// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  BFs7ll_BFu7i_BFu7c  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7c) C1{ FL:7 Fi:7 Fc:7}



static void Test_BFs7ll_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7c, BFs7ll_BFu7i_BFu7c)
//============================================================================


struct  BFs7ll_BFu7i_BFu7c_BFs7c  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7c_BFs7c) C1{ FL:7 Fi:7 Fc:7 Fc:7}



static void Test_BFs7ll_BFu7i_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7c_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7c_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7c_BFs7c, BFs7ll_BFu7i_BFu7c_BFs7c)
//============================================================================


struct  BFs7ll_BFu7i_BFu7c_BFs7i  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7c_BFs7i) C1{ FL:7 Fi:7 Fc:7 Fi:7}



static void Test_BFs7ll_BFu7i_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7c_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7c_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7c_BFs7i, BFs7ll_BFu7i_BFu7c_BFs7i)
//============================================================================


struct  BFs7ll_BFu7i_BFu7c_BFs7ll  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7c_BFs7ll) C1{ FL:7 Fi:7 Fc:7 FL:7}



static void Test_BFs7ll_BFu7i_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7c_BFs7ll, BFs7ll_BFu7i_BFu7c_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7i_BFu7c_BFs7s  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7c_BFs7s) C1{ FL:7 Fi:7 Fc:7 Fs:7}



static void Test_BFs7ll_BFu7i_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7c_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7c_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7c_BFs7s, BFs7ll_BFu7i_BFu7c_BFs7s)
//============================================================================


struct  BFs7ll_BFu7i_BFu7c_BFu7c  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7c_BFu7c) C1{ FL:7 Fi:7 Fc:7 Fc:7}



static void Test_BFs7ll_BFu7i_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7c_BFu7c, BFs7ll_BFu7i_BFu7c_BFu7c)
//============================================================================


struct  BFs7ll_BFu7i_BFu7c_BFu7i  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7c_BFu7i) C1{ FL:7 Fi:7 Fc:7 Fi:7}



static void Test_BFs7ll_BFu7i_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7c_BFu7i, BFs7ll_BFu7i_BFu7c_BFu7i)
//============================================================================


struct  BFs7ll_BFu7i_BFu7c_BFu7ll  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7c_BFu7ll) C1{ FL:7 Fi:7 Fc:7 FL:7}



static void Test_BFs7ll_BFu7i_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7c_BFu7ll, BFs7ll_BFu7i_BFu7c_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7i_BFu7c_BFu7s  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7c_BFu7s) C1{ FL:7 Fi:7 Fc:7 Fs:7}



static void Test_BFs7ll_BFu7i_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7c_BFu7s, BFs7ll_BFu7i_BFu7c_BFu7s)
//============================================================================


struct  BFs7ll_BFu7i_BFu7i  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7i) C1{ FL:7 Fi:7 Fi:7}



static void Test_BFs7ll_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7i, BFs7ll_BFu7i_BFu7i)
//============================================================================


struct  BFs7ll_BFu7i_BFu7i_BFs7c  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7i_BFs7c) C1{ FL:7 Fi:7 Fi:7 Fc:7}



static void Test_BFs7ll_BFu7i_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7i_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7i_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7i_BFs7c, BFs7ll_BFu7i_BFu7i_BFs7c)
//============================================================================


struct  BFs7ll_BFu7i_BFu7i_BFs7i  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7i_BFs7i) C1{ FL:7 Fi:7 Fi:7 Fi:7}



static void Test_BFs7ll_BFu7i_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7i_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7i_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7i_BFs7i, BFs7ll_BFu7i_BFu7i_BFs7i)
//============================================================================


struct  BFs7ll_BFu7i_BFu7i_BFs7ll  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7i_BFs7ll) C1{ FL:7 Fi:7 Fi:7 FL:7}



static void Test_BFs7ll_BFu7i_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7i_BFs7ll, BFs7ll_BFu7i_BFu7i_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7i_BFu7i_BFs7s  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7i_BFs7s) C1{ FL:7 Fi:7 Fi:7 Fs:7}



static void Test_BFs7ll_BFu7i_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7i_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7i_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7i_BFs7s, BFs7ll_BFu7i_BFu7i_BFs7s)
//============================================================================


struct  BFs7ll_BFu7i_BFu7i_BFu7c  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7i_BFu7c) C1{ FL:7 Fi:7 Fi:7 Fc:7}



static void Test_BFs7ll_BFu7i_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7i_BFu7c, BFs7ll_BFu7i_BFu7i_BFu7c)
//============================================================================


struct  BFs7ll_BFu7i_BFu7i_BFu7i  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7i_BFu7i) C1{ FL:7 Fi:7 Fi:7 Fi:7}



static void Test_BFs7ll_BFu7i_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7i_BFu7i, BFs7ll_BFu7i_BFu7i_BFu7i)
//============================================================================


struct  BFs7ll_BFu7i_BFu7i_BFu7ll  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7i_BFu7ll) C1{ FL:7 Fi:7 Fi:7 FL:7}



static void Test_BFs7ll_BFu7i_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7i_BFu7ll, BFs7ll_BFu7i_BFu7i_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7i_BFu7i_BFu7s  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7i_BFu7s) C1{ FL:7 Fi:7 Fi:7 Fs:7}



static void Test_BFs7ll_BFu7i_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7i_BFu7s, BFs7ll_BFu7i_BFu7i_BFu7s)
//============================================================================


struct  BFs7ll_BFu7i_BFu7ll  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7ll) C1{ FL:7 Fi:7 FL:7}



static void Test_BFs7ll_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7ll, BFs7ll_BFu7i_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7i_BFu7ll_BFs7c  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7ll_BFs7c) C1{ FL:7 Fi:7 FL:7 Fc:7}



static void Test_BFs7ll_BFu7i_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7ll_BFs7c, BFs7ll_BFu7i_BFu7ll_BFs7c)
//============================================================================


struct  BFs7ll_BFu7i_BFu7ll_BFs7i  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7ll_BFs7i) C1{ FL:7 Fi:7 FL:7 Fi:7}



static void Test_BFs7ll_BFu7i_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7ll_BFs7i, BFs7ll_BFu7i_BFu7ll_BFs7i)
//============================================================================


struct  BFs7ll_BFu7i_BFu7ll_BFs7ll  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7ll_BFs7ll) C1{ FL:7 Fi:7 FL:7 FL:7}



static void Test_BFs7ll_BFu7i_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7ll_BFs7ll, BFs7ll_BFu7i_BFu7ll_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7i_BFu7ll_BFs7s  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7ll_BFs7s) C1{ FL:7 Fi:7 FL:7 Fs:7}



static void Test_BFs7ll_BFu7i_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7ll_BFs7s, BFs7ll_BFu7i_BFu7ll_BFs7s)
//============================================================================


struct  BFs7ll_BFu7i_BFu7ll_BFu7c  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7ll_BFu7c) C1{ FL:7 Fi:7 FL:7 Fc:7}



static void Test_BFs7ll_BFu7i_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7ll_BFu7c, BFs7ll_BFu7i_BFu7ll_BFu7c)
//============================================================================


struct  BFs7ll_BFu7i_BFu7ll_BFu7i  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7ll_BFu7i) C1{ FL:7 Fi:7 FL:7 Fi:7}



static void Test_BFs7ll_BFu7i_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7ll_BFu7i, BFs7ll_BFu7i_BFu7ll_BFu7i)
//============================================================================


struct  BFs7ll_BFu7i_BFu7ll_BFu7ll  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7ll_BFu7ll) C1{ FL:7 Fi:7 FL:7 FL:7}



static void Test_BFs7ll_BFu7i_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7ll_BFu7ll, BFs7ll_BFu7i_BFu7ll_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7i_BFu7ll_BFu7s  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7ll_BFu7s) C1{ FL:7 Fi:7 FL:7 Fs:7}



static void Test_BFs7ll_BFu7i_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7ll_BFu7s, BFs7ll_BFu7i_BFu7ll_BFu7s)
//============================================================================


struct  BFs7ll_BFu7i_BFu7s  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7s) C1{ FL:7 Fi:7 Fs:7}



static void Test_BFs7ll_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7s, BFs7ll_BFu7i_BFu7s)
//============================================================================


struct  BFs7ll_BFu7i_BFu7s_BFs7c  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7s_BFs7c) C1{ FL:7 Fi:7 Fs:7 Fc:7}



static void Test_BFs7ll_BFu7i_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7s_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7s_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7s_BFs7c, BFs7ll_BFu7i_BFu7s_BFs7c)
//============================================================================


struct  BFs7ll_BFu7i_BFu7s_BFs7i  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7s_BFs7i) C1{ FL:7 Fi:7 Fs:7 Fi:7}



static void Test_BFs7ll_BFu7i_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7s_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7s_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7s_BFs7i, BFs7ll_BFu7i_BFu7s_BFs7i)
//============================================================================


struct  BFs7ll_BFu7i_BFu7s_BFs7ll  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7s_BFs7ll) C1{ FL:7 Fi:7 Fs:7 FL:7}



static void Test_BFs7ll_BFu7i_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7s_BFs7ll, BFs7ll_BFu7i_BFu7s_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7i_BFu7s_BFs7s  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7s_BFs7s) C1{ FL:7 Fi:7 Fs:7 Fs:7}



static void Test_BFs7ll_BFu7i_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7s_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7s_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7s_BFs7s, BFs7ll_BFu7i_BFu7s_BFs7s)
//============================================================================


struct  BFs7ll_BFu7i_BFu7s_BFu7c  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7s_BFu7c) C1{ FL:7 Fi:7 Fs:7 Fc:7}



static void Test_BFs7ll_BFu7i_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7s_BFu7c, BFs7ll_BFu7i_BFu7s_BFu7c)
//============================================================================


struct  BFs7ll_BFu7i_BFu7s_BFu7i  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7s_BFu7i) C1{ FL:7 Fi:7 Fs:7 Fi:7}



static void Test_BFs7ll_BFu7i_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7s_BFu7i, BFs7ll_BFu7i_BFu7s_BFu7i)
//============================================================================


struct  BFs7ll_BFu7i_BFu7s_BFu7ll  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7s_BFu7ll) C1{ FL:7 Fi:7 Fs:7 FL:7}



static void Test_BFs7ll_BFu7i_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7s_BFu7ll, BFs7ll_BFu7i_BFu7s_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7i_BFu7s_BFu7s  {
  signed __tsi64 v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7i_BFu7s_BFu7s) C1{ FL:7 Fi:7 Fs:7 Fs:7}



static void Test_BFs7ll_BFu7i_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7i_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7i_BFu7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7i_BFu7s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7i_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7i_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7i_BFu7s_BFu7s, BFs7ll_BFu7i_BFu7s_BFu7s)
//============================================================================


struct  BFs7ll_BFu7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
};
//SIG(1 BFs7ll_BFu7ll) C1{ FL:7 FL:7}



static void Test_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll, BFs7ll_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed char v3:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7c) C1{ FL:7 FL:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7c, BFs7ll_BFu7ll_BFs7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7c_BFs7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7c_BFs7c) C1{ FL:7 FL:7 Fc:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7c_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7c_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7c_BFs7c, BFs7ll_BFu7ll_BFs7c_BFs7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7c_BFs7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7c_BFs7i) C1{ FL:7 FL:7 Fc:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7c_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7c_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7c_BFs7i, BFs7ll_BFu7ll_BFs7c_BFs7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7c_BFs7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7c_BFs7ll) C1{ FL:7 FL:7 Fc:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7c_BFs7ll, BFs7ll_BFu7ll_BFs7c_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7c_BFs7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7c_BFs7s) C1{ FL:7 FL:7 Fc:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7c_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7c_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7c_BFs7s, BFs7ll_BFu7ll_BFs7c_BFs7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7c_BFu7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7c_BFu7c) C1{ FL:7 FL:7 Fc:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7c_BFu7c, BFs7ll_BFu7ll_BFs7c_BFu7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7c_BFu7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7c_BFu7i) C1{ FL:7 FL:7 Fc:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7c_BFu7i, BFs7ll_BFu7ll_BFs7c_BFu7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7c_BFu7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7c_BFu7ll) C1{ FL:7 FL:7 Fc:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7c_BFu7ll, BFs7ll_BFu7ll_BFs7c_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7c_BFu7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7c_BFu7s) C1{ FL:7 FL:7 Fc:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7c_BFu7s, BFs7ll_BFu7ll_BFs7c_BFu7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed int v3:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7i) C1{ FL:7 FL:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7i, BFs7ll_BFu7ll_BFs7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7i_BFs7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7i_BFs7c) C1{ FL:7 FL:7 Fi:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7i_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7i_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7i_BFs7c, BFs7ll_BFu7ll_BFs7i_BFs7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7i_BFs7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7i_BFs7i) C1{ FL:7 FL:7 Fi:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7i_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7i_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7i_BFs7i, BFs7ll_BFu7ll_BFs7i_BFs7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7i_BFs7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7i_BFs7ll) C1{ FL:7 FL:7 Fi:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7i_BFs7ll, BFs7ll_BFu7ll_BFs7i_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7i_BFs7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7i_BFs7s) C1{ FL:7 FL:7 Fi:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7i_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7i_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7i_BFs7s, BFs7ll_BFu7ll_BFs7i_BFs7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7i_BFu7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7i_BFu7c) C1{ FL:7 FL:7 Fi:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7i_BFu7c, BFs7ll_BFu7ll_BFs7i_BFu7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7i_BFu7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7i_BFu7i) C1{ FL:7 FL:7 Fi:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7i_BFu7i, BFs7ll_BFu7ll_BFs7i_BFu7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7i_BFu7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7i_BFu7ll) C1{ FL:7 FL:7 Fi:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7i_BFu7ll, BFs7ll_BFu7ll_BFs7i_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7i_BFu7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7i_BFu7s) C1{ FL:7 FL:7 Fi:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7i_BFu7s, BFs7ll_BFu7ll_BFs7i_BFu7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7ll) C1{ FL:7 FL:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7ll, BFs7ll_BFu7ll_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7ll_BFs7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7ll_BFs7c) C1{ FL:7 FL:7 FL:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7ll_BFs7c, BFs7ll_BFu7ll_BFs7ll_BFs7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7ll_BFs7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7ll_BFs7i) C1{ FL:7 FL:7 FL:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7ll_BFs7i, BFs7ll_BFu7ll_BFs7ll_BFs7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7ll_BFs7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7ll_BFs7ll) C1{ FL:7 FL:7 FL:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7ll_BFs7ll, BFs7ll_BFu7ll_BFs7ll_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7ll_BFs7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7ll_BFs7s) C1{ FL:7 FL:7 FL:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7ll_BFs7s, BFs7ll_BFu7ll_BFs7ll_BFs7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7ll_BFu7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7ll_BFu7c) C1{ FL:7 FL:7 FL:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7ll_BFu7c, BFs7ll_BFu7ll_BFs7ll_BFu7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7ll_BFu7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7ll_BFu7i) C1{ FL:7 FL:7 FL:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7ll_BFu7i, BFs7ll_BFu7ll_BFs7ll_BFu7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7ll_BFu7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7ll_BFu7ll) C1{ FL:7 FL:7 FL:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7ll_BFu7ll, BFs7ll_BFu7ll_BFs7ll_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7ll_BFu7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7ll_BFu7s) C1{ FL:7 FL:7 FL:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7ll_BFu7s, BFs7ll_BFu7ll_BFs7ll_BFu7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed short v3:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7s) C1{ FL:7 FL:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7s, BFs7ll_BFu7ll_BFs7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7s_BFs7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7s_BFs7c) C1{ FL:7 FL:7 Fs:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7s_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7s_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7s_BFs7c, BFs7ll_BFu7ll_BFs7s_BFs7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7s_BFs7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7s_BFs7i) C1{ FL:7 FL:7 Fs:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7s_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7s_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7s_BFs7i, BFs7ll_BFu7ll_BFs7s_BFs7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7s_BFs7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7s_BFs7ll) C1{ FL:7 FL:7 Fs:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7s_BFs7ll, BFs7ll_BFu7ll_BFs7s_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7s_BFs7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7s_BFs7s) C1{ FL:7 FL:7 Fs:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7s_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7s_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7s_BFs7s, BFs7ll_BFu7ll_BFs7s_BFs7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7s_BFu7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7s_BFu7c) C1{ FL:7 FL:7 Fs:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7s_BFu7c, BFs7ll_BFu7ll_BFs7s_BFu7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7s_BFu7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7s_BFu7i) C1{ FL:7 FL:7 Fs:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7s_BFu7i, BFs7ll_BFu7ll_BFs7s_BFu7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7s_BFu7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7s_BFu7ll) C1{ FL:7 FL:7 Fs:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7s_BFu7ll, BFs7ll_BFu7ll_BFs7s_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFs7s_BFu7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFs7s_BFu7s) C1{ FL:7 FL:7 Fs:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFs7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFs7s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFs7s_BFu7s, BFs7ll_BFu7ll_BFs7s_BFu7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7c) C1{ FL:7 FL:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7c, BFs7ll_BFu7ll_BFu7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7c_BFs7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7c_BFs7c) C1{ FL:7 FL:7 Fc:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7c_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7c_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7c_BFs7c, BFs7ll_BFu7ll_BFu7c_BFs7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7c_BFs7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7c_BFs7i) C1{ FL:7 FL:7 Fc:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7c_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7c_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7c_BFs7i, BFs7ll_BFu7ll_BFu7c_BFs7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7c_BFs7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7c_BFs7ll) C1{ FL:7 FL:7 Fc:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7c_BFs7ll, BFs7ll_BFu7ll_BFu7c_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7c_BFs7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7c_BFs7s) C1{ FL:7 FL:7 Fc:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7c_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7c_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7c_BFs7s, BFs7ll_BFu7ll_BFu7c_BFs7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7c_BFu7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7c_BFu7c) C1{ FL:7 FL:7 Fc:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7c_BFu7c, BFs7ll_BFu7ll_BFu7c_BFu7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7c_BFu7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7c_BFu7i) C1{ FL:7 FL:7 Fc:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7c_BFu7i, BFs7ll_BFu7ll_BFu7c_BFu7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7c_BFu7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7c_BFu7ll) C1{ FL:7 FL:7 Fc:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7c_BFu7ll, BFs7ll_BFu7ll_BFu7c_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7c_BFu7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7c_BFu7s) C1{ FL:7 FL:7 Fc:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7c_BFu7s, BFs7ll_BFu7ll_BFu7c_BFu7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7i) C1{ FL:7 FL:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7i, BFs7ll_BFu7ll_BFu7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7i_BFs7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7i_BFs7c) C1{ FL:7 FL:7 Fi:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7i_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7i_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7i_BFs7c, BFs7ll_BFu7ll_BFu7i_BFs7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7i_BFs7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7i_BFs7i) C1{ FL:7 FL:7 Fi:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7i_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7i_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7i_BFs7i, BFs7ll_BFu7ll_BFu7i_BFs7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7i_BFs7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7i_BFs7ll) C1{ FL:7 FL:7 Fi:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7i_BFs7ll, BFs7ll_BFu7ll_BFu7i_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7i_BFs7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7i_BFs7s) C1{ FL:7 FL:7 Fi:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7i_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7i_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7i_BFs7s, BFs7ll_BFu7ll_BFu7i_BFs7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7i_BFu7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7i_BFu7c) C1{ FL:7 FL:7 Fi:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7i_BFu7c, BFs7ll_BFu7ll_BFu7i_BFu7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7i_BFu7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7i_BFu7i) C1{ FL:7 FL:7 Fi:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7i_BFu7i, BFs7ll_BFu7ll_BFu7i_BFu7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7i_BFu7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7i_BFu7ll) C1{ FL:7 FL:7 Fi:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7i_BFu7ll, BFs7ll_BFu7ll_BFu7i_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7i_BFu7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7i_BFu7s) C1{ FL:7 FL:7 Fi:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7i_BFu7s, BFs7ll_BFu7ll_BFu7i_BFu7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7ll) C1{ FL:7 FL:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7ll, BFs7ll_BFu7ll_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7ll_BFs7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7ll_BFs7c) C1{ FL:7 FL:7 FL:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7ll_BFs7c, BFs7ll_BFu7ll_BFu7ll_BFs7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7ll_BFs7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7ll_BFs7i) C1{ FL:7 FL:7 FL:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7ll_BFs7i, BFs7ll_BFu7ll_BFu7ll_BFs7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7ll_BFs7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7ll_BFs7ll) C1{ FL:7 FL:7 FL:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7ll_BFs7ll, BFs7ll_BFu7ll_BFu7ll_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7ll_BFs7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7ll_BFs7s) C1{ FL:7 FL:7 FL:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7ll_BFs7s, BFs7ll_BFu7ll_BFu7ll_BFs7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7ll_BFu7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7ll_BFu7c) C1{ FL:7 FL:7 FL:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7ll_BFu7c, BFs7ll_BFu7ll_BFu7ll_BFu7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7ll_BFu7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7ll_BFu7i) C1{ FL:7 FL:7 FL:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7ll_BFu7i, BFs7ll_BFu7ll_BFu7ll_BFu7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7ll_BFu7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7ll_BFu7ll) C1{ FL:7 FL:7 FL:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7ll_BFu7ll, BFs7ll_BFu7ll_BFu7ll_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7ll_BFu7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7ll_BFu7s) C1{ FL:7 FL:7 FL:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7ll_BFu7s, BFs7ll_BFu7ll_BFu7ll_BFu7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7s) C1{ FL:7 FL:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7s, BFs7ll_BFu7ll_BFu7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7s_BFs7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7s_BFs7c) C1{ FL:7 FL:7 Fs:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7s_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7s_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7s_BFs7c, BFs7ll_BFu7ll_BFu7s_BFs7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7s_BFs7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7s_BFs7i) C1{ FL:7 FL:7 Fs:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7s_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7s_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7s_BFs7i, BFs7ll_BFu7ll_BFu7s_BFs7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7s_BFs7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7s_BFs7ll) C1{ FL:7 FL:7 Fs:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7s_BFs7ll, BFs7ll_BFu7ll_BFu7s_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7s_BFs7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7s_BFs7s) C1{ FL:7 FL:7 Fs:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7s_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7s_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7s_BFs7s, BFs7ll_BFu7ll_BFu7s_BFs7s)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7s_BFu7c  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7s_BFu7c) C1{ FL:7 FL:7 Fs:7 Fc:7}



static void Test_BFs7ll_BFu7ll_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7s_BFu7c, BFs7ll_BFu7ll_BFu7s_BFu7c)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7s_BFu7i  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7s_BFu7i) C1{ FL:7 FL:7 Fs:7 Fi:7}



static void Test_BFs7ll_BFu7ll_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7s_BFu7i, BFs7ll_BFu7ll_BFu7s_BFu7i)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7s_BFu7ll  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7s_BFu7ll) C1{ FL:7 FL:7 Fs:7 FL:7}



static void Test_BFs7ll_BFu7ll_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7s_BFu7ll, BFs7ll_BFu7ll_BFu7s_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7ll_BFu7s_BFu7s  {
  signed __tsi64 v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7ll_BFu7s_BFu7s) C1{ FL:7 FL:7 Fs:7 Fs:7}



static void Test_BFs7ll_BFu7ll_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7ll_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7ll_BFu7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7ll_BFu7s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7ll_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7ll_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7ll_BFu7s_BFu7s, BFs7ll_BFu7ll_BFu7s_BFu7s)
//============================================================================


struct  BFs7ll_BFu7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
};
//SIG(1 BFs7ll_BFu7s) C1{ FL:7 Fs:7}



static void Test_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s, BFs7ll_BFu7s)
//============================================================================


struct  BFs7ll_BFu7s_BFs7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed char v3:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7c) C1{ FL:7 Fs:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7c, BFs7ll_BFu7s_BFs7c)
//============================================================================


struct  BFs7ll_BFu7s_BFs7c_BFs7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7c_BFs7c) C1{ FL:7 Fs:7 Fc:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7c_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7c_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7c_BFs7c, BFs7ll_BFu7s_BFs7c_BFs7c)
//============================================================================


struct  BFs7ll_BFu7s_BFs7c_BFs7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7c_BFs7i) C1{ FL:7 Fs:7 Fc:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7c_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7c_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7c_BFs7i, BFs7ll_BFu7s_BFs7c_BFs7i)
//============================================================================


struct  BFs7ll_BFu7s_BFs7c_BFs7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7c_BFs7ll) C1{ FL:7 Fs:7 Fc:7 FL:7}



static void Test_BFs7ll_BFu7s_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7c_BFs7ll, BFs7ll_BFu7s_BFs7c_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFs7c_BFs7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7c_BFs7s) C1{ FL:7 Fs:7 Fc:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7c_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7c_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7c_BFs7s, BFs7ll_BFu7s_BFs7c_BFs7s)
//============================================================================


struct  BFs7ll_BFu7s_BFs7c_BFu7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7c_BFu7c) C1{ FL:7 Fs:7 Fc:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7c_BFu7c, BFs7ll_BFu7s_BFs7c_BFu7c)
//============================================================================


struct  BFs7ll_BFu7s_BFs7c_BFu7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7c_BFu7i) C1{ FL:7 Fs:7 Fc:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7c_BFu7i, BFs7ll_BFu7s_BFs7c_BFu7i)
//============================================================================


struct  BFs7ll_BFu7s_BFs7c_BFu7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7c_BFu7ll) C1{ FL:7 Fs:7 Fc:7 FL:7}



static void Test_BFs7ll_BFu7s_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7c_BFu7ll, BFs7ll_BFu7s_BFs7c_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFs7c_BFu7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7c_BFu7s) C1{ FL:7 Fs:7 Fc:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7c_BFu7s, BFs7ll_BFu7s_BFs7c_BFu7s)
//============================================================================


struct  BFs7ll_BFu7s_BFs7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed int v3:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7i) C1{ FL:7 Fs:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7i, BFs7ll_BFu7s_BFs7i)
//============================================================================


struct  BFs7ll_BFu7s_BFs7i_BFs7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7i_BFs7c) C1{ FL:7 Fs:7 Fi:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7i_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7i_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7i_BFs7c, BFs7ll_BFu7s_BFs7i_BFs7c)
//============================================================================


struct  BFs7ll_BFu7s_BFs7i_BFs7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7i_BFs7i) C1{ FL:7 Fs:7 Fi:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7i_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7i_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7i_BFs7i, BFs7ll_BFu7s_BFs7i_BFs7i)
//============================================================================


struct  BFs7ll_BFu7s_BFs7i_BFs7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7i_BFs7ll) C1{ FL:7 Fs:7 Fi:7 FL:7}



static void Test_BFs7ll_BFu7s_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7i_BFs7ll, BFs7ll_BFu7s_BFs7i_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFs7i_BFs7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7i_BFs7s) C1{ FL:7 Fs:7 Fi:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7i_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7i_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7i_BFs7s, BFs7ll_BFu7s_BFs7i_BFs7s)
//============================================================================


struct  BFs7ll_BFu7s_BFs7i_BFu7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7i_BFu7c) C1{ FL:7 Fs:7 Fi:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7i_BFu7c, BFs7ll_BFu7s_BFs7i_BFu7c)
//============================================================================


struct  BFs7ll_BFu7s_BFs7i_BFu7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7i_BFu7i) C1{ FL:7 Fs:7 Fi:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7i_BFu7i, BFs7ll_BFu7s_BFs7i_BFu7i)
//============================================================================


struct  BFs7ll_BFu7s_BFs7i_BFu7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7i_BFu7ll) C1{ FL:7 Fs:7 Fi:7 FL:7}



static void Test_BFs7ll_BFu7s_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7i_BFu7ll, BFs7ll_BFu7s_BFs7i_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFs7i_BFu7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7i_BFu7s) C1{ FL:7 Fs:7 Fi:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7i_BFu7s, BFs7ll_BFu7s_BFs7i_BFu7s)
//============================================================================


struct  BFs7ll_BFu7s_BFs7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7ll) C1{ FL:7 Fs:7 FL:7}



static void Test_BFs7ll_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7ll, BFs7ll_BFu7s_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFs7ll_BFs7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7ll_BFs7c) C1{ FL:7 Fs:7 FL:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7ll_BFs7c, BFs7ll_BFu7s_BFs7ll_BFs7c)
//============================================================================


struct  BFs7ll_BFu7s_BFs7ll_BFs7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7ll_BFs7i) C1{ FL:7 Fs:7 FL:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7ll_BFs7i, BFs7ll_BFu7s_BFs7ll_BFs7i)
//============================================================================


struct  BFs7ll_BFu7s_BFs7ll_BFs7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7ll_BFs7ll) C1{ FL:7 Fs:7 FL:7 FL:7}



static void Test_BFs7ll_BFu7s_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7ll_BFs7ll, BFs7ll_BFu7s_BFs7ll_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFs7ll_BFs7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7ll_BFs7s) C1{ FL:7 Fs:7 FL:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7ll_BFs7s, BFs7ll_BFu7s_BFs7ll_BFs7s)
//============================================================================


struct  BFs7ll_BFu7s_BFs7ll_BFu7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7ll_BFu7c) C1{ FL:7 Fs:7 FL:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7ll_BFu7c, BFs7ll_BFu7s_BFs7ll_BFu7c)
//============================================================================


struct  BFs7ll_BFu7s_BFs7ll_BFu7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7ll_BFu7i) C1{ FL:7 Fs:7 FL:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7ll_BFu7i, BFs7ll_BFu7s_BFs7ll_BFu7i)
//============================================================================


struct  BFs7ll_BFu7s_BFs7ll_BFu7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7ll_BFu7ll) C1{ FL:7 Fs:7 FL:7 FL:7}



static void Test_BFs7ll_BFu7s_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7ll_BFu7ll, BFs7ll_BFu7s_BFs7ll_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFs7ll_BFu7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7ll_BFu7s) C1{ FL:7 Fs:7 FL:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7ll_BFu7s, BFs7ll_BFu7s_BFs7ll_BFu7s)
//============================================================================


struct  BFs7ll_BFu7s_BFs7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed short v3:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7s) C1{ FL:7 Fs:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7s, BFs7ll_BFu7s_BFs7s)
//============================================================================


struct  BFs7ll_BFu7s_BFs7s_BFs7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7s_BFs7c) C1{ FL:7 Fs:7 Fs:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7s_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7s_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7s_BFs7c, BFs7ll_BFu7s_BFs7s_BFs7c)
//============================================================================


struct  BFs7ll_BFu7s_BFs7s_BFs7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7s_BFs7i) C1{ FL:7 Fs:7 Fs:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7s_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7s_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7s_BFs7i, BFs7ll_BFu7s_BFs7s_BFs7i)
//============================================================================


struct  BFs7ll_BFu7s_BFs7s_BFs7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7s_BFs7ll) C1{ FL:7 Fs:7 Fs:7 FL:7}



static void Test_BFs7ll_BFu7s_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7s_BFs7ll, BFs7ll_BFu7s_BFs7s_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFs7s_BFs7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7s_BFs7s) C1{ FL:7 Fs:7 Fs:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7s_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7s_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7s_BFs7s, BFs7ll_BFu7s_BFs7s_BFs7s)
//============================================================================


struct  BFs7ll_BFu7s_BFs7s_BFu7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7s_BFu7c) C1{ FL:7 Fs:7 Fs:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7s_BFu7c, BFs7ll_BFu7s_BFs7s_BFu7c)
//============================================================================


struct  BFs7ll_BFu7s_BFs7s_BFu7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7s_BFu7i) C1{ FL:7 Fs:7 Fs:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7s_BFu7i, BFs7ll_BFu7s_BFs7s_BFu7i)
//============================================================================


struct  BFs7ll_BFu7s_BFs7s_BFu7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7s_BFu7ll) C1{ FL:7 Fs:7 Fs:7 FL:7}



static void Test_BFs7ll_BFu7s_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7s_BFu7ll, BFs7ll_BFu7s_BFs7s_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFs7s_BFu7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  signed short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFs7s_BFu7s) C1{ FL:7 Fs:7 Fs:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFs7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFs7s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFs7s_BFu7s, BFs7ll_BFu7s_BFs7s_BFu7s)
//============================================================================


struct  BFs7ll_BFu7s_BFu7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7c) C1{ FL:7 Fs:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7c, BFs7ll_BFu7s_BFu7c)
//============================================================================


struct  BFs7ll_BFu7s_BFu7c_BFs7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7c_BFs7c) C1{ FL:7 Fs:7 Fc:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7c_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7c_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7c_BFs7c, BFs7ll_BFu7s_BFu7c_BFs7c)
//============================================================================


struct  BFs7ll_BFu7s_BFu7c_BFs7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7c_BFs7i) C1{ FL:7 Fs:7 Fc:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7c_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7c_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7c_BFs7i, BFs7ll_BFu7s_BFu7c_BFs7i)
//============================================================================


struct  BFs7ll_BFu7s_BFu7c_BFs7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7c_BFs7ll) C1{ FL:7 Fs:7 Fc:7 FL:7}



static void Test_BFs7ll_BFu7s_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7c_BFs7ll, BFs7ll_BFu7s_BFu7c_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFu7c_BFs7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7c_BFs7s) C1{ FL:7 Fs:7 Fc:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7c_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7c_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7c_BFs7s, BFs7ll_BFu7s_BFu7c_BFs7s)
//============================================================================


struct  BFs7ll_BFu7s_BFu7c_BFu7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7c_BFu7c) C1{ FL:7 Fs:7 Fc:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7c_BFu7c, BFs7ll_BFu7s_BFu7c_BFu7c)
//============================================================================


struct  BFs7ll_BFu7s_BFu7c_BFu7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7c_BFu7i) C1{ FL:7 Fs:7 Fc:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7c_BFu7i, BFs7ll_BFu7s_BFu7c_BFu7i)
//============================================================================


struct  BFs7ll_BFu7s_BFu7c_BFu7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7c_BFu7ll) C1{ FL:7 Fs:7 Fc:7 FL:7}



static void Test_BFs7ll_BFu7s_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7c_BFu7ll, BFs7ll_BFu7s_BFu7c_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFu7c_BFu7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7c_BFu7s) C1{ FL:7 Fs:7 Fc:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7c_BFu7s, BFs7ll_BFu7s_BFu7c_BFu7s)
//============================================================================


struct  BFs7ll_BFu7s_BFu7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7i) C1{ FL:7 Fs:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7i, BFs7ll_BFu7s_BFu7i)
//============================================================================


struct  BFs7ll_BFu7s_BFu7i_BFs7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7i_BFs7c) C1{ FL:7 Fs:7 Fi:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7i_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7i_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7i_BFs7c, BFs7ll_BFu7s_BFu7i_BFs7c)
//============================================================================


struct  BFs7ll_BFu7s_BFu7i_BFs7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7i_BFs7i) C1{ FL:7 Fs:7 Fi:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7i_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7i_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7i_BFs7i, BFs7ll_BFu7s_BFu7i_BFs7i)
//============================================================================


struct  BFs7ll_BFu7s_BFu7i_BFs7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7i_BFs7ll) C1{ FL:7 Fs:7 Fi:7 FL:7}



static void Test_BFs7ll_BFu7s_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7i_BFs7ll, BFs7ll_BFu7s_BFu7i_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFu7i_BFs7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7i_BFs7s) C1{ FL:7 Fs:7 Fi:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7i_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7i_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7i_BFs7s, BFs7ll_BFu7s_BFu7i_BFs7s)
//============================================================================


struct  BFs7ll_BFu7s_BFu7i_BFu7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7i_BFu7c) C1{ FL:7 Fs:7 Fi:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7i_BFu7c, BFs7ll_BFu7s_BFu7i_BFu7c)
//============================================================================


struct  BFs7ll_BFu7s_BFu7i_BFu7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7i_BFu7i) C1{ FL:7 Fs:7 Fi:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7i_BFu7i, BFs7ll_BFu7s_BFu7i_BFu7i)
//============================================================================


struct  BFs7ll_BFu7s_BFu7i_BFu7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7i_BFu7ll) C1{ FL:7 Fs:7 Fi:7 FL:7}



static void Test_BFs7ll_BFu7s_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7i_BFu7ll, BFs7ll_BFu7s_BFu7i_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFu7i_BFu7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7i_BFu7s) C1{ FL:7 Fs:7 Fi:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7i_BFu7s, BFs7ll_BFu7s_BFu7i_BFu7s)
//============================================================================


struct  BFs7ll_BFu7s_BFu7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7ll) C1{ FL:7 Fs:7 FL:7}



static void Test_BFs7ll_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7ll, BFs7ll_BFu7s_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFu7ll_BFs7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7ll_BFs7c) C1{ FL:7 Fs:7 FL:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7ll_BFs7c, BFs7ll_BFu7s_BFu7ll_BFs7c)
//============================================================================


struct  BFs7ll_BFu7s_BFu7ll_BFs7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7ll_BFs7i) C1{ FL:7 Fs:7 FL:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7ll_BFs7i, BFs7ll_BFu7s_BFu7ll_BFs7i)
//============================================================================


struct  BFs7ll_BFu7s_BFu7ll_BFs7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7ll_BFs7ll) C1{ FL:7 Fs:7 FL:7 FL:7}



static void Test_BFs7ll_BFu7s_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7ll_BFs7ll, BFs7ll_BFu7s_BFu7ll_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFu7ll_BFs7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7ll_BFs7s) C1{ FL:7 Fs:7 FL:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7ll_BFs7s, BFs7ll_BFu7s_BFu7ll_BFs7s)
//============================================================================


struct  BFs7ll_BFu7s_BFu7ll_BFu7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7ll_BFu7c) C1{ FL:7 Fs:7 FL:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7ll_BFu7c, BFs7ll_BFu7s_BFu7ll_BFu7c)
//============================================================================


struct  BFs7ll_BFu7s_BFu7ll_BFu7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7ll_BFu7i) C1{ FL:7 Fs:7 FL:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7ll_BFu7i, BFs7ll_BFu7s_BFu7ll_BFu7i)
//============================================================================


struct  BFs7ll_BFu7s_BFu7ll_BFu7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7ll_BFu7ll) C1{ FL:7 Fs:7 FL:7 FL:7}



static void Test_BFs7ll_BFu7s_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7ll_BFu7ll, BFs7ll_BFu7s_BFu7ll_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFu7ll_BFu7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7ll_BFu7s) C1{ FL:7 Fs:7 FL:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7ll_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7ll_BFu7s, BFs7ll_BFu7s_BFu7ll_BFu7s)
//============================================================================


struct  BFs7ll_BFu7s_BFu7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7s) C1{ FL:7 Fs:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7s, BFs7ll_BFu7s_BFu7s)
//============================================================================


struct  BFs7ll_BFu7s_BFu7s_BFs7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7s_BFs7c) C1{ FL:7 Fs:7 Fs:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7s_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7s_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7s_BFs7c, BFs7ll_BFu7s_BFu7s_BFs7c)
//============================================================================


struct  BFs7ll_BFu7s_BFu7s_BFs7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7s_BFs7i) C1{ FL:7 Fs:7 Fs:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7s_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7s_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7s_BFs7i, BFs7ll_BFu7s_BFu7s_BFs7i)
//============================================================================


struct  BFs7ll_BFu7s_BFu7s_BFs7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7s_BFs7ll) C1{ FL:7 Fs:7 Fs:7 FL:7}



static void Test_BFs7ll_BFu7s_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7s_BFs7ll, BFs7ll_BFu7s_BFu7s_BFs7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFu7s_BFs7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7s_BFs7s) C1{ FL:7 Fs:7 Fs:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7s_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7s_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7s_BFs7s, BFs7ll_BFu7s_BFu7s_BFs7s)
//============================================================================


struct  BFs7ll_BFu7s_BFu7s_BFu7c  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7s_BFu7c) C1{ FL:7 Fs:7 Fs:7 Fc:7}



static void Test_BFs7ll_BFu7s_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7s_BFu7c, BFs7ll_BFu7s_BFu7s_BFu7c)
//============================================================================


struct  BFs7ll_BFu7s_BFu7s_BFu7i  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7s_BFu7i) C1{ FL:7 Fs:7 Fs:7 Fi:7}



static void Test_BFs7ll_BFu7s_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7s_BFu7i, BFs7ll_BFu7s_BFu7s_BFu7i)
//============================================================================


struct  BFs7ll_BFu7s_BFu7s_BFu7ll  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7s_BFu7ll) C1{ FL:7 Fs:7 Fs:7 FL:7}



static void Test_BFs7ll_BFu7s_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7s_BFu7ll, BFs7ll_BFu7s_BFu7s_BFu7ll)
//============================================================================


struct  BFs7ll_BFu7s_BFu7s_BFu7s  {
  signed __tsi64 v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7ll_BFu7s_BFu7s_BFu7s) C1{ FL:7 Fs:7 Fs:7 Fs:7}



static void Test_BFs7ll_BFu7s_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7ll_BFu7s_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7ll_BFu7s_BFu7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7ll_BFu7s_BFu7s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7ll_BFu7s_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7ll_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7ll_BFu7s_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7ll_BFu7s_BFu7s_BFu7s, BFs7ll_BFu7s_BFu7s_BFu7s)
//============================================================================


struct  BFs7s_BFs7c  {
  signed short v1:7;
  signed char v2:7;
};
//SIG(1 BFs7s_BFs7c) C1{ Fs:7 Fc:7}



static void Test_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7c lv;
    check2(sizeof(lv), 2, "sizeof(BFs7s_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c, BFs7s_BFs7c)
//============================================================================


struct  BFs7s_BFs7c_BFs7c  {
  signed short v1:7;
  signed char v2:7;
  signed char v3:7;
};
//SIG(1 BFs7s_BFs7c_BFs7c) C1{ Fs:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7c, BFs7s_BFs7c_BFs7c)
//============================================================================


struct  BFs7s_BFs7c_BFs7c_BFs7c  {
  signed short v1:7;
  signed char v2:7;
  signed char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7c_BFs7c) C1{ Fs:7 Fc:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7c_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7c_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7c_BFs7c, BFs7s_BFs7c_BFs7c_BFs7c)
//============================================================================


struct  BFs7s_BFs7c_BFs7c_BFs7i  {
  signed short v1:7;
  signed char v2:7;
  signed char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7c_BFs7i) C1{ Fs:7 Fc:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7c_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7c_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7c_BFs7i, BFs7s_BFs7c_BFs7c_BFs7i)
//============================================================================


struct  BFs7s_BFs7c_BFs7c_BFs7ll  {
  signed short v1:7;
  signed char v2:7;
  signed char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7c_BFs7ll) C1{ Fs:7 Fc:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7c_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7c_BFs7ll, BFs7s_BFs7c_BFs7c_BFs7ll)
//============================================================================


struct  BFs7s_BFs7c_BFs7c_BFs7s  {
  signed short v1:7;
  signed char v2:7;
  signed char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7c_BFs7s) C1{ Fs:7 Fc:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7c_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7c_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7c_BFs7s, BFs7s_BFs7c_BFs7c_BFs7s)
//============================================================================


struct  BFs7s_BFs7c_BFs7c_BFu7c  {
  signed short v1:7;
  signed char v2:7;
  signed char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7c_BFu7c) C1{ Fs:7 Fc:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7c_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7c_BFu7c, BFs7s_BFs7c_BFs7c_BFu7c)
//============================================================================


struct  BFs7s_BFs7c_BFs7c_BFu7i  {
  signed short v1:7;
  signed char v2:7;
  signed char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7c_BFu7i) C1{ Fs:7 Fc:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7c_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7c_BFu7i, BFs7s_BFs7c_BFs7c_BFu7i)
//============================================================================


struct  BFs7s_BFs7c_BFs7c_BFu7ll  {
  signed short v1:7;
  signed char v2:7;
  signed char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7c_BFu7ll) C1{ Fs:7 Fc:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7c_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7c_BFu7ll, BFs7s_BFs7c_BFs7c_BFu7ll)
//============================================================================


struct  BFs7s_BFs7c_BFs7c_BFu7s  {
  signed short v1:7;
  signed char v2:7;
  signed char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7c_BFu7s) C1{ Fs:7 Fc:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7c_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7c_BFu7s, BFs7s_BFs7c_BFs7c_BFu7s)
//============================================================================


struct  BFs7s_BFs7c_BFs7i  {
  signed short v1:7;
  signed char v2:7;
  signed int v3:7;
};
//SIG(1 BFs7s_BFs7c_BFs7i) C1{ Fs:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7i, BFs7s_BFs7c_BFs7i)
//============================================================================


struct  BFs7s_BFs7c_BFs7i_BFs7c  {
  signed short v1:7;
  signed char v2:7;
  signed int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7i_BFs7c) C1{ Fs:7 Fc:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7c_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7i_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7i_BFs7c, BFs7s_BFs7c_BFs7i_BFs7c)
//============================================================================


struct  BFs7s_BFs7c_BFs7i_BFs7i  {
  signed short v1:7;
  signed char v2:7;
  signed int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7i_BFs7i) C1{ Fs:7 Fc:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7c_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7i_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7i_BFs7i, BFs7s_BFs7c_BFs7i_BFs7i)
//============================================================================


struct  BFs7s_BFs7c_BFs7i_BFs7ll  {
  signed short v1:7;
  signed char v2:7;
  signed int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7i_BFs7ll) C1{ Fs:7 Fc:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7c_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7i_BFs7ll, BFs7s_BFs7c_BFs7i_BFs7ll)
//============================================================================


struct  BFs7s_BFs7c_BFs7i_BFs7s  {
  signed short v1:7;
  signed char v2:7;
  signed int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7i_BFs7s) C1{ Fs:7 Fc:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7c_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7i_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7i_BFs7s, BFs7s_BFs7c_BFs7i_BFs7s)
//============================================================================


struct  BFs7s_BFs7c_BFs7i_BFu7c  {
  signed short v1:7;
  signed char v2:7;
  signed int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7i_BFu7c) C1{ Fs:7 Fc:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7c_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7i_BFu7c, BFs7s_BFs7c_BFs7i_BFu7c)
//============================================================================


struct  BFs7s_BFs7c_BFs7i_BFu7i  {
  signed short v1:7;
  signed char v2:7;
  signed int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7i_BFu7i) C1{ Fs:7 Fc:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7c_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7i_BFu7i, BFs7s_BFs7c_BFs7i_BFu7i)
//============================================================================


struct  BFs7s_BFs7c_BFs7i_BFu7ll  {
  signed short v1:7;
  signed char v2:7;
  signed int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7i_BFu7ll) C1{ Fs:7 Fc:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7c_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7i_BFu7ll, BFs7s_BFs7c_BFs7i_BFu7ll)
//============================================================================


struct  BFs7s_BFs7c_BFs7i_BFu7s  {
  signed short v1:7;
  signed char v2:7;
  signed int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7i_BFu7s) C1{ Fs:7 Fc:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7c_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7i_BFu7s, BFs7s_BFs7c_BFs7i_BFu7s)
//============================================================================


struct  BFs7s_BFs7c_BFs7ll  {
  signed short v1:7;
  signed char v2:7;
  signed __tsi64 v3:7;
};
//SIG(1 BFs7s_BFs7c_BFs7ll) C1{ Fs:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7ll, BFs7s_BFs7c_BFs7ll)
//============================================================================


struct  BFs7s_BFs7c_BFs7ll_BFs7c  {
  signed short v1:7;
  signed char v2:7;
  signed __tsi64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7ll_BFs7c) C1{ Fs:7 Fc:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7c_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7ll_BFs7c, BFs7s_BFs7c_BFs7ll_BFs7c)
//============================================================================


struct  BFs7s_BFs7c_BFs7ll_BFs7i  {
  signed short v1:7;
  signed char v2:7;
  signed __tsi64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7ll_BFs7i) C1{ Fs:7 Fc:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7c_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7ll_BFs7i, BFs7s_BFs7c_BFs7ll_BFs7i)
//============================================================================


struct  BFs7s_BFs7c_BFs7ll_BFs7ll  {
  signed short v1:7;
  signed char v2:7;
  signed __tsi64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7ll_BFs7ll) C1{ Fs:7 Fc:7 FL:7 FL:7}



static void Test_BFs7s_BFs7c_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7ll_BFs7ll, BFs7s_BFs7c_BFs7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFs7c_BFs7ll_BFs7s  {
  signed short v1:7;
  signed char v2:7;
  signed __tsi64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7ll_BFs7s) C1{ Fs:7 Fc:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7c_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7ll_BFs7s, BFs7s_BFs7c_BFs7ll_BFs7s)
//============================================================================


struct  BFs7s_BFs7c_BFs7ll_BFu7c  {
  signed short v1:7;
  signed char v2:7;
  signed __tsi64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7ll_BFu7c) C1{ Fs:7 Fc:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7c_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7ll_BFu7c, BFs7s_BFs7c_BFs7ll_BFu7c)
//============================================================================


struct  BFs7s_BFs7c_BFs7ll_BFu7i  {
  signed short v1:7;
  signed char v2:7;
  signed __tsi64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7ll_BFu7i) C1{ Fs:7 Fc:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7c_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7ll_BFu7i, BFs7s_BFs7c_BFs7ll_BFu7i)
//============================================================================


struct  BFs7s_BFs7c_BFs7ll_BFu7ll  {
  signed short v1:7;
  signed char v2:7;
  signed __tsi64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7ll_BFu7ll) C1{ Fs:7 Fc:7 FL:7 FL:7}



static void Test_BFs7s_BFs7c_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7ll_BFu7ll, BFs7s_BFs7c_BFs7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFs7c_BFs7ll_BFu7s  {
  signed short v1:7;
  signed char v2:7;
  signed __tsi64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7ll_BFu7s) C1{ Fs:7 Fc:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7c_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7ll_BFu7s, BFs7s_BFs7c_BFs7ll_BFu7s)
//============================================================================


struct  BFs7s_BFs7c_BFs7s  {
  signed short v1:7;
  signed char v2:7;
  signed short v3:7;
};
//SIG(1 BFs7s_BFs7c_BFs7s) C1{ Fs:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7s, BFs7s_BFs7c_BFs7s)
//============================================================================


struct  BFs7s_BFs7c_BFs7s_BFs7c  {
  signed short v1:7;
  signed char v2:7;
  signed short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7s_BFs7c) C1{ Fs:7 Fc:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7c_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7s_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7s_BFs7c, BFs7s_BFs7c_BFs7s_BFs7c)
//============================================================================


struct  BFs7s_BFs7c_BFs7s_BFs7i  {
  signed short v1:7;
  signed char v2:7;
  signed short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7s_BFs7i) C1{ Fs:7 Fc:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7c_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7s_BFs7i, BFs7s_BFs7c_BFs7s_BFs7i)
//============================================================================


struct  BFs7s_BFs7c_BFs7s_BFs7ll  {
  signed short v1:7;
  signed char v2:7;
  signed short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7s_BFs7ll) C1{ Fs:7 Fc:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7c_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7s_BFs7ll, BFs7s_BFs7c_BFs7s_BFs7ll)
//============================================================================


struct  BFs7s_BFs7c_BFs7s_BFs7s  {
  signed short v1:7;
  signed char v2:7;
  signed short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7s_BFs7s) C1{ Fs:7 Fc:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7c_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7s_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7s_BFs7s, BFs7s_BFs7c_BFs7s_BFs7s)
//============================================================================


struct  BFs7s_BFs7c_BFs7s_BFu7c  {
  signed short v1:7;
  signed char v2:7;
  signed short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7s_BFu7c) C1{ Fs:7 Fc:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7c_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7s_BFu7c, BFs7s_BFs7c_BFs7s_BFu7c)
//============================================================================


struct  BFs7s_BFs7c_BFs7s_BFu7i  {
  signed short v1:7;
  signed char v2:7;
  signed short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7s_BFu7i) C1{ Fs:7 Fc:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7c_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7s_BFu7i, BFs7s_BFs7c_BFs7s_BFu7i)
//============================================================================


struct  BFs7s_BFs7c_BFs7s_BFu7ll  {
  signed short v1:7;
  signed char v2:7;
  signed short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7s_BFu7ll) C1{ Fs:7 Fc:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7c_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFs7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7s_BFu7ll, BFs7s_BFs7c_BFs7s_BFu7ll)
//============================================================================


struct  BFs7s_BFs7c_BFs7s_BFu7s  {
  signed short v1:7;
  signed char v2:7;
  signed short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFs7s_BFu7s) C1{ Fs:7 Fc:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7c_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFs7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFs7s_BFu7s, BFs7s_BFs7c_BFs7s_BFu7s)
//============================================================================


struct  BFs7s_BFs7c_BFu7c  {
  signed short v1:7;
  signed char v2:7;
  unsigned char v3:7;
};
//SIG(1 BFs7s_BFs7c_BFu7c) C1{ Fs:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7c, BFs7s_BFs7c_BFu7c)
//============================================================================


struct  BFs7s_BFs7c_BFu7c_BFs7c  {
  signed short v1:7;
  signed char v2:7;
  unsigned char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7c_BFs7c) C1{ Fs:7 Fc:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7c_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7c_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7c_BFs7c, BFs7s_BFs7c_BFu7c_BFs7c)
//============================================================================


struct  BFs7s_BFs7c_BFu7c_BFs7i  {
  signed short v1:7;
  signed char v2:7;
  unsigned char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7c_BFs7i) C1{ Fs:7 Fc:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7c_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7c_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7c_BFs7i, BFs7s_BFs7c_BFu7c_BFs7i)
//============================================================================


struct  BFs7s_BFs7c_BFu7c_BFs7ll  {
  signed short v1:7;
  signed char v2:7;
  unsigned char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7c_BFs7ll) C1{ Fs:7 Fc:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7c_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7c_BFs7ll, BFs7s_BFs7c_BFu7c_BFs7ll)
//============================================================================


struct  BFs7s_BFs7c_BFu7c_BFs7s  {
  signed short v1:7;
  signed char v2:7;
  unsigned char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7c_BFs7s) C1{ Fs:7 Fc:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7c_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7c_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7c_BFs7s, BFs7s_BFs7c_BFu7c_BFs7s)
//============================================================================


struct  BFs7s_BFs7c_BFu7c_BFu7c  {
  signed short v1:7;
  signed char v2:7;
  unsigned char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7c_BFu7c) C1{ Fs:7 Fc:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7c_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7c_BFu7c, BFs7s_BFs7c_BFu7c_BFu7c)
//============================================================================


struct  BFs7s_BFs7c_BFu7c_BFu7i  {
  signed short v1:7;
  signed char v2:7;
  unsigned char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7c_BFu7i) C1{ Fs:7 Fc:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7c_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7c_BFu7i, BFs7s_BFs7c_BFu7c_BFu7i)
//============================================================================


struct  BFs7s_BFs7c_BFu7c_BFu7ll  {
  signed short v1:7;
  signed char v2:7;
  unsigned char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7c_BFu7ll) C1{ Fs:7 Fc:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7c_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7c_BFu7ll, BFs7s_BFs7c_BFu7c_BFu7ll)
//============================================================================


struct  BFs7s_BFs7c_BFu7c_BFu7s  {
  signed short v1:7;
  signed char v2:7;
  unsigned char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7c_BFu7s) C1{ Fs:7 Fc:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7c_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7c_BFu7s, BFs7s_BFs7c_BFu7c_BFu7s)
//============================================================================


struct  BFs7s_BFs7c_BFu7i  {
  signed short v1:7;
  signed char v2:7;
  unsigned int v3:7;
};
//SIG(1 BFs7s_BFs7c_BFu7i) C1{ Fs:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7i, BFs7s_BFs7c_BFu7i)
//============================================================================


struct  BFs7s_BFs7c_BFu7i_BFs7c  {
  signed short v1:7;
  signed char v2:7;
  unsigned int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7i_BFs7c) C1{ Fs:7 Fc:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7c_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7i_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7i_BFs7c, BFs7s_BFs7c_BFu7i_BFs7c)
//============================================================================


struct  BFs7s_BFs7c_BFu7i_BFs7i  {
  signed short v1:7;
  signed char v2:7;
  unsigned int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7i_BFs7i) C1{ Fs:7 Fc:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7c_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7i_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7i_BFs7i, BFs7s_BFs7c_BFu7i_BFs7i)
//============================================================================


struct  BFs7s_BFs7c_BFu7i_BFs7ll  {
  signed short v1:7;
  signed char v2:7;
  unsigned int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7i_BFs7ll) C1{ Fs:7 Fc:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7c_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7i_BFs7ll, BFs7s_BFs7c_BFu7i_BFs7ll)
//============================================================================


struct  BFs7s_BFs7c_BFu7i_BFs7s  {
  signed short v1:7;
  signed char v2:7;
  unsigned int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7i_BFs7s) C1{ Fs:7 Fc:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7c_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7i_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7i_BFs7s, BFs7s_BFs7c_BFu7i_BFs7s)
//============================================================================


struct  BFs7s_BFs7c_BFu7i_BFu7c  {
  signed short v1:7;
  signed char v2:7;
  unsigned int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7i_BFu7c) C1{ Fs:7 Fc:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7c_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7i_BFu7c, BFs7s_BFs7c_BFu7i_BFu7c)
//============================================================================


struct  BFs7s_BFs7c_BFu7i_BFu7i  {
  signed short v1:7;
  signed char v2:7;
  unsigned int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7i_BFu7i) C1{ Fs:7 Fc:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7c_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7i_BFu7i, BFs7s_BFs7c_BFu7i_BFu7i)
//============================================================================


struct  BFs7s_BFs7c_BFu7i_BFu7ll  {
  signed short v1:7;
  signed char v2:7;
  unsigned int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7i_BFu7ll) C1{ Fs:7 Fc:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7c_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7i_BFu7ll, BFs7s_BFs7c_BFu7i_BFu7ll)
//============================================================================


struct  BFs7s_BFs7c_BFu7i_BFu7s  {
  signed short v1:7;
  signed char v2:7;
  unsigned int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7i_BFu7s) C1{ Fs:7 Fc:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7c_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7i_BFu7s, BFs7s_BFs7c_BFu7i_BFu7s)
//============================================================================


struct  BFs7s_BFs7c_BFu7ll  {
  signed short v1:7;
  signed char v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFs7s_BFs7c_BFu7ll) C1{ Fs:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7ll, BFs7s_BFs7c_BFu7ll)
//============================================================================


struct  BFs7s_BFs7c_BFu7ll_BFs7c  {
  signed short v1:7;
  signed char v2:7;
  __tsu64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7ll_BFs7c) C1{ Fs:7 Fc:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7c_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7ll_BFs7c, BFs7s_BFs7c_BFu7ll_BFs7c)
//============================================================================


struct  BFs7s_BFs7c_BFu7ll_BFs7i  {
  signed short v1:7;
  signed char v2:7;
  __tsu64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7ll_BFs7i) C1{ Fs:7 Fc:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7c_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7ll_BFs7i, BFs7s_BFs7c_BFu7ll_BFs7i)
//============================================================================


struct  BFs7s_BFs7c_BFu7ll_BFs7ll  {
  signed short v1:7;
  signed char v2:7;
  __tsu64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7ll_BFs7ll) C1{ Fs:7 Fc:7 FL:7 FL:7}



static void Test_BFs7s_BFs7c_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7ll_BFs7ll, BFs7s_BFs7c_BFu7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFs7c_BFu7ll_BFs7s  {
  signed short v1:7;
  signed char v2:7;
  __tsu64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7ll_BFs7s) C1{ Fs:7 Fc:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7c_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7ll_BFs7s, BFs7s_BFs7c_BFu7ll_BFs7s)
//============================================================================


struct  BFs7s_BFs7c_BFu7ll_BFu7c  {
  signed short v1:7;
  signed char v2:7;
  __tsu64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7ll_BFu7c) C1{ Fs:7 Fc:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7c_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7ll_BFu7c, BFs7s_BFs7c_BFu7ll_BFu7c)
//============================================================================


struct  BFs7s_BFs7c_BFu7ll_BFu7i  {
  signed short v1:7;
  signed char v2:7;
  __tsu64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7ll_BFu7i) C1{ Fs:7 Fc:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7c_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7ll_BFu7i, BFs7s_BFs7c_BFu7ll_BFu7i)
//============================================================================


struct  BFs7s_BFs7c_BFu7ll_BFu7ll  {
  signed short v1:7;
  signed char v2:7;
  __tsu64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7ll_BFu7ll) C1{ Fs:7 Fc:7 FL:7 FL:7}



static void Test_BFs7s_BFs7c_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7ll_BFu7ll, BFs7s_BFs7c_BFu7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFs7c_BFu7ll_BFu7s  {
  signed short v1:7;
  signed char v2:7;
  __tsu64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7ll_BFu7s) C1{ Fs:7 Fc:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7c_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFs7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7ll_BFu7s, BFs7s_BFs7c_BFu7ll_BFu7s)
//============================================================================


struct  BFs7s_BFs7c_BFu7s  {
  signed short v1:7;
  signed char v2:7;
  unsigned short v3:7;
};
//SIG(1 BFs7s_BFs7c_BFu7s) C1{ Fs:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7s, BFs7s_BFs7c_BFu7s)
//============================================================================


struct  BFs7s_BFs7c_BFu7s_BFs7c  {
  signed short v1:7;
  signed char v2:7;
  unsigned short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7s_BFs7c) C1{ Fs:7 Fc:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7c_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7s_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7s_BFs7c, BFs7s_BFs7c_BFu7s_BFs7c)
//============================================================================


struct  BFs7s_BFs7c_BFu7s_BFs7i  {
  signed short v1:7;
  signed char v2:7;
  unsigned short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7s_BFs7i) C1{ Fs:7 Fc:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7c_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7s_BFs7i, BFs7s_BFs7c_BFu7s_BFs7i)
//============================================================================


struct  BFs7s_BFs7c_BFu7s_BFs7ll  {
  signed short v1:7;
  signed char v2:7;
  unsigned short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7s_BFs7ll) C1{ Fs:7 Fc:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7c_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7s_BFs7ll, BFs7s_BFs7c_BFu7s_BFs7ll)
//============================================================================


struct  BFs7s_BFs7c_BFu7s_BFs7s  {
  signed short v1:7;
  signed char v2:7;
  unsigned short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7s_BFs7s) C1{ Fs:7 Fc:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7c_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7s_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7s_BFs7s, BFs7s_BFs7c_BFu7s_BFs7s)
//============================================================================


struct  BFs7s_BFs7c_BFu7s_BFu7c  {
  signed short v1:7;
  signed char v2:7;
  unsigned short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7s_BFu7c) C1{ Fs:7 Fc:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7c_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7s_BFu7c, BFs7s_BFs7c_BFu7s_BFu7c)
//============================================================================


struct  BFs7s_BFs7c_BFu7s_BFu7i  {
  signed short v1:7;
  signed char v2:7;
  unsigned short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7s_BFu7i) C1{ Fs:7 Fc:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7c_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7c_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7s_BFu7i, BFs7s_BFs7c_BFu7s_BFu7i)
//============================================================================


struct  BFs7s_BFs7c_BFu7s_BFu7ll  {
  signed short v1:7;
  signed char v2:7;
  unsigned short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7s_BFu7ll) C1{ Fs:7 Fc:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7c_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7c_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7c_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7s_BFu7ll, BFs7s_BFs7c_BFu7s_BFu7ll)
//============================================================================


struct  BFs7s_BFs7c_BFu7s_BFu7s  {
  signed short v1:7;
  signed char v2:7;
  unsigned short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7c_BFu7s_BFu7s) C1{ Fs:7 Fc:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7c_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7c_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7c_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7c_BFu7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7c_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7c_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7c_BFu7s_BFu7s, BFs7s_BFs7c_BFu7s_BFu7s)
//============================================================================


struct  BFs7s_BFs7i  {
  signed short v1:7;
  signed int v2:7;
};
//SIG(1 BFs7s_BFs7i) C1{ Fs:7 Fi:7}



static void Test_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i, BFs7s_BFs7i)
//============================================================================


struct  BFs7s_BFs7i_BFs7c  {
  signed short v1:7;
  signed int v2:7;
  signed char v3:7;
};
//SIG(1 BFs7s_BFs7i_BFs7c) C1{ Fs:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7c, BFs7s_BFs7i_BFs7c)
//============================================================================


struct  BFs7s_BFs7i_BFs7c_BFs7c  {
  signed short v1:7;
  signed int v2:7;
  signed char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7c_BFs7c) C1{ Fs:7 Fi:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7i_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7c_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7c_BFs7c, BFs7s_BFs7i_BFs7c_BFs7c)
//============================================================================


struct  BFs7s_BFs7i_BFs7c_BFs7i  {
  signed short v1:7;
  signed int v2:7;
  signed char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7c_BFs7i) C1{ Fs:7 Fi:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7i_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7c_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7c_BFs7i, BFs7s_BFs7i_BFs7c_BFs7i)
//============================================================================


struct  BFs7s_BFs7i_BFs7c_BFs7ll  {
  signed short v1:7;
  signed int v2:7;
  signed char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7c_BFs7ll) C1{ Fs:7 Fi:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7i_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7c_BFs7ll, BFs7s_BFs7i_BFs7c_BFs7ll)
//============================================================================


struct  BFs7s_BFs7i_BFs7c_BFs7s  {
  signed short v1:7;
  signed int v2:7;
  signed char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7c_BFs7s) C1{ Fs:7 Fi:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7i_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7c_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7c_BFs7s, BFs7s_BFs7i_BFs7c_BFs7s)
//============================================================================


struct  BFs7s_BFs7i_BFs7c_BFu7c  {
  signed short v1:7;
  signed int v2:7;
  signed char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7c_BFu7c) C1{ Fs:7 Fi:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7i_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7c_BFu7c, BFs7s_BFs7i_BFs7c_BFu7c)
//============================================================================


struct  BFs7s_BFs7i_BFs7c_BFu7i  {
  signed short v1:7;
  signed int v2:7;
  signed char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7c_BFu7i) C1{ Fs:7 Fi:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7i_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7c_BFu7i, BFs7s_BFs7i_BFs7c_BFu7i)
//============================================================================


struct  BFs7s_BFs7i_BFs7c_BFu7ll  {
  signed short v1:7;
  signed int v2:7;
  signed char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7c_BFu7ll) C1{ Fs:7 Fi:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7i_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7c_BFu7ll, BFs7s_BFs7i_BFs7c_BFu7ll)
//============================================================================


struct  BFs7s_BFs7i_BFs7c_BFu7s  {
  signed short v1:7;
  signed int v2:7;
  signed char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7c_BFu7s) C1{ Fs:7 Fi:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7i_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7c_BFu7s, BFs7s_BFs7i_BFs7c_BFu7s)
//============================================================================


struct  BFs7s_BFs7i_BFs7i  {
  signed short v1:7;
  signed int v2:7;
  signed int v3:7;
};
//SIG(1 BFs7s_BFs7i_BFs7i) C1{ Fs:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7i, BFs7s_BFs7i_BFs7i)
//============================================================================


struct  BFs7s_BFs7i_BFs7i_BFs7c  {
  signed short v1:7;
  signed int v2:7;
  signed int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7i_BFs7c) C1{ Fs:7 Fi:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7i_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7i_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7i_BFs7c, BFs7s_BFs7i_BFs7i_BFs7c)
//============================================================================


struct  BFs7s_BFs7i_BFs7i_BFs7i  {
  signed short v1:7;
  signed int v2:7;
  signed int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7i_BFs7i) C1{ Fs:7 Fi:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7i_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7i_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7i_BFs7i, BFs7s_BFs7i_BFs7i_BFs7i)
//============================================================================


struct  BFs7s_BFs7i_BFs7i_BFs7ll  {
  signed short v1:7;
  signed int v2:7;
  signed int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7i_BFs7ll) C1{ Fs:7 Fi:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7i_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7i_BFs7ll, BFs7s_BFs7i_BFs7i_BFs7ll)
//============================================================================


struct  BFs7s_BFs7i_BFs7i_BFs7s  {
  signed short v1:7;
  signed int v2:7;
  signed int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7i_BFs7s) C1{ Fs:7 Fi:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7i_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7i_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7i_BFs7s, BFs7s_BFs7i_BFs7i_BFs7s)
//============================================================================


struct  BFs7s_BFs7i_BFs7i_BFu7c  {
  signed short v1:7;
  signed int v2:7;
  signed int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7i_BFu7c) C1{ Fs:7 Fi:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7i_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7i_BFu7c, BFs7s_BFs7i_BFs7i_BFu7c)
//============================================================================


struct  BFs7s_BFs7i_BFs7i_BFu7i  {
  signed short v1:7;
  signed int v2:7;
  signed int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7i_BFu7i) C1{ Fs:7 Fi:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7i_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7i_BFu7i, BFs7s_BFs7i_BFs7i_BFu7i)
//============================================================================


struct  BFs7s_BFs7i_BFs7i_BFu7ll  {
  signed short v1:7;
  signed int v2:7;
  signed int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7i_BFu7ll) C1{ Fs:7 Fi:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7i_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7i_BFu7ll, BFs7s_BFs7i_BFs7i_BFu7ll)
//============================================================================


struct  BFs7s_BFs7i_BFs7i_BFu7s  {
  signed short v1:7;
  signed int v2:7;
  signed int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7i_BFu7s) C1{ Fs:7 Fi:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7i_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7i_BFu7s, BFs7s_BFs7i_BFs7i_BFu7s)
//============================================================================


struct  BFs7s_BFs7i_BFs7ll  {
  signed short v1:7;
  signed int v2:7;
  signed __tsi64 v3:7;
};
//SIG(1 BFs7s_BFs7i_BFs7ll) C1{ Fs:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7ll, BFs7s_BFs7i_BFs7ll)
//============================================================================


struct  BFs7s_BFs7i_BFs7ll_BFs7c  {
  signed short v1:7;
  signed int v2:7;
  signed __tsi64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7ll_BFs7c) C1{ Fs:7 Fi:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7i_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7ll_BFs7c, BFs7s_BFs7i_BFs7ll_BFs7c)
//============================================================================


struct  BFs7s_BFs7i_BFs7ll_BFs7i  {
  signed short v1:7;
  signed int v2:7;
  signed __tsi64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7ll_BFs7i) C1{ Fs:7 Fi:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7i_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7ll_BFs7i, BFs7s_BFs7i_BFs7ll_BFs7i)
//============================================================================


struct  BFs7s_BFs7i_BFs7ll_BFs7ll  {
  signed short v1:7;
  signed int v2:7;
  signed __tsi64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7ll_BFs7ll) C1{ Fs:7 Fi:7 FL:7 FL:7}



static void Test_BFs7s_BFs7i_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7ll_BFs7ll, BFs7s_BFs7i_BFs7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFs7i_BFs7ll_BFs7s  {
  signed short v1:7;
  signed int v2:7;
  signed __tsi64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7ll_BFs7s) C1{ Fs:7 Fi:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7i_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7ll_BFs7s, BFs7s_BFs7i_BFs7ll_BFs7s)
//============================================================================


struct  BFs7s_BFs7i_BFs7ll_BFu7c  {
  signed short v1:7;
  signed int v2:7;
  signed __tsi64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7ll_BFu7c) C1{ Fs:7 Fi:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7i_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7ll_BFu7c, BFs7s_BFs7i_BFs7ll_BFu7c)
//============================================================================


struct  BFs7s_BFs7i_BFs7ll_BFu7i  {
  signed short v1:7;
  signed int v2:7;
  signed __tsi64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7ll_BFu7i) C1{ Fs:7 Fi:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7i_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7ll_BFu7i, BFs7s_BFs7i_BFs7ll_BFu7i)
//============================================================================


struct  BFs7s_BFs7i_BFs7ll_BFu7ll  {
  signed short v1:7;
  signed int v2:7;
  signed __tsi64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7ll_BFu7ll) C1{ Fs:7 Fi:7 FL:7 FL:7}



static void Test_BFs7s_BFs7i_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7ll_BFu7ll, BFs7s_BFs7i_BFs7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFs7i_BFs7ll_BFu7s  {
  signed short v1:7;
  signed int v2:7;
  signed __tsi64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7ll_BFu7s) C1{ Fs:7 Fi:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7i_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7ll_BFu7s, BFs7s_BFs7i_BFs7ll_BFu7s)
//============================================================================


struct  BFs7s_BFs7i_BFs7s  {
  signed short v1:7;
  signed int v2:7;
  signed short v3:7;
};
//SIG(1 BFs7s_BFs7i_BFs7s) C1{ Fs:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7s, BFs7s_BFs7i_BFs7s)
//============================================================================


struct  BFs7s_BFs7i_BFs7s_BFs7c  {
  signed short v1:7;
  signed int v2:7;
  signed short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7s_BFs7c) C1{ Fs:7 Fi:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7i_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7s_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7s_BFs7c, BFs7s_BFs7i_BFs7s_BFs7c)
//============================================================================


struct  BFs7s_BFs7i_BFs7s_BFs7i  {
  signed short v1:7;
  signed int v2:7;
  signed short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7s_BFs7i) C1{ Fs:7 Fi:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7i_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7s_BFs7i, BFs7s_BFs7i_BFs7s_BFs7i)
//============================================================================


struct  BFs7s_BFs7i_BFs7s_BFs7ll  {
  signed short v1:7;
  signed int v2:7;
  signed short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7s_BFs7ll) C1{ Fs:7 Fi:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7i_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7s_BFs7ll, BFs7s_BFs7i_BFs7s_BFs7ll)
//============================================================================


struct  BFs7s_BFs7i_BFs7s_BFs7s  {
  signed short v1:7;
  signed int v2:7;
  signed short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7s_BFs7s) C1{ Fs:7 Fi:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7i_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7s_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7s_BFs7s, BFs7s_BFs7i_BFs7s_BFs7s)
//============================================================================


struct  BFs7s_BFs7i_BFs7s_BFu7c  {
  signed short v1:7;
  signed int v2:7;
  signed short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7s_BFu7c) C1{ Fs:7 Fi:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7i_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7s_BFu7c, BFs7s_BFs7i_BFs7s_BFu7c)
//============================================================================


struct  BFs7s_BFs7i_BFs7s_BFu7i  {
  signed short v1:7;
  signed int v2:7;
  signed short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7s_BFu7i) C1{ Fs:7 Fi:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7i_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7s_BFu7i, BFs7s_BFs7i_BFs7s_BFu7i)
//============================================================================


struct  BFs7s_BFs7i_BFs7s_BFu7ll  {
  signed short v1:7;
  signed int v2:7;
  signed short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7s_BFu7ll) C1{ Fs:7 Fi:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7i_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFs7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7s_BFu7ll, BFs7s_BFs7i_BFs7s_BFu7ll)
//============================================================================


struct  BFs7s_BFs7i_BFs7s_BFu7s  {
  signed short v1:7;
  signed int v2:7;
  signed short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFs7s_BFu7s) C1{ Fs:7 Fi:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7i_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFs7s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFs7s_BFu7s, BFs7s_BFs7i_BFs7s_BFu7s)
//============================================================================


struct  BFs7s_BFs7i_BFu7c  {
  signed short v1:7;
  signed int v2:7;
  unsigned char v3:7;
};
//SIG(1 BFs7s_BFs7i_BFu7c) C1{ Fs:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7c, BFs7s_BFs7i_BFu7c)
//============================================================================


struct  BFs7s_BFs7i_BFu7c_BFs7c  {
  signed short v1:7;
  signed int v2:7;
  unsigned char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7c_BFs7c) C1{ Fs:7 Fi:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7i_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7c_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7c_BFs7c, BFs7s_BFs7i_BFu7c_BFs7c)
//============================================================================


struct  BFs7s_BFs7i_BFu7c_BFs7i  {
  signed short v1:7;
  signed int v2:7;
  unsigned char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7c_BFs7i) C1{ Fs:7 Fi:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7i_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7c_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7c_BFs7i, BFs7s_BFs7i_BFu7c_BFs7i)
//============================================================================


struct  BFs7s_BFs7i_BFu7c_BFs7ll  {
  signed short v1:7;
  signed int v2:7;
  unsigned char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7c_BFs7ll) C1{ Fs:7 Fi:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7i_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7c_BFs7ll, BFs7s_BFs7i_BFu7c_BFs7ll)
//============================================================================


struct  BFs7s_BFs7i_BFu7c_BFs7s  {
  signed short v1:7;
  signed int v2:7;
  unsigned char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7c_BFs7s) C1{ Fs:7 Fi:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7i_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7c_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7c_BFs7s, BFs7s_BFs7i_BFu7c_BFs7s)
//============================================================================


struct  BFs7s_BFs7i_BFu7c_BFu7c  {
  signed short v1:7;
  signed int v2:7;
  unsigned char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7c_BFu7c) C1{ Fs:7 Fi:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7i_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7c_BFu7c, BFs7s_BFs7i_BFu7c_BFu7c)
//============================================================================


struct  BFs7s_BFs7i_BFu7c_BFu7i  {
  signed short v1:7;
  signed int v2:7;
  unsigned char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7c_BFu7i) C1{ Fs:7 Fi:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7i_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7c_BFu7i, BFs7s_BFs7i_BFu7c_BFu7i)
//============================================================================


struct  BFs7s_BFs7i_BFu7c_BFu7ll  {
  signed short v1:7;
  signed int v2:7;
  unsigned char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7c_BFu7ll) C1{ Fs:7 Fi:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7i_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7c_BFu7ll, BFs7s_BFs7i_BFu7c_BFu7ll)
//============================================================================


struct  BFs7s_BFs7i_BFu7c_BFu7s  {
  signed short v1:7;
  signed int v2:7;
  unsigned char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7c_BFu7s) C1{ Fs:7 Fi:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7i_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7c_BFu7s, BFs7s_BFs7i_BFu7c_BFu7s)
//============================================================================


struct  BFs7s_BFs7i_BFu7i  {
  signed short v1:7;
  signed int v2:7;
  unsigned int v3:7;
};
//SIG(1 BFs7s_BFs7i_BFu7i) C1{ Fs:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7i, BFs7s_BFs7i_BFu7i)
//============================================================================


struct  BFs7s_BFs7i_BFu7i_BFs7c  {
  signed short v1:7;
  signed int v2:7;
  unsigned int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7i_BFs7c) C1{ Fs:7 Fi:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7i_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7i_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7i_BFs7c, BFs7s_BFs7i_BFu7i_BFs7c)
//============================================================================


struct  BFs7s_BFs7i_BFu7i_BFs7i  {
  signed short v1:7;
  signed int v2:7;
  unsigned int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7i_BFs7i) C1{ Fs:7 Fi:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7i_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7i_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7i_BFs7i, BFs7s_BFs7i_BFu7i_BFs7i)
//============================================================================


struct  BFs7s_BFs7i_BFu7i_BFs7ll  {
  signed short v1:7;
  signed int v2:7;
  unsigned int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7i_BFs7ll) C1{ Fs:7 Fi:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7i_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7i_BFs7ll, BFs7s_BFs7i_BFu7i_BFs7ll)
//============================================================================


struct  BFs7s_BFs7i_BFu7i_BFs7s  {
  signed short v1:7;
  signed int v2:7;
  unsigned int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7i_BFs7s) C1{ Fs:7 Fi:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7i_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7i_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7i_BFs7s, BFs7s_BFs7i_BFu7i_BFs7s)
//============================================================================


struct  BFs7s_BFs7i_BFu7i_BFu7c  {
  signed short v1:7;
  signed int v2:7;
  unsigned int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7i_BFu7c) C1{ Fs:7 Fi:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7i_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7i_BFu7c, BFs7s_BFs7i_BFu7i_BFu7c)
//============================================================================


struct  BFs7s_BFs7i_BFu7i_BFu7i  {
  signed short v1:7;
  signed int v2:7;
  unsigned int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7i_BFu7i) C1{ Fs:7 Fi:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7i_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7i_BFu7i, BFs7s_BFs7i_BFu7i_BFu7i)
//============================================================================


struct  BFs7s_BFs7i_BFu7i_BFu7ll  {
  signed short v1:7;
  signed int v2:7;
  unsigned int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7i_BFu7ll) C1{ Fs:7 Fi:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7i_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7i_BFu7ll, BFs7s_BFs7i_BFu7i_BFu7ll)
//============================================================================


struct  BFs7s_BFs7i_BFu7i_BFu7s  {
  signed short v1:7;
  signed int v2:7;
  unsigned int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7i_BFu7s) C1{ Fs:7 Fi:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7i_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7i_BFu7s, BFs7s_BFs7i_BFu7i_BFu7s)
//============================================================================


struct  BFs7s_BFs7i_BFu7ll  {
  signed short v1:7;
  signed int v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFs7s_BFs7i_BFu7ll) C1{ Fs:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7ll, BFs7s_BFs7i_BFu7ll)
//============================================================================


struct  BFs7s_BFs7i_BFu7ll_BFs7c  {
  signed short v1:7;
  signed int v2:7;
  __tsu64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7ll_BFs7c) C1{ Fs:7 Fi:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7i_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7ll_BFs7c, BFs7s_BFs7i_BFu7ll_BFs7c)
//============================================================================


struct  BFs7s_BFs7i_BFu7ll_BFs7i  {
  signed short v1:7;
  signed int v2:7;
  __tsu64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7ll_BFs7i) C1{ Fs:7 Fi:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7i_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7ll_BFs7i, BFs7s_BFs7i_BFu7ll_BFs7i)
//============================================================================


struct  BFs7s_BFs7i_BFu7ll_BFs7ll  {
  signed short v1:7;
  signed int v2:7;
  __tsu64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7ll_BFs7ll) C1{ Fs:7 Fi:7 FL:7 FL:7}



static void Test_BFs7s_BFs7i_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7ll_BFs7ll, BFs7s_BFs7i_BFu7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFs7i_BFu7ll_BFs7s  {
  signed short v1:7;
  signed int v2:7;
  __tsu64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7ll_BFs7s) C1{ Fs:7 Fi:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7i_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7ll_BFs7s, BFs7s_BFs7i_BFu7ll_BFs7s)
//============================================================================


struct  BFs7s_BFs7i_BFu7ll_BFu7c  {
  signed short v1:7;
  signed int v2:7;
  __tsu64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7ll_BFu7c) C1{ Fs:7 Fi:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7i_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7ll_BFu7c, BFs7s_BFs7i_BFu7ll_BFu7c)
//============================================================================


struct  BFs7s_BFs7i_BFu7ll_BFu7i  {
  signed short v1:7;
  signed int v2:7;
  __tsu64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7ll_BFu7i) C1{ Fs:7 Fi:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7i_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7ll_BFu7i, BFs7s_BFs7i_BFu7ll_BFu7i)
//============================================================================


struct  BFs7s_BFs7i_BFu7ll_BFu7ll  {
  signed short v1:7;
  signed int v2:7;
  __tsu64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7ll_BFu7ll) C1{ Fs:7 Fi:7 FL:7 FL:7}



static void Test_BFs7s_BFs7i_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7ll_BFu7ll, BFs7s_BFs7i_BFu7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFs7i_BFu7ll_BFu7s  {
  signed short v1:7;
  signed int v2:7;
  __tsu64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7ll_BFu7s) C1{ Fs:7 Fi:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7i_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7ll_BFu7s, BFs7s_BFs7i_BFu7ll_BFu7s)
//============================================================================


struct  BFs7s_BFs7i_BFu7s  {
  signed short v1:7;
  signed int v2:7;
  unsigned short v3:7;
};
//SIG(1 BFs7s_BFs7i_BFu7s) C1{ Fs:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7s, BFs7s_BFs7i_BFu7s)
//============================================================================


struct  BFs7s_BFs7i_BFu7s_BFs7c  {
  signed short v1:7;
  signed int v2:7;
  unsigned short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7s_BFs7c) C1{ Fs:7 Fi:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7i_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7s_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7s_BFs7c, BFs7s_BFs7i_BFu7s_BFs7c)
//============================================================================


struct  BFs7s_BFs7i_BFu7s_BFs7i  {
  signed short v1:7;
  signed int v2:7;
  unsigned short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7s_BFs7i) C1{ Fs:7 Fi:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7i_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7s_BFs7i, BFs7s_BFs7i_BFu7s_BFs7i)
//============================================================================


struct  BFs7s_BFs7i_BFu7s_BFs7ll  {
  signed short v1:7;
  signed int v2:7;
  unsigned short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7s_BFs7ll) C1{ Fs:7 Fi:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7i_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7s_BFs7ll, BFs7s_BFs7i_BFu7s_BFs7ll)
//============================================================================


struct  BFs7s_BFs7i_BFu7s_BFs7s  {
  signed short v1:7;
  signed int v2:7;
  unsigned short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7s_BFs7s) C1{ Fs:7 Fi:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7i_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7s_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7s_BFs7s, BFs7s_BFs7i_BFu7s_BFs7s)
//============================================================================


struct  BFs7s_BFs7i_BFu7s_BFu7c  {
  signed short v1:7;
  signed int v2:7;
  unsigned short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7s_BFu7c) C1{ Fs:7 Fi:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7i_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7s_BFu7c, BFs7s_BFs7i_BFu7s_BFu7c)
//============================================================================


struct  BFs7s_BFs7i_BFu7s_BFu7i  {
  signed short v1:7;
  signed int v2:7;
  unsigned short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7s_BFu7i) C1{ Fs:7 Fi:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7i_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7s_BFu7i, BFs7s_BFs7i_BFu7s_BFu7i)
//============================================================================


struct  BFs7s_BFs7i_BFu7s_BFu7ll  {
  signed short v1:7;
  signed int v2:7;
  unsigned short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7s_BFu7ll) C1{ Fs:7 Fi:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7i_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7i_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7i_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7s_BFu7ll, BFs7s_BFs7i_BFu7s_BFu7ll)
//============================================================================


struct  BFs7s_BFs7i_BFu7s_BFu7s  {
  signed short v1:7;
  signed int v2:7;
  unsigned short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7i_BFu7s_BFu7s) C1{ Fs:7 Fi:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7i_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7i_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7i_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7i_BFu7s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7i_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7i_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7i_BFu7s_BFu7s, BFs7s_BFs7i_BFu7s_BFu7s)
//============================================================================


struct  BFs7s_BFs7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
};
//SIG(1 BFs7s_BFs7ll) C1{ Fs:7 FL:7}



static void Test_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll, BFs7s_BFs7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFs7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed char v3:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7c) C1{ Fs:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7c, BFs7s_BFs7ll_BFs7c)
//============================================================================


struct  BFs7s_BFs7ll_BFs7c_BFs7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7c_BFs7c) C1{ Fs:7 FL:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7c_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7c_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7c_BFs7c, BFs7s_BFs7ll_BFs7c_BFs7c)
//============================================================================


struct  BFs7s_BFs7ll_BFs7c_BFs7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7c_BFs7i) C1{ Fs:7 FL:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7c_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7c_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7c_BFs7i, BFs7s_BFs7ll_BFs7c_BFs7i)
//============================================================================


struct  BFs7s_BFs7ll_BFs7c_BFs7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7c_BFs7ll) C1{ Fs:7 FL:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7ll_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7c_BFs7ll, BFs7s_BFs7ll_BFs7c_BFs7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFs7c_BFs7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7c_BFs7s) C1{ Fs:7 FL:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7c_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7c_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7c_BFs7s, BFs7s_BFs7ll_BFs7c_BFs7s)
//============================================================================


struct  BFs7s_BFs7ll_BFs7c_BFu7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7c_BFu7c) C1{ Fs:7 FL:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7c_BFu7c, BFs7s_BFs7ll_BFs7c_BFu7c)
//============================================================================


struct  BFs7s_BFs7ll_BFs7c_BFu7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7c_BFu7i) C1{ Fs:7 FL:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7c_BFu7i, BFs7s_BFs7ll_BFs7c_BFu7i)
//============================================================================


struct  BFs7s_BFs7ll_BFs7c_BFu7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7c_BFu7ll) C1{ Fs:7 FL:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7ll_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7c_BFu7ll, BFs7s_BFs7ll_BFs7c_BFu7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFs7c_BFu7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7c_BFu7s) C1{ Fs:7 FL:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7c_BFu7s, BFs7s_BFs7ll_BFs7c_BFu7s)
//============================================================================


struct  BFs7s_BFs7ll_BFs7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed int v3:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7i) C1{ Fs:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7i, BFs7s_BFs7ll_BFs7i)
//============================================================================


struct  BFs7s_BFs7ll_BFs7i_BFs7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7i_BFs7c) C1{ Fs:7 FL:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7i_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7i_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7i_BFs7c, BFs7s_BFs7ll_BFs7i_BFs7c)
//============================================================================


struct  BFs7s_BFs7ll_BFs7i_BFs7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7i_BFs7i) C1{ Fs:7 FL:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7i_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7i_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7i_BFs7i, BFs7s_BFs7ll_BFs7i_BFs7i)
//============================================================================


struct  BFs7s_BFs7ll_BFs7i_BFs7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7i_BFs7ll) C1{ Fs:7 FL:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7ll_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7i_BFs7ll, BFs7s_BFs7ll_BFs7i_BFs7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFs7i_BFs7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7i_BFs7s) C1{ Fs:7 FL:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7i_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7i_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7i_BFs7s, BFs7s_BFs7ll_BFs7i_BFs7s)
//============================================================================


struct  BFs7s_BFs7ll_BFs7i_BFu7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7i_BFu7c) C1{ Fs:7 FL:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7i_BFu7c, BFs7s_BFs7ll_BFs7i_BFu7c)
//============================================================================


struct  BFs7s_BFs7ll_BFs7i_BFu7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7i_BFu7i) C1{ Fs:7 FL:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7i_BFu7i, BFs7s_BFs7ll_BFs7i_BFu7i)
//============================================================================


struct  BFs7s_BFs7ll_BFs7i_BFu7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7i_BFu7ll) C1{ Fs:7 FL:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7ll_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7i_BFu7ll, BFs7s_BFs7ll_BFs7i_BFu7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFs7i_BFu7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7i_BFu7s) C1{ Fs:7 FL:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7i_BFu7s, BFs7s_BFs7ll_BFs7i_BFu7s)
//============================================================================


struct  BFs7s_BFs7ll_BFs7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed __tsi64 v3:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7ll) C1{ Fs:7 FL:7 FL:7}



static void Test_BFs7s_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7ll, BFs7s_BFs7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFs7ll_BFs7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed __tsi64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7ll_BFs7c) C1{ Fs:7 FL:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7ll_BFs7c, BFs7s_BFs7ll_BFs7ll_BFs7c)
//============================================================================


struct  BFs7s_BFs7ll_BFs7ll_BFs7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed __tsi64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7ll_BFs7i) C1{ Fs:7 FL:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7ll_BFs7i, BFs7s_BFs7ll_BFs7ll_BFs7i)
//============================================================================


struct  BFs7s_BFs7ll_BFs7ll_BFs7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed __tsi64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7ll_BFs7ll) C1{ Fs:7 FL:7 FL:7 FL:7}



static void Test_BFs7s_BFs7ll_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7ll_BFs7ll, BFs7s_BFs7ll_BFs7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFs7ll_BFs7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed __tsi64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7ll_BFs7s) C1{ Fs:7 FL:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7ll_BFs7s, BFs7s_BFs7ll_BFs7ll_BFs7s)
//============================================================================


struct  BFs7s_BFs7ll_BFs7ll_BFu7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed __tsi64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7ll_BFu7c) C1{ Fs:7 FL:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7ll_BFu7c, BFs7s_BFs7ll_BFs7ll_BFu7c)
//============================================================================


struct  BFs7s_BFs7ll_BFs7ll_BFu7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed __tsi64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7ll_BFu7i) C1{ Fs:7 FL:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7ll_BFu7i, BFs7s_BFs7ll_BFs7ll_BFu7i)
//============================================================================


struct  BFs7s_BFs7ll_BFs7ll_BFu7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed __tsi64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7ll_BFu7ll) C1{ Fs:7 FL:7 FL:7 FL:7}



static void Test_BFs7s_BFs7ll_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7ll_BFu7ll, BFs7s_BFs7ll_BFs7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFs7ll_BFu7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed __tsi64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7ll_BFu7s) C1{ Fs:7 FL:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7ll_BFu7s, BFs7s_BFs7ll_BFs7ll_BFu7s)
//============================================================================


struct  BFs7s_BFs7ll_BFs7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed short v3:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7s) C1{ Fs:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7s, BFs7s_BFs7ll_BFs7s)
//============================================================================


struct  BFs7s_BFs7ll_BFs7s_BFs7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7s_BFs7c) C1{ Fs:7 FL:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7s_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7s_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7s_BFs7c, BFs7s_BFs7ll_BFs7s_BFs7c)
//============================================================================


struct  BFs7s_BFs7ll_BFs7s_BFs7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7s_BFs7i) C1{ Fs:7 FL:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7s_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7s_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7s_BFs7i, BFs7s_BFs7ll_BFs7s_BFs7i)
//============================================================================


struct  BFs7s_BFs7ll_BFs7s_BFs7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7s_BFs7ll) C1{ Fs:7 FL:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7ll_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7s_BFs7ll, BFs7s_BFs7ll_BFs7s_BFs7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFs7s_BFs7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7s_BFs7s) C1{ Fs:7 FL:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7s_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7s_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7s_BFs7s, BFs7s_BFs7ll_BFs7s_BFs7s)
//============================================================================


struct  BFs7s_BFs7ll_BFs7s_BFu7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7s_BFu7c) C1{ Fs:7 FL:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7s_BFu7c, BFs7s_BFs7ll_BFs7s_BFu7c)
//============================================================================


struct  BFs7s_BFs7ll_BFs7s_BFu7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7s_BFu7i) C1{ Fs:7 FL:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7s_BFu7i, BFs7s_BFs7ll_BFs7s_BFu7i)
//============================================================================


struct  BFs7s_BFs7ll_BFs7s_BFu7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7s_BFu7ll) C1{ Fs:7 FL:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7ll_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7s_BFu7ll, BFs7s_BFs7ll_BFs7s_BFu7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFs7s_BFu7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  signed short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFs7s_BFu7s) C1{ Fs:7 FL:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFs7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFs7s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFs7s_BFu7s, BFs7s_BFs7ll_BFs7s_BFu7s)
//============================================================================


struct  BFs7s_BFs7ll_BFu7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned char v3:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7c) C1{ Fs:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7c, BFs7s_BFs7ll_BFu7c)
//============================================================================


struct  BFs7s_BFs7ll_BFu7c_BFs7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7c_BFs7c) C1{ Fs:7 FL:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7c_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7c_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7c_BFs7c, BFs7s_BFs7ll_BFu7c_BFs7c)
//============================================================================


struct  BFs7s_BFs7ll_BFu7c_BFs7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7c_BFs7i) C1{ Fs:7 FL:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7c_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7c_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7c_BFs7i, BFs7s_BFs7ll_BFu7c_BFs7i)
//============================================================================


struct  BFs7s_BFs7ll_BFu7c_BFs7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7c_BFs7ll) C1{ Fs:7 FL:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7ll_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7c_BFs7ll, BFs7s_BFs7ll_BFu7c_BFs7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFu7c_BFs7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7c_BFs7s) C1{ Fs:7 FL:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7c_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7c_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7c_BFs7s, BFs7s_BFs7ll_BFu7c_BFs7s)
//============================================================================


struct  BFs7s_BFs7ll_BFu7c_BFu7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7c_BFu7c) C1{ Fs:7 FL:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7c_BFu7c, BFs7s_BFs7ll_BFu7c_BFu7c)
//============================================================================


struct  BFs7s_BFs7ll_BFu7c_BFu7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7c_BFu7i) C1{ Fs:7 FL:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7c_BFu7i, BFs7s_BFs7ll_BFu7c_BFu7i)
//============================================================================


struct  BFs7s_BFs7ll_BFu7c_BFu7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7c_BFu7ll) C1{ Fs:7 FL:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7ll_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7c_BFu7ll, BFs7s_BFs7ll_BFu7c_BFu7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFu7c_BFu7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7c_BFu7s) C1{ Fs:7 FL:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7c_BFu7s, BFs7s_BFs7ll_BFu7c_BFu7s)
//============================================================================


struct  BFs7s_BFs7ll_BFu7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned int v3:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7i) C1{ Fs:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7i, BFs7s_BFs7ll_BFu7i)
//============================================================================


struct  BFs7s_BFs7ll_BFu7i_BFs7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7i_BFs7c) C1{ Fs:7 FL:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7i_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7i_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7i_BFs7c, BFs7s_BFs7ll_BFu7i_BFs7c)
//============================================================================


struct  BFs7s_BFs7ll_BFu7i_BFs7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7i_BFs7i) C1{ Fs:7 FL:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7i_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7i_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7i_BFs7i, BFs7s_BFs7ll_BFu7i_BFs7i)
//============================================================================


struct  BFs7s_BFs7ll_BFu7i_BFs7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7i_BFs7ll) C1{ Fs:7 FL:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7ll_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7i_BFs7ll, BFs7s_BFs7ll_BFu7i_BFs7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFu7i_BFs7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7i_BFs7s) C1{ Fs:7 FL:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7i_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7i_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7i_BFs7s, BFs7s_BFs7ll_BFu7i_BFs7s)
//============================================================================


struct  BFs7s_BFs7ll_BFu7i_BFu7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7i_BFu7c) C1{ Fs:7 FL:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7i_BFu7c, BFs7s_BFs7ll_BFu7i_BFu7c)
//============================================================================


struct  BFs7s_BFs7ll_BFu7i_BFu7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7i_BFu7i) C1{ Fs:7 FL:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7i_BFu7i, BFs7s_BFs7ll_BFu7i_BFu7i)
//============================================================================


struct  BFs7s_BFs7ll_BFu7i_BFu7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7i_BFu7ll) C1{ Fs:7 FL:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7ll_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7i_BFu7ll, BFs7s_BFs7ll_BFu7i_BFu7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFu7i_BFu7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7i_BFu7s) C1{ Fs:7 FL:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7i_BFu7s, BFs7s_BFs7ll_BFu7i_BFu7s)
//============================================================================


struct  BFs7s_BFs7ll_BFu7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7ll) C1{ Fs:7 FL:7 FL:7}



static void Test_BFs7s_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7ll, BFs7s_BFs7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFu7ll_BFs7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  __tsu64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7ll_BFs7c) C1{ Fs:7 FL:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7ll_BFs7c, BFs7s_BFs7ll_BFu7ll_BFs7c)
//============================================================================


struct  BFs7s_BFs7ll_BFu7ll_BFs7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  __tsu64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7ll_BFs7i) C1{ Fs:7 FL:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7ll_BFs7i, BFs7s_BFs7ll_BFu7ll_BFs7i)
//============================================================================


struct  BFs7s_BFs7ll_BFu7ll_BFs7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  __tsu64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7ll_BFs7ll) C1{ Fs:7 FL:7 FL:7 FL:7}



static void Test_BFs7s_BFs7ll_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7ll_BFs7ll, BFs7s_BFs7ll_BFu7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFu7ll_BFs7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  __tsu64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7ll_BFs7s) C1{ Fs:7 FL:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7ll_BFs7s, BFs7s_BFs7ll_BFu7ll_BFs7s)
//============================================================================


struct  BFs7s_BFs7ll_BFu7ll_BFu7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  __tsu64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7ll_BFu7c) C1{ Fs:7 FL:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7ll_BFu7c, BFs7s_BFs7ll_BFu7ll_BFu7c)
//============================================================================


struct  BFs7s_BFs7ll_BFu7ll_BFu7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  __tsu64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7ll_BFu7i) C1{ Fs:7 FL:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7ll_BFu7i, BFs7s_BFs7ll_BFu7ll_BFu7i)
//============================================================================


struct  BFs7s_BFs7ll_BFu7ll_BFu7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  __tsu64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7ll_BFu7ll) C1{ Fs:7 FL:7 FL:7 FL:7}



static void Test_BFs7s_BFs7ll_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7ll_BFu7ll, BFs7s_BFs7ll_BFu7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFu7ll_BFu7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  __tsu64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7ll_BFu7s) C1{ Fs:7 FL:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7ll_BFu7s, BFs7s_BFs7ll_BFu7ll_BFu7s)
//============================================================================


struct  BFs7s_BFs7ll_BFu7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned short v3:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7s) C1{ Fs:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7s, BFs7s_BFs7ll_BFu7s)
//============================================================================


struct  BFs7s_BFs7ll_BFu7s_BFs7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7s_BFs7c) C1{ Fs:7 FL:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7s_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7s_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7s_BFs7c, BFs7s_BFs7ll_BFu7s_BFs7c)
//============================================================================


struct  BFs7s_BFs7ll_BFu7s_BFs7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7s_BFs7i) C1{ Fs:7 FL:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7s_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7s_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7s_BFs7i, BFs7s_BFs7ll_BFu7s_BFs7i)
//============================================================================


struct  BFs7s_BFs7ll_BFu7s_BFs7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7s_BFs7ll) C1{ Fs:7 FL:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7ll_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7s_BFs7ll, BFs7s_BFs7ll_BFu7s_BFs7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFu7s_BFs7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7s_BFs7s) C1{ Fs:7 FL:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7s_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7s_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7s_BFs7s, BFs7s_BFs7ll_BFu7s_BFs7s)
//============================================================================


struct  BFs7s_BFs7ll_BFu7s_BFu7c  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7s_BFu7c) C1{ Fs:7 FL:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7ll_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7s_BFu7c, BFs7s_BFs7ll_BFu7s_BFu7c)
//============================================================================


struct  BFs7s_BFs7ll_BFu7s_BFu7i  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7s_BFu7i) C1{ Fs:7 FL:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7ll_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7s_BFu7i, BFs7s_BFs7ll_BFu7s_BFu7i)
//============================================================================


struct  BFs7s_BFs7ll_BFu7s_BFu7ll  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7s_BFu7ll) C1{ Fs:7 FL:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7ll_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7s_BFu7ll, BFs7s_BFs7ll_BFu7s_BFu7ll)
//============================================================================


struct  BFs7s_BFs7ll_BFu7s_BFu7s  {
  signed short v1:7;
  signed __tsi64 v2:7;
  unsigned short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7ll_BFu7s_BFu7s) C1{ Fs:7 FL:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7ll_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7ll_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7ll_BFu7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7ll_BFu7s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7ll_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7ll_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7ll_BFu7s_BFu7s, BFs7s_BFs7ll_BFu7s_BFu7s)
//============================================================================


struct  BFs7s_BFs7s  {
  signed short v1:7;
  signed short v2:7;
};
//SIG(1 BFs7s_BFs7s) C1{ Fs:7 Fs:7}



static void Test_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7s lv;
    check2(sizeof(lv), 2, "sizeof(BFs7s_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s, BFs7s_BFs7s)
//============================================================================


struct  BFs7s_BFs7s_BFs7c  {
  signed short v1:7;
  signed short v2:7;
  signed char v3:7;
};
//SIG(1 BFs7s_BFs7s_BFs7c) C1{ Fs:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7c, BFs7s_BFs7s_BFs7c)
//============================================================================


struct  BFs7s_BFs7s_BFs7c_BFs7c  {
  signed short v1:7;
  signed short v2:7;
  signed char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7c_BFs7c) C1{ Fs:7 Fs:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7s_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7c_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7c_BFs7c, BFs7s_BFs7s_BFs7c_BFs7c)
//============================================================================


struct  BFs7s_BFs7s_BFs7c_BFs7i  {
  signed short v1:7;
  signed short v2:7;
  signed char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7c_BFs7i) C1{ Fs:7 Fs:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7s_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7c_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7c_BFs7i, BFs7s_BFs7s_BFs7c_BFs7i)
//============================================================================


struct  BFs7s_BFs7s_BFs7c_BFs7ll  {
  signed short v1:7;
  signed short v2:7;
  signed char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7c_BFs7ll) C1{ Fs:7 Fs:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7s_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7c_BFs7ll, BFs7s_BFs7s_BFs7c_BFs7ll)
//============================================================================


struct  BFs7s_BFs7s_BFs7c_BFs7s  {
  signed short v1:7;
  signed short v2:7;
  signed char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7c_BFs7s) C1{ Fs:7 Fs:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7s_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7c_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7c_BFs7s, BFs7s_BFs7s_BFs7c_BFs7s)
//============================================================================


struct  BFs7s_BFs7s_BFs7c_BFu7c  {
  signed short v1:7;
  signed short v2:7;
  signed char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7c_BFu7c) C1{ Fs:7 Fs:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7s_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7c_BFu7c, BFs7s_BFs7s_BFs7c_BFu7c)
//============================================================================


struct  BFs7s_BFs7s_BFs7c_BFu7i  {
  signed short v1:7;
  signed short v2:7;
  signed char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7c_BFu7i) C1{ Fs:7 Fs:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7s_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7c_BFu7i, BFs7s_BFs7s_BFs7c_BFu7i)
//============================================================================


struct  BFs7s_BFs7s_BFs7c_BFu7ll  {
  signed short v1:7;
  signed short v2:7;
  signed char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7c_BFu7ll) C1{ Fs:7 Fs:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7s_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7c_BFu7ll, BFs7s_BFs7s_BFs7c_BFu7ll)
//============================================================================


struct  BFs7s_BFs7s_BFs7c_BFu7s  {
  signed short v1:7;
  signed short v2:7;
  signed char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7c_BFu7s) C1{ Fs:7 Fs:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7s_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7c_BFu7s, BFs7s_BFs7s_BFs7c_BFu7s)
//============================================================================


struct  BFs7s_BFs7s_BFs7i  {
  signed short v1:7;
  signed short v2:7;
  signed int v3:7;
};
//SIG(1 BFs7s_BFs7s_BFs7i) C1{ Fs:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7i, BFs7s_BFs7s_BFs7i)
//============================================================================


struct  BFs7s_BFs7s_BFs7i_BFs7c  {
  signed short v1:7;
  signed short v2:7;
  signed int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7i_BFs7c) C1{ Fs:7 Fs:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7s_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7i_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7i_BFs7c, BFs7s_BFs7s_BFs7i_BFs7c)
//============================================================================


struct  BFs7s_BFs7s_BFs7i_BFs7i  {
  signed short v1:7;
  signed short v2:7;
  signed int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7i_BFs7i) C1{ Fs:7 Fs:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7s_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7i_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7i_BFs7i, BFs7s_BFs7s_BFs7i_BFs7i)
//============================================================================


struct  BFs7s_BFs7s_BFs7i_BFs7ll  {
  signed short v1:7;
  signed short v2:7;
  signed int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7i_BFs7ll) C1{ Fs:7 Fs:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7s_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7i_BFs7ll, BFs7s_BFs7s_BFs7i_BFs7ll)
//============================================================================


struct  BFs7s_BFs7s_BFs7i_BFs7s  {
  signed short v1:7;
  signed short v2:7;
  signed int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7i_BFs7s) C1{ Fs:7 Fs:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7s_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7i_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7i_BFs7s, BFs7s_BFs7s_BFs7i_BFs7s)
//============================================================================


struct  BFs7s_BFs7s_BFs7i_BFu7c  {
  signed short v1:7;
  signed short v2:7;
  signed int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7i_BFu7c) C1{ Fs:7 Fs:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7s_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7i_BFu7c, BFs7s_BFs7s_BFs7i_BFu7c)
//============================================================================


struct  BFs7s_BFs7s_BFs7i_BFu7i  {
  signed short v1:7;
  signed short v2:7;
  signed int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7i_BFu7i) C1{ Fs:7 Fs:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7s_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7i_BFu7i, BFs7s_BFs7s_BFs7i_BFu7i)
//============================================================================


struct  BFs7s_BFs7s_BFs7i_BFu7ll  {
  signed short v1:7;
  signed short v2:7;
  signed int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7i_BFu7ll) C1{ Fs:7 Fs:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7s_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7i_BFu7ll, BFs7s_BFs7s_BFs7i_BFu7ll)
//============================================================================


struct  BFs7s_BFs7s_BFs7i_BFu7s  {
  signed short v1:7;
  signed short v2:7;
  signed int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7i_BFu7s) C1{ Fs:7 Fs:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7s_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7i_BFu7s, BFs7s_BFs7s_BFs7i_BFu7s)
//============================================================================


struct  BFs7s_BFs7s_BFs7ll  {
  signed short v1:7;
  signed short v2:7;
  signed __tsi64 v3:7;
};
//SIG(1 BFs7s_BFs7s_BFs7ll) C1{ Fs:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7ll, BFs7s_BFs7s_BFs7ll)
//============================================================================


struct  BFs7s_BFs7s_BFs7ll_BFs7c  {
  signed short v1:7;
  signed short v2:7;
  signed __tsi64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7ll_BFs7c) C1{ Fs:7 Fs:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7s_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7ll_BFs7c, BFs7s_BFs7s_BFs7ll_BFs7c)
//============================================================================


struct  BFs7s_BFs7s_BFs7ll_BFs7i  {
  signed short v1:7;
  signed short v2:7;
  signed __tsi64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7ll_BFs7i) C1{ Fs:7 Fs:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7s_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7ll_BFs7i, BFs7s_BFs7s_BFs7ll_BFs7i)
//============================================================================


struct  BFs7s_BFs7s_BFs7ll_BFs7ll  {
  signed short v1:7;
  signed short v2:7;
  signed __tsi64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7ll_BFs7ll) C1{ Fs:7 Fs:7 FL:7 FL:7}



static void Test_BFs7s_BFs7s_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7ll_BFs7ll, BFs7s_BFs7s_BFs7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFs7s_BFs7ll_BFs7s  {
  signed short v1:7;
  signed short v2:7;
  signed __tsi64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7ll_BFs7s) C1{ Fs:7 Fs:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7s_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7ll_BFs7s, BFs7s_BFs7s_BFs7ll_BFs7s)
//============================================================================


struct  BFs7s_BFs7s_BFs7ll_BFu7c  {
  signed short v1:7;
  signed short v2:7;
  signed __tsi64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7ll_BFu7c) C1{ Fs:7 Fs:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7s_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7ll_BFu7c, BFs7s_BFs7s_BFs7ll_BFu7c)
//============================================================================


struct  BFs7s_BFs7s_BFs7ll_BFu7i  {
  signed short v1:7;
  signed short v2:7;
  signed __tsi64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7ll_BFu7i) C1{ Fs:7 Fs:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7s_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7ll_BFu7i, BFs7s_BFs7s_BFs7ll_BFu7i)
//============================================================================


struct  BFs7s_BFs7s_BFs7ll_BFu7ll  {
  signed short v1:7;
  signed short v2:7;
  signed __tsi64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7ll_BFu7ll) C1{ Fs:7 Fs:7 FL:7 FL:7}



static void Test_BFs7s_BFs7s_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7ll_BFu7ll, BFs7s_BFs7s_BFs7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFs7s_BFs7ll_BFu7s  {
  signed short v1:7;
  signed short v2:7;
  signed __tsi64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7ll_BFu7s) C1{ Fs:7 Fs:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7s_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7ll_BFu7s, BFs7s_BFs7s_BFs7ll_BFu7s)
//============================================================================


struct  BFs7s_BFs7s_BFs7s  {
  signed short v1:7;
  signed short v2:7;
  signed short v3:7;
};
//SIG(1 BFs7s_BFs7s_BFs7s) C1{ Fs:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7s, BFs7s_BFs7s_BFs7s)
//============================================================================


struct  BFs7s_BFs7s_BFs7s_BFs7c  {
  signed short v1:7;
  signed short v2:7;
  signed short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7s_BFs7c) C1{ Fs:7 Fs:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7s_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7s_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7s_BFs7c, BFs7s_BFs7s_BFs7s_BFs7c)
//============================================================================


struct  BFs7s_BFs7s_BFs7s_BFs7i  {
  signed short v1:7;
  signed short v2:7;
  signed short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7s_BFs7i) C1{ Fs:7 Fs:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7s_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7s_BFs7i, BFs7s_BFs7s_BFs7s_BFs7i)
//============================================================================


struct  BFs7s_BFs7s_BFs7s_BFs7ll  {
  signed short v1:7;
  signed short v2:7;
  signed short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7s_BFs7ll) C1{ Fs:7 Fs:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7s_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7s_BFs7ll, BFs7s_BFs7s_BFs7s_BFs7ll)
//============================================================================


struct  BFs7s_BFs7s_BFs7s_BFs7s  {
  signed short v1:7;
  signed short v2:7;
  signed short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7s_BFs7s) C1{ Fs:7 Fs:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7s_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7s_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7s_BFs7s, BFs7s_BFs7s_BFs7s_BFs7s)
//============================================================================


struct  BFs7s_BFs7s_BFs7s_BFu7c  {
  signed short v1:7;
  signed short v2:7;
  signed short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7s_BFu7c) C1{ Fs:7 Fs:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7s_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7s_BFu7c, BFs7s_BFs7s_BFs7s_BFu7c)
//============================================================================


struct  BFs7s_BFs7s_BFs7s_BFu7i  {
  signed short v1:7;
  signed short v2:7;
  signed short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7s_BFu7i) C1{ Fs:7 Fs:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7s_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7s_BFu7i, BFs7s_BFs7s_BFs7s_BFu7i)
//============================================================================


struct  BFs7s_BFs7s_BFs7s_BFu7ll  {
  signed short v1:7;
  signed short v2:7;
  signed short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7s_BFu7ll) C1{ Fs:7 Fs:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7s_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFs7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7s_BFu7ll, BFs7s_BFs7s_BFs7s_BFu7ll)
//============================================================================


struct  BFs7s_BFs7s_BFs7s_BFu7s  {
  signed short v1:7;
  signed short v2:7;
  signed short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFs7s_BFu7s) C1{ Fs:7 Fs:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7s_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFs7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFs7s_BFu7s, BFs7s_BFs7s_BFs7s_BFu7s)
//============================================================================


struct  BFs7s_BFs7s_BFu7c  {
  signed short v1:7;
  signed short v2:7;
  unsigned char v3:7;
};
//SIG(1 BFs7s_BFs7s_BFu7c) C1{ Fs:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7c, BFs7s_BFs7s_BFu7c)
//============================================================================


struct  BFs7s_BFs7s_BFu7c_BFs7c  {
  signed short v1:7;
  signed short v2:7;
  unsigned char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7c_BFs7c) C1{ Fs:7 Fs:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7s_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7c_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7c_BFs7c, BFs7s_BFs7s_BFu7c_BFs7c)
//============================================================================


struct  BFs7s_BFs7s_BFu7c_BFs7i  {
  signed short v1:7;
  signed short v2:7;
  unsigned char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7c_BFs7i) C1{ Fs:7 Fs:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7s_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7c_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7c_BFs7i, BFs7s_BFs7s_BFu7c_BFs7i)
//============================================================================


struct  BFs7s_BFs7s_BFu7c_BFs7ll  {
  signed short v1:7;
  signed short v2:7;
  unsigned char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7c_BFs7ll) C1{ Fs:7 Fs:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7s_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7c_BFs7ll, BFs7s_BFs7s_BFu7c_BFs7ll)
//============================================================================


struct  BFs7s_BFs7s_BFu7c_BFs7s  {
  signed short v1:7;
  signed short v2:7;
  unsigned char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7c_BFs7s) C1{ Fs:7 Fs:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7s_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7c_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7c_BFs7s, BFs7s_BFs7s_BFu7c_BFs7s)
//============================================================================


struct  BFs7s_BFs7s_BFu7c_BFu7c  {
  signed short v1:7;
  signed short v2:7;
  unsigned char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7c_BFu7c) C1{ Fs:7 Fs:7 Fc:7 Fc:7}



static void Test_BFs7s_BFs7s_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7c_BFu7c, BFs7s_BFs7s_BFu7c_BFu7c)
//============================================================================


struct  BFs7s_BFs7s_BFu7c_BFu7i  {
  signed short v1:7;
  signed short v2:7;
  unsigned char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7c_BFu7i) C1{ Fs:7 Fs:7 Fc:7 Fi:7}



static void Test_BFs7s_BFs7s_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7c_BFu7i, BFs7s_BFs7s_BFu7c_BFu7i)
//============================================================================


struct  BFs7s_BFs7s_BFu7c_BFu7ll  {
  signed short v1:7;
  signed short v2:7;
  unsigned char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7c_BFu7ll) C1{ Fs:7 Fs:7 Fc:7 FL:7}



static void Test_BFs7s_BFs7s_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7c_BFu7ll, BFs7s_BFs7s_BFu7c_BFu7ll)
//============================================================================


struct  BFs7s_BFs7s_BFu7c_BFu7s  {
  signed short v1:7;
  signed short v2:7;
  unsigned char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7c_BFu7s) C1{ Fs:7 Fs:7 Fc:7 Fs:7}



static void Test_BFs7s_BFs7s_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7c_BFu7s, BFs7s_BFs7s_BFu7c_BFu7s)
//============================================================================


struct  BFs7s_BFs7s_BFu7i  {
  signed short v1:7;
  signed short v2:7;
  unsigned int v3:7;
};
//SIG(1 BFs7s_BFs7s_BFu7i) C1{ Fs:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7i, BFs7s_BFs7s_BFu7i)
//============================================================================


struct  BFs7s_BFs7s_BFu7i_BFs7c  {
  signed short v1:7;
  signed short v2:7;
  unsigned int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7i_BFs7c) C1{ Fs:7 Fs:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7s_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7i_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7i_BFs7c, BFs7s_BFs7s_BFu7i_BFs7c)
//============================================================================


struct  BFs7s_BFs7s_BFu7i_BFs7i  {
  signed short v1:7;
  signed short v2:7;
  unsigned int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7i_BFs7i) C1{ Fs:7 Fs:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7s_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7i_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7i_BFs7i, BFs7s_BFs7s_BFu7i_BFs7i)
//============================================================================


struct  BFs7s_BFs7s_BFu7i_BFs7ll  {
  signed short v1:7;
  signed short v2:7;
  unsigned int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7i_BFs7ll) C1{ Fs:7 Fs:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7s_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7i_BFs7ll, BFs7s_BFs7s_BFu7i_BFs7ll)
//============================================================================


struct  BFs7s_BFs7s_BFu7i_BFs7s  {
  signed short v1:7;
  signed short v2:7;
  unsigned int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7i_BFs7s) C1{ Fs:7 Fs:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7s_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7i_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7i_BFs7s, BFs7s_BFs7s_BFu7i_BFs7s)
//============================================================================


struct  BFs7s_BFs7s_BFu7i_BFu7c  {
  signed short v1:7;
  signed short v2:7;
  unsigned int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7i_BFu7c) C1{ Fs:7 Fs:7 Fi:7 Fc:7}



static void Test_BFs7s_BFs7s_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7i_BFu7c, BFs7s_BFs7s_BFu7i_BFu7c)
//============================================================================


struct  BFs7s_BFs7s_BFu7i_BFu7i  {
  signed short v1:7;
  signed short v2:7;
  unsigned int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7i_BFu7i) C1{ Fs:7 Fs:7 Fi:7 Fi:7}



static void Test_BFs7s_BFs7s_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7i_BFu7i, BFs7s_BFs7s_BFu7i_BFu7i)
//============================================================================


struct  BFs7s_BFs7s_BFu7i_BFu7ll  {
  signed short v1:7;
  signed short v2:7;
  unsigned int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7i_BFu7ll) C1{ Fs:7 Fs:7 Fi:7 FL:7}



static void Test_BFs7s_BFs7s_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7i_BFu7ll, BFs7s_BFs7s_BFu7i_BFu7ll)
//============================================================================


struct  BFs7s_BFs7s_BFu7i_BFu7s  {
  signed short v1:7;
  signed short v2:7;
  unsigned int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7i_BFu7s) C1{ Fs:7 Fs:7 Fi:7 Fs:7}



static void Test_BFs7s_BFs7s_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7i_BFu7s, BFs7s_BFs7s_BFu7i_BFu7s)
//============================================================================


struct  BFs7s_BFs7s_BFu7ll  {
  signed short v1:7;
  signed short v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFs7s_BFs7s_BFu7ll) C1{ Fs:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7ll, BFs7s_BFs7s_BFu7ll)
//============================================================================


struct  BFs7s_BFs7s_BFu7ll_BFs7c  {
  signed short v1:7;
  signed short v2:7;
  __tsu64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7ll_BFs7c) C1{ Fs:7 Fs:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7s_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7ll_BFs7c, BFs7s_BFs7s_BFu7ll_BFs7c)
//============================================================================


struct  BFs7s_BFs7s_BFu7ll_BFs7i  {
  signed short v1:7;
  signed short v2:7;
  __tsu64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7ll_BFs7i) C1{ Fs:7 Fs:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7s_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7ll_BFs7i, BFs7s_BFs7s_BFu7ll_BFs7i)
//============================================================================


struct  BFs7s_BFs7s_BFu7ll_BFs7ll  {
  signed short v1:7;
  signed short v2:7;
  __tsu64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7ll_BFs7ll) C1{ Fs:7 Fs:7 FL:7 FL:7}



static void Test_BFs7s_BFs7s_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7ll_BFs7ll, BFs7s_BFs7s_BFu7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFs7s_BFu7ll_BFs7s  {
  signed short v1:7;
  signed short v2:7;
  __tsu64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7ll_BFs7s) C1{ Fs:7 Fs:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7s_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7ll_BFs7s, BFs7s_BFs7s_BFu7ll_BFs7s)
//============================================================================


struct  BFs7s_BFs7s_BFu7ll_BFu7c  {
  signed short v1:7;
  signed short v2:7;
  __tsu64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7ll_BFu7c) C1{ Fs:7 Fs:7 FL:7 Fc:7}



static void Test_BFs7s_BFs7s_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7ll_BFu7c, BFs7s_BFs7s_BFu7ll_BFu7c)
//============================================================================


struct  BFs7s_BFs7s_BFu7ll_BFu7i  {
  signed short v1:7;
  signed short v2:7;
  __tsu64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7ll_BFu7i) C1{ Fs:7 Fs:7 FL:7 Fi:7}



static void Test_BFs7s_BFs7s_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7ll_BFu7i, BFs7s_BFs7s_BFu7ll_BFu7i)
//============================================================================


struct  BFs7s_BFs7s_BFu7ll_BFu7ll  {
  signed short v1:7;
  signed short v2:7;
  __tsu64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7ll_BFu7ll) C1{ Fs:7 Fs:7 FL:7 FL:7}



static void Test_BFs7s_BFs7s_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7ll_BFu7ll, BFs7s_BFs7s_BFu7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFs7s_BFu7ll_BFu7s  {
  signed short v1:7;
  signed short v2:7;
  __tsu64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7ll_BFu7s) C1{ Fs:7 Fs:7 FL:7 Fs:7}



static void Test_BFs7s_BFs7s_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7ll_BFu7s, BFs7s_BFs7s_BFu7ll_BFu7s)
//============================================================================


struct  BFs7s_BFs7s_BFu7s  {
  signed short v1:7;
  signed short v2:7;
  unsigned short v3:7;
};
//SIG(1 BFs7s_BFs7s_BFu7s) C1{ Fs:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7s, BFs7s_BFs7s_BFu7s)
//============================================================================


struct  BFs7s_BFs7s_BFu7s_BFs7c  {
  signed short v1:7;
  signed short v2:7;
  unsigned short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7s_BFs7c) C1{ Fs:7 Fs:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7s_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7s_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7s_BFs7c, BFs7s_BFs7s_BFu7s_BFs7c)
//============================================================================


struct  BFs7s_BFs7s_BFu7s_BFs7i  {
  signed short v1:7;
  signed short v2:7;
  unsigned short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7s_BFs7i) C1{ Fs:7 Fs:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7s_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7s_BFs7i, BFs7s_BFs7s_BFu7s_BFs7i)
//============================================================================


struct  BFs7s_BFs7s_BFu7s_BFs7ll  {
  signed short v1:7;
  signed short v2:7;
  unsigned short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7s_BFs7ll) C1{ Fs:7 Fs:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7s_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7s_BFs7ll, BFs7s_BFs7s_BFu7s_BFs7ll)
//============================================================================


struct  BFs7s_BFs7s_BFu7s_BFs7s  {
  signed short v1:7;
  signed short v2:7;
  unsigned short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7s_BFs7s) C1{ Fs:7 Fs:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7s_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7s_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7s_BFs7s, BFs7s_BFs7s_BFu7s_BFs7s)
//============================================================================


struct  BFs7s_BFs7s_BFu7s_BFu7c  {
  signed short v1:7;
  signed short v2:7;
  unsigned short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7s_BFu7c) C1{ Fs:7 Fs:7 Fs:7 Fc:7}



static void Test_BFs7s_BFs7s_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7s_BFu7c, BFs7s_BFs7s_BFu7s_BFu7c)
//============================================================================


struct  BFs7s_BFs7s_BFu7s_BFu7i  {
  signed short v1:7;
  signed short v2:7;
  unsigned short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7s_BFu7i) C1{ Fs:7 Fs:7 Fs:7 Fi:7}



static void Test_BFs7s_BFs7s_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFs7s_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7s_BFu7i, BFs7s_BFs7s_BFu7s_BFu7i)
//============================================================================


struct  BFs7s_BFs7s_BFu7s_BFu7ll  {
  signed short v1:7;
  signed short v2:7;
  unsigned short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7s_BFu7ll) C1{ Fs:7 Fs:7 Fs:7 FL:7}



static void Test_BFs7s_BFs7s_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFs7s_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFs7s_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7s_BFu7ll, BFs7s_BFs7s_BFu7s_BFu7ll)
//============================================================================


struct  BFs7s_BFs7s_BFu7s_BFu7s  {
  signed short v1:7;
  signed short v2:7;
  unsigned short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFs7s_BFu7s_BFu7s) C1{ Fs:7 Fs:7 Fs:7 Fs:7}



static void Test_BFs7s_BFs7s_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFs7s_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFs7s_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFs7s_BFu7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFs7s_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_sll(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFs7s_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFs7s_BFu7s_BFu7s, BFs7s_BFs7s_BFu7s_BFu7s)
//============================================================================


struct  BFs7s_BFu7c  {
  signed short v1:7;
  unsigned char v2:7;
};
//SIG(1 BFs7s_BFu7c) C1{ Fs:7 Fc:7}



static void Test_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(BFs7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c, BFs7s_BFu7c)
//============================================================================


struct  BFs7s_BFu7c_BFs7c  {
  signed short v1:7;
  unsigned char v2:7;
  signed char v3:7;
};
//SIG(1 BFs7s_BFu7c_BFs7c) C1{ Fs:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7c, BFs7s_BFu7c_BFs7c)
//============================================================================


struct  BFs7s_BFu7c_BFs7c_BFs7c  {
  signed short v1:7;
  unsigned char v2:7;
  signed char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7c_BFs7c) C1{ Fs:7 Fc:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7c_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7c_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7c_BFs7c, BFs7s_BFu7c_BFs7c_BFs7c)
//============================================================================


struct  BFs7s_BFu7c_BFs7c_BFs7i  {
  signed short v1:7;
  unsigned char v2:7;
  signed char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7c_BFs7i) C1{ Fs:7 Fc:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7c_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7c_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7c_BFs7i, BFs7s_BFu7c_BFs7c_BFs7i)
//============================================================================


struct  BFs7s_BFu7c_BFs7c_BFs7ll  {
  signed short v1:7;
  unsigned char v2:7;
  signed char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7c_BFs7ll) C1{ Fs:7 Fc:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7c_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7c_BFs7ll, BFs7s_BFu7c_BFs7c_BFs7ll)
//============================================================================


struct  BFs7s_BFu7c_BFs7c_BFs7s  {
  signed short v1:7;
  unsigned char v2:7;
  signed char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7c_BFs7s) C1{ Fs:7 Fc:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7c_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7c_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7c_BFs7s, BFs7s_BFu7c_BFs7c_BFs7s)
//============================================================================


struct  BFs7s_BFu7c_BFs7c_BFu7c  {
  signed short v1:7;
  unsigned char v2:7;
  signed char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7c_BFu7c) C1{ Fs:7 Fc:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7c_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7c_BFu7c, BFs7s_BFu7c_BFs7c_BFu7c)
//============================================================================


struct  BFs7s_BFu7c_BFs7c_BFu7i  {
  signed short v1:7;
  unsigned char v2:7;
  signed char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7c_BFu7i) C1{ Fs:7 Fc:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7c_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7c_BFu7i, BFs7s_BFu7c_BFs7c_BFu7i)
//============================================================================


struct  BFs7s_BFu7c_BFs7c_BFu7ll  {
  signed short v1:7;
  unsigned char v2:7;
  signed char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7c_BFu7ll) C1{ Fs:7 Fc:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7c_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7c_BFu7ll, BFs7s_BFu7c_BFs7c_BFu7ll)
//============================================================================


struct  BFs7s_BFu7c_BFs7c_BFu7s  {
  signed short v1:7;
  unsigned char v2:7;
  signed char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7c_BFu7s) C1{ Fs:7 Fc:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7c_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7c_BFu7s, BFs7s_BFu7c_BFs7c_BFu7s)
//============================================================================


struct  BFs7s_BFu7c_BFs7i  {
  signed short v1:7;
  unsigned char v2:7;
  signed int v3:7;
};
//SIG(1 BFs7s_BFu7c_BFs7i) C1{ Fs:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7i, BFs7s_BFu7c_BFs7i)
//============================================================================


struct  BFs7s_BFu7c_BFs7i_BFs7c  {
  signed short v1:7;
  unsigned char v2:7;
  signed int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7i_BFs7c) C1{ Fs:7 Fc:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7c_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7i_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7i_BFs7c, BFs7s_BFu7c_BFs7i_BFs7c)
//============================================================================


struct  BFs7s_BFu7c_BFs7i_BFs7i  {
  signed short v1:7;
  unsigned char v2:7;
  signed int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7i_BFs7i) C1{ Fs:7 Fc:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7c_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7i_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7i_BFs7i, BFs7s_BFu7c_BFs7i_BFs7i)
//============================================================================


struct  BFs7s_BFu7c_BFs7i_BFs7ll  {
  signed short v1:7;
  unsigned char v2:7;
  signed int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7i_BFs7ll) C1{ Fs:7 Fc:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7c_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7i_BFs7ll, BFs7s_BFu7c_BFs7i_BFs7ll)
//============================================================================


struct  BFs7s_BFu7c_BFs7i_BFs7s  {
  signed short v1:7;
  unsigned char v2:7;
  signed int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7i_BFs7s) C1{ Fs:7 Fc:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7c_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7i_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7i_BFs7s, BFs7s_BFu7c_BFs7i_BFs7s)
//============================================================================


struct  BFs7s_BFu7c_BFs7i_BFu7c  {
  signed short v1:7;
  unsigned char v2:7;
  signed int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7i_BFu7c) C1{ Fs:7 Fc:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7c_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7i_BFu7c, BFs7s_BFu7c_BFs7i_BFu7c)
//============================================================================


struct  BFs7s_BFu7c_BFs7i_BFu7i  {
  signed short v1:7;
  unsigned char v2:7;
  signed int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7i_BFu7i) C1{ Fs:7 Fc:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7c_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7i_BFu7i, BFs7s_BFu7c_BFs7i_BFu7i)
//============================================================================


struct  BFs7s_BFu7c_BFs7i_BFu7ll  {
  signed short v1:7;
  unsigned char v2:7;
  signed int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7i_BFu7ll) C1{ Fs:7 Fc:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7c_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7i_BFu7ll, BFs7s_BFu7c_BFs7i_BFu7ll)
//============================================================================


struct  BFs7s_BFu7c_BFs7i_BFu7s  {
  signed short v1:7;
  unsigned char v2:7;
  signed int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7i_BFu7s) C1{ Fs:7 Fc:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7c_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7i_BFu7s, BFs7s_BFu7c_BFs7i_BFu7s)
//============================================================================


struct  BFs7s_BFu7c_BFs7ll  {
  signed short v1:7;
  unsigned char v2:7;
  signed __tsi64 v3:7;
};
//SIG(1 BFs7s_BFu7c_BFs7ll) C1{ Fs:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7ll, BFs7s_BFu7c_BFs7ll)
//============================================================================


struct  BFs7s_BFu7c_BFs7ll_BFs7c  {
  signed short v1:7;
  unsigned char v2:7;
  signed __tsi64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7ll_BFs7c) C1{ Fs:7 Fc:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7c_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7ll_BFs7c, BFs7s_BFu7c_BFs7ll_BFs7c)
//============================================================================


struct  BFs7s_BFu7c_BFs7ll_BFs7i  {
  signed short v1:7;
  unsigned char v2:7;
  signed __tsi64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7ll_BFs7i) C1{ Fs:7 Fc:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7c_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7ll_BFs7i, BFs7s_BFu7c_BFs7ll_BFs7i)
//============================================================================


struct  BFs7s_BFu7c_BFs7ll_BFs7ll  {
  signed short v1:7;
  unsigned char v2:7;
  signed __tsi64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7ll_BFs7ll) C1{ Fs:7 Fc:7 FL:7 FL:7}



static void Test_BFs7s_BFu7c_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7ll_BFs7ll, BFs7s_BFu7c_BFs7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFu7c_BFs7ll_BFs7s  {
  signed short v1:7;
  unsigned char v2:7;
  signed __tsi64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7ll_BFs7s) C1{ Fs:7 Fc:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7c_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7ll_BFs7s, BFs7s_BFu7c_BFs7ll_BFs7s)
//============================================================================


struct  BFs7s_BFu7c_BFs7ll_BFu7c  {
  signed short v1:7;
  unsigned char v2:7;
  signed __tsi64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7ll_BFu7c) C1{ Fs:7 Fc:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7c_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7ll_BFu7c, BFs7s_BFu7c_BFs7ll_BFu7c)
//============================================================================


struct  BFs7s_BFu7c_BFs7ll_BFu7i  {
  signed short v1:7;
  unsigned char v2:7;
  signed __tsi64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7ll_BFu7i) C1{ Fs:7 Fc:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7c_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7ll_BFu7i, BFs7s_BFu7c_BFs7ll_BFu7i)
//============================================================================


struct  BFs7s_BFu7c_BFs7ll_BFu7ll  {
  signed short v1:7;
  unsigned char v2:7;
  signed __tsi64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7ll_BFu7ll) C1{ Fs:7 Fc:7 FL:7 FL:7}



static void Test_BFs7s_BFu7c_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7ll_BFu7ll, BFs7s_BFu7c_BFs7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFu7c_BFs7ll_BFu7s  {
  signed short v1:7;
  unsigned char v2:7;
  signed __tsi64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7ll_BFu7s) C1{ Fs:7 Fc:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7c_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7ll_BFu7s, BFs7s_BFu7c_BFs7ll_BFu7s)
//============================================================================


struct  BFs7s_BFu7c_BFs7s  {
  signed short v1:7;
  unsigned char v2:7;
  signed short v3:7;
};
//SIG(1 BFs7s_BFu7c_BFs7s) C1{ Fs:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7s, BFs7s_BFu7c_BFs7s)
//============================================================================


struct  BFs7s_BFu7c_BFs7s_BFs7c  {
  signed short v1:7;
  unsigned char v2:7;
  signed short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7s_BFs7c) C1{ Fs:7 Fc:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7c_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7s_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7s_BFs7c, BFs7s_BFu7c_BFs7s_BFs7c)
//============================================================================


struct  BFs7s_BFu7c_BFs7s_BFs7i  {
  signed short v1:7;
  unsigned char v2:7;
  signed short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7s_BFs7i) C1{ Fs:7 Fc:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7c_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7s_BFs7i, BFs7s_BFu7c_BFs7s_BFs7i)
//============================================================================


struct  BFs7s_BFu7c_BFs7s_BFs7ll  {
  signed short v1:7;
  unsigned char v2:7;
  signed short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7s_BFs7ll) C1{ Fs:7 Fc:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7c_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7s_BFs7ll, BFs7s_BFu7c_BFs7s_BFs7ll)
//============================================================================


struct  BFs7s_BFu7c_BFs7s_BFs7s  {
  signed short v1:7;
  unsigned char v2:7;
  signed short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7s_BFs7s) C1{ Fs:7 Fc:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7c_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7s_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7s_BFs7s, BFs7s_BFu7c_BFs7s_BFs7s)
//============================================================================


struct  BFs7s_BFu7c_BFs7s_BFu7c  {
  signed short v1:7;
  unsigned char v2:7;
  signed short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7s_BFu7c) C1{ Fs:7 Fc:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7c_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7s_BFu7c, BFs7s_BFu7c_BFs7s_BFu7c)
//============================================================================


struct  BFs7s_BFu7c_BFs7s_BFu7i  {
  signed short v1:7;
  unsigned char v2:7;
  signed short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7s_BFu7i) C1{ Fs:7 Fc:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7c_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7s_BFu7i, BFs7s_BFu7c_BFs7s_BFu7i)
//============================================================================


struct  BFs7s_BFu7c_BFs7s_BFu7ll  {
  signed short v1:7;
  unsigned char v2:7;
  signed short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7s_BFu7ll) C1{ Fs:7 Fc:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7c_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFs7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7s_BFu7ll, BFs7s_BFu7c_BFs7s_BFu7ll)
//============================================================================


struct  BFs7s_BFu7c_BFs7s_BFu7s  {
  signed short v1:7;
  unsigned char v2:7;
  signed short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFs7s_BFu7s) C1{ Fs:7 Fc:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7c_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFs7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFs7s_BFu7s, BFs7s_BFu7c_BFs7s_BFu7s)
//============================================================================


struct  BFs7s_BFu7c_BFu7c  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned char v3:7;
};
//SIG(1 BFs7s_BFu7c_BFu7c) C1{ Fs:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7c, BFs7s_BFu7c_BFu7c)
//============================================================================


struct  BFs7s_BFu7c_BFu7c_BFs7c  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7c_BFs7c) C1{ Fs:7 Fc:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7c_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7c_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7c_BFs7c, BFs7s_BFu7c_BFu7c_BFs7c)
//============================================================================


struct  BFs7s_BFu7c_BFu7c_BFs7i  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7c_BFs7i) C1{ Fs:7 Fc:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7c_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7c_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7c_BFs7i, BFs7s_BFu7c_BFu7c_BFs7i)
//============================================================================


struct  BFs7s_BFu7c_BFu7c_BFs7ll  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7c_BFs7ll) C1{ Fs:7 Fc:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7c_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7c_BFs7ll, BFs7s_BFu7c_BFu7c_BFs7ll)
//============================================================================


struct  BFs7s_BFu7c_BFu7c_BFs7s  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7c_BFs7s) C1{ Fs:7 Fc:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7c_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7c_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7c_BFs7s, BFs7s_BFu7c_BFu7c_BFs7s)
//============================================================================


struct  BFs7s_BFu7c_BFu7c_BFu7c  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7c_BFu7c) C1{ Fs:7 Fc:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7c_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7c_BFu7c, BFs7s_BFu7c_BFu7c_BFu7c)
//============================================================================


struct  BFs7s_BFu7c_BFu7c_BFu7i  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7c_BFu7i) C1{ Fs:7 Fc:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7c_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7c_BFu7i, BFs7s_BFu7c_BFu7c_BFu7i)
//============================================================================


struct  BFs7s_BFu7c_BFu7c_BFu7ll  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7c_BFu7ll) C1{ Fs:7 Fc:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7c_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7c_BFu7ll, BFs7s_BFu7c_BFu7c_BFu7ll)
//============================================================================


struct  BFs7s_BFu7c_BFu7c_BFu7s  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7c_BFu7s) C1{ Fs:7 Fc:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7c_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7c_BFu7s, BFs7s_BFu7c_BFu7c_BFu7s)
//============================================================================


struct  BFs7s_BFu7c_BFu7i  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned int v3:7;
};
//SIG(1 BFs7s_BFu7c_BFu7i) C1{ Fs:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7i, BFs7s_BFu7c_BFu7i)
//============================================================================


struct  BFs7s_BFu7c_BFu7i_BFs7c  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7i_BFs7c) C1{ Fs:7 Fc:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7c_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7i_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7i_BFs7c, BFs7s_BFu7c_BFu7i_BFs7c)
//============================================================================


struct  BFs7s_BFu7c_BFu7i_BFs7i  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7i_BFs7i) C1{ Fs:7 Fc:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7c_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7i_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7i_BFs7i, BFs7s_BFu7c_BFu7i_BFs7i)
//============================================================================


struct  BFs7s_BFu7c_BFu7i_BFs7ll  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7i_BFs7ll) C1{ Fs:7 Fc:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7c_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7i_BFs7ll, BFs7s_BFu7c_BFu7i_BFs7ll)
//============================================================================


struct  BFs7s_BFu7c_BFu7i_BFs7s  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7i_BFs7s) C1{ Fs:7 Fc:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7c_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7i_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7i_BFs7s, BFs7s_BFu7c_BFu7i_BFs7s)
//============================================================================


struct  BFs7s_BFu7c_BFu7i_BFu7c  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7i_BFu7c) C1{ Fs:7 Fc:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7c_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7i_BFu7c, BFs7s_BFu7c_BFu7i_BFu7c)
//============================================================================


struct  BFs7s_BFu7c_BFu7i_BFu7i  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7i_BFu7i) C1{ Fs:7 Fc:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7c_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7i_BFu7i, BFs7s_BFu7c_BFu7i_BFu7i)
//============================================================================


struct  BFs7s_BFu7c_BFu7i_BFu7ll  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7i_BFu7ll) C1{ Fs:7 Fc:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7c_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7i_BFu7ll, BFs7s_BFu7c_BFu7i_BFu7ll)
//============================================================================


struct  BFs7s_BFu7c_BFu7i_BFu7s  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7i_BFu7s) C1{ Fs:7 Fc:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7c_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7i_BFu7s, BFs7s_BFu7c_BFu7i_BFu7s)
//============================================================================


struct  BFs7s_BFu7c_BFu7ll  {
  signed short v1:7;
  unsigned char v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFs7s_BFu7c_BFu7ll) C1{ Fs:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7ll, BFs7s_BFu7c_BFu7ll)
//============================================================================


struct  BFs7s_BFu7c_BFu7ll_BFs7c  {
  signed short v1:7;
  unsigned char v2:7;
  __tsu64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7ll_BFs7c) C1{ Fs:7 Fc:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7c_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7ll_BFs7c, BFs7s_BFu7c_BFu7ll_BFs7c)
//============================================================================


struct  BFs7s_BFu7c_BFu7ll_BFs7i  {
  signed short v1:7;
  unsigned char v2:7;
  __tsu64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7ll_BFs7i) C1{ Fs:7 Fc:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7c_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7ll_BFs7i, BFs7s_BFu7c_BFu7ll_BFs7i)
//============================================================================


struct  BFs7s_BFu7c_BFu7ll_BFs7ll  {
  signed short v1:7;
  unsigned char v2:7;
  __tsu64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7ll_BFs7ll) C1{ Fs:7 Fc:7 FL:7 FL:7}



static void Test_BFs7s_BFu7c_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7ll_BFs7ll, BFs7s_BFu7c_BFu7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFu7c_BFu7ll_BFs7s  {
  signed short v1:7;
  unsigned char v2:7;
  __tsu64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7ll_BFs7s) C1{ Fs:7 Fc:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7c_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7ll_BFs7s, BFs7s_BFu7c_BFu7ll_BFs7s)
//============================================================================


struct  BFs7s_BFu7c_BFu7ll_BFu7c  {
  signed short v1:7;
  unsigned char v2:7;
  __tsu64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7ll_BFu7c) C1{ Fs:7 Fc:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7c_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7ll_BFu7c, BFs7s_BFu7c_BFu7ll_BFu7c)
//============================================================================


struct  BFs7s_BFu7c_BFu7ll_BFu7i  {
  signed short v1:7;
  unsigned char v2:7;
  __tsu64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7ll_BFu7i) C1{ Fs:7 Fc:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7c_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7ll_BFu7i, BFs7s_BFu7c_BFu7ll_BFu7i)
//============================================================================


struct  BFs7s_BFu7c_BFu7ll_BFu7ll  {
  signed short v1:7;
  unsigned char v2:7;
  __tsu64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7ll_BFu7ll) C1{ Fs:7 Fc:7 FL:7 FL:7}



static void Test_BFs7s_BFu7c_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7ll_BFu7ll, BFs7s_BFu7c_BFu7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFu7c_BFu7ll_BFu7s  {
  signed short v1:7;
  unsigned char v2:7;
  __tsu64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7ll_BFu7s) C1{ Fs:7 Fc:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7c_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, 1, "BFs7s_BFu7c_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7ll_BFu7s, BFs7s_BFu7c_BFu7ll_BFu7s)
//============================================================================


struct  BFs7s_BFu7c_BFu7s  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned short v3:7;
};
//SIG(1 BFs7s_BFu7c_BFu7s) C1{ Fs:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7s, BFs7s_BFu7c_BFu7s)
//============================================================================


struct  BFs7s_BFu7c_BFu7s_BFs7c  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7s_BFs7c) C1{ Fs:7 Fc:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7c_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7s_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7s_BFs7c, BFs7s_BFu7c_BFu7s_BFs7c)
//============================================================================


struct  BFs7s_BFu7c_BFu7s_BFs7i  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7s_BFs7i) C1{ Fs:7 Fc:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7c_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7s_BFs7i, BFs7s_BFu7c_BFu7s_BFs7i)
//============================================================================


struct  BFs7s_BFu7c_BFu7s_BFs7ll  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7s_BFs7ll) C1{ Fs:7 Fc:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7c_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7s_BFs7ll, BFs7s_BFu7c_BFu7s_BFs7ll)
//============================================================================


struct  BFs7s_BFu7c_BFu7s_BFs7s  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7s_BFs7s) C1{ Fs:7 Fc:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7c_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7s_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7s_BFs7s, BFs7s_BFu7c_BFu7s_BFs7s)
//============================================================================


struct  BFs7s_BFu7c_BFu7s_BFu7c  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7s_BFu7c) C1{ Fs:7 Fc:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7c_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7s_BFu7c, BFs7s_BFu7c_BFu7s_BFu7c)
//============================================================================


struct  BFs7s_BFu7c_BFu7s_BFu7i  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7s_BFu7i) C1{ Fs:7 Fc:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7c_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7c_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7s_BFu7i, BFs7s_BFu7c_BFu7s_BFu7i)
//============================================================================


struct  BFs7s_BFu7c_BFu7s_BFu7ll  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7s_BFu7ll) C1{ Fs:7 Fc:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7c_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7c_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7c_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7s_BFu7ll, BFs7s_BFu7c_BFu7s_BFu7ll)
//============================================================================


struct  BFs7s_BFu7c_BFu7s_BFu7s  {
  signed short v1:7;
  unsigned char v2:7;
  unsigned short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7c_BFu7s_BFu7s) C1{ Fs:7 Fc:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7c_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7c_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7c_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7c_BFu7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7c_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7c_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7c_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7c_BFu7s_BFu7s, BFs7s_BFu7c_BFu7s_BFu7s)
//============================================================================


struct  BFs7s_BFu7i  {
  signed short v1:7;
  unsigned int v2:7;
};
//SIG(1 BFs7s_BFu7i) C1{ Fs:7 Fi:7}



static void Test_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i, BFs7s_BFu7i)
//============================================================================


struct  BFs7s_BFu7i_BFs7c  {
  signed short v1:7;
  unsigned int v2:7;
  signed char v3:7;
};
//SIG(1 BFs7s_BFu7i_BFs7c) C1{ Fs:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7c, BFs7s_BFu7i_BFs7c)
//============================================================================


struct  BFs7s_BFu7i_BFs7c_BFs7c  {
  signed short v1:7;
  unsigned int v2:7;
  signed char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7c_BFs7c) C1{ Fs:7 Fi:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7i_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7c_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7c_BFs7c, BFs7s_BFu7i_BFs7c_BFs7c)
//============================================================================


struct  BFs7s_BFu7i_BFs7c_BFs7i  {
  signed short v1:7;
  unsigned int v2:7;
  signed char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7c_BFs7i) C1{ Fs:7 Fi:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7i_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7c_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7c_BFs7i, BFs7s_BFu7i_BFs7c_BFs7i)
//============================================================================


struct  BFs7s_BFu7i_BFs7c_BFs7ll  {
  signed short v1:7;
  unsigned int v2:7;
  signed char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7c_BFs7ll) C1{ Fs:7 Fi:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7i_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7c_BFs7ll, BFs7s_BFu7i_BFs7c_BFs7ll)
//============================================================================


struct  BFs7s_BFu7i_BFs7c_BFs7s  {
  signed short v1:7;
  unsigned int v2:7;
  signed char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7c_BFs7s) C1{ Fs:7 Fi:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7i_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7c_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7c_BFs7s, BFs7s_BFu7i_BFs7c_BFs7s)
//============================================================================


struct  BFs7s_BFu7i_BFs7c_BFu7c  {
  signed short v1:7;
  unsigned int v2:7;
  signed char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7c_BFu7c) C1{ Fs:7 Fi:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7i_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7c_BFu7c, BFs7s_BFu7i_BFs7c_BFu7c)
//============================================================================


struct  BFs7s_BFu7i_BFs7c_BFu7i  {
  signed short v1:7;
  unsigned int v2:7;
  signed char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7c_BFu7i) C1{ Fs:7 Fi:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7i_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7c_BFu7i, BFs7s_BFu7i_BFs7c_BFu7i)
//============================================================================


struct  BFs7s_BFu7i_BFs7c_BFu7ll  {
  signed short v1:7;
  unsigned int v2:7;
  signed char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7c_BFu7ll) C1{ Fs:7 Fi:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7i_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7c_BFu7ll, BFs7s_BFu7i_BFs7c_BFu7ll)
//============================================================================


struct  BFs7s_BFu7i_BFs7c_BFu7s  {
  signed short v1:7;
  unsigned int v2:7;
  signed char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7c_BFu7s) C1{ Fs:7 Fi:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7i_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7c_BFu7s, BFs7s_BFu7i_BFs7c_BFu7s)
//============================================================================


struct  BFs7s_BFu7i_BFs7i  {
  signed short v1:7;
  unsigned int v2:7;
  signed int v3:7;
};
//SIG(1 BFs7s_BFu7i_BFs7i) C1{ Fs:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7i, BFs7s_BFu7i_BFs7i)
//============================================================================


struct  BFs7s_BFu7i_BFs7i_BFs7c  {
  signed short v1:7;
  unsigned int v2:7;
  signed int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7i_BFs7c) C1{ Fs:7 Fi:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7i_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7i_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7i_BFs7c, BFs7s_BFu7i_BFs7i_BFs7c)
//============================================================================


struct  BFs7s_BFu7i_BFs7i_BFs7i  {
  signed short v1:7;
  unsigned int v2:7;
  signed int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7i_BFs7i) C1{ Fs:7 Fi:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7i_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7i_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7i_BFs7i, BFs7s_BFu7i_BFs7i_BFs7i)
//============================================================================


struct  BFs7s_BFu7i_BFs7i_BFs7ll  {
  signed short v1:7;
  unsigned int v2:7;
  signed int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7i_BFs7ll) C1{ Fs:7 Fi:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7i_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7i_BFs7ll, BFs7s_BFu7i_BFs7i_BFs7ll)
//============================================================================


struct  BFs7s_BFu7i_BFs7i_BFs7s  {
  signed short v1:7;
  unsigned int v2:7;
  signed int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7i_BFs7s) C1{ Fs:7 Fi:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7i_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7i_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7i_BFs7s, BFs7s_BFu7i_BFs7i_BFs7s)
//============================================================================


struct  BFs7s_BFu7i_BFs7i_BFu7c  {
  signed short v1:7;
  unsigned int v2:7;
  signed int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7i_BFu7c) C1{ Fs:7 Fi:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7i_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7i_BFu7c, BFs7s_BFu7i_BFs7i_BFu7c)
//============================================================================


struct  BFs7s_BFu7i_BFs7i_BFu7i  {
  signed short v1:7;
  unsigned int v2:7;
  signed int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7i_BFu7i) C1{ Fs:7 Fi:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7i_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7i_BFu7i, BFs7s_BFu7i_BFs7i_BFu7i)
//============================================================================


struct  BFs7s_BFu7i_BFs7i_BFu7ll  {
  signed short v1:7;
  unsigned int v2:7;
  signed int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7i_BFu7ll) C1{ Fs:7 Fi:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7i_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7i_BFu7ll, BFs7s_BFu7i_BFs7i_BFu7ll)
//============================================================================


struct  BFs7s_BFu7i_BFs7i_BFu7s  {
  signed short v1:7;
  unsigned int v2:7;
  signed int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7i_BFu7s) C1{ Fs:7 Fi:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7i_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7i_BFu7s, BFs7s_BFu7i_BFs7i_BFu7s)
//============================================================================


struct  BFs7s_BFu7i_BFs7ll  {
  signed short v1:7;
  unsigned int v2:7;
  signed __tsi64 v3:7;
};
//SIG(1 BFs7s_BFu7i_BFs7ll) C1{ Fs:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7ll, BFs7s_BFu7i_BFs7ll)
//============================================================================


struct  BFs7s_BFu7i_BFs7ll_BFs7c  {
  signed short v1:7;
  unsigned int v2:7;
  signed __tsi64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7ll_BFs7c) C1{ Fs:7 Fi:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7i_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7ll_BFs7c, BFs7s_BFu7i_BFs7ll_BFs7c)
//============================================================================


struct  BFs7s_BFu7i_BFs7ll_BFs7i  {
  signed short v1:7;
  unsigned int v2:7;
  signed __tsi64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7ll_BFs7i) C1{ Fs:7 Fi:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7i_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7ll_BFs7i, BFs7s_BFu7i_BFs7ll_BFs7i)
//============================================================================


struct  BFs7s_BFu7i_BFs7ll_BFs7ll  {
  signed short v1:7;
  unsigned int v2:7;
  signed __tsi64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7ll_BFs7ll) C1{ Fs:7 Fi:7 FL:7 FL:7}



static void Test_BFs7s_BFu7i_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7ll_BFs7ll, BFs7s_BFu7i_BFs7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFu7i_BFs7ll_BFs7s  {
  signed short v1:7;
  unsigned int v2:7;
  signed __tsi64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7ll_BFs7s) C1{ Fs:7 Fi:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7i_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7ll_BFs7s, BFs7s_BFu7i_BFs7ll_BFs7s)
//============================================================================


struct  BFs7s_BFu7i_BFs7ll_BFu7c  {
  signed short v1:7;
  unsigned int v2:7;
  signed __tsi64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7ll_BFu7c) C1{ Fs:7 Fi:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7i_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7ll_BFu7c, BFs7s_BFu7i_BFs7ll_BFu7c)
//============================================================================


struct  BFs7s_BFu7i_BFs7ll_BFu7i  {
  signed short v1:7;
  unsigned int v2:7;
  signed __tsi64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7ll_BFu7i) C1{ Fs:7 Fi:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7i_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7ll_BFu7i, BFs7s_BFu7i_BFs7ll_BFu7i)
//============================================================================


struct  BFs7s_BFu7i_BFs7ll_BFu7ll  {
  signed short v1:7;
  unsigned int v2:7;
  signed __tsi64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7ll_BFu7ll) C1{ Fs:7 Fi:7 FL:7 FL:7}



static void Test_BFs7s_BFu7i_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7ll_BFu7ll, BFs7s_BFu7i_BFs7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFu7i_BFs7ll_BFu7s  {
  signed short v1:7;
  unsigned int v2:7;
  signed __tsi64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7ll_BFu7s) C1{ Fs:7 Fi:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7i_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7ll_BFu7s, BFs7s_BFu7i_BFs7ll_BFu7s)
//============================================================================


struct  BFs7s_BFu7i_BFs7s  {
  signed short v1:7;
  unsigned int v2:7;
  signed short v3:7;
};
//SIG(1 BFs7s_BFu7i_BFs7s) C1{ Fs:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7s, BFs7s_BFu7i_BFs7s)
//============================================================================


struct  BFs7s_BFu7i_BFs7s_BFs7c  {
  signed short v1:7;
  unsigned int v2:7;
  signed short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7s_BFs7c) C1{ Fs:7 Fi:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7i_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7s_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7s_BFs7c, BFs7s_BFu7i_BFs7s_BFs7c)
//============================================================================


struct  BFs7s_BFu7i_BFs7s_BFs7i  {
  signed short v1:7;
  unsigned int v2:7;
  signed short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7s_BFs7i) C1{ Fs:7 Fi:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7i_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7s_BFs7i, BFs7s_BFu7i_BFs7s_BFs7i)
//============================================================================


struct  BFs7s_BFu7i_BFs7s_BFs7ll  {
  signed short v1:7;
  unsigned int v2:7;
  signed short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7s_BFs7ll) C1{ Fs:7 Fi:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7i_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7s_BFs7ll, BFs7s_BFu7i_BFs7s_BFs7ll)
//============================================================================


struct  BFs7s_BFu7i_BFs7s_BFs7s  {
  signed short v1:7;
  unsigned int v2:7;
  signed short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7s_BFs7s) C1{ Fs:7 Fi:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7i_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7s_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7s_BFs7s, BFs7s_BFu7i_BFs7s_BFs7s)
//============================================================================


struct  BFs7s_BFu7i_BFs7s_BFu7c  {
  signed short v1:7;
  unsigned int v2:7;
  signed short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7s_BFu7c) C1{ Fs:7 Fi:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7i_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7s_BFu7c, BFs7s_BFu7i_BFs7s_BFu7c)
//============================================================================


struct  BFs7s_BFu7i_BFs7s_BFu7i  {
  signed short v1:7;
  unsigned int v2:7;
  signed short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7s_BFu7i) C1{ Fs:7 Fi:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7i_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7s_BFu7i, BFs7s_BFu7i_BFs7s_BFu7i)
//============================================================================


struct  BFs7s_BFu7i_BFs7s_BFu7ll  {
  signed short v1:7;
  unsigned int v2:7;
  signed short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7s_BFu7ll) C1{ Fs:7 Fi:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7i_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFs7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7s_BFu7ll, BFs7s_BFu7i_BFs7s_BFu7ll)
//============================================================================


struct  BFs7s_BFu7i_BFs7s_BFu7s  {
  signed short v1:7;
  unsigned int v2:7;
  signed short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFs7s_BFu7s) C1{ Fs:7 Fi:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7i_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFs7s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFs7s_BFu7s, BFs7s_BFu7i_BFs7s_BFu7s)
//============================================================================


struct  BFs7s_BFu7i_BFu7c  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
};
//SIG(1 BFs7s_BFu7i_BFu7c) C1{ Fs:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7c, BFs7s_BFu7i_BFu7c)
//============================================================================


struct  BFs7s_BFu7i_BFu7c_BFs7c  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7c_BFs7c) C1{ Fs:7 Fi:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7i_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7c_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7c_BFs7c, BFs7s_BFu7i_BFu7c_BFs7c)
//============================================================================


struct  BFs7s_BFu7i_BFu7c_BFs7i  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7c_BFs7i) C1{ Fs:7 Fi:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7i_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7c_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7c_BFs7i, BFs7s_BFu7i_BFu7c_BFs7i)
//============================================================================


struct  BFs7s_BFu7i_BFu7c_BFs7ll  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7c_BFs7ll) C1{ Fs:7 Fi:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7i_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7c_BFs7ll, BFs7s_BFu7i_BFu7c_BFs7ll)
//============================================================================


struct  BFs7s_BFu7i_BFu7c_BFs7s  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7c_BFs7s) C1{ Fs:7 Fi:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7i_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7c_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7c_BFs7s, BFs7s_BFu7i_BFu7c_BFs7s)
//============================================================================


struct  BFs7s_BFu7i_BFu7c_BFu7c  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7c_BFu7c) C1{ Fs:7 Fi:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7i_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7c_BFu7c, BFs7s_BFu7i_BFu7c_BFu7c)
//============================================================================


struct  BFs7s_BFu7i_BFu7c_BFu7i  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7c_BFu7i) C1{ Fs:7 Fi:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7i_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7c_BFu7i, BFs7s_BFu7i_BFu7c_BFu7i)
//============================================================================


struct  BFs7s_BFu7i_BFu7c_BFu7ll  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7c_BFu7ll) C1{ Fs:7 Fi:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7i_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7c_BFu7ll, BFs7s_BFu7i_BFu7c_BFu7ll)
//============================================================================


struct  BFs7s_BFu7i_BFu7c_BFu7s  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7c_BFu7s) C1{ Fs:7 Fi:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7i_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7c_BFu7s, BFs7s_BFu7i_BFu7c_BFu7s)
//============================================================================


struct  BFs7s_BFu7i_BFu7i  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
};
//SIG(1 BFs7s_BFu7i_BFu7i) C1{ Fs:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7i, BFs7s_BFu7i_BFu7i)
//============================================================================


struct  BFs7s_BFu7i_BFu7i_BFs7c  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7i_BFs7c) C1{ Fs:7 Fi:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7i_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7i_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7i_BFs7c, BFs7s_BFu7i_BFu7i_BFs7c)
//============================================================================


struct  BFs7s_BFu7i_BFu7i_BFs7i  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7i_BFs7i) C1{ Fs:7 Fi:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7i_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7i_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7i_BFs7i, BFs7s_BFu7i_BFu7i_BFs7i)
//============================================================================


struct  BFs7s_BFu7i_BFu7i_BFs7ll  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7i_BFs7ll) C1{ Fs:7 Fi:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7i_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7i_BFs7ll, BFs7s_BFu7i_BFu7i_BFs7ll)
//============================================================================


struct  BFs7s_BFu7i_BFu7i_BFs7s  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7i_BFs7s) C1{ Fs:7 Fi:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7i_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7i_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7i_BFs7s, BFs7s_BFu7i_BFu7i_BFs7s)
//============================================================================


struct  BFs7s_BFu7i_BFu7i_BFu7c  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7i_BFu7c) C1{ Fs:7 Fi:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7i_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7i_BFu7c, BFs7s_BFu7i_BFu7i_BFu7c)
//============================================================================


struct  BFs7s_BFu7i_BFu7i_BFu7i  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7i_BFu7i) C1{ Fs:7 Fi:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7i_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7i_BFu7i, BFs7s_BFu7i_BFu7i_BFu7i)
//============================================================================


struct  BFs7s_BFu7i_BFu7i_BFu7ll  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7i_BFu7ll) C1{ Fs:7 Fi:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7i_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7i_BFu7ll, BFs7s_BFu7i_BFu7i_BFu7ll)
//============================================================================


struct  BFs7s_BFu7i_BFu7i_BFu7s  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7i_BFu7s) C1{ Fs:7 Fi:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7i_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7i_BFu7s, BFs7s_BFu7i_BFu7i_BFu7s)
//============================================================================


struct  BFs7s_BFu7i_BFu7ll  {
  signed short v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFs7s_BFu7i_BFu7ll) C1{ Fs:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7ll, BFs7s_BFu7i_BFu7ll)
//============================================================================


struct  BFs7s_BFu7i_BFu7ll_BFs7c  {
  signed short v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7ll_BFs7c) C1{ Fs:7 Fi:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7i_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7ll_BFs7c, BFs7s_BFu7i_BFu7ll_BFs7c)
//============================================================================


struct  BFs7s_BFu7i_BFu7ll_BFs7i  {
  signed short v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7ll_BFs7i) C1{ Fs:7 Fi:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7i_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7ll_BFs7i, BFs7s_BFu7i_BFu7ll_BFs7i)
//============================================================================


struct  BFs7s_BFu7i_BFu7ll_BFs7ll  {
  signed short v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7ll_BFs7ll) C1{ Fs:7 Fi:7 FL:7 FL:7}



static void Test_BFs7s_BFu7i_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7ll_BFs7ll, BFs7s_BFu7i_BFu7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFu7i_BFu7ll_BFs7s  {
  signed short v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7ll_BFs7s) C1{ Fs:7 Fi:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7i_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7ll_BFs7s, BFs7s_BFu7i_BFu7ll_BFs7s)
//============================================================================


struct  BFs7s_BFu7i_BFu7ll_BFu7c  {
  signed short v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7ll_BFu7c) C1{ Fs:7 Fi:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7i_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7ll_BFu7c, BFs7s_BFu7i_BFu7ll_BFu7c)
//============================================================================


struct  BFs7s_BFu7i_BFu7ll_BFu7i  {
  signed short v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7ll_BFu7i) C1{ Fs:7 Fi:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7i_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7ll_BFu7i, BFs7s_BFu7i_BFu7ll_BFu7i)
//============================================================================


struct  BFs7s_BFu7i_BFu7ll_BFu7ll  {
  signed short v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7ll_BFu7ll) C1{ Fs:7 Fi:7 FL:7 FL:7}



static void Test_BFs7s_BFu7i_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7ll_BFu7ll, BFs7s_BFu7i_BFu7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFu7i_BFu7ll_BFu7s  {
  signed short v1:7;
  unsigned int v2:7;
  __tsu64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7ll_BFu7s) C1{ Fs:7 Fi:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7i_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7ll_BFu7s, BFs7s_BFu7i_BFu7ll_BFu7s)
//============================================================================


struct  BFs7s_BFu7i_BFu7s  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
};
//SIG(1 BFs7s_BFu7i_BFu7s) C1{ Fs:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7s, BFs7s_BFu7i_BFu7s)
//============================================================================


struct  BFs7s_BFu7i_BFu7s_BFs7c  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7s_BFs7c) C1{ Fs:7 Fi:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7i_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7s_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7s_BFs7c, BFs7s_BFu7i_BFu7s_BFs7c)
//============================================================================


struct  BFs7s_BFu7i_BFu7s_BFs7i  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7s_BFs7i) C1{ Fs:7 Fi:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7i_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7s_BFs7i, BFs7s_BFu7i_BFu7s_BFs7i)
//============================================================================


struct  BFs7s_BFu7i_BFu7s_BFs7ll  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7s_BFs7ll) C1{ Fs:7 Fi:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7i_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7s_BFs7ll, BFs7s_BFu7i_BFu7s_BFs7ll)
//============================================================================


struct  BFs7s_BFu7i_BFu7s_BFs7s  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7s_BFs7s) C1{ Fs:7 Fi:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7i_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7s_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7s_BFs7s, BFs7s_BFu7i_BFu7s_BFs7s)
//============================================================================


struct  BFs7s_BFu7i_BFu7s_BFu7c  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7s_BFu7c) C1{ Fs:7 Fi:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7i_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7s_BFu7c, BFs7s_BFu7i_BFu7s_BFu7c)
//============================================================================


struct  BFs7s_BFu7i_BFu7s_BFu7i  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7s_BFu7i) C1{ Fs:7 Fi:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7i_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7s_BFu7i, BFs7s_BFu7i_BFu7s_BFu7i)
//============================================================================


struct  BFs7s_BFu7i_BFu7s_BFu7ll  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7s_BFu7ll) C1{ Fs:7 Fi:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7i_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7i_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7i_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7s_BFu7ll, BFs7s_BFu7i_BFu7s_BFu7ll)
//============================================================================


struct  BFs7s_BFu7i_BFu7s_BFu7s  {
  signed short v1:7;
  unsigned int v2:7;
  unsigned short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7i_BFu7s_BFu7s) C1{ Fs:7 Fi:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7i_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7i_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7i_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7i_BFu7s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7i_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7i_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7i_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7i_BFu7s_BFu7s, BFs7s_BFu7i_BFu7s_BFu7s)
//============================================================================


struct  BFs7s_BFu7ll  {
  signed short v1:7;
  __tsu64 v2:7;
};
//SIG(1 BFs7s_BFu7ll) C1{ Fs:7 FL:7}



static void Test_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll, BFs7s_BFu7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFs7c  {
  signed short v1:7;
  __tsu64 v2:7;
  signed char v3:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7c) C1{ Fs:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7c, BFs7s_BFu7ll_BFs7c)
//============================================================================


struct  BFs7s_BFu7ll_BFs7c_BFs7c  {
  signed short v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7c_BFs7c) C1{ Fs:7 FL:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7c_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7c_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7c_BFs7c, BFs7s_BFu7ll_BFs7c_BFs7c)
//============================================================================


struct  BFs7s_BFu7ll_BFs7c_BFs7i  {
  signed short v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7c_BFs7i) C1{ Fs:7 FL:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7c_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7c_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7c_BFs7i, BFs7s_BFu7ll_BFs7c_BFs7i)
//============================================================================


struct  BFs7s_BFu7ll_BFs7c_BFs7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7c_BFs7ll) C1{ Fs:7 FL:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7ll_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7c_BFs7ll, BFs7s_BFu7ll_BFs7c_BFs7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFs7c_BFs7s  {
  signed short v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7c_BFs7s) C1{ Fs:7 FL:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7c_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7c_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7c_BFs7s, BFs7s_BFu7ll_BFs7c_BFs7s)
//============================================================================


struct  BFs7s_BFu7ll_BFs7c_BFu7c  {
  signed short v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7c_BFu7c) C1{ Fs:7 FL:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7c_BFu7c, BFs7s_BFu7ll_BFs7c_BFu7c)
//============================================================================


struct  BFs7s_BFu7ll_BFs7c_BFu7i  {
  signed short v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7c_BFu7i) C1{ Fs:7 FL:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7c_BFu7i, BFs7s_BFu7ll_BFs7c_BFu7i)
//============================================================================


struct  BFs7s_BFu7ll_BFs7c_BFu7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7c_BFu7ll) C1{ Fs:7 FL:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7ll_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7c_BFu7ll, BFs7s_BFu7ll_BFs7c_BFu7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFs7c_BFu7s  {
  signed short v1:7;
  __tsu64 v2:7;
  signed char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7c_BFu7s) C1{ Fs:7 FL:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7c_BFu7s, BFs7s_BFu7ll_BFs7c_BFu7s)
//============================================================================


struct  BFs7s_BFu7ll_BFs7i  {
  signed short v1:7;
  __tsu64 v2:7;
  signed int v3:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7i) C1{ Fs:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7i, BFs7s_BFu7ll_BFs7i)
//============================================================================


struct  BFs7s_BFu7ll_BFs7i_BFs7c  {
  signed short v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7i_BFs7c) C1{ Fs:7 FL:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7i_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7i_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7i_BFs7c, BFs7s_BFu7ll_BFs7i_BFs7c)
//============================================================================


struct  BFs7s_BFu7ll_BFs7i_BFs7i  {
  signed short v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7i_BFs7i) C1{ Fs:7 FL:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7i_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7i_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7i_BFs7i, BFs7s_BFu7ll_BFs7i_BFs7i)
//============================================================================


struct  BFs7s_BFu7ll_BFs7i_BFs7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7i_BFs7ll) C1{ Fs:7 FL:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7ll_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7i_BFs7ll, BFs7s_BFu7ll_BFs7i_BFs7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFs7i_BFs7s  {
  signed short v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7i_BFs7s) C1{ Fs:7 FL:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7i_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7i_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7i_BFs7s, BFs7s_BFu7ll_BFs7i_BFs7s)
//============================================================================


struct  BFs7s_BFu7ll_BFs7i_BFu7c  {
  signed short v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7i_BFu7c) C1{ Fs:7 FL:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7i_BFu7c, BFs7s_BFu7ll_BFs7i_BFu7c)
//============================================================================


struct  BFs7s_BFu7ll_BFs7i_BFu7i  {
  signed short v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7i_BFu7i) C1{ Fs:7 FL:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7i_BFu7i, BFs7s_BFu7ll_BFs7i_BFu7i)
//============================================================================


struct  BFs7s_BFu7ll_BFs7i_BFu7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7i_BFu7ll) C1{ Fs:7 FL:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7ll_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7i_BFu7ll, BFs7s_BFu7ll_BFs7i_BFu7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFs7i_BFu7s  {
  signed short v1:7;
  __tsu64 v2:7;
  signed int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7i_BFu7s) C1{ Fs:7 FL:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7i_BFu7s, BFs7s_BFu7ll_BFs7i_BFu7s)
//============================================================================


struct  BFs7s_BFu7ll_BFs7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7ll) C1{ Fs:7 FL:7 FL:7}



static void Test_BFs7s_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7ll, BFs7s_BFu7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFs7ll_BFs7c  {
  signed short v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7ll_BFs7c) C1{ Fs:7 FL:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7ll_BFs7c, BFs7s_BFu7ll_BFs7ll_BFs7c)
//============================================================================


struct  BFs7s_BFu7ll_BFs7ll_BFs7i  {
  signed short v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7ll_BFs7i) C1{ Fs:7 FL:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7ll_BFs7i, BFs7s_BFu7ll_BFs7ll_BFs7i)
//============================================================================


struct  BFs7s_BFu7ll_BFs7ll_BFs7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7ll_BFs7ll) C1{ Fs:7 FL:7 FL:7 FL:7}



static void Test_BFs7s_BFu7ll_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7ll_BFs7ll, BFs7s_BFu7ll_BFs7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFs7ll_BFs7s  {
  signed short v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7ll_BFs7s) C1{ Fs:7 FL:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7ll_BFs7s, BFs7s_BFu7ll_BFs7ll_BFs7s)
//============================================================================


struct  BFs7s_BFu7ll_BFs7ll_BFu7c  {
  signed short v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7ll_BFu7c) C1{ Fs:7 FL:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7ll_BFu7c, BFs7s_BFu7ll_BFs7ll_BFu7c)
//============================================================================


struct  BFs7s_BFu7ll_BFs7ll_BFu7i  {
  signed short v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7ll_BFu7i) C1{ Fs:7 FL:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7ll_BFu7i, BFs7s_BFu7ll_BFs7ll_BFu7i)
//============================================================================


struct  BFs7s_BFu7ll_BFs7ll_BFu7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7ll_BFu7ll) C1{ Fs:7 FL:7 FL:7 FL:7}



static void Test_BFs7s_BFu7ll_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7ll_BFu7ll, BFs7s_BFu7ll_BFs7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFs7ll_BFu7s  {
  signed short v1:7;
  __tsu64 v2:7;
  signed __tsi64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7ll_BFu7s) C1{ Fs:7 FL:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7ll_BFu7s, BFs7s_BFu7ll_BFs7ll_BFu7s)
//============================================================================


struct  BFs7s_BFu7ll_BFs7s  {
  signed short v1:7;
  __tsu64 v2:7;
  signed short v3:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7s) C1{ Fs:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7s, BFs7s_BFu7ll_BFs7s)
//============================================================================


struct  BFs7s_BFu7ll_BFs7s_BFs7c  {
  signed short v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7s_BFs7c) C1{ Fs:7 FL:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7s_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7s_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7s_BFs7c, BFs7s_BFu7ll_BFs7s_BFs7c)
//============================================================================


struct  BFs7s_BFu7ll_BFs7s_BFs7i  {
  signed short v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7s_BFs7i) C1{ Fs:7 FL:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7s_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7s_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7s_BFs7i, BFs7s_BFu7ll_BFs7s_BFs7i)
//============================================================================


struct  BFs7s_BFu7ll_BFs7s_BFs7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7s_BFs7ll) C1{ Fs:7 FL:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7ll_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7s_BFs7ll, BFs7s_BFu7ll_BFs7s_BFs7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFs7s_BFs7s  {
  signed short v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7s_BFs7s) C1{ Fs:7 FL:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7s_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7s_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7s_BFs7s, BFs7s_BFu7ll_BFs7s_BFs7s)
//============================================================================


struct  BFs7s_BFu7ll_BFs7s_BFu7c  {
  signed short v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7s_BFu7c) C1{ Fs:7 FL:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7s_BFu7c, BFs7s_BFu7ll_BFs7s_BFu7c)
//============================================================================


struct  BFs7s_BFu7ll_BFs7s_BFu7i  {
  signed short v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7s_BFu7i) C1{ Fs:7 FL:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7s_BFu7i, BFs7s_BFu7ll_BFs7s_BFu7i)
//============================================================================


struct  BFs7s_BFu7ll_BFs7s_BFu7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7s_BFu7ll) C1{ Fs:7 FL:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7ll_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7s_BFu7ll, BFs7s_BFu7ll_BFs7s_BFu7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFs7s_BFu7s  {
  signed short v1:7;
  __tsu64 v2:7;
  signed short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFs7s_BFu7s) C1{ Fs:7 FL:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFs7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFs7s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFs7s_BFu7s, BFs7s_BFu7ll_BFs7s_BFu7s)
//============================================================================


struct  BFs7s_BFu7ll_BFu7c  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7c) C1{ Fs:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7c, BFs7s_BFu7ll_BFu7c)
//============================================================================


struct  BFs7s_BFu7ll_BFu7c_BFs7c  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7c_BFs7c) C1{ Fs:7 FL:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7c_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7c_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7c_BFs7c, BFs7s_BFu7ll_BFu7c_BFs7c)
//============================================================================


struct  BFs7s_BFu7ll_BFu7c_BFs7i  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7c_BFs7i) C1{ Fs:7 FL:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7c_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7c_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7c_BFs7i, BFs7s_BFu7ll_BFu7c_BFs7i)
//============================================================================


struct  BFs7s_BFu7ll_BFu7c_BFs7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7c_BFs7ll) C1{ Fs:7 FL:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7ll_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7c_BFs7ll, BFs7s_BFu7ll_BFu7c_BFs7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFu7c_BFs7s  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7c_BFs7s) C1{ Fs:7 FL:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7c_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7c_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7c_BFs7s, BFs7s_BFu7ll_BFu7c_BFs7s)
//============================================================================


struct  BFs7s_BFu7ll_BFu7c_BFu7c  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7c_BFu7c) C1{ Fs:7 FL:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7c_BFu7c, BFs7s_BFu7ll_BFu7c_BFu7c)
//============================================================================


struct  BFs7s_BFu7ll_BFu7c_BFu7i  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7c_BFu7i) C1{ Fs:7 FL:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7c_BFu7i, BFs7s_BFu7ll_BFu7c_BFu7i)
//============================================================================


struct  BFs7s_BFu7ll_BFu7c_BFu7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7c_BFu7ll) C1{ Fs:7 FL:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7ll_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7c_BFu7ll, BFs7s_BFu7ll_BFu7c_BFu7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFu7c_BFu7s  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7c_BFu7s) C1{ Fs:7 FL:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7c_BFu7s, BFs7s_BFu7ll_BFu7c_BFu7s)
//============================================================================


struct  BFs7s_BFu7ll_BFu7i  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7i) C1{ Fs:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7i, BFs7s_BFu7ll_BFu7i)
//============================================================================


struct  BFs7s_BFu7ll_BFu7i_BFs7c  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7i_BFs7c) C1{ Fs:7 FL:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7i_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7i_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7i_BFs7c, BFs7s_BFu7ll_BFu7i_BFs7c)
//============================================================================


struct  BFs7s_BFu7ll_BFu7i_BFs7i  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7i_BFs7i) C1{ Fs:7 FL:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7i_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7i_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7i_BFs7i, BFs7s_BFu7ll_BFu7i_BFs7i)
//============================================================================


struct  BFs7s_BFu7ll_BFu7i_BFs7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7i_BFs7ll) C1{ Fs:7 FL:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7ll_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7i_BFs7ll, BFs7s_BFu7ll_BFu7i_BFs7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFu7i_BFs7s  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7i_BFs7s) C1{ Fs:7 FL:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7i_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7i_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7i_BFs7s, BFs7s_BFu7ll_BFu7i_BFs7s)
//============================================================================


struct  BFs7s_BFu7ll_BFu7i_BFu7c  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7i_BFu7c) C1{ Fs:7 FL:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7i_BFu7c, BFs7s_BFu7ll_BFu7i_BFu7c)
//============================================================================


struct  BFs7s_BFu7ll_BFu7i_BFu7i  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7i_BFu7i) C1{ Fs:7 FL:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7i_BFu7i, BFs7s_BFu7ll_BFu7i_BFu7i)
//============================================================================


struct  BFs7s_BFu7ll_BFu7i_BFu7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7i_BFu7ll) C1{ Fs:7 FL:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7ll_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7i_BFu7ll, BFs7s_BFu7ll_BFu7i_BFu7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFu7i_BFu7s  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7i_BFu7s) C1{ Fs:7 FL:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7i_BFu7s, BFs7s_BFu7ll_BFu7i_BFu7s)
//============================================================================


struct  BFs7s_BFu7ll_BFu7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7ll) C1{ Fs:7 FL:7 FL:7}



static void Test_BFs7s_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7ll, BFs7s_BFu7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFu7ll_BFs7c  {
  signed short v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7ll_BFs7c) C1{ Fs:7 FL:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7ll_BFs7c, BFs7s_BFu7ll_BFu7ll_BFs7c)
//============================================================================


struct  BFs7s_BFu7ll_BFu7ll_BFs7i  {
  signed short v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7ll_BFs7i) C1{ Fs:7 FL:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7ll_BFs7i, BFs7s_BFu7ll_BFu7ll_BFs7i)
//============================================================================


struct  BFs7s_BFu7ll_BFu7ll_BFs7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7ll_BFs7ll) C1{ Fs:7 FL:7 FL:7 FL:7}



static void Test_BFs7s_BFu7ll_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7ll_BFs7ll, BFs7s_BFu7ll_BFu7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFu7ll_BFs7s  {
  signed short v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7ll_BFs7s) C1{ Fs:7 FL:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7ll_BFs7s, BFs7s_BFu7ll_BFu7ll_BFs7s)
//============================================================================


struct  BFs7s_BFu7ll_BFu7ll_BFu7c  {
  signed short v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7ll_BFu7c) C1{ Fs:7 FL:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7ll_BFu7c, BFs7s_BFu7ll_BFu7ll_BFu7c)
//============================================================================


struct  BFs7s_BFu7ll_BFu7ll_BFu7i  {
  signed short v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7ll_BFu7i) C1{ Fs:7 FL:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7ll_BFu7i, BFs7s_BFu7ll_BFu7ll_BFu7i)
//============================================================================


struct  BFs7s_BFu7ll_BFu7ll_BFu7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7ll_BFu7ll) C1{ Fs:7 FL:7 FL:7 FL:7}



static void Test_BFs7s_BFu7ll_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7ll_BFu7ll, BFs7s_BFu7ll_BFu7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFu7ll_BFu7s  {
  signed short v1:7;
  __tsu64 v2:7;
  __tsu64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7ll_BFu7s) C1{ Fs:7 FL:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7ll_BFu7s, BFs7s_BFu7ll_BFu7ll_BFu7s)
//============================================================================


struct  BFs7s_BFu7ll_BFu7s  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7s) C1{ Fs:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7s, BFs7s_BFu7ll_BFu7s)
//============================================================================


struct  BFs7s_BFu7ll_BFu7s_BFs7c  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7s_BFs7c) C1{ Fs:7 FL:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7s_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7s_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7s_BFs7c, BFs7s_BFu7ll_BFu7s_BFs7c)
//============================================================================


struct  BFs7s_BFu7ll_BFu7s_BFs7i  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7s_BFs7i) C1{ Fs:7 FL:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7s_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7s_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7s_BFs7i, BFs7s_BFu7ll_BFu7s_BFs7i)
//============================================================================


struct  BFs7s_BFu7ll_BFu7s_BFs7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7s_BFs7ll) C1{ Fs:7 FL:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7ll_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7s_BFs7ll, BFs7s_BFu7ll_BFu7s_BFs7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFu7s_BFs7s  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7s_BFs7s) C1{ Fs:7 FL:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7s_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7s_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7s_BFs7s, BFs7s_BFu7ll_BFu7s_BFs7s)
//============================================================================


struct  BFs7s_BFu7ll_BFu7s_BFu7c  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7s_BFu7c) C1{ Fs:7 FL:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7ll_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7s_BFu7c, BFs7s_BFu7ll_BFu7s_BFu7c)
//============================================================================


struct  BFs7s_BFu7ll_BFu7s_BFu7i  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7s_BFu7i) C1{ Fs:7 FL:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7ll_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7s_BFu7i, BFs7s_BFu7ll_BFu7s_BFu7i)
//============================================================================


struct  BFs7s_BFu7ll_BFu7s_BFu7ll  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7s_BFu7ll) C1{ Fs:7 FL:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7ll_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7s_BFu7ll, BFs7s_BFu7ll_BFu7s_BFu7ll)
//============================================================================


struct  BFs7s_BFu7ll_BFu7s_BFu7s  {
  signed short v1:7;
  __tsu64 v2:7;
  unsigned short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7ll_BFu7s_BFu7s) C1{ Fs:7 FL:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7ll_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7ll_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7ll_BFu7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7ll_BFu7s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7ll_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7ll_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7ll_BFu7s_BFu7s, BFs7s_BFu7ll_BFu7s_BFu7s)
//============================================================================


struct  BFs7s_BFu7s  {
  signed short v1:7;
  unsigned short v2:7;
};
//SIG(1 BFs7s_BFu7s) C1{ Fs:7 Fs:7}



static void Test_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(BFs7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s, BFs7s_BFu7s)
//============================================================================


struct  BFs7s_BFu7s_BFs7c  {
  signed short v1:7;
  unsigned short v2:7;
  signed char v3:7;
};
//SIG(1 BFs7s_BFu7s_BFs7c) C1{ Fs:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7c, BFs7s_BFu7s_BFs7c)
//============================================================================


struct  BFs7s_BFu7s_BFs7c_BFs7c  {
  signed short v1:7;
  unsigned short v2:7;
  signed char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7c_BFs7c) C1{ Fs:7 Fs:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7s_BFs7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7c_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFs7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7c_BFs7c, BFs7s_BFu7s_BFs7c_BFs7c)
//============================================================================


struct  BFs7s_BFu7s_BFs7c_BFs7i  {
  signed short v1:7;
  unsigned short v2:7;
  signed char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7c_BFs7i) C1{ Fs:7 Fs:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7s_BFs7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7c_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFs7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7c_BFs7i, BFs7s_BFu7s_BFs7c_BFs7i)
//============================================================================


struct  BFs7s_BFu7s_BFs7c_BFs7ll  {
  signed short v1:7;
  unsigned short v2:7;
  signed char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7c_BFs7ll) C1{ Fs:7 Fs:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7s_BFs7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7c_BFs7ll, BFs7s_BFu7s_BFs7c_BFs7ll)
//============================================================================


struct  BFs7s_BFu7s_BFs7c_BFs7s  {
  signed short v1:7;
  unsigned short v2:7;
  signed char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7c_BFs7s) C1{ Fs:7 Fs:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7s_BFs7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7c_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFs7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFs7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7c_BFs7s, BFs7s_BFu7s_BFs7c_BFs7s)
//============================================================================


struct  BFs7s_BFu7s_BFs7c_BFu7c  {
  signed short v1:7;
  unsigned short v2:7;
  signed char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7c_BFu7c) C1{ Fs:7 Fs:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7s_BFs7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFs7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7c_BFu7c, BFs7s_BFu7s_BFs7c_BFu7c)
//============================================================================


struct  BFs7s_BFu7s_BFs7c_BFu7i  {
  signed short v1:7;
  unsigned short v2:7;
  signed char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7c_BFu7i) C1{ Fs:7 Fs:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7s_BFs7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFs7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7c_BFu7i, BFs7s_BFu7s_BFs7c_BFu7i)
//============================================================================


struct  BFs7s_BFu7s_BFs7c_BFu7ll  {
  signed short v1:7;
  unsigned short v2:7;
  signed char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7c_BFu7ll) C1{ Fs:7 Fs:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7s_BFs7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7c_BFu7ll, BFs7s_BFu7s_BFs7c_BFu7ll)
//============================================================================


struct  BFs7s_BFu7s_BFs7c_BFu7s  {
  signed short v1:7;
  unsigned short v2:7;
  signed char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7c_BFu7s) C1{ Fs:7 Fs:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7s_BFs7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFs7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFs7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7c_BFu7s, BFs7s_BFu7s_BFs7c_BFu7s)
//============================================================================


struct  BFs7s_BFu7s_BFs7i  {
  signed short v1:7;
  unsigned short v2:7;
  signed int v3:7;
};
//SIG(1 BFs7s_BFu7s_BFs7i) C1{ Fs:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7i, BFs7s_BFu7s_BFs7i)
//============================================================================


struct  BFs7s_BFu7s_BFs7i_BFs7c  {
  signed short v1:7;
  unsigned short v2:7;
  signed int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7i_BFs7c) C1{ Fs:7 Fs:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7s_BFs7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7i_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFs7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7i_BFs7c, BFs7s_BFu7s_BFs7i_BFs7c)
//============================================================================


struct  BFs7s_BFu7s_BFs7i_BFs7i  {
  signed short v1:7;
  unsigned short v2:7;
  signed int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7i_BFs7i) C1{ Fs:7 Fs:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7s_BFs7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7i_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFs7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7i_BFs7i, BFs7s_BFu7s_BFs7i_BFs7i)
//============================================================================


struct  BFs7s_BFu7s_BFs7i_BFs7ll  {
  signed short v1:7;
  unsigned short v2:7;
  signed int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7i_BFs7ll) C1{ Fs:7 Fs:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7s_BFs7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7i_BFs7ll, BFs7s_BFu7s_BFs7i_BFs7ll)
//============================================================================


struct  BFs7s_BFu7s_BFs7i_BFs7s  {
  signed short v1:7;
  unsigned short v2:7;
  signed int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7i_BFs7s) C1{ Fs:7 Fs:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7s_BFs7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7i_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFs7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFs7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7i_BFs7s, BFs7s_BFu7s_BFs7i_BFs7s)
//============================================================================


struct  BFs7s_BFu7s_BFs7i_BFu7c  {
  signed short v1:7;
  unsigned short v2:7;
  signed int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7i_BFu7c) C1{ Fs:7 Fs:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7s_BFs7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFs7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7i_BFu7c, BFs7s_BFu7s_BFs7i_BFu7c)
//============================================================================


struct  BFs7s_BFu7s_BFs7i_BFu7i  {
  signed short v1:7;
  unsigned short v2:7;
  signed int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7i_BFu7i) C1{ Fs:7 Fs:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7s_BFs7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFs7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7i_BFu7i, BFs7s_BFu7s_BFs7i_BFu7i)
//============================================================================


struct  BFs7s_BFu7s_BFs7i_BFu7ll  {
  signed short v1:7;
  unsigned short v2:7;
  signed int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7i_BFu7ll) C1{ Fs:7 Fs:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7s_BFs7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7i_BFu7ll, BFs7s_BFu7s_BFs7i_BFu7ll)
//============================================================================


struct  BFs7s_BFu7s_BFs7i_BFu7s  {
  signed short v1:7;
  unsigned short v2:7;
  signed int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7i_BFu7s) C1{ Fs:7 Fs:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7s_BFs7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFs7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFs7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7i_BFu7s, BFs7s_BFu7s_BFs7i_BFu7s)
//============================================================================


struct  BFs7s_BFu7s_BFs7ll  {
  signed short v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
};
//SIG(1 BFs7s_BFu7s_BFs7ll) C1{ Fs:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7ll, BFs7s_BFu7s_BFs7ll)
//============================================================================


struct  BFs7s_BFu7s_BFs7ll_BFs7c  {
  signed short v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7ll_BFs7c) C1{ Fs:7 Fs:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7s_BFs7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7ll_BFs7c, BFs7s_BFu7s_BFs7ll_BFs7c)
//============================================================================


struct  BFs7s_BFu7s_BFs7ll_BFs7i  {
  signed short v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7ll_BFs7i) C1{ Fs:7 Fs:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7s_BFs7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7ll_BFs7i, BFs7s_BFu7s_BFs7ll_BFs7i)
//============================================================================


struct  BFs7s_BFu7s_BFs7ll_BFs7ll  {
  signed short v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7ll_BFs7ll) C1{ Fs:7 Fs:7 FL:7 FL:7}



static void Test_BFs7s_BFu7s_BFs7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7ll_BFs7ll, BFs7s_BFu7s_BFs7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFu7s_BFs7ll_BFs7s  {
  signed short v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7ll_BFs7s) C1{ Fs:7 Fs:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7s_BFs7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFs7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7ll_BFs7s, BFs7s_BFu7s_BFs7ll_BFs7s)
//============================================================================


struct  BFs7s_BFu7s_BFs7ll_BFu7c  {
  signed short v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7ll_BFu7c) C1{ Fs:7 Fs:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7s_BFs7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7ll_BFu7c, BFs7s_BFu7s_BFs7ll_BFu7c)
//============================================================================


struct  BFs7s_BFu7s_BFs7ll_BFu7i  {
  signed short v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7ll_BFu7i) C1{ Fs:7 Fs:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7s_BFs7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7ll_BFu7i, BFs7s_BFu7s_BFs7ll_BFu7i)
//============================================================================


struct  BFs7s_BFu7s_BFs7ll_BFu7ll  {
  signed short v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7ll_BFu7ll) C1{ Fs:7 Fs:7 FL:7 FL:7}



static void Test_BFs7s_BFu7s_BFs7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7ll_BFu7ll, BFs7s_BFu7s_BFs7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFu7s_BFs7ll_BFu7s  {
  signed short v1:7;
  unsigned short v2:7;
  signed __tsi64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7ll_BFu7s) C1{ Fs:7 Fs:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7s_BFs7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFs7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7ll_BFu7s, BFs7s_BFu7s_BFs7ll_BFu7s)
//============================================================================


struct  BFs7s_BFu7s_BFs7s  {
  signed short v1:7;
  unsigned short v2:7;
  signed short v3:7;
};
//SIG(1 BFs7s_BFu7s_BFs7s) C1{ Fs:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7s, BFs7s_BFu7s_BFs7s)
//============================================================================


struct  BFs7s_BFu7s_BFs7s_BFs7c  {
  signed short v1:7;
  unsigned short v2:7;
  signed short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7s_BFs7c) C1{ Fs:7 Fs:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7s_BFs7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7s_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFs7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7s_BFs7c, BFs7s_BFu7s_BFs7s_BFs7c)
//============================================================================


struct  BFs7s_BFu7s_BFs7s_BFs7i  {
  signed short v1:7;
  unsigned short v2:7;
  signed short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7s_BFs7i) C1{ Fs:7 Fs:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7s_BFs7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFs7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7s_BFs7i, BFs7s_BFu7s_BFs7s_BFs7i)
//============================================================================


struct  BFs7s_BFu7s_BFs7s_BFs7ll  {
  signed short v1:7;
  unsigned short v2:7;
  signed short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7s_BFs7ll) C1{ Fs:7 Fs:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7s_BFs7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7s_BFs7ll, BFs7s_BFu7s_BFs7s_BFs7ll)
//============================================================================


struct  BFs7s_BFu7s_BFs7s_BFs7s  {
  signed short v1:7;
  unsigned short v2:7;
  signed short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7s_BFs7s) C1{ Fs:7 Fs:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7s_BFs7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7s_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFs7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFs7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7s_BFs7s, BFs7s_BFu7s_BFs7s_BFs7s)
//============================================================================


struct  BFs7s_BFu7s_BFs7s_BFu7c  {
  signed short v1:7;
  unsigned short v2:7;
  signed short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7s_BFu7c) C1{ Fs:7 Fs:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7s_BFs7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFs7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7s_BFu7c, BFs7s_BFu7s_BFs7s_BFu7c)
//============================================================================


struct  BFs7s_BFu7s_BFs7s_BFu7i  {
  signed short v1:7;
  unsigned short v2:7;
  signed short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7s_BFu7i) C1{ Fs:7 Fs:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7s_BFs7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFs7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7s_BFu7i, BFs7s_BFu7s_BFs7s_BFu7i)
//============================================================================


struct  BFs7s_BFu7s_BFs7s_BFu7ll  {
  signed short v1:7;
  unsigned short v2:7;
  signed short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7s_BFu7ll) C1{ Fs:7 Fs:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7s_BFs7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFs7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFs7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7s_BFu7ll, BFs7s_BFu7s_BFs7s_BFu7ll)
//============================================================================


struct  BFs7s_BFu7s_BFs7s_BFu7s  {
  signed short v1:7;
  unsigned short v2:7;
  signed short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFs7s_BFu7s) C1{ Fs:7 Fs:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7s_BFs7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFs7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFs7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFs7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFs7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFs7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFs7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFs7s_BFu7s, BFs7s_BFu7s_BFs7s_BFu7s)
//============================================================================


struct  BFs7s_BFu7s_BFu7c  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
};
//SIG(1 BFs7s_BFu7s_BFu7c) C1{ Fs:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7c, BFs7s_BFu7s_BFu7c)
//============================================================================


struct  BFs7s_BFu7s_BFu7c_BFs7c  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7c_BFs7c) C1{ Fs:7 Fs:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7s_BFu7c_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7c_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7c_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7c_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFu7c_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7c_BFs7c, BFs7s_BFu7s_BFu7c_BFs7c)
//============================================================================


struct  BFs7s_BFu7s_BFu7c_BFs7i  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7c_BFs7i) C1{ Fs:7 Fs:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7s_BFu7c_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7c_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7c_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7c_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFu7c_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7c_BFs7i, BFs7s_BFu7s_BFu7c_BFs7i)
//============================================================================


struct  BFs7s_BFu7s_BFu7c_BFs7ll  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7c_BFs7ll) C1{ Fs:7 Fs:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7s_BFu7c_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7c_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7c_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7c_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7c_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7c_BFs7ll, BFs7s_BFu7s_BFu7c_BFs7ll)
//============================================================================


struct  BFs7s_BFu7s_BFu7c_BFs7s  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7c_BFs7s) C1{ Fs:7 Fs:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7s_BFu7c_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7c_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7c_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7c_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFu7c_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFu7c_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7c_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7c_BFs7s, BFs7s_BFu7s_BFu7c_BFs7s)
//============================================================================


struct  BFs7s_BFu7s_BFu7c_BFu7c  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7c_BFu7c) C1{ Fs:7 Fs:7 Fc:7 Fc:7}



static void Test_BFs7s_BFu7s_BFu7c_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7c_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7c_BFu7c, BFs7s_BFu7s_BFu7c_BFu7c)
//============================================================================


struct  BFs7s_BFu7s_BFu7c_BFu7i  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7c_BFu7i) C1{ Fs:7 Fs:7 Fc:7 Fi:7}



static void Test_BFs7s_BFu7s_BFu7c_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7c_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7c_BFu7i, BFs7s_BFu7s_BFu7c_BFu7i)
//============================================================================


struct  BFs7s_BFu7s_BFu7c_BFu7ll  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7c_BFu7ll) C1{ Fs:7 Fs:7 Fc:7 FL:7}



static void Test_BFs7s_BFu7s_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7c_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7c_BFu7ll, BFs7s_BFu7s_BFu7c_BFu7ll)
//============================================================================


struct  BFs7s_BFu7s_BFu7c_BFu7s  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned char v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7c_BFu7s) C1{ Fs:7 Fs:7 Fc:7 Fs:7}



static void Test_BFs7s_BFu7s_BFu7c_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7c_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFu7c_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7c_BFu7s, BFs7s_BFu7s_BFu7c_BFu7s)
//============================================================================


struct  BFs7s_BFu7s_BFu7i  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
};
//SIG(1 BFs7s_BFu7s_BFu7i) C1{ Fs:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7i, BFs7s_BFu7s_BFu7i)
//============================================================================


struct  BFs7s_BFu7s_BFu7i_BFs7c  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7i_BFs7c) C1{ Fs:7 Fs:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7s_BFu7i_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7i_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7i_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7i_BFs7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFu7i_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7i_BFs7c, BFs7s_BFu7s_BFu7i_BFs7c)
//============================================================================


struct  BFs7s_BFu7s_BFu7i_BFs7i  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7i_BFs7i) C1{ Fs:7 Fs:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7s_BFu7i_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7i_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7i_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7i_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFu7i_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7i_BFs7i, BFs7s_BFu7s_BFu7i_BFs7i)
//============================================================================


struct  BFs7s_BFu7s_BFu7i_BFs7ll  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7i_BFs7ll) C1{ Fs:7 Fs:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7s_BFu7i_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7i_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7i_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7i_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7i_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7i_BFs7ll, BFs7s_BFu7s_BFu7i_BFs7ll)
//============================================================================


struct  BFs7s_BFu7s_BFu7i_BFs7s  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7i_BFs7s) C1{ Fs:7 Fs:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7s_BFu7i_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7i_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7i_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7i_BFs7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFu7i_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFu7i_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7i_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7i_BFs7s, BFs7s_BFu7s_BFu7i_BFs7s)
//============================================================================


struct  BFs7s_BFu7s_BFu7i_BFu7c  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7i_BFu7c) C1{ Fs:7 Fs:7 Fi:7 Fc:7}



static void Test_BFs7s_BFu7s_BFu7i_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7i_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7i_BFu7c, BFs7s_BFu7s_BFu7i_BFu7c)
//============================================================================


struct  BFs7s_BFu7s_BFu7i_BFu7i  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7i_BFu7i) C1{ Fs:7 Fs:7 Fi:7 Fi:7}



static void Test_BFs7s_BFu7s_BFu7i_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7i_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7i_BFu7i, BFs7s_BFu7s_BFu7i_BFu7i)
//============================================================================


struct  BFs7s_BFu7s_BFu7i_BFu7ll  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7i_BFu7ll) C1{ Fs:7 Fs:7 Fi:7 FL:7}



static void Test_BFs7s_BFu7s_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7i_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7i_BFu7ll, BFs7s_BFu7s_BFu7i_BFu7ll)
//============================================================================


struct  BFs7s_BFu7s_BFu7i_BFu7s  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned int v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7i_BFu7s) C1{ Fs:7 Fs:7 Fi:7 Fs:7}



static void Test_BFs7s_BFu7s_BFu7i_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7i_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFu7i_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7i_BFu7s, BFs7s_BFu7s_BFu7i_BFu7s)
//============================================================================


struct  BFs7s_BFu7s_BFu7ll  {
  signed short v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
};
//SIG(1 BFs7s_BFu7s_BFu7ll) C1{ Fs:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7ll, BFs7s_BFu7s_BFu7ll)
//============================================================================


struct  BFs7s_BFu7s_BFu7ll_BFs7c  {
  signed short v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7ll_BFs7c) C1{ Fs:7 Fs:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7s_BFu7ll_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7ll_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7ll_BFs7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7ll_BFs7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7ll_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7ll_BFs7c, BFs7s_BFu7s_BFu7ll_BFs7c)
//============================================================================


struct  BFs7s_BFu7s_BFu7ll_BFs7i  {
  signed short v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7ll_BFs7i) C1{ Fs:7 Fs:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7s_BFu7ll_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7ll_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7ll_BFs7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7ll_BFs7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7ll_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7ll_BFs7i, BFs7s_BFu7s_BFu7ll_BFs7i)
//============================================================================


struct  BFs7s_BFu7s_BFu7ll_BFs7ll  {
  signed short v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7ll_BFs7ll) C1{ Fs:7 Fs:7 FL:7 FL:7}



static void Test_BFs7s_BFu7s_BFu7ll_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7ll_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7ll_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7ll_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7ll_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7ll_BFs7ll, BFs7s_BFu7s_BFu7ll_BFs7ll)
//============================================================================


struct  BFs7s_BFu7s_BFu7ll_BFs7s  {
  signed short v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7ll_BFs7s) C1{ Fs:7 Fs:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7s_BFu7ll_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7ll_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7ll_BFs7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7ll_BFs7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7ll_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFu7ll_BFs7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7ll_BFs7s, BFs7s_BFu7s_BFu7ll_BFs7s)
//============================================================================


struct  BFs7s_BFu7s_BFu7ll_BFu7c  {
  signed short v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7ll_BFu7c) C1{ Fs:7 Fs:7 FL:7 Fc:7}



static void Test_BFs7s_BFu7s_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7ll_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7ll_BFu7c, BFs7s_BFu7s_BFu7ll_BFu7c)
//============================================================================


struct  BFs7s_BFu7s_BFu7ll_BFu7i  {
  signed short v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7ll_BFu7i) C1{ Fs:7 Fs:7 FL:7 Fi:7}



static void Test_BFs7s_BFu7s_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7ll_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7i");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7ll_BFu7i, BFs7s_BFu7s_BFu7ll_BFu7i)
//============================================================================


struct  BFs7s_BFu7s_BFu7ll_BFu7ll  {
  signed short v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7ll_BFu7ll) C1{ Fs:7 Fs:7 FL:7 FL:7}



static void Test_BFs7s_BFu7s_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7ll_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7ll_BFu7ll, BFs7s_BFu7s_BFu7ll_BFu7ll)
//============================================================================


struct  BFs7s_BFu7s_BFu7ll_BFu7s  {
  signed short v1:7;
  unsigned short v2:7;
  __tsu64 v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7ll_BFu7s) C1{ Fs:7 Fs:7 FL:7 Fs:7}



static void Test_BFs7s_BFu7s_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7ll_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 6, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, 1, "BFs7s_BFu7s_BFu7ll_BFu7s");
    set_bf_and_test(lv, v4, 2, 5, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7ll_BFu7s, BFs7s_BFu7s_BFu7ll_BFu7s)
//============================================================================


struct  BFs7s_BFu7s_BFu7s  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
};
//SIG(1 BFs7s_BFu7s_BFu7s) C1{ Fs:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7s, BFs7s_BFu7s_BFu7s)
//============================================================================


struct  BFs7s_BFu7s_BFu7s_BFs7c  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  signed char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7s_BFs7c) C1{ Fs:7 Fs:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7s_BFu7s_BFs7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7s_BFs7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7s_BFs7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7s_BFs7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFu7s_BFs7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7s_BFs7c, BFs7s_BFu7s_BFu7s_BFs7c)
//============================================================================


struct  BFs7s_BFu7s_BFu7s_BFs7i  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  signed int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7s_BFs7i) C1{ Fs:7 Fs:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7s_BFu7s_BFs7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7s_BFs7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7s_BFs7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7s_BFs7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFu7s_BFs7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7s_BFs7i, BFs7s_BFu7s_BFu7s_BFs7i)
//============================================================================


struct  BFs7s_BFu7s_BFu7s_BFs7ll  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  signed __tsi64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7s_BFs7ll) C1{ Fs:7 Fs:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7s_BFu7s_BFs7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7s_BFs7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7s_BFs7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7s_BFs7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7s_BFs7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7s_BFs7ll, BFs7s_BFu7s_BFu7s_BFs7ll)
//============================================================================


struct  BFs7s_BFu7s_BFu7s_BFs7s  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  signed short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7s_BFs7s) C1{ Fs:7 Fs:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7s_BFu7s_BFs7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7s_BFs7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7s_BFs7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7s_BFs7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFu7s_BFs7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFu7s_BFs7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7s_BFs7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7s_BFs7s, BFs7s_BFu7s_BFu7s_BFs7s)
//============================================================================


struct  BFs7s_BFu7s_BFu7s_BFu7c  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  unsigned char v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7s_BFu7c) C1{ Fs:7 Fs:7 Fs:7 Fc:7}



static void Test_BFs7s_BFu7s_BFu7s_BFu7c()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7s_BFu7c");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7c");
    set_bf_and_test(lv, v4, 3, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7s_BFu7c, BFs7s_BFu7s_BFu7s_BFu7c)
//============================================================================


struct  BFs7s_BFu7s_BFu7s_BFu7i  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  unsigned int v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7s_BFu7i) C1{ Fs:7 Fs:7 Fs:7 Fi:7}



static void Test_BFs7s_BFu7s_BFu7s_BFu7i()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7s_BFu7i");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs7s_BFu7s_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7i");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7s_BFu7i, BFs7s_BFu7s_BFu7s_BFu7i)
//============================================================================


struct  BFs7s_BFu7s_BFu7s_BFu7ll  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  __tsu64 v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7s_BFu7ll) C1{ Fs:7 Fs:7 Fs:7 FL:7}



static void Test_BFs7s_BFu7s_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7s_BFu7ll");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs7s_BFu7s_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs7s_BFu7s_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7ll");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7s_BFu7ll, BFs7s_BFu7s_BFu7s_BFu7ll)
//============================================================================


struct  BFs7s_BFu7s_BFu7s_BFu7s  {
  signed short v1:7;
  unsigned short v2:7;
  unsigned short v3:7;
  unsigned short v4:7;
};
//SIG(1 BFs7s_BFu7s_BFu7s_BFu7s) C1{ Fs:7 Fs:7 Fs:7 Fs:7}



static void Test_BFs7s_BFu7s_BFu7s_BFu7s()
{
  {
    init_simple_test("BFs7s_BFu7s_BFu7s_BFu7s");
    static STRUCT_IF_C BFs7s_BFu7s_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFs7s_BFu7s_BFu7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs7s_BFu7s_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_sll(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, 1, "BFs7s_BFu7s_BFu7s_BFu7s");
    set_bf_and_test(lv, v4, 2, 7, 7, hide_ull(1LL<<6), "BFs7s_BFu7s_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs7s_BFu7s_BFu7s_BFu7s, BFs7s_BFu7s_BFu7s_BFu7s)
//============================================================================


struct  BFs8c_BFs8c  {
  signed char v1:8;
  signed char v2:8;
};
//SIG(1 BFs8c_BFs8c) C1{ Fc:8 Fc:8}



static void Test_BFs8c_BFs8c()
{
  {
    init_simple_test("BFs8c_BFs8c");
    static STRUCT_IF_C BFs8c_BFs8c lv;
    check2(sizeof(lv), 2, "sizeof(BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c, BFs8c_BFs8c)
//============================================================================


struct  BFs8c_BFs8c_BFs8c  {
  signed char v1:8;
  signed char v2:8;
  signed char v3:8;
};
//SIG(1 BFs8c_BFs8c_BFs8c) C1{ Fc:8 Fc:8 Fc:8}



static void Test_BFs8c_BFs8c_BFs8c()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8c");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8c_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8c_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8c, BFs8c_BFs8c_BFs8c)
//============================================================================


struct  BFs8c_BFs8c_BFs8c_BFs8c  {
  signed char v1:8;
  signed char v2:8;
  signed char v3:8;
  signed char v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8c_BFs8c) C1{ Fc:8 Fc:8 Fc:8 Fc:8}



static void Test_BFs8c_BFs8c_BFs8c_BFs8c()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8c_BFs8c");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8c_BFs8c_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8c_BFs8c, BFs8c_BFs8c_BFs8c_BFs8c)
//============================================================================


struct  BFs8c_BFs8c_BFs8c_BFs8i  {
  signed char v1:8;
  signed char v2:8;
  signed char v3:8;
  signed int v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8c_BFs8i) C1{ Fc:8 Fc:8 Fc:8 Fi:8}



static void Test_BFs8c_BFs8c_BFs8c_BFs8i()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8c_BFs8i");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8c_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8c_BFs8i, BFs8c_BFs8c_BFs8c_BFs8i)
//============================================================================


struct  BFs8c_BFs8c_BFs8c_BFs8ll  {
  signed char v1:8;
  signed char v2:8;
  signed char v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8c_BFs8ll) C1{ Fc:8 Fc:8 Fc:8 FL:8}



static void Test_BFs8c_BFs8c_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8c_BFs8ll");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8c_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8c_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8c_BFs8ll, BFs8c_BFs8c_BFs8c_BFs8ll)
//============================================================================


struct  BFs8c_BFs8c_BFs8c_BFs8s  {
  signed char v1:8;
  signed char v2:8;
  signed char v3:8;
  signed short v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8c_BFs8s) C1{ Fc:8 Fc:8 Fc:8 Fs:8}



static void Test_BFs8c_BFs8c_BFs8c_BFs8s()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8c_BFs8s");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8c_BFs8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8c_BFs8c_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8c_BFs8s, BFs8c_BFs8c_BFs8c_BFs8s)
//============================================================================


struct  BFs8c_BFs8c_BFs8c_BFu8c  {
  signed char v1:8;
  signed char v2:8;
  signed char v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8c_BFu8c) C1{ Fc:8 Fc:8 Fc:8 Fc:8}



static void Test_BFs8c_BFs8c_BFs8c_BFu8c()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8c_BFu8c");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8c_BFs8c_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8c_BFu8c, BFs8c_BFs8c_BFs8c_BFu8c)
//============================================================================


struct  BFs8c_BFs8c_BFs8c_BFu8i  {
  signed char v1:8;
  signed char v2:8;
  signed char v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8c_BFu8i) C1{ Fc:8 Fc:8 Fc:8 Fi:8}



static void Test_BFs8c_BFs8c_BFs8c_BFu8i()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8c_BFu8i");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8c_BFu8i, BFs8c_BFs8c_BFs8c_BFu8i)
//============================================================================


struct  BFs8c_BFs8c_BFs8c_BFu8ll  {
  signed char v1:8;
  signed char v2:8;
  signed char v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8c_BFu8ll) C1{ Fc:8 Fc:8 Fc:8 FL:8}



static void Test_BFs8c_BFs8c_BFs8c_BFu8ll()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8c_BFu8ll");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8c_BFu8ll, BFs8c_BFs8c_BFs8c_BFu8ll)
//============================================================================


struct  BFs8c_BFs8c_BFs8c_BFu8s  {
  signed char v1:8;
  signed char v2:8;
  signed char v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8c_BFu8s) C1{ Fc:8 Fc:8 Fc:8 Fs:8}



static void Test_BFs8c_BFs8c_BFs8c_BFu8s()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8c_BFu8s");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8c_BFs8c_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8c_BFu8s, BFs8c_BFs8c_BFs8c_BFu8s)
//============================================================================


struct  BFs8c_BFs8c_BFs8i  {
  signed char v1:8;
  signed char v2:8;
  signed int v3:8;
};
//SIG(1 BFs8c_BFs8c_BFs8i) C1{ Fc:8 Fc:8 Fi:8}



static void Test_BFs8c_BFs8c_BFs8i()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8i");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8i, BFs8c_BFs8c_BFs8i)
//============================================================================


struct  BFs8c_BFs8c_BFs8i_BFs8c  {
  signed char v1:8;
  signed char v2:8;
  signed int v3:8;
  signed char v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8i_BFs8c) C1{ Fc:8 Fc:8 Fi:8 Fc:8}



static void Test_BFs8c_BFs8c_BFs8i_BFs8c()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8i_BFs8c");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8i_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8i_BFs8c, BFs8c_BFs8c_BFs8i_BFs8c)
//============================================================================


struct  BFs8c_BFs8c_BFs8i_BFs8i  {
  signed char v1:8;
  signed char v2:8;
  signed int v3:8;
  signed int v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8i_BFs8i) C1{ Fc:8 Fc:8 Fi:8 Fi:8}



static void Test_BFs8c_BFs8c_BFs8i_BFs8i()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8i_BFs8i");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8i_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8i_BFs8i, BFs8c_BFs8c_BFs8i_BFs8i)
//============================================================================


struct  BFs8c_BFs8c_BFs8i_BFs8ll  {
  signed char v1:8;
  signed char v2:8;
  signed int v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8i_BFs8ll) C1{ Fc:8 Fc:8 Fi:8 FL:8}



static void Test_BFs8c_BFs8c_BFs8i_BFs8ll()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8i_BFs8ll");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8i_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8i_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8i_BFs8ll, BFs8c_BFs8c_BFs8i_BFs8ll)
//============================================================================


struct  BFs8c_BFs8c_BFs8i_BFs8s  {
  signed char v1:8;
  signed char v2:8;
  signed int v3:8;
  signed short v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8i_BFs8s) C1{ Fc:8 Fc:8 Fi:8 Fs:8}



static void Test_BFs8c_BFs8c_BFs8i_BFs8s()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8i_BFs8s");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8i_BFs8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8i_BFs8s, BFs8c_BFs8c_BFs8i_BFs8s)
//============================================================================


struct  BFs8c_BFs8c_BFs8i_BFu8c  {
  signed char v1:8;
  signed char v2:8;
  signed int v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8i_BFu8c) C1{ Fc:8 Fc:8 Fi:8 Fc:8}



static void Test_BFs8c_BFs8c_BFs8i_BFu8c()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8i_BFu8c");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8i_BFu8c, BFs8c_BFs8c_BFs8i_BFu8c)
//============================================================================


struct  BFs8c_BFs8c_BFs8i_BFu8i  {
  signed char v1:8;
  signed char v2:8;
  signed int v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8i_BFu8i) C1{ Fc:8 Fc:8 Fi:8 Fi:8}



static void Test_BFs8c_BFs8c_BFs8i_BFu8i()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8i_BFu8i");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8i_BFu8i, BFs8c_BFs8c_BFs8i_BFu8i)
//============================================================================


struct  BFs8c_BFs8c_BFs8i_BFu8ll  {
  signed char v1:8;
  signed char v2:8;
  signed int v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8i_BFu8ll) C1{ Fc:8 Fc:8 Fi:8 FL:8}



static void Test_BFs8c_BFs8c_BFs8i_BFu8ll()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8i_BFu8ll");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8i_BFu8ll, BFs8c_BFs8c_BFs8i_BFu8ll)
//============================================================================


struct  BFs8c_BFs8c_BFs8i_BFu8s  {
  signed char v1:8;
  signed char v2:8;
  signed int v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8i_BFu8s) C1{ Fc:8 Fc:8 Fi:8 Fs:8}



static void Test_BFs8c_BFs8c_BFs8i_BFu8s()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8i_BFu8s");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8i_BFu8s, BFs8c_BFs8c_BFs8i_BFu8s)
//============================================================================


struct  BFs8c_BFs8c_BFs8ll  {
  signed char v1:8;
  signed char v2:8;
  signed __tsi64 v3:8;
};
//SIG(1 BFs8c_BFs8c_BFs8ll) C1{ Fc:8 Fc:8 FL:8}



static void Test_BFs8c_BFs8c_BFs8ll()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8ll");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8ll, BFs8c_BFs8c_BFs8ll)
//============================================================================


struct  BFs8c_BFs8c_BFs8ll_BFs8c  {
  signed char v1:8;
  signed char v2:8;
  signed __tsi64 v3:8;
  signed char v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8ll_BFs8c) C1{ Fc:8 Fc:8 FL:8 Fc:8}



static void Test_BFs8c_BFs8c_BFs8ll_BFs8c()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8ll_BFs8c");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8ll_BFs8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8ll_BFs8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8ll_BFs8c, BFs8c_BFs8c_BFs8ll_BFs8c)
//============================================================================


struct  BFs8c_BFs8c_BFs8ll_BFs8i  {
  signed char v1:8;
  signed char v2:8;
  signed __tsi64 v3:8;
  signed int v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8ll_BFs8i) C1{ Fc:8 Fc:8 FL:8 Fi:8}



static void Test_BFs8c_BFs8c_BFs8ll_BFs8i()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8ll_BFs8i");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8ll_BFs8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8ll_BFs8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8ll_BFs8i, BFs8c_BFs8c_BFs8ll_BFs8i)
//============================================================================


struct  BFs8c_BFs8c_BFs8ll_BFs8ll  {
  signed char v1:8;
  signed char v2:8;
  signed __tsi64 v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8ll_BFs8ll) C1{ Fc:8 Fc:8 FL:8 FL:8}



static void Test_BFs8c_BFs8c_BFs8ll_BFs8ll()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8ll_BFs8ll");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8ll_BFs8ll, BFs8c_BFs8c_BFs8ll_BFs8ll)
//============================================================================


struct  BFs8c_BFs8c_BFs8ll_BFs8s  {
  signed char v1:8;
  signed char v2:8;
  signed __tsi64 v3:8;
  signed short v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8ll_BFs8s) C1{ Fc:8 Fc:8 FL:8 Fs:8}



static void Test_BFs8c_BFs8c_BFs8ll_BFs8s()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8ll_BFs8s");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8ll_BFs8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8ll_BFs8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8ll_BFs8s, BFs8c_BFs8c_BFs8ll_BFs8s)
//============================================================================


struct  BFs8c_BFs8c_BFs8ll_BFu8c  {
  signed char v1:8;
  signed char v2:8;
  signed __tsi64 v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8ll_BFu8c) C1{ Fc:8 Fc:8 FL:8 Fc:8}



static void Test_BFs8c_BFs8c_BFs8ll_BFu8c()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8ll_BFu8c");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8ll_BFu8c, BFs8c_BFs8c_BFs8ll_BFu8c)
//============================================================================


struct  BFs8c_BFs8c_BFs8ll_BFu8i  {
  signed char v1:8;
  signed char v2:8;
  signed __tsi64 v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8ll_BFu8i) C1{ Fc:8 Fc:8 FL:8 Fi:8}



static void Test_BFs8c_BFs8c_BFs8ll_BFu8i()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8ll_BFu8i");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8ll_BFu8i, BFs8c_BFs8c_BFs8ll_BFu8i)
//============================================================================


struct  BFs8c_BFs8c_BFs8ll_BFu8ll  {
  signed char v1:8;
  signed char v2:8;
  signed __tsi64 v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8ll_BFu8ll) C1{ Fc:8 Fc:8 FL:8 FL:8}



static void Test_BFs8c_BFs8c_BFs8ll_BFu8ll()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8ll_BFu8ll");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8ll_BFu8ll, BFs8c_BFs8c_BFs8ll_BFu8ll)
//============================================================================


struct  BFs8c_BFs8c_BFs8ll_BFu8s  {
  signed char v1:8;
  signed char v2:8;
  signed __tsi64 v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8ll_BFu8s) C1{ Fc:8 Fc:8 FL:8 Fs:8}



static void Test_BFs8c_BFs8c_BFs8ll_BFu8s()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8ll_BFu8s");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8ll_BFu8s, BFs8c_BFs8c_BFs8ll_BFu8s)
//============================================================================


struct  BFs8c_BFs8c_BFs8s  {
  signed char v1:8;
  signed char v2:8;
  signed short v3:8;
};
//SIG(1 BFs8c_BFs8c_BFs8s) C1{ Fc:8 Fc:8 Fs:8}



static void Test_BFs8c_BFs8c_BFs8s()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8s");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8c_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8s, BFs8c_BFs8c_BFs8s)
//============================================================================


struct  BFs8c_BFs8c_BFs8s_BFs8c  {
  signed char v1:8;
  signed char v2:8;
  signed short v3:8;
  signed char v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8s_BFs8c) C1{ Fc:8 Fc:8 Fs:8 Fc:8}



static void Test_BFs8c_BFs8c_BFs8s_BFs8c()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8s_BFs8c");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8s_BFs8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8c_BFs8c_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8s_BFs8c, BFs8c_BFs8c_BFs8s_BFs8c)
//============================================================================


struct  BFs8c_BFs8c_BFs8s_BFs8i  {
  signed char v1:8;
  signed char v2:8;
  signed short v3:8;
  signed int v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8s_BFs8i) C1{ Fc:8 Fc:8 Fs:8 Fi:8}



static void Test_BFs8c_BFs8c_BFs8s_BFs8i()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8s_BFs8i");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8s_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8s_BFs8i, BFs8c_BFs8c_BFs8s_BFs8i)
//============================================================================


struct  BFs8c_BFs8c_BFs8s_BFs8ll  {
  signed char v1:8;
  signed char v2:8;
  signed short v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8s_BFs8ll) C1{ Fc:8 Fc:8 Fs:8 FL:8}



static void Test_BFs8c_BFs8c_BFs8s_BFs8ll()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8s_BFs8ll");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8s_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8s_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8s_BFs8ll, BFs8c_BFs8c_BFs8s_BFs8ll)
//============================================================================


struct  BFs8c_BFs8c_BFs8s_BFs8s  {
  signed char v1:8;
  signed char v2:8;
  signed short v3:8;
  signed short v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8s_BFs8s) C1{ Fc:8 Fc:8 Fs:8 Fs:8}



static void Test_BFs8c_BFs8c_BFs8s_BFs8s()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8s_BFs8s");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8s_BFs8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8c_BFs8c_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8s_BFs8s, BFs8c_BFs8c_BFs8s_BFs8s)
//============================================================================


struct  BFs8c_BFs8c_BFs8s_BFu8c  {
  signed char v1:8;
  signed char v2:8;
  signed short v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8s_BFu8c) C1{ Fc:8 Fc:8 Fs:8 Fc:8}



static void Test_BFs8c_BFs8c_BFs8s_BFu8c()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8s_BFu8c");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8c_BFs8c_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8s_BFu8c, BFs8c_BFs8c_BFs8s_BFu8c)
//============================================================================


struct  BFs8c_BFs8c_BFs8s_BFu8i  {
  signed char v1:8;
  signed char v2:8;
  signed short v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8s_BFu8i) C1{ Fc:8 Fc:8 Fs:8 Fi:8}



static void Test_BFs8c_BFs8c_BFs8s_BFu8i()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8s_BFu8i");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8s_BFu8i, BFs8c_BFs8c_BFs8s_BFu8i)
//============================================================================


struct  BFs8c_BFs8c_BFs8s_BFu8ll  {
  signed char v1:8;
  signed char v2:8;
  signed short v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8s_BFu8ll) C1{ Fc:8 Fc:8 Fs:8 FL:8}



static void Test_BFs8c_BFs8c_BFs8s_BFu8ll()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8s_BFu8ll");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFs8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8s_BFu8ll, BFs8c_BFs8c_BFs8s_BFu8ll)
//============================================================================


struct  BFs8c_BFs8c_BFs8s_BFu8s  {
  signed char v1:8;
  signed char v2:8;
  signed short v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8c_BFs8c_BFs8s_BFu8s) C1{ Fc:8 Fc:8 Fs:8 Fs:8}



static void Test_BFs8c_BFs8c_BFs8s_BFu8s()
{
  {
    init_simple_test("BFs8c_BFs8c_BFs8s_BFu8s");
    static STRUCT_IF_C BFs8c_BFs8c_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFs8s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8c_BFs8c_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFs8s_BFu8s, BFs8c_BFs8c_BFs8s_BFu8s)
//============================================================================


struct  BFs8c_BFs8c_BFu8c  {
  signed char v1:8;
  signed char v2:8;
  unsigned char v3:8;
};
//SIG(1 BFs8c_BFs8c_BFu8c) C1{ Fc:8 Fc:8 Fc:8}



static void Test_BFs8c_BFs8c_BFu8c()
{
  {
    init_simple_test("BFs8c_BFs8c_BFu8c");
    static STRUCT_IF_C BFs8c_BFs8c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFs8c_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8c_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFu8c, BFs8c_BFs8c_BFu8c)
//============================================================================


struct  BFs8c_BFs8c_BFu8c_BFs8c  {
  signed char v1:8;
  signed char v2:8;
  unsigned char v3:8;
  signed char v4:8;
};
//SIG(1 BFs8c_BFs8c_BFu8c_BFs8c) C1{ Fc:8 Fc:8 Fc:8 Fc:8}



static void Test_BFs8c_BFs8c_BFu8c_BFs8c()
{
  {
    init_simple_test("BFs8c_BFs8c_BFu8c_BFs8c");
    static STRUCT_IF_C BFs8c_BFs8c_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8c_BFs8c_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFu8c_BFs8c, BFs8c_BFs8c_BFu8c_BFs8c)
//============================================================================


struct  BFs8c_BFs8c_BFu8c_BFs8i  {
  signed char v1:8;
  signed char v2:8;
  unsigned char v3:8;
  signed int v4:8;
};
//SIG(1 BFs8c_BFs8c_BFu8c_BFs8i) C1{ Fc:8 Fc:8 Fc:8 Fi:8}



static void Test_BFs8c_BFs8c_BFu8c_BFs8i()
{
  {
    init_simple_test("BFs8c_BFs8c_BFu8c_BFs8i");
    static STRUCT_IF_C BFs8c_BFs8c_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFu8c_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFu8c_BFs8i, BFs8c_BFs8c_BFu8c_BFs8i)
//============================================================================


struct  BFs8c_BFs8c_BFu8c_BFs8ll  {
  signed char v1:8;
  signed char v2:8;
  unsigned char v3:8;
  signed __tsi64 v4:8;
};
//SIG(1 BFs8c_BFs8c_BFu8c_BFs8ll) C1{ Fc:8 Fc:8 Fc:8 FL:8}



static void Test_BFs8c_BFs8c_BFu8c_BFs8ll()
{
  {
    init_simple_test("BFs8c_BFs8c_BFu8c_BFs8ll");
    static STRUCT_IF_C BFs8c_BFs8c_BFu8c_BFs8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFu8c_BFs8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFu8c_BFs8ll, BFs8c_BFs8c_BFu8c_BFs8ll)
//============================================================================


struct  BFs8c_BFs8c_BFu8c_BFs8s  {
  signed char v1:8;
  signed char v2:8;
  unsigned char v3:8;
  signed short v4:8;
};
//SIG(1 BFs8c_BFs8c_BFu8c_BFs8s) C1{ Fc:8 Fc:8 Fc:8 Fs:8}



static void Test_BFs8c_BFs8c_BFu8c_BFs8s()
{
  {
    init_simple_test("BFs8c_BFs8c_BFu8c_BFs8s");
    static STRUCT_IF_C BFs8c_BFs8c_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFu8c_BFs8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8c_BFs8c_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFu8c_BFs8s, BFs8c_BFs8c_BFu8c_BFs8s)
//============================================================================


struct  BFs8c_BFs8c_BFu8c_BFu8c  {
  signed char v1:8;
  signed char v2:8;
  unsigned char v3:8;
  unsigned char v4:8;
};
//SIG(1 BFs8c_BFs8c_BFu8c_BFu8c) C1{ Fc:8 Fc:8 Fc:8 Fc:8}



static void Test_BFs8c_BFs8c_BFu8c_BFu8c()
{
  {
    init_simple_test("BFs8c_BFs8c_BFu8c_BFu8c");
    static STRUCT_IF_C BFs8c_BFs8c_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs8c_BFs8c_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFu8c_BFu8c, BFs8c_BFs8c_BFu8c_BFu8c)
//============================================================================


struct  BFs8c_BFs8c_BFu8c_BFu8i  {
  signed char v1:8;
  signed char v2:8;
  unsigned char v3:8;
  unsigned int v4:8;
};
//SIG(1 BFs8c_BFs8c_BFu8c_BFu8i) C1{ Fc:8 Fc:8 Fc:8 Fi:8}



static void Test_BFs8c_BFs8c_BFu8c_BFu8i()
{
  {
    init_simple_test("BFs8c_BFs8c_BFu8c_BFu8i");
    static STRUCT_IF_C BFs8c_BFs8c_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFu8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFu8c_BFu8i, BFs8c_BFs8c_BFu8c_BFu8i)
//============================================================================


struct  BFs8c_BFs8c_BFu8c_BFu8ll  {
  signed char v1:8;
  signed char v2:8;
  unsigned char v3:8;
  __tsu64 v4:8;
};
//SIG(1 BFs8c_BFs8c_BFu8c_BFu8ll) C1{ Fc:8 Fc:8 Fc:8 FL:8}



static void Test_BFs8c_BFs8c_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFs8c_BFs8c_BFu8c_BFu8ll");
    static STRUCT_IF_C BFs8c_BFs8c_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs8c_BFs8c_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs8c_BFs8c_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFu8c_BFu8ll, BFs8c_BFs8c_BFu8c_BFu8ll)
//============================================================================


struct  BFs8c_BFs8c_BFu8c_BFu8s  {
  signed char v1:8;
  signed char v2:8;
  unsigned char v3:8;
  unsigned short v4:8;
};
//SIG(1 BFs8c_BFs8c_BFu8c_BFu8s) C1{ Fc:8 Fc:8 Fc:8 Fs:8}



static void Test_BFs8c_BFs8c_BFu8c_BFu8s()
{
  {
    init_simple_test("BFs8c_BFs8c_BFu8c_BFu8s");
    static STRUCT_IF_C BFs8c_BFs8c_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFu8c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs8c_BFs8c_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFu8c_BFu8s, BFs8c_BFs8c_BFu8c_BFu8s)
//============================================================================


struct  BFs8c_BFs8c_BFu8i  {
  signed char v1:8;
  signed char v2:8;
  unsigned int v3:8;
};
//SIG(1 BFs8c_BFs8c_BFu8i) C1{ Fc:8 Fc:8 Fi:8}



static void Test_BFs8c_BFs8c_BFu8i()
{
  {
    init_simple_test("BFs8c_BFs8c_BFu8i");
    static STRUCT_IF_C BFs8c_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFu8i, BFs8c_BFs8c_BFu8i)
//============================================================================


struct  BFs8c_BFs8c_BFu8i_BFs8c  {
  signed char v1:8;
  signed char v2:8;
  unsigned int v3:8;
  signed char v4:8;
};
//SIG(1 BFs8c_BFs8c_BFu8i_BFs8c) C1{ Fc:8 Fc:8 Fi:8 Fc:8}



static void Test_BFs8c_BFs8c_BFu8i_BFs8c()
{
  {
    init_simple_test("BFs8c_BFs8c_BFu8i_BFs8c");
    static STRUCT_IF_C BFs8c_BFs8c_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFu8i_BFs8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs8c_BFs8c_BFu8i_BFs8c, BFs8c_BFs8c_BFu8i_BFs8c)
//============================================================================


struct  BFs8c_BFs8c_BFu8i_BFs8i  {
  signed char v1:8;
  signed char v2:8;
  unsigned int v3:8;
  signed int v4:8;
};
//SIG(1 BFs8c_BFs8c_BFu8i_BFs8i) C1{ Fc:8 Fc:8 Fi:8 Fi:8}



static void Test_BFs8c_BFs8c_BFu8i_BFs8i()
{
  {
    init_simple_test("BFs8c_BFs8c_BFu8i_BFs8i");
    static STRUCT_IF_C BFs8c_BFs8c_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(BFs8c_BFs8c_BFu8i_BFs8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs8c_BFs8c_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFs8c_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFs8c_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "BFs8c_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFs8c_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFs8c_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "BFs8c_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "BFs8c_BF