// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  BFs1ll_BFs1i_BFu1c_BFu1i  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1c_BFu1i) C1{ FL:1 Fi:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFs1i_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1c_BFu1i, BFs1ll_BFs1i_BFu1c_BFu1i)
//============================================================================


struct  BFs1ll_BFs1i_BFu1c_BFu1ll  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1c_BFu1ll) C1{ FL:1 Fi:1 Fc:1 FL:1}



static void Test_BFs1ll_BFs1i_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1c_BFu1ll, BFs1ll_BFs1i_BFu1c_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1i_BFu1c_BFu1s  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1c_BFu1s) C1{ FL:1 Fi:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFs1i_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1c_BFu1s, BFs1ll_BFs1i_BFu1c_BFu1s)
//============================================================================


struct  BFs1ll_BFs1i_BFu1i  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1i) C1{ FL:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1i, BFs1ll_BFs1i_BFu1i)
//============================================================================


struct  BFs1ll_BFs1i_BFu1i_BFs1c  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1i_BFs1c) C1{ FL:1 Fi:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFs1i_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1i_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1i_BFs1c, BFs1ll_BFs1i_BFu1i_BFs1c)
//============================================================================


struct  BFs1ll_BFs1i_BFu1i_BFs1i  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1i_BFs1i) C1{ FL:1 Fi:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFs1i_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1i_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1i_BFs1i, BFs1ll_BFs1i_BFu1i_BFs1i)
//============================================================================


struct  BFs1ll_BFs1i_BFu1i_BFs1ll  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1i_BFs1ll) C1{ FL:1 Fi:1 Fi:1 FL:1}



static void Test_BFs1ll_BFs1i_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1i_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1i_BFs1ll, BFs1ll_BFs1i_BFu1i_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1i_BFu1i_BFs1s  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1i_BFs1s) C1{ FL:1 Fi:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFs1i_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1i_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1i_BFs1s, BFs1ll_BFs1i_BFu1i_BFs1s)
//============================================================================


struct  BFs1ll_BFs1i_BFu1i_BFu1c  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1i_BFu1c) C1{ FL:1 Fi:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFs1i_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1i_BFu1c, BFs1ll_BFs1i_BFu1i_BFu1c)
//============================================================================


struct  BFs1ll_BFs1i_BFu1i_BFu1i  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1i_BFu1i) C1{ FL:1 Fi:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFs1i_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1i_BFu1i, BFs1ll_BFs1i_BFu1i_BFu1i)
//============================================================================


struct  BFs1ll_BFs1i_BFu1i_BFu1ll  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1i_BFu1ll) C1{ FL:1 Fi:1 Fi:1 FL:1}



static void Test_BFs1ll_BFs1i_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1i_BFu1ll, BFs1ll_BFs1i_BFu1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1i_BFu1i_BFu1s  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1i_BFu1s) C1{ FL:1 Fi:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFs1i_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1i_BFu1s, BFs1ll_BFs1i_BFu1i_BFu1s)
//============================================================================


struct  BFs1ll_BFs1i_BFu1ll  {
  signed __tsi64 v1:1;
  signed int v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1ll) C1{ FL:1 Fi:1 FL:1}



static void Test_BFs1ll_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1ll, BFs1ll_BFs1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1i_BFu1ll_BFs1c  {
  signed __tsi64 v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1ll_BFs1c) C1{ FL:1 Fi:1 FL:1 Fc:1}



static void Test_BFs1ll_BFs1i_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1ll_BFs1c, BFs1ll_BFs1i_BFu1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFs1i_BFu1ll_BFs1i  {
  signed __tsi64 v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1ll_BFs1i) C1{ FL:1 Fi:1 FL:1 Fi:1}



static void Test_BFs1ll_BFs1i_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1ll_BFs1i, BFs1ll_BFs1i_BFu1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFs1i_BFu1ll_BFs1ll  {
  signed __tsi64 v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1ll_BFs1ll) C1{ FL:1 Fi:1 FL:1 FL:1}



static void Test_BFs1ll_BFs1i_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1ll_BFs1ll, BFs1ll_BFs1i_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1i_BFu1ll_BFs1s  {
  signed __tsi64 v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1ll_BFs1s) C1{ FL:1 Fi:1 FL:1 Fs:1}



static void Test_BFs1ll_BFs1i_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1ll_BFs1s, BFs1ll_BFs1i_BFu1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFs1i_BFu1ll_BFu1c  {
  signed __tsi64 v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1ll_BFu1c) C1{ FL:1 Fi:1 FL:1 Fc:1}



static void Test_BFs1ll_BFs1i_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1ll_BFu1c, BFs1ll_BFs1i_BFu1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFs1i_BFu1ll_BFu1i  {
  signed __tsi64 v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1ll_BFu1i) C1{ FL:1 Fi:1 FL:1 Fi:1}



static void Test_BFs1ll_BFs1i_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1ll_BFu1i, BFs1ll_BFs1i_BFu1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFs1i_BFu1ll_BFu1ll  {
  signed __tsi64 v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1ll_BFu1ll) C1{ FL:1 Fi:1 FL:1 FL:1}



static void Test_BFs1ll_BFs1i_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1ll_BFu1ll, BFs1ll_BFs1i_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1i_BFu1ll_BFu1s  {
  signed __tsi64 v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1ll_BFu1s) C1{ FL:1 Fi:1 FL:1 Fs:1}



static void Test_BFs1ll_BFs1i_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1ll_BFu1s, BFs1ll_BFs1i_BFu1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFs1i_BFu1s  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1s) C1{ FL:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1s, BFs1ll_BFs1i_BFu1s)
//============================================================================


struct  BFs1ll_BFs1i_BFu1s_BFs1c  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1s_BFs1c) C1{ FL:1 Fi:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFs1i_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1i_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1s_BFs1c, BFs1ll_BFs1i_BFu1s_BFs1c)
//============================================================================


struct  BFs1ll_BFs1i_BFu1s_BFs1i  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1s_BFs1i) C1{ FL:1 Fi:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFs1i_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1i_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1s_BFs1i, BFs1ll_BFs1i_BFu1s_BFs1i)
//============================================================================


struct  BFs1ll_BFs1i_BFu1s_BFs1ll  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1s_BFs1ll) C1{ FL:1 Fi:1 Fs:1 FL:1}



static void Test_BFs1ll_BFs1i_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1i_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1s_BFs1ll, BFs1ll_BFs1i_BFu1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1i_BFu1s_BFs1s  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1s_BFs1s) C1{ FL:1 Fi:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFs1i_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1i_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1s_BFs1s, BFs1ll_BFs1i_BFu1s_BFs1s)
//============================================================================


struct  BFs1ll_BFs1i_BFu1s_BFu1c  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1s_BFu1c) C1{ FL:1 Fi:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFs1i_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1s_BFu1c, BFs1ll_BFs1i_BFu1s_BFu1c)
//============================================================================


struct  BFs1ll_BFs1i_BFu1s_BFu1i  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1s_BFu1i) C1{ FL:1 Fi:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFs1i_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1s_BFu1i, BFs1ll_BFs1i_BFu1s_BFu1i)
//============================================================================


struct  BFs1ll_BFs1i_BFu1s_BFu1ll  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1s_BFu1ll) C1{ FL:1 Fi:1 Fs:1 FL:1}



static void Test_BFs1ll_BFs1i_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1s_BFu1ll, BFs1ll_BFs1i_BFu1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1i_BFu1s_BFu1s  {
  signed __tsi64 v1:1;
  signed int v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1i_BFu1s_BFu1s) C1{ FL:1 Fi:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFs1i_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1i_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1i_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1i_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1i_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1i_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1i_BFu1s_BFu1s, BFs1ll_BFs1i_BFu1s_BFu1s)
//============================================================================


struct  BFs1ll_BFs1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
};
//SIG(1 BFs1ll_BFs1ll) C1{ FL:1 FL:1}



static void Test_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll, BFs1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1c) C1{ FL:1 FL:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1c, BFs1ll_BFs1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1c_BFs1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1c_BFs1c) C1{ FL:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1c_BFs1c, BFs1ll_BFs1ll_BFs1c_BFs1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1c_BFs1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1c_BFs1i) C1{ FL:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1c_BFs1i, BFs1ll_BFs1ll_BFs1c_BFs1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1c_BFs1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1c_BFs1ll) C1{ FL:1 FL:1 Fc:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1c_BFs1ll, BFs1ll_BFs1ll_BFs1c_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1c_BFs1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1c_BFs1s) C1{ FL:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1c_BFs1s, BFs1ll_BFs1ll_BFs1c_BFs1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1c_BFu1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1c_BFu1c) C1{ FL:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1c_BFu1c, BFs1ll_BFs1ll_BFs1c_BFu1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1c_BFu1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1c_BFu1i) C1{ FL:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1c_BFu1i, BFs1ll_BFs1ll_BFs1c_BFu1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1c_BFu1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1c_BFu1ll) C1{ FL:1 FL:1 Fc:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1c_BFu1ll, BFs1ll_BFs1ll_BFs1c_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1c_BFu1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1c_BFu1s) C1{ FL:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1c_BFu1s, BFs1ll_BFs1ll_BFs1c_BFu1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1i) C1{ FL:1 FL:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1i, BFs1ll_BFs1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1i_BFs1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1i_BFs1c) C1{ FL:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1i_BFs1c, BFs1ll_BFs1ll_BFs1i_BFs1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1i_BFs1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1i_BFs1i) C1{ FL:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1i_BFs1i, BFs1ll_BFs1ll_BFs1i_BFs1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1i_BFs1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1i_BFs1ll) C1{ FL:1 FL:1 Fi:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1i_BFs1ll, BFs1ll_BFs1ll_BFs1i_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1i_BFs1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1i_BFs1s) C1{ FL:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1i_BFs1s, BFs1ll_BFs1ll_BFs1i_BFs1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1i_BFu1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1i_BFu1c) C1{ FL:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1i_BFu1c, BFs1ll_BFs1ll_BFs1i_BFu1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1i_BFu1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1i_BFu1i) C1{ FL:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1i_BFu1i, BFs1ll_BFs1ll_BFs1i_BFu1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1i_BFu1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1i_BFu1ll) C1{ FL:1 FL:1 Fi:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1i_BFu1ll, BFs1ll_BFs1ll_BFs1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1i_BFu1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1i_BFu1s) C1{ FL:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1i_BFu1s, BFs1ll_BFs1ll_BFs1i_BFu1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1ll) C1{ FL:1 FL:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1ll, BFs1ll_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1ll_BFs1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1ll_BFs1c) C1{ FL:1 FL:1 FL:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1ll_BFs1c, BFs1ll_BFs1ll_BFs1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1ll_BFs1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1ll_BFs1i) C1{ FL:1 FL:1 FL:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1ll_BFs1i, BFs1ll_BFs1ll_BFs1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1ll_BFs1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1ll_BFs1ll) C1{ FL:1 FL:1 FL:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1ll_BFs1ll, BFs1ll_BFs1ll_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1ll_BFs1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1ll_BFs1s) C1{ FL:1 FL:1 FL:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1ll_BFs1s, BFs1ll_BFs1ll_BFs1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1ll_BFu1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1ll_BFu1c) C1{ FL:1 FL:1 FL:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1ll_BFu1c, BFs1ll_BFs1ll_BFs1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1ll_BFu1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1ll_BFu1i) C1{ FL:1 FL:1 FL:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1ll_BFu1i, BFs1ll_BFs1ll_BFs1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1ll_BFu1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1ll_BFu1ll) C1{ FL:1 FL:1 FL:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1ll_BFu1ll, BFs1ll_BFs1ll_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1ll_BFu1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1ll_BFu1s) C1{ FL:1 FL:1 FL:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1ll_BFu1s, BFs1ll_BFs1ll_BFs1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1s) C1{ FL:1 FL:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1s, BFs1ll_BFs1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1s_BFs1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1s_BFs1c) C1{ FL:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1s_BFs1c, BFs1ll_BFs1ll_BFs1s_BFs1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1s_BFs1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1s_BFs1i) C1{ FL:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1s_BFs1i, BFs1ll_BFs1ll_BFs1s_BFs1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1s_BFs1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1s_BFs1ll) C1{ FL:1 FL:1 Fs:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1s_BFs1ll, BFs1ll_BFs1ll_BFs1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1s_BFs1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1s_BFs1s) C1{ FL:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1s_BFs1s, BFs1ll_BFs1ll_BFs1s_BFs1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1s_BFu1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1s_BFu1c) C1{ FL:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1s_BFu1c, BFs1ll_BFs1ll_BFs1s_BFu1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1s_BFu1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1s_BFu1i) C1{ FL:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1s_BFu1i, BFs1ll_BFs1ll_BFs1s_BFu1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1s_BFu1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1s_BFu1ll) C1{ FL:1 FL:1 Fs:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1s_BFu1ll, BFs1ll_BFs1ll_BFs1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFs1s_BFu1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFs1s_BFu1s) C1{ FL:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFs1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFs1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFs1s_BFu1s, BFs1ll_BFs1ll_BFs1s_BFu1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1c) C1{ FL:1 FL:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1c, BFs1ll_BFs1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1c_BFs1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1c_BFs1c) C1{ FL:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1c_BFs1c, BFs1ll_BFs1ll_BFu1c_BFs1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1c_BFs1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1c_BFs1i) C1{ FL:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1c_BFs1i, BFs1ll_BFs1ll_BFu1c_BFs1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1c_BFs1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1c_BFs1ll) C1{ FL:1 FL:1 Fc:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1c_BFs1ll, BFs1ll_BFs1ll_BFu1c_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1c_BFs1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1c_BFs1s) C1{ FL:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1c_BFs1s, BFs1ll_BFs1ll_BFu1c_BFs1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1c_BFu1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1c_BFu1c) C1{ FL:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1c_BFu1c, BFs1ll_BFs1ll_BFu1c_BFu1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1c_BFu1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1c_BFu1i) C1{ FL:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1c_BFu1i, BFs1ll_BFs1ll_BFu1c_BFu1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1c_BFu1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1c_BFu1ll) C1{ FL:1 FL:1 Fc:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1c_BFu1ll, BFs1ll_BFs1ll_BFu1c_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1c_BFu1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1c_BFu1s) C1{ FL:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1c_BFu1s, BFs1ll_BFs1ll_BFu1c_BFu1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1i) C1{ FL:1 FL:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1i, BFs1ll_BFs1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1i_BFs1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1i_BFs1c) C1{ FL:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1i_BFs1c, BFs1ll_BFs1ll_BFu1i_BFs1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1i_BFs1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1i_BFs1i) C1{ FL:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1i_BFs1i, BFs1ll_BFs1ll_BFu1i_BFs1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1i_BFs1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1i_BFs1ll) C1{ FL:1 FL:1 Fi:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1i_BFs1ll, BFs1ll_BFs1ll_BFu1i_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1i_BFs1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1i_BFs1s) C1{ FL:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1i_BFs1s, BFs1ll_BFs1ll_BFu1i_BFs1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1i_BFu1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1i_BFu1c) C1{ FL:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1i_BFu1c, BFs1ll_BFs1ll_BFu1i_BFu1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1i_BFu1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1i_BFu1i) C1{ FL:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1i_BFu1i, BFs1ll_BFs1ll_BFu1i_BFu1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1i_BFu1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1i_BFu1ll) C1{ FL:1 FL:1 Fi:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1i_BFu1ll, BFs1ll_BFs1ll_BFu1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1i_BFu1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1i_BFu1s) C1{ FL:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1i_BFu1s, BFs1ll_BFs1ll_BFu1i_BFu1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1ll) C1{ FL:1 FL:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1ll, BFs1ll_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1ll_BFs1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1ll_BFs1c) C1{ FL:1 FL:1 FL:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1ll_BFs1c, BFs1ll_BFs1ll_BFu1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1ll_BFs1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1ll_BFs1i) C1{ FL:1 FL:1 FL:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1ll_BFs1i, BFs1ll_BFs1ll_BFu1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1ll_BFs1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1ll_BFs1ll) C1{ FL:1 FL:1 FL:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1ll_BFs1ll, BFs1ll_BFs1ll_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1ll_BFs1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1ll_BFs1s) C1{ FL:1 FL:1 FL:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1ll_BFs1s, BFs1ll_BFs1ll_BFu1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1ll_BFu1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1ll_BFu1c) C1{ FL:1 FL:1 FL:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1ll_BFu1c, BFs1ll_BFs1ll_BFu1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1ll_BFu1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1ll_BFu1i) C1{ FL:1 FL:1 FL:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1ll_BFu1i, BFs1ll_BFs1ll_BFu1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1ll_BFu1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1ll_BFu1ll) C1{ FL:1 FL:1 FL:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1ll_BFu1ll, BFs1ll_BFs1ll_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1ll_BFu1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1ll_BFu1s) C1{ FL:1 FL:1 FL:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1ll_BFu1s, BFs1ll_BFs1ll_BFu1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1s) C1{ FL:1 FL:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1s, BFs1ll_BFs1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1s_BFs1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1s_BFs1c) C1{ FL:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1s_BFs1c, BFs1ll_BFs1ll_BFu1s_BFs1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1s_BFs1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1s_BFs1i) C1{ FL:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1s_BFs1i, BFs1ll_BFs1ll_BFu1s_BFs1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1s_BFs1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1s_BFs1ll) C1{ FL:1 FL:1 Fs:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1s_BFs1ll, BFs1ll_BFs1ll_BFu1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1s_BFs1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1s_BFs1s) C1{ FL:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1s_BFs1s, BFs1ll_BFs1ll_BFu1s_BFs1s)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1s_BFu1c  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1s_BFu1c) C1{ FL:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFs1ll_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1s_BFu1c, BFs1ll_BFs1ll_BFu1s_BFu1c)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1s_BFu1i  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1s_BFu1i) C1{ FL:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFs1ll_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1s_BFu1i, BFs1ll_BFs1ll_BFu1s_BFu1i)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1s_BFu1ll  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1s_BFu1ll) C1{ FL:1 FL:1 Fs:1 FL:1}



static void Test_BFs1ll_BFs1ll_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1s_BFu1ll, BFs1ll_BFs1ll_BFu1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1ll_BFu1s_BFu1s  {
  signed __tsi64 v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1ll_BFu1s_BFu1s) C1{ FL:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFs1ll_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1ll_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1ll_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1ll_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1ll_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1ll_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1ll_BFu1s_BFu1s, BFs1ll_BFs1ll_BFu1s_BFu1s)
//============================================================================


struct  BFs1ll_BFs1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
};
//SIG(1 BFs1ll_BFs1s) C1{ FL:1 Fs:1}



static void Test_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s, BFs1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFs1s_BFs1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed char v3:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1c) C1{ FL:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1c, BFs1ll_BFs1s_BFs1c)
//============================================================================


struct  BFs1ll_BFs1s_BFs1c_BFs1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1c_BFs1c) C1{ FL:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1c_BFs1c, BFs1ll_BFs1s_BFs1c_BFs1c)
//============================================================================


struct  BFs1ll_BFs1s_BFs1c_BFs1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1c_BFs1i) C1{ FL:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1c_BFs1i, BFs1ll_BFs1s_BFs1c_BFs1i)
//============================================================================


struct  BFs1ll_BFs1s_BFs1c_BFs1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1c_BFs1ll) C1{ FL:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1ll_BFs1s_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1c_BFs1ll, BFs1ll_BFs1s_BFs1c_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFs1c_BFs1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1c_BFs1s) C1{ FL:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1c_BFs1s, BFs1ll_BFs1s_BFs1c_BFs1s)
//============================================================================


struct  BFs1ll_BFs1s_BFs1c_BFu1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1c_BFu1c) C1{ FL:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1c_BFu1c, BFs1ll_BFs1s_BFs1c_BFu1c)
//============================================================================


struct  BFs1ll_BFs1s_BFs1c_BFu1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1c_BFu1i) C1{ FL:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1c_BFu1i, BFs1ll_BFs1s_BFs1c_BFu1i)
//============================================================================


struct  BFs1ll_BFs1s_BFs1c_BFu1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1c_BFu1ll) C1{ FL:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1ll_BFs1s_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1c_BFu1ll, BFs1ll_BFs1s_BFs1c_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFs1c_BFu1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1c_BFu1s) C1{ FL:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1c_BFu1s, BFs1ll_BFs1s_BFs1c_BFu1s)
//============================================================================


struct  BFs1ll_BFs1s_BFs1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed int v3:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1i) C1{ FL:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1i, BFs1ll_BFs1s_BFs1i)
//============================================================================


struct  BFs1ll_BFs1s_BFs1i_BFs1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1i_BFs1c) C1{ FL:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1i_BFs1c, BFs1ll_BFs1s_BFs1i_BFs1c)
//============================================================================


struct  BFs1ll_BFs1s_BFs1i_BFs1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1i_BFs1i) C1{ FL:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1i_BFs1i, BFs1ll_BFs1s_BFs1i_BFs1i)
//============================================================================


struct  BFs1ll_BFs1s_BFs1i_BFs1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1i_BFs1ll) C1{ FL:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1ll_BFs1s_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1i_BFs1ll, BFs1ll_BFs1s_BFs1i_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFs1i_BFs1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1i_BFs1s) C1{ FL:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1i_BFs1s, BFs1ll_BFs1s_BFs1i_BFs1s)
//============================================================================


struct  BFs1ll_BFs1s_BFs1i_BFu1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1i_BFu1c) C1{ FL:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1i_BFu1c, BFs1ll_BFs1s_BFs1i_BFu1c)
//============================================================================


struct  BFs1ll_BFs1s_BFs1i_BFu1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1i_BFu1i) C1{ FL:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1i_BFu1i, BFs1ll_BFs1s_BFs1i_BFu1i)
//============================================================================


struct  BFs1ll_BFs1s_BFs1i_BFu1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1i_BFu1ll) C1{ FL:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1ll_BFs1s_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1i_BFu1ll, BFs1ll_BFs1s_BFs1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFs1i_BFu1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1i_BFu1s) C1{ FL:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1i_BFu1s, BFs1ll_BFs1s_BFs1i_BFu1s)
//============================================================================


struct  BFs1ll_BFs1s_BFs1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1ll) C1{ FL:1 Fs:1 FL:1}



static void Test_BFs1ll_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1ll, BFs1ll_BFs1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFs1ll_BFs1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1ll_BFs1c) C1{ FL:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1ll_BFs1c, BFs1ll_BFs1s_BFs1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFs1s_BFs1ll_BFs1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1ll_BFs1i) C1{ FL:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1ll_BFs1i, BFs1ll_BFs1s_BFs1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFs1s_BFs1ll_BFs1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1ll_BFs1ll) C1{ FL:1 Fs:1 FL:1 FL:1}



static void Test_BFs1ll_BFs1s_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1ll_BFs1ll, BFs1ll_BFs1s_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFs1ll_BFs1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1ll_BFs1s) C1{ FL:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1ll_BFs1s, BFs1ll_BFs1s_BFs1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFs1s_BFs1ll_BFu1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1ll_BFu1c) C1{ FL:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1ll_BFu1c, BFs1ll_BFs1s_BFs1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFs1s_BFs1ll_BFu1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1ll_BFu1i) C1{ FL:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1ll_BFu1i, BFs1ll_BFs1s_BFs1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFs1s_BFs1ll_BFu1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1ll_BFu1ll) C1{ FL:1 Fs:1 FL:1 FL:1}



static void Test_BFs1ll_BFs1s_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1ll_BFu1ll, BFs1ll_BFs1s_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFs1ll_BFu1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1ll_BFu1s) C1{ FL:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1ll_BFu1s, BFs1ll_BFs1s_BFs1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFs1s_BFs1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed short v3:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1s) C1{ FL:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1s, BFs1ll_BFs1s_BFs1s)
//============================================================================


struct  BFs1ll_BFs1s_BFs1s_BFs1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1s_BFs1c) C1{ FL:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1s_BFs1c, BFs1ll_BFs1s_BFs1s_BFs1c)
//============================================================================


struct  BFs1ll_BFs1s_BFs1s_BFs1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1s_BFs1i) C1{ FL:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1s_BFs1i, BFs1ll_BFs1s_BFs1s_BFs1i)
//============================================================================


struct  BFs1ll_BFs1s_BFs1s_BFs1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1s_BFs1ll) C1{ FL:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1ll_BFs1s_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1s_BFs1ll, BFs1ll_BFs1s_BFs1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFs1s_BFs1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1s_BFs1s) C1{ FL:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1s_BFs1s, BFs1ll_BFs1s_BFs1s_BFs1s)
//============================================================================


struct  BFs1ll_BFs1s_BFs1s_BFu1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1s_BFu1c) C1{ FL:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1s_BFu1c, BFs1ll_BFs1s_BFs1s_BFu1c)
//============================================================================


struct  BFs1ll_BFs1s_BFs1s_BFu1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1s_BFu1i) C1{ FL:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1s_BFu1i, BFs1ll_BFs1s_BFs1s_BFu1i)
//============================================================================


struct  BFs1ll_BFs1s_BFs1s_BFu1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1s_BFu1ll) C1{ FL:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1ll_BFs1s_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1s_BFu1ll, BFs1ll_BFs1s_BFs1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFs1s_BFu1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFs1s_BFu1s) C1{ FL:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFs1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFs1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFs1s_BFu1s, BFs1ll_BFs1s_BFs1s_BFu1s)
//============================================================================


struct  BFs1ll_BFs1s_BFu1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned char v3:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1c) C1{ FL:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1c, BFs1ll_BFs1s_BFu1c)
//============================================================================


struct  BFs1ll_BFs1s_BFu1c_BFs1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1c_BFs1c) C1{ FL:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1c_BFs1c, BFs1ll_BFs1s_BFu1c_BFs1c)
//============================================================================


struct  BFs1ll_BFs1s_BFu1c_BFs1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1c_BFs1i) C1{ FL:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1c_BFs1i, BFs1ll_BFs1s_BFu1c_BFs1i)
//============================================================================


struct  BFs1ll_BFs1s_BFu1c_BFs1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1c_BFs1ll) C1{ FL:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1ll_BFs1s_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1c_BFs1ll, BFs1ll_BFs1s_BFu1c_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFu1c_BFs1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1c_BFs1s) C1{ FL:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1c_BFs1s, BFs1ll_BFs1s_BFu1c_BFs1s)
//============================================================================


struct  BFs1ll_BFs1s_BFu1c_BFu1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1c_BFu1c) C1{ FL:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1c_BFu1c, BFs1ll_BFs1s_BFu1c_BFu1c)
//============================================================================


struct  BFs1ll_BFs1s_BFu1c_BFu1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1c_BFu1i) C1{ FL:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1c_BFu1i, BFs1ll_BFs1s_BFu1c_BFu1i)
//============================================================================


struct  BFs1ll_BFs1s_BFu1c_BFu1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1c_BFu1ll) C1{ FL:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1ll_BFs1s_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1c_BFu1ll, BFs1ll_BFs1s_BFu1c_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFu1c_BFu1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1c_BFu1s) C1{ FL:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1c_BFu1s, BFs1ll_BFs1s_BFu1c_BFu1s)
//============================================================================


struct  BFs1ll_BFs1s_BFu1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1i) C1{ FL:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1i, BFs1ll_BFs1s_BFu1i)
//============================================================================


struct  BFs1ll_BFs1s_BFu1i_BFs1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1i_BFs1c) C1{ FL:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1i_BFs1c, BFs1ll_BFs1s_BFu1i_BFs1c)
//============================================================================


struct  BFs1ll_BFs1s_BFu1i_BFs1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1i_BFs1i) C1{ FL:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1i_BFs1i, BFs1ll_BFs1s_BFu1i_BFs1i)
//============================================================================


struct  BFs1ll_BFs1s_BFu1i_BFs1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1i_BFs1ll) C1{ FL:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1ll_BFs1s_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1i_BFs1ll, BFs1ll_BFs1s_BFu1i_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFu1i_BFs1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1i_BFs1s) C1{ FL:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1i_BFs1s, BFs1ll_BFs1s_BFu1i_BFs1s)
//============================================================================


struct  BFs1ll_BFs1s_BFu1i_BFu1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1i_BFu1c) C1{ FL:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1i_BFu1c, BFs1ll_BFs1s_BFu1i_BFu1c)
//============================================================================


struct  BFs1ll_BFs1s_BFu1i_BFu1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1i_BFu1i) C1{ FL:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1i_BFu1i, BFs1ll_BFs1s_BFu1i_BFu1i)
//============================================================================


struct  BFs1ll_BFs1s_BFu1i_BFu1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1i_BFu1ll) C1{ FL:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1ll_BFs1s_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1i_BFu1ll, BFs1ll_BFs1s_BFu1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFu1i_BFu1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1i_BFu1s) C1{ FL:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1i_BFu1s, BFs1ll_BFs1s_BFu1i_BFu1s)
//============================================================================


struct  BFs1ll_BFs1s_BFu1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1ll) C1{ FL:1 Fs:1 FL:1}



static void Test_BFs1ll_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1ll, BFs1ll_BFs1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFu1ll_BFs1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1ll_BFs1c) C1{ FL:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1ll_BFs1c, BFs1ll_BFs1s_BFu1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFs1s_BFu1ll_BFs1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1ll_BFs1i) C1{ FL:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1ll_BFs1i, BFs1ll_BFs1s_BFu1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFs1s_BFu1ll_BFs1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1ll_BFs1ll) C1{ FL:1 Fs:1 FL:1 FL:1}



static void Test_BFs1ll_BFs1s_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1ll_BFs1ll, BFs1ll_BFs1s_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFu1ll_BFs1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1ll_BFs1s) C1{ FL:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1ll_BFs1s, BFs1ll_BFs1s_BFu1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFs1s_BFu1ll_BFu1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1ll_BFu1c) C1{ FL:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1ll_BFu1c, BFs1ll_BFs1s_BFu1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFs1s_BFu1ll_BFu1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1ll_BFu1i) C1{ FL:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1ll_BFu1i, BFs1ll_BFs1s_BFu1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFs1s_BFu1ll_BFu1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1ll_BFu1ll) C1{ FL:1 Fs:1 FL:1 FL:1}



static void Test_BFs1ll_BFs1s_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1ll_BFu1ll, BFs1ll_BFs1s_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFu1ll_BFu1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1ll_BFu1s) C1{ FL:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1ll_BFu1s, BFs1ll_BFs1s_BFu1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFs1s_BFu1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1s) C1{ FL:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1s, BFs1ll_BFs1s_BFu1s)
//============================================================================


struct  BFs1ll_BFs1s_BFu1s_BFs1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1s_BFs1c) C1{ FL:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1s_BFs1c, BFs1ll_BFs1s_BFu1s_BFs1c)
//============================================================================


struct  BFs1ll_BFs1s_BFu1s_BFs1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1s_BFs1i) C1{ FL:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1s_BFs1i, BFs1ll_BFs1s_BFu1s_BFs1i)
//============================================================================


struct  BFs1ll_BFs1s_BFu1s_BFs1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1s_BFs1ll) C1{ FL:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1ll_BFs1s_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1s_BFs1ll, BFs1ll_BFs1s_BFu1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFu1s_BFs1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1s_BFs1s) C1{ FL:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1s_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1s_BFs1s, BFs1ll_BFs1s_BFu1s_BFs1s)
//============================================================================


struct  BFs1ll_BFs1s_BFu1s_BFu1c  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1s_BFu1c) C1{ FL:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFs1s_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1s_BFu1c, BFs1ll_BFs1s_BFu1s_BFu1c)
//============================================================================


struct  BFs1ll_BFs1s_BFu1s_BFu1i  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1s_BFu1i) C1{ FL:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFs1s_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1s_BFu1i, BFs1ll_BFs1s_BFu1s_BFu1i)
//============================================================================


struct  BFs1ll_BFs1s_BFu1s_BFu1ll  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1s_BFu1ll) C1{ FL:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1ll_BFs1s_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1s_BFu1ll, BFs1ll_BFs1s_BFu1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFs1s_BFu1s_BFu1s  {
  signed __tsi64 v1:1;
  signed short v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFs1s_BFu1s_BFu1s) C1{ FL:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFs1s_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1s_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1s_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFs1s_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFs1s_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1s_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1s_BFu1s_BFu1s, BFs1ll_BFs1s_BFu1s_BFu1s)
//============================================================================


struct  BFs1ll_BFu1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
};
//SIG(1 BFs1ll_BFu1c) C1{ FL:1 Fc:1}



static void Test_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c, BFs1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFu1c_BFs1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed char v3:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1c) C1{ FL:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1c, BFs1ll_BFu1c_BFs1c)
//============================================================================


struct  BFs1ll_BFu1c_BFs1c_BFs1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1c_BFs1c) C1{ FL:1 Fc:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1c_BFs1c, BFs1ll_BFu1c_BFs1c_BFs1c)
//============================================================================


struct  BFs1ll_BFu1c_BFs1c_BFs1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1c_BFs1i) C1{ FL:1 Fc:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1c_BFs1i, BFs1ll_BFu1c_BFs1c_BFs1i)
//============================================================================


struct  BFs1ll_BFu1c_BFs1c_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1c_BFs1ll) C1{ FL:1 Fc:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1c_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1c_BFs1ll, BFs1ll_BFu1c_BFs1c_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFs1c_BFs1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1c_BFs1s) C1{ FL:1 Fc:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1c_BFs1s, BFs1ll_BFu1c_BFs1c_BFs1s)
//============================================================================


struct  BFs1ll_BFu1c_BFs1c_BFu1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1c_BFu1c) C1{ FL:1 Fc:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1c_BFu1c, BFs1ll_BFu1c_BFs1c_BFu1c)
//============================================================================


struct  BFs1ll_BFu1c_BFs1c_BFu1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1c_BFu1i) C1{ FL:1 Fc:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1c_BFu1i, BFs1ll_BFu1c_BFs1c_BFu1i)
//============================================================================


struct  BFs1ll_BFu1c_BFs1c_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1c_BFu1ll) C1{ FL:1 Fc:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1c_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1c_BFu1ll, BFs1ll_BFu1c_BFs1c_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFs1c_BFu1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1c_BFu1s) C1{ FL:1 Fc:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1c_BFu1s, BFs1ll_BFu1c_BFs1c_BFu1s)
//============================================================================


struct  BFs1ll_BFu1c_BFs1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed int v3:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1i) C1{ FL:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1i, BFs1ll_BFu1c_BFs1i)
//============================================================================


struct  BFs1ll_BFu1c_BFs1i_BFs1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1i_BFs1c) C1{ FL:1 Fc:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1i_BFs1c, BFs1ll_BFu1c_BFs1i_BFs1c)
//============================================================================


struct  BFs1ll_BFu1c_BFs1i_BFs1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1i_BFs1i) C1{ FL:1 Fc:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1i_BFs1i, BFs1ll_BFu1c_BFs1i_BFs1i)
//============================================================================


struct  BFs1ll_BFu1c_BFs1i_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1i_BFs1ll) C1{ FL:1 Fc:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1c_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1i_BFs1ll, BFs1ll_BFu1c_BFs1i_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFs1i_BFs1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1i_BFs1s) C1{ FL:1 Fc:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1i_BFs1s, BFs1ll_BFu1c_BFs1i_BFs1s)
//============================================================================


struct  BFs1ll_BFu1c_BFs1i_BFu1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1i_BFu1c) C1{ FL:1 Fc:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1i_BFu1c, BFs1ll_BFu1c_BFs1i_BFu1c)
//============================================================================


struct  BFs1ll_BFu1c_BFs1i_BFu1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1i_BFu1i) C1{ FL:1 Fc:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1i_BFu1i, BFs1ll_BFu1c_BFs1i_BFu1i)
//============================================================================


struct  BFs1ll_BFu1c_BFs1i_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1i_BFu1ll) C1{ FL:1 Fc:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1c_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1i_BFu1ll, BFs1ll_BFu1c_BFs1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFs1i_BFu1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1i_BFu1s) C1{ FL:1 Fc:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1i_BFu1s, BFs1ll_BFu1c_BFs1i_BFu1s)
//============================================================================


struct  BFs1ll_BFu1c_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1ll) C1{ FL:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1ll, BFs1ll_BFu1c_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFs1ll_BFs1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1ll_BFs1c) C1{ FL:1 Fc:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1ll_BFs1c, BFs1ll_BFu1c_BFs1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFu1c_BFs1ll_BFs1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1ll_BFs1i) C1{ FL:1 Fc:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1ll_BFs1i, BFs1ll_BFu1c_BFs1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFu1c_BFs1ll_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1ll_BFs1ll) C1{ FL:1 Fc:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1c_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1ll_BFs1ll, BFs1ll_BFu1c_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFs1ll_BFs1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1ll_BFs1s) C1{ FL:1 Fc:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1ll_BFs1s, BFs1ll_BFu1c_BFs1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFu1c_BFs1ll_BFu1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1ll_BFu1c) C1{ FL:1 Fc:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1ll_BFu1c, BFs1ll_BFu1c_BFs1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFu1c_BFs1ll_BFu1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1ll_BFu1i) C1{ FL:1 Fc:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1ll_BFu1i, BFs1ll_BFu1c_BFs1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFu1c_BFs1ll_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1ll_BFu1ll) C1{ FL:1 Fc:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1c_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1ll_BFu1ll, BFs1ll_BFu1c_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFs1ll_BFu1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1ll_BFu1s) C1{ FL:1 Fc:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1ll_BFu1s, BFs1ll_BFu1c_BFs1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFu1c_BFs1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed short v3:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1s) C1{ FL:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1s, BFs1ll_BFu1c_BFs1s)
//============================================================================


struct  BFs1ll_BFu1c_BFs1s_BFs1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1s_BFs1c) C1{ FL:1 Fc:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1s_BFs1c, BFs1ll_BFu1c_BFs1s_BFs1c)
//============================================================================


struct  BFs1ll_BFu1c_BFs1s_BFs1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1s_BFs1i) C1{ FL:1 Fc:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1s_BFs1i, BFs1ll_BFu1c_BFs1s_BFs1i)
//============================================================================


struct  BFs1ll_BFu1c_BFs1s_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1s_BFs1ll) C1{ FL:1 Fc:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1c_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1s_BFs1ll, BFs1ll_BFu1c_BFs1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFs1s_BFs1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1s_BFs1s) C1{ FL:1 Fc:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1s_BFs1s, BFs1ll_BFu1c_BFs1s_BFs1s)
//============================================================================


struct  BFs1ll_BFu1c_BFs1s_BFu1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1s_BFu1c) C1{ FL:1 Fc:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1s_BFu1c, BFs1ll_BFu1c_BFs1s_BFu1c)
//============================================================================


struct  BFs1ll_BFu1c_BFs1s_BFu1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1s_BFu1i) C1{ FL:1 Fc:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1s_BFu1i, BFs1ll_BFu1c_BFs1s_BFu1i)
//============================================================================


struct  BFs1ll_BFu1c_BFs1s_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1s_BFu1ll) C1{ FL:1 Fc:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1c_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1s_BFu1ll, BFs1ll_BFu1c_BFs1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFs1s_BFu1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFs1s_BFu1s) C1{ FL:1 Fc:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFs1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFs1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFs1s_BFu1s, BFs1ll_BFu1c_BFs1s_BFu1s)
//============================================================================


struct  BFs1ll_BFu1c_BFu1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1c) C1{ FL:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1c, BFs1ll_BFu1c_BFu1c)
//============================================================================


struct  BFs1ll_BFu1c_BFu1c_BFs1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1c_BFs1c) C1{ FL:1 Fc:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1c_BFs1c, BFs1ll_BFu1c_BFu1c_BFs1c)
//============================================================================


struct  BFs1ll_BFu1c_BFu1c_BFs1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1c_BFs1i) C1{ FL:1 Fc:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1c_BFs1i, BFs1ll_BFu1c_BFu1c_BFs1i)
//============================================================================


struct  BFs1ll_BFu1c_BFu1c_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1c_BFs1ll) C1{ FL:1 Fc:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1c_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1c_BFs1ll, BFs1ll_BFu1c_BFu1c_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFu1c_BFs1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1c_BFs1s) C1{ FL:1 Fc:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1c_BFs1s, BFs1ll_BFu1c_BFu1c_BFs1s)
//============================================================================


struct  BFs1ll_BFu1c_BFu1c_BFu1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1c_BFu1c) C1{ FL:1 Fc:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1c_BFu1c, BFs1ll_BFu1c_BFu1c_BFu1c)
//============================================================================


struct  BFs1ll_BFu1c_BFu1c_BFu1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1c_BFu1i) C1{ FL:1 Fc:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1c_BFu1i, BFs1ll_BFu1c_BFu1c_BFu1i)
//============================================================================


struct  BFs1ll_BFu1c_BFu1c_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1c_BFu1ll) C1{ FL:1 Fc:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1c_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1c_BFu1ll, BFs1ll_BFu1c_BFu1c_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFu1c_BFu1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1c_BFu1s) C1{ FL:1 Fc:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1c_BFu1s, BFs1ll_BFu1c_BFu1c_BFu1s)
//============================================================================


struct  BFs1ll_BFu1c_BFu1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1i) C1{ FL:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1i, BFs1ll_BFu1c_BFu1i)
//============================================================================


struct  BFs1ll_BFu1c_BFu1i_BFs1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1i_BFs1c) C1{ FL:1 Fc:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1i_BFs1c, BFs1ll_BFu1c_BFu1i_BFs1c)
//============================================================================


struct  BFs1ll_BFu1c_BFu1i_BFs1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1i_BFs1i) C1{ FL:1 Fc:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1i_BFs1i, BFs1ll_BFu1c_BFu1i_BFs1i)
//============================================================================


struct  BFs1ll_BFu1c_BFu1i_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1i_BFs1ll) C1{ FL:1 Fc:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1c_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1i_BFs1ll, BFs1ll_BFu1c_BFu1i_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFu1i_BFs1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1i_BFs1s) C1{ FL:1 Fc:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1i_BFs1s, BFs1ll_BFu1c_BFu1i_BFs1s)
//============================================================================


struct  BFs1ll_BFu1c_BFu1i_BFu1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1i_BFu1c) C1{ FL:1 Fc:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1i_BFu1c, BFs1ll_BFu1c_BFu1i_BFu1c)
//============================================================================


struct  BFs1ll_BFu1c_BFu1i_BFu1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1i_BFu1i) C1{ FL:1 Fc:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1i_BFu1i, BFs1ll_BFu1c_BFu1i_BFu1i)
//============================================================================


struct  BFs1ll_BFu1c_BFu1i_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1i_BFu1ll) C1{ FL:1 Fc:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1c_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1i_BFu1ll, BFs1ll_BFu1c_BFu1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFu1i_BFu1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1i_BFu1s) C1{ FL:1 Fc:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1i_BFu1s, BFs1ll_BFu1c_BFu1i_BFu1s)
//============================================================================


struct  BFs1ll_BFu1c_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1ll) C1{ FL:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1ll, BFs1ll_BFu1c_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFu1ll_BFs1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1ll_BFs1c) C1{ FL:1 Fc:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1ll_BFs1c, BFs1ll_BFu1c_BFu1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFu1c_BFu1ll_BFs1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1ll_BFs1i) C1{ FL:1 Fc:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1ll_BFs1i, BFs1ll_BFu1c_BFu1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFu1c_BFu1ll_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1ll_BFs1ll) C1{ FL:1 Fc:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1c_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1ll_BFs1ll, BFs1ll_BFu1c_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFu1ll_BFs1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1ll_BFs1s) C1{ FL:1 Fc:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1ll_BFs1s, BFs1ll_BFu1c_BFu1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFu1c_BFu1ll_BFu1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1ll_BFu1c) C1{ FL:1 Fc:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1ll_BFu1c, BFs1ll_BFu1c_BFu1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFu1c_BFu1ll_BFu1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1ll_BFu1i) C1{ FL:1 Fc:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1ll_BFu1i, BFs1ll_BFu1c_BFu1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFu1c_BFu1ll_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1ll_BFu1ll) C1{ FL:1 Fc:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1c_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1ll_BFu1ll, BFs1ll_BFu1c_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFu1ll_BFu1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1ll_BFu1s) C1{ FL:1 Fc:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1ll_BFu1s, BFs1ll_BFu1c_BFu1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFu1c_BFu1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1s) C1{ FL:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1s, BFs1ll_BFu1c_BFu1s)
//============================================================================


struct  BFs1ll_BFu1c_BFu1s_BFs1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1s_BFs1c) C1{ FL:1 Fc:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1s_BFs1c, BFs1ll_BFu1c_BFu1s_BFs1c)
//============================================================================


struct  BFs1ll_BFu1c_BFu1s_BFs1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1s_BFs1i) C1{ FL:1 Fc:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1s_BFs1i, BFs1ll_BFu1c_BFu1s_BFs1i)
//============================================================================


struct  BFs1ll_BFu1c_BFu1s_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1s_BFs1ll) C1{ FL:1 Fc:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1c_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1s_BFs1ll, BFs1ll_BFu1c_BFu1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFu1s_BFs1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1s_BFs1s) C1{ FL:1 Fc:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1c_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1s_BFs1s, BFs1ll_BFu1c_BFu1s_BFs1s)
//============================================================================


struct  BFs1ll_BFu1c_BFu1s_BFu1c  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1s_BFu1c) C1{ FL:1 Fc:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1c_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1s_BFu1c, BFs1ll_BFu1c_BFu1s_BFu1c)
//============================================================================


struct  BFs1ll_BFu1c_BFu1s_BFu1i  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1s_BFu1i) C1{ FL:1 Fc:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1c_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1s_BFu1i, BFs1ll_BFu1c_BFu1s_BFu1i)
//============================================================================


struct  BFs1ll_BFu1c_BFu1s_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1s_BFu1ll) C1{ FL:1 Fc:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1c_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1s_BFu1ll, BFs1ll_BFu1c_BFu1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1c_BFu1s_BFu1s  {
  signed __tsi64 v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1c_BFu1s_BFu1s) C1{ FL:1 Fc:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1c_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1c_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1c_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1c_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1c_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1c_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1c_BFu1s_BFu1s, BFs1ll_BFu1c_BFu1s_BFu1s)
//============================================================================


struct  BFs1ll_BFu1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
};
//SIG(1 BFs1ll_BFu1i) C1{ FL:1 Fi:1}



static void Test_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i, BFs1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFu1i_BFs1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed char v3:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1c) C1{ FL:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1c, BFs1ll_BFu1i_BFs1c)
//============================================================================


struct  BFs1ll_BFu1i_BFs1c_BFs1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1c_BFs1c) C1{ FL:1 Fi:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1c_BFs1c, BFs1ll_BFu1i_BFs1c_BFs1c)
//============================================================================


struct  BFs1ll_BFu1i_BFs1c_BFs1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1c_BFs1i) C1{ FL:1 Fi:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1c_BFs1i, BFs1ll_BFu1i_BFs1c_BFs1i)
//============================================================================


struct  BFs1ll_BFu1i_BFs1c_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1c_BFs1ll) C1{ FL:1 Fi:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1i_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1c_BFs1ll, BFs1ll_BFu1i_BFs1c_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFs1c_BFs1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1c_BFs1s) C1{ FL:1 Fi:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1c_BFs1s, BFs1ll_BFu1i_BFs1c_BFs1s)
//============================================================================


struct  BFs1ll_BFu1i_BFs1c_BFu1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1c_BFu1c) C1{ FL:1 Fi:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1c_BFu1c, BFs1ll_BFu1i_BFs1c_BFu1c)
//============================================================================


struct  BFs1ll_BFu1i_BFs1c_BFu1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1c_BFu1i) C1{ FL:1 Fi:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1c_BFu1i, BFs1ll_BFu1i_BFs1c_BFu1i)
//============================================================================


struct  BFs1ll_BFu1i_BFs1c_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1c_BFu1ll) C1{ FL:1 Fi:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1i_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1c_BFu1ll, BFs1ll_BFu1i_BFs1c_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFs1c_BFu1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1c_BFu1s) C1{ FL:1 Fi:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1c_BFu1s, BFs1ll_BFu1i_BFs1c_BFu1s)
//============================================================================


struct  BFs1ll_BFu1i_BFs1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed int v3:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1i) C1{ FL:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1i, BFs1ll_BFu1i_BFs1i)
//============================================================================


struct  BFs1ll_BFu1i_BFs1i_BFs1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1i_BFs1c) C1{ FL:1 Fi:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1i_BFs1c, BFs1ll_BFu1i_BFs1i_BFs1c)
//============================================================================


struct  BFs1ll_BFu1i_BFs1i_BFs1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1i_BFs1i) C1{ FL:1 Fi:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1i_BFs1i, BFs1ll_BFu1i_BFs1i_BFs1i)
//============================================================================


struct  BFs1ll_BFu1i_BFs1i_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1i_BFs1ll) C1{ FL:1 Fi:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1i_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1i_BFs1ll, BFs1ll_BFu1i_BFs1i_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFs1i_BFs1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1i_BFs1s) C1{ FL:1 Fi:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1i_BFs1s, BFs1ll_BFu1i_BFs1i_BFs1s)
//============================================================================


struct  BFs1ll_BFu1i_BFs1i_BFu1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1i_BFu1c) C1{ FL:1 Fi:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1i_BFu1c, BFs1ll_BFu1i_BFs1i_BFu1c)
//============================================================================


struct  BFs1ll_BFu1i_BFs1i_BFu1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1i_BFu1i) C1{ FL:1 Fi:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1i_BFu1i, BFs1ll_BFu1i_BFs1i_BFu1i)
//============================================================================


struct  BFs1ll_BFu1i_BFs1i_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1i_BFu1ll) C1{ FL:1 Fi:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1i_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1i_BFu1ll, BFs1ll_BFu1i_BFs1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFs1i_BFu1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1i_BFu1s) C1{ FL:1 Fi:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1i_BFu1s, BFs1ll_BFu1i_BFs1i_BFu1s)
//============================================================================


struct  BFs1ll_BFu1i_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1ll) C1{ FL:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1ll, BFs1ll_BFu1i_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFs1ll_BFs1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1ll_BFs1c) C1{ FL:1 Fi:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1ll_BFs1c, BFs1ll_BFu1i_BFs1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFu1i_BFs1ll_BFs1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1ll_BFs1i) C1{ FL:1 Fi:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1ll_BFs1i, BFs1ll_BFu1i_BFs1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFu1i_BFs1ll_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1ll_BFs1ll) C1{ FL:1 Fi:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1i_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1ll_BFs1ll, BFs1ll_BFu1i_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFs1ll_BFs1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1ll_BFs1s) C1{ FL:1 Fi:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1ll_BFs1s, BFs1ll_BFu1i_BFs1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFu1i_BFs1ll_BFu1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1ll_BFu1c) C1{ FL:1 Fi:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1ll_BFu1c, BFs1ll_BFu1i_BFs1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFu1i_BFs1ll_BFu1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1ll_BFu1i) C1{ FL:1 Fi:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1ll_BFu1i, BFs1ll_BFu1i_BFs1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFu1i_BFs1ll_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1ll_BFu1ll) C1{ FL:1 Fi:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1i_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1ll_BFu1ll, BFs1ll_BFu1i_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFs1ll_BFu1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1ll_BFu1s) C1{ FL:1 Fi:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1ll_BFu1s, BFs1ll_BFu1i_BFs1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFu1i_BFs1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed short v3:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1s) C1{ FL:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1s, BFs1ll_BFu1i_BFs1s)
//============================================================================


struct  BFs1ll_BFu1i_BFs1s_BFs1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1s_BFs1c) C1{ FL:1 Fi:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1s_BFs1c, BFs1ll_BFu1i_BFs1s_BFs1c)
//============================================================================


struct  BFs1ll_BFu1i_BFs1s_BFs1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1s_BFs1i) C1{ FL:1 Fi:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1s_BFs1i, BFs1ll_BFu1i_BFs1s_BFs1i)
//============================================================================


struct  BFs1ll_BFu1i_BFs1s_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1s_BFs1ll) C1{ FL:1 Fi:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1i_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1s_BFs1ll, BFs1ll_BFu1i_BFs1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFs1s_BFs1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1s_BFs1s) C1{ FL:1 Fi:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1s_BFs1s, BFs1ll_BFu1i_BFs1s_BFs1s)
//============================================================================


struct  BFs1ll_BFu1i_BFs1s_BFu1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1s_BFu1c) C1{ FL:1 Fi:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1s_BFu1c, BFs1ll_BFu1i_BFs1s_BFu1c)
//============================================================================


struct  BFs1ll_BFu1i_BFs1s_BFu1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1s_BFu1i) C1{ FL:1 Fi:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1s_BFu1i, BFs1ll_BFu1i_BFs1s_BFu1i)
//============================================================================


struct  BFs1ll_BFu1i_BFs1s_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1s_BFu1ll) C1{ FL:1 Fi:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1i_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1s_BFu1ll, BFs1ll_BFu1i_BFs1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFs1s_BFu1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFs1s_BFu1s) C1{ FL:1 Fi:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFs1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFs1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFs1s_BFu1s, BFs1ll_BFu1i_BFs1s_BFu1s)
//============================================================================


struct  BFs1ll_BFu1i_BFu1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1c) C1{ FL:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1c, BFs1ll_BFu1i_BFu1c)
//============================================================================


struct  BFs1ll_BFu1i_BFu1c_BFs1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1c_BFs1c) C1{ FL:1 Fi:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1c_BFs1c, BFs1ll_BFu1i_BFu1c_BFs1c)
//============================================================================


struct  BFs1ll_BFu1i_BFu1c_BFs1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1c_BFs1i) C1{ FL:1 Fi:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1c_BFs1i, BFs1ll_BFu1i_BFu1c_BFs1i)
//============================================================================


struct  BFs1ll_BFu1i_BFu1c_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1c_BFs1ll) C1{ FL:1 Fi:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1i_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1c_BFs1ll, BFs1ll_BFu1i_BFu1c_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFu1c_BFs1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1c_BFs1s) C1{ FL:1 Fi:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1c_BFs1s, BFs1ll_BFu1i_BFu1c_BFs1s)
//============================================================================


struct  BFs1ll_BFu1i_BFu1c_BFu1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1c_BFu1c) C1{ FL:1 Fi:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1c_BFu1c, BFs1ll_BFu1i_BFu1c_BFu1c)
//============================================================================


struct  BFs1ll_BFu1i_BFu1c_BFu1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1c_BFu1i) C1{ FL:1 Fi:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1c_BFu1i, BFs1ll_BFu1i_BFu1c_BFu1i)
//============================================================================


struct  BFs1ll_BFu1i_BFu1c_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1c_BFu1ll) C1{ FL:1 Fi:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1i_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1c_BFu1ll, BFs1ll_BFu1i_BFu1c_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFu1c_BFu1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1c_BFu1s) C1{ FL:1 Fi:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1c_BFu1s, BFs1ll_BFu1i_BFu1c_BFu1s)
//============================================================================


struct  BFs1ll_BFu1i_BFu1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1i) C1{ FL:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1i, BFs1ll_BFu1i_BFu1i)
//============================================================================


struct  BFs1ll_BFu1i_BFu1i_BFs1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1i_BFs1c) C1{ FL:1 Fi:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1i_BFs1c, BFs1ll_BFu1i_BFu1i_BFs1c)
//============================================================================


struct  BFs1ll_BFu1i_BFu1i_BFs1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1i_BFs1i) C1{ FL:1 Fi:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1i_BFs1i, BFs1ll_BFu1i_BFu1i_BFs1i)
//============================================================================


struct  BFs1ll_BFu1i_BFu1i_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1i_BFs1ll) C1{ FL:1 Fi:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1i_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1i_BFs1ll, BFs1ll_BFu1i_BFu1i_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFu1i_BFs1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1i_BFs1s) C1{ FL:1 Fi:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1i_BFs1s, BFs1ll_BFu1i_BFu1i_BFs1s)
//============================================================================


struct  BFs1ll_BFu1i_BFu1i_BFu1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1i_BFu1c) C1{ FL:1 Fi:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1i_BFu1c, BFs1ll_BFu1i_BFu1i_BFu1c)
//============================================================================


struct  BFs1ll_BFu1i_BFu1i_BFu1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1i_BFu1i) C1{ FL:1 Fi:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1i_BFu1i, BFs1ll_BFu1i_BFu1i_BFu1i)
//============================================================================


struct  BFs1ll_BFu1i_BFu1i_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1i_BFu1ll) C1{ FL:1 Fi:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1i_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1i_BFu1ll, BFs1ll_BFu1i_BFu1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFu1i_BFu1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1i_BFu1s) C1{ FL:1 Fi:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1i_BFu1s, BFs1ll_BFu1i_BFu1i_BFu1s)
//============================================================================


struct  BFs1ll_BFu1i_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1ll) C1{ FL:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1ll, BFs1ll_BFu1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFu1ll_BFs1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1ll_BFs1c) C1{ FL:1 Fi:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1ll_BFs1c, BFs1ll_BFu1i_BFu1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFu1i_BFu1ll_BFs1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1ll_BFs1i) C1{ FL:1 Fi:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1ll_BFs1i, BFs1ll_BFu1i_BFu1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFu1i_BFu1ll_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1ll_BFs1ll) C1{ FL:1 Fi:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1i_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1ll_BFs1ll, BFs1ll_BFu1i_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFu1ll_BFs1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1ll_BFs1s) C1{ FL:1 Fi:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1ll_BFs1s, BFs1ll_BFu1i_BFu1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFu1i_BFu1ll_BFu1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1ll_BFu1c) C1{ FL:1 Fi:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1ll_BFu1c, BFs1ll_BFu1i_BFu1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFu1i_BFu1ll_BFu1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1ll_BFu1i) C1{ FL:1 Fi:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1ll_BFu1i, BFs1ll_BFu1i_BFu1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFu1i_BFu1ll_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1ll_BFu1ll) C1{ FL:1 Fi:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1i_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1ll_BFu1ll, BFs1ll_BFu1i_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFu1ll_BFu1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1ll_BFu1s) C1{ FL:1 Fi:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1ll_BFu1s, BFs1ll_BFu1i_BFu1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFu1i_BFu1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1s) C1{ FL:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1s, BFs1ll_BFu1i_BFu1s)
//============================================================================


struct  BFs1ll_BFu1i_BFu1s_BFs1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1s_BFs1c) C1{ FL:1 Fi:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1s_BFs1c, BFs1ll_BFu1i_BFu1s_BFs1c)
//============================================================================


struct  BFs1ll_BFu1i_BFu1s_BFs1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1s_BFs1i) C1{ FL:1 Fi:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1s_BFs1i, BFs1ll_BFu1i_BFu1s_BFs1i)
//============================================================================


struct  BFs1ll_BFu1i_BFu1s_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1s_BFs1ll) C1{ FL:1 Fi:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1i_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1s_BFs1ll, BFs1ll_BFu1i_BFu1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFu1s_BFs1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1s_BFs1s) C1{ FL:1 Fi:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1i_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1s_BFs1s, BFs1ll_BFu1i_BFu1s_BFs1s)
//============================================================================


struct  BFs1ll_BFu1i_BFu1s_BFu1c  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1s_BFu1c) C1{ FL:1 Fi:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1i_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1s_BFu1c, BFs1ll_BFu1i_BFu1s_BFu1c)
//============================================================================


struct  BFs1ll_BFu1i_BFu1s_BFu1i  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1s_BFu1i) C1{ FL:1 Fi:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1i_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1s_BFu1i, BFs1ll_BFu1i_BFu1s_BFu1i)
//============================================================================


struct  BFs1ll_BFu1i_BFu1s_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1s_BFu1ll) C1{ FL:1 Fi:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1i_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1s_BFu1ll, BFs1ll_BFu1i_BFu1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1i_BFu1s_BFu1s  {
  signed __tsi64 v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1i_BFu1s_BFu1s) C1{ FL:1 Fi:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1i_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1i_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1i_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1i_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1i_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1i_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1i_BFu1s_BFu1s, BFs1ll_BFu1i_BFu1s_BFu1s)
//============================================================================


struct  BFs1ll_BFu1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
};
//SIG(1 BFs1ll_BFu1ll) C1{ FL:1 FL:1}



static void Test_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll, BFs1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed char v3:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1c) C1{ FL:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1c, BFs1ll_BFu1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1c_BFs1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1c_BFs1c) C1{ FL:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1c_BFs1c, BFs1ll_BFu1ll_BFs1c_BFs1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1c_BFs1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1c_BFs1i) C1{ FL:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1c_BFs1i, BFs1ll_BFu1ll_BFs1c_BFs1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1c_BFs1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1c_BFs1ll) C1{ FL:1 FL:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1c_BFs1ll, BFs1ll_BFu1ll_BFs1c_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1c_BFs1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1c_BFs1s) C1{ FL:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1c_BFs1s, BFs1ll_BFu1ll_BFs1c_BFs1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1c_BFu1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1c_BFu1c) C1{ FL:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1c_BFu1c, BFs1ll_BFu1ll_BFs1c_BFu1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1c_BFu1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1c_BFu1i) C1{ FL:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1c_BFu1i, BFs1ll_BFu1ll_BFs1c_BFu1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1c_BFu1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1c_BFu1ll) C1{ FL:1 FL:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1c_BFu1ll, BFs1ll_BFu1ll_BFs1c_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1c_BFu1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1c_BFu1s) C1{ FL:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1c_BFu1s, BFs1ll_BFu1ll_BFs1c_BFu1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed int v3:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1i) C1{ FL:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1i, BFs1ll_BFu1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1i_BFs1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1i_BFs1c) C1{ FL:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1i_BFs1c, BFs1ll_BFu1ll_BFs1i_BFs1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1i_BFs1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1i_BFs1i) C1{ FL:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1i_BFs1i, BFs1ll_BFu1ll_BFs1i_BFs1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1i_BFs1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1i_BFs1ll) C1{ FL:1 FL:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1i_BFs1ll, BFs1ll_BFu1ll_BFs1i_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1i_BFs1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1i_BFs1s) C1{ FL:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1i_BFs1s, BFs1ll_BFu1ll_BFs1i_BFs1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1i_BFu1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1i_BFu1c) C1{ FL:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1i_BFu1c, BFs1ll_BFu1ll_BFs1i_BFu1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1i_BFu1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1i_BFu1i) C1{ FL:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1i_BFu1i, BFs1ll_BFu1ll_BFs1i_BFu1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1i_BFu1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1i_BFu1ll) C1{ FL:1 FL:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1i_BFu1ll, BFs1ll_BFu1ll_BFs1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1i_BFu1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1i_BFu1s) C1{ FL:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1i_BFu1s, BFs1ll_BFu1ll_BFs1i_BFu1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1ll) C1{ FL:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1ll, BFs1ll_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1ll_BFs1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1ll_BFs1c) C1{ FL:1 FL:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1ll_BFs1c, BFs1ll_BFu1ll_BFs1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1ll_BFs1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1ll_BFs1i) C1{ FL:1 FL:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1ll_BFs1i, BFs1ll_BFu1ll_BFs1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1ll_BFs1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1ll_BFs1ll) C1{ FL:1 FL:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1ll_BFs1ll, BFs1ll_BFu1ll_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1ll_BFs1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1ll_BFs1s) C1{ FL:1 FL:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1ll_BFs1s, BFs1ll_BFu1ll_BFs1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1ll_BFu1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1ll_BFu1c) C1{ FL:1 FL:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1ll_BFu1c, BFs1ll_BFu1ll_BFs1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1ll_BFu1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1ll_BFu1i) C1{ FL:1 FL:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1ll_BFu1i, BFs1ll_BFu1ll_BFs1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1ll_BFu1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1ll_BFu1ll) C1{ FL:1 FL:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1ll_BFu1ll, BFs1ll_BFu1ll_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1ll_BFu1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1ll_BFu1s) C1{ FL:1 FL:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1ll_BFu1s, BFs1ll_BFu1ll_BFs1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed short v3:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1s) C1{ FL:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1s, BFs1ll_BFu1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1s_BFs1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1s_BFs1c) C1{ FL:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1s_BFs1c, BFs1ll_BFu1ll_BFs1s_BFs1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1s_BFs1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1s_BFs1i) C1{ FL:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1s_BFs1i, BFs1ll_BFu1ll_BFs1s_BFs1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1s_BFs1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1s_BFs1ll) C1{ FL:1 FL:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1s_BFs1ll, BFs1ll_BFu1ll_BFs1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1s_BFs1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1s_BFs1s) C1{ FL:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1s_BFs1s, BFs1ll_BFu1ll_BFs1s_BFs1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1s_BFu1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1s_BFu1c) C1{ FL:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1s_BFu1c, BFs1ll_BFu1ll_BFs1s_BFu1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1s_BFu1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1s_BFu1i) C1{ FL:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1s_BFu1i, BFs1ll_BFu1ll_BFs1s_BFu1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1s_BFu1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1s_BFu1ll) C1{ FL:1 FL:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1s_BFu1ll, BFs1ll_BFu1ll_BFs1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFs1s_BFu1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFs1s_BFu1s) C1{ FL:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFs1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFs1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFs1s_BFu1s, BFs1ll_BFu1ll_BFs1s_BFu1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1c) C1{ FL:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1c, BFs1ll_BFu1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1c_BFs1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1c_BFs1c) C1{ FL:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1c_BFs1c, BFs1ll_BFu1ll_BFu1c_BFs1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1c_BFs1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1c_BFs1i) C1{ FL:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1c_BFs1i, BFs1ll_BFu1ll_BFu1c_BFs1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1c_BFs1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1c_BFs1ll) C1{ FL:1 FL:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1c_BFs1ll, BFs1ll_BFu1ll_BFu1c_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1c_BFs1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1c_BFs1s) C1{ FL:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1c_BFs1s, BFs1ll_BFu1ll_BFu1c_BFs1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1c_BFu1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1c_BFu1c) C1{ FL:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1c_BFu1c, BFs1ll_BFu1ll_BFu1c_BFu1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1c_BFu1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1c_BFu1i) C1{ FL:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1c_BFu1i, BFs1ll_BFu1ll_BFu1c_BFu1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1c_BFu1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1c_BFu1ll) C1{ FL:1 FL:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1c_BFu1ll, BFs1ll_BFu1ll_BFu1c_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1c_BFu1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1c_BFu1s) C1{ FL:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1c_BFu1s, BFs1ll_BFu1ll_BFu1c_BFu1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1i) C1{ FL:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1i, BFs1ll_BFu1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1i_BFs1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1i_BFs1c) C1{ FL:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1i_BFs1c, BFs1ll_BFu1ll_BFu1i_BFs1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1i_BFs1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1i_BFs1i) C1{ FL:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1i_BFs1i, BFs1ll_BFu1ll_BFu1i_BFs1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1i_BFs1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1i_BFs1ll) C1{ FL:1 FL:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1i_BFs1ll, BFs1ll_BFu1ll_BFu1i_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1i_BFs1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1i_BFs1s) C1{ FL:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1i_BFs1s, BFs1ll_BFu1ll_BFu1i_BFs1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1i_BFu1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1i_BFu1c) C1{ FL:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1i_BFu1c, BFs1ll_BFu1ll_BFu1i_BFu1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1i_BFu1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1i_BFu1i) C1{ FL:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1i_BFu1i, BFs1ll_BFu1ll_BFu1i_BFu1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1i_BFu1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1i_BFu1ll) C1{ FL:1 FL:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1i_BFu1ll, BFs1ll_BFu1ll_BFu1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1i_BFu1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1i_BFu1s) C1{ FL:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1i_BFu1s, BFs1ll_BFu1ll_BFu1i_BFu1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1ll) C1{ FL:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1ll, BFs1ll_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1ll_BFs1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1ll_BFs1c) C1{ FL:1 FL:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1ll_BFs1c, BFs1ll_BFu1ll_BFu1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1ll_BFs1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1ll_BFs1i) C1{ FL:1 FL:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1ll_BFs1i, BFs1ll_BFu1ll_BFu1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1ll_BFs1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1ll_BFs1ll) C1{ FL:1 FL:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1ll_BFs1ll, BFs1ll_BFu1ll_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1ll_BFs1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1ll_BFs1s) C1{ FL:1 FL:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1ll_BFs1s, BFs1ll_BFu1ll_BFu1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1ll_BFu1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1ll_BFu1c) C1{ FL:1 FL:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1ll_BFu1c, BFs1ll_BFu1ll_BFu1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1ll_BFu1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1ll_BFu1i) C1{ FL:1 FL:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1ll_BFu1i, BFs1ll_BFu1ll_BFu1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1ll_BFu1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1ll_BFu1ll) C1{ FL:1 FL:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1ll_BFu1ll, BFs1ll_BFu1ll_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1ll_BFu1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1ll_BFu1s) C1{ FL:1 FL:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1ll_BFu1s, BFs1ll_BFu1ll_BFu1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1s) C1{ FL:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1s, BFs1ll_BFu1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1s_BFs1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1s_BFs1c) C1{ FL:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1s_BFs1c, BFs1ll_BFu1ll_BFu1s_BFs1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1s_BFs1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1s_BFs1i) C1{ FL:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1s_BFs1i, BFs1ll_BFu1ll_BFu1s_BFs1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1s_BFs1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1s_BFs1ll) C1{ FL:1 FL:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1s_BFs1ll, BFs1ll_BFu1ll_BFu1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1s_BFs1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1s_BFs1s) C1{ FL:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1ll_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1s_BFs1s, BFs1ll_BFu1ll_BFu1s_BFs1s)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1s_BFu1c  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1s_BFu1c) C1{ FL:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1ll_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1s_BFu1c, BFs1ll_BFu1ll_BFu1s_BFu1c)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1s_BFu1i  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1s_BFu1i) C1{ FL:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1ll_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1s_BFu1i, BFs1ll_BFu1ll_BFu1s_BFu1i)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1s_BFu1ll  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1s_BFu1ll) C1{ FL:1 FL:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1ll_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1s_BFu1ll, BFs1ll_BFu1ll_BFu1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1ll_BFu1s_BFu1s  {
  signed __tsi64 v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1ll_BFu1s_BFu1s) C1{ FL:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1ll_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1ll_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1ll_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1ll_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1ll_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1ll_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1ll_BFu1s_BFu1s, BFs1ll_BFu1ll_BFu1s_BFu1s)
//============================================================================


struct  BFs1ll_BFu1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
};
//SIG(1 BFs1ll_BFu1s) C1{ FL:1 Fs:1}



static void Test_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s, BFs1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFu1s_BFs1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed char v3:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1c) C1{ FL:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1c, BFs1ll_BFu1s_BFs1c)
//============================================================================


struct  BFs1ll_BFu1s_BFs1c_BFs1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1c_BFs1c) C1{ FL:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1c_BFs1c, BFs1ll_BFu1s_BFs1c_BFs1c)
//============================================================================


struct  BFs1ll_BFu1s_BFs1c_BFs1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1c_BFs1i) C1{ FL:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1c_BFs1i, BFs1ll_BFu1s_BFs1c_BFs1i)
//============================================================================


struct  BFs1ll_BFu1s_BFs1c_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1c_BFs1ll) C1{ FL:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1s_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1c_BFs1ll, BFs1ll_BFu1s_BFs1c_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFs1c_BFs1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1c_BFs1s) C1{ FL:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1c_BFs1s, BFs1ll_BFu1s_BFs1c_BFs1s)
//============================================================================


struct  BFs1ll_BFu1s_BFs1c_BFu1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1c_BFu1c) C1{ FL:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1c_BFu1c, BFs1ll_BFu1s_BFs1c_BFu1c)
//============================================================================


struct  BFs1ll_BFu1s_BFs1c_BFu1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1c_BFu1i) C1{ FL:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1c_BFu1i, BFs1ll_BFu1s_BFs1c_BFu1i)
//============================================================================


struct  BFs1ll_BFu1s_BFs1c_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1c_BFu1ll) C1{ FL:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1s_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1c_BFu1ll, BFs1ll_BFu1s_BFs1c_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFs1c_BFu1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1c_BFu1s) C1{ FL:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1c_BFu1s, BFs1ll_BFu1s_BFs1c_BFu1s)
//============================================================================


struct  BFs1ll_BFu1s_BFs1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed int v3:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1i) C1{ FL:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1i, BFs1ll_BFu1s_BFs1i)
//============================================================================


struct  BFs1ll_BFu1s_BFs1i_BFs1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1i_BFs1c) C1{ FL:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1i_BFs1c, BFs1ll_BFu1s_BFs1i_BFs1c)
//============================================================================


struct  BFs1ll_BFu1s_BFs1i_BFs1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1i_BFs1i) C1{ FL:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1i_BFs1i, BFs1ll_BFu1s_BFs1i_BFs1i)
//============================================================================


struct  BFs1ll_BFu1s_BFs1i_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1i_BFs1ll) C1{ FL:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1s_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1i_BFs1ll, BFs1ll_BFu1s_BFs1i_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFs1i_BFs1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1i_BFs1s) C1{ FL:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1i_BFs1s, BFs1ll_BFu1s_BFs1i_BFs1s)
//============================================================================


struct  BFs1ll_BFu1s_BFs1i_BFu1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1i_BFu1c) C1{ FL:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1i_BFu1c, BFs1ll_BFu1s_BFs1i_BFu1c)
//============================================================================


struct  BFs1ll_BFu1s_BFs1i_BFu1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1i_BFu1i) C1{ FL:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1i_BFu1i, BFs1ll_BFu1s_BFs1i_BFu1i)
//============================================================================


struct  BFs1ll_BFu1s_BFs1i_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1i_BFu1ll) C1{ FL:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1s_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1i_BFu1ll, BFs1ll_BFu1s_BFs1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFs1i_BFu1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1i_BFu1s) C1{ FL:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1i_BFu1s, BFs1ll_BFu1s_BFs1i_BFu1s)
//============================================================================


struct  BFs1ll_BFu1s_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1ll) C1{ FL:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1ll, BFs1ll_BFu1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFs1ll_BFs1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1ll_BFs1c) C1{ FL:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1ll_BFs1c, BFs1ll_BFu1s_BFs1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFu1s_BFs1ll_BFs1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1ll_BFs1i) C1{ FL:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1ll_BFs1i, BFs1ll_BFu1s_BFs1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFu1s_BFs1ll_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1ll_BFs1ll) C1{ FL:1 Fs:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1s_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1ll_BFs1ll, BFs1ll_BFu1s_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFs1ll_BFs1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1ll_BFs1s) C1{ FL:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1ll_BFs1s, BFs1ll_BFu1s_BFs1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFu1s_BFs1ll_BFu1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1ll_BFu1c) C1{ FL:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1ll_BFu1c, BFs1ll_BFu1s_BFs1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFu1s_BFs1ll_BFu1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1ll_BFu1i) C1{ FL:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1ll_BFu1i, BFs1ll_BFu1s_BFs1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFu1s_BFs1ll_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1ll_BFu1ll) C1{ FL:1 Fs:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1s_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1ll_BFu1ll, BFs1ll_BFu1s_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFs1ll_BFu1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1ll_BFu1s) C1{ FL:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1ll_BFu1s, BFs1ll_BFu1s_BFs1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFu1s_BFs1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed short v3:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1s) C1{ FL:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1s, BFs1ll_BFu1s_BFs1s)
//============================================================================


struct  BFs1ll_BFu1s_BFs1s_BFs1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1s_BFs1c) C1{ FL:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1s_BFs1c, BFs1ll_BFu1s_BFs1s_BFs1c)
//============================================================================


struct  BFs1ll_BFu1s_BFs1s_BFs1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1s_BFs1i) C1{ FL:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1s_BFs1i, BFs1ll_BFu1s_BFs1s_BFs1i)
//============================================================================


struct  BFs1ll_BFu1s_BFs1s_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1s_BFs1ll) C1{ FL:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1s_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1s_BFs1ll, BFs1ll_BFu1s_BFs1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFs1s_BFs1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1s_BFs1s) C1{ FL:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1s_BFs1s, BFs1ll_BFu1s_BFs1s_BFs1s)
//============================================================================


struct  BFs1ll_BFu1s_BFs1s_BFu1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1s_BFu1c) C1{ FL:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1s_BFu1c, BFs1ll_BFu1s_BFs1s_BFu1c)
//============================================================================


struct  BFs1ll_BFu1s_BFs1s_BFu1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1s_BFu1i) C1{ FL:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1s_BFu1i, BFs1ll_BFu1s_BFs1s_BFu1i)
//============================================================================


struct  BFs1ll_BFu1s_BFs1s_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1s_BFu1ll) C1{ FL:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1s_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1s_BFu1ll, BFs1ll_BFu1s_BFs1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFs1s_BFu1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFs1s_BFu1s) C1{ FL:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFs1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFs1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFs1s_BFu1s, BFs1ll_BFu1s_BFs1s_BFu1s)
//============================================================================


struct  BFs1ll_BFu1s_BFu1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1c) C1{ FL:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1c, BFs1ll_BFu1s_BFu1c)
//============================================================================


struct  BFs1ll_BFu1s_BFu1c_BFs1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1c_BFs1c) C1{ FL:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1c_BFs1c, BFs1ll_BFu1s_BFu1c_BFs1c)
//============================================================================


struct  BFs1ll_BFu1s_BFu1c_BFs1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1c_BFs1i) C1{ FL:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1c_BFs1i, BFs1ll_BFu1s_BFu1c_BFs1i)
//============================================================================


struct  BFs1ll_BFu1s_BFu1c_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1c_BFs1ll) C1{ FL:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1s_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1c_BFs1ll, BFs1ll_BFu1s_BFu1c_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFu1c_BFs1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1c_BFs1s) C1{ FL:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1c_BFs1s, BFs1ll_BFu1s_BFu1c_BFs1s)
//============================================================================


struct  BFs1ll_BFu1s_BFu1c_BFu1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1c_BFu1c) C1{ FL:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1c_BFu1c, BFs1ll_BFu1s_BFu1c_BFu1c)
//============================================================================


struct  BFs1ll_BFu1s_BFu1c_BFu1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1c_BFu1i) C1{ FL:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1c_BFu1i, BFs1ll_BFu1s_BFu1c_BFu1i)
//============================================================================


struct  BFs1ll_BFu1s_BFu1c_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1c_BFu1ll) C1{ FL:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1ll_BFu1s_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1c_BFu1ll, BFs1ll_BFu1s_BFu1c_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFu1c_BFu1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1c_BFu1s) C1{ FL:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1c_BFu1s, BFs1ll_BFu1s_BFu1c_BFu1s)
//============================================================================


struct  BFs1ll_BFu1s_BFu1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1i) C1{ FL:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1i, BFs1ll_BFu1s_BFu1i)
//============================================================================


struct  BFs1ll_BFu1s_BFu1i_BFs1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1i_BFs1c) C1{ FL:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1i_BFs1c, BFs1ll_BFu1s_BFu1i_BFs1c)
//============================================================================


struct  BFs1ll_BFu1s_BFu1i_BFs1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1i_BFs1i) C1{ FL:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1i_BFs1i, BFs1ll_BFu1s_BFu1i_BFs1i)
//============================================================================


struct  BFs1ll_BFu1s_BFu1i_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1i_BFs1ll) C1{ FL:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1s_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1i_BFs1ll, BFs1ll_BFu1s_BFu1i_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFu1i_BFs1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1i_BFs1s) C1{ FL:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1i_BFs1s, BFs1ll_BFu1s_BFu1i_BFs1s)
//============================================================================


struct  BFs1ll_BFu1s_BFu1i_BFu1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1i_BFu1c) C1{ FL:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1i_BFu1c, BFs1ll_BFu1s_BFu1i_BFu1c)
//============================================================================


struct  BFs1ll_BFu1s_BFu1i_BFu1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1i_BFu1i) C1{ FL:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1i_BFu1i, BFs1ll_BFu1s_BFu1i_BFu1i)
//============================================================================


struct  BFs1ll_BFu1s_BFu1i_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1i_BFu1ll) C1{ FL:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1ll_BFu1s_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1i_BFu1ll, BFs1ll_BFu1s_BFu1i_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFu1i_BFu1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1i_BFu1s) C1{ FL:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1i_BFu1s, BFs1ll_BFu1s_BFu1i_BFu1s)
//============================================================================


struct  BFs1ll_BFu1s_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1ll) C1{ FL:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1ll, BFs1ll_BFu1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFu1ll_BFs1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1ll_BFs1c) C1{ FL:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1ll_BFs1c, BFs1ll_BFu1s_BFu1ll_BFs1c)
//============================================================================


struct  BFs1ll_BFu1s_BFu1ll_BFs1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1ll_BFs1i) C1{ FL:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1ll_BFs1i, BFs1ll_BFu1s_BFu1ll_BFs1i)
//============================================================================


struct  BFs1ll_BFu1s_BFu1ll_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1ll_BFs1ll) C1{ FL:1 Fs:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1s_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1ll_BFs1ll, BFs1ll_BFu1s_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFu1ll_BFs1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1ll_BFs1s) C1{ FL:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1ll_BFs1s, BFs1ll_BFu1s_BFu1ll_BFs1s)
//============================================================================


struct  BFs1ll_BFu1s_BFu1ll_BFu1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1ll_BFu1c) C1{ FL:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1ll_BFu1c, BFs1ll_BFu1s_BFu1ll_BFu1c)
//============================================================================


struct  BFs1ll_BFu1s_BFu1ll_BFu1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1ll_BFu1i) C1{ FL:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1ll_BFu1i, BFs1ll_BFu1s_BFu1ll_BFu1i)
//============================================================================


struct  BFs1ll_BFu1s_BFu1ll_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1ll_BFu1ll) C1{ FL:1 Fs:1 FL:1 FL:1}



static void Test_BFs1ll_BFu1s_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1ll_BFu1ll, BFs1ll_BFu1s_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFu1ll_BFu1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1ll_BFu1s) C1{ FL:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1ll_BFu1s, BFs1ll_BFu1s_BFu1ll_BFu1s)
//============================================================================


struct  BFs1ll_BFu1s_BFu1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1s) C1{ FL:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1s, BFs1ll_BFu1s_BFu1s)
//============================================================================


struct  BFs1ll_BFu1s_BFu1s_BFs1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1s_BFs1c) C1{ FL:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1s_BFs1c, BFs1ll_BFu1s_BFu1s_BFs1c)
//============================================================================


struct  BFs1ll_BFu1s_BFu1s_BFs1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1s_BFs1i) C1{ FL:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1s_BFs1i, BFs1ll_BFu1s_BFu1s_BFs1i)
//============================================================================


struct  BFs1ll_BFu1s_BFu1s_BFs1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1s_BFs1ll) C1{ FL:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1s_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1s_BFs1ll, BFs1ll_BFu1s_BFu1s_BFs1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFu1s_BFs1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1s_BFs1s) C1{ FL:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFu1s_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1s_BFs1s, BFs1ll_BFu1s_BFu1s_BFs1s)
//============================================================================


struct  BFs1ll_BFu1s_BFu1s_BFu1c  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1s_BFu1c) C1{ FL:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1ll_BFu1s_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1s_BFu1c, BFs1ll_BFu1s_BFu1s_BFu1c)
//============================================================================


struct  BFs1ll_BFu1s_BFu1s_BFu1i  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1s_BFu1i) C1{ FL:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1ll_BFu1s_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1s_BFu1i, BFs1ll_BFu1s_BFu1s_BFu1i)
//============================================================================


struct  BFs1ll_BFu1s_BFu1s_BFu1ll  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1s_BFu1ll) C1{ FL:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1ll_BFu1s_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1s_BFu1ll, BFs1ll_BFu1s_BFu1s_BFu1ll)
//============================================================================


struct  BFs1ll_BFu1s_BFu1s_BFu1s  {
  signed __tsi64 v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1ll_BFu1s_BFu1s_BFu1s) C1{ FL:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1ll_BFu1s_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFu1s_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1ll_BFu1s_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1ll_BFu1s_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1ll_BFu1s_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1ll_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1ll_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFu1s_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFu1s_BFu1s_BFu1s, BFs1ll_BFu1s_BFu1s_BFu1s)
//============================================================================


struct  BFs1s_BFs1c  {
  signed short v1:1;
  signed char v2:1;
};
//SIG(1 BFs1s_BFs1c) C1{ Fs:1 Fc:1}



static void Test_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c, BFs1s_BFs1c)
//============================================================================


struct  BFs1s_BFs1c_BFs1c  {
  signed short v1:1;
  signed char v2:1;
  signed char v3:1;
};
//SIG(1 BFs1s_BFs1c_BFs1c) C1{ Fs:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1c, BFs1s_BFs1c_BFs1c)
//============================================================================


struct  BFs1s_BFs1c_BFs1c_BFs1c  {
  signed short v1:1;
  signed char v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1c_BFs1c) C1{ Fs:1 Fc:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1c_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1c_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFs1c_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1c_BFs1c, BFs1s_BFs1c_BFs1c_BFs1c)
//============================================================================


struct  BFs1s_BFs1c_BFs1c_BFs1i  {
  signed short v1:1;
  signed char v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1c_BFs1i) C1{ Fs:1 Fc:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1c_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1c_BFs1i, BFs1s_BFs1c_BFs1c_BFs1i)
//============================================================================


struct  BFs1s_BFs1c_BFs1c_BFs1ll  {
  signed short v1:1;
  signed char v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1c_BFs1ll) C1{ Fs:1 Fc:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1c_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1c_BFs1ll, BFs1s_BFs1c_BFs1c_BFs1ll)
//============================================================================


struct  BFs1s_BFs1c_BFs1c_BFs1s  {
  signed short v1:1;
  signed char v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1c_BFs1s) C1{ Fs:1 Fc:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1c_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFs1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1c_BFs1s, BFs1s_BFs1c_BFs1c_BFs1s)
//============================================================================


struct  BFs1s_BFs1c_BFs1c_BFu1c  {
  signed short v1:1;
  signed char v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1c_BFu1c) C1{ Fs:1 Fc:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1c_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFs1c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1c_BFu1c, BFs1s_BFs1c_BFs1c_BFu1c)
//============================================================================


struct  BFs1s_BFs1c_BFs1c_BFu1i  {
  signed short v1:1;
  signed char v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1c_BFu1i) C1{ Fs:1 Fc:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1c_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1c_BFu1i, BFs1s_BFs1c_BFs1c_BFu1i)
//============================================================================


struct  BFs1s_BFs1c_BFs1c_BFu1ll  {
  signed short v1:1;
  signed char v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1c_BFu1ll) C1{ Fs:1 Fc:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1c_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1c_BFu1ll, BFs1s_BFs1c_BFs1c_BFu1ll)
//============================================================================


struct  BFs1s_BFs1c_BFs1c_BFu1s  {
  signed short v1:1;
  signed char v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1c_BFu1s) C1{ Fs:1 Fc:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1c_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFs1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1c_BFu1s, BFs1s_BFs1c_BFs1c_BFu1s)
//============================================================================


struct  BFs1s_BFs1c_BFs1i  {
  signed short v1:1;
  signed char v2:1;
  signed int v3:1;
};
//SIG(1 BFs1s_BFs1c_BFs1i) C1{ Fs:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1i, BFs1s_BFs1c_BFs1i)
//============================================================================


struct  BFs1s_BFs1c_BFs1i_BFs1c  {
  signed short v1:1;
  signed char v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1i_BFs1c) C1{ Fs:1 Fc:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1c_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1i_BFs1c, BFs1s_BFs1c_BFs1i_BFs1c)
//============================================================================


struct  BFs1s_BFs1c_BFs1i_BFs1i  {
  signed short v1:1;
  signed char v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1i_BFs1i) C1{ Fs:1 Fc:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1c_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1i_BFs1i, BFs1s_BFs1c_BFs1i_BFs1i)
//============================================================================


struct  BFs1s_BFs1c_BFs1i_BFs1ll  {
  signed short v1:1;
  signed char v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1i_BFs1ll) C1{ Fs:1 Fc:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1c_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1i_BFs1ll, BFs1s_BFs1c_BFs1i_BFs1ll)
//============================================================================


struct  BFs1s_BFs1c_BFs1i_BFs1s  {
  signed short v1:1;
  signed char v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1i_BFs1s) C1{ Fs:1 Fc:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1c_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1i_BFs1s, BFs1s_BFs1c_BFs1i_BFs1s)
//============================================================================


struct  BFs1s_BFs1c_BFs1i_BFu1c  {
  signed short v1:1;
  signed char v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1i_BFu1c) C1{ Fs:1 Fc:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1c_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1i_BFu1c, BFs1s_BFs1c_BFs1i_BFu1c)
//============================================================================


struct  BFs1s_BFs1c_BFs1i_BFu1i  {
  signed short v1:1;
  signed char v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1i_BFu1i) C1{ Fs:1 Fc:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1c_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1i_BFu1i, BFs1s_BFs1c_BFs1i_BFu1i)
//============================================================================


struct  BFs1s_BFs1c_BFs1i_BFu1ll  {
  signed short v1:1;
  signed char v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1i_BFu1ll) C1{ Fs:1 Fc:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1c_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1i_BFu1ll, BFs1s_BFs1c_BFs1i_BFu1ll)
//============================================================================


struct  BFs1s_BFs1c_BFs1i_BFu1s  {
  signed short v1:1;
  signed char v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1i_BFu1s) C1{ Fs:1 Fc:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1c_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1i_BFu1s, BFs1s_BFs1c_BFs1i_BFu1s)
//============================================================================


struct  BFs1s_BFs1c_BFs1ll  {
  signed short v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFs1s_BFs1c_BFs1ll) C1{ Fs:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1ll, BFs1s_BFs1c_BFs1ll)
//============================================================================


struct  BFs1s_BFs1c_BFs1ll_BFs1c  {
  signed short v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1ll_BFs1c) C1{ Fs:1 Fc:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1c_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1ll_BFs1c, BFs1s_BFs1c_BFs1ll_BFs1c)
//============================================================================


struct  BFs1s_BFs1c_BFs1ll_BFs1i  {
  signed short v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1ll_BFs1i) C1{ Fs:1 Fc:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1c_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1ll_BFs1i, BFs1s_BFs1c_BFs1ll_BFs1i)
//============================================================================


struct  BFs1s_BFs1c_BFs1ll_BFs1ll  {
  signed short v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1ll_BFs1ll) C1{ Fs:1 Fc:1 FL:1 FL:1}



static void Test_BFs1s_BFs1c_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1ll_BFs1ll, BFs1s_BFs1c_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFs1c_BFs1ll_BFs1s  {
  signed short v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1ll_BFs1s) C1{ Fs:1 Fc:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1c_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1ll_BFs1s, BFs1s_BFs1c_BFs1ll_BFs1s)
//============================================================================


struct  BFs1s_BFs1c_BFs1ll_BFu1c  {
  signed short v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1ll_BFu1c) C1{ Fs:1 Fc:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1c_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1ll_BFu1c, BFs1s_BFs1c_BFs1ll_BFu1c)
//============================================================================


struct  BFs1s_BFs1c_BFs1ll_BFu1i  {
  signed short v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1ll_BFu1i) C1{ Fs:1 Fc:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1c_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1ll_BFu1i, BFs1s_BFs1c_BFs1ll_BFu1i)
//============================================================================


struct  BFs1s_BFs1c_BFs1ll_BFu1ll  {
  signed short v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1ll_BFu1ll) C1{ Fs:1 Fc:1 FL:1 FL:1}



static void Test_BFs1s_BFs1c_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1ll_BFu1ll, BFs1s_BFs1c_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFs1c_BFs1ll_BFu1s  {
  signed short v1:1;
  signed char v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1ll_BFu1s) C1{ Fs:1 Fc:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1c_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1ll_BFu1s, BFs1s_BFs1c_BFs1ll_BFu1s)
//============================================================================


struct  BFs1s_BFs1c_BFs1s  {
  signed short v1:1;
  signed char v2:1;
  signed short v3:1;
};
//SIG(1 BFs1s_BFs1c_BFs1s) C1{ Fs:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1s, BFs1s_BFs1c_BFs1s)
//============================================================================


struct  BFs1s_BFs1c_BFs1s_BFs1c  {
  signed short v1:1;
  signed char v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1s_BFs1c) C1{ Fs:1 Fc:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1c_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFs1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1s_BFs1c, BFs1s_BFs1c_BFs1s_BFs1c)
//============================================================================


struct  BFs1s_BFs1c_BFs1s_BFs1i  {
  signed short v1:1;
  signed char v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1s_BFs1i) C1{ Fs:1 Fc:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1c_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1s_BFs1i, BFs1s_BFs1c_BFs1s_BFs1i)
//============================================================================


struct  BFs1s_BFs1c_BFs1s_BFs1ll  {
  signed short v1:1;
  signed char v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1s_BFs1ll) C1{ Fs:1 Fc:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1c_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1s_BFs1ll, BFs1s_BFs1c_BFs1s_BFs1ll)
//============================================================================


struct  BFs1s_BFs1c_BFs1s_BFs1s  {
  signed short v1:1;
  signed char v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1s_BFs1s) C1{ Fs:1 Fc:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1c_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFs1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1s_BFs1s, BFs1s_BFs1c_BFs1s_BFs1s)
//============================================================================


struct  BFs1s_BFs1c_BFs1s_BFu1c  {
  signed short v1:1;
  signed char v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1s_BFu1c) C1{ Fs:1 Fc:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1c_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFs1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1s_BFu1c, BFs1s_BFs1c_BFs1s_BFu1c)
//============================================================================


struct  BFs1s_BFs1c_BFs1s_BFu1i  {
  signed short v1:1;
  signed char v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1s_BFu1i) C1{ Fs:1 Fc:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1c_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1s_BFu1i, BFs1s_BFs1c_BFs1s_BFu1i)
//============================================================================


struct  BFs1s_BFs1c_BFs1s_BFu1ll  {
  signed short v1:1;
  signed char v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1s_BFu1ll) C1{ Fs:1 Fc:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1c_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1s_BFu1ll, BFs1s_BFs1c_BFs1s_BFu1ll)
//============================================================================


struct  BFs1s_BFs1c_BFs1s_BFu1s  {
  signed short v1:1;
  signed char v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFs1s_BFu1s) C1{ Fs:1 Fc:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1c_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFs1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFs1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFs1s_BFu1s, BFs1s_BFs1c_BFs1s_BFu1s)
//============================================================================


struct  BFs1s_BFs1c_BFu1c  {
  signed short v1:1;
  signed char v2:1;
  unsigned char v3:1;
};
//SIG(1 BFs1s_BFs1c_BFu1c) C1{ Fs:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1c, BFs1s_BFs1c_BFu1c)
//============================================================================


struct  BFs1s_BFs1c_BFu1c_BFs1c  {
  signed short v1:1;
  signed char v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1c_BFs1c) C1{ Fs:1 Fc:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1c_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1c_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFu1c_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1c_BFs1c, BFs1s_BFs1c_BFu1c_BFs1c)
//============================================================================


struct  BFs1s_BFs1c_BFu1c_BFs1i  {
  signed short v1:1;
  signed char v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1c_BFs1i) C1{ Fs:1 Fc:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1c_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1c_BFs1i, BFs1s_BFs1c_BFu1c_BFs1i)
//============================================================================


struct  BFs1s_BFs1c_BFu1c_BFs1ll  {
  signed short v1:1;
  signed char v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1c_BFs1ll) C1{ Fs:1 Fc:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1c_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1c_BFs1ll, BFs1s_BFs1c_BFu1c_BFs1ll)
//============================================================================


struct  BFs1s_BFs1c_BFu1c_BFs1s  {
  signed short v1:1;
  signed char v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1c_BFs1s) C1{ Fs:1 Fc:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1c_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFu1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1c_BFs1s, BFs1s_BFs1c_BFu1c_BFs1s)
//============================================================================


struct  BFs1s_BFs1c_BFu1c_BFu1c  {
  signed short v1:1;
  signed char v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1c_BFu1c) C1{ Fs:1 Fc:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1c_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFu1c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1c_BFu1c, BFs1s_BFs1c_BFu1c_BFu1c)
//============================================================================


struct  BFs1s_BFs1c_BFu1c_BFu1i  {
  signed short v1:1;
  signed char v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1c_BFu1i) C1{ Fs:1 Fc:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1c_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1c_BFu1i, BFs1s_BFs1c_BFu1c_BFu1i)
//============================================================================


struct  BFs1s_BFs1c_BFu1c_BFu1ll  {
  signed short v1:1;
  signed char v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1c_BFu1ll) C1{ Fs:1 Fc:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1c_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1c_BFu1ll, BFs1s_BFs1c_BFu1c_BFu1ll)
//============================================================================


struct  BFs1s_BFs1c_BFu1c_BFu1s  {
  signed short v1:1;
  signed char v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1c_BFu1s) C1{ Fs:1 Fc:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1c_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFu1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1c_BFu1s, BFs1s_BFs1c_BFu1c_BFu1s)
//============================================================================


struct  BFs1s_BFs1c_BFu1i  {
  signed short v1:1;
  signed char v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1s_BFs1c_BFu1i) C1{ Fs:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1i, BFs1s_BFs1c_BFu1i)
//============================================================================


struct  BFs1s_BFs1c_BFu1i_BFs1c  {
  signed short v1:1;
  signed char v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1i_BFs1c) C1{ Fs:1 Fc:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1c_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1i_BFs1c, BFs1s_BFs1c_BFu1i_BFs1c)
//============================================================================


struct  BFs1s_BFs1c_BFu1i_BFs1i  {
  signed short v1:1;
  signed char v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1i_BFs1i) C1{ Fs:1 Fc:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1c_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1i_BFs1i, BFs1s_BFs1c_BFu1i_BFs1i)
//============================================================================


struct  BFs1s_BFs1c_BFu1i_BFs1ll  {
  signed short v1:1;
  signed char v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1i_BFs1ll) C1{ Fs:1 Fc:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1c_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1i_BFs1ll, BFs1s_BFs1c_BFu1i_BFs1ll)
//============================================================================


struct  BFs1s_BFs1c_BFu1i_BFs1s  {
  signed short v1:1;
  signed char v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1i_BFs1s) C1{ Fs:1 Fc:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1c_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1i_BFs1s, BFs1s_BFs1c_BFu1i_BFs1s)
//============================================================================


struct  BFs1s_BFs1c_BFu1i_BFu1c  {
  signed short v1:1;
  signed char v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1i_BFu1c) C1{ Fs:1 Fc:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1c_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1i_BFu1c, BFs1s_BFs1c_BFu1i_BFu1c)
//============================================================================


struct  BFs1s_BFs1c_BFu1i_BFu1i  {
  signed short v1:1;
  signed char v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1i_BFu1i) C1{ Fs:1 Fc:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1c_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1i_BFu1i, BFs1s_BFs1c_BFu1i_BFu1i)
//============================================================================


struct  BFs1s_BFs1c_BFu1i_BFu1ll  {
  signed short v1:1;
  signed char v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1i_BFu1ll) C1{ Fs:1 Fc:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1c_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1i_BFu1ll, BFs1s_BFs1c_BFu1i_BFu1ll)
//============================================================================


struct  BFs1s_BFs1c_BFu1i_BFu1s  {
  signed short v1:1;
  signed char v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1i_BFu1s) C1{ Fs:1 Fc:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1c_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1i_BFu1s, BFs1s_BFs1c_BFu1i_BFu1s)
//============================================================================


struct  BFs1s_BFs1c_BFu1ll  {
  signed short v1:1;
  signed char v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1s_BFs1c_BFu1ll) C1{ Fs:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1ll, BFs1s_BFs1c_BFu1ll)
//============================================================================


struct  BFs1s_BFs1c_BFu1ll_BFs1c  {
  signed short v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1ll_BFs1c) C1{ Fs:1 Fc:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1c_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1ll_BFs1c, BFs1s_BFs1c_BFu1ll_BFs1c)
//============================================================================


struct  BFs1s_BFs1c_BFu1ll_BFs1i  {
  signed short v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1ll_BFs1i) C1{ Fs:1 Fc:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1c_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1ll_BFs1i, BFs1s_BFs1c_BFu1ll_BFs1i)
//============================================================================


struct  BFs1s_BFs1c_BFu1ll_BFs1ll  {
  signed short v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1ll_BFs1ll) C1{ Fs:1 Fc:1 FL:1 FL:1}



static void Test_BFs1s_BFs1c_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1ll_BFs1ll, BFs1s_BFs1c_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFs1c_BFu1ll_BFs1s  {
  signed short v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1ll_BFs1s) C1{ Fs:1 Fc:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1c_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1ll_BFs1s, BFs1s_BFs1c_BFu1ll_BFs1s)
//============================================================================


struct  BFs1s_BFs1c_BFu1ll_BFu1c  {
  signed short v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1ll_BFu1c) C1{ Fs:1 Fc:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1c_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1ll_BFu1c, BFs1s_BFs1c_BFu1ll_BFu1c)
//============================================================================


struct  BFs1s_BFs1c_BFu1ll_BFu1i  {
  signed short v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1ll_BFu1i) C1{ Fs:1 Fc:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1c_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1ll_BFu1i, BFs1s_BFs1c_BFu1ll_BFu1i)
//============================================================================


struct  BFs1s_BFs1c_BFu1ll_BFu1ll  {
  signed short v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1ll_BFu1ll) C1{ Fs:1 Fc:1 FL:1 FL:1}



static void Test_BFs1s_BFs1c_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1ll_BFu1ll, BFs1s_BFs1c_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFs1c_BFu1ll_BFu1s  {
  signed short v1:1;
  signed char v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1ll_BFu1s) C1{ Fs:1 Fc:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1c_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1ll_BFu1s, BFs1s_BFs1c_BFu1ll_BFu1s)
//============================================================================


struct  BFs1s_BFs1c_BFu1s  {
  signed short v1:1;
  signed char v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1s_BFs1c_BFu1s) C1{ Fs:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1s, BFs1s_BFs1c_BFu1s)
//============================================================================


struct  BFs1s_BFs1c_BFu1s_BFs1c  {
  signed short v1:1;
  signed char v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1s_BFs1c) C1{ Fs:1 Fc:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1c_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFu1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1s_BFs1c, BFs1s_BFs1c_BFu1s_BFs1c)
//============================================================================


struct  BFs1s_BFs1c_BFu1s_BFs1i  {
  signed short v1:1;
  signed char v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1s_BFs1i) C1{ Fs:1 Fc:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1c_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1s_BFs1i, BFs1s_BFs1c_BFu1s_BFs1i)
//============================================================================


struct  BFs1s_BFs1c_BFu1s_BFs1ll  {
  signed short v1:1;
  signed char v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1s_BFs1ll) C1{ Fs:1 Fc:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1c_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1s_BFs1ll, BFs1s_BFs1c_BFu1s_BFs1ll)
//============================================================================


struct  BFs1s_BFs1c_BFu1s_BFs1s  {
  signed short v1:1;
  signed char v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1s_BFs1s) C1{ Fs:1 Fc:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1c_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFu1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1c_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1s_BFs1s, BFs1s_BFs1c_BFu1s_BFs1s)
//============================================================================


struct  BFs1s_BFs1c_BFu1s_BFu1c  {
  signed short v1:1;
  signed char v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1s_BFu1c) C1{ Fs:1 Fc:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1c_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFu1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1s_BFu1c, BFs1s_BFs1c_BFu1s_BFu1c)
//============================================================================


struct  BFs1s_BFs1c_BFu1s_BFu1i  {
  signed short v1:1;
  signed char v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1s_BFu1i) C1{ Fs:1 Fc:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1c_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1c_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1c_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1s_BFu1i, BFs1s_BFs1c_BFu1s_BFu1i)
//============================================================================


struct  BFs1s_BFs1c_BFu1s_BFu1ll  {
  signed short v1:1;
  signed char v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1s_BFu1ll) C1{ Fs:1 Fc:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1c_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1c_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1c_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1s_BFu1ll, BFs1s_BFs1c_BFu1s_BFu1ll)
//============================================================================


struct  BFs1s_BFs1c_BFu1s_BFu1s  {
  signed short v1:1;
  signed char v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1c_BFu1s_BFu1s) C1{ Fs:1 Fc:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1c_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1c_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1c_BFu1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1c_BFu1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1c_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1c_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1c_BFu1s_BFu1s, BFs1s_BFs1c_BFu1s_BFu1s)
//============================================================================


struct  BFs1s_BFs1i  {
  signed short v1:1;
  signed int v2:1;
};
//SIG(1 BFs1s_BFs1i) C1{ Fs:1 Fi:1}



static void Test_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i, BFs1s_BFs1i)
//============================================================================


struct  BFs1s_BFs1i_BFs1c  {
  signed short v1:1;
  signed int v2:1;
  signed char v3:1;
};
//SIG(1 BFs1s_BFs1i_BFs1c) C1{ Fs:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1c, BFs1s_BFs1i_BFs1c)
//============================================================================


struct  BFs1s_BFs1i_BFs1c_BFs1c  {
  signed short v1:1;
  signed int v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1c_BFs1c) C1{ Fs:1 Fi:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1i_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1c_BFs1c, BFs1s_BFs1i_BFs1c_BFs1c)
//============================================================================


struct  BFs1s_BFs1i_BFs1c_BFs1i  {
  signed short v1:1;
  signed int v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1c_BFs1i) C1{ Fs:1 Fi:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1i_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1c_BFs1i, BFs1s_BFs1i_BFs1c_BFs1i)
//============================================================================


struct  BFs1s_BFs1i_BFs1c_BFs1ll  {
  signed short v1:1;
  signed int v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1c_BFs1ll) C1{ Fs:1 Fi:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1i_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1c_BFs1ll, BFs1s_BFs1i_BFs1c_BFs1ll)
//============================================================================


struct  BFs1s_BFs1i_BFs1c_BFs1s  {
  signed short v1:1;
  signed int v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1c_BFs1s) C1{ Fs:1 Fi:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1i_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1c_BFs1s, BFs1s_BFs1i_BFs1c_BFs1s)
//============================================================================


struct  BFs1s_BFs1i_BFs1c_BFu1c  {
  signed short v1:1;
  signed int v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1c_BFu1c) C1{ Fs:1 Fi:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1i_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1c_BFu1c, BFs1s_BFs1i_BFs1c_BFu1c)
//============================================================================


struct  BFs1s_BFs1i_BFs1c_BFu1i  {
  signed short v1:1;
  signed int v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1c_BFu1i) C1{ Fs:1 Fi:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1i_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1c_BFu1i, BFs1s_BFs1i_BFs1c_BFu1i)
//============================================================================


struct  BFs1s_BFs1i_BFs1c_BFu1ll  {
  signed short v1:1;
  signed int v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1c_BFu1ll) C1{ Fs:1 Fi:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1i_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1c_BFu1ll, BFs1s_BFs1i_BFs1c_BFu1ll)
//============================================================================


struct  BFs1s_BFs1i_BFs1c_BFu1s  {
  signed short v1:1;
  signed int v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1c_BFu1s) C1{ Fs:1 Fi:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1i_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1c_BFu1s, BFs1s_BFs1i_BFs1c_BFu1s)
//============================================================================


struct  BFs1s_BFs1i_BFs1i  {
  signed short v1:1;
  signed int v2:1;
  signed int v3:1;
};
//SIG(1 BFs1s_BFs1i_BFs1i) C1{ Fs:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1i, BFs1s_BFs1i_BFs1i)
//============================================================================


struct  BFs1s_BFs1i_BFs1i_BFs1c  {
  signed short v1:1;
  signed int v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1i_BFs1c) C1{ Fs:1 Fi:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1i_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1i_BFs1c, BFs1s_BFs1i_BFs1i_BFs1c)
//============================================================================


struct  BFs1s_BFs1i_BFs1i_BFs1i  {
  signed short v1:1;
  signed int v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1i_BFs1i) C1{ Fs:1 Fi:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1i_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1i_BFs1i, BFs1s_BFs1i_BFs1i_BFs1i)
//============================================================================


struct  BFs1s_BFs1i_BFs1i_BFs1ll  {
  signed short v1:1;
  signed int v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1i_BFs1ll) C1{ Fs:1 Fi:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1i_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1i_BFs1ll, BFs1s_BFs1i_BFs1i_BFs1ll)
//============================================================================


struct  BFs1s_BFs1i_BFs1i_BFs1s  {
  signed short v1:1;
  signed int v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1i_BFs1s) C1{ Fs:1 Fi:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1i_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1i_BFs1s, BFs1s_BFs1i_BFs1i_BFs1s)
//============================================================================


struct  BFs1s_BFs1i_BFs1i_BFu1c  {
  signed short v1:1;
  signed int v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1i_BFu1c) C1{ Fs:1 Fi:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1i_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1i_BFu1c, BFs1s_BFs1i_BFs1i_BFu1c)
//============================================================================


struct  BFs1s_BFs1i_BFs1i_BFu1i  {
  signed short v1:1;
  signed int v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1i_BFu1i) C1{ Fs:1 Fi:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1i_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1i_BFu1i, BFs1s_BFs1i_BFs1i_BFu1i)
//============================================================================


struct  BFs1s_BFs1i_BFs1i_BFu1ll  {
  signed short v1:1;
  signed int v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1i_BFu1ll) C1{ Fs:1 Fi:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1i_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1i_BFu1ll, BFs1s_BFs1i_BFs1i_BFu1ll)
//============================================================================


struct  BFs1s_BFs1i_BFs1i_BFu1s  {
  signed short v1:1;
  signed int v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1i_BFu1s) C1{ Fs:1 Fi:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1i_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1i_BFu1s, BFs1s_BFs1i_BFs1i_BFu1s)
//============================================================================


struct  BFs1s_BFs1i_BFs1ll  {
  signed short v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFs1s_BFs1i_BFs1ll) C1{ Fs:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1ll, BFs1s_BFs1i_BFs1ll)
//============================================================================


struct  BFs1s_BFs1i_BFs1ll_BFs1c  {
  signed short v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1ll_BFs1c) C1{ Fs:1 Fi:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1i_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1ll_BFs1c, BFs1s_BFs1i_BFs1ll_BFs1c)
//============================================================================


struct  BFs1s_BFs1i_BFs1ll_BFs1i  {
  signed short v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1ll_BFs1i) C1{ Fs:1 Fi:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1i_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1ll_BFs1i, BFs1s_BFs1i_BFs1ll_BFs1i)
//============================================================================


struct  BFs1s_BFs1i_BFs1ll_BFs1ll  {
  signed short v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1ll_BFs1ll) C1{ Fs:1 Fi:1 FL:1 FL:1}



static void Test_BFs1s_BFs1i_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1ll_BFs1ll, BFs1s_BFs1i_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFs1i_BFs1ll_BFs1s  {
  signed short v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1ll_BFs1s) C1{ Fs:1 Fi:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1i_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1ll_BFs1s, BFs1s_BFs1i_BFs1ll_BFs1s)
//============================================================================


struct  BFs1s_BFs1i_BFs1ll_BFu1c  {
  signed short v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1ll_BFu1c) C1{ Fs:1 Fi:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1i_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1ll_BFu1c, BFs1s_BFs1i_BFs1ll_BFu1c)
//============================================================================


struct  BFs1s_BFs1i_BFs1ll_BFu1i  {
  signed short v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1ll_BFu1i) C1{ Fs:1 Fi:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1i_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1ll_BFu1i, BFs1s_BFs1i_BFs1ll_BFu1i)
//============================================================================


struct  BFs1s_BFs1i_BFs1ll_BFu1ll  {
  signed short v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1ll_BFu1ll) C1{ Fs:1 Fi:1 FL:1 FL:1}



static void Test_BFs1s_BFs1i_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1ll_BFu1ll, BFs1s_BFs1i_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFs1i_BFs1ll_BFu1s  {
  signed short v1:1;
  signed int v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1ll_BFu1s) C1{ Fs:1 Fi:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1i_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1ll_BFu1s, BFs1s_BFs1i_BFs1ll_BFu1s)
//============================================================================


struct  BFs1s_BFs1i_BFs1s  {
  signed short v1:1;
  signed int v2:1;
  signed short v3:1;
};
//SIG(1 BFs1s_BFs1i_BFs1s) C1{ Fs:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1s, BFs1s_BFs1i_BFs1s)
//============================================================================


struct  BFs1s_BFs1i_BFs1s_BFs1c  {
  signed short v1:1;
  signed int v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1s_BFs1c) C1{ Fs:1 Fi:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1i_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1s_BFs1c, BFs1s_BFs1i_BFs1s_BFs1c)
//============================================================================


struct  BFs1s_BFs1i_BFs1s_BFs1i  {
  signed short v1:1;
  signed int v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1s_BFs1i) C1{ Fs:1 Fi:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1i_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1s_BFs1i, BFs1s_BFs1i_BFs1s_BFs1i)
//============================================================================


struct  BFs1s_BFs1i_BFs1s_BFs1ll  {
  signed short v1:1;
  signed int v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1s_BFs1ll) C1{ Fs:1 Fi:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1i_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1s_BFs1ll, BFs1s_BFs1i_BFs1s_BFs1ll)
//============================================================================


struct  BFs1s_BFs1i_BFs1s_BFs1s  {
  signed short v1:1;
  signed int v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1s_BFs1s) C1{ Fs:1 Fi:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1i_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1s_BFs1s, BFs1s_BFs1i_BFs1s_BFs1s)
//============================================================================


struct  BFs1s_BFs1i_BFs1s_BFu1c  {
  signed short v1:1;
  signed int v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1s_BFu1c) C1{ Fs:1 Fi:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1i_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1s_BFu1c, BFs1s_BFs1i_BFs1s_BFu1c)
//============================================================================


struct  BFs1s_BFs1i_BFs1s_BFu1i  {
  signed short v1:1;
  signed int v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1s_BFu1i) C1{ Fs:1 Fi:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1i_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1s_BFu1i, BFs1s_BFs1i_BFs1s_BFu1i)
//============================================================================


struct  BFs1s_BFs1i_BFs1s_BFu1ll  {
  signed short v1:1;
  signed int v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1s_BFu1ll) C1{ Fs:1 Fi:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1i_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1s_BFu1ll, BFs1s_BFs1i_BFs1s_BFu1ll)
//============================================================================


struct  BFs1s_BFs1i_BFs1s_BFu1s  {
  signed short v1:1;
  signed int v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFs1s_BFu1s) C1{ Fs:1 Fi:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1i_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFs1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFs1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFs1s_BFu1s, BFs1s_BFs1i_BFs1s_BFu1s)
//============================================================================


struct  BFs1s_BFs1i_BFu1c  {
  signed short v1:1;
  signed int v2:1;
  unsigned char v3:1;
};
//SIG(1 BFs1s_BFs1i_BFu1c) C1{ Fs:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1c, BFs1s_BFs1i_BFu1c)
//============================================================================


struct  BFs1s_BFs1i_BFu1c_BFs1c  {
  signed short v1:1;
  signed int v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1c_BFs1c) C1{ Fs:1 Fi:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1i_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1c_BFs1c, BFs1s_BFs1i_BFu1c_BFs1c)
//============================================================================


struct  BFs1s_BFs1i_BFu1c_BFs1i  {
  signed short v1:1;
  signed int v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1c_BFs1i) C1{ Fs:1 Fi:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1i_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1c_BFs1i, BFs1s_BFs1i_BFu1c_BFs1i)
//============================================================================


struct  BFs1s_BFs1i_BFu1c_BFs1ll  {
  signed short v1:1;
  signed int v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1c_BFs1ll) C1{ Fs:1 Fi:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1i_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1c_BFs1ll, BFs1s_BFs1i_BFu1c_BFs1ll)
//============================================================================


struct  BFs1s_BFs1i_BFu1c_BFs1s  {
  signed short v1:1;
  signed int v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1c_BFs1s) C1{ Fs:1 Fi:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1i_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1c_BFs1s, BFs1s_BFs1i_BFu1c_BFs1s)
//============================================================================


struct  BFs1s_BFs1i_BFu1c_BFu1c  {
  signed short v1:1;
  signed int v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1c_BFu1c) C1{ Fs:1 Fi:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1i_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1c_BFu1c, BFs1s_BFs1i_BFu1c_BFu1c)
//============================================================================


struct  BFs1s_BFs1i_BFu1c_BFu1i  {
  signed short v1:1;
  signed int v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1c_BFu1i) C1{ Fs:1 Fi:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1i_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1c_BFu1i, BFs1s_BFs1i_BFu1c_BFu1i)
//============================================================================


struct  BFs1s_BFs1i_BFu1c_BFu1ll  {
  signed short v1:1;
  signed int v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1c_BFu1ll) C1{ Fs:1 Fi:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1i_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1c_BFu1ll, BFs1s_BFs1i_BFu1c_BFu1ll)
//============================================================================


struct  BFs1s_BFs1i_BFu1c_BFu1s  {
  signed short v1:1;
  signed int v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1c_BFu1s) C1{ Fs:1 Fi:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1i_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1c_BFu1s, BFs1s_BFs1i_BFu1c_BFu1s)
//============================================================================


struct  BFs1s_BFs1i_BFu1i  {
  signed short v1:1;
  signed int v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1s_BFs1i_BFu1i) C1{ Fs:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1i, BFs1s_BFs1i_BFu1i)
//============================================================================


struct  BFs1s_BFs1i_BFu1i_BFs1c  {
  signed short v1:1;
  signed int v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1i_BFs1c) C1{ Fs:1 Fi:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1i_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1i_BFs1c, BFs1s_BFs1i_BFu1i_BFs1c)
//============================================================================


struct  BFs1s_BFs1i_BFu1i_BFs1i  {
  signed short v1:1;
  signed int v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1i_BFs1i) C1{ Fs:1 Fi:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1i_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1i_BFs1i, BFs1s_BFs1i_BFu1i_BFs1i)
//============================================================================


struct  BFs1s_BFs1i_BFu1i_BFs1ll  {
  signed short v1:1;
  signed int v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1i_BFs1ll) C1{ Fs:1 Fi:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1i_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1i_BFs1ll, BFs1s_BFs1i_BFu1i_BFs1ll)
//============================================================================


struct  BFs1s_BFs1i_BFu1i_BFs1s  {
  signed short v1:1;
  signed int v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1i_BFs1s) C1{ Fs:1 Fi:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1i_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1i_BFs1s, BFs1s_BFs1i_BFu1i_BFs1s)
//============================================================================


struct  BFs1s_BFs1i_BFu1i_BFu1c  {
  signed short v1:1;
  signed int v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1i_BFu1c) C1{ Fs:1 Fi:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1i_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1i_BFu1c, BFs1s_BFs1i_BFu1i_BFu1c)
//============================================================================


struct  BFs1s_BFs1i_BFu1i_BFu1i  {
  signed short v1:1;
  signed int v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1i_BFu1i) C1{ Fs:1 Fi:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1i_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1i_BFu1i, BFs1s_BFs1i_BFu1i_BFu1i)
//============================================================================


struct  BFs1s_BFs1i_BFu1i_BFu1ll  {
  signed short v1:1;
  signed int v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1i_BFu1ll) C1{ Fs:1 Fi:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1i_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1i_BFu1ll, BFs1s_BFs1i_BFu1i_BFu1ll)
//============================================================================


struct  BFs1s_BFs1i_BFu1i_BFu1s  {
  signed short v1:1;
  signed int v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1i_BFu1s) C1{ Fs:1 Fi:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1i_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1i_BFu1s, BFs1s_BFs1i_BFu1i_BFu1s)
//============================================================================


struct  BFs1s_BFs1i_BFu1ll  {
  signed short v1:1;
  signed int v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1s_BFs1i_BFu1ll) C1{ Fs:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1ll, BFs1s_BFs1i_BFu1ll)
//============================================================================


struct  BFs1s_BFs1i_BFu1ll_BFs1c  {
  signed short v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1ll_BFs1c) C1{ Fs:1 Fi:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1i_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1ll_BFs1c, BFs1s_BFs1i_BFu1ll_BFs1c)
//============================================================================


struct  BFs1s_BFs1i_BFu1ll_BFs1i  {
  signed short v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1ll_BFs1i) C1{ Fs:1 Fi:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1i_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1ll_BFs1i, BFs1s_BFs1i_BFu1ll_BFs1i)
//============================================================================


struct  BFs1s_BFs1i_BFu1ll_BFs1ll  {
  signed short v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1ll_BFs1ll) C1{ Fs:1 Fi:1 FL:1 FL:1}



static void Test_BFs1s_BFs1i_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1ll_BFs1ll, BFs1s_BFs1i_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFs1i_BFu1ll_BFs1s  {
  signed short v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1ll_BFs1s) C1{ Fs:1 Fi:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1i_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1ll_BFs1s, BFs1s_BFs1i_BFu1ll_BFs1s)
//============================================================================


struct  BFs1s_BFs1i_BFu1ll_BFu1c  {
  signed short v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1ll_BFu1c) C1{ Fs:1 Fi:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1i_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1ll_BFu1c, BFs1s_BFs1i_BFu1ll_BFu1c)
//============================================================================


struct  BFs1s_BFs1i_BFu1ll_BFu1i  {
  signed short v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1ll_BFu1i) C1{ Fs:1 Fi:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1i_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1ll_BFu1i, BFs1s_BFs1i_BFu1ll_BFu1i)
//============================================================================


struct  BFs1s_BFs1i_BFu1ll_BFu1ll  {
  signed short v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1ll_BFu1ll) C1{ Fs:1 Fi:1 FL:1 FL:1}



static void Test_BFs1s_BFs1i_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1ll_BFu1ll, BFs1s_BFs1i_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFs1i_BFu1ll_BFu1s  {
  signed short v1:1;
  signed int v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1ll_BFu1s) C1{ Fs:1 Fi:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1i_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1ll_BFu1s, BFs1s_BFs1i_BFu1ll_BFu1s)
//============================================================================


struct  BFs1s_BFs1i_BFu1s  {
  signed short v1:1;
  signed int v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1s_BFs1i_BFu1s) C1{ Fs:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1s, BFs1s_BFs1i_BFu1s)
//============================================================================


struct  BFs1s_BFs1i_BFu1s_BFs1c  {
  signed short v1:1;
  signed int v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1s_BFs1c) C1{ Fs:1 Fi:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1i_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1s_BFs1c, BFs1s_BFs1i_BFu1s_BFs1c)
//============================================================================


struct  BFs1s_BFs1i_BFu1s_BFs1i  {
  signed short v1:1;
  signed int v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1s_BFs1i) C1{ Fs:1 Fi:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1i_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1s_BFs1i, BFs1s_BFs1i_BFu1s_BFs1i)
//============================================================================


struct  BFs1s_BFs1i_BFu1s_BFs1ll  {
  signed short v1:1;
  signed int v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1s_BFs1ll) C1{ Fs:1 Fi:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1i_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1s_BFs1ll, BFs1s_BFs1i_BFu1s_BFs1ll)
//============================================================================


struct  BFs1s_BFs1i_BFu1s_BFs1s  {
  signed short v1:1;
  signed int v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1s_BFs1s) C1{ Fs:1 Fi:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1i_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1i_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1s_BFs1s, BFs1s_BFs1i_BFu1s_BFs1s)
//============================================================================


struct  BFs1s_BFs1i_BFu1s_BFu1c  {
  signed short v1:1;
  signed int v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1s_BFu1c) C1{ Fs:1 Fi:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1i_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1s_BFu1c, BFs1s_BFs1i_BFu1s_BFu1c)
//============================================================================


struct  BFs1s_BFs1i_BFu1s_BFu1i  {
  signed short v1:1;
  signed int v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1s_BFu1i) C1{ Fs:1 Fi:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1i_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1s_BFu1i, BFs1s_BFs1i_BFu1s_BFu1i)
//============================================================================


struct  BFs1s_BFs1i_BFu1s_BFu1ll  {
  signed short v1:1;
  signed int v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1s_BFu1ll) C1{ Fs:1 Fi:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1i_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1i_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1i_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1s_BFu1ll, BFs1s_BFs1i_BFu1s_BFu1ll)
//============================================================================


struct  BFs1s_BFs1i_BFu1s_BFu1s  {
  signed short v1:1;
  signed int v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1i_BFu1s_BFu1s) C1{ Fs:1 Fi:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1i_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1i_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1i_BFu1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1i_BFu1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1i_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1i_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1i_BFu1s_BFu1s, BFs1s_BFs1i_BFu1s_BFu1s)
//============================================================================


struct  BFs1s_BFs1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
};
//SIG(1 BFs1s_BFs1ll) C1{ Fs:1 FL:1}



static void Test_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll, BFs1s_BFs1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFs1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1c) C1{ Fs:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1c, BFs1s_BFs1ll_BFs1c)
//============================================================================


struct  BFs1s_BFs1ll_BFs1c_BFs1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1c_BFs1c) C1{ Fs:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1c_BFs1c, BFs1s_BFs1ll_BFs1c_BFs1c)
//============================================================================


struct  BFs1s_BFs1ll_BFs1c_BFs1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1c_BFs1i) C1{ Fs:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1c_BFs1i, BFs1s_BFs1ll_BFs1c_BFs1i)
//============================================================================


struct  BFs1s_BFs1ll_BFs1c_BFs1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1c_BFs1ll) C1{ Fs:1 FL:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1ll_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1c_BFs1ll, BFs1s_BFs1ll_BFs1c_BFs1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFs1c_BFs1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1c_BFs1s) C1{ Fs:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1c_BFs1s, BFs1s_BFs1ll_BFs1c_BFs1s)
//============================================================================


struct  BFs1s_BFs1ll_BFs1c_BFu1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1c_BFu1c) C1{ Fs:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1c_BFu1c, BFs1s_BFs1ll_BFs1c_BFu1c)
//============================================================================


struct  BFs1s_BFs1ll_BFs1c_BFu1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1c_BFu1i) C1{ Fs:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1c_BFu1i, BFs1s_BFs1ll_BFs1c_BFu1i)
//============================================================================


struct  BFs1s_BFs1ll_BFs1c_BFu1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1c_BFu1ll) C1{ Fs:1 FL:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1ll_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1c_BFu1ll, BFs1s_BFs1ll_BFs1c_BFu1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFs1c_BFu1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1c_BFu1s) C1{ Fs:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1c_BFu1s, BFs1s_BFs1ll_BFs1c_BFu1s)
//============================================================================


struct  BFs1s_BFs1ll_BFs1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1i) C1{ Fs:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1i, BFs1s_BFs1ll_BFs1i)
//============================================================================


struct  BFs1s_BFs1ll_BFs1i_BFs1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1i_BFs1c) C1{ Fs:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1i_BFs1c, BFs1s_BFs1ll_BFs1i_BFs1c)
//============================================================================


struct  BFs1s_BFs1ll_BFs1i_BFs1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1i_BFs1i) C1{ Fs:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1i_BFs1i, BFs1s_BFs1ll_BFs1i_BFs1i)
//============================================================================


struct  BFs1s_BFs1ll_BFs1i_BFs1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1i_BFs1ll) C1{ Fs:1 FL:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1ll_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1i_BFs1ll, BFs1s_BFs1ll_BFs1i_BFs1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFs1i_BFs1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1i_BFs1s) C1{ Fs:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1i_BFs1s, BFs1s_BFs1ll_BFs1i_BFs1s)
//============================================================================


struct  BFs1s_BFs1ll_BFs1i_BFu1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1i_BFu1c) C1{ Fs:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1i_BFu1c, BFs1s_BFs1ll_BFs1i_BFu1c)
//============================================================================


struct  BFs1s_BFs1ll_BFs1i_BFu1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1i_BFu1i) C1{ Fs:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1i_BFu1i, BFs1s_BFs1ll_BFs1i_BFu1i)
//============================================================================


struct  BFs1s_BFs1ll_BFs1i_BFu1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1i_BFu1ll) C1{ Fs:1 FL:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1ll_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1i_BFu1ll, BFs1s_BFs1ll_BFs1i_BFu1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFs1i_BFu1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1i_BFu1s) C1{ Fs:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1i_BFu1s, BFs1s_BFs1ll_BFs1i_BFu1s)
//============================================================================


struct  BFs1s_BFs1ll_BFs1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1ll) C1{ Fs:1 FL:1 FL:1}



static void Test_BFs1s_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1ll, BFs1s_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFs1ll_BFs1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1ll_BFs1c) C1{ Fs:1 FL:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1ll_BFs1c, BFs1s_BFs1ll_BFs1ll_BFs1c)
//============================================================================


struct  BFs1s_BFs1ll_BFs1ll_BFs1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1ll_BFs1i) C1{ Fs:1 FL:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1ll_BFs1i, BFs1s_BFs1ll_BFs1ll_BFs1i)
//============================================================================


struct  BFs1s_BFs1ll_BFs1ll_BFs1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1ll_BFs1ll) C1{ Fs:1 FL:1 FL:1 FL:1}



static void Test_BFs1s_BFs1ll_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1ll_BFs1ll, BFs1s_BFs1ll_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFs1ll_BFs1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1ll_BFs1s) C1{ Fs:1 FL:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1ll_BFs1s, BFs1s_BFs1ll_BFs1ll_BFs1s)
//============================================================================


struct  BFs1s_BFs1ll_BFs1ll_BFu1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1ll_BFu1c) C1{ Fs:1 FL:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1ll_BFu1c, BFs1s_BFs1ll_BFs1ll_BFu1c)
//============================================================================


struct  BFs1s_BFs1ll_BFs1ll_BFu1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1ll_BFu1i) C1{ Fs:1 FL:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1ll_BFu1i, BFs1s_BFs1ll_BFs1ll_BFu1i)
//============================================================================


struct  BFs1s_BFs1ll_BFs1ll_BFu1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1ll_BFu1ll) C1{ Fs:1 FL:1 FL:1 FL:1}



static void Test_BFs1s_BFs1ll_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1ll_BFu1ll, BFs1s_BFs1ll_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFs1ll_BFu1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1ll_BFu1s) C1{ Fs:1 FL:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1ll_BFu1s, BFs1s_BFs1ll_BFs1ll_BFu1s)
//============================================================================


struct  BFs1s_BFs1ll_BFs1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1s) C1{ Fs:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1s, BFs1s_BFs1ll_BFs1s)
//============================================================================


struct  BFs1s_BFs1ll_BFs1s_BFs1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1s_BFs1c) C1{ Fs:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1s_BFs1c, BFs1s_BFs1ll_BFs1s_BFs1c)
//============================================================================


struct  BFs1s_BFs1ll_BFs1s_BFs1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1s_BFs1i) C1{ Fs:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1s_BFs1i, BFs1s_BFs1ll_BFs1s_BFs1i)
//============================================================================


struct  BFs1s_BFs1ll_BFs1s_BFs1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1s_BFs1ll) C1{ Fs:1 FL:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1ll_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1s_BFs1ll, BFs1s_BFs1ll_BFs1s_BFs1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFs1s_BFs1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1s_BFs1s) C1{ Fs:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1s_BFs1s, BFs1s_BFs1ll_BFs1s_BFs1s)
//============================================================================


struct  BFs1s_BFs1ll_BFs1s_BFu1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1s_BFu1c) C1{ Fs:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1s_BFu1c, BFs1s_BFs1ll_BFs1s_BFu1c)
//============================================================================


struct  BFs1s_BFs1ll_BFs1s_BFu1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1s_BFu1i) C1{ Fs:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1s_BFu1i, BFs1s_BFs1ll_BFs1s_BFu1i)
//============================================================================


struct  BFs1s_BFs1ll_BFs1s_BFu1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1s_BFu1ll) C1{ Fs:1 FL:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1ll_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1s_BFu1ll, BFs1s_BFs1ll_BFs1s_BFu1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFs1s_BFu1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFs1s_BFu1s) C1{ Fs:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFs1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFs1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFs1s_BFu1s, BFs1s_BFs1ll_BFs1s_BFu1s)
//============================================================================


struct  BFs1s_BFs1ll_BFu1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1c) C1{ Fs:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1c, BFs1s_BFs1ll_BFu1c)
//============================================================================


struct  BFs1s_BFs1ll_BFu1c_BFs1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1c_BFs1c) C1{ Fs:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1c_BFs1c, BFs1s_BFs1ll_BFu1c_BFs1c)
//============================================================================


struct  BFs1s_BFs1ll_BFu1c_BFs1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1c_BFs1i) C1{ Fs:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1c_BFs1i, BFs1s_BFs1ll_BFu1c_BFs1i)
//============================================================================


struct  BFs1s_BFs1ll_BFu1c_BFs1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1c_BFs1ll) C1{ Fs:1 FL:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1ll_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1c_BFs1ll, BFs1s_BFs1ll_BFu1c_BFs1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFu1c_BFs1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1c_BFs1s) C1{ Fs:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1c_BFs1s, BFs1s_BFs1ll_BFu1c_BFs1s)
//============================================================================


struct  BFs1s_BFs1ll_BFu1c_BFu1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1c_BFu1c) C1{ Fs:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1c_BFu1c, BFs1s_BFs1ll_BFu1c_BFu1c)
//============================================================================


struct  BFs1s_BFs1ll_BFu1c_BFu1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1c_BFu1i) C1{ Fs:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1c_BFu1i, BFs1s_BFs1ll_BFu1c_BFu1i)
//============================================================================


struct  BFs1s_BFs1ll_BFu1c_BFu1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1c_BFu1ll) C1{ Fs:1 FL:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1ll_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1c_BFu1ll, BFs1s_BFs1ll_BFu1c_BFu1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFu1c_BFu1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1c_BFu1s) C1{ Fs:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1c_BFu1s, BFs1s_BFs1ll_BFu1c_BFu1s)
//============================================================================


struct  BFs1s_BFs1ll_BFu1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1i) C1{ Fs:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1i, BFs1s_BFs1ll_BFu1i)
//============================================================================


struct  BFs1s_BFs1ll_BFu1i_BFs1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1i_BFs1c) C1{ Fs:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1i_BFs1c, BFs1s_BFs1ll_BFu1i_BFs1c)
//============================================================================


struct  BFs1s_BFs1ll_BFu1i_BFs1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1i_BFs1i) C1{ Fs:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1i_BFs1i, BFs1s_BFs1ll_BFu1i_BFs1i)
//============================================================================


struct  BFs1s_BFs1ll_BFu1i_BFs1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1i_BFs1ll) C1{ Fs:1 FL:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1ll_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1i_BFs1ll, BFs1s_BFs1ll_BFu1i_BFs1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFu1i_BFs1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1i_BFs1s) C1{ Fs:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1i_BFs1s, BFs1s_BFs1ll_BFu1i_BFs1s)
//============================================================================


struct  BFs1s_BFs1ll_BFu1i_BFu1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1i_BFu1c) C1{ Fs:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1i_BFu1c, BFs1s_BFs1ll_BFu1i_BFu1c)
//============================================================================


struct  BFs1s_BFs1ll_BFu1i_BFu1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1i_BFu1i) C1{ Fs:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1i_BFu1i, BFs1s_BFs1ll_BFu1i_BFu1i)
//============================================================================


struct  BFs1s_BFs1ll_BFu1i_BFu1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1i_BFu1ll) C1{ Fs:1 FL:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1ll_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1i_BFu1ll, BFs1s_BFs1ll_BFu1i_BFu1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFu1i_BFu1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1i_BFu1s) C1{ Fs:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1i_BFu1s, BFs1s_BFs1ll_BFu1i_BFu1s)
//============================================================================


struct  BFs1s_BFs1ll_BFu1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1ll) C1{ Fs:1 FL:1 FL:1}



static void Test_BFs1s_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1ll, BFs1s_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFu1ll_BFs1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1ll_BFs1c) C1{ Fs:1 FL:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1ll_BFs1c, BFs1s_BFs1ll_BFu1ll_BFs1c)
//============================================================================


struct  BFs1s_BFs1ll_BFu1ll_BFs1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1ll_BFs1i) C1{ Fs:1 FL:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1ll_BFs1i, BFs1s_BFs1ll_BFu1ll_BFs1i)
//============================================================================


struct  BFs1s_BFs1ll_BFu1ll_BFs1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1ll_BFs1ll) C1{ Fs:1 FL:1 FL:1 FL:1}



static void Test_BFs1s_BFs1ll_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1ll_BFs1ll, BFs1s_BFs1ll_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFu1ll_BFs1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1ll_BFs1s) C1{ Fs:1 FL:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1ll_BFs1s, BFs1s_BFs1ll_BFu1ll_BFs1s)
//============================================================================


struct  BFs1s_BFs1ll_BFu1ll_BFu1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1ll_BFu1c) C1{ Fs:1 FL:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1ll_BFu1c, BFs1s_BFs1ll_BFu1ll_BFu1c)
//============================================================================


struct  BFs1s_BFs1ll_BFu1ll_BFu1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1ll_BFu1i) C1{ Fs:1 FL:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1ll_BFu1i, BFs1s_BFs1ll_BFu1ll_BFu1i)
//============================================================================


struct  BFs1s_BFs1ll_BFu1ll_BFu1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1ll_BFu1ll) C1{ Fs:1 FL:1 FL:1 FL:1}



static void Test_BFs1s_BFs1ll_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1ll_BFu1ll, BFs1s_BFs1ll_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFu1ll_BFu1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1ll_BFu1s) C1{ Fs:1 FL:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1ll_BFu1s, BFs1s_BFs1ll_BFu1ll_BFu1s)
//============================================================================


struct  BFs1s_BFs1ll_BFu1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1s) C1{ Fs:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1s, BFs1s_BFs1ll_BFu1s)
//============================================================================


struct  BFs1s_BFs1ll_BFu1s_BFs1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1s_BFs1c) C1{ Fs:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1s_BFs1c, BFs1s_BFs1ll_BFu1s_BFs1c)
//============================================================================


struct  BFs1s_BFs1ll_BFu1s_BFs1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1s_BFs1i) C1{ Fs:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1s_BFs1i, BFs1s_BFs1ll_BFu1s_BFs1i)
//============================================================================


struct  BFs1s_BFs1ll_BFu1s_BFs1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1s_BFs1ll) C1{ Fs:1 FL:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1ll_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1s_BFs1ll, BFs1s_BFs1ll_BFu1s_BFs1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFu1s_BFs1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1s_BFs1s) C1{ Fs:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1ll_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1s_BFs1s, BFs1s_BFs1ll_BFu1s_BFs1s)
//============================================================================


struct  BFs1s_BFs1ll_BFu1s_BFu1c  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1s_BFu1c) C1{ Fs:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1ll_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1s_BFu1c, BFs1s_BFs1ll_BFu1s_BFu1c)
//============================================================================


struct  BFs1s_BFs1ll_BFu1s_BFu1i  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1s_BFu1i) C1{ Fs:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1ll_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1s_BFu1i, BFs1s_BFs1ll_BFu1s_BFu1i)
//============================================================================


struct  BFs1s_BFs1ll_BFu1s_BFu1ll  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1s_BFu1ll) C1{ Fs:1 FL:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1ll_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1s_BFu1ll, BFs1s_BFs1ll_BFu1s_BFu1ll)
//============================================================================


struct  BFs1s_BFs1ll_BFu1s_BFu1s  {
  signed short v1:1;
  signed __tsi64 v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1ll_BFu1s_BFu1s) C1{ Fs:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1ll_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1ll_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1ll_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1ll_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1ll_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1ll_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1ll_BFu1s_BFu1s, BFs1s_BFs1ll_BFu1s_BFu1s)
//============================================================================


struct  BFs1s_BFs1s  {
  signed short v1:1;
  signed short v2:1;
};
//SIG(1 BFs1s_BFs1s) C1{ Fs:1 Fs:1}



static void Test_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s, BFs1s_BFs1s)
//============================================================================


struct  BFs1s_BFs1s_BFs1c  {
  signed short v1:1;
  signed short v2:1;
  signed char v3:1;
};
//SIG(1 BFs1s_BFs1s_BFs1c) C1{ Fs:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1c, BFs1s_BFs1s_BFs1c)
//============================================================================


struct  BFs1s_BFs1s_BFs1c_BFs1c  {
  signed short v1:1;
  signed short v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1c_BFs1c) C1{ Fs:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1s_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1c_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFs1c_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1c_BFs1c, BFs1s_BFs1s_BFs1c_BFs1c)
//============================================================================


struct  BFs1s_BFs1s_BFs1c_BFs1i  {
  signed short v1:1;
  signed short v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1c_BFs1i) C1{ Fs:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1s_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1c_BFs1i, BFs1s_BFs1s_BFs1c_BFs1i)
//============================================================================


struct  BFs1s_BFs1s_BFs1c_BFs1ll  {
  signed short v1:1;
  signed short v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1c_BFs1ll) C1{ Fs:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1s_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1c_BFs1ll, BFs1s_BFs1s_BFs1c_BFs1ll)
//============================================================================


struct  BFs1s_BFs1s_BFs1c_BFs1s  {
  signed short v1:1;
  signed short v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1c_BFs1s) C1{ Fs:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1s_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFs1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1c_BFs1s, BFs1s_BFs1s_BFs1c_BFs1s)
//============================================================================


struct  BFs1s_BFs1s_BFs1c_BFu1c  {
  signed short v1:1;
  signed short v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1c_BFu1c) C1{ Fs:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1s_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFs1c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1c_BFu1c, BFs1s_BFs1s_BFs1c_BFu1c)
//============================================================================


struct  BFs1s_BFs1s_BFs1c_BFu1i  {
  signed short v1:1;
  signed short v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1c_BFu1i) C1{ Fs:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1s_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1c_BFu1i, BFs1s_BFs1s_BFs1c_BFu1i)
//============================================================================


struct  BFs1s_BFs1s_BFs1c_BFu1ll  {
  signed short v1:1;
  signed short v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1c_BFu1ll) C1{ Fs:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1s_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1c_BFu1ll, BFs1s_BFs1s_BFs1c_BFu1ll)
//============================================================================


struct  BFs1s_BFs1s_BFs1c_BFu1s  {
  signed short v1:1;
  signed short v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1c_BFu1s) C1{ Fs:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1s_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFs1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1c_BFu1s, BFs1s_BFs1s_BFs1c_BFu1s)
//============================================================================


struct  BFs1s_BFs1s_BFs1i  {
  signed short v1:1;
  signed short v2:1;
  signed int v3:1;
};
//SIG(1 BFs1s_BFs1s_BFs1i) C1{ Fs:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1i, BFs1s_BFs1s_BFs1i)
//============================================================================


struct  BFs1s_BFs1s_BFs1i_BFs1c  {
  signed short v1:1;
  signed short v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1i_BFs1c) C1{ Fs:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1s_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1i_BFs1c, BFs1s_BFs1s_BFs1i_BFs1c)
//============================================================================


struct  BFs1s_BFs1s_BFs1i_BFs1i  {
  signed short v1:1;
  signed short v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1i_BFs1i) C1{ Fs:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1s_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1i_BFs1i, BFs1s_BFs1s_BFs1i_BFs1i)
//============================================================================


struct  BFs1s_BFs1s_BFs1i_BFs1ll  {
  signed short v1:1;
  signed short v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1i_BFs1ll) C1{ Fs:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1s_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1i_BFs1ll, BFs1s_BFs1s_BFs1i_BFs1ll)
//============================================================================


struct  BFs1s_BFs1s_BFs1i_BFs1s  {
  signed short v1:1;
  signed short v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1i_BFs1s) C1{ Fs:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1s_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1i_BFs1s, BFs1s_BFs1s_BFs1i_BFs1s)
//============================================================================


struct  BFs1s_BFs1s_BFs1i_BFu1c  {
  signed short v1:1;
  signed short v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1i_BFu1c) C1{ Fs:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1s_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1i_BFu1c, BFs1s_BFs1s_BFs1i_BFu1c)
//============================================================================


struct  BFs1s_BFs1s_BFs1i_BFu1i  {
  signed short v1:1;
  signed short v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1i_BFu1i) C1{ Fs:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1s_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1i_BFu1i, BFs1s_BFs1s_BFs1i_BFu1i)
//============================================================================


struct  BFs1s_BFs1s_BFs1i_BFu1ll  {
  signed short v1:1;
  signed short v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1i_BFu1ll) C1{ Fs:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1s_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1i_BFu1ll, BFs1s_BFs1s_BFs1i_BFu1ll)
//============================================================================


struct  BFs1s_BFs1s_BFs1i_BFu1s  {
  signed short v1:1;
  signed short v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1i_BFu1s) C1{ Fs:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1s_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1i_BFu1s, BFs1s_BFs1s_BFs1i_BFu1s)
//============================================================================


struct  BFs1s_BFs1s_BFs1ll  {
  signed short v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFs1s_BFs1s_BFs1ll) C1{ Fs:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1ll, BFs1s_BFs1s_BFs1ll)
//============================================================================


struct  BFs1s_BFs1s_BFs1ll_BFs1c  {
  signed short v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1ll_BFs1c) C1{ Fs:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1s_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1ll_BFs1c, BFs1s_BFs1s_BFs1ll_BFs1c)
//============================================================================


struct  BFs1s_BFs1s_BFs1ll_BFs1i  {
  signed short v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1ll_BFs1i) C1{ Fs:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1s_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1ll_BFs1i, BFs1s_BFs1s_BFs1ll_BFs1i)
//============================================================================


struct  BFs1s_BFs1s_BFs1ll_BFs1ll  {
  signed short v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1ll_BFs1ll) C1{ Fs:1 Fs:1 FL:1 FL:1}



static void Test_BFs1s_BFs1s_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1ll_BFs1ll, BFs1s_BFs1s_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFs1s_BFs1ll_BFs1s  {
  signed short v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1ll_BFs1s) C1{ Fs:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1s_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1ll_BFs1s, BFs1s_BFs1s_BFs1ll_BFs1s)
//============================================================================


struct  BFs1s_BFs1s_BFs1ll_BFu1c  {
  signed short v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1ll_BFu1c) C1{ Fs:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1s_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1ll_BFu1c, BFs1s_BFs1s_BFs1ll_BFu1c)
//============================================================================


struct  BFs1s_BFs1s_BFs1ll_BFu1i  {
  signed short v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1ll_BFu1i) C1{ Fs:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1s_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1ll_BFu1i, BFs1s_BFs1s_BFs1ll_BFu1i)
//============================================================================


struct  BFs1s_BFs1s_BFs1ll_BFu1ll  {
  signed short v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1ll_BFu1ll) C1{ Fs:1 Fs:1 FL:1 FL:1}



static void Test_BFs1s_BFs1s_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1ll_BFu1ll, BFs1s_BFs1s_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFs1s_BFs1ll_BFu1s  {
  signed short v1:1;
  signed short v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1ll_BFu1s) C1{ Fs:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1s_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1ll_BFu1s, BFs1s_BFs1s_BFs1ll_BFu1s)
//============================================================================


struct  BFs1s_BFs1s_BFs1s  {
  signed short v1:1;
  signed short v2:1;
  signed short v3:1;
};
//SIG(1 BFs1s_BFs1s_BFs1s) C1{ Fs:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1s, BFs1s_BFs1s_BFs1s)
//============================================================================


struct  BFs1s_BFs1s_BFs1s_BFs1c  {
  signed short v1:1;
  signed short v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1s_BFs1c) C1{ Fs:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1s_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFs1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1s_BFs1c, BFs1s_BFs1s_BFs1s_BFs1c)
//============================================================================


struct  BFs1s_BFs1s_BFs1s_BFs1i  {
  signed short v1:1;
  signed short v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1s_BFs1i) C1{ Fs:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1s_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1s_BFs1i, BFs1s_BFs1s_BFs1s_BFs1i)
//============================================================================


struct  BFs1s_BFs1s_BFs1s_BFs1ll  {
  signed short v1:1;
  signed short v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1s_BFs1ll) C1{ Fs:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1s_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1s_BFs1ll, BFs1s_BFs1s_BFs1s_BFs1ll)
//============================================================================


struct  BFs1s_BFs1s_BFs1s_BFs1s  {
  signed short v1:1;
  signed short v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1s_BFs1s) C1{ Fs:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1s_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFs1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1s_BFs1s, BFs1s_BFs1s_BFs1s_BFs1s)
//============================================================================


struct  BFs1s_BFs1s_BFs1s_BFu1c  {
  signed short v1:1;
  signed short v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1s_BFu1c) C1{ Fs:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1s_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFs1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1s_BFu1c, BFs1s_BFs1s_BFs1s_BFu1c)
//============================================================================


struct  BFs1s_BFs1s_BFs1s_BFu1i  {
  signed short v1:1;
  signed short v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1s_BFu1i) C1{ Fs:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1s_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1s_BFu1i, BFs1s_BFs1s_BFs1s_BFu1i)
//============================================================================


struct  BFs1s_BFs1s_BFs1s_BFu1ll  {
  signed short v1:1;
  signed short v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1s_BFu1ll) C1{ Fs:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1s_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1s_BFu1ll, BFs1s_BFs1s_BFs1s_BFu1ll)
//============================================================================


struct  BFs1s_BFs1s_BFs1s_BFu1s  {
  signed short v1:1;
  signed short v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFs1s_BFu1s) C1{ Fs:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1s_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFs1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFs1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFs1s_BFu1s, BFs1s_BFs1s_BFs1s_BFu1s)
//============================================================================


struct  BFs1s_BFs1s_BFu1c  {
  signed short v1:1;
  signed short v2:1;
  unsigned char v3:1;
};
//SIG(1 BFs1s_BFs1s_BFu1c) C1{ Fs:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1c, BFs1s_BFs1s_BFu1c)
//============================================================================


struct  BFs1s_BFs1s_BFu1c_BFs1c  {
  signed short v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1c_BFs1c) C1{ Fs:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1s_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1c_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFu1c_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1c_BFs1c, BFs1s_BFs1s_BFu1c_BFs1c)
//============================================================================


struct  BFs1s_BFs1s_BFu1c_BFs1i  {
  signed short v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1c_BFs1i) C1{ Fs:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1s_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1c_BFs1i, BFs1s_BFs1s_BFu1c_BFs1i)
//============================================================================


struct  BFs1s_BFs1s_BFu1c_BFs1ll  {
  signed short v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1c_BFs1ll) C1{ Fs:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1s_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1c_BFs1ll, BFs1s_BFs1s_BFu1c_BFs1ll)
//============================================================================


struct  BFs1s_BFs1s_BFu1c_BFs1s  {
  signed short v1:1;
  signed short v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1c_BFs1s) C1{ Fs:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1s_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFu1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1c_BFs1s, BFs1s_BFs1s_BFu1c_BFs1s)
//============================================================================


struct  BFs1s_BFs1s_BFu1c_BFu1c  {
  signed short v1:1;
  signed short v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1c_BFu1c) C1{ Fs:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1s_BFs1s_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFu1c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1c_BFu1c, BFs1s_BFs1s_BFu1c_BFu1c)
//============================================================================


struct  BFs1s_BFs1s_BFu1c_BFu1i  {
  signed short v1:1;
  signed short v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1c_BFu1i) C1{ Fs:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1s_BFs1s_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1c_BFu1i, BFs1s_BFs1s_BFu1c_BFu1i)
//============================================================================


struct  BFs1s_BFs1s_BFu1c_BFu1ll  {
  signed short v1:1;
  signed short v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1c_BFu1ll) C1{ Fs:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1s_BFs1s_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1c_BFu1ll, BFs1s_BFs1s_BFu1c_BFu1ll)
//============================================================================


struct  BFs1s_BFs1s_BFu1c_BFu1s  {
  signed short v1:1;
  signed short v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1c_BFu1s) C1{ Fs:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1s_BFs1s_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFu1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1c_BFu1s, BFs1s_BFs1s_BFu1c_BFu1s)
//============================================================================


struct  BFs1s_BFs1s_BFu1i  {
  signed short v1:1;
  signed short v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1s_BFs1s_BFu1i) C1{ Fs:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1i, BFs1s_BFs1s_BFu1i)
//============================================================================


struct  BFs1s_BFs1s_BFu1i_BFs1c  {
  signed short v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1i_BFs1c) C1{ Fs:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1s_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1i_BFs1c, BFs1s_BFs1s_BFu1i_BFs1c)
//============================================================================


struct  BFs1s_BFs1s_BFu1i_BFs1i  {
  signed short v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1i_BFs1i) C1{ Fs:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1s_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1i_BFs1i, BFs1s_BFs1s_BFu1i_BFs1i)
//============================================================================


struct  BFs1s_BFs1s_BFu1i_BFs1ll  {
  signed short v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1i_BFs1ll) C1{ Fs:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1s_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1i_BFs1ll, BFs1s_BFs1s_BFu1i_BFs1ll)
//============================================================================


struct  BFs1s_BFs1s_BFu1i_BFs1s  {
  signed short v1:1;
  signed short v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1i_BFs1s) C1{ Fs:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1s_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1i_BFs1s, BFs1s_BFs1s_BFu1i_BFs1s)
//============================================================================


struct  BFs1s_BFs1s_BFu1i_BFu1c  {
  signed short v1:1;
  signed short v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1i_BFu1c) C1{ Fs:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1s_BFs1s_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1i_BFu1c, BFs1s_BFs1s_BFu1i_BFu1c)
//============================================================================


struct  BFs1s_BFs1s_BFu1i_BFu1i  {
  signed short v1:1;
  signed short v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1i_BFu1i) C1{ Fs:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1s_BFs1s_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1i_BFu1i, BFs1s_BFs1s_BFu1i_BFu1i)
//============================================================================


struct  BFs1s_BFs1s_BFu1i_BFu1ll  {
  signed short v1:1;
  signed short v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1i_BFu1ll) C1{ Fs:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1s_BFs1s_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1i_BFu1ll, BFs1s_BFs1s_BFu1i_BFu1ll)
//============================================================================


struct  BFs1s_BFs1s_BFu1i_BFu1s  {
  signed short v1:1;
  signed short v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1i_BFu1s) C1{ Fs:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1s_BFs1s_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1i_BFu1s, BFs1s_BFs1s_BFu1i_BFu1s)
//============================================================================


struct  BFs1s_BFs1s_BFu1ll  {
  signed short v1:1;
  signed short v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1s_BFs1s_BFu1ll) C1{ Fs:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1ll, BFs1s_BFs1s_BFu1ll)
//============================================================================


struct  BFs1s_BFs1s_BFu1ll_BFs1c  {
  signed short v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1ll_BFs1c) C1{ Fs:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1s_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1ll_BFs1c, BFs1s_BFs1s_BFu1ll_BFs1c)
//============================================================================


struct  BFs1s_BFs1s_BFu1ll_BFs1i  {
  signed short v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1ll_BFs1i) C1{ Fs:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1s_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1ll_BFs1i, BFs1s_BFs1s_BFu1ll_BFs1i)
//============================================================================


struct  BFs1s_BFs1s_BFu1ll_BFs1ll  {
  signed short v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1ll_BFs1ll) C1{ Fs:1 Fs:1 FL:1 FL:1}



static void Test_BFs1s_BFs1s_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1ll_BFs1ll, BFs1s_BFs1s_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFs1s_BFu1ll_BFs1s  {
  signed short v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1ll_BFs1s) C1{ Fs:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1s_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1ll_BFs1s, BFs1s_BFs1s_BFu1ll_BFs1s)
//============================================================================


struct  BFs1s_BFs1s_BFu1ll_BFu1c  {
  signed short v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1ll_BFu1c) C1{ Fs:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1s_BFs1s_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1ll_BFu1c, BFs1s_BFs1s_BFu1ll_BFu1c)
//============================================================================


struct  BFs1s_BFs1s_BFu1ll_BFu1i  {
  signed short v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1ll_BFu1i) C1{ Fs:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1s_BFs1s_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1ll_BFu1i, BFs1s_BFs1s_BFu1ll_BFu1i)
//============================================================================


struct  BFs1s_BFs1s_BFu1ll_BFu1ll  {
  signed short v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1ll_BFu1ll) C1{ Fs:1 Fs:1 FL:1 FL:1}



static void Test_BFs1s_BFs1s_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1ll_BFu1ll, BFs1s_BFs1s_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFs1s_BFu1ll_BFu1s  {
  signed short v1:1;
  signed short v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1ll_BFu1s) C1{ Fs:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1s_BFs1s_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1ll_BFu1s, BFs1s_BFs1s_BFu1ll_BFu1s)
//============================================================================


struct  BFs1s_BFs1s_BFu1s  {
  signed short v1:1;
  signed short v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1s_BFs1s_BFu1s) C1{ Fs:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1s, BFs1s_BFs1s_BFu1s)
//============================================================================


struct  BFs1s_BFs1s_BFu1s_BFs1c  {
  signed short v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1s_BFs1c) C1{ Fs:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1s_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFu1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1s_BFs1c, BFs1s_BFs1s_BFu1s_BFs1c)
//============================================================================


struct  BFs1s_BFs1s_BFu1s_BFs1i  {
  signed short v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1s_BFs1i) C1{ Fs:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1s_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1s_BFs1i, BFs1s_BFs1s_BFu1s_BFs1i)
//============================================================================


struct  BFs1s_BFs1s_BFu1s_BFs1ll  {
  signed short v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1s_BFs1ll) C1{ Fs:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1s_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1s_BFs1ll, BFs1s_BFs1s_BFu1s_BFs1ll)
//============================================================================


struct  BFs1s_BFs1s_BFu1s_BFs1s  {
  signed short v1:1;
  signed short v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1s_BFs1s) C1{ Fs:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1s_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFu1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFs1s_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1s_BFs1s, BFs1s_BFs1s_BFu1s_BFs1s)
//============================================================================


struct  BFs1s_BFs1s_BFu1s_BFu1c  {
  signed short v1:1;
  signed short v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1s_BFu1c) C1{ Fs:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1s_BFs1s_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFu1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1s_BFu1c, BFs1s_BFs1s_BFu1s_BFu1c)
//============================================================================


struct  BFs1s_BFs1s_BFu1s_BFu1i  {
  signed short v1:1;
  signed short v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1s_BFu1i) C1{ Fs:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1s_BFs1s_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFs1s_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFs1s_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1s_BFu1i, BFs1s_BFs1s_BFu1s_BFu1i)
//============================================================================


struct  BFs1s_BFs1s_BFu1s_BFu1ll  {
  signed short v1:1;
  signed short v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1s_BFu1ll) C1{ Fs:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1s_BFs1s_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFs1s_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFs1s_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1s_BFu1ll, BFs1s_BFs1s_BFu1s_BFu1ll)
//============================================================================


struct  BFs1s_BFs1s_BFu1s_BFu1s  {
  signed short v1:1;
  signed short v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFs1s_BFu1s_BFu1s) C1{ Fs:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1s_BFs1s_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFs1s_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFs1s_BFu1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFs1s_BFu1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFs1s_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1s_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFs1s_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFs1s_BFu1s_BFu1s, BFs1s_BFs1s_BFu1s_BFu1s)
//============================================================================


struct  BFs1s_BFu1c  {
  signed short v1:1;
  unsigned char v2:1;
};
//SIG(1 BFs1s_BFu1c) C1{ Fs:1 Fc:1}



static void Test_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c, BFs1s_BFu1c)
//============================================================================


struct  BFs1s_BFu1c_BFs1c  {
  signed short v1:1;
  unsigned char v2:1;
  signed char v3:1;
};
//SIG(1 BFs1s_BFu1c_BFs1c) C1{ Fs:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1c, BFs1s_BFu1c_BFs1c)
//============================================================================


struct  BFs1s_BFu1c_BFs1c_BFs1c  {
  signed short v1:1;
  unsigned char v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1c_BFs1c) C1{ Fs:1 Fc:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1c_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1c_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFs1c_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1c_BFs1c, BFs1s_BFu1c_BFs1c_BFs1c)
//============================================================================


struct  BFs1s_BFu1c_BFs1c_BFs1i  {
  signed short v1:1;
  unsigned char v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1c_BFs1i) C1{ Fs:1 Fc:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1c_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1c_BFs1i, BFs1s_BFu1c_BFs1c_BFs1i)
//============================================================================


struct  BFs1s_BFu1c_BFs1c_BFs1ll  {
  signed short v1:1;
  unsigned char v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1c_BFs1ll) C1{ Fs:1 Fc:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1c_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1c_BFs1ll, BFs1s_BFu1c_BFs1c_BFs1ll)
//============================================================================


struct  BFs1s_BFu1c_BFs1c_BFs1s  {
  signed short v1:1;
  unsigned char v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1c_BFs1s) C1{ Fs:1 Fc:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1c_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFs1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1c_BFs1s, BFs1s_BFu1c_BFs1c_BFs1s)
//============================================================================


struct  BFs1s_BFu1c_BFs1c_BFu1c  {
  signed short v1:1;
  unsigned char v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1c_BFu1c) C1{ Fs:1 Fc:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1c_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFs1c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1c_BFu1c, BFs1s_BFu1c_BFs1c_BFu1c)
//============================================================================


struct  BFs1s_BFu1c_BFs1c_BFu1i  {
  signed short v1:1;
  unsigned char v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1c_BFu1i) C1{ Fs:1 Fc:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1c_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1c_BFu1i, BFs1s_BFu1c_BFs1c_BFu1i)
//============================================================================


struct  BFs1s_BFu1c_BFs1c_BFu1ll  {
  signed short v1:1;
  unsigned char v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1c_BFu1ll) C1{ Fs:1 Fc:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1c_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1c_BFu1ll, BFs1s_BFu1c_BFs1c_BFu1ll)
//============================================================================


struct  BFs1s_BFu1c_BFs1c_BFu1s  {
  signed short v1:1;
  unsigned char v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1c_BFu1s) C1{ Fs:1 Fc:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1c_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFs1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1c_BFu1s, BFs1s_BFu1c_BFs1c_BFu1s)
//============================================================================


struct  BFs1s_BFu1c_BFs1i  {
  signed short v1:1;
  unsigned char v2:1;
  signed int v3:1;
};
//SIG(1 BFs1s_BFu1c_BFs1i) C1{ Fs:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1i, BFs1s_BFu1c_BFs1i)
//============================================================================


struct  BFs1s_BFu1c_BFs1i_BFs1c  {
  signed short v1:1;
  unsigned char v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1i_BFs1c) C1{ Fs:1 Fc:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1c_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1i_BFs1c, BFs1s_BFu1c_BFs1i_BFs1c)
//============================================================================


struct  BFs1s_BFu1c_BFs1i_BFs1i  {
  signed short v1:1;
  unsigned char v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1i_BFs1i) C1{ Fs:1 Fc:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1c_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1i_BFs1i, BFs1s_BFu1c_BFs1i_BFs1i)
//============================================================================


struct  BFs1s_BFu1c_BFs1i_BFs1ll  {
  signed short v1:1;
  unsigned char v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1i_BFs1ll) C1{ Fs:1 Fc:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1c_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1i_BFs1ll, BFs1s_BFu1c_BFs1i_BFs1ll)
//============================================================================


struct  BFs1s_BFu1c_BFs1i_BFs1s  {
  signed short v1:1;
  unsigned char v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1i_BFs1s) C1{ Fs:1 Fc:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1c_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1i_BFs1s, BFs1s_BFu1c_BFs1i_BFs1s)
//============================================================================


struct  BFs1s_BFu1c_BFs1i_BFu1c  {
  signed short v1:1;
  unsigned char v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1i_BFu1c) C1{ Fs:1 Fc:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1c_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1i_BFu1c, BFs1s_BFu1c_BFs1i_BFu1c)
//============================================================================


struct  BFs1s_BFu1c_BFs1i_BFu1i  {
  signed short v1:1;
  unsigned char v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1i_BFu1i) C1{ Fs:1 Fc:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1c_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1i_BFu1i, BFs1s_BFu1c_BFs1i_BFu1i)
//============================================================================


struct  BFs1s_BFu1c_BFs1i_BFu1ll  {
  signed short v1:1;
  unsigned char v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1i_BFu1ll) C1{ Fs:1 Fc:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1c_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1i_BFu1ll, BFs1s_BFu1c_BFs1i_BFu1ll)
//============================================================================


struct  BFs1s_BFu1c_BFs1i_BFu1s  {
  signed short v1:1;
  unsigned char v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1i_BFu1s) C1{ Fs:1 Fc:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1c_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1i_BFu1s, BFs1s_BFu1c_BFs1i_BFu1s)
//============================================================================


struct  BFs1s_BFu1c_BFs1ll  {
  signed short v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFs1s_BFu1c_BFs1ll) C1{ Fs:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1ll, BFs1s_BFu1c_BFs1ll)
//============================================================================


struct  BFs1s_BFu1c_BFs1ll_BFs1c  {
  signed short v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1ll_BFs1c) C1{ Fs:1 Fc:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1c_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1ll_BFs1c, BFs1s_BFu1c_BFs1ll_BFs1c)
//============================================================================


struct  BFs1s_BFu1c_BFs1ll_BFs1i  {
  signed short v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1ll_BFs1i) C1{ Fs:1 Fc:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1c_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1ll_BFs1i, BFs1s_BFu1c_BFs1ll_BFs1i)
//============================================================================


struct  BFs1s_BFu1c_BFs1ll_BFs1ll  {
  signed short v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1ll_BFs1ll) C1{ Fs:1 Fc:1 FL:1 FL:1}



static void Test_BFs1s_BFu1c_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1ll_BFs1ll, BFs1s_BFu1c_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFu1c_BFs1ll_BFs1s  {
  signed short v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1ll_BFs1s) C1{ Fs:1 Fc:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1c_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1ll_BFs1s, BFs1s_BFu1c_BFs1ll_BFs1s)
//============================================================================


struct  BFs1s_BFu1c_BFs1ll_BFu1c  {
  signed short v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1ll_BFu1c) C1{ Fs:1 Fc:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1c_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1ll_BFu1c, BFs1s_BFu1c_BFs1ll_BFu1c)
//============================================================================


struct  BFs1s_BFu1c_BFs1ll_BFu1i  {
  signed short v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1ll_BFu1i) C1{ Fs:1 Fc:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1c_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1ll_BFu1i, BFs1s_BFu1c_BFs1ll_BFu1i)
//============================================================================


struct  BFs1s_BFu1c_BFs1ll_BFu1ll  {
  signed short v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1ll_BFu1ll) C1{ Fs:1 Fc:1 FL:1 FL:1}



static void Test_BFs1s_BFu1c_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1ll_BFu1ll, BFs1s_BFu1c_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFu1c_BFs1ll_BFu1s  {
  signed short v1:1;
  unsigned char v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1ll_BFu1s) C1{ Fs:1 Fc:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1c_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1ll_BFu1s, BFs1s_BFu1c_BFs1ll_BFu1s)
//============================================================================


struct  BFs1s_BFu1c_BFs1s  {
  signed short v1:1;
  unsigned char v2:1;
  signed short v3:1;
};
//SIG(1 BFs1s_BFu1c_BFs1s) C1{ Fs:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1s, BFs1s_BFu1c_BFs1s)
//============================================================================


struct  BFs1s_BFu1c_BFs1s_BFs1c  {
  signed short v1:1;
  unsigned char v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1s_BFs1c) C1{ Fs:1 Fc:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1c_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFs1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1s_BFs1c, BFs1s_BFu1c_BFs1s_BFs1c)
//============================================================================


struct  BFs1s_BFu1c_BFs1s_BFs1i  {
  signed short v1:1;
  unsigned char v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1s_BFs1i) C1{ Fs:1 Fc:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1c_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1s_BFs1i, BFs1s_BFu1c_BFs1s_BFs1i)
//============================================================================


struct  BFs1s_BFu1c_BFs1s_BFs1ll  {
  signed short v1:1;
  unsigned char v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1s_BFs1ll) C1{ Fs:1 Fc:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1c_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1s_BFs1ll, BFs1s_BFu1c_BFs1s_BFs1ll)
//============================================================================


struct  BFs1s_BFu1c_BFs1s_BFs1s  {
  signed short v1:1;
  unsigned char v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1s_BFs1s) C1{ Fs:1 Fc:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1c_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFs1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1s_BFs1s, BFs1s_BFu1c_BFs1s_BFs1s)
//============================================================================


struct  BFs1s_BFu1c_BFs1s_BFu1c  {
  signed short v1:1;
  unsigned char v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1s_BFu1c) C1{ Fs:1 Fc:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1c_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFs1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1s_BFu1c, BFs1s_BFu1c_BFs1s_BFu1c)
//============================================================================


struct  BFs1s_BFu1c_BFs1s_BFu1i  {
  signed short v1:1;
  unsigned char v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1s_BFu1i) C1{ Fs:1 Fc:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1c_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1s_BFu1i, BFs1s_BFu1c_BFs1s_BFu1i)
//============================================================================


struct  BFs1s_BFu1c_BFs1s_BFu1ll  {
  signed short v1:1;
  unsigned char v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1s_BFu1ll) C1{ Fs:1 Fc:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1c_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1s_BFu1ll, BFs1s_BFu1c_BFs1s_BFu1ll)
//============================================================================


struct  BFs1s_BFu1c_BFs1s_BFu1s  {
  signed short v1:1;
  unsigned char v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFs1s_BFu1s) C1{ Fs:1 Fc:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1c_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFs1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFs1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFs1s_BFu1s, BFs1s_BFu1c_BFs1s_BFu1s)
//============================================================================


struct  BFs1s_BFu1c_BFu1c  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
};
//SIG(1 BFs1s_BFu1c_BFu1c) C1{ Fs:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1c, BFs1s_BFu1c_BFu1c)
//============================================================================


struct  BFs1s_BFu1c_BFu1c_BFs1c  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1c_BFs1c) C1{ Fs:1 Fc:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1c_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1c_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFu1c_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1c_BFs1c, BFs1s_BFu1c_BFu1c_BFs1c)
//============================================================================


struct  BFs1s_BFu1c_BFu1c_BFs1i  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1c_BFs1i) C1{ Fs:1 Fc:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1c_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1c_BFs1i, BFs1s_BFu1c_BFu1c_BFs1i)
//============================================================================


struct  BFs1s_BFu1c_BFu1c_BFs1ll  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1c_BFs1ll) C1{ Fs:1 Fc:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1c_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1c_BFs1ll, BFs1s_BFu1c_BFu1c_BFs1ll)
//============================================================================


struct  BFs1s_BFu1c_BFu1c_BFs1s  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1c_BFs1s) C1{ Fs:1 Fc:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1c_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFu1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1c_BFs1s, BFs1s_BFu1c_BFu1c_BFs1s)
//============================================================================


struct  BFs1s_BFu1c_BFu1c_BFu1c  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1c_BFu1c) C1{ Fs:1 Fc:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1c_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFu1c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1c_BFu1c, BFs1s_BFu1c_BFu1c_BFu1c)
//============================================================================


struct  BFs1s_BFu1c_BFu1c_BFu1i  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1c_BFu1i) C1{ Fs:1 Fc:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1c_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1c_BFu1i, BFs1s_BFu1c_BFu1c_BFu1i)
//============================================================================


struct  BFs1s_BFu1c_BFu1c_BFu1ll  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1c_BFu1ll) C1{ Fs:1 Fc:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1c_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1c_BFu1ll, BFs1s_BFu1c_BFu1c_BFu1ll)
//============================================================================


struct  BFs1s_BFu1c_BFu1c_BFu1s  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1c_BFu1s) C1{ Fs:1 Fc:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1c_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFu1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1c_BFu1s, BFs1s_BFu1c_BFu1c_BFu1s)
//============================================================================


struct  BFs1s_BFu1c_BFu1i  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1s_BFu1c_BFu1i) C1{ Fs:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1i, BFs1s_BFu1c_BFu1i)
//============================================================================


struct  BFs1s_BFu1c_BFu1i_BFs1c  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1i_BFs1c) C1{ Fs:1 Fc:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1c_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1i_BFs1c, BFs1s_BFu1c_BFu1i_BFs1c)
//============================================================================


struct  BFs1s_BFu1c_BFu1i_BFs1i  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1i_BFs1i) C1{ Fs:1 Fc:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1c_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1i_BFs1i, BFs1s_BFu1c_BFu1i_BFs1i)
//============================================================================


struct  BFs1s_BFu1c_BFu1i_BFs1ll  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1i_BFs1ll) C1{ Fs:1 Fc:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1c_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1i_BFs1ll, BFs1s_BFu1c_BFu1i_BFs1ll)
//============================================================================


struct  BFs1s_BFu1c_BFu1i_BFs1s  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1i_BFs1s) C1{ Fs:1 Fc:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1c_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1i_BFs1s, BFs1s_BFu1c_BFu1i_BFs1s)
//============================================================================


struct  BFs1s_BFu1c_BFu1i_BFu1c  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1i_BFu1c) C1{ Fs:1 Fc:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1c_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1i_BFu1c, BFs1s_BFu1c_BFu1i_BFu1c)
//============================================================================


struct  BFs1s_BFu1c_BFu1i_BFu1i  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1i_BFu1i) C1{ Fs:1 Fc:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1c_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1i_BFu1i, BFs1s_BFu1c_BFu1i_BFu1i)
//============================================================================


struct  BFs1s_BFu1c_BFu1i_BFu1ll  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1i_BFu1ll) C1{ Fs:1 Fc:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1c_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1i_BFu1ll, BFs1s_BFu1c_BFu1i_BFu1ll)
//============================================================================


struct  BFs1s_BFu1c_BFu1i_BFu1s  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1i_BFu1s) C1{ Fs:1 Fc:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1c_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1i_BFu1s, BFs1s_BFu1c_BFu1i_BFu1s)
//============================================================================


struct  BFs1s_BFu1c_BFu1ll  {
  signed short v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1s_BFu1c_BFu1ll) C1{ Fs:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1ll, BFs1s_BFu1c_BFu1ll)
//============================================================================


struct  BFs1s_BFu1c_BFu1ll_BFs1c  {
  signed short v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1ll_BFs1c) C1{ Fs:1 Fc:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1c_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1ll_BFs1c, BFs1s_BFu1c_BFu1ll_BFs1c)
//============================================================================


struct  BFs1s_BFu1c_BFu1ll_BFs1i  {
  signed short v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1ll_BFs1i) C1{ Fs:1 Fc:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1c_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1ll_BFs1i, BFs1s_BFu1c_BFu1ll_BFs1i)
//============================================================================


struct  BFs1s_BFu1c_BFu1ll_BFs1ll  {
  signed short v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1ll_BFs1ll) C1{ Fs:1 Fc:1 FL:1 FL:1}



static void Test_BFs1s_BFu1c_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1ll_BFs1ll, BFs1s_BFu1c_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFu1c_BFu1ll_BFs1s  {
  signed short v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1ll_BFs1s) C1{ Fs:1 Fc:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1c_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1ll_BFs1s, BFs1s_BFu1c_BFu1ll_BFs1s)
//============================================================================


struct  BFs1s_BFu1c_BFu1ll_BFu1c  {
  signed short v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1ll_BFu1c) C1{ Fs:1 Fc:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1c_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1ll_BFu1c, BFs1s_BFu1c_BFu1ll_BFu1c)
//============================================================================


struct  BFs1s_BFu1c_BFu1ll_BFu1i  {
  signed short v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1ll_BFu1i) C1{ Fs:1 Fc:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1c_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1ll_BFu1i, BFs1s_BFu1c_BFu1ll_BFu1i)
//============================================================================


struct  BFs1s_BFu1c_BFu1ll_BFu1ll  {
  signed short v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1ll_BFu1ll) C1{ Fs:1 Fc:1 FL:1 FL:1}



static void Test_BFs1s_BFu1c_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1ll_BFu1ll, BFs1s_BFu1c_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFu1c_BFu1ll_BFu1s  {
  signed short v1:1;
  unsigned char v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1ll_BFu1s) C1{ Fs:1 Fc:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1c_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1ll_BFu1s, BFs1s_BFu1c_BFu1ll_BFu1s)
//============================================================================


struct  BFs1s_BFu1c_BFu1s  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1s_BFu1c_BFu1s) C1{ Fs:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1s, BFs1s_BFu1c_BFu1s)
//============================================================================


struct  BFs1s_BFu1c_BFu1s_BFs1c  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1s_BFs1c) C1{ Fs:1 Fc:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1c_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFu1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1s_BFs1c, BFs1s_BFu1c_BFu1s_BFs1c)
//============================================================================


struct  BFs1s_BFu1c_BFu1s_BFs1i  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1s_BFs1i) C1{ Fs:1 Fc:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1c_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1s_BFs1i, BFs1s_BFu1c_BFu1s_BFs1i)
//============================================================================


struct  BFs1s_BFu1c_BFu1s_BFs1ll  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1s_BFs1ll) C1{ Fs:1 Fc:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1c_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1s_BFs1ll, BFs1s_BFu1c_BFu1s_BFs1ll)
//============================================================================


struct  BFs1s_BFu1c_BFu1s_BFs1s  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1s_BFs1s) C1{ Fs:1 Fc:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1c_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFu1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1c_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1s_BFs1s, BFs1s_BFu1c_BFu1s_BFs1s)
//============================================================================


struct  BFs1s_BFu1c_BFu1s_BFu1c  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1s_BFu1c) C1{ Fs:1 Fc:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1c_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFu1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1s_BFu1c, BFs1s_BFu1c_BFu1s_BFu1c)
//============================================================================


struct  BFs1s_BFu1c_BFu1s_BFu1i  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1s_BFu1i) C1{ Fs:1 Fc:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1c_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1c_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1c_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1s_BFu1i, BFs1s_BFu1c_BFu1s_BFu1i)
//============================================================================


struct  BFs1s_BFu1c_BFu1s_BFu1ll  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1s_BFu1ll) C1{ Fs:1 Fc:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1c_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1c_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1c_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1s_BFu1ll, BFs1s_BFu1c_BFu1s_BFu1ll)
//============================================================================


struct  BFs1s_BFu1c_BFu1s_BFu1s  {
  signed short v1:1;
  unsigned char v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1c_BFu1s_BFu1s) C1{ Fs:1 Fc:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1c_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1c_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1c_BFu1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1c_BFu1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1c_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1c_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1c_BFu1s_BFu1s, BFs1s_BFu1c_BFu1s_BFu1s)
//============================================================================


struct  BFs1s_BFu1i  {
  signed short v1:1;
  unsigned int v2:1;
};
//SIG(1 BFs1s_BFu1i) C1{ Fs:1 Fi:1}



static void Test_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i, BFs1s_BFu1i)
//============================================================================


struct  BFs1s_BFu1i_BFs1c  {
  signed short v1:1;
  unsigned int v2:1;
  signed char v3:1;
};
//SIG(1 BFs1s_BFu1i_BFs1c) C1{ Fs:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1c, BFs1s_BFu1i_BFs1c)
//============================================================================


struct  BFs1s_BFu1i_BFs1c_BFs1c  {
  signed short v1:1;
  unsigned int v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1c_BFs1c) C1{ Fs:1 Fi:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1i_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1c_BFs1c, BFs1s_BFu1i_BFs1c_BFs1c)
//============================================================================


struct  BFs1s_BFu1i_BFs1c_BFs1i  {
  signed short v1:1;
  unsigned int v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1c_BFs1i) C1{ Fs:1 Fi:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1i_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1c_BFs1i, BFs1s_BFu1i_BFs1c_BFs1i)
//============================================================================


struct  BFs1s_BFu1i_BFs1c_BFs1ll  {
  signed short v1:1;
  unsigned int v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1c_BFs1ll) C1{ Fs:1 Fi:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1i_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1c_BFs1ll, BFs1s_BFu1i_BFs1c_BFs1ll)
//============================================================================


struct  BFs1s_BFu1i_BFs1c_BFs1s  {
  signed short v1:1;
  unsigned int v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1c_BFs1s) C1{ Fs:1 Fi:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1i_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1c_BFs1s, BFs1s_BFu1i_BFs1c_BFs1s)
//============================================================================


struct  BFs1s_BFu1i_BFs1c_BFu1c  {
  signed short v1:1;
  unsigned int v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1c_BFu1c) C1{ Fs:1 Fi:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1i_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1c_BFu1c, BFs1s_BFu1i_BFs1c_BFu1c)
//============================================================================


struct  BFs1s_BFu1i_BFs1c_BFu1i  {
  signed short v1:1;
  unsigned int v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1c_BFu1i) C1{ Fs:1 Fi:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1i_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1c_BFu1i, BFs1s_BFu1i_BFs1c_BFu1i)
//============================================================================


struct  BFs1s_BFu1i_BFs1c_BFu1ll  {
  signed short v1:1;
  unsigned int v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1c_BFu1ll) C1{ Fs:1 Fi:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1i_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1c_BFu1ll, BFs1s_BFu1i_BFs1c_BFu1ll)
//============================================================================


struct  BFs1s_BFu1i_BFs1c_BFu1s  {
  signed short v1:1;
  unsigned int v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1c_BFu1s) C1{ Fs:1 Fi:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1i_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1c_BFu1s, BFs1s_BFu1i_BFs1c_BFu1s)
//============================================================================


struct  BFs1s_BFu1i_BFs1i  {
  signed short v1:1;
  unsigned int v2:1;
  signed int v3:1;
};
//SIG(1 BFs1s_BFu1i_BFs1i) C1{ Fs:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1i, BFs1s_BFu1i_BFs1i)
//============================================================================


struct  BFs1s_BFu1i_BFs1i_BFs1c  {
  signed short v1:1;
  unsigned int v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1i_BFs1c) C1{ Fs:1 Fi:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1i_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1i_BFs1c, BFs1s_BFu1i_BFs1i_BFs1c)
//============================================================================


struct  BFs1s_BFu1i_BFs1i_BFs1i  {
  signed short v1:1;
  unsigned int v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1i_BFs1i) C1{ Fs:1 Fi:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1i_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1i_BFs1i, BFs1s_BFu1i_BFs1i_BFs1i)
//============================================================================


struct  BFs1s_BFu1i_BFs1i_BFs1ll  {
  signed short v1:1;
  unsigned int v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1i_BFs1ll) C1{ Fs:1 Fi:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1i_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1i_BFs1ll, BFs1s_BFu1i_BFs1i_BFs1ll)
//============================================================================


struct  BFs1s_BFu1i_BFs1i_BFs1s  {
  signed short v1:1;
  unsigned int v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1i_BFs1s) C1{ Fs:1 Fi:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1i_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1i_BFs1s, BFs1s_BFu1i_BFs1i_BFs1s)
//============================================================================


struct  BFs1s_BFu1i_BFs1i_BFu1c  {
  signed short v1:1;
  unsigned int v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1i_BFu1c) C1{ Fs:1 Fi:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1i_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1i_BFu1c, BFs1s_BFu1i_BFs1i_BFu1c)
//============================================================================


struct  BFs1s_BFu1i_BFs1i_BFu1i  {
  signed short v1:1;
  unsigned int v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1i_BFu1i) C1{ Fs:1 Fi:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1i_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1i_BFu1i, BFs1s_BFu1i_BFs1i_BFu1i)
//============================================================================


struct  BFs1s_BFu1i_BFs1i_BFu1ll  {
  signed short v1:1;
  unsigned int v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1i_BFu1ll) C1{ Fs:1 Fi:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1i_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1i_BFu1ll, BFs1s_BFu1i_BFs1i_BFu1ll)
//============================================================================


struct  BFs1s_BFu1i_BFs1i_BFu1s  {
  signed short v1:1;
  unsigned int v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1i_BFu1s) C1{ Fs:1 Fi:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1i_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1i_BFu1s, BFs1s_BFu1i_BFs1i_BFu1s)
//============================================================================


struct  BFs1s_BFu1i_BFs1ll  {
  signed short v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFs1s_BFu1i_BFs1ll) C1{ Fs:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1ll, BFs1s_BFu1i_BFs1ll)
//============================================================================


struct  BFs1s_BFu1i_BFs1ll_BFs1c  {
  signed short v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1ll_BFs1c) C1{ Fs:1 Fi:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1i_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1ll_BFs1c, BFs1s_BFu1i_BFs1ll_BFs1c)
//============================================================================


struct  BFs1s_BFu1i_BFs1ll_BFs1i  {
  signed short v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1ll_BFs1i) C1{ Fs:1 Fi:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1i_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1ll_BFs1i, BFs1s_BFu1i_BFs1ll_BFs1i)
//============================================================================


struct  BFs1s_BFu1i_BFs1ll_BFs1ll  {
  signed short v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1ll_BFs1ll) C1{ Fs:1 Fi:1 FL:1 FL:1}



static void Test_BFs1s_BFu1i_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1ll_BFs1ll, BFs1s_BFu1i_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFu1i_BFs1ll_BFs1s  {
  signed short v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1ll_BFs1s) C1{ Fs:1 Fi:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1i_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1ll_BFs1s, BFs1s_BFu1i_BFs1ll_BFs1s)
//============================================================================


struct  BFs1s_BFu1i_BFs1ll_BFu1c  {
  signed short v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1ll_BFu1c) C1{ Fs:1 Fi:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1i_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1ll_BFu1c, BFs1s_BFu1i_BFs1ll_BFu1c)
//============================================================================


struct  BFs1s_BFu1i_BFs1ll_BFu1i  {
  signed short v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1ll_BFu1i) C1{ Fs:1 Fi:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1i_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1ll_BFu1i, BFs1s_BFu1i_BFs1ll_BFu1i)
//============================================================================


struct  BFs1s_BFu1i_BFs1ll_BFu1ll  {
  signed short v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1ll_BFu1ll) C1{ Fs:1 Fi:1 FL:1 FL:1}



static void Test_BFs1s_BFu1i_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1ll_BFu1ll, BFs1s_BFu1i_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFu1i_BFs1ll_BFu1s  {
  signed short v1:1;
  unsigned int v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1ll_BFu1s) C1{ Fs:1 Fi:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1i_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1ll_BFu1s, BFs1s_BFu1i_BFs1ll_BFu1s)
//============================================================================


struct  BFs1s_BFu1i_BFs1s  {
  signed short v1:1;
  unsigned int v2:1;
  signed short v3:1;
};
//SIG(1 BFs1s_BFu1i_BFs1s) C1{ Fs:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1s, BFs1s_BFu1i_BFs1s)
//============================================================================


struct  BFs1s_BFu1i_BFs1s_BFs1c  {
  signed short v1:1;
  unsigned int v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1s_BFs1c) C1{ Fs:1 Fi:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1i_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1s_BFs1c, BFs1s_BFu1i_BFs1s_BFs1c)
//============================================================================


struct  BFs1s_BFu1i_BFs1s_BFs1i  {
  signed short v1:1;
  unsigned int v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1s_BFs1i) C1{ Fs:1 Fi:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1i_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1s_BFs1i, BFs1s_BFu1i_BFs1s_BFs1i)
//============================================================================


struct  BFs1s_BFu1i_BFs1s_BFs1ll  {
  signed short v1:1;
  unsigned int v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1s_BFs1ll) C1{ Fs:1 Fi:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1i_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1s_BFs1ll, BFs1s_BFu1i_BFs1s_BFs1ll)
//============================================================================


struct  BFs1s_BFu1i_BFs1s_BFs1s  {
  signed short v1:1;
  unsigned int v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1s_BFs1s) C1{ Fs:1 Fi:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1i_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1s_BFs1s, BFs1s_BFu1i_BFs1s_BFs1s)
//============================================================================


struct  BFs1s_BFu1i_BFs1s_BFu1c  {
  signed short v1:1;
  unsigned int v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1s_BFu1c) C1{ Fs:1 Fi:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1i_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1s_BFu1c, BFs1s_BFu1i_BFs1s_BFu1c)
//============================================================================


struct  BFs1s_BFu1i_BFs1s_BFu1i  {
  signed short v1:1;
  unsigned int v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1s_BFu1i) C1{ Fs:1 Fi:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1i_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1s_BFu1i, BFs1s_BFu1i_BFs1s_BFu1i)
//============================================================================


struct  BFs1s_BFu1i_BFs1s_BFu1ll  {
  signed short v1:1;
  unsigned int v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1s_BFu1ll) C1{ Fs:1 Fi:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1i_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1s_BFu1ll, BFs1s_BFu1i_BFs1s_BFu1ll)
//============================================================================


struct  BFs1s_BFu1i_BFs1s_BFu1s  {
  signed short v1:1;
  unsigned int v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFs1s_BFu1s) C1{ Fs:1 Fi:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1i_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFs1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFs1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFs1s_BFu1s, BFs1s_BFu1i_BFs1s_BFu1s)
//============================================================================


struct  BFs1s_BFu1i_BFu1c  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
};
//SIG(1 BFs1s_BFu1i_BFu1c) C1{ Fs:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1c, BFs1s_BFu1i_BFu1c)
//============================================================================


struct  BFs1s_BFu1i_BFu1c_BFs1c  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1c_BFs1c) C1{ Fs:1 Fi:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1i_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1c_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1c_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1c_BFs1c, BFs1s_BFu1i_BFu1c_BFs1c)
//============================================================================


struct  BFs1s_BFu1i_BFu1c_BFs1i  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1c_BFs1i) C1{ Fs:1 Fi:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1i_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1c_BFs1i, BFs1s_BFu1i_BFu1c_BFs1i)
//============================================================================


struct  BFs1s_BFu1i_BFu1c_BFs1ll  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1c_BFs1ll) C1{ Fs:1 Fi:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1i_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1c_BFs1ll, BFs1s_BFu1i_BFu1c_BFs1ll)
//============================================================================


struct  BFs1s_BFu1i_BFu1c_BFs1s  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1c_BFs1s) C1{ Fs:1 Fi:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1i_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1c_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1c_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1c_BFs1s, BFs1s_BFu1i_BFu1c_BFs1s)
//============================================================================


struct  BFs1s_BFu1i_BFu1c_BFu1c  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1c_BFu1c) C1{ Fs:1 Fi:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1i_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1c_BFu1c, BFs1s_BFu1i_BFu1c_BFu1c)
//============================================================================


struct  BFs1s_BFu1i_BFu1c_BFu1i  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1c_BFu1i) C1{ Fs:1 Fi:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1i_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1c_BFu1i, BFs1s_BFu1i_BFu1c_BFu1i)
//============================================================================


struct  BFs1s_BFu1i_BFu1c_BFu1ll  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1c_BFu1ll) C1{ Fs:1 Fi:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1i_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1c_BFu1ll, BFs1s_BFu1i_BFu1c_BFu1ll)
//============================================================================


struct  BFs1s_BFu1i_BFu1c_BFu1s  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1c_BFu1s) C1{ Fs:1 Fi:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1i_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1c_BFu1s, BFs1s_BFu1i_BFu1c_BFu1s)
//============================================================================


struct  BFs1s_BFu1i_BFu1i  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1s_BFu1i_BFu1i) C1{ Fs:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1i, BFs1s_BFu1i_BFu1i)
//============================================================================


struct  BFs1s_BFu1i_BFu1i_BFs1c  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1i_BFs1c) C1{ Fs:1 Fi:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1i_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1i_BFs1c, BFs1s_BFu1i_BFu1i_BFs1c)
//============================================================================


struct  BFs1s_BFu1i_BFu1i_BFs1i  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1i_BFs1i) C1{ Fs:1 Fi:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1i_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1i_BFs1i, BFs1s_BFu1i_BFu1i_BFs1i)
//============================================================================


struct  BFs1s_BFu1i_BFu1i_BFs1ll  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1i_BFs1ll) C1{ Fs:1 Fi:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1i_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1i_BFs1ll, BFs1s_BFu1i_BFu1i_BFs1ll)
//============================================================================


struct  BFs1s_BFu1i_BFu1i_BFs1s  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1i_BFs1s) C1{ Fs:1 Fi:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1i_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1i_BFs1s, BFs1s_BFu1i_BFu1i_BFs1s)
//============================================================================


struct  BFs1s_BFu1i_BFu1i_BFu1c  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1i_BFu1c) C1{ Fs:1 Fi:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1i_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1i_BFu1c, BFs1s_BFu1i_BFu1i_BFu1c)
//============================================================================


struct  BFs1s_BFu1i_BFu1i_BFu1i  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1i_BFu1i) C1{ Fs:1 Fi:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1i_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1i_BFu1i, BFs1s_BFu1i_BFu1i_BFu1i)
//============================================================================


struct  BFs1s_BFu1i_BFu1i_BFu1ll  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1i_BFu1ll) C1{ Fs:1 Fi:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1i_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1i_BFu1ll, BFs1s_BFu1i_BFu1i_BFu1ll)
//============================================================================


struct  BFs1s_BFu1i_BFu1i_BFu1s  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1i_BFu1s) C1{ Fs:1 Fi:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1i_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1i_BFu1s, BFs1s_BFu1i_BFu1i_BFu1s)
//============================================================================


struct  BFs1s_BFu1i_BFu1ll  {
  signed short v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1s_BFu1i_BFu1ll) C1{ Fs:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1ll, BFs1s_BFu1i_BFu1ll)
//============================================================================


struct  BFs1s_BFu1i_BFu1ll_BFs1c  {
  signed short v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1ll_BFs1c) C1{ Fs:1 Fi:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1i_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1ll_BFs1c, BFs1s_BFu1i_BFu1ll_BFs1c)
//============================================================================


struct  BFs1s_BFu1i_BFu1ll_BFs1i  {
  signed short v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1ll_BFs1i) C1{ Fs:1 Fi:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1i_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1ll_BFs1i, BFs1s_BFu1i_BFu1ll_BFs1i)
//============================================================================


struct  BFs1s_BFu1i_BFu1ll_BFs1ll  {
  signed short v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1ll_BFs1ll) C1{ Fs:1 Fi:1 FL:1 FL:1}



static void Test_BFs1s_BFu1i_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1ll_BFs1ll, BFs1s_BFu1i_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFu1i_BFu1ll_BFs1s  {
  signed short v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1ll_BFs1s) C1{ Fs:1 Fi:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1i_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1ll_BFs1s, BFs1s_BFu1i_BFu1ll_BFs1s)
//============================================================================


struct  BFs1s_BFu1i_BFu1ll_BFu1c  {
  signed short v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1ll_BFu1c) C1{ Fs:1 Fi:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1i_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1ll_BFu1c, BFs1s_BFu1i_BFu1ll_BFu1c)
//============================================================================


struct  BFs1s_BFu1i_BFu1ll_BFu1i  {
  signed short v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1ll_BFu1i) C1{ Fs:1 Fi:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1i_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1ll_BFu1i, BFs1s_BFu1i_BFu1ll_BFu1i)
//============================================================================


struct  BFs1s_BFu1i_BFu1ll_BFu1ll  {
  signed short v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1ll_BFu1ll) C1{ Fs:1 Fi:1 FL:1 FL:1}



static void Test_BFs1s_BFu1i_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1ll_BFu1ll, BFs1s_BFu1i_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFu1i_BFu1ll_BFu1s  {
  signed short v1:1;
  unsigned int v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1ll_BFu1s) C1{ Fs:1 Fi:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1i_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1ll_BFu1s, BFs1s_BFu1i_BFu1ll_BFu1s)
//============================================================================


struct  BFs1s_BFu1i_BFu1s  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1s_BFu1i_BFu1s) C1{ Fs:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1s, BFs1s_BFu1i_BFu1s)
//============================================================================


struct  BFs1s_BFu1i_BFu1s_BFs1c  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1s_BFs1c) C1{ Fs:1 Fi:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1i_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1s_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1s_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1s_BFs1c, BFs1s_BFu1i_BFu1s_BFs1c)
//============================================================================


struct  BFs1s_BFu1i_BFu1s_BFs1i  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1s_BFs1i) C1{ Fs:1 Fi:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1i_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1s_BFs1i, BFs1s_BFu1i_BFu1s_BFs1i)
//============================================================================


struct  BFs1s_BFu1i_BFu1s_BFs1ll  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1s_BFs1ll) C1{ Fs:1 Fi:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1i_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1s_BFs1ll, BFs1s_BFu1i_BFu1s_BFs1ll)
//============================================================================


struct  BFs1s_BFu1i_BFu1s_BFs1s  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1s_BFs1s) C1{ Fs:1 Fi:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1i_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1s_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1s_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1i_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1s_BFs1s, BFs1s_BFu1i_BFu1s_BFs1s)
//============================================================================


struct  BFs1s_BFu1i_BFu1s_BFu1c  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1s_BFu1c) C1{ Fs:1 Fi:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1i_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1s_BFu1c, BFs1s_BFu1i_BFu1s_BFu1c)
//============================================================================


struct  BFs1s_BFu1i_BFu1s_BFu1i  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1s_BFu1i) C1{ Fs:1 Fi:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1i_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1s_BFu1i, BFs1s_BFu1i_BFu1s_BFu1i)
//============================================================================


struct  BFs1s_BFu1i_BFu1s_BFu1ll  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1s_BFu1ll) C1{ Fs:1 Fi:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1i_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1i_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1i_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1s_BFu1ll, BFs1s_BFu1i_BFu1s_BFu1ll)
//============================================================================


struct  BFs1s_BFu1i_BFu1s_BFu1s  {
  signed short v1:1;
  unsigned int v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1i_BFu1s_BFu1s) C1{ Fs:1 Fi:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1i_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1i_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1i_BFu1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1i_BFu1s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1i_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1i_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1i_BFu1s_BFu1s, BFs1s_BFu1i_BFu1s_BFu1s)
//============================================================================


struct  BFs1s_BFu1ll  {
  signed short v1:1;
  __tsu64 v2:1;
};
//SIG(1 BFs1s_BFu1ll) C1{ Fs:1 FL:1}



static void Test_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll, BFs1s_BFu1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFs1c  {
  signed short v1:1;
  __tsu64 v2:1;
  signed char v3:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1c) C1{ Fs:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1c, BFs1s_BFu1ll_BFs1c)
//============================================================================


struct  BFs1s_BFu1ll_BFs1c_BFs1c  {
  signed short v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1c_BFs1c) C1{ Fs:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1c_BFs1c, BFs1s_BFu1ll_BFs1c_BFs1c)
//============================================================================


struct  BFs1s_BFu1ll_BFs1c_BFs1i  {
  signed short v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1c_BFs1i) C1{ Fs:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1c_BFs1i, BFs1s_BFu1ll_BFs1c_BFs1i)
//============================================================================


struct  BFs1s_BFu1ll_BFs1c_BFs1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1c_BFs1ll) C1{ Fs:1 FL:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1ll_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1c_BFs1ll, BFs1s_BFu1ll_BFs1c_BFs1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFs1c_BFs1s  {
  signed short v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1c_BFs1s) C1{ Fs:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1c_BFs1s, BFs1s_BFu1ll_BFs1c_BFs1s)
//============================================================================


struct  BFs1s_BFu1ll_BFs1c_BFu1c  {
  signed short v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1c_BFu1c) C1{ Fs:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1c_BFu1c, BFs1s_BFu1ll_BFs1c_BFu1c)
//============================================================================


struct  BFs1s_BFu1ll_BFs1c_BFu1i  {
  signed short v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1c_BFu1i) C1{ Fs:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1c_BFu1i, BFs1s_BFu1ll_BFs1c_BFu1i)
//============================================================================


struct  BFs1s_BFu1ll_BFs1c_BFu1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1c_BFu1ll) C1{ Fs:1 FL:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1ll_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1c_BFu1ll, BFs1s_BFu1ll_BFs1c_BFu1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFs1c_BFu1s  {
  signed short v1:1;
  __tsu64 v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1c_BFu1s) C1{ Fs:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1c_BFu1s, BFs1s_BFu1ll_BFs1c_BFu1s)
//============================================================================


struct  BFs1s_BFu1ll_BFs1i  {
  signed short v1:1;
  __tsu64 v2:1;
  signed int v3:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1i) C1{ Fs:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1i, BFs1s_BFu1ll_BFs1i)
//============================================================================


struct  BFs1s_BFu1ll_BFs1i_BFs1c  {
  signed short v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1i_BFs1c) C1{ Fs:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1i_BFs1c, BFs1s_BFu1ll_BFs1i_BFs1c)
//============================================================================


struct  BFs1s_BFu1ll_BFs1i_BFs1i  {
  signed short v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1i_BFs1i) C1{ Fs:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1i_BFs1i, BFs1s_BFu1ll_BFs1i_BFs1i)
//============================================================================


struct  BFs1s_BFu1ll_BFs1i_BFs1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1i_BFs1ll) C1{ Fs:1 FL:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1ll_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1i_BFs1ll, BFs1s_BFu1ll_BFs1i_BFs1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFs1i_BFs1s  {
  signed short v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1i_BFs1s) C1{ Fs:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1i_BFs1s, BFs1s_BFu1ll_BFs1i_BFs1s)
//============================================================================


struct  BFs1s_BFu1ll_BFs1i_BFu1c  {
  signed short v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1i_BFu1c) C1{ Fs:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1i_BFu1c, BFs1s_BFu1ll_BFs1i_BFu1c)
//============================================================================


struct  BFs1s_BFu1ll_BFs1i_BFu1i  {
  signed short v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1i_BFu1i) C1{ Fs:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1i_BFu1i, BFs1s_BFu1ll_BFs1i_BFu1i)
//============================================================================


struct  BFs1s_BFu1ll_BFs1i_BFu1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1i_BFu1ll) C1{ Fs:1 FL:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1ll_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1i_BFu1ll, BFs1s_BFu1ll_BFs1i_BFu1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFs1i_BFu1s  {
  signed short v1:1;
  __tsu64 v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1i_BFu1s) C1{ Fs:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1i_BFu1s, BFs1s_BFu1ll_BFs1i_BFu1s)
//============================================================================


struct  BFs1s_BFu1ll_BFs1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1ll) C1{ Fs:1 FL:1 FL:1}



static void Test_BFs1s_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1ll, BFs1s_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFs1ll_BFs1c  {
  signed short v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1ll_BFs1c) C1{ Fs:1 FL:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1ll_BFs1c, BFs1s_BFu1ll_BFs1ll_BFs1c)
//============================================================================


struct  BFs1s_BFu1ll_BFs1ll_BFs1i  {
  signed short v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1ll_BFs1i) C1{ Fs:1 FL:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1ll_BFs1i, BFs1s_BFu1ll_BFs1ll_BFs1i)
//============================================================================


struct  BFs1s_BFu1ll_BFs1ll_BFs1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1ll_BFs1ll) C1{ Fs:1 FL:1 FL:1 FL:1}



static void Test_BFs1s_BFu1ll_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1ll_BFs1ll, BFs1s_BFu1ll_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFs1ll_BFs1s  {
  signed short v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1ll_BFs1s) C1{ Fs:1 FL:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1ll_BFs1s, BFs1s_BFu1ll_BFs1ll_BFs1s)
//============================================================================


struct  BFs1s_BFu1ll_BFs1ll_BFu1c  {
  signed short v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1ll_BFu1c) C1{ Fs:1 FL:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1ll_BFu1c, BFs1s_BFu1ll_BFs1ll_BFu1c)
//============================================================================


struct  BFs1s_BFu1ll_BFs1ll_BFu1i  {
  signed short v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1ll_BFu1i) C1{ Fs:1 FL:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1ll_BFu1i, BFs1s_BFu1ll_BFs1ll_BFu1i)
//============================================================================


struct  BFs1s_BFu1ll_BFs1ll_BFu1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1ll_BFu1ll) C1{ Fs:1 FL:1 FL:1 FL:1}



static void Test_BFs1s_BFu1ll_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1ll_BFu1ll, BFs1s_BFu1ll_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFs1ll_BFu1s  {
  signed short v1:1;
  __tsu64 v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1ll_BFu1s) C1{ Fs:1 FL:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1ll_BFu1s, BFs1s_BFu1ll_BFs1ll_BFu1s)
//============================================================================


struct  BFs1s_BFu1ll_BFs1s  {
  signed short v1:1;
  __tsu64 v2:1;
  signed short v3:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1s) C1{ Fs:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1s, BFs1s_BFu1ll_BFs1s)
//============================================================================


struct  BFs1s_BFu1ll_BFs1s_BFs1c  {
  signed short v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1s_BFs1c) C1{ Fs:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1s_BFs1c, BFs1s_BFu1ll_BFs1s_BFs1c)
//============================================================================


struct  BFs1s_BFu1ll_BFs1s_BFs1i  {
  signed short v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1s_BFs1i) C1{ Fs:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1s_BFs1i, BFs1s_BFu1ll_BFs1s_BFs1i)
//============================================================================


struct  BFs1s_BFu1ll_BFs1s_BFs1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1s_BFs1ll) C1{ Fs:1 FL:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1ll_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1s_BFs1ll, BFs1s_BFu1ll_BFs1s_BFs1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFs1s_BFs1s  {
  signed short v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1s_BFs1s) C1{ Fs:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1s_BFs1s, BFs1s_BFu1ll_BFs1s_BFs1s)
//============================================================================


struct  BFs1s_BFu1ll_BFs1s_BFu1c  {
  signed short v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1s_BFu1c) C1{ Fs:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1s_BFu1c, BFs1s_BFu1ll_BFs1s_BFu1c)
//============================================================================


struct  BFs1s_BFu1ll_BFs1s_BFu1i  {
  signed short v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1s_BFu1i) C1{ Fs:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1s_BFu1i, BFs1s_BFu1ll_BFs1s_BFu1i)
//============================================================================


struct  BFs1s_BFu1ll_BFs1s_BFu1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1s_BFu1ll) C1{ Fs:1 FL:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1ll_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1s_BFu1ll, BFs1s_BFu1ll_BFs1s_BFu1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFs1s_BFu1s  {
  signed short v1:1;
  __tsu64 v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFs1s_BFu1s) C1{ Fs:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFs1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFs1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFs1s_BFu1s, BFs1s_BFu1ll_BFs1s_BFu1s)
//============================================================================


struct  BFs1s_BFu1ll_BFu1c  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1c) C1{ Fs:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1c, BFs1s_BFu1ll_BFu1c)
//============================================================================


struct  BFs1s_BFu1ll_BFu1c_BFs1c  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1c_BFs1c) C1{ Fs:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1c_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1c_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1c_BFs1c, BFs1s_BFu1ll_BFu1c_BFs1c)
//============================================================================


struct  BFs1s_BFu1ll_BFu1c_BFs1i  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1c_BFs1i) C1{ Fs:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1c_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1c_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1c_BFs1i, BFs1s_BFu1ll_BFu1c_BFs1i)
//============================================================================


struct  BFs1s_BFu1ll_BFu1c_BFs1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1c_BFs1ll) C1{ Fs:1 FL:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1ll_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1c_BFs1ll, BFs1s_BFu1ll_BFu1c_BFs1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFu1c_BFs1s  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1c_BFs1s) C1{ Fs:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1c_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1c_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1c_BFs1s, BFs1s_BFu1ll_BFu1c_BFs1s)
//============================================================================


struct  BFs1s_BFu1ll_BFu1c_BFu1c  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1c_BFu1c) C1{ Fs:1 FL:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1c_BFu1c, BFs1s_BFu1ll_BFu1c_BFu1c)
//============================================================================


struct  BFs1s_BFu1ll_BFu1c_BFu1i  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1c_BFu1i) C1{ Fs:1 FL:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1c_BFu1i, BFs1s_BFu1ll_BFu1c_BFu1i)
//============================================================================


struct  BFs1s_BFu1ll_BFu1c_BFu1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1c_BFu1ll) C1{ Fs:1 FL:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1ll_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1c_BFu1ll, BFs1s_BFu1ll_BFu1c_BFu1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFu1c_BFu1s  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1c_BFu1s) C1{ Fs:1 FL:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1c_BFu1s, BFs1s_BFu1ll_BFu1c_BFu1s)
//============================================================================


struct  BFs1s_BFu1ll_BFu1i  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1i) C1{ Fs:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1i, BFs1s_BFu1ll_BFu1i)
//============================================================================


struct  BFs1s_BFu1ll_BFu1i_BFs1c  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1i_BFs1c) C1{ Fs:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1i_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1i_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1i_BFs1c, BFs1s_BFu1ll_BFu1i_BFs1c)
//============================================================================


struct  BFs1s_BFu1ll_BFu1i_BFs1i  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1i_BFs1i) C1{ Fs:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1i_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1i_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1i_BFs1i, BFs1s_BFu1ll_BFu1i_BFs1i)
//============================================================================


struct  BFs1s_BFu1ll_BFu1i_BFs1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1i_BFs1ll) C1{ Fs:1 FL:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1ll_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1i_BFs1ll, BFs1s_BFu1ll_BFu1i_BFs1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFu1i_BFs1s  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1i_BFs1s) C1{ Fs:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1i_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1i_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1i_BFs1s, BFs1s_BFu1ll_BFu1i_BFs1s)
//============================================================================


struct  BFs1s_BFu1ll_BFu1i_BFu1c  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1i_BFu1c) C1{ Fs:1 FL:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1i_BFu1c, BFs1s_BFu1ll_BFu1i_BFu1c)
//============================================================================


struct  BFs1s_BFu1ll_BFu1i_BFu1i  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1i_BFu1i) C1{ Fs:1 FL:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1i_BFu1i, BFs1s_BFu1ll_BFu1i_BFu1i)
//============================================================================


struct  BFs1s_BFu1ll_BFu1i_BFu1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1i_BFu1ll) C1{ Fs:1 FL:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1ll_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1i_BFu1ll, BFs1s_BFu1ll_BFu1i_BFu1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFu1i_BFu1s  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1i_BFu1s) C1{ Fs:1 FL:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1i_BFu1s, BFs1s_BFu1ll_BFu1i_BFu1s)
//============================================================================


struct  BFs1s_BFu1ll_BFu1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1ll) C1{ Fs:1 FL:1 FL:1}



static void Test_BFs1s_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1ll, BFs1s_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFu1ll_BFs1c  {
  signed short v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1ll_BFs1c) C1{ Fs:1 FL:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1ll_BFs1c, BFs1s_BFu1ll_BFu1ll_BFs1c)
//============================================================================


struct  BFs1s_BFu1ll_BFu1ll_BFs1i  {
  signed short v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1ll_BFs1i) C1{ Fs:1 FL:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1ll_BFs1i, BFs1s_BFu1ll_BFu1ll_BFs1i)
//============================================================================


struct  BFs1s_BFu1ll_BFu1ll_BFs1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1ll_BFs1ll) C1{ Fs:1 FL:1 FL:1 FL:1}



static void Test_BFs1s_BFu1ll_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1ll_BFs1ll, BFs1s_BFu1ll_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFu1ll_BFs1s  {
  signed short v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1ll_BFs1s) C1{ Fs:1 FL:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1ll_BFs1s, BFs1s_BFu1ll_BFu1ll_BFs1s)
//============================================================================


struct  BFs1s_BFu1ll_BFu1ll_BFu1c  {
  signed short v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1ll_BFu1c) C1{ Fs:1 FL:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1ll_BFu1c, BFs1s_BFu1ll_BFu1ll_BFu1c)
//============================================================================


struct  BFs1s_BFu1ll_BFu1ll_BFu1i  {
  signed short v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1ll_BFu1i) C1{ Fs:1 FL:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1ll_BFu1i, BFs1s_BFu1ll_BFu1ll_BFu1i)
//============================================================================


struct  BFs1s_BFu1ll_BFu1ll_BFu1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1ll_BFu1ll) C1{ Fs:1 FL:1 FL:1 FL:1}



static void Test_BFs1s_BFu1ll_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1ll_BFu1ll, BFs1s_BFu1ll_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFu1ll_BFu1s  {
  signed short v1:1;
  __tsu64 v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1ll_BFu1s) C1{ Fs:1 FL:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1ll_BFu1s, BFs1s_BFu1ll_BFu1ll_BFu1s)
//============================================================================


struct  BFs1s_BFu1ll_BFu1s  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1s) C1{ Fs:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1s, BFs1s_BFu1ll_BFu1s)
//============================================================================


struct  BFs1s_BFu1ll_BFu1s_BFs1c  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1s_BFs1c) C1{ Fs:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1s_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1s_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1s_BFs1c, BFs1s_BFu1ll_BFu1s_BFs1c)
//============================================================================


struct  BFs1s_BFu1ll_BFu1s_BFs1i  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1s_BFs1i) C1{ Fs:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1s_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1s_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1s_BFs1i, BFs1s_BFu1ll_BFu1s_BFs1i)
//============================================================================


struct  BFs1s_BFu1ll_BFu1s_BFs1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1s_BFs1ll) C1{ Fs:1 FL:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1ll_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1s_BFs1ll, BFs1s_BFu1ll_BFu1s_BFs1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFu1s_BFs1s  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1s_BFs1s) C1{ Fs:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1s_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1s_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1ll_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1s_BFs1s, BFs1s_BFu1ll_BFu1s_BFs1s)
//============================================================================


struct  BFs1s_BFu1ll_BFu1s_BFu1c  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1s_BFu1c) C1{ Fs:1 FL:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1ll_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1s_BFu1c, BFs1s_BFu1ll_BFu1s_BFu1c)
//============================================================================


struct  BFs1s_BFu1ll_BFu1s_BFu1i  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1s_BFu1i) C1{ Fs:1 FL:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1ll_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1s_BFu1i, BFs1s_BFu1ll_BFu1s_BFu1i)
//============================================================================


struct  BFs1s_BFu1ll_BFu1s_BFu1ll  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1s_BFu1ll) C1{ Fs:1 FL:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1ll_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1s_BFu1ll, BFs1s_BFu1ll_BFu1s_BFu1ll)
//============================================================================


struct  BFs1s_BFu1ll_BFu1s_BFu1s  {
  signed short v1:1;
  __tsu64 v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1ll_BFu1s_BFu1s) C1{ Fs:1 FL:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1ll_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1ll_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1ll_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1ll_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1ll_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1ll_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1ll_BFu1s_BFu1s, BFs1s_BFu1ll_BFu1s_BFu1s)
//============================================================================


struct  BFs1s_BFu1s  {
  signed short v1:1;
  unsigned short v2:1;
};
//SIG(1 BFs1s_BFu1s) C1{ Fs:1 Fs:1}



static void Test_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s, BFs1s_BFu1s)
//============================================================================


struct  BFs1s_BFu1s_BFs1c  {
  signed short v1:1;
  unsigned short v2:1;
  signed char v3:1;
};
//SIG(1 BFs1s_BFu1s_BFs1c) C1{ Fs:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1c, BFs1s_BFu1s_BFs1c)
//============================================================================


struct  BFs1s_BFu1s_BFs1c_BFs1c  {
  signed short v1:1;
  unsigned short v2:1;
  signed char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1c_BFs1c) C1{ Fs:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1s_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1c_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFs1c_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1c_BFs1c, BFs1s_BFu1s_BFs1c_BFs1c)
//============================================================================


struct  BFs1s_BFu1s_BFs1c_BFs1i  {
  signed short v1:1;
  unsigned short v2:1;
  signed char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1c_BFs1i) C1{ Fs:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1s_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFs1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1c_BFs1i, BFs1s_BFu1s_BFs1c_BFs1i)
//============================================================================


struct  BFs1s_BFu1s_BFs1c_BFs1ll  {
  signed short v1:1;
  unsigned short v2:1;
  signed char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1c_BFs1ll) C1{ Fs:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1s_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1c_BFs1ll, BFs1s_BFu1s_BFs1c_BFs1ll)
//============================================================================


struct  BFs1s_BFu1s_BFs1c_BFs1s  {
  signed short v1:1;
  unsigned short v2:1;
  signed char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1c_BFs1s) C1{ Fs:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1s_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFs1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1c_BFs1s, BFs1s_BFu1s_BFs1c_BFs1s)
//============================================================================


struct  BFs1s_BFu1s_BFs1c_BFu1c  {
  signed short v1:1;
  unsigned short v2:1;
  signed char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1c_BFu1c) C1{ Fs:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1s_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFs1c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1c_BFu1c, BFs1s_BFu1s_BFs1c_BFu1c)
//============================================================================


struct  BFs1s_BFu1s_BFs1c_BFu1i  {
  signed short v1:1;
  unsigned short v2:1;
  signed char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1c_BFu1i) C1{ Fs:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1s_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFs1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1c_BFu1i, BFs1s_BFu1s_BFs1c_BFu1i)
//============================================================================


struct  BFs1s_BFu1s_BFs1c_BFu1ll  {
  signed short v1:1;
  unsigned short v2:1;
  signed char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1c_BFu1ll) C1{ Fs:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1s_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1c_BFu1ll, BFs1s_BFu1s_BFs1c_BFu1ll)
//============================================================================


struct  BFs1s_BFu1s_BFs1c_BFu1s  {
  signed short v1:1;
  unsigned short v2:1;
  signed char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1c_BFu1s) C1{ Fs:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1s_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFs1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1c_BFu1s, BFs1s_BFu1s_BFs1c_BFu1s)
//============================================================================


struct  BFs1s_BFu1s_BFs1i  {
  signed short v1:1;
  unsigned short v2:1;
  signed int v3:1;
};
//SIG(1 BFs1s_BFu1s_BFs1i) C1{ Fs:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1i, BFs1s_BFu1s_BFs1i)
//============================================================================


struct  BFs1s_BFu1s_BFs1i_BFs1c  {
  signed short v1:1;
  unsigned short v2:1;
  signed int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1i_BFs1c) C1{ Fs:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1s_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFs1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1i_BFs1c, BFs1s_BFu1s_BFs1i_BFs1c)
//============================================================================


struct  BFs1s_BFu1s_BFs1i_BFs1i  {
  signed short v1:1;
  unsigned short v2:1;
  signed int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1i_BFs1i) C1{ Fs:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1s_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFs1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1i_BFs1i, BFs1s_BFu1s_BFs1i_BFs1i)
//============================================================================


struct  BFs1s_BFu1s_BFs1i_BFs1ll  {
  signed short v1:1;
  unsigned short v2:1;
  signed int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1i_BFs1ll) C1{ Fs:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1s_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1i_BFs1ll, BFs1s_BFu1s_BFs1i_BFs1ll)
//============================================================================


struct  BFs1s_BFu1s_BFs1i_BFs1s  {
  signed short v1:1;
  unsigned short v2:1;
  signed int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1i_BFs1s) C1{ Fs:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1s_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFs1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1i_BFs1s, BFs1s_BFu1s_BFs1i_BFs1s)
//============================================================================


struct  BFs1s_BFu1s_BFs1i_BFu1c  {
  signed short v1:1;
  unsigned short v2:1;
  signed int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1i_BFu1c) C1{ Fs:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1s_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFs1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1i_BFu1c, BFs1s_BFu1s_BFs1i_BFu1c)
//============================================================================


struct  BFs1s_BFu1s_BFs1i_BFu1i  {
  signed short v1:1;
  unsigned short v2:1;
  signed int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1i_BFu1i) C1{ Fs:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1s_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFs1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1i_BFu1i, BFs1s_BFu1s_BFs1i_BFu1i)
//============================================================================


struct  BFs1s_BFu1s_BFs1i_BFu1ll  {
  signed short v1:1;
  unsigned short v2:1;
  signed int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1i_BFu1ll) C1{ Fs:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1s_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1i_BFu1ll, BFs1s_BFu1s_BFs1i_BFu1ll)
//============================================================================


struct  BFs1s_BFu1s_BFs1i_BFu1s  {
  signed short v1:1;
  unsigned short v2:1;
  signed int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1i_BFu1s) C1{ Fs:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1s_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFs1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1i_BFu1s, BFs1s_BFu1s_BFs1i_BFu1s)
//============================================================================


struct  BFs1s_BFu1s_BFs1ll  {
  signed short v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
};
//SIG(1 BFs1s_BFu1s_BFs1ll) C1{ Fs:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1ll, BFs1s_BFu1s_BFs1ll)
//============================================================================


struct  BFs1s_BFu1s_BFs1ll_BFs1c  {
  signed short v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1ll_BFs1c) C1{ Fs:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1s_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1ll_BFs1c, BFs1s_BFu1s_BFs1ll_BFs1c)
//============================================================================


struct  BFs1s_BFu1s_BFs1ll_BFs1i  {
  signed short v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1ll_BFs1i) C1{ Fs:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1s_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1ll_BFs1i, BFs1s_BFu1s_BFs1ll_BFs1i)
//============================================================================


struct  BFs1s_BFu1s_BFs1ll_BFs1ll  {
  signed short v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1ll_BFs1ll) C1{ Fs:1 Fs:1 FL:1 FL:1}



static void Test_BFs1s_BFu1s_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1ll_BFs1ll, BFs1s_BFu1s_BFs1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFu1s_BFs1ll_BFs1s  {
  signed short v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1ll_BFs1s) C1{ Fs:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1s_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1ll_BFs1s, BFs1s_BFu1s_BFs1ll_BFs1s)
//============================================================================


struct  BFs1s_BFu1s_BFs1ll_BFu1c  {
  signed short v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1ll_BFu1c) C1{ Fs:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1s_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1ll_BFu1c, BFs1s_BFu1s_BFs1ll_BFu1c)
//============================================================================


struct  BFs1s_BFu1s_BFs1ll_BFu1i  {
  signed short v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1ll_BFu1i) C1{ Fs:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1s_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1ll_BFu1i, BFs1s_BFu1s_BFs1ll_BFu1i)
//============================================================================


struct  BFs1s_BFu1s_BFs1ll_BFu1ll  {
  signed short v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1ll_BFu1ll) C1{ Fs:1 Fs:1 FL:1 FL:1}



static void Test_BFs1s_BFu1s_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1ll_BFu1ll, BFs1s_BFu1s_BFs1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFu1s_BFs1ll_BFu1s  {
  signed short v1:1;
  unsigned short v2:1;
  signed __tsi64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1ll_BFu1s) C1{ Fs:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1s_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1ll_BFu1s, BFs1s_BFu1s_BFs1ll_BFu1s)
//============================================================================


struct  BFs1s_BFu1s_BFs1s  {
  signed short v1:1;
  unsigned short v2:1;
  signed short v3:1;
};
//SIG(1 BFs1s_BFu1s_BFs1s) C1{ Fs:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1s, BFs1s_BFu1s_BFs1s)
//============================================================================


struct  BFs1s_BFu1s_BFs1s_BFs1c  {
  signed short v1:1;
  unsigned short v2:1;
  signed short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1s_BFs1c) C1{ Fs:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1s_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFs1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1s_BFs1c, BFs1s_BFu1s_BFs1s_BFs1c)
//============================================================================


struct  BFs1s_BFu1s_BFs1s_BFs1i  {
  signed short v1:1;
  unsigned short v2:1;
  signed short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1s_BFs1i) C1{ Fs:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1s_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFs1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1s_BFs1i, BFs1s_BFu1s_BFs1s_BFs1i)
//============================================================================


struct  BFs1s_BFu1s_BFs1s_BFs1ll  {
  signed short v1:1;
  unsigned short v2:1;
  signed short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1s_BFs1ll) C1{ Fs:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1s_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1s_BFs1ll, BFs1s_BFu1s_BFs1s_BFs1ll)
//============================================================================


struct  BFs1s_BFu1s_BFs1s_BFs1s  {
  signed short v1:1;
  unsigned short v2:1;
  signed short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1s_BFs1s) C1{ Fs:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1s_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFs1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1s_BFs1s, BFs1s_BFu1s_BFs1s_BFs1s)
//============================================================================


struct  BFs1s_BFu1s_BFs1s_BFu1c  {
  signed short v1:1;
  unsigned short v2:1;
  signed short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1s_BFu1c) C1{ Fs:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1s_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFs1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1s_BFu1c, BFs1s_BFu1s_BFs1s_BFu1c)
//============================================================================


struct  BFs1s_BFu1s_BFs1s_BFu1i  {
  signed short v1:1;
  unsigned short v2:1;
  signed short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1s_BFu1i) C1{ Fs:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1s_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFs1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1s_BFu1i, BFs1s_BFu1s_BFs1s_BFu1i)
//============================================================================


struct  BFs1s_BFu1s_BFs1s_BFu1ll  {
  signed short v1:1;
  unsigned short v2:1;
  signed short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1s_BFu1ll) C1{ Fs:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1s_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFs1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1s_BFu1ll, BFs1s_BFu1s_BFs1s_BFu1ll)
//============================================================================


struct  BFs1s_BFu1s_BFs1s_BFu1s  {
  signed short v1:1;
  unsigned short v2:1;
  signed short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFs1s_BFu1s) C1{ Fs:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1s_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFs1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFs1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1s_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFs1s_BFu1s, BFs1s_BFu1s_BFs1s_BFu1s)
//============================================================================


struct  BFs1s_BFu1s_BFu1c  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
};
//SIG(1 BFs1s_BFu1s_BFu1c) C1{ Fs:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1c, BFs1s_BFu1s_BFu1c)
//============================================================================


struct  BFs1s_BFu1s_BFu1c_BFs1c  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1c_BFs1c) C1{ Fs:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1s_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1c_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFu1c_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1c_BFs1c, BFs1s_BFu1s_BFu1c_BFs1c)
//============================================================================


struct  BFs1s_BFu1s_BFu1c_BFs1i  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1c_BFs1i) C1{ Fs:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1s_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1c_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFu1c_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1c_BFs1i, BFs1s_BFu1s_BFu1c_BFs1i)
//============================================================================


struct  BFs1s_BFu1s_BFu1c_BFs1ll  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1c_BFs1ll) C1{ Fs:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1s_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1c_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1c_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1c_BFs1ll, BFs1s_BFu1s_BFu1c_BFs1ll)
//============================================================================


struct  BFs1s_BFu1s_BFu1c_BFs1s  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1c_BFs1s) C1{ Fs:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1s_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1c_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFu1c_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1c_BFs1s, BFs1s_BFu1s_BFu1c_BFs1s)
//============================================================================


struct  BFs1s_BFu1s_BFu1c_BFu1c  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1c_BFu1c) C1{ Fs:1 Fs:1 Fc:1 Fc:1}



static void Test_BFs1s_BFu1s_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFu1c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1c_BFu1c, BFs1s_BFu1s_BFu1c_BFu1c)
//============================================================================


struct  BFs1s_BFu1s_BFu1c_BFu1i  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1c_BFu1i) C1{ Fs:1 Fs:1 Fc:1 Fi:1}



static void Test_BFs1s_BFu1s_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1c_BFu1i, BFs1s_BFu1s_BFu1c_BFu1i)
//============================================================================


struct  BFs1s_BFu1s_BFu1c_BFu1ll  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1c_BFu1ll) C1{ Fs:1 Fs:1 Fc:1 FL:1}



static void Test_BFs1s_BFu1s_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1c_BFu1ll, BFs1s_BFu1s_BFu1c_BFu1ll)
//============================================================================


struct  BFs1s_BFu1s_BFu1c_BFu1s  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned char v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1c_BFu1s) C1{ Fs:1 Fs:1 Fc:1 Fs:1}



static void Test_BFs1s_BFu1s_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFu1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1c_BFu1s, BFs1s_BFu1s_BFu1c_BFu1s)
//============================================================================


struct  BFs1s_BFu1s_BFu1i  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
};
//SIG(1 BFs1s_BFu1s_BFu1i) C1{ Fs:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1i, BFs1s_BFu1s_BFu1i)
//============================================================================


struct  BFs1s_BFu1s_BFu1i_BFs1c  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1i_BFs1c) C1{ Fs:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1s_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1i_BFs1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFu1i_BFs1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1i_BFs1c, BFs1s_BFu1s_BFu1i_BFs1c)
//============================================================================


struct  BFs1s_BFu1s_BFu1i_BFs1i  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1i_BFs1i) C1{ Fs:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1s_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1i_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFu1i_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1i_BFs1i, BFs1s_BFu1s_BFu1i_BFs1i)
//============================================================================


struct  BFs1s_BFu1s_BFu1i_BFs1ll  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1i_BFs1ll) C1{ Fs:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1s_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1i_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1i_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1i_BFs1ll, BFs1s_BFu1s_BFu1i_BFs1ll)
//============================================================================


struct  BFs1s_BFu1s_BFu1i_BFs1s  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1i_BFs1s) C1{ Fs:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1s_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1i_BFs1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFu1i_BFs1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1i_BFs1s, BFs1s_BFu1s_BFu1i_BFs1s)
//============================================================================


struct  BFs1s_BFu1s_BFu1i_BFu1c  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1i_BFu1c) C1{ Fs:1 Fs:1 Fi:1 Fc:1}



static void Test_BFs1s_BFu1s_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1i_BFu1c, BFs1s_BFu1s_BFu1i_BFu1c)
//============================================================================


struct  BFs1s_BFu1s_BFu1i_BFu1i  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1i_BFu1i) C1{ Fs:1 Fs:1 Fi:1 Fi:1}



static void Test_BFs1s_BFu1s_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1i_BFu1i, BFs1s_BFu1s_BFu1i_BFu1i)
//============================================================================


struct  BFs1s_BFu1s_BFu1i_BFu1ll  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1i_BFu1ll) C1{ Fs:1 Fs:1 Fi:1 FL:1}



static void Test_BFs1s_BFu1s_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1i_BFu1ll, BFs1s_BFu1s_BFu1i_BFu1ll)
//============================================================================


struct  BFs1s_BFu1s_BFu1i_BFu1s  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned int v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1i_BFu1s) C1{ Fs:1 Fs:1 Fi:1 Fs:1}



static void Test_BFs1s_BFu1s_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1i_BFu1s, BFs1s_BFu1s_BFu1i_BFu1s)
//============================================================================


struct  BFs1s_BFu1s_BFu1ll  {
  signed short v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
};
//SIG(1 BFs1s_BFu1s_BFu1ll) C1{ Fs:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1ll, BFs1s_BFu1s_BFu1ll)
//============================================================================


struct  BFs1s_BFu1s_BFu1ll_BFs1c  {
  signed short v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1ll_BFs1c) C1{ Fs:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1s_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1ll_BFs1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1ll_BFs1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1ll_BFs1c, BFs1s_BFu1s_BFu1ll_BFs1c)
//============================================================================


struct  BFs1s_BFu1s_BFu1ll_BFs1i  {
  signed short v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1ll_BFs1i) C1{ Fs:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1s_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1ll_BFs1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1ll_BFs1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1ll_BFs1i, BFs1s_BFu1s_BFu1ll_BFs1i)
//============================================================================


struct  BFs1s_BFu1s_BFu1ll_BFs1ll  {
  signed short v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1ll_BFs1ll) C1{ Fs:1 Fs:1 FL:1 FL:1}



static void Test_BFs1s_BFu1s_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1ll_BFs1ll, BFs1s_BFu1s_BFu1ll_BFs1ll)
//============================================================================


struct  BFs1s_BFu1s_BFu1ll_BFs1s  {
  signed short v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1ll_BFs1s) C1{ Fs:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1s_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1ll_BFs1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1ll_BFs1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1ll_BFs1s, BFs1s_BFu1s_BFu1ll_BFs1s)
//============================================================================


struct  BFs1s_BFu1s_BFu1ll_BFu1c  {
  signed short v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1ll_BFu1c) C1{ Fs:1 Fs:1 FL:1 Fc:1}



static void Test_BFs1s_BFu1s_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1ll_BFu1c, BFs1s_BFu1s_BFu1ll_BFu1c)
//============================================================================


struct  BFs1s_BFu1s_BFu1ll_BFu1i  {
  signed short v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1ll_BFu1i) C1{ Fs:1 Fs:1 FL:1 Fi:1}



static void Test_BFs1s_BFu1s_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1ll_BFu1i, BFs1s_BFu1s_BFu1ll_BFu1i)
//============================================================================


struct  BFs1s_BFu1s_BFu1ll_BFu1ll  {
  signed short v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1ll_BFu1ll) C1{ Fs:1 Fs:1 FL:1 FL:1}



static void Test_BFs1s_BFu1s_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1ll_BFu1ll, BFs1s_BFu1s_BFu1ll_BFu1ll)
//============================================================================


struct  BFs1s_BFu1s_BFu1ll_BFu1s  {
  signed short v1:1;
  unsigned short v2:1;
  __tsu64 v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1ll_BFu1s) C1{ Fs:1 Fs:1 FL:1 Fs:1}



static void Test_BFs1s_BFu1s_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1ll_BFu1s, BFs1s_BFu1s_BFu1ll_BFu1s)
//============================================================================


struct  BFs1s_BFu1s_BFu1s  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
};
//SIG(1 BFs1s_BFu1s_BFu1s) C1{ Fs:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1s, BFs1s_BFu1s_BFu1s)
//============================================================================


struct  BFs1s_BFu1s_BFu1s_BFs1c  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  signed char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1s_BFs1c) C1{ Fs:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1s_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1s_BFs1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFu1s_BFs1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1s_BFs1c, BFs1s_BFu1s_BFu1s_BFs1c)
//============================================================================


struct  BFs1s_BFu1s_BFu1s_BFs1i  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  signed int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1s_BFs1i) C1{ Fs:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1s_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1s_BFs1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFu1s_BFs1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1s_BFs1i, BFs1s_BFu1s_BFu1s_BFs1i)
//============================================================================


struct  BFs1s_BFu1s_BFu1s_BFs1ll  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  signed __tsi64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1s_BFs1ll) C1{ Fs:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1s_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1s_BFs1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1s_BFs1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1s_BFs1ll, BFs1s_BFu1s_BFu1s_BFs1ll)
//============================================================================


struct  BFs1s_BFu1s_BFu1s_BFs1s  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  signed short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1s_BFs1s) C1{ Fs:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1s_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1s_BFs1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFu1s_BFs1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1s_BFu1s_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1s_BFs1s, BFs1s_BFu1s_BFu1s_BFs1s)
//============================================================================


struct  BFs1s_BFu1s_BFu1s_BFu1c  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  unsigned char v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1s_BFu1c) C1{ Fs:1 Fs:1 Fs:1 Fc:1}



static void Test_BFs1s_BFu1s_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFu1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1s_BFu1c, BFs1s_BFu1s_BFu1s_BFu1c)
//============================================================================


struct  BFs1s_BFu1s_BFu1s_BFu1i  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  unsigned int v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1s_BFu1i) C1{ Fs:1 Fs:1 Fs:1 Fi:1}



static void Test_BFs1s_BFu1s_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFs1s_BFu1s_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs1s_BFu1s_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1s_BFu1i, BFs1s_BFu1s_BFu1s_BFu1i)
//============================================================================


struct  BFs1s_BFu1s_BFu1s_BFu1ll  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  __tsu64 v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1s_BFu1ll) C1{ Fs:1 Fs:1 Fs:1 FL:1}



static void Test_BFs1s_BFu1s_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs1s_BFu1s_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs1s_BFu1s_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1s_BFu1ll, BFs1s_BFu1s_BFu1s_BFu1ll)
//============================================================================


struct  BFs1s_BFu1s_BFu1s_BFu1s  {
  signed short v1:1;
  unsigned short v2:1;
  unsigned short v3:1;
  unsigned short v4:1;
};
//SIG(1 BFs1s_BFu1s_BFu1s_BFu1s) C1{ Fs:1 Fs:1 Fs:1 Fs:1}



static void Test_BFs1s_BFu1s_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1s_BFu1s_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1s_BFu1s_BFu1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(BFs1s_BFu1s_BFu1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs1s_BFu1s_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1s_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1s_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1s_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1s_BFu1s_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1s_BFu1s_BFu1s_BFu1s, BFs1s_BFu1s_BFu1s_BFu1s)
//============================================================================


struct  BFs31i_BFs31i  {
  signed int v1:31;
  signed int v2:31;
};
//SIG(1 BFs31i_BFs31i) C1{ Fi:31 Fi:31}



static void Test_BFs31i_BFs31i()
{
  {
    init_simple_test("BFs31i_BFs31i");
    static STRUCT_IF_C BFs31i_BFs31i lv;
    check2(sizeof(lv), 8, "sizeof(BFs31i_BFs31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs31i_BFs31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i, BFs31i_BFs31i)
//============================================================================


struct  BFs31i_BFs31i_BFs31i  {
  signed int v1:31;
  signed int v2:31;
  signed int v3:31;
};
//SIG(1 BFs31i_BFs31i_BFs31i) C1{ Fi:31 Fi:31 Fi:31}



static void Test_BFs31i_BFs31i_BFs31i()
{
  {
    init_simple_test("BFs31i_BFs31i_BFs31i");
    static STRUCT_IF_C BFs31i_BFs31i_BFs31i lv;
    check2(sizeof(lv), 12, "sizeof(BFs31i_BFs31i_BFs31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs31i_BFs31i_BFs31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFs31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFs31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31i_BFs31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFs31i, BFs31i_BFs31i_BFs31i)
//============================================================================


struct  BFs31i_BFs31i_BFs31i_BFs31i  {
  signed int v1:31;
  signed int v2:31;
  signed int v3:31;
  signed int v4:31;
};
//SIG(1 BFs31i_BFs31i_BFs31i_BFs31i) C1{ Fi:31 Fi:31 Fi:31 Fi:31}



static void Test_BFs31i_BFs31i_BFs31i_BFs31i()
{
  {
    init_simple_test("BFs31i_BFs31i_BFs31i_BFs31i");
    static STRUCT_IF_C BFs31i_BFs31i_BFs31i_BFs31i lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFs31i_BFs31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs31i_BFs31i_BFs31i_BFs31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFs31i_BFs31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i_BFs31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFs31i_BFs31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i_BFs31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31i_BFs31i_BFs31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i_BFs31i");
    set_bf_and_test(lv, v4, 12, 0, 31, 1, "BFs31i_BFs31i_BFs31i_BFs31i");
    set_bf_and_test(lv, v4, 12, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i_BFs31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFs31i_BFs31i, BFs31i_BFs31i_BFs31i_BFs31i)
//============================================================================


struct  BFs31i_BFs31i_BFs31i_BFs31ll  {
  signed int v1:31;
  signed int v2:31;
  signed int v3:31;
  signed __tsi64 v4:31;
};
//SIG(1 BFs31i_BFs31i_BFs31i_BFs31ll) C1{ Fi:31 Fi:31 Fi:31 FL:31}



static void Test_BFs31i_BFs31i_BFs31i_BFs31ll()
{
  {
    init_simple_test("BFs31i_BFs31i_BFs31i_BFs31ll");
    static STRUCT_IF_C BFs31i_BFs31i_BFs31i_BFs31ll lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFs31i_BFs31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31i_BFs31i_BFs31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFs31i_BFs31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i_BFs31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFs31i_BFs31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i_BFs31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31i_BFs31i_BFs31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i_BFs31ll");
    set_bf_and_test(lv, v4, 11, 7, 31, 1, "BFs31i_BFs31i_BFs31i_BFs31ll");
    set_bf_and_test(lv, v4, 11, 7, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i_BFs31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFs31i_BFs31ll, BFs31i_BFs31i_BFs31i_BFs31ll)
//============================================================================


struct  BFs31i_BFs31i_BFs31i_BFu31i  {
  signed int v1:31;
  signed int v2:31;
  signed int v3:31;
  unsigned int v4:31;
};
//SIG(1 BFs31i_BFs31i_BFs31i_BFu31i) C1{ Fi:31 Fi:31 Fi:31 Fi:31}



static void Test_BFs31i_BFs31i_BFs31i_BFu31i()
{
  {
    init_simple_test("BFs31i_BFs31i_BFs31i_BFu31i");
    static STRUCT_IF_C BFs31i_BFs31i_BFs31i_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFs31i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs31i_BFs31i_BFs31i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFs31i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFs31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31i_BFs31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i_BFu31i");
    set_bf_and_test(lv, v4, 12, 0, 31, 1, "BFs31i_BFs31i_BFs31i_BFu31i");
    set_bf_and_test(lv, v4, 12, 0, 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFs31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFs31i_BFu31i, BFs31i_BFs31i_BFs31i_BFu31i)
//============================================================================


struct  BFs31i_BFs31i_BFs31i_BFu31ll  {
  signed int v1:31;
  signed int v2:31;
  signed int v3:31;
  __tsu64 v4:31;
};
//SIG(1 BFs31i_BFs31i_BFs31i_BFu31ll) C1{ Fi:31 Fi:31 Fi:31 FL:31}



static void Test_BFs31i_BFs31i_BFs31i_BFu31ll()
{
  {
    init_simple_test("BFs31i_BFs31i_BFs31i_BFu31ll");
    static STRUCT_IF_C BFs31i_BFs31i_BFs31i_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFs31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31i_BFs31i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFs31i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFs31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31i_BFs31i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31i_BFu31ll");
    set_bf_and_test(lv, v4, 11, 7, 31, 1, "BFs31i_BFs31i_BFs31i_BFu31ll");
    set_bf_and_test(lv, v4, 11, 7, 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFs31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFs31i_BFu31ll, BFs31i_BFs31i_BFs31i_BFu31ll)
//============================================================================


struct  BFs31i_BFs31i_BFs31ll  {
  signed int v1:31;
  signed int v2:31;
  signed __tsi64 v3:31;
};
//SIG(1 BFs31i_BFs31i_BFs31ll) C1{ Fi:31 Fi:31 FL:31}



static void Test_BFs31i_BFs31i_BFs31ll()
{
  {
    init_simple_test("BFs31i_BFs31i_BFs31ll");
    static STRUCT_IF_C BFs31i_BFs31i_BFs31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFs31i_BFs31i_BFs31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31i_BFs31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFs31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFs31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "BFs31i_BFs31i_BFs31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFs31ll, BFs31i_BFs31i_BFs31ll)
//============================================================================


struct  BFs31i_BFs31i_BFs31ll_BFs31i  {
  signed int v1:31;
  signed int v2:31;
  signed __tsi64 v3:31;
  signed int v4:31;
};
//SIG(1 BFs31i_BFs31i_BFs31ll_BFs31i) C1{ Fi:31 Fi:31 FL:31 Fi:31}



static void Test_BFs31i_BFs31i_BFs31ll_BFs31i()
{
  {
    init_simple_test("BFs31i_BFs31i_BFs31ll_BFs31i");
    static STRUCT_IF_C BFs31i_BFs31i_BFs31ll_BFs31i lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFs31ll_BFs31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31i_BFs31ll_BFs31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFs31ll_BFs31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFs31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFs31ll_BFs31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFs31i");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "BFs31i_BFs31i_BFs31ll_BFs31i");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFs31i");
    set_bf_and_test(lv, v4, 12, 0, 31, 1, "BFs31i_BFs31i_BFs31ll_BFs31i");
    set_bf_and_test(lv, v4, 12, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFs31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFs31ll_BFs31i, BFs31i_BFs31i_BFs31ll_BFs31i)
//============================================================================


struct  BFs31i_BFs31i_BFs31ll_BFs31ll  {
  signed int v1:31;
  signed int v2:31;
  signed __tsi64 v3:31;
  signed __tsi64 v4:31;
};
//SIG(1 BFs31i_BFs31i_BFs31ll_BFs31ll) C1{ Fi:31 Fi:31 FL:31 FL:31}



static void Test_BFs31i_BFs31i_BFs31ll_BFs31ll()
{
  {
    init_simple_test("BFs31i_BFs31i_BFs31ll_BFs31ll");
    static STRUCT_IF_C BFs31i_BFs31i_BFs31ll_BFs31ll lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFs31ll_BFs31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31i_BFs31ll_BFs31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "BFs31i_BFs31i_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v4, 11, ABISELECT(7,6), 31, 1, "BFs31i_BFs31i_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v4, 11, ABISELECT(7,6), 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFs31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFs31ll_BFs31ll, BFs31i_BFs31i_BFs31ll_BFs31ll)
//============================================================================


struct  BFs31i_BFs31i_BFs31ll_BFu31i  {
  signed int v1:31;
  signed int v2:31;
  signed __tsi64 v3:31;
  unsigned int v4:31;
};
//SIG(1 BFs31i_BFs31i_BFs31ll_BFu31i) C1{ Fi:31 Fi:31 FL:31 Fi:31}



static void Test_BFs31i_BFs31i_BFs31ll_BFu31i()
{
  {
    init_simple_test("BFs31i_BFs31i_BFs31ll_BFu31i");
    static STRUCT_IF_C BFs31i_BFs31i_BFs31ll_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFs31ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31i_BFs31ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFs31ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFs31ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "BFs31i_BFs31i_BFs31ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFu31i");
    set_bf_and_test(lv, v4, 12, 0, 31, 1, "BFs31i_BFs31i_BFs31ll_BFu31i");
    set_bf_and_test(lv, v4, 12, 0, 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFs31ll_BFu31i, BFs31i_BFs31i_BFs31ll_BFu31i)
//============================================================================


struct  BFs31i_BFs31i_BFs31ll_BFu31ll  {
  signed int v1:31;
  signed int v2:31;
  signed __tsi64 v3:31;
  __tsu64 v4:31;
};
//SIG(1 BFs31i_BFs31i_BFs31ll_BFu31ll) C1{ Fi:31 Fi:31 FL:31 FL:31}



static void Test_BFs31i_BFs31i_BFs31ll_BFu31ll()
{
  {
    init_simple_test("BFs31i_BFs31i_BFs31ll_BFu31ll");
    static STRUCT_IF_C BFs31i_BFs31i_BFs31ll_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFs31ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31i_BFs31ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFs31ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFs31ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "BFs31i_BFs31i_BFs31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFu31ll");
    set_bf_and_test(lv, v4, 11, ABISELECT(7,6), 31, 1, "BFs31i_BFs31i_BFs31ll_BFu31ll");
    set_bf_and_test(lv, v4, 11, ABISELECT(7,6), 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFs31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFs31ll_BFu31ll, BFs31i_BFs31i_BFs31ll_BFu31ll)
//============================================================================


struct  BFs31i_BFs31i_BFu31i  {
  signed int v1:31;
  signed int v2:31;
  unsigned int v3:31;
};
//SIG(1 BFs31i_BFs31i_BFu31i) C1{ Fi:31 Fi:31 Fi:31}



static void Test_BFs31i_BFs31i_BFu31i()
{
  {
    init_simple_test("BFs31i_BFs31i_BFu31i");
    static STRUCT_IF_C BFs31i_BFs31i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(BFs31i_BFs31i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs31i_BFs31i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFu31i, BFs31i_BFs31i_BFu31i)
//============================================================================


struct  BFs31i_BFs31i_BFu31i_BFs31i  {
  signed int v1:31;
  signed int v2:31;
  unsigned int v3:31;
  signed int v4:31;
};
//SIG(1 BFs31i_BFs31i_BFu31i_BFs31i) C1{ Fi:31 Fi:31 Fi:31 Fi:31}



static void Test_BFs31i_BFs31i_BFu31i_BFs31i()
{
  {
    init_simple_test("BFs31i_BFs31i_BFu31i_BFs31i");
    static STRUCT_IF_C BFs31i_BFs31i_BFu31i_BFs31i lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFu31i_BFs31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs31i_BFs31i_BFu31i_BFs31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFu31i_BFs31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31i_BFs31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFu31i_BFs31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31i_BFs31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31i_BFu31i_BFs31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFu31i_BFs31i");
    set_bf_and_test(lv, v4, 12, 0, 31, 1, "BFs31i_BFs31i_BFu31i_BFs31i");
    set_bf_and_test(lv, v4, 12, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31i_BFs31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFu31i_BFs31i, BFs31i_BFs31i_BFu31i_BFs31i)
//============================================================================


struct  BFs31i_BFs31i_BFu31i_BFs31ll  {
  signed int v1:31;
  signed int v2:31;
  unsigned int v3:31;
  signed __tsi64 v4:31;
};
//SIG(1 BFs31i_BFs31i_BFu31i_BFs31ll) C1{ Fi:31 Fi:31 Fi:31 FL:31}



static void Test_BFs31i_BFs31i_BFu31i_BFs31ll()
{
  {
    init_simple_test("BFs31i_BFs31i_BFu31i_BFs31ll");
    static STRUCT_IF_C BFs31i_BFs31i_BFu31i_BFs31ll lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFu31i_BFs31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31i_BFu31i_BFs31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFu31i_BFs31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31i_BFs31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFu31i_BFs31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31i_BFs31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31i_BFu31i_BFs31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFu31i_BFs31ll");
    set_bf_and_test(lv, v4, 11, 7, 31, 1, "BFs31i_BFs31i_BFu31i_BFs31ll");
    set_bf_and_test(lv, v4, 11, 7, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31i_BFs31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFu31i_BFs31ll, BFs31i_BFs31i_BFu31i_BFs31ll)
//============================================================================


struct  BFs31i_BFs31i_BFu31i_BFu31i  {
  signed int v1:31;
  signed int v2:31;
  unsigned int v3:31;
  unsigned int v4:31;
};
//SIG(1 BFs31i_BFs31i_BFu31i_BFu31i) C1{ Fi:31 Fi:31 Fi:31 Fi:31}



static void Test_BFs31i_BFs31i_BFu31i_BFu31i()
{
  {
    init_simple_test("BFs31i_BFs31i_BFu31i_BFu31i");
    static STRUCT_IF_C BFs31i_BFs31i_BFu31i_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFu31i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs31i_BFs31i_BFu31i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFu31i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31i_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFu31i_BFu31i");
    set_bf_and_test(lv, v4, 12, 0, 31, 1, "BFs31i_BFs31i_BFu31i_BFu31i");
    set_bf_and_test(lv, v4, 12, 0, 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFu31i_BFu31i, BFs31i_BFs31i_BFu31i_BFu31i)
//============================================================================


struct  BFs31i_BFs31i_BFu31i_BFu31ll  {
  signed int v1:31;
  signed int v2:31;
  unsigned int v3:31;
  __tsu64 v4:31;
};
//SIG(1 BFs31i_BFs31i_BFu31i_BFu31ll) C1{ Fi:31 Fi:31 Fi:31 FL:31}



static void Test_BFs31i_BFs31i_BFu31i_BFu31ll()
{
  {
    init_simple_test("BFs31i_BFs31i_BFu31i_BFu31ll");
    static STRUCT_IF_C BFs31i_BFs31i_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFu31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31i_BFu31i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFu31i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31i_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFu31i_BFu31ll");
    set_bf_and_test(lv, v4, 11, 7, 31, 1, "BFs31i_BFs31i_BFu31i_BFu31ll");
    set_bf_and_test(lv, v4, 11, 7, 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFu31i_BFu31ll, BFs31i_BFs31i_BFu31i_BFu31ll)
//============================================================================


struct  BFs31i_BFs31i_BFu31ll  {
  signed int v1:31;
  signed int v2:31;
  __tsu64 v3:31;
};
//SIG(1 BFs31i_BFs31i_BFu31ll) C1{ Fi:31 Fi:31 FL:31}



static void Test_BFs31i_BFs31i_BFu31ll()
{
  {
    init_simple_test("BFs31i_BFs31i_BFu31ll");
    static STRUCT_IF_C BFs31i_BFs31i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFs31i_BFs31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "BFs31i_BFs31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFu31ll, BFs31i_BFs31i_BFu31ll)
//============================================================================


struct  BFs31i_BFs31i_BFu31ll_BFs31i  {
  signed int v1:31;
  signed int v2:31;
  __tsu64 v3:31;
  signed int v4:31;
};
//SIG(1 BFs31i_BFs31i_BFu31ll_BFs31i) C1{ Fi:31 Fi:31 FL:31 Fi:31}



static void Test_BFs31i_BFs31i_BFu31ll_BFs31i()
{
  {
    init_simple_test("BFs31i_BFs31i_BFu31ll_BFs31i");
    static STRUCT_IF_C BFs31i_BFs31i_BFu31ll_BFs31i lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFu31ll_BFs31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31i_BFu31ll_BFs31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFu31ll_BFs31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFs31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFu31ll_BFs31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFs31i");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "BFs31i_BFs31i_BFu31ll_BFs31i");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFs31i");
    set_bf_and_test(lv, v4, 12, 0, 31, 1, "BFs31i_BFs31i_BFu31ll_BFs31i");
    set_bf_and_test(lv, v4, 12, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFs31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFu31ll_BFs31i, BFs31i_BFs31i_BFu31ll_BFs31i)
//============================================================================


struct  BFs31i_BFs31i_BFu31ll_BFs31ll  {
  signed int v1:31;
  signed int v2:31;
  __tsu64 v3:31;
  signed __tsi64 v4:31;
};
//SIG(1 BFs31i_BFs31i_BFu31ll_BFs31ll) C1{ Fi:31 Fi:31 FL:31 FL:31}



static void Test_BFs31i_BFs31i_BFu31ll_BFs31ll()
{
  {
    init_simple_test("BFs31i_BFs31i_BFu31ll_BFs31ll");
    static STRUCT_IF_C BFs31i_BFs31i_BFu31ll_BFs31ll lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFu31ll_BFs31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31i_BFu31ll_BFs31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFu31ll_BFs31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFs31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFu31ll_BFs31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFs31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "BFs31i_BFs31i_BFu31ll_BFs31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFs31ll");
    set_bf_and_test(lv, v4, 11, ABISELECT(7,6), 31, 1, "BFs31i_BFs31i_BFu31ll_BFs31ll");
    set_bf_and_test(lv, v4, 11, ABISELECT(7,6), 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFs31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFu31ll_BFs31ll, BFs31i_BFs31i_BFu31ll_BFs31ll)
//============================================================================


struct  BFs31i_BFs31i_BFu31ll_BFu31i  {
  signed int v1:31;
  signed int v2:31;
  __tsu64 v3:31;
  unsigned int v4:31;
};
//SIG(1 BFs31i_BFs31i_BFu31ll_BFu31i) C1{ Fi:31 Fi:31 FL:31 Fi:31}



static void Test_BFs31i_BFs31i_BFu31ll_BFu31i()
{
  {
    init_simple_test("BFs31i_BFs31i_BFu31ll_BFu31i");
    static STRUCT_IF_C BFs31i_BFs31i_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFu31ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31i_BFu31ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFu31ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "BFs31i_BFs31i_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFu31i");
    set_bf_and_test(lv, v4, 12, 0, 31, 1, "BFs31i_BFs31i_BFu31ll_BFu31i");
    set_bf_and_test(lv, v4, 12, 0, 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFu31ll_BFu31i, BFs31i_BFs31i_BFu31ll_BFu31i)
//============================================================================


struct  BFs31i_BFs31i_BFu31ll_BFu31ll  {
  signed int v1:31;
  signed int v2:31;
  __tsu64 v3:31;
  __tsu64 v4:31;
};
//SIG(1 BFs31i_BFs31i_BFu31ll_BFu31ll) C1{ Fi:31 Fi:31 FL:31 FL:31}



static void Test_BFs31i_BFs31i_BFu31ll_BFu31ll()
{
  {
    init_simple_test("BFs31i_BFs31i_BFu31ll_BFu31ll");
    static STRUCT_IF_C BFs31i_BFs31i_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31i_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31i_BFu31ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31i_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFs31i_BFs31i_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "BFs31i_BFs31i_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v4, 11, ABISELECT(7,6), 31, 1, "BFs31i_BFs31i_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v4, 11, ABISELECT(7,6), 31, hide_ull(1LL<<30), "BFs31i_BFs31i_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31i_BFu31ll_BFu31ll, BFs31i_BFs31i_BFu31ll_BFu31ll)
//============================================================================


struct  BFs31i_BFs31ll  {
  signed int v1:31;
  signed __tsi64 v2:31;
};
//SIG(1 BFs31i_BFs31ll) C1{ Fi:31 FL:31}



static void Test_BFs31i_BFs31ll()
{
  {
    init_simple_test("BFs31i_BFs31ll");
    static STRUCT_IF_C BFs31i_BFs31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs31i_BFs31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFs31i_BFs31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31ll, BFs31i_BFs31ll)
//============================================================================


struct  BFs31i_BFs31ll_BFs31i  {
  signed int v1:31;
  signed __tsi64 v2:31;
  signed int v3:31;
};
//SIG(1 BFs31i_BFs31ll_BFs31i) C1{ Fi:31 FL:31 Fi:31}



static void Test_BFs31i_BFs31ll_BFs31i()
{
  {
    init_simple_test("BFs31i_BFs31ll_BFs31i");
    static STRUCT_IF_C BFs31i_BFs31ll_BFs31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFs31i_BFs31ll_BFs31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31ll_BFs31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31ll_BFs31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFs31i_BFs31ll_BFs31i");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31ll_BFs31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31ll_BFs31i, BFs31i_BFs31ll_BFs31i)
//============================================================================


struct  BFs31i_BFs31ll_BFs31i_BFs31i  {
  signed int v1:31;
  signed __tsi64 v2:31;
  signed int v3:31;
  signed int v4:31;
};
//SIG(1 BFs31i_BFs31ll_BFs31i_BFs31i) C1{ Fi:31 FL:31 Fi:31 Fi:31}



static void Test_BFs31i_BFs31ll_BFs31i_BFs31i()
{
  {
    init_simple_test("BFs31i_BFs31ll_BFs31i_BFs31i");
    static STRUCT_IF_C BFs31i_BFs31ll_BFs31i_BFs31i lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31ll_BFs31i_BFs31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31ll_BFs31i_BFs31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31ll_BFs31i_BFs31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFs31i");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFs31i_BFs31ll_BFs31i_BFs31i");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFs31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31ll_BFs31i_BFs31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFs31i");
    set_bf_and_test(lv, v4, 12, 0, 31, 1, "BFs31i_BFs31ll_BFs31i_BFs31i");
    set_bf_and_test(lv, v4, 12, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFs31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31ll_BFs31i_BFs31i, BFs31i_BFs31ll_BFs31i_BFs31i)
//============================================================================


struct  BFs31i_BFs31ll_BFs31i_BFs31ll  {
  signed int v1:31;
  signed __tsi64 v2:31;
  signed int v3:31;
  signed __tsi64 v4:31;
};
//SIG(1 BFs31i_BFs31ll_BFs31i_BFs31ll) C1{ Fi:31 FL:31 Fi:31 FL:31}



static void Test_BFs31i_BFs31ll_BFs31i_BFs31ll()
{
  {
    init_simple_test("BFs31i_BFs31ll_BFs31i_BFs31ll");
    static STRUCT_IF_C BFs31i_BFs31ll_BFs31i_BFs31ll lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31ll_BFs31i_BFs31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31ll_BFs31i_BFs31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31ll_BFs31i_BFs31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFs31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFs31i_BFs31ll_BFs31i_BFs31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFs31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31ll_BFs31i_BFs31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFs31ll");
    set_bf_and_test(lv, v4, 11, 7, 31, 1, "BFs31i_BFs31ll_BFs31i_BFs31ll");
    set_bf_and_test(lv, v4, 11, 7, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFs31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31ll_BFs31i_BFs31ll, BFs31i_BFs31ll_BFs31i_BFs31ll)
//============================================================================


struct  BFs31i_BFs31ll_BFs31i_BFu31i  {
  signed int v1:31;
  signed __tsi64 v2:31;
  signed int v3:31;
  unsigned int v4:31;
};
//SIG(1 BFs31i_BFs31ll_BFs31i_BFu31i) C1{ Fi:31 FL:31 Fi:31 Fi:31}



static void Test_BFs31i_BFs31ll_BFs31i_BFu31i()
{
  {
    init_simple_test("BFs31i_BFs31ll_BFs31i_BFu31i");
    static STRUCT_IF_C BFs31i_BFs31ll_BFs31i_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31ll_BFs31i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31ll_BFs31i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31ll_BFs31i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFu31i");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFs31i_BFs31ll_BFs31i_BFu31i");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31ll_BFs31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFu31i");
    set_bf_and_test(lv, v4, 12, 0, 31, 1, "BFs31i_BFs31ll_BFs31i_BFu31i");
    set_bf_and_test(lv, v4, 12, 0, 31, hide_ull(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31ll_BFs31i_BFu31i, BFs31i_BFs31ll_BFs31i_BFu31i)
//============================================================================


struct  BFs31i_BFs31ll_BFs31i_BFu31ll  {
  signed int v1:31;
  signed __tsi64 v2:31;
  signed int v3:31;
  __tsu64 v4:31;
};
//SIG(1 BFs31i_BFs31ll_BFs31i_BFu31ll) C1{ Fi:31 FL:31 Fi:31 FL:31}



static void Test_BFs31i_BFs31ll_BFs31i_BFu31ll()
{
  {
    init_simple_test("BFs31i_BFs31ll_BFs31i_BFu31ll");
    static STRUCT_IF_C BFs31i_BFs31ll_BFs31i_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31ll_BFs31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31ll_BFs31i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31ll_BFs31i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFu31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFs31i_BFs31ll_BFs31i_BFu31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFs31i_BFs31ll_BFs31i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFu31ll");
    set_bf_and_test(lv, v4, 11, 7, 31, 1, "BFs31i_BFs31ll_BFs31i_BFu31ll");
    set_bf_and_test(lv, v4, 11, 7, 31, hide_ull(1LL<<30), "BFs31i_BFs31ll_BFs31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31ll_BFs31i_BFu31ll, BFs31i_BFs31ll_BFs31i_BFu31ll)
//============================================================================


struct  BFs31i_BFs31ll_BFs31ll  {
  signed int v1:31;
  signed __tsi64 v2:31;
  signed __tsi64 v3:31;
};
//SIG(1 BFs31i_BFs31ll_BFs31ll) C1{ Fi:31 FL:31 FL:31}



static void Test_BFs31i_BFs31ll_BFs31ll()
{
  {
    init_simple_test("BFs31i_BFs31ll_BFs31ll");
    static STRUCT_IF_C BFs31i_BFs31ll_BFs31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFs31i_BFs31ll_BFs31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31ll_BFs31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFs31i_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,6), 31, 1, "BFs31i_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,6), 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31ll_BFs31ll, BFs31i_BFs31ll_BFs31ll)
//============================================================================


struct  BFs31i_BFs31ll_BFs31ll_BFs31i  {
  signed int v1:31;
  signed __tsi64 v2:31;
  signed __tsi64 v3:31;
  signed int v4:31;
};
//SIG(1 BFs31i_BFs31ll_BFs31ll_BFs31i) C1{ Fi:31 FL:31 FL:31 Fi:31}



static void Test_BFs31i_BFs31ll_BFs31ll_BFs31i()
{
  {
    init_simple_test("BFs31i_BFs31ll_BFs31ll_BFs31i");
    static STRUCT_IF_C BFs31i_BFs31ll_BFs31ll_BFs31i lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31ll_BFs31ll_BFs31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31ll_BFs31ll_BFs31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31ll_BFs31ll_BFs31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31ll_BFs31i");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFs31i_BFs31ll_BFs31ll_BFs31i");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31ll_BFs31i");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,6), 31, 1, "BFs31i_BFs31ll_BFs31ll_BFs31i");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,6), 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31ll_BFs31i");
    set_bf_and_test(lv, v4, 12, 0, 31, 1, "BFs31i_BFs31ll_BFs31ll_BFs31i");
    set_bf_and_test(lv, v4, 12, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31ll_BFs31i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs31i_BFs31ll_BFs31ll_BFs31i, BFs31i_BFs31ll_BFs31ll_BFs31i)
//============================================================================


struct  BFs31i_BFs31ll_BFs31ll_BFs31ll  {
  signed int v1:31;
  signed __tsi64 v2:31;
  signed __tsi64 v3:31;
  signed __tsi64 v4:31;
};
//SIG(1 BFs31i_BFs31ll_BFs31ll_BFs31ll) C1{ Fi:31 FL:31 FL:31 FL:31}



static void Test_BFs31i_BFs31ll_BFs31ll_BFs31ll()
{
  {
    init_simple_test("BFs31i_BFs31ll_BFs31ll_BFs31ll");
    static STRUCT_IF_C BFs31i_BFs31ll_BFs31ll_BFs31ll lv;
    check2(sizeof(lv), 16, "sizeof(BFs31i_BFs31ll_BFs31ll_BFs31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs31i_BFs31ll_BFs31ll_BFs31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFs31i_BFs31ll_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFs31i_BFs31ll_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,6), 31, 1, "BFs31i_BFs31ll_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,6), 31, hide_sll(1LL<<30), "BFs31i_BFs31ll_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v4, 11, ABISELECT(7,5), 31, 1, "BFs31i_BFs31ll_BFs31ll_BFs31ll");
    set_bf_and_test(lv, v4, 