// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  BFs15i_BFs15i  {
  signed int v1:15;
  signed int v2:15;
};
//SIG(1 BFs15i_BFs15i) C1{ Fi:15 Fi:15}



static void Test_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15i lv;
    check2(sizeof(lv), 4, "sizeof(BFs15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i, BFs15i_BFs15i)
//============================================================================


struct  BFs15i_BFs15i_BFs15i  {
  signed int v1:15;
  signed int v2:15;
  signed int v3:15;
};
//SIG(1 BFs15i_BFs15i_BFs15i) C1{ Fi:15 Fi:15 Fi:15}



static void Test_BFs15i_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15i, BFs15i_BFs15i_BFs15i)
//============================================================================


struct  BFs15i_BFs15i_BFs15i_BFs15i  {
  signed int v1:15;
  signed int v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15i_BFs15i) C1{ Fi:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15i_BFs15i_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15i_BFs15i, BFs15i_BFs15i_BFs15i_BFs15i)
//============================================================================


struct  BFs15i_BFs15i_BFs15i_BFs15ll  {
  signed int v1:15;
  signed int v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15i_BFs15ll) C1{ Fi:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15i_BFs15i_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15i_BFs15ll, BFs15i_BFs15i_BFs15i_BFs15ll)
//============================================================================


struct  BFs15i_BFs15i_BFs15i_BFs15s  {
  signed int v1:15;
  signed int v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15i_BFs15s) C1{ Fi:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15i_BFs15i_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15i_BFs15s, BFs15i_BFs15i_BFs15i_BFs15s)
//============================================================================


struct  BFs15i_BFs15i_BFs15i_BFu15i  {
  signed int v1:15;
  signed int v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15i_BFu15i) C1{ Fi:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15i_BFs15i_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15i_BFu15i, BFs15i_BFs15i_BFs15i_BFu15i)
//============================================================================


struct  BFs15i_BFs15i_BFs15i_BFu15ll  {
  signed int v1:15;
  signed int v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15i_BFu15ll) C1{ Fi:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15i_BFs15i_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15i_BFu15ll, BFs15i_BFs15i_BFs15i_BFu15ll)
//============================================================================


struct  BFs15i_BFs15i_BFs15i_BFu15s  {
  signed int v1:15;
  signed int v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15i_BFu15s) C1{ Fi:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15i_BFs15i_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15i_BFu15s, BFs15i_BFs15i_BFs15i_BFu15s)
//============================================================================


struct  BFs15i_BFs15i_BFs15ll  {
  signed int v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15i_BFs15i_BFs15ll) C1{ Fi:15 Fi:15 FL:15}



static void Test_BFs15i_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15ll, BFs15i_BFs15i_BFs15ll)
//============================================================================


struct  BFs15i_BFs15i_BFs15ll_BFs15i  {
  signed int v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15ll_BFs15i) C1{ Fi:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15i_BFs15i_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15ll_BFs15i, BFs15i_BFs15i_BFs15ll_BFs15i)
//============================================================================


struct  BFs15i_BFs15i_BFs15ll_BFs15ll  {
  signed int v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15ll_BFs15ll) C1{ Fi:15 Fi:15 FL:15 FL:15}



static void Test_BFs15i_BFs15i_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15ll_BFs15ll, BFs15i_BFs15i_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15i_BFs15i_BFs15ll_BFs15s  {
  signed int v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15ll_BFs15s) C1{ Fi:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15i_BFs15i_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15ll_BFs15s, BFs15i_BFs15i_BFs15ll_BFs15s)
//============================================================================


struct  BFs15i_BFs15i_BFs15ll_BFu15i  {
  signed int v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15ll_BFu15i) C1{ Fi:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15i_BFs15i_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15ll_BFu15i, BFs15i_BFs15i_BFs15ll_BFu15i)
//============================================================================


struct  BFs15i_BFs15i_BFs15ll_BFu15ll  {
  signed int v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15ll_BFu15ll) C1{ Fi:15 Fi:15 FL:15 FL:15}



static void Test_BFs15i_BFs15i_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15ll_BFu15ll, BFs15i_BFs15i_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15i_BFs15i_BFs15ll_BFu15s  {
  signed int v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15ll_BFu15s) C1{ Fi:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15i_BFs15i_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15ll_BFu15s, BFs15i_BFs15i_BFs15ll_BFu15s)
//============================================================================


struct  BFs15i_BFs15i_BFs15s  {
  signed int v1:15;
  signed int v2:15;
  signed short v3:15;
};
//SIG(1 BFs15i_BFs15i_BFs15s) C1{ Fi:15 Fi:15 Fs:15}



static void Test_BFs15i_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15s, BFs15i_BFs15i_BFs15s)
//============================================================================


struct  BFs15i_BFs15i_BFs15s_BFs15i  {
  signed int v1:15;
  signed int v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15s_BFs15i) C1{ Fi:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15i_BFs15i_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15s_BFs15i, BFs15i_BFs15i_BFs15s_BFs15i)
//============================================================================


struct  BFs15i_BFs15i_BFs15s_BFs15ll  {
  signed int v1:15;
  signed int v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15s_BFs15ll) C1{ Fi:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15i_BFs15i_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15s_BFs15ll, BFs15i_BFs15i_BFs15s_BFs15ll)
//============================================================================


struct  BFs15i_BFs15i_BFs15s_BFs15s  {
  signed int v1:15;
  signed int v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15s_BFs15s) C1{ Fi:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15i_BFs15i_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15s_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15s_BFs15s, BFs15i_BFs15i_BFs15s_BFs15s)
//============================================================================


struct  BFs15i_BFs15i_BFs15s_BFu15i  {
  signed int v1:15;
  signed int v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15s_BFu15i) C1{ Fi:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15i_BFs15i_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15s_BFu15i, BFs15i_BFs15i_BFs15s_BFu15i)
//============================================================================


struct  BFs15i_BFs15i_BFs15s_BFu15ll  {
  signed int v1:15;
  signed int v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15s_BFu15ll) C1{ Fi:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15i_BFs15i_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15s_BFu15ll, BFs15i_BFs15i_BFs15s_BFu15ll)
//============================================================================


struct  BFs15i_BFs15i_BFs15s_BFu15s  {
  signed int v1:15;
  signed int v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15i_BFs15s_BFu15s) C1{ Fi:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15i_BFs15i_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15i_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15i_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFs15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFs15s_BFu15s, BFs15i_BFs15i_BFs15s_BFu15s)
//============================================================================


struct  BFs15i_BFs15i_BFu15i  {
  signed int v1:15;
  signed int v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15i_BFs15i_BFu15i) C1{ Fi:15 Fi:15 Fi:15}



static void Test_BFs15i_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15i, BFs15i_BFs15i_BFu15i)
//============================================================================


struct  BFs15i_BFs15i_BFu15i_BFs15i  {
  signed int v1:15;
  signed int v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15i_BFs15i) C1{ Fi:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15i_BFs15i_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15i_BFs15i, BFs15i_BFs15i_BFu15i_BFs15i)
//============================================================================


struct  BFs15i_BFs15i_BFu15i_BFs15ll  {
  signed int v1:15;
  signed int v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15i_BFs15ll) C1{ Fi:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15i_BFs15i_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15i_BFs15ll, BFs15i_BFs15i_BFu15i_BFs15ll)
//============================================================================


struct  BFs15i_BFs15i_BFu15i_BFs15s  {
  signed int v1:15;
  signed int v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15i_BFs15s) C1{ Fi:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15i_BFs15i_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15i_BFs15s, BFs15i_BFs15i_BFu15i_BFs15s)
//============================================================================


struct  BFs15i_BFs15i_BFu15i_BFu15i  {
  signed int v1:15;
  signed int v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15i_BFu15i) C1{ Fi:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15i_BFs15i_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15i_BFu15i, BFs15i_BFs15i_BFu15i_BFu15i)
//============================================================================


struct  BFs15i_BFs15i_BFu15i_BFu15ll  {
  signed int v1:15;
  signed int v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15i_BFu15ll) C1{ Fi:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15i_BFs15i_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15i_BFu15ll, BFs15i_BFs15i_BFu15i_BFu15ll)
//============================================================================


struct  BFs15i_BFs15i_BFu15i_BFu15s  {
  signed int v1:15;
  signed int v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15i_BFu15s) C1{ Fi:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15i_BFs15i_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15i_BFu15s, BFs15i_BFs15i_BFu15i_BFu15s)
//============================================================================


struct  BFs15i_BFs15i_BFu15ll  {
  signed int v1:15;
  signed int v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15i_BFs15i_BFu15ll) C1{ Fi:15 Fi:15 FL:15}



static void Test_BFs15i_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15ll, BFs15i_BFs15i_BFu15ll)
//============================================================================


struct  BFs15i_BFs15i_BFu15ll_BFs15i  {
  signed int v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15ll_BFs15i) C1{ Fi:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15i_BFs15i_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15ll_BFs15i, BFs15i_BFs15i_BFu15ll_BFs15i)
//============================================================================


struct  BFs15i_BFs15i_BFu15ll_BFs15ll  {
  signed int v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15ll_BFs15ll) C1{ Fi:15 Fi:15 FL:15 FL:15}



static void Test_BFs15i_BFs15i_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15ll_BFs15ll, BFs15i_BFs15i_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15i_BFs15i_BFu15ll_BFs15s  {
  signed int v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15ll_BFs15s) C1{ Fi:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15i_BFs15i_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15ll_BFs15s, BFs15i_BFs15i_BFu15ll_BFs15s)
//============================================================================


struct  BFs15i_BFs15i_BFu15ll_BFu15i  {
  signed int v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15ll_BFu15i) C1{ Fi:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15i_BFs15i_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15ll_BFu15i, BFs15i_BFs15i_BFu15ll_BFu15i)
//============================================================================


struct  BFs15i_BFs15i_BFu15ll_BFu15ll  {
  signed int v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15ll_BFu15ll) C1{ Fi:15 Fi:15 FL:15 FL:15}



static void Test_BFs15i_BFs15i_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15ll_BFu15ll, BFs15i_BFs15i_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15i_BFs15i_BFu15ll_BFu15s  {
  signed int v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15ll_BFu15s) C1{ Fi:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15i_BFs15i_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15ll_BFu15s, BFs15i_BFs15i_BFu15ll_BFu15s)
//============================================================================


struct  BFs15i_BFs15i_BFu15s  {
  signed int v1:15;
  signed int v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15i_BFs15i_BFu15s) C1{ Fi:15 Fi:15 Fs:15}



static void Test_BFs15i_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15s, BFs15i_BFs15i_BFu15s)
//============================================================================


struct  BFs15i_BFs15i_BFu15s_BFs15i  {
  signed int v1:15;
  signed int v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15s_BFs15i) C1{ Fi:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15i_BFs15i_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15s_BFs15i, BFs15i_BFs15i_BFu15s_BFs15i)
//============================================================================


struct  BFs15i_BFs15i_BFu15s_BFs15ll  {
  signed int v1:15;
  signed int v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15s_BFs15ll) C1{ Fi:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15i_BFs15i_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15s_BFs15ll, BFs15i_BFs15i_BFu15s_BFs15ll)
//============================================================================


struct  BFs15i_BFs15i_BFu15s_BFs15s  {
  signed int v1:15;
  signed int v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15s_BFs15s) C1{ Fi:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15i_BFs15i_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15s_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15s_BFs15s, BFs15i_BFs15i_BFu15s_BFs15s)
//============================================================================


struct  BFs15i_BFs15i_BFu15s_BFu15i  {
  signed int v1:15;
  signed int v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15s_BFu15i) C1{ Fi:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15i_BFs15i_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15s_BFu15i, BFs15i_BFs15i_BFu15s_BFu15i)
//============================================================================


struct  BFs15i_BFs15i_BFu15s_BFu15ll  {
  signed int v1:15;
  signed int v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15s_BFu15ll) C1{ Fi:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15i_BFs15i_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15i_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15s_BFu15ll, BFs15i_BFs15i_BFu15s_BFu15ll)
//============================================================================


struct  BFs15i_BFs15i_BFu15s_BFu15s  {
  signed int v1:15;
  signed int v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15i_BFu15s_BFu15s) C1{ Fi:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15i_BFs15i_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15i_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15i_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15i_BFu15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15i_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15i_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15i_BFu15s_BFu15s, BFs15i_BFs15i_BFu15s_BFu15s)
//============================================================================


struct  BFs15i_BFs15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
};
//SIG(1 BFs15i_BFs15ll) C1{ Fi:15 FL:15}



static void Test_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll, BFs15i_BFs15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFs15i  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15i) C1{ Fi:15 FL:15 Fi:15}



static void Test_BFs15i_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15i, BFs15i_BFs15ll_BFs15i)
//============================================================================


struct  BFs15i_BFs15ll_BFs15i_BFs15i  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15i_BFs15i) C1{ Fi:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15i_BFs15ll_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15i_BFs15i, BFs15i_BFs15ll_BFs15i_BFs15i)
//============================================================================


struct  BFs15i_BFs15ll_BFs15i_BFs15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15i_BFs15ll) C1{ Fi:15 FL:15 Fi:15 FL:15}



static void Test_BFs15i_BFs15ll_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15i_BFs15ll, BFs15i_BFs15ll_BFs15i_BFs15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFs15i_BFs15s  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15i_BFs15s) C1{ Fi:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15i_BFs15ll_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15i_BFs15s, BFs15i_BFs15ll_BFs15i_BFs15s)
//============================================================================


struct  BFs15i_BFs15ll_BFs15i_BFu15i  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15i_BFu15i) C1{ Fi:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15i_BFs15ll_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15i_BFu15i, BFs15i_BFs15ll_BFs15i_BFu15i)
//============================================================================


struct  BFs15i_BFs15ll_BFs15i_BFu15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15i_BFu15ll) C1{ Fi:15 FL:15 Fi:15 FL:15}



static void Test_BFs15i_BFs15ll_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15i_BFu15ll, BFs15i_BFs15ll_BFs15i_BFu15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFs15i_BFu15s  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15i_BFu15s) C1{ Fi:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15i_BFs15ll_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15i_BFu15s, BFs15i_BFs15ll_BFs15i_BFu15s)
//============================================================================


struct  BFs15i_BFs15ll_BFs15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15ll) C1{ Fi:15 FL:15 FL:15}



static void Test_BFs15i_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15ll, BFs15i_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFs15ll_BFs15i  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15ll_BFs15i) C1{ Fi:15 FL:15 FL:15 Fi:15}



static void Test_BFs15i_BFs15ll_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15ll_BFs15i, BFs15i_BFs15ll_BFs15ll_BFs15i)
//============================================================================


struct  BFs15i_BFs15ll_BFs15ll_BFs15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15ll_BFs15ll) C1{ Fi:15 FL:15 FL:15 FL:15}



static void Test_BFs15i_BFs15ll_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15ll_BFs15ll, BFs15i_BFs15ll_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFs15ll_BFs15s  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15ll_BFs15s) C1{ Fi:15 FL:15 FL:15 Fs:15}



static void Test_BFs15i_BFs15ll_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15ll_BFs15s, BFs15i_BFs15ll_BFs15ll_BFs15s)
//============================================================================


struct  BFs15i_BFs15ll_BFs15ll_BFu15i  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15ll_BFu15i) C1{ Fi:15 FL:15 FL:15 Fi:15}



static void Test_BFs15i_BFs15ll_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15ll_BFu15i, BFs15i_BFs15ll_BFs15ll_BFu15i)
//============================================================================


struct  BFs15i_BFs15ll_BFs15ll_BFu15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15ll_BFu15ll) C1{ Fi:15 FL:15 FL:15 FL:15}



static void Test_BFs15i_BFs15ll_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15ll_BFu15ll, BFs15i_BFs15ll_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFs15ll_BFu15s  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15ll_BFu15s) C1{ Fi:15 FL:15 FL:15 Fs:15}



static void Test_BFs15i_BFs15ll_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15ll_BFu15s, BFs15i_BFs15ll_BFs15ll_BFu15s)
//============================================================================


struct  BFs15i_BFs15ll_BFs15s  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15s) C1{ Fi:15 FL:15 Fs:15}



static void Test_BFs15i_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15s, BFs15i_BFs15ll_BFs15s)
//============================================================================


struct  BFs15i_BFs15ll_BFs15s_BFs15i  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15s_BFs15i) C1{ Fi:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15i_BFs15ll_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15s_BFs15i, BFs15i_BFs15ll_BFs15s_BFs15i)
//============================================================================


struct  BFs15i_BFs15ll_BFs15s_BFs15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15s_BFs15ll) C1{ Fi:15 FL:15 Fs:15 FL:15}



static void Test_BFs15i_BFs15ll_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15s_BFs15ll, BFs15i_BFs15ll_BFs15s_BFs15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFs15s_BFs15s  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15s_BFs15s) C1{ Fi:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15i_BFs15ll_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15s_BFs15s, BFs15i_BFs15ll_BFs15s_BFs15s)
//============================================================================


struct  BFs15i_BFs15ll_BFs15s_BFu15i  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15s_BFu15i) C1{ Fi:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15i_BFs15ll_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15s_BFu15i, BFs15i_BFs15ll_BFs15s_BFu15i)
//============================================================================


struct  BFs15i_BFs15ll_BFs15s_BFu15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15s_BFu15ll) C1{ Fi:15 FL:15 Fs:15 FL:15}



static void Test_BFs15i_BFs15ll_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15s_BFu15ll, BFs15i_BFs15ll_BFs15s_BFu15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFs15s_BFu15s  {
  signed int v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFs15s_BFu15s) C1{ Fi:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15i_BFs15ll_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15ll_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFs15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFs15s_BFu15s, BFs15i_BFs15ll_BFs15s_BFu15s)
//============================================================================


struct  BFs15i_BFs15ll_BFu15i  {
  signed int v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15i) C1{ Fi:15 FL:15 Fi:15}



static void Test_BFs15i_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15i, BFs15i_BFs15ll_BFu15i)
//============================================================================


struct  BFs15i_BFs15ll_BFu15i_BFs15i  {
  signed int v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15i_BFs15i) C1{ Fi:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15i_BFs15ll_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15i_BFs15i, BFs15i_BFs15ll_BFu15i_BFs15i)
//============================================================================


struct  BFs15i_BFs15ll_BFu15i_BFs15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15i_BFs15ll) C1{ Fi:15 FL:15 Fi:15 FL:15}



static void Test_BFs15i_BFs15ll_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15i_BFs15ll, BFs15i_BFs15ll_BFu15i_BFs15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFu15i_BFs15s  {
  signed int v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15i_BFs15s) C1{ Fi:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15i_BFs15ll_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15i_BFs15s, BFs15i_BFs15ll_BFu15i_BFs15s)
//============================================================================


struct  BFs15i_BFs15ll_BFu15i_BFu15i  {
  signed int v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15i_BFu15i) C1{ Fi:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15i_BFs15ll_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15i_BFu15i, BFs15i_BFs15ll_BFu15i_BFu15i)
//============================================================================


struct  BFs15i_BFs15ll_BFu15i_BFu15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15i_BFu15ll) C1{ Fi:15 FL:15 Fi:15 FL:15}



static void Test_BFs15i_BFs15ll_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15i_BFu15ll, BFs15i_BFs15ll_BFu15i_BFu15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFu15i_BFu15s  {
  signed int v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15i_BFu15s) C1{ Fi:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15i_BFs15ll_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15i_BFu15s, BFs15i_BFs15ll_BFu15i_BFu15s)
//============================================================================


struct  BFs15i_BFs15ll_BFu15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15ll) C1{ Fi:15 FL:15 FL:15}



static void Test_BFs15i_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15ll, BFs15i_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFu15ll_BFs15i  {
  signed int v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15ll_BFs15i) C1{ Fi:15 FL:15 FL:15 Fi:15}



static void Test_BFs15i_BFs15ll_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15ll_BFs15i, BFs15i_BFs15ll_BFu15ll_BFs15i)
//============================================================================


struct  BFs15i_BFs15ll_BFu15ll_BFs15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15ll_BFs15ll) C1{ Fi:15 FL:15 FL:15 FL:15}



static void Test_BFs15i_BFs15ll_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15ll_BFs15ll, BFs15i_BFs15ll_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFu15ll_BFs15s  {
  signed int v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15ll_BFs15s) C1{ Fi:15 FL:15 FL:15 Fs:15}



static void Test_BFs15i_BFs15ll_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15ll_BFs15s, BFs15i_BFs15ll_BFu15ll_BFs15s)
//============================================================================


struct  BFs15i_BFs15ll_BFu15ll_BFu15i  {
  signed int v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15ll_BFu15i) C1{ Fi:15 FL:15 FL:15 Fi:15}



static void Test_BFs15i_BFs15ll_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15ll_BFu15i, BFs15i_BFs15ll_BFu15ll_BFu15i)
//============================================================================


struct  BFs15i_BFs15ll_BFu15ll_BFu15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15ll_BFu15ll) C1{ Fi:15 FL:15 FL:15 FL:15}



static void Test_BFs15i_BFs15ll_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15ll_BFu15ll, BFs15i_BFs15ll_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFu15ll_BFu15s  {
  signed int v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15ll_BFu15s) C1{ Fi:15 FL:15 FL:15 Fs:15}



static void Test_BFs15i_BFs15ll_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15ll_BFu15s, BFs15i_BFs15ll_BFu15ll_BFu15s)
//============================================================================


struct  BFs15i_BFs15ll_BFu15s  {
  signed int v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15s) C1{ Fi:15 FL:15 Fs:15}



static void Test_BFs15i_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15s, BFs15i_BFs15ll_BFu15s)
//============================================================================


struct  BFs15i_BFs15ll_BFu15s_BFs15i  {
  signed int v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15s_BFs15i) C1{ Fi:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15i_BFs15ll_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15s_BFs15i, BFs15i_BFs15ll_BFu15s_BFs15i)
//============================================================================


struct  BFs15i_BFs15ll_BFu15s_BFs15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15s_BFs15ll) C1{ Fi:15 FL:15 Fs:15 FL:15}



static void Test_BFs15i_BFs15ll_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15s_BFs15ll, BFs15i_BFs15ll_BFu15s_BFs15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFu15s_BFs15s  {
  signed int v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15s_BFs15s) C1{ Fi:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15i_BFs15ll_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15s_BFs15s, BFs15i_BFs15ll_BFu15s_BFs15s)
//============================================================================


struct  BFs15i_BFs15ll_BFu15s_BFu15i  {
  signed int v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15s_BFu15i) C1{ Fi:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15i_BFs15ll_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15s_BFu15i, BFs15i_BFs15ll_BFu15s_BFu15i)
//============================================================================


struct  BFs15i_BFs15ll_BFu15s_BFu15ll  {
  signed int v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15s_BFu15ll) C1{ Fi:15 FL:15 Fs:15 FL:15}



static void Test_BFs15i_BFs15ll_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15s_BFu15ll, BFs15i_BFs15ll_BFu15s_BFu15ll)
//============================================================================


struct  BFs15i_BFs15ll_BFu15s_BFu15s  {
  signed int v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15ll_BFu15s_BFu15s) C1{ Fi:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15i_BFs15ll_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15ll_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15ll_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15ll_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15ll_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15ll_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15ll_BFu15s_BFu15s, BFs15i_BFs15ll_BFu15s_BFu15s)
//============================================================================


struct  BFs15i_BFs15s  {
  signed int v1:15;
  signed short v2:15;
};
//SIG(1 BFs15i_BFs15s) C1{ Fi:15 Fs:15}



static void Test_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15s lv;
    check2(sizeof(lv), 4, "sizeof(BFs15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s, BFs15i_BFs15s)
//============================================================================


struct  BFs15i_BFs15s_BFs15i  {
  signed int v1:15;
  signed short v2:15;
  signed int v3:15;
};
//SIG(1 BFs15i_BFs15s_BFs15i) C1{ Fi:15 Fs:15 Fi:15}



static void Test_BFs15i_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15i, BFs15i_BFs15s_BFs15i)
//============================================================================


struct  BFs15i_BFs15s_BFs15i_BFs15i  {
  signed int v1:15;
  signed short v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15i_BFs15i) C1{ Fi:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15i_BFs15s_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15i_BFs15i, BFs15i_BFs15s_BFs15i_BFs15i)
//============================================================================


struct  BFs15i_BFs15s_BFs15i_BFs15ll  {
  signed int v1:15;
  signed short v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15i_BFs15ll) C1{ Fi:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15i_BFs15s_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15i_BFs15ll, BFs15i_BFs15s_BFs15i_BFs15ll)
//============================================================================


struct  BFs15i_BFs15s_BFs15i_BFs15s  {
  signed int v1:15;
  signed short v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15i_BFs15s) C1{ Fi:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15i_BFs15s_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15i_BFs15s, BFs15i_BFs15s_BFs15i_BFs15s)
//============================================================================


struct  BFs15i_BFs15s_BFs15i_BFu15i  {
  signed int v1:15;
  signed short v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15i_BFu15i) C1{ Fi:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15i_BFs15s_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15i_BFu15i, BFs15i_BFs15s_BFs15i_BFu15i)
//============================================================================


struct  BFs15i_BFs15s_BFs15i_BFu15ll  {
  signed int v1:15;
  signed short v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15i_BFu15ll) C1{ Fi:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15i_BFs15s_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15i_BFu15ll, BFs15i_BFs15s_BFs15i_BFu15ll)
//============================================================================


struct  BFs15i_BFs15s_BFs15i_BFu15s  {
  signed int v1:15;
  signed short v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15i_BFu15s) C1{ Fi:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15i_BFs15s_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15i_BFu15s, BFs15i_BFs15s_BFs15i_BFu15s)
//============================================================================


struct  BFs15i_BFs15s_BFs15ll  {
  signed int v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15i_BFs15s_BFs15ll) C1{ Fi:15 Fs:15 FL:15}



static void Test_BFs15i_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15ll, BFs15i_BFs15s_BFs15ll)
//============================================================================


struct  BFs15i_BFs15s_BFs15ll_BFs15i  {
  signed int v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15ll_BFs15i) C1{ Fi:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15i_BFs15s_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15ll_BFs15i, BFs15i_BFs15s_BFs15ll_BFs15i)
//============================================================================


struct  BFs15i_BFs15s_BFs15ll_BFs15ll  {
  signed int v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15ll_BFs15ll) C1{ Fi:15 Fs:15 FL:15 FL:15}



static void Test_BFs15i_BFs15s_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15ll_BFs15ll, BFs15i_BFs15s_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15i_BFs15s_BFs15ll_BFs15s  {
  signed int v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15ll_BFs15s) C1{ Fi:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15i_BFs15s_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15ll_BFs15s, BFs15i_BFs15s_BFs15ll_BFs15s)
//============================================================================


struct  BFs15i_BFs15s_BFs15ll_BFu15i  {
  signed int v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15ll_BFu15i) C1{ Fi:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15i_BFs15s_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15ll_BFu15i, BFs15i_BFs15s_BFs15ll_BFu15i)
//============================================================================


struct  BFs15i_BFs15s_BFs15ll_BFu15ll  {
  signed int v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15ll_BFu15ll) C1{ Fi:15 Fs:15 FL:15 FL:15}



static void Test_BFs15i_BFs15s_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15ll_BFu15ll, BFs15i_BFs15s_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15i_BFs15s_BFs15ll_BFu15s  {
  signed int v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15ll_BFu15s) C1{ Fi:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15i_BFs15s_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15ll_BFu15s, BFs15i_BFs15s_BFs15ll_BFu15s)
//============================================================================


struct  BFs15i_BFs15s_BFs15s  {
  signed int v1:15;
  signed short v2:15;
  signed short v3:15;
};
//SIG(1 BFs15i_BFs15s_BFs15s) C1{ Fi:15 Fs:15 Fs:15}



static void Test_BFs15i_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15s, BFs15i_BFs15s_BFs15s)
//============================================================================


struct  BFs15i_BFs15s_BFs15s_BFs15i  {
  signed int v1:15;
  signed short v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15s_BFs15i) C1{ Fi:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15i_BFs15s_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15s_BFs15i, BFs15i_BFs15s_BFs15s_BFs15i)
//============================================================================


struct  BFs15i_BFs15s_BFs15s_BFs15ll  {
  signed int v1:15;
  signed short v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15s_BFs15ll) C1{ Fi:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15i_BFs15s_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15s_BFs15ll, BFs15i_BFs15s_BFs15s_BFs15ll)
//============================================================================


struct  BFs15i_BFs15s_BFs15s_BFs15s  {
  signed int v1:15;
  signed short v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15s_BFs15s) C1{ Fi:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15i_BFs15s_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15s_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15s_BFs15s, BFs15i_BFs15s_BFs15s_BFs15s)
//============================================================================


struct  BFs15i_BFs15s_BFs15s_BFu15i  {
  signed int v1:15;
  signed short v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15s_BFu15i) C1{ Fi:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15i_BFs15s_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15s_BFu15i, BFs15i_BFs15s_BFs15s_BFu15i)
//============================================================================


struct  BFs15i_BFs15s_BFs15s_BFu15ll  {
  signed int v1:15;
  signed short v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15s_BFu15ll) C1{ Fi:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15i_BFs15s_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15s_BFu15ll, BFs15i_BFs15s_BFs15s_BFu15ll)
//============================================================================


struct  BFs15i_BFs15s_BFs15s_BFu15s  {
  signed int v1:15;
  signed short v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15s_BFs15s_BFu15s) C1{ Fi:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15i_BFs15s_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15s_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15s_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFs15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFs15s_BFu15s, BFs15i_BFs15s_BFs15s_BFu15s)
//============================================================================


struct  BFs15i_BFs15s_BFu15i  {
  signed int v1:15;
  signed short v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15i_BFs15s_BFu15i) C1{ Fi:15 Fs:15 Fi:15}



static void Test_BFs15i_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15i, BFs15i_BFs15s_BFu15i)
//============================================================================


struct  BFs15i_BFs15s_BFu15i_BFs15i  {
  signed int v1:15;
  signed short v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15i_BFs15i) C1{ Fi:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15i_BFs15s_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15i_BFs15i, BFs15i_BFs15s_BFu15i_BFs15i)
//============================================================================


struct  BFs15i_BFs15s_BFu15i_BFs15ll  {
  signed int v1:15;
  signed short v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15i_BFs15ll) C1{ Fi:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15i_BFs15s_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15i_BFs15ll, BFs15i_BFs15s_BFu15i_BFs15ll)
//============================================================================


struct  BFs15i_BFs15s_BFu15i_BFs15s  {
  signed int v1:15;
  signed short v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15i_BFs15s) C1{ Fi:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15i_BFs15s_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15i_BFs15s, BFs15i_BFs15s_BFu15i_BFs15s)
//============================================================================


struct  BFs15i_BFs15s_BFu15i_BFu15i  {
  signed int v1:15;
  signed short v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15i_BFu15i) C1{ Fi:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15i_BFs15s_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15i_BFu15i, BFs15i_BFs15s_BFu15i_BFu15i)
//============================================================================


struct  BFs15i_BFs15s_BFu15i_BFu15ll  {
  signed int v1:15;
  signed short v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15i_BFu15ll) C1{ Fi:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15i_BFs15s_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15i_BFu15ll, BFs15i_BFs15s_BFu15i_BFu15ll)
//============================================================================


struct  BFs15i_BFs15s_BFu15i_BFu15s  {
  signed int v1:15;
  signed short v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15i_BFu15s) C1{ Fi:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15i_BFs15s_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15i_BFu15s, BFs15i_BFs15s_BFu15i_BFu15s)
//============================================================================


struct  BFs15i_BFs15s_BFu15ll  {
  signed int v1:15;
  signed short v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15i_BFs15s_BFu15ll) C1{ Fi:15 Fs:15 FL:15}



static void Test_BFs15i_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15ll, BFs15i_BFs15s_BFu15ll)
//============================================================================


struct  BFs15i_BFs15s_BFu15ll_BFs15i  {
  signed int v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15ll_BFs15i) C1{ Fi:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15i_BFs15s_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15ll_BFs15i, BFs15i_BFs15s_BFu15ll_BFs15i)
//============================================================================


struct  BFs15i_BFs15s_BFu15ll_BFs15ll  {
  signed int v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15ll_BFs15ll) C1{ Fi:15 Fs:15 FL:15 FL:15}



static void Test_BFs15i_BFs15s_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15ll_BFs15ll, BFs15i_BFs15s_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15i_BFs15s_BFu15ll_BFs15s  {
  signed int v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15ll_BFs15s) C1{ Fi:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15i_BFs15s_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15ll_BFs15s, BFs15i_BFs15s_BFu15ll_BFs15s)
//============================================================================


struct  BFs15i_BFs15s_BFu15ll_BFu15i  {
  signed int v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15ll_BFu15i) C1{ Fi:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15i_BFs15s_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15ll_BFu15i, BFs15i_BFs15s_BFu15ll_BFu15i)
//============================================================================


struct  BFs15i_BFs15s_BFu15ll_BFu15ll  {
  signed int v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15ll_BFu15ll) C1{ Fi:15 Fs:15 FL:15 FL:15}



static void Test_BFs15i_BFs15s_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15ll_BFu15ll, BFs15i_BFs15s_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15i_BFs15s_BFu15ll_BFu15s  {
  signed int v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15ll_BFu15s) C1{ Fi:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15i_BFs15s_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15ll_BFu15s, BFs15i_BFs15s_BFu15ll_BFu15s)
//============================================================================


struct  BFs15i_BFs15s_BFu15s  {
  signed int v1:15;
  signed short v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15i_BFs15s_BFu15s) C1{ Fi:15 Fs:15 Fs:15}



static void Test_BFs15i_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15s, BFs15i_BFs15s_BFu15s)
//============================================================================


struct  BFs15i_BFs15s_BFu15s_BFs15i  {
  signed int v1:15;
  signed short v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15s_BFs15i) C1{ Fi:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15i_BFs15s_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15s_BFs15i, BFs15i_BFs15s_BFu15s_BFs15i)
//============================================================================


struct  BFs15i_BFs15s_BFu15s_BFs15ll  {
  signed int v1:15;
  signed short v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15s_BFs15ll) C1{ Fi:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15i_BFs15s_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15s_BFs15ll, BFs15i_BFs15s_BFu15s_BFs15ll)
//============================================================================


struct  BFs15i_BFs15s_BFu15s_BFs15s  {
  signed int v1:15;
  signed short v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15s_BFs15s) C1{ Fi:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15i_BFs15s_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15s_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15s_BFs15s, BFs15i_BFs15s_BFu15s_BFs15s)
//============================================================================


struct  BFs15i_BFs15s_BFu15s_BFu15i  {
  signed int v1:15;
  signed short v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15s_BFu15i) C1{ Fi:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15i_BFs15s_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15s_BFu15i, BFs15i_BFs15s_BFu15s_BFu15i)
//============================================================================


struct  BFs15i_BFs15s_BFu15s_BFu15ll  {
  signed int v1:15;
  signed short v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15s_BFu15ll) C1{ Fi:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15i_BFs15s_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFs15s_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15s_BFu15ll, BFs15i_BFs15s_BFu15s_BFu15ll)
//============================================================================


struct  BFs15i_BFs15s_BFu15s_BFu15s  {
  signed int v1:15;
  signed short v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFs15s_BFu15s_BFu15s) C1{ Fi:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15i_BFs15s_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15i_BFs15s_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15i_BFs15s_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFs15s_BFu15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFs15s_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15i_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFs15s_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFs15s_BFu15s_BFu15s, BFs15i_BFs15s_BFu15s_BFu15s)
//============================================================================


struct  BFs15i_BFu15i  {
  signed int v1:15;
  unsigned int v2:15;
};
//SIG(1 BFs15i_BFu15i) C1{ Fi:15 Fi:15}



static void Test_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFs15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i, BFs15i_BFu15i)
//============================================================================


struct  BFs15i_BFu15i_BFs15i  {
  signed int v1:15;
  unsigned int v2:15;
  signed int v3:15;
};
//SIG(1 BFs15i_BFu15i_BFs15i) C1{ Fi:15 Fi:15 Fi:15}



static void Test_BFs15i_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15i, BFs15i_BFu15i_BFs15i)
//============================================================================


struct  BFs15i_BFu15i_BFs15i_BFs15i  {
  signed int v1:15;
  unsigned int v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15i_BFs15i) C1{ Fi:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15i_BFu15i_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15i_BFs15i, BFs15i_BFu15i_BFs15i_BFs15i)
//============================================================================


struct  BFs15i_BFu15i_BFs15i_BFs15ll  {
  signed int v1:15;
  unsigned int v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15i_BFs15ll) C1{ Fi:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15i_BFu15i_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15i_BFs15ll, BFs15i_BFu15i_BFs15i_BFs15ll)
//============================================================================


struct  BFs15i_BFu15i_BFs15i_BFs15s  {
  signed int v1:15;
  unsigned int v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15i_BFs15s) C1{ Fi:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15i_BFu15i_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15i_BFs15s, BFs15i_BFu15i_BFs15i_BFs15s)
//============================================================================


struct  BFs15i_BFu15i_BFs15i_BFu15i  {
  signed int v1:15;
  unsigned int v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15i_BFu15i) C1{ Fi:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15i_BFu15i_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15i_BFu15i, BFs15i_BFu15i_BFs15i_BFu15i)
//============================================================================


struct  BFs15i_BFu15i_BFs15i_BFu15ll  {
  signed int v1:15;
  unsigned int v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15i_BFu15ll) C1{ Fi:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15i_BFu15i_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15i_BFu15ll, BFs15i_BFu15i_BFs15i_BFu15ll)
//============================================================================


struct  BFs15i_BFu15i_BFs15i_BFu15s  {
  signed int v1:15;
  unsigned int v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15i_BFu15s) C1{ Fi:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15i_BFu15i_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15i_BFu15s, BFs15i_BFu15i_BFs15i_BFu15s)
//============================================================================


struct  BFs15i_BFu15i_BFs15ll  {
  signed int v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15i_BFu15i_BFs15ll) C1{ Fi:15 Fi:15 FL:15}



static void Test_BFs15i_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15ll, BFs15i_BFu15i_BFs15ll)
//============================================================================


struct  BFs15i_BFu15i_BFs15ll_BFs15i  {
  signed int v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15ll_BFs15i) C1{ Fi:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15i_BFu15i_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15ll_BFs15i, BFs15i_BFu15i_BFs15ll_BFs15i)
//============================================================================


struct  BFs15i_BFu15i_BFs15ll_BFs15ll  {
  signed int v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15ll_BFs15ll) C1{ Fi:15 Fi:15 FL:15 FL:15}



static void Test_BFs15i_BFu15i_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15ll_BFs15ll, BFs15i_BFu15i_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15i_BFu15i_BFs15ll_BFs15s  {
  signed int v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15ll_BFs15s) C1{ Fi:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15i_BFu15i_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15ll_BFs15s, BFs15i_BFu15i_BFs15ll_BFs15s)
//============================================================================


struct  BFs15i_BFu15i_BFs15ll_BFu15i  {
  signed int v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15ll_BFu15i) C1{ Fi:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15i_BFu15i_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15ll_BFu15i, BFs15i_BFu15i_BFs15ll_BFu15i)
//============================================================================


struct  BFs15i_BFu15i_BFs15ll_BFu15ll  {
  signed int v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15ll_BFu15ll) C1{ Fi:15 Fi:15 FL:15 FL:15}



static void Test_BFs15i_BFu15i_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15ll_BFu15ll, BFs15i_BFu15i_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15i_BFu15i_BFs15ll_BFu15s  {
  signed int v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15ll_BFu15s) C1{ Fi:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15i_BFu15i_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15ll_BFu15s, BFs15i_BFu15i_BFs15ll_BFu15s)
//============================================================================


struct  BFs15i_BFu15i_BFs15s  {
  signed int v1:15;
  unsigned int v2:15;
  signed short v3:15;
};
//SIG(1 BFs15i_BFu15i_BFs15s) C1{ Fi:15 Fi:15 Fs:15}



static void Test_BFs15i_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15s, BFs15i_BFu15i_BFs15s)
//============================================================================


struct  BFs15i_BFu15i_BFs15s_BFs15i  {
  signed int v1:15;
  unsigned int v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15s_BFs15i) C1{ Fi:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15i_BFu15i_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15s_BFs15i, BFs15i_BFu15i_BFs15s_BFs15i)
//============================================================================


struct  BFs15i_BFu15i_BFs15s_BFs15ll  {
  signed int v1:15;
  unsigned int v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15s_BFs15ll) C1{ Fi:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15i_BFu15i_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15s_BFs15ll, BFs15i_BFu15i_BFs15s_BFs15ll)
//============================================================================


struct  BFs15i_BFu15i_BFs15s_BFs15s  {
  signed int v1:15;
  unsigned int v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15s_BFs15s) C1{ Fi:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15i_BFu15i_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15s_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15s_BFs15s, BFs15i_BFu15i_BFs15s_BFs15s)
//============================================================================


struct  BFs15i_BFu15i_BFs15s_BFu15i  {
  signed int v1:15;
  unsigned int v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15s_BFu15i) C1{ Fi:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15i_BFu15i_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15s_BFu15i, BFs15i_BFu15i_BFs15s_BFu15i)
//============================================================================


struct  BFs15i_BFu15i_BFs15s_BFu15ll  {
  signed int v1:15;
  unsigned int v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15s_BFu15ll) C1{ Fi:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15i_BFu15i_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15s_BFu15ll, BFs15i_BFu15i_BFs15s_BFu15ll)
//============================================================================


struct  BFs15i_BFu15i_BFs15s_BFu15s  {
  signed int v1:15;
  unsigned int v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15i_BFs15s_BFu15s) C1{ Fi:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15i_BFu15i_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15i_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15i_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFs15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFs15s_BFu15s, BFs15i_BFu15i_BFs15s_BFu15s)
//============================================================================


struct  BFs15i_BFu15i_BFu15i  {
  signed int v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15i_BFu15i_BFu15i) C1{ Fi:15 Fi:15 Fi:15}



static void Test_BFs15i_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15i, BFs15i_BFu15i_BFu15i)
//============================================================================


struct  BFs15i_BFu15i_BFu15i_BFs15i  {
  signed int v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15i_BFs15i) C1{ Fi:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15i_BFu15i_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15i_BFs15i, BFs15i_BFu15i_BFu15i_BFs15i)
//============================================================================


struct  BFs15i_BFu15i_BFu15i_BFs15ll  {
  signed int v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15i_BFs15ll) C1{ Fi:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15i_BFu15i_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15i_BFs15ll, BFs15i_BFu15i_BFu15i_BFs15ll)
//============================================================================


struct  BFs15i_BFu15i_BFu15i_BFs15s  {
  signed int v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15i_BFs15s) C1{ Fi:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15i_BFu15i_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15i_BFs15s, BFs15i_BFu15i_BFu15i_BFs15s)
//============================================================================


struct  BFs15i_BFu15i_BFu15i_BFu15i  {
  signed int v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15i_BFu15i) C1{ Fi:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15i_BFu15i_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15i_BFu15i, BFs15i_BFu15i_BFu15i_BFu15i)
//============================================================================


struct  BFs15i_BFu15i_BFu15i_BFu15ll  {
  signed int v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15i_BFu15ll) C1{ Fi:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15i_BFu15i_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15i_BFu15ll, BFs15i_BFu15i_BFu15i_BFu15ll)
//============================================================================


struct  BFs15i_BFu15i_BFu15i_BFu15s  {
  signed int v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15i_BFu15s) C1{ Fi:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15i_BFu15i_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15i_BFu15s, BFs15i_BFu15i_BFu15i_BFu15s)
//============================================================================


struct  BFs15i_BFu15i_BFu15ll  {
  signed int v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15i_BFu15i_BFu15ll) C1{ Fi:15 Fi:15 FL:15}



static void Test_BFs15i_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15ll, BFs15i_BFu15i_BFu15ll)
//============================================================================


struct  BFs15i_BFu15i_BFu15ll_BFs15i  {
  signed int v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15ll_BFs15i) C1{ Fi:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15i_BFu15i_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15ll_BFs15i, BFs15i_BFu15i_BFu15ll_BFs15i)
//============================================================================


struct  BFs15i_BFu15i_BFu15ll_BFs15ll  {
  signed int v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15ll_BFs15ll) C1{ Fi:15 Fi:15 FL:15 FL:15}



static void Test_BFs15i_BFu15i_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15ll_BFs15ll, BFs15i_BFu15i_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15i_BFu15i_BFu15ll_BFs15s  {
  signed int v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15ll_BFs15s) C1{ Fi:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15i_BFu15i_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15ll_BFs15s, BFs15i_BFu15i_BFu15ll_BFs15s)
//============================================================================


struct  BFs15i_BFu15i_BFu15ll_BFu15i  {
  signed int v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15ll_BFu15i) C1{ Fi:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15i_BFu15i_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15ll_BFu15i, BFs15i_BFu15i_BFu15ll_BFu15i)
//============================================================================


struct  BFs15i_BFu15i_BFu15ll_BFu15ll  {
  signed int v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15ll_BFu15ll) C1{ Fi:15 Fi:15 FL:15 FL:15}



static void Test_BFs15i_BFu15i_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15ll_BFu15ll, BFs15i_BFu15i_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15i_BFu15i_BFu15ll_BFu15s  {
  signed int v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15ll_BFu15s) C1{ Fi:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15i_BFu15i_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15ll_BFu15s, BFs15i_BFu15i_BFu15ll_BFu15s)
//============================================================================


struct  BFs15i_BFu15i_BFu15s  {
  signed int v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15i_BFu15i_BFu15s) C1{ Fi:15 Fi:15 Fs:15}



static void Test_BFs15i_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15s, BFs15i_BFu15i_BFu15s)
//============================================================================


struct  BFs15i_BFu15i_BFu15s_BFs15i  {
  signed int v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15s_BFs15i) C1{ Fi:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15i_BFu15i_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15s_BFs15i, BFs15i_BFu15i_BFu15s_BFs15i)
//============================================================================


struct  BFs15i_BFu15i_BFu15s_BFs15ll  {
  signed int v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15s_BFs15ll) C1{ Fi:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15i_BFu15i_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15s_BFs15ll, BFs15i_BFu15i_BFu15s_BFs15ll)
//============================================================================


struct  BFs15i_BFu15i_BFu15s_BFs15s  {
  signed int v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15s_BFs15s) C1{ Fi:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15i_BFu15i_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15s_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15s_BFs15s, BFs15i_BFu15i_BFu15s_BFs15s)
//============================================================================


struct  BFs15i_BFu15i_BFu15s_BFu15i  {
  signed int v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15s_BFu15i) C1{ Fi:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15i_BFu15i_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15s_BFu15i, BFs15i_BFu15i_BFu15s_BFu15i)
//============================================================================


struct  BFs15i_BFu15i_BFu15s_BFu15ll  {
  signed int v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15s_BFu15ll) C1{ Fi:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15i_BFu15i_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15i_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15s_BFu15ll, BFs15i_BFu15i_BFu15s_BFu15ll)
//============================================================================


struct  BFs15i_BFu15i_BFu15s_BFu15s  {
  signed int v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15i_BFu15s_BFu15s) C1{ Fi:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15i_BFu15i_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15i_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15i_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15i_BFu15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15i_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15i_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15i_BFu15s_BFu15s, BFs15i_BFu15i_BFu15s_BFu15s)
//============================================================================


struct  BFs15i_BFu15ll  {
  signed int v1:15;
  __tsu64 v2:15;
};
//SIG(1 BFs15i_BFu15ll) C1{ Fi:15 FL:15}



static void Test_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll, BFs15i_BFu15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFs15i  {
  signed int v1:15;
  __tsu64 v2:15;
  signed int v3:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15i) C1{ Fi:15 FL:15 Fi:15}



static void Test_BFs15i_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15i, BFs15i_BFu15ll_BFs15i)
//============================================================================


struct  BFs15i_BFu15ll_BFs15i_BFs15i  {
  signed int v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15i_BFs15i) C1{ Fi:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15i_BFu15ll_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15i_BFs15i, BFs15i_BFu15ll_BFs15i_BFs15i)
//============================================================================


struct  BFs15i_BFu15ll_BFs15i_BFs15ll  {
  signed int v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15i_BFs15ll) C1{ Fi:15 FL:15 Fi:15 FL:15}



static void Test_BFs15i_BFu15ll_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15i_BFs15ll, BFs15i_BFu15ll_BFs15i_BFs15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFs15i_BFs15s  {
  signed int v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15i_BFs15s) C1{ Fi:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15i_BFu15ll_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15i_BFs15s, BFs15i_BFu15ll_BFs15i_BFs15s)
//============================================================================


struct  BFs15i_BFu15ll_BFs15i_BFu15i  {
  signed int v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15i_BFu15i) C1{ Fi:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15i_BFu15ll_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15i_BFu15i, BFs15i_BFu15ll_BFs15i_BFu15i)
//============================================================================


struct  BFs15i_BFu15ll_BFs15i_BFu15ll  {
  signed int v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15i_BFu15ll) C1{ Fi:15 FL:15 Fi:15 FL:15}



static void Test_BFs15i_BFu15ll_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15i_BFu15ll, BFs15i_BFu15ll_BFs15i_BFu15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFs15i_BFu15s  {
  signed int v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15i_BFu15s) C1{ Fi:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15i_BFu15ll_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15i_BFu15s, BFs15i_BFu15ll_BFs15i_BFu15s)
//============================================================================


struct  BFs15i_BFu15ll_BFs15ll  {
  signed int v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15ll) C1{ Fi:15 FL:15 FL:15}



static void Test_BFs15i_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15ll, BFs15i_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFs15ll_BFs15i  {
  signed int v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15ll_BFs15i) C1{ Fi:15 FL:15 FL:15 Fi:15}



static void Test_BFs15i_BFu15ll_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15ll_BFs15i, BFs15i_BFu15ll_BFs15ll_BFs15i)
//============================================================================


struct  BFs15i_BFu15ll_BFs15ll_BFs15ll  {
  signed int v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15ll_BFs15ll) C1{ Fi:15 FL:15 FL:15 FL:15}



static void Test_BFs15i_BFu15ll_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15ll_BFs15ll, BFs15i_BFu15ll_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFs15ll_BFs15s  {
  signed int v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15ll_BFs15s) C1{ Fi:15 FL:15 FL:15 Fs:15}



static void Test_BFs15i_BFu15ll_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15ll_BFs15s, BFs15i_BFu15ll_BFs15ll_BFs15s)
//============================================================================


struct  BFs15i_BFu15ll_BFs15ll_BFu15i  {
  signed int v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15ll_BFu15i) C1{ Fi:15 FL:15 FL:15 Fi:15}



static void Test_BFs15i_BFu15ll_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15ll_BFu15i, BFs15i_BFu15ll_BFs15ll_BFu15i)
//============================================================================


struct  BFs15i_BFu15ll_BFs15ll_BFu15ll  {
  signed int v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15ll_BFu15ll) C1{ Fi:15 FL:15 FL:15 FL:15}



static void Test_BFs15i_BFu15ll_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15ll_BFu15ll, BFs15i_BFu15ll_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFs15ll_BFu15s  {
  signed int v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15ll_BFu15s) C1{ Fi:15 FL:15 FL:15 Fs:15}



static void Test_BFs15i_BFu15ll_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15ll_BFu15s, BFs15i_BFu15ll_BFs15ll_BFu15s)
//============================================================================


struct  BFs15i_BFu15ll_BFs15s  {
  signed int v1:15;
  __tsu64 v2:15;
  signed short v3:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15s) C1{ Fi:15 FL:15 Fs:15}



static void Test_BFs15i_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15s, BFs15i_BFu15ll_BFs15s)
//============================================================================


struct  BFs15i_BFu15ll_BFs15s_BFs15i  {
  signed int v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15s_BFs15i) C1{ Fi:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15i_BFu15ll_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15s_BFs15i, BFs15i_BFu15ll_BFs15s_BFs15i)
//============================================================================


struct  BFs15i_BFu15ll_BFs15s_BFs15ll  {
  signed int v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15s_BFs15ll) C1{ Fi:15 FL:15 Fs:15 FL:15}



static void Test_BFs15i_BFu15ll_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15s_BFs15ll, BFs15i_BFu15ll_BFs15s_BFs15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFs15s_BFs15s  {
  signed int v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15s_BFs15s) C1{ Fi:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15i_BFu15ll_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15s_BFs15s, BFs15i_BFu15ll_BFs15s_BFs15s)
//============================================================================


struct  BFs15i_BFu15ll_BFs15s_BFu15i  {
  signed int v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15s_BFu15i) C1{ Fi:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15i_BFu15ll_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15s_BFu15i, BFs15i_BFu15ll_BFs15s_BFu15i)
//============================================================================


struct  BFs15i_BFu15ll_BFs15s_BFu15ll  {
  signed int v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15s_BFu15ll) C1{ Fi:15 FL:15 Fs:15 FL:15}



static void Test_BFs15i_BFu15ll_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15s_BFu15ll, BFs15i_BFu15ll_BFs15s_BFu15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFs15s_BFu15s  {
  signed int v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFs15s_BFu15s) C1{ Fi:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15i_BFu15ll_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15ll_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFs15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFs15s_BFu15s, BFs15i_BFu15ll_BFs15s_BFu15s)
//============================================================================


struct  BFs15i_BFu15ll_BFu15i  {
  signed int v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15i) C1{ Fi:15 FL:15 Fi:15}



static void Test_BFs15i_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15i, BFs15i_BFu15ll_BFu15i)
//============================================================================


struct  BFs15i_BFu15ll_BFu15i_BFs15i  {
  signed int v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15i_BFs15i) C1{ Fi:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15i_BFu15ll_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15i_BFs15i, BFs15i_BFu15ll_BFu15i_BFs15i)
//============================================================================


struct  BFs15i_BFu15ll_BFu15i_BFs15ll  {
  signed int v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15i_BFs15ll) C1{ Fi:15 FL:15 Fi:15 FL:15}



static void Test_BFs15i_BFu15ll_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15i_BFs15ll, BFs15i_BFu15ll_BFu15i_BFs15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFu15i_BFs15s  {
  signed int v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15i_BFs15s) C1{ Fi:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15i_BFu15ll_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15i_BFs15s, BFs15i_BFu15ll_BFu15i_BFs15s)
//============================================================================


struct  BFs15i_BFu15ll_BFu15i_BFu15i  {
  signed int v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15i_BFu15i) C1{ Fi:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15i_BFu15ll_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15i_BFu15i, BFs15i_BFu15ll_BFu15i_BFu15i)
//============================================================================


struct  BFs15i_BFu15ll_BFu15i_BFu15ll  {
  signed int v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15i_BFu15ll) C1{ Fi:15 FL:15 Fi:15 FL:15}



static void Test_BFs15i_BFu15ll_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15i_BFu15ll, BFs15i_BFu15ll_BFu15i_BFu15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFu15i_BFu15s  {
  signed int v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15i_BFu15s) C1{ Fi:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15i_BFu15ll_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15i_BFu15s, BFs15i_BFu15ll_BFu15i_BFu15s)
//============================================================================


struct  BFs15i_BFu15ll_BFu15ll  {
  signed int v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15ll) C1{ Fi:15 FL:15 FL:15}



static void Test_BFs15i_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15ll, BFs15i_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFu15ll_BFs15i  {
  signed int v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15ll_BFs15i) C1{ Fi:15 FL:15 FL:15 Fi:15}



static void Test_BFs15i_BFu15ll_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15ll_BFs15i, BFs15i_BFu15ll_BFu15ll_BFs15i)
//============================================================================


struct  BFs15i_BFu15ll_BFu15ll_BFs15ll  {
  signed int v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15ll_BFs15ll) C1{ Fi:15 FL:15 FL:15 FL:15}



static void Test_BFs15i_BFu15ll_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15ll_BFs15ll, BFs15i_BFu15ll_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFu15ll_BFs15s  {
  signed int v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15ll_BFs15s) C1{ Fi:15 FL:15 FL:15 Fs:15}



static void Test_BFs15i_BFu15ll_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15ll_BFs15s, BFs15i_BFu15ll_BFu15ll_BFs15s)
//============================================================================


struct  BFs15i_BFu15ll_BFu15ll_BFu15i  {
  signed int v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15ll_BFu15i) C1{ Fi:15 FL:15 FL:15 Fi:15}



static void Test_BFs15i_BFu15ll_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15ll_BFu15i, BFs15i_BFu15ll_BFu15ll_BFu15i)
//============================================================================


struct  BFs15i_BFu15ll_BFu15ll_BFu15ll  {
  signed int v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15ll_BFu15ll) C1{ Fi:15 FL:15 FL:15 FL:15}



static void Test_BFs15i_BFu15ll_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15ll_BFu15ll, BFs15i_BFu15ll_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFu15ll_BFu15s  {
  signed int v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15ll_BFu15s) C1{ Fi:15 FL:15 FL:15 Fs:15}



static void Test_BFs15i_BFu15ll_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15ll_BFu15s, BFs15i_BFu15ll_BFu15ll_BFu15s)
//============================================================================


struct  BFs15i_BFu15ll_BFu15s  {
  signed int v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15s) C1{ Fi:15 FL:15 Fs:15}



static void Test_BFs15i_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15s, BFs15i_BFu15ll_BFu15s)
//============================================================================


struct  BFs15i_BFu15ll_BFu15s_BFs15i  {
  signed int v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15s_BFs15i) C1{ Fi:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15i_BFu15ll_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15s_BFs15i, BFs15i_BFu15ll_BFu15s_BFs15i)
//============================================================================


struct  BFs15i_BFu15ll_BFu15s_BFs15ll  {
  signed int v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15s_BFs15ll) C1{ Fi:15 FL:15 Fs:15 FL:15}



static void Test_BFs15i_BFu15ll_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15s_BFs15ll, BFs15i_BFu15ll_BFu15s_BFs15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFu15s_BFs15s  {
  signed int v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15s_BFs15s) C1{ Fi:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15i_BFu15ll_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15s_BFs15s, BFs15i_BFu15ll_BFu15s_BFs15s)
//============================================================================


struct  BFs15i_BFu15ll_BFu15s_BFu15i  {
  signed int v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15s_BFu15i) C1{ Fi:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15i_BFu15ll_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15s_BFu15i, BFs15i_BFu15ll_BFu15s_BFu15i)
//============================================================================


struct  BFs15i_BFu15ll_BFu15s_BFu15ll  {
  signed int v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15s_BFu15ll) C1{ Fi:15 FL:15 Fs:15 FL:15}



static void Test_BFs15i_BFu15ll_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15s_BFu15ll, BFs15i_BFu15ll_BFu15s_BFu15ll)
//============================================================================


struct  BFs15i_BFu15ll_BFu15s_BFu15s  {
  signed int v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15ll_BFu15s_BFu15s) C1{ Fi:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15i_BFu15ll_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15ll_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15ll_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15ll_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15ll_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15i_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15ll_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15ll_BFu15s_BFu15s, BFs15i_BFu15ll_BFu15s_BFu15s)
//============================================================================


struct  BFs15i_BFu15s  {
  signed int v1:15;
  unsigned short v2:15;
};
//SIG(1 BFs15i_BFu15s) C1{ Fi:15 Fs:15}



static void Test_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFs15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s, BFs15i_BFu15s)
//============================================================================


struct  BFs15i_BFu15s_BFs15i  {
  signed int v1:15;
  unsigned short v2:15;
  signed int v3:15;
};
//SIG(1 BFs15i_BFu15s_BFs15i) C1{ Fi:15 Fs:15 Fi:15}



static void Test_BFs15i_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15i, BFs15i_BFu15s_BFs15i)
//============================================================================


struct  BFs15i_BFu15s_BFs15i_BFs15i  {
  signed int v1:15;
  unsigned short v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15i_BFs15i) C1{ Fi:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15i_BFu15s_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15i_BFs15i, BFs15i_BFu15s_BFs15i_BFs15i)
//============================================================================


struct  BFs15i_BFu15s_BFs15i_BFs15ll  {
  signed int v1:15;
  unsigned short v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15i_BFs15ll) C1{ Fi:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15i_BFu15s_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15i_BFs15ll, BFs15i_BFu15s_BFs15i_BFs15ll)
//============================================================================


struct  BFs15i_BFu15s_BFs15i_BFs15s  {
  signed int v1:15;
  unsigned short v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15i_BFs15s) C1{ Fi:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15i_BFu15s_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15i_BFs15s, BFs15i_BFu15s_BFs15i_BFs15s)
//============================================================================


struct  BFs15i_BFu15s_BFs15i_BFu15i  {
  signed int v1:15;
  unsigned short v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15i_BFu15i) C1{ Fi:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15i_BFu15s_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15i_BFu15i, BFs15i_BFu15s_BFs15i_BFu15i)
//============================================================================


struct  BFs15i_BFu15s_BFs15i_BFu15ll  {
  signed int v1:15;
  unsigned short v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15i_BFu15ll) C1{ Fi:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15i_BFu15s_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15i_BFu15ll, BFs15i_BFu15s_BFs15i_BFu15ll)
//============================================================================


struct  BFs15i_BFu15s_BFs15i_BFu15s  {
  signed int v1:15;
  unsigned short v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15i_BFu15s) C1{ Fi:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15i_BFu15s_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15i_BFu15s, BFs15i_BFu15s_BFs15i_BFu15s)
//============================================================================


struct  BFs15i_BFu15s_BFs15ll  {
  signed int v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15i_BFu15s_BFs15ll) C1{ Fi:15 Fs:15 FL:15}



static void Test_BFs15i_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15ll, BFs15i_BFu15s_BFs15ll)
//============================================================================


struct  BFs15i_BFu15s_BFs15ll_BFs15i  {
  signed int v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15ll_BFs15i) C1{ Fi:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15i_BFu15s_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15ll_BFs15i, BFs15i_BFu15s_BFs15ll_BFs15i)
//============================================================================


struct  BFs15i_BFu15s_BFs15ll_BFs15ll  {
  signed int v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15ll_BFs15ll) C1{ Fi:15 Fs:15 FL:15 FL:15}



static void Test_BFs15i_BFu15s_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15ll_BFs15ll, BFs15i_BFu15s_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15i_BFu15s_BFs15ll_BFs15s  {
  signed int v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15ll_BFs15s) C1{ Fi:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15i_BFu15s_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15ll_BFs15s, BFs15i_BFu15s_BFs15ll_BFs15s)
//============================================================================


struct  BFs15i_BFu15s_BFs15ll_BFu15i  {
  signed int v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15ll_BFu15i) C1{ Fi:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15i_BFu15s_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15ll_BFu15i, BFs15i_BFu15s_BFs15ll_BFu15i)
//============================================================================


struct  BFs15i_BFu15s_BFs15ll_BFu15ll  {
  signed int v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15ll_BFu15ll) C1{ Fi:15 Fs:15 FL:15 FL:15}



static void Test_BFs15i_BFu15s_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15ll_BFu15ll, BFs15i_BFu15s_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15i_BFu15s_BFs15ll_BFu15s  {
  signed int v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15ll_BFu15s) C1{ Fi:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15i_BFu15s_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15ll_BFu15s, BFs15i_BFu15s_BFs15ll_BFu15s)
//============================================================================


struct  BFs15i_BFu15s_BFs15s  {
  signed int v1:15;
  unsigned short v2:15;
  signed short v3:15;
};
//SIG(1 BFs15i_BFu15s_BFs15s) C1{ Fi:15 Fs:15 Fs:15}



static void Test_BFs15i_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15s, BFs15i_BFu15s_BFs15s)
//============================================================================


struct  BFs15i_BFu15s_BFs15s_BFs15i  {
  signed int v1:15;
  unsigned short v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15s_BFs15i) C1{ Fi:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15i_BFu15s_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15s_BFs15i, BFs15i_BFu15s_BFs15s_BFs15i)
//============================================================================


struct  BFs15i_BFu15s_BFs15s_BFs15ll  {
  signed int v1:15;
  unsigned short v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15s_BFs15ll) C1{ Fi:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15i_BFu15s_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15s_BFs15ll, BFs15i_BFu15s_BFs15s_BFs15ll)
//============================================================================


struct  BFs15i_BFu15s_BFs15s_BFs15s  {
  signed int v1:15;
  unsigned short v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15s_BFs15s) C1{ Fi:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15i_BFu15s_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15s_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15s_BFs15s, BFs15i_BFu15s_BFs15s_BFs15s)
//============================================================================


struct  BFs15i_BFu15s_BFs15s_BFu15i  {
  signed int v1:15;
  unsigned short v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15s_BFu15i) C1{ Fi:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15i_BFu15s_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15s_BFu15i, BFs15i_BFu15s_BFs15s_BFu15i)
//============================================================================


struct  BFs15i_BFu15s_BFs15s_BFu15ll  {
  signed int v1:15;
  unsigned short v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15s_BFu15ll) C1{ Fi:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15i_BFu15s_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15s_BFu15ll, BFs15i_BFu15s_BFs15s_BFu15ll)
//============================================================================


struct  BFs15i_BFu15s_BFs15s_BFu15s  {
  signed int v1:15;
  unsigned short v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15s_BFs15s_BFu15s) C1{ Fi:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15i_BFu15s_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15s_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15s_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFs15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFs15s_BFu15s, BFs15i_BFu15s_BFs15s_BFu15s)
//============================================================================


struct  BFs15i_BFu15s_BFu15i  {
  signed int v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15i_BFu15s_BFu15i) C1{ Fi:15 Fs:15 Fi:15}



static void Test_BFs15i_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15i, BFs15i_BFu15s_BFu15i)
//============================================================================


struct  BFs15i_BFu15s_BFu15i_BFs15i  {
  signed int v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15i_BFs15i) C1{ Fi:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15i_BFu15s_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15i_BFs15i, BFs15i_BFu15s_BFu15i_BFs15i)
//============================================================================


struct  BFs15i_BFu15s_BFu15i_BFs15ll  {
  signed int v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15i_BFs15ll) C1{ Fi:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15i_BFu15s_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15i_BFs15ll, BFs15i_BFu15s_BFu15i_BFs15ll)
//============================================================================


struct  BFs15i_BFu15s_BFu15i_BFs15s  {
  signed int v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15i_BFs15s) C1{ Fi:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15i_BFu15s_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15i_BFs15s, BFs15i_BFu15s_BFu15i_BFs15s)
//============================================================================


struct  BFs15i_BFu15s_BFu15i_BFu15i  {
  signed int v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15i_BFu15i) C1{ Fi:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15i_BFu15s_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15i_BFu15i, BFs15i_BFu15s_BFu15i_BFu15i)
//============================================================================


struct  BFs15i_BFu15s_BFu15i_BFu15ll  {
  signed int v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15i_BFu15ll) C1{ Fi:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15i_BFu15s_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15i_BFu15ll, BFs15i_BFu15s_BFu15i_BFu15ll)
//============================================================================


struct  BFs15i_BFu15s_BFu15i_BFu15s  {
  signed int v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15i_BFu15s) C1{ Fi:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15i_BFu15s_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15i_BFu15s, BFs15i_BFu15s_BFu15i_BFu15s)
//============================================================================


struct  BFs15i_BFu15s_BFu15ll  {
  signed int v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15i_BFu15s_BFu15ll) C1{ Fi:15 Fs:15 FL:15}



static void Test_BFs15i_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15ll, BFs15i_BFu15s_BFu15ll)
//============================================================================


struct  BFs15i_BFu15s_BFu15ll_BFs15i  {
  signed int v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15ll_BFs15i) C1{ Fi:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15i_BFu15s_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15ll_BFs15i, BFs15i_BFu15s_BFu15ll_BFs15i)
//============================================================================


struct  BFs15i_BFu15s_BFu15ll_BFs15ll  {
  signed int v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15ll_BFs15ll) C1{ Fi:15 Fs:15 FL:15 FL:15}



static void Test_BFs15i_BFu15s_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15ll_BFs15ll, BFs15i_BFu15s_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15i_BFu15s_BFu15ll_BFs15s  {
  signed int v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15ll_BFs15s) C1{ Fi:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15i_BFu15s_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15ll_BFs15s, BFs15i_BFu15s_BFu15ll_BFs15s)
//============================================================================


struct  BFs15i_BFu15s_BFu15ll_BFu15i  {
  signed int v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15ll_BFu15i) C1{ Fi:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15i_BFu15s_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15ll_BFu15i, BFs15i_BFu15s_BFu15ll_BFu15i)
//============================================================================


struct  BFs15i_BFu15s_BFu15ll_BFu15ll  {
  signed int v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15ll_BFu15ll) C1{ Fi:15 Fs:15 FL:15 FL:15}



static void Test_BFs15i_BFu15s_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15i_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15ll_BFu15ll, BFs15i_BFu15s_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15i_BFu15s_BFu15ll_BFu15s  {
  signed int v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15ll_BFu15s) C1{ Fi:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15i_BFu15s_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15i_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15ll_BFu15s, BFs15i_BFu15s_BFu15ll_BFu15s)
//============================================================================


struct  BFs15i_BFu15s_BFu15s  {
  signed int v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15i_BFu15s_BFu15s) C1{ Fi:15 Fs:15 Fs:15}



static void Test_BFs15i_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15s, BFs15i_BFu15s_BFu15s)
//============================================================================


struct  BFs15i_BFu15s_BFu15s_BFs15i  {
  signed int v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15s_BFs15i) C1{ Fi:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15i_BFu15s_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15s_BFs15i, BFs15i_BFu15s_BFu15s_BFs15i)
//============================================================================


struct  BFs15i_BFu15s_BFu15s_BFs15ll  {
  signed int v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15s_BFs15ll) C1{ Fi:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15i_BFu15s_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15s_BFs15ll, BFs15i_BFu15s_BFu15s_BFs15ll)
//============================================================================


struct  BFs15i_BFu15s_BFu15s_BFs15s  {
  signed int v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15s_BFs15s) C1{ Fi:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15i_BFu15s_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15s_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15s_BFs15s, BFs15i_BFu15s_BFu15s_BFs15s)
//============================================================================


struct  BFs15i_BFu15s_BFu15s_BFu15i  {
  signed int v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15s_BFu15i) C1{ Fi:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15i_BFu15s_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15s_BFu15i, BFs15i_BFu15s_BFu15s_BFu15i)
//============================================================================


struct  BFs15i_BFu15s_BFu15s_BFu15ll  {
  signed int v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15s_BFu15ll) C1{ Fi:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15i_BFu15s_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15i_BFu15s_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15i_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15s_BFu15ll, BFs15i_BFu15s_BFu15s_BFu15ll)
//============================================================================


struct  BFs15i_BFu15s_BFu15s_BFu15s  {
  signed int v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15i_BFu15s_BFu15s_BFu15s) C1{ Fi:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15i_BFu15s_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15i_BFu15s_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15i_BFu15s_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15i_BFu15s_BFu15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15i_BFu15s_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15i_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15i_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15i_BFu15s_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15i_BFu15s_BFu15s_BFu15s, BFs15i_BFu15s_BFu15s_BFu15s)
//============================================================================


struct  BFs15ll_BFs15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
};
//SIG(1 BFs15ll_BFs15i) C1{ FL:15 Fi:15}



static void Test_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i, BFs15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFs15i_BFs15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed int v3:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15i) C1{ FL:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15i, BFs15ll_BFs15i_BFs15i)
//============================================================================


struct  BFs15ll_BFs15i_BFs15i_BFs15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15i_BFs15i) C1{ FL:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFs15i_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15i_BFs15i, BFs15ll_BFs15i_BFs15i_BFs15i)
//============================================================================


struct  BFs15ll_BFs15i_BFs15i_BFs15ll  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15i_BFs15ll) C1{ FL:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15ll_BFs15i_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15i_BFs15ll, BFs15ll_BFs15i_BFs15i_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15i_BFs15i_BFs15s  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15i_BFs15s) C1{ FL:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFs15i_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15i_BFs15s, BFs15ll_BFs15i_BFs15i_BFs15s)
//============================================================================


struct  BFs15ll_BFs15i_BFs15i_BFu15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15i_BFu15i) C1{ FL:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFs15i_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15i_BFu15i, BFs15ll_BFs15i_BFs15i_BFu15i)
//============================================================================


struct  BFs15ll_BFs15i_BFs15i_BFu15ll  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15i_BFu15ll) C1{ FL:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15ll_BFs15i_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15i_BFu15ll, BFs15ll_BFs15i_BFs15i_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15i_BFs15i_BFu15s  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15i_BFu15s) C1{ FL:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFs15i_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15i_BFu15s, BFs15ll_BFs15i_BFs15i_BFu15s)
//============================================================================


struct  BFs15ll_BFs15i_BFs15ll  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15ll) C1{ FL:15 Fi:15 FL:15}



static void Test_BFs15ll_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15ll, BFs15ll_BFs15i_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15i_BFs15ll_BFs15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15ll_BFs15i) C1{ FL:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15ll_BFs15i_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15ll_BFs15i, BFs15ll_BFs15i_BFs15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFs15i_BFs15ll_BFs15ll  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15ll_BFs15ll) C1{ FL:15 Fi:15 FL:15 FL:15}



static void Test_BFs15ll_BFs15i_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15ll_BFs15ll, BFs15ll_BFs15i_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15i_BFs15ll_BFs15s  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15ll_BFs15s) C1{ FL:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15ll_BFs15i_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15ll_BFs15s, BFs15ll_BFs15i_BFs15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFs15i_BFs15ll_BFu15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15ll_BFu15i) C1{ FL:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15ll_BFs15i_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15ll_BFu15i, BFs15ll_BFs15i_BFs15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFs15i_BFs15ll_BFu15ll  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15ll_BFu15ll) C1{ FL:15 Fi:15 FL:15 FL:15}



static void Test_BFs15ll_BFs15i_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15ll_BFu15ll, BFs15ll_BFs15i_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15i_BFs15ll_BFu15s  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15ll_BFu15s) C1{ FL:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15ll_BFs15i_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15ll_BFu15s, BFs15ll_BFs15i_BFs15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFs15i_BFs15s  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed short v3:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15s) C1{ FL:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15s, BFs15ll_BFs15i_BFs15s)
//============================================================================


struct  BFs15ll_BFs15i_BFs15s_BFs15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15s_BFs15i) C1{ FL:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFs15i_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15s_BFs15i, BFs15ll_BFs15i_BFs15s_BFs15i)
//============================================================================


struct  BFs15ll_BFs15i_BFs15s_BFs15ll  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15s_BFs15ll) C1{ FL:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15ll_BFs15i_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15s_BFs15ll, BFs15ll_BFs15i_BFs15s_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15i_BFs15s_BFs15s  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15s_BFs15s) C1{ FL:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFs15i_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15s_BFs15s, BFs15ll_BFs15i_BFs15s_BFs15s)
//============================================================================


struct  BFs15ll_BFs15i_BFs15s_BFu15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15s_BFu15i) C1{ FL:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFs15i_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15s_BFu15i, BFs15ll_BFs15i_BFs15s_BFu15i)
//============================================================================


struct  BFs15ll_BFs15i_BFs15s_BFu15ll  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15s_BFu15ll) C1{ FL:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15ll_BFs15i_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15s_BFu15ll, BFs15ll_BFs15i_BFs15s_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15i_BFs15s_BFu15s  {
  signed __tsi64 v1:15;
  signed int v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFs15s_BFu15s) C1{ FL:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFs15i_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15i_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFs15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFs15s_BFu15s, BFs15ll_BFs15i_BFs15s_BFu15s)
//============================================================================


struct  BFs15ll_BFs15i_BFu15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15i) C1{ FL:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15i, BFs15ll_BFs15i_BFu15i)
//============================================================================


struct  BFs15ll_BFs15i_BFu15i_BFs15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15i_BFs15i) C1{ FL:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFs15i_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15i_BFs15i, BFs15ll_BFs15i_BFu15i_BFs15i)
//============================================================================


struct  BFs15ll_BFs15i_BFu15i_BFs15ll  {
  signed __tsi64 v1:15;
  signed int v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15i_BFs15ll) C1{ FL:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15ll_BFs15i_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15i_BFs15ll, BFs15ll_BFs15i_BFu15i_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15i_BFu15i_BFs15s  {
  signed __tsi64 v1:15;
  signed int v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15i_BFs15s) C1{ FL:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFs15i_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15i_BFs15s, BFs15ll_BFs15i_BFu15i_BFs15s)
//============================================================================


struct  BFs15ll_BFs15i_BFu15i_BFu15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15i_BFu15i) C1{ FL:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFs15i_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15i_BFu15i, BFs15ll_BFs15i_BFu15i_BFu15i)
//============================================================================


struct  BFs15ll_BFs15i_BFu15i_BFu15ll  {
  signed __tsi64 v1:15;
  signed int v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15i_BFu15ll) C1{ FL:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15ll_BFs15i_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15i_BFu15ll, BFs15ll_BFs15i_BFu15i_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15i_BFu15i_BFu15s  {
  signed __tsi64 v1:15;
  signed int v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15i_BFu15s) C1{ FL:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFs15i_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15i_BFu15s, BFs15ll_BFs15i_BFu15i_BFu15s)
//============================================================================


struct  BFs15ll_BFs15i_BFu15ll  {
  signed __tsi64 v1:15;
  signed int v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15ll) C1{ FL:15 Fi:15 FL:15}



static void Test_BFs15ll_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15ll, BFs15ll_BFs15i_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15i_BFu15ll_BFs15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15ll_BFs15i) C1{ FL:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15ll_BFs15i_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15ll_BFs15i, BFs15ll_BFs15i_BFu15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFs15i_BFu15ll_BFs15ll  {
  signed __tsi64 v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15ll_BFs15ll) C1{ FL:15 Fi:15 FL:15 FL:15}



static void Test_BFs15ll_BFs15i_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15ll_BFs15ll, BFs15ll_BFs15i_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15i_BFu15ll_BFs15s  {
  signed __tsi64 v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15ll_BFs15s) C1{ FL:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15ll_BFs15i_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15ll_BFs15s, BFs15ll_BFs15i_BFu15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFs15i_BFu15ll_BFu15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15ll_BFu15i) C1{ FL:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15ll_BFs15i_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15ll_BFu15i, BFs15ll_BFs15i_BFu15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFs15i_BFu15ll_BFu15ll  {
  signed __tsi64 v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15ll_BFu15ll) C1{ FL:15 Fi:15 FL:15 FL:15}



static void Test_BFs15ll_BFs15i_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15ll_BFu15ll, BFs15ll_BFs15i_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15i_BFu15ll_BFu15s  {
  signed __tsi64 v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15ll_BFu15s) C1{ FL:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15ll_BFs15i_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15ll_BFu15s, BFs15ll_BFs15i_BFu15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFs15i_BFu15s  {
  signed __tsi64 v1:15;
  signed int v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15s) C1{ FL:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15s, BFs15ll_BFs15i_BFu15s)
//============================================================================


struct  BFs15ll_BFs15i_BFu15s_BFs15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15s_BFs15i) C1{ FL:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFs15i_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15s_BFs15i, BFs15ll_BFs15i_BFu15s_BFs15i)
//============================================================================


struct  BFs15ll_BFs15i_BFu15s_BFs15ll  {
  signed __tsi64 v1:15;
  signed int v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15s_BFs15ll) C1{ FL:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15ll_BFs15i_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15s_BFs15ll, BFs15ll_BFs15i_BFu15s_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15i_BFu15s_BFs15s  {
  signed __tsi64 v1:15;
  signed int v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15s_BFs15s) C1{ FL:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFs15i_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15s_BFs15s, BFs15ll_BFs15i_BFu15s_BFs15s)
//============================================================================


struct  BFs15ll_BFs15i_BFu15s_BFu15i  {
  signed __tsi64 v1:15;
  signed int v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15s_BFu15i) C1{ FL:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFs15i_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15s_BFu15i, BFs15ll_BFs15i_BFu15s_BFu15i)
//============================================================================


struct  BFs15ll_BFs15i_BFu15s_BFu15ll  {
  signed __tsi64 v1:15;
  signed int v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15s_BFu15ll) C1{ FL:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15ll_BFs15i_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15s_BFu15ll, BFs15ll_BFs15i_BFu15s_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15i_BFu15s_BFu15s  {
  signed __tsi64 v1:15;
  signed int v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15i_BFu15s_BFu15s) C1{ FL:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFs15i_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15i_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15i_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15i_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15i_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15i_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15i_BFu15s_BFu15s, BFs15ll_BFs15i_BFu15s_BFu15s)
//============================================================================


struct  BFs15ll_BFs15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
};
//SIG(1 BFs15ll_BFs15ll) C1{ FL:15 FL:15}



static void Test_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll, BFs15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15i  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15i) C1{ FL:15 FL:15 Fi:15}



static void Test_BFs15ll_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15i, BFs15ll_BFs15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15i_BFs15i  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15i_BFs15i) C1{ FL:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFs15ll_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15i_BFs15i, BFs15ll_BFs15ll_BFs15i_BFs15i)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15i_BFs15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15i_BFs15ll) C1{ FL:15 FL:15 Fi:15 FL:15}



static void Test_BFs15ll_BFs15ll_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15i_BFs15ll, BFs15ll_BFs15ll_BFs15i_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15i_BFs15s  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15i_BFs15s) C1{ FL:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFs15ll_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15i_BFs15s, BFs15ll_BFs15ll_BFs15i_BFs15s)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15i_BFu15i  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15i_BFu15i) C1{ FL:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFs15ll_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15i_BFu15i, BFs15ll_BFs15ll_BFs15i_BFu15i)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15i_BFu15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15i_BFu15ll) C1{ FL:15 FL:15 Fi:15 FL:15}



static void Test_BFs15ll_BFs15ll_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15i_BFu15ll, BFs15ll_BFs15ll_BFs15i_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15i_BFu15s  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15i_BFu15s) C1{ FL:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFs15ll_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15i_BFu15s, BFs15ll_BFs15ll_BFs15i_BFu15s)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15ll) C1{ FL:15 FL:15 FL:15}



static void Test_BFs15ll_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15ll, BFs15ll_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15ll_BFs15i  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15ll_BFs15i) C1{ FL:15 FL:15 FL:15 Fi:15}



static void Test_BFs15ll_BFs15ll_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15ll_BFs15i, BFs15ll_BFs15ll_BFs15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15ll_BFs15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15ll_BFs15ll) C1{ FL:15 FL:15 FL:15 FL:15}



static void Test_BFs15ll_BFs15ll_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15ll_BFs15ll, BFs15ll_BFs15ll_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15ll_BFs15s  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15ll_BFs15s) C1{ FL:15 FL:15 FL:15 Fs:15}



static void Test_BFs15ll_BFs15ll_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15ll_BFs15s, BFs15ll_BFs15ll_BFs15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15ll_BFu15i  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15ll_BFu15i) C1{ FL:15 FL:15 FL:15 Fi:15}



static void Test_BFs15ll_BFs15ll_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15ll_BFu15i, BFs15ll_BFs15ll_BFs15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15ll_BFu15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15ll_BFu15ll) C1{ FL:15 FL:15 FL:15 FL:15}



static void Test_BFs15ll_BFs15ll_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15ll_BFu15ll, BFs15ll_BFs15ll_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15ll_BFu15s  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15ll_BFu15s) C1{ FL:15 FL:15 FL:15 Fs:15}



static void Test_BFs15ll_BFs15ll_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15ll_BFu15s, BFs15ll_BFs15ll_BFs15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15s  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15s) C1{ FL:15 FL:15 Fs:15}



static void Test_BFs15ll_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15s, BFs15ll_BFs15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15s_BFs15i  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15s_BFs15i) C1{ FL:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFs15ll_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15s_BFs15i, BFs15ll_BFs15ll_BFs15s_BFs15i)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15s_BFs15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15s_BFs15ll) C1{ FL:15 FL:15 Fs:15 FL:15}



static void Test_BFs15ll_BFs15ll_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15s_BFs15ll, BFs15ll_BFs15ll_BFs15s_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15s_BFs15s  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15s_BFs15s) C1{ FL:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFs15ll_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15s_BFs15s, BFs15ll_BFs15ll_BFs15s_BFs15s)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15s_BFu15i  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15s_BFu15i) C1{ FL:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFs15ll_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15s_BFu15i, BFs15ll_BFs15ll_BFs15s_BFu15i)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15s_BFu15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15s_BFu15ll) C1{ FL:15 FL:15 Fs:15 FL:15}



static void Test_BFs15ll_BFs15ll_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15s_BFu15ll, BFs15ll_BFs15ll_BFs15s_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFs15s_BFu15s  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFs15s_BFu15s) C1{ FL:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFs15ll_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFs15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFs15s_BFu15s, BFs15ll_BFs15ll_BFs15s_BFu15s)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15i  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15i) C1{ FL:15 FL:15 Fi:15}



static void Test_BFs15ll_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15i, BFs15ll_BFs15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15i_BFs15i  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15i_BFs15i) C1{ FL:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFs15ll_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15i_BFs15i, BFs15ll_BFs15ll_BFu15i_BFs15i)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15i_BFs15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15i_BFs15ll) C1{ FL:15 FL:15 Fi:15 FL:15}



static void Test_BFs15ll_BFs15ll_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15i_BFs15ll, BFs15ll_BFs15ll_BFu15i_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15i_BFs15s  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15i_BFs15s) C1{ FL:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFs15ll_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15i_BFs15s, BFs15ll_BFs15ll_BFu15i_BFs15s)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15i_BFu15i  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15i_BFu15i) C1{ FL:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFs15ll_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15i_BFu15i, BFs15ll_BFs15ll_BFu15i_BFu15i)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15i_BFu15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15i_BFu15ll) C1{ FL:15 FL:15 Fi:15 FL:15}



static void Test_BFs15ll_BFs15ll_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15i_BFu15ll, BFs15ll_BFs15ll_BFu15i_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15i_BFu15s  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15i_BFu15s) C1{ FL:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFs15ll_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15i_BFu15s, BFs15ll_BFs15ll_BFu15i_BFu15s)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15ll) C1{ FL:15 FL:15 FL:15}



static void Test_BFs15ll_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15ll, BFs15ll_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15ll_BFs15i  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15ll_BFs15i) C1{ FL:15 FL:15 FL:15 Fi:15}



static void Test_BFs15ll_BFs15ll_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15ll_BFs15i, BFs15ll_BFs15ll_BFu15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15ll_BFs15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15ll_BFs15ll) C1{ FL:15 FL:15 FL:15 FL:15}



static void Test_BFs15ll_BFs15ll_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15ll_BFs15ll, BFs15ll_BFs15ll_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15ll_BFs15s  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15ll_BFs15s) C1{ FL:15 FL:15 FL:15 Fs:15}



static void Test_BFs15ll_BFs15ll_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15ll_BFs15s, BFs15ll_BFs15ll_BFu15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15ll_BFu15i  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15ll_BFu15i) C1{ FL:15 FL:15 FL:15 Fi:15}



static void Test_BFs15ll_BFs15ll_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15ll_BFu15i, BFs15ll_BFs15ll_BFu15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15ll_BFu15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15ll_BFu15ll) C1{ FL:15 FL:15 FL:15 FL:15}



static void Test_BFs15ll_BFs15ll_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15ll_BFu15ll, BFs15ll_BFs15ll_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15ll_BFu15s  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15ll_BFu15s) C1{ FL:15 FL:15 FL:15 Fs:15}



static void Test_BFs15ll_BFs15ll_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15ll_BFu15s, BFs15ll_BFs15ll_BFu15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15s  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15s) C1{ FL:15 FL:15 Fs:15}



static void Test_BFs15ll_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15s, BFs15ll_BFs15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15s_BFs15i  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15s_BFs15i) C1{ FL:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFs15ll_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15s_BFs15i, BFs15ll_BFs15ll_BFu15s_BFs15i)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15s_BFs15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15s_BFs15ll) C1{ FL:15 FL:15 Fs:15 FL:15}



static void Test_BFs15ll_BFs15ll_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15s_BFs15ll, BFs15ll_BFs15ll_BFu15s_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15s_BFs15s  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15s_BFs15s) C1{ FL:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFs15ll_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15s_BFs15s, BFs15ll_BFs15ll_BFu15s_BFs15s)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15s_BFu15i  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15s_BFu15i) C1{ FL:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFs15ll_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15s_BFu15i, BFs15ll_BFs15ll_BFu15s_BFu15i)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15s_BFu15ll  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15s_BFu15ll) C1{ FL:15 FL:15 Fs:15 FL:15}



static void Test_BFs15ll_BFs15ll_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15s_BFu15ll, BFs15ll_BFs15ll_BFu15s_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15ll_BFu15s_BFu15s  {
  signed __tsi64 v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15ll_BFu15s_BFu15s) C1{ FL:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFs15ll_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15ll_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15ll_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15ll_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15ll_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15ll_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15ll_BFu15s_BFu15s, BFs15ll_BFs15ll_BFu15s_BFu15s)
//============================================================================


struct  BFs15ll_BFs15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
};
//SIG(1 BFs15ll_BFs15s) C1{ FL:15 Fs:15}



static void Test_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s, BFs15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFs15s_BFs15i  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed int v3:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15i) C1{ FL:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15i, BFs15ll_BFs15s_BFs15i)
//============================================================================


struct  BFs15ll_BFs15s_BFs15i_BFs15i  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15i_BFs15i) C1{ FL:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFs15s_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15i_BFs15i, BFs15ll_BFs15s_BFs15i_BFs15i)
//============================================================================


struct  BFs15ll_BFs15s_BFs15i_BFs15ll  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15i_BFs15ll) C1{ FL:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15ll_BFs15s_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15i_BFs15ll, BFs15ll_BFs15s_BFs15i_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15s_BFs15i_BFs15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15i_BFs15s) C1{ FL:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFs15s_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15i_BFs15s, BFs15ll_BFs15s_BFs15i_BFs15s)
//============================================================================


struct  BFs15ll_BFs15s_BFs15i_BFu15i  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15i_BFu15i) C1{ FL:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFs15s_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15i_BFu15i, BFs15ll_BFs15s_BFs15i_BFu15i)
//============================================================================


struct  BFs15ll_BFs15s_BFs15i_BFu15ll  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15i_BFu15ll) C1{ FL:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15ll_BFs15s_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15i_BFu15ll, BFs15ll_BFs15s_BFs15i_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15s_BFs15i_BFu15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15i_BFu15s) C1{ FL:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFs15s_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15i_BFu15s, BFs15ll_BFs15s_BFs15i_BFu15s)
//============================================================================


struct  BFs15ll_BFs15s_BFs15ll  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15ll) C1{ FL:15 Fs:15 FL:15}



static void Test_BFs15ll_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15ll, BFs15ll_BFs15s_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15s_BFs15ll_BFs15i  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15ll_BFs15i) C1{ FL:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15ll_BFs15s_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15ll_BFs15i, BFs15ll_BFs15s_BFs15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFs15s_BFs15ll_BFs15ll  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15ll_BFs15ll) C1{ FL:15 Fs:15 FL:15 FL:15}



static void Test_BFs15ll_BFs15s_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15ll_BFs15ll, BFs15ll_BFs15s_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15s_BFs15ll_BFs15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15ll_BFs15s) C1{ FL:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15ll_BFs15s_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15ll_BFs15s, BFs15ll_BFs15s_BFs15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFs15s_BFs15ll_BFu15i  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15ll_BFu15i) C1{ FL:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15ll_BFs15s_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15ll_BFu15i, BFs15ll_BFs15s_BFs15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFs15s_BFs15ll_BFu15ll  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15ll_BFu15ll) C1{ FL:15 Fs:15 FL:15 FL:15}



static void Test_BFs15ll_BFs15s_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15ll_BFu15ll, BFs15ll_BFs15s_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15s_BFs15ll_BFu15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15ll_BFu15s) C1{ FL:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15ll_BFs15s_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15ll_BFu15s, BFs15ll_BFs15s_BFs15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFs15s_BFs15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed short v3:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15s) C1{ FL:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15s, BFs15ll_BFs15s_BFs15s)
//============================================================================


struct  BFs15ll_BFs15s_BFs15s_BFs15i  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15s_BFs15i) C1{ FL:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFs15s_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15s_BFs15i, BFs15ll_BFs15s_BFs15s_BFs15i)
//============================================================================


struct  BFs15ll_BFs15s_BFs15s_BFs15ll  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15s_BFs15ll) C1{ FL:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15ll_BFs15s_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15s_BFs15ll, BFs15ll_BFs15s_BFs15s_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15s_BFs15s_BFs15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15s_BFs15s) C1{ FL:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFs15s_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15s_BFs15s, BFs15ll_BFs15s_BFs15s_BFs15s)
//============================================================================


struct  BFs15ll_BFs15s_BFs15s_BFu15i  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15s_BFu15i) C1{ FL:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFs15s_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15s_BFu15i, BFs15ll_BFs15s_BFs15s_BFu15i)
//============================================================================


struct  BFs15ll_BFs15s_BFs15s_BFu15ll  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15s_BFu15ll) C1{ FL:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15ll_BFs15s_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15s_BFu15ll, BFs15ll_BFs15s_BFs15s_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15s_BFs15s_BFu15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFs15s_BFu15s) C1{ FL:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFs15s_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15s_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFs15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFs15s_BFu15s, BFs15ll_BFs15s_BFs15s_BFu15s)
//============================================================================


struct  BFs15ll_BFs15s_BFu15i  {
  signed __tsi64 v1:15;
  signed short v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15i) C1{ FL:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15i, BFs15ll_BFs15s_BFu15i)
//============================================================================


struct  BFs15ll_BFs15s_BFu15i_BFs15i  {
  signed __tsi64 v1:15;
  signed short v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15i_BFs15i) C1{ FL:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFs15s_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15i_BFs15i, BFs15ll_BFs15s_BFu15i_BFs15i)
//============================================================================


struct  BFs15ll_BFs15s_BFu15i_BFs15ll  {
  signed __tsi64 v1:15;
  signed short v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15i_BFs15ll) C1{ FL:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15ll_BFs15s_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15i_BFs15ll, BFs15ll_BFs15s_BFu15i_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15s_BFu15i_BFs15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15i_BFs15s) C1{ FL:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFs15s_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15i_BFs15s, BFs15ll_BFs15s_BFu15i_BFs15s)
//============================================================================


struct  BFs15ll_BFs15s_BFu15i_BFu15i  {
  signed __tsi64 v1:15;
  signed short v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15i_BFu15i) C1{ FL:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFs15s_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15i_BFu15i, BFs15ll_BFs15s_BFu15i_BFu15i)
//============================================================================


struct  BFs15ll_BFs15s_BFu15i_BFu15ll  {
  signed __tsi64 v1:15;
  signed short v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15i_BFu15ll) C1{ FL:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15ll_BFs15s_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15i_BFu15ll, BFs15ll_BFs15s_BFu15i_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15s_BFu15i_BFu15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15i_BFu15s) C1{ FL:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFs15s_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15i_BFu15s, BFs15ll_BFs15s_BFu15i_BFu15s)
//============================================================================


struct  BFs15ll_BFs15s_BFu15ll  {
  signed __tsi64 v1:15;
  signed short v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15ll) C1{ FL:15 Fs:15 FL:15}



static void Test_BFs15ll_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15ll, BFs15ll_BFs15s_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15s_BFu15ll_BFs15i  {
  signed __tsi64 v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15ll_BFs15i) C1{ FL:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15ll_BFs15s_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15ll_BFs15i, BFs15ll_BFs15s_BFu15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFs15s_BFu15ll_BFs15ll  {
  signed __tsi64 v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15ll_BFs15ll) C1{ FL:15 Fs:15 FL:15 FL:15}



static void Test_BFs15ll_BFs15s_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15ll_BFs15ll, BFs15ll_BFs15s_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15s_BFu15ll_BFs15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15ll_BFs15s) C1{ FL:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15ll_BFs15s_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15ll_BFs15s, BFs15ll_BFs15s_BFu15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFs15s_BFu15ll_BFu15i  {
  signed __tsi64 v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15ll_BFu15i) C1{ FL:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15ll_BFs15s_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15ll_BFu15i, BFs15ll_BFs15s_BFu15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFs15s_BFu15ll_BFu15ll  {
  signed __tsi64 v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15ll_BFu15ll) C1{ FL:15 Fs:15 FL:15 FL:15}



static void Test_BFs15ll_BFs15s_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15ll_BFu15ll, BFs15ll_BFs15s_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15s_BFu15ll_BFu15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15ll_BFu15s) C1{ FL:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15ll_BFs15s_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15ll_BFu15s, BFs15ll_BFs15s_BFu15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFs15s_BFu15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15s) C1{ FL:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15s, BFs15ll_BFs15s_BFu15s)
//============================================================================


struct  BFs15ll_BFs15s_BFu15s_BFs15i  {
  signed __tsi64 v1:15;
  signed short v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15s_BFs15i) C1{ FL:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFs15s_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15s_BFs15i, BFs15ll_BFs15s_BFu15s_BFs15i)
//============================================================================


struct  BFs15ll_BFs15s_BFu15s_BFs15ll  {
  signed __tsi64 v1:15;
  signed short v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15s_BFs15ll) C1{ FL:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15ll_BFs15s_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15s_BFs15ll, BFs15ll_BFs15s_BFu15s_BFs15ll)
//============================================================================


struct  BFs15ll_BFs15s_BFu15s_BFs15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15s_BFs15s) C1{ FL:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFs15s_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15s_BFs15s, BFs15ll_BFs15s_BFu15s_BFs15s)
//============================================================================


struct  BFs15ll_BFs15s_BFu15s_BFu15i  {
  signed __tsi64 v1:15;
  signed short v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15s_BFu15i) C1{ FL:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFs15s_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15s_BFu15i, BFs15ll_BFs15s_BFu15s_BFu15i)
//============================================================================


struct  BFs15ll_BFs15s_BFu15s_BFu15ll  {
  signed __tsi64 v1:15;
  signed short v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15s_BFu15ll) C1{ FL:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15ll_BFs15s_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15s_BFu15ll, BFs15ll_BFs15s_BFu15s_BFu15ll)
//============================================================================


struct  BFs15ll_BFs15s_BFu15s_BFu15s  {
  signed __tsi64 v1:15;
  signed short v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFs15s_BFu15s_BFu15s) C1{ FL:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFs15s_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFs15s_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15ll_BFs15s_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFs15s_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFs15s_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFs15s_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFs15s_BFu15s_BFu15s, BFs15ll_BFs15s_BFu15s_BFu15s)
//============================================================================


struct  BFs15ll_BFu15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
};
//SIG(1 BFs15ll_BFu15i) C1{ FL:15 Fi:15}



static void Test_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i, BFs15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFu15i_BFs15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed int v3:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15i) C1{ FL:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15i, BFs15ll_BFu15i_BFs15i)
//============================================================================


struct  BFs15ll_BFu15i_BFs15i_BFs15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15i_BFs15i) C1{ FL:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFu15i_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15i_BFs15i, BFs15ll_BFu15i_BFs15i_BFs15i)
//============================================================================


struct  BFs15ll_BFu15i_BFs15i_BFs15ll  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15i_BFs15ll) C1{ FL:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15ll_BFu15i_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15i_BFs15ll, BFs15ll_BFu15i_BFs15i_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15i_BFs15i_BFs15s  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15i_BFs15s) C1{ FL:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFu15i_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15i_BFs15s, BFs15ll_BFu15i_BFs15i_BFs15s)
//============================================================================


struct  BFs15ll_BFu15i_BFs15i_BFu15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15i_BFu15i) C1{ FL:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFu15i_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15i_BFu15i, BFs15ll_BFu15i_BFs15i_BFu15i)
//============================================================================


struct  BFs15ll_BFu15i_BFs15i_BFu15ll  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15i_BFu15ll) C1{ FL:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15ll_BFu15i_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15i_BFu15ll, BFs15ll_BFu15i_BFs15i_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15i_BFs15i_BFu15s  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15i_BFu15s) C1{ FL:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFu15i_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15i_BFu15s, BFs15ll_BFu15i_BFs15i_BFu15s)
//============================================================================


struct  BFs15ll_BFu15i_BFs15ll  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15ll) C1{ FL:15 Fi:15 FL:15}



static void Test_BFs15ll_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15ll, BFs15ll_BFu15i_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15i_BFs15ll_BFs15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15ll_BFs15i) C1{ FL:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15ll_BFu15i_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15ll_BFs15i, BFs15ll_BFu15i_BFs15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFu15i_BFs15ll_BFs15ll  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15ll_BFs15ll) C1{ FL:15 Fi:15 FL:15 FL:15}



static void Test_BFs15ll_BFu15i_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15ll_BFs15ll, BFs15ll_BFu15i_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15i_BFs15ll_BFs15s  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15ll_BFs15s) C1{ FL:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15ll_BFu15i_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15ll_BFs15s, BFs15ll_BFu15i_BFs15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFu15i_BFs15ll_BFu15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15ll_BFu15i) C1{ FL:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15ll_BFu15i_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15ll_BFu15i, BFs15ll_BFu15i_BFs15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFu15i_BFs15ll_BFu15ll  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15ll_BFu15ll) C1{ FL:15 Fi:15 FL:15 FL:15}



static void Test_BFs15ll_BFu15i_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15ll_BFu15ll, BFs15ll_BFu15i_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15i_BFs15ll_BFu15s  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15ll_BFu15s) C1{ FL:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15ll_BFu15i_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15ll_BFu15s, BFs15ll_BFu15i_BFs15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFu15i_BFs15s  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed short v3:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15s) C1{ FL:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15s, BFs15ll_BFu15i_BFs15s)
//============================================================================


struct  BFs15ll_BFu15i_BFs15s_BFs15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15s_BFs15i) C1{ FL:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFu15i_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15s_BFs15i, BFs15ll_BFu15i_BFs15s_BFs15i)
//============================================================================


struct  BFs15ll_BFu15i_BFs15s_BFs15ll  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15s_BFs15ll) C1{ FL:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15ll_BFu15i_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15s_BFs15ll, BFs15ll_BFu15i_BFs15s_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15i_BFs15s_BFs15s  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15s_BFs15s) C1{ FL:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFu15i_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15s_BFs15s, BFs15ll_BFu15i_BFs15s_BFs15s)
//============================================================================


struct  BFs15ll_BFu15i_BFs15s_BFu15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15s_BFu15i) C1{ FL:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFu15i_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15s_BFu15i, BFs15ll_BFu15i_BFs15s_BFu15i)
//============================================================================


struct  BFs15ll_BFu15i_BFs15s_BFu15ll  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15s_BFu15ll) C1{ FL:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15ll_BFu15i_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15s_BFu15ll, BFs15ll_BFu15i_BFs15s_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15i_BFs15s_BFu15s  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFs15s_BFu15s) C1{ FL:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFu15i_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15i_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFs15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFs15s_BFu15s, BFs15ll_BFu15i_BFs15s_BFu15s)
//============================================================================


struct  BFs15ll_BFu15i_BFu15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15i) C1{ FL:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15i, BFs15ll_BFu15i_BFu15i)
//============================================================================


struct  BFs15ll_BFu15i_BFu15i_BFs15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15i_BFs15i) C1{ FL:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFu15i_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15i_BFs15i, BFs15ll_BFu15i_BFu15i_BFs15i)
//============================================================================


struct  BFs15ll_BFu15i_BFu15i_BFs15ll  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15i_BFs15ll) C1{ FL:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15ll_BFu15i_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15i_BFs15ll, BFs15ll_BFu15i_BFu15i_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15i_BFu15i_BFs15s  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15i_BFs15s) C1{ FL:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFu15i_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15i_BFs15s, BFs15ll_BFu15i_BFu15i_BFs15s)
//============================================================================


struct  BFs15ll_BFu15i_BFu15i_BFu15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15i_BFu15i) C1{ FL:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFu15i_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15i_BFu15i, BFs15ll_BFu15i_BFu15i_BFu15i)
//============================================================================


struct  BFs15ll_BFu15i_BFu15i_BFu15ll  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15i_BFu15ll) C1{ FL:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15ll_BFu15i_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15i_BFu15ll, BFs15ll_BFu15i_BFu15i_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15i_BFu15i_BFu15s  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15i_BFu15s) C1{ FL:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFu15i_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15i_BFu15s, BFs15ll_BFu15i_BFu15i_BFu15s)
//============================================================================


struct  BFs15ll_BFu15i_BFu15ll  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15ll) C1{ FL:15 Fi:15 FL:15}



static void Test_BFs15ll_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15ll, BFs15ll_BFu15i_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15i_BFu15ll_BFs15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15ll_BFs15i) C1{ FL:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15ll_BFu15i_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15ll_BFs15i, BFs15ll_BFu15i_BFu15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFu15i_BFu15ll_BFs15ll  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15ll_BFs15ll) C1{ FL:15 Fi:15 FL:15 FL:15}



static void Test_BFs15ll_BFu15i_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15ll_BFs15ll, BFs15ll_BFu15i_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15i_BFu15ll_BFs15s  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15ll_BFs15s) C1{ FL:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15ll_BFu15i_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15ll_BFs15s, BFs15ll_BFu15i_BFu15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFu15i_BFu15ll_BFu15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15ll_BFu15i) C1{ FL:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15ll_BFu15i_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15ll_BFu15i, BFs15ll_BFu15i_BFu15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFu15i_BFu15ll_BFu15ll  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15ll_BFu15ll) C1{ FL:15 Fi:15 FL:15 FL:15}



static void Test_BFs15ll_BFu15i_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15ll_BFu15ll, BFs15ll_BFu15i_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15i_BFu15ll_BFu15s  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15ll_BFu15s) C1{ FL:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15ll_BFu15i_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15ll_BFu15s, BFs15ll_BFu15i_BFu15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFu15i_BFu15s  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15s) C1{ FL:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15s, BFs15ll_BFu15i_BFu15s)
//============================================================================


struct  BFs15ll_BFu15i_BFu15s_BFs15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15s_BFs15i) C1{ FL:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFu15i_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15s_BFs15i, BFs15ll_BFu15i_BFu15s_BFs15i)
//============================================================================


struct  BFs15ll_BFu15i_BFu15s_BFs15ll  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15s_BFs15ll) C1{ FL:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15ll_BFu15i_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15s_BFs15ll, BFs15ll_BFu15i_BFu15s_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15i_BFu15s_BFs15s  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15s_BFs15s) C1{ FL:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFu15i_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15s_BFs15s, BFs15ll_BFu15i_BFu15s_BFs15s)
//============================================================================


struct  BFs15ll_BFu15i_BFu15s_BFu15i  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15s_BFu15i) C1{ FL:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFu15i_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15s_BFu15i, BFs15ll_BFu15i_BFu15s_BFu15i)
//============================================================================


struct  BFs15ll_BFu15i_BFu15s_BFu15ll  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15s_BFu15ll) C1{ FL:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15ll_BFu15i_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15s_BFu15ll, BFs15ll_BFu15i_BFu15s_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15i_BFu15s_BFu15s  {
  signed __tsi64 v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15i_BFu15s_BFu15s) C1{ FL:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFu15i_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15i_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15i_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15i_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15i_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15i_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15i_BFu15s_BFu15s, BFs15ll_BFu15i_BFu15s_BFu15s)
//============================================================================


struct  BFs15ll_BFu15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
};
//SIG(1 BFs15ll_BFu15ll) C1{ FL:15 FL:15}



static void Test_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll, BFs15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15i  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed int v3:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15i) C1{ FL:15 FL:15 Fi:15}



static void Test_BFs15ll_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15i, BFs15ll_BFu15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15i_BFs15i  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15i_BFs15i) C1{ FL:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFu15ll_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15i_BFs15i, BFs15ll_BFu15ll_BFs15i_BFs15i)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15i_BFs15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15i_BFs15ll) C1{ FL:15 FL:15 Fi:15 FL:15}



static void Test_BFs15ll_BFu15ll_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15i_BFs15ll, BFs15ll_BFu15ll_BFs15i_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15i_BFs15s  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15i_BFs15s) C1{ FL:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFu15ll_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15i_BFs15s, BFs15ll_BFu15ll_BFs15i_BFs15s)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15i_BFu15i  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15i_BFu15i) C1{ FL:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFu15ll_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15i_BFu15i, BFs15ll_BFu15ll_BFs15i_BFu15i)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15i_BFu15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15i_BFu15ll) C1{ FL:15 FL:15 Fi:15 FL:15}



static void Test_BFs15ll_BFu15ll_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15i_BFu15ll, BFs15ll_BFu15ll_BFs15i_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15i_BFu15s  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15i_BFu15s) C1{ FL:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFu15ll_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15i_BFu15s, BFs15ll_BFu15ll_BFs15i_BFu15s)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15ll) C1{ FL:15 FL:15 FL:15}



static void Test_BFs15ll_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15ll, BFs15ll_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15ll_BFs15i  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15ll_BFs15i) C1{ FL:15 FL:15 FL:15 Fi:15}



static void Test_BFs15ll_BFu15ll_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15ll_BFs15i, BFs15ll_BFu15ll_BFs15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15ll_BFs15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15ll_BFs15ll) C1{ FL:15 FL:15 FL:15 FL:15}



static void Test_BFs15ll_BFu15ll_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15ll_BFs15ll, BFs15ll_BFu15ll_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15ll_BFs15s  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15ll_BFs15s) C1{ FL:15 FL:15 FL:15 Fs:15}



static void Test_BFs15ll_BFu15ll_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15ll_BFs15s, BFs15ll_BFu15ll_BFs15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15ll_BFu15i  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15ll_BFu15i) C1{ FL:15 FL:15 FL:15 Fi:15}



static void Test_BFs15ll_BFu15ll_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15ll_BFu15i, BFs15ll_BFu15ll_BFs15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15ll_BFu15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15ll_BFu15ll) C1{ FL:15 FL:15 FL:15 FL:15}



static void Test_BFs15ll_BFu15ll_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15ll_BFu15ll, BFs15ll_BFu15ll_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15ll_BFu15s  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15ll_BFu15s) C1{ FL:15 FL:15 FL:15 Fs:15}



static void Test_BFs15ll_BFu15ll_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15ll_BFu15s, BFs15ll_BFu15ll_BFs15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15s  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed short v3:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15s) C1{ FL:15 FL:15 Fs:15}



static void Test_BFs15ll_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15s, BFs15ll_BFu15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15s_BFs15i  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15s_BFs15i) C1{ FL:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFu15ll_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15s_BFs15i, BFs15ll_BFu15ll_BFs15s_BFs15i)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15s_BFs15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15s_BFs15ll) C1{ FL:15 FL:15 Fs:15 FL:15}



static void Test_BFs15ll_BFu15ll_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15s_BFs15ll, BFs15ll_BFu15ll_BFs15s_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15s_BFs15s  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15s_BFs15s) C1{ FL:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFu15ll_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15s_BFs15s, BFs15ll_BFu15ll_BFs15s_BFs15s)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15s_BFu15i  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15s_BFu15i) C1{ FL:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFu15ll_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15s_BFu15i, BFs15ll_BFu15ll_BFs15s_BFu15i)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15s_BFu15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15s_BFu15ll) C1{ FL:15 FL:15 Fs:15 FL:15}



static void Test_BFs15ll_BFu15ll_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15s_BFu15ll, BFs15ll_BFu15ll_BFs15s_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFs15s_BFu15s  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFs15s_BFu15s) C1{ FL:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFu15ll_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFs15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFs15s_BFu15s, BFs15ll_BFu15ll_BFs15s_BFu15s)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15i  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15i) C1{ FL:15 FL:15 Fi:15}



static void Test_BFs15ll_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15i, BFs15ll_BFu15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15i_BFs15i  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15i_BFs15i) C1{ FL:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFu15ll_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15i_BFs15i, BFs15ll_BFu15ll_BFu15i_BFs15i)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15i_BFs15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15i_BFs15ll) C1{ FL:15 FL:15 Fi:15 FL:15}



static void Test_BFs15ll_BFu15ll_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15i_BFs15ll, BFs15ll_BFu15ll_BFu15i_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15i_BFs15s  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15i_BFs15s) C1{ FL:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFu15ll_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15i_BFs15s, BFs15ll_BFu15ll_BFu15i_BFs15s)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15i_BFu15i  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15i_BFu15i) C1{ FL:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFu15ll_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15i_BFu15i, BFs15ll_BFu15ll_BFu15i_BFu15i)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15i_BFu15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15i_BFu15ll) C1{ FL:15 FL:15 Fi:15 FL:15}



static void Test_BFs15ll_BFu15ll_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15i_BFu15ll, BFs15ll_BFu15ll_BFu15i_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15i_BFu15s  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15i_BFu15s) C1{ FL:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFu15ll_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15i_BFu15s, BFs15ll_BFu15ll_BFu15i_BFu15s)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15ll) C1{ FL:15 FL:15 FL:15}



static void Test_BFs15ll_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15ll, BFs15ll_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15ll_BFs15i  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15ll_BFs15i) C1{ FL:15 FL:15 FL:15 Fi:15}



static void Test_BFs15ll_BFu15ll_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15ll_BFs15i, BFs15ll_BFu15ll_BFu15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15ll_BFs15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15ll_BFs15ll) C1{ FL:15 FL:15 FL:15 FL:15}



static void Test_BFs15ll_BFu15ll_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15ll_BFs15ll, BFs15ll_BFu15ll_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15ll_BFs15s  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15ll_BFs15s) C1{ FL:15 FL:15 FL:15 Fs:15}



static void Test_BFs15ll_BFu15ll_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15ll_BFs15s, BFs15ll_BFu15ll_BFu15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15ll_BFu15i  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15ll_BFu15i) C1{ FL:15 FL:15 FL:15 Fi:15}



static void Test_BFs15ll_BFu15ll_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15ll_BFu15i, BFs15ll_BFu15ll_BFu15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15ll_BFu15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15ll_BFu15ll) C1{ FL:15 FL:15 FL:15 FL:15}



static void Test_BFs15ll_BFu15ll_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15ll_BFu15ll, BFs15ll_BFu15ll_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15ll_BFu15s  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15ll_BFu15s) C1{ FL:15 FL:15 FL:15 Fs:15}



static void Test_BFs15ll_BFu15ll_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15ll_BFu15s, BFs15ll_BFu15ll_BFu15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15s  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15s) C1{ FL:15 FL:15 Fs:15}



static void Test_BFs15ll_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15s, BFs15ll_BFu15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15s_BFs15i  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15s_BFs15i) C1{ FL:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFu15ll_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15s_BFs15i, BFs15ll_BFu15ll_BFu15s_BFs15i)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15s_BFs15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15s_BFs15ll) C1{ FL:15 FL:15 Fs:15 FL:15}



static void Test_BFs15ll_BFu15ll_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15s_BFs15ll, BFs15ll_BFu15ll_BFu15s_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15s_BFs15s  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15s_BFs15s) C1{ FL:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFu15ll_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15s_BFs15s, BFs15ll_BFu15ll_BFu15s_BFs15s)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15s_BFu15i  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15s_BFu15i) C1{ FL:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFu15ll_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15s_BFu15i, BFs15ll_BFu15ll_BFu15s_BFu15i)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15s_BFu15ll  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15s_BFu15ll) C1{ FL:15 FL:15 Fs:15 FL:15}



static void Test_BFs15ll_BFu15ll_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15s_BFu15ll, BFs15ll_BFu15ll_BFu15s_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15ll_BFu15s_BFu15s  {
  signed __tsi64 v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15ll_BFu15s_BFu15s) C1{ FL:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFu15ll_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15ll_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15ll_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15ll_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15ll_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15ll_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15ll_BFu15s_BFu15s, BFs15ll_BFu15ll_BFu15s_BFu15s)
//============================================================================


struct  BFs15ll_BFu15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
};
//SIG(1 BFs15ll_BFu15s) C1{ FL:15 Fs:15}



static void Test_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s, BFs15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFu15s_BFs15i  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed int v3:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15i) C1{ FL:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15i, BFs15ll_BFu15s_BFs15i)
//============================================================================


struct  BFs15ll_BFu15s_BFs15i_BFs15i  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15i_BFs15i) C1{ FL:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFu15s_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15i_BFs15i, BFs15ll_BFu15s_BFs15i_BFs15i)
//============================================================================


struct  BFs15ll_BFu15s_BFs15i_BFs15ll  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15i_BFs15ll) C1{ FL:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15ll_BFu15s_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15i_BFs15ll, BFs15ll_BFu15s_BFs15i_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15s_BFs15i_BFs15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15i_BFs15s) C1{ FL:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFu15s_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15i_BFs15s, BFs15ll_BFu15s_BFs15i_BFs15s)
//============================================================================


struct  BFs15ll_BFu15s_BFs15i_BFu15i  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15i_BFu15i) C1{ FL:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFu15s_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15i_BFu15i, BFs15ll_BFu15s_BFs15i_BFu15i)
//============================================================================


struct  BFs15ll_BFu15s_BFs15i_BFu15ll  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15i_BFu15ll) C1{ FL:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15ll_BFu15s_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15i_BFu15ll, BFs15ll_BFu15s_BFs15i_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15s_BFs15i_BFu15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15i_BFu15s) C1{ FL:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFu15s_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15i_BFu15s, BFs15ll_BFu15s_BFs15i_BFu15s)
//============================================================================


struct  BFs15ll_BFu15s_BFs15ll  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15ll) C1{ FL:15 Fs:15 FL:15}



static void Test_BFs15ll_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15ll, BFs15ll_BFu15s_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15s_BFs15ll_BFs15i  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15ll_BFs15i) C1{ FL:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15ll_BFu15s_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15ll_BFs15i, BFs15ll_BFu15s_BFs15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFu15s_BFs15ll_BFs15ll  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15ll_BFs15ll) C1{ FL:15 Fs:15 FL:15 FL:15}



static void Test_BFs15ll_BFu15s_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15ll_BFs15ll, BFs15ll_BFu15s_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15s_BFs15ll_BFs15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15ll_BFs15s) C1{ FL:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15ll_BFu15s_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15ll_BFs15s, BFs15ll_BFu15s_BFs15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFu15s_BFs15ll_BFu15i  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15ll_BFu15i) C1{ FL:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15ll_BFu15s_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15ll_BFu15i, BFs15ll_BFu15s_BFs15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFu15s_BFs15ll_BFu15ll  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15ll_BFu15ll) C1{ FL:15 Fs:15 FL:15 FL:15}



static void Test_BFs15ll_BFu15s_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15ll_BFu15ll, BFs15ll_BFu15s_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15s_BFs15ll_BFu15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15ll_BFu15s) C1{ FL:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15ll_BFu15s_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15ll_BFu15s, BFs15ll_BFu15s_BFs15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFu15s_BFs15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed short v3:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15s) C1{ FL:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15s, BFs15ll_BFu15s_BFs15s)
//============================================================================


struct  BFs15ll_BFu15s_BFs15s_BFs15i  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15s_BFs15i) C1{ FL:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFu15s_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15s_BFs15i, BFs15ll_BFu15s_BFs15s_BFs15i)
//============================================================================


struct  BFs15ll_BFu15s_BFs15s_BFs15ll  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15s_BFs15ll) C1{ FL:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15ll_BFu15s_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15s_BFs15ll, BFs15ll_BFu15s_BFs15s_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15s_BFs15s_BFs15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15s_BFs15s) C1{ FL:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFu15s_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15s_BFs15s, BFs15ll_BFu15s_BFs15s_BFs15s)
//============================================================================


struct  BFs15ll_BFu15s_BFs15s_BFu15i  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15s_BFu15i) C1{ FL:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFu15s_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15s_BFu15i, BFs15ll_BFu15s_BFs15s_BFu15i)
//============================================================================


struct  BFs15ll_BFu15s_BFs15s_BFu15ll  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15s_BFu15ll) C1{ FL:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15ll_BFu15s_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15s_BFu15ll, BFs15ll_BFu15s_BFs15s_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15s_BFs15s_BFu15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFs15s_BFu15s) C1{ FL:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFu15s_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15s_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFs15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFs15s_BFu15s, BFs15ll_BFu15s_BFs15s_BFu15s)
//============================================================================


struct  BFs15ll_BFu15s_BFu15i  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15i) C1{ FL:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15i, BFs15ll_BFu15s_BFu15i)
//============================================================================


struct  BFs15ll_BFu15s_BFu15i_BFs15i  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15i_BFs15i) C1{ FL:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFu15s_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15i_BFs15i, BFs15ll_BFu15s_BFu15i_BFs15i)
//============================================================================


struct  BFs15ll_BFu15s_BFu15i_BFs15ll  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15i_BFs15ll) C1{ FL:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15ll_BFu15s_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15i_BFs15ll, BFs15ll_BFu15s_BFu15i_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15s_BFu15i_BFs15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15i_BFs15s) C1{ FL:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFu15s_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15i_BFs15s, BFs15ll_BFu15s_BFu15i_BFs15s)
//============================================================================


struct  BFs15ll_BFu15s_BFu15i_BFu15i  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15i_BFu15i) C1{ FL:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15ll_BFu15s_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15i_BFu15i, BFs15ll_BFu15s_BFu15i_BFu15i)
//============================================================================


struct  BFs15ll_BFu15s_BFu15i_BFu15ll  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15i_BFu15ll) C1{ FL:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15ll_BFu15s_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15i_BFu15ll, BFs15ll_BFu15s_BFu15i_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15s_BFu15i_BFu15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15i_BFu15s) C1{ FL:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15ll_BFu15s_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15i_BFu15s, BFs15ll_BFu15s_BFu15i_BFu15s)
//============================================================================


struct  BFs15ll_BFu15s_BFu15ll  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15ll) C1{ FL:15 Fs:15 FL:15}



static void Test_BFs15ll_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15ll, BFs15ll_BFu15s_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15s_BFu15ll_BFs15i  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15ll_BFs15i) C1{ FL:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15ll_BFu15s_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15ll_BFs15i, BFs15ll_BFu15s_BFu15ll_BFs15i)
//============================================================================


struct  BFs15ll_BFu15s_BFu15ll_BFs15ll  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15ll_BFs15ll) C1{ FL:15 Fs:15 FL:15 FL:15}



static void Test_BFs15ll_BFu15s_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15ll_BFs15ll, BFs15ll_BFu15s_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15s_BFu15ll_BFs15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15ll_BFs15s) C1{ FL:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15ll_BFu15s_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15ll_BFs15s, BFs15ll_BFu15s_BFu15ll_BFs15s)
//============================================================================


struct  BFs15ll_BFu15s_BFu15ll_BFu15i  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15ll_BFu15i) C1{ FL:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15ll_BFu15s_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15ll_BFu15i, BFs15ll_BFu15s_BFu15ll_BFu15i)
//============================================================================


struct  BFs15ll_BFu15s_BFu15ll_BFu15ll  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15ll_BFu15ll) C1{ FL:15 Fs:15 FL:15 FL:15}



static void Test_BFs15ll_BFu15s_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15ll_BFu15ll, BFs15ll_BFu15s_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15s_BFu15ll_BFu15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15ll_BFu15s) C1{ FL:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15ll_BFu15s_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15ll_BFu15s, BFs15ll_BFu15s_BFu15ll_BFu15s)
//============================================================================


struct  BFs15ll_BFu15s_BFu15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15s) C1{ FL:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15s, BFs15ll_BFu15s_BFu15s)
//============================================================================


struct  BFs15ll_BFu15s_BFu15s_BFs15i  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15s_BFs15i) C1{ FL:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFu15s_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15s_BFs15i, BFs15ll_BFu15s_BFu15s_BFs15i)
//============================================================================


struct  BFs15ll_BFu15s_BFu15s_BFs15ll  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15s_BFs15ll) C1{ FL:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15ll_BFu15s_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15s_BFs15ll, BFs15ll_BFu15s_BFu15s_BFs15ll)
//============================================================================


struct  BFs15ll_BFu15s_BFu15s_BFs15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15s_BFs15s) C1{ FL:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFu15s_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15s_BFs15s, BFs15ll_BFu15s_BFu15s_BFs15s)
//============================================================================


struct  BFs15ll_BFu15s_BFu15s_BFu15i  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15s_BFu15i) C1{ FL:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15ll_BFu15s_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15s_BFu15i, BFs15ll_BFu15s_BFu15s_BFu15i)
//============================================================================


struct  BFs15ll_BFu15s_BFu15s_BFu15ll  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15s_BFu15ll) C1{ FL:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15ll_BFu15s_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15ll_BFu15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15s_BFu15ll, BFs15ll_BFu15s_BFu15s_BFu15ll)
//============================================================================


struct  BFs15ll_BFu15s_BFu15s_BFu15s  {
  signed __tsi64 v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15ll_BFu15s_BFu15s_BFu15s) C1{ FL:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15ll_BFu15s_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15ll_BFu15s_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15ll_BFu15s_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15ll_BFu15s_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15ll_BFu15s_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15ll_BFu15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15ll_BFu15s_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15ll_BFu15s_BFu15s_BFu15s, BFs15ll_BFu15s_BFu15s_BFu15s)
//============================================================================


struct  BFs15s_BFs15i  {
  signed short v1:15;
  signed int v2:15;
};
//SIG(1 BFs15s_BFs15i) C1{ Fs:15 Fi:15}



static void Test_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15i lv;
    check2(sizeof(lv), 4, "sizeof(BFs15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i, BFs15s_BFs15i)
//============================================================================


struct  BFs15s_BFs15i_BFs15i  {
  signed short v1:15;
  signed int v2:15;
  signed int v3:15;
};
//SIG(1 BFs15s_BFs15i_BFs15i) C1{ Fs:15 Fi:15 Fi:15}



static void Test_BFs15s_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15i, BFs15s_BFs15i_BFs15i)
//============================================================================


struct  BFs15s_BFs15i_BFs15i_BFs15i  {
  signed short v1:15;
  signed int v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15i_BFs15i) C1{ Fs:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15s_BFs15i_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15i_BFs15i, BFs15s_BFs15i_BFs15i_BFs15i)
//============================================================================


struct  BFs15s_BFs15i_BFs15i_BFs15ll  {
  signed short v1:15;
  signed int v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15i_BFs15ll) C1{ Fs:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15s_BFs15i_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15i_BFs15ll, BFs15s_BFs15i_BFs15i_BFs15ll)
//============================================================================


struct  BFs15s_BFs15i_BFs15i_BFs15s  {
  signed short v1:15;
  signed int v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15i_BFs15s) C1{ Fs:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15s_BFs15i_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15i_BFs15s, BFs15s_BFs15i_BFs15i_BFs15s)
//============================================================================


struct  BFs15s_BFs15i_BFs15i_BFu15i  {
  signed short v1:15;
  signed int v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15i_BFu15i) C1{ Fs:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15s_BFs15i_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15i_BFu15i, BFs15s_BFs15i_BFs15i_BFu15i)
//============================================================================


struct  BFs15s_BFs15i_BFs15i_BFu15ll  {
  signed short v1:15;
  signed int v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15i_BFu15ll) C1{ Fs:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15s_BFs15i_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15i_BFu15ll, BFs15s_BFs15i_BFs15i_BFu15ll)
//============================================================================


struct  BFs15s_BFs15i_BFs15i_BFu15s  {
  signed short v1:15;
  signed int v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15i_BFu15s) C1{ Fs:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15s_BFs15i_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15i_BFu15s, BFs15s_BFs15i_BFs15i_BFu15s)
//============================================================================


struct  BFs15s_BFs15i_BFs15ll  {
  signed short v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15s_BFs15i_BFs15ll) C1{ Fs:15 Fi:15 FL:15}



static void Test_BFs15s_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15ll, BFs15s_BFs15i_BFs15ll)
//============================================================================


struct  BFs15s_BFs15i_BFs15ll_BFs15i  {
  signed short v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15ll_BFs15i) C1{ Fs:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15s_BFs15i_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15ll_BFs15i, BFs15s_BFs15i_BFs15ll_BFs15i)
//============================================================================


struct  BFs15s_BFs15i_BFs15ll_BFs15ll  {
  signed short v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15ll_BFs15ll) C1{ Fs:15 Fi:15 FL:15 FL:15}



static void Test_BFs15s_BFs15i_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15ll_BFs15ll, BFs15s_BFs15i_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15s_BFs15i_BFs15ll_BFs15s  {
  signed short v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15ll_BFs15s) C1{ Fs:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15s_BFs15i_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15ll_BFs15s, BFs15s_BFs15i_BFs15ll_BFs15s)
//============================================================================


struct  BFs15s_BFs15i_BFs15ll_BFu15i  {
  signed short v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15ll_BFu15i) C1{ Fs:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15s_BFs15i_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15ll_BFu15i, BFs15s_BFs15i_BFs15ll_BFu15i)
//============================================================================


struct  BFs15s_BFs15i_BFs15ll_BFu15ll  {
  signed short v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15ll_BFu15ll) C1{ Fs:15 Fi:15 FL:15 FL:15}



static void Test_BFs15s_BFs15i_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15ll_BFu15ll, BFs15s_BFs15i_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15s_BFs15i_BFs15ll_BFu15s  {
  signed short v1:15;
  signed int v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15ll_BFu15s) C1{ Fs:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15s_BFs15i_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15ll_BFu15s, BFs15s_BFs15i_BFs15ll_BFu15s)
//============================================================================


struct  BFs15s_BFs15i_BFs15s  {
  signed short v1:15;
  signed int v2:15;
  signed short v3:15;
};
//SIG(1 BFs15s_BFs15i_BFs15s) C1{ Fs:15 Fi:15 Fs:15}



static void Test_BFs15s_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15s, BFs15s_BFs15i_BFs15s)
//============================================================================


struct  BFs15s_BFs15i_BFs15s_BFs15i  {
  signed short v1:15;
  signed int v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15s_BFs15i) C1{ Fs:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15s_BFs15i_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15s_BFs15i, BFs15s_BFs15i_BFs15s_BFs15i)
//============================================================================


struct  BFs15s_BFs15i_BFs15s_BFs15ll  {
  signed short v1:15;
  signed int v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15s_BFs15ll) C1{ Fs:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15s_BFs15i_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15s_BFs15ll, BFs15s_BFs15i_BFs15s_BFs15ll)
//============================================================================


struct  BFs15s_BFs15i_BFs15s_BFs15s  {
  signed short v1:15;
  signed int v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15s_BFs15s) C1{ Fs:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15s_BFs15i_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15s_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15s_BFs15s, BFs15s_BFs15i_BFs15s_BFs15s)
//============================================================================


struct  BFs15s_BFs15i_BFs15s_BFu15i  {
  signed short v1:15;
  signed int v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15s_BFu15i) C1{ Fs:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15s_BFs15i_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15s_BFu15i, BFs15s_BFs15i_BFs15s_BFu15i)
//============================================================================


struct  BFs15s_BFs15i_BFs15s_BFu15ll  {
  signed short v1:15;
  signed int v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15s_BFu15ll) C1{ Fs:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15s_BFs15i_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15s_BFu15ll, BFs15s_BFs15i_BFs15s_BFu15ll)
//============================================================================


struct  BFs15s_BFs15i_BFs15s_BFu15s  {
  signed short v1:15;
  signed int v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15i_BFs15s_BFu15s) C1{ Fs:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15s_BFs15i_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15i_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15i_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFs15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFs15s_BFu15s, BFs15s_BFs15i_BFs15s_BFu15s)
//============================================================================


struct  BFs15s_BFs15i_BFu15i  {
  signed short v1:15;
  signed int v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15s_BFs15i_BFu15i) C1{ Fs:15 Fi:15 Fi:15}



static void Test_BFs15s_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15i, BFs15s_BFs15i_BFu15i)
//============================================================================


struct  BFs15s_BFs15i_BFu15i_BFs15i  {
  signed short v1:15;
  signed int v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15i_BFs15i) C1{ Fs:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15s_BFs15i_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15i_BFs15i, BFs15s_BFs15i_BFu15i_BFs15i)
//============================================================================


struct  BFs15s_BFs15i_BFu15i_BFs15ll  {
  signed short v1:15;
  signed int v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15i_BFs15ll) C1{ Fs:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15s_BFs15i_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15i_BFs15ll, BFs15s_BFs15i_BFu15i_BFs15ll)
//============================================================================


struct  BFs15s_BFs15i_BFu15i_BFs15s  {
  signed short v1:15;
  signed int v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15i_BFs15s) C1{ Fs:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15s_BFs15i_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15i_BFs15s, BFs15s_BFs15i_BFu15i_BFs15s)
//============================================================================


struct  BFs15s_BFs15i_BFu15i_BFu15i  {
  signed short v1:15;
  signed int v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15i_BFu15i) C1{ Fs:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15s_BFs15i_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15i_BFu15i, BFs15s_BFs15i_BFu15i_BFu15i)
//============================================================================


struct  BFs15s_BFs15i_BFu15i_BFu15ll  {
  signed short v1:15;
  signed int v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15i_BFu15ll) C1{ Fs:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15s_BFs15i_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15i_BFu15ll, BFs15s_BFs15i_BFu15i_BFu15ll)
//============================================================================


struct  BFs15s_BFs15i_BFu15i_BFu15s  {
  signed short v1:15;
  signed int v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15i_BFu15s) C1{ Fs:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15s_BFs15i_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15i_BFu15s, BFs15s_BFs15i_BFu15i_BFu15s)
//============================================================================


struct  BFs15s_BFs15i_BFu15ll  {
  signed short v1:15;
  signed int v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15s_BFs15i_BFu15ll) C1{ Fs:15 Fi:15 FL:15}



static void Test_BFs15s_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15ll, BFs15s_BFs15i_BFu15ll)
//============================================================================


struct  BFs15s_BFs15i_BFu15ll_BFs15i  {
  signed short v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15ll_BFs15i) C1{ Fs:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15s_BFs15i_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15ll_BFs15i, BFs15s_BFs15i_BFu15ll_BFs15i)
//============================================================================


struct  BFs15s_BFs15i_BFu15ll_BFs15ll  {
  signed short v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15ll_BFs15ll) C1{ Fs:15 Fi:15 FL:15 FL:15}



static void Test_BFs15s_BFs15i_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15ll_BFs15ll, BFs15s_BFs15i_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15s_BFs15i_BFu15ll_BFs15s  {
  signed short v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15ll_BFs15s) C1{ Fs:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15s_BFs15i_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15ll_BFs15s, BFs15s_BFs15i_BFu15ll_BFs15s)
//============================================================================


struct  BFs15s_BFs15i_BFu15ll_BFu15i  {
  signed short v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15ll_BFu15i) C1{ Fs:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15s_BFs15i_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15ll_BFu15i, BFs15s_BFs15i_BFu15ll_BFu15i)
//============================================================================


struct  BFs15s_BFs15i_BFu15ll_BFu15ll  {
  signed short v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15ll_BFu15ll) C1{ Fs:15 Fi:15 FL:15 FL:15}



static void Test_BFs15s_BFs15i_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15ll_BFu15ll, BFs15s_BFs15i_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15s_BFs15i_BFu15ll_BFu15s  {
  signed short v1:15;
  signed int v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15ll_BFu15s) C1{ Fs:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15s_BFs15i_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15ll_BFu15s, BFs15s_BFs15i_BFu15ll_BFu15s)
//============================================================================


struct  BFs15s_BFs15i_BFu15s  {
  signed short v1:15;
  signed int v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15s_BFs15i_BFu15s) C1{ Fs:15 Fi:15 Fs:15}



static void Test_BFs15s_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15s, BFs15s_BFs15i_BFu15s)
//============================================================================


struct  BFs15s_BFs15i_BFu15s_BFs15i  {
  signed short v1:15;
  signed int v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15s_BFs15i) C1{ Fs:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15s_BFs15i_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15s_BFs15i, BFs15s_BFs15i_BFu15s_BFs15i)
//============================================================================


struct  BFs15s_BFs15i_BFu15s_BFs15ll  {
  signed short v1:15;
  signed int v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15s_BFs15ll) C1{ Fs:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15s_BFs15i_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15s_BFs15ll, BFs15s_BFs15i_BFu15s_BFs15ll)
//============================================================================


struct  BFs15s_BFs15i_BFu15s_BFs15s  {
  signed short v1:15;
  signed int v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15s_BFs15s) C1{ Fs:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15s_BFs15i_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15s_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15s_BFs15s, BFs15s_BFs15i_BFu15s_BFs15s)
//============================================================================


struct  BFs15s_BFs15i_BFu15s_BFu15i  {
  signed short v1:15;
  signed int v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15s_BFu15i) C1{ Fs:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15s_BFs15i_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15s_BFu15i, BFs15s_BFs15i_BFu15s_BFu15i)
//============================================================================


struct  BFs15s_BFs15i_BFu15s_BFu15ll  {
  signed short v1:15;
  signed int v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15s_BFu15ll) C1{ Fs:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15s_BFs15i_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15i_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15s_BFu15ll, BFs15s_BFs15i_BFu15s_BFu15ll)
//============================================================================


struct  BFs15s_BFs15i_BFu15s_BFu15s  {
  signed short v1:15;
  signed int v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15i_BFu15s_BFu15s) C1{ Fs:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15s_BFs15i_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15i_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15i_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15i_BFu15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15i_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15i_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15i_BFu15s_BFu15s, BFs15s_BFs15i_BFu15s_BFu15s)
//============================================================================


struct  BFs15s_BFs15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
};
//SIG(1 BFs15s_BFs15ll) C1{ Fs:15 FL:15}



static void Test_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll, BFs15s_BFs15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFs15i  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15i) C1{ Fs:15 FL:15 Fi:15}



static void Test_BFs15s_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15i, BFs15s_BFs15ll_BFs15i)
//============================================================================


struct  BFs15s_BFs15ll_BFs15i_BFs15i  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15i_BFs15i) C1{ Fs:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15s_BFs15ll_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15i_BFs15i, BFs15s_BFs15ll_BFs15i_BFs15i)
//============================================================================


struct  BFs15s_BFs15ll_BFs15i_BFs15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15i_BFs15ll) C1{ Fs:15 FL:15 Fi:15 FL:15}



static void Test_BFs15s_BFs15ll_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15i_BFs15ll, BFs15s_BFs15ll_BFs15i_BFs15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFs15i_BFs15s  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15i_BFs15s) C1{ Fs:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15s_BFs15ll_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15i_BFs15s, BFs15s_BFs15ll_BFs15i_BFs15s)
//============================================================================


struct  BFs15s_BFs15ll_BFs15i_BFu15i  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15i_BFu15i) C1{ Fs:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15s_BFs15ll_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15i_BFu15i, BFs15s_BFs15ll_BFs15i_BFu15i)
//============================================================================


struct  BFs15s_BFs15ll_BFs15i_BFu15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15i_BFu15ll) C1{ Fs:15 FL:15 Fi:15 FL:15}



static void Test_BFs15s_BFs15ll_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15i_BFu15ll, BFs15s_BFs15ll_BFs15i_BFu15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFs15i_BFu15s  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15i_BFu15s) C1{ Fs:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15s_BFs15ll_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15i_BFu15s, BFs15s_BFs15ll_BFs15i_BFu15s)
//============================================================================


struct  BFs15s_BFs15ll_BFs15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15ll) C1{ Fs:15 FL:15 FL:15}



static void Test_BFs15s_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15ll, BFs15s_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFs15ll_BFs15i  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15ll_BFs15i) C1{ Fs:15 FL:15 FL:15 Fi:15}



static void Test_BFs15s_BFs15ll_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15ll_BFs15i, BFs15s_BFs15ll_BFs15ll_BFs15i)
//============================================================================


struct  BFs15s_BFs15ll_BFs15ll_BFs15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15ll_BFs15ll) C1{ Fs:15 FL:15 FL:15 FL:15}



static void Test_BFs15s_BFs15ll_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15ll_BFs15ll, BFs15s_BFs15ll_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFs15ll_BFs15s  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15ll_BFs15s) C1{ Fs:15 FL:15 FL:15 Fs:15}



static void Test_BFs15s_BFs15ll_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15ll_BFs15s, BFs15s_BFs15ll_BFs15ll_BFs15s)
//============================================================================


struct  BFs15s_BFs15ll_BFs15ll_BFu15i  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15ll_BFu15i) C1{ Fs:15 FL:15 FL:15 Fi:15}



static void Test_BFs15s_BFs15ll_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15ll_BFu15i, BFs15s_BFs15ll_BFs15ll_BFu15i)
//============================================================================


struct  BFs15s_BFs15ll_BFs15ll_BFu15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15ll_BFu15ll) C1{ Fs:15 FL:15 FL:15 FL:15}



static void Test_BFs15s_BFs15ll_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15ll_BFu15ll, BFs15s_BFs15ll_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFs15ll_BFu15s  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15ll_BFu15s) C1{ Fs:15 FL:15 FL:15 Fs:15}



static void Test_BFs15s_BFs15ll_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15ll_BFu15s, BFs15s_BFs15ll_BFs15ll_BFu15s)
//============================================================================


struct  BFs15s_BFs15ll_BFs15s  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15s) C1{ Fs:15 FL:15 Fs:15}



static void Test_BFs15s_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15s, BFs15s_BFs15ll_BFs15s)
//============================================================================


struct  BFs15s_BFs15ll_BFs15s_BFs15i  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15s_BFs15i) C1{ Fs:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15s_BFs15ll_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15s_BFs15i, BFs15s_BFs15ll_BFs15s_BFs15i)
//============================================================================


struct  BFs15s_BFs15ll_BFs15s_BFs15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15s_BFs15ll) C1{ Fs:15 FL:15 Fs:15 FL:15}



static void Test_BFs15s_BFs15ll_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15s_BFs15ll, BFs15s_BFs15ll_BFs15s_BFs15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFs15s_BFs15s  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15s_BFs15s) C1{ Fs:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15s_BFs15ll_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15s_BFs15s, BFs15s_BFs15ll_BFs15s_BFs15s)
//============================================================================


struct  BFs15s_BFs15ll_BFs15s_BFu15i  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15s_BFu15i) C1{ Fs:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15s_BFs15ll_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15s_BFu15i, BFs15s_BFs15ll_BFs15s_BFu15i)
//============================================================================


struct  BFs15s_BFs15ll_BFs15s_BFu15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15s_BFu15ll) C1{ Fs:15 FL:15 Fs:15 FL:15}



static void Test_BFs15s_BFs15ll_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15s_BFu15ll, BFs15s_BFs15ll_BFs15s_BFu15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFs15s_BFu15s  {
  signed short v1:15;
  signed __tsi64 v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFs15s_BFu15s) C1{ Fs:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15s_BFs15ll_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15ll_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFs15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFs15s_BFu15s, BFs15s_BFs15ll_BFs15s_BFu15s)
//============================================================================


struct  BFs15s_BFs15ll_BFu15i  {
  signed short v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15i) C1{ Fs:15 FL:15 Fi:15}



static void Test_BFs15s_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15i, BFs15s_BFs15ll_BFu15i)
//============================================================================


struct  BFs15s_BFs15ll_BFu15i_BFs15i  {
  signed short v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15i_BFs15i) C1{ Fs:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15s_BFs15ll_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15i_BFs15i, BFs15s_BFs15ll_BFu15i_BFs15i)
//============================================================================


struct  BFs15s_BFs15ll_BFu15i_BFs15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15i_BFs15ll) C1{ Fs:15 FL:15 Fi:15 FL:15}



static void Test_BFs15s_BFs15ll_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15i_BFs15ll, BFs15s_BFs15ll_BFu15i_BFs15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFu15i_BFs15s  {
  signed short v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15i_BFs15s) C1{ Fs:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15s_BFs15ll_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15i_BFs15s, BFs15s_BFs15ll_BFu15i_BFs15s)
//============================================================================


struct  BFs15s_BFs15ll_BFu15i_BFu15i  {
  signed short v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15i_BFu15i) C1{ Fs:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15s_BFs15ll_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15i_BFu15i, BFs15s_BFs15ll_BFu15i_BFu15i)
//============================================================================


struct  BFs15s_BFs15ll_BFu15i_BFu15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15i_BFu15ll) C1{ Fs:15 FL:15 Fi:15 FL:15}



static void Test_BFs15s_BFs15ll_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15i_BFu15ll, BFs15s_BFs15ll_BFu15i_BFu15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFu15i_BFu15s  {
  signed short v1:15;
  signed __tsi64 v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15i_BFu15s) C1{ Fs:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15s_BFs15ll_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15i_BFu15s, BFs15s_BFs15ll_BFu15i_BFu15s)
//============================================================================


struct  BFs15s_BFs15ll_BFu15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15ll) C1{ Fs:15 FL:15 FL:15}



static void Test_BFs15s_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15ll, BFs15s_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFu15ll_BFs15i  {
  signed short v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15ll_BFs15i) C1{ Fs:15 FL:15 FL:15 Fi:15}



static void Test_BFs15s_BFs15ll_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15ll_BFs15i, BFs15s_BFs15ll_BFu15ll_BFs15i)
//============================================================================


struct  BFs15s_BFs15ll_BFu15ll_BFs15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15ll_BFs15ll) C1{ Fs:15 FL:15 FL:15 FL:15}



static void Test_BFs15s_BFs15ll_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15ll_BFs15ll, BFs15s_BFs15ll_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFu15ll_BFs15s  {
  signed short v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15ll_BFs15s) C1{ Fs:15 FL:15 FL:15 Fs:15}



static void Test_BFs15s_BFs15ll_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15ll_BFs15s, BFs15s_BFs15ll_BFu15ll_BFs15s)
//============================================================================


struct  BFs15s_BFs15ll_BFu15ll_BFu15i  {
  signed short v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15ll_BFu15i) C1{ Fs:15 FL:15 FL:15 Fi:15}



static void Test_BFs15s_BFs15ll_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15ll_BFu15i, BFs15s_BFs15ll_BFu15ll_BFu15i)
//============================================================================


struct  BFs15s_BFs15ll_BFu15ll_BFu15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15ll_BFu15ll) C1{ Fs:15 FL:15 FL:15 FL:15}



static void Test_BFs15s_BFs15ll_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15ll_BFu15ll, BFs15s_BFs15ll_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFu15ll_BFu15s  {
  signed short v1:15;
  signed __tsi64 v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15ll_BFu15s) C1{ Fs:15 FL:15 FL:15 Fs:15}



static void Test_BFs15s_BFs15ll_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15ll_BFu15s, BFs15s_BFs15ll_BFu15ll_BFu15s)
//============================================================================


struct  BFs15s_BFs15ll_BFu15s  {
  signed short v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15s) C1{ Fs:15 FL:15 Fs:15}



static void Test_BFs15s_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15s, BFs15s_BFs15ll_BFu15s)
//============================================================================


struct  BFs15s_BFs15ll_BFu15s_BFs15i  {
  signed short v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15s_BFs15i) C1{ Fs:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15s_BFs15ll_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15s_BFs15i, BFs15s_BFs15ll_BFu15s_BFs15i)
//============================================================================


struct  BFs15s_BFs15ll_BFu15s_BFs15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15s_BFs15ll) C1{ Fs:15 FL:15 Fs:15 FL:15}



static void Test_BFs15s_BFs15ll_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15s_BFs15ll, BFs15s_BFs15ll_BFu15s_BFs15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFu15s_BFs15s  {
  signed short v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15s_BFs15s) C1{ Fs:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15s_BFs15ll_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15s_BFs15s, BFs15s_BFs15ll_BFu15s_BFs15s)
//============================================================================


struct  BFs15s_BFs15ll_BFu15s_BFu15i  {
  signed short v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15s_BFu15i) C1{ Fs:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15s_BFs15ll_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15s_BFu15i, BFs15s_BFs15ll_BFu15s_BFu15i)
//============================================================================


struct  BFs15s_BFs15ll_BFu15s_BFu15ll  {
  signed short v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15s_BFu15ll) C1{ Fs:15 FL:15 Fs:15 FL:15}



static void Test_BFs15s_BFs15ll_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15s_BFu15ll, BFs15s_BFs15ll_BFu15s_BFu15ll)
//============================================================================


struct  BFs15s_BFs15ll_BFu15s_BFu15s  {
  signed short v1:15;
  signed __tsi64 v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15ll_BFu15s_BFu15s) C1{ Fs:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15s_BFs15ll_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15ll_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15ll_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15ll_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15ll_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15ll_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15ll_BFu15s_BFu15s, BFs15s_BFs15ll_BFu15s_BFu15s)
//============================================================================


struct  BFs15s_BFs15s  {
  signed short v1:15;
  signed short v2:15;
};
//SIG(1 BFs15s_BFs15s) C1{ Fs:15 Fs:15}



static void Test_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15s lv;
    check2(sizeof(lv), 4, "sizeof(BFs15s_BFs15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s, BFs15s_BFs15s)
//============================================================================


struct  BFs15s_BFs15s_BFs15i  {
  signed short v1:15;
  signed short v2:15;
  signed int v3:15;
};
//SIG(1 BFs15s_BFs15s_BFs15i) C1{ Fs:15 Fs:15 Fi:15}



static void Test_BFs15s_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15i, BFs15s_BFs15s_BFs15i)
//============================================================================


struct  BFs15s_BFs15s_BFs15i_BFs15i  {
  signed short v1:15;
  signed short v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15i_BFs15i) C1{ Fs:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15s_BFs15s_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15s_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15i_BFs15i, BFs15s_BFs15s_BFs15i_BFs15i)
//============================================================================


struct  BFs15s_BFs15s_BFs15i_BFs15ll  {
  signed short v1:15;
  signed short v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15i_BFs15ll) C1{ Fs:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15s_BFs15s_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15i_BFs15ll, BFs15s_BFs15s_BFs15i_BFs15ll)
//============================================================================


struct  BFs15s_BFs15s_BFs15i_BFs15s  {
  signed short v1:15;
  signed short v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15i_BFs15s) C1{ Fs:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15s_BFs15s_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15s_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15i_BFs15s, BFs15s_BFs15s_BFs15i_BFs15s)
//============================================================================


struct  BFs15s_BFs15s_BFs15i_BFu15i  {
  signed short v1:15;
  signed short v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15i_BFu15i) C1{ Fs:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15s_BFs15s_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15s_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15i_BFu15i, BFs15s_BFs15s_BFs15i_BFu15i)
//============================================================================


struct  BFs15s_BFs15s_BFs15i_BFu15ll  {
  signed short v1:15;
  signed short v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15i_BFu15ll) C1{ Fs:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15s_BFs15s_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15i_BFu15ll, BFs15s_BFs15s_BFs15i_BFu15ll)
//============================================================================


struct  BFs15s_BFs15s_BFs15i_BFu15s  {
  signed short v1:15;
  signed short v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15i_BFu15s) C1{ Fs:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15s_BFs15s_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15s_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15i_BFu15s, BFs15s_BFs15s_BFs15i_BFu15s)
//============================================================================


struct  BFs15s_BFs15s_BFs15ll  {
  signed short v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15s_BFs15s_BFs15ll) C1{ Fs:15 Fs:15 FL:15}



static void Test_BFs15s_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15ll, BFs15s_BFs15s_BFs15ll)
//============================================================================


struct  BFs15s_BFs15s_BFs15ll_BFs15i  {
  signed short v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15ll_BFs15i) C1{ Fs:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15s_BFs15s_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFs15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15ll_BFs15i, BFs15s_BFs15s_BFs15ll_BFs15i)
//============================================================================


struct  BFs15s_BFs15s_BFs15ll_BFs15ll  {
  signed short v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15ll_BFs15ll) C1{ Fs:15 Fs:15 FL:15 FL:15}



static void Test_BFs15s_BFs15s_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFs15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15ll_BFs15ll, BFs15s_BFs15s_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15s_BFs15s_BFs15ll_BFs15s  {
  signed short v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15ll_BFs15s) C1{ Fs:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15s_BFs15s_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15ll_BFs15s, BFs15s_BFs15s_BFs15ll_BFs15s)
//============================================================================


struct  BFs15s_BFs15s_BFs15ll_BFu15i  {
  signed short v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15ll_BFu15i) C1{ Fs:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15s_BFs15s_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFs15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15ll_BFu15i, BFs15s_BFs15s_BFs15ll_BFu15i)
//============================================================================


struct  BFs15s_BFs15s_BFs15ll_BFu15ll  {
  signed short v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15ll_BFu15ll) C1{ Fs:15 Fs:15 FL:15 FL:15}



static void Test_BFs15s_BFs15s_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFs15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15ll_BFu15ll, BFs15s_BFs15s_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15s_BFs15s_BFs15ll_BFu15s  {
  signed short v1:15;
  signed short v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15ll_BFu15s) C1{ Fs:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15s_BFs15s_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15ll_BFu15s, BFs15s_BFs15s_BFs15ll_BFu15s)
//============================================================================


struct  BFs15s_BFs15s_BFs15s  {
  signed short v1:15;
  signed short v2:15;
  signed short v3:15;
};
//SIG(1 BFs15s_BFs15s_BFs15s) C1{ Fs:15 Fs:15 Fs:15}



static void Test_BFs15s_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15s lv;
    check2(sizeof(lv), 6, "sizeof(BFs15s_BFs15s_BFs15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs15s_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15s, BFs15s_BFs15s_BFs15s)
//============================================================================


struct  BFs15s_BFs15s_BFs15s_BFs15i  {
  signed short v1:15;
  signed short v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15s_BFs15i) C1{ Fs:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15s_BFs15s_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15s_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15s_BFs15i, BFs15s_BFs15s_BFs15s_BFs15i)
//============================================================================


struct  BFs15s_BFs15s_BFs15s_BFs15ll  {
  signed short v1:15;
  signed short v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15s_BFs15ll) C1{ Fs:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15s_BFs15s_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15s_BFs15ll, BFs15s_BFs15s_BFs15s_BFs15ll)
//============================================================================


struct  BFs15s_BFs15s_BFs15s_BFs15s  {
  signed short v1:15;
  signed short v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15s_BFs15s) C1{ Fs:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15s_BFs15s_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15s_BFs15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs15s_BFs15s_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15s_BFs15s, BFs15s_BFs15s_BFs15s_BFs15s)
//============================================================================


struct  BFs15s_BFs15s_BFs15s_BFu15i  {
  signed short v1:15;
  signed short v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15s_BFu15i) C1{ Fs:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15s_BFs15s_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15s_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15s_BFu15i, BFs15s_BFs15s_BFs15s_BFu15i)
//============================================================================


struct  BFs15s_BFs15s_BFs15s_BFu15ll  {
  signed short v1:15;
  signed short v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15s_BFu15ll) C1{ Fs:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15s_BFs15s_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15s_BFu15ll, BFs15s_BFs15s_BFs15s_BFu15ll)
//============================================================================


struct  BFs15s_BFs15s_BFs15s_BFu15s  {
  signed short v1:15;
  signed short v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15s_BFs15s_BFu15s) C1{ Fs:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15s_BFs15s_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15s_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15s_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFs15s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs15s_BFs15s_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFs15s_BFu15s, BFs15s_BFs15s_BFs15s_BFu15s)
//============================================================================


struct  BFs15s_BFs15s_BFu15i  {
  signed short v1:15;
  signed short v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15s_BFs15s_BFu15i) C1{ Fs:15 Fs:15 Fi:15}



static void Test_BFs15s_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15i, BFs15s_BFs15s_BFu15i)
//============================================================================


struct  BFs15s_BFs15s_BFu15i_BFs15i  {
  signed short v1:15;
  signed short v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15i_BFs15i) C1{ Fs:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15s_BFs15s_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15s_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15i_BFs15i, BFs15s_BFs15s_BFu15i_BFs15i)
//============================================================================


struct  BFs15s_BFs15s_BFu15i_BFs15ll  {
  signed short v1:15;
  signed short v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15i_BFs15ll) C1{ Fs:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15s_BFs15s_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15i_BFs15ll, BFs15s_BFs15s_BFu15i_BFs15ll)
//============================================================================


struct  BFs15s_BFs15s_BFu15i_BFs15s  {
  signed short v1:15;
  signed short v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15i_BFs15s) C1{ Fs:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15s_BFs15s_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15s_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15i_BFs15s, BFs15s_BFs15s_BFu15i_BFs15s)
//============================================================================


struct  BFs15s_BFs15s_BFu15i_BFu15i  {
  signed short v1:15;
  signed short v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15i_BFu15i) C1{ Fs:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15s_BFs15s_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15s_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15i_BFu15i, BFs15s_BFs15s_BFu15i_BFu15i)
//============================================================================


struct  BFs15s_BFs15s_BFu15i_BFu15ll  {
  signed short v1:15;
  signed short v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15i_BFu15ll) C1{ Fs:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15s_BFs15s_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15i_BFu15ll, BFs15s_BFs15s_BFu15i_BFu15ll)
//============================================================================


struct  BFs15s_BFs15s_BFu15i_BFu15s  {
  signed short v1:15;
  signed short v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15i_BFu15s) C1{ Fs:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15s_BFs15s_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15s_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15i_BFu15s, BFs15s_BFs15s_BFu15i_BFu15s)
//============================================================================


struct  BFs15s_BFs15s_BFu15ll  {
  signed short v1:15;
  signed short v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15s_BFs15s_BFu15ll) C1{ Fs:15 Fs:15 FL:15}



static void Test_BFs15s_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15ll, BFs15s_BFs15s_BFu15ll)
//============================================================================


struct  BFs15s_BFs15s_BFu15ll_BFs15i  {
  signed short v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15ll_BFs15i) C1{ Fs:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15s_BFs15s_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15ll_BFs15i, BFs15s_BFs15s_BFu15ll_BFs15i)
//============================================================================


struct  BFs15s_BFs15s_BFu15ll_BFs15ll  {
  signed short v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15ll_BFs15ll) C1{ Fs:15 Fs:15 FL:15 FL:15}



static void Test_BFs15s_BFs15s_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15ll_BFs15ll, BFs15s_BFs15s_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15s_BFs15s_BFu15ll_BFs15s  {
  signed short v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15ll_BFs15s) C1{ Fs:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15s_BFs15s_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15ll_BFs15s, BFs15s_BFs15s_BFu15ll_BFs15s)
//============================================================================


struct  BFs15s_BFs15s_BFu15ll_BFu15i  {
  signed short v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15ll_BFu15i) C1{ Fs:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15s_BFs15s_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15ll_BFu15i, BFs15s_BFs15s_BFu15ll_BFu15i)
//============================================================================


struct  BFs15s_BFs15s_BFu15ll_BFu15ll  {
  signed short v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15ll_BFu15ll) C1{ Fs:15 Fs:15 FL:15 FL:15}



static void Test_BFs15s_BFs15s_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15ll_BFu15ll, BFs15s_BFs15s_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15s_BFs15s_BFu15ll_BFu15s  {
  signed short v1:15;
  signed short v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15ll_BFu15s) C1{ Fs:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15s_BFs15s_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15ll_BFu15s, BFs15s_BFs15s_BFu15ll_BFu15s)
//============================================================================


struct  BFs15s_BFs15s_BFu15s  {
  signed short v1:15;
  signed short v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15s_BFs15s_BFu15s) C1{ Fs:15 Fs:15 Fs:15}



static void Test_BFs15s_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFs15s_BFs15s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs15s_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15s, BFs15s_BFs15s_BFu15s)
//============================================================================


struct  BFs15s_BFs15s_BFu15s_BFs15i  {
  signed short v1:15;
  signed short v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15s_BFs15i) C1{ Fs:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15s_BFs15s_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15s_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15s_BFs15i, BFs15s_BFs15s_BFu15s_BFs15i)
//============================================================================


struct  BFs15s_BFs15s_BFu15s_BFs15ll  {
  signed short v1:15;
  signed short v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15s_BFs15ll) C1{ Fs:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15s_BFs15s_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15s_BFs15ll, BFs15s_BFs15s_BFu15s_BFs15ll)
//============================================================================


struct  BFs15s_BFs15s_BFu15s_BFs15s  {
  signed short v1:15;
  signed short v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15s_BFs15s) C1{ Fs:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15s_BFs15s_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15s_BFs15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs15s_BFs15s_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15s_BFs15s, BFs15s_BFs15s_BFu15s_BFs15s)
//============================================================================


struct  BFs15s_BFs15s_BFu15s_BFu15i  {
  signed short v1:15;
  signed short v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15s_BFu15i) C1{ Fs:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15s_BFs15s_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFs15s_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15s_BFu15i, BFs15s_BFs15s_BFu15s_BFu15i)
//============================================================================


struct  BFs15s_BFs15s_BFu15s_BFu15ll  {
  signed short v1:15;
  signed short v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15s_BFu15ll) C1{ Fs:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15s_BFs15s_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFs15s_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15s_BFu15ll, BFs15s_BFs15s_BFu15s_BFu15ll)
//============================================================================


struct  BFs15s_BFs15s_BFu15s_BFu15s  {
  signed short v1:15;
  signed short v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFs15s_BFu15s_BFu15s) C1{ Fs:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15s_BFs15s_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15s_BFs15s_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15s_BFs15s_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFs15s_BFu15s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs15s_BFs15s_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_sll(1LL<<14), "BFs15s_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFs15s_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFs15s_BFu15s_BFu15s, BFs15s_BFs15s_BFu15s_BFu15s)
//============================================================================


struct  BFs15s_BFu15i  {
  signed short v1:15;
  unsigned int v2:15;
};
//SIG(1 BFs15s_BFu15i) C1{ Fs:15 Fi:15}



static void Test_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFs15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i, BFs15s_BFu15i)
//============================================================================


struct  BFs15s_BFu15i_BFs15i  {
  signed short v1:15;
  unsigned int v2:15;
  signed int v3:15;
};
//SIG(1 BFs15s_BFu15i_BFs15i) C1{ Fs:15 Fi:15 Fi:15}



static void Test_BFs15s_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15i, BFs15s_BFu15i_BFs15i)
//============================================================================


struct  BFs15s_BFu15i_BFs15i_BFs15i  {
  signed short v1:15;
  unsigned int v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15i_BFs15i) C1{ Fs:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15s_BFu15i_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15i_BFs15i, BFs15s_BFu15i_BFs15i_BFs15i)
//============================================================================


struct  BFs15s_BFu15i_BFs15i_BFs15ll  {
  signed short v1:15;
  unsigned int v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15i_BFs15ll) C1{ Fs:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15s_BFu15i_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15i_BFs15ll, BFs15s_BFu15i_BFs15i_BFs15ll)
//============================================================================


struct  BFs15s_BFu15i_BFs15i_BFs15s  {
  signed short v1:15;
  unsigned int v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15i_BFs15s) C1{ Fs:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15s_BFu15i_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15i_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15i_BFs15s, BFs15s_BFu15i_BFs15i_BFs15s)
//============================================================================


struct  BFs15s_BFu15i_BFs15i_BFu15i  {
  signed short v1:15;
  unsigned int v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15i_BFu15i) C1{ Fs:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15s_BFu15i_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15i_BFu15i, BFs15s_BFu15i_BFs15i_BFu15i)
//============================================================================


struct  BFs15s_BFu15i_BFs15i_BFu15ll  {
  signed short v1:15;
  unsigned int v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15i_BFu15ll) C1{ Fs:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15s_BFu15i_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15i_BFu15ll, BFs15s_BFu15i_BFs15i_BFu15ll)
//============================================================================


struct  BFs15s_BFu15i_BFs15i_BFu15s  {
  signed short v1:15;
  unsigned int v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15i_BFu15s) C1{ Fs:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15s_BFu15i_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15i_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15i_BFu15s, BFs15s_BFu15i_BFs15i_BFu15s)
//============================================================================


struct  BFs15s_BFu15i_BFs15ll  {
  signed short v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15s_BFu15i_BFs15ll) C1{ Fs:15 Fi:15 FL:15}



static void Test_BFs15s_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15ll, BFs15s_BFu15i_BFs15ll)
//============================================================================


struct  BFs15s_BFu15i_BFs15ll_BFs15i  {
  signed short v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15ll_BFs15i) C1{ Fs:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15s_BFu15i_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15i_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15ll_BFs15i, BFs15s_BFu15i_BFs15ll_BFs15i)
//============================================================================


struct  BFs15s_BFu15i_BFs15ll_BFs15ll  {
  signed short v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15ll_BFs15ll) C1{ Fs:15 Fi:15 FL:15 FL:15}



static void Test_BFs15s_BFu15i_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15i_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15ll_BFs15ll, BFs15s_BFu15i_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15s_BFu15i_BFs15ll_BFs15s  {
  signed short v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15ll_BFs15s) C1{ Fs:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15s_BFu15i_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15i_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15ll_BFs15s, BFs15s_BFu15i_BFs15ll_BFs15s)
//============================================================================


struct  BFs15s_BFu15i_BFs15ll_BFu15i  {
  signed short v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15ll_BFu15i) C1{ Fs:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15s_BFu15i_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15i_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15ll_BFu15i, BFs15s_BFu15i_BFs15ll_BFu15i)
//============================================================================


struct  BFs15s_BFu15i_BFs15ll_BFu15ll  {
  signed short v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15ll_BFu15ll) C1{ Fs:15 Fi:15 FL:15 FL:15}



static void Test_BFs15s_BFu15i_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15i_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15ll_BFu15ll, BFs15s_BFu15i_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15s_BFu15i_BFs15ll_BFu15s  {
  signed short v1:15;
  unsigned int v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15ll_BFu15s) C1{ Fs:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15s_BFu15i_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15i_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15ll_BFu15s, BFs15s_BFu15i_BFs15ll_BFu15s)
//============================================================================


struct  BFs15s_BFu15i_BFs15s  {
  signed short v1:15;
  unsigned int v2:15;
  signed short v3:15;
};
//SIG(1 BFs15s_BFu15i_BFs15s) C1{ Fs:15 Fi:15 Fs:15}



static void Test_BFs15s_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15s, BFs15s_BFu15i_BFs15s)
//============================================================================


struct  BFs15s_BFu15i_BFs15s_BFs15i  {
  signed short v1:15;
  unsigned int v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15s_BFs15i) C1{ Fs:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15s_BFu15i_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15s_BFs15i, BFs15s_BFu15i_BFs15s_BFs15i)
//============================================================================


struct  BFs15s_BFu15i_BFs15s_BFs15ll  {
  signed short v1:15;
  unsigned int v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15s_BFs15ll) C1{ Fs:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15s_BFu15i_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15s_BFs15ll, BFs15s_BFu15i_BFs15s_BFs15ll)
//============================================================================


struct  BFs15s_BFu15i_BFs15s_BFs15s  {
  signed short v1:15;
  unsigned int v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15s_BFs15s) C1{ Fs:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15s_BFu15i_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15s_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15i_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15s_BFs15s, BFs15s_BFu15i_BFs15s_BFs15s)
//============================================================================


struct  BFs15s_BFu15i_BFs15s_BFu15i  {
  signed short v1:15;
  unsigned int v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15s_BFu15i) C1{ Fs:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15s_BFu15i_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15s_BFu15i, BFs15s_BFu15i_BFs15s_BFu15i)
//============================================================================


struct  BFs15s_BFu15i_BFs15s_BFu15ll  {
  signed short v1:15;
  unsigned int v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15s_BFu15ll) C1{ Fs:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15s_BFu15i_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15s_BFu15ll, BFs15s_BFu15i_BFs15s_BFu15ll)
//============================================================================


struct  BFs15s_BFu15i_BFs15s_BFu15s  {
  signed short v1:15;
  unsigned int v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15i_BFs15s_BFu15s) C1{ Fs:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15s_BFu15i_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15i_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15i_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFs15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15i_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFs15s_BFu15s, BFs15s_BFu15i_BFs15s_BFu15s)
//============================================================================


struct  BFs15s_BFu15i_BFu15i  {
  signed short v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15s_BFu15i_BFu15i) C1{ Fs:15 Fi:15 Fi:15}



static void Test_BFs15s_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15i, BFs15s_BFu15i_BFu15i)
//============================================================================


struct  BFs15s_BFu15i_BFu15i_BFs15i  {
  signed short v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15i_BFs15i) C1{ Fs:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15s_BFu15i_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15i_BFs15i, BFs15s_BFu15i_BFu15i_BFs15i)
//============================================================================


struct  BFs15s_BFu15i_BFu15i_BFs15ll  {
  signed short v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15i_BFs15ll) C1{ Fs:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15s_BFu15i_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15i_BFs15ll, BFs15s_BFu15i_BFu15i_BFs15ll)
//============================================================================


struct  BFs15s_BFu15i_BFu15i_BFs15s  {
  signed short v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15i_BFs15s) C1{ Fs:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15s_BFu15i_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15i_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15i_BFs15s, BFs15s_BFu15i_BFu15i_BFs15s)
//============================================================================


struct  BFs15s_BFu15i_BFu15i_BFu15i  {
  signed short v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15i_BFu15i) C1{ Fs:15 Fi:15 Fi:15 Fi:15}



static void Test_BFs15s_BFu15i_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15i_BFu15i, BFs15s_BFu15i_BFu15i_BFu15i)
//============================================================================


struct  BFs15s_BFu15i_BFu15i_BFu15ll  {
  signed short v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15i_BFu15ll) C1{ Fs:15 Fi:15 Fi:15 FL:15}



static void Test_BFs15s_BFu15i_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15i_BFu15ll, BFs15s_BFu15i_BFu15i_BFu15ll)
//============================================================================


struct  BFs15s_BFu15i_BFu15i_BFu15s  {
  signed short v1:15;
  unsigned int v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15i_BFu15s) C1{ Fs:15 Fi:15 Fi:15 Fs:15}



static void Test_BFs15s_BFu15i_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15i_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15i_BFu15s, BFs15s_BFu15i_BFu15i_BFu15s)
//============================================================================


struct  BFs15s_BFu15i_BFu15ll  {
  signed short v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15s_BFu15i_BFu15ll) C1{ Fs:15 Fi:15 FL:15}



static void Test_BFs15s_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15ll, BFs15s_BFu15i_BFu15ll)
//============================================================================


struct  BFs15s_BFu15i_BFu15ll_BFs15i  {
  signed short v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15ll_BFs15i) C1{ Fs:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15s_BFu15i_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15i_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15ll_BFs15i, BFs15s_BFu15i_BFu15ll_BFs15i)
//============================================================================


struct  BFs15s_BFu15i_BFu15ll_BFs15ll  {
  signed short v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15ll_BFs15ll) C1{ Fs:15 Fi:15 FL:15 FL:15}



static void Test_BFs15s_BFu15i_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15i_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15ll_BFs15ll, BFs15s_BFu15i_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15s_BFu15i_BFu15ll_BFs15s  {
  signed short v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15ll_BFs15s) C1{ Fs:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15s_BFu15i_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15i_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15ll_BFs15s, BFs15s_BFu15i_BFu15ll_BFs15s)
//============================================================================


struct  BFs15s_BFu15i_BFu15ll_BFu15i  {
  signed short v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15ll_BFu15i) C1{ Fs:15 Fi:15 FL:15 Fi:15}



static void Test_BFs15s_BFu15i_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15i_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15ll_BFu15i, BFs15s_BFu15i_BFu15ll_BFu15i)
//============================================================================


struct  BFs15s_BFu15i_BFu15ll_BFu15ll  {
  signed short v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15ll_BFu15ll) C1{ Fs:15 Fi:15 FL:15 FL:15}



static void Test_BFs15s_BFu15i_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15i_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15ll_BFu15ll, BFs15s_BFu15i_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15s_BFu15i_BFu15ll_BFu15s  {
  signed short v1:15;
  unsigned int v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15ll_BFu15s) C1{ Fs:15 Fi:15 FL:15 Fs:15}



static void Test_BFs15s_BFu15i_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15i_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15ll_BFu15s, BFs15s_BFu15i_BFu15ll_BFu15s)
//============================================================================


struct  BFs15s_BFu15i_BFu15s  {
  signed short v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15s_BFu15i_BFu15s) C1{ Fs:15 Fi:15 Fs:15}



static void Test_BFs15s_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15s, BFs15s_BFu15i_BFu15s)
//============================================================================


struct  BFs15s_BFu15i_BFu15s_BFs15i  {
  signed short v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15s_BFs15i) C1{ Fs:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15s_BFu15i_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15s_BFs15i, BFs15s_BFu15i_BFu15s_BFs15i)
//============================================================================


struct  BFs15s_BFu15i_BFu15s_BFs15ll  {
  signed short v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15s_BFs15ll) C1{ Fs:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15s_BFu15i_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15s_BFs15ll, BFs15s_BFu15i_BFu15s_BFs15ll)
//============================================================================


struct  BFs15s_BFu15i_BFu15s_BFs15s  {
  signed short v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15s_BFs15s) C1{ Fs:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15s_BFu15i_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15s_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15i_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15s_BFs15s, BFs15s_BFu15i_BFu15s_BFs15s)
//============================================================================


struct  BFs15s_BFu15i_BFu15s_BFu15i  {
  signed short v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15s_BFu15i) C1{ Fs:15 Fi:15 Fs:15 Fi:15}



static void Test_BFs15s_BFu15i_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15s_BFu15i, BFs15s_BFu15i_BFu15s_BFu15i)
//============================================================================


struct  BFs15s_BFu15i_BFu15s_BFu15ll  {
  signed short v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15s_BFu15ll) C1{ Fs:15 Fi:15 Fs:15 FL:15}



static void Test_BFs15s_BFu15i_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15i_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15i_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15s_BFu15ll, BFs15s_BFu15i_BFu15s_BFu15ll)
//============================================================================


struct  BFs15s_BFu15i_BFu15s_BFu15s  {
  signed short v1:15;
  unsigned int v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15i_BFu15s_BFu15s) C1{ Fs:15 Fi:15 Fs:15 Fs:15}



static void Test_BFs15s_BFu15i_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15i_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15i_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15i_BFu15s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15i_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15i_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15i_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15i_BFu15s_BFu15s, BFs15s_BFu15i_BFu15s_BFu15s)
//============================================================================


struct  BFs15s_BFu15ll  {
  signed short v1:15;
  __tsu64 v2:15;
};
//SIG(1 BFs15s_BFu15ll) C1{ Fs:15 FL:15}



static void Test_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll, BFs15s_BFu15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFs15i  {
  signed short v1:15;
  __tsu64 v2:15;
  signed int v3:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15i) C1{ Fs:15 FL:15 Fi:15}



static void Test_BFs15s_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15i, BFs15s_BFu15ll_BFs15i)
//============================================================================


struct  BFs15s_BFu15ll_BFs15i_BFs15i  {
  signed short v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15i_BFs15i) C1{ Fs:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15s_BFu15ll_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15i_BFs15i, BFs15s_BFu15ll_BFs15i_BFs15i)
//============================================================================


struct  BFs15s_BFu15ll_BFs15i_BFs15ll  {
  signed short v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15i_BFs15ll) C1{ Fs:15 FL:15 Fi:15 FL:15}



static void Test_BFs15s_BFu15ll_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15i_BFs15ll, BFs15s_BFu15ll_BFs15i_BFs15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFs15i_BFs15s  {
  signed short v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15i_BFs15s) C1{ Fs:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15s_BFu15ll_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15ll_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15i_BFs15s, BFs15s_BFu15ll_BFs15i_BFs15s)
//============================================================================


struct  BFs15s_BFu15ll_BFs15i_BFu15i  {
  signed short v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15i_BFu15i) C1{ Fs:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15s_BFu15ll_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15i_BFu15i, BFs15s_BFu15ll_BFs15i_BFu15i)
//============================================================================


struct  BFs15s_BFu15ll_BFs15i_BFu15ll  {
  signed short v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15i_BFu15ll) C1{ Fs:15 FL:15 Fi:15 FL:15}



static void Test_BFs15s_BFu15ll_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15i_BFu15ll, BFs15s_BFu15ll_BFs15i_BFu15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFs15i_BFu15s  {
  signed short v1:15;
  __tsu64 v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15i_BFu15s) C1{ Fs:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15s_BFu15ll_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15ll_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15i_BFu15s, BFs15s_BFu15ll_BFs15i_BFu15s)
//============================================================================


struct  BFs15s_BFu15ll_BFs15ll  {
  signed short v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15ll) C1{ Fs:15 FL:15 FL:15}



static void Test_BFs15s_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15ll, BFs15s_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFs15ll_BFs15i  {
  signed short v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15ll_BFs15i) C1{ Fs:15 FL:15 FL:15 Fi:15}



static void Test_BFs15s_BFu15ll_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15ll_BFs15i, BFs15s_BFu15ll_BFs15ll_BFs15i)
//============================================================================


struct  BFs15s_BFu15ll_BFs15ll_BFs15ll  {
  signed short v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15ll_BFs15ll) C1{ Fs:15 FL:15 FL:15 FL:15}



static void Test_BFs15s_BFu15ll_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15ll_BFs15ll, BFs15s_BFu15ll_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFs15ll_BFs15s  {
  signed short v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15ll_BFs15s) C1{ Fs:15 FL:15 FL:15 Fs:15}



static void Test_BFs15s_BFu15ll_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15ll_BFs15s, BFs15s_BFu15ll_BFs15ll_BFs15s)
//============================================================================


struct  BFs15s_BFu15ll_BFs15ll_BFu15i  {
  signed short v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15ll_BFu15i) C1{ Fs:15 FL:15 FL:15 Fi:15}



static void Test_BFs15s_BFu15ll_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15ll_BFu15i, BFs15s_BFu15ll_BFs15ll_BFu15i)
//============================================================================


struct  BFs15s_BFu15ll_BFs15ll_BFu15ll  {
  signed short v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15ll_BFu15ll) C1{ Fs:15 FL:15 FL:15 FL:15}



static void Test_BFs15s_BFu15ll_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15ll_BFu15ll, BFs15s_BFu15ll_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFs15ll_BFu15s  {
  signed short v1:15;
  __tsu64 v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15ll_BFu15s) C1{ Fs:15 FL:15 FL:15 Fs:15}



static void Test_BFs15s_BFu15ll_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15ll_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15ll_BFu15s, BFs15s_BFu15ll_BFs15ll_BFu15s)
//============================================================================


struct  BFs15s_BFu15ll_BFs15s  {
  signed short v1:15;
  __tsu64 v2:15;
  signed short v3:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15s) C1{ Fs:15 FL:15 Fs:15}



static void Test_BFs15s_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15s, BFs15s_BFu15ll_BFs15s)
//============================================================================


struct  BFs15s_BFu15ll_BFs15s_BFs15i  {
  signed short v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15s_BFs15i) C1{ Fs:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15s_BFu15ll_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15s_BFs15i, BFs15s_BFu15ll_BFs15s_BFs15i)
//============================================================================


struct  BFs15s_BFu15ll_BFs15s_BFs15ll  {
  signed short v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15s_BFs15ll) C1{ Fs:15 FL:15 Fs:15 FL:15}



static void Test_BFs15s_BFu15ll_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15s_BFs15ll, BFs15s_BFu15ll_BFs15s_BFs15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFs15s_BFs15s  {
  signed short v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15s_BFs15s) C1{ Fs:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15s_BFu15ll_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15ll_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15s_BFs15s, BFs15s_BFu15ll_BFs15s_BFs15s)
//============================================================================


struct  BFs15s_BFu15ll_BFs15s_BFu15i  {
  signed short v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15s_BFu15i) C1{ Fs:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15s_BFu15ll_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15s_BFu15i, BFs15s_BFu15ll_BFs15s_BFu15i)
//============================================================================


struct  BFs15s_BFu15ll_BFs15s_BFu15ll  {
  signed short v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15s_BFu15ll) C1{ Fs:15 FL:15 Fs:15 FL:15}



static void Test_BFs15s_BFu15ll_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15s_BFu15ll, BFs15s_BFu15ll_BFs15s_BFu15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFs15s_BFu15s  {
  signed short v1:15;
  __tsu64 v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFs15s_BFu15s) C1{ Fs:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15s_BFu15ll_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15ll_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFs15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15ll_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFs15s_BFu15s, BFs15s_BFu15ll_BFs15s_BFu15s)
//============================================================================


struct  BFs15s_BFu15ll_BFu15i  {
  signed short v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15i) C1{ Fs:15 FL:15 Fi:15}



static void Test_BFs15s_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15i, BFs15s_BFu15ll_BFu15i)
//============================================================================


struct  BFs15s_BFu15ll_BFu15i_BFs15i  {
  signed short v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15i_BFs15i) C1{ Fs:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15s_BFu15ll_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15i_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15i_BFs15i, BFs15s_BFu15ll_BFu15i_BFs15i)
//============================================================================


struct  BFs15s_BFu15ll_BFu15i_BFs15ll  {
  signed short v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15i_BFs15ll) C1{ Fs:15 FL:15 Fi:15 FL:15}



static void Test_BFs15s_BFu15ll_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15i_BFs15ll, BFs15s_BFu15ll_BFu15i_BFs15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFu15i_BFs15s  {
  signed short v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15i_BFs15s) C1{ Fs:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15s_BFu15ll_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15i_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15ll_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15i_BFs15s, BFs15s_BFu15ll_BFu15i_BFs15s)
//============================================================================


struct  BFs15s_BFu15ll_BFu15i_BFu15i  {
  signed short v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15i_BFu15i) C1{ Fs:15 FL:15 Fi:15 Fi:15}



static void Test_BFs15s_BFu15ll_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15i_BFu15i, BFs15s_BFu15ll_BFu15i_BFu15i)
//============================================================================


struct  BFs15s_BFu15ll_BFu15i_BFu15ll  {
  signed short v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15i_BFu15ll) C1{ Fs:15 FL:15 Fi:15 FL:15}



static void Test_BFs15s_BFu15ll_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15i_BFu15ll, BFs15s_BFu15ll_BFu15i_BFu15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFu15i_BFu15s  {
  signed short v1:15;
  __tsu64 v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15i_BFu15s) C1{ Fs:15 FL:15 Fi:15 Fs:15}



static void Test_BFs15s_BFu15ll_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15ll_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15i_BFu15s, BFs15s_BFu15ll_BFu15i_BFu15s)
//============================================================================


struct  BFs15s_BFu15ll_BFu15ll  {
  signed short v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15ll) C1{ Fs:15 FL:15 FL:15}



static void Test_BFs15s_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15ll, BFs15s_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFu15ll_BFs15i  {
  signed short v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15ll_BFs15i) C1{ Fs:15 FL:15 FL:15 Fi:15}



static void Test_BFs15s_BFu15ll_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15ll_BFs15i, BFs15s_BFu15ll_BFu15ll_BFs15i)
//============================================================================


struct  BFs15s_BFu15ll_BFu15ll_BFs15ll  {
  signed short v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15ll_BFs15ll) C1{ Fs:15 FL:15 FL:15 FL:15}



static void Test_BFs15s_BFu15ll_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15ll_BFs15ll, BFs15s_BFu15ll_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFu15ll_BFs15s  {
  signed short v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15ll_BFs15s) C1{ Fs:15 FL:15 FL:15 Fs:15}



static void Test_BFs15s_BFu15ll_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15ll_BFs15s, BFs15s_BFu15ll_BFu15ll_BFs15s)
//============================================================================


struct  BFs15s_BFu15ll_BFu15ll_BFu15i  {
  signed short v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15ll_BFu15i) C1{ Fs:15 FL:15 FL:15 Fi:15}



static void Test_BFs15s_BFu15ll_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15ll_BFu15i, BFs15s_BFu15ll_BFu15ll_BFu15i)
//============================================================================


struct  BFs15s_BFu15ll_BFu15ll_BFu15ll  {
  signed short v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15ll_BFu15ll) C1{ Fs:15 FL:15 FL:15 FL:15}



static void Test_BFs15s_BFu15ll_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 5, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15ll_BFu15ll, BFs15s_BFu15ll_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFu15ll_BFu15s  {
  signed short v1:15;
  __tsu64 v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15ll_BFu15s) C1{ Fs:15 FL:15 FL:15 Fs:15}



static void Test_BFs15s_BFu15ll_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15ll_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15ll_BFu15s, BFs15s_BFu15ll_BFu15ll_BFu15s)
//============================================================================


struct  BFs15s_BFu15ll_BFu15s  {
  signed short v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15s) C1{ Fs:15 FL:15 Fs:15}



static void Test_BFs15s_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15s, BFs15s_BFu15ll_BFu15s)
//============================================================================


struct  BFs15s_BFu15ll_BFu15s_BFs15i  {
  signed short v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15s_BFs15i) C1{ Fs:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15s_BFu15ll_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15s_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15s_BFs15i, BFs15s_BFu15ll_BFu15s_BFs15i)
//============================================================================


struct  BFs15s_BFu15ll_BFu15s_BFs15ll  {
  signed short v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15s_BFs15ll) C1{ Fs:15 FL:15 Fs:15 FL:15}



static void Test_BFs15s_BFu15ll_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15s_BFs15ll, BFs15s_BFu15ll_BFu15s_BFs15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFu15s_BFs15s  {
  signed short v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15s_BFs15s) C1{ Fs:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15s_BFu15ll_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15s_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15ll_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15s_BFs15s, BFs15s_BFu15ll_BFu15s_BFs15s)
//============================================================================


struct  BFs15s_BFu15ll_BFu15s_BFu15i  {
  signed short v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15s_BFu15i) C1{ Fs:15 FL:15 Fs:15 Fi:15}



static void Test_BFs15s_BFu15ll_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15s_BFu15i, BFs15s_BFu15ll_BFu15s_BFu15i)
//============================================================================


struct  BFs15s_BFu15ll_BFu15s_BFu15ll  {
  signed short v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15s_BFu15ll) C1{ Fs:15 FL:15 Fs:15 FL:15}



static void Test_BFs15s_BFu15ll_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15ll_BFu15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15s_BFu15ll, BFs15s_BFu15ll_BFu15s_BFu15ll)
//============================================================================


struct  BFs15s_BFu15ll_BFu15s_BFu15s  {
  signed short v1:15;
  __tsu64 v2:15;
  unsigned short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15ll_BFu15s_BFu15s) C1{ Fs:15 FL:15 Fs:15 Fs:15}



static void Test_BFs15s_BFu15ll_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15ll_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15ll_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15ll_BFu15s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15ll_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFs15s_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15ll_BFu15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15ll_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15ll_BFu15s_BFu15s, BFs15s_BFu15ll_BFu15s_BFu15s)
//============================================================================


struct  BFs15s_BFu15s  {
  signed short v1:15;
  unsigned short v2:15;
};
//SIG(1 BFs15s_BFu15s) C1{ Fs:15 Fs:15}



static void Test_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFs15s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s, BFs15s_BFu15s)
//============================================================================


struct  BFs15s_BFu15s_BFs15i  {
  signed short v1:15;
  unsigned short v2:15;
  signed int v3:15;
};
//SIG(1 BFs15s_BFu15s_BFs15i) C1{ Fs:15 Fs:15 Fi:15}



static void Test_BFs15s_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15i, BFs15s_BFu15s_BFs15i)
//============================================================================


struct  BFs15s_BFu15s_BFs15i_BFs15i  {
  signed short v1:15;
  unsigned short v2:15;
  signed int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15i_BFs15i) C1{ Fs:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15s_BFu15s_BFs15i_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15i_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15s_BFs15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFs15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15i_BFs15i, BFs15s_BFu15s_BFs15i_BFs15i)
//============================================================================


struct  BFs15s_BFu15s_BFs15i_BFs15ll  {
  signed short v1:15;
  unsigned short v2:15;
  signed int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15i_BFs15ll) C1{ Fs:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15s_BFu15s_BFs15i_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15i_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFs15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFs15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15i_BFs15ll, BFs15s_BFu15s_BFs15i_BFs15ll)
//============================================================================


struct  BFs15s_BFu15s_BFs15i_BFs15s  {
  signed short v1:15;
  unsigned short v2:15;
  signed int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15i_BFs15s) C1{ Fs:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15s_BFu15s_BFs15i_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15i_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15s_BFs15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15i_BFs15s, BFs15s_BFu15s_BFs15i_BFs15s)
//============================================================================


struct  BFs15s_BFu15s_BFs15i_BFu15i  {
  signed short v1:15;
  unsigned short v2:15;
  signed int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15i_BFu15i) C1{ Fs:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15s_BFu15s_BFs15i_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15i_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15s_BFs15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFs15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15i_BFu15i, BFs15s_BFu15s_BFs15i_BFu15i)
//============================================================================


struct  BFs15s_BFu15s_BFs15i_BFu15ll  {
  signed short v1:15;
  unsigned short v2:15;
  signed int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15i_BFu15ll) C1{ Fs:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15s_BFu15s_BFs15i_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15i_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFs15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFs15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15i_BFu15ll, BFs15s_BFu15s_BFs15i_BFu15ll)
//============================================================================


struct  BFs15s_BFu15s_BFs15i_BFu15s  {
  signed short v1:15;
  unsigned short v2:15;
  signed int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15i_BFu15s) C1{ Fs:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15s_BFu15s_BFs15i_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15i_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15s_BFs15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15s_BFs15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15i_BFu15s, BFs15s_BFu15s_BFs15i_BFu15s)
//============================================================================


struct  BFs15s_BFu15s_BFs15ll  {
  signed short v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
};
//SIG(1 BFs15s_BFu15s_BFs15ll) C1{ Fs:15 Fs:15 FL:15}



static void Test_BFs15s_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15ll, BFs15s_BFu15s_BFs15ll)
//============================================================================


struct  BFs15s_BFu15s_BFs15ll_BFs15i  {
  signed short v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15ll_BFs15i) C1{ Fs:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15s_BFu15s_BFs15ll_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15ll_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFs15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFu15s_BFs15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15ll_BFs15i, BFs15s_BFu15s_BFs15ll_BFs15i)
//============================================================================


struct  BFs15s_BFu15s_BFs15ll_BFs15ll  {
  signed short v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15ll_BFs15ll) C1{ Fs:15 Fs:15 FL:15 FL:15}



static void Test_BFs15s_BFu15s_BFs15ll_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15ll_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFs15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFu15s_BFs15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15ll_BFs15ll, BFs15s_BFu15s_BFs15ll_BFs15ll)
//============================================================================


struct  BFs15s_BFu15s_BFs15ll_BFs15s  {
  signed short v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15ll_BFs15s) C1{ Fs:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15s_BFu15s_BFs15ll_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15ll_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFs15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15s_BFs15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15ll_BFs15s, BFs15s_BFu15s_BFs15ll_BFs15s)
//============================================================================


struct  BFs15s_BFu15s_BFs15ll_BFu15i  {
  signed short v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15ll_BFu15i) C1{ Fs:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15s_BFu15s_BFs15ll_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15ll_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFs15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFu15s_BFs15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15ll_BFu15i, BFs15s_BFu15s_BFs15ll_BFu15i)
//============================================================================


struct  BFs15s_BFu15s_BFs15ll_BFu15ll  {
  signed short v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15ll_BFu15ll) C1{ Fs:15 Fs:15 FL:15 FL:15}



static void Test_BFs15s_BFu15s_BFs15ll_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15ll_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFs15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFu15s_BFs15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15ll_BFu15ll, BFs15s_BFu15s_BFs15ll_BFu15ll)
//============================================================================


struct  BFs15s_BFu15s_BFs15ll_BFu15s  {
  signed short v1:15;
  unsigned short v2:15;
  signed __tsi64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15ll_BFu15s) C1{ Fs:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15s_BFu15s_BFs15ll_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15ll_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFs15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15s_BFs15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15ll_BFu15s, BFs15s_BFu15s_BFs15ll_BFu15s)
//============================================================================


struct  BFs15s_BFu15s_BFs15s  {
  signed short v1:15;
  unsigned short v2:15;
  signed short v3:15;
};
//SIG(1 BFs15s_BFu15s_BFs15s) C1{ Fs:15 Fs:15 Fs:15}



static void Test_BFs15s_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15s lv;
    check2(sizeof(lv), 6, "sizeof(BFs15s_BFu15s_BFs15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs15s_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15s, BFs15s_BFu15s_BFs15s)
//============================================================================


struct  BFs15s_BFu15s_BFs15s_BFs15i  {
  signed short v1:15;
  unsigned short v2:15;
  signed short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15s_BFs15i) C1{ Fs:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15s_BFu15s_BFs15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15s_BFs15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFs15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15s_BFs15i, BFs15s_BFu15s_BFs15s_BFs15i)
//============================================================================


struct  BFs15s_BFu15s_BFs15s_BFs15ll  {
  signed short v1:15;
  unsigned short v2:15;
  signed short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15s_BFs15ll) C1{ Fs:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15s_BFu15s_BFs15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFs15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFs15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15s_BFs15ll, BFs15s_BFu15s_BFs15s_BFs15ll)
//============================================================================


struct  BFs15s_BFu15s_BFs15s_BFs15s  {
  signed short v1:15;
  unsigned short v2:15;
  signed short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15s_BFs15s) C1{ Fs:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15s_BFu15s_BFs15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15s_BFs15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs15s_BFu15s_BFs15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15s_BFs15s, BFs15s_BFu15s_BFs15s_BFs15s)
//============================================================================


struct  BFs15s_BFu15s_BFs15s_BFu15i  {
  signed short v1:15;
  unsigned short v2:15;
  signed short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15s_BFu15i) C1{ Fs:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15s_BFu15s_BFs15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15s_BFs15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFs15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15s_BFu15i, BFs15s_BFu15s_BFs15s_BFu15i)
//============================================================================


struct  BFs15s_BFu15s_BFs15s_BFu15ll  {
  signed short v1:15;
  unsigned short v2:15;
  signed short v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15s_BFu15ll) C1{ Fs:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15s_BFu15s_BFs15s_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15s_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFs15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFs15s_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15s_BFu15ll, BFs15s_BFu15s_BFs15s_BFu15ll)
//============================================================================


struct  BFs15s_BFu15s_BFs15s_BFu15s  {
  signed short v1:15;
  unsigned short v2:15;
  signed short v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15s_BFs15s_BFu15s) C1{ Fs:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15s_BFu15s_BFs15s_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15s_BFs15s_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15s_BFs15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFs15s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs15s_BFu15s_BFs15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15s_BFs15s_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFs15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFs15s_BFu15s, BFs15s_BFu15s_BFs15s_BFu15s)
//============================================================================


struct  BFs15s_BFu15s_BFu15i  {
  signed short v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
};
//SIG(1 BFs15s_BFu15s_BFu15i) C1{ Fs:15 Fs:15 Fi:15}



static void Test_BFs15s_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15i, BFs15s_BFu15s_BFu15i)
//============================================================================


struct  BFs15s_BFu15s_BFu15i_BFs15i  {
  signed short v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15i_BFs15i) C1{ Fs:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15s_BFu15s_BFu15i_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15i_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15i_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15i_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15s_BFu15i_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFu15i_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15i_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15i_BFs15i, BFs15s_BFu15s_BFu15i_BFs15i)
//============================================================================


struct  BFs15s_BFu15s_BFu15i_BFs15ll  {
  signed short v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15i_BFs15ll) C1{ Fs:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15s_BFu15s_BFu15i_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15i_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15i_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15i_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFu15i_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFu15i_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15i_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15i_BFs15ll, BFs15s_BFu15s_BFu15i_BFs15ll)
//============================================================================


struct  BFs15s_BFu15s_BFu15i_BFs15s  {
  signed short v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15i_BFs15s) C1{ Fs:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15s_BFu15s_BFu15i_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15i_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15i_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15i_BFs15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15s_BFu15i_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15i_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15i_BFs15s, BFs15s_BFu15s_BFu15i_BFs15s)
//============================================================================


struct  BFs15s_BFu15s_BFu15i_BFu15i  {
  signed short v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15i_BFu15i) C1{ Fs:15 Fs:15 Fi:15 Fi:15}



static void Test_BFs15s_BFu15s_BFu15i_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15i_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15s_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFu15i_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15i_BFu15i, BFs15s_BFu15s_BFu15i_BFu15i)
//============================================================================


struct  BFs15s_BFu15s_BFu15i_BFu15ll  {
  signed short v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15i_BFu15ll) C1{ Fs:15 Fs:15 Fi:15 FL:15}



static void Test_BFs15s_BFu15s_BFu15i_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15i_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15i_BFu15ll, BFs15s_BFu15s_BFu15i_BFu15ll)
//============================================================================


struct  BFs15s_BFu15s_BFu15i_BFu15s  {
  signed short v1:15;
  unsigned short v2:15;
  unsigned int v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15i_BFu15s) C1{ Fs:15 Fs:15 Fi:15 Fs:15}



static void Test_BFs15s_BFu15s_BFu15i_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15i_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15s_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15s_BFu15i_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15i_BFu15s, BFs15s_BFu15s_BFu15i_BFu15s)
//============================================================================


struct  BFs15s_BFu15s_BFu15ll  {
  signed short v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
};
//SIG(1 BFs15s_BFu15s_BFu15ll) C1{ Fs:15 Fs:15 FL:15}



static void Test_BFs15s_BFu15s_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15ll, BFs15s_BFu15s_BFu15ll)
//============================================================================


struct  BFs15s_BFu15s_BFu15ll_BFs15i  {
  signed short v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15ll_BFs15i) C1{ Fs:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15s_BFu15s_BFu15ll_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15ll_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15ll_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15ll_BFs15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFu15ll_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFu15s_BFu15ll_BFs15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15ll_BFs15i, BFs15s_BFu15s_BFu15ll_BFs15i)
//============================================================================


struct  BFs15s_BFu15s_BFu15ll_BFs15ll  {
  signed short v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15ll_BFs15ll) C1{ Fs:15 Fs:15 FL:15 FL:15}



static void Test_BFs15s_BFu15s_BFu15ll_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15ll_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15ll_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15ll_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFu15ll_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFu15s_BFu15ll_BFs15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15ll_BFs15ll, BFs15s_BFu15s_BFu15ll_BFs15ll)
//============================================================================


struct  BFs15s_BFu15s_BFu15ll_BFs15s  {
  signed short v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15ll_BFs15s) C1{ Fs:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15s_BFu15s_BFu15ll_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15ll_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15ll_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15ll_BFs15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFu15ll_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15s_BFu15ll_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15ll_BFs15s, BFs15s_BFu15s_BFu15ll_BFs15s)
//============================================================================


struct  BFs15s_BFu15s_BFu15ll_BFu15i  {
  signed short v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15ll_BFu15i) C1{ Fs:15 Fs:15 FL:15 Fi:15}



static void Test_BFs15s_BFu15s_BFu15ll_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15ll_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFu15ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFu15s_BFu15ll_BFu15i");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15ll_BFu15i, BFs15s_BFu15s_BFu15ll_BFu15i)
//============================================================================


struct  BFs15s_BFu15s_BFu15ll_BFu15ll  {
  signed short v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  __tsu64 v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15ll_BFu15ll) C1{ Fs:15 Fs:15 FL:15 FL:15}



static void Test_BFs15s_BFu15s_BFu15ll_BFu15ll()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15ll_BFu15ll");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFu15ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, 1, "BFs15s_BFu15s_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v4, 5, 6, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15ll_BFu15ll, BFs15s_BFu15s_BFu15ll_BFu15ll)
//============================================================================


struct  BFs15s_BFu15s_BFu15ll_BFu15s  {
  signed short v1:15;
  unsigned short v2:15;
  __tsu64 v3:15;
  unsigned short v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15ll_BFu15s) C1{ Fs:15 Fs:15 FL:15 Fs:15}



static void Test_BFs15s_BFu15s_BFu15ll_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15ll_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFu15ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "BFs15s_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15s_BFu15ll_BFu15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15ll_BFu15s, BFs15s_BFu15s_BFu15ll_BFu15s)
//============================================================================


struct  BFs15s_BFu15s_BFu15s  {
  signed short v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
};
//SIG(1 BFs15s_BFu15s_BFu15s) C1{ Fs:15 Fs:15 Fs:15}



static void Test_BFs15s_BFu15s_BFu15s()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15s");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFs15s_BFu15s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs15s_BFu15s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15s, BFs15s_BFu15s_BFu15s)
//============================================================================


struct  BFs15s_BFu15s_BFu15s_BFs15i  {
  signed short v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  signed int v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15s_BFs15i) C1{ Fs:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15s_BFu15s_BFu15s_BFs15i()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15s_BFs15i");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15s_BFs15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15s_BFs15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15s_BFu15s_BFs15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFu15s_BFs15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15s_BFs15i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15s_BFs15i, BFs15s_BFu15s_BFu15s_BFs15i)
//============================================================================


struct  BFs15s_BFu15s_BFu15s_BFs15ll  {
  signed short v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  signed __tsi64 v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15s_BFs15ll) C1{ Fs:15 Fs:15 Fs:15 FL:15}



static void Test_BFs15s_BFu15s_BFu15s_BFs15ll()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15s_BFs15ll");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15s_BFs15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15s_BFs15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFs15s_BFu15s_BFu15s_BFs15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFu15s_BFs15ll");
    set_bf_and_test(lv, v4, 5, 7, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15s_BFs15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15s_BFs15ll, BFs15s_BFu15s_BFu15s_BFs15ll)
//============================================================================


struct  BFs15s_BFu15s_BFu15s_BFs15s  {
  signed short v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  signed short v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15s_BFs15s) C1{ Fs:15 Fs:15 Fs:15 Fs:15}



static void Test_BFs15s_BFu15s_BFu15s_BFs15s()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15s_BFs15s");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15s_BFs15s lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15s_BFs15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFs15s_BFu15s_BFu15s_BFs15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, 1, "BFs15s_BFu15s_BFu15s_BFs15s");
    set_bf_and_test(lv, v4, 6, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15s_BFs15s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs15s_BFu15s_BFu15s_BFs15s, BFs15s_BFu15s_BFu15s_BFs15s)
//============================================================================


struct  BFs15s_BFu15s_BFu15s_BFu15i  {
  signed short v1:15;
  unsigned short v2:15;
  unsigned short v3:15;
  unsigned int v4:15;
};
//SIG(1 BFs15s_BFu15s_BFu15s_BFu15i) C1{ Fs:15 Fs:15 Fs:15 Fi:15}



static void Test_BFs15s_BFu15s_BFu15s_BFu15i()
{
  {
    init_simple_test("BFs15s_BFu15s_BFu15s_BFu15i");
    static STRUCT_IF_C BFs15s_BFu15s_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFs15s_BFu15s_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFs15s_BFu15s_BFu15s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFs15s_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_sll(1LL<<14), "BFs15s_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFs15s_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFs15s_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFs15s_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, 1, "BFs15s_BFu15s_BFu15s_BFu15i");
    set_bf_and_test(lv, v4, 5, 7, 15, hi