// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  BFu32ll_BFu16s_B  {
  __tsu64 v1:32;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 BFu32ll_BFu16s_B) C1{ FL:32 Fs:16 Fc}



static void Test_BFu32ll_BFu16s_B()
{
  {
    init_simple_test("BFu32ll_BFu16s_B");
    static BFu32ll_BFu16s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu16s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu16s_B");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu32ll_BFu16s_B");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu32ll_BFu16s_B");
    check_field_offset(lv, v3, 6, "BFu32ll_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu16s_B(Test_BFu32ll_BFu16s_B, "BFu32ll_BFu16s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu17i_B  {
  __tsu64 v1:32;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 BFu32ll_BFu17i_B) C1{ FL:32 Fi:17 Fc}



static void Test_BFu32ll_BFu17i_B()
{
  {
    init_simple_test("BFu32ll_BFu17i_B");
    static BFu32ll_BFu17i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu17i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu17i_B");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu32ll_BFu17i_B");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu32ll_BFu17i_B");
    check_field_offset(lv, v3, 7, "BFu32ll_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu17i_B(Test_BFu32ll_BFu17i_B, "BFu32ll_BFu17i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu17ll_B  {
  __tsu64 v1:32;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 BFu32ll_BFu17ll_B) C1{ FL:32 FL:17 Fc}



static void Test_BFu32ll_BFu17ll_B()
{
  {
    init_simple_test("BFu32ll_BFu17ll_B");
    static BFu32ll_BFu17ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu32ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu32ll_BFu17ll_B");
    check_field_offset(lv, v3, 7, "BFu32ll_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu17ll_B(Test_BFu32ll_BFu17ll_B, "BFu32ll_BFu17ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu1c_B  {
  __tsu64 v1:32;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 BFu32ll_BFu1c_B) C1{ FL:32 Fc:1 Fc}



static void Test_BFu32ll_BFu1c_B()
{
  {
    init_simple_test("BFu32ll_BFu1c_B");
    static BFu32ll_BFu1c_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu1c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu1c_B");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu32ll_BFu1c_B");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu1c_B(Test_BFu32ll_BFu1c_B, "BFu32ll_BFu1c_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu1i_B  {
  __tsu64 v1:32;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 BFu32ll_BFu1i_B) C1{ FL:32 Fi:1 Fc}



static void Test_BFu32ll_BFu1i_B()
{
  {
    init_simple_test("BFu32ll_BFu1i_B");
    static BFu32ll_BFu1i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu1i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu1i_B");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu32ll_BFu1i_B");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu1i_B(Test_BFu32ll_BFu1i_B, "BFu32ll_BFu1i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu1ll_B  {
  __tsu64 v1:32;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 BFu32ll_BFu1ll_B) C1{ FL:32 FL:1 Fc}



static void Test_BFu32ll_BFu1ll_B()
{
  {
    init_simple_test("BFu32ll_BFu1ll_B");
    static BFu32ll_BFu1ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu1ll_B");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu32ll_BFu1ll_B");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu1ll_B(Test_BFu32ll_BFu1ll_B, "BFu32ll_BFu1ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu1s_B  {
  __tsu64 v1:32;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 BFu32ll_BFu1s_B) C1{ FL:32 Fs:1 Fc}



static void Test_BFu32ll_BFu1s_B()
{
  {
    init_simple_test("BFu32ll_BFu1s_B");
    static BFu32ll_BFu1s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu1s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu1s_B");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu32ll_BFu1s_B");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu1s_B(Test_BFu32ll_BFu1s_B, "BFu32ll_BFu1s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu31i_B  {
  __tsu64 v1:32;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 BFu32ll_BFu31i_B) C1{ FL:32 Fi:31 Fc}



static void Test_BFu32ll_BFu31i_B()
{
  {
    init_simple_test("BFu32ll_BFu31i_B");
    static BFu32ll_BFu31i_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu32ll_BFu31i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu32ll_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu32ll_BFu31i_B");
    check_field_offset(lv, v3, 8, "BFu32ll_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu31i_B(Test_BFu32ll_BFu31i_B, "BFu32ll_BFu31i_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu31ll_B  {
  __tsu64 v1:32;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 BFu32ll_BFu31ll_B) C1{ FL:32 FL:31 Fc}



static void Test_BFu32ll_BFu31ll_B()
{
  {
    init_simple_test("BFu32ll_BFu31ll_B");
    static BFu32ll_BFu31ll_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu32ll_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu32ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu32ll_BFu31ll_B");
    check_field_offset(lv, v3, 8, "BFu32ll_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu31ll_B(Test_BFu32ll_BFu31ll_B, "BFu32ll_BFu31ll_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu32i_B  {
  __tsu64 v1:32;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 BFu32ll_BFu32i_B) C1{ FL:32 Fi:32 Fc}



static void Test_BFu32ll_BFu32i_B()
{
  {
    init_simple_test("BFu32ll_BFu32i_B");
    static BFu32ll_BFu32i_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu32ll_BFu32i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu32ll_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu32i_B");
    check_field_offset(lv, v3, 8, "BFu32ll_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu32i_B(Test_BFu32ll_BFu32i_B, "BFu32ll_BFu32i_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu32ll_B  {
  __tsu64 v1:32;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 BFu32ll_BFu32ll_B) C1{ FL:32 FL:32 Fc}



static void Test_BFu32ll_BFu32ll_B()
{
  {
    init_simple_test("BFu32ll_BFu32ll_B");
    static BFu32ll_BFu32ll_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu32ll_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu32ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu32ll_B");
    check_field_offset(lv, v3, 8, "BFu32ll_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu32ll_B(Test_BFu32ll_BFu32ll_B, "BFu32ll_BFu32ll_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu33_B  {
  __tsu64 v1:32;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 BFu32ll_BFu33_B) C1{ FL:32 FL:33 Fc}



static void Test_BFu32ll_BFu33_B()
{
  {
    init_simple_test("BFu32ll_BFu33_B");
    static BFu32ll_BFu33_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu32ll_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu33_B");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu32ll_BFu33_B");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu32ll_BFu33_B");
    check_field_offset(lv, v3, ABISELECT(13,9), "BFu32ll_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu33_B(Test_BFu32ll_BFu33_B, "BFu32ll_BFu33_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu7c_B  {
  __tsu64 v1:32;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 BFu32ll_BFu7c_B) C1{ FL:32 Fc:7 Fc}



static void Test_BFu32ll_BFu7c_B()
{
  {
    init_simple_test("BFu32ll_BFu7c_B");
    static BFu32ll_BFu7c_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu7c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu7c_B");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu32ll_BFu7c_B");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu32ll_BFu7c_B");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu7c_B(Test_BFu32ll_BFu7c_B, "BFu32ll_BFu7c_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu7i_B  {
  __tsu64 v1:32;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 BFu32ll_BFu7i_B) C1{ FL:32 Fi:7 Fc}



static void Test_BFu32ll_BFu7i_B()
{
  {
    init_simple_test("BFu32ll_BFu7i_B");
    static BFu32ll_BFu7i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu7i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu7i_B");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu32ll_BFu7i_B");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu32ll_BFu7i_B");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu7i_B(Test_BFu32ll_BFu7i_B, "BFu32ll_BFu7i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu7ll_B  {
  __tsu64 v1:32;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 BFu32ll_BFu7ll_B) C1{ FL:32 FL:7 Fc}



static void Test_BFu32ll_BFu7ll_B()
{
  {
    init_simple_test("BFu32ll_BFu7ll_B");
    static BFu32ll_BFu7ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu32ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu32ll_BFu7ll_B");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu7ll_B(Test_BFu32ll_BFu7ll_B, "BFu32ll_BFu7ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu7s_B  {
  __tsu64 v1:32;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 BFu32ll_BFu7s_B) C1{ FL:32 Fs:7 Fc}



static void Test_BFu32ll_BFu7s_B()
{
  {
    init_simple_test("BFu32ll_BFu7s_B");
    static BFu32ll_BFu7s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu7s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu7s_B");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu32ll_BFu7s_B");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu32ll_BFu7s_B");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu7s_B(Test_BFu32ll_BFu7s_B, "BFu32ll_BFu7s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu8c_B  {
  __tsu64 v1:32;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 BFu32ll_BFu8c_B) C1{ FL:32 Fc:8 Fc}



static void Test_BFu32ll_BFu8c_B()
{
  {
    init_simple_test("BFu32ll_BFu8c_B");
    static BFu32ll_BFu8c_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu8c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu8c_B");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu32ll_BFu8c_B");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu32ll_BFu8c_B");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu8c_B(Test_BFu32ll_BFu8c_B, "BFu32ll_BFu8c_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu8i_B  {
  __tsu64 v1:32;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 BFu32ll_BFu8i_B) C1{ FL:32 Fi:8 Fc}



static void Test_BFu32ll_BFu8i_B()
{
  {
    init_simple_test("BFu32ll_BFu8i_B");
    static BFu32ll_BFu8i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu8i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu8i_B");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu32ll_BFu8i_B");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu32ll_BFu8i_B");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu8i_B(Test_BFu32ll_BFu8i_B, "BFu32ll_BFu8i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu8ll_B  {
  __tsu64 v1:32;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 BFu32ll_BFu8ll_B) C1{ FL:32 FL:8 Fc}



static void Test_BFu32ll_BFu8ll_B()
{
  {
    init_simple_test("BFu32ll_BFu8ll_B");
    static BFu32ll_BFu8ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu32ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu32ll_BFu8ll_B");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu8ll_B(Test_BFu32ll_BFu8ll_B, "BFu32ll_BFu8ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu8s_B  {
  __tsu64 v1:32;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 BFu32ll_BFu8s_B) C1{ FL:32 Fs:8 Fc}



static void Test_BFu32ll_BFu8s_B()
{
  {
    init_simple_test("BFu32ll_BFu8s_B");
    static BFu32ll_BFu8s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu8s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu8s_B");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu32ll_BFu8s_B");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu32ll_BFu8s_B");
    check_field_offset(lv, v3, 5, "BFu32ll_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu8s_B(Test_BFu32ll_BFu8s_B, "BFu32ll_BFu8s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu9i_B  {
  __tsu64 v1:32;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 BFu32ll_BFu9i_B) C1{ FL:32 Fi:9 Fc}



static void Test_BFu32ll_BFu9i_B()
{
  {
    init_simple_test("BFu32ll_BFu9i_B");
    static BFu32ll_BFu9i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu9i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu9i_B");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu32ll_BFu9i_B");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu32ll_BFu9i_B");
    check_field_offset(lv, v3, 6, "BFu32ll_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu9i_B(Test_BFu32ll_BFu9i_B, "BFu32ll_BFu9i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu9ll_B  {
  __tsu64 v1:32;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 BFu32ll_BFu9ll_B) C1{ FL:32 FL:9 Fc}



static void Test_BFu32ll_BFu9ll_B()
{
  {
    init_simple_test("BFu32ll_BFu9ll_B");
    static BFu32ll_BFu9ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu32ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu32ll_BFu9ll_B");
    check_field_offset(lv, v3, 6, "BFu32ll_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu9ll_B(Test_BFu32ll_BFu9ll_B, "BFu32ll_BFu9ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_BFu9s_B  {
  __tsu64 v1:32;
  unsigned short v2:9;
  bool v3;
};
//SIG(1 BFu32ll_BFu9s_B) C1{ FL:32 Fs:9 Fc}



static void Test_BFu32ll_BFu9s_B()
{
  {
    init_simple_test("BFu32ll_BFu9s_B");
    static BFu32ll_BFu9s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_BFu9s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_BFu9s_B");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu32ll_BFu9s_B");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu32ll_BFu9s_B");
    check_field_offset(lv, v3, 6, "BFu32ll_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_BFu9s_B(Test_BFu32ll_BFu9s_B, "BFu32ll_BFu9s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_C_B  {
  __tsu64 v1:32;
  char v2;
  bool v3;
};
//SIG(1 BFu32ll_C_B) C1{ FL:32 Fc[2]}



static void Test_BFu32ll_C_B()
{
  {
    init_simple_test("BFu32ll_C_B");
    static BFu32ll_C_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_C_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_C_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_C_B");
    check_field_offset(lv, v2, 4, "BFu32ll_C_B.v2");
    check_field_offset(lv, v3, 5, "BFu32ll_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_C_B(Test_BFu32ll_C_B, "BFu32ll_C_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_D_B  {
  __tsu64 v1:32;
  double v2;
  bool v3;
};
//SIG(1 BFu32ll_D_B) C1{ FL:32 FL Fc}



static void Test_BFu32ll_D_B()
{
  {
    init_simple_test("BFu32ll_D_B");
    static BFu32ll_D_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu32ll_D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_D_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_D_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu32ll_D_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu32ll_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_D_B(Test_BFu32ll_D_B, "BFu32ll_D_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_F_B  {
  __tsu64 v1:32;
  float v2;
  bool v3;
};
//SIG(1 BFu32ll_F_B) C1{ FL:32 Fi Fc}



static void Test_BFu32ll_F_B()
{
  {
    init_simple_test("BFu32ll_F_B");
    static BFu32ll_F_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu32ll_F_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_F_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_F_B");
    check_field_offset(lv, v2, 4, "BFu32ll_F_B.v2");
    check_field_offset(lv, v3, 8, "BFu32ll_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_F_B(Test_BFu32ll_F_B, "BFu32ll_F_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_I_B  {
  __tsu64 v1:32;
  int v2;
  bool v3;
};
//SIG(1 BFu32ll_I_B) C1{ FL:32 Fi Fc}



static void Test_BFu32ll_I_B()
{
  {
    init_simple_test("BFu32ll_I_B");
    static BFu32ll_I_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu32ll_I_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_I_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_I_B");
    check_field_offset(lv, v2, 4, "BFu32ll_I_B.v2");
    check_field_offset(lv, v3, 8, "BFu32ll_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_I_B(Test_BFu32ll_I_B, "BFu32ll_I_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_Ip_B  {
  __tsu64 v1:32;
  int *v2;
  bool v3;
};
//SIG(1 BFu32ll_Ip_B) C1{ FL:32 Fp Fc}



static void Test_BFu32ll_Ip_B()
{
  {
    init_simple_test("BFu32ll_Ip_B");
    static BFu32ll_Ip_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu32ll_Ip_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Ip_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu32ll_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu32ll_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_Ip_B(Test_BFu32ll_Ip_B, "BFu32ll_Ip_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_L_B  {
  __tsu64 v1:32;
  __tsi64 v2;
  bool v3;
};
//SIG(1 BFu32ll_L_B) C1{ FL:32 FL Fc}



static void Test_BFu32ll_L_B()
{
  {
    init_simple_test("BFu32ll_L_B");
    static BFu32ll_L_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu32ll_L_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_L_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_L_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu32ll_L_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu32ll_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_L_B(Test_BFu32ll_L_B, "BFu32ll_L_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_S_B  {
  __tsu64 v1:32;
  short v2;
  bool v3;
};
//SIG(1 BFu32ll_S_B) C1{ FL:32 Fs Fc}



static void Test_BFu32ll_S_B()
{
  {
    init_simple_test("BFu32ll_S_B");
    static BFu32ll_S_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_S_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_S_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_S_B");
    check_field_offset(lv, v2, 4, "BFu32ll_S_B.v2");
    check_field_offset(lv, v3, 6, "BFu32ll_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_S_B(Test_BFu32ll_S_B, "BFu32ll_S_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_Uc_B  {
  __tsu64 v1:32;
  unsigned char v2;
  bool v3;
};
//SIG(1 BFu32ll_Uc_B) C1{ FL:32 Fc[2]}



static void Test_BFu32ll_Uc_B()
{
  {
    init_simple_test("BFu32ll_Uc_B");
    static BFu32ll_Uc_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_Uc_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Uc_B");
    check_field_offset(lv, v2, 4, "BFu32ll_Uc_B.v2");
    check_field_offset(lv, v3, 5, "BFu32ll_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_Uc_B(Test_BFu32ll_Uc_B, "BFu32ll_Uc_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_Ui_B  {
  __tsu64 v1:32;
  unsigned int v2;
  bool v3;
};
//SIG(1 BFu32ll_Ui_B) C1{ FL:32 Fi Fc}



static void Test_BFu32ll_Ui_B()
{
  {
    init_simple_test("BFu32ll_Ui_B");
    static BFu32ll_Ui_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu32ll_Ui_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Ui_B");
    check_field_offset(lv, v2, 4, "BFu32ll_Ui_B.v2");
    check_field_offset(lv, v3, 8, "BFu32ll_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_Ui_B(Test_BFu32ll_Ui_B, "BFu32ll_Ui_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_Ul_B  {
  __tsu64 v1:32;
  __tsu64 v2;
  bool v3;
};
//SIG(1 BFu32ll_Ul_B) C1{ FL:32 FL Fc}



static void Test_BFu32ll_Ul_B()
{
  {
    init_simple_test("BFu32ll_Ul_B");
    static BFu32ll_Ul_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu32ll_Ul_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Ul_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu32ll_Ul_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu32ll_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_Ul_B(Test_BFu32ll_Ul_B, "BFu32ll_Ul_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_Us_B  {
  __tsu64 v1:32;
  unsigned short v2;
  bool v3;
};
//SIG(1 BFu32ll_Us_B) C1{ FL:32 Fs Fc}



static void Test_BFu32ll_Us_B()
{
  {
    init_simple_test("BFu32ll_Us_B");
    static BFu32ll_Us_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu32ll_Us_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Us_B");
    check_field_offset(lv, v2, 4, "BFu32ll_Us_B.v2");
    check_field_offset(lv, v3, 6, "BFu32ll_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_Us_B(Test_BFu32ll_Us_B, "BFu32ll_Us_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu32ll_Vp_B  {
  __tsu64 v1:32;
  void *v2;
  bool v3;
};
//SIG(1 BFu32ll_Vp_B) C1{ FL:32 Fp Fc}



static void Test_BFu32ll_Vp_B()
{
  {
    init_simple_test("BFu32ll_Vp_B");
    static BFu32ll_Vp_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu32ll_Vp_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu32ll_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu32ll_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu32ll_Vp_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu32ll_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu32ll_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu32ll_Vp_B(Test_BFu32ll_Vp_B, "BFu32ll_Vp_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B  {
  __tsu64 v1:33;
  bool v2;
};
//SIG(1 BFu33_B) C1{ FL:33 Fc}



static void Test_BFu33_B()
{
  {
    init_simple_test("BFu33_B");
    static BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B");
    check_field_offset(lv, v2, 5, "BFu33_B.v2");
  }
}
static Arrange_To_Call_Me vBFu33_B(Test_BFu33_B, "BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_B  {
  __tsu64 v1:33;
  bool v2;
  bool v3;
};
//SIG(1 BFu33_B_B) C1{ FL:33 Fc[2]}



static void Test_BFu33_B_B()
{
  {
    init_simple_test("BFu33_B_B");
    static BFu33_B_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_B");
    check_field_offset(lv, v2, 5, "BFu33_B_B.v2");
    check_field_offset(lv, v3, 6, "BFu33_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_B_B(Test_BFu33_B_B, "BFu33_B_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu15i  {
  __tsu64 v1:33;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 BFu33_B_BFu15i) C1{ FL:33 Fc Fi:15}



static void Test_BFu33_B_BFu15i()
{
  {
    init_simple_test("BFu33_B_BFu15i");
    static BFu33_B_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu15i");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu33_B_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu33_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu15i(Test_BFu33_B_BFu15i, "BFu33_B_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu15ll  {
  __tsu64 v1:33;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 BFu33_B_BFu15ll) C1{ FL:33 Fc FL:15}



static void Test_BFu33_B_BFu15ll()
{
  {
    init_simple_test("BFu33_B_BFu15ll");
    static BFu33_B_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu15ll");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu33_B_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu33_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu15ll(Test_BFu33_B_BFu15ll, "BFu33_B_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu15s  {
  __tsu64 v1:33;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 BFu33_B_BFu15s) C1{ FL:33 Fc Fs:15}



static void Test_BFu33_B_BFu15s()
{
  {
    init_simple_test("BFu33_B_BFu15s");
    static BFu33_B_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu15s");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu33_B_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu33_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu15s(Test_BFu33_B_BFu15s, "BFu33_B_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu16i  {
  __tsu64 v1:33;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 BFu33_B_BFu16i) C1{ FL:33 Fc Fi:16}



static void Test_BFu33_B_BFu16i()
{
  {
    init_simple_test("BFu33_B_BFu16i");
    static BFu33_B_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu16i");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu33_B_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu33_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu16i(Test_BFu33_B_BFu16i, "BFu33_B_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu16ll  {
  __tsu64 v1:33;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 BFu33_B_BFu16ll) C1{ FL:33 Fc FL:16}



static void Test_BFu33_B_BFu16ll()
{
  {
    init_simple_test("BFu33_B_BFu16ll");
    static BFu33_B_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu16ll");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu33_B_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu33_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu16ll(Test_BFu33_B_BFu16ll, "BFu33_B_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu16s  {
  __tsu64 v1:33;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 BFu33_B_BFu16s) C1{ FL:33 Fc Fs:16}



static void Test_BFu33_B_BFu16s()
{
  {
    init_simple_test("BFu33_B_BFu16s");
    static BFu33_B_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu16s");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu33_B_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu33_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu16s(Test_BFu33_B_BFu16s, "BFu33_B_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu17i  {
  __tsu64 v1:33;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 BFu33_B_BFu17i) C1{ FL:33 Fc Fi:17}



static void Test_BFu33_B_BFu17i()
{
  {
    init_simple_test("BFu33_B_BFu17i");
    static BFu33_B_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_B_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu17i");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "BFu33_B_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "BFu33_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu17i(Test_BFu33_B_BFu17i, "BFu33_B_BFu17i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu17ll  {
  __tsu64 v1:33;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 BFu33_B_BFu17ll) C1{ FL:33 Fc FL:17}



static void Test_BFu33_B_BFu17ll()
{
  {
    init_simple_test("BFu33_B_BFu17ll");
    static BFu33_B_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu17ll");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, 1, "BFu33_B_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 17, hide_ull(1LL<<16), "BFu33_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu17ll(Test_BFu33_B_BFu17ll, "BFu33_B_BFu17ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu1c  {
  __tsu64 v1:33;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 BFu33_B_BFu1c) C1{ FL:33 Fc Fc:1}



static void Test_BFu33_B_BFu1c()
{
  {
    init_simple_test("BFu33_B_BFu1c");
    static BFu33_B_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu1c");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu33_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu1c(Test_BFu33_B_BFu1c, "BFu33_B_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu1i  {
  __tsu64 v1:33;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 BFu33_B_BFu1i) C1{ FL:33 Fc Fi:1}



static void Test_BFu33_B_BFu1i()
{
  {
    init_simple_test("BFu33_B_BFu1i");
    static BFu33_B_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu1i");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu33_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu1i(Test_BFu33_B_BFu1i, "BFu33_B_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu1ll  {
  __tsu64 v1:33;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 BFu33_B_BFu1ll) C1{ FL:33 Fc FL:1}



static void Test_BFu33_B_BFu1ll()
{
  {
    init_simple_test("BFu33_B_BFu1ll");
    static BFu33_B_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu1ll");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu33_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu1ll(Test_BFu33_B_BFu1ll, "BFu33_B_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu1s  {
  __tsu64 v1:33;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 BFu33_B_BFu1s) C1{ FL:33 Fc Fs:1}



static void Test_BFu33_B_BFu1s()
{
  {
    init_simple_test("BFu33_B_BFu1s");
    static BFu33_B_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu1s");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "BFu33_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu1s(Test_BFu33_B_BFu1s, "BFu33_B_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu31i  {
  __tsu64 v1:33;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 BFu33_B_BFu31i) C1{ FL:33 Fc Fi:31}



static void Test_BFu33_B_BFu31i()
{
  {
    init_simple_test("BFu33_B_BFu31i");
    static BFu33_B_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_B_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu31i");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu33_B_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu33_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu31i(Test_BFu33_B_BFu31i, "BFu33_B_BFu31i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu31ll  {
  __tsu64 v1:33;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 BFu33_B_BFu31ll) C1{ FL:33 Fc FL:31}



static void Test_BFu33_B_BFu31ll()
{
  {
    init_simple_test("BFu33_B_BFu31ll");
    static BFu33_B_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu31ll");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, 1, "BFu33_B_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 31, hide_ull(1LL<<30), "BFu33_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu31ll(Test_BFu33_B_BFu31ll, "BFu33_B_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu32i  {
  __tsu64 v1:33;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 BFu33_B_BFu32i) C1{ FL:33 Fc Fi:32}



static void Test_BFu33_B_BFu32i()
{
  {
    init_simple_test("BFu33_B_BFu32i");
    static BFu33_B_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_B_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu32i");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu33_B_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu33_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu32i(Test_BFu33_B_BFu32i, "BFu33_B_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu32ll  {
  __tsu64 v1:33;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 BFu33_B_BFu32ll) C1{ FL:33 Fc FL:32}



static void Test_BFu33_B_BFu32ll()
{
  {
    init_simple_test("BFu33_B_BFu32ll");
    static BFu33_B_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu32ll");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, 1, "BFu33_B_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 32, hide_ull(1LL<<31), "BFu33_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu32ll(Test_BFu33_B_BFu32ll, "BFu33_B_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu33  {
  __tsu64 v1:33;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 BFu33_B_BFu33) C1{ FL:33 Fc FL:33}



static void Test_BFu33_B_BFu33()
{
  {
    init_simple_test("BFu33_B_BFu33");
    static BFu33_B_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu33");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, 1, "BFu33_B_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu33(Test_BFu33_B_BFu33, "BFu33_B_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu7c  {
  __tsu64 v1:33;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 BFu33_B_BFu7c) C1{ FL:33 Fc Fc:7}



static void Test_BFu33_B_BFu7c()
{
  {
    init_simple_test("BFu33_B_BFu7c");
    static BFu33_B_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu7c");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu33_B_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu33_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu7c(Test_BFu33_B_BFu7c, "BFu33_B_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu7i  {
  __tsu64 v1:33;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 BFu33_B_BFu7i) C1{ FL:33 Fc Fi:7}



static void Test_BFu33_B_BFu7i()
{
  {
    init_simple_test("BFu33_B_BFu7i");
    static BFu33_B_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu7i");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu33_B_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu33_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu7i(Test_BFu33_B_BFu7i, "BFu33_B_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu7ll  {
  __tsu64 v1:33;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 BFu33_B_BFu7ll) C1{ FL:33 Fc FL:7}



static void Test_BFu33_B_BFu7ll()
{
  {
    init_simple_test("BFu33_B_BFu7ll");
    static BFu33_B_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu7ll");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu33_B_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu33_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu7ll(Test_BFu33_B_BFu7ll, "BFu33_B_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu7s  {
  __tsu64 v1:33;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 BFu33_B_BFu7s) C1{ FL:33 Fc Fs:7}



static void Test_BFu33_B_BFu7s()
{
  {
    init_simple_test("BFu33_B_BFu7s");
    static BFu33_B_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu7s");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "BFu33_B_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "BFu33_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu7s(Test_BFu33_B_BFu7s, "BFu33_B_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu8c  {
  __tsu64 v1:33;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 BFu33_B_BFu8c) C1{ FL:33 Fc Fc:8}



static void Test_BFu33_B_BFu8c()
{
  {
    init_simple_test("BFu33_B_BFu8c");
    static BFu33_B_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu8c");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu33_B_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu33_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu8c(Test_BFu33_B_BFu8c, "BFu33_B_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu8i  {
  __tsu64 v1:33;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 BFu33_B_BFu8i) C1{ FL:33 Fc Fi:8}



static void Test_BFu33_B_BFu8i()
{
  {
    init_simple_test("BFu33_B_BFu8i");
    static BFu33_B_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu8i");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu33_B_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu33_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu8i(Test_BFu33_B_BFu8i, "BFu33_B_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu8ll  {
  __tsu64 v1:33;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 BFu33_B_BFu8ll) C1{ FL:33 Fc FL:8}



static void Test_BFu33_B_BFu8ll()
{
  {
    init_simple_test("BFu33_B_BFu8ll");
    static BFu33_B_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu8ll");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu33_B_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu33_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu8ll(Test_BFu33_B_BFu8ll, "BFu33_B_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu8s  {
  __tsu64 v1:33;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 BFu33_B_BFu8s) C1{ FL:33 Fc Fs:8}



static void Test_BFu33_B_BFu8s()
{
  {
    init_simple_test("BFu33_B_BFu8s");
    static BFu33_B_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu8s");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "BFu33_B_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "BFu33_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu8s(Test_BFu33_B_BFu8s, "BFu33_B_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu9i  {
  __tsu64 v1:33;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 BFu33_B_BFu9i) C1{ FL:33 Fc Fi:9}



static void Test_BFu33_B_BFu9i()
{
  {
    init_simple_test("BFu33_B_BFu9i");
    static BFu33_B_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu9i");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu33_B_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu33_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu9i(Test_BFu33_B_BFu9i, "BFu33_B_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu9ll  {
  __tsu64 v1:33;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 BFu33_B_BFu9ll) C1{ FL:33 Fc FL:9}



static void Test_BFu33_B_BFu9ll()
{
  {
    init_simple_test("BFu33_B_BFu9ll");
    static BFu33_B_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu9ll");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu33_B_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu33_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu9ll(Test_BFu33_B_BFu9ll, "BFu33_B_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_BFu9s  {
  __tsu64 v1:33;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 BFu33_B_BFu9s) C1{ FL:33 Fc Fs:9}



static void Test_BFu33_B_BFu9s()
{
  {
    init_simple_test("BFu33_B_BFu9s");
    static BFu33_B_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_BFu9s");
    check_field_offset(lv, v2, 5, "BFu33_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu33_B_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu33_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu33_B_BFu9s(Test_BFu33_B_BFu9s, "BFu33_B_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_C  {
  __tsu64 v1:33;
  bool v2;
  char v3;
};
//SIG(1 BFu33_B_C) C1{ FL:33 Fc[2]}



static void Test_BFu33_B_C()
{
  {
    init_simple_test("BFu33_B_C");
    static BFu33_B_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_C");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_C");
    check_field_offset(lv, v2, 5, "BFu33_B_C.v2");
    check_field_offset(lv, v3, 6, "BFu33_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu33_B_C(Test_BFu33_B_C, "BFu33_B_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_D  {
  __tsu64 v1:33;
  bool v2;
  double v3;
};
//SIG(1 BFu33_B_D) C1{ FL:33 Fc FL}



static void Test_BFu33_B_D()
{
  {
    init_simple_test("BFu33_B_D");
    static BFu33_B_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_D");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_D");
    check_field_offset(lv, v2, 5, "BFu33_B_D.v2");
    check_field_offset(lv, v3, 8, "BFu33_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu33_B_D(Test_BFu33_B_D, "BFu33_B_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_F  {
  __tsu64 v1:33;
  bool v2;
  float v3;
};
//SIG(1 BFu33_B_F) C1{ FL:33 Fc Fi}



static void Test_BFu33_B_F()
{
  {
    init_simple_test("BFu33_B_F");
    static BFu33_B_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_B_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_F");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_F");
    check_field_offset(lv, v2, 5, "BFu33_B_F.v2");
    check_field_offset(lv, v3, 8, "BFu33_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu33_B_F(Test_BFu33_B_F, "BFu33_B_F", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_I  {
  __tsu64 v1:33;
  bool v2;
  int v3;
};
//SIG(1 BFu33_B_I) C1{ FL:33 Fc Fi}



static void Test_BFu33_B_I()
{
  {
    init_simple_test("BFu33_B_I");
    static BFu33_B_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_B_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_I");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_I");
    check_field_offset(lv, v2, 5, "BFu33_B_I.v2");
    check_field_offset(lv, v3, 8, "BFu33_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu33_B_I(Test_BFu33_B_I, "BFu33_B_I", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_Ip  {
  __tsu64 v1:33;
  bool v2;
  int *v3;
};
//SIG(1 BFu33_B_Ip) C1{ FL:33 Fc Fp}



static void Test_BFu33_B_Ip()
{
  {
    init_simple_test("BFu33_B_Ip");
    static BFu33_B_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_Ip");
    check_field_offset(lv, v2, 5, "BFu33_B_Ip.v2");
    check_field_offset(lv, v3, 8, "BFu33_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu33_B_Ip(Test_BFu33_B_Ip, "BFu33_B_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_L  {
  __tsu64 v1:33;
  bool v2;
  __tsi64 v3;
};
//SIG(1 BFu33_B_L) C1{ FL:33 Fc FL}



static void Test_BFu33_B_L()
{
  {
    init_simple_test("BFu33_B_L");
    static BFu33_B_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_L");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_L");
    check_field_offset(lv, v2, 5, "BFu33_B_L.v2");
    check_field_offset(lv, v3, 8, "BFu33_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu33_B_L(Test_BFu33_B_L, "BFu33_B_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_S  {
  __tsu64 v1:33;
  bool v2;
  short v3;
};
//SIG(1 BFu33_B_S) C1{ FL:33 Fc Fs}



static void Test_BFu33_B_S()
{
  {
    init_simple_test("BFu33_B_S");
    static BFu33_B_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_S");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_S");
    check_field_offset(lv, v2, 5, "BFu33_B_S.v2");
    check_field_offset(lv, v3, 6, "BFu33_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu33_B_S(Test_BFu33_B_S, "BFu33_B_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_Uc  {
  __tsu64 v1:33;
  bool v2;
  unsigned char v3;
};
//SIG(1 BFu33_B_Uc) C1{ FL:33 Fc[2]}



static void Test_BFu33_B_Uc()
{
  {
    init_simple_test("BFu33_B_Uc");
    static BFu33_B_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_Uc");
    check_field_offset(lv, v2, 5, "BFu33_B_Uc.v2");
    check_field_offset(lv, v3, 6, "BFu33_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu33_B_Uc(Test_BFu33_B_Uc, "BFu33_B_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_Ui  {
  __tsu64 v1:33;
  bool v2;
  unsigned int v3;
};
//SIG(1 BFu33_B_Ui) C1{ FL:33 Fc Fi}



static void Test_BFu33_B_Ui()
{
  {
    init_simple_test("BFu33_B_Ui");
    static BFu33_B_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_B_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_Ui");
    check_field_offset(lv, v2, 5, "BFu33_B_Ui.v2");
    check_field_offset(lv, v3, 8, "BFu33_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu33_B_Ui(Test_BFu33_B_Ui, "BFu33_B_Ui", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_Ul  {
  __tsu64 v1:33;
  bool v2;
  __tsu64 v3;
};
//SIG(1 BFu33_B_Ul) C1{ FL:33 Fc FL}



static void Test_BFu33_B_Ul()
{
  {
    init_simple_test("BFu33_B_Ul");
    static BFu33_B_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_Ul");
    check_field_offset(lv, v2, 5, "BFu33_B_Ul.v2");
    check_field_offset(lv, v3, 8, "BFu33_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu33_B_Ul(Test_BFu33_B_Ul, "BFu33_B_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_Us  {
  __tsu64 v1:33;
  bool v2;
  unsigned short v3;
};
//SIG(1 BFu33_B_Us) C1{ FL:33 Fc Fs}



static void Test_BFu33_B_Us()
{
  {
    init_simple_test("BFu33_B_Us");
    static BFu33_B_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_B_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_Us");
    check_field_offset(lv, v2, 5, "BFu33_B_Us.v2");
    check_field_offset(lv, v3, 6, "BFu33_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu33_B_Us(Test_BFu33_B_Us, "BFu33_B_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_B_Vp  {
  __tsu64 v1:33;
  bool v2;
  void *v3;
};
//SIG(1 BFu33_B_Vp) C1{ FL:33 Fc Fp}



static void Test_BFu33_B_Vp()
{
  {
    init_simple_test("BFu33_B_Vp");
    static BFu33_B_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_B_Vp");
    check_field_offset(lv, v2, 5, "BFu33_B_Vp.v2");
    check_field_offset(lv, v3, 8, "BFu33_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu33_B_Vp(Test_BFu33_B_Vp, "BFu33_B_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu15i_B  {
  __tsu64 v1:33;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 BFu33_BFu15i_B) C1{ FL:33 Fi:15 Fc}



static void Test_BFu33_BFu15i_B()
{
  {
    init_simple_test("BFu33_BFu15i_B");
    static BFu33_BFu15i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15i_B");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15i_B");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15i_B");
    check_field_offset(lv, v3, 6, "BFu33_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu15i_B(Test_BFu33_BFu15i_B, "BFu33_BFu15i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu15ll_B  {
  __tsu64 v1:33;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 BFu33_BFu15ll_B) C1{ FL:33 FL:15 Fc}



static void Test_BFu33_BFu15ll_B()
{
  {
    init_simple_test("BFu33_BFu15ll_B");
    static BFu33_BFu15ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15ll_B");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15ll_B");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15ll_B");
    check_field_offset(lv, v3, 6, "BFu33_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu15ll_B(Test_BFu33_BFu15ll_B, "BFu33_BFu15ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu15s_B  {
  __tsu64 v1:33;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 BFu33_BFu15s_B) C1{ FL:33 Fs:15 Fc}



static void Test_BFu33_BFu15s_B()
{
  {
    init_simple_test("BFu33_BFu15s_B");
    static BFu33_BFu15s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu15s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu15s_B");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu33_BFu15s_B");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu33_BFu15s_B");
    check_field_offset(lv, v3, 6, "BFu33_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu15s_B(Test_BFu33_BFu15s_B, "BFu33_BFu15s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu16i_B  {
  __tsu64 v1:33;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 BFu33_BFu16i_B) C1{ FL:33 Fi:16 Fc}



static void Test_BFu33_BFu16i_B()
{
  {
    init_simple_test("BFu33_BFu16i_B");
    static BFu33_BFu16i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu16i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16i_B");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu33_BFu16i_B");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu33_BFu16i_B");
    check_field_offset(lv, v3, 7, "BFu33_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu16i_B(Test_BFu33_BFu16i_B, "BFu33_BFu16i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu16ll_B  {
  __tsu64 v1:33;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 BFu33_BFu16ll_B) C1{ FL:33 FL:16 Fc}



static void Test_BFu33_BFu16ll_B()
{
  {
    init_simple_test("BFu33_BFu16ll_B");
    static BFu33_BFu16ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16ll_B");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu33_BFu16ll_B");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu33_BFu16ll_B");
    check_field_offset(lv, v3, 7, "BFu33_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu16ll_B(Test_BFu33_BFu16ll_B, "BFu33_BFu16ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu16s_B  {
  __tsu64 v1:33;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 BFu33_BFu16s_B) C1{ FL:33 Fs:16 Fc}



static void Test_BFu33_BFu16s_B()
{
  {
    init_simple_test("BFu33_BFu16s_B");
    static BFu33_BFu16s_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu16s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu16s_B");
    set_bf_and_test(lv, v2, 6, 0, 16, 1, "BFu33_BFu16s_B");
    set_bf_and_test(lv, v2, 6, 0, 16, hide_ull(1LL<<15), "BFu33_BFu16s_B");
    check_field_offset(lv, v3, 8, "BFu33_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu16s_B(Test_BFu33_BFu16s_B, "BFu33_BFu16s_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu17i_B  {
  __tsu64 v1:33;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 BFu33_BFu17i_B) C1{ FL:33 Fi:17 Fc}



static void Test_BFu33_BFu17i_B()
{
  {
    init_simple_test("BFu33_BFu17i_B");
    static BFu33_BFu17i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu17i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu17i_B");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu33_BFu17i_B");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu33_BFu17i_B");
    check_field_offset(lv, v3, 7, "BFu33_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu17i_B(Test_BFu33_BFu17i_B, "BFu33_BFu17i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu17ll_B  {
  __tsu64 v1:33;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 BFu33_BFu17ll_B) C1{ FL:33 FL:17 Fc}



static void Test_BFu33_BFu17ll_B()
{
  {
    init_simple_test("BFu33_BFu17ll_B");
    static BFu33_BFu17ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu17ll_B");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu33_BFu17ll_B");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu33_BFu17ll_B");
    check_field_offset(lv, v3, 7, "BFu33_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu17ll_B(Test_BFu33_BFu17ll_B, "BFu33_BFu17ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu1c_B  {
  __tsu64 v1:33;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 BFu33_BFu1c_B) C1{ FL:33 Fc:1 Fc}



static void Test_BFu33_BFu1c_B()
{
  {
    init_simple_test("BFu33_BFu1c_B");
    static BFu33_BFu1c_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1c_B");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1c_B");
    check_field_offset(lv, v3, 5, "BFu33_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu1c_B(Test_BFu33_BFu1c_B, "BFu33_BFu1c_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu1i_B  {
  __tsu64 v1:33;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 BFu33_BFu1i_B) C1{ FL:33 Fi:1 Fc}



static void Test_BFu33_BFu1i_B()
{
  {
    init_simple_test("BFu33_BFu1i_B");
    static BFu33_BFu1i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1i_B");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1i_B");
    check_field_offset(lv, v3, 5, "BFu33_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu1i_B(Test_BFu33_BFu1i_B, "BFu33_BFu1i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu1ll_B  {
  __tsu64 v1:33;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 BFu33_BFu1ll_B) C1{ FL:33 FL:1 Fc}



static void Test_BFu33_BFu1ll_B()
{
  {
    init_simple_test("BFu33_BFu1ll_B");
    static BFu33_BFu1ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1ll_B");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1ll_B");
    check_field_offset(lv, v3, 5, "BFu33_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu1ll_B(Test_BFu33_BFu1ll_B, "BFu33_BFu1ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu1s_B  {
  __tsu64 v1:33;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 BFu33_BFu1s_B) C1{ FL:33 Fs:1 Fc}



static void Test_BFu33_BFu1s_B()
{
  {
    init_simple_test("BFu33_BFu1s_B");
    static BFu33_BFu1s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu1s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu1s_B");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu33_BFu1s_B");
    check_field_offset(lv, v3, 5, "BFu33_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu1s_B(Test_BFu33_BFu1s_B, "BFu33_BFu1s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu31i_B  {
  __tsu64 v1:33;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 BFu33_BFu31i_B) C1{ FL:33 Fi:31 Fc}



static void Test_BFu33_BFu31i_B()
{
  {
    init_simple_test("BFu33_BFu31i_B");
    static BFu33_BFu31i_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu31i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu33_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu33_BFu31i_B");
    check_field_offset(lv, v3, 8, "BFu33_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu31i_B(Test_BFu33_BFu31i_B, "BFu33_BFu31i_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu31ll_B  {
  __tsu64 v1:33;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 BFu33_BFu31ll_B) C1{ FL:33 FL:31 Fc}



static void Test_BFu33_BFu31ll_B()
{
  {
    init_simple_test("BFu33_BFu31ll_B");
    static BFu33_BFu31ll_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu31ll_B");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu33_BFu31ll_B");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu33_BFu31ll_B");
    check_field_offset(lv, v3, 8, "BFu33_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu31ll_B(Test_BFu33_BFu31ll_B, "BFu33_BFu31ll_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu32i_B  {
  __tsu64 v1:33;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 BFu33_BFu32i_B) C1{ FL:33 Fi:32 Fc}



static void Test_BFu33_BFu32i_B()
{
  {
    init_simple_test("BFu33_BFu32i_B");
    static BFu33_BFu32i_B lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_BFu32i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu32i_B");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu33_BFu32i_B");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu33_BFu32i_B");
    check_field_offset(lv, v3, 12, "BFu33_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu32i_B(Test_BFu33_BFu32i_B, "BFu33_BFu32i_B", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu32ll_B  {
  __tsu64 v1:33;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 BFu33_BFu32ll_B) C1{ FL:33 FL:32 Fc}



static void Test_BFu33_BFu32ll_B()
{
  {
    init_simple_test("BFu33_BFu32ll_B");
    static BFu33_BFu32ll_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu32ll_B");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "BFu33_BFu32ll_B");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "BFu33_BFu32ll_B");
    check_field_offset(lv, v3, ABISELECT(12,9), "BFu33_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu32ll_B(Test_BFu33_BFu32ll_B, "BFu33_BFu32ll_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu33_B  {
  __tsu64 v1:33;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 BFu33_BFu33_B) C1{ FL:33 FL:33 Fc}



static void Test_BFu33_BFu33_B()
{
  {
    init_simple_test("BFu33_BFu33_B");
    static BFu33_BFu33_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu33_B");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "BFu33_BFu33_B");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "BFu33_BFu33_B");
    check_field_offset(lv, v3, ABISELECT(13,9), "BFu33_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu33_B(Test_BFu33_BFu33_B, "BFu33_BFu33_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu7c_B  {
  __tsu64 v1:33;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 BFu33_BFu7c_B) C1{ FL:33 Fc:7 Fc}



static void Test_BFu33_BFu7c_B()
{
  {
    init_simple_test("BFu33_BFu7c_B");
    static BFu33_BFu7c_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7c_B");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7c_B");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7c_B");
    check_field_offset(lv, v3, 5, "BFu33_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu7c_B(Test_BFu33_BFu7c_B, "BFu33_BFu7c_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu7i_B  {
  __tsu64 v1:33;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 BFu33_BFu7i_B) C1{ FL:33 Fi:7 Fc}



static void Test_BFu33_BFu7i_B()
{
  {
    init_simple_test("BFu33_BFu7i_B");
    static BFu33_BFu7i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7i_B");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7i_B");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7i_B");
    check_field_offset(lv, v3, 5, "BFu33_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu7i_B(Test_BFu33_BFu7i_B, "BFu33_BFu7i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu7ll_B  {
  __tsu64 v1:33;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 BFu33_BFu7ll_B) C1{ FL:33 FL:7 Fc}



static void Test_BFu33_BFu7ll_B()
{
  {
    init_simple_test("BFu33_BFu7ll_B");
    static BFu33_BFu7ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7ll_B");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7ll_B");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7ll_B");
    check_field_offset(lv, v3, 5, "BFu33_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu7ll_B(Test_BFu33_BFu7ll_B, "BFu33_BFu7ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu7s_B  {
  __tsu64 v1:33;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 BFu33_BFu7s_B) C1{ FL:33 Fs:7 Fc}



static void Test_BFu33_BFu7s_B()
{
  {
    init_simple_test("BFu33_BFu7s_B");
    static BFu33_BFu7s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu7s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu7s_B");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu33_BFu7s_B");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu33_BFu7s_B");
    check_field_offset(lv, v3, 5, "BFu33_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu7s_B(Test_BFu33_BFu7s_B, "BFu33_BFu7s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu8c_B  {
  __tsu64 v1:33;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 BFu33_BFu8c_B) C1{ FL:33 Fc:8 Fc}



static void Test_BFu33_BFu8c_B()
{
  {
    init_simple_test("BFu33_BFu8c_B");
    static BFu33_BFu8c_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8c_B");
    set_bf_and_test(lv, v2, 5, 0, 8, 1, "BFu33_BFu8c_B");
    set_bf_and_test(lv, v2, 5, 0, 8, hide_ull(1LL<<7), "BFu33_BFu8c_B");
    check_field_offset(lv, v3, 6, "BFu33_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu8c_B(Test_BFu33_BFu8c_B, "BFu33_BFu8c_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu8i_B  {
  __tsu64 v1:33;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 BFu33_BFu8i_B) C1{ FL:33 Fi:8 Fc}



static void Test_BFu33_BFu8i_B()
{
  {
    init_simple_test("BFu33_BFu8i_B");
    static BFu33_BFu8i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8i_B");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8i_B");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8i_B");
    check_field_offset(lv, v3, 6, "BFu33_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu8i_B(Test_BFu33_BFu8i_B, "BFu33_BFu8i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu8ll_B  {
  __tsu64 v1:33;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 BFu33_BFu8ll_B) C1{ FL:33 FL:8 Fc}



static void Test_BFu33_BFu8ll_B()
{
  {
    init_simple_test("BFu33_BFu8ll_B");
    static BFu33_BFu8ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8ll_B");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8ll_B");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8ll_B");
    check_field_offset(lv, v3, 6, "BFu33_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu8ll_B(Test_BFu33_BFu8ll_B, "BFu33_BFu8ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu8s_B  {
  __tsu64 v1:33;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 BFu33_BFu8s_B) C1{ FL:33 Fs:8 Fc}



static void Test_BFu33_BFu8s_B()
{
  {
    init_simple_test("BFu33_BFu8s_B");
    static BFu33_BFu8s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu8s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu8s_B");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu33_BFu8s_B");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu33_BFu8s_B");
    check_field_offset(lv, v3, 6, "BFu33_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu8s_B(Test_BFu33_BFu8s_B, "BFu33_BFu8s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu9i_B  {
  __tsu64 v1:33;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 BFu33_BFu9i_B) C1{ FL:33 Fi:9 Fc}



static void Test_BFu33_BFu9i_B()
{
  {
    init_simple_test("BFu33_BFu9i_B");
    static BFu33_BFu9i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9i_B");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9i_B");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9i_B");
    check_field_offset(lv, v3, 6, "BFu33_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu9i_B(Test_BFu33_BFu9i_B, "BFu33_BFu9i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu9ll_B  {
  __tsu64 v1:33;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 BFu33_BFu9ll_B) C1{ FL:33 FL:9 Fc}



static void Test_BFu33_BFu9ll_B()
{
  {
    init_simple_test("BFu33_BFu9ll_B");
    static BFu33_BFu9ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9ll_B");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9ll_B");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9ll_B");
    check_field_offset(lv, v3, 6, "BFu33_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu9ll_B(Test_BFu33_BFu9ll_B, "BFu33_BFu9ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_BFu9s_B  {
  __tsu64 v1:33;
  unsigned short v2:9;
  bool v3;
};
//SIG(1 BFu33_BFu9s_B) C1{ FL:33 Fs:9 Fc}



static void Test_BFu33_BFu9s_B()
{
  {
    init_simple_test("BFu33_BFu9s_B");
    static BFu33_BFu9s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_BFu9s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_BFu9s_B");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu33_BFu9s_B");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu33_BFu9s_B");
    check_field_offset(lv, v3, 6, "BFu33_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_BFu9s_B(Test_BFu33_BFu9s_B, "BFu33_BFu9s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_C_B  {
  __tsu64 v1:33;
  char v2;
  bool v3;
};
//SIG(1 BFu33_C_B) C1{ FL:33 Fc[2]}



static void Test_BFu33_C_B()
{
  {
    init_simple_test("BFu33_C_B");
    static BFu33_C_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_C_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_C_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_C_B");
    check_field_offset(lv, v2, 5, "BFu33_C_B.v2");
    check_field_offset(lv, v3, 6, "BFu33_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_C_B(Test_BFu33_C_B, "BFu33_C_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_D_B  {
  __tsu64 v1:33;
  double v2;
  bool v3;
};
//SIG(1 BFu33_D_B) C1{ FL:33 FL Fc}



static void Test_BFu33_D_B()
{
  {
    init_simple_test("BFu33_D_B");
    static BFu33_D_B lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu33_D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_D_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_D_B");
    check_field_offset(lv, v2, 8, "BFu33_D_B.v2");
    check_field_offset(lv, v3, 16, "BFu33_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_D_B(Test_BFu33_D_B, "BFu33_D_B", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_F_B  {
  __tsu64 v1:33;
  float v2;
  bool v3;
};
//SIG(1 BFu33_F_B) C1{ FL:33 Fi Fc}



static void Test_BFu33_F_B()
{
  {
    init_simple_test("BFu33_F_B");
    static BFu33_F_B lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_F_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_F_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_F_B");
    check_field_offset(lv, v2, 8, "BFu33_F_B.v2");
    check_field_offset(lv, v3, 12, "BFu33_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_F_B(Test_BFu33_F_B, "BFu33_F_B", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_I_B  {
  __tsu64 v1:33;
  int v2;
  bool v3;
};
//SIG(1 BFu33_I_B) C1{ FL:33 Fi Fc}



static void Test_BFu33_I_B()
{
  {
    init_simple_test("BFu33_I_B");
    static BFu33_I_B lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_I_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_I_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_I_B");
    check_field_offset(lv, v2, 8, "BFu33_I_B.v2");
    check_field_offset(lv, v3, 12, "BFu33_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_I_B(Test_BFu33_I_B, "BFu33_I_B", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_Ip_B  {
  __tsu64 v1:33;
  int *v2;
  bool v3;
};
//SIG(1 BFu33_Ip_B) C1{ FL:33 Fp Fc}



static void Test_BFu33_Ip_B()
{
  {
    init_simple_test("BFu33_Ip_B");
    static BFu33_Ip_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu33_Ip_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ip_B");
    check_field_offset(lv, v2, 8, "BFu33_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu33_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_Ip_B(Test_BFu33_Ip_B, "BFu33_Ip_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_L_B  {
  __tsu64 v1:33;
  __tsi64 v2;
  bool v3;
};
//SIG(1 BFu33_L_B) C1{ FL:33 FL Fc}



static void Test_BFu33_L_B()
{
  {
    init_simple_test("BFu33_L_B");
    static BFu33_L_B lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu33_L_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_L_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_L_B");
    check_field_offset(lv, v2, 8, "BFu33_L_B.v2");
    check_field_offset(lv, v3, 16, "BFu33_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_L_B(Test_BFu33_L_B, "BFu33_L_B", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_S_B  {
  __tsu64 v1:33;
  short v2;
  bool v3;
};
//SIG(1 BFu33_S_B) C1{ FL:33 Fs Fc}



static void Test_BFu33_S_B()
{
  {
    init_simple_test("BFu33_S_B");
    static BFu33_S_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_S_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_S_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_S_B");
    check_field_offset(lv, v2, 6, "BFu33_S_B.v2");
    check_field_offset(lv, v3, 8, "BFu33_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_S_B(Test_BFu33_S_B, "BFu33_S_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_Uc_B  {
  __tsu64 v1:33;
  unsigned char v2;
  bool v3;
};
//SIG(1 BFu33_Uc_B) C1{ FL:33 Fc[2]}



static void Test_BFu33_Uc_B()
{
  {
    init_simple_test("BFu33_Uc_B");
    static BFu33_Uc_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu33_Uc_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Uc_B");
    check_field_offset(lv, v2, 5, "BFu33_Uc_B.v2");
    check_field_offset(lv, v3, 6, "BFu33_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_Uc_B(Test_BFu33_Uc_B, "BFu33_Uc_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_Ui_B  {
  __tsu64 v1:33;
  unsigned int v2;
  bool v3;
};
//SIG(1 BFu33_Ui_B) C1{ FL:33 Fi Fc}



static void Test_BFu33_Ui_B()
{
  {
    init_simple_test("BFu33_Ui_B");
    static BFu33_Ui_B lv;
    check2(sizeof(lv), 16, "sizeof(BFu33_Ui_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ui_B");
    check_field_offset(lv, v2, 8, "BFu33_Ui_B.v2");
    check_field_offset(lv, v3, 12, "BFu33_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_Ui_B(Test_BFu33_Ui_B, "BFu33_Ui_B", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_Ul_B  {
  __tsu64 v1:33;
  __tsu64 v2;
  bool v3;
};
//SIG(1 BFu33_Ul_B) C1{ FL:33 FL Fc}



static void Test_BFu33_Ul_B()
{
  {
    init_simple_test("BFu33_Ul_B");
    static BFu33_Ul_B lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(BFu33_Ul_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Ul_B");
    check_field_offset(lv, v2, 8, "BFu33_Ul_B.v2");
    check_field_offset(lv, v3, 16, "BFu33_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_Ul_B(Test_BFu33_Ul_B, "BFu33_Ul_B", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_Us_B  {
  __tsu64 v1:33;
  unsigned short v2;
  bool v3;
};
//SIG(1 BFu33_Us_B) C1{ FL:33 Fs Fc}



static void Test_BFu33_Us_B()
{
  {
    init_simple_test("BFu33_Us_B");
    static BFu33_Us_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu33_Us_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Us_B");
    check_field_offset(lv, v2, 6, "BFu33_Us_B.v2");
    check_field_offset(lv, v3, 8, "BFu33_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_Us_B(Test_BFu33_Us_B, "BFu33_Us_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu33_Vp_B  {
  __tsu64 v1:33;
  void *v2;
  bool v3;
};
//SIG(1 BFu33_Vp_B) C1{ FL:33 Fp Fc}



static void Test_BFu33_Vp_B()
{
  {
    init_simple_test("BFu33_Vp_B");
    static BFu33_Vp_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu33_Vp_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu33_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu33_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu33_Vp_B");
    check_field_offset(lv, v2, 8, "BFu33_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu33_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu33_Vp_B(Test_BFu33_Vp_B, "BFu33_Vp_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B  {
  unsigned char v1:7;
  bool v2;
};
//SIG(1 BFu7c_B) C1{ Fc:7 Fc}



static void Test_BFu7c_B()
{
  {
    init_simple_test("BFu7c_B");
    static BFu7c_B lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B");
    check_field_offset(lv, v2, 1, "BFu7c_B.v2");
  }
}
static Arrange_To_Call_Me vBFu7c_B(Test_BFu7c_B, "BFu7c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_B  {
  unsigned char v1:7;
  bool v2;
  bool v3;
};
//SIG(1 BFu7c_B_B) C1{ Fc:7 Fc[2]}



static void Test_BFu7c_B_B()
{
  {
    init_simple_test("BFu7c_B_B");
    static BFu7c_B_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_B");
    check_field_offset(lv, v2, 1, "BFu7c_B_B.v2");
    check_field_offset(lv, v3, 2, "BFu7c_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_B_B(Test_BFu7c_B_B, "BFu7c_B_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu15i  {
  unsigned char v1:7;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 BFu7c_B_BFu15i) C1{ Fc:7 Fc Fi:15}



static void Test_BFu7c_B_BFu15i()
{
  {
    init_simple_test("BFu7c_B_BFu15i");
    static BFu7c_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_B_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu15i");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7c_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu15i(Test_BFu7c_B_BFu15i, "BFu7c_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu15ll  {
  unsigned char v1:7;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 BFu7c_B_BFu15ll) C1{ Fc:7 Fc FL:15}



static void Test_BFu7c_B_BFu15ll()
{
  {
    init_simple_test("BFu7c_B_BFu15ll");
    static BFu7c_B_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7c_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu15ll(Test_BFu7c_B_BFu15ll, "BFu7c_B_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu15s  {
  unsigned char v1:7;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 BFu7c_B_BFu15s) C1{ Fc:7 Fc Fs:15}



static void Test_BFu7c_B_BFu15s()
{
  {
    init_simple_test("BFu7c_B_BFu15s");
    static BFu7c_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_B_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu15s");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7c_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu15s(Test_BFu7c_B_BFu15s, "BFu7c_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu16i  {
  unsigned char v1:7;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 BFu7c_B_BFu16i) C1{ Fc:7 Fc Fi:16}



static void Test_BFu7c_B_BFu16i()
{
  {
    init_simple_test("BFu7c_B_BFu16i");
    static BFu7c_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_B_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu16i");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7c_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu16i(Test_BFu7c_B_BFu16i, "BFu7c_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu16ll  {
  unsigned char v1:7;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 BFu7c_B_BFu16ll) C1{ Fc:7 Fc FL:16}



static void Test_BFu7c_B_BFu16ll()
{
  {
    init_simple_test("BFu7c_B_BFu16ll");
    static BFu7c_B_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7c_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu16ll(Test_BFu7c_B_BFu16ll, "BFu7c_B_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu16s  {
  unsigned char v1:7;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 BFu7c_B_BFu16s) C1{ Fc:7 Fc Fs:16}



static void Test_BFu7c_B_BFu16s()
{
  {
    init_simple_test("BFu7c_B_BFu16s");
    static BFu7c_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_B_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu16s");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7c_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu16s(Test_BFu7c_B_BFu16s, "BFu7c_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu17i  {
  unsigned char v1:7;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 BFu7c_B_BFu17i) C1{ Fc:7 Fc Fi:17}



static void Test_BFu7c_B_BFu17i()
{
  {
    init_simple_test("BFu7c_B_BFu17i");
    static BFu7c_B_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_B_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu17i");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu7c_B_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu7c_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu17i(Test_BFu7c_B_BFu17i, "BFu7c_B_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu17ll  {
  unsigned char v1:7;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 BFu7c_B_BFu17ll) C1{ Fc:7 Fc FL:17}



static void Test_BFu7c_B_BFu17ll()
{
  {
    init_simple_test("BFu7c_B_BFu17ll");
    static BFu7c_B_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu7c_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu7c_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu17ll(Test_BFu7c_B_BFu17ll, "BFu7c_B_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu1c  {
  unsigned char v1:7;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 BFu7c_B_BFu1c) C1{ Fc:7 Fc Fc:1}



static void Test_BFu7c_B_BFu1c()
{
  {
    init_simple_test("BFu7c_B_BFu1c");
    static BFu7c_B_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu1c");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7c_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu1c(Test_BFu7c_B_BFu1c, "BFu7c_B_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu1i  {
  unsigned char v1:7;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 BFu7c_B_BFu1i) C1{ Fc:7 Fc Fi:1}



static void Test_BFu7c_B_BFu1i()
{
  {
    init_simple_test("BFu7c_B_BFu1i");
    static BFu7c_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_B_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu1i");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7c_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu1i(Test_BFu7c_B_BFu1i, "BFu7c_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu1ll  {
  unsigned char v1:7;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 BFu7c_B_BFu1ll) C1{ Fc:7 Fc FL:1}



static void Test_BFu7c_B_BFu1ll()
{
  {
    init_simple_test("BFu7c_B_BFu1ll");
    static BFu7c_B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7c_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu1ll(Test_BFu7c_B_BFu1ll, "BFu7c_B_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu1s  {
  unsigned char v1:7;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 BFu7c_B_BFu1s) C1{ Fc:7 Fc Fs:1}



static void Test_BFu7c_B_BFu1s()
{
  {
    init_simple_test("BFu7c_B_BFu1s");
    static BFu7c_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_B_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu1s");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7c_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu1s(Test_BFu7c_B_BFu1s, "BFu7c_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu31i  {
  unsigned char v1:7;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 BFu7c_B_BFu31i) C1{ Fc:7 Fc Fi:31}



static void Test_BFu7c_B_BFu31i()
{
  {
    init_simple_test("BFu7c_B_BFu31i");
    static BFu7c_B_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_B_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu31i");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu7c_B_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu7c_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu31i(Test_BFu7c_B_BFu31i, "BFu7c_B_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu31ll  {
  unsigned char v1:7;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 BFu7c_B_BFu31ll) C1{ Fc:7 Fc FL:31}



static void Test_BFu7c_B_BFu31ll()
{
  {
    init_simple_test("BFu7c_B_BFu31ll");
    static BFu7c_B_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu7c_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu7c_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu31ll(Test_BFu7c_B_BFu31ll, "BFu7c_B_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu32i  {
  unsigned char v1:7;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 BFu7c_B_BFu32i) C1{ Fc:7 Fc Fi:32}



static void Test_BFu7c_B_BFu32i()
{
  {
    init_simple_test("BFu7c_B_BFu32i");
    static BFu7c_B_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_B_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu32i");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu7c_B_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu7c_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu32i(Test_BFu7c_B_BFu32i, "BFu7c_B_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu32ll  {
  unsigned char v1:7;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 BFu7c_B_BFu32ll) C1{ Fc:7 Fc FL:32}



static void Test_BFu7c_B_BFu32ll()
{
  {
    init_simple_test("BFu7c_B_BFu32ll");
    static BFu7c_B_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu7c_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu7c_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu32ll(Test_BFu7c_B_BFu32ll, "BFu7c_B_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu33  {
  unsigned char v1:7;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 BFu7c_B_BFu33) C1{ Fc:7 Fc FL:33}



static void Test_BFu7c_B_BFu33()
{
  {
    init_simple_test("BFu7c_B_BFu33");
    static BFu7c_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu33");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu7c_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu7c_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu33(Test_BFu7c_B_BFu33, "BFu7c_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu7c  {
  unsigned char v1:7;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 BFu7c_B_BFu7c) C1{ Fc:7 Fc Fc:7}



static void Test_BFu7c_B_BFu7c()
{
  {
    init_simple_test("BFu7c_B_BFu7c");
    static BFu7c_B_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu7c");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7c_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu7c(Test_BFu7c_B_BFu7c, "BFu7c_B_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu7i  {
  unsigned char v1:7;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 BFu7c_B_BFu7i) C1{ Fc:7 Fc Fi:7}



static void Test_BFu7c_B_BFu7i()
{
  {
    init_simple_test("BFu7c_B_BFu7i");
    static BFu7c_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_B_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu7i");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7c_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu7i(Test_BFu7c_B_BFu7i, "BFu7c_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu7ll  {
  unsigned char v1:7;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 BFu7c_B_BFu7ll) C1{ Fc:7 Fc FL:7}



static void Test_BFu7c_B_BFu7ll()
{
  {
    init_simple_test("BFu7c_B_BFu7ll");
    static BFu7c_B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7c_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu7ll(Test_BFu7c_B_BFu7ll, "BFu7c_B_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu7s  {
  unsigned char v1:7;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 BFu7c_B_BFu7s) C1{ Fc:7 Fc Fs:7}



static void Test_BFu7c_B_BFu7s()
{
  {
    init_simple_test("BFu7c_B_BFu7s");
    static BFu7c_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_B_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu7s");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7c_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu7s(Test_BFu7c_B_BFu7s, "BFu7c_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu8c  {
  unsigned char v1:7;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 BFu7c_B_BFu8c) C1{ Fc:7 Fc Fc:8}



static void Test_BFu7c_B_BFu8c()
{
  {
    init_simple_test("BFu7c_B_BFu8c");
    static BFu7c_B_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu8c");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7c_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7c_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu8c(Test_BFu7c_B_BFu8c, "BFu7c_B_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu8i  {
  unsigned char v1:7;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 BFu7c_B_BFu8i) C1{ Fc:7 Fc Fi:8}



static void Test_BFu7c_B_BFu8i()
{
  {
    init_simple_test("BFu7c_B_BFu8i");
    static BFu7c_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_B_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu8i");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7c_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7c_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu8i(Test_BFu7c_B_BFu8i, "BFu7c_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu8ll  {
  unsigned char v1:7;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 BFu7c_B_BFu8ll) C1{ Fc:7 Fc FL:8}



static void Test_BFu7c_B_BFu8ll()
{
  {
    init_simple_test("BFu7c_B_BFu8ll");
    static BFu7c_B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7c_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7c_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu8ll(Test_BFu7c_B_BFu8ll, "BFu7c_B_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu8s  {
  unsigned char v1:7;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 BFu7c_B_BFu8s) C1{ Fc:7 Fc Fs:8}



static void Test_BFu7c_B_BFu8s()
{
  {
    init_simple_test("BFu7c_B_BFu8s");
    static BFu7c_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_B_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu8s");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7c_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7c_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu8s(Test_BFu7c_B_BFu8s, "BFu7c_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu9i  {
  unsigned char v1:7;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 BFu7c_B_BFu9i) C1{ Fc:7 Fc Fi:9}



static void Test_BFu7c_B_BFu9i()
{
  {
    init_simple_test("BFu7c_B_BFu9i");
    static BFu7c_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_B_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu9i");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7c_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7c_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu9i(Test_BFu7c_B_BFu9i, "BFu7c_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu9ll  {
  unsigned char v1:7;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 BFu7c_B_BFu9ll) C1{ Fc:7 Fc FL:9}



static void Test_BFu7c_B_BFu9ll()
{
  {
    init_simple_test("BFu7c_B_BFu9ll");
    static BFu7c_B_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7c_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7c_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu9ll(Test_BFu7c_B_BFu9ll, "BFu7c_B_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_BFu9s  {
  unsigned char v1:7;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 BFu7c_B_BFu9s) C1{ Fc:7 Fc Fs:9}



static void Test_BFu7c_B_BFu9s()
{
  {
    init_simple_test("BFu7c_B_BFu9s");
    static BFu7c_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_B_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_BFu9s");
    check_field_offset(lv, v2, 1, "BFu7c_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7c_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7c_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu7c_B_BFu9s(Test_BFu7c_B_BFu9s, "BFu7c_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_C  {
  unsigned char v1:7;
  bool v2;
  char v3;
};
//SIG(1 BFu7c_B_C) C1{ Fc:7 Fc[2]}



static void Test_BFu7c_B_C()
{
  {
    init_simple_test("BFu7c_B_C");
    static BFu7c_B_C lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_C");
    check_field_offset(lv, v2, 1, "BFu7c_B_C.v2");
    check_field_offset(lv, v3, 2, "BFu7c_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_B_C(Test_BFu7c_B_C, "BFu7c_B_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_D  {
  unsigned char v1:7;
  bool v2;
  double v3;
};
//SIG(1 BFu7c_B_D) C1{ Fc:7 Fc FL}



static void Test_BFu7c_B_D()
{
  {
    init_simple_test("BFu7c_B_D");
    static BFu7c_B_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_D");
    check_field_offset(lv, v2, 1, "BFu7c_B_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7c_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_B_D(Test_BFu7c_B_D, "BFu7c_B_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_F  {
  unsigned char v1:7;
  bool v2;
  float v3;
};
//SIG(1 BFu7c_B_F) C1{ Fc:7 Fc Fi}



static void Test_BFu7c_B_F()
{
  {
    init_simple_test("BFu7c_B_F");
    static BFu7c_B_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_B_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_F");
    check_field_offset(lv, v2, 1, "BFu7c_B_F.v2");
    check_field_offset(lv, v3, 4, "BFu7c_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_B_F(Test_BFu7c_B_F, "BFu7c_B_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_I  {
  unsigned char v1:7;
  bool v2;
  int v3;
};
//SIG(1 BFu7c_B_I) C1{ Fc:7 Fc Fi}



static void Test_BFu7c_B_I()
{
  {
    init_simple_test("BFu7c_B_I");
    static BFu7c_B_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_B_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_I");
    check_field_offset(lv, v2, 1, "BFu7c_B_I.v2");
    check_field_offset(lv, v3, 4, "BFu7c_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_B_I(Test_BFu7c_B_I, "BFu7c_B_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_Ip  {
  unsigned char v1:7;
  bool v2;
  int *v3;
};
//SIG(1 BFu7c_B_Ip) C1{ Fc:7 Fc Fp}



static void Test_BFu7c_B_Ip()
{
  {
    init_simple_test("BFu7c_B_Ip");
    static BFu7c_B_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_Ip");
    check_field_offset(lv, v2, 1, "BFu7c_B_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7c_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_B_Ip(Test_BFu7c_B_Ip, "BFu7c_B_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_L  {
  unsigned char v1:7;
  bool v2;
  __tsi64 v3;
};
//SIG(1 BFu7c_B_L) C1{ Fc:7 Fc FL}



static void Test_BFu7c_B_L()
{
  {
    init_simple_test("BFu7c_B_L");
    static BFu7c_B_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_L");
    check_field_offset(lv, v2, 1, "BFu7c_B_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7c_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_B_L(Test_BFu7c_B_L, "BFu7c_B_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_S  {
  unsigned char v1:7;
  bool v2;
  short v3;
};
//SIG(1 BFu7c_B_S) C1{ Fc:7 Fc Fs}



static void Test_BFu7c_B_S()
{
  {
    init_simple_test("BFu7c_B_S");
    static BFu7c_B_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_B_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_S");
    check_field_offset(lv, v2, 1, "BFu7c_B_S.v2");
    check_field_offset(lv, v3, 2, "BFu7c_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_B_S(Test_BFu7c_B_S, "BFu7c_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_Uc  {
  unsigned char v1:7;
  bool v2;
  unsigned char v3;
};
//SIG(1 BFu7c_B_Uc) C1{ Fc:7 Fc[2]}



static void Test_BFu7c_B_Uc()
{
  {
    init_simple_test("BFu7c_B_Uc");
    static BFu7c_B_Uc lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_Uc");
    check_field_offset(lv, v2, 1, "BFu7c_B_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu7c_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_B_Uc(Test_BFu7c_B_Uc, "BFu7c_B_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_Ui  {
  unsigned char v1:7;
  bool v2;
  unsigned int v3;
};
//SIG(1 BFu7c_B_Ui) C1{ Fc:7 Fc Fi}



static void Test_BFu7c_B_Ui()
{
  {
    init_simple_test("BFu7c_B_Ui");
    static BFu7c_B_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_B_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_Ui");
    check_field_offset(lv, v2, 1, "BFu7c_B_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu7c_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_B_Ui(Test_BFu7c_B_Ui, "BFu7c_B_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_Ul  {
  unsigned char v1:7;
  bool v2;
  __tsu64 v3;
};
//SIG(1 BFu7c_B_Ul) C1{ Fc:7 Fc FL}



static void Test_BFu7c_B_Ul()
{
  {
    init_simple_test("BFu7c_B_Ul");
    static BFu7c_B_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7c_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_Ul");
    check_field_offset(lv, v2, 1, "BFu7c_B_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7c_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_B_Ul(Test_BFu7c_B_Ul, "BFu7c_B_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_Us  {
  unsigned char v1:7;
  bool v2;
  unsigned short v3;
};
//SIG(1 BFu7c_B_Us) C1{ Fc:7 Fc Fs}



static void Test_BFu7c_B_Us()
{
  {
    init_simple_test("BFu7c_B_Us");
    static BFu7c_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_B_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_Us");
    check_field_offset(lv, v2, 1, "BFu7c_B_Us.v2");
    check_field_offset(lv, v3, 2, "BFu7c_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_B_Us(Test_BFu7c_B_Us, "BFu7c_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_B_Vp  {
  unsigned char v1:7;
  bool v2;
  void *v3;
};
//SIG(1 BFu7c_B_Vp) C1{ Fc:7 Fc Fp}



static void Test_BFu7c_B_Vp()
{
  {
    init_simple_test("BFu7c_B_Vp");
    static BFu7c_B_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7c_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_B_Vp");
    check_field_offset(lv, v2, 1, "BFu7c_B_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7c_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_B_Vp(Test_BFu7c_B_Vp, "BFu7c_B_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu15i_B  {
  unsigned char v1:7;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 BFu7c_BFu15i_B) C1{ Fc:7 Fi:15 Fc}



static void Test_BFu7c_BFu15i_B()
{
  {
    init_simple_test("BFu7c_BFu15i_B");
    static BFu7c_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu15i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7c_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7c_BFu15i_B");
    check_field_offset(lv, v3, 3, "BFu7c_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu15i_B(Test_BFu7c_BFu15i_B, "BFu7c_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu15ll_B  {
  unsigned char v1:7;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 BFu7c_BFu15ll_B) C1{ Fc:7 FL:15 Fc}



static void Test_BFu7c_BFu15ll_B()
{
  {
    init_simple_test("BFu7c_BFu15ll_B");
    static BFu7c_BFu15ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7c_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7c_BFu15ll_B");
    check_field_offset(lv, v3, 3, "BFu7c_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu15ll_B(Test_BFu7c_BFu15ll_B, "BFu7c_BFu15ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu15s_B  {
  unsigned char v1:7;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 BFu7c_BFu15s_B) C1{ Fc:7 Fs:15 Fc}



static void Test_BFu7c_BFu15s_B()
{
  {
    init_simple_test("BFu7c_BFu15s_B");
    static BFu7c_BFu15s_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_BFu15s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7c_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7c_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu7c_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu15s_B(Test_BFu7c_BFu15s_B, "BFu7c_BFu15s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu16i_B  {
  unsigned char v1:7;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 BFu7c_BFu16i_B) C1{ Fc:7 Fi:16 Fc}



static void Test_BFu7c_BFu16i_B()
{
  {
    init_simple_test("BFu7c_BFu16i_B");
    static BFu7c_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu16i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7c_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7c_BFu16i_B");
    check_field_offset(lv, v3, 3, "BFu7c_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu16i_B(Test_BFu7c_BFu16i_B, "BFu7c_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu16ll_B  {
  unsigned char v1:7;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 BFu7c_BFu16ll_B) C1{ Fc:7 FL:16 Fc}



static void Test_BFu7c_BFu16ll_B()
{
  {
    init_simple_test("BFu7c_BFu16ll_B");
    static BFu7c_BFu16ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7c_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7c_BFu16ll_B");
    check_field_offset(lv, v3, 3, "BFu7c_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu16ll_B(Test_BFu7c_BFu16ll_B, "BFu7c_BFu16ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu16s_B  {
  unsigned char v1:7;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 BFu7c_BFu16s_B) C1{ Fc:7 Fs:16 Fc}



static void Test_BFu7c_BFu16s_B()
{
  {
    init_simple_test("BFu7c_BFu16s_B");
    static BFu7c_BFu16s_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_BFu16s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7c_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7c_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu7c_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu16s_B(Test_BFu7c_BFu16s_B, "BFu7c_BFu16s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu17i_B  {
  unsigned char v1:7;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 BFu7c_BFu17i_B) C1{ Fc:7 Fi:17 Fc}



static void Test_BFu7c_BFu17i_B()
{
  {
    init_simple_test("BFu7c_BFu17i_B");
    static BFu7c_BFu17i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu17i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7c_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7c_BFu17i_B");
    check_field_offset(lv, v3, 3, "BFu7c_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu17i_B(Test_BFu7c_BFu17i_B, "BFu7c_BFu17i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu17ll_B  {
  unsigned char v1:7;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 BFu7c_BFu17ll_B) C1{ Fc:7 FL:17 Fc}



static void Test_BFu7c_BFu17ll_B()
{
  {
    init_simple_test("BFu7c_BFu17ll_B");
    static BFu7c_BFu17ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7c_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7c_BFu17ll_B");
    check_field_offset(lv, v3, 3, "BFu7c_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu17ll_B(Test_BFu7c_BFu17ll_B, "BFu7c_BFu17ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu1c_B  {
  unsigned char v1:7;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 BFu7c_BFu1c_B) C1{ Fc:7 Fc:1 Fc}



static void Test_BFu7c_BFu1c_B()
{
  {
    init_simple_test("BFu7c_BFu1c_B");
    static BFu7c_BFu1c_B lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1c_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1c_B");
    check_field_offset(lv, v3, 1, "BFu7c_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu1c_B(Test_BFu7c_BFu1c_B, "BFu7c_BFu1c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu1i_B  {
  unsigned char v1:7;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 BFu7c_BFu1i_B) C1{ Fc:7 Fi:1 Fc}



static void Test_BFu7c_BFu1i_B()
{
  {
    init_simple_test("BFu7c_BFu1i_B");
    static BFu7c_BFu1i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu1i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1i_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1i_B");
    check_field_offset(lv, v3, 1, "BFu7c_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu1i_B(Test_BFu7c_BFu1i_B, "BFu7c_BFu1i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu1ll_B  {
  unsigned char v1:7;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 BFu7c_BFu1ll_B) C1{ Fc:7 FL:1 Fc}



static void Test_BFu7c_BFu1ll_B()
{
  {
    init_simple_test("BFu7c_BFu1ll_B");
    static BFu7c_BFu1ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1ll_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1ll_B");
    check_field_offset(lv, v3, 1, "BFu7c_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu1ll_B(Test_BFu7c_BFu1ll_B, "BFu7c_BFu1ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu1s_B  {
  unsigned char v1:7;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 BFu7c_BFu1s_B) C1{ Fc:7 Fs:1 Fc}



static void Test_BFu7c_BFu1s_B()
{
  {
    init_simple_test("BFu7c_BFu1s_B");
    static BFu7c_BFu1s_B lv;
    check2(sizeof(lv), 2, "sizeof(BFu7c_BFu1s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu1s_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7c_BFu1s_B");
    check_field_offset(lv, v3, 1, "BFu7c_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu1s_B(Test_BFu7c_BFu1s_B, "BFu7c_BFu1s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu31i_B  {
  unsigned char v1:7;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 BFu7c_BFu31i_B) C1{ Fc:7 Fi:31 Fc}



static void Test_BFu7c_BFu31i_B()
{
  {
    init_simple_test("BFu7c_BFu31i_B");
    static BFu7c_BFu31i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7c_BFu31i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7c_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7c_BFu31i_B");
    check_field_offset(lv, v3, 8, "BFu7c_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu31i_B(Test_BFu7c_BFu31i_B, "BFu7c_BFu31i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu31ll_B  {
  unsigned char v1:7;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 BFu7c_BFu31ll_B) C1{ Fc:7 FL:31 Fc}



static void Test_BFu7c_BFu31ll_B()
{
  {
    init_simple_test("BFu7c_BFu31ll_B");
    static BFu7c_BFu31ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7c_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7c_BFu31ll_B");
    check_field_offset(lv, v3, 5, "BFu7c_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu31ll_B(Test_BFu7c_BFu31ll_B, "BFu7c_BFu31ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu32i_B  {
  unsigned char v1:7;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 BFu7c_BFu32i_B) C1{ Fc:7 Fi:32 Fc}



static void Test_BFu7c_BFu32i_B()
{
  {
    init_simple_test("BFu7c_BFu32i_B");
    static BFu7c_BFu32i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7c_BFu32i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7c_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7c_BFu32i_B");
    check_field_offset(lv, v3, 8, "BFu7c_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu32i_B(Test_BFu7c_BFu32i_B, "BFu7c_BFu32i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu32ll_B  {
  unsigned char v1:7;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 BFu7c_BFu32ll_B) C1{ Fc:7 FL:32 Fc}



static void Test_BFu7c_BFu32ll_B()
{
  {
    init_simple_test("BFu7c_BFu32ll_B");
    static BFu7c_BFu32ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7c_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7c_BFu32ll_B");
    check_field_offset(lv, v3, 5, "BFu7c_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu32ll_B(Test_BFu7c_BFu32ll_B, "BFu7c_BFu32ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu33_B  {
  unsigned char v1:7;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 BFu7c_BFu33_B) C1{ Fc:7 FL:33 Fc}



static void Test_BFu7c_BFu33_B()
{
  {
    init_simple_test("BFu7c_BFu33_B");
    static BFu7c_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7c_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7c_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7c_BFu33_B");
    check_field_offset(lv, v3, 5, "BFu7c_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu33_B(Test_BFu7c_BFu33_B, "BFu7c_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu7c_B  {
  unsigned char v1:7;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 BFu7c_BFu7c_B) C1{ Fc:7 Fc:7 Fc}



static void Test_BFu7c_BFu7c_B()
{
  {
    init_simple_test("BFu7c_BFu7c_B");
    static BFu7c_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7c_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7c_B");
    check_field_offset(lv, v3, 2, "BFu7c_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu7c_B(Test_BFu7c_BFu7c_B, "BFu7c_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu7i_B  {
  unsigned char v1:7;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 BFu7c_BFu7i_B) C1{ Fc:7 Fi:7 Fc}



static void Test_BFu7c_BFu7i_B()
{
  {
    init_simple_test("BFu7c_BFu7i_B");
    static BFu7c_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu7i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7i_B");
    check_field_offset(lv, v3, 2, "BFu7c_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu7i_B(Test_BFu7c_BFu7i_B, "BFu7c_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu7ll_B  {
  unsigned char v1:7;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 BFu7c_BFu7ll_B) C1{ Fc:7 FL:7 Fc}



static void Test_BFu7c_BFu7ll_B()
{
  {
    init_simple_test("BFu7c_BFu7ll_B");
    static BFu7c_BFu7ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7ll_B");
    check_field_offset(lv, v3, 2, "BFu7c_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu7ll_B(Test_BFu7c_BFu7ll_B, "BFu7c_BFu7ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu7s_B  {
  unsigned char v1:7;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 BFu7c_BFu7s_B) C1{ Fc:7 Fs:7 Fc}



static void Test_BFu7c_BFu7s_B()
{
  {
    init_simple_test("BFu7c_BFu7s_B");
    static BFu7c_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu7s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7c_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7c_BFu7s_B");
    check_field_offset(lv, v3, 2, "BFu7c_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu7s_B(Test_BFu7c_BFu7s_B, "BFu7c_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu8c_B  {
  unsigned char v1:7;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 BFu7c_BFu8c_B) C1{ Fc:7 Fc:8 Fc}



static void Test_BFu7c_BFu8c_B()
{
  {
    init_simple_test("BFu7c_BFu8c_B");
    static BFu7c_BFu8c_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7c_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7c_BFu8c_B");
    check_field_offset(lv, v3, 2, "BFu7c_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu8c_B(Test_BFu7c_BFu8c_B, "BFu7c_BFu8c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu8i_B  {
  unsigned char v1:7;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 BFu7c_BFu8i_B) C1{ Fc:7 Fi:8 Fc}



static void Test_BFu7c_BFu8i_B()
{
  {
    init_simple_test("BFu7c_BFu8i_B");
    static BFu7c_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu8i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8i_B");
    check_field_offset(lv, v3, 2, "BFu7c_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu8i_B(Test_BFu7c_BFu8i_B, "BFu7c_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu8ll_B  {
  unsigned char v1:7;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 BFu7c_BFu8ll_B) C1{ Fc:7 FL:8 Fc}



static void Test_BFu7c_BFu8ll_B()
{
  {
    init_simple_test("BFu7c_BFu8ll_B");
    static BFu7c_BFu8ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8ll_B");
    check_field_offset(lv, v3, 2, "BFu7c_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu8ll_B(Test_BFu7c_BFu8ll_B, "BFu7c_BFu8ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu8s_B  {
  unsigned char v1:7;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 BFu7c_BFu8s_B) C1{ Fc:7 Fs:8 Fc}



static void Test_BFu7c_BFu8s_B()
{
  {
    init_simple_test("BFu7c_BFu8s_B");
    static BFu7c_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu8s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7c_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7c_BFu8s_B");
    check_field_offset(lv, v3, 2, "BFu7c_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu8s_B(Test_BFu7c_BFu8s_B, "BFu7c_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu9i_B  {
  unsigned char v1:7;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 BFu7c_BFu9i_B) C1{ Fc:7 Fi:9 Fc}



static void Test_BFu7c_BFu9i_B()
{
  {
    init_simple_test("BFu7c_BFu9i_B");
    static BFu7c_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu9i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9i_B");
    check_field_offset(lv, v3, 2, "BFu7c_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu9i_B(Test_BFu7c_BFu9i_B, "BFu7c_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu9ll_B  {
  unsigned char v1:7;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 BFu7c_BFu9ll_B) C1{ Fc:7 FL:9 Fc}



static void Test_BFu7c_BFu9ll_B()
{
  {
    init_simple_test("BFu7c_BFu9ll_B");
    static BFu7c_BFu9ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7c_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9ll_B");
    check_field_offset(lv, v3, 2, "BFu7c_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu9ll_B(Test_BFu7c_BFu9ll_B, "BFu7c_BFu9ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_BFu9s_B  {
  unsigned char v1:7;
  unsigned short v2:9;
  bool v3;
};
//SIG(1 BFu7c_BFu9s_B) C1{ Fc:7 Fs:9 Fc}



static void Test_BFu7c_BFu9s_B()
{
  {
    init_simple_test("BFu7c_BFu9s_B");
    static BFu7c_BFu9s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7c_BFu9s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7c_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7c_BFu9s_B");
    check_field_offset(lv, v3, 2, "BFu7c_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_BFu9s_B(Test_BFu7c_BFu9s_B, "BFu7c_BFu9s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_C_B  {
  unsigned char v1:7;
  char v2;
  bool v3;
};
//SIG(1 BFu7c_C_B) C1{ Fc:7 Fc[2]}



static void Test_BFu7c_C_B()
{
  {
    init_simple_test("BFu7c_C_B");
    static BFu7c_C_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_C_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_C_B");
    check_field_offset(lv, v2, 1, "BFu7c_C_B.v2");
    check_field_offset(lv, v3, 2, "BFu7c_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_C_B(Test_BFu7c_C_B, "BFu7c_C_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_D_B  {
  unsigned char v1:7;
  double v2;
  bool v3;
};
//SIG(1 BFu7c_D_B) C1{ Fc:7 FL Fc}



static void Test_BFu7c_D_B()
{
  {
    init_simple_test("BFu7c_D_B");
    static BFu7c_D_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu7c_D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_D_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_D_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_D_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu7c_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_D_B(Test_BFu7c_D_B, "BFu7c_D_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_F_B  {
  unsigned char v1:7;
  float v2;
  bool v3;
};
//SIG(1 BFu7c_F_B) C1{ Fc:7 Fi Fc}



static void Test_BFu7c_F_B()
{
  {
    init_simple_test("BFu7c_F_B");
    static BFu7c_F_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7c_F_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_F_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_F_B");
    check_field_offset(lv, v2, 4, "BFu7c_F_B.v2");
    check_field_offset(lv, v3, 8, "BFu7c_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_F_B(Test_BFu7c_F_B, "BFu7c_F_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_I_B  {
  unsigned char v1:7;
  int v2;
  bool v3;
};
//SIG(1 BFu7c_I_B) C1{ Fc:7 Fi Fc}



static void Test_BFu7c_I_B()
{
  {
    init_simple_test("BFu7c_I_B");
    static BFu7c_I_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7c_I_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_I_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_I_B");
    check_field_offset(lv, v2, 4, "BFu7c_I_B.v2");
    check_field_offset(lv, v3, 8, "BFu7c_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_I_B(Test_BFu7c_I_B, "BFu7c_I_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_Ip_B  {
  unsigned char v1:7;
  int *v2;
  bool v3;
};
//SIG(1 BFu7c_Ip_B) C1{ Fc:7 Fp Fc}



static void Test_BFu7c_Ip_B()
{
  {
    init_simple_test("BFu7c_Ip_B");
    static BFu7c_Ip_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu7c_Ip_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ip_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu7c_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_Ip_B(Test_BFu7c_Ip_B, "BFu7c_Ip_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_L_B  {
  unsigned char v1:7;
  __tsi64 v2;
  bool v3;
};
//SIG(1 BFu7c_L_B) C1{ Fc:7 FL Fc}



static void Test_BFu7c_L_B()
{
  {
    init_simple_test("BFu7c_L_B");
    static BFu7c_L_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu7c_L_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_L_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_L_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_L_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu7c_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_L_B(Test_BFu7c_L_B, "BFu7c_L_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_S_B  {
  unsigned char v1:7;
  short v2;
  bool v3;
};
//SIG(1 BFu7c_S_B) C1{ Fc:7 Fs Fc}



static void Test_BFu7c_S_B()
{
  {
    init_simple_test("BFu7c_S_B");
    static BFu7c_S_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_S_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_S_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_S_B");
    check_field_offset(lv, v2, 2, "BFu7c_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu7c_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_S_B(Test_BFu7c_S_B, "BFu7c_S_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_Uc_B  {
  unsigned char v1:7;
  unsigned char v2;
  bool v3;
};
//SIG(1 BFu7c_Uc_B) C1{ Fc:7 Fc[2]}



static void Test_BFu7c_Uc_B()
{
  {
    init_simple_test("BFu7c_Uc_B");
    static BFu7c_Uc_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu7c_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu7c_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Uc_B");
    check_field_offset(lv, v2, 1, "BFu7c_Uc_B.v2");
    check_field_offset(lv, v3, 2, "BFu7c_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_Uc_B(Test_BFu7c_Uc_B, "BFu7c_Uc_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_Ui_B  {
  unsigned char v1:7;
  unsigned int v2;
  bool v3;
};
//SIG(1 BFu7c_Ui_B) C1{ Fc:7 Fi Fc}



static void Test_BFu7c_Ui_B()
{
  {
    init_simple_test("BFu7c_Ui_B");
    static BFu7c_Ui_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7c_Ui_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7c_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ui_B");
    check_field_offset(lv, v2, 4, "BFu7c_Ui_B.v2");
    check_field_offset(lv, v3, 8, "BFu7c_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_Ui_B(Test_BFu7c_Ui_B, "BFu7c_Ui_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_Ul_B  {
  unsigned char v1:7;
  __tsu64 v2;
  bool v3;
};
//SIG(1 BFu7c_Ul_B) C1{ Fc:7 FL Fc}



static void Test_BFu7c_Ul_B()
{
  {
    init_simple_test("BFu7c_Ul_B");
    static BFu7c_Ul_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu7c_Ul_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Ul_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Ul_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu7c_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_Ul_B(Test_BFu7c_Ul_B, "BFu7c_Ul_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_Us_B  {
  unsigned char v1:7;
  unsigned short v2;
  bool v3;
};
//SIG(1 BFu7c_Us_B) C1{ Fc:7 Fs Fc}



static void Test_BFu7c_Us_B()
{
  {
    init_simple_test("BFu7c_Us_B");
    static BFu7c_Us_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu7c_Us_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7c_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Us_B");
    check_field_offset(lv, v2, 2, "BFu7c_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu7c_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_Us_B(Test_BFu7c_Us_B, "BFu7c_Us_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7c_Vp_B  {
  unsigned char v1:7;
  void *v2;
  bool v3;
};
//SIG(1 BFu7c_Vp_B) C1{ Fc:7 Fp Fc}



static void Test_BFu7c_Vp_B()
{
  {
    init_simple_test("BFu7c_Vp_B");
    static BFu7c_Vp_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu7c_Vp_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7c_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7c_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7c_Vp_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7c_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu7c_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7c_Vp_B(Test_BFu7c_Vp_B, "BFu7c_Vp_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B  {
  unsigned int v1:7;
  bool v2;
};
//SIG(1 BFu7i_B) C1{ Fi:7 Fc}



static void Test_BFu7i_B()
{
  {
    init_simple_test("BFu7i_B");
    static BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B");
    check_field_offset(lv, v2, 1, "BFu7i_B.v2");
  }
}
static Arrange_To_Call_Me vBFu7i_B(Test_BFu7i_B, "BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_B  {
  unsigned int v1:7;
  bool v2;
  bool v3;
};
//SIG(1 BFu7i_B_B) C1{ Fi:7 Fc[2]}



static void Test_BFu7i_B_B()
{
  {
    init_simple_test("BFu7i_B_B");
    static BFu7i_B_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_B");
    check_field_offset(lv, v2, 1, "BFu7i_B_B.v2");
    check_field_offset(lv, v3, 2, "BFu7i_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_B_B(Test_BFu7i_B_B, "BFu7i_B_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu15i  {
  unsigned int v1:7;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 BFu7i_B_BFu15i) C1{ Fi:7 Fc Fi:15}



static void Test_BFu7i_B_BFu15i()
{
  {
    init_simple_test("BFu7i_B_BFu15i");
    static BFu7i_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu15i");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7i_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7i_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu15i(Test_BFu7i_B_BFu15i, "BFu7i_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu15ll  {
  unsigned int v1:7;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 BFu7i_B_BFu15ll) C1{ Fi:7 Fc FL:15}



static void Test_BFu7i_B_BFu15ll()
{
  {
    init_simple_test("BFu7i_B_BFu15ll");
    static BFu7i_B_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7i_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7i_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu15ll(Test_BFu7i_B_BFu15ll, "BFu7i_B_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu15s  {
  unsigned int v1:7;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 BFu7i_B_BFu15s) C1{ Fi:7 Fc Fs:15}



static void Test_BFu7i_B_BFu15s()
{
  {
    init_simple_test("BFu7i_B_BFu15s");
    static BFu7i_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu15s");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7i_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7i_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu15s(Test_BFu7i_B_BFu15s, "BFu7i_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu16i  {
  unsigned int v1:7;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 BFu7i_B_BFu16i) C1{ Fi:7 Fc Fi:16}



static void Test_BFu7i_B_BFu16i()
{
  {
    init_simple_test("BFu7i_B_BFu16i");
    static BFu7i_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu16i");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7i_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7i_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu16i(Test_BFu7i_B_BFu16i, "BFu7i_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu16ll  {
  unsigned int v1:7;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 BFu7i_B_BFu16ll) C1{ Fi:7 Fc FL:16}



static void Test_BFu7i_B_BFu16ll()
{
  {
    init_simple_test("BFu7i_B_BFu16ll");
    static BFu7i_B_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7i_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7i_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu16ll(Test_BFu7i_B_BFu16ll, "BFu7i_B_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu16s  {
  unsigned int v1:7;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 BFu7i_B_BFu16s) C1{ Fi:7 Fc Fs:16}



static void Test_BFu7i_B_BFu16s()
{
  {
    init_simple_test("BFu7i_B_BFu16s");
    static BFu7i_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu16s");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7i_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7i_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu16s(Test_BFu7i_B_BFu16s, "BFu7i_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu17i  {
  unsigned int v1:7;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 BFu7i_B_BFu17i) C1{ Fi:7 Fc Fi:17}



static void Test_BFu7i_B_BFu17i()
{
  {
    init_simple_test("BFu7i_B_BFu17i");
    static BFu7i_B_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_B_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu17i");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu7i_B_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu7i_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu17i(Test_BFu7i_B_BFu17i, "BFu7i_B_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu17ll  {
  unsigned int v1:7;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 BFu7i_B_BFu17ll) C1{ Fi:7 Fc FL:17}



static void Test_BFu7i_B_BFu17ll()
{
  {
    init_simple_test("BFu7i_B_BFu17ll");
    static BFu7i_B_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu7i_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu7i_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu17ll(Test_BFu7i_B_BFu17ll, "BFu7i_B_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu1c  {
  unsigned int v1:7;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 BFu7i_B_BFu1c) C1{ Fi:7 Fc Fc:1}



static void Test_BFu7i_B_BFu1c()
{
  {
    init_simple_test("BFu7i_B_BFu1c");
    static BFu7i_B_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu1c");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7i_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu1c(Test_BFu7i_B_BFu1c, "BFu7i_B_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu1i  {
  unsigned int v1:7;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 BFu7i_B_BFu1i) C1{ Fi:7 Fc Fi:1}



static void Test_BFu7i_B_BFu1i()
{
  {
    init_simple_test("BFu7i_B_BFu1i");
    static BFu7i_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu1i");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7i_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu1i(Test_BFu7i_B_BFu1i, "BFu7i_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu1ll  {
  unsigned int v1:7;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 BFu7i_B_BFu1ll) C1{ Fi:7 Fc FL:1}



static void Test_BFu7i_B_BFu1ll()
{
  {
    init_simple_test("BFu7i_B_BFu1ll");
    static BFu7i_B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7i_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu1ll(Test_BFu7i_B_BFu1ll, "BFu7i_B_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu1s  {
  unsigned int v1:7;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 BFu7i_B_BFu1s) C1{ Fi:7 Fc Fs:1}



static void Test_BFu7i_B_BFu1s()
{
  {
    init_simple_test("BFu7i_B_BFu1s");
    static BFu7i_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu1s");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7i_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu1s(Test_BFu7i_B_BFu1s, "BFu7i_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu31i  {
  unsigned int v1:7;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 BFu7i_B_BFu31i) C1{ Fi:7 Fc Fi:31}



static void Test_BFu7i_B_BFu31i()
{
  {
    init_simple_test("BFu7i_B_BFu31i");
    static BFu7i_B_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_B_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu31i");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu7i_B_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu7i_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu31i(Test_BFu7i_B_BFu31i, "BFu7i_B_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu31ll  {
  unsigned int v1:7;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 BFu7i_B_BFu31ll) C1{ Fi:7 Fc FL:31}



static void Test_BFu7i_B_BFu31ll()
{
  {
    init_simple_test("BFu7i_B_BFu31ll");
    static BFu7i_B_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu7i_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu7i_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu31ll(Test_BFu7i_B_BFu31ll, "BFu7i_B_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu32i  {
  unsigned int v1:7;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 BFu7i_B_BFu32i) C1{ Fi:7 Fc Fi:32}



static void Test_BFu7i_B_BFu32i()
{
  {
    init_simple_test("BFu7i_B_BFu32i");
    static BFu7i_B_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_B_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu32i");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu7i_B_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu7i_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu32i(Test_BFu7i_B_BFu32i, "BFu7i_B_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu32ll  {
  unsigned int v1:7;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 BFu7i_B_BFu32ll) C1{ Fi:7 Fc FL:32}



static void Test_BFu7i_B_BFu32ll()
{
  {
    init_simple_test("BFu7i_B_BFu32ll");
    static BFu7i_B_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu7i_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu7i_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu32ll(Test_BFu7i_B_BFu32ll, "BFu7i_B_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu33  {
  unsigned int v1:7;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 BFu7i_B_BFu33) C1{ Fi:7 Fc FL:33}



static void Test_BFu7i_B_BFu33()
{
  {
    init_simple_test("BFu7i_B_BFu33");
    static BFu7i_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu33");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu7i_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu7i_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu33(Test_BFu7i_B_BFu33, "BFu7i_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu7c  {
  unsigned int v1:7;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 BFu7i_B_BFu7c) C1{ Fi:7 Fc Fc:7}



static void Test_BFu7i_B_BFu7c()
{
  {
    init_simple_test("BFu7i_B_BFu7c");
    static BFu7i_B_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu7c");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7i_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu7c(Test_BFu7i_B_BFu7c, "BFu7i_B_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu7i  {
  unsigned int v1:7;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 BFu7i_B_BFu7i) C1{ Fi:7 Fc Fi:7}



static void Test_BFu7i_B_BFu7i()
{
  {
    init_simple_test("BFu7i_B_BFu7i");
    static BFu7i_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu7i");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7i_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu7i(Test_BFu7i_B_BFu7i, "BFu7i_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu7ll  {
  unsigned int v1:7;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 BFu7i_B_BFu7ll) C1{ Fi:7 Fc FL:7}



static void Test_BFu7i_B_BFu7ll()
{
  {
    init_simple_test("BFu7i_B_BFu7ll");
    static BFu7i_B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7i_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu7ll(Test_BFu7i_B_BFu7ll, "BFu7i_B_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu7s  {
  unsigned int v1:7;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 BFu7i_B_BFu7s) C1{ Fi:7 Fc Fs:7}



static void Test_BFu7i_B_BFu7s()
{
  {
    init_simple_test("BFu7i_B_BFu7s");
    static BFu7i_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu7s");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7i_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu7s(Test_BFu7i_B_BFu7s, "BFu7i_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu8c  {
  unsigned int v1:7;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 BFu7i_B_BFu8c) C1{ Fi:7 Fc Fc:8}



static void Test_BFu7i_B_BFu8c()
{
  {
    init_simple_test("BFu7i_B_BFu8c");
    static BFu7i_B_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu8c");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7i_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7i_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu8c(Test_BFu7i_B_BFu8c, "BFu7i_B_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu8i  {
  unsigned int v1:7;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 BFu7i_B_BFu8i) C1{ Fi:7 Fc Fi:8}



static void Test_BFu7i_B_BFu8i()
{
  {
    init_simple_test("BFu7i_B_BFu8i");
    static BFu7i_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu8i");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7i_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7i_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu8i(Test_BFu7i_B_BFu8i, "BFu7i_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu8ll  {
  unsigned int v1:7;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 BFu7i_B_BFu8ll) C1{ Fi:7 Fc FL:8}



static void Test_BFu7i_B_BFu8ll()
{
  {
    init_simple_test("BFu7i_B_BFu8ll");
    static BFu7i_B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7i_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7i_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu8ll(Test_BFu7i_B_BFu8ll, "BFu7i_B_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu8s  {
  unsigned int v1:7;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 BFu7i_B_BFu8s) C1{ Fi:7 Fc Fs:8}



static void Test_BFu7i_B_BFu8s()
{
  {
    init_simple_test("BFu7i_B_BFu8s");
    static BFu7i_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu8s");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7i_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7i_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu8s(Test_BFu7i_B_BFu8s, "BFu7i_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu9i  {
  unsigned int v1:7;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 BFu7i_B_BFu9i) C1{ Fi:7 Fc Fi:9}



static void Test_BFu7i_B_BFu9i()
{
  {
    init_simple_test("BFu7i_B_BFu9i");
    static BFu7i_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu9i");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7i_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7i_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu9i(Test_BFu7i_B_BFu9i, "BFu7i_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu9ll  {
  unsigned int v1:7;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 BFu7i_B_BFu9ll) C1{ Fi:7 Fc FL:9}



static void Test_BFu7i_B_BFu9ll()
{
  {
    init_simple_test("BFu7i_B_BFu9ll");
    static BFu7i_B_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7i_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7i_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu9ll(Test_BFu7i_B_BFu9ll, "BFu7i_B_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_BFu9s  {
  unsigned int v1:7;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 BFu7i_B_BFu9s) C1{ Fi:7 Fc Fs:9}



static void Test_BFu7i_B_BFu9s()
{
  {
    init_simple_test("BFu7i_B_BFu9s");
    static BFu7i_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_BFu9s");
    check_field_offset(lv, v2, 1, "BFu7i_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7i_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7i_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu7i_B_BFu9s(Test_BFu7i_B_BFu9s, "BFu7i_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_C  {
  unsigned int v1:7;
  bool v2;
  char v3;
};
//SIG(1 BFu7i_B_C) C1{ Fi:7 Fc[2]}



static void Test_BFu7i_B_C()
{
  {
    init_simple_test("BFu7i_B_C");
    static BFu7i_B_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_C");
    check_field_offset(lv, v2, 1, "BFu7i_B_C.v2");
    check_field_offset(lv, v3, 2, "BFu7i_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_B_C(Test_BFu7i_B_C, "BFu7i_B_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_D  {
  unsigned int v1:7;
  bool v2;
  double v3;
};
//SIG(1 BFu7i_B_D) C1{ Fi:7 Fc FL}



static void Test_BFu7i_B_D()
{
  {
    init_simple_test("BFu7i_B_D");
    static BFu7i_B_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_D");
    check_field_offset(lv, v2, 1, "BFu7i_B_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7i_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_B_D(Test_BFu7i_B_D, "BFu7i_B_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_F  {
  unsigned int v1:7;
  bool v2;
  float v3;
};
//SIG(1 BFu7i_B_F) C1{ Fi:7 Fc Fi}



static void Test_BFu7i_B_F()
{
  {
    init_simple_test("BFu7i_B_F");
    static BFu7i_B_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_B_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_F");
    check_field_offset(lv, v2, 1, "BFu7i_B_F.v2");
    check_field_offset(lv, v3, 4, "BFu7i_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_B_F(Test_BFu7i_B_F, "BFu7i_B_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_I  {
  unsigned int v1:7;
  bool v2;
  int v3;
};
//SIG(1 BFu7i_B_I) C1{ Fi:7 Fc Fi}



static void Test_BFu7i_B_I()
{
  {
    init_simple_test("BFu7i_B_I");
    static BFu7i_B_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_B_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_I");
    check_field_offset(lv, v2, 1, "BFu7i_B_I.v2");
    check_field_offset(lv, v3, 4, "BFu7i_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_B_I(Test_BFu7i_B_I, "BFu7i_B_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_Ip  {
  unsigned int v1:7;
  bool v2;
  int *v3;
};
//SIG(1 BFu7i_B_Ip) C1{ Fi:7 Fc Fp}



static void Test_BFu7i_B_Ip()
{
  {
    init_simple_test("BFu7i_B_Ip");
    static BFu7i_B_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_Ip");
    check_field_offset(lv, v2, 1, "BFu7i_B_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7i_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_B_Ip(Test_BFu7i_B_Ip, "BFu7i_B_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_L  {
  unsigned int v1:7;
  bool v2;
  __tsi64 v3;
};
//SIG(1 BFu7i_B_L) C1{ Fi:7 Fc FL}



static void Test_BFu7i_B_L()
{
  {
    init_simple_test("BFu7i_B_L");
    static BFu7i_B_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_L");
    check_field_offset(lv, v2, 1, "BFu7i_B_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7i_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_B_L(Test_BFu7i_B_L, "BFu7i_B_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_S  {
  unsigned int v1:7;
  bool v2;
  short v3;
};
//SIG(1 BFu7i_B_S) C1{ Fi:7 Fc Fs}



static void Test_BFu7i_B_S()
{
  {
    init_simple_test("BFu7i_B_S");
    static BFu7i_B_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_S");
    check_field_offset(lv, v2, 1, "BFu7i_B_S.v2");
    check_field_offset(lv, v3, 2, "BFu7i_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_B_S(Test_BFu7i_B_S, "BFu7i_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_Uc  {
  unsigned int v1:7;
  bool v2;
  unsigned char v3;
};
//SIG(1 BFu7i_B_Uc) C1{ Fi:7 Fc[2]}



static void Test_BFu7i_B_Uc()
{
  {
    init_simple_test("BFu7i_B_Uc");
    static BFu7i_B_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_Uc");
    check_field_offset(lv, v2, 1, "BFu7i_B_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu7i_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_B_Uc(Test_BFu7i_B_Uc, "BFu7i_B_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_Ui  {
  unsigned int v1:7;
  bool v2;
  unsigned int v3;
};
//SIG(1 BFu7i_B_Ui) C1{ Fi:7 Fc Fi}



static void Test_BFu7i_B_Ui()
{
  {
    init_simple_test("BFu7i_B_Ui");
    static BFu7i_B_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_B_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_Ui");
    check_field_offset(lv, v2, 1, "BFu7i_B_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu7i_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_B_Ui(Test_BFu7i_B_Ui, "BFu7i_B_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_Ul  {
  unsigned int v1:7;
  bool v2;
  __tsu64 v3;
};
//SIG(1 BFu7i_B_Ul) C1{ Fi:7 Fc FL}



static void Test_BFu7i_B_Ul()
{
  {
    init_simple_test("BFu7i_B_Ul");
    static BFu7i_B_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7i_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_Ul");
    check_field_offset(lv, v2, 1, "BFu7i_B_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7i_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_B_Ul(Test_BFu7i_B_Ul, "BFu7i_B_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_Us  {
  unsigned int v1:7;
  bool v2;
  unsigned short v3;
};
//SIG(1 BFu7i_B_Us) C1{ Fi:7 Fc Fs}



static void Test_BFu7i_B_Us()
{
  {
    init_simple_test("BFu7i_B_Us");
    static BFu7i_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_B_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_Us");
    check_field_offset(lv, v2, 1, "BFu7i_B_Us.v2");
    check_field_offset(lv, v3, 2, "BFu7i_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_B_Us(Test_BFu7i_B_Us, "BFu7i_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_B_Vp  {
  unsigned int v1:7;
  bool v2;
  void *v3;
};
//SIG(1 BFu7i_B_Vp) C1{ Fi:7 Fc Fp}



static void Test_BFu7i_B_Vp()
{
  {
    init_simple_test("BFu7i_B_Vp");
    static BFu7i_B_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7i_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_B_Vp");
    check_field_offset(lv, v2, 1, "BFu7i_B_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7i_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_B_Vp(Test_BFu7i_B_Vp, "BFu7i_B_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu15i_B  {
  unsigned int v1:7;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 BFu7i_BFu15i_B) C1{ Fi:7 Fi:15 Fc}



static void Test_BFu7i_BFu15i_B()
{
  {
    init_simple_test("BFu7i_BFu15i_B");
    static BFu7i_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu15i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15i_B");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu15i_B(Test_BFu7i_BFu15i_B, "BFu7i_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu15ll_B  {
  unsigned int v1:7;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 BFu7i_BFu15ll_B) C1{ Fi:7 FL:15 Fc}



static void Test_BFu7i_BFu15ll_B()
{
  {
    init_simple_test("BFu7i_BFu15ll_B");
    static BFu7i_BFu15ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7i_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7i_BFu15ll_B");
    check_field_offset(lv, v3, 3, "BFu7i_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu15ll_B(Test_BFu7i_BFu15ll_B, "BFu7i_BFu15ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu15s_B  {
  unsigned int v1:7;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 BFu7i_BFu15s_B) C1{ Fi:7 Fs:15 Fc}



static void Test_BFu7i_BFu15s_B()
{
  {
    init_simple_test("BFu7i_BFu15s_B");
    static BFu7i_BFu15s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu15s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7i_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7i_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu7i_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu15s_B(Test_BFu7i_BFu15s_B, "BFu7i_BFu15s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu16i_B  {
  unsigned int v1:7;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 BFu7i_BFu16i_B) C1{ Fi:7 Fi:16 Fc}



static void Test_BFu7i_BFu16i_B()
{
  {
    init_simple_test("BFu7i_BFu16i_B");
    static BFu7i_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu16i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16i_B");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu16i_B(Test_BFu7i_BFu16i_B, "BFu7i_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu16ll_B  {
  unsigned int v1:7;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 BFu7i_BFu16ll_B) C1{ Fi:7 FL:16 Fc}



static void Test_BFu7i_BFu16ll_B()
{
  {
    init_simple_test("BFu7i_BFu16ll_B");
    static BFu7i_BFu16ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7i_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7i_BFu16ll_B");
    check_field_offset(lv, v3, 3, "BFu7i_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu16ll_B(Test_BFu7i_BFu16ll_B, "BFu7i_BFu16ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu16s_B  {
  unsigned int v1:7;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 BFu7i_BFu16s_B) C1{ Fi:7 Fs:16 Fc}



static void Test_BFu7i_BFu16s_B()
{
  {
    init_simple_test("BFu7i_BFu16s_B");
    static BFu7i_BFu16s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu16s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7i_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7i_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu7i_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu16s_B(Test_BFu7i_BFu16s_B, "BFu7i_BFu16s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu17i_B  {
  unsigned int v1:7;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 BFu7i_BFu17i_B) C1{ Fi:7 Fi:17 Fc}



static void Test_BFu7i_BFu17i_B()
{
  {
    init_simple_test("BFu7i_BFu17i_B");
    static BFu7i_BFu17i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu17i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17i_B");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu17i_B(Test_BFu7i_BFu17i_B, "BFu7i_BFu17i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu17ll_B  {
  unsigned int v1:7;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 BFu7i_BFu17ll_B) C1{ Fi:7 FL:17 Fc}



static void Test_BFu7i_BFu17ll_B()
{
  {
    init_simple_test("BFu7i_BFu17ll_B");
    static BFu7i_BFu17ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7i_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7i_BFu17ll_B");
    check_field_offset(lv, v3, 3, "BFu7i_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu17ll_B(Test_BFu7i_BFu17ll_B, "BFu7i_BFu17ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu1c_B  {
  unsigned int v1:7;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 BFu7i_BFu1c_B) C1{ Fi:7 Fc:1 Fc}



static void Test_BFu7i_BFu1c_B()
{
  {
    init_simple_test("BFu7i_BFu1c_B");
    static BFu7i_BFu1c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu1c_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1c_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1c_B");
    check_field_offset(lv, v3, 1, "BFu7i_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu1c_B(Test_BFu7i_BFu1c_B, "BFu7i_BFu1c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu1i_B  {
  unsigned int v1:7;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 BFu7i_BFu1i_B) C1{ Fi:7 Fi:1 Fc}



static void Test_BFu7i_BFu1i_B()
{
  {
    init_simple_test("BFu7i_BFu1i_B");
    static BFu7i_BFu1i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu1i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1i_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1i_B");
    check_field_offset(lv, v3, 1, "BFu7i_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu1i_B(Test_BFu7i_BFu1i_B, "BFu7i_BFu1i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu1ll_B  {
  unsigned int v1:7;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 BFu7i_BFu1ll_B) C1{ Fi:7 FL:1 Fc}



static void Test_BFu7i_BFu1ll_B()
{
  {
    init_simple_test("BFu7i_BFu1ll_B");
    static BFu7i_BFu1ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1ll_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1ll_B");
    check_field_offset(lv, v3, 1, "BFu7i_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu1ll_B(Test_BFu7i_BFu1ll_B, "BFu7i_BFu1ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu1s_B  {
  unsigned int v1:7;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 BFu7i_BFu1s_B) C1{ Fi:7 Fs:1 Fc}



static void Test_BFu7i_BFu1s_B()
{
  {
    init_simple_test("BFu7i_BFu1s_B");
    static BFu7i_BFu1s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu1s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu1s_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7i_BFu1s_B");
    check_field_offset(lv, v3, 1, "BFu7i_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu1s_B(Test_BFu7i_BFu1s_B, "BFu7i_BFu1s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu31i_B  {
  unsigned int v1:7;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 BFu7i_BFu31i_B) C1{ Fi:7 Fi:31 Fc}



static void Test_BFu7i_BFu31i_B()
{
  {
    init_simple_test("BFu7i_BFu31i_B");
    static BFu7i_BFu31i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7i_BFu31i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7i_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7i_BFu31i_B");
    check_field_offset(lv, v3, 8, "BFu7i_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu31i_B(Test_BFu7i_BFu31i_B, "BFu7i_BFu31i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu31ll_B  {
  unsigned int v1:7;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 BFu7i_BFu31ll_B) C1{ Fi:7 FL:31 Fc}



static void Test_BFu7i_BFu31ll_B()
{
  {
    init_simple_test("BFu7i_BFu31ll_B");
    static BFu7i_BFu31ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7i_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7i_BFu31ll_B");
    check_field_offset(lv, v3, 5, "BFu7i_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu31ll_B(Test_BFu7i_BFu31ll_B, "BFu7i_BFu31ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu32i_B  {
  unsigned int v1:7;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 BFu7i_BFu32i_B) C1{ Fi:7 Fi:32 Fc}



static void Test_BFu7i_BFu32i_B()
{
  {
    init_simple_test("BFu7i_BFu32i_B");
    static BFu7i_BFu32i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7i_BFu32i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7i_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7i_BFu32i_B");
    check_field_offset(lv, v3, 8, "BFu7i_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu32i_B(Test_BFu7i_BFu32i_B, "BFu7i_BFu32i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu32ll_B  {
  unsigned int v1:7;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 BFu7i_BFu32ll_B) C1{ Fi:7 FL:32 Fc}



static void Test_BFu7i_BFu32ll_B()
{
  {
    init_simple_test("BFu7i_BFu32ll_B");
    static BFu7i_BFu32ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7i_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7i_BFu32ll_B");
    check_field_offset(lv, v3, 5, "BFu7i_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu32ll_B(Test_BFu7i_BFu32ll_B, "BFu7i_BFu32ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu33_B  {
  unsigned int v1:7;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 BFu7i_BFu33_B) C1{ Fi:7 FL:33 Fc}



static void Test_BFu7i_BFu33_B()
{
  {
    init_simple_test("BFu7i_BFu33_B");
    static BFu7i_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7i_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7i_BFu33_B");
    check_field_offset(lv, v3, 5, "BFu7i_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu33_B(Test_BFu7i_BFu33_B, "BFu7i_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu7c_B  {
  unsigned int v1:7;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 BFu7i_BFu7c_B) C1{ Fi:7 Fc:7 Fc}



static void Test_BFu7i_BFu7c_B()
{
  {
    init_simple_test("BFu7i_BFu7c_B");
    static BFu7i_BFu7c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu7c_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7i_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7c_B");
    check_field_offset(lv, v3, 2, "BFu7i_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu7c_B(Test_BFu7i_BFu7c_B, "BFu7i_BFu7c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu7i_B  {
  unsigned int v1:7;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 BFu7i_BFu7i_B) C1{ Fi:7 Fi:7 Fc}



static void Test_BFu7i_BFu7i_B()
{
  {
    init_simple_test("BFu7i_BFu7i_B");
    static BFu7i_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu7i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7i_B");
    check_field_offset(lv, v3, 2, "BFu7i_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu7i_B(Test_BFu7i_BFu7i_B, "BFu7i_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu7ll_B  {
  unsigned int v1:7;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 BFu7i_BFu7ll_B) C1{ Fi:7 FL:7 Fc}



static void Test_BFu7i_BFu7ll_B()
{
  {
    init_simple_test("BFu7i_BFu7ll_B");
    static BFu7i_BFu7ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7ll_B");
    check_field_offset(lv, v3, 2, "BFu7i_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu7ll_B(Test_BFu7i_BFu7ll_B, "BFu7i_BFu7ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu7s_B  {
  unsigned int v1:7;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 BFu7i_BFu7s_B) C1{ Fi:7 Fs:7 Fc}



static void Test_BFu7i_BFu7s_B()
{
  {
    init_simple_test("BFu7i_BFu7s_B");
    static BFu7i_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu7s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7i_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7i_BFu7s_B");
    check_field_offset(lv, v3, 2, "BFu7i_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu7s_B(Test_BFu7i_BFu7s_B, "BFu7i_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu8c_B  {
  unsigned int v1:7;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 BFu7i_BFu8c_B) C1{ Fi:7 Fc:8 Fc}



static void Test_BFu7i_BFu8c_B()
{
  {
    init_simple_test("BFu7i_BFu8c_B");
    static BFu7i_BFu8c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu8c_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7i_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7i_BFu8c_B");
    check_field_offset(lv, v3, 2, "BFu7i_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu8c_B(Test_BFu7i_BFu8c_B, "BFu7i_BFu8c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu8i_B  {
  unsigned int v1:7;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 BFu7i_BFu8i_B) C1{ Fi:7 Fi:8 Fc}



static void Test_BFu7i_BFu8i_B()
{
  {
    init_simple_test("BFu7i_BFu8i_B");
    static BFu7i_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu8i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8i_B");
    check_field_offset(lv, v3, 2, "BFu7i_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu8i_B(Test_BFu7i_BFu8i_B, "BFu7i_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu8ll_B  {
  unsigned int v1:7;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 BFu7i_BFu8ll_B) C1{ Fi:7 FL:8 Fc}



static void Test_BFu7i_BFu8ll_B()
{
  {
    init_simple_test("BFu7i_BFu8ll_B");
    static BFu7i_BFu8ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8ll_B");
    check_field_offset(lv, v3, 2, "BFu7i_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu8ll_B(Test_BFu7i_BFu8ll_B, "BFu7i_BFu8ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu8s_B  {
  unsigned int v1:7;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 BFu7i_BFu8s_B) C1{ Fi:7 Fs:8 Fc}



static void Test_BFu7i_BFu8s_B()
{
  {
    init_simple_test("BFu7i_BFu8s_B");
    static BFu7i_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu8s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7i_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7i_BFu8s_B");
    check_field_offset(lv, v3, 2, "BFu7i_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu8s_B(Test_BFu7i_BFu8s_B, "BFu7i_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu9i_B  {
  unsigned int v1:7;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 BFu7i_BFu9i_B) C1{ Fi:7 Fi:9 Fc}



static void Test_BFu7i_BFu9i_B()
{
  {
    init_simple_test("BFu7i_BFu9i_B");
    static BFu7i_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu9i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9i_B");
    check_field_offset(lv, v3, 2, "BFu7i_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu9i_B(Test_BFu7i_BFu9i_B, "BFu7i_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu9ll_B  {
  unsigned int v1:7;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 BFu7i_BFu9ll_B) C1{ Fi:7 FL:9 Fc}



static void Test_BFu7i_BFu9ll_B()
{
  {
    init_simple_test("BFu7i_BFu9ll_B");
    static BFu7i_BFu9ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7i_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9ll_B");
    check_field_offset(lv, v3, 2, "BFu7i_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu9ll_B(Test_BFu7i_BFu9ll_B, "BFu7i_BFu9ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_BFu9s_B  {
  unsigned int v1:7;
  unsigned short v2:9;
  bool v3;
};
//SIG(1 BFu7i_BFu9s_B) C1{ Fi:7 Fs:9 Fc}



static void Test_BFu7i_BFu9s_B()
{
  {
    init_simple_test("BFu7i_BFu9s_B");
    static BFu7i_BFu9s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_BFu9s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7i_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7i_BFu9s_B");
    check_field_offset(lv, v3, 2, "BFu7i_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_BFu9s_B(Test_BFu7i_BFu9s_B, "BFu7i_BFu9s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_C_B  {
  unsigned int v1:7;
  char v2;
  bool v3;
};
//SIG(1 BFu7i_C_B) C1{ Fi:7 Fc[2]}



static void Test_BFu7i_C_B()
{
  {
    init_simple_test("BFu7i_C_B");
    static BFu7i_C_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_C_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_C_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_C_B");
    check_field_offset(lv, v2, 1, "BFu7i_C_B.v2");
    check_field_offset(lv, v3, 2, "BFu7i_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_C_B(Test_BFu7i_C_B, "BFu7i_C_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_D_B  {
  unsigned int v1:7;
  double v2;
  bool v3;
};
//SIG(1 BFu7i_D_B) C1{ Fi:7 FL Fc}



static void Test_BFu7i_D_B()
{
  {
    init_simple_test("BFu7i_D_B");
    static BFu7i_D_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu7i_D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_D_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_D_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_D_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu7i_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_D_B(Test_BFu7i_D_B, "BFu7i_D_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_F_B  {
  unsigned int v1:7;
  float v2;
  bool v3;
};
//SIG(1 BFu7i_F_B) C1{ Fi:7 Fi Fc}



static void Test_BFu7i_F_B()
{
  {
    init_simple_test("BFu7i_F_B");
    static BFu7i_F_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7i_F_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_F_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_F_B");
    check_field_offset(lv, v2, 4, "BFu7i_F_B.v2");
    check_field_offset(lv, v3, 8, "BFu7i_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_F_B(Test_BFu7i_F_B, "BFu7i_F_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_I_B  {
  unsigned int v1:7;
  int v2;
  bool v3;
};
//SIG(1 BFu7i_I_B) C1{ Fi:7 Fi Fc}



static void Test_BFu7i_I_B()
{
  {
    init_simple_test("BFu7i_I_B");
    static BFu7i_I_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7i_I_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_I_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_I_B");
    check_field_offset(lv, v2, 4, "BFu7i_I_B.v2");
    check_field_offset(lv, v3, 8, "BFu7i_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_I_B(Test_BFu7i_I_B, "BFu7i_I_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_Ip_B  {
  unsigned int v1:7;
  int *v2;
  bool v3;
};
//SIG(1 BFu7i_Ip_B) C1{ Fi:7 Fp Fc}



static void Test_BFu7i_Ip_B()
{
  {
    init_simple_test("BFu7i_Ip_B");
    static BFu7i_Ip_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu7i_Ip_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ip_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu7i_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_Ip_B(Test_BFu7i_Ip_B, "BFu7i_Ip_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_L_B  {
  unsigned int v1:7;
  __tsi64 v2;
  bool v3;
};
//SIG(1 BFu7i_L_B) C1{ Fi:7 FL Fc}



static void Test_BFu7i_L_B()
{
  {
    init_simple_test("BFu7i_L_B");
    static BFu7i_L_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu7i_L_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_L_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_L_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_L_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu7i_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_L_B(Test_BFu7i_L_B, "BFu7i_L_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_S_B  {
  unsigned int v1:7;
  short v2;
  bool v3;
};
//SIG(1 BFu7i_S_B) C1{ Fi:7 Fs Fc}



static void Test_BFu7i_S_B()
{
  {
    init_simple_test("BFu7i_S_B");
    static BFu7i_S_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_S_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_S_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_S_B");
    check_field_offset(lv, v2, 2, "BFu7i_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu7i_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_S_B(Test_BFu7i_S_B, "BFu7i_S_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_Uc_B  {
  unsigned int v1:7;
  unsigned char v2;
  bool v3;
};
//SIG(1 BFu7i_Uc_B) C1{ Fi:7 Fc[2]}



static void Test_BFu7i_Uc_B()
{
  {
    init_simple_test("BFu7i_Uc_B");
    static BFu7i_Uc_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7i_Uc_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Uc_B");
    check_field_offset(lv, v2, 1, "BFu7i_Uc_B.v2");
    check_field_offset(lv, v3, 2, "BFu7i_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_Uc_B(Test_BFu7i_Uc_B, "BFu7i_Uc_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_Ui_B  {
  unsigned int v1:7;
  unsigned int v2;
  bool v3;
};
//SIG(1 BFu7i_Ui_B) C1{ Fi:7 Fi Fc}



static void Test_BFu7i_Ui_B()
{
  {
    init_simple_test("BFu7i_Ui_B");
    static BFu7i_Ui_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7i_Ui_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ui_B");
    check_field_offset(lv, v2, 4, "BFu7i_Ui_B.v2");
    check_field_offset(lv, v3, 8, "BFu7i_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_Ui_B(Test_BFu7i_Ui_B, "BFu7i_Ui_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_Ul_B  {
  unsigned int v1:7;
  __tsu64 v2;
  bool v3;
};
//SIG(1 BFu7i_Ul_B) C1{ Fi:7 FL Fc}



static void Test_BFu7i_Ul_B()
{
  {
    init_simple_test("BFu7i_Ul_B");
    static BFu7i_Ul_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu7i_Ul_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Ul_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Ul_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu7i_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_Ul_B(Test_BFu7i_Ul_B, "BFu7i_Ul_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_Us_B  {
  unsigned int v1:7;
  unsigned short v2;
  bool v3;
};
//SIG(1 BFu7i_Us_B) C1{ Fi:7 Fs Fc}



static void Test_BFu7i_Us_B()
{
  {
    init_simple_test("BFu7i_Us_B");
    static BFu7i_Us_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7i_Us_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7i_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Us_B");
    check_field_offset(lv, v2, 2, "BFu7i_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu7i_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_Us_B(Test_BFu7i_Us_B, "BFu7i_Us_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7i_Vp_B  {
  unsigned int v1:7;
  void *v2;
  bool v3;
};
//SIG(1 BFu7i_Vp_B) C1{ Fi:7 Fp Fc}



static void Test_BFu7i_Vp_B()
{
  {
    init_simple_test("BFu7i_Vp_B");
    static BFu7i_Vp_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu7i_Vp_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7i_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7i_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7i_Vp_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7i_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu7i_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7i_Vp_B(Test_BFu7i_Vp_B, "BFu7i_Vp_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B  {
  __tsu64 v1:7;
  bool v2;
};
//SIG(1 BFu7ll_B) C1{ FL:7 Fc}



static void Test_BFu7ll_B()
{
  {
    init_simple_test("BFu7ll_B");
    static BFu7ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B");
    check_field_offset(lv, v2, 1, "BFu7ll_B.v2");
  }
}
static Arrange_To_Call_Me vBFu7ll_B(Test_BFu7ll_B, "BFu7ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_B  {
  __tsu64 v1:7;
  bool v2;
  bool v3;
};
//SIG(1 BFu7ll_B_B) C1{ FL:7 Fc[2]}



static void Test_BFu7ll_B_B()
{
  {
    init_simple_test("BFu7ll_B_B");
    static BFu7ll_B_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_B");
    check_field_offset(lv, v2, 1, "BFu7ll_B_B.v2");
    check_field_offset(lv, v3, 2, "BFu7ll_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_B(Test_BFu7ll_B_B, "BFu7ll_B_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu15i  {
  __tsu64 v1:7;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 BFu7ll_B_BFu15i) C1{ FL:7 Fc Fi:15}



static void Test_BFu7ll_B_BFu15i()
{
  {
    init_simple_test("BFu7ll_B_BFu15i");
    static BFu7ll_B_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu15i");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7ll_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7ll_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu15i(Test_BFu7ll_B_BFu15i, "BFu7ll_B_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu15ll  {
  __tsu64 v1:7;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 BFu7ll_B_BFu15ll) C1{ FL:7 Fc FL:15}



static void Test_BFu7ll_B_BFu15ll()
{
  {
    init_simple_test("BFu7ll_B_BFu15ll");
    static BFu7ll_B_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7ll_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7ll_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu15ll(Test_BFu7ll_B_BFu15ll, "BFu7ll_B_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu15s  {
  __tsu64 v1:7;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 BFu7ll_B_BFu15s) C1{ FL:7 Fc Fs:15}



static void Test_BFu7ll_B_BFu15s()
{
  {
    init_simple_test("BFu7ll_B_BFu15s");
    static BFu7ll_B_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu15s");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7ll_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7ll_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu15s(Test_BFu7ll_B_BFu15s, "BFu7ll_B_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu16i  {
  __tsu64 v1:7;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 BFu7ll_B_BFu16i) C1{ FL:7 Fc Fi:16}



static void Test_BFu7ll_B_BFu16i()
{
  {
    init_simple_test("BFu7ll_B_BFu16i");
    static BFu7ll_B_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu16i");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7ll_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7ll_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu16i(Test_BFu7ll_B_BFu16i, "BFu7ll_B_BFu16i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu16ll  {
  __tsu64 v1:7;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 BFu7ll_B_BFu16ll) C1{ FL:7 Fc FL:16}



static void Test_BFu7ll_B_BFu16ll()
{
  {
    init_simple_test("BFu7ll_B_BFu16ll");
    static BFu7ll_B_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7ll_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7ll_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu16ll(Test_BFu7ll_B_BFu16ll, "BFu7ll_B_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu16s  {
  __tsu64 v1:7;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 BFu7ll_B_BFu16s) C1{ FL:7 Fc Fs:16}



static void Test_BFu7ll_B_BFu16s()
{
  {
    init_simple_test("BFu7ll_B_BFu16s");
    static BFu7ll_B_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu16s");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7ll_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7ll_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu16s(Test_BFu7ll_B_BFu16s, "BFu7ll_B_BFu16s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu17i  {
  __tsu64 v1:7;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 BFu7ll_B_BFu17i) C1{ FL:7 Fc Fi:17}



static void Test_BFu7ll_B_BFu17i()
{
  {
    init_simple_test("BFu7ll_B_BFu17i");
    static BFu7ll_B_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_B_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu17i");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu7ll_B_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu7ll_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu17i(Test_BFu7ll_B_BFu17i, "BFu7ll_B_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu17ll  {
  __tsu64 v1:7;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 BFu7ll_B_BFu17ll) C1{ FL:7 Fc FL:17}



static void Test_BFu7ll_B_BFu17ll()
{
  {
    init_simple_test("BFu7ll_B_BFu17ll");
    static BFu7ll_B_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu7ll_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu7ll_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu17ll(Test_BFu7ll_B_BFu17ll, "BFu7ll_B_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu1c  {
  __tsu64 v1:7;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 BFu7ll_B_BFu1c) C1{ FL:7 Fc Fc:1}



static void Test_BFu7ll_B_BFu1c()
{
  {
    init_simple_test("BFu7ll_B_BFu1c");
    static BFu7ll_B_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu1c");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7ll_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu1c(Test_BFu7ll_B_BFu1c, "BFu7ll_B_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu1i  {
  __tsu64 v1:7;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 BFu7ll_B_BFu1i) C1{ FL:7 Fc Fi:1}



static void Test_BFu7ll_B_BFu1i()
{
  {
    init_simple_test("BFu7ll_B_BFu1i");
    static BFu7ll_B_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu1i");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7ll_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu1i(Test_BFu7ll_B_BFu1i, "BFu7ll_B_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu1ll  {
  __tsu64 v1:7;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 BFu7ll_B_BFu1ll) C1{ FL:7 Fc FL:1}



static void Test_BFu7ll_B_BFu1ll()
{
  {
    init_simple_test("BFu7ll_B_BFu1ll");
    static BFu7ll_B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7ll_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu1ll(Test_BFu7ll_B_BFu1ll, "BFu7ll_B_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu1s  {
  __tsu64 v1:7;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 BFu7ll_B_BFu1s) C1{ FL:7 Fc Fs:1}



static void Test_BFu7ll_B_BFu1s()
{
  {
    init_simple_test("BFu7ll_B_BFu1s");
    static BFu7ll_B_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu1s");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7ll_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu1s(Test_BFu7ll_B_BFu1s, "BFu7ll_B_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu31i  {
  __tsu64 v1:7;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 BFu7ll_B_BFu31i) C1{ FL:7 Fc Fi:31}



static void Test_BFu7ll_B_BFu31i()
{
  {
    init_simple_test("BFu7ll_B_BFu31i");
    static BFu7ll_B_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_B_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu31i");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu7ll_B_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu7ll_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu31i(Test_BFu7ll_B_BFu31i, "BFu7ll_B_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu31ll  {
  __tsu64 v1:7;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 BFu7ll_B_BFu31ll) C1{ FL:7 Fc FL:31}



static void Test_BFu7ll_B_BFu31ll()
{
  {
    init_simple_test("BFu7ll_B_BFu31ll");
    static BFu7ll_B_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu7ll_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu7ll_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu31ll(Test_BFu7ll_B_BFu31ll, "BFu7ll_B_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu32i  {
  __tsu64 v1:7;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 BFu7ll_B_BFu32i) C1{ FL:7 Fc Fi:32}



static void Test_BFu7ll_B_BFu32i()
{
  {
    init_simple_test("BFu7ll_B_BFu32i");
    static BFu7ll_B_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_B_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu32i");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu7ll_B_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu7ll_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu32i(Test_BFu7ll_B_BFu32i, "BFu7ll_B_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu32ll  {
  __tsu64 v1:7;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 BFu7ll_B_BFu32ll) C1{ FL:7 Fc FL:32}



static void Test_BFu7ll_B_BFu32ll()
{
  {
    init_simple_test("BFu7ll_B_BFu32ll");
    static BFu7ll_B_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu7ll_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu7ll_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu32ll(Test_BFu7ll_B_BFu32ll, "BFu7ll_B_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu33  {
  __tsu64 v1:7;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 BFu7ll_B_BFu33) C1{ FL:7 Fc FL:33}



static void Test_BFu7ll_B_BFu33()
{
  {
    init_simple_test("BFu7ll_B_BFu33");
    static BFu7ll_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu33");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu7ll_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu7ll_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu33(Test_BFu7ll_B_BFu33, "BFu7ll_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu7c  {
  __tsu64 v1:7;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 BFu7ll_B_BFu7c) C1{ FL:7 Fc Fc:7}



static void Test_BFu7ll_B_BFu7c()
{
  {
    init_simple_test("BFu7ll_B_BFu7c");
    static BFu7ll_B_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu7c");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7ll_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu7c(Test_BFu7ll_B_BFu7c, "BFu7ll_B_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu7i  {
  __tsu64 v1:7;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 BFu7ll_B_BFu7i) C1{ FL:7 Fc Fi:7}



static void Test_BFu7ll_B_BFu7i()
{
  {
    init_simple_test("BFu7ll_B_BFu7i");
    static BFu7ll_B_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu7i");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7ll_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu7i(Test_BFu7ll_B_BFu7i, "BFu7ll_B_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu7ll  {
  __tsu64 v1:7;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 BFu7ll_B_BFu7ll) C1{ FL:7 Fc FL:7}



static void Test_BFu7ll_B_BFu7ll()
{
  {
    init_simple_test("BFu7ll_B_BFu7ll");
    static BFu7ll_B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7ll_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu7ll(Test_BFu7ll_B_BFu7ll, "BFu7ll_B_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu7s  {
  __tsu64 v1:7;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 BFu7ll_B_BFu7s) C1{ FL:7 Fc Fs:7}



static void Test_BFu7ll_B_BFu7s()
{
  {
    init_simple_test("BFu7ll_B_BFu7s");
    static BFu7ll_B_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu7s");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7ll_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu7s(Test_BFu7ll_B_BFu7s, "BFu7ll_B_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu8c  {
  __tsu64 v1:7;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 BFu7ll_B_BFu8c) C1{ FL:7 Fc Fc:8}



static void Test_BFu7ll_B_BFu8c()
{
  {
    init_simple_test("BFu7ll_B_BFu8c");
    static BFu7ll_B_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu8c");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7ll_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7ll_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu8c(Test_BFu7ll_B_BFu8c, "BFu7ll_B_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu8i  {
  __tsu64 v1:7;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 BFu7ll_B_BFu8i) C1{ FL:7 Fc Fi:8}



static void Test_BFu7ll_B_BFu8i()
{
  {
    init_simple_test("BFu7ll_B_BFu8i");
    static BFu7ll_B_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu8i");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7ll_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7ll_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu8i(Test_BFu7ll_B_BFu8i, "BFu7ll_B_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu8ll  {
  __tsu64 v1:7;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 BFu7ll_B_BFu8ll) C1{ FL:7 Fc FL:8}



static void Test_BFu7ll_B_BFu8ll()
{
  {
    init_simple_test("BFu7ll_B_BFu8ll");
    static BFu7ll_B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7ll_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7ll_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu8ll(Test_BFu7ll_B_BFu8ll, "BFu7ll_B_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu8s  {
  __tsu64 v1:7;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 BFu7ll_B_BFu8s) C1{ FL:7 Fc Fs:8}



static void Test_BFu7ll_B_BFu8s()
{
  {
    init_simple_test("BFu7ll_B_BFu8s");
    static BFu7ll_B_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu8s");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7ll_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7ll_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu8s(Test_BFu7ll_B_BFu8s, "BFu7ll_B_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu9i  {
  __tsu64 v1:7;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 BFu7ll_B_BFu9i) C1{ FL:7 Fc Fi:9}



static void Test_BFu7ll_B_BFu9i()
{
  {
    init_simple_test("BFu7ll_B_BFu9i");
    static BFu7ll_B_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu9i");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7ll_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7ll_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu9i(Test_BFu7ll_B_BFu9i, "BFu7ll_B_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu9ll  {
  __tsu64 v1:7;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 BFu7ll_B_BFu9ll) C1{ FL:7 Fc FL:9}



static void Test_BFu7ll_B_BFu9ll()
{
  {
    init_simple_test("BFu7ll_B_BFu9ll");
    static BFu7ll_B_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7ll_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7ll_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu9ll(Test_BFu7ll_B_BFu9ll, "BFu7ll_B_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_BFu9s  {
  __tsu64 v1:7;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 BFu7ll_B_BFu9s) C1{ FL:7 Fc Fs:9}



static void Test_BFu7ll_B_BFu9s()
{
  {
    init_simple_test("BFu7ll_B_BFu9s");
    static BFu7ll_B_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_BFu9s");
    check_field_offset(lv, v2, 1, "BFu7ll_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7ll_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7ll_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_BFu9s(Test_BFu7ll_B_BFu9s, "BFu7ll_B_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_C  {
  __tsu64 v1:7;
  bool v2;
  char v3;
};
//SIG(1 BFu7ll_B_C) C1{ FL:7 Fc[2]}



static void Test_BFu7ll_B_C()
{
  {
    init_simple_test("BFu7ll_B_C");
    static BFu7ll_B_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_C");
    check_field_offset(lv, v2, 1, "BFu7ll_B_C.v2");
    check_field_offset(lv, v3, 2, "BFu7ll_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_C(Test_BFu7ll_B_C, "BFu7ll_B_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_D  {
  __tsu64 v1:7;
  bool v2;
  double v3;
};
//SIG(1 BFu7ll_B_D) C1{ FL:7 Fc FL}



static void Test_BFu7ll_B_D()
{
  {
    init_simple_test("BFu7ll_B_D");
    static BFu7ll_B_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_D");
    check_field_offset(lv, v2, 1, "BFu7ll_B_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7ll_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_D(Test_BFu7ll_B_D, "BFu7ll_B_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_F  {
  __tsu64 v1:7;
  bool v2;
  float v3;
};
//SIG(1 BFu7ll_B_F) C1{ FL:7 Fc Fi}



static void Test_BFu7ll_B_F()
{
  {
    init_simple_test("BFu7ll_B_F");
    static BFu7ll_B_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_B_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_F");
    check_field_offset(lv, v2, 1, "BFu7ll_B_F.v2");
    check_field_offset(lv, v3, 4, "BFu7ll_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_F(Test_BFu7ll_B_F, "BFu7ll_B_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_I  {
  __tsu64 v1:7;
  bool v2;
  int v3;
};
//SIG(1 BFu7ll_B_I) C1{ FL:7 Fc Fi}



static void Test_BFu7ll_B_I()
{
  {
    init_simple_test("BFu7ll_B_I");
    static BFu7ll_B_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_B_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_I");
    check_field_offset(lv, v2, 1, "BFu7ll_B_I.v2");
    check_field_offset(lv, v3, 4, "BFu7ll_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_I(Test_BFu7ll_B_I, "BFu7ll_B_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_Ip  {
  __tsu64 v1:7;
  bool v2;
  int *v3;
};
//SIG(1 BFu7ll_B_Ip) C1{ FL:7 Fc Fp}



static void Test_BFu7ll_B_Ip()
{
  {
    init_simple_test("BFu7ll_B_Ip");
    static BFu7ll_B_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_Ip");
    check_field_offset(lv, v2, 1, "BFu7ll_B_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7ll_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_Ip(Test_BFu7ll_B_Ip, "BFu7ll_B_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_L  {
  __tsu64 v1:7;
  bool v2;
  __tsi64 v3;
};
//SIG(1 BFu7ll_B_L) C1{ FL:7 Fc FL}



static void Test_BFu7ll_B_L()
{
  {
    init_simple_test("BFu7ll_B_L");
    static BFu7ll_B_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_L");
    check_field_offset(lv, v2, 1, "BFu7ll_B_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7ll_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_L(Test_BFu7ll_B_L, "BFu7ll_B_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_S  {
  __tsu64 v1:7;
  bool v2;
  short v3;
};
//SIG(1 BFu7ll_B_S) C1{ FL:7 Fc Fs}



static void Test_BFu7ll_B_S()
{
  {
    init_simple_test("BFu7ll_B_S");
    static BFu7ll_B_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_S");
    check_field_offset(lv, v2, 1, "BFu7ll_B_S.v2");
    check_field_offset(lv, v3, 2, "BFu7ll_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_S(Test_BFu7ll_B_S, "BFu7ll_B_S", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_Uc  {
  __tsu64 v1:7;
  bool v2;
  unsigned char v3;
};
//SIG(1 BFu7ll_B_Uc) C1{ FL:7 Fc[2]}



static void Test_BFu7ll_B_Uc()
{
  {
    init_simple_test("BFu7ll_B_Uc");
    static BFu7ll_B_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_Uc");
    check_field_offset(lv, v2, 1, "BFu7ll_B_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu7ll_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_Uc(Test_BFu7ll_B_Uc, "BFu7ll_B_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_Ui  {
  __tsu64 v1:7;
  bool v2;
  unsigned int v3;
};
//SIG(1 BFu7ll_B_Ui) C1{ FL:7 Fc Fi}



static void Test_BFu7ll_B_Ui()
{
  {
    init_simple_test("BFu7ll_B_Ui");
    static BFu7ll_B_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_B_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_Ui");
    check_field_offset(lv, v2, 1, "BFu7ll_B_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu7ll_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_Ui(Test_BFu7ll_B_Ui, "BFu7ll_B_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_Ul  {
  __tsu64 v1:7;
  bool v2;
  __tsu64 v3;
};
//SIG(1 BFu7ll_B_Ul) C1{ FL:7 Fc FL}



static void Test_BFu7ll_B_Ul()
{
  {
    init_simple_test("BFu7ll_B_Ul");
    static BFu7ll_B_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_Ul");
    check_field_offset(lv, v2, 1, "BFu7ll_B_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7ll_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_Ul(Test_BFu7ll_B_Ul, "BFu7ll_B_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_Us  {
  __tsu64 v1:7;
  bool v2;
  unsigned short v3;
};
//SIG(1 BFu7ll_B_Us) C1{ FL:7 Fc Fs}



static void Test_BFu7ll_B_Us()
{
  {
    init_simple_test("BFu7ll_B_Us");
    static BFu7ll_B_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_B_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_Us");
    check_field_offset(lv, v2, 1, "BFu7ll_B_Us.v2");
    check_field_offset(lv, v3, 2, "BFu7ll_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_Us(Test_BFu7ll_B_Us, "BFu7ll_B_Us", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_B_Vp  {
  __tsu64 v1:7;
  bool v2;
  void *v3;
};
//SIG(1 BFu7ll_B_Vp) C1{ FL:7 Fc Fp}



static void Test_BFu7ll_B_Vp()
{
  {
    init_simple_test("BFu7ll_B_Vp");
    static BFu7ll_B_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7ll_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_B_Vp");
    check_field_offset(lv, v2, 1, "BFu7ll_B_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7ll_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_B_Vp(Test_BFu7ll_B_Vp, "BFu7ll_B_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu15i_B  {
  __tsu64 v1:7;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 BFu7ll_BFu15i_B) C1{ FL:7 Fi:15 Fc}



static void Test_BFu7ll_BFu15i_B()
{
  {
    init_simple_test("BFu7ll_BFu15i_B");
    static BFu7ll_BFu15i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu15i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7ll_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7ll_BFu15i_B");
    check_field_offset(lv, v3, 3, "BFu7ll_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu15i_B(Test_BFu7ll_BFu15i_B, "BFu7ll_BFu15i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu15ll_B  {
  __tsu64 v1:7;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 BFu7ll_BFu15ll_B) C1{ FL:7 FL:15 Fc}



static void Test_BFu7ll_BFu15ll_B()
{
  {
    init_simple_test("BFu7ll_BFu15ll_B");
    static BFu7ll_BFu15ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7ll_BFu15ll_B");
    check_field_offset(lv, v3, 3, "BFu7ll_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu15ll_B(Test_BFu7ll_BFu15ll_B, "BFu7ll_BFu15ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu15s_B  {
  __tsu64 v1:7;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 BFu7ll_BFu15s_B) C1{ FL:7 Fs:15 Fc}



static void Test_BFu7ll_BFu15s_B()
{
  {
    init_simple_test("BFu7ll_BFu15s_B");
    static BFu7ll_BFu15s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu15s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7ll_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7ll_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu7ll_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu15s_B(Test_BFu7ll_BFu15s_B, "BFu7ll_BFu15s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu16i_B  {
  __tsu64 v1:7;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 BFu7ll_BFu16i_B) C1{ FL:7 Fi:16 Fc}



static void Test_BFu7ll_BFu16i_B()
{
  {
    init_simple_test("BFu7ll_BFu16i_B");
    static BFu7ll_BFu16i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu16i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7ll_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7ll_BFu16i_B");
    check_field_offset(lv, v3, 3, "BFu7ll_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu16i_B(Test_BFu7ll_BFu16i_B, "BFu7ll_BFu16i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu16ll_B  {
  __tsu64 v1:7;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 BFu7ll_BFu16ll_B) C1{ FL:7 FL:16 Fc}



static void Test_BFu7ll_BFu16ll_B()
{
  {
    init_simple_test("BFu7ll_BFu16ll_B");
    static BFu7ll_BFu16ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7ll_BFu16ll_B");
    check_field_offset(lv, v3, 3, "BFu7ll_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu16ll_B(Test_BFu7ll_BFu16ll_B, "BFu7ll_BFu16ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu16s_B  {
  __tsu64 v1:7;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 BFu7ll_BFu16s_B) C1{ FL:7 Fs:16 Fc}



static void Test_BFu7ll_BFu16s_B()
{
  {
    init_simple_test("BFu7ll_BFu16s_B");
    static BFu7ll_BFu16s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu16s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7ll_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7ll_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu7ll_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu16s_B(Test_BFu7ll_BFu16s_B, "BFu7ll_BFu16s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu17i_B  {
  __tsu64 v1:7;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 BFu7ll_BFu17i_B) C1{ FL:7 Fi:17 Fc}



static void Test_BFu7ll_BFu17i_B()
{
  {
    init_simple_test("BFu7ll_BFu17i_B");
    static BFu7ll_BFu17i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu17i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7ll_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7ll_BFu17i_B");
    check_field_offset(lv, v3, 3, "BFu7ll_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu17i_B(Test_BFu7ll_BFu17i_B, "BFu7ll_BFu17i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu17ll_B  {
  __tsu64 v1:7;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 BFu7ll_BFu17ll_B) C1{ FL:7 FL:17 Fc}



static void Test_BFu7ll_BFu17ll_B()
{
  {
    init_simple_test("BFu7ll_BFu17ll_B");
    static BFu7ll_BFu17ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7ll_BFu17ll_B");
    check_field_offset(lv, v3, 3, "BFu7ll_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu17ll_B(Test_BFu7ll_BFu17ll_B, "BFu7ll_BFu17ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu1c_B  {
  __tsu64 v1:7;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 BFu7ll_BFu1c_B) C1{ FL:7 Fc:1 Fc}



static void Test_BFu7ll_BFu1c_B()
{
  {
    init_simple_test("BFu7ll_BFu1c_B");
    static BFu7ll_BFu1c_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1c_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1c_B");
    check_field_offset(lv, v3, 1, "BFu7ll_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu1c_B(Test_BFu7ll_BFu1c_B, "BFu7ll_BFu1c_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu1i_B  {
  __tsu64 v1:7;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 BFu7ll_BFu1i_B) C1{ FL:7 Fi:1 Fc}



static void Test_BFu7ll_BFu1i_B()
{
  {
    init_simple_test("BFu7ll_BFu1i_B");
    static BFu7ll_BFu1i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1i_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1i_B");
    check_field_offset(lv, v3, 1, "BFu7ll_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu1i_B(Test_BFu7ll_BFu1i_B, "BFu7ll_BFu1i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu1ll_B  {
  __tsu64 v1:7;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 BFu7ll_BFu1ll_B) C1{ FL:7 FL:1 Fc}



static void Test_BFu7ll_BFu1ll_B()
{
  {
    init_simple_test("BFu7ll_BFu1ll_B");
    static BFu7ll_BFu1ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1ll_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1ll_B");
    check_field_offset(lv, v3, 1, "BFu7ll_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu1ll_B(Test_BFu7ll_BFu1ll_B, "BFu7ll_BFu1ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu1s_B  {
  __tsu64 v1:7;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 BFu7ll_BFu1s_B) C1{ FL:7 Fs:1 Fc}



static void Test_BFu7ll_BFu1s_B()
{
  {
    init_simple_test("BFu7ll_BFu1s_B");
    static BFu7ll_BFu1s_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu1s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu1s_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7ll_BFu1s_B");
    check_field_offset(lv, v3, 1, "BFu7ll_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu1s_B(Test_BFu7ll_BFu1s_B, "BFu7ll_BFu1s_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu31i_B  {
  __tsu64 v1:7;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 BFu7ll_BFu31i_B) C1{ FL:7 Fi:31 Fc}



static void Test_BFu7ll_BFu31i_B()
{
  {
    init_simple_test("BFu7ll_BFu31i_B");
    static BFu7ll_BFu31i_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu31i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7ll_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7ll_BFu31i_B");
    check_field_offset(lv, v3, 8, "BFu7ll_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu31i_B(Test_BFu7ll_BFu31i_B, "BFu7ll_BFu31i_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu31ll_B  {
  __tsu64 v1:7;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 BFu7ll_BFu31ll_B) C1{ FL:7 FL:31 Fc}



static void Test_BFu7ll_BFu31ll_B()
{
  {
    init_simple_test("BFu7ll_BFu31ll_B");
    static BFu7ll_BFu31ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7ll_BFu31ll_B");
    check_field_offset(lv, v3, 5, "BFu7ll_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu31ll_B(Test_BFu7ll_BFu31ll_B, "BFu7ll_BFu31ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu32i_B  {
  __tsu64 v1:7;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 BFu7ll_BFu32i_B) C1{ FL:7 Fi:32 Fc}



static void Test_BFu7ll_BFu32i_B()
{
  {
    init_simple_test("BFu7ll_BFu32i_B");
    static BFu7ll_BFu32i_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_BFu32i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7ll_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7ll_BFu32i_B");
    check_field_offset(lv, v3, 8, "BFu7ll_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu32i_B(Test_BFu7ll_BFu32i_B, "BFu7ll_BFu32i_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu32ll_B  {
  __tsu64 v1:7;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 BFu7ll_BFu32ll_B) C1{ FL:7 FL:32 Fc}



static void Test_BFu7ll_BFu32ll_B()
{
  {
    init_simple_test("BFu7ll_BFu32ll_B");
    static BFu7ll_BFu32ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7ll_BFu32ll_B");
    check_field_offset(lv, v3, 5, "BFu7ll_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu32ll_B(Test_BFu7ll_BFu32ll_B, "BFu7ll_BFu32ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu33_B  {
  __tsu64 v1:7;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 BFu7ll_BFu33_B) C1{ FL:7 FL:33 Fc}



static void Test_BFu7ll_BFu33_B()
{
  {
    init_simple_test("BFu7ll_BFu33_B");
    static BFu7ll_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7ll_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7ll_BFu33_B");
    check_field_offset(lv, v3, 5, "BFu7ll_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu33_B(Test_BFu7ll_BFu33_B, "BFu7ll_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu7c_B  {
  __tsu64 v1:7;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 BFu7ll_BFu7c_B) C1{ FL:7 Fc:7 Fc}



static void Test_BFu7ll_BFu7c_B()
{
  {
    init_simple_test("BFu7ll_BFu7c_B");
    static BFu7ll_BFu7c_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7ll_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7c_B");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu7c_B(Test_BFu7ll_BFu7c_B, "BFu7ll_BFu7c_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu7i_B  {
  __tsu64 v1:7;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 BFu7ll_BFu7i_B) C1{ FL:7 Fi:7 Fc}



static void Test_BFu7ll_BFu7i_B()
{
  {
    init_simple_test("BFu7ll_BFu7i_B");
    static BFu7ll_BFu7i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7i_B");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu7i_B(Test_BFu7ll_BFu7i_B, "BFu7ll_BFu7i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu7ll_B  {
  __tsu64 v1:7;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 BFu7ll_BFu7ll_B) C1{ FL:7 FL:7 Fc}



static void Test_BFu7ll_BFu7ll_B()
{
  {
    init_simple_test("BFu7ll_BFu7ll_B");
    static BFu7ll_BFu7ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7ll_B");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu7ll_B(Test_BFu7ll_BFu7ll_B, "BFu7ll_BFu7ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu7s_B  {
  __tsu64 v1:7;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 BFu7ll_BFu7s_B) C1{ FL:7 Fs:7 Fc}



static void Test_BFu7ll_BFu7s_B()
{
  {
    init_simple_test("BFu7ll_BFu7s_B");
    static BFu7ll_BFu7s_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu7s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7ll_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7ll_BFu7s_B");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu7s_B(Test_BFu7ll_BFu7s_B, "BFu7ll_BFu7s_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu8c_B  {
  __tsu64 v1:7;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 BFu7ll_BFu8c_B) C1{ FL:7 Fc:8 Fc}



static void Test_BFu7ll_BFu8c_B()
{
  {
    init_simple_test("BFu7ll_BFu8c_B");
    static BFu7ll_BFu8c_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu8c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7ll_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7ll_BFu8c_B");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu8c_B(Test_BFu7ll_BFu8c_B, "BFu7ll_BFu8c_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu8i_B  {
  __tsu64 v1:7;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 BFu7ll_BFu8i_B) C1{ FL:7 Fi:8 Fc}



static void Test_BFu7ll_BFu8i_B()
{
  {
    init_simple_test("BFu7ll_BFu8i_B");
    static BFu7ll_BFu8i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu8i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7ll_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7ll_BFu8i_B");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu8i_B(Test_BFu7ll_BFu8i_B, "BFu7ll_BFu8i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu8ll_B  {
  __tsu64 v1:7;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 BFu7ll_BFu8ll_B) C1{ FL:7 FL:8 Fc}



static void Test_BFu7ll_BFu8ll_B()
{
  {
    init_simple_test("BFu7ll_BFu8ll_B");
    static BFu7ll_BFu8ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7ll_BFu8ll_B");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu8ll_B(Test_BFu7ll_BFu8ll_B, "BFu7ll_BFu8ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu8s_B  {
  __tsu64 v1:7;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 BFu7ll_BFu8s_B) C1{ FL:7 Fs:8 Fc}



static void Test_BFu7ll_BFu8s_B()
{
  {
    init_simple_test("BFu7ll_BFu8s_B");
    static BFu7ll_BFu8s_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu8s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7ll_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7ll_BFu8s_B");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu8s_B(Test_BFu7ll_BFu8s_B, "BFu7ll_BFu8s_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu9i_B  {
  __tsu64 v1:7;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 BFu7ll_BFu9i_B) C1{ FL:7 Fi:9 Fc}



static void Test_BFu7ll_BFu9i_B()
{
  {
    init_simple_test("BFu7ll_BFu9i_B");
    static BFu7ll_BFu9i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu9i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7ll_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7ll_BFu9i_B");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu9i_B(Test_BFu7ll_BFu9i_B, "BFu7ll_BFu9i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu9ll_B  {
  __tsu64 v1:7;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 BFu7ll_BFu9ll_B) C1{ FL:7 FL:9 Fc}



static void Test_BFu7ll_BFu9ll_B()
{
  {
    init_simple_test("BFu7ll_BFu9ll_B");
    static BFu7ll_BFu9ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7ll_BFu9ll_B");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu9ll_B(Test_BFu7ll_BFu9ll_B, "BFu7ll_BFu9ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_BFu9s_B  {
  __tsu64 v1:7;
  unsigned short v2:9;
  bool v3;
};
//SIG(1 BFu7ll_BFu9s_B) C1{ FL:7 Fs:9 Fc}



static void Test_BFu7ll_BFu9s_B()
{
  {
    init_simple_test("BFu7ll_BFu9s_B");
    static BFu7ll_BFu9s_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_BFu9s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7ll_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7ll_BFu9s_B");
    check_field_offset(lv, v3, 2, "BFu7ll_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_BFu9s_B(Test_BFu7ll_BFu9s_B, "BFu7ll_BFu9s_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_C_B  {
  __tsu64 v1:7;
  char v2;
  bool v3;
};
//SIG(1 BFu7ll_C_B) C1{ FL:7 Fc[2]}



static void Test_BFu7ll_C_B()
{
  {
    init_simple_test("BFu7ll_C_B");
    static BFu7ll_C_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_C_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_C_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_C_B");
    check_field_offset(lv, v2, 1, "BFu7ll_C_B.v2");
    check_field_offset(lv, v3, 2, "BFu7ll_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_C_B(Test_BFu7ll_C_B, "BFu7ll_C_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_D_B  {
  __tsu64 v1:7;
  double v2;
  bool v3;
};
//SIG(1 BFu7ll_D_B) C1{ FL:7 FL Fc}



static void Test_BFu7ll_D_B()
{
  {
    init_simple_test("BFu7ll_D_B");
    static BFu7ll_D_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu7ll_D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_D_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_D_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_D_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu7ll_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_D_B(Test_BFu7ll_D_B, "BFu7ll_D_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_F_B  {
  __tsu64 v1:7;
  float v2;
  bool v3;
};
//SIG(1 BFu7ll_F_B) C1{ FL:7 Fi Fc}



static void Test_BFu7ll_F_B()
{
  {
    init_simple_test("BFu7ll_F_B");
    static BFu7ll_F_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_F_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_F_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_F_B");
    check_field_offset(lv, v2, 4, "BFu7ll_F_B.v2");
    check_field_offset(lv, v3, 8, "BFu7ll_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_F_B(Test_BFu7ll_F_B, "BFu7ll_F_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_I_B  {
  __tsu64 v1:7;
  int v2;
  bool v3;
};
//SIG(1 BFu7ll_I_B) C1{ FL:7 Fi Fc}



static void Test_BFu7ll_I_B()
{
  {
    init_simple_test("BFu7ll_I_B");
    static BFu7ll_I_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_I_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_I_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_I_B");
    check_field_offset(lv, v2, 4, "BFu7ll_I_B.v2");
    check_field_offset(lv, v3, 8, "BFu7ll_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_I_B(Test_BFu7ll_I_B, "BFu7ll_I_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_Ip_B  {
  __tsu64 v1:7;
  int *v2;
  bool v3;
};
//SIG(1 BFu7ll_Ip_B) C1{ FL:7 Fp Fc}



static void Test_BFu7ll_Ip_B()
{
  {
    init_simple_test("BFu7ll_Ip_B");
    static BFu7ll_Ip_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu7ll_Ip_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Ip_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu7ll_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_Ip_B(Test_BFu7ll_Ip_B, "BFu7ll_Ip_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_L_B  {
  __tsu64 v1:7;
  __tsi64 v2;
  bool v3;
};
//SIG(1 BFu7ll_L_B) C1{ FL:7 FL Fc}



static void Test_BFu7ll_L_B()
{
  {
    init_simple_test("BFu7ll_L_B");
    static BFu7ll_L_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu7ll_L_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_L_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_L_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_L_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu7ll_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_L_B(Test_BFu7ll_L_B, "BFu7ll_L_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_S_B  {
  __tsu64 v1:7;
  short v2;
  bool v3;
};
//SIG(1 BFu7ll_S_B) C1{ FL:7 Fs Fc}



static void Test_BFu7ll_S_B()
{
  {
    init_simple_test("BFu7ll_S_B");
    static BFu7ll_S_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_S_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_S_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_S_B");
    check_field_offset(lv, v2, 2, "BFu7ll_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu7ll_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_S_B(Test_BFu7ll_S_B, "BFu7ll_S_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_Uc_B  {
  __tsu64 v1:7;
  unsigned char v2;
  bool v3;
};
//SIG(1 BFu7ll_Uc_B) C1{ FL:7 Fc[2]}



static void Test_BFu7ll_Uc_B()
{
  {
    init_simple_test("BFu7ll_Uc_B");
    static BFu7ll_Uc_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7ll_Uc_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Uc_B");
    check_field_offset(lv, v2, 1, "BFu7ll_Uc_B.v2");
    check_field_offset(lv, v3, 2, "BFu7ll_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_Uc_B(Test_BFu7ll_Uc_B, "BFu7ll_Uc_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_Ui_B  {
  __tsu64 v1:7;
  unsigned int v2;
  bool v3;
};
//SIG(1 BFu7ll_Ui_B) C1{ FL:7 Fi Fc}



static void Test_BFu7ll_Ui_B()
{
  {
    init_simple_test("BFu7ll_Ui_B");
    static BFu7ll_Ui_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7ll_Ui_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Ui_B");
    check_field_offset(lv, v2, 4, "BFu7ll_Ui_B.v2");
    check_field_offset(lv, v3, 8, "BFu7ll_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_Ui_B(Test_BFu7ll_Ui_B, "BFu7ll_Ui_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_Ul_B  {
  __tsu64 v1:7;
  __tsu64 v2;
  bool v3;
};
//SIG(1 BFu7ll_Ul_B) C1{ FL:7 FL Fc}



static void Test_BFu7ll_Ul_B()
{
  {
    init_simple_test("BFu7ll_Ul_B");
    static BFu7ll_Ul_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu7ll_Ul_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Ul_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_Ul_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu7ll_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_Ul_B(Test_BFu7ll_Ul_B, "BFu7ll_Ul_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_Us_B  {
  __tsu64 v1:7;
  unsigned short v2;
  bool v3;
};
//SIG(1 BFu7ll_Us_B) C1{ FL:7 Fs Fc}



static void Test_BFu7ll_Us_B()
{
  {
    init_simple_test("BFu7ll_Us_B");
    static BFu7ll_Us_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7ll_Us_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Us_B");
    check_field_offset(lv, v2, 2, "BFu7ll_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu7ll_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_Us_B(Test_BFu7ll_Us_B, "BFu7ll_Us_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7ll_Vp_B  {
  __tsu64 v1:7;
  void *v2;
  bool v3;
};
//SIG(1 BFu7ll_Vp_B) C1{ FL:7 Fp Fc}



static void Test_BFu7ll_Vp_B()
{
  {
    init_simple_test("BFu7ll_Vp_B");
    static BFu7ll_Vp_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu7ll_Vp_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7ll_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7ll_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7ll_Vp_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7ll_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu7ll_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7ll_Vp_B(Test_BFu7ll_Vp_B, "BFu7ll_Vp_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B  {
  unsigned short v1:7;
  bool v2;
};
//SIG(1 BFu7s_B) C1{ Fs:7 Fc}



static void Test_BFu7s_B()
{
  {
    init_simple_test("BFu7s_B");
    static BFu7s_B lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B");
    check_field_offset(lv, v2, 1, "BFu7s_B.v2");
  }
}
static Arrange_To_Call_Me vBFu7s_B(Test_BFu7s_B, "BFu7s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_B  {
  unsigned short v1:7;
  bool v2;
  bool v3;
};
//SIG(1 BFu7s_B_B) C1{ Fs:7 Fc[2]}



static void Test_BFu7s_B_B()
{
  {
    init_simple_test("BFu7s_B_B");
    static BFu7s_B_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_B");
    check_field_offset(lv, v2, 1, "BFu7s_B_B.v2");
    check_field_offset(lv, v3, 2, "BFu7s_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_B_B(Test_BFu7s_B_B, "BFu7s_B_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu15i  {
  unsigned short v1:7;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 BFu7s_B_BFu15i) C1{ Fs:7 Fc Fi:15}



static void Test_BFu7s_B_BFu15i()
{
  {
    init_simple_test("BFu7s_B_BFu15i");
    static BFu7s_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu15i");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7s_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7s_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu15i(Test_BFu7s_B_BFu15i, "BFu7s_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu15ll  {
  unsigned short v1:7;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 BFu7s_B_BFu15ll) C1{ Fs:7 Fc FL:15}



static void Test_BFu7s_B_BFu15ll()
{
  {
    init_simple_test("BFu7s_B_BFu15ll");
    static BFu7s_B_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7s_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7s_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7s_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu15ll(Test_BFu7s_B_BFu15ll, "BFu7s_B_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu15s  {
  unsigned short v1:7;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 BFu7s_B_BFu15s) C1{ Fs:7 Fc Fs:15}



static void Test_BFu7s_B_BFu15s()
{
  {
    init_simple_test("BFu7s_B_BFu15s");
    static BFu7s_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu15s");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu7s_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu7s_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu15s(Test_BFu7s_B_BFu15s, "BFu7s_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu16i  {
  unsigned short v1:7;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 BFu7s_B_BFu16i) C1{ Fs:7 Fc Fi:16}



static void Test_BFu7s_B_BFu16i()
{
  {
    init_simple_test("BFu7s_B_BFu16i");
    static BFu7s_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu16i");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7s_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7s_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu16i(Test_BFu7s_B_BFu16i, "BFu7s_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu16ll  {
  unsigned short v1:7;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 BFu7s_B_BFu16ll) C1{ Fs:7 Fc FL:16}



static void Test_BFu7s_B_BFu16ll()
{
  {
    init_simple_test("BFu7s_B_BFu16ll");
    static BFu7s_B_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7s_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7s_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7s_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu16ll(Test_BFu7s_B_BFu16ll, "BFu7s_B_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu16s  {
  unsigned short v1:7;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 BFu7s_B_BFu16s) C1{ Fs:7 Fc Fs:16}



static void Test_BFu7s_B_BFu16s()
{
  {
    init_simple_test("BFu7s_B_BFu16s");
    static BFu7s_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu16s");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu7s_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu7s_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu16s(Test_BFu7s_B_BFu16s, "BFu7s_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu17i  {
  unsigned short v1:7;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 BFu7s_B_BFu17i) C1{ Fs:7 Fc Fi:17}



static void Test_BFu7s_B_BFu17i()
{
  {
    init_simple_test("BFu7s_B_BFu17i");
    static BFu7s_B_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7s_B_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu17i");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu7s_B_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu7s_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu17i(Test_BFu7s_B_BFu17i, "BFu7s_B_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu17ll  {
  unsigned short v1:7;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 BFu7s_B_BFu17ll) C1{ Fs:7 Fc FL:17}



static void Test_BFu7s_B_BFu17ll()
{
  {
    init_simple_test("BFu7s_B_BFu17ll");
    static BFu7s_B_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7s_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu7s_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu7s_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu17ll(Test_BFu7s_B_BFu17ll, "BFu7s_B_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu1c  {
  unsigned short v1:7;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 BFu7s_B_BFu1c) C1{ Fs:7 Fc Fc:1}



static void Test_BFu7s_B_BFu1c()
{
  {
    init_simple_test("BFu7s_B_BFu1c");
    static BFu7s_B_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu1c");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7s_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu1c(Test_BFu7s_B_BFu1c, "BFu7s_B_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu1i  {
  unsigned short v1:7;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 BFu7s_B_BFu1i) C1{ Fs:7 Fc Fi:1}



static void Test_BFu7s_B_BFu1i()
{
  {
    init_simple_test("BFu7s_B_BFu1i");
    static BFu7s_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu1i");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7s_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu1i(Test_BFu7s_B_BFu1i, "BFu7s_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu1ll  {
  unsigned short v1:7;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 BFu7s_B_BFu1ll) C1{ Fs:7 Fc FL:1}



static void Test_BFu7s_B_BFu1ll()
{
  {
    init_simple_test("BFu7s_B_BFu1ll");
    static BFu7s_B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7s_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7s_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu1ll(Test_BFu7s_B_BFu1ll, "BFu7s_B_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu1s  {
  unsigned short v1:7;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 BFu7s_B_BFu1s) C1{ Fs:7 Fc Fs:1}



static void Test_BFu7s_B_BFu1s()
{
  {
    init_simple_test("BFu7s_B_BFu1s");
    static BFu7s_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu1s");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu7s_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu1s(Test_BFu7s_B_BFu1s, "BFu7s_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu31i  {
  unsigned short v1:7;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 BFu7s_B_BFu31i) C1{ Fs:7 Fc Fi:31}



static void Test_BFu7s_B_BFu31i()
{
  {
    init_simple_test("BFu7s_B_BFu31i");
    static BFu7s_B_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7s_B_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu31i");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu7s_B_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu7s_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu31i(Test_BFu7s_B_BFu31i, "BFu7s_B_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu31ll  {
  unsigned short v1:7;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 BFu7s_B_BFu31ll) C1{ Fs:7 Fc FL:31}



static void Test_BFu7s_B_BFu31ll()
{
  {
    init_simple_test("BFu7s_B_BFu31ll");
    static BFu7s_B_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7s_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu7s_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu7s_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu31ll(Test_BFu7s_B_BFu31ll, "BFu7s_B_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu32i  {
  unsigned short v1:7;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 BFu7s_B_BFu32i) C1{ Fs:7 Fc Fi:32}



static void Test_BFu7s_B_BFu32i()
{
  {
    init_simple_test("BFu7s_B_BFu32i");
    static BFu7s_B_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu7s_B_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu32i");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu7s_B_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu7s_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu32i(Test_BFu7s_B_BFu32i, "BFu7s_B_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu32ll  {
  unsigned short v1:7;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 BFu7s_B_BFu32ll) C1{ Fs:7 Fc FL:32}



static void Test_BFu7s_B_BFu32ll()
{
  {
    init_simple_test("BFu7s_B_BFu32ll");
    static BFu7s_B_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu7s_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu7s_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu7s_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu32ll(Test_BFu7s_B_BFu32ll, "BFu7s_B_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu33  {
  unsigned short v1:7;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 BFu7s_B_BFu33) C1{ Fs:7 Fc FL:33}



static void Test_BFu7s_B_BFu33()
{
  {
    init_simple_test("BFu7s_B_BFu33");
    static BFu7s_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu7s_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu33");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu7s_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu7s_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu33(Test_BFu7s_B_BFu33, "BFu7s_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu7c  {
  unsigned short v1:7;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 BFu7s_B_BFu7c) C1{ Fs:7 Fc Fc:7}



static void Test_BFu7s_B_BFu7c()
{
  {
    init_simple_test("BFu7s_B_BFu7c");
    static BFu7s_B_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu7c");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7s_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu7c(Test_BFu7s_B_BFu7c, "BFu7s_B_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu7i  {
  unsigned short v1:7;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 BFu7s_B_BFu7i) C1{ Fs:7 Fc Fi:7}



static void Test_BFu7s_B_BFu7i()
{
  {
    init_simple_test("BFu7s_B_BFu7i");
    static BFu7s_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu7i");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7s_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu7i(Test_BFu7s_B_BFu7i, "BFu7s_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu7ll  {
  unsigned short v1:7;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 BFu7s_B_BFu7ll) C1{ Fs:7 Fc FL:7}



static void Test_BFu7s_B_BFu7ll()
{
  {
    init_simple_test("BFu7s_B_BFu7ll");
    static BFu7s_B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7s_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7s_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu7ll(Test_BFu7s_B_BFu7ll, "BFu7s_B_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu7s  {
  unsigned short v1:7;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 BFu7s_B_BFu7s) C1{ Fs:7 Fc Fs:7}



static void Test_BFu7s_B_BFu7s()
{
  {
    init_simple_test("BFu7s_B_BFu7s");
    static BFu7s_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu7s");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu7s_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu7s(Test_BFu7s_B_BFu7s, "BFu7s_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu8c  {
  unsigned short v1:7;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 BFu7s_B_BFu8c) C1{ Fs:7 Fc Fc:8}



static void Test_BFu7s_B_BFu8c()
{
  {
    init_simple_test("BFu7s_B_BFu8c");
    static BFu7s_B_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu8c");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7s_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7s_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu8c(Test_BFu7s_B_BFu8c, "BFu7s_B_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu8i  {
  unsigned short v1:7;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 BFu7s_B_BFu8i) C1{ Fs:7 Fc Fi:8}



static void Test_BFu7s_B_BFu8i()
{
  {
    init_simple_test("BFu7s_B_BFu8i");
    static BFu7s_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu8i");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7s_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7s_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu8i(Test_BFu7s_B_BFu8i, "BFu7s_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu8ll  {
  unsigned short v1:7;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 BFu7s_B_BFu8ll) C1{ Fs:7 Fc FL:8}



static void Test_BFu7s_B_BFu8ll()
{
  {
    init_simple_test("BFu7s_B_BFu8ll");
    static BFu7s_B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7s_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7s_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7s_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu8ll(Test_BFu7s_B_BFu8ll, "BFu7s_B_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu8s  {
  unsigned short v1:7;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 BFu7s_B_BFu8s) C1{ Fs:7 Fc Fs:8}



static void Test_BFu7s_B_BFu8s()
{
  {
    init_simple_test("BFu7s_B_BFu8s");
    static BFu7s_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu8s");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu7s_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu7s_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu8s(Test_BFu7s_B_BFu8s, "BFu7s_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu9i  {
  unsigned short v1:7;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 BFu7s_B_BFu9i) C1{ Fs:7 Fc Fi:9}



static void Test_BFu7s_B_BFu9i()
{
  {
    init_simple_test("BFu7s_B_BFu9i");
    static BFu7s_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu9i");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7s_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7s_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu9i(Test_BFu7s_B_BFu9i, "BFu7s_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu9ll  {
  unsigned short v1:7;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 BFu7s_B_BFu9ll) C1{ Fs:7 Fc FL:9}



static void Test_BFu7s_B_BFu9ll()
{
  {
    init_simple_test("BFu7s_B_BFu9ll");
    static BFu7s_B_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7s_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7s_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7s_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu9ll(Test_BFu7s_B_BFu9ll, "BFu7s_B_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_BFu9s  {
  unsigned short v1:7;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 BFu7s_B_BFu9s) C1{ Fs:7 Fc Fs:9}



static void Test_BFu7s_B_BFu9s()
{
  {
    init_simple_test("BFu7s_B_BFu9s");
    static BFu7s_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_BFu9s");
    check_field_offset(lv, v2, 1, "BFu7s_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu7s_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu7s_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu7s_B_BFu9s(Test_BFu7s_B_BFu9s, "BFu7s_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_C  {
  unsigned short v1:7;
  bool v2;
  char v3;
};
//SIG(1 BFu7s_B_C) C1{ Fs:7 Fc[2]}



static void Test_BFu7s_B_C()
{
  {
    init_simple_test("BFu7s_B_C");
    static BFu7s_B_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_C");
    check_field_offset(lv, v2, 1, "BFu7s_B_C.v2");
    check_field_offset(lv, v3, 2, "BFu7s_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_B_C(Test_BFu7s_B_C, "BFu7s_B_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_D  {
  unsigned short v1:7;
  bool v2;
  double v3;
};
//SIG(1 BFu7s_B_D) C1{ Fs:7 Fc FL}



static void Test_BFu7s_B_D()
{
  {
    init_simple_test("BFu7s_B_D");
    static BFu7s_B_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7s_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_D");
    check_field_offset(lv, v2, 1, "BFu7s_B_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7s_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_B_D(Test_BFu7s_B_D, "BFu7s_B_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_F  {
  unsigned short v1:7;
  bool v2;
  float v3;
};
//SIG(1 BFu7s_B_F) C1{ Fs:7 Fc Fi}



static void Test_BFu7s_B_F()
{
  {
    init_simple_test("BFu7s_B_F");
    static BFu7s_B_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu7s_B_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_F");
    check_field_offset(lv, v2, 1, "BFu7s_B_F.v2");
    check_field_offset(lv, v3, 4, "BFu7s_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_B_F(Test_BFu7s_B_F, "BFu7s_B_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_I  {
  unsigned short v1:7;
  bool v2;
  int v3;
};
//SIG(1 BFu7s_B_I) C1{ Fs:7 Fc Fi}



static void Test_BFu7s_B_I()
{
  {
    init_simple_test("BFu7s_B_I");
    static BFu7s_B_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu7s_B_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_I");
    check_field_offset(lv, v2, 1, "BFu7s_B_I.v2");
    check_field_offset(lv, v3, 4, "BFu7s_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_B_I(Test_BFu7s_B_I, "BFu7s_B_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_Ip  {
  unsigned short v1:7;
  bool v2;
  int *v3;
};
//SIG(1 BFu7s_B_Ip) C1{ Fs:7 Fc Fp}



static void Test_BFu7s_B_Ip()
{
  {
    init_simple_test("BFu7s_B_Ip");
    static BFu7s_B_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7s_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_Ip");
    check_field_offset(lv, v2, 1, "BFu7s_B_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7s_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_B_Ip(Test_BFu7s_B_Ip, "BFu7s_B_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_L  {
  unsigned short v1:7;
  bool v2;
  __tsi64 v3;
};
//SIG(1 BFu7s_B_L) C1{ Fs:7 Fc FL}



static void Test_BFu7s_B_L()
{
  {
    init_simple_test("BFu7s_B_L");
    static BFu7s_B_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7s_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_L");
    check_field_offset(lv, v2, 1, "BFu7s_B_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7s_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_B_L(Test_BFu7s_B_L, "BFu7s_B_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_S  {
  unsigned short v1:7;
  bool v2;
  short v3;
};
//SIG(1 BFu7s_B_S) C1{ Fs:7 Fc Fs}



static void Test_BFu7s_B_S()
{
  {
    init_simple_test("BFu7s_B_S");
    static BFu7s_B_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_S");
    check_field_offset(lv, v2, 1, "BFu7s_B_S.v2");
    check_field_offset(lv, v3, 2, "BFu7s_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_B_S(Test_BFu7s_B_S, "BFu7s_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_Uc  {
  unsigned short v1:7;
  bool v2;
  unsigned char v3;
};
//SIG(1 BFu7s_B_Uc) C1{ Fs:7 Fc[2]}



static void Test_BFu7s_B_Uc()
{
  {
    init_simple_test("BFu7s_B_Uc");
    static BFu7s_B_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_Uc");
    check_field_offset(lv, v2, 1, "BFu7s_B_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu7s_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_B_Uc(Test_BFu7s_B_Uc, "BFu7s_B_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_Ui  {
  unsigned short v1:7;
  bool v2;
  unsigned int v3;
};
//SIG(1 BFu7s_B_Ui) C1{ Fs:7 Fc Fi}



static void Test_BFu7s_B_Ui()
{
  {
    init_simple_test("BFu7s_B_Ui");
    static BFu7s_B_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu7s_B_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_Ui");
    check_field_offset(lv, v2, 1, "BFu7s_B_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu7s_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_B_Ui(Test_BFu7s_B_Ui, "BFu7s_B_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_Ul  {
  unsigned short v1:7;
  bool v2;
  __tsu64 v3;
};
//SIG(1 BFu7s_B_Ul) C1{ Fs:7 Fc FL}



static void Test_BFu7s_B_Ul()
{
  {
    init_simple_test("BFu7s_B_Ul");
    static BFu7s_B_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu7s_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_Ul");
    check_field_offset(lv, v2, 1, "BFu7s_B_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7s_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_B_Ul(Test_BFu7s_B_Ul, "BFu7s_B_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_Us  {
  unsigned short v1:7;
  bool v2;
  unsigned short v3;
};
//SIG(1 BFu7s_B_Us) C1{ Fs:7 Fc Fs}



static void Test_BFu7s_B_Us()
{
  {
    init_simple_test("BFu7s_B_Us");
    static BFu7s_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_B_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_Us");
    check_field_offset(lv, v2, 1, "BFu7s_B_Us.v2");
    check_field_offset(lv, v3, 2, "BFu7s_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_B_Us(Test_BFu7s_B_Us, "BFu7s_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_B_Vp  {
  unsigned short v1:7;
  bool v2;
  void *v3;
};
//SIG(1 BFu7s_B_Vp) C1{ Fs:7 Fc Fp}



static void Test_BFu7s_B_Vp()
{
  {
    init_simple_test("BFu7s_B_Vp");
    static BFu7s_B_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu7s_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_B_Vp");
    check_field_offset(lv, v2, 1, "BFu7s_B_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu7s_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_B_Vp(Test_BFu7s_B_Vp, "BFu7s_B_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu15i_B  {
  unsigned short v1:7;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 BFu7s_BFu15i_B) C1{ Fs:7 Fi:15 Fc}



static void Test_BFu7s_BFu15i_B()
{
  {
    init_simple_test("BFu7s_BFu15i_B");
    static BFu7s_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_BFu15i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7s_BFu15i_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7s_BFu15i_B");
    check_field_offset(lv, v3, 3, "BFu7s_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu15i_B(Test_BFu7s_BFu15i_B, "BFu7s_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu15ll_B  {
  unsigned short v1:7;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 BFu7s_BFu15ll_B) C1{ Fs:7 FL:15 Fc}



static void Test_BFu7s_BFu15ll_B()
{
  {
    init_simple_test("BFu7s_BFu15ll_B");
    static BFu7s_BFu15ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7s_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu7s_BFu15ll_B");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu7s_BFu15ll_B");
    check_field_offset(lv, v3, 3, "BFu7s_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu15ll_B(Test_BFu7s_BFu15ll_B, "BFu7s_BFu15ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu15s_B  {
  unsigned short v1:7;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 BFu7s_BFu15s_B) C1{ Fs:7 Fs:15 Fc}



static void Test_BFu7s_BFu15s_B()
{
  {
    init_simple_test("BFu7s_BFu15s_B");
    static BFu7s_BFu15s_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu7s_BFu15s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu7s_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu7s_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu7s_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu15s_B(Test_BFu7s_BFu15s_B, "BFu7s_BFu15s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu16i_B  {
  unsigned short v1:7;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 BFu7s_BFu16i_B) C1{ Fs:7 Fi:16 Fc}



static void Test_BFu7s_BFu16i_B()
{
  {
    init_simple_test("BFu7s_BFu16i_B");
    static BFu7s_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_BFu16i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7s_BFu16i_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7s_BFu16i_B");
    check_field_offset(lv, v3, 3, "BFu7s_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu16i_B(Test_BFu7s_BFu16i_B, "BFu7s_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu16ll_B  {
  unsigned short v1:7;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 BFu7s_BFu16ll_B) C1{ Fs:7 FL:16 Fc}



static void Test_BFu7s_BFu16ll_B()
{
  {
    init_simple_test("BFu7s_BFu16ll_B");
    static BFu7s_BFu16ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7s_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu7s_BFu16ll_B");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu7s_BFu16ll_B");
    check_field_offset(lv, v3, 3, "BFu7s_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu16ll_B(Test_BFu7s_BFu16ll_B, "BFu7s_BFu16ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu16s_B  {
  unsigned short v1:7;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 BFu7s_BFu16s_B) C1{ Fs:7 Fs:16 Fc}



static void Test_BFu7s_BFu16s_B()
{
  {
    init_simple_test("BFu7s_BFu16s_B");
    static BFu7s_BFu16s_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu7s_BFu16s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu7s_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu7s_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu7s_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu16s_B(Test_BFu7s_BFu16s_B, "BFu7s_BFu16s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu17i_B  {
  unsigned short v1:7;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 BFu7s_BFu17i_B) C1{ Fs:7 Fi:17 Fc}



static void Test_BFu7s_BFu17i_B()
{
  {
    init_simple_test("BFu7s_BFu17i_B");
    static BFu7s_BFu17i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_BFu17i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7s_BFu17i_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7s_BFu17i_B");
    check_field_offset(lv, v3, 3, "BFu7s_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu17i_B(Test_BFu7s_BFu17i_B, "BFu7s_BFu17i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu17ll_B  {
  unsigned short v1:7;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 BFu7s_BFu17ll_B) C1{ Fs:7 FL:17 Fc}



static void Test_BFu7s_BFu17ll_B()
{
  {
    init_simple_test("BFu7s_BFu17ll_B");
    static BFu7s_BFu17ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7s_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu7s_BFu17ll_B");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu7s_BFu17ll_B");
    check_field_offset(lv, v3, 3, "BFu7s_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu17ll_B(Test_BFu7s_BFu17ll_B, "BFu7s_BFu17ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu1c_B  {
  unsigned short v1:7;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 BFu7s_BFu1c_B) C1{ Fs:7 Fc:1 Fc}



static void Test_BFu7s_BFu1c_B()
{
  {
    init_simple_test("BFu7s_BFu1c_B");
    static BFu7s_BFu1c_B lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_BFu1c_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu1c_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7s_BFu1c_B");
    check_field_offset(lv, v3, 1, "BFu7s_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu1c_B(Test_BFu7s_BFu1c_B, "BFu7s_BFu1c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu1i_B  {
  unsigned short v1:7;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 BFu7s_BFu1i_B) C1{ Fs:7 Fi:1 Fc}



static void Test_BFu7s_BFu1i_B()
{
  {
    init_simple_test("BFu7s_BFu1i_B");
    static BFu7s_BFu1i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_BFu1i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu1i_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7s_BFu1i_B");
    check_field_offset(lv, v3, 1, "BFu7s_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu1i_B(Test_BFu7s_BFu1i_B, "BFu7s_BFu1i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu1ll_B  {
  unsigned short v1:7;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 BFu7s_BFu1ll_B) C1{ Fs:7 FL:1 Fc}



static void Test_BFu7s_BFu1ll_B()
{
  {
    init_simple_test("BFu7s_BFu1ll_B");
    static BFu7s_BFu1ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7s_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu1ll_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7s_BFu1ll_B");
    check_field_offset(lv, v3, 1, "BFu7s_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu1ll_B(Test_BFu7s_BFu1ll_B, "BFu7s_BFu1ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu1s_B  {
  unsigned short v1:7;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 BFu7s_BFu1s_B) C1{ Fs:7 Fs:1 Fc}



static void Test_BFu7s_BFu1s_B()
{
  {
    init_simple_test("BFu7s_BFu1s_B");
    static BFu7s_BFu1s_B lv;
    check2(sizeof(lv), 2, "sizeof(BFu7s_BFu1s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu1s_B");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu7s_BFu1s_B");
    check_field_offset(lv, v3, 1, "BFu7s_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu1s_B(Test_BFu7s_BFu1s_B, "BFu7s_BFu1s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu31i_B  {
  unsigned short v1:7;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 BFu7s_BFu31i_B) C1{ Fs:7 Fi:31 Fc}



static void Test_BFu7s_BFu31i_B()
{
  {
    init_simple_test("BFu7s_BFu31i_B");
    static BFu7s_BFu31i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7s_BFu31i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu7s_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu7s_BFu31i_B");
    check_field_offset(lv, v3, 8, "BFu7s_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu31i_B(Test_BFu7s_BFu31i_B, "BFu7s_BFu31i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu31ll_B  {
  unsigned short v1:7;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 BFu7s_BFu31ll_B) C1{ Fs:7 FL:31 Fc}



static void Test_BFu7s_BFu31ll_B()
{
  {
    init_simple_test("BFu7s_BFu31ll_B");
    static BFu7s_BFu31ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7s_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu7s_BFu31ll_B");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu7s_BFu31ll_B");
    check_field_offset(lv, v3, 5, "BFu7s_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu31ll_B(Test_BFu7s_BFu31ll_B, "BFu7s_BFu31ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu32i_B  {
  unsigned short v1:7;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 BFu7s_BFu32i_B) C1{ Fs:7 Fi:32 Fc}



static void Test_BFu7s_BFu32i_B()
{
  {
    init_simple_test("BFu7s_BFu32i_B");
    static BFu7s_BFu32i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7s_BFu32i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu7s_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu7s_BFu32i_B");
    check_field_offset(lv, v3, 8, "BFu7s_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu32i_B(Test_BFu7s_BFu32i_B, "BFu7s_BFu32i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu32ll_B  {
  unsigned short v1:7;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 BFu7s_BFu32ll_B) C1{ Fs:7 FL:32 Fc}



static void Test_BFu7s_BFu32ll_B()
{
  {
    init_simple_test("BFu7s_BFu32ll_B");
    static BFu7s_BFu32ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7s_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu7s_BFu32ll_B");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu7s_BFu32ll_B");
    check_field_offset(lv, v3, 5, "BFu7s_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu32ll_B(Test_BFu7s_BFu32ll_B, "BFu7s_BFu32ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu33_B  {
  unsigned short v1:7;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 BFu7s_BFu33_B) C1{ Fs:7 FL:33 Fc}



static void Test_BFu7s_BFu33_B()
{
  {
    init_simple_test("BFu7s_BFu33_B");
    static BFu7s_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu7s_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu7s_BFu33_B");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu7s_BFu33_B");
    check_field_offset(lv, v3, 5, "BFu7s_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu33_B(Test_BFu7s_BFu33_B, "BFu7s_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu7c_B  {
  unsigned short v1:7;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 BFu7s_BFu7c_B) C1{ Fs:7 Fc:7 Fc}



static void Test_BFu7s_BFu7c_B()
{
  {
    init_simple_test("BFu7s_BFu7c_B");
    static BFu7s_BFu7c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_BFu7c_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu7s_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu7c_B");
    check_field_offset(lv, v3, 2, "BFu7s_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu7c_B(Test_BFu7s_BFu7c_B, "BFu7s_BFu7c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu7i_B  {
  unsigned short v1:7;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 BFu7s_BFu7i_B) C1{ Fs:7 Fi:7 Fc}



static void Test_BFu7s_BFu7i_B()
{
  {
    init_simple_test("BFu7s_BFu7i_B");
    static BFu7s_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_BFu7i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7s_BFu7i_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7s_BFu7i_B");
    check_field_offset(lv, v3, 2, "BFu7s_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu7i_B(Test_BFu7s_BFu7i_B, "BFu7s_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu7ll_B  {
  unsigned short v1:7;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 BFu7s_BFu7ll_B) C1{ Fs:7 FL:7 Fc}



static void Test_BFu7s_BFu7ll_B()
{
  {
    init_simple_test("BFu7s_BFu7ll_B");
    static BFu7s_BFu7ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7s_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7s_BFu7ll_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7s_BFu7ll_B");
    check_field_offset(lv, v3, 2, "BFu7s_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu7ll_B(Test_BFu7s_BFu7ll_B, "BFu7s_BFu7ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu7s_B  {
  unsigned short v1:7;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 BFu7s_BFu7s_B) C1{ Fs:7 Fs:7 Fc}



static void Test_BFu7s_BFu7s_B()
{
  {
    init_simple_test("BFu7s_BFu7s_B");
    static BFu7s_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_BFu7s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu7s_BFu7s_B");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu7s_BFu7s_B");
    check_field_offset(lv, v3, 2, "BFu7s_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu7s_B(Test_BFu7s_BFu7s_B, "BFu7s_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu8c_B  {
  unsigned short v1:7;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 BFu7s_BFu8c_B) C1{ Fs:7 Fc:8 Fc}



static void Test_BFu7s_BFu8c_B()
{
  {
    init_simple_test("BFu7s_BFu8c_B");
    static BFu7s_BFu8c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_BFu8c_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu7s_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu7s_BFu8c_B");
    check_field_offset(lv, v3, 2, "BFu7s_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu8c_B(Test_BFu7s_BFu8c_B, "BFu7s_BFu8c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu8i_B  {
  unsigned short v1:7;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 BFu7s_BFu8i_B) C1{ Fs:7 Fi:8 Fc}



static void Test_BFu7s_BFu8i_B()
{
  {
    init_simple_test("BFu7s_BFu8i_B");
    static BFu7s_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_BFu8i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7s_BFu8i_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7s_BFu8i_B");
    check_field_offset(lv, v3, 2, "BFu7s_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu8i_B(Test_BFu7s_BFu8i_B, "BFu7s_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu8ll_B  {
  unsigned short v1:7;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 BFu7s_BFu8ll_B) C1{ Fs:7 FL:8 Fc}



static void Test_BFu7s_BFu8ll_B()
{
  {
    init_simple_test("BFu7s_BFu8ll_B");
    static BFu7s_BFu8ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7s_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7s_BFu8ll_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7s_BFu8ll_B");
    check_field_offset(lv, v3, 2, "BFu7s_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu8ll_B(Test_BFu7s_BFu8ll_B, "BFu7s_BFu8ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu8s_B  {
  unsigned short v1:7;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 BFu7s_BFu8s_B) C1{ Fs:7 Fs:8 Fc}



static void Test_BFu7s_BFu8s_B()
{
  {
    init_simple_test("BFu7s_BFu8s_B");
    static BFu7s_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_BFu8s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu7s_BFu8s_B");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu7s_BFu8s_B");
    check_field_offset(lv, v3, 2, "BFu7s_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu8s_B(Test_BFu7s_BFu8s_B, "BFu7s_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu9i_B  {
  unsigned short v1:7;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 BFu7s_BFu9i_B) C1{ Fs:7 Fi:9 Fc}



static void Test_BFu7s_BFu9i_B()
{
  {
    init_simple_test("BFu7s_BFu9i_B");
    static BFu7s_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_BFu9i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7s_BFu9i_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7s_BFu9i_B");
    check_field_offset(lv, v3, 2, "BFu7s_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu9i_B(Test_BFu7s_BFu9i_B, "BFu7s_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu9ll_B  {
  unsigned short v1:7;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 BFu7s_BFu9ll_B) C1{ Fs:7 FL:9 Fc}



static void Test_BFu7s_BFu9ll_B()
{
  {
    init_simple_test("BFu7s_BFu9ll_B");
    static BFu7s_BFu9ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu7s_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7s_BFu9ll_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7s_BFu9ll_B");
    check_field_offset(lv, v3, 2, "BFu7s_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu9ll_B(Test_BFu7s_BFu9ll_B, "BFu7s_BFu9ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_BFu9s_B  {
  unsigned short v1:7;
  unsigned short v2:9;
  bool v3;
};
//SIG(1 BFu7s_BFu9s_B) C1{ Fs:7 Fs:9 Fc}



static void Test_BFu7s_BFu9s_B()
{
  {
    init_simple_test("BFu7s_BFu9s_B");
    static BFu7s_BFu9s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_BFu9s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu7s_BFu9s_B");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu7s_BFu9s_B");
    check_field_offset(lv, v3, 2, "BFu7s_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_BFu9s_B(Test_BFu7s_BFu9s_B, "BFu7s_BFu9s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_C_B  {
  unsigned short v1:7;
  char v2;
  bool v3;
};
//SIG(1 BFu7s_C_B) C1{ Fs:7 Fc[2]}



static void Test_BFu7s_C_B()
{
  {
    init_simple_test("BFu7s_C_B");
    static BFu7s_C_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_C_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_C_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_C_B");
    check_field_offset(lv, v2, 1, "BFu7s_C_B.v2");
    check_field_offset(lv, v3, 2, "BFu7s_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_C_B(Test_BFu7s_C_B, "BFu7s_C_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_D_B  {
  unsigned short v1:7;
  double v2;
  bool v3;
};
//SIG(1 BFu7s_D_B) C1{ Fs:7 FL Fc}



static void Test_BFu7s_D_B()
{
  {
    init_simple_test("BFu7s_D_B");
    static BFu7s_D_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu7s_D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_D_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_D_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7s_D_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu7s_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_D_B(Test_BFu7s_D_B, "BFu7s_D_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_F_B  {
  unsigned short v1:7;
  float v2;
  bool v3;
};
//SIG(1 BFu7s_F_B) C1{ Fs:7 Fi Fc}



static void Test_BFu7s_F_B()
{
  {
    init_simple_test("BFu7s_F_B");
    static BFu7s_F_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7s_F_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_F_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_F_B");
    check_field_offset(lv, v2, 4, "BFu7s_F_B.v2");
    check_field_offset(lv, v3, 8, "BFu7s_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_F_B(Test_BFu7s_F_B, "BFu7s_F_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_I_B  {
  unsigned short v1:7;
  int v2;
  bool v3;
};
//SIG(1 BFu7s_I_B) C1{ Fs:7 Fi Fc}



static void Test_BFu7s_I_B()
{
  {
    init_simple_test("BFu7s_I_B");
    static BFu7s_I_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7s_I_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_I_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_I_B");
    check_field_offset(lv, v2, 4, "BFu7s_I_B.v2");
    check_field_offset(lv, v3, 8, "BFu7s_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_I_B(Test_BFu7s_I_B, "BFu7s_I_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_Ip_B  {
  unsigned short v1:7;
  int *v2;
  bool v3;
};
//SIG(1 BFu7s_Ip_B) C1{ Fs:7 Fp Fc}



static void Test_BFu7s_Ip_B()
{
  {
    init_simple_test("BFu7s_Ip_B");
    static BFu7s_Ip_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu7s_Ip_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Ip_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7s_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu7s_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_Ip_B(Test_BFu7s_Ip_B, "BFu7s_Ip_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_L_B  {
  unsigned short v1:7;
  __tsi64 v2;
  bool v3;
};
//SIG(1 BFu7s_L_B) C1{ Fs:7 FL Fc}



static void Test_BFu7s_L_B()
{
  {
    init_simple_test("BFu7s_L_B");
    static BFu7s_L_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu7s_L_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_L_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_L_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7s_L_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu7s_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_L_B(Test_BFu7s_L_B, "BFu7s_L_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_S_B  {
  unsigned short v1:7;
  short v2;
  bool v3;
};
//SIG(1 BFu7s_S_B) C1{ Fs:7 Fs Fc}



static void Test_BFu7s_S_B()
{
  {
    init_simple_test("BFu7s_S_B");
    static BFu7s_S_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu7s_S_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_S_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_S_B");
    check_field_offset(lv, v2, 2, "BFu7s_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu7s_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_S_B(Test_BFu7s_S_B, "BFu7s_S_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_Uc_B  {
  unsigned short v1:7;
  unsigned char v2;
  bool v3;
};
//SIG(1 BFu7s_Uc_B) C1{ Fs:7 Fc[2]}



static void Test_BFu7s_Uc_B()
{
  {
    init_simple_test("BFu7s_Uc_B");
    static BFu7s_Uc_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu7s_Uc_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Uc_B");
    check_field_offset(lv, v2, 1, "BFu7s_Uc_B.v2");
    check_field_offset(lv, v3, 2, "BFu7s_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_Uc_B(Test_BFu7s_Uc_B, "BFu7s_Uc_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_Ui_B  {
  unsigned short v1:7;
  unsigned int v2;
  bool v3;
};
//SIG(1 BFu7s_Ui_B) C1{ Fs:7 Fi Fc}



static void Test_BFu7s_Ui_B()
{
  {
    init_simple_test("BFu7s_Ui_B");
    static BFu7s_Ui_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu7s_Ui_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu7s_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Ui_B");
    check_field_offset(lv, v2, 4, "BFu7s_Ui_B.v2");
    check_field_offset(lv, v3, 8, "BFu7s_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_Ui_B(Test_BFu7s_Ui_B, "BFu7s_Ui_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_Ul_B  {
  unsigned short v1:7;
  __tsu64 v2;
  bool v3;
};
//SIG(1 BFu7s_Ul_B) C1{ Fs:7 FL Fc}



static void Test_BFu7s_Ul_B()
{
  {
    init_simple_test("BFu7s_Ul_B");
    static BFu7s_Ul_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu7s_Ul_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Ul_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7s_Ul_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu7s_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_Ul_B(Test_BFu7s_Ul_B, "BFu7s_Ul_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_Us_B  {
  unsigned short v1:7;
  unsigned short v2;
  bool v3;
};
//SIG(1 BFu7s_Us_B) C1{ Fs:7 Fs Fc}



static void Test_BFu7s_Us_B()
{
  {
    init_simple_test("BFu7s_Us_B");
    static BFu7s_Us_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu7s_Us_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu7s_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Us_B");
    check_field_offset(lv, v2, 2, "BFu7s_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu7s_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_Us_B(Test_BFu7s_Us_B, "BFu7s_Us_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu7s_Vp_B  {
  unsigned short v1:7;
  void *v2;
  bool v3;
};
//SIG(1 BFu7s_Vp_B) C1{ Fs:7 Fp Fc}



static void Test_BFu7s_Vp_B()
{
  {
    init_simple_test("BFu7s_Vp_B");
    static BFu7s_Vp_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu7s_Vp_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu7s_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu7s_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu7s_Vp_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu7s_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu7s_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu7s_Vp_B(Test_BFu7s_Vp_B, "BFu7s_Vp_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B  {
  unsigned char v1:8;
  bool v2;
};
//SIG(1 BFu8c_B) C1{ Fc:8 Fc}



static void Test_BFu8c_B()
{
  {
    init_simple_test("BFu8c_B");
    static BFu8c_B lv;
    check2(sizeof(lv), 2, "sizeof(BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B");
    check_field_offset(lv, v2, 1, "BFu8c_B.v2");
  }
}
static Arrange_To_Call_Me vBFu8c_B(Test_BFu8c_B, "BFu8c_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_B  {
  unsigned char v1:8;
  bool v2;
  bool v3;
};
//SIG(1 BFu8c_B_B) C1{ Fc:8 Fc[2]}



static void Test_BFu8c_B_B()
{
  {
    init_simple_test("BFu8c_B_B");
    static BFu8c_B_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_B");
    check_field_offset(lv, v2, 1, "BFu8c_B_B.v2");
    check_field_offset(lv, v3, 2, "BFu8c_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_B_B(Test_BFu8c_B_B, "BFu8c_B_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu15i  {
  unsigned char v1:8;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 BFu8c_B_BFu15i) C1{ Fc:8 Fc Fi:15}



static void Test_BFu8c_B_BFu15i()
{
  {
    init_simple_test("BFu8c_B_BFu15i");
    static BFu8c_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_B_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu15i");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8c_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8c_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu15i(Test_BFu8c_B_BFu15i, "BFu8c_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu15ll  {
  unsigned char v1:8;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 BFu8c_B_BFu15ll) C1{ Fc:8 Fc FL:15}



static void Test_BFu8c_B_BFu15ll()
{
  {
    init_simple_test("BFu8c_B_BFu15ll");
    static BFu8c_B_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8c_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8c_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8c_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu15ll(Test_BFu8c_B_BFu15ll, "BFu8c_B_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu15s  {
  unsigned char v1:8;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 BFu8c_B_BFu15s) C1{ Fc:8 Fc Fs:15}



static void Test_BFu8c_B_BFu15s()
{
  {
    init_simple_test("BFu8c_B_BFu15s");
    static BFu8c_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_B_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu15s");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8c_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8c_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu15s(Test_BFu8c_B_BFu15s, "BFu8c_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu16i  {
  unsigned char v1:8;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 BFu8c_B_BFu16i) C1{ Fc:8 Fc Fi:16}



static void Test_BFu8c_B_BFu16i()
{
  {
    init_simple_test("BFu8c_B_BFu16i");
    static BFu8c_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_B_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu16i");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8c_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8c_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu16i(Test_BFu8c_B_BFu16i, "BFu8c_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu16ll  {
  unsigned char v1:8;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 BFu8c_B_BFu16ll) C1{ Fc:8 Fc FL:16}



static void Test_BFu8c_B_BFu16ll()
{
  {
    init_simple_test("BFu8c_B_BFu16ll");
    static BFu8c_B_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8c_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8c_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8c_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu16ll(Test_BFu8c_B_BFu16ll, "BFu8c_B_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu16s  {
  unsigned char v1:8;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 BFu8c_B_BFu16s) C1{ Fc:8 Fc Fs:16}



static void Test_BFu8c_B_BFu16s()
{
  {
    init_simple_test("BFu8c_B_BFu16s");
    static BFu8c_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_B_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu16s");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8c_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8c_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu16s(Test_BFu8c_B_BFu16s, "BFu8c_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu17i  {
  unsigned char v1:8;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 BFu8c_B_BFu17i) C1{ Fc:8 Fc Fi:17}



static void Test_BFu8c_B_BFu17i()
{
  {
    init_simple_test("BFu8c_B_BFu17i");
    static BFu8c_B_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_B_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu17i");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu8c_B_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu8c_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu17i(Test_BFu8c_B_BFu17i, "BFu8c_B_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu17ll  {
  unsigned char v1:8;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 BFu8c_B_BFu17ll) C1{ Fc:8 Fc FL:17}



static void Test_BFu8c_B_BFu17ll()
{
  {
    init_simple_test("BFu8c_B_BFu17ll");
    static BFu8c_B_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu8c_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu8c_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu17ll(Test_BFu8c_B_BFu17ll, "BFu8c_B_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu1c  {
  unsigned char v1:8;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 BFu8c_B_BFu1c) C1{ Fc:8 Fc Fc:1}



static void Test_BFu8c_B_BFu1c()
{
  {
    init_simple_test("BFu8c_B_BFu1c");
    static BFu8c_B_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu1c");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8c_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu1c(Test_BFu8c_B_BFu1c, "BFu8c_B_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu1i  {
  unsigned char v1:8;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 BFu8c_B_BFu1i) C1{ Fc:8 Fc Fi:1}



static void Test_BFu8c_B_BFu1i()
{
  {
    init_simple_test("BFu8c_B_BFu1i");
    static BFu8c_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_B_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu1i");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8c_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu1i(Test_BFu8c_B_BFu1i, "BFu8c_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu1ll  {
  unsigned char v1:8;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 BFu8c_B_BFu1ll) C1{ Fc:8 Fc FL:1}



static void Test_BFu8c_B_BFu1ll()
{
  {
    init_simple_test("BFu8c_B_BFu1ll");
    static BFu8c_B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8c_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8c_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu1ll(Test_BFu8c_B_BFu1ll, "BFu8c_B_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu1s  {
  unsigned char v1:8;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 BFu8c_B_BFu1s) C1{ Fc:8 Fc Fs:1}



static void Test_BFu8c_B_BFu1s()
{
  {
    init_simple_test("BFu8c_B_BFu1s");
    static BFu8c_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_B_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu1s");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8c_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu1s(Test_BFu8c_B_BFu1s, "BFu8c_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu31i  {
  unsigned char v1:8;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 BFu8c_B_BFu31i) C1{ Fc:8 Fc Fi:31}



static void Test_BFu8c_B_BFu31i()
{
  {
    init_simple_test("BFu8c_B_BFu31i");
    static BFu8c_B_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_B_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu31i");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8c_B_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8c_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu31i(Test_BFu8c_B_BFu31i, "BFu8c_B_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu31ll  {
  unsigned char v1:8;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 BFu8c_B_BFu31ll) C1{ Fc:8 Fc FL:31}



static void Test_BFu8c_B_BFu31ll()
{
  {
    init_simple_test("BFu8c_B_BFu31ll");
    static BFu8c_B_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu8c_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu8c_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu31ll(Test_BFu8c_B_BFu31ll, "BFu8c_B_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu32i  {
  unsigned char v1:8;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 BFu8c_B_BFu32i) C1{ Fc:8 Fc Fi:32}



static void Test_BFu8c_B_BFu32i()
{
  {
    init_simple_test("BFu8c_B_BFu32i");
    static BFu8c_B_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_B_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu32i");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8c_B_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8c_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu32i(Test_BFu8c_B_BFu32i, "BFu8c_B_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu32ll  {
  unsigned char v1:8;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 BFu8c_B_BFu32ll) C1{ Fc:8 Fc FL:32}



static void Test_BFu8c_B_BFu32ll()
{
  {
    init_simple_test("BFu8c_B_BFu32ll");
    static BFu8c_B_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu8c_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu8c_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu32ll(Test_BFu8c_B_BFu32ll, "BFu8c_B_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu33  {
  unsigned char v1:8;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 BFu8c_B_BFu33) C1{ Fc:8 Fc FL:33}



static void Test_BFu8c_B_BFu33()
{
  {
    init_simple_test("BFu8c_B_BFu33");
    static BFu8c_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu33");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu8c_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu8c_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu33(Test_BFu8c_B_BFu33, "BFu8c_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu7c  {
  unsigned char v1:8;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 BFu8c_B_BFu7c) C1{ Fc:8 Fc Fc:7}



static void Test_BFu8c_B_BFu7c()
{
  {
    init_simple_test("BFu8c_B_BFu7c");
    static BFu8c_B_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu7c");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8c_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8c_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu7c(Test_BFu8c_B_BFu7c, "BFu8c_B_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu7i  {
  unsigned char v1:8;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 BFu8c_B_BFu7i) C1{ Fc:8 Fc Fi:7}



static void Test_BFu8c_B_BFu7i()
{
  {
    init_simple_test("BFu8c_B_BFu7i");
    static BFu8c_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_B_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu7i");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8c_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8c_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu7i(Test_BFu8c_B_BFu7i, "BFu8c_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu7ll  {
  unsigned char v1:8;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 BFu8c_B_BFu7ll) C1{ Fc:8 Fc FL:7}



static void Test_BFu8c_B_BFu7ll()
{
  {
    init_simple_test("BFu8c_B_BFu7ll");
    static BFu8c_B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8c_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8c_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8c_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu7ll(Test_BFu8c_B_BFu7ll, "BFu8c_B_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu7s  {
  unsigned char v1:8;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 BFu8c_B_BFu7s) C1{ Fc:8 Fc Fs:7}



static void Test_BFu8c_B_BFu7s()
{
  {
    init_simple_test("BFu8c_B_BFu7s");
    static BFu8c_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_B_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu7s");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8c_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8c_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu7s(Test_BFu8c_B_BFu7s, "BFu8c_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu8c  {
  unsigned char v1:8;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 BFu8c_B_BFu8c) C1{ Fc:8 Fc Fc:8}



static void Test_BFu8c_B_BFu8c()
{
  {
    init_simple_test("BFu8c_B_BFu8c");
    static BFu8c_B_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu8c");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8c_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu8c(Test_BFu8c_B_BFu8c, "BFu8c_B_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu8i  {
  unsigned char v1:8;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 BFu8c_B_BFu8i) C1{ Fc:8 Fc Fi:8}



static void Test_BFu8c_B_BFu8i()
{
  {
    init_simple_test("BFu8c_B_BFu8i");
    static BFu8c_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_B_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu8i");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8c_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu8i(Test_BFu8c_B_BFu8i, "BFu8c_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu8ll  {
  unsigned char v1:8;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 BFu8c_B_BFu8ll) C1{ Fc:8 Fc FL:8}



static void Test_BFu8c_B_BFu8ll()
{
  {
    init_simple_test("BFu8c_B_BFu8ll");
    static BFu8c_B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8c_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8c_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu8ll(Test_BFu8c_B_BFu8ll, "BFu8c_B_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu8s  {
  unsigned char v1:8;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 BFu8c_B_BFu8s) C1{ Fc:8 Fc Fs:8}



static void Test_BFu8c_B_BFu8s()
{
  {
    init_simple_test("BFu8c_B_BFu8s");
    static BFu8c_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_B_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu8s");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8c_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu8s(Test_BFu8c_B_BFu8s, "BFu8c_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu9i  {
  unsigned char v1:8;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 BFu8c_B_BFu9i) C1{ Fc:8 Fc Fi:9}



static void Test_BFu8c_B_BFu9i()
{
  {
    init_simple_test("BFu8c_B_BFu9i");
    static BFu8c_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_B_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu9i");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8c_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8c_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu9i(Test_BFu8c_B_BFu9i, "BFu8c_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu9ll  {
  unsigned char v1:8;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 BFu8c_B_BFu9ll) C1{ Fc:8 Fc FL:9}



static void Test_BFu8c_B_BFu9ll()
{
  {
    init_simple_test("BFu8c_B_BFu9ll");
    static BFu8c_B_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8c_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8c_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8c_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu9ll(Test_BFu8c_B_BFu9ll, "BFu8c_B_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_BFu9s  {
  unsigned char v1:8;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 BFu8c_B_BFu9s) C1{ Fc:8 Fc Fs:9}



static void Test_BFu8c_B_BFu9s()
{
  {
    init_simple_test("BFu8c_B_BFu9s");
    static BFu8c_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_B_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_BFu9s");
    check_field_offset(lv, v2, 1, "BFu8c_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8c_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8c_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu8c_B_BFu9s(Test_BFu8c_B_BFu9s, "BFu8c_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_C  {
  unsigned char v1:8;
  bool v2;
  char v3;
};
//SIG(1 BFu8c_B_C) C1{ Fc:8 Fc[2]}



static void Test_BFu8c_B_C()
{
  {
    init_simple_test("BFu8c_B_C");
    static BFu8c_B_C lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_C");
    check_field_offset(lv, v2, 1, "BFu8c_B_C.v2");
    check_field_offset(lv, v3, 2, "BFu8c_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_B_C(Test_BFu8c_B_C, "BFu8c_B_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_D  {
  unsigned char v1:8;
  bool v2;
  double v3;
};
//SIG(1 BFu8c_B_D) C1{ Fc:8 Fc FL}



static void Test_BFu8c_B_D()
{
  {
    init_simple_test("BFu8c_B_D");
    static BFu8c_B_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8c_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_D");
    check_field_offset(lv, v2, 1, "BFu8c_B_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8c_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_B_D(Test_BFu8c_B_D, "BFu8c_B_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_F  {
  unsigned char v1:8;
  bool v2;
  float v3;
};
//SIG(1 BFu8c_B_F) C1{ Fc:8 Fc Fi}



static void Test_BFu8c_B_F()
{
  {
    init_simple_test("BFu8c_B_F");
    static BFu8c_B_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_B_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_F");
    check_field_offset(lv, v2, 1, "BFu8c_B_F.v2");
    check_field_offset(lv, v3, 4, "BFu8c_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_B_F(Test_BFu8c_B_F, "BFu8c_B_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_I  {
  unsigned char v1:8;
  bool v2;
  int v3;
};
//SIG(1 BFu8c_B_I) C1{ Fc:8 Fc Fi}



static void Test_BFu8c_B_I()
{
  {
    init_simple_test("BFu8c_B_I");
    static BFu8c_B_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_B_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_I");
    check_field_offset(lv, v2, 1, "BFu8c_B_I.v2");
    check_field_offset(lv, v3, 4, "BFu8c_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_B_I(Test_BFu8c_B_I, "BFu8c_B_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_Ip  {
  unsigned char v1:8;
  bool v2;
  int *v3;
};
//SIG(1 BFu8c_B_Ip) C1{ Fc:8 Fc Fp}



static void Test_BFu8c_B_Ip()
{
  {
    init_simple_test("BFu8c_B_Ip");
    static BFu8c_B_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8c_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_Ip");
    check_field_offset(lv, v2, 1, "BFu8c_B_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8c_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_B_Ip(Test_BFu8c_B_Ip, "BFu8c_B_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_L  {
  unsigned char v1:8;
  bool v2;
  __tsi64 v3;
};
//SIG(1 BFu8c_B_L) C1{ Fc:8 Fc FL}



static void Test_BFu8c_B_L()
{
  {
    init_simple_test("BFu8c_B_L");
    static BFu8c_B_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8c_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_L");
    check_field_offset(lv, v2, 1, "BFu8c_B_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8c_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_B_L(Test_BFu8c_B_L, "BFu8c_B_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_S  {
  unsigned char v1:8;
  bool v2;
  short v3;
};
//SIG(1 BFu8c_B_S) C1{ Fc:8 Fc Fs}



static void Test_BFu8c_B_S()
{
  {
    init_simple_test("BFu8c_B_S");
    static BFu8c_B_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_B_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_S");
    check_field_offset(lv, v2, 1, "BFu8c_B_S.v2");
    check_field_offset(lv, v3, 2, "BFu8c_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_B_S(Test_BFu8c_B_S, "BFu8c_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_Uc  {
  unsigned char v1:8;
  bool v2;
  unsigned char v3;
};
//SIG(1 BFu8c_B_Uc) C1{ Fc:8 Fc[2]}



static void Test_BFu8c_B_Uc()
{
  {
    init_simple_test("BFu8c_B_Uc");
    static BFu8c_B_Uc lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_Uc");
    check_field_offset(lv, v2, 1, "BFu8c_B_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu8c_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_B_Uc(Test_BFu8c_B_Uc, "BFu8c_B_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_Ui  {
  unsigned char v1:8;
  bool v2;
  unsigned int v3;
};
//SIG(1 BFu8c_B_Ui) C1{ Fc:8 Fc Fi}



static void Test_BFu8c_B_Ui()
{
  {
    init_simple_test("BFu8c_B_Ui");
    static BFu8c_B_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_B_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_Ui");
    check_field_offset(lv, v2, 1, "BFu8c_B_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu8c_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_B_Ui(Test_BFu8c_B_Ui, "BFu8c_B_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_Ul  {
  unsigned char v1:8;
  bool v2;
  __tsu64 v3;
};
//SIG(1 BFu8c_B_Ul) C1{ Fc:8 Fc FL}



static void Test_BFu8c_B_Ul()
{
  {
    init_simple_test("BFu8c_B_Ul");
    static BFu8c_B_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8c_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_Ul");
    check_field_offset(lv, v2, 1, "BFu8c_B_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8c_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_B_Ul(Test_BFu8c_B_Ul, "BFu8c_B_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_Us  {
  unsigned char v1:8;
  bool v2;
  unsigned short v3;
};
//SIG(1 BFu8c_B_Us) C1{ Fc:8 Fc Fs}



static void Test_BFu8c_B_Us()
{
  {
    init_simple_test("BFu8c_B_Us");
    static BFu8c_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_B_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_Us");
    check_field_offset(lv, v2, 1, "BFu8c_B_Us.v2");
    check_field_offset(lv, v3, 2, "BFu8c_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_B_Us(Test_BFu8c_B_Us, "BFu8c_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_B_Vp  {
  unsigned char v1:8;
  bool v2;
  void *v3;
};
//SIG(1 BFu8c_B_Vp) C1{ Fc:8 Fc Fp}



static void Test_BFu8c_B_Vp()
{
  {
    init_simple_test("BFu8c_B_Vp");
    static BFu8c_B_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8c_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_B_Vp");
    check_field_offset(lv, v2, 1, "BFu8c_B_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8c_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_B_Vp(Test_BFu8c_B_Vp, "BFu8c_B_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu15i_B  {
  unsigned char v1:8;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 BFu8c_BFu15i_B) C1{ Fc:8 Fi:15 Fc}



static void Test_BFu8c_BFu15i_B()
{
  {
    init_simple_test("BFu8c_BFu15i_B");
    static BFu8c_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_BFu15i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8c_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8c_BFu15i_B");
    check_field_offset(lv, v3, 3, "BFu8c_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu15i_B(Test_BFu8c_BFu15i_B, "BFu8c_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu15ll_B  {
  unsigned char v1:8;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 BFu8c_BFu15ll_B) C1{ Fc:8 FL:15 Fc}



static void Test_BFu8c_BFu15ll_B()
{
  {
    init_simple_test("BFu8c_BFu15ll_B");
    static BFu8c_BFu15ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8c_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8c_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8c_BFu15ll_B");
    check_field_offset(lv, v3, 3, "BFu8c_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu15ll_B(Test_BFu8c_BFu15ll_B, "BFu8c_BFu15ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu15s_B  {
  unsigned char v1:8;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 BFu8c_BFu15s_B) C1{ Fc:8 Fs:15 Fc}



static void Test_BFu8c_BFu15s_B()
{
  {
    init_simple_test("BFu8c_BFu15s_B");
    static BFu8c_BFu15s_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu8c_BFu15s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu8c_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu8c_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu8c_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu15s_B(Test_BFu8c_BFu15s_B, "BFu8c_BFu15s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu16i_B  {
  unsigned char v1:8;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 BFu8c_BFu16i_B) C1{ Fc:8 Fi:16 Fc}



static void Test_BFu8c_BFu16i_B()
{
  {
    init_simple_test("BFu8c_BFu16i_B");
    static BFu8c_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_BFu16i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8c_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8c_BFu16i_B");
    check_field_offset(lv, v3, 3, "BFu8c_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu16i_B(Test_BFu8c_BFu16i_B, "BFu8c_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu16ll_B  {
  unsigned char v1:8;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 BFu8c_BFu16ll_B) C1{ Fc:8 FL:16 Fc}



static void Test_BFu8c_BFu16ll_B()
{
  {
    init_simple_test("BFu8c_BFu16ll_B");
    static BFu8c_BFu16ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8c_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8c_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8c_BFu16ll_B");
    check_field_offset(lv, v3, 3, "BFu8c_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu16ll_B(Test_BFu8c_BFu16ll_B, "BFu8c_BFu16ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu16s_B  {
  unsigned char v1:8;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 BFu8c_BFu16s_B) C1{ Fc:8 Fs:16 Fc}



static void Test_BFu8c_BFu16s_B()
{
  {
    init_simple_test("BFu8c_BFu16s_B");
    static BFu8c_BFu16s_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu8c_BFu16s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu8c_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu8c_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu8c_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu16s_B(Test_BFu8c_BFu16s_B, "BFu8c_BFu16s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu17i_B  {
  unsigned char v1:8;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 BFu8c_BFu17i_B) C1{ Fc:8 Fi:17 Fc}



static void Test_BFu8c_BFu17i_B()
{
  {
    init_simple_test("BFu8c_BFu17i_B");
    static BFu8c_BFu17i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_BFu17i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8c_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8c_BFu17i_B");
    check_field_offset(lv, v3, 4, "BFu8c_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu17i_B(Test_BFu8c_BFu17i_B, "BFu8c_BFu17i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu17ll_B  {
  unsigned char v1:8;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 BFu8c_BFu17ll_B) C1{ Fc:8 FL:17 Fc}



static void Test_BFu8c_BFu17ll_B()
{
  {
    init_simple_test("BFu8c_BFu17ll_B");
    static BFu8c_BFu17ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8c_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8c_BFu17ll_B");
    check_field_offset(lv, v3, 4, "BFu8c_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu17ll_B(Test_BFu8c_BFu17ll_B, "BFu8c_BFu17ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu1c_B  {
  unsigned char v1:8;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 BFu8c_BFu1c_B) C1{ Fc:8 Fc:1 Fc}



static void Test_BFu8c_BFu1c_B()
{
  {
    init_simple_test("BFu8c_BFu1c_B");
    static BFu8c_BFu1c_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8c_BFu1c_B");
    check_field_offset(lv, v3, 2, "BFu8c_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu1c_B(Test_BFu8c_BFu1c_B, "BFu8c_BFu1c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu1i_B  {
  unsigned char v1:8;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 BFu8c_BFu1i_B) C1{ Fc:8 Fi:1 Fc}



static void Test_BFu8c_BFu1i_B()
{
  {
    init_simple_test("BFu8c_BFu1i_B");
    static BFu8c_BFu1i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_BFu1i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8c_BFu1i_B");
    check_field_offset(lv, v3, 2, "BFu8c_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu1i_B(Test_BFu8c_BFu1i_B, "BFu8c_BFu1i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu1ll_B  {
  unsigned char v1:8;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 BFu8c_BFu1ll_B) C1{ Fc:8 FL:1 Fc}



static void Test_BFu8c_BFu1ll_B()
{
  {
    init_simple_test("BFu8c_BFu1ll_B");
    static BFu8c_BFu1ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8c_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8c_BFu1ll_B");
    check_field_offset(lv, v3, 2, "BFu8c_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu1ll_B(Test_BFu8c_BFu1ll_B, "BFu8c_BFu1ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu1s_B  {
  unsigned char v1:8;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 BFu8c_BFu1s_B) C1{ Fc:8 Fs:1 Fc}



static void Test_BFu8c_BFu1s_B()
{
  {
    init_simple_test("BFu8c_BFu1s_B");
    static BFu8c_BFu1s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_BFu1s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8c_BFu1s_B");
    check_field_offset(lv, v3, 2, "BFu8c_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu1s_B(Test_BFu8c_BFu1s_B, "BFu8c_BFu1s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu31i_B  {
  unsigned char v1:8;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 BFu8c_BFu31i_B) C1{ Fc:8 Fi:31 Fc}



static void Test_BFu8c_BFu31i_B()
{
  {
    init_simple_test("BFu8c_BFu31i_B");
    static BFu8c_BFu31i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8c_BFu31i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu8c_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu8c_BFu31i_B");
    check_field_offset(lv, v3, 8, "BFu8c_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu31i_B(Test_BFu8c_BFu31i_B, "BFu8c_BFu31i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu31ll_B  {
  unsigned char v1:8;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 BFu8c_BFu31ll_B) C1{ Fc:8 FL:31 Fc}



static void Test_BFu8c_BFu31ll_B()
{
  {
    init_simple_test("BFu8c_BFu31ll_B");
    static BFu8c_BFu31ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu8c_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu8c_BFu31ll_B");
    check_field_offset(lv, v3, 5, "BFu8c_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu31ll_B(Test_BFu8c_BFu31ll_B, "BFu8c_BFu31ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu32i_B  {
  unsigned char v1:8;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 BFu8c_BFu32i_B) C1{ Fc:8 Fi:32 Fc}



static void Test_BFu8c_BFu32i_B()
{
  {
    init_simple_test("BFu8c_BFu32i_B");
    static BFu8c_BFu32i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8c_BFu32i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu8c_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu8c_BFu32i_B");
    check_field_offset(lv, v3, 8, "BFu8c_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu32i_B(Test_BFu8c_BFu32i_B, "BFu8c_BFu32i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu32ll_B  {
  unsigned char v1:8;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 BFu8c_BFu32ll_B) C1{ Fc:8 FL:32 Fc}



static void Test_BFu8c_BFu32ll_B()
{
  {
    init_simple_test("BFu8c_BFu32ll_B");
    static BFu8c_BFu32ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu8c_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu8c_BFu32ll_B");
    check_field_offset(lv, v3, 5, "BFu8c_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu32ll_B(Test_BFu8c_BFu32ll_B, "BFu8c_BFu32ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu33_B  {
  unsigned char v1:8;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 BFu8c_BFu33_B) C1{ Fc:8 FL:33 Fc}



static void Test_BFu8c_BFu33_B()
{
  {
    init_simple_test("BFu8c_BFu33_B");
    static BFu8c_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8c_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8c_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8c_BFu33_B");
    check_field_offset(lv, v3, 6, "BFu8c_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu33_B(Test_BFu8c_BFu33_B, "BFu8c_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu7c_B  {
  unsigned char v1:8;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 BFu8c_BFu7c_B) C1{ Fc:8 Fc:7 Fc}



static void Test_BFu8c_BFu7c_B()
{
  {
    init_simple_test("BFu8c_BFu7c_B");
    static BFu8c_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8c_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8c_BFu7c_B");
    check_field_offset(lv, v3, 2, "BFu8c_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu7c_B(Test_BFu8c_BFu7c_B, "BFu8c_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu7i_B  {
  unsigned char v1:8;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 BFu8c_BFu7i_B) C1{ Fc:8 Fi:7 Fc}



static void Test_BFu8c_BFu7i_B()
{
  {
    init_simple_test("BFu8c_BFu7i_B");
    static BFu8c_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_BFu7i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8c_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8c_BFu7i_B");
    check_field_offset(lv, v3, 2, "BFu8c_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu7i_B(Test_BFu8c_BFu7i_B, "BFu8c_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu7ll_B  {
  unsigned char v1:8;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 BFu8c_BFu7ll_B) C1{ Fc:8 FL:7 Fc}



static void Test_BFu8c_BFu7ll_B()
{
  {
    init_simple_test("BFu8c_BFu7ll_B");
    static BFu8c_BFu7ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8c_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8c_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8c_BFu7ll_B");
    check_field_offset(lv, v3, 2, "BFu8c_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu7ll_B(Test_BFu8c_BFu7ll_B, "BFu8c_BFu7ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu7s_B  {
  unsigned char v1:8;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 BFu8c_BFu7s_B) C1{ Fc:8 Fs:7 Fc}



static void Test_BFu8c_BFu7s_B()
{
  {
    init_simple_test("BFu8c_BFu7s_B");
    static BFu8c_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_BFu7s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8c_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8c_BFu7s_B");
    check_field_offset(lv, v3, 2, "BFu8c_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu7s_B(Test_BFu8c_BFu7s_B, "BFu8c_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu8c_B  {
  unsigned char v1:8;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 BFu8c_BFu8c_B) C1{ Fc:8 Fc:8 Fc}



static void Test_BFu8c_BFu8c_B()
{
  {
    init_simple_test("BFu8c_BFu8c_B");
    static BFu8c_BFu8c_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8c_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8c_B");
    check_field_offset(lv, v3, 2, "BFu8c_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu8c_B(Test_BFu8c_BFu8c_B, "BFu8c_BFu8c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu8i_B  {
  unsigned char v1:8;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 BFu8c_BFu8i_B) C1{ Fc:8 Fi:8 Fc}



static void Test_BFu8c_BFu8i_B()
{
  {
    init_simple_test("BFu8c_BFu8i_B");
    static BFu8c_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_BFu8i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8c_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8i_B");
    check_field_offset(lv, v3, 2, "BFu8c_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu8i_B(Test_BFu8c_BFu8i_B, "BFu8c_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu8ll_B  {
  unsigned char v1:8;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 BFu8c_BFu8ll_B) C1{ Fc:8 FL:8 Fc}



static void Test_BFu8c_BFu8ll_B()
{
  {
    init_simple_test("BFu8c_BFu8ll_B");
    static BFu8c_BFu8ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8c_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8c_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8ll_B");
    check_field_offset(lv, v3, 2, "BFu8c_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu8ll_B(Test_BFu8c_BFu8ll_B, "BFu8c_BFu8ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu8s_B  {
  unsigned char v1:8;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 BFu8c_BFu8s_B) C1{ Fc:8 Fs:8 Fc}



static void Test_BFu8c_BFu8s_B()
{
  {
    init_simple_test("BFu8c_BFu8s_B");
    static BFu8c_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_BFu8s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8c_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu8s_B");
    check_field_offset(lv, v3, 2, "BFu8c_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu8s_B(Test_BFu8c_BFu8s_B, "BFu8c_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu9i_B  {
  unsigned char v1:8;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 BFu8c_BFu9i_B) C1{ Fc:8 Fi:9 Fc}



static void Test_BFu8c_BFu9i_B()
{
  {
    init_simple_test("BFu8c_BFu9i_B");
    static BFu8c_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8c_BFu9i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8c_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8c_BFu9i_B");
    check_field_offset(lv, v3, 3, "BFu8c_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu9i_B(Test_BFu8c_BFu9i_B, "BFu8c_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu9ll_B  {
  unsigned char v1:8;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 BFu8c_BFu9ll_B) C1{ Fc:8 FL:9 Fc}



static void Test_BFu8c_BFu9ll_B()
{
  {
    init_simple_test("BFu8c_BFu9ll_B");
    static BFu8c_BFu9ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8c_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8c_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8c_BFu9ll_B");
    check_field_offset(lv, v3, 3, "BFu8c_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu9ll_B(Test_BFu8c_BFu9ll_B, "BFu8c_BFu9ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_BFu9s_B  {
  unsigned char v1:8;
  unsigned short v2:9;
  bool v3;
};
//SIG(1 BFu8c_BFu9s_B) C1{ Fc:8 Fs:9 Fc}



static void Test_BFu8c_BFu9s_B()
{
  {
    init_simple_test("BFu8c_BFu9s_B");
    static BFu8c_BFu9s_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu8c_BFu9s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8c_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8c_BFu9s_B");
    check_field_offset(lv, v3, 4, "BFu8c_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_BFu9s_B(Test_BFu8c_BFu9s_B, "BFu8c_BFu9s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_C_B  {
  unsigned char v1:8;
  char v2;
  bool v3;
};
//SIG(1 BFu8c_C_B) C1{ Fc:8 Fc[2]}



static void Test_BFu8c_C_B()
{
  {
    init_simple_test("BFu8c_C_B");
    static BFu8c_C_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_C_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_C_B");
    check_field_offset(lv, v2, 1, "BFu8c_C_B.v2");
    check_field_offset(lv, v3, 2, "BFu8c_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_C_B(Test_BFu8c_C_B, "BFu8c_C_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_D_B  {
  unsigned char v1:8;
  double v2;
  bool v3;
};
//SIG(1 BFu8c_D_B) C1{ Fc:8 FL Fc}



static void Test_BFu8c_D_B()
{
  {
    init_simple_test("BFu8c_D_B");
    static BFu8c_D_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8c_D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_D_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_D_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8c_D_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8c_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_D_B(Test_BFu8c_D_B, "BFu8c_D_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_F_B  {
  unsigned char v1:8;
  float v2;
  bool v3;
};
//SIG(1 BFu8c_F_B) C1{ Fc:8 Fi Fc}



static void Test_BFu8c_F_B()
{
  {
    init_simple_test("BFu8c_F_B");
    static BFu8c_F_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8c_F_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_F_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_F_B");
    check_field_offset(lv, v2, 4, "BFu8c_F_B.v2");
    check_field_offset(lv, v3, 8, "BFu8c_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_F_B(Test_BFu8c_F_B, "BFu8c_F_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_I_B  {
  unsigned char v1:8;
  int v2;
  bool v3;
};
//SIG(1 BFu8c_I_B) C1{ Fc:8 Fi Fc}



static void Test_BFu8c_I_B()
{
  {
    init_simple_test("BFu8c_I_B");
    static BFu8c_I_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8c_I_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_I_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_I_B");
    check_field_offset(lv, v2, 4, "BFu8c_I_B.v2");
    check_field_offset(lv, v3, 8, "BFu8c_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_I_B(Test_BFu8c_I_B, "BFu8c_I_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_Ip_B  {
  unsigned char v1:8;
  int *v2;
  bool v3;
};
//SIG(1 BFu8c_Ip_B) C1{ Fc:8 Fp Fc}



static void Test_BFu8c_Ip_B()
{
  {
    init_simple_test("BFu8c_Ip_B");
    static BFu8c_Ip_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8c_Ip_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Ip_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8c_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8c_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_Ip_B(Test_BFu8c_Ip_B, "BFu8c_Ip_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_L_B  {
  unsigned char v1:8;
  __tsi64 v2;
  bool v3;
};
//SIG(1 BFu8c_L_B) C1{ Fc:8 FL Fc}



static void Test_BFu8c_L_B()
{
  {
    init_simple_test("BFu8c_L_B");
    static BFu8c_L_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8c_L_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_L_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_L_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8c_L_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8c_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_L_B(Test_BFu8c_L_B, "BFu8c_L_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_S_B  {
  unsigned char v1:8;
  short v2;
  bool v3;
};
//SIG(1 BFu8c_S_B) C1{ Fc:8 Fs Fc}



static void Test_BFu8c_S_B()
{
  {
    init_simple_test("BFu8c_S_B");
    static BFu8c_S_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu8c_S_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_S_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_S_B");
    check_field_offset(lv, v2, 2, "BFu8c_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu8c_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_S_B(Test_BFu8c_S_B, "BFu8c_S_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_Uc_B  {
  unsigned char v1:8;
  unsigned char v2;
  bool v3;
};
//SIG(1 BFu8c_Uc_B) C1{ Fc:8 Fc[2]}



static void Test_BFu8c_Uc_B()
{
  {
    init_simple_test("BFu8c_Uc_B");
    static BFu8c_Uc_B lv;
    check2(sizeof(lv), 3, "sizeof(BFu8c_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(BFu8c_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Uc_B");
    check_field_offset(lv, v2, 1, "BFu8c_Uc_B.v2");
    check_field_offset(lv, v3, 2, "BFu8c_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_Uc_B(Test_BFu8c_Uc_B, "BFu8c_Uc_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_Ui_B  {
  unsigned char v1:8;
  unsigned int v2;
  bool v3;
};
//SIG(1 BFu8c_Ui_B) C1{ Fc:8 Fi Fc}



static void Test_BFu8c_Ui_B()
{
  {
    init_simple_test("BFu8c_Ui_B");
    static BFu8c_Ui_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8c_Ui_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8c_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Ui_B");
    check_field_offset(lv, v2, 4, "BFu8c_Ui_B.v2");
    check_field_offset(lv, v3, 8, "BFu8c_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_Ui_B(Test_BFu8c_Ui_B, "BFu8c_Ui_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_Ul_B  {
  unsigned char v1:8;
  __tsu64 v2;
  bool v3;
};
//SIG(1 BFu8c_Ul_B) C1{ Fc:8 FL Fc}



static void Test_BFu8c_Ul_B()
{
  {
    init_simple_test("BFu8c_Ul_B");
    static BFu8c_Ul_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8c_Ul_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Ul_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8c_Ul_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8c_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_Ul_B(Test_BFu8c_Ul_B, "BFu8c_Ul_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_Us_B  {
  unsigned char v1:8;
  unsigned short v2;
  bool v3;
};
//SIG(1 BFu8c_Us_B) C1{ Fc:8 Fs Fc}



static void Test_BFu8c_Us_B()
{
  {
    init_simple_test("BFu8c_Us_B");
    static BFu8c_Us_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu8c_Us_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8c_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Us_B");
    check_field_offset(lv, v2, 2, "BFu8c_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu8c_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_Us_B(Test_BFu8c_Us_B, "BFu8c_Us_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8c_Vp_B  {
  unsigned char v1:8;
  void *v2;
  bool v3;
};
//SIG(1 BFu8c_Vp_B) C1{ Fc:8 Fp Fc}



static void Test_BFu8c_Vp_B()
{
  {
    init_simple_test("BFu8c_Vp_B");
    static BFu8c_Vp_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8c_Vp_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8c_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8c_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8c_Vp_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8c_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8c_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8c_Vp_B(Test_BFu8c_Vp_B, "BFu8c_Vp_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B  {
  unsigned int v1:8;
  bool v2;
};
//SIG(1 BFu8i_B) C1{ Fi:8 Fc}



static void Test_BFu8i_B()
{
  {
    init_simple_test("BFu8i_B");
    static BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B");
    check_field_offset(lv, v2, 1, "BFu8i_B.v2");
  }
}
static Arrange_To_Call_Me vBFu8i_B(Test_BFu8i_B, "BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_B  {
  unsigned int v1:8;
  bool v2;
  bool v3;
};
//SIG(1 BFu8i_B_B) C1{ Fi:8 Fc[2]}



static void Test_BFu8i_B_B()
{
  {
    init_simple_test("BFu8i_B_B");
    static BFu8i_B_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_B");
    check_field_offset(lv, v2, 1, "BFu8i_B_B.v2");
    check_field_offset(lv, v3, 2, "BFu8i_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_B_B(Test_BFu8i_B_B, "BFu8i_B_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu15i  {
  unsigned int v1:8;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 BFu8i_B_BFu15i) C1{ Fi:8 Fc Fi:15}



static void Test_BFu8i_B_BFu15i()
{
  {
    init_simple_test("BFu8i_B_BFu15i");
    static BFu8i_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu15i");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu15i(Test_BFu8i_B_BFu15i, "BFu8i_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu15ll  {
  unsigned int v1:8;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 BFu8i_B_BFu15ll) C1{ Fi:8 Fc FL:15}



static void Test_BFu8i_B_BFu15ll()
{
  {
    init_simple_test("BFu8i_B_BFu15ll");
    static BFu8i_B_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu15ll(Test_BFu8i_B_BFu15ll, "BFu8i_B_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu15s  {
  unsigned int v1:8;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 BFu8i_B_BFu15s) C1{ Fi:8 Fc Fs:15}



static void Test_BFu8i_B_BFu15s()
{
  {
    init_simple_test("BFu8i_B_BFu15s");
    static BFu8i_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu15s");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8i_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu15s(Test_BFu8i_B_BFu15s, "BFu8i_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu16i  {
  unsigned int v1:8;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 BFu8i_B_BFu16i) C1{ Fi:8 Fc Fi:16}



static void Test_BFu8i_B_BFu16i()
{
  {
    init_simple_test("BFu8i_B_BFu16i");
    static BFu8i_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu16i");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu16i(Test_BFu8i_B_BFu16i, "BFu8i_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu16ll  {
  unsigned int v1:8;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 BFu8i_B_BFu16ll) C1{ Fi:8 Fc FL:16}



static void Test_BFu8i_B_BFu16ll()
{
  {
    init_simple_test("BFu8i_B_BFu16ll");
    static BFu8i_B_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu16ll(Test_BFu8i_B_BFu16ll, "BFu8i_B_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu16s  {
  unsigned int v1:8;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 BFu8i_B_BFu16s) C1{ Fi:8 Fc Fs:16}



static void Test_BFu8i_B_BFu16s()
{
  {
    init_simple_test("BFu8i_B_BFu16s");
    static BFu8i_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu16s");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8i_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu16s(Test_BFu8i_B_BFu16s, "BFu8i_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu17i  {
  unsigned int v1:8;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 BFu8i_B_BFu17i) C1{ Fi:8 Fc Fi:17}



static void Test_BFu8i_B_BFu17i()
{
  {
    init_simple_test("BFu8i_B_BFu17i");
    static BFu8i_B_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_B_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu17i");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu8i_B_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu8i_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu17i(Test_BFu8i_B_BFu17i, "BFu8i_B_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu17ll  {
  unsigned int v1:8;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 BFu8i_B_BFu17ll) C1{ Fi:8 Fc FL:17}



static void Test_BFu8i_B_BFu17ll()
{
  {
    init_simple_test("BFu8i_B_BFu17ll");
    static BFu8i_B_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu8i_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu8i_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu17ll(Test_BFu8i_B_BFu17ll, "BFu8i_B_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu1c  {
  unsigned int v1:8;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 BFu8i_B_BFu1c) C1{ Fi:8 Fc Fc:1}



static void Test_BFu8i_B_BFu1c()
{
  {
    init_simple_test("BFu8i_B_BFu1c");
    static BFu8i_B_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu1c");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu1c(Test_BFu8i_B_BFu1c, "BFu8i_B_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu1i  {
  unsigned int v1:8;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 BFu8i_B_BFu1i) C1{ Fi:8 Fc Fi:1}



static void Test_BFu8i_B_BFu1i()
{
  {
    init_simple_test("BFu8i_B_BFu1i");
    static BFu8i_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu1i");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu1i(Test_BFu8i_B_BFu1i, "BFu8i_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu1ll  {
  unsigned int v1:8;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 BFu8i_B_BFu1ll) C1{ Fi:8 Fc FL:1}



static void Test_BFu8i_B_BFu1ll()
{
  {
    init_simple_test("BFu8i_B_BFu1ll");
    static BFu8i_B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu1ll(Test_BFu8i_B_BFu1ll, "BFu8i_B_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu1s  {
  unsigned int v1:8;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 BFu8i_B_BFu1s) C1{ Fi:8 Fc Fs:1}



static void Test_BFu8i_B_BFu1s()
{
  {
    init_simple_test("BFu8i_B_BFu1s");
    static BFu8i_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu1s");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8i_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu1s(Test_BFu8i_B_BFu1s, "BFu8i_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu31i  {
  unsigned int v1:8;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 BFu8i_B_BFu31i) C1{ Fi:8 Fc Fi:31}



static void Test_BFu8i_B_BFu31i()
{
  {
    init_simple_test("BFu8i_B_BFu31i");
    static BFu8i_B_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_B_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu31i");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8i_B_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu31i(Test_BFu8i_B_BFu31i, "BFu8i_B_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu31ll  {
  unsigned int v1:8;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 BFu8i_B_BFu31ll) C1{ Fi:8 Fc FL:31}



static void Test_BFu8i_B_BFu31ll()
{
  {
    init_simple_test("BFu8i_B_BFu31ll");
    static BFu8i_B_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu8i_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu8i_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu31ll(Test_BFu8i_B_BFu31ll, "BFu8i_B_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu32i  {
  unsigned int v1:8;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 BFu8i_B_BFu32i) C1{ Fi:8 Fc Fi:32}



static void Test_BFu8i_B_BFu32i()
{
  {
    init_simple_test("BFu8i_B_BFu32i");
    static BFu8i_B_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_B_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu32i");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8i_B_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu32i(Test_BFu8i_B_BFu32i, "BFu8i_B_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu32ll  {
  unsigned int v1:8;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 BFu8i_B_BFu32ll) C1{ Fi:8 Fc FL:32}



static void Test_BFu8i_B_BFu32ll()
{
  {
    init_simple_test("BFu8i_B_BFu32ll");
    static BFu8i_B_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu8i_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu8i_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu32ll(Test_BFu8i_B_BFu32ll, "BFu8i_B_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu33  {
  unsigned int v1:8;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 BFu8i_B_BFu33) C1{ Fi:8 Fc FL:33}



static void Test_BFu8i_B_BFu33()
{
  {
    init_simple_test("BFu8i_B_BFu33");
    static BFu8i_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu33");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu8i_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu8i_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu33(Test_BFu8i_B_BFu33, "BFu8i_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu7c  {
  unsigned int v1:8;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 BFu8i_B_BFu7c) C1{ Fi:8 Fc Fc:7}



static void Test_BFu8i_B_BFu7c()
{
  {
    init_simple_test("BFu8i_B_BFu7c");
    static BFu8i_B_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu7c");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu7c(Test_BFu8i_B_BFu7c, "BFu8i_B_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu7i  {
  unsigned int v1:8;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 BFu8i_B_BFu7i) C1{ Fi:8 Fc Fi:7}



static void Test_BFu8i_B_BFu7i()
{
  {
    init_simple_test("BFu8i_B_BFu7i");
    static BFu8i_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu7i");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu7i(Test_BFu8i_B_BFu7i, "BFu8i_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu7ll  {
  unsigned int v1:8;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 BFu8i_B_BFu7ll) C1{ Fi:8 Fc FL:7}



static void Test_BFu8i_B_BFu7ll()
{
  {
    init_simple_test("BFu8i_B_BFu7ll");
    static BFu8i_B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu7ll(Test_BFu8i_B_BFu7ll, "BFu8i_B_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu7s  {
  unsigned int v1:8;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 BFu8i_B_BFu7s) C1{ Fi:8 Fc Fs:7}



static void Test_BFu8i_B_BFu7s()
{
  {
    init_simple_test("BFu8i_B_BFu7s");
    static BFu8i_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu7s");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8i_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8i_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu7s(Test_BFu8i_B_BFu7s, "BFu8i_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu8c  {
  unsigned int v1:8;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 BFu8i_B_BFu8c) C1{ Fi:8 Fc Fc:8}



static void Test_BFu8i_B_BFu8c()
{
  {
    init_simple_test("BFu8i_B_BFu8c");
    static BFu8i_B_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu8c");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu8c(Test_BFu8i_B_BFu8c, "BFu8i_B_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu8i  {
  unsigned int v1:8;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 BFu8i_B_BFu8i) C1{ Fi:8 Fc Fi:8}



static void Test_BFu8i_B_BFu8i()
{
  {
    init_simple_test("BFu8i_B_BFu8i");
    static BFu8i_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu8i");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu8i(Test_BFu8i_B_BFu8i, "BFu8i_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu8ll  {
  unsigned int v1:8;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 BFu8i_B_BFu8ll) C1{ Fi:8 Fc FL:8}



static void Test_BFu8i_B_BFu8ll()
{
  {
    init_simple_test("BFu8i_B_BFu8ll");
    static BFu8i_B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu8ll(Test_BFu8i_B_BFu8ll, "BFu8i_B_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu8s  {
  unsigned int v1:8;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 BFu8i_B_BFu8s) C1{ Fi:8 Fc Fs:8}



static void Test_BFu8i_B_BFu8s()
{
  {
    init_simple_test("BFu8i_B_BFu8s");
    static BFu8i_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu8s");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8i_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu8s(Test_BFu8i_B_BFu8s, "BFu8i_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu9i  {
  unsigned int v1:8;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 BFu8i_B_BFu9i) C1{ Fi:8 Fc Fi:9}



static void Test_BFu8i_B_BFu9i()
{
  {
    init_simple_test("BFu8i_B_BFu9i");
    static BFu8i_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu9i");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu9i(Test_BFu8i_B_BFu9i, "BFu8i_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu9ll  {
  unsigned int v1:8;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 BFu8i_B_BFu9ll) C1{ Fi:8 Fc FL:9}



static void Test_BFu8i_B_BFu9ll()
{
  {
    init_simple_test("BFu8i_B_BFu9ll");
    static BFu8i_B_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu9ll(Test_BFu8i_B_BFu9ll, "BFu8i_B_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_BFu9s  {
  unsigned int v1:8;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 BFu8i_B_BFu9s) C1{ Fi:8 Fc Fs:9}



static void Test_BFu8i_B_BFu9s()
{
  {
    init_simple_test("BFu8i_B_BFu9s");
    static BFu8i_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_BFu9s");
    check_field_offset(lv, v2, 1, "BFu8i_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8i_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu8i_B_BFu9s(Test_BFu8i_B_BFu9s, "BFu8i_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_C  {
  unsigned int v1:8;
  bool v2;
  char v3;
};
//SIG(1 BFu8i_B_C) C1{ Fi:8 Fc[2]}



static void Test_BFu8i_B_C()
{
  {
    init_simple_test("BFu8i_B_C");
    static BFu8i_B_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_C");
    check_field_offset(lv, v2, 1, "BFu8i_B_C.v2");
    check_field_offset(lv, v3, 2, "BFu8i_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_B_C(Test_BFu8i_B_C, "BFu8i_B_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_D  {
  unsigned int v1:8;
  bool v2;
  double v3;
};
//SIG(1 BFu8i_B_D) C1{ Fi:8 Fc FL}



static void Test_BFu8i_B_D()
{
  {
    init_simple_test("BFu8i_B_D");
    static BFu8i_B_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_D");
    check_field_offset(lv, v2, 1, "BFu8i_B_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_B_D(Test_BFu8i_B_D, "BFu8i_B_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_F  {
  unsigned int v1:8;
  bool v2;
  float v3;
};
//SIG(1 BFu8i_B_F) C1{ Fi:8 Fc Fi}



static void Test_BFu8i_B_F()
{
  {
    init_simple_test("BFu8i_B_F");
    static BFu8i_B_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_B_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_F");
    check_field_offset(lv, v2, 1, "BFu8i_B_F.v2");
    check_field_offset(lv, v3, 4, "BFu8i_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_B_F(Test_BFu8i_B_F, "BFu8i_B_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_I  {
  unsigned int v1:8;
  bool v2;
  int v3;
};
//SIG(1 BFu8i_B_I) C1{ Fi:8 Fc Fi}



static void Test_BFu8i_B_I()
{
  {
    init_simple_test("BFu8i_B_I");
    static BFu8i_B_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_B_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_I");
    check_field_offset(lv, v2, 1, "BFu8i_B_I.v2");
    check_field_offset(lv, v3, 4, "BFu8i_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_B_I(Test_BFu8i_B_I, "BFu8i_B_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_Ip  {
  unsigned int v1:8;
  bool v2;
  int *v3;
};
//SIG(1 BFu8i_B_Ip) C1{ Fi:8 Fc Fp}



static void Test_BFu8i_B_Ip()
{
  {
    init_simple_test("BFu8i_B_Ip");
    static BFu8i_B_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_Ip");
    check_field_offset(lv, v2, 1, "BFu8i_B_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_B_Ip(Test_BFu8i_B_Ip, "BFu8i_B_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_L  {
  unsigned int v1:8;
  bool v2;
  __tsi64 v3;
};
//SIG(1 BFu8i_B_L) C1{ Fi:8 Fc FL}



static void Test_BFu8i_B_L()
{
  {
    init_simple_test("BFu8i_B_L");
    static BFu8i_B_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_L");
    check_field_offset(lv, v2, 1, "BFu8i_B_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_B_L(Test_BFu8i_B_L, "BFu8i_B_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_S  {
  unsigned int v1:8;
  bool v2;
  short v3;
};
//SIG(1 BFu8i_B_S) C1{ Fi:8 Fc Fs}



static void Test_BFu8i_B_S()
{
  {
    init_simple_test("BFu8i_B_S");
    static BFu8i_B_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_S");
    check_field_offset(lv, v2, 1, "BFu8i_B_S.v2");
    check_field_offset(lv, v3, 2, "BFu8i_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_B_S(Test_BFu8i_B_S, "BFu8i_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_Uc  {
  unsigned int v1:8;
  bool v2;
  unsigned char v3;
};
//SIG(1 BFu8i_B_Uc) C1{ Fi:8 Fc[2]}



static void Test_BFu8i_B_Uc()
{
  {
    init_simple_test("BFu8i_B_Uc");
    static BFu8i_B_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_Uc");
    check_field_offset(lv, v2, 1, "BFu8i_B_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu8i_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_B_Uc(Test_BFu8i_B_Uc, "BFu8i_B_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_Ui  {
  unsigned int v1:8;
  bool v2;
  unsigned int v3;
};
//SIG(1 BFu8i_B_Ui) C1{ Fi:8 Fc Fi}



static void Test_BFu8i_B_Ui()
{
  {
    init_simple_test("BFu8i_B_Ui");
    static BFu8i_B_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_B_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_Ui");
    check_field_offset(lv, v2, 1, "BFu8i_B_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu8i_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_B_Ui(Test_BFu8i_B_Ui, "BFu8i_B_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_Ul  {
  unsigned int v1:8;
  bool v2;
  __tsu64 v3;
};
//SIG(1 BFu8i_B_Ul) C1{ Fi:8 Fc FL}



static void Test_BFu8i_B_Ul()
{
  {
    init_simple_test("BFu8i_B_Ul");
    static BFu8i_B_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8i_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_Ul");
    check_field_offset(lv, v2, 1, "BFu8i_B_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_B_Ul(Test_BFu8i_B_Ul, "BFu8i_B_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_Us  {
  unsigned int v1:8;
  bool v2;
  unsigned short v3;
};
//SIG(1 BFu8i_B_Us) C1{ Fi:8 Fc Fs}



static void Test_BFu8i_B_Us()
{
  {
    init_simple_test("BFu8i_B_Us");
    static BFu8i_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_B_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_Us");
    check_field_offset(lv, v2, 1, "BFu8i_B_Us.v2");
    check_field_offset(lv, v3, 2, "BFu8i_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_B_Us(Test_BFu8i_B_Us, "BFu8i_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_B_Vp  {
  unsigned int v1:8;
  bool v2;
  void *v3;
};
//SIG(1 BFu8i_B_Vp) C1{ Fi:8 Fc Fp}



static void Test_BFu8i_B_Vp()
{
  {
    init_simple_test("BFu8i_B_Vp");
    static BFu8i_B_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8i_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_B_Vp");
    check_field_offset(lv, v2, 1, "BFu8i_B_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8i_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_B_Vp(Test_BFu8i_B_Vp, "BFu8i_B_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu15i_B  {
  unsigned int v1:8;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 BFu8i_BFu15i_B) C1{ Fi:8 Fi:15 Fc}



static void Test_BFu8i_BFu15i_B()
{
  {
    init_simple_test("BFu8i_BFu15i_B");
    static BFu8i_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu15i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8i_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu15i_B");
    check_field_offset(lv, v3, 3, "BFu8i_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu15i_B(Test_BFu8i_BFu15i_B, "BFu8i_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu15ll_B  {
  unsigned int v1:8;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 BFu8i_BFu15ll_B) C1{ Fi:8 FL:15 Fc}



static void Test_BFu8i_BFu15ll_B()
{
  {
    init_simple_test("BFu8i_BFu15ll_B");
    static BFu8i_BFu15ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8i_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu15ll_B");
    check_field_offset(lv, v3, 3, "BFu8i_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu15ll_B(Test_BFu8i_BFu15ll_B, "BFu8i_BFu15ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu15s_B  {
  unsigned int v1:8;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 BFu8i_BFu15s_B) C1{ Fi:8 Fs:15 Fc}



static void Test_BFu8i_BFu15s_B()
{
  {
    init_simple_test("BFu8i_BFu15s_B");
    static BFu8i_BFu15s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu15s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu8i_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu8i_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu8i_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu15s_B(Test_BFu8i_BFu15s_B, "BFu8i_BFu15s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu16i_B  {
  unsigned int v1:8;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 BFu8i_BFu16i_B) C1{ Fi:8 Fi:16 Fc}



static void Test_BFu8i_BFu16i_B()
{
  {
    init_simple_test("BFu8i_BFu16i_B");
    static BFu8i_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu16i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8i_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu16i_B");
    check_field_offset(lv, v3, 3, "BFu8i_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu16i_B(Test_BFu8i_BFu16i_B, "BFu8i_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu16ll_B  {
  unsigned int v1:8;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 BFu8i_BFu16ll_B) C1{ Fi:8 FL:16 Fc}



static void Test_BFu8i_BFu16ll_B()
{
  {
    init_simple_test("BFu8i_BFu16ll_B");
    static BFu8i_BFu16ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8i_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu16ll_B");
    check_field_offset(lv, v3, 3, "BFu8i_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu16ll_B(Test_BFu8i_BFu16ll_B, "BFu8i_BFu16ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu16s_B  {
  unsigned int v1:8;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 BFu8i_BFu16s_B) C1{ Fi:8 Fs:16 Fc}



static void Test_BFu8i_BFu16s_B()
{
  {
    init_simple_test("BFu8i_BFu16s_B");
    static BFu8i_BFu16s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu16s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu8i_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu8i_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu8i_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu16s_B(Test_BFu8i_BFu16s_B, "BFu8i_BFu16s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu17i_B  {
  unsigned int v1:8;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 BFu8i_BFu17i_B) C1{ Fi:8 Fi:17 Fc}



static void Test_BFu8i_BFu17i_B()
{
  {
    init_simple_test("BFu8i_BFu17i_B");
    static BFu8i_BFu17i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu17i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8i_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu17i_B");
    check_field_offset(lv, v3, 4, "BFu8i_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu17i_B(Test_BFu8i_BFu17i_B, "BFu8i_BFu17i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu17ll_B  {
  unsigned int v1:8;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 BFu8i_BFu17ll_B) C1{ Fi:8 FL:17 Fc}



static void Test_BFu8i_BFu17ll_B()
{
  {
    init_simple_test("BFu8i_BFu17ll_B");
    static BFu8i_BFu17ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8i_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8i_BFu17ll_B");
    check_field_offset(lv, v3, 4, "BFu8i_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu17ll_B(Test_BFu8i_BFu17ll_B, "BFu8i_BFu17ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu1c_B  {
  unsigned int v1:8;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 BFu8i_BFu1c_B) C1{ Fi:8 Fc:1 Fc}



static void Test_BFu8i_BFu1c_B()
{
  {
    init_simple_test("BFu8i_BFu1c_B");
    static BFu8i_BFu1c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu1c_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8i_BFu1c_B");
    check_field_offset(lv, v3, 2, "BFu8i_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu1c_B(Test_BFu8i_BFu1c_B, "BFu8i_BFu1c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu1i_B  {
  unsigned int v1:8;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 BFu8i_BFu1i_B) C1{ Fi:8 Fi:1 Fc}



static void Test_BFu8i_BFu1i_B()
{
  {
    init_simple_test("BFu8i_BFu1i_B");
    static BFu8i_BFu1i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu1i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8i_BFu1i_B");
    check_field_offset(lv, v3, 2, "BFu8i_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu1i_B(Test_BFu8i_BFu1i_B, "BFu8i_BFu1i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu1ll_B  {
  unsigned int v1:8;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 BFu8i_BFu1ll_B) C1{ Fi:8 FL:1 Fc}



static void Test_BFu8i_BFu1ll_B()
{
  {
    init_simple_test("BFu8i_BFu1ll_B");
    static BFu8i_BFu1ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8i_BFu1ll_B");
    check_field_offset(lv, v3, 2, "BFu8i_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu1ll_B(Test_BFu8i_BFu1ll_B, "BFu8i_BFu1ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu1s_B  {
  unsigned int v1:8;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 BFu8i_BFu1s_B) C1{ Fi:8 Fs:1 Fc}



static void Test_BFu8i_BFu1s_B()
{
  {
    init_simple_test("BFu8i_BFu1s_B");
    static BFu8i_BFu1s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu1s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8i_BFu1s_B");
    check_field_offset(lv, v3, 2, "BFu8i_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu1s_B(Test_BFu8i_BFu1s_B, "BFu8i_BFu1s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu31i_B  {
  unsigned int v1:8;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 BFu8i_BFu31i_B) C1{ Fi:8 Fi:31 Fc}



static void Test_BFu8i_BFu31i_B()
{
  {
    init_simple_test("BFu8i_BFu31i_B");
    static BFu8i_BFu31i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_BFu31i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu8i_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu31i_B");
    check_field_offset(lv, v3, 8, "BFu8i_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu31i_B(Test_BFu8i_BFu31i_B, "BFu8i_BFu31i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu31ll_B  {
  unsigned int v1:8;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 BFu8i_BFu31ll_B) C1{ Fi:8 FL:31 Fc}



static void Test_BFu8i_BFu31ll_B()
{
  {
    init_simple_test("BFu8i_BFu31ll_B");
    static BFu8i_BFu31ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu8i_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu8i_BFu31ll_B");
    check_field_offset(lv, v3, 5, "BFu8i_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu31ll_B(Test_BFu8i_BFu31ll_B, "BFu8i_BFu31ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu32i_B  {
  unsigned int v1:8;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 BFu8i_BFu32i_B) C1{ Fi:8 Fi:32 Fc}



static void Test_BFu8i_BFu32i_B()
{
  {
    init_simple_test("BFu8i_BFu32i_B");
    static BFu8i_BFu32i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_BFu32i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu8i_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu32i_B");
    check_field_offset(lv, v3, 8, "BFu8i_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu32i_B(Test_BFu8i_BFu32i_B, "BFu8i_BFu32i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu32ll_B  {
  unsigned int v1:8;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 BFu8i_BFu32ll_B) C1{ Fi:8 FL:32 Fc}



static void Test_BFu8i_BFu32ll_B()
{
  {
    init_simple_test("BFu8i_BFu32ll_B");
    static BFu8i_BFu32ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu8i_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu8i_BFu32ll_B");
    check_field_offset(lv, v3, 5, "BFu8i_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu32ll_B(Test_BFu8i_BFu32ll_B, "BFu8i_BFu32ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu33_B  {
  unsigned int v1:8;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 BFu8i_BFu33_B) C1{ Fi:8 FL:33 Fc}



static void Test_BFu8i_BFu33_B()
{
  {
    init_simple_test("BFu8i_BFu33_B");
    static BFu8i_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8i_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8i_BFu33_B");
    check_field_offset(lv, v3, 6, "BFu8i_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu33_B(Test_BFu8i_BFu33_B, "BFu8i_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu7c_B  {
  unsigned int v1:8;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 BFu8i_BFu7c_B) C1{ Fi:8 Fc:7 Fc}



static void Test_BFu8i_BFu7c_B()
{
  {
    init_simple_test("BFu8i_BFu7c_B");
    static BFu8i_BFu7c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7c_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7c_B");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu7c_B(Test_BFu8i_BFu7c_B, "BFu8i_BFu7c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu7i_B  {
  unsigned int v1:8;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 BFu8i_BFu7i_B) C1{ Fi:8 Fi:7 Fc}



static void Test_BFu8i_BFu7i_B()
{
  {
    init_simple_test("BFu8i_BFu7i_B");
    static BFu8i_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7i_B");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu7i_B(Test_BFu8i_BFu7i_B, "BFu8i_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu7ll_B  {
  unsigned int v1:8;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 BFu8i_BFu7ll_B) C1{ Fi:8 FL:7 Fc}



static void Test_BFu8i_BFu7ll_B()
{
  {
    init_simple_test("BFu8i_BFu7ll_B");
    static BFu8i_BFu7ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7ll_B");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu7ll_B(Test_BFu8i_BFu7ll_B, "BFu8i_BFu7ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu7s_B  {
  unsigned int v1:8;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 BFu8i_BFu7s_B) C1{ Fi:8 Fs:7 Fc}



static void Test_BFu8i_BFu7s_B()
{
  {
    init_simple_test("BFu8i_BFu7s_B");
    static BFu8i_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu7s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8i_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8i_BFu7s_B");
    check_field_offset(lv, v3, 2, "BFu8i_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu7s_B(Test_BFu8i_BFu7s_B, "BFu8i_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu8c_B  {
  unsigned int v1:8;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 BFu8i_BFu8c_B) C1{ Fi:8 Fc:8 Fc}



static void Test_BFu8i_BFu8c_B()
{
  {
    init_simple_test("BFu8i_BFu8c_B");
    static BFu8i_BFu8c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8c_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8c_B");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu8c_B(Test_BFu8i_BFu8c_B, "BFu8i_BFu8c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu8i_B  {
  unsigned int v1:8;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 BFu8i_BFu8i_B) C1{ Fi:8 Fi:8 Fc}



static void Test_BFu8i_BFu8i_B()
{
  {
    init_simple_test("BFu8i_BFu8i_B");
    static BFu8i_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8i_B");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu8i_B(Test_BFu8i_BFu8i_B, "BFu8i_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu8ll_B  {
  unsigned int v1:8;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 BFu8i_BFu8ll_B) C1{ Fi:8 FL:8 Fc}



static void Test_BFu8i_BFu8ll_B()
{
  {
    init_simple_test("BFu8i_BFu8ll_B");
    static BFu8i_BFu8ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8ll_B");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu8ll_B(Test_BFu8i_BFu8ll_B, "BFu8i_BFu8ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu8s_B  {
  unsigned int v1:8;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 BFu8i_BFu8s_B) C1{ Fi:8 Fs:8 Fc}



static void Test_BFu8i_BFu8s_B()
{
  {
    init_simple_test("BFu8i_BFu8s_B");
    static BFu8i_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu8s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8i_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu8s_B");
    check_field_offset(lv, v3, 2, "BFu8i_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu8s_B(Test_BFu8i_BFu8s_B, "BFu8i_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu9i_B  {
  unsigned int v1:8;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 BFu8i_BFu9i_B) C1{ Fi:8 Fi:9 Fc}



static void Test_BFu8i_BFu9i_B()
{
  {
    init_simple_test("BFu8i_BFu9i_B");
    static BFu8i_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_BFu9i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9i_B");
    check_field_offset(lv, v3, 3, "BFu8i_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu9i_B(Test_BFu8i_BFu9i_B, "BFu8i_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu9ll_B  {
  unsigned int v1:8;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 BFu8i_BFu9ll_B) C1{ Fi:8 FL:9 Fc}



static void Test_BFu8i_BFu9ll_B()
{
  {
    init_simple_test("BFu8i_BFu9ll_B");
    static BFu8i_BFu9ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8i_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8i_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9ll_B");
    check_field_offset(lv, v3, 3, "BFu8i_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu9ll_B(Test_BFu8i_BFu9ll_B, "BFu8i_BFu9ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_BFu9s_B  {
  unsigned int v1:8;
  unsigned short v2:9;
  bool v3;
};
//SIG(1 BFu8i_BFu9s_B) C1{ Fi:8 Fs:9 Fc}



static void Test_BFu8i_BFu9s_B()
{
  {
    init_simple_test("BFu8i_BFu9s_B");
    static BFu8i_BFu9s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_BFu9s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8i_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8i_BFu9s_B");
    check_field_offset(lv, v3, 4, "BFu8i_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_BFu9s_B(Test_BFu8i_BFu9s_B, "BFu8i_BFu9s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_C_B  {
  unsigned int v1:8;
  char v2;
  bool v3;
};
//SIG(1 BFu8i_C_B) C1{ Fi:8 Fc[2]}



static void Test_BFu8i_C_B()
{
  {
    init_simple_test("BFu8i_C_B");
    static BFu8i_C_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_C_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_C_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_C_B");
    check_field_offset(lv, v2, 1, "BFu8i_C_B.v2");
    check_field_offset(lv, v3, 2, "BFu8i_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_C_B(Test_BFu8i_C_B, "BFu8i_C_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_D_B  {
  unsigned int v1:8;
  double v2;
  bool v3;
};
//SIG(1 BFu8i_D_B) C1{ Fi:8 FL Fc}



static void Test_BFu8i_D_B()
{
  {
    init_simple_test("BFu8i_D_B");
    static BFu8i_D_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_D_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_D_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_D_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_D_B(Test_BFu8i_D_B, "BFu8i_D_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_F_B  {
  unsigned int v1:8;
  float v2;
  bool v3;
};
//SIG(1 BFu8i_F_B) C1{ Fi:8 Fi Fc}



static void Test_BFu8i_F_B()
{
  {
    init_simple_test("BFu8i_F_B");
    static BFu8i_F_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_F_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_F_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_F_B");
    check_field_offset(lv, v2, 4, "BFu8i_F_B.v2");
    check_field_offset(lv, v3, 8, "BFu8i_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_F_B(Test_BFu8i_F_B, "BFu8i_F_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_I_B  {
  unsigned int v1:8;
  int v2;
  bool v3;
};
//SIG(1 BFu8i_I_B) C1{ Fi:8 Fi Fc}



static void Test_BFu8i_I_B()
{
  {
    init_simple_test("BFu8i_I_B");
    static BFu8i_I_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_I_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_I_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_I_B");
    check_field_offset(lv, v2, 4, "BFu8i_I_B.v2");
    check_field_offset(lv, v3, 8, "BFu8i_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_I_B(Test_BFu8i_I_B, "BFu8i_I_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_Ip_B  {
  unsigned int v1:8;
  int *v2;
  bool v3;
};
//SIG(1 BFu8i_Ip_B) C1{ Fi:8 Fp Fc}



static void Test_BFu8i_Ip_B()
{
  {
    init_simple_test("BFu8i_Ip_B");
    static BFu8i_Ip_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Ip_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ip_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8i_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_Ip_B(Test_BFu8i_Ip_B, "BFu8i_Ip_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_L_B  {
  unsigned int v1:8;
  __tsi64 v2;
  bool v3;
};
//SIG(1 BFu8i_L_B) C1{ Fi:8 FL Fc}



static void Test_BFu8i_L_B()
{
  {
    init_simple_test("BFu8i_L_B");
    static BFu8i_L_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_L_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_L_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_L_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_L_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_L_B(Test_BFu8i_L_B, "BFu8i_L_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_S_B  {
  unsigned int v1:8;
  short v2;
  bool v3;
};
//SIG(1 BFu8i_S_B) C1{ Fi:8 Fs Fc}



static void Test_BFu8i_S_B()
{
  {
    init_simple_test("BFu8i_S_B");
    static BFu8i_S_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_S_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_S_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_S_B");
    check_field_offset(lv, v2, 2, "BFu8i_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu8i_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_S_B(Test_BFu8i_S_B, "BFu8i_S_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_Uc_B  {
  unsigned int v1:8;
  unsigned char v2;
  bool v3;
};
//SIG(1 BFu8i_Uc_B) C1{ Fi:8 Fc[2]}



static void Test_BFu8i_Uc_B()
{
  {
    init_simple_test("BFu8i_Uc_B");
    static BFu8i_Uc_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8i_Uc_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Uc_B");
    check_field_offset(lv, v2, 1, "BFu8i_Uc_B.v2");
    check_field_offset(lv, v3, 2, "BFu8i_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_Uc_B(Test_BFu8i_Uc_B, "BFu8i_Uc_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_Ui_B  {
  unsigned int v1:8;
  unsigned int v2;
  bool v3;
};
//SIG(1 BFu8i_Ui_B) C1{ Fi:8 Fi Fc}



static void Test_BFu8i_Ui_B()
{
  {
    init_simple_test("BFu8i_Ui_B");
    static BFu8i_Ui_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8i_Ui_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ui_B");
    check_field_offset(lv, v2, 4, "BFu8i_Ui_B.v2");
    check_field_offset(lv, v3, 8, "BFu8i_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_Ui_B(Test_BFu8i_Ui_B, "BFu8i_Ui_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_Ul_B  {
  unsigned int v1:8;
  __tsu64 v2;
  bool v3;
};
//SIG(1 BFu8i_Ul_B) C1{ Fi:8 FL Fc}



static void Test_BFu8i_Ul_B()
{
  {
    init_simple_test("BFu8i_Ul_B");
    static BFu8i_Ul_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8i_Ul_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Ul_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Ul_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8i_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_Ul_B(Test_BFu8i_Ul_B, "BFu8i_Ul_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_Us_B  {
  unsigned int v1:8;
  unsigned short v2;
  bool v3;
};
//SIG(1 BFu8i_Us_B) C1{ Fi:8 Fs Fc}



static void Test_BFu8i_Us_B()
{
  {
    init_simple_test("BFu8i_Us_B");
    static BFu8i_Us_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8i_Us_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8i_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Us_B");
    check_field_offset(lv, v2, 2, "BFu8i_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu8i_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_Us_B(Test_BFu8i_Us_B, "BFu8i_Us_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8i_Vp_B  {
  unsigned int v1:8;
  void *v2;
  bool v3;
};
//SIG(1 BFu8i_Vp_B) C1{ Fi:8 Fp Fc}



static void Test_BFu8i_Vp_B()
{
  {
    init_simple_test("BFu8i_Vp_B");
    static BFu8i_Vp_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8i_Vp_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8i_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8i_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8i_Vp_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8i_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8i_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8i_Vp_B(Test_BFu8i_Vp_B, "BFu8i_Vp_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B  {
  __tsu64 v1:8;
  bool v2;
};
//SIG(1 BFu8ll_B) C1{ FL:8 Fc}



static void Test_BFu8ll_B()
{
  {
    init_simple_test("BFu8ll_B");
    static BFu8ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B");
    check_field_offset(lv, v2, 1, "BFu8ll_B.v2");
  }
}
static Arrange_To_Call_Me vBFu8ll_B(Test_BFu8ll_B, "BFu8ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_B  {
  __tsu64 v1:8;
  bool v2;
  bool v3;
};
//SIG(1 BFu8ll_B_B) C1{ FL:8 Fc[2]}



static void Test_BFu8ll_B_B()
{
  {
    init_simple_test("BFu8ll_B_B");
    static BFu8ll_B_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_B");
    check_field_offset(lv, v2, 1, "BFu8ll_B_B.v2");
    check_field_offset(lv, v3, 2, "BFu8ll_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_B(Test_BFu8ll_B_B, "BFu8ll_B_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu15i  {
  __tsu64 v1:8;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 BFu8ll_B_BFu15i) C1{ FL:8 Fc Fi:15}



static void Test_BFu8ll_B_BFu15i()
{
  {
    init_simple_test("BFu8ll_B_BFu15i");
    static BFu8ll_B_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu15i");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8ll_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8ll_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu15i(Test_BFu8ll_B_BFu15i, "BFu8ll_B_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu15ll  {
  __tsu64 v1:8;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 BFu8ll_B_BFu15ll) C1{ FL:8 Fc FL:15}



static void Test_BFu8ll_B_BFu15ll()
{
  {
    init_simple_test("BFu8ll_B_BFu15ll");
    static BFu8ll_B_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8ll_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8ll_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu15ll(Test_BFu8ll_B_BFu15ll, "BFu8ll_B_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu15s  {
  __tsu64 v1:8;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 BFu8ll_B_BFu15s) C1{ FL:8 Fc Fs:15}



static void Test_BFu8ll_B_BFu15s()
{
  {
    init_simple_test("BFu8ll_B_BFu15s");
    static BFu8ll_B_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu15s");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8ll_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8ll_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu15s(Test_BFu8ll_B_BFu15s, "BFu8ll_B_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu16i  {
  __tsu64 v1:8;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 BFu8ll_B_BFu16i) C1{ FL:8 Fc Fi:16}



static void Test_BFu8ll_B_BFu16i()
{
  {
    init_simple_test("BFu8ll_B_BFu16i");
    static BFu8ll_B_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu16i");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8ll_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8ll_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu16i(Test_BFu8ll_B_BFu16i, "BFu8ll_B_BFu16i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu16ll  {
  __tsu64 v1:8;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 BFu8ll_B_BFu16ll) C1{ FL:8 Fc FL:16}



static void Test_BFu8ll_B_BFu16ll()
{
  {
    init_simple_test("BFu8ll_B_BFu16ll");
    static BFu8ll_B_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8ll_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8ll_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu16ll(Test_BFu8ll_B_BFu16ll, "BFu8ll_B_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu16s  {
  __tsu64 v1:8;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 BFu8ll_B_BFu16s) C1{ FL:8 Fc Fs:16}



static void Test_BFu8ll_B_BFu16s()
{
  {
    init_simple_test("BFu8ll_B_BFu16s");
    static BFu8ll_B_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu16s");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8ll_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8ll_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu16s(Test_BFu8ll_B_BFu16s, "BFu8ll_B_BFu16s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu17i  {
  __tsu64 v1:8;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 BFu8ll_B_BFu17i) C1{ FL:8 Fc Fi:17}



static void Test_BFu8ll_B_BFu17i()
{
  {
    init_simple_test("BFu8ll_B_BFu17i");
    static BFu8ll_B_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_B_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu17i");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu8ll_B_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu8ll_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu17i(Test_BFu8ll_B_BFu17i, "BFu8ll_B_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu17ll  {
  __tsu64 v1:8;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 BFu8ll_B_BFu17ll) C1{ FL:8 Fc FL:17}



static void Test_BFu8ll_B_BFu17ll()
{
  {
    init_simple_test("BFu8ll_B_BFu17ll");
    static BFu8ll_B_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu8ll_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu8ll_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu17ll(Test_BFu8ll_B_BFu17ll, "BFu8ll_B_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu1c  {
  __tsu64 v1:8;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 BFu8ll_B_BFu1c) C1{ FL:8 Fc Fc:1}



static void Test_BFu8ll_B_BFu1c()
{
  {
    init_simple_test("BFu8ll_B_BFu1c");
    static BFu8ll_B_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu1c");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8ll_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu1c(Test_BFu8ll_B_BFu1c, "BFu8ll_B_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu1i  {
  __tsu64 v1:8;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 BFu8ll_B_BFu1i) C1{ FL:8 Fc Fi:1}



static void Test_BFu8ll_B_BFu1i()
{
  {
    init_simple_test("BFu8ll_B_BFu1i");
    static BFu8ll_B_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu1i");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8ll_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu1i(Test_BFu8ll_B_BFu1i, "BFu8ll_B_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu1ll  {
  __tsu64 v1:8;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 BFu8ll_B_BFu1ll) C1{ FL:8 Fc FL:1}



static void Test_BFu8ll_B_BFu1ll()
{
  {
    init_simple_test("BFu8ll_B_BFu1ll");
    static BFu8ll_B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8ll_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu1ll(Test_BFu8ll_B_BFu1ll, "BFu8ll_B_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu1s  {
  __tsu64 v1:8;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 BFu8ll_B_BFu1s) C1{ FL:8 Fc Fs:1}



static void Test_BFu8ll_B_BFu1s()
{
  {
    init_simple_test("BFu8ll_B_BFu1s");
    static BFu8ll_B_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu1s");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8ll_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu1s(Test_BFu8ll_B_BFu1s, "BFu8ll_B_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu31i  {
  __tsu64 v1:8;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 BFu8ll_B_BFu31i) C1{ FL:8 Fc Fi:31}



static void Test_BFu8ll_B_BFu31i()
{
  {
    init_simple_test("BFu8ll_B_BFu31i");
    static BFu8ll_B_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_B_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu31i");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8ll_B_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8ll_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu31i(Test_BFu8ll_B_BFu31i, "BFu8ll_B_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu31ll  {
  __tsu64 v1:8;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 BFu8ll_B_BFu31ll) C1{ FL:8 Fc FL:31}



static void Test_BFu8ll_B_BFu31ll()
{
  {
    init_simple_test("BFu8ll_B_BFu31ll");
    static BFu8ll_B_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu8ll_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu8ll_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu31ll(Test_BFu8ll_B_BFu31ll, "BFu8ll_B_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu32i  {
  __tsu64 v1:8;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 BFu8ll_B_BFu32i) C1{ FL:8 Fc Fi:32}



static void Test_BFu8ll_B_BFu32i()
{
  {
    init_simple_test("BFu8ll_B_BFu32i");
    static BFu8ll_B_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_B_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu32i");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8ll_B_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8ll_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu32i(Test_BFu8ll_B_BFu32i, "BFu8ll_B_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu32ll  {
  __tsu64 v1:8;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 BFu8ll_B_BFu32ll) C1{ FL:8 Fc FL:32}



static void Test_BFu8ll_B_BFu32ll()
{
  {
    init_simple_test("BFu8ll_B_BFu32ll");
    static BFu8ll_B_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu8ll_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu8ll_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu32ll(Test_BFu8ll_B_BFu32ll, "BFu8ll_B_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu33  {
  __tsu64 v1:8;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 BFu8ll_B_BFu33) C1{ FL:8 Fc FL:33}



static void Test_BFu8ll_B_BFu33()
{
  {
    init_simple_test("BFu8ll_B_BFu33");
    static BFu8ll_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu33");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu8ll_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu8ll_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu33(Test_BFu8ll_B_BFu33, "BFu8ll_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu7c  {
  __tsu64 v1:8;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 BFu8ll_B_BFu7c) C1{ FL:8 Fc Fc:7}



static void Test_BFu8ll_B_BFu7c()
{
  {
    init_simple_test("BFu8ll_B_BFu7c");
    static BFu8ll_B_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu7c");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8ll_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8ll_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu7c(Test_BFu8ll_B_BFu7c, "BFu8ll_B_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu7i  {
  __tsu64 v1:8;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 BFu8ll_B_BFu7i) C1{ FL:8 Fc Fi:7}



static void Test_BFu8ll_B_BFu7i()
{
  {
    init_simple_test("BFu8ll_B_BFu7i");
    static BFu8ll_B_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu7i");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8ll_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8ll_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu7i(Test_BFu8ll_B_BFu7i, "BFu8ll_B_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu7ll  {
  __tsu64 v1:8;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 BFu8ll_B_BFu7ll) C1{ FL:8 Fc FL:7}



static void Test_BFu8ll_B_BFu7ll()
{
  {
    init_simple_test("BFu8ll_B_BFu7ll");
    static BFu8ll_B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8ll_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8ll_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu7ll(Test_BFu8ll_B_BFu7ll, "BFu8ll_B_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu7s  {
  __tsu64 v1:8;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 BFu8ll_B_BFu7s) C1{ FL:8 Fc Fs:7}



static void Test_BFu8ll_B_BFu7s()
{
  {
    init_simple_test("BFu8ll_B_BFu7s");
    static BFu8ll_B_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu7s");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8ll_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8ll_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu7s(Test_BFu8ll_B_BFu7s, "BFu8ll_B_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu8c  {
  __tsu64 v1:8;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 BFu8ll_B_BFu8c) C1{ FL:8 Fc Fc:8}



static void Test_BFu8ll_B_BFu8c()
{
  {
    init_simple_test("BFu8ll_B_BFu8c");
    static BFu8ll_B_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu8c");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8ll_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu8c(Test_BFu8ll_B_BFu8c, "BFu8ll_B_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu8i  {
  __tsu64 v1:8;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 BFu8ll_B_BFu8i) C1{ FL:8 Fc Fi:8}



static void Test_BFu8ll_B_BFu8i()
{
  {
    init_simple_test("BFu8ll_B_BFu8i");
    static BFu8ll_B_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu8i");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8ll_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu8i(Test_BFu8ll_B_BFu8i, "BFu8ll_B_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu8ll  {
  __tsu64 v1:8;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 BFu8ll_B_BFu8ll) C1{ FL:8 Fc FL:8}



static void Test_BFu8ll_B_BFu8ll()
{
  {
    init_simple_test("BFu8ll_B_BFu8ll");
    static BFu8ll_B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8ll_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu8ll(Test_BFu8ll_B_BFu8ll, "BFu8ll_B_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu8s  {
  __tsu64 v1:8;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 BFu8ll_B_BFu8s) C1{ FL:8 Fc Fs:8}



static void Test_BFu8ll_B_BFu8s()
{
  {
    init_simple_test("BFu8ll_B_BFu8s");
    static BFu8ll_B_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu8s");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8ll_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu8s(Test_BFu8ll_B_BFu8s, "BFu8ll_B_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu9i  {
  __tsu64 v1:8;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 BFu8ll_B_BFu9i) C1{ FL:8 Fc Fi:9}



static void Test_BFu8ll_B_BFu9i()
{
  {
    init_simple_test("BFu8ll_B_BFu9i");
    static BFu8ll_B_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu9i");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8ll_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8ll_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu9i(Test_BFu8ll_B_BFu9i, "BFu8ll_B_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu9ll  {
  __tsu64 v1:8;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 BFu8ll_B_BFu9ll) C1{ FL:8 Fc FL:9}



static void Test_BFu8ll_B_BFu9ll()
{
  {
    init_simple_test("BFu8ll_B_BFu9ll");
    static BFu8ll_B_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8ll_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8ll_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu9ll(Test_BFu8ll_B_BFu9ll, "BFu8ll_B_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_BFu9s  {
  __tsu64 v1:8;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 BFu8ll_B_BFu9s) C1{ FL:8 Fc Fs:9}



static void Test_BFu8ll_B_BFu9s()
{
  {
    init_simple_test("BFu8ll_B_BFu9s");
    static BFu8ll_B_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_BFu9s");
    check_field_offset(lv, v2, 1, "BFu8ll_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8ll_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8ll_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_BFu9s(Test_BFu8ll_B_BFu9s, "BFu8ll_B_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_C  {
  __tsu64 v1:8;
  bool v2;
  char v3;
};
//SIG(1 BFu8ll_B_C) C1{ FL:8 Fc[2]}



static void Test_BFu8ll_B_C()
{
  {
    init_simple_test("BFu8ll_B_C");
    static BFu8ll_B_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_C");
    check_field_offset(lv, v2, 1, "BFu8ll_B_C.v2");
    check_field_offset(lv, v3, 2, "BFu8ll_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_C(Test_BFu8ll_B_C, "BFu8ll_B_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_D  {
  __tsu64 v1:8;
  bool v2;
  double v3;
};
//SIG(1 BFu8ll_B_D) C1{ FL:8 Fc FL}



static void Test_BFu8ll_B_D()
{
  {
    init_simple_test("BFu8ll_B_D");
    static BFu8ll_B_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8ll_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_D");
    check_field_offset(lv, v2, 1, "BFu8ll_B_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8ll_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_D(Test_BFu8ll_B_D, "BFu8ll_B_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_F  {
  __tsu64 v1:8;
  bool v2;
  float v3;
};
//SIG(1 BFu8ll_B_F) C1{ FL:8 Fc Fi}



static void Test_BFu8ll_B_F()
{
  {
    init_simple_test("BFu8ll_B_F");
    static BFu8ll_B_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_B_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_F");
    check_field_offset(lv, v2, 1, "BFu8ll_B_F.v2");
    check_field_offset(lv, v3, 4, "BFu8ll_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_F(Test_BFu8ll_B_F, "BFu8ll_B_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_I  {
  __tsu64 v1:8;
  bool v2;
  int v3;
};
//SIG(1 BFu8ll_B_I) C1{ FL:8 Fc Fi}



static void Test_BFu8ll_B_I()
{
  {
    init_simple_test("BFu8ll_B_I");
    static BFu8ll_B_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_B_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_I");
    check_field_offset(lv, v2, 1, "BFu8ll_B_I.v2");
    check_field_offset(lv, v3, 4, "BFu8ll_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_I(Test_BFu8ll_B_I, "BFu8ll_B_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_Ip  {
  __tsu64 v1:8;
  bool v2;
  int *v3;
};
//SIG(1 BFu8ll_B_Ip) C1{ FL:8 Fc Fp}



static void Test_BFu8ll_B_Ip()
{
  {
    init_simple_test("BFu8ll_B_Ip");
    static BFu8ll_B_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8ll_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_Ip");
    check_field_offset(lv, v2, 1, "BFu8ll_B_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8ll_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_Ip(Test_BFu8ll_B_Ip, "BFu8ll_B_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_L  {
  __tsu64 v1:8;
  bool v2;
  __tsi64 v3;
};
//SIG(1 BFu8ll_B_L) C1{ FL:8 Fc FL}



static void Test_BFu8ll_B_L()
{
  {
    init_simple_test("BFu8ll_B_L");
    static BFu8ll_B_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8ll_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_L");
    check_field_offset(lv, v2, 1, "BFu8ll_B_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8ll_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_L(Test_BFu8ll_B_L, "BFu8ll_B_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_S  {
  __tsu64 v1:8;
  bool v2;
  short v3;
};
//SIG(1 BFu8ll_B_S) C1{ FL:8 Fc Fs}



static void Test_BFu8ll_B_S()
{
  {
    init_simple_test("BFu8ll_B_S");
    static BFu8ll_B_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_S");
    check_field_offset(lv, v2, 1, "BFu8ll_B_S.v2");
    check_field_offset(lv, v3, 2, "BFu8ll_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_S(Test_BFu8ll_B_S, "BFu8ll_B_S", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_Uc  {
  __tsu64 v1:8;
  bool v2;
  unsigned char v3;
};
//SIG(1 BFu8ll_B_Uc) C1{ FL:8 Fc[2]}



static void Test_BFu8ll_B_Uc()
{
  {
    init_simple_test("BFu8ll_B_Uc");
    static BFu8ll_B_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_Uc");
    check_field_offset(lv, v2, 1, "BFu8ll_B_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu8ll_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_Uc(Test_BFu8ll_B_Uc, "BFu8ll_B_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_Ui  {
  __tsu64 v1:8;
  bool v2;
  unsigned int v3;
};
//SIG(1 BFu8ll_B_Ui) C1{ FL:8 Fc Fi}



static void Test_BFu8ll_B_Ui()
{
  {
    init_simple_test("BFu8ll_B_Ui");
    static BFu8ll_B_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_B_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_Ui");
    check_field_offset(lv, v2, 1, "BFu8ll_B_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu8ll_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_Ui(Test_BFu8ll_B_Ui, "BFu8ll_B_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_Ul  {
  __tsu64 v1:8;
  bool v2;
  __tsu64 v3;
};
//SIG(1 BFu8ll_B_Ul) C1{ FL:8 Fc FL}



static void Test_BFu8ll_B_Ul()
{
  {
    init_simple_test("BFu8ll_B_Ul");
    static BFu8ll_B_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8ll_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_Ul");
    check_field_offset(lv, v2, 1, "BFu8ll_B_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8ll_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_Ul(Test_BFu8ll_B_Ul, "BFu8ll_B_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_Us  {
  __tsu64 v1:8;
  bool v2;
  unsigned short v3;
};
//SIG(1 BFu8ll_B_Us) C1{ FL:8 Fc Fs}



static void Test_BFu8ll_B_Us()
{
  {
    init_simple_test("BFu8ll_B_Us");
    static BFu8ll_B_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_B_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_Us");
    check_field_offset(lv, v2, 1, "BFu8ll_B_Us.v2");
    check_field_offset(lv, v3, 2, "BFu8ll_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_Us(Test_BFu8ll_B_Us, "BFu8ll_B_Us", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_B_Vp  {
  __tsu64 v1:8;
  bool v2;
  void *v3;
};
//SIG(1 BFu8ll_B_Vp) C1{ FL:8 Fc Fp}



static void Test_BFu8ll_B_Vp()
{
  {
    init_simple_test("BFu8ll_B_Vp");
    static BFu8ll_B_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8ll_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_B_Vp");
    check_field_offset(lv, v2, 1, "BFu8ll_B_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8ll_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_B_Vp(Test_BFu8ll_B_Vp, "BFu8ll_B_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu15i_B  {
  __tsu64 v1:8;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 BFu8ll_BFu15i_B) C1{ FL:8 Fi:15 Fc}



static void Test_BFu8ll_BFu15i_B()
{
  {
    init_simple_test("BFu8ll_BFu15i_B");
    static BFu8ll_BFu15i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu15i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8ll_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8ll_BFu15i_B");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu15i_B(Test_BFu8ll_BFu15i_B, "BFu8ll_BFu15i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu15ll_B  {
  __tsu64 v1:8;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 BFu8ll_BFu15ll_B) C1{ FL:8 FL:15 Fc}



static void Test_BFu8ll_BFu15ll_B()
{
  {
    init_simple_test("BFu8ll_BFu15ll_B");
    static BFu8ll_BFu15ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8ll_BFu15ll_B");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu15ll_B(Test_BFu8ll_BFu15ll_B, "BFu8ll_BFu15ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu15s_B  {
  __tsu64 v1:8;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 BFu8ll_BFu15s_B) C1{ FL:8 Fs:15 Fc}



static void Test_BFu8ll_BFu15s_B()
{
  {
    init_simple_test("BFu8ll_BFu15s_B");
    static BFu8ll_BFu15s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_BFu15s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu8ll_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu8ll_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu8ll_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu15s_B(Test_BFu8ll_BFu15s_B, "BFu8ll_BFu15s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu16i_B  {
  __tsu64 v1:8;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 BFu8ll_BFu16i_B) C1{ FL:8 Fi:16 Fc}



static void Test_BFu8ll_BFu16i_B()
{
  {
    init_simple_test("BFu8ll_BFu16i_B");
    static BFu8ll_BFu16i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu16i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8ll_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8ll_BFu16i_B");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu16i_B(Test_BFu8ll_BFu16i_B, "BFu8ll_BFu16i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu16ll_B  {
  __tsu64 v1:8;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 BFu8ll_BFu16ll_B) C1{ FL:8 FL:16 Fc}



static void Test_BFu8ll_BFu16ll_B()
{
  {
    init_simple_test("BFu8ll_BFu16ll_B");
    static BFu8ll_BFu16ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8ll_BFu16ll_B");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu16ll_B(Test_BFu8ll_BFu16ll_B, "BFu8ll_BFu16ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu16s_B  {
  __tsu64 v1:8;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 BFu8ll_BFu16s_B) C1{ FL:8 Fs:16 Fc}



static void Test_BFu8ll_BFu16s_B()
{
  {
    init_simple_test("BFu8ll_BFu16s_B");
    static BFu8ll_BFu16s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_BFu16s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu8ll_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu8ll_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu8ll_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu16s_B(Test_BFu8ll_BFu16s_B, "BFu8ll_BFu16s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu17i_B  {
  __tsu64 v1:8;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 BFu8ll_BFu17i_B) C1{ FL:8 Fi:17 Fc}



static void Test_BFu8ll_BFu17i_B()
{
  {
    init_simple_test("BFu8ll_BFu17i_B");
    static BFu8ll_BFu17i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_BFu17i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8ll_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8ll_BFu17i_B");
    check_field_offset(lv, v3, 4, "BFu8ll_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu17i_B(Test_BFu8ll_BFu17i_B, "BFu8ll_BFu17i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu17ll_B  {
  __tsu64 v1:8;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 BFu8ll_BFu17ll_B) C1{ FL:8 FL:17 Fc}



static void Test_BFu8ll_BFu17ll_B()
{
  {
    init_simple_test("BFu8ll_BFu17ll_B");
    static BFu8ll_BFu17ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8ll_BFu17ll_B");
    check_field_offset(lv, v3, 4, "BFu8ll_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu17ll_B(Test_BFu8ll_BFu17ll_B, "BFu8ll_BFu17ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu1c_B  {
  __tsu64 v1:8;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 BFu8ll_BFu1c_B) C1{ FL:8 Fc:1 Fc}



static void Test_BFu8ll_BFu1c_B()
{
  {
    init_simple_test("BFu8ll_BFu1c_B");
    static BFu8ll_BFu1c_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu1c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8ll_BFu1c_B");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu1c_B(Test_BFu8ll_BFu1c_B, "BFu8ll_BFu1c_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu1i_B  {
  __tsu64 v1:8;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 BFu8ll_BFu1i_B) C1{ FL:8 Fi:1 Fc}



static void Test_BFu8ll_BFu1i_B()
{
  {
    init_simple_test("BFu8ll_BFu1i_B");
    static BFu8ll_BFu1i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu1i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8ll_BFu1i_B");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu1i_B(Test_BFu8ll_BFu1i_B, "BFu8ll_BFu1i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu1ll_B  {
  __tsu64 v1:8;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 BFu8ll_BFu1ll_B) C1{ FL:8 FL:1 Fc}



static void Test_BFu8ll_BFu1ll_B()
{
  {
    init_simple_test("BFu8ll_BFu1ll_B");
    static BFu8ll_BFu1ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8ll_BFu1ll_B");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu1ll_B(Test_BFu8ll_BFu1ll_B, "BFu8ll_BFu1ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu1s_B  {
  __tsu64 v1:8;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 BFu8ll_BFu1s_B) C1{ FL:8 Fs:1 Fc}



static void Test_BFu8ll_BFu1s_B()
{
  {
    init_simple_test("BFu8ll_BFu1s_B");
    static BFu8ll_BFu1s_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu1s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8ll_BFu1s_B");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu1s_B(Test_BFu8ll_BFu1s_B, "BFu8ll_BFu1s_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu31i_B  {
  __tsu64 v1:8;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 BFu8ll_BFu31i_B) C1{ FL:8 Fi:31 Fc}



static void Test_BFu8ll_BFu31i_B()
{
  {
    init_simple_test("BFu8ll_BFu31i_B");
    static BFu8ll_BFu31i_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8ll_BFu31i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu8ll_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu8ll_BFu31i_B");
    check_field_offset(lv, v3, 8, "BFu8ll_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu31i_B(Test_BFu8ll_BFu31i_B, "BFu8ll_BFu31i_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu31ll_B  {
  __tsu64 v1:8;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 BFu8ll_BFu31ll_B) C1{ FL:8 FL:31 Fc}



static void Test_BFu8ll_BFu31ll_B()
{
  {
    init_simple_test("BFu8ll_BFu31ll_B");
    static BFu8ll_BFu31ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu8ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu8ll_BFu31ll_B");
    check_field_offset(lv, v3, 5, "BFu8ll_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu31ll_B(Test_BFu8ll_BFu31ll_B, "BFu8ll_BFu31ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu32i_B  {
  __tsu64 v1:8;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 BFu8ll_BFu32i_B) C1{ FL:8 Fi:32 Fc}



static void Test_BFu8ll_BFu32i_B()
{
  {
    init_simple_test("BFu8ll_BFu32i_B");
    static BFu8ll_BFu32i_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8ll_BFu32i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu8ll_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu8ll_BFu32i_B");
    check_field_offset(lv, v3, 8, "BFu8ll_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu32i_B(Test_BFu8ll_BFu32i_B, "BFu8ll_BFu32i_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu32ll_B  {
  __tsu64 v1:8;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 BFu8ll_BFu32ll_B) C1{ FL:8 FL:32 Fc}



static void Test_BFu8ll_BFu32ll_B()
{
  {
    init_simple_test("BFu8ll_BFu32ll_B");
    static BFu8ll_BFu32ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu8ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu8ll_BFu32ll_B");
    check_field_offset(lv, v3, 5, "BFu8ll_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu32ll_B(Test_BFu8ll_BFu32ll_B, "BFu8ll_BFu32ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu33_B  {
  __tsu64 v1:8;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 BFu8ll_BFu33_B) C1{ FL:8 FL:33 Fc}



static void Test_BFu8ll_BFu33_B()
{
  {
    init_simple_test("BFu8ll_BFu33_B");
    static BFu8ll_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8ll_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8ll_BFu33_B");
    check_field_offset(lv, v3, 6, "BFu8ll_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu33_B(Test_BFu8ll_BFu33_B, "BFu8ll_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu7c_B  {
  __tsu64 v1:8;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 BFu8ll_BFu7c_B) C1{ FL:8 Fc:7 Fc}



static void Test_BFu8ll_BFu7c_B()
{
  {
    init_simple_test("BFu8ll_BFu7c_B");
    static BFu8ll_BFu7c_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu7c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8ll_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8ll_BFu7c_B");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu7c_B(Test_BFu8ll_BFu7c_B, "BFu8ll_BFu7c_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu7i_B  {
  __tsu64 v1:8;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 BFu8ll_BFu7i_B) C1{ FL:8 Fi:7 Fc}



static void Test_BFu8ll_BFu7i_B()
{
  {
    init_simple_test("BFu8ll_BFu7i_B");
    static BFu8ll_BFu7i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu7i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8ll_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8ll_BFu7i_B");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu7i_B(Test_BFu8ll_BFu7i_B, "BFu8ll_BFu7i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu7ll_B  {
  __tsu64 v1:8;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 BFu8ll_BFu7ll_B) C1{ FL:8 FL:7 Fc}



static void Test_BFu8ll_BFu7ll_B()
{
  {
    init_simple_test("BFu8ll_BFu7ll_B");
    static BFu8ll_BFu7ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8ll_BFu7ll_B");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu7ll_B(Test_BFu8ll_BFu7ll_B, "BFu8ll_BFu7ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu7s_B  {
  __tsu64 v1:8;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 BFu8ll_BFu7s_B) C1{ FL:8 Fs:7 Fc}



static void Test_BFu8ll_BFu7s_B()
{
  {
    init_simple_test("BFu8ll_BFu7s_B");
    static BFu8ll_BFu7s_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu7s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8ll_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8ll_BFu7s_B");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu7s_B(Test_BFu8ll_BFu7s_B, "BFu8ll_BFu7s_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu8c_B  {
  __tsu64 v1:8;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 BFu8ll_BFu8c_B) C1{ FL:8 Fc:8 Fc}



static void Test_BFu8ll_BFu8c_B()
{
  {
    init_simple_test("BFu8ll_BFu8c_B");
    static BFu8ll_BFu8c_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu8c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8ll_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8c_B");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu8c_B(Test_BFu8ll_BFu8c_B, "BFu8ll_BFu8c_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu8i_B  {
  __tsu64 v1:8;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 BFu8ll_BFu8i_B) C1{ FL:8 Fi:8 Fc}



static void Test_BFu8ll_BFu8i_B()
{
  {
    init_simple_test("BFu8ll_BFu8i_B");
    static BFu8ll_BFu8i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu8i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8ll_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8i_B");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu8i_B(Test_BFu8ll_BFu8i_B, "BFu8ll_BFu8i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu8ll_B  {
  __tsu64 v1:8;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 BFu8ll_BFu8ll_B) C1{ FL:8 FL:8 Fc}



static void Test_BFu8ll_BFu8ll_B()
{
  {
    init_simple_test("BFu8ll_BFu8ll_B");
    static BFu8ll_BFu8ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8ll_B");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu8ll_B(Test_BFu8ll_BFu8ll_B, "BFu8ll_BFu8ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu8s_B  {
  __tsu64 v1:8;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 BFu8ll_BFu8s_B) C1{ FL:8 Fs:8 Fc}



static void Test_BFu8ll_BFu8s_B()
{
  {
    init_simple_test("BFu8ll_BFu8s_B");
    static BFu8ll_BFu8s_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu8s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8ll_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu8s_B");
    check_field_offset(lv, v3, 2, "BFu8ll_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu8s_B(Test_BFu8ll_BFu8s_B, "BFu8ll_BFu8s_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu9i_B  {
  __tsu64 v1:8;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 BFu8ll_BFu9i_B) C1{ FL:8 Fi:9 Fc}



static void Test_BFu8ll_BFu9i_B()
{
  {
    init_simple_test("BFu8ll_BFu9i_B");
    static BFu8ll_BFu9i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu9i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8ll_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8ll_BFu9i_B");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu9i_B(Test_BFu8ll_BFu9i_B, "BFu8ll_BFu9i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu9ll_B  {
  __tsu64 v1:8;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 BFu8ll_BFu9ll_B) C1{ FL:8 FL:9 Fc}



static void Test_BFu8ll_BFu9ll_B()
{
  {
    init_simple_test("BFu8ll_BFu9ll_B");
    static BFu8ll_BFu9ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8ll_BFu9ll_B");
    check_field_offset(lv, v3, 3, "BFu8ll_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu9ll_B(Test_BFu8ll_BFu9ll_B, "BFu8ll_BFu9ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_BFu9s_B  {
  __tsu64 v1:8;
  unsigned short v2:9;
  bool v3;
};
//SIG(1 BFu8ll_BFu9s_B) C1{ FL:8 Fs:9 Fc}



static void Test_BFu8ll_BFu9s_B()
{
  {
    init_simple_test("BFu8ll_BFu9s_B");
    static BFu8ll_BFu9s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_BFu9s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8ll_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8ll_BFu9s_B");
    check_field_offset(lv, v3, 4, "BFu8ll_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_BFu9s_B(Test_BFu8ll_BFu9s_B, "BFu8ll_BFu9s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_C_B  {
  __tsu64 v1:8;
  char v2;
  bool v3;
};
//SIG(1 BFu8ll_C_B) C1{ FL:8 Fc[2]}



static void Test_BFu8ll_C_B()
{
  {
    init_simple_test("BFu8ll_C_B");
    static BFu8ll_C_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_C_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_C_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_C_B");
    check_field_offset(lv, v2, 1, "BFu8ll_C_B.v2");
    check_field_offset(lv, v3, 2, "BFu8ll_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_C_B(Test_BFu8ll_C_B, "BFu8ll_C_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_D_B  {
  __tsu64 v1:8;
  double v2;
  bool v3;
};
//SIG(1 BFu8ll_D_B) C1{ FL:8 FL Fc}



static void Test_BFu8ll_D_B()
{
  {
    init_simple_test("BFu8ll_D_B");
    static BFu8ll_D_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8ll_D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_D_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_D_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8ll_D_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8ll_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_D_B(Test_BFu8ll_D_B, "BFu8ll_D_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_F_B  {
  __tsu64 v1:8;
  float v2;
  bool v3;
};
//SIG(1 BFu8ll_F_B) C1{ FL:8 Fi Fc}



static void Test_BFu8ll_F_B()
{
  {
    init_simple_test("BFu8ll_F_B");
    static BFu8ll_F_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8ll_F_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_F_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_F_B");
    check_field_offset(lv, v2, 4, "BFu8ll_F_B.v2");
    check_field_offset(lv, v3, 8, "BFu8ll_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_F_B(Test_BFu8ll_F_B, "BFu8ll_F_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_I_B  {
  __tsu64 v1:8;
  int v2;
  bool v3;
};
//SIG(1 BFu8ll_I_B) C1{ FL:8 Fi Fc}



static void Test_BFu8ll_I_B()
{
  {
    init_simple_test("BFu8ll_I_B");
    static BFu8ll_I_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8ll_I_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_I_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_I_B");
    check_field_offset(lv, v2, 4, "BFu8ll_I_B.v2");
    check_field_offset(lv, v3, 8, "BFu8ll_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_I_B(Test_BFu8ll_I_B, "BFu8ll_I_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_Ip_B  {
  __tsu64 v1:8;
  int *v2;
  bool v3;
};
//SIG(1 BFu8ll_Ip_B) C1{ FL:8 Fp Fc}



static void Test_BFu8ll_Ip_B()
{
  {
    init_simple_test("BFu8ll_Ip_B");
    static BFu8ll_Ip_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8ll_Ip_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Ip_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8ll_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8ll_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_Ip_B(Test_BFu8ll_Ip_B, "BFu8ll_Ip_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_L_B  {
  __tsu64 v1:8;
  __tsi64 v2;
  bool v3;
};
//SIG(1 BFu8ll_L_B) C1{ FL:8 FL Fc}



static void Test_BFu8ll_L_B()
{
  {
    init_simple_test("BFu8ll_L_B");
    static BFu8ll_L_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8ll_L_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_L_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_L_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8ll_L_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8ll_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_L_B(Test_BFu8ll_L_B, "BFu8ll_L_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_S_B  {
  __tsu64 v1:8;
  short v2;
  bool v3;
};
//SIG(1 BFu8ll_S_B) C1{ FL:8 Fs Fc}



static void Test_BFu8ll_S_B()
{
  {
    init_simple_test("BFu8ll_S_B");
    static BFu8ll_S_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_S_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_S_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_S_B");
    check_field_offset(lv, v2, 2, "BFu8ll_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu8ll_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_S_B(Test_BFu8ll_S_B, "BFu8ll_S_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_Uc_B  {
  __tsu64 v1:8;
  unsigned char v2;
  bool v3;
};
//SIG(1 BFu8ll_Uc_B) C1{ FL:8 Fc[2]}



static void Test_BFu8ll_Uc_B()
{
  {
    init_simple_test("BFu8ll_Uc_B");
    static BFu8ll_Uc_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8ll_Uc_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Uc_B");
    check_field_offset(lv, v2, 1, "BFu8ll_Uc_B.v2");
    check_field_offset(lv, v3, 2, "BFu8ll_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_Uc_B(Test_BFu8ll_Uc_B, "BFu8ll_Uc_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_Ui_B  {
  __tsu64 v1:8;
  unsigned int v2;
  bool v3;
};
//SIG(1 BFu8ll_Ui_B) C1{ FL:8 Fi Fc}



static void Test_BFu8ll_Ui_B()
{
  {
    init_simple_test("BFu8ll_Ui_B");
    static BFu8ll_Ui_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8ll_Ui_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Ui_B");
    check_field_offset(lv, v2, 4, "BFu8ll_Ui_B.v2");
    check_field_offset(lv, v3, 8, "BFu8ll_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_Ui_B(Test_BFu8ll_Ui_B, "BFu8ll_Ui_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_Ul_B  {
  __tsu64 v1:8;
  __tsu64 v2;
  bool v3;
};
//SIG(1 BFu8ll_Ul_B) C1{ FL:8 FL Fc}



static void Test_BFu8ll_Ul_B()
{
  {
    init_simple_test("BFu8ll_Ul_B");
    static BFu8ll_Ul_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8ll_Ul_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Ul_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8ll_Ul_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8ll_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_Ul_B(Test_BFu8ll_Ul_B, "BFu8ll_Ul_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_Us_B  {
  __tsu64 v1:8;
  unsigned short v2;
  bool v3;
};
//SIG(1 BFu8ll_Us_B) C1{ FL:8 Fs Fc}



static void Test_BFu8ll_Us_B()
{
  {
    init_simple_test("BFu8ll_Us_B");
    static BFu8ll_Us_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8ll_Us_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Us_B");
    check_field_offset(lv, v2, 2, "BFu8ll_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu8ll_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_Us_B(Test_BFu8ll_Us_B, "BFu8ll_Us_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8ll_Vp_B  {
  __tsu64 v1:8;
  void *v2;
  bool v3;
};
//SIG(1 BFu8ll_Vp_B) C1{ FL:8 Fp Fc}



static void Test_BFu8ll_Vp_B()
{
  {
    init_simple_test("BFu8ll_Vp_B");
    static BFu8ll_Vp_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8ll_Vp_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8ll_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8ll_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8ll_Vp_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8ll_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8ll_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8ll_Vp_B(Test_BFu8ll_Vp_B, "BFu8ll_Vp_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B  {
  unsigned short v1:8;
  bool v2;
};
//SIG(1 BFu8s_B) C1{ Fs:8 Fc}



static void Test_BFu8s_B()
{
  {
    init_simple_test("BFu8s_B");
    static BFu8s_B lv;
    check2(sizeof(lv), 2, "sizeof(BFu8s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B");
    check_field_offset(lv, v2, 1, "BFu8s_B.v2");
  }
}
static Arrange_To_Call_Me vBFu8s_B(Test_BFu8s_B, "BFu8s_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_B  {
  unsigned short v1:8;
  bool v2;
  bool v3;
};
//SIG(1 BFu8s_B_B) C1{ Fs:8 Fc[2]}



static void Test_BFu8s_B_B()
{
  {
    init_simple_test("BFu8s_B_B");
    static BFu8s_B_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_B");
    check_field_offset(lv, v2, 1, "BFu8s_B_B.v2");
    check_field_offset(lv, v3, 2, "BFu8s_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_B_B(Test_BFu8s_B_B, "BFu8s_B_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu15i  {
  unsigned short v1:8;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 BFu8s_B_BFu15i) C1{ Fs:8 Fc Fi:15}



static void Test_BFu8s_B_BFu15i()
{
  {
    init_simple_test("BFu8s_B_BFu15i");
    static BFu8s_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu15i");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8s_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8s_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu15i(Test_BFu8s_B_BFu15i, "BFu8s_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu15ll  {
  unsigned short v1:8;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 BFu8s_B_BFu15ll) C1{ Fs:8 Fc FL:15}



static void Test_BFu8s_B_BFu15ll()
{
  {
    init_simple_test("BFu8s_B_BFu15ll");
    static BFu8s_B_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8s_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8s_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8s_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu15ll(Test_BFu8s_B_BFu15ll, "BFu8s_B_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu15s  {
  unsigned short v1:8;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 BFu8s_B_BFu15s) C1{ Fs:8 Fc Fs:15}



static void Test_BFu8s_B_BFu15s()
{
  {
    init_simple_test("BFu8s_B_BFu15s");
    static BFu8s_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu15s");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu8s_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu8s_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu15s(Test_BFu8s_B_BFu15s, "BFu8s_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu16i  {
  unsigned short v1:8;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 BFu8s_B_BFu16i) C1{ Fs:8 Fc Fi:16}



static void Test_BFu8s_B_BFu16i()
{
  {
    init_simple_test("BFu8s_B_BFu16i");
    static BFu8s_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu16i");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8s_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8s_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu16i(Test_BFu8s_B_BFu16i, "BFu8s_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu16ll  {
  unsigned short v1:8;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 BFu8s_B_BFu16ll) C1{ Fs:8 Fc FL:16}



static void Test_BFu8s_B_BFu16ll()
{
  {
    init_simple_test("BFu8s_B_BFu16ll");
    static BFu8s_B_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8s_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8s_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8s_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu16ll(Test_BFu8s_B_BFu16ll, "BFu8s_B_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu16s  {
  unsigned short v1:8;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 BFu8s_B_BFu16s) C1{ Fs:8 Fc Fs:16}



static void Test_BFu8s_B_BFu16s()
{
  {
    init_simple_test("BFu8s_B_BFu16s");
    static BFu8s_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu16s");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu8s_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu8s_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu16s(Test_BFu8s_B_BFu16s, "BFu8s_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu17i  {
  unsigned short v1:8;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 BFu8s_B_BFu17i) C1{ Fs:8 Fc Fi:17}



static void Test_BFu8s_B_BFu17i()
{
  {
    init_simple_test("BFu8s_B_BFu17i");
    static BFu8s_B_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_B_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu17i");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu8s_B_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu8s_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu17i(Test_BFu8s_B_BFu17i, "BFu8s_B_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu17ll  {
  unsigned short v1:8;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 BFu8s_B_BFu17ll) C1{ Fs:8 Fc FL:17}



static void Test_BFu8s_B_BFu17ll()
{
  {
    init_simple_test("BFu8s_B_BFu17ll");
    static BFu8s_B_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu8s_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu8s_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu17ll(Test_BFu8s_B_BFu17ll, "BFu8s_B_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu1c  {
  unsigned short v1:8;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 BFu8s_B_BFu1c) C1{ Fs:8 Fc Fc:1}



static void Test_BFu8s_B_BFu1c()
{
  {
    init_simple_test("BFu8s_B_BFu1c");
    static BFu8s_B_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu1c");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8s_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu1c(Test_BFu8s_B_BFu1c, "BFu8s_B_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu1i  {
  unsigned short v1:8;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 BFu8s_B_BFu1i) C1{ Fs:8 Fc Fi:1}



static void Test_BFu8s_B_BFu1i()
{
  {
    init_simple_test("BFu8s_B_BFu1i");
    static BFu8s_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu1i");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8s_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu1i(Test_BFu8s_B_BFu1i, "BFu8s_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu1ll  {
  unsigned short v1:8;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 BFu8s_B_BFu1ll) C1{ Fs:8 Fc FL:1}



static void Test_BFu8s_B_BFu1ll()
{
  {
    init_simple_test("BFu8s_B_BFu1ll");
    static BFu8s_B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8s_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8s_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu1ll(Test_BFu8s_B_BFu1ll, "BFu8s_B_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu1s  {
  unsigned short v1:8;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 BFu8s_B_BFu1s) C1{ Fs:8 Fc Fs:1}



static void Test_BFu8s_B_BFu1s()
{
  {
    init_simple_test("BFu8s_B_BFu1s");
    static BFu8s_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu1s");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu8s_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu1s(Test_BFu8s_B_BFu1s, "BFu8s_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu31i  {
  unsigned short v1:8;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 BFu8s_B_BFu31i) C1{ Fs:8 Fc Fi:31}



static void Test_BFu8s_B_BFu31i()
{
  {
    init_simple_test("BFu8s_B_BFu31i");
    static BFu8s_B_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_B_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu31i");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu8s_B_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu8s_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu31i(Test_BFu8s_B_BFu31i, "BFu8s_B_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu31ll  {
  unsigned short v1:8;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 BFu8s_B_BFu31ll) C1{ Fs:8 Fc FL:31}



static void Test_BFu8s_B_BFu31ll()
{
  {
    init_simple_test("BFu8s_B_BFu31ll");
    static BFu8s_B_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu8s_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu8s_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu31ll(Test_BFu8s_B_BFu31ll, "BFu8s_B_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu32i  {
  unsigned short v1:8;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 BFu8s_B_BFu32i) C1{ Fs:8 Fc Fi:32}



static void Test_BFu8s_B_BFu32i()
{
  {
    init_simple_test("BFu8s_B_BFu32i");
    static BFu8s_B_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_B_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu32i");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu8s_B_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu8s_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu32i(Test_BFu8s_B_BFu32i, "BFu8s_B_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu32ll  {
  unsigned short v1:8;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 BFu8s_B_BFu32ll) C1{ Fs:8 Fc FL:32}



static void Test_BFu8s_B_BFu32ll()
{
  {
    init_simple_test("BFu8s_B_BFu32ll");
    static BFu8s_B_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu8s_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu8s_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu32ll(Test_BFu8s_B_BFu32ll, "BFu8s_B_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu33  {
  unsigned short v1:8;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 BFu8s_B_BFu33) C1{ Fs:8 Fc FL:33}



static void Test_BFu8s_B_BFu33()
{
  {
    init_simple_test("BFu8s_B_BFu33");
    static BFu8s_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu33");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu8s_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu8s_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu33(Test_BFu8s_B_BFu33, "BFu8s_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu7c  {
  unsigned short v1:8;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 BFu8s_B_BFu7c) C1{ Fs:8 Fc Fc:7}



static void Test_BFu8s_B_BFu7c()
{
  {
    init_simple_test("BFu8s_B_BFu7c");
    static BFu8s_B_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu7c");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8s_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8s_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu7c(Test_BFu8s_B_BFu7c, "BFu8s_B_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu7i  {
  unsigned short v1:8;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 BFu8s_B_BFu7i) C1{ Fs:8 Fc Fi:7}



static void Test_BFu8s_B_BFu7i()
{
  {
    init_simple_test("BFu8s_B_BFu7i");
    static BFu8s_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu7i");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8s_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8s_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu7i(Test_BFu8s_B_BFu7i, "BFu8s_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu7ll  {
  unsigned short v1:8;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 BFu8s_B_BFu7ll) C1{ Fs:8 Fc FL:7}



static void Test_BFu8s_B_BFu7ll()
{
  {
    init_simple_test("BFu8s_B_BFu7ll");
    static BFu8s_B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8s_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8s_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8s_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu7ll(Test_BFu8s_B_BFu7ll, "BFu8s_B_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu7s  {
  unsigned short v1:8;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 BFu8s_B_BFu7s) C1{ Fs:8 Fc Fs:7}



static void Test_BFu8s_B_BFu7s()
{
  {
    init_simple_test("BFu8s_B_BFu7s");
    static BFu8s_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu7s");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu8s_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu8s_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu7s(Test_BFu8s_B_BFu7s, "BFu8s_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu8c  {
  unsigned short v1:8;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 BFu8s_B_BFu8c) C1{ Fs:8 Fc Fc:8}



static void Test_BFu8s_B_BFu8c()
{
  {
    init_simple_test("BFu8s_B_BFu8c");
    static BFu8s_B_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu8c");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8s_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu8c(Test_BFu8s_B_BFu8c, "BFu8s_B_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu8i  {
  unsigned short v1:8;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 BFu8s_B_BFu8i) C1{ Fs:8 Fc Fi:8}



static void Test_BFu8s_B_BFu8i()
{
  {
    init_simple_test("BFu8s_B_BFu8i");
    static BFu8s_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu8i");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8s_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu8i(Test_BFu8s_B_BFu8i, "BFu8s_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu8ll  {
  unsigned short v1:8;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 BFu8s_B_BFu8ll) C1{ Fs:8 Fc FL:8}



static void Test_BFu8s_B_BFu8ll()
{
  {
    init_simple_test("BFu8s_B_BFu8ll");
    static BFu8s_B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8s_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8s_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu8ll(Test_BFu8s_B_BFu8ll, "BFu8s_B_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu8s  {
  unsigned short v1:8;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 BFu8s_B_BFu8s) C1{ Fs:8 Fc Fs:8}



static void Test_BFu8s_B_BFu8s()
{
  {
    init_simple_test("BFu8s_B_BFu8s");
    static BFu8s_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu8s");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu8s_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu8s(Test_BFu8s_B_BFu8s, "BFu8s_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu9i  {
  unsigned short v1:8;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 BFu8s_B_BFu9i) C1{ Fs:8 Fc Fi:9}



static void Test_BFu8s_B_BFu9i()
{
  {
    init_simple_test("BFu8s_B_BFu9i");
    static BFu8s_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu9i");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8s_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8s_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu9i(Test_BFu8s_B_BFu9i, "BFu8s_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu9ll  {
  unsigned short v1:8;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 BFu8s_B_BFu9ll) C1{ Fs:8 Fc FL:9}



static void Test_BFu8s_B_BFu9ll()
{
  {
    init_simple_test("BFu8s_B_BFu9ll");
    static BFu8s_B_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8s_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8s_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8s_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu9ll(Test_BFu8s_B_BFu9ll, "BFu8s_B_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_BFu9s  {
  unsigned short v1:8;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 BFu8s_B_BFu9s) C1{ Fs:8 Fc Fs:9}



static void Test_BFu8s_B_BFu9s()
{
  {
    init_simple_test("BFu8s_B_BFu9s");
    static BFu8s_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_BFu9s");
    check_field_offset(lv, v2, 1, "BFu8s_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu8s_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu8s_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu8s_B_BFu9s(Test_BFu8s_B_BFu9s, "BFu8s_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_C  {
  unsigned short v1:8;
  bool v2;
  char v3;
};
//SIG(1 BFu8s_B_C) C1{ Fs:8 Fc[2]}



static void Test_BFu8s_B_C()
{
  {
    init_simple_test("BFu8s_B_C");
    static BFu8s_B_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_C");
    check_field_offset(lv, v2, 1, "BFu8s_B_C.v2");
    check_field_offset(lv, v3, 2, "BFu8s_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_B_C(Test_BFu8s_B_C, "BFu8s_B_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_D  {
  unsigned short v1:8;
  bool v2;
  double v3;
};
//SIG(1 BFu8s_B_D) C1{ Fs:8 Fc FL}



static void Test_BFu8s_B_D()
{
  {
    init_simple_test("BFu8s_B_D");
    static BFu8s_B_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8s_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_D");
    check_field_offset(lv, v2, 1, "BFu8s_B_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8s_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_B_D(Test_BFu8s_B_D, "BFu8s_B_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_F  {
  unsigned short v1:8;
  bool v2;
  float v3;
};
//SIG(1 BFu8s_B_F) C1{ Fs:8 Fc Fi}



static void Test_BFu8s_B_F()
{
  {
    init_simple_test("BFu8s_B_F");
    static BFu8s_B_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_B_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_F");
    check_field_offset(lv, v2, 1, "BFu8s_B_F.v2");
    check_field_offset(lv, v3, 4, "BFu8s_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_B_F(Test_BFu8s_B_F, "BFu8s_B_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_I  {
  unsigned short v1:8;
  bool v2;
  int v3;
};
//SIG(1 BFu8s_B_I) C1{ Fs:8 Fc Fi}



static void Test_BFu8s_B_I()
{
  {
    init_simple_test("BFu8s_B_I");
    static BFu8s_B_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_B_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_I");
    check_field_offset(lv, v2, 1, "BFu8s_B_I.v2");
    check_field_offset(lv, v3, 4, "BFu8s_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_B_I(Test_BFu8s_B_I, "BFu8s_B_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_Ip  {
  unsigned short v1:8;
  bool v2;
  int *v3;
};
//SIG(1 BFu8s_B_Ip) C1{ Fs:8 Fc Fp}



static void Test_BFu8s_B_Ip()
{
  {
    init_simple_test("BFu8s_B_Ip");
    static BFu8s_B_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8s_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_Ip");
    check_field_offset(lv, v2, 1, "BFu8s_B_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8s_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_B_Ip(Test_BFu8s_B_Ip, "BFu8s_B_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_L  {
  unsigned short v1:8;
  bool v2;
  __tsi64 v3;
};
//SIG(1 BFu8s_B_L) C1{ Fs:8 Fc FL}



static void Test_BFu8s_B_L()
{
  {
    init_simple_test("BFu8s_B_L");
    static BFu8s_B_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8s_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_L");
    check_field_offset(lv, v2, 1, "BFu8s_B_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8s_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_B_L(Test_BFu8s_B_L, "BFu8s_B_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_S  {
  unsigned short v1:8;
  bool v2;
  short v3;
};
//SIG(1 BFu8s_B_S) C1{ Fs:8 Fc Fs}



static void Test_BFu8s_B_S()
{
  {
    init_simple_test("BFu8s_B_S");
    static BFu8s_B_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_S");
    check_field_offset(lv, v2, 1, "BFu8s_B_S.v2");
    check_field_offset(lv, v3, 2, "BFu8s_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_B_S(Test_BFu8s_B_S, "BFu8s_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_Uc  {
  unsigned short v1:8;
  bool v2;
  unsigned char v3;
};
//SIG(1 BFu8s_B_Uc) C1{ Fs:8 Fc[2]}



static void Test_BFu8s_B_Uc()
{
  {
    init_simple_test("BFu8s_B_Uc");
    static BFu8s_B_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_Uc");
    check_field_offset(lv, v2, 1, "BFu8s_B_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu8s_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_B_Uc(Test_BFu8s_B_Uc, "BFu8s_B_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_Ui  {
  unsigned short v1:8;
  bool v2;
  unsigned int v3;
};
//SIG(1 BFu8s_B_Ui) C1{ Fs:8 Fc Fi}



static void Test_BFu8s_B_Ui()
{
  {
    init_simple_test("BFu8s_B_Ui");
    static BFu8s_B_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_B_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_Ui");
    check_field_offset(lv, v2, 1, "BFu8s_B_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu8s_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_B_Ui(Test_BFu8s_B_Ui, "BFu8s_B_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_Ul  {
  unsigned short v1:8;
  bool v2;
  __tsu64 v3;
};
//SIG(1 BFu8s_B_Ul) C1{ Fs:8 Fc FL}



static void Test_BFu8s_B_Ul()
{
  {
    init_simple_test("BFu8s_B_Ul");
    static BFu8s_B_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu8s_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_Ul");
    check_field_offset(lv, v2, 1, "BFu8s_B_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8s_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_B_Ul(Test_BFu8s_B_Ul, "BFu8s_B_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_Us  {
  unsigned short v1:8;
  bool v2;
  unsigned short v3;
};
//SIG(1 BFu8s_B_Us) C1{ Fs:8 Fc Fs}



static void Test_BFu8s_B_Us()
{
  {
    init_simple_test("BFu8s_B_Us");
    static BFu8s_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_B_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_Us");
    check_field_offset(lv, v2, 1, "BFu8s_B_Us.v2");
    check_field_offset(lv, v3, 2, "BFu8s_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_B_Us(Test_BFu8s_B_Us, "BFu8s_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_B_Vp  {
  unsigned short v1:8;
  bool v2;
  void *v3;
};
//SIG(1 BFu8s_B_Vp) C1{ Fs:8 Fc Fp}



static void Test_BFu8s_B_Vp()
{
  {
    init_simple_test("BFu8s_B_Vp");
    static BFu8s_B_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu8s_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_B_Vp");
    check_field_offset(lv, v2, 1, "BFu8s_B_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu8s_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_B_Vp(Test_BFu8s_B_Vp, "BFu8s_B_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu15i_B  {
  unsigned short v1:8;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 BFu8s_BFu15i_B) C1{ Fs:8 Fi:15 Fc}



static void Test_BFu8s_BFu15i_B()
{
  {
    init_simple_test("BFu8s_BFu15i_B");
    static BFu8s_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_BFu15i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8s_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8s_BFu15i_B");
    check_field_offset(lv, v3, 3, "BFu8s_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu15i_B(Test_BFu8s_BFu15i_B, "BFu8s_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu15ll_B  {
  unsigned short v1:8;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 BFu8s_BFu15ll_B) C1{ Fs:8 FL:15 Fc}



static void Test_BFu8s_BFu15ll_B()
{
  {
    init_simple_test("BFu8s_BFu15ll_B");
    static BFu8s_BFu15ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8s_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu8s_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu8s_BFu15ll_B");
    check_field_offset(lv, v3, 3, "BFu8s_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu15ll_B(Test_BFu8s_BFu15ll_B, "BFu8s_BFu15ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu15s_B  {
  unsigned short v1:8;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 BFu8s_BFu15s_B) C1{ Fs:8 Fs:15 Fc}



static void Test_BFu8s_BFu15s_B()
{
  {
    init_simple_test("BFu8s_BFu15s_B");
    static BFu8s_BFu15s_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu8s_BFu15s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu8s_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu8s_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu8s_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu15s_B(Test_BFu8s_BFu15s_B, "BFu8s_BFu15s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu16i_B  {
  unsigned short v1:8;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 BFu8s_BFu16i_B) C1{ Fs:8 Fi:16 Fc}



static void Test_BFu8s_BFu16i_B()
{
  {
    init_simple_test("BFu8s_BFu16i_B");
    static BFu8s_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_BFu16i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8s_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8s_BFu16i_B");
    check_field_offset(lv, v3, 3, "BFu8s_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu16i_B(Test_BFu8s_BFu16i_B, "BFu8s_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu16ll_B  {
  unsigned short v1:8;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 BFu8s_BFu16ll_B) C1{ Fs:8 FL:16 Fc}



static void Test_BFu8s_BFu16ll_B()
{
  {
    init_simple_test("BFu8s_BFu16ll_B");
    static BFu8s_BFu16ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8s_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu8s_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu8s_BFu16ll_B");
    check_field_offset(lv, v3, 3, "BFu8s_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu16ll_B(Test_BFu8s_BFu16ll_B, "BFu8s_BFu16ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu16s_B  {
  unsigned short v1:8;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 BFu8s_BFu16s_B) C1{ Fs:8 Fs:16 Fc}



static void Test_BFu8s_BFu16s_B()
{
  {
    init_simple_test("BFu8s_BFu16s_B");
    static BFu8s_BFu16s_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu8s_BFu16s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu8s_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu8s_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu8s_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu16s_B(Test_BFu8s_BFu16s_B, "BFu8s_BFu16s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu17i_B  {
  unsigned short v1:8;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 BFu8s_BFu17i_B) C1{ Fs:8 Fi:17 Fc}



static void Test_BFu8s_BFu17i_B()
{
  {
    init_simple_test("BFu8s_BFu17i_B");
    static BFu8s_BFu17i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_BFu17i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8s_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8s_BFu17i_B");
    check_field_offset(lv, v3, 4, "BFu8s_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu17i_B(Test_BFu8s_BFu17i_B, "BFu8s_BFu17i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu17ll_B  {
  unsigned short v1:8;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 BFu8s_BFu17ll_B) C1{ Fs:8 FL:17 Fc}



static void Test_BFu8s_BFu17ll_B()
{
  {
    init_simple_test("BFu8s_BFu17ll_B");
    static BFu8s_BFu17ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu8s_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu8s_BFu17ll_B");
    check_field_offset(lv, v3, 4, "BFu8s_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu17ll_B(Test_BFu8s_BFu17ll_B, "BFu8s_BFu17ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu1c_B  {
  unsigned short v1:8;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 BFu8s_BFu1c_B) C1{ Fs:8 Fc:1 Fc}



static void Test_BFu8s_BFu1c_B()
{
  {
    init_simple_test("BFu8s_BFu1c_B");
    static BFu8s_BFu1c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_BFu1c_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8s_BFu1c_B");
    check_field_offset(lv, v3, 2, "BFu8s_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu1c_B(Test_BFu8s_BFu1c_B, "BFu8s_BFu1c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu1i_B  {
  unsigned short v1:8;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 BFu8s_BFu1i_B) C1{ Fs:8 Fi:1 Fc}



static void Test_BFu8s_BFu1i_B()
{
  {
    init_simple_test("BFu8s_BFu1i_B");
    static BFu8s_BFu1i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_BFu1i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8s_BFu1i_B");
    check_field_offset(lv, v3, 2, "BFu8s_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu1i_B(Test_BFu8s_BFu1i_B, "BFu8s_BFu1i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu1ll_B  {
  unsigned short v1:8;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 BFu8s_BFu1ll_B) C1{ Fs:8 FL:1 Fc}



static void Test_BFu8s_BFu1ll_B()
{
  {
    init_simple_test("BFu8s_BFu1ll_B");
    static BFu8s_BFu1ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8s_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8s_BFu1ll_B");
    check_field_offset(lv, v3, 2, "BFu8s_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu1ll_B(Test_BFu8s_BFu1ll_B, "BFu8s_BFu1ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu1s_B  {
  unsigned short v1:8;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 BFu8s_BFu1s_B) C1{ Fs:8 Fs:1 Fc}



static void Test_BFu8s_BFu1s_B()
{
  {
    init_simple_test("BFu8s_BFu1s_B");
    static BFu8s_BFu1s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_BFu1s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu8s_BFu1s_B");
    check_field_offset(lv, v3, 2, "BFu8s_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu1s_B(Test_BFu8s_BFu1s_B, "BFu8s_BFu1s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu31i_B  {
  unsigned short v1:8;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 BFu8s_BFu31i_B) C1{ Fs:8 Fi:31 Fc}



static void Test_BFu8s_BFu31i_B()
{
  {
    init_simple_test("BFu8s_BFu31i_B");
    static BFu8s_BFu31i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8s_BFu31i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu8s_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu8s_BFu31i_B");
    check_field_offset(lv, v3, 8, "BFu8s_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu31i_B(Test_BFu8s_BFu31i_B, "BFu8s_BFu31i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu31ll_B  {
  unsigned short v1:8;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 BFu8s_BFu31ll_B) C1{ Fs:8 FL:31 Fc}



static void Test_BFu8s_BFu31ll_B()
{
  {
    init_simple_test("BFu8s_BFu31ll_B");
    static BFu8s_BFu31ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu8s_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu8s_BFu31ll_B");
    check_field_offset(lv, v3, 5, "BFu8s_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu31ll_B(Test_BFu8s_BFu31ll_B, "BFu8s_BFu31ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu32i_B  {
  unsigned short v1:8;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 BFu8s_BFu32i_B) C1{ Fs:8 Fi:32 Fc}



static void Test_BFu8s_BFu32i_B()
{
  {
    init_simple_test("BFu8s_BFu32i_B");
    static BFu8s_BFu32i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8s_BFu32i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu8s_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu8s_BFu32i_B");
    check_field_offset(lv, v3, 8, "BFu8s_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu32i_B(Test_BFu8s_BFu32i_B, "BFu8s_BFu32i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu32ll_B  {
  unsigned short v1:8;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 BFu8s_BFu32ll_B) C1{ Fs:8 FL:32 Fc}



static void Test_BFu8s_BFu32ll_B()
{
  {
    init_simple_test("BFu8s_BFu32ll_B");
    static BFu8s_BFu32ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu8s_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu8s_BFu32ll_B");
    check_field_offset(lv, v3, 5, "BFu8s_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu32ll_B(Test_BFu8s_BFu32ll_B, "BFu8s_BFu32ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu33_B  {
  unsigned short v1:8;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 BFu8s_BFu33_B) C1{ Fs:8 FL:33 Fc}



static void Test_BFu8s_BFu33_B()
{
  {
    init_simple_test("BFu8s_BFu33_B");
    static BFu8s_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu8s_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu8s_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu8s_BFu33_B");
    check_field_offset(lv, v3, 6, "BFu8s_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu33_B(Test_BFu8s_BFu33_B, "BFu8s_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu7c_B  {
  unsigned short v1:8;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 BFu8s_BFu7c_B) C1{ Fs:8 Fc:7 Fc}



static void Test_BFu8s_BFu7c_B()
{
  {
    init_simple_test("BFu8s_BFu7c_B");
    static BFu8s_BFu7c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_BFu7c_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8s_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8s_BFu7c_B");
    check_field_offset(lv, v3, 2, "BFu8s_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu7c_B(Test_BFu8s_BFu7c_B, "BFu8s_BFu7c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu7i_B  {
  unsigned short v1:8;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 BFu8s_BFu7i_B) C1{ Fs:8 Fi:7 Fc}



static void Test_BFu8s_BFu7i_B()
{
  {
    init_simple_test("BFu8s_BFu7i_B");
    static BFu8s_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_BFu7i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8s_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8s_BFu7i_B");
    check_field_offset(lv, v3, 2, "BFu8s_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu7i_B(Test_BFu8s_BFu7i_B, "BFu8s_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu7ll_B  {
  unsigned short v1:8;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 BFu8s_BFu7ll_B) C1{ Fs:8 FL:7 Fc}



static void Test_BFu8s_BFu7ll_B()
{
  {
    init_simple_test("BFu8s_BFu7ll_B");
    static BFu8s_BFu7ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8s_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8s_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8s_BFu7ll_B");
    check_field_offset(lv, v3, 2, "BFu8s_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu7ll_B(Test_BFu8s_BFu7ll_B, "BFu8s_BFu7ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu7s_B  {
  unsigned short v1:8;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 BFu8s_BFu7s_B) C1{ Fs:8 Fs:7 Fc}



static void Test_BFu8s_BFu7s_B()
{
  {
    init_simple_test("BFu8s_BFu7s_B");
    static BFu8s_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_BFu7s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu8s_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu8s_BFu7s_B");
    check_field_offset(lv, v3, 2, "BFu8s_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu7s_B(Test_BFu8s_BFu7s_B, "BFu8s_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu8c_B  {
  unsigned short v1:8;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 BFu8s_BFu8c_B) C1{ Fs:8 Fc:8 Fc}



static void Test_BFu8s_BFu8c_B()
{
  {
    init_simple_test("BFu8s_BFu8c_B");
    static BFu8s_BFu8c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_BFu8c_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8s_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8c_B");
    check_field_offset(lv, v3, 2, "BFu8s_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu8c_B(Test_BFu8s_BFu8c_B, "BFu8s_BFu8c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu8i_B  {
  unsigned short v1:8;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 BFu8s_BFu8i_B) C1{ Fs:8 Fi:8 Fc}



static void Test_BFu8s_BFu8i_B()
{
  {
    init_simple_test("BFu8s_BFu8i_B");
    static BFu8s_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_BFu8i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8s_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8i_B");
    check_field_offset(lv, v3, 2, "BFu8s_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu8i_B(Test_BFu8s_BFu8i_B, "BFu8s_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu8ll_B  {
  unsigned short v1:8;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 BFu8s_BFu8ll_B) C1{ Fs:8 FL:8 Fc}



static void Test_BFu8s_BFu8ll_B()
{
  {
    init_simple_test("BFu8s_BFu8ll_B");
    static BFu8s_BFu8ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8s_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8s_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8ll_B");
    check_field_offset(lv, v3, 2, "BFu8s_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu8ll_B(Test_BFu8s_BFu8ll_B, "BFu8s_BFu8ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu8s_B  {
  unsigned short v1:8;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 BFu8s_BFu8s_B) C1{ Fs:8 Fs:8 Fc}



static void Test_BFu8s_BFu8s_B()
{
  {
    init_simple_test("BFu8s_BFu8s_B");
    static BFu8s_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_BFu8s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu8s_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu8s_B");
    check_field_offset(lv, v3, 2, "BFu8s_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu8s_B(Test_BFu8s_BFu8s_B, "BFu8s_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu9i_B  {
  unsigned short v1:8;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 BFu8s_BFu9i_B) C1{ Fs:8 Fi:9 Fc}



static void Test_BFu8s_BFu9i_B()
{
  {
    init_simple_test("BFu8s_BFu9i_B");
    static BFu8s_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_BFu9i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8s_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8s_BFu9i_B");
    check_field_offset(lv, v3, 3, "BFu8s_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu9i_B(Test_BFu8s_BFu9i_B, "BFu8s_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu9ll_B  {
  unsigned short v1:8;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 BFu8s_BFu9ll_B) C1{ Fs:8 FL:9 Fc}



static void Test_BFu8s_BFu9ll_B()
{
  {
    init_simple_test("BFu8s_BFu9ll_B");
    static BFu8s_BFu9ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu8s_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu8s_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu8s_BFu9ll_B");
    check_field_offset(lv, v3, 3, "BFu8s_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu9ll_B(Test_BFu8s_BFu9ll_B, "BFu8s_BFu9ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_BFu9s_B  {
  unsigned short v1:8;
  unsigned short v2:9;
  bool v3;
};
//SIG(1 BFu8s_BFu9s_B) C1{ Fs:8 Fs:9 Fc}



static void Test_BFu8s_BFu9s_B()
{
  {
    init_simple_test("BFu8s_BFu9s_B");
    static BFu8s_BFu9s_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu8s_BFu9s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu8s_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu8s_BFu9s_B");
    check_field_offset(lv, v3, 4, "BFu8s_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_BFu9s_B(Test_BFu8s_BFu9s_B, "BFu8s_BFu9s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_C_B  {
  unsigned short v1:8;
  char v2;
  bool v3;
};
//SIG(1 BFu8s_C_B) C1{ Fs:8 Fc[2]}



static void Test_BFu8s_C_B()
{
  {
    init_simple_test("BFu8s_C_B");
    static BFu8s_C_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_C_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_C_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_C_B");
    check_field_offset(lv, v2, 1, "BFu8s_C_B.v2");
    check_field_offset(lv, v3, 2, "BFu8s_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_C_B(Test_BFu8s_C_B, "BFu8s_C_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_D_B  {
  unsigned short v1:8;
  double v2;
  bool v3;
};
//SIG(1 BFu8s_D_B) C1{ Fs:8 FL Fc}



static void Test_BFu8s_D_B()
{
  {
    init_simple_test("BFu8s_D_B");
    static BFu8s_D_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8s_D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_D_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_D_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8s_D_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8s_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_D_B(Test_BFu8s_D_B, "BFu8s_D_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_F_B  {
  unsigned short v1:8;
  float v2;
  bool v3;
};
//SIG(1 BFu8s_F_B) C1{ Fs:8 Fi Fc}



static void Test_BFu8s_F_B()
{
  {
    init_simple_test("BFu8s_F_B");
    static BFu8s_F_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8s_F_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_F_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_F_B");
    check_field_offset(lv, v2, 4, "BFu8s_F_B.v2");
    check_field_offset(lv, v3, 8, "BFu8s_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_F_B(Test_BFu8s_F_B, "BFu8s_F_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_I_B  {
  unsigned short v1:8;
  int v2;
  bool v3;
};
//SIG(1 BFu8s_I_B) C1{ Fs:8 Fi Fc}



static void Test_BFu8s_I_B()
{
  {
    init_simple_test("BFu8s_I_B");
    static BFu8s_I_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8s_I_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_I_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_I_B");
    check_field_offset(lv, v2, 4, "BFu8s_I_B.v2");
    check_field_offset(lv, v3, 8, "BFu8s_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_I_B(Test_BFu8s_I_B, "BFu8s_I_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_Ip_B  {
  unsigned short v1:8;
  int *v2;
  bool v3;
};
//SIG(1 BFu8s_Ip_B) C1{ Fs:8 Fp Fc}



static void Test_BFu8s_Ip_B()
{
  {
    init_simple_test("BFu8s_Ip_B");
    static BFu8s_Ip_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8s_Ip_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Ip_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8s_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8s_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_Ip_B(Test_BFu8s_Ip_B, "BFu8s_Ip_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_L_B  {
  unsigned short v1:8;
  __tsi64 v2;
  bool v3;
};
//SIG(1 BFu8s_L_B) C1{ Fs:8 FL Fc}



static void Test_BFu8s_L_B()
{
  {
    init_simple_test("BFu8s_L_B");
    static BFu8s_L_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8s_L_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_L_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_L_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8s_L_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8s_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_L_B(Test_BFu8s_L_B, "BFu8s_L_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_S_B  {
  unsigned short v1:8;
  short v2;
  bool v3;
};
//SIG(1 BFu8s_S_B) C1{ Fs:8 Fs Fc}



static void Test_BFu8s_S_B()
{
  {
    init_simple_test("BFu8s_S_B");
    static BFu8s_S_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu8s_S_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_S_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_S_B");
    check_field_offset(lv, v2, 2, "BFu8s_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu8s_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_S_B(Test_BFu8s_S_B, "BFu8s_S_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_Uc_B  {
  unsigned short v1:8;
  unsigned char v2;
  bool v3;
};
//SIG(1 BFu8s_Uc_B) C1{ Fs:8 Fc[2]}



static void Test_BFu8s_Uc_B()
{
  {
    init_simple_test("BFu8s_Uc_B");
    static BFu8s_Uc_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu8s_Uc_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Uc_B");
    check_field_offset(lv, v2, 1, "BFu8s_Uc_B.v2");
    check_field_offset(lv, v3, 2, "BFu8s_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_Uc_B(Test_BFu8s_Uc_B, "BFu8s_Uc_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_Ui_B  {
  unsigned short v1:8;
  unsigned int v2;
  bool v3;
};
//SIG(1 BFu8s_Ui_B) C1{ Fs:8 Fi Fc}



static void Test_BFu8s_Ui_B()
{
  {
    init_simple_test("BFu8s_Ui_B");
    static BFu8s_Ui_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu8s_Ui_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu8s_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Ui_B");
    check_field_offset(lv, v2, 4, "BFu8s_Ui_B.v2");
    check_field_offset(lv, v3, 8, "BFu8s_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_Ui_B(Test_BFu8s_Ui_B, "BFu8s_Ui_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_Ul_B  {
  unsigned short v1:8;
  __tsu64 v2;
  bool v3;
};
//SIG(1 BFu8s_Ul_B) C1{ Fs:8 FL Fc}



static void Test_BFu8s_Ul_B()
{
  {
    init_simple_test("BFu8s_Ul_B");
    static BFu8s_Ul_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu8s_Ul_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Ul_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8s_Ul_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu8s_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_Ul_B(Test_BFu8s_Ul_B, "BFu8s_Ul_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_Us_B  {
  unsigned short v1:8;
  unsigned short v2;
  bool v3;
};
//SIG(1 BFu8s_Us_B) C1{ Fs:8 Fs Fc}



static void Test_BFu8s_Us_B()
{
  {
    init_simple_test("BFu8s_Us_B");
    static BFu8s_Us_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu8s_Us_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu8s_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Us_B");
    check_field_offset(lv, v2, 2, "BFu8s_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu8s_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_Us_B(Test_BFu8s_Us_B, "BFu8s_Us_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu8s_Vp_B  {
  unsigned short v1:8;
  void *v2;
  bool v3;
};
//SIG(1 BFu8s_Vp_B) C1{ Fs:8 Fp Fc}



static void Test_BFu8s_Vp_B()
{
  {
    init_simple_test("BFu8s_Vp_B");
    static BFu8s_Vp_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu8s_Vp_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu8s_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu8s_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu8s_Vp_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu8s_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu8s_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu8s_Vp_B(Test_BFu8s_Vp_B, "BFu8s_Vp_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B  {
  unsigned int v1:9;
  bool v2;
};
//SIG(1 BFu9i_B) C1{ Fi:9 Fc}



static void Test_BFu9i_B()
{
  {
    init_simple_test("BFu9i_B");
    static BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B");
    check_field_offset(lv, v2, 2, "BFu9i_B.v2");
  }
}
static Arrange_To_Call_Me vBFu9i_B(Test_BFu9i_B, "BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_B  {
  unsigned int v1:9;
  bool v2;
  bool v3;
};
//SIG(1 BFu9i_B_B) C1{ Fi:9 Fc[2]}



static void Test_BFu9i_B_B()
{
  {
    init_simple_test("BFu9i_B_B");
    static BFu9i_B_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_B_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_B");
    check_field_offset(lv, v2, 2, "BFu9i_B_B.v2");
    check_field_offset(lv, v3, 3, "BFu9i_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_B_B(Test_BFu9i_B_B, "BFu9i_B_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu15i  {
  unsigned int v1:9;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 BFu9i_B_BFu15i) C1{ Fi:9 Fc Fi:15}



static void Test_BFu9i_B_BFu15i()
{
  {
    init_simple_test("BFu9i_B_BFu15i");
    static BFu9i_B_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu15i");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu9i_B_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu9i_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu15i(Test_BFu9i_B_BFu15i, "BFu9i_B_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu15ll  {
  unsigned int v1:9;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 BFu9i_B_BFu15ll) C1{ Fi:9 Fc FL:15}



static void Test_BFu9i_B_BFu15ll()
{
  {
    init_simple_test("BFu9i_B_BFu15ll");
    static BFu9i_B_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu9i_B_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu9i_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu15ll(Test_BFu9i_B_BFu15ll, "BFu9i_B_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu15s  {
  unsigned int v1:9;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 BFu9i_B_BFu15s) C1{ Fi:9 Fc Fs:15}



static void Test_BFu9i_B_BFu15s()
{
  {
    init_simple_test("BFu9i_B_BFu15s");
    static BFu9i_B_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu15s");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu9i_B_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu9i_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu15s(Test_BFu9i_B_BFu15s, "BFu9i_B_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu16i  {
  unsigned int v1:9;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 BFu9i_B_BFu16i) C1{ Fi:9 Fc Fi:16}



static void Test_BFu9i_B_BFu16i()
{
  {
    init_simple_test("BFu9i_B_BFu16i");
    static BFu9i_B_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu16i");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu9i_B_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu9i_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu16i(Test_BFu9i_B_BFu16i, "BFu9i_B_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu16ll  {
  unsigned int v1:9;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 BFu9i_B_BFu16ll) C1{ Fi:9 Fc FL:16}



static void Test_BFu9i_B_BFu16ll()
{
  {
    init_simple_test("BFu9i_B_BFu16ll");
    static BFu9i_B_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu9i_B_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu9i_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu16ll(Test_BFu9i_B_BFu16ll, "BFu9i_B_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu16s  {
  unsigned int v1:9;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 BFu9i_B_BFu16s) C1{ Fi:9 Fc Fs:16}



static void Test_BFu9i_B_BFu16s()
{
  {
    init_simple_test("BFu9i_B_BFu16s");
    static BFu9i_B_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu16s");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu9i_B_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu9i_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu16s(Test_BFu9i_B_BFu16s, "BFu9i_B_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu17i  {
  unsigned int v1:9;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 BFu9i_B_BFu17i) C1{ Fi:9 Fc Fi:17}



static void Test_BFu9i_B_BFu17i()
{
  {
    init_simple_test("BFu9i_B_BFu17i");
    static BFu9i_B_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu17i");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu9i_B_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu9i_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu17i(Test_BFu9i_B_BFu17i, "BFu9i_B_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu17ll  {
  unsigned int v1:9;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 BFu9i_B_BFu17ll) C1{ Fi:9 Fc FL:17}



static void Test_BFu9i_B_BFu17ll()
{
  {
    init_simple_test("BFu9i_B_BFu17ll");
    static BFu9i_B_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu9i_B_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu9i_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu17ll(Test_BFu9i_B_BFu17ll, "BFu9i_B_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu1c  {
  unsigned int v1:9;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 BFu9i_B_BFu1c) C1{ Fi:9 Fc Fc:1}



static void Test_BFu9i_B_BFu1c()
{
  {
    init_simple_test("BFu9i_B_BFu1c");
    static BFu9i_B_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_B_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu1c");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9i_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu1c(Test_BFu9i_B_BFu1c, "BFu9i_B_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu1i  {
  unsigned int v1:9;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 BFu9i_B_BFu1i) C1{ Fi:9 Fc Fi:1}



static void Test_BFu9i_B_BFu1i()
{
  {
    init_simple_test("BFu9i_B_BFu1i");
    static BFu9i_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_B_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu1i");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9i_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu1i(Test_BFu9i_B_BFu1i, "BFu9i_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu1ll  {
  unsigned int v1:9;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 BFu9i_B_BFu1ll) C1{ Fi:9 Fc FL:1}



static void Test_BFu9i_B_BFu1ll()
{
  {
    init_simple_test("BFu9i_B_BFu1ll");
    static BFu9i_B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9i_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9i_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu1ll(Test_BFu9i_B_BFu1ll, "BFu9i_B_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu1s  {
  unsigned int v1:9;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 BFu9i_B_BFu1s) C1{ Fi:9 Fc Fs:1}



static void Test_BFu9i_B_BFu1s()
{
  {
    init_simple_test("BFu9i_B_BFu1s");
    static BFu9i_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_B_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu1s");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9i_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu1s(Test_BFu9i_B_BFu1s, "BFu9i_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu31i  {
  unsigned int v1:9;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 BFu9i_B_BFu31i) C1{ Fi:9 Fc Fi:31}



static void Test_BFu9i_B_BFu31i()
{
  {
    init_simple_test("BFu9i_B_BFu31i");
    static BFu9i_B_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu31i");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu9i_B_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu9i_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu31i(Test_BFu9i_B_BFu31i, "BFu9i_B_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu31ll  {
  unsigned int v1:9;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 BFu9i_B_BFu31ll) C1{ Fi:9 Fc FL:31}



static void Test_BFu9i_B_BFu31ll()
{
  {
    init_simple_test("BFu9i_B_BFu31ll");
    static BFu9i_B_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu9i_B_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu9i_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu31ll(Test_BFu9i_B_BFu31ll, "BFu9i_B_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu32i  {
  unsigned int v1:9;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 BFu9i_B_BFu32i) C1{ Fi:9 Fc Fi:32}



static void Test_BFu9i_B_BFu32i()
{
  {
    init_simple_test("BFu9i_B_BFu32i");
    static BFu9i_B_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu32i");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu9i_B_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu9i_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu32i(Test_BFu9i_B_BFu32i, "BFu9i_B_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu32ll  {
  unsigned int v1:9;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 BFu9i_B_BFu32ll) C1{ Fi:9 Fc FL:32}



static void Test_BFu9i_B_BFu32ll()
{
  {
    init_simple_test("BFu9i_B_BFu32ll");
    static BFu9i_B_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu9i_B_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu9i_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu32ll(Test_BFu9i_B_BFu32ll, "BFu9i_B_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu33  {
  unsigned int v1:9;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 BFu9i_B_BFu33) C1{ Fi:9 Fc FL:33}



static void Test_BFu9i_B_BFu33()
{
  {
    init_simple_test("BFu9i_B_BFu33");
    static BFu9i_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu33");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu9i_B_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu9i_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu33(Test_BFu9i_B_BFu33, "BFu9i_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu7c  {
  unsigned int v1:9;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 BFu9i_B_BFu7c) C1{ Fi:9 Fc Fc:7}



static void Test_BFu9i_B_BFu7c()
{
  {
    init_simple_test("BFu9i_B_BFu7c");
    static BFu9i_B_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_B_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu7c");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9i_B_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9i_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu7c(Test_BFu9i_B_BFu7c, "BFu9i_B_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu7i  {
  unsigned int v1:9;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 BFu9i_B_BFu7i) C1{ Fi:9 Fc Fi:7}



static void Test_BFu9i_B_BFu7i()
{
  {
    init_simple_test("BFu9i_B_BFu7i");
    static BFu9i_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_B_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu7i");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9i_B_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9i_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu7i(Test_BFu9i_B_BFu7i, "BFu9i_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu7ll  {
  unsigned int v1:9;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 BFu9i_B_BFu7ll) C1{ Fi:9 Fc FL:7}



static void Test_BFu9i_B_BFu7ll()
{
  {
    init_simple_test("BFu9i_B_BFu7ll");
    static BFu9i_B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9i_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9i_B_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9i_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu7ll(Test_BFu9i_B_BFu7ll, "BFu9i_B_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu7s  {
  unsigned int v1:9;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 BFu9i_B_BFu7s) C1{ Fi:9 Fc Fs:7}



static void Test_BFu9i_B_BFu7s()
{
  {
    init_simple_test("BFu9i_B_BFu7s");
    static BFu9i_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_B_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu7s");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9i_B_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9i_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu7s(Test_BFu9i_B_BFu7s, "BFu9i_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu8c  {
  unsigned int v1:9;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 BFu9i_B_BFu8c) C1{ Fi:9 Fc Fc:8}



static void Test_BFu9i_B_BFu8c()
{
  {
    init_simple_test("BFu9i_B_BFu8c");
    static BFu9i_B_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_B_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu8c");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9i_B_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9i_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu8c(Test_BFu9i_B_BFu8c, "BFu9i_B_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu8i  {
  unsigned int v1:9;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 BFu9i_B_BFu8i) C1{ Fi:9 Fc Fi:8}



static void Test_BFu9i_B_BFu8i()
{
  {
    init_simple_test("BFu9i_B_BFu8i");
    static BFu9i_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_B_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu8i");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9i_B_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9i_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu8i(Test_BFu9i_B_BFu8i, "BFu9i_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu8ll  {
  unsigned int v1:9;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 BFu9i_B_BFu8ll) C1{ Fi:9 Fc FL:8}



static void Test_BFu9i_B_BFu8ll()
{
  {
    init_simple_test("BFu9i_B_BFu8ll");
    static BFu9i_B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9i_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9i_B_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9i_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu8ll(Test_BFu9i_B_BFu8ll, "BFu9i_B_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu8s  {
  unsigned int v1:9;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 BFu9i_B_BFu8s) C1{ Fi:9 Fc Fs:8}



static void Test_BFu9i_B_BFu8s()
{
  {
    init_simple_test("BFu9i_B_BFu8s");
    static BFu9i_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_B_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu8s");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9i_B_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9i_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu8s(Test_BFu9i_B_BFu8s, "BFu9i_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu9i  {
  unsigned int v1:9;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 BFu9i_B_BFu9i) C1{ Fi:9 Fc Fi:9}



static void Test_BFu9i_B_BFu9i()
{
  {
    init_simple_test("BFu9i_B_BFu9i");
    static BFu9i_B_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu9i");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu9i_B_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu9i(Test_BFu9i_B_BFu9i, "BFu9i_B_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu9ll  {
  unsigned int v1:9;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 BFu9i_B_BFu9ll) C1{ Fi:9 Fc FL:9}



static void Test_BFu9i_B_BFu9ll()
{
  {
    init_simple_test("BFu9i_B_BFu9ll");
    static BFu9i_B_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu9i_B_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu9ll(Test_BFu9i_B_BFu9ll, "BFu9i_B_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_BFu9s  {
  unsigned int v1:9;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 BFu9i_B_BFu9s) C1{ Fi:9 Fc Fs:9}



static void Test_BFu9i_B_BFu9s()
{
  {
    init_simple_test("BFu9i_B_BFu9s");
    static BFu9i_B_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu9s");
    check_field_offset(lv, v2, 2, "BFu9i_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu9i_B_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu9i_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu9i_B_BFu9s(Test_BFu9i_B_BFu9s, "BFu9i_B_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_C  {
  unsigned int v1:9;
  bool v2;
  char v3;
};
//SIG(1 BFu9i_B_C) C1{ Fi:9 Fc[2]}



static void Test_BFu9i_B_C()
{
  {
    init_simple_test("BFu9i_B_C");
    static BFu9i_B_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_B_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_C");
    check_field_offset(lv, v2, 2, "BFu9i_B_C.v2");
    check_field_offset(lv, v3, 3, "BFu9i_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_B_C(Test_BFu9i_B_C, "BFu9i_B_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_D  {
  unsigned int v1:9;
  bool v2;
  double v3;
};
//SIG(1 BFu9i_B_D) C1{ Fi:9 Fc FL}



static void Test_BFu9i_B_D()
{
  {
    init_simple_test("BFu9i_B_D");
    static BFu9i_B_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu9i_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_D");
    check_field_offset(lv, v2, 2, "BFu9i_B_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9i_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_B_D(Test_BFu9i_B_D, "BFu9i_B_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_F  {
  unsigned int v1:9;
  bool v2;
  float v3;
};
//SIG(1 BFu9i_B_F) C1{ Fi:9 Fc Fi}



static void Test_BFu9i_B_F()
{
  {
    init_simple_test("BFu9i_B_F");
    static BFu9i_B_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_F");
    check_field_offset(lv, v2, 2, "BFu9i_B_F.v2");
    check_field_offset(lv, v3, 4, "BFu9i_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_B_F(Test_BFu9i_B_F, "BFu9i_B_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_I  {
  unsigned int v1:9;
  bool v2;
  int v3;
};
//SIG(1 BFu9i_B_I) C1{ Fi:9 Fc Fi}



static void Test_BFu9i_B_I()
{
  {
    init_simple_test("BFu9i_B_I");
    static BFu9i_B_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_I");
    check_field_offset(lv, v2, 2, "BFu9i_B_I.v2");
    check_field_offset(lv, v3, 4, "BFu9i_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_B_I(Test_BFu9i_B_I, "BFu9i_B_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_Ip  {
  unsigned int v1:9;
  bool v2;
  int *v3;
};
//SIG(1 BFu9i_B_Ip) C1{ Fi:9 Fc Fp}



static void Test_BFu9i_B_Ip()
{
  {
    init_simple_test("BFu9i_B_Ip");
    static BFu9i_B_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu9i_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_Ip");
    check_field_offset(lv, v2, 2, "BFu9i_B_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9i_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_B_Ip(Test_BFu9i_B_Ip, "BFu9i_B_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_L  {
  unsigned int v1:9;
  bool v2;
  __tsi64 v3;
};
//SIG(1 BFu9i_B_L) C1{ Fi:9 Fc FL}



static void Test_BFu9i_B_L()
{
  {
    init_simple_test("BFu9i_B_L");
    static BFu9i_B_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu9i_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_L");
    check_field_offset(lv, v2, 2, "BFu9i_B_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9i_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_B_L(Test_BFu9i_B_L, "BFu9i_B_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_S  {
  unsigned int v1:9;
  bool v2;
  short v3;
};
//SIG(1 BFu9i_B_S) C1{ Fi:9 Fc Fs}



static void Test_BFu9i_B_S()
{
  {
    init_simple_test("BFu9i_B_S");
    static BFu9i_B_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_S");
    check_field_offset(lv, v2, 2, "BFu9i_B_S.v2");
    check_field_offset(lv, v3, 4, "BFu9i_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_B_S(Test_BFu9i_B_S, "BFu9i_B_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_Uc  {
  unsigned int v1:9;
  bool v2;
  unsigned char v3;
};
//SIG(1 BFu9i_B_Uc) C1{ Fi:9 Fc[2]}



static void Test_BFu9i_B_Uc()
{
  {
    init_simple_test("BFu9i_B_Uc");
    static BFu9i_B_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_B_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_Uc");
    check_field_offset(lv, v2, 2, "BFu9i_B_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu9i_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_B_Uc(Test_BFu9i_B_Uc, "BFu9i_B_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_Ui  {
  unsigned int v1:9;
  bool v2;
  unsigned int v3;
};
//SIG(1 BFu9i_B_Ui) C1{ Fi:9 Fc Fi}



static void Test_BFu9i_B_Ui()
{
  {
    init_simple_test("BFu9i_B_Ui");
    static BFu9i_B_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_Ui");
    check_field_offset(lv, v2, 2, "BFu9i_B_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu9i_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_B_Ui(Test_BFu9i_B_Ui, "BFu9i_B_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_Ul  {
  unsigned int v1:9;
  bool v2;
  __tsu64 v3;
};
//SIG(1 BFu9i_B_Ul) C1{ Fi:9 Fc FL}



static void Test_BFu9i_B_Ul()
{
  {
    init_simple_test("BFu9i_B_Ul");
    static BFu9i_B_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu9i_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_Ul");
    check_field_offset(lv, v2, 2, "BFu9i_B_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9i_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_B_Ul(Test_BFu9i_B_Ul, "BFu9i_B_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_Us  {
  unsigned int v1:9;
  bool v2;
  unsigned short v3;
};
//SIG(1 BFu9i_B_Us) C1{ Fi:9 Fc Fs}



static void Test_BFu9i_B_Us()
{
  {
    init_simple_test("BFu9i_B_Us");
    static BFu9i_B_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_B_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_Us");
    check_field_offset(lv, v2, 2, "BFu9i_B_Us.v2");
    check_field_offset(lv, v3, 4, "BFu9i_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_B_Us(Test_BFu9i_B_Us, "BFu9i_B_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_B_Vp  {
  unsigned int v1:9;
  bool v2;
  void *v3;
};
//SIG(1 BFu9i_B_Vp) C1{ Fi:9 Fc Fp}



static void Test_BFu9i_B_Vp()
{
  {
    init_simple_test("BFu9i_B_Vp");
    static BFu9i_B_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu9i_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_B_Vp");
    check_field_offset(lv, v2, 2, "BFu9i_B_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9i_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_B_Vp(Test_BFu9i_B_Vp, "BFu9i_B_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu15i_B  {
  unsigned int v1:9;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 BFu9i_BFu15i_B) C1{ Fi:9 Fi:15 Fc}



static void Test_BFu9i_BFu15i_B()
{
  {
    init_simple_test("BFu9i_BFu15i_B");
    static BFu9i_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu15i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu9i_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu9i_BFu15i_B");
    check_field_offset(lv, v3, 3, "BFu9i_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu15i_B(Test_BFu9i_BFu15i_B, "BFu9i_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu15ll_B  {
  unsigned int v1:9;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 BFu9i_BFu15ll_B) C1{ Fi:9 FL:15 Fc}



static void Test_BFu9i_BFu15ll_B()
{
  {
    init_simple_test("BFu9i_BFu15ll_B");
    static BFu9i_BFu15ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9i_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu9i_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu9i_BFu15ll_B");
    check_field_offset(lv, v3, 3, "BFu9i_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu15ll_B(Test_BFu9i_BFu15ll_B, "BFu9i_BFu15ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu15s_B  {
  unsigned int v1:9;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 BFu9i_BFu15s_B) C1{ Fi:9 Fs:15 Fc}



static void Test_BFu9i_BFu15s_B()
{
  {
    init_simple_test("BFu9i_BFu15s_B");
    static BFu9i_BFu15s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_BFu15s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu9i_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu9i_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu9i_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu15s_B(Test_BFu9i_BFu15s_B, "BFu9i_BFu15s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu16i_B  {
  unsigned int v1:9;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 BFu9i_BFu16i_B) C1{ Fi:9 Fi:16 Fc}



static void Test_BFu9i_BFu16i_B()
{
  {
    init_simple_test("BFu9i_BFu16i_B");
    static BFu9i_BFu16i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_BFu16i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu9i_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu9i_BFu16i_B");
    check_field_offset(lv, v3, 4, "BFu9i_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu16i_B(Test_BFu9i_BFu16i_B, "BFu9i_BFu16i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu16ll_B  {
  unsigned int v1:9;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 BFu9i_BFu16ll_B) C1{ Fi:9 FL:16 Fc}



static void Test_BFu9i_BFu16ll_B()
{
  {
    init_simple_test("BFu9i_BFu16ll_B");
    static BFu9i_BFu16ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu9i_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu9i_BFu16ll_B");
    check_field_offset(lv, v3, 4, "BFu9i_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu16ll_B(Test_BFu9i_BFu16ll_B, "BFu9i_BFu16ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu16s_B  {
  unsigned int v1:9;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 BFu9i_BFu16s_B) C1{ Fi:9 Fs:16 Fc}



static void Test_BFu9i_BFu16s_B()
{
  {
    init_simple_test("BFu9i_BFu16s_B");
    static BFu9i_BFu16s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_BFu16s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu9i_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu9i_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu9i_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu16s_B(Test_BFu9i_BFu16s_B, "BFu9i_BFu16s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu17i_B  {
  unsigned int v1:9;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 BFu9i_BFu17i_B) C1{ Fi:9 Fi:17 Fc}



static void Test_BFu9i_BFu17i_B()
{
  {
    init_simple_test("BFu9i_BFu17i_B");
    static BFu9i_BFu17i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_BFu17i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu9i_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu9i_BFu17i_B");
    check_field_offset(lv, v3, 4, "BFu9i_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu17i_B(Test_BFu9i_BFu17i_B, "BFu9i_BFu17i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu17ll_B  {
  unsigned int v1:9;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 BFu9i_BFu17ll_B) C1{ Fi:9 FL:17 Fc}



static void Test_BFu9i_BFu17ll_B()
{
  {
    init_simple_test("BFu9i_BFu17ll_B");
    static BFu9i_BFu17ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu9i_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu9i_BFu17ll_B");
    check_field_offset(lv, v3, 4, "BFu9i_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu17ll_B(Test_BFu9i_BFu17ll_B, "BFu9i_BFu17ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu1c_B  {
  unsigned int v1:9;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 BFu9i_BFu1c_B) C1{ Fi:9 Fc:1 Fc}



static void Test_BFu9i_BFu1c_B()
{
  {
    init_simple_test("BFu9i_BFu1c_B");
    static BFu9i_BFu1c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu1c_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9i_BFu1c_B");
    check_field_offset(lv, v3, 2, "BFu9i_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu1c_B(Test_BFu9i_BFu1c_B, "BFu9i_BFu1c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu1i_B  {
  unsigned int v1:9;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 BFu9i_BFu1i_B) C1{ Fi:9 Fi:1 Fc}



static void Test_BFu9i_BFu1i_B()
{
  {
    init_simple_test("BFu9i_BFu1i_B");
    static BFu9i_BFu1i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu1i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9i_BFu1i_B");
    check_field_offset(lv, v3, 2, "BFu9i_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu1i_B(Test_BFu9i_BFu1i_B, "BFu9i_BFu1i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu1ll_B  {
  unsigned int v1:9;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 BFu9i_BFu1ll_B) C1{ Fi:9 FL:1 Fc}



static void Test_BFu9i_BFu1ll_B()
{
  {
    init_simple_test("BFu9i_BFu1ll_B");
    static BFu9i_BFu1ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9i_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9i_BFu1ll_B");
    check_field_offset(lv, v3, 2, "BFu9i_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu1ll_B(Test_BFu9i_BFu1ll_B, "BFu9i_BFu1ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu1s_B  {
  unsigned int v1:9;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 BFu9i_BFu1s_B) C1{ Fi:9 Fs:1 Fc}



static void Test_BFu9i_BFu1s_B()
{
  {
    init_simple_test("BFu9i_BFu1s_B");
    static BFu9i_BFu1s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu1s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9i_BFu1s_B");
    check_field_offset(lv, v3, 2, "BFu9i_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu1s_B(Test_BFu9i_BFu1s_B, "BFu9i_BFu1s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu31i_B  {
  unsigned int v1:9;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 BFu9i_BFu31i_B) C1{ Fi:9 Fi:31 Fc}



static void Test_BFu9i_BFu31i_B()
{
  {
    init_simple_test("BFu9i_BFu31i_B");
    static BFu9i_BFu31i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu9i_BFu31i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu9i_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu9i_BFu31i_B");
    check_field_offset(lv, v3, 8, "BFu9i_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu31i_B(Test_BFu9i_BFu31i_B, "BFu9i_BFu31i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu31ll_B  {
  unsigned int v1:9;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 BFu9i_BFu31ll_B) C1{ Fi:9 FL:31 Fc}



static void Test_BFu9i_BFu31ll_B()
{
  {
    init_simple_test("BFu9i_BFu31ll_B");
    static BFu9i_BFu31ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu9i_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu9i_BFu31ll_B");
    check_field_offset(lv, v3, 5, "BFu9i_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu31ll_B(Test_BFu9i_BFu31ll_B, "BFu9i_BFu31ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu32i_B  {
  unsigned int v1:9;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 BFu9i_BFu32i_B) C1{ Fi:9 Fi:32 Fc}



static void Test_BFu9i_BFu32i_B()
{
  {
    init_simple_test("BFu9i_BFu32i_B");
    static BFu9i_BFu32i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu9i_BFu32i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu9i_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu9i_BFu32i_B");
    check_field_offset(lv, v3, 8, "BFu9i_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu32i_B(Test_BFu9i_BFu32i_B, "BFu9i_BFu32i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu32ll_B  {
  unsigned int v1:9;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 BFu9i_BFu32ll_B) C1{ Fi:9 FL:32 Fc}



static void Test_BFu9i_BFu32ll_B()
{
  {
    init_simple_test("BFu9i_BFu32ll_B");
    static BFu9i_BFu32ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu9i_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu9i_BFu32ll_B");
    check_field_offset(lv, v3, 6, "BFu9i_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu32ll_B(Test_BFu9i_BFu32ll_B, "BFu9i_BFu32ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu33_B  {
  unsigned int v1:9;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 BFu9i_BFu33_B) C1{ Fi:9 FL:33 Fc}



static void Test_BFu9i_BFu33_B()
{
  {
    init_simple_test("BFu9i_BFu33_B");
    static BFu9i_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu33_B");
    set_bf_and_test(lv, v2, 1, 1, 33, 1, "BFu9i_BFu33_B");
    set_bf_and_test(lv, v2, 1, 1, 33, hide_ull(1LL<<32), "BFu9i_BFu33_B");
    check_field_offset(lv, v3, 6, "BFu9i_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu33_B(Test_BFu9i_BFu33_B, "BFu9i_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu7c_B  {
  unsigned int v1:9;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 BFu9i_BFu7c_B) C1{ Fi:9 Fc:7 Fc}



static void Test_BFu9i_BFu7c_B()
{
  {
    init_simple_test("BFu9i_BFu7c_B");
    static BFu9i_BFu7c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu7c_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9i_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9i_BFu7c_B");
    check_field_offset(lv, v3, 2, "BFu9i_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu7c_B(Test_BFu9i_BFu7c_B, "BFu9i_BFu7c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu7i_B  {
  unsigned int v1:9;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 BFu9i_BFu7i_B) C1{ Fi:9 Fi:7 Fc}



static void Test_BFu9i_BFu7i_B()
{
  {
    init_simple_test("BFu9i_BFu7i_B");
    static BFu9i_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu7i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9i_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9i_BFu7i_B");
    check_field_offset(lv, v3, 2, "BFu9i_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu7i_B(Test_BFu9i_BFu7i_B, "BFu9i_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu7ll_B  {
  unsigned int v1:9;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 BFu9i_BFu7ll_B) C1{ Fi:9 FL:7 Fc}



static void Test_BFu9i_BFu7ll_B()
{
  {
    init_simple_test("BFu9i_BFu7ll_B");
    static BFu9i_BFu7ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9i_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9i_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9i_BFu7ll_B");
    check_field_offset(lv, v3, 2, "BFu9i_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu7ll_B(Test_BFu9i_BFu7ll_B, "BFu9i_BFu7ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu7s_B  {
  unsigned int v1:9;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 BFu9i_BFu7s_B) C1{ Fi:9 Fs:7 Fc}



static void Test_BFu9i_BFu7s_B()
{
  {
    init_simple_test("BFu9i_BFu7s_B");
    static BFu9i_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu7s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9i_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9i_BFu7s_B");
    check_field_offset(lv, v3, 2, "BFu9i_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu7s_B(Test_BFu9i_BFu7s_B, "BFu9i_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu8c_B  {
  unsigned int v1:9;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 BFu9i_BFu8c_B) C1{ Fi:9 Fc:8 Fc}



static void Test_BFu9i_BFu8c_B()
{
  {
    init_simple_test("BFu9i_BFu8c_B");
    static BFu9i_BFu8c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu8c_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu8c_B");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu9i_BFu8c_B");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu9i_BFu8c_B");
    check_field_offset(lv, v3, 3, "BFu9i_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu8c_B(Test_BFu9i_BFu8c_B, "BFu9i_BFu8c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu8i_B  {
  unsigned int v1:9;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 BFu9i_BFu8i_B) C1{ Fi:9 Fi:8 Fc}



static void Test_BFu9i_BFu8i_B()
{
  {
    init_simple_test("BFu9i_BFu8i_B");
    static BFu9i_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu8i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu9i_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu9i_BFu8i_B");
    check_field_offset(lv, v3, 3, "BFu9i_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu8i_B(Test_BFu9i_BFu8i_B, "BFu9i_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu8ll_B  {
  unsigned int v1:9;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 BFu9i_BFu8ll_B) C1{ Fi:9 FL:8 Fc}



static void Test_BFu9i_BFu8ll_B()
{
  {
    init_simple_test("BFu9i_BFu8ll_B");
    static BFu9i_BFu8ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9i_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu9i_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu9i_BFu8ll_B");
    check_field_offset(lv, v3, 3, "BFu9i_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu8ll_B(Test_BFu9i_BFu8ll_B, "BFu9i_BFu8ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu8s_B  {
  unsigned int v1:9;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 BFu9i_BFu8s_B) C1{ Fi:9 Fs:8 Fc}



static void Test_BFu9i_BFu8s_B()
{
  {
    init_simple_test("BFu9i_BFu8s_B");
    static BFu9i_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu8s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu8s_B");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu9i_BFu8s_B");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu9i_BFu8s_B");
    check_field_offset(lv, v3, 3, "BFu9i_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu8s_B(Test_BFu9i_BFu8s_B, "BFu9i_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu9i_B  {
  unsigned int v1:9;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 BFu9i_BFu9i_B) C1{ Fi:9 Fi:9 Fc}



static void Test_BFu9i_BFu9i_B()
{
  {
    init_simple_test("BFu9i_BFu9i_B");
    static BFu9i_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_BFu9i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu9i_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu9i_BFu9i_B");
    check_field_offset(lv, v3, 3, "BFu9i_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu9i_B(Test_BFu9i_BFu9i_B, "BFu9i_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu9ll_B  {
  unsigned int v1:9;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 BFu9i_BFu9ll_B) C1{ Fi:9 FL:9 Fc}



static void Test_BFu9i_BFu9ll_B()
{
  {
    init_simple_test("BFu9i_BFu9ll_B");
    static BFu9i_BFu9ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9i_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu9i_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu9i_BFu9ll_B");
    check_field_offset(lv, v3, 3, "BFu9i_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu9ll_B(Test_BFu9i_BFu9ll_B, "BFu9i_BFu9ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_BFu9s_B  {
  unsigned int v1:9;
  unsigned short v2:9;
  bool v3;
};
//SIG(1 BFu9i_BFu9s_B) C1{ Fi:9 Fs:9 Fc}



static void Test_BFu9i_BFu9s_B()
{
  {
    init_simple_test("BFu9i_BFu9s_B");
    static BFu9i_BFu9s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_BFu9s_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu9i_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu9i_BFu9s_B");
    check_field_offset(lv, v3, 4, "BFu9i_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_BFu9s_B(Test_BFu9i_BFu9s_B, "BFu9i_BFu9s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_C_B  {
  unsigned int v1:9;
  char v2;
  bool v3;
};
//SIG(1 BFu9i_C_B) C1{ Fi:9 Fc[2]}



static void Test_BFu9i_C_B()
{
  {
    init_simple_test("BFu9i_C_B");
    static BFu9i_C_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_C_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_C_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_C_B");
    check_field_offset(lv, v2, 2, "BFu9i_C_B.v2");
    check_field_offset(lv, v3, 3, "BFu9i_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_C_B(Test_BFu9i_C_B, "BFu9i_C_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_D_B  {
  unsigned int v1:9;
  double v2;
  bool v3;
};
//SIG(1 BFu9i_D_B) C1{ Fi:9 FL Fc}



static void Test_BFu9i_D_B()
{
  {
    init_simple_test("BFu9i_D_B");
    static BFu9i_D_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu9i_D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_D_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_D_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9i_D_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu9i_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_D_B(Test_BFu9i_D_B, "BFu9i_D_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_F_B  {
  unsigned int v1:9;
  float v2;
  bool v3;
};
//SIG(1 BFu9i_F_B) C1{ Fi:9 Fi Fc}



static void Test_BFu9i_F_B()
{
  {
    init_simple_test("BFu9i_F_B");
    static BFu9i_F_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu9i_F_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_F_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_F_B");
    check_field_offset(lv, v2, 4, "BFu9i_F_B.v2");
    check_field_offset(lv, v3, 8, "BFu9i_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_F_B(Test_BFu9i_F_B, "BFu9i_F_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_I_B  {
  unsigned int v1:9;
  int v2;
  bool v3;
};
//SIG(1 BFu9i_I_B) C1{ Fi:9 Fi Fc}



static void Test_BFu9i_I_B()
{
  {
    init_simple_test("BFu9i_I_B");
    static BFu9i_I_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu9i_I_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_I_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_I_B");
    check_field_offset(lv, v2, 4, "BFu9i_I_B.v2");
    check_field_offset(lv, v3, 8, "BFu9i_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_I_B(Test_BFu9i_I_B, "BFu9i_I_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_Ip_B  {
  unsigned int v1:9;
  int *v2;
  bool v3;
};
//SIG(1 BFu9i_Ip_B) C1{ Fi:9 Fp Fc}



static void Test_BFu9i_Ip_B()
{
  {
    init_simple_test("BFu9i_Ip_B");
    static BFu9i_Ip_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu9i_Ip_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Ip_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9i_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu9i_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_Ip_B(Test_BFu9i_Ip_B, "BFu9i_Ip_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_L_B  {
  unsigned int v1:9;
  __tsi64 v2;
  bool v3;
};
//SIG(1 BFu9i_L_B) C1{ Fi:9 FL Fc}



static void Test_BFu9i_L_B()
{
  {
    init_simple_test("BFu9i_L_B");
    static BFu9i_L_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu9i_L_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_L_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_L_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9i_L_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu9i_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_L_B(Test_BFu9i_L_B, "BFu9i_L_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_S_B  {
  unsigned int v1:9;
  short v2;
  bool v3;
};
//SIG(1 BFu9i_S_B) C1{ Fi:9 Fs Fc}



static void Test_BFu9i_S_B()
{
  {
    init_simple_test("BFu9i_S_B");
    static BFu9i_S_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_S_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_S_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_S_B");
    check_field_offset(lv, v2, 2, "BFu9i_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu9i_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_S_B(Test_BFu9i_S_B, "BFu9i_S_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_Uc_B  {
  unsigned int v1:9;
  unsigned char v2;
  bool v3;
};
//SIG(1 BFu9i_Uc_B) C1{ Fi:9 Fc[2]}



static void Test_BFu9i_Uc_B()
{
  {
    init_simple_test("BFu9i_Uc_B");
    static BFu9i_Uc_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9i_Uc_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Uc_B");
    check_field_offset(lv, v2, 2, "BFu9i_Uc_B.v2");
    check_field_offset(lv, v3, 3, "BFu9i_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_Uc_B(Test_BFu9i_Uc_B, "BFu9i_Uc_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_Ui_B  {
  unsigned int v1:9;
  unsigned int v2;
  bool v3;
};
//SIG(1 BFu9i_Ui_B) C1{ Fi:9 Fi Fc}



static void Test_BFu9i_Ui_B()
{
  {
    init_simple_test("BFu9i_Ui_B");
    static BFu9i_Ui_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu9i_Ui_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Ui_B");
    check_field_offset(lv, v2, 4, "BFu9i_Ui_B.v2");
    check_field_offset(lv, v3, 8, "BFu9i_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_Ui_B(Test_BFu9i_Ui_B, "BFu9i_Ui_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_Ul_B  {
  unsigned int v1:9;
  __tsu64 v2;
  bool v3;
};
//SIG(1 BFu9i_Ul_B) C1{ Fi:9 FL Fc}



static void Test_BFu9i_Ul_B()
{
  {
    init_simple_test("BFu9i_Ul_B");
    static BFu9i_Ul_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu9i_Ul_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Ul_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9i_Ul_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu9i_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_Ul_B(Test_BFu9i_Ul_B, "BFu9i_Ul_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_Us_B  {
  unsigned int v1:9;
  unsigned short v2;
  bool v3;
};
//SIG(1 BFu9i_Us_B) C1{ Fi:9 Fs Fc}



static void Test_BFu9i_Us_B()
{
  {
    init_simple_test("BFu9i_Us_B");
    static BFu9i_Us_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9i_Us_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9i_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Us_B");
    check_field_offset(lv, v2, 2, "BFu9i_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu9i_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_Us_B(Test_BFu9i_Us_B, "BFu9i_Us_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9i_Vp_B  {
  unsigned int v1:9;
  void *v2;
  bool v3;
};
//SIG(1 BFu9i_Vp_B) C1{ Fi:9 Fp Fc}



static void Test_BFu9i_Vp_B()
{
  {
    init_simple_test("BFu9i_Vp_B");
    static BFu9i_Vp_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu9i_Vp_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9i_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9i_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9i_Vp_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9i_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu9i_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9i_Vp_B(Test_BFu9i_Vp_B, "BFu9i_Vp_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B  {
  __tsu64 v1:9;
  bool v2;
};
//SIG(1 BFu9ll_B) C1{ FL:9 Fc}



static void Test_BFu9ll_B()
{
  {
    init_simple_test("BFu9ll_B");
    static BFu9ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B");
    check_field_offset(lv, v2, 2, "BFu9ll_B.v2");
  }
}
static Arrange_To_Call_Me vBFu9ll_B(Test_BFu9ll_B, "BFu9ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_B  {
  __tsu64 v1:9;
  bool v2;
  bool v3;
};
//SIG(1 BFu9ll_B_B) C1{ FL:9 Fc[2]}



static void Test_BFu9ll_B_B()
{
  {
    init_simple_test("BFu9ll_B_B");
    static BFu9ll_B_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_B");
    check_field_offset(lv, v2, 2, "BFu9ll_B_B.v2");
    check_field_offset(lv, v3, 3, "BFu9ll_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_B(Test_BFu9ll_B_B, "BFu9ll_B_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu15i  {
  __tsu64 v1:9;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 BFu9ll_B_BFu15i) C1{ FL:9 Fc Fi:15}



static void Test_BFu9ll_B_BFu15i()
{
  {
    init_simple_test("BFu9ll_B_BFu15i");
    static BFu9ll_B_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu15i");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu9ll_B_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu9ll_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu15i(Test_BFu9ll_B_BFu15i, "BFu9ll_B_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu15ll  {
  __tsu64 v1:9;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 BFu9ll_B_BFu15ll) C1{ FL:9 Fc FL:15}



static void Test_BFu9ll_B_BFu15ll()
{
  {
    init_simple_test("BFu9ll_B_BFu15ll");
    static BFu9ll_B_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu9ll_B_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu9ll_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu15ll(Test_BFu9ll_B_BFu15ll, "BFu9ll_B_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu15s  {
  __tsu64 v1:9;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 BFu9ll_B_BFu15s) C1{ FL:9 Fc Fs:15}



static void Test_BFu9ll_B_BFu15s()
{
  {
    init_simple_test("BFu9ll_B_BFu15s");
    static BFu9ll_B_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu15s");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu9ll_B_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu9ll_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu15s(Test_BFu9ll_B_BFu15s, "BFu9ll_B_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu16i  {
  __tsu64 v1:9;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 BFu9ll_B_BFu16i) C1{ FL:9 Fc Fi:16}



static void Test_BFu9ll_B_BFu16i()
{
  {
    init_simple_test("BFu9ll_B_BFu16i");
    static BFu9ll_B_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu16i");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu9ll_B_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu9ll_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu16i(Test_BFu9ll_B_BFu16i, "BFu9ll_B_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu16ll  {
  __tsu64 v1:9;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 BFu9ll_B_BFu16ll) C1{ FL:9 Fc FL:16}



static void Test_BFu9ll_B_BFu16ll()
{
  {
    init_simple_test("BFu9ll_B_BFu16ll");
    static BFu9ll_B_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu9ll_B_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu9ll_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu16ll(Test_BFu9ll_B_BFu16ll, "BFu9ll_B_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu16s  {
  __tsu64 v1:9;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 BFu9ll_B_BFu16s) C1{ FL:9 Fc Fs:16}



static void Test_BFu9ll_B_BFu16s()
{
  {
    init_simple_test("BFu9ll_B_BFu16s");
    static BFu9ll_B_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu16s");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu9ll_B_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu9ll_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu16s(Test_BFu9ll_B_BFu16s, "BFu9ll_B_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu17i  {
  __tsu64 v1:9;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 BFu9ll_B_BFu17i) C1{ FL:9 Fc Fi:17}



static void Test_BFu9ll_B_BFu17i()
{
  {
    init_simple_test("BFu9ll_B_BFu17i");
    static BFu9ll_B_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu17i");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu9ll_B_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu9ll_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu17i(Test_BFu9ll_B_BFu17i, "BFu9ll_B_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu17ll  {
  __tsu64 v1:9;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 BFu9ll_B_BFu17ll) C1{ FL:9 Fc FL:17}



static void Test_BFu9ll_B_BFu17ll()
{
  {
    init_simple_test("BFu9ll_B_BFu17ll");
    static BFu9ll_B_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu9ll_B_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu9ll_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu17ll(Test_BFu9ll_B_BFu17ll, "BFu9ll_B_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu1c  {
  __tsu64 v1:9;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 BFu9ll_B_BFu1c) C1{ FL:9 Fc Fc:1}



static void Test_BFu9ll_B_BFu1c()
{
  {
    init_simple_test("BFu9ll_B_BFu1c");
    static BFu9ll_B_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu1c");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9ll_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu1c(Test_BFu9ll_B_BFu1c, "BFu9ll_B_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu1i  {
  __tsu64 v1:9;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 BFu9ll_B_BFu1i) C1{ FL:9 Fc Fi:1}



static void Test_BFu9ll_B_BFu1i()
{
  {
    init_simple_test("BFu9ll_B_BFu1i");
    static BFu9ll_B_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu1i");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9ll_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu1i(Test_BFu9ll_B_BFu1i, "BFu9ll_B_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu1ll  {
  __tsu64 v1:9;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 BFu9ll_B_BFu1ll) C1{ FL:9 Fc FL:1}



static void Test_BFu9ll_B_BFu1ll()
{
  {
    init_simple_test("BFu9ll_B_BFu1ll");
    static BFu9ll_B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9ll_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu1ll(Test_BFu9ll_B_BFu1ll, "BFu9ll_B_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu1s  {
  __tsu64 v1:9;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 BFu9ll_B_BFu1s) C1{ FL:9 Fc Fs:1}



static void Test_BFu9ll_B_BFu1s()
{
  {
    init_simple_test("BFu9ll_B_BFu1s");
    static BFu9ll_B_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu1s");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9ll_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu1s(Test_BFu9ll_B_BFu1s, "BFu9ll_B_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu31i  {
  __tsu64 v1:9;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 BFu9ll_B_BFu31i) C1{ FL:9 Fc Fi:31}



static void Test_BFu9ll_B_BFu31i()
{
  {
    init_simple_test("BFu9ll_B_BFu31i");
    static BFu9ll_B_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu31i");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu9ll_B_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu9ll_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu31i(Test_BFu9ll_B_BFu31i, "BFu9ll_B_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu31ll  {
  __tsu64 v1:9;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 BFu9ll_B_BFu31ll) C1{ FL:9 Fc FL:31}



static void Test_BFu9ll_B_BFu31ll()
{
  {
    init_simple_test("BFu9ll_B_BFu31ll");
    static BFu9ll_B_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu9ll_B_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu9ll_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu31ll(Test_BFu9ll_B_BFu31ll, "BFu9ll_B_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu32i  {
  __tsu64 v1:9;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 BFu9ll_B_BFu32i) C1{ FL:9 Fc Fi:32}



static void Test_BFu9ll_B_BFu32i()
{
  {
    init_simple_test("BFu9ll_B_BFu32i");
    static BFu9ll_B_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu32i");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu9ll_B_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu9ll_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu32i(Test_BFu9ll_B_BFu32i, "BFu9ll_B_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu32ll  {
  __tsu64 v1:9;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 BFu9ll_B_BFu32ll) C1{ FL:9 Fc FL:32}



static void Test_BFu9ll_B_BFu32ll()
{
  {
    init_simple_test("BFu9ll_B_BFu32ll");
    static BFu9ll_B_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu9ll_B_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu9ll_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu32ll(Test_BFu9ll_B_BFu32ll, "BFu9ll_B_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu33  {
  __tsu64 v1:9;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 BFu9ll_B_BFu33) C1{ FL:9 Fc FL:33}



static void Test_BFu9ll_B_BFu33()
{
  {
    init_simple_test("BFu9ll_B_BFu33");
    static BFu9ll_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu33");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu9ll_B_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu9ll_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu33(Test_BFu9ll_B_BFu33, "BFu9ll_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu7c  {
  __tsu64 v1:9;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 BFu9ll_B_BFu7c) C1{ FL:9 Fc Fc:7}



static void Test_BFu9ll_B_BFu7c()
{
  {
    init_simple_test("BFu9ll_B_BFu7c");
    static BFu9ll_B_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu7c");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9ll_B_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9ll_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu7c(Test_BFu9ll_B_BFu7c, "BFu9ll_B_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu7i  {
  __tsu64 v1:9;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 BFu9ll_B_BFu7i) C1{ FL:9 Fc Fi:7}



static void Test_BFu9ll_B_BFu7i()
{
  {
    init_simple_test("BFu9ll_B_BFu7i");
    static BFu9ll_B_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu7i");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9ll_B_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9ll_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu7i(Test_BFu9ll_B_BFu7i, "BFu9ll_B_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu7ll  {
  __tsu64 v1:9;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 BFu9ll_B_BFu7ll) C1{ FL:9 Fc FL:7}



static void Test_BFu9ll_B_BFu7ll()
{
  {
    init_simple_test("BFu9ll_B_BFu7ll");
    static BFu9ll_B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9ll_B_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9ll_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu7ll(Test_BFu9ll_B_BFu7ll, "BFu9ll_B_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu7s  {
  __tsu64 v1:9;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 BFu9ll_B_BFu7s) C1{ FL:9 Fc Fs:7}



static void Test_BFu9ll_B_BFu7s()
{
  {
    init_simple_test("BFu9ll_B_BFu7s");
    static BFu9ll_B_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu7s");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9ll_B_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9ll_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu7s(Test_BFu9ll_B_BFu7s, "BFu9ll_B_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu8c  {
  __tsu64 v1:9;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 BFu9ll_B_BFu8c) C1{ FL:9 Fc Fc:8}



static void Test_BFu9ll_B_BFu8c()
{
  {
    init_simple_test("BFu9ll_B_BFu8c");
    static BFu9ll_B_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu8c");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9ll_B_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9ll_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu8c(Test_BFu9ll_B_BFu8c, "BFu9ll_B_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu8i  {
  __tsu64 v1:9;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 BFu9ll_B_BFu8i) C1{ FL:9 Fc Fi:8}



static void Test_BFu9ll_B_BFu8i()
{
  {
    init_simple_test("BFu9ll_B_BFu8i");
    static BFu9ll_B_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu8i");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9ll_B_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9ll_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu8i(Test_BFu9ll_B_BFu8i, "BFu9ll_B_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu8ll  {
  __tsu64 v1:9;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 BFu9ll_B_BFu8ll) C1{ FL:9 Fc FL:8}



static void Test_BFu9ll_B_BFu8ll()
{
  {
    init_simple_test("BFu9ll_B_BFu8ll");
    static BFu9ll_B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9ll_B_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9ll_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu8ll(Test_BFu9ll_B_BFu8ll, "BFu9ll_B_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu8s  {
  __tsu64 v1:9;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 BFu9ll_B_BFu8s) C1{ FL:9 Fc Fs:8}



static void Test_BFu9ll_B_BFu8s()
{
  {
    init_simple_test("BFu9ll_B_BFu8s");
    static BFu9ll_B_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu8s");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9ll_B_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9ll_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu8s(Test_BFu9ll_B_BFu8s, "BFu9ll_B_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu9i  {
  __tsu64 v1:9;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 BFu9ll_B_BFu9i) C1{ FL:9 Fc Fi:9}



static void Test_BFu9ll_B_BFu9i()
{
  {
    init_simple_test("BFu9ll_B_BFu9i");
    static BFu9ll_B_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu9i");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu9ll_B_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu9i(Test_BFu9ll_B_BFu9i, "BFu9ll_B_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu9ll  {
  __tsu64 v1:9;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 BFu9ll_B_BFu9ll) C1{ FL:9 Fc FL:9}



static void Test_BFu9ll_B_BFu9ll()
{
  {
    init_simple_test("BFu9ll_B_BFu9ll");
    static BFu9ll_B_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu9ll_B_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu9ll(Test_BFu9ll_B_BFu9ll, "BFu9ll_B_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_BFu9s  {
  __tsu64 v1:9;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 BFu9ll_B_BFu9s) C1{ FL:9 Fc Fs:9}



static void Test_BFu9ll_B_BFu9s()
{
  {
    init_simple_test("BFu9ll_B_BFu9s");
    static BFu9ll_B_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu9s");
    check_field_offset(lv, v2, 2, "BFu9ll_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu9ll_B_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_BFu9s(Test_BFu9ll_B_BFu9s, "BFu9ll_B_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_C  {
  __tsu64 v1:9;
  bool v2;
  char v3;
};
//SIG(1 BFu9ll_B_C) C1{ FL:9 Fc[2]}



static void Test_BFu9ll_B_C()
{
  {
    init_simple_test("BFu9ll_B_C");
    static BFu9ll_B_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_C");
    check_field_offset(lv, v2, 2, "BFu9ll_B_C.v2");
    check_field_offset(lv, v3, 3, "BFu9ll_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_C(Test_BFu9ll_B_C, "BFu9ll_B_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_D  {
  __tsu64 v1:9;
  bool v2;
  double v3;
};
//SIG(1 BFu9ll_B_D) C1{ FL:9 Fc FL}



static void Test_BFu9ll_B_D()
{
  {
    init_simple_test("BFu9ll_B_D");
    static BFu9ll_B_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu9ll_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_D");
    check_field_offset(lv, v2, 2, "BFu9ll_B_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9ll_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_D(Test_BFu9ll_B_D, "BFu9ll_B_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_F  {
  __tsu64 v1:9;
  bool v2;
  float v3;
};
//SIG(1 BFu9ll_B_F) C1{ FL:9 Fc Fi}



static void Test_BFu9ll_B_F()
{
  {
    init_simple_test("BFu9ll_B_F");
    static BFu9ll_B_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_F");
    check_field_offset(lv, v2, 2, "BFu9ll_B_F.v2");
    check_field_offset(lv, v3, 4, "BFu9ll_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_F(Test_BFu9ll_B_F, "BFu9ll_B_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_I  {
  __tsu64 v1:9;
  bool v2;
  int v3;
};
//SIG(1 BFu9ll_B_I) C1{ FL:9 Fc Fi}



static void Test_BFu9ll_B_I()
{
  {
    init_simple_test("BFu9ll_B_I");
    static BFu9ll_B_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_I");
    check_field_offset(lv, v2, 2, "BFu9ll_B_I.v2");
    check_field_offset(lv, v3, 4, "BFu9ll_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_I(Test_BFu9ll_B_I, "BFu9ll_B_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_Ip  {
  __tsu64 v1:9;
  bool v2;
  int *v3;
};
//SIG(1 BFu9ll_B_Ip) C1{ FL:9 Fc Fp}



static void Test_BFu9ll_B_Ip()
{
  {
    init_simple_test("BFu9ll_B_Ip");
    static BFu9ll_B_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu9ll_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_Ip");
    check_field_offset(lv, v2, 2, "BFu9ll_B_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9ll_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_Ip(Test_BFu9ll_B_Ip, "BFu9ll_B_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_L  {
  __tsu64 v1:9;
  bool v2;
  __tsi64 v3;
};
//SIG(1 BFu9ll_B_L) C1{ FL:9 Fc FL}



static void Test_BFu9ll_B_L()
{
  {
    init_simple_test("BFu9ll_B_L");
    static BFu9ll_B_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu9ll_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_L");
    check_field_offset(lv, v2, 2, "BFu9ll_B_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9ll_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_L(Test_BFu9ll_B_L, "BFu9ll_B_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_S  {
  __tsu64 v1:9;
  bool v2;
  short v3;
};
//SIG(1 BFu9ll_B_S) C1{ FL:9 Fc Fs}



static void Test_BFu9ll_B_S()
{
  {
    init_simple_test("BFu9ll_B_S");
    static BFu9ll_B_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_S");
    check_field_offset(lv, v2, 2, "BFu9ll_B_S.v2");
    check_field_offset(lv, v3, 4, "BFu9ll_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_S(Test_BFu9ll_B_S, "BFu9ll_B_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_Uc  {
  __tsu64 v1:9;
  bool v2;
  unsigned char v3;
};
//SIG(1 BFu9ll_B_Uc) C1{ FL:9 Fc[2]}



static void Test_BFu9ll_B_Uc()
{
  {
    init_simple_test("BFu9ll_B_Uc");
    static BFu9ll_B_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_B_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_Uc");
    check_field_offset(lv, v2, 2, "BFu9ll_B_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu9ll_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_Uc(Test_BFu9ll_B_Uc, "BFu9ll_B_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_Ui  {
  __tsu64 v1:9;
  bool v2;
  unsigned int v3;
};
//SIG(1 BFu9ll_B_Ui) C1{ FL:9 Fc Fi}



static void Test_BFu9ll_B_Ui()
{
  {
    init_simple_test("BFu9ll_B_Ui");
    static BFu9ll_B_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_Ui");
    check_field_offset(lv, v2, 2, "BFu9ll_B_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu9ll_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_Ui(Test_BFu9ll_B_Ui, "BFu9ll_B_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_Ul  {
  __tsu64 v1:9;
  bool v2;
  __tsu64 v3;
};
//SIG(1 BFu9ll_B_Ul) C1{ FL:9 Fc FL}



static void Test_BFu9ll_B_Ul()
{
  {
    init_simple_test("BFu9ll_B_Ul");
    static BFu9ll_B_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu9ll_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_Ul");
    check_field_offset(lv, v2, 2, "BFu9ll_B_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9ll_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_Ul(Test_BFu9ll_B_Ul, "BFu9ll_B_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_Us  {
  __tsu64 v1:9;
  bool v2;
  unsigned short v3;
};
//SIG(1 BFu9ll_B_Us) C1{ FL:9 Fc Fs}



static void Test_BFu9ll_B_Us()
{
  {
    init_simple_test("BFu9ll_B_Us");
    static BFu9ll_B_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_B_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_Us");
    check_field_offset(lv, v2, 2, "BFu9ll_B_Us.v2");
    check_field_offset(lv, v3, 4, "BFu9ll_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_Us(Test_BFu9ll_B_Us, "BFu9ll_B_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_B_Vp  {
  __tsu64 v1:9;
  bool v2;
  void *v3;
};
//SIG(1 BFu9ll_B_Vp) C1{ FL:9 Fc Fp}



static void Test_BFu9ll_B_Vp()
{
  {
    init_simple_test("BFu9ll_B_Vp");
    static BFu9ll_B_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu9ll_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_B_Vp");
    check_field_offset(lv, v2, 2, "BFu9ll_B_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9ll_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_B_Vp(Test_BFu9ll_B_Vp, "BFu9ll_B_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu15i_B  {
  __tsu64 v1:9;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 BFu9ll_BFu15i_B) C1{ FL:9 Fi:15 Fc}



static void Test_BFu9ll_BFu15i_B()
{
  {
    init_simple_test("BFu9ll_BFu15i_B");
    static BFu9ll_BFu15i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu15i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu9ll_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu9ll_BFu15i_B");
    check_field_offset(lv, v3, 3, "BFu9ll_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu15i_B(Test_BFu9ll_BFu15i_B, "BFu9ll_BFu15i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu15ll_B  {
  __tsu64 v1:9;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 BFu9ll_BFu15ll_B) C1{ FL:9 FL:15 Fc}



static void Test_BFu9ll_BFu15ll_B()
{
  {
    init_simple_test("BFu9ll_BFu15ll_B");
    static BFu9ll_BFu15ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu9ll_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu9ll_BFu15ll_B");
    check_field_offset(lv, v3, 3, "BFu9ll_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu15ll_B(Test_BFu9ll_BFu15ll_B, "BFu9ll_BFu15ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu15s_B  {
  __tsu64 v1:9;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 BFu9ll_BFu15s_B) C1{ FL:9 Fs:15 Fc}



static void Test_BFu9ll_BFu15s_B()
{
  {
    init_simple_test("BFu9ll_BFu15s_B");
    static BFu9ll_BFu15s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_BFu15s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu9ll_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu9ll_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu9ll_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu15s_B(Test_BFu9ll_BFu15s_B, "BFu9ll_BFu15s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu16i_B  {
  __tsu64 v1:9;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 BFu9ll_BFu16i_B) C1{ FL:9 Fi:16 Fc}



static void Test_BFu9ll_BFu16i_B()
{
  {
    init_simple_test("BFu9ll_BFu16i_B");
    static BFu9ll_BFu16i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_BFu16i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu9ll_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu9ll_BFu16i_B");
    check_field_offset(lv, v3, 4, "BFu9ll_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu16i_B(Test_BFu9ll_BFu16i_B, "BFu9ll_BFu16i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu16ll_B  {
  __tsu64 v1:9;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 BFu9ll_BFu16ll_B) C1{ FL:9 FL:16 Fc}



static void Test_BFu9ll_BFu16ll_B()
{
  {
    init_simple_test("BFu9ll_BFu16ll_B");
    static BFu9ll_BFu16ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu9ll_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu9ll_BFu16ll_B");
    check_field_offset(lv, v3, 4, "BFu9ll_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu16ll_B(Test_BFu9ll_BFu16ll_B, "BFu9ll_BFu16ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu16s_B  {
  __tsu64 v1:9;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 BFu9ll_BFu16s_B) C1{ FL:9 Fs:16 Fc}



static void Test_BFu9ll_BFu16s_B()
{
  {
    init_simple_test("BFu9ll_BFu16s_B");
    static BFu9ll_BFu16s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_BFu16s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu9ll_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu9ll_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu9ll_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu16s_B(Test_BFu9ll_BFu16s_B, "BFu9ll_BFu16s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu17i_B  {
  __tsu64 v1:9;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 BFu9ll_BFu17i_B) C1{ FL:9 Fi:17 Fc}



static void Test_BFu9ll_BFu17i_B()
{
  {
    init_simple_test("BFu9ll_BFu17i_B");
    static BFu9ll_BFu17i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_BFu17i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu9ll_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu9ll_BFu17i_B");
    check_field_offset(lv, v3, 4, "BFu9ll_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu17i_B(Test_BFu9ll_BFu17i_B, "BFu9ll_BFu17i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu17ll_B  {
  __tsu64 v1:9;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 BFu9ll_BFu17ll_B) C1{ FL:9 FL:17 Fc}



static void Test_BFu9ll_BFu17ll_B()
{
  {
    init_simple_test("BFu9ll_BFu17ll_B");
    static BFu9ll_BFu17ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu9ll_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu9ll_BFu17ll_B");
    check_field_offset(lv, v3, 4, "BFu9ll_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu17ll_B(Test_BFu9ll_BFu17ll_B, "BFu9ll_BFu17ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu1c_B  {
  __tsu64 v1:9;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 BFu9ll_BFu1c_B) C1{ FL:9 Fc:1 Fc}



static void Test_BFu9ll_BFu1c_B()
{
  {
    init_simple_test("BFu9ll_BFu1c_B");
    static BFu9ll_BFu1c_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu1c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9ll_BFu1c_B");
    check_field_offset(lv, v3, 2, "BFu9ll_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu1c_B(Test_BFu9ll_BFu1c_B, "BFu9ll_BFu1c_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu1i_B  {
  __tsu64 v1:9;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 BFu9ll_BFu1i_B) C1{ FL:9 Fi:1 Fc}



static void Test_BFu9ll_BFu1i_B()
{
  {
    init_simple_test("BFu9ll_BFu1i_B");
    static BFu9ll_BFu1i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu1i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9ll_BFu1i_B");
    check_field_offset(lv, v3, 2, "BFu9ll_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu1i_B(Test_BFu9ll_BFu1i_B, "BFu9ll_BFu1i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu1ll_B  {
  __tsu64 v1:9;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 BFu9ll_BFu1ll_B) C1{ FL:9 FL:1 Fc}



static void Test_BFu9ll_BFu1ll_B()
{
  {
    init_simple_test("BFu9ll_BFu1ll_B");
    static BFu9ll_BFu1ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9ll_BFu1ll_B");
    check_field_offset(lv, v3, 2, "BFu9ll_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu1ll_B(Test_BFu9ll_BFu1ll_B, "BFu9ll_BFu1ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu1s_B  {
  __tsu64 v1:9;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 BFu9ll_BFu1s_B) C1{ FL:9 Fs:1 Fc}



static void Test_BFu9ll_BFu1s_B()
{
  {
    init_simple_test("BFu9ll_BFu1s_B");
    static BFu9ll_BFu1s_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu1s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9ll_BFu1s_B");
    check_field_offset(lv, v3, 2, "BFu9ll_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu1s_B(Test_BFu9ll_BFu1s_B, "BFu9ll_BFu1s_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu31i_B  {
  __tsu64 v1:9;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 BFu9ll_BFu31i_B) C1{ FL:9 Fi:31 Fc}



static void Test_BFu9ll_BFu31i_B()
{
  {
    init_simple_test("BFu9ll_BFu31i_B");
    static BFu9ll_BFu31i_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu9ll_BFu31i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu9ll_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu9ll_BFu31i_B");
    check_field_offset(lv, v3, 8, "BFu9ll_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu31i_B(Test_BFu9ll_BFu31i_B, "BFu9ll_BFu31i_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu31ll_B  {
  __tsu64 v1:9;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 BFu9ll_BFu31ll_B) C1{ FL:9 FL:31 Fc}



static void Test_BFu9ll_BFu31ll_B()
{
  {
    init_simple_test("BFu9ll_BFu31ll_B");
    static BFu9ll_BFu31ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu9ll_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu9ll_BFu31ll_B");
    check_field_offset(lv, v3, 5, "BFu9ll_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu31ll_B(Test_BFu9ll_BFu31ll_B, "BFu9ll_BFu31ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu32i_B  {
  __tsu64 v1:9;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 BFu9ll_BFu32i_B) C1{ FL:9 Fi:32 Fc}



static void Test_BFu9ll_BFu32i_B()
{
  {
    init_simple_test("BFu9ll_BFu32i_B");
    static BFu9ll_BFu32i_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu9ll_BFu32i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu9ll_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu9ll_BFu32i_B");
    check_field_offset(lv, v3, 8, "BFu9ll_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu32i_B(Test_BFu9ll_BFu32i_B, "BFu9ll_BFu32i_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu32ll_B  {
  __tsu64 v1:9;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 BFu9ll_BFu32ll_B) C1{ FL:9 FL:32 Fc}



static void Test_BFu9ll_BFu32ll_B()
{
  {
    init_simple_test("BFu9ll_BFu32ll_B");
    static BFu9ll_BFu32ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu9ll_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu9ll_BFu32ll_B");
    check_field_offset(lv, v3, 6, "BFu9ll_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu32ll_B(Test_BFu9ll_BFu32ll_B, "BFu9ll_BFu32ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu33_B  {
  __tsu64 v1:9;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 BFu9ll_BFu33_B) C1{ FL:9 FL:33 Fc}



static void Test_BFu9ll_BFu33_B()
{
  {
    init_simple_test("BFu9ll_BFu33_B");
    static BFu9ll_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu33_B");
    set_bf_and_test(lv, v2, 1, 1, 33, 1, "BFu9ll_BFu33_B");
    set_bf_and_test(lv, v2, 1, 1, 33, hide_ull(1LL<<32), "BFu9ll_BFu33_B");
    check_field_offset(lv, v3, 6, "BFu9ll_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu33_B(Test_BFu9ll_BFu33_B, "BFu9ll_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu7c_B  {
  __tsu64 v1:9;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 BFu9ll_BFu7c_B) C1{ FL:9 Fc:7 Fc}



static void Test_BFu9ll_BFu7c_B()
{
  {
    init_simple_test("BFu9ll_BFu7c_B");
    static BFu9ll_BFu7c_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu7c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9ll_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9ll_BFu7c_B");
    check_field_offset(lv, v3, 2, "BFu9ll_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu7c_B(Test_BFu9ll_BFu7c_B, "BFu9ll_BFu7c_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu7i_B  {
  __tsu64 v1:9;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 BFu9ll_BFu7i_B) C1{ FL:9 Fi:7 Fc}



static void Test_BFu9ll_BFu7i_B()
{
  {
    init_simple_test("BFu9ll_BFu7i_B");
    static BFu9ll_BFu7i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu7i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9ll_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9ll_BFu7i_B");
    check_field_offset(lv, v3, 2, "BFu9ll_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu7i_B(Test_BFu9ll_BFu7i_B, "BFu9ll_BFu7i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu7ll_B  {
  __tsu64 v1:9;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 BFu9ll_BFu7ll_B) C1{ FL:9 FL:7 Fc}



static void Test_BFu9ll_BFu7ll_B()
{
  {
    init_simple_test("BFu9ll_BFu7ll_B");
    static BFu9ll_BFu7ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9ll_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9ll_BFu7ll_B");
    check_field_offset(lv, v3, 2, "BFu9ll_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu7ll_B(Test_BFu9ll_BFu7ll_B, "BFu9ll_BFu7ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu7s_B  {
  __tsu64 v1:9;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 BFu9ll_BFu7s_B) C1{ FL:9 Fs:7 Fc}



static void Test_BFu9ll_BFu7s_B()
{
  {
    init_simple_test("BFu9ll_BFu7s_B");
    static BFu9ll_BFu7s_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu7s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9ll_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9ll_BFu7s_B");
    check_field_offset(lv, v3, 2, "BFu9ll_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu7s_B(Test_BFu9ll_BFu7s_B, "BFu9ll_BFu7s_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu8c_B  {
  __tsu64 v1:9;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 BFu9ll_BFu8c_B) C1{ FL:9 Fc:8 Fc}



static void Test_BFu9ll_BFu8c_B()
{
  {
    init_simple_test("BFu9ll_BFu8c_B");
    static BFu9ll_BFu8c_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu8c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu8c_B");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu9ll_BFu8c_B");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu9ll_BFu8c_B");
    check_field_offset(lv, v3, 3, "BFu9ll_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu8c_B(Test_BFu9ll_BFu8c_B, "BFu9ll_BFu8c_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu8i_B  {
  __tsu64 v1:9;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 BFu9ll_BFu8i_B) C1{ FL:9 Fi:8 Fc}



static void Test_BFu9ll_BFu8i_B()
{
  {
    init_simple_test("BFu9ll_BFu8i_B");
    static BFu9ll_BFu8i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu8i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu9ll_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu9ll_BFu8i_B");
    check_field_offset(lv, v3, 3, "BFu9ll_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu8i_B(Test_BFu9ll_BFu8i_B, "BFu9ll_BFu8i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu8ll_B  {
  __tsu64 v1:9;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 BFu9ll_BFu8ll_B) C1{ FL:9 FL:8 Fc}



static void Test_BFu9ll_BFu8ll_B()
{
  {
    init_simple_test("BFu9ll_BFu8ll_B");
    static BFu9ll_BFu8ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu9ll_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu9ll_BFu8ll_B");
    check_field_offset(lv, v3, 3, "BFu9ll_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu8ll_B(Test_BFu9ll_BFu8ll_B, "BFu9ll_BFu8ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu8s_B  {
  __tsu64 v1:9;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 BFu9ll_BFu8s_B) C1{ FL:9 Fs:8 Fc}



static void Test_BFu9ll_BFu8s_B()
{
  {
    init_simple_test("BFu9ll_BFu8s_B");
    static BFu9ll_BFu8s_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu8s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu8s_B");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu9ll_BFu8s_B");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu9ll_BFu8s_B");
    check_field_offset(lv, v3, 3, "BFu9ll_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu8s_B(Test_BFu9ll_BFu8s_B, "BFu9ll_BFu8s_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu9i_B  {
  __tsu64 v1:9;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 BFu9ll_BFu9i_B) C1{ FL:9 Fi:9 Fc}



static void Test_BFu9ll_BFu9i_B()
{
  {
    init_simple_test("BFu9ll_BFu9i_B");
    static BFu9ll_BFu9i_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu9i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu9ll_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu9ll_BFu9i_B");
    check_field_offset(lv, v3, 3, "BFu9ll_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu9i_B(Test_BFu9ll_BFu9i_B, "BFu9ll_BFu9i_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu9ll_B  {
  __tsu64 v1:9;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 BFu9ll_BFu9ll_B) C1{ FL:9 FL:9 Fc}



static void Test_BFu9ll_BFu9ll_B()
{
  {
    init_simple_test("BFu9ll_BFu9ll_B");
    static BFu9ll_BFu9ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu9ll_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu9ll_BFu9ll_B");
    check_field_offset(lv, v3, 3, "BFu9ll_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu9ll_B(Test_BFu9ll_BFu9ll_B, "BFu9ll_BFu9ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_BFu9s_B  {
  __tsu64 v1:9;
  unsigned short v2:9;
  bool v3;
};
//SIG(1 BFu9ll_BFu9s_B) C1{ FL:9 Fs:9 Fc}



static void Test_BFu9ll_BFu9s_B()
{
  {
    init_simple_test("BFu9ll_BFu9s_B");
    static BFu9ll_BFu9s_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_BFu9s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu9ll_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu9ll_BFu9s_B");
    check_field_offset(lv, v3, 4, "BFu9ll_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_BFu9s_B(Test_BFu9ll_BFu9s_B, "BFu9ll_BFu9s_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_C_B  {
  __tsu64 v1:9;
  char v2;
  bool v3;
};
//SIG(1 BFu9ll_C_B) C1{ FL:9 Fc[2]}



static void Test_BFu9ll_C_B()
{
  {
    init_simple_test("BFu9ll_C_B");
    static BFu9ll_C_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_C_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_C_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_C_B");
    check_field_offset(lv, v2, 2, "BFu9ll_C_B.v2");
    check_field_offset(lv, v3, 3, "BFu9ll_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_C_B(Test_BFu9ll_C_B, "BFu9ll_C_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_D_B  {
  __tsu64 v1:9;
  double v2;
  bool v3;
};
//SIG(1 BFu9ll_D_B) C1{ FL:9 FL Fc}



static void Test_BFu9ll_D_B()
{
  {
    init_simple_test("BFu9ll_D_B");
    static BFu9ll_D_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu9ll_D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_D_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_D_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9ll_D_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu9ll_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_D_B(Test_BFu9ll_D_B, "BFu9ll_D_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_F_B  {
  __tsu64 v1:9;
  float v2;
  bool v3;
};
//SIG(1 BFu9ll_F_B) C1{ FL:9 Fi Fc}



static void Test_BFu9ll_F_B()
{
  {
    init_simple_test("BFu9ll_F_B");
    static BFu9ll_F_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu9ll_F_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_F_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_F_B");
    check_field_offset(lv, v2, 4, "BFu9ll_F_B.v2");
    check_field_offset(lv, v3, 8, "BFu9ll_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_F_B(Test_BFu9ll_F_B, "BFu9ll_F_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_I_B  {
  __tsu64 v1:9;
  int v2;
  bool v3;
};
//SIG(1 BFu9ll_I_B) C1{ FL:9 Fi Fc}



static void Test_BFu9ll_I_B()
{
  {
    init_simple_test("BFu9ll_I_B");
    static BFu9ll_I_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu9ll_I_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_I_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_I_B");
    check_field_offset(lv, v2, 4, "BFu9ll_I_B.v2");
    check_field_offset(lv, v3, 8, "BFu9ll_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_I_B(Test_BFu9ll_I_B, "BFu9ll_I_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_Ip_B  {
  __tsu64 v1:9;
  int *v2;
  bool v3;
};
//SIG(1 BFu9ll_Ip_B) C1{ FL:9 Fp Fc}



static void Test_BFu9ll_Ip_B()
{
  {
    init_simple_test("BFu9ll_Ip_B");
    static BFu9ll_Ip_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu9ll_Ip_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_Ip_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9ll_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu9ll_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_Ip_B(Test_BFu9ll_Ip_B, "BFu9ll_Ip_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_L_B  {
  __tsu64 v1:9;
  __tsi64 v2;
  bool v3;
};
//SIG(1 BFu9ll_L_B) C1{ FL:9 FL Fc}



static void Test_BFu9ll_L_B()
{
  {
    init_simple_test("BFu9ll_L_B");
    static BFu9ll_L_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu9ll_L_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_L_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_L_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9ll_L_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu9ll_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_L_B(Test_BFu9ll_L_B, "BFu9ll_L_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_S_B  {
  __tsu64 v1:9;
  short v2;
  bool v3;
};
//SIG(1 BFu9ll_S_B) C1{ FL:9 Fs Fc}



static void Test_BFu9ll_S_B()
{
  {
    init_simple_test("BFu9ll_S_B");
    static BFu9ll_S_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_S_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_S_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_S_B");
    check_field_offset(lv, v2, 2, "BFu9ll_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu9ll_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_S_B(Test_BFu9ll_S_B, "BFu9ll_S_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_Uc_B  {
  __tsu64 v1:9;
  unsigned char v2;
  bool v3;
};
//SIG(1 BFu9ll_Uc_B) C1{ FL:9 Fc[2]}



static void Test_BFu9ll_Uc_B()
{
  {
    init_simple_test("BFu9ll_Uc_B");
    static BFu9ll_Uc_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9ll_Uc_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_Uc_B");
    check_field_offset(lv, v2, 2, "BFu9ll_Uc_B.v2");
    check_field_offset(lv, v3, 3, "BFu9ll_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_Uc_B(Test_BFu9ll_Uc_B, "BFu9ll_Uc_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_Ui_B  {
  __tsu64 v1:9;
  unsigned int v2;
  bool v3;
};
//SIG(1 BFu9ll_Ui_B) C1{ FL:9 Fi Fc}



static void Test_BFu9ll_Ui_B()
{
  {
    init_simple_test("BFu9ll_Ui_B");
    static BFu9ll_Ui_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu9ll_Ui_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_Ui_B");
    check_field_offset(lv, v2, 4, "BFu9ll_Ui_B.v2");
    check_field_offset(lv, v3, 8, "BFu9ll_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_Ui_B(Test_BFu9ll_Ui_B, "BFu9ll_Ui_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_Ul_B  {
  __tsu64 v1:9;
  __tsu64 v2;
  bool v3;
};
//SIG(1 BFu9ll_Ul_B) C1{ FL:9 FL Fc}



static void Test_BFu9ll_Ul_B()
{
  {
    init_simple_test("BFu9ll_Ul_B");
    static BFu9ll_Ul_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu9ll_Ul_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_Ul_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9ll_Ul_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu9ll_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_Ul_B(Test_BFu9ll_Ul_B, "BFu9ll_Ul_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_Us_B  {
  __tsu64 v1:9;
  unsigned short v2;
  bool v3;
};
//SIG(1 BFu9ll_Us_B) C1{ FL:9 Fs Fc}



static void Test_BFu9ll_Us_B()
{
  {
    init_simple_test("BFu9ll_Us_B");
    static BFu9ll_Us_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9ll_Us_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_Us_B");
    check_field_offset(lv, v2, 2, "BFu9ll_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu9ll_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_Us_B(Test_BFu9ll_Us_B, "BFu9ll_Us_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9ll_Vp_B  {
  __tsu64 v1:9;
  void *v2;
  bool v3;
};
//SIG(1 BFu9ll_Vp_B) C1{ FL:9 Fp Fc}



static void Test_BFu9ll_Vp_B()
{
  {
    init_simple_test("BFu9ll_Vp_B");
    static BFu9ll_Vp_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu9ll_Vp_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9ll_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9ll_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9ll_Vp_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9ll_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu9ll_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9ll_Vp_B(Test_BFu9ll_Vp_B, "BFu9ll_Vp_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B  {
  unsigned short v1:9;
  bool v2;
};
//SIG(1 BFu9s_B) C1{ Fs:9 Fc}



static void Test_BFu9s_B()
{
  {
    init_simple_test("BFu9s_B");
    static BFu9s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B");
    check_field_offset(lv, v2, 2, "BFu9s_B.v2");
  }
}
static Arrange_To_Call_Me vBFu9s_B(Test_BFu9s_B, "BFu9s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_B  {
  unsigned short v1:9;
  bool v2;
  bool v3;
};
//SIG(1 BFu9s_B_B) C1{ Fs:9 Fc[2]}



static void Test_BFu9s_B_B()
{
  {
    init_simple_test("BFu9s_B_B");
    static BFu9s_B_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_B_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_B");
    check_field_offset(lv, v2, 2, "BFu9s_B_B.v2");
    check_field_offset(lv, v3, 3, "BFu9s_B_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_B_B(Test_BFu9s_B_B, "BFu9s_B_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu15i  {
  unsigned short v1:9;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 BFu9s_B_BFu15i) C1{ Fs:9 Fc Fi:15}



static void Test_BFu9s_B_BFu15i()
{
  {
    init_simple_test("BFu9s_B_BFu15i");
    static BFu9s_B_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_B_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu15i");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu9s_B_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu9s_B_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu15i(Test_BFu9s_B_BFu15i, "BFu9s_B_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu15ll  {
  unsigned short v1:9;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 BFu9s_B_BFu15ll) C1{ Fs:9 Fc FL:15}



static void Test_BFu9s_B_BFu15ll()
{
  {
    init_simple_test("BFu9s_B_BFu15ll");
    static BFu9s_B_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu9s_B_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu9s_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu15ll(Test_BFu9s_B_BFu15ll, "BFu9s_B_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu15s  {
  unsigned short v1:9;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 BFu9s_B_BFu15s) C1{ Fs:9 Fc Fs:15}



static void Test_BFu9s_B_BFu15s()
{
  {
    init_simple_test("BFu9s_B_BFu15s");
    static BFu9s_B_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_B_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu15s");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu9s_B_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu9s_B_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu15s(Test_BFu9s_B_BFu15s, "BFu9s_B_BFu15s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu16i  {
  unsigned short v1:9;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 BFu9s_B_BFu16i) C1{ Fs:9 Fc Fi:16}



static void Test_BFu9s_B_BFu16i()
{
  {
    init_simple_test("BFu9s_B_BFu16i");
    static BFu9s_B_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_B_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu16i");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu9s_B_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu9s_B_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu16i(Test_BFu9s_B_BFu16i, "BFu9s_B_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu16ll  {
  unsigned short v1:9;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 BFu9s_B_BFu16ll) C1{ Fs:9 Fc FL:16}



static void Test_BFu9s_B_BFu16ll()
{
  {
    init_simple_test("BFu9s_B_BFu16ll");
    static BFu9s_B_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu9s_B_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu9s_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu16ll(Test_BFu9s_B_BFu16ll, "BFu9s_B_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu16s  {
  unsigned short v1:9;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 BFu9s_B_BFu16s) C1{ Fs:9 Fc Fs:16}



static void Test_BFu9s_B_BFu16s()
{
  {
    init_simple_test("BFu9s_B_BFu16s");
    static BFu9s_B_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_B_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu16s");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu9s_B_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu9s_B_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu16s(Test_BFu9s_B_BFu16s, "BFu9s_B_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu17i  {
  unsigned short v1:9;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 BFu9s_B_BFu17i) C1{ Fs:9 Fc Fi:17}



static void Test_BFu9s_B_BFu17i()
{
  {
    init_simple_test("BFu9s_B_BFu17i");
    static BFu9s_B_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_B_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu17i");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu9s_B_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu9s_B_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu17i(Test_BFu9s_B_BFu17i, "BFu9s_B_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu17ll  {
  unsigned short v1:9;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 BFu9s_B_BFu17ll) C1{ Fs:9 Fc FL:17}



static void Test_BFu9s_B_BFu17ll()
{
  {
    init_simple_test("BFu9s_B_BFu17ll");
    static BFu9s_B_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu9s_B_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu9s_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu17ll(Test_BFu9s_B_BFu17ll, "BFu9s_B_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu1c  {
  unsigned short v1:9;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 BFu9s_B_BFu1c) C1{ Fs:9 Fc Fc:1}



static void Test_BFu9s_B_BFu1c()
{
  {
    init_simple_test("BFu9s_B_BFu1c");
    static BFu9s_B_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_B_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu1c");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9s_B_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu1c(Test_BFu9s_B_BFu1c, "BFu9s_B_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu1i  {
  unsigned short v1:9;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 BFu9s_B_BFu1i) C1{ Fs:9 Fc Fi:1}



static void Test_BFu9s_B_BFu1i()
{
  {
    init_simple_test("BFu9s_B_BFu1i");
    static BFu9s_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_B_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_B_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu1i");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9s_B_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu1i(Test_BFu9s_B_BFu1i, "BFu9s_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu1ll  {
  unsigned short v1:9;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 BFu9s_B_BFu1ll) C1{ Fs:9 Fc FL:1}



static void Test_BFu9s_B_BFu1ll()
{
  {
    init_simple_test("BFu9s_B_BFu1ll");
    static BFu9s_B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9s_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9s_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu1ll(Test_BFu9s_B_BFu1ll, "BFu9s_B_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu1s  {
  unsigned short v1:9;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 BFu9s_B_BFu1s) C1{ Fs:9 Fc Fs:1}



static void Test_BFu9s_B_BFu1s()
{
  {
    init_simple_test("BFu9s_B_BFu1s");
    static BFu9s_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_B_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu1s");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu9s_B_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu1s(Test_BFu9s_B_BFu1s, "BFu9s_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu31i  {
  unsigned short v1:9;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 BFu9s_B_BFu31i) C1{ Fs:9 Fc Fi:31}



static void Test_BFu9s_B_BFu31i()
{
  {
    init_simple_test("BFu9s_B_BFu31i");
    static BFu9s_B_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_B_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu31i");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu9s_B_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu9s_B_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu31i(Test_BFu9s_B_BFu31i, "BFu9s_B_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu31ll  {
  unsigned short v1:9;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 BFu9s_B_BFu31ll) C1{ Fs:9 Fc FL:31}



static void Test_BFu9s_B_BFu31ll()
{
  {
    init_simple_test("BFu9s_B_BFu31ll");
    static BFu9s_B_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu9s_B_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu9s_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu31ll(Test_BFu9s_B_BFu31ll, "BFu9s_B_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu32i  {
  unsigned short v1:9;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 BFu9s_B_BFu32i) C1{ Fs:9 Fc Fi:32}



static void Test_BFu9s_B_BFu32i()
{
  {
    init_simple_test("BFu9s_B_BFu32i");
    static BFu9s_B_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_B_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu32i");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu9s_B_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu9s_B_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu32i(Test_BFu9s_B_BFu32i, "BFu9s_B_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu32ll  {
  unsigned short v1:9;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 BFu9s_B_BFu32ll) C1{ Fs:9 Fc FL:32}



static void Test_BFu9s_B_BFu32ll()
{
  {
    init_simple_test("BFu9s_B_BFu32ll");
    static BFu9s_B_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu9s_B_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu9s_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu32ll(Test_BFu9s_B_BFu32ll, "BFu9s_B_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu33  {
  unsigned short v1:9;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 BFu9s_B_BFu33) C1{ Fs:9 Fc FL:33}



static void Test_BFu9s_B_BFu33()
{
  {
    init_simple_test("BFu9s_B_BFu33");
    static BFu9s_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu33");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu9s_B_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu9s_B_BFu33");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu33(Test_BFu9s_B_BFu33, "BFu9s_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu7c  {
  unsigned short v1:9;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 BFu9s_B_BFu7c) C1{ Fs:9 Fc Fc:7}



static void Test_BFu9s_B_BFu7c()
{
  {
    init_simple_test("BFu9s_B_BFu7c");
    static BFu9s_B_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_B_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu7c");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9s_B_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9s_B_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu7c(Test_BFu9s_B_BFu7c, "BFu9s_B_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu7i  {
  unsigned short v1:9;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 BFu9s_B_BFu7i) C1{ Fs:9 Fc Fi:7}



static void Test_BFu9s_B_BFu7i()
{
  {
    init_simple_test("BFu9s_B_BFu7i");
    static BFu9s_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_B_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_B_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu7i");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9s_B_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9s_B_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu7i(Test_BFu9s_B_BFu7i, "BFu9s_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu7ll  {
  unsigned short v1:9;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 BFu9s_B_BFu7ll) C1{ Fs:9 Fc FL:7}



static void Test_BFu9s_B_BFu7ll()
{
  {
    init_simple_test("BFu9s_B_BFu7ll");
    static BFu9s_B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9s_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9s_B_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9s_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu7ll(Test_BFu9s_B_BFu7ll, "BFu9s_B_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu7s  {
  unsigned short v1:9;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 BFu9s_B_BFu7s) C1{ Fs:9 Fc Fs:7}



static void Test_BFu9s_B_BFu7s()
{
  {
    init_simple_test("BFu9s_B_BFu7s");
    static BFu9s_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_B_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu7s");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu9s_B_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu9s_B_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu7s(Test_BFu9s_B_BFu7s, "BFu9s_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu8c  {
  unsigned short v1:9;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 BFu9s_B_BFu8c) C1{ Fs:9 Fc Fc:8}



static void Test_BFu9s_B_BFu8c()
{
  {
    init_simple_test("BFu9s_B_BFu8c");
    static BFu9s_B_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_B_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu8c");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9s_B_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9s_B_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu8c(Test_BFu9s_B_BFu8c, "BFu9s_B_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu8i  {
  unsigned short v1:9;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 BFu9s_B_BFu8i) C1{ Fs:9 Fc Fi:8}



static void Test_BFu9s_B_BFu8i()
{
  {
    init_simple_test("BFu9s_B_BFu8i");
    static BFu9s_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_B_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_B_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu8i");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9s_B_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9s_B_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu8i(Test_BFu9s_B_BFu8i, "BFu9s_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu8ll  {
  unsigned short v1:9;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 BFu9s_B_BFu8ll) C1{ Fs:9 Fc FL:8}



static void Test_BFu9s_B_BFu8ll()
{
  {
    init_simple_test("BFu9s_B_BFu8ll");
    static BFu9s_B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9s_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9s_B_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9s_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu8ll(Test_BFu9s_B_BFu8ll, "BFu9s_B_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu8s  {
  unsigned short v1:9;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 BFu9s_B_BFu8s) C1{ Fs:9 Fc Fs:8}



static void Test_BFu9s_B_BFu8s()
{
  {
    init_simple_test("BFu9s_B_BFu8s");
    static BFu9s_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_B_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu8s");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu9s_B_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu9s_B_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu8s(Test_BFu9s_B_BFu8s, "BFu9s_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu9i  {
  unsigned short v1:9;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 BFu9s_B_BFu9i) C1{ Fs:9 Fc Fi:9}



static void Test_BFu9s_B_BFu9i()
{
  {
    init_simple_test("BFu9s_B_BFu9i");
    static BFu9s_B_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_B_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu9i");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu9s_B_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu9i(Test_BFu9s_B_BFu9i, "BFu9s_B_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu9ll  {
  unsigned short v1:9;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 BFu9s_B_BFu9ll) C1{ Fs:9 Fc FL:9}



static void Test_BFu9s_B_BFu9ll()
{
  {
    init_simple_test("BFu9s_B_BFu9ll");
    static BFu9s_B_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu9s_B_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu9ll(Test_BFu9s_B_BFu9ll, "BFu9s_B_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_BFu9s  {
  unsigned short v1:9;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 BFu9s_B_BFu9s) C1{ Fs:9 Fc Fs:9}



static void Test_BFu9s_B_BFu9s()
{
  {
    init_simple_test("BFu9s_B_BFu9s");
    static BFu9s_B_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_B_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu9s");
    check_field_offset(lv, v2, 2, "BFu9s_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu9s_B_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu9s_B_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu9s_B_BFu9s(Test_BFu9s_B_BFu9s, "BFu9s_B_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_C  {
  unsigned short v1:9;
  bool v2;
  char v3;
};
//SIG(1 BFu9s_B_C) C1{ Fs:9 Fc[2]}



static void Test_BFu9s_B_C()
{
  {
    init_simple_test("BFu9s_B_C");
    static BFu9s_B_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_B_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_C");
    check_field_offset(lv, v2, 2, "BFu9s_B_C.v2");
    check_field_offset(lv, v3, 3, "BFu9s_B_C.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_B_C(Test_BFu9s_B_C, "BFu9s_B_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_D  {
  unsigned short v1:9;
  bool v2;
  double v3;
};
//SIG(1 BFu9s_B_D) C1{ Fs:9 Fc FL}



static void Test_BFu9s_B_D()
{
  {
    init_simple_test("BFu9s_B_D");
    static BFu9s_B_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu9s_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_D");
    check_field_offset(lv, v2, 2, "BFu9s_B_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9s_B_D.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_B_D(Test_BFu9s_B_D, "BFu9s_B_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_F  {
  unsigned short v1:9;
  bool v2;
  float v3;
};
//SIG(1 BFu9s_B_F) C1{ Fs:9 Fc Fi}



static void Test_BFu9s_B_F()
{
  {
    init_simple_test("BFu9s_B_F");
    static BFu9s_B_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_B_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_F");
    check_field_offset(lv, v2, 2, "BFu9s_B_F.v2");
    check_field_offset(lv, v3, 4, "BFu9s_B_F.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_B_F(Test_BFu9s_B_F, "BFu9s_B_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_I  {
  unsigned short v1:9;
  bool v2;
  int v3;
};
//SIG(1 BFu9s_B_I) C1{ Fs:9 Fc Fi}



static void Test_BFu9s_B_I()
{
  {
    init_simple_test("BFu9s_B_I");
    static BFu9s_B_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_B_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_I");
    check_field_offset(lv, v2, 2, "BFu9s_B_I.v2");
    check_field_offset(lv, v3, 4, "BFu9s_B_I.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_B_I(Test_BFu9s_B_I, "BFu9s_B_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_Ip  {
  unsigned short v1:9;
  bool v2;
  int *v3;
};
//SIG(1 BFu9s_B_Ip) C1{ Fs:9 Fc Fp}



static void Test_BFu9s_B_Ip()
{
  {
    init_simple_test("BFu9s_B_Ip");
    static BFu9s_B_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu9s_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_Ip");
    check_field_offset(lv, v2, 2, "BFu9s_B_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9s_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_B_Ip(Test_BFu9s_B_Ip, "BFu9s_B_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_L  {
  unsigned short v1:9;
  bool v2;
  __tsi64 v3;
};
//SIG(1 BFu9s_B_L) C1{ Fs:9 Fc FL}



static void Test_BFu9s_B_L()
{
  {
    init_simple_test("BFu9s_B_L");
    static BFu9s_B_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu9s_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_L");
    check_field_offset(lv, v2, 2, "BFu9s_B_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9s_B_L.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_B_L(Test_BFu9s_B_L, "BFu9s_B_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_S  {
  unsigned short v1:9;
  bool v2;
  short v3;
};
//SIG(1 BFu9s_B_S) C1{ Fs:9 Fc Fs}



static void Test_BFu9s_B_S()
{
  {
    init_simple_test("BFu9s_B_S");
    static BFu9s_B_S lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_B_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_S");
    check_field_offset(lv, v2, 2, "BFu9s_B_S.v2");
    check_field_offset(lv, v3, 4, "BFu9s_B_S.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_B_S(Test_BFu9s_B_S, "BFu9s_B_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_Uc  {
  unsigned short v1:9;
  bool v2;
  unsigned char v3;
};
//SIG(1 BFu9s_B_Uc) C1{ Fs:9 Fc[2]}



static void Test_BFu9s_B_Uc()
{
  {
    init_simple_test("BFu9s_B_Uc");
    static BFu9s_B_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_B_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_Uc");
    check_field_offset(lv, v2, 2, "BFu9s_B_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu9s_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_B_Uc(Test_BFu9s_B_Uc, "BFu9s_B_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_Ui  {
  unsigned short v1:9;
  bool v2;
  unsigned int v3;
};
//SIG(1 BFu9s_B_Ui) C1{ Fs:9 Fc Fi}



static void Test_BFu9s_B_Ui()
{
  {
    init_simple_test("BFu9s_B_Ui");
    static BFu9s_B_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_B_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_B_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_Ui");
    check_field_offset(lv, v2, 2, "BFu9s_B_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu9s_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_B_Ui(Test_BFu9s_B_Ui, "BFu9s_B_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_Ul  {
  unsigned short v1:9;
  bool v2;
  __tsu64 v3;
};
//SIG(1 BFu9s_B_Ul) C1{ Fs:9 Fc FL}



static void Test_BFu9s_B_Ul()
{
  {
    init_simple_test("BFu9s_B_Ul");
    static BFu9s_B_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu9s_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_Ul");
    check_field_offset(lv, v2, 2, "BFu9s_B_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9s_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_B_Ul(Test_BFu9s_B_Ul, "BFu9s_B_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_Us  {
  unsigned short v1:9;
  bool v2;
  unsigned short v3;
};
//SIG(1 BFu9s_B_Us) C1{ Fs:9 Fc Fs}



static void Test_BFu9s_B_Us()
{
  {
    init_simple_test("BFu9s_B_Us");
    static BFu9s_B_Us lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_B_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_B_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_Us");
    check_field_offset(lv, v2, 2, "BFu9s_B_Us.v2");
    check_field_offset(lv, v3, 4, "BFu9s_B_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_B_Us(Test_BFu9s_B_Us, "BFu9s_B_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_B_Vp  {
  unsigned short v1:9;
  bool v2;
  void *v3;
};
//SIG(1 BFu9s_B_Vp) C1{ Fs:9 Fc Fp}



static void Test_BFu9s_B_Vp()
{
  {
    init_simple_test("BFu9s_B_Vp");
    static BFu9s_B_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu9s_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_B_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_B_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_B_Vp");
    check_field_offset(lv, v2, 2, "BFu9s_B_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu9s_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_B_Vp(Test_BFu9s_B_Vp, "BFu9s_B_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu15i_B  {
  unsigned short v1:9;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 BFu9s_BFu15i_B) C1{ Fs:9 Fi:15 Fc}



static void Test_BFu9s_BFu15i_B()
{
  {
    init_simple_test("BFu9s_BFu15i_B");
    static BFu9s_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_BFu15i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_BFu15i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu15i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu9s_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu9s_BFu15i_B");
    check_field_offset(lv, v3, 3, "BFu9s_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu15i_B(Test_BFu9s_BFu15i_B, "BFu9s_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu15ll_B  {
  unsigned short v1:9;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 BFu9s_BFu15ll_B) C1{ Fs:9 FL:15 Fc}



static void Test_BFu9s_BFu15ll_B()
{
  {
    init_simple_test("BFu9s_BFu15ll_B");
    static BFu9s_BFu15ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9s_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_BFu15ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu15ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu9s_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu9s_BFu15ll_B");
    check_field_offset(lv, v3, 3, "BFu9s_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu15ll_B(Test_BFu9s_BFu15ll_B, "BFu9s_BFu15ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu15s_B  {
  unsigned short v1:9;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 BFu9s_BFu15s_B) C1{ Fs:9 Fs:15 Fc}



static void Test_BFu9s_BFu15s_B()
{
  {
    init_simple_test("BFu9s_BFu15s_B");
    static BFu9s_BFu15s_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_BFu15s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_BFu15s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu15s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu9s_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu9s_BFu15s_B");
    check_field_offset(lv, v3, 4, "BFu9s_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu15s_B(Test_BFu9s_BFu15s_B, "BFu9s_BFu15s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu16i_B  {
  unsigned short v1:9;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 BFu9s_BFu16i_B) C1{ Fs:9 Fi:16 Fc}



static void Test_BFu9s_BFu16i_B()
{
  {
    init_simple_test("BFu9s_BFu16i_B");
    static BFu9s_BFu16i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_BFu16i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_BFu16i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu16i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu9s_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu9s_BFu16i_B");
    check_field_offset(lv, v3, 4, "BFu9s_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu16i_B(Test_BFu9s_BFu16i_B, "BFu9s_BFu16i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu16ll_B  {
  unsigned short v1:9;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 BFu9s_BFu16ll_B) C1{ Fs:9 FL:16 Fc}



static void Test_BFu9s_BFu16ll_B()
{
  {
    init_simple_test("BFu9s_BFu16ll_B");
    static BFu9s_BFu16ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_BFu16ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu16ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu9s_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu9s_BFu16ll_B");
    check_field_offset(lv, v3, 4, "BFu9s_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu16ll_B(Test_BFu9s_BFu16ll_B, "BFu9s_BFu16ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu16s_B  {
  unsigned short v1:9;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 BFu9s_BFu16s_B) C1{ Fs:9 Fs:16 Fc}



static void Test_BFu9s_BFu16s_B()
{
  {
    init_simple_test("BFu9s_BFu16s_B");
    static BFu9s_BFu16s_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_BFu16s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_BFu16s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu16s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu9s_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu9s_BFu16s_B");
    check_field_offset(lv, v3, 4, "BFu9s_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu16s_B(Test_BFu9s_BFu16s_B, "BFu9s_BFu16s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu17i_B  {
  unsigned short v1:9;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 BFu9s_BFu17i_B) C1{ Fs:9 Fi:17 Fc}



static void Test_BFu9s_BFu17i_B()
{
  {
    init_simple_test("BFu9s_BFu17i_B");
    static BFu9s_BFu17i_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_BFu17i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_BFu17i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu17i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu9s_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu9s_BFu17i_B");
    check_field_offset(lv, v3, 4, "BFu9s_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu17i_B(Test_BFu9s_BFu17i_B, "BFu9s_BFu17i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu17ll_B  {
  unsigned short v1:9;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 BFu9s_BFu17ll_B) C1{ Fs:9 FL:17 Fc}



static void Test_BFu9s_BFu17ll_B()
{
  {
    init_simple_test("BFu9s_BFu17ll_B");
    static BFu9s_BFu17ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_BFu17ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu17ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu9s_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu9s_BFu17ll_B");
    check_field_offset(lv, v3, 4, "BFu9s_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu17ll_B(Test_BFu9s_BFu17ll_B, "BFu9s_BFu17ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu1c_B  {
  unsigned short v1:9;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 BFu9s_BFu1c_B) C1{ Fs:9 Fc:1 Fc}



static void Test_BFu9s_BFu1c_B()
{
  {
    init_simple_test("BFu9s_BFu1c_B");
    static BFu9s_BFu1c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_BFu1c_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_BFu1c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu1c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu1c_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9s_BFu1c_B");
    check_field_offset(lv, v3, 2, "BFu9s_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu1c_B(Test_BFu9s_BFu1c_B, "BFu9s_BFu1c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu1i_B  {
  unsigned short v1:9;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 BFu9s_BFu1i_B) C1{ Fs:9 Fi:1 Fc}



static void Test_BFu9s_BFu1i_B()
{
  {
    init_simple_test("BFu9s_BFu1i_B");
    static BFu9s_BFu1i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_BFu1i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_BFu1i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu1i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu1i_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9s_BFu1i_B");
    check_field_offset(lv, v3, 2, "BFu9s_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu1i_B(Test_BFu9s_BFu1i_B, "BFu9s_BFu1i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu1ll_B  {
  unsigned short v1:9;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 BFu9s_BFu1ll_B) C1{ Fs:9 FL:1 Fc}



static void Test_BFu9s_BFu1ll_B()
{
  {
    init_simple_test("BFu9s_BFu1ll_B");
    static BFu9s_BFu1ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9s_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_BFu1ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu1ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu1ll_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9s_BFu1ll_B");
    check_field_offset(lv, v3, 2, "BFu9s_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu1ll_B(Test_BFu9s_BFu1ll_B, "BFu9s_BFu1ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu1s_B  {
  unsigned short v1:9;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 BFu9s_BFu1s_B) C1{ Fs:9 Fs:1 Fc}



static void Test_BFu9s_BFu1s_B()
{
  {
    init_simple_test("BFu9s_BFu1s_B");
    static BFu9s_BFu1s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_BFu1s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_BFu1s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu1s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu1s_B");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu9s_BFu1s_B");
    check_field_offset(lv, v3, 2, "BFu9s_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu1s_B(Test_BFu9s_BFu1s_B, "BFu9s_BFu1s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu31i_B  {
  unsigned short v1:9;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 BFu9s_BFu31i_B) C1{ Fs:9 Fi:31 Fc}



static void Test_BFu9s_BFu31i_B()
{
  {
    init_simple_test("BFu9s_BFu31i_B");
    static BFu9s_BFu31i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_BFu31i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_BFu31i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu31i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu9s_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu9s_BFu31i_B");
    check_field_offset(lv, v3, 8, "BFu9s_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu31i_B(Test_BFu9s_BFu31i_B, "BFu9s_BFu31i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu31ll_B  {
  unsigned short v1:9;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 BFu9s_BFu31ll_B) C1{ Fs:9 FL:31 Fc}



static void Test_BFu9s_BFu31ll_B()
{
  {
    init_simple_test("BFu9s_BFu31ll_B");
    static BFu9s_BFu31ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_BFu31ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu31ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu9s_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu9s_BFu31ll_B");
    check_field_offset(lv, v3, 5, "BFu9s_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu31ll_B(Test_BFu9s_BFu31ll_B, "BFu9s_BFu31ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu32i_B  {
  unsigned short v1:9;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 BFu9s_BFu32i_B) C1{ Fs:9 Fi:32 Fc}



static void Test_BFu9s_BFu32i_B()
{
  {
    init_simple_test("BFu9s_BFu32i_B");
    static BFu9s_BFu32i_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_BFu32i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_BFu32i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu32i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu9s_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu9s_BFu32i_B");
    check_field_offset(lv, v3, 8, "BFu9s_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu32i_B(Test_BFu9s_BFu32i_B, "BFu9s_BFu32i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu32ll_B  {
  unsigned short v1:9;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 BFu9s_BFu32ll_B) C1{ Fs:9 FL:32 Fc}



static void Test_BFu9s_BFu32ll_B()
{
  {
    init_simple_test("BFu9s_BFu32ll_B");
    static BFu9s_BFu32ll_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_BFu32ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu32ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu9s_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu9s_BFu32ll_B");
    check_field_offset(lv, v3, 6, "BFu9s_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu32ll_B(Test_BFu9s_BFu32ll_B, "BFu9s_BFu32ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu33_B  {
  unsigned short v1:9;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 BFu9s_BFu33_B) C1{ Fs:9 FL:33 Fc}



static void Test_BFu9s_BFu33_B()
{
  {
    init_simple_test("BFu9s_BFu33_B");
    static BFu9s_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(BFu9s_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_BFu33_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu33_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu33_B");
    set_bf_and_test(lv, v2, 1, 1, 33, 1, "BFu9s_BFu33_B");
    set_bf_and_test(lv, v2, 1, 1, 33, hide_ull(1LL<<32), "BFu9s_BFu33_B");
    check_field_offset(lv, v3, 6, "BFu9s_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu33_B(Test_BFu9s_BFu33_B, "BFu9s_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu7c_B  {
  unsigned short v1:9;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 BFu9s_BFu7c_B) C1{ Fs:9 Fc:7 Fc}



static void Test_BFu9s_BFu7c_B()
{
  {
    init_simple_test("BFu9s_BFu7c_B");
    static BFu9s_BFu7c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_BFu7c_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_BFu7c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu7c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9s_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9s_BFu7c_B");
    check_field_offset(lv, v3, 2, "BFu9s_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu7c_B(Test_BFu9s_BFu7c_B, "BFu9s_BFu7c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu7i_B  {
  unsigned short v1:9;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 BFu9s_BFu7i_B) C1{ Fs:9 Fi:7 Fc}



static void Test_BFu9s_BFu7i_B()
{
  {
    init_simple_test("BFu9s_BFu7i_B");
    static BFu9s_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_BFu7i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_BFu7i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu7i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9s_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9s_BFu7i_B");
    check_field_offset(lv, v3, 2, "BFu9s_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu7i_B(Test_BFu9s_BFu7i_B, "BFu9s_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu7ll_B  {
  unsigned short v1:9;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 BFu9s_BFu7ll_B) C1{ Fs:9 FL:7 Fc}



static void Test_BFu9s_BFu7ll_B()
{
  {
    init_simple_test("BFu9s_BFu7ll_B");
    static BFu9s_BFu7ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9s_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_BFu7ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu7ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9s_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9s_BFu7ll_B");
    check_field_offset(lv, v3, 2, "BFu9s_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu7ll_B(Test_BFu9s_BFu7ll_B, "BFu9s_BFu7ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu7s_B  {
  unsigned short v1:9;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 BFu9s_BFu7s_B) C1{ Fs:9 Fs:7 Fc}



static void Test_BFu9s_BFu7s_B()
{
  {
    init_simple_test("BFu9s_BFu7s_B");
    static BFu9s_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_BFu7s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_BFu7s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu7s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu9s_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu9s_BFu7s_B");
    check_field_offset(lv, v3, 2, "BFu9s_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu7s_B(Test_BFu9s_BFu7s_B, "BFu9s_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu8c_B  {
  unsigned short v1:9;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 BFu9s_BFu8c_B) C1{ Fs:9 Fc:8 Fc}



static void Test_BFu9s_BFu8c_B()
{
  {
    init_simple_test("BFu9s_BFu8c_B");
    static BFu9s_BFu8c_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_BFu8c_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_BFu8c_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu8c_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu8c_B");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu9s_BFu8c_B");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu9s_BFu8c_B");
    check_field_offset(lv, v3, 3, "BFu9s_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu8c_B(Test_BFu9s_BFu8c_B, "BFu9s_BFu8c_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu8i_B  {
  unsigned short v1:9;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 BFu9s_BFu8i_B) C1{ Fs:9 Fi:8 Fc}



static void Test_BFu9s_BFu8i_B()
{
  {
    init_simple_test("BFu9s_BFu8i_B");
    static BFu9s_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_BFu8i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_BFu8i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu8i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu9s_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu9s_BFu8i_B");
    check_field_offset(lv, v3, 3, "BFu9s_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu8i_B(Test_BFu9s_BFu8i_B, "BFu9s_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu8ll_B  {
  unsigned short v1:9;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 BFu9s_BFu8ll_B) C1{ Fs:9 FL:8 Fc}



static void Test_BFu9s_BFu8ll_B()
{
  {
    init_simple_test("BFu9s_BFu8ll_B");
    static BFu9s_BFu8ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9s_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_BFu8ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu8ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu9s_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu9s_BFu8ll_B");
    check_field_offset(lv, v3, 3, "BFu9s_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu8ll_B(Test_BFu9s_BFu8ll_B, "BFu9s_BFu8ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu8s_B  {
  unsigned short v1:9;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 BFu9s_BFu8s_B) C1{ Fs:9 Fs:8 Fc}



static void Test_BFu9s_BFu8s_B()
{
  {
    init_simple_test("BFu9s_BFu8s_B");
    static BFu9s_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_BFu8s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_BFu8s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu8s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu8s_B");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu9s_BFu8s_B");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu9s_BFu8s_B");
    check_field_offset(lv, v3, 3, "BFu9s_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu8s_B(Test_BFu9s_BFu8s_B, "BFu9s_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu9i_B  {
  unsigned short v1:9;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 BFu9s_BFu9i_B) C1{ Fs:9 Fi:9 Fc}



static void Test_BFu9s_BFu9i_B()
{
  {
    init_simple_test("BFu9s_BFu9i_B");
    static BFu9s_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_BFu9i_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_BFu9i_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu9i_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu9s_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu9s_BFu9i_B");
    check_field_offset(lv, v3, 3, "BFu9s_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu9i_B(Test_BFu9s_BFu9i_B, "BFu9s_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu9ll_B  {
  unsigned short v1:9;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 BFu9s_BFu9ll_B) C1{ Fs:9 FL:9 Fc}



static void Test_BFu9s_BFu9ll_B()
{
  {
    init_simple_test("BFu9s_BFu9ll_B");
    static BFu9s_BFu9ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu9s_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_BFu9ll_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu9ll_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu9s_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu9s_BFu9ll_B");
    check_field_offset(lv, v3, 3, "BFu9s_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu9ll_B(Test_BFu9s_BFu9ll_B, "BFu9s_BFu9ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_BFu9s_B  {
  unsigned short v1:9;
  unsigned short v2:9;
  bool v3;
};
//SIG(1 BFu9s_BFu9s_B) C1{ Fs:9 Fs:9 Fc}



static void Test_BFu9s_BFu9s_B()
{
  {
    init_simple_test("BFu9s_BFu9s_B");
    static BFu9s_BFu9s_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_BFu9s_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_BFu9s_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_BFu9s_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu9s_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu9s_BFu9s_B");
    check_field_offset(lv, v3, 4, "BFu9s_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_BFu9s_B(Test_BFu9s_BFu9s_B, "BFu9s_BFu9s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_C_B  {
  unsigned short v1:9;
  char v2;
  bool v3;
};
//SIG(1 BFu9s_C_B) C1{ Fs:9 Fc[2]}



static void Test_BFu9s_C_B()
{
  {
    init_simple_test("BFu9s_C_B");
    static BFu9s_C_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_C_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_C_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_C_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_C_B");
    check_field_offset(lv, v2, 2, "BFu9s_C_B.v2");
    check_field_offset(lv, v3, 3, "BFu9s_C_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_C_B(Test_BFu9s_C_B, "BFu9s_C_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_D_B  {
  unsigned short v1:9;
  double v2;
  bool v3;
};
//SIG(1 BFu9s_D_B) C1{ Fs:9 FL Fc}



static void Test_BFu9s_D_B()
{
  {
    init_simple_test("BFu9s_D_B");
    static BFu9s_D_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu9s_D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_D_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_D_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_D_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9s_D_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu9s_D_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_D_B(Test_BFu9s_D_B, "BFu9s_D_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_F_B  {
  unsigned short v1:9;
  float v2;
  bool v3;
};
//SIG(1 BFu9s_F_B) C1{ Fs:9 Fi Fc}



static void Test_BFu9s_F_B()
{
  {
    init_simple_test("BFu9s_F_B");
    static BFu9s_F_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_F_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_F_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_F_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_F_B");
    check_field_offset(lv, v2, 4, "BFu9s_F_B.v2");
    check_field_offset(lv, v3, 8, "BFu9s_F_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_F_B(Test_BFu9s_F_B, "BFu9s_F_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_I_B  {
  unsigned short v1:9;
  int v2;
  bool v3;
};
//SIG(1 BFu9s_I_B) C1{ Fs:9 Fi Fc}



static void Test_BFu9s_I_B()
{
  {
    init_simple_test("BFu9s_I_B");
    static BFu9s_I_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_I_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_I_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_I_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_I_B");
    check_field_offset(lv, v2, 4, "BFu9s_I_B.v2");
    check_field_offset(lv, v3, 8, "BFu9s_I_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_I_B(Test_BFu9s_I_B, "BFu9s_I_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_Ip_B  {
  unsigned short v1:9;
  int *v2;
  bool v3;
};
//SIG(1 BFu9s_Ip_B) C1{ Fs:9 Fp Fc}



static void Test_BFu9s_Ip_B()
{
  {
    init_simple_test("BFu9s_Ip_B");
    static BFu9s_Ip_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu9s_Ip_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_Ip_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ip_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ip_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9s_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu9s_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_Ip_B(Test_BFu9s_Ip_B, "BFu9s_Ip_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_L_B  {
  unsigned short v1:9;
  __tsi64 v2;
  bool v3;
};
//SIG(1 BFu9s_L_B) C1{ Fs:9 FL Fc}



static void Test_BFu9s_L_B()
{
  {
    init_simple_test("BFu9s_L_B");
    static BFu9s_L_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu9s_L_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_L_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_L_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_L_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9s_L_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu9s_L_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_L_B(Test_BFu9s_L_B, "BFu9s_L_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_S_B  {
  unsigned short v1:9;
  short v2;
  bool v3;
};
//SIG(1 BFu9s_S_B) C1{ Fs:9 Fs Fc}



static void Test_BFu9s_S_B()
{
  {
    init_simple_test("BFu9s_S_B");
    static BFu9s_S_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_S_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_S_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_S_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_S_B");
    check_field_offset(lv, v2, 2, "BFu9s_S_B.v2");
    check_field_offset(lv, v3, 4, "BFu9s_S_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_S_B(Test_BFu9s_S_B, "BFu9s_S_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_Uc_B  {
  unsigned short v1:9;
  unsigned char v2;
  bool v3;
};
//SIG(1 BFu9s_Uc_B) C1{ Fs:9 Fc[2]}



static void Test_BFu9s_Uc_B()
{
  {
    init_simple_test("BFu9s_Uc_B");
    static BFu9s_Uc_B lv;
    check2(sizeof(lv), 4, "sizeof(BFu9s_Uc_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_Uc_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Uc_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Uc_B");
    check_field_offset(lv, v2, 2, "BFu9s_Uc_B.v2");
    check_field_offset(lv, v3, 3, "BFu9s_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_Uc_B(Test_BFu9s_Uc_B, "BFu9s_Uc_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_Ui_B  {
  unsigned short v1:9;
  unsigned int v2;
  bool v3;
};
//SIG(1 BFu9s_Ui_B) C1{ Fs:9 Fi Fc}



static void Test_BFu9s_Ui_B()
{
  {
    init_simple_test("BFu9s_Ui_B");
    static BFu9s_Ui_B lv;
    check2(sizeof(lv), 12, "sizeof(BFu9s_Ui_B)");
    check2(__alignof__(lv), 4, "__alignof__(BFu9s_Ui_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ui_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ui_B");
    check_field_offset(lv, v2, 4, "BFu9s_Ui_B.v2");
    check_field_offset(lv, v3, 8, "BFu9s_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_Ui_B(Test_BFu9s_Ui_B, "BFu9s_Ui_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_Ul_B  {
  unsigned short v1:9;
  __tsu64 v2;
  bool v3;
};
//SIG(1 BFu9s_Ul_B) C1{ Fs:9 FL Fc}



static void Test_BFu9s_Ul_B()
{
  {
    init_simple_test("BFu9s_Ul_B");
    static BFu9s_Ul_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu9s_Ul_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_Ul_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Ul_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Ul_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9s_Ul_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu9s_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_Ul_B(Test_BFu9s_Ul_B, "BFu9s_Ul_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_Us_B  {
  unsigned short v1:9;
  unsigned short v2;
  bool v3;
};
//SIG(1 BFu9s_Us_B) C1{ Fs:9 Fs Fc}



static void Test_BFu9s_Us_B()
{
  {
    init_simple_test("BFu9s_Us_B");
    static BFu9s_Us_B lv;
    check2(sizeof(lv), 6, "sizeof(BFu9s_Us_B)");
    check2(__alignof__(lv), 2, "__alignof__(BFu9s_Us_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Us_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Us_B");
    check_field_offset(lv, v2, 2, "BFu9s_Us_B.v2");
    check_field_offset(lv, v3, 4, "BFu9s_Us_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_Us_B(Test_BFu9s_Us_B, "BFu9s_Us_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu9s_Vp_B  {
  unsigned short v1:9;
  void *v2;
  bool v3;
};
//SIG(1 BFu9s_Vp_B) C1{ Fs:9 Fp Fc}



static void Test_BFu9s_Vp_B()
{
  {
    init_simple_test("BFu9s_Vp_B");
    static BFu9s_Vp_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu9s_Vp_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu9s_Vp_B)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu9s_Vp_B");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu9s_Vp_B");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu9s_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu9s_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vBFu9s_Vp_B(Test_BFu9s_Vp_B, "BFu9s_Vp_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B  {
  char v1;
  bool v2;
};
//SIG(1 C_B) C1{ Fc[2]}



static void Test_C_B()
{
  {
    init_simple_test("C_B");
    C_B lv;
    check2(sizeof(lv), 2, "sizeof(C_B)");
    check2(__alignof__(lv), 1, "__alignof__(C_B)");
    check_field_offset(lv, v1, 0, "C_B.v1");
    check_field_offset(lv, v2, 1, "C_B.v2");
  }
}
static Arrange_To_Call_Me vC_B(Test_C_B, "C_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_B  {
  char v1;
  bool v2;
  bool v3;
};
//SIG(1 C_B_B) C1{ Fc[3]}



static void Test_C_B_B()
{
  {
    init_simple_test("C_B_B");
    C_B_B lv;
    check2(sizeof(lv), 3, "sizeof(C_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(C_B_B)");
    check_field_offset(lv, v1, 0, "C_B_B.v1");
    check_field_offset(lv, v2, 1, "C_B_B.v2");
    check_field_offset(lv, v3, 2, "C_B_B.v3");
  }
}
static Arrange_To_Call_Me vC_B_B(Test_C_B_B, "C_B_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu15i  {
  char v1;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 C_B_BFu15i) C1{ Fc[2] Fi:15}



static void Test_C_B_BFu15i()
{
  {
    init_simple_test("C_B_BFu15i");
    static C_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(C_B_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(C_B_BFu15i)");
    check_field_offset(lv, v1, 0, "C_B_BFu15i.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_B_BFu15i");
  }
}
static Arrange_To_Call_Me vC_B_BFu15i(Test_C_B_BFu15i, "C_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu15ll  {
  char v1;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 C_B_BFu15ll) C1{ Fc[2] FL:15}



static void Test_C_B_BFu15ll()
{
  {
    init_simple_test("C_B_BFu15ll");
    static C_B_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_BFu15ll)");
    check_field_offset(lv, v1, 0, "C_B_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vC_B_BFu15ll(Test_C_B_BFu15ll, "C_B_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu15s  {
  char v1;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 C_B_BFu15s) C1{ Fc[2] Fs:15}



static void Test_C_B_BFu15s()
{
  {
    init_simple_test("C_B_BFu15s");
    static C_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(C_B_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(C_B_BFu15s)");
    check_field_offset(lv, v1, 0, "C_B_BFu15s.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "C_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "C_B_BFu15s");
  }
}
static Arrange_To_Call_Me vC_B_BFu15s(Test_C_B_BFu15s, "C_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu16i  {
  char v1;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 C_B_BFu16i) C1{ Fc[2] Fi:16}



static void Test_C_B_BFu16i()
{
  {
    init_simple_test("C_B_BFu16i");
    static C_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(C_B_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(C_B_BFu16i)");
    check_field_offset(lv, v1, 0, "C_B_BFu16i.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_B_BFu16i");
  }
}
static Arrange_To_Call_Me vC_B_BFu16i(Test_C_B_BFu16i, "C_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu16ll  {
  char v1;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 C_B_BFu16ll) C1{ Fc[2] FL:16}



static void Test_C_B_BFu16ll()
{
  {
    init_simple_test("C_B_BFu16ll");
    static C_B_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_BFu16ll)");
    check_field_offset(lv, v1, 0, "C_B_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vC_B_BFu16ll(Test_C_B_BFu16ll, "C_B_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu16s  {
  char v1;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 C_B_BFu16s) C1{ Fc[2] Fs:16}



static void Test_C_B_BFu16s()
{
  {
    init_simple_test("C_B_BFu16s");
    static C_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(C_B_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(C_B_BFu16s)");
    check_field_offset(lv, v1, 0, "C_B_BFu16s.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "C_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "C_B_BFu16s");
  }
}
static Arrange_To_Call_Me vC_B_BFu16s(Test_C_B_BFu16s, "C_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu17i  {
  char v1;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 C_B_BFu17i) C1{ Fc[2] Fi:17}



static void Test_C_B_BFu17i()
{
  {
    init_simple_test("C_B_BFu17i");
    static C_B_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(C_B_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(C_B_BFu17i)");
    check_field_offset(lv, v1, 0, "C_B_BFu17i.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "C_B_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "C_B_BFu17i");
  }
}
static Arrange_To_Call_Me vC_B_BFu17i(Test_C_B_BFu17i, "C_B_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu17ll  {
  char v1;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 C_B_BFu17ll) C1{ Fc[2] FL:17}



static void Test_C_B_BFu17ll()
{
  {
    init_simple_test("C_B_BFu17ll");
    static C_B_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(C_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_BFu17ll)");
    check_field_offset(lv, v1, 0, "C_B_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "C_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "C_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vC_B_BFu17ll(Test_C_B_BFu17ll, "C_B_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu1c  {
  char v1;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 C_B_BFu1c) C1{ Fc[2] Fc:1}



static void Test_C_B_BFu1c()
{
  {
    init_simple_test("C_B_BFu1c");
    static C_B_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(C_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(C_B_BFu1c)");
    check_field_offset(lv, v1, 0, "C_B_BFu1c.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_B_BFu1c");
  }
}
static Arrange_To_Call_Me vC_B_BFu1c(Test_C_B_BFu1c, "C_B_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu1i  {
  char v1;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 C_B_BFu1i) C1{ Fc[2] Fi:1}



static void Test_C_B_BFu1i()
{
  {
    init_simple_test("C_B_BFu1i");
    static C_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(C_B_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(C_B_BFu1i)");
    check_field_offset(lv, v1, 0, "C_B_BFu1i.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_B_BFu1i");
  }
}
static Arrange_To_Call_Me vC_B_BFu1i(Test_C_B_BFu1i, "C_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu1ll  {
  char v1;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 C_B_BFu1ll) C1{ Fc[2] FL:1}



static void Test_C_B_BFu1ll()
{
  {
    init_simple_test("C_B_BFu1ll");
    static C_B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_BFu1ll)");
    check_field_offset(lv, v1, 0, "C_B_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vC_B_BFu1ll(Test_C_B_BFu1ll, "C_B_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu1s  {
  char v1;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 C_B_BFu1s) C1{ Fc[2] Fs:1}



static void Test_C_B_BFu1s()
{
  {
    init_simple_test("C_B_BFu1s");
    static C_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(C_B_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(C_B_BFu1s)");
    check_field_offset(lv, v1, 0, "C_B_BFu1s.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "C_B_BFu1s");
  }
}
static Arrange_To_Call_Me vC_B_BFu1s(Test_C_B_BFu1s, "C_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu31i  {
  char v1;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 C_B_BFu31i) C1{ Fc[2] Fi:31}



static void Test_C_B_BFu31i()
{
  {
    init_simple_test("C_B_BFu31i");
    static C_B_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(C_B_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(C_B_BFu31i)");
    check_field_offset(lv, v1, 0, "C_B_BFu31i.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "C_B_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "C_B_BFu31i");
  }
}
static Arrange_To_Call_Me vC_B_BFu31i(Test_C_B_BFu31i, "C_B_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu31ll  {
  char v1;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 C_B_BFu31ll) C1{ Fc[2] FL:31}



static void Test_C_B_BFu31ll()
{
  {
    init_simple_test("C_B_BFu31ll");
    static C_B_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(C_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_BFu31ll)");
    check_field_offset(lv, v1, 0, "C_B_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "C_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "C_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vC_B_BFu31ll(Test_C_B_BFu31ll, "C_B_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu32i  {
  char v1;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 C_B_BFu32i) C1{ Fc[2] Fi:32}



static void Test_C_B_BFu32i()
{
  {
    init_simple_test("C_B_BFu32i");
    static C_B_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(C_B_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(C_B_BFu32i)");
    check_field_offset(lv, v1, 0, "C_B_BFu32i.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "C_B_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "C_B_BFu32i");
  }
}
static Arrange_To_Call_Me vC_B_BFu32i(Test_C_B_BFu32i, "C_B_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu32ll  {
  char v1;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 C_B_BFu32ll) C1{ Fc[2] FL:32}



static void Test_C_B_BFu32ll()
{
  {
    init_simple_test("C_B_BFu32ll");
    static C_B_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(C_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_BFu32ll)");
    check_field_offset(lv, v1, 0, "C_B_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "C_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "C_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vC_B_BFu32ll(Test_C_B_BFu32ll, "C_B_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu33  {
  char v1;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 C_B_BFu33) C1{ Fc[2] FL:33}



static void Test_C_B_BFu33()
{
  {
    init_simple_test("C_B_BFu33");
    static C_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(C_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_BFu33)");
    check_field_offset(lv, v1, 0, "C_B_BFu33.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "C_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "C_B_BFu33");
  }
}
static Arrange_To_Call_Me vC_B_BFu33(Test_C_B_BFu33, "C_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu7c  {
  char v1;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 C_B_BFu7c) C1{ Fc[2] Fc:7}



static void Test_C_B_BFu7c()
{
  {
    init_simple_test("C_B_BFu7c");
    static C_B_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(C_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(C_B_BFu7c)");
    check_field_offset(lv, v1, 0, "C_B_BFu7c.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_B_BFu7c");
  }
}
static Arrange_To_Call_Me vC_B_BFu7c(Test_C_B_BFu7c, "C_B_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu7i  {
  char v1;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 C_B_BFu7i) C1{ Fc[2] Fi:7}



static void Test_C_B_BFu7i()
{
  {
    init_simple_test("C_B_BFu7i");
    static C_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(C_B_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(C_B_BFu7i)");
    check_field_offset(lv, v1, 0, "C_B_BFu7i.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_B_BFu7i");
  }
}
static Arrange_To_Call_Me vC_B_BFu7i(Test_C_B_BFu7i, "C_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu7ll  {
  char v1;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 C_B_BFu7ll) C1{ Fc[2] FL:7}



static void Test_C_B_BFu7ll()
{
  {
    init_simple_test("C_B_BFu7ll");
    static C_B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_BFu7ll)");
    check_field_offset(lv, v1, 0, "C_B_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vC_B_BFu7ll(Test_C_B_BFu7ll, "C_B_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu7s  {
  char v1;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 C_B_BFu7s) C1{ Fc[2] Fs:7}



static void Test_C_B_BFu7s()
{
  {
    init_simple_test("C_B_BFu7s");
    static C_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(C_B_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(C_B_BFu7s)");
    check_field_offset(lv, v1, 0, "C_B_BFu7s.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "C_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "C_B_BFu7s");
  }
}
static Arrange_To_Call_Me vC_B_BFu7s(Test_C_B_BFu7s, "C_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu8c  {
  char v1;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 C_B_BFu8c) C1{ Fc[2] Fc:8}



static void Test_C_B_BFu8c()
{
  {
    init_simple_test("C_B_BFu8c");
    static C_B_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(C_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(C_B_BFu8c)");
    check_field_offset(lv, v1, 0, "C_B_BFu8c.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_B_BFu8c");
  }
}
static Arrange_To_Call_Me vC_B_BFu8c(Test_C_B_BFu8c, "C_B_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu8i  {
  char v1;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 C_B_BFu8i) C1{ Fc[2] Fi:8}



static void Test_C_B_BFu8i()
{
  {
    init_simple_test("C_B_BFu8i");
    static C_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(C_B_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(C_B_BFu8i)");
    check_field_offset(lv, v1, 0, "C_B_BFu8i.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_B_BFu8i");
  }
}
static Arrange_To_Call_Me vC_B_BFu8i(Test_C_B_BFu8i, "C_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu8ll  {
  char v1;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 C_B_BFu8ll) C1{ Fc[2] FL:8}



static void Test_C_B_BFu8ll()
{
  {
    init_simple_test("C_B_BFu8ll");
    static C_B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_BFu8ll)");
    check_field_offset(lv, v1, 0, "C_B_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vC_B_BFu8ll(Test_C_B_BFu8ll, "C_B_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu8s  {
  char v1;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 C_B_BFu8s) C1{ Fc[2] Fs:8}



static void Test_C_B_BFu8s()
{
  {
    init_simple_test("C_B_BFu8s");
    static C_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(C_B_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(C_B_BFu8s)");
    check_field_offset(lv, v1, 0, "C_B_BFu8s.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "C_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "C_B_BFu8s");
  }
}
static Arrange_To_Call_Me vC_B_BFu8s(Test_C_B_BFu8s, "C_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu9i  {
  char v1;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 C_B_BFu9i) C1{ Fc[2] Fi:9}



static void Test_C_B_BFu9i()
{
  {
    init_simple_test("C_B_BFu9i");
    static C_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(C_B_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(C_B_BFu9i)");
    check_field_offset(lv, v1, 0, "C_B_BFu9i.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_B_BFu9i");
  }
}
static Arrange_To_Call_Me vC_B_BFu9i(Test_C_B_BFu9i, "C_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu9ll  {
  char v1;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 C_B_BFu9ll) C1{ Fc[2] FL:9}



static void Test_C_B_BFu9ll()
{
  {
    init_simple_test("C_B_BFu9ll");
    static C_B_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_BFu9ll)");
    check_field_offset(lv, v1, 0, "C_B_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vC_B_BFu9ll(Test_C_B_BFu9ll, "C_B_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_BFu9s  {
  char v1;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 C_B_BFu9s) C1{ Fc[2] Fs:9}



static void Test_C_B_BFu9s()
{
  {
    init_simple_test("C_B_BFu9s");
    static C_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(C_B_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(C_B_BFu9s)");
    check_field_offset(lv, v1, 0, "C_B_BFu9s.v1");
    check_field_offset(lv, v2, 1, "C_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "C_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "C_B_BFu9s");
  }
}
static Arrange_To_Call_Me vC_B_BFu9s(Test_C_B_BFu9s, "C_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_C  {
  char v1;
  bool v2;
  char v3;
};
//SIG(1 C_B_C) C1{ Fc[3]}



static void Test_C_B_C()
{
  {
    init_simple_test("C_B_C");
    C_B_C lv;
    check2(sizeof(lv), 3, "sizeof(C_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(C_B_C)");
    check_field_offset(lv, v1, 0, "C_B_C.v1");
    check_field_offset(lv, v2, 1, "C_B_C.v2");
    check_field_offset(lv, v3, 2, "C_B_C.v3");
  }
}
static Arrange_To_Call_Me vC_B_C(Test_C_B_C, "C_B_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_D  {
  char v1;
  bool v2;
  double v3;
};
//SIG(1 C_B_D) C1{ Fc[2] FL}



static void Test_C_B_D()
{
  {
    init_simple_test("C_B_D");
    C_B_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_D)");
    check_field_offset(lv, v1, 0, "C_B_D.v1");
    check_field_offset(lv, v2, 1, "C_B_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_B_D.v3");
  }
}
static Arrange_To_Call_Me vC_B_D(Test_C_B_D, "C_B_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_F  {
  char v1;
  bool v2;
  float v3;
};
//SIG(1 C_B_F) C1{ Fc[2] Fi}



static void Test_C_B_F()
{
  {
    init_simple_test("C_B_F");
    C_B_F lv;
    check2(sizeof(lv), 8, "sizeof(C_B_F)");
    check2(__alignof__(lv), 4, "__alignof__(C_B_F)");
    check_field_offset(lv, v1, 0, "C_B_F.v1");
    check_field_offset(lv, v2, 1, "C_B_F.v2");
    check_field_offset(lv, v3, 4, "C_B_F.v3");
  }
}
static Arrange_To_Call_Me vC_B_F(Test_C_B_F, "C_B_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_I  {
  char v1;
  bool v2;
  int v3;
};
//SIG(1 C_B_I) C1{ Fc[2] Fi}



static void Test_C_B_I()
{
  {
    init_simple_test("C_B_I");
    C_B_I lv;
    check2(sizeof(lv), 8, "sizeof(C_B_I)");
    check2(__alignof__(lv), 4, "__alignof__(C_B_I)");
    check_field_offset(lv, v1, 0, "C_B_I.v1");
    check_field_offset(lv, v2, 1, "C_B_I.v2");
    check_field_offset(lv, v3, 4, "C_B_I.v3");
  }
}
static Arrange_To_Call_Me vC_B_I(Test_C_B_I, "C_B_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_Ip  {
  char v1;
  bool v2;
  int *v3;
};
//SIG(1 C_B_Ip) C1{ Fc[2] Fp}



static void Test_C_B_Ip()
{
  {
    init_simple_test("C_B_Ip");
    C_B_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_Ip)");
    check_field_offset(lv, v1, 0, "C_B_Ip.v1");
    check_field_offset(lv, v2, 1, "C_B_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vC_B_Ip(Test_C_B_Ip, "C_B_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_L  {
  char v1;
  bool v2;
  __tsi64 v3;
};
//SIG(1 C_B_L) C1{ Fc[2] FL}



static void Test_C_B_L()
{
  {
    init_simple_test("C_B_L");
    C_B_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_L)");
    check_field_offset(lv, v1, 0, "C_B_L.v1");
    check_field_offset(lv, v2, 1, "C_B_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_B_L.v3");
  }
}
static Arrange_To_Call_Me vC_B_L(Test_C_B_L, "C_B_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_S  {
  char v1;
  bool v2;
  short v3;
};
//SIG(1 C_B_S) C1{ Fc[2] Fs}



static void Test_C_B_S()
{
  {
    init_simple_test("C_B_S");
    C_B_S lv;
    check2(sizeof(lv), 4, "sizeof(C_B_S)");
    check2(__alignof__(lv), 2, "__alignof__(C_B_S)");
    check_field_offset(lv, v1, 0, "C_B_S.v1");
    check_field_offset(lv, v2, 1, "C_B_S.v2");
    check_field_offset(lv, v3, 2, "C_B_S.v3");
  }
}
static Arrange_To_Call_Me vC_B_S(Test_C_B_S, "C_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_Uc  {
  char v1;
  bool v2;
  unsigned char v3;
};
//SIG(1 C_B_Uc) C1{ Fc[3]}



static void Test_C_B_Uc()
{
  {
    init_simple_test("C_B_Uc");
    C_B_Uc lv;
    check2(sizeof(lv), 3, "sizeof(C_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(C_B_Uc)");
    check_field_offset(lv, v1, 0, "C_B_Uc.v1");
    check_field_offset(lv, v2, 1, "C_B_Uc.v2");
    check_field_offset(lv, v3, 2, "C_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vC_B_Uc(Test_C_B_Uc, "C_B_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_Ui  {
  char v1;
  bool v2;
  unsigned int v3;
};
//SIG(1 C_B_Ui) C1{ Fc[2] Fi}



static void Test_C_B_Ui()
{
  {
    init_simple_test("C_B_Ui");
    C_B_Ui lv;
    check2(sizeof(lv), 8, "sizeof(C_B_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(C_B_Ui)");
    check_field_offset(lv, v1, 0, "C_B_Ui.v1");
    check_field_offset(lv, v2, 1, "C_B_Ui.v2");
    check_field_offset(lv, v3, 4, "C_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vC_B_Ui(Test_C_B_Ui, "C_B_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_Ul  {
  char v1;
  bool v2;
  __tsu64 v3;
};
//SIG(1 C_B_Ul) C1{ Fc[2] FL}



static void Test_C_B_Ul()
{
  {
    init_simple_test("C_B_Ul");
    C_B_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(C_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_Ul)");
    check_field_offset(lv, v1, 0, "C_B_Ul.v1");
    check_field_offset(lv, v2, 1, "C_B_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vC_B_Ul(Test_C_B_Ul, "C_B_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_Us  {
  char v1;
  bool v2;
  unsigned short v3;
};
//SIG(1 C_B_Us) C1{ Fc[2] Fs}



static void Test_C_B_Us()
{
  {
    init_simple_test("C_B_Us");
    C_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(C_B_Us)");
    check2(__alignof__(lv), 2, "__alignof__(C_B_Us)");
    check_field_offset(lv, v1, 0, "C_B_Us.v1");
    check_field_offset(lv, v2, 1, "C_B_Us.v2");
    check_field_offset(lv, v3, 2, "C_B_Us.v3");
  }
}
static Arrange_To_Call_Me vC_B_Us(Test_C_B_Us, "C_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_B_Vp  {
  char v1;
  bool v2;
  void *v3;
};
//SIG(1 C_B_Vp) C1{ Fc[2] Fp}



static void Test_C_B_Vp()
{
  {
    init_simple_test("C_B_Vp");
    C_B_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(C_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_B_Vp)");
    check_field_offset(lv, v1, 0, "C_B_Vp.v1");
    check_field_offset(lv, v2, 1, "C_B_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "C_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vC_B_Vp(Test_C_B_Vp, "C_B_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu15i_B  {
  char v1;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 C_BFu15i_B) C1{ Fc Fi:15 Fc}



static void Test_C_BFu15i_B()
{
  {
    init_simple_test("C_BFu15i_B");
    static C_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu15i_B)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu15i_B)");
    check_field_offset(lv, v1, 0, "C_BFu15i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15i_B");
    check_field_offset(lv, v3, 3, "C_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu15i_B(Test_C_BFu15i_B, "C_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu15ll_B  {
  char v1;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 C_BFu15ll_B) C1{ Fc FL:15 Fc}



static void Test_C_BFu15ll_B()
{
  {
    init_simple_test("C_BFu15ll_B");
    static C_BFu15ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu15ll_B)");
    check_field_offset(lv, v1, 0, "C_BFu15ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "C_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "C_BFu15ll_B");
    check_field_offset(lv, v3, 3, "C_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu15ll_B(Test_C_BFu15ll_B, "C_BFu15ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu15s_B  {
  char v1;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 C_BFu15s_B) C1{ Fc Fs:15 Fc}



static void Test_C_BFu15s_B()
{
  {
    init_simple_test("C_BFu15s_B");
    static C_BFu15s_B lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu15s_B)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu15s_B)");
    check_field_offset(lv, v1, 0, "C_BFu15s_B.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "C_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "C_BFu15s_B");
    check_field_offset(lv, v3, 4, "C_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu15s_B(Test_C_BFu15s_B, "C_BFu15s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu16i_B  {
  char v1;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 C_BFu16i_B) C1{ Fc Fi:16 Fc}



static void Test_C_BFu16i_B()
{
  {
    init_simple_test("C_BFu16i_B");
    static C_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu16i_B)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu16i_B)");
    check_field_offset(lv, v1, 0, "C_BFu16i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16i_B");
    check_field_offset(lv, v3, 3, "C_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu16i_B(Test_C_BFu16i_B, "C_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu16ll_B  {
  char v1;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 C_BFu16ll_B) C1{ Fc FL:16 Fc}



static void Test_C_BFu16ll_B()
{
  {
    init_simple_test("C_BFu16ll_B");
    static C_BFu16ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu16ll_B)");
    check_field_offset(lv, v1, 0, "C_BFu16ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "C_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "C_BFu16ll_B");
    check_field_offset(lv, v3, 3, "C_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu16ll_B(Test_C_BFu16ll_B, "C_BFu16ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu16s_B  {
  char v1;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 C_BFu16s_B) C1{ Fc Fs:16 Fc}



static void Test_C_BFu16s_B()
{
  {
    init_simple_test("C_BFu16s_B");
    static C_BFu16s_B lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu16s_B)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu16s_B)");
    check_field_offset(lv, v1, 0, "C_BFu16s_B.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "C_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "C_BFu16s_B");
    check_field_offset(lv, v3, 4, "C_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu16s_B(Test_C_BFu16s_B, "C_BFu16s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu17i_B  {
  char v1;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 C_BFu17i_B) C1{ Fc Fi:17 Fc}



static void Test_C_BFu17i_B()
{
  {
    init_simple_test("C_BFu17i_B");
    static C_BFu17i_B lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu17i_B)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu17i_B)");
    check_field_offset(lv, v1, 0, "C_BFu17i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17i_B");
    check_field_offset(lv, v3, 4, "C_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu17i_B(Test_C_BFu17i_B, "C_BFu17i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu17ll_B  {
  char v1;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 C_BFu17ll_B) C1{ Fc FL:17 Fc}



static void Test_C_BFu17ll_B()
{
  {
    init_simple_test("C_BFu17ll_B");
    static C_BFu17ll_B lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu17ll_B)");
    check_field_offset(lv, v1, 0, "C_BFu17ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "C_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "C_BFu17ll_B");
    check_field_offset(lv, v3, 4, "C_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu17ll_B(Test_C_BFu17ll_B, "C_BFu17ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu1c_B  {
  char v1;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 C_BFu1c_B) C1{ Fc Fc:1 Fc}



static void Test_C_BFu1c_B()
{
  {
    init_simple_test("C_BFu1c_B");
    static C_BFu1c_B lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu1c_B)");
    check_field_offset(lv, v1, 0, "C_BFu1c_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1c_B");
    check_field_offset(lv, v3, 2, "C_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu1c_B(Test_C_BFu1c_B, "C_BFu1c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu1i_B  {
  char v1;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 C_BFu1i_B) C1{ Fc Fi:1 Fc}



static void Test_C_BFu1i_B()
{
  {
    init_simple_test("C_BFu1i_B");
    static C_BFu1i_B lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1i_B)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu1i_B)");
    check_field_offset(lv, v1, 0, "C_BFu1i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1i_B");
    check_field_offset(lv, v3, 2, "C_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu1i_B(Test_C_BFu1i_B, "C_BFu1i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu1ll_B  {
  char v1;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 C_BFu1ll_B) C1{ Fc FL:1 Fc}



static void Test_C_BFu1ll_B()
{
  {
    init_simple_test("C_BFu1ll_B");
    static C_BFu1ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu1ll_B)");
    check_field_offset(lv, v1, 0, "C_BFu1ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1ll_B");
    check_field_offset(lv, v3, 2, "C_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu1ll_B(Test_C_BFu1ll_B, "C_BFu1ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu1s_B  {
  char v1;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 C_BFu1s_B) C1{ Fc Fs:1 Fc}



static void Test_C_BFu1s_B()
{
  {
    init_simple_test("C_BFu1s_B");
    static C_BFu1s_B lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu1s_B)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu1s_B)");
    check_field_offset(lv, v1, 0, "C_BFu1s_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "C_BFu1s_B");
    check_field_offset(lv, v3, 2, "C_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu1s_B(Test_C_BFu1s_B, "C_BFu1s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu31i_B  {
  char v1;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 C_BFu31i_B) C1{ Fc Fi:31 Fc}



static void Test_C_BFu31i_B()
{
  {
    init_simple_test("C_BFu31i_B");
    static C_BFu31i_B lv;
    check2(sizeof(lv), 12, "sizeof(C_BFu31i_B)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu31i_B)");
    check_field_offset(lv, v1, 0, "C_BFu31i_B.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "C_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "C_BFu31i_B");
    check_field_offset(lv, v3, 8, "C_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu31i_B(Test_C_BFu31i_B, "C_BFu31i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu31ll_B  {
  char v1;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 C_BFu31ll_B) C1{ Fc FL:31 Fc}



static void Test_C_BFu31ll_B()
{
  {
    init_simple_test("C_BFu31ll_B");
    static C_BFu31ll_B lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu31ll_B)");
    check_field_offset(lv, v1, 0, "C_BFu31ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "C_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "C_BFu31ll_B");
    check_field_offset(lv, v3, 5, "C_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu31ll_B(Test_C_BFu31ll_B, "C_BFu31ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu32i_B  {
  char v1;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 C_BFu32i_B) C1{ Fc Fi:32 Fc}



static void Test_C_BFu32i_B()
{
  {
    init_simple_test("C_BFu32i_B");
    static C_BFu32i_B lv;
    check2(sizeof(lv), 12, "sizeof(C_BFu32i_B)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu32i_B)");
    check_field_offset(lv, v1, 0, "C_BFu32i_B.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "C_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "C_BFu32i_B");
    check_field_offset(lv, v3, 8, "C_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu32i_B(Test_C_BFu32i_B, "C_BFu32i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu32ll_B  {
  char v1;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 C_BFu32ll_B) C1{ Fc FL:32 Fc}



static void Test_C_BFu32ll_B()
{
  {
    init_simple_test("C_BFu32ll_B");
    static C_BFu32ll_B lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu32ll_B)");
    check_field_offset(lv, v1, 0, "C_BFu32ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "C_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "C_BFu32ll_B");
    check_field_offset(lv, v3, 5, "C_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu32ll_B(Test_C_BFu32ll_B, "C_BFu32ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu33_B  {
  char v1;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 C_BFu33_B) C1{ Fc FL:33 Fc}



static void Test_C_BFu33_B()
{
  {
    init_simple_test("C_BFu33_B");
    static C_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(C_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu33_B)");
    check_field_offset(lv, v1, 0, "C_BFu33_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "C_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "C_BFu33_B");
    check_field_offset(lv, v3, 6, "C_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu33_B(Test_C_BFu33_B, "C_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu7c_B  {
  char v1;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 C_BFu7c_B) C1{ Fc Fc:7 Fc}



static void Test_C_BFu7c_B()
{
  {
    init_simple_test("C_BFu7c_B");
    static C_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu7c_B)");
    check_field_offset(lv, v1, 0, "C_BFu7c_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7c_B");
    check_field_offset(lv, v3, 2, "C_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu7c_B(Test_C_BFu7c_B, "C_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu7i_B  {
  char v1;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 C_BFu7i_B) C1{ Fc Fi:7 Fc}



static void Test_C_BFu7i_B()
{
  {
    init_simple_test("C_BFu7i_B");
    static C_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7i_B)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu7i_B)");
    check_field_offset(lv, v1, 0, "C_BFu7i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7i_B");
    check_field_offset(lv, v3, 2, "C_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu7i_B(Test_C_BFu7i_B, "C_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu7ll_B  {
  char v1;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 C_BFu7ll_B) C1{ Fc FL:7 Fc}



static void Test_C_BFu7ll_B()
{
  {
    init_simple_test("C_BFu7ll_B");
    static C_BFu7ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu7ll_B)");
    check_field_offset(lv, v1, 0, "C_BFu7ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7ll_B");
    check_field_offset(lv, v3, 2, "C_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu7ll_B(Test_C_BFu7ll_B, "C_BFu7ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu7s_B  {
  char v1;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 C_BFu7s_B) C1{ Fc Fs:7 Fc}



static void Test_C_BFu7s_B()
{
  {
    init_simple_test("C_BFu7s_B");
    static C_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu7s_B)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu7s_B)");
    check_field_offset(lv, v1, 0, "C_BFu7s_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "C_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "C_BFu7s_B");
    check_field_offset(lv, v3, 2, "C_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu7s_B(Test_C_BFu7s_B, "C_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu8c_B  {
  char v1;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 C_BFu8c_B) C1{ Fc Fc:8 Fc}



static void Test_C_BFu8c_B()
{
  {
    init_simple_test("C_BFu8c_B");
    static C_BFu8c_B lv;
    check2(sizeof(lv), 3, "sizeof(C_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(C_BFu8c_B)");
    check_field_offset(lv, v1, 0, "C_BFu8c_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8c_B");
    check_field_offset(lv, v3, 2, "C_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu8c_B(Test_C_BFu8c_B, "C_BFu8c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu8i_B  {
  char v1;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 C_BFu8i_B) C1{ Fc Fi:8 Fc}



static void Test_C_BFu8i_B()
{
  {
    init_simple_test("C_BFu8i_B");
    static C_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8i_B)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu8i_B)");
    check_field_offset(lv, v1, 0, "C_BFu8i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8i_B");
    check_field_offset(lv, v3, 2, "C_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu8i_B(Test_C_BFu8i_B, "C_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu8ll_B  {
  char v1;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 C_BFu8ll_B) C1{ Fc FL:8 Fc}



static void Test_C_BFu8ll_B()
{
  {
    init_simple_test("C_BFu8ll_B");
    static C_BFu8ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu8ll_B)");
    check_field_offset(lv, v1, 0, "C_BFu8ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8ll_B");
    check_field_offset(lv, v3, 2, "C_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu8ll_B(Test_C_BFu8ll_B, "C_BFu8ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu8s_B  {
  char v1;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 C_BFu8s_B) C1{ Fc Fs:8 Fc}



static void Test_C_BFu8s_B()
{
  {
    init_simple_test("C_BFu8s_B");
    static C_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu8s_B)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu8s_B)");
    check_field_offset(lv, v1, 0, "C_BFu8s_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "C_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "C_BFu8s_B");
    check_field_offset(lv, v3, 2, "C_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu8s_B(Test_C_BFu8s_B, "C_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu9i_B  {
  char v1;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 C_BFu9i_B) C1{ Fc Fi:9 Fc}



static void Test_C_BFu9i_B()
{
  {
    init_simple_test("C_BFu9i_B");
    static C_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(C_BFu9i_B)");
    check2(__alignof__(lv), 4, "__alignof__(C_BFu9i_B)");
    check_field_offset(lv, v1, 0, "C_BFu9i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9i_B");
    check_field_offset(lv, v3, 3, "C_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu9i_B(Test_C_BFu9i_B, "C_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu9ll_B  {
  char v1;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 C_BFu9ll_B) C1{ Fc FL:9 Fc}



static void Test_C_BFu9ll_B()
{
  {
    init_simple_test("C_BFu9ll_B");
    static C_BFu9ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(C_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_BFu9ll_B)");
    check_field_offset(lv, v1, 0, "C_BFu9ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "C_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "C_BFu9ll_B");
    check_field_offset(lv, v3, 3, "C_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu9ll_B(Test_C_BFu9ll_B, "C_BFu9ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_BFu9s_B  {
  char v1;
  unsigned short v2:9;
  bool v3;
};
//SIG(1 C_BFu9s_B) C1{ Fc Fs:9 Fc}



static void Test_C_BFu9s_B()
{
  {
    init_simple_test("C_BFu9s_B");
    static C_BFu9s_B lv;
    check2(sizeof(lv), 6, "sizeof(C_BFu9s_B)");
    check2(__alignof__(lv), 2, "__alignof__(C_BFu9s_B)");
    check_field_offset(lv, v1, 0, "C_BFu9s_B.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "C_BFu9s_B");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "C_BFu9s_B");
    check_field_offset(lv, v3, 4, "C_BFu9s_B.v3");
  }
}
static Arrange_To_Call_Me vC_BFu9s_B(Test_C_BFu9s_B, "C_BFu9s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_C_B  {
  char v1;
  char v2;
  bool v3;
};
//SIG(1 C_C_B) C1{ Fc[3]}



static void Test_C_C_B()
{
  {
    init_simple_test("C_C_B");
    C_C_B lv;
    check2(sizeof(lv), 3, "sizeof(C_C_B)");
    check2(__alignof__(lv), 1, "__alignof__(C_C_B)");
    check_field_offset(lv, v1, 0, "C_C_B.v1");
    check_field_offset(lv, v2, 1, "C_C_B.v2");
    check_field_offset(lv, v3, 2, "C_C_B.v3");
  }
}
static Arrange_To_Call_Me vC_C_B(Test_C_C_B, "C_C_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_D_B  {
  char v1;
  double v2;
  bool v3;
};
//SIG(1 C_D_B) C1{ Fc FL Fc}



static void Test_C_D_B()
{
  {
    init_simple_test("C_D_B");
    C_D_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_D_B)");
    check_field_offset(lv, v1, 0, "C_D_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_D_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_D_B.v3");
  }
}
static Arrange_To_Call_Me vC_D_B(Test_C_D_B, "C_D_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_F_B  {
  char v1;
  float v2;
  bool v3;
};
//SIG(1 C_F_B) C1{ Fc Fi Fc}



static void Test_C_F_B()
{
  {
    init_simple_test("C_F_B");
    C_F_B lv;
    check2(sizeof(lv), 12, "sizeof(C_F_B)");
    check2(__alignof__(lv), 4, "__alignof__(C_F_B)");
    check_field_offset(lv, v1, 0, "C_F_B.v1");
    check_field_offset(lv, v2, 4, "C_F_B.v2");
    check_field_offset(lv, v3, 8, "C_F_B.v3");
  }
}
static Arrange_To_Call_Me vC_F_B(Test_C_F_B, "C_F_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_I_B  {
  char v1;
  int v2;
  bool v3;
};
//SIG(1 C_I_B) C1{ Fc Fi Fc}



static void Test_C_I_B()
{
  {
    init_simple_test("C_I_B");
    C_I_B lv;
    check2(sizeof(lv), 12, "sizeof(C_I_B)");
    check2(__alignof__(lv), 4, "__alignof__(C_I_B)");
    check_field_offset(lv, v1, 0, "C_I_B.v1");
    check_field_offset(lv, v2, 4, "C_I_B.v2");
    check_field_offset(lv, v3, 8, "C_I_B.v3");
  }
}
static Arrange_To_Call_Me vC_I_B(Test_C_I_B, "C_I_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_Ip_B  {
  char v1;
  int *v2;
  bool v3;
};
//SIG(1 C_Ip_B) C1{ Fc Fp Fc}



static void Test_C_Ip_B()
{
  {
    init_simple_test("C_Ip_B");
    C_Ip_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Ip_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ip_B)");
    check_field_offset(lv, v1, 0, "C_Ip_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ip_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Ip_B.v3");
  }
}
static Arrange_To_Call_Me vC_Ip_B(Test_C_Ip_B, "C_Ip_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_L_B  {
  char v1;
  __tsi64 v2;
  bool v3;
};
//SIG(1 C_L_B) C1{ Fc FL Fc}



static void Test_C_L_B()
{
  {
    init_simple_test("C_L_B");
    C_L_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_L_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_L_B)");
    check_field_offset(lv, v1, 0, "C_L_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_L_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_L_B.v3");
  }
}
static Arrange_To_Call_Me vC_L_B(Test_C_L_B, "C_L_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_S_B  {
  char v1;
  short v2;
  bool v3;
};
//SIG(1 C_S_B) C1{ Fc Fs Fc}



static void Test_C_S_B()
{
  {
    init_simple_test("C_S_B");
    C_S_B lv;
    check2(sizeof(lv), 6, "sizeof(C_S_B)");
    check2(__alignof__(lv), 2, "__alignof__(C_S_B)");
    check_field_offset(lv, v1, 0, "C_S_B.v1");
    check_field_offset(lv, v2, 2, "C_S_B.v2");
    check_field_offset(lv, v3, 4, "C_S_B.v3");
  }
}
static Arrange_To_Call_Me vC_S_B(Test_C_S_B, "C_S_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_Uc_B  {
  char v1;
  unsigned char v2;
  bool v3;
};
//SIG(1 C_Uc_B) C1{ Fc[3]}



static void Test_C_Uc_B()
{
  {
    init_simple_test("C_Uc_B");
    C_Uc_B lv;
    check2(sizeof(lv), 3, "sizeof(C_Uc_B)");
    check2(__alignof__(lv), 1, "__alignof__(C_Uc_B)");
    check_field_offset(lv, v1, 0, "C_Uc_B.v1");
    check_field_offset(lv, v2, 1, "C_Uc_B.v2");
    check_field_offset(lv, v3, 2, "C_Uc_B.v3");
  }
}
static Arrange_To_Call_Me vC_Uc_B(Test_C_Uc_B, "C_Uc_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_Ui_B  {
  char v1;
  unsigned int v2;
  bool v3;
};
//SIG(1 C_Ui_B) C1{ Fc Fi Fc}



static void Test_C_Ui_B()
{
  {
    init_simple_test("C_Ui_B");
    C_Ui_B lv;
    check2(sizeof(lv), 12, "sizeof(C_Ui_B)");
    check2(__alignof__(lv), 4, "__alignof__(C_Ui_B)");
    check_field_offset(lv, v1, 0, "C_Ui_B.v1");
    check_field_offset(lv, v2, 4, "C_Ui_B.v2");
    check_field_offset(lv, v3, 8, "C_Ui_B.v3");
  }
}
static Arrange_To_Call_Me vC_Ui_B(Test_C_Ui_B, "C_Ui_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_Ul_B  {
  char v1;
  __tsu64 v2;
  bool v3;
};
//SIG(1 C_Ul_B) C1{ Fc FL Fc}



static void Test_C_Ul_B()
{
  {
    init_simple_test("C_Ul_B");
    C_Ul_B lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(C_Ul_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Ul_B)");
    check_field_offset(lv, v1, 0, "C_Ul_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Ul_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "C_Ul_B.v3");
  }
}
static Arrange_To_Call_Me vC_Ul_B(Test_C_Ul_B, "C_Ul_B", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_Us_B  {
  char v1;
  unsigned short v2;
  bool v3;
};
//SIG(1 C_Us_B) C1{ Fc Fs Fc}



static void Test_C_Us_B()
{
  {
    init_simple_test("C_Us_B");
    C_Us_B lv;
    check2(sizeof(lv), 6, "sizeof(C_Us_B)");
    check2(__alignof__(lv), 2, "__alignof__(C_Us_B)");
    check_field_offset(lv, v1, 0, "C_Us_B.v1");
    check_field_offset(lv, v2, 2, "C_Us_B.v2");
    check_field_offset(lv, v3, 4, "C_Us_B.v3");
  }
}
static Arrange_To_Call_Me vC_Us_B(Test_C_Us_B, "C_Us_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  C_Vp_B  {
  char v1;
  void *v2;
  bool v3;
};
//SIG(1 C_Vp_B) C1{ Fc Fp Fc}



static void Test_C_Vp_B()
{
  {
    init_simple_test("C_Vp_B");
    C_Vp_B lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(C_Vp_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(C_Vp_B)");
    check_field_offset(lv, v1, 0, "C_Vp_B.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "C_Vp_B.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "C_Vp_B.v3");
  }
}
static Arrange_To_Call_Me vC_Vp_B(Test_C_Vp_B, "C_Vp_B", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B  {
  double v1;
  bool v2;
};
//SIG(1 D_B) C1{ FL Fc}



static void Test_D_B()
{
  {
    init_simple_test("D_B");
    D_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B)");
    check_field_offset(lv, v1, 0, "D_B.v1");
    check_field_offset(lv, v2, 8, "D_B.v2");
  }
}
static Arrange_To_Call_Me vD_B(Test_D_B, "D_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_B  {
  double v1;
  bool v2;
  bool v3;
};
//SIG(1 D_B_B) C1{ FL Fc[2]}



static void Test_D_B_B()
{
  {
    init_simple_test("D_B_B");
    D_B_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_B)");
    check_field_offset(lv, v1, 0, "D_B_B.v1");
    check_field_offset(lv, v2, 8, "D_B_B.v2");
    check_field_offset(lv, v3, 9, "D_B_B.v3");
  }
}
static Arrange_To_Call_Me vD_B_B(Test_D_B_B, "D_B_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu15i  {
  double v1;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 D_B_BFu15i) C1{ FL Fc Fi:15}



static void Test_D_B_BFu15i()
{
  {
    init_simple_test("D_B_BFu15i");
    static D_B_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu15i)");
    check_field_offset(lv, v1, 0, "D_B_BFu15i.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "D_B_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "D_B_BFu15i");
  }
}
static Arrange_To_Call_Me vD_B_BFu15i(Test_D_B_BFu15i, "D_B_BFu15i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu15ll  {
  double v1;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 D_B_BFu15ll) C1{ FL Fc FL:15}



static void Test_D_B_BFu15ll()
{
  {
    init_simple_test("D_B_BFu15ll");
    static D_B_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu15ll)");
    check_field_offset(lv, v1, 0, "D_B_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "D_B_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "D_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vD_B_BFu15ll(Test_D_B_BFu15ll, "D_B_BFu15ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu15s  {
  double v1;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 D_B_BFu15s) C1{ FL Fc Fs:15}



static void Test_D_B_BFu15s()
{
  {
    init_simple_test("D_B_BFu15s");
    static D_B_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu15s)");
    check_field_offset(lv, v1, 0, "D_B_BFu15s.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "D_B_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "D_B_BFu15s");
  }
}
static Arrange_To_Call_Me vD_B_BFu15s(Test_D_B_BFu15s, "D_B_BFu15s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu16i  {
  double v1;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 D_B_BFu16i) C1{ FL Fc Fi:16}



static void Test_D_B_BFu16i()
{
  {
    init_simple_test("D_B_BFu16i");
    static D_B_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu16i)");
    check_field_offset(lv, v1, 0, "D_B_BFu16i.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "D_B_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "D_B_BFu16i");
  }
}
static Arrange_To_Call_Me vD_B_BFu16i(Test_D_B_BFu16i, "D_B_BFu16i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu16ll  {
  double v1;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 D_B_BFu16ll) C1{ FL Fc FL:16}



static void Test_D_B_BFu16ll()
{
  {
    init_simple_test("D_B_BFu16ll");
    static D_B_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu16ll)");
    check_field_offset(lv, v1, 0, "D_B_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "D_B_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "D_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vD_B_BFu16ll(Test_D_B_BFu16ll, "D_B_BFu16ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu16s  {
  double v1;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 D_B_BFu16s) C1{ FL Fc Fs:16}



static void Test_D_B_BFu16s()
{
  {
    init_simple_test("D_B_BFu16s");
    static D_B_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu16s)");
    check_field_offset(lv, v1, 0, "D_B_BFu16s.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "D_B_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "D_B_BFu16s");
  }
}
static Arrange_To_Call_Me vD_B_BFu16s(Test_D_B_BFu16s, "D_B_BFu16s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu17i  {
  double v1;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 D_B_BFu17i) C1{ FL Fc Fi:17}



static void Test_D_B_BFu17i()
{
  {
    init_simple_test("D_B_BFu17i");
    static D_B_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu17i)");
    check_field_offset(lv, v1, 0, "D_B_BFu17i.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "D_B_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "D_B_BFu17i");
  }
}
static Arrange_To_Call_Me vD_B_BFu17i(Test_D_B_BFu17i, "D_B_BFu17i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu17ll  {
  double v1;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 D_B_BFu17ll) C1{ FL Fc FL:17}



static void Test_D_B_BFu17ll()
{
  {
    init_simple_test("D_B_BFu17ll");
    static D_B_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu17ll)");
    check_field_offset(lv, v1, 0, "D_B_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "D_B_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "D_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vD_B_BFu17ll(Test_D_B_BFu17ll, "D_B_BFu17ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu1c  {
  double v1;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 D_B_BFu1c) C1{ FL Fc Fc:1}



static void Test_D_B_BFu1c()
{
  {
    init_simple_test("D_B_BFu1c");
    static D_B_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu1c)");
    check_field_offset(lv, v1, 0, "D_B_BFu1c.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "D_B_BFu1c");
  }
}
static Arrange_To_Call_Me vD_B_BFu1c(Test_D_B_BFu1c, "D_B_BFu1c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu1i  {
  double v1;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 D_B_BFu1i) C1{ FL Fc Fi:1}



static void Test_D_B_BFu1i()
{
  {
    init_simple_test("D_B_BFu1i");
    static D_B_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu1i)");
    check_field_offset(lv, v1, 0, "D_B_BFu1i.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "D_B_BFu1i");
  }
}
static Arrange_To_Call_Me vD_B_BFu1i(Test_D_B_BFu1i, "D_B_BFu1i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu1ll  {
  double v1;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 D_B_BFu1ll) C1{ FL Fc FL:1}



static void Test_D_B_BFu1ll()
{
  {
    init_simple_test("D_B_BFu1ll");
    static D_B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu1ll)");
    check_field_offset(lv, v1, 0, "D_B_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "D_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vD_B_BFu1ll(Test_D_B_BFu1ll, "D_B_BFu1ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu1s  {
  double v1;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 D_B_BFu1s) C1{ FL Fc Fs:1}



static void Test_D_B_BFu1s()
{
  {
    init_simple_test("D_B_BFu1s");
    static D_B_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu1s)");
    check_field_offset(lv, v1, 0, "D_B_BFu1s.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "D_B_BFu1s");
  }
}
static Arrange_To_Call_Me vD_B_BFu1s(Test_D_B_BFu1s, "D_B_BFu1s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu31i  {
  double v1;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 D_B_BFu31i) C1{ FL Fc Fi:31}



static void Test_D_B_BFu31i()
{
  {
    init_simple_test("D_B_BFu31i");
    static D_B_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(D_B_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu31i)");
    check_field_offset(lv, v1, 0, "D_B_BFu31i.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "D_B_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "D_B_BFu31i");
  }
}
static Arrange_To_Call_Me vD_B_BFu31i(Test_D_B_BFu31i, "D_B_BFu31i", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu31ll  {
  double v1;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 D_B_BFu31ll) C1{ FL Fc FL:31}



static void Test_D_B_BFu31ll()
{
  {
    init_simple_test("D_B_BFu31ll");
    static D_B_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(D_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu31ll)");
    check_field_offset(lv, v1, 0, "D_B_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "D_B_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "D_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vD_B_BFu31ll(Test_D_B_BFu31ll, "D_B_BFu31ll", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu32i  {
  double v1;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 D_B_BFu32i) C1{ FL Fc Fi:32}



static void Test_D_B_BFu32i()
{
  {
    init_simple_test("D_B_BFu32i");
    static D_B_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(D_B_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu32i)");
    check_field_offset(lv, v1, 0, "D_B_BFu32i.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "D_B_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "D_B_BFu32i");
  }
}
static Arrange_To_Call_Me vD_B_BFu32i(Test_D_B_BFu32i, "D_B_BFu32i", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu32ll  {
  double v1;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 D_B_BFu32ll) C1{ FL Fc FL:32}



static void Test_D_B_BFu32ll()
{
  {
    init_simple_test("D_B_BFu32ll");
    static D_B_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(D_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu32ll)");
    check_field_offset(lv, v1, 0, "D_B_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "D_B_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "D_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vD_B_BFu32ll(Test_D_B_BFu32ll, "D_B_BFu32ll", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu33  {
  double v1;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 D_B_BFu33) C1{ FL Fc FL:33}



static void Test_D_B_BFu33()
{
  {
    init_simple_test("D_B_BFu33");
    static D_B_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(D_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu33)");
    check_field_offset(lv, v1, 0, "D_B_BFu33.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "D_B_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "D_B_BFu33");
  }
}
static Arrange_To_Call_Me vD_B_BFu33(Test_D_B_BFu33, "D_B_BFu33", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu7c  {
  double v1;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 D_B_BFu7c) C1{ FL Fc Fc:7}



static void Test_D_B_BFu7c()
{
  {
    init_simple_test("D_B_BFu7c");
    static D_B_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu7c)");
    check_field_offset(lv, v1, 0, "D_B_BFu7c.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "D_B_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "D_B_BFu7c");
  }
}
static Arrange_To_Call_Me vD_B_BFu7c(Test_D_B_BFu7c, "D_B_BFu7c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu7i  {
  double v1;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 D_B_BFu7i) C1{ FL Fc Fi:7}



static void Test_D_B_BFu7i()
{
  {
    init_simple_test("D_B_BFu7i");
    static D_B_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu7i)");
    check_field_offset(lv, v1, 0, "D_B_BFu7i.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "D_B_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "D_B_BFu7i");
  }
}
static Arrange_To_Call_Me vD_B_BFu7i(Test_D_B_BFu7i, "D_B_BFu7i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu7ll  {
  double v1;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 D_B_BFu7ll) C1{ FL Fc FL:7}



static void Test_D_B_BFu7ll()
{
  {
    init_simple_test("D_B_BFu7ll");
    static D_B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu7ll)");
    check_field_offset(lv, v1, 0, "D_B_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "D_B_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "D_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vD_B_BFu7ll(Test_D_B_BFu7ll, "D_B_BFu7ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu7s  {
  double v1;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 D_B_BFu7s) C1{ FL Fc Fs:7}



static void Test_D_B_BFu7s()
{
  {
    init_simple_test("D_B_BFu7s");
    static D_B_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu7s)");
    check_field_offset(lv, v1, 0, "D_B_BFu7s.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "D_B_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "D_B_BFu7s");
  }
}
static Arrange_To_Call_Me vD_B_BFu7s(Test_D_B_BFu7s, "D_B_BFu7s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu8c  {
  double v1;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 D_B_BFu8c) C1{ FL Fc Fc:8}



static void Test_D_B_BFu8c()
{
  {
    init_simple_test("D_B_BFu8c");
    static D_B_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu8c)");
    check_field_offset(lv, v1, 0, "D_B_BFu8c.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "D_B_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "D_B_BFu8c");
  }
}
static Arrange_To_Call_Me vD_B_BFu8c(Test_D_B_BFu8c, "D_B_BFu8c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu8i  {
  double v1;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 D_B_BFu8i) C1{ FL Fc Fi:8}



static void Test_D_B_BFu8i()
{
  {
    init_simple_test("D_B_BFu8i");
    static D_B_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu8i)");
    check_field_offset(lv, v1, 0, "D_B_BFu8i.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "D_B_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "D_B_BFu8i");
  }
}
static Arrange_To_Call_Me vD_B_BFu8i(Test_D_B_BFu8i, "D_B_BFu8i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu8ll  {
  double v1;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 D_B_BFu8ll) C1{ FL Fc FL:8}



static void Test_D_B_BFu8ll()
{
  {
    init_simple_test("D_B_BFu8ll");
    static D_B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu8ll)");
    check_field_offset(lv, v1, 0, "D_B_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "D_B_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "D_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vD_B_BFu8ll(Test_D_B_BFu8ll, "D_B_BFu8ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu8s  {
  double v1;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 D_B_BFu8s) C1{ FL Fc Fs:8}



static void Test_D_B_BFu8s()
{
  {
    init_simple_test("D_B_BFu8s");
    static D_B_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu8s)");
    check_field_offset(lv, v1, 0, "D_B_BFu8s.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "D_B_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "D_B_BFu8s");
  }
}
static Arrange_To_Call_Me vD_B_BFu8s(Test_D_B_BFu8s, "D_B_BFu8s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu9i  {
  double v1;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 D_B_BFu9i) C1{ FL Fc Fi:9}



static void Test_D_B_BFu9i()
{
  {
    init_simple_test("D_B_BFu9i");
    static D_B_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu9i)");
    check_field_offset(lv, v1, 0, "D_B_BFu9i.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "D_B_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "D_B_BFu9i");
  }
}
static Arrange_To_Call_Me vD_B_BFu9i(Test_D_B_BFu9i, "D_B_BFu9i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu9ll  {
  double v1;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 D_B_BFu9ll) C1{ FL Fc FL:9}



static void Test_D_B_BFu9ll()
{
  {
    init_simple_test("D_B_BFu9ll");
    static D_B_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu9ll)");
    check_field_offset(lv, v1, 0, "D_B_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "D_B_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "D_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vD_B_BFu9ll(Test_D_B_BFu9ll, "D_B_BFu9ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_BFu9s  {
  double v1;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 D_B_BFu9s) C1{ FL Fc Fs:9}



static void Test_D_B_BFu9s()
{
  {
    init_simple_test("D_B_BFu9s");
    static D_B_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_BFu9s)");
    check_field_offset(lv, v1, 0, "D_B_BFu9s.v1");
    check_field_offset(lv, v2, 8, "D_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "D_B_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "D_B_BFu9s");
  }
}
static Arrange_To_Call_Me vD_B_BFu9s(Test_D_B_BFu9s, "D_B_BFu9s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_C  {
  double v1;
  bool v2;
  char v3;
};
//SIG(1 D_B_C) C1{ FL Fc[2]}



static void Test_D_B_C()
{
  {
    init_simple_test("D_B_C");
    D_B_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_C)");
    check_field_offset(lv, v1, 0, "D_B_C.v1");
    check_field_offset(lv, v2, 8, "D_B_C.v2");
    check_field_offset(lv, v3, 9, "D_B_C.v3");
  }
}
static Arrange_To_Call_Me vD_B_C(Test_D_B_C, "D_B_C", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_D  {
  double v1;
  bool v2;
  double v3;
};
//SIG(1 D_B_D) C1{ FL Fc FL}



static void Test_D_B_D()
{
  {
    init_simple_test("D_B_D");
    D_B_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_D)");
    check_field_offset(lv, v1, 0, "D_B_D.v1");
    check_field_offset(lv, v2, 8, "D_B_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_B_D.v3");
  }
}
static Arrange_To_Call_Me vD_B_D(Test_D_B_D, "D_B_D", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_F  {
  double v1;
  bool v2;
  float v3;
};
//SIG(1 D_B_F) C1{ FL Fc Fi}



static void Test_D_B_F()
{
  {
    init_simple_test("D_B_F");
    D_B_F lv;
    check2(sizeof(lv), 16, "sizeof(D_B_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_F)");
    check_field_offset(lv, v1, 0, "D_B_F.v1");
    check_field_offset(lv, v2, 8, "D_B_F.v2");
    check_field_offset(lv, v3, 12, "D_B_F.v3");
  }
}
static Arrange_To_Call_Me vD_B_F(Test_D_B_F, "D_B_F", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_I  {
  double v1;
  bool v2;
  int v3;
};
//SIG(1 D_B_I) C1{ FL Fc Fi}



static void Test_D_B_I()
{
  {
    init_simple_test("D_B_I");
    D_B_I lv;
    check2(sizeof(lv), 16, "sizeof(D_B_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_I)");
    check_field_offset(lv, v1, 0, "D_B_I.v1");
    check_field_offset(lv, v2, 8, "D_B_I.v2");
    check_field_offset(lv, v3, 12, "D_B_I.v3");
  }
}
static Arrange_To_Call_Me vD_B_I(Test_D_B_I, "D_B_I", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_Ip  {
  double v1;
  bool v2;
  int *v3;
};
//SIG(1 D_B_Ip) C1{ FL Fc Fp}



static void Test_D_B_Ip()
{
  {
    init_simple_test("D_B_Ip");
    D_B_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_Ip)");
    check_field_offset(lv, v1, 0, "D_B_Ip.v1");
    check_field_offset(lv, v2, 8, "D_B_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vD_B_Ip(Test_D_B_Ip, "D_B_Ip", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_L  {
  double v1;
  bool v2;
  __tsi64 v3;
};
//SIG(1 D_B_L) C1{ FL Fc FL}



static void Test_D_B_L()
{
  {
    init_simple_test("D_B_L");
    D_B_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_L)");
    check_field_offset(lv, v1, 0, "D_B_L.v1");
    check_field_offset(lv, v2, 8, "D_B_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_B_L.v3");
  }
}
static Arrange_To_Call_Me vD_B_L(Test_D_B_L, "D_B_L", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_S  {
  double v1;
  bool v2;
  short v3;
};
//SIG(1 D_B_S) C1{ FL Fc Fs}



static void Test_D_B_S()
{
  {
    init_simple_test("D_B_S");
    D_B_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_S)");
    check_field_offset(lv, v1, 0, "D_B_S.v1");
    check_field_offset(lv, v2, 8, "D_B_S.v2");
    check_field_offset(lv, v3, 10, "D_B_S.v3");
  }
}
static Arrange_To_Call_Me vD_B_S(Test_D_B_S, "D_B_S", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_Uc  {
  double v1;
  bool v2;
  unsigned char v3;
};
//SIG(1 D_B_Uc) C1{ FL Fc[2]}



static void Test_D_B_Uc()
{
  {
    init_simple_test("D_B_Uc");
    D_B_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_Uc)");
    check_field_offset(lv, v1, 0, "D_B_Uc.v1");
    check_field_offset(lv, v2, 8, "D_B_Uc.v2");
    check_field_offset(lv, v3, 9, "D_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vD_B_Uc(Test_D_B_Uc, "D_B_Uc", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_Ui  {
  double v1;
  bool v2;
  unsigned int v3;
};
//SIG(1 D_B_Ui) C1{ FL Fc Fi}



static void Test_D_B_Ui()
{
  {
    init_simple_test("D_B_Ui");
    D_B_Ui lv;
    check2(sizeof(lv), 16, "sizeof(D_B_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_Ui)");
    check_field_offset(lv, v1, 0, "D_B_Ui.v1");
    check_field_offset(lv, v2, 8, "D_B_Ui.v2");
    check_field_offset(lv, v3, 12, "D_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vD_B_Ui(Test_D_B_Ui, "D_B_Ui", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_Ul  {
  double v1;
  bool v2;
  __tsu64 v3;
};
//SIG(1 D_B_Ul) C1{ FL Fc FL}



static void Test_D_B_Ul()
{
  {
    init_simple_test("D_B_Ul");
    D_B_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(D_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_Ul)");
    check_field_offset(lv, v1, 0, "D_B_Ul.v1");
    check_field_offset(lv, v2, 8, "D_B_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vD_B_Ul(Test_D_B_Ul, "D_B_Ul", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_Us  {
  double v1;
  bool v2;
  unsigned short v3;
};
//SIG(1 D_B_Us) C1{ FL Fc Fs}



static void Test_D_B_Us()
{
  {
    init_simple_test("D_B_Us");
    D_B_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_B_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_Us)");
    check_field_offset(lv, v1, 0, "D_B_Us.v1");
    check_field_offset(lv, v2, 8, "D_B_Us.v2");
    check_field_offset(lv, v3, 10, "D_B_Us.v3");
  }
}
static Arrange_To_Call_Me vD_B_Us(Test_D_B_Us, "D_B_Us", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_B_Vp  {
  double v1;
  bool v2;
  void *v3;
};
//SIG(1 D_B_Vp) C1{ FL Fc Fp}



static void Test_D_B_Vp()
{
  {
    init_simple_test("D_B_Vp");
    D_B_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(D_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_B_Vp)");
    check_field_offset(lv, v1, 0, "D_B_Vp.v1");
    check_field_offset(lv, v2, 8, "D_B_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "D_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vD_B_Vp(Test_D_B_Vp, "D_B_Vp", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu15i_B  {
  double v1;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 D_BFu15i_B) C1{ FL Fi:15 Fc}



static void Test_D_BFu15i_B()
{
  {
    init_simple_test("D_BFu15i_B");
    static D_BFu15i_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15i_B)");
    check_field_offset(lv, v1, 0, "D_BFu15i_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15i_B");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15i_B");
    check_field_offset(lv, v3, 10, "D_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu15i_B(Test_D_BFu15i_B, "D_BFu15i_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu15ll_B  {
  double v1;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 D_BFu15ll_B) C1{ FL FL:15 Fc}



static void Test_D_BFu15ll_B()
{
  {
    init_simple_test("D_BFu15ll_B");
    static D_BFu15ll_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15ll_B)");
    check_field_offset(lv, v1, 0, "D_BFu15ll_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15ll_B");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15ll_B");
    check_field_offset(lv, v3, 10, "D_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu15ll_B(Test_D_BFu15ll_B, "D_BFu15ll_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu15s_B  {
  double v1;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 D_BFu15s_B) C1{ FL Fs:15 Fc}



static void Test_D_BFu15s_B()
{
  {
    init_simple_test("D_BFu15s_B");
    static D_BFu15s_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu15s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu15s_B)");
    check_field_offset(lv, v1, 0, "D_BFu15s_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "D_BFu15s_B");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "D_BFu15s_B");
    check_field_offset(lv, v3, 10, "D_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu15s_B(Test_D_BFu15s_B, "D_BFu15s_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu16i_B  {
  double v1;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 D_BFu16i_B) C1{ FL Fi:16 Fc}



static void Test_D_BFu16i_B()
{
  {
    init_simple_test("D_BFu16i_B");
    static D_BFu16i_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16i_B)");
    check_field_offset(lv, v1, 0, "D_BFu16i_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16i_B");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16i_B");
    check_field_offset(lv, v3, 10, "D_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu16i_B(Test_D_BFu16i_B, "D_BFu16i_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu16ll_B  {
  double v1;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 D_BFu16ll_B) C1{ FL FL:16 Fc}



static void Test_D_BFu16ll_B()
{
  {
    init_simple_test("D_BFu16ll_B");
    static D_BFu16ll_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16ll_B)");
    check_field_offset(lv, v1, 0, "D_BFu16ll_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16ll_B");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16ll_B");
    check_field_offset(lv, v3, 10, "D_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu16ll_B(Test_D_BFu16ll_B, "D_BFu16ll_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu16s_B  {
  double v1;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 D_BFu16s_B) C1{ FL Fs:16 Fc}



static void Test_D_BFu16s_B()
{
  {
    init_simple_test("D_BFu16s_B");
    static D_BFu16s_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu16s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu16s_B)");
    check_field_offset(lv, v1, 0, "D_BFu16s_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "D_BFu16s_B");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "D_BFu16s_B");
    check_field_offset(lv, v3, 10, "D_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu16s_B(Test_D_BFu16s_B, "D_BFu16s_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu17i_B  {
  double v1;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 D_BFu17i_B) C1{ FL Fi:17 Fc}



static void Test_D_BFu17i_B()
{
  {
    init_simple_test("D_BFu17i_B");
    static D_BFu17i_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17i_B)");
    check_field_offset(lv, v1, 0, "D_BFu17i_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17i_B");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17i_B");
    check_field_offset(lv, v3, 11, "D_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu17i_B(Test_D_BFu17i_B, "D_BFu17i_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu17ll_B  {
  double v1;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 D_BFu17ll_B) C1{ FL FL:17 Fc}



static void Test_D_BFu17ll_B()
{
  {
    init_simple_test("D_BFu17ll_B");
    static D_BFu17ll_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu17ll_B)");
    check_field_offset(lv, v1, 0, "D_BFu17ll_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "D_BFu17ll_B");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "D_BFu17ll_B");
    check_field_offset(lv, v3, 11, "D_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu17ll_B(Test_D_BFu17ll_B, "D_BFu17ll_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu1c_B  {
  double v1;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 D_BFu1c_B) C1{ FL Fc:1 Fc}



static void Test_D_BFu1c_B()
{
  {
    init_simple_test("D_BFu1c_B");
    static D_BFu1c_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1c_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1c_B)");
    check_field_offset(lv, v1, 0, "D_BFu1c_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1c_B");
    check_field_offset(lv, v3, 9, "D_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu1c_B(Test_D_BFu1c_B, "D_BFu1c_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu1i_B  {
  double v1;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 D_BFu1i_B) C1{ FL Fi:1 Fc}



static void Test_D_BFu1i_B()
{
  {
    init_simple_test("D_BFu1i_B");
    static D_BFu1i_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1i_B)");
    check_field_offset(lv, v1, 0, "D_BFu1i_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1i_B");
    check_field_offset(lv, v3, 9, "D_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu1i_B(Test_D_BFu1i_B, "D_BFu1i_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu1ll_B  {
  double v1;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 D_BFu1ll_B) C1{ FL FL:1 Fc}



static void Test_D_BFu1ll_B()
{
  {
    init_simple_test("D_BFu1ll_B");
    static D_BFu1ll_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1ll_B)");
    check_field_offset(lv, v1, 0, "D_BFu1ll_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1ll_B");
    check_field_offset(lv, v3, 9, "D_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu1ll_B(Test_D_BFu1ll_B, "D_BFu1ll_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu1s_B  {
  double v1;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 D_BFu1s_B) C1{ FL Fs:1 Fc}



static void Test_D_BFu1s_B()
{
  {
    init_simple_test("D_BFu1s_B");
    static D_BFu1s_B lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(D_BFu1s_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu1s_B)");
    check_field_offset(lv, v1, 0, "D_BFu1s_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "D_BFu1s_B");
    check_field_offset(lv, v3, 9, "D_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu1s_B(Test_D_BFu1s_B, "D_BFu1s_B", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu31i_B  {
  double v1;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 D_BFu31i_B) C1{ FL Fi:31 Fc}



static void Test_D_BFu31i_B()
{
  {
    init_simple_test("D_BFu31i_B");
    static D_BFu31i_B lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu31i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu31i_B)");
    check_field_offset(lv, v1, 0, "D_BFu31i_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "D_BFu31i_B");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "D_BFu31i_B");
    check_field_offset(lv, v3, 12, "D_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu31i_B(Test_D_BFu31i_B, "D_BFu31i_B", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu31ll_B  {
  double v1;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 D_BFu31ll_B) C1{ FL FL:31 Fc}



static void Test_D_BFu31ll_B()
{
  {
    init_simple_test("D_BFu31ll_B");
    static D_BFu31ll_B lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu31ll_B)");
    check_field_offset(lv, v1, 0, "D_BFu31ll_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "D_BFu31ll_B");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "D_BFu31ll_B");
    check_field_offset(lv, v3, 12, "D_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu31ll_B(Test_D_BFu31ll_B, "D_BFu31ll_B", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu32i_B  {
  double v1;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 D_BFu32i_B) C1{ FL Fi:32 Fc}



static void Test_D_BFu32i_B()
{
  {
    init_simple_test("D_BFu32i_B");
    static D_BFu32i_B lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu32i_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu32i_B)");
    check_field_offset(lv, v1, 0, "D_BFu32i_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "D_BFu32i_B");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "D_BFu32i_B");
    check_field_offset(lv, v3, 12, "D_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu32i_B(Test_D_BFu32i_B, "D_BFu32i_B", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu32ll_B  {
  double v1;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 D_BFu32ll_B) C1{ FL FL:32 Fc}



static void Test_D_BFu32ll_B()
{
  {
    init_simple_test("D_BFu32ll_B");
    static D_BFu32ll_B lv;
    check2(sizeof(lv), 16, "sizeof(D_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(D_BFu32ll_B)");
    check_field_offset(lv, v1, 0, "D_BFu32ll_B.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "D_BFu32ll_B");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "D_BFu32ll_B");
    check_field_offset(lv, v3, 12, "D_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vD_BFu32ll_B(Test_D_BFu32ll_B, "D_BFu32ll_B", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  D_BFu33_B  {
  double v1;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 D_BFu33_B) C1{ FL FL:33 Fc}



static void Test_D_BFu33_B()
{
  {
    init_simple_test("D_BFu33_B");
    static D_BFu33_B lv;
    check2(