// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  B  {
  bool v1;
};
//SIG(1 B) C1{ Fc}



static void Test_B()
{
  {
    init_simple_test("B");
    B lv;
    check2(sizeof(lv), 1, "sizeof(B)");
    check2(__alignof__(lv), 1, "__alignof__(B)");
    check_field_offset(lv, v1, 0, "B.v1");
  }
}
static Arrange_To_Call_Me vB(Test_B, "B", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B  {
  bool v1;
  bool v2;
};
//SIG(1 B_B) C1{ Fc[2]}



static void Test_B_B()
{
  {
    init_simple_test("B_B");
    B_B lv;
    check2(sizeof(lv), 2, "sizeof(B_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_B)");
    check_field_offset(lv, v1, 0, "B_B.v1");
    check_field_offset(lv, v2, 1, "B_B.v2");
  }
}
static Arrange_To_Call_Me vB_B(Test_B_B, "B_B", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_B  {
  bool v1;
  bool v2;
  bool v3;
};
//SIG(1 B_B_B) C1{ Fc[3]}



static void Test_B_B_B()
{
  {
    init_simple_test("B_B_B");
    B_B_B lv;
    check2(sizeof(lv), 3, "sizeof(B_B_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_B_B)");
    check_field_offset(lv, v1, 0, "B_B_B.v1");
    check_field_offset(lv, v2, 1, "B_B_B.v2");
    check_field_offset(lv, v3, 2, "B_B_B.v3");
  }
}
static Arrange_To_Call_Me vB_B_B(Test_B_B_B, "B_B_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu15i  {
  bool v1;
  bool v2;
  unsigned int v3:15;
};
//SIG(1 B_B_BFu15i) C1{ Fc[2] Fi:15}



static void Test_B_B_BFu15i()
{
  {
    init_simple_test("B_B_BFu15i");
    static B_B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_B_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_B_BFu15i)");
    check_field_offset(lv, v1, 0, "B_B_BFu15i.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_B_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_B_BFu15i");
  }
}
static Arrange_To_Call_Me vB_B_BFu15i(Test_B_B_BFu15i, "B_B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu15ll  {
  bool v1;
  bool v2;
  __tsu64 v3:15;
};
//SIG(1 B_B_BFu15ll) C1{ Fc[2] FL:15}



static void Test_B_B_BFu15ll()
{
  {
    init_simple_test("B_B_BFu15ll");
    static B_B_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_B_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_B_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_B_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_B_BFu15ll(Test_B_B_BFu15ll, "B_B_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu15s  {
  bool v1;
  bool v2;
  unsigned short v3:15;
};
//SIG(1 B_B_BFu15s) C1{ Fc[2] Fs:15}



static void Test_B_B_BFu15s()
{
  {
    init_simple_test("B_B_BFu15s");
    static B_B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_B_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(B_B_BFu15s)");
    check_field_offset(lv, v1, 0, "B_B_BFu15s.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_B_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_B_BFu15s");
  }
}
static Arrange_To_Call_Me vB_B_BFu15s(Test_B_B_BFu15s, "B_B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu16i  {
  bool v1;
  bool v2;
  unsigned int v3:16;
};
//SIG(1 B_B_BFu16i) C1{ Fc[2] Fi:16}



static void Test_B_B_BFu16i()
{
  {
    init_simple_test("B_B_BFu16i");
    static B_B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_B_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_B_BFu16i)");
    check_field_offset(lv, v1, 0, "B_B_BFu16i.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_B_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_B_BFu16i");
  }
}
static Arrange_To_Call_Me vB_B_BFu16i(Test_B_B_BFu16i, "B_B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu16ll  {
  bool v1;
  bool v2;
  __tsu64 v3:16;
};
//SIG(1 B_B_BFu16ll) C1{ Fc[2] FL:16}



static void Test_B_B_BFu16ll()
{
  {
    init_simple_test("B_B_BFu16ll");
    static B_B_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_B_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_B_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_B_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_B_BFu16ll(Test_B_B_BFu16ll, "B_B_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu16s  {
  bool v1;
  bool v2;
  unsigned short v3:16;
};
//SIG(1 B_B_BFu16s) C1{ Fc[2] Fs:16}



static void Test_B_B_BFu16s()
{
  {
    init_simple_test("B_B_BFu16s");
    static B_B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_B_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(B_B_BFu16s)");
    check_field_offset(lv, v1, 0, "B_B_BFu16s.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_B_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_B_BFu16s");
  }
}
static Arrange_To_Call_Me vB_B_BFu16s(Test_B_B_BFu16s, "B_B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu17i  {
  bool v1;
  bool v2;
  unsigned int v3:17;
};
//SIG(1 B_B_BFu17i) C1{ Fc[2] Fi:17}



static void Test_B_B_BFu17i()
{
  {
    init_simple_test("B_B_BFu17i");
    static B_B_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_B_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_B_BFu17i)");
    check_field_offset(lv, v1, 0, "B_B_BFu17i.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_B_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_B_BFu17i");
  }
}
static Arrange_To_Call_Me vB_B_BFu17i(Test_B_B_BFu17i, "B_B_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu17ll  {
  bool v1;
  bool v2;
  __tsu64 v3:17;
};
//SIG(1 B_B_BFu17ll) C1{ Fc[2] FL:17}



static void Test_B_B_BFu17ll()
{
  {
    init_simple_test("B_B_BFu17ll");
    static B_B_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_B_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "B_B_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "B_B_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_B_BFu17ll(Test_B_B_BFu17ll, "B_B_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu1c  {
  bool v1;
  bool v2;
  unsigned char v3:1;
};
//SIG(1 B_B_BFu1c) C1{ Fc[2] Fc:1}



static void Test_B_B_BFu1c()
{
  {
    init_simple_test("B_B_BFu1c");
    static B_B_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(B_B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_B_BFu1c)");
    check_field_offset(lv, v1, 0, "B_B_BFu1c.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_B_BFu1c");
  }
}
static Arrange_To_Call_Me vB_B_BFu1c(Test_B_B_BFu1c, "B_B_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu1i  {
  bool v1;
  bool v2;
  unsigned int v3:1;
};
//SIG(1 B_B_BFu1i) C1{ Fc[2] Fi:1}



static void Test_B_B_BFu1i()
{
  {
    init_simple_test("B_B_BFu1i");
    static B_B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_B_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_B_BFu1i)");
    check_field_offset(lv, v1, 0, "B_B_BFu1i.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_B_BFu1i");
  }
}
static Arrange_To_Call_Me vB_B_BFu1i(Test_B_B_BFu1i, "B_B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu1ll  {
  bool v1;
  bool v2;
  __tsu64 v3:1;
};
//SIG(1 B_B_BFu1ll) C1{ Fc[2] FL:1}



static void Test_B_B_BFu1ll()
{
  {
    init_simple_test("B_B_BFu1ll");
    static B_B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_B_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_B_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_B_BFu1ll(Test_B_B_BFu1ll, "B_B_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu1s  {
  bool v1;
  bool v2;
  unsigned short v3:1;
};
//SIG(1 B_B_BFu1s) C1{ Fc[2] Fs:1}



static void Test_B_B_BFu1s()
{
  {
    init_simple_test("B_B_BFu1s");
    static B_B_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(B_B_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(B_B_BFu1s)");
    check_field_offset(lv, v1, 0, "B_B_BFu1s.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_B_BFu1s");
  }
}
static Arrange_To_Call_Me vB_B_BFu1s(Test_B_B_BFu1s, "B_B_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu31i  {
  bool v1;
  bool v2;
  unsigned int v3:31;
};
//SIG(1 B_B_BFu31i) C1{ Fc[2] Fi:31}



static void Test_B_B_BFu31i()
{
  {
    init_simple_test("B_B_BFu31i");
    static B_B_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_B_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_B_BFu31i)");
    check_field_offset(lv, v1, 0, "B_B_BFu31i.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_B_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_B_BFu31i");
  }
}
static Arrange_To_Call_Me vB_B_BFu31i(Test_B_B_BFu31i, "B_B_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu31ll  {
  bool v1;
  bool v2;
  __tsu64 v3:31;
};
//SIG(1 B_B_BFu31ll) C1{ Fc[2] FL:31}



static void Test_B_B_BFu31ll()
{
  {
    init_simple_test("B_B_BFu31ll");
    static B_B_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_B_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "B_B_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "B_B_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_B_BFu31ll(Test_B_B_BFu31ll, "B_B_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu32i  {
  bool v1;
  bool v2;
  unsigned int v3:32;
};
//SIG(1 B_B_BFu32i) C1{ Fc[2] Fi:32}



static void Test_B_B_BFu32i()
{
  {
    init_simple_test("B_B_BFu32i");
    static B_B_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_B_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_B_BFu32i)");
    check_field_offset(lv, v1, 0, "B_B_BFu32i.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_B_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_B_BFu32i");
  }
}
static Arrange_To_Call_Me vB_B_BFu32i(Test_B_B_BFu32i, "B_B_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu32ll  {
  bool v1;
  bool v2;
  __tsu64 v3:32;
};
//SIG(1 B_B_BFu32ll) C1{ Fc[2] FL:32}



static void Test_B_B_BFu32ll()
{
  {
    init_simple_test("B_B_BFu32ll");
    static B_B_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_B_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "B_B_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "B_B_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_B_BFu32ll(Test_B_B_BFu32ll, "B_B_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu33  {
  bool v1;
  bool v2;
  __tsu64 v3:33;
};
//SIG(1 B_B_BFu33) C1{ Fc[2] FL:33}



static void Test_B_B_BFu33()
{
  {
    init_simple_test("B_B_BFu33");
    static B_B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_BFu33)");
    check_field_offset(lv, v1, 0, "B_B_BFu33.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "B_B_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "B_B_BFu33");
  }
}
static Arrange_To_Call_Me vB_B_BFu33(Test_B_B_BFu33, "B_B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu7c  {
  bool v1;
  bool v2;
  unsigned char v3:7;
};
//SIG(1 B_B_BFu7c) C1{ Fc[2] Fc:7}



static void Test_B_B_BFu7c()
{
  {
    init_simple_test("B_B_BFu7c");
    static B_B_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(B_B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_B_BFu7c)");
    check_field_offset(lv, v1, 0, "B_B_BFu7c.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_B_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_B_BFu7c");
  }
}
static Arrange_To_Call_Me vB_B_BFu7c(Test_B_B_BFu7c, "B_B_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu7i  {
  bool v1;
  bool v2;
  unsigned int v3:7;
};
//SIG(1 B_B_BFu7i) C1{ Fc[2] Fi:7}



static void Test_B_B_BFu7i()
{
  {
    init_simple_test("B_B_BFu7i");
    static B_B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_B_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_B_BFu7i)");
    check_field_offset(lv, v1, 0, "B_B_BFu7i.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_B_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_B_BFu7i");
  }
}
static Arrange_To_Call_Me vB_B_BFu7i(Test_B_B_BFu7i, "B_B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu7ll  {
  bool v1;
  bool v2;
  __tsu64 v3:7;
};
//SIG(1 B_B_BFu7ll) C1{ Fc[2] FL:7}



static void Test_B_B_BFu7ll()
{
  {
    init_simple_test("B_B_BFu7ll");
    static B_B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_B_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_B_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_B_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_B_BFu7ll(Test_B_B_BFu7ll, "B_B_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu7s  {
  bool v1;
  bool v2;
  unsigned short v3:7;
};
//SIG(1 B_B_BFu7s) C1{ Fc[2] Fs:7}



static void Test_B_B_BFu7s()
{
  {
    init_simple_test("B_B_BFu7s");
    static B_B_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(B_B_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(B_B_BFu7s)");
    check_field_offset(lv, v1, 0, "B_B_BFu7s.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_B_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_B_BFu7s");
  }
}
static Arrange_To_Call_Me vB_B_BFu7s(Test_B_B_BFu7s, "B_B_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu8c  {
  bool v1;
  bool v2;
  unsigned char v3:8;
};
//SIG(1 B_B_BFu8c) C1{ Fc[2] Fc:8}



static void Test_B_B_BFu8c()
{
  {
    init_simple_test("B_B_BFu8c");
    static B_B_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(B_B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_B_BFu8c)");
    check_field_offset(lv, v1, 0, "B_B_BFu8c.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_B_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_B_BFu8c");
  }
}
static Arrange_To_Call_Me vB_B_BFu8c(Test_B_B_BFu8c, "B_B_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu8i  {
  bool v1;
  bool v2;
  unsigned int v3:8;
};
//SIG(1 B_B_BFu8i) C1{ Fc[2] Fi:8}



static void Test_B_B_BFu8i()
{
  {
    init_simple_test("B_B_BFu8i");
    static B_B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_B_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_B_BFu8i)");
    check_field_offset(lv, v1, 0, "B_B_BFu8i.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_B_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_B_BFu8i");
  }
}
static Arrange_To_Call_Me vB_B_BFu8i(Test_B_B_BFu8i, "B_B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu8ll  {
  bool v1;
  bool v2;
  __tsu64 v3:8;
};
//SIG(1 B_B_BFu8ll) C1{ Fc[2] FL:8}



static void Test_B_B_BFu8ll()
{
  {
    init_simple_test("B_B_BFu8ll");
    static B_B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_B_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_B_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_B_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_B_BFu8ll(Test_B_B_BFu8ll, "B_B_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu8s  {
  bool v1;
  bool v2;
  unsigned short v3:8;
};
//SIG(1 B_B_BFu8s) C1{ Fc[2] Fs:8}



static void Test_B_B_BFu8s()
{
  {
    init_simple_test("B_B_BFu8s");
    static B_B_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_B_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(B_B_BFu8s)");
    check_field_offset(lv, v1, 0, "B_B_BFu8s.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_B_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_B_BFu8s");
  }
}
static Arrange_To_Call_Me vB_B_BFu8s(Test_B_B_BFu8s, "B_B_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu9i  {
  bool v1;
  bool v2;
  unsigned int v3:9;
};
//SIG(1 B_B_BFu9i) C1{ Fc[2] Fi:9}



static void Test_B_B_BFu9i()
{
  {
    init_simple_test("B_B_BFu9i");
    static B_B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_B_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_B_BFu9i)");
    check_field_offset(lv, v1, 0, "B_B_BFu9i.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_B_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_B_BFu9i");
  }
}
static Arrange_To_Call_Me vB_B_BFu9i(Test_B_B_BFu9i, "B_B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu9ll  {
  bool v1;
  bool v2;
  __tsu64 v3:9;
};
//SIG(1 B_B_BFu9ll) C1{ Fc[2] FL:9}



static void Test_B_B_BFu9ll()
{
  {
    init_simple_test("B_B_BFu9ll");
    static B_B_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_B_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_B_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_B_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_B_BFu9ll(Test_B_B_BFu9ll, "B_B_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_BFu9s  {
  bool v1;
  bool v2;
  unsigned short v3:9;
};
//SIG(1 B_B_BFu9s) C1{ Fc[2] Fs:9}



static void Test_B_B_BFu9s()
{
  {
    init_simple_test("B_B_BFu9s");
    static B_B_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_B_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(B_B_BFu9s)");
    check_field_offset(lv, v1, 0, "B_B_BFu9s.v1");
    check_field_offset(lv, v2, 1, "B_B_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_B_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_B_BFu9s");
  }
}
static Arrange_To_Call_Me vB_B_BFu9s(Test_B_B_BFu9s, "B_B_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_C  {
  bool v1;
  bool v2;
  char v3;
};
//SIG(1 B_B_C) C1{ Fc[3]}



static void Test_B_B_C()
{
  {
    init_simple_test("B_B_C");
    B_B_C lv;
    check2(sizeof(lv), 3, "sizeof(B_B_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_B_C)");
    check_field_offset(lv, v1, 0, "B_B_C.v1");
    check_field_offset(lv, v2, 1, "B_B_C.v2");
    check_field_offset(lv, v3, 2, "B_B_C.v3");
  }
}
static Arrange_To_Call_Me vB_B_C(Test_B_B_C, "B_B_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_D  {
  bool v1;
  bool v2;
  double v3;
};
//SIG(1 B_B_D) C1{ Fc[2] FL}



static void Test_B_B_D()
{
  {
    init_simple_test("B_B_D");
    B_B_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_B_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_D)");
    check_field_offset(lv, v1, 0, "B_B_D.v1");
    check_field_offset(lv, v2, 1, "B_B_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_B_D.v3");
  }
}
static Arrange_To_Call_Me vB_B_D(Test_B_B_D, "B_B_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_F  {
  bool v1;
  bool v2;
  float v3;
};
//SIG(1 B_B_F) C1{ Fc[2] Fi}



static void Test_B_B_F()
{
  {
    init_simple_test("B_B_F");
    B_B_F lv;
    check2(sizeof(lv), 8, "sizeof(B_B_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_B_F)");
    check_field_offset(lv, v1, 0, "B_B_F.v1");
    check_field_offset(lv, v2, 1, "B_B_F.v2");
    check_field_offset(lv, v3, 4, "B_B_F.v3");
  }
}
static Arrange_To_Call_Me vB_B_F(Test_B_B_F, "B_B_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_I  {
  bool v1;
  bool v2;
  int v3;
};
//SIG(1 B_B_I) C1{ Fc[2] Fi}



static void Test_B_B_I()
{
  {
    init_simple_test("B_B_I");
    B_B_I lv;
    check2(sizeof(lv), 8, "sizeof(B_B_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_B_I)");
    check_field_offset(lv, v1, 0, "B_B_I.v1");
    check_field_offset(lv, v2, 1, "B_B_I.v2");
    check_field_offset(lv, v3, 4, "B_B_I.v3");
  }
}
static Arrange_To_Call_Me vB_B_I(Test_B_B_I, "B_B_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_Ip  {
  bool v1;
  bool v2;
  int *v3;
};
//SIG(1 B_B_Ip) C1{ Fc[2] Fp}



static void Test_B_B_Ip()
{
  {
    init_simple_test("B_B_Ip");
    B_B_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_B_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_Ip)");
    check_field_offset(lv, v1, 0, "B_B_Ip.v1");
    check_field_offset(lv, v2, 1, "B_B_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_B_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_B_Ip(Test_B_B_Ip, "B_B_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_L  {
  bool v1;
  bool v2;
  __tsi64 v3;
};
//SIG(1 B_B_L) C1{ Fc[2] FL}



static void Test_B_B_L()
{
  {
    init_simple_test("B_B_L");
    B_B_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_B_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_L)");
    check_field_offset(lv, v1, 0, "B_B_L.v1");
    check_field_offset(lv, v2, 1, "B_B_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_B_L.v3");
  }
}
static Arrange_To_Call_Me vB_B_L(Test_B_B_L, "B_B_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_S  {
  bool v1;
  bool v2;
  short v3;
};
//SIG(1 B_B_S) C1{ Fc[2] Fs}



static void Test_B_B_S()
{
  {
    init_simple_test("B_B_S");
    B_B_S lv;
    check2(sizeof(lv), 4, "sizeof(B_B_S)");
    check2(__alignof__(lv), 2, "__alignof__(B_B_S)");
    check_field_offset(lv, v1, 0, "B_B_S.v1");
    check_field_offset(lv, v2, 1, "B_B_S.v2");
    check_field_offset(lv, v3, 2, "B_B_S.v3");
  }
}
static Arrange_To_Call_Me vB_B_S(Test_B_B_S, "B_B_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_Uc  {
  bool v1;
  bool v2;
  unsigned char v3;
};
//SIG(1 B_B_Uc) C1{ Fc[3]}



static void Test_B_B_Uc()
{
  {
    init_simple_test("B_B_Uc");
    B_B_Uc lv;
    check2(sizeof(lv), 3, "sizeof(B_B_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_B_Uc)");
    check_field_offset(lv, v1, 0, "B_B_Uc.v1");
    check_field_offset(lv, v2, 1, "B_B_Uc.v2");
    check_field_offset(lv, v3, 2, "B_B_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_B_Uc(Test_B_B_Uc, "B_B_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_Ui  {
  bool v1;
  bool v2;
  unsigned int v3;
};
//SIG(1 B_B_Ui) C1{ Fc[2] Fi}



static void Test_B_B_Ui()
{
  {
    init_simple_test("B_B_Ui");
    B_B_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_B_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_B_Ui)");
    check_field_offset(lv, v1, 0, "B_B_Ui.v1");
    check_field_offset(lv, v2, 1, "B_B_Ui.v2");
    check_field_offset(lv, v3, 4, "B_B_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_B_Ui(Test_B_B_Ui, "B_B_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_Ul  {
  bool v1;
  bool v2;
  __tsu64 v3;
};
//SIG(1 B_B_Ul) C1{ Fc[2] FL}



static void Test_B_B_Ul()
{
  {
    init_simple_test("B_B_Ul");
    B_B_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_B_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_Ul)");
    check_field_offset(lv, v1, 0, "B_B_Ul.v1");
    check_field_offset(lv, v2, 1, "B_B_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_B_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_B_Ul(Test_B_B_Ul, "B_B_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_Us  {
  bool v1;
  bool v2;
  unsigned short v3;
};
//SIG(1 B_B_Us) C1{ Fc[2] Fs}



static void Test_B_B_Us()
{
  {
    init_simple_test("B_B_Us");
    B_B_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_B_Us)");
    check2(__alignof__(lv), 2, "__alignof__(B_B_Us)");
    check_field_offset(lv, v1, 0, "B_B_Us.v1");
    check_field_offset(lv, v2, 1, "B_B_Us.v2");
    check_field_offset(lv, v3, 2, "B_B_Us.v3");
  }
}
static Arrange_To_Call_Me vB_B_Us(Test_B_B_Us, "B_B_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_B_Vp  {
  bool v1;
  bool v2;
  void *v3;
};
//SIG(1 B_B_Vp) C1{ Fc[2] Fp}



static void Test_B_B_Vp()
{
  {
    init_simple_test("B_B_Vp");
    B_B_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_B_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_B_Vp)");
    check_field_offset(lv, v1, 0, "B_B_Vp.v1");
    check_field_offset(lv, v2, 1, "B_B_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_B_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_B_Vp(Test_B_B_Vp, "B_B_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i  {
  bool v1;
  unsigned int v2:15;
};
//SIG(1 B_BFu15i) C1{ Fc Fi:15}



static void Test_B_BFu15i()
{
  {
    init_simple_test("B_BFu15i");
    static B_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu15i(Test_B_BFu15i, "B_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_B  {
  bool v1;
  unsigned int v2:15;
  bool v3;
};
//SIG(1 B_BFu15i_B) C1{ Fc Fi:15 Fc}



static void Test_B_BFu15i_B()
{
  {
    init_simple_test("B_BFu15i_B");
    static B_BFu15i_B lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i_B)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_B)");
    check_field_offset(lv, v1, 0, "B_BFu15i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_B");
    check_field_offset(lv, v3, 3, "B_BFu15i_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15i_B(Test_B_BFu15i_B, "B_BFu15i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu15i  {
  bool v1;
  unsigned int v2:15;
  unsigned int v3:15;
};
//SIG(1 B_BFu15i_BFu15i) C1{ Fc Fi:15 Fi:15}



static void Test_B_BFu15i_BFu15i()
{
  {
    init_simple_test("B_BFu15i_BFu15i");
    static B_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu15i(Test_B_BFu15i_BFu15i, "B_BFu15i_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu15ll  {
  bool v1;
  unsigned int v2:15;
  __tsu64 v3:15;
};
//SIG(1 B_BFu15i_BFu15ll) C1{ Fc Fi:15 FL:15}



static void Test_B_BFu15i_BFu15ll()
{
  {
    init_simple_test("B_BFu15i_BFu15ll");
    static B_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "B_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "B_BFu15i_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu15ll(Test_B_BFu15i_BFu15ll, "B_BFu15i_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu15s  {
  bool v1;
  unsigned int v2:15;
  unsigned short v3:15;
};
//SIG(1 B_BFu15i_BFu15s) C1{ Fc Fi:15 Fs:15}



static void Test_B_BFu15i_BFu15s()
{
  {
    init_simple_test("B_BFu15i_BFu15s");
    static B_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu15s(Test_B_BFu15i_BFu15s, "B_BFu15i_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu16i  {
  bool v1;
  unsigned int v2:15;
  unsigned int v3:16;
};
//SIG(1 B_BFu15i_BFu16i) C1{ Fc Fi:15 Fi:16}



static void Test_B_BFu15i_BFu16i()
{
  {
    init_simple_test("B_BFu15i_BFu16i");
    static B_BFu15i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu15i_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu16i(Test_B_BFu15i_BFu16i, "B_BFu15i_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu16ll  {
  bool v1;
  unsigned int v2:15;
  __tsu64 v3:16;
};
//SIG(1 B_BFu15i_BFu16ll) C1{ Fc Fi:15 FL:16}



static void Test_B_BFu15i_BFu16ll()
{
  {
    init_simple_test("B_BFu15i_BFu16ll");
    static B_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "B_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "B_BFu15i_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu16ll(Test_B_BFu15i_BFu16ll, "B_BFu15i_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu16s  {
  bool v1;
  unsigned int v2:15;
  unsigned short v3:16;
};
//SIG(1 B_BFu15i_BFu16s) C1{ Fc Fi:15 Fs:16}



static void Test_B_BFu15i_BFu16s()
{
  {
    init_simple_test("B_BFu15i_BFu16s");
    static B_BFu15i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu15i_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu16s(Test_B_BFu15i_BFu16s, "B_BFu15i_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu17i  {
  bool v1;
  unsigned int v2:15;
  unsigned int v3:17;
};
//SIG(1 B_BFu15i_BFu17i) C1{ Fc Fi:15 Fi:17}



static void Test_B_BFu15i_BFu17i()
{
  {
    init_simple_test("B_BFu15i_BFu17i");
    static B_BFu15i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu15i_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu17i(Test_B_BFu15i_BFu17i, "B_BFu15i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu17ll  {
  bool v1;
  unsigned int v2:15;
  __tsu64 v3:17;
};
//SIG(1 B_BFu15i_BFu17ll) C1{ Fc Fi:15 FL:17}



static void Test_B_BFu15i_BFu17ll()
{
  {
    init_simple_test("B_BFu15i_BFu17ll");
    static B_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "B_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "B_BFu15i_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu17ll(Test_B_BFu15i_BFu17ll, "B_BFu15i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu1c  {
  bool v1;
  unsigned int v2:15;
  unsigned char v3:1;
};
//SIG(1 B_BFu15i_BFu1c) C1{ Fc Fi:15 Fc:1}



static void Test_B_BFu15i_BFu1c()
{
  {
    init_simple_test("B_BFu15i_BFu1c");
    static B_BFu15i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "B_BFu15i_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu1c(Test_B_BFu15i_BFu1c, "B_BFu15i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu1i  {
  bool v1;
  unsigned int v2:15;
  unsigned int v3:1;
};
//SIG(1 B_BFu15i_BFu1i) C1{ Fc Fi:15 Fi:1}



static void Test_B_BFu15i_BFu1i()
{
  {
    init_simple_test("B_BFu15i_BFu1i");
    static B_BFu15i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "B_BFu15i_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu1i(Test_B_BFu15i_BFu1i, "B_BFu15i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu1ll  {
  bool v1;
  unsigned int v2:15;
  __tsu64 v3:1;
};
//SIG(1 B_BFu15i_BFu1ll) C1{ Fc Fi:15 FL:1}



static void Test_B_BFu15i_BFu1ll()
{
  {
    init_simple_test("B_BFu15i_BFu1ll");
    static B_BFu15i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "B_BFu15i_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu1ll(Test_B_BFu15i_BFu1ll, "B_BFu15i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu1s  {
  bool v1;
  unsigned int v2:15;
  unsigned short v3:1;
};
//SIG(1 B_BFu15i_BFu1s) C1{ Fc Fi:15 Fs:1}



static void Test_B_BFu15i_BFu1s()
{
  {
    init_simple_test("B_BFu15i_BFu1s");
    static B_BFu15i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "B_BFu15i_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu1s(Test_B_BFu15i_BFu1s, "B_BFu15i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu31i  {
  bool v1;
  unsigned int v2:15;
  unsigned int v3:31;
};
//SIG(1 B_BFu15i_BFu31i) C1{ Fc Fi:15 Fi:31}



static void Test_B_BFu15i_BFu31i()
{
  {
    init_simple_test("B_BFu15i_BFu31i");
    static B_BFu15i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu15i_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu31i(Test_B_BFu15i_BFu31i, "B_BFu15i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu31ll  {
  bool v1;
  unsigned int v2:15;
  __tsu64 v3:31;
};
//SIG(1 B_BFu15i_BFu31ll) C1{ Fc Fi:15 FL:31}



static void Test_B_BFu15i_BFu31ll()
{
  {
    init_simple_test("B_BFu15i_BFu31ll");
    static B_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "B_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "B_BFu15i_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu31ll(Test_B_BFu15i_BFu31ll, "B_BFu15i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu32i  {
  bool v1;
  unsigned int v2:15;
  unsigned int v3:32;
};
//SIG(1 B_BFu15i_BFu32i) C1{ Fc Fi:15 Fi:32}



static void Test_B_BFu15i_BFu32i()
{
  {
    init_simple_test("B_BFu15i_BFu32i");
    static B_BFu15i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu15i_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu32i(Test_B_BFu15i_BFu32i, "B_BFu15i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu32ll  {
  bool v1;
  unsigned int v2:15;
  __tsu64 v3:32;
};
//SIG(1 B_BFu15i_BFu32ll) C1{ Fc Fi:15 FL:32}



static void Test_B_BFu15i_BFu32ll()
{
  {
    init_simple_test("B_BFu15i_BFu32ll");
    static B_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "B_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "B_BFu15i_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu32ll(Test_B_BFu15i_BFu32ll, "B_BFu15i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu33  {
  bool v1;
  unsigned int v2:15;
  __tsu64 v3:33;
};
//SIG(1 B_BFu15i_BFu33) C1{ Fc Fi:15 FL:33}



static void Test_B_BFu15i_BFu33()
{
  {
    init_simple_test("B_BFu15i_BFu33");
    static B_BFu15i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "B_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "B_BFu15i_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu33(Test_B_BFu15i_BFu33, "B_BFu15i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu7c  {
  bool v1;
  unsigned int v2:15;
  unsigned char v3:7;
};
//SIG(1 B_BFu15i_BFu7c) C1{ Fc Fi:15 Fc:7}



static void Test_B_BFu15i_BFu7c()
{
  {
    init_simple_test("B_BFu15i_BFu7c");
    static B_BFu15i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_BFu15i_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu7c(Test_B_BFu15i_BFu7c, "B_BFu15i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu7i  {
  bool v1;
  unsigned int v2:15;
  unsigned int v3:7;
};
//SIG(1 B_BFu15i_BFu7i) C1{ Fc Fi:15 Fi:7}



static void Test_B_BFu15i_BFu7i()
{
  {
    init_simple_test("B_BFu15i_BFu7i");
    static B_BFu15i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "B_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "B_BFu15i_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu7i(Test_B_BFu15i_BFu7i, "B_BFu15i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu7ll  {
  bool v1;
  unsigned int v2:15;
  __tsu64 v3:7;
};
//SIG(1 B_BFu15i_BFu7ll) C1{ Fc Fi:15 FL:7}



static void Test_B_BFu15i_BFu7ll()
{
  {
    init_simple_test("B_BFu15i_BFu7ll");
    static B_BFu15i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "B_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "B_BFu15i_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu7ll(Test_B_BFu15i_BFu7ll, "B_BFu15i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu7s  {
  bool v1;
  unsigned int v2:15;
  unsigned short v3:7;
};
//SIG(1 B_BFu15i_BFu7s) C1{ Fc Fi:15 Fs:7}



static void Test_B_BFu15i_BFu7s()
{
  {
    init_simple_test("B_BFu15i_BFu7s");
    static B_BFu15i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "B_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "B_BFu15i_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu7s(Test_B_BFu15i_BFu7s, "B_BFu15i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu8c  {
  bool v1;
  unsigned int v2:15;
  unsigned char v3:8;
};
//SIG(1 B_BFu15i_BFu8c) C1{ Fc Fi:15 Fc:8}



static void Test_B_BFu15i_BFu8c()
{
  {
    init_simple_test("B_BFu15i_BFu8c");
    static B_BFu15i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_BFu15i_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu8c(Test_B_BFu15i_BFu8c, "B_BFu15i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu8i  {
  bool v1;
  unsigned int v2:15;
  unsigned int v3:8;
};
//SIG(1 B_BFu15i_BFu8i) C1{ Fc Fi:15 Fi:8}



static void Test_B_BFu15i_BFu8i()
{
  {
    init_simple_test("B_BFu15i_BFu8i");
    static B_BFu15i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "B_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "B_BFu15i_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu8i(Test_B_BFu15i_BFu8i, "B_BFu15i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu8ll  {
  bool v1;
  unsigned int v2:15;
  __tsu64 v3:8;
};
//SIG(1 B_BFu15i_BFu8ll) C1{ Fc Fi:15 FL:8}



static void Test_B_BFu15i_BFu8ll()
{
  {
    init_simple_test("B_BFu15i_BFu8ll");
    static B_BFu15i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "B_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "B_BFu15i_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu8ll(Test_B_BFu15i_BFu8ll, "B_BFu15i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu8s  {
  bool v1;
  unsigned int v2:15;
  unsigned short v3:8;
};
//SIG(1 B_BFu15i_BFu8s) C1{ Fc Fi:15 Fs:8}



static void Test_B_BFu15i_BFu8s()
{
  {
    init_simple_test("B_BFu15i_BFu8s");
    static B_BFu15i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "B_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "B_BFu15i_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu8s(Test_B_BFu15i_BFu8s, "B_BFu15i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu9i  {
  bool v1;
  unsigned int v2:15;
  unsigned int v3:9;
};
//SIG(1 B_BFu15i_BFu9i) C1{ Fc Fi:15 Fi:9}



static void Test_B_BFu15i_BFu9i()
{
  {
    init_simple_test("B_BFu15i_BFu9i");
    static B_BFu15i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "B_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "B_BFu15i_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu9i(Test_B_BFu15i_BFu9i, "B_BFu15i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu9ll  {
  bool v1;
  unsigned int v2:15;
  __tsu64 v3:9;
};
//SIG(1 B_BFu15i_BFu9ll) C1{ Fc Fi:15 FL:9}



static void Test_B_BFu15i_BFu9ll()
{
  {
    init_simple_test("B_BFu15i_BFu9ll");
    static B_BFu15i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "B_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "B_BFu15i_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu9ll(Test_B_BFu15i_BFu9ll, "B_BFu15i_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_BFu9s  {
  bool v1;
  unsigned int v2:15;
  unsigned short v3:9;
};
//SIG(1 B_BFu15i_BFu9s) C1{ Fc Fi:15 Fs:9}



static void Test_B_BFu15i_BFu9s()
{
  {
    init_simple_test("B_BFu15i_BFu9s");
    static B_BFu15i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "B_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "B_BFu15i_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu15i_BFu9s(Test_B_BFu15i_BFu9s, "B_BFu15i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_C  {
  bool v1;
  unsigned int v2:15;
  char v3;
};
//SIG(1 B_BFu15i_C) C1{ Fc Fi:15 Fc}



static void Test_B_BFu15i_C()
{
  {
    init_simple_test("B_BFu15i_C");
    static B_BFu15i_C lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i_C)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_C)");
    check_field_offset(lv, v1, 0, "B_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_C");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_C");
    check_field_offset(lv, v3, 3, "B_BFu15i_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15i_C(Test_B_BFu15i_C, "B_BFu15i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_D  {
  bool v1;
  unsigned int v2:15;
  double v3;
};
//SIG(1 B_BFu15i_D) C1{ Fc Fi:15 FL}



static void Test_B_BFu15i_D()
{
  {
    init_simple_test("B_BFu15i_D");
    static B_BFu15i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu15i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_D)");
    check_field_offset(lv, v1, 0, "B_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_D");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15i_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15i_D(Test_B_BFu15i_D, "B_BFu15i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_F  {
  bool v1;
  unsigned int v2:15;
  float v3;
};
//SIG(1 B_BFu15i_F) C1{ Fc Fi:15 Fi}



static void Test_B_BFu15i_F()
{
  {
    init_simple_test("B_BFu15i_F");
    static B_BFu15i_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_F)");
    check_field_offset(lv, v1, 0, "B_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_F");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_F");
    check_field_offset(lv, v3, 4, "B_BFu15i_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15i_F(Test_B_BFu15i_F, "B_BFu15i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_I  {
  bool v1;
  unsigned int v2:15;
  int v3;
};
//SIG(1 B_BFu15i_I) C1{ Fc Fi:15 Fi}



static void Test_B_BFu15i_I()
{
  {
    init_simple_test("B_BFu15i_I");
    static B_BFu15i_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_I)");
    check_field_offset(lv, v1, 0, "B_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_I");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_I");
    check_field_offset(lv, v3, 4, "B_BFu15i_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15i_I(Test_B_BFu15i_I, "B_BFu15i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_Ip  {
  bool v1;
  unsigned int v2:15;
  int *v3;
};
//SIG(1 B_BFu15i_Ip) C1{ Fc Fi:15 Fp}



static void Test_B_BFu15i_Ip()
{
  {
    init_simple_test("B_BFu15i_Ip");
    static B_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu15i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15i_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15i_Ip(Test_B_BFu15i_Ip, "B_BFu15i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_L  {
  bool v1;
  unsigned int v2:15;
  __tsi64 v3;
};
//SIG(1 B_BFu15i_L) C1{ Fc Fi:15 FL}



static void Test_B_BFu15i_L()
{
  {
    init_simple_test("B_BFu15i_L");
    static B_BFu15i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu15i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_L)");
    check_field_offset(lv, v1, 0, "B_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_L");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15i_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15i_L(Test_B_BFu15i_L, "B_BFu15i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_S  {
  bool v1;
  unsigned int v2:15;
  short v3;
};
//SIG(1 B_BFu15i_S) C1{ Fc Fi:15 Fs}



static void Test_B_BFu15i_S()
{
  {
    init_simple_test("B_BFu15i_S");
    static B_BFu15i_S lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_S)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_S)");
    check_field_offset(lv, v1, 0, "B_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_S");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_S");
    check_field_offset(lv, v3, 4, "B_BFu15i_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15i_S(Test_B_BFu15i_S, "B_BFu15i_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_Uc  {
  bool v1;
  unsigned int v2:15;
  unsigned char v3;
};
//SIG(1 B_BFu15i_Uc) C1{ Fc Fi:15 Fc}



static void Test_B_BFu15i_Uc()
{
  {
    init_simple_test("B_BFu15i_Uc");
    static B_BFu15i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_Uc");
    check_field_offset(lv, v3, 3, "B_BFu15i_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15i_Uc(Test_B_BFu15i_Uc, "B_BFu15i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_Ui  {
  bool v1;
  unsigned int v2:15;
  unsigned int v3;
};
//SIG(1 B_BFu15i_Ui) C1{ Fc Fi:15 Fi}



static void Test_B_BFu15i_Ui()
{
  {
    init_simple_test("B_BFu15i_Ui");
    static B_BFu15i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_Ui");
    check_field_offset(lv, v3, 4, "B_BFu15i_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15i_Ui(Test_B_BFu15i_Ui, "B_BFu15i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_Ul  {
  bool v1;
  unsigned int v2:15;
  __tsu64 v3;
};
//SIG(1 B_BFu15i_Ul) C1{ Fc Fi:15 FL}



static void Test_B_BFu15i_Ul()
{
  {
    init_simple_test("B_BFu15i_Ul");
    static B_BFu15i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu15i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15i_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15i_Ul(Test_B_BFu15i_Ul, "B_BFu15i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_Us  {
  bool v1;
  unsigned int v2:15;
  unsigned short v3;
};
//SIG(1 B_BFu15i_Us) C1{ Fc Fi:15 Fs}



static void Test_B_BFu15i_Us()
{
  {
    init_simple_test("B_BFu15i_Us");
    static B_BFu15i_Us lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "B_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_Us");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_Us");
    check_field_offset(lv, v3, 4, "B_BFu15i_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15i_Us(Test_B_BFu15i_Us, "B_BFu15i_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15i_Vp  {
  bool v1;
  unsigned int v2:15;
  void *v3;
};
//SIG(1 B_BFu15i_Vp) C1{ Fc Fi:15 Fp}



static void Test_B_BFu15i_Vp()
{
  {
    init_simple_test("B_BFu15i_Vp");
    static B_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu15i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15i_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15i_Vp(Test_B_BFu15i_Vp, "B_BFu15i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll  {
  bool v1;
  __tsu64 v2:15;
};
//SIG(1 B_BFu15ll) C1{ Fc FL:15}



static void Test_B_BFu15ll()
{
  {
    init_simple_test("B_BFu15ll");
    static B_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu15ll(Test_B_BFu15ll, "B_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_B  {
  bool v1;
  __tsu64 v2:15;
  bool v3;
};
//SIG(1 B_BFu15ll_B) C1{ Fc FL:15 Fc}



static void Test_B_BFu15ll_B()
{
  {
    init_simple_test("B_BFu15ll_B");
    static B_BFu15ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_B)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_B");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_B");
    check_field_offset(lv, v3, 3, "B_BFu15ll_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_B(Test_B_BFu15ll_B, "B_BFu15ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu15i  {
  bool v1;
  __tsu64 v2:15;
  unsigned int v3:15;
};
//SIG(1 B_BFu15ll_BFu15i) C1{ Fc FL:15 Fi:15}



static void Test_B_BFu15ll_BFu15i()
{
  {
    init_simple_test("B_BFu15ll_BFu15i");
    static B_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu15i(Test_B_BFu15ll_BFu15i, "B_BFu15ll_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu15ll  {
  bool v1;
  __tsu64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 B_BFu15ll_BFu15ll) C1{ Fc FL:15 FL:15}



static void Test_B_BFu15ll_BFu15ll()
{
  {
    init_simple_test("B_BFu15ll_BFu15ll");
    static B_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "B_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu15ll(Test_B_BFu15ll_BFu15ll, "B_BFu15ll_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu15s  {
  bool v1;
  __tsu64 v2:15;
  unsigned short v3:15;
};
//SIG(1 B_BFu15ll_BFu15s) C1{ Fc FL:15 Fs:15}



static void Test_B_BFu15ll_BFu15s()
{
  {
    init_simple_test("B_BFu15ll_BFu15s");
    static B_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu15s(Test_B_BFu15ll_BFu15s, "B_BFu15ll_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu16i  {
  bool v1;
  __tsu64 v2:15;
  unsigned int v3:16;
};
//SIG(1 B_BFu15ll_BFu16i) C1{ Fc FL:15 Fi:16}



static void Test_B_BFu15ll_BFu16i()
{
  {
    init_simple_test("B_BFu15ll_BFu16i");
    static B_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu15ll_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu16i(Test_B_BFu15ll_BFu16i, "B_BFu15ll_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu16ll  {
  bool v1;
  __tsu64 v2:15;
  __tsu64 v3:16;
};
//SIG(1 B_BFu15ll_BFu16ll) C1{ Fc FL:15 FL:16}



static void Test_B_BFu15ll_BFu16ll()
{
  {
    init_simple_test("B_BFu15ll_BFu16ll");
    static B_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "B_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "B_BFu15ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu16ll(Test_B_BFu15ll_BFu16ll, "B_BFu15ll_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu16s  {
  bool v1;
  __tsu64 v2:15;
  unsigned short v3:16;
};
//SIG(1 B_BFu15ll_BFu16s) C1{ Fc FL:15 Fs:16}



static void Test_B_BFu15ll_BFu16s()
{
  {
    init_simple_test("B_BFu15ll_BFu16s");
    static B_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu15ll_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu16s(Test_B_BFu15ll_BFu16s, "B_BFu15ll_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu17i  {
  bool v1;
  __tsu64 v2:15;
  unsigned int v3:17;
};
//SIG(1 B_BFu15ll_BFu17i) C1{ Fc FL:15 Fi:17}



static void Test_B_BFu15ll_BFu17i()
{
  {
    init_simple_test("B_BFu15ll_BFu17i");
    static B_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu15ll_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu17i(Test_B_BFu15ll_BFu17i, "B_BFu15ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu17ll  {
  bool v1;
  __tsu64 v2:15;
  __tsu64 v3:17;
};
//SIG(1 B_BFu15ll_BFu17ll) C1{ Fc FL:15 FL:17}



static void Test_B_BFu15ll_BFu17ll()
{
  {
    init_simple_test("B_BFu15ll_BFu17ll");
    static B_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "B_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "B_BFu15ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu17ll(Test_B_BFu15ll_BFu17ll, "B_BFu15ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu1c  {
  bool v1;
  __tsu64 v2:15;
  unsigned char v3:1;
};
//SIG(1 B_BFu15ll_BFu1c) C1{ Fc FL:15 Fc:1}



static void Test_B_BFu15ll_BFu1c()
{
  {
    init_simple_test("B_BFu15ll_BFu1c");
    static B_BFu15ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "B_BFu15ll_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu1c(Test_B_BFu15ll_BFu1c, "B_BFu15ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu1i  {
  bool v1;
  __tsu64 v2:15;
  unsigned int v3:1;
};
//SIG(1 B_BFu15ll_BFu1i) C1{ Fc FL:15 Fi:1}



static void Test_B_BFu15ll_BFu1i()
{
  {
    init_simple_test("B_BFu15ll_BFu1i");
    static B_BFu15ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "B_BFu15ll_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu1i(Test_B_BFu15ll_BFu1i, "B_BFu15ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu1ll  {
  bool v1;
  __tsu64 v2:15;
  __tsu64 v3:1;
};
//SIG(1 B_BFu15ll_BFu1ll) C1{ Fc FL:15 FL:1}



static void Test_B_BFu15ll_BFu1ll()
{
  {
    init_simple_test("B_BFu15ll_BFu1ll");
    static B_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "B_BFu15ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu1ll(Test_B_BFu15ll_BFu1ll, "B_BFu15ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu1s  {
  bool v1;
  __tsu64 v2:15;
  unsigned short v3:1;
};
//SIG(1 B_BFu15ll_BFu1s) C1{ Fc FL:15 Fs:1}



static void Test_B_BFu15ll_BFu1s()
{
  {
    init_simple_test("B_BFu15ll_BFu1s");
    static B_BFu15ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "B_BFu15ll_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu1s(Test_B_BFu15ll_BFu1s, "B_BFu15ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu31i  {
  bool v1;
  __tsu64 v2:15;
  unsigned int v3:31;
};
//SIG(1 B_BFu15ll_BFu31i) C1{ Fc FL:15 Fi:31}



static void Test_B_BFu15ll_BFu31i()
{
  {
    init_simple_test("B_BFu15ll_BFu31i");
    static B_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu15ll_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu31i(Test_B_BFu15ll_BFu31i, "B_BFu15ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu31ll  {
  bool v1;
  __tsu64 v2:15;
  __tsu64 v3:31;
};
//SIG(1 B_BFu15ll_BFu31ll) C1{ Fc FL:15 FL:31}



static void Test_B_BFu15ll_BFu31ll()
{
  {
    init_simple_test("B_BFu15ll_BFu31ll");
    static B_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "B_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "B_BFu15ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu31ll(Test_B_BFu15ll_BFu31ll, "B_BFu15ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu32i  {
  bool v1;
  __tsu64 v2:15;
  unsigned int v3:32;
};
//SIG(1 B_BFu15ll_BFu32i) C1{ Fc FL:15 Fi:32}



static void Test_B_BFu15ll_BFu32i()
{
  {
    init_simple_test("B_BFu15ll_BFu32i");
    static B_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu15ll_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu32i(Test_B_BFu15ll_BFu32i, "B_BFu15ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu32ll  {
  bool v1;
  __tsu64 v2:15;
  __tsu64 v3:32;
};
//SIG(1 B_BFu15ll_BFu32ll) C1{ Fc FL:15 FL:32}



static void Test_B_BFu15ll_BFu32ll()
{
  {
    init_simple_test("B_BFu15ll_BFu32ll");
    static B_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "B_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "B_BFu15ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu32ll(Test_B_BFu15ll_BFu32ll, "B_BFu15ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu33  {
  bool v1;
  __tsu64 v2:15;
  __tsu64 v3:33;
};
//SIG(1 B_BFu15ll_BFu33) C1{ Fc FL:15 FL:33}



static void Test_B_BFu15ll_BFu33()
{
  {
    init_simple_test("B_BFu15ll_BFu33");
    static B_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "B_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "B_BFu15ll_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu33(Test_B_BFu15ll_BFu33, "B_BFu15ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu7c  {
  bool v1;
  __tsu64 v2:15;
  unsigned char v3:7;
};
//SIG(1 B_BFu15ll_BFu7c) C1{ Fc FL:15 Fc:7}



static void Test_B_BFu15ll_BFu7c()
{
  {
    init_simple_test("B_BFu15ll_BFu7c");
    static B_BFu15ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_BFu15ll_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu7c(Test_B_BFu15ll_BFu7c, "B_BFu15ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu7i  {
  bool v1;
  __tsu64 v2:15;
  unsigned int v3:7;
};
//SIG(1 B_BFu15ll_BFu7i) C1{ Fc FL:15 Fi:7}



static void Test_B_BFu15ll_BFu7i()
{
  {
    init_simple_test("B_BFu15ll_BFu7i");
    static B_BFu15ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "B_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "B_BFu15ll_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu7i(Test_B_BFu15ll_BFu7i, "B_BFu15ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu7ll  {
  bool v1;
  __tsu64 v2:15;
  __tsu64 v3:7;
};
//SIG(1 B_BFu15ll_BFu7ll) C1{ Fc FL:15 FL:7}



static void Test_B_BFu15ll_BFu7ll()
{
  {
    init_simple_test("B_BFu15ll_BFu7ll");
    static B_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "B_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "B_BFu15ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu7ll(Test_B_BFu15ll_BFu7ll, "B_BFu15ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu7s  {
  bool v1;
  __tsu64 v2:15;
  unsigned short v3:7;
};
//SIG(1 B_BFu15ll_BFu7s) C1{ Fc FL:15 Fs:7}



static void Test_B_BFu15ll_BFu7s()
{
  {
    init_simple_test("B_BFu15ll_BFu7s");
    static B_BFu15ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "B_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "B_BFu15ll_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu7s(Test_B_BFu15ll_BFu7s, "B_BFu15ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu8c  {
  bool v1;
  __tsu64 v2:15;
  unsigned char v3:8;
};
//SIG(1 B_BFu15ll_BFu8c) C1{ Fc FL:15 Fc:8}



static void Test_B_BFu15ll_BFu8c()
{
  {
    init_simple_test("B_BFu15ll_BFu8c");
    static B_BFu15ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_BFu15ll_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu8c(Test_B_BFu15ll_BFu8c, "B_BFu15ll_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu8i  {
  bool v1;
  __tsu64 v2:15;
  unsigned int v3:8;
};
//SIG(1 B_BFu15ll_BFu8i) C1{ Fc FL:15 Fi:8}



static void Test_B_BFu15ll_BFu8i()
{
  {
    init_simple_test("B_BFu15ll_BFu8i");
    static B_BFu15ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "B_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "B_BFu15ll_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu8i(Test_B_BFu15ll_BFu8i, "B_BFu15ll_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu8ll  {
  bool v1;
  __tsu64 v2:15;
  __tsu64 v3:8;
};
//SIG(1 B_BFu15ll_BFu8ll) C1{ Fc FL:15 FL:8}



static void Test_B_BFu15ll_BFu8ll()
{
  {
    init_simple_test("B_BFu15ll_BFu8ll");
    static B_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "B_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "B_BFu15ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu8ll(Test_B_BFu15ll_BFu8ll, "B_BFu15ll_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu8s  {
  bool v1;
  __tsu64 v2:15;
  unsigned short v3:8;
};
//SIG(1 B_BFu15ll_BFu8s) C1{ Fc FL:15 Fs:8}



static void Test_B_BFu15ll_BFu8s()
{
  {
    init_simple_test("B_BFu15ll_BFu8s");
    static B_BFu15ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "B_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "B_BFu15ll_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu8s(Test_B_BFu15ll_BFu8s, "B_BFu15ll_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu9i  {
  bool v1;
  __tsu64 v2:15;
  unsigned int v3:9;
};
//SIG(1 B_BFu15ll_BFu9i) C1{ Fc FL:15 Fi:9}



static void Test_B_BFu15ll_BFu9i()
{
  {
    init_simple_test("B_BFu15ll_BFu9i");
    static B_BFu15ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "B_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "B_BFu15ll_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu9i(Test_B_BFu15ll_BFu9i, "B_BFu15ll_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu9ll  {
  bool v1;
  __tsu64 v2:15;
  __tsu64 v3:9;
};
//SIG(1 B_BFu15ll_BFu9ll) C1{ Fc FL:15 FL:9}



static void Test_B_BFu15ll_BFu9ll()
{
  {
    init_simple_test("B_BFu15ll_BFu9ll");
    static B_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "B_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "B_BFu15ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu9ll(Test_B_BFu15ll_BFu9ll, "B_BFu15ll_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_BFu9s  {
  bool v1;
  __tsu64 v2:15;
  unsigned short v3:9;
};
//SIG(1 B_BFu15ll_BFu9s) C1{ Fc FL:15 Fs:9}



static void Test_B_BFu15ll_BFu9s()
{
  {
    init_simple_test("B_BFu15ll_BFu9s");
    static B_BFu15ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "B_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "B_BFu15ll_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_BFu9s(Test_B_BFu15ll_BFu9s, "B_BFu15ll_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_C  {
  bool v1;
  __tsu64 v2:15;
  char v3;
};
//SIG(1 B_BFu15ll_C) C1{ Fc FL:15 Fc}



static void Test_B_BFu15ll_C()
{
  {
    init_simple_test("B_BFu15ll_C");
    static B_BFu15ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_C");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_C");
    check_field_offset(lv, v3, 3, "B_BFu15ll_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_C(Test_B_BFu15ll_C, "B_BFu15ll_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_D  {
  bool v1;
  __tsu64 v2:15;
  double v3;
};
//SIG(1 B_BFu15ll_D) C1{ Fc FL:15 FL}



static void Test_B_BFu15ll_D()
{
  {
    init_simple_test("B_BFu15ll_D");
    static B_BFu15ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu15ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_D");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15ll_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_D(Test_B_BFu15ll_D, "B_BFu15ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_F  {
  bool v1;
  __tsu64 v2:15;
  float v3;
};
//SIG(1 B_BFu15ll_F) C1{ Fc FL:15 Fi}



static void Test_B_BFu15ll_F()
{
  {
    init_simple_test("B_BFu15ll_F");
    static B_BFu15ll_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_F");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_F");
    check_field_offset(lv, v3, 4, "B_BFu15ll_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_F(Test_B_BFu15ll_F, "B_BFu15ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_I  {
  bool v1;
  __tsu64 v2:15;
  int v3;
};
//SIG(1 B_BFu15ll_I) C1{ Fc FL:15 Fi}



static void Test_B_BFu15ll_I()
{
  {
    init_simple_test("B_BFu15ll_I");
    static B_BFu15ll_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_I");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_I");
    check_field_offset(lv, v3, 4, "B_BFu15ll_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_I(Test_B_BFu15ll_I, "B_BFu15ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_Ip  {
  bool v1;
  __tsu64 v2:15;
  int *v3;
};
//SIG(1 B_BFu15ll_Ip) C1{ Fc FL:15 Fp}



static void Test_B_BFu15ll_Ip()
{
  {
    init_simple_test("B_BFu15ll_Ip");
    static B_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu15ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_Ip(Test_B_BFu15ll_Ip, "B_BFu15ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_L  {
  bool v1;
  __tsu64 v2:15;
  __tsi64 v3;
};
//SIG(1 B_BFu15ll_L) C1{ Fc FL:15 FL}



static void Test_B_BFu15ll_L()
{
  {
    init_simple_test("B_BFu15ll_L");
    static B_BFu15ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu15ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_L");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15ll_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_L(Test_B_BFu15ll_L, "B_BFu15ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_S  {
  bool v1;
  __tsu64 v2:15;
  short v3;
};
//SIG(1 B_BFu15ll_S) C1{ Fc FL:15 Fs}



static void Test_B_BFu15ll_S()
{
  {
    init_simple_test("B_BFu15ll_S");
    static B_BFu15ll_S lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_S");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_S");
    check_field_offset(lv, v3, 4, "B_BFu15ll_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_S(Test_B_BFu15ll_S, "B_BFu15ll_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_Uc  {
  bool v1;
  __tsu64 v2:15;
  unsigned char v3;
};
//SIG(1 B_BFu15ll_Uc) C1{ Fc FL:15 Fc}



static void Test_B_BFu15ll_Uc()
{
  {
    init_simple_test("B_BFu15ll_Uc");
    static B_BFu15ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_Uc");
    check_field_offset(lv, v3, 3, "B_BFu15ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_Uc(Test_B_BFu15ll_Uc, "B_BFu15ll_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_Ui  {
  bool v1;
  __tsu64 v2:15;
  unsigned int v3;
};
//SIG(1 B_BFu15ll_Ui) C1{ Fc FL:15 Fi}



static void Test_B_BFu15ll_Ui()
{
  {
    init_simple_test("B_BFu15ll_Ui");
    static B_BFu15ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_Ui");
    check_field_offset(lv, v3, 4, "B_BFu15ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_Ui(Test_B_BFu15ll_Ui, "B_BFu15ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_Ul  {
  bool v1;
  __tsu64 v2:15;
  __tsu64 v3;
};
//SIG(1 B_BFu15ll_Ul) C1{ Fc FL:15 FL}



static void Test_B_BFu15ll_Ul()
{
  {
    init_simple_test("B_BFu15ll_Ul");
    static B_BFu15ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu15ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_Ul(Test_B_BFu15ll_Ul, "B_BFu15ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_Us  {
  bool v1;
  __tsu64 v2:15;
  unsigned short v3;
};
//SIG(1 B_BFu15ll_Us) C1{ Fc FL:15 Fs}



static void Test_B_BFu15ll_Us()
{
  {
    init_simple_test("B_BFu15ll_Us");
    static B_BFu15ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_Us");
    check_field_offset(lv, v3, 4, "B_BFu15ll_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_Us(Test_B_BFu15ll_Us, "B_BFu15ll_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15ll_Vp  {
  bool v1;
  __tsu64 v2:15;
  void *v3;
};
//SIG(1 B_BFu15ll_Vp) C1{ Fc FL:15 Fp}



static void Test_B_BFu15ll_Vp()
{
  {
    init_simple_test("B_BFu15ll_Vp");
    static B_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu15ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "B_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "B_BFu15ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15ll_Vp(Test_B_BFu15ll_Vp, "B_BFu15ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s  {
  bool v1;
  unsigned short v2:15;
};
//SIG(1 B_BFu15s) C1{ Fc Fs:15}



static void Test_B_BFu15s()
{
  {
    init_simple_test("B_BFu15s");
    static B_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu15s(Test_B_BFu15s, "B_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_B  {
  bool v1;
  unsigned short v2:15;
  bool v3;
};
//SIG(1 B_BFu15s_B) C1{ Fc Fs:15 Fc}



static void Test_B_BFu15s_B()
{
  {
    init_simple_test("B_BFu15s_B");
    static B_BFu15s_B lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu15s_B)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s_B)");
    check_field_offset(lv, v1, 0, "B_BFu15s_B.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_B");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_B");
    check_field_offset(lv, v3, 4, "B_BFu15s_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15s_B(Test_B_BFu15s_B, "B_BFu15s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu15i  {
  bool v1;
  unsigned short v2:15;
  unsigned int v3:15;
};
//SIG(1 B_BFu15s_BFu15i) C1{ Fc Fs:15 Fi:15}



static void Test_B_BFu15s_BFu15i()
{
  {
    init_simple_test("B_BFu15s_BFu15i");
    static B_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu15i(Test_B_BFu15s_BFu15i, "B_BFu15s_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu15ll  {
  bool v1;
  unsigned short v2:15;
  __tsu64 v3:15;
};
//SIG(1 B_BFu15s_BFu15ll) C1{ Fc Fs:15 FL:15}



static void Test_B_BFu15s_BFu15ll()
{
  {
    init_simple_test("B_BFu15s_BFu15ll");
    static B_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "B_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "B_BFu15s_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu15ll(Test_B_BFu15s_BFu15ll, "B_BFu15s_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu15s  {
  bool v1;
  unsigned short v2:15;
  unsigned short v3:15;
};
//SIG(1 B_BFu15s_BFu15s) C1{ Fc Fs:15 Fs:15}



static void Test_B_BFu15s_BFu15s()
{
  {
    init_simple_test("B_BFu15s_BFu15s");
    static B_BFu15s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu15s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu15s(Test_B_BFu15s_BFu15s, "B_BFu15s_BFu15s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu16i  {
  bool v1;
  unsigned short v2:15;
  unsigned int v3:16;
};
//SIG(1 B_BFu15s_BFu16i) C1{ Fc Fs:15 Fi:16}



static void Test_B_BFu15s_BFu16i()
{
  {
    init_simple_test("B_BFu15s_BFu16i");
    static B_BFu15s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu15s_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu16i(Test_B_BFu15s_BFu16i, "B_BFu15s_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu16ll  {
  bool v1;
  unsigned short v2:15;
  __tsu64 v3:16;
};
//SIG(1 B_BFu15s_BFu16ll) C1{ Fc Fs:15 FL:16}



static void Test_B_BFu15s_BFu16ll()
{
  {
    init_simple_test("B_BFu15s_BFu16ll");
    static B_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "B_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "B_BFu15s_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu16ll(Test_B_BFu15s_BFu16ll, "B_BFu15s_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu16s  {
  bool v1;
  unsigned short v2:15;
  unsigned short v3:16;
};
//SIG(1 B_BFu15s_BFu16s) C1{ Fc Fs:15 Fs:16}



static void Test_B_BFu15s_BFu16s()
{
  {
    init_simple_test("B_BFu15s_BFu16s");
    static B_BFu15s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu15s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu15s_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu16s(Test_B_BFu15s_BFu16s, "B_BFu15s_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu17i  {
  bool v1;
  unsigned short v2:15;
  unsigned int v3:17;
};
//SIG(1 B_BFu15s_BFu17i) C1{ Fc Fs:15 Fi:17}



static void Test_B_BFu15s_BFu17i()
{
  {
    init_simple_test("B_BFu15s_BFu17i");
    static B_BFu15s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu15s_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu17i(Test_B_BFu15s_BFu17i, "B_BFu15s_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu17ll  {
  bool v1;
  unsigned short v2:15;
  __tsu64 v3:17;
};
//SIG(1 B_BFu15s_BFu17ll) C1{ Fc Fs:15 FL:17}



static void Test_B_BFu15s_BFu17ll()
{
  {
    init_simple_test("B_BFu15s_BFu17ll");
    static B_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "B_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "B_BFu15s_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu17ll(Test_B_BFu15s_BFu17ll, "B_BFu15s_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu1c  {
  bool v1;
  unsigned short v2:15;
  unsigned char v3:1;
};
//SIG(1 B_BFu15s_BFu1c) C1{ Fc Fs:15 Fc:1}



static void Test_B_BFu15s_BFu1c()
{
  {
    init_simple_test("B_BFu15s_BFu1c");
    static B_BFu15s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "B_BFu15s_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu1c(Test_B_BFu15s_BFu1c, "B_BFu15s_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu1i  {
  bool v1;
  unsigned short v2:15;
  unsigned int v3:1;
};
//SIG(1 B_BFu15s_BFu1i) C1{ Fc Fs:15 Fi:1}



static void Test_B_BFu15s_BFu1i()
{
  {
    init_simple_test("B_BFu15s_BFu1i");
    static B_BFu15s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "B_BFu15s_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu1i(Test_B_BFu15s_BFu1i, "B_BFu15s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu1ll  {
  bool v1;
  unsigned short v2:15;
  __tsu64 v3:1;
};
//SIG(1 B_BFu15s_BFu1ll) C1{ Fc Fs:15 FL:1}



static void Test_B_BFu15s_BFu1ll()
{
  {
    init_simple_test("B_BFu15s_BFu1ll");
    static B_BFu15s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu15s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "B_BFu15s_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu1ll(Test_B_BFu15s_BFu1ll, "B_BFu15s_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu1s  {
  bool v1;
  unsigned short v2:15;
  unsigned short v3:1;
};
//SIG(1 B_BFu15s_BFu1s) C1{ Fc Fs:15 Fs:1}



static void Test_B_BFu15s_BFu1s()
{
  {
    init_simple_test("B_BFu15s_BFu1s");
    static B_BFu15s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu15s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "B_BFu15s_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu1s(Test_B_BFu15s_BFu1s, "B_BFu15s_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu31i  {
  bool v1;
  unsigned short v2:15;
  unsigned int v3:31;
};
//SIG(1 B_BFu15s_BFu31i) C1{ Fc Fs:15 Fi:31}



static void Test_B_BFu15s_BFu31i()
{
  {
    init_simple_test("B_BFu15s_BFu31i");
    static B_BFu15s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu15s_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu31i(Test_B_BFu15s_BFu31i, "B_BFu15s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu31ll  {
  bool v1;
  unsigned short v2:15;
  __tsu64 v3:31;
};
//SIG(1 B_BFu15s_BFu31ll) C1{ Fc Fs:15 FL:31}



static void Test_B_BFu15s_BFu31ll()
{
  {
    init_simple_test("B_BFu15s_BFu31ll");
    static B_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "B_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "B_BFu15s_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu31ll(Test_B_BFu15s_BFu31ll, "B_BFu15s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu32i  {
  bool v1;
  unsigned short v2:15;
  unsigned int v3:32;
};
//SIG(1 B_BFu15s_BFu32i) C1{ Fc Fs:15 Fi:32}



static void Test_B_BFu15s_BFu32i()
{
  {
    init_simple_test("B_BFu15s_BFu32i");
    static B_BFu15s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15s_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu15s_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu32i(Test_B_BFu15s_BFu32i, "B_BFu15s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu32ll  {
  bool v1;
  unsigned short v2:15;
  __tsu64 v3:32;
};
//SIG(1 B_BFu15s_BFu32ll) C1{ Fc Fs:15 FL:32}



static void Test_B_BFu15s_BFu32ll()
{
  {
    init_simple_test("B_BFu15s_BFu32ll");
    static B_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "B_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "B_BFu15s_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu32ll(Test_B_BFu15s_BFu32ll, "B_BFu15s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu33  {
  bool v1;
  unsigned short v2:15;
  __tsu64 v3:33;
};
//SIG(1 B_BFu15s_BFu33) C1{ Fc Fs:15 FL:33}



static void Test_B_BFu15s_BFu33()
{
  {
    init_simple_test("B_BFu15s_BFu33");
    static B_BFu15s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "B_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "B_BFu15s_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu33(Test_B_BFu15s_BFu33, "B_BFu15s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu7c  {
  bool v1;
  unsigned short v2:15;
  unsigned char v3:7;
};
//SIG(1 B_BFu15s_BFu7c) C1{ Fc Fs:15 Fc:7}



static void Test_B_BFu15s_BFu7c()
{
  {
    init_simple_test("B_BFu15s_BFu7c");
    static B_BFu15s_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu15s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "B_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "B_BFu15s_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu7c(Test_B_BFu15s_BFu7c, "B_BFu15s_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu7i  {
  bool v1;
  unsigned short v2:15;
  unsigned int v3:7;
};
//SIG(1 B_BFu15s_BFu7i) C1{ Fc Fs:15 Fi:7}



static void Test_B_BFu15s_BFu7i()
{
  {
    init_simple_test("B_BFu15s_BFu7i");
    static B_BFu15s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15s_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "B_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "B_BFu15s_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu7i(Test_B_BFu15s_BFu7i, "B_BFu15s_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu7ll  {
  bool v1;
  unsigned short v2:15;
  __tsu64 v3:7;
};
//SIG(1 B_BFu15s_BFu7ll) C1{ Fc Fs:15 FL:7}



static void Test_B_BFu15s_BFu7ll()
{
  {
    init_simple_test("B_BFu15s_BFu7ll");
    static B_BFu15s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "B_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "B_BFu15s_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu7ll(Test_B_BFu15s_BFu7ll, "B_BFu15s_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu7s  {
  bool v1;
  unsigned short v2:15;
  unsigned short v3:7;
};
//SIG(1 B_BFu15s_BFu7s) C1{ Fc Fs:15 Fs:7}



static void Test_B_BFu15s_BFu7s()
{
  {
    init_simple_test("B_BFu15s_BFu7s");
    static B_BFu15s_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu15s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "B_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "B_BFu15s_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu7s(Test_B_BFu15s_BFu7s, "B_BFu15s_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu8c  {
  bool v1;
  unsigned short v2:15;
  unsigned char v3:8;
};
//SIG(1 B_BFu15s_BFu8c) C1{ Fc Fs:15 Fc:8}



static void Test_B_BFu15s_BFu8c()
{
  {
    init_simple_test("B_BFu15s_BFu8c");
    static B_BFu15s_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu15s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "B_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "B_BFu15s_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu8c(Test_B_BFu15s_BFu8c, "B_BFu15s_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu8i  {
  bool v1;
  unsigned short v2:15;
  unsigned int v3:8;
};
//SIG(1 B_BFu15s_BFu8i) C1{ Fc Fs:15 Fi:8}



static void Test_B_BFu15s_BFu8i()
{
  {
    init_simple_test("B_BFu15s_BFu8i");
    static B_BFu15s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15s_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "B_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "B_BFu15s_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu8i(Test_B_BFu15s_BFu8i, "B_BFu15s_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu8ll  {
  bool v1;
  unsigned short v2:15;
  __tsu64 v3:8;
};
//SIG(1 B_BFu15s_BFu8ll) C1{ Fc Fs:15 FL:8}



static void Test_B_BFu15s_BFu8ll()
{
  {
    init_simple_test("B_BFu15s_BFu8ll");
    static B_BFu15s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "B_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "B_BFu15s_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu8ll(Test_B_BFu15s_BFu8ll, "B_BFu15s_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu8s  {
  bool v1;
  unsigned short v2:15;
  unsigned short v3:8;
};
//SIG(1 B_BFu15s_BFu8s) C1{ Fc Fs:15 Fs:8}



static void Test_B_BFu15s_BFu8s()
{
  {
    init_simple_test("B_BFu15s_BFu8s");
    static B_BFu15s_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu15s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "B_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "B_BFu15s_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu8s(Test_B_BFu15s_BFu8s, "B_BFu15s_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu9i  {
  bool v1;
  unsigned short v2:15;
  unsigned int v3:9;
};
//SIG(1 B_BFu15s_BFu9i) C1{ Fc Fs:15 Fi:9}



static void Test_B_BFu15s_BFu9i()
{
  {
    init_simple_test("B_BFu15s_BFu9i");
    static B_BFu15s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15s_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "B_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "B_BFu15s_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu9i(Test_B_BFu15s_BFu9i, "B_BFu15s_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu9ll  {
  bool v1;
  unsigned short v2:15;
  __tsu64 v3:9;
};
//SIG(1 B_BFu15s_BFu9ll) C1{ Fc Fs:15 FL:9}



static void Test_B_BFu15s_BFu9ll()
{
  {
    init_simple_test("B_BFu15s_BFu9ll");
    static B_BFu15s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "B_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "B_BFu15s_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu9ll(Test_B_BFu15s_BFu9ll, "B_BFu15s_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_BFu9s  {
  bool v1;
  unsigned short v2:15;
  unsigned short v3:9;
};
//SIG(1 B_BFu15s_BFu9s) C1{ Fc Fs:15 Fs:9}



static void Test_B_BFu15s_BFu9s()
{
  {
    init_simple_test("B_BFu15s_BFu9s");
    static B_BFu15s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu15s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu15s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "B_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "B_BFu15s_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu15s_BFu9s(Test_B_BFu15s_BFu9s, "B_BFu15s_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_C  {
  bool v1;
  unsigned short v2:15;
  char v3;
};
//SIG(1 B_BFu15s_C) C1{ Fc Fs:15 Fc}



static void Test_B_BFu15s_C()
{
  {
    init_simple_test("B_BFu15s_C");
    static B_BFu15s_C lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu15s_C)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s_C)");
    check_field_offset(lv, v1, 0, "B_BFu15s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_C");
    check_field_offset(lv, v3, 4, "B_BFu15s_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15s_C(Test_B_BFu15s_C, "B_BFu15s_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_D  {
  bool v1;
  unsigned short v2:15;
  double v3;
};
//SIG(1 B_BFu15s_D) C1{ Fc Fs:15 FL}



static void Test_B_BFu15s_D()
{
  {
    init_simple_test("B_BFu15s_D");
    static B_BFu15s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu15s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_D)");
    check_field_offset(lv, v1, 0, "B_BFu15s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15s_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15s_D(Test_B_BFu15s_D, "B_BFu15s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_F  {
  bool v1;
  unsigned short v2:15;
  float v3;
};
//SIG(1 B_BFu15s_F) C1{ Fc Fs:15 Fi}



static void Test_B_BFu15s_F()
{
  {
    init_simple_test("B_BFu15s_F");
    static B_BFu15s_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15s_F)");
    check_field_offset(lv, v1, 0, "B_BFu15s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_F");
    check_field_offset(lv, v3, 4, "B_BFu15s_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15s_F(Test_B_BFu15s_F, "B_BFu15s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_I  {
  bool v1;
  unsigned short v2:15;
  int v3;
};
//SIG(1 B_BFu15s_I) C1{ Fc Fs:15 Fi}



static void Test_B_BFu15s_I()
{
  {
    init_simple_test("B_BFu15s_I");
    static B_BFu15s_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15s_I)");
    check_field_offset(lv, v1, 0, "B_BFu15s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_I");
    check_field_offset(lv, v3, 4, "B_BFu15s_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15s_I(Test_B_BFu15s_I, "B_BFu15s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_Ip  {
  bool v1;
  unsigned short v2:15;
  int *v3;
};
//SIG(1 B_BFu15s_Ip) C1{ Fc Fs:15 Fp}



static void Test_B_BFu15s_Ip()
{
  {
    init_simple_test("B_BFu15s_Ip");
    static B_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu15s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu15s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15s_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15s_Ip(Test_B_BFu15s_Ip, "B_BFu15s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_L  {
  bool v1;
  unsigned short v2:15;
  __tsi64 v3;
};
//SIG(1 B_BFu15s_L) C1{ Fc Fs:15 FL}



static void Test_B_BFu15s_L()
{
  {
    init_simple_test("B_BFu15s_L");
    static B_BFu15s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu15s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_L)");
    check_field_offset(lv, v1, 0, "B_BFu15s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15s_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15s_L(Test_B_BFu15s_L, "B_BFu15s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_S  {
  bool v1;
  unsigned short v2:15;
  short v3;
};
//SIG(1 B_BFu15s_S) C1{ Fc Fs:15 Fs}



static void Test_B_BFu15s_S()
{
  {
    init_simple_test("B_BFu15s_S");
    static B_BFu15s_S lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu15s_S)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s_S)");
    check_field_offset(lv, v1, 0, "B_BFu15s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_S");
    check_field_offset(lv, v3, 4, "B_BFu15s_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15s_S(Test_B_BFu15s_S, "B_BFu15s_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_Uc  {
  bool v1;
  unsigned short v2:15;
  unsigned char v3;
};
//SIG(1 B_BFu15s_Uc) C1{ Fc Fs:15 Fc}



static void Test_B_BFu15s_Uc()
{
  {
    init_simple_test("B_BFu15s_Uc");
    static B_BFu15s_Uc lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu15s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu15s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_Uc");
    check_field_offset(lv, v3, 4, "B_BFu15s_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15s_Uc(Test_B_BFu15s_Uc, "B_BFu15s_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_Ui  {
  bool v1;
  unsigned short v2:15;
  unsigned int v3;
};
//SIG(1 B_BFu15s_Ui) C1{ Fc Fs:15 Fi}



static void Test_B_BFu15s_Ui()
{
  {
    init_simple_test("B_BFu15s_Ui");
    static B_BFu15s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu15s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu15s_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu15s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_Ui");
    check_field_offset(lv, v3, 4, "B_BFu15s_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15s_Ui(Test_B_BFu15s_Ui, "B_BFu15s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_Ul  {
  bool v1;
  unsigned short v2:15;
  __tsu64 v3;
};
//SIG(1 B_BFu15s_Ul) C1{ Fc Fs:15 FL}



static void Test_B_BFu15s_Ul()
{
  {
    init_simple_test("B_BFu15s_Ul");
    static B_BFu15s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu15s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu15s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15s_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15s_Ul(Test_B_BFu15s_Ul, "B_BFu15s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_Us  {
  bool v1;
  unsigned short v2:15;
  unsigned short v3;
};
//SIG(1 B_BFu15s_Us) C1{ Fc Fs:15 Fs}



static void Test_B_BFu15s_Us()
{
  {
    init_simple_test("B_BFu15s_Us");
    static B_BFu15s_Us lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu15s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "B_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_Us");
    check_field_offset(lv, v3, 4, "B_BFu15s_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15s_Us(Test_B_BFu15s_Us, "B_BFu15s_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu15s_Vp  {
  bool v1;
  unsigned short v2:15;
  void *v3;
};
//SIG(1 B_BFu15s_Vp) C1{ Fc Fs:15 Fp}



static void Test_B_BFu15s_Vp()
{
  {
    init_simple_test("B_BFu15s_Vp");
    static B_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu15s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "B_BFu15s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "B_BFu15s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu15s_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu15s_Vp(Test_B_BFu15s_Vp, "B_BFu15s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i  {
  bool v1;
  unsigned int v2:16;
};
//SIG(1 B_BFu16i) C1{ Fc Fi:16}



static void Test_B_BFu16i()
{
  {
    init_simple_test("B_BFu16i");
    static B_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu16i(Test_B_BFu16i, "B_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_B  {
  bool v1;
  unsigned int v2:16;
  bool v3;
};
//SIG(1 B_BFu16i_B) C1{ Fc Fi:16 Fc}



static void Test_B_BFu16i_B()
{
  {
    init_simple_test("B_BFu16i_B");
    static B_BFu16i_B lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu16i_B)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_B)");
    check_field_offset(lv, v1, 0, "B_BFu16i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_B");
    check_field_offset(lv, v3, 3, "B_BFu16i_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16i_B(Test_B_BFu16i_B, "B_BFu16i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu15i  {
  bool v1;
  unsigned int v2:16;
  unsigned int v3:15;
};
//SIG(1 B_BFu16i_BFu15i) C1{ Fc Fi:16 Fi:15}



static void Test_B_BFu16i_BFu15i()
{
  {
    init_simple_test("B_BFu16i_BFu15i");
    static B_BFu16i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu16i_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu15i(Test_B_BFu16i_BFu15i, "B_BFu16i_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu15ll  {
  bool v1;
  unsigned int v2:16;
  __tsu64 v3:15;
};
//SIG(1 B_BFu16i_BFu15ll) C1{ Fc Fi:16 FL:15}



static void Test_B_BFu16i_BFu15ll()
{
  {
    init_simple_test("B_BFu16i_BFu15ll");
    static B_BFu16i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "B_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "B_BFu16i_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu15ll(Test_B_BFu16i_BFu15ll, "B_BFu16i_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu15s  {
  bool v1;
  unsigned int v2:16;
  unsigned short v3:15;
};
//SIG(1 B_BFu16i_BFu15s) C1{ Fc Fi:16 Fs:15}



static void Test_B_BFu16i_BFu15s()
{
  {
    init_simple_test("B_BFu16i_BFu15s");
    static B_BFu16i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu16i_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu15s(Test_B_BFu16i_BFu15s, "B_BFu16i_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu16i  {
  bool v1;
  unsigned int v2:16;
  unsigned int v3:16;
};
//SIG(1 B_BFu16i_BFu16i) C1{ Fc Fi:16 Fi:16}



static void Test_B_BFu16i_BFu16i()
{
  {
    init_simple_test("B_BFu16i_BFu16i");
    static B_BFu16i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu16i(Test_B_BFu16i_BFu16i, "B_BFu16i_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu16ll  {
  bool v1;
  unsigned int v2:16;
  __tsu64 v3:16;
};
//SIG(1 B_BFu16i_BFu16ll) C1{ Fc Fi:16 FL:16}



static void Test_B_BFu16i_BFu16ll()
{
  {
    init_simple_test("B_BFu16i_BFu16ll");
    static B_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "B_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu16ll(Test_B_BFu16i_BFu16ll, "B_BFu16i_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu16s  {
  bool v1;
  unsigned int v2:16;
  unsigned short v3:16;
};
//SIG(1 B_BFu16i_BFu16s) C1{ Fc Fi:16 Fs:16}



static void Test_B_BFu16i_BFu16s()
{
  {
    init_simple_test("B_BFu16i_BFu16s");
    static B_BFu16i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu16s(Test_B_BFu16i_BFu16s, "B_BFu16i_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu17i  {
  bool v1;
  unsigned int v2:16;
  unsigned int v3:17;
};
//SIG(1 B_BFu16i_BFu17i) C1{ Fc Fi:16 Fi:17}



static void Test_B_BFu16i_BFu17i()
{
  {
    init_simple_test("B_BFu16i_BFu17i");
    static B_BFu16i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu16i_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu17i(Test_B_BFu16i_BFu17i, "B_BFu16i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu17ll  {
  bool v1;
  unsigned int v2:16;
  __tsu64 v3:17;
};
//SIG(1 B_BFu16i_BFu17ll) C1{ Fc Fi:16 FL:17}



static void Test_B_BFu16i_BFu17ll()
{
  {
    init_simple_test("B_BFu16i_BFu17ll");
    static B_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "B_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "B_BFu16i_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu17ll(Test_B_BFu16i_BFu17ll, "B_BFu16i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu1c  {
  bool v1;
  unsigned int v2:16;
  unsigned char v3:1;
};
//SIG(1 B_BFu16i_BFu1c) C1{ Fc Fi:16 Fc:1}



static void Test_B_BFu16i_BFu1c()
{
  {
    init_simple_test("B_BFu16i_BFu1c");
    static B_BFu16i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu16i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_BFu16i_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu1c(Test_B_BFu16i_BFu1c, "B_BFu16i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu1i  {
  bool v1;
  unsigned int v2:16;
  unsigned int v3:1;
};
//SIG(1 B_BFu16i_BFu1i) C1{ Fc Fi:16 Fi:1}



static void Test_B_BFu16i_BFu1i()
{
  {
    init_simple_test("B_BFu16i_BFu1i");
    static B_BFu16i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu16i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_BFu16i_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu1i(Test_B_BFu16i_BFu1i, "B_BFu16i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu1ll  {
  bool v1;
  unsigned int v2:16;
  __tsu64 v3:1;
};
//SIG(1 B_BFu16i_BFu1ll) C1{ Fc Fi:16 FL:1}



static void Test_B_BFu16i_BFu1ll()
{
  {
    init_simple_test("B_BFu16i_BFu1ll");
    static B_BFu16i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_BFu16i_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu1ll(Test_B_BFu16i_BFu1ll, "B_BFu16i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu1s  {
  bool v1;
  unsigned int v2:16;
  unsigned short v3:1;
};
//SIG(1 B_BFu16i_BFu1s) C1{ Fc Fi:16 Fs:1}



static void Test_B_BFu16i_BFu1s()
{
  {
    init_simple_test("B_BFu16i_BFu1s");
    static B_BFu16i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu16i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_BFu16i_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu1s(Test_B_BFu16i_BFu1s, "B_BFu16i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu31i  {
  bool v1;
  unsigned int v2:16;
  unsigned int v3:31;
};
//SIG(1 B_BFu16i_BFu31i) C1{ Fc Fi:16 Fi:31}



static void Test_B_BFu16i_BFu31i()
{
  {
    init_simple_test("B_BFu16i_BFu31i");
    static B_BFu16i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu16i_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu31i(Test_B_BFu16i_BFu31i, "B_BFu16i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu31ll  {
  bool v1;
  unsigned int v2:16;
  __tsu64 v3:31;
};
//SIG(1 B_BFu16i_BFu31ll) C1{ Fc Fi:16 FL:31}



static void Test_B_BFu16i_BFu31ll()
{
  {
    init_simple_test("B_BFu16i_BFu31ll");
    static B_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "B_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "B_BFu16i_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu31ll(Test_B_BFu16i_BFu31ll, "B_BFu16i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu32i  {
  bool v1;
  unsigned int v2:16;
  unsigned int v3:32;
};
//SIG(1 B_BFu16i_BFu32i) C1{ Fc Fi:16 Fi:32}



static void Test_B_BFu16i_BFu32i()
{
  {
    init_simple_test("B_BFu16i_BFu32i");
    static B_BFu16i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu16i_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu32i(Test_B_BFu16i_BFu32i, "B_BFu16i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu32ll  {
  bool v1;
  unsigned int v2:16;
  __tsu64 v3:32;
};
//SIG(1 B_BFu16i_BFu32ll) C1{ Fc Fi:16 FL:32}



static void Test_B_BFu16i_BFu32ll()
{
  {
    init_simple_test("B_BFu16i_BFu32ll");
    static B_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "B_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "B_BFu16i_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu32ll(Test_B_BFu16i_BFu32ll, "B_BFu16i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu33  {
  bool v1;
  unsigned int v2:16;
  __tsu64 v3:33;
};
//SIG(1 B_BFu16i_BFu33) C1{ Fc Fi:16 FL:33}



static void Test_B_BFu16i_BFu33()
{
  {
    init_simple_test("B_BFu16i_BFu33");
    static B_BFu16i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "B_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "B_BFu16i_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu33(Test_B_BFu16i_BFu33, "B_BFu16i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu7c  {
  bool v1;
  unsigned int v2:16;
  unsigned char v3:7;
};
//SIG(1 B_BFu16i_BFu7c) C1{ Fc Fi:16 Fc:7}



static void Test_B_BFu16i_BFu7c()
{
  {
    init_simple_test("B_BFu16i_BFu7c");
    static B_BFu16i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu16i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_BFu16i_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu7c(Test_B_BFu16i_BFu7c, "B_BFu16i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu7i  {
  bool v1;
  unsigned int v2:16;
  unsigned int v3:7;
};
//SIG(1 B_BFu16i_BFu7i) C1{ Fc Fi:16 Fi:7}



static void Test_B_BFu16i_BFu7i()
{
  {
    init_simple_test("B_BFu16i_BFu7i");
    static B_BFu16i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu16i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_BFu16i_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu7i(Test_B_BFu16i_BFu7i, "B_BFu16i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu7ll  {
  bool v1;
  unsigned int v2:16;
  __tsu64 v3:7;
};
//SIG(1 B_BFu16i_BFu7ll) C1{ Fc Fi:16 FL:7}



static void Test_B_BFu16i_BFu7ll()
{
  {
    init_simple_test("B_BFu16i_BFu7ll");
    static B_BFu16i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_BFu16i_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu7ll(Test_B_BFu16i_BFu7ll, "B_BFu16i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu7s  {
  bool v1;
  unsigned int v2:16;
  unsigned short v3:7;
};
//SIG(1 B_BFu16i_BFu7s) C1{ Fc Fi:16 Fs:7}



static void Test_B_BFu16i_BFu7s()
{
  {
    init_simple_test("B_BFu16i_BFu7s");
    static B_BFu16i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu16i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_BFu16i_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu7s(Test_B_BFu16i_BFu7s, "B_BFu16i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu8c  {
  bool v1;
  unsigned int v2:16;
  unsigned char v3:8;
};
//SIG(1 B_BFu16i_BFu8c) C1{ Fc Fi:16 Fc:8}



static void Test_B_BFu16i_BFu8c()
{
  {
    init_simple_test("B_BFu16i_BFu8c");
    static B_BFu16i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu16i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_BFu16i_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu8c(Test_B_BFu16i_BFu8c, "B_BFu16i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu8i  {
  bool v1;
  unsigned int v2:16;
  unsigned int v3:8;
};
//SIG(1 B_BFu16i_BFu8i) C1{ Fc Fi:16 Fi:8}



static void Test_B_BFu16i_BFu8i()
{
  {
    init_simple_test("B_BFu16i_BFu8i");
    static B_BFu16i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu16i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_BFu16i_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu8i(Test_B_BFu16i_BFu8i, "B_BFu16i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu8ll  {
  bool v1;
  unsigned int v2:16;
  __tsu64 v3:8;
};
//SIG(1 B_BFu16i_BFu8ll) C1{ Fc Fi:16 FL:8}



static void Test_B_BFu16i_BFu8ll()
{
  {
    init_simple_test("B_BFu16i_BFu8ll");
    static B_BFu16i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_BFu16i_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu8ll(Test_B_BFu16i_BFu8ll, "B_BFu16i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu8s  {
  bool v1;
  unsigned int v2:16;
  unsigned short v3:8;
};
//SIG(1 B_BFu16i_BFu8s) C1{ Fc Fi:16 Fs:8}



static void Test_B_BFu16i_BFu8s()
{
  {
    init_simple_test("B_BFu16i_BFu8s");
    static B_BFu16i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu16i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_BFu16i_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu8s(Test_B_BFu16i_BFu8s, "B_BFu16i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu9i  {
  bool v1;
  unsigned int v2:16;
  unsigned int v3:9;
};
//SIG(1 B_BFu16i_BFu9i) C1{ Fc Fi:16 Fi:9}



static void Test_B_BFu16i_BFu9i()
{
  {
    init_simple_test("B_BFu16i_BFu9i");
    static B_BFu16i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "B_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "B_BFu16i_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu9i(Test_B_BFu16i_BFu9i, "B_BFu16i_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu9ll  {
  bool v1;
  unsigned int v2:16;
  __tsu64 v3:9;
};
//SIG(1 B_BFu16i_BFu9ll) C1{ Fc Fi:16 FL:9}



static void Test_B_BFu16i_BFu9ll()
{
  {
    init_simple_test("B_BFu16i_BFu9ll");
    static B_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "B_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "B_BFu16i_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu9ll(Test_B_BFu16i_BFu9ll, "B_BFu16i_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_BFu9s  {
  bool v1;
  unsigned int v2:16;
  unsigned short v3:9;
};
//SIG(1 B_BFu16i_BFu9s) C1{ Fc Fi:16 Fs:9}



static void Test_B_BFu16i_BFu9s()
{
  {
    init_simple_test("B_BFu16i_BFu9s");
    static B_BFu16i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "B_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "B_BFu16i_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu16i_BFu9s(Test_B_BFu16i_BFu9s, "B_BFu16i_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_C  {
  bool v1;
  unsigned int v2:16;
  char v3;
};
//SIG(1 B_BFu16i_C) C1{ Fc Fi:16 Fc}



static void Test_B_BFu16i_C()
{
  {
    init_simple_test("B_BFu16i_C");
    static B_BFu16i_C lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu16i_C)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_C)");
    check_field_offset(lv, v1, 0, "B_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_C");
    check_field_offset(lv, v3, 3, "B_BFu16i_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16i_C(Test_B_BFu16i_C, "B_BFu16i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_D  {
  bool v1;
  unsigned int v2:16;
  double v3;
};
//SIG(1 B_BFu16i_D) C1{ Fc Fi:16 FL}



static void Test_B_BFu16i_D()
{
  {
    init_simple_test("B_BFu16i_D");
    static B_BFu16i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu16i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_D)");
    check_field_offset(lv, v1, 0, "B_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16i_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16i_D(Test_B_BFu16i_D, "B_BFu16i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_F  {
  bool v1;
  unsigned int v2:16;
  float v3;
};
//SIG(1 B_BFu16i_F) C1{ Fc Fi:16 Fi}



static void Test_B_BFu16i_F()
{
  {
    init_simple_test("B_BFu16i_F");
    static B_BFu16i_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_F)");
    check_field_offset(lv, v1, 0, "B_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_F");
    check_field_offset(lv, v3, 4, "B_BFu16i_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16i_F(Test_B_BFu16i_F, "B_BFu16i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_I  {
  bool v1;
  unsigned int v2:16;
  int v3;
};
//SIG(1 B_BFu16i_I) C1{ Fc Fi:16 Fi}



static void Test_B_BFu16i_I()
{
  {
    init_simple_test("B_BFu16i_I");
    static B_BFu16i_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_I)");
    check_field_offset(lv, v1, 0, "B_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_I");
    check_field_offset(lv, v3, 4, "B_BFu16i_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16i_I(Test_B_BFu16i_I, "B_BFu16i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_Ip  {
  bool v1;
  unsigned int v2:16;
  int *v3;
};
//SIG(1 B_BFu16i_Ip) C1{ Fc Fi:16 Fp}



static void Test_B_BFu16i_Ip()
{
  {
    init_simple_test("B_BFu16i_Ip");
    static B_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu16i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16i_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16i_Ip(Test_B_BFu16i_Ip, "B_BFu16i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_L  {
  bool v1;
  unsigned int v2:16;
  __tsi64 v3;
};
//SIG(1 B_BFu16i_L) C1{ Fc Fi:16 FL}



static void Test_B_BFu16i_L()
{
  {
    init_simple_test("B_BFu16i_L");
    static B_BFu16i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu16i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_L)");
    check_field_offset(lv, v1, 0, "B_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16i_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16i_L(Test_B_BFu16i_L, "B_BFu16i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_S  {
  bool v1;
  unsigned int v2:16;
  short v3;
};
//SIG(1 B_BFu16i_S) C1{ Fc Fi:16 Fs}



static void Test_B_BFu16i_S()
{
  {
    init_simple_test("B_BFu16i_S");
    static B_BFu16i_S lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_S)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_S)");
    check_field_offset(lv, v1, 0, "B_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_S");
    check_field_offset(lv, v3, 4, "B_BFu16i_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16i_S(Test_B_BFu16i_S, "B_BFu16i_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_Uc  {
  bool v1;
  unsigned int v2:16;
  unsigned char v3;
};
//SIG(1 B_BFu16i_Uc) C1{ Fc Fi:16 Fc}



static void Test_B_BFu16i_Uc()
{
  {
    init_simple_test("B_BFu16i_Uc");
    static B_BFu16i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu16i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_Uc");
    check_field_offset(lv, v3, 3, "B_BFu16i_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16i_Uc(Test_B_BFu16i_Uc, "B_BFu16i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_Ui  {
  bool v1;
  unsigned int v2:16;
  unsigned int v3;
};
//SIG(1 B_BFu16i_Ui) C1{ Fc Fi:16 Fi}



static void Test_B_BFu16i_Ui()
{
  {
    init_simple_test("B_BFu16i_Ui");
    static B_BFu16i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_Ui");
    check_field_offset(lv, v3, 4, "B_BFu16i_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16i_Ui(Test_B_BFu16i_Ui, "B_BFu16i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_Ul  {
  bool v1;
  unsigned int v2:16;
  __tsu64 v3;
};
//SIG(1 B_BFu16i_Ul) C1{ Fc Fi:16 FL}



static void Test_B_BFu16i_Ul()
{
  {
    init_simple_test("B_BFu16i_Ul");
    static B_BFu16i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu16i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16i_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16i_Ul(Test_B_BFu16i_Ul, "B_BFu16i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_Us  {
  bool v1;
  unsigned int v2:16;
  unsigned short v3;
};
//SIG(1 B_BFu16i_Us) C1{ Fc Fi:16 Fs}



static void Test_B_BFu16i_Us()
{
  {
    init_simple_test("B_BFu16i_Us");
    static B_BFu16i_Us lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "B_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_Us");
    check_field_offset(lv, v3, 4, "B_BFu16i_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16i_Us(Test_B_BFu16i_Us, "B_BFu16i_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16i_Vp  {
  bool v1;
  unsigned int v2:16;
  void *v3;
};
//SIG(1 B_BFu16i_Vp) C1{ Fc Fi:16 Fp}



static void Test_B_BFu16i_Vp()
{
  {
    init_simple_test("B_BFu16i_Vp");
    static B_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu16i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16i_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16i_Vp(Test_B_BFu16i_Vp, "B_BFu16i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll  {
  bool v1;
  __tsu64 v2:16;
};
//SIG(1 B_BFu16ll) C1{ Fc FL:16}



static void Test_B_BFu16ll()
{
  {
    init_simple_test("B_BFu16ll");
    static B_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu16ll(Test_B_BFu16ll, "B_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_B  {
  bool v1;
  __tsu64 v2:16;
  bool v3;
};
//SIG(1 B_BFu16ll_B) C1{ Fc FL:16 Fc}



static void Test_B_BFu16ll_B()
{
  {
    init_simple_test("B_BFu16ll_B");
    static B_BFu16ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_B)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_B");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_B");
    check_field_offset(lv, v3, 3, "B_BFu16ll_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_B(Test_B_BFu16ll_B, "B_BFu16ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu15i  {
  bool v1;
  __tsu64 v2:16;
  unsigned int v3:15;
};
//SIG(1 B_BFu16ll_BFu15i) C1{ Fc FL:16 Fi:15}



static void Test_B_BFu16ll_BFu15i()
{
  {
    init_simple_test("B_BFu16ll_BFu15i");
    static B_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu16ll_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu15i(Test_B_BFu16ll_BFu15i, "B_BFu16ll_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu15ll  {
  bool v1;
  __tsu64 v2:16;
  __tsu64 v3:15;
};
//SIG(1 B_BFu16ll_BFu15ll) C1{ Fc FL:16 FL:15}



static void Test_B_BFu16ll_BFu15ll()
{
  {
    init_simple_test("B_BFu16ll_BFu15ll");
    static B_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "B_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "B_BFu16ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu15ll(Test_B_BFu16ll_BFu15ll, "B_BFu16ll_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu15s  {
  bool v1;
  __tsu64 v2:16;
  unsigned short v3:15;
};
//SIG(1 B_BFu16ll_BFu15s) C1{ Fc FL:16 Fs:15}



static void Test_B_BFu16ll_BFu15s()
{
  {
    init_simple_test("B_BFu16ll_BFu15s");
    static B_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu16ll_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu15s(Test_B_BFu16ll_BFu15s, "B_BFu16ll_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu16i  {
  bool v1;
  __tsu64 v2:16;
  unsigned int v3:16;
};
//SIG(1 B_BFu16ll_BFu16i) C1{ Fc FL:16 Fi:16}



static void Test_B_BFu16ll_BFu16i()
{
  {
    init_simple_test("B_BFu16ll_BFu16i");
    static B_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu16i(Test_B_BFu16ll_BFu16i, "B_BFu16ll_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu16ll  {
  bool v1;
  __tsu64 v2:16;
  __tsu64 v3:16;
};
//SIG(1 B_BFu16ll_BFu16ll) C1{ Fc FL:16 FL:16}



static void Test_B_BFu16ll_BFu16ll()
{
  {
    init_simple_test("B_BFu16ll_BFu16ll");
    static B_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "B_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu16ll(Test_B_BFu16ll_BFu16ll, "B_BFu16ll_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu16s  {
  bool v1;
  __tsu64 v2:16;
  unsigned short v3:16;
};
//SIG(1 B_BFu16ll_BFu16s) C1{ Fc FL:16 Fs:16}



static void Test_B_BFu16ll_BFu16s()
{
  {
    init_simple_test("B_BFu16ll_BFu16s");
    static B_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu16s(Test_B_BFu16ll_BFu16s, "B_BFu16ll_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu17i  {
  bool v1;
  __tsu64 v2:16;
  unsigned int v3:17;
};
//SIG(1 B_BFu16ll_BFu17i) C1{ Fc FL:16 Fi:17}



static void Test_B_BFu16ll_BFu17i()
{
  {
    init_simple_test("B_BFu16ll_BFu17i");
    static B_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu16ll_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu17i(Test_B_BFu16ll_BFu17i, "B_BFu16ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu17ll  {
  bool v1;
  __tsu64 v2:16;
  __tsu64 v3:17;
};
//SIG(1 B_BFu16ll_BFu17ll) C1{ Fc FL:16 FL:17}



static void Test_B_BFu16ll_BFu17ll()
{
  {
    init_simple_test("B_BFu16ll_BFu17ll");
    static B_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "B_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "B_BFu16ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu17ll(Test_B_BFu16ll_BFu17ll, "B_BFu16ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu1c  {
  bool v1;
  __tsu64 v2:16;
  unsigned char v3:1;
};
//SIG(1 B_BFu16ll_BFu1c) C1{ Fc FL:16 Fc:1}



static void Test_B_BFu16ll_BFu1c()
{
  {
    init_simple_test("B_BFu16ll_BFu1c");
    static B_BFu16ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_BFu16ll_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu1c(Test_B_BFu16ll_BFu1c, "B_BFu16ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu1i  {
  bool v1;
  __tsu64 v2:16;
  unsigned int v3:1;
};
//SIG(1 B_BFu16ll_BFu1i) C1{ Fc FL:16 Fi:1}



static void Test_B_BFu16ll_BFu1i()
{
  {
    init_simple_test("B_BFu16ll_BFu1i");
    static B_BFu16ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_BFu16ll_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu1i(Test_B_BFu16ll_BFu1i, "B_BFu16ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu1ll  {
  bool v1;
  __tsu64 v2:16;
  __tsu64 v3:1;
};
//SIG(1 B_BFu16ll_BFu1ll) C1{ Fc FL:16 FL:1}



static void Test_B_BFu16ll_BFu1ll()
{
  {
    init_simple_test("B_BFu16ll_BFu1ll");
    static B_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_BFu16ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu1ll(Test_B_BFu16ll_BFu1ll, "B_BFu16ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu1s  {
  bool v1;
  __tsu64 v2:16;
  unsigned short v3:1;
};
//SIG(1 B_BFu16ll_BFu1s) C1{ Fc FL:16 Fs:1}



static void Test_B_BFu16ll_BFu1s()
{
  {
    init_simple_test("B_BFu16ll_BFu1s");
    static B_BFu16ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "B_BFu16ll_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu1s(Test_B_BFu16ll_BFu1s, "B_BFu16ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu31i  {
  bool v1;
  __tsu64 v2:16;
  unsigned int v3:31;
};
//SIG(1 B_BFu16ll_BFu31i) C1{ Fc FL:16 Fi:31}



static void Test_B_BFu16ll_BFu31i()
{
  {
    init_simple_test("B_BFu16ll_BFu31i");
    static B_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu16ll_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu31i(Test_B_BFu16ll_BFu31i, "B_BFu16ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu31ll  {
  bool v1;
  __tsu64 v2:16;
  __tsu64 v3:31;
};
//SIG(1 B_BFu16ll_BFu31ll) C1{ Fc FL:16 FL:31}



static void Test_B_BFu16ll_BFu31ll()
{
  {
    init_simple_test("B_BFu16ll_BFu31ll");
    static B_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "B_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "B_BFu16ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu31ll(Test_B_BFu16ll_BFu31ll, "B_BFu16ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu32i  {
  bool v1;
  __tsu64 v2:16;
  unsigned int v3:32;
};
//SIG(1 B_BFu16ll_BFu32i) C1{ Fc FL:16 Fi:32}



static void Test_B_BFu16ll_BFu32i()
{
  {
    init_simple_test("B_BFu16ll_BFu32i");
    static B_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu16ll_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu32i(Test_B_BFu16ll_BFu32i, "B_BFu16ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu32ll  {
  bool v1;
  __tsu64 v2:16;
  __tsu64 v3:32;
};
//SIG(1 B_BFu16ll_BFu32ll) C1{ Fc FL:16 FL:32}



static void Test_B_BFu16ll_BFu32ll()
{
  {
    init_simple_test("B_BFu16ll_BFu32ll");
    static B_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "B_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "B_BFu16ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu32ll(Test_B_BFu16ll_BFu32ll, "B_BFu16ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu33  {
  bool v1;
  __tsu64 v2:16;
  __tsu64 v3:33;
};
//SIG(1 B_BFu16ll_BFu33) C1{ Fc FL:16 FL:33}



static void Test_B_BFu16ll_BFu33()
{
  {
    init_simple_test("B_BFu16ll_BFu33");
    static B_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "B_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "B_BFu16ll_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu33(Test_B_BFu16ll_BFu33, "B_BFu16ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu7c  {
  bool v1;
  __tsu64 v2:16;
  unsigned char v3:7;
};
//SIG(1 B_BFu16ll_BFu7c) C1{ Fc FL:16 Fc:7}



static void Test_B_BFu16ll_BFu7c()
{
  {
    init_simple_test("B_BFu16ll_BFu7c");
    static B_BFu16ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_BFu16ll_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu7c(Test_B_BFu16ll_BFu7c, "B_BFu16ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu7i  {
  bool v1;
  __tsu64 v2:16;
  unsigned int v3:7;
};
//SIG(1 B_BFu16ll_BFu7i) C1{ Fc FL:16 Fi:7}



static void Test_B_BFu16ll_BFu7i()
{
  {
    init_simple_test("B_BFu16ll_BFu7i");
    static B_BFu16ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_BFu16ll_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu7i(Test_B_BFu16ll_BFu7i, "B_BFu16ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu7ll  {
  bool v1;
  __tsu64 v2:16;
  __tsu64 v3:7;
};
//SIG(1 B_BFu16ll_BFu7ll) C1{ Fc FL:16 FL:7}



static void Test_B_BFu16ll_BFu7ll()
{
  {
    init_simple_test("B_BFu16ll_BFu7ll");
    static B_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_BFu16ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu7ll(Test_B_BFu16ll_BFu7ll, "B_BFu16ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu7s  {
  bool v1;
  __tsu64 v2:16;
  unsigned short v3:7;
};
//SIG(1 B_BFu16ll_BFu7s) C1{ Fc FL:16 Fs:7}



static void Test_B_BFu16ll_BFu7s()
{
  {
    init_simple_test("B_BFu16ll_BFu7s");
    static B_BFu16ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "B_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "B_BFu16ll_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu7s(Test_B_BFu16ll_BFu7s, "B_BFu16ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu8c  {
  bool v1;
  __tsu64 v2:16;
  unsigned char v3:8;
};
//SIG(1 B_BFu16ll_BFu8c) C1{ Fc FL:16 Fc:8}



static void Test_B_BFu16ll_BFu8c()
{
  {
    init_simple_test("B_BFu16ll_BFu8c");
    static B_BFu16ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_BFu16ll_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu8c(Test_B_BFu16ll_BFu8c, "B_BFu16ll_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu8i  {
  bool v1;
  __tsu64 v2:16;
  unsigned int v3:8;
};
//SIG(1 B_BFu16ll_BFu8i) C1{ Fc FL:16 Fi:8}



static void Test_B_BFu16ll_BFu8i()
{
  {
    init_simple_test("B_BFu16ll_BFu8i");
    static B_BFu16ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_BFu16ll_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu8i(Test_B_BFu16ll_BFu8i, "B_BFu16ll_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu8ll  {
  bool v1;
  __tsu64 v2:16;
  __tsu64 v3:8;
};
//SIG(1 B_BFu16ll_BFu8ll) C1{ Fc FL:16 FL:8}



static void Test_B_BFu16ll_BFu8ll()
{
  {
    init_simple_test("B_BFu16ll_BFu8ll");
    static B_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_BFu16ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu8ll(Test_B_BFu16ll_BFu8ll, "B_BFu16ll_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu8s  {
  bool v1;
  __tsu64 v2:16;
  unsigned short v3:8;
};
//SIG(1 B_BFu16ll_BFu8s) C1{ Fc FL:16 Fs:8}



static void Test_B_BFu16ll_BFu8s()
{
  {
    init_simple_test("B_BFu16ll_BFu8s");
    static B_BFu16ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_BFu16ll_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu8s(Test_B_BFu16ll_BFu8s, "B_BFu16ll_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu9i  {
  bool v1;
  __tsu64 v2:16;
  unsigned int v3:9;
};
//SIG(1 B_BFu16ll_BFu9i) C1{ Fc FL:16 Fi:9}



static void Test_B_BFu16ll_BFu9i()
{
  {
    init_simple_test("B_BFu16ll_BFu9i");
    static B_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "B_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "B_BFu16ll_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu9i(Test_B_BFu16ll_BFu9i, "B_BFu16ll_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu9ll  {
  bool v1;
  __tsu64 v2:16;
  __tsu64 v3:9;
};
//SIG(1 B_BFu16ll_BFu9ll) C1{ Fc FL:16 FL:9}



static void Test_B_BFu16ll_BFu9ll()
{
  {
    init_simple_test("B_BFu16ll_BFu9ll");
    static B_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "B_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "B_BFu16ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu9ll(Test_B_BFu16ll_BFu9ll, "B_BFu16ll_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_BFu9s  {
  bool v1;
  __tsu64 v2:16;
  unsigned short v3:9;
};
//SIG(1 B_BFu16ll_BFu9s) C1{ Fc FL:16 Fs:9}



static void Test_B_BFu16ll_BFu9s()
{
  {
    init_simple_test("B_BFu16ll_BFu9s");
    static B_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "B_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "B_BFu16ll_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_BFu9s(Test_B_BFu16ll_BFu9s, "B_BFu16ll_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_C  {
  bool v1;
  __tsu64 v2:16;
  char v3;
};
//SIG(1 B_BFu16ll_C) C1{ Fc FL:16 Fc}



static void Test_B_BFu16ll_C()
{
  {
    init_simple_test("B_BFu16ll_C");
    static B_BFu16ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_C");
    check_field_offset(lv, v3, 3, "B_BFu16ll_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_C(Test_B_BFu16ll_C, "B_BFu16ll_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_D  {
  bool v1;
  __tsu64 v2:16;
  double v3;
};
//SIG(1 B_BFu16ll_D) C1{ Fc FL:16 FL}



static void Test_B_BFu16ll_D()
{
  {
    init_simple_test("B_BFu16ll_D");
    static B_BFu16ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu16ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16ll_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_D(Test_B_BFu16ll_D, "B_BFu16ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_F  {
  bool v1;
  __tsu64 v2:16;
  float v3;
};
//SIG(1 B_BFu16ll_F) C1{ Fc FL:16 Fi}



static void Test_B_BFu16ll_F()
{
  {
    init_simple_test("B_BFu16ll_F");
    static B_BFu16ll_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_F");
    check_field_offset(lv, v3, 4, "B_BFu16ll_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_F(Test_B_BFu16ll_F, "B_BFu16ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_I  {
  bool v1;
  __tsu64 v2:16;
  int v3;
};
//SIG(1 B_BFu16ll_I) C1{ Fc FL:16 Fi}



static void Test_B_BFu16ll_I()
{
  {
    init_simple_test("B_BFu16ll_I");
    static B_BFu16ll_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_I");
    check_field_offset(lv, v3, 4, "B_BFu16ll_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_I(Test_B_BFu16ll_I, "B_BFu16ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_Ip  {
  bool v1;
  __tsu64 v2:16;
  int *v3;
};
//SIG(1 B_BFu16ll_Ip) C1{ Fc FL:16 Fp}



static void Test_B_BFu16ll_Ip()
{
  {
    init_simple_test("B_BFu16ll_Ip");
    static B_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu16ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_Ip(Test_B_BFu16ll_Ip, "B_BFu16ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_L  {
  bool v1;
  __tsu64 v2:16;
  __tsi64 v3;
};
//SIG(1 B_BFu16ll_L) C1{ Fc FL:16 FL}



static void Test_B_BFu16ll_L()
{
  {
    init_simple_test("B_BFu16ll_L");
    static B_BFu16ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu16ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16ll_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_L(Test_B_BFu16ll_L, "B_BFu16ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_S  {
  bool v1;
  __tsu64 v2:16;
  short v3;
};
//SIG(1 B_BFu16ll_S) C1{ Fc FL:16 Fs}



static void Test_B_BFu16ll_S()
{
  {
    init_simple_test("B_BFu16ll_S");
    static B_BFu16ll_S lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_S");
    check_field_offset(lv, v3, 4, "B_BFu16ll_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_S(Test_B_BFu16ll_S, "B_BFu16ll_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_Uc  {
  bool v1;
  __tsu64 v2:16;
  unsigned char v3;
};
//SIG(1 B_BFu16ll_Uc) C1{ Fc FL:16 Fc}



static void Test_B_BFu16ll_Uc()
{
  {
    init_simple_test("B_BFu16ll_Uc");
    static B_BFu16ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu16ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_Uc");
    check_field_offset(lv, v3, 3, "B_BFu16ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_Uc(Test_B_BFu16ll_Uc, "B_BFu16ll_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_Ui  {
  bool v1;
  __tsu64 v2:16;
  unsigned int v3;
};
//SIG(1 B_BFu16ll_Ui) C1{ Fc FL:16 Fi}



static void Test_B_BFu16ll_Ui()
{
  {
    init_simple_test("B_BFu16ll_Ui");
    static B_BFu16ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_Ui");
    check_field_offset(lv, v3, 4, "B_BFu16ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_Ui(Test_B_BFu16ll_Ui, "B_BFu16ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_Ul  {
  bool v1;
  __tsu64 v2:16;
  __tsu64 v3;
};
//SIG(1 B_BFu16ll_Ul) C1{ Fc FL:16 FL}



static void Test_B_BFu16ll_Ul()
{
  {
    init_simple_test("B_BFu16ll_Ul");
    static B_BFu16ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu16ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_Ul(Test_B_BFu16ll_Ul, "B_BFu16ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_Us  {
  bool v1;
  __tsu64 v2:16;
  unsigned short v3;
};
//SIG(1 B_BFu16ll_Us) C1{ Fc FL:16 Fs}



static void Test_B_BFu16ll_Us()
{
  {
    init_simple_test("B_BFu16ll_Us");
    static B_BFu16ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_Us");
    check_field_offset(lv, v3, 4, "B_BFu16ll_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_Us(Test_B_BFu16ll_Us, "B_BFu16ll_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16ll_Vp  {
  bool v1;
  __tsu64 v2:16;
  void *v3;
};
//SIG(1 B_BFu16ll_Vp) C1{ Fc FL:16 Fp}



static void Test_B_BFu16ll_Vp()
{
  {
    init_simple_test("B_BFu16ll_Vp");
    static B_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu16ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "B_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "B_BFu16ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16ll_Vp(Test_B_BFu16ll_Vp, "B_BFu16ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s  {
  bool v1;
  unsigned short v2:16;
};
//SIG(1 B_BFu16s) C1{ Fc Fs:16}



static void Test_B_BFu16s()
{
  {
    init_simple_test("B_BFu16s");
    static B_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu16s(Test_B_BFu16s, "B_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_B  {
  bool v1;
  unsigned short v2:16;
  bool v3;
};
//SIG(1 B_BFu16s_B) C1{ Fc Fs:16 Fc}



static void Test_B_BFu16s_B()
{
  {
    init_simple_test("B_BFu16s_B");
    static B_BFu16s_B lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu16s_B)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s_B)");
    check_field_offset(lv, v1, 0, "B_BFu16s_B.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_B");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_B");
    check_field_offset(lv, v3, 4, "B_BFu16s_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16s_B(Test_B_BFu16s_B, "B_BFu16s_B", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu15i  {
  bool v1;
  unsigned short v2:16;
  unsigned int v3:15;
};
//SIG(1 B_BFu16s_BFu15i) C1{ Fc Fs:16 Fi:15}



static void Test_B_BFu16s_BFu15i()
{
  {
    init_simple_test("B_BFu16s_BFu15i");
    static B_BFu16s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu16s_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu15i(Test_B_BFu16s_BFu15i, "B_BFu16s_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu15ll  {
  bool v1;
  unsigned short v2:16;
  __tsu64 v3:15;
};
//SIG(1 B_BFu16s_BFu15ll) C1{ Fc Fs:16 FL:15}



static void Test_B_BFu16s_BFu15ll()
{
  {
    init_simple_test("B_BFu16s_BFu15ll");
    static B_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu16s_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu15ll(Test_B_BFu16s_BFu15ll, "B_BFu16s_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu15s  {
  bool v1;
  unsigned short v2:16;
  unsigned short v3:15;
};
//SIG(1 B_BFu16s_BFu15s) C1{ Fc Fs:16 Fs:15}



static void Test_B_BFu16s_BFu15s()
{
  {
    init_simple_test("B_BFu16s_BFu15s");
    static B_BFu16s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu16s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu16s_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu15s(Test_B_BFu16s_BFu15s, "B_BFu16s_BFu15s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu16i  {
  bool v1;
  unsigned short v2:16;
  unsigned int v3:16;
};
//SIG(1 B_BFu16s_BFu16i) C1{ Fc Fs:16 Fi:16}



static void Test_B_BFu16s_BFu16i()
{
  {
    init_simple_test("B_BFu16s_BFu16i");
    static B_BFu16s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu16i(Test_B_BFu16s_BFu16i, "B_BFu16s_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu16ll  {
  bool v1;
  unsigned short v2:16;
  __tsu64 v3:16;
};
//SIG(1 B_BFu16s_BFu16ll) C1{ Fc Fs:16 FL:16}



static void Test_B_BFu16s_BFu16ll()
{
  {
    init_simple_test("B_BFu16s_BFu16ll");
    static B_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu16ll(Test_B_BFu16s_BFu16ll, "B_BFu16s_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu16s  {
  bool v1;
  unsigned short v2:16;
  unsigned short v3:16;
};
//SIG(1 B_BFu16s_BFu16s) C1{ Fc Fs:16 Fs:16}



static void Test_B_BFu16s_BFu16s()
{
  {
    init_simple_test("B_BFu16s_BFu16s");
    static B_BFu16s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu16s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu16s(Test_B_BFu16s_BFu16s, "B_BFu16s_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu17i  {
  bool v1;
  unsigned short v2:16;
  unsigned int v3:17;
};
//SIG(1 B_BFu16s_BFu17i) C1{ Fc Fs:16 Fi:17}



static void Test_B_BFu16s_BFu17i()
{
  {
    init_simple_test("B_BFu16s_BFu17i");
    static B_BFu16s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu16s_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu17i(Test_B_BFu16s_BFu17i, "B_BFu16s_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu17ll  {
  bool v1;
  unsigned short v2:16;
  __tsu64 v3:17;
};
//SIG(1 B_BFu16s_BFu17ll) C1{ Fc Fs:16 FL:17}



static void Test_B_BFu16s_BFu17ll()
{
  {
    init_simple_test("B_BFu16s_BFu17ll");
    static B_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu16s_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu17ll(Test_B_BFu16s_BFu17ll, "B_BFu16s_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu1c  {
  bool v1;
  unsigned short v2:16;
  unsigned char v3:1;
};
//SIG(1 B_BFu16s_BFu1c) C1{ Fc Fs:16 Fc:1}



static void Test_B_BFu16s_BFu1c()
{
  {
    init_simple_test("B_BFu16s_BFu1c");
    static B_BFu16s_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu16s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "B_BFu16s_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu1c(Test_B_BFu16s_BFu1c, "B_BFu16s_BFu1c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu1i  {
  bool v1;
  unsigned short v2:16;
  unsigned int v3:1;
};
//SIG(1 B_BFu16s_BFu1i) C1{ Fc Fs:16 Fi:1}



static void Test_B_BFu16s_BFu1i()
{
  {
    init_simple_test("B_BFu16s_BFu1i");
    static B_BFu16s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "B_BFu16s_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu1i(Test_B_BFu16s_BFu1i, "B_BFu16s_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu1ll  {
  bool v1;
  unsigned short v2:16;
  __tsu64 v3:1;
};
//SIG(1 B_BFu16s_BFu1ll) C1{ Fc Fs:16 FL:1}



static void Test_B_BFu16s_BFu1ll()
{
  {
    init_simple_test("B_BFu16s_BFu1ll");
    static B_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "B_BFu16s_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu1ll(Test_B_BFu16s_BFu1ll, "B_BFu16s_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu1s  {
  bool v1;
  unsigned short v2:16;
  unsigned short v3:1;
};
//SIG(1 B_BFu16s_BFu1s) C1{ Fc Fs:16 Fs:1}



static void Test_B_BFu16s_BFu1s()
{
  {
    init_simple_test("B_BFu16s_BFu1s");
    static B_BFu16s_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu16s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "B_BFu16s_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu1s(Test_B_BFu16s_BFu1s, "B_BFu16s_BFu1s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu31i  {
  bool v1;
  unsigned short v2:16;
  unsigned int v3:31;
};
//SIG(1 B_BFu16s_BFu31i) C1{ Fc Fs:16 Fi:31}



static void Test_B_BFu16s_BFu31i()
{
  {
    init_simple_test("B_BFu16s_BFu31i");
    static B_BFu16s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu16s_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu31i(Test_B_BFu16s_BFu31i, "B_BFu16s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu31ll  {
  bool v1;
  unsigned short v2:16;
  __tsu64 v3:31;
};
//SIG(1 B_BFu16s_BFu31ll) C1{ Fc Fs:16 FL:31}



static void Test_B_BFu16s_BFu31ll()
{
  {
    init_simple_test("B_BFu16s_BFu31ll");
    static B_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu16s_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu31ll(Test_B_BFu16s_BFu31ll, "B_BFu16s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu32i  {
  bool v1;
  unsigned short v2:16;
  unsigned int v3:32;
};
//SIG(1 B_BFu16s_BFu32i) C1{ Fc Fs:16 Fi:32}



static void Test_B_BFu16s_BFu32i()
{
  {
    init_simple_test("B_BFu16s_BFu32i");
    static B_BFu16s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu16s_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu32i(Test_B_BFu16s_BFu32i, "B_BFu16s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu32ll  {
  bool v1;
  unsigned short v2:16;
  __tsu64 v3:32;
};
//SIG(1 B_BFu16s_BFu32ll) C1{ Fc Fs:16 FL:32}



static void Test_B_BFu16s_BFu32ll()
{
  {
    init_simple_test("B_BFu16s_BFu32ll");
    static B_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu16s_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu32ll(Test_B_BFu16s_BFu32ll, "B_BFu16s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu33  {
  bool v1;
  unsigned short v2:16;
  __tsu64 v3:33;
};
//SIG(1 B_BFu16s_BFu33) C1{ Fc Fs:16 FL:33}



static void Test_B_BFu16s_BFu33()
{
  {
    init_simple_test("B_BFu16s_BFu33");
    static B_BFu16s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu16s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "B_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "B_BFu16s_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu33(Test_B_BFu16s_BFu33, "B_BFu16s_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu7c  {
  bool v1;
  unsigned short v2:16;
  unsigned char v3:7;
};
//SIG(1 B_BFu16s_BFu7c) C1{ Fc Fs:16 Fc:7}



static void Test_B_BFu16s_BFu7c()
{
  {
    init_simple_test("B_BFu16s_BFu7c");
    static B_BFu16s_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu16s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "B_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "B_BFu16s_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu7c(Test_B_BFu16s_BFu7c, "B_BFu16s_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu7i  {
  bool v1;
  unsigned short v2:16;
  unsigned int v3:7;
};
//SIG(1 B_BFu16s_BFu7i) C1{ Fc Fs:16 Fi:7}



static void Test_B_BFu16s_BFu7i()
{
  {
    init_simple_test("B_BFu16s_BFu7i");
    static B_BFu16s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "B_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "B_BFu16s_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu7i(Test_B_BFu16s_BFu7i, "B_BFu16s_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu7ll  {
  bool v1;
  unsigned short v2:16;
  __tsu64 v3:7;
};
//SIG(1 B_BFu16s_BFu7ll) C1{ Fc Fs:16 FL:7}



static void Test_B_BFu16s_BFu7ll()
{
  {
    init_simple_test("B_BFu16s_BFu7ll");
    static B_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "B_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "B_BFu16s_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu7ll(Test_B_BFu16s_BFu7ll, "B_BFu16s_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu7s  {
  bool v1;
  unsigned short v2:16;
  unsigned short v3:7;
};
//SIG(1 B_BFu16s_BFu7s) C1{ Fc Fs:16 Fs:7}



static void Test_B_BFu16s_BFu7s()
{
  {
    init_simple_test("B_BFu16s_BFu7s");
    static B_BFu16s_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu16s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "B_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "B_BFu16s_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu7s(Test_B_BFu16s_BFu7s, "B_BFu16s_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu8c  {
  bool v1;
  unsigned short v2:16;
  unsigned char v3:8;
};
//SIG(1 B_BFu16s_BFu8c) C1{ Fc Fs:16 Fc:8}



static void Test_B_BFu16s_BFu8c()
{
  {
    init_simple_test("B_BFu16s_BFu8c");
    static B_BFu16s_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu16s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "B_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "B_BFu16s_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu8c(Test_B_BFu16s_BFu8c, "B_BFu16s_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu8i  {
  bool v1;
  unsigned short v2:16;
  unsigned int v3:8;
};
//SIG(1 B_BFu16s_BFu8i) C1{ Fc Fs:16 Fi:8}



static void Test_B_BFu16s_BFu8i()
{
  {
    init_simple_test("B_BFu16s_BFu8i");
    static B_BFu16s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "B_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "B_BFu16s_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu8i(Test_B_BFu16s_BFu8i, "B_BFu16s_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu8ll  {
  bool v1;
  unsigned short v2:16;
  __tsu64 v3:8;
};
//SIG(1 B_BFu16s_BFu8ll) C1{ Fc Fs:16 FL:8}



static void Test_B_BFu16s_BFu8ll()
{
  {
    init_simple_test("B_BFu16s_BFu8ll");
    static B_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "B_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "B_BFu16s_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu8ll(Test_B_BFu16s_BFu8ll, "B_BFu16s_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu8s  {
  bool v1;
  unsigned short v2:16;
  unsigned short v3:8;
};
//SIG(1 B_BFu16s_BFu8s) C1{ Fc Fs:16 Fs:8}



static void Test_B_BFu16s_BFu8s()
{
  {
    init_simple_test("B_BFu16s_BFu8s");
    static B_BFu16s_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu16s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "B_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "B_BFu16s_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu8s(Test_B_BFu16s_BFu8s, "B_BFu16s_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu9i  {
  bool v1;
  unsigned short v2:16;
  unsigned int v3:9;
};
//SIG(1 B_BFu16s_BFu9i) C1{ Fc Fs:16 Fi:9}



static void Test_B_BFu16s_BFu9i()
{
  {
    init_simple_test("B_BFu16s_BFu9i");
    static B_BFu16s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "B_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "B_BFu16s_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu9i(Test_B_BFu16s_BFu9i, "B_BFu16s_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu9ll  {
  bool v1;
  unsigned short v2:16;
  __tsu64 v3:9;
};
//SIG(1 B_BFu16s_BFu9ll) C1{ Fc Fs:16 FL:9}



static void Test_B_BFu16s_BFu9ll()
{
  {
    init_simple_test("B_BFu16s_BFu9ll");
    static B_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "B_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "B_BFu16s_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu9ll(Test_B_BFu16s_BFu9ll, "B_BFu16s_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_BFu9s  {
  bool v1;
  unsigned short v2:16;
  unsigned short v3:9;
};
//SIG(1 B_BFu16s_BFu9s) C1{ Fc Fs:16 Fs:9}



static void Test_B_BFu16s_BFu9s()
{
  {
    init_simple_test("B_BFu16s_BFu9s");
    static B_BFu16s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu16s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "B_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "B_BFu16s_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu16s_BFu9s(Test_B_BFu16s_BFu9s, "B_BFu16s_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_C  {
  bool v1;
  unsigned short v2:16;
  char v3;
};
//SIG(1 B_BFu16s_C) C1{ Fc Fs:16 Fc}



static void Test_B_BFu16s_C()
{
  {
    init_simple_test("B_BFu16s_C");
    static B_BFu16s_C lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu16s_C)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s_C)");
    check_field_offset(lv, v1, 0, "B_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_C");
    check_field_offset(lv, v3, 4, "B_BFu16s_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16s_C(Test_B_BFu16s_C, "B_BFu16s_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_D  {
  bool v1;
  unsigned short v2:16;
  double v3;
};
//SIG(1 B_BFu16s_D) C1{ Fc Fs:16 FL}



static void Test_B_BFu16s_D()
{
  {
    init_simple_test("B_BFu16s_D");
    static B_BFu16s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu16s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_D)");
    check_field_offset(lv, v1, 0, "B_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16s_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16s_D(Test_B_BFu16s_D, "B_BFu16s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_F  {
  bool v1;
  unsigned short v2:16;
  float v3;
};
//SIG(1 B_BFu16s_F) C1{ Fc Fs:16 Fi}



static void Test_B_BFu16s_F()
{
  {
    init_simple_test("B_BFu16s_F");
    static B_BFu16s_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16s_F)");
    check_field_offset(lv, v1, 0, "B_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_F");
    check_field_offset(lv, v3, 4, "B_BFu16s_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16s_F(Test_B_BFu16s_F, "B_BFu16s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_I  {
  bool v1;
  unsigned short v2:16;
  int v3;
};
//SIG(1 B_BFu16s_I) C1{ Fc Fs:16 Fi}



static void Test_B_BFu16s_I()
{
  {
    init_simple_test("B_BFu16s_I");
    static B_BFu16s_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16s_I)");
    check_field_offset(lv, v1, 0, "B_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_I");
    check_field_offset(lv, v3, 4, "B_BFu16s_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16s_I(Test_B_BFu16s_I, "B_BFu16s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_Ip  {
  bool v1;
  unsigned short v2:16;
  int *v3;
};
//SIG(1 B_BFu16s_Ip) C1{ Fc Fs:16 Fp}



static void Test_B_BFu16s_Ip()
{
  {
    init_simple_test("B_BFu16s_Ip");
    static B_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu16s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16s_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16s_Ip(Test_B_BFu16s_Ip, "B_BFu16s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_L  {
  bool v1;
  unsigned short v2:16;
  __tsi64 v3;
};
//SIG(1 B_BFu16s_L) C1{ Fc Fs:16 FL}



static void Test_B_BFu16s_L()
{
  {
    init_simple_test("B_BFu16s_L");
    static B_BFu16s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu16s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_L)");
    check_field_offset(lv, v1, 0, "B_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16s_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16s_L(Test_B_BFu16s_L, "B_BFu16s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_S  {
  bool v1;
  unsigned short v2:16;
  short v3;
};
//SIG(1 B_BFu16s_S) C1{ Fc Fs:16 Fs}



static void Test_B_BFu16s_S()
{
  {
    init_simple_test("B_BFu16s_S");
    static B_BFu16s_S lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu16s_S)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s_S)");
    check_field_offset(lv, v1, 0, "B_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_S");
    check_field_offset(lv, v3, 4, "B_BFu16s_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16s_S(Test_B_BFu16s_S, "B_BFu16s_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_Uc  {
  bool v1;
  unsigned short v2:16;
  unsigned char v3;
};
//SIG(1 B_BFu16s_Uc) C1{ Fc Fs:16 Fc}



static void Test_B_BFu16s_Uc()
{
  {
    init_simple_test("B_BFu16s_Uc");
    static B_BFu16s_Uc lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu16s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_Uc");
    check_field_offset(lv, v3, 4, "B_BFu16s_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16s_Uc(Test_B_BFu16s_Uc, "B_BFu16s_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_Ui  {
  bool v1;
  unsigned short v2:16;
  unsigned int v3;
};
//SIG(1 B_BFu16s_Ui) C1{ Fc Fs:16 Fi}



static void Test_B_BFu16s_Ui()
{
  {
    init_simple_test("B_BFu16s_Ui");
    static B_BFu16s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu16s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_Ui");
    check_field_offset(lv, v3, 4, "B_BFu16s_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16s_Ui(Test_B_BFu16s_Ui, "B_BFu16s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_Ul  {
  bool v1;
  unsigned short v2:16;
  __tsu64 v3;
};
//SIG(1 B_BFu16s_Ul) C1{ Fc Fs:16 FL}



static void Test_B_BFu16s_Ul()
{
  {
    init_simple_test("B_BFu16s_Ul");
    static B_BFu16s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu16s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16s_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16s_Ul(Test_B_BFu16s_Ul, "B_BFu16s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_Us  {
  bool v1;
  unsigned short v2:16;
  unsigned short v3;
};
//SIG(1 B_BFu16s_Us) C1{ Fc Fs:16 Fs}



static void Test_B_BFu16s_Us()
{
  {
    init_simple_test("B_BFu16s_Us");
    static B_BFu16s_Us lv;
    check2(sizeof(lv), 6, "sizeof(B_BFu16s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "B_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_Us");
    check_field_offset(lv, v3, 4, "B_BFu16s_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16s_Us(Test_B_BFu16s_Us, "B_BFu16s_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu16s_Vp  {
  bool v1;
  unsigned short v2:16;
  void *v3;
};
//SIG(1 B_BFu16s_Vp) C1{ Fc Fs:16 Fp}



static void Test_B_BFu16s_Vp()
{
  {
    init_simple_test("B_BFu16s_Vp");
    static B_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu16s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "B_BFu16s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "B_BFu16s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu16s_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu16s_Vp(Test_B_BFu16s_Vp, "B_BFu16s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i  {
  bool v1;
  unsigned int v2:17;
};
//SIG(1 B_BFu17i) C1{ Fc Fi:17}



static void Test_B_BFu17i()
{
  {
    init_simple_test("B_BFu17i");
    static B_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu17i(Test_B_BFu17i, "B_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_B  {
  bool v1;
  unsigned int v2:17;
  bool v3;
};
//SIG(1 B_BFu17i_B) C1{ Fc Fi:17 Fc}



static void Test_B_BFu17i_B()
{
  {
    init_simple_test("B_BFu17i_B");
    static B_BFu17i_B lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_B)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_B)");
    check_field_offset(lv, v1, 0, "B_BFu17i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_B");
    check_field_offset(lv, v3, 4, "B_BFu17i_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17i_B(Test_B_BFu17i_B, "B_BFu17i_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu15i  {
  bool v1;
  unsigned int v2:17;
  unsigned int v3:15;
};
//SIG(1 B_BFu17i_BFu15i) C1{ Fc Fi:17 Fi:15}



static void Test_B_BFu17i_BFu15i()
{
  {
    init_simple_test("B_BFu17i_BFu15i");
    static B_BFu17i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu17i_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu15i(Test_B_BFu17i_BFu15i, "B_BFu17i_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu15ll  {
  bool v1;
  unsigned int v2:17;
  __tsu64 v3:15;
};
//SIG(1 B_BFu17i_BFu15ll) C1{ Fc Fi:17 FL:15}



static void Test_B_BFu17i_BFu15ll()
{
  {
    init_simple_test("B_BFu17i_BFu15ll");
    static B_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "B_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "B_BFu17i_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu15ll(Test_B_BFu17i_BFu15ll, "B_BFu17i_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu15s  {
  bool v1;
  unsigned int v2:17;
  unsigned short v3:15;
};
//SIG(1 B_BFu17i_BFu15s) C1{ Fc Fi:17 Fs:15}



static void Test_B_BFu17i_BFu15s()
{
  {
    init_simple_test("B_BFu17i_BFu15s");
    static B_BFu17i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu17i_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu15s(Test_B_BFu17i_BFu15s, "B_BFu17i_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu16i  {
  bool v1;
  unsigned int v2:17;
  unsigned int v3:16;
};
//SIG(1 B_BFu17i_BFu16i) C1{ Fc Fi:17 Fi:16}



static void Test_B_BFu17i_BFu16i()
{
  {
    init_simple_test("B_BFu17i_BFu16i");
    static B_BFu17i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu17i_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu16i(Test_B_BFu17i_BFu16i, "B_BFu17i_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu16ll  {
  bool v1;
  unsigned int v2:17;
  __tsu64 v3:16;
};
//SIG(1 B_BFu17i_BFu16ll) C1{ Fc Fi:17 FL:16}



static void Test_B_BFu17i_BFu16ll()
{
  {
    init_simple_test("B_BFu17i_BFu16ll");
    static B_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "B_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "B_BFu17i_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu16ll(Test_B_BFu17i_BFu16ll, "B_BFu17i_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu16s  {
  bool v1;
  unsigned int v2:17;
  unsigned short v3:16;
};
//SIG(1 B_BFu17i_BFu16s) C1{ Fc Fi:17 Fs:16}



static void Test_B_BFu17i_BFu16s()
{
  {
    init_simple_test("B_BFu17i_BFu16s");
    static B_BFu17i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu17i_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu16s(Test_B_BFu17i_BFu16s, "B_BFu17i_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu17i  {
  bool v1;
  unsigned int v2:17;
  unsigned int v3:17;
};
//SIG(1 B_BFu17i_BFu17i) C1{ Fc Fi:17 Fi:17}



static void Test_B_BFu17i_BFu17i()
{
  {
    init_simple_test("B_BFu17i_BFu17i");
    static B_BFu17i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu17i(Test_B_BFu17i_BFu17i, "B_BFu17i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu17ll  {
  bool v1;
  unsigned int v2:17;
  __tsu64 v3:17;
};
//SIG(1 B_BFu17i_BFu17ll) C1{ Fc Fi:17 FL:17}



static void Test_B_BFu17i_BFu17ll()
{
  {
    init_simple_test("B_BFu17i_BFu17ll");
    static B_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "B_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "B_BFu17i_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu17ll(Test_B_BFu17i_BFu17ll, "B_BFu17i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu1c  {
  bool v1;
  unsigned int v2:17;
  unsigned char v3:1;
};
//SIG(1 B_BFu17i_BFu1c) C1{ Fc Fi:17 Fc:1}



static void Test_B_BFu17i_BFu1c()
{
  {
    init_simple_test("B_BFu17i_BFu1c");
    static B_BFu17i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu17i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "B_BFu17i_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu1c(Test_B_BFu17i_BFu1c, "B_BFu17i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu1i  {
  bool v1;
  unsigned int v2:17;
  unsigned int v3:1;
};
//SIG(1 B_BFu17i_BFu1i) C1{ Fc Fi:17 Fi:1}



static void Test_B_BFu17i_BFu1i()
{
  {
    init_simple_test("B_BFu17i_BFu1i");
    static B_BFu17i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu17i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "B_BFu17i_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu1i(Test_B_BFu17i_BFu1i, "B_BFu17i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu1ll  {
  bool v1;
  unsigned int v2:17;
  __tsu64 v3:1;
};
//SIG(1 B_BFu17i_BFu1ll) C1{ Fc Fi:17 FL:1}



static void Test_B_BFu17i_BFu1ll()
{
  {
    init_simple_test("B_BFu17i_BFu1ll");
    static B_BFu17i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu17i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "B_BFu17i_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu1ll(Test_B_BFu17i_BFu1ll, "B_BFu17i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu1s  {
  bool v1;
  unsigned int v2:17;
  unsigned short v3:1;
};
//SIG(1 B_BFu17i_BFu1s) C1{ Fc Fi:17 Fs:1}



static void Test_B_BFu17i_BFu1s()
{
  {
    init_simple_test("B_BFu17i_BFu1s");
    static B_BFu17i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu17i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "B_BFu17i_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu1s(Test_B_BFu17i_BFu1s, "B_BFu17i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu31i  {
  bool v1;
  unsigned int v2:17;
  unsigned int v3:31;
};
//SIG(1 B_BFu17i_BFu31i) C1{ Fc Fi:17 Fi:31}



static void Test_B_BFu17i_BFu31i()
{
  {
    init_simple_test("B_BFu17i_BFu31i");
    static B_BFu17i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu17i_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu31i(Test_B_BFu17i_BFu31i, "B_BFu17i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu31ll  {
  bool v1;
  unsigned int v2:17;
  __tsu64 v3:31;
};
//SIG(1 B_BFu17i_BFu31ll) C1{ Fc Fi:17 FL:31}



static void Test_B_BFu17i_BFu31ll()
{
  {
    init_simple_test("B_BFu17i_BFu31ll");
    static B_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "B_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "B_BFu17i_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu31ll(Test_B_BFu17i_BFu31ll, "B_BFu17i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu32i  {
  bool v1;
  unsigned int v2:17;
  unsigned int v3:32;
};
//SIG(1 B_BFu17i_BFu32i) C1{ Fc Fi:17 Fi:32}



static void Test_B_BFu17i_BFu32i()
{
  {
    init_simple_test("B_BFu17i_BFu32i");
    static B_BFu17i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu17i_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu32i(Test_B_BFu17i_BFu32i, "B_BFu17i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu32ll  {
  bool v1;
  unsigned int v2:17;
  __tsu64 v3:32;
};
//SIG(1 B_BFu17i_BFu32ll) C1{ Fc Fi:17 FL:32}



static void Test_B_BFu17i_BFu32ll()
{
  {
    init_simple_test("B_BFu17i_BFu32ll");
    static B_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "B_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "B_BFu17i_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu32ll(Test_B_BFu17i_BFu32ll, "B_BFu17i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu33  {
  bool v1;
  unsigned int v2:17;
  __tsu64 v3:33;
};
//SIG(1 B_BFu17i_BFu33) C1{ Fc Fi:17 FL:33}



static void Test_B_BFu17i_BFu33()
{
  {
    init_simple_test("B_BFu17i_BFu33");
    static B_BFu17i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "B_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "B_BFu17i_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu33(Test_B_BFu17i_BFu33, "B_BFu17i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu7c  {
  bool v1;
  unsigned int v2:17;
  unsigned char v3:7;
};
//SIG(1 B_BFu17i_BFu7c) C1{ Fc Fi:17 Fc:7}



static void Test_B_BFu17i_BFu7c()
{
  {
    init_simple_test("B_BFu17i_BFu7c");
    static B_BFu17i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu17i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "B_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "B_BFu17i_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu7c(Test_B_BFu17i_BFu7c, "B_BFu17i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu7i  {
  bool v1;
  unsigned int v2:17;
  unsigned int v3:7;
};
//SIG(1 B_BFu17i_BFu7i) C1{ Fc Fi:17 Fi:7}



static void Test_B_BFu17i_BFu7i()
{
  {
    init_simple_test("B_BFu17i_BFu7i");
    static B_BFu17i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu17i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "B_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "B_BFu17i_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu7i(Test_B_BFu17i_BFu7i, "B_BFu17i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu7ll  {
  bool v1;
  unsigned int v2:17;
  __tsu64 v3:7;
};
//SIG(1 B_BFu17i_BFu7ll) C1{ Fc Fi:17 FL:7}



static void Test_B_BFu17i_BFu7ll()
{
  {
    init_simple_test("B_BFu17i_BFu7ll");
    static B_BFu17i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu17i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "B_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "B_BFu17i_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu7ll(Test_B_BFu17i_BFu7ll, "B_BFu17i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu7s  {
  bool v1;
  unsigned int v2:17;
  unsigned short v3:7;
};
//SIG(1 B_BFu17i_BFu7s) C1{ Fc Fi:17 Fs:7}



static void Test_B_BFu17i_BFu7s()
{
  {
    init_simple_test("B_BFu17i_BFu7s");
    static B_BFu17i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu17i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "B_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "B_BFu17i_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu7s(Test_B_BFu17i_BFu7s, "B_BFu17i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu8c  {
  bool v1;
  unsigned int v2:17;
  unsigned char v3:8;
};
//SIG(1 B_BFu17i_BFu8c) C1{ Fc Fi:17 Fc:8}



static void Test_B_BFu17i_BFu8c()
{
  {
    init_simple_test("B_BFu17i_BFu8c");
    static B_BFu17i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "B_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "B_BFu17i_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu8c(Test_B_BFu17i_BFu8c, "B_BFu17i_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu8i  {
  bool v1;
  unsigned int v2:17;
  unsigned int v3:8;
};
//SIG(1 B_BFu17i_BFu8i) C1{ Fc Fi:17 Fi:8}



static void Test_B_BFu17i_BFu8i()
{
  {
    init_simple_test("B_BFu17i_BFu8i");
    static B_BFu17i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "B_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "B_BFu17i_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu8i(Test_B_BFu17i_BFu8i, "B_BFu17i_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu8ll  {
  bool v1;
  unsigned int v2:17;
  __tsu64 v3:8;
};
//SIG(1 B_BFu17i_BFu8ll) C1{ Fc Fi:17 FL:8}



static void Test_B_BFu17i_BFu8ll()
{
  {
    init_simple_test("B_BFu17i_BFu8ll");
    static B_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "B_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "B_BFu17i_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu8ll(Test_B_BFu17i_BFu8ll, "B_BFu17i_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu8s  {
  bool v1;
  unsigned int v2:17;
  unsigned short v3:8;
};
//SIG(1 B_BFu17i_BFu8s) C1{ Fc Fi:17 Fs:8}



static void Test_B_BFu17i_BFu8s()
{
  {
    init_simple_test("B_BFu17i_BFu8s");
    static B_BFu17i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "B_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "B_BFu17i_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu8s(Test_B_BFu17i_BFu8s, "B_BFu17i_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu9i  {
  bool v1;
  unsigned int v2:17;
  unsigned int v3:9;
};
//SIG(1 B_BFu17i_BFu9i) C1{ Fc Fi:17 Fi:9}



static void Test_B_BFu17i_BFu9i()
{
  {
    init_simple_test("B_BFu17i_BFu9i");
    static B_BFu17i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "B_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "B_BFu17i_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu9i(Test_B_BFu17i_BFu9i, "B_BFu17i_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu9ll  {
  bool v1;
  unsigned int v2:17;
  __tsu64 v3:9;
};
//SIG(1 B_BFu17i_BFu9ll) C1{ Fc Fi:17 FL:9}



static void Test_B_BFu17i_BFu9ll()
{
  {
    init_simple_test("B_BFu17i_BFu9ll");
    static B_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "B_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "B_BFu17i_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu9ll(Test_B_BFu17i_BFu9ll, "B_BFu17i_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_BFu9s  {
  bool v1;
  unsigned int v2:17;
  unsigned short v3:9;
};
//SIG(1 B_BFu17i_BFu9s) C1{ Fc Fi:17 Fs:9}



static void Test_B_BFu17i_BFu9s()
{
  {
    init_simple_test("B_BFu17i_BFu9s");
    static B_BFu17i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "B_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "B_BFu17i_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu17i_BFu9s(Test_B_BFu17i_BFu9s, "B_BFu17i_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_C  {
  bool v1;
  unsigned int v2:17;
  char v3;
};
//SIG(1 B_BFu17i_C) C1{ Fc Fi:17 Fc}



static void Test_B_BFu17i_C()
{
  {
    init_simple_test("B_BFu17i_C");
    static B_BFu17i_C lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_C)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_C)");
    check_field_offset(lv, v1, 0, "B_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_C");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_C");
    check_field_offset(lv, v3, 4, "B_BFu17i_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17i_C(Test_B_BFu17i_C, "B_BFu17i_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_D  {
  bool v1;
  unsigned int v2:17;
  double v3;
};
//SIG(1 B_BFu17i_D) C1{ Fc Fi:17 FL}



static void Test_B_BFu17i_D()
{
  {
    init_simple_test("B_BFu17i_D");
    static B_BFu17i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu17i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_D)");
    check_field_offset(lv, v1, 0, "B_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_D");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu17i_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17i_D(Test_B_BFu17i_D, "B_BFu17i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_F  {
  bool v1;
  unsigned int v2:17;
  float v3;
};
//SIG(1 B_BFu17i_F) C1{ Fc Fi:17 Fi}



static void Test_B_BFu17i_F()
{
  {
    init_simple_test("B_BFu17i_F");
    static B_BFu17i_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_F)");
    check_field_offset(lv, v1, 0, "B_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_F");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_F");
    check_field_offset(lv, v3, 4, "B_BFu17i_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17i_F(Test_B_BFu17i_F, "B_BFu17i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_I  {
  bool v1;
  unsigned int v2:17;
  int v3;
};
//SIG(1 B_BFu17i_I) C1{ Fc Fi:17 Fi}



static void Test_B_BFu17i_I()
{
  {
    init_simple_test("B_BFu17i_I");
    static B_BFu17i_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_I)");
    check_field_offset(lv, v1, 0, "B_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_I");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_I");
    check_field_offset(lv, v3, 4, "B_BFu17i_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17i_I(Test_B_BFu17i_I, "B_BFu17i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_Ip  {
  bool v1;
  unsigned int v2:17;
  int *v3;
};
//SIG(1 B_BFu17i_Ip) C1{ Fc Fi:17 Fp}



static void Test_B_BFu17i_Ip()
{
  {
    init_simple_test("B_BFu17i_Ip");
    static B_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu17i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu17i_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17i_Ip(Test_B_BFu17i_Ip, "B_BFu17i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_L  {
  bool v1;
  unsigned int v2:17;
  __tsi64 v3;
};
//SIG(1 B_BFu17i_L) C1{ Fc Fi:17 FL}



static void Test_B_BFu17i_L()
{
  {
    init_simple_test("B_BFu17i_L");
    static B_BFu17i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu17i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_L)");
    check_field_offset(lv, v1, 0, "B_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_L");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu17i_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17i_L(Test_B_BFu17i_L, "B_BFu17i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_S  {
  bool v1;
  unsigned int v2:17;
  short v3;
};
//SIG(1 B_BFu17i_S) C1{ Fc Fi:17 Fs}



static void Test_B_BFu17i_S()
{
  {
    init_simple_test("B_BFu17i_S");
    static B_BFu17i_S lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_S)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_S)");
    check_field_offset(lv, v1, 0, "B_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_S");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_S");
    check_field_offset(lv, v3, 4, "B_BFu17i_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17i_S(Test_B_BFu17i_S, "B_BFu17i_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_Uc  {
  bool v1;
  unsigned int v2:17;
  unsigned char v3;
};
//SIG(1 B_BFu17i_Uc) C1{ Fc Fi:17 Fc}



static void Test_B_BFu17i_Uc()
{
  {
    init_simple_test("B_BFu17i_Uc");
    static B_BFu17i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_Uc");
    check_field_offset(lv, v3, 4, "B_BFu17i_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17i_Uc(Test_B_BFu17i_Uc, "B_BFu17i_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_Ui  {
  bool v1;
  unsigned int v2:17;
  unsigned int v3;
};
//SIG(1 B_BFu17i_Ui) C1{ Fc Fi:17 Fi}



static void Test_B_BFu17i_Ui()
{
  {
    init_simple_test("B_BFu17i_Ui");
    static B_BFu17i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_Ui");
    check_field_offset(lv, v3, 4, "B_BFu17i_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17i_Ui(Test_B_BFu17i_Ui, "B_BFu17i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_Ul  {
  bool v1;
  unsigned int v2:17;
  __tsu64 v3;
};
//SIG(1 B_BFu17i_Ul) C1{ Fc Fi:17 FL}



static void Test_B_BFu17i_Ul()
{
  {
    init_simple_test("B_BFu17i_Ul");
    static B_BFu17i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu17i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu17i_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17i_Ul(Test_B_BFu17i_Ul, "B_BFu17i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_Us  {
  bool v1;
  unsigned int v2:17;
  unsigned short v3;
};
//SIG(1 B_BFu17i_Us) C1{ Fc Fi:17 Fs}



static void Test_B_BFu17i_Us()
{
  {
    init_simple_test("B_BFu17i_Us");
    static B_BFu17i_Us lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "B_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_Us");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_Us");
    check_field_offset(lv, v3, 4, "B_BFu17i_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17i_Us(Test_B_BFu17i_Us, "B_BFu17i_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17i_Vp  {
  bool v1;
  unsigned int v2:17;
  void *v3;
};
//SIG(1 B_BFu17i_Vp) C1{ Fc Fi:17 Fp}



static void Test_B_BFu17i_Vp()
{
  {
    init_simple_test("B_BFu17i_Vp");
    static B_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu17i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu17i_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17i_Vp(Test_B_BFu17i_Vp, "B_BFu17i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll  {
  bool v1;
  __tsu64 v2:17;
};
//SIG(1 B_BFu17ll) C1{ Fc FL:17}



static void Test_B_BFu17ll()
{
  {
    init_simple_test("B_BFu17ll");
    static B_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu17ll(Test_B_BFu17ll, "B_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_B  {
  bool v1;
  __tsu64 v2:17;
  bool v3;
};
//SIG(1 B_BFu17ll_B) C1{ Fc FL:17 Fc}



static void Test_B_BFu17ll_B()
{
  {
    init_simple_test("B_BFu17ll_B");
    static B_BFu17ll_B lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_B)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_B");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_B");
    check_field_offset(lv, v3, 4, "B_BFu17ll_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_B(Test_B_BFu17ll_B, "B_BFu17ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu15i  {
  bool v1;
  __tsu64 v2:17;
  unsigned int v3:15;
};
//SIG(1 B_BFu17ll_BFu15i) C1{ Fc FL:17 Fi:15}



static void Test_B_BFu17ll_BFu15i()
{
  {
    init_simple_test("B_BFu17ll_BFu15i");
    static B_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu17ll_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu15i(Test_B_BFu17ll_BFu15i, "B_BFu17ll_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu15ll  {
  bool v1;
  __tsu64 v2:17;
  __tsu64 v3:15;
};
//SIG(1 B_BFu17ll_BFu15ll) C1{ Fc FL:17 FL:15}



static void Test_B_BFu17ll_BFu15ll()
{
  {
    init_simple_test("B_BFu17ll_BFu15ll");
    static B_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "B_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "B_BFu17ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu15ll(Test_B_BFu17ll_BFu15ll, "B_BFu17ll_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu15s  {
  bool v1;
  __tsu64 v2:17;
  unsigned short v3:15;
};
//SIG(1 B_BFu17ll_BFu15s) C1{ Fc FL:17 Fs:15}



static void Test_B_BFu17ll_BFu15s()
{
  {
    init_simple_test("B_BFu17ll_BFu15s");
    static B_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "B_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "B_BFu17ll_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu15s(Test_B_BFu17ll_BFu15s, "B_BFu17ll_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu16i  {
  bool v1;
  __tsu64 v2:17;
  unsigned int v3:16;
};
//SIG(1 B_BFu17ll_BFu16i) C1{ Fc FL:17 Fi:16}



static void Test_B_BFu17ll_BFu16i()
{
  {
    init_simple_test("B_BFu17ll_BFu16i");
    static B_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu17ll_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu16i(Test_B_BFu17ll_BFu16i, "B_BFu17ll_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu16ll  {
  bool v1;
  __tsu64 v2:17;
  __tsu64 v3:16;
};
//SIG(1 B_BFu17ll_BFu16ll) C1{ Fc FL:17 FL:16}



static void Test_B_BFu17ll_BFu16ll()
{
  {
    init_simple_test("B_BFu17ll_BFu16ll");
    static B_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "B_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "B_BFu17ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu16ll(Test_B_BFu17ll_BFu16ll, "B_BFu17ll_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu16s  {
  bool v1;
  __tsu64 v2:17;
  unsigned short v3:16;
};
//SIG(1 B_BFu17ll_BFu16s) C1{ Fc FL:17 Fs:16}



static void Test_B_BFu17ll_BFu16s()
{
  {
    init_simple_test("B_BFu17ll_BFu16s");
    static B_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu17ll_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu16s(Test_B_BFu17ll_BFu16s, "B_BFu17ll_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu17i  {
  bool v1;
  __tsu64 v2:17;
  unsigned int v3:17;
};
//SIG(1 B_BFu17ll_BFu17i) C1{ Fc FL:17 Fi:17}



static void Test_B_BFu17ll_BFu17i()
{
  {
    init_simple_test("B_BFu17ll_BFu17i");
    static B_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu17i(Test_B_BFu17ll_BFu17i, "B_BFu17ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu17ll  {
  bool v1;
  __tsu64 v2:17;
  __tsu64 v3:17;
};
//SIG(1 B_BFu17ll_BFu17ll) C1{ Fc FL:17 FL:17}



static void Test_B_BFu17ll_BFu17ll()
{
  {
    init_simple_test("B_BFu17ll_BFu17ll");
    static B_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "B_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu17ll(Test_B_BFu17ll_BFu17ll, "B_BFu17ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu1c  {
  bool v1;
  __tsu64 v2:17;
  unsigned char v3:1;
};
//SIG(1 B_BFu17ll_BFu1c) C1{ Fc FL:17 Fc:1}



static void Test_B_BFu17ll_BFu1c()
{
  {
    init_simple_test("B_BFu17ll_BFu1c");
    static B_BFu17ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu17ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "B_BFu17ll_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu1c(Test_B_BFu17ll_BFu1c, "B_BFu17ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu1i  {
  bool v1;
  __tsu64 v2:17;
  unsigned int v3:1;
};
//SIG(1 B_BFu17ll_BFu1i) C1{ Fc FL:17 Fi:1}



static void Test_B_BFu17ll_BFu1i()
{
  {
    init_simple_test("B_BFu17ll_BFu1i");
    static B_BFu17ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu17ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "B_BFu17ll_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu1i(Test_B_BFu17ll_BFu1i, "B_BFu17ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu1ll  {
  bool v1;
  __tsu64 v2:17;
  __tsu64 v3:1;
};
//SIG(1 B_BFu17ll_BFu1ll) C1{ Fc FL:17 FL:1}



static void Test_B_BFu17ll_BFu1ll()
{
  {
    init_simple_test("B_BFu17ll_BFu1ll");
    static B_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "B_BFu17ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu1ll(Test_B_BFu17ll_BFu1ll, "B_BFu17ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu1s  {
  bool v1;
  __tsu64 v2:17;
  unsigned short v3:1;
};
//SIG(1 B_BFu17ll_BFu1s) C1{ Fc FL:17 Fs:1}



static void Test_B_BFu17ll_BFu1s()
{
  {
    init_simple_test("B_BFu17ll_BFu1s");
    static B_BFu17ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu17ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "B_BFu17ll_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu1s(Test_B_BFu17ll_BFu1s, "B_BFu17ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu31i  {
  bool v1;
  __tsu64 v2:17;
  unsigned int v3:31;
};
//SIG(1 B_BFu17ll_BFu31i) C1{ Fc FL:17 Fi:31}



static void Test_B_BFu17ll_BFu31i()
{
  {
    init_simple_test("B_BFu17ll_BFu31i");
    static B_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu17ll_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu31i(Test_B_BFu17ll_BFu31i, "B_BFu17ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu31ll  {
  bool v1;
  __tsu64 v2:17;
  __tsu64 v3:31;
};
//SIG(1 B_BFu17ll_BFu31ll) C1{ Fc FL:17 FL:31}



static void Test_B_BFu17ll_BFu31ll()
{
  {
    init_simple_test("B_BFu17ll_BFu31ll");
    static B_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "B_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "B_BFu17ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu31ll(Test_B_BFu17ll_BFu31ll, "B_BFu17ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu32i  {
  bool v1;
  __tsu64 v2:17;
  unsigned int v3:32;
};
//SIG(1 B_BFu17ll_BFu32i) C1{ Fc FL:17 Fi:32}



static void Test_B_BFu17ll_BFu32i()
{
  {
    init_simple_test("B_BFu17ll_BFu32i");
    static B_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu17ll_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu32i(Test_B_BFu17ll_BFu32i, "B_BFu17ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu32ll  {
  bool v1;
  __tsu64 v2:17;
  __tsu64 v3:32;
};
//SIG(1 B_BFu17ll_BFu32ll) C1{ Fc FL:17 FL:32}



static void Test_B_BFu17ll_BFu32ll()
{
  {
    init_simple_test("B_BFu17ll_BFu32ll");
    static B_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "B_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "B_BFu17ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu32ll(Test_B_BFu17ll_BFu32ll, "B_BFu17ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu33  {
  bool v1;
  __tsu64 v2:17;
  __tsu64 v3:33;
};
//SIG(1 B_BFu17ll_BFu33) C1{ Fc FL:17 FL:33}



static void Test_B_BFu17ll_BFu33()
{
  {
    init_simple_test("B_BFu17ll_BFu33");
    static B_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "B_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "B_BFu17ll_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu33(Test_B_BFu17ll_BFu33, "B_BFu17ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu7c  {
  bool v1;
  __tsu64 v2:17;
  unsigned char v3:7;
};
//SIG(1 B_BFu17ll_BFu7c) C1{ Fc FL:17 Fc:7}



static void Test_B_BFu17ll_BFu7c()
{
  {
    init_simple_test("B_BFu17ll_BFu7c");
    static B_BFu17ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu17ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "B_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "B_BFu17ll_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu7c(Test_B_BFu17ll_BFu7c, "B_BFu17ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu7i  {
  bool v1;
  __tsu64 v2:17;
  unsigned int v3:7;
};
//SIG(1 B_BFu17ll_BFu7i) C1{ Fc FL:17 Fi:7}



static void Test_B_BFu17ll_BFu7i()
{
  {
    init_simple_test("B_BFu17ll_BFu7i");
    static B_BFu17ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu17ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "B_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "B_BFu17ll_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu7i(Test_B_BFu17ll_BFu7i, "B_BFu17ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu7ll  {
  bool v1;
  __tsu64 v2:17;
  __tsu64 v3:7;
};
//SIG(1 B_BFu17ll_BFu7ll) C1{ Fc FL:17 FL:7}



static void Test_B_BFu17ll_BFu7ll()
{
  {
    init_simple_test("B_BFu17ll_BFu7ll");
    static B_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "B_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "B_BFu17ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu7ll(Test_B_BFu17ll_BFu7ll, "B_BFu17ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu7s  {
  bool v1;
  __tsu64 v2:17;
  unsigned short v3:7;
};
//SIG(1 B_BFu17ll_BFu7s) C1{ Fc FL:17 Fs:7}



static void Test_B_BFu17ll_BFu7s()
{
  {
    init_simple_test("B_BFu17ll_BFu7s");
    static B_BFu17ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu17ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "B_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "B_BFu17ll_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu7s(Test_B_BFu17ll_BFu7s, "B_BFu17ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu8c  {
  bool v1;
  __tsu64 v2:17;
  unsigned char v3:8;
};
//SIG(1 B_BFu17ll_BFu8c) C1{ Fc FL:17 Fc:8}



static void Test_B_BFu17ll_BFu8c()
{
  {
    init_simple_test("B_BFu17ll_BFu8c");
    static B_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "B_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "B_BFu17ll_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu8c(Test_B_BFu17ll_BFu8c, "B_BFu17ll_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu8i  {
  bool v1;
  __tsu64 v2:17;
  unsigned int v3:8;
};
//SIG(1 B_BFu17ll_BFu8i) C1{ Fc FL:17 Fi:8}



static void Test_B_BFu17ll_BFu8i()
{
  {
    init_simple_test("B_BFu17ll_BFu8i");
    static B_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "B_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "B_BFu17ll_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu8i(Test_B_BFu17ll_BFu8i, "B_BFu17ll_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu8ll  {
  bool v1;
  __tsu64 v2:17;
  __tsu64 v3:8;
};
//SIG(1 B_BFu17ll_BFu8ll) C1{ Fc FL:17 FL:8}



static void Test_B_BFu17ll_BFu8ll()
{
  {
    init_simple_test("B_BFu17ll_BFu8ll");
    static B_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "B_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "B_BFu17ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu8ll(Test_B_BFu17ll_BFu8ll, "B_BFu17ll_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu8s  {
  bool v1;
  __tsu64 v2:17;
  unsigned short v3:8;
};
//SIG(1 B_BFu17ll_BFu8s) C1{ Fc FL:17 Fs:8}



static void Test_B_BFu17ll_BFu8s()
{
  {
    init_simple_test("B_BFu17ll_BFu8s");
    static B_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "B_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "B_BFu17ll_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu8s(Test_B_BFu17ll_BFu8s, "B_BFu17ll_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu9i  {
  bool v1;
  __tsu64 v2:17;
  unsigned int v3:9;
};
//SIG(1 B_BFu17ll_BFu9i) C1{ Fc FL:17 Fi:9}



static void Test_B_BFu17ll_BFu9i()
{
  {
    init_simple_test("B_BFu17ll_BFu9i");
    static B_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "B_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "B_BFu17ll_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu9i(Test_B_BFu17ll_BFu9i, "B_BFu17ll_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu9ll  {
  bool v1;
  __tsu64 v2:17;
  __tsu64 v3:9;
};
//SIG(1 B_BFu17ll_BFu9ll) C1{ Fc FL:17 FL:9}



static void Test_B_BFu17ll_BFu9ll()
{
  {
    init_simple_test("B_BFu17ll_BFu9ll");
    static B_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "B_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "B_BFu17ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu9ll(Test_B_BFu17ll_BFu9ll, "B_BFu17ll_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_BFu9s  {
  bool v1;
  __tsu64 v2:17;
  unsigned short v3:9;
};
//SIG(1 B_BFu17ll_BFu9s) C1{ Fc FL:17 Fs:9}



static void Test_B_BFu17ll_BFu9s()
{
  {
    init_simple_test("B_BFu17ll_BFu9s");
    static B_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "B_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "B_BFu17ll_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_BFu9s(Test_B_BFu17ll_BFu9s, "B_BFu17ll_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_C  {
  bool v1;
  __tsu64 v2:17;
  char v3;
};
//SIG(1 B_BFu17ll_C) C1{ Fc FL:17 Fc}



static void Test_B_BFu17ll_C()
{
  {
    init_simple_test("B_BFu17ll_C");
    static B_BFu17ll_C lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_C");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_C");
    check_field_offset(lv, v3, 4, "B_BFu17ll_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_C(Test_B_BFu17ll_C, "B_BFu17ll_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_D  {
  bool v1;
  __tsu64 v2:17;
  double v3;
};
//SIG(1 B_BFu17ll_D) C1{ Fc FL:17 FL}



static void Test_B_BFu17ll_D()
{
  {
    init_simple_test("B_BFu17ll_D");
    static B_BFu17ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu17ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_D");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu17ll_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_D(Test_B_BFu17ll_D, "B_BFu17ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_F  {
  bool v1;
  __tsu64 v2:17;
  float v3;
};
//SIG(1 B_BFu17ll_F) C1{ Fc FL:17 Fi}



static void Test_B_BFu17ll_F()
{
  {
    init_simple_test("B_BFu17ll_F");
    static B_BFu17ll_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_F");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_F");
    check_field_offset(lv, v3, 4, "B_BFu17ll_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_F(Test_B_BFu17ll_F, "B_BFu17ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_I  {
  bool v1;
  __tsu64 v2:17;
  int v3;
};
//SIG(1 B_BFu17ll_I) C1{ Fc FL:17 Fi}



static void Test_B_BFu17ll_I()
{
  {
    init_simple_test("B_BFu17ll_I");
    static B_BFu17ll_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_I");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_I");
    check_field_offset(lv, v3, 4, "B_BFu17ll_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_I(Test_B_BFu17ll_I, "B_BFu17ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_Ip  {
  bool v1;
  __tsu64 v2:17;
  int *v3;
};
//SIG(1 B_BFu17ll_Ip) C1{ Fc FL:17 Fp}



static void Test_B_BFu17ll_Ip()
{
  {
    init_simple_test("B_BFu17ll_Ip");
    static B_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu17ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu17ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_Ip(Test_B_BFu17ll_Ip, "B_BFu17ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_L  {
  bool v1;
  __tsu64 v2:17;
  __tsi64 v3;
};
//SIG(1 B_BFu17ll_L) C1{ Fc FL:17 FL}



static void Test_B_BFu17ll_L()
{
  {
    init_simple_test("B_BFu17ll_L");
    static B_BFu17ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu17ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_L");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu17ll_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_L(Test_B_BFu17ll_L, "B_BFu17ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_S  {
  bool v1;
  __tsu64 v2:17;
  short v3;
};
//SIG(1 B_BFu17ll_S) C1{ Fc FL:17 Fs}



static void Test_B_BFu17ll_S()
{
  {
    init_simple_test("B_BFu17ll_S");
    static B_BFu17ll_S lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_S");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_S");
    check_field_offset(lv, v3, 4, "B_BFu17ll_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_S(Test_B_BFu17ll_S, "B_BFu17ll_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_Uc  {
  bool v1;
  __tsu64 v2:17;
  unsigned char v3;
};
//SIG(1 B_BFu17ll_Uc) C1{ Fc FL:17 Fc}



static void Test_B_BFu17ll_Uc()
{
  {
    init_simple_test("B_BFu17ll_Uc");
    static B_BFu17ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_Uc");
    check_field_offset(lv, v3, 4, "B_BFu17ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_Uc(Test_B_BFu17ll_Uc, "B_BFu17ll_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_Ui  {
  bool v1;
  __tsu64 v2:17;
  unsigned int v3;
};
//SIG(1 B_BFu17ll_Ui) C1{ Fc FL:17 Fi}



static void Test_B_BFu17ll_Ui()
{
  {
    init_simple_test("B_BFu17ll_Ui");
    static B_BFu17ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_Ui");
    check_field_offset(lv, v3, 4, "B_BFu17ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_Ui(Test_B_BFu17ll_Ui, "B_BFu17ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_Ul  {
  bool v1;
  __tsu64 v2:17;
  __tsu64 v3;
};
//SIG(1 B_BFu17ll_Ul) C1{ Fc FL:17 FL}



static void Test_B_BFu17ll_Ul()
{
  {
    init_simple_test("B_BFu17ll_Ul");
    static B_BFu17ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu17ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu17ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_Ul(Test_B_BFu17ll_Ul, "B_BFu17ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_Us  {
  bool v1;
  __tsu64 v2:17;
  unsigned short v3;
};
//SIG(1 B_BFu17ll_Us) C1{ Fc FL:17 Fs}



static void Test_B_BFu17ll_Us()
{
  {
    init_simple_test("B_BFu17ll_Us");
    static B_BFu17ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu17ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_Us");
    check_field_offset(lv, v3, 4, "B_BFu17ll_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_Us(Test_B_BFu17ll_Us, "B_BFu17ll_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu17ll_Vp  {
  bool v1;
  __tsu64 v2:17;
  void *v3;
};
//SIG(1 B_BFu17ll_Vp) C1{ Fc FL:17 Fp}



static void Test_B_BFu17ll_Vp()
{
  {
    init_simple_test("B_BFu17ll_Vp");
    static B_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu17ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "B_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "B_BFu17ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu17ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu17ll_Vp(Test_B_BFu17ll_Vp, "B_BFu17ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c  {
  bool v1;
  unsigned char v2:1;
};
//SIG(1 B_BFu1c) C1{ Fc Fc:1}



static void Test_B_BFu1c()
{
  {
    init_simple_test("B_BFu1c");
    static B_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu1c(Test_B_BFu1c, "B_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_B  {
  bool v1;
  unsigned char v2:1;
  bool v3;
};
//SIG(1 B_BFu1c_B) C1{ Fc Fc:1 Fc}



static void Test_B_BFu1c_B()
{
  {
    init_simple_test("B_BFu1c_B");
    static B_BFu1c_B lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu1c_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu1c_B)");
    check_field_offset(lv, v1, 0, "B_BFu1c_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_B");
    check_field_offset(lv, v3, 2, "B_BFu1c_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1c_B(Test_B_BFu1c_B, "B_BFu1c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu15i  {
  bool v1;
  unsigned char v2:1;
  unsigned int v3:15;
};
//SIG(1 B_BFu1c_BFu15i) C1{ Fc Fc:1 Fi:15}



static void Test_B_BFu1c_BFu15i()
{
  {
    init_simple_test("B_BFu1c_BFu15i");
    static B_BFu1c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "B_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "B_BFu1c_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu15i(Test_B_BFu1c_BFu15i, "B_BFu1c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu15ll  {
  bool v1;
  unsigned char v2:1;
  __tsu64 v3:15;
};
//SIG(1 B_BFu1c_BFu15ll) C1{ Fc Fc:1 FL:15}



static void Test_B_BFu1c_BFu15ll()
{
  {
    init_simple_test("B_BFu1c_BFu15ll");
    static B_BFu1c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "B_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "B_BFu1c_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu15ll(Test_B_BFu1c_BFu15ll, "B_BFu1c_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu15s  {
  bool v1;
  unsigned char v2:1;
  unsigned short v3:15;
};
//SIG(1 B_BFu1c_BFu15s) C1{ Fc Fc:1 Fs:15}



static void Test_B_BFu1c_BFu15s()
{
  {
    init_simple_test("B_BFu1c_BFu15s");
    static B_BFu1c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu1c_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu15s(Test_B_BFu1c_BFu15s, "B_BFu1c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu16i  {
  bool v1;
  unsigned char v2:1;
  unsigned int v3:16;
};
//SIG(1 B_BFu1c_BFu16i) C1{ Fc Fc:1 Fi:16}



static void Test_B_BFu1c_BFu16i()
{
  {
    init_simple_test("B_BFu1c_BFu16i");
    static B_BFu1c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "B_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "B_BFu1c_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu16i(Test_B_BFu1c_BFu16i, "B_BFu1c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu16ll  {
  bool v1;
  unsigned char v2:1;
  __tsu64 v3:16;
};
//SIG(1 B_BFu1c_BFu16ll) C1{ Fc Fc:1 FL:16}



static void Test_B_BFu1c_BFu16ll()
{
  {
    init_simple_test("B_BFu1c_BFu16ll");
    static B_BFu1c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "B_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "B_BFu1c_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu16ll(Test_B_BFu1c_BFu16ll, "B_BFu1c_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu16s  {
  bool v1;
  unsigned char v2:1;
  unsigned short v3:16;
};
//SIG(1 B_BFu1c_BFu16s) C1{ Fc Fc:1 Fs:16}



static void Test_B_BFu1c_BFu16s()
{
  {
    init_simple_test("B_BFu1c_BFu16s");
    static B_BFu1c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu1c_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu16s(Test_B_BFu1c_BFu16s, "B_BFu1c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu17i  {
  bool v1;
  unsigned char v2:1;
  unsigned int v3:17;
};
//SIG(1 B_BFu1c_BFu17i) C1{ Fc Fc:1 Fi:17}



static void Test_B_BFu1c_BFu17i()
{
  {
    init_simple_test("B_BFu1c_BFu17i");
    static B_BFu1c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "B_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "B_BFu1c_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu17i(Test_B_BFu1c_BFu17i, "B_BFu1c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu17ll  {
  bool v1;
  unsigned char v2:1;
  __tsu64 v3:17;
};
//SIG(1 B_BFu1c_BFu17ll) C1{ Fc Fc:1 FL:17}



static void Test_B_BFu1c_BFu17ll()
{
  {
    init_simple_test("B_BFu1c_BFu17ll");
    static B_BFu1c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "B_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "B_BFu1c_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu17ll(Test_B_BFu1c_BFu17ll, "B_BFu1c_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu1c  {
  bool v1;
  unsigned char v2:1;
  unsigned char v3:1;
};
//SIG(1 B_BFu1c_BFu1c) C1{ Fc Fc:1 Fc:1}



static void Test_B_BFu1c_BFu1c()
{
  {
    init_simple_test("B_BFu1c_BFu1c");
    static B_BFu1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1c_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu1c(Test_B_BFu1c_BFu1c, "B_BFu1c_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu1i  {
  bool v1;
  unsigned char v2:1;
  unsigned int v3:1;
};
//SIG(1 B_BFu1c_BFu1i) C1{ Fc Fc:1 Fi:1}



static void Test_B_BFu1c_BFu1i()
{
  {
    init_simple_test("B_BFu1c_BFu1i");
    static B_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1c_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu1i(Test_B_BFu1c_BFu1i, "B_BFu1c_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu1ll  {
  bool v1;
  unsigned char v2:1;
  __tsu64 v3:1;
};
//SIG(1 B_BFu1c_BFu1ll) C1{ Fc Fc:1 FL:1}



static void Test_B_BFu1c_BFu1ll()
{
  {
    init_simple_test("B_BFu1c_BFu1ll");
    static B_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1c_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu1ll(Test_B_BFu1c_BFu1ll, "B_BFu1c_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu1s  {
  bool v1;
  unsigned char v2:1;
  unsigned short v3:1;
};
//SIG(1 B_BFu1c_BFu1s) C1{ Fc Fc:1 Fs:1}



static void Test_B_BFu1c_BFu1s()
{
  {
    init_simple_test("B_BFu1c_BFu1s");
    static B_BFu1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1c_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu1s(Test_B_BFu1c_BFu1s, "B_BFu1c_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu31i  {
  bool v1;
  unsigned char v2:1;
  unsigned int v3:31;
};
//SIG(1 B_BFu1c_BFu31i) C1{ Fc Fc:1 Fi:31}



static void Test_B_BFu1c_BFu31i()
{
  {
    init_simple_test("B_BFu1c_BFu31i");
    static B_BFu1c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu1c_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu31i(Test_B_BFu1c_BFu31i, "B_BFu1c_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu31ll  {
  bool v1;
  unsigned char v2:1;
  __tsu64 v3:31;
};
//SIG(1 B_BFu1c_BFu31ll) C1{ Fc Fc:1 FL:31}



static void Test_B_BFu1c_BFu31ll()
{
  {
    init_simple_test("B_BFu1c_BFu31ll");
    static B_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "B_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "B_BFu1c_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu31ll(Test_B_BFu1c_BFu31ll, "B_BFu1c_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu32i  {
  bool v1;
  unsigned char v2:1;
  unsigned int v3:32;
};
//SIG(1 B_BFu1c_BFu32i) C1{ Fc Fc:1 Fi:32}



static void Test_B_BFu1c_BFu32i()
{
  {
    init_simple_test("B_BFu1c_BFu32i");
    static B_BFu1c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu1c_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu32i(Test_B_BFu1c_BFu32i, "B_BFu1c_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu32ll  {
  bool v1;
  unsigned char v2:1;
  __tsu64 v3:32;
};
//SIG(1 B_BFu1c_BFu32ll) C1{ Fc Fc:1 FL:32}



static void Test_B_BFu1c_BFu32ll()
{
  {
    init_simple_test("B_BFu1c_BFu32ll");
    static B_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "B_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "B_BFu1c_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu32ll(Test_B_BFu1c_BFu32ll, "B_BFu1c_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu33  {
  bool v1;
  unsigned char v2:1;
  __tsu64 v3:33;
};
//SIG(1 B_BFu1c_BFu33) C1{ Fc Fc:1 FL:33}



static void Test_B_BFu1c_BFu33()
{
  {
    init_simple_test("B_BFu1c_BFu33");
    static B_BFu1c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "B_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "B_BFu1c_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu33(Test_B_BFu1c_BFu33, "B_BFu1c_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu7c  {
  bool v1;
  unsigned char v2:1;
  unsigned char v3:7;
};
//SIG(1 B_BFu1c_BFu7c) C1{ Fc Fc:1 Fc:7}



static void Test_B_BFu1c_BFu7c()
{
  {
    init_simple_test("B_BFu1c_BFu7c");
    static B_BFu1c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1c_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu7c(Test_B_BFu1c_BFu7c, "B_BFu1c_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu7i  {
  bool v1;
  unsigned char v2:1;
  unsigned int v3:7;
};
//SIG(1 B_BFu1c_BFu7i) C1{ Fc Fc:1 Fi:7}



static void Test_B_BFu1c_BFu7i()
{
  {
    init_simple_test("B_BFu1c_BFu7i");
    static B_BFu1c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1c_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu7i(Test_B_BFu1c_BFu7i, "B_BFu1c_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu7ll  {
  bool v1;
  unsigned char v2:1;
  __tsu64 v3:7;
};
//SIG(1 B_BFu1c_BFu7ll) C1{ Fc Fc:1 FL:7}



static void Test_B_BFu1c_BFu7ll()
{
  {
    init_simple_test("B_BFu1c_BFu7ll");
    static B_BFu1c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1c_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu7ll(Test_B_BFu1c_BFu7ll, "B_BFu1c_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu7s  {
  bool v1;
  unsigned char v2:1;
  unsigned short v3:7;
};
//SIG(1 B_BFu1c_BFu7s) C1{ Fc Fc:1 Fs:7}



static void Test_B_BFu1c_BFu7s()
{
  {
    init_simple_test("B_BFu1c_BFu7s");
    static B_BFu1c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1c_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu7s(Test_B_BFu1c_BFu7s, "B_BFu1c_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu8c  {
  bool v1;
  unsigned char v2:1;
  unsigned char v3:8;
};
//SIG(1 B_BFu1c_BFu8c) C1{ Fc Fc:1 Fc:8}



static void Test_B_BFu1c_BFu8c()
{
  {
    init_simple_test("B_BFu1c_BFu8c");
    static B_BFu1c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu1c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu1c_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu8c(Test_B_BFu1c_BFu8c, "B_BFu1c_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu8i  {
  bool v1;
  unsigned char v2:1;
  unsigned int v3:8;
};
//SIG(1 B_BFu1c_BFu8i) C1{ Fc Fc:1 Fi:8}



static void Test_B_BFu1c_BFu8i()
{
  {
    init_simple_test("B_BFu1c_BFu8i");
    static B_BFu1c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "B_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "B_BFu1c_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu8i(Test_B_BFu1c_BFu8i, "B_BFu1c_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu8ll  {
  bool v1;
  unsigned char v2:1;
  __tsu64 v3:8;
};
//SIG(1 B_BFu1c_BFu8ll) C1{ Fc Fc:1 FL:8}



static void Test_B_BFu1c_BFu8ll()
{
  {
    init_simple_test("B_BFu1c_BFu8ll");
    static B_BFu1c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "B_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "B_BFu1c_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu8ll(Test_B_BFu1c_BFu8ll, "B_BFu1c_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu8s  {
  bool v1;
  unsigned char v2:1;
  unsigned short v3:8;
};
//SIG(1 B_BFu1c_BFu8s) C1{ Fc Fc:1 Fs:8}



static void Test_B_BFu1c_BFu8s()
{
  {
    init_simple_test("B_BFu1c_BFu8s");
    static B_BFu1c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu1c_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu8s(Test_B_BFu1c_BFu8s, "B_BFu1c_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu9i  {
  bool v1;
  unsigned char v2:1;
  unsigned int v3:9;
};
//SIG(1 B_BFu1c_BFu9i) C1{ Fc Fc:1 Fi:9}



static void Test_B_BFu1c_BFu9i()
{
  {
    init_simple_test("B_BFu1c_BFu9i");
    static B_BFu1c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "B_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "B_BFu1c_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu9i(Test_B_BFu1c_BFu9i, "B_BFu1c_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu9ll  {
  bool v1;
  unsigned char v2:1;
  __tsu64 v3:9;
};
//SIG(1 B_BFu1c_BFu9ll) C1{ Fc Fc:1 FL:9}



static void Test_B_BFu1c_BFu9ll()
{
  {
    init_simple_test("B_BFu1c_BFu9ll");
    static B_BFu1c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "B_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "B_BFu1c_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu9ll(Test_B_BFu1c_BFu9ll, "B_BFu1c_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_BFu9s  {
  bool v1;
  unsigned char v2:1;
  unsigned short v3:9;
};
//SIG(1 B_BFu1c_BFu9s) C1{ Fc Fc:1 Fs:9}



static void Test_B_BFu1c_BFu9s()
{
  {
    init_simple_test("B_BFu1c_BFu9s");
    static B_BFu1c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu1c_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu1c_BFu9s(Test_B_BFu1c_BFu9s, "B_BFu1c_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_C  {
  bool v1;
  unsigned char v2:1;
  char v3;
};
//SIG(1 B_BFu1c_C) C1{ Fc Fc:1 Fc}



static void Test_B_BFu1c_C()
{
  {
    init_simple_test("B_BFu1c_C");
    static B_BFu1c_C lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu1c_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu1c_C)");
    check_field_offset(lv, v1, 0, "B_BFu1c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_C");
    check_field_offset(lv, v3, 2, "B_BFu1c_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1c_C(Test_B_BFu1c_C, "B_BFu1c_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_D  {
  bool v1;
  unsigned char v2:1;
  double v3;
};
//SIG(1 B_BFu1c_D) C1{ Fc Fc:1 FL}



static void Test_B_BFu1c_D()
{
  {
    init_simple_test("B_BFu1c_D");
    static B_BFu1c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu1c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_D)");
    check_field_offset(lv, v1, 0, "B_BFu1c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1c_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1c_D(Test_B_BFu1c_D, "B_BFu1c_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_F  {
  bool v1;
  unsigned char v2:1;
  float v3;
};
//SIG(1 B_BFu1c_F) C1{ Fc Fc:1 Fi}



static void Test_B_BFu1c_F()
{
  {
    init_simple_test("B_BFu1c_F");
    static B_BFu1c_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1c_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1c_F)");
    check_field_offset(lv, v1, 0, "B_BFu1c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_F");
    check_field_offset(lv, v3, 4, "B_BFu1c_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1c_F(Test_B_BFu1c_F, "B_BFu1c_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_I  {
  bool v1;
  unsigned char v2:1;
  int v3;
};
//SIG(1 B_BFu1c_I) C1{ Fc Fc:1 Fi}



static void Test_B_BFu1c_I()
{
  {
    init_simple_test("B_BFu1c_I");
    static B_BFu1c_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1c_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1c_I)");
    check_field_offset(lv, v1, 0, "B_BFu1c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_I");
    check_field_offset(lv, v3, 4, "B_BFu1c_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1c_I(Test_B_BFu1c_I, "B_BFu1c_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_Ip  {
  bool v1;
  unsigned char v2:1;
  int *v3;
};
//SIG(1 B_BFu1c_Ip) C1{ Fc Fc:1 Fp}



static void Test_B_BFu1c_Ip()
{
  {
    init_simple_test("B_BFu1c_Ip");
    static B_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu1c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1c_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1c_Ip(Test_B_BFu1c_Ip, "B_BFu1c_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_L  {
  bool v1;
  unsigned char v2:1;
  __tsi64 v3;
};
//SIG(1 B_BFu1c_L) C1{ Fc Fc:1 FL}



static void Test_B_BFu1c_L()
{
  {
    init_simple_test("B_BFu1c_L");
    static B_BFu1c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu1c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_L)");
    check_field_offset(lv, v1, 0, "B_BFu1c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1c_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1c_L(Test_B_BFu1c_L, "B_BFu1c_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_S  {
  bool v1;
  unsigned char v2:1;
  short v3;
};
//SIG(1 B_BFu1c_S) C1{ Fc Fc:1 Fs}



static void Test_B_BFu1c_S()
{
  {
    init_simple_test("B_BFu1c_S");
    static B_BFu1c_S lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1c_S)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1c_S)");
    check_field_offset(lv, v1, 0, "B_BFu1c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_S");
    check_field_offset(lv, v3, 2, "B_BFu1c_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1c_S(Test_B_BFu1c_S, "B_BFu1c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_Uc  {
  bool v1;
  unsigned char v2:1;
  unsigned char v3;
};
//SIG(1 B_BFu1c_Uc) C1{ Fc Fc:1 Fc}



static void Test_B_BFu1c_Uc()
{
  {
    init_simple_test("B_BFu1c_Uc");
    static B_BFu1c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu1c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_Uc");
    check_field_offset(lv, v3, 2, "B_BFu1c_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1c_Uc(Test_B_BFu1c_Uc, "B_BFu1c_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_Ui  {
  bool v1;
  unsigned char v2:1;
  unsigned int v3;
};
//SIG(1 B_BFu1c_Ui) C1{ Fc Fc:1 Fi}



static void Test_B_BFu1c_Ui()
{
  {
    init_simple_test("B_BFu1c_Ui");
    static B_BFu1c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_Ui");
    check_field_offset(lv, v3, 4, "B_BFu1c_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1c_Ui(Test_B_BFu1c_Ui, "B_BFu1c_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_Ul  {
  bool v1;
  unsigned char v2:1;
  __tsu64 v3;
};
//SIG(1 B_BFu1c_Ul) C1{ Fc Fc:1 FL}



static void Test_B_BFu1c_Ul()
{
  {
    init_simple_test("B_BFu1c_Ul");
    static B_BFu1c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu1c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1c_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1c_Ul(Test_B_BFu1c_Ul, "B_BFu1c_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_Us  {
  bool v1;
  unsigned char v2:1;
  unsigned short v3;
};
//SIG(1 B_BFu1c_Us) C1{ Fc Fc:1 Fs}



static void Test_B_BFu1c_Us()
{
  {
    init_simple_test("B_BFu1c_Us");
    static B_BFu1c_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "B_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_Us");
    check_field_offset(lv, v3, 2, "B_BFu1c_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1c_Us(Test_B_BFu1c_Us, "B_BFu1c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1c_Vp  {
  bool v1;
  unsigned char v2:1;
  void *v3;
};
//SIG(1 B_BFu1c_Vp) C1{ Fc Fc:1 Fp}



static void Test_B_BFu1c_Vp()
{
  {
    init_simple_test("B_BFu1c_Vp");
    static B_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu1c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1c_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1c_Vp(Test_B_BFu1c_Vp, "B_BFu1c_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i  {
  bool v1;
  unsigned int v2:1;
};
//SIG(1 B_BFu1i) C1{ Fc Fi:1}



static void Test_B_BFu1i()
{
  {
    init_simple_test("B_BFu1i");
    static B_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu1i(Test_B_BFu1i, "B_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_B  {
  bool v1;
  unsigned int v2:1;
  bool v3;
};
//SIG(1 B_BFu1i_B) C1{ Fc Fi:1 Fc}



static void Test_B_BFu1i_B()
{
  {
    init_simple_test("B_BFu1i_B");
    static B_BFu1i_B lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_B)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_B)");
    check_field_offset(lv, v1, 0, "B_BFu1i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_B");
    check_field_offset(lv, v3, 2, "B_BFu1i_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1i_B(Test_B_BFu1i_B, "B_BFu1i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu15i  {
  bool v1;
  unsigned int v2:1;
  unsigned int v3:15;
};
//SIG(1 B_BFu1i_BFu15i) C1{ Fc Fi:1 Fi:15}



static void Test_B_BFu1i_BFu15i()
{
  {
    init_simple_test("B_BFu1i_BFu15i");
    static B_BFu1i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "B_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "B_BFu1i_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu15i(Test_B_BFu1i_BFu15i, "B_BFu1i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu15ll  {
  bool v1;
  unsigned int v2:1;
  __tsu64 v3:15;
};
//SIG(1 B_BFu1i_BFu15ll) C1{ Fc Fi:1 FL:15}



static void Test_B_BFu1i_BFu15ll()
{
  {
    init_simple_test("B_BFu1i_BFu15ll");
    static B_BFu1i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "B_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "B_BFu1i_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu15ll(Test_B_BFu1i_BFu15ll, "B_BFu1i_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu15s  {
  bool v1;
  unsigned int v2:1;
  unsigned short v3:15;
};
//SIG(1 B_BFu1i_BFu15s) C1{ Fc Fi:1 Fs:15}



static void Test_B_BFu1i_BFu15s()
{
  {
    init_simple_test("B_BFu1i_BFu15s");
    static B_BFu1i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu1i_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu15s(Test_B_BFu1i_BFu15s, "B_BFu1i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu16i  {
  bool v1;
  unsigned int v2:1;
  unsigned int v3:16;
};
//SIG(1 B_BFu1i_BFu16i) C1{ Fc Fi:1 Fi:16}



static void Test_B_BFu1i_BFu16i()
{
  {
    init_simple_test("B_BFu1i_BFu16i");
    static B_BFu1i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "B_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "B_BFu1i_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu16i(Test_B_BFu1i_BFu16i, "B_BFu1i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu16ll  {
  bool v1;
  unsigned int v2:1;
  __tsu64 v3:16;
};
//SIG(1 B_BFu1i_BFu16ll) C1{ Fc Fi:1 FL:16}



static void Test_B_BFu1i_BFu16ll()
{
  {
    init_simple_test("B_BFu1i_BFu16ll");
    static B_BFu1i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "B_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "B_BFu1i_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu16ll(Test_B_BFu1i_BFu16ll, "B_BFu1i_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu16s  {
  bool v1;
  unsigned int v2:1;
  unsigned short v3:16;
};
//SIG(1 B_BFu1i_BFu16s) C1{ Fc Fi:1 Fs:16}



static void Test_B_BFu1i_BFu16s()
{
  {
    init_simple_test("B_BFu1i_BFu16s");
    static B_BFu1i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu1i_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu16s(Test_B_BFu1i_BFu16s, "B_BFu1i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu17i  {
  bool v1;
  unsigned int v2:1;
  unsigned int v3:17;
};
//SIG(1 B_BFu1i_BFu17i) C1{ Fc Fi:1 Fi:17}



static void Test_B_BFu1i_BFu17i()
{
  {
    init_simple_test("B_BFu1i_BFu17i");
    static B_BFu1i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "B_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "B_BFu1i_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu17i(Test_B_BFu1i_BFu17i, "B_BFu1i_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu17ll  {
  bool v1;
  unsigned int v2:1;
  __tsu64 v3:17;
};
//SIG(1 B_BFu1i_BFu17ll) C1{ Fc Fi:1 FL:17}



static void Test_B_BFu1i_BFu17ll()
{
  {
    init_simple_test("B_BFu1i_BFu17ll");
    static B_BFu1i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "B_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "B_BFu1i_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu17ll(Test_B_BFu1i_BFu17ll, "B_BFu1i_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu1c  {
  bool v1;
  unsigned int v2:1;
  unsigned char v3:1;
};
//SIG(1 B_BFu1i_BFu1c) C1{ Fc Fi:1 Fc:1}



static void Test_B_BFu1i_BFu1c()
{
  {
    init_simple_test("B_BFu1i_BFu1c");
    static B_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1i_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu1c(Test_B_BFu1i_BFu1c, "B_BFu1i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu1i  {
  bool v1;
  unsigned int v2:1;
  unsigned int v3:1;
};
//SIG(1 B_BFu1i_BFu1i) C1{ Fc Fi:1 Fi:1}



static void Test_B_BFu1i_BFu1i()
{
  {
    init_simple_test("B_BFu1i_BFu1i");
    static B_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1i_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu1i(Test_B_BFu1i_BFu1i, "B_BFu1i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu1ll  {
  bool v1;
  unsigned int v2:1;
  __tsu64 v3:1;
};
//SIG(1 B_BFu1i_BFu1ll) C1{ Fc Fi:1 FL:1}



static void Test_B_BFu1i_BFu1ll()
{
  {
    init_simple_test("B_BFu1i_BFu1ll");
    static B_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1i_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu1ll(Test_B_BFu1i_BFu1ll, "B_BFu1i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu1s  {
  bool v1;
  unsigned int v2:1;
  unsigned short v3:1;
};
//SIG(1 B_BFu1i_BFu1s) C1{ Fc Fi:1 Fs:1}



static void Test_B_BFu1i_BFu1s()
{
  {
    init_simple_test("B_BFu1i_BFu1s");
    static B_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1i_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu1s(Test_B_BFu1i_BFu1s, "B_BFu1i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu31i  {
  bool v1;
  unsigned int v2:1;
  unsigned int v3:31;
};
//SIG(1 B_BFu1i_BFu31i) C1{ Fc Fi:1 Fi:31}



static void Test_B_BFu1i_BFu31i()
{
  {
    init_simple_test("B_BFu1i_BFu31i");
    static B_BFu1i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu1i_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu31i(Test_B_BFu1i_BFu31i, "B_BFu1i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu31ll  {
  bool v1;
  unsigned int v2:1;
  __tsu64 v3:31;
};
//SIG(1 B_BFu1i_BFu31ll) C1{ Fc Fi:1 FL:31}



static void Test_B_BFu1i_BFu31ll()
{
  {
    init_simple_test("B_BFu1i_BFu31ll");
    static B_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "B_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "B_BFu1i_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu31ll(Test_B_BFu1i_BFu31ll, "B_BFu1i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu32i  {
  bool v1;
  unsigned int v2:1;
  unsigned int v3:32;
};
//SIG(1 B_BFu1i_BFu32i) C1{ Fc Fi:1 Fi:32}



static void Test_B_BFu1i_BFu32i()
{
  {
    init_simple_test("B_BFu1i_BFu32i");
    static B_BFu1i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu1i_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu32i(Test_B_BFu1i_BFu32i, "B_BFu1i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu32ll  {
  bool v1;
  unsigned int v2:1;
  __tsu64 v3:32;
};
//SIG(1 B_BFu1i_BFu32ll) C1{ Fc Fi:1 FL:32}



static void Test_B_BFu1i_BFu32ll()
{
  {
    init_simple_test("B_BFu1i_BFu32ll");
    static B_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "B_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "B_BFu1i_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu32ll(Test_B_BFu1i_BFu32ll, "B_BFu1i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu33  {
  bool v1;
  unsigned int v2:1;
  __tsu64 v3:33;
};
//SIG(1 B_BFu1i_BFu33) C1{ Fc Fi:1 FL:33}



static void Test_B_BFu1i_BFu33()
{
  {
    init_simple_test("B_BFu1i_BFu33");
    static B_BFu1i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "B_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "B_BFu1i_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu33(Test_B_BFu1i_BFu33, "B_BFu1i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu7c  {
  bool v1;
  unsigned int v2:1;
  unsigned char v3:7;
};
//SIG(1 B_BFu1i_BFu7c) C1{ Fc Fi:1 Fc:7}



static void Test_B_BFu1i_BFu7c()
{
  {
    init_simple_test("B_BFu1i_BFu7c");
    static B_BFu1i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1i_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu7c(Test_B_BFu1i_BFu7c, "B_BFu1i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu7i  {
  bool v1;
  unsigned int v2:1;
  unsigned int v3:7;
};
//SIG(1 B_BFu1i_BFu7i) C1{ Fc Fi:1 Fi:7}



static void Test_B_BFu1i_BFu7i()
{
  {
    init_simple_test("B_BFu1i_BFu7i");
    static B_BFu1i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1i_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu7i(Test_B_BFu1i_BFu7i, "B_BFu1i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu7ll  {
  bool v1;
  unsigned int v2:1;
  __tsu64 v3:7;
};
//SIG(1 B_BFu1i_BFu7ll) C1{ Fc Fi:1 FL:7}



static void Test_B_BFu1i_BFu7ll()
{
  {
    init_simple_test("B_BFu1i_BFu7ll");
    static B_BFu1i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1i_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu7ll(Test_B_BFu1i_BFu7ll, "B_BFu1i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu7s  {
  bool v1;
  unsigned int v2:1;
  unsigned short v3:7;
};
//SIG(1 B_BFu1i_BFu7s) C1{ Fc Fi:1 Fs:7}



static void Test_B_BFu1i_BFu7s()
{
  {
    init_simple_test("B_BFu1i_BFu7s");
    static B_BFu1i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1i_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu7s(Test_B_BFu1i_BFu7s, "B_BFu1i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu8c  {
  bool v1;
  unsigned int v2:1;
  unsigned char v3:8;
};
//SIG(1 B_BFu1i_BFu8c) C1{ Fc Fi:1 Fc:8}



static void Test_B_BFu1i_BFu8c()
{
  {
    init_simple_test("B_BFu1i_BFu8c");
    static B_BFu1i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu1i_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu8c(Test_B_BFu1i_BFu8c, "B_BFu1i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu8i  {
  bool v1;
  unsigned int v2:1;
  unsigned int v3:8;
};
//SIG(1 B_BFu1i_BFu8i) C1{ Fc Fi:1 Fi:8}



static void Test_B_BFu1i_BFu8i()
{
  {
    init_simple_test("B_BFu1i_BFu8i");
    static B_BFu1i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "B_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "B_BFu1i_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu8i(Test_B_BFu1i_BFu8i, "B_BFu1i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu8ll  {
  bool v1;
  unsigned int v2:1;
  __tsu64 v3:8;
};
//SIG(1 B_BFu1i_BFu8ll) C1{ Fc Fi:1 FL:8}



static void Test_B_BFu1i_BFu8ll()
{
  {
    init_simple_test("B_BFu1i_BFu8ll");
    static B_BFu1i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "B_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "B_BFu1i_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu8ll(Test_B_BFu1i_BFu8ll, "B_BFu1i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu8s  {
  bool v1;
  unsigned int v2:1;
  unsigned short v3:8;
};
//SIG(1 B_BFu1i_BFu8s) C1{ Fc Fi:1 Fs:8}



static void Test_B_BFu1i_BFu8s()
{
  {
    init_simple_test("B_BFu1i_BFu8s");
    static B_BFu1i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu1i_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu8s(Test_B_BFu1i_BFu8s, "B_BFu1i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu9i  {
  bool v1;
  unsigned int v2:1;
  unsigned int v3:9;
};
//SIG(1 B_BFu1i_BFu9i) C1{ Fc Fi:1 Fi:9}



static void Test_B_BFu1i_BFu9i()
{
  {
    init_simple_test("B_BFu1i_BFu9i");
    static B_BFu1i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "B_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "B_BFu1i_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu9i(Test_B_BFu1i_BFu9i, "B_BFu1i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu9ll  {
  bool v1;
  unsigned int v2:1;
  __tsu64 v3:9;
};
//SIG(1 B_BFu1i_BFu9ll) C1{ Fc Fi:1 FL:9}



static void Test_B_BFu1i_BFu9ll()
{
  {
    init_simple_test("B_BFu1i_BFu9ll");
    static B_BFu1i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "B_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "B_BFu1i_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu9ll(Test_B_BFu1i_BFu9ll, "B_BFu1i_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_BFu9s  {
  bool v1;
  unsigned int v2:1;
  unsigned short v3:9;
};
//SIG(1 B_BFu1i_BFu9s) C1{ Fc Fi:1 Fs:9}



static void Test_B_BFu1i_BFu9s()
{
  {
    init_simple_test("B_BFu1i_BFu9s");
    static B_BFu1i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu1i_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu1i_BFu9s(Test_B_BFu1i_BFu9s, "B_BFu1i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_C  {
  bool v1;
  unsigned int v2:1;
  char v3;
};
//SIG(1 B_BFu1i_C) C1{ Fc Fi:1 Fc}



static void Test_B_BFu1i_C()
{
  {
    init_simple_test("B_BFu1i_C");
    static B_BFu1i_C lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_C)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_C)");
    check_field_offset(lv, v1, 0, "B_BFu1i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_C");
    check_field_offset(lv, v3, 2, "B_BFu1i_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1i_C(Test_B_BFu1i_C, "B_BFu1i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_D  {
  bool v1;
  unsigned int v2:1;
  double v3;
};
//SIG(1 B_BFu1i_D) C1{ Fc Fi:1 FL}



static void Test_B_BFu1i_D()
{
  {
    init_simple_test("B_BFu1i_D");
    static B_BFu1i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu1i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_D)");
    check_field_offset(lv, v1, 0, "B_BFu1i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1i_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1i_D(Test_B_BFu1i_D, "B_BFu1i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_F  {
  bool v1;
  unsigned int v2:1;
  float v3;
};
//SIG(1 B_BFu1i_F) C1{ Fc Fi:1 Fi}



static void Test_B_BFu1i_F()
{
  {
    init_simple_test("B_BFu1i_F");
    static B_BFu1i_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1i_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_F)");
    check_field_offset(lv, v1, 0, "B_BFu1i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_F");
    check_field_offset(lv, v3, 4, "B_BFu1i_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1i_F(Test_B_BFu1i_F, "B_BFu1i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_I  {
  bool v1;
  unsigned int v2:1;
  int v3;
};
//SIG(1 B_BFu1i_I) C1{ Fc Fi:1 Fi}



static void Test_B_BFu1i_I()
{
  {
    init_simple_test("B_BFu1i_I");
    static B_BFu1i_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1i_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_I)");
    check_field_offset(lv, v1, 0, "B_BFu1i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_I");
    check_field_offset(lv, v3, 4, "B_BFu1i_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1i_I(Test_B_BFu1i_I, "B_BFu1i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_Ip  {
  bool v1;
  unsigned int v2:1;
  int *v3;
};
//SIG(1 B_BFu1i_Ip) C1{ Fc Fi:1 Fp}



static void Test_B_BFu1i_Ip()
{
  {
    init_simple_test("B_BFu1i_Ip");
    static B_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu1i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1i_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1i_Ip(Test_B_BFu1i_Ip, "B_BFu1i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_L  {
  bool v1;
  unsigned int v2:1;
  __tsi64 v3;
};
//SIG(1 B_BFu1i_L) C1{ Fc Fi:1 FL}



static void Test_B_BFu1i_L()
{
  {
    init_simple_test("B_BFu1i_L");
    static B_BFu1i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu1i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_L)");
    check_field_offset(lv, v1, 0, "B_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1i_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1i_L(Test_B_BFu1i_L, "B_BFu1i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_S  {
  bool v1;
  unsigned int v2:1;
  short v3;
};
//SIG(1 B_BFu1i_S) C1{ Fc Fi:1 Fs}



static void Test_B_BFu1i_S()
{
  {
    init_simple_test("B_BFu1i_S");
    static B_BFu1i_S lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_S)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_S)");
    check_field_offset(lv, v1, 0, "B_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_S");
    check_field_offset(lv, v3, 2, "B_BFu1i_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1i_S(Test_B_BFu1i_S, "B_BFu1i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_Uc  {
  bool v1;
  unsigned int v2:1;
  unsigned char v3;
};
//SIG(1 B_BFu1i_Uc) C1{ Fc Fi:1 Fc}



static void Test_B_BFu1i_Uc()
{
  {
    init_simple_test("B_BFu1i_Uc");
    static B_BFu1i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_Uc");
    check_field_offset(lv, v3, 2, "B_BFu1i_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1i_Uc(Test_B_BFu1i_Uc, "B_BFu1i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_Ui  {
  bool v1;
  unsigned int v2:1;
  unsigned int v3;
};
//SIG(1 B_BFu1i_Ui) C1{ Fc Fi:1 Fi}



static void Test_B_BFu1i_Ui()
{
  {
    init_simple_test("B_BFu1i_Ui");
    static B_BFu1i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_Ui");
    check_field_offset(lv, v3, 4, "B_BFu1i_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1i_Ui(Test_B_BFu1i_Ui, "B_BFu1i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_Ul  {
  bool v1;
  unsigned int v2:1;
  __tsu64 v3;
};
//SIG(1 B_BFu1i_Ul) C1{ Fc Fi:1 FL}



static void Test_B_BFu1i_Ul()
{
  {
    init_simple_test("B_BFu1i_Ul");
    static B_BFu1i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu1i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1i_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1i_Ul(Test_B_BFu1i_Ul, "B_BFu1i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_Us  {
  bool v1;
  unsigned int v2:1;
  unsigned short v3;
};
//SIG(1 B_BFu1i_Us) C1{ Fc Fi:1 Fs}



static void Test_B_BFu1i_Us()
{
  {
    init_simple_test("B_BFu1i_Us");
    static B_BFu1i_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "B_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_Us");
    check_field_offset(lv, v3, 2, "B_BFu1i_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1i_Us(Test_B_BFu1i_Us, "B_BFu1i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1i_Vp  {
  bool v1;
  unsigned int v2:1;
  void *v3;
};
//SIG(1 B_BFu1i_Vp) C1{ Fc Fi:1 Fp}



static void Test_B_BFu1i_Vp()
{
  {
    init_simple_test("B_BFu1i_Vp");
    static B_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu1i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1i_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1i_Vp(Test_B_BFu1i_Vp, "B_BFu1i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll  {
  bool v1;
  __tsu64 v2:1;
};
//SIG(1 B_BFu1ll) C1{ Fc FL:1}



static void Test_B_BFu1ll()
{
  {
    init_simple_test("B_BFu1ll");
    static B_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu1ll(Test_B_BFu1ll, "B_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_B  {
  bool v1;
  __tsu64 v2:1;
  bool v3;
};
//SIG(1 B_BFu1ll_B) C1{ Fc FL:1 Fc}



static void Test_B_BFu1ll_B()
{
  {
    init_simple_test("B_BFu1ll_B");
    static B_BFu1ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_B)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_B");
    check_field_offset(lv, v3, 2, "B_BFu1ll_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_B(Test_B_BFu1ll_B, "B_BFu1ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu15i  {
  bool v1;
  __tsu64 v2:1;
  unsigned int v3:15;
};
//SIG(1 B_BFu1ll_BFu15i) C1{ Fc FL:1 Fi:15}



static void Test_B_BFu1ll_BFu15i()
{
  {
    init_simple_test("B_BFu1ll_BFu15i");
    static B_BFu1ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "B_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "B_BFu1ll_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu15i(Test_B_BFu1ll_BFu15i, "B_BFu1ll_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu15ll  {
  bool v1;
  __tsu64 v2:1;
  __tsu64 v3:15;
};
//SIG(1 B_BFu1ll_BFu15ll) C1{ Fc FL:1 FL:15}



static void Test_B_BFu1ll_BFu15ll()
{
  {
    init_simple_test("B_BFu1ll_BFu15ll");
    static B_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "B_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "B_BFu1ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu15ll(Test_B_BFu1ll_BFu15ll, "B_BFu1ll_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu15s  {
  bool v1;
  __tsu64 v2:1;
  unsigned short v3:15;
};
//SIG(1 B_BFu1ll_BFu15s) C1{ Fc FL:1 Fs:15}



static void Test_B_BFu1ll_BFu15s()
{
  {
    init_simple_test("B_BFu1ll_BFu15s");
    static B_BFu1ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu1ll_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu15s(Test_B_BFu1ll_BFu15s, "B_BFu1ll_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu16i  {
  bool v1;
  __tsu64 v2:1;
  unsigned int v3:16;
};
//SIG(1 B_BFu1ll_BFu16i) C1{ Fc FL:1 Fi:16}



static void Test_B_BFu1ll_BFu16i()
{
  {
    init_simple_test("B_BFu1ll_BFu16i");
    static B_BFu1ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "B_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "B_BFu1ll_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu16i(Test_B_BFu1ll_BFu16i, "B_BFu1ll_BFu16i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu16ll  {
  bool v1;
  __tsu64 v2:1;
  __tsu64 v3:16;
};
//SIG(1 B_BFu1ll_BFu16ll) C1{ Fc FL:1 FL:16}



static void Test_B_BFu1ll_BFu16ll()
{
  {
    init_simple_test("B_BFu1ll_BFu16ll");
    static B_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "B_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "B_BFu1ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu16ll(Test_B_BFu1ll_BFu16ll, "B_BFu1ll_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu16s  {
  bool v1;
  __tsu64 v2:1;
  unsigned short v3:16;
};
//SIG(1 B_BFu1ll_BFu16s) C1{ Fc FL:1 Fs:16}



static void Test_B_BFu1ll_BFu16s()
{
  {
    init_simple_test("B_BFu1ll_BFu16s");
    static B_BFu1ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu1ll_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu16s(Test_B_BFu1ll_BFu16s, "B_BFu1ll_BFu16s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu17i  {
  bool v1;
  __tsu64 v2:1;
  unsigned int v3:17;
};
//SIG(1 B_BFu1ll_BFu17i) C1{ Fc FL:1 Fi:17}



static void Test_B_BFu1ll_BFu17i()
{
  {
    init_simple_test("B_BFu1ll_BFu17i");
    static B_BFu1ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "B_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "B_BFu1ll_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu17i(Test_B_BFu1ll_BFu17i, "B_BFu1ll_BFu17i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu17ll  {
  bool v1;
  __tsu64 v2:1;
  __tsu64 v3:17;
};
//SIG(1 B_BFu1ll_BFu17ll) C1{ Fc FL:1 FL:17}



static void Test_B_BFu1ll_BFu17ll()
{
  {
    init_simple_test("B_BFu1ll_BFu17ll");
    static B_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "B_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "B_BFu1ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu17ll(Test_B_BFu1ll_BFu17ll, "B_BFu1ll_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu1c  {
  bool v1;
  __tsu64 v2:1;
  unsigned char v3:1;
};
//SIG(1 B_BFu1ll_BFu1c) C1{ Fc FL:1 Fc:1}



static void Test_B_BFu1ll_BFu1c()
{
  {
    init_simple_test("B_BFu1ll_BFu1c");
    static B_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1ll_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu1c(Test_B_BFu1ll_BFu1c, "B_BFu1ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu1i  {
  bool v1;
  __tsu64 v2:1;
  unsigned int v3:1;
};
//SIG(1 B_BFu1ll_BFu1i) C1{ Fc FL:1 Fi:1}



static void Test_B_BFu1ll_BFu1i()
{
  {
    init_simple_test("B_BFu1ll_BFu1i");
    static B_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1ll_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu1i(Test_B_BFu1ll_BFu1i, "B_BFu1ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu1ll  {
  bool v1;
  __tsu64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 B_BFu1ll_BFu1ll) C1{ Fc FL:1 FL:1}



static void Test_B_BFu1ll_BFu1ll()
{
  {
    init_simple_test("B_BFu1ll_BFu1ll");
    static B_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu1ll(Test_B_BFu1ll_BFu1ll, "B_BFu1ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu1s  {
  bool v1;
  __tsu64 v2:1;
  unsigned short v3:1;
};
//SIG(1 B_BFu1ll_BFu1s) C1{ Fc FL:1 Fs:1}



static void Test_B_BFu1ll_BFu1s()
{
  {
    init_simple_test("B_BFu1ll_BFu1s");
    static B_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1ll_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu1s(Test_B_BFu1ll_BFu1s, "B_BFu1ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu31i  {
  bool v1;
  __tsu64 v2:1;
  unsigned int v3:31;
};
//SIG(1 B_BFu1ll_BFu31i) C1{ Fc FL:1 Fi:31}



static void Test_B_BFu1ll_BFu31i()
{
  {
    init_simple_test("B_BFu1ll_BFu31i");
    static B_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu1ll_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu31i(Test_B_BFu1ll_BFu31i, "B_BFu1ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu31ll  {
  bool v1;
  __tsu64 v2:1;
  __tsu64 v3:31;
};
//SIG(1 B_BFu1ll_BFu31ll) C1{ Fc FL:1 FL:31}



static void Test_B_BFu1ll_BFu31ll()
{
  {
    init_simple_test("B_BFu1ll_BFu31ll");
    static B_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "B_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "B_BFu1ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu31ll(Test_B_BFu1ll_BFu31ll, "B_BFu1ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu32i  {
  bool v1;
  __tsu64 v2:1;
  unsigned int v3:32;
};
//SIG(1 B_BFu1ll_BFu32i) C1{ Fc FL:1 Fi:32}



static void Test_B_BFu1ll_BFu32i()
{
  {
    init_simple_test("B_BFu1ll_BFu32i");
    static B_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu1ll_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu32i(Test_B_BFu1ll_BFu32i, "B_BFu1ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu32ll  {
  bool v1;
  __tsu64 v2:1;
  __tsu64 v3:32;
};
//SIG(1 B_BFu1ll_BFu32ll) C1{ Fc FL:1 FL:32}



static void Test_B_BFu1ll_BFu32ll()
{
  {
    init_simple_test("B_BFu1ll_BFu32ll");
    static B_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "B_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "B_BFu1ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu32ll(Test_B_BFu1ll_BFu32ll, "B_BFu1ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu33  {
  bool v1;
  __tsu64 v2:1;
  __tsu64 v3:33;
};
//SIG(1 B_BFu1ll_BFu33) C1{ Fc FL:1 FL:33}



static void Test_B_BFu1ll_BFu33()
{
  {
    init_simple_test("B_BFu1ll_BFu33");
    static B_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "B_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "B_BFu1ll_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu33(Test_B_BFu1ll_BFu33, "B_BFu1ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu7c  {
  bool v1;
  __tsu64 v2:1;
  unsigned char v3:7;
};
//SIG(1 B_BFu1ll_BFu7c) C1{ Fc FL:1 Fc:7}



static void Test_B_BFu1ll_BFu7c()
{
  {
    init_simple_test("B_BFu1ll_BFu7c");
    static B_BFu1ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1ll_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu7c(Test_B_BFu1ll_BFu7c, "B_BFu1ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu7i  {
  bool v1;
  __tsu64 v2:1;
  unsigned int v3:7;
};
//SIG(1 B_BFu1ll_BFu7i) C1{ Fc FL:1 Fi:7}



static void Test_B_BFu1ll_BFu7i()
{
  {
    init_simple_test("B_BFu1ll_BFu7i");
    static B_BFu1ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1ll_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu7i(Test_B_BFu1ll_BFu7i, "B_BFu1ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu7ll  {
  bool v1;
  __tsu64 v2:1;
  __tsu64 v3:7;
};
//SIG(1 B_BFu1ll_BFu7ll) C1{ Fc FL:1 FL:7}



static void Test_B_BFu1ll_BFu7ll()
{
  {
    init_simple_test("B_BFu1ll_BFu7ll");
    static B_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu7ll(Test_B_BFu1ll_BFu7ll, "B_BFu1ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu7s  {
  bool v1;
  __tsu64 v2:1;
  unsigned short v3:7;
};
//SIG(1 B_BFu1ll_BFu7s) C1{ Fc FL:1 Fs:7}



static void Test_B_BFu1ll_BFu7s()
{
  {
    init_simple_test("B_BFu1ll_BFu7s");
    static B_BFu1ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1ll_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu7s(Test_B_BFu1ll_BFu7s, "B_BFu1ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu8c  {
  bool v1;
  __tsu64 v2:1;
  unsigned char v3:8;
};
//SIG(1 B_BFu1ll_BFu8c) C1{ Fc FL:1 Fc:8}



static void Test_B_BFu1ll_BFu8c()
{
  {
    init_simple_test("B_BFu1ll_BFu8c");
    static B_BFu1ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu1ll_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu8c(Test_B_BFu1ll_BFu8c, "B_BFu1ll_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu8i  {
  bool v1;
  __tsu64 v2:1;
  unsigned int v3:8;
};
//SIG(1 B_BFu1ll_BFu8i) C1{ Fc FL:1 Fi:8}



static void Test_B_BFu1ll_BFu8i()
{
  {
    init_simple_test("B_BFu1ll_BFu8i");
    static B_BFu1ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "B_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "B_BFu1ll_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu8i(Test_B_BFu1ll_BFu8i, "B_BFu1ll_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu8ll  {
  bool v1;
  __tsu64 v2:1;
  __tsu64 v3:8;
};
//SIG(1 B_BFu1ll_BFu8ll) C1{ Fc FL:1 FL:8}



static void Test_B_BFu1ll_BFu8ll()
{
  {
    init_simple_test("B_BFu1ll_BFu8ll");
    static B_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "B_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "B_BFu1ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu8ll(Test_B_BFu1ll_BFu8ll, "B_BFu1ll_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu8s  {
  bool v1;
  __tsu64 v2:1;
  unsigned short v3:8;
};
//SIG(1 B_BFu1ll_BFu8s) C1{ Fc FL:1 Fs:8}



static void Test_B_BFu1ll_BFu8s()
{
  {
    init_simple_test("B_BFu1ll_BFu8s");
    static B_BFu1ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu1ll_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu8s(Test_B_BFu1ll_BFu8s, "B_BFu1ll_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu9i  {
  bool v1;
  __tsu64 v2:1;
  unsigned int v3:9;
};
//SIG(1 B_BFu1ll_BFu9i) C1{ Fc FL:1 Fi:9}



static void Test_B_BFu1ll_BFu9i()
{
  {
    init_simple_test("B_BFu1ll_BFu9i");
    static B_BFu1ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "B_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "B_BFu1ll_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu9i(Test_B_BFu1ll_BFu9i, "B_BFu1ll_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu9ll  {
  bool v1;
  __tsu64 v2:1;
  __tsu64 v3:9;
};
//SIG(1 B_BFu1ll_BFu9ll) C1{ Fc FL:1 FL:9}



static void Test_B_BFu1ll_BFu9ll()
{
  {
    init_simple_test("B_BFu1ll_BFu9ll");
    static B_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "B_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "B_BFu1ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu9ll(Test_B_BFu1ll_BFu9ll, "B_BFu1ll_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_BFu9s  {
  bool v1;
  __tsu64 v2:1;
  unsigned short v3:9;
};
//SIG(1 B_BFu1ll_BFu9s) C1{ Fc FL:1 Fs:9}



static void Test_B_BFu1ll_BFu9s()
{
  {
    init_simple_test("B_BFu1ll_BFu9s");
    static B_BFu1ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu1ll_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_BFu9s(Test_B_BFu1ll_BFu9s, "B_BFu1ll_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_C  {
  bool v1;
  __tsu64 v2:1;
  char v3;
};
//SIG(1 B_BFu1ll_C) C1{ Fc FL:1 Fc}



static void Test_B_BFu1ll_C()
{
  {
    init_simple_test("B_BFu1ll_C");
    static B_BFu1ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_C");
    check_field_offset(lv, v3, 2, "B_BFu1ll_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_C(Test_B_BFu1ll_C, "B_BFu1ll_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_D  {
  bool v1;
  __tsu64 v2:1;
  double v3;
};
//SIG(1 B_BFu1ll_D) C1{ Fc FL:1 FL}



static void Test_B_BFu1ll_D()
{
  {
    init_simple_test("B_BFu1ll_D");
    static B_BFu1ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu1ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1ll_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_D(Test_B_BFu1ll_D, "B_BFu1ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_F  {
  bool v1;
  __tsu64 v2:1;
  float v3;
};
//SIG(1 B_BFu1ll_F) C1{ Fc FL:1 Fi}



static void Test_B_BFu1ll_F()
{
  {
    init_simple_test("B_BFu1ll_F");
    static B_BFu1ll_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_F");
    check_field_offset(lv, v3, 4, "B_BFu1ll_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_F(Test_B_BFu1ll_F, "B_BFu1ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_I  {
  bool v1;
  __tsu64 v2:1;
  int v3;
};
//SIG(1 B_BFu1ll_I) C1{ Fc FL:1 Fi}



static void Test_B_BFu1ll_I()
{
  {
    init_simple_test("B_BFu1ll_I");
    static B_BFu1ll_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_I");
    check_field_offset(lv, v3, 4, "B_BFu1ll_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_I(Test_B_BFu1ll_I, "B_BFu1ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_Ip  {
  bool v1;
  __tsu64 v2:1;
  int *v3;
};
//SIG(1 B_BFu1ll_Ip) C1{ Fc FL:1 Fp}



static void Test_B_BFu1ll_Ip()
{
  {
    init_simple_test("B_BFu1ll_Ip");
    static B_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu1ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_Ip(Test_B_BFu1ll_Ip, "B_BFu1ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_L  {
  bool v1;
  __tsu64 v2:1;
  __tsi64 v3;
};
//SIG(1 B_BFu1ll_L) C1{ Fc FL:1 FL}



static void Test_B_BFu1ll_L()
{
  {
    init_simple_test("B_BFu1ll_L");
    static B_BFu1ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu1ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1ll_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_L(Test_B_BFu1ll_L, "B_BFu1ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_S  {
  bool v1;
  __tsu64 v2:1;
  short v3;
};
//SIG(1 B_BFu1ll_S) C1{ Fc FL:1 Fs}



static void Test_B_BFu1ll_S()
{
  {
    init_simple_test("B_BFu1ll_S");
    static B_BFu1ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_S");
    check_field_offset(lv, v3, 2, "B_BFu1ll_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_S(Test_B_BFu1ll_S, "B_BFu1ll_S", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_Uc  {
  bool v1;
  __tsu64 v2:1;
  unsigned char v3;
};
//SIG(1 B_BFu1ll_Uc) C1{ Fc FL:1 Fc}



static void Test_B_BFu1ll_Uc()
{
  {
    init_simple_test("B_BFu1ll_Uc");
    static B_BFu1ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_Uc");
    check_field_offset(lv, v3, 2, "B_BFu1ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_Uc(Test_B_BFu1ll_Uc, "B_BFu1ll_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_Ui  {
  bool v1;
  __tsu64 v2:1;
  unsigned int v3;
};
//SIG(1 B_BFu1ll_Ui) C1{ Fc FL:1 Fi}



static void Test_B_BFu1ll_Ui()
{
  {
    init_simple_test("B_BFu1ll_Ui");
    static B_BFu1ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_Ui");
    check_field_offset(lv, v3, 4, "B_BFu1ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_Ui(Test_B_BFu1ll_Ui, "B_BFu1ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_Ul  {
  bool v1;
  __tsu64 v2:1;
  __tsu64 v3;
};
//SIG(1 B_BFu1ll_Ul) C1{ Fc FL:1 FL}



static void Test_B_BFu1ll_Ul()
{
  {
    init_simple_test("B_BFu1ll_Ul");
    static B_BFu1ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu1ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_Ul(Test_B_BFu1ll_Ul, "B_BFu1ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_Us  {
  bool v1;
  __tsu64 v2:1;
  unsigned short v3;
};
//SIG(1 B_BFu1ll_Us) C1{ Fc FL:1 Fs}



static void Test_B_BFu1ll_Us()
{
  {
    init_simple_test("B_BFu1ll_Us");
    static B_BFu1ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_Us");
    check_field_offset(lv, v3, 2, "B_BFu1ll_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_Us(Test_B_BFu1ll_Us, "B_BFu1ll_Us", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1ll_Vp  {
  bool v1;
  __tsu64 v2:1;
  void *v3;
};
//SIG(1 B_BFu1ll_Vp) C1{ Fc FL:1 Fp}



static void Test_B_BFu1ll_Vp()
{
  {
    init_simple_test("B_BFu1ll_Vp");
    static B_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu1ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1ll_Vp(Test_B_BFu1ll_Vp, "B_BFu1ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s  {
  bool v1;
  unsigned short v2:1;
};
//SIG(1 B_BFu1s) C1{ Fc Fs:1}



static void Test_B_BFu1s()
{
  {
    init_simple_test("B_BFu1s");
    static B_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu1s(Test_B_BFu1s, "B_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_B  {
  bool v1;
  unsigned short v2:1;
  bool v3;
};
//SIG(1 B_BFu1s_B) C1{ Fc Fs:1 Fc}



static void Test_B_BFu1s_B()
{
  {
    init_simple_test("B_BFu1s_B");
    static B_BFu1s_B lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_B)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s_B)");
    check_field_offset(lv, v1, 0, "B_BFu1s_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_B");
    check_field_offset(lv, v3, 2, "B_BFu1s_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1s_B(Test_B_BFu1s_B, "B_BFu1s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu15i  {
  bool v1;
  unsigned short v2:1;
  unsigned int v3:15;
};
//SIG(1 B_BFu1s_BFu15i) C1{ Fc Fs:1 Fi:15}



static void Test_B_BFu1s_BFu15i()
{
  {
    init_simple_test("B_BFu1s_BFu15i");
    static B_BFu1s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "B_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "B_BFu1s_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu15i(Test_B_BFu1s_BFu15i, "B_BFu1s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu15ll  {
  bool v1;
  unsigned short v2:1;
  __tsu64 v3:15;
};
//SIG(1 B_BFu1s_BFu15ll) C1{ Fc Fs:1 FL:15}



static void Test_B_BFu1s_BFu15ll()
{
  {
    init_simple_test("B_BFu1s_BFu15ll");
    static B_BFu1s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "B_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "B_BFu1s_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu15ll(Test_B_BFu1s_BFu15ll, "B_BFu1s_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu15s  {
  bool v1;
  unsigned short v2:1;
  unsigned short v3:15;
};
//SIG(1 B_BFu1s_BFu15s) C1{ Fc Fs:1 Fs:15}



static void Test_B_BFu1s_BFu15s()
{
  {
    init_simple_test("B_BFu1s_BFu15s");
    static B_BFu1s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu1s_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu15s(Test_B_BFu1s_BFu15s, "B_BFu1s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu16i  {
  bool v1;
  unsigned short v2:1;
  unsigned int v3:16;
};
//SIG(1 B_BFu1s_BFu16i) C1{ Fc Fs:1 Fi:16}



static void Test_B_BFu1s_BFu16i()
{
  {
    init_simple_test("B_BFu1s_BFu16i");
    static B_BFu1s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "B_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "B_BFu1s_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu16i(Test_B_BFu1s_BFu16i, "B_BFu1s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu16ll  {
  bool v1;
  unsigned short v2:1;
  __tsu64 v3:16;
};
//SIG(1 B_BFu1s_BFu16ll) C1{ Fc Fs:1 FL:16}



static void Test_B_BFu1s_BFu16ll()
{
  {
    init_simple_test("B_BFu1s_BFu16ll");
    static B_BFu1s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "B_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "B_BFu1s_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu16ll(Test_B_BFu1s_BFu16ll, "B_BFu1s_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu16s  {
  bool v1;
  unsigned short v2:1;
  unsigned short v3:16;
};
//SIG(1 B_BFu1s_BFu16s) C1{ Fc Fs:1 Fs:16}



static void Test_B_BFu1s_BFu16s()
{
  {
    init_simple_test("B_BFu1s_BFu16s");
    static B_BFu1s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu1s_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu16s(Test_B_BFu1s_BFu16s, "B_BFu1s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu17i  {
  bool v1;
  unsigned short v2:1;
  unsigned int v3:17;
};
//SIG(1 B_BFu1s_BFu17i) C1{ Fc Fs:1 Fi:17}



static void Test_B_BFu1s_BFu17i()
{
  {
    init_simple_test("B_BFu1s_BFu17i");
    static B_BFu1s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "B_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "B_BFu1s_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu17i(Test_B_BFu1s_BFu17i, "B_BFu1s_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu17ll  {
  bool v1;
  unsigned short v2:1;
  __tsu64 v3:17;
};
//SIG(1 B_BFu1s_BFu17ll) C1{ Fc Fs:1 FL:17}



static void Test_B_BFu1s_BFu17ll()
{
  {
    init_simple_test("B_BFu1s_BFu17ll");
    static B_BFu1s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "B_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "B_BFu1s_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu17ll(Test_B_BFu1s_BFu17ll, "B_BFu1s_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu1c  {
  bool v1;
  unsigned short v2:1;
  unsigned char v3:1;
};
//SIG(1 B_BFu1s_BFu1c) C1{ Fc Fs:1 Fc:1}



static void Test_B_BFu1s_BFu1c()
{
  {
    init_simple_test("B_BFu1s_BFu1c");
    static B_BFu1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1s_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu1c(Test_B_BFu1s_BFu1c, "B_BFu1s_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu1i  {
  bool v1;
  unsigned short v2:1;
  unsigned int v3:1;
};
//SIG(1 B_BFu1s_BFu1i) C1{ Fc Fs:1 Fi:1}



static void Test_B_BFu1s_BFu1i()
{
  {
    init_simple_test("B_BFu1s_BFu1i");
    static B_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1s_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu1i(Test_B_BFu1s_BFu1i, "B_BFu1s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu1ll  {
  bool v1;
  unsigned short v2:1;
  __tsu64 v3:1;
};
//SIG(1 B_BFu1s_BFu1ll) C1{ Fc Fs:1 FL:1}



static void Test_B_BFu1s_BFu1ll()
{
  {
    init_simple_test("B_BFu1s_BFu1ll");
    static B_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1s_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu1ll(Test_B_BFu1s_BFu1ll, "B_BFu1s_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu1s  {
  bool v1;
  unsigned short v2:1;
  unsigned short v3:1;
};
//SIG(1 B_BFu1s_BFu1s) C1{ Fc Fs:1 Fs:1}



static void Test_B_BFu1s_BFu1s()
{
  {
    init_simple_test("B_BFu1s_BFu1s");
    static B_BFu1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "B_BFu1s_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu1s(Test_B_BFu1s_BFu1s, "B_BFu1s_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu31i  {
  bool v1;
  unsigned short v2:1;
  unsigned int v3:31;
};
//SIG(1 B_BFu1s_BFu31i) C1{ Fc Fs:1 Fi:31}



static void Test_B_BFu1s_BFu31i()
{
  {
    init_simple_test("B_BFu1s_BFu31i");
    static B_BFu1s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu1s_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu31i(Test_B_BFu1s_BFu31i, "B_BFu1s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu31ll  {
  bool v1;
  unsigned short v2:1;
  __tsu64 v3:31;
};
//SIG(1 B_BFu1s_BFu31ll) C1{ Fc Fs:1 FL:31}



static void Test_B_BFu1s_BFu31ll()
{
  {
    init_simple_test("B_BFu1s_BFu31ll");
    static B_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "B_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "B_BFu1s_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu31ll(Test_B_BFu1s_BFu31ll, "B_BFu1s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu32i  {
  bool v1;
  unsigned short v2:1;
  unsigned int v3:32;
};
//SIG(1 B_BFu1s_BFu32i) C1{ Fc Fs:1 Fi:32}



static void Test_B_BFu1s_BFu32i()
{
  {
    init_simple_test("B_BFu1s_BFu32i");
    static B_BFu1s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu1s_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu32i(Test_B_BFu1s_BFu32i, "B_BFu1s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu32ll  {
  bool v1;
  unsigned short v2:1;
  __tsu64 v3:32;
};
//SIG(1 B_BFu1s_BFu32ll) C1{ Fc Fs:1 FL:32}



static void Test_B_BFu1s_BFu32ll()
{
  {
    init_simple_test("B_BFu1s_BFu32ll");
    static B_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "B_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "B_BFu1s_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu32ll(Test_B_BFu1s_BFu32ll, "B_BFu1s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu33  {
  bool v1;
  unsigned short v2:1;
  __tsu64 v3:33;
};
//SIG(1 B_BFu1s_BFu33) C1{ Fc Fs:1 FL:33}



static void Test_B_BFu1s_BFu33()
{
  {
    init_simple_test("B_BFu1s_BFu33");
    static B_BFu1s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "B_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "B_BFu1s_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu33(Test_B_BFu1s_BFu33, "B_BFu1s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu7c  {
  bool v1;
  unsigned short v2:1;
  unsigned char v3:7;
};
//SIG(1 B_BFu1s_BFu7c) C1{ Fc Fs:1 Fc:7}



static void Test_B_BFu1s_BFu7c()
{
  {
    init_simple_test("B_BFu1s_BFu7c");
    static B_BFu1s_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1s_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu7c(Test_B_BFu1s_BFu7c, "B_BFu1s_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu7i  {
  bool v1;
  unsigned short v2:1;
  unsigned int v3:7;
};
//SIG(1 B_BFu1s_BFu7i) C1{ Fc Fs:1 Fi:7}



static void Test_B_BFu1s_BFu7i()
{
  {
    init_simple_test("B_BFu1s_BFu7i");
    static B_BFu1s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1s_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu7i(Test_B_BFu1s_BFu7i, "B_BFu1s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu7ll  {
  bool v1;
  unsigned short v2:1;
  __tsu64 v3:7;
};
//SIG(1 B_BFu1s_BFu7ll) C1{ Fc Fs:1 FL:7}



static void Test_B_BFu1s_BFu7ll()
{
  {
    init_simple_test("B_BFu1s_BFu7ll");
    static B_BFu1s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1s_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu7ll(Test_B_BFu1s_BFu7ll, "B_BFu1s_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu7s  {
  bool v1;
  unsigned short v2:1;
  unsigned short v3:7;
};
//SIG(1 B_BFu1s_BFu7s) C1{ Fc Fs:1 Fs:7}



static void Test_B_BFu1s_BFu7s()
{
  {
    init_simple_test("B_BFu1s_BFu7s");
    static B_BFu1s_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu1s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "B_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "B_BFu1s_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu7s(Test_B_BFu1s_BFu7s, "B_BFu1s_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu8c  {
  bool v1;
  unsigned short v2:1;
  unsigned char v3:8;
};
//SIG(1 B_BFu1s_BFu8c) C1{ Fc Fs:1 Fc:8}



static void Test_B_BFu1s_BFu8c()
{
  {
    init_simple_test("B_BFu1s_BFu8c");
    static B_BFu1s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu1s_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu8c(Test_B_BFu1s_BFu8c, "B_BFu1s_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu8i  {
  bool v1;
  unsigned short v2:1;
  unsigned int v3:8;
};
//SIG(1 B_BFu1s_BFu8i) C1{ Fc Fs:1 Fi:8}



static void Test_B_BFu1s_BFu8i()
{
  {
    init_simple_test("B_BFu1s_BFu8i");
    static B_BFu1s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "B_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "B_BFu1s_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu8i(Test_B_BFu1s_BFu8i, "B_BFu1s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu8ll  {
  bool v1;
  unsigned short v2:1;
  __tsu64 v3:8;
};
//SIG(1 B_BFu1s_BFu8ll) C1{ Fc Fs:1 FL:8}



static void Test_B_BFu1s_BFu8ll()
{
  {
    init_simple_test("B_BFu1s_BFu8ll");
    static B_BFu1s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "B_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "B_BFu1s_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu8ll(Test_B_BFu1s_BFu8ll, "B_BFu1s_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu8s  {
  bool v1;
  unsigned short v2:1;
  unsigned short v3:8;
};
//SIG(1 B_BFu1s_BFu8s) C1{ Fc Fs:1 Fs:8}



static void Test_B_BFu1s_BFu8s()
{
  {
    init_simple_test("B_BFu1s_BFu8s");
    static B_BFu1s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu1s_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu8s(Test_B_BFu1s_BFu8s, "B_BFu1s_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu9i  {
  bool v1;
  unsigned short v2:1;
  unsigned int v3:9;
};
//SIG(1 B_BFu1s_BFu9i) C1{ Fc Fs:1 Fi:9}



static void Test_B_BFu1s_BFu9i()
{
  {
    init_simple_test("B_BFu1s_BFu9i");
    static B_BFu1s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "B_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "B_BFu1s_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu9i(Test_B_BFu1s_BFu9i, "B_BFu1s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu9ll  {
  bool v1;
  unsigned short v2:1;
  __tsu64 v3:9;
};
//SIG(1 B_BFu1s_BFu9ll) C1{ Fc Fs:1 FL:9}



static void Test_B_BFu1s_BFu9ll()
{
  {
    init_simple_test("B_BFu1s_BFu9ll");
    static B_BFu1s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu1s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "B_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "B_BFu1s_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu9ll(Test_B_BFu1s_BFu9ll, "B_BFu1s_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_BFu9s  {
  bool v1;
  unsigned short v2:1;
  unsigned short v3:9;
};
//SIG(1 B_BFu1s_BFu9s) C1{ Fc Fs:1 Fs:9}



static void Test_B_BFu1s_BFu9s()
{
  {
    init_simple_test("B_BFu1s_BFu9s");
    static B_BFu1s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu1s_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu1s_BFu9s(Test_B_BFu1s_BFu9s, "B_BFu1s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_C  {
  bool v1;
  unsigned short v2:1;
  char v3;
};
//SIG(1 B_BFu1s_C) C1{ Fc Fs:1 Fc}



static void Test_B_BFu1s_C()
{
  {
    init_simple_test("B_BFu1s_C");
    static B_BFu1s_C lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_C)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s_C)");
    check_field_offset(lv, v1, 0, "B_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_C");
    check_field_offset(lv, v3, 2, "B_BFu1s_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1s_C(Test_B_BFu1s_C, "B_BFu1s_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_D  {
  bool v1;
  unsigned short v2:1;
  double v3;
};
//SIG(1 B_BFu1s_D) C1{ Fc Fs:1 FL}



static void Test_B_BFu1s_D()
{
  {
    init_simple_test("B_BFu1s_D");
    static B_BFu1s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu1s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_D)");
    check_field_offset(lv, v1, 0, "B_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1s_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1s_D(Test_B_BFu1s_D, "B_BFu1s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_F  {
  bool v1;
  unsigned short v2:1;
  float v3;
};
//SIG(1 B_BFu1s_F) C1{ Fc Fs:1 Fi}



static void Test_B_BFu1s_F()
{
  {
    init_simple_test("B_BFu1s_F");
    static B_BFu1s_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1s_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1s_F)");
    check_field_offset(lv, v1, 0, "B_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_F");
    check_field_offset(lv, v3, 4, "B_BFu1s_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1s_F(Test_B_BFu1s_F, "B_BFu1s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_I  {
  bool v1;
  unsigned short v2:1;
  int v3;
};
//SIG(1 B_BFu1s_I) C1{ Fc Fs:1 Fi}



static void Test_B_BFu1s_I()
{
  {
    init_simple_test("B_BFu1s_I");
    static B_BFu1s_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1s_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1s_I)");
    check_field_offset(lv, v1, 0, "B_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_I");
    check_field_offset(lv, v3, 4, "B_BFu1s_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1s_I(Test_B_BFu1s_I, "B_BFu1s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_Ip  {
  bool v1;
  unsigned short v2:1;
  int *v3;
};
//SIG(1 B_BFu1s_Ip) C1{ Fc Fs:1 Fp}



static void Test_B_BFu1s_Ip()
{
  {
    init_simple_test("B_BFu1s_Ip");
    static B_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu1s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1s_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1s_Ip(Test_B_BFu1s_Ip, "B_BFu1s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_L  {
  bool v1;
  unsigned short v2:1;
  __tsi64 v3;
};
//SIG(1 B_BFu1s_L) C1{ Fc Fs:1 FL}



static void Test_B_BFu1s_L()
{
  {
    init_simple_test("B_BFu1s_L");
    static B_BFu1s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu1s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_L)");
    check_field_offset(lv, v1, 0, "B_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1s_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1s_L(Test_B_BFu1s_L, "B_BFu1s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_S  {
  bool v1;
  unsigned short v2:1;
  short v3;
};
//SIG(1 B_BFu1s_S) C1{ Fc Fs:1 Fs}



static void Test_B_BFu1s_S()
{
  {
    init_simple_test("B_BFu1s_S");
    static B_BFu1s_S lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_S)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s_S)");
    check_field_offset(lv, v1, 0, "B_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_S");
    check_field_offset(lv, v3, 2, "B_BFu1s_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1s_S(Test_B_BFu1s_S, "B_BFu1s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_Uc  {
  bool v1;
  unsigned short v2:1;
  unsigned char v3;
};
//SIG(1 B_BFu1s_Uc) C1{ Fc Fs:1 Fc}



static void Test_B_BFu1s_Uc()
{
  {
    init_simple_test("B_BFu1s_Uc");
    static B_BFu1s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_Uc");
    check_field_offset(lv, v3, 2, "B_BFu1s_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1s_Uc(Test_B_BFu1s_Uc, "B_BFu1s_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_Ui  {
  bool v1;
  unsigned short v2:1;
  unsigned int v3;
};
//SIG(1 B_BFu1s_Ui) C1{ Fc Fs:1 Fi}



static void Test_B_BFu1s_Ui()
{
  {
    init_simple_test("B_BFu1s_Ui");
    static B_BFu1s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu1s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_Ui");
    check_field_offset(lv, v3, 4, "B_BFu1s_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1s_Ui(Test_B_BFu1s_Ui, "B_BFu1s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_Ul  {
  bool v1;
  unsigned short v2:1;
  __tsu64 v3;
};
//SIG(1 B_BFu1s_Ul) C1{ Fc Fs:1 FL}



static void Test_B_BFu1s_Ul()
{
  {
    init_simple_test("B_BFu1s_Ul");
    static B_BFu1s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu1s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1s_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1s_Ul(Test_B_BFu1s_Ul, "B_BFu1s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_Us  {
  bool v1;
  unsigned short v2:1;
  unsigned short v3;
};
//SIG(1 B_BFu1s_Us) C1{ Fc Fs:1 Fs}



static void Test_B_BFu1s_Us()
{
  {
    init_simple_test("B_BFu1s_Us");
    static B_BFu1s_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu1s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "B_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_Us");
    check_field_offset(lv, v3, 2, "B_BFu1s_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1s_Us(Test_B_BFu1s_Us, "B_BFu1s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu1s_Vp  {
  bool v1;
  unsigned short v2:1;
  void *v3;
};
//SIG(1 B_BFu1s_Vp) C1{ Fc Fs:1 Fp}



static void Test_B_BFu1s_Vp()
{
  {
    init_simple_test("B_BFu1s_Vp");
    static B_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu1s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "B_BFu1s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu1s_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu1s_Vp(Test_B_BFu1s_Vp, "B_BFu1s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i  {
  bool v1;
  unsigned int v2:31;
};
//SIG(1 B_BFu31i) C1{ Fc Fi:31}



static void Test_B_BFu31i()
{
  {
    init_simple_test("B_BFu31i");
    static B_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu31i(Test_B_BFu31i, "B_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_B  {
  bool v1;
  unsigned int v2:31;
  bool v3;
};
//SIG(1 B_BFu31i_B) C1{ Fc Fi:31 Fc}



static void Test_B_BFu31i_B()
{
  {
    init_simple_test("B_BFu31i_B");
    static B_BFu31i_B lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_B)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_B)");
    check_field_offset(lv, v1, 0, "B_BFu31i_B.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_B");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_B");
    check_field_offset(lv, v3, 8, "B_BFu31i_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31i_B(Test_B_BFu31i_B, "B_BFu31i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu15i  {
  bool v1;
  unsigned int v2:31;
  unsigned int v3:15;
};
//SIG(1 B_BFu31i_BFu15i) C1{ Fc Fi:31 Fi:15}



static void Test_B_BFu31i_BFu15i()
{
  {
    init_simple_test("B_BFu31i_BFu15i");
    static B_BFu31i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "B_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "B_BFu31i_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu15i(Test_B_BFu31i_BFu15i, "B_BFu31i_BFu15i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu15ll  {
  bool v1;
  unsigned int v2:31;
  __tsu64 v3:15;
};
//SIG(1 B_BFu31i_BFu15ll) C1{ Fc Fi:31 FL:15}



static void Test_B_BFu31i_BFu15ll()
{
  {
    init_simple_test("B_BFu31i_BFu15ll");
    static B_BFu31i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, 1, "B_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, hide_ull(1LL<<14), "B_BFu31i_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu15ll(Test_B_BFu31i_BFu15ll, "B_BFu31i_BFu15ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu15s  {
  bool v1;
  unsigned int v2:31;
  unsigned short v3:15;
};
//SIG(1 B_BFu31i_BFu15s) C1{ Fc Fi:31 Fs:15}



static void Test_B_BFu31i_BFu15s()
{
  {
    init_simple_test("B_BFu31i_BFu15s");
    static B_BFu31i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "B_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "B_BFu31i_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu15s(Test_B_BFu31i_BFu15s, "B_BFu31i_BFu15s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu16i  {
  bool v1;
  unsigned int v2:31;
  unsigned int v3:16;
};
//SIG(1 B_BFu31i_BFu16i) C1{ Fc Fi:31 Fi:16}



static void Test_B_BFu31i_BFu16i()
{
  {
    init_simple_test("B_BFu31i_BFu16i");
    static B_BFu31i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "B_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "B_BFu31i_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu16i(Test_B_BFu31i_BFu16i, "B_BFu31i_BFu16i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu16ll  {
  bool v1;
  unsigned int v2:31;
  __tsu64 v3:16;
};
//SIG(1 B_BFu31i_BFu16ll) C1{ Fc Fi:31 FL:16}



static void Test_B_BFu31i_BFu16ll()
{
  {
    init_simple_test("B_BFu31i_BFu16ll");
    static B_BFu31i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, 1, "B_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, hide_ull(1LL<<15), "B_BFu31i_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu16ll(Test_B_BFu31i_BFu16ll, "B_BFu31i_BFu16ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu16s  {
  bool v1;
  unsigned int v2:31;
  unsigned short v3:16;
};
//SIG(1 B_BFu31i_BFu16s) C1{ Fc Fi:31 Fs:16}



static void Test_B_BFu31i_BFu16s()
{
  {
    init_simple_test("B_BFu31i_BFu16s");
    static B_BFu31i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "B_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "B_BFu31i_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu16s(Test_B_BFu31i_BFu16s, "B_BFu31i_BFu16s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu17i  {
  bool v1;
  unsigned int v2:31;
  unsigned int v3:17;
};
//SIG(1 B_BFu31i_BFu17i) C1{ Fc Fi:31 Fi:17}



static void Test_B_BFu31i_BFu17i()
{
  {
    init_simple_test("B_BFu31i_BFu17i");
    static B_BFu31i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "B_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "B_BFu31i_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu17i(Test_B_BFu31i_BFu17i, "B_BFu31i_BFu17i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu17ll  {
  bool v1;
  unsigned int v2:31;
  __tsu64 v3:17;
};
//SIG(1 B_BFu31i_BFu17ll) C1{ Fc Fi:31 FL:17}



static void Test_B_BFu31i_BFu17ll()
{
  {
    init_simple_test("B_BFu31i_BFu17ll");
    static B_BFu31i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, 1, "B_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, hide_ull(1LL<<16), "B_BFu31i_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu17ll(Test_B_BFu31i_BFu17ll, "B_BFu31i_BFu17ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu1c  {
  bool v1;
  unsigned int v2:31;
  unsigned char v3:1;
};
//SIG(1 B_BFu31i_BFu1c) C1{ Fc Fi:31 Fc:1}



static void Test_B_BFu31i_BFu1c()
{
  {
    init_simple_test("B_BFu31i_BFu1c");
    static B_BFu31i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "B_BFu31i_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu1c(Test_B_BFu31i_BFu1c, "B_BFu31i_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu1i  {
  bool v1;
  unsigned int v2:31;
  unsigned int v3:1;
};
//SIG(1 B_BFu31i_BFu1i) C1{ Fc Fi:31 Fi:1}



static void Test_B_BFu31i_BFu1i()
{
  {
    init_simple_test("B_BFu31i_BFu1i");
    static B_BFu31i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "B_BFu31i_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu1i(Test_B_BFu31i_BFu1i, "B_BFu31i_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu1ll  {
  bool v1;
  unsigned int v2:31;
  __tsu64 v3:1;
};
//SIG(1 B_BFu31i_BFu1ll) C1{ Fc Fi:31 FL:1}



static void Test_B_BFu31i_BFu1ll()
{
  {
    init_simple_test("B_BFu31i_BFu1ll");
    static B_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "B_BFu31i_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu1ll(Test_B_BFu31i_BFu1ll, "B_BFu31i_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu1s  {
  bool v1;
  unsigned int v2:31;
  unsigned short v3:1;
};
//SIG(1 B_BFu31i_BFu1s) C1{ Fc Fi:31 Fs:1}



static void Test_B_BFu31i_BFu1s()
{
  {
    init_simple_test("B_BFu31i_BFu1s");
    static B_BFu31i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "B_BFu31i_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu1s(Test_B_BFu31i_BFu1s, "B_BFu31i_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu31i  {
  bool v1;
  unsigned int v2:31;
  unsigned int v3:31;
};
//SIG(1 B_BFu31i_BFu31i) C1{ Fc Fi:31 Fi:31}



static void Test_B_BFu31i_BFu31i()
{
  {
    init_simple_test("B_BFu31i_BFu31i");
    static B_BFu31i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "B_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu31i(Test_B_BFu31i_BFu31i, "B_BFu31i_BFu31i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu31ll  {
  bool v1;
  unsigned int v2:31;
  __tsu64 v3:31;
};
//SIG(1 B_BFu31i_BFu31ll) C1{ Fc Fi:31 FL:31}



static void Test_B_BFu31i_BFu31ll()
{
  {
    init_simple_test("B_BFu31i_BFu31ll");
    static B_BFu31i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "B_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_ull(1LL<<30), "B_BFu31i_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu31ll(Test_B_BFu31i_BFu31ll, "B_BFu31i_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu32i  {
  bool v1;
  unsigned int v2:31;
  unsigned int v3:32;
};
//SIG(1 B_BFu31i_BFu32i) C1{ Fc Fi:31 Fi:32}



static void Test_B_BFu31i_BFu32i()
{
  {
    init_simple_test("B_BFu31i_BFu32i");
    static B_BFu31i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "B_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "B_BFu31i_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu32i(Test_B_BFu31i_BFu32i, "B_BFu31i_BFu32i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu32ll  {
  bool v1;
  unsigned int v2:31;
  __tsu64 v3:32;
};
//SIG(1 B_BFu31i_BFu32ll) C1{ Fc Fi:31 FL:32}



static void Test_B_BFu31i_BFu32ll()
{
  {
    init_simple_test("B_BFu31i_BFu32ll");
    static B_BFu31i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, 1, "B_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, hide_ull(1LL<<31), "B_BFu31i_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu32ll(Test_B_BFu31i_BFu32ll, "B_BFu31i_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu33  {
  bool v1;
  unsigned int v2:31;
  __tsu64 v3:33;
};
//SIG(1 B_BFu31i_BFu33) C1{ Fc Fi:31 FL:33}



static void Test_B_BFu31i_BFu33()
{
  {
    init_simple_test("B_BFu31i_BFu33");
    static B_BFu31i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, 1, "B_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, hide_ull(1LL<<32), "B_BFu31i_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu33(Test_B_BFu31i_BFu33, "B_BFu31i_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu7c  {
  bool v1;
  unsigned int v2:31;
  unsigned char v3:7;
};
//SIG(1 B_BFu31i_BFu7c) C1{ Fc Fi:31 Fc:7}



static void Test_B_BFu31i_BFu7c()
{
  {
    init_simple_test("B_BFu31i_BFu7c");
    static B_BFu31i_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "B_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "B_BFu31i_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu7c(Test_B_BFu31i_BFu7c, "B_BFu31i_BFu7c", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu7i  {
  bool v1;
  unsigned int v2:31;
  unsigned int v3:7;
};
//SIG(1 B_BFu31i_BFu7i) C1{ Fc Fi:31 Fi:7}



static void Test_B_BFu31i_BFu7i()
{
  {
    init_simple_test("B_BFu31i_BFu7i");
    static B_BFu31i_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "B_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "B_BFu31i_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu7i(Test_B_BFu31i_BFu7i, "B_BFu31i_BFu7i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu7ll  {
  bool v1;
  unsigned int v2:31;
  __tsu64 v3:7;
};
//SIG(1 B_BFu31i_BFu7ll) C1{ Fc Fi:31 FL:7}



static void Test_B_BFu31i_BFu7ll()
{
  {
    init_simple_test("B_BFu31i_BFu7ll");
    static B_BFu31i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, 1, "B_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, hide_ull(1LL<<6), "B_BFu31i_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu7ll(Test_B_BFu31i_BFu7ll, "B_BFu31i_BFu7ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu7s  {
  bool v1;
  unsigned int v2:31;
  unsigned short v3:7;
};
//SIG(1 B_BFu31i_BFu7s) C1{ Fc Fi:31 Fs:7}



static void Test_B_BFu31i_BFu7s()
{
  {
    init_simple_test("B_BFu31i_BFu7s");
    static B_BFu31i_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "B_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "B_BFu31i_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu7s(Test_B_BFu31i_BFu7s, "B_BFu31i_BFu7s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu8c  {
  bool v1;
  unsigned int v2:31;
  unsigned char v3:8;
};
//SIG(1 B_BFu31i_BFu8c) C1{ Fc Fi:31 Fc:8}



static void Test_B_BFu31i_BFu8c()
{
  {
    init_simple_test("B_BFu31i_BFu8c");
    static B_BFu31i_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "B_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "B_BFu31i_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu8c(Test_B_BFu31i_BFu8c, "B_BFu31i_BFu8c", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu8i  {
  bool v1;
  unsigned int v2:31;
  unsigned int v3:8;
};
//SIG(1 B_BFu31i_BFu8i) C1{ Fc Fi:31 Fi:8}



static void Test_B_BFu31i_BFu8i()
{
  {
    init_simple_test("B_BFu31i_BFu8i");
    static B_BFu31i_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "B_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "B_BFu31i_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu8i(Test_B_BFu31i_BFu8i, "B_BFu31i_BFu8i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu8ll  {
  bool v1;
  unsigned int v2:31;
  __tsu64 v3:8;
};
//SIG(1 B_BFu31i_BFu8ll) C1{ Fc Fi:31 FL:8}



static void Test_B_BFu31i_BFu8ll()
{
  {
    init_simple_test("B_BFu31i_BFu8ll");
    static B_BFu31i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, 1, "B_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, hide_ull(1LL<<7), "B_BFu31i_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu8ll(Test_B_BFu31i_BFu8ll, "B_BFu31i_BFu8ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu8s  {
  bool v1;
  unsigned int v2:31;
  unsigned short v3:8;
};
//SIG(1 B_BFu31i_BFu8s) C1{ Fc Fi:31 Fs:8}



static void Test_B_BFu31i_BFu8s()
{
  {
    init_simple_test("B_BFu31i_BFu8s");
    static B_BFu31i_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "B_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "B_BFu31i_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu8s(Test_B_BFu31i_BFu8s, "B_BFu31i_BFu8s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu9i  {
  bool v1;
  unsigned int v2:31;
  unsigned int v3:9;
};
//SIG(1 B_BFu31i_BFu9i) C1{ Fc Fi:31 Fi:9}



static void Test_B_BFu31i_BFu9i()
{
  {
    init_simple_test("B_BFu31i_BFu9i");
    static B_BFu31i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "B_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "B_BFu31i_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu9i(Test_B_BFu31i_BFu9i, "B_BFu31i_BFu9i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu9ll  {
  bool v1;
  unsigned int v2:31;
  __tsu64 v3:9;
};
//SIG(1 B_BFu31i_BFu9ll) C1{ Fc Fi:31 FL:9}



static void Test_B_BFu31i_BFu9ll()
{
  {
    init_simple_test("B_BFu31i_BFu9ll");
    static B_BFu31i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, 1, "B_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, hide_ull(1LL<<8), "B_BFu31i_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu9ll(Test_B_BFu31i_BFu9ll, "B_BFu31i_BFu9ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_BFu9s  {
  bool v1;
  unsigned int v2:31;
  unsigned short v3:9;
};
//SIG(1 B_BFu31i_BFu9s) C1{ Fc Fi:31 Fs:9}



static void Test_B_BFu31i_BFu9s()
{
  {
    init_simple_test("B_BFu31i_BFu9s");
    static B_BFu31i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "B_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "B_BFu31i_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu31i_BFu9s(Test_B_BFu31i_BFu9s, "B_BFu31i_BFu9s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_C  {
  bool v1;
  unsigned int v2:31;
  char v3;
};
//SIG(1 B_BFu31i_C) C1{ Fc Fi:31 Fc}



static void Test_B_BFu31i_C()
{
  {
    init_simple_test("B_BFu31i_C");
    static B_BFu31i_C lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_C)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_C)");
    check_field_offset(lv, v1, 0, "B_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_C");
    check_field_offset(lv, v3, 8, "B_BFu31i_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31i_C(Test_B_BFu31i_C, "B_BFu31i_C", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_D  {
  bool v1;
  unsigned int v2:31;
  double v3;
};
//SIG(1 B_BFu31i_D) C1{ Fc Fi:31 FL}



static void Test_B_BFu31i_D()
{
  {
    init_simple_test("B_BFu31i_D");
    static B_BFu31i_D lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu31i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_D)");
    check_field_offset(lv, v1, 0, "B_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_D");
    check_field_offset(lv, v3, 8, "B_BFu31i_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31i_D(Test_B_BFu31i_D, "B_BFu31i_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_F  {
  bool v1;
  unsigned int v2:31;
  float v3;
};
//SIG(1 B_BFu31i_F) C1{ Fc Fi:31 Fi}



static void Test_B_BFu31i_F()
{
  {
    init_simple_test("B_BFu31i_F");
    static B_BFu31i_F lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_F)");
    check_field_offset(lv, v1, 0, "B_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_F");
    check_field_offset(lv, v3, 8, "B_BFu31i_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31i_F(Test_B_BFu31i_F, "B_BFu31i_F", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_I  {
  bool v1;
  unsigned int v2:31;
  int v3;
};
//SIG(1 B_BFu31i_I) C1{ Fc Fi:31 Fi}



static void Test_B_BFu31i_I()
{
  {
    init_simple_test("B_BFu31i_I");
    static B_BFu31i_I lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_I)");
    check_field_offset(lv, v1, 0, "B_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_I");
    check_field_offset(lv, v3, 8, "B_BFu31i_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31i_I(Test_B_BFu31i_I, "B_BFu31i_I", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_Ip  {
  bool v1;
  unsigned int v2:31;
  int *v3;
};
//SIG(1 B_BFu31i_Ip) C1{ Fc Fi:31 Fp}



static void Test_B_BFu31i_Ip()
{
  {
    init_simple_test("B_BFu31i_Ip");
    static B_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_Ip");
    check_field_offset(lv, v3, 8, "B_BFu31i_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31i_Ip(Test_B_BFu31i_Ip, "B_BFu31i_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_L  {
  bool v1;
  unsigned int v2:31;
  __tsi64 v3;
};
//SIG(1 B_BFu31i_L) C1{ Fc Fi:31 FL}



static void Test_B_BFu31i_L()
{
  {
    init_simple_test("B_BFu31i_L");
    static B_BFu31i_L lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu31i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_L)");
    check_field_offset(lv, v1, 0, "B_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_L");
    check_field_offset(lv, v3, 8, "B_BFu31i_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31i_L(Test_B_BFu31i_L, "B_BFu31i_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_S  {
  bool v1;
  unsigned int v2:31;
  short v3;
};
//SIG(1 B_BFu31i_S) C1{ Fc Fi:31 Fs}



static void Test_B_BFu31i_S()
{
  {
    init_simple_test("B_BFu31i_S");
    static B_BFu31i_S lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_S)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_S)");
    check_field_offset(lv, v1, 0, "B_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_S");
    check_field_offset(lv, v3, 8, "B_BFu31i_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31i_S(Test_B_BFu31i_S, "B_BFu31i_S", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_Uc  {
  bool v1;
  unsigned int v2:31;
  unsigned char v3;
};
//SIG(1 B_BFu31i_Uc) C1{ Fc Fi:31 Fc}



static void Test_B_BFu31i_Uc()
{
  {
    init_simple_test("B_BFu31i_Uc");
    static B_BFu31i_Uc lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_Uc");
    check_field_offset(lv, v3, 8, "B_BFu31i_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31i_Uc(Test_B_BFu31i_Uc, "B_BFu31i_Uc", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_Ui  {
  bool v1;
  unsigned int v2:31;
  unsigned int v3;
};
//SIG(1 B_BFu31i_Ui) C1{ Fc Fi:31 Fi}



static void Test_B_BFu31i_Ui()
{
  {
    init_simple_test("B_BFu31i_Ui");
    static B_BFu31i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_Ui");
    check_field_offset(lv, v3, 8, "B_BFu31i_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31i_Ui(Test_B_BFu31i_Ui, "B_BFu31i_Ui", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_Ul  {
  bool v1;
  unsigned int v2:31;
  __tsu64 v3;
};
//SIG(1 B_BFu31i_Ul) C1{ Fc Fi:31 FL}



static void Test_B_BFu31i_Ul()
{
  {
    init_simple_test("B_BFu31i_Ul");
    static B_BFu31i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu31i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_Ul");
    check_field_offset(lv, v3, 8, "B_BFu31i_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31i_Ul(Test_B_BFu31i_Ul, "B_BFu31i_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_Us  {
  bool v1;
  unsigned int v2:31;
  unsigned short v3;
};
//SIG(1 B_BFu31i_Us) C1{ Fc Fi:31 Fs}



static void Test_B_BFu31i_Us()
{
  {
    init_simple_test("B_BFu31i_Us");
    static B_BFu31i_Us lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu31i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "B_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_Us");
    check_field_offset(lv, v3, 8, "B_BFu31i_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31i_Us(Test_B_BFu31i_Us, "B_BFu31i_Us", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31i_Vp  {
  bool v1;
  unsigned int v2:31;
  void *v3;
};
//SIG(1 B_BFu31i_Vp) C1{ Fc Fi:31 Fp}



static void Test_B_BFu31i_Vp()
{
  {
    init_simple_test("B_BFu31i_Vp");
    static B_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "B_BFu31i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "B_BFu31i_Vp");
    check_field_offset(lv, v3, 8, "B_BFu31i_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31i_Vp(Test_B_BFu31i_Vp, "B_BFu31i_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll  {
  bool v1;
  __tsu64 v2:31;
};
//SIG(1 B_BFu31ll) C1{ Fc FL:31}



static void Test_B_BFu31ll()
{
  {
    init_simple_test("B_BFu31ll");
    static B_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu31ll(Test_B_BFu31ll, "B_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_B  {
  bool v1;
  __tsu64 v2:31;
  bool v3;
};
//SIG(1 B_BFu31ll_B) C1{ Fc FL:31 Fc}



static void Test_B_BFu31ll_B()
{
  {
    init_simple_test("B_BFu31ll_B");
    static B_BFu31ll_B lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_B)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_B");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_B");
    check_field_offset(lv, v3, 5, "B_BFu31ll_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_B(Test_B_BFu31ll_B, "B_BFu31ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu15i  {
  bool v1;
  __tsu64 v2:31;
  unsigned int v3:15;
};
//SIG(1 B_BFu31ll_BFu15i) C1{ Fc FL:31 Fi:15}



static void Test_B_BFu31ll_BFu15i()
{
  {
    init_simple_test("B_BFu31ll_BFu15i");
    static B_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "B_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "B_BFu31ll_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu15i(Test_B_BFu31ll_BFu15i, "B_BFu31ll_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu15ll  {
  bool v1;
  __tsu64 v2:31;
  __tsu64 v3:15;
};
//SIG(1 B_BFu31ll_BFu15ll) C1{ Fc FL:31 FL:15}



static void Test_B_BFu31ll_BFu15ll()
{
  {
    init_simple_test("B_BFu31ll_BFu15ll");
    static B_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "B_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "B_BFu31ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu15ll(Test_B_BFu31ll_BFu15ll, "B_BFu31ll_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu15s  {
  bool v1;
  __tsu64 v2:31;
  unsigned short v3:15;
};
//SIG(1 B_BFu31ll_BFu15s) C1{ Fc FL:31 Fs:15}



static void Test_B_BFu31ll_BFu15s()
{
  {
    init_simple_test("B_BFu31ll_BFu15s");
    static B_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "B_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "B_BFu31ll_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu15s(Test_B_BFu31ll_BFu15s, "B_BFu31ll_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu16i  {
  bool v1;
  __tsu64 v2:31;
  unsigned int v3:16;
};
//SIG(1 B_BFu31ll_BFu16i) C1{ Fc FL:31 Fi:16}



static void Test_B_BFu31ll_BFu16i()
{
  {
    init_simple_test("B_BFu31ll_BFu16i");
    static B_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "B_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "B_BFu31ll_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu16i(Test_B_BFu31ll_BFu16i, "B_BFu31ll_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu16ll  {
  bool v1;
  __tsu64 v2:31;
  __tsu64 v3:16;
};
//SIG(1 B_BFu31ll_BFu16ll) C1{ Fc FL:31 FL:16}



static void Test_B_BFu31ll_BFu16ll()
{
  {
    init_simple_test("B_BFu31ll_BFu16ll");
    static B_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "B_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "B_BFu31ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu16ll(Test_B_BFu31ll_BFu16ll, "B_BFu31ll_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu16s  {
  bool v1;
  __tsu64 v2:31;
  unsigned short v3:16;
};
//SIG(1 B_BFu31ll_BFu16s) C1{ Fc FL:31 Fs:16}



static void Test_B_BFu31ll_BFu16s()
{
  {
    init_simple_test("B_BFu31ll_BFu16s");
    static B_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "B_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "B_BFu31ll_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu16s(Test_B_BFu31ll_BFu16s, "B_BFu31ll_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu17i  {
  bool v1;
  __tsu64 v2:31;
  unsigned int v3:17;
};
//SIG(1 B_BFu31ll_BFu17i) C1{ Fc FL:31 Fi:17}



static void Test_B_BFu31ll_BFu17i()
{
  {
    init_simple_test("B_BFu31ll_BFu17i");
    static B_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "B_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "B_BFu31ll_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu17i(Test_B_BFu31ll_BFu17i, "B_BFu31ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu17ll  {
  bool v1;
  __tsu64 v2:31;
  __tsu64 v3:17;
};
//SIG(1 B_BFu31ll_BFu17ll) C1{ Fc FL:31 FL:17}



static void Test_B_BFu31ll_BFu17ll()
{
  {
    init_simple_test("B_BFu31ll_BFu17ll");
    static B_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "B_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "B_BFu31ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu17ll(Test_B_BFu31ll_BFu17ll, "B_BFu31ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu1c  {
  bool v1;
  __tsu64 v2:31;
  unsigned char v3:1;
};
//SIG(1 B_BFu31ll_BFu1c) C1{ Fc FL:31 Fc:1}



static void Test_B_BFu31ll_BFu1c()
{
  {
    init_simple_test("B_BFu31ll_BFu1c");
    static B_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "B_BFu31ll_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu1c(Test_B_BFu31ll_BFu1c, "B_BFu31ll_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu1i  {
  bool v1;
  __tsu64 v2:31;
  unsigned int v3:1;
};
//SIG(1 B_BFu31ll_BFu1i) C1{ Fc FL:31 Fi:1}



static void Test_B_BFu31ll_BFu1i()
{
  {
    init_simple_test("B_BFu31ll_BFu1i");
    static B_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "B_BFu31ll_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu1i(Test_B_BFu31ll_BFu1i, "B_BFu31ll_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu1ll  {
  bool v1;
  __tsu64 v2:31;
  __tsu64 v3:1;
};
//SIG(1 B_BFu31ll_BFu1ll) C1{ Fc FL:31 FL:1}



static void Test_B_BFu31ll_BFu1ll()
{
  {
    init_simple_test("B_BFu31ll_BFu1ll");
    static B_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "B_BFu31ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu1ll(Test_B_BFu31ll_BFu1ll, "B_BFu31ll_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu1s  {
  bool v1;
  __tsu64 v2:31;
  unsigned short v3:1;
};
//SIG(1 B_BFu31ll_BFu1s) C1{ Fc FL:31 Fs:1}



static void Test_B_BFu31ll_BFu1s()
{
  {
    init_simple_test("B_BFu31ll_BFu1s");
    static B_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "B_BFu31ll_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu1s(Test_B_BFu31ll_BFu1s, "B_BFu31ll_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu31i  {
  bool v1;
  __tsu64 v2:31;
  unsigned int v3:31;
};
//SIG(1 B_BFu31ll_BFu31i) C1{ Fc FL:31 Fi:31}



static void Test_B_BFu31ll_BFu31i()
{
  {
    init_simple_test("B_BFu31ll_BFu31i");
    static B_BFu31ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "B_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu31i(Test_B_BFu31ll_BFu31i, "B_BFu31ll_BFu31i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu31ll  {
  bool v1;
  __tsu64 v2:31;
  __tsu64 v3:31;
};
//SIG(1 B_BFu31ll_BFu31ll) C1{ Fc FL:31 FL:31}



static void Test_B_BFu31ll_BFu31ll()
{
  {
    init_simple_test("B_BFu31ll_BFu31ll");
    static B_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, 1, "B_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, hide_ull(1LL<<30), "B_BFu31ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu31ll(Test_B_BFu31ll_BFu31ll, "B_BFu31ll_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu32i  {
  bool v1;
  __tsu64 v2:31;
  unsigned int v3:32;
};
//SIG(1 B_BFu31ll_BFu32i) C1{ Fc FL:31 Fi:32}



static void Test_B_BFu31ll_BFu32i()
{
  {
    init_simple_test("B_BFu31ll_BFu32i");
    static B_BFu31ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "B_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "B_BFu31ll_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu32i(Test_B_BFu31ll_BFu32i, "B_BFu31ll_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu32ll  {
  bool v1;
  __tsu64 v2:31;
  __tsu64 v3:32;
};
//SIG(1 B_BFu31ll_BFu32ll) C1{ Fc FL:31 FL:32}



static void Test_B_BFu31ll_BFu32ll()
{
  {
    init_simple_test("B_BFu31ll_BFu32ll");
    static B_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, 1, "B_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, hide_ull(1LL<<31), "B_BFu31ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu32ll(Test_B_BFu31ll_BFu32ll, "B_BFu31ll_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu33  {
  bool v1;
  __tsu64 v2:31;
  __tsu64 v3:33;
};
//SIG(1 B_BFu31ll_BFu33) C1{ Fc FL:31 FL:33}



static void Test_B_BFu31ll_BFu33()
{
  {
    init_simple_test("B_BFu31ll_BFu33");
    static B_BFu31ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, 1, "B_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, hide_ull(1LL<<32), "B_BFu31ll_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu33(Test_B_BFu31ll_BFu33, "B_BFu31ll_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu7c  {
  bool v1;
  __tsu64 v2:31;
  unsigned char v3:7;
};
//SIG(1 B_BFu31ll_BFu7c) C1{ Fc FL:31 Fc:7}



static void Test_B_BFu31ll_BFu7c()
{
  {
    init_simple_test("B_BFu31ll_BFu7c");
    static B_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_BFu31ll_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu7c(Test_B_BFu31ll_BFu7c, "B_BFu31ll_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu7i  {
  bool v1;
  __tsu64 v2:31;
  unsigned int v3:7;
};
//SIG(1 B_BFu31ll_BFu7i) C1{ Fc FL:31 Fi:7}



static void Test_B_BFu31ll_BFu7i()
{
  {
    init_simple_test("B_BFu31ll_BFu7i");
    static B_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "B_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "B_BFu31ll_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu7i(Test_B_BFu31ll_BFu7i, "B_BFu31ll_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu7ll  {
  bool v1;
  __tsu64 v2:31;
  __tsu64 v3:7;
};
//SIG(1 B_BFu31ll_BFu7ll) C1{ Fc FL:31 FL:7}



static void Test_B_BFu31ll_BFu7ll()
{
  {
    init_simple_test("B_BFu31ll_BFu7ll");
    static B_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "B_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "B_BFu31ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu7ll(Test_B_BFu31ll_BFu7ll, "B_BFu31ll_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu7s  {
  bool v1;
  __tsu64 v2:31;
  unsigned short v3:7;
};
//SIG(1 B_BFu31ll_BFu7s) C1{ Fc FL:31 Fs:7}



static void Test_B_BFu31ll_BFu7s()
{
  {
    init_simple_test("B_BFu31ll_BFu7s");
    static B_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "B_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "B_BFu31ll_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu7s(Test_B_BFu31ll_BFu7s, "B_BFu31ll_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu8c  {
  bool v1;
  __tsu64 v2:31;
  unsigned char v3:8;
};
//SIG(1 B_BFu31ll_BFu8c) C1{ Fc FL:31 Fc:8}



static void Test_B_BFu31ll_BFu8c()
{
  {
    init_simple_test("B_BFu31ll_BFu8c");
    static B_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_BFu31ll_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu8c(Test_B_BFu31ll_BFu8c, "B_BFu31ll_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu8i  {
  bool v1;
  __tsu64 v2:31;
  unsigned int v3:8;
};
//SIG(1 B_BFu31ll_BFu8i) C1{ Fc FL:31 Fi:8}



static void Test_B_BFu31ll_BFu8i()
{
  {
    init_simple_test("B_BFu31ll_BFu8i");
    static B_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "B_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "B_BFu31ll_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu8i(Test_B_BFu31ll_BFu8i, "B_BFu31ll_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu8ll  {
  bool v1;
  __tsu64 v2:31;
  __tsu64 v3:8;
};
//SIG(1 B_BFu31ll_BFu8ll) C1{ Fc FL:31 FL:8}



static void Test_B_BFu31ll_BFu8ll()
{
  {
    init_simple_test("B_BFu31ll_BFu8ll");
    static B_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "B_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "B_BFu31ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu8ll(Test_B_BFu31ll_BFu8ll, "B_BFu31ll_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu8s  {
  bool v1;
  __tsu64 v2:31;
  unsigned short v3:8;
};
//SIG(1 B_BFu31ll_BFu8s) C1{ Fc FL:31 Fs:8}



static void Test_B_BFu31ll_BFu8s()
{
  {
    init_simple_test("B_BFu31ll_BFu8s");
    static B_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "B_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "B_BFu31ll_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu8s(Test_B_BFu31ll_BFu8s, "B_BFu31ll_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu9i  {
  bool v1;
  __tsu64 v2:31;
  unsigned int v3:9;
};
//SIG(1 B_BFu31ll_BFu9i) C1{ Fc FL:31 Fi:9}



static void Test_B_BFu31ll_BFu9i()
{
  {
    init_simple_test("B_BFu31ll_BFu9i");
    static B_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "B_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "B_BFu31ll_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu9i(Test_B_BFu31ll_BFu9i, "B_BFu31ll_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu9ll  {
  bool v1;
  __tsu64 v2:31;
  __tsu64 v3:9;
};
//SIG(1 B_BFu31ll_BFu9ll) C1{ Fc FL:31 FL:9}



static void Test_B_BFu31ll_BFu9ll()
{
  {
    init_simple_test("B_BFu31ll_BFu9ll");
    static B_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "B_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "B_BFu31ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu9ll(Test_B_BFu31ll_BFu9ll, "B_BFu31ll_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_BFu9s  {
  bool v1;
  __tsu64 v2:31;
  unsigned short v3:9;
};
//SIG(1 B_BFu31ll_BFu9s) C1{ Fc FL:31 Fs:9}



static void Test_B_BFu31ll_BFu9s()
{
  {
    init_simple_test("B_BFu31ll_BFu9s");
    static B_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "B_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "B_BFu31ll_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_BFu9s(Test_B_BFu31ll_BFu9s, "B_BFu31ll_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_C  {
  bool v1;
  __tsu64 v2:31;
  char v3;
};
//SIG(1 B_BFu31ll_C) C1{ Fc FL:31 Fc}



static void Test_B_BFu31ll_C()
{
  {
    init_simple_test("B_BFu31ll_C");
    static B_BFu31ll_C lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_C");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_C");
    check_field_offset(lv, v3, 5, "B_BFu31ll_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_C(Test_B_BFu31ll_C, "B_BFu31ll_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_D  {
  bool v1;
  __tsu64 v2:31;
  double v3;
};
//SIG(1 B_BFu31ll_D) C1{ Fc FL:31 FL}



static void Test_B_BFu31ll_D()
{
  {
    init_simple_test("B_BFu31ll_D");
    static B_BFu31ll_D lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu31ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_D");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_D");
    check_field_offset(lv, v3, 8, "B_BFu31ll_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_D(Test_B_BFu31ll_D, "B_BFu31ll_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_F  {
  bool v1;
  __tsu64 v2:31;
  float v3;
};
//SIG(1 B_BFu31ll_F) C1{ Fc FL:31 Fi}



static void Test_B_BFu31ll_F()
{
  {
    init_simple_test("B_BFu31ll_F");
    static B_BFu31ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_F");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_F");
    check_field_offset(lv, v3, 8, "B_BFu31ll_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_F(Test_B_BFu31ll_F, "B_BFu31ll_F", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_I  {
  bool v1;
  __tsu64 v2:31;
  int v3;
};
//SIG(1 B_BFu31ll_I) C1{ Fc FL:31 Fi}



static void Test_B_BFu31ll_I()
{
  {
    init_simple_test("B_BFu31ll_I");
    static B_BFu31ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_I");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_I");
    check_field_offset(lv, v3, 8, "B_BFu31ll_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_I(Test_B_BFu31ll_I, "B_BFu31ll_I", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_Ip  {
  bool v1;
  __tsu64 v2:31;
  int *v3;
};
//SIG(1 B_BFu31ll_Ip) C1{ Fc FL:31 Fp}



static void Test_B_BFu31ll_Ip()
{
  {
    init_simple_test("B_BFu31ll_Ip");
    static B_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_Ip");
    check_field_offset(lv, v3, 8, "B_BFu31ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_Ip(Test_B_BFu31ll_Ip, "B_BFu31ll_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_L  {
  bool v1;
  __tsu64 v2:31;
  __tsi64 v3;
};
//SIG(1 B_BFu31ll_L) C1{ Fc FL:31 FL}



static void Test_B_BFu31ll_L()
{
  {
    init_simple_test("B_BFu31ll_L");
    static B_BFu31ll_L lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu31ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_L");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_L");
    check_field_offset(lv, v3, 8, "B_BFu31ll_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_L(Test_B_BFu31ll_L, "B_BFu31ll_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_S  {
  bool v1;
  __tsu64 v2:31;
  short v3;
};
//SIG(1 B_BFu31ll_S) C1{ Fc FL:31 Fs}



static void Test_B_BFu31ll_S()
{
  {
    init_simple_test("B_BFu31ll_S");
    static B_BFu31ll_S lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_S");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_S");
    check_field_offset(lv, v3, 6, "B_BFu31ll_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_S(Test_B_BFu31ll_S, "B_BFu31ll_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_Uc  {
  bool v1;
  __tsu64 v2:31;
  unsigned char v3;
};
//SIG(1 B_BFu31ll_Uc) C1{ Fc FL:31 Fc}



static void Test_B_BFu31ll_Uc()
{
  {
    init_simple_test("B_BFu31ll_Uc");
    static B_BFu31ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_Uc");
    check_field_offset(lv, v3, 5, "B_BFu31ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_Uc(Test_B_BFu31ll_Uc, "B_BFu31ll_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_Ui  {
  bool v1;
  __tsu64 v2:31;
  unsigned int v3;
};
//SIG(1 B_BFu31ll_Ui) C1{ Fc FL:31 Fi}



static void Test_B_BFu31ll_Ui()
{
  {
    init_simple_test("B_BFu31ll_Ui");
    static B_BFu31ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_Ui");
    check_field_offset(lv, v3, 8, "B_BFu31ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_Ui(Test_B_BFu31ll_Ui, "B_BFu31ll_Ui", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_Ul  {
  bool v1;
  __tsu64 v2:31;
  __tsu64 v3;
};
//SIG(1 B_BFu31ll_Ul) C1{ Fc FL:31 FL}



static void Test_B_BFu31ll_Ul()
{
  {
    init_simple_test("B_BFu31ll_Ul");
    static B_BFu31ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu31ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_Ul");
    check_field_offset(lv, v3, 8, "B_BFu31ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_Ul(Test_B_BFu31ll_Ul, "B_BFu31ll_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_Us  {
  bool v1;
  __tsu64 v2:31;
  unsigned short v3;
};
//SIG(1 B_BFu31ll_Us) C1{ Fc FL:31 Fs}



static void Test_B_BFu31ll_Us()
{
  {
    init_simple_test("B_BFu31ll_Us");
    static B_BFu31ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu31ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_Us");
    check_field_offset(lv, v3, 6, "B_BFu31ll_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_Us(Test_B_BFu31ll_Us, "B_BFu31ll_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu31ll_Vp  {
  bool v1;
  __tsu64 v2:31;
  void *v3;
};
//SIG(1 B_BFu31ll_Vp) C1{ Fc FL:31 Fp}



static void Test_B_BFu31ll_Vp()
{
  {
    init_simple_test("B_BFu31ll_Vp");
    static B_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu31ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "B_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "B_BFu31ll_Vp");
    check_field_offset(lv, v3, 8, "B_BFu31ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu31ll_Vp(Test_B_BFu31ll_Vp, "B_BFu31ll_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i  {
  bool v1;
  unsigned int v2:32;
};
//SIG(1 B_BFu32i) C1{ Fc Fi:32}



static void Test_B_BFu32i()
{
  {
    init_simple_test("B_BFu32i");
    static B_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu32i(Test_B_BFu32i, "B_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_B  {
  bool v1;
  unsigned int v2:32;
  bool v3;
};
//SIG(1 B_BFu32i_B) C1{ Fc Fi:32 Fc}



static void Test_B_BFu32i_B()
{
  {
    init_simple_test("B_BFu32i_B");
    static B_BFu32i_B lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_B)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_B)");
    check_field_offset(lv, v1, 0, "B_BFu32i_B.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_B");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_B");
    check_field_offset(lv, v3, 8, "B_BFu32i_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32i_B(Test_B_BFu32i_B, "B_BFu32i_B", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu15i  {
  bool v1;
  unsigned int v2:32;
  unsigned int v3:15;
};
//SIG(1 B_BFu32i_BFu15i) C1{ Fc Fi:32 Fi:15}



static void Test_B_BFu32i_BFu15i()
{
  {
    init_simple_test("B_BFu32i_BFu15i");
    static B_BFu32i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "B_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "B_BFu32i_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu15i(Test_B_BFu32i_BFu15i, "B_BFu32i_BFu15i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu15ll  {
  bool v1;
  unsigned int v2:32;
  __tsu64 v3:15;
};
//SIG(1 B_BFu32i_BFu15ll) C1{ Fc Fi:32 FL:15}



static void Test_B_BFu32i_BFu15ll()
{
  {
    init_simple_test("B_BFu32i_BFu15ll");
    static B_BFu32i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "B_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "B_BFu32i_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu15ll(Test_B_BFu32i_BFu15ll, "B_BFu32i_BFu15ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu15s  {
  bool v1;
  unsigned int v2:32;
  unsigned short v3:15;
};
//SIG(1 B_BFu32i_BFu15s) C1{ Fc Fi:32 Fs:15}



static void Test_B_BFu32i_BFu15s()
{
  {
    init_simple_test("B_BFu32i_BFu15s");
    static B_BFu32i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "B_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "B_BFu32i_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu15s(Test_B_BFu32i_BFu15s, "B_BFu32i_BFu15s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu16i  {
  bool v1;
  unsigned int v2:32;
  unsigned int v3:16;
};
//SIG(1 B_BFu32i_BFu16i) C1{ Fc Fi:32 Fi:16}



static void Test_B_BFu32i_BFu16i()
{
  {
    init_simple_test("B_BFu32i_BFu16i");
    static B_BFu32i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "B_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "B_BFu32i_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu16i(Test_B_BFu32i_BFu16i, "B_BFu32i_BFu16i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu16ll  {
  bool v1;
  unsigned int v2:32;
  __tsu64 v3:16;
};
//SIG(1 B_BFu32i_BFu16ll) C1{ Fc Fi:32 FL:16}



static void Test_B_BFu32i_BFu16ll()
{
  {
    init_simple_test("B_BFu32i_BFu16ll");
    static B_BFu32i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "B_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "B_BFu32i_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu16ll(Test_B_BFu32i_BFu16ll, "B_BFu32i_BFu16ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu16s  {
  bool v1;
  unsigned int v2:32;
  unsigned short v3:16;
};
//SIG(1 B_BFu32i_BFu16s) C1{ Fc Fi:32 Fs:16}



static void Test_B_BFu32i_BFu16s()
{
  {
    init_simple_test("B_BFu32i_BFu16s");
    static B_BFu32i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "B_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "B_BFu32i_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu16s(Test_B_BFu32i_BFu16s, "B_BFu32i_BFu16s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu17i  {
  bool v1;
  unsigned int v2:32;
  unsigned int v3:17;
};
//SIG(1 B_BFu32i_BFu17i) C1{ Fc Fi:32 Fi:17}



static void Test_B_BFu32i_BFu17i()
{
  {
    init_simple_test("B_BFu32i_BFu17i");
    static B_BFu32i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "B_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "B_BFu32i_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu17i(Test_B_BFu32i_BFu17i, "B_BFu32i_BFu17i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu17ll  {
  bool v1;
  unsigned int v2:32;
  __tsu64 v3:17;
};
//SIG(1 B_BFu32i_BFu17ll) C1{ Fc Fi:32 FL:17}



static void Test_B_BFu32i_BFu17ll()
{
  {
    init_simple_test("B_BFu32i_BFu17ll");
    static B_BFu32i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "B_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "B_BFu32i_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu17ll(Test_B_BFu32i_BFu17ll, "B_BFu32i_BFu17ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu1c  {
  bool v1;
  unsigned int v2:32;
  unsigned char v3:1;
};
//SIG(1 B_BFu32i_BFu1c) C1{ Fc Fi:32 Fc:1}



static void Test_B_BFu32i_BFu1c()
{
  {
    init_simple_test("B_BFu32i_BFu1c");
    static B_BFu32i_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "B_BFu32i_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu1c(Test_B_BFu32i_BFu1c, "B_BFu32i_BFu1c", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu1i  {
  bool v1;
  unsigned int v2:32;
  unsigned int v3:1;
};
//SIG(1 B_BFu32i_BFu1i) C1{ Fc Fi:32 Fi:1}



static void Test_B_BFu32i_BFu1i()
{
  {
    init_simple_test("B_BFu32i_BFu1i");
    static B_BFu32i_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "B_BFu32i_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu1i(Test_B_BFu32i_BFu1i, "B_BFu32i_BFu1i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu1ll  {
  bool v1;
  unsigned int v2:32;
  __tsu64 v3:1;
};
//SIG(1 B_BFu32i_BFu1ll) C1{ Fc Fi:32 FL:1}



static void Test_B_BFu32i_BFu1ll()
{
  {
    init_simple_test("B_BFu32i_BFu1ll");
    static B_BFu32i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "B_BFu32i_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu1ll(Test_B_BFu32i_BFu1ll, "B_BFu32i_BFu1ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu1s  {
  bool v1;
  unsigned int v2:32;
  unsigned short v3:1;
};
//SIG(1 B_BFu32i_BFu1s) C1{ Fc Fi:32 Fs:1}



static void Test_B_BFu32i_BFu1s()
{
  {
    init_simple_test("B_BFu32i_BFu1s");
    static B_BFu32i_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "B_BFu32i_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu1s(Test_B_BFu32i_BFu1s, "B_BFu32i_BFu1s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu31i  {
  bool v1;
  unsigned int v2:32;
  unsigned int v3:31;
};
//SIG(1 B_BFu32i_BFu31i) C1{ Fc Fi:32 Fi:31}



static void Test_B_BFu32i_BFu31i()
{
  {
    init_simple_test("B_BFu32i_BFu31i");
    static B_BFu32i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "B_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "B_BFu32i_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu31i(Test_B_BFu32i_BFu31i, "B_BFu32i_BFu31i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu31ll  {
  bool v1;
  unsigned int v2:32;
  __tsu64 v3:31;
};
//SIG(1 B_BFu32i_BFu31ll) C1{ Fc Fi:32 FL:31}



static void Test_B_BFu32i_BFu31ll()
{
  {
    init_simple_test("B_BFu32i_BFu31ll");
    static B_BFu32i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "B_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "B_BFu32i_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu31ll(Test_B_BFu32i_BFu31ll, "B_BFu32i_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu32i  {
  bool v1;
  unsigned int v2:32;
  unsigned int v3:32;
};
//SIG(1 B_BFu32i_BFu32i) C1{ Fc Fi:32 Fi:32}



static void Test_B_BFu32i_BFu32i()
{
  {
    init_simple_test("B_BFu32i_BFu32i");
    static B_BFu32i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "B_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu32i(Test_B_BFu32i_BFu32i, "B_BFu32i_BFu32i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu32ll  {
  bool v1;
  unsigned int v2:32;
  __tsu64 v3:32;
};
//SIG(1 B_BFu32i_BFu32ll) C1{ Fc Fi:32 FL:32}



static void Test_B_BFu32i_BFu32ll()
{
  {
    init_simple_test("B_BFu32i_BFu32ll");
    static B_BFu32i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "B_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu32ll(Test_B_BFu32i_BFu32ll, "B_BFu32i_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu33  {
  bool v1;
  unsigned int v2:32;
  __tsu64 v3:33;
};
//SIG(1 B_BFu32i_BFu33) C1{ Fc Fi:32 FL:33}



static void Test_B_BFu32i_BFu33()
{
  {
    init_simple_test("B_BFu32i_BFu33");
    static B_BFu32i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu32i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "B_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "B_BFu32i_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu33(Test_B_BFu32i_BFu33, "B_BFu32i_BFu33", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu7c  {
  bool v1;
  unsigned int v2:32;
  unsigned char v3:7;
};
//SIG(1 B_BFu32i_BFu7c) C1{ Fc Fi:32 Fc:7}



static void Test_B_BFu32i_BFu7c()
{
  {
    init_simple_test("B_BFu32i_BFu7c");
    static B_BFu32i_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "B_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "B_BFu32i_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu7c(Test_B_BFu32i_BFu7c, "B_BFu32i_BFu7c", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu7i  {
  bool v1;
  unsigned int v2:32;
  unsigned int v3:7;
};
//SIG(1 B_BFu32i_BFu7i) C1{ Fc Fi:32 Fi:7}



static void Test_B_BFu32i_BFu7i()
{
  {
    init_simple_test("B_BFu32i_BFu7i");
    static B_BFu32i_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "B_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "B_BFu32i_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu7i(Test_B_BFu32i_BFu7i, "B_BFu32i_BFu7i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu7ll  {
  bool v1;
  unsigned int v2:32;
  __tsu64 v3:7;
};
//SIG(1 B_BFu32i_BFu7ll) C1{ Fc Fi:32 FL:7}



static void Test_B_BFu32i_BFu7ll()
{
  {
    init_simple_test("B_BFu32i_BFu7ll");
    static B_BFu32i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "B_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "B_BFu32i_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu7ll(Test_B_BFu32i_BFu7ll, "B_BFu32i_BFu7ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu7s  {
  bool v1;
  unsigned int v2:32;
  unsigned short v3:7;
};
//SIG(1 B_BFu32i_BFu7s) C1{ Fc Fi:32 Fs:7}



static void Test_B_BFu32i_BFu7s()
{
  {
    init_simple_test("B_BFu32i_BFu7s");
    static B_BFu32i_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "B_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "B_BFu32i_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu7s(Test_B_BFu32i_BFu7s, "B_BFu32i_BFu7s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu8c  {
  bool v1;
  unsigned int v2:32;
  unsigned char v3:8;
};
//SIG(1 B_BFu32i_BFu8c) C1{ Fc Fi:32 Fc:8}



static void Test_B_BFu32i_BFu8c()
{
  {
    init_simple_test("B_BFu32i_BFu8c");
    static B_BFu32i_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "B_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "B_BFu32i_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu8c(Test_B_BFu32i_BFu8c, "B_BFu32i_BFu8c", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu8i  {
  bool v1;
  unsigned int v2:32;
  unsigned int v3:8;
};
//SIG(1 B_BFu32i_BFu8i) C1{ Fc Fi:32 Fi:8}



static void Test_B_BFu32i_BFu8i()
{
  {
    init_simple_test("B_BFu32i_BFu8i");
    static B_BFu32i_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "B_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "B_BFu32i_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu8i(Test_B_BFu32i_BFu8i, "B_BFu32i_BFu8i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu8ll  {
  bool v1;
  unsigned int v2:32;
  __tsu64 v3:8;
};
//SIG(1 B_BFu32i_BFu8ll) C1{ Fc Fi:32 FL:8}



static void Test_B_BFu32i_BFu8ll()
{
  {
    init_simple_test("B_BFu32i_BFu8ll");
    static B_BFu32i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "B_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "B_BFu32i_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu8ll(Test_B_BFu32i_BFu8ll, "B_BFu32i_BFu8ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu8s  {
  bool v1;
  unsigned int v2:32;
  unsigned short v3:8;
};
//SIG(1 B_BFu32i_BFu8s) C1{ Fc Fi:32 Fs:8}



static void Test_B_BFu32i_BFu8s()
{
  {
    init_simple_test("B_BFu32i_BFu8s");
    static B_BFu32i_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "B_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "B_BFu32i_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu8s(Test_B_BFu32i_BFu8s, "B_BFu32i_BFu8s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu9i  {
  bool v1;
  unsigned int v2:32;
  unsigned int v3:9;
};
//SIG(1 B_BFu32i_BFu9i) C1{ Fc Fi:32 Fi:9}



static void Test_B_BFu32i_BFu9i()
{
  {
    init_simple_test("B_BFu32i_BFu9i");
    static B_BFu32i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "B_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "B_BFu32i_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu9i(Test_B_BFu32i_BFu9i, "B_BFu32i_BFu9i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu9ll  {
  bool v1;
  unsigned int v2:32;
  __tsu64 v3:9;
};
//SIG(1 B_BFu32i_BFu9ll) C1{ Fc Fi:32 FL:9}



static void Test_B_BFu32i_BFu9ll()
{
  {
    init_simple_test("B_BFu32i_BFu9ll");
    static B_BFu32i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "B_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "B_BFu32i_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu9ll(Test_B_BFu32i_BFu9ll, "B_BFu32i_BFu9ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_BFu9s  {
  bool v1;
  unsigned int v2:32;
  unsigned short v3:9;
};
//SIG(1 B_BFu32i_BFu9s) C1{ Fc Fi:32 Fs:9}



static void Test_B_BFu32i_BFu9s()
{
  {
    init_simple_test("B_BFu32i_BFu9s");
    static B_BFu32i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "B_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "B_BFu32i_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu32i_BFu9s(Test_B_BFu32i_BFu9s, "B_BFu32i_BFu9s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_C  {
  bool v1;
  unsigned int v2:32;
  char v3;
};
//SIG(1 B_BFu32i_C) C1{ Fc Fi:32 Fc}



static void Test_B_BFu32i_C()
{
  {
    init_simple_test("B_BFu32i_C");
    static B_BFu32i_C lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_C)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_C)");
    check_field_offset(lv, v1, 0, "B_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_C");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_C");
    check_field_offset(lv, v3, 8, "B_BFu32i_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32i_C(Test_B_BFu32i_C, "B_BFu32i_C", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_D  {
  bool v1;
  unsigned int v2:32;
  double v3;
};
//SIG(1 B_BFu32i_D) C1{ Fc Fi:32 FL}



static void Test_B_BFu32i_D()
{
  {
    init_simple_test("B_BFu32i_D");
    static B_BFu32i_D lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu32i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_D)");
    check_field_offset(lv, v1, 0, "B_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_D");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_D");
    check_field_offset(lv, v3, 8, "B_BFu32i_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32i_D(Test_B_BFu32i_D, "B_BFu32i_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_F  {
  bool v1;
  unsigned int v2:32;
  float v3;
};
//SIG(1 B_BFu32i_F) C1{ Fc Fi:32 Fi}



static void Test_B_BFu32i_F()
{
  {
    init_simple_test("B_BFu32i_F");
    static B_BFu32i_F lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_F)");
    check_field_offset(lv, v1, 0, "B_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_F");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_F");
    check_field_offset(lv, v3, 8, "B_BFu32i_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32i_F(Test_B_BFu32i_F, "B_BFu32i_F", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_I  {
  bool v1;
  unsigned int v2:32;
  int v3;
};
//SIG(1 B_BFu32i_I) C1{ Fc Fi:32 Fi}



static void Test_B_BFu32i_I()
{
  {
    init_simple_test("B_BFu32i_I");
    static B_BFu32i_I lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_I)");
    check_field_offset(lv, v1, 0, "B_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_I");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_I");
    check_field_offset(lv, v3, 8, "B_BFu32i_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32i_I(Test_B_BFu32i_I, "B_BFu32i_I", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_Ip  {
  bool v1;
  unsigned int v2:32;
  int *v3;
};
//SIG(1 B_BFu32i_Ip) C1{ Fc Fi:32 Fp}



static void Test_B_BFu32i_Ip()
{
  {
    init_simple_test("B_BFu32i_Ip");
    static B_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_Ip");
    check_field_offset(lv, v3, 8, "B_BFu32i_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32i_Ip(Test_B_BFu32i_Ip, "B_BFu32i_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_L  {
  bool v1;
  unsigned int v2:32;
  __tsi64 v3;
};
//SIG(1 B_BFu32i_L) C1{ Fc Fi:32 FL}



static void Test_B_BFu32i_L()
{
  {
    init_simple_test("B_BFu32i_L");
    static B_BFu32i_L lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu32i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_L)");
    check_field_offset(lv, v1, 0, "B_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_L");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_L");
    check_field_offset(lv, v3, 8, "B_BFu32i_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32i_L(Test_B_BFu32i_L, "B_BFu32i_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_S  {
  bool v1;
  unsigned int v2:32;
  short v3;
};
//SIG(1 B_BFu32i_S) C1{ Fc Fi:32 Fs}



static void Test_B_BFu32i_S()
{
  {
    init_simple_test("B_BFu32i_S");
    static B_BFu32i_S lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_S)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_S)");
    check_field_offset(lv, v1, 0, "B_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_S");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_S");
    check_field_offset(lv, v3, 8, "B_BFu32i_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32i_S(Test_B_BFu32i_S, "B_BFu32i_S", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_Uc  {
  bool v1;
  unsigned int v2:32;
  unsigned char v3;
};
//SIG(1 B_BFu32i_Uc) C1{ Fc Fi:32 Fc}



static void Test_B_BFu32i_Uc()
{
  {
    init_simple_test("B_BFu32i_Uc");
    static B_BFu32i_Uc lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_Uc");
    check_field_offset(lv, v3, 8, "B_BFu32i_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32i_Uc(Test_B_BFu32i_Uc, "B_BFu32i_Uc", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_Ui  {
  bool v1;
  unsigned int v2:32;
  unsigned int v3;
};
//SIG(1 B_BFu32i_Ui) C1{ Fc Fi:32 Fi}



static void Test_B_BFu32i_Ui()
{
  {
    init_simple_test("B_BFu32i_Ui");
    static B_BFu32i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_Ui");
    check_field_offset(lv, v3, 8, "B_BFu32i_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32i_Ui(Test_B_BFu32i_Ui, "B_BFu32i_Ui", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_Ul  {
  bool v1;
  unsigned int v2:32;
  __tsu64 v3;
};
//SIG(1 B_BFu32i_Ul) C1{ Fc Fi:32 FL}



static void Test_B_BFu32i_Ul()
{
  {
    init_simple_test("B_BFu32i_Ul");
    static B_BFu32i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu32i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_Ul");
    check_field_offset(lv, v3, 8, "B_BFu32i_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32i_Ul(Test_B_BFu32i_Ul, "B_BFu32i_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_Us  {
  bool v1;
  unsigned int v2:32;
  unsigned short v3;
};
//SIG(1 B_BFu32i_Us) C1{ Fc Fi:32 Fs}



static void Test_B_BFu32i_Us()
{
  {
    init_simple_test("B_BFu32i_Us");
    static B_BFu32i_Us lv;
    check2(sizeof(lv), 12, "sizeof(B_BFu32i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "B_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_Us");
    check_field_offset(lv, v3, 8, "B_BFu32i_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32i_Us(Test_B_BFu32i_Us, "B_BFu32i_Us", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32i_Vp  {
  bool v1;
  unsigned int v2:32;
  void *v3;
};
//SIG(1 B_BFu32i_Vp) C1{ Fc Fi:32 Fp}



static void Test_B_BFu32i_Vp()
{
  {
    init_simple_test("B_BFu32i_Vp");
    static B_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "B_BFu32i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "B_BFu32i_Vp");
    check_field_offset(lv, v3, 8, "B_BFu32i_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32i_Vp(Test_B_BFu32i_Vp, "B_BFu32i_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll  {
  bool v1;
  __tsu64 v2:32;
};
//SIG(1 B_BFu32ll) C1{ Fc FL:32}



static void Test_B_BFu32ll()
{
  {
    init_simple_test("B_BFu32ll");
    static B_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu32ll(Test_B_BFu32ll, "B_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_B  {
  bool v1;
  __tsu64 v2:32;
  bool v3;
};
//SIG(1 B_BFu32ll_B) C1{ Fc FL:32 Fc}



static void Test_B_BFu32ll_B()
{
  {
    init_simple_test("B_BFu32ll_B");
    static B_BFu32ll_B lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_B)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_B");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_B");
    check_field_offset(lv, v3, 5, "B_BFu32ll_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_B(Test_B_BFu32ll_B, "B_BFu32ll_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu15i  {
  bool v1;
  __tsu64 v2:32;
  unsigned int v3:15;
};
//SIG(1 B_BFu32ll_BFu15i) C1{ Fc FL:32 Fi:15}



static void Test_B_BFu32ll_BFu15i()
{
  {
    init_simple_test("B_BFu32ll_BFu15i");
    static B_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "B_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "B_BFu32ll_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu15i(Test_B_BFu32ll_BFu15i, "B_BFu32ll_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu15ll  {
  bool v1;
  __tsu64 v2:32;
  __tsu64 v3:15;
};
//SIG(1 B_BFu32ll_BFu15ll) C1{ Fc FL:32 FL:15}



static void Test_B_BFu32ll_BFu15ll()
{
  {
    init_simple_test("B_BFu32ll_BFu15ll");
    static B_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "B_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "B_BFu32ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu15ll(Test_B_BFu32ll_BFu15ll, "B_BFu32ll_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu15s  {
  bool v1;
  __tsu64 v2:32;
  unsigned short v3:15;
};
//SIG(1 B_BFu32ll_BFu15s) C1{ Fc FL:32 Fs:15}



static void Test_B_BFu32ll_BFu15s()
{
  {
    init_simple_test("B_BFu32ll_BFu15s");
    static B_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "B_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "B_BFu32ll_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu15s(Test_B_BFu32ll_BFu15s, "B_BFu32ll_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu16i  {
  bool v1;
  __tsu64 v2:32;
  unsigned int v3:16;
};
//SIG(1 B_BFu32ll_BFu16i) C1{ Fc FL:32 Fi:16}



static void Test_B_BFu32ll_BFu16i()
{
  {
    init_simple_test("B_BFu32ll_BFu16i");
    static B_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "B_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "B_BFu32ll_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu16i(Test_B_BFu32ll_BFu16i, "B_BFu32ll_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu16ll  {
  bool v1;
  __tsu64 v2:32;
  __tsu64 v3:16;
};
//SIG(1 B_BFu32ll_BFu16ll) C1{ Fc FL:32 FL:16}



static void Test_B_BFu32ll_BFu16ll()
{
  {
    init_simple_test("B_BFu32ll_BFu16ll");
    static B_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "B_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "B_BFu32ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu16ll(Test_B_BFu32ll_BFu16ll, "B_BFu32ll_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu16s  {
  bool v1;
  __tsu64 v2:32;
  unsigned short v3:16;
};
//SIG(1 B_BFu32ll_BFu16s) C1{ Fc FL:32 Fs:16}



static void Test_B_BFu32ll_BFu16s()
{
  {
    init_simple_test("B_BFu32ll_BFu16s");
    static B_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "B_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "B_BFu32ll_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu16s(Test_B_BFu32ll_BFu16s, "B_BFu32ll_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu17i  {
  bool v1;
  __tsu64 v2:32;
  unsigned int v3:17;
};
//SIG(1 B_BFu32ll_BFu17i) C1{ Fc FL:32 Fi:17}



static void Test_B_BFu32ll_BFu17i()
{
  {
    init_simple_test("B_BFu32ll_BFu17i");
    static B_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "B_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "B_BFu32ll_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu17i(Test_B_BFu32ll_BFu17i, "B_BFu32ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu17ll  {
  bool v1;
  __tsu64 v2:32;
  __tsu64 v3:17;
};
//SIG(1 B_BFu32ll_BFu17ll) C1{ Fc FL:32 FL:17}



static void Test_B_BFu32ll_BFu17ll()
{
  {
    init_simple_test("B_BFu32ll_BFu17ll");
    static B_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "B_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "B_BFu32ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu17ll(Test_B_BFu32ll_BFu17ll, "B_BFu32ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu1c  {
  bool v1;
  __tsu64 v2:32;
  unsigned char v3:1;
};
//SIG(1 B_BFu32ll_BFu1c) C1{ Fc FL:32 Fc:1}



static void Test_B_BFu32ll_BFu1c()
{
  {
    init_simple_test("B_BFu32ll_BFu1c");
    static B_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_BFu32ll_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu1c(Test_B_BFu32ll_BFu1c, "B_BFu32ll_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu1i  {
  bool v1;
  __tsu64 v2:32;
  unsigned int v3:1;
};
//SIG(1 B_BFu32ll_BFu1i) C1{ Fc FL:32 Fi:1}



static void Test_B_BFu32ll_BFu1i()
{
  {
    init_simple_test("B_BFu32ll_BFu1i");
    static B_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_BFu32ll_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu1i(Test_B_BFu32ll_BFu1i, "B_BFu32ll_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu1ll  {
  bool v1;
  __tsu64 v2:32;
  __tsu64 v3:1;
};
//SIG(1 B_BFu32ll_BFu1ll) C1{ Fc FL:32 FL:1}



static void Test_B_BFu32ll_BFu1ll()
{
  {
    init_simple_test("B_BFu32ll_BFu1ll");
    static B_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_BFu32ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu1ll(Test_B_BFu32ll_BFu1ll, "B_BFu32ll_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu1s  {
  bool v1;
  __tsu64 v2:32;
  unsigned short v3:1;
};
//SIG(1 B_BFu32ll_BFu1s) C1{ Fc FL:32 Fs:1}



static void Test_B_BFu32ll_BFu1s()
{
  {
    init_simple_test("B_BFu32ll_BFu1s");
    static B_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "B_BFu32ll_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu1s(Test_B_BFu32ll_BFu1s, "B_BFu32ll_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu31i  {
  bool v1;
  __tsu64 v2:32;
  unsigned int v3:31;
};
//SIG(1 B_BFu32ll_BFu31i) C1{ Fc FL:32 Fi:31}



static void Test_B_BFu32ll_BFu31i()
{
  {
    init_simple_test("B_BFu32ll_BFu31i");
    static B_BFu32ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "B_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "B_BFu32ll_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu31i(Test_B_BFu32ll_BFu31i, "B_BFu32ll_BFu31i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu31ll  {
  bool v1;
  __tsu64 v2:32;
  __tsu64 v3:31;
};
//SIG(1 B_BFu32ll_BFu31ll) C1{ Fc FL:32 FL:31}



static void Test_B_BFu32ll_BFu31ll()
{
  {
    init_simple_test("B_BFu32ll_BFu31ll");
    static B_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, 1, "B_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, hide_ull(1LL<<30), "B_BFu32ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu31ll(Test_B_BFu32ll_BFu31ll, "B_BFu32ll_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu32i  {
  bool v1;
  __tsu64 v2:32;
  unsigned int v3:32;
};
//SIG(1 B_BFu32ll_BFu32i) C1{ Fc FL:32 Fi:32}



static void Test_B_BFu32ll_BFu32i()
{
  {
    init_simple_test("B_BFu32ll_BFu32i");
    static B_BFu32ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "B_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu32i(Test_B_BFu32ll_BFu32i, "B_BFu32ll_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu32ll  {
  bool v1;
  __tsu64 v2:32;
  __tsu64 v3:32;
};
//SIG(1 B_BFu32ll_BFu32ll) C1{ Fc FL:32 FL:32}



static void Test_B_BFu32ll_BFu32ll()
{
  {
    init_simple_test("B_BFu32ll_BFu32ll");
    static B_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, 1, "B_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu32ll(Test_B_BFu32ll_BFu32ll, "B_BFu32ll_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu33  {
  bool v1;
  __tsu64 v2:32;
  __tsu64 v3:33;
};
//SIG(1 B_BFu32ll_BFu33) C1{ Fc FL:32 FL:33}



static void Test_B_BFu32ll_BFu33()
{
  {
    init_simple_test("B_BFu32ll_BFu33");
    static B_BFu32ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, 1, "B_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, hide_ull(1LL<<32), "B_BFu32ll_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu33(Test_B_BFu32ll_BFu33, "B_BFu32ll_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu7c  {
  bool v1;
  __tsu64 v2:32;
  unsigned char v3:7;
};
//SIG(1 B_BFu32ll_BFu7c) C1{ Fc FL:32 Fc:7}



static void Test_B_BFu32ll_BFu7c()
{
  {
    init_simple_test("B_BFu32ll_BFu7c");
    static B_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_BFu32ll_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu7c(Test_B_BFu32ll_BFu7c, "B_BFu32ll_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu7i  {
  bool v1;
  __tsu64 v2:32;
  unsigned int v3:7;
};
//SIG(1 B_BFu32ll_BFu7i) C1{ Fc FL:32 Fi:7}



static void Test_B_BFu32ll_BFu7i()
{
  {
    init_simple_test("B_BFu32ll_BFu7i");
    static B_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_BFu32ll_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu7i(Test_B_BFu32ll_BFu7i, "B_BFu32ll_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu7ll  {
  bool v1;
  __tsu64 v2:32;
  __tsu64 v3:7;
};
//SIG(1 B_BFu32ll_BFu7ll) C1{ Fc FL:32 FL:7}



static void Test_B_BFu32ll_BFu7ll()
{
  {
    init_simple_test("B_BFu32ll_BFu7ll");
    static B_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_BFu32ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu7ll(Test_B_BFu32ll_BFu7ll, "B_BFu32ll_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu7s  {
  bool v1;
  __tsu64 v2:32;
  unsigned short v3:7;
};
//SIG(1 B_BFu32ll_BFu7s) C1{ Fc FL:32 Fs:7}



static void Test_B_BFu32ll_BFu7s()
{
  {
    init_simple_test("B_BFu32ll_BFu7s");
    static B_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "B_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "B_BFu32ll_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu7s(Test_B_BFu32ll_BFu7s, "B_BFu32ll_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu8c  {
  bool v1;
  __tsu64 v2:32;
  unsigned char v3:8;
};
//SIG(1 B_BFu32ll_BFu8c) C1{ Fc FL:32 Fc:8}



static void Test_B_BFu32ll_BFu8c()
{
  {
    init_simple_test("B_BFu32ll_BFu8c");
    static B_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_BFu32ll_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu8c(Test_B_BFu32ll_BFu8c, "B_BFu32ll_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu8i  {
  bool v1;
  __tsu64 v2:32;
  unsigned int v3:8;
};
//SIG(1 B_BFu32ll_BFu8i) C1{ Fc FL:32 Fi:8}



static void Test_B_BFu32ll_BFu8i()
{
  {
    init_simple_test("B_BFu32ll_BFu8i");
    static B_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_BFu32ll_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu8i(Test_B_BFu32ll_BFu8i, "B_BFu32ll_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu8ll  {
  bool v1;
  __tsu64 v2:32;
  __tsu64 v3:8;
};
//SIG(1 B_BFu32ll_BFu8ll) C1{ Fc FL:32 FL:8}



static void Test_B_BFu32ll_BFu8ll()
{
  {
    init_simple_test("B_BFu32ll_BFu8ll");
    static B_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_BFu32ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu8ll(Test_B_BFu32ll_BFu8ll, "B_BFu32ll_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu8s  {
  bool v1;
  __tsu64 v2:32;
  unsigned short v3:8;
};
//SIG(1 B_BFu32ll_BFu8s) C1{ Fc FL:32 Fs:8}



static void Test_B_BFu32ll_BFu8s()
{
  {
    init_simple_test("B_BFu32ll_BFu8s");
    static B_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "B_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "B_BFu32ll_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu8s(Test_B_BFu32ll_BFu8s, "B_BFu32ll_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu9i  {
  bool v1;
  __tsu64 v2:32;
  unsigned int v3:9;
};
//SIG(1 B_BFu32ll_BFu9i) C1{ Fc FL:32 Fi:9}



static void Test_B_BFu32ll_BFu9i()
{
  {
    init_simple_test("B_BFu32ll_BFu9i");
    static B_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "B_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "B_BFu32ll_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu9i(Test_B_BFu32ll_BFu9i, "B_BFu32ll_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu9ll  {
  bool v1;
  __tsu64 v2:32;
  __tsu64 v3:9;
};
//SIG(1 B_BFu32ll_BFu9ll) C1{ Fc FL:32 FL:9}



static void Test_B_BFu32ll_BFu9ll()
{
  {
    init_simple_test("B_BFu32ll_BFu9ll");
    static B_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "B_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "B_BFu32ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu9ll(Test_B_BFu32ll_BFu9ll, "B_BFu32ll_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_BFu9s  {
  bool v1;
  __tsu64 v2:32;
  unsigned short v3:9;
};
//SIG(1 B_BFu32ll_BFu9s) C1{ Fc FL:32 Fs:9}



static void Test_B_BFu32ll_BFu9s()
{
  {
    init_simple_test("B_BFu32ll_BFu9s");
    static B_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "B_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "B_BFu32ll_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_BFu9s(Test_B_BFu32ll_BFu9s, "B_BFu32ll_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_C  {
  bool v1;
  __tsu64 v2:32;
  char v3;
};
//SIG(1 B_BFu32ll_C) C1{ Fc FL:32 Fc}



static void Test_B_BFu32ll_C()
{
  {
    init_simple_test("B_BFu32ll_C");
    static B_BFu32ll_C lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_C");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_C");
    check_field_offset(lv, v3, 5, "B_BFu32ll_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_C(Test_B_BFu32ll_C, "B_BFu32ll_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_D  {
  bool v1;
  __tsu64 v2:32;
  double v3;
};
//SIG(1 B_BFu32ll_D) C1{ Fc FL:32 FL}



static void Test_B_BFu32ll_D()
{
  {
    init_simple_test("B_BFu32ll_D");
    static B_BFu32ll_D lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu32ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_D");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_D");
    check_field_offset(lv, v3, 8, "B_BFu32ll_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_D(Test_B_BFu32ll_D, "B_BFu32ll_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_F  {
  bool v1;
  __tsu64 v2:32;
  float v3;
};
//SIG(1 B_BFu32ll_F) C1{ Fc FL:32 Fi}



static void Test_B_BFu32ll_F()
{
  {
    init_simple_test("B_BFu32ll_F");
    static B_BFu32ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_F");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_F");
    check_field_offset(lv, v3, 8, "B_BFu32ll_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_F(Test_B_BFu32ll_F, "B_BFu32ll_F", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_I  {
  bool v1;
  __tsu64 v2:32;
  int v3;
};
//SIG(1 B_BFu32ll_I) C1{ Fc FL:32 Fi}



static void Test_B_BFu32ll_I()
{
  {
    init_simple_test("B_BFu32ll_I");
    static B_BFu32ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_I");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_I");
    check_field_offset(lv, v3, 8, "B_BFu32ll_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_I(Test_B_BFu32ll_I, "B_BFu32ll_I", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_Ip  {
  bool v1;
  __tsu64 v2:32;
  int *v3;
};
//SIG(1 B_BFu32ll_Ip) C1{ Fc FL:32 Fp}



static void Test_B_BFu32ll_Ip()
{
  {
    init_simple_test("B_BFu32ll_Ip");
    static B_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_Ip");
    check_field_offset(lv, v3, 8, "B_BFu32ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_Ip(Test_B_BFu32ll_Ip, "B_BFu32ll_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_L  {
  bool v1;
  __tsu64 v2:32;
  __tsi64 v3;
};
//SIG(1 B_BFu32ll_L) C1{ Fc FL:32 FL}



static void Test_B_BFu32ll_L()
{
  {
    init_simple_test("B_BFu32ll_L");
    static B_BFu32ll_L lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu32ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_L");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_L");
    check_field_offset(lv, v3, 8, "B_BFu32ll_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_L(Test_B_BFu32ll_L, "B_BFu32ll_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_S  {
  bool v1;
  __tsu64 v2:32;
  short v3;
};
//SIG(1 B_BFu32ll_S) C1{ Fc FL:32 Fs}



static void Test_B_BFu32ll_S()
{
  {
    init_simple_test("B_BFu32ll_S");
    static B_BFu32ll_S lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_S");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_S");
    check_field_offset(lv, v3, 6, "B_BFu32ll_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_S(Test_B_BFu32ll_S, "B_BFu32ll_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_Uc  {
  bool v1;
  __tsu64 v2:32;
  unsigned char v3;
};
//SIG(1 B_BFu32ll_Uc) C1{ Fc FL:32 Fc}



static void Test_B_BFu32ll_Uc()
{
  {
    init_simple_test("B_BFu32ll_Uc");
    static B_BFu32ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_Uc");
    check_field_offset(lv, v3, 5, "B_BFu32ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_Uc(Test_B_BFu32ll_Uc, "B_BFu32ll_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_Ui  {
  bool v1;
  __tsu64 v2:32;
  unsigned int v3;
};
//SIG(1 B_BFu32ll_Ui) C1{ Fc FL:32 Fi}



static void Test_B_BFu32ll_Ui()
{
  {
    init_simple_test("B_BFu32ll_Ui");
    static B_BFu32ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_Ui");
    check_field_offset(lv, v3, 8, "B_BFu32ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_Ui(Test_B_BFu32ll_Ui, "B_BFu32ll_Ui", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_Ul  {
  bool v1;
  __tsu64 v2:32;
  __tsu64 v3;
};
//SIG(1 B_BFu32ll_Ul) C1{ Fc FL:32 FL}



static void Test_B_BFu32ll_Ul()
{
  {
    init_simple_test("B_BFu32ll_Ul");
    static B_BFu32ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu32ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_Ul");
    check_field_offset(lv, v3, 8, "B_BFu32ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_Ul(Test_B_BFu32ll_Ul, "B_BFu32ll_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_Us  {
  bool v1;
  __tsu64 v2:32;
  unsigned short v3;
};
//SIG(1 B_BFu32ll_Us) C1{ Fc FL:32 Fs}



static void Test_B_BFu32ll_Us()
{
  {
    init_simple_test("B_BFu32ll_Us");
    static B_BFu32ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu32ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_Us");
    check_field_offset(lv, v3, 6, "B_BFu32ll_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_Us(Test_B_BFu32ll_Us, "B_BFu32ll_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu32ll_Vp  {
  bool v1;
  __tsu64 v2:32;
  void *v3;
};
//SIG(1 B_BFu32ll_Vp) C1{ Fc FL:32 Fp}



static void Test_B_BFu32ll_Vp()
{
  {
    init_simple_test("B_BFu32ll_Vp");
    static B_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu32ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "B_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "B_BFu32ll_Vp");
    check_field_offset(lv, v3, 8, "B_BFu32ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu32ll_Vp(Test_B_BFu32ll_Vp, "B_BFu32ll_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33  {
  bool v1;
  __tsu64 v2:33;
};
//SIG(1 B_BFu33) C1{ Fc FL:33}



static void Test_B_BFu33()
{
  {
    init_simple_test("B_BFu33");
    static B_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu33(Test_B_BFu33, "B_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_B  {
  bool v1;
  __tsu64 v2:33;
  bool v3;
};
//SIG(1 B_BFu33_B) C1{ Fc FL:33 Fc}



static void Test_B_BFu33_B()
{
  {
    init_simple_test("B_BFu33_B");
    static B_BFu33_B lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_B)");
    check_field_offset(lv, v1, 0, "B_BFu33_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_B");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_B");
    check_field_offset(lv, v3, 6, "B_BFu33_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu33_B(Test_B_BFu33_B, "B_BFu33_B", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu15i  {
  bool v1;
  __tsu64 v2:33;
  unsigned int v3:15;
};
//SIG(1 B_BFu33_BFu15i) C1{ Fc FL:33 Fi:15}



static void Test_B_BFu33_BFu15i()
{
  {
    init_simple_test("B_BFu33_BFu15i");
    static B_BFu33_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "B_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "B_BFu33_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu15i(Test_B_BFu33_BFu15i, "B_BFu33_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu15ll  {
  bool v1;
  __tsu64 v2:33;
  __tsu64 v3:15;
};
//SIG(1 B_BFu33_BFu15ll) C1{ Fc FL:33 FL:15}



static void Test_B_BFu33_BFu15ll()
{
  {
    init_simple_test("B_BFu33_BFu15ll");
    static B_BFu33_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "B_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "B_BFu33_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu15ll(Test_B_BFu33_BFu15ll, "B_BFu33_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu15s  {
  bool v1;
  __tsu64 v2:33;
  unsigned short v3:15;
};
//SIG(1 B_BFu33_BFu15s) C1{ Fc FL:33 Fs:15}



static void Test_B_BFu33_BFu15s()
{
  {
    init_simple_test("B_BFu33_BFu15s");
    static B_BFu33_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "B_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "B_BFu33_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu15s(Test_B_BFu33_BFu15s, "B_BFu33_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu16i  {
  bool v1;
  __tsu64 v2:33;
  unsigned int v3:16;
};
//SIG(1 B_BFu33_BFu16i) C1{ Fc FL:33 Fi:16}



static void Test_B_BFu33_BFu16i()
{
  {
    init_simple_test("B_BFu33_BFu16i");
    static B_BFu33_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "B_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "B_BFu33_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu16i(Test_B_BFu33_BFu16i, "B_BFu33_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu16ll  {
  bool v1;
  __tsu64 v2:33;
  __tsu64 v3:16;
};
//SIG(1 B_BFu33_BFu16ll) C1{ Fc FL:33 FL:16}



static void Test_B_BFu33_BFu16ll()
{
  {
    init_simple_test("B_BFu33_BFu16ll");
    static B_BFu33_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "B_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "B_BFu33_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu16ll(Test_B_BFu33_BFu16ll, "B_BFu33_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu16s  {
  bool v1;
  __tsu64 v2:33;
  unsigned short v3:16;
};
//SIG(1 B_BFu33_BFu16s) C1{ Fc FL:33 Fs:16}



static void Test_B_BFu33_BFu16s()
{
  {
    init_simple_test("B_BFu33_BFu16s");
    static B_BFu33_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "B_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "B_BFu33_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu16s(Test_B_BFu33_BFu16s, "B_BFu33_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu17i  {
  bool v1;
  __tsu64 v2:33;
  unsigned int v3:17;
};
//SIG(1 B_BFu33_BFu17i) C1{ Fc FL:33 Fi:17}



static void Test_B_BFu33_BFu17i()
{
  {
    init_simple_test("B_BFu33_BFu17i");
    static B_BFu33_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "B_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "B_BFu33_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu17i(Test_B_BFu33_BFu17i, "B_BFu33_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu17ll  {
  bool v1;
  __tsu64 v2:33;
  __tsu64 v3:17;
};
//SIG(1 B_BFu33_BFu17ll) C1{ Fc FL:33 FL:17}



static void Test_B_BFu33_BFu17ll()
{
  {
    init_simple_test("B_BFu33_BFu17ll");
    static B_BFu33_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "B_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "B_BFu33_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu17ll(Test_B_BFu33_BFu17ll, "B_BFu33_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu1c  {
  bool v1;
  __tsu64 v2:33;
  unsigned char v3:1;
};
//SIG(1 B_BFu33_BFu1c) C1{ Fc FL:33 Fc:1}



static void Test_B_BFu33_BFu1c()
{
  {
    init_simple_test("B_BFu33_BFu1c");
    static B_BFu33_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "B_BFu33_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu1c(Test_B_BFu33_BFu1c, "B_BFu33_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu1i  {
  bool v1;
  __tsu64 v2:33;
  unsigned int v3:1;
};
//SIG(1 B_BFu33_BFu1i) C1{ Fc FL:33 Fi:1}



static void Test_B_BFu33_BFu1i()
{
  {
    init_simple_test("B_BFu33_BFu1i");
    static B_BFu33_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "B_BFu33_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu1i(Test_B_BFu33_BFu1i, "B_BFu33_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu1ll  {
  bool v1;
  __tsu64 v2:33;
  __tsu64 v3:1;
};
//SIG(1 B_BFu33_BFu1ll) C1{ Fc FL:33 FL:1}



static void Test_B_BFu33_BFu1ll()
{
  {
    init_simple_test("B_BFu33_BFu1ll");
    static B_BFu33_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "B_BFu33_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu1ll(Test_B_BFu33_BFu1ll, "B_BFu33_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu1s  {
  bool v1;
  __tsu64 v2:33;
  unsigned short v3:1;
};
//SIG(1 B_BFu33_BFu1s) C1{ Fc FL:33 Fs:1}



static void Test_B_BFu33_BFu1s()
{
  {
    init_simple_test("B_BFu33_BFu1s");
    static B_BFu33_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "B_BFu33_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu1s(Test_B_BFu33_BFu1s, "B_BFu33_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu31i  {
  bool v1;
  __tsu64 v2:33;
  unsigned int v3:31;
};
//SIG(1 B_BFu33_BFu31i) C1{ Fc FL:33 Fi:31}



static void Test_B_BFu33_BFu31i()
{
  {
    init_simple_test("B_BFu33_BFu31i");
    static B_BFu33_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu33_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "B_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "B_BFu33_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu31i(Test_B_BFu33_BFu31i, "B_BFu33_BFu31i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu31ll  {
  bool v1;
  __tsu64 v2:33;
  __tsu64 v3:31;
};
//SIG(1 B_BFu33_BFu31ll) C1{ Fc FL:33 FL:31}



static void Test_B_BFu33_BFu31ll()
{
  {
    init_simple_test("B_BFu33_BFu31ll");
    static B_BFu33_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu33_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 31, 1, "B_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 31, hide_ull(1LL<<30), "B_BFu33_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu31ll(Test_B_BFu33_BFu31ll, "B_BFu33_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu32i  {
  bool v1;
  __tsu64 v2:33;
  unsigned int v3:32;
};
//SIG(1 B_BFu33_BFu32i) C1{ Fc FL:33 Fi:32}



static void Test_B_BFu33_BFu32i()
{
  {
    init_simple_test("B_BFu33_BFu32i");
    static B_BFu33_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu33_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "B_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "B_BFu33_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu32i(Test_B_BFu33_BFu32i, "B_BFu33_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu32ll  {
  bool v1;
  __tsu64 v2:33;
  __tsu64 v3:32;
};
//SIG(1 B_BFu33_BFu32ll) C1{ Fc FL:33 FL:32}



static void Test_B_BFu33_BFu32ll()
{
  {
    init_simple_test("B_BFu33_BFu32ll");
    static B_BFu33_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu33_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 32, 1, "B_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 32, hide_ull(1LL<<31), "B_BFu33_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu32ll(Test_B_BFu33_BFu32ll, "B_BFu33_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu33  {
  bool v1;
  __tsu64 v2:33;
  __tsu64 v3:33;
};
//SIG(1 B_BFu33_BFu33) C1{ Fc FL:33 FL:33}



static void Test_B_BFu33_BFu33()
{
  {
    init_simple_test("B_BFu33_BFu33");
    static B_BFu33_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu33_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 33, 1, "B_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 33, hide_ull(1LL<<32), "B_BFu33_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu33(Test_B_BFu33_BFu33, "B_BFu33_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu7c  {
  bool v1;
  __tsu64 v2:33;
  unsigned char v3:7;
};
//SIG(1 B_BFu33_BFu7c) C1{ Fc FL:33 Fc:7}



static void Test_B_BFu33_BFu7c()
{
  {
    init_simple_test("B_BFu33_BFu7c");
    static B_BFu33_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "B_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "B_BFu33_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu7c(Test_B_BFu33_BFu7c, "B_BFu33_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu7i  {
  bool v1;
  __tsu64 v2:33;
  unsigned int v3:7;
};
//SIG(1 B_BFu33_BFu7i) C1{ Fc FL:33 Fi:7}



static void Test_B_BFu33_BFu7i()
{
  {
    init_simple_test("B_BFu33_BFu7i");
    static B_BFu33_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "B_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "B_BFu33_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu7i(Test_B_BFu33_BFu7i, "B_BFu33_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu7ll  {
  bool v1;
  __tsu64 v2:33;
  __tsu64 v3:7;
};
//SIG(1 B_BFu33_BFu7ll) C1{ Fc FL:33 FL:7}



static void Test_B_BFu33_BFu7ll()
{
  {
    init_simple_test("B_BFu33_BFu7ll");
    static B_BFu33_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "B_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "B_BFu33_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu7ll(Test_B_BFu33_BFu7ll, "B_BFu33_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu7s  {
  bool v1;
  __tsu64 v2:33;
  unsigned short v3:7;
};
//SIG(1 B_BFu33_BFu7s) C1{ Fc FL:33 Fs:7}



static void Test_B_BFu33_BFu7s()
{
  {
    init_simple_test("B_BFu33_BFu7s");
    static B_BFu33_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "B_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "B_BFu33_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu7s(Test_B_BFu33_BFu7s, "B_BFu33_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu8c  {
  bool v1;
  __tsu64 v2:33;
  unsigned char v3:8;
};
//SIG(1 B_BFu33_BFu8c) C1{ Fc FL:33 Fc:8}



static void Test_B_BFu33_BFu8c()
{
  {
    init_simple_test("B_BFu33_BFu8c");
    static B_BFu33_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "B_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "B_BFu33_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu8c(Test_B_BFu33_BFu8c, "B_BFu33_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu8i  {
  bool v1;
  __tsu64 v2:33;
  unsigned int v3:8;
};
//SIG(1 B_BFu33_BFu8i) C1{ Fc FL:33 Fi:8}



static void Test_B_BFu33_BFu8i()
{
  {
    init_simple_test("B_BFu33_BFu8i");
    static B_BFu33_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "B_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "B_BFu33_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu8i(Test_B_BFu33_BFu8i, "B_BFu33_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu8ll  {
  bool v1;
  __tsu64 v2:33;
  __tsu64 v3:8;
};
//SIG(1 B_BFu33_BFu8ll) C1{ Fc FL:33 FL:8}



static void Test_B_BFu33_BFu8ll()
{
  {
    init_simple_test("B_BFu33_BFu8ll");
    static B_BFu33_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "B_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "B_BFu33_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu8ll(Test_B_BFu33_BFu8ll, "B_BFu33_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu8s  {
  bool v1;
  __tsu64 v2:33;
  unsigned short v3:8;
};
//SIG(1 B_BFu33_BFu8s) C1{ Fc FL:33 Fs:8}



static void Test_B_BFu33_BFu8s()
{
  {
    init_simple_test("B_BFu33_BFu8s");
    static B_BFu33_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "B_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "B_BFu33_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu8s(Test_B_BFu33_BFu8s, "B_BFu33_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu9i  {
  bool v1;
  __tsu64 v2:33;
  unsigned int v3:9;
};
//SIG(1 B_BFu33_BFu9i) C1{ Fc FL:33 Fi:9}



static void Test_B_BFu33_BFu9i()
{
  {
    init_simple_test("B_BFu33_BFu9i");
    static B_BFu33_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "B_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "B_BFu33_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu9i(Test_B_BFu33_BFu9i, "B_BFu33_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu9ll  {
  bool v1;
  __tsu64 v2:33;
  __tsu64 v3:9;
};
//SIG(1 B_BFu33_BFu9ll) C1{ Fc FL:33 FL:9}



static void Test_B_BFu33_BFu9ll()
{
  {
    init_simple_test("B_BFu33_BFu9ll");
    static B_BFu33_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "B_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "B_BFu33_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu9ll(Test_B_BFu33_BFu9ll, "B_BFu33_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_BFu9s  {
  bool v1;
  __tsu64 v2:33;
  unsigned short v3:9;
};
//SIG(1 B_BFu33_BFu9s) C1{ Fc FL:33 Fs:9}



static void Test_B_BFu33_BFu9s()
{
  {
    init_simple_test("B_BFu33_BFu9s");
    static B_BFu33_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "B_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "B_BFu33_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu33_BFu9s(Test_B_BFu33_BFu9s, "B_BFu33_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_C  {
  bool v1;
  __tsu64 v2:33;
  char v3;
};
//SIG(1 B_BFu33_C) C1{ Fc FL:33 Fc}



static void Test_B_BFu33_C()
{
  {
    init_simple_test("B_BFu33_C");
    static B_BFu33_C lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_C)");
    check_field_offset(lv, v1, 0, "B_BFu33_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_C");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_C");
    check_field_offset(lv, v3, 6, "B_BFu33_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu33_C(Test_B_BFu33_C, "B_BFu33_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_D  {
  bool v1;
  __tsu64 v2:33;
  double v3;
};
//SIG(1 B_BFu33_D) C1{ Fc FL:33 FL}



static void Test_B_BFu33_D()
{
  {
    init_simple_test("B_BFu33_D");
    static B_BFu33_D lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu33_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_D)");
    check_field_offset(lv, v1, 0, "B_BFu33_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_D");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_D");
    check_field_offset(lv, v3, 8, "B_BFu33_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu33_D(Test_B_BFu33_D, "B_BFu33_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_F  {
  bool v1;
  __tsu64 v2:33;
  float v3;
};
//SIG(1 B_BFu33_F) C1{ Fc FL:33 Fi}



static void Test_B_BFu33_F()
{
  {
    init_simple_test("B_BFu33_F");
    static B_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu33_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_F)");
    check_field_offset(lv, v1, 0, "B_BFu33_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_F");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_F");
    check_field_offset(lv, v3, 8, "B_BFu33_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu33_F(Test_B_BFu33_F, "B_BFu33_F", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_I  {
  bool v1;
  __tsu64 v2:33;
  int v3;
};
//SIG(1 B_BFu33_I) C1{ Fc FL:33 Fi}



static void Test_B_BFu33_I()
{
  {
    init_simple_test("B_BFu33_I");
    static B_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu33_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_I)");
    check_field_offset(lv, v1, 0, "B_BFu33_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_I");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_I");
    check_field_offset(lv, v3, 8, "B_BFu33_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu33_I(Test_B_BFu33_I, "B_BFu33_I", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_Ip  {
  bool v1;
  __tsu64 v2:33;
  int *v3;
};
//SIG(1 B_BFu33_Ip) C1{ Fc FL:33 Fp}



static void Test_B_BFu33_Ip()
{
  {
    init_simple_test("B_BFu33_Ip");
    static B_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu33_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_Ip");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_Ip");
    check_field_offset(lv, v3, 8, "B_BFu33_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu33_Ip(Test_B_BFu33_Ip, "B_BFu33_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_L  {
  bool v1;
  __tsu64 v2:33;
  __tsi64 v3;
};
//SIG(1 B_BFu33_L) C1{ Fc FL:33 FL}



static void Test_B_BFu33_L()
{
  {
    init_simple_test("B_BFu33_L");
    static B_BFu33_L lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu33_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_L)");
    check_field_offset(lv, v1, 0, "B_BFu33_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_L");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_L");
    check_field_offset(lv, v3, 8, "B_BFu33_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu33_L(Test_B_BFu33_L, "B_BFu33_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_S  {
  bool v1;
  __tsu64 v2:33;
  short v3;
};
//SIG(1 B_BFu33_S) C1{ Fc FL:33 Fs}



static void Test_B_BFu33_S()
{
  {
    init_simple_test("B_BFu33_S");
    static B_BFu33_S lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_S)");
    check_field_offset(lv, v1, 0, "B_BFu33_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_S");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_S");
    check_field_offset(lv, v3, 6, "B_BFu33_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu33_S(Test_B_BFu33_S, "B_BFu33_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_Uc  {
  bool v1;
  __tsu64 v2:33;
  unsigned char v3;
};
//SIG(1 B_BFu33_Uc) C1{ Fc FL:33 Fc}



static void Test_B_BFu33_Uc()
{
  {
    init_simple_test("B_BFu33_Uc");
    static B_BFu33_Uc lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_Uc");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_Uc");
    check_field_offset(lv, v3, 6, "B_BFu33_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu33_Uc(Test_B_BFu33_Uc, "B_BFu33_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_Ui  {
  bool v1;
  __tsu64 v2:33;
  unsigned int v3;
};
//SIG(1 B_BFu33_Ui) C1{ Fc FL:33 Fi}



static void Test_B_BFu33_Ui()
{
  {
    init_simple_test("B_BFu33_Ui");
    static B_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu33_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_Ui");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_Ui");
    check_field_offset(lv, v3, 8, "B_BFu33_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu33_Ui(Test_B_BFu33_Ui, "B_BFu33_Ui", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_Ul  {
  bool v1;
  __tsu64 v2:33;
  __tsu64 v3;
};
//SIG(1 B_BFu33_Ul) C1{ Fc FL:33 FL}



static void Test_B_BFu33_Ul()
{
  {
    init_simple_test("B_BFu33_Ul");
    static B_BFu33_Ul lv;
    check2(sizeof(lv), 16, "sizeof(B_BFu33_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_Ul");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_Ul");
    check_field_offset(lv, v3, 8, "B_BFu33_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu33_Ul(Test_B_BFu33_Ul, "B_BFu33_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_Us  {
  bool v1;
  __tsu64 v2:33;
  unsigned short v3;
};
//SIG(1 B_BFu33_Us) C1{ Fc FL:33 Fs}



static void Test_B_BFu33_Us()
{
  {
    init_simple_test("B_BFu33_Us");
    static B_BFu33_Us lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu33_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_Us)");
    check_field_offset(lv, v1, 0, "B_BFu33_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_Us");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_Us");
    check_field_offset(lv, v3, 6, "B_BFu33_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu33_Us(Test_B_BFu33_Us, "B_BFu33_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu33_Vp  {
  bool v1;
  __tsu64 v2:33;
  void *v3;
};
//SIG(1 B_BFu33_Vp) C1{ Fc FL:33 Fp}



static void Test_B_BFu33_Vp()
{
  {
    init_simple_test("B_BFu33_Vp");
    static B_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu33_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "B_BFu33_Vp");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "B_BFu33_Vp");
    check_field_offset(lv, v3, 8, "B_BFu33_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu33_Vp(Test_B_BFu33_Vp, "B_BFu33_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c  {
  bool v1;
  unsigned char v2:7;
};
//SIG(1 B_BFu7c) C1{ Fc Fc:7}



static void Test_B_BFu7c()
{
  {
    init_simple_test("B_BFu7c");
    static B_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu7c(Test_B_BFu7c, "B_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_B  {
  bool v1;
  unsigned char v2:7;
  bool v3;
};
//SIG(1 B_BFu7c_B) C1{ Fc Fc:7 Fc}



static void Test_B_BFu7c_B()
{
  {
    init_simple_test("B_BFu7c_B");
    static B_BFu7c_B lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu7c_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu7c_B)");
    check_field_offset(lv, v1, 0, "B_BFu7c_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_B");
    check_field_offset(lv, v3, 2, "B_BFu7c_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7c_B(Test_B_BFu7c_B, "B_BFu7c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu15i  {
  bool v1;
  unsigned char v2:7;
  unsigned int v3:15;
};
//SIG(1 B_BFu7c_BFu15i) C1{ Fc Fc:7 Fi:15}



static void Test_B_BFu7c_BFu15i()
{
  {
    init_simple_test("B_BFu7c_BFu15i");
    static B_BFu7c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "B_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "B_BFu7c_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu15i(Test_B_BFu7c_BFu15i, "B_BFu7c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu15ll  {
  bool v1;
  unsigned char v2:7;
  __tsu64 v3:15;
};
//SIG(1 B_BFu7c_BFu15ll) C1{ Fc Fc:7 FL:15}



static void Test_B_BFu7c_BFu15ll()
{
  {
    init_simple_test("B_BFu7c_BFu15ll");
    static B_BFu7c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "B_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "B_BFu7c_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu15ll(Test_B_BFu7c_BFu15ll, "B_BFu7c_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu15s  {
  bool v1;
  unsigned char v2:7;
  unsigned short v3:15;
};
//SIG(1 B_BFu7c_BFu15s) C1{ Fc Fc:7 Fs:15}



static void Test_B_BFu7c_BFu15s()
{
  {
    init_simple_test("B_BFu7c_BFu15s");
    static B_BFu7c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu7c_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu15s(Test_B_BFu7c_BFu15s, "B_BFu7c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu16i  {
  bool v1;
  unsigned char v2:7;
  unsigned int v3:16;
};
//SIG(1 B_BFu7c_BFu16i) C1{ Fc Fc:7 Fi:16}



static void Test_B_BFu7c_BFu16i()
{
  {
    init_simple_test("B_BFu7c_BFu16i");
    static B_BFu7c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "B_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "B_BFu7c_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu16i(Test_B_BFu7c_BFu16i, "B_BFu7c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu16ll  {
  bool v1;
  unsigned char v2:7;
  __tsu64 v3:16;
};
//SIG(1 B_BFu7c_BFu16ll) C1{ Fc Fc:7 FL:16}



static void Test_B_BFu7c_BFu16ll()
{
  {
    init_simple_test("B_BFu7c_BFu16ll");
    static B_BFu7c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "B_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "B_BFu7c_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu16ll(Test_B_BFu7c_BFu16ll, "B_BFu7c_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu16s  {
  bool v1;
  unsigned char v2:7;
  unsigned short v3:16;
};
//SIG(1 B_BFu7c_BFu16s) C1{ Fc Fc:7 Fs:16}



static void Test_B_BFu7c_BFu16s()
{
  {
    init_simple_test("B_BFu7c_BFu16s");
    static B_BFu7c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu7c_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu16s(Test_B_BFu7c_BFu16s, "B_BFu7c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu17i  {
  bool v1;
  unsigned char v2:7;
  unsigned int v3:17;
};
//SIG(1 B_BFu7c_BFu17i) C1{ Fc Fc:7 Fi:17}



static void Test_B_BFu7c_BFu17i()
{
  {
    init_simple_test("B_BFu7c_BFu17i");
    static B_BFu7c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "B_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "B_BFu7c_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu17i(Test_B_BFu7c_BFu17i, "B_BFu7c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu17ll  {
  bool v1;
  unsigned char v2:7;
  __tsu64 v3:17;
};
//SIG(1 B_BFu7c_BFu17ll) C1{ Fc Fc:7 FL:17}



static void Test_B_BFu7c_BFu17ll()
{
  {
    init_simple_test("B_BFu7c_BFu17ll");
    static B_BFu7c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "B_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "B_BFu7c_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu17ll(Test_B_BFu7c_BFu17ll, "B_BFu7c_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu1c  {
  bool v1;
  unsigned char v2:7;
  unsigned char v3:1;
};
//SIG(1 B_BFu7c_BFu1c) C1{ Fc Fc:7 Fc:1}



static void Test_B_BFu7c_BFu1c()
{
  {
    init_simple_test("B_BFu7c_BFu1c");
    static B_BFu7c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7c_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu1c(Test_B_BFu7c_BFu1c, "B_BFu7c_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu1i  {
  bool v1;
  unsigned char v2:7;
  unsigned int v3:1;
};
//SIG(1 B_BFu7c_BFu1i) C1{ Fc Fc:7 Fi:1}



static void Test_B_BFu7c_BFu1i()
{
  {
    init_simple_test("B_BFu7c_BFu1i");
    static B_BFu7c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7c_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu1i(Test_B_BFu7c_BFu1i, "B_BFu7c_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu1ll  {
  bool v1;
  unsigned char v2:7;
  __tsu64 v3:1;
};
//SIG(1 B_BFu7c_BFu1ll) C1{ Fc Fc:7 FL:1}



static void Test_B_BFu7c_BFu1ll()
{
  {
    init_simple_test("B_BFu7c_BFu1ll");
    static B_BFu7c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7c_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu1ll(Test_B_BFu7c_BFu1ll, "B_BFu7c_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu1s  {
  bool v1;
  unsigned char v2:7;
  unsigned short v3:1;
};
//SIG(1 B_BFu7c_BFu1s) C1{ Fc Fc:7 Fs:1}



static void Test_B_BFu7c_BFu1s()
{
  {
    init_simple_test("B_BFu7c_BFu1s");
    static B_BFu7c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu7c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7c_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu1s(Test_B_BFu7c_BFu1s, "B_BFu7c_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu31i  {
  bool v1;
  unsigned char v2:7;
  unsigned int v3:31;
};
//SIG(1 B_BFu7c_BFu31i) C1{ Fc Fc:7 Fi:31}



static void Test_B_BFu7c_BFu31i()
{
  {
    init_simple_test("B_BFu7c_BFu31i");
    static B_BFu7c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu7c_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu31i(Test_B_BFu7c_BFu31i, "B_BFu7c_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu31ll  {
  bool v1;
  unsigned char v2:7;
  __tsu64 v3:31;
};
//SIG(1 B_BFu7c_BFu31ll) C1{ Fc Fc:7 FL:31}



static void Test_B_BFu7c_BFu31ll()
{
  {
    init_simple_test("B_BFu7c_BFu31ll");
    static B_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "B_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "B_BFu7c_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu31ll(Test_B_BFu7c_BFu31ll, "B_BFu7c_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu32i  {
  bool v1;
  unsigned char v2:7;
  unsigned int v3:32;
};
//SIG(1 B_BFu7c_BFu32i) C1{ Fc Fc:7 Fi:32}



static void Test_B_BFu7c_BFu32i()
{
  {
    init_simple_test("B_BFu7c_BFu32i");
    static B_BFu7c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu7c_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu32i(Test_B_BFu7c_BFu32i, "B_BFu7c_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu32ll  {
  bool v1;
  unsigned char v2:7;
  __tsu64 v3:32;
};
//SIG(1 B_BFu7c_BFu32ll) C1{ Fc Fc:7 FL:32}



static void Test_B_BFu7c_BFu32ll()
{
  {
    init_simple_test("B_BFu7c_BFu32ll");
    static B_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "B_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "B_BFu7c_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu32ll(Test_B_BFu7c_BFu32ll, "B_BFu7c_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu33  {
  bool v1;
  unsigned char v2:7;
  __tsu64 v3:33;
};
//SIG(1 B_BFu7c_BFu33) C1{ Fc Fc:7 FL:33}



static void Test_B_BFu7c_BFu33()
{
  {
    init_simple_test("B_BFu7c_BFu33");
    static B_BFu7c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "B_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "B_BFu7c_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu33(Test_B_BFu7c_BFu33, "B_BFu7c_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu7c  {
  bool v1;
  unsigned char v2:7;
  unsigned char v3:7;
};
//SIG(1 B_BFu7c_BFu7c) C1{ Fc Fc:7 Fc:7}



static void Test_B_BFu7c_BFu7c()
{
  {
    init_simple_test("B_BFu7c_BFu7c");
    static B_BFu7c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu7c(Test_B_BFu7c_BFu7c, "B_BFu7c_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu7i  {
  bool v1;
  unsigned char v2:7;
  unsigned int v3:7;
};
//SIG(1 B_BFu7c_BFu7i) C1{ Fc Fc:7 Fi:7}



static void Test_B_BFu7c_BFu7i()
{
  {
    init_simple_test("B_BFu7c_BFu7i");
    static B_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "B_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "B_BFu7c_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu7i(Test_B_BFu7c_BFu7i, "B_BFu7c_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu7ll  {
  bool v1;
  unsigned char v2:7;
  __tsu64 v3:7;
};
//SIG(1 B_BFu7c_BFu7ll) C1{ Fc Fc:7 FL:7}



static void Test_B_BFu7c_BFu7ll()
{
  {
    init_simple_test("B_BFu7c_BFu7ll");
    static B_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "B_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "B_BFu7c_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu7ll(Test_B_BFu7c_BFu7ll, "B_BFu7c_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu7s  {
  bool v1;
  unsigned char v2:7;
  unsigned short v3:7;
};
//SIG(1 B_BFu7c_BFu7s) C1{ Fc Fc:7 Fs:7}



static void Test_B_BFu7c_BFu7s()
{
  {
    init_simple_test("B_BFu7c_BFu7s");
    static B_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu7s(Test_B_BFu7c_BFu7s, "B_BFu7c_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu8c  {
  bool v1;
  unsigned char v2:7;
  unsigned char v3:8;
};
//SIG(1 B_BFu7c_BFu8c) C1{ Fc Fc:7 Fc:8}



static void Test_B_BFu7c_BFu8c()
{
  {
    init_simple_test("B_BFu7c_BFu8c");
    static B_BFu7c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu7c_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu8c(Test_B_BFu7c_BFu8c, "B_BFu7c_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu8i  {
  bool v1;
  unsigned char v2:7;
  unsigned int v3:8;
};
//SIG(1 B_BFu7c_BFu8i) C1{ Fc Fc:7 Fi:8}



static void Test_B_BFu7c_BFu8i()
{
  {
    init_simple_test("B_BFu7c_BFu8i");
    static B_BFu7c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "B_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "B_BFu7c_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu8i(Test_B_BFu7c_BFu8i, "B_BFu7c_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu8ll  {
  bool v1;
  unsigned char v2:7;
  __tsu64 v3:8;
};
//SIG(1 B_BFu7c_BFu8ll) C1{ Fc Fc:7 FL:8}



static void Test_B_BFu7c_BFu8ll()
{
  {
    init_simple_test("B_BFu7c_BFu8ll");
    static B_BFu7c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "B_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "B_BFu7c_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu8ll(Test_B_BFu7c_BFu8ll, "B_BFu7c_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu8s  {
  bool v1;
  unsigned char v2:7;
  unsigned short v3:8;
};
//SIG(1 B_BFu7c_BFu8s) C1{ Fc Fc:7 Fs:8}



static void Test_B_BFu7c_BFu8s()
{
  {
    init_simple_test("B_BFu7c_BFu8s");
    static B_BFu7c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu7c_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu8s(Test_B_BFu7c_BFu8s, "B_BFu7c_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu9i  {
  bool v1;
  unsigned char v2:7;
  unsigned int v3:9;
};
//SIG(1 B_BFu7c_BFu9i) C1{ Fc Fc:7 Fi:9}



static void Test_B_BFu7c_BFu9i()
{
  {
    init_simple_test("B_BFu7c_BFu9i");
    static B_BFu7c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "B_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "B_BFu7c_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu9i(Test_B_BFu7c_BFu9i, "B_BFu7c_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu9ll  {
  bool v1;
  unsigned char v2:7;
  __tsu64 v3:9;
};
//SIG(1 B_BFu7c_BFu9ll) C1{ Fc Fc:7 FL:9}



static void Test_B_BFu7c_BFu9ll()
{
  {
    init_simple_test("B_BFu7c_BFu9ll");
    static B_BFu7c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "B_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "B_BFu7c_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu9ll(Test_B_BFu7c_BFu9ll, "B_BFu7c_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_BFu9s  {
  bool v1;
  unsigned char v2:7;
  unsigned short v3:9;
};
//SIG(1 B_BFu7c_BFu9s) C1{ Fc Fc:7 Fs:9}



static void Test_B_BFu7c_BFu9s()
{
  {
    init_simple_test("B_BFu7c_BFu9s");
    static B_BFu7c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu7c_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu7c_BFu9s(Test_B_BFu7c_BFu9s, "B_BFu7c_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_C  {
  bool v1;
  unsigned char v2:7;
  char v3;
};
//SIG(1 B_BFu7c_C) C1{ Fc Fc:7 Fc}



static void Test_B_BFu7c_C()
{
  {
    init_simple_test("B_BFu7c_C");
    static B_BFu7c_C lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu7c_C)");
    check_field_offset(lv, v1, 0, "B_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_C");
    check_field_offset(lv, v3, 2, "B_BFu7c_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7c_C(Test_B_BFu7c_C, "B_BFu7c_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_D  {
  bool v1;
  unsigned char v2:7;
  double v3;
};
//SIG(1 B_BFu7c_D) C1{ Fc Fc:7 FL}



static void Test_B_BFu7c_D()
{
  {
    init_simple_test("B_BFu7c_D");
    static B_BFu7c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu7c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_D)");
    check_field_offset(lv, v1, 0, "B_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7c_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7c_D(Test_B_BFu7c_D, "B_BFu7c_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_F  {
  bool v1;
  unsigned char v2:7;
  float v3;
};
//SIG(1 B_BFu7c_F) C1{ Fc Fc:7 Fi}



static void Test_B_BFu7c_F()
{
  {
    init_simple_test("B_BFu7c_F");
    static B_BFu7c_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7c_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7c_F)");
    check_field_offset(lv, v1, 0, "B_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_F");
    check_field_offset(lv, v3, 4, "B_BFu7c_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7c_F(Test_B_BFu7c_F, "B_BFu7c_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_I  {
  bool v1;
  unsigned char v2:7;
  int v3;
};
//SIG(1 B_BFu7c_I) C1{ Fc Fc:7 Fi}



static void Test_B_BFu7c_I()
{
  {
    init_simple_test("B_BFu7c_I");
    static B_BFu7c_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7c_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7c_I)");
    check_field_offset(lv, v1, 0, "B_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_I");
    check_field_offset(lv, v3, 4, "B_BFu7c_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7c_I(Test_B_BFu7c_I, "B_BFu7c_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_Ip  {
  bool v1;
  unsigned char v2:7;
  int *v3;
};
//SIG(1 B_BFu7c_Ip) C1{ Fc Fc:7 Fp}



static void Test_B_BFu7c_Ip()
{
  {
    init_simple_test("B_BFu7c_Ip");
    static B_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu7c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7c_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7c_Ip(Test_B_BFu7c_Ip, "B_BFu7c_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_L  {
  bool v1;
  unsigned char v2:7;
  __tsi64 v3;
};
//SIG(1 B_BFu7c_L) C1{ Fc Fc:7 FL}



static void Test_B_BFu7c_L()
{
  {
    init_simple_test("B_BFu7c_L");
    static B_BFu7c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu7c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_L)");
    check_field_offset(lv, v1, 0, "B_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7c_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7c_L(Test_B_BFu7c_L, "B_BFu7c_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_S  {
  bool v1;
  unsigned char v2:7;
  short v3;
};
//SIG(1 B_BFu7c_S) C1{ Fc Fc:7 Fs}



static void Test_B_BFu7c_S()
{
  {
    init_simple_test("B_BFu7c_S");
    static B_BFu7c_S lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7c_S)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7c_S)");
    check_field_offset(lv, v1, 0, "B_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_S");
    check_field_offset(lv, v3, 2, "B_BFu7c_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7c_S(Test_B_BFu7c_S, "B_BFu7c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_Uc  {
  bool v1;
  unsigned char v2:7;
  unsigned char v3;
};
//SIG(1 B_BFu7c_Uc) C1{ Fc Fc:7 Fc}



static void Test_B_BFu7c_Uc()
{
  {
    init_simple_test("B_BFu7c_Uc");
    static B_BFu7c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_Uc");
    check_field_offset(lv, v3, 2, "B_BFu7c_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7c_Uc(Test_B_BFu7c_Uc, "B_BFu7c_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_Ui  {
  bool v1;
  unsigned char v2:7;
  unsigned int v3;
};
//SIG(1 B_BFu7c_Ui) C1{ Fc Fc:7 Fi}



static void Test_B_BFu7c_Ui()
{
  {
    init_simple_test("B_BFu7c_Ui");
    static B_BFu7c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_Ui");
    check_field_offset(lv, v3, 4, "B_BFu7c_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7c_Ui(Test_B_BFu7c_Ui, "B_BFu7c_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_Ul  {
  bool v1;
  unsigned char v2:7;
  __tsu64 v3;
};
//SIG(1 B_BFu7c_Ul) C1{ Fc Fc:7 FL}



static void Test_B_BFu7c_Ul()
{
  {
    init_simple_test("B_BFu7c_Ul");
    static B_BFu7c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu7c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7c_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7c_Ul(Test_B_BFu7c_Ul, "B_BFu7c_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_Us  {
  bool v1;
  unsigned char v2:7;
  unsigned short v3;
};
//SIG(1 B_BFu7c_Us) C1{ Fc Fc:7 Fs}



static void Test_B_BFu7c_Us()
{
  {
    init_simple_test("B_BFu7c_Us");
    static B_BFu7c_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "B_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_Us");
    check_field_offset(lv, v3, 2, "B_BFu7c_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7c_Us(Test_B_BFu7c_Us, "B_BFu7c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7c_Vp  {
  bool v1;
  unsigned char v2:7;
  void *v3;
};
//SIG(1 B_BFu7c_Vp) C1{ Fc Fc:7 Fp}



static void Test_B_BFu7c_Vp()
{
  {
    init_simple_test("B_BFu7c_Vp");
    static B_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu7c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7c_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7c_Vp(Test_B_BFu7c_Vp, "B_BFu7c_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i  {
  bool v1;
  unsigned int v2:7;
};
//SIG(1 B_BFu7i) C1{ Fc Fi:7}



static void Test_B_BFu7i()
{
  {
    init_simple_test("B_BFu7i");
    static B_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu7i(Test_B_BFu7i, "B_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_B  {
  bool v1;
  unsigned int v2:7;
  bool v3;
};
//SIG(1 B_BFu7i_B) C1{ Fc Fi:7 Fc}



static void Test_B_BFu7i_B()
{
  {
    init_simple_test("B_BFu7i_B");
    static B_BFu7i_B lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_B)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_B)");
    check_field_offset(lv, v1, 0, "B_BFu7i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_B");
    check_field_offset(lv, v3, 2, "B_BFu7i_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7i_B(Test_B_BFu7i_B, "B_BFu7i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu15i  {
  bool v1;
  unsigned int v2:7;
  unsigned int v3:15;
};
//SIG(1 B_BFu7i_BFu15i) C1{ Fc Fi:7 Fi:15}



static void Test_B_BFu7i_BFu15i()
{
  {
    init_simple_test("B_BFu7i_BFu15i");
    static B_BFu7i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "B_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "B_BFu7i_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu15i(Test_B_BFu7i_BFu15i, "B_BFu7i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu15ll  {
  bool v1;
  unsigned int v2:7;
  __tsu64 v3:15;
};
//SIG(1 B_BFu7i_BFu15ll) C1{ Fc Fi:7 FL:15}



static void Test_B_BFu7i_BFu15ll()
{
  {
    init_simple_test("B_BFu7i_BFu15ll");
    static B_BFu7i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "B_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "B_BFu7i_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu15ll(Test_B_BFu7i_BFu15ll, "B_BFu7i_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu15s  {
  bool v1;
  unsigned int v2:7;
  unsigned short v3:15;
};
//SIG(1 B_BFu7i_BFu15s) C1{ Fc Fi:7 Fs:15}



static void Test_B_BFu7i_BFu15s()
{
  {
    init_simple_test("B_BFu7i_BFu15s");
    static B_BFu7i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu7i_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu15s(Test_B_BFu7i_BFu15s, "B_BFu7i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu16i  {
  bool v1;
  unsigned int v2:7;
  unsigned int v3:16;
};
//SIG(1 B_BFu7i_BFu16i) C1{ Fc Fi:7 Fi:16}



static void Test_B_BFu7i_BFu16i()
{
  {
    init_simple_test("B_BFu7i_BFu16i");
    static B_BFu7i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "B_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "B_BFu7i_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu16i(Test_B_BFu7i_BFu16i, "B_BFu7i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu16ll  {
  bool v1;
  unsigned int v2:7;
  __tsu64 v3:16;
};
//SIG(1 B_BFu7i_BFu16ll) C1{ Fc Fi:7 FL:16}



static void Test_B_BFu7i_BFu16ll()
{
  {
    init_simple_test("B_BFu7i_BFu16ll");
    static B_BFu7i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "B_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "B_BFu7i_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu16ll(Test_B_BFu7i_BFu16ll, "B_BFu7i_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu16s  {
  bool v1;
  unsigned int v2:7;
  unsigned short v3:16;
};
//SIG(1 B_BFu7i_BFu16s) C1{ Fc Fi:7 Fs:16}



static void Test_B_BFu7i_BFu16s()
{
  {
    init_simple_test("B_BFu7i_BFu16s");
    static B_BFu7i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu7i_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu16s(Test_B_BFu7i_BFu16s, "B_BFu7i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu17i  {
  bool v1;
  unsigned int v2:7;
  unsigned int v3:17;
};
//SIG(1 B_BFu7i_BFu17i) C1{ Fc Fi:7 Fi:17}



static void Test_B_BFu7i_BFu17i()
{
  {
    init_simple_test("B_BFu7i_BFu17i");
    static B_BFu7i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "B_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "B_BFu7i_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu17i(Test_B_BFu7i_BFu17i, "B_BFu7i_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu17ll  {
  bool v1;
  unsigned int v2:7;
  __tsu64 v3:17;
};
//SIG(1 B_BFu7i_BFu17ll) C1{ Fc Fi:7 FL:17}



static void Test_B_BFu7i_BFu17ll()
{
  {
    init_simple_test("B_BFu7i_BFu17ll");
    static B_BFu7i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "B_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "B_BFu7i_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu17ll(Test_B_BFu7i_BFu17ll, "B_BFu7i_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu1c  {
  bool v1;
  unsigned int v2:7;
  unsigned char v3:1;
};
//SIG(1 B_BFu7i_BFu1c) C1{ Fc Fi:7 Fc:1}



static void Test_B_BFu7i_BFu1c()
{
  {
    init_simple_test("B_BFu7i_BFu1c");
    static B_BFu7i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7i_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu1c(Test_B_BFu7i_BFu1c, "B_BFu7i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu1i  {
  bool v1;
  unsigned int v2:7;
  unsigned int v3:1;
};
//SIG(1 B_BFu7i_BFu1i) C1{ Fc Fi:7 Fi:1}



static void Test_B_BFu7i_BFu1i()
{
  {
    init_simple_test("B_BFu7i_BFu1i");
    static B_BFu7i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7i_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu1i(Test_B_BFu7i_BFu1i, "B_BFu7i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu1ll  {
  bool v1;
  unsigned int v2:7;
  __tsu64 v3:1;
};
//SIG(1 B_BFu7i_BFu1ll) C1{ Fc Fi:7 FL:1}



static void Test_B_BFu7i_BFu1ll()
{
  {
    init_simple_test("B_BFu7i_BFu1ll");
    static B_BFu7i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7i_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu1ll(Test_B_BFu7i_BFu1ll, "B_BFu7i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu1s  {
  bool v1;
  unsigned int v2:7;
  unsigned short v3:1;
};
//SIG(1 B_BFu7i_BFu1s) C1{ Fc Fi:7 Fs:1}



static void Test_B_BFu7i_BFu1s()
{
  {
    init_simple_test("B_BFu7i_BFu1s");
    static B_BFu7i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7i_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu1s(Test_B_BFu7i_BFu1s, "B_BFu7i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu31i  {
  bool v1;
  unsigned int v2:7;
  unsigned int v3:31;
};
//SIG(1 B_BFu7i_BFu31i) C1{ Fc Fi:7 Fi:31}



static void Test_B_BFu7i_BFu31i()
{
  {
    init_simple_test("B_BFu7i_BFu31i");
    static B_BFu7i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu7i_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu31i(Test_B_BFu7i_BFu31i, "B_BFu7i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu31ll  {
  bool v1;
  unsigned int v2:7;
  __tsu64 v3:31;
};
//SIG(1 B_BFu7i_BFu31ll) C1{ Fc Fi:7 FL:31}



static void Test_B_BFu7i_BFu31ll()
{
  {
    init_simple_test("B_BFu7i_BFu31ll");
    static B_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "B_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "B_BFu7i_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu31ll(Test_B_BFu7i_BFu31ll, "B_BFu7i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu32i  {
  bool v1;
  unsigned int v2:7;
  unsigned int v3:32;
};
//SIG(1 B_BFu7i_BFu32i) C1{ Fc Fi:7 Fi:32}



static void Test_B_BFu7i_BFu32i()
{
  {
    init_simple_test("B_BFu7i_BFu32i");
    static B_BFu7i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu7i_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu32i(Test_B_BFu7i_BFu32i, "B_BFu7i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu32ll  {
  bool v1;
  unsigned int v2:7;
  __tsu64 v3:32;
};
//SIG(1 B_BFu7i_BFu32ll) C1{ Fc Fi:7 FL:32}



static void Test_B_BFu7i_BFu32ll()
{
  {
    init_simple_test("B_BFu7i_BFu32ll");
    static B_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "B_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "B_BFu7i_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu32ll(Test_B_BFu7i_BFu32ll, "B_BFu7i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu33  {
  bool v1;
  unsigned int v2:7;
  __tsu64 v3:33;
};
//SIG(1 B_BFu7i_BFu33) C1{ Fc Fi:7 FL:33}



static void Test_B_BFu7i_BFu33()
{
  {
    init_simple_test("B_BFu7i_BFu33");
    static B_BFu7i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "B_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "B_BFu7i_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu33(Test_B_BFu7i_BFu33, "B_BFu7i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu7c  {
  bool v1;
  unsigned int v2:7;
  unsigned char v3:7;
};
//SIG(1 B_BFu7i_BFu7c) C1{ Fc Fi:7 Fc:7}



static void Test_B_BFu7i_BFu7c()
{
  {
    init_simple_test("B_BFu7i_BFu7c");
    static B_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu7c(Test_B_BFu7i_BFu7c, "B_BFu7i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu7i  {
  bool v1;
  unsigned int v2:7;
  unsigned int v3:7;
};
//SIG(1 B_BFu7i_BFu7i) C1{ Fc Fi:7 Fi:7}



static void Test_B_BFu7i_BFu7i()
{
  {
    init_simple_test("B_BFu7i_BFu7i");
    static B_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "B_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "B_BFu7i_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu7i(Test_B_BFu7i_BFu7i, "B_BFu7i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu7ll  {
  bool v1;
  unsigned int v2:7;
  __tsu64 v3:7;
};
//SIG(1 B_BFu7i_BFu7ll) C1{ Fc Fi:7 FL:7}



static void Test_B_BFu7i_BFu7ll()
{
  {
    init_simple_test("B_BFu7i_BFu7ll");
    static B_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "B_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "B_BFu7i_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu7ll(Test_B_BFu7i_BFu7ll, "B_BFu7i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu7s  {
  bool v1;
  unsigned int v2:7;
  unsigned short v3:7;
};
//SIG(1 B_BFu7i_BFu7s) C1{ Fc Fi:7 Fs:7}



static void Test_B_BFu7i_BFu7s()
{
  {
    init_simple_test("B_BFu7i_BFu7s");
    static B_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu7s(Test_B_BFu7i_BFu7s, "B_BFu7i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu8c  {
  bool v1;
  unsigned int v2:7;
  unsigned char v3:8;
};
//SIG(1 B_BFu7i_BFu8c) C1{ Fc Fi:7 Fc:8}



static void Test_B_BFu7i_BFu8c()
{
  {
    init_simple_test("B_BFu7i_BFu8c");
    static B_BFu7i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu7i_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu8c(Test_B_BFu7i_BFu8c, "B_BFu7i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu8i  {
  bool v1;
  unsigned int v2:7;
  unsigned int v3:8;
};
//SIG(1 B_BFu7i_BFu8i) C1{ Fc Fi:7 Fi:8}



static void Test_B_BFu7i_BFu8i()
{
  {
    init_simple_test("B_BFu7i_BFu8i");
    static B_BFu7i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "B_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "B_BFu7i_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu8i(Test_B_BFu7i_BFu8i, "B_BFu7i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu8ll  {
  bool v1;
  unsigned int v2:7;
  __tsu64 v3:8;
};
//SIG(1 B_BFu7i_BFu8ll) C1{ Fc Fi:7 FL:8}



static void Test_B_BFu7i_BFu8ll()
{
  {
    init_simple_test("B_BFu7i_BFu8ll");
    static B_BFu7i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "B_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "B_BFu7i_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu8ll(Test_B_BFu7i_BFu8ll, "B_BFu7i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu8s  {
  bool v1;
  unsigned int v2:7;
  unsigned short v3:8;
};
//SIG(1 B_BFu7i_BFu8s) C1{ Fc Fi:7 Fs:8}



static void Test_B_BFu7i_BFu8s()
{
  {
    init_simple_test("B_BFu7i_BFu8s");
    static B_BFu7i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu7i_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu8s(Test_B_BFu7i_BFu8s, "B_BFu7i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu9i  {
  bool v1;
  unsigned int v2:7;
  unsigned int v3:9;
};
//SIG(1 B_BFu7i_BFu9i) C1{ Fc Fi:7 Fi:9}



static void Test_B_BFu7i_BFu9i()
{
  {
    init_simple_test("B_BFu7i_BFu9i");
    static B_BFu7i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "B_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "B_BFu7i_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu9i(Test_B_BFu7i_BFu9i, "B_BFu7i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu9ll  {
  bool v1;
  unsigned int v2:7;
  __tsu64 v3:9;
};
//SIG(1 B_BFu7i_BFu9ll) C1{ Fc Fi:7 FL:9}



static void Test_B_BFu7i_BFu9ll()
{
  {
    init_simple_test("B_BFu7i_BFu9ll");
    static B_BFu7i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "B_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "B_BFu7i_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu9ll(Test_B_BFu7i_BFu9ll, "B_BFu7i_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_BFu9s  {
  bool v1;
  unsigned int v2:7;
  unsigned short v3:9;
};
//SIG(1 B_BFu7i_BFu9s) C1{ Fc Fi:7 Fs:9}



static void Test_B_BFu7i_BFu9s()
{
  {
    init_simple_test("B_BFu7i_BFu9s");
    static B_BFu7i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu7i_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu7i_BFu9s(Test_B_BFu7i_BFu9s, "B_BFu7i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_C  {
  bool v1;
  unsigned int v2:7;
  char v3;
};
//SIG(1 B_BFu7i_C) C1{ Fc Fi:7 Fc}



static void Test_B_BFu7i_C()
{
  {
    init_simple_test("B_BFu7i_C");
    static B_BFu7i_C lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_C)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_C)");
    check_field_offset(lv, v1, 0, "B_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_C");
    check_field_offset(lv, v3, 2, "B_BFu7i_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7i_C(Test_B_BFu7i_C, "B_BFu7i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_D  {
  bool v1;
  unsigned int v2:7;
  double v3;
};
//SIG(1 B_BFu7i_D) C1{ Fc Fi:7 FL}



static void Test_B_BFu7i_D()
{
  {
    init_simple_test("B_BFu7i_D");
    static B_BFu7i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu7i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_D)");
    check_field_offset(lv, v1, 0, "B_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7i_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7i_D(Test_B_BFu7i_D, "B_BFu7i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_F  {
  bool v1;
  unsigned int v2:7;
  float v3;
};
//SIG(1 B_BFu7i_F) C1{ Fc Fi:7 Fi}



static void Test_B_BFu7i_F()
{
  {
    init_simple_test("B_BFu7i_F");
    static B_BFu7i_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7i_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_F)");
    check_field_offset(lv, v1, 0, "B_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_F");
    check_field_offset(lv, v3, 4, "B_BFu7i_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7i_F(Test_B_BFu7i_F, "B_BFu7i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_I  {
  bool v1;
  unsigned int v2:7;
  int v3;
};
//SIG(1 B_BFu7i_I) C1{ Fc Fi:7 Fi}



static void Test_B_BFu7i_I()
{
  {
    init_simple_test("B_BFu7i_I");
    static B_BFu7i_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7i_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_I)");
    check_field_offset(lv, v1, 0, "B_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_I");
    check_field_offset(lv, v3, 4, "B_BFu7i_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7i_I(Test_B_BFu7i_I, "B_BFu7i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_Ip  {
  bool v1;
  unsigned int v2:7;
  int *v3;
};
//SIG(1 B_BFu7i_Ip) C1{ Fc Fi:7 Fp}



static void Test_B_BFu7i_Ip()
{
  {
    init_simple_test("B_BFu7i_Ip");
    static B_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu7i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7i_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7i_Ip(Test_B_BFu7i_Ip, "B_BFu7i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_L  {
  bool v1;
  unsigned int v2:7;
  __tsi64 v3;
};
//SIG(1 B_BFu7i_L) C1{ Fc Fi:7 FL}



static void Test_B_BFu7i_L()
{
  {
    init_simple_test("B_BFu7i_L");
    static B_BFu7i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu7i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_L)");
    check_field_offset(lv, v1, 0, "B_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7i_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7i_L(Test_B_BFu7i_L, "B_BFu7i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_S  {
  bool v1;
  unsigned int v2:7;
  short v3;
};
//SIG(1 B_BFu7i_S) C1{ Fc Fi:7 Fs}



static void Test_B_BFu7i_S()
{
  {
    init_simple_test("B_BFu7i_S");
    static B_BFu7i_S lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_S)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_S)");
    check_field_offset(lv, v1, 0, "B_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_S");
    check_field_offset(lv, v3, 2, "B_BFu7i_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7i_S(Test_B_BFu7i_S, "B_BFu7i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_Uc  {
  bool v1;
  unsigned int v2:7;
  unsigned char v3;
};
//SIG(1 B_BFu7i_Uc) C1{ Fc Fi:7 Fc}



static void Test_B_BFu7i_Uc()
{
  {
    init_simple_test("B_BFu7i_Uc");
    static B_BFu7i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_Uc");
    check_field_offset(lv, v3, 2, "B_BFu7i_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7i_Uc(Test_B_BFu7i_Uc, "B_BFu7i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_Ui  {
  bool v1;
  unsigned int v2:7;
  unsigned int v3;
};
//SIG(1 B_BFu7i_Ui) C1{ Fc Fi:7 Fi}



static void Test_B_BFu7i_Ui()
{
  {
    init_simple_test("B_BFu7i_Ui");
    static B_BFu7i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_Ui");
    check_field_offset(lv, v3, 4, "B_BFu7i_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7i_Ui(Test_B_BFu7i_Ui, "B_BFu7i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_Ul  {
  bool v1;
  unsigned int v2:7;
  __tsu64 v3;
};
//SIG(1 B_BFu7i_Ul) C1{ Fc Fi:7 FL}



static void Test_B_BFu7i_Ul()
{
  {
    init_simple_test("B_BFu7i_Ul");
    static B_BFu7i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu7i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7i_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7i_Ul(Test_B_BFu7i_Ul, "B_BFu7i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_Us  {
  bool v1;
  unsigned int v2:7;
  unsigned short v3;
};
//SIG(1 B_BFu7i_Us) C1{ Fc Fi:7 Fs}



static void Test_B_BFu7i_Us()
{
  {
    init_simple_test("B_BFu7i_Us");
    static B_BFu7i_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "B_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_Us");
    check_field_offset(lv, v3, 2, "B_BFu7i_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7i_Us(Test_B_BFu7i_Us, "B_BFu7i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7i_Vp  {
  bool v1;
  unsigned int v2:7;
  void *v3;
};
//SIG(1 B_BFu7i_Vp) C1{ Fc Fi:7 Fp}



static void Test_B_BFu7i_Vp()
{
  {
    init_simple_test("B_BFu7i_Vp");
    static B_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu7i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7i_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7i_Vp(Test_B_BFu7i_Vp, "B_BFu7i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll  {
  bool v1;
  __tsu64 v2:7;
};
//SIG(1 B_BFu7ll) C1{ Fc FL:7}



static void Test_B_BFu7ll()
{
  {
    init_simple_test("B_BFu7ll");
    static B_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu7ll(Test_B_BFu7ll, "B_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_B  {
  bool v1;
  __tsu64 v2:7;
  bool v3;
};
//SIG(1 B_BFu7ll_B) C1{ Fc FL:7 Fc}



static void Test_B_BFu7ll_B()
{
  {
    init_simple_test("B_BFu7ll_B");
    static B_BFu7ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_B)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_B");
    check_field_offset(lv, v3, 2, "B_BFu7ll_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_B(Test_B_BFu7ll_B, "B_BFu7ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu15i  {
  bool v1;
  __tsu64 v2:7;
  unsigned int v3:15;
};
//SIG(1 B_BFu7ll_BFu15i) C1{ Fc FL:7 Fi:15}



static void Test_B_BFu7ll_BFu15i()
{
  {
    init_simple_test("B_BFu7ll_BFu15i");
    static B_BFu7ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "B_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "B_BFu7ll_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu15i(Test_B_BFu7ll_BFu15i, "B_BFu7ll_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu15ll  {
  bool v1;
  __tsu64 v2:7;
  __tsu64 v3:15;
};
//SIG(1 B_BFu7ll_BFu15ll) C1{ Fc FL:7 FL:15}



static void Test_B_BFu7ll_BFu15ll()
{
  {
    init_simple_test("B_BFu7ll_BFu15ll");
    static B_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "B_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "B_BFu7ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu15ll(Test_B_BFu7ll_BFu15ll, "B_BFu7ll_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu15s  {
  bool v1;
  __tsu64 v2:7;
  unsigned short v3:15;
};
//SIG(1 B_BFu7ll_BFu15s) C1{ Fc FL:7 Fs:15}



static void Test_B_BFu7ll_BFu15s()
{
  {
    init_simple_test("B_BFu7ll_BFu15s");
    static B_BFu7ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu7ll_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu15s(Test_B_BFu7ll_BFu15s, "B_BFu7ll_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu16i  {
  bool v1;
  __tsu64 v2:7;
  unsigned int v3:16;
};
//SIG(1 B_BFu7ll_BFu16i) C1{ Fc FL:7 Fi:16}



static void Test_B_BFu7ll_BFu16i()
{
  {
    init_simple_test("B_BFu7ll_BFu16i");
    static B_BFu7ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "B_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "B_BFu7ll_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu16i(Test_B_BFu7ll_BFu16i, "B_BFu7ll_BFu16i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu16ll  {
  bool v1;
  __tsu64 v2:7;
  __tsu64 v3:16;
};
//SIG(1 B_BFu7ll_BFu16ll) C1{ Fc FL:7 FL:16}



static void Test_B_BFu7ll_BFu16ll()
{
  {
    init_simple_test("B_BFu7ll_BFu16ll");
    static B_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "B_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "B_BFu7ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu16ll(Test_B_BFu7ll_BFu16ll, "B_BFu7ll_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu16s  {
  bool v1;
  __tsu64 v2:7;
  unsigned short v3:16;
};
//SIG(1 B_BFu7ll_BFu16s) C1{ Fc FL:7 Fs:16}



static void Test_B_BFu7ll_BFu16s()
{
  {
    init_simple_test("B_BFu7ll_BFu16s");
    static B_BFu7ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu7ll_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu16s(Test_B_BFu7ll_BFu16s, "B_BFu7ll_BFu16s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu17i  {
  bool v1;
  __tsu64 v2:7;
  unsigned int v3:17;
};
//SIG(1 B_BFu7ll_BFu17i) C1{ Fc FL:7 Fi:17}



static void Test_B_BFu7ll_BFu17i()
{
  {
    init_simple_test("B_BFu7ll_BFu17i");
    static B_BFu7ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "B_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "B_BFu7ll_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu17i(Test_B_BFu7ll_BFu17i, "B_BFu7ll_BFu17i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu17ll  {
  bool v1;
  __tsu64 v2:7;
  __tsu64 v3:17;
};
//SIG(1 B_BFu7ll_BFu17ll) C1{ Fc FL:7 FL:17}



static void Test_B_BFu7ll_BFu17ll()
{
  {
    init_simple_test("B_BFu7ll_BFu17ll");
    static B_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "B_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "B_BFu7ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu17ll(Test_B_BFu7ll_BFu17ll, "B_BFu7ll_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu1c  {
  bool v1;
  __tsu64 v2:7;
  unsigned char v3:1;
};
//SIG(1 B_BFu7ll_BFu1c) C1{ Fc FL:7 Fc:1}



static void Test_B_BFu7ll_BFu1c()
{
  {
    init_simple_test("B_BFu7ll_BFu1c");
    static B_BFu7ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7ll_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu1c(Test_B_BFu7ll_BFu1c, "B_BFu7ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu1i  {
  bool v1;
  __tsu64 v2:7;
  unsigned int v3:1;
};
//SIG(1 B_BFu7ll_BFu1i) C1{ Fc FL:7 Fi:1}



static void Test_B_BFu7ll_BFu1i()
{
  {
    init_simple_test("B_BFu7ll_BFu1i");
    static B_BFu7ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7ll_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu1i(Test_B_BFu7ll_BFu1i, "B_BFu7ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu1ll  {
  bool v1;
  __tsu64 v2:7;
  __tsu64 v3:1;
};
//SIG(1 B_BFu7ll_BFu1ll) C1{ Fc FL:7 FL:1}



static void Test_B_BFu7ll_BFu1ll()
{
  {
    init_simple_test("B_BFu7ll_BFu1ll");
    static B_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu1ll(Test_B_BFu7ll_BFu1ll, "B_BFu7ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu1s  {
  bool v1;
  __tsu64 v2:7;
  unsigned short v3:1;
};
//SIG(1 B_BFu7ll_BFu1s) C1{ Fc FL:7 Fs:1}



static void Test_B_BFu7ll_BFu1s()
{
  {
    init_simple_test("B_BFu7ll_BFu1s");
    static B_BFu7ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7ll_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu1s(Test_B_BFu7ll_BFu1s, "B_BFu7ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu31i  {
  bool v1;
  __tsu64 v2:7;
  unsigned int v3:31;
};
//SIG(1 B_BFu7ll_BFu31i) C1{ Fc FL:7 Fi:31}



static void Test_B_BFu7ll_BFu31i()
{
  {
    init_simple_test("B_BFu7ll_BFu31i");
    static B_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu7ll_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu31i(Test_B_BFu7ll_BFu31i, "B_BFu7ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu31ll  {
  bool v1;
  __tsu64 v2:7;
  __tsu64 v3:31;
};
//SIG(1 B_BFu7ll_BFu31ll) C1{ Fc FL:7 FL:31}



static void Test_B_BFu7ll_BFu31ll()
{
  {
    init_simple_test("B_BFu7ll_BFu31ll");
    static B_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "B_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "B_BFu7ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu31ll(Test_B_BFu7ll_BFu31ll, "B_BFu7ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu32i  {
  bool v1;
  __tsu64 v2:7;
  unsigned int v3:32;
};
//SIG(1 B_BFu7ll_BFu32i) C1{ Fc FL:7 Fi:32}



static void Test_B_BFu7ll_BFu32i()
{
  {
    init_simple_test("B_BFu7ll_BFu32i");
    static B_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu7ll_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu32i(Test_B_BFu7ll_BFu32i, "B_BFu7ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu32ll  {
  bool v1;
  __tsu64 v2:7;
  __tsu64 v3:32;
};
//SIG(1 B_BFu7ll_BFu32ll) C1{ Fc FL:7 FL:32}



static void Test_B_BFu7ll_BFu32ll()
{
  {
    init_simple_test("B_BFu7ll_BFu32ll");
    static B_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "B_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "B_BFu7ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu32ll(Test_B_BFu7ll_BFu32ll, "B_BFu7ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu33  {
  bool v1;
  __tsu64 v2:7;
  __tsu64 v3:33;
};
//SIG(1 B_BFu7ll_BFu33) C1{ Fc FL:7 FL:33}



static void Test_B_BFu7ll_BFu33()
{
  {
    init_simple_test("B_BFu7ll_BFu33");
    static B_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "B_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "B_BFu7ll_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu33(Test_B_BFu7ll_BFu33, "B_BFu7ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu7c  {
  bool v1;
  __tsu64 v2:7;
  unsigned char v3:7;
};
//SIG(1 B_BFu7ll_BFu7c) C1{ Fc FL:7 Fc:7}



static void Test_B_BFu7ll_BFu7c()
{
  {
    init_simple_test("B_BFu7ll_BFu7c");
    static B_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu7c(Test_B_BFu7ll_BFu7c, "B_BFu7ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu7i  {
  bool v1;
  __tsu64 v2:7;
  unsigned int v3:7;
};
//SIG(1 B_BFu7ll_BFu7i) C1{ Fc FL:7 Fi:7}



static void Test_B_BFu7ll_BFu7i()
{
  {
    init_simple_test("B_BFu7ll_BFu7i");
    static B_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "B_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu7i(Test_B_BFu7ll_BFu7i, "B_BFu7ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu7ll  {
  bool v1;
  __tsu64 v2:7;
  __tsu64 v3:7;
};
//SIG(1 B_BFu7ll_BFu7ll) C1{ Fc FL:7 FL:7}



static void Test_B_BFu7ll_BFu7ll()
{
  {
    init_simple_test("B_BFu7ll_BFu7ll");
    static B_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "B_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu7ll(Test_B_BFu7ll_BFu7ll, "B_BFu7ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu7s  {
  bool v1;
  __tsu64 v2:7;
  unsigned short v3:7;
};
//SIG(1 B_BFu7ll_BFu7s) C1{ Fc FL:7 Fs:7}



static void Test_B_BFu7ll_BFu7s()
{
  {
    init_simple_test("B_BFu7ll_BFu7s");
    static B_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu7s(Test_B_BFu7ll_BFu7s, "B_BFu7ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu8c  {
  bool v1;
  __tsu64 v2:7;
  unsigned char v3:8;
};
//SIG(1 B_BFu7ll_BFu8c) C1{ Fc FL:7 Fc:8}



static void Test_B_BFu7ll_BFu8c()
{
  {
    init_simple_test("B_BFu7ll_BFu8c");
    static B_BFu7ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu7ll_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu8c(Test_B_BFu7ll_BFu8c, "B_BFu7ll_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu8i  {
  bool v1;
  __tsu64 v2:7;
  unsigned int v3:8;
};
//SIG(1 B_BFu7ll_BFu8i) C1{ Fc FL:7 Fi:8}



static void Test_B_BFu7ll_BFu8i()
{
  {
    init_simple_test("B_BFu7ll_BFu8i");
    static B_BFu7ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "B_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "B_BFu7ll_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu8i(Test_B_BFu7ll_BFu8i, "B_BFu7ll_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu8ll  {
  bool v1;
  __tsu64 v2:7;
  __tsu64 v3:8;
};
//SIG(1 B_BFu7ll_BFu8ll) C1{ Fc FL:7 FL:8}



static void Test_B_BFu7ll_BFu8ll()
{
  {
    init_simple_test("B_BFu7ll_BFu8ll");
    static B_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "B_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "B_BFu7ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu8ll(Test_B_BFu7ll_BFu8ll, "B_BFu7ll_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu8s  {
  bool v1;
  __tsu64 v2:7;
  unsigned short v3:8;
};
//SIG(1 B_BFu7ll_BFu8s) C1{ Fc FL:7 Fs:8}



static void Test_B_BFu7ll_BFu8s()
{
  {
    init_simple_test("B_BFu7ll_BFu8s");
    static B_BFu7ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu7ll_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu8s(Test_B_BFu7ll_BFu8s, "B_BFu7ll_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu9i  {
  bool v1;
  __tsu64 v2:7;
  unsigned int v3:9;
};
//SIG(1 B_BFu7ll_BFu9i) C1{ Fc FL:7 Fi:9}



static void Test_B_BFu7ll_BFu9i()
{
  {
    init_simple_test("B_BFu7ll_BFu9i");
    static B_BFu7ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "B_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "B_BFu7ll_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu9i(Test_B_BFu7ll_BFu9i, "B_BFu7ll_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu9ll  {
  bool v1;
  __tsu64 v2:7;
  __tsu64 v3:9;
};
//SIG(1 B_BFu7ll_BFu9ll) C1{ Fc FL:7 FL:9}



static void Test_B_BFu7ll_BFu9ll()
{
  {
    init_simple_test("B_BFu7ll_BFu9ll");
    static B_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "B_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "B_BFu7ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu9ll(Test_B_BFu7ll_BFu9ll, "B_BFu7ll_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_BFu9s  {
  bool v1;
  __tsu64 v2:7;
  unsigned short v3:9;
};
//SIG(1 B_BFu7ll_BFu9s) C1{ Fc FL:7 Fs:9}



static void Test_B_BFu7ll_BFu9s()
{
  {
    init_simple_test("B_BFu7ll_BFu9s");
    static B_BFu7ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu7ll_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_BFu9s(Test_B_BFu7ll_BFu9s, "B_BFu7ll_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_C  {
  bool v1;
  __tsu64 v2:7;
  char v3;
};
//SIG(1 B_BFu7ll_C) C1{ Fc FL:7 Fc}



static void Test_B_BFu7ll_C()
{
  {
    init_simple_test("B_BFu7ll_C");
    static B_BFu7ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_C");
    check_field_offset(lv, v3, 2, "B_BFu7ll_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_C(Test_B_BFu7ll_C, "B_BFu7ll_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_D  {
  bool v1;
  __tsu64 v2:7;
  double v3;
};
//SIG(1 B_BFu7ll_D) C1{ Fc FL:7 FL}



static void Test_B_BFu7ll_D()
{
  {
    init_simple_test("B_BFu7ll_D");
    static B_BFu7ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu7ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7ll_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_D(Test_B_BFu7ll_D, "B_BFu7ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_F  {
  bool v1;
  __tsu64 v2:7;
  float v3;
};
//SIG(1 B_BFu7ll_F) C1{ Fc FL:7 Fi}



static void Test_B_BFu7ll_F()
{
  {
    init_simple_test("B_BFu7ll_F");
    static B_BFu7ll_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_F");
    check_field_offset(lv, v3, 4, "B_BFu7ll_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_F(Test_B_BFu7ll_F, "B_BFu7ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_I  {
  bool v1;
  __tsu64 v2:7;
  int v3;
};
//SIG(1 B_BFu7ll_I) C1{ Fc FL:7 Fi}



static void Test_B_BFu7ll_I()
{
  {
    init_simple_test("B_BFu7ll_I");
    static B_BFu7ll_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_I");
    check_field_offset(lv, v3, 4, "B_BFu7ll_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_I(Test_B_BFu7ll_I, "B_BFu7ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_Ip  {
  bool v1;
  __tsu64 v2:7;
  int *v3;
};
//SIG(1 B_BFu7ll_Ip) C1{ Fc FL:7 Fp}



static void Test_B_BFu7ll_Ip()
{
  {
    init_simple_test("B_BFu7ll_Ip");
    static B_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu7ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_Ip(Test_B_BFu7ll_Ip, "B_BFu7ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_L  {
  bool v1;
  __tsu64 v2:7;
  __tsi64 v3;
};
//SIG(1 B_BFu7ll_L) C1{ Fc FL:7 FL}



static void Test_B_BFu7ll_L()
{
  {
    init_simple_test("B_BFu7ll_L");
    static B_BFu7ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu7ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7ll_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_L(Test_B_BFu7ll_L, "B_BFu7ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_S  {
  bool v1;
  __tsu64 v2:7;
  short v3;
};
//SIG(1 B_BFu7ll_S) C1{ Fc FL:7 Fs}



static void Test_B_BFu7ll_S()
{
  {
    init_simple_test("B_BFu7ll_S");
    static B_BFu7ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_S");
    check_field_offset(lv, v3, 2, "B_BFu7ll_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_S(Test_B_BFu7ll_S, "B_BFu7ll_S", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_Uc  {
  bool v1;
  __tsu64 v2:7;
  unsigned char v3;
};
//SIG(1 B_BFu7ll_Uc) C1{ Fc FL:7 Fc}



static void Test_B_BFu7ll_Uc()
{
  {
    init_simple_test("B_BFu7ll_Uc");
    static B_BFu7ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_Uc");
    check_field_offset(lv, v3, 2, "B_BFu7ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_Uc(Test_B_BFu7ll_Uc, "B_BFu7ll_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_Ui  {
  bool v1;
  __tsu64 v2:7;
  unsigned int v3;
};
//SIG(1 B_BFu7ll_Ui) C1{ Fc FL:7 Fi}



static void Test_B_BFu7ll_Ui()
{
  {
    init_simple_test("B_BFu7ll_Ui");
    static B_BFu7ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_Ui");
    check_field_offset(lv, v3, 4, "B_BFu7ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_Ui(Test_B_BFu7ll_Ui, "B_BFu7ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_Ul  {
  bool v1;
  __tsu64 v2:7;
  __tsu64 v3;
};
//SIG(1 B_BFu7ll_Ul) C1{ Fc FL:7 FL}



static void Test_B_BFu7ll_Ul()
{
  {
    init_simple_test("B_BFu7ll_Ul");
    static B_BFu7ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu7ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_Ul(Test_B_BFu7ll_Ul, "B_BFu7ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_Us  {
  bool v1;
  __tsu64 v2:7;
  unsigned short v3;
};
//SIG(1 B_BFu7ll_Us) C1{ Fc FL:7 Fs}



static void Test_B_BFu7ll_Us()
{
  {
    init_simple_test("B_BFu7ll_Us");
    static B_BFu7ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_Us");
    check_field_offset(lv, v3, 2, "B_BFu7ll_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_Us(Test_B_BFu7ll_Us, "B_BFu7ll_Us", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7ll_Vp  {
  bool v1;
  __tsu64 v2:7;
  void *v3;
};
//SIG(1 B_BFu7ll_Vp) C1{ Fc FL:7 Fp}



static void Test_B_BFu7ll_Vp()
{
  {
    init_simple_test("B_BFu7ll_Vp");
    static B_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu7ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7ll_Vp(Test_B_BFu7ll_Vp, "B_BFu7ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s  {
  bool v1;
  unsigned short v2:7;
};
//SIG(1 B_BFu7s) C1{ Fc Fs:7}



static void Test_B_BFu7s()
{
  {
    init_simple_test("B_BFu7s");
    static B_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu7s(Test_B_BFu7s, "B_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_B  {
  bool v1;
  unsigned short v2:7;
  bool v3;
};
//SIG(1 B_BFu7s_B) C1{ Fc Fs:7 Fc}



static void Test_B_BFu7s_B()
{
  {
    init_simple_test("B_BFu7s_B");
    static B_BFu7s_B lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_B)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s_B)");
    check_field_offset(lv, v1, 0, "B_BFu7s_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_B");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_B");
    check_field_offset(lv, v3, 2, "B_BFu7s_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7s_B(Test_B_BFu7s_B, "B_BFu7s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu15i  {
  bool v1;
  unsigned short v2:7;
  unsigned int v3:15;
};
//SIG(1 B_BFu7s_BFu15i) C1{ Fc Fs:7 Fi:15}



static void Test_B_BFu7s_BFu15i()
{
  {
    init_simple_test("B_BFu7s_BFu15i");
    static B_BFu7s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "B_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "B_BFu7s_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu15i(Test_B_BFu7s_BFu15i, "B_BFu7s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu15ll  {
  bool v1;
  unsigned short v2:7;
  __tsu64 v3:15;
};
//SIG(1 B_BFu7s_BFu15ll) C1{ Fc Fs:7 FL:15}



static void Test_B_BFu7s_BFu15ll()
{
  {
    init_simple_test("B_BFu7s_BFu15ll");
    static B_BFu7s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "B_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "B_BFu7s_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu15ll(Test_B_BFu7s_BFu15ll, "B_BFu7s_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu15s  {
  bool v1;
  unsigned short v2:7;
  unsigned short v3:15;
};
//SIG(1 B_BFu7s_BFu15s) C1{ Fc Fs:7 Fs:15}



static void Test_B_BFu7s_BFu15s()
{
  {
    init_simple_test("B_BFu7s_BFu15s");
    static B_BFu7s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu7s_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu15s(Test_B_BFu7s_BFu15s, "B_BFu7s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu16i  {
  bool v1;
  unsigned short v2:7;
  unsigned int v3:16;
};
//SIG(1 B_BFu7s_BFu16i) C1{ Fc Fs:7 Fi:16}



static void Test_B_BFu7s_BFu16i()
{
  {
    init_simple_test("B_BFu7s_BFu16i");
    static B_BFu7s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "B_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "B_BFu7s_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu16i(Test_B_BFu7s_BFu16i, "B_BFu7s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu16ll  {
  bool v1;
  unsigned short v2:7;
  __tsu64 v3:16;
};
//SIG(1 B_BFu7s_BFu16ll) C1{ Fc Fs:7 FL:16}



static void Test_B_BFu7s_BFu16ll()
{
  {
    init_simple_test("B_BFu7s_BFu16ll");
    static B_BFu7s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "B_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "B_BFu7s_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu16ll(Test_B_BFu7s_BFu16ll, "B_BFu7s_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu16s  {
  bool v1;
  unsigned short v2:7;
  unsigned short v3:16;
};
//SIG(1 B_BFu7s_BFu16s) C1{ Fc Fs:7 Fs:16}



static void Test_B_BFu7s_BFu16s()
{
  {
    init_simple_test("B_BFu7s_BFu16s");
    static B_BFu7s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu7s_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu16s(Test_B_BFu7s_BFu16s, "B_BFu7s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu17i  {
  bool v1;
  unsigned short v2:7;
  unsigned int v3:17;
};
//SIG(1 B_BFu7s_BFu17i) C1{ Fc Fs:7 Fi:17}



static void Test_B_BFu7s_BFu17i()
{
  {
    init_simple_test("B_BFu7s_BFu17i");
    static B_BFu7s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "B_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "B_BFu7s_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu17i(Test_B_BFu7s_BFu17i, "B_BFu7s_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu17ll  {
  bool v1;
  unsigned short v2:7;
  __tsu64 v3:17;
};
//SIG(1 B_BFu7s_BFu17ll) C1{ Fc Fs:7 FL:17}



static void Test_B_BFu7s_BFu17ll()
{
  {
    init_simple_test("B_BFu7s_BFu17ll");
    static B_BFu7s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "B_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "B_BFu7s_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu17ll(Test_B_BFu7s_BFu17ll, "B_BFu7s_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu1c  {
  bool v1;
  unsigned short v2:7;
  unsigned char v3:1;
};
//SIG(1 B_BFu7s_BFu1c) C1{ Fc Fs:7 Fc:1}



static void Test_B_BFu7s_BFu1c()
{
  {
    init_simple_test("B_BFu7s_BFu1c");
    static B_BFu7s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu7s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7s_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu1c(Test_B_BFu7s_BFu1c, "B_BFu7s_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu1i  {
  bool v1;
  unsigned short v2:7;
  unsigned int v3:1;
};
//SIG(1 B_BFu7s_BFu1i) C1{ Fc Fs:7 Fi:1}



static void Test_B_BFu7s_BFu1i()
{
  {
    init_simple_test("B_BFu7s_BFu1i");
    static B_BFu7s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7s_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu1i(Test_B_BFu7s_BFu1i, "B_BFu7s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu1ll  {
  bool v1;
  unsigned short v2:7;
  __tsu64 v3:1;
};
//SIG(1 B_BFu7s_BFu1ll) C1{ Fc Fs:7 FL:1}



static void Test_B_BFu7s_BFu1ll()
{
  {
    init_simple_test("B_BFu7s_BFu1ll");
    static B_BFu7s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7s_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu1ll(Test_B_BFu7s_BFu1ll, "B_BFu7s_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu1s  {
  bool v1;
  unsigned short v2:7;
  unsigned short v3:1;
};
//SIG(1 B_BFu7s_BFu1s) C1{ Fc Fs:7 Fs:1}



static void Test_B_BFu7s_BFu1s()
{
  {
    init_simple_test("B_BFu7s_BFu1s");
    static B_BFu7s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu7s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "B_BFu7s_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu1s(Test_B_BFu7s_BFu1s, "B_BFu7s_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu31i  {
  bool v1;
  unsigned short v2:7;
  unsigned int v3:31;
};
//SIG(1 B_BFu7s_BFu31i) C1{ Fc Fs:7 Fi:31}



static void Test_B_BFu7s_BFu31i()
{
  {
    init_simple_test("B_BFu7s_BFu31i");
    static B_BFu7s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu7s_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu31i(Test_B_BFu7s_BFu31i, "B_BFu7s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu31ll  {
  bool v1;
  unsigned short v2:7;
  __tsu64 v3:31;
};
//SIG(1 B_BFu7s_BFu31ll) C1{ Fc Fs:7 FL:31}



static void Test_B_BFu7s_BFu31ll()
{
  {
    init_simple_test("B_BFu7s_BFu31ll");
    static B_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "B_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "B_BFu7s_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu31ll(Test_B_BFu7s_BFu31ll, "B_BFu7s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu32i  {
  bool v1;
  unsigned short v2:7;
  unsigned int v3:32;
};
//SIG(1 B_BFu7s_BFu32i) C1{ Fc Fs:7 Fi:32}



static void Test_B_BFu7s_BFu32i()
{
  {
    init_simple_test("B_BFu7s_BFu32i");
    static B_BFu7s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu7s_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu32i(Test_B_BFu7s_BFu32i, "B_BFu7s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu32ll  {
  bool v1;
  unsigned short v2:7;
  __tsu64 v3:32;
};
//SIG(1 B_BFu7s_BFu32ll) C1{ Fc Fs:7 FL:32}



static void Test_B_BFu7s_BFu32ll()
{
  {
    init_simple_test("B_BFu7s_BFu32ll");
    static B_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "B_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "B_BFu7s_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu32ll(Test_B_BFu7s_BFu32ll, "B_BFu7s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu33  {
  bool v1;
  unsigned short v2:7;
  __tsu64 v3:33;
};
//SIG(1 B_BFu7s_BFu33) C1{ Fc Fs:7 FL:33}



static void Test_B_BFu7s_BFu33()
{
  {
    init_simple_test("B_BFu7s_BFu33");
    static B_BFu7s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "B_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "B_BFu7s_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu33(Test_B_BFu7s_BFu33, "B_BFu7s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu7c  {
  bool v1;
  unsigned short v2:7;
  unsigned char v3:7;
};
//SIG(1 B_BFu7s_BFu7c) C1{ Fc Fs:7 Fc:7}



static void Test_B_BFu7s_BFu7c()
{
  {
    init_simple_test("B_BFu7s_BFu7c");
    static B_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu7c(Test_B_BFu7s_BFu7c, "B_BFu7s_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu7i  {
  bool v1;
  unsigned short v2:7;
  unsigned int v3:7;
};
//SIG(1 B_BFu7s_BFu7i) C1{ Fc Fs:7 Fi:7}



static void Test_B_BFu7s_BFu7i()
{
  {
    init_simple_test("B_BFu7s_BFu7i");
    static B_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "B_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "B_BFu7s_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu7i(Test_B_BFu7s_BFu7i, "B_BFu7s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu7ll  {
  bool v1;
  unsigned short v2:7;
  __tsu64 v3:7;
};
//SIG(1 B_BFu7s_BFu7ll) C1{ Fc Fs:7 FL:7}



static void Test_B_BFu7s_BFu7ll()
{
  {
    init_simple_test("B_BFu7s_BFu7ll");
    static B_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "B_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "B_BFu7s_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu7ll(Test_B_BFu7s_BFu7ll, "B_BFu7s_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu7s  {
  bool v1;
  unsigned short v2:7;
  unsigned short v3:7;
};
//SIG(1 B_BFu7s_BFu7s) C1{ Fc Fs:7 Fs:7}



static void Test_B_BFu7s_BFu7s()
{
  {
    init_simple_test("B_BFu7s_BFu7s");
    static B_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu7s(Test_B_BFu7s_BFu7s, "B_BFu7s_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu8c  {
  bool v1;
  unsigned short v2:7;
  unsigned char v3:8;
};
//SIG(1 B_BFu7s_BFu8c) C1{ Fc Fs:7 Fc:8}



static void Test_B_BFu7s_BFu8c()
{
  {
    init_simple_test("B_BFu7s_BFu8c");
    static B_BFu7s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu7s_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu8c(Test_B_BFu7s_BFu8c, "B_BFu7s_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu8i  {
  bool v1;
  unsigned short v2:7;
  unsigned int v3:8;
};
//SIG(1 B_BFu7s_BFu8i) C1{ Fc Fs:7 Fi:8}



static void Test_B_BFu7s_BFu8i()
{
  {
    init_simple_test("B_BFu7s_BFu8i");
    static B_BFu7s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "B_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "B_BFu7s_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu8i(Test_B_BFu7s_BFu8i, "B_BFu7s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu8ll  {
  bool v1;
  unsigned short v2:7;
  __tsu64 v3:8;
};
//SIG(1 B_BFu7s_BFu8ll) C1{ Fc Fs:7 FL:8}



static void Test_B_BFu7s_BFu8ll()
{
  {
    init_simple_test("B_BFu7s_BFu8ll");
    static B_BFu7s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "B_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "B_BFu7s_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu8ll(Test_B_BFu7s_BFu8ll, "B_BFu7s_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu8s  {
  bool v1;
  unsigned short v2:7;
  unsigned short v3:8;
};
//SIG(1 B_BFu7s_BFu8s) C1{ Fc Fs:7 Fs:8}



static void Test_B_BFu7s_BFu8s()
{
  {
    init_simple_test("B_BFu7s_BFu8s");
    static B_BFu7s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu7s_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu8s(Test_B_BFu7s_BFu8s, "B_BFu7s_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu9i  {
  bool v1;
  unsigned short v2:7;
  unsigned int v3:9;
};
//SIG(1 B_BFu7s_BFu9i) C1{ Fc Fs:7 Fi:9}



static void Test_B_BFu7s_BFu9i()
{
  {
    init_simple_test("B_BFu7s_BFu9i");
    static B_BFu7s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "B_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "B_BFu7s_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu9i(Test_B_BFu7s_BFu9i, "B_BFu7s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu9ll  {
  bool v1;
  unsigned short v2:7;
  __tsu64 v3:9;
};
//SIG(1 B_BFu7s_BFu9ll) C1{ Fc Fs:7 FL:9}



static void Test_B_BFu7s_BFu9ll()
{
  {
    init_simple_test("B_BFu7s_BFu9ll");
    static B_BFu7s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu7s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "B_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "B_BFu7s_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu9ll(Test_B_BFu7s_BFu9ll, "B_BFu7s_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_BFu9s  {
  bool v1;
  unsigned short v2:7;
  unsigned short v3:9;
};
//SIG(1 B_BFu7s_BFu9s) C1{ Fc Fs:7 Fs:9}



static void Test_B_BFu7s_BFu9s()
{
  {
    init_simple_test("B_BFu7s_BFu9s");
    static B_BFu7s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu7s_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu7s_BFu9s(Test_B_BFu7s_BFu9s, "B_BFu7s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_C  {
  bool v1;
  unsigned short v2:7;
  char v3;
};
//SIG(1 B_BFu7s_C) C1{ Fc Fs:7 Fc}



static void Test_B_BFu7s_C()
{
  {
    init_simple_test("B_BFu7s_C");
    static B_BFu7s_C lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_C)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s_C)");
    check_field_offset(lv, v1, 0, "B_BFu7s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_C");
    check_field_offset(lv, v3, 2, "B_BFu7s_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7s_C(Test_B_BFu7s_C, "B_BFu7s_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_D  {
  bool v1;
  unsigned short v2:7;
  double v3;
};
//SIG(1 B_BFu7s_D) C1{ Fc Fs:7 FL}



static void Test_B_BFu7s_D()
{
  {
    init_simple_test("B_BFu7s_D");
    static B_BFu7s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu7s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_D)");
    check_field_offset(lv, v1, 0, "B_BFu7s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7s_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7s_D(Test_B_BFu7s_D, "B_BFu7s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_F  {
  bool v1;
  unsigned short v2:7;
  float v3;
};
//SIG(1 B_BFu7s_F) C1{ Fc Fs:7 Fi}



static void Test_B_BFu7s_F()
{
  {
    init_simple_test("B_BFu7s_F");
    static B_BFu7s_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7s_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7s_F)");
    check_field_offset(lv, v1, 0, "B_BFu7s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_F");
    check_field_offset(lv, v3, 4, "B_BFu7s_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7s_F(Test_B_BFu7s_F, "B_BFu7s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_I  {
  bool v1;
  unsigned short v2:7;
  int v3;
};
//SIG(1 B_BFu7s_I) C1{ Fc Fs:7 Fi}



static void Test_B_BFu7s_I()
{
  {
    init_simple_test("B_BFu7s_I");
    static B_BFu7s_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7s_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7s_I)");
    check_field_offset(lv, v1, 0, "B_BFu7s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_I");
    check_field_offset(lv, v3, 4, "B_BFu7s_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7s_I(Test_B_BFu7s_I, "B_BFu7s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_Ip  {
  bool v1;
  unsigned short v2:7;
  int *v3;
};
//SIG(1 B_BFu7s_Ip) C1{ Fc Fs:7 Fp}



static void Test_B_BFu7s_Ip()
{
  {
    init_simple_test("B_BFu7s_Ip");
    static B_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu7s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7s_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7s_Ip(Test_B_BFu7s_Ip, "B_BFu7s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_L  {
  bool v1;
  unsigned short v2:7;
  __tsi64 v3;
};
//SIG(1 B_BFu7s_L) C1{ Fc Fs:7 FL}



static void Test_B_BFu7s_L()
{
  {
    init_simple_test("B_BFu7s_L");
    static B_BFu7s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu7s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_L)");
    check_field_offset(lv, v1, 0, "B_BFu7s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7s_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7s_L(Test_B_BFu7s_L, "B_BFu7s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_S  {
  bool v1;
  unsigned short v2:7;
  short v3;
};
//SIG(1 B_BFu7s_S) C1{ Fc Fs:7 Fs}



static void Test_B_BFu7s_S()
{
  {
    init_simple_test("B_BFu7s_S");
    static B_BFu7s_S lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_S)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s_S)");
    check_field_offset(lv, v1, 0, "B_BFu7s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_S");
    check_field_offset(lv, v3, 2, "B_BFu7s_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7s_S(Test_B_BFu7s_S, "B_BFu7s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_Uc  {
  bool v1;
  unsigned short v2:7;
  unsigned char v3;
};
//SIG(1 B_BFu7s_Uc) C1{ Fc Fs:7 Fc}



static void Test_B_BFu7s_Uc()
{
  {
    init_simple_test("B_BFu7s_Uc");
    static B_BFu7s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_Uc");
    check_field_offset(lv, v3, 2, "B_BFu7s_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7s_Uc(Test_B_BFu7s_Uc, "B_BFu7s_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_Ui  {
  bool v1;
  unsigned short v2:7;
  unsigned int v3;
};
//SIG(1 B_BFu7s_Ui) C1{ Fc Fs:7 Fi}



static void Test_B_BFu7s_Ui()
{
  {
    init_simple_test("B_BFu7s_Ui");
    static B_BFu7s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu7s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_Ui");
    check_field_offset(lv, v3, 4, "B_BFu7s_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7s_Ui(Test_B_BFu7s_Ui, "B_BFu7s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_Ul  {
  bool v1;
  unsigned short v2:7;
  __tsu64 v3;
};
//SIG(1 B_BFu7s_Ul) C1{ Fc Fs:7 FL}



static void Test_B_BFu7s_Ul()
{
  {
    init_simple_test("B_BFu7s_Ul");
    static B_BFu7s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu7s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7s_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7s_Ul(Test_B_BFu7s_Ul, "B_BFu7s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_Us  {
  bool v1;
  unsigned short v2:7;
  unsigned short v3;
};
//SIG(1 B_BFu7s_Us) C1{ Fc Fs:7 Fs}



static void Test_B_BFu7s_Us()
{
  {
    init_simple_test("B_BFu7s_Us");
    static B_BFu7s_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu7s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "B_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_Us");
    check_field_offset(lv, v3, 2, "B_BFu7s_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7s_Us(Test_B_BFu7s_Us, "B_BFu7s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu7s_Vp  {
  bool v1;
  unsigned short v2:7;
  void *v3;
};
//SIG(1 B_BFu7s_Vp) C1{ Fc Fs:7 Fp}



static void Test_B_BFu7s_Vp()
{
  {
    init_simple_test("B_BFu7s_Vp");
    static B_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu7s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "B_BFu7s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "B_BFu7s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu7s_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu7s_Vp(Test_B_BFu7s_Vp, "B_BFu7s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c  {
  bool v1;
  unsigned char v2:8;
};
//SIG(1 B_BFu8c) C1{ Fc Fc:8}



static void Test_B_BFu8c()
{
  {
    init_simple_test("B_BFu8c");
    static B_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu8c(Test_B_BFu8c, "B_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_B  {
  bool v1;
  unsigned char v2:8;
  bool v3;
};
//SIG(1 B_BFu8c_B) C1{ Fc Fc:8 Fc}



static void Test_B_BFu8c_B()
{
  {
    init_simple_test("B_BFu8c_B");
    static B_BFu8c_B lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8c_B)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8c_B)");
    check_field_offset(lv, v1, 0, "B_BFu8c_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_B");
    check_field_offset(lv, v3, 2, "B_BFu8c_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8c_B(Test_B_BFu8c_B, "B_BFu8c_B", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu15i  {
  bool v1;
  unsigned char v2:8;
  unsigned int v3:15;
};
//SIG(1 B_BFu8c_BFu15i) C1{ Fc Fc:8 Fi:15}



static void Test_B_BFu8c_BFu15i()
{
  {
    init_simple_test("B_BFu8c_BFu15i");
    static B_BFu8c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8c_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu15i(Test_B_BFu8c_BFu15i, "B_BFu8c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu15ll  {
  bool v1;
  unsigned char v2:8;
  __tsu64 v3:15;
};
//SIG(1 B_BFu8c_BFu15ll) C1{ Fc Fc:8 FL:15}



static void Test_B_BFu8c_BFu15ll()
{
  {
    init_simple_test("B_BFu8c_BFu15ll");
    static B_BFu8c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8c_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu15ll(Test_B_BFu8c_BFu15ll, "B_BFu8c_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu15s  {
  bool v1;
  unsigned char v2:8;
  unsigned short v3:15;
};
//SIG(1 B_BFu8c_BFu15s) C1{ Fc Fc:8 Fs:15}



static void Test_B_BFu8c_BFu15s()
{
  {
    init_simple_test("B_BFu8c_BFu15s");
    static B_BFu8c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8c_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu15s(Test_B_BFu8c_BFu15s, "B_BFu8c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu16i  {
  bool v1;
  unsigned char v2:8;
  unsigned int v3:16;
};
//SIG(1 B_BFu8c_BFu16i) C1{ Fc Fc:8 Fi:16}



static void Test_B_BFu8c_BFu16i()
{
  {
    init_simple_test("B_BFu8c_BFu16i");
    static B_BFu8c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8c_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu16i(Test_B_BFu8c_BFu16i, "B_BFu8c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu16ll  {
  bool v1;
  unsigned char v2:8;
  __tsu64 v3:16;
};
//SIG(1 B_BFu8c_BFu16ll) C1{ Fc Fc:8 FL:16}



static void Test_B_BFu8c_BFu16ll()
{
  {
    init_simple_test("B_BFu8c_BFu16ll");
    static B_BFu8c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8c_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu16ll(Test_B_BFu8c_BFu16ll, "B_BFu8c_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu16s  {
  bool v1;
  unsigned char v2:8;
  unsigned short v3:16;
};
//SIG(1 B_BFu8c_BFu16s) C1{ Fc Fc:8 Fs:16}



static void Test_B_BFu8c_BFu16s()
{
  {
    init_simple_test("B_BFu8c_BFu16s");
    static B_BFu8c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8c_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu16s(Test_B_BFu8c_BFu16s, "B_BFu8c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu17i  {
  bool v1;
  unsigned char v2:8;
  unsigned int v3:17;
};
//SIG(1 B_BFu8c_BFu17i) C1{ Fc Fc:8 Fi:17}



static void Test_B_BFu8c_BFu17i()
{
  {
    init_simple_test("B_BFu8c_BFu17i");
    static B_BFu8c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu8c_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu17i(Test_B_BFu8c_BFu17i, "B_BFu8c_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu17ll  {
  bool v1;
  unsigned char v2:8;
  __tsu64 v3:17;
};
//SIG(1 B_BFu8c_BFu17ll) C1{ Fc Fc:8 FL:17}



static void Test_B_BFu8c_BFu17ll()
{
  {
    init_simple_test("B_BFu8c_BFu17ll");
    static B_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "B_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "B_BFu8c_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu17ll(Test_B_BFu8c_BFu17ll, "B_BFu8c_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu1c  {
  bool v1;
  unsigned char v2:8;
  unsigned char v3:1;
};
//SIG(1 B_BFu8c_BFu1c) C1{ Fc Fc:8 Fc:1}



static void Test_B_BFu8c_BFu1c()
{
  {
    init_simple_test("B_BFu8c_BFu1c");
    static B_BFu8c_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8c_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu1c(Test_B_BFu8c_BFu1c, "B_BFu8c_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu1i  {
  bool v1;
  unsigned char v2:8;
  unsigned int v3:1;
};
//SIG(1 B_BFu8c_BFu1i) C1{ Fc Fc:8 Fi:1}



static void Test_B_BFu8c_BFu1i()
{
  {
    init_simple_test("B_BFu8c_BFu1i");
    static B_BFu8c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8c_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu1i(Test_B_BFu8c_BFu1i, "B_BFu8c_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu1ll  {
  bool v1;
  unsigned char v2:8;
  __tsu64 v3:1;
};
//SIG(1 B_BFu8c_BFu1ll) C1{ Fc Fc:8 FL:1}



static void Test_B_BFu8c_BFu1ll()
{
  {
    init_simple_test("B_BFu8c_BFu1ll");
    static B_BFu8c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8c_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu1ll(Test_B_BFu8c_BFu1ll, "B_BFu8c_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu1s  {
  bool v1;
  unsigned char v2:8;
  unsigned short v3:1;
};
//SIG(1 B_BFu8c_BFu1s) C1{ Fc Fc:8 Fs:1}



static void Test_B_BFu8c_BFu1s()
{
  {
    init_simple_test("B_BFu8c_BFu1s");
    static B_BFu8c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8c_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu1s(Test_B_BFu8c_BFu1s, "B_BFu8c_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu31i  {
  bool v1;
  unsigned char v2:8;
  unsigned int v3:31;
};
//SIG(1 B_BFu8c_BFu31i) C1{ Fc Fc:8 Fi:31}



static void Test_B_BFu8c_BFu31i()
{
  {
    init_simple_test("B_BFu8c_BFu31i");
    static B_BFu8c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu8c_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu31i(Test_B_BFu8c_BFu31i, "B_BFu8c_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu31ll  {
  bool v1;
  unsigned char v2:8;
  __tsu64 v3:31;
};
//SIG(1 B_BFu8c_BFu31ll) C1{ Fc Fc:8 FL:31}



static void Test_B_BFu8c_BFu31ll()
{
  {
    init_simple_test("B_BFu8c_BFu31ll");
    static B_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "B_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "B_BFu8c_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu31ll(Test_B_BFu8c_BFu31ll, "B_BFu8c_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu32i  {
  bool v1;
  unsigned char v2:8;
  unsigned int v3:32;
};
//SIG(1 B_BFu8c_BFu32i) C1{ Fc Fc:8 Fi:32}



static void Test_B_BFu8c_BFu32i()
{
  {
    init_simple_test("B_BFu8c_BFu32i");
    static B_BFu8c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu8c_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu32i(Test_B_BFu8c_BFu32i, "B_BFu8c_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu32ll  {
  bool v1;
  unsigned char v2:8;
  __tsu64 v3:32;
};
//SIG(1 B_BFu8c_BFu32ll) C1{ Fc Fc:8 FL:32}



static void Test_B_BFu8c_BFu32ll()
{
  {
    init_simple_test("B_BFu8c_BFu32ll");
    static B_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "B_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "B_BFu8c_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu32ll(Test_B_BFu8c_BFu32ll, "B_BFu8c_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu33  {
  bool v1;
  unsigned char v2:8;
  __tsu64 v3:33;
};
//SIG(1 B_BFu8c_BFu33) C1{ Fc Fc:8 FL:33}



static void Test_B_BFu8c_BFu33()
{
  {
    init_simple_test("B_BFu8c_BFu33");
    static B_BFu8c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "B_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "B_BFu8c_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu33(Test_B_BFu8c_BFu33, "B_BFu8c_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu7c  {
  bool v1;
  unsigned char v2:8;
  unsigned char v3:7;
};
//SIG(1 B_BFu8c_BFu7c) C1{ Fc Fc:8 Fc:7}



static void Test_B_BFu8c_BFu7c()
{
  {
    init_simple_test("B_BFu8c_BFu7c");
    static B_BFu8c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8c_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu7c(Test_B_BFu8c_BFu7c, "B_BFu8c_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu7i  {
  bool v1;
  unsigned char v2:8;
  unsigned int v3:7;
};
//SIG(1 B_BFu8c_BFu7i) C1{ Fc Fc:8 Fi:7}



static void Test_B_BFu8c_BFu7i()
{
  {
    init_simple_test("B_BFu8c_BFu7i");
    static B_BFu8c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8c_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu7i(Test_B_BFu8c_BFu7i, "B_BFu8c_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu7ll  {
  bool v1;
  unsigned char v2:8;
  __tsu64 v3:7;
};
//SIG(1 B_BFu8c_BFu7ll) C1{ Fc Fc:8 FL:7}



static void Test_B_BFu8c_BFu7ll()
{
  {
    init_simple_test("B_BFu8c_BFu7ll");
    static B_BFu8c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8c_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu7ll(Test_B_BFu8c_BFu7ll, "B_BFu8c_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu7s  {
  bool v1;
  unsigned char v2:8;
  unsigned short v3:7;
};
//SIG(1 B_BFu8c_BFu7s) C1{ Fc Fc:8 Fs:7}



static void Test_B_BFu8c_BFu7s()
{
  {
    init_simple_test("B_BFu8c_BFu7s");
    static B_BFu8c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8c_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu7s(Test_B_BFu8c_BFu7s, "B_BFu8c_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu8c  {
  bool v1;
  unsigned char v2:8;
  unsigned char v3:8;
};
//SIG(1 B_BFu8c_BFu8c) C1{ Fc Fc:8 Fc:8}



static void Test_B_BFu8c_BFu8c()
{
  {
    init_simple_test("B_BFu8c_BFu8c");
    static B_BFu8c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu8c(Test_B_BFu8c_BFu8c, "B_BFu8c_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu8i  {
  bool v1;
  unsigned char v2:8;
  unsigned int v3:8;
};
//SIG(1 B_BFu8c_BFu8i) C1{ Fc Fc:8 Fi:8}



static void Test_B_BFu8c_BFu8i()
{
  {
    init_simple_test("B_BFu8c_BFu8i");
    static B_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu8i(Test_B_BFu8c_BFu8i, "B_BFu8c_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu8ll  {
  bool v1;
  unsigned char v2:8;
  __tsu64 v3:8;
};
//SIG(1 B_BFu8c_BFu8ll) C1{ Fc Fc:8 FL:8}



static void Test_B_BFu8c_BFu8ll()
{
  {
    init_simple_test("B_BFu8c_BFu8ll");
    static B_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu8ll(Test_B_BFu8c_BFu8ll, "B_BFu8c_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu8s  {
  bool v1;
  unsigned char v2:8;
  unsigned short v3:8;
};
//SIG(1 B_BFu8c_BFu8s) C1{ Fc Fc:8 Fs:8}



static void Test_B_BFu8c_BFu8s()
{
  {
    init_simple_test("B_BFu8c_BFu8s");
    static B_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu8s(Test_B_BFu8c_BFu8s, "B_BFu8c_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu9i  {
  bool v1;
  unsigned char v2:8;
  unsigned int v3:9;
};
//SIG(1 B_BFu8c_BFu9i) C1{ Fc Fc:8 Fi:9}



static void Test_B_BFu8c_BFu9i()
{
  {
    init_simple_test("B_BFu8c_BFu9i");
    static B_BFu8c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8c_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu9i(Test_B_BFu8c_BFu9i, "B_BFu8c_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu9ll  {
  bool v1;
  unsigned char v2:8;
  __tsu64 v3:9;
};
//SIG(1 B_BFu8c_BFu9ll) C1{ Fc Fc:8 FL:9}



static void Test_B_BFu8c_BFu9ll()
{
  {
    init_simple_test("B_BFu8c_BFu9ll");
    static B_BFu8c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8c_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu9ll(Test_B_BFu8c_BFu9ll, "B_BFu8c_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_BFu9s  {
  bool v1;
  unsigned char v2:8;
  unsigned short v3:9;
};
//SIG(1 B_BFu8c_BFu9s) C1{ Fc Fc:8 Fs:9}



static void Test_B_BFu8c_BFu9s()
{
  {
    init_simple_test("B_BFu8c_BFu9s");
    static B_BFu8c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8c_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu8c_BFu9s(Test_B_BFu8c_BFu9s, "B_BFu8c_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_C  {
  bool v1;
  unsigned char v2:8;
  char v3;
};
//SIG(1 B_BFu8c_C) C1{ Fc Fc:8 Fc}



static void Test_B_BFu8c_C()
{
  {
    init_simple_test("B_BFu8c_C");
    static B_BFu8c_C lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8c_C)");
    check_field_offset(lv, v1, 0, "B_BFu8c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_C");
    check_field_offset(lv, v3, 2, "B_BFu8c_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8c_C(Test_B_BFu8c_C, "B_BFu8c_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_D  {
  bool v1;
  unsigned char v2:8;
  double v3;
};
//SIG(1 B_BFu8c_D) C1{ Fc Fc:8 FL}



static void Test_B_BFu8c_D()
{
  {
    init_simple_test("B_BFu8c_D");
    static B_BFu8c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu8c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_D)");
    check_field_offset(lv, v1, 0, "B_BFu8c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8c_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8c_D(Test_B_BFu8c_D, "B_BFu8c_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_F  {
  bool v1;
  unsigned char v2:8;
  float v3;
};
//SIG(1 B_BFu8c_F) C1{ Fc Fc:8 Fi}



static void Test_B_BFu8c_F()
{
  {
    init_simple_test("B_BFu8c_F");
    static B_BFu8c_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8c_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8c_F)");
    check_field_offset(lv, v1, 0, "B_BFu8c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_F");
    check_field_offset(lv, v3, 4, "B_BFu8c_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8c_F(Test_B_BFu8c_F, "B_BFu8c_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_I  {
  bool v1;
  unsigned char v2:8;
  int v3;
};
//SIG(1 B_BFu8c_I) C1{ Fc Fc:8 Fi}



static void Test_B_BFu8c_I()
{
  {
    init_simple_test("B_BFu8c_I");
    static B_BFu8c_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8c_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8c_I)");
    check_field_offset(lv, v1, 0, "B_BFu8c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_I");
    check_field_offset(lv, v3, 4, "B_BFu8c_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8c_I(Test_B_BFu8c_I, "B_BFu8c_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_Ip  {
  bool v1;
  unsigned char v2:8;
  int *v3;
};
//SIG(1 B_BFu8c_Ip) C1{ Fc Fc:8 Fp}



static void Test_B_BFu8c_Ip()
{
  {
    init_simple_test("B_BFu8c_Ip");
    static B_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu8c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8c_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8c_Ip(Test_B_BFu8c_Ip, "B_BFu8c_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_L  {
  bool v1;
  unsigned char v2:8;
  __tsi64 v3;
};
//SIG(1 B_BFu8c_L) C1{ Fc Fc:8 FL}



static void Test_B_BFu8c_L()
{
  {
    init_simple_test("B_BFu8c_L");
    static B_BFu8c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu8c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_L)");
    check_field_offset(lv, v1, 0, "B_BFu8c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8c_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8c_L(Test_B_BFu8c_L, "B_BFu8c_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_S  {
  bool v1;
  unsigned char v2:8;
  short v3;
};
//SIG(1 B_BFu8c_S) C1{ Fc Fc:8 Fs}



static void Test_B_BFu8c_S()
{
  {
    init_simple_test("B_BFu8c_S");
    static B_BFu8c_S lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8c_S)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8c_S)");
    check_field_offset(lv, v1, 0, "B_BFu8c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_S");
    check_field_offset(lv, v3, 2, "B_BFu8c_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8c_S(Test_B_BFu8c_S, "B_BFu8c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_Uc  {
  bool v1;
  unsigned char v2:8;
  unsigned char v3;
};
//SIG(1 B_BFu8c_Uc) C1{ Fc Fc:8 Fc}



static void Test_B_BFu8c_Uc()
{
  {
    init_simple_test("B_BFu8c_Uc");
    static B_BFu8c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(B_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(B_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_Uc");
    check_field_offset(lv, v3, 2, "B_BFu8c_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8c_Uc(Test_B_BFu8c_Uc, "B_BFu8c_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_Ui  {
  bool v1;
  unsigned char v2:8;
  unsigned int v3;
};
//SIG(1 B_BFu8c_Ui) C1{ Fc Fc:8 Fi}



static void Test_B_BFu8c_Ui()
{
  {
    init_simple_test("B_BFu8c_Ui");
    static B_BFu8c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_Ui");
    check_field_offset(lv, v3, 4, "B_BFu8c_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8c_Ui(Test_B_BFu8c_Ui, "B_BFu8c_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_Ul  {
  bool v1;
  unsigned char v2:8;
  __tsu64 v3;
};
//SIG(1 B_BFu8c_Ul) C1{ Fc Fc:8 FL}



static void Test_B_BFu8c_Ul()
{
  {
    init_simple_test("B_BFu8c_Ul");
    static B_BFu8c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu8c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8c_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8c_Ul(Test_B_BFu8c_Ul, "B_BFu8c_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_Us  {
  bool v1;
  unsigned char v2:8;
  unsigned short v3;
};
//SIG(1 B_BFu8c_Us) C1{ Fc Fc:8 Fs}



static void Test_B_BFu8c_Us()
{
  {
    init_simple_test("B_BFu8c_Us");
    static B_BFu8c_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "B_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_Us");
    check_field_offset(lv, v3, 2, "B_BFu8c_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8c_Us(Test_B_BFu8c_Us, "B_BFu8c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8c_Vp  {
  bool v1;
  unsigned char v2:8;
  void *v3;
};
//SIG(1 B_BFu8c_Vp) C1{ Fc Fc:8 Fp}



static void Test_B_BFu8c_Vp()
{
  {
    init_simple_test("B_BFu8c_Vp");
    static B_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu8c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8c_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu8c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8c_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8c_Vp(Test_B_BFu8c_Vp, "B_BFu8c_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i  {
  bool v1;
  unsigned int v2:8;
};
//SIG(1 B_BFu8i) C1{ Fc Fi:8}



static void Test_B_BFu8i()
{
  {
    init_simple_test("B_BFu8i");
    static B_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu8i(Test_B_BFu8i, "B_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_B  {
  bool v1;
  unsigned int v2:8;
  bool v3;
};
//SIG(1 B_BFu8i_B) C1{ Fc Fi:8 Fc}



static void Test_B_BFu8i_B()
{
  {
    init_simple_test("B_BFu8i_B");
    static B_BFu8i_B lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_B)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_B)");
    check_field_offset(lv, v1, 0, "B_BFu8i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_B");
    check_field_offset(lv, v3, 2, "B_BFu8i_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_B(Test_B_BFu8i_B, "B_BFu8i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu15i  {
  bool v1;
  unsigned int v2:8;
  unsigned int v3:15;
};
//SIG(1 B_BFu8i_BFu15i) C1{ Fc Fi:8 Fi:15}



static void Test_B_BFu8i_BFu15i()
{
  {
    init_simple_test("B_BFu8i_BFu15i");
    static B_BFu8i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8i_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu15i(Test_B_BFu8i_BFu15i, "B_BFu8i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu15ll  {
  bool v1;
  unsigned int v2:8;
  __tsu64 v3:15;
};
//SIG(1 B_BFu8i_BFu15ll) C1{ Fc Fi:8 FL:15}



static void Test_B_BFu8i_BFu15ll()
{
  {
    init_simple_test("B_BFu8i_BFu15ll");
    static B_BFu8i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8i_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu15ll(Test_B_BFu8i_BFu15ll, "B_BFu8i_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu15s  {
  bool v1;
  unsigned int v2:8;
  unsigned short v3:15;
};
//SIG(1 B_BFu8i_BFu15s) C1{ Fc Fi:8 Fs:15}



static void Test_B_BFu8i_BFu15s()
{
  {
    init_simple_test("B_BFu8i_BFu15s");
    static B_BFu8i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8i_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu15s(Test_B_BFu8i_BFu15s, "B_BFu8i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu16i  {
  bool v1;
  unsigned int v2:8;
  unsigned int v3:16;
};
//SIG(1 B_BFu8i_BFu16i) C1{ Fc Fi:8 Fi:16}



static void Test_B_BFu8i_BFu16i()
{
  {
    init_simple_test("B_BFu8i_BFu16i");
    static B_BFu8i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8i_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu16i(Test_B_BFu8i_BFu16i, "B_BFu8i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu16ll  {
  bool v1;
  unsigned int v2:8;
  __tsu64 v3:16;
};
//SIG(1 B_BFu8i_BFu16ll) C1{ Fc Fi:8 FL:16}



static void Test_B_BFu8i_BFu16ll()
{
  {
    init_simple_test("B_BFu8i_BFu16ll");
    static B_BFu8i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8i_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu16ll(Test_B_BFu8i_BFu16ll, "B_BFu8i_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu16s  {
  bool v1;
  unsigned int v2:8;
  unsigned short v3:16;
};
//SIG(1 B_BFu8i_BFu16s) C1{ Fc Fi:8 Fs:16}



static void Test_B_BFu8i_BFu16s()
{
  {
    init_simple_test("B_BFu8i_BFu16s");
    static B_BFu8i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8i_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu16s(Test_B_BFu8i_BFu16s, "B_BFu8i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu17i  {
  bool v1;
  unsigned int v2:8;
  unsigned int v3:17;
};
//SIG(1 B_BFu8i_BFu17i) C1{ Fc Fi:8 Fi:17}



static void Test_B_BFu8i_BFu17i()
{
  {
    init_simple_test("B_BFu8i_BFu17i");
    static B_BFu8i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu8i_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu17i(Test_B_BFu8i_BFu17i, "B_BFu8i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu17ll  {
  bool v1;
  unsigned int v2:8;
  __tsu64 v3:17;
};
//SIG(1 B_BFu8i_BFu17ll) C1{ Fc Fi:8 FL:17}



static void Test_B_BFu8i_BFu17ll()
{
  {
    init_simple_test("B_BFu8i_BFu17ll");
    static B_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "B_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "B_BFu8i_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu17ll(Test_B_BFu8i_BFu17ll, "B_BFu8i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu1c  {
  bool v1;
  unsigned int v2:8;
  unsigned char v3:1;
};
//SIG(1 B_BFu8i_BFu1c) C1{ Fc Fi:8 Fc:1}



static void Test_B_BFu8i_BFu1c()
{
  {
    init_simple_test("B_BFu8i_BFu1c");
    static B_BFu8i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8i_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu1c(Test_B_BFu8i_BFu1c, "B_BFu8i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu1i  {
  bool v1;
  unsigned int v2:8;
  unsigned int v3:1;
};
//SIG(1 B_BFu8i_BFu1i) C1{ Fc Fi:8 Fi:1}



static void Test_B_BFu8i_BFu1i()
{
  {
    init_simple_test("B_BFu8i_BFu1i");
    static B_BFu8i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8i_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu1i(Test_B_BFu8i_BFu1i, "B_BFu8i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu1ll  {
  bool v1;
  unsigned int v2:8;
  __tsu64 v3:1;
};
//SIG(1 B_BFu8i_BFu1ll) C1{ Fc Fi:8 FL:1}



static void Test_B_BFu8i_BFu1ll()
{
  {
    init_simple_test("B_BFu8i_BFu1ll");
    static B_BFu8i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8i_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu1ll(Test_B_BFu8i_BFu1ll, "B_BFu8i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu1s  {
  bool v1;
  unsigned int v2:8;
  unsigned short v3:1;
};
//SIG(1 B_BFu8i_BFu1s) C1{ Fc Fi:8 Fs:1}



static void Test_B_BFu8i_BFu1s()
{
  {
    init_simple_test("B_BFu8i_BFu1s");
    static B_BFu8i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8i_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu1s(Test_B_BFu8i_BFu1s, "B_BFu8i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu31i  {
  bool v1;
  unsigned int v2:8;
  unsigned int v3:31;
};
//SIG(1 B_BFu8i_BFu31i) C1{ Fc Fi:8 Fi:31}



static void Test_B_BFu8i_BFu31i()
{
  {
    init_simple_test("B_BFu8i_BFu31i");
    static B_BFu8i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu8i_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu31i(Test_B_BFu8i_BFu31i, "B_BFu8i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu31ll  {
  bool v1;
  unsigned int v2:8;
  __tsu64 v3:31;
};
//SIG(1 B_BFu8i_BFu31ll) C1{ Fc Fi:8 FL:31}



static void Test_B_BFu8i_BFu31ll()
{
  {
    init_simple_test("B_BFu8i_BFu31ll");
    static B_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "B_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "B_BFu8i_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu31ll(Test_B_BFu8i_BFu31ll, "B_BFu8i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu32i  {
  bool v1;
  unsigned int v2:8;
  unsigned int v3:32;
};
//SIG(1 B_BFu8i_BFu32i) C1{ Fc Fi:8 Fi:32}



static void Test_B_BFu8i_BFu32i()
{
  {
    init_simple_test("B_BFu8i_BFu32i");
    static B_BFu8i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu8i_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu32i(Test_B_BFu8i_BFu32i, "B_BFu8i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu32ll  {
  bool v1;
  unsigned int v2:8;
  __tsu64 v3:32;
};
//SIG(1 B_BFu8i_BFu32ll) C1{ Fc Fi:8 FL:32}



static void Test_B_BFu8i_BFu32ll()
{
  {
    init_simple_test("B_BFu8i_BFu32ll");
    static B_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "B_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "B_BFu8i_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu32ll(Test_B_BFu8i_BFu32ll, "B_BFu8i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu33  {
  bool v1;
  unsigned int v2:8;
  __tsu64 v3:33;
};
//SIG(1 B_BFu8i_BFu33) C1{ Fc Fi:8 FL:33}



static void Test_B_BFu8i_BFu33()
{
  {
    init_simple_test("B_BFu8i_BFu33");
    static B_BFu8i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "B_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "B_BFu8i_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu33(Test_B_BFu8i_BFu33, "B_BFu8i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu7c  {
  bool v1;
  unsigned int v2:8;
  unsigned char v3:7;
};
//SIG(1 B_BFu8i_BFu7c) C1{ Fc Fi:8 Fc:7}



static void Test_B_BFu8i_BFu7c()
{
  {
    init_simple_test("B_BFu8i_BFu7c");
    static B_BFu8i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8i_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu7c(Test_B_BFu8i_BFu7c, "B_BFu8i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu7i  {
  bool v1;
  unsigned int v2:8;
  unsigned int v3:7;
};
//SIG(1 B_BFu8i_BFu7i) C1{ Fc Fi:8 Fi:7}



static void Test_B_BFu8i_BFu7i()
{
  {
    init_simple_test("B_BFu8i_BFu7i");
    static B_BFu8i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8i_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu7i(Test_B_BFu8i_BFu7i, "B_BFu8i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu7ll  {
  bool v1;
  unsigned int v2:8;
  __tsu64 v3:7;
};
//SIG(1 B_BFu8i_BFu7ll) C1{ Fc Fi:8 FL:7}



static void Test_B_BFu8i_BFu7ll()
{
  {
    init_simple_test("B_BFu8i_BFu7ll");
    static B_BFu8i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8i_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu7ll(Test_B_BFu8i_BFu7ll, "B_BFu8i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu7s  {
  bool v1;
  unsigned int v2:8;
  unsigned short v3:7;
};
//SIG(1 B_BFu8i_BFu7s) C1{ Fc Fi:8 Fs:7}



static void Test_B_BFu8i_BFu7s()
{
  {
    init_simple_test("B_BFu8i_BFu7s");
    static B_BFu8i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8i_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu7s(Test_B_BFu8i_BFu7s, "B_BFu8i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu8c  {
  bool v1;
  unsigned int v2:8;
  unsigned char v3:8;
};
//SIG(1 B_BFu8i_BFu8c) C1{ Fc Fi:8 Fc:8}



static void Test_B_BFu8i_BFu8c()
{
  {
    init_simple_test("B_BFu8i_BFu8c");
    static B_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu8c(Test_B_BFu8i_BFu8c, "B_BFu8i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu8i  {
  bool v1;
  unsigned int v2:8;
  unsigned int v3:8;
};
//SIG(1 B_BFu8i_BFu8i) C1{ Fc Fi:8 Fi:8}



static void Test_B_BFu8i_BFu8i()
{
  {
    init_simple_test("B_BFu8i_BFu8i");
    static B_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu8i(Test_B_BFu8i_BFu8i, "B_BFu8i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu8ll  {
  bool v1;
  unsigned int v2:8;
  __tsu64 v3:8;
};
//SIG(1 B_BFu8i_BFu8ll) C1{ Fc Fi:8 FL:8}



static void Test_B_BFu8i_BFu8ll()
{
  {
    init_simple_test("B_BFu8i_BFu8ll");
    static B_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu8ll(Test_B_BFu8i_BFu8ll, "B_BFu8i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu8s  {
  bool v1;
  unsigned int v2:8;
  unsigned short v3:8;
};
//SIG(1 B_BFu8i_BFu8s) C1{ Fc Fi:8 Fs:8}



static void Test_B_BFu8i_BFu8s()
{
  {
    init_simple_test("B_BFu8i_BFu8s");
    static B_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu8s(Test_B_BFu8i_BFu8s, "B_BFu8i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu9i  {
  bool v1;
  unsigned int v2:8;
  unsigned int v3:9;
};
//SIG(1 B_BFu8i_BFu9i) C1{ Fc Fi:8 Fi:9}



static void Test_B_BFu8i_BFu9i()
{
  {
    init_simple_test("B_BFu8i_BFu9i");
    static B_BFu8i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8i_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu9i(Test_B_BFu8i_BFu9i, "B_BFu8i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu9ll  {
  bool v1;
  unsigned int v2:8;
  __tsu64 v3:9;
};
//SIG(1 B_BFu8i_BFu9ll) C1{ Fc Fi:8 FL:9}



static void Test_B_BFu8i_BFu9ll()
{
  {
    init_simple_test("B_BFu8i_BFu9ll");
    static B_BFu8i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8i_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu9ll(Test_B_BFu8i_BFu9ll, "B_BFu8i_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_BFu9s  {
  bool v1;
  unsigned int v2:8;
  unsigned short v3:9;
};
//SIG(1 B_BFu8i_BFu9s) C1{ Fc Fi:8 Fs:9}



static void Test_B_BFu8i_BFu9s()
{
  {
    init_simple_test("B_BFu8i_BFu9s");
    static B_BFu8i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8i_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu8i_BFu9s(Test_B_BFu8i_BFu9s, "B_BFu8i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_C  {
  bool v1;
  unsigned int v2:8;
  char v3;
};
//SIG(1 B_BFu8i_C) C1{ Fc Fi:8 Fc}



static void Test_B_BFu8i_C()
{
  {
    init_simple_test("B_BFu8i_C");
    static B_BFu8i_C lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_C)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_C)");
    check_field_offset(lv, v1, 0, "B_BFu8i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_C");
    check_field_offset(lv, v3, 2, "B_BFu8i_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_C(Test_B_BFu8i_C, "B_BFu8i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_D  {
  bool v1;
  unsigned int v2:8;
  double v3;
};
//SIG(1 B_BFu8i_D) C1{ Fc Fi:8 FL}



static void Test_B_BFu8i_D()
{
  {
    init_simple_test("B_BFu8i_D");
    static B_BFu8i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu8i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_D)");
    check_field_offset(lv, v1, 0, "B_BFu8i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8i_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_D(Test_B_BFu8i_D, "B_BFu8i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_F  {
  bool v1;
  unsigned int v2:8;
  float v3;
};
//SIG(1 B_BFu8i_F) C1{ Fc Fi:8 Fi}



static void Test_B_BFu8i_F()
{
  {
    init_simple_test("B_BFu8i_F");
    static B_BFu8i_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8i_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_F)");
    check_field_offset(lv, v1, 0, "B_BFu8i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_F");
    check_field_offset(lv, v3, 4, "B_BFu8i_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_F(Test_B_BFu8i_F, "B_BFu8i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_I  {
  bool v1;
  unsigned int v2:8;
  int v3;
};
//SIG(1 B_BFu8i_I) C1{ Fc Fi:8 Fi}



static void Test_B_BFu8i_I()
{
  {
    init_simple_test("B_BFu8i_I");
    static B_BFu8i_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8i_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_I)");
    check_field_offset(lv, v1, 0, "B_BFu8i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_I");
    check_field_offset(lv, v3, 4, "B_BFu8i_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_I(Test_B_BFu8i_I, "B_BFu8i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_Ip  {
  bool v1;
  unsigned int v2:8;
  int *v3;
};
//SIG(1 B_BFu8i_Ip) C1{ Fc Fi:8 Fp}



static void Test_B_BFu8i_Ip()
{
  {
    init_simple_test("B_BFu8i_Ip");
    static B_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu8i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8i_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_Ip(Test_B_BFu8i_Ip, "B_BFu8i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_L  {
  bool v1;
  unsigned int v2:8;
  __tsi64 v3;
};
//SIG(1 B_BFu8i_L) C1{ Fc Fi:8 FL}



static void Test_B_BFu8i_L()
{
  {
    init_simple_test("B_BFu8i_L");
    static B_BFu8i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu8i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_L)");
    check_field_offset(lv, v1, 0, "B_BFu8i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8i_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_L(Test_B_BFu8i_L, "B_BFu8i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_S  {
  bool v1;
  unsigned int v2:8;
  short v3;
};
//SIG(1 B_BFu8i_S) C1{ Fc Fi:8 Fs}



static void Test_B_BFu8i_S()
{
  {
    init_simple_test("B_BFu8i_S");
    static B_BFu8i_S lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_S)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_S)");
    check_field_offset(lv, v1, 0, "B_BFu8i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_S");
    check_field_offset(lv, v3, 2, "B_BFu8i_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_S(Test_B_BFu8i_S, "B_BFu8i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_Uc  {
  bool v1;
  unsigned int v2:8;
  unsigned char v3;
};
//SIG(1 B_BFu8i_Uc) C1{ Fc Fi:8 Fc}



static void Test_B_BFu8i_Uc()
{
  {
    init_simple_test("B_BFu8i_Uc");
    static B_BFu8i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_Uc");
    check_field_offset(lv, v3, 2, "B_BFu8i_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_Uc(Test_B_BFu8i_Uc, "B_BFu8i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_Ui  {
  bool v1;
  unsigned int v2:8;
  unsigned int v3;
};
//SIG(1 B_BFu8i_Ui) C1{ Fc Fi:8 Fi}



static void Test_B_BFu8i_Ui()
{
  {
    init_simple_test("B_BFu8i_Ui");
    static B_BFu8i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_Ui");
    check_field_offset(lv, v3, 4, "B_BFu8i_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_Ui(Test_B_BFu8i_Ui, "B_BFu8i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_Ul  {
  bool v1;
  unsigned int v2:8;
  __tsu64 v3;
};
//SIG(1 B_BFu8i_Ul) C1{ Fc Fi:8 FL}



static void Test_B_BFu8i_Ul()
{
  {
    init_simple_test("B_BFu8i_Ul");
    static B_BFu8i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu8i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8i_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_Ul(Test_B_BFu8i_Ul, "B_BFu8i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_Us  {
  bool v1;
  unsigned int v2:8;
  unsigned short v3;
};
//SIG(1 B_BFu8i_Us) C1{ Fc Fi:8 Fs}



static void Test_B_BFu8i_Us()
{
  {
    init_simple_test("B_BFu8i_Us");
    static B_BFu8i_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "B_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_Us");
    check_field_offset(lv, v3, 2, "B_BFu8i_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_Us(Test_B_BFu8i_Us, "B_BFu8i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8i_Vp  {
  bool v1;
  unsigned int v2:8;
  void *v3;
};
//SIG(1 B_BFu8i_Vp) C1{ Fc Fi:8 Fp}



static void Test_B_BFu8i_Vp()
{
  {
    init_simple_test("B_BFu8i_Vp");
    static B_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu8i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8i_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8i_Vp(Test_B_BFu8i_Vp, "B_BFu8i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll  {
  bool v1;
  __tsu64 v2:8;
};
//SIG(1 B_BFu8ll) C1{ Fc FL:8}



static void Test_B_BFu8ll()
{
  {
    init_simple_test("B_BFu8ll");
    static B_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll(Test_B_BFu8ll, "B_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_B  {
  bool v1;
  __tsu64 v2:8;
  bool v3;
};
//SIG(1 B_BFu8ll_B) C1{ Fc FL:8 Fc}



static void Test_B_BFu8ll_B()
{
  {
    init_simple_test("B_BFu8ll_B");
    static B_BFu8ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_B)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_B");
    check_field_offset(lv, v3, 2, "B_BFu8ll_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_B(Test_B_BFu8ll_B, "B_BFu8ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu15i  {
  bool v1;
  __tsu64 v2:8;
  unsigned int v3:15;
};
//SIG(1 B_BFu8ll_BFu15i) C1{ Fc FL:8 Fi:15}



static void Test_B_BFu8ll_BFu15i()
{
  {
    init_simple_test("B_BFu8ll_BFu15i");
    static B_BFu8ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8ll_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu15i(Test_B_BFu8ll_BFu15i, "B_BFu8ll_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu15ll  {
  bool v1;
  __tsu64 v2:8;
  __tsu64 v3:15;
};
//SIG(1 B_BFu8ll_BFu15ll) C1{ Fc FL:8 FL:15}



static void Test_B_BFu8ll_BFu15ll()
{
  {
    init_simple_test("B_BFu8ll_BFu15ll");
    static B_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu15ll(Test_B_BFu8ll_BFu15ll, "B_BFu8ll_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu15s  {
  bool v1;
  __tsu64 v2:8;
  unsigned short v3:15;
};
//SIG(1 B_BFu8ll_BFu15s) C1{ Fc FL:8 Fs:15}



static void Test_B_BFu8ll_BFu15s()
{
  {
    init_simple_test("B_BFu8ll_BFu15s");
    static B_BFu8ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8ll_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu15s(Test_B_BFu8ll_BFu15s, "B_BFu8ll_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu16i  {
  bool v1;
  __tsu64 v2:8;
  unsigned int v3:16;
};
//SIG(1 B_BFu8ll_BFu16i) C1{ Fc FL:8 Fi:16}



static void Test_B_BFu8ll_BFu16i()
{
  {
    init_simple_test("B_BFu8ll_BFu16i");
    static B_BFu8ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8ll_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu16i(Test_B_BFu8ll_BFu16i, "B_BFu8ll_BFu16i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu16ll  {
  bool v1;
  __tsu64 v2:8;
  __tsu64 v3:16;
};
//SIG(1 B_BFu8ll_BFu16ll) C1{ Fc FL:8 FL:16}



static void Test_B_BFu8ll_BFu16ll()
{
  {
    init_simple_test("B_BFu8ll_BFu16ll");
    static B_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu16ll(Test_B_BFu8ll_BFu16ll, "B_BFu8ll_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu16s  {
  bool v1;
  __tsu64 v2:8;
  unsigned short v3:16;
};
//SIG(1 B_BFu8ll_BFu16s) C1{ Fc FL:8 Fs:16}



static void Test_B_BFu8ll_BFu16s()
{
  {
    init_simple_test("B_BFu8ll_BFu16s");
    static B_BFu8ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8ll_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu16s(Test_B_BFu8ll_BFu16s, "B_BFu8ll_BFu16s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu17i  {
  bool v1;
  __tsu64 v2:8;
  unsigned int v3:17;
};
//SIG(1 B_BFu8ll_BFu17i) C1{ Fc FL:8 Fi:17}



static void Test_B_BFu8ll_BFu17i()
{
  {
    init_simple_test("B_BFu8ll_BFu17i");
    static B_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu8ll_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu17i(Test_B_BFu8ll_BFu17i, "B_BFu8ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu17ll  {
  bool v1;
  __tsu64 v2:8;
  __tsu64 v3:17;
};
//SIG(1 B_BFu8ll_BFu17ll) C1{ Fc FL:8 FL:17}



static void Test_B_BFu8ll_BFu17ll()
{
  {
    init_simple_test("B_BFu8ll_BFu17ll");
    static B_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "B_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "B_BFu8ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu17ll(Test_B_BFu8ll_BFu17ll, "B_BFu8ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu1c  {
  bool v1;
  __tsu64 v2:8;
  unsigned char v3:1;
};
//SIG(1 B_BFu8ll_BFu1c) C1{ Fc FL:8 Fc:1}



static void Test_B_BFu8ll_BFu1c()
{
  {
    init_simple_test("B_BFu8ll_BFu1c");
    static B_BFu8ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8ll_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu1c(Test_B_BFu8ll_BFu1c, "B_BFu8ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu1i  {
  bool v1;
  __tsu64 v2:8;
  unsigned int v3:1;
};
//SIG(1 B_BFu8ll_BFu1i) C1{ Fc FL:8 Fi:1}



static void Test_B_BFu8ll_BFu1i()
{
  {
    init_simple_test("B_BFu8ll_BFu1i");
    static B_BFu8ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8ll_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu1i(Test_B_BFu8ll_BFu1i, "B_BFu8ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu1ll  {
  bool v1;
  __tsu64 v2:8;
  __tsu64 v3:1;
};
//SIG(1 B_BFu8ll_BFu1ll) C1{ Fc FL:8 FL:1}



static void Test_B_BFu8ll_BFu1ll()
{
  {
    init_simple_test("B_BFu8ll_BFu1ll");
    static B_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu1ll(Test_B_BFu8ll_BFu1ll, "B_BFu8ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu1s  {
  bool v1;
  __tsu64 v2:8;
  unsigned short v3:1;
};
//SIG(1 B_BFu8ll_BFu1s) C1{ Fc FL:8 Fs:1}



static void Test_B_BFu8ll_BFu1s()
{
  {
    init_simple_test("B_BFu8ll_BFu1s");
    static B_BFu8ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8ll_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu1s(Test_B_BFu8ll_BFu1s, "B_BFu8ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu31i  {
  bool v1;
  __tsu64 v2:8;
  unsigned int v3:31;
};
//SIG(1 B_BFu8ll_BFu31i) C1{ Fc FL:8 Fi:31}



static void Test_B_BFu8ll_BFu31i()
{
  {
    init_simple_test("B_BFu8ll_BFu31i");
    static B_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu8ll_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu31i(Test_B_BFu8ll_BFu31i, "B_BFu8ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu31ll  {
  bool v1;
  __tsu64 v2:8;
  __tsu64 v3:31;
};
//SIG(1 B_BFu8ll_BFu31ll) C1{ Fc FL:8 FL:31}



static void Test_B_BFu8ll_BFu31ll()
{
  {
    init_simple_test("B_BFu8ll_BFu31ll");
    static B_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "B_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "B_BFu8ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu31ll(Test_B_BFu8ll_BFu31ll, "B_BFu8ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu32i  {
  bool v1;
  __tsu64 v2:8;
  unsigned int v3:32;
};
//SIG(1 B_BFu8ll_BFu32i) C1{ Fc FL:8 Fi:32}



static void Test_B_BFu8ll_BFu32i()
{
  {
    init_simple_test("B_BFu8ll_BFu32i");
    static B_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu8ll_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu32i(Test_B_BFu8ll_BFu32i, "B_BFu8ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu32ll  {
  bool v1;
  __tsu64 v2:8;
  __tsu64 v3:32;
};
//SIG(1 B_BFu8ll_BFu32ll) C1{ Fc FL:8 FL:32}



static void Test_B_BFu8ll_BFu32ll()
{
  {
    init_simple_test("B_BFu8ll_BFu32ll");
    static B_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "B_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "B_BFu8ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu32ll(Test_B_BFu8ll_BFu32ll, "B_BFu8ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu33  {
  bool v1;
  __tsu64 v2:8;
  __tsu64 v3:33;
};
//SIG(1 B_BFu8ll_BFu33) C1{ Fc FL:8 FL:33}



static void Test_B_BFu8ll_BFu33()
{
  {
    init_simple_test("B_BFu8ll_BFu33");
    static B_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "B_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "B_BFu8ll_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu33(Test_B_BFu8ll_BFu33, "B_BFu8ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu7c  {
  bool v1;
  __tsu64 v2:8;
  unsigned char v3:7;
};
//SIG(1 B_BFu8ll_BFu7c) C1{ Fc FL:8 Fc:7}



static void Test_B_BFu8ll_BFu7c()
{
  {
    init_simple_test("B_BFu8ll_BFu7c");
    static B_BFu8ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8ll_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu7c(Test_B_BFu8ll_BFu7c, "B_BFu8ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu7i  {
  bool v1;
  __tsu64 v2:8;
  unsigned int v3:7;
};
//SIG(1 B_BFu8ll_BFu7i) C1{ Fc FL:8 Fi:7}



static void Test_B_BFu8ll_BFu7i()
{
  {
    init_simple_test("B_BFu8ll_BFu7i");
    static B_BFu8ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8ll_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu7i(Test_B_BFu8ll_BFu7i, "B_BFu8ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu7ll  {
  bool v1;
  __tsu64 v2:8;
  __tsu64 v3:7;
};
//SIG(1 B_BFu8ll_BFu7ll) C1{ Fc FL:8 FL:7}



static void Test_B_BFu8ll_BFu7ll()
{
  {
    init_simple_test("B_BFu8ll_BFu7ll");
    static B_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu7ll(Test_B_BFu8ll_BFu7ll, "B_BFu8ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu7s  {
  bool v1;
  __tsu64 v2:8;
  unsigned short v3:7;
};
//SIG(1 B_BFu8ll_BFu7s) C1{ Fc FL:8 Fs:7}



static void Test_B_BFu8ll_BFu7s()
{
  {
    init_simple_test("B_BFu8ll_BFu7s");
    static B_BFu8ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8ll_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu7s(Test_B_BFu8ll_BFu7s, "B_BFu8ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu8c  {
  bool v1;
  __tsu64 v2:8;
  unsigned char v3:8;
};
//SIG(1 B_BFu8ll_BFu8c) C1{ Fc FL:8 Fc:8}



static void Test_B_BFu8ll_BFu8c()
{
  {
    init_simple_test("B_BFu8ll_BFu8c");
    static B_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu8c(Test_B_BFu8ll_BFu8c, "B_BFu8ll_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu8i  {
  bool v1;
  __tsu64 v2:8;
  unsigned int v3:8;
};
//SIG(1 B_BFu8ll_BFu8i) C1{ Fc FL:8 Fi:8}



static void Test_B_BFu8ll_BFu8i()
{
  {
    init_simple_test("B_BFu8ll_BFu8i");
    static B_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu8i(Test_B_BFu8ll_BFu8i, "B_BFu8ll_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu8ll  {
  bool v1;
  __tsu64 v2:8;
  __tsu64 v3:8;
};
//SIG(1 B_BFu8ll_BFu8ll) C1{ Fc FL:8 FL:8}



static void Test_B_BFu8ll_BFu8ll()
{
  {
    init_simple_test("B_BFu8ll_BFu8ll");
    static B_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu8ll(Test_B_BFu8ll_BFu8ll, "B_BFu8ll_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu8s  {
  bool v1;
  __tsu64 v2:8;
  unsigned short v3:8;
};
//SIG(1 B_BFu8ll_BFu8s) C1{ Fc FL:8 Fs:8}



static void Test_B_BFu8ll_BFu8s()
{
  {
    init_simple_test("B_BFu8ll_BFu8s");
    static B_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu8s(Test_B_BFu8ll_BFu8s, "B_BFu8ll_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu9i  {
  bool v1;
  __tsu64 v2:8;
  unsigned int v3:9;
};
//SIG(1 B_BFu8ll_BFu9i) C1{ Fc FL:8 Fi:9}



static void Test_B_BFu8ll_BFu9i()
{
  {
    init_simple_test("B_BFu8ll_BFu9i");
    static B_BFu8ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8ll_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu9i(Test_B_BFu8ll_BFu9i, "B_BFu8ll_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu9ll  {
  bool v1;
  __tsu64 v2:8;
  __tsu64 v3:9;
};
//SIG(1 B_BFu8ll_BFu9ll) C1{ Fc FL:8 FL:9}



static void Test_B_BFu8ll_BFu9ll()
{
  {
    init_simple_test("B_BFu8ll_BFu9ll");
    static B_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu9ll(Test_B_BFu8ll_BFu9ll, "B_BFu8ll_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_BFu9s  {
  bool v1;
  __tsu64 v2:8;
  unsigned short v3:9;
};
//SIG(1 B_BFu8ll_BFu9s) C1{ Fc FL:8 Fs:9}



static void Test_B_BFu8ll_BFu9s()
{
  {
    init_simple_test("B_BFu8ll_BFu9s");
    static B_BFu8ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8ll_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_BFu9s(Test_B_BFu8ll_BFu9s, "B_BFu8ll_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_C  {
  bool v1;
  __tsu64 v2:8;
  char v3;
};
//SIG(1 B_BFu8ll_C) C1{ Fc FL:8 Fc}



static void Test_B_BFu8ll_C()
{
  {
    init_simple_test("B_BFu8ll_C");
    static B_BFu8ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_C");
    check_field_offset(lv, v3, 2, "B_BFu8ll_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_C(Test_B_BFu8ll_C, "B_BFu8ll_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_D  {
  bool v1;
  __tsu64 v2:8;
  double v3;
};
//SIG(1 B_BFu8ll_D) C1{ Fc FL:8 FL}



static void Test_B_BFu8ll_D()
{
  {
    init_simple_test("B_BFu8ll_D");
    static B_BFu8ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu8ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8ll_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_D(Test_B_BFu8ll_D, "B_BFu8ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_F  {
  bool v1;
  __tsu64 v2:8;
  float v3;
};
//SIG(1 B_BFu8ll_F) C1{ Fc FL:8 Fi}



static void Test_B_BFu8ll_F()
{
  {
    init_simple_test("B_BFu8ll_F");
    static B_BFu8ll_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_F");
    check_field_offset(lv, v3, 4, "B_BFu8ll_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_F(Test_B_BFu8ll_F, "B_BFu8ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_I  {
  bool v1;
  __tsu64 v2:8;
  int v3;
};
//SIG(1 B_BFu8ll_I) C1{ Fc FL:8 Fi}



static void Test_B_BFu8ll_I()
{
  {
    init_simple_test("B_BFu8ll_I");
    static B_BFu8ll_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_I");
    check_field_offset(lv, v3, 4, "B_BFu8ll_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_I(Test_B_BFu8ll_I, "B_BFu8ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_Ip  {
  bool v1;
  __tsu64 v2:8;
  int *v3;
};
//SIG(1 B_BFu8ll_Ip) C1{ Fc FL:8 Fp}



static void Test_B_BFu8ll_Ip()
{
  {
    init_simple_test("B_BFu8ll_Ip");
    static B_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu8ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_Ip(Test_B_BFu8ll_Ip, "B_BFu8ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_L  {
  bool v1;
  __tsu64 v2:8;
  __tsi64 v3;
};
//SIG(1 B_BFu8ll_L) C1{ Fc FL:8 FL}



static void Test_B_BFu8ll_L()
{
  {
    init_simple_test("B_BFu8ll_L");
    static B_BFu8ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu8ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8ll_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_L(Test_B_BFu8ll_L, "B_BFu8ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_S  {
  bool v1;
  __tsu64 v2:8;
  short v3;
};
//SIG(1 B_BFu8ll_S) C1{ Fc FL:8 Fs}



static void Test_B_BFu8ll_S()
{
  {
    init_simple_test("B_BFu8ll_S");
    static B_BFu8ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_S");
    check_field_offset(lv, v3, 2, "B_BFu8ll_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_S(Test_B_BFu8ll_S, "B_BFu8ll_S", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_Uc  {
  bool v1;
  __tsu64 v2:8;
  unsigned char v3;
};
//SIG(1 B_BFu8ll_Uc) C1{ Fc FL:8 Fc}



static void Test_B_BFu8ll_Uc()
{
  {
    init_simple_test("B_BFu8ll_Uc");
    static B_BFu8ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_Uc");
    check_field_offset(lv, v3, 2, "B_BFu8ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_Uc(Test_B_BFu8ll_Uc, "B_BFu8ll_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_Ui  {
  bool v1;
  __tsu64 v2:8;
  unsigned int v3;
};
//SIG(1 B_BFu8ll_Ui) C1{ Fc FL:8 Fi}



static void Test_B_BFu8ll_Ui()
{
  {
    init_simple_test("B_BFu8ll_Ui");
    static B_BFu8ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_Ui");
    check_field_offset(lv, v3, 4, "B_BFu8ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_Ui(Test_B_BFu8ll_Ui, "B_BFu8ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_Ul  {
  bool v1;
  __tsu64 v2:8;
  __tsu64 v3;
};
//SIG(1 B_BFu8ll_Ul) C1{ Fc FL:8 FL}



static void Test_B_BFu8ll_Ul()
{
  {
    init_simple_test("B_BFu8ll_Ul");
    static B_BFu8ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu8ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_Ul(Test_B_BFu8ll_Ul, "B_BFu8ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_Us  {
  bool v1;
  __tsu64 v2:8;
  unsigned short v3;
};
//SIG(1 B_BFu8ll_Us) C1{ Fc FL:8 Fs}



static void Test_B_BFu8ll_Us()
{
  {
    init_simple_test("B_BFu8ll_Us");
    static B_BFu8ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_Us");
    check_field_offset(lv, v3, 2, "B_BFu8ll_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_Us(Test_B_BFu8ll_Us, "B_BFu8ll_Us", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8ll_Vp  {
  bool v1;
  __tsu64 v2:8;
  void *v3;
};
//SIG(1 B_BFu8ll_Vp) C1{ Fc FL:8 Fp}



static void Test_B_BFu8ll_Vp()
{
  {
    init_simple_test("B_BFu8ll_Vp");
    static B_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu8ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8ll_Vp(Test_B_BFu8ll_Vp, "B_BFu8ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s  {
  bool v1;
  unsigned short v2:8;
};
//SIG(1 B_BFu8s) C1{ Fc Fs:8}



static void Test_B_BFu8s()
{
  {
    init_simple_test("B_BFu8s");
    static B_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(B_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu8s(Test_B_BFu8s, "B_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_B  {
  bool v1;
  unsigned short v2:8;
  bool v3;
};
//SIG(1 B_BFu8s_B) C1{ Fc Fs:8 Fc}



static void Test_B_BFu8s_B()
{
  {
    init_simple_test("B_BFu8s_B");
    static B_BFu8s_B lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_B)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s_B)");
    check_field_offset(lv, v1, 0, "B_BFu8s_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_B");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_B");
    check_field_offset(lv, v3, 2, "B_BFu8s_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_B(Test_B_BFu8s_B, "B_BFu8s_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu15i  {
  bool v1;
  unsigned short v2:8;
  unsigned int v3:15;
};
//SIG(1 B_BFu8s_BFu15i) C1{ Fc Fs:8 Fi:15}



static void Test_B_BFu8s_BFu15i()
{
  {
    init_simple_test("B_BFu8s_BFu15i");
    static B_BFu8s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8s_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu15i(Test_B_BFu8s_BFu15i, "B_BFu8s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu15ll  {
  bool v1;
  unsigned short v2:8;
  __tsu64 v3:15;
};
//SIG(1 B_BFu8s_BFu15ll) C1{ Fc Fs:8 FL:15}



static void Test_B_BFu8s_BFu15ll()
{
  {
    init_simple_test("B_BFu8s_BFu15ll");
    static B_BFu8s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8s_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu15ll(Test_B_BFu8s_BFu15ll, "B_BFu8s_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu15s  {
  bool v1;
  unsigned short v2:8;
  unsigned short v3:15;
};
//SIG(1 B_BFu8s_BFu15s) C1{ Fc Fs:8 Fs:15}



static void Test_B_BFu8s_BFu15s()
{
  {
    init_simple_test("B_BFu8s_BFu15s");
    static B_BFu8s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "B_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "B_BFu8s_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu15s(Test_B_BFu8s_BFu15s, "B_BFu8s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu16i  {
  bool v1;
  unsigned short v2:8;
  unsigned int v3:16;
};
//SIG(1 B_BFu8s_BFu16i) C1{ Fc Fs:8 Fi:16}



static void Test_B_BFu8s_BFu16i()
{
  {
    init_simple_test("B_BFu8s_BFu16i");
    static B_BFu8s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8s_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu16i(Test_B_BFu8s_BFu16i, "B_BFu8s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu16ll  {
  bool v1;
  unsigned short v2:8;
  __tsu64 v3:16;
};
//SIG(1 B_BFu8s_BFu16ll) C1{ Fc Fs:8 FL:16}



static void Test_B_BFu8s_BFu16ll()
{
  {
    init_simple_test("B_BFu8s_BFu16ll");
    static B_BFu8s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8s_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu16ll(Test_B_BFu8s_BFu16ll, "B_BFu8s_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu16s  {
  bool v1;
  unsigned short v2:8;
  unsigned short v3:16;
};
//SIG(1 B_BFu8s_BFu16s) C1{ Fc Fs:8 Fs:16}



static void Test_B_BFu8s_BFu16s()
{
  {
    init_simple_test("B_BFu8s_BFu16s");
    static B_BFu8s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "B_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "B_BFu8s_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu16s(Test_B_BFu8s_BFu16s, "B_BFu8s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu17i  {
  bool v1;
  unsigned short v2:8;
  unsigned int v3:17;
};
//SIG(1 B_BFu8s_BFu17i) C1{ Fc Fs:8 Fi:17}



static void Test_B_BFu8s_BFu17i()
{
  {
    init_simple_test("B_BFu8s_BFu17i");
    static B_BFu8s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu8s_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu17i(Test_B_BFu8s_BFu17i, "B_BFu8s_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu17ll  {
  bool v1;
  unsigned short v2:8;
  __tsu64 v3:17;
};
//SIG(1 B_BFu8s_BFu17ll) C1{ Fc Fs:8 FL:17}



static void Test_B_BFu8s_BFu17ll()
{
  {
    init_simple_test("B_BFu8s_BFu17ll");
    static B_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "B_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "B_BFu8s_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu17ll(Test_B_BFu8s_BFu17ll, "B_BFu8s_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu1c  {
  bool v1;
  unsigned short v2:8;
  unsigned char v3:1;
};
//SIG(1 B_BFu8s_BFu1c) C1{ Fc Fs:8 Fc:1}



static void Test_B_BFu8s_BFu1c()
{
  {
    init_simple_test("B_BFu8s_BFu1c");
    static B_BFu8s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8s_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu1c(Test_B_BFu8s_BFu1c, "B_BFu8s_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu1i  {
  bool v1;
  unsigned short v2:8;
  unsigned int v3:1;
};
//SIG(1 B_BFu8s_BFu1i) C1{ Fc Fs:8 Fi:1}



static void Test_B_BFu8s_BFu1i()
{
  {
    init_simple_test("B_BFu8s_BFu1i");
    static B_BFu8s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8s_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu1i(Test_B_BFu8s_BFu1i, "B_BFu8s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu1ll  {
  bool v1;
  unsigned short v2:8;
  __tsu64 v3:1;
};
//SIG(1 B_BFu8s_BFu1ll) C1{ Fc Fs:8 FL:1}



static void Test_B_BFu8s_BFu1ll()
{
  {
    init_simple_test("B_BFu8s_BFu1ll");
    static B_BFu8s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8s_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu1ll(Test_B_BFu8s_BFu1ll, "B_BFu8s_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu1s  {
  bool v1;
  unsigned short v2:8;
  unsigned short v3:1;
};
//SIG(1 B_BFu8s_BFu1s) C1{ Fc Fs:8 Fs:1}



static void Test_B_BFu8s_BFu1s()
{
  {
    init_simple_test("B_BFu8s_BFu1s");
    static B_BFu8s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "B_BFu8s_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu1s(Test_B_BFu8s_BFu1s, "B_BFu8s_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu31i  {
  bool v1;
  unsigned short v2:8;
  unsigned int v3:31;
};
//SIG(1 B_BFu8s_BFu31i) C1{ Fc Fs:8 Fi:31}



static void Test_B_BFu8s_BFu31i()
{
  {
    init_simple_test("B_BFu8s_BFu31i");
    static B_BFu8s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu8s_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu31i(Test_B_BFu8s_BFu31i, "B_BFu8s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu31ll  {
  bool v1;
  unsigned short v2:8;
  __tsu64 v3:31;
};
//SIG(1 B_BFu8s_BFu31ll) C1{ Fc Fs:8 FL:31}



static void Test_B_BFu8s_BFu31ll()
{
  {
    init_simple_test("B_BFu8s_BFu31ll");
    static B_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "B_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "B_BFu8s_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu31ll(Test_B_BFu8s_BFu31ll, "B_BFu8s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu32i  {
  bool v1;
  unsigned short v2:8;
  unsigned int v3:32;
};
//SIG(1 B_BFu8s_BFu32i) C1{ Fc Fs:8 Fi:32}



static void Test_B_BFu8s_BFu32i()
{
  {
    init_simple_test("B_BFu8s_BFu32i");
    static B_BFu8s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu8s_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu32i(Test_B_BFu8s_BFu32i, "B_BFu8s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu32ll  {
  bool v1;
  unsigned short v2:8;
  __tsu64 v3:32;
};
//SIG(1 B_BFu8s_BFu32ll) C1{ Fc Fs:8 FL:32}



static void Test_B_BFu8s_BFu32ll()
{
  {
    init_simple_test("B_BFu8s_BFu32ll");
    static B_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "B_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "B_BFu8s_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu32ll(Test_B_BFu8s_BFu32ll, "B_BFu8s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu33  {
  bool v1;
  unsigned short v2:8;
  __tsu64 v3:33;
};
//SIG(1 B_BFu8s_BFu33) C1{ Fc Fs:8 FL:33}



static void Test_B_BFu8s_BFu33()
{
  {
    init_simple_test("B_BFu8s_BFu33");
    static B_BFu8s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "B_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "B_BFu8s_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu33(Test_B_BFu8s_BFu33, "B_BFu8s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu7c  {
  bool v1;
  unsigned short v2:8;
  unsigned char v3:7;
};
//SIG(1 B_BFu8s_BFu7c) C1{ Fc Fs:8 Fc:7}



static void Test_B_BFu8s_BFu7c()
{
  {
    init_simple_test("B_BFu8s_BFu7c");
    static B_BFu8s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8s_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu7c(Test_B_BFu8s_BFu7c, "B_BFu8s_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu7i  {
  bool v1;
  unsigned short v2:8;
  unsigned int v3:7;
};
//SIG(1 B_BFu8s_BFu7i) C1{ Fc Fs:8 Fi:7}



static void Test_B_BFu8s_BFu7i()
{
  {
    init_simple_test("B_BFu8s_BFu7i");
    static B_BFu8s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8s_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu7i(Test_B_BFu8s_BFu7i, "B_BFu8s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu7ll  {
  bool v1;
  unsigned short v2:8;
  __tsu64 v3:7;
};
//SIG(1 B_BFu8s_BFu7ll) C1{ Fc Fs:8 FL:7}



static void Test_B_BFu8s_BFu7ll()
{
  {
    init_simple_test("B_BFu8s_BFu7ll");
    static B_BFu8s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8s_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu7ll(Test_B_BFu8s_BFu7ll, "B_BFu8s_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu7s  {
  bool v1;
  unsigned short v2:8;
  unsigned short v3:7;
};
//SIG(1 B_BFu8s_BFu7s) C1{ Fc Fs:8 Fs:7}



static void Test_B_BFu8s_BFu7s()
{
  {
    init_simple_test("B_BFu8s_BFu7s");
    static B_BFu8s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "B_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "B_BFu8s_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu7s(Test_B_BFu8s_BFu7s, "B_BFu8s_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu8c  {
  bool v1;
  unsigned short v2:8;
  unsigned char v3:8;
};
//SIG(1 B_BFu8s_BFu8c) C1{ Fc Fs:8 Fc:8}



static void Test_B_BFu8s_BFu8c()
{
  {
    init_simple_test("B_BFu8s_BFu8c");
    static B_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu8c(Test_B_BFu8s_BFu8c, "B_BFu8s_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu8i  {
  bool v1;
  unsigned short v2:8;
  unsigned int v3:8;
};
//SIG(1 B_BFu8s_BFu8i) C1{ Fc Fs:8 Fi:8}



static void Test_B_BFu8s_BFu8i()
{
  {
    init_simple_test("B_BFu8s_BFu8i");
    static B_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu8i(Test_B_BFu8s_BFu8i, "B_BFu8s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu8ll  {
  bool v1;
  unsigned short v2:8;
  __tsu64 v3:8;
};
//SIG(1 B_BFu8s_BFu8ll) C1{ Fc Fs:8 FL:8}



static void Test_B_BFu8s_BFu8ll()
{
  {
    init_simple_test("B_BFu8s_BFu8ll");
    static B_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu8ll(Test_B_BFu8s_BFu8ll, "B_BFu8s_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu8s  {
  bool v1;
  unsigned short v2:8;
  unsigned short v3:8;
};
//SIG(1 B_BFu8s_BFu8s) C1{ Fc Fs:8 Fs:8}



static void Test_B_BFu8s_BFu8s()
{
  {
    init_simple_test("B_BFu8s_BFu8s");
    static B_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "B_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu8s(Test_B_BFu8s_BFu8s, "B_BFu8s_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu9i  {
  bool v1;
  unsigned short v2:8;
  unsigned int v3:9;
};
//SIG(1 B_BFu8s_BFu9i) C1{ Fc Fs:8 Fi:9}



static void Test_B_BFu8s_BFu9i()
{
  {
    init_simple_test("B_BFu8s_BFu9i");
    static B_BFu8s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8s_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu9i(Test_B_BFu8s_BFu9i, "B_BFu8s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu9ll  {
  bool v1;
  unsigned short v2:8;
  __tsu64 v3:9;
};
//SIG(1 B_BFu8s_BFu9ll) C1{ Fc Fs:8 FL:9}



static void Test_B_BFu8s_BFu9ll()
{
  {
    init_simple_test("B_BFu8s_BFu9ll");
    static B_BFu8s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu8s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8s_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu9ll(Test_B_BFu8s_BFu9ll, "B_BFu8s_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_BFu9s  {
  bool v1;
  unsigned short v2:8;
  unsigned short v3:9;
};
//SIG(1 B_BFu8s_BFu9s) C1{ Fc Fs:8 Fs:9}



static void Test_B_BFu8s_BFu9s()
{
  {
    init_simple_test("B_BFu8s_BFu9s");
    static B_BFu8s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "B_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "B_BFu8s_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu8s_BFu9s(Test_B_BFu8s_BFu9s, "B_BFu8s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_C  {
  bool v1;
  unsigned short v2:8;
  char v3;
};
//SIG(1 B_BFu8s_C) C1{ Fc Fs:8 Fc}



static void Test_B_BFu8s_C()
{
  {
    init_simple_test("B_BFu8s_C");
    static B_BFu8s_C lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_C)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s_C)");
    check_field_offset(lv, v1, 0, "B_BFu8s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_C");
    check_field_offset(lv, v3, 2, "B_BFu8s_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_C(Test_B_BFu8s_C, "B_BFu8s_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_D  {
  bool v1;
  unsigned short v2:8;
  double v3;
};
//SIG(1 B_BFu8s_D) C1{ Fc Fs:8 FL}



static void Test_B_BFu8s_D()
{
  {
    init_simple_test("B_BFu8s_D");
    static B_BFu8s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu8s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_D)");
    check_field_offset(lv, v1, 0, "B_BFu8s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8s_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_D(Test_B_BFu8s_D, "B_BFu8s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_F  {
  bool v1;
  unsigned short v2:8;
  float v3;
};
//SIG(1 B_BFu8s_F) C1{ Fc Fs:8 Fi}



static void Test_B_BFu8s_F()
{
  {
    init_simple_test("B_BFu8s_F");
    static B_BFu8s_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8s_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8s_F)");
    check_field_offset(lv, v1, 0, "B_BFu8s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_F");
    check_field_offset(lv, v3, 4, "B_BFu8s_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_F(Test_B_BFu8s_F, "B_BFu8s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_I  {
  bool v1;
  unsigned short v2:8;
  int v3;
};
//SIG(1 B_BFu8s_I) C1{ Fc Fs:8 Fi}



static void Test_B_BFu8s_I()
{
  {
    init_simple_test("B_BFu8s_I");
    static B_BFu8s_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8s_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8s_I)");
    check_field_offset(lv, v1, 0, "B_BFu8s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_I");
    check_field_offset(lv, v3, 4, "B_BFu8s_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_I(Test_B_BFu8s_I, "B_BFu8s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_Ip  {
  bool v1;
  unsigned short v2:8;
  int *v3;
};
//SIG(1 B_BFu8s_Ip) C1{ Fc Fs:8 Fp}



static void Test_B_BFu8s_Ip()
{
  {
    init_simple_test("B_BFu8s_Ip");
    static B_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu8s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8s_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_Ip(Test_B_BFu8s_Ip, "B_BFu8s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_L  {
  bool v1;
  unsigned short v2:8;
  __tsi64 v3;
};
//SIG(1 B_BFu8s_L) C1{ Fc Fs:8 FL}



static void Test_B_BFu8s_L()
{
  {
    init_simple_test("B_BFu8s_L");
    static B_BFu8s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu8s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_L)");
    check_field_offset(lv, v1, 0, "B_BFu8s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8s_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_L(Test_B_BFu8s_L, "B_BFu8s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_S  {
  bool v1;
  unsigned short v2:8;
  short v3;
};
//SIG(1 B_BFu8s_S) C1{ Fc Fs:8 Fs}



static void Test_B_BFu8s_S()
{
  {
    init_simple_test("B_BFu8s_S");
    static B_BFu8s_S lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_S)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s_S)");
    check_field_offset(lv, v1, 0, "B_BFu8s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_S");
    check_field_offset(lv, v3, 2, "B_BFu8s_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_S(Test_B_BFu8s_S, "B_BFu8s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_Uc  {
  bool v1;
  unsigned short v2:8;
  unsigned char v3;
};
//SIG(1 B_BFu8s_Uc) C1{ Fc Fs:8 Fc}



static void Test_B_BFu8s_Uc()
{
  {
    init_simple_test("B_BFu8s_Uc");
    static B_BFu8s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_Uc");
    check_field_offset(lv, v3, 2, "B_BFu8s_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_Uc(Test_B_BFu8s_Uc, "B_BFu8s_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_Ui  {
  bool v1;
  unsigned short v2:8;
  unsigned int v3;
};
//SIG(1 B_BFu8s_Ui) C1{ Fc Fs:8 Fi}



static void Test_B_BFu8s_Ui()
{
  {
    init_simple_test("B_BFu8s_Ui");
    static B_BFu8s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu8s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_Ui");
    check_field_offset(lv, v3, 4, "B_BFu8s_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_Ui(Test_B_BFu8s_Ui, "B_BFu8s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_Ul  {
  bool v1;
  unsigned short v2:8;
  __tsu64 v3;
};
//SIG(1 B_BFu8s_Ul) C1{ Fc Fs:8 FL}



static void Test_B_BFu8s_Ul()
{
  {
    init_simple_test("B_BFu8s_Ul");
    static B_BFu8s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu8s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8s_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_Ul(Test_B_BFu8s_Ul, "B_BFu8s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_Us  {
  bool v1;
  unsigned short v2:8;
  unsigned short v3;
};
//SIG(1 B_BFu8s_Us) C1{ Fc Fs:8 Fs}



static void Test_B_BFu8s_Us()
{
  {
    init_simple_test("B_BFu8s_Us");
    static B_BFu8s_Us lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu8s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(B_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "B_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_Us");
    check_field_offset(lv, v3, 2, "B_BFu8s_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_Us(Test_B_BFu8s_Us, "B_BFu8s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu8s_Vp  {
  bool v1;
  unsigned short v2:8;
  void *v3;
};
//SIG(1 B_BFu8s_Vp) C1{ Fc Fs:8 Fp}



static void Test_B_BFu8s_Vp()
{
  {
    init_simple_test("B_BFu8s_Vp");
    static B_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu8s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "B_BFu8s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "B_BFu8s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu8s_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu8s_Vp(Test_B_BFu8s_Vp, "B_BFu8s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i  {
  bool v1;
  unsigned int v2:9;
};
//SIG(1 B_BFu9i) C1{ Fc Fi:9}



static void Test_B_BFu9i()
{
  {
    init_simple_test("B_BFu9i");
    static B_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu9i(Test_B_BFu9i, "B_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_B  {
  bool v1;
  unsigned int v2:9;
  bool v3;
};
//SIG(1 B_BFu9i_B) C1{ Fc Fi:9 Fc}



static void Test_B_BFu9i_B()
{
  {
    init_simple_test("B_BFu9i_B");
    static B_BFu9i_B lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_B)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_B)");
    check_field_offset(lv, v1, 0, "B_BFu9i_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_B");
    check_field_offset(lv, v3, 3, "B_BFu9i_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_B(Test_B_BFu9i_B, "B_BFu9i_B", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu15i  {
  bool v1;
  unsigned int v2:9;
  unsigned int v3:15;
};
//SIG(1 B_BFu9i_BFu15i) C1{ Fc Fi:9 Fi:15}



static void Test_B_BFu9i_BFu15i()
{
  {
    init_simple_test("B_BFu9i_BFu15i");
    static B_BFu9i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9i_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu15i(Test_B_BFu9i_BFu15i, "B_BFu9i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu15ll  {
  bool v1;
  unsigned int v2:9;
  __tsu64 v3:15;
};
//SIG(1 B_BFu9i_BFu15ll) C1{ Fc Fi:9 FL:15}



static void Test_B_BFu9i_BFu15ll()
{
  {
    init_simple_test("B_BFu9i_BFu15ll");
    static B_BFu9i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu9i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9i_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu15ll(Test_B_BFu9i_BFu15ll, "B_BFu9i_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu15s  {
  bool v1;
  unsigned int v2:9;
  unsigned short v3:15;
};
//SIG(1 B_BFu9i_BFu15s) C1{ Fc Fi:9 Fs:15}



static void Test_B_BFu9i_BFu15s()
{
  {
    init_simple_test("B_BFu9i_BFu15s");
    static B_BFu9i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9i_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu15s(Test_B_BFu9i_BFu15s, "B_BFu9i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu16i  {
  bool v1;
  unsigned int v2:9;
  unsigned int v3:16;
};
//SIG(1 B_BFu9i_BFu16i) C1{ Fc Fi:9 Fi:16}



static void Test_B_BFu9i_BFu16i()
{
  {
    init_simple_test("B_BFu9i_BFu16i");
    static B_BFu9i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu9i_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu16i(Test_B_BFu9i_BFu16i, "B_BFu9i_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu16ll  {
  bool v1;
  unsigned int v2:9;
  __tsu64 v3:16;
};
//SIG(1 B_BFu9i_BFu16ll) C1{ Fc Fi:9 FL:16}



static void Test_B_BFu9i_BFu16ll()
{
  {
    init_simple_test("B_BFu9i_BFu16ll");
    static B_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "B_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "B_BFu9i_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu16ll(Test_B_BFu9i_BFu16ll, "B_BFu9i_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu16s  {
  bool v1;
  unsigned int v2:9;
  unsigned short v3:16;
};
//SIG(1 B_BFu9i_BFu16s) C1{ Fc Fi:9 Fs:16}



static void Test_B_BFu9i_BFu16s()
{
  {
    init_simple_test("B_BFu9i_BFu16s");
    static B_BFu9i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu9i_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu16s(Test_B_BFu9i_BFu16s, "B_BFu9i_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu17i  {
  bool v1;
  unsigned int v2:9;
  unsigned int v3:17;
};
//SIG(1 B_BFu9i_BFu17i) C1{ Fc Fi:9 Fi:17}



static void Test_B_BFu9i_BFu17i()
{
  {
    init_simple_test("B_BFu9i_BFu17i");
    static B_BFu9i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu9i_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu17i(Test_B_BFu9i_BFu17i, "B_BFu9i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu17ll  {
  bool v1;
  unsigned int v2:9;
  __tsu64 v3:17;
};
//SIG(1 B_BFu9i_BFu17ll) C1{ Fc Fi:9 FL:17}



static void Test_B_BFu9i_BFu17ll()
{
  {
    init_simple_test("B_BFu9i_BFu17ll");
    static B_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "B_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "B_BFu9i_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu17ll(Test_B_BFu9i_BFu17ll, "B_BFu9i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu1c  {
  bool v1;
  unsigned int v2:9;
  unsigned char v3:1;
};
//SIG(1 B_BFu9i_BFu1c) C1{ Fc Fi:9 Fc:1}



static void Test_B_BFu9i_BFu1c()
{
  {
    init_simple_test("B_BFu9i_BFu1c");
    static B_BFu9i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9i_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu1c(Test_B_BFu9i_BFu1c, "B_BFu9i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu1i  {
  bool v1;
  unsigned int v2:9;
  unsigned int v3:1;
};
//SIG(1 B_BFu9i_BFu1i) C1{ Fc Fi:9 Fi:1}



static void Test_B_BFu9i_BFu1i()
{
  {
    init_simple_test("B_BFu9i_BFu1i");
    static B_BFu9i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9i_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu1i(Test_B_BFu9i_BFu1i, "B_BFu9i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu1ll  {
  bool v1;
  unsigned int v2:9;
  __tsu64 v3:1;
};
//SIG(1 B_BFu9i_BFu1ll) C1{ Fc Fi:9 FL:1}



static void Test_B_BFu9i_BFu1ll()
{
  {
    init_simple_test("B_BFu9i_BFu1ll");
    static B_BFu9i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu9i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9i_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu1ll(Test_B_BFu9i_BFu1ll, "B_BFu9i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu1s  {
  bool v1;
  unsigned int v2:9;
  unsigned short v3:1;
};
//SIG(1 B_BFu9i_BFu1s) C1{ Fc Fi:9 Fs:1}



static void Test_B_BFu9i_BFu1s()
{
  {
    init_simple_test("B_BFu9i_BFu1s");
    static B_BFu9i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9i_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu1s(Test_B_BFu9i_BFu1s, "B_BFu9i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu31i  {
  bool v1;
  unsigned int v2:9;
  unsigned int v3:31;
};
//SIG(1 B_BFu9i_BFu31i) C1{ Fc Fi:9 Fi:31}



static void Test_B_BFu9i_BFu31i()
{
  {
    init_simple_test("B_BFu9i_BFu31i");
    static B_BFu9i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu9i_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu31i(Test_B_BFu9i_BFu31i, "B_BFu9i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu31ll  {
  bool v1;
  unsigned int v2:9;
  __tsu64 v3:31;
};
//SIG(1 B_BFu9i_BFu31ll) C1{ Fc Fi:9 FL:31}



static void Test_B_BFu9i_BFu31ll()
{
  {
    init_simple_test("B_BFu9i_BFu31ll");
    static B_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "B_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "B_BFu9i_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu31ll(Test_B_BFu9i_BFu31ll, "B_BFu9i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu32i  {
  bool v1;
  unsigned int v2:9;
  unsigned int v3:32;
};
//SIG(1 B_BFu9i_BFu32i) C1{ Fc Fi:9 Fi:32}



static void Test_B_BFu9i_BFu32i()
{
  {
    init_simple_test("B_BFu9i_BFu32i");
    static B_BFu9i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu9i_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu32i(Test_B_BFu9i_BFu32i, "B_BFu9i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu32ll  {
  bool v1;
  unsigned int v2:9;
  __tsu64 v3:32;
};
//SIG(1 B_BFu9i_BFu32ll) C1{ Fc Fi:9 FL:32}



static void Test_B_BFu9i_BFu32ll()
{
  {
    init_simple_test("B_BFu9i_BFu32ll");
    static B_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "B_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "B_BFu9i_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu32ll(Test_B_BFu9i_BFu32ll, "B_BFu9i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu33  {
  bool v1;
  unsigned int v2:9;
  __tsu64 v3:33;
};
//SIG(1 B_BFu9i_BFu33) C1{ Fc Fi:9 FL:33}



static void Test_B_BFu9i_BFu33()
{
  {
    init_simple_test("B_BFu9i_BFu33");
    static B_BFu9i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "B_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "B_BFu9i_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu33(Test_B_BFu9i_BFu33, "B_BFu9i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu7c  {
  bool v1;
  unsigned int v2:9;
  unsigned char v3:7;
};
//SIG(1 B_BFu9i_BFu7c) C1{ Fc Fi:9 Fc:7}



static void Test_B_BFu9i_BFu7c()
{
  {
    init_simple_test("B_BFu9i_BFu7c");
    static B_BFu9i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9i_BFu7c");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu7c(Test_B_BFu9i_BFu7c, "B_BFu9i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu7i  {
  bool v1;
  unsigned int v2:9;
  unsigned int v3:7;
};
//SIG(1 B_BFu9i_BFu7i) C1{ Fc Fi:9 Fi:7}



static void Test_B_BFu9i_BFu7i()
{
  {
    init_simple_test("B_BFu9i_BFu7i");
    static B_BFu9i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9i_BFu7i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu7i(Test_B_BFu9i_BFu7i, "B_BFu9i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu7ll  {
  bool v1;
  unsigned int v2:9;
  __tsu64 v3:7;
};
//SIG(1 B_BFu9i_BFu7ll) C1{ Fc Fi:9 FL:7}



static void Test_B_BFu9i_BFu7ll()
{
  {
    init_simple_test("B_BFu9i_BFu7ll");
    static B_BFu9i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu9i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9i_BFu7ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu7ll(Test_B_BFu9i_BFu7ll, "B_BFu9i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu7s  {
  bool v1;
  unsigned int v2:9;
  unsigned short v3:7;
};
//SIG(1 B_BFu9i_BFu7s) C1{ Fc Fi:9 Fs:7}



static void Test_B_BFu9i_BFu7s()
{
  {
    init_simple_test("B_BFu9i_BFu7s");
    static B_BFu9i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "B_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "B_BFu9i_BFu7s");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu7s(Test_B_BFu9i_BFu7s, "B_BFu9i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu8c  {
  bool v1;
  unsigned int v2:9;
  unsigned char v3:8;
};
//SIG(1 B_BFu9i_BFu8c) C1{ Fc Fi:9 Fc:8}



static void Test_B_BFu9i_BFu8c()
{
  {
    init_simple_test("B_BFu9i_BFu8c");
    static B_BFu9i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "B_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "B_BFu9i_BFu8c");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu8c(Test_B_BFu9i_BFu8c, "B_BFu9i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu8i  {
  bool v1;
  unsigned int v2:9;
  unsigned int v3:8;
};
//SIG(1 B_BFu9i_BFu8i) C1{ Fc Fi:9 Fi:8}



static void Test_B_BFu9i_BFu8i()
{
  {
    init_simple_test("B_BFu9i_BFu8i");
    static B_BFu9i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9i_BFu8i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu8i(Test_B_BFu9i_BFu8i, "B_BFu9i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu8ll  {
  bool v1;
  unsigned int v2:9;
  __tsu64 v3:8;
};
//SIG(1 B_BFu9i_BFu8ll) C1{ Fc Fi:9 FL:8}



static void Test_B_BFu9i_BFu8ll()
{
  {
    init_simple_test("B_BFu9i_BFu8ll");
    static B_BFu9i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu9i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9i_BFu8ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu8ll(Test_B_BFu9i_BFu8ll, "B_BFu9i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu8s  {
  bool v1;
  unsigned int v2:9;
  unsigned short v3:8;
};
//SIG(1 B_BFu9i_BFu8s) C1{ Fc Fi:9 Fs:8}



static void Test_B_BFu9i_BFu8s()
{
  {
    init_simple_test("B_BFu9i_BFu8s");
    static B_BFu9i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "B_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "B_BFu9i_BFu8s");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu8s(Test_B_BFu9i_BFu8s, "B_BFu9i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu9i  {
  bool v1;
  unsigned int v2:9;
  unsigned int v3:9;
};
//SIG(1 B_BFu9i_BFu9i) C1{ Fc Fi:9 Fi:9}



static void Test_B_BFu9i_BFu9i()
{
  {
    init_simple_test("B_BFu9i_BFu9i");
    static B_BFu9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "B_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "B_BFu9i_BFu9i");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu9i(Test_B_BFu9i_BFu9i, "B_BFu9i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu9ll  {
  bool v1;
  unsigned int v2:9;
  __tsu64 v3:9;
};
//SIG(1 B_BFu9i_BFu9ll) C1{ Fc Fi:9 FL:9}



static void Test_B_BFu9i_BFu9ll()
{
  {
    init_simple_test("B_BFu9i_BFu9ll");
    static B_BFu9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "B_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "B_BFu9i_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu9ll(Test_B_BFu9i_BFu9ll, "B_BFu9i_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_BFu9s  {
  bool v1;
  unsigned int v2:9;
  unsigned short v3:9;
};
//SIG(1 B_BFu9i_BFu9s) C1{ Fc Fi:9 Fs:9}



static void Test_B_BFu9i_BFu9s()
{
  {
    init_simple_test("B_BFu9i_BFu9s");
    static B_BFu9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "B_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "B_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "B_BFu9i_BFu9s");
  }
}
static Arrange_To_Call_Me vB_BFu9i_BFu9s(Test_B_BFu9i_BFu9s, "B_BFu9i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_C  {
  bool v1;
  unsigned int v2:9;
  char v3;
};
//SIG(1 B_BFu9i_C) C1{ Fc Fi:9 Fc}



static void Test_B_BFu9i_C()
{
  {
    init_simple_test("B_BFu9i_C");
    static B_BFu9i_C lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_C)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_C)");
    check_field_offset(lv, v1, 0, "B_BFu9i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_C");
    check_field_offset(lv, v3, 3, "B_BFu9i_C.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_C(Test_B_BFu9i_C, "B_BFu9i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_D  {
  bool v1;
  unsigned int v2:9;
  double v3;
};
//SIG(1 B_BFu9i_D) C1{ Fc Fi:9 FL}



static void Test_B_BFu9i_D()
{
  {
    init_simple_test("B_BFu9i_D");
    static B_BFu9i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu9i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_D)");
    check_field_offset(lv, v1, 0, "B_BFu9i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu9i_D.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_D(Test_B_BFu9i_D, "B_BFu9i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_F  {
  bool v1;
  unsigned int v2:9;
  float v3;
};
//SIG(1 B_BFu9i_F) C1{ Fc Fi:9 Fi}



static void Test_B_BFu9i_F()
{
  {
    init_simple_test("B_BFu9i_F");
    static B_BFu9i_F lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_F)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_F)");
    check_field_offset(lv, v1, 0, "B_BFu9i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_F");
    check_field_offset(lv, v3, 4, "B_BFu9i_F.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_F(Test_B_BFu9i_F, "B_BFu9i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_I  {
  bool v1;
  unsigned int v2:9;
  int v3;
};
//SIG(1 B_BFu9i_I) C1{ Fc Fi:9 Fi}



static void Test_B_BFu9i_I()
{
  {
    init_simple_test("B_BFu9i_I");
    static B_BFu9i_I lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_I)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_I)");
    check_field_offset(lv, v1, 0, "B_BFu9i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_I");
    check_field_offset(lv, v3, 4, "B_BFu9i_I.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_I(Test_B_BFu9i_I, "B_BFu9i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_Ip  {
  bool v1;
  unsigned int v2:9;
  int *v3;
};
//SIG(1 B_BFu9i_Ip) C1{ Fc Fi:9 Fp}



static void Test_B_BFu9i_Ip()
{
  {
    init_simple_test("B_BFu9i_Ip");
    static B_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu9i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "B_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu9i_Ip.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_Ip(Test_B_BFu9i_Ip, "B_BFu9i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_L  {
  bool v1;
  unsigned int v2:9;
  __tsi64 v3;
};
//SIG(1 B_BFu9i_L) C1{ Fc Fi:9 FL}



static void Test_B_BFu9i_L()
{
  {
    init_simple_test("B_BFu9i_L");
    static B_BFu9i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu9i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_L)");
    check_field_offset(lv, v1, 0, "B_BFu9i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu9i_L.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_L(Test_B_BFu9i_L, "B_BFu9i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_S  {
  bool v1;
  unsigned int v2:9;
  short v3;
};
//SIG(1 B_BFu9i_S) C1{ Fc Fi:9 Fs}



static void Test_B_BFu9i_S()
{
  {
    init_simple_test("B_BFu9i_S");
    static B_BFu9i_S lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_S)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_S)");
    check_field_offset(lv, v1, 0, "B_BFu9i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_S");
    check_field_offset(lv, v3, 4, "B_BFu9i_S.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_S(Test_B_BFu9i_S, "B_BFu9i_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_Uc  {
  bool v1;
  unsigned int v2:9;
  unsigned char v3;
};
//SIG(1 B_BFu9i_Uc) C1{ Fc Fi:9 Fc}



static void Test_B_BFu9i_Uc()
{
  {
    init_simple_test("B_BFu9i_Uc");
    static B_BFu9i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(B_BFu9i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "B_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_Uc");
    check_field_offset(lv, v3, 3, "B_BFu9i_Uc.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_Uc(Test_B_BFu9i_Uc, "B_BFu9i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_Ui  {
  bool v1;
  unsigned int v2:9;
  unsigned int v3;
};
//SIG(1 B_BFu9i_Ui) C1{ Fc Fi:9 Fi}



static void Test_B_BFu9i_Ui()
{
  {
    init_simple_test("B_BFu9i_Ui");
    static B_BFu9i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "B_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_Ui");
    check_field_offset(lv, v3, 4, "B_BFu9i_Ui.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_Ui(Test_B_BFu9i_Ui, "B_BFu9i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_Ul  {
  bool v1;
  unsigned int v2:9;
  __tsu64 v3;
};
//SIG(1 B_BFu9i_Ul) C1{ Fc Fi:9 FL}



static void Test_B_BFu9i_Ul()
{
  {
    init_simple_test("B_BFu9i_Ul");
    static B_BFu9i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(B_BFu9i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "B_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu9i_Ul.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_Ul(Test_B_BFu9i_Ul, "B_BFu9i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_Us  {
  bool v1;
  unsigned int v2:9;
  unsigned short v3;
};
//SIG(1 B_BFu9i_Us) C1{ Fc Fi:9 Fs}



static void Test_B_BFu9i_Us()
{
  {
    init_simple_test("B_BFu9i_Us");
    static B_BFu9i_Us lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(B_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "B_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_Us");
    check_field_offset(lv, v3, 4, "B_BFu9i_Us.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_Us(Test_B_BFu9i_Us, "B_BFu9i_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9i_Vp  {
  bool v1;
  unsigned int v2:9;
  void *v3;
};
//SIG(1 B_BFu9i_Vp) C1{ Fc Fi:9 Fp}



static void Test_B_BFu9i_Vp()
{
  {
    init_simple_test("B_BFu9i_Vp");
    static B_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(B_BFu9i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "B_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "B_BFu9i_Vp.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9i_Vp(Test_B_BFu9i_Vp, "B_BFu9i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll  {
  bool v1;
  __tsu64 v2:9;
};
//SIG(1 B_BFu9ll) C1{ Fc FL:9}



static void Test_B_BFu9ll()
{
  {
    init_simple_test("B_BFu9ll");
    static B_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll(Test_B_BFu9ll, "B_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_B  {
  bool v1;
  __tsu64 v2:9;
  bool v3;
};
//SIG(1 B_BFu9ll_B) C1{ Fc FL:9 Fc}



static void Test_B_BFu9ll_B()
{
  {
    init_simple_test("B_BFu9ll_B");
    static B_BFu9ll_B lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu9ll_B)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_B)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_B.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_B");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_B");
    check_field_offset(lv, v3, 3, "B_BFu9ll_B.v3");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_B(Test_B_BFu9ll_B, "B_BFu9ll_B", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu15i  {
  bool v1;
  __tsu64 v2:9;
  unsigned int v3:15;
};
//SIG(1 B_BFu9ll_BFu15i) C1{ Fc FL:9 Fi:15}



static void Test_B_BFu9ll_BFu15i()
{
  {
    init_simple_test("B_BFu9ll_BFu15i");
    static B_BFu9ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu9ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9ll_BFu15i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu15i(Test_B_BFu9ll_BFu15i, "B_BFu9ll_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu15ll  {
  bool v1;
  __tsu64 v2:9;
  __tsu64 v3:15;
};
//SIG(1 B_BFu9ll_BFu15ll) C1{ Fc FL:9 FL:15}



static void Test_B_BFu9ll_BFu15ll()
{
  {
    init_simple_test("B_BFu9ll_BFu15ll");
    static B_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu15ll(Test_B_BFu9ll_BFu15ll, "B_BFu9ll_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu15s  {
  bool v1;
  __tsu64 v2:9;
  unsigned short v3:15;
};
//SIG(1 B_BFu9ll_BFu15s) C1{ Fc FL:9 Fs:15}



static void Test_B_BFu9ll_BFu15s()
{
  {
    init_simple_test("B_BFu9ll_BFu15s");
    static B_BFu9ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu9ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "B_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "B_BFu9ll_BFu15s");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu15s(Test_B_BFu9ll_BFu15s, "B_BFu9ll_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu16i  {
  bool v1;
  __tsu64 v2:9;
  unsigned int v3:16;
};
//SIG(1 B_BFu9ll_BFu16i) C1{ Fc FL:9 Fi:16}



static void Test_B_BFu9ll_BFu16i()
{
  {
    init_simple_test("B_BFu9ll_BFu16i");
    static B_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu9ll_BFu16i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu16i(Test_B_BFu9ll_BFu16i, "B_BFu9ll_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu16ll  {
  bool v1;
  __tsu64 v2:9;
  __tsu64 v3:16;
};
//SIG(1 B_BFu9ll_BFu16ll) C1{ Fc FL:9 FL:16}



static void Test_B_BFu9ll_BFu16ll()
{
  {
    init_simple_test("B_BFu9ll_BFu16ll");
    static B_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "B_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "B_BFu9ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu16ll(Test_B_BFu9ll_BFu16ll, "B_BFu9ll_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu16s  {
  bool v1;
  __tsu64 v2:9;
  unsigned short v3:16;
};
//SIG(1 B_BFu9ll_BFu16s) C1{ Fc FL:9 Fs:16}



static void Test_B_BFu9ll_BFu16s()
{
  {
    init_simple_test("B_BFu9ll_BFu16s");
    static B_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "B_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "B_BFu9ll_BFu16s");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu16s(Test_B_BFu9ll_BFu16s, "B_BFu9ll_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu17i  {
  bool v1;
  __tsu64 v2:9;
  unsigned int v3:17;
};
//SIG(1 B_BFu9ll_BFu17i) C1{ Fc FL:9 Fi:17}



static void Test_B_BFu9ll_BFu17i()
{
  {
    init_simple_test("B_BFu9ll_BFu17i");
    static B_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "B_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "B_BFu9ll_BFu17i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu17i(Test_B_BFu9ll_BFu17i, "B_BFu9ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu17ll  {
  bool v1;
  __tsu64 v2:9;
  __tsu64 v3:17;
};
//SIG(1 B_BFu9ll_BFu17ll) C1{ Fc FL:9 FL:17}



static void Test_B_BFu9ll_BFu17ll()
{
  {
    init_simple_test("B_BFu9ll_BFu17ll");
    static B_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "B_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "B_BFu9ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu17ll(Test_B_BFu9ll_BFu17ll, "B_BFu9ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu1c  {
  bool v1;
  __tsu64 v2:9;
  unsigned char v3:1;
};
//SIG(1 B_BFu9ll_BFu1c) C1{ Fc FL:9 Fc:1}



static void Test_B_BFu9ll_BFu1c()
{
  {
    init_simple_test("B_BFu9ll_BFu1c");
    static B_BFu9ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu9ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9ll_BFu1c");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu1c(Test_B_BFu9ll_BFu1c, "B_BFu9ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu1i  {
  bool v1;
  __tsu64 v2:9;
  unsigned int v3:1;
};
//SIG(1 B_BFu9ll_BFu1i) C1{ Fc FL:9 Fi:1}



static void Test_B_BFu9ll_BFu1i()
{
  {
    init_simple_test("B_BFu9ll_BFu1i");
    static B_BFu9ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu9ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9ll_BFu1i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu1i(Test_B_BFu9ll_BFu1i, "B_BFu9ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu1ll  {
  bool v1;
  __tsu64 v2:9;
  __tsu64 v3:1;
};
//SIG(1 B_BFu9ll_BFu1ll) C1{ Fc FL:9 FL:1}



static void Test_B_BFu9ll_BFu1ll()
{
  {
    init_simple_test("B_BFu9ll_BFu1ll");
    static B_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu1ll(Test_B_BFu9ll_BFu1ll, "B_BFu9ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu1s  {
  bool v1;
  __tsu64 v2:9;
  unsigned short v3:1;
};
//SIG(1 B_BFu9ll_BFu1s) C1{ Fc FL:9 Fs:1}



static void Test_B_BFu9ll_BFu1s()
{
  {
    init_simple_test("B_BFu9ll_BFu1s");
    static B_BFu9ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(B_BFu9ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "B_BFu9ll_BFu1s");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu1s(Test_B_BFu9ll_BFu1s, "B_BFu9ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu31i  {
  bool v1;
  __tsu64 v2:9;
  unsigned int v3:31;
};
//SIG(1 B_BFu9ll_BFu31i) C1{ Fc FL:9 Fi:31}



static void Test_B_BFu9ll_BFu31i()
{
  {
    init_simple_test("B_BFu9ll_BFu31i");
    static B_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "B_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "B_BFu9ll_BFu31i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu31i(Test_B_BFu9ll_BFu31i, "B_BFu9ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu31ll  {
  bool v1;
  __tsu64 v2:9;
  __tsu64 v3:31;
};
//SIG(1 B_BFu9ll_BFu31ll) C1{ Fc FL:9 FL:31}



static void Test_B_BFu9ll_BFu31ll()
{
  {
    init_simple_test("B_BFu9ll_BFu31ll");
    static B_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "B_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "B_BFu9ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu31ll(Test_B_BFu9ll_BFu31ll, "B_BFu9ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu32i  {
  bool v1;
  __tsu64 v2:9;
  unsigned int v3:32;
};
//SIG(1 B_BFu9ll_BFu32i) C1{ Fc FL:9 Fi:32}



static void Test_B_BFu9ll_BFu32i()
{
  {
    init_simple_test("B_BFu9ll_BFu32i");
    static B_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "B_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "B_BFu9ll_BFu32i");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu32i(Test_B_BFu9ll_BFu32i, "B_BFu9ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu32ll  {
  bool v1;
  __tsu64 v2:9;
  __tsu64 v3:32;
};
//SIG(1 B_BFu9ll_BFu32ll) C1{ Fc FL:9 FL:32}



static void Test_B_BFu9ll_BFu32ll()
{
  {
    init_simple_test("B_BFu9ll_BFu32ll");
    static B_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "B_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "B_BFu9ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu32ll(Test_B_BFu9ll_BFu32ll, "B_BFu9ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu33  {
  bool v1;
  __tsu64 v2:9;
  __tsu64 v3:33;
};
//SIG(1 B_BFu9ll_BFu33) C1{ Fc FL:9 FL:33}



static void Test_B_BFu9ll_BFu33()
{
  {
    init_simple_test("B_BFu9ll_BFu33");
    static B_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(B_BFu9ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(B_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "B_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "B_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "B_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "B_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "B_BFu9ll_BFu33");
  }
}
static Arrange_To_Call_Me vB_BFu9ll_BFu33(Test_B_BFu9ll_BFu33, "B_BFu9ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  B_BFu9ll_BFu7c  {
  bool v1;
  __tsu64 v2:9;
  unsigned char v3:7;
};
//SIG(1 B_BFu9ll_BFu7c) C1{ Fc FL:9 Fc:7}



static void Test_B_BFu9ll_BFu7c()
{
  {
    init_simple_test("B_BFu9ll_BFu7c");
    static B_BFu9ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4)