// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  STT010  {
  char fa;
  unsigned char  :0;
  char fb;
};
//SIG(1 STT010) C1{ Fc Fc:0 Fc}



static void Test_STT010()
{
  {
    init_simple_test("STT010");
    static STT010 lv;
    check2(sizeof(lv), 2, "sizeof(STT010)");
    check2(__alignof__(lv), 1, "__alignof__(STT010)");
    check_field_offset(lv, fa, 0, "STT010.fa");
    check_field_offset(lv, fb, 1, "STT010.fb");
  }
}
static Arrange_To_Call_Me vSTT010(Test_STT010, "STT010", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT020  {
  char fa;
  unsigned short  :0;
  char fb;
};
//SIG(1 STT020) C1{ Fc Fs:0 Fc}



static void Test_STT020()
{
  {
    init_simple_test("STT020");
    static STT020 lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(STT020)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT020)");
    check_field_offset(lv, fa, 0, "STT020.fa");
    check_field_offset(lv, fb, 2, "STT020.fb");
  }
}
static Arrange_To_Call_Me vSTT020(Test_STT020, "STT020", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT030  {
  char fa;
  unsigned int  :0;
  char fb;
};
//SIG(1 STT030) C1{ Fc Fi:0 Fc}



static void Test_STT030()
{
  {
    init_simple_test("STT030");
    static STT030 lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(STT030)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT030)");
    check_field_offset(lv, fa, 0, "STT030.fa");
    check_field_offset(lv, fb, 4, "STT030.fb");
  }
}
static Arrange_To_Call_Me vSTT030(Test_STT030, "STT030", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT040  {
  char fa;
  __tsu64  :0;
  char fb;
};
//SIG(1 STT040) C1{ Fc FL:0 Fc}



static void Test_STT040()
{
  {
    init_simple_test("STT040");
    static STT040 lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(STT040)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT040)");
    check_field_offset(lv, fa, 0, "STT040.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT040.fb");
  }
}
static Arrange_To_Call_Me vSTT040(Test_STT040, "STT040", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT050  {
  char fa;
  unsigned char  :3;
  char fb;
};
//SIG(1 STT050) C1{ Fc Fc:3 Fc}



static void Test_STT050()
{
  {
    init_simple_test("STT050");
    static STT050 lv;
    check2(sizeof(lv), 3, "sizeof(STT050)");
    check2(__alignof__(lv), 1, "__alignof__(STT050)");
    check_field_offset(lv, fa, 0, "STT050.fa");
    check_field_offset(lv, fb, 2, "STT050.fb");
  }
}
static Arrange_To_Call_Me vSTT050(Test_STT050, "STT050", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT060  {
  char fa;
  unsigned short  :3;
  char fb;
};
//SIG(1 STT060) C1{ Fc Fs:3 Fc}



static void Test_STT060()
{
  {
    init_simple_test("STT060");
    static STT060 lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(STT060)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT060)");
    check_field_offset(lv, fa, 0, "STT060.fa");
    check_field_offset(lv, fb, 2, "STT060.fb");
  }
}
static Arrange_To_Call_Me vSTT060(Test_STT060, "STT060", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT070  {
  char fa;
  unsigned int  :3;
  char fb;
};
//SIG(1 STT070) C1{ Fc Fi:3 Fc}



static void Test_STT070()
{
  {
    init_simple_test("STT070");
    static STT070 lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(STT070)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT070)");
    check_field_offset(lv, fa, 0, "STT070.fa");
    check_field_offset(lv, fb, 2, "STT070.fb");
  }
}
static Arrange_To_Call_Me vSTT070(Test_STT070, "STT070", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT080  {
  char fa;
  __tsu64  :3;
  char fb;
};
//SIG(1 STT080) C1{ Fc FL:3 Fc}



static void Test_STT080()
{
  {
    init_simple_test("STT080");
    static STT080 lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(STT080)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT080)");
    check_field_offset(lv, fa, 0, "STT080.fa");
    check_field_offset(lv, fb, 2, "STT080.fb");
  }
}
static Arrange_To_Call_Me vSTT080(Test_STT080, "STT080", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT090  {
  char fa;
  unsigned short  :8;
  char fb;
};
//SIG(1 STT090) C1{ Fc Fs:8 Fc}



static void Test_STT090()
{
  {
    init_simple_test("STT090");
    static STT090 lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(STT090)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT090)");
    check_field_offset(lv, fa, 0, "STT090.fa");
    check_field_offset(lv, fb, 2, "STT090.fb");
  }
}
static Arrange_To_Call_Me vSTT090(Test_STT090, "STT090", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0100  {
  char fa;
  unsigned int  :8;
  char fb;
};
//SIG(1 STT0100) C1{ Fc Fi:8 Fc}



static void Test_STT0100()
{
  {
    init_simple_test("STT0100");
    static STT0100 lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(STT0100)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0100)");
    check_field_offset(lv, fa, 0, "STT0100.fa");
    check_field_offset(lv, fb, 2, "STT0100.fb");
  }
}
static Arrange_To_Call_Me vSTT0100(Test_STT0100, "STT0100", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0110  {
  char fa;
  __tsu64  :8;
  char fb;
};
//SIG(1 STT0110) C1{ Fc FL:8 Fc}



static void Test_STT0110()
{
  {
    init_simple_test("STT0110");
    static STT0110 lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(STT0110)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0110)");
    check_field_offset(lv, fa, 0, "STT0110.fa");
    check_field_offset(lv, fb, 2, "STT0110.fb");
  }
}
static Arrange_To_Call_Me vSTT0110(Test_STT0110, "STT0110", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0120  {
  char fa;
  unsigned int  :18;
  char fb;
};
//SIG(1 STT0120) C1{ Fc Fi:18 Fc}



static void Test_STT0120()
{
  {
    init_simple_test("STT0120");
    static STT0120 lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(STT0120)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0120)");
    check_field_offset(lv, fa, 0, "STT0120.fa");
    check_field_offset(lv, fb, 4, "STT0120.fb");
  }
}
static Arrange_To_Call_Me vSTT0120(Test_STT0120, "STT0120", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0130  {
  char fa;
  __tsu64  :18;
  char fb;
};
//SIG(1 STT0130) C1{ Fc FL:18 Fc}



static void Test_STT0130()
{
  {
    init_simple_test("STT0130");
    static STT0130 lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(STT0130)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0130)");
    check_field_offset(lv, fa, 0, "STT0130.fa");
    check_field_offset(lv, fb, 4, "STT0130.fb");
  }
}
static Arrange_To_Call_Me vSTT0130(Test_STT0130, "STT0130", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0140  {
  char fa;
  __tsu64  :48;
  char fb;
};
//SIG(1 STT0140) C1{ Fc FL:48 Fc}



static void Test_STT0140()
{
  {
    init_simple_test("STT0140");
    static STT0140 lv;
    check2(sizeof(lv), 8, "sizeof(STT0140)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0140)");
    check_field_offset(lv, fa, 0, "STT0140.fa");
    check_field_offset(lv, fb, 7, "STT0140.fb");
  }
}
static Arrange_To_Call_Me vSTT0140(Test_STT0140, "STT0140", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0150  {
  char fa;
  unsigned char bf:3;
  char fb;
};
//SIG(1 STT0150) C1{ Fc Fc:3 Fc}



static void Test_STT0150()
{
  {
    init_simple_test("STT0150");
    static STT0150 lv;
    check2(sizeof(lv), 3, "sizeof(STT0150)");
    check2(__alignof__(lv), 1, "__alignof__(STT0150)");
    check_field_offset(lv, fa, 0, "STT0150.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0150");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0150");
    check_field_offset(lv, fb, 2, "STT0150.fb");
  }
}
static Arrange_To_Call_Me vSTT0150(Test_STT0150, "STT0150", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0160  {
  char fa;
  unsigned short bf:3;
  char fb;
};
//SIG(1 STT0160) C1{ Fc Fs:3 Fc}



static void Test_STT0160()
{
  {
    init_simple_test("STT0160");
    static STT0160 lv;
    check2(sizeof(lv), 4, "sizeof(STT0160)");
    check2(__alignof__(lv), 2, "__alignof__(STT0160)");
    check_field_offset(lv, fa, 0, "STT0160.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0160");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0160");
    check_field_offset(lv, fb, 2, "STT0160.fb");
  }
}
static Arrange_To_Call_Me vSTT0160(Test_STT0160, "STT0160", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0170  {
  char fa;
  unsigned int bf:3;
  char fb;
};
//SIG(1 STT0170) C1{ Fc Fi:3 Fc}



static void Test_STT0170()
{
  {
    init_simple_test("STT0170");
    static STT0170 lv;
    check2(sizeof(lv), 4, "sizeof(STT0170)");
    check2(__alignof__(lv), 4, "__alignof__(STT0170)");
    check_field_offset(lv, fa, 0, "STT0170.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0170");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0170");
    check_field_offset(lv, fb, 2, "STT0170.fb");
  }
}
static Arrange_To_Call_Me vSTT0170(Test_STT0170, "STT0170", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0180  {
  char fa;
  __tsu64 bf:3;
  char fb;
};
//SIG(1 STT0180) C1{ Fc FL:3 Fc}



static void Test_STT0180()
{
  {
    init_simple_test("STT0180");
    static STT0180 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT0180)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0180)");
    check_field_offset(lv, fa, 0, "STT0180.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0180");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0180");
    check_field_offset(lv, fb, 2, "STT0180.fb");
  }
}
static Arrange_To_Call_Me vSTT0180(Test_STT0180, "STT0180", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0190  {
  char fa;
  unsigned short bf:8;
  char fb;
};
//SIG(1 STT0190) C1{ Fc Fs:8 Fc}



static void Test_STT0190()
{
  {
    init_simple_test("STT0190");
    static STT0190 lv;
    check2(sizeof(lv), 4, "sizeof(STT0190)");
    check2(__alignof__(lv), 2, "__alignof__(STT0190)");
    check_field_offset(lv, fa, 0, "STT0190.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0190");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0190");
    check_field_offset(lv, fb, 2, "STT0190.fb");
  }
}
static Arrange_To_Call_Me vSTT0190(Test_STT0190, "STT0190", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0200  {
  char fa;
  unsigned int bf:8;
  char fb;
};
//SIG(1 STT0200) C1{ Fc Fi:8 Fc}



static void Test_STT0200()
{
  {
    init_simple_test("STT0200");
    static STT0200 lv;
    check2(sizeof(lv), 4, "sizeof(STT0200)");
    check2(__alignof__(lv), 4, "__alignof__(STT0200)");
    check_field_offset(lv, fa, 0, "STT0200.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0200");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0200");
    check_field_offset(lv, fb, 2, "STT0200.fb");
  }
}
static Arrange_To_Call_Me vSTT0200(Test_STT0200, "STT0200", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0210  {
  char fa;
  __tsu64 bf:8;
  char fb;
};
//SIG(1 STT0210) C1{ Fc FL:8 Fc}



static void Test_STT0210()
{
  {
    init_simple_test("STT0210");
    static STT0210 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT0210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0210)");
    check_field_offset(lv, fa, 0, "STT0210.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0210");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0210");
    check_field_offset(lv, fb, 2, "STT0210.fb");
  }
}
static Arrange_To_Call_Me vSTT0210(Test_STT0210, "STT0210", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0220  {
  char fa;
  unsigned int bf:18;
  char fb;
};
//SIG(1 STT0220) C1{ Fc Fi:18 Fc}



static void Test_STT0220()
{
  {
    init_simple_test("STT0220");
    static STT0220 lv;
    check2(sizeof(lv), 8, "sizeof(STT0220)");
    check2(__alignof__(lv), 4, "__alignof__(STT0220)");
    check_field_offset(lv, fa, 0, "STT0220.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0220");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0220");
    check_field_offset(lv, fb, 4, "STT0220.fb");
  }
}
static Arrange_To_Call_Me vSTT0220(Test_STT0220, "STT0220", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0230  {
  char fa;
  __tsu64 bf:18;
  char fb;
};
//SIG(1 STT0230) C1{ Fc FL:18 Fc}



static void Test_STT0230()
{
  {
    init_simple_test("STT0230");
    static STT0230 lv;
    check2(sizeof(lv), 8, "sizeof(STT0230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0230)");
    check_field_offset(lv, fa, 0, "STT0230.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0230");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0230");
    check_field_offset(lv, fb, 4, "STT0230.fb");
  }
}
static Arrange_To_Call_Me vSTT0230(Test_STT0230, "STT0230", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0240  {
  char fa;
  __tsu64 bf:48;
  char fb;
};
//SIG(1 STT0240) C1{ Fc FL:48 Fc}



static void Test_STT0240()
{
  {
    init_simple_test("STT0240");
    static STT0240 lv;
    check2(sizeof(lv), 8, "sizeof(STT0240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0240)");
    check_field_offset(lv, fa, 0, "STT0240.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0240");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0240");
    check_field_offset(lv, fb, 7, "STT0240.fb");
  }
}
static Arrange_To_Call_Me vSTT0240(Test_STT0240, "STT0240", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT011  {
  char fa;
  unsigned char  :0;
  short fb;
};
//SIG(1 STT011) C1{ Fc Fc:0 Fs}



static void Test_STT011()
{
  {
    init_simple_test("STT011");
    static STT011 lv;
    check2(sizeof(lv), 4, "sizeof(STT011)");
    check2(__alignof__(lv), 2, "__alignof__(STT011)");
    check_field_offset(lv, fa, 0, "STT011.fa");
    check_field_offset(lv, fb, 2, "STT011.fb");
  }
}
static Arrange_To_Call_Me vSTT011(Test_STT011, "STT011", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT021  {
  char fa;
  unsigned short  :0;
  short fb;
};
//SIG(1 STT021) C1{ Fc Fs:0 Fs}



static void Test_STT021()
{
  {
    init_simple_test("STT021");
    static STT021 lv;
    check2(sizeof(lv), 4, "sizeof(STT021)");
    check2(__alignof__(lv), 2, "__alignof__(STT021)");
    check_field_offset(lv, fa, 0, "STT021.fa");
    check_field_offset(lv, fb, 2, "STT021.fb");
  }
}
static Arrange_To_Call_Me vSTT021(Test_STT021, "STT021", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT031  {
  char fa;
  unsigned int  :0;
  short fb;
};
//SIG(1 STT031) C1{ Fc Fi:0 Fs}



static void Test_STT031()
{
  {
    init_simple_test("STT031");
    static STT031 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT031)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT031)");
    check_field_offset(lv, fa, 0, "STT031.fa");
    check_field_offset(lv, fb, 4, "STT031.fb");
  }
}
static Arrange_To_Call_Me vSTT031(Test_STT031, "STT031", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT041  {
  char fa;
  __tsu64  :0;
  short fb;
};
//SIG(1 STT041) C1{ Fc FL:0 Fs}



static void Test_STT041()
{
  {
    init_simple_test("STT041");
    static STT041 lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(STT041)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT041)");
    check_field_offset(lv, fa, 0, "STT041.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT041.fb");
  }
}
static Arrange_To_Call_Me vSTT041(Test_STT041, "STT041", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT051  {
  char fa;
  unsigned char  :3;
  short fb;
};
//SIG(1 STT051) C1{ Fc Fc:3 Fs}



static void Test_STT051()
{
  {
    init_simple_test("STT051");
    static STT051 lv;
    check2(sizeof(lv), 4, "sizeof(STT051)");
    check2(__alignof__(lv), 2, "__alignof__(STT051)");
    check_field_offset(lv, fa, 0, "STT051.fa");
    check_field_offset(lv, fb, 2, "STT051.fb");
  }
}
static Arrange_To_Call_Me vSTT051(Test_STT051, "STT051", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT061  {
  char fa;
  unsigned short  :3;
  short fb;
};
//SIG(1 STT061) C1{ Fc Fs:3 Fs}



static void Test_STT061()
{
  {
    init_simple_test("STT061");
    static STT061 lv;
    check2(sizeof(lv), 4, "sizeof(STT061)");
    check2(__alignof__(lv), 2, "__alignof__(STT061)");
    check_field_offset(lv, fa, 0, "STT061.fa");
    check_field_offset(lv, fb, 2, "STT061.fb");
  }
}
static Arrange_To_Call_Me vSTT061(Test_STT061, "STT061", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT071  {
  char fa;
  unsigned int  :3;
  short fb;
};
//SIG(1 STT071) C1{ Fc Fi:3 Fs}



static void Test_STT071()
{
  {
    init_simple_test("STT071");
    static STT071 lv;
    check2(sizeof(lv), 4, "sizeof(STT071)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT071)");
    check_field_offset(lv, fa, 0, "STT071.fa");
    check_field_offset(lv, fb, 2, "STT071.fb");
  }
}
static Arrange_To_Call_Me vSTT071(Test_STT071, "STT071", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT081  {
  char fa;
  __tsu64  :3;
  short fb;
};
//SIG(1 STT081) C1{ Fc FL:3 Fs}



static void Test_STT081()
{
  {
    init_simple_test("STT081");
    static STT081 lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(STT081)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT081)");
    check_field_offset(lv, fa, 0, "STT081.fa");
    check_field_offset(lv, fb, 2, "STT081.fb");
  }
}
static Arrange_To_Call_Me vSTT081(Test_STT081, "STT081", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT091  {
  char fa;
  unsigned short  :8;
  short fb;
};
//SIG(1 STT091) C1{ Fc Fs:8 Fs}



static void Test_STT091()
{
  {
    init_simple_test("STT091");
    static STT091 lv;
    check2(sizeof(lv), 4, "sizeof(STT091)");
    check2(__alignof__(lv), 2, "__alignof__(STT091)");
    check_field_offset(lv, fa, 0, "STT091.fa");
    check_field_offset(lv, fb, 2, "STT091.fb");
  }
}
static Arrange_To_Call_Me vSTT091(Test_STT091, "STT091", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0101  {
  char fa;
  unsigned int  :8;
  short fb;
};
//SIG(1 STT0101) C1{ Fc Fi:8 Fs}



static void Test_STT0101()
{
  {
    init_simple_test("STT0101");
    static STT0101 lv;
    check2(sizeof(lv), 4, "sizeof(STT0101)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT0101)");
    check_field_offset(lv, fa, 0, "STT0101.fa");
    check_field_offset(lv, fb, 2, "STT0101.fb");
  }
}
static Arrange_To_Call_Me vSTT0101(Test_STT0101, "STT0101", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0111  {
  char fa;
  __tsu64  :8;
  short fb;
};
//SIG(1 STT0111) C1{ Fc FL:8 Fs}



static void Test_STT0111()
{
  {
    init_simple_test("STT0111");
    static STT0111 lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(STT0111)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT0111)");
    check_field_offset(lv, fa, 0, "STT0111.fa");
    check_field_offset(lv, fb, 2, "STT0111.fb");
  }
}
static Arrange_To_Call_Me vSTT0111(Test_STT0111, "STT0111", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0121  {
  char fa;
  unsigned int  :18;
  short fb;
};
//SIG(1 STT0121) C1{ Fc Fi:18 Fs}



static void Test_STT0121()
{
  {
    init_simple_test("STT0121");
    static STT0121 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT0121)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT0121)");
    check_field_offset(lv, fa, 0, "STT0121.fa");
    check_field_offset(lv, fb, 4, "STT0121.fb");
  }
}
static Arrange_To_Call_Me vSTT0121(Test_STT0121, "STT0121", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0131  {
  char fa;
  __tsu64  :18;
  short fb;
};
//SIG(1 STT0131) C1{ Fc FL:18 Fs}



static void Test_STT0131()
{
  {
    init_simple_test("STT0131");
    static STT0131 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT0131)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT0131)");
    check_field_offset(lv, fa, 0, "STT0131.fa");
    check_field_offset(lv, fb, 4, "STT0131.fb");
  }
}
static Arrange_To_Call_Me vSTT0131(Test_STT0131, "STT0131", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0141  {
  char fa;
  __tsu64  :48;
  short fb;
};
//SIG(1 STT0141) C1{ Fc FL:48 Fs}



static void Test_STT0141()
{
  {
    init_simple_test("STT0141");
    static STT0141 lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(STT0141)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT0141)");
    check_field_offset(lv, fa, 0, "STT0141.fa");
    check_field_offset(lv, fb, 8, "STT0141.fb");
  }
}
static Arrange_To_Call_Me vSTT0141(Test_STT0141, "STT0141", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0151  {
  char fa;
  unsigned char bf:3;
  short fb;
};
//SIG(1 STT0151) C1{ Fc Fc:3 Fs}



static void Test_STT0151()
{
  {
    init_simple_test("STT0151");
    static STT0151 lv;
    check2(sizeof(lv), 4, "sizeof(STT0151)");
    check2(__alignof__(lv), 2, "__alignof__(STT0151)");
    check_field_offset(lv, fa, 0, "STT0151.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0151");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0151");
    check_field_offset(lv, fb, 2, "STT0151.fb");
  }
}
static Arrange_To_Call_Me vSTT0151(Test_STT0151, "STT0151", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0161  {
  char fa;
  unsigned short bf:3;
  short fb;
};
//SIG(1 STT0161) C1{ Fc Fs:3 Fs}



static void Test_STT0161()
{
  {
    init_simple_test("STT0161");
    static STT0161 lv;
    check2(sizeof(lv), 4, "sizeof(STT0161)");
    check2(__alignof__(lv), 2, "__alignof__(STT0161)");
    check_field_offset(lv, fa, 0, "STT0161.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0161");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0161");
    check_field_offset(lv, fb, 2, "STT0161.fb");
  }
}
static Arrange_To_Call_Me vSTT0161(Test_STT0161, "STT0161", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0171  {
  char fa;
  unsigned int bf:3;
  short fb;
};
//SIG(1 STT0171) C1{ Fc Fi:3 Fs}



static void Test_STT0171()
{
  {
    init_simple_test("STT0171");
    static STT0171 lv;
    check2(sizeof(lv), 4, "sizeof(STT0171)");
    check2(__alignof__(lv), 4, "__alignof__(STT0171)");
    check_field_offset(lv, fa, 0, "STT0171.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0171");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0171");
    check_field_offset(lv, fb, 2, "STT0171.fb");
  }
}
static Arrange_To_Call_Me vSTT0171(Test_STT0171, "STT0171", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0181  {
  char fa;
  __tsu64 bf:3;
  short fb;
};
//SIG(1 STT0181) C1{ Fc FL:3 Fs}



static void Test_STT0181()
{
  {
    init_simple_test("STT0181");
    static STT0181 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT0181)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0181)");
    check_field_offset(lv, fa, 0, "STT0181.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0181");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0181");
    check_field_offset(lv, fb, 2, "STT0181.fb");
  }
}
static Arrange_To_Call_Me vSTT0181(Test_STT0181, "STT0181", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0191  {
  char fa;
  unsigned short bf:8;
  short fb;
};
//SIG(1 STT0191) C1{ Fc Fs:8 Fs}



static void Test_STT0191()
{
  {
    init_simple_test("STT0191");
    static STT0191 lv;
    check2(sizeof(lv), 4, "sizeof(STT0191)");
    check2(__alignof__(lv), 2, "__alignof__(STT0191)");
    check_field_offset(lv, fa, 0, "STT0191.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0191");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0191");
    check_field_offset(lv, fb, 2, "STT0191.fb");
  }
}
static Arrange_To_Call_Me vSTT0191(Test_STT0191, "STT0191", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0201  {
  char fa;
  unsigned int bf:8;
  short fb;
};
//SIG(1 STT0201) C1{ Fc Fi:8 Fs}



static void Test_STT0201()
{
  {
    init_simple_test("STT0201");
    static STT0201 lv;
    check2(sizeof(lv), 4, "sizeof(STT0201)");
    check2(__alignof__(lv), 4, "__alignof__(STT0201)");
    check_field_offset(lv, fa, 0, "STT0201.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0201");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0201");
    check_field_offset(lv, fb, 2, "STT0201.fb");
  }
}
static Arrange_To_Call_Me vSTT0201(Test_STT0201, "STT0201", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0211  {
  char fa;
  __tsu64 bf:8;
  short fb;
};
//SIG(1 STT0211) C1{ Fc FL:8 Fs}



static void Test_STT0211()
{
  {
    init_simple_test("STT0211");
    static STT0211 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT0211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0211)");
    check_field_offset(lv, fa, 0, "STT0211.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0211");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0211");
    check_field_offset(lv, fb, 2, "STT0211.fb");
  }
}
static Arrange_To_Call_Me vSTT0211(Test_STT0211, "STT0211", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0221  {
  char fa;
  unsigned int bf:18;
  short fb;
};
//SIG(1 STT0221) C1{ Fc Fi:18 Fs}



static void Test_STT0221()
{
  {
    init_simple_test("STT0221");
    static STT0221 lv;
    check2(sizeof(lv), 8, "sizeof(STT0221)");
    check2(__alignof__(lv), 4, "__alignof__(STT0221)");
    check_field_offset(lv, fa, 0, "STT0221.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0221");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0221");
    check_field_offset(lv, fb, 4, "STT0221.fb");
  }
}
static Arrange_To_Call_Me vSTT0221(Test_STT0221, "STT0221", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0231  {
  char fa;
  __tsu64 bf:18;
  short fb;
};
//SIG(1 STT0231) C1{ Fc FL:18 Fs}



static void Test_STT0231()
{
  {
    init_simple_test("STT0231");
    static STT0231 lv;
    check2(sizeof(lv), 8, "sizeof(STT0231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0231)");
    check_field_offset(lv, fa, 0, "STT0231.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0231");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0231");
    check_field_offset(lv, fb, 4, "STT0231.fb");
  }
}
static Arrange_To_Call_Me vSTT0231(Test_STT0231, "STT0231", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0241  {
  char fa;
  __tsu64 bf:48;
  short fb;
};
//SIG(1 STT0241) C1{ Fc FL:48 Fs}



static void Test_STT0241()
{
  {
    init_simple_test("STT0241");
    static STT0241 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0241)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0241)");
    check_field_offset(lv, fa, 0, "STT0241.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0241");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0241");
    check_field_offset(lv, fb, 8, "STT0241.fb");
  }
}
static Arrange_To_Call_Me vSTT0241(Test_STT0241, "STT0241", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT012  {
  char fa;
  unsigned char  :0;
  int fb;
};
//SIG(1 STT012) C1{ Fc Fc:0 Fi}



static void Test_STT012()
{
  {
    init_simple_test("STT012");
    static STT012 lv;
    check2(sizeof(lv), 8, "sizeof(STT012)");
    check2(__alignof__(lv), 4, "__alignof__(STT012)");
    check_field_offset(lv, fa, 0, "STT012.fa");
    check_field_offset(lv, fb, 4, "STT012.fb");
  }
}
static Arrange_To_Call_Me vSTT012(Test_STT012, "STT012", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT022  {
  char fa;
  unsigned short  :0;
  int fb;
};
//SIG(1 STT022) C1{ Fc Fs:0 Fi}



static void Test_STT022()
{
  {
    init_simple_test("STT022");
    static STT022 lv;
    check2(sizeof(lv), 8, "sizeof(STT022)");
    check2(__alignof__(lv), 4, "__alignof__(STT022)");
    check_field_offset(lv, fa, 0, "STT022.fa");
    check_field_offset(lv, fb, 4, "STT022.fb");
  }
}
static Arrange_To_Call_Me vSTT022(Test_STT022, "STT022", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT032  {
  char fa;
  unsigned int  :0;
  int fb;
};
//SIG(1 STT032) C1{ Fc Fi:0 Fi}



static void Test_STT032()
{
  {
    init_simple_test("STT032");
    static STT032 lv;
    check2(sizeof(lv), 8, "sizeof(STT032)");
    check2(__alignof__(lv), 4, "__alignof__(STT032)");
    check_field_offset(lv, fa, 0, "STT032.fa");
    check_field_offset(lv, fb, 4, "STT032.fb");
  }
}
static Arrange_To_Call_Me vSTT032(Test_STT032, "STT032", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT042  {
  char fa;
  __tsu64  :0;
  int fb;
};
//SIG(1 STT042) C1{ Fc FL:0 Fi}



static void Test_STT042()
{
  {
    init_simple_test("STT042");
    static STT042 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT042)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT042)");
    check_field_offset(lv, fa, 0, "STT042.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT042.fb");
  }
}
static Arrange_To_Call_Me vSTT042(Test_STT042, "STT042", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT052  {
  char fa;
  unsigned char  :3;
  int fb;
};
//SIG(1 STT052) C1{ Fc Fc:3 Fi}



static void Test_STT052()
{
  {
    init_simple_test("STT052");
    static STT052 lv;
    check2(sizeof(lv), 8, "sizeof(STT052)");
    check2(__alignof__(lv), 4, "__alignof__(STT052)");
    check_field_offset(lv, fa, 0, "STT052.fa");
    check_field_offset(lv, fb, 4, "STT052.fb");
  }
}
static Arrange_To_Call_Me vSTT052(Test_STT052, "STT052", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT062  {
  char fa;
  unsigned short  :3;
  int fb;
};
//SIG(1 STT062) C1{ Fc Fs:3 Fi}



static void Test_STT062()
{
  {
    init_simple_test("STT062");
    static STT062 lv;
    check2(sizeof(lv), 8, "sizeof(STT062)");
    check2(__alignof__(lv), 4, "__alignof__(STT062)");
    check_field_offset(lv, fa, 0, "STT062.fa");
    check_field_offset(lv, fb, 4, "STT062.fb");
  }
}
static Arrange_To_Call_Me vSTT062(Test_STT062, "STT062", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT072  {
  char fa;
  unsigned int  :3;
  int fb;
};
//SIG(1 STT072) C1{ Fc Fi:3 Fi}



static void Test_STT072()
{
  {
    init_simple_test("STT072");
    static STT072 lv;
    check2(sizeof(lv), 8, "sizeof(STT072)");
    check2(__alignof__(lv), 4, "__alignof__(STT072)");
    check_field_offset(lv, fa, 0, "STT072.fa");
    check_field_offset(lv, fb, 4, "STT072.fb");
  }
}
static Arrange_To_Call_Me vSTT072(Test_STT072, "STT072", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT082  {
  char fa;
  __tsu64  :3;
  int fb;
};
//SIG(1 STT082) C1{ Fc FL:3 Fi}



static void Test_STT082()
{
  {
    init_simple_test("STT082");
    static STT082 lv;
    check2(sizeof(lv), 8, "sizeof(STT082)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT082)");
    check_field_offset(lv, fa, 0, "STT082.fa");
    check_field_offset(lv, fb, 4, "STT082.fb");
  }
}
static Arrange_To_Call_Me vSTT082(Test_STT082, "STT082", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT092  {
  char fa;
  unsigned short  :8;
  int fb;
};
//SIG(1 STT092) C1{ Fc Fs:8 Fi}



static void Test_STT092()
{
  {
    init_simple_test("STT092");
    static STT092 lv;
    check2(sizeof(lv), 8, "sizeof(STT092)");
    check2(__alignof__(lv), 4, "__alignof__(STT092)");
    check_field_offset(lv, fa, 0, "STT092.fa");
    check_field_offset(lv, fb, 4, "STT092.fb");
  }
}
static Arrange_To_Call_Me vSTT092(Test_STT092, "STT092", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0102  {
  char fa;
  unsigned int  :8;
  int fb;
};
//SIG(1 STT0102) C1{ Fc Fi:8 Fi}



static void Test_STT0102()
{
  {
    init_simple_test("STT0102");
    static STT0102 lv;
    check2(sizeof(lv), 8, "sizeof(STT0102)");
    check2(__alignof__(lv), 4, "__alignof__(STT0102)");
    check_field_offset(lv, fa, 0, "STT0102.fa");
    check_field_offset(lv, fb, 4, "STT0102.fb");
  }
}
static Arrange_To_Call_Me vSTT0102(Test_STT0102, "STT0102", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0112  {
  char fa;
  __tsu64  :8;
  int fb;
};
//SIG(1 STT0112) C1{ Fc FL:8 Fi}



static void Test_STT0112()
{
  {
    init_simple_test("STT0112");
    static STT0112 lv;
    check2(sizeof(lv), 8, "sizeof(STT0112)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT0112)");
    check_field_offset(lv, fa, 0, "STT0112.fa");
    check_field_offset(lv, fb, 4, "STT0112.fb");
  }
}
static Arrange_To_Call_Me vSTT0112(Test_STT0112, "STT0112", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0122  {
  char fa;
  unsigned int  :18;
  int fb;
};
//SIG(1 STT0122) C1{ Fc Fi:18 Fi}



static void Test_STT0122()
{
  {
    init_simple_test("STT0122");
    static STT0122 lv;
    check2(sizeof(lv), 8, "sizeof(STT0122)");
    check2(__alignof__(lv), 4, "__alignof__(STT0122)");
    check_field_offset(lv, fa, 0, "STT0122.fa");
    check_field_offset(lv, fb, 4, "STT0122.fb");
  }
}
static Arrange_To_Call_Me vSTT0122(Test_STT0122, "STT0122", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0132  {
  char fa;
  __tsu64  :18;
  int fb;
};
//SIG(1 STT0132) C1{ Fc FL:18 Fi}



static void Test_STT0132()
{
  {
    init_simple_test("STT0132");
    static STT0132 lv;
    check2(sizeof(lv), 8, "sizeof(STT0132)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT0132)");
    check_field_offset(lv, fa, 0, "STT0132.fa");
    check_field_offset(lv, fb, 4, "STT0132.fb");
  }
}
static Arrange_To_Call_Me vSTT0132(Test_STT0132, "STT0132", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0142  {
  char fa;
  __tsu64  :48;
  int fb;
};
//SIG(1 STT0142) C1{ Fc FL:48 Fi}



static void Test_STT0142()
{
  {
    init_simple_test("STT0142");
    static STT0142 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT0142)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT0142)");
    check_field_offset(lv, fa, 0, "STT0142.fa");
    check_field_offset(lv, fb, 8, "STT0142.fb");
  }
}
static Arrange_To_Call_Me vSTT0142(Test_STT0142, "STT0142", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0152  {
  char fa;
  unsigned char bf:3;
  int fb;
};
//SIG(1 STT0152) C1{ Fc Fc:3 Fi}



static void Test_STT0152()
{
  {
    init_simple_test("STT0152");
    static STT0152 lv;
    check2(sizeof(lv), 8, "sizeof(STT0152)");
    check2(__alignof__(lv), 4, "__alignof__(STT0152)");
    check_field_offset(lv, fa, 0, "STT0152.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0152");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0152");
    check_field_offset(lv, fb, 4, "STT0152.fb");
  }
}
static Arrange_To_Call_Me vSTT0152(Test_STT0152, "STT0152", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0162  {
  char fa;
  unsigned short bf:3;
  int fb;
};
//SIG(1 STT0162) C1{ Fc Fs:3 Fi}



static void Test_STT0162()
{
  {
    init_simple_test("STT0162");
    static STT0162 lv;
    check2(sizeof(lv), 8, "sizeof(STT0162)");
    check2(__alignof__(lv), 4, "__alignof__(STT0162)");
    check_field_offset(lv, fa, 0, "STT0162.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0162");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0162");
    check_field_offset(lv, fb, 4, "STT0162.fb");
  }
}
static Arrange_To_Call_Me vSTT0162(Test_STT0162, "STT0162", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0172  {
  char fa;
  unsigned int bf:3;
  int fb;
};
//SIG(1 STT0172) C1{ Fc Fi:3 Fi}



static void Test_STT0172()
{
  {
    init_simple_test("STT0172");
    static STT0172 lv;
    check2(sizeof(lv), 8, "sizeof(STT0172)");
    check2(__alignof__(lv), 4, "__alignof__(STT0172)");
    check_field_offset(lv, fa, 0, "STT0172.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0172");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0172");
    check_field_offset(lv, fb, 4, "STT0172.fb");
  }
}
static Arrange_To_Call_Me vSTT0172(Test_STT0172, "STT0172", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0182  {
  char fa;
  __tsu64 bf:3;
  int fb;
};
//SIG(1 STT0182) C1{ Fc FL:3 Fi}



static void Test_STT0182()
{
  {
    init_simple_test("STT0182");
    static STT0182 lv;
    check2(sizeof(lv), 8, "sizeof(STT0182)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0182)");
    check_field_offset(lv, fa, 0, "STT0182.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0182");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0182");
    check_field_offset(lv, fb, 4, "STT0182.fb");
  }
}
static Arrange_To_Call_Me vSTT0182(Test_STT0182, "STT0182", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0192  {
  char fa;
  unsigned short bf:8;
  int fb;
};
//SIG(1 STT0192) C1{ Fc Fs:8 Fi}



static void Test_STT0192()
{
  {
    init_simple_test("STT0192");
    static STT0192 lv;
    check2(sizeof(lv), 8, "sizeof(STT0192)");
    check2(__alignof__(lv), 4, "__alignof__(STT0192)");
    check_field_offset(lv, fa, 0, "STT0192.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0192");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0192");
    check_field_offset(lv, fb, 4, "STT0192.fb");
  }
}
static Arrange_To_Call_Me vSTT0192(Test_STT0192, "STT0192", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0202  {
  char fa;
  unsigned int bf:8;
  int fb;
};
//SIG(1 STT0202) C1{ Fc Fi:8 Fi}



static void Test_STT0202()
{
  {
    init_simple_test("STT0202");
    static STT0202 lv;
    check2(sizeof(lv), 8, "sizeof(STT0202)");
    check2(__alignof__(lv), 4, "__alignof__(STT0202)");
    check_field_offset(lv, fa, 0, "STT0202.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0202");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0202");
    check_field_offset(lv, fb, 4, "STT0202.fb");
  }
}
static Arrange_To_Call_Me vSTT0202(Test_STT0202, "STT0202", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0212  {
  char fa;
  __tsu64 bf:8;
  int fb;
};
//SIG(1 STT0212) C1{ Fc FL:8 Fi}



static void Test_STT0212()
{
  {
    init_simple_test("STT0212");
    static STT0212 lv;
    check2(sizeof(lv), 8, "sizeof(STT0212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0212)");
    check_field_offset(lv, fa, 0, "STT0212.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0212");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0212");
    check_field_offset(lv, fb, 4, "STT0212.fb");
  }
}
static Arrange_To_Call_Me vSTT0212(Test_STT0212, "STT0212", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0222  {
  char fa;
  unsigned int bf:18;
  int fb;
};
//SIG(1 STT0222) C1{ Fc Fi:18 Fi}



static void Test_STT0222()
{
  {
    init_simple_test("STT0222");
    static STT0222 lv;
    check2(sizeof(lv), 8, "sizeof(STT0222)");
    check2(__alignof__(lv), 4, "__alignof__(STT0222)");
    check_field_offset(lv, fa, 0, "STT0222.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0222");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0222");
    check_field_offset(lv, fb, 4, "STT0222.fb");
  }
}
static Arrange_To_Call_Me vSTT0222(Test_STT0222, "STT0222", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0232  {
  char fa;
  __tsu64 bf:18;
  int fb;
};
//SIG(1 STT0232) C1{ Fc FL:18 Fi}



static void Test_STT0232()
{
  {
    init_simple_test("STT0232");
    static STT0232 lv;
    check2(sizeof(lv), 8, "sizeof(STT0232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0232)");
    check_field_offset(lv, fa, 0, "STT0232.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0232");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0232");
    check_field_offset(lv, fb, 4, "STT0232.fb");
  }
}
static Arrange_To_Call_Me vSTT0232(Test_STT0232, "STT0232", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0242  {
  char fa;
  __tsu64 bf:48;
  int fb;
};
//SIG(1 STT0242) C1{ Fc FL:48 Fi}



static void Test_STT0242()
{
  {
    init_simple_test("STT0242");
    static STT0242 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0242)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0242)");
    check_field_offset(lv, fa, 0, "STT0242.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0242");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0242");
    check_field_offset(lv, fb, 8, "STT0242.fb");
  }
}
static Arrange_To_Call_Me vSTT0242(Test_STT0242, "STT0242", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT013  {
  char fa;
  unsigned char  :0;
  long fb;
};
//SIG(1 STT013) C1{ Fc Fc:0 Fl}



static void Test_STT013()
{
  {
    init_simple_test("STT013");
    static STT013 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT013)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT013)");
    check_field_offset(lv, fa, 0, "STT013.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT013.fb");
  }
}
static Arrange_To_Call_Me vSTT013(Test_STT013, "STT013", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT023  {
  char fa;
  unsigned short  :0;
  long fb;
};
//SIG(1 STT023) C1{ Fc Fs:0 Fl}



static void Test_STT023()
{
  {
    init_simple_test("STT023");
    static STT023 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT023)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT023)");
    check_field_offset(lv, fa, 0, "STT023.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT023.fb");
  }
}
static Arrange_To_Call_Me vSTT023(Test_STT023, "STT023", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT033  {
  char fa;
  unsigned int  :0;
  long fb;
};
//SIG(1 STT033) C1{ Fc Fi:0 Fl}



static void Test_STT033()
{
  {
    init_simple_test("STT033");
    static STT033 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT033)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT033)");
    check_field_offset(lv, fa, 0, "STT033.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT033.fb");
  }
}
static Arrange_To_Call_Me vSTT033(Test_STT033, "STT033", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT043  {
  char fa;
  __tsu64  :0;
  long fb;
};
//SIG(1 STT043) C1{ Fc FL:0 Fl}



static void Test_STT043()
{
  {
    init_simple_test("STT043");
    static STT043 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT043)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT043)");
    check_field_offset(lv, fa, 0, "STT043.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT043.fb");
  }
}
static Arrange_To_Call_Me vSTT043(Test_STT043, "STT043", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT053  {
  char fa;
  unsigned char  :3;
  long fb;
};
//SIG(1 STT053) C1{ Fc Fc:3 Fl}



static void Test_STT053()
{
  {
    init_simple_test("STT053");
    static STT053 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT053)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT053)");
    check_field_offset(lv, fa, 0, "STT053.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT053.fb");
  }
}
static Arrange_To_Call_Me vSTT053(Test_STT053, "STT053", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT063  {
  char fa;
  unsigned short  :3;
  long fb;
};
//SIG(1 STT063) C1{ Fc Fs:3 Fl}



static void Test_STT063()
{
  {
    init_simple_test("STT063");
    static STT063 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT063)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT063)");
    check_field_offset(lv, fa, 0, "STT063.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT063.fb");
  }
}
static Arrange_To_Call_Me vSTT063(Test_STT063, "STT063", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT073  {
  char fa;
  unsigned int  :3;
  long fb;
};
//SIG(1 STT073) C1{ Fc Fi:3 Fl}



static void Test_STT073()
{
  {
    init_simple_test("STT073");
    static STT073 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT073)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT073)");
    check_field_offset(lv, fa, 0, "STT073.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT073.fb");
  }
}
static Arrange_To_Call_Me vSTT073(Test_STT073, "STT073", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT083  {
  char fa;
  __tsu64  :3;
  long fb;
};
//SIG(1 STT083) C1{ Fc FL:3 Fl}



static void Test_STT083()
{
  {
    init_simple_test("STT083");
    static STT083 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT083)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT083)");
    check_field_offset(lv, fa, 0, "STT083.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT083.fb");
  }
}
static Arrange_To_Call_Me vSTT083(Test_STT083, "STT083", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT093  {
  char fa;
  unsigned short  :8;
  long fb;
};
//SIG(1 STT093) C1{ Fc Fs:8 Fl}



static void Test_STT093()
{
  {
    init_simple_test("STT093");
    static STT093 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT093)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT093)");
    check_field_offset(lv, fa, 0, "STT093.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT093.fb");
  }
}
static Arrange_To_Call_Me vSTT093(Test_STT093, "STT093", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0103  {
  char fa;
  unsigned int  :8;
  long fb;
};
//SIG(1 STT0103) C1{ Fc Fi:8 Fl}



static void Test_STT0103()
{
  {
    init_simple_test("STT0103");
    static STT0103 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0103)");
    check_field_offset(lv, fa, 0, "STT0103.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0103.fb");
  }
}
static Arrange_To_Call_Me vSTT0103(Test_STT0103, "STT0103", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0113  {
  char fa;
  __tsu64  :8;
  long fb;
};
//SIG(1 STT0113) C1{ Fc FL:8 Fl}



static void Test_STT0113()
{
  {
    init_simple_test("STT0113");
    static STT0113 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0113)");
    check_field_offset(lv, fa, 0, "STT0113.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0113.fb");
  }
}
static Arrange_To_Call_Me vSTT0113(Test_STT0113, "STT0113", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0123  {
  char fa;
  unsigned int  :18;
  long fb;
};
//SIG(1 STT0123) C1{ Fc Fi:18 Fl}



static void Test_STT0123()
{
  {
    init_simple_test("STT0123");
    static STT0123 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0123)");
    check_field_offset(lv, fa, 0, "STT0123.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0123.fb");
  }
}
static Arrange_To_Call_Me vSTT0123(Test_STT0123, "STT0123", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0133  {
  char fa;
  __tsu64  :18;
  long fb;
};
//SIG(1 STT0133) C1{ Fc FL:18 Fl}



static void Test_STT0133()
{
  {
    init_simple_test("STT0133");
    static STT0133 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0133)");
    check_field_offset(lv, fa, 0, "STT0133.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0133.fb");
  }
}
static Arrange_To_Call_Me vSTT0133(Test_STT0133, "STT0133", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0143  {
  char fa;
  __tsu64  :48;
  long fb;
};
//SIG(1 STT0143) C1{ Fc FL:48 Fl}



static void Test_STT0143()
{
  {
    init_simple_test("STT0143");
    static STT0143 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0143)");
    check_field_offset(lv, fa, 0, "STT0143.fa");
    check_field_offset(lv, fb, 8, "STT0143.fb");
  }
}
static Arrange_To_Call_Me vSTT0143(Test_STT0143, "STT0143", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0153  {
  char fa;
  unsigned char bf:3;
  long fb;
};
//SIG(1 STT0153) C1{ Fc Fc:3 Fl}



static void Test_STT0153()
{
  {
    init_simple_test("STT0153");
    static STT0153 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0153)");
    check_field_offset(lv, fa, 0, "STT0153.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0153");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0153");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0153.fb");
  }
}
static Arrange_To_Call_Me vSTT0153(Test_STT0153, "STT0153", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0163  {
  char fa;
  unsigned short bf:3;
  long fb;
};
//SIG(1 STT0163) C1{ Fc Fs:3 Fl}



static void Test_STT0163()
{
  {
    init_simple_test("STT0163");
    static STT0163 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0163)");
    check_field_offset(lv, fa, 0, "STT0163.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0163");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0163");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0163.fb");
  }
}
static Arrange_To_Call_Me vSTT0163(Test_STT0163, "STT0163", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0173  {
  char fa;
  unsigned int bf:3;
  long fb;
};
//SIG(1 STT0173) C1{ Fc Fi:3 Fl}



static void Test_STT0173()
{
  {
    init_simple_test("STT0173");
    static STT0173 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0173)");
    check_field_offset(lv, fa, 0, "STT0173.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0173");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0173");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0173.fb");
  }
}
static Arrange_To_Call_Me vSTT0173(Test_STT0173, "STT0173", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0183  {
  char fa;
  __tsu64 bf:3;
  long fb;
};
//SIG(1 STT0183) C1{ Fc FL:3 Fl}



static void Test_STT0183()
{
  {
    init_simple_test("STT0183");
    static STT0183 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0183)");
    check_field_offset(lv, fa, 0, "STT0183.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0183");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0183");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0183.fb");
  }
}
static Arrange_To_Call_Me vSTT0183(Test_STT0183, "STT0183", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0193  {
  char fa;
  unsigned short bf:8;
  long fb;
};
//SIG(1 STT0193) C1{ Fc Fs:8 Fl}



static void Test_STT0193()
{
  {
    init_simple_test("STT0193");
    static STT0193 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0193)");
    check_field_offset(lv, fa, 0, "STT0193.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0193");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0193");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0193.fb");
  }
}
static Arrange_To_Call_Me vSTT0193(Test_STT0193, "STT0193", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0203  {
  char fa;
  unsigned int bf:8;
  long fb;
};
//SIG(1 STT0203) C1{ Fc Fi:8 Fl}



static void Test_STT0203()
{
  {
    init_simple_test("STT0203");
    static STT0203 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0203)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0203)");
    check_field_offset(lv, fa, 0, "STT0203.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0203");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0203");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0203.fb");
  }
}
static Arrange_To_Call_Me vSTT0203(Test_STT0203, "STT0203", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0213  {
  char fa;
  __tsu64 bf:8;
  long fb;
};
//SIG(1 STT0213) C1{ Fc FL:8 Fl}



static void Test_STT0213()
{
  {
    init_simple_test("STT0213");
    static STT0213 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0213)");
    check_field_offset(lv, fa, 0, "STT0213.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0213");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0213");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0213.fb");
  }
}
static Arrange_To_Call_Me vSTT0213(Test_STT0213, "STT0213", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0223  {
  char fa;
  unsigned int bf:18;
  long fb;
};
//SIG(1 STT0223) C1{ Fc Fi:18 Fl}



static void Test_STT0223()
{
  {
    init_simple_test("STT0223");
    static STT0223 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0223)");
    check_field_offset(lv, fa, 0, "STT0223.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0223");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0223");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0223.fb");
  }
}
static Arrange_To_Call_Me vSTT0223(Test_STT0223, "STT0223", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0233  {
  char fa;
  __tsu64 bf:18;
  long fb;
};
//SIG(1 STT0233) C1{ Fc FL:18 Fl}



static void Test_STT0233()
{
  {
    init_simple_test("STT0233");
    static STT0233 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0233)");
    check_field_offset(lv, fa, 0, "STT0233.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0233");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0233");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0233.fb");
  }
}
static Arrange_To_Call_Me vSTT0233(Test_STT0233, "STT0233", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0243  {
  char fa;
  __tsu64 bf:48;
  long fb;
};
//SIG(1 STT0243) C1{ Fc FL:48 Fl}



static void Test_STT0243()
{
  {
    init_simple_test("STT0243");
    static STT0243 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0243)");
    check_field_offset(lv, fa, 0, "STT0243.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0243");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0243");
    check_field_offset(lv, fb, 8, "STT0243.fb");
  }
}
static Arrange_To_Call_Me vSTT0243(Test_STT0243, "STT0243", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT014  {
  char fa;
  unsigned char  :0;
  __tsi64 fb;
};
//SIG(1 STT014) C1{ Fc Fc:0 FL}



static void Test_STT014()
{
  {
    init_simple_test("STT014");
    static STT014 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT014)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT014)");
    check_field_offset(lv, fa, 0, "STT014.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT014.fb");
  }
}
static Arrange_To_Call_Me vSTT014(Test_STT014, "STT014", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT024  {
  char fa;
  unsigned short  :0;
  __tsi64 fb;
};
//SIG(1 STT024) C1{ Fc Fs:0 FL}



static void Test_STT024()
{
  {
    init_simple_test("STT024");
    static STT024 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT024)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT024)");
    check_field_offset(lv, fa, 0, "STT024.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT024.fb");
  }
}
static Arrange_To_Call_Me vSTT024(Test_STT024, "STT024", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT034  {
  char fa;
  unsigned int  :0;
  __tsi64 fb;
};
//SIG(1 STT034) C1{ Fc Fi:0 FL}



static void Test_STT034()
{
  {
    init_simple_test("STT034");
    static STT034 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT034)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT034)");
    check_field_offset(lv, fa, 0, "STT034.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT034.fb");
  }
}
static Arrange_To_Call_Me vSTT034(Test_STT034, "STT034", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT044  {
  char fa;
  __tsu64  :0;
  __tsi64 fb;
};
//SIG(1 STT044) C1{ Fc FL:0 FL}



static void Test_STT044()
{
  {
    init_simple_test("STT044");
    static STT044 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT044)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT044)");
    check_field_offset(lv, fa, 0, "STT044.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT044.fb");
  }
}
static Arrange_To_Call_Me vSTT044(Test_STT044, "STT044", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT054  {
  char fa;
  unsigned char  :3;
  __tsi64 fb;
};
//SIG(1 STT054) C1{ Fc Fc:3 FL}



static void Test_STT054()
{
  {
    init_simple_test("STT054");
    static STT054 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT054)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT054)");
    check_field_offset(lv, fa, 0, "STT054.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT054.fb");
  }
}
static Arrange_To_Call_Me vSTT054(Test_STT054, "STT054", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT064  {
  char fa;
  unsigned short  :3;
  __tsi64 fb;
};
//SIG(1 STT064) C1{ Fc Fs:3 FL}



static void Test_STT064()
{
  {
    init_simple_test("STT064");
    static STT064 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT064)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT064)");
    check_field_offset(lv, fa, 0, "STT064.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT064.fb");
  }
}
static Arrange_To_Call_Me vSTT064(Test_STT064, "STT064", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT074  {
  char fa;
  unsigned int  :3;
  __tsi64 fb;
};
//SIG(1 STT074) C1{ Fc Fi:3 FL}



static void Test_STT074()
{
  {
    init_simple_test("STT074");
    static STT074 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT074)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT074)");
    check_field_offset(lv, fa, 0, "STT074.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT074.fb");
  }
}
static Arrange_To_Call_Me vSTT074(Test_STT074, "STT074", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT084  {
  char fa;
  __tsu64  :3;
  __tsi64 fb;
};
//SIG(1 STT084) C1{ Fc FL:3 FL}



static void Test_STT084()
{
  {
    init_simple_test("STT084");
    static STT084 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT084)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT084)");
    check_field_offset(lv, fa, 0, "STT084.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT084.fb");
  }
}
static Arrange_To_Call_Me vSTT084(Test_STT084, "STT084", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT094  {
  char fa;
  unsigned short  :8;
  __tsi64 fb;
};
//SIG(1 STT094) C1{ Fc Fs:8 FL}



static void Test_STT094()
{
  {
    init_simple_test("STT094");
    static STT094 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT094)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT094)");
    check_field_offset(lv, fa, 0, "STT094.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT094.fb");
  }
}
static Arrange_To_Call_Me vSTT094(Test_STT094, "STT094", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0104  {
  char fa;
  unsigned int  :8;
  __tsi64 fb;
};
//SIG(1 STT0104) C1{ Fc Fi:8 FL}



static void Test_STT0104()
{
  {
    init_simple_test("STT0104");
    static STT0104 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0104)");
    check_field_offset(lv, fa, 0, "STT0104.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0104.fb");
  }
}
static Arrange_To_Call_Me vSTT0104(Test_STT0104, "STT0104", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0114  {
  char fa;
  __tsu64  :8;
  __tsi64 fb;
};
//SIG(1 STT0114) C1{ Fc FL:8 FL}



static void Test_STT0114()
{
  {
    init_simple_test("STT0114");
    static STT0114 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0114)");
    check_field_offset(lv, fa, 0, "STT0114.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0114.fb");
  }
}
static Arrange_To_Call_Me vSTT0114(Test_STT0114, "STT0114", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0124  {
  char fa;
  unsigned int  :18;
  __tsi64 fb;
};
//SIG(1 STT0124) C1{ Fc Fi:18 FL}



static void Test_STT0124()
{
  {
    init_simple_test("STT0124");
    static STT0124 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0124)");
    check_field_offset(lv, fa, 0, "STT0124.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0124.fb");
  }
}
static Arrange_To_Call_Me vSTT0124(Test_STT0124, "STT0124", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0134  {
  char fa;
  __tsu64  :18;
  __tsi64 fb;
};
//SIG(1 STT0134) C1{ Fc FL:18 FL}



static void Test_STT0134()
{
  {
    init_simple_test("STT0134");
    static STT0134 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0134)");
    check_field_offset(lv, fa, 0, "STT0134.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0134.fb");
  }
}
static Arrange_To_Call_Me vSTT0134(Test_STT0134, "STT0134", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0144  {
  char fa;
  __tsu64  :48;
  __tsi64 fb;
};
//SIG(1 STT0144) C1{ Fc FL:48 FL}



static void Test_STT0144()
{
  {
    init_simple_test("STT0144");
    static STT0144 lv;
    check2(sizeof(lv), 16, "sizeof(STT0144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0144)");
    check_field_offset(lv, fa, 0, "STT0144.fa");
    check_field_offset(lv, fb, 8, "STT0144.fb");
  }
}
static Arrange_To_Call_Me vSTT0144(Test_STT0144, "STT0144", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0154  {
  char fa;
  unsigned char bf:3;
  __tsi64 fb;
};
//SIG(1 STT0154) C1{ Fc Fc:3 FL}



static void Test_STT0154()
{
  {
    init_simple_test("STT0154");
    static STT0154 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0154)");
    check_field_offset(lv, fa, 0, "STT0154.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0154");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0154");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0154.fb");
  }
}
static Arrange_To_Call_Me vSTT0154(Test_STT0154, "STT0154", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0164  {
  char fa;
  unsigned short bf:3;
  __tsi64 fb;
};
//SIG(1 STT0164) C1{ Fc Fs:3 FL}



static void Test_STT0164()
{
  {
    init_simple_test("STT0164");
    static STT0164 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0164)");
    check_field_offset(lv, fa, 0, "STT0164.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0164");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0164");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0164.fb");
  }
}
static Arrange_To_Call_Me vSTT0164(Test_STT0164, "STT0164", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0174  {
  char fa;
  unsigned int bf:3;
  __tsi64 fb;
};
//SIG(1 STT0174) C1{ Fc Fi:3 FL}



static void Test_STT0174()
{
  {
    init_simple_test("STT0174");
    static STT0174 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0174)");
    check_field_offset(lv, fa, 0, "STT0174.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0174");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0174");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0174.fb");
  }
}
static Arrange_To_Call_Me vSTT0174(Test_STT0174, "STT0174", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0184  {
  char fa;
  __tsu64 bf:3;
  __tsi64 fb;
};
//SIG(1 STT0184) C1{ Fc FL:3 FL}



static void Test_STT0184()
{
  {
    init_simple_test("STT0184");
    static STT0184 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0184)");
    check_field_offset(lv, fa, 0, "STT0184.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0184");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0184");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0184.fb");
  }
}
static Arrange_To_Call_Me vSTT0184(Test_STT0184, "STT0184", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0194  {
  char fa;
  unsigned short bf:8;
  __tsi64 fb;
};
//SIG(1 STT0194) C1{ Fc Fs:8 FL}



static void Test_STT0194()
{
  {
    init_simple_test("STT0194");
    static STT0194 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0194)");
    check_field_offset(lv, fa, 0, "STT0194.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0194");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0194");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0194.fb");
  }
}
static Arrange_To_Call_Me vSTT0194(Test_STT0194, "STT0194", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0204  {
  char fa;
  unsigned int bf:8;
  __tsi64 fb;
};
//SIG(1 STT0204) C1{ Fc Fi:8 FL}



static void Test_STT0204()
{
  {
    init_simple_test("STT0204");
    static STT0204 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0204)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0204)");
    check_field_offset(lv, fa, 0, "STT0204.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0204");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0204");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0204.fb");
  }
}
static Arrange_To_Call_Me vSTT0204(Test_STT0204, "STT0204", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0214  {
  char fa;
  __tsu64 bf:8;
  __tsi64 fb;
};
//SIG(1 STT0214) C1{ Fc FL:8 FL}



static void Test_STT0214()
{
  {
    init_simple_test("STT0214");
    static STT0214 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0214)");
    check_field_offset(lv, fa, 0, "STT0214.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0214");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0214");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0214.fb");
  }
}
static Arrange_To_Call_Me vSTT0214(Test_STT0214, "STT0214", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0224  {
  char fa;
  unsigned int bf:18;
  __tsi64 fb;
};
//SIG(1 STT0224) C1{ Fc Fi:18 FL}



static void Test_STT0224()
{
  {
    init_simple_test("STT0224");
    static STT0224 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0224)");
    check_field_offset(lv, fa, 0, "STT0224.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0224");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0224");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0224.fb");
  }
}
static Arrange_To_Call_Me vSTT0224(Test_STT0224, "STT0224", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0234  {
  char fa;
  __tsu64 bf:18;
  __tsi64 fb;
};
//SIG(1 STT0234) C1{ Fc FL:18 FL}



static void Test_STT0234()
{
  {
    init_simple_test("STT0234");
    static STT0234 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0234)");
    check_field_offset(lv, fa, 0, "STT0234.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0234");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0234");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0234.fb");
  }
}
static Arrange_To_Call_Me vSTT0234(Test_STT0234, "STT0234", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0244  {
  char fa;
  __tsu64 bf:48;
  __tsi64 fb;
};
//SIG(1 STT0244) C1{ Fc FL:48 FL}



static void Test_STT0244()
{
  {
    init_simple_test("STT0244");
    static STT0244 lv;
    check2(sizeof(lv), 16, "sizeof(STT0244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0244)");
    check_field_offset(lv, fa, 0, "STT0244.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0244");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0244");
    check_field_offset(lv, fb, 8, "STT0244.fb");
  }
}
static Arrange_To_Call_Me vSTT0244(Test_STT0244, "STT0244", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT015  {
  char fa;
  unsigned char  :0;
  void *fb;
};
//SIG(1 STT015) C1{ Fc Fc:0 Fp}



static void Test_STT015()
{
  {
    init_simple_test("STT015");
    static STT015 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT015)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT015)");
    check_field_offset(lv, fa, 0, "STT015.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT015.fb");
  }
}
static Arrange_To_Call_Me vSTT015(Test_STT015, "STT015", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT025  {
  char fa;
  unsigned short  :0;
  void *fb;
};
//SIG(1 STT025) C1{ Fc Fs:0 Fp}



static void Test_STT025()
{
  {
    init_simple_test("STT025");
    static STT025 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT025)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT025)");
    check_field_offset(lv, fa, 0, "STT025.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT025.fb");
  }
}
static Arrange_To_Call_Me vSTT025(Test_STT025, "STT025", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT035  {
  char fa;
  unsigned int  :0;
  void *fb;
};
//SIG(1 STT035) C1{ Fc Fi:0 Fp}



static void Test_STT035()
{
  {
    init_simple_test("STT035");
    static STT035 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT035)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT035)");
    check_field_offset(lv, fa, 0, "STT035.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT035.fb");
  }
}
static Arrange_To_Call_Me vSTT035(Test_STT035, "STT035", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT045  {
  char fa;
  __tsu64  :0;
  void *fb;
};
//SIG(1 STT045) C1{ Fc FL:0 Fp}



static void Test_STT045()
{
  {
    init_simple_test("STT045");
    static STT045 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT045)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT045)");
    check_field_offset(lv, fa, 0, "STT045.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT045.fb");
  }
}
static Arrange_To_Call_Me vSTT045(Test_STT045, "STT045", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT055  {
  char fa;
  unsigned char  :3;
  void *fb;
};
//SIG(1 STT055) C1{ Fc Fc:3 Fp}



static void Test_STT055()
{
  {
    init_simple_test("STT055");
    static STT055 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT055)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT055)");
    check_field_offset(lv, fa, 0, "STT055.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT055.fb");
  }
}
static Arrange_To_Call_Me vSTT055(Test_STT055, "STT055", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT065  {
  char fa;
  unsigned short  :3;
  void *fb;
};
//SIG(1 STT065) C1{ Fc Fs:3 Fp}



static void Test_STT065()
{
  {
    init_simple_test("STT065");
    static STT065 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT065)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT065)");
    check_field_offset(lv, fa, 0, "STT065.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT065.fb");
  }
}
static Arrange_To_Call_Me vSTT065(Test_STT065, "STT065", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT075  {
  char fa;
  unsigned int  :3;
  void *fb;
};
//SIG(1 STT075) C1{ Fc Fi:3 Fp}



static void Test_STT075()
{
  {
    init_simple_test("STT075");
    static STT075 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT075)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT075)");
    check_field_offset(lv, fa, 0, "STT075.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT075.fb");
  }
}
static Arrange_To_Call_Me vSTT075(Test_STT075, "STT075", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT085  {
  char fa;
  __tsu64  :3;
  void *fb;
};
//SIG(1 STT085) C1{ Fc FL:3 Fp}



static void Test_STT085()
{
  {
    init_simple_test("STT085");
    static STT085 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT085)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT085)");
    check_field_offset(lv, fa, 0, "STT085.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT085.fb");
  }
}
static Arrange_To_Call_Me vSTT085(Test_STT085, "STT085", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT095  {
  char fa;
  unsigned short  :8;
  void *fb;
};
//SIG(1 STT095) C1{ Fc Fs:8 Fp}



static void Test_STT095()
{
  {
    init_simple_test("STT095");
    static STT095 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT095)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT095)");
    check_field_offset(lv, fa, 0, "STT095.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT095.fb");
  }
}
static Arrange_To_Call_Me vSTT095(Test_STT095, "STT095", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0105  {
  char fa;
  unsigned int  :8;
  void *fb;
};
//SIG(1 STT0105) C1{ Fc Fi:8 Fp}



static void Test_STT0105()
{
  {
    init_simple_test("STT0105");
    static STT0105 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0105)");
    check_field_offset(lv, fa, 0, "STT0105.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0105.fb");
  }
}
static Arrange_To_Call_Me vSTT0105(Test_STT0105, "STT0105", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0115  {
  char fa;
  __tsu64  :8;
  void *fb;
};
//SIG(1 STT0115) C1{ Fc FL:8 Fp}



static void Test_STT0115()
{
  {
    init_simple_test("STT0115");
    static STT0115 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0115)");
    check_field_offset(lv, fa, 0, "STT0115.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0115.fb");
  }
}
static Arrange_To_Call_Me vSTT0115(Test_STT0115, "STT0115", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0125  {
  char fa;
  unsigned int  :18;
  void *fb;
};
//SIG(1 STT0125) C1{ Fc Fi:18 Fp}



static void Test_STT0125()
{
  {
    init_simple_test("STT0125");
    static STT0125 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0125)");
    check_field_offset(lv, fa, 0, "STT0125.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0125.fb");
  }
}
static Arrange_To_Call_Me vSTT0125(Test_STT0125, "STT0125", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0135  {
  char fa;
  __tsu64  :18;
  void *fb;
};
//SIG(1 STT0135) C1{ Fc FL:18 Fp}



static void Test_STT0135()
{
  {
    init_simple_test("STT0135");
    static STT0135 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0135)");
    check_field_offset(lv, fa, 0, "STT0135.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0135.fb");
  }
}
static Arrange_To_Call_Me vSTT0135(Test_STT0135, "STT0135", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0145  {
  char fa;
  __tsu64  :48;
  void *fb;
};
//SIG(1 STT0145) C1{ Fc FL:48 Fp}



static void Test_STT0145()
{
  {
    init_simple_test("STT0145");
    static STT0145 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0145)");
    check_field_offset(lv, fa, 0, "STT0145.fa");
    check_field_offset(lv, fb, 8, "STT0145.fb");
  }
}
static Arrange_To_Call_Me vSTT0145(Test_STT0145, "STT0145", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0155  {
  char fa;
  unsigned char bf:3;
  void *fb;
};
//SIG(1 STT0155) C1{ Fc Fc:3 Fp}



static void Test_STT0155()
{
  {
    init_simple_test("STT0155");
    static STT0155 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0155)");
    check_field_offset(lv, fa, 0, "STT0155.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0155");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0155");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0155.fb");
  }
}
static Arrange_To_Call_Me vSTT0155(Test_STT0155, "STT0155", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0165  {
  char fa;
  unsigned short bf:3;
  void *fb;
};
//SIG(1 STT0165) C1{ Fc Fs:3 Fp}



static void Test_STT0165()
{
  {
    init_simple_test("STT0165");
    static STT0165 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0165)");
    check_field_offset(lv, fa, 0, "STT0165.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0165");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0165");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0165.fb");
  }
}
static Arrange_To_Call_Me vSTT0165(Test_STT0165, "STT0165", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0175  {
  char fa;
  unsigned int bf:3;
  void *fb;
};
//SIG(1 STT0175) C1{ Fc Fi:3 Fp}



static void Test_STT0175()
{
  {
    init_simple_test("STT0175");
    static STT0175 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0175)");
    check_field_offset(lv, fa, 0, "STT0175.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0175");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0175");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0175.fb");
  }
}
static Arrange_To_Call_Me vSTT0175(Test_STT0175, "STT0175", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0185  {
  char fa;
  __tsu64 bf:3;
  void *fb;
};
//SIG(1 STT0185) C1{ Fc FL:3 Fp}



static void Test_STT0185()
{
  {
    init_simple_test("STT0185");
    static STT0185 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0185)");
    check_field_offset(lv, fa, 0, "STT0185.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0185");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0185");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0185.fb");
  }
}
static Arrange_To_Call_Me vSTT0185(Test_STT0185, "STT0185", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0195  {
  char fa;
  unsigned short bf:8;
  void *fb;
};
//SIG(1 STT0195) C1{ Fc Fs:8 Fp}



static void Test_STT0195()
{
  {
    init_simple_test("STT0195");
    static STT0195 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0195)");
    check_field_offset(lv, fa, 0, "STT0195.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0195");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0195");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0195.fb");
  }
}
static Arrange_To_Call_Me vSTT0195(Test_STT0195, "STT0195", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0205  {
  char fa;
  unsigned int bf:8;
  void *fb;
};
//SIG(1 STT0205) C1{ Fc Fi:8 Fp}



static void Test_STT0205()
{
  {
    init_simple_test("STT0205");
    static STT0205 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0205)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0205)");
    check_field_offset(lv, fa, 0, "STT0205.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0205");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0205");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0205.fb");
  }
}
static Arrange_To_Call_Me vSTT0205(Test_STT0205, "STT0205", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0215  {
  char fa;
  __tsu64 bf:8;
  void *fb;
};
//SIG(1 STT0215) C1{ Fc FL:8 Fp}



static void Test_STT0215()
{
  {
    init_simple_test("STT0215");
    static STT0215 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0215)");
    check_field_offset(lv, fa, 0, "STT0215.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0215");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0215");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0215.fb");
  }
}
static Arrange_To_Call_Me vSTT0215(Test_STT0215, "STT0215", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0225  {
  char fa;
  unsigned int bf:18;
  void *fb;
};
//SIG(1 STT0225) C1{ Fc Fi:18 Fp}



static void Test_STT0225()
{
  {
    init_simple_test("STT0225");
    static STT0225 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0225)");
    check_field_offset(lv, fa, 0, "STT0225.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0225");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0225");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0225.fb");
  }
}
static Arrange_To_Call_Me vSTT0225(Test_STT0225, "STT0225", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0235  {
  char fa;
  __tsu64 bf:18;
  void *fb;
};
//SIG(1 STT0235) C1{ Fc FL:18 Fp}



static void Test_STT0235()
{
  {
    init_simple_test("STT0235");
    static STT0235 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT0235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0235)");
    check_field_offset(lv, fa, 0, "STT0235.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0235");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0235");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0235.fb");
  }
}
static Arrange_To_Call_Me vSTT0235(Test_STT0235, "STT0235", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0245  {
  char fa;
  __tsu64 bf:48;
  void *fb;
};
//SIG(1 STT0245) C1{ Fc FL:48 Fp}



static void Test_STT0245()
{
  {
    init_simple_test("STT0245");
    static STT0245 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0245)");
    check_field_offset(lv, fa, 0, "STT0245.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0245");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0245");
    check_field_offset(lv, fb, 8, "STT0245.fb");
  }
}
static Arrange_To_Call_Me vSTT0245(Test_STT0245, "STT0245", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT016  {
  char fa;
  unsigned char  :0;
  float fb;
};
//SIG(1 STT016) C1{ Fc Fc:0 Fi}



static void Test_STT016()
{
  {
    init_simple_test("STT016");
    static STT016 lv;
    check2(sizeof(lv), 8, "sizeof(STT016)");
    check2(__alignof__(lv), 4, "__alignof__(STT016)");
    check_field_offset(lv, fa, 0, "STT016.fa");
    check_field_offset(lv, fb, 4, "STT016.fb");
  }
}
static Arrange_To_Call_Me vSTT016(Test_STT016, "STT016", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT026  {
  char fa;
  unsigned short  :0;
  float fb;
};
//SIG(1 STT026) C1{ Fc Fs:0 Fi}



static void Test_STT026()
{
  {
    init_simple_test("STT026");
    static STT026 lv;
    check2(sizeof(lv), 8, "sizeof(STT026)");
    check2(__alignof__(lv), 4, "__alignof__(STT026)");
    check_field_offset(lv, fa, 0, "STT026.fa");
    check_field_offset(lv, fb, 4, "STT026.fb");
  }
}
static Arrange_To_Call_Me vSTT026(Test_STT026, "STT026", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT036  {
  char fa;
  unsigned int  :0;
  float fb;
};
//SIG(1 STT036) C1{ Fc Fi:0 Fi}



static void Test_STT036()
{
  {
    init_simple_test("STT036");
    static STT036 lv;
    check2(sizeof(lv), 8, "sizeof(STT036)");
    check2(__alignof__(lv), 4, "__alignof__(STT036)");
    check_field_offset(lv, fa, 0, "STT036.fa");
    check_field_offset(lv, fb, 4, "STT036.fb");
  }
}
static Arrange_To_Call_Me vSTT036(Test_STT036, "STT036", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT046  {
  char fa;
  __tsu64  :0;
  float fb;
};
//SIG(1 STT046) C1{ Fc FL:0 Fi}



static void Test_STT046()
{
  {
    init_simple_test("STT046");
    static STT046 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT046)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT046)");
    check_field_offset(lv, fa, 0, "STT046.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT046.fb");
  }
}
static Arrange_To_Call_Me vSTT046(Test_STT046, "STT046", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT056  {
  char fa;
  unsigned char  :3;
  float fb;
};
//SIG(1 STT056) C1{ Fc Fc:3 Fi}



static void Test_STT056()
{
  {
    init_simple_test("STT056");
    static STT056 lv;
    check2(sizeof(lv), 8, "sizeof(STT056)");
    check2(__alignof__(lv), 4, "__alignof__(STT056)");
    check_field_offset(lv, fa, 0, "STT056.fa");
    check_field_offset(lv, fb, 4, "STT056.fb");
  }
}
static Arrange_To_Call_Me vSTT056(Test_STT056, "STT056", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT066  {
  char fa;
  unsigned short  :3;
  float fb;
};
//SIG(1 STT066) C1{ Fc Fs:3 Fi}



static void Test_STT066()
{
  {
    init_simple_test("STT066");
    static STT066 lv;
    check2(sizeof(lv), 8, "sizeof(STT066)");
    check2(__alignof__(lv), 4, "__alignof__(STT066)");
    check_field_offset(lv, fa, 0, "STT066.fa");
    check_field_offset(lv, fb, 4, "STT066.fb");
  }
}
static Arrange_To_Call_Me vSTT066(Test_STT066, "STT066", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT076  {
  char fa;
  unsigned int  :3;
  float fb;
};
//SIG(1 STT076) C1{ Fc Fi:3 Fi}



static void Test_STT076()
{
  {
    init_simple_test("STT076");
    static STT076 lv;
    check2(sizeof(lv), 8, "sizeof(STT076)");
    check2(__alignof__(lv), 4, "__alignof__(STT076)");
    check_field_offset(lv, fa, 0, "STT076.fa");
    check_field_offset(lv, fb, 4, "STT076.fb");
  }
}
static Arrange_To_Call_Me vSTT076(Test_STT076, "STT076", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT086  {
  char fa;
  __tsu64  :3;
  float fb;
};
//SIG(1 STT086) C1{ Fc FL:3 Fi}



static void Test_STT086()
{
  {
    init_simple_test("STT086");
    static STT086 lv;
    check2(sizeof(lv), 8, "sizeof(STT086)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT086)");
    check_field_offset(lv, fa, 0, "STT086.fa");
    check_field_offset(lv, fb, 4, "STT086.fb");
  }
}
static Arrange_To_Call_Me vSTT086(Test_STT086, "STT086", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT096  {
  char fa;
  unsigned short  :8;
  float fb;
};
//SIG(1 STT096) C1{ Fc Fs:8 Fi}



static void Test_STT096()
{
  {
    init_simple_test("STT096");
    static STT096 lv;
    check2(sizeof(lv), 8, "sizeof(STT096)");
    check2(__alignof__(lv), 4, "__alignof__(STT096)");
    check_field_offset(lv, fa, 0, "STT096.fa");
    check_field_offset(lv, fb, 4, "STT096.fb");
  }
}
static Arrange_To_Call_Me vSTT096(Test_STT096, "STT096", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0106  {
  char fa;
  unsigned int  :8;
  float fb;
};
//SIG(1 STT0106) C1{ Fc Fi:8 Fi}



static void Test_STT0106()
{
  {
    init_simple_test("STT0106");
    static STT0106 lv;
    check2(sizeof(lv), 8, "sizeof(STT0106)");
    check2(__alignof__(lv), 4, "__alignof__(STT0106)");
    check_field_offset(lv, fa, 0, "STT0106.fa");
    check_field_offset(lv, fb, 4, "STT0106.fb");
  }
}
static Arrange_To_Call_Me vSTT0106(Test_STT0106, "STT0106", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0116  {
  char fa;
  __tsu64  :8;
  float fb;
};
//SIG(1 STT0116) C1{ Fc FL:8 Fi}



static void Test_STT0116()
{
  {
    init_simple_test("STT0116");
    static STT0116 lv;
    check2(sizeof(lv), 8, "sizeof(STT0116)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT0116)");
    check_field_offset(lv, fa, 0, "STT0116.fa");
    check_field_offset(lv, fb, 4, "STT0116.fb");
  }
}
static Arrange_To_Call_Me vSTT0116(Test_STT0116, "STT0116", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0126  {
  char fa;
  unsigned int  :18;
  float fb;
};
//SIG(1 STT0126) C1{ Fc Fi:18 Fi}



static void Test_STT0126()
{
  {
    init_simple_test("STT0126");
    static STT0126 lv;
    check2(sizeof(lv), 8, "sizeof(STT0126)");
    check2(__alignof__(lv), 4, "__alignof__(STT0126)");
    check_field_offset(lv, fa, 0, "STT0126.fa");
    check_field_offset(lv, fb, 4, "STT0126.fb");
  }
}
static Arrange_To_Call_Me vSTT0126(Test_STT0126, "STT0126", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0136  {
  char fa;
  __tsu64  :18;
  float fb;
};
//SIG(1 STT0136) C1{ Fc FL:18 Fi}



static void Test_STT0136()
{
  {
    init_simple_test("STT0136");
    static STT0136 lv;
    check2(sizeof(lv), 8, "sizeof(STT0136)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT0136)");
    check_field_offset(lv, fa, 0, "STT0136.fa");
    check_field_offset(lv, fb, 4, "STT0136.fb");
  }
}
static Arrange_To_Call_Me vSTT0136(Test_STT0136, "STT0136", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0146  {
  char fa;
  __tsu64  :48;
  float fb;
};
//SIG(1 STT0146) C1{ Fc FL:48 Fi}



static void Test_STT0146()
{
  {
    init_simple_test("STT0146");
    static STT0146 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT0146)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT0146)");
    check_field_offset(lv, fa, 0, "STT0146.fa");
    check_field_offset(lv, fb, 8, "STT0146.fb");
  }
}
static Arrange_To_Call_Me vSTT0146(Test_STT0146, "STT0146", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0156  {
  char fa;
  unsigned char bf:3;
  float fb;
};
//SIG(1 STT0156) C1{ Fc Fc:3 Fi}



static void Test_STT0156()
{
  {
    init_simple_test("STT0156");
    static STT0156 lv;
    check2(sizeof(lv), 8, "sizeof(STT0156)");
    check2(__alignof__(lv), 4, "__alignof__(STT0156)");
    check_field_offset(lv, fa, 0, "STT0156.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0156");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0156");
    check_field_offset(lv, fb, 4, "STT0156.fb");
  }
}
static Arrange_To_Call_Me vSTT0156(Test_STT0156, "STT0156", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0166  {
  char fa;
  unsigned short bf:3;
  float fb;
};
//SIG(1 STT0166) C1{ Fc Fs:3 Fi}



static void Test_STT0166()
{
  {
    init_simple_test("STT0166");
    static STT0166 lv;
    check2(sizeof(lv), 8, "sizeof(STT0166)");
    check2(__alignof__(lv), 4, "__alignof__(STT0166)");
    check_field_offset(lv, fa, 0, "STT0166.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0166");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0166");
    check_field_offset(lv, fb, 4, "STT0166.fb");
  }
}
static Arrange_To_Call_Me vSTT0166(Test_STT0166, "STT0166", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0176  {
  char fa;
  unsigned int bf:3;
  float fb;
};
//SIG(1 STT0176) C1{ Fc Fi:3 Fi}



static void Test_STT0176()
{
  {
    init_simple_test("STT0176");
    static STT0176 lv;
    check2(sizeof(lv), 8, "sizeof(STT0176)");
    check2(__alignof__(lv), 4, "__alignof__(STT0176)");
    check_field_offset(lv, fa, 0, "STT0176.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0176");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0176");
    check_field_offset(lv, fb, 4, "STT0176.fb");
  }
}
static Arrange_To_Call_Me vSTT0176(Test_STT0176, "STT0176", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0186  {
  char fa;
  __tsu64 bf:3;
  float fb;
};
//SIG(1 STT0186) C1{ Fc FL:3 Fi}



static void Test_STT0186()
{
  {
    init_simple_test("STT0186");
    static STT0186 lv;
    check2(sizeof(lv), 8, "sizeof(STT0186)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0186)");
    check_field_offset(lv, fa, 0, "STT0186.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0186");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0186");
    check_field_offset(lv, fb, 4, "STT0186.fb");
  }
}
static Arrange_To_Call_Me vSTT0186(Test_STT0186, "STT0186", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0196  {
  char fa;
  unsigned short bf:8;
  float fb;
};
//SIG(1 STT0196) C1{ Fc Fs:8 Fi}



static void Test_STT0196()
{
  {
    init_simple_test("STT0196");
    static STT0196 lv;
    check2(sizeof(lv), 8, "sizeof(STT0196)");
    check2(__alignof__(lv), 4, "__alignof__(STT0196)");
    check_field_offset(lv, fa, 0, "STT0196.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0196");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0196");
    check_field_offset(lv, fb, 4, "STT0196.fb");
  }
}
static Arrange_To_Call_Me vSTT0196(Test_STT0196, "STT0196", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0206  {
  char fa;
  unsigned int bf:8;
  float fb;
};
//SIG(1 STT0206) C1{ Fc Fi:8 Fi}



static void Test_STT0206()
{
  {
    init_simple_test("STT0206");
    static STT0206 lv;
    check2(sizeof(lv), 8, "sizeof(STT0206)");
    check2(__alignof__(lv), 4, "__alignof__(STT0206)");
    check_field_offset(lv, fa, 0, "STT0206.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0206");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0206");
    check_field_offset(lv, fb, 4, "STT0206.fb");
  }
}
static Arrange_To_Call_Me vSTT0206(Test_STT0206, "STT0206", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0216  {
  char fa;
  __tsu64 bf:8;
  float fb;
};
//SIG(1 STT0216) C1{ Fc FL:8 Fi}



static void Test_STT0216()
{
  {
    init_simple_test("STT0216");
    static STT0216 lv;
    check2(sizeof(lv), 8, "sizeof(STT0216)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0216)");
    check_field_offset(lv, fa, 0, "STT0216.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0216");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0216");
    check_field_offset(lv, fb, 4, "STT0216.fb");
  }
}
static Arrange_To_Call_Me vSTT0216(Test_STT0216, "STT0216", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0226  {
  char fa;
  unsigned int bf:18;
  float fb;
};
//SIG(1 STT0226) C1{ Fc Fi:18 Fi}



static void Test_STT0226()
{
  {
    init_simple_test("STT0226");
    static STT0226 lv;
    check2(sizeof(lv), 8, "sizeof(STT0226)");
    check2(__alignof__(lv), 4, "__alignof__(STT0226)");
    check_field_offset(lv, fa, 0, "STT0226.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0226");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0226");
    check_field_offset(lv, fb, 4, "STT0226.fb");
  }
}
static Arrange_To_Call_Me vSTT0226(Test_STT0226, "STT0226", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0236  {
  char fa;
  __tsu64 bf:18;
  float fb;
};
//SIG(1 STT0236) C1{ Fc FL:18 Fi}



static void Test_STT0236()
{
  {
    init_simple_test("STT0236");
    static STT0236 lv;
    check2(sizeof(lv), 8, "sizeof(STT0236)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0236)");
    check_field_offset(lv, fa, 0, "STT0236.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0236");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0236");
    check_field_offset(lv, fb, 4, "STT0236.fb");
  }
}
static Arrange_To_Call_Me vSTT0236(Test_STT0236, "STT0236", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0246  {
  char fa;
  __tsu64 bf:48;
  float fb;
};
//SIG(1 STT0246) C1{ Fc FL:48 Fi}



static void Test_STT0246()
{
  {
    init_simple_test("STT0246");
    static STT0246 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0246)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0246)");
    check_field_offset(lv, fa, 0, "STT0246.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0246");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0246");
    check_field_offset(lv, fb, 8, "STT0246.fb");
  }
}
static Arrange_To_Call_Me vSTT0246(Test_STT0246, "STT0246", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT017  {
  char fa;
  unsigned char  :0;
  double fb;
};
//SIG(1 STT017) C1{ Fc Fc:0 FL}



static void Test_STT017()
{
  {
    init_simple_test("STT017");
    static STT017 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT017)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT017)");
    check_field_offset(lv, fa, 0, "STT017.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT017.fb");
  }
}
static Arrange_To_Call_Me vSTT017(Test_STT017, "STT017", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT027  {
  char fa;
  unsigned short  :0;
  double fb;
};
//SIG(1 STT027) C1{ Fc Fs:0 FL}



static void Test_STT027()
{
  {
    init_simple_test("STT027");
    static STT027 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT027)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT027)");
    check_field_offset(lv, fa, 0, "STT027.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT027.fb");
  }
}
static Arrange_To_Call_Me vSTT027(Test_STT027, "STT027", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT037  {
  char fa;
  unsigned int  :0;
  double fb;
};
//SIG(1 STT037) C1{ Fc Fi:0 FL}



static void Test_STT037()
{
  {
    init_simple_test("STT037");
    static STT037 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT037)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT037)");
    check_field_offset(lv, fa, 0, "STT037.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT037.fb");
  }
}
static Arrange_To_Call_Me vSTT037(Test_STT037, "STT037", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT047  {
  char fa;
  __tsu64  :0;
  double fb;
};
//SIG(1 STT047) C1{ Fc FL:0 FL}



static void Test_STT047()
{
  {
    init_simple_test("STT047");
    static STT047 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT047)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT047)");
    check_field_offset(lv, fa, 0, "STT047.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT047.fb");
  }
}
static Arrange_To_Call_Me vSTT047(Test_STT047, "STT047", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT057  {
  char fa;
  unsigned char  :3;
  double fb;
};
//SIG(1 STT057) C1{ Fc Fc:3 FL}



static void Test_STT057()
{
  {
    init_simple_test("STT057");
    static STT057 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT057)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT057)");
    check_field_offset(lv, fa, 0, "STT057.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT057.fb");
  }
}
static Arrange_To_Call_Me vSTT057(Test_STT057, "STT057", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT067  {
  char fa;
  unsigned short  :3;
  double fb;
};
//SIG(1 STT067) C1{ Fc Fs:3 FL}



static void Test_STT067()
{
  {
    init_simple_test("STT067");
    static STT067 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT067)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT067)");
    check_field_offset(lv, fa, 0, "STT067.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT067.fb");
  }
}
static Arrange_To_Call_Me vSTT067(Test_STT067, "STT067", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT077  {
  char fa;
  unsigned int  :3;
  double fb;
};
//SIG(1 STT077) C1{ Fc Fi:3 FL}



static void Test_STT077()
{
  {
    init_simple_test("STT077");
    static STT077 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT077)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT077)");
    check_field_offset(lv, fa, 0, "STT077.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT077.fb");
  }
}
static Arrange_To_Call_Me vSTT077(Test_STT077, "STT077", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT087  {
  char fa;
  __tsu64  :3;
  double fb;
};
//SIG(1 STT087) C1{ Fc FL:3 FL}



static void Test_STT087()
{
  {
    init_simple_test("STT087");
    static STT087 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT087)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT087)");
    check_field_offset(lv, fa, 0, "STT087.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT087.fb");
  }
}
static Arrange_To_Call_Me vSTT087(Test_STT087, "STT087", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT097  {
  char fa;
  unsigned short  :8;
  double fb;
};
//SIG(1 STT097) C1{ Fc Fs:8 FL}



static void Test_STT097()
{
  {
    init_simple_test("STT097");
    static STT097 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT097)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT097)");
    check_field_offset(lv, fa, 0, "STT097.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT097.fb");
  }
}
static Arrange_To_Call_Me vSTT097(Test_STT097, "STT097", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0107  {
  char fa;
  unsigned int  :8;
  double fb;
};
//SIG(1 STT0107) C1{ Fc Fi:8 FL}



static void Test_STT0107()
{
  {
    init_simple_test("STT0107");
    static STT0107 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0107)");
    check_field_offset(lv, fa, 0, "STT0107.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0107.fb");
  }
}
static Arrange_To_Call_Me vSTT0107(Test_STT0107, "STT0107", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0117  {
  char fa;
  __tsu64  :8;
  double fb;
};
//SIG(1 STT0117) C1{ Fc FL:8 FL}



static void Test_STT0117()
{
  {
    init_simple_test("STT0117");
    static STT0117 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0117)");
    check_field_offset(lv, fa, 0, "STT0117.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0117.fb");
  }
}
static Arrange_To_Call_Me vSTT0117(Test_STT0117, "STT0117", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0127  {
  char fa;
  unsigned int  :18;
  double fb;
};
//SIG(1 STT0127) C1{ Fc Fi:18 FL}



static void Test_STT0127()
{
  {
    init_simple_test("STT0127");
    static STT0127 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0127)");
    check_field_offset(lv, fa, 0, "STT0127.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0127.fb");
  }
}
static Arrange_To_Call_Me vSTT0127(Test_STT0127, "STT0127", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0137  {
  char fa;
  __tsu64  :18;
  double fb;
};
//SIG(1 STT0137) C1{ Fc FL:18 FL}



static void Test_STT0137()
{
  {
    init_simple_test("STT0137");
    static STT0137 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0137)");
    check_field_offset(lv, fa, 0, "STT0137.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0137.fb");
  }
}
static Arrange_To_Call_Me vSTT0137(Test_STT0137, "STT0137", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0147  {
  char fa;
  __tsu64  :48;
  double fb;
};
//SIG(1 STT0147) C1{ Fc FL:48 FL}



static void Test_STT0147()
{
  {
    init_simple_test("STT0147");
    static STT0147 lv;
    check2(sizeof(lv), 16, "sizeof(STT0147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0147)");
    check_field_offset(lv, fa, 0, "STT0147.fa");
    check_field_offset(lv, fb, 8, "STT0147.fb");
  }
}
static Arrange_To_Call_Me vSTT0147(Test_STT0147, "STT0147", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0157  {
  char fa;
  unsigned char bf:3;
  double fb;
};
//SIG(1 STT0157) C1{ Fc Fc:3 FL}



static void Test_STT0157()
{
  {
    init_simple_test("STT0157");
    static STT0157 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0157)");
    check_field_offset(lv, fa, 0, "STT0157.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0157");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0157");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0157.fb");
  }
}
static Arrange_To_Call_Me vSTT0157(Test_STT0157, "STT0157", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0167  {
  char fa;
  unsigned short bf:3;
  double fb;
};
//SIG(1 STT0167) C1{ Fc Fs:3 FL}



static void Test_STT0167()
{
  {
    init_simple_test("STT0167");
    static STT0167 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0167)");
    check_field_offset(lv, fa, 0, "STT0167.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0167");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0167");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0167.fb");
  }
}
static Arrange_To_Call_Me vSTT0167(Test_STT0167, "STT0167", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0177  {
  char fa;
  unsigned int bf:3;
  double fb;
};
//SIG(1 STT0177) C1{ Fc Fi:3 FL}



static void Test_STT0177()
{
  {
    init_simple_test("STT0177");
    static STT0177 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0177)");
    check_field_offset(lv, fa, 0, "STT0177.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0177");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0177");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0177.fb");
  }
}
static Arrange_To_Call_Me vSTT0177(Test_STT0177, "STT0177", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0187  {
  char fa;
  __tsu64 bf:3;
  double fb;
};
//SIG(1 STT0187) C1{ Fc FL:3 FL}



static void Test_STT0187()
{
  {
    init_simple_test("STT0187");
    static STT0187 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0187)");
    check_field_offset(lv, fa, 0, "STT0187.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0187");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0187");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0187.fb");
  }
}
static Arrange_To_Call_Me vSTT0187(Test_STT0187, "STT0187", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0197  {
  char fa;
  unsigned short bf:8;
  double fb;
};
//SIG(1 STT0197) C1{ Fc Fs:8 FL}



static void Test_STT0197()
{
  {
    init_simple_test("STT0197");
    static STT0197 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0197)");
    check_field_offset(lv, fa, 0, "STT0197.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0197");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0197");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0197.fb");
  }
}
static Arrange_To_Call_Me vSTT0197(Test_STT0197, "STT0197", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0207  {
  char fa;
  unsigned int bf:8;
  double fb;
};
//SIG(1 STT0207) C1{ Fc Fi:8 FL}



static void Test_STT0207()
{
  {
    init_simple_test("STT0207");
    static STT0207 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0207)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0207)");
    check_field_offset(lv, fa, 0, "STT0207.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0207");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0207");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0207.fb");
  }
}
static Arrange_To_Call_Me vSTT0207(Test_STT0207, "STT0207", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0217  {
  char fa;
  __tsu64 bf:8;
  double fb;
};
//SIG(1 STT0217) C1{ Fc FL:8 FL}



static void Test_STT0217()
{
  {
    init_simple_test("STT0217");
    static STT0217 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0217)");
    check_field_offset(lv, fa, 0, "STT0217.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0217");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0217");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0217.fb");
  }
}
static Arrange_To_Call_Me vSTT0217(Test_STT0217, "STT0217", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0227  {
  char fa;
  unsigned int bf:18;
  double fb;
};
//SIG(1 STT0227) C1{ Fc Fi:18 FL}



static void Test_STT0227()
{
  {
    init_simple_test("STT0227");
    static STT0227 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0227)");
    check_field_offset(lv, fa, 0, "STT0227.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0227");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0227");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0227.fb");
  }
}
static Arrange_To_Call_Me vSTT0227(Test_STT0227, "STT0227", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0237  {
  char fa;
  __tsu64 bf:18;
  double fb;
};
//SIG(1 STT0237) C1{ Fc FL:18 FL}



static void Test_STT0237()
{
  {
    init_simple_test("STT0237");
    static STT0237 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT0237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0237)");
    check_field_offset(lv, fa, 0, "STT0237.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0237");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0237");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT0237.fb");
  }
}
static Arrange_To_Call_Me vSTT0237(Test_STT0237, "STT0237", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0247  {
  char fa;
  __tsu64 bf:48;
  double fb;
};
//SIG(1 STT0247) C1{ Fc FL:48 FL}



static void Test_STT0247()
{
  {
    init_simple_test("STT0247");
    static STT0247 lv;
    check2(sizeof(lv), 16, "sizeof(STT0247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0247)");
    check_field_offset(lv, fa, 0, "STT0247.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0247");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0247");
    check_field_offset(lv, fb, 8, "STT0247.fb");
  }
}
static Arrange_To_Call_Me vSTT0247(Test_STT0247, "STT0247", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT018  {
  char fa;
  unsigned char  :0;
  long double fb;
};
//SIG(1 STT018) C1{ Fc Fc:0 FD}



static void Test_STT018()
{
  {
    init_simple_test("STT018");
    static STT018 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT018)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT018)");
    check_field_offset(lv, fa, 0, "STT018.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT018.fb");
  }
}
static Arrange_To_Call_Me vSTT018(Test_STT018, "STT018", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT028  {
  char fa;
  unsigned short  :0;
  long double fb;
};
//SIG(1 STT028) C1{ Fc Fs:0 FD}



static void Test_STT028()
{
  {
    init_simple_test("STT028");
    static STT028 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT028)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT028)");
    check_field_offset(lv, fa, 0, "STT028.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT028.fb");
  }
}
static Arrange_To_Call_Me vSTT028(Test_STT028, "STT028", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT038  {
  char fa;
  unsigned int  :0;
  long double fb;
};
//SIG(1 STT038) C1{ Fc Fi:0 FD}



static void Test_STT038()
{
  {
    init_simple_test("STT038");
    static STT038 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT038)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT038)");
    check_field_offset(lv, fa, 0, "STT038.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT038.fb");
  }
}
static Arrange_To_Call_Me vSTT038(Test_STT038, "STT038", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT048  {
  char fa;
  __tsu64  :0;
  long double fb;
};
//SIG(1 STT048) C1{ Fc FL:0 FD}



static void Test_STT048()
{
  {
    init_simple_test("STT048");
    static STT048 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT048)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT048)");
    check_field_offset(lv, fa, 0, "STT048.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT048.fb");
  }
}
static Arrange_To_Call_Me vSTT048(Test_STT048, "STT048", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT058  {
  char fa;
  unsigned char  :3;
  long double fb;
};
//SIG(1 STT058) C1{ Fc Fc:3 FD}



static void Test_STT058()
{
  {
    init_simple_test("STT058");
    static STT058 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT058)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT058)");
    check_field_offset(lv, fa, 0, "STT058.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT058.fb");
  }
}
static Arrange_To_Call_Me vSTT058(Test_STT058, "STT058", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT068  {
  char fa;
  unsigned short  :3;
  long double fb;
};
//SIG(1 STT068) C1{ Fc Fs:3 FD}



static void Test_STT068()
{
  {
    init_simple_test("STT068");
    static STT068 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT068)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT068)");
    check_field_offset(lv, fa, 0, "STT068.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT068.fb");
  }
}
static Arrange_To_Call_Me vSTT068(Test_STT068, "STT068", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT078  {
  char fa;
  unsigned int  :3;
  long double fb;
};
//SIG(1 STT078) C1{ Fc Fi:3 FD}



static void Test_STT078()
{
  {
    init_simple_test("STT078");
    static STT078 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT078)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT078)");
    check_field_offset(lv, fa, 0, "STT078.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT078.fb");
  }
}
static Arrange_To_Call_Me vSTT078(Test_STT078, "STT078", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT088  {
  char fa;
  __tsu64  :3;
  long double fb;
};
//SIG(1 STT088) C1{ Fc FL:3 FD}



static void Test_STT088()
{
  {
    init_simple_test("STT088");
    static STT088 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT088)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT088)");
    check_field_offset(lv, fa, 0, "STT088.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT088.fb");
  }
}
static Arrange_To_Call_Me vSTT088(Test_STT088, "STT088", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT098  {
  char fa;
  unsigned short  :8;
  long double fb;
};
//SIG(1 STT098) C1{ Fc Fs:8 FD}



static void Test_STT098()
{
  {
    init_simple_test("STT098");
    static STT098 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT098)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT098)");
    check_field_offset(lv, fa, 0, "STT098.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT098.fb");
  }
}
static Arrange_To_Call_Me vSTT098(Test_STT098, "STT098", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0108  {
  char fa;
  unsigned int  :8;
  long double fb;
};
//SIG(1 STT0108) C1{ Fc Fi:8 FD}



static void Test_STT0108()
{
  {
    init_simple_test("STT0108");
    static STT0108 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0108)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0108)");
    check_field_offset(lv, fa, 0, "STT0108.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0108.fb");
  }
}
static Arrange_To_Call_Me vSTT0108(Test_STT0108, "STT0108", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0118  {
  char fa;
  __tsu64  :8;
  long double fb;
};
//SIG(1 STT0118) C1{ Fc FL:8 FD}



static void Test_STT0118()
{
  {
    init_simple_test("STT0118");
    static STT0118 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0118)");
    check_field_offset(lv, fa, 0, "STT0118.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0118.fb");
  }
}
static Arrange_To_Call_Me vSTT0118(Test_STT0118, "STT0118", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0128  {
  char fa;
  unsigned int  :18;
  long double fb;
};
//SIG(1 STT0128) C1{ Fc Fi:18 FD}



static void Test_STT0128()
{
  {
    init_simple_test("STT0128");
    static STT0128 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0128)");
    check_field_offset(lv, fa, 0, "STT0128.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0128.fb");
  }
}
static Arrange_To_Call_Me vSTT0128(Test_STT0128, "STT0128", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0138  {
  char fa;
  __tsu64  :18;
  long double fb;
};
//SIG(1 STT0138) C1{ Fc FL:18 FD}



static void Test_STT0138()
{
  {
    init_simple_test("STT0138");
    static STT0138 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0138)");
    check_field_offset(lv, fa, 0, "STT0138.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0138.fb");
  }
}
static Arrange_To_Call_Me vSTT0138(Test_STT0138, "STT0138", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0148  {
  char fa;
  __tsu64  :48;
  long double fb;
};
//SIG(1 STT0148) C1{ Fc FL:48 FD}



static void Test_STT0148()
{
  {
    init_simple_test("STT0148");
    static STT0148 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT0148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0148)");
    check_field_offset(lv, fa, 0, "STT0148.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT0148.fb");
  }
}
static Arrange_To_Call_Me vSTT0148(Test_STT0148, "STT0148", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0158  {
  char fa;
  unsigned char bf:3;
  long double fb;
};
//SIG(1 STT0158) C1{ Fc Fc:3 FD}



static void Test_STT0158()
{
  {
    init_simple_test("STT0158");
    static STT0158 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0158)");
    check_field_offset(lv, fa, 0, "STT0158.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0158");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0158");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0158.fb");
  }
}
static Arrange_To_Call_Me vSTT0158(Test_STT0158, "STT0158", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0168  {
  char fa;
  unsigned short bf:3;
  long double fb;
};
//SIG(1 STT0168) C1{ Fc Fs:3 FD}



static void Test_STT0168()
{
  {
    init_simple_test("STT0168");
    static STT0168 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0168)");
    check_field_offset(lv, fa, 0, "STT0168.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0168");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0168");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0168.fb");
  }
}
static Arrange_To_Call_Me vSTT0168(Test_STT0168, "STT0168", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0178  {
  char fa;
  unsigned int bf:3;
  long double fb;
};
//SIG(1 STT0178) C1{ Fc Fi:3 FD}



static void Test_STT0178()
{
  {
    init_simple_test("STT0178");
    static STT0178 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0178)");
    check_field_offset(lv, fa, 0, "STT0178.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0178");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0178");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0178.fb");
  }
}
static Arrange_To_Call_Me vSTT0178(Test_STT0178, "STT0178", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0188  {
  char fa;
  __tsu64 bf:3;
  long double fb;
};
//SIG(1 STT0188) C1{ Fc FL:3 FD}



static void Test_STT0188()
{
  {
    init_simple_test("STT0188");
    static STT0188 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0188)");
    check_field_offset(lv, fa, 0, "STT0188.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0188");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0188");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0188.fb");
  }
}
static Arrange_To_Call_Me vSTT0188(Test_STT0188, "STT0188", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0198  {
  char fa;
  unsigned short bf:8;
  long double fb;
};
//SIG(1 STT0198) C1{ Fc Fs:8 FD}



static void Test_STT0198()
{
  {
    init_simple_test("STT0198");
    static STT0198 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0198)");
    check_field_offset(lv, fa, 0, "STT0198.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0198");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0198");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0198.fb");
  }
}
static Arrange_To_Call_Me vSTT0198(Test_STT0198, "STT0198", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0208  {
  char fa;
  unsigned int bf:8;
  long double fb;
};
//SIG(1 STT0208) C1{ Fc Fi:8 FD}



static void Test_STT0208()
{
  {
    init_simple_test("STT0208");
    static STT0208 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0208)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0208)");
    check_field_offset(lv, fa, 0, "STT0208.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0208");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0208");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0208.fb");
  }
}
static Arrange_To_Call_Me vSTT0208(Test_STT0208, "STT0208", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0218  {
  char fa;
  __tsu64 bf:8;
  long double fb;
};
//SIG(1 STT0218) C1{ Fc FL:8 FD}



static void Test_STT0218()
{
  {
    init_simple_test("STT0218");
    static STT0218 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0218)");
    check_field_offset(lv, fa, 0, "STT0218.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0218");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0218");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0218.fb");
  }
}
static Arrange_To_Call_Me vSTT0218(Test_STT0218, "STT0218", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0228  {
  char fa;
  unsigned int bf:18;
  long double fb;
};
//SIG(1 STT0228) C1{ Fc Fi:18 FD}



static void Test_STT0228()
{
  {
    init_simple_test("STT0228");
    static STT0228 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0228)");
    check_field_offset(lv, fa, 0, "STT0228.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0228");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0228");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0228.fb");
  }
}
static Arrange_To_Call_Me vSTT0228(Test_STT0228, "STT0228", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0238  {
  char fa;
  __tsu64 bf:18;
  long double fb;
};
//SIG(1 STT0238) C1{ Fc FL:18 FD}



static void Test_STT0238()
{
  {
    init_simple_test("STT0238");
    static STT0238 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT0238)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0238)");
    check_field_offset(lv, fa, 0, "STT0238.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0238");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0238");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT0238.fb");
  }
}
static Arrange_To_Call_Me vSTT0238(Test_STT0238, "STT0238", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0248  {
  char fa;
  __tsu64 bf:48;
  long double fb;
};
//SIG(1 STT0248) C1{ Fc FL:48 FD}



static void Test_STT0248()
{
  {
    init_simple_test("STT0248");
    static STT0248 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT0248)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT0248)");
    check_field_offset(lv, fa, 0, "STT0248.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0248");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0248");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT0248.fb");
  }
}
static Arrange_To_Call_Me vSTT0248(Test_STT0248, "STT0248", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT019  {
  char fa;
  unsigned char  :0;
};
//SIG(1 STT019) C1{ Fc Fc:0}



static void Test_STT019()
{
  {
    init_simple_test("STT019");
    static STT019 lv;
    check2(sizeof(lv), 1, "sizeof(STT019)");
    check2(__alignof__(lv), 1, "__alignof__(STT019)");
    check_field_offset(lv, fa, 0, "STT019.fa");
  }
}
static Arrange_To_Call_Me vSTT019(Test_STT019, "STT019", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT029  {
  char fa;
  unsigned short  :0;
};
//SIG(1 STT029) C1{ Fc Fs:0}



static void Test_STT029()
{
  {
    init_simple_test("STT029");
    static STT029 lv;
    check2(sizeof(lv), 2, "sizeof(STT029)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT029)");
    check_field_offset(lv, fa, 0, "STT029.fa");
  }
}
static Arrange_To_Call_Me vSTT029(Test_STT029, "STT029", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT039  {
  char fa;
  unsigned int  :0;
};
//SIG(1 STT039) C1{ Fc Fi:0}



static void Test_STT039()
{
  {
    init_simple_test("STT039");
    static STT039 lv;
    check2(sizeof(lv), 4, "sizeof(STT039)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT039)");
    check_field_offset(lv, fa, 0, "STT039.fa");
  }
}
static Arrange_To_Call_Me vSTT039(Test_STT039, "STT039", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT049  {
  char fa;
  __tsu64  :0;
};
//SIG(1 STT049) C1{ Fc FL:0}



static void Test_STT049()
{
  {
    init_simple_test("STT049");
    static STT049 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT049)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT049)");
    check_field_offset(lv, fa, 0, "STT049.fa");
  }
}
static Arrange_To_Call_Me vSTT049(Test_STT049, "STT049", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT059  {
  char fa;
  unsigned char  :3;
};
//SIG(1 STT059) C1{ Fc Fc:3}



static void Test_STT059()
{
  {
    init_simple_test("STT059");
    static STT059 lv;
    check2(sizeof(lv), 2, "sizeof(STT059)");
    check2(__alignof__(lv), 1, "__alignof__(STT059)");
    check_field_offset(lv, fa, 0, "STT059.fa");
  }
}
static Arrange_To_Call_Me vSTT059(Test_STT059, "STT059", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT069  {
  char fa;
  unsigned short  :3;
};
//SIG(1 STT069) C1{ Fc Fs:3}



static void Test_STT069()
{
  {
    init_simple_test("STT069");
    static STT069 lv;
    check2(sizeof(lv), 2, "sizeof(STT069)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT069)");
    check_field_offset(lv, fa, 0, "STT069.fa");
  }
}
static Arrange_To_Call_Me vSTT069(Test_STT069, "STT069", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT079  {
  char fa;
  unsigned int  :3;
};
//SIG(1 STT079) C1{ Fc Fi:3}



static void Test_STT079()
{
  {
    init_simple_test("STT079");
    static STT079 lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(STT079)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT079)");
    check_field_offset(lv, fa, 0, "STT079.fa");
  }
}
static Arrange_To_Call_Me vSTT079(Test_STT079, "STT079", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT089  {
  char fa;
  __tsu64  :3;
};
//SIG(1 STT089) C1{ Fc FL:3}



static void Test_STT089()
{
  {
    init_simple_test("STT089");
    static STT089 lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(STT089)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT089)");
    check_field_offset(lv, fa, 0, "STT089.fa");
  }
}
static Arrange_To_Call_Me vSTT089(Test_STT089, "STT089", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT099  {
  char fa;
  unsigned short  :8;
};
//SIG(1 STT099) C1{ Fc Fs:8}



static void Test_STT099()
{
  {
    init_simple_test("STT099");
    static STT099 lv;
    check2(sizeof(lv), 2, "sizeof(STT099)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT099)");
    check_field_offset(lv, fa, 0, "STT099.fa");
  }
}
static Arrange_To_Call_Me vSTT099(Test_STT099, "STT099", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0109  {
  char fa;
  unsigned int  :8;
};
//SIG(1 STT0109) C1{ Fc Fi:8}



static void Test_STT0109()
{
  {
    init_simple_test("STT0109");
    static STT0109 lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(STT0109)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0109)");
    check_field_offset(lv, fa, 0, "STT0109.fa");
  }
}
static Arrange_To_Call_Me vSTT0109(Test_STT0109, "STT0109", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0119  {
  char fa;
  __tsu64  :8;
};
//SIG(1 STT0119) C1{ Fc FL:8}



static void Test_STT0119()
{
  {
    init_simple_test("STT0119");
    static STT0119 lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(STT0119)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0119)");
    check_field_offset(lv, fa, 0, "STT0119.fa");
  }
}
static Arrange_To_Call_Me vSTT0119(Test_STT0119, "STT0119", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0129  {
  char fa;
  unsigned int  :18;
};
//SIG(1 STT0129) C1{ Fc Fi:18}



static void Test_STT0129()
{
  {
    init_simple_test("STT0129");
    static STT0129 lv;
    check2(sizeof(lv), 4, "sizeof(STT0129)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0129)");
    check_field_offset(lv, fa, 0, "STT0129.fa");
  }
}
static Arrange_To_Call_Me vSTT0129(Test_STT0129, "STT0129", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0139  {
  char fa;
  __tsu64  :18;
};
//SIG(1 STT0139) C1{ Fc FL:18}



static void Test_STT0139()
{
  {
    init_simple_test("STT0139");
    static STT0139 lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(STT0139)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0139)");
    check_field_offset(lv, fa, 0, "STT0139.fa");
  }
}
static Arrange_To_Call_Me vSTT0139(Test_STT0139, "STT0139", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0149  {
  char fa;
  __tsu64  :48;
};
//SIG(1 STT0149) C1{ Fc FL:48}



static void Test_STT0149()
{
  {
    init_simple_test("STT0149");
    static STT0149 lv;
    check2(sizeof(lv), ABISELECT(7,7), "sizeof(STT0149)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(STT0149)");
    check_field_offset(lv, fa, 0, "STT0149.fa");
  }
}
static Arrange_To_Call_Me vSTT0149(Test_STT0149, "STT0149", ABISELECT(7,7));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0159  {
  char fa;
  unsigned char bf:3;
};
//SIG(1 STT0159) C1{ Fc Fc:3}



static void Test_STT0159()
{
  {
    init_simple_test("STT0159");
    static STT0159 lv;
    check2(sizeof(lv), 2, "sizeof(STT0159)");
    check2(__alignof__(lv), 1, "__alignof__(STT0159)");
    check_field_offset(lv, fa, 0, "STT0159.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0159");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0159");
  }
}
static Arrange_To_Call_Me vSTT0159(Test_STT0159, "STT0159", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0169  {
  char fa;
  unsigned short bf:3;
};
//SIG(1 STT0169) C1{ Fc Fs:3}



static void Test_STT0169()
{
  {
    init_simple_test("STT0169");
    static STT0169 lv;
    check2(sizeof(lv), 2, "sizeof(STT0169)");
    check2(__alignof__(lv), 2, "__alignof__(STT0169)");
    check_field_offset(lv, fa, 0, "STT0169.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0169");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0169");
  }
}
static Arrange_To_Call_Me vSTT0169(Test_STT0169, "STT0169", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0179  {
  char fa;
  unsigned int bf:3;
};
//SIG(1 STT0179) C1{ Fc Fi:3}



static void Test_STT0179()
{
  {
    init_simple_test("STT0179");
    static STT0179 lv;
    check2(sizeof(lv), 4, "sizeof(STT0179)");
    check2(__alignof__(lv), 4, "__alignof__(STT0179)");
    check_field_offset(lv, fa, 0, "STT0179.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0179");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0179");
  }
}
static Arrange_To_Call_Me vSTT0179(Test_STT0179, "STT0179", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0189  {
  char fa;
  __tsu64 bf:3;
};
//SIG(1 STT0189) C1{ Fc FL:3}



static void Test_STT0189()
{
  {
    init_simple_test("STT0189");
    static STT0189 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT0189)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0189)");
    check_field_offset(lv, fa, 0, "STT0189.fa");
    set_bf_and_test(lv, bf, 1, 0, 3, 1, "STT0189");
    set_bf_and_test(lv, bf, 1, 0, 3, hide_ull(1LL<<2), "STT0189");
  }
}
static Arrange_To_Call_Me vSTT0189(Test_STT0189, "STT0189", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0199  {
  char fa;
  unsigned short bf:8;
};
//SIG(1 STT0199) C1{ Fc Fs:8}



static void Test_STT0199()
{
  {
    init_simple_test("STT0199");
    static STT0199 lv;
    check2(sizeof(lv), 2, "sizeof(STT0199)");
    check2(__alignof__(lv), 2, "__alignof__(STT0199)");
    check_field_offset(lv, fa, 0, "STT0199.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0199");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0199");
  }
}
static Arrange_To_Call_Me vSTT0199(Test_STT0199, "STT0199", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0209  {
  char fa;
  unsigned int bf:8;
};
//SIG(1 STT0209) C1{ Fc Fi:8}



static void Test_STT0209()
{
  {
    init_simple_test("STT0209");
    static STT0209 lv;
    check2(sizeof(lv), 4, "sizeof(STT0209)");
    check2(__alignof__(lv), 4, "__alignof__(STT0209)");
    check_field_offset(lv, fa, 0, "STT0209.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0209");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0209");
  }
}
static Arrange_To_Call_Me vSTT0209(Test_STT0209, "STT0209", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0219  {
  char fa;
  __tsu64 bf:8;
};
//SIG(1 STT0219) C1{ Fc FL:8}



static void Test_STT0219()
{
  {
    init_simple_test("STT0219");
    static STT0219 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT0219)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0219)");
    check_field_offset(lv, fa, 0, "STT0219.fa");
    set_bf_and_test(lv, bf, 1, 0, 8, 1, "STT0219");
    set_bf_and_test(lv, bf, 1, 0, 8, hide_ull(1LL<<7), "STT0219");
  }
}
static Arrange_To_Call_Me vSTT0219(Test_STT0219, "STT0219", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0229  {
  char fa;
  unsigned int bf:18;
};
//SIG(1 STT0229) C1{ Fc Fi:18}



static void Test_STT0229()
{
  {
    init_simple_test("STT0229");
    static STT0229 lv;
    check2(sizeof(lv), 4, "sizeof(STT0229)");
    check2(__alignof__(lv), 4, "__alignof__(STT0229)");
    check_field_offset(lv, fa, 0, "STT0229.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0229");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0229");
  }
}
static Arrange_To_Call_Me vSTT0229(Test_STT0229, "STT0229", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0239  {
  char fa;
  __tsu64 bf:18;
};
//SIG(1 STT0239) C1{ Fc FL:18}



static void Test_STT0239()
{
  {
    init_simple_test("STT0239");
    static STT0239 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT0239)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0239)");
    check_field_offset(lv, fa, 0, "STT0239.fa");
    set_bf_and_test(lv, bf, 1, 0, 18, 1, "STT0239");
    set_bf_and_test(lv, bf, 1, 0, 18, hide_ull(1LL<<17), "STT0239");
  }
}
static Arrange_To_Call_Me vSTT0239(Test_STT0239, "STT0239", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT0249  {
  char fa;
  __tsu64 bf:48;
};
//SIG(1 STT0249) C1{ Fc FL:48}



static void Test_STT0249()
{
  {
    init_simple_test("STT0249");
    static STT0249 lv;
    check2(sizeof(lv), 8, "sizeof(STT0249)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT0249)");
    check_field_offset(lv, fa, 0, "STT0249.fa");
    set_bf_and_test(lv, bf, 1, 0, 48, 1, "STT0249");
    set_bf_and_test(lv, bf, 1, 0, 48, hide_ull(1LL<<47), "STT0249");
  }
}
static Arrange_To_Call_Me vSTT0249(Test_STT0249, "STT0249", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT110  {
  short fa;
  unsigned char  :0;
  char fb;
};
//SIG(1 STT110) C1{ Fs Fc:0 Fc}



static void Test_STT110()
{
  {
    init_simple_test("STT110");
    static STT110 lv;
    check2(sizeof(lv), 4, "sizeof(STT110)");
    check2(__alignof__(lv), 2, "__alignof__(STT110)");
    check_field_offset(lv, fa, 0, "STT110.fa");
    check_field_offset(lv, fb, 2, "STT110.fb");
  }
}
static Arrange_To_Call_Me vSTT110(Test_STT110, "STT110", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT120  {
  short fa;
  unsigned short  :0;
  char fb;
};
//SIG(1 STT120) C1{ Fs Fs:0 Fc}



static void Test_STT120()
{
  {
    init_simple_test("STT120");
    static STT120 lv;
    check2(sizeof(lv), 4, "sizeof(STT120)");
    check2(__alignof__(lv), 2, "__alignof__(STT120)");
    check_field_offset(lv, fa, 0, "STT120.fa");
    check_field_offset(lv, fb, 2, "STT120.fb");
  }
}
static Arrange_To_Call_Me vSTT120(Test_STT120, "STT120", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT130  {
  short fa;
  unsigned int  :0;
  char fb;
};
//SIG(1 STT130) C1{ Fs Fi:0 Fc}



static void Test_STT130()
{
  {
    init_simple_test("STT130");
    static STT130 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT130)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT130)");
    check_field_offset(lv, fa, 0, "STT130.fa");
    check_field_offset(lv, fb, 4, "STT130.fb");
  }
}
static Arrange_To_Call_Me vSTT130(Test_STT130, "STT130", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT140  {
  short fa;
  __tsu64  :0;
  char fb;
};
//SIG(1 STT140) C1{ Fs FL:0 Fc}



static void Test_STT140()
{
  {
    init_simple_test("STT140");
    static STT140 lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(STT140)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT140)");
    check_field_offset(lv, fa, 0, "STT140.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT140.fb");
  }
}
static Arrange_To_Call_Me vSTT140(Test_STT140, "STT140", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT150  {
  short fa;
  unsigned char  :3;
  char fb;
};
//SIG(1 STT150) C1{ Fs Fc:3 Fc}



static void Test_STT150()
{
  {
    init_simple_test("STT150");
    static STT150 lv;
    check2(sizeof(lv), 4, "sizeof(STT150)");
    check2(__alignof__(lv), 2, "__alignof__(STT150)");
    check_field_offset(lv, fa, 0, "STT150.fa");
    check_field_offset(lv, fb, 3, "STT150.fb");
  }
}
static Arrange_To_Call_Me vSTT150(Test_STT150, "STT150", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT160  {
  short fa;
  unsigned short  :3;
  char fb;
};
//SIG(1 STT160) C1{ Fs Fs:3 Fc}



static void Test_STT160()
{
  {
    init_simple_test("STT160");
    static STT160 lv;
    check2(sizeof(lv), 4, "sizeof(STT160)");
    check2(__alignof__(lv), 2, "__alignof__(STT160)");
    check_field_offset(lv, fa, 0, "STT160.fa");
    check_field_offset(lv, fb, 3, "STT160.fb");
  }
}
static Arrange_To_Call_Me vSTT160(Test_STT160, "STT160", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT170  {
  short fa;
  unsigned int  :3;
  char fb;
};
//SIG(1 STT170) C1{ Fs Fi:3 Fc}



static void Test_STT170()
{
  {
    init_simple_test("STT170");
    static STT170 lv;
    check2(sizeof(lv), 4, "sizeof(STT170)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT170)");
    check_field_offset(lv, fa, 0, "STT170.fa");
    check_field_offset(lv, fb, 3, "STT170.fb");
  }
}
static Arrange_To_Call_Me vSTT170(Test_STT170, "STT170", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT180  {
  short fa;
  __tsu64  :3;
  char fb;
};
//SIG(1 STT180) C1{ Fs FL:3 Fc}



static void Test_STT180()
{
  {
    init_simple_test("STT180");
    static STT180 lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(STT180)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT180)");
    check_field_offset(lv, fa, 0, "STT180.fa");
    check_field_offset(lv, fb, 3, "STT180.fb");
  }
}
static Arrange_To_Call_Me vSTT180(Test_STT180, "STT180", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT190  {
  short fa;
  unsigned short  :8;
  char fb;
};
//SIG(1 STT190) C1{ Fs Fs:8 Fc}



static void Test_STT190()
{
  {
    init_simple_test("STT190");
    static STT190 lv;
    check2(sizeof(lv), 4, "sizeof(STT190)");
    check2(__alignof__(lv), 2, "__alignof__(STT190)");
    check_field_offset(lv, fa, 0, "STT190.fa");
    check_field_offset(lv, fb, 3, "STT190.fb");
  }
}
static Arrange_To_Call_Me vSTT190(Test_STT190, "STT190", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1100  {
  short fa;
  unsigned int  :8;
  char fb;
};
//SIG(1 STT1100) C1{ Fs Fi:8 Fc}



static void Test_STT1100()
{
  {
    init_simple_test("STT1100");
    static STT1100 lv;
    check2(sizeof(lv), 4, "sizeof(STT1100)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1100)");
    check_field_offset(lv, fa, 0, "STT1100.fa");
    check_field_offset(lv, fb, 3, "STT1100.fb");
  }
}
static Arrange_To_Call_Me vSTT1100(Test_STT1100, "STT1100", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1110  {
  short fa;
  __tsu64  :8;
  char fb;
};
//SIG(1 STT1110) C1{ Fs FL:8 Fc}



static void Test_STT1110()
{
  {
    init_simple_test("STT1110");
    static STT1110 lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(STT1110)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1110)");
    check_field_offset(lv, fa, 0, "STT1110.fa");
    check_field_offset(lv, fb, 3, "STT1110.fb");
  }
}
static Arrange_To_Call_Me vSTT1110(Test_STT1110, "STT1110", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1120  {
  short fa;
  unsigned int  :18;
  char fb;
};
//SIG(1 STT1120) C1{ Fs Fi:18 Fc}



static void Test_STT1120()
{
  {
    init_simple_test("STT1120");
    static STT1120 lv;
    check2(sizeof(lv), 8, "sizeof(STT1120)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1120)");
    check_field_offset(lv, fa, 0, "STT1120.fa");
    check_field_offset(lv, fb, 7, "STT1120.fb");
  }
}
static Arrange_To_Call_Me vSTT1120(Test_STT1120, "STT1120", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1130  {
  short fa;
  __tsu64  :18;
  char fb;
};
//SIG(1 STT1130) C1{ Fs FL:18 Fc}



static void Test_STT1130()
{
  {
    init_simple_test("STT1130");
    static STT1130 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT1130)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1130)");
    check_field_offset(lv, fa, 0, "STT1130.fa");
    check_field_offset(lv, fb, 5, "STT1130.fb");
  }
}
static Arrange_To_Call_Me vSTT1130(Test_STT1130, "STT1130", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1140  {
  short fa;
  __tsu64  :48;
  char fb;
};
//SIG(1 STT1140) C1{ Fs FL:48 Fc}



static void Test_STT1140()
{
  {
    init_simple_test("STT1140");
    static STT1140 lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(STT1140)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1140)");
    check_field_offset(lv, fa, 0, "STT1140.fa");
    check_field_offset(lv, fb, 8, "STT1140.fb");
  }
}
static Arrange_To_Call_Me vSTT1140(Test_STT1140, "STT1140", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1150  {
  short fa;
  unsigned char bf:3;
  char fb;
};
//SIG(1 STT1150) C1{ Fs Fc:3 Fc}



static void Test_STT1150()
{
  {
    init_simple_test("STT1150");
    static STT1150 lv;
    check2(sizeof(lv), 4, "sizeof(STT1150)");
    check2(__alignof__(lv), 2, "__alignof__(STT1150)");
    check_field_offset(lv, fa, 0, "STT1150.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1150");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1150");
    check_field_offset(lv, fb, 3, "STT1150.fb");
  }
}
static Arrange_To_Call_Me vSTT1150(Test_STT1150, "STT1150", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1160  {
  short fa;
  unsigned short bf:3;
  char fb;
};
//SIG(1 STT1160) C1{ Fs Fs:3 Fc}



static void Test_STT1160()
{
  {
    init_simple_test("STT1160");
    static STT1160 lv;
    check2(sizeof(lv), 4, "sizeof(STT1160)");
    check2(__alignof__(lv), 2, "__alignof__(STT1160)");
    check_field_offset(lv, fa, 0, "STT1160.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1160");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1160");
    check_field_offset(lv, fb, 3, "STT1160.fb");
  }
}
static Arrange_To_Call_Me vSTT1160(Test_STT1160, "STT1160", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1170  {
  short fa;
  unsigned int bf:3;
  char fb;
};
//SIG(1 STT1170) C1{ Fs Fi:3 Fc}



static void Test_STT1170()
{
  {
    init_simple_test("STT1170");
    static STT1170 lv;
    check2(sizeof(lv), 4, "sizeof(STT1170)");
    check2(__alignof__(lv), 4, "__alignof__(STT1170)");
    check_field_offset(lv, fa, 0, "STT1170.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1170");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1170");
    check_field_offset(lv, fb, 3, "STT1170.fb");
  }
}
static Arrange_To_Call_Me vSTT1170(Test_STT1170, "STT1170", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1180  {
  short fa;
  __tsu64 bf:3;
  char fb;
};
//SIG(1 STT1180) C1{ Fs FL:3 Fc}



static void Test_STT1180()
{
  {
    init_simple_test("STT1180");
    static STT1180 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT1180)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1180)");
    check_field_offset(lv, fa, 0, "STT1180.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1180");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1180");
    check_field_offset(lv, fb, 3, "STT1180.fb");
  }
}
static Arrange_To_Call_Me vSTT1180(Test_STT1180, "STT1180", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1190  {
  short fa;
  unsigned short bf:8;
  char fb;
};
//SIG(1 STT1190) C1{ Fs Fs:8 Fc}



static void Test_STT1190()
{
  {
    init_simple_test("STT1190");
    static STT1190 lv;
    check2(sizeof(lv), 4, "sizeof(STT1190)");
    check2(__alignof__(lv), 2, "__alignof__(STT1190)");
    check_field_offset(lv, fa, 0, "STT1190.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1190");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1190");
    check_field_offset(lv, fb, 3, "STT1190.fb");
  }
}
static Arrange_To_Call_Me vSTT1190(Test_STT1190, "STT1190", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1200  {
  short fa;
  unsigned int bf:8;
  char fb;
};
//SIG(1 STT1200) C1{ Fs Fi:8 Fc}



static void Test_STT1200()
{
  {
    init_simple_test("STT1200");
    static STT1200 lv;
    check2(sizeof(lv), 4, "sizeof(STT1200)");
    check2(__alignof__(lv), 4, "__alignof__(STT1200)");
    check_field_offset(lv, fa, 0, "STT1200.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1200");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1200");
    check_field_offset(lv, fb, 3, "STT1200.fb");
  }
}
static Arrange_To_Call_Me vSTT1200(Test_STT1200, "STT1200", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1210  {
  short fa;
  __tsu64 bf:8;
  char fb;
};
//SIG(1 STT1210) C1{ Fs FL:8 Fc}



static void Test_STT1210()
{
  {
    init_simple_test("STT1210");
    static STT1210 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT1210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1210)");
    check_field_offset(lv, fa, 0, "STT1210.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1210");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1210");
    check_field_offset(lv, fb, 3, "STT1210.fb");
  }
}
static Arrange_To_Call_Me vSTT1210(Test_STT1210, "STT1210", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1220  {
  short fa;
  unsigned int bf:18;
  char fb;
};
//SIG(1 STT1220) C1{ Fs Fi:18 Fc}



static void Test_STT1220()
{
  {
    init_simple_test("STT1220");
    static STT1220 lv;
    check2(sizeof(lv), 8, "sizeof(STT1220)");
    check2(__alignof__(lv), 4, "__alignof__(STT1220)");
    check_field_offset(lv, fa, 0, "STT1220.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1220");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1220");
    check_field_offset(lv, fb, 7, "STT1220.fb");
  }
}
static Arrange_To_Call_Me vSTT1220(Test_STT1220, "STT1220", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1230  {
  short fa;
  __tsu64 bf:18;
  char fb;
};
//SIG(1 STT1230) C1{ Fs FL:18 Fc}



static void Test_STT1230()
{
  {
    init_simple_test("STT1230");
    static STT1230 lv;
    check2(sizeof(lv), 8, "sizeof(STT1230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1230)");
    check_field_offset(lv, fa, 0, "STT1230.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1230");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1230");
    check_field_offset(lv, fb, 5, "STT1230.fb");
  }
}
static Arrange_To_Call_Me vSTT1230(Test_STT1230, "STT1230", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1240  {
  short fa;
  __tsu64 bf:48;
  char fb;
};
//SIG(1 STT1240) C1{ Fs FL:48 Fc}



static void Test_STT1240()
{
  {
    init_simple_test("STT1240");
    static STT1240 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1240)");
    check_field_offset(lv, fa, 0, "STT1240.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1240");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1240");
    check_field_offset(lv, fb, 8, "STT1240.fb");
  }
}
static Arrange_To_Call_Me vSTT1240(Test_STT1240, "STT1240", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT111  {
  short fa;
  unsigned char  :0;
  short fb;
};
//SIG(1 STT111) C1{ Fs Fc:0 Fs}



static void Test_STT111()
{
  {
    init_simple_test("STT111");
    static STT111 lv;
    check2(sizeof(lv), 4, "sizeof(STT111)");
    check2(__alignof__(lv), 2, "__alignof__(STT111)");
    check_field_offset(lv, fa, 0, "STT111.fa");
    check_field_offset(lv, fb, 2, "STT111.fb");
  }
}
static Arrange_To_Call_Me vSTT111(Test_STT111, "STT111", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT121  {
  short fa;
  unsigned short  :0;
  short fb;
};
//SIG(1 STT121) C1{ Fs Fs:0 Fs}



static void Test_STT121()
{
  {
    init_simple_test("STT121");
    static STT121 lv;
    check2(sizeof(lv), 4, "sizeof(STT121)");
    check2(__alignof__(lv), 2, "__alignof__(STT121)");
    check_field_offset(lv, fa, 0, "STT121.fa");
    check_field_offset(lv, fb, 2, "STT121.fb");
  }
}
static Arrange_To_Call_Me vSTT121(Test_STT121, "STT121", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT131  {
  short fa;
  unsigned int  :0;
  short fb;
};
//SIG(1 STT131) C1{ Fs Fi:0 Fs}



static void Test_STT131()
{
  {
    init_simple_test("STT131");
    static STT131 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT131)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT131)");
    check_field_offset(lv, fa, 0, "STT131.fa");
    check_field_offset(lv, fb, 4, "STT131.fb");
  }
}
static Arrange_To_Call_Me vSTT131(Test_STT131, "STT131", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT141  {
  short fa;
  __tsu64  :0;
  short fb;
};
//SIG(1 STT141) C1{ Fs FL:0 Fs}



static void Test_STT141()
{
  {
    init_simple_test("STT141");
    static STT141 lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(STT141)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT141)");
    check_field_offset(lv, fa, 0, "STT141.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT141.fb");
  }
}
static Arrange_To_Call_Me vSTT141(Test_STT141, "STT141", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT151  {
  short fa;
  unsigned char  :3;
  short fb;
};
//SIG(1 STT151) C1{ Fs Fc:3 Fs}



static void Test_STT151()
{
  {
    init_simple_test("STT151");
    static STT151 lv;
    check2(sizeof(lv), 6, "sizeof(STT151)");
    check2(__alignof__(lv), 2, "__alignof__(STT151)");
    check_field_offset(lv, fa, 0, "STT151.fa");
    check_field_offset(lv, fb, 4, "STT151.fb");
  }
}
static Arrange_To_Call_Me vSTT151(Test_STT151, "STT151", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT161  {
  short fa;
  unsigned short  :3;
  short fb;
};
//SIG(1 STT161) C1{ Fs Fs:3 Fs}



static void Test_STT161()
{
  {
    init_simple_test("STT161");
    static STT161 lv;
    check2(sizeof(lv), 6, "sizeof(STT161)");
    check2(__alignof__(lv), 2, "__alignof__(STT161)");
    check_field_offset(lv, fa, 0, "STT161.fa");
    check_field_offset(lv, fb, 4, "STT161.fb");
  }
}
static Arrange_To_Call_Me vSTT161(Test_STT161, "STT161", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT171  {
  short fa;
  unsigned int  :3;
  short fb;
};
//SIG(1 STT171) C1{ Fs Fi:3 Fs}



static void Test_STT171()
{
  {
    init_simple_test("STT171");
    static STT171 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT171)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT171)");
    check_field_offset(lv, fa, 0, "STT171.fa");
    check_field_offset(lv, fb, 4, "STT171.fb");
  }
}
static Arrange_To_Call_Me vSTT171(Test_STT171, "STT171", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT181  {
  short fa;
  __tsu64  :3;
  short fb;
};
//SIG(1 STT181) C1{ Fs FL:3 Fs}



static void Test_STT181()
{
  {
    init_simple_test("STT181");
    static STT181 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT181)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT181)");
    check_field_offset(lv, fa, 0, "STT181.fa");
    check_field_offset(lv, fb, 4, "STT181.fb");
  }
}
static Arrange_To_Call_Me vSTT181(Test_STT181, "STT181", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT191  {
  short fa;
  unsigned short  :8;
  short fb;
};
//SIG(1 STT191) C1{ Fs Fs:8 Fs}



static void Test_STT191()
{
  {
    init_simple_test("STT191");
    static STT191 lv;
    check2(sizeof(lv), 6, "sizeof(STT191)");
    check2(__alignof__(lv), 2, "__alignof__(STT191)");
    check_field_offset(lv, fa, 0, "STT191.fa");
    check_field_offset(lv, fb, 4, "STT191.fb");
  }
}
static Arrange_To_Call_Me vSTT191(Test_STT191, "STT191", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1101  {
  short fa;
  unsigned int  :8;
  short fb;
};
//SIG(1 STT1101) C1{ Fs Fi:8 Fs}



static void Test_STT1101()
{
  {
    init_simple_test("STT1101");
    static STT1101 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT1101)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1101)");
    check_field_offset(lv, fa, 0, "STT1101.fa");
    check_field_offset(lv, fb, 4, "STT1101.fb");
  }
}
static Arrange_To_Call_Me vSTT1101(Test_STT1101, "STT1101", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1111  {
  short fa;
  __tsu64  :8;
  short fb;
};
//SIG(1 STT1111) C1{ Fs FL:8 Fs}



static void Test_STT1111()
{
  {
    init_simple_test("STT1111");
    static STT1111 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT1111)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1111)");
    check_field_offset(lv, fa, 0, "STT1111.fa");
    check_field_offset(lv, fb, 4, "STT1111.fb");
  }
}
static Arrange_To_Call_Me vSTT1111(Test_STT1111, "STT1111", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1121  {
  short fa;
  unsigned int  :18;
  short fb;
};
//SIG(1 STT1121) C1{ Fs Fi:18 Fs}



static void Test_STT1121()
{
  {
    init_simple_test("STT1121");
    static STT1121 lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(STT1121)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1121)");
    check_field_offset(lv, fa, 0, "STT1121.fa");
    check_field_offset(lv, fb, 8, "STT1121.fb");
  }
}
static Arrange_To_Call_Me vSTT1121(Test_STT1121, "STT1121", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1131  {
  short fa;
  __tsu64  :18;
  short fb;
};
//SIG(1 STT1131) C1{ Fs FL:18 Fs}



static void Test_STT1131()
{
  {
    init_simple_test("STT1131");
    static STT1131 lv;
    check2(sizeof(lv), 8, "sizeof(STT1131)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1131)");
    check_field_offset(lv, fa, 0, "STT1131.fa");
    check_field_offset(lv, fb, 6, "STT1131.fb");
  }
}
static Arrange_To_Call_Me vSTT1131(Test_STT1131, "STT1131", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1141  {
  short fa;
  __tsu64  :48;
  short fb;
};
//SIG(1 STT1141) C1{ Fs FL:48 Fs}



static void Test_STT1141()
{
  {
    init_simple_test("STT1141");
    static STT1141 lv;
    check2(sizeof(lv), ABISELECT(10,10), "sizeof(STT1141)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1141)");
    check_field_offset(lv, fa, 0, "STT1141.fa");
    check_field_offset(lv, fb, 8, "STT1141.fb");
  }
}
static Arrange_To_Call_Me vSTT1141(Test_STT1141, "STT1141", ABISELECT(10,10));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1151  {
  short fa;
  unsigned char bf:3;
  short fb;
};
//SIG(1 STT1151) C1{ Fs Fc:3 Fs}



static void Test_STT1151()
{
  {
    init_simple_test("STT1151");
    static STT1151 lv;
    check2(sizeof(lv), 6, "sizeof(STT1151)");
    check2(__alignof__(lv), 2, "__alignof__(STT1151)");
    check_field_offset(lv, fa, 0, "STT1151.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1151");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1151");
    check_field_offset(lv, fb, 4, "STT1151.fb");
  }
}
static Arrange_To_Call_Me vSTT1151(Test_STT1151, "STT1151", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1161  {
  short fa;
  unsigned short bf:3;
  short fb;
};
//SIG(1 STT1161) C1{ Fs Fs:3 Fs}



static void Test_STT1161()
{
  {
    init_simple_test("STT1161");
    static STT1161 lv;
    check2(sizeof(lv), 6, "sizeof(STT1161)");
    check2(__alignof__(lv), 2, "__alignof__(STT1161)");
    check_field_offset(lv, fa, 0, "STT1161.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1161");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1161");
    check_field_offset(lv, fb, 4, "STT1161.fb");
  }
}
static Arrange_To_Call_Me vSTT1161(Test_STT1161, "STT1161", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1171  {
  short fa;
  unsigned int bf:3;
  short fb;
};
//SIG(1 STT1171) C1{ Fs Fi:3 Fs}



static void Test_STT1171()
{
  {
    init_simple_test("STT1171");
    static STT1171 lv;
    check2(sizeof(lv), 8, "sizeof(STT1171)");
    check2(__alignof__(lv), 4, "__alignof__(STT1171)");
    check_field_offset(lv, fa, 0, "STT1171.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1171");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1171");
    check_field_offset(lv, fb, 4, "STT1171.fb");
  }
}
static Arrange_To_Call_Me vSTT1171(Test_STT1171, "STT1171", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1181  {
  short fa;
  __tsu64 bf:3;
  short fb;
};
//SIG(1 STT1181) C1{ Fs FL:3 Fs}



static void Test_STT1181()
{
  {
    init_simple_test("STT1181");
    static STT1181 lv;
    check2(sizeof(lv), 8, "sizeof(STT1181)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1181)");
    check_field_offset(lv, fa, 0, "STT1181.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1181");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1181");
    check_field_offset(lv, fb, 4, "STT1181.fb");
  }
}
static Arrange_To_Call_Me vSTT1181(Test_STT1181, "STT1181", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1191  {
  short fa;
  unsigned short bf:8;
  short fb;
};
//SIG(1 STT1191) C1{ Fs Fs:8 Fs}



static void Test_STT1191()
{
  {
    init_simple_test("STT1191");
    static STT1191 lv;
    check2(sizeof(lv), 6, "sizeof(STT1191)");
    check2(__alignof__(lv), 2, "__alignof__(STT1191)");
    check_field_offset(lv, fa, 0, "STT1191.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1191");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1191");
    check_field_offset(lv, fb, 4, "STT1191.fb");
  }
}
static Arrange_To_Call_Me vSTT1191(Test_STT1191, "STT1191", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1201  {
  short fa;
  unsigned int bf:8;
  short fb;
};
//SIG(1 STT1201) C1{ Fs Fi:8 Fs}



static void Test_STT1201()
{
  {
    init_simple_test("STT1201");
    static STT1201 lv;
    check2(sizeof(lv), 8, "sizeof(STT1201)");
    check2(__alignof__(lv), 4, "__alignof__(STT1201)");
    check_field_offset(lv, fa, 0, "STT1201.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1201");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1201");
    check_field_offset(lv, fb, 4, "STT1201.fb");
  }
}
static Arrange_To_Call_Me vSTT1201(Test_STT1201, "STT1201", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1211  {
  short fa;
  __tsu64 bf:8;
  short fb;
};
//SIG(1 STT1211) C1{ Fs FL:8 Fs}



static void Test_STT1211()
{
  {
    init_simple_test("STT1211");
    static STT1211 lv;
    check2(sizeof(lv), 8, "sizeof(STT1211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1211)");
    check_field_offset(lv, fa, 0, "STT1211.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1211");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1211");
    check_field_offset(lv, fb, 4, "STT1211.fb");
  }
}
static Arrange_To_Call_Me vSTT1211(Test_STT1211, "STT1211", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1221  {
  short fa;
  unsigned int bf:18;
  short fb;
};
//SIG(1 STT1221) C1{ Fs Fi:18 Fs}



static void Test_STT1221()
{
  {
    init_simple_test("STT1221");
    static STT1221 lv;
    check2(sizeof(lv), 12, "sizeof(STT1221)");
    check2(__alignof__(lv), 4, "__alignof__(STT1221)");
    check_field_offset(lv, fa, 0, "STT1221.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1221");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1221");
    check_field_offset(lv, fb, 8, "STT1221.fb");
  }
}
static Arrange_To_Call_Me vSTT1221(Test_STT1221, "STT1221", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1231  {
  short fa;
  __tsu64 bf:18;
  short fb;
};
//SIG(1 STT1231) C1{ Fs FL:18 Fs}



static void Test_STT1231()
{
  {
    init_simple_test("STT1231");
    static STT1231 lv;
    check2(sizeof(lv), 8, "sizeof(STT1231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1231)");
    check_field_offset(lv, fa, 0, "STT1231.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1231");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1231");
    check_field_offset(lv, fb, 6, "STT1231.fb");
  }
}
static Arrange_To_Call_Me vSTT1231(Test_STT1231, "STT1231", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1241  {
  short fa;
  __tsu64 bf:48;
  short fb;
};
//SIG(1 STT1241) C1{ Fs FL:48 Fs}



static void Test_STT1241()
{
  {
    init_simple_test("STT1241");
    static STT1241 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1241)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1241)");
    check_field_offset(lv, fa, 0, "STT1241.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1241");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1241");
    check_field_offset(lv, fb, 8, "STT1241.fb");
  }
}
static Arrange_To_Call_Me vSTT1241(Test_STT1241, "STT1241", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT112  {
  short fa;
  unsigned char  :0;
  int fb;
};
//SIG(1 STT112) C1{ Fs Fc:0 Fi}



static void Test_STT112()
{
  {
    init_simple_test("STT112");
    static STT112 lv;
    check2(sizeof(lv), 8, "sizeof(STT112)");
    check2(__alignof__(lv), 4, "__alignof__(STT112)");
    check_field_offset(lv, fa, 0, "STT112.fa");
    check_field_offset(lv, fb, 4, "STT112.fb");
  }
}
static Arrange_To_Call_Me vSTT112(Test_STT112, "STT112", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT122  {
  short fa;
  unsigned short  :0;
  int fb;
};
//SIG(1 STT122) C1{ Fs Fs:0 Fi}



static void Test_STT122()
{
  {
    init_simple_test("STT122");
    static STT122 lv;
    check2(sizeof(lv), 8, "sizeof(STT122)");
    check2(__alignof__(lv), 4, "__alignof__(STT122)");
    check_field_offset(lv, fa, 0, "STT122.fa");
    check_field_offset(lv, fb, 4, "STT122.fb");
  }
}
static Arrange_To_Call_Me vSTT122(Test_STT122, "STT122", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT132  {
  short fa;
  unsigned int  :0;
  int fb;
};
//SIG(1 STT132) C1{ Fs Fi:0 Fi}



static void Test_STT132()
{
  {
    init_simple_test("STT132");
    static STT132 lv;
    check2(sizeof(lv), 8, "sizeof(STT132)");
    check2(__alignof__(lv), 4, "__alignof__(STT132)");
    check_field_offset(lv, fa, 0, "STT132.fa");
    check_field_offset(lv, fb, 4, "STT132.fb");
  }
}
static Arrange_To_Call_Me vSTT132(Test_STT132, "STT132", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT142  {
  short fa;
  __tsu64  :0;
  int fb;
};
//SIG(1 STT142) C1{ Fs FL:0 Fi}



static void Test_STT142()
{
  {
    init_simple_test("STT142");
    static STT142 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT142)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT142)");
    check_field_offset(lv, fa, 0, "STT142.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT142.fb");
  }
}
static Arrange_To_Call_Me vSTT142(Test_STT142, "STT142", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT152  {
  short fa;
  unsigned char  :3;
  int fb;
};
//SIG(1 STT152) C1{ Fs Fc:3 Fi}



static void Test_STT152()
{
  {
    init_simple_test("STT152");
    static STT152 lv;
    check2(sizeof(lv), 8, "sizeof(STT152)");
    check2(__alignof__(lv), 4, "__alignof__(STT152)");
    check_field_offset(lv, fa, 0, "STT152.fa");
    check_field_offset(lv, fb, 4, "STT152.fb");
  }
}
static Arrange_To_Call_Me vSTT152(Test_STT152, "STT152", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT162  {
  short fa;
  unsigned short  :3;
  int fb;
};
//SIG(1 STT162) C1{ Fs Fs:3 Fi}



static void Test_STT162()
{
  {
    init_simple_test("STT162");
    static STT162 lv;
    check2(sizeof(lv), 8, "sizeof(STT162)");
    check2(__alignof__(lv), 4, "__alignof__(STT162)");
    check_field_offset(lv, fa, 0, "STT162.fa");
    check_field_offset(lv, fb, 4, "STT162.fb");
  }
}
static Arrange_To_Call_Me vSTT162(Test_STT162, "STT162", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT172  {
  short fa;
  unsigned int  :3;
  int fb;
};
//SIG(1 STT172) C1{ Fs Fi:3 Fi}



static void Test_STT172()
{
  {
    init_simple_test("STT172");
    static STT172 lv;
    check2(sizeof(lv), 8, "sizeof(STT172)");
    check2(__alignof__(lv), 4, "__alignof__(STT172)");
    check_field_offset(lv, fa, 0, "STT172.fa");
    check_field_offset(lv, fb, 4, "STT172.fb");
  }
}
static Arrange_To_Call_Me vSTT172(Test_STT172, "STT172", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT182  {
  short fa;
  __tsu64  :3;
  int fb;
};
//SIG(1 STT182) C1{ Fs FL:3 Fi}



static void Test_STT182()
{
  {
    init_simple_test("STT182");
    static STT182 lv;
    check2(sizeof(lv), 8, "sizeof(STT182)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT182)");
    check_field_offset(lv, fa, 0, "STT182.fa");
    check_field_offset(lv, fb, 4, "STT182.fb");
  }
}
static Arrange_To_Call_Me vSTT182(Test_STT182, "STT182", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT192  {
  short fa;
  unsigned short  :8;
  int fb;
};
//SIG(1 STT192) C1{ Fs Fs:8 Fi}



static void Test_STT192()
{
  {
    init_simple_test("STT192");
    static STT192 lv;
    check2(sizeof(lv), 8, "sizeof(STT192)");
    check2(__alignof__(lv), 4, "__alignof__(STT192)");
    check_field_offset(lv, fa, 0, "STT192.fa");
    check_field_offset(lv, fb, 4, "STT192.fb");
  }
}
static Arrange_To_Call_Me vSTT192(Test_STT192, "STT192", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1102  {
  short fa;
  unsigned int  :8;
  int fb;
};
//SIG(1 STT1102) C1{ Fs Fi:8 Fi}



static void Test_STT1102()
{
  {
    init_simple_test("STT1102");
    static STT1102 lv;
    check2(sizeof(lv), 8, "sizeof(STT1102)");
    check2(__alignof__(lv), 4, "__alignof__(STT1102)");
    check_field_offset(lv, fa, 0, "STT1102.fa");
    check_field_offset(lv, fb, 4, "STT1102.fb");
  }
}
static Arrange_To_Call_Me vSTT1102(Test_STT1102, "STT1102", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1112  {
  short fa;
  __tsu64  :8;
  int fb;
};
//SIG(1 STT1112) C1{ Fs FL:8 Fi}



static void Test_STT1112()
{
  {
    init_simple_test("STT1112");
    static STT1112 lv;
    check2(sizeof(lv), 8, "sizeof(STT1112)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT1112)");
    check_field_offset(lv, fa, 0, "STT1112.fa");
    check_field_offset(lv, fb, 4, "STT1112.fb");
  }
}
static Arrange_To_Call_Me vSTT1112(Test_STT1112, "STT1112", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1122  {
  short fa;
  unsigned int  :18;
  int fb;
};
//SIG(1 STT1122) C1{ Fs Fi:18 Fi}



static void Test_STT1122()
{
  {
    init_simple_test("STT1122");
    static STT1122 lv;
    check2(sizeof(lv), 12, "sizeof(STT1122)");
    check2(__alignof__(lv), 4, "__alignof__(STT1122)");
    check_field_offset(lv, fa, 0, "STT1122.fa");
    check_field_offset(lv, fb, 8, "STT1122.fb");
  }
}
static Arrange_To_Call_Me vSTT1122(Test_STT1122, "STT1122", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1132  {
  short fa;
  __tsu64  :18;
  int fb;
};
//SIG(1 STT1132) C1{ Fs FL:18 Fi}



static void Test_STT1132()
{
  {
    init_simple_test("STT1132");
    static STT1132 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT1132)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT1132)");
    check_field_offset(lv, fa, 0, "STT1132.fa");
    check_field_offset(lv, fb, 8, "STT1132.fb");
  }
}
static Arrange_To_Call_Me vSTT1132(Test_STT1132, "STT1132", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1142  {
  short fa;
  __tsu64  :48;
  int fb;
};
//SIG(1 STT1142) C1{ Fs FL:48 Fi}



static void Test_STT1142()
{
  {
    init_simple_test("STT1142");
    static STT1142 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT1142)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT1142)");
    check_field_offset(lv, fa, 0, "STT1142.fa");
    check_field_offset(lv, fb, 8, "STT1142.fb");
  }
}
static Arrange_To_Call_Me vSTT1142(Test_STT1142, "STT1142", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1152  {
  short fa;
  unsigned char bf:3;
  int fb;
};
//SIG(1 STT1152) C1{ Fs Fc:3 Fi}



static void Test_STT1152()
{
  {
    init_simple_test("STT1152");
    static STT1152 lv;
    check2(sizeof(lv), 8, "sizeof(STT1152)");
    check2(__alignof__(lv), 4, "__alignof__(STT1152)");
    check_field_offset(lv, fa, 0, "STT1152.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1152");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1152");
    check_field_offset(lv, fb, 4, "STT1152.fb");
  }
}
static Arrange_To_Call_Me vSTT1152(Test_STT1152, "STT1152", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1162  {
  short fa;
  unsigned short bf:3;
  int fb;
};
//SIG(1 STT1162) C1{ Fs Fs:3 Fi}



static void Test_STT1162()
{
  {
    init_simple_test("STT1162");
    static STT1162 lv;
    check2(sizeof(lv), 8, "sizeof(STT1162)");
    check2(__alignof__(lv), 4, "__alignof__(STT1162)");
    check_field_offset(lv, fa, 0, "STT1162.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1162");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1162");
    check_field_offset(lv, fb, 4, "STT1162.fb");
  }
}
static Arrange_To_Call_Me vSTT1162(Test_STT1162, "STT1162", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1172  {
  short fa;
  unsigned int bf:3;
  int fb;
};
//SIG(1 STT1172) C1{ Fs Fi:3 Fi}



static void Test_STT1172()
{
  {
    init_simple_test("STT1172");
    static STT1172 lv;
    check2(sizeof(lv), 8, "sizeof(STT1172)");
    check2(__alignof__(lv), 4, "__alignof__(STT1172)");
    check_field_offset(lv, fa, 0, "STT1172.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1172");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1172");
    check_field_offset(lv, fb, 4, "STT1172.fb");
  }
}
static Arrange_To_Call_Me vSTT1172(Test_STT1172, "STT1172", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1182  {
  short fa;
  __tsu64 bf:3;
  int fb;
};
//SIG(1 STT1182) C1{ Fs FL:3 Fi}



static void Test_STT1182()
{
  {
    init_simple_test("STT1182");
    static STT1182 lv;
    check2(sizeof(lv), 8, "sizeof(STT1182)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1182)");
    check_field_offset(lv, fa, 0, "STT1182.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1182");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1182");
    check_field_offset(lv, fb, 4, "STT1182.fb");
  }
}
static Arrange_To_Call_Me vSTT1182(Test_STT1182, "STT1182", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1192  {
  short fa;
  unsigned short bf:8;
  int fb;
};
//SIG(1 STT1192) C1{ Fs Fs:8 Fi}



static void Test_STT1192()
{
  {
    init_simple_test("STT1192");
    static STT1192 lv;
    check2(sizeof(lv), 8, "sizeof(STT1192)");
    check2(__alignof__(lv), 4, "__alignof__(STT1192)");
    check_field_offset(lv, fa, 0, "STT1192.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1192");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1192");
    check_field_offset(lv, fb, 4, "STT1192.fb");
  }
}
static Arrange_To_Call_Me vSTT1192(Test_STT1192, "STT1192", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1202  {
  short fa;
  unsigned int bf:8;
  int fb;
};
//SIG(1 STT1202) C1{ Fs Fi:8 Fi}



static void Test_STT1202()
{
  {
    init_simple_test("STT1202");
    static STT1202 lv;
    check2(sizeof(lv), 8, "sizeof(STT1202)");
    check2(__alignof__(lv), 4, "__alignof__(STT1202)");
    check_field_offset(lv, fa, 0, "STT1202.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1202");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1202");
    check_field_offset(lv, fb, 4, "STT1202.fb");
  }
}
static Arrange_To_Call_Me vSTT1202(Test_STT1202, "STT1202", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1212  {
  short fa;
  __tsu64 bf:8;
  int fb;
};
//SIG(1 STT1212) C1{ Fs FL:8 Fi}



static void Test_STT1212()
{
  {
    init_simple_test("STT1212");
    static STT1212 lv;
    check2(sizeof(lv), 8, "sizeof(STT1212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1212)");
    check_field_offset(lv, fa, 0, "STT1212.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1212");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1212");
    check_field_offset(lv, fb, 4, "STT1212.fb");
  }
}
static Arrange_To_Call_Me vSTT1212(Test_STT1212, "STT1212", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1222  {
  short fa;
  unsigned int bf:18;
  int fb;
};
//SIG(1 STT1222) C1{ Fs Fi:18 Fi}



static void Test_STT1222()
{
  {
    init_simple_test("STT1222");
    static STT1222 lv;
    check2(sizeof(lv), 12, "sizeof(STT1222)");
    check2(__alignof__(lv), 4, "__alignof__(STT1222)");
    check_field_offset(lv, fa, 0, "STT1222.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1222");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1222");
    check_field_offset(lv, fb, 8, "STT1222.fb");
  }
}
static Arrange_To_Call_Me vSTT1222(Test_STT1222, "STT1222", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1232  {
  short fa;
  __tsu64 bf:18;
  int fb;
};
//SIG(1 STT1232) C1{ Fs FL:18 Fi}



static void Test_STT1232()
{
  {
    init_simple_test("STT1232");
    static STT1232 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1232)");
    check_field_offset(lv, fa, 0, "STT1232.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1232");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1232");
    check_field_offset(lv, fb, 8, "STT1232.fb");
  }
}
static Arrange_To_Call_Me vSTT1232(Test_STT1232, "STT1232", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1242  {
  short fa;
  __tsu64 bf:48;
  int fb;
};
//SIG(1 STT1242) C1{ Fs FL:48 Fi}



static void Test_STT1242()
{
  {
    init_simple_test("STT1242");
    static STT1242 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1242)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1242)");
    check_field_offset(lv, fa, 0, "STT1242.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1242");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1242");
    check_field_offset(lv, fb, 8, "STT1242.fb");
  }
}
static Arrange_To_Call_Me vSTT1242(Test_STT1242, "STT1242", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT113  {
  short fa;
  unsigned char  :0;
  long fb;
};
//SIG(1 STT113) C1{ Fs Fc:0 Fl}



static void Test_STT113()
{
  {
    init_simple_test("STT113");
    static STT113 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT113)");
    check_field_offset(lv, fa, 0, "STT113.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT113.fb");
  }
}
static Arrange_To_Call_Me vSTT113(Test_STT113, "STT113", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT123  {
  short fa;
  unsigned short  :0;
  long fb;
};
//SIG(1 STT123) C1{ Fs Fs:0 Fl}



static void Test_STT123()
{
  {
    init_simple_test("STT123");
    static STT123 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT123)");
    check_field_offset(lv, fa, 0, "STT123.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT123.fb");
  }
}
static Arrange_To_Call_Me vSTT123(Test_STT123, "STT123", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT133  {
  short fa;
  unsigned int  :0;
  long fb;
};
//SIG(1 STT133) C1{ Fs Fi:0 Fl}



static void Test_STT133()
{
  {
    init_simple_test("STT133");
    static STT133 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT133)");
    check_field_offset(lv, fa, 0, "STT133.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT133.fb");
  }
}
static Arrange_To_Call_Me vSTT133(Test_STT133, "STT133", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT143  {
  short fa;
  __tsu64  :0;
  long fb;
};
//SIG(1 STT143) C1{ Fs FL:0 Fl}



static void Test_STT143()
{
  {
    init_simple_test("STT143");
    static STT143 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT143)");
    check_field_offset(lv, fa, 0, "STT143.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT143.fb");
  }
}
static Arrange_To_Call_Me vSTT143(Test_STT143, "STT143", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT153  {
  short fa;
  unsigned char  :3;
  long fb;
};
//SIG(1 STT153) C1{ Fs Fc:3 Fl}



static void Test_STT153()
{
  {
    init_simple_test("STT153");
    static STT153 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT153)");
    check_field_offset(lv, fa, 0, "STT153.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT153.fb");
  }
}
static Arrange_To_Call_Me vSTT153(Test_STT153, "STT153", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT163  {
  short fa;
  unsigned short  :3;
  long fb;
};
//SIG(1 STT163) C1{ Fs Fs:3 Fl}



static void Test_STT163()
{
  {
    init_simple_test("STT163");
    static STT163 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT163)");
    check_field_offset(lv, fa, 0, "STT163.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT163.fb");
  }
}
static Arrange_To_Call_Me vSTT163(Test_STT163, "STT163", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT173  {
  short fa;
  unsigned int  :3;
  long fb;
};
//SIG(1 STT173) C1{ Fs Fi:3 Fl}



static void Test_STT173()
{
  {
    init_simple_test("STT173");
    static STT173 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT173)");
    check_field_offset(lv, fa, 0, "STT173.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT173.fb");
  }
}
static Arrange_To_Call_Me vSTT173(Test_STT173, "STT173", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT183  {
  short fa;
  __tsu64  :3;
  long fb;
};
//SIG(1 STT183) C1{ Fs FL:3 Fl}



static void Test_STT183()
{
  {
    init_simple_test("STT183");
    static STT183 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT183)");
    check_field_offset(lv, fa, 0, "STT183.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT183.fb");
  }
}
static Arrange_To_Call_Me vSTT183(Test_STT183, "STT183", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT193  {
  short fa;
  unsigned short  :8;
  long fb;
};
//SIG(1 STT193) C1{ Fs Fs:8 Fl}



static void Test_STT193()
{
  {
    init_simple_test("STT193");
    static STT193 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT193)");
    check_field_offset(lv, fa, 0, "STT193.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT193.fb");
  }
}
static Arrange_To_Call_Me vSTT193(Test_STT193, "STT193", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1103  {
  short fa;
  unsigned int  :8;
  long fb;
};
//SIG(1 STT1103) C1{ Fs Fi:8 Fl}



static void Test_STT1103()
{
  {
    init_simple_test("STT1103");
    static STT1103 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1103)");
    check_field_offset(lv, fa, 0, "STT1103.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1103.fb");
  }
}
static Arrange_To_Call_Me vSTT1103(Test_STT1103, "STT1103", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1113  {
  short fa;
  __tsu64  :8;
  long fb;
};
//SIG(1 STT1113) C1{ Fs FL:8 Fl}



static void Test_STT1113()
{
  {
    init_simple_test("STT1113");
    static STT1113 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1113)");
    check_field_offset(lv, fa, 0, "STT1113.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1113.fb");
  }
}
static Arrange_To_Call_Me vSTT1113(Test_STT1113, "STT1113", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1123  {
  short fa;
  unsigned int  :18;
  long fb;
};
//SIG(1 STT1123) C1{ Fs Fi:18 Fl}



static void Test_STT1123()
{
  {
    init_simple_test("STT1123");
    static STT1123 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1123)");
    check_field_offset(lv, fa, 0, "STT1123.fa");
    check_field_offset(lv, fb, 8, "STT1123.fb");
  }
}
static Arrange_To_Call_Me vSTT1123(Test_STT1123, "STT1123", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1133  {
  short fa;
  __tsu64  :18;
  long fb;
};
//SIG(1 STT1133) C1{ Fs FL:18 Fl}



static void Test_STT1133()
{
  {
    init_simple_test("STT1133");
    static STT1133 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1133)");
    check_field_offset(lv, fa, 0, "STT1133.fa");
    check_field_offset(lv, fb, 8, "STT1133.fb");
  }
}
static Arrange_To_Call_Me vSTT1133(Test_STT1133, "STT1133", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1143  {
  short fa;
  __tsu64  :48;
  long fb;
};
//SIG(1 STT1143) C1{ Fs FL:48 Fl}



static void Test_STT1143()
{
  {
    init_simple_test("STT1143");
    static STT1143 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1143)");
    check_field_offset(lv, fa, 0, "STT1143.fa");
    check_field_offset(lv, fb, 8, "STT1143.fb");
  }
}
static Arrange_To_Call_Me vSTT1143(Test_STT1143, "STT1143", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1153  {
  short fa;
  unsigned char bf:3;
  long fb;
};
//SIG(1 STT1153) C1{ Fs Fc:3 Fl}



static void Test_STT1153()
{
  {
    init_simple_test("STT1153");
    static STT1153 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1153)");
    check_field_offset(lv, fa, 0, "STT1153.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1153");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1153");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1153.fb");
  }
}
static Arrange_To_Call_Me vSTT1153(Test_STT1153, "STT1153", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1163  {
  short fa;
  unsigned short bf:3;
  long fb;
};
//SIG(1 STT1163) C1{ Fs Fs:3 Fl}



static void Test_STT1163()
{
  {
    init_simple_test("STT1163");
    static STT1163 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1163)");
    check_field_offset(lv, fa, 0, "STT1163.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1163");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1163");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1163.fb");
  }
}
static Arrange_To_Call_Me vSTT1163(Test_STT1163, "STT1163", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1173  {
  short fa;
  unsigned int bf:3;
  long fb;
};
//SIG(1 STT1173) C1{ Fs Fi:3 Fl}



static void Test_STT1173()
{
  {
    init_simple_test("STT1173");
    static STT1173 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1173)");
    check_field_offset(lv, fa, 0, "STT1173.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1173");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1173");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1173.fb");
  }
}
static Arrange_To_Call_Me vSTT1173(Test_STT1173, "STT1173", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1183  {
  short fa;
  __tsu64 bf:3;
  long fb;
};
//SIG(1 STT1183) C1{ Fs FL:3 Fl}



static void Test_STT1183()
{
  {
    init_simple_test("STT1183");
    static STT1183 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1183)");
    check_field_offset(lv, fa, 0, "STT1183.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1183");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1183");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1183.fb");
  }
}
static Arrange_To_Call_Me vSTT1183(Test_STT1183, "STT1183", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1193  {
  short fa;
  unsigned short bf:8;
  long fb;
};
//SIG(1 STT1193) C1{ Fs Fs:8 Fl}



static void Test_STT1193()
{
  {
    init_simple_test("STT1193");
    static STT1193 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1193)");
    check_field_offset(lv, fa, 0, "STT1193.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1193");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1193");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1193.fb");
  }
}
static Arrange_To_Call_Me vSTT1193(Test_STT1193, "STT1193", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1203  {
  short fa;
  unsigned int bf:8;
  long fb;
};
//SIG(1 STT1203) C1{ Fs Fi:8 Fl}



static void Test_STT1203()
{
  {
    init_simple_test("STT1203");
    static STT1203 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1203)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1203)");
    check_field_offset(lv, fa, 0, "STT1203.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1203");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1203");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1203.fb");
  }
}
static Arrange_To_Call_Me vSTT1203(Test_STT1203, "STT1203", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1213  {
  short fa;
  __tsu64 bf:8;
  long fb;
};
//SIG(1 STT1213) C1{ Fs FL:8 Fl}



static void Test_STT1213()
{
  {
    init_simple_test("STT1213");
    static STT1213 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1213)");
    check_field_offset(lv, fa, 0, "STT1213.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1213");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1213");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1213.fb");
  }
}
static Arrange_To_Call_Me vSTT1213(Test_STT1213, "STT1213", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1223  {
  short fa;
  unsigned int bf:18;
  long fb;
};
//SIG(1 STT1223) C1{ Fs Fi:18 Fl}



static void Test_STT1223()
{
  {
    init_simple_test("STT1223");
    static STT1223 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1223)");
    check_field_offset(lv, fa, 0, "STT1223.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1223");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1223");
    check_field_offset(lv, fb, 8, "STT1223.fb");
  }
}
static Arrange_To_Call_Me vSTT1223(Test_STT1223, "STT1223", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1233  {
  short fa;
  __tsu64 bf:18;
  long fb;
};
//SIG(1 STT1233) C1{ Fs FL:18 Fl}



static void Test_STT1233()
{
  {
    init_simple_test("STT1233");
    static STT1233 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1233)");
    check_field_offset(lv, fa, 0, "STT1233.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1233");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1233");
    check_field_offset(lv, fb, 8, "STT1233.fb");
  }
}
static Arrange_To_Call_Me vSTT1233(Test_STT1233, "STT1233", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1243  {
  short fa;
  __tsu64 bf:48;
  long fb;
};
//SIG(1 STT1243) C1{ Fs FL:48 Fl}



static void Test_STT1243()
{
  {
    init_simple_test("STT1243");
    static STT1243 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1243)");
    check_field_offset(lv, fa, 0, "STT1243.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1243");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1243");
    check_field_offset(lv, fb, 8, "STT1243.fb");
  }
}
static Arrange_To_Call_Me vSTT1243(Test_STT1243, "STT1243", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT114  {
  short fa;
  unsigned char  :0;
  __tsi64 fb;
};
//SIG(1 STT114) C1{ Fs Fc:0 FL}



static void Test_STT114()
{
  {
    init_simple_test("STT114");
    static STT114 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT114)");
    check_field_offset(lv, fa, 0, "STT114.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT114.fb");
  }
}
static Arrange_To_Call_Me vSTT114(Test_STT114, "STT114", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT124  {
  short fa;
  unsigned short  :0;
  __tsi64 fb;
};
//SIG(1 STT124) C1{ Fs Fs:0 FL}



static void Test_STT124()
{
  {
    init_simple_test("STT124");
    static STT124 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT124)");
    check_field_offset(lv, fa, 0, "STT124.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT124.fb");
  }
}
static Arrange_To_Call_Me vSTT124(Test_STT124, "STT124", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT134  {
  short fa;
  unsigned int  :0;
  __tsi64 fb;
};
//SIG(1 STT134) C1{ Fs Fi:0 FL}



static void Test_STT134()
{
  {
    init_simple_test("STT134");
    static STT134 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT134)");
    check_field_offset(lv, fa, 0, "STT134.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT134.fb");
  }
}
static Arrange_To_Call_Me vSTT134(Test_STT134, "STT134", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT144  {
  short fa;
  __tsu64  :0;
  __tsi64 fb;
};
//SIG(1 STT144) C1{ Fs FL:0 FL}



static void Test_STT144()
{
  {
    init_simple_test("STT144");
    static STT144 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT144)");
    check_field_offset(lv, fa, 0, "STT144.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT144.fb");
  }
}
static Arrange_To_Call_Me vSTT144(Test_STT144, "STT144", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT154  {
  short fa;
  unsigned char  :3;
  __tsi64 fb;
};
//SIG(1 STT154) C1{ Fs Fc:3 FL}



static void Test_STT154()
{
  {
    init_simple_test("STT154");
    static STT154 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT154)");
    check_field_offset(lv, fa, 0, "STT154.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT154.fb");
  }
}
static Arrange_To_Call_Me vSTT154(Test_STT154, "STT154", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT164  {
  short fa;
  unsigned short  :3;
  __tsi64 fb;
};
//SIG(1 STT164) C1{ Fs Fs:3 FL}



static void Test_STT164()
{
  {
    init_simple_test("STT164");
    static STT164 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT164)");
    check_field_offset(lv, fa, 0, "STT164.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT164.fb");
  }
}
static Arrange_To_Call_Me vSTT164(Test_STT164, "STT164", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT174  {
  short fa;
  unsigned int  :3;
  __tsi64 fb;
};
//SIG(1 STT174) C1{ Fs Fi:3 FL}



static void Test_STT174()
{
  {
    init_simple_test("STT174");
    static STT174 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT174)");
    check_field_offset(lv, fa, 0, "STT174.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT174.fb");
  }
}
static Arrange_To_Call_Me vSTT174(Test_STT174, "STT174", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT184  {
  short fa;
  __tsu64  :3;
  __tsi64 fb;
};
//SIG(1 STT184) C1{ Fs FL:3 FL}



static void Test_STT184()
{
  {
    init_simple_test("STT184");
    static STT184 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT184)");
    check_field_offset(lv, fa, 0, "STT184.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT184.fb");
  }
}
static Arrange_To_Call_Me vSTT184(Test_STT184, "STT184", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT194  {
  short fa;
  unsigned short  :8;
  __tsi64 fb;
};
//SIG(1 STT194) C1{ Fs Fs:8 FL}



static void Test_STT194()
{
  {
    init_simple_test("STT194");
    static STT194 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT194)");
    check_field_offset(lv, fa, 0, "STT194.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT194.fb");
  }
}
static Arrange_To_Call_Me vSTT194(Test_STT194, "STT194", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1104  {
  short fa;
  unsigned int  :8;
  __tsi64 fb;
};
//SIG(1 STT1104) C1{ Fs Fi:8 FL}



static void Test_STT1104()
{
  {
    init_simple_test("STT1104");
    static STT1104 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1104)");
    check_field_offset(lv, fa, 0, "STT1104.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1104.fb");
  }
}
static Arrange_To_Call_Me vSTT1104(Test_STT1104, "STT1104", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1114  {
  short fa;
  __tsu64  :8;
  __tsi64 fb;
};
//SIG(1 STT1114) C1{ Fs FL:8 FL}



static void Test_STT1114()
{
  {
    init_simple_test("STT1114");
    static STT1114 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1114)");
    check_field_offset(lv, fa, 0, "STT1114.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1114.fb");
  }
}
static Arrange_To_Call_Me vSTT1114(Test_STT1114, "STT1114", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1124  {
  short fa;
  unsigned int  :18;
  __tsi64 fb;
};
//SIG(1 STT1124) C1{ Fs Fi:18 FL}



static void Test_STT1124()
{
  {
    init_simple_test("STT1124");
    static STT1124 lv;
    check2(sizeof(lv), 16, "sizeof(STT1124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1124)");
    check_field_offset(lv, fa, 0, "STT1124.fa");
    check_field_offset(lv, fb, 8, "STT1124.fb");
  }
}
static Arrange_To_Call_Me vSTT1124(Test_STT1124, "STT1124", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1134  {
  short fa;
  __tsu64  :18;
  __tsi64 fb;
};
//SIG(1 STT1134) C1{ Fs FL:18 FL}



static void Test_STT1134()
{
  {
    init_simple_test("STT1134");
    static STT1134 lv;
    check2(sizeof(lv), 16, "sizeof(STT1134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1134)");
    check_field_offset(lv, fa, 0, "STT1134.fa");
    check_field_offset(lv, fb, 8, "STT1134.fb");
  }
}
static Arrange_To_Call_Me vSTT1134(Test_STT1134, "STT1134", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1144  {
  short fa;
  __tsu64  :48;
  __tsi64 fb;
};
//SIG(1 STT1144) C1{ Fs FL:48 FL}



static void Test_STT1144()
{
  {
    init_simple_test("STT1144");
    static STT1144 lv;
    check2(sizeof(lv), 16, "sizeof(STT1144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1144)");
    check_field_offset(lv, fa, 0, "STT1144.fa");
    check_field_offset(lv, fb, 8, "STT1144.fb");
  }
}
static Arrange_To_Call_Me vSTT1144(Test_STT1144, "STT1144", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1154  {
  short fa;
  unsigned char bf:3;
  __tsi64 fb;
};
//SIG(1 STT1154) C1{ Fs Fc:3 FL}



static void Test_STT1154()
{
  {
    init_simple_test("STT1154");
    static STT1154 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1154)");
    check_field_offset(lv, fa, 0, "STT1154.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1154");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1154");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1154.fb");
  }
}
static Arrange_To_Call_Me vSTT1154(Test_STT1154, "STT1154", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1164  {
  short fa;
  unsigned short bf:3;
  __tsi64 fb;
};
//SIG(1 STT1164) C1{ Fs Fs:3 FL}



static void Test_STT1164()
{
  {
    init_simple_test("STT1164");
    static STT1164 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1164)");
    check_field_offset(lv, fa, 0, "STT1164.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1164");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1164");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1164.fb");
  }
}
static Arrange_To_Call_Me vSTT1164(Test_STT1164, "STT1164", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1174  {
  short fa;
  unsigned int bf:3;
  __tsi64 fb;
};
//SIG(1 STT1174) C1{ Fs Fi:3 FL}



static void Test_STT1174()
{
  {
    init_simple_test("STT1174");
    static STT1174 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1174)");
    check_field_offset(lv, fa, 0, "STT1174.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1174");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1174");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1174.fb");
  }
}
static Arrange_To_Call_Me vSTT1174(Test_STT1174, "STT1174", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1184  {
  short fa;
  __tsu64 bf:3;
  __tsi64 fb;
};
//SIG(1 STT1184) C1{ Fs FL:3 FL}



static void Test_STT1184()
{
  {
    init_simple_test("STT1184");
    static STT1184 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1184)");
    check_field_offset(lv, fa, 0, "STT1184.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1184");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1184");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1184.fb");
  }
}
static Arrange_To_Call_Me vSTT1184(Test_STT1184, "STT1184", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1194  {
  short fa;
  unsigned short bf:8;
  __tsi64 fb;
};
//SIG(1 STT1194) C1{ Fs Fs:8 FL}



static void Test_STT1194()
{
  {
    init_simple_test("STT1194");
    static STT1194 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1194)");
    check_field_offset(lv, fa, 0, "STT1194.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1194");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1194");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1194.fb");
  }
}
static Arrange_To_Call_Me vSTT1194(Test_STT1194, "STT1194", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1204  {
  short fa;
  unsigned int bf:8;
  __tsi64 fb;
};
//SIG(1 STT1204) C1{ Fs Fi:8 FL}



static void Test_STT1204()
{
  {
    init_simple_test("STT1204");
    static STT1204 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1204)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1204)");
    check_field_offset(lv, fa, 0, "STT1204.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1204");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1204");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1204.fb");
  }
}
static Arrange_To_Call_Me vSTT1204(Test_STT1204, "STT1204", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1214  {
  short fa;
  __tsu64 bf:8;
  __tsi64 fb;
};
//SIG(1 STT1214) C1{ Fs FL:8 FL}



static void Test_STT1214()
{
  {
    init_simple_test("STT1214");
    static STT1214 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1214)");
    check_field_offset(lv, fa, 0, "STT1214.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1214");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1214");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1214.fb");
  }
}
static Arrange_To_Call_Me vSTT1214(Test_STT1214, "STT1214", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1224  {
  short fa;
  unsigned int bf:18;
  __tsi64 fb;
};
//SIG(1 STT1224) C1{ Fs Fi:18 FL}



static void Test_STT1224()
{
  {
    init_simple_test("STT1224");
    static STT1224 lv;
    check2(sizeof(lv), 16, "sizeof(STT1224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1224)");
    check_field_offset(lv, fa, 0, "STT1224.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1224");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1224");
    check_field_offset(lv, fb, 8, "STT1224.fb");
  }
}
static Arrange_To_Call_Me vSTT1224(Test_STT1224, "STT1224", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1234  {
  short fa;
  __tsu64 bf:18;
  __tsi64 fb;
};
//SIG(1 STT1234) C1{ Fs FL:18 FL}



static void Test_STT1234()
{
  {
    init_simple_test("STT1234");
    static STT1234 lv;
    check2(sizeof(lv), 16, "sizeof(STT1234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1234)");
    check_field_offset(lv, fa, 0, "STT1234.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1234");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1234");
    check_field_offset(lv, fb, 8, "STT1234.fb");
  }
}
static Arrange_To_Call_Me vSTT1234(Test_STT1234, "STT1234", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1244  {
  short fa;
  __tsu64 bf:48;
  __tsi64 fb;
};
//SIG(1 STT1244) C1{ Fs FL:48 FL}



static void Test_STT1244()
{
  {
    init_simple_test("STT1244");
    static STT1244 lv;
    check2(sizeof(lv), 16, "sizeof(STT1244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1244)");
    check_field_offset(lv, fa, 0, "STT1244.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1244");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1244");
    check_field_offset(lv, fb, 8, "STT1244.fb");
  }
}
static Arrange_To_Call_Me vSTT1244(Test_STT1244, "STT1244", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT115  {
  short fa;
  unsigned char  :0;
  void *fb;
};
//SIG(1 STT115) C1{ Fs Fc:0 Fp}



static void Test_STT115()
{
  {
    init_simple_test("STT115");
    static STT115 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT115)");
    check_field_offset(lv, fa, 0, "STT115.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT115.fb");
  }
}
static Arrange_To_Call_Me vSTT115(Test_STT115, "STT115", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT125  {
  short fa;
  unsigned short  :0;
  void *fb;
};
//SIG(1 STT125) C1{ Fs Fs:0 Fp}



static void Test_STT125()
{
  {
    init_simple_test("STT125");
    static STT125 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT125)");
    check_field_offset(lv, fa, 0, "STT125.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT125.fb");
  }
}
static Arrange_To_Call_Me vSTT125(Test_STT125, "STT125", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT135  {
  short fa;
  unsigned int  :0;
  void *fb;
};
//SIG(1 STT135) C1{ Fs Fi:0 Fp}



static void Test_STT135()
{
  {
    init_simple_test("STT135");
    static STT135 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT135)");
    check_field_offset(lv, fa, 0, "STT135.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT135.fb");
  }
}
static Arrange_To_Call_Me vSTT135(Test_STT135, "STT135", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT145  {
  short fa;
  __tsu64  :0;
  void *fb;
};
//SIG(1 STT145) C1{ Fs FL:0 Fp}



static void Test_STT145()
{
  {
    init_simple_test("STT145");
    static STT145 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT145)");
    check_field_offset(lv, fa, 0, "STT145.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT145.fb");
  }
}
static Arrange_To_Call_Me vSTT145(Test_STT145, "STT145", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT155  {
  short fa;
  unsigned char  :3;
  void *fb;
};
//SIG(1 STT155) C1{ Fs Fc:3 Fp}



static void Test_STT155()
{
  {
    init_simple_test("STT155");
    static STT155 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT155)");
    check_field_offset(lv, fa, 0, "STT155.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT155.fb");
  }
}
static Arrange_To_Call_Me vSTT155(Test_STT155, "STT155", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT165  {
  short fa;
  unsigned short  :3;
  void *fb;
};
//SIG(1 STT165) C1{ Fs Fs:3 Fp}



static void Test_STT165()
{
  {
    init_simple_test("STT165");
    static STT165 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT165)");
    check_field_offset(lv, fa, 0, "STT165.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT165.fb");
  }
}
static Arrange_To_Call_Me vSTT165(Test_STT165, "STT165", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT175  {
  short fa;
  unsigned int  :3;
  void *fb;
};
//SIG(1 STT175) C1{ Fs Fi:3 Fp}



static void Test_STT175()
{
  {
    init_simple_test("STT175");
    static STT175 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT175)");
    check_field_offset(lv, fa, 0, "STT175.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT175.fb");
  }
}
static Arrange_To_Call_Me vSTT175(Test_STT175, "STT175", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT185  {
  short fa;
  __tsu64  :3;
  void *fb;
};
//SIG(1 STT185) C1{ Fs FL:3 Fp}



static void Test_STT185()
{
  {
    init_simple_test("STT185");
    static STT185 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT185)");
    check_field_offset(lv, fa, 0, "STT185.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT185.fb");
  }
}
static Arrange_To_Call_Me vSTT185(Test_STT185, "STT185", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT195  {
  short fa;
  unsigned short  :8;
  void *fb;
};
//SIG(1 STT195) C1{ Fs Fs:8 Fp}



static void Test_STT195()
{
  {
    init_simple_test("STT195");
    static STT195 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT195)");
    check_field_offset(lv, fa, 0, "STT195.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT195.fb");
  }
}
static Arrange_To_Call_Me vSTT195(Test_STT195, "STT195", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1105  {
  short fa;
  unsigned int  :8;
  void *fb;
};
//SIG(1 STT1105) C1{ Fs Fi:8 Fp}



static void Test_STT1105()
{
  {
    init_simple_test("STT1105");
    static STT1105 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1105)");
    check_field_offset(lv, fa, 0, "STT1105.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1105.fb");
  }
}
static Arrange_To_Call_Me vSTT1105(Test_STT1105, "STT1105", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1115  {
  short fa;
  __tsu64  :8;
  void *fb;
};
//SIG(1 STT1115) C1{ Fs FL:8 Fp}



static void Test_STT1115()
{
  {
    init_simple_test("STT1115");
    static STT1115 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1115)");
    check_field_offset(lv, fa, 0, "STT1115.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1115.fb");
  }
}
static Arrange_To_Call_Me vSTT1115(Test_STT1115, "STT1115", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1125  {
  short fa;
  unsigned int  :18;
  void *fb;
};
//SIG(1 STT1125) C1{ Fs Fi:18 Fp}



static void Test_STT1125()
{
  {
    init_simple_test("STT1125");
    static STT1125 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1125)");
    check_field_offset(lv, fa, 0, "STT1125.fa");
    check_field_offset(lv, fb, 8, "STT1125.fb");
  }
}
static Arrange_To_Call_Me vSTT1125(Test_STT1125, "STT1125", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1135  {
  short fa;
  __tsu64  :18;
  void *fb;
};
//SIG(1 STT1135) C1{ Fs FL:18 Fp}



static void Test_STT1135()
{
  {
    init_simple_test("STT1135");
    static STT1135 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1135)");
    check_field_offset(lv, fa, 0, "STT1135.fa");
    check_field_offset(lv, fb, 8, "STT1135.fb");
  }
}
static Arrange_To_Call_Me vSTT1135(Test_STT1135, "STT1135", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1145  {
  short fa;
  __tsu64  :48;
  void *fb;
};
//SIG(1 STT1145) C1{ Fs FL:48 Fp}



static void Test_STT1145()
{
  {
    init_simple_test("STT1145");
    static STT1145 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1145)");
    check_field_offset(lv, fa, 0, "STT1145.fa");
    check_field_offset(lv, fb, 8, "STT1145.fb");
  }
}
static Arrange_To_Call_Me vSTT1145(Test_STT1145, "STT1145", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1155  {
  short fa;
  unsigned char bf:3;
  void *fb;
};
//SIG(1 STT1155) C1{ Fs Fc:3 Fp}



static void Test_STT1155()
{
  {
    init_simple_test("STT1155");
    static STT1155 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1155)");
    check_field_offset(lv, fa, 0, "STT1155.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1155");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1155");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1155.fb");
  }
}
static Arrange_To_Call_Me vSTT1155(Test_STT1155, "STT1155", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1165  {
  short fa;
  unsigned short bf:3;
  void *fb;
};
//SIG(1 STT1165) C1{ Fs Fs:3 Fp}



static void Test_STT1165()
{
  {
    init_simple_test("STT1165");
    static STT1165 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1165)");
    check_field_offset(lv, fa, 0, "STT1165.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1165");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1165");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1165.fb");
  }
}
static Arrange_To_Call_Me vSTT1165(Test_STT1165, "STT1165", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1175  {
  short fa;
  unsigned int bf:3;
  void *fb;
};
//SIG(1 STT1175) C1{ Fs Fi:3 Fp}



static void Test_STT1175()
{
  {
    init_simple_test("STT1175");
    static STT1175 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1175)");
    check_field_offset(lv, fa, 0, "STT1175.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1175");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1175");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1175.fb");
  }
}
static Arrange_To_Call_Me vSTT1175(Test_STT1175, "STT1175", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1185  {
  short fa;
  __tsu64 bf:3;
  void *fb;
};
//SIG(1 STT1185) C1{ Fs FL:3 Fp}



static void Test_STT1185()
{
  {
    init_simple_test("STT1185");
    static STT1185 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1185)");
    check_field_offset(lv, fa, 0, "STT1185.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1185");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1185");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1185.fb");
  }
}
static Arrange_To_Call_Me vSTT1185(Test_STT1185, "STT1185", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1195  {
  short fa;
  unsigned short bf:8;
  void *fb;
};
//SIG(1 STT1195) C1{ Fs Fs:8 Fp}



static void Test_STT1195()
{
  {
    init_simple_test("STT1195");
    static STT1195 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1195)");
    check_field_offset(lv, fa, 0, "STT1195.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1195");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1195");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1195.fb");
  }
}
static Arrange_To_Call_Me vSTT1195(Test_STT1195, "STT1195", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1205  {
  short fa;
  unsigned int bf:8;
  void *fb;
};
//SIG(1 STT1205) C1{ Fs Fi:8 Fp}



static void Test_STT1205()
{
  {
    init_simple_test("STT1205");
    static STT1205 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1205)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1205)");
    check_field_offset(lv, fa, 0, "STT1205.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1205");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1205");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1205.fb");
  }
}
static Arrange_To_Call_Me vSTT1205(Test_STT1205, "STT1205", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1215  {
  short fa;
  __tsu64 bf:8;
  void *fb;
};
//SIG(1 STT1215) C1{ Fs FL:8 Fp}



static void Test_STT1215()
{
  {
    init_simple_test("STT1215");
    static STT1215 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT1215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1215)");
    check_field_offset(lv, fa, 0, "STT1215.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1215");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1215");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1215.fb");
  }
}
static Arrange_To_Call_Me vSTT1215(Test_STT1215, "STT1215", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1225  {
  short fa;
  unsigned int bf:18;
  void *fb;
};
//SIG(1 STT1225) C1{ Fs Fi:18 Fp}



static void Test_STT1225()
{
  {
    init_simple_test("STT1225");
    static STT1225 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1225)");
    check_field_offset(lv, fa, 0, "STT1225.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1225");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1225");
    check_field_offset(lv, fb, 8, "STT1225.fb");
  }
}
static Arrange_To_Call_Me vSTT1225(Test_STT1225, "STT1225", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1235  {
  short fa;
  __tsu64 bf:18;
  void *fb;
};
//SIG(1 STT1235) C1{ Fs FL:18 Fp}



static void Test_STT1235()
{
  {
    init_simple_test("STT1235");
    static STT1235 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1235)");
    check_field_offset(lv, fa, 0, "STT1235.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1235");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1235");
    check_field_offset(lv, fb, 8, "STT1235.fb");
  }
}
static Arrange_To_Call_Me vSTT1235(Test_STT1235, "STT1235", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1245  {
  short fa;
  __tsu64 bf:48;
  void *fb;
};
//SIG(1 STT1245) C1{ Fs FL:48 Fp}



static void Test_STT1245()
{
  {
    init_simple_test("STT1245");
    static STT1245 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1245)");
    check_field_offset(lv, fa, 0, "STT1245.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1245");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1245");
    check_field_offset(lv, fb, 8, "STT1245.fb");
  }
}
static Arrange_To_Call_Me vSTT1245(Test_STT1245, "STT1245", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT116  {
  short fa;
  unsigned char  :0;
  float fb;
};
//SIG(1 STT116) C1{ Fs Fc:0 Fi}



static void Test_STT116()
{
  {
    init_simple_test("STT116");
    static STT116 lv;
    check2(sizeof(lv), 8, "sizeof(STT116)");
    check2(__alignof__(lv), 4, "__alignof__(STT116)");
    check_field_offset(lv, fa, 0, "STT116.fa");
    check_field_offset(lv, fb, 4, "STT116.fb");
  }
}
static Arrange_To_Call_Me vSTT116(Test_STT116, "STT116", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT126  {
  short fa;
  unsigned short  :0;
  float fb;
};
//SIG(1 STT126) C1{ Fs Fs:0 Fi}



static void Test_STT126()
{
  {
    init_simple_test("STT126");
    static STT126 lv;
    check2(sizeof(lv), 8, "sizeof(STT126)");
    check2(__alignof__(lv), 4, "__alignof__(STT126)");
    check_field_offset(lv, fa, 0, "STT126.fa");
    check_field_offset(lv, fb, 4, "STT126.fb");
  }
}
static Arrange_To_Call_Me vSTT126(Test_STT126, "STT126", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT136  {
  short fa;
  unsigned int  :0;
  float fb;
};
//SIG(1 STT136) C1{ Fs Fi:0 Fi}



static void Test_STT136()
{
  {
    init_simple_test("STT136");
    static STT136 lv;
    check2(sizeof(lv), 8, "sizeof(STT136)");
    check2(__alignof__(lv), 4, "__alignof__(STT136)");
    check_field_offset(lv, fa, 0, "STT136.fa");
    check_field_offset(lv, fb, 4, "STT136.fb");
  }
}
static Arrange_To_Call_Me vSTT136(Test_STT136, "STT136", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT146  {
  short fa;
  __tsu64  :0;
  float fb;
};
//SIG(1 STT146) C1{ Fs FL:0 Fi}



static void Test_STT146()
{
  {
    init_simple_test("STT146");
    static STT146 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT146)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT146)");
    check_field_offset(lv, fa, 0, "STT146.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT146.fb");
  }
}
static Arrange_To_Call_Me vSTT146(Test_STT146, "STT146", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT156  {
  short fa;
  unsigned char  :3;
  float fb;
};
//SIG(1 STT156) C1{ Fs Fc:3 Fi}



static void Test_STT156()
{
  {
    init_simple_test("STT156");
    static STT156 lv;
    check2(sizeof(lv), 8, "sizeof(STT156)");
    check2(__alignof__(lv), 4, "__alignof__(STT156)");
    check_field_offset(lv, fa, 0, "STT156.fa");
    check_field_offset(lv, fb, 4, "STT156.fb");
  }
}
static Arrange_To_Call_Me vSTT156(Test_STT156, "STT156", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT166  {
  short fa;
  unsigned short  :3;
  float fb;
};
//SIG(1 STT166) C1{ Fs Fs:3 Fi}



static void Test_STT166()
{
  {
    init_simple_test("STT166");
    static STT166 lv;
    check2(sizeof(lv), 8, "sizeof(STT166)");
    check2(__alignof__(lv), 4, "__alignof__(STT166)");
    check_field_offset(lv, fa, 0, "STT166.fa");
    check_field_offset(lv, fb, 4, "STT166.fb");
  }
}
static Arrange_To_Call_Me vSTT166(Test_STT166, "STT166", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT176  {
  short fa;
  unsigned int  :3;
  float fb;
};
//SIG(1 STT176) C1{ Fs Fi:3 Fi}



static void Test_STT176()
{
  {
    init_simple_test("STT176");
    static STT176 lv;
    check2(sizeof(lv), 8, "sizeof(STT176)");
    check2(__alignof__(lv), 4, "__alignof__(STT176)");
    check_field_offset(lv, fa, 0, "STT176.fa");
    check_field_offset(lv, fb, 4, "STT176.fb");
  }
}
static Arrange_To_Call_Me vSTT176(Test_STT176, "STT176", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT186  {
  short fa;
  __tsu64  :3;
  float fb;
};
//SIG(1 STT186) C1{ Fs FL:3 Fi}



static void Test_STT186()
{
  {
    init_simple_test("STT186");
    static STT186 lv;
    check2(sizeof(lv), 8, "sizeof(STT186)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT186)");
    check_field_offset(lv, fa, 0, "STT186.fa");
    check_field_offset(lv, fb, 4, "STT186.fb");
  }
}
static Arrange_To_Call_Me vSTT186(Test_STT186, "STT186", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT196  {
  short fa;
  unsigned short  :8;
  float fb;
};
//SIG(1 STT196) C1{ Fs Fs:8 Fi}



static void Test_STT196()
{
  {
    init_simple_test("STT196");
    static STT196 lv;
    check2(sizeof(lv), 8, "sizeof(STT196)");
    check2(__alignof__(lv), 4, "__alignof__(STT196)");
    check_field_offset(lv, fa, 0, "STT196.fa");
    check_field_offset(lv, fb, 4, "STT196.fb");
  }
}
static Arrange_To_Call_Me vSTT196(Test_STT196, "STT196", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1106  {
  short fa;
  unsigned int  :8;
  float fb;
};
//SIG(1 STT1106) C1{ Fs Fi:8 Fi}



static void Test_STT1106()
{
  {
    init_simple_test("STT1106");
    static STT1106 lv;
    check2(sizeof(lv), 8, "sizeof(STT1106)");
    check2(__alignof__(lv), 4, "__alignof__(STT1106)");
    check_field_offset(lv, fa, 0, "STT1106.fa");
    check_field_offset(lv, fb, 4, "STT1106.fb");
  }
}
static Arrange_To_Call_Me vSTT1106(Test_STT1106, "STT1106", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1116  {
  short fa;
  __tsu64  :8;
  float fb;
};
//SIG(1 STT1116) C1{ Fs FL:8 Fi}



static void Test_STT1116()
{
  {
    init_simple_test("STT1116");
    static STT1116 lv;
    check2(sizeof(lv), 8, "sizeof(STT1116)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT1116)");
    check_field_offset(lv, fa, 0, "STT1116.fa");
    check_field_offset(lv, fb, 4, "STT1116.fb");
  }
}
static Arrange_To_Call_Me vSTT1116(Test_STT1116, "STT1116", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1126  {
  short fa;
  unsigned int  :18;
  float fb;
};
//SIG(1 STT1126) C1{ Fs Fi:18 Fi}



static void Test_STT1126()
{
  {
    init_simple_test("STT1126");
    static STT1126 lv;
    check2(sizeof(lv), 12, "sizeof(STT1126)");
    check2(__alignof__(lv), 4, "__alignof__(STT1126)");
    check_field_offset(lv, fa, 0, "STT1126.fa");
    check_field_offset(lv, fb, 8, "STT1126.fb");
  }
}
static Arrange_To_Call_Me vSTT1126(Test_STT1126, "STT1126", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1136  {
  short fa;
  __tsu64  :18;
  float fb;
};
//SIG(1 STT1136) C1{ Fs FL:18 Fi}



static void Test_STT1136()
{
  {
    init_simple_test("STT1136");
    static STT1136 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT1136)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT1136)");
    check_field_offset(lv, fa, 0, "STT1136.fa");
    check_field_offset(lv, fb, 8, "STT1136.fb");
  }
}
static Arrange_To_Call_Me vSTT1136(Test_STT1136, "STT1136", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1146  {
  short fa;
  __tsu64  :48;
  float fb;
};
//SIG(1 STT1146) C1{ Fs FL:48 Fi}



static void Test_STT1146()
{
  {
    init_simple_test("STT1146");
    static STT1146 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT1146)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT1146)");
    check_field_offset(lv, fa, 0, "STT1146.fa");
    check_field_offset(lv, fb, 8, "STT1146.fb");
  }
}
static Arrange_To_Call_Me vSTT1146(Test_STT1146, "STT1146", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1156  {
  short fa;
  unsigned char bf:3;
  float fb;
};
//SIG(1 STT1156) C1{ Fs Fc:3 Fi}



static void Test_STT1156()
{
  {
    init_simple_test("STT1156");
    static STT1156 lv;
    check2(sizeof(lv), 8, "sizeof(STT1156)");
    check2(__alignof__(lv), 4, "__alignof__(STT1156)");
    check_field_offset(lv, fa, 0, "STT1156.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1156");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1156");
    check_field_offset(lv, fb, 4, "STT1156.fb");
  }
}
static Arrange_To_Call_Me vSTT1156(Test_STT1156, "STT1156", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1166  {
  short fa;
  unsigned short bf:3;
  float fb;
};
//SIG(1 STT1166) C1{ Fs Fs:3 Fi}



static void Test_STT1166()
{
  {
    init_simple_test("STT1166");
    static STT1166 lv;
    check2(sizeof(lv), 8, "sizeof(STT1166)");
    check2(__alignof__(lv), 4, "__alignof__(STT1166)");
    check_field_offset(lv, fa, 0, "STT1166.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1166");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1166");
    check_field_offset(lv, fb, 4, "STT1166.fb");
  }
}
static Arrange_To_Call_Me vSTT1166(Test_STT1166, "STT1166", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1176  {
  short fa;
  unsigned int bf:3;
  float fb;
};
//SIG(1 STT1176) C1{ Fs Fi:3 Fi}



static void Test_STT1176()
{
  {
    init_simple_test("STT1176");
    static STT1176 lv;
    check2(sizeof(lv), 8, "sizeof(STT1176)");
    check2(__alignof__(lv), 4, "__alignof__(STT1176)");
    check_field_offset(lv, fa, 0, "STT1176.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1176");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1176");
    check_field_offset(lv, fb, 4, "STT1176.fb");
  }
}
static Arrange_To_Call_Me vSTT1176(Test_STT1176, "STT1176", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1186  {
  short fa;
  __tsu64 bf:3;
  float fb;
};
//SIG(1 STT1186) C1{ Fs FL:3 Fi}



static void Test_STT1186()
{
  {
    init_simple_test("STT1186");
    static STT1186 lv;
    check2(sizeof(lv), 8, "sizeof(STT1186)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1186)");
    check_field_offset(lv, fa, 0, "STT1186.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1186");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1186");
    check_field_offset(lv, fb, 4, "STT1186.fb");
  }
}
static Arrange_To_Call_Me vSTT1186(Test_STT1186, "STT1186", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1196  {
  short fa;
  unsigned short bf:8;
  float fb;
};
//SIG(1 STT1196) C1{ Fs Fs:8 Fi}



static void Test_STT1196()
{
  {
    init_simple_test("STT1196");
    static STT1196 lv;
    check2(sizeof(lv), 8, "sizeof(STT1196)");
    check2(__alignof__(lv), 4, "__alignof__(STT1196)");
    check_field_offset(lv, fa, 0, "STT1196.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1196");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1196");
    check_field_offset(lv, fb, 4, "STT1196.fb");
  }
}
static Arrange_To_Call_Me vSTT1196(Test_STT1196, "STT1196", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1206  {
  short fa;
  unsigned int bf:8;
  float fb;
};
//SIG(1 STT1206) C1{ Fs Fi:8 Fi}



static void Test_STT1206()
{
  {
    init_simple_test("STT1206");
    static STT1206 lv;
    check2(sizeof(lv), 8, "sizeof(STT1206)");
    check2(__alignof__(lv), 4, "__alignof__(STT1206)");
    check_field_offset(lv, fa, 0, "STT1206.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1206");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1206");
    check_field_offset(lv, fb, 4, "STT1206.fb");
  }
}
static Arrange_To_Call_Me vSTT1206(Test_STT1206, "STT1206", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1216  {
  short fa;
  __tsu64 bf:8;
  float fb;
};
//SIG(1 STT1216) C1{ Fs FL:8 Fi}



static void Test_STT1216()
{
  {
    init_simple_test("STT1216");
    static STT1216 lv;
    check2(sizeof(lv), 8, "sizeof(STT1216)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1216)");
    check_field_offset(lv, fa, 0, "STT1216.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1216");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1216");
    check_field_offset(lv, fb, 4, "STT1216.fb");
  }
}
static Arrange_To_Call_Me vSTT1216(Test_STT1216, "STT1216", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1226  {
  short fa;
  unsigned int bf:18;
  float fb;
};
//SIG(1 STT1226) C1{ Fs Fi:18 Fi}



static void Test_STT1226()
{
  {
    init_simple_test("STT1226");
    static STT1226 lv;
    check2(sizeof(lv), 12, "sizeof(STT1226)");
    check2(__alignof__(lv), 4, "__alignof__(STT1226)");
    check_field_offset(lv, fa, 0, "STT1226.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1226");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1226");
    check_field_offset(lv, fb, 8, "STT1226.fb");
  }
}
static Arrange_To_Call_Me vSTT1226(Test_STT1226, "STT1226", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1236  {
  short fa;
  __tsu64 bf:18;
  float fb;
};
//SIG(1 STT1236) C1{ Fs FL:18 Fi}



static void Test_STT1236()
{
  {
    init_simple_test("STT1236");
    static STT1236 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1236)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1236)");
    check_field_offset(lv, fa, 0, "STT1236.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1236");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1236");
    check_field_offset(lv, fb, 8, "STT1236.fb");
  }
}
static Arrange_To_Call_Me vSTT1236(Test_STT1236, "STT1236", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1246  {
  short fa;
  __tsu64 bf:48;
  float fb;
};
//SIG(1 STT1246) C1{ Fs FL:48 Fi}



static void Test_STT1246()
{
  {
    init_simple_test("STT1246");
    static STT1246 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1246)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1246)");
    check_field_offset(lv, fa, 0, "STT1246.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1246");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1246");
    check_field_offset(lv, fb, 8, "STT1246.fb");
  }
}
static Arrange_To_Call_Me vSTT1246(Test_STT1246, "STT1246", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT117  {
  short fa;
  unsigned char  :0;
  double fb;
};
//SIG(1 STT117) C1{ Fs Fc:0 FL}



static void Test_STT117()
{
  {
    init_simple_test("STT117");
    static STT117 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT117)");
    check_field_offset(lv, fa, 0, "STT117.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT117.fb");
  }
}
static Arrange_To_Call_Me vSTT117(Test_STT117, "STT117", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT127  {
  short fa;
  unsigned short  :0;
  double fb;
};
//SIG(1 STT127) C1{ Fs Fs:0 FL}



static void Test_STT127()
{
  {
    init_simple_test("STT127");
    static STT127 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT127)");
    check_field_offset(lv, fa, 0, "STT127.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT127.fb");
  }
}
static Arrange_To_Call_Me vSTT127(Test_STT127, "STT127", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT137  {
  short fa;
  unsigned int  :0;
  double fb;
};
//SIG(1 STT137) C1{ Fs Fi:0 FL}



static void Test_STT137()
{
  {
    init_simple_test("STT137");
    static STT137 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT137)");
    check_field_offset(lv, fa, 0, "STT137.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT137.fb");
  }
}
static Arrange_To_Call_Me vSTT137(Test_STT137, "STT137", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT147  {
  short fa;
  __tsu64  :0;
  double fb;
};
//SIG(1 STT147) C1{ Fs FL:0 FL}



static void Test_STT147()
{
  {
    init_simple_test("STT147");
    static STT147 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT147)");
    check_field_offset(lv, fa, 0, "STT147.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT147.fb");
  }
}
static Arrange_To_Call_Me vSTT147(Test_STT147, "STT147", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT157  {
  short fa;
  unsigned char  :3;
  double fb;
};
//SIG(1 STT157) C1{ Fs Fc:3 FL}



static void Test_STT157()
{
  {
    init_simple_test("STT157");
    static STT157 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT157)");
    check_field_offset(lv, fa, 0, "STT157.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT157.fb");
  }
}
static Arrange_To_Call_Me vSTT157(Test_STT157, "STT157", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT167  {
  short fa;
  unsigned short  :3;
  double fb;
};
//SIG(1 STT167) C1{ Fs Fs:3 FL}



static void Test_STT167()
{
  {
    init_simple_test("STT167");
    static STT167 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT167)");
    check_field_offset(lv, fa, 0, "STT167.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT167.fb");
  }
}
static Arrange_To_Call_Me vSTT167(Test_STT167, "STT167", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT177  {
  short fa;
  unsigned int  :3;
  double fb;
};
//SIG(1 STT177) C1{ Fs Fi:3 FL}



static void Test_STT177()
{
  {
    init_simple_test("STT177");
    static STT177 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT177)");
    check_field_offset(lv, fa, 0, "STT177.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT177.fb");
  }
}
static Arrange_To_Call_Me vSTT177(Test_STT177, "STT177", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT187  {
  short fa;
  __tsu64  :3;
  double fb;
};
//SIG(1 STT187) C1{ Fs FL:3 FL}



static void Test_STT187()
{
  {
    init_simple_test("STT187");
    static STT187 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT187)");
    check_field_offset(lv, fa, 0, "STT187.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT187.fb");
  }
}
static Arrange_To_Call_Me vSTT187(Test_STT187, "STT187", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT197  {
  short fa;
  unsigned short  :8;
  double fb;
};
//SIG(1 STT197) C1{ Fs Fs:8 FL}



static void Test_STT197()
{
  {
    init_simple_test("STT197");
    static STT197 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT197)");
    check_field_offset(lv, fa, 0, "STT197.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT197.fb");
  }
}
static Arrange_To_Call_Me vSTT197(Test_STT197, "STT197", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1107  {
  short fa;
  unsigned int  :8;
  double fb;
};
//SIG(1 STT1107) C1{ Fs Fi:8 FL}



static void Test_STT1107()
{
  {
    init_simple_test("STT1107");
    static STT1107 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1107)");
    check_field_offset(lv, fa, 0, "STT1107.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1107.fb");
  }
}
static Arrange_To_Call_Me vSTT1107(Test_STT1107, "STT1107", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1117  {
  short fa;
  __tsu64  :8;
  double fb;
};
//SIG(1 STT1117) C1{ Fs FL:8 FL}



static void Test_STT1117()
{
  {
    init_simple_test("STT1117");
    static STT1117 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1117)");
    check_field_offset(lv, fa, 0, "STT1117.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1117.fb");
  }
}
static Arrange_To_Call_Me vSTT1117(Test_STT1117, "STT1117", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1127  {
  short fa;
  unsigned int  :18;
  double fb;
};
//SIG(1 STT1127) C1{ Fs Fi:18 FL}



static void Test_STT1127()
{
  {
    init_simple_test("STT1127");
    static STT1127 lv;
    check2(sizeof(lv), 16, "sizeof(STT1127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1127)");
    check_field_offset(lv, fa, 0, "STT1127.fa");
    check_field_offset(lv, fb, 8, "STT1127.fb");
  }
}
static Arrange_To_Call_Me vSTT1127(Test_STT1127, "STT1127", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1137  {
  short fa;
  __tsu64  :18;
  double fb;
};
//SIG(1 STT1137) C1{ Fs FL:18 FL}



static void Test_STT1137()
{
  {
    init_simple_test("STT1137");
    static STT1137 lv;
    check2(sizeof(lv), 16, "sizeof(STT1137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1137)");
    check_field_offset(lv, fa, 0, "STT1137.fa");
    check_field_offset(lv, fb, 8, "STT1137.fb");
  }
}
static Arrange_To_Call_Me vSTT1137(Test_STT1137, "STT1137", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1147  {
  short fa;
  __tsu64  :48;
  double fb;
};
//SIG(1 STT1147) C1{ Fs FL:48 FL}



static void Test_STT1147()
{
  {
    init_simple_test("STT1147");
    static STT1147 lv;
    check2(sizeof(lv), 16, "sizeof(STT1147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1147)");
    check_field_offset(lv, fa, 0, "STT1147.fa");
    check_field_offset(lv, fb, 8, "STT1147.fb");
  }
}
static Arrange_To_Call_Me vSTT1147(Test_STT1147, "STT1147", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1157  {
  short fa;
  unsigned char bf:3;
  double fb;
};
//SIG(1 STT1157) C1{ Fs Fc:3 FL}



static void Test_STT1157()
{
  {
    init_simple_test("STT1157");
    static STT1157 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1157)");
    check_field_offset(lv, fa, 0, "STT1157.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1157");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1157");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1157.fb");
  }
}
static Arrange_To_Call_Me vSTT1157(Test_STT1157, "STT1157", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1167  {
  short fa;
  unsigned short bf:3;
  double fb;
};
//SIG(1 STT1167) C1{ Fs Fs:3 FL}



static void Test_STT1167()
{
  {
    init_simple_test("STT1167");
    static STT1167 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1167)");
    check_field_offset(lv, fa, 0, "STT1167.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1167");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1167");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1167.fb");
  }
}
static Arrange_To_Call_Me vSTT1167(Test_STT1167, "STT1167", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1177  {
  short fa;
  unsigned int bf:3;
  double fb;
};
//SIG(1 STT1177) C1{ Fs Fi:3 FL}



static void Test_STT1177()
{
  {
    init_simple_test("STT1177");
    static STT1177 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1177)");
    check_field_offset(lv, fa, 0, "STT1177.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1177");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1177");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1177.fb");
  }
}
static Arrange_To_Call_Me vSTT1177(Test_STT1177, "STT1177", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1187  {
  short fa;
  __tsu64 bf:3;
  double fb;
};
//SIG(1 STT1187) C1{ Fs FL:3 FL}



static void Test_STT1187()
{
  {
    init_simple_test("STT1187");
    static STT1187 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1187)");
    check_field_offset(lv, fa, 0, "STT1187.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1187");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1187");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1187.fb");
  }
}
static Arrange_To_Call_Me vSTT1187(Test_STT1187, "STT1187", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1197  {
  short fa;
  unsigned short bf:8;
  double fb;
};
//SIG(1 STT1197) C1{ Fs Fs:8 FL}



static void Test_STT1197()
{
  {
    init_simple_test("STT1197");
    static STT1197 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1197)");
    check_field_offset(lv, fa, 0, "STT1197.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1197");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1197");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1197.fb");
  }
}
static Arrange_To_Call_Me vSTT1197(Test_STT1197, "STT1197", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1207  {
  short fa;
  unsigned int bf:8;
  double fb;
};
//SIG(1 STT1207) C1{ Fs Fi:8 FL}



static void Test_STT1207()
{
  {
    init_simple_test("STT1207");
    static STT1207 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1207)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1207)");
    check_field_offset(lv, fa, 0, "STT1207.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1207");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1207");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1207.fb");
  }
}
static Arrange_To_Call_Me vSTT1207(Test_STT1207, "STT1207", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1217  {
  short fa;
  __tsu64 bf:8;
  double fb;
};
//SIG(1 STT1217) C1{ Fs FL:8 FL}



static void Test_STT1217()
{
  {
    init_simple_test("STT1217");
    static STT1217 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT1217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1217)");
    check_field_offset(lv, fa, 0, "STT1217.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1217");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1217");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT1217.fb");
  }
}
static Arrange_To_Call_Me vSTT1217(Test_STT1217, "STT1217", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1227  {
  short fa;
  unsigned int bf:18;
  double fb;
};
//SIG(1 STT1227) C1{ Fs Fi:18 FL}



static void Test_STT1227()
{
  {
    init_simple_test("STT1227");
    static STT1227 lv;
    check2(sizeof(lv), 16, "sizeof(STT1227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1227)");
    check_field_offset(lv, fa, 0, "STT1227.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1227");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1227");
    check_field_offset(lv, fb, 8, "STT1227.fb");
  }
}
static Arrange_To_Call_Me vSTT1227(Test_STT1227, "STT1227", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1237  {
  short fa;
  __tsu64 bf:18;
  double fb;
};
//SIG(1 STT1237) C1{ Fs FL:18 FL}



static void Test_STT1237()
{
  {
    init_simple_test("STT1237");
    static STT1237 lv;
    check2(sizeof(lv), 16, "sizeof(STT1237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1237)");
    check_field_offset(lv, fa, 0, "STT1237.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1237");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1237");
    check_field_offset(lv, fb, 8, "STT1237.fb");
  }
}
static Arrange_To_Call_Me vSTT1237(Test_STT1237, "STT1237", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1247  {
  short fa;
  __tsu64 bf:48;
  double fb;
};
//SIG(1 STT1247) C1{ Fs FL:48 FL}



static void Test_STT1247()
{
  {
    init_simple_test("STT1247");
    static STT1247 lv;
    check2(sizeof(lv), 16, "sizeof(STT1247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1247)");
    check_field_offset(lv, fa, 0, "STT1247.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1247");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1247");
    check_field_offset(lv, fb, 8, "STT1247.fb");
  }
}
static Arrange_To_Call_Me vSTT1247(Test_STT1247, "STT1247", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT118  {
  short fa;
  unsigned char  :0;
  long double fb;
};
//SIG(1 STT118) C1{ Fs Fc:0 FD}



static void Test_STT118()
{
  {
    init_simple_test("STT118");
    static STT118 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT118)");
    check_field_offset(lv, fa, 0, "STT118.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT118.fb");
  }
}
static Arrange_To_Call_Me vSTT118(Test_STT118, "STT118", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT128  {
  short fa;
  unsigned short  :0;
  long double fb;
};
//SIG(1 STT128) C1{ Fs Fs:0 FD}



static void Test_STT128()
{
  {
    init_simple_test("STT128");
    static STT128 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT128)");
    check_field_offset(lv, fa, 0, "STT128.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT128.fb");
  }
}
static Arrange_To_Call_Me vSTT128(Test_STT128, "STT128", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT138  {
  short fa;
  unsigned int  :0;
  long double fb;
};
//SIG(1 STT138) C1{ Fs Fi:0 FD}



static void Test_STT138()
{
  {
    init_simple_test("STT138");
    static STT138 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT138)");
    check_field_offset(lv, fa, 0, "STT138.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT138.fb");
  }
}
static Arrange_To_Call_Me vSTT138(Test_STT138, "STT138", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT148  {
  short fa;
  __tsu64  :0;
  long double fb;
};
//SIG(1 STT148) C1{ Fs FL:0 FD}



static void Test_STT148()
{
  {
    init_simple_test("STT148");
    static STT148 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT148)");
    check_field_offset(lv, fa, 0, "STT148.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT148.fb");
  }
}
static Arrange_To_Call_Me vSTT148(Test_STT148, "STT148", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT158  {
  short fa;
  unsigned char  :3;
  long double fb;
};
//SIG(1 STT158) C1{ Fs Fc:3 FD}



static void Test_STT158()
{
  {
    init_simple_test("STT158");
    static STT158 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT158)");
    check_field_offset(lv, fa, 0, "STT158.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT158.fb");
  }
}
static Arrange_To_Call_Me vSTT158(Test_STT158, "STT158", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT168  {
  short fa;
  unsigned short  :3;
  long double fb;
};
//SIG(1 STT168) C1{ Fs Fs:3 FD}



static void Test_STT168()
{
  {
    init_simple_test("STT168");
    static STT168 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT168)");
    check_field_offset(lv, fa, 0, "STT168.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT168.fb");
  }
}
static Arrange_To_Call_Me vSTT168(Test_STT168, "STT168", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT178  {
  short fa;
  unsigned int  :3;
  long double fb;
};
//SIG(1 STT178) C1{ Fs Fi:3 FD}



static void Test_STT178()
{
  {
    init_simple_test("STT178");
    static STT178 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT178)");
    check_field_offset(lv, fa, 0, "STT178.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT178.fb");
  }
}
static Arrange_To_Call_Me vSTT178(Test_STT178, "STT178", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT188  {
  short fa;
  __tsu64  :3;
  long double fb;
};
//SIG(1 STT188) C1{ Fs FL:3 FD}



static void Test_STT188()
{
  {
    init_simple_test("STT188");
    static STT188 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT188)");
    check_field_offset(lv, fa, 0, "STT188.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT188.fb");
  }
}
static Arrange_To_Call_Me vSTT188(Test_STT188, "STT188", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT198  {
  short fa;
  unsigned short  :8;
  long double fb;
};
//SIG(1 STT198) C1{ Fs Fs:8 FD}



static void Test_STT198()
{
  {
    init_simple_test("STT198");
    static STT198 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT198)");
    check_field_offset(lv, fa, 0, "STT198.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT198.fb");
  }
}
static Arrange_To_Call_Me vSTT198(Test_STT198, "STT198", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1108  {
  short fa;
  unsigned int  :8;
  long double fb;
};
//SIG(1 STT1108) C1{ Fs Fi:8 FD}



static void Test_STT1108()
{
  {
    init_simple_test("STT1108");
    static STT1108 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1108)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1108)");
    check_field_offset(lv, fa, 0, "STT1108.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1108.fb");
  }
}
static Arrange_To_Call_Me vSTT1108(Test_STT1108, "STT1108", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1118  {
  short fa;
  __tsu64  :8;
  long double fb;
};
//SIG(1 STT1118) C1{ Fs FL:8 FD}



static void Test_STT1118()
{
  {
    init_simple_test("STT1118");
    static STT1118 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1118)");
    check_field_offset(lv, fa, 0, "STT1118.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1118.fb");
  }
}
static Arrange_To_Call_Me vSTT1118(Test_STT1118, "STT1118", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1128  {
  short fa;
  unsigned int  :18;
  long double fb;
};
//SIG(1 STT1128) C1{ Fs Fi:18 FD}



static void Test_STT1128()
{
  {
    init_simple_test("STT1128");
    static STT1128 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT1128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1128)");
    check_field_offset(lv, fa, 0, "STT1128.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT1128.fb");
  }
}
static Arrange_To_Call_Me vSTT1128(Test_STT1128, "STT1128", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1138  {
  short fa;
  __tsu64  :18;
  long double fb;
};
//SIG(1 STT1138) C1{ Fs FL:18 FD}



static void Test_STT1138()
{
  {
    init_simple_test("STT1138");
    static STT1138 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT1138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1138)");
    check_field_offset(lv, fa, 0, "STT1138.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT1138.fb");
  }
}
static Arrange_To_Call_Me vSTT1138(Test_STT1138, "STT1138", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1148  {
  short fa;
  __tsu64  :48;
  long double fb;
};
//SIG(1 STT1148) C1{ Fs FL:48 FD}



static void Test_STT1148()
{
  {
    init_simple_test("STT1148");
    static STT1148 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT1148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1148)");
    check_field_offset(lv, fa, 0, "STT1148.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT1148.fb");
  }
}
static Arrange_To_Call_Me vSTT1148(Test_STT1148, "STT1148", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1158  {
  short fa;
  unsigned char bf:3;
  long double fb;
};
//SIG(1 STT1158) C1{ Fs Fc:3 FD}



static void Test_STT1158()
{
  {
    init_simple_test("STT1158");
    static STT1158 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1158)");
    check_field_offset(lv, fa, 0, "STT1158.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1158");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1158");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1158.fb");
  }
}
static Arrange_To_Call_Me vSTT1158(Test_STT1158, "STT1158", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1168  {
  short fa;
  unsigned short bf:3;
  long double fb;
};
//SIG(1 STT1168) C1{ Fs Fs:3 FD}



static void Test_STT1168()
{
  {
    init_simple_test("STT1168");
    static STT1168 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1168)");
    check_field_offset(lv, fa, 0, "STT1168.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1168");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1168");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1168.fb");
  }
}
static Arrange_To_Call_Me vSTT1168(Test_STT1168, "STT1168", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1178  {
  short fa;
  unsigned int bf:3;
  long double fb;
};
//SIG(1 STT1178) C1{ Fs Fi:3 FD}



static void Test_STT1178()
{
  {
    init_simple_test("STT1178");
    static STT1178 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1178)");
    check_field_offset(lv, fa, 0, "STT1178.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1178");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1178");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1178.fb");
  }
}
static Arrange_To_Call_Me vSTT1178(Test_STT1178, "STT1178", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1188  {
  short fa;
  __tsu64 bf:3;
  long double fb;
};
//SIG(1 STT1188) C1{ Fs FL:3 FD}



static void Test_STT1188()
{
  {
    init_simple_test("STT1188");
    static STT1188 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1188)");
    check_field_offset(lv, fa, 0, "STT1188.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1188");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1188");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1188.fb");
  }
}
static Arrange_To_Call_Me vSTT1188(Test_STT1188, "STT1188", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1198  {
  short fa;
  unsigned short bf:8;
  long double fb;
};
//SIG(1 STT1198) C1{ Fs Fs:8 FD}



static void Test_STT1198()
{
  {
    init_simple_test("STT1198");
    static STT1198 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1198)");
    check_field_offset(lv, fa, 0, "STT1198.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1198");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1198");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1198.fb");
  }
}
static Arrange_To_Call_Me vSTT1198(Test_STT1198, "STT1198", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1208  {
  short fa;
  unsigned int bf:8;
  long double fb;
};
//SIG(1 STT1208) C1{ Fs Fi:8 FD}



static void Test_STT1208()
{
  {
    init_simple_test("STT1208");
    static STT1208 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1208)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1208)");
    check_field_offset(lv, fa, 0, "STT1208.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1208");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1208");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1208.fb");
  }
}
static Arrange_To_Call_Me vSTT1208(Test_STT1208, "STT1208", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1218  {
  short fa;
  __tsu64 bf:8;
  long double fb;
};
//SIG(1 STT1218) C1{ Fs FL:8 FD}



static void Test_STT1218()
{
  {
    init_simple_test("STT1218");
    static STT1218 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT1218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1218)");
    check_field_offset(lv, fa, 0, "STT1218.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1218");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1218");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT1218.fb");
  }
}
static Arrange_To_Call_Me vSTT1218(Test_STT1218, "STT1218", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1228  {
  short fa;
  unsigned int bf:18;
  long double fb;
};
//SIG(1 STT1228) C1{ Fs Fi:18 FD}



static void Test_STT1228()
{
  {
    init_simple_test("STT1228");
    static STT1228 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT1228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1228)");
    check_field_offset(lv, fa, 0, "STT1228.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1228");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1228");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT1228.fb");
  }
}
static Arrange_To_Call_Me vSTT1228(Test_STT1228, "STT1228", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1238  {
  short fa;
  __tsu64 bf:18;
  long double fb;
};
//SIG(1 STT1238) C1{ Fs FL:18 FD}



static void Test_STT1238()
{
  {
    init_simple_test("STT1238");
    static STT1238 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT1238)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1238)");
    check_field_offset(lv, fa, 0, "STT1238.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1238");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1238");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT1238.fb");
  }
}
static Arrange_To_Call_Me vSTT1238(Test_STT1238, "STT1238", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1248  {
  short fa;
  __tsu64 bf:48;
  long double fb;
};
//SIG(1 STT1248) C1{ Fs FL:48 FD}



static void Test_STT1248()
{
  {
    init_simple_test("STT1248");
    static STT1248 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT1248)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT1248)");
    check_field_offset(lv, fa, 0, "STT1248.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1248");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1248");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT1248.fb");
  }
}
static Arrange_To_Call_Me vSTT1248(Test_STT1248, "STT1248", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT119  {
  short fa;
  unsigned char  :0;
};
//SIG(1 STT119) C1{ Fs Fc:0}



static void Test_STT119()
{
  {
    init_simple_test("STT119");
    static STT119 lv;
    check2(sizeof(lv), 2, "sizeof(STT119)");
    check2(__alignof__(lv), 2, "__alignof__(STT119)");
    check_field_offset(lv, fa, 0, "STT119.fa");
  }
}
static Arrange_To_Call_Me vSTT119(Test_STT119, "STT119", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT129  {
  short fa;
  unsigned short  :0;
};
//SIG(1 STT129) C1{ Fs Fs:0}



static void Test_STT129()
{
  {
    init_simple_test("STT129");
    static STT129 lv;
    check2(sizeof(lv), 2, "sizeof(STT129)");
    check2(__alignof__(lv), 2, "__alignof__(STT129)");
    check_field_offset(lv, fa, 0, "STT129.fa");
  }
}
static Arrange_To_Call_Me vSTT129(Test_STT129, "STT129", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT139  {
  short fa;
  unsigned int  :0;
};
//SIG(1 STT139) C1{ Fs Fi:0}



static void Test_STT139()
{
  {
    init_simple_test("STT139");
    static STT139 lv;
    check2(sizeof(lv), 4, "sizeof(STT139)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT139)");
    check_field_offset(lv, fa, 0, "STT139.fa");
  }
}
static Arrange_To_Call_Me vSTT139(Test_STT139, "STT139", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT149  {
  short fa;
  __tsu64  :0;
};
//SIG(1 STT149) C1{ Fs FL:0}



static void Test_STT149()
{
  {
    init_simple_test("STT149");
    static STT149 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT149)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT149)");
    check_field_offset(lv, fa, 0, "STT149.fa");
  }
}
static Arrange_To_Call_Me vSTT149(Test_STT149, "STT149", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT159  {
  short fa;
  unsigned char  :3;
};
//SIG(1 STT159) C1{ Fs Fc:3}



static void Test_STT159()
{
  {
    init_simple_test("STT159");
    static STT159 lv;
    check2(sizeof(lv), 4, "sizeof(STT159)");
    check2(__alignof__(lv), 2, "__alignof__(STT159)");
    check_field_offset(lv, fa, 0, "STT159.fa");
  }
}
static Arrange_To_Call_Me vSTT159(Test_STT159, "STT159", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT169  {
  short fa;
  unsigned short  :3;
};
//SIG(1 STT169) C1{ Fs Fs:3}



static void Test_STT169()
{
  {
    init_simple_test("STT169");
    static STT169 lv;
    check2(sizeof(lv), 4, "sizeof(STT169)");
    check2(__alignof__(lv), 2, "__alignof__(STT169)");
    check_field_offset(lv, fa, 0, "STT169.fa");
  }
}
static Arrange_To_Call_Me vSTT169(Test_STT169, "STT169", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT179  {
  short fa;
  unsigned int  :3;
};
//SIG(1 STT179) C1{ Fs Fi:3}



static void Test_STT179()
{
  {
    init_simple_test("STT179");
    static STT179 lv;
    check2(sizeof(lv), 4, "sizeof(STT179)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT179)");
    check_field_offset(lv, fa, 0, "STT179.fa");
  }
}
static Arrange_To_Call_Me vSTT179(Test_STT179, "STT179", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT189  {
  short fa;
  __tsu64  :3;
};
//SIG(1 STT189) C1{ Fs FL:3}



static void Test_STT189()
{
  {
    init_simple_test("STT189");
    static STT189 lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(STT189)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT189)");
    check_field_offset(lv, fa, 0, "STT189.fa");
  }
}
static Arrange_To_Call_Me vSTT189(Test_STT189, "STT189", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT199  {
  short fa;
  unsigned short  :8;
};
//SIG(1 STT199) C1{ Fs Fs:8}



static void Test_STT199()
{
  {
    init_simple_test("STT199");
    static STT199 lv;
    check2(sizeof(lv), 4, "sizeof(STT199)");
    check2(__alignof__(lv), 2, "__alignof__(STT199)");
    check_field_offset(lv, fa, 0, "STT199.fa");
  }
}
static Arrange_To_Call_Me vSTT199(Test_STT199, "STT199", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1109  {
  short fa;
  unsigned int  :8;
};
//SIG(1 STT1109) C1{ Fs Fi:8}



static void Test_STT1109()
{
  {
    init_simple_test("STT1109");
    static STT1109 lv;
    check2(sizeof(lv), 4, "sizeof(STT1109)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1109)");
    check_field_offset(lv, fa, 0, "STT1109.fa");
  }
}
static Arrange_To_Call_Me vSTT1109(Test_STT1109, "STT1109", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1119  {
  short fa;
  __tsu64  :8;
};
//SIG(1 STT1119) C1{ Fs FL:8}



static void Test_STT1119()
{
  {
    init_simple_test("STT1119");
    static STT1119 lv;
    check2(sizeof(lv), ABISELECT(4,4), "sizeof(STT1119)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1119)");
    check_field_offset(lv, fa, 0, "STT1119.fa");
  }
}
static Arrange_To_Call_Me vSTT1119(Test_STT1119, "STT1119", ABISELECT(4,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1129  {
  short fa;
  unsigned int  :18;
};
//SIG(1 STT1129) C1{ Fs Fi:18}



static void Test_STT1129()
{
  {
    init_simple_test("STT1129");
    static STT1129 lv;
    check2(sizeof(lv), 8, "sizeof(STT1129)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1129)");
    check_field_offset(lv, fa, 0, "STT1129.fa");
  }
}
static Arrange_To_Call_Me vSTT1129(Test_STT1129, "STT1129", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1139  {
  short fa;
  __tsu64  :18;
};
//SIG(1 STT1139) C1{ Fs FL:18}



static void Test_STT1139()
{
  {
    init_simple_test("STT1139");
    static STT1139 lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(STT1139)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1139)");
    check_field_offset(lv, fa, 0, "STT1139.fa");
  }
}
static Arrange_To_Call_Me vSTT1139(Test_STT1139, "STT1139", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1149  {
  short fa;
  __tsu64  :48;
};
//SIG(1 STT1149) C1{ Fs FL:48}



static void Test_STT1149()
{
  {
    init_simple_test("STT1149");
    static STT1149 lv;
    check2(sizeof(lv), 8, "sizeof(STT1149)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(STT1149)");
    check_field_offset(lv, fa, 0, "STT1149.fa");
  }
}
static Arrange_To_Call_Me vSTT1149(Test_STT1149, "STT1149", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1159  {
  short fa;
  unsigned char bf:3;
};
//SIG(1 STT1159) C1{ Fs Fc:3}



static void Test_STT1159()
{
  {
    init_simple_test("STT1159");
    static STT1159 lv;
    check2(sizeof(lv), 4, "sizeof(STT1159)");
    check2(__alignof__(lv), 2, "__alignof__(STT1159)");
    check_field_offset(lv, fa, 0, "STT1159.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1159");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1159");
  }
}
static Arrange_To_Call_Me vSTT1159(Test_STT1159, "STT1159", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1169  {
  short fa;
  unsigned short bf:3;
};
//SIG(1 STT1169) C1{ Fs Fs:3}



static void Test_STT1169()
{
  {
    init_simple_test("STT1169");
    static STT1169 lv;
    check2(sizeof(lv), 4, "sizeof(STT1169)");
    check2(__alignof__(lv), 2, "__alignof__(STT1169)");
    check_field_offset(lv, fa, 0, "STT1169.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1169");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1169");
  }
}
static Arrange_To_Call_Me vSTT1169(Test_STT1169, "STT1169", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1179  {
  short fa;
  unsigned int bf:3;
};
//SIG(1 STT1179) C1{ Fs Fi:3}



static void Test_STT1179()
{
  {
    init_simple_test("STT1179");
    static STT1179 lv;
    check2(sizeof(lv), 4, "sizeof(STT1179)");
    check2(__alignof__(lv), 4, "__alignof__(STT1179)");
    check_field_offset(lv, fa, 0, "STT1179.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1179");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1179");
  }
}
static Arrange_To_Call_Me vSTT1179(Test_STT1179, "STT1179", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1189  {
  short fa;
  __tsu64 bf:3;
};
//SIG(1 STT1189) C1{ Fs FL:3}



static void Test_STT1189()
{
  {
    init_simple_test("STT1189");
    static STT1189 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT1189)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1189)");
    check_field_offset(lv, fa, 0, "STT1189.fa");
    set_bf_and_test(lv, bf, 2, 0, 3, 1, "STT1189");
    set_bf_and_test(lv, bf, 2, 0, 3, hide_ull(1LL<<2), "STT1189");
  }
}
static Arrange_To_Call_Me vSTT1189(Test_STT1189, "STT1189", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1199  {
  short fa;
  unsigned short bf:8;
};
//SIG(1 STT1199) C1{ Fs Fs:8}



static void Test_STT1199()
{
  {
    init_simple_test("STT1199");
    static STT1199 lv;
    check2(sizeof(lv), 4, "sizeof(STT1199)");
    check2(__alignof__(lv), 2, "__alignof__(STT1199)");
    check_field_offset(lv, fa, 0, "STT1199.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1199");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1199");
  }
}
static Arrange_To_Call_Me vSTT1199(Test_STT1199, "STT1199", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1209  {
  short fa;
  unsigned int bf:8;
};
//SIG(1 STT1209) C1{ Fs Fi:8}



static void Test_STT1209()
{
  {
    init_simple_test("STT1209");
    static STT1209 lv;
    check2(sizeof(lv), 4, "sizeof(STT1209)");
    check2(__alignof__(lv), 4, "__alignof__(STT1209)");
    check_field_offset(lv, fa, 0, "STT1209.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1209");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1209");
  }
}
static Arrange_To_Call_Me vSTT1209(Test_STT1209, "STT1209", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1219  {
  short fa;
  __tsu64 bf:8;
};
//SIG(1 STT1219) C1{ Fs FL:8}



static void Test_STT1219()
{
  {
    init_simple_test("STT1219");
    static STT1219 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT1219)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1219)");
    check_field_offset(lv, fa, 0, "STT1219.fa");
    set_bf_and_test(lv, bf, 2, 0, 8, 1, "STT1219");
    set_bf_and_test(lv, bf, 2, 0, 8, hide_ull(1LL<<7), "STT1219");
  }
}
static Arrange_To_Call_Me vSTT1219(Test_STT1219, "STT1219", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1229  {
  short fa;
  unsigned int bf:18;
};
//SIG(1 STT1229) C1{ Fs Fi:18}



static void Test_STT1229()
{
  {
    init_simple_test("STT1229");
    static STT1229 lv;
    check2(sizeof(lv), 8, "sizeof(STT1229)");
    check2(__alignof__(lv), 4, "__alignof__(STT1229)");
    check_field_offset(lv, fa, 0, "STT1229.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT1229");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT1229");
  }
}
static Arrange_To_Call_Me vSTT1229(Test_STT1229, "STT1229", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1239  {
  short fa;
  __tsu64 bf:18;
};
//SIG(1 STT1239) C1{ Fs FL:18}



static void Test_STT1239()
{
  {
    init_simple_test("STT1239");
    static STT1239 lv;
    check2(sizeof(lv), 8, "sizeof(STT1239)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1239)");
    check_field_offset(lv, fa, 0, "STT1239.fa");
    set_bf_and_test(lv, bf, 2, 0, 18, 1, "STT1239");
    set_bf_and_test(lv, bf, 2, 0, 18, hide_ull(1LL<<17), "STT1239");
  }
}
static Arrange_To_Call_Me vSTT1239(Test_STT1239, "STT1239", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT1249  {
  short fa;
  __tsu64 bf:48;
};
//SIG(1 STT1249) C1{ Fs FL:48}



static void Test_STT1249()
{
  {
    init_simple_test("STT1249");
    static STT1249 lv;
    check2(sizeof(lv), 8, "sizeof(STT1249)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT1249)");
    check_field_offset(lv, fa, 0, "STT1249.fa");
    set_bf_and_test(lv, bf, 2, 0, 48, 1, "STT1249");
    set_bf_and_test(lv, bf, 2, 0, 48, hide_ull(1LL<<47), "STT1249");
  }
}
static Arrange_To_Call_Me vSTT1249(Test_STT1249, "STT1249", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT210  {
  int fa;
  unsigned char  :0;
  char fb;
};
//SIG(1 STT210) C1{ Fi Fc:0 Fc}



static void Test_STT210()
{
  {
    init_simple_test("STT210");
    static STT210 lv;
    check2(sizeof(lv), 8, "sizeof(STT210)");
    check2(__alignof__(lv), 4, "__alignof__(STT210)");
    check_field_offset(lv, fa, 0, "STT210.fa");
    check_field_offset(lv, fb, 4, "STT210.fb");
  }
}
static Arrange_To_Call_Me vSTT210(Test_STT210, "STT210", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT220  {
  int fa;
  unsigned short  :0;
  char fb;
};
//SIG(1 STT220) C1{ Fi Fs:0 Fc}



static void Test_STT220()
{
  {
    init_simple_test("STT220");
    static STT220 lv;
    check2(sizeof(lv), 8, "sizeof(STT220)");
    check2(__alignof__(lv), 4, "__alignof__(STT220)");
    check_field_offset(lv, fa, 0, "STT220.fa");
    check_field_offset(lv, fb, 4, "STT220.fb");
  }
}
static Arrange_To_Call_Me vSTT220(Test_STT220, "STT220", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT230  {
  int fa;
  unsigned int  :0;
  char fb;
};
//SIG(1 STT230) C1{ Fi Fi:0 Fc}



static void Test_STT230()
{
  {
    init_simple_test("STT230");
    static STT230 lv;
    check2(sizeof(lv), 8, "sizeof(STT230)");
    check2(__alignof__(lv), 4, "__alignof__(STT230)");
    check_field_offset(lv, fa, 0, "STT230.fa");
    check_field_offset(lv, fb, 4, "STT230.fb");
  }
}
static Arrange_To_Call_Me vSTT230(Test_STT230, "STT230", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT240  {
  int fa;
  __tsu64  :0;
  char fb;
};
//SIG(1 STT240) C1{ Fi FL:0 Fc}



static void Test_STT240()
{
  {
    init_simple_test("STT240");
    static STT240 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT240)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT240)");
    check_field_offset(lv, fa, 0, "STT240.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT240.fb");
  }
}
static Arrange_To_Call_Me vSTT240(Test_STT240, "STT240", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT250  {
  int fa;
  unsigned char  :3;
  char fb;
};
//SIG(1 STT250) C1{ Fi Fc:3 Fc}



static void Test_STT250()
{
  {
    init_simple_test("STT250");
    static STT250 lv;
    check2(sizeof(lv), 8, "sizeof(STT250)");
    check2(__alignof__(lv), 4, "__alignof__(STT250)");
    check_field_offset(lv, fa, 0, "STT250.fa");
    check_field_offset(lv, fb, 5, "STT250.fb");
  }
}
static Arrange_To_Call_Me vSTT250(Test_STT250, "STT250", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT260  {
  int fa;
  unsigned short  :3;
  char fb;
};
//SIG(1 STT260) C1{ Fi Fs:3 Fc}



static void Test_STT260()
{
  {
    init_simple_test("STT260");
    static STT260 lv;
    check2(sizeof(lv), 8, "sizeof(STT260)");
    check2(__alignof__(lv), 4, "__alignof__(STT260)");
    check_field_offset(lv, fa, 0, "STT260.fa");
    check_field_offset(lv, fb, 5, "STT260.fb");
  }
}
static Arrange_To_Call_Me vSTT260(Test_STT260, "STT260", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT270  {
  int fa;
  unsigned int  :3;
  char fb;
};
//SIG(1 STT270) C1{ Fi Fi:3 Fc}



static void Test_STT270()
{
  {
    init_simple_test("STT270");
    static STT270 lv;
    check2(sizeof(lv), 8, "sizeof(STT270)");
    check2(__alignof__(lv), 4, "__alignof__(STT270)");
    check_field_offset(lv, fa, 0, "STT270.fa");
    check_field_offset(lv, fb, 5, "STT270.fb");
  }
}
static Arrange_To_Call_Me vSTT270(Test_STT270, "STT270", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT280  {
  int fa;
  __tsu64  :3;
  char fb;
};
//SIG(1 STT280) C1{ Fi FL:3 Fc}



static void Test_STT280()
{
  {
    init_simple_test("STT280");
    static STT280 lv;
    check2(sizeof(lv), 8, "sizeof(STT280)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT280)");
    check_field_offset(lv, fa, 0, "STT280.fa");
    check_field_offset(lv, fb, 5, "STT280.fb");
  }
}
static Arrange_To_Call_Me vSTT280(Test_STT280, "STT280", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT290  {
  int fa;
  unsigned short  :8;
  char fb;
};
//SIG(1 STT290) C1{ Fi Fs:8 Fc}



static void Test_STT290()
{
  {
    init_simple_test("STT290");
    static STT290 lv;
    check2(sizeof(lv), 8, "sizeof(STT290)");
    check2(__alignof__(lv), 4, "__alignof__(STT290)");
    check_field_offset(lv, fa, 0, "STT290.fa");
    check_field_offset(lv, fb, 5, "STT290.fb");
  }
}
static Arrange_To_Call_Me vSTT290(Test_STT290, "STT290", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2100  {
  int fa;
  unsigned int  :8;
  char fb;
};
//SIG(1 STT2100) C1{ Fi Fi:8 Fc}



static void Test_STT2100()
{
  {
    init_simple_test("STT2100");
    static STT2100 lv;
    check2(sizeof(lv), 8, "sizeof(STT2100)");
    check2(__alignof__(lv), 4, "__alignof__(STT2100)");
    check_field_offset(lv, fa, 0, "STT2100.fa");
    check_field_offset(lv, fb, 5, "STT2100.fb");
  }
}
static Arrange_To_Call_Me vSTT2100(Test_STT2100, "STT2100", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2110  {
  int fa;
  __tsu64  :8;
  char fb;
};
//SIG(1 STT2110) C1{ Fi FL:8 Fc}



static void Test_STT2110()
{
  {
    init_simple_test("STT2110");
    static STT2110 lv;
    check2(sizeof(lv), 8, "sizeof(STT2110)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2110)");
    check_field_offset(lv, fa, 0, "STT2110.fa");
    check_field_offset(lv, fb, 5, "STT2110.fb");
  }
}
static Arrange_To_Call_Me vSTT2110(Test_STT2110, "STT2110", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2120  {
  int fa;
  unsigned int  :18;
  char fb;
};
//SIG(1 STT2120) C1{ Fi Fi:18 Fc}



static void Test_STT2120()
{
  {
    init_simple_test("STT2120");
    static STT2120 lv;
    check2(sizeof(lv), 8, "sizeof(STT2120)");
    check2(__alignof__(lv), 4, "__alignof__(STT2120)");
    check_field_offset(lv, fa, 0, "STT2120.fa");
    check_field_offset(lv, fb, 7, "STT2120.fb");
  }
}
static Arrange_To_Call_Me vSTT2120(Test_STT2120, "STT2120", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2130  {
  int fa;
  __tsu64  :18;
  char fb;
};
//SIG(1 STT2130) C1{ Fi FL:18 Fc}



static void Test_STT2130()
{
  {
    init_simple_test("STT2130");
    static STT2130 lv;
    check2(sizeof(lv), 8, "sizeof(STT2130)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2130)");
    check_field_offset(lv, fa, 0, "STT2130.fa");
    check_field_offset(lv, fb, 7, "STT2130.fb");
  }
}
static Arrange_To_Call_Me vSTT2130(Test_STT2130, "STT2130", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2140  {
  int fa;
  __tsu64  :48;
  char fb;
};
//SIG(1 STT2140) C1{ Fi FL:48 Fc}



static void Test_STT2140()
{
  {
    init_simple_test("STT2140");
    static STT2140 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2140)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2140)");
    check_field_offset(lv, fa, 0, "STT2140.fa");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT2140.fb");
  }
}
static Arrange_To_Call_Me vSTT2140(Test_STT2140, "STT2140", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2150  {
  int fa;
  unsigned char bf:3;
  char fb;
};
//SIG(1 STT2150) C1{ Fi Fc:3 Fc}



static void Test_STT2150()
{
  {
    init_simple_test("STT2150");
    static STT2150 lv;
    check2(sizeof(lv), 8, "sizeof(STT2150)");
    check2(__alignof__(lv), 4, "__alignof__(STT2150)");
    check_field_offset(lv, fa, 0, "STT2150.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2150");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2150");
    check_field_offset(lv, fb, 5, "STT2150.fb");
  }
}
static Arrange_To_Call_Me vSTT2150(Test_STT2150, "STT2150", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2160  {
  int fa;
  unsigned short bf:3;
  char fb;
};
//SIG(1 STT2160) C1{ Fi Fs:3 Fc}



static void Test_STT2160()
{
  {
    init_simple_test("STT2160");
    static STT2160 lv;
    check2(sizeof(lv), 8, "sizeof(STT2160)");
    check2(__alignof__(lv), 4, "__alignof__(STT2160)");
    check_field_offset(lv, fa, 0, "STT2160.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2160");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2160");
    check_field_offset(lv, fb, 5, "STT2160.fb");
  }
}
static Arrange_To_Call_Me vSTT2160(Test_STT2160, "STT2160", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2170  {
  int fa;
  unsigned int bf:3;
  char fb;
};
//SIG(1 STT2170) C1{ Fi Fi:3 Fc}



static void Test_STT2170()
{
  {
    init_simple_test("STT2170");
    static STT2170 lv;
    check2(sizeof(lv), 8, "sizeof(STT2170)");
    check2(__alignof__(lv), 4, "__alignof__(STT2170)");
    check_field_offset(lv, fa, 0, "STT2170.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2170");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2170");
    check_field_offset(lv, fb, 5, "STT2170.fb");
  }
}
static Arrange_To_Call_Me vSTT2170(Test_STT2170, "STT2170", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2180  {
  int fa;
  __tsu64 bf:3;
  char fb;
};
//SIG(1 STT2180) C1{ Fi FL:3 Fc}



static void Test_STT2180()
{
  {
    init_simple_test("STT2180");
    static STT2180 lv;
    check2(sizeof(lv), 8, "sizeof(STT2180)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2180)");
    check_field_offset(lv, fa, 0, "STT2180.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2180");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2180");
    check_field_offset(lv, fb, 5, "STT2180.fb");
  }
}
static Arrange_To_Call_Me vSTT2180(Test_STT2180, "STT2180", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2190  {
  int fa;
  unsigned short bf:8;
  char fb;
};
//SIG(1 STT2190) C1{ Fi Fs:8 Fc}



static void Test_STT2190()
{
  {
    init_simple_test("STT2190");
    static STT2190 lv;
    check2(sizeof(lv), 8, "sizeof(STT2190)");
    check2(__alignof__(lv), 4, "__alignof__(STT2190)");
    check_field_offset(lv, fa, 0, "STT2190.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2190");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2190");
    check_field_offset(lv, fb, 5, "STT2190.fb");
  }
}
static Arrange_To_Call_Me vSTT2190(Test_STT2190, "STT2190", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2200  {
  int fa;
  unsigned int bf:8;
  char fb;
};
//SIG(1 STT2200) C1{ Fi Fi:8 Fc}



static void Test_STT2200()
{
  {
    init_simple_test("STT2200");
    static STT2200 lv;
    check2(sizeof(lv), 8, "sizeof(STT2200)");
    check2(__alignof__(lv), 4, "__alignof__(STT2200)");
    check_field_offset(lv, fa, 0, "STT2200.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2200");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2200");
    check_field_offset(lv, fb, 5, "STT2200.fb");
  }
}
static Arrange_To_Call_Me vSTT2200(Test_STT2200, "STT2200", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2210  {
  int fa;
  __tsu64 bf:8;
  char fb;
};
//SIG(1 STT2210) C1{ Fi FL:8 Fc}



static void Test_STT2210()
{
  {
    init_simple_test("STT2210");
    static STT2210 lv;
    check2(sizeof(lv), 8, "sizeof(STT2210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2210)");
    check_field_offset(lv, fa, 0, "STT2210.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2210");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2210");
    check_field_offset(lv, fb, 5, "STT2210.fb");
  }
}
static Arrange_To_Call_Me vSTT2210(Test_STT2210, "STT2210", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2220  {
  int fa;
  unsigned int bf:18;
  char fb;
};
//SIG(1 STT2220) C1{ Fi Fi:18 Fc}



static void Test_STT2220()
{
  {
    init_simple_test("STT2220");
    static STT2220 lv;
    check2(sizeof(lv), 8, "sizeof(STT2220)");
    check2(__alignof__(lv), 4, "__alignof__(STT2220)");
    check_field_offset(lv, fa, 0, "STT2220.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2220");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2220");
    check_field_offset(lv, fb, 7, "STT2220.fb");
  }
}
static Arrange_To_Call_Me vSTT2220(Test_STT2220, "STT2220", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2230  {
  int fa;
  __tsu64 bf:18;
  char fb;
};
//SIG(1 STT2230) C1{ Fi FL:18 Fc}



static void Test_STT2230()
{
  {
    init_simple_test("STT2230");
    static STT2230 lv;
    check2(sizeof(lv), 8, "sizeof(STT2230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2230)");
    check_field_offset(lv, fa, 0, "STT2230.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2230");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2230");
    check_field_offset(lv, fb, 7, "STT2230.fb");
  }
}
static Arrange_To_Call_Me vSTT2230(Test_STT2230, "STT2230", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2240  {
  int fa;
  __tsu64 bf:48;
  char fb;
};
//SIG(1 STT2240) C1{ Fi FL:48 Fc}



static void Test_STT2240()
{
  {
    init_simple_test("STT2240");
    static STT2240 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2240)");
    check_field_offset(lv, fa, 0, "STT2240.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2240");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2240");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT2240.fb");
  }
}
static Arrange_To_Call_Me vSTT2240(Test_STT2240, "STT2240", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT211  {
  int fa;
  unsigned char  :0;
  short fb;
};
//SIG(1 STT211) C1{ Fi Fc:0 Fs}



static void Test_STT211()
{
  {
    init_simple_test("STT211");
    static STT211 lv;
    check2(sizeof(lv), 8, "sizeof(STT211)");
    check2(__alignof__(lv), 4, "__alignof__(STT211)");
    check_field_offset(lv, fa, 0, "STT211.fa");
    check_field_offset(lv, fb, 4, "STT211.fb");
  }
}
static Arrange_To_Call_Me vSTT211(Test_STT211, "STT211", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT221  {
  int fa;
  unsigned short  :0;
  short fb;
};
//SIG(1 STT221) C1{ Fi Fs:0 Fs}



static void Test_STT221()
{
  {
    init_simple_test("STT221");
    static STT221 lv;
    check2(sizeof(lv), 8, "sizeof(STT221)");
    check2(__alignof__(lv), 4, "__alignof__(STT221)");
    check_field_offset(lv, fa, 0, "STT221.fa");
    check_field_offset(lv, fb, 4, "STT221.fb");
  }
}
static Arrange_To_Call_Me vSTT221(Test_STT221, "STT221", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT231  {
  int fa;
  unsigned int  :0;
  short fb;
};
//SIG(1 STT231) C1{ Fi Fi:0 Fs}



static void Test_STT231()
{
  {
    init_simple_test("STT231");
    static STT231 lv;
    check2(sizeof(lv), 8, "sizeof(STT231)");
    check2(__alignof__(lv), 4, "__alignof__(STT231)");
    check_field_offset(lv, fa, 0, "STT231.fa");
    check_field_offset(lv, fb, 4, "STT231.fb");
  }
}
static Arrange_To_Call_Me vSTT231(Test_STT231, "STT231", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT241  {
  int fa;
  __tsu64  :0;
  short fb;
};
//SIG(1 STT241) C1{ Fi FL:0 Fs}



static void Test_STT241()
{
  {
    init_simple_test("STT241");
    static STT241 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT241)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT241)");
    check_field_offset(lv, fa, 0, "STT241.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT241.fb");
  }
}
static Arrange_To_Call_Me vSTT241(Test_STT241, "STT241", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT251  {
  int fa;
  unsigned char  :3;
  short fb;
};
//SIG(1 STT251) C1{ Fi Fc:3 Fs}



static void Test_STT251()
{
  {
    init_simple_test("STT251");
    static STT251 lv;
    check2(sizeof(lv), 8, "sizeof(STT251)");
    check2(__alignof__(lv), 4, "__alignof__(STT251)");
    check_field_offset(lv, fa, 0, "STT251.fa");
    check_field_offset(lv, fb, 6, "STT251.fb");
  }
}
static Arrange_To_Call_Me vSTT251(Test_STT251, "STT251", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT261  {
  int fa;
  unsigned short  :3;
  short fb;
};
//SIG(1 STT261) C1{ Fi Fs:3 Fs}



static void Test_STT261()
{
  {
    init_simple_test("STT261");
    static STT261 lv;
    check2(sizeof(lv), 8, "sizeof(STT261)");
    check2(__alignof__(lv), 4, "__alignof__(STT261)");
    check_field_offset(lv, fa, 0, "STT261.fa");
    check_field_offset(lv, fb, 6, "STT261.fb");
  }
}
static Arrange_To_Call_Me vSTT261(Test_STT261, "STT261", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT271  {
  int fa;
  unsigned int  :3;
  short fb;
};
//SIG(1 STT271) C1{ Fi Fi:3 Fs}



static void Test_STT271()
{
  {
    init_simple_test("STT271");
    static STT271 lv;
    check2(sizeof(lv), 8, "sizeof(STT271)");
    check2(__alignof__(lv), 4, "__alignof__(STT271)");
    check_field_offset(lv, fa, 0, "STT271.fa");
    check_field_offset(lv, fb, 6, "STT271.fb");
  }
}
static Arrange_To_Call_Me vSTT271(Test_STT271, "STT271", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT281  {
  int fa;
  __tsu64  :3;
  short fb;
};
//SIG(1 STT281) C1{ Fi FL:3 Fs}



static void Test_STT281()
{
  {
    init_simple_test("STT281");
    static STT281 lv;
    check2(sizeof(lv), 8, "sizeof(STT281)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT281)");
    check_field_offset(lv, fa, 0, "STT281.fa");
    check_field_offset(lv, fb, 6, "STT281.fb");
  }
}
static Arrange_To_Call_Me vSTT281(Test_STT281, "STT281", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT291  {
  int fa;
  unsigned short  :8;
  short fb;
};
//SIG(1 STT291) C1{ Fi Fs:8 Fs}



static void Test_STT291()
{
  {
    init_simple_test("STT291");
    static STT291 lv;
    check2(sizeof(lv), 8, "sizeof(STT291)");
    check2(__alignof__(lv), 4, "__alignof__(STT291)");
    check_field_offset(lv, fa, 0, "STT291.fa");
    check_field_offset(lv, fb, 6, "STT291.fb");
  }
}
static Arrange_To_Call_Me vSTT291(Test_STT291, "STT291", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2101  {
  int fa;
  unsigned int  :8;
  short fb;
};
//SIG(1 STT2101) C1{ Fi Fi:8 Fs}



static void Test_STT2101()
{
  {
    init_simple_test("STT2101");
    static STT2101 lv;
    check2(sizeof(lv), 8, "sizeof(STT2101)");
    check2(__alignof__(lv), 4, "__alignof__(STT2101)");
    check_field_offset(lv, fa, 0, "STT2101.fa");
    check_field_offset(lv, fb, 6, "STT2101.fb");
  }
}
static Arrange_To_Call_Me vSTT2101(Test_STT2101, "STT2101", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2111  {
  int fa;
  __tsu64  :8;
  short fb;
};
//SIG(1 STT2111) C1{ Fi FL:8 Fs}



static void Test_STT2111()
{
  {
    init_simple_test("STT2111");
    static STT2111 lv;
    check2(sizeof(lv), 8, "sizeof(STT2111)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2111)");
    check_field_offset(lv, fa, 0, "STT2111.fa");
    check_field_offset(lv, fb, 6, "STT2111.fb");
  }
}
static Arrange_To_Call_Me vSTT2111(Test_STT2111, "STT2111", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2121  {
  int fa;
  unsigned int  :18;
  short fb;
};
//SIG(1 STT2121) C1{ Fi Fi:18 Fs}



static void Test_STT2121()
{
  {
    init_simple_test("STT2121");
    static STT2121 lv;
    check2(sizeof(lv), 12, "sizeof(STT2121)");
    check2(__alignof__(lv), 4, "__alignof__(STT2121)");
    check_field_offset(lv, fa, 0, "STT2121.fa");
    check_field_offset(lv, fb, 8, "STT2121.fb");
  }
}
static Arrange_To_Call_Me vSTT2121(Test_STT2121, "STT2121", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2131  {
  int fa;
  __tsu64  :18;
  short fb;
};
//SIG(1 STT2131) C1{ Fi FL:18 Fs}



static void Test_STT2131()
{
  {
    init_simple_test("STT2131");
    static STT2131 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT2131)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2131)");
    check_field_offset(lv, fa, 0, "STT2131.fa");
    check_field_offset(lv, fb, 8, "STT2131.fb");
  }
}
static Arrange_To_Call_Me vSTT2131(Test_STT2131, "STT2131", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2141  {
  int fa;
  __tsu64  :48;
  short fb;
};
//SIG(1 STT2141) C1{ Fi FL:48 Fs}



static void Test_STT2141()
{
  {
    init_simple_test("STT2141");
    static STT2141 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2141)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2141)");
    check_field_offset(lv, fa, 0, "STT2141.fa");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT2141.fb");
  }
}
static Arrange_To_Call_Me vSTT2141(Test_STT2141, "STT2141", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2151  {
  int fa;
  unsigned char bf:3;
  short fb;
};
//SIG(1 STT2151) C1{ Fi Fc:3 Fs}



static void Test_STT2151()
{
  {
    init_simple_test("STT2151");
    static STT2151 lv;
    check2(sizeof(lv), 8, "sizeof(STT2151)");
    check2(__alignof__(lv), 4, "__alignof__(STT2151)");
    check_field_offset(lv, fa, 0, "STT2151.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2151");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2151");
    check_field_offset(lv, fb, 6, "STT2151.fb");
  }
}
static Arrange_To_Call_Me vSTT2151(Test_STT2151, "STT2151", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2161  {
  int fa;
  unsigned short bf:3;
  short fb;
};
//SIG(1 STT2161) C1{ Fi Fs:3 Fs}



static void Test_STT2161()
{
  {
    init_simple_test("STT2161");
    static STT2161 lv;
    check2(sizeof(lv), 8, "sizeof(STT2161)");
    check2(__alignof__(lv), 4, "__alignof__(STT2161)");
    check_field_offset(lv, fa, 0, "STT2161.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2161");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2161");
    check_field_offset(lv, fb, 6, "STT2161.fb");
  }
}
static Arrange_To_Call_Me vSTT2161(Test_STT2161, "STT2161", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2171  {
  int fa;
  unsigned int bf:3;
  short fb;
};
//SIG(1 STT2171) C1{ Fi Fi:3 Fs}



static void Test_STT2171()
{
  {
    init_simple_test("STT2171");
    static STT2171 lv;
    check2(sizeof(lv), 8, "sizeof(STT2171)");
    check2(__alignof__(lv), 4, "__alignof__(STT2171)");
    check_field_offset(lv, fa, 0, "STT2171.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2171");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2171");
    check_field_offset(lv, fb, 6, "STT2171.fb");
  }
}
static Arrange_To_Call_Me vSTT2171(Test_STT2171, "STT2171", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2181  {
  int fa;
  __tsu64 bf:3;
  short fb;
};
//SIG(1 STT2181) C1{ Fi FL:3 Fs}



static void Test_STT2181()
{
  {
    init_simple_test("STT2181");
    static STT2181 lv;
    check2(sizeof(lv), 8, "sizeof(STT2181)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2181)");
    check_field_offset(lv, fa, 0, "STT2181.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2181");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2181");
    check_field_offset(lv, fb, 6, "STT2181.fb");
  }
}
static Arrange_To_Call_Me vSTT2181(Test_STT2181, "STT2181", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2191  {
  int fa;
  unsigned short bf:8;
  short fb;
};
//SIG(1 STT2191) C1{ Fi Fs:8 Fs}



static void Test_STT2191()
{
  {
    init_simple_test("STT2191");
    static STT2191 lv;
    check2(sizeof(lv), 8, "sizeof(STT2191)");
    check2(__alignof__(lv), 4, "__alignof__(STT2191)");
    check_field_offset(lv, fa, 0, "STT2191.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2191");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2191");
    check_field_offset(lv, fb, 6, "STT2191.fb");
  }
}
static Arrange_To_Call_Me vSTT2191(Test_STT2191, "STT2191", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2201  {
  int fa;
  unsigned int bf:8;
  short fb;
};
//SIG(1 STT2201) C1{ Fi Fi:8 Fs}



static void Test_STT2201()
{
  {
    init_simple_test("STT2201");
    static STT2201 lv;
    check2(sizeof(lv), 8, "sizeof(STT2201)");
    check2(__alignof__(lv), 4, "__alignof__(STT2201)");
    check_field_offset(lv, fa, 0, "STT2201.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2201");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2201");
    check_field_offset(lv, fb, 6, "STT2201.fb");
  }
}
static Arrange_To_Call_Me vSTT2201(Test_STT2201, "STT2201", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2211  {
  int fa;
  __tsu64 bf:8;
  short fb;
};
//SIG(1 STT2211) C1{ Fi FL:8 Fs}



static void Test_STT2211()
{
  {
    init_simple_test("STT2211");
    static STT2211 lv;
    check2(sizeof(lv), 8, "sizeof(STT2211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2211)");
    check_field_offset(lv, fa, 0, "STT2211.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2211");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2211");
    check_field_offset(lv, fb, 6, "STT2211.fb");
  }
}
static Arrange_To_Call_Me vSTT2211(Test_STT2211, "STT2211", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2221  {
  int fa;
  unsigned int bf:18;
  short fb;
};
//SIG(1 STT2221) C1{ Fi Fi:18 Fs}



static void Test_STT2221()
{
  {
    init_simple_test("STT2221");
    static STT2221 lv;
    check2(sizeof(lv), 12, "sizeof(STT2221)");
    check2(__alignof__(lv), 4, "__alignof__(STT2221)");
    check_field_offset(lv, fa, 0, "STT2221.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2221");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2221");
    check_field_offset(lv, fb, 8, "STT2221.fb");
  }
}
static Arrange_To_Call_Me vSTT2221(Test_STT2221, "STT2221", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2231  {
  int fa;
  __tsu64 bf:18;
  short fb;
};
//SIG(1 STT2231) C1{ Fi FL:18 Fs}



static void Test_STT2231()
{
  {
    init_simple_test("STT2231");
    static STT2231 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2231)");
    check_field_offset(lv, fa, 0, "STT2231.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2231");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2231");
    check_field_offset(lv, fb, 8, "STT2231.fb");
  }
}
static Arrange_To_Call_Me vSTT2231(Test_STT2231, "STT2231", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2241  {
  int fa;
  __tsu64 bf:48;
  short fb;
};
//SIG(1 STT2241) C1{ Fi FL:48 Fs}



static void Test_STT2241()
{
  {
    init_simple_test("STT2241");
    static STT2241 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2241)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2241)");
    check_field_offset(lv, fa, 0, "STT2241.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2241");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2241");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT2241.fb");
  }
}
static Arrange_To_Call_Me vSTT2241(Test_STT2241, "STT2241", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT212  {
  int fa;
  unsigned char  :0;
  int fb;
};
//SIG(1 STT212) C1{ Fi Fc:0 Fi}



static void Test_STT212()
{
  {
    init_simple_test("STT212");
    static STT212 lv;
    check2(sizeof(lv), 8, "sizeof(STT212)");
    check2(__alignof__(lv), 4, "__alignof__(STT212)");
    check_field_offset(lv, fa, 0, "STT212.fa");
    check_field_offset(lv, fb, 4, "STT212.fb");
  }
}
static Arrange_To_Call_Me vSTT212(Test_STT212, "STT212", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT222  {
  int fa;
  unsigned short  :0;
  int fb;
};
//SIG(1 STT222) C1{ Fi Fs:0 Fi}



static void Test_STT222()
{
  {
    init_simple_test("STT222");
    static STT222 lv;
    check2(sizeof(lv), 8, "sizeof(STT222)");
    check2(__alignof__(lv), 4, "__alignof__(STT222)");
    check_field_offset(lv, fa, 0, "STT222.fa");
    check_field_offset(lv, fb, 4, "STT222.fb");
  }
}
static Arrange_To_Call_Me vSTT222(Test_STT222, "STT222", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT232  {
  int fa;
  unsigned int  :0;
  int fb;
};
//SIG(1 STT232) C1{ Fi Fi:0 Fi}



static void Test_STT232()
{
  {
    init_simple_test("STT232");
    static STT232 lv;
    check2(sizeof(lv), 8, "sizeof(STT232)");
    check2(__alignof__(lv), 4, "__alignof__(STT232)");
    check_field_offset(lv, fa, 0, "STT232.fa");
    check_field_offset(lv, fb, 4, "STT232.fb");
  }
}
static Arrange_To_Call_Me vSTT232(Test_STT232, "STT232", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT242  {
  int fa;
  __tsu64  :0;
  int fb;
};
//SIG(1 STT242) C1{ Fi FL:0 Fi}



static void Test_STT242()
{
  {
    init_simple_test("STT242");
    static STT242 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT242)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT242)");
    check_field_offset(lv, fa, 0, "STT242.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT242.fb");
  }
}
static Arrange_To_Call_Me vSTT242(Test_STT242, "STT242", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT252  {
  int fa;
  unsigned char  :3;
  int fb;
};
//SIG(1 STT252) C1{ Fi Fc:3 Fi}



static void Test_STT252()
{
  {
    init_simple_test("STT252");
    static STT252 lv;
    check2(sizeof(lv), 12, "sizeof(STT252)");
    check2(__alignof__(lv), 4, "__alignof__(STT252)");
    check_field_offset(lv, fa, 0, "STT252.fa");
    check_field_offset(lv, fb, 8, "STT252.fb");
  }
}
static Arrange_To_Call_Me vSTT252(Test_STT252, "STT252", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT262  {
  int fa;
  unsigned short  :3;
  int fb;
};
//SIG(1 STT262) C1{ Fi Fs:3 Fi}



static void Test_STT262()
{
  {
    init_simple_test("STT262");
    static STT262 lv;
    check2(sizeof(lv), 12, "sizeof(STT262)");
    check2(__alignof__(lv), 4, "__alignof__(STT262)");
    check_field_offset(lv, fa, 0, "STT262.fa");
    check_field_offset(lv, fb, 8, "STT262.fb");
  }
}
static Arrange_To_Call_Me vSTT262(Test_STT262, "STT262", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT272  {
  int fa;
  unsigned int  :3;
  int fb;
};
//SIG(1 STT272) C1{ Fi Fi:3 Fi}



static void Test_STT272()
{
  {
    init_simple_test("STT272");
    static STT272 lv;
    check2(sizeof(lv), 12, "sizeof(STT272)");
    check2(__alignof__(lv), 4, "__alignof__(STT272)");
    check_field_offset(lv, fa, 0, "STT272.fa");
    check_field_offset(lv, fb, 8, "STT272.fb");
  }
}
static Arrange_To_Call_Me vSTT272(Test_STT272, "STT272", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT282  {
  int fa;
  __tsu64  :3;
  int fb;
};
//SIG(1 STT282) C1{ Fi FL:3 Fi}



static void Test_STT282()
{
  {
    init_simple_test("STT282");
    static STT282 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT282)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT282)");
    check_field_offset(lv, fa, 0, "STT282.fa");
    check_field_offset(lv, fb, 8, "STT282.fb");
  }
}
static Arrange_To_Call_Me vSTT282(Test_STT282, "STT282", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT292  {
  int fa;
  unsigned short  :8;
  int fb;
};
//SIG(1 STT292) C1{ Fi Fs:8 Fi}



static void Test_STT292()
{
  {
    init_simple_test("STT292");
    static STT292 lv;
    check2(sizeof(lv), 12, "sizeof(STT292)");
    check2(__alignof__(lv), 4, "__alignof__(STT292)");
    check_field_offset(lv, fa, 0, "STT292.fa");
    check_field_offset(lv, fb, 8, "STT292.fb");
  }
}
static Arrange_To_Call_Me vSTT292(Test_STT292, "STT292", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2102  {
  int fa;
  unsigned int  :8;
  int fb;
};
//SIG(1 STT2102) C1{ Fi Fi:8 Fi}



static void Test_STT2102()
{
  {
    init_simple_test("STT2102");
    static STT2102 lv;
    check2(sizeof(lv), 12, "sizeof(STT2102)");
    check2(__alignof__(lv), 4, "__alignof__(STT2102)");
    check_field_offset(lv, fa, 0, "STT2102.fa");
    check_field_offset(lv, fb, 8, "STT2102.fb");
  }
}
static Arrange_To_Call_Me vSTT2102(Test_STT2102, "STT2102", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2112  {
  int fa;
  __tsu64  :8;
  int fb;
};
//SIG(1 STT2112) C1{ Fi FL:8 Fi}



static void Test_STT2112()
{
  {
    init_simple_test("STT2112");
    static STT2112 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT2112)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2112)");
    check_field_offset(lv, fa, 0, "STT2112.fa");
    check_field_offset(lv, fb, 8, "STT2112.fb");
  }
}
static Arrange_To_Call_Me vSTT2112(Test_STT2112, "STT2112", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2122  {
  int fa;
  unsigned int  :18;
  int fb;
};
//SIG(1 STT2122) C1{ Fi Fi:18 Fi}



static void Test_STT2122()
{
  {
    init_simple_test("STT2122");
    static STT2122 lv;
    check2(sizeof(lv), 12, "sizeof(STT2122)");
    check2(__alignof__(lv), 4, "__alignof__(STT2122)");
    check_field_offset(lv, fa, 0, "STT2122.fa");
    check_field_offset(lv, fb, 8, "STT2122.fb");
  }
}
static Arrange_To_Call_Me vSTT2122(Test_STT2122, "STT2122", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2132  {
  int fa;
  __tsu64  :18;
  int fb;
};
//SIG(1 STT2132) C1{ Fi FL:18 Fi}



static void Test_STT2132()
{
  {
    init_simple_test("STT2132");
    static STT2132 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT2132)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2132)");
    check_field_offset(lv, fa, 0, "STT2132.fa");
    check_field_offset(lv, fb, 8, "STT2132.fb");
  }
}
static Arrange_To_Call_Me vSTT2132(Test_STT2132, "STT2132", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2142  {
  int fa;
  __tsu64  :48;
  int fb;
};
//SIG(1 STT2142) C1{ Fi FL:48 Fi}



static void Test_STT2142()
{
  {
    init_simple_test("STT2142");
    static STT2142 lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(STT2142)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2142)");
    check_field_offset(lv, fa, 0, "STT2142.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2142.fb");
  }
}
static Arrange_To_Call_Me vSTT2142(Test_STT2142, "STT2142", ABISELECT(20,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2152  {
  int fa;
  unsigned char bf:3;
  int fb;
};
//SIG(1 STT2152) C1{ Fi Fc:3 Fi}



static void Test_STT2152()
{
  {
    init_simple_test("STT2152");
    static STT2152 lv;
    check2(sizeof(lv), 12, "sizeof(STT2152)");
    check2(__alignof__(lv), 4, "__alignof__(STT2152)");
    check_field_offset(lv, fa, 0, "STT2152.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2152");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2152");
    check_field_offset(lv, fb, 8, "STT2152.fb");
  }
}
static Arrange_To_Call_Me vSTT2152(Test_STT2152, "STT2152", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2162  {
  int fa;
  unsigned short bf:3;
  int fb;
};
//SIG(1 STT2162) C1{ Fi Fs:3 Fi}



static void Test_STT2162()
{
  {
    init_simple_test("STT2162");
    static STT2162 lv;
    check2(sizeof(lv), 12, "sizeof(STT2162)");
    check2(__alignof__(lv), 4, "__alignof__(STT2162)");
    check_field_offset(lv, fa, 0, "STT2162.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2162");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2162");
    check_field_offset(lv, fb, 8, "STT2162.fb");
  }
}
static Arrange_To_Call_Me vSTT2162(Test_STT2162, "STT2162", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2172  {
  int fa;
  unsigned int bf:3;
  int fb;
};
//SIG(1 STT2172) C1{ Fi Fi:3 Fi}



static void Test_STT2172()
{
  {
    init_simple_test("STT2172");
    static STT2172 lv;
    check2(sizeof(lv), 12, "sizeof(STT2172)");
    check2(__alignof__(lv), 4, "__alignof__(STT2172)");
    check_field_offset(lv, fa, 0, "STT2172.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2172");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2172");
    check_field_offset(lv, fb, 8, "STT2172.fb");
  }
}
static Arrange_To_Call_Me vSTT2172(Test_STT2172, "STT2172", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2182  {
  int fa;
  __tsu64 bf:3;
  int fb;
};
//SIG(1 STT2182) C1{ Fi FL:3 Fi}



static void Test_STT2182()
{
  {
    init_simple_test("STT2182");
    static STT2182 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2182)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2182)");
    check_field_offset(lv, fa, 0, "STT2182.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2182");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2182");
    check_field_offset(lv, fb, 8, "STT2182.fb");
  }
}
static Arrange_To_Call_Me vSTT2182(Test_STT2182, "STT2182", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2192  {
  int fa;
  unsigned short bf:8;
  int fb;
};
//SIG(1 STT2192) C1{ Fi Fs:8 Fi}



static void Test_STT2192()
{
  {
    init_simple_test("STT2192");
    static STT2192 lv;
    check2(sizeof(lv), 12, "sizeof(STT2192)");
    check2(__alignof__(lv), 4, "__alignof__(STT2192)");
    check_field_offset(lv, fa, 0, "STT2192.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2192");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2192");
    check_field_offset(lv, fb, 8, "STT2192.fb");
  }
}
static Arrange_To_Call_Me vSTT2192(Test_STT2192, "STT2192", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2202  {
  int fa;
  unsigned int bf:8;
  int fb;
};
//SIG(1 STT2202) C1{ Fi Fi:8 Fi}



static void Test_STT2202()
{
  {
    init_simple_test("STT2202");
    static STT2202 lv;
    check2(sizeof(lv), 12, "sizeof(STT2202)");
    check2(__alignof__(lv), 4, "__alignof__(STT2202)");
    check_field_offset(lv, fa, 0, "STT2202.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2202");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2202");
    check_field_offset(lv, fb, 8, "STT2202.fb");
  }
}
static Arrange_To_Call_Me vSTT2202(Test_STT2202, "STT2202", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2212  {
  int fa;
  __tsu64 bf:8;
  int fb;
};
//SIG(1 STT2212) C1{ Fi FL:8 Fi}



static void Test_STT2212()
{
  {
    init_simple_test("STT2212");
    static STT2212 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2212)");
    check_field_offset(lv, fa, 0, "STT2212.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2212");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2212");
    check_field_offset(lv, fb, 8, "STT2212.fb");
  }
}
static Arrange_To_Call_Me vSTT2212(Test_STT2212, "STT2212", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2222  {
  int fa;
  unsigned int bf:18;
  int fb;
};
//SIG(1 STT2222) C1{ Fi Fi:18 Fi}



static void Test_STT2222()
{
  {
    init_simple_test("STT2222");
    static STT2222 lv;
    check2(sizeof(lv), 12, "sizeof(STT2222)");
    check2(__alignof__(lv), 4, "__alignof__(STT2222)");
    check_field_offset(lv, fa, 0, "STT2222.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2222");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2222");
    check_field_offset(lv, fb, 8, "STT2222.fb");
  }
}
static Arrange_To_Call_Me vSTT2222(Test_STT2222, "STT2222", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2232  {
  int fa;
  __tsu64 bf:18;
  int fb;
};
//SIG(1 STT2232) C1{ Fi FL:18 Fi}



static void Test_STT2232()
{
  {
    init_simple_test("STT2232");
    static STT2232 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2232)");
    check_field_offset(lv, fa, 0, "STT2232.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2232");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2232");
    check_field_offset(lv, fb, 8, "STT2232.fb");
  }
}
static Arrange_To_Call_Me vSTT2232(Test_STT2232, "STT2232", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2242  {
  int fa;
  __tsu64 bf:48;
  int fb;
};
//SIG(1 STT2242) C1{ Fi FL:48 Fi}



static void Test_STT2242()
{
  {
    init_simple_test("STT2242");
    static STT2242 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT2242)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2242)");
    check_field_offset(lv, fa, 0, "STT2242.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2242");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2242");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2242.fb");
  }
}
static Arrange_To_Call_Me vSTT2242(Test_STT2242, "STT2242", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT213  {
  int fa;
  unsigned char  :0;
  long fb;
};
//SIG(1 STT213) C1{ Fi Fc:0 Fl}



static void Test_STT213()
{
  {
    init_simple_test("STT213");
    static STT213 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT213)");
    check_field_offset(lv, fa, 0, "STT213.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT213.fb");
  }
}
static Arrange_To_Call_Me vSTT213(Test_STT213, "STT213", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT223  {
  int fa;
  unsigned short  :0;
  long fb;
};
//SIG(1 STT223) C1{ Fi Fs:0 Fl}



static void Test_STT223()
{
  {
    init_simple_test("STT223");
    static STT223 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT223)");
    check_field_offset(lv, fa, 0, "STT223.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT223.fb");
  }
}
static Arrange_To_Call_Me vSTT223(Test_STT223, "STT223", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT233  {
  int fa;
  unsigned int  :0;
  long fb;
};
//SIG(1 STT233) C1{ Fi Fi:0 Fl}



static void Test_STT233()
{
  {
    init_simple_test("STT233");
    static STT233 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT233)");
    check_field_offset(lv, fa, 0, "STT233.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT233.fb");
  }
}
static Arrange_To_Call_Me vSTT233(Test_STT233, "STT233", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT243  {
  int fa;
  __tsu64  :0;
  long fb;
};
//SIG(1 STT243) C1{ Fi FL:0 Fl}



static void Test_STT243()
{
  {
    init_simple_test("STT243");
    static STT243 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT243)");
    check_field_offset(lv, fa, 0, "STT243.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT243.fb");
  }
}
static Arrange_To_Call_Me vSTT243(Test_STT243, "STT243", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT253  {
  int fa;
  unsigned char  :3;
  long fb;
};
//SIG(1 STT253) C1{ Fi Fc:3 Fl}



static void Test_STT253()
{
  {
    init_simple_test("STT253");
    static STT253 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT253)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT253)");
    check_field_offset(lv, fa, 0, "STT253.fa");
    check_field_offset(lv, fb, 8, "STT253.fb");
  }
}
static Arrange_To_Call_Me vSTT253(Test_STT253, "STT253", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT263  {
  int fa;
  unsigned short  :3;
  long fb;
};
//SIG(1 STT263) C1{ Fi Fs:3 Fl}



static void Test_STT263()
{
  {
    init_simple_test("STT263");
    static STT263 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT263)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT263)");
    check_field_offset(lv, fa, 0, "STT263.fa");
    check_field_offset(lv, fb, 8, "STT263.fb");
  }
}
static Arrange_To_Call_Me vSTT263(Test_STT263, "STT263", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT273  {
  int fa;
  unsigned int  :3;
  long fb;
};
//SIG(1 STT273) C1{ Fi Fi:3 Fl}



static void Test_STT273()
{
  {
    init_simple_test("STT273");
    static STT273 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT273)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT273)");
    check_field_offset(lv, fa, 0, "STT273.fa");
    check_field_offset(lv, fb, 8, "STT273.fb");
  }
}
static Arrange_To_Call_Me vSTT273(Test_STT273, "STT273", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT283  {
  int fa;
  __tsu64  :3;
  long fb;
};
//SIG(1 STT283) C1{ Fi FL:3 Fl}



static void Test_STT283()
{
  {
    init_simple_test("STT283");
    static STT283 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT283)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT283)");
    check_field_offset(lv, fa, 0, "STT283.fa");
    check_field_offset(lv, fb, 8, "STT283.fb");
  }
}
static Arrange_To_Call_Me vSTT283(Test_STT283, "STT283", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT293  {
  int fa;
  unsigned short  :8;
  long fb;
};
//SIG(1 STT293) C1{ Fi Fs:8 Fl}



static void Test_STT293()
{
  {
    init_simple_test("STT293");
    static STT293 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT293)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT293)");
    check_field_offset(lv, fa, 0, "STT293.fa");
    check_field_offset(lv, fb, 8, "STT293.fb");
  }
}
static Arrange_To_Call_Me vSTT293(Test_STT293, "STT293", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2103  {
  int fa;
  unsigned int  :8;
  long fb;
};
//SIG(1 STT2103) C1{ Fi Fi:8 Fl}



static void Test_STT2103()
{
  {
    init_simple_test("STT2103");
    static STT2103 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2103)");
    check_field_offset(lv, fa, 0, "STT2103.fa");
    check_field_offset(lv, fb, 8, "STT2103.fb");
  }
}
static Arrange_To_Call_Me vSTT2103(Test_STT2103, "STT2103", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2113  {
  int fa;
  __tsu64  :8;
  long fb;
};
//SIG(1 STT2113) C1{ Fi FL:8 Fl}



static void Test_STT2113()
{
  {
    init_simple_test("STT2113");
    static STT2113 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2113)");
    check_field_offset(lv, fa, 0, "STT2113.fa");
    check_field_offset(lv, fb, 8, "STT2113.fb");
  }
}
static Arrange_To_Call_Me vSTT2113(Test_STT2113, "STT2113", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2123  {
  int fa;
  unsigned int  :18;
  long fb;
};
//SIG(1 STT2123) C1{ Fi Fi:18 Fl}



static void Test_STT2123()
{
  {
    init_simple_test("STT2123");
    static STT2123 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2123)");
    check_field_offset(lv, fa, 0, "STT2123.fa");
    check_field_offset(lv, fb, 8, "STT2123.fb");
  }
}
static Arrange_To_Call_Me vSTT2123(Test_STT2123, "STT2123", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2133  {
  int fa;
  __tsu64  :18;
  long fb;
};
//SIG(1 STT2133) C1{ Fi FL:18 Fl}



static void Test_STT2133()
{
  {
    init_simple_test("STT2133");
    static STT2133 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2133)");
    check_field_offset(lv, fa, 0, "STT2133.fa");
    check_field_offset(lv, fb, 8, "STT2133.fb");
  }
}
static Arrange_To_Call_Me vSTT2133(Test_STT2133, "STT2133", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2143  {
  int fa;
  __tsu64  :48;
  long fb;
};
//SIG(1 STT2143) C1{ Fi FL:48 Fl}



static void Test_STT2143()
{
  {
    init_simple_test("STT2143");
    static STT2143 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT2143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2143)");
    check_field_offset(lv, fa, 0, "STT2143.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2143.fb");
  }
}
static Arrange_To_Call_Me vSTT2143(Test_STT2143, "STT2143", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2153  {
  int fa;
  unsigned char bf:3;
  long fb;
};
//SIG(1 STT2153) C1{ Fi Fc:3 Fl}



static void Test_STT2153()
{
  {
    init_simple_test("STT2153");
    static STT2153 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2153)");
    check_field_offset(lv, fa, 0, "STT2153.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2153");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2153");
    check_field_offset(lv, fb, 8, "STT2153.fb");
  }
}
static Arrange_To_Call_Me vSTT2153(Test_STT2153, "STT2153", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2163  {
  int fa;
  unsigned short bf:3;
  long fb;
};
//SIG(1 STT2163) C1{ Fi Fs:3 Fl}



static void Test_STT2163()
{
  {
    init_simple_test("STT2163");
    static STT2163 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2163)");
    check_field_offset(lv, fa, 0, "STT2163.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2163");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2163");
    check_field_offset(lv, fb, 8, "STT2163.fb");
  }
}
static Arrange_To_Call_Me vSTT2163(Test_STT2163, "STT2163", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2173  {
  int fa;
  unsigned int bf:3;
  long fb;
};
//SIG(1 STT2173) C1{ Fi Fi:3 Fl}



static void Test_STT2173()
{
  {
    init_simple_test("STT2173");
    static STT2173 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2173)");
    check_field_offset(lv, fa, 0, "STT2173.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2173");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2173");
    check_field_offset(lv, fb, 8, "STT2173.fb");
  }
}
static Arrange_To_Call_Me vSTT2173(Test_STT2173, "STT2173", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2183  {
  int fa;
  __tsu64 bf:3;
  long fb;
};
//SIG(1 STT2183) C1{ Fi FL:3 Fl}



static void Test_STT2183()
{
  {
    init_simple_test("STT2183");
    static STT2183 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2183)");
    check_field_offset(lv, fa, 0, "STT2183.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2183");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2183");
    check_field_offset(lv, fb, 8, "STT2183.fb");
  }
}
static Arrange_To_Call_Me vSTT2183(Test_STT2183, "STT2183", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2193  {
  int fa;
  unsigned short bf:8;
  long fb;
};
//SIG(1 STT2193) C1{ Fi Fs:8 Fl}



static void Test_STT2193()
{
  {
    init_simple_test("STT2193");
    static STT2193 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2193)");
    check_field_offset(lv, fa, 0, "STT2193.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2193");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2193");
    check_field_offset(lv, fb, 8, "STT2193.fb");
  }
}
static Arrange_To_Call_Me vSTT2193(Test_STT2193, "STT2193", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2203  {
  int fa;
  unsigned int bf:8;
  long fb;
};
//SIG(1 STT2203) C1{ Fi Fi:8 Fl}



static void Test_STT2203()
{
  {
    init_simple_test("STT2203");
    static STT2203 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2203)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2203)");
    check_field_offset(lv, fa, 0, "STT2203.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2203");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2203");
    check_field_offset(lv, fb, 8, "STT2203.fb");
  }
}
static Arrange_To_Call_Me vSTT2203(Test_STT2203, "STT2203", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2213  {
  int fa;
  __tsu64 bf:8;
  long fb;
};
//SIG(1 STT2213) C1{ Fi FL:8 Fl}



static void Test_STT2213()
{
  {
    init_simple_test("STT2213");
    static STT2213 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2213)");
    check_field_offset(lv, fa, 0, "STT2213.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2213");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2213");
    check_field_offset(lv, fb, 8, "STT2213.fb");
  }
}
static Arrange_To_Call_Me vSTT2213(Test_STT2213, "STT2213", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2223  {
  int fa;
  unsigned int bf:18;
  long fb;
};
//SIG(1 STT2223) C1{ Fi Fi:18 Fl}



static void Test_STT2223()
{
  {
    init_simple_test("STT2223");
    static STT2223 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2223)");
    check_field_offset(lv, fa, 0, "STT2223.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2223");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2223");
    check_field_offset(lv, fb, 8, "STT2223.fb");
  }
}
static Arrange_To_Call_Me vSTT2223(Test_STT2223, "STT2223", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2233  {
  int fa;
  __tsu64 bf:18;
  long fb;
};
//SIG(1 STT2233) C1{ Fi FL:18 Fl}



static void Test_STT2233()
{
  {
    init_simple_test("STT2233");
    static STT2233 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2233)");
    check_field_offset(lv, fa, 0, "STT2233.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2233");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2233");
    check_field_offset(lv, fb, 8, "STT2233.fb");
  }
}
static Arrange_To_Call_Me vSTT2233(Test_STT2233, "STT2233", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2243  {
  int fa;
  __tsu64 bf:48;
  long fb;
};
//SIG(1 STT2243) C1{ Fi FL:48 Fl}



static void Test_STT2243()
{
  {
    init_simple_test("STT2243");
    static STT2243 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT2243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2243)");
    check_field_offset(lv, fa, 0, "STT2243.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2243");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2243");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2243.fb");
  }
}
static Arrange_To_Call_Me vSTT2243(Test_STT2243, "STT2243", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT214  {
  int fa;
  unsigned char  :0;
  __tsi64 fb;
};
//SIG(1 STT214) C1{ Fi Fc:0 FL}



static void Test_STT214()
{
  {
    init_simple_test("STT214");
    static STT214 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT214)");
    check_field_offset(lv, fa, 0, "STT214.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT214.fb");
  }
}
static Arrange_To_Call_Me vSTT214(Test_STT214, "STT214", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT224  {
  int fa;
  unsigned short  :0;
  __tsi64 fb;
};
//SIG(1 STT224) C1{ Fi Fs:0 FL}



static void Test_STT224()
{
  {
    init_simple_test("STT224");
    static STT224 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT224)");
    check_field_offset(lv, fa, 0, "STT224.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT224.fb");
  }
}
static Arrange_To_Call_Me vSTT224(Test_STT224, "STT224", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT234  {
  int fa;
  unsigned int  :0;
  __tsi64 fb;
};
//SIG(1 STT234) C1{ Fi Fi:0 FL}



static void Test_STT234()
{
  {
    init_simple_test("STT234");
    static STT234 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT234)");
    check_field_offset(lv, fa, 0, "STT234.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT234.fb");
  }
}
static Arrange_To_Call_Me vSTT234(Test_STT234, "STT234", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT244  {
  int fa;
  __tsu64  :0;
  __tsi64 fb;
};
//SIG(1 STT244) C1{ Fi FL:0 FL}



static void Test_STT244()
{
  {
    init_simple_test("STT244");
    static STT244 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT244)");
    check_field_offset(lv, fa, 0, "STT244.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT244.fb");
  }
}
static Arrange_To_Call_Me vSTT244(Test_STT244, "STT244", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT254  {
  int fa;
  unsigned char  :3;
  __tsi64 fb;
};
//SIG(1 STT254) C1{ Fi Fc:3 FL}



static void Test_STT254()
{
  {
    init_simple_test("STT254");
    static STT254 lv;
    check2(sizeof(lv), 16, "sizeof(STT254)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT254)");
    check_field_offset(lv, fa, 0, "STT254.fa");
    check_field_offset(lv, fb, 8, "STT254.fb");
  }
}
static Arrange_To_Call_Me vSTT254(Test_STT254, "STT254", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT264  {
  int fa;
  unsigned short  :3;
  __tsi64 fb;
};
//SIG(1 STT264) C1{ Fi Fs:3 FL}



static void Test_STT264()
{
  {
    init_simple_test("STT264");
    static STT264 lv;
    check2(sizeof(lv), 16, "sizeof(STT264)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT264)");
    check_field_offset(lv, fa, 0, "STT264.fa");
    check_field_offset(lv, fb, 8, "STT264.fb");
  }
}
static Arrange_To_Call_Me vSTT264(Test_STT264, "STT264", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT274  {
  int fa;
  unsigned int  :3;
  __tsi64 fb;
};
//SIG(1 STT274) C1{ Fi Fi:3 FL}



static void Test_STT274()
{
  {
    init_simple_test("STT274");
    static STT274 lv;
    check2(sizeof(lv), 16, "sizeof(STT274)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT274)");
    check_field_offset(lv, fa, 0, "STT274.fa");
    check_field_offset(lv, fb, 8, "STT274.fb");
  }
}
static Arrange_To_Call_Me vSTT274(Test_STT274, "STT274", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT284  {
  int fa;
  __tsu64  :3;
  __tsi64 fb;
};
//SIG(1 STT284) C1{ Fi FL:3 FL}



static void Test_STT284()
{
  {
    init_simple_test("STT284");
    static STT284 lv;
    check2(sizeof(lv), 16, "sizeof(STT284)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT284)");
    check_field_offset(lv, fa, 0, "STT284.fa");
    check_field_offset(lv, fb, 8, "STT284.fb");
  }
}
static Arrange_To_Call_Me vSTT284(Test_STT284, "STT284", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT294  {
  int fa;
  unsigned short  :8;
  __tsi64 fb;
};
//SIG(1 STT294) C1{ Fi Fs:8 FL}



static void Test_STT294()
{
  {
    init_simple_test("STT294");
    static STT294 lv;
    check2(sizeof(lv), 16, "sizeof(STT294)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT294)");
    check_field_offset(lv, fa, 0, "STT294.fa");
    check_field_offset(lv, fb, 8, "STT294.fb");
  }
}
static Arrange_To_Call_Me vSTT294(Test_STT294, "STT294", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2104  {
  int fa;
  unsigned int  :8;
  __tsi64 fb;
};
//SIG(1 STT2104) C1{ Fi Fi:8 FL}



static void Test_STT2104()
{
  {
    init_simple_test("STT2104");
    static STT2104 lv;
    check2(sizeof(lv), 16, "sizeof(STT2104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2104)");
    check_field_offset(lv, fa, 0, "STT2104.fa");
    check_field_offset(lv, fb, 8, "STT2104.fb");
  }
}
static Arrange_To_Call_Me vSTT2104(Test_STT2104, "STT2104", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2114  {
  int fa;
  __tsu64  :8;
  __tsi64 fb;
};
//SIG(1 STT2114) C1{ Fi FL:8 FL}



static void Test_STT2114()
{
  {
    init_simple_test("STT2114");
    static STT2114 lv;
    check2(sizeof(lv), 16, "sizeof(STT2114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2114)");
    check_field_offset(lv, fa, 0, "STT2114.fa");
    check_field_offset(lv, fb, 8, "STT2114.fb");
  }
}
static Arrange_To_Call_Me vSTT2114(Test_STT2114, "STT2114", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2124  {
  int fa;
  unsigned int  :18;
  __tsi64 fb;
};
//SIG(1 STT2124) C1{ Fi Fi:18 FL}



static void Test_STT2124()
{
  {
    init_simple_test("STT2124");
    static STT2124 lv;
    check2(sizeof(lv), 16, "sizeof(STT2124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2124)");
    check_field_offset(lv, fa, 0, "STT2124.fa");
    check_field_offset(lv, fb, 8, "STT2124.fb");
  }
}
static Arrange_To_Call_Me vSTT2124(Test_STT2124, "STT2124", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2134  {
  int fa;
  __tsu64  :18;
  __tsi64 fb;
};
//SIG(1 STT2134) C1{ Fi FL:18 FL}



static void Test_STT2134()
{
  {
    init_simple_test("STT2134");
    static STT2134 lv;
    check2(sizeof(lv), 16, "sizeof(STT2134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2134)");
    check_field_offset(lv, fa, 0, "STT2134.fa");
    check_field_offset(lv, fb, 8, "STT2134.fb");
  }
}
static Arrange_To_Call_Me vSTT2134(Test_STT2134, "STT2134", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2144  {
  int fa;
  __tsu64  :48;
  __tsi64 fb;
};
//SIG(1 STT2144) C1{ Fi FL:48 FL}



static void Test_STT2144()
{
  {
    init_simple_test("STT2144");
    static STT2144 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT2144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2144)");
    check_field_offset(lv, fa, 0, "STT2144.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2144.fb");
  }
}
static Arrange_To_Call_Me vSTT2144(Test_STT2144, "STT2144", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2154  {
  int fa;
  unsigned char bf:3;
  __tsi64 fb;
};
//SIG(1 STT2154) C1{ Fi Fc:3 FL}



static void Test_STT2154()
{
  {
    init_simple_test("STT2154");
    static STT2154 lv;
    check2(sizeof(lv), 16, "sizeof(STT2154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2154)");
    check_field_offset(lv, fa, 0, "STT2154.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2154");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2154");
    check_field_offset(lv, fb, 8, "STT2154.fb");
  }
}
static Arrange_To_Call_Me vSTT2154(Test_STT2154, "STT2154", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2164  {
  int fa;
  unsigned short bf:3;
  __tsi64 fb;
};
//SIG(1 STT2164) C1{ Fi Fs:3 FL}



static void Test_STT2164()
{
  {
    init_simple_test("STT2164");
    static STT2164 lv;
    check2(sizeof(lv), 16, "sizeof(STT2164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2164)");
    check_field_offset(lv, fa, 0, "STT2164.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2164");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2164");
    check_field_offset(lv, fb, 8, "STT2164.fb");
  }
}
static Arrange_To_Call_Me vSTT2164(Test_STT2164, "STT2164", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2174  {
  int fa;
  unsigned int bf:3;
  __tsi64 fb;
};
//SIG(1 STT2174) C1{ Fi Fi:3 FL}



static void Test_STT2174()
{
  {
    init_simple_test("STT2174");
    static STT2174 lv;
    check2(sizeof(lv), 16, "sizeof(STT2174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2174)");
    check_field_offset(lv, fa, 0, "STT2174.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2174");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2174");
    check_field_offset(lv, fb, 8, "STT2174.fb");
  }
}
static Arrange_To_Call_Me vSTT2174(Test_STT2174, "STT2174", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2184  {
  int fa;
  __tsu64 bf:3;
  __tsi64 fb;
};
//SIG(1 STT2184) C1{ Fi FL:3 FL}



static void Test_STT2184()
{
  {
    init_simple_test("STT2184");
    static STT2184 lv;
    check2(sizeof(lv), 16, "sizeof(STT2184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2184)");
    check_field_offset(lv, fa, 0, "STT2184.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2184");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2184");
    check_field_offset(lv, fb, 8, "STT2184.fb");
  }
}
static Arrange_To_Call_Me vSTT2184(Test_STT2184, "STT2184", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2194  {
  int fa;
  unsigned short bf:8;
  __tsi64 fb;
};
//SIG(1 STT2194) C1{ Fi Fs:8 FL}



static void Test_STT2194()
{
  {
    init_simple_test("STT2194");
    static STT2194 lv;
    check2(sizeof(lv), 16, "sizeof(STT2194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2194)");
    check_field_offset(lv, fa, 0, "STT2194.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2194");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2194");
    check_field_offset(lv, fb, 8, "STT2194.fb");
  }
}
static Arrange_To_Call_Me vSTT2194(Test_STT2194, "STT2194", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2204  {
  int fa;
  unsigned int bf:8;
  __tsi64 fb;
};
//SIG(1 STT2204) C1{ Fi Fi:8 FL}



static void Test_STT2204()
{
  {
    init_simple_test("STT2204");
    static STT2204 lv;
    check2(sizeof(lv), 16, "sizeof(STT2204)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2204)");
    check_field_offset(lv, fa, 0, "STT2204.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2204");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2204");
    check_field_offset(lv, fb, 8, "STT2204.fb");
  }
}
static Arrange_To_Call_Me vSTT2204(Test_STT2204, "STT2204", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2214  {
  int fa;
  __tsu64 bf:8;
  __tsi64 fb;
};
//SIG(1 STT2214) C1{ Fi FL:8 FL}



static void Test_STT2214()
{
  {
    init_simple_test("STT2214");
    static STT2214 lv;
    check2(sizeof(lv), 16, "sizeof(STT2214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2214)");
    check_field_offset(lv, fa, 0, "STT2214.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2214");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2214");
    check_field_offset(lv, fb, 8, "STT2214.fb");
  }
}
static Arrange_To_Call_Me vSTT2214(Test_STT2214, "STT2214", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2224  {
  int fa;
  unsigned int bf:18;
  __tsi64 fb;
};
//SIG(1 STT2224) C1{ Fi Fi:18 FL}



static void Test_STT2224()
{
  {
    init_simple_test("STT2224");
    static STT2224 lv;
    check2(sizeof(lv), 16, "sizeof(STT2224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2224)");
    check_field_offset(lv, fa, 0, "STT2224.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2224");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2224");
    check_field_offset(lv, fb, 8, "STT2224.fb");
  }
}
static Arrange_To_Call_Me vSTT2224(Test_STT2224, "STT2224", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2234  {
  int fa;
  __tsu64 bf:18;
  __tsi64 fb;
};
//SIG(1 STT2234) C1{ Fi FL:18 FL}



static void Test_STT2234()
{
  {
    init_simple_test("STT2234");
    static STT2234 lv;
    check2(sizeof(lv), 16, "sizeof(STT2234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2234)");
    check_field_offset(lv, fa, 0, "STT2234.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2234");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2234");
    check_field_offset(lv, fb, 8, "STT2234.fb");
  }
}
static Arrange_To_Call_Me vSTT2234(Test_STT2234, "STT2234", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2244  {
  int fa;
  __tsu64 bf:48;
  __tsi64 fb;
};
//SIG(1 STT2244) C1{ Fi FL:48 FL}



static void Test_STT2244()
{
  {
    init_simple_test("STT2244");
    static STT2244 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT2244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2244)");
    check_field_offset(lv, fa, 0, "STT2244.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2244");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2244");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2244.fb");
  }
}
static Arrange_To_Call_Me vSTT2244(Test_STT2244, "STT2244", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT215  {
  int fa;
  unsigned char  :0;
  void *fb;
};
//SIG(1 STT215) C1{ Fi Fc:0 Fp}



static void Test_STT215()
{
  {
    init_simple_test("STT215");
    static STT215 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT215)");
    check_field_offset(lv, fa, 0, "STT215.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT215.fb");
  }
}
static Arrange_To_Call_Me vSTT215(Test_STT215, "STT215", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT225  {
  int fa;
  unsigned short  :0;
  void *fb;
};
//SIG(1 STT225) C1{ Fi Fs:0 Fp}



static void Test_STT225()
{
  {
    init_simple_test("STT225");
    static STT225 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT225)");
    check_field_offset(lv, fa, 0, "STT225.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT225.fb");
  }
}
static Arrange_To_Call_Me vSTT225(Test_STT225, "STT225", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT235  {
  int fa;
  unsigned int  :0;
  void *fb;
};
//SIG(1 STT235) C1{ Fi Fi:0 Fp}



static void Test_STT235()
{
  {
    init_simple_test("STT235");
    static STT235 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT235)");
    check_field_offset(lv, fa, 0, "STT235.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT235.fb");
  }
}
static Arrange_To_Call_Me vSTT235(Test_STT235, "STT235", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT245  {
  int fa;
  __tsu64  :0;
  void *fb;
};
//SIG(1 STT245) C1{ Fi FL:0 Fp}



static void Test_STT245()
{
  {
    init_simple_test("STT245");
    static STT245 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT245)");
    check_field_offset(lv, fa, 0, "STT245.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT245.fb");
  }
}
static Arrange_To_Call_Me vSTT245(Test_STT245, "STT245", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT255  {
  int fa;
  unsigned char  :3;
  void *fb;
};
//SIG(1 STT255) C1{ Fi Fc:3 Fp}



static void Test_STT255()
{
  {
    init_simple_test("STT255");
    static STT255 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT255)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT255)");
    check_field_offset(lv, fa, 0, "STT255.fa");
    check_field_offset(lv, fb, 8, "STT255.fb");
  }
}
static Arrange_To_Call_Me vSTT255(Test_STT255, "STT255", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT265  {
  int fa;
  unsigned short  :3;
  void *fb;
};
//SIG(1 STT265) C1{ Fi Fs:3 Fp}



static void Test_STT265()
{
  {
    init_simple_test("STT265");
    static STT265 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT265)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT265)");
    check_field_offset(lv, fa, 0, "STT265.fa");
    check_field_offset(lv, fb, 8, "STT265.fb");
  }
}
static Arrange_To_Call_Me vSTT265(Test_STT265, "STT265", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT275  {
  int fa;
  unsigned int  :3;
  void *fb;
};
//SIG(1 STT275) C1{ Fi Fi:3 Fp}



static void Test_STT275()
{
  {
    init_simple_test("STT275");
    static STT275 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT275)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT275)");
    check_field_offset(lv, fa, 0, "STT275.fa");
    check_field_offset(lv, fb, 8, "STT275.fb");
  }
}
static Arrange_To_Call_Me vSTT275(Test_STT275, "STT275", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT285  {
  int fa;
  __tsu64  :3;
  void *fb;
};
//SIG(1 STT285) C1{ Fi FL:3 Fp}



static void Test_STT285()
{
  {
    init_simple_test("STT285");
    static STT285 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT285)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT285)");
    check_field_offset(lv, fa, 0, "STT285.fa");
    check_field_offset(lv, fb, 8, "STT285.fb");
  }
}
static Arrange_To_Call_Me vSTT285(Test_STT285, "STT285", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT295  {
  int fa;
  unsigned short  :8;
  void *fb;
};
//SIG(1 STT295) C1{ Fi Fs:8 Fp}



static void Test_STT295()
{
  {
    init_simple_test("STT295");
    static STT295 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT295)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT295)");
    check_field_offset(lv, fa, 0, "STT295.fa");
    check_field_offset(lv, fb, 8, "STT295.fb");
  }
}
static Arrange_To_Call_Me vSTT295(Test_STT295, "STT295", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2105  {
  int fa;
  unsigned int  :8;
  void *fb;
};
//SIG(1 STT2105) C1{ Fi Fi:8 Fp}



static void Test_STT2105()
{
  {
    init_simple_test("STT2105");
    static STT2105 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2105)");
    check_field_offset(lv, fa, 0, "STT2105.fa");
    check_field_offset(lv, fb, 8, "STT2105.fb");
  }
}
static Arrange_To_Call_Me vSTT2105(Test_STT2105, "STT2105", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2115  {
  int fa;
  __tsu64  :8;
  void *fb;
};
//SIG(1 STT2115) C1{ Fi FL:8 Fp}



static void Test_STT2115()
{
  {
    init_simple_test("STT2115");
    static STT2115 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2115)");
    check_field_offset(lv, fa, 0, "STT2115.fa");
    check_field_offset(lv, fb, 8, "STT2115.fb");
  }
}
static Arrange_To_Call_Me vSTT2115(Test_STT2115, "STT2115", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2125  {
  int fa;
  unsigned int  :18;
  void *fb;
};
//SIG(1 STT2125) C1{ Fi Fi:18 Fp}



static void Test_STT2125()
{
  {
    init_simple_test("STT2125");
    static STT2125 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2125)");
    check_field_offset(lv, fa, 0, "STT2125.fa");
    check_field_offset(lv, fb, 8, "STT2125.fb");
  }
}
static Arrange_To_Call_Me vSTT2125(Test_STT2125, "STT2125", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2135  {
  int fa;
  __tsu64  :18;
  void *fb;
};
//SIG(1 STT2135) C1{ Fi FL:18 Fp}



static void Test_STT2135()
{
  {
    init_simple_test("STT2135");
    static STT2135 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2135)");
    check_field_offset(lv, fa, 0, "STT2135.fa");
    check_field_offset(lv, fb, 8, "STT2135.fb");
  }
}
static Arrange_To_Call_Me vSTT2135(Test_STT2135, "STT2135", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2145  {
  int fa;
  __tsu64  :48;
  void *fb;
};
//SIG(1 STT2145) C1{ Fi FL:48 Fp}



static void Test_STT2145()
{
  {
    init_simple_test("STT2145");
    static STT2145 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT2145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2145)");
    check_field_offset(lv, fa, 0, "STT2145.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2145.fb");
  }
}
static Arrange_To_Call_Me vSTT2145(Test_STT2145, "STT2145", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2155  {
  int fa;
  unsigned char bf:3;
  void *fb;
};
//SIG(1 STT2155) C1{ Fi Fc:3 Fp}



static void Test_STT2155()
{
  {
    init_simple_test("STT2155");
    static STT2155 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2155)");
    check_field_offset(lv, fa, 0, "STT2155.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2155");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2155");
    check_field_offset(lv, fb, 8, "STT2155.fb");
  }
}
static Arrange_To_Call_Me vSTT2155(Test_STT2155, "STT2155", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2165  {
  int fa;
  unsigned short bf:3;
  void *fb;
};
//SIG(1 STT2165) C1{ Fi Fs:3 Fp}



static void Test_STT2165()
{
  {
    init_simple_test("STT2165");
    static STT2165 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2165)");
    check_field_offset(lv, fa, 0, "STT2165.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2165");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2165");
    check_field_offset(lv, fb, 8, "STT2165.fb");
  }
}
static Arrange_To_Call_Me vSTT2165(Test_STT2165, "STT2165", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2175  {
  int fa;
  unsigned int bf:3;
  void *fb;
};
//SIG(1 STT2175) C1{ Fi Fi:3 Fp}



static void Test_STT2175()
{
  {
    init_simple_test("STT2175");
    static STT2175 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2175)");
    check_field_offset(lv, fa, 0, "STT2175.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2175");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2175");
    check_field_offset(lv, fb, 8, "STT2175.fb");
  }
}
static Arrange_To_Call_Me vSTT2175(Test_STT2175, "STT2175", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2185  {
  int fa;
  __tsu64 bf:3;
  void *fb;
};
//SIG(1 STT2185) C1{ Fi FL:3 Fp}



static void Test_STT2185()
{
  {
    init_simple_test("STT2185");
    static STT2185 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2185)");
    check_field_offset(lv, fa, 0, "STT2185.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2185");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2185");
    check_field_offset(lv, fb, 8, "STT2185.fb");
  }
}
static Arrange_To_Call_Me vSTT2185(Test_STT2185, "STT2185", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2195  {
  int fa;
  unsigned short bf:8;
  void *fb;
};
//SIG(1 STT2195) C1{ Fi Fs:8 Fp}



static void Test_STT2195()
{
  {
    init_simple_test("STT2195");
    static STT2195 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2195)");
    check_field_offset(lv, fa, 0, "STT2195.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2195");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2195");
    check_field_offset(lv, fb, 8, "STT2195.fb");
  }
}
static Arrange_To_Call_Me vSTT2195(Test_STT2195, "STT2195", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2205  {
  int fa;
  unsigned int bf:8;
  void *fb;
};
//SIG(1 STT2205) C1{ Fi Fi:8 Fp}



static void Test_STT2205()
{
  {
    init_simple_test("STT2205");
    static STT2205 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2205)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2205)");
    check_field_offset(lv, fa, 0, "STT2205.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2205");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2205");
    check_field_offset(lv, fb, 8, "STT2205.fb");
  }
}
static Arrange_To_Call_Me vSTT2205(Test_STT2205, "STT2205", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2215  {
  int fa;
  __tsu64 bf:8;
  void *fb;
};
//SIG(1 STT2215) C1{ Fi FL:8 Fp}



static void Test_STT2215()
{
  {
    init_simple_test("STT2215");
    static STT2215 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2215)");
    check_field_offset(lv, fa, 0, "STT2215.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2215");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2215");
    check_field_offset(lv, fb, 8, "STT2215.fb");
  }
}
static Arrange_To_Call_Me vSTT2215(Test_STT2215, "STT2215", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2225  {
  int fa;
  unsigned int bf:18;
  void *fb;
};
//SIG(1 STT2225) C1{ Fi Fi:18 Fp}



static void Test_STT2225()
{
  {
    init_simple_test("STT2225");
    static STT2225 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2225)");
    check_field_offset(lv, fa, 0, "STT2225.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2225");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2225");
    check_field_offset(lv, fb, 8, "STT2225.fb");
  }
}
static Arrange_To_Call_Me vSTT2225(Test_STT2225, "STT2225", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2235  {
  int fa;
  __tsu64 bf:18;
  void *fb;
};
//SIG(1 STT2235) C1{ Fi FL:18 Fp}



static void Test_STT2235()
{
  {
    init_simple_test("STT2235");
    static STT2235 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2235)");
    check_field_offset(lv, fa, 0, "STT2235.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2235");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2235");
    check_field_offset(lv, fb, 8, "STT2235.fb");
  }
}
static Arrange_To_Call_Me vSTT2235(Test_STT2235, "STT2235", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2245  {
  int fa;
  __tsu64 bf:48;
  void *fb;
};
//SIG(1 STT2245) C1{ Fi FL:48 Fp}



static void Test_STT2245()
{
  {
    init_simple_test("STT2245");
    static STT2245 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT2245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2245)");
    check_field_offset(lv, fa, 0, "STT2245.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2245");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2245");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2245.fb");
  }
}
static Arrange_To_Call_Me vSTT2245(Test_STT2245, "STT2245", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT216  {
  int fa;
  unsigned char  :0;
  float fb;
};
//SIG(1 STT216) C1{ Fi Fc:0 Fi}



static void Test_STT216()
{
  {
    init_simple_test("STT216");
    static STT216 lv;
    check2(sizeof(lv), 8, "sizeof(STT216)");
    check2(__alignof__(lv), 4, "__alignof__(STT216)");
    check_field_offset(lv, fa, 0, "STT216.fa");
    check_field_offset(lv, fb, 4, "STT216.fb");
  }
}
static Arrange_To_Call_Me vSTT216(Test_STT216, "STT216", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT226  {
  int fa;
  unsigned short  :0;
  float fb;
};
//SIG(1 STT226) C1{ Fi Fs:0 Fi}



static void Test_STT226()
{
  {
    init_simple_test("STT226");
    static STT226 lv;
    check2(sizeof(lv), 8, "sizeof(STT226)");
    check2(__alignof__(lv), 4, "__alignof__(STT226)");
    check_field_offset(lv, fa, 0, "STT226.fa");
    check_field_offset(lv, fb, 4, "STT226.fb");
  }
}
static Arrange_To_Call_Me vSTT226(Test_STT226, "STT226", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT236  {
  int fa;
  unsigned int  :0;
  float fb;
};
//SIG(1 STT236) C1{ Fi Fi:0 Fi}



static void Test_STT236()
{
  {
    init_simple_test("STT236");
    static STT236 lv;
    check2(sizeof(lv), 8, "sizeof(STT236)");
    check2(__alignof__(lv), 4, "__alignof__(STT236)");
    check_field_offset(lv, fa, 0, "STT236.fa");
    check_field_offset(lv, fb, 4, "STT236.fb");
  }
}
static Arrange_To_Call_Me vSTT236(Test_STT236, "STT236", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT246  {
  int fa;
  __tsu64  :0;
  float fb;
};
//SIG(1 STT246) C1{ Fi FL:0 Fi}



static void Test_STT246()
{
  {
    init_simple_test("STT246");
    static STT246 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT246)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT246)");
    check_field_offset(lv, fa, 0, "STT246.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT246.fb");
  }
}
static Arrange_To_Call_Me vSTT246(Test_STT246, "STT246", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT256  {
  int fa;
  unsigned char  :3;
  float fb;
};
//SIG(1 STT256) C1{ Fi Fc:3 Fi}



static void Test_STT256()
{
  {
    init_simple_test("STT256");
    static STT256 lv;
    check2(sizeof(lv), 12, "sizeof(STT256)");
    check2(__alignof__(lv), 4, "__alignof__(STT256)");
    check_field_offset(lv, fa, 0, "STT256.fa");
    check_field_offset(lv, fb, 8, "STT256.fb");
  }
}
static Arrange_To_Call_Me vSTT256(Test_STT256, "STT256", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT266  {
  int fa;
  unsigned short  :3;
  float fb;
};
//SIG(1 STT266) C1{ Fi Fs:3 Fi}



static void Test_STT266()
{
  {
    init_simple_test("STT266");
    static STT266 lv;
    check2(sizeof(lv), 12, "sizeof(STT266)");
    check2(__alignof__(lv), 4, "__alignof__(STT266)");
    check_field_offset(lv, fa, 0, "STT266.fa");
    check_field_offset(lv, fb, 8, "STT266.fb");
  }
}
static Arrange_To_Call_Me vSTT266(Test_STT266, "STT266", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT276  {
  int fa;
  unsigned int  :3;
  float fb;
};
//SIG(1 STT276) C1{ Fi Fi:3 Fi}



static void Test_STT276()
{
  {
    init_simple_test("STT276");
    static STT276 lv;
    check2(sizeof(lv), 12, "sizeof(STT276)");
    check2(__alignof__(lv), 4, "__alignof__(STT276)");
    check_field_offset(lv, fa, 0, "STT276.fa");
    check_field_offset(lv, fb, 8, "STT276.fb");
  }
}
static Arrange_To_Call_Me vSTT276(Test_STT276, "STT276", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT286  {
  int fa;
  __tsu64  :3;
  float fb;
};
//SIG(1 STT286) C1{ Fi FL:3 Fi}



static void Test_STT286()
{
  {
    init_simple_test("STT286");
    static STT286 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT286)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT286)");
    check_field_offset(lv, fa, 0, "STT286.fa");
    check_field_offset(lv, fb, 8, "STT286.fb");
  }
}
static Arrange_To_Call_Me vSTT286(Test_STT286, "STT286", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT296  {
  int fa;
  unsigned short  :8;
  float fb;
};
//SIG(1 STT296) C1{ Fi Fs:8 Fi}



static void Test_STT296()
{
  {
    init_simple_test("STT296");
    static STT296 lv;
    check2(sizeof(lv), 12, "sizeof(STT296)");
    check2(__alignof__(lv), 4, "__alignof__(STT296)");
    check_field_offset(lv, fa, 0, "STT296.fa");
    check_field_offset(lv, fb, 8, "STT296.fb");
  }
}
static Arrange_To_Call_Me vSTT296(Test_STT296, "STT296", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2106  {
  int fa;
  unsigned int  :8;
  float fb;
};
//SIG(1 STT2106) C1{ Fi Fi:8 Fi}



static void Test_STT2106()
{
  {
    init_simple_test("STT2106");
    static STT2106 lv;
    check2(sizeof(lv), 12, "sizeof(STT2106)");
    check2(__alignof__(lv), 4, "__alignof__(STT2106)");
    check_field_offset(lv, fa, 0, "STT2106.fa");
    check_field_offset(lv, fb, 8, "STT2106.fb");
  }
}
static Arrange_To_Call_Me vSTT2106(Test_STT2106, "STT2106", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2116  {
  int fa;
  __tsu64  :8;
  float fb;
};
//SIG(1 STT2116) C1{ Fi FL:8 Fi}



static void Test_STT2116()
{
  {
    init_simple_test("STT2116");
    static STT2116 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT2116)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2116)");
    check_field_offset(lv, fa, 0, "STT2116.fa");
    check_field_offset(lv, fb, 8, "STT2116.fb");
  }
}
static Arrange_To_Call_Me vSTT2116(Test_STT2116, "STT2116", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2126  {
  int fa;
  unsigned int  :18;
  float fb;
};
//SIG(1 STT2126) C1{ Fi Fi:18 Fi}



static void Test_STT2126()
{
  {
    init_simple_test("STT2126");
    static STT2126 lv;
    check2(sizeof(lv), 12, "sizeof(STT2126)");
    check2(__alignof__(lv), 4, "__alignof__(STT2126)");
    check_field_offset(lv, fa, 0, "STT2126.fa");
    check_field_offset(lv, fb, 8, "STT2126.fb");
  }
}
static Arrange_To_Call_Me vSTT2126(Test_STT2126, "STT2126", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2136  {
  int fa;
  __tsu64  :18;
  float fb;
};
//SIG(1 STT2136) C1{ Fi FL:18 Fi}



static void Test_STT2136()
{
  {
    init_simple_test("STT2136");
    static STT2136 lv;
    check2(sizeof(lv), ABISELECT(12,12), "sizeof(STT2136)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2136)");
    check_field_offset(lv, fa, 0, "STT2136.fa");
    check_field_offset(lv, fb, 8, "STT2136.fb");
  }
}
static Arrange_To_Call_Me vSTT2136(Test_STT2136, "STT2136", ABISELECT(12,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2146  {
  int fa;
  __tsu64  :48;
  float fb;
};
//SIG(1 STT2146) C1{ Fi FL:48 Fi}



static void Test_STT2146()
{
  {
    init_simple_test("STT2146");
    static STT2146 lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(STT2146)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2146)");
    check_field_offset(lv, fa, 0, "STT2146.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2146.fb");
  }
}
static Arrange_To_Call_Me vSTT2146(Test_STT2146, "STT2146", ABISELECT(20,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2156  {
  int fa;
  unsigned char bf:3;
  float fb;
};
//SIG(1 STT2156) C1{ Fi Fc:3 Fi}



static void Test_STT2156()
{
  {
    init_simple_test("STT2156");
    static STT2156 lv;
    check2(sizeof(lv), 12, "sizeof(STT2156)");
    check2(__alignof__(lv), 4, "__alignof__(STT2156)");
    check_field_offset(lv, fa, 0, "STT2156.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2156");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2156");
    check_field_offset(lv, fb, 8, "STT2156.fb");
  }
}
static Arrange_To_Call_Me vSTT2156(Test_STT2156, "STT2156", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2166  {
  int fa;
  unsigned short bf:3;
  float fb;
};
//SIG(1 STT2166) C1{ Fi Fs:3 Fi}



static void Test_STT2166()
{
  {
    init_simple_test("STT2166");
    static STT2166 lv;
    check2(sizeof(lv), 12, "sizeof(STT2166)");
    check2(__alignof__(lv), 4, "__alignof__(STT2166)");
    check_field_offset(lv, fa, 0, "STT2166.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2166");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2166");
    check_field_offset(lv, fb, 8, "STT2166.fb");
  }
}
static Arrange_To_Call_Me vSTT2166(Test_STT2166, "STT2166", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2176  {
  int fa;
  unsigned int bf:3;
  float fb;
};
//SIG(1 STT2176) C1{ Fi Fi:3 Fi}



static void Test_STT2176()
{
  {
    init_simple_test("STT2176");
    static STT2176 lv;
    check2(sizeof(lv), 12, "sizeof(STT2176)");
    check2(__alignof__(lv), 4, "__alignof__(STT2176)");
    check_field_offset(lv, fa, 0, "STT2176.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2176");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2176");
    check_field_offset(lv, fb, 8, "STT2176.fb");
  }
}
static Arrange_To_Call_Me vSTT2176(Test_STT2176, "STT2176", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2186  {
  int fa;
  __tsu64 bf:3;
  float fb;
};
//SIG(1 STT2186) C1{ Fi FL:3 Fi}



static void Test_STT2186()
{
  {
    init_simple_test("STT2186");
    static STT2186 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2186)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2186)");
    check_field_offset(lv, fa, 0, "STT2186.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2186");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2186");
    check_field_offset(lv, fb, 8, "STT2186.fb");
  }
}
static Arrange_To_Call_Me vSTT2186(Test_STT2186, "STT2186", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2196  {
  int fa;
  unsigned short bf:8;
  float fb;
};
//SIG(1 STT2196) C1{ Fi Fs:8 Fi}



static void Test_STT2196()
{
  {
    init_simple_test("STT2196");
    static STT2196 lv;
    check2(sizeof(lv), 12, "sizeof(STT2196)");
    check2(__alignof__(lv), 4, "__alignof__(STT2196)");
    check_field_offset(lv, fa, 0, "STT2196.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2196");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2196");
    check_field_offset(lv, fb, 8, "STT2196.fb");
  }
}
static Arrange_To_Call_Me vSTT2196(Test_STT2196, "STT2196", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2206  {
  int fa;
  unsigned int bf:8;
  float fb;
};
//SIG(1 STT2206) C1{ Fi Fi:8 Fi}



static void Test_STT2206()
{
  {
    init_simple_test("STT2206");
    static STT2206 lv;
    check2(sizeof(lv), 12, "sizeof(STT2206)");
    check2(__alignof__(lv), 4, "__alignof__(STT2206)");
    check_field_offset(lv, fa, 0, "STT2206.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2206");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2206");
    check_field_offset(lv, fb, 8, "STT2206.fb");
  }
}
static Arrange_To_Call_Me vSTT2206(Test_STT2206, "STT2206", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2216  {
  int fa;
  __tsu64 bf:8;
  float fb;
};
//SIG(1 STT2216) C1{ Fi FL:8 Fi}



static void Test_STT2216()
{
  {
    init_simple_test("STT2216");
    static STT2216 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2216)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2216)");
    check_field_offset(lv, fa, 0, "STT2216.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2216");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2216");
    check_field_offset(lv, fb, 8, "STT2216.fb");
  }
}
static Arrange_To_Call_Me vSTT2216(Test_STT2216, "STT2216", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2226  {
  int fa;
  unsigned int bf:18;
  float fb;
};
//SIG(1 STT2226) C1{ Fi Fi:18 Fi}



static void Test_STT2226()
{
  {
    init_simple_test("STT2226");
    static STT2226 lv;
    check2(sizeof(lv), 12, "sizeof(STT2226)");
    check2(__alignof__(lv), 4, "__alignof__(STT2226)");
    check_field_offset(lv, fa, 0, "STT2226.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2226");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2226");
    check_field_offset(lv, fb, 8, "STT2226.fb");
  }
}
static Arrange_To_Call_Me vSTT2226(Test_STT2226, "STT2226", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2236  {
  int fa;
  __tsu64 bf:18;
  float fb;
};
//SIG(1 STT2236) C1{ Fi FL:18 Fi}



static void Test_STT2236()
{
  {
    init_simple_test("STT2236");
    static STT2236 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2236)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2236)");
    check_field_offset(lv, fa, 0, "STT2236.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2236");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2236");
    check_field_offset(lv, fb, 8, "STT2236.fb");
  }
}
static Arrange_To_Call_Me vSTT2236(Test_STT2236, "STT2236", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2246  {
  int fa;
  __tsu64 bf:48;
  float fb;
};
//SIG(1 STT2246) C1{ Fi FL:48 Fi}



static void Test_STT2246()
{
  {
    init_simple_test("STT2246");
    static STT2246 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT2246)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2246)");
    check_field_offset(lv, fa, 0, "STT2246.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2246");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2246");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2246.fb");
  }
}
static Arrange_To_Call_Me vSTT2246(Test_STT2246, "STT2246", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT217  {
  int fa;
  unsigned char  :0;
  double fb;
};
//SIG(1 STT217) C1{ Fi Fc:0 FL}



static void Test_STT217()
{
  {
    init_simple_test("STT217");
    static STT217 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT217)");
    check_field_offset(lv, fa, 0, "STT217.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT217.fb");
  }
}
static Arrange_To_Call_Me vSTT217(Test_STT217, "STT217", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT227  {
  int fa;
  unsigned short  :0;
  double fb;
};
//SIG(1 STT227) C1{ Fi Fs:0 FL}



static void Test_STT227()
{
  {
    init_simple_test("STT227");
    static STT227 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT227)");
    check_field_offset(lv, fa, 0, "STT227.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT227.fb");
  }
}
static Arrange_To_Call_Me vSTT227(Test_STT227, "STT227", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT237  {
  int fa;
  unsigned int  :0;
  double fb;
};
//SIG(1 STT237) C1{ Fi Fi:0 FL}



static void Test_STT237()
{
  {
    init_simple_test("STT237");
    static STT237 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT237)");
    check_field_offset(lv, fa, 0, "STT237.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT237.fb");
  }
}
static Arrange_To_Call_Me vSTT237(Test_STT237, "STT237", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT247  {
  int fa;
  __tsu64  :0;
  double fb;
};
//SIG(1 STT247) C1{ Fi FL:0 FL}



static void Test_STT247()
{
  {
    init_simple_test("STT247");
    static STT247 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT247)");
    check_field_offset(lv, fa, 0, "STT247.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT247.fb");
  }
}
static Arrange_To_Call_Me vSTT247(Test_STT247, "STT247", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT257  {
  int fa;
  unsigned char  :3;
  double fb;
};
//SIG(1 STT257) C1{ Fi Fc:3 FL}



static void Test_STT257()
{
  {
    init_simple_test("STT257");
    static STT257 lv;
    check2(sizeof(lv), 16, "sizeof(STT257)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT257)");
    check_field_offset(lv, fa, 0, "STT257.fa");
    check_field_offset(lv, fb, 8, "STT257.fb");
  }
}
static Arrange_To_Call_Me vSTT257(Test_STT257, "STT257", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT267  {
  int fa;
  unsigned short  :3;
  double fb;
};
//SIG(1 STT267) C1{ Fi Fs:3 FL}



static void Test_STT267()
{
  {
    init_simple_test("STT267");
    static STT267 lv;
    check2(sizeof(lv), 16, "sizeof(STT267)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT267)");
    check_field_offset(lv, fa, 0, "STT267.fa");
    check_field_offset(lv, fb, 8, "STT267.fb");
  }
}
static Arrange_To_Call_Me vSTT267(Test_STT267, "STT267", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT277  {
  int fa;
  unsigned int  :3;
  double fb;
};
//SIG(1 STT277) C1{ Fi Fi:3 FL}



static void Test_STT277()
{
  {
    init_simple_test("STT277");
    static STT277 lv;
    check2(sizeof(lv), 16, "sizeof(STT277)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT277)");
    check_field_offset(lv, fa, 0, "STT277.fa");
    check_field_offset(lv, fb, 8, "STT277.fb");
  }
}
static Arrange_To_Call_Me vSTT277(Test_STT277, "STT277", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT287  {
  int fa;
  __tsu64  :3;
  double fb;
};
//SIG(1 STT287) C1{ Fi FL:3 FL}



static void Test_STT287()
{
  {
    init_simple_test("STT287");
    static STT287 lv;
    check2(sizeof(lv), 16, "sizeof(STT287)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT287)");
    check_field_offset(lv, fa, 0, "STT287.fa");
    check_field_offset(lv, fb, 8, "STT287.fb");
  }
}
static Arrange_To_Call_Me vSTT287(Test_STT287, "STT287", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT297  {
  int fa;
  unsigned short  :8;
  double fb;
};
//SIG(1 STT297) C1{ Fi Fs:8 FL}



static void Test_STT297()
{
  {
    init_simple_test("STT297");
    static STT297 lv;
    check2(sizeof(lv), 16, "sizeof(STT297)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT297)");
    check_field_offset(lv, fa, 0, "STT297.fa");
    check_field_offset(lv, fb, 8, "STT297.fb");
  }
}
static Arrange_To_Call_Me vSTT297(Test_STT297, "STT297", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2107  {
  int fa;
  unsigned int  :8;
  double fb;
};
//SIG(1 STT2107) C1{ Fi Fi:8 FL}



static void Test_STT2107()
{
  {
    init_simple_test("STT2107");
    static STT2107 lv;
    check2(sizeof(lv), 16, "sizeof(STT2107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2107)");
    check_field_offset(lv, fa, 0, "STT2107.fa");
    check_field_offset(lv, fb, 8, "STT2107.fb");
  }
}
static Arrange_To_Call_Me vSTT2107(Test_STT2107, "STT2107", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2117  {
  int fa;
  __tsu64  :8;
  double fb;
};
//SIG(1 STT2117) C1{ Fi FL:8 FL}



static void Test_STT2117()
{
  {
    init_simple_test("STT2117");
    static STT2117 lv;
    check2(sizeof(lv), 16, "sizeof(STT2117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2117)");
    check_field_offset(lv, fa, 0, "STT2117.fa");
    check_field_offset(lv, fb, 8, "STT2117.fb");
  }
}
static Arrange_To_Call_Me vSTT2117(Test_STT2117, "STT2117", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2127  {
  int fa;
  unsigned int  :18;
  double fb;
};
//SIG(1 STT2127) C1{ Fi Fi:18 FL}



static void Test_STT2127()
{
  {
    init_simple_test("STT2127");
    static STT2127 lv;
    check2(sizeof(lv), 16, "sizeof(STT2127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2127)");
    check_field_offset(lv, fa, 0, "STT2127.fa");
    check_field_offset(lv, fb, 8, "STT2127.fb");
  }
}
static Arrange_To_Call_Me vSTT2127(Test_STT2127, "STT2127", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2137  {
  int fa;
  __tsu64  :18;
  double fb;
};
//SIG(1 STT2137) C1{ Fi FL:18 FL}



static void Test_STT2137()
{
  {
    init_simple_test("STT2137");
    static STT2137 lv;
    check2(sizeof(lv), 16, "sizeof(STT2137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2137)");
    check_field_offset(lv, fa, 0, "STT2137.fa");
    check_field_offset(lv, fb, 8, "STT2137.fb");
  }
}
static Arrange_To_Call_Me vSTT2137(Test_STT2137, "STT2137", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2147  {
  int fa;
  __tsu64  :48;
  double fb;
};
//SIG(1 STT2147) C1{ Fi FL:48 FL}



static void Test_STT2147()
{
  {
    init_simple_test("STT2147");
    static STT2147 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT2147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2147)");
    check_field_offset(lv, fa, 0, "STT2147.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2147.fb");
  }
}
static Arrange_To_Call_Me vSTT2147(Test_STT2147, "STT2147", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2157  {
  int fa;
  unsigned char bf:3;
  double fb;
};
//SIG(1 STT2157) C1{ Fi Fc:3 FL}



static void Test_STT2157()
{
  {
    init_simple_test("STT2157");
    static STT2157 lv;
    check2(sizeof(lv), 16, "sizeof(STT2157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2157)");
    check_field_offset(lv, fa, 0, "STT2157.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2157");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2157");
    check_field_offset(lv, fb, 8, "STT2157.fb");
  }
}
static Arrange_To_Call_Me vSTT2157(Test_STT2157, "STT2157", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2167  {
  int fa;
  unsigned short bf:3;
  double fb;
};
//SIG(1 STT2167) C1{ Fi Fs:3 FL}



static void Test_STT2167()
{
  {
    init_simple_test("STT2167");
    static STT2167 lv;
    check2(sizeof(lv), 16, "sizeof(STT2167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2167)");
    check_field_offset(lv, fa, 0, "STT2167.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2167");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2167");
    check_field_offset(lv, fb, 8, "STT2167.fb");
  }
}
static Arrange_To_Call_Me vSTT2167(Test_STT2167, "STT2167", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2177  {
  int fa;
  unsigned int bf:3;
  double fb;
};
//SIG(1 STT2177) C1{ Fi Fi:3 FL}



static void Test_STT2177()
{
  {
    init_simple_test("STT2177");
    static STT2177 lv;
    check2(sizeof(lv), 16, "sizeof(STT2177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2177)");
    check_field_offset(lv, fa, 0, "STT2177.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2177");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2177");
    check_field_offset(lv, fb, 8, "STT2177.fb");
  }
}
static Arrange_To_Call_Me vSTT2177(Test_STT2177, "STT2177", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2187  {
  int fa;
  __tsu64 bf:3;
  double fb;
};
//SIG(1 STT2187) C1{ Fi FL:3 FL}



static void Test_STT2187()
{
  {
    init_simple_test("STT2187");
    static STT2187 lv;
    check2(sizeof(lv), 16, "sizeof(STT2187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2187)");
    check_field_offset(lv, fa, 0, "STT2187.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2187");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2187");
    check_field_offset(lv, fb, 8, "STT2187.fb");
  }
}
static Arrange_To_Call_Me vSTT2187(Test_STT2187, "STT2187", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2197  {
  int fa;
  unsigned short bf:8;
  double fb;
};
//SIG(1 STT2197) C1{ Fi Fs:8 FL}



static void Test_STT2197()
{
  {
    init_simple_test("STT2197");
    static STT2197 lv;
    check2(sizeof(lv), 16, "sizeof(STT2197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2197)");
    check_field_offset(lv, fa, 0, "STT2197.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2197");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2197");
    check_field_offset(lv, fb, 8, "STT2197.fb");
  }
}
static Arrange_To_Call_Me vSTT2197(Test_STT2197, "STT2197", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2207  {
  int fa;
  unsigned int bf:8;
  double fb;
};
//SIG(1 STT2207) C1{ Fi Fi:8 FL}



static void Test_STT2207()
{
  {
    init_simple_test("STT2207");
    static STT2207 lv;
    check2(sizeof(lv), 16, "sizeof(STT2207)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2207)");
    check_field_offset(lv, fa, 0, "STT2207.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2207");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2207");
    check_field_offset(lv, fb, 8, "STT2207.fb");
  }
}
static Arrange_To_Call_Me vSTT2207(Test_STT2207, "STT2207", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2217  {
  int fa;
  __tsu64 bf:8;
  double fb;
};
//SIG(1 STT2217) C1{ Fi FL:8 FL}



static void Test_STT2217()
{
  {
    init_simple_test("STT2217");
    static STT2217 lv;
    check2(sizeof(lv), 16, "sizeof(STT2217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2217)");
    check_field_offset(lv, fa, 0, "STT2217.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2217");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2217");
    check_field_offset(lv, fb, 8, "STT2217.fb");
  }
}
static Arrange_To_Call_Me vSTT2217(Test_STT2217, "STT2217", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2227  {
  int fa;
  unsigned int bf:18;
  double fb;
};
//SIG(1 STT2227) C1{ Fi Fi:18 FL}



static void Test_STT2227()
{
  {
    init_simple_test("STT2227");
    static STT2227 lv;
    check2(sizeof(lv), 16, "sizeof(STT2227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2227)");
    check_field_offset(lv, fa, 0, "STT2227.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2227");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2227");
    check_field_offset(lv, fb, 8, "STT2227.fb");
  }
}
static Arrange_To_Call_Me vSTT2227(Test_STT2227, "STT2227", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2237  {
  int fa;
  __tsu64 bf:18;
  double fb;
};
//SIG(1 STT2237) C1{ Fi FL:18 FL}



static void Test_STT2237()
{
  {
    init_simple_test("STT2237");
    static STT2237 lv;
    check2(sizeof(lv), 16, "sizeof(STT2237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2237)");
    check_field_offset(lv, fa, 0, "STT2237.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2237");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2237");
    check_field_offset(lv, fb, 8, "STT2237.fb");
  }
}
static Arrange_To_Call_Me vSTT2237(Test_STT2237, "STT2237", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2247  {
  int fa;
  __tsu64 bf:48;
  double fb;
};
//SIG(1 STT2247) C1{ Fi FL:48 FL}



static void Test_STT2247()
{
  {
    init_simple_test("STT2247");
    static STT2247 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT2247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2247)");
    check_field_offset(lv, fa, 0, "STT2247.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2247");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2247");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2247.fb");
  }
}
static Arrange_To_Call_Me vSTT2247(Test_STT2247, "STT2247", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT218  {
  int fa;
  unsigned char  :0;
  long double fb;
};
//SIG(1 STT218) C1{ Fi Fc:0 FD}



static void Test_STT218()
{
  {
    init_simple_test("STT218");
    static STT218 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT218)");
    check_field_offset(lv, fa, 0, "STT218.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT218.fb");
  }
}
static Arrange_To_Call_Me vSTT218(Test_STT218, "STT218", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT228  {
  int fa;
  unsigned short  :0;
  long double fb;
};
//SIG(1 STT228) C1{ Fi Fs:0 FD}



static void Test_STT228()
{
  {
    init_simple_test("STT228");
    static STT228 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT228)");
    check_field_offset(lv, fa, 0, "STT228.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT228.fb");
  }
}
static Arrange_To_Call_Me vSTT228(Test_STT228, "STT228", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT238  {
  int fa;
  unsigned int  :0;
  long double fb;
};
//SIG(1 STT238) C1{ Fi Fi:0 FD}



static void Test_STT238()
{
  {
    init_simple_test("STT238");
    static STT238 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT238)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT238)");
    check_field_offset(lv, fa, 0, "STT238.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT238.fb");
  }
}
static Arrange_To_Call_Me vSTT238(Test_STT238, "STT238", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT248  {
  int fa;
  __tsu64  :0;
  long double fb;
};
//SIG(1 STT248) C1{ Fi FL:0 FD}



static void Test_STT248()
{
  {
    init_simple_test("STT248");
    static STT248 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT248)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT248)");
    check_field_offset(lv, fa, 0, "STT248.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT248.fb");
  }
}
static Arrange_To_Call_Me vSTT248(Test_STT248, "STT248", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT258  {
  int fa;
  unsigned char  :3;
  long double fb;
};
//SIG(1 STT258) C1{ Fi Fc:3 FD}



static void Test_STT258()
{
  {
    init_simple_test("STT258");
    static STT258 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT258)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT258)");
    check_field_offset(lv, fa, 0, "STT258.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT258.fb");
  }
}
static Arrange_To_Call_Me vSTT258(Test_STT258, "STT258", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT268  {
  int fa;
  unsigned short  :3;
  long double fb;
};
//SIG(1 STT268) C1{ Fi Fs:3 FD}



static void Test_STT268()
{
  {
    init_simple_test("STT268");
    static STT268 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT268)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT268)");
    check_field_offset(lv, fa, 0, "STT268.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT268.fb");
  }
}
static Arrange_To_Call_Me vSTT268(Test_STT268, "STT268", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT278  {
  int fa;
  unsigned int  :3;
  long double fb;
};
//SIG(1 STT278) C1{ Fi Fi:3 FD}



static void Test_STT278()
{
  {
    init_simple_test("STT278");
    static STT278 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT278)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT278)");
    check_field_offset(lv, fa, 0, "STT278.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT278.fb");
  }
}
static Arrange_To_Call_Me vSTT278(Test_STT278, "STT278", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT288  {
  int fa;
  __tsu64  :3;
  long double fb;
};
//SIG(1 STT288) C1{ Fi FL:3 FD}



static void Test_STT288()
{
  {
    init_simple_test("STT288");
    static STT288 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT288)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT288)");
    check_field_offset(lv, fa, 0, "STT288.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT288.fb");
  }
}
static Arrange_To_Call_Me vSTT288(Test_STT288, "STT288", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT298  {
  int fa;
  unsigned short  :8;
  long double fb;
};
//SIG(1 STT298) C1{ Fi Fs:8 FD}



static void Test_STT298()
{
  {
    init_simple_test("STT298");
    static STT298 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT298)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT298)");
    check_field_offset(lv, fa, 0, "STT298.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT298.fb");
  }
}
static Arrange_To_Call_Me vSTT298(Test_STT298, "STT298", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2108  {
  int fa;
  unsigned int  :8;
  long double fb;
};
//SIG(1 STT2108) C1{ Fi Fi:8 FD}



static void Test_STT2108()
{
  {
    init_simple_test("STT2108");
    static STT2108 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2108)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2108)");
    check_field_offset(lv, fa, 0, "STT2108.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2108.fb");
  }
}
static Arrange_To_Call_Me vSTT2108(Test_STT2108, "STT2108", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2118  {
  int fa;
  __tsu64  :8;
  long double fb;
};
//SIG(1 STT2118) C1{ Fi FL:8 FD}



static void Test_STT2118()
{
  {
    init_simple_test("STT2118");
    static STT2118 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2118)");
    check_field_offset(lv, fa, 0, "STT2118.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2118.fb");
  }
}
static Arrange_To_Call_Me vSTT2118(Test_STT2118, "STT2118", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2128  {
  int fa;
  unsigned int  :18;
  long double fb;
};
//SIG(1 STT2128) C1{ Fi Fi:18 FD}



static void Test_STT2128()
{
  {
    init_simple_test("STT2128");
    static STT2128 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2128)");
    check_field_offset(lv, fa, 0, "STT2128.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2128.fb");
  }
}
static Arrange_To_Call_Me vSTT2128(Test_STT2128, "STT2128", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2138  {
  int fa;
  __tsu64  :18;
  long double fb;
};
//SIG(1 STT2138) C1{ Fi FL:18 FD}



static void Test_STT2138()
{
  {
    init_simple_test("STT2138");
    static STT2138 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2138)");
    check_field_offset(lv, fa, 0, "STT2138.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2138.fb");
  }
}
static Arrange_To_Call_Me vSTT2138(Test_STT2138, "STT2138", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2148  {
  int fa;
  __tsu64  :48;
  long double fb;
};
//SIG(1 STT2148) C1{ Fi FL:48 FD}



static void Test_STT2148()
{
  {
    init_simple_test("STT2148");
    static STT2148 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT2148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2148)");
    check_field_offset(lv, fa, 0, "STT2148.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2148.fb");
  }
}
static Arrange_To_Call_Me vSTT2148(Test_STT2148, "STT2148", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2158  {
  int fa;
  unsigned char bf:3;
  long double fb;
};
//SIG(1 STT2158) C1{ Fi Fc:3 FD}



static void Test_STT2158()
{
  {
    init_simple_test("STT2158");
    static STT2158 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2158)");
    check_field_offset(lv, fa, 0, "STT2158.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2158");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2158");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2158.fb");
  }
}
static Arrange_To_Call_Me vSTT2158(Test_STT2158, "STT2158", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2168  {
  int fa;
  unsigned short bf:3;
  long double fb;
};
//SIG(1 STT2168) C1{ Fi Fs:3 FD}



static void Test_STT2168()
{
  {
    init_simple_test("STT2168");
    static STT2168 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2168)");
    check_field_offset(lv, fa, 0, "STT2168.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2168");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2168");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2168.fb");
  }
}
static Arrange_To_Call_Me vSTT2168(Test_STT2168, "STT2168", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2178  {
  int fa;
  unsigned int bf:3;
  long double fb;
};
//SIG(1 STT2178) C1{ Fi Fi:3 FD}



static void Test_STT2178()
{
  {
    init_simple_test("STT2178");
    static STT2178 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2178)");
    check_field_offset(lv, fa, 0, "STT2178.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2178");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2178");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2178.fb");
  }
}
static Arrange_To_Call_Me vSTT2178(Test_STT2178, "STT2178", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2188  {
  int fa;
  __tsu64 bf:3;
  long double fb;
};
//SIG(1 STT2188) C1{ Fi FL:3 FD}



static void Test_STT2188()
{
  {
    init_simple_test("STT2188");
    static STT2188 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2188)");
    check_field_offset(lv, fa, 0, "STT2188.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2188");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2188");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2188.fb");
  }
}
static Arrange_To_Call_Me vSTT2188(Test_STT2188, "STT2188", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2198  {
  int fa;
  unsigned short bf:8;
  long double fb;
};
//SIG(1 STT2198) C1{ Fi Fs:8 FD}



static void Test_STT2198()
{
  {
    init_simple_test("STT2198");
    static STT2198 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2198)");
    check_field_offset(lv, fa, 0, "STT2198.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2198");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2198");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2198.fb");
  }
}
static Arrange_To_Call_Me vSTT2198(Test_STT2198, "STT2198", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2208  {
  int fa;
  unsigned int bf:8;
  long double fb;
};
//SIG(1 STT2208) C1{ Fi Fi:8 FD}



static void Test_STT2208()
{
  {
    init_simple_test("STT2208");
    static STT2208 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2208)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2208)");
    check_field_offset(lv, fa, 0, "STT2208.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2208");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2208");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2208.fb");
  }
}
static Arrange_To_Call_Me vSTT2208(Test_STT2208, "STT2208", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2218  {
  int fa;
  __tsu64 bf:8;
  long double fb;
};
//SIG(1 STT2218) C1{ Fi FL:8 FD}



static void Test_STT2218()
{
  {
    init_simple_test("STT2218");
    static STT2218 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2218)");
    check_field_offset(lv, fa, 0, "STT2218.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2218");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2218");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2218.fb");
  }
}
static Arrange_To_Call_Me vSTT2218(Test_STT2218, "STT2218", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2228  {
  int fa;
  unsigned int bf:18;
  long double fb;
};
//SIG(1 STT2228) C1{ Fi Fi:18 FD}



static void Test_STT2228()
{
  {
    init_simple_test("STT2228");
    static STT2228 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2228)");
    check_field_offset(lv, fa, 0, "STT2228.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2228");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2228");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2228.fb");
  }
}
static Arrange_To_Call_Me vSTT2228(Test_STT2228, "STT2228", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2238  {
  int fa;
  __tsu64 bf:18;
  long double fb;
};
//SIG(1 STT2238) C1{ Fi FL:18 FD}



static void Test_STT2238()
{
  {
    init_simple_test("STT2238");
    static STT2238 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT2238)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2238)");
    check_field_offset(lv, fa, 0, "STT2238.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2238");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2238");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT2238.fb");
  }
}
static Arrange_To_Call_Me vSTT2238(Test_STT2238, "STT2238", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2248  {
  int fa;
  __tsu64 bf:48;
  long double fb;
};
//SIG(1 STT2248) C1{ Fi FL:48 FD}



static void Test_STT2248()
{
  {
    init_simple_test("STT2248");
    static STT2248 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT2248)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT2248)");
    check_field_offset(lv, fa, 0, "STT2248.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2248");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2248");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT2248.fb");
  }
}
static Arrange_To_Call_Me vSTT2248(Test_STT2248, "STT2248", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT219  {
  int fa;
  unsigned char  :0;
};
//SIG(1 STT219) C1{ Fi Fc:0}



static void Test_STT219()
{
  {
    init_simple_test("STT219");
    static STT219 lv;
    check2(sizeof(lv), 4, "sizeof(STT219)");
    check2(__alignof__(lv), 4, "__alignof__(STT219)");
    check_field_offset(lv, fa, 0, "STT219.fa");
  }
}
static Arrange_To_Call_Me vSTT219(Test_STT219, "STT219", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT229  {
  int fa;
  unsigned short  :0;
};
//SIG(1 STT229) C1{ Fi Fs:0}



static void Test_STT229()
{
  {
    init_simple_test("STT229");
    static STT229 lv;
    check2(sizeof(lv), 4, "sizeof(STT229)");
    check2(__alignof__(lv), 4, "__alignof__(STT229)");
    check_field_offset(lv, fa, 0, "STT229.fa");
  }
}
static Arrange_To_Call_Me vSTT229(Test_STT229, "STT229", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT239  {
  int fa;
  unsigned int  :0;
};
//SIG(1 STT239) C1{ Fi Fi:0}



static void Test_STT239()
{
  {
    init_simple_test("STT239");
    static STT239 lv;
    check2(sizeof(lv), 4, "sizeof(STT239)");
    check2(__alignof__(lv), 4, "__alignof__(STT239)");
    check_field_offset(lv, fa, 0, "STT239.fa");
  }
}
static Arrange_To_Call_Me vSTT239(Test_STT239, "STT239", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT249  {
  int fa;
  __tsu64  :0;
};
//SIG(1 STT249) C1{ Fi FL:0}



static void Test_STT249()
{
  {
    init_simple_test("STT249");
    static STT249 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT249)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT249)");
    check_field_offset(lv, fa, 0, "STT249.fa");
  }
}
static Arrange_To_Call_Me vSTT249(Test_STT249, "STT249", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT259  {
  int fa;
  unsigned char  :3;
};
//SIG(1 STT259) C1{ Fi Fc:3}



static void Test_STT259()
{
  {
    init_simple_test("STT259");
    static STT259 lv;
    check2(sizeof(lv), 8, "sizeof(STT259)");
    check2(__alignof__(lv), 4, "__alignof__(STT259)");
    check_field_offset(lv, fa, 0, "STT259.fa");
  }
}
static Arrange_To_Call_Me vSTT259(Test_STT259, "STT259", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT269  {
  int fa;
  unsigned short  :3;
};
//SIG(1 STT269) C1{ Fi Fs:3}



static void Test_STT269()
{
  {
    init_simple_test("STT269");
    static STT269 lv;
    check2(sizeof(lv), 8, "sizeof(STT269)");
    check2(__alignof__(lv), 4, "__alignof__(STT269)");
    check_field_offset(lv, fa, 0, "STT269.fa");
  }
}
static Arrange_To_Call_Me vSTT269(Test_STT269, "STT269", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT279  {
  int fa;
  unsigned int  :3;
};
//SIG(1 STT279) C1{ Fi Fi:3}



static void Test_STT279()
{
  {
    init_simple_test("STT279");
    static STT279 lv;
    check2(sizeof(lv), 8, "sizeof(STT279)");
    check2(__alignof__(lv), 4, "__alignof__(STT279)");
    check_field_offset(lv, fa, 0, "STT279.fa");
  }
}
static Arrange_To_Call_Me vSTT279(Test_STT279, "STT279", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT289  {
  int fa;
  __tsu64  :3;
};
//SIG(1 STT289) C1{ Fi FL:3}



static void Test_STT289()
{
  {
    init_simple_test("STT289");
    static STT289 lv;
    check2(sizeof(lv), 8, "sizeof(STT289)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT289)");
    check_field_offset(lv, fa, 0, "STT289.fa");
  }
}
static Arrange_To_Call_Me vSTT289(Test_STT289, "STT289", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT299  {
  int fa;
  unsigned short  :8;
};
//SIG(1 STT299) C1{ Fi Fs:8}



static void Test_STT299()
{
  {
    init_simple_test("STT299");
    static STT299 lv;
    check2(sizeof(lv), 8, "sizeof(STT299)");
    check2(__alignof__(lv), 4, "__alignof__(STT299)");
    check_field_offset(lv, fa, 0, "STT299.fa");
  }
}
static Arrange_To_Call_Me vSTT299(Test_STT299, "STT299", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2109  {
  int fa;
  unsigned int  :8;
};
//SIG(1 STT2109) C1{ Fi Fi:8}



static void Test_STT2109()
{
  {
    init_simple_test("STT2109");
    static STT2109 lv;
    check2(sizeof(lv), 8, "sizeof(STT2109)");
    check2(__alignof__(lv), 4, "__alignof__(STT2109)");
    check_field_offset(lv, fa, 0, "STT2109.fa");
  }
}
static Arrange_To_Call_Me vSTT2109(Test_STT2109, "STT2109", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2119  {
  int fa;
  __tsu64  :8;
};
//SIG(1 STT2119) C1{ Fi FL:8}



static void Test_STT2119()
{
  {
    init_simple_test("STT2119");
    static STT2119 lv;
    check2(sizeof(lv), 8, "sizeof(STT2119)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2119)");
    check_field_offset(lv, fa, 0, "STT2119.fa");
  }
}
static Arrange_To_Call_Me vSTT2119(Test_STT2119, "STT2119", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2129  {
  int fa;
  unsigned int  :18;
};
//SIG(1 STT2129) C1{ Fi Fi:18}



static void Test_STT2129()
{
  {
    init_simple_test("STT2129");
    static STT2129 lv;
    check2(sizeof(lv), 8, "sizeof(STT2129)");
    check2(__alignof__(lv), 4, "__alignof__(STT2129)");
    check_field_offset(lv, fa, 0, "STT2129.fa");
  }
}
static Arrange_To_Call_Me vSTT2129(Test_STT2129, "STT2129", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2139  {
  int fa;
  __tsu64  :18;
};
//SIG(1 STT2139) C1{ Fi FL:18}



static void Test_STT2139()
{
  {
    init_simple_test("STT2139");
    static STT2139 lv;
    check2(sizeof(lv), 8, "sizeof(STT2139)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2139)");
    check_field_offset(lv, fa, 0, "STT2139.fa");
  }
}
static Arrange_To_Call_Me vSTT2139(Test_STT2139, "STT2139", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2149  {
  int fa;
  __tsu64  :48;
};
//SIG(1 STT2149) C1{ Fi FL:48}



static void Test_STT2149()
{
  {
    init_simple_test("STT2149");
    static STT2149 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2149)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT2149)");
    check_field_offset(lv, fa, 0, "STT2149.fa");
  }
}
static Arrange_To_Call_Me vSTT2149(Test_STT2149, "STT2149", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2159  {
  int fa;
  unsigned char bf:3;
};
//SIG(1 STT2159) C1{ Fi Fc:3}



static void Test_STT2159()
{
  {
    init_simple_test("STT2159");
    static STT2159 lv;
    check2(sizeof(lv), 8, "sizeof(STT2159)");
    check2(__alignof__(lv), 4, "__alignof__(STT2159)");
    check_field_offset(lv, fa, 0, "STT2159.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2159");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2159");
  }
}
static Arrange_To_Call_Me vSTT2159(Test_STT2159, "STT2159", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2169  {
  int fa;
  unsigned short bf:3;
};
//SIG(1 STT2169) C1{ Fi Fs:3}



static void Test_STT2169()
{
  {
    init_simple_test("STT2169");
    static STT2169 lv;
    check2(sizeof(lv), 8, "sizeof(STT2169)");
    check2(__alignof__(lv), 4, "__alignof__(STT2169)");
    check_field_offset(lv, fa, 0, "STT2169.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2169");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2169");
  }
}
static Arrange_To_Call_Me vSTT2169(Test_STT2169, "STT2169", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2179  {
  int fa;
  unsigned int bf:3;
};
//SIG(1 STT2179) C1{ Fi Fi:3}



static void Test_STT2179()
{
  {
    init_simple_test("STT2179");
    static STT2179 lv;
    check2(sizeof(lv), 8, "sizeof(STT2179)");
    check2(__alignof__(lv), 4, "__alignof__(STT2179)");
    check_field_offset(lv, fa, 0, "STT2179.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2179");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2179");
  }
}
static Arrange_To_Call_Me vSTT2179(Test_STT2179, "STT2179", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2189  {
  int fa;
  __tsu64 bf:3;
};
//SIG(1 STT2189) C1{ Fi FL:3}



static void Test_STT2189()
{
  {
    init_simple_test("STT2189");
    static STT2189 lv;
    check2(sizeof(lv), 8, "sizeof(STT2189)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2189)");
    check_field_offset(lv, fa, 0, "STT2189.fa");
    set_bf_and_test(lv, bf, 4, 0, 3, 1, "STT2189");
    set_bf_and_test(lv, bf, 4, 0, 3, hide_ull(1LL<<2), "STT2189");
  }
}
static Arrange_To_Call_Me vSTT2189(Test_STT2189, "STT2189", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2199  {
  int fa;
  unsigned short bf:8;
};
//SIG(1 STT2199) C1{ Fi Fs:8}



static void Test_STT2199()
{
  {
    init_simple_test("STT2199");
    static STT2199 lv;
    check2(sizeof(lv), 8, "sizeof(STT2199)");
    check2(__alignof__(lv), 4, "__alignof__(STT2199)");
    check_field_offset(lv, fa, 0, "STT2199.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2199");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2199");
  }
}
static Arrange_To_Call_Me vSTT2199(Test_STT2199, "STT2199", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2209  {
  int fa;
  unsigned int bf:8;
};
//SIG(1 STT2209) C1{ Fi Fi:8}



static void Test_STT2209()
{
  {
    init_simple_test("STT2209");
    static STT2209 lv;
    check2(sizeof(lv), 8, "sizeof(STT2209)");
    check2(__alignof__(lv), 4, "__alignof__(STT2209)");
    check_field_offset(lv, fa, 0, "STT2209.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2209");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2209");
  }
}
static Arrange_To_Call_Me vSTT2209(Test_STT2209, "STT2209", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2219  {
  int fa;
  __tsu64 bf:8;
};
//SIG(1 STT2219) C1{ Fi FL:8}



static void Test_STT2219()
{
  {
    init_simple_test("STT2219");
    static STT2219 lv;
    check2(sizeof(lv), 8, "sizeof(STT2219)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2219)");
    check_field_offset(lv, fa, 0, "STT2219.fa");
    set_bf_and_test(lv, bf, 4, 0, 8, 1, "STT2219");
    set_bf_and_test(lv, bf, 4, 0, 8, hide_ull(1LL<<7), "STT2219");
  }
}
static Arrange_To_Call_Me vSTT2219(Test_STT2219, "STT2219", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2229  {
  int fa;
  unsigned int bf:18;
};
//SIG(1 STT2229) C1{ Fi Fi:18}



static void Test_STT2229()
{
  {
    init_simple_test("STT2229");
    static STT2229 lv;
    check2(sizeof(lv), 8, "sizeof(STT2229)");
    check2(__alignof__(lv), 4, "__alignof__(STT2229)");
    check_field_offset(lv, fa, 0, "STT2229.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2229");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2229");
  }
}
static Arrange_To_Call_Me vSTT2229(Test_STT2229, "STT2229", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2239  {
  int fa;
  __tsu64 bf:18;
};
//SIG(1 STT2239) C1{ Fi FL:18}



static void Test_STT2239()
{
  {
    init_simple_test("STT2239");
    static STT2239 lv;
    check2(sizeof(lv), 8, "sizeof(STT2239)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2239)");
    check_field_offset(lv, fa, 0, "STT2239.fa");
    set_bf_and_test(lv, bf, 4, 0, 18, 1, "STT2239");
    set_bf_and_test(lv, bf, 4, 0, 18, hide_ull(1LL<<17), "STT2239");
  }
}
static Arrange_To_Call_Me vSTT2239(Test_STT2239, "STT2239", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT2249  {
  int fa;
  __tsu64 bf:48;
};
//SIG(1 STT2249) C1{ Fi FL:48}



static void Test_STT2249()
{
  {
    init_simple_test("STT2249");
    static STT2249 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT2249)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT2249)");
    check_field_offset(lv, fa, 0, "STT2249.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT2249");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT2249");
  }
}
static Arrange_To_Call_Me vSTT2249(Test_STT2249, "STT2249", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT310  {
  long fa;
  unsigned char  :0;
  char fb;
};
//SIG(1 STT310) C1{ Fl Fc:0 Fc}



static void Test_STT310()
{
  {
    init_simple_test("STT310");
    static STT310 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT310)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT310)");
    check_field_offset(lv, fa, 0, "STT310.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT310.fb");
  }
}
static Arrange_To_Call_Me vSTT310(Test_STT310, "STT310", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT320  {
  long fa;
  unsigned short  :0;
  char fb;
};
//SIG(1 STT320) C1{ Fl Fs:0 Fc}



static void Test_STT320()
{
  {
    init_simple_test("STT320");
    static STT320 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT320)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT320)");
    check_field_offset(lv, fa, 0, "STT320.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT320.fb");
  }
}
static Arrange_To_Call_Me vSTT320(Test_STT320, "STT320", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT330  {
  long fa;
  unsigned int  :0;
  char fb;
};
//SIG(1 STT330) C1{ Fl Fi:0 Fc}



static void Test_STT330()
{
  {
    init_simple_test("STT330");
    static STT330 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT330)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT330)");
    check_field_offset(lv, fa, 0, "STT330.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT330.fb");
  }
}
static Arrange_To_Call_Me vSTT330(Test_STT330, "STT330", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT340  {
  long fa;
  __tsu64  :0;
  char fb;
};
//SIG(1 STT340) C1{ Fl FL:0 Fc}



static void Test_STT340()
{
  {
    init_simple_test("STT340");
    static STT340 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT340)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT340)");
    check_field_offset(lv, fa, 0, "STT340.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT340.fb");
  }
}
static Arrange_To_Call_Me vSTT340(Test_STT340, "STT340", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT350  {
  long fa;
  unsigned char  :3;
  char fb;
};
//SIG(1 STT350) C1{ Fl Fc:3 Fc}



static void Test_STT350()
{
  {
    init_simple_test("STT350");
    static STT350 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT350)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT350)");
    check_field_offset(lv, fa, 0, "STT350.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT350.fb");
  }
}
static Arrange_To_Call_Me vSTT350(Test_STT350, "STT350", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT360  {
  long fa;
  unsigned short  :3;
  char fb;
};
//SIG(1 STT360) C1{ Fl Fs:3 Fc}



static void Test_STT360()
{
  {
    init_simple_test("STT360");
    static STT360 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT360)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT360)");
    check_field_offset(lv, fa, 0, "STT360.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT360.fb");
  }
}
static Arrange_To_Call_Me vSTT360(Test_STT360, "STT360", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT370  {
  long fa;
  unsigned int  :3;
  char fb;
};
//SIG(1 STT370) C1{ Fl Fi:3 Fc}



static void Test_STT370()
{
  {
    init_simple_test("STT370");
    static STT370 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT370)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT370)");
    check_field_offset(lv, fa, 0, "STT370.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT370.fb");
  }
}
static Arrange_To_Call_Me vSTT370(Test_STT370, "STT370", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT380  {
  long fa;
  __tsu64  :3;
  char fb;
};
//SIG(1 STT380) C1{ Fl FL:3 Fc}



static void Test_STT380()
{
  {
    init_simple_test("STT380");
    static STT380 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT380)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT380)");
    check_field_offset(lv, fa, 0, "STT380.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT380.fb");
  }
}
static Arrange_To_Call_Me vSTT380(Test_STT380, "STT380", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT390  {
  long fa;
  unsigned short  :8;
  char fb;
};
//SIG(1 STT390) C1{ Fl Fs:8 Fc}



static void Test_STT390()
{
  {
    init_simple_test("STT390");
    static STT390 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT390)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT390)");
    check_field_offset(lv, fa, 0, "STT390.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT390.fb");
  }
}
static Arrange_To_Call_Me vSTT390(Test_STT390, "STT390", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3100  {
  long fa;
  unsigned int  :8;
  char fb;
};
//SIG(1 STT3100) C1{ Fl Fi:8 Fc}



static void Test_STT3100()
{
  {
    init_simple_test("STT3100");
    static STT3100 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3100)");
    check_field_offset(lv, fa, 0, "STT3100.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3100.fb");
  }
}
static Arrange_To_Call_Me vSTT3100(Test_STT3100, "STT3100", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3110  {
  long fa;
  __tsu64  :8;
  char fb;
};
//SIG(1 STT3110) C1{ Fl FL:8 Fc}



static void Test_STT3110()
{
  {
    init_simple_test("STT3110");
    static STT3110 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3110)");
    check_field_offset(lv, fa, 0, "STT3110.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3110.fb");
  }
}
static Arrange_To_Call_Me vSTT3110(Test_STT3110, "STT3110", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3120  {
  long fa;
  unsigned int  :18;
  char fb;
};
//SIG(1 STT3120) C1{ Fl Fi:18 Fc}



static void Test_STT3120()
{
  {
    init_simple_test("STT3120");
    static STT3120 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3120)");
    check_field_offset(lv, fa, 0, "STT3120.fa");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT3120.fb");
  }
}
static Arrange_To_Call_Me vSTT3120(Test_STT3120, "STT3120", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3130  {
  long fa;
  __tsu64  :18;
  char fb;
};
//SIG(1 STT3130) C1{ Fl FL:18 Fc}



static void Test_STT3130()
{
  {
    init_simple_test("STT3130");
    static STT3130 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3130)");
    check_field_offset(lv, fa, 0, "STT3130.fa");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT3130.fb");
  }
}
static Arrange_To_Call_Me vSTT3130(Test_STT3130, "STT3130", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3140  {
  long fa;
  __tsu64  :48;
  char fb;
};
//SIG(1 STT3140) C1{ Fl FL:48 Fc}



static void Test_STT3140()
{
  {
    init_simple_test("STT3140");
    static STT3140 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3140)");
    check_field_offset(lv, fa, 0, "STT3140.fa");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT3140.fb");
  }
}
static Arrange_To_Call_Me vSTT3140(Test_STT3140, "STT3140", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3150  {
  long fa;
  unsigned char bf:3;
  char fb;
};
//SIG(1 STT3150) C1{ Fl Fc:3 Fc}



static void Test_STT3150()
{
  {
    init_simple_test("STT3150");
    static STT3150 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3150)");
    check_field_offset(lv, fa, 0, "STT3150.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3150");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3150");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3150.fb");
  }
}
static Arrange_To_Call_Me vSTT3150(Test_STT3150, "STT3150", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3160  {
  long fa;
  unsigned short bf:3;
  char fb;
};
//SIG(1 STT3160) C1{ Fl Fs:3 Fc}



static void Test_STT3160()
{
  {
    init_simple_test("STT3160");
    static STT3160 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3160)");
    check_field_offset(lv, fa, 0, "STT3160.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3160");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3160");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3160.fb");
  }
}
static Arrange_To_Call_Me vSTT3160(Test_STT3160, "STT3160", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3170  {
  long fa;
  unsigned int bf:3;
  char fb;
};
//SIG(1 STT3170) C1{ Fl Fi:3 Fc}



static void Test_STT3170()
{
  {
    init_simple_test("STT3170");
    static STT3170 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3170)");
    check_field_offset(lv, fa, 0, "STT3170.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3170");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3170");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3170.fb");
  }
}
static Arrange_To_Call_Me vSTT3170(Test_STT3170, "STT3170", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3180  {
  long fa;
  __tsu64 bf:3;
  char fb;
};
//SIG(1 STT3180) C1{ Fl FL:3 Fc}



static void Test_STT3180()
{
  {
    init_simple_test("STT3180");
    static STT3180 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3180)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3180)");
    check_field_offset(lv, fa, 0, "STT3180.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3180");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3180");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3180.fb");
  }
}
static Arrange_To_Call_Me vSTT3180(Test_STT3180, "STT3180", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3190  {
  long fa;
  unsigned short bf:8;
  char fb;
};
//SIG(1 STT3190) C1{ Fl Fs:8 Fc}



static void Test_STT3190()
{
  {
    init_simple_test("STT3190");
    static STT3190 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3190)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3190)");
    check_field_offset(lv, fa, 0, "STT3190.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3190");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3190");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3190.fb");
  }
}
static Arrange_To_Call_Me vSTT3190(Test_STT3190, "STT3190", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3200  {
  long fa;
  unsigned int bf:8;
  char fb;
};
//SIG(1 STT3200) C1{ Fl Fi:8 Fc}



static void Test_STT3200()
{
  {
    init_simple_test("STT3200");
    static STT3200 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3200)");
    check_field_offset(lv, fa, 0, "STT3200.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3200");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3200");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3200.fb");
  }
}
static Arrange_To_Call_Me vSTT3200(Test_STT3200, "STT3200", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3210  {
  long fa;
  __tsu64 bf:8;
  char fb;
};
//SIG(1 STT3210) C1{ Fl FL:8 Fc}



static void Test_STT3210()
{
  {
    init_simple_test("STT3210");
    static STT3210 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3210)");
    check_field_offset(lv, fa, 0, "STT3210.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3210");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3210");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT3210.fb");
  }
}
static Arrange_To_Call_Me vSTT3210(Test_STT3210, "STT3210", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3220  {
  long fa;
  unsigned int bf:18;
  char fb;
};
//SIG(1 STT3220) C1{ Fl Fi:18 Fc}



static void Test_STT3220()
{
  {
    init_simple_test("STT3220");
    static STT3220 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3220)");
    check_field_offset(lv, fa, 0, "STT3220.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3220");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3220");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT3220.fb");
  }
}
static Arrange_To_Call_Me vSTT3220(Test_STT3220, "STT3220", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3230  {
  long fa;
  __tsu64 bf:18;
  char fb;
};
//SIG(1 STT3230) C1{ Fl FL:18 Fc}



static void Test_STT3230()
{
  {
    init_simple_test("STT3230");
    static STT3230 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3230)");
    check_field_offset(lv, fa, 0, "STT3230.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3230");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3230");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT3230.fb");
  }
}
static Arrange_To_Call_Me vSTT3230(Test_STT3230, "STT3230", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3240  {
  long fa;
  __tsu64 bf:48;
  char fb;
};
//SIG(1 STT3240) C1{ Fl FL:48 Fc}



static void Test_STT3240()
{
  {
    init_simple_test("STT3240");
    static STT3240 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3240)");
    check_field_offset(lv, fa, 0, "STT3240.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3240");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3240");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT3240.fb");
  }
}
static Arrange_To_Call_Me vSTT3240(Test_STT3240, "STT3240", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT311  {
  long fa;
  unsigned char  :0;
  short fb;
};
//SIG(1 STT311) C1{ Fl Fc:0 Fs}



static void Test_STT311()
{
  {
    init_simple_test("STT311");
    static STT311 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT311)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT311)");
    check_field_offset(lv, fa, 0, "STT311.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT311.fb");
  }
}
static Arrange_To_Call_Me vSTT311(Test_STT311, "STT311", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT321  {
  long fa;
  unsigned short  :0;
  short fb;
};
//SIG(1 STT321) C1{ Fl Fs:0 Fs}



static void Test_STT321()
{
  {
    init_simple_test("STT321");
    static STT321 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT321)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT321)");
    check_field_offset(lv, fa, 0, "STT321.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT321.fb");
  }
}
static Arrange_To_Call_Me vSTT321(Test_STT321, "STT321", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT331  {
  long fa;
  unsigned int  :0;
  short fb;
};
//SIG(1 STT331) C1{ Fl Fi:0 Fs}



static void Test_STT331()
{
  {
    init_simple_test("STT331");
    static STT331 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT331)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT331)");
    check_field_offset(lv, fa, 0, "STT331.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT331.fb");
  }
}
static Arrange_To_Call_Me vSTT331(Test_STT331, "STT331", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT341  {
  long fa;
  __tsu64  :0;
  short fb;
};
//SIG(1 STT341) C1{ Fl FL:0 Fs}



static void Test_STT341()
{
  {
    init_simple_test("STT341");
    static STT341 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT341)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT341)");
    check_field_offset(lv, fa, 0, "STT341.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT341.fb");
  }
}
static Arrange_To_Call_Me vSTT341(Test_STT341, "STT341", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT351  {
  long fa;
  unsigned char  :3;
  short fb;
};
//SIG(1 STT351) C1{ Fl Fc:3 Fs}



static void Test_STT351()
{
  {
    init_simple_test("STT351");
    static STT351 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT351)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT351)");
    check_field_offset(lv, fa, 0, "STT351.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT351.fb");
  }
}
static Arrange_To_Call_Me vSTT351(Test_STT351, "STT351", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT361  {
  long fa;
  unsigned short  :3;
  short fb;
};
//SIG(1 STT361) C1{ Fl Fs:3 Fs}



static void Test_STT361()
{
  {
    init_simple_test("STT361");
    static STT361 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT361)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT361)");
    check_field_offset(lv, fa, 0, "STT361.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT361.fb");
  }
}
static Arrange_To_Call_Me vSTT361(Test_STT361, "STT361", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT371  {
  long fa;
  unsigned int  :3;
  short fb;
};
//SIG(1 STT371) C1{ Fl Fi:3 Fs}



static void Test_STT371()
{
  {
    init_simple_test("STT371");
    static STT371 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT371)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT371)");
    check_field_offset(lv, fa, 0, "STT371.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT371.fb");
  }
}
static Arrange_To_Call_Me vSTT371(Test_STT371, "STT371", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT381  {
  long fa;
  __tsu64  :3;
  short fb;
};
//SIG(1 STT381) C1{ Fl FL:3 Fs}



static void Test_STT381()
{
  {
    init_simple_test("STT381");
    static STT381 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT381)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT381)");
    check_field_offset(lv, fa, 0, "STT381.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT381.fb");
  }
}
static Arrange_To_Call_Me vSTT381(Test_STT381, "STT381", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT391  {
  long fa;
  unsigned short  :8;
  short fb;
};
//SIG(1 STT391) C1{ Fl Fs:8 Fs}



static void Test_STT391()
{
  {
    init_simple_test("STT391");
    static STT391 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT391)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT391)");
    check_field_offset(lv, fa, 0, "STT391.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT391.fb");
  }
}
static Arrange_To_Call_Me vSTT391(Test_STT391, "STT391", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3101  {
  long fa;
  unsigned int  :8;
  short fb;
};
//SIG(1 STT3101) C1{ Fl Fi:8 Fs}



static void Test_STT3101()
{
  {
    init_simple_test("STT3101");
    static STT3101 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3101)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3101)");
    check_field_offset(lv, fa, 0, "STT3101.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3101.fb");
  }
}
static Arrange_To_Call_Me vSTT3101(Test_STT3101, "STT3101", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3111  {
  long fa;
  __tsu64  :8;
  short fb;
};
//SIG(1 STT3111) C1{ Fl FL:8 Fs}



static void Test_STT3111()
{
  {
    init_simple_test("STT3111");
    static STT3111 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3111)");
    check_field_offset(lv, fa, 0, "STT3111.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3111.fb");
  }
}
static Arrange_To_Call_Me vSTT3111(Test_STT3111, "STT3111", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3121  {
  long fa;
  unsigned int  :18;
  short fb;
};
//SIG(1 STT3121) C1{ Fl Fi:18 Fs}



static void Test_STT3121()
{
  {
    init_simple_test("STT3121");
    static STT3121 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3121)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3121)");
    check_field_offset(lv, fa, 0, "STT3121.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3121.fb");
  }
}
static Arrange_To_Call_Me vSTT3121(Test_STT3121, "STT3121", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3131  {
  long fa;
  __tsu64  :18;
  short fb;
};
//SIG(1 STT3131) C1{ Fl FL:18 Fs}



static void Test_STT3131()
{
  {
    init_simple_test("STT3131");
    static STT3131 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3131)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3131)");
    check_field_offset(lv, fa, 0, "STT3131.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3131.fb");
  }
}
static Arrange_To_Call_Me vSTT3131(Test_STT3131, "STT3131", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3141  {
  long fa;
  __tsu64  :48;
  short fb;
};
//SIG(1 STT3141) C1{ Fl FL:48 Fs}



static void Test_STT3141()
{
  {
    init_simple_test("STT3141");
    static STT3141 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3141)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3141)");
    check_field_offset(lv, fa, 0, "STT3141.fa");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT3141.fb");
  }
}
static Arrange_To_Call_Me vSTT3141(Test_STT3141, "STT3141", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3151  {
  long fa;
  unsigned char bf:3;
  short fb;
};
//SIG(1 STT3151) C1{ Fl Fc:3 Fs}



static void Test_STT3151()
{
  {
    init_simple_test("STT3151");
    static STT3151 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3151)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3151)");
    check_field_offset(lv, fa, 0, "STT3151.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3151");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3151");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3151.fb");
  }
}
static Arrange_To_Call_Me vSTT3151(Test_STT3151, "STT3151", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3161  {
  long fa;
  unsigned short bf:3;
  short fb;
};
//SIG(1 STT3161) C1{ Fl Fs:3 Fs}



static void Test_STT3161()
{
  {
    init_simple_test("STT3161");
    static STT3161 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3161)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3161)");
    check_field_offset(lv, fa, 0, "STT3161.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3161");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3161");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3161.fb");
  }
}
static Arrange_To_Call_Me vSTT3161(Test_STT3161, "STT3161", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3171  {
  long fa;
  unsigned int bf:3;
  short fb;
};
//SIG(1 STT3171) C1{ Fl Fi:3 Fs}



static void Test_STT3171()
{
  {
    init_simple_test("STT3171");
    static STT3171 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3171)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3171)");
    check_field_offset(lv, fa, 0, "STT3171.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3171");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3171");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3171.fb");
  }
}
static Arrange_To_Call_Me vSTT3171(Test_STT3171, "STT3171", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3181  {
  long fa;
  __tsu64 bf:3;
  short fb;
};
//SIG(1 STT3181) C1{ Fl FL:3 Fs}



static void Test_STT3181()
{
  {
    init_simple_test("STT3181");
    static STT3181 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3181)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3181)");
    check_field_offset(lv, fa, 0, "STT3181.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3181");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3181");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3181.fb");
  }
}
static Arrange_To_Call_Me vSTT3181(Test_STT3181, "STT3181", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3191  {
  long fa;
  unsigned short bf:8;
  short fb;
};
//SIG(1 STT3191) C1{ Fl Fs:8 Fs}



static void Test_STT3191()
{
  {
    init_simple_test("STT3191");
    static STT3191 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3191)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3191)");
    check_field_offset(lv, fa, 0, "STT3191.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3191");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3191");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3191.fb");
  }
}
static Arrange_To_Call_Me vSTT3191(Test_STT3191, "STT3191", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3201  {
  long fa;
  unsigned int bf:8;
  short fb;
};
//SIG(1 STT3201) C1{ Fl Fi:8 Fs}



static void Test_STT3201()
{
  {
    init_simple_test("STT3201");
    static STT3201 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3201)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3201)");
    check_field_offset(lv, fa, 0, "STT3201.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3201");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3201");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3201.fb");
  }
}
static Arrange_To_Call_Me vSTT3201(Test_STT3201, "STT3201", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3211  {
  long fa;
  __tsu64 bf:8;
  short fb;
};
//SIG(1 STT3211) C1{ Fl FL:8 Fs}



static void Test_STT3211()
{
  {
    init_simple_test("STT3211");
    static STT3211 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3211)");
    check_field_offset(lv, fa, 0, "STT3211.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3211");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3211");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT3211.fb");
  }
}
static Arrange_To_Call_Me vSTT3211(Test_STT3211, "STT3211", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3221  {
  long fa;
  unsigned int bf:18;
  short fb;
};
//SIG(1 STT3221) C1{ Fl Fi:18 Fs}



static void Test_STT3221()
{
  {
    init_simple_test("STT3221");
    static STT3221 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3221)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3221)");
    check_field_offset(lv, fa, 0, "STT3221.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3221");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3221");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3221.fb");
  }
}
static Arrange_To_Call_Me vSTT3221(Test_STT3221, "STT3221", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3231  {
  long fa;
  __tsu64 bf:18;
  short fb;
};
//SIG(1 STT3231) C1{ Fl FL:18 Fs}



static void Test_STT3231()
{
  {
    init_simple_test("STT3231");
    static STT3231 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3231)");
    check_field_offset(lv, fa, 0, "STT3231.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3231");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3231");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3231.fb");
  }
}
static Arrange_To_Call_Me vSTT3231(Test_STT3231, "STT3231", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3241  {
  long fa;
  __tsu64 bf:48;
  short fb;
};
//SIG(1 STT3241) C1{ Fl FL:48 Fs}



static void Test_STT3241()
{
  {
    init_simple_test("STT3241");
    static STT3241 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3241)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3241)");
    check_field_offset(lv, fa, 0, "STT3241.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3241");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3241");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT3241.fb");
  }
}
static Arrange_To_Call_Me vSTT3241(Test_STT3241, "STT3241", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT312  {
  long fa;
  unsigned char  :0;
  int fb;
};
//SIG(1 STT312) C1{ Fl Fc:0 Fi}



static void Test_STT312()
{
  {
    init_simple_test("STT312");
    static STT312 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT312)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT312)");
    check_field_offset(lv, fa, 0, "STT312.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT312.fb");
  }
}
static Arrange_To_Call_Me vSTT312(Test_STT312, "STT312", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT322  {
  long fa;
  unsigned short  :0;
  int fb;
};
//SIG(1 STT322) C1{ Fl Fs:0 Fi}



static void Test_STT322()
{
  {
    init_simple_test("STT322");
    static STT322 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT322)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT322)");
    check_field_offset(lv, fa, 0, "STT322.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT322.fb");
  }
}
static Arrange_To_Call_Me vSTT322(Test_STT322, "STT322", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT332  {
  long fa;
  unsigned int  :0;
  int fb;
};
//SIG(1 STT332) C1{ Fl Fi:0 Fi}



static void Test_STT332()
{
  {
    init_simple_test("STT332");
    static STT332 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT332)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT332)");
    check_field_offset(lv, fa, 0, "STT332.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT332.fb");
  }
}
static Arrange_To_Call_Me vSTT332(Test_STT332, "STT332", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT342  {
  long fa;
  __tsu64  :0;
  int fb;
};
//SIG(1 STT342) C1{ Fl FL:0 Fi}



static void Test_STT342()
{
  {
    init_simple_test("STT342");
    static STT342 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT342)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT342)");
    check_field_offset(lv, fa, 0, "STT342.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT342.fb");
  }
}
static Arrange_To_Call_Me vSTT342(Test_STT342, "STT342", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT352  {
  long fa;
  unsigned char  :3;
  int fb;
};
//SIG(1 STT352) C1{ Fl Fc:3 Fi}



static void Test_STT352()
{
  {
    init_simple_test("STT352");
    static STT352 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT352)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT352)");
    check_field_offset(lv, fa, 0, "STT352.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT352.fb");
  }
}
static Arrange_To_Call_Me vSTT352(Test_STT352, "STT352", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT362  {
  long fa;
  unsigned short  :3;
  int fb;
};
//SIG(1 STT362) C1{ Fl Fs:3 Fi}



static void Test_STT362()
{
  {
    init_simple_test("STT362");
    static STT362 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT362)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT362)");
    check_field_offset(lv, fa, 0, "STT362.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT362.fb");
  }
}
static Arrange_To_Call_Me vSTT362(Test_STT362, "STT362", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT372  {
  long fa;
  unsigned int  :3;
  int fb;
};
//SIG(1 STT372) C1{ Fl Fi:3 Fi}



static void Test_STT372()
{
  {
    init_simple_test("STT372");
    static STT372 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT372)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT372)");
    check_field_offset(lv, fa, 0, "STT372.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT372.fb");
  }
}
static Arrange_To_Call_Me vSTT372(Test_STT372, "STT372", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT382  {
  long fa;
  __tsu64  :3;
  int fb;
};
//SIG(1 STT382) C1{ Fl FL:3 Fi}



static void Test_STT382()
{
  {
    init_simple_test("STT382");
    static STT382 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT382)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT382)");
    check_field_offset(lv, fa, 0, "STT382.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT382.fb");
  }
}
static Arrange_To_Call_Me vSTT382(Test_STT382, "STT382", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT392  {
  long fa;
  unsigned short  :8;
  int fb;
};
//SIG(1 STT392) C1{ Fl Fs:8 Fi}



static void Test_STT392()
{
  {
    init_simple_test("STT392");
    static STT392 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT392)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT392)");
    check_field_offset(lv, fa, 0, "STT392.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT392.fb");
  }
}
static Arrange_To_Call_Me vSTT392(Test_STT392, "STT392", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3102  {
  long fa;
  unsigned int  :8;
  int fb;
};
//SIG(1 STT3102) C1{ Fl Fi:8 Fi}



static void Test_STT3102()
{
  {
    init_simple_test("STT3102");
    static STT3102 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3102)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3102)");
    check_field_offset(lv, fa, 0, "STT3102.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3102.fb");
  }
}
static Arrange_To_Call_Me vSTT3102(Test_STT3102, "STT3102", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3112  {
  long fa;
  __tsu64  :8;
  int fb;
};
//SIG(1 STT3112) C1{ Fl FL:8 Fi}



static void Test_STT3112()
{
  {
    init_simple_test("STT3112");
    static STT3112 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3112)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3112)");
    check_field_offset(lv, fa, 0, "STT3112.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3112.fb");
  }
}
static Arrange_To_Call_Me vSTT3112(Test_STT3112, "STT3112", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3122  {
  long fa;
  unsigned int  :18;
  int fb;
};
//SIG(1 STT3122) C1{ Fl Fi:18 Fi}



static void Test_STT3122()
{
  {
    init_simple_test("STT3122");
    static STT3122 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3122)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3122)");
    check_field_offset(lv, fa, 0, "STT3122.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3122.fb");
  }
}
static Arrange_To_Call_Me vSTT3122(Test_STT3122, "STT3122", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3132  {
  long fa;
  __tsu64  :18;
  int fb;
};
//SIG(1 STT3132) C1{ Fl FL:18 Fi}



static void Test_STT3132()
{
  {
    init_simple_test("STT3132");
    static STT3132 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3132)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3132)");
    check_field_offset(lv, fa, 0, "STT3132.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3132.fb");
  }
}
static Arrange_To_Call_Me vSTT3132(Test_STT3132, "STT3132", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3142  {
  long fa;
  __tsu64  :48;
  int fb;
};
//SIG(1 STT3142) C1{ Fl FL:48 Fi}



static void Test_STT3142()
{
  {
    init_simple_test("STT3142");
    static STT3142 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3142)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3142)");
    check_field_offset(lv, fa, 0, "STT3142.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3142.fb");
  }
}
static Arrange_To_Call_Me vSTT3142(Test_STT3142, "STT3142", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3152  {
  long fa;
  unsigned char bf:3;
  int fb;
};
//SIG(1 STT3152) C1{ Fl Fc:3 Fi}



static void Test_STT3152()
{
  {
    init_simple_test("STT3152");
    static STT3152 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3152)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3152)");
    check_field_offset(lv, fa, 0, "STT3152.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3152");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3152");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3152.fb");
  }
}
static Arrange_To_Call_Me vSTT3152(Test_STT3152, "STT3152", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3162  {
  long fa;
  unsigned short bf:3;
  int fb;
};
//SIG(1 STT3162) C1{ Fl Fs:3 Fi}



static void Test_STT3162()
{
  {
    init_simple_test("STT3162");
    static STT3162 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3162)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3162)");
    check_field_offset(lv, fa, 0, "STT3162.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3162");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3162");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3162.fb");
  }
}
static Arrange_To_Call_Me vSTT3162(Test_STT3162, "STT3162", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3172  {
  long fa;
  unsigned int bf:3;
  int fb;
};
//SIG(1 STT3172) C1{ Fl Fi:3 Fi}



static void Test_STT3172()
{
  {
    init_simple_test("STT3172");
    static STT3172 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3172)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3172)");
    check_field_offset(lv, fa, 0, "STT3172.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3172");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3172");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3172.fb");
  }
}
static Arrange_To_Call_Me vSTT3172(Test_STT3172, "STT3172", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3182  {
  long fa;
  __tsu64 bf:3;
  int fb;
};
//SIG(1 STT3182) C1{ Fl FL:3 Fi}



static void Test_STT3182()
{
  {
    init_simple_test("STT3182");
    static STT3182 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3182)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3182)");
    check_field_offset(lv, fa, 0, "STT3182.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3182");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3182");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3182.fb");
  }
}
static Arrange_To_Call_Me vSTT3182(Test_STT3182, "STT3182", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3192  {
  long fa;
  unsigned short bf:8;
  int fb;
};
//SIG(1 STT3192) C1{ Fl Fs:8 Fi}



static void Test_STT3192()
{
  {
    init_simple_test("STT3192");
    static STT3192 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3192)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3192)");
    check_field_offset(lv, fa, 0, "STT3192.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3192");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3192");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3192.fb");
  }
}
static Arrange_To_Call_Me vSTT3192(Test_STT3192, "STT3192", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3202  {
  long fa;
  unsigned int bf:8;
  int fb;
};
//SIG(1 STT3202) C1{ Fl Fi:8 Fi}



static void Test_STT3202()
{
  {
    init_simple_test("STT3202");
    static STT3202 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3202)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3202)");
    check_field_offset(lv, fa, 0, "STT3202.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3202");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3202");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3202.fb");
  }
}
static Arrange_To_Call_Me vSTT3202(Test_STT3202, "STT3202", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3212  {
  long fa;
  __tsu64 bf:8;
  int fb;
};
//SIG(1 STT3212) C1{ Fl FL:8 Fi}



static void Test_STT3212()
{
  {
    init_simple_test("STT3212");
    static STT3212 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3212)");
    check_field_offset(lv, fa, 0, "STT3212.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3212");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3212");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3212.fb");
  }
}
static Arrange_To_Call_Me vSTT3212(Test_STT3212, "STT3212", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3222  {
  long fa;
  unsigned int bf:18;
  int fb;
};
//SIG(1 STT3222) C1{ Fl Fi:18 Fi}



static void Test_STT3222()
{
  {
    init_simple_test("STT3222");
    static STT3222 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3222)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3222)");
    check_field_offset(lv, fa, 0, "STT3222.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3222");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3222");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3222.fb");
  }
}
static Arrange_To_Call_Me vSTT3222(Test_STT3222, "STT3222", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3232  {
  long fa;
  __tsu64 bf:18;
  int fb;
};
//SIG(1 STT3232) C1{ Fl FL:18 Fi}



static void Test_STT3232()
{
  {
    init_simple_test("STT3232");
    static STT3232 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3232)");
    check_field_offset(lv, fa, 0, "STT3232.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3232");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3232");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3232.fb");
  }
}
static Arrange_To_Call_Me vSTT3232(Test_STT3232, "STT3232", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3242  {
  long fa;
  __tsu64 bf:48;
  int fb;
};
//SIG(1 STT3242) C1{ Fl FL:48 Fi}



static void Test_STT3242()
{
  {
    init_simple_test("STT3242");
    static STT3242 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3242)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3242)");
    check_field_offset(lv, fa, 0, "STT3242.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3242");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3242");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3242.fb");
  }
}
static Arrange_To_Call_Me vSTT3242(Test_STT3242, "STT3242", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT313  {
  long fa;
  unsigned char  :0;
  long fb;
};
//SIG(1 STT313) C1{ Fl Fc:0 Fl}



static void Test_STT313()
{
  {
    init_simple_test("STT313");
    static STT313 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT313)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT313)");
    check_field_offset(lv, fa, 0, "STT313.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT313.fb");
  }
}
static Arrange_To_Call_Me vSTT313(Test_STT313, "STT313", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT323  {
  long fa;
  unsigned short  :0;
  long fb;
};
//SIG(1 STT323) C1{ Fl Fs:0 Fl}



static void Test_STT323()
{
  {
    init_simple_test("STT323");
    static STT323 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT323)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT323)");
    check_field_offset(lv, fa, 0, "STT323.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT323.fb");
  }
}
static Arrange_To_Call_Me vSTT323(Test_STT323, "STT323", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT333  {
  long fa;
  unsigned int  :0;
  long fb;
};
//SIG(1 STT333) C1{ Fl Fi:0 Fl}



static void Test_STT333()
{
  {
    init_simple_test("STT333");
    static STT333 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT333)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT333)");
    check_field_offset(lv, fa, 0, "STT333.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT333.fb");
  }
}
static Arrange_To_Call_Me vSTT333(Test_STT333, "STT333", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT343  {
  long fa;
  __tsu64  :0;
  long fb;
};
//SIG(1 STT343) C1{ Fl FL:0 Fl}



static void Test_STT343()
{
  {
    init_simple_test("STT343");
    static STT343 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT343)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT343)");
    check_field_offset(lv, fa, 0, "STT343.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT343.fb");
  }
}
static Arrange_To_Call_Me vSTT343(Test_STT343, "STT343", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT353  {
  long fa;
  unsigned char  :3;
  long fb;
};
//SIG(1 STT353) C1{ Fl Fc:3 Fl}



static void Test_STT353()
{
  {
    init_simple_test("STT353");
    static STT353 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT353)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT353)");
    check_field_offset(lv, fa, 0, "STT353.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT353.fb");
  }
}
static Arrange_To_Call_Me vSTT353(Test_STT353, "STT353", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT363  {
  long fa;
  unsigned short  :3;
  long fb;
};
//SIG(1 STT363) C1{ Fl Fs:3 Fl}



static void Test_STT363()
{
  {
    init_simple_test("STT363");
    static STT363 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT363)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT363)");
    check_field_offset(lv, fa, 0, "STT363.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT363.fb");
  }
}
static Arrange_To_Call_Me vSTT363(Test_STT363, "STT363", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT373  {
  long fa;
  unsigned int  :3;
  long fb;
};
//SIG(1 STT373) C1{ Fl Fi:3 Fl}



static void Test_STT373()
{
  {
    init_simple_test("STT373");
    static STT373 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT373)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT373)");
    check_field_offset(lv, fa, 0, "STT373.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT373.fb");
  }
}
static Arrange_To_Call_Me vSTT373(Test_STT373, "STT373", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT383  {
  long fa;
  __tsu64  :3;
  long fb;
};
//SIG(1 STT383) C1{ Fl FL:3 Fl}



static void Test_STT383()
{
  {
    init_simple_test("STT383");
    static STT383 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT383)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT383)");
    check_field_offset(lv, fa, 0, "STT383.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT383.fb");
  }
}
static Arrange_To_Call_Me vSTT383(Test_STT383, "STT383", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT393  {
  long fa;
  unsigned short  :8;
  long fb;
};
//SIG(1 STT393) C1{ Fl Fs:8 Fl}



static void Test_STT393()
{
  {
    init_simple_test("STT393");
    static STT393 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT393)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT393)");
    check_field_offset(lv, fa, 0, "STT393.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT393.fb");
  }
}
static Arrange_To_Call_Me vSTT393(Test_STT393, "STT393", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3103  {
  long fa;
  unsigned int  :8;
  long fb;
};
//SIG(1 STT3103) C1{ Fl Fi:8 Fl}



static void Test_STT3103()
{
  {
    init_simple_test("STT3103");
    static STT3103 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3103)");
    check_field_offset(lv, fa, 0, "STT3103.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3103.fb");
  }
}
static Arrange_To_Call_Me vSTT3103(Test_STT3103, "STT3103", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3113  {
  long fa;
  __tsu64  :8;
  long fb;
};
//SIG(1 STT3113) C1{ Fl FL:8 Fl}



static void Test_STT3113()
{
  {
    init_simple_test("STT3113");
    static STT3113 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3113)");
    check_field_offset(lv, fa, 0, "STT3113.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3113.fb");
  }
}
static Arrange_To_Call_Me vSTT3113(Test_STT3113, "STT3113", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3123  {
  long fa;
  unsigned int  :18;
  long fb;
};
//SIG(1 STT3123) C1{ Fl Fi:18 Fl}



static void Test_STT3123()
{
  {
    init_simple_test("STT3123");
    static STT3123 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3123)");
    check_field_offset(lv, fa, 0, "STT3123.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3123.fb");
  }
}
static Arrange_To_Call_Me vSTT3123(Test_STT3123, "STT3123", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3133  {
  long fa;
  __tsu64  :18;
  long fb;
};
//SIG(1 STT3133) C1{ Fl FL:18 Fl}



static void Test_STT3133()
{
  {
    init_simple_test("STT3133");
    static STT3133 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3133)");
    check_field_offset(lv, fa, 0, "STT3133.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3133.fb");
  }
}
static Arrange_To_Call_Me vSTT3133(Test_STT3133, "STT3133", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3143  {
  long fa;
  __tsu64  :48;
  long fb;
};
//SIG(1 STT3143) C1{ Fl FL:48 Fl}



static void Test_STT3143()
{
  {
    init_simple_test("STT3143");
    static STT3143 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3143)");
    check_field_offset(lv, fa, 0, "STT3143.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3143.fb");
  }
}
static Arrange_To_Call_Me vSTT3143(Test_STT3143, "STT3143", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3153  {
  long fa;
  unsigned char bf:3;
  long fb;
};
//SIG(1 STT3153) C1{ Fl Fc:3 Fl}



static void Test_STT3153()
{
  {
    init_simple_test("STT3153");
    static STT3153 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3153)");
    check_field_offset(lv, fa, 0, "STT3153.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3153");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3153");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3153.fb");
  }
}
static Arrange_To_Call_Me vSTT3153(Test_STT3153, "STT3153", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3163  {
  long fa;
  unsigned short bf:3;
  long fb;
};
//SIG(1 STT3163) C1{ Fl Fs:3 Fl}



static void Test_STT3163()
{
  {
    init_simple_test("STT3163");
    static STT3163 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3163)");
    check_field_offset(lv, fa, 0, "STT3163.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3163");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3163");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3163.fb");
  }
}
static Arrange_To_Call_Me vSTT3163(Test_STT3163, "STT3163", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3173  {
  long fa;
  unsigned int bf:3;
  long fb;
};
//SIG(1 STT3173) C1{ Fl Fi:3 Fl}



static void Test_STT3173()
{
  {
    init_simple_test("STT3173");
    static STT3173 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3173)");
    check_field_offset(lv, fa, 0, "STT3173.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3173");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3173");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3173.fb");
  }
}
static Arrange_To_Call_Me vSTT3173(Test_STT3173, "STT3173", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3183  {
  long fa;
  __tsu64 bf:3;
  long fb;
};
//SIG(1 STT3183) C1{ Fl FL:3 Fl}



static void Test_STT3183()
{
  {
    init_simple_test("STT3183");
    static STT3183 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3183)");
    check_field_offset(lv, fa, 0, "STT3183.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3183");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3183");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3183.fb");
  }
}
static Arrange_To_Call_Me vSTT3183(Test_STT3183, "STT3183", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3193  {
  long fa;
  unsigned short bf:8;
  long fb;
};
//SIG(1 STT3193) C1{ Fl Fs:8 Fl}



static void Test_STT3193()
{
  {
    init_simple_test("STT3193");
    static STT3193 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3193)");
    check_field_offset(lv, fa, 0, "STT3193.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3193");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3193");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3193.fb");
  }
}
static Arrange_To_Call_Me vSTT3193(Test_STT3193, "STT3193", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3203  {
  long fa;
  unsigned int bf:8;
  long fb;
};
//SIG(1 STT3203) C1{ Fl Fi:8 Fl}



static void Test_STT3203()
{
  {
    init_simple_test("STT3203");
    static STT3203 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3203)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3203)");
    check_field_offset(lv, fa, 0, "STT3203.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3203");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3203");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3203.fb");
  }
}
static Arrange_To_Call_Me vSTT3203(Test_STT3203, "STT3203", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3213  {
  long fa;
  __tsu64 bf:8;
  long fb;
};
//SIG(1 STT3213) C1{ Fl FL:8 Fl}



static void Test_STT3213()
{
  {
    init_simple_test("STT3213");
    static STT3213 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3213)");
    check_field_offset(lv, fa, 0, "STT3213.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3213");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3213");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3213.fb");
  }
}
static Arrange_To_Call_Me vSTT3213(Test_STT3213, "STT3213", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3223  {
  long fa;
  unsigned int bf:18;
  long fb;
};
//SIG(1 STT3223) C1{ Fl Fi:18 Fl}



static void Test_STT3223()
{
  {
    init_simple_test("STT3223");
    static STT3223 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3223)");
    check_field_offset(lv, fa, 0, "STT3223.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3223");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3223");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3223.fb");
  }
}
static Arrange_To_Call_Me vSTT3223(Test_STT3223, "STT3223", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3233  {
  long fa;
  __tsu64 bf:18;
  long fb;
};
//SIG(1 STT3233) C1{ Fl FL:18 Fl}



static void Test_STT3233()
{
  {
    init_simple_test("STT3233");
    static STT3233 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3233)");
    check_field_offset(lv, fa, 0, "STT3233.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3233");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3233");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3233.fb");
  }
}
static Arrange_To_Call_Me vSTT3233(Test_STT3233, "STT3233", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3243  {
  long fa;
  __tsu64 bf:48;
  long fb;
};
//SIG(1 STT3243) C1{ Fl FL:48 Fl}



static void Test_STT3243()
{
  {
    init_simple_test("STT3243");
    static STT3243 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3243)");
    check_field_offset(lv, fa, 0, "STT3243.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3243");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3243");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3243.fb");
  }
}
static Arrange_To_Call_Me vSTT3243(Test_STT3243, "STT3243", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT314  {
  long fa;
  unsigned char  :0;
  __tsi64 fb;
};
//SIG(1 STT314) C1{ Fl Fc:0 FL}



static void Test_STT314()
{
  {
    init_simple_test("STT314");
    static STT314 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT314)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT314)");
    check_field_offset(lv, fa, 0, "STT314.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT314.fb");
  }
}
static Arrange_To_Call_Me vSTT314(Test_STT314, "STT314", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT324  {
  long fa;
  unsigned short  :0;
  __tsi64 fb;
};
//SIG(1 STT324) C1{ Fl Fs:0 FL}



static void Test_STT324()
{
  {
    init_simple_test("STT324");
    static STT324 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT324)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT324)");
    check_field_offset(lv, fa, 0, "STT324.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT324.fb");
  }
}
static Arrange_To_Call_Me vSTT324(Test_STT324, "STT324", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT334  {
  long fa;
  unsigned int  :0;
  __tsi64 fb;
};
//SIG(1 STT334) C1{ Fl Fi:0 FL}



static void Test_STT334()
{
  {
    init_simple_test("STT334");
    static STT334 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT334)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT334)");
    check_field_offset(lv, fa, 0, "STT334.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT334.fb");
  }
}
static Arrange_To_Call_Me vSTT334(Test_STT334, "STT334", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT344  {
  long fa;
  __tsu64  :0;
  __tsi64 fb;
};
//SIG(1 STT344) C1{ Fl FL:0 FL}



static void Test_STT344()
{
  {
    init_simple_test("STT344");
    static STT344 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT344)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT344)");
    check_field_offset(lv, fa, 0, "STT344.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT344.fb");
  }
}
static Arrange_To_Call_Me vSTT344(Test_STT344, "STT344", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT354  {
  long fa;
  unsigned char  :3;
  __tsi64 fb;
};
//SIG(1 STT354) C1{ Fl Fc:3 FL}



static void Test_STT354()
{
  {
    init_simple_test("STT354");
    static STT354 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT354)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT354)");
    check_field_offset(lv, fa, 0, "STT354.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT354.fb");
  }
}
static Arrange_To_Call_Me vSTT354(Test_STT354, "STT354", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT364  {
  long fa;
  unsigned short  :3;
  __tsi64 fb;
};
//SIG(1 STT364) C1{ Fl Fs:3 FL}



static void Test_STT364()
{
  {
    init_simple_test("STT364");
    static STT364 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT364)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT364)");
    check_field_offset(lv, fa, 0, "STT364.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT364.fb");
  }
}
static Arrange_To_Call_Me vSTT364(Test_STT364, "STT364", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT374  {
  long fa;
  unsigned int  :3;
  __tsi64 fb;
};
//SIG(1 STT374) C1{ Fl Fi:3 FL}



static void Test_STT374()
{
  {
    init_simple_test("STT374");
    static STT374 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT374)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT374)");
    check_field_offset(lv, fa, 0, "STT374.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT374.fb");
  }
}
static Arrange_To_Call_Me vSTT374(Test_STT374, "STT374", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT384  {
  long fa;
  __tsu64  :3;
  __tsi64 fb;
};
//SIG(1 STT384) C1{ Fl FL:3 FL}



static void Test_STT384()
{
  {
    init_simple_test("STT384");
    static STT384 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT384)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT384)");
    check_field_offset(lv, fa, 0, "STT384.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT384.fb");
  }
}
static Arrange_To_Call_Me vSTT384(Test_STT384, "STT384", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT394  {
  long fa;
  unsigned short  :8;
  __tsi64 fb;
};
//SIG(1 STT394) C1{ Fl Fs:8 FL}



static void Test_STT394()
{
  {
    init_simple_test("STT394");
    static STT394 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT394)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT394)");
    check_field_offset(lv, fa, 0, "STT394.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT394.fb");
  }
}
static Arrange_To_Call_Me vSTT394(Test_STT394, "STT394", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3104  {
  long fa;
  unsigned int  :8;
  __tsi64 fb;
};
//SIG(1 STT3104) C1{ Fl Fi:8 FL}



static void Test_STT3104()
{
  {
    init_simple_test("STT3104");
    static STT3104 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3104)");
    check_field_offset(lv, fa, 0, "STT3104.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3104.fb");
  }
}
static Arrange_To_Call_Me vSTT3104(Test_STT3104, "STT3104", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3114  {
  long fa;
  __tsu64  :8;
  __tsi64 fb;
};
//SIG(1 STT3114) C1{ Fl FL:8 FL}



static void Test_STT3114()
{
  {
    init_simple_test("STT3114");
    static STT3114 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3114)");
    check_field_offset(lv, fa, 0, "STT3114.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3114.fb");
  }
}
static Arrange_To_Call_Me vSTT3114(Test_STT3114, "STT3114", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3124  {
  long fa;
  unsigned int  :18;
  __tsi64 fb;
};
//SIG(1 STT3124) C1{ Fl Fi:18 FL}



static void Test_STT3124()
{
  {
    init_simple_test("STT3124");
    static STT3124 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3124)");
    check_field_offset(lv, fa, 0, "STT3124.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3124.fb");
  }
}
static Arrange_To_Call_Me vSTT3124(Test_STT3124, "STT3124", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3134  {
  long fa;
  __tsu64  :18;
  __tsi64 fb;
};
//SIG(1 STT3134) C1{ Fl FL:18 FL}



static void Test_STT3134()
{
  {
    init_simple_test("STT3134");
    static STT3134 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3134)");
    check_field_offset(lv, fa, 0, "STT3134.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3134.fb");
  }
}
static Arrange_To_Call_Me vSTT3134(Test_STT3134, "STT3134", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3144  {
  long fa;
  __tsu64  :48;
  __tsi64 fb;
};
//SIG(1 STT3144) C1{ Fl FL:48 FL}



static void Test_STT3144()
{
  {
    init_simple_test("STT3144");
    static STT3144 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT3144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3144)");
    check_field_offset(lv, fa, 0, "STT3144.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3144.fb");
  }
}
static Arrange_To_Call_Me vSTT3144(Test_STT3144, "STT3144", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3154  {
  long fa;
  unsigned char bf:3;
  __tsi64 fb;
};
//SIG(1 STT3154) C1{ Fl Fc:3 FL}



static void Test_STT3154()
{
  {
    init_simple_test("STT3154");
    static STT3154 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3154)");
    check_field_offset(lv, fa, 0, "STT3154.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3154");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3154");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3154.fb");
  }
}
static Arrange_To_Call_Me vSTT3154(Test_STT3154, "STT3154", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3164  {
  long fa;
  unsigned short bf:3;
  __tsi64 fb;
};
//SIG(1 STT3164) C1{ Fl Fs:3 FL}



static void Test_STT3164()
{
  {
    init_simple_test("STT3164");
    static STT3164 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3164)");
    check_field_offset(lv, fa, 0, "STT3164.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3164");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3164");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3164.fb");
  }
}
static Arrange_To_Call_Me vSTT3164(Test_STT3164, "STT3164", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3174  {
  long fa;
  unsigned int bf:3;
  __tsi64 fb;
};
//SIG(1 STT3174) C1{ Fl Fi:3 FL}



static void Test_STT3174()
{
  {
    init_simple_test("STT3174");
    static STT3174 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3174)");
    check_field_offset(lv, fa, 0, "STT3174.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3174");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3174");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3174.fb");
  }
}
static Arrange_To_Call_Me vSTT3174(Test_STT3174, "STT3174", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3184  {
  long fa;
  __tsu64 bf:3;
  __tsi64 fb;
};
//SIG(1 STT3184) C1{ Fl FL:3 FL}



static void Test_STT3184()
{
  {
    init_simple_test("STT3184");
    static STT3184 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3184)");
    check_field_offset(lv, fa, 0, "STT3184.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3184");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3184");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3184.fb");
  }
}
static Arrange_To_Call_Me vSTT3184(Test_STT3184, "STT3184", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3194  {
  long fa;
  unsigned short bf:8;
  __tsi64 fb;
};
//SIG(1 STT3194) C1{ Fl Fs:8 FL}



static void Test_STT3194()
{
  {
    init_simple_test("STT3194");
    static STT3194 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3194)");
    check_field_offset(lv, fa, 0, "STT3194.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3194");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3194");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3194.fb");
  }
}
static Arrange_To_Call_Me vSTT3194(Test_STT3194, "STT3194", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3204  {
  long fa;
  unsigned int bf:8;
  __tsi64 fb;
};
//SIG(1 STT3204) C1{ Fl Fi:8 FL}



static void Test_STT3204()
{
  {
    init_simple_test("STT3204");
    static STT3204 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3204)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3204)");
    check_field_offset(lv, fa, 0, "STT3204.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3204");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3204");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3204.fb");
  }
}
static Arrange_To_Call_Me vSTT3204(Test_STT3204, "STT3204", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3214  {
  long fa;
  __tsu64 bf:8;
  __tsi64 fb;
};
//SIG(1 STT3214) C1{ Fl FL:8 FL}



static void Test_STT3214()
{
  {
    init_simple_test("STT3214");
    static STT3214 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3214)");
    check_field_offset(lv, fa, 0, "STT3214.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3214");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3214");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3214.fb");
  }
}
static Arrange_To_Call_Me vSTT3214(Test_STT3214, "STT3214", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3224  {
  long fa;
  unsigned int bf:18;
  __tsi64 fb;
};
//SIG(1 STT3224) C1{ Fl Fi:18 FL}



static void Test_STT3224()
{
  {
    init_simple_test("STT3224");
    static STT3224 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3224)");
    check_field_offset(lv, fa, 0, "STT3224.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3224");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3224");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3224.fb");
  }
}
static Arrange_To_Call_Me vSTT3224(Test_STT3224, "STT3224", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3234  {
  long fa;
  __tsu64 bf:18;
  __tsi64 fb;
};
//SIG(1 STT3234) C1{ Fl FL:18 FL}



static void Test_STT3234()
{
  {
    init_simple_test("STT3234");
    static STT3234 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3234)");
    check_field_offset(lv, fa, 0, "STT3234.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3234");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3234");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3234.fb");
  }
}
static Arrange_To_Call_Me vSTT3234(Test_STT3234, "STT3234", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3244  {
  long fa;
  __tsu64 bf:48;
  __tsi64 fb;
};
//SIG(1 STT3244) C1{ Fl FL:48 FL}



static void Test_STT3244()
{
  {
    init_simple_test("STT3244");
    static STT3244 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT3244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3244)");
    check_field_offset(lv, fa, 0, "STT3244.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3244");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3244");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3244.fb");
  }
}
static Arrange_To_Call_Me vSTT3244(Test_STT3244, "STT3244", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT315  {
  long fa;
  unsigned char  :0;
  void *fb;
};
//SIG(1 STT315) C1{ Fl Fc:0 Fp}



static void Test_STT315()
{
  {
    init_simple_test("STT315");
    static STT315 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT315)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT315)");
    check_field_offset(lv, fa, 0, "STT315.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT315.fb");
  }
}
static Arrange_To_Call_Me vSTT315(Test_STT315, "STT315", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT325  {
  long fa;
  unsigned short  :0;
  void *fb;
};
//SIG(1 STT325) C1{ Fl Fs:0 Fp}



static void Test_STT325()
{
  {
    init_simple_test("STT325");
    static STT325 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT325)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT325)");
    check_field_offset(lv, fa, 0, "STT325.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT325.fb");
  }
}
static Arrange_To_Call_Me vSTT325(Test_STT325, "STT325", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT335  {
  long fa;
  unsigned int  :0;
  void *fb;
};
//SIG(1 STT335) C1{ Fl Fi:0 Fp}



static void Test_STT335()
{
  {
    init_simple_test("STT335");
    static STT335 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT335)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT335)");
    check_field_offset(lv, fa, 0, "STT335.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT335.fb");
  }
}
static Arrange_To_Call_Me vSTT335(Test_STT335, "STT335", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT345  {
  long fa;
  __tsu64  :0;
  void *fb;
};
//SIG(1 STT345) C1{ Fl FL:0 Fp}



static void Test_STT345()
{
  {
    init_simple_test("STT345");
    static STT345 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT345)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT345)");
    check_field_offset(lv, fa, 0, "STT345.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT345.fb");
  }
}
static Arrange_To_Call_Me vSTT345(Test_STT345, "STT345", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT355  {
  long fa;
  unsigned char  :3;
  void *fb;
};
//SIG(1 STT355) C1{ Fl Fc:3 Fp}



static void Test_STT355()
{
  {
    init_simple_test("STT355");
    static STT355 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT355)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT355)");
    check_field_offset(lv, fa, 0, "STT355.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT355.fb");
  }
}
static Arrange_To_Call_Me vSTT355(Test_STT355, "STT355", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT365  {
  long fa;
  unsigned short  :3;
  void *fb;
};
//SIG(1 STT365) C1{ Fl Fs:3 Fp}



static void Test_STT365()
{
  {
    init_simple_test("STT365");
    static STT365 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT365)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT365)");
    check_field_offset(lv, fa, 0, "STT365.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT365.fb");
  }
}
static Arrange_To_Call_Me vSTT365(Test_STT365, "STT365", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT375  {
  long fa;
  unsigned int  :3;
  void *fb;
};
//SIG(1 STT375) C1{ Fl Fi:3 Fp}



static void Test_STT375()
{
  {
    init_simple_test("STT375");
    static STT375 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT375)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT375)");
    check_field_offset(lv, fa, 0, "STT375.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT375.fb");
  }
}
static Arrange_To_Call_Me vSTT375(Test_STT375, "STT375", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT385  {
  long fa;
  __tsu64  :3;
  void *fb;
};
//SIG(1 STT385) C1{ Fl FL:3 Fp}



static void Test_STT385()
{
  {
    init_simple_test("STT385");
    static STT385 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT385)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT385)");
    check_field_offset(lv, fa, 0, "STT385.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT385.fb");
  }
}
static Arrange_To_Call_Me vSTT385(Test_STT385, "STT385", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT395  {
  long fa;
  unsigned short  :8;
  void *fb;
};
//SIG(1 STT395) C1{ Fl Fs:8 Fp}



static void Test_STT395()
{
  {
    init_simple_test("STT395");
    static STT395 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT395)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT395)");
    check_field_offset(lv, fa, 0, "STT395.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT395.fb");
  }
}
static Arrange_To_Call_Me vSTT395(Test_STT395, "STT395", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3105  {
  long fa;
  unsigned int  :8;
  void *fb;
};
//SIG(1 STT3105) C1{ Fl Fi:8 Fp}



static void Test_STT3105()
{
  {
    init_simple_test("STT3105");
    static STT3105 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3105)");
    check_field_offset(lv, fa, 0, "STT3105.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3105.fb");
  }
}
static Arrange_To_Call_Me vSTT3105(Test_STT3105, "STT3105", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3115  {
  long fa;
  __tsu64  :8;
  void *fb;
};
//SIG(1 STT3115) C1{ Fl FL:8 Fp}



static void Test_STT3115()
{
  {
    init_simple_test("STT3115");
    static STT3115 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3115)");
    check_field_offset(lv, fa, 0, "STT3115.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3115.fb");
  }
}
static Arrange_To_Call_Me vSTT3115(Test_STT3115, "STT3115", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3125  {
  long fa;
  unsigned int  :18;
  void *fb;
};
//SIG(1 STT3125) C1{ Fl Fi:18 Fp}



static void Test_STT3125()
{
  {
    init_simple_test("STT3125");
    static STT3125 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3125)");
    check_field_offset(lv, fa, 0, "STT3125.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3125.fb");
  }
}
static Arrange_To_Call_Me vSTT3125(Test_STT3125, "STT3125", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3135  {
  long fa;
  __tsu64  :18;
  void *fb;
};
//SIG(1 STT3135) C1{ Fl FL:18 Fp}



static void Test_STT3135()
{
  {
    init_simple_test("STT3135");
    static STT3135 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3135)");
    check_field_offset(lv, fa, 0, "STT3135.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3135.fb");
  }
}
static Arrange_To_Call_Me vSTT3135(Test_STT3135, "STT3135", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3145  {
  long fa;
  __tsu64  :48;
  void *fb;
};
//SIG(1 STT3145) C1{ Fl FL:48 Fp}



static void Test_STT3145()
{
  {
    init_simple_test("STT3145");
    static STT3145 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3145)");
    check_field_offset(lv, fa, 0, "STT3145.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3145.fb");
  }
}
static Arrange_To_Call_Me vSTT3145(Test_STT3145, "STT3145", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3155  {
  long fa;
  unsigned char bf:3;
  void *fb;
};
//SIG(1 STT3155) C1{ Fl Fc:3 Fp}



static void Test_STT3155()
{
  {
    init_simple_test("STT3155");
    static STT3155 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3155)");
    check_field_offset(lv, fa, 0, "STT3155.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3155");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3155");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3155.fb");
  }
}
static Arrange_To_Call_Me vSTT3155(Test_STT3155, "STT3155", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3165  {
  long fa;
  unsigned short bf:3;
  void *fb;
};
//SIG(1 STT3165) C1{ Fl Fs:3 Fp}



static void Test_STT3165()
{
  {
    init_simple_test("STT3165");
    static STT3165 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3165)");
    check_field_offset(lv, fa, 0, "STT3165.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3165");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3165");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3165.fb");
  }
}
static Arrange_To_Call_Me vSTT3165(Test_STT3165, "STT3165", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3175  {
  long fa;
  unsigned int bf:3;
  void *fb;
};
//SIG(1 STT3175) C1{ Fl Fi:3 Fp}



static void Test_STT3175()
{
  {
    init_simple_test("STT3175");
    static STT3175 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3175)");
    check_field_offset(lv, fa, 0, "STT3175.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3175");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3175");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3175.fb");
  }
}
static Arrange_To_Call_Me vSTT3175(Test_STT3175, "STT3175", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3185  {
  long fa;
  __tsu64 bf:3;
  void *fb;
};
//SIG(1 STT3185) C1{ Fl FL:3 Fp}



static void Test_STT3185()
{
  {
    init_simple_test("STT3185");
    static STT3185 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3185)");
    check_field_offset(lv, fa, 0, "STT3185.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3185");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3185");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3185.fb");
  }
}
static Arrange_To_Call_Me vSTT3185(Test_STT3185, "STT3185", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3195  {
  long fa;
  unsigned short bf:8;
  void *fb;
};
//SIG(1 STT3195) C1{ Fl Fs:8 Fp}



static void Test_STT3195()
{
  {
    init_simple_test("STT3195");
    static STT3195 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3195)");
    check_field_offset(lv, fa, 0, "STT3195.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3195");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3195");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3195.fb");
  }
}
static Arrange_To_Call_Me vSTT3195(Test_STT3195, "STT3195", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3205  {
  long fa;
  unsigned int bf:8;
  void *fb;
};
//SIG(1 STT3205) C1{ Fl Fi:8 Fp}



static void Test_STT3205()
{
  {
    init_simple_test("STT3205");
    static STT3205 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3205)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3205)");
    check_field_offset(lv, fa, 0, "STT3205.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3205");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3205");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3205.fb");
  }
}
static Arrange_To_Call_Me vSTT3205(Test_STT3205, "STT3205", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3215  {
  long fa;
  __tsu64 bf:8;
  void *fb;
};
//SIG(1 STT3215) C1{ Fl FL:8 Fp}



static void Test_STT3215()
{
  {
    init_simple_test("STT3215");
    static STT3215 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3215)");
    check_field_offset(lv, fa, 0, "STT3215.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3215");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3215");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3215.fb");
  }
}
static Arrange_To_Call_Me vSTT3215(Test_STT3215, "STT3215", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3225  {
  long fa;
  unsigned int bf:18;
  void *fb;
};
//SIG(1 STT3225) C1{ Fl Fi:18 Fp}



static void Test_STT3225()
{
  {
    init_simple_test("STT3225");
    static STT3225 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3225)");
    check_field_offset(lv, fa, 0, "STT3225.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3225");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3225");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3225.fb");
  }
}
static Arrange_To_Call_Me vSTT3225(Test_STT3225, "STT3225", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3235  {
  long fa;
  __tsu64 bf:18;
  void *fb;
};
//SIG(1 STT3235) C1{ Fl FL:18 Fp}



static void Test_STT3235()
{
  {
    init_simple_test("STT3235");
    static STT3235 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT3235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3235)");
    check_field_offset(lv, fa, 0, "STT3235.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3235");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3235");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3235.fb");
  }
}
static Arrange_To_Call_Me vSTT3235(Test_STT3235, "STT3235", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3245  {
  long fa;
  __tsu64 bf:48;
  void *fb;
};
//SIG(1 STT3245) C1{ Fl FL:48 Fp}



static void Test_STT3245()
{
  {
    init_simple_test("STT3245");
    static STT3245 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3245)");
    check_field_offset(lv, fa, 0, "STT3245.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3245");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3245");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3245.fb");
  }
}
static Arrange_To_Call_Me vSTT3245(Test_STT3245, "STT3245", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT316  {
  long fa;
  unsigned char  :0;
  float fb;
};
//SIG(1 STT316) C1{ Fl Fc:0 Fi}



static void Test_STT316()
{
  {
    init_simple_test("STT316");
    static STT316 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT316)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT316)");
    check_field_offset(lv, fa, 0, "STT316.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT316.fb");
  }
}
static Arrange_To_Call_Me vSTT316(Test_STT316, "STT316", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT326  {
  long fa;
  unsigned short  :0;
  float fb;
};
//SIG(1 STT326) C1{ Fl Fs:0 Fi}



static void Test_STT326()
{
  {
    init_simple_test("STT326");
    static STT326 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT326)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT326)");
    check_field_offset(lv, fa, 0, "STT326.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT326.fb");
  }
}
static Arrange_To_Call_Me vSTT326(Test_STT326, "STT326", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT336  {
  long fa;
  unsigned int  :0;
  float fb;
};
//SIG(1 STT336) C1{ Fl Fi:0 Fi}



static void Test_STT336()
{
  {
    init_simple_test("STT336");
    static STT336 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT336)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT336)");
    check_field_offset(lv, fa, 0, "STT336.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT336.fb");
  }
}
static Arrange_To_Call_Me vSTT336(Test_STT336, "STT336", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT346  {
  long fa;
  __tsu64  :0;
  float fb;
};
//SIG(1 STT346) C1{ Fl FL:0 Fi}



static void Test_STT346()
{
  {
    init_simple_test("STT346");
    static STT346 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT346)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT346)");
    check_field_offset(lv, fa, 0, "STT346.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT346.fb");
  }
}
static Arrange_To_Call_Me vSTT346(Test_STT346, "STT346", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT356  {
  long fa;
  unsigned char  :3;
  float fb;
};
//SIG(1 STT356) C1{ Fl Fc:3 Fi}



static void Test_STT356()
{
  {
    init_simple_test("STT356");
    static STT356 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT356)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT356)");
    check_field_offset(lv, fa, 0, "STT356.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT356.fb");
  }
}
static Arrange_To_Call_Me vSTT356(Test_STT356, "STT356", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT366  {
  long fa;
  unsigned short  :3;
  float fb;
};
//SIG(1 STT366) C1{ Fl Fs:3 Fi}



static void Test_STT366()
{
  {
    init_simple_test("STT366");
    static STT366 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT366)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT366)");
    check_field_offset(lv, fa, 0, "STT366.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT366.fb");
  }
}
static Arrange_To_Call_Me vSTT366(Test_STT366, "STT366", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT376  {
  long fa;
  unsigned int  :3;
  float fb;
};
//SIG(1 STT376) C1{ Fl Fi:3 Fi}



static void Test_STT376()
{
  {
    init_simple_test("STT376");
    static STT376 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT376)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT376)");
    check_field_offset(lv, fa, 0, "STT376.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT376.fb");
  }
}
static Arrange_To_Call_Me vSTT376(Test_STT376, "STT376", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT386  {
  long fa;
  __tsu64  :3;
  float fb;
};
//SIG(1 STT386) C1{ Fl FL:3 Fi}



static void Test_STT386()
{
  {
    init_simple_test("STT386");
    static STT386 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT386)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT386)");
    check_field_offset(lv, fa, 0, "STT386.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT386.fb");
  }
}
static Arrange_To_Call_Me vSTT386(Test_STT386, "STT386", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT396  {
  long fa;
  unsigned short  :8;
  float fb;
};
//SIG(1 STT396) C1{ Fl Fs:8 Fi}



static void Test_STT396()
{
  {
    init_simple_test("STT396");
    static STT396 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT396)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT396)");
    check_field_offset(lv, fa, 0, "STT396.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT396.fb");
  }
}
static Arrange_To_Call_Me vSTT396(Test_STT396, "STT396", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3106  {
  long fa;
  unsigned int  :8;
  float fb;
};
//SIG(1 STT3106) C1{ Fl Fi:8 Fi}



static void Test_STT3106()
{
  {
    init_simple_test("STT3106");
    static STT3106 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3106)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3106)");
    check_field_offset(lv, fa, 0, "STT3106.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3106.fb");
  }
}
static Arrange_To_Call_Me vSTT3106(Test_STT3106, "STT3106", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3116  {
  long fa;
  __tsu64  :8;
  float fb;
};
//SIG(1 STT3116) C1{ Fl FL:8 Fi}



static void Test_STT3116()
{
  {
    init_simple_test("STT3116");
    static STT3116 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3116)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3116)");
    check_field_offset(lv, fa, 0, "STT3116.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3116.fb");
  }
}
static Arrange_To_Call_Me vSTT3116(Test_STT3116, "STT3116", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3126  {
  long fa;
  unsigned int  :18;
  float fb;
};
//SIG(1 STT3126) C1{ Fl Fi:18 Fi}



static void Test_STT3126()
{
  {
    init_simple_test("STT3126");
    static STT3126 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3126)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3126)");
    check_field_offset(lv, fa, 0, "STT3126.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3126.fb");
  }
}
static Arrange_To_Call_Me vSTT3126(Test_STT3126, "STT3126", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3136  {
  long fa;
  __tsu64  :18;
  float fb;
};
//SIG(1 STT3136) C1{ Fl FL:18 Fi}



static void Test_STT3136()
{
  {
    init_simple_test("STT3136");
    static STT3136 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3136)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3136)");
    check_field_offset(lv, fa, 0, "STT3136.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3136.fb");
  }
}
static Arrange_To_Call_Me vSTT3136(Test_STT3136, "STT3136", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3146  {
  long fa;
  __tsu64  :48;
  float fb;
};
//SIG(1 STT3146) C1{ Fl FL:48 Fi}



static void Test_STT3146()
{
  {
    init_simple_test("STT3146");
    static STT3146 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3146)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3146)");
    check_field_offset(lv, fa, 0, "STT3146.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3146.fb");
  }
}
static Arrange_To_Call_Me vSTT3146(Test_STT3146, "STT3146", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3156  {
  long fa;
  unsigned char bf:3;
  float fb;
};
//SIG(1 STT3156) C1{ Fl Fc:3 Fi}



static void Test_STT3156()
{
  {
    init_simple_test("STT3156");
    static STT3156 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3156)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3156)");
    check_field_offset(lv, fa, 0, "STT3156.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3156");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3156");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3156.fb");
  }
}
static Arrange_To_Call_Me vSTT3156(Test_STT3156, "STT3156", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3166  {
  long fa;
  unsigned short bf:3;
  float fb;
};
//SIG(1 STT3166) C1{ Fl Fs:3 Fi}



static void Test_STT3166()
{
  {
    init_simple_test("STT3166");
    static STT3166 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3166)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3166)");
    check_field_offset(lv, fa, 0, "STT3166.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3166");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3166");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3166.fb");
  }
}
static Arrange_To_Call_Me vSTT3166(Test_STT3166, "STT3166", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3176  {
  long fa;
  unsigned int bf:3;
  float fb;
};
//SIG(1 STT3176) C1{ Fl Fi:3 Fi}



static void Test_STT3176()
{
  {
    init_simple_test("STT3176");
    static STT3176 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3176)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3176)");
    check_field_offset(lv, fa, 0, "STT3176.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3176");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3176");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3176.fb");
  }
}
static Arrange_To_Call_Me vSTT3176(Test_STT3176, "STT3176", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3186  {
  long fa;
  __tsu64 bf:3;
  float fb;
};
//SIG(1 STT3186) C1{ Fl FL:3 Fi}



static void Test_STT3186()
{
  {
    init_simple_test("STT3186");
    static STT3186 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3186)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3186)");
    check_field_offset(lv, fa, 0, "STT3186.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3186");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3186");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3186.fb");
  }
}
static Arrange_To_Call_Me vSTT3186(Test_STT3186, "STT3186", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3196  {
  long fa;
  unsigned short bf:8;
  float fb;
};
//SIG(1 STT3196) C1{ Fl Fs:8 Fi}



static void Test_STT3196()
{
  {
    init_simple_test("STT3196");
    static STT3196 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3196)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3196)");
    check_field_offset(lv, fa, 0, "STT3196.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3196");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3196");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3196.fb");
  }
}
static Arrange_To_Call_Me vSTT3196(Test_STT3196, "STT3196", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3206  {
  long fa;
  unsigned int bf:8;
  float fb;
};
//SIG(1 STT3206) C1{ Fl Fi:8 Fi}



static void Test_STT3206()
{
  {
    init_simple_test("STT3206");
    static STT3206 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3206)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3206)");
    check_field_offset(lv, fa, 0, "STT3206.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3206");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3206");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3206.fb");
  }
}
static Arrange_To_Call_Me vSTT3206(Test_STT3206, "STT3206", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3216  {
  long fa;
  __tsu64 bf:8;
  float fb;
};
//SIG(1 STT3216) C1{ Fl FL:8 Fi}



static void Test_STT3216()
{
  {
    init_simple_test("STT3216");
    static STT3216 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3216)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3216)");
    check_field_offset(lv, fa, 0, "STT3216.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3216");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3216");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3216.fb");
  }
}
static Arrange_To_Call_Me vSTT3216(Test_STT3216, "STT3216", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3226  {
  long fa;
  unsigned int bf:18;
  float fb;
};
//SIG(1 STT3226) C1{ Fl Fi:18 Fi}



static void Test_STT3226()
{
  {
    init_simple_test("STT3226");
    static STT3226 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3226)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3226)");
    check_field_offset(lv, fa, 0, "STT3226.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3226");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3226");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3226.fb");
  }
}
static Arrange_To_Call_Me vSTT3226(Test_STT3226, "STT3226", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3236  {
  long fa;
  __tsu64 bf:18;
  float fb;
};
//SIG(1 STT3236) C1{ Fl FL:18 Fi}



static void Test_STT3236()
{
  {
    init_simple_test("STT3236");
    static STT3236 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3236)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3236)");
    check_field_offset(lv, fa, 0, "STT3236.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3236");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3236");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT3236.fb");
  }
}
static Arrange_To_Call_Me vSTT3236(Test_STT3236, "STT3236", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3246  {
  long fa;
  __tsu64 bf:48;
  float fb;
};
//SIG(1 STT3246) C1{ Fl FL:48 Fi}



static void Test_STT3246()
{
  {
    init_simple_test("STT3246");
    static STT3246 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3246)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3246)");
    check_field_offset(lv, fa, 0, "STT3246.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3246");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3246");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3246.fb");
  }
}
static Arrange_To_Call_Me vSTT3246(Test_STT3246, "STT3246", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT317  {
  long fa;
  unsigned char  :0;
  double fb;
};
//SIG(1 STT317) C1{ Fl Fc:0 FL}



static void Test_STT317()
{
  {
    init_simple_test("STT317");
    static STT317 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT317)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT317)");
    check_field_offset(lv, fa, 0, "STT317.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT317.fb");
  }
}
static Arrange_To_Call_Me vSTT317(Test_STT317, "STT317", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT327  {
  long fa;
  unsigned short  :0;
  double fb;
};
//SIG(1 STT327) C1{ Fl Fs:0 FL}



static void Test_STT327()
{
  {
    init_simple_test("STT327");
    static STT327 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT327)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT327)");
    check_field_offset(lv, fa, 0, "STT327.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT327.fb");
  }
}
static Arrange_To_Call_Me vSTT327(Test_STT327, "STT327", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT337  {
  long fa;
  unsigned int  :0;
  double fb;
};
//SIG(1 STT337) C1{ Fl Fi:0 FL}



static void Test_STT337()
{
  {
    init_simple_test("STT337");
    static STT337 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT337)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT337)");
    check_field_offset(lv, fa, 0, "STT337.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT337.fb");
  }
}
static Arrange_To_Call_Me vSTT337(Test_STT337, "STT337", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT347  {
  long fa;
  __tsu64  :0;
  double fb;
};
//SIG(1 STT347) C1{ Fl FL:0 FL}



static void Test_STT347()
{
  {
    init_simple_test("STT347");
    static STT347 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT347)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT347)");
    check_field_offset(lv, fa, 0, "STT347.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT347.fb");
  }
}
static Arrange_To_Call_Me vSTT347(Test_STT347, "STT347", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT357  {
  long fa;
  unsigned char  :3;
  double fb;
};
//SIG(1 STT357) C1{ Fl Fc:3 FL}



static void Test_STT357()
{
  {
    init_simple_test("STT357");
    static STT357 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT357)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT357)");
    check_field_offset(lv, fa, 0, "STT357.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT357.fb");
  }
}
static Arrange_To_Call_Me vSTT357(Test_STT357, "STT357", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT367  {
  long fa;
  unsigned short  :3;
  double fb;
};
//SIG(1 STT367) C1{ Fl Fs:3 FL}



static void Test_STT367()
{
  {
    init_simple_test("STT367");
    static STT367 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT367)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT367)");
    check_field_offset(lv, fa, 0, "STT367.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT367.fb");
  }
}
static Arrange_To_Call_Me vSTT367(Test_STT367, "STT367", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT377  {
  long fa;
  unsigned int  :3;
  double fb;
};
//SIG(1 STT377) C1{ Fl Fi:3 FL}



static void Test_STT377()
{
  {
    init_simple_test("STT377");
    static STT377 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT377)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT377)");
    check_field_offset(lv, fa, 0, "STT377.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT377.fb");
  }
}
static Arrange_To_Call_Me vSTT377(Test_STT377, "STT377", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT387  {
  long fa;
  __tsu64  :3;
  double fb;
};
//SIG(1 STT387) C1{ Fl FL:3 FL}



static void Test_STT387()
{
  {
    init_simple_test("STT387");
    static STT387 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT387)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT387)");
    check_field_offset(lv, fa, 0, "STT387.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT387.fb");
  }
}
static Arrange_To_Call_Me vSTT387(Test_STT387, "STT387", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT397  {
  long fa;
  unsigned short  :8;
  double fb;
};
//SIG(1 STT397) C1{ Fl Fs:8 FL}



static void Test_STT397()
{
  {
    init_simple_test("STT397");
    static STT397 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT397)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT397)");
    check_field_offset(lv, fa, 0, "STT397.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT397.fb");
  }
}
static Arrange_To_Call_Me vSTT397(Test_STT397, "STT397", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3107  {
  long fa;
  unsigned int  :8;
  double fb;
};
//SIG(1 STT3107) C1{ Fl Fi:8 FL}



static void Test_STT3107()
{
  {
    init_simple_test("STT3107");
    static STT3107 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3107)");
    check_field_offset(lv, fa, 0, "STT3107.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3107.fb");
  }
}
static Arrange_To_Call_Me vSTT3107(Test_STT3107, "STT3107", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3117  {
  long fa;
  __tsu64  :8;
  double fb;
};
//SIG(1 STT3117) C1{ Fl FL:8 FL}



static void Test_STT3117()
{
  {
    init_simple_test("STT3117");
    static STT3117 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3117)");
    check_field_offset(lv, fa, 0, "STT3117.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3117.fb");
  }
}
static Arrange_To_Call_Me vSTT3117(Test_STT3117, "STT3117", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3127  {
  long fa;
  unsigned int  :18;
  double fb;
};
//SIG(1 STT3127) C1{ Fl Fi:18 FL}



static void Test_STT3127()
{
  {
    init_simple_test("STT3127");
    static STT3127 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3127)");
    check_field_offset(lv, fa, 0, "STT3127.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3127.fb");
  }
}
static Arrange_To_Call_Me vSTT3127(Test_STT3127, "STT3127", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3137  {
  long fa;
  __tsu64  :18;
  double fb;
};
//SIG(1 STT3137) C1{ Fl FL:18 FL}



static void Test_STT3137()
{
  {
    init_simple_test("STT3137");
    static STT3137 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3137)");
    check_field_offset(lv, fa, 0, "STT3137.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3137.fb");
  }
}
static Arrange_To_Call_Me vSTT3137(Test_STT3137, "STT3137", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3147  {
  long fa;
  __tsu64  :48;
  double fb;
};
//SIG(1 STT3147) C1{ Fl FL:48 FL}



static void Test_STT3147()
{
  {
    init_simple_test("STT3147");
    static STT3147 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT3147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3147)");
    check_field_offset(lv, fa, 0, "STT3147.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3147.fb");
  }
}
static Arrange_To_Call_Me vSTT3147(Test_STT3147, "STT3147", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3157  {
  long fa;
  unsigned char bf:3;
  double fb;
};
//SIG(1 STT3157) C1{ Fl Fc:3 FL}



static void Test_STT3157()
{
  {
    init_simple_test("STT3157");
    static STT3157 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3157)");
    check_field_offset(lv, fa, 0, "STT3157.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3157");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3157");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3157.fb");
  }
}
static Arrange_To_Call_Me vSTT3157(Test_STT3157, "STT3157", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3167  {
  long fa;
  unsigned short bf:3;
  double fb;
};
//SIG(1 STT3167) C1{ Fl Fs:3 FL}



static void Test_STT3167()
{
  {
    init_simple_test("STT3167");
    static STT3167 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3167)");
    check_field_offset(lv, fa, 0, "STT3167.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3167");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3167");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3167.fb");
  }
}
static Arrange_To_Call_Me vSTT3167(Test_STT3167, "STT3167", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3177  {
  long fa;
  unsigned int bf:3;
  double fb;
};
//SIG(1 STT3177) C1{ Fl Fi:3 FL}



static void Test_STT3177()
{
  {
    init_simple_test("STT3177");
    static STT3177 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3177)");
    check_field_offset(lv, fa, 0, "STT3177.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3177");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3177");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3177.fb");
  }
}
static Arrange_To_Call_Me vSTT3177(Test_STT3177, "STT3177", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3187  {
  long fa;
  __tsu64 bf:3;
  double fb;
};
//SIG(1 STT3187) C1{ Fl FL:3 FL}



static void Test_STT3187()
{
  {
    init_simple_test("STT3187");
    static STT3187 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3187)");
    check_field_offset(lv, fa, 0, "STT3187.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3187");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3187");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3187.fb");
  }
}
static Arrange_To_Call_Me vSTT3187(Test_STT3187, "STT3187", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3197  {
  long fa;
  unsigned short bf:8;
  double fb;
};
//SIG(1 STT3197) C1{ Fl Fs:8 FL}



static void Test_STT3197()
{
  {
    init_simple_test("STT3197");
    static STT3197 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3197)");
    check_field_offset(lv, fa, 0, "STT3197.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3197");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3197");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3197.fb");
  }
}
static Arrange_To_Call_Me vSTT3197(Test_STT3197, "STT3197", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3207  {
  long fa;
  unsigned int bf:8;
  double fb;
};
//SIG(1 STT3207) C1{ Fl Fi:8 FL}



static void Test_STT3207()
{
  {
    init_simple_test("STT3207");
    static STT3207 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3207)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3207)");
    check_field_offset(lv, fa, 0, "STT3207.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3207");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3207");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3207.fb");
  }
}
static Arrange_To_Call_Me vSTT3207(Test_STT3207, "STT3207", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3217  {
  long fa;
  __tsu64 bf:8;
  double fb;
};
//SIG(1 STT3217) C1{ Fl FL:8 FL}



static void Test_STT3217()
{
  {
    init_simple_test("STT3217");
    static STT3217 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3217)");
    check_field_offset(lv, fa, 0, "STT3217.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3217");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3217");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3217.fb");
  }
}
static Arrange_To_Call_Me vSTT3217(Test_STT3217, "STT3217", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3227  {
  long fa;
  unsigned int bf:18;
  double fb;
};
//SIG(1 STT3227) C1{ Fl Fi:18 FL}



static void Test_STT3227()
{
  {
    init_simple_test("STT3227");
    static STT3227 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3227)");
    check_field_offset(lv, fa, 0, "STT3227.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3227");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3227");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3227.fb");
  }
}
static Arrange_To_Call_Me vSTT3227(Test_STT3227, "STT3227", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3237  {
  long fa;
  __tsu64 bf:18;
  double fb;
};
//SIG(1 STT3237) C1{ Fl FL:18 FL}



static void Test_STT3237()
{
  {
    init_simple_test("STT3237");
    static STT3237 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT3237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3237)");
    check_field_offset(lv, fa, 0, "STT3237.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3237");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3237");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3237.fb");
  }
}
static Arrange_To_Call_Me vSTT3237(Test_STT3237, "STT3237", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3247  {
  long fa;
  __tsu64 bf:48;
  double fb;
};
//SIG(1 STT3247) C1{ Fl FL:48 FL}



static void Test_STT3247()
{
  {
    init_simple_test("STT3247");
    static STT3247 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT3247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3247)");
    check_field_offset(lv, fa, 0, "STT3247.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3247");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3247");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3247.fb");
  }
}
static Arrange_To_Call_Me vSTT3247(Test_STT3247, "STT3247", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT318  {
  long fa;
  unsigned char  :0;
  long double fb;
};
//SIG(1 STT318) C1{ Fl Fc:0 FD}



static void Test_STT318()
{
  {
    init_simple_test("STT318");
    static STT318 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT318)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT318)");
    check_field_offset(lv, fa, 0, "STT318.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT318.fb");
  }
}
static Arrange_To_Call_Me vSTT318(Test_STT318, "STT318", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT328  {
  long fa;
  unsigned short  :0;
  long double fb;
};
//SIG(1 STT328) C1{ Fl Fs:0 FD}



static void Test_STT328()
{
  {
    init_simple_test("STT328");
    static STT328 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT328)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT328)");
    check_field_offset(lv, fa, 0, "STT328.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT328.fb");
  }
}
static Arrange_To_Call_Me vSTT328(Test_STT328, "STT328", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT338  {
  long fa;
  unsigned int  :0;
  long double fb;
};
//SIG(1 STT338) C1{ Fl Fi:0 FD}



static void Test_STT338()
{
  {
    init_simple_test("STT338");
    static STT338 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT338)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT338)");
    check_field_offset(lv, fa, 0, "STT338.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT338.fb");
  }
}
static Arrange_To_Call_Me vSTT338(Test_STT338, "STT338", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT348  {
  long fa;
  __tsu64  :0;
  long double fb;
};
//SIG(1 STT348) C1{ Fl FL:0 FD}



static void Test_STT348()
{
  {
    init_simple_test("STT348");
    static STT348 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT348)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT348)");
    check_field_offset(lv, fa, 0, "STT348.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT348.fb");
  }
}
static Arrange_To_Call_Me vSTT348(Test_STT348, "STT348", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT358  {
  long fa;
  unsigned char  :3;
  long double fb;
};
//SIG(1 STT358) C1{ Fl Fc:3 FD}



static void Test_STT358()
{
  {
    init_simple_test("STT358");
    static STT358 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT358)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT358)");
    check_field_offset(lv, fa, 0, "STT358.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT358.fb");
  }
}
static Arrange_To_Call_Me vSTT358(Test_STT358, "STT358", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT368  {
  long fa;
  unsigned short  :3;
  long double fb;
};
//SIG(1 STT368) C1{ Fl Fs:3 FD}



static void Test_STT368()
{
  {
    init_simple_test("STT368");
    static STT368 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT368)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT368)");
    check_field_offset(lv, fa, 0, "STT368.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT368.fb");
  }
}
static Arrange_To_Call_Me vSTT368(Test_STT368, "STT368", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT378  {
  long fa;
  unsigned int  :3;
  long double fb;
};
//SIG(1 STT378) C1{ Fl Fi:3 FD}



static void Test_STT378()
{
  {
    init_simple_test("STT378");
    static STT378 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT378)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT378)");
    check_field_offset(lv, fa, 0, "STT378.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT378.fb");
  }
}
static Arrange_To_Call_Me vSTT378(Test_STT378, "STT378", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT388  {
  long fa;
  __tsu64  :3;
  long double fb;
};
//SIG(1 STT388) C1{ Fl FL:3 FD}



static void Test_STT388()
{
  {
    init_simple_test("STT388");
    static STT388 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT388)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT388)");
    check_field_offset(lv, fa, 0, "STT388.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT388.fb");
  }
}
static Arrange_To_Call_Me vSTT388(Test_STT388, "STT388", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT398  {
  long fa;
  unsigned short  :8;
  long double fb;
};
//SIG(1 STT398) C1{ Fl Fs:8 FD}



static void Test_STT398()
{
  {
    init_simple_test("STT398");
    static STT398 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT398)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT398)");
    check_field_offset(lv, fa, 0, "STT398.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT398.fb");
  }
}
static Arrange_To_Call_Me vSTT398(Test_STT398, "STT398", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3108  {
  long fa;
  unsigned int  :8;
  long double fb;
};
//SIG(1 STT3108) C1{ Fl Fi:8 FD}



static void Test_STT3108()
{
  {
    init_simple_test("STT3108");
    static STT3108 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3108)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3108)");
    check_field_offset(lv, fa, 0, "STT3108.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3108.fb");
  }
}
static Arrange_To_Call_Me vSTT3108(Test_STT3108, "STT3108", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3118  {
  long fa;
  __tsu64  :8;
  long double fb;
};
//SIG(1 STT3118) C1{ Fl FL:8 FD}



static void Test_STT3118()
{
  {
    init_simple_test("STT3118");
    static STT3118 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3118)");
    check_field_offset(lv, fa, 0, "STT3118.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3118.fb");
  }
}
static Arrange_To_Call_Me vSTT3118(Test_STT3118, "STT3118", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3128  {
  long fa;
  unsigned int  :18;
  long double fb;
};
//SIG(1 STT3128) C1{ Fl Fi:18 FD}



static void Test_STT3128()
{
  {
    init_simple_test("STT3128");
    static STT3128 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3128)");
    check_field_offset(lv, fa, 0, "STT3128.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3128.fb");
  }
}
static Arrange_To_Call_Me vSTT3128(Test_STT3128, "STT3128", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3138  {
  long fa;
  __tsu64  :18;
  long double fb;
};
//SIG(1 STT3138) C1{ Fl FL:18 FD}



static void Test_STT3138()
{
  {
    init_simple_test("STT3138");
    static STT3138 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3138)");
    check_field_offset(lv, fa, 0, "STT3138.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3138.fb");
  }
}
static Arrange_To_Call_Me vSTT3138(Test_STT3138, "STT3138", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3148  {
  long fa;
  __tsu64  :48;
  long double fb;
};
//SIG(1 STT3148) C1{ Fl FL:48 FD}



static void Test_STT3148()
{
  {
    init_simple_test("STT3148");
    static STT3148 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT3148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3148)");
    check_field_offset(lv, fa, 0, "STT3148.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3148.fb");
  }
}
static Arrange_To_Call_Me vSTT3148(Test_STT3148, "STT3148", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3158  {
  long fa;
  unsigned char bf:3;
  long double fb;
};
//SIG(1 STT3158) C1{ Fl Fc:3 FD}



static void Test_STT3158()
{
  {
    init_simple_test("STT3158");
    static STT3158 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3158)");
    check_field_offset(lv, fa, 0, "STT3158.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3158");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3158");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3158.fb");
  }
}
static Arrange_To_Call_Me vSTT3158(Test_STT3158, "STT3158", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3168  {
  long fa;
  unsigned short bf:3;
  long double fb;
};
//SIG(1 STT3168) C1{ Fl Fs:3 FD}



static void Test_STT3168()
{
  {
    init_simple_test("STT3168");
    static STT3168 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3168)");
    check_field_offset(lv, fa, 0, "STT3168.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3168");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3168");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3168.fb");
  }
}
static Arrange_To_Call_Me vSTT3168(Test_STT3168, "STT3168", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3178  {
  long fa;
  unsigned int bf:3;
  long double fb;
};
//SIG(1 STT3178) C1{ Fl Fi:3 FD}



static void Test_STT3178()
{
  {
    init_simple_test("STT3178");
    static STT3178 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3178)");
    check_field_offset(lv, fa, 0, "STT3178.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3178");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3178");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3178.fb");
  }
}
static Arrange_To_Call_Me vSTT3178(Test_STT3178, "STT3178", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3188  {
  long fa;
  __tsu64 bf:3;
  long double fb;
};
//SIG(1 STT3188) C1{ Fl FL:3 FD}



static void Test_STT3188()
{
  {
    init_simple_test("STT3188");
    static STT3188 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3188)");
    check_field_offset(lv, fa, 0, "STT3188.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3188");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3188");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3188.fb");
  }
}
static Arrange_To_Call_Me vSTT3188(Test_STT3188, "STT3188", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3198  {
  long fa;
  unsigned short bf:8;
  long double fb;
};
//SIG(1 STT3198) C1{ Fl Fs:8 FD}



static void Test_STT3198()
{
  {
    init_simple_test("STT3198");
    static STT3198 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3198)");
    check_field_offset(lv, fa, 0, "STT3198.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3198");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3198");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3198.fb");
  }
}
static Arrange_To_Call_Me vSTT3198(Test_STT3198, "STT3198", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3208  {
  long fa;
  unsigned int bf:8;
  long double fb;
};
//SIG(1 STT3208) C1{ Fl Fi:8 FD}



static void Test_STT3208()
{
  {
    init_simple_test("STT3208");
    static STT3208 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3208)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3208)");
    check_field_offset(lv, fa, 0, "STT3208.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3208");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3208");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3208.fb");
  }
}
static Arrange_To_Call_Me vSTT3208(Test_STT3208, "STT3208", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3218  {
  long fa;
  __tsu64 bf:8;
  long double fb;
};
//SIG(1 STT3218) C1{ Fl FL:8 FD}



static void Test_STT3218()
{
  {
    init_simple_test("STT3218");
    static STT3218 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3218)");
    check_field_offset(lv, fa, 0, "STT3218.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3218");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3218");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3218.fb");
  }
}
static Arrange_To_Call_Me vSTT3218(Test_STT3218, "STT3218", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3228  {
  long fa;
  unsigned int bf:18;
  long double fb;
};
//SIG(1 STT3228) C1{ Fl Fi:18 FD}



static void Test_STT3228()
{
  {
    init_simple_test("STT3228");
    static STT3228 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3228)");
    check_field_offset(lv, fa, 0, "STT3228.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3228");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3228");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3228.fb");
  }
}
static Arrange_To_Call_Me vSTT3228(Test_STT3228, "STT3228", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3238  {
  long fa;
  __tsu64 bf:18;
  long double fb;
};
//SIG(1 STT3238) C1{ Fl FL:18 FD}



static void Test_STT3238()
{
  {
    init_simple_test("STT3238");
    static STT3238 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT3238)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3238)");
    check_field_offset(lv, fa, 0, "STT3238.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3238");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3238");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT3238.fb");
  }
}
static Arrange_To_Call_Me vSTT3238(Test_STT3238, "STT3238", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3248  {
  long fa;
  __tsu64 bf:48;
  long double fb;
};
//SIG(1 STT3248) C1{ Fl FL:48 FD}



static void Test_STT3248()
{
  {
    init_simple_test("STT3248");
    static STT3248 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT3248)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT3248)");
    check_field_offset(lv, fa, 0, "STT3248.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3248");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3248");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT3248.fb");
  }
}
static Arrange_To_Call_Me vSTT3248(Test_STT3248, "STT3248", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT319  {
  long fa;
  unsigned char  :0;
};
//SIG(1 STT319) C1{ Fl Fc:0}



static void Test_STT319()
{
  {
    init_simple_test("STT319");
    static STT319 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT319)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT319)");
    check_field_offset(lv, fa, 0, "STT319.fa");
  }
}
static Arrange_To_Call_Me vSTT319(Test_STT319, "STT319", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT329  {
  long fa;
  unsigned short  :0;
};
//SIG(1 STT329) C1{ Fl Fs:0}



static void Test_STT329()
{
  {
    init_simple_test("STT329");
    static STT329 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT329)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT329)");
    check_field_offset(lv, fa, 0, "STT329.fa");
  }
}
static Arrange_To_Call_Me vSTT329(Test_STT329, "STT329", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT339  {
  long fa;
  unsigned int  :0;
};
//SIG(1 STT339) C1{ Fl Fi:0}



static void Test_STT339()
{
  {
    init_simple_test("STT339");
    static STT339 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT339)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT339)");
    check_field_offset(lv, fa, 0, "STT339.fa");
  }
}
static Arrange_To_Call_Me vSTT339(Test_STT339, "STT339", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT349  {
  long fa;
  __tsu64  :0;
};
//SIG(1 STT349) C1{ Fl FL:0}



static void Test_STT349()
{
  {
    init_simple_test("STT349");
    static STT349 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT349)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT349)");
    check_field_offset(lv, fa, 0, "STT349.fa");
  }
}
static Arrange_To_Call_Me vSTT349(Test_STT349, "STT349", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT359  {
  long fa;
  unsigned char  :3;
};
//SIG(1 STT359) C1{ Fl Fc:3}



static void Test_STT359()
{
  {
    init_simple_test("STT359");
    static STT359 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT359)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT359)");
    check_field_offset(lv, fa, 0, "STT359.fa");
  }
}
static Arrange_To_Call_Me vSTT359(Test_STT359, "STT359", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT369  {
  long fa;
  unsigned short  :3;
};
//SIG(1 STT369) C1{ Fl Fs:3}



static void Test_STT369()
{
  {
    init_simple_test("STT369");
    static STT369 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT369)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT369)");
    check_field_offset(lv, fa, 0, "STT369.fa");
  }
}
static Arrange_To_Call_Me vSTT369(Test_STT369, "STT369", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT379  {
  long fa;
  unsigned int  :3;
};
//SIG(1 STT379) C1{ Fl Fi:3}



static void Test_STT379()
{
  {
    init_simple_test("STT379");
    static STT379 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT379)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT379)");
    check_field_offset(lv, fa, 0, "STT379.fa");
  }
}
static Arrange_To_Call_Me vSTT379(Test_STT379, "STT379", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT389  {
  long fa;
  __tsu64  :3;
};
//SIG(1 STT389) C1{ Fl FL:3}



static void Test_STT389()
{
  {
    init_simple_test("STT389");
    static STT389 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT389)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT389)");
    check_field_offset(lv, fa, 0, "STT389.fa");
  }
}
static Arrange_To_Call_Me vSTT389(Test_STT389, "STT389", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT399  {
  long fa;
  unsigned short  :8;
};
//SIG(1 STT399) C1{ Fl Fs:8}



static void Test_STT399()
{
  {
    init_simple_test("STT399");
    static STT399 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT399)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT399)");
    check_field_offset(lv, fa, 0, "STT399.fa");
  }
}
static Arrange_To_Call_Me vSTT399(Test_STT399, "STT399", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3109  {
  long fa;
  unsigned int  :8;
};
//SIG(1 STT3109) C1{ Fl Fi:8}



static void Test_STT3109()
{
  {
    init_simple_test("STT3109");
    static STT3109 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3109)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3109)");
    check_field_offset(lv, fa, 0, "STT3109.fa");
  }
}
static Arrange_To_Call_Me vSTT3109(Test_STT3109, "STT3109", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3119  {
  long fa;
  __tsu64  :8;
};
//SIG(1 STT3119) C1{ Fl FL:8}



static void Test_STT3119()
{
  {
    init_simple_test("STT3119");
    static STT3119 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3119)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3119)");
    check_field_offset(lv, fa, 0, "STT3119.fa");
  }
}
static Arrange_To_Call_Me vSTT3119(Test_STT3119, "STT3119", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3129  {
  long fa;
  unsigned int  :18;
};
//SIG(1 STT3129) C1{ Fl Fi:18}



static void Test_STT3129()
{
  {
    init_simple_test("STT3129");
    static STT3129 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3129)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3129)");
    check_field_offset(lv, fa, 0, "STT3129.fa");
  }
}
static Arrange_To_Call_Me vSTT3129(Test_STT3129, "STT3129", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3139  {
  long fa;
  __tsu64  :18;
};
//SIG(1 STT3139) C1{ Fl FL:18}



static void Test_STT3139()
{
  {
    init_simple_test("STT3139");
    static STT3139 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3139)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3139)");
    check_field_offset(lv, fa, 0, "STT3139.fa");
  }
}
static Arrange_To_Call_Me vSTT3139(Test_STT3139, "STT3139", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3149  {
  long fa;
  __tsu64  :48;
};
//SIG(1 STT3149) C1{ Fl FL:48}



static void Test_STT3149()
{
  {
    init_simple_test("STT3149");
    static STT3149 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3149)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3149)");
    check_field_offset(lv, fa, 0, "STT3149.fa");
  }
}
static Arrange_To_Call_Me vSTT3149(Test_STT3149, "STT3149", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3159  {
  long fa;
  unsigned char bf:3;
};
//SIG(1 STT3159) C1{ Fl Fc:3}



static void Test_STT3159()
{
  {
    init_simple_test("STT3159");
    static STT3159 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3159)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3159)");
    check_field_offset(lv, fa, 0, "STT3159.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3159");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3159");
  }
}
static Arrange_To_Call_Me vSTT3159(Test_STT3159, "STT3159", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3169  {
  long fa;
  unsigned short bf:3;
};
//SIG(1 STT3169) C1{ Fl Fs:3}



static void Test_STT3169()
{
  {
    init_simple_test("STT3169");
    static STT3169 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3169)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3169)");
    check_field_offset(lv, fa, 0, "STT3169.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3169");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3169");
  }
}
static Arrange_To_Call_Me vSTT3169(Test_STT3169, "STT3169", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3179  {
  long fa;
  unsigned int bf:3;
};
//SIG(1 STT3179) C1{ Fl Fi:3}



static void Test_STT3179()
{
  {
    init_simple_test("STT3179");
    static STT3179 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3179)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3179)");
    check_field_offset(lv, fa, 0, "STT3179.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3179");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3179");
  }
}
static Arrange_To_Call_Me vSTT3179(Test_STT3179, "STT3179", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3189  {
  long fa;
  __tsu64 bf:3;
};
//SIG(1 STT3189) C1{ Fl FL:3}



static void Test_STT3189()
{
  {
    init_simple_test("STT3189");
    static STT3189 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3189)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3189)");
    check_field_offset(lv, fa, 0, "STT3189.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT3189");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT3189");
  }
}
static Arrange_To_Call_Me vSTT3189(Test_STT3189, "STT3189", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3199  {
  long fa;
  unsigned short bf:8;
};
//SIG(1 STT3199) C1{ Fl Fs:8}



static void Test_STT3199()
{
  {
    init_simple_test("STT3199");
    static STT3199 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3199)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3199)");
    check_field_offset(lv, fa, 0, "STT3199.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3199");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3199");
  }
}
static Arrange_To_Call_Me vSTT3199(Test_STT3199, "STT3199", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3209  {
  long fa;
  unsigned int bf:8;
};
//SIG(1 STT3209) C1{ Fl Fi:8}



static void Test_STT3209()
{
  {
    init_simple_test("STT3209");
    static STT3209 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3209)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3209)");
    check_field_offset(lv, fa, 0, "STT3209.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3209");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3209");
  }
}
static Arrange_To_Call_Me vSTT3209(Test_STT3209, "STT3209", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3219  {
  long fa;
  __tsu64 bf:8;
};
//SIG(1 STT3219) C1{ Fl FL:8}



static void Test_STT3219()
{
  {
    init_simple_test("STT3219");
    static STT3219 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3219)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3219)");
    check_field_offset(lv, fa, 0, "STT3219.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT3219");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT3219");
  }
}
static Arrange_To_Call_Me vSTT3219(Test_STT3219, "STT3219", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3229  {
  long fa;
  unsigned int bf:18;
};
//SIG(1 STT3229) C1{ Fl Fi:18}



static void Test_STT3229()
{
  {
    init_simple_test("STT3229");
    static STT3229 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3229)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3229)");
    check_field_offset(lv, fa, 0, "STT3229.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3229");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3229");
  }
}
static Arrange_To_Call_Me vSTT3229(Test_STT3229, "STT3229", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3239  {
  long fa;
  __tsu64 bf:18;
};
//SIG(1 STT3239) C1{ Fl FL:18}



static void Test_STT3239()
{
  {
    init_simple_test("STT3239");
    static STT3239 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT3239)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3239)");
    check_field_offset(lv, fa, 0, "STT3239.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT3239");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT3239");
  }
}
static Arrange_To_Call_Me vSTT3239(Test_STT3239, "STT3239", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT3249  {
  long fa;
  __tsu64 bf:48;
};
//SIG(1 STT3249) C1{ Fl FL:48}



static void Test_STT3249()
{
  {
    init_simple_test("STT3249");
    static STT3249 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT3249)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT3249)");
    check_field_offset(lv, fa, 0, "STT3249.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT3249");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT3249");
  }
}
static Arrange_To_Call_Me vSTT3249(Test_STT3249, "STT3249", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT410  {
  __tsi64 fa;
  unsigned char  :0;
  char fb;
};
//SIG(1 STT410) C1{ FL Fc:0 Fc}



static void Test_STT410()
{
  {
    init_simple_test("STT410");
    static STT410 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT410)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT410)");
    check_field_offset(lv, fa, 0, "STT410.fa");
    check_field_offset(lv, fb, 8, "STT410.fb");
  }
}
static Arrange_To_Call_Me vSTT410(Test_STT410, "STT410", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT420  {
  __tsi64 fa;
  unsigned short  :0;
  char fb;
};
//SIG(1 STT420) C1{ FL Fs:0 Fc}



static void Test_STT420()
{
  {
    init_simple_test("STT420");
    static STT420 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT420)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT420)");
    check_field_offset(lv, fa, 0, "STT420.fa");
    check_field_offset(lv, fb, 8, "STT420.fb");
  }
}
static Arrange_To_Call_Me vSTT420(Test_STT420, "STT420", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT430  {
  __tsi64 fa;
  unsigned int  :0;
  char fb;
};
//SIG(1 STT430) C1{ FL Fi:0 Fc}



static void Test_STT430()
{
  {
    init_simple_test("STT430");
    static STT430 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT430)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT430)");
    check_field_offset(lv, fa, 0, "STT430.fa");
    check_field_offset(lv, fb, 8, "STT430.fb");
  }
}
static Arrange_To_Call_Me vSTT430(Test_STT430, "STT430", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT440  {
  __tsi64 fa;
  __tsu64  :0;
  char fb;
};
//SIG(1 STT440) C1{ FL FL:0 Fc}



static void Test_STT440()
{
  {
    init_simple_test("STT440");
    static STT440 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT440)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT440)");
    check_field_offset(lv, fa, 0, "STT440.fa");
    check_field_offset(lv, fb, 8, "STT440.fb");
  }
}
static Arrange_To_Call_Me vSTT440(Test_STT440, "STT440", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT450  {
  __tsi64 fa;
  unsigned char  :3;
  char fb;
};
//SIG(1 STT450) C1{ FL Fc:3 Fc}



static void Test_STT450()
{
  {
    init_simple_test("STT450");
    static STT450 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT450)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT450)");
    check_field_offset(lv, fa, 0, "STT450.fa");
    check_field_offset(lv, fb, 9, "STT450.fb");
  }
}
static Arrange_To_Call_Me vSTT450(Test_STT450, "STT450", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT460  {
  __tsi64 fa;
  unsigned short  :3;
  char fb;
};
//SIG(1 STT460) C1{ FL Fs:3 Fc}



static void Test_STT460()
{
  {
    init_simple_test("STT460");
    static STT460 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT460)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT460)");
    check_field_offset(lv, fa, 0, "STT460.fa");
    check_field_offset(lv, fb, 9, "STT460.fb");
  }
}
static Arrange_To_Call_Me vSTT460(Test_STT460, "STT460", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT470  {
  __tsi64 fa;
  unsigned int  :3;
  char fb;
};
//SIG(1 STT470) C1{ FL Fi:3 Fc}



static void Test_STT470()
{
  {
    init_simple_test("STT470");
    static STT470 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT470)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT470)");
    check_field_offset(lv, fa, 0, "STT470.fa");
    check_field_offset(lv, fb, 9, "STT470.fb");
  }
}
static Arrange_To_Call_Me vSTT470(Test_STT470, "STT470", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT480  {
  __tsi64 fa;
  __tsu64  :3;
  char fb;
};
//SIG(1 STT480) C1{ FL FL:3 Fc}



static void Test_STT480()
{
  {
    init_simple_test("STT480");
    static STT480 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT480)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT480)");
    check_field_offset(lv, fa, 0, "STT480.fa");
    check_field_offset(lv, fb, 9, "STT480.fb");
  }
}
static Arrange_To_Call_Me vSTT480(Test_STT480, "STT480", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT490  {
  __tsi64 fa;
  unsigned short  :8;
  char fb;
};
//SIG(1 STT490) C1{ FL Fs:8 Fc}



static void Test_STT490()
{
  {
    init_simple_test("STT490");
    static STT490 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT490)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT490)");
    check_field_offset(lv, fa, 0, "STT490.fa");
    check_field_offset(lv, fb, 9, "STT490.fb");
  }
}
static Arrange_To_Call_Me vSTT490(Test_STT490, "STT490", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4100  {
  __tsi64 fa;
  unsigned int  :8;
  char fb;
};
//SIG(1 STT4100) C1{ FL Fi:8 Fc}



static void Test_STT4100()
{
  {
    init_simple_test("STT4100");
    static STT4100 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4100)");
    check_field_offset(lv, fa, 0, "STT4100.fa");
    check_field_offset(lv, fb, 9, "STT4100.fb");
  }
}
static Arrange_To_Call_Me vSTT4100(Test_STT4100, "STT4100", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4110  {
  __tsi64 fa;
  __tsu64  :8;
  char fb;
};
//SIG(1 STT4110) C1{ FL FL:8 Fc}



static void Test_STT4110()
{
  {
    init_simple_test("STT4110");
    static STT4110 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4110)");
    check_field_offset(lv, fa, 0, "STT4110.fa");
    check_field_offset(lv, fb, 9, "STT4110.fb");
  }
}
static Arrange_To_Call_Me vSTT4110(Test_STT4110, "STT4110", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4120  {
  __tsi64 fa;
  unsigned int  :18;
  char fb;
};
//SIG(1 STT4120) C1{ FL Fi:18 Fc}



static void Test_STT4120()
{
  {
    init_simple_test("STT4120");
    static STT4120 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4120)");
    check_field_offset(lv, fa, 0, "STT4120.fa");
    check_field_offset(lv, fb, 11, "STT4120.fb");
  }
}
static Arrange_To_Call_Me vSTT4120(Test_STT4120, "STT4120", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4130  {
  __tsi64 fa;
  __tsu64  :18;
  char fb;
};
//SIG(1 STT4130) C1{ FL FL:18 Fc}



static void Test_STT4130()
{
  {
    init_simple_test("STT4130");
    static STT4130 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4130)");
    check_field_offset(lv, fa, 0, "STT4130.fa");
    check_field_offset(lv, fb, 11, "STT4130.fb");
  }
}
static Arrange_To_Call_Me vSTT4130(Test_STT4130, "STT4130", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4140  {
  __tsi64 fa;
  __tsu64  :48;
  char fb;
};
//SIG(1 STT4140) C1{ FL FL:48 Fc}



static void Test_STT4140()
{
  {
    init_simple_test("STT4140");
    static STT4140 lv;
    check2(sizeof(lv), 16, "sizeof(STT4140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4140)");
    check_field_offset(lv, fa, 0, "STT4140.fa");
    check_field_offset(lv, fb, 14, "STT4140.fb");
  }
}
static Arrange_To_Call_Me vSTT4140(Test_STT4140, "STT4140", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4150  {
  __tsi64 fa;
  unsigned char bf:3;
  char fb;
};
//SIG(1 STT4150) C1{ FL Fc:3 Fc}



static void Test_STT4150()
{
  {
    init_simple_test("STT4150");
    static STT4150 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4150)");
    check_field_offset(lv, fa, 0, "STT4150.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4150");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4150");
    check_field_offset(lv, fb, 9, "STT4150.fb");
  }
}
static Arrange_To_Call_Me vSTT4150(Test_STT4150, "STT4150", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4160  {
  __tsi64 fa;
  unsigned short bf:3;
  char fb;
};
//SIG(1 STT4160) C1{ FL Fs:3 Fc}



static void Test_STT4160()
{
  {
    init_simple_test("STT4160");
    static STT4160 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4160)");
    check_field_offset(lv, fa, 0, "STT4160.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4160");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4160");
    check_field_offset(lv, fb, 9, "STT4160.fb");
  }
}
static Arrange_To_Call_Me vSTT4160(Test_STT4160, "STT4160", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4170  {
  __tsi64 fa;
  unsigned int bf:3;
  char fb;
};
//SIG(1 STT4170) C1{ FL Fi:3 Fc}



static void Test_STT4170()
{
  {
    init_simple_test("STT4170");
    static STT4170 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4170)");
    check_field_offset(lv, fa, 0, "STT4170.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4170");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4170");
    check_field_offset(lv, fb, 9, "STT4170.fb");
  }
}
static Arrange_To_Call_Me vSTT4170(Test_STT4170, "STT4170", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4180  {
  __tsi64 fa;
  __tsu64 bf:3;
  char fb;
};
//SIG(1 STT4180) C1{ FL FL:3 Fc}



static void Test_STT4180()
{
  {
    init_simple_test("STT4180");
    static STT4180 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4180)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4180)");
    check_field_offset(lv, fa, 0, "STT4180.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4180");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4180");
    check_field_offset(lv, fb, 9, "STT4180.fb");
  }
}
static Arrange_To_Call_Me vSTT4180(Test_STT4180, "STT4180", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4190  {
  __tsi64 fa;
  unsigned short bf:8;
  char fb;
};
//SIG(1 STT4190) C1{ FL Fs:8 Fc}



static void Test_STT4190()
{
  {
    init_simple_test("STT4190");
    static STT4190 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4190)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4190)");
    check_field_offset(lv, fa, 0, "STT4190.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4190");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4190");
    check_field_offset(lv, fb, 9, "STT4190.fb");
  }
}
static Arrange_To_Call_Me vSTT4190(Test_STT4190, "STT4190", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4200  {
  __tsi64 fa;
  unsigned int bf:8;
  char fb;
};
//SIG(1 STT4200) C1{ FL Fi:8 Fc}



static void Test_STT4200()
{
  {
    init_simple_test("STT4200");
    static STT4200 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4200)");
    check_field_offset(lv, fa, 0, "STT4200.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4200");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4200");
    check_field_offset(lv, fb, 9, "STT4200.fb");
  }
}
static Arrange_To_Call_Me vSTT4200(Test_STT4200, "STT4200", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4210  {
  __tsi64 fa;
  __tsu64 bf:8;
  char fb;
};
//SIG(1 STT4210) C1{ FL FL:8 Fc}



static void Test_STT4210()
{
  {
    init_simple_test("STT4210");
    static STT4210 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4210)");
    check_field_offset(lv, fa, 0, "STT4210.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4210");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4210");
    check_field_offset(lv, fb, 9, "STT4210.fb");
  }
}
static Arrange_To_Call_Me vSTT4210(Test_STT4210, "STT4210", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4220  {
  __tsi64 fa;
  unsigned int bf:18;
  char fb;
};
//SIG(1 STT4220) C1{ FL Fi:18 Fc}



static void Test_STT4220()
{
  {
    init_simple_test("STT4220");
    static STT4220 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4220)");
    check_field_offset(lv, fa, 0, "STT4220.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4220");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4220");
    check_field_offset(lv, fb, 11, "STT4220.fb");
  }
}
static Arrange_To_Call_Me vSTT4220(Test_STT4220, "STT4220", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4230  {
  __tsi64 fa;
  __tsu64 bf:18;
  char fb;
};
//SIG(1 STT4230) C1{ FL FL:18 Fc}



static void Test_STT4230()
{
  {
    init_simple_test("STT4230");
    static STT4230 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4230)");
    check_field_offset(lv, fa, 0, "STT4230.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4230");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4230");
    check_field_offset(lv, fb, 11, "STT4230.fb");
  }
}
static Arrange_To_Call_Me vSTT4230(Test_STT4230, "STT4230", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4240  {
  __tsi64 fa;
  __tsu64 bf:48;
  char fb;
};
//SIG(1 STT4240) C1{ FL FL:48 Fc}



static void Test_STT4240()
{
  {
    init_simple_test("STT4240");
    static STT4240 lv;
    check2(sizeof(lv), 16, "sizeof(STT4240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4240)");
    check_field_offset(lv, fa, 0, "STT4240.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4240");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4240");
    check_field_offset(lv, fb, 14, "STT4240.fb");
  }
}
static Arrange_To_Call_Me vSTT4240(Test_STT4240, "STT4240", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT411  {
  __tsi64 fa;
  unsigned char  :0;
  short fb;
};
//SIG(1 STT411) C1{ FL Fc:0 Fs}



static void Test_STT411()
{
  {
    init_simple_test("STT411");
    static STT411 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT411)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT411)");
    check_field_offset(lv, fa, 0, "STT411.fa");
    check_field_offset(lv, fb, 8, "STT411.fb");
  }
}
static Arrange_To_Call_Me vSTT411(Test_STT411, "STT411", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT421  {
  __tsi64 fa;
  unsigned short  :0;
  short fb;
};
//SIG(1 STT421) C1{ FL Fs:0 Fs}



static void Test_STT421()
{
  {
    init_simple_test("STT421");
    static STT421 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT421)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT421)");
    check_field_offset(lv, fa, 0, "STT421.fa");
    check_field_offset(lv, fb, 8, "STT421.fb");
  }
}
static Arrange_To_Call_Me vSTT421(Test_STT421, "STT421", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT431  {
  __tsi64 fa;
  unsigned int  :0;
  short fb;
};
//SIG(1 STT431) C1{ FL Fi:0 Fs}



static void Test_STT431()
{
  {
    init_simple_test("STT431");
    static STT431 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT431)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT431)");
    check_field_offset(lv, fa, 0, "STT431.fa");
    check_field_offset(lv, fb, 8, "STT431.fb");
  }
}
static Arrange_To_Call_Me vSTT431(Test_STT431, "STT431", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT441  {
  __tsi64 fa;
  __tsu64  :0;
  short fb;
};
//SIG(1 STT441) C1{ FL FL:0 Fs}



static void Test_STT441()
{
  {
    init_simple_test("STT441");
    static STT441 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT441)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT441)");
    check_field_offset(lv, fa, 0, "STT441.fa");
    check_field_offset(lv, fb, 8, "STT441.fb");
  }
}
static Arrange_To_Call_Me vSTT441(Test_STT441, "STT441", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT451  {
  __tsi64 fa;
  unsigned char  :3;
  short fb;
};
//SIG(1 STT451) C1{ FL Fc:3 Fs}



static void Test_STT451()
{
  {
    init_simple_test("STT451");
    static STT451 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT451)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT451)");
    check_field_offset(lv, fa, 0, "STT451.fa");
    check_field_offset(lv, fb, 10, "STT451.fb");
  }
}
static Arrange_To_Call_Me vSTT451(Test_STT451, "STT451", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT461  {
  __tsi64 fa;
  unsigned short  :3;
  short fb;
};
//SIG(1 STT461) C1{ FL Fs:3 Fs}



static void Test_STT461()
{
  {
    init_simple_test("STT461");
    static STT461 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT461)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT461)");
    check_field_offset(lv, fa, 0, "STT461.fa");
    check_field_offset(lv, fb, 10, "STT461.fb");
  }
}
static Arrange_To_Call_Me vSTT461(Test_STT461, "STT461", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT471  {
  __tsi64 fa;
  unsigned int  :3;
  short fb;
};
//SIG(1 STT471) C1{ FL Fi:3 Fs}



static void Test_STT471()
{
  {
    init_simple_test("STT471");
    static STT471 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT471)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT471)");
    check_field_offset(lv, fa, 0, "STT471.fa");
    check_field_offset(lv, fb, 10, "STT471.fb");
  }
}
static Arrange_To_Call_Me vSTT471(Test_STT471, "STT471", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT481  {
  __tsi64 fa;
  __tsu64  :3;
  short fb;
};
//SIG(1 STT481) C1{ FL FL:3 Fs}



static void Test_STT481()
{
  {
    init_simple_test("STT481");
    static STT481 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT481)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT481)");
    check_field_offset(lv, fa, 0, "STT481.fa");
    check_field_offset(lv, fb, 10, "STT481.fb");
  }
}
static Arrange_To_Call_Me vSTT481(Test_STT481, "STT481", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT491  {
  __tsi64 fa;
  unsigned short  :8;
  short fb;
};
//SIG(1 STT491) C1{ FL Fs:8 Fs}



static void Test_STT491()
{
  {
    init_simple_test("STT491");
    static STT491 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT491)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT491)");
    check_field_offset(lv, fa, 0, "STT491.fa");
    check_field_offset(lv, fb, 10, "STT491.fb");
  }
}
static Arrange_To_Call_Me vSTT491(Test_STT491, "STT491", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4101  {
  __tsi64 fa;
  unsigned int  :8;
  short fb;
};
//SIG(1 STT4101) C1{ FL Fi:8 Fs}



static void Test_STT4101()
{
  {
    init_simple_test("STT4101");
    static STT4101 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4101)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4101)");
    check_field_offset(lv, fa, 0, "STT4101.fa");
    check_field_offset(lv, fb, 10, "STT4101.fb");
  }
}
static Arrange_To_Call_Me vSTT4101(Test_STT4101, "STT4101", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4111  {
  __tsi64 fa;
  __tsu64  :8;
  short fb;
};
//SIG(1 STT4111) C1{ FL FL:8 Fs}



static void Test_STT4111()
{
  {
    init_simple_test("STT4111");
    static STT4111 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4111)");
    check_field_offset(lv, fa, 0, "STT4111.fa");
    check_field_offset(lv, fb, 10, "STT4111.fb");
  }
}
static Arrange_To_Call_Me vSTT4111(Test_STT4111, "STT4111", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4121  {
  __tsi64 fa;
  unsigned int  :18;
  short fb;
};
//SIG(1 STT4121) C1{ FL Fi:18 Fs}



static void Test_STT4121()
{
  {
    init_simple_test("STT4121");
    static STT4121 lv;
    check2(sizeof(lv), 16, "sizeof(STT4121)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4121)");
    check_field_offset(lv, fa, 0, "STT4121.fa");
    check_field_offset(lv, fb, 12, "STT4121.fb");
  }
}
static Arrange_To_Call_Me vSTT4121(Test_STT4121, "STT4121", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4131  {
  __tsi64 fa;
  __tsu64  :18;
  short fb;
};
//SIG(1 STT4131) C1{ FL FL:18 Fs}



static void Test_STT4131()
{
  {
    init_simple_test("STT4131");
    static STT4131 lv;
    check2(sizeof(lv), 16, "sizeof(STT4131)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4131)");
    check_field_offset(lv, fa, 0, "STT4131.fa");
    check_field_offset(lv, fb, 12, "STT4131.fb");
  }
}
static Arrange_To_Call_Me vSTT4131(Test_STT4131, "STT4131", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4141  {
  __tsi64 fa;
  __tsu64  :48;
  short fb;
};
//SIG(1 STT4141) C1{ FL FL:48 Fs}



static void Test_STT4141()
{
  {
    init_simple_test("STT4141");
    static STT4141 lv;
    check2(sizeof(lv), 16, "sizeof(STT4141)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4141)");
    check_field_offset(lv, fa, 0, "STT4141.fa");
    check_field_offset(lv, fb, 14, "STT4141.fb");
  }
}
static Arrange_To_Call_Me vSTT4141(Test_STT4141, "STT4141", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4151  {
  __tsi64 fa;
  unsigned char bf:3;
  short fb;
};
//SIG(1 STT4151) C1{ FL Fc:3 Fs}



static void Test_STT4151()
{
  {
    init_simple_test("STT4151");
    static STT4151 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4151)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4151)");
    check_field_offset(lv, fa, 0, "STT4151.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4151");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4151");
    check_field_offset(lv, fb, 10, "STT4151.fb");
  }
}
static Arrange_To_Call_Me vSTT4151(Test_STT4151, "STT4151", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4161  {
  __tsi64 fa;
  unsigned short bf:3;
  short fb;
};
//SIG(1 STT4161) C1{ FL Fs:3 Fs}



static void Test_STT4161()
{
  {
    init_simple_test("STT4161");
    static STT4161 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4161)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4161)");
    check_field_offset(lv, fa, 0, "STT4161.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4161");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4161");
    check_field_offset(lv, fb, 10, "STT4161.fb");
  }
}
static Arrange_To_Call_Me vSTT4161(Test_STT4161, "STT4161", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4171  {
  __tsi64 fa;
  unsigned int bf:3;
  short fb;
};
//SIG(1 STT4171) C1{ FL Fi:3 Fs}



static void Test_STT4171()
{
  {
    init_simple_test("STT4171");
    static STT4171 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4171)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4171)");
    check_field_offset(lv, fa, 0, "STT4171.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4171");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4171");
    check_field_offset(lv, fb, 10, "STT4171.fb");
  }
}
static Arrange_To_Call_Me vSTT4171(Test_STT4171, "STT4171", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4181  {
  __tsi64 fa;
  __tsu64 bf:3;
  short fb;
};
//SIG(1 STT4181) C1{ FL FL:3 Fs}



static void Test_STT4181()
{
  {
    init_simple_test("STT4181");
    static STT4181 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4181)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4181)");
    check_field_offset(lv, fa, 0, "STT4181.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4181");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4181");
    check_field_offset(lv, fb, 10, "STT4181.fb");
  }
}
static Arrange_To_Call_Me vSTT4181(Test_STT4181, "STT4181", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4191  {
  __tsi64 fa;
  unsigned short bf:8;
  short fb;
};
//SIG(1 STT4191) C1{ FL Fs:8 Fs}



static void Test_STT4191()
{
  {
    init_simple_test("STT4191");
    static STT4191 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4191)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4191)");
    check_field_offset(lv, fa, 0, "STT4191.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4191");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4191");
    check_field_offset(lv, fb, 10, "STT4191.fb");
  }
}
static Arrange_To_Call_Me vSTT4191(Test_STT4191, "STT4191", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4201  {
  __tsi64 fa;
  unsigned int bf:8;
  short fb;
};
//SIG(1 STT4201) C1{ FL Fi:8 Fs}



static void Test_STT4201()
{
  {
    init_simple_test("STT4201");
    static STT4201 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4201)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4201)");
    check_field_offset(lv, fa, 0, "STT4201.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4201");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4201");
    check_field_offset(lv, fb, 10, "STT4201.fb");
  }
}
static Arrange_To_Call_Me vSTT4201(Test_STT4201, "STT4201", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4211  {
  __tsi64 fa;
  __tsu64 bf:8;
  short fb;
};
//SIG(1 STT4211) C1{ FL FL:8 Fs}



static void Test_STT4211()
{
  {
    init_simple_test("STT4211");
    static STT4211 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4211)");
    check_field_offset(lv, fa, 0, "STT4211.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4211");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4211");
    check_field_offset(lv, fb, 10, "STT4211.fb");
  }
}
static Arrange_To_Call_Me vSTT4211(Test_STT4211, "STT4211", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4221  {
  __tsi64 fa;
  unsigned int bf:18;
  short fb;
};
//SIG(1 STT4221) C1{ FL Fi:18 Fs}



static void Test_STT4221()
{
  {
    init_simple_test("STT4221");
    static STT4221 lv;
    check2(sizeof(lv), 16, "sizeof(STT4221)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4221)");
    check_field_offset(lv, fa, 0, "STT4221.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4221");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4221");
    check_field_offset(lv, fb, 12, "STT4221.fb");
  }
}
static Arrange_To_Call_Me vSTT4221(Test_STT4221, "STT4221", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4231  {
  __tsi64 fa;
  __tsu64 bf:18;
  short fb;
};
//SIG(1 STT4231) C1{ FL FL:18 Fs}



static void Test_STT4231()
{
  {
    init_simple_test("STT4231");
    static STT4231 lv;
    check2(sizeof(lv), 16, "sizeof(STT4231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4231)");
    check_field_offset(lv, fa, 0, "STT4231.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4231");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4231");
    check_field_offset(lv, fb, 12, "STT4231.fb");
  }
}
static Arrange_To_Call_Me vSTT4231(Test_STT4231, "STT4231", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4241  {
  __tsi64 fa;
  __tsu64 bf:48;
  short fb;
};
//SIG(1 STT4241) C1{ FL FL:48 Fs}



static void Test_STT4241()
{
  {
    init_simple_test("STT4241");
    static STT4241 lv;
    check2(sizeof(lv), 16, "sizeof(STT4241)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4241)");
    check_field_offset(lv, fa, 0, "STT4241.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4241");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4241");
    check_field_offset(lv, fb, 14, "STT4241.fb");
  }
}
static Arrange_To_Call_Me vSTT4241(Test_STT4241, "STT4241", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT412  {
  __tsi64 fa;
  unsigned char  :0;
  int fb;
};
//SIG(1 STT412) C1{ FL Fc:0 Fi}



static void Test_STT412()
{
  {
    init_simple_test("STT412");
    static STT412 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT412)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT412)");
    check_field_offset(lv, fa, 0, "STT412.fa");
    check_field_offset(lv, fb, 8, "STT412.fb");
  }
}
static Arrange_To_Call_Me vSTT412(Test_STT412, "STT412", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT422  {
  __tsi64 fa;
  unsigned short  :0;
  int fb;
};
//SIG(1 STT422) C1{ FL Fs:0 Fi}



static void Test_STT422()
{
  {
    init_simple_test("STT422");
    static STT422 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT422)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT422)");
    check_field_offset(lv, fa, 0, "STT422.fa");
    check_field_offset(lv, fb, 8, "STT422.fb");
  }
}
static Arrange_To_Call_Me vSTT422(Test_STT422, "STT422", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT432  {
  __tsi64 fa;
  unsigned int  :0;
  int fb;
};
//SIG(1 STT432) C1{ FL Fi:0 Fi}



static void Test_STT432()
{
  {
    init_simple_test("STT432");
    static STT432 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT432)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT432)");
    check_field_offset(lv, fa, 0, "STT432.fa");
    check_field_offset(lv, fb, 8, "STT432.fb");
  }
}
static Arrange_To_Call_Me vSTT432(Test_STT432, "STT432", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT442  {
  __tsi64 fa;
  __tsu64  :0;
  int fb;
};
//SIG(1 STT442) C1{ FL FL:0 Fi}



static void Test_STT442()
{
  {
    init_simple_test("STT442");
    static STT442 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT442)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT442)");
    check_field_offset(lv, fa, 0, "STT442.fa");
    check_field_offset(lv, fb, 8, "STT442.fb");
  }
}
static Arrange_To_Call_Me vSTT442(Test_STT442, "STT442", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT452  {
  __tsi64 fa;
  unsigned char  :3;
  int fb;
};
//SIG(1 STT452) C1{ FL Fc:3 Fi}



static void Test_STT452()
{
  {
    init_simple_test("STT452");
    static STT452 lv;
    check2(sizeof(lv), 16, "sizeof(STT452)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT452)");
    check_field_offset(lv, fa, 0, "STT452.fa");
    check_field_offset(lv, fb, 12, "STT452.fb");
  }
}
static Arrange_To_Call_Me vSTT452(Test_STT452, "STT452", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT462  {
  __tsi64 fa;
  unsigned short  :3;
  int fb;
};
//SIG(1 STT462) C1{ FL Fs:3 Fi}



static void Test_STT462()
{
  {
    init_simple_test("STT462");
    static STT462 lv;
    check2(sizeof(lv), 16, "sizeof(STT462)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT462)");
    check_field_offset(lv, fa, 0, "STT462.fa");
    check_field_offset(lv, fb, 12, "STT462.fb");
  }
}
static Arrange_To_Call_Me vSTT462(Test_STT462, "STT462", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT472  {
  __tsi64 fa;
  unsigned int  :3;
  int fb;
};
//SIG(1 STT472) C1{ FL Fi:3 Fi}



static void Test_STT472()
{
  {
    init_simple_test("STT472");
    static STT472 lv;
    check2(sizeof(lv), 16, "sizeof(STT472)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT472)");
    check_field_offset(lv, fa, 0, "STT472.fa");
    check_field_offset(lv, fb, 12, "STT472.fb");
  }
}
static Arrange_To_Call_Me vSTT472(Test_STT472, "STT472", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT482  {
  __tsi64 fa;
  __tsu64  :3;
  int fb;
};
//SIG(1 STT482) C1{ FL FL:3 Fi}



static void Test_STT482()
{
  {
    init_simple_test("STT482");
    static STT482 lv;
    check2(sizeof(lv), 16, "sizeof(STT482)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT482)");
    check_field_offset(lv, fa, 0, "STT482.fa");
    check_field_offset(lv, fb, 12, "STT482.fb");
  }
}
static Arrange_To_Call_Me vSTT482(Test_STT482, "STT482", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT492  {
  __tsi64 fa;
  unsigned short  :8;
  int fb;
};
//SIG(1 STT492) C1{ FL Fs:8 Fi}



static void Test_STT492()
{
  {
    init_simple_test("STT492");
    static STT492 lv;
    check2(sizeof(lv), 16, "sizeof(STT492)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT492)");
    check_field_offset(lv, fa, 0, "STT492.fa");
    check_field_offset(lv, fb, 12, "STT492.fb");
  }
}
static Arrange_To_Call_Me vSTT492(Test_STT492, "STT492", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4102  {
  __tsi64 fa;
  unsigned int  :8;
  int fb;
};
//SIG(1 STT4102) C1{ FL Fi:8 Fi}



static void Test_STT4102()
{
  {
    init_simple_test("STT4102");
    static STT4102 lv;
    check2(sizeof(lv), 16, "sizeof(STT4102)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4102)");
    check_field_offset(lv, fa, 0, "STT4102.fa");
    check_field_offset(lv, fb, 12, "STT4102.fb");
  }
}
static Arrange_To_Call_Me vSTT4102(Test_STT4102, "STT4102", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4112  {
  __tsi64 fa;
  __tsu64  :8;
  int fb;
};
//SIG(1 STT4112) C1{ FL FL:8 Fi}



static void Test_STT4112()
{
  {
    init_simple_test("STT4112");
    static STT4112 lv;
    check2(sizeof(lv), 16, "sizeof(STT4112)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4112)");
    check_field_offset(lv, fa, 0, "STT4112.fa");
    check_field_offset(lv, fb, 12, "STT4112.fb");
  }
}
static Arrange_To_Call_Me vSTT4112(Test_STT4112, "STT4112", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4122  {
  __tsi64 fa;
  unsigned int  :18;
  int fb;
};
//SIG(1 STT4122) C1{ FL Fi:18 Fi}



static void Test_STT4122()
{
  {
    init_simple_test("STT4122");
    static STT4122 lv;
    check2(sizeof(lv), 16, "sizeof(STT4122)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4122)");
    check_field_offset(lv, fa, 0, "STT4122.fa");
    check_field_offset(lv, fb, 12, "STT4122.fb");
  }
}
static Arrange_To_Call_Me vSTT4122(Test_STT4122, "STT4122", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4132  {
  __tsi64 fa;
  __tsu64  :18;
  int fb;
};
//SIG(1 STT4132) C1{ FL FL:18 Fi}



static void Test_STT4132()
{
  {
    init_simple_test("STT4132");
    static STT4132 lv;
    check2(sizeof(lv), 16, "sizeof(STT4132)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4132)");
    check_field_offset(lv, fa, 0, "STT4132.fa");
    check_field_offset(lv, fb, 12, "STT4132.fb");
  }
}
static Arrange_To_Call_Me vSTT4132(Test_STT4132, "STT4132", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4142  {
  __tsi64 fa;
  __tsu64  :48;
  int fb;
};
//SIG(1 STT4142) C1{ FL FL:48 Fi}



static void Test_STT4142()
{
  {
    init_simple_test("STT4142");
    static STT4142 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4142)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4142)");
    check_field_offset(lv, fa, 0, "STT4142.fa");
    check_field_offset(lv, fb, 16, "STT4142.fb");
  }
}
static Arrange_To_Call_Me vSTT4142(Test_STT4142, "STT4142", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4152  {
  __tsi64 fa;
  unsigned char bf:3;
  int fb;
};
//SIG(1 STT4152) C1{ FL Fc:3 Fi}



static void Test_STT4152()
{
  {
    init_simple_test("STT4152");
    static STT4152 lv;
    check2(sizeof(lv), 16, "sizeof(STT4152)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4152)");
    check_field_offset(lv, fa, 0, "STT4152.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4152");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4152");
    check_field_offset(lv, fb, 12, "STT4152.fb");
  }
}
static Arrange_To_Call_Me vSTT4152(Test_STT4152, "STT4152", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4162  {
  __tsi64 fa;
  unsigned short bf:3;
  int fb;
};
//SIG(1 STT4162) C1{ FL Fs:3 Fi}



static void Test_STT4162()
{
  {
    init_simple_test("STT4162");
    static STT4162 lv;
    check2(sizeof(lv), 16, "sizeof(STT4162)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4162)");
    check_field_offset(lv, fa, 0, "STT4162.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4162");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4162");
    check_field_offset(lv, fb, 12, "STT4162.fb");
  }
}
static Arrange_To_Call_Me vSTT4162(Test_STT4162, "STT4162", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4172  {
  __tsi64 fa;
  unsigned int bf:3;
  int fb;
};
//SIG(1 STT4172) C1{ FL Fi:3 Fi}



static void Test_STT4172()
{
  {
    init_simple_test("STT4172");
    static STT4172 lv;
    check2(sizeof(lv), 16, "sizeof(STT4172)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4172)");
    check_field_offset(lv, fa, 0, "STT4172.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4172");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4172");
    check_field_offset(lv, fb, 12, "STT4172.fb");
  }
}
static Arrange_To_Call_Me vSTT4172(Test_STT4172, "STT4172", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4182  {
  __tsi64 fa;
  __tsu64 bf:3;
  int fb;
};
//SIG(1 STT4182) C1{ FL FL:3 Fi}



static void Test_STT4182()
{
  {
    init_simple_test("STT4182");
    static STT4182 lv;
    check2(sizeof(lv), 16, "sizeof(STT4182)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4182)");
    check_field_offset(lv, fa, 0, "STT4182.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4182");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4182");
    check_field_offset(lv, fb, 12, "STT4182.fb");
  }
}
static Arrange_To_Call_Me vSTT4182(Test_STT4182, "STT4182", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4192  {
  __tsi64 fa;
  unsigned short bf:8;
  int fb;
};
//SIG(1 STT4192) C1{ FL Fs:8 Fi}



static void Test_STT4192()
{
  {
    init_simple_test("STT4192");
    static STT4192 lv;
    check2(sizeof(lv), 16, "sizeof(STT4192)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4192)");
    check_field_offset(lv, fa, 0, "STT4192.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4192");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4192");
    check_field_offset(lv, fb, 12, "STT4192.fb");
  }
}
static Arrange_To_Call_Me vSTT4192(Test_STT4192, "STT4192", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4202  {
  __tsi64 fa;
  unsigned int bf:8;
  int fb;
};
//SIG(1 STT4202) C1{ FL Fi:8 Fi}



static void Test_STT4202()
{
  {
    init_simple_test("STT4202");
    static STT4202 lv;
    check2(sizeof(lv), 16, "sizeof(STT4202)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4202)");
    check_field_offset(lv, fa, 0, "STT4202.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4202");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4202");
    check_field_offset(lv, fb, 12, "STT4202.fb");
  }
}
static Arrange_To_Call_Me vSTT4202(Test_STT4202, "STT4202", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4212  {
  __tsi64 fa;
  __tsu64 bf:8;
  int fb;
};
//SIG(1 STT4212) C1{ FL FL:8 Fi}



static void Test_STT4212()
{
  {
    init_simple_test("STT4212");
    static STT4212 lv;
    check2(sizeof(lv), 16, "sizeof(STT4212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4212)");
    check_field_offset(lv, fa, 0, "STT4212.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4212");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4212");
    check_field_offset(lv, fb, 12, "STT4212.fb");
  }
}
static Arrange_To_Call_Me vSTT4212(Test_STT4212, "STT4212", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4222  {
  __tsi64 fa;
  unsigned int bf:18;
  int fb;
};
//SIG(1 STT4222) C1{ FL Fi:18 Fi}



static void Test_STT4222()
{
  {
    init_simple_test("STT4222");
    static STT4222 lv;
    check2(sizeof(lv), 16, "sizeof(STT4222)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4222)");
    check_field_offset(lv, fa, 0, "STT4222.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4222");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4222");
    check_field_offset(lv, fb, 12, "STT4222.fb");
  }
}
static Arrange_To_Call_Me vSTT4222(Test_STT4222, "STT4222", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4232  {
  __tsi64 fa;
  __tsu64 bf:18;
  int fb;
};
//SIG(1 STT4232) C1{ FL FL:18 Fi}



static void Test_STT4232()
{
  {
    init_simple_test("STT4232");
    static STT4232 lv;
    check2(sizeof(lv), 16, "sizeof(STT4232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4232)");
    check_field_offset(lv, fa, 0, "STT4232.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4232");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4232");
    check_field_offset(lv, fb, 12, "STT4232.fb");
  }
}
static Arrange_To_Call_Me vSTT4232(Test_STT4232, "STT4232", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4242  {
  __tsi64 fa;
  __tsu64 bf:48;
  int fb;
};
//SIG(1 STT4242) C1{ FL FL:48 Fi}



static void Test_STT4242()
{
  {
    init_simple_test("STT4242");
    static STT4242 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4242)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4242)");
    check_field_offset(lv, fa, 0, "STT4242.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4242");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4242");
    check_field_offset(lv, fb, 16, "STT4242.fb");
  }
}
static Arrange_To_Call_Me vSTT4242(Test_STT4242, "STT4242", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT413  {
  __tsi64 fa;
  unsigned char  :0;
  long fb;
};
//SIG(1 STT413) C1{ FL Fc:0 Fl}



static void Test_STT413()
{
  {
    init_simple_test("STT413");
    static STT413 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT413)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT413)");
    check_field_offset(lv, fa, 0, "STT413.fa");
    check_field_offset(lv, fb, 8, "STT413.fb");
  }
}
static Arrange_To_Call_Me vSTT413(Test_STT413, "STT413", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT423  {
  __tsi64 fa;
  unsigned short  :0;
  long fb;
};
//SIG(1 STT423) C1{ FL Fs:0 Fl}



static void Test_STT423()
{
  {
    init_simple_test("STT423");
    static STT423 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT423)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT423)");
    check_field_offset(lv, fa, 0, "STT423.fa");
    check_field_offset(lv, fb, 8, "STT423.fb");
  }
}
static Arrange_To_Call_Me vSTT423(Test_STT423, "STT423", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT433  {
  __tsi64 fa;
  unsigned int  :0;
  long fb;
};
//SIG(1 STT433) C1{ FL Fi:0 Fl}



static void Test_STT433()
{
  {
    init_simple_test("STT433");
    static STT433 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT433)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT433)");
    check_field_offset(lv, fa, 0, "STT433.fa");
    check_field_offset(lv, fb, 8, "STT433.fb");
  }
}
static Arrange_To_Call_Me vSTT433(Test_STT433, "STT433", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT443  {
  __tsi64 fa;
  __tsu64  :0;
  long fb;
};
//SIG(1 STT443) C1{ FL FL:0 Fl}



static void Test_STT443()
{
  {
    init_simple_test("STT443");
    static STT443 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT443)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT443)");
    check_field_offset(lv, fa, 0, "STT443.fa");
    check_field_offset(lv, fb, 8, "STT443.fb");
  }
}
static Arrange_To_Call_Me vSTT443(Test_STT443, "STT443", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT453  {
  __tsi64 fa;
  unsigned char  :3;
  long fb;
};
//SIG(1 STT453) C1{ FL Fc:3 Fl}



static void Test_STT453()
{
  {
    init_simple_test("STT453");
    static STT453 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT453)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT453)");
    check_field_offset(lv, fa, 0, "STT453.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT453.fb");
  }
}
static Arrange_To_Call_Me vSTT453(Test_STT453, "STT453", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT463  {
  __tsi64 fa;
  unsigned short  :3;
  long fb;
};
//SIG(1 STT463) C1{ FL Fs:3 Fl}



static void Test_STT463()
{
  {
    init_simple_test("STT463");
    static STT463 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT463)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT463)");
    check_field_offset(lv, fa, 0, "STT463.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT463.fb");
  }
}
static Arrange_To_Call_Me vSTT463(Test_STT463, "STT463", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT473  {
  __tsi64 fa;
  unsigned int  :3;
  long fb;
};
//SIG(1 STT473) C1{ FL Fi:3 Fl}



static void Test_STT473()
{
  {
    init_simple_test("STT473");
    static STT473 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT473)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT473)");
    check_field_offset(lv, fa, 0, "STT473.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT473.fb");
  }
}
static Arrange_To_Call_Me vSTT473(Test_STT473, "STT473", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT483  {
  __tsi64 fa;
  __tsu64  :3;
  long fb;
};
//SIG(1 STT483) C1{ FL FL:3 Fl}



static void Test_STT483()
{
  {
    init_simple_test("STT483");
    static STT483 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT483)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT483)");
    check_field_offset(lv, fa, 0, "STT483.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT483.fb");
  }
}
static Arrange_To_Call_Me vSTT483(Test_STT483, "STT483", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT493  {
  __tsi64 fa;
  unsigned short  :8;
  long fb;
};
//SIG(1 STT493) C1{ FL Fs:8 Fl}



static void Test_STT493()
{
  {
    init_simple_test("STT493");
    static STT493 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT493)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT493)");
    check_field_offset(lv, fa, 0, "STT493.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT493.fb");
  }
}
static Arrange_To_Call_Me vSTT493(Test_STT493, "STT493", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4103  {
  __tsi64 fa;
  unsigned int  :8;
  long fb;
};
//SIG(1 STT4103) C1{ FL Fi:8 Fl}



static void Test_STT4103()
{
  {
    init_simple_test("STT4103");
    static STT4103 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4103)");
    check_field_offset(lv, fa, 0, "STT4103.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4103.fb");
  }
}
static Arrange_To_Call_Me vSTT4103(Test_STT4103, "STT4103", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4113  {
  __tsi64 fa;
  __tsu64  :8;
  long fb;
};
//SIG(1 STT4113) C1{ FL FL:8 Fl}



static void Test_STT4113()
{
  {
    init_simple_test("STT4113");
    static STT4113 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4113)");
    check_field_offset(lv, fa, 0, "STT4113.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4113.fb");
  }
}
static Arrange_To_Call_Me vSTT4113(Test_STT4113, "STT4113", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4123  {
  __tsi64 fa;
  unsigned int  :18;
  long fb;
};
//SIG(1 STT4123) C1{ FL Fi:18 Fl}



static void Test_STT4123()
{
  {
    init_simple_test("STT4123");
    static STT4123 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4123)");
    check_field_offset(lv, fa, 0, "STT4123.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4123.fb");
  }
}
static Arrange_To_Call_Me vSTT4123(Test_STT4123, "STT4123", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4133  {
  __tsi64 fa;
  __tsu64  :18;
  long fb;
};
//SIG(1 STT4133) C1{ FL FL:18 Fl}



static void Test_STT4133()
{
  {
    init_simple_test("STT4133");
    static STT4133 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4133)");
    check_field_offset(lv, fa, 0, "STT4133.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4133.fb");
  }
}
static Arrange_To_Call_Me vSTT4133(Test_STT4133, "STT4133", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4143  {
  __tsi64 fa;
  __tsu64  :48;
  long fb;
};
//SIG(1 STT4143) C1{ FL FL:48 Fl}



static void Test_STT4143()
{
  {
    init_simple_test("STT4143");
    static STT4143 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4143)");
    check_field_offset(lv, fa, 0, "STT4143.fa");
    check_field_offset(lv, fb, 16, "STT4143.fb");
  }
}
static Arrange_To_Call_Me vSTT4143(Test_STT4143, "STT4143", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4153  {
  __tsi64 fa;
  unsigned char bf:3;
  long fb;
};
//SIG(1 STT4153) C1{ FL Fc:3 Fl}



static void Test_STT4153()
{
  {
    init_simple_test("STT4153");
    static STT4153 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4153)");
    check_field_offset(lv, fa, 0, "STT4153.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4153");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4153");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4153.fb");
  }
}
static Arrange_To_Call_Me vSTT4153(Test_STT4153, "STT4153", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4163  {
  __tsi64 fa;
  unsigned short bf:3;
  long fb;
};
//SIG(1 STT4163) C1{ FL Fs:3 Fl}



static void Test_STT4163()
{
  {
    init_simple_test("STT4163");
    static STT4163 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4163)");
    check_field_offset(lv, fa, 0, "STT4163.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4163");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4163");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4163.fb");
  }
}
static Arrange_To_Call_Me vSTT4163(Test_STT4163, "STT4163", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4173  {
  __tsi64 fa;
  unsigned int bf:3;
  long fb;
};
//SIG(1 STT4173) C1{ FL Fi:3 Fl}



static void Test_STT4173()
{
  {
    init_simple_test("STT4173");
    static STT4173 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4173)");
    check_field_offset(lv, fa, 0, "STT4173.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4173");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4173");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4173.fb");
  }
}
static Arrange_To_Call_Me vSTT4173(Test_STT4173, "STT4173", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4183  {
  __tsi64 fa;
  __tsu64 bf:3;
  long fb;
};
//SIG(1 STT4183) C1{ FL FL:3 Fl}



static void Test_STT4183()
{
  {
    init_simple_test("STT4183");
    static STT4183 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4183)");
    check_field_offset(lv, fa, 0, "STT4183.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4183");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4183");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4183.fb");
  }
}
static Arrange_To_Call_Me vSTT4183(Test_STT4183, "STT4183", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4193  {
  __tsi64 fa;
  unsigned short bf:8;
  long fb;
};
//SIG(1 STT4193) C1{ FL Fs:8 Fl}



static void Test_STT4193()
{
  {
    init_simple_test("STT4193");
    static STT4193 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4193)");
    check_field_offset(lv, fa, 0, "STT4193.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4193");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4193");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4193.fb");
  }
}
static Arrange_To_Call_Me vSTT4193(Test_STT4193, "STT4193", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4203  {
  __tsi64 fa;
  unsigned int bf:8;
  long fb;
};
//SIG(1 STT4203) C1{ FL Fi:8 Fl}



static void Test_STT4203()
{
  {
    init_simple_test("STT4203");
    static STT4203 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4203)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4203)");
    check_field_offset(lv, fa, 0, "STT4203.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4203");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4203");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4203.fb");
  }
}
static Arrange_To_Call_Me vSTT4203(Test_STT4203, "STT4203", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4213  {
  __tsi64 fa;
  __tsu64 bf:8;
  long fb;
};
//SIG(1 STT4213) C1{ FL FL:8 Fl}



static void Test_STT4213()
{
  {
    init_simple_test("STT4213");
    static STT4213 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4213)");
    check_field_offset(lv, fa, 0, "STT4213.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4213");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4213");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4213.fb");
  }
}
static Arrange_To_Call_Me vSTT4213(Test_STT4213, "STT4213", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4223  {
  __tsi64 fa;
  unsigned int bf:18;
  long fb;
};
//SIG(1 STT4223) C1{ FL Fi:18 Fl}



static void Test_STT4223()
{
  {
    init_simple_test("STT4223");
    static STT4223 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4223)");
    check_field_offset(lv, fa, 0, "STT4223.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4223");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4223");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4223.fb");
  }
}
static Arrange_To_Call_Me vSTT4223(Test_STT4223, "STT4223", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4233  {
  __tsi64 fa;
  __tsu64 bf:18;
  long fb;
};
//SIG(1 STT4233) C1{ FL FL:18 Fl}



static void Test_STT4233()
{
  {
    init_simple_test("STT4233");
    static STT4233 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4233)");
    check_field_offset(lv, fa, 0, "STT4233.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4233");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4233");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4233.fb");
  }
}
static Arrange_To_Call_Me vSTT4233(Test_STT4233, "STT4233", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4243  {
  __tsi64 fa;
  __tsu64 bf:48;
  long fb;
};
//SIG(1 STT4243) C1{ FL FL:48 Fl}



static void Test_STT4243()
{
  {
    init_simple_test("STT4243");
    static STT4243 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4243)");
    check_field_offset(lv, fa, 0, "STT4243.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4243");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4243");
    check_field_offset(lv, fb, 16, "STT4243.fb");
  }
}
static Arrange_To_Call_Me vSTT4243(Test_STT4243, "STT4243", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT414  {
  __tsi64 fa;
  unsigned char  :0;
  __tsi64 fb;
};
//SIG(1 STT414) C1{ FL Fc:0 FL}



static void Test_STT414()
{
  {
    init_simple_test("STT414");
    static STT414 lv;
    check2(sizeof(lv), 16, "sizeof(STT414)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT414)");
    check_field_offset(lv, fa, 0, "STT414.fa");
    check_field_offset(lv, fb, 8, "STT414.fb");
  }
}
static Arrange_To_Call_Me vSTT414(Test_STT414, "STT414", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT424  {
  __tsi64 fa;
  unsigned short  :0;
  __tsi64 fb;
};
//SIG(1 STT424) C1{ FL Fs:0 FL}



static void Test_STT424()
{
  {
    init_simple_test("STT424");
    static STT424 lv;
    check2(sizeof(lv), 16, "sizeof(STT424)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT424)");
    check_field_offset(lv, fa, 0, "STT424.fa");
    check_field_offset(lv, fb, 8, "STT424.fb");
  }
}
static Arrange_To_Call_Me vSTT424(Test_STT424, "STT424", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT434  {
  __tsi64 fa;
  unsigned int  :0;
  __tsi64 fb;
};
//SIG(1 STT434) C1{ FL Fi:0 FL}



static void Test_STT434()
{
  {
    init_simple_test("STT434");
    static STT434 lv;
    check2(sizeof(lv), 16, "sizeof(STT434)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT434)");
    check_field_offset(lv, fa, 0, "STT434.fa");
    check_field_offset(lv, fb, 8, "STT434.fb");
  }
}
static Arrange_To_Call_Me vSTT434(Test_STT434, "STT434", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT444  {
  __tsi64 fa;
  __tsu64  :0;
  __tsi64 fb;
};
//SIG(1 STT444) C1{ FL FL:0 FL}



static void Test_STT444()
{
  {
    init_simple_test("STT444");
    static STT444 lv;
    check2(sizeof(lv), 16, "sizeof(STT444)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT444)");
    check_field_offset(lv, fa, 0, "STT444.fa");
    check_field_offset(lv, fb, 8, "STT444.fb");
  }
}
static Arrange_To_Call_Me vSTT444(Test_STT444, "STT444", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT454  {
  __tsi64 fa;
  unsigned char  :3;
  __tsi64 fb;
};
//SIG(1 STT454) C1{ FL Fc:3 FL}



static void Test_STT454()
{
  {
    init_simple_test("STT454");
    static STT454 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT454)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT454)");
    check_field_offset(lv, fa, 0, "STT454.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT454.fb");
  }
}
static Arrange_To_Call_Me vSTT454(Test_STT454, "STT454", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT464  {
  __tsi64 fa;
  unsigned short  :3;
  __tsi64 fb;
};
//SIG(1 STT464) C1{ FL Fs:3 FL}



static void Test_STT464()
{
  {
    init_simple_test("STT464");
    static STT464 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT464)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT464)");
    check_field_offset(lv, fa, 0, "STT464.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT464.fb");
  }
}
static Arrange_To_Call_Me vSTT464(Test_STT464, "STT464", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT474  {
  __tsi64 fa;
  unsigned int  :3;
  __tsi64 fb;
};
//SIG(1 STT474) C1{ FL Fi:3 FL}



static void Test_STT474()
{
  {
    init_simple_test("STT474");
    static STT474 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT474)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT474)");
    check_field_offset(lv, fa, 0, "STT474.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT474.fb");
  }
}
static Arrange_To_Call_Me vSTT474(Test_STT474, "STT474", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT484  {
  __tsi64 fa;
  __tsu64  :3;
  __tsi64 fb;
};
//SIG(1 STT484) C1{ FL FL:3 FL}



static void Test_STT484()
{
  {
    init_simple_test("STT484");
    static STT484 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT484)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT484)");
    check_field_offset(lv, fa, 0, "STT484.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT484.fb");
  }
}
static Arrange_To_Call_Me vSTT484(Test_STT484, "STT484", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT494  {
  __tsi64 fa;
  unsigned short  :8;
  __tsi64 fb;
};
//SIG(1 STT494) C1{ FL Fs:8 FL}



static void Test_STT494()
{
  {
    init_simple_test("STT494");
    static STT494 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT494)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT494)");
    check_field_offset(lv, fa, 0, "STT494.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT494.fb");
  }
}
static Arrange_To_Call_Me vSTT494(Test_STT494, "STT494", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4104  {
  __tsi64 fa;
  unsigned int  :8;
  __tsi64 fb;
};
//SIG(1 STT4104) C1{ FL Fi:8 FL}



static void Test_STT4104()
{
  {
    init_simple_test("STT4104");
    static STT4104 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4104)");
    check_field_offset(lv, fa, 0, "STT4104.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4104.fb");
  }
}
static Arrange_To_Call_Me vSTT4104(Test_STT4104, "STT4104", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4114  {
  __tsi64 fa;
  __tsu64  :8;
  __tsi64 fb;
};
//SIG(1 STT4114) C1{ FL FL:8 FL}



static void Test_STT4114()
{
  {
    init_simple_test("STT4114");
    static STT4114 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4114)");
    check_field_offset(lv, fa, 0, "STT4114.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4114.fb");
  }
}
static Arrange_To_Call_Me vSTT4114(Test_STT4114, "STT4114", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4124  {
  __tsi64 fa;
  unsigned int  :18;
  __tsi64 fb;
};
//SIG(1 STT4124) C1{ FL Fi:18 FL}



static void Test_STT4124()
{
  {
    init_simple_test("STT4124");
    static STT4124 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4124)");
    check_field_offset(lv, fa, 0, "STT4124.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4124.fb");
  }
}
static Arrange_To_Call_Me vSTT4124(Test_STT4124, "STT4124", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4134  {
  __tsi64 fa;
  __tsu64  :18;
  __tsi64 fb;
};
//SIG(1 STT4134) C1{ FL FL:18 FL}



static void Test_STT4134()
{
  {
    init_simple_test("STT4134");
    static STT4134 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4134)");
    check_field_offset(lv, fa, 0, "STT4134.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4134.fb");
  }
}
static Arrange_To_Call_Me vSTT4134(Test_STT4134, "STT4134", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4144  {
  __tsi64 fa;
  __tsu64  :48;
  __tsi64 fb;
};
//SIG(1 STT4144) C1{ FL FL:48 FL}



static void Test_STT4144()
{
  {
    init_simple_test("STT4144");
    static STT4144 lv;
    check2(sizeof(lv), 24, "sizeof(STT4144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4144)");
    check_field_offset(lv, fa, 0, "STT4144.fa");
    check_field_offset(lv, fb, 16, "STT4144.fb");
  }
}
static Arrange_To_Call_Me vSTT4144(Test_STT4144, "STT4144", 24);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4154  {
  __tsi64 fa;
  unsigned char bf:3;
  __tsi64 fb;
};
//SIG(1 STT4154) C1{ FL Fc:3 FL}



static void Test_STT4154()
{
  {
    init_simple_test("STT4154");
    static STT4154 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4154)");
    check_field_offset(lv, fa, 0, "STT4154.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4154");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4154");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4154.fb");
  }
}
static Arrange_To_Call_Me vSTT4154(Test_STT4154, "STT4154", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4164  {
  __tsi64 fa;
  unsigned short bf:3;
  __tsi64 fb;
};
//SIG(1 STT4164) C1{ FL Fs:3 FL}



static void Test_STT4164()
{
  {
    init_simple_test("STT4164");
    static STT4164 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4164)");
    check_field_offset(lv, fa, 0, "STT4164.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4164");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4164");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4164.fb");
  }
}
static Arrange_To_Call_Me vSTT4164(Test_STT4164, "STT4164", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4174  {
  __tsi64 fa;
  unsigned int bf:3;
  __tsi64 fb;
};
//SIG(1 STT4174) C1{ FL Fi:3 FL}



static void Test_STT4174()
{
  {
    init_simple_test("STT4174");
    static STT4174 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4174)");
    check_field_offset(lv, fa, 0, "STT4174.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4174");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4174");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4174.fb");
  }
}
static Arrange_To_Call_Me vSTT4174(Test_STT4174, "STT4174", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4184  {
  __tsi64 fa;
  __tsu64 bf:3;
  __tsi64 fb;
};
//SIG(1 STT4184) C1{ FL FL:3 FL}



static void Test_STT4184()
{
  {
    init_simple_test("STT4184");
    static STT4184 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4184)");
    check_field_offset(lv, fa, 0, "STT4184.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4184");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4184");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4184.fb");
  }
}
static Arrange_To_Call_Me vSTT4184(Test_STT4184, "STT4184", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4194  {
  __tsi64 fa;
  unsigned short bf:8;
  __tsi64 fb;
};
//SIG(1 STT4194) C1{ FL Fs:8 FL}



static void Test_STT4194()
{
  {
    init_simple_test("STT4194");
    static STT4194 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4194)");
    check_field_offset(lv, fa, 0, "STT4194.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4194");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4194");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4194.fb");
  }
}
static Arrange_To_Call_Me vSTT4194(Test_STT4194, "STT4194", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4204  {
  __tsi64 fa;
  unsigned int bf:8;
  __tsi64 fb;
};
//SIG(1 STT4204) C1{ FL Fi:8 FL}



static void Test_STT4204()
{
  {
    init_simple_test("STT4204");
    static STT4204 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4204)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4204)");
    check_field_offset(lv, fa, 0, "STT4204.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4204");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4204");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4204.fb");
  }
}
static Arrange_To_Call_Me vSTT4204(Test_STT4204, "STT4204", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4214  {
  __tsi64 fa;
  __tsu64 bf:8;
  __tsi64 fb;
};
//SIG(1 STT4214) C1{ FL FL:8 FL}



static void Test_STT4214()
{
  {
    init_simple_test("STT4214");
    static STT4214 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4214)");
    check_field_offset(lv, fa, 0, "STT4214.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4214");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4214");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4214.fb");
  }
}
static Arrange_To_Call_Me vSTT4214(Test_STT4214, "STT4214", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4224  {
  __tsi64 fa;
  unsigned int bf:18;
  __tsi64 fb;
};
//SIG(1 STT4224) C1{ FL Fi:18 FL}



static void Test_STT4224()
{
  {
    init_simple_test("STT4224");
    static STT4224 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4224)");
    check_field_offset(lv, fa, 0, "STT4224.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4224");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4224");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4224.fb");
  }
}
static Arrange_To_Call_Me vSTT4224(Test_STT4224, "STT4224", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4234  {
  __tsi64 fa;
  __tsu64 bf:18;
  __tsi64 fb;
};
//SIG(1 STT4234) C1{ FL FL:18 FL}



static void Test_STT4234()
{
  {
    init_simple_test("STT4234");
    static STT4234 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4234)");
    check_field_offset(lv, fa, 0, "STT4234.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4234");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4234");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4234.fb");
  }
}
static Arrange_To_Call_Me vSTT4234(Test_STT4234, "STT4234", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4244  {
  __tsi64 fa;
  __tsu64 bf:48;
  __tsi64 fb;
};
//SIG(1 STT4244) C1{ FL FL:48 FL}



static void Test_STT4244()
{
  {
    init_simple_test("STT4244");
    static STT4244 lv;
    check2(sizeof(lv), 24, "sizeof(STT4244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4244)");
    check_field_offset(lv, fa, 0, "STT4244.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4244");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4244");
    check_field_offset(lv, fb, 16, "STT4244.fb");
  }
}
static Arrange_To_Call_Me vSTT4244(Test_STT4244, "STT4244", 24);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT415  {
  __tsi64 fa;
  unsigned char  :0;
  void *fb;
};
//SIG(1 STT415) C1{ FL Fc:0 Fp}



static void Test_STT415()
{
  {
    init_simple_test("STT415");
    static STT415 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT415)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT415)");
    check_field_offset(lv, fa, 0, "STT415.fa");
    check_field_offset(lv, fb, 8, "STT415.fb");
  }
}
static Arrange_To_Call_Me vSTT415(Test_STT415, "STT415", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT425  {
  __tsi64 fa;
  unsigned short  :0;
  void *fb;
};
//SIG(1 STT425) C1{ FL Fs:0 Fp}



static void Test_STT425()
{
  {
    init_simple_test("STT425");
    static STT425 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT425)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT425)");
    check_field_offset(lv, fa, 0, "STT425.fa");
    check_field_offset(lv, fb, 8, "STT425.fb");
  }
}
static Arrange_To_Call_Me vSTT425(Test_STT425, "STT425", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT435  {
  __tsi64 fa;
  unsigned int  :0;
  void *fb;
};
//SIG(1 STT435) C1{ FL Fi:0 Fp}



static void Test_STT435()
{
  {
    init_simple_test("STT435");
    static STT435 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT435)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT435)");
    check_field_offset(lv, fa, 0, "STT435.fa");
    check_field_offset(lv, fb, 8, "STT435.fb");
  }
}
static Arrange_To_Call_Me vSTT435(Test_STT435, "STT435", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT445  {
  __tsi64 fa;
  __tsu64  :0;
  void *fb;
};
//SIG(1 STT445) C1{ FL FL:0 Fp}



static void Test_STT445()
{
  {
    init_simple_test("STT445");
    static STT445 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT445)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT445)");
    check_field_offset(lv, fa, 0, "STT445.fa");
    check_field_offset(lv, fb, 8, "STT445.fb");
  }
}
static Arrange_To_Call_Me vSTT445(Test_STT445, "STT445", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT455  {
  __tsi64 fa;
  unsigned char  :3;
  void *fb;
};
//SIG(1 STT455) C1{ FL Fc:3 Fp}



static void Test_STT455()
{
  {
    init_simple_test("STT455");
    static STT455 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT455)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT455)");
    check_field_offset(lv, fa, 0, "STT455.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT455.fb");
  }
}
static Arrange_To_Call_Me vSTT455(Test_STT455, "STT455", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT465  {
  __tsi64 fa;
  unsigned short  :3;
  void *fb;
};
//SIG(1 STT465) C1{ FL Fs:3 Fp}



static void Test_STT465()
{
  {
    init_simple_test("STT465");
    static STT465 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT465)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT465)");
    check_field_offset(lv, fa, 0, "STT465.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT465.fb");
  }
}
static Arrange_To_Call_Me vSTT465(Test_STT465, "STT465", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT475  {
  __tsi64 fa;
  unsigned int  :3;
  void *fb;
};
//SIG(1 STT475) C1{ FL Fi:3 Fp}



static void Test_STT475()
{
  {
    init_simple_test("STT475");
    static STT475 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT475)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT475)");
    check_field_offset(lv, fa, 0, "STT475.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT475.fb");
  }
}
static Arrange_To_Call_Me vSTT475(Test_STT475, "STT475", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT485  {
  __tsi64 fa;
  __tsu64  :3;
  void *fb;
};
//SIG(1 STT485) C1{ FL FL:3 Fp}



static void Test_STT485()
{
  {
    init_simple_test("STT485");
    static STT485 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT485)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT485)");
    check_field_offset(lv, fa, 0, "STT485.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT485.fb");
  }
}
static Arrange_To_Call_Me vSTT485(Test_STT485, "STT485", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT495  {
  __tsi64 fa;
  unsigned short  :8;
  void *fb;
};
//SIG(1 STT495) C1{ FL Fs:8 Fp}



static void Test_STT495()
{
  {
    init_simple_test("STT495");
    static STT495 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT495)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT495)");
    check_field_offset(lv, fa, 0, "STT495.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT495.fb");
  }
}
static Arrange_To_Call_Me vSTT495(Test_STT495, "STT495", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4105  {
  __tsi64 fa;
  unsigned int  :8;
  void *fb;
};
//SIG(1 STT4105) C1{ FL Fi:8 Fp}



static void Test_STT4105()
{
  {
    init_simple_test("STT4105");
    static STT4105 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4105)");
    check_field_offset(lv, fa, 0, "STT4105.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4105.fb");
  }
}
static Arrange_To_Call_Me vSTT4105(Test_STT4105, "STT4105", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4115  {
  __tsi64 fa;
  __tsu64  :8;
  void *fb;
};
//SIG(1 STT4115) C1{ FL FL:8 Fp}



static void Test_STT4115()
{
  {
    init_simple_test("STT4115");
    static STT4115 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4115)");
    check_field_offset(lv, fa, 0, "STT4115.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4115.fb");
  }
}
static Arrange_To_Call_Me vSTT4115(Test_STT4115, "STT4115", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4125  {
  __tsi64 fa;
  unsigned int  :18;
  void *fb;
};
//SIG(1 STT4125) C1{ FL Fi:18 Fp}



static void Test_STT4125()
{
  {
    init_simple_test("STT4125");
    static STT4125 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4125)");
    check_field_offset(lv, fa, 0, "STT4125.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4125.fb");
  }
}
static Arrange_To_Call_Me vSTT4125(Test_STT4125, "STT4125", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4135  {
  __tsi64 fa;
  __tsu64  :18;
  void *fb;
};
//SIG(1 STT4135) C1{ FL FL:18 Fp}



static void Test_STT4135()
{
  {
    init_simple_test("STT4135");
    static STT4135 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4135)");
    check_field_offset(lv, fa, 0, "STT4135.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4135.fb");
  }
}
static Arrange_To_Call_Me vSTT4135(Test_STT4135, "STT4135", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4145  {
  __tsi64 fa;
  __tsu64  :48;
  void *fb;
};
//SIG(1 STT4145) C1{ FL FL:48 Fp}



static void Test_STT4145()
{
  {
    init_simple_test("STT4145");
    static STT4145 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4145)");
    check_field_offset(lv, fa, 0, "STT4145.fa");
    check_field_offset(lv, fb, 16, "STT4145.fb");
  }
}
static Arrange_To_Call_Me vSTT4145(Test_STT4145, "STT4145", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4155  {
  __tsi64 fa;
  unsigned char bf:3;
  void *fb;
};
//SIG(1 STT4155) C1{ FL Fc:3 Fp}



static void Test_STT4155()
{
  {
    init_simple_test("STT4155");
    static STT4155 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4155)");
    check_field_offset(lv, fa, 0, "STT4155.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4155");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4155");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4155.fb");
  }
}
static Arrange_To_Call_Me vSTT4155(Test_STT4155, "STT4155", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4165  {
  __tsi64 fa;
  unsigned short bf:3;
  void *fb;
};
//SIG(1 STT4165) C1{ FL Fs:3 Fp}



static void Test_STT4165()
{
  {
    init_simple_test("STT4165");
    static STT4165 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4165)");
    check_field_offset(lv, fa, 0, "STT4165.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4165");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4165");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4165.fb");
  }
}
static Arrange_To_Call_Me vSTT4165(Test_STT4165, "STT4165", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4175  {
  __tsi64 fa;
  unsigned int bf:3;
  void *fb;
};
//SIG(1 STT4175) C1{ FL Fi:3 Fp}



static void Test_STT4175()
{
  {
    init_simple_test("STT4175");
    static STT4175 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4175)");
    check_field_offset(lv, fa, 0, "STT4175.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4175");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4175");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4175.fb");
  }
}
static Arrange_To_Call_Me vSTT4175(Test_STT4175, "STT4175", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4185  {
  __tsi64 fa;
  __tsu64 bf:3;
  void *fb;
};
//SIG(1 STT4185) C1{ FL FL:3 Fp}



static void Test_STT4185()
{
  {
    init_simple_test("STT4185");
    static STT4185 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4185)");
    check_field_offset(lv, fa, 0, "STT4185.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4185");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4185");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4185.fb");
  }
}
static Arrange_To_Call_Me vSTT4185(Test_STT4185, "STT4185", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4195  {
  __tsi64 fa;
  unsigned short bf:8;
  void *fb;
};
//SIG(1 STT4195) C1{ FL Fs:8 Fp}



static void Test_STT4195()
{
  {
    init_simple_test("STT4195");
    static STT4195 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4195)");
    check_field_offset(lv, fa, 0, "STT4195.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4195");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4195");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4195.fb");
  }
}
static Arrange_To_Call_Me vSTT4195(Test_STT4195, "STT4195", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4205  {
  __tsi64 fa;
  unsigned int bf:8;
  void *fb;
};
//SIG(1 STT4205) C1{ FL Fi:8 Fp}



static void Test_STT4205()
{
  {
    init_simple_test("STT4205");
    static STT4205 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4205)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4205)");
    check_field_offset(lv, fa, 0, "STT4205.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4205");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4205");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4205.fb");
  }
}
static Arrange_To_Call_Me vSTT4205(Test_STT4205, "STT4205", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4215  {
  __tsi64 fa;
  __tsu64 bf:8;
  void *fb;
};
//SIG(1 STT4215) C1{ FL FL:8 Fp}



static void Test_STT4215()
{
  {
    init_simple_test("STT4215");
    static STT4215 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4215)");
    check_field_offset(lv, fa, 0, "STT4215.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4215");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4215");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4215.fb");
  }
}
static Arrange_To_Call_Me vSTT4215(Test_STT4215, "STT4215", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4225  {
  __tsi64 fa;
  unsigned int bf:18;
  void *fb;
};
//SIG(1 STT4225) C1{ FL Fi:18 Fp}



static void Test_STT4225()
{
  {
    init_simple_test("STT4225");
    static STT4225 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4225)");
    check_field_offset(lv, fa, 0, "STT4225.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4225");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4225");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4225.fb");
  }
}
static Arrange_To_Call_Me vSTT4225(Test_STT4225, "STT4225", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4235  {
  __tsi64 fa;
  __tsu64 bf:18;
  void *fb;
};
//SIG(1 STT4235) C1{ FL FL:18 Fp}



static void Test_STT4235()
{
  {
    init_simple_test("STT4235");
    static STT4235 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT4235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4235)");
    check_field_offset(lv, fa, 0, "STT4235.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4235");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4235");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4235.fb");
  }
}
static Arrange_To_Call_Me vSTT4235(Test_STT4235, "STT4235", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4245  {
  __tsi64 fa;
  __tsu64 bf:48;
  void *fb;
};
//SIG(1 STT4245) C1{ FL FL:48 Fp}



static void Test_STT4245()
{
  {
    init_simple_test("STT4245");
    static STT4245 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4245)");
    check_field_offset(lv, fa, 0, "STT4245.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4245");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4245");
    check_field_offset(lv, fb, 16, "STT4245.fb");
  }
}
static Arrange_To_Call_Me vSTT4245(Test_STT4245, "STT4245", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT416  {
  __tsi64 fa;
  unsigned char  :0;
  float fb;
};
//SIG(1 STT416) C1{ FL Fc:0 Fi}



static void Test_STT416()
{
  {
    init_simple_test("STT416");
    static STT416 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT416)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT416)");
    check_field_offset(lv, fa, 0, "STT416.fa");
    check_field_offset(lv, fb, 8, "STT416.fb");
  }
}
static Arrange_To_Call_Me vSTT416(Test_STT416, "STT416", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT426  {
  __tsi64 fa;
  unsigned short  :0;
  float fb;
};
//SIG(1 STT426) C1{ FL Fs:0 Fi}



static void Test_STT426()
{
  {
    init_simple_test("STT426");
    static STT426 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT426)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT426)");
    check_field_offset(lv, fa, 0, "STT426.fa");
    check_field_offset(lv, fb, 8, "STT426.fb");
  }
}
static Arrange_To_Call_Me vSTT426(Test_STT426, "STT426", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT436  {
  __tsi64 fa;
  unsigned int  :0;
  float fb;
};
//SIG(1 STT436) C1{ FL Fi:0 Fi}



static void Test_STT436()
{
  {
    init_simple_test("STT436");
    static STT436 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT436)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT436)");
    check_field_offset(lv, fa, 0, "STT436.fa");
    check_field_offset(lv, fb, 8, "STT436.fb");
  }
}
static Arrange_To_Call_Me vSTT436(Test_STT436, "STT436", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT446  {
  __tsi64 fa;
  __tsu64  :0;
  float fb;
};
//SIG(1 STT446) C1{ FL FL:0 Fi}



static void Test_STT446()
{
  {
    init_simple_test("STT446");
    static STT446 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT446)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT446)");
    check_field_offset(lv, fa, 0, "STT446.fa");
    check_field_offset(lv, fb, 8, "STT446.fb");
  }
}
static Arrange_To_Call_Me vSTT446(Test_STT446, "STT446", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT456  {
  __tsi64 fa;
  unsigned char  :3;
  float fb;
};
//SIG(1 STT456) C1{ FL Fc:3 Fi}



static void Test_STT456()
{
  {
    init_simple_test("STT456");
    static STT456 lv;
    check2(sizeof(lv), 16, "sizeof(STT456)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT456)");
    check_field_offset(lv, fa, 0, "STT456.fa");
    check_field_offset(lv, fb, 12, "STT456.fb");
  }
}
static Arrange_To_Call_Me vSTT456(Test_STT456, "STT456", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT466  {
  __tsi64 fa;
  unsigned short  :3;
  float fb;
};
//SIG(1 STT466) C1{ FL Fs:3 Fi}



static void Test_STT466()
{
  {
    init_simple_test("STT466");
    static STT466 lv;
    check2(sizeof(lv), 16, "sizeof(STT466)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT466)");
    check_field_offset(lv, fa, 0, "STT466.fa");
    check_field_offset(lv, fb, 12, "STT466.fb");
  }
}
static Arrange_To_Call_Me vSTT466(Test_STT466, "STT466", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT476  {
  __tsi64 fa;
  unsigned int  :3;
  float fb;
};
//SIG(1 STT476) C1{ FL Fi:3 Fi}



static void Test_STT476()
{
  {
    init_simple_test("STT476");
    static STT476 lv;
    check2(sizeof(lv), 16, "sizeof(STT476)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT476)");
    check_field_offset(lv, fa, 0, "STT476.fa");
    check_field_offset(lv, fb, 12, "STT476.fb");
  }
}
static Arrange_To_Call_Me vSTT476(Test_STT476, "STT476", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT486  {
  __tsi64 fa;
  __tsu64  :3;
  float fb;
};
//SIG(1 STT486) C1{ FL FL:3 Fi}



static void Test_STT486()
{
  {
    init_simple_test("STT486");
    static STT486 lv;
    check2(sizeof(lv), 16, "sizeof(STT486)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT486)");
    check_field_offset(lv, fa, 0, "STT486.fa");
    check_field_offset(lv, fb, 12, "STT486.fb");
  }
}
static Arrange_To_Call_Me vSTT486(Test_STT486, "STT486", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT496  {
  __tsi64 fa;
  unsigned short  :8;
  float fb;
};
//SIG(1 STT496) C1{ FL Fs:8 Fi}



static void Test_STT496()
{
  {
    init_simple_test("STT496");
    static STT496 lv;
    check2(sizeof(lv), 16, "sizeof(STT496)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT496)");
    check_field_offset(lv, fa, 0, "STT496.fa");
    check_field_offset(lv, fb, 12, "STT496.fb");
  }
}
static Arrange_To_Call_Me vSTT496(Test_STT496, "STT496", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4106  {
  __tsi64 fa;
  unsigned int  :8;
  float fb;
};
//SIG(1 STT4106) C1{ FL Fi:8 Fi}



static void Test_STT4106()
{
  {
    init_simple_test("STT4106");
    static STT4106 lv;
    check2(sizeof(lv), 16, "sizeof(STT4106)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4106)");
    check_field_offset(lv, fa, 0, "STT4106.fa");
    check_field_offset(lv, fb, 12, "STT4106.fb");
  }
}
static Arrange_To_Call_Me vSTT4106(Test_STT4106, "STT4106", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4116  {
  __tsi64 fa;
  __tsu64  :8;
  float fb;
};
//SIG(1 STT4116) C1{ FL FL:8 Fi}



static void Test_STT4116()
{
  {
    init_simple_test("STT4116");
    static STT4116 lv;
    check2(sizeof(lv), 16, "sizeof(STT4116)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4116)");
    check_field_offset(lv, fa, 0, "STT4116.fa");
    check_field_offset(lv, fb, 12, "STT4116.fb");
  }
}
static Arrange_To_Call_Me vSTT4116(Test_STT4116, "STT4116", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4126  {
  __tsi64 fa;
  unsigned int  :18;
  float fb;
};
//SIG(1 STT4126) C1{ FL Fi:18 Fi}



static void Test_STT4126()
{
  {
    init_simple_test("STT4126");
    static STT4126 lv;
    check2(sizeof(lv), 16, "sizeof(STT4126)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4126)");
    check_field_offset(lv, fa, 0, "STT4126.fa");
    check_field_offset(lv, fb, 12, "STT4126.fb");
  }
}
static Arrange_To_Call_Me vSTT4126(Test_STT4126, "STT4126", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4136  {
  __tsi64 fa;
  __tsu64  :18;
  float fb;
};
//SIG(1 STT4136) C1{ FL FL:18 Fi}



static void Test_STT4136()
{
  {
    init_simple_test("STT4136");
    static STT4136 lv;
    check2(sizeof(lv), 16, "sizeof(STT4136)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4136)");
    check_field_offset(lv, fa, 0, "STT4136.fa");
    check_field_offset(lv, fb, 12, "STT4136.fb");
  }
}
static Arrange_To_Call_Me vSTT4136(Test_STT4136, "STT4136", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4146  {
  __tsi64 fa;
  __tsu64  :48;
  float fb;
};
//SIG(1 STT4146) C1{ FL FL:48 Fi}



static void Test_STT4146()
{
  {
    init_simple_test("STT4146");
    static STT4146 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4146)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4146)");
    check_field_offset(lv, fa, 0, "STT4146.fa");
    check_field_offset(lv, fb, 16, "STT4146.fb");
  }
}
static Arrange_To_Call_Me vSTT4146(Test_STT4146, "STT4146", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4156  {
  __tsi64 fa;
  unsigned char bf:3;
  float fb;
};
//SIG(1 STT4156) C1{ FL Fc:3 Fi}



static void Test_STT4156()
{
  {
    init_simple_test("STT4156");
    static STT4156 lv;
    check2(sizeof(lv), 16, "sizeof(STT4156)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4156)");
    check_field_offset(lv, fa, 0, "STT4156.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4156");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4156");
    check_field_offset(lv, fb, 12, "STT4156.fb");
  }
}
static Arrange_To_Call_Me vSTT4156(Test_STT4156, "STT4156", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4166  {
  __tsi64 fa;
  unsigned short bf:3;
  float fb;
};
//SIG(1 STT4166) C1{ FL Fs:3 Fi}



static void Test_STT4166()
{
  {
    init_simple_test("STT4166");
    static STT4166 lv;
    check2(sizeof(lv), 16, "sizeof(STT4166)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4166)");
    check_field_offset(lv, fa, 0, "STT4166.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4166");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4166");
    check_field_offset(lv, fb, 12, "STT4166.fb");
  }
}
static Arrange_To_Call_Me vSTT4166(Test_STT4166, "STT4166", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4176  {
  __tsi64 fa;
  unsigned int bf:3;
  float fb;
};
//SIG(1 STT4176) C1{ FL Fi:3 Fi}



static void Test_STT4176()
{
  {
    init_simple_test("STT4176");
    static STT4176 lv;
    check2(sizeof(lv), 16, "sizeof(STT4176)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4176)");
    check_field_offset(lv, fa, 0, "STT4176.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4176");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4176");
    check_field_offset(lv, fb, 12, "STT4176.fb");
  }
}
static Arrange_To_Call_Me vSTT4176(Test_STT4176, "STT4176", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4186  {
  __tsi64 fa;
  __tsu64 bf:3;
  float fb;
};
//SIG(1 STT4186) C1{ FL FL:3 Fi}



static void Test_STT4186()
{
  {
    init_simple_test("STT4186");
    static STT4186 lv;
    check2(sizeof(lv), 16, "sizeof(STT4186)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4186)");
    check_field_offset(lv, fa, 0, "STT4186.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4186");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4186");
    check_field_offset(lv, fb, 12, "STT4186.fb");
  }
}
static Arrange_To_Call_Me vSTT4186(Test_STT4186, "STT4186", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4196  {
  __tsi64 fa;
  unsigned short bf:8;
  float fb;
};
//SIG(1 STT4196) C1{ FL Fs:8 Fi}



static void Test_STT4196()
{
  {
    init_simple_test("STT4196");
    static STT4196 lv;
    check2(sizeof(lv), 16, "sizeof(STT4196)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4196)");
    check_field_offset(lv, fa, 0, "STT4196.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4196");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4196");
    check_field_offset(lv, fb, 12, "STT4196.fb");
  }
}
static Arrange_To_Call_Me vSTT4196(Test_STT4196, "STT4196", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4206  {
  __tsi64 fa;
  unsigned int bf:8;
  float fb;
};
//SIG(1 STT4206) C1{ FL Fi:8 Fi}



static void Test_STT4206()
{
  {
    init_simple_test("STT4206");
    static STT4206 lv;
    check2(sizeof(lv), 16, "sizeof(STT4206)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4206)");
    check_field_offset(lv, fa, 0, "STT4206.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4206");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4206");
    check_field_offset(lv, fb, 12, "STT4206.fb");
  }
}
static Arrange_To_Call_Me vSTT4206(Test_STT4206, "STT4206", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4216  {
  __tsi64 fa;
  __tsu64 bf:8;
  float fb;
};
//SIG(1 STT4216) C1{ FL FL:8 Fi}



static void Test_STT4216()
{
  {
    init_simple_test("STT4216");
    static STT4216 lv;
    check2(sizeof(lv), 16, "sizeof(STT4216)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4216)");
    check_field_offset(lv, fa, 0, "STT4216.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4216");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4216");
    check_field_offset(lv, fb, 12, "STT4216.fb");
  }
}
static Arrange_To_Call_Me vSTT4216(Test_STT4216, "STT4216", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4226  {
  __tsi64 fa;
  unsigned int bf:18;
  float fb;
};
//SIG(1 STT4226) C1{ FL Fi:18 Fi}



static void Test_STT4226()
{
  {
    init_simple_test("STT4226");
    static STT4226 lv;
    check2(sizeof(lv), 16, "sizeof(STT4226)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4226)");
    check_field_offset(lv, fa, 0, "STT4226.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4226");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4226");
    check_field_offset(lv, fb, 12, "STT4226.fb");
  }
}
static Arrange_To_Call_Me vSTT4226(Test_STT4226, "STT4226", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4236  {
  __tsi64 fa;
  __tsu64 bf:18;
  float fb;
};
//SIG(1 STT4236) C1{ FL FL:18 Fi}



static void Test_STT4236()
{
  {
    init_simple_test("STT4236");
    static STT4236 lv;
    check2(sizeof(lv), 16, "sizeof(STT4236)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4236)");
    check_field_offset(lv, fa, 0, "STT4236.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4236");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4236");
    check_field_offset(lv, fb, 12, "STT4236.fb");
  }
}
static Arrange_To_Call_Me vSTT4236(Test_STT4236, "STT4236", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4246  {
  __tsi64 fa;
  __tsu64 bf:48;
  float fb;
};
//SIG(1 STT4246) C1{ FL FL:48 Fi}



static void Test_STT4246()
{
  {
    init_simple_test("STT4246");
    static STT4246 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4246)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4246)");
    check_field_offset(lv, fa, 0, "STT4246.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4246");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4246");
    check_field_offset(lv, fb, 16, "STT4246.fb");
  }
}
static Arrange_To_Call_Me vSTT4246(Test_STT4246, "STT4246", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT417  {
  __tsi64 fa;
  unsigned char  :0;
  double fb;
};
//SIG(1 STT417) C1{ FL Fc:0 FL}



static void Test_STT417()
{
  {
    init_simple_test("STT417");
    static STT417 lv;
    check2(sizeof(lv), 16, "sizeof(STT417)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT417)");
    check_field_offset(lv, fa, 0, "STT417.fa");
    check_field_offset(lv, fb, 8, "STT417.fb");
  }
}
static Arrange_To_Call_Me vSTT417(Test_STT417, "STT417", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT427  {
  __tsi64 fa;
  unsigned short  :0;
  double fb;
};
//SIG(1 STT427) C1{ FL Fs:0 FL}



static void Test_STT427()
{
  {
    init_simple_test("STT427");
    static STT427 lv;
    check2(sizeof(lv), 16, "sizeof(STT427)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT427)");
    check_field_offset(lv, fa, 0, "STT427.fa");
    check_field_offset(lv, fb, 8, "STT427.fb");
  }
}
static Arrange_To_Call_Me vSTT427(Test_STT427, "STT427", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT437  {
  __tsi64 fa;
  unsigned int  :0;
  double fb;
};
//SIG(1 STT437) C1{ FL Fi:0 FL}



static void Test_STT437()
{
  {
    init_simple_test("STT437");
    static STT437 lv;
    check2(sizeof(lv), 16, "sizeof(STT437)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT437)");
    check_field_offset(lv, fa, 0, "STT437.fa");
    check_field_offset(lv, fb, 8, "STT437.fb");
  }
}
static Arrange_To_Call_Me vSTT437(Test_STT437, "STT437", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT447  {
  __tsi64 fa;
  __tsu64  :0;
  double fb;
};
//SIG(1 STT447) C1{ FL FL:0 FL}



static void Test_STT447()
{
  {
    init_simple_test("STT447");
    static STT447 lv;
    check2(sizeof(lv), 16, "sizeof(STT447)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT447)");
    check_field_offset(lv, fa, 0, "STT447.fa");
    check_field_offset(lv, fb, 8, "STT447.fb");
  }
}
static Arrange_To_Call_Me vSTT447(Test_STT447, "STT447", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT457  {
  __tsi64 fa;
  unsigned char  :3;
  double fb;
};
//SIG(1 STT457) C1{ FL Fc:3 FL}



static void Test_STT457()
{
  {
    init_simple_test("STT457");
    static STT457 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT457)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT457)");
    check_field_offset(lv, fa, 0, "STT457.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT457.fb");
  }
}
static Arrange_To_Call_Me vSTT457(Test_STT457, "STT457", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT467  {
  __tsi64 fa;
  unsigned short  :3;
  double fb;
};
//SIG(1 STT467) C1{ FL Fs:3 FL}



static void Test_STT467()
{
  {
    init_simple_test("STT467");
    static STT467 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT467)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT467)");
    check_field_offset(lv, fa, 0, "STT467.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT467.fb");
  }
}
static Arrange_To_Call_Me vSTT467(Test_STT467, "STT467", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT477  {
  __tsi64 fa;
  unsigned int  :3;
  double fb;
};
//SIG(1 STT477) C1{ FL Fi:3 FL}



static void Test_STT477()
{
  {
    init_simple_test("STT477");
    static STT477 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT477)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT477)");
    check_field_offset(lv, fa, 0, "STT477.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT477.fb");
  }
}
static Arrange_To_Call_Me vSTT477(Test_STT477, "STT477", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT487  {
  __tsi64 fa;
  __tsu64  :3;
  double fb;
};
//SIG(1 STT487) C1{ FL FL:3 FL}



static void Test_STT487()
{
  {
    init_simple_test("STT487");
    static STT487 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT487)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT487)");
    check_field_offset(lv, fa, 0, "STT487.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT487.fb");
  }
}
static Arrange_To_Call_Me vSTT487(Test_STT487, "STT487", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT497  {
  __tsi64 fa;
  unsigned short  :8;
  double fb;
};
//SIG(1 STT497) C1{ FL Fs:8 FL}



static void Test_STT497()
{
  {
    init_simple_test("STT497");
    static STT497 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT497)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT497)");
    check_field_offset(lv, fa, 0, "STT497.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT497.fb");
  }
}
static Arrange_To_Call_Me vSTT497(Test_STT497, "STT497", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4107  {
  __tsi64 fa;
  unsigned int  :8;
  double fb;
};
//SIG(1 STT4107) C1{ FL Fi:8 FL}



static void Test_STT4107()
{
  {
    init_simple_test("STT4107");
    static STT4107 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4107)");
    check_field_offset(lv, fa, 0, "STT4107.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4107.fb");
  }
}
static Arrange_To_Call_Me vSTT4107(Test_STT4107, "STT4107", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4117  {
  __tsi64 fa;
  __tsu64  :8;
  double fb;
};
//SIG(1 STT4117) C1{ FL FL:8 FL}



static void Test_STT4117()
{
  {
    init_simple_test("STT4117");
    static STT4117 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4117)");
    check_field_offset(lv, fa, 0, "STT4117.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4117.fb");
  }
}
static Arrange_To_Call_Me vSTT4117(Test_STT4117, "STT4117", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4127  {
  __tsi64 fa;
  unsigned int  :18;
  double fb;
};
//SIG(1 STT4127) C1{ FL Fi:18 FL}



static void Test_STT4127()
{
  {
    init_simple_test("STT4127");
    static STT4127 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4127)");
    check_field_offset(lv, fa, 0, "STT4127.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4127.fb");
  }
}
static Arrange_To_Call_Me vSTT4127(Test_STT4127, "STT4127", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4137  {
  __tsi64 fa;
  __tsu64  :18;
  double fb;
};
//SIG(1 STT4137) C1{ FL FL:18 FL}



static void Test_STT4137()
{
  {
    init_simple_test("STT4137");
    static STT4137 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4137)");
    check_field_offset(lv, fa, 0, "STT4137.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4137.fb");
  }
}
static Arrange_To_Call_Me vSTT4137(Test_STT4137, "STT4137", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4147  {
  __tsi64 fa;
  __tsu64  :48;
  double fb;
};
//SIG(1 STT4147) C1{ FL FL:48 FL}



static void Test_STT4147()
{
  {
    init_simple_test("STT4147");
    static STT4147 lv;
    check2(sizeof(lv), 24, "sizeof(STT4147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4147)");
    check_field_offset(lv, fa, 0, "STT4147.fa");
    check_field_offset(lv, fb, 16, "STT4147.fb");
  }
}
static Arrange_To_Call_Me vSTT4147(Test_STT4147, "STT4147", 24);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4157  {
  __tsi64 fa;
  unsigned char bf:3;
  double fb;
};
//SIG(1 STT4157) C1{ FL Fc:3 FL}



static void Test_STT4157()
{
  {
    init_simple_test("STT4157");
    static STT4157 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4157)");
    check_field_offset(lv, fa, 0, "STT4157.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4157");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4157");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4157.fb");
  }
}
static Arrange_To_Call_Me vSTT4157(Test_STT4157, "STT4157", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4167  {
  __tsi64 fa;
  unsigned short bf:3;
  double fb;
};
//SIG(1 STT4167) C1{ FL Fs:3 FL}



static void Test_STT4167()
{
  {
    init_simple_test("STT4167");
    static STT4167 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4167)");
    check_field_offset(lv, fa, 0, "STT4167.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4167");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4167");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4167.fb");
  }
}
static Arrange_To_Call_Me vSTT4167(Test_STT4167, "STT4167", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4177  {
  __tsi64 fa;
  unsigned int bf:3;
  double fb;
};
//SIG(1 STT4177) C1{ FL Fi:3 FL}



static void Test_STT4177()
{
  {
    init_simple_test("STT4177");
    static STT4177 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4177)");
    check_field_offset(lv, fa, 0, "STT4177.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4177");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4177");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4177.fb");
  }
}
static Arrange_To_Call_Me vSTT4177(Test_STT4177, "STT4177", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4187  {
  __tsi64 fa;
  __tsu64 bf:3;
  double fb;
};
//SIG(1 STT4187) C1{ FL FL:3 FL}



static void Test_STT4187()
{
  {
    init_simple_test("STT4187");
    static STT4187 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4187)");
    check_field_offset(lv, fa, 0, "STT4187.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4187");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4187");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4187.fb");
  }
}
static Arrange_To_Call_Me vSTT4187(Test_STT4187, "STT4187", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4197  {
  __tsi64 fa;
  unsigned short bf:8;
  double fb;
};
//SIG(1 STT4197) C1{ FL Fs:8 FL}



static void Test_STT4197()
{
  {
    init_simple_test("STT4197");
    static STT4197 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4197)");
    check_field_offset(lv, fa, 0, "STT4197.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4197");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4197");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4197.fb");
  }
}
static Arrange_To_Call_Me vSTT4197(Test_STT4197, "STT4197", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4207  {
  __tsi64 fa;
  unsigned int bf:8;
  double fb;
};
//SIG(1 STT4207) C1{ FL Fi:8 FL}



static void Test_STT4207()
{
  {
    init_simple_test("STT4207");
    static STT4207 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4207)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4207)");
    check_field_offset(lv, fa, 0, "STT4207.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4207");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4207");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4207.fb");
  }
}
static Arrange_To_Call_Me vSTT4207(Test_STT4207, "STT4207", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4217  {
  __tsi64 fa;
  __tsu64 bf:8;
  double fb;
};
//SIG(1 STT4217) C1{ FL FL:8 FL}



static void Test_STT4217()
{
  {
    init_simple_test("STT4217");
    static STT4217 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4217)");
    check_field_offset(lv, fa, 0, "STT4217.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4217");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4217");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4217.fb");
  }
}
static Arrange_To_Call_Me vSTT4217(Test_STT4217, "STT4217", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4227  {
  __tsi64 fa;
  unsigned int bf:18;
  double fb;
};
//SIG(1 STT4227) C1{ FL Fi:18 FL}



static void Test_STT4227()
{
  {
    init_simple_test("STT4227");
    static STT4227 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4227)");
    check_field_offset(lv, fa, 0, "STT4227.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4227");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4227");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4227.fb");
  }
}
static Arrange_To_Call_Me vSTT4227(Test_STT4227, "STT4227", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4237  {
  __tsi64 fa;
  __tsu64 bf:18;
  double fb;
};
//SIG(1 STT4237) C1{ FL FL:18 FL}



static void Test_STT4237()
{
  {
    init_simple_test("STT4237");
    static STT4237 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT4237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4237)");
    check_field_offset(lv, fa, 0, "STT4237.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4237");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4237");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4237.fb");
  }
}
static Arrange_To_Call_Me vSTT4237(Test_STT4237, "STT4237", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4247  {
  __tsi64 fa;
  __tsu64 bf:48;
  double fb;
};
//SIG(1 STT4247) C1{ FL FL:48 FL}



static void Test_STT4247()
{
  {
    init_simple_test("STT4247");
    static STT4247 lv;
    check2(sizeof(lv), 24, "sizeof(STT4247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4247)");
    check_field_offset(lv, fa, 0, "STT4247.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4247");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4247");
    check_field_offset(lv, fb, 16, "STT4247.fb");
  }
}
static Arrange_To_Call_Me vSTT4247(Test_STT4247, "STT4247", 24);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT418  {
  __tsi64 fa;
  unsigned char  :0;
  long double fb;
};
//SIG(1 STT418) C1{ FL Fc:0 FD}



static void Test_STT418()
{
  {
    init_simple_test("STT418");
    static STT418 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT418)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT418)");
    check_field_offset(lv, fa, 0, "STT418.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT418.fb");
  }
}
static Arrange_To_Call_Me vSTT418(Test_STT418, "STT418", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT428  {
  __tsi64 fa;
  unsigned short  :0;
  long double fb;
};
//SIG(1 STT428) C1{ FL Fs:0 FD}



static void Test_STT428()
{
  {
    init_simple_test("STT428");
    static STT428 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT428)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT428)");
    check_field_offset(lv, fa, 0, "STT428.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT428.fb");
  }
}
static Arrange_To_Call_Me vSTT428(Test_STT428, "STT428", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT438  {
  __tsi64 fa;
  unsigned int  :0;
  long double fb;
};
//SIG(1 STT438) C1{ FL Fi:0 FD}



static void Test_STT438()
{
  {
    init_simple_test("STT438");
    static STT438 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT438)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT438)");
    check_field_offset(lv, fa, 0, "STT438.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT438.fb");
  }
}
static Arrange_To_Call_Me vSTT438(Test_STT438, "STT438", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT448  {
  __tsi64 fa;
  __tsu64  :0;
  long double fb;
};
//SIG(1 STT448) C1{ FL FL:0 FD}



static void Test_STT448()
{
  {
    init_simple_test("STT448");
    static STT448 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT448)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT448)");
    check_field_offset(lv, fa, 0, "STT448.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT448.fb");
  }
}
static Arrange_To_Call_Me vSTT448(Test_STT448, "STT448", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT458  {
  __tsi64 fa;
  unsigned char  :3;
  long double fb;
};
//SIG(1 STT458) C1{ FL Fc:3 FD}



static void Test_STT458()
{
  {
    init_simple_test("STT458");
    static STT458 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT458)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT458)");
    check_field_offset(lv, fa, 0, "STT458.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT458.fb");
  }
}
static Arrange_To_Call_Me vSTT458(Test_STT458, "STT458", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT468  {
  __tsi64 fa;
  unsigned short  :3;
  long double fb;
};
//SIG(1 STT468) C1{ FL Fs:3 FD}



static void Test_STT468()
{
  {
    init_simple_test("STT468");
    static STT468 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT468)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT468)");
    check_field_offset(lv, fa, 0, "STT468.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT468.fb");
  }
}
static Arrange_To_Call_Me vSTT468(Test_STT468, "STT468", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT478  {
  __tsi64 fa;
  unsigned int  :3;
  long double fb;
};
//SIG(1 STT478) C1{ FL Fi:3 FD}



static void Test_STT478()
{
  {
    init_simple_test("STT478");
    static STT478 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT478)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT478)");
    check_field_offset(lv, fa, 0, "STT478.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT478.fb");
  }
}
static Arrange_To_Call_Me vSTT478(Test_STT478, "STT478", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT488  {
  __tsi64 fa;
  __tsu64  :3;
  long double fb;
};
//SIG(1 STT488) C1{ FL FL:3 FD}



static void Test_STT488()
{
  {
    init_simple_test("STT488");
    static STT488 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT488)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT488)");
    check_field_offset(lv, fa, 0, "STT488.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT488.fb");
  }
}
static Arrange_To_Call_Me vSTT488(Test_STT488, "STT488", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT498  {
  __tsi64 fa;
  unsigned short  :8;
  long double fb;
};
//SIG(1 STT498) C1{ FL Fs:8 FD}



static void Test_STT498()
{
  {
    init_simple_test("STT498");
    static STT498 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT498)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT498)");
    check_field_offset(lv, fa, 0, "STT498.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT498.fb");
  }
}
static Arrange_To_Call_Me vSTT498(Test_STT498, "STT498", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4108  {
  __tsi64 fa;
  unsigned int  :8;
  long double fb;
};
//SIG(1 STT4108) C1{ FL Fi:8 FD}



static void Test_STT4108()
{
  {
    init_simple_test("STT4108");
    static STT4108 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4108)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4108)");
    check_field_offset(lv, fa, 0, "STT4108.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4108.fb");
  }
}
static Arrange_To_Call_Me vSTT4108(Test_STT4108, "STT4108", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4118  {
  __tsi64 fa;
  __tsu64  :8;
  long double fb;
};
//SIG(1 STT4118) C1{ FL FL:8 FD}



static void Test_STT4118()
{
  {
    init_simple_test("STT4118");
    static STT4118 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4118)");
    check_field_offset(lv, fa, 0, "STT4118.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4118.fb");
  }
}
static Arrange_To_Call_Me vSTT4118(Test_STT4118, "STT4118", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4128  {
  __tsi64 fa;
  unsigned int  :18;
  long double fb;
};
//SIG(1 STT4128) C1{ FL Fi:18 FD}



static void Test_STT4128()
{
  {
    init_simple_test("STT4128");
    static STT4128 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4128)");
    check_field_offset(lv, fa, 0, "STT4128.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4128.fb");
  }
}
static Arrange_To_Call_Me vSTT4128(Test_STT4128, "STT4128", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4138  {
  __tsi64 fa;
  __tsu64  :18;
  long double fb;
};
//SIG(1 STT4138) C1{ FL FL:18 FD}



static void Test_STT4138()
{
  {
    init_simple_test("STT4138");
    static STT4138 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4138)");
    check_field_offset(lv, fa, 0, "STT4138.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4138.fb");
  }
}
static Arrange_To_Call_Me vSTT4138(Test_STT4138, "STT4138", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4148  {
  __tsi64 fa;
  __tsu64  :48;
  long double fb;
};
//SIG(1 STT4148) C1{ FL FL:48 FD}



static void Test_STT4148()
{
  {
    init_simple_test("STT4148");
    static STT4148 lv;
    check2(sizeof(lv), ABISELECT(32,28), "sizeof(STT4148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4148)");
    check_field_offset(lv, fa, 0, "STT4148.fa");
    check_field_offset(lv, fb, 16, "STT4148.fb");
  }
}
static Arrange_To_Call_Me vSTT4148(Test_STT4148, "STT4148", ABISELECT(32,28));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4158  {
  __tsi64 fa;
  unsigned char bf:3;
  long double fb;
};
//SIG(1 STT4158) C1{ FL Fc:3 FD}



static void Test_STT4158()
{
  {
    init_simple_test("STT4158");
    static STT4158 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4158)");
    check_field_offset(lv, fa, 0, "STT4158.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4158");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4158");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4158.fb");
  }
}
static Arrange_To_Call_Me vSTT4158(Test_STT4158, "STT4158", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4168  {
  __tsi64 fa;
  unsigned short bf:3;
  long double fb;
};
//SIG(1 STT4168) C1{ FL Fs:3 FD}



static void Test_STT4168()
{
  {
    init_simple_test("STT4168");
    static STT4168 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4168)");
    check_field_offset(lv, fa, 0, "STT4168.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4168");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4168");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4168.fb");
  }
}
static Arrange_To_Call_Me vSTT4168(Test_STT4168, "STT4168", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4178  {
  __tsi64 fa;
  unsigned int bf:3;
  long double fb;
};
//SIG(1 STT4178) C1{ FL Fi:3 FD}



static void Test_STT4178()
{
  {
    init_simple_test("STT4178");
    static STT4178 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4178)");
    check_field_offset(lv, fa, 0, "STT4178.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4178");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4178");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4178.fb");
  }
}
static Arrange_To_Call_Me vSTT4178(Test_STT4178, "STT4178", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4188  {
  __tsi64 fa;
  __tsu64 bf:3;
  long double fb;
};
//SIG(1 STT4188) C1{ FL FL:3 FD}



static void Test_STT4188()
{
  {
    init_simple_test("STT4188");
    static STT4188 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4188)");
    check_field_offset(lv, fa, 0, "STT4188.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4188");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4188");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4188.fb");
  }
}
static Arrange_To_Call_Me vSTT4188(Test_STT4188, "STT4188", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4198  {
  __tsi64 fa;
  unsigned short bf:8;
  long double fb;
};
//SIG(1 STT4198) C1{ FL Fs:8 FD}



static void Test_STT4198()
{
  {
    init_simple_test("STT4198");
    static STT4198 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4198)");
    check_field_offset(lv, fa, 0, "STT4198.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4198");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4198");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4198.fb");
  }
}
static Arrange_To_Call_Me vSTT4198(Test_STT4198, "STT4198", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4208  {
  __tsi64 fa;
  unsigned int bf:8;
  long double fb;
};
//SIG(1 STT4208) C1{ FL Fi:8 FD}



static void Test_STT4208()
{
  {
    init_simple_test("STT4208");
    static STT4208 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4208)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4208)");
    check_field_offset(lv, fa, 0, "STT4208.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4208");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4208");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4208.fb");
  }
}
static Arrange_To_Call_Me vSTT4208(Test_STT4208, "STT4208", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4218  {
  __tsi64 fa;
  __tsu64 bf:8;
  long double fb;
};
//SIG(1 STT4218) C1{ FL FL:8 FD}



static void Test_STT4218()
{
  {
    init_simple_test("STT4218");
    static STT4218 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4218)");
    check_field_offset(lv, fa, 0, "STT4218.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4218");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4218");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4218.fb");
  }
}
static Arrange_To_Call_Me vSTT4218(Test_STT4218, "STT4218", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4228  {
  __tsi64 fa;
  unsigned int bf:18;
  long double fb;
};
//SIG(1 STT4228) C1{ FL Fi:18 FD}



static void Test_STT4228()
{
  {
    init_simple_test("STT4228");
    static STT4228 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4228)");
    check_field_offset(lv, fa, 0, "STT4228.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4228");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4228");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4228.fb");
  }
}
static Arrange_To_Call_Me vSTT4228(Test_STT4228, "STT4228", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4238  {
  __tsi64 fa;
  __tsu64 bf:18;
  long double fb;
};
//SIG(1 STT4238) C1{ FL FL:18 FD}



static void Test_STT4238()
{
  {
    init_simple_test("STT4238");
    static STT4238 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT4238)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4238)");
    check_field_offset(lv, fa, 0, "STT4238.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4238");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4238");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT4238.fb");
  }
}
static Arrange_To_Call_Me vSTT4238(Test_STT4238, "STT4238", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4248  {
  __tsi64 fa;
  __tsu64 bf:48;
  long double fb;
};
//SIG(1 STT4248) C1{ FL FL:48 FD}



static void Test_STT4248()
{
  {
    init_simple_test("STT4248");
    static STT4248 lv;
    check2(sizeof(lv), ABISELECT(32,28), "sizeof(STT4248)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT4248)");
    check_field_offset(lv, fa, 0, "STT4248.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4248");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4248");
    check_field_offset(lv, fb, 16, "STT4248.fb");
  }
}
static Arrange_To_Call_Me vSTT4248(Test_STT4248, "STT4248", ABISELECT(32,28));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT419  {
  __tsi64 fa;
  unsigned char  :0;
};
//SIG(1 STT419) C1{ FL Fc:0}



static void Test_STT419()
{
  {
    init_simple_test("STT419");
    static STT419 lv;
    check2(sizeof(lv), 8, "sizeof(STT419)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT419)");
    check_field_offset(lv, fa, 0, "STT419.fa");
  }
}
static Arrange_To_Call_Me vSTT419(Test_STT419, "STT419", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT429  {
  __tsi64 fa;
  unsigned short  :0;
};
//SIG(1 STT429) C1{ FL Fs:0}



static void Test_STT429()
{
  {
    init_simple_test("STT429");
    static STT429 lv;
    check2(sizeof(lv), 8, "sizeof(STT429)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT429)");
    check_field_offset(lv, fa, 0, "STT429.fa");
  }
}
static Arrange_To_Call_Me vSTT429(Test_STT429, "STT429", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT439  {
  __tsi64 fa;
  unsigned int  :0;
};
//SIG(1 STT439) C1{ FL Fi:0}



static void Test_STT439()
{
  {
    init_simple_test("STT439");
    static STT439 lv;
    check2(sizeof(lv), 8, "sizeof(STT439)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT439)");
    check_field_offset(lv, fa, 0, "STT439.fa");
  }
}
static Arrange_To_Call_Me vSTT439(Test_STT439, "STT439", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT449  {
  __tsi64 fa;
  __tsu64  :0;
};
//SIG(1 STT449) C1{ FL FL:0}



static void Test_STT449()
{
  {
    init_simple_test("STT449");
    static STT449 lv;
    check2(sizeof(lv), 8, "sizeof(STT449)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT449)");
    check_field_offset(lv, fa, 0, "STT449.fa");
  }
}
static Arrange_To_Call_Me vSTT449(Test_STT449, "STT449", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT459  {
  __tsi64 fa;
  unsigned char  :3;
};
//SIG(1 STT459) C1{ FL Fc:3}



static void Test_STT459()
{
  {
    init_simple_test("STT459");
    static STT459 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT459)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT459)");
    check_field_offset(lv, fa, 0, "STT459.fa");
  }
}
static Arrange_To_Call_Me vSTT459(Test_STT459, "STT459", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT469  {
  __tsi64 fa;
  unsigned short  :3;
};
//SIG(1 STT469) C1{ FL Fs:3}



static void Test_STT469()
{
  {
    init_simple_test("STT469");
    static STT469 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT469)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT469)");
    check_field_offset(lv, fa, 0, "STT469.fa");
  }
}
static Arrange_To_Call_Me vSTT469(Test_STT469, "STT469", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT479  {
  __tsi64 fa;
  unsigned int  :3;
};
//SIG(1 STT479) C1{ FL Fi:3}



static void Test_STT479()
{
  {
    init_simple_test("STT479");
    static STT479 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT479)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT479)");
    check_field_offset(lv, fa, 0, "STT479.fa");
  }
}
static Arrange_To_Call_Me vSTT479(Test_STT479, "STT479", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT489  {
  __tsi64 fa;
  __tsu64  :3;
};
//SIG(1 STT489) C1{ FL FL:3}



static void Test_STT489()
{
  {
    init_simple_test("STT489");
    static STT489 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT489)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT489)");
    check_field_offset(lv, fa, 0, "STT489.fa");
  }
}
static Arrange_To_Call_Me vSTT489(Test_STT489, "STT489", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT499  {
  __tsi64 fa;
  unsigned short  :8;
};
//SIG(1 STT499) C1{ FL Fs:8}



static void Test_STT499()
{
  {
    init_simple_test("STT499");
    static STT499 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT499)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT499)");
    check_field_offset(lv, fa, 0, "STT499.fa");
  }
}
static Arrange_To_Call_Me vSTT499(Test_STT499, "STT499", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4109  {
  __tsi64 fa;
  unsigned int  :8;
};
//SIG(1 STT4109) C1{ FL Fi:8}



static void Test_STT4109()
{
  {
    init_simple_test("STT4109");
    static STT4109 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4109)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4109)");
    check_field_offset(lv, fa, 0, "STT4109.fa");
  }
}
static Arrange_To_Call_Me vSTT4109(Test_STT4109, "STT4109", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4119  {
  __tsi64 fa;
  __tsu64  :8;
};
//SIG(1 STT4119) C1{ FL FL:8}



static void Test_STT4119()
{
  {
    init_simple_test("STT4119");
    static STT4119 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4119)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4119)");
    check_field_offset(lv, fa, 0, "STT4119.fa");
  }
}
static Arrange_To_Call_Me vSTT4119(Test_STT4119, "STT4119", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4129  {
  __tsi64 fa;
  unsigned int  :18;
};
//SIG(1 STT4129) C1{ FL Fi:18}



static void Test_STT4129()
{
  {
    init_simple_test("STT4129");
    static STT4129 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4129)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4129)");
    check_field_offset(lv, fa, 0, "STT4129.fa");
  }
}
static Arrange_To_Call_Me vSTT4129(Test_STT4129, "STT4129", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4139  {
  __tsi64 fa;
  __tsu64  :18;
};
//SIG(1 STT4139) C1{ FL FL:18}



static void Test_STT4139()
{
  {
    init_simple_test("STT4139");
    static STT4139 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4139)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4139)");
    check_field_offset(lv, fa, 0, "STT4139.fa");
  }
}
static Arrange_To_Call_Me vSTT4139(Test_STT4139, "STT4139", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4149  {
  __tsi64 fa;
  __tsu64  :48;
};
//SIG(1 STT4149) C1{ FL FL:48}



static void Test_STT4149()
{
  {
    init_simple_test("STT4149");
    static STT4149 lv;
    check2(sizeof(lv), 16, "sizeof(STT4149)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4149)");
    check_field_offset(lv, fa, 0, "STT4149.fa");
  }
}
static Arrange_To_Call_Me vSTT4149(Test_STT4149, "STT4149", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4159  {
  __tsi64 fa;
  unsigned char bf:3;
};
//SIG(1 STT4159) C1{ FL Fc:3}



static void Test_STT4159()
{
  {
    init_simple_test("STT4159");
    static STT4159 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4159)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4159)");
    check_field_offset(lv, fa, 0, "STT4159.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4159");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4159");
  }
}
static Arrange_To_Call_Me vSTT4159(Test_STT4159, "STT4159", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4169  {
  __tsi64 fa;
  unsigned short bf:3;
};
//SIG(1 STT4169) C1{ FL Fs:3}



static void Test_STT4169()
{
  {
    init_simple_test("STT4169");
    static STT4169 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4169)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4169)");
    check_field_offset(lv, fa, 0, "STT4169.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4169");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4169");
  }
}
static Arrange_To_Call_Me vSTT4169(Test_STT4169, "STT4169", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4179  {
  __tsi64 fa;
  unsigned int bf:3;
};
//SIG(1 STT4179) C1{ FL Fi:3}



static void Test_STT4179()
{
  {
    init_simple_test("STT4179");
    static STT4179 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4179)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4179)");
    check_field_offset(lv, fa, 0, "STT4179.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4179");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4179");
  }
}
static Arrange_To_Call_Me vSTT4179(Test_STT4179, "STT4179", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4189  {
  __tsi64 fa;
  __tsu64 bf:3;
};
//SIG(1 STT4189) C1{ FL FL:3}



static void Test_STT4189()
{
  {
    init_simple_test("STT4189");
    static STT4189 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4189)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4189)");
    check_field_offset(lv, fa, 0, "STT4189.fa");
    set_bf_and_test(lv, bf, 8, 0, 3, 1, "STT4189");
    set_bf_and_test(lv, bf, 8, 0, 3, hide_ull(1LL<<2), "STT4189");
  }
}
static Arrange_To_Call_Me vSTT4189(Test_STT4189, "STT4189", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4199  {
  __tsi64 fa;
  unsigned short bf:8;
};
//SIG(1 STT4199) C1{ FL Fs:8}



static void Test_STT4199()
{
  {
    init_simple_test("STT4199");
    static STT4199 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4199)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4199)");
    check_field_offset(lv, fa, 0, "STT4199.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4199");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4199");
  }
}
static Arrange_To_Call_Me vSTT4199(Test_STT4199, "STT4199", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4209  {
  __tsi64 fa;
  unsigned int bf:8;
};
//SIG(1 STT4209) C1{ FL Fi:8}



static void Test_STT4209()
{
  {
    init_simple_test("STT4209");
    static STT4209 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4209)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4209)");
    check_field_offset(lv, fa, 0, "STT4209.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4209");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4209");
  }
}
static Arrange_To_Call_Me vSTT4209(Test_STT4209, "STT4209", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4219  {
  __tsi64 fa;
  __tsu64 bf:8;
};
//SIG(1 STT4219) C1{ FL FL:8}



static void Test_STT4219()
{
  {
    init_simple_test("STT4219");
    static STT4219 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4219)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4219)");
    check_field_offset(lv, fa, 0, "STT4219.fa");
    set_bf_and_test(lv, bf, 8, 0, 8, 1, "STT4219");
    set_bf_and_test(lv, bf, 8, 0, 8, hide_ull(1LL<<7), "STT4219");
  }
}
static Arrange_To_Call_Me vSTT4219(Test_STT4219, "STT4219", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4229  {
  __tsi64 fa;
  unsigned int bf:18;
};
//SIG(1 STT4229) C1{ FL Fi:18}



static void Test_STT4229()
{
  {
    init_simple_test("STT4229");
    static STT4229 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4229)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4229)");
    check_field_offset(lv, fa, 0, "STT4229.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4229");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4229");
  }
}
static Arrange_To_Call_Me vSTT4229(Test_STT4229, "STT4229", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4239  {
  __tsi64 fa;
  __tsu64 bf:18;
};
//SIG(1 STT4239) C1{ FL FL:18}



static void Test_STT4239()
{
  {
    init_simple_test("STT4239");
    static STT4239 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT4239)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4239)");
    check_field_offset(lv, fa, 0, "STT4239.fa");
    set_bf_and_test(lv, bf, 8, 0, 18, 1, "STT4239");
    set_bf_and_test(lv, bf, 8, 0, 18, hide_ull(1LL<<17), "STT4239");
  }
}
static Arrange_To_Call_Me vSTT4239(Test_STT4239, "STT4239", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT4249  {
  __tsi64 fa;
  __tsu64 bf:48;
};
//SIG(1 STT4249) C1{ FL FL:48}



static void Test_STT4249()
{
  {
    init_simple_test("STT4249");
    static STT4249 lv;
    check2(sizeof(lv), 16, "sizeof(STT4249)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT4249)");
    check_field_offset(lv, fa, 0, "STT4249.fa");
    set_bf_and_test(lv, bf, 8, 0, 48, 1, "STT4249");
    set_bf_and_test(lv, bf, 8, 0, 48, hide_ull(1LL<<47), "STT4249");
  }
}
static Arrange_To_Call_Me vSTT4249(Test_STT4249, "STT4249", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT510  {
  void *fa;
  unsigned char  :0;
  char fb;
};
//SIG(1 STT510) C1{ Fp Fc:0 Fc}



static void Test_STT510()
{
  {
    init_simple_test("STT510");
    static STT510 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT510)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT510)");
    check_field_offset(lv, fa, 0, "STT510.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT510.fb");
  }
}
static Arrange_To_Call_Me vSTT510(Test_STT510, "STT510", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT520  {
  void *fa;
  unsigned short  :0;
  char fb;
};
//SIG(1 STT520) C1{ Fp Fs:0 Fc}



static void Test_STT520()
{
  {
    init_simple_test("STT520");
    static STT520 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT520)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT520)");
    check_field_offset(lv, fa, 0, "STT520.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT520.fb");
  }
}
static Arrange_To_Call_Me vSTT520(Test_STT520, "STT520", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT530  {
  void *fa;
  unsigned int  :0;
  char fb;
};
//SIG(1 STT530) C1{ Fp Fi:0 Fc}



static void Test_STT530()
{
  {
    init_simple_test("STT530");
    static STT530 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT530)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT530)");
    check_field_offset(lv, fa, 0, "STT530.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT530.fb");
  }
}
static Arrange_To_Call_Me vSTT530(Test_STT530, "STT530", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT540  {
  void *fa;
  __tsu64  :0;
  char fb;
};
//SIG(1 STT540) C1{ Fp FL:0 Fc}



static void Test_STT540()
{
  {
    init_simple_test("STT540");
    static STT540 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT540)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT540)");
    check_field_offset(lv, fa, 0, "STT540.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT540.fb");
  }
}
static Arrange_To_Call_Me vSTT540(Test_STT540, "STT540", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT550  {
  void *fa;
  unsigned char  :3;
  char fb;
};
//SIG(1 STT550) C1{ Fp Fc:3 Fc}



static void Test_STT550()
{
  {
    init_simple_test("STT550");
    static STT550 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT550)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT550)");
    check_field_offset(lv, fa, 0, "STT550.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT550.fb");
  }
}
static Arrange_To_Call_Me vSTT550(Test_STT550, "STT550", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT560  {
  void *fa;
  unsigned short  :3;
  char fb;
};
//SIG(1 STT560) C1{ Fp Fs:3 Fc}



static void Test_STT560()
{
  {
    init_simple_test("STT560");
    static STT560 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT560)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT560)");
    check_field_offset(lv, fa, 0, "STT560.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT560.fb");
  }
}
static Arrange_To_Call_Me vSTT560(Test_STT560, "STT560", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT570  {
  void *fa;
  unsigned int  :3;
  char fb;
};
//SIG(1 STT570) C1{ Fp Fi:3 Fc}



static void Test_STT570()
{
  {
    init_simple_test("STT570");
    static STT570 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT570)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT570)");
    check_field_offset(lv, fa, 0, "STT570.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT570.fb");
  }
}
static Arrange_To_Call_Me vSTT570(Test_STT570, "STT570", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT580  {
  void *fa;
  __tsu64  :3;
  char fb;
};
//SIG(1 STT580) C1{ Fp FL:3 Fc}



static void Test_STT580()
{
  {
    init_simple_test("STT580");
    static STT580 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT580)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT580)");
    check_field_offset(lv, fa, 0, "STT580.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT580.fb");
  }
}
static Arrange_To_Call_Me vSTT580(Test_STT580, "STT580", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT590  {
  void *fa;
  unsigned short  :8;
  char fb;
};
//SIG(1 STT590) C1{ Fp Fs:8 Fc}



static void Test_STT590()
{
  {
    init_simple_test("STT590");
    static STT590 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT590)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT590)");
    check_field_offset(lv, fa, 0, "STT590.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT590.fb");
  }
}
static Arrange_To_Call_Me vSTT590(Test_STT590, "STT590", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5100  {
  void *fa;
  unsigned int  :8;
  char fb;
};
//SIG(1 STT5100) C1{ Fp Fi:8 Fc}



static void Test_STT5100()
{
  {
    init_simple_test("STT5100");
    static STT5100 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5100)");
    check_field_offset(lv, fa, 0, "STT5100.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5100.fb");
  }
}
static Arrange_To_Call_Me vSTT5100(Test_STT5100, "STT5100", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5110  {
  void *fa;
  __tsu64  :8;
  char fb;
};
//SIG(1 STT5110) C1{ Fp FL:8 Fc}



static void Test_STT5110()
{
  {
    init_simple_test("STT5110");
    static STT5110 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5110)");
    check_field_offset(lv, fa, 0, "STT5110.fa");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5110.fb");
  }
}
static Arrange_To_Call_Me vSTT5110(Test_STT5110, "STT5110", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5120  {
  void *fa;
  unsigned int  :18;
  char fb;
};
//SIG(1 STT5120) C1{ Fp Fi:18 Fc}



static void Test_STT5120()
{
  {
    init_simple_test("STT5120");
    static STT5120 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5120)");
    check_field_offset(lv, fa, 0, "STT5120.fa");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT5120.fb");
  }
}
static Arrange_To_Call_Me vSTT5120(Test_STT5120, "STT5120", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5130  {
  void *fa;
  __tsu64  :18;
  char fb;
};
//SIG(1 STT5130) C1{ Fp FL:18 Fc}



static void Test_STT5130()
{
  {
    init_simple_test("STT5130");
    static STT5130 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5130)");
    check_field_offset(lv, fa, 0, "STT5130.fa");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT5130.fb");
  }
}
static Arrange_To_Call_Me vSTT5130(Test_STT5130, "STT5130", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5140  {
  void *fa;
  __tsu64  :48;
  char fb;
};
//SIG(1 STT5140) C1{ Fp FL:48 Fc}



static void Test_STT5140()
{
  {
    init_simple_test("STT5140");
    static STT5140 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5140)");
    check_field_offset(lv, fa, 0, "STT5140.fa");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT5140.fb");
  }
}
static Arrange_To_Call_Me vSTT5140(Test_STT5140, "STT5140", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5150  {
  void *fa;
  unsigned char bf:3;
  char fb;
};
//SIG(1 STT5150) C1{ Fp Fc:3 Fc}



static void Test_STT5150()
{
  {
    init_simple_test("STT5150");
    static STT5150 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5150)");
    check_field_offset(lv, fa, 0, "STT5150.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5150");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5150");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5150.fb");
  }
}
static Arrange_To_Call_Me vSTT5150(Test_STT5150, "STT5150", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5160  {
  void *fa;
  unsigned short bf:3;
  char fb;
};
//SIG(1 STT5160) C1{ Fp Fs:3 Fc}



static void Test_STT5160()
{
  {
    init_simple_test("STT5160");
    static STT5160 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5160)");
    check_field_offset(lv, fa, 0, "STT5160.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5160");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5160");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5160.fb");
  }
}
static Arrange_To_Call_Me vSTT5160(Test_STT5160, "STT5160", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5170  {
  void *fa;
  unsigned int bf:3;
  char fb;
};
//SIG(1 STT5170) C1{ Fp Fi:3 Fc}



static void Test_STT5170()
{
  {
    init_simple_test("STT5170");
    static STT5170 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5170)");
    check_field_offset(lv, fa, 0, "STT5170.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5170");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5170");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5170.fb");
  }
}
static Arrange_To_Call_Me vSTT5170(Test_STT5170, "STT5170", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5180  {
  void *fa;
  __tsu64 bf:3;
  char fb;
};
//SIG(1 STT5180) C1{ Fp FL:3 Fc}



static void Test_STT5180()
{
  {
    init_simple_test("STT5180");
    static STT5180 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5180)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5180)");
    check_field_offset(lv, fa, 0, "STT5180.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5180");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5180");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5180.fb");
  }
}
static Arrange_To_Call_Me vSTT5180(Test_STT5180, "STT5180", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5190  {
  void *fa;
  unsigned short bf:8;
  char fb;
};
//SIG(1 STT5190) C1{ Fp Fs:8 Fc}



static void Test_STT5190()
{
  {
    init_simple_test("STT5190");
    static STT5190 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5190)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5190)");
    check_field_offset(lv, fa, 0, "STT5190.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5190");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5190");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5190.fb");
  }
}
static Arrange_To_Call_Me vSTT5190(Test_STT5190, "STT5190", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5200  {
  void *fa;
  unsigned int bf:8;
  char fb;
};
//SIG(1 STT5200) C1{ Fp Fi:8 Fc}



static void Test_STT5200()
{
  {
    init_simple_test("STT5200");
    static STT5200 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5200)");
    check_field_offset(lv, fa, 0, "STT5200.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5200");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5200");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5200.fb");
  }
}
static Arrange_To_Call_Me vSTT5200(Test_STT5200, "STT5200", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5210  {
  void *fa;
  __tsu64 bf:8;
  char fb;
};
//SIG(1 STT5210) C1{ Fp FL:8 Fc}



static void Test_STT5210()
{
  {
    init_simple_test("STT5210");
    static STT5210 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5210)");
    check_field_offset(lv, fa, 0, "STT5210.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5210");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5210");
    check_field_offset(lv, fb, ABISELECT(9,5), "STT5210.fb");
  }
}
static Arrange_To_Call_Me vSTT5210(Test_STT5210, "STT5210", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5220  {
  void *fa;
  unsigned int bf:18;
  char fb;
};
//SIG(1 STT5220) C1{ Fp Fi:18 Fc}



static void Test_STT5220()
{
  {
    init_simple_test("STT5220");
    static STT5220 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5220)");
    check_field_offset(lv, fa, 0, "STT5220.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5220");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5220");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT5220.fb");
  }
}
static Arrange_To_Call_Me vSTT5220(Test_STT5220, "STT5220", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5230  {
  void *fa;
  __tsu64 bf:18;
  char fb;
};
//SIG(1 STT5230) C1{ Fp FL:18 Fc}



static void Test_STT5230()
{
  {
    init_simple_test("STT5230");
    static STT5230 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5230)");
    check_field_offset(lv, fa, 0, "STT5230.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5230");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5230");
    check_field_offset(lv, fb, ABISELECT(11,7), "STT5230.fb");
  }
}
static Arrange_To_Call_Me vSTT5230(Test_STT5230, "STT5230", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5240  {
  void *fa;
  __tsu64 bf:48;
  char fb;
};
//SIG(1 STT5240) C1{ Fp FL:48 Fc}



static void Test_STT5240()
{
  {
    init_simple_test("STT5240");
    static STT5240 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5240)");
    check_field_offset(lv, fa, 0, "STT5240.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5240");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5240");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT5240.fb");
  }
}
static Arrange_To_Call_Me vSTT5240(Test_STT5240, "STT5240", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT511  {
  void *fa;
  unsigned char  :0;
  short fb;
};
//SIG(1 STT511) C1{ Fp Fc:0 Fs}



static void Test_STT511()
{
  {
    init_simple_test("STT511");
    static STT511 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT511)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT511)");
    check_field_offset(lv, fa, 0, "STT511.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT511.fb");
  }
}
static Arrange_To_Call_Me vSTT511(Test_STT511, "STT511", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT521  {
  void *fa;
  unsigned short  :0;
  short fb;
};
//SIG(1 STT521) C1{ Fp Fs:0 Fs}



static void Test_STT521()
{
  {
    init_simple_test("STT521");
    static STT521 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT521)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT521)");
    check_field_offset(lv, fa, 0, "STT521.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT521.fb");
  }
}
static Arrange_To_Call_Me vSTT521(Test_STT521, "STT521", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT531  {
  void *fa;
  unsigned int  :0;
  short fb;
};
//SIG(1 STT531) C1{ Fp Fi:0 Fs}



static void Test_STT531()
{
  {
    init_simple_test("STT531");
    static STT531 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT531)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT531)");
    check_field_offset(lv, fa, 0, "STT531.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT531.fb");
  }
}
static Arrange_To_Call_Me vSTT531(Test_STT531, "STT531", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT541  {
  void *fa;
  __tsu64  :0;
  short fb;
};
//SIG(1 STT541) C1{ Fp FL:0 Fs}



static void Test_STT541()
{
  {
    init_simple_test("STT541");
    static STT541 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT541)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT541)");
    check_field_offset(lv, fa, 0, "STT541.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT541.fb");
  }
}
static Arrange_To_Call_Me vSTT541(Test_STT541, "STT541", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT551  {
  void *fa;
  unsigned char  :3;
  short fb;
};
//SIG(1 STT551) C1{ Fp Fc:3 Fs}



static void Test_STT551()
{
  {
    init_simple_test("STT551");
    static STT551 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT551)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT551)");
    check_field_offset(lv, fa, 0, "STT551.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT551.fb");
  }
}
static Arrange_To_Call_Me vSTT551(Test_STT551, "STT551", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT561  {
  void *fa;
  unsigned short  :3;
  short fb;
};
//SIG(1 STT561) C1{ Fp Fs:3 Fs}



static void Test_STT561()
{
  {
    init_simple_test("STT561");
    static STT561 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT561)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT561)");
    check_field_offset(lv, fa, 0, "STT561.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT561.fb");
  }
}
static Arrange_To_Call_Me vSTT561(Test_STT561, "STT561", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT571  {
  void *fa;
  unsigned int  :3;
  short fb;
};
//SIG(1 STT571) C1{ Fp Fi:3 Fs}



static void Test_STT571()
{
  {
    init_simple_test("STT571");
    static STT571 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT571)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT571)");
    check_field_offset(lv, fa, 0, "STT571.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT571.fb");
  }
}
static Arrange_To_Call_Me vSTT571(Test_STT571, "STT571", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT581  {
  void *fa;
  __tsu64  :3;
  short fb;
};
//SIG(1 STT581) C1{ Fp FL:3 Fs}



static void Test_STT581()
{
  {
    init_simple_test("STT581");
    static STT581 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT581)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT581)");
    check_field_offset(lv, fa, 0, "STT581.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT581.fb");
  }
}
static Arrange_To_Call_Me vSTT581(Test_STT581, "STT581", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT591  {
  void *fa;
  unsigned short  :8;
  short fb;
};
//SIG(1 STT591) C1{ Fp Fs:8 Fs}



static void Test_STT591()
{
  {
    init_simple_test("STT591");
    static STT591 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT591)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT591)");
    check_field_offset(lv, fa, 0, "STT591.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT591.fb");
  }
}
static Arrange_To_Call_Me vSTT591(Test_STT591, "STT591", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5101  {
  void *fa;
  unsigned int  :8;
  short fb;
};
//SIG(1 STT5101) C1{ Fp Fi:8 Fs}



static void Test_STT5101()
{
  {
    init_simple_test("STT5101");
    static STT5101 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5101)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5101)");
    check_field_offset(lv, fa, 0, "STT5101.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5101.fb");
  }
}
static Arrange_To_Call_Me vSTT5101(Test_STT5101, "STT5101", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5111  {
  void *fa;
  __tsu64  :8;
  short fb;
};
//SIG(1 STT5111) C1{ Fp FL:8 Fs}



static void Test_STT5111()
{
  {
    init_simple_test("STT5111");
    static STT5111 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5111)");
    check_field_offset(lv, fa, 0, "STT5111.fa");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5111.fb");
  }
}
static Arrange_To_Call_Me vSTT5111(Test_STT5111, "STT5111", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5121  {
  void *fa;
  unsigned int  :18;
  short fb;
};
//SIG(1 STT5121) C1{ Fp Fi:18 Fs}



static void Test_STT5121()
{
  {
    init_simple_test("STT5121");
    static STT5121 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5121)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5121)");
    check_field_offset(lv, fa, 0, "STT5121.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5121.fb");
  }
}
static Arrange_To_Call_Me vSTT5121(Test_STT5121, "STT5121", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5131  {
  void *fa;
  __tsu64  :18;
  short fb;
};
//SIG(1 STT5131) C1{ Fp FL:18 Fs}



static void Test_STT5131()
{
  {
    init_simple_test("STT5131");
    static STT5131 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5131)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5131)");
    check_field_offset(lv, fa, 0, "STT5131.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5131.fb");
  }
}
static Arrange_To_Call_Me vSTT5131(Test_STT5131, "STT5131", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5141  {
  void *fa;
  __tsu64  :48;
  short fb;
};
//SIG(1 STT5141) C1{ Fp FL:48 Fs}



static void Test_STT5141()
{
  {
    init_simple_test("STT5141");
    static STT5141 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5141)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5141)");
    check_field_offset(lv, fa, 0, "STT5141.fa");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT5141.fb");
  }
}
static Arrange_To_Call_Me vSTT5141(Test_STT5141, "STT5141", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5151  {
  void *fa;
  unsigned char bf:3;
  short fb;
};
//SIG(1 STT5151) C1{ Fp Fc:3 Fs}



static void Test_STT5151()
{
  {
    init_simple_test("STT5151");
    static STT5151 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5151)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5151)");
    check_field_offset(lv, fa, 0, "STT5151.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5151");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5151");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5151.fb");
  }
}
static Arrange_To_Call_Me vSTT5151(Test_STT5151, "STT5151", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5161  {
  void *fa;
  unsigned short bf:3;
  short fb;
};
//SIG(1 STT5161) C1{ Fp Fs:3 Fs}



static void Test_STT5161()
{
  {
    init_simple_test("STT5161");
    static STT5161 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5161)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5161)");
    check_field_offset(lv, fa, 0, "STT5161.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5161");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5161");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5161.fb");
  }
}
static Arrange_To_Call_Me vSTT5161(Test_STT5161, "STT5161", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5171  {
  void *fa;
  unsigned int bf:3;
  short fb;
};
//SIG(1 STT5171) C1{ Fp Fi:3 Fs}



static void Test_STT5171()
{
  {
    init_simple_test("STT5171");
    static STT5171 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5171)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5171)");
    check_field_offset(lv, fa, 0, "STT5171.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5171");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5171");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5171.fb");
  }
}
static Arrange_To_Call_Me vSTT5171(Test_STT5171, "STT5171", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5181  {
  void *fa;
  __tsu64 bf:3;
  short fb;
};
//SIG(1 STT5181) C1{ Fp FL:3 Fs}



static void Test_STT5181()
{
  {
    init_simple_test("STT5181");
    static STT5181 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5181)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5181)");
    check_field_offset(lv, fa, 0, "STT5181.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5181");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5181");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5181.fb");
  }
}
static Arrange_To_Call_Me vSTT5181(Test_STT5181, "STT5181", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5191  {
  void *fa;
  unsigned short bf:8;
  short fb;
};
//SIG(1 STT5191) C1{ Fp Fs:8 Fs}



static void Test_STT5191()
{
  {
    init_simple_test("STT5191");
    static STT5191 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5191)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5191)");
    check_field_offset(lv, fa, 0, "STT5191.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5191");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5191");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5191.fb");
  }
}
static Arrange_To_Call_Me vSTT5191(Test_STT5191, "STT5191", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5201  {
  void *fa;
  unsigned int bf:8;
  short fb;
};
//SIG(1 STT5201) C1{ Fp Fi:8 Fs}



static void Test_STT5201()
{
  {
    init_simple_test("STT5201");
    static STT5201 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5201)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5201)");
    check_field_offset(lv, fa, 0, "STT5201.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5201");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5201");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5201.fb");
  }
}
static Arrange_To_Call_Me vSTT5201(Test_STT5201, "STT5201", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5211  {
  void *fa;
  __tsu64 bf:8;
  short fb;
};
//SIG(1 STT5211) C1{ Fp FL:8 Fs}



static void Test_STT5211()
{
  {
    init_simple_test("STT5211");
    static STT5211 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5211)");
    check_field_offset(lv, fa, 0, "STT5211.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5211");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5211");
    check_field_offset(lv, fb, ABISELECT(10,6), "STT5211.fb");
  }
}
static Arrange_To_Call_Me vSTT5211(Test_STT5211, "STT5211", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5221  {
  void *fa;
  unsigned int bf:18;
  short fb;
};
//SIG(1 STT5221) C1{ Fp Fi:18 Fs}



static void Test_STT5221()
{
  {
    init_simple_test("STT5221");
    static STT5221 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5221)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5221)");
    check_field_offset(lv, fa, 0, "STT5221.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5221");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5221");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5221.fb");
  }
}
static Arrange_To_Call_Me vSTT5221(Test_STT5221, "STT5221", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5231  {
  void *fa;
  __tsu64 bf:18;
  short fb;
};
//SIG(1 STT5231) C1{ Fp FL:18 Fs}



static void Test_STT5231()
{
  {
    init_simple_test("STT5231");
    static STT5231 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5231)");
    check_field_offset(lv, fa, 0, "STT5231.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5231");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5231");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5231.fb");
  }
}
static Arrange_To_Call_Me vSTT5231(Test_STT5231, "STT5231", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5241  {
  void *fa;
  __tsu64 bf:48;
  short fb;
};
//SIG(1 STT5241) C1{ Fp FL:48 Fs}



static void Test_STT5241()
{
  {
    init_simple_test("STT5241");
    static STT5241 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5241)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5241)");
    check_field_offset(lv, fa, 0, "STT5241.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5241");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5241");
    check_field_offset(lv, fb, ABISELECT(14,10), "STT5241.fb");
  }
}
static Arrange_To_Call_Me vSTT5241(Test_STT5241, "STT5241", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT512  {
  void *fa;
  unsigned char  :0;
  int fb;
};
//SIG(1 STT512) C1{ Fp Fc:0 Fi}



static void Test_STT512()
{
  {
    init_simple_test("STT512");
    static STT512 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT512)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT512)");
    check_field_offset(lv, fa, 0, "STT512.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT512.fb");
  }
}
static Arrange_To_Call_Me vSTT512(Test_STT512, "STT512", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT522  {
  void *fa;
  unsigned short  :0;
  int fb;
};
//SIG(1 STT522) C1{ Fp Fs:0 Fi}



static void Test_STT522()
{
  {
    init_simple_test("STT522");
    static STT522 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT522)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT522)");
    check_field_offset(lv, fa, 0, "STT522.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT522.fb");
  }
}
static Arrange_To_Call_Me vSTT522(Test_STT522, "STT522", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT532  {
  void *fa;
  unsigned int  :0;
  int fb;
};
//SIG(1 STT532) C1{ Fp Fi:0 Fi}



static void Test_STT532()
{
  {
    init_simple_test("STT532");
    static STT532 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT532)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT532)");
    check_field_offset(lv, fa, 0, "STT532.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT532.fb");
  }
}
static Arrange_To_Call_Me vSTT532(Test_STT532, "STT532", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT542  {
  void *fa;
  __tsu64  :0;
  int fb;
};
//SIG(1 STT542) C1{ Fp FL:0 Fi}



static void Test_STT542()
{
  {
    init_simple_test("STT542");
    static STT542 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT542)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT542)");
    check_field_offset(lv, fa, 0, "STT542.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT542.fb");
  }
}
static Arrange_To_Call_Me vSTT542(Test_STT542, "STT542", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT552  {
  void *fa;
  unsigned char  :3;
  int fb;
};
//SIG(1 STT552) C1{ Fp Fc:3 Fi}



static void Test_STT552()
{
  {
    init_simple_test("STT552");
    static STT552 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT552)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT552)");
    check_field_offset(lv, fa, 0, "STT552.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT552.fb");
  }
}
static Arrange_To_Call_Me vSTT552(Test_STT552, "STT552", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT562  {
  void *fa;
  unsigned short  :3;
  int fb;
};
//SIG(1 STT562) C1{ Fp Fs:3 Fi}



static void Test_STT562()
{
  {
    init_simple_test("STT562");
    static STT562 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT562)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT562)");
    check_field_offset(lv, fa, 0, "STT562.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT562.fb");
  }
}
static Arrange_To_Call_Me vSTT562(Test_STT562, "STT562", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT572  {
  void *fa;
  unsigned int  :3;
  int fb;
};
//SIG(1 STT572) C1{ Fp Fi:3 Fi}



static void Test_STT572()
{
  {
    init_simple_test("STT572");
    static STT572 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT572)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT572)");
    check_field_offset(lv, fa, 0, "STT572.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT572.fb");
  }
}
static Arrange_To_Call_Me vSTT572(Test_STT572, "STT572", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT582  {
  void *fa;
  __tsu64  :3;
  int fb;
};
//SIG(1 STT582) C1{ Fp FL:3 Fi}



static void Test_STT582()
{
  {
    init_simple_test("STT582");
    static STT582 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT582)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT582)");
    check_field_offset(lv, fa, 0, "STT582.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT582.fb");
  }
}
static Arrange_To_Call_Me vSTT582(Test_STT582, "STT582", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT592  {
  void *fa;
  unsigned short  :8;
  int fb;
};
//SIG(1 STT592) C1{ Fp Fs:8 Fi}



static void Test_STT592()
{
  {
    init_simple_test("STT592");
    static STT592 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT592)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT592)");
    check_field_offset(lv, fa, 0, "STT592.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT592.fb");
  }
}
static Arrange_To_Call_Me vSTT592(Test_STT592, "STT592", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5102  {
  void *fa;
  unsigned int  :8;
  int fb;
};
//SIG(1 STT5102) C1{ Fp Fi:8 Fi}



static void Test_STT5102()
{
  {
    init_simple_test("STT5102");
    static STT5102 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5102)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5102)");
    check_field_offset(lv, fa, 0, "STT5102.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5102.fb");
  }
}
static Arrange_To_Call_Me vSTT5102(Test_STT5102, "STT5102", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5112  {
  void *fa;
  __tsu64  :8;
  int fb;
};
//SIG(1 STT5112) C1{ Fp FL:8 Fi}



static void Test_STT5112()
{
  {
    init_simple_test("STT5112");
    static STT5112 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5112)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5112)");
    check_field_offset(lv, fa, 0, "STT5112.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5112.fb");
  }
}
static Arrange_To_Call_Me vSTT5112(Test_STT5112, "STT5112", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5122  {
  void *fa;
  unsigned int  :18;
  int fb;
};
//SIG(1 STT5122) C1{ Fp Fi:18 Fi}



static void Test_STT5122()
{
  {
    init_simple_test("STT5122");
    static STT5122 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5122)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5122)");
    check_field_offset(lv, fa, 0, "STT5122.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5122.fb");
  }
}
static Arrange_To_Call_Me vSTT5122(Test_STT5122, "STT5122", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5132  {
  void *fa;
  __tsu64  :18;
  int fb;
};
//SIG(1 STT5132) C1{ Fp FL:18 Fi}



static void Test_STT5132()
{
  {
    init_simple_test("STT5132");
    static STT5132 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5132)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5132)");
    check_field_offset(lv, fa, 0, "STT5132.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5132.fb");
  }
}
static Arrange_To_Call_Me vSTT5132(Test_STT5132, "STT5132", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5142  {
  void *fa;
  __tsu64  :48;
  int fb;
};
//SIG(1 STT5142) C1{ Fp FL:48 Fi}



static void Test_STT5142()
{
  {
    init_simple_test("STT5142");
    static STT5142 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5142)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5142)");
    check_field_offset(lv, fa, 0, "STT5142.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5142.fb");
  }
}
static Arrange_To_Call_Me vSTT5142(Test_STT5142, "STT5142", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5152  {
  void *fa;
  unsigned char bf:3;
  int fb;
};
//SIG(1 STT5152) C1{ Fp Fc:3 Fi}



static void Test_STT5152()
{
  {
    init_simple_test("STT5152");
    static STT5152 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5152)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5152)");
    check_field_offset(lv, fa, 0, "STT5152.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5152");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5152");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5152.fb");
  }
}
static Arrange_To_Call_Me vSTT5152(Test_STT5152, "STT5152", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5162  {
  void *fa;
  unsigned short bf:3;
  int fb;
};
//SIG(1 STT5162) C1{ Fp Fs:3 Fi}



static void Test_STT5162()
{
  {
    init_simple_test("STT5162");
    static STT5162 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5162)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5162)");
    check_field_offset(lv, fa, 0, "STT5162.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5162");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5162");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5162.fb");
  }
}
static Arrange_To_Call_Me vSTT5162(Test_STT5162, "STT5162", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5172  {
  void *fa;
  unsigned int bf:3;
  int fb;
};
//SIG(1 STT5172) C1{ Fp Fi:3 Fi}



static void Test_STT5172()
{
  {
    init_simple_test("STT5172");
    static STT5172 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5172)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5172)");
    check_field_offset(lv, fa, 0, "STT5172.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5172");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5172");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5172.fb");
  }
}
static Arrange_To_Call_Me vSTT5172(Test_STT5172, "STT5172", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5182  {
  void *fa;
  __tsu64 bf:3;
  int fb;
};
//SIG(1 STT5182) C1{ Fp FL:3 Fi}



static void Test_STT5182()
{
  {
    init_simple_test("STT5182");
    static STT5182 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5182)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5182)");
    check_field_offset(lv, fa, 0, "STT5182.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5182");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5182");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5182.fb");
  }
}
static Arrange_To_Call_Me vSTT5182(Test_STT5182, "STT5182", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5192  {
  void *fa;
  unsigned short bf:8;
  int fb;
};
//SIG(1 STT5192) C1{ Fp Fs:8 Fi}



static void Test_STT5192()
{
  {
    init_simple_test("STT5192");
    static STT5192 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5192)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5192)");
    check_field_offset(lv, fa, 0, "STT5192.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5192");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5192");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5192.fb");
  }
}
static Arrange_To_Call_Me vSTT5192(Test_STT5192, "STT5192", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5202  {
  void *fa;
  unsigned int bf:8;
  int fb;
};
//SIG(1 STT5202) C1{ Fp Fi:8 Fi}



static void Test_STT5202()
{
  {
    init_simple_test("STT5202");
    static STT5202 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5202)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5202)");
    check_field_offset(lv, fa, 0, "STT5202.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5202");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5202");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5202.fb");
  }
}
static Arrange_To_Call_Me vSTT5202(Test_STT5202, "STT5202", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5212  {
  void *fa;
  __tsu64 bf:8;
  int fb;
};
//SIG(1 STT5212) C1{ Fp FL:8 Fi}



static void Test_STT5212()
{
  {
    init_simple_test("STT5212");
    static STT5212 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5212)");
    check_field_offset(lv, fa, 0, "STT5212.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5212");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5212");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5212.fb");
  }
}
static Arrange_To_Call_Me vSTT5212(Test_STT5212, "STT5212", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5222  {
  void *fa;
  unsigned int bf:18;
  int fb;
};
//SIG(1 STT5222) C1{ Fp Fi:18 Fi}



static void Test_STT5222()
{
  {
    init_simple_test("STT5222");
    static STT5222 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5222)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5222)");
    check_field_offset(lv, fa, 0, "STT5222.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5222");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5222");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5222.fb");
  }
}
static Arrange_To_Call_Me vSTT5222(Test_STT5222, "STT5222", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5232  {
  void *fa;
  __tsu64 bf:18;
  int fb;
};
//SIG(1 STT5232) C1{ Fp FL:18 Fi}



static void Test_STT5232()
{
  {
    init_simple_test("STT5232");
    static STT5232 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5232)");
    check_field_offset(lv, fa, 0, "STT5232.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5232");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5232");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5232.fb");
  }
}
static Arrange_To_Call_Me vSTT5232(Test_STT5232, "STT5232", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5242  {
  void *fa;
  __tsu64 bf:48;
  int fb;
};
//SIG(1 STT5242) C1{ Fp FL:48 Fi}



static void Test_STT5242()
{
  {
    init_simple_test("STT5242");
    static STT5242 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5242)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5242)");
    check_field_offset(lv, fa, 0, "STT5242.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5242");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5242");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5242.fb");
  }
}
static Arrange_To_Call_Me vSTT5242(Test_STT5242, "STT5242", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT513  {
  void *fa;
  unsigned char  :0;
  long fb;
};
//SIG(1 STT513) C1{ Fp Fc:0 Fl}



static void Test_STT513()
{
  {
    init_simple_test("STT513");
    static STT513 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT513)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT513)");
    check_field_offset(lv, fa, 0, "STT513.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT513.fb");
  }
}
static Arrange_To_Call_Me vSTT513(Test_STT513, "STT513", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT523  {
  void *fa;
  unsigned short  :0;
  long fb;
};
//SIG(1 STT523) C1{ Fp Fs:0 Fl}



static void Test_STT523()
{
  {
    init_simple_test("STT523");
    static STT523 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT523)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT523)");
    check_field_offset(lv, fa, 0, "STT523.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT523.fb");
  }
}
static Arrange_To_Call_Me vSTT523(Test_STT523, "STT523", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT533  {
  void *fa;
  unsigned int  :0;
  long fb;
};
//SIG(1 STT533) C1{ Fp Fi:0 Fl}



static void Test_STT533()
{
  {
    init_simple_test("STT533");
    static STT533 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT533)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT533)");
    check_field_offset(lv, fa, 0, "STT533.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT533.fb");
  }
}
static Arrange_To_Call_Me vSTT533(Test_STT533, "STT533", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT543  {
  void *fa;
  __tsu64  :0;
  long fb;
};
//SIG(1 STT543) C1{ Fp FL:0 Fl}



static void Test_STT543()
{
  {
    init_simple_test("STT543");
    static STT543 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT543)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT543)");
    check_field_offset(lv, fa, 0, "STT543.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT543.fb");
  }
}
static Arrange_To_Call_Me vSTT543(Test_STT543, "STT543", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT553  {
  void *fa;
  unsigned char  :3;
  long fb;
};
//SIG(1 STT553) C1{ Fp Fc:3 Fl}



static void Test_STT553()
{
  {
    init_simple_test("STT553");
    static STT553 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT553)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT553)");
    check_field_offset(lv, fa, 0, "STT553.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT553.fb");
  }
}
static Arrange_To_Call_Me vSTT553(Test_STT553, "STT553", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT563  {
  void *fa;
  unsigned short  :3;
  long fb;
};
//SIG(1 STT563) C1{ Fp Fs:3 Fl}



static void Test_STT563()
{
  {
    init_simple_test("STT563");
    static STT563 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT563)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT563)");
    check_field_offset(lv, fa, 0, "STT563.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT563.fb");
  }
}
static Arrange_To_Call_Me vSTT563(Test_STT563, "STT563", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT573  {
  void *fa;
  unsigned int  :3;
  long fb;
};
//SIG(1 STT573) C1{ Fp Fi:3 Fl}



static void Test_STT573()
{
  {
    init_simple_test("STT573");
    static STT573 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT573)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT573)");
    check_field_offset(lv, fa, 0, "STT573.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT573.fb");
  }
}
static Arrange_To_Call_Me vSTT573(Test_STT573, "STT573", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT583  {
  void *fa;
  __tsu64  :3;
  long fb;
};
//SIG(1 STT583) C1{ Fp FL:3 Fl}



static void Test_STT583()
{
  {
    init_simple_test("STT583");
    static STT583 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT583)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT583)");
    check_field_offset(lv, fa, 0, "STT583.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT583.fb");
  }
}
static Arrange_To_Call_Me vSTT583(Test_STT583, "STT583", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT593  {
  void *fa;
  unsigned short  :8;
  long fb;
};
//SIG(1 STT593) C1{ Fp Fs:8 Fl}



static void Test_STT593()
{
  {
    init_simple_test("STT593");
    static STT593 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT593)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT593)");
    check_field_offset(lv, fa, 0, "STT593.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT593.fb");
  }
}
static Arrange_To_Call_Me vSTT593(Test_STT593, "STT593", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5103  {
  void *fa;
  unsigned int  :8;
  long fb;
};
//SIG(1 STT5103) C1{ Fp Fi:8 Fl}



static void Test_STT5103()
{
  {
    init_simple_test("STT5103");
    static STT5103 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5103)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5103)");
    check_field_offset(lv, fa, 0, "STT5103.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5103.fb");
  }
}
static Arrange_To_Call_Me vSTT5103(Test_STT5103, "STT5103", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5113  {
  void *fa;
  __tsu64  :8;
  long fb;
};
//SIG(1 STT5113) C1{ Fp FL:8 Fl}



static void Test_STT5113()
{
  {
    init_simple_test("STT5113");
    static STT5113 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5113)");
    check_field_offset(lv, fa, 0, "STT5113.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5113.fb");
  }
}
static Arrange_To_Call_Me vSTT5113(Test_STT5113, "STT5113", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5123  {
  void *fa;
  unsigned int  :18;
  long fb;
};
//SIG(1 STT5123) C1{ Fp Fi:18 Fl}



static void Test_STT5123()
{
  {
    init_simple_test("STT5123");
    static STT5123 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5123)");
    check_field_offset(lv, fa, 0, "STT5123.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5123.fb");
  }
}
static Arrange_To_Call_Me vSTT5123(Test_STT5123, "STT5123", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5133  {
  void *fa;
  __tsu64  :18;
  long fb;
};
//SIG(1 STT5133) C1{ Fp FL:18 Fl}



static void Test_STT5133()
{
  {
    init_simple_test("STT5133");
    static STT5133 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5133)");
    check_field_offset(lv, fa, 0, "STT5133.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5133.fb");
  }
}
static Arrange_To_Call_Me vSTT5133(Test_STT5133, "STT5133", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5143  {
  void *fa;
  __tsu64  :48;
  long fb;
};
//SIG(1 STT5143) C1{ Fp FL:48 Fl}



static void Test_STT5143()
{
  {
    init_simple_test("STT5143");
    static STT5143 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5143)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5143)");
    check_field_offset(lv, fa, 0, "STT5143.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5143.fb");
  }
}
static Arrange_To_Call_Me vSTT5143(Test_STT5143, "STT5143", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5153  {
  void *fa;
  unsigned char bf:3;
  long fb;
};
//SIG(1 STT5153) C1{ Fp Fc:3 Fl}



static void Test_STT5153()
{
  {
    init_simple_test("STT5153");
    static STT5153 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5153)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5153)");
    check_field_offset(lv, fa, 0, "STT5153.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5153");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5153");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5153.fb");
  }
}
static Arrange_To_Call_Me vSTT5153(Test_STT5153, "STT5153", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5163  {
  void *fa;
  unsigned short bf:3;
  long fb;
};
//SIG(1 STT5163) C1{ Fp Fs:3 Fl}



static void Test_STT5163()
{
  {
    init_simple_test("STT5163");
    static STT5163 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5163)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5163)");
    check_field_offset(lv, fa, 0, "STT5163.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5163");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5163");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5163.fb");
  }
}
static Arrange_To_Call_Me vSTT5163(Test_STT5163, "STT5163", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5173  {
  void *fa;
  unsigned int bf:3;
  long fb;
};
//SIG(1 STT5173) C1{ Fp Fi:3 Fl}



static void Test_STT5173()
{
  {
    init_simple_test("STT5173");
    static STT5173 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5173)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5173)");
    check_field_offset(lv, fa, 0, "STT5173.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5173");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5173");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5173.fb");
  }
}
static Arrange_To_Call_Me vSTT5173(Test_STT5173, "STT5173", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5183  {
  void *fa;
  __tsu64 bf:3;
  long fb;
};
//SIG(1 STT5183) C1{ Fp FL:3 Fl}



static void Test_STT5183()
{
  {
    init_simple_test("STT5183");
    static STT5183 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5183)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5183)");
    check_field_offset(lv, fa, 0, "STT5183.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5183");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5183");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5183.fb");
  }
}
static Arrange_To_Call_Me vSTT5183(Test_STT5183, "STT5183", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5193  {
  void *fa;
  unsigned short bf:8;
  long fb;
};
//SIG(1 STT5193) C1{ Fp Fs:8 Fl}



static void Test_STT5193()
{
  {
    init_simple_test("STT5193");
    static STT5193 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5193)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5193)");
    check_field_offset(lv, fa, 0, "STT5193.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5193");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5193");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5193.fb");
  }
}
static Arrange_To_Call_Me vSTT5193(Test_STT5193, "STT5193", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5203  {
  void *fa;
  unsigned int bf:8;
  long fb;
};
//SIG(1 STT5203) C1{ Fp Fi:8 Fl}



static void Test_STT5203()
{
  {
    init_simple_test("STT5203");
    static STT5203 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5203)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5203)");
    check_field_offset(lv, fa, 0, "STT5203.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5203");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5203");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5203.fb");
  }
}
static Arrange_To_Call_Me vSTT5203(Test_STT5203, "STT5203", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5213  {
  void *fa;
  __tsu64 bf:8;
  long fb;
};
//SIG(1 STT5213) C1{ Fp FL:8 Fl}



static void Test_STT5213()
{
  {
    init_simple_test("STT5213");
    static STT5213 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5213)");
    check_field_offset(lv, fa, 0, "STT5213.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5213");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5213");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5213.fb");
  }
}
static Arrange_To_Call_Me vSTT5213(Test_STT5213, "STT5213", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5223  {
  void *fa;
  unsigned int bf:18;
  long fb;
};
//SIG(1 STT5223) C1{ Fp Fi:18 Fl}



static void Test_STT5223()
{
  {
    init_simple_test("STT5223");
    static STT5223 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5223)");
    check_field_offset(lv, fa, 0, "STT5223.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5223");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5223");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5223.fb");
  }
}
static Arrange_To_Call_Me vSTT5223(Test_STT5223, "STT5223", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5233  {
  void *fa;
  __tsu64 bf:18;
  long fb;
};
//SIG(1 STT5233) C1{ Fp FL:18 Fl}



static void Test_STT5233()
{
  {
    init_simple_test("STT5233");
    static STT5233 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5233)");
    check_field_offset(lv, fa, 0, "STT5233.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5233");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5233");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5233.fb");
  }
}
static Arrange_To_Call_Me vSTT5233(Test_STT5233, "STT5233", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5243  {
  void *fa;
  __tsu64 bf:48;
  long fb;
};
//SIG(1 STT5243) C1{ Fp FL:48 Fl}



static void Test_STT5243()
{
  {
    init_simple_test("STT5243");
    static STT5243 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5243)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5243)");
    check_field_offset(lv, fa, 0, "STT5243.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5243");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5243");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5243.fb");
  }
}
static Arrange_To_Call_Me vSTT5243(Test_STT5243, "STT5243", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT514  {
  void *fa;
  unsigned char  :0;
  __tsi64 fb;
};
//SIG(1 STT514) C1{ Fp Fc:0 FL}



static void Test_STT514()
{
  {
    init_simple_test("STT514");
    static STT514 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT514)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT514)");
    check_field_offset(lv, fa, 0, "STT514.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT514.fb");
  }
}
static Arrange_To_Call_Me vSTT514(Test_STT514, "STT514", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT524  {
  void *fa;
  unsigned short  :0;
  __tsi64 fb;
};
//SIG(1 STT524) C1{ Fp Fs:0 FL}



static void Test_STT524()
{
  {
    init_simple_test("STT524");
    static STT524 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT524)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT524)");
    check_field_offset(lv, fa, 0, "STT524.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT524.fb");
  }
}
static Arrange_To_Call_Me vSTT524(Test_STT524, "STT524", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT534  {
  void *fa;
  unsigned int  :0;
  __tsi64 fb;
};
//SIG(1 STT534) C1{ Fp Fi:0 FL}



static void Test_STT534()
{
  {
    init_simple_test("STT534");
    static STT534 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT534)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT534)");
    check_field_offset(lv, fa, 0, "STT534.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT534.fb");
  }
}
static Arrange_To_Call_Me vSTT534(Test_STT534, "STT534", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT544  {
  void *fa;
  __tsu64  :0;
  __tsi64 fb;
};
//SIG(1 STT544) C1{ Fp FL:0 FL}



static void Test_STT544()
{
  {
    init_simple_test("STT544");
    static STT544 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT544)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT544)");
    check_field_offset(lv, fa, 0, "STT544.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT544.fb");
  }
}
static Arrange_To_Call_Me vSTT544(Test_STT544, "STT544", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT554  {
  void *fa;
  unsigned char  :3;
  __tsi64 fb;
};
//SIG(1 STT554) C1{ Fp Fc:3 FL}



static void Test_STT554()
{
  {
    init_simple_test("STT554");
    static STT554 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT554)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT554)");
    check_field_offset(lv, fa, 0, "STT554.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT554.fb");
  }
}
static Arrange_To_Call_Me vSTT554(Test_STT554, "STT554", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT564  {
  void *fa;
  unsigned short  :3;
  __tsi64 fb;
};
//SIG(1 STT564) C1{ Fp Fs:3 FL}



static void Test_STT564()
{
  {
    init_simple_test("STT564");
    static STT564 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT564)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT564)");
    check_field_offset(lv, fa, 0, "STT564.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT564.fb");
  }
}
static Arrange_To_Call_Me vSTT564(Test_STT564, "STT564", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT574  {
  void *fa;
  unsigned int  :3;
  __tsi64 fb;
};
//SIG(1 STT574) C1{ Fp Fi:3 FL}



static void Test_STT574()
{
  {
    init_simple_test("STT574");
    static STT574 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT574)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT574)");
    check_field_offset(lv, fa, 0, "STT574.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT574.fb");
  }
}
static Arrange_To_Call_Me vSTT574(Test_STT574, "STT574", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT584  {
  void *fa;
  __tsu64  :3;
  __tsi64 fb;
};
//SIG(1 STT584) C1{ Fp FL:3 FL}



static void Test_STT584()
{
  {
    init_simple_test("STT584");
    static STT584 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT584)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT584)");
    check_field_offset(lv, fa, 0, "STT584.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT584.fb");
  }
}
static Arrange_To_Call_Me vSTT584(Test_STT584, "STT584", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT594  {
  void *fa;
  unsigned short  :8;
  __tsi64 fb;
};
//SIG(1 STT594) C1{ Fp Fs:8 FL}



static void Test_STT594()
{
  {
    init_simple_test("STT594");
    static STT594 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT594)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT594)");
    check_field_offset(lv, fa, 0, "STT594.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT594.fb");
  }
}
static Arrange_To_Call_Me vSTT594(Test_STT594, "STT594", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5104  {
  void *fa;
  unsigned int  :8;
  __tsi64 fb;
};
//SIG(1 STT5104) C1{ Fp Fi:8 FL}



static void Test_STT5104()
{
  {
    init_simple_test("STT5104");
    static STT5104 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5104)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5104)");
    check_field_offset(lv, fa, 0, "STT5104.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5104.fb");
  }
}
static Arrange_To_Call_Me vSTT5104(Test_STT5104, "STT5104", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5114  {
  void *fa;
  __tsu64  :8;
  __tsi64 fb;
};
//SIG(1 STT5114) C1{ Fp FL:8 FL}



static void Test_STT5114()
{
  {
    init_simple_test("STT5114");
    static STT5114 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5114)");
    check_field_offset(lv, fa, 0, "STT5114.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5114.fb");
  }
}
static Arrange_To_Call_Me vSTT5114(Test_STT5114, "STT5114", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5124  {
  void *fa;
  unsigned int  :18;
  __tsi64 fb;
};
//SIG(1 STT5124) C1{ Fp Fi:18 FL}



static void Test_STT5124()
{
  {
    init_simple_test("STT5124");
    static STT5124 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5124)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5124)");
    check_field_offset(lv, fa, 0, "STT5124.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5124.fb");
  }
}
static Arrange_To_Call_Me vSTT5124(Test_STT5124, "STT5124", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5134  {
  void *fa;
  __tsu64  :18;
  __tsi64 fb;
};
//SIG(1 STT5134) C1{ Fp FL:18 FL}



static void Test_STT5134()
{
  {
    init_simple_test("STT5134");
    static STT5134 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5134)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5134)");
    check_field_offset(lv, fa, 0, "STT5134.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5134.fb");
  }
}
static Arrange_To_Call_Me vSTT5134(Test_STT5134, "STT5134", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5144  {
  void *fa;
  __tsu64  :48;
  __tsi64 fb;
};
//SIG(1 STT5144) C1{ Fp FL:48 FL}



static void Test_STT5144()
{
  {
    init_simple_test("STT5144");
    static STT5144 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT5144)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5144)");
    check_field_offset(lv, fa, 0, "STT5144.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5144.fb");
  }
}
static Arrange_To_Call_Me vSTT5144(Test_STT5144, "STT5144", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5154  {
  void *fa;
  unsigned char bf:3;
  __tsi64 fb;
};
//SIG(1 STT5154) C1{ Fp Fc:3 FL}



static void Test_STT5154()
{
  {
    init_simple_test("STT5154");
    static STT5154 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5154)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5154)");
    check_field_offset(lv, fa, 0, "STT5154.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5154");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5154");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5154.fb");
  }
}
static Arrange_To_Call_Me vSTT5154(Test_STT5154, "STT5154", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5164  {
  void *fa;
  unsigned short bf:3;
  __tsi64 fb;
};
//SIG(1 STT5164) C1{ Fp Fs:3 FL}



static void Test_STT5164()
{
  {
    init_simple_test("STT5164");
    static STT5164 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5164)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5164)");
    check_field_offset(lv, fa, 0, "STT5164.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5164");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5164");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5164.fb");
  }
}
static Arrange_To_Call_Me vSTT5164(Test_STT5164, "STT5164", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5174  {
  void *fa;
  unsigned int bf:3;
  __tsi64 fb;
};
//SIG(1 STT5174) C1{ Fp Fi:3 FL}



static void Test_STT5174()
{
  {
    init_simple_test("STT5174");
    static STT5174 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5174)");
    check_field_offset(lv, fa, 0, "STT5174.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5174");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5174");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5174.fb");
  }
}
static Arrange_To_Call_Me vSTT5174(Test_STT5174, "STT5174", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5184  {
  void *fa;
  __tsu64 bf:3;
  __tsi64 fb;
};
//SIG(1 STT5184) C1{ Fp FL:3 FL}



static void Test_STT5184()
{
  {
    init_simple_test("STT5184");
    static STT5184 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5184)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5184)");
    check_field_offset(lv, fa, 0, "STT5184.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5184");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5184");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5184.fb");
  }
}
static Arrange_To_Call_Me vSTT5184(Test_STT5184, "STT5184", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5194  {
  void *fa;
  unsigned short bf:8;
  __tsi64 fb;
};
//SIG(1 STT5194) C1{ Fp Fs:8 FL}



static void Test_STT5194()
{
  {
    init_simple_test("STT5194");
    static STT5194 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5194)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5194)");
    check_field_offset(lv, fa, 0, "STT5194.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5194");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5194");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5194.fb");
  }
}
static Arrange_To_Call_Me vSTT5194(Test_STT5194, "STT5194", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5204  {
  void *fa;
  unsigned int bf:8;
  __tsi64 fb;
};
//SIG(1 STT5204) C1{ Fp Fi:8 FL}



static void Test_STT5204()
{
  {
    init_simple_test("STT5204");
    static STT5204 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5204)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5204)");
    check_field_offset(lv, fa, 0, "STT5204.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5204");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5204");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5204.fb");
  }
}
static Arrange_To_Call_Me vSTT5204(Test_STT5204, "STT5204", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5214  {
  void *fa;
  __tsu64 bf:8;
  __tsi64 fb;
};
//SIG(1 STT5214) C1{ Fp FL:8 FL}



static void Test_STT5214()
{
  {
    init_simple_test("STT5214");
    static STT5214 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5214)");
    check_field_offset(lv, fa, 0, "STT5214.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5214");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5214");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5214.fb");
  }
}
static Arrange_To_Call_Me vSTT5214(Test_STT5214, "STT5214", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5224  {
  void *fa;
  unsigned int bf:18;
  __tsi64 fb;
};
//SIG(1 STT5224) C1{ Fp Fi:18 FL}



static void Test_STT5224()
{
  {
    init_simple_test("STT5224");
    static STT5224 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5224)");
    check_field_offset(lv, fa, 0, "STT5224.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5224");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5224");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5224.fb");
  }
}
static Arrange_To_Call_Me vSTT5224(Test_STT5224, "STT5224", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5234  {
  void *fa;
  __tsu64 bf:18;
  __tsi64 fb;
};
//SIG(1 STT5234) C1{ Fp FL:18 FL}



static void Test_STT5234()
{
  {
    init_simple_test("STT5234");
    static STT5234 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5234)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5234)");
    check_field_offset(lv, fa, 0, "STT5234.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5234");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5234");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5234.fb");
  }
}
static Arrange_To_Call_Me vSTT5234(Test_STT5234, "STT5234", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5244  {
  void *fa;
  __tsu64 bf:48;
  __tsi64 fb;
};
//SIG(1 STT5244) C1{ Fp FL:48 FL}



static void Test_STT5244()
{
  {
    init_simple_test("STT5244");
    static STT5244 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT5244)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5244)");
    check_field_offset(lv, fa, 0, "STT5244.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5244");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5244");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5244.fb");
  }
}
static Arrange_To_Call_Me vSTT5244(Test_STT5244, "STT5244", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT515  {
  void *fa;
  unsigned char  :0;
  void *fb;
};
//SIG(1 STT515) C1{ Fp Fc:0 Fp}



static void Test_STT515()
{
  {
    init_simple_test("STT515");
    static STT515 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT515)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT515)");
    check_field_offset(lv, fa, 0, "STT515.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT515.fb");
  }
}
static Arrange_To_Call_Me vSTT515(Test_STT515, "STT515", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT525  {
  void *fa;
  unsigned short  :0;
  void *fb;
};
//SIG(1 STT525) C1{ Fp Fs:0 Fp}



static void Test_STT525()
{
  {
    init_simple_test("STT525");
    static STT525 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT525)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT525)");
    check_field_offset(lv, fa, 0, "STT525.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT525.fb");
  }
}
static Arrange_To_Call_Me vSTT525(Test_STT525, "STT525", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT535  {
  void *fa;
  unsigned int  :0;
  void *fb;
};
//SIG(1 STT535) C1{ Fp Fi:0 Fp}



static void Test_STT535()
{
  {
    init_simple_test("STT535");
    static STT535 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT535)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT535)");
    check_field_offset(lv, fa, 0, "STT535.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT535.fb");
  }
}
static Arrange_To_Call_Me vSTT535(Test_STT535, "STT535", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT545  {
  void *fa;
  __tsu64  :0;
  void *fb;
};
//SIG(1 STT545) C1{ Fp FL:0 Fp}



static void Test_STT545()
{
  {
    init_simple_test("STT545");
    static STT545 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT545)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT545)");
    check_field_offset(lv, fa, 0, "STT545.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT545.fb");
  }
}
static Arrange_To_Call_Me vSTT545(Test_STT545, "STT545", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT555  {
  void *fa;
  unsigned char  :3;
  void *fb;
};
//SIG(1 STT555) C1{ Fp Fc:3 Fp}



static void Test_STT555()
{
  {
    init_simple_test("STT555");
    static STT555 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT555)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT555)");
    check_field_offset(lv, fa, 0, "STT555.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT555.fb");
  }
}
static Arrange_To_Call_Me vSTT555(Test_STT555, "STT555", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT565  {
  void *fa;
  unsigned short  :3;
  void *fb;
};
//SIG(1 STT565) C1{ Fp Fs:3 Fp}



static void Test_STT565()
{
  {
    init_simple_test("STT565");
    static STT565 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT565)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT565)");
    check_field_offset(lv, fa, 0, "STT565.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT565.fb");
  }
}
static Arrange_To_Call_Me vSTT565(Test_STT565, "STT565", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT575  {
  void *fa;
  unsigned int  :3;
  void *fb;
};
//SIG(1 STT575) C1{ Fp Fi:3 Fp}



static void Test_STT575()
{
  {
    init_simple_test("STT575");
    static STT575 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT575)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT575)");
    check_field_offset(lv, fa, 0, "STT575.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT575.fb");
  }
}
static Arrange_To_Call_Me vSTT575(Test_STT575, "STT575", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT585  {
  void *fa;
  __tsu64  :3;
  void *fb;
};
//SIG(1 STT585) C1{ Fp FL:3 Fp}



static void Test_STT585()
{
  {
    init_simple_test("STT585");
    static STT585 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT585)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT585)");
    check_field_offset(lv, fa, 0, "STT585.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT585.fb");
  }
}
static Arrange_To_Call_Me vSTT585(Test_STT585, "STT585", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT595  {
  void *fa;
  unsigned short  :8;
  void *fb;
};
//SIG(1 STT595) C1{ Fp Fs:8 Fp}



static void Test_STT595()
{
  {
    init_simple_test("STT595");
    static STT595 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT595)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT595)");
    check_field_offset(lv, fa, 0, "STT595.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT595.fb");
  }
}
static Arrange_To_Call_Me vSTT595(Test_STT595, "STT595", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5105  {
  void *fa;
  unsigned int  :8;
  void *fb;
};
//SIG(1 STT5105) C1{ Fp Fi:8 Fp}



static void Test_STT5105()
{
  {
    init_simple_test("STT5105");
    static STT5105 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5105)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5105)");
    check_field_offset(lv, fa, 0, "STT5105.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5105.fb");
  }
}
static Arrange_To_Call_Me vSTT5105(Test_STT5105, "STT5105", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5115  {
  void *fa;
  __tsu64  :8;
  void *fb;
};
//SIG(1 STT5115) C1{ Fp FL:8 Fp}



static void Test_STT5115()
{
  {
    init_simple_test("STT5115");
    static STT5115 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5115)");
    check_field_offset(lv, fa, 0, "STT5115.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5115.fb");
  }
}
static Arrange_To_Call_Me vSTT5115(Test_STT5115, "STT5115", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5125  {
  void *fa;
  unsigned int  :18;
  void *fb;
};
//SIG(1 STT5125) C1{ Fp Fi:18 Fp}



static void Test_STT5125()
{
  {
    init_simple_test("STT5125");
    static STT5125 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5125)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5125)");
    check_field_offset(lv, fa, 0, "STT5125.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5125.fb");
  }
}
static Arrange_To_Call_Me vSTT5125(Test_STT5125, "STT5125", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5135  {
  void *fa;
  __tsu64  :18;
  void *fb;
};
//SIG(1 STT5135) C1{ Fp FL:18 Fp}



static void Test_STT5135()
{
  {
    init_simple_test("STT5135");
    static STT5135 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5135)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5135)");
    check_field_offset(lv, fa, 0, "STT5135.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5135.fb");
  }
}
static Arrange_To_Call_Me vSTT5135(Test_STT5135, "STT5135", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5145  {
  void *fa;
  __tsu64  :48;
  void *fb;
};
//SIG(1 STT5145) C1{ Fp FL:48 Fp}



static void Test_STT5145()
{
  {
    init_simple_test("STT5145");
    static STT5145 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5145)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5145)");
    check_field_offset(lv, fa, 0, "STT5145.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5145.fb");
  }
}
static Arrange_To_Call_Me vSTT5145(Test_STT5145, "STT5145", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5155  {
  void *fa;
  unsigned char bf:3;
  void *fb;
};
//SIG(1 STT5155) C1{ Fp Fc:3 Fp}



static void Test_STT5155()
{
  {
    init_simple_test("STT5155");
    static STT5155 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5155)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5155)");
    check_field_offset(lv, fa, 0, "STT5155.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5155");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5155");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5155.fb");
  }
}
static Arrange_To_Call_Me vSTT5155(Test_STT5155, "STT5155", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5165  {
  void *fa;
  unsigned short bf:3;
  void *fb;
};
//SIG(1 STT5165) C1{ Fp Fs:3 Fp}



static void Test_STT5165()
{
  {
    init_simple_test("STT5165");
    static STT5165 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5165)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5165)");
    check_field_offset(lv, fa, 0, "STT5165.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5165");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5165");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5165.fb");
  }
}
static Arrange_To_Call_Me vSTT5165(Test_STT5165, "STT5165", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5175  {
  void *fa;
  unsigned int bf:3;
  void *fb;
};
//SIG(1 STT5175) C1{ Fp Fi:3 Fp}



static void Test_STT5175()
{
  {
    init_simple_test("STT5175");
    static STT5175 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5175)");
    check_field_offset(lv, fa, 0, "STT5175.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5175");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5175");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5175.fb");
  }
}
static Arrange_To_Call_Me vSTT5175(Test_STT5175, "STT5175", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5185  {
  void *fa;
  __tsu64 bf:3;
  void *fb;
};
//SIG(1 STT5185) C1{ Fp FL:3 Fp}



static void Test_STT5185()
{
  {
    init_simple_test("STT5185");
    static STT5185 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5185)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5185)");
    check_field_offset(lv, fa, 0, "STT5185.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5185");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5185");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5185.fb");
  }
}
static Arrange_To_Call_Me vSTT5185(Test_STT5185, "STT5185", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5195  {
  void *fa;
  unsigned short bf:8;
  void *fb;
};
//SIG(1 STT5195) C1{ Fp Fs:8 Fp}



static void Test_STT5195()
{
  {
    init_simple_test("STT5195");
    static STT5195 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5195)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5195)");
    check_field_offset(lv, fa, 0, "STT5195.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5195");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5195");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5195.fb");
  }
}
static Arrange_To_Call_Me vSTT5195(Test_STT5195, "STT5195", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5205  {
  void *fa;
  unsigned int bf:8;
  void *fb;
};
//SIG(1 STT5205) C1{ Fp Fi:8 Fp}



static void Test_STT5205()
{
  {
    init_simple_test("STT5205");
    static STT5205 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5205)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5205)");
    check_field_offset(lv, fa, 0, "STT5205.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5205");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5205");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5205.fb");
  }
}
static Arrange_To_Call_Me vSTT5205(Test_STT5205, "STT5205", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5215  {
  void *fa;
  __tsu64 bf:8;
  void *fb;
};
//SIG(1 STT5215) C1{ Fp FL:8 Fp}



static void Test_STT5215()
{
  {
    init_simple_test("STT5215");
    static STT5215 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5215)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5215)");
    check_field_offset(lv, fa, 0, "STT5215.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5215");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5215");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5215.fb");
  }
}
static Arrange_To_Call_Me vSTT5215(Test_STT5215, "STT5215", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5225  {
  void *fa;
  unsigned int bf:18;
  void *fb;
};
//SIG(1 STT5225) C1{ Fp Fi:18 Fp}



static void Test_STT5225()
{
  {
    init_simple_test("STT5225");
    static STT5225 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5225)");
    check_field_offset(lv, fa, 0, "STT5225.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5225");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5225");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5225.fb");
  }
}
static Arrange_To_Call_Me vSTT5225(Test_STT5225, "STT5225", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5235  {
  void *fa;
  __tsu64 bf:18;
  void *fb;
};
//SIG(1 STT5235) C1{ Fp FL:18 Fp}



static void Test_STT5235()
{
  {
    init_simple_test("STT5235");
    static STT5235 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(STT5235)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5235)");
    check_field_offset(lv, fa, 0, "STT5235.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5235");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5235");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5235.fb");
  }
}
static Arrange_To_Call_Me vSTT5235(Test_STT5235, "STT5235", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5245  {
  void *fa;
  __tsu64 bf:48;
  void *fb;
};
//SIG(1 STT5245) C1{ Fp FL:48 Fp}



static void Test_STT5245()
{
  {
    init_simple_test("STT5245");
    static STT5245 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5245)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5245)");
    check_field_offset(lv, fa, 0, "STT5245.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5245");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5245");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5245.fb");
  }
}
static Arrange_To_Call_Me vSTT5245(Test_STT5245, "STT5245", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT516  {
  void *fa;
  unsigned char  :0;
  float fb;
};
//SIG(1 STT516) C1{ Fp Fc:0 Fi}



static void Test_STT516()
{
  {
    init_simple_test("STT516");
    static STT516 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT516)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT516)");
    check_field_offset(lv, fa, 0, "STT516.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT516.fb");
  }
}
static Arrange_To_Call_Me vSTT516(Test_STT516, "STT516", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT526  {
  void *fa;
  unsigned short  :0;
  float fb;
};
//SIG(1 STT526) C1{ Fp Fs:0 Fi}



static void Test_STT526()
{
  {
    init_simple_test("STT526");
    static STT526 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT526)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT526)");
    check_field_offset(lv, fa, 0, "STT526.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT526.fb");
  }
}
static Arrange_To_Call_Me vSTT526(Test_STT526, "STT526", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT536  {
  void *fa;
  unsigned int  :0;
  float fb;
};
//SIG(1 STT536) C1{ Fp Fi:0 Fi}



static void Test_STT536()
{
  {
    init_simple_test("STT536");
    static STT536 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT536)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT536)");
    check_field_offset(lv, fa, 0, "STT536.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT536.fb");
  }
}
static Arrange_To_Call_Me vSTT536(Test_STT536, "STT536", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT546  {
  void *fa;
  __tsu64  :0;
  float fb;
};
//SIG(1 STT546) C1{ Fp FL:0 Fi}



static void Test_STT546()
{
  {
    init_simple_test("STT546");
    static STT546 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT546)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT546)");
    check_field_offset(lv, fa, 0, "STT546.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT546.fb");
  }
}
static Arrange_To_Call_Me vSTT546(Test_STT546, "STT546", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT556  {
  void *fa;
  unsigned char  :3;
  float fb;
};
//SIG(1 STT556) C1{ Fp Fc:3 Fi}



static void Test_STT556()
{
  {
    init_simple_test("STT556");
    static STT556 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT556)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT556)");
    check_field_offset(lv, fa, 0, "STT556.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT556.fb");
  }
}
static Arrange_To_Call_Me vSTT556(Test_STT556, "STT556", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT566  {
  void *fa;
  unsigned short  :3;
  float fb;
};
//SIG(1 STT566) C1{ Fp Fs:3 Fi}



static void Test_STT566()
{
  {
    init_simple_test("STT566");
    static STT566 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT566)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT566)");
    check_field_offset(lv, fa, 0, "STT566.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT566.fb");
  }
}
static Arrange_To_Call_Me vSTT566(Test_STT566, "STT566", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT576  {
  void *fa;
  unsigned int  :3;
  float fb;
};
//SIG(1 STT576) C1{ Fp Fi:3 Fi}



static void Test_STT576()
{
  {
    init_simple_test("STT576");
    static STT576 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT576)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT576)");
    check_field_offset(lv, fa, 0, "STT576.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT576.fb");
  }
}
static Arrange_To_Call_Me vSTT576(Test_STT576, "STT576", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT586  {
  void *fa;
  __tsu64  :3;
  float fb;
};
//SIG(1 STT586) C1{ Fp FL:3 Fi}



static void Test_STT586()
{
  {
    init_simple_test("STT586");
    static STT586 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT586)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT586)");
    check_field_offset(lv, fa, 0, "STT586.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT586.fb");
  }
}
static Arrange_To_Call_Me vSTT586(Test_STT586, "STT586", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT596  {
  void *fa;
  unsigned short  :8;
  float fb;
};
//SIG(1 STT596) C1{ Fp Fs:8 Fi}



static void Test_STT596()
{
  {
    init_simple_test("STT596");
    static STT596 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT596)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT596)");
    check_field_offset(lv, fa, 0, "STT596.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT596.fb");
  }
}
static Arrange_To_Call_Me vSTT596(Test_STT596, "STT596", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5106  {
  void *fa;
  unsigned int  :8;
  float fb;
};
//SIG(1 STT5106) C1{ Fp Fi:8 Fi}



static void Test_STT5106()
{
  {
    init_simple_test("STT5106");
    static STT5106 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5106)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5106)");
    check_field_offset(lv, fa, 0, "STT5106.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5106.fb");
  }
}
static Arrange_To_Call_Me vSTT5106(Test_STT5106, "STT5106", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5116  {
  void *fa;
  __tsu64  :8;
  float fb;
};
//SIG(1 STT5116) C1{ Fp FL:8 Fi}



static void Test_STT5116()
{
  {
    init_simple_test("STT5116");
    static STT5116 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5116)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5116)");
    check_field_offset(lv, fa, 0, "STT5116.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5116.fb");
  }
}
static Arrange_To_Call_Me vSTT5116(Test_STT5116, "STT5116", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5126  {
  void *fa;
  unsigned int  :18;
  float fb;
};
//SIG(1 STT5126) C1{ Fp Fi:18 Fi}



static void Test_STT5126()
{
  {
    init_simple_test("STT5126");
    static STT5126 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5126)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5126)");
    check_field_offset(lv, fa, 0, "STT5126.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5126.fb");
  }
}
static Arrange_To_Call_Me vSTT5126(Test_STT5126, "STT5126", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5136  {
  void *fa;
  __tsu64  :18;
  float fb;
};
//SIG(1 STT5136) C1{ Fp FL:18 Fi}



static void Test_STT5136()
{
  {
    init_simple_test("STT5136");
    static STT5136 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5136)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5136)");
    check_field_offset(lv, fa, 0, "STT5136.fa");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5136.fb");
  }
}
static Arrange_To_Call_Me vSTT5136(Test_STT5136, "STT5136", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5146  {
  void *fa;
  __tsu64  :48;
  float fb;
};
//SIG(1 STT5146) C1{ Fp FL:48 Fi}



static void Test_STT5146()
{
  {
    init_simple_test("STT5146");
    static STT5146 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5146)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5146)");
    check_field_offset(lv, fa, 0, "STT5146.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5146.fb");
  }
}
static Arrange_To_Call_Me vSTT5146(Test_STT5146, "STT5146", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5156  {
  void *fa;
  unsigned char bf:3;
  float fb;
};
//SIG(1 STT5156) C1{ Fp Fc:3 Fi}



static void Test_STT5156()
{
  {
    init_simple_test("STT5156");
    static STT5156 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5156)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5156)");
    check_field_offset(lv, fa, 0, "STT5156.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5156");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5156");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5156.fb");
  }
}
static Arrange_To_Call_Me vSTT5156(Test_STT5156, "STT5156", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5166  {
  void *fa;
  unsigned short bf:3;
  float fb;
};
//SIG(1 STT5166) C1{ Fp Fs:3 Fi}



static void Test_STT5166()
{
  {
    init_simple_test("STT5166");
    static STT5166 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5166)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5166)");
    check_field_offset(lv, fa, 0, "STT5166.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5166");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5166");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5166.fb");
  }
}
static Arrange_To_Call_Me vSTT5166(Test_STT5166, "STT5166", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5176  {
  void *fa;
  unsigned int bf:3;
  float fb;
};
//SIG(1 STT5176) C1{ Fp Fi:3 Fi}



static void Test_STT5176()
{
  {
    init_simple_test("STT5176");
    static STT5176 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5176)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5176)");
    check_field_offset(lv, fa, 0, "STT5176.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5176");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5176");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5176.fb");
  }
}
static Arrange_To_Call_Me vSTT5176(Test_STT5176, "STT5176", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5186  {
  void *fa;
  __tsu64 bf:3;
  float fb;
};
//SIG(1 STT5186) C1{ Fp FL:3 Fi}



static void Test_STT5186()
{
  {
    init_simple_test("STT5186");
    static STT5186 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5186)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5186)");
    check_field_offset(lv, fa, 0, "STT5186.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5186");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5186");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5186.fb");
  }
}
static Arrange_To_Call_Me vSTT5186(Test_STT5186, "STT5186", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5196  {
  void *fa;
  unsigned short bf:8;
  float fb;
};
//SIG(1 STT5196) C1{ Fp Fs:8 Fi}



static void Test_STT5196()
{
  {
    init_simple_test("STT5196");
    static STT5196 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5196)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5196)");
    check_field_offset(lv, fa, 0, "STT5196.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5196");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5196");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5196.fb");
  }
}
static Arrange_To_Call_Me vSTT5196(Test_STT5196, "STT5196", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5206  {
  void *fa;
  unsigned int bf:8;
  float fb;
};
//SIG(1 STT5206) C1{ Fp Fi:8 Fi}



static void Test_STT5206()
{
  {
    init_simple_test("STT5206");
    static STT5206 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5206)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5206)");
    check_field_offset(lv, fa, 0, "STT5206.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5206");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5206");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5206.fb");
  }
}
static Arrange_To_Call_Me vSTT5206(Test_STT5206, "STT5206", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5216  {
  void *fa;
  __tsu64 bf:8;
  float fb;
};
//SIG(1 STT5216) C1{ Fp FL:8 Fi}



static void Test_STT5216()
{
  {
    init_simple_test("STT5216");
    static STT5216 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5216)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5216)");
    check_field_offset(lv, fa, 0, "STT5216.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5216");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5216");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5216.fb");
  }
}
static Arrange_To_Call_Me vSTT5216(Test_STT5216, "STT5216", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5226  {
  void *fa;
  unsigned int bf:18;
  float fb;
};
//SIG(1 STT5226) C1{ Fp Fi:18 Fi}



static void Test_STT5226()
{
  {
    init_simple_test("STT5226");
    static STT5226 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5226)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5226)");
    check_field_offset(lv, fa, 0, "STT5226.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5226");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5226");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5226.fb");
  }
}
static Arrange_To_Call_Me vSTT5226(Test_STT5226, "STT5226", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5236  {
  void *fa;
  __tsu64 bf:18;
  float fb;
};
//SIG(1 STT5236) C1{ Fp FL:18 Fi}



static void Test_STT5236()
{
  {
    init_simple_test("STT5236");
    static STT5236 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5236)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5236)");
    check_field_offset(lv, fa, 0, "STT5236.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5236");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5236");
    check_field_offset(lv, fb, ABISELECT(12,8), "STT5236.fb");
  }
}
static Arrange_To_Call_Me vSTT5236(Test_STT5236, "STT5236", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5246  {
  void *fa;
  __tsu64 bf:48;
  float fb;
};
//SIG(1 STT5246) C1{ Fp FL:48 Fi}



static void Test_STT5246()
{
  {
    init_simple_test("STT5246");
    static STT5246 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5246)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5246)");
    check_field_offset(lv, fa, 0, "STT5246.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5246");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5246");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5246.fb");
  }
}
static Arrange_To_Call_Me vSTT5246(Test_STT5246, "STT5246", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT517  {
  void *fa;
  unsigned char  :0;
  double fb;
};
//SIG(1 STT517) C1{ Fp Fc:0 FL}



static void Test_STT517()
{
  {
    init_simple_test("STT517");
    static STT517 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT517)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT517)");
    check_field_offset(lv, fa, 0, "STT517.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT517.fb");
  }
}
static Arrange_To_Call_Me vSTT517(Test_STT517, "STT517", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT527  {
  void *fa;
  unsigned short  :0;
  double fb;
};
//SIG(1 STT527) C1{ Fp Fs:0 FL}



static void Test_STT527()
{
  {
    init_simple_test("STT527");
    static STT527 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT527)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT527)");
    check_field_offset(lv, fa, 0, "STT527.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT527.fb");
  }
}
static Arrange_To_Call_Me vSTT527(Test_STT527, "STT527", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT537  {
  void *fa;
  unsigned int  :0;
  double fb;
};
//SIG(1 STT537) C1{ Fp Fi:0 FL}



static void Test_STT537()
{
  {
    init_simple_test("STT537");
    static STT537 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT537)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT537)");
    check_field_offset(lv, fa, 0, "STT537.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT537.fb");
  }
}
static Arrange_To_Call_Me vSTT537(Test_STT537, "STT537", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT547  {
  void *fa;
  __tsu64  :0;
  double fb;
};
//SIG(1 STT547) C1{ Fp FL:0 FL}



static void Test_STT547()
{
  {
    init_simple_test("STT547");
    static STT547 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT547)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT547)");
    check_field_offset(lv, fa, 0, "STT547.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT547.fb");
  }
}
static Arrange_To_Call_Me vSTT547(Test_STT547, "STT547", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT557  {
  void *fa;
  unsigned char  :3;
  double fb;
};
//SIG(1 STT557) C1{ Fp Fc:3 FL}



static void Test_STT557()
{
  {
    init_simple_test("STT557");
    static STT557 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT557)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT557)");
    check_field_offset(lv, fa, 0, "STT557.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT557.fb");
  }
}
static Arrange_To_Call_Me vSTT557(Test_STT557, "STT557", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT567  {
  void *fa;
  unsigned short  :3;
  double fb;
};
//SIG(1 STT567) C1{ Fp Fs:3 FL}



static void Test_STT567()
{
  {
    init_simple_test("STT567");
    static STT567 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT567)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT567)");
    check_field_offset(lv, fa, 0, "STT567.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT567.fb");
  }
}
static Arrange_To_Call_Me vSTT567(Test_STT567, "STT567", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT577  {
  void *fa;
  unsigned int  :3;
  double fb;
};
//SIG(1 STT577) C1{ Fp Fi:3 FL}



static void Test_STT577()
{
  {
    init_simple_test("STT577");
    static STT577 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT577)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT577)");
    check_field_offset(lv, fa, 0, "STT577.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT577.fb");
  }
}
static Arrange_To_Call_Me vSTT577(Test_STT577, "STT577", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT587  {
  void *fa;
  __tsu64  :3;
  double fb;
};
//SIG(1 STT587) C1{ Fp FL:3 FL}



static void Test_STT587()
{
  {
    init_simple_test("STT587");
    static STT587 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT587)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT587)");
    check_field_offset(lv, fa, 0, "STT587.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT587.fb");
  }
}
static Arrange_To_Call_Me vSTT587(Test_STT587, "STT587", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT597  {
  void *fa;
  unsigned short  :8;
  double fb;
};
//SIG(1 STT597) C1{ Fp Fs:8 FL}



static void Test_STT597()
{
  {
    init_simple_test("STT597");
    static STT597 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT597)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT597)");
    check_field_offset(lv, fa, 0, "STT597.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT597.fb");
  }
}
static Arrange_To_Call_Me vSTT597(Test_STT597, "STT597", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5107  {
  void *fa;
  unsigned int  :8;
  double fb;
};
//SIG(1 STT5107) C1{ Fp Fi:8 FL}



static void Test_STT5107()
{
  {
    init_simple_test("STT5107");
    static STT5107 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5107)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5107)");
    check_field_offset(lv, fa, 0, "STT5107.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5107.fb");
  }
}
static Arrange_To_Call_Me vSTT5107(Test_STT5107, "STT5107", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5117  {
  void *fa;
  __tsu64  :8;
  double fb;
};
//SIG(1 STT5117) C1{ Fp FL:8 FL}



static void Test_STT5117()
{
  {
    init_simple_test("STT5117");
    static STT5117 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5117)");
    check_field_offset(lv, fa, 0, "STT5117.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5117.fb");
  }
}
static Arrange_To_Call_Me vSTT5117(Test_STT5117, "STT5117", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5127  {
  void *fa;
  unsigned int  :18;
  double fb;
};
//SIG(1 STT5127) C1{ Fp Fi:18 FL}



static void Test_STT5127()
{
  {
    init_simple_test("STT5127");
    static STT5127 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5127)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5127)");
    check_field_offset(lv, fa, 0, "STT5127.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5127.fb");
  }
}
static Arrange_To_Call_Me vSTT5127(Test_STT5127, "STT5127", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5137  {
  void *fa;
  __tsu64  :18;
  double fb;
};
//SIG(1 STT5137) C1{ Fp FL:18 FL}



static void Test_STT5137()
{
  {
    init_simple_test("STT5137");
    static STT5137 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5137)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5137)");
    check_field_offset(lv, fa, 0, "STT5137.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5137.fb");
  }
}
static Arrange_To_Call_Me vSTT5137(Test_STT5137, "STT5137", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5147  {
  void *fa;
  __tsu64  :48;
  double fb;
};
//SIG(1 STT5147) C1{ Fp FL:48 FL}



static void Test_STT5147()
{
  {
    init_simple_test("STT5147");
    static STT5147 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT5147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5147)");
    check_field_offset(lv, fa, 0, "STT5147.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5147.fb");
  }
}
static Arrange_To_Call_Me vSTT5147(Test_STT5147, "STT5147", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5157  {
  void *fa;
  unsigned char bf:3;
  double fb;
};
//SIG(1 STT5157) C1{ Fp Fc:3 FL}



static void Test_STT5157()
{
  {
    init_simple_test("STT5157");
    static STT5157 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5157)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5157)");
    check_field_offset(lv, fa, 0, "STT5157.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5157");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5157");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5157.fb");
  }
}
static Arrange_To_Call_Me vSTT5157(Test_STT5157, "STT5157", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5167  {
  void *fa;
  unsigned short bf:3;
  double fb;
};
//SIG(1 STT5167) C1{ Fp Fs:3 FL}



static void Test_STT5167()
{
  {
    init_simple_test("STT5167");
    static STT5167 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5167)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5167)");
    check_field_offset(lv, fa, 0, "STT5167.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5167");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5167");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5167.fb");
  }
}
static Arrange_To_Call_Me vSTT5167(Test_STT5167, "STT5167", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5177  {
  void *fa;
  unsigned int bf:3;
  double fb;
};
//SIG(1 STT5177) C1{ Fp Fi:3 FL}



static void Test_STT5177()
{
  {
    init_simple_test("STT5177");
    static STT5177 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5177)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5177)");
    check_field_offset(lv, fa, 0, "STT5177.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5177");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5177");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5177.fb");
  }
}
static Arrange_To_Call_Me vSTT5177(Test_STT5177, "STT5177", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5187  {
  void *fa;
  __tsu64 bf:3;
  double fb;
};
//SIG(1 STT5187) C1{ Fp FL:3 FL}



static void Test_STT5187()
{
  {
    init_simple_test("STT5187");
    static STT5187 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5187)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5187)");
    check_field_offset(lv, fa, 0, "STT5187.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5187");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5187");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5187.fb");
  }
}
static Arrange_To_Call_Me vSTT5187(Test_STT5187, "STT5187", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5197  {
  void *fa;
  unsigned short bf:8;
  double fb;
};
//SIG(1 STT5197) C1{ Fp Fs:8 FL}



static void Test_STT5197()
{
  {
    init_simple_test("STT5197");
    static STT5197 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5197)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5197)");
    check_field_offset(lv, fa, 0, "STT5197.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5197");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5197");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5197.fb");
  }
}
static Arrange_To_Call_Me vSTT5197(Test_STT5197, "STT5197", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5207  {
  void *fa;
  unsigned int bf:8;
  double fb;
};
//SIG(1 STT5207) C1{ Fp Fi:8 FL}



static void Test_STT5207()
{
  {
    init_simple_test("STT5207");
    static STT5207 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5207)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5207)");
    check_field_offset(lv, fa, 0, "STT5207.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5207");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5207");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5207.fb");
  }
}
static Arrange_To_Call_Me vSTT5207(Test_STT5207, "STT5207", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5217  {
  void *fa;
  __tsu64 bf:8;
  double fb;
};
//SIG(1 STT5217) C1{ Fp FL:8 FL}



static void Test_STT5217()
{
  {
    init_simple_test("STT5217");
    static STT5217 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5217)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5217)");
    check_field_offset(lv, fa, 0, "STT5217.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5217");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5217");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5217.fb");
  }
}
static Arrange_To_Call_Me vSTT5217(Test_STT5217, "STT5217", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5227  {
  void *fa;
  unsigned int bf:18;
  double fb;
};
//SIG(1 STT5227) C1{ Fp Fi:18 FL}



static void Test_STT5227()
{
  {
    init_simple_test("STT5227");
    static STT5227 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5227)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5227)");
    check_field_offset(lv, fa, 0, "STT5227.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5227");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5227");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5227.fb");
  }
}
static Arrange_To_Call_Me vSTT5227(Test_STT5227, "STT5227", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5237  {
  void *fa;
  __tsu64 bf:18;
  double fb;
};
//SIG(1 STT5237) C1{ Fp FL:18 FL}



static void Test_STT5237()
{
  {
    init_simple_test("STT5237");
    static STT5237 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(STT5237)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5237)");
    check_field_offset(lv, fa, 0, "STT5237.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5237");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5237");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5237.fb");
  }
}
static Arrange_To_Call_Me vSTT5237(Test_STT5237, "STT5237", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5247  {
  void *fa;
  __tsu64 bf:48;
  double fb;
};
//SIG(1 STT5247) C1{ Fp FL:48 FL}



static void Test_STT5247()
{
  {
    init_simple_test("STT5247");
    static STT5247 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(STT5247)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5247)");
    check_field_offset(lv, fa, 0, "STT5247.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5247");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5247");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5247.fb");
  }
}
static Arrange_To_Call_Me vSTT5247(Test_STT5247, "STT5247", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT518  {
  void *fa;
  unsigned char  :0;
  long double fb;
};
//SIG(1 STT518) C1{ Fp Fc:0 FD}



static void Test_STT518()
{
  {
    init_simple_test("STT518");
    static STT518 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT518)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT518)");
    check_field_offset(lv, fa, 0, "STT518.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT518.fb");
  }
}
static Arrange_To_Call_Me vSTT518(Test_STT518, "STT518", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT528  {
  void *fa;
  unsigned short  :0;
  long double fb;
};
//SIG(1 STT528) C1{ Fp Fs:0 FD}



static void Test_STT528()
{
  {
    init_simple_test("STT528");
    static STT528 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT528)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT528)");
    check_field_offset(lv, fa, 0, "STT528.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT528.fb");
  }
}
static Arrange_To_Call_Me vSTT528(Test_STT528, "STT528", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT538  {
  void *fa;
  unsigned int  :0;
  long double fb;
};
//SIG(1 STT538) C1{ Fp Fi:0 FD}



static void Test_STT538()
{
  {
    init_simple_test("STT538");
    static STT538 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT538)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT538)");
    check_field_offset(lv, fa, 0, "STT538.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT538.fb");
  }
}
static Arrange_To_Call_Me vSTT538(Test_STT538, "STT538", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT548  {
  void *fa;
  __tsu64  :0;
  long double fb;
};
//SIG(1 STT548) C1{ Fp FL:0 FD}



static void Test_STT548()
{
  {
    init_simple_test("STT548");
    static STT548 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(STT548)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT548)");
    check_field_offset(lv, fa, 0, "STT548.fa");
    check_field_offset(lv, fb, ABISELECT(16,4), "STT548.fb");
  }
}
static Arrange_To_Call_Me vSTT548(Test_STT548, "STT548", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT558  {
  void *fa;
  unsigned char  :3;
  long double fb;
};
//SIG(1 STT558) C1{ Fp Fc:3 FD}



static void Test_STT558()
{
  {
    init_simple_test("STT558");
    static STT558 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT558)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT558)");
    check_field_offset(lv, fa, 0, "STT558.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT558.fb");
  }
}
static Arrange_To_Call_Me vSTT558(Test_STT558, "STT558", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT568  {
  void *fa;
  unsigned short  :3;
  long double fb;
};
//SIG(1 STT568) C1{ Fp Fs:3 FD}



static void Test_STT568()
{
  {
    init_simple_test("STT568");
    static STT568 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT568)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT568)");
    check_field_offset(lv, fa, 0, "STT568.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT568.fb");
  }
}
static Arrange_To_Call_Me vSTT568(Test_STT568, "STT568", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT578  {
  void *fa;
  unsigned int  :3;
  long double fb;
};
//SIG(1 STT578) C1{ Fp Fi:3 FD}



static void Test_STT578()
{
  {
    init_simple_test("STT578");
    static STT578 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT578)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT578)");
    check_field_offset(lv, fa, 0, "STT578.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT578.fb");
  }
}
static Arrange_To_Call_Me vSTT578(Test_STT578, "STT578", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT588  {
  void *fa;
  __tsu64  :3;
  long double fb;
};
//SIG(1 STT588) C1{ Fp FL:3 FD}



static void Test_STT588()
{
  {
    init_simple_test("STT588");
    static STT588 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT588)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT588)");
    check_field_offset(lv, fa, 0, "STT588.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT588.fb");
  }
}
static Arrange_To_Call_Me vSTT588(Test_STT588, "STT588", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT598  {
  void *fa;
  unsigned short  :8;
  long double fb;
};
//SIG(1 STT598) C1{ Fp Fs:8 FD}



static void Test_STT598()
{
  {
    init_simple_test("STT598");
    static STT598 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT598)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT598)");
    check_field_offset(lv, fa, 0, "STT598.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT598.fb");
  }
}
static Arrange_To_Call_Me vSTT598(Test_STT598, "STT598", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5108  {
  void *fa;
  unsigned int  :8;
  long double fb;
};
//SIG(1 STT5108) C1{ Fp Fi:8 FD}



static void Test_STT5108()
{
  {
    init_simple_test("STT5108");
    static STT5108 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5108)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5108)");
    check_field_offset(lv, fa, 0, "STT5108.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5108.fb");
  }
}
static Arrange_To_Call_Me vSTT5108(Test_STT5108, "STT5108", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5118  {
  void *fa;
  __tsu64  :8;
  long double fb;
};
//SIG(1 STT5118) C1{ Fp FL:8 FD}



static void Test_STT5118()
{
  {
    init_simple_test("STT5118");
    static STT5118 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5118)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5118)");
    check_field_offset(lv, fa, 0, "STT5118.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5118.fb");
  }
}
static Arrange_To_Call_Me vSTT5118(Test_STT5118, "STT5118", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5128  {
  void *fa;
  unsigned int  :18;
  long double fb;
};
//SIG(1 STT5128) C1{ Fp Fi:18 FD}



static void Test_STT5128()
{
  {
    init_simple_test("STT5128");
    static STT5128 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5128)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5128)");
    check_field_offset(lv, fa, 0, "STT5128.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5128.fb");
  }
}
static Arrange_To_Call_Me vSTT5128(Test_STT5128, "STT5128", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5138  {
  void *fa;
  __tsu64  :18;
  long double fb;
};
//SIG(1 STT5138) C1{ Fp FL:18 FD}



static void Test_STT5138()
{
  {
    init_simple_test("STT5138");
    static STT5138 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5138)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5138)");
    check_field_offset(lv, fa, 0, "STT5138.fa");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5138.fb");
  }
}
static Arrange_To_Call_Me vSTT5138(Test_STT5138, "STT5138", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5148  {
  void *fa;
  __tsu64  :48;
  long double fb;
};
//SIG(1 STT5148) C1{ Fp FL:48 FD}



static void Test_STT5148()
{
  {
    init_simple_test("STT5148");
    static STT5148 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT5148)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5148)");
    check_field_offset(lv, fa, 0, "STT5148.fa");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5148.fb");
  }
}
static Arrange_To_Call_Me vSTT5148(Test_STT5148, "STT5148", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5158  {
  void *fa;
  unsigned char bf:3;
  long double fb;
};
//SIG(1 STT5158) C1{ Fp Fc:3 FD}



static void Test_STT5158()
{
  {
    init_simple_test("STT5158");
    static STT5158 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5158)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5158)");
    check_field_offset(lv, fa, 0, "STT5158.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5158");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5158");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5158.fb");
  }
}
static Arrange_To_Call_Me vSTT5158(Test_STT5158, "STT5158", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5168  {
  void *fa;
  unsigned short bf:3;
  long double fb;
};
//SIG(1 STT5168) C1{ Fp Fs:3 FD}



static void Test_STT5168()
{
  {
    init_simple_test("STT5168");
    static STT5168 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5168)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5168)");
    check_field_offset(lv, fa, 0, "STT5168.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5168");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5168");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5168.fb");
  }
}
static Arrange_To_Call_Me vSTT5168(Test_STT5168, "STT5168", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5178  {
  void *fa;
  unsigned int bf:3;
  long double fb;
};
//SIG(1 STT5178) C1{ Fp Fi:3 FD}



static void Test_STT5178()
{
  {
    init_simple_test("STT5178");
    static STT5178 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5178)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5178)");
    check_field_offset(lv, fa, 0, "STT5178.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5178");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5178");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5178.fb");
  }
}
static Arrange_To_Call_Me vSTT5178(Test_STT5178, "STT5178", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5188  {
  void *fa;
  __tsu64 bf:3;
  long double fb;
};
//SIG(1 STT5188) C1{ Fp FL:3 FD}



static void Test_STT5188()
{
  {
    init_simple_test("STT5188");
    static STT5188 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5188)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5188)");
    check_field_offset(lv, fa, 0, "STT5188.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5188");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5188");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5188.fb");
  }
}
static Arrange_To_Call_Me vSTT5188(Test_STT5188, "STT5188", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5198  {
  void *fa;
  unsigned short bf:8;
  long double fb;
};
//SIG(1 STT5198) C1{ Fp Fs:8 FD}



static void Test_STT5198()
{
  {
    init_simple_test("STT5198");
    static STT5198 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5198)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5198)");
    check_field_offset(lv, fa, 0, "STT5198.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5198");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5198");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5198.fb");
  }
}
static Arrange_To_Call_Me vSTT5198(Test_STT5198, "STT5198", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5208  {
  void *fa;
  unsigned int bf:8;
  long double fb;
};
//SIG(1 STT5208) C1{ Fp Fi:8 FD}



static void Test_STT5208()
{
  {
    init_simple_test("STT5208");
    static STT5208 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5208)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5208)");
    check_field_offset(lv, fa, 0, "STT5208.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5208");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5208");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5208.fb");
  }
}
static Arrange_To_Call_Me vSTT5208(Test_STT5208, "STT5208", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5218  {
  void *fa;
  __tsu64 bf:8;
  long double fb;
};
//SIG(1 STT5218) C1{ Fp FL:8 FD}



static void Test_STT5218()
{
  {
    init_simple_test("STT5218");
    static STT5218 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5218)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5218)");
    check_field_offset(lv, fa, 0, "STT5218.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5218");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5218");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5218.fb");
  }
}
static Arrange_To_Call_Me vSTT5218(Test_STT5218, "STT5218", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5228  {
  void *fa;
  unsigned int bf:18;
  long double fb;
};
//SIG(1 STT5228) C1{ Fp Fi:18 FD}



static void Test_STT5228()
{
  {
    init_simple_test("STT5228");
    static STT5228 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5228)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5228)");
    check_field_offset(lv, fa, 0, "STT5228.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5228");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5228");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5228.fb");
  }
}
static Arrange_To_Call_Me vSTT5228(Test_STT5228, "STT5228", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5238  {
  void *fa;
  __tsu64 bf:18;
  long double fb;
};
//SIG(1 STT5238) C1{ Fp FL:18 FD}



static void Test_STT5238()
{
  {
    init_simple_test("STT5238");
    static STT5238 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(STT5238)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5238)");
    check_field_offset(lv, fa, 0, "STT5238.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5238");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5238");
    check_field_offset(lv, fb, ABISELECT(16,8), "STT5238.fb");
  }
}
static Arrange_To_Call_Me vSTT5238(Test_STT5238, "STT5238", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5248  {
  void *fa;
  __tsu64 bf:48;
  long double fb;
};
//SIG(1 STT5248) C1{ Fp FL:48 FD}



static void Test_STT5248()
{
  {
    init_simple_test("STT5248");
    static STT5248 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(STT5248)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(STT5248)");
    check_field_offset(lv, fa, 0, "STT5248.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5248");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5248");
    check_field_offset(lv, fb, ABISELECT(16,12), "STT5248.fb");
  }
}
static Arrange_To_Call_Me vSTT5248(Test_STT5248, "STT5248", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT519  {
  void *fa;
  unsigned char  :0;
};
//SIG(1 STT519) C1{ Fp Fc:0}



static void Test_STT519()
{
  {
    init_simple_test("STT519");
    static STT519 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT519)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT519)");
    check_field_offset(lv, fa, 0, "STT519.fa");
  }
}
static Arrange_To_Call_Me vSTT519(Test_STT519, "STT519", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT529  {
  void *fa;
  unsigned short  :0;
};
//SIG(1 STT529) C1{ Fp Fs:0}



static void Test_STT529()
{
  {
    init_simple_test("STT529");
    static STT529 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT529)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT529)");
    check_field_offset(lv, fa, 0, "STT529.fa");
  }
}
static Arrange_To_Call_Me vSTT529(Test_STT529, "STT529", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT539  {
  void *fa;
  unsigned int  :0;
};
//SIG(1 STT539) C1{ Fp Fi:0}



static void Test_STT539()
{
  {
    init_simple_test("STT539");
    static STT539 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT539)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT539)");
    check_field_offset(lv, fa, 0, "STT539.fa");
  }
}
static Arrange_To_Call_Me vSTT539(Test_STT539, "STT539", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT549  {
  void *fa;
  __tsu64  :0;
};
//SIG(1 STT549) C1{ Fp FL:0}



static void Test_STT549()
{
  {
    init_simple_test("STT549");
    static STT549 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(STT549)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT549)");
    check_field_offset(lv, fa, 0, "STT549.fa");
  }
}
static Arrange_To_Call_Me vSTT549(Test_STT549, "STT549", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT559  {
  void *fa;
  unsigned char  :3;
};
//SIG(1 STT559) C1{ Fp Fc:3}



static void Test_STT559()
{
  {
    init_simple_test("STT559");
    static STT559 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT559)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT559)");
    check_field_offset(lv, fa, 0, "STT559.fa");
  }
}
static Arrange_To_Call_Me vSTT559(Test_STT559, "STT559", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT569  {
  void *fa;
  unsigned short  :3;
};
//SIG(1 STT569) C1{ Fp Fs:3}



static void Test_STT569()
{
  {
    init_simple_test("STT569");
    static STT569 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT569)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT569)");
    check_field_offset(lv, fa, 0, "STT569.fa");
  }
}
static Arrange_To_Call_Me vSTT569(Test_STT569, "STT569", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT579  {
  void *fa;
  unsigned int  :3;
};
//SIG(1 STT579) C1{ Fp Fi:3}



static void Test_STT579()
{
  {
    init_simple_test("STT579");
    static STT579 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT579)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT579)");
    check_field_offset(lv, fa, 0, "STT579.fa");
  }
}
static Arrange_To_Call_Me vSTT579(Test_STT579, "STT579", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT589  {
  void *fa;
  __tsu64  :3;
};
//SIG(1 STT589) C1{ Fp FL:3}



static void Test_STT589()
{
  {
    init_simple_test("STT589");
    static STT589 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT589)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT589)");
    check_field_offset(lv, fa, 0, "STT589.fa");
  }
}
static Arrange_To_Call_Me vSTT589(Test_STT589, "STT589", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT599  {
  void *fa;
  unsigned short  :8;
};
//SIG(1 STT599) C1{ Fp Fs:8}



static void Test_STT599()
{
  {
    init_simple_test("STT599");
    static STT599 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT599)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT599)");
    check_field_offset(lv, fa, 0, "STT599.fa");
  }
}
static Arrange_To_Call_Me vSTT599(Test_STT599, "STT599", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5109  {
  void *fa;
  unsigned int  :8;
};
//SIG(1 STT5109) C1{ Fp Fi:8}



static void Test_STT5109()
{
  {
    init_simple_test("STT5109");
    static STT5109 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5109)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5109)");
    check_field_offset(lv, fa, 0, "STT5109.fa");
  }
}
static Arrange_To_Call_Me vSTT5109(Test_STT5109, "STT5109", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5119  {
  void *fa;
  __tsu64  :8;
};
//SIG(1 STT5119) C1{ Fp FL:8}



static void Test_STT5119()
{
  {
    init_simple_test("STT5119");
    static STT5119 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5119)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5119)");
    check_field_offset(lv, fa, 0, "STT5119.fa");
  }
}
static Arrange_To_Call_Me vSTT5119(Test_STT5119, "STT5119", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5129  {
  void *fa;
  unsigned int  :18;
};
//SIG(1 STT5129) C1{ Fp Fi:18}



static void Test_STT5129()
{
  {
    init_simple_test("STT5129");
    static STT5129 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5129)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5129)");
    check_field_offset(lv, fa, 0, "STT5129.fa");
  }
}
static Arrange_To_Call_Me vSTT5129(Test_STT5129, "STT5129", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5139  {
  void *fa;
  __tsu64  :18;
};
//SIG(1 STT5139) C1{ Fp FL:18}



static void Test_STT5139()
{
  {
    init_simple_test("STT5139");
    static STT5139 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5139)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5139)");
    check_field_offset(lv, fa, 0, "STT5139.fa");
  }
}
static Arrange_To_Call_Me vSTT5139(Test_STT5139, "STT5139", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5149  {
  void *fa;
  __tsu64  :48;
};
//SIG(1 STT5149) C1{ Fp FL:48}



static void Test_STT5149()
{
  {
    init_simple_test("STT5149");
    static STT5149 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5149)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5149)");
    check_field_offset(lv, fa, 0, "STT5149.fa");
  }
}
static Arrange_To_Call_Me vSTT5149(Test_STT5149, "STT5149", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5159  {
  void *fa;
  unsigned char bf:3;
};
//SIG(1 STT5159) C1{ Fp Fc:3}



static void Test_STT5159()
{
  {
    init_simple_test("STT5159");
    static STT5159 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5159)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5159)");
    check_field_offset(lv, fa, 0, "STT5159.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5159");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5159");
  }
}
static Arrange_To_Call_Me vSTT5159(Test_STT5159, "STT5159", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5169  {
  void *fa;
  unsigned short bf:3;
};
//SIG(1 STT5169) C1{ Fp Fs:3}



static void Test_STT5169()
{
  {
    init_simple_test("STT5169");
    static STT5169 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5169)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5169)");
    check_field_offset(lv, fa, 0, "STT5169.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5169");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5169");
  }
}
static Arrange_To_Call_Me vSTT5169(Test_STT5169, "STT5169", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5179  {
  void *fa;
  unsigned int bf:3;
};
//SIG(1 STT5179) C1{ Fp Fi:3}



static void Test_STT5179()
{
  {
    init_simple_test("STT5179");
    static STT5179 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5179)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5179)");
    check_field_offset(lv, fa, 0, "STT5179.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5179");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5179");
  }
}
static Arrange_To_Call_Me vSTT5179(Test_STT5179, "STT5179", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5189  {
  void *fa;
  __tsu64 bf:3;
};
//SIG(1 STT5189) C1{ Fp FL:3}



static void Test_STT5189()
{
  {
    init_simple_test("STT5189");
    static STT5189 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5189)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5189)");
    check_field_offset(lv, fa, 0, "STT5189.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, 1, "STT5189");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 3, hide_ull(1LL<<2), "STT5189");
  }
}
static Arrange_To_Call_Me vSTT5189(Test_STT5189, "STT5189", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5199  {
  void *fa;
  unsigned short bf:8;
};
//SIG(1 STT5199) C1{ Fp Fs:8}



static void Test_STT5199()
{
  {
    init_simple_test("STT5199");
    static STT5199 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5199)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5199)");
    check_field_offset(lv, fa, 0, "STT5199.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5199");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5199");
  }
}
static Arrange_To_Call_Me vSTT5199(Test_STT5199, "STT5199", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5209  {
  void *fa;
  unsigned int bf:8;
};
//SIG(1 STT5209) C1{ Fp Fi:8}



static void Test_STT5209()
{
  {
    init_simple_test("STT5209");
    static STT5209 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5209)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5209)");
    check_field_offset(lv, fa, 0, "STT5209.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5209");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5209");
  }
}
static Arrange_To_Call_Me vSTT5209(Test_STT5209, "STT5209", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5219  {
  void *fa;
  __tsu64 bf:8;
};
//SIG(1 STT5219) C1{ Fp FL:8}



static void Test_STT5219()
{
  {
    init_simple_test("STT5219");
    static STT5219 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5219)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5219)");
    check_field_offset(lv, fa, 0, "STT5219.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, 1, "STT5219");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "STT5219");
  }
}
static Arrange_To_Call_Me vSTT5219(Test_STT5219, "STT5219", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5229  {
  void *fa;
  unsigned int bf:18;
};
//SIG(1 STT5229) C1{ Fp Fi:18}



static void Test_STT5229()
{
  {
    init_simple_test("STT5229");
    static STT5229 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5229)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5229)");
    check_field_offset(lv, fa, 0, "STT5229.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5229");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5229");
  }
}
static Arrange_To_Call_Me vSTT5229(Test_STT5229, "STT5229", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5239  {
  void *fa;
  __tsu64 bf:18;
};
//SIG(1 STT5239) C1{ Fp FL:18}



static void Test_STT5239()
{
  {
    init_simple_test("STT5239");
    static STT5239 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(STT5239)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5239)");
    check_field_offset(lv, fa, 0, "STT5239.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, 1, "STT5239");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 18, hide_ull(1LL<<17), "STT5239");
  }
}
static Arrange_To_Call_Me vSTT5239(Test_STT5239, "STT5239", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT5249  {
  void *fa;
  __tsu64 bf:48;
};
//SIG(1 STT5249) C1{ Fp FL:48}



static void Test_STT5249()
{
  {
    init_simple_test("STT5249");
    static STT5249 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(STT5249)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(STT5249)");
    check_field_offset(lv, fa, 0, "STT5249.fa");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, 1, "STT5249");
    set_bf_and_test(lv, bf, ABISELECT(8,4), 0, 48, hide_ull(1LL<<47), "STT5249");
  }
}
static Arrange_To_Call_Me vSTT5249(Test_STT5249, "STT5249", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT610  {
  float fa;
  unsigned char  :0;
  char fb;
};
//SIG(1 STT610) C1{ Fi Fc:0 Fc}



static void Test_STT610()
{
  {
    init_simple_test("STT610");
    static STT610 lv;
    check2(sizeof(lv), 8, "sizeof(STT610)");
    check2(__alignof__(lv), 4, "__alignof__(STT610)");
    check_field_offset(lv, fa, 0, "STT610.fa");
    check_field_offset(lv, fb, 4, "STT610.fb");
  }
}
static Arrange_To_Call_Me vSTT610(Test_STT610, "STT610", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT620  {
  float fa;
  unsigned short  :0;
  char fb;
};
//SIG(1 STT620) C1{ Fi Fs:0 Fc}



static void Test_STT620()
{
  {
    init_simple_test("STT620");
    static STT620 lv;
    check2(sizeof(lv), 8, "sizeof(STT620)");
    check2(__alignof__(lv), 4, "__alignof__(STT620)");
    check_field_offset(lv, fa, 0, "STT620.fa");
    check_field_offset(lv, fb, 4, "STT620.fb");
  }
}
static Arrange_To_Call_Me vSTT620(Test_STT620, "STT620", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT630  {
  float fa;
  unsigned int  :0;
  char fb;
};
//SIG(1 STT630) C1{ Fi Fi:0 Fc}



static void Test_STT630()
{
  {
    init_simple_test("STT630");
    static STT630 lv;
    check2(sizeof(lv), 8, "sizeof(STT630)");
    check2(__alignof__(lv), 4, "__alignof__(STT630)");
    check_field_offset(lv, fa, 0, "STT630.fa");
    check_field_offset(lv, fb, 4, "STT630.fb");
  }
}
static Arrange_To_Call_Me vSTT630(Test_STT630, "STT630", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT640  {
  float fa;
  __tsu64  :0;
  char fb;
};
//SIG(1 STT640) C1{ Fi FL:0 Fc}



static void Test_STT640()
{
  {
    init_simple_test("STT640");
    static STT640 lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(STT640)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT640)");
    check_field_offset(lv, fa, 0, "STT640.fa");
    check_field_offset(lv, fb, ABISELECT(8,4), "STT640.fb");
  }
}
static Arrange_To_Call_Me vSTT640(Test_STT640, "STT640", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT650  {
  float fa;
  unsigned char  :3;
  char fb;
};
//SIG(1 STT650) C1{ Fi Fc:3 Fc}



static void Test_STT650()
{
  {
    init_simple_test("STT650");
    static STT650 lv;
    check2(sizeof(lv), 8, "sizeof(STT650)");
    check2(__alignof__(lv), 4, "__alignof__(STT650)");
    check_field_offset(lv, fa, 0, "STT650.fa");
    check_field_offset(lv, fb, 5, "STT650.fb");
  }
}
static Arrange_To_Call_Me vSTT650(Test_STT650, "STT650", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT660  {
  float fa;
  unsigned short  :3;
  char fb;
};
//SIG(1 STT660) C1{ Fi Fs:3 Fc}



static void Test_STT660()
{
  {
    init_simple_test("STT660");
    static STT660 lv;
    check2(sizeof(lv), 8, "sizeof(STT660)");
    check2(__alignof__(lv), 4, "__alignof__(STT660)");
    check_field_offset(lv, fa, 0, "STT660.fa");
    check_field_offset(lv, fb, 5, "STT660.fb");
  }
}
static Arrange_To_Call_Me vSTT660(Test_STT660, "STT660", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT670  {
  float fa;
  unsigned int  :3;
  char fb;
};
//SIG(1 STT670) C1{ Fi Fi:3 Fc}



static void Test_STT670()
{
  {
    init_simple_test("STT670");
    static STT670 lv;
    check2(sizeof(lv), 8, "sizeof(STT670)");
    check2(__alignof__(lv), 4, "__alignof__(STT670)");
    check_field_offset(lv, fa, 0, "STT670.fa");
    check_field_offset(lv, fb, 5, "STT670.fb");
  }
}
static Arrange_To_Call_Me vSTT670(Test_STT670, "STT670", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT680  {
  float fa;
  __tsu64  :3;
  char fb;
};
//SIG(1 STT680) C1{ Fi FL:3 Fc}



static void Test_STT680()
{
  {
    init_simple_test("STT680");
    static STT680 lv;
    check2(sizeof(lv), 8, "sizeof(STT680)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(STT680)");
    check_field_offset(lv, fa, 0, "STT680.fa");
    check_field_offset(lv, fb, 5, "STT680.fb");
  }
}
static Arrange_To_Call_Me vSTT680(Test_STT680, "STT680", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  STT690  {
  float fa;
  unsigned short  :8;
  char fb;
};
//SIG(1 STT690) C1{ Fi Fs:8 Fc}



static void Test_STT690()
{
  {
    init_simple