// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  L_BFu8c_BFu0c  {
  __tsi64 v1;
  unsigned char v2:8;
  unsigned char  :0;
};
//SIG(1 L_BFu8c_BFu0c) C1{ FL Fc:8 Fc:0}



static void Test_L_BFu8c_BFu0c()
{
  {
    init_simple_test("L_BFu8c_BFu0c");
    static L_BFu8c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8c_BFu0c)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu0c");
  }
}
static Arrange_To_Call_Me vL_BFu8c_BFu0c(Test_L_BFu8c_BFu0c, "L_BFu8c_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8c_BFu0i  {
  __tsi64 v1;
  unsigned char v2:8;
  unsigned int  :0;
};
//SIG(1 L_BFu8c_BFu0i) C1{ FL Fc:8 Fi:0}



static void Test_L_BFu8c_BFu0i()
{
  {
    init_simple_test("L_BFu8c_BFu0i");
    static L_BFu8c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8c_BFu0i)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu0i");
  }
}
static Arrange_To_Call_Me vL_BFu8c_BFu0i(Test_L_BFu8c_BFu0i, "L_BFu8c_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8c_BFu0ll  {
  __tsi64 v1;
  unsigned char v2:8;
  __tsu64  :0;
};
//SIG(1 L_BFu8c_BFu0ll) C1{ FL Fc:8 FL:0}



static void Test_L_BFu8c_BFu0ll()
{
  {
    init_simple_test("L_BFu8c_BFu0ll");
    static L_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8c_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu0ll");
  }
}
static Arrange_To_Call_Me vL_BFu8c_BFu0ll(Test_L_BFu8c_BFu0ll, "L_BFu8c_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8c_BFu0s  {
  __tsi64 v1;
  unsigned char v2:8;
  unsigned short  :0;
};
//SIG(1 L_BFu8c_BFu0s) C1{ FL Fc:8 Fs:0}



static void Test_L_BFu8c_BFu0s()
{
  {
    init_simple_test("L_BFu8c_BFu0s");
    static L_BFu8c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8c_BFu0s)");
    check_field_offset(lv, v1, 0, "L_BFu8c_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8c_BFu0s");
  }
}
static Arrange_To_Call_Me vL_BFu8c_BFu0s(Test_L_BFu8c_BFu0s, "L_BFu8c_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8i_BFu0c  {
  __tsi64 v1;
  unsigned int v2:8;
  unsigned char  :0;
};
//SIG(1 L_BFu8i_BFu0c) C1{ FL Fi:8 Fc:0}



static void Test_L_BFu8i_BFu0c()
{
  {
    init_simple_test("L_BFu8i_BFu0c");
    static L_BFu8i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8i_BFu0c)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu0c");
  }
}
static Arrange_To_Call_Me vL_BFu8i_BFu0c(Test_L_BFu8i_BFu0c, "L_BFu8i_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8i_BFu0i  {
  __tsi64 v1;
  unsigned int v2:8;
  unsigned int  :0;
};
//SIG(1 L_BFu8i_BFu0i) C1{ FL Fi:8 Fi:0}



static void Test_L_BFu8i_BFu0i()
{
  {
    init_simple_test("L_BFu8i_BFu0i");
    static L_BFu8i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8i_BFu0i)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu0i");
  }
}
static Arrange_To_Call_Me vL_BFu8i_BFu0i(Test_L_BFu8i_BFu0i, "L_BFu8i_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8i_BFu0ll  {
  __tsi64 v1;
  unsigned int v2:8;
  __tsu64  :0;
};
//SIG(1 L_BFu8i_BFu0ll) C1{ FL Fi:8 FL:0}



static void Test_L_BFu8i_BFu0ll()
{
  {
    init_simple_test("L_BFu8i_BFu0ll");
    static L_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8i_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu0ll");
  }
}
static Arrange_To_Call_Me vL_BFu8i_BFu0ll(Test_L_BFu8i_BFu0ll, "L_BFu8i_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8i_BFu0s  {
  __tsi64 v1;
  unsigned int v2:8;
  unsigned short  :0;
};
//SIG(1 L_BFu8i_BFu0s) C1{ FL Fi:8 Fs:0}



static void Test_L_BFu8i_BFu0s()
{
  {
    init_simple_test("L_BFu8i_BFu0s");
    static L_BFu8i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8i_BFu0s)");
    check_field_offset(lv, v1, 0, "L_BFu8i_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8i_BFu0s");
  }
}
static Arrange_To_Call_Me vL_BFu8i_BFu0s(Test_L_BFu8i_BFu0s, "L_BFu8i_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8ll_BFu0c  {
  __tsi64 v1;
  __tsu64 v2:8;
  unsigned char  :0;
};
//SIG(1 L_BFu8ll_BFu0c) C1{ FL FL:8 Fc:0}



static void Test_L_BFu8ll_BFu0c()
{
  {
    init_simple_test("L_BFu8ll_BFu0c");
    static L_BFu8ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8ll_BFu0c)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu0c");
  }
}
static Arrange_To_Call_Me vL_BFu8ll_BFu0c(Test_L_BFu8ll_BFu0c, "L_BFu8ll_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8ll_BFu0i  {
  __tsi64 v1;
  __tsu64 v2:8;
  unsigned int  :0;
};
//SIG(1 L_BFu8ll_BFu0i) C1{ FL FL:8 Fi:0}



static void Test_L_BFu8ll_BFu0i()
{
  {
    init_simple_test("L_BFu8ll_BFu0i");
    static L_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8ll_BFu0i)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu0i");
  }
}
static Arrange_To_Call_Me vL_BFu8ll_BFu0i(Test_L_BFu8ll_BFu0i, "L_BFu8ll_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8ll_BFu0ll  {
  __tsi64 v1;
  __tsu64 v2:8;
  __tsu64  :0;
};
//SIG(1 L_BFu8ll_BFu0ll) C1{ FL FL:8 FL:0}



static void Test_L_BFu8ll_BFu0ll()
{
  {
    init_simple_test("L_BFu8ll_BFu0ll");
    static L_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vL_BFu8ll_BFu0ll(Test_L_BFu8ll_BFu0ll, "L_BFu8ll_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8ll_BFu0s  {
  __tsi64 v1;
  __tsu64 v2:8;
  unsigned short  :0;
};
//SIG(1 L_BFu8ll_BFu0s) C1{ FL FL:8 Fs:0}



static void Test_L_BFu8ll_BFu0s()
{
  {
    init_simple_test("L_BFu8ll_BFu0s");
    static L_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8ll_BFu0s)");
    check_field_offset(lv, v1, 0, "L_BFu8ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8ll_BFu0s");
  }
}
static Arrange_To_Call_Me vL_BFu8ll_BFu0s(Test_L_BFu8ll_BFu0s, "L_BFu8ll_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8s_BFu0c  {
  __tsi64 v1;
  unsigned short v2:8;
  unsigned char  :0;
};
//SIG(1 L_BFu8s_BFu0c) C1{ FL Fs:8 Fc:0}



static void Test_L_BFu8s_BFu0c()
{
  {
    init_simple_test("L_BFu8s_BFu0c");
    static L_BFu8s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8s_BFu0c)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu0c");
  }
}
static Arrange_To_Call_Me vL_BFu8s_BFu0c(Test_L_BFu8s_BFu0c, "L_BFu8s_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8s_BFu0i  {
  __tsi64 v1;
  unsigned short v2:8;
  unsigned int  :0;
};
//SIG(1 L_BFu8s_BFu0i) C1{ FL Fs:8 Fi:0}



static void Test_L_BFu8s_BFu0i()
{
  {
    init_simple_test("L_BFu8s_BFu0i");
    static L_BFu8s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8s_BFu0i)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu0i");
  }
}
static Arrange_To_Call_Me vL_BFu8s_BFu0i(Test_L_BFu8s_BFu0i, "L_BFu8s_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8s_BFu0ll  {
  __tsi64 v1;
  unsigned short v2:8;
  __tsu64  :0;
};
//SIG(1 L_BFu8s_BFu0ll) C1{ FL Fs:8 FL:0}



static void Test_L_BFu8s_BFu0ll()
{
  {
    init_simple_test("L_BFu8s_BFu0ll");
    static L_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8s_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu0ll");
  }
}
static Arrange_To_Call_Me vL_BFu8s_BFu0ll(Test_L_BFu8s_BFu0ll, "L_BFu8s_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu8s_BFu0s  {
  __tsi64 v1;
  unsigned short v2:8;
  unsigned short  :0;
};
//SIG(1 L_BFu8s_BFu0s) C1{ FL Fs:8 Fs:0}



static void Test_L_BFu8s_BFu0s()
{
  {
    init_simple_test("L_BFu8s_BFu0s");
    static L_BFu8s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu8s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu8s_BFu0s)");
    check_field_offset(lv, v1, 0, "L_BFu8s_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "L_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "L_BFu8s_BFu0s");
  }
}
static Arrange_To_Call_Me vL_BFu8s_BFu0s(Test_L_BFu8s_BFu0s, "L_BFu8s_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu9i_BFu0c  {
  __tsi64 v1;
  unsigned int v2:9;
  unsigned char  :0;
};
//SIG(1 L_BFu9i_BFu0c) C1{ FL Fi:9 Fc:0}



static void Test_L_BFu9i_BFu0c()
{
  {
    init_simple_test("L_BFu9i_BFu0c");
    static L_BFu9i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu9i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu9i_BFu0c)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu0c");
  }
}
static Arrange_To_Call_Me vL_BFu9i_BFu0c(Test_L_BFu9i_BFu0c, "L_BFu9i_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu9i_BFu0i  {
  __tsi64 v1;
  unsigned int v2:9;
  unsigned int  :0;
};
//SIG(1 L_BFu9i_BFu0i) C1{ FL Fi:9 Fi:0}



static void Test_L_BFu9i_BFu0i()
{
  {
    init_simple_test("L_BFu9i_BFu0i");
    static L_BFu9i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu9i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu9i_BFu0i)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu0i");
  }
}
static Arrange_To_Call_Me vL_BFu9i_BFu0i(Test_L_BFu9i_BFu0i, "L_BFu9i_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu9i_BFu0ll  {
  __tsi64 v1;
  unsigned int v2:9;
  __tsu64  :0;
};
//SIG(1 L_BFu9i_BFu0ll) C1{ FL Fi:9 FL:0}



static void Test_L_BFu9i_BFu0ll()
{
  {
    init_simple_test("L_BFu9i_BFu0ll");
    static L_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu9i_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu0ll");
  }
}
static Arrange_To_Call_Me vL_BFu9i_BFu0ll(Test_L_BFu9i_BFu0ll, "L_BFu9i_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu9i_BFu0s  {
  __tsi64 v1;
  unsigned int v2:9;
  unsigned short  :0;
};
//SIG(1 L_BFu9i_BFu0s) C1{ FL Fi:9 Fs:0}



static void Test_L_BFu9i_BFu0s()
{
  {
    init_simple_test("L_BFu9i_BFu0s");
    static L_BFu9i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu9i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu9i_BFu0s)");
    check_field_offset(lv, v1, 0, "L_BFu9i_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9i_BFu0s");
  }
}
static Arrange_To_Call_Me vL_BFu9i_BFu0s(Test_L_BFu9i_BFu0s, "L_BFu9i_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu9ll_BFu0c  {
  __tsi64 v1;
  __tsu64 v2:9;
  unsigned char  :0;
};
//SIG(1 L_BFu9ll_BFu0c) C1{ FL FL:9 Fc:0}



static void Test_L_BFu9ll_BFu0c()
{
  {
    init_simple_test("L_BFu9ll_BFu0c");
    static L_BFu9ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu9ll_BFu0c)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu0c");
  }
}
static Arrange_To_Call_Me vL_BFu9ll_BFu0c(Test_L_BFu9ll_BFu0c, "L_BFu9ll_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu9ll_BFu0i  {
  __tsi64 v1;
  __tsu64 v2:9;
  unsigned int  :0;
};
//SIG(1 L_BFu9ll_BFu0i) C1{ FL FL:9 Fi:0}



static void Test_L_BFu9ll_BFu0i()
{
  {
    init_simple_test("L_BFu9ll_BFu0i");
    static L_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu9ll_BFu0i)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu0i");
  }
}
static Arrange_To_Call_Me vL_BFu9ll_BFu0i(Test_L_BFu9ll_BFu0i, "L_BFu9ll_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu9ll_BFu0ll  {
  __tsi64 v1;
  __tsu64 v2:9;
  __tsu64  :0;
};
//SIG(1 L_BFu9ll_BFu0ll) C1{ FL FL:9 FL:0}



static void Test_L_BFu9ll_BFu0ll()
{
  {
    init_simple_test("L_BFu9ll_BFu0ll");
    static L_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu9ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vL_BFu9ll_BFu0ll(Test_L_BFu9ll_BFu0ll, "L_BFu9ll_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu9ll_BFu0s  {
  __tsi64 v1;
  __tsu64 v2:9;
  unsigned short  :0;
};
//SIG(1 L_BFu9ll_BFu0s) C1{ FL FL:9 Fs:0}



static void Test_L_BFu9ll_BFu0s()
{
  {
    init_simple_test("L_BFu9ll_BFu0s");
    static L_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu9ll_BFu0s)");
    check_field_offset(lv, v1, 0, "L_BFu9ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9ll_BFu0s");
  }
}
static Arrange_To_Call_Me vL_BFu9ll_BFu0s(Test_L_BFu9ll_BFu0s, "L_BFu9ll_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu9s_BFu0c  {
  __tsi64 v1;
  unsigned short v2:9;
  unsigned char  :0;
};
//SIG(1 L_BFu9s_BFu0c) C1{ FL Fs:9 Fc:0}



static void Test_L_BFu9s_BFu0c()
{
  {
    init_simple_test("L_BFu9s_BFu0c");
    static L_BFu9s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu9s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu9s_BFu0c)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu0c");
  }
}
static Arrange_To_Call_Me vL_BFu9s_BFu0c(Test_L_BFu9s_BFu0c, "L_BFu9s_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu9s_BFu0i  {
  __tsi64 v1;
  unsigned short v2:9;
  unsigned int  :0;
};
//SIG(1 L_BFu9s_BFu0i) C1{ FL Fs:9 Fi:0}



static void Test_L_BFu9s_BFu0i()
{
  {
    init_simple_test("L_BFu9s_BFu0i");
    static L_BFu9s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu9s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu9s_BFu0i)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu0i");
  }
}
static Arrange_To_Call_Me vL_BFu9s_BFu0i(Test_L_BFu9s_BFu0i, "L_BFu9s_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu9s_BFu0ll  {
  __tsi64 v1;
  unsigned short v2:9;
  __tsu64  :0;
};
//SIG(1 L_BFu9s_BFu0ll) C1{ FL Fs:9 FL:0}



static void Test_L_BFu9s_BFu0ll()
{
  {
    init_simple_test("L_BFu9s_BFu0ll");
    static L_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu9s_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu0ll");
  }
}
static Arrange_To_Call_Me vL_BFu9s_BFu0ll(Test_L_BFu9s_BFu0ll, "L_BFu9s_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_BFu9s_BFu0s  {
  __tsi64 v1;
  unsigned short v2:9;
  unsigned short  :0;
};
//SIG(1 L_BFu9s_BFu0s) C1{ FL Fs:9 Fs:0}



static void Test_L_BFu9s_BFu0s()
{
  {
    init_simple_test("L_BFu9s_BFu0s");
    static L_BFu9s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_BFu9s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_BFu9s_BFu0s)");
    check_field_offset(lv, v1, 0, "L_BFu9s_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "L_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "L_BFu9s_BFu0s");
  }
}
static Arrange_To_Call_Me vL_BFu9s_BFu0s(Test_L_BFu9s_BFu0s, "L_BFu9s_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_C_BFu0c  {
  __tsi64 v1;
  char v2;
  unsigned char  :0;
};
//SIG(1 L_C_BFu0c) C1{ FL Fc Fc:0}



static void Test_L_C_BFu0c()
{
  {
    init_simple_test("L_C_BFu0c");
    static L_C_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_C_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_C_BFu0c)");
    check_field_offset(lv, v1, 0, "L_C_BFu0c.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vL_C_BFu0c(Test_L_C_BFu0c, "L_C_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_C_BFu0i  {
  __tsi64 v1;
  char v2;
  unsigned int  :0;
};
//SIG(1 L_C_BFu0i) C1{ FL Fc Fi:0}



static void Test_L_C_BFu0i()
{
  {
    init_simple_test("L_C_BFu0i");
    static L_C_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_C_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_C_BFu0i)");
    check_field_offset(lv, v1, 0, "L_C_BFu0i.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vL_C_BFu0i(Test_L_C_BFu0i, "L_C_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_C_BFu0ll  {
  __tsi64 v1;
  char v2;
  __tsu64  :0;
};
//SIG(1 L_C_BFu0ll) C1{ FL Fc FL:0}



static void Test_L_C_BFu0ll()
{
  {
    init_simple_test("L_C_BFu0ll");
    static L_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_C_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_C_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vL_C_BFu0ll(Test_L_C_BFu0ll, "L_C_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_C_BFu0s  {
  __tsi64 v1;
  char v2;
  unsigned short  :0;
};
//SIG(1 L_C_BFu0s) C1{ FL Fc Fs:0}



static void Test_L_C_BFu0s()
{
  {
    init_simple_test("L_C_BFu0s");
    static L_C_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_C_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_C_BFu0s)");
    check_field_offset(lv, v1, 0, "L_C_BFu0s.v1");
    check_field_offset(lv, v2, 8, "L_C_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vL_C_BFu0s(Test_L_C_BFu0s, "L_C_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_D_BFu0c  {
  __tsi64 v1;
  double v2;
  unsigned char  :0;
};
//SIG(1 L_D_BFu0c) C1{ FL[2] Fc:0}



static void Test_L_D_BFu0c()
{
  {
    init_simple_test("L_D_BFu0c");
    static L_D_BFu0c lv;
    check2(sizeof(lv), 16, "sizeof(L_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_D_BFu0c)");
    check_field_offset(lv, v1, 0, "L_D_BFu0c.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vL_D_BFu0c(Test_L_D_BFu0c, "L_D_BFu0c", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_D_BFu0i  {
  __tsi64 v1;
  double v2;
  unsigned int  :0;
};
//SIG(1 L_D_BFu0i) C1{ FL[2] Fi:0}



static void Test_L_D_BFu0i()
{
  {
    init_simple_test("L_D_BFu0i");
    static L_D_BFu0i lv;
    check2(sizeof(lv), 16, "sizeof(L_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_D_BFu0i)");
    check_field_offset(lv, v1, 0, "L_D_BFu0i.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vL_D_BFu0i(Test_L_D_BFu0i, "L_D_BFu0i", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_D_BFu0ll  {
  __tsi64 v1;
  double v2;
  __tsu64  :0;
};
//SIG(1 L_D_BFu0ll) C1{ FL[2] FL:0}



static void Test_L_D_BFu0ll()
{
  {
    init_simple_test("L_D_BFu0ll");
    static L_D_BFu0ll lv;
    check2(sizeof(lv), 16, "sizeof(L_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_D_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_D_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vL_D_BFu0ll(Test_L_D_BFu0ll, "L_D_BFu0ll", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_D_BFu0s  {
  __tsi64 v1;
  double v2;
  unsigned short  :0;
};
//SIG(1 L_D_BFu0s) C1{ FL[2] Fs:0}



static void Test_L_D_BFu0s()
{
  {
    init_simple_test("L_D_BFu0s");
    static L_D_BFu0s lv;
    check2(sizeof(lv), 16, "sizeof(L_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_D_BFu0s)");
    check_field_offset(lv, v1, 0, "L_D_BFu0s.v1");
    check_field_offset(lv, v2, 8, "L_D_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vL_D_BFu0s(Test_L_D_BFu0s, "L_D_BFu0s", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_F_BFu0c  {
  __tsi64 v1;
  float v2;
  unsigned char  :0;
};
//SIG(1 L_F_BFu0c) C1{ FL Fi Fc:0}



static void Test_L_F_BFu0c()
{
  {
    init_simple_test("L_F_BFu0c");
    static L_F_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_F_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_F_BFu0c)");
    check_field_offset(lv, v1, 0, "L_F_BFu0c.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vL_F_BFu0c(Test_L_F_BFu0c, "L_F_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_F_BFu0i  {
  __tsi64 v1;
  float v2;
  unsigned int  :0;
};
//SIG(1 L_F_BFu0i) C1{ FL Fi Fi:0}



static void Test_L_F_BFu0i()
{
  {
    init_simple_test("L_F_BFu0i");
    static L_F_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_F_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_F_BFu0i)");
    check_field_offset(lv, v1, 0, "L_F_BFu0i.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vL_F_BFu0i(Test_L_F_BFu0i, "L_F_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_F_BFu0ll  {
  __tsi64 v1;
  float v2;
  __tsu64  :0;
};
//SIG(1 L_F_BFu0ll) C1{ FL Fi FL:0}



static void Test_L_F_BFu0ll()
{
  {
    init_simple_test("L_F_BFu0ll");
    static L_F_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_F_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_F_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vL_F_BFu0ll(Test_L_F_BFu0ll, "L_F_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_F_BFu0s  {
  __tsi64 v1;
  float v2;
  unsigned short  :0;
};
//SIG(1 L_F_BFu0s) C1{ FL Fi Fs:0}



static void Test_L_F_BFu0s()
{
  {
    init_simple_test("L_F_BFu0s");
    static L_F_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_F_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_F_BFu0s)");
    check_field_offset(lv, v1, 0, "L_F_BFu0s.v1");
    check_field_offset(lv, v2, 8, "L_F_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vL_F_BFu0s(Test_L_F_BFu0s, "L_F_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_I_BFu0c  {
  __tsi64 v1;
  int v2;
  unsigned char  :0;
};
//SIG(1 L_I_BFu0c) C1{ FL Fi Fc:0}



static void Test_L_I_BFu0c()
{
  {
    init_simple_test("L_I_BFu0c");
    static L_I_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_I_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_I_BFu0c)");
    check_field_offset(lv, v1, 0, "L_I_BFu0c.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vL_I_BFu0c(Test_L_I_BFu0c, "L_I_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_I_BFu0i  {
  __tsi64 v1;
  int v2;
  unsigned int  :0;
};
//SIG(1 L_I_BFu0i) C1{ FL Fi Fi:0}



static void Test_L_I_BFu0i()
{
  {
    init_simple_test("L_I_BFu0i");
    static L_I_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_I_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_I_BFu0i)");
    check_field_offset(lv, v1, 0, "L_I_BFu0i.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vL_I_BFu0i(Test_L_I_BFu0i, "L_I_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_I_BFu0ll  {
  __tsi64 v1;
  int v2;
  __tsu64  :0;
};
//SIG(1 L_I_BFu0ll) C1{ FL Fi FL:0}



static void Test_L_I_BFu0ll()
{
  {
    init_simple_test("L_I_BFu0ll");
    static L_I_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_I_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_I_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vL_I_BFu0ll(Test_L_I_BFu0ll, "L_I_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_I_BFu0s  {
  __tsi64 v1;
  int v2;
  unsigned short  :0;
};
//SIG(1 L_I_BFu0s) C1{ FL Fi Fs:0}



static void Test_L_I_BFu0s()
{
  {
    init_simple_test("L_I_BFu0s");
    static L_I_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_I_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_I_BFu0s)");
    check_field_offset(lv, v1, 0, "L_I_BFu0s.v1");
    check_field_offset(lv, v2, 8, "L_I_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vL_I_BFu0s(Test_L_I_BFu0s, "L_I_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Ip_BFu0c  {
  __tsi64 v1;
  int *v2;
  unsigned char  :0;
};
//SIG(1 L_Ip_BFu0c) C1{ FL Fp Fc:0}



static void Test_L_Ip_BFu0c()
{
  {
    init_simple_test("L_Ip_BFu0c");
    static L_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ip_BFu0c)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu0c.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vL_Ip_BFu0c(Test_L_Ip_BFu0c, "L_Ip_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Ip_BFu0i  {
  __tsi64 v1;
  int *v2;
  unsigned int  :0;
};
//SIG(1 L_Ip_BFu0i) C1{ FL Fp Fi:0}



static void Test_L_Ip_BFu0i()
{
  {
    init_simple_test("L_Ip_BFu0i");
    static L_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ip_BFu0i)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu0i.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vL_Ip_BFu0i(Test_L_Ip_BFu0i, "L_Ip_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Ip_BFu0ll  {
  __tsi64 v1;
  int *v2;
  __tsu64  :0;
};
//SIG(1 L_Ip_BFu0ll) C1{ FL Fp FL:0}



static void Test_L_Ip_BFu0ll()
{
  {
    init_simple_test("L_Ip_BFu0ll");
    static L_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ip_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vL_Ip_BFu0ll(Test_L_Ip_BFu0ll, "L_Ip_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Ip_BFu0s  {
  __tsi64 v1;
  int *v2;
  unsigned short  :0;
};
//SIG(1 L_Ip_BFu0s) C1{ FL Fp Fs:0}



static void Test_L_Ip_BFu0s()
{
  {
    init_simple_test("L_Ip_BFu0s");
    static L_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ip_BFu0s)");
    check_field_offset(lv, v1, 0, "L_Ip_BFu0s.v1");
    check_field_offset(lv, v2, 8, "L_Ip_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vL_Ip_BFu0s(Test_L_Ip_BFu0s, "L_Ip_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_L_BFu0c  {
  __tsi64 v1;
  __tsi64 v2;
  unsigned char  :0;
};
//SIG(1 L_L_BFu0c) C1{ FL[2] Fc:0}



static void Test_L_L_BFu0c()
{
  {
    init_simple_test("L_L_BFu0c");
    static L_L_BFu0c lv;
    check2(sizeof(lv), 16, "sizeof(L_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_L_BFu0c)");
    check_field_offset(lv, v1, 0, "L_L_BFu0c.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vL_L_BFu0c(Test_L_L_BFu0c, "L_L_BFu0c", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_L_BFu0i  {
  __tsi64 v1;
  __tsi64 v2;
  unsigned int  :0;
};
//SIG(1 L_L_BFu0i) C1{ FL[2] Fi:0}



static void Test_L_L_BFu0i()
{
  {
    init_simple_test("L_L_BFu0i");
    static L_L_BFu0i lv;
    check2(sizeof(lv), 16, "sizeof(L_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_L_BFu0i)");
    check_field_offset(lv, v1, 0, "L_L_BFu0i.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vL_L_BFu0i(Test_L_L_BFu0i, "L_L_BFu0i", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_L_BFu0ll  {
  __tsi64 v1;
  __tsi64 v2;
  __tsu64  :0;
};
//SIG(1 L_L_BFu0ll) C1{ FL[2] FL:0}



static void Test_L_L_BFu0ll()
{
  {
    init_simple_test("L_L_BFu0ll");
    static L_L_BFu0ll lv;
    check2(sizeof(lv), 16, "sizeof(L_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_L_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_L_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vL_L_BFu0ll(Test_L_L_BFu0ll, "L_L_BFu0ll", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_L_BFu0s  {
  __tsi64 v1;
  __tsi64 v2;
  unsigned short  :0;
};
//SIG(1 L_L_BFu0s) C1{ FL[2] Fs:0}



static void Test_L_L_BFu0s()
{
  {
    init_simple_test("L_L_BFu0s");
    static L_L_BFu0s lv;
    check2(sizeof(lv), 16, "sizeof(L_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_L_BFu0s)");
    check_field_offset(lv, v1, 0, "L_L_BFu0s.v1");
    check_field_offset(lv, v2, 8, "L_L_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vL_L_BFu0s(Test_L_L_BFu0s, "L_L_BFu0s", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_S_BFu0c  {
  __tsi64 v1;
  short v2;
  unsigned char  :0;
};
//SIG(1 L_S_BFu0c) C1{ FL Fs Fc:0}



static void Test_L_S_BFu0c()
{
  {
    init_simple_test("L_S_BFu0c");
    static L_S_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_S_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_S_BFu0c)");
    check_field_offset(lv, v1, 0, "L_S_BFu0c.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vL_S_BFu0c(Test_L_S_BFu0c, "L_S_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_S_BFu0i  {
  __tsi64 v1;
  short v2;
  unsigned int  :0;
};
//SIG(1 L_S_BFu0i) C1{ FL Fs Fi:0}



static void Test_L_S_BFu0i()
{
  {
    init_simple_test("L_S_BFu0i");
    static L_S_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_S_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_S_BFu0i)");
    check_field_offset(lv, v1, 0, "L_S_BFu0i.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vL_S_BFu0i(Test_L_S_BFu0i, "L_S_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_S_BFu0ll  {
  __tsi64 v1;
  short v2;
  __tsu64  :0;
};
//SIG(1 L_S_BFu0ll) C1{ FL Fs FL:0}



static void Test_L_S_BFu0ll()
{
  {
    init_simple_test("L_S_BFu0ll");
    static L_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_S_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_S_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vL_S_BFu0ll(Test_L_S_BFu0ll, "L_S_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_S_BFu0s  {
  __tsi64 v1;
  short v2;
  unsigned short  :0;
};
//SIG(1 L_S_BFu0s) C1{ FL Fs Fs:0}



static void Test_L_S_BFu0s()
{
  {
    init_simple_test("L_S_BFu0s");
    static L_S_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_S_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_S_BFu0s)");
    check_field_offset(lv, v1, 0, "L_S_BFu0s.v1");
    check_field_offset(lv, v2, 8, "L_S_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vL_S_BFu0s(Test_L_S_BFu0s, "L_S_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Uc_BFu0c  {
  __tsi64 v1;
  unsigned char v2;
  unsigned char  :0;
};
//SIG(1 L_Uc_BFu0c) C1{ FL Fc Fc:0}



static void Test_L_Uc_BFu0c()
{
  {
    init_simple_test("L_Uc_BFu0c");
    static L_Uc_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Uc_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Uc_BFu0c)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu0c.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vL_Uc_BFu0c(Test_L_Uc_BFu0c, "L_Uc_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Uc_BFu0i  {
  __tsi64 v1;
  unsigned char v2;
  unsigned int  :0;
};
//SIG(1 L_Uc_BFu0i) C1{ FL Fc Fi:0}



static void Test_L_Uc_BFu0i()
{
  {
    init_simple_test("L_Uc_BFu0i");
    static L_Uc_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Uc_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Uc_BFu0i)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu0i.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vL_Uc_BFu0i(Test_L_Uc_BFu0i, "L_Uc_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Uc_BFu0ll  {
  __tsi64 v1;
  unsigned char v2;
  __tsu64  :0;
};
//SIG(1 L_Uc_BFu0ll) C1{ FL Fc FL:0}



static void Test_L_Uc_BFu0ll()
{
  {
    init_simple_test("L_Uc_BFu0ll");
    static L_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Uc_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vL_Uc_BFu0ll(Test_L_Uc_BFu0ll, "L_Uc_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Uc_BFu0s  {
  __tsi64 v1;
  unsigned char v2;
  unsigned short  :0;
};
//SIG(1 L_Uc_BFu0s) C1{ FL Fc Fs:0}



static void Test_L_Uc_BFu0s()
{
  {
    init_simple_test("L_Uc_BFu0s");
    static L_Uc_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Uc_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Uc_BFu0s)");
    check_field_offset(lv, v1, 0, "L_Uc_BFu0s.v1");
    check_field_offset(lv, v2, 8, "L_Uc_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vL_Uc_BFu0s(Test_L_Uc_BFu0s, "L_Uc_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Ui_BFu0c  {
  __tsi64 v1;
  unsigned int v2;
  unsigned char  :0;
};
//SIG(1 L_Ui_BFu0c) C1{ FL Fi Fc:0}



static void Test_L_Ui_BFu0c()
{
  {
    init_simple_test("L_Ui_BFu0c");
    static L_Ui_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Ui_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu0c)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu0c.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vL_Ui_BFu0c(Test_L_Ui_BFu0c, "L_Ui_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Ui_BFu0i  {
  __tsi64 v1;
  unsigned int v2;
  unsigned int  :0;
};
//SIG(1 L_Ui_BFu0i) C1{ FL Fi Fi:0}



static void Test_L_Ui_BFu0i()
{
  {
    init_simple_test("L_Ui_BFu0i");
    static L_Ui_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Ui_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu0i)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu0i.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vL_Ui_BFu0i(Test_L_Ui_BFu0i, "L_Ui_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Ui_BFu0ll  {
  __tsi64 v1;
  unsigned int v2;
  __tsu64  :0;
};
//SIG(1 L_Ui_BFu0ll) C1{ FL Fi FL:0}



static void Test_L_Ui_BFu0ll()
{
  {
    init_simple_test("L_Ui_BFu0ll");
    static L_Ui_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vL_Ui_BFu0ll(Test_L_Ui_BFu0ll, "L_Ui_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Ui_BFu0s  {
  __tsi64 v1;
  unsigned int v2;
  unsigned short  :0;
};
//SIG(1 L_Ui_BFu0s) C1{ FL Fi Fs:0}



static void Test_L_Ui_BFu0s()
{
  {
    init_simple_test("L_Ui_BFu0s");
    static L_Ui_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Ui_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ui_BFu0s)");
    check_field_offset(lv, v1, 0, "L_Ui_BFu0s.v1");
    check_field_offset(lv, v2, 8, "L_Ui_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vL_Ui_BFu0s(Test_L_Ui_BFu0s, "L_Ui_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Ul_BFu0c  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned char  :0;
};
//SIG(1 L_Ul_BFu0c) C1{ FL[2] Fc:0}



static void Test_L_Ul_BFu0c()
{
  {
    init_simple_test("L_Ul_BFu0c");
    static L_Ul_BFu0c lv;
    check2(sizeof(lv), 16, "sizeof(L_Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu0c)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu0c.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vL_Ul_BFu0c(Test_L_Ul_BFu0c, "L_Ul_BFu0c", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Ul_BFu0i  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned int  :0;
};
//SIG(1 L_Ul_BFu0i) C1{ FL[2] Fi:0}



static void Test_L_Ul_BFu0i()
{
  {
    init_simple_test("L_Ul_BFu0i");
    static L_Ul_BFu0i lv;
    check2(sizeof(lv), 16, "sizeof(L_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu0i)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu0i.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vL_Ul_BFu0i(Test_L_Ul_BFu0i, "L_Ul_BFu0i", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Ul_BFu0ll  {
  __tsi64 v1;
  __tsu64 v2;
  __tsu64  :0;
};
//SIG(1 L_Ul_BFu0ll) C1{ FL[2] FL:0}



static void Test_L_Ul_BFu0ll()
{
  {
    init_simple_test("L_Ul_BFu0ll");
    static L_Ul_BFu0ll lv;
    check2(sizeof(lv), 16, "sizeof(L_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vL_Ul_BFu0ll(Test_L_Ul_BFu0ll, "L_Ul_BFu0ll", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Ul_BFu0s  {
  __tsi64 v1;
  __tsu64 v2;
  unsigned short  :0;
};
//SIG(1 L_Ul_BFu0s) C1{ FL[2] Fs:0}



static void Test_L_Ul_BFu0s()
{
  {
    init_simple_test("L_Ul_BFu0s");
    static L_Ul_BFu0s lv;
    check2(sizeof(lv), 16, "sizeof(L_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Ul_BFu0s)");
    check_field_offset(lv, v1, 0, "L_Ul_BFu0s.v1");
    check_field_offset(lv, v2, 8, "L_Ul_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vL_Ul_BFu0s(Test_L_Ul_BFu0s, "L_Ul_BFu0s", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Us_BFu0c  {
  __tsi64 v1;
  unsigned short v2;
  unsigned char  :0;
};
//SIG(1 L_Us_BFu0c) C1{ FL Fs Fc:0}



static void Test_L_Us_BFu0c()
{
  {
    init_simple_test("L_Us_BFu0c");
    static L_Us_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu0c)");
    check_field_offset(lv, v1, 0, "L_Us_BFu0c.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vL_Us_BFu0c(Test_L_Us_BFu0c, "L_Us_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Us_BFu0i  {
  __tsi64 v1;
  unsigned short v2;
  unsigned int  :0;
};
//SIG(1 L_Us_BFu0i) C1{ FL Fs Fi:0}



static void Test_L_Us_BFu0i()
{
  {
    init_simple_test("L_Us_BFu0i");
    static L_Us_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu0i)");
    check_field_offset(lv, v1, 0, "L_Us_BFu0i.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vL_Us_BFu0i(Test_L_Us_BFu0i, "L_Us_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Us_BFu0ll  {
  __tsi64 v1;
  unsigned short v2;
  __tsu64  :0;
};
//SIG(1 L_Us_BFu0ll) C1{ FL Fs FL:0}



static void Test_L_Us_BFu0ll()
{
  {
    init_simple_test("L_Us_BFu0ll");
    static L_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_Us_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vL_Us_BFu0ll(Test_L_Us_BFu0ll, "L_Us_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Us_BFu0s  {
  __tsi64 v1;
  unsigned short v2;
  unsigned short  :0;
};
//SIG(1 L_Us_BFu0s) C1{ FL Fs Fs:0}



static void Test_L_Us_BFu0s()
{
  {
    init_simple_test("L_Us_BFu0s");
    static L_Us_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Us_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Us_BFu0s)");
    check_field_offset(lv, v1, 0, "L_Us_BFu0s.v1");
    check_field_offset(lv, v2, 8, "L_Us_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vL_Us_BFu0s(Test_L_Us_BFu0s, "L_Us_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Vp_BFu0c  {
  __tsi64 v1;
  void *v2;
  unsigned char  :0;
};
//SIG(1 L_Vp_BFu0c) C1{ FL Fp Fc:0}



static void Test_L_Vp_BFu0c()
{
  {
    init_simple_test("L_Vp_BFu0c");
    static L_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Vp_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu0c)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu0c.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vL_Vp_BFu0c(Test_L_Vp_BFu0c, "L_Vp_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Vp_BFu0i  {
  __tsi64 v1;
  void *v2;
  unsigned int  :0;
};
//SIG(1 L_Vp_BFu0i) C1{ FL Fp Fi:0}



static void Test_L_Vp_BFu0i()
{
  {
    init_simple_test("L_Vp_BFu0i");
    static L_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu0i)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu0i.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vL_Vp_BFu0i(Test_L_Vp_BFu0i, "L_Vp_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Vp_BFu0ll  {
  __tsi64 v1;
  void *v2;
  __tsu64  :0;
};
//SIG(1 L_Vp_BFu0ll) C1{ FL Fp FL:0}



static void Test_L_Vp_BFu0ll()
{
  {
    init_simple_test("L_Vp_BFu0ll");
    static L_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu0ll)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu0ll.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vL_Vp_BFu0ll(Test_L_Vp_BFu0ll, "L_Vp_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  L_Vp_BFu0s  {
  __tsi64 v1;
  void *v2;
  unsigned short  :0;
};
//SIG(1 L_Vp_BFu0s) C1{ FL Fp Fs:0}



static void Test_L_Vp_BFu0s()
{
  {
    init_simple_test("L_Vp_BFu0s");
    static L_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(L_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(L_Vp_BFu0s)");
    check_field_offset(lv, v1, 0, "L_Vp_BFu0s.v1");
    check_field_offset(lv, v2, 8, "L_Vp_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vL_Vp_BFu0s(Test_L_Vp_BFu0s, "L_Vp_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c  {
  short v1;
  unsigned char  :0;
};
//SIG(1 S_BFu0c) C1{ Fs Fc:0}



static void Test_S_BFu0c()
{
  {
    init_simple_test("S_BFu0c");
    static S_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(S_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0c(Test_S_BFu0c, "S_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu0c  {
  short v1;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 S_BFu0c_BFu0c) C1{ Fs Fc:0 Fc:0}



static void Test_S_BFu0c_BFu0c()
{
  {
    init_simple_test("S_BFu0c_BFu0c");
    static S_BFu0c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(S_BFu0c_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu0c(Test_S_BFu0c_BFu0c, "S_BFu0c_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu0i  {
  short v1;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 S_BFu0c_BFu0i) C1{ Fs Fc:0 Fi:0}



static void Test_S_BFu0c_BFu0i()
{
  {
    init_simple_test("S_BFu0c_BFu0i");
    static S_BFu0c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0c_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu0i(Test_S_BFu0c_BFu0i, "S_BFu0c_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu0ll  {
  short v1;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 S_BFu0c_BFu0ll) C1{ Fs Fc:0 FL:0}



static void Test_S_BFu0c_BFu0ll()
{
  {
    init_simple_test("S_BFu0c_BFu0ll");
    static S_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0c_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu0ll(Test_S_BFu0c_BFu0ll, "S_BFu0c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu0s  {
  short v1;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 S_BFu0c_BFu0s) C1{ Fs Fc:0 Fs:0}



static void Test_S_BFu0c_BFu0s()
{
  {
    init_simple_test("S_BFu0c_BFu0s");
    static S_BFu0c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(S_BFu0c_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu0s(Test_S_BFu0c_BFu0s, "S_BFu0c_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu15i  {
  short v1;
  unsigned char  :0;
  unsigned int v2:15;
};
//SIG(1 S_BFu0c_BFu15i) C1{ Fs Fc:0 Fi:15}



static void Test_S_BFu0c_BFu15i()
{
  {
    init_simple_test("S_BFu0c_BFu15i");
    static S_BFu0c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0c_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu0c_BFu15i");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu15i(Test_S_BFu0c_BFu15i, "S_BFu0c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu15ll  {
  short v1;
  unsigned char  :0;
  __tsu64 v2:15;
};
//SIG(1 S_BFu0c_BFu15ll) C1{ Fs Fc:0 FL:15}



static void Test_S_BFu0c_BFu15ll()
{
  {
    init_simple_test("S_BFu0c_BFu15ll");
    static S_BFu0c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu0c_BFu15ll");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu15ll(Test_S_BFu0c_BFu15ll, "S_BFu0c_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu15s  {
  short v1;
  unsigned char  :0;
  unsigned short v2:15;
};
//SIG(1 S_BFu0c_BFu15s) C1{ Fs Fc:0 Fs:15}



static void Test_S_BFu0c_BFu15s()
{
  {
    init_simple_test("S_BFu0c_BFu15s");
    static S_BFu0c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu0c_BFu15s");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu15s(Test_S_BFu0c_BFu15s, "S_BFu0c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu16i  {
  short v1;
  unsigned char  :0;
  unsigned int v2:16;
};
//SIG(1 S_BFu0c_BFu16i) C1{ Fs Fc:0 Fi:16}



static void Test_S_BFu0c_BFu16i()
{
  {
    init_simple_test("S_BFu0c_BFu16i");
    static S_BFu0c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0c_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu0c_BFu16i");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu16i(Test_S_BFu0c_BFu16i, "S_BFu0c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu16ll  {
  short v1;
  unsigned char  :0;
  __tsu64 v2:16;
};
//SIG(1 S_BFu0c_BFu16ll) C1{ Fs Fc:0 FL:16}



static void Test_S_BFu0c_BFu16ll()
{
  {
    init_simple_test("S_BFu0c_BFu16ll");
    static S_BFu0c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu0c_BFu16ll");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu16ll(Test_S_BFu0c_BFu16ll, "S_BFu0c_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu16s  {
  short v1;
  unsigned char  :0;
  unsigned short v2:16;
};
//SIG(1 S_BFu0c_BFu16s) C1{ Fs Fc:0 Fs:16}



static void Test_S_BFu0c_BFu16s()
{
  {
    init_simple_test("S_BFu0c_BFu16s");
    static S_BFu0c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu0c_BFu16s");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu16s(Test_S_BFu0c_BFu16s, "S_BFu0c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu17i  {
  short v1;
  unsigned char  :0;
  unsigned int v2:17;
};
//SIG(1 S_BFu0c_BFu17i) C1{ Fs Fc:0 Fi:17}



static void Test_S_BFu0c_BFu17i()
{
  {
    init_simple_test("S_BFu0c_BFu17i");
    static S_BFu0c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0c_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu0c_BFu17i");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu17i(Test_S_BFu0c_BFu17i, "S_BFu0c_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu17ll  {
  short v1;
  unsigned char  :0;
  __tsu64 v2:17;
};
//SIG(1 S_BFu0c_BFu17ll) C1{ Fs Fc:0 FL:17}



static void Test_S_BFu0c_BFu17ll()
{
  {
    init_simple_test("S_BFu0c_BFu17ll");
    static S_BFu0c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu0c_BFu17ll");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu17ll(Test_S_BFu0c_BFu17ll, "S_BFu0c_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu1c  {
  short v1;
  unsigned char  :0;
  unsigned char v2:1;
};
//SIG(1 S_BFu0c_BFu1c) C1{ Fs Fc:0 Fc:1}



static void Test_S_BFu0c_BFu1c()
{
  {
    init_simple_test("S_BFu0c_BFu1c");
    static S_BFu0c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu0c_BFu1c");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu1c(Test_S_BFu0c_BFu1c, "S_BFu0c_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu1i  {
  short v1;
  unsigned char  :0;
  unsigned int v2:1;
};
//SIG(1 S_BFu0c_BFu1i) C1{ Fs Fc:0 Fi:1}



static void Test_S_BFu0c_BFu1i()
{
  {
    init_simple_test("S_BFu0c_BFu1i");
    static S_BFu0c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0c_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu0c_BFu1i");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu1i(Test_S_BFu0c_BFu1i, "S_BFu0c_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu1ll  {
  short v1;
  unsigned char  :0;
  __tsu64 v2:1;
};
//SIG(1 S_BFu0c_BFu1ll) C1{ Fs Fc:0 FL:1}



static void Test_S_BFu0c_BFu1ll()
{
  {
    init_simple_test("S_BFu0c_BFu1ll");
    static S_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu0c_BFu1ll");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu1ll(Test_S_BFu0c_BFu1ll, "S_BFu0c_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu1s  {
  short v1;
  unsigned char  :0;
  unsigned short v2:1;
};
//SIG(1 S_BFu0c_BFu1s) C1{ Fs Fc:0 Fs:1}



static void Test_S_BFu0c_BFu1s()
{
  {
    init_simple_test("S_BFu0c_BFu1s");
    static S_BFu0c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu0c_BFu1s");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu1s(Test_S_BFu0c_BFu1s, "S_BFu0c_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu31i  {
  short v1;
  unsigned char  :0;
  unsigned int v2:31;
};
//SIG(1 S_BFu0c_BFu31i) C1{ Fs Fc:0 Fi:31}



static void Test_S_BFu0c_BFu31i()
{
  {
    init_simple_test("S_BFu0c_BFu31i");
    static S_BFu0c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0c_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu0c_BFu31i");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu31i(Test_S_BFu0c_BFu31i, "S_BFu0c_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu31ll  {
  short v1;
  unsigned char  :0;
  __tsu64 v2:31;
};
//SIG(1 S_BFu0c_BFu31ll) C1{ Fs Fc:0 FL:31}



static void Test_S_BFu0c_BFu31ll()
{
  {
    init_simple_test("S_BFu0c_BFu31ll");
    static S_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu0c_BFu31ll");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu31ll(Test_S_BFu0c_BFu31ll, "S_BFu0c_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu32i  {
  short v1;
  unsigned char  :0;
  unsigned int v2:32;
};
//SIG(1 S_BFu0c_BFu32i) C1{ Fs Fc:0 Fi:32}



static void Test_S_BFu0c_BFu32i()
{
  {
    init_simple_test("S_BFu0c_BFu32i");
    static S_BFu0c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0c_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu0c_BFu32i");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu32i(Test_S_BFu0c_BFu32i, "S_BFu0c_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu32ll  {
  short v1;
  unsigned char  :0;
  __tsu64 v2:32;
};
//SIG(1 S_BFu0c_BFu32ll) C1{ Fs Fc:0 FL:32}



static void Test_S_BFu0c_BFu32ll()
{
  {
    init_simple_test("S_BFu0c_BFu32ll");
    static S_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu0c_BFu32ll");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu32ll(Test_S_BFu0c_BFu32ll, "S_BFu0c_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu33  {
  short v1;
  unsigned char  :0;
  __tsu64 v2:33;
};
//SIG(1 S_BFu0c_BFu33) C1{ Fs Fc:0 FL:33}



static void Test_S_BFu0c_BFu33()
{
  {
    init_simple_test("S_BFu0c_BFu33");
    static S_BFu0c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu0c_BFu33");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu33(Test_S_BFu0c_BFu33, "S_BFu0c_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu7c  {
  short v1;
  unsigned char  :0;
  unsigned char v2:7;
};
//SIG(1 S_BFu0c_BFu7c) C1{ Fs Fc:0 Fc:7}



static void Test_S_BFu0c_BFu7c()
{
  {
    init_simple_test("S_BFu0c_BFu7c");
    static S_BFu0c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu0c_BFu7c");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu7c(Test_S_BFu0c_BFu7c, "S_BFu0c_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu7i  {
  short v1;
  unsigned char  :0;
  unsigned int v2:7;
};
//SIG(1 S_BFu0c_BFu7i) C1{ Fs Fc:0 Fi:7}



static void Test_S_BFu0c_BFu7i()
{
  {
    init_simple_test("S_BFu0c_BFu7i");
    static S_BFu0c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0c_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu0c_BFu7i");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu7i(Test_S_BFu0c_BFu7i, "S_BFu0c_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu7ll  {
  short v1;
  unsigned char  :0;
  __tsu64 v2:7;
};
//SIG(1 S_BFu0c_BFu7ll) C1{ Fs Fc:0 FL:7}



static void Test_S_BFu0c_BFu7ll()
{
  {
    init_simple_test("S_BFu0c_BFu7ll");
    static S_BFu0c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu0c_BFu7ll");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu7ll(Test_S_BFu0c_BFu7ll, "S_BFu0c_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu7s  {
  short v1;
  unsigned char  :0;
  unsigned short v2:7;
};
//SIG(1 S_BFu0c_BFu7s) C1{ Fs Fc:0 Fs:7}



static void Test_S_BFu0c_BFu7s()
{
  {
    init_simple_test("S_BFu0c_BFu7s");
    static S_BFu0c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu0c_BFu7s");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu7s(Test_S_BFu0c_BFu7s, "S_BFu0c_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu8c  {
  short v1;
  unsigned char  :0;
  unsigned char v2:8;
};
//SIG(1 S_BFu0c_BFu8c) C1{ Fs Fc:0 Fc:8}



static void Test_S_BFu0c_BFu8c()
{
  {
    init_simple_test("S_BFu0c_BFu8c");
    static S_BFu0c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu0c_BFu8c");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu8c(Test_S_BFu0c_BFu8c, "S_BFu0c_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu8i  {
  short v1;
  unsigned char  :0;
  unsigned int v2:8;
};
//SIG(1 S_BFu0c_BFu8i) C1{ Fs Fc:0 Fi:8}



static void Test_S_BFu0c_BFu8i()
{
  {
    init_simple_test("S_BFu0c_BFu8i");
    static S_BFu0c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0c_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu0c_BFu8i");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu8i(Test_S_BFu0c_BFu8i, "S_BFu0c_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu8ll  {
  short v1;
  unsigned char  :0;
  __tsu64 v2:8;
};
//SIG(1 S_BFu0c_BFu8ll) C1{ Fs Fc:0 FL:8}



static void Test_S_BFu0c_BFu8ll()
{
  {
    init_simple_test("S_BFu0c_BFu8ll");
    static S_BFu0c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu0c_BFu8ll");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu8ll(Test_S_BFu0c_BFu8ll, "S_BFu0c_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu8s  {
  short v1;
  unsigned char  :0;
  unsigned short v2:8;
};
//SIG(1 S_BFu0c_BFu8s) C1{ Fs Fc:0 Fs:8}



static void Test_S_BFu0c_BFu8s()
{
  {
    init_simple_test("S_BFu0c_BFu8s");
    static S_BFu0c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu0c_BFu8s");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu8s(Test_S_BFu0c_BFu8s, "S_BFu0c_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu9i  {
  short v1;
  unsigned char  :0;
  unsigned int v2:9;
};
//SIG(1 S_BFu0c_BFu9i) C1{ Fs Fc:0 Fi:9}



static void Test_S_BFu0c_BFu9i()
{
  {
    init_simple_test("S_BFu0c_BFu9i");
    static S_BFu0c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0c_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu0c_BFu9i");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu9i(Test_S_BFu0c_BFu9i, "S_BFu0c_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu9ll  {
  short v1;
  unsigned char  :0;
  __tsu64 v2:9;
};
//SIG(1 S_BFu0c_BFu9ll) C1{ Fs Fc:0 FL:9}



static void Test_S_BFu0c_BFu9ll()
{
  {
    init_simple_test("S_BFu0c_BFu9ll");
    static S_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu0c_BFu9ll");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu9ll(Test_S_BFu0c_BFu9ll, "S_BFu0c_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_BFu9s  {
  short v1;
  unsigned char  :0;
  unsigned short v2:9;
};
//SIG(1 S_BFu0c_BFu9s) C1{ Fs Fc:0 Fs:9}



static void Test_S_BFu0c_BFu9s()
{
  {
    init_simple_test("S_BFu0c_BFu9s");
    static S_BFu0c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu0c_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu0c_BFu9s");
  }
}
static Arrange_To_Call_Me vS_BFu0c_BFu9s(Test_S_BFu0c_BFu9s, "S_BFu0c_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_C  {
  short v1;
  unsigned char  :0;
  char v2;
};
//SIG(1 S_BFu0c_C) C1{ Fs Fc:0 Fc}



static void Test_S_BFu0c_C()
{
  {
    init_simple_test("S_BFu0c_C");
    static S_BFu0c_C lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_C)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_C)");
    check_field_offset(lv, v1, 0, "S_BFu0c_C.v1");
    check_field_offset(lv, v2, 2, "S_BFu0c_C.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0c_C(Test_S_BFu0c_C, "S_BFu0c_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_D  {
  short v1;
  unsigned char  :0;
  double v2;
};
//SIG(1 S_BFu0c_D) C1{ Fs Fc:0 FL}



static void Test_S_BFu0c_D()
{
  {
    init_simple_test("S_BFu0c_D");
    static S_BFu0c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu0c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_D)");
    check_field_offset(lv, v1, 0, "S_BFu0c_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0c_D.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0c_D(Test_S_BFu0c_D, "S_BFu0c_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_F  {
  short v1;
  unsigned char  :0;
  float v2;
};
//SIG(1 S_BFu0c_F) C1{ Fs Fc:0 Fi}



static void Test_S_BFu0c_F()
{
  {
    init_simple_test("S_BFu0c_F");
    static S_BFu0c_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0c_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0c_F)");
    check_field_offset(lv, v1, 0, "S_BFu0c_F.v1");
    check_field_offset(lv, v2, 4, "S_BFu0c_F.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0c_F(Test_S_BFu0c_F, "S_BFu0c_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_I  {
  short v1;
  unsigned char  :0;
  int v2;
};
//SIG(1 S_BFu0c_I) C1{ Fs Fc:0 Fi}



static void Test_S_BFu0c_I()
{
  {
    init_simple_test("S_BFu0c_I");
    static S_BFu0c_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0c_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0c_I)");
    check_field_offset(lv, v1, 0, "S_BFu0c_I.v1");
    check_field_offset(lv, v2, 4, "S_BFu0c_I.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0c_I(Test_S_BFu0c_I, "S_BFu0c_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_Ip  {
  short v1;
  unsigned char  :0;
  int *v2;
};
//SIG(1 S_BFu0c_Ip) C1{ Fs Fc:0 Fp}



static void Test_S_BFu0c_Ip()
{
  {
    init_simple_test("S_BFu0c_Ip");
    static S_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu0c_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0c_Ip.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0c_Ip(Test_S_BFu0c_Ip, "S_BFu0c_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_L  {
  short v1;
  unsigned char  :0;
  __tsi64 v2;
};
//SIG(1 S_BFu0c_L) C1{ Fs Fc:0 FL}



static void Test_S_BFu0c_L()
{
  {
    init_simple_test("S_BFu0c_L");
    static S_BFu0c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu0c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_L)");
    check_field_offset(lv, v1, 0, "S_BFu0c_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0c_L.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0c_L(Test_S_BFu0c_L, "S_BFu0c_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_S  {
  short v1;
  unsigned char  :0;
  short v2;
};
//SIG(1 S_BFu0c_S) C1{ Fs Fc:0 Fs}



static void Test_S_BFu0c_S()
{
  {
    init_simple_test("S_BFu0c_S");
    static S_BFu0c_S lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_S)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_S)");
    check_field_offset(lv, v1, 0, "S_BFu0c_S.v1");
    check_field_offset(lv, v2, 2, "S_BFu0c_S.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0c_S(Test_S_BFu0c_S, "S_BFu0c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_Uc  {
  short v1;
  unsigned char  :0;
  unsigned char v2;
};
//SIG(1 S_BFu0c_Uc) C1{ Fs Fc:0 Fc}



static void Test_S_BFu0c_Uc()
{
  {
    init_simple_test("S_BFu0c_Uc");
    static S_BFu0c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu0c_Uc.v1");
    check_field_offset(lv, v2, 2, "S_BFu0c_Uc.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0c_Uc(Test_S_BFu0c_Uc, "S_BFu0c_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_Ui  {
  short v1;
  unsigned char  :0;
  unsigned int v2;
};
//SIG(1 S_BFu0c_Ui) C1{ Fs Fc:0 Fi}



static void Test_S_BFu0c_Ui()
{
  {
    init_simple_test("S_BFu0c_Ui");
    static S_BFu0c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0c_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu0c_Ui.v1");
    check_field_offset(lv, v2, 4, "S_BFu0c_Ui.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0c_Ui(Test_S_BFu0c_Ui, "S_BFu0c_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_Ul  {
  short v1;
  unsigned char  :0;
  __tsu64 v2;
};
//SIG(1 S_BFu0c_Ul) C1{ Fs Fc:0 FL}



static void Test_S_BFu0c_Ul()
{
  {
    init_simple_test("S_BFu0c_Ul");
    static S_BFu0c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu0c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu0c_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0c_Ul.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0c_Ul(Test_S_BFu0c_Ul, "S_BFu0c_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_Us  {
  short v1;
  unsigned char  :0;
  unsigned short v2;
};
//SIG(1 S_BFu0c_Us) C1{ Fs Fc:0 Fs}



static void Test_S_BFu0c_Us()
{
  {
    init_simple_test("S_BFu0c_Us");
    static S_BFu0c_Us lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0c_Us)");
    check_field_offset(lv, v1, 0, "S_BFu0c_Us.v1");
    check_field_offset(lv, v2, 2, "S_BFu0c_Us.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0c_Us(Test_S_BFu0c_Us, "S_BFu0c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0c_Vp  {
  short v1;
  unsigned char  :0;
  void *v2;
};
//SIG(1 S_BFu0c_Vp) C1{ Fs Fc:0 Fp}



static void Test_S_BFu0c_Vp()
{
  {
    init_simple_test("S_BFu0c_Vp");
    static S_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0c_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu0c_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0c_Vp.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0c_Vp(Test_S_BFu0c_Vp, "S_BFu0c_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i  {
  short v1;
  unsigned int  :0;
};
//SIG(1 S_BFu0i) C1{ Fs Fi:0}



static void Test_S_BFu0i()
{
  {
    init_simple_test("S_BFu0i");
    static S_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0i(Test_S_BFu0i, "S_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu0c  {
  short v1;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 S_BFu0i_BFu0c) C1{ Fs Fi:0 Fc:0}



static void Test_S_BFu0i_BFu0c()
{
  {
    init_simple_test("S_BFu0i_BFu0c");
    static S_BFu0i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu0c(Test_S_BFu0i_BFu0c, "S_BFu0i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu0i  {
  short v1;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 S_BFu0i_BFu0i) C1{ Fs Fi:0 Fi:0}



static void Test_S_BFu0i_BFu0i()
{
  {
    init_simple_test("S_BFu0i_BFu0i");
    static S_BFu0i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu0i(Test_S_BFu0i_BFu0i, "S_BFu0i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu0ll  {
  short v1;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 S_BFu0i_BFu0ll) C1{ Fs Fi:0 FL:0}



static void Test_S_BFu0i_BFu0ll()
{
  {
    init_simple_test("S_BFu0i_BFu0ll");
    static S_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu0ll(Test_S_BFu0i_BFu0ll, "S_BFu0i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu0s  {
  short v1;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 S_BFu0i_BFu0s) C1{ Fs Fi:0 Fs:0}



static void Test_S_BFu0i_BFu0s()
{
  {
    init_simple_test("S_BFu0i_BFu0s");
    static S_BFu0i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu0s(Test_S_BFu0i_BFu0s, "S_BFu0i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu15i  {
  short v1;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 S_BFu0i_BFu15i) C1{ Fs Fi:0 Fi:15}



static void Test_S_BFu0i_BFu15i()
{
  {
    init_simple_test("S_BFu0i_BFu15i");
    static S_BFu0i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0i_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "S_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "S_BFu0i_BFu15i");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu15i(Test_S_BFu0i_BFu15i, "S_BFu0i_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu15ll  {
  short v1;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 S_BFu0i_BFu15ll) C1{ Fs Fi:0 FL:15}



static void Test_S_BFu0i_BFu15ll()
{
  {
    init_simple_test("S_BFu0i_BFu15ll");
    static S_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "S_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "S_BFu0i_BFu15ll");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu15ll(Test_S_BFu0i_BFu15ll, "S_BFu0i_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu15s  {
  short v1;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 S_BFu0i_BFu15s) C1{ Fs Fi:0 Fs:15}



static void Test_S_BFu0i_BFu15s()
{
  {
    init_simple_test("S_BFu0i_BFu15s");
    static S_BFu0i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(S_BFu0i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "S_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "S_BFu0i_BFu15s");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu15s(Test_S_BFu0i_BFu15s, "S_BFu0i_BFu15s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu16i  {
  short v1;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 S_BFu0i_BFu16i) C1{ Fs Fi:0 Fi:16}



static void Test_S_BFu0i_BFu16i()
{
  {
    init_simple_test("S_BFu0i_BFu16i");
    static S_BFu0i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0i_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "S_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "S_BFu0i_BFu16i");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu16i(Test_S_BFu0i_BFu16i, "S_BFu0i_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu16ll  {
  short v1;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 S_BFu0i_BFu16ll) C1{ Fs Fi:0 FL:16}



static void Test_S_BFu0i_BFu16ll()
{
  {
    init_simple_test("S_BFu0i_BFu16ll");
    static S_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "S_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "S_BFu0i_BFu16ll");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu16ll(Test_S_BFu0i_BFu16ll, "S_BFu0i_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu16s  {
  short v1;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 S_BFu0i_BFu16s) C1{ Fs Fi:0 Fs:16}



static void Test_S_BFu0i_BFu16s()
{
  {
    init_simple_test("S_BFu0i_BFu16s");
    static S_BFu0i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(S_BFu0i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "S_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "S_BFu0i_BFu16s");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu16s(Test_S_BFu0i_BFu16s, "S_BFu0i_BFu16s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu17i  {
  short v1;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 S_BFu0i_BFu17i) C1{ Fs Fi:0 Fi:17}



static void Test_S_BFu0i_BFu17i()
{
  {
    init_simple_test("S_BFu0i_BFu17i");
    static S_BFu0i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0i_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu0i_BFu17i");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu17i(Test_S_BFu0i_BFu17i, "S_BFu0i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu17ll  {
  short v1;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 S_BFu0i_BFu17ll) C1{ Fs Fi:0 FL:17}



static void Test_S_BFu0i_BFu17ll()
{
  {
    init_simple_test("S_BFu0i_BFu17ll");
    static S_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu0i_BFu17ll");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu17ll(Test_S_BFu0i_BFu17ll, "S_BFu0i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu1c  {
  short v1;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 S_BFu0i_BFu1c) C1{ Fs Fi:0 Fc:1}



static void Test_S_BFu0i_BFu1c()
{
  {
    init_simple_test("S_BFu0i_BFu1c");
    static S_BFu0i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(S_BFu0i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "S_BFu0i_BFu1c");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu1c(Test_S_BFu0i_BFu1c, "S_BFu0i_BFu1c", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu1i  {
  short v1;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 S_BFu0i_BFu1i) C1{ Fs Fi:0 Fi:1}



static void Test_S_BFu0i_BFu1i()
{
  {
    init_simple_test("S_BFu0i_BFu1i");
    static S_BFu0i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0i_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "S_BFu0i_BFu1i");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu1i(Test_S_BFu0i_BFu1i, "S_BFu0i_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu1ll  {
  short v1;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 S_BFu0i_BFu1ll) C1{ Fs Fi:0 FL:1}



static void Test_S_BFu0i_BFu1ll()
{
  {
    init_simple_test("S_BFu0i_BFu1ll");
    static S_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "S_BFu0i_BFu1ll");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu1ll(Test_S_BFu0i_BFu1ll, "S_BFu0i_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu1s  {
  short v1;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 S_BFu0i_BFu1s) C1{ Fs Fi:0 Fs:1}



static void Test_S_BFu0i_BFu1s()
{
  {
    init_simple_test("S_BFu0i_BFu1s");
    static S_BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(S_BFu0i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "S_BFu0i_BFu1s");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu1s(Test_S_BFu0i_BFu1s, "S_BFu0i_BFu1s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu31i  {
  short v1;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 S_BFu0i_BFu31i) C1{ Fs Fi:0 Fi:31}



static void Test_S_BFu0i_BFu31i()
{
  {
    init_simple_test("S_BFu0i_BFu31i");
    static S_BFu0i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0i_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu0i_BFu31i");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu31i(Test_S_BFu0i_BFu31i, "S_BFu0i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu31ll  {
  short v1;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 S_BFu0i_BFu31ll) C1{ Fs Fi:0 FL:31}



static void Test_S_BFu0i_BFu31ll()
{
  {
    init_simple_test("S_BFu0i_BFu31ll");
    static S_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu0i_BFu31ll");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu31ll(Test_S_BFu0i_BFu31ll, "S_BFu0i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu32i  {
  short v1;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 S_BFu0i_BFu32i) C1{ Fs Fi:0 Fi:32}



static void Test_S_BFu0i_BFu32i()
{
  {
    init_simple_test("S_BFu0i_BFu32i");
    static S_BFu0i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0i_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu0i_BFu32i");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu32i(Test_S_BFu0i_BFu32i, "S_BFu0i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu32ll  {
  short v1;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 S_BFu0i_BFu32ll) C1{ Fs Fi:0 FL:32}



static void Test_S_BFu0i_BFu32ll()
{
  {
    init_simple_test("S_BFu0i_BFu32ll");
    static S_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu0i_BFu32ll");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu32ll(Test_S_BFu0i_BFu32ll, "S_BFu0i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu33  {
  short v1;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 S_BFu0i_BFu33) C1{ Fs Fi:0 FL:33}



static void Test_S_BFu0i_BFu33()
{
  {
    init_simple_test("S_BFu0i_BFu33");
    static S_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "S_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "S_BFu0i_BFu33");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu33(Test_S_BFu0i_BFu33, "S_BFu0i_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu7c  {
  short v1;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 S_BFu0i_BFu7c) C1{ Fs Fi:0 Fc:7}



static void Test_S_BFu0i_BFu7c()
{
  {
    init_simple_test("S_BFu0i_BFu7c");
    static S_BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(S_BFu0i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "S_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "S_BFu0i_BFu7c");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu7c(Test_S_BFu0i_BFu7c, "S_BFu0i_BFu7c", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu7i  {
  short v1;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 S_BFu0i_BFu7i) C1{ Fs Fi:0 Fi:7}



static void Test_S_BFu0i_BFu7i()
{
  {
    init_simple_test("S_BFu0i_BFu7i");
    static S_BFu0i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0i_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "S_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "S_BFu0i_BFu7i");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu7i(Test_S_BFu0i_BFu7i, "S_BFu0i_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu7ll  {
  short v1;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 S_BFu0i_BFu7ll) C1{ Fs Fi:0 FL:7}



static void Test_S_BFu0i_BFu7ll()
{
  {
    init_simple_test("S_BFu0i_BFu7ll");
    static S_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "S_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "S_BFu0i_BFu7ll");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu7ll(Test_S_BFu0i_BFu7ll, "S_BFu0i_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu7s  {
  short v1;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 S_BFu0i_BFu7s) C1{ Fs Fi:0 Fs:7}



static void Test_S_BFu0i_BFu7s()
{
  {
    init_simple_test("S_BFu0i_BFu7s");
    static S_BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(S_BFu0i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "S_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "S_BFu0i_BFu7s");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu7s(Test_S_BFu0i_BFu7s, "S_BFu0i_BFu7s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu8c  {
  short v1;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 S_BFu0i_BFu8c) C1{ Fs Fi:0 Fc:8}



static void Test_S_BFu0i_BFu8c()
{
  {
    init_simple_test("S_BFu0i_BFu8c");
    static S_BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(S_BFu0i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "S_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "S_BFu0i_BFu8c");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu8c(Test_S_BFu0i_BFu8c, "S_BFu0i_BFu8c", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu8i  {
  short v1;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 S_BFu0i_BFu8i) C1{ Fs Fi:0 Fi:8}



static void Test_S_BFu0i_BFu8i()
{
  {
    init_simple_test("S_BFu0i_BFu8i");
    static S_BFu0i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0i_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "S_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "S_BFu0i_BFu8i");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu8i(Test_S_BFu0i_BFu8i, "S_BFu0i_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu8ll  {
  short v1;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 S_BFu0i_BFu8ll) C1{ Fs Fi:0 FL:8}



static void Test_S_BFu0i_BFu8ll()
{
  {
    init_simple_test("S_BFu0i_BFu8ll");
    static S_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "S_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "S_BFu0i_BFu8ll");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu8ll(Test_S_BFu0i_BFu8ll, "S_BFu0i_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu8s  {
  short v1;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 S_BFu0i_BFu8s) C1{ Fs Fi:0 Fs:8}



static void Test_S_BFu0i_BFu8s()
{
  {
    init_simple_test("S_BFu0i_BFu8s");
    static S_BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(S_BFu0i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "S_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "S_BFu0i_BFu8s");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu8s(Test_S_BFu0i_BFu8s, "S_BFu0i_BFu8s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu9i  {
  short v1;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 S_BFu0i_BFu9i) C1{ Fs Fi:0 Fi:9}



static void Test_S_BFu0i_BFu9i()
{
  {
    init_simple_test("S_BFu0i_BFu9i");
    static S_BFu0i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0i_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "S_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "S_BFu0i_BFu9i");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu9i(Test_S_BFu0i_BFu9i, "S_BFu0i_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu9ll  {
  short v1;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 S_BFu0i_BFu9ll) C1{ Fs Fi:0 FL:9}



static void Test_S_BFu0i_BFu9ll()
{
  {
    init_simple_test("S_BFu0i_BFu9ll");
    static S_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "S_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "S_BFu0i_BFu9ll");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu9ll(Test_S_BFu0i_BFu9ll, "S_BFu0i_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_BFu9s  {
  short v1;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 S_BFu0i_BFu9s) C1{ Fs Fi:0 Fs:9}



static void Test_S_BFu0i_BFu9s()
{
  {
    init_simple_test("S_BFu0i_BFu9s");
    static S_BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(S_BFu0i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu0i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "S_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "S_BFu0i_BFu9s");
  }
}
static Arrange_To_Call_Me vS_BFu0i_BFu9s(Test_S_BFu0i_BFu9s, "S_BFu0i_BFu9s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_C  {
  short v1;
  unsigned int  :0;
  char v2;
};
//SIG(1 S_BFu0i_C) C1{ Fs Fi:0 Fc}



static void Test_S_BFu0i_C()
{
  {
    init_simple_test("S_BFu0i_C");
    static S_BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(S_BFu0i_C)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_C)");
    check_field_offset(lv, v1, 0, "S_BFu0i_C.v1");
    check_field_offset(lv, v2, 4, "S_BFu0i_C.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0i_C(Test_S_BFu0i_C, "S_BFu0i_C", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_D  {
  short v1;
  unsigned int  :0;
  double v2;
};
//SIG(1 S_BFu0i_D) C1{ Fs Fi:0 FL}



static void Test_S_BFu0i_D()
{
  {
    init_simple_test("S_BFu0i_D");
    static S_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_D)");
    check_field_offset(lv, v1, 0, "S_BFu0i_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0i_D.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0i_D(Test_S_BFu0i_D, "S_BFu0i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_F  {
  short v1;
  unsigned int  :0;
  float v2;
};
//SIG(1 S_BFu0i_F) C1{ Fs Fi:0 Fi}



static void Test_S_BFu0i_F()
{
  {
    init_simple_test("S_BFu0i_F");
    static S_BFu0i_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0i_F)");
    check_field_offset(lv, v1, 0, "S_BFu0i_F.v1");
    check_field_offset(lv, v2, 4, "S_BFu0i_F.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0i_F(Test_S_BFu0i_F, "S_BFu0i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_I  {
  short v1;
  unsigned int  :0;
  int v2;
};
//SIG(1 S_BFu0i_I) C1{ Fs Fi:0 Fi}



static void Test_S_BFu0i_I()
{
  {
    init_simple_test("S_BFu0i_I");
    static S_BFu0i_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0i_I)");
    check_field_offset(lv, v1, 0, "S_BFu0i_I.v1");
    check_field_offset(lv, v2, 4, "S_BFu0i_I.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0i_I(Test_S_BFu0i_I, "S_BFu0i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_Ip  {
  short v1;
  unsigned int  :0;
  int *v2;
};
//SIG(1 S_BFu0i_Ip) C1{ Fs Fi:0 Fp}



static void Test_S_BFu0i_Ip()
{
  {
    init_simple_test("S_BFu0i_Ip");
    static S_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu0i_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0i_Ip.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0i_Ip(Test_S_BFu0i_Ip, "S_BFu0i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_L  {
  short v1;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 S_BFu0i_L) C1{ Fs Fi:0 FL}



static void Test_S_BFu0i_L()
{
  {
    init_simple_test("S_BFu0i_L");
    static S_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_L)");
    check_field_offset(lv, v1, 0, "S_BFu0i_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0i_L.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0i_L(Test_S_BFu0i_L, "S_BFu0i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_S  {
  short v1;
  unsigned int  :0;
  short v2;
};
//SIG(1 S_BFu0i_S) C1{ Fs Fi:0 Fs}



static void Test_S_BFu0i_S()
{
  {
    init_simple_test("S_BFu0i_S");
    static S_BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(S_BFu0i_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_S)");
    check_field_offset(lv, v1, 0, "S_BFu0i_S.v1");
    check_field_offset(lv, v2, 4, "S_BFu0i_S.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0i_S(Test_S_BFu0i_S, "S_BFu0i_S", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_Uc  {
  short v1;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 S_BFu0i_Uc) C1{ Fs Fi:0 Fc}



static void Test_S_BFu0i_Uc()
{
  {
    init_simple_test("S_BFu0i_Uc");
    static S_BFu0i_Uc lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(S_BFu0i_Uc)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu0i_Uc.v1");
    check_field_offset(lv, v2, 4, "S_BFu0i_Uc.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0i_Uc(Test_S_BFu0i_Uc, "S_BFu0i_Uc", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_Ui  {
  short v1;
  unsigned int  :0;
  unsigned int v2;
};
//SIG(1 S_BFu0i_Ui) C1{ Fs Fi:0 Fi}



static void Test_S_BFu0i_Ui()
{
  {
    init_simple_test("S_BFu0i_Ui");
    static S_BFu0i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0i_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu0i_Ui.v1");
    check_field_offset(lv, v2, 4, "S_BFu0i_Ui.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0i_Ui(Test_S_BFu0i_Ui, "S_BFu0i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_Ul  {
  short v1;
  unsigned int  :0;
  __tsu64 v2;
};
//SIG(1 S_BFu0i_Ul) C1{ Fs Fi:0 FL}



static void Test_S_BFu0i_Ul()
{
  {
    init_simple_test("S_BFu0i_Ul");
    static S_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu0i_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0i_Ul.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0i_Ul(Test_S_BFu0i_Ul, "S_BFu0i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_Us  {
  short v1;
  unsigned int  :0;
  unsigned short v2;
};
//SIG(1 S_BFu0i_Us) C1{ Fs Fi:0 Fs}



static void Test_S_BFu0i_Us()
{
  {
    init_simple_test("S_BFu0i_Us");
    static S_BFu0i_Us lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(S_BFu0i_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0i_Us)");
    check_field_offset(lv, v1, 0, "S_BFu0i_Us.v1");
    check_field_offset(lv, v2, 4, "S_BFu0i_Us.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0i_Us(Test_S_BFu0i_Us, "S_BFu0i_Us", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0i_Vp  {
  short v1;
  unsigned int  :0;
  void *v2;
};
//SIG(1 S_BFu0i_Vp) C1{ Fs Fi:0 Fp}



static void Test_S_BFu0i_Vp()
{
  {
    init_simple_test("S_BFu0i_Vp");
    static S_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0i_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu0i_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0i_Vp.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0i_Vp(Test_S_BFu0i_Vp, "S_BFu0i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll  {
  short v1;
  __tsu64  :0;
};
//SIG(1 S_BFu0ll) C1{ Fs FL:0}



static void Test_S_BFu0ll()
{
  {
    init_simple_test("S_BFu0ll");
    static S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0ll(Test_S_BFu0ll, "S_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu0c  {
  short v1;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 S_BFu0ll_BFu0c) C1{ Fs FL:0 Fc:0}



static void Test_S_BFu0ll_BFu0c()
{
  {
    init_simple_test("S_BFu0ll_BFu0c");
    static S_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu0c(Test_S_BFu0ll_BFu0c, "S_BFu0ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu0i  {
  short v1;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 S_BFu0ll_BFu0i) C1{ Fs FL:0 Fi:0}



static void Test_S_BFu0ll_BFu0i()
{
  {
    init_simple_test("S_BFu0ll_BFu0i");
    static S_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu0i(Test_S_BFu0ll_BFu0i, "S_BFu0ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu0ll  {
  short v1;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 S_BFu0ll_BFu0ll) C1{ Fs FL:0 FL:0}



static void Test_S_BFu0ll_BFu0ll()
{
  {
    init_simple_test("S_BFu0ll_BFu0ll");
    static S_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu0ll(Test_S_BFu0ll_BFu0ll, "S_BFu0ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu0s  {
  short v1;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 S_BFu0ll_BFu0s) C1{ Fs FL:0 Fs:0}



static void Test_S_BFu0ll_BFu0s()
{
  {
    init_simple_test("S_BFu0ll_BFu0s");
    static S_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu0s(Test_S_BFu0ll_BFu0s, "S_BFu0ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu15i  {
  short v1;
  __tsu64  :0;
  unsigned int v2:15;
};
//SIG(1 S_BFu0ll_BFu15i) C1{ Fs FL:0 Fi:15}



static void Test_S_BFu0ll_BFu15i()
{
  {
    init_simple_test("S_BFu0ll_BFu15i");
    static S_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu0ll_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "S_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "S_BFu0ll_BFu15i");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu15i(Test_S_BFu0ll_BFu15i, "S_BFu0ll_BFu15i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu15ll  {
  short v1;
  __tsu64  :0;
  __tsu64 v2:15;
};
//SIG(1 S_BFu0ll_BFu15ll) C1{ Fs FL:0 FL:15}



static void Test_S_BFu0ll_BFu15ll()
{
  {
    init_simple_test("S_BFu0ll_BFu15ll");
    static S_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "S_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "S_BFu0ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu15ll(Test_S_BFu0ll_BFu15ll, "S_BFu0ll_BFu15ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu15s  {
  short v1;
  __tsu64  :0;
  unsigned short v2:15;
};
//SIG(1 S_BFu0ll_BFu15s) C1{ Fs FL:0 Fs:15}



static void Test_S_BFu0ll_BFu15s()
{
  {
    init_simple_test("S_BFu0ll_BFu15s");
    static S_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(S_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "S_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "S_BFu0ll_BFu15s");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu15s(Test_S_BFu0ll_BFu15s, "S_BFu0ll_BFu15s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu16i  {
  short v1;
  __tsu64  :0;
  unsigned int v2:16;
};
//SIG(1 S_BFu0ll_BFu16i) C1{ Fs FL:0 Fi:16}



static void Test_S_BFu0ll_BFu16i()
{
  {
    init_simple_test("S_BFu0ll_BFu16i");
    static S_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu0ll_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "S_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "S_BFu0ll_BFu16i");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu16i(Test_S_BFu0ll_BFu16i, "S_BFu0ll_BFu16i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu16ll  {
  short v1;
  __tsu64  :0;
  __tsu64 v2:16;
};
//SIG(1 S_BFu0ll_BFu16ll) C1{ Fs FL:0 FL:16}



static void Test_S_BFu0ll_BFu16ll()
{
  {
    init_simple_test("S_BFu0ll_BFu16ll");
    static S_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "S_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "S_BFu0ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu16ll(Test_S_BFu0ll_BFu16ll, "S_BFu0ll_BFu16ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu16s  {
  short v1;
  __tsu64  :0;
  unsigned short v2:16;
};
//SIG(1 S_BFu0ll_BFu16s) C1{ Fs FL:0 Fs:16}



static void Test_S_BFu0ll_BFu16s()
{
  {
    init_simple_test("S_BFu0ll_BFu16s");
    static S_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(S_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "S_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "S_BFu0ll_BFu16s");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu16s(Test_S_BFu0ll_BFu16s, "S_BFu0ll_BFu16s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu17i  {
  short v1;
  __tsu64  :0;
  unsigned int v2:17;
};
//SIG(1 S_BFu0ll_BFu17i) C1{ Fs FL:0 Fi:17}



static void Test_S_BFu0ll_BFu17i()
{
  {
    init_simple_test("S_BFu0ll_BFu17i");
    static S_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu0ll_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "S_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "S_BFu0ll_BFu17i");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu17i(Test_S_BFu0ll_BFu17i, "S_BFu0ll_BFu17i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu17ll  {
  short v1;
  __tsu64  :0;
  __tsu64 v2:17;
};
//SIG(1 S_BFu0ll_BFu17ll) C1{ Fs FL:0 FL:17}



static void Test_S_BFu0ll_BFu17ll()
{
  {
    init_simple_test("S_BFu0ll_BFu17ll");
    static S_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "S_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "S_BFu0ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu17ll(Test_S_BFu0ll_BFu17ll, "S_BFu0ll_BFu17ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu1c  {
  short v1;
  __tsu64  :0;
  unsigned char v2:1;
};
//SIG(1 S_BFu0ll_BFu1c) C1{ Fs FL:0 Fc:1}



static void Test_S_BFu0ll_BFu1c()
{
  {
    init_simple_test("S_BFu0ll_BFu1c");
    static S_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(S_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "S_BFu0ll_BFu1c");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu1c(Test_S_BFu0ll_BFu1c, "S_BFu0ll_BFu1c", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu1i  {
  short v1;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 S_BFu0ll_BFu1i) C1{ Fs FL:0 Fi:1}



static void Test_S_BFu0ll_BFu1i()
{
  {
    init_simple_test("S_BFu0ll_BFu1i");
    static S_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu0ll_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "S_BFu0ll_BFu1i");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu1i(Test_S_BFu0ll_BFu1i, "S_BFu0ll_BFu1i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu1ll  {
  short v1;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 S_BFu0ll_BFu1ll) C1{ Fs FL:0 FL:1}



static void Test_S_BFu0ll_BFu1ll()
{
  {
    init_simple_test("S_BFu0ll_BFu1ll");
    static S_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "S_BFu0ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu1ll(Test_S_BFu0ll_BFu1ll, "S_BFu0ll_BFu1ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu1s  {
  short v1;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 S_BFu0ll_BFu1s) C1{ Fs FL:0 Fs:1}



static void Test_S_BFu0ll_BFu1s()
{
  {
    init_simple_test("S_BFu0ll_BFu1s");
    static S_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(S_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "S_BFu0ll_BFu1s");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu1s(Test_S_BFu0ll_BFu1s, "S_BFu0ll_BFu1s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu31i  {
  short v1;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 S_BFu0ll_BFu31i) C1{ Fs FL:0 Fi:31}



static void Test_S_BFu0ll_BFu31i()
{
  {
    init_simple_test("S_BFu0ll_BFu31i");
    static S_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu0ll_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "S_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "S_BFu0ll_BFu31i");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu31i(Test_S_BFu0ll_BFu31i, "S_BFu0ll_BFu31i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu31ll  {
  short v1;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 S_BFu0ll_BFu31ll) C1{ Fs FL:0 FL:31}



static void Test_S_BFu0ll_BFu31ll()
{
  {
    init_simple_test("S_BFu0ll_BFu31ll");
    static S_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "S_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "S_BFu0ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu31ll(Test_S_BFu0ll_BFu31ll, "S_BFu0ll_BFu31ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu32i  {
  short v1;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 S_BFu0ll_BFu32i) C1{ Fs FL:0 Fi:32}



static void Test_S_BFu0ll_BFu32i()
{
  {
    init_simple_test("S_BFu0ll_BFu32i");
    static S_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu0ll_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "S_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "S_BFu0ll_BFu32i");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu32i(Test_S_BFu0ll_BFu32i, "S_BFu0ll_BFu32i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu32ll  {
  short v1;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 S_BFu0ll_BFu32ll) C1{ Fs FL:0 FL:32}



static void Test_S_BFu0ll_BFu32ll()
{
  {
    init_simple_test("S_BFu0ll_BFu32ll");
    static S_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "S_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "S_BFu0ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu32ll(Test_S_BFu0ll_BFu32ll, "S_BFu0ll_BFu32ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu33  {
  short v1;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 S_BFu0ll_BFu33) C1{ Fs FL:0 FL:33}



static void Test_S_BFu0ll_BFu33()
{
  {
    init_simple_test("S_BFu0ll_BFu33");
    static S_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "S_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "S_BFu0ll_BFu33");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu33(Test_S_BFu0ll_BFu33, "S_BFu0ll_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu7c  {
  short v1;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 S_BFu0ll_BFu7c) C1{ Fs FL:0 Fc:7}



static void Test_S_BFu0ll_BFu7c()
{
  {
    init_simple_test("S_BFu0ll_BFu7c");
    static S_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(S_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "S_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "S_BFu0ll_BFu7c");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu7c(Test_S_BFu0ll_BFu7c, "S_BFu0ll_BFu7c", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu7i  {
  short v1;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 S_BFu0ll_BFu7i) C1{ Fs FL:0 Fi:7}



static void Test_S_BFu0ll_BFu7i()
{
  {
    init_simple_test("S_BFu0ll_BFu7i");
    static S_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu0ll_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "S_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "S_BFu0ll_BFu7i");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu7i(Test_S_BFu0ll_BFu7i, "S_BFu0ll_BFu7i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu7ll  {
  short v1;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 S_BFu0ll_BFu7ll) C1{ Fs FL:0 FL:7}



static void Test_S_BFu0ll_BFu7ll()
{
  {
    init_simple_test("S_BFu0ll_BFu7ll");
    static S_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "S_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "S_BFu0ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu7ll(Test_S_BFu0ll_BFu7ll, "S_BFu0ll_BFu7ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu7s  {
  short v1;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 S_BFu0ll_BFu7s) C1{ Fs FL:0 Fs:7}



static void Test_S_BFu0ll_BFu7s()
{
  {
    init_simple_test("S_BFu0ll_BFu7s");
    static S_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(S_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "S_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "S_BFu0ll_BFu7s");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu7s(Test_S_BFu0ll_BFu7s, "S_BFu0ll_BFu7s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu8c  {
  short v1;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 S_BFu0ll_BFu8c) C1{ Fs FL:0 Fc:8}



static void Test_S_BFu0ll_BFu8c()
{
  {
    init_simple_test("S_BFu0ll_BFu8c");
    static S_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(S_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "S_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "S_BFu0ll_BFu8c");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu8c(Test_S_BFu0ll_BFu8c, "S_BFu0ll_BFu8c", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu8i  {
  short v1;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 S_BFu0ll_BFu8i) C1{ Fs FL:0 Fi:8}



static void Test_S_BFu0ll_BFu8i()
{
  {
    init_simple_test("S_BFu0ll_BFu8i");
    static S_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu0ll_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "S_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "S_BFu0ll_BFu8i");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu8i(Test_S_BFu0ll_BFu8i, "S_BFu0ll_BFu8i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu8ll  {
  short v1;
  __tsu64  :0;
  __tsu64 v2:8;
};
//SIG(1 S_BFu0ll_BFu8ll) C1{ Fs FL:0 FL:8}



static void Test_S_BFu0ll_BFu8ll()
{
  {
    init_simple_test("S_BFu0ll_BFu8ll");
    static S_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "S_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "S_BFu0ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu8ll(Test_S_BFu0ll_BFu8ll, "S_BFu0ll_BFu8ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu8s  {
  short v1;
  __tsu64  :0;
  unsigned short v2:8;
};
//SIG(1 S_BFu0ll_BFu8s) C1{ Fs FL:0 Fs:8}



static void Test_S_BFu0ll_BFu8s()
{
  {
    init_simple_test("S_BFu0ll_BFu8s");
    static S_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(S_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "S_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "S_BFu0ll_BFu8s");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu8s(Test_S_BFu0ll_BFu8s, "S_BFu0ll_BFu8s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu9i  {
  short v1;
  __tsu64  :0;
  unsigned int v2:9;
};
//SIG(1 S_BFu0ll_BFu9i) C1{ Fs FL:0 Fi:9}



static void Test_S_BFu0ll_BFu9i()
{
  {
    init_simple_test("S_BFu0ll_BFu9i");
    static S_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu0ll_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "S_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "S_BFu0ll_BFu9i");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu9i(Test_S_BFu0ll_BFu9i, "S_BFu0ll_BFu9i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu9ll  {
  short v1;
  __tsu64  :0;
  __tsu64 v2:9;
};
//SIG(1 S_BFu0ll_BFu9ll) C1{ Fs FL:0 FL:9}



static void Test_S_BFu0ll_BFu9ll()
{
  {
    init_simple_test("S_BFu0ll_BFu9ll");
    static S_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "S_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "S_BFu0ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu9ll(Test_S_BFu0ll_BFu9ll, "S_BFu0ll_BFu9ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_BFu9s  {
  short v1;
  __tsu64  :0;
  unsigned short v2:9;
};
//SIG(1 S_BFu0ll_BFu9s) C1{ Fs FL:0 Fs:9}



static void Test_S_BFu0ll_BFu9s()
{
  {
    init_simple_test("S_BFu0ll_BFu9s");
    static S_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(S_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "S_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "S_BFu0ll_BFu9s");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_BFu9s(Test_S_BFu0ll_BFu9s, "S_BFu0ll_BFu9s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_C  {
  short v1;
  __tsu64  :0;
  char v2;
};
//SIG(1 S_BFu0ll_C) C1{ Fs FL:0 Fc}



static void Test_S_BFu0ll_C()
{
  {
    init_simple_test("S_BFu0ll_C");
    static S_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(S_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_C)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0ll_C.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_C(Test_S_BFu0ll_C, "S_BFu0ll_C", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_D  {
  short v1;
  __tsu64  :0;
  double v2;
};
//SIG(1 S_BFu0ll_D) C1{ Fs FL:0 FL}



static void Test_S_BFu0ll_D()
{
  {
    init_simple_test("S_BFu0ll_D");
    static S_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_D)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0ll_D.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_D(Test_S_BFu0ll_D, "S_BFu0ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_F  {
  short v1;
  __tsu64  :0;
  float v2;
};
//SIG(1 S_BFu0ll_F) C1{ Fs FL:0 Fi}



static void Test_S_BFu0ll_F()
{
  {
    init_simple_test("S_BFu0ll_F");
    static S_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu0ll_F)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0ll_F.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_F(Test_S_BFu0ll_F, "S_BFu0ll_F", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_I  {
  short v1;
  __tsu64  :0;
  int v2;
};
//SIG(1 S_BFu0ll_I) C1{ Fs FL:0 Fi}



static void Test_S_BFu0ll_I()
{
  {
    init_simple_test("S_BFu0ll_I");
    static S_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu0ll_I)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0ll_I.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_I(Test_S_BFu0ll_I, "S_BFu0ll_I", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_Ip  {
  short v1;
  __tsu64  :0;
  int *v2;
};
//SIG(1 S_BFu0ll_Ip) C1{ Fs FL:0 Fp}



static void Test_S_BFu0ll_Ip()
{
  {
    init_simple_test("S_BFu0ll_Ip");
    static S_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_Ip(Test_S_BFu0ll_Ip, "S_BFu0ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_L  {
  short v1;
  __tsu64  :0;
  __tsi64 v2;
};
//SIG(1 S_BFu0ll_L) C1{ Fs FL:0 FL}



static void Test_S_BFu0ll_L()
{
  {
    init_simple_test("S_BFu0ll_L");
    static S_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_L)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0ll_L.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_L(Test_S_BFu0ll_L, "S_BFu0ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_S  {
  short v1;
  __tsu64  :0;
  short v2;
};
//SIG(1 S_BFu0ll_S) C1{ Fs FL:0 Fs}



static void Test_S_BFu0ll_S()
{
  {
    init_simple_test("S_BFu0ll_S");
    static S_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(S_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_S)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0ll_S.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_S(Test_S_BFu0ll_S, "S_BFu0ll_S", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_Uc  {
  short v1;
  __tsu64  :0;
  unsigned char v2;
};
//SIG(1 S_BFu0ll_Uc) C1{ Fs FL:0 Fc}



static void Test_S_BFu0ll_Uc()
{
  {
    init_simple_test("S_BFu0ll_Uc");
    static S_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(S_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_Uc(Test_S_BFu0ll_Uc, "S_BFu0ll_Uc", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_Ui  {
  short v1;
  __tsu64  :0;
  unsigned int v2;
};
//SIG(1 S_BFu0ll_Ui) C1{ Fs FL:0 Fi}



static void Test_S_BFu0ll_Ui()
{
  {
    init_simple_test("S_BFu0ll_Ui");
    static S_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(S_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu0ll_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_Ui(Test_S_BFu0ll_Ui, "S_BFu0ll_Ui", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_Ul  {
  short v1;
  __tsu64  :0;
  __tsu64 v2;
};
//SIG(1 S_BFu0ll_Ul) C1{ Fs FL:0 FL}



static void Test_S_BFu0ll_Ul()
{
  {
    init_simple_test("S_BFu0ll_Ul");
    static S_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_Ul(Test_S_BFu0ll_Ul, "S_BFu0ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_Us  {
  short v1;
  __tsu64  :0;
  unsigned short v2;
};
//SIG(1 S_BFu0ll_Us) C1{ Fs FL:0 Fs}



static void Test_S_BFu0ll_Us()
{
  {
    init_simple_test("S_BFu0ll_Us");
    static S_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(S_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0ll_Us)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0ll_Us.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_Us(Test_S_BFu0ll_Us, "S_BFu0ll_Us", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0ll_Vp  {
  short v1;
  __tsu64  :0;
  void *v2;
};
//SIG(1 S_BFu0ll_Vp) C1{ Fs FL:0 Fp}



static void Test_S_BFu0ll_Vp()
{
  {
    init_simple_test("S_BFu0ll_Vp");
    static S_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0ll_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu0ll_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0ll_Vp(Test_S_BFu0ll_Vp, "S_BFu0ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s  {
  short v1;
  unsigned short  :0;
};
//SIG(1 S_BFu0s) C1{ Fs Fs:0}



static void Test_S_BFu0s()
{
  {
    init_simple_test("S_BFu0s");
    static S_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(S_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0s(Test_S_BFu0s, "S_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu0c  {
  short v1;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 S_BFu0s_BFu0c) C1{ Fs Fs:0 Fc:0}



static void Test_S_BFu0s_BFu0c()
{
  {
    init_simple_test("S_BFu0s_BFu0c");
    static S_BFu0s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(S_BFu0s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu0c(Test_S_BFu0s_BFu0c, "S_BFu0s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu0i  {
  short v1;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 S_BFu0s_BFu0i) C1{ Fs Fs:0 Fi:0}



static void Test_S_BFu0s_BFu0i()
{
  {
    init_simple_test("S_BFu0s_BFu0i");
    static S_BFu0s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0s_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu0i(Test_S_BFu0s_BFu0i, "S_BFu0s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu0ll  {
  short v1;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 S_BFu0s_BFu0ll) C1{ Fs Fs:0 FL:0}



static void Test_S_BFu0s_BFu0ll()
{
  {
    init_simple_test("S_BFu0s_BFu0ll");
    static S_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu0s_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu0ll(Test_S_BFu0s_BFu0ll, "S_BFu0s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu0s  {
  short v1;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 S_BFu0s_BFu0s) C1{ Fs Fs:0 Fs:0}



static void Test_S_BFu0s_BFu0s()
{
  {
    init_simple_test("S_BFu0s_BFu0s");
    static S_BFu0s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(S_BFu0s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu0s(Test_S_BFu0s_BFu0s, "S_BFu0s_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu15i  {
  short v1;
  unsigned short  :0;
  unsigned int v2:15;
};
//SIG(1 S_BFu0s_BFu15i) C1{ Fs Fs:0 Fi:15}



static void Test_S_BFu0s_BFu15i()
{
  {
    init_simple_test("S_BFu0s_BFu15i");
    static S_BFu0s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0s_BFu15i)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu0s_BFu15i");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu15i(Test_S_BFu0s_BFu15i, "S_BFu0s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu15ll  {
  short v1;
  unsigned short  :0;
  __tsu64 v2:15;
};
//SIG(1 S_BFu0s_BFu15ll) C1{ Fs Fs:0 FL:15}



static void Test_S_BFu0s_BFu15ll()
{
  {
    init_simple_test("S_BFu0s_BFu15ll");
    static S_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_BFu15ll)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu0s_BFu15ll");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu15ll(Test_S_BFu0s_BFu15ll, "S_BFu0s_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu15s  {
  short v1;
  unsigned short  :0;
  unsigned short v2:15;
};
//SIG(1 S_BFu0s_BFu15s) C1{ Fs Fs:0 Fs:15}



static void Test_S_BFu0s_BFu15s()
{
  {
    init_simple_test("S_BFu0s_BFu15s");
    static S_BFu0s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_BFu15s)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu0s_BFu15s");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu15s(Test_S_BFu0s_BFu15s, "S_BFu0s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu16i  {
  short v1;
  unsigned short  :0;
  unsigned int v2:16;
};
//SIG(1 S_BFu0s_BFu16i) C1{ Fs Fs:0 Fi:16}



static void Test_S_BFu0s_BFu16i()
{
  {
    init_simple_test("S_BFu0s_BFu16i");
    static S_BFu0s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0s_BFu16i)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu0s_BFu16i");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu16i(Test_S_BFu0s_BFu16i, "S_BFu0s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu16ll  {
  short v1;
  unsigned short  :0;
  __tsu64 v2:16;
};
//SIG(1 S_BFu0s_BFu16ll) C1{ Fs Fs:0 FL:16}



static void Test_S_BFu0s_BFu16ll()
{
  {
    init_simple_test("S_BFu0s_BFu16ll");
    static S_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_BFu16ll)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu0s_BFu16ll");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu16ll(Test_S_BFu0s_BFu16ll, "S_BFu0s_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu16s  {
  short v1;
  unsigned short  :0;
  unsigned short v2:16;
};
//SIG(1 S_BFu0s_BFu16s) C1{ Fs Fs:0 Fs:16}



static void Test_S_BFu0s_BFu16s()
{
  {
    init_simple_test("S_BFu0s_BFu16s");
    static S_BFu0s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_BFu16s)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu0s_BFu16s");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu16s(Test_S_BFu0s_BFu16s, "S_BFu0s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu17i  {
  short v1;
  unsigned short  :0;
  unsigned int v2:17;
};
//SIG(1 S_BFu0s_BFu17i) C1{ Fs Fs:0 Fi:17}



static void Test_S_BFu0s_BFu17i()
{
  {
    init_simple_test("S_BFu0s_BFu17i");
    static S_BFu0s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0s_BFu17i)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu0s_BFu17i");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu17i(Test_S_BFu0s_BFu17i, "S_BFu0s_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu17ll  {
  short v1;
  unsigned short  :0;
  __tsu64 v2:17;
};
//SIG(1 S_BFu0s_BFu17ll) C1{ Fs Fs:0 FL:17}



static void Test_S_BFu0s_BFu17ll()
{
  {
    init_simple_test("S_BFu0s_BFu17ll");
    static S_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_BFu17ll)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu0s_BFu17ll");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu17ll(Test_S_BFu0s_BFu17ll, "S_BFu0s_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu1c  {
  short v1;
  unsigned short  :0;
  unsigned char v2:1;
};
//SIG(1 S_BFu0s_BFu1c) C1{ Fs Fs:0 Fc:1}



static void Test_S_BFu0s_BFu1c()
{
  {
    init_simple_test("S_BFu0s_BFu1c");
    static S_BFu0s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_BFu1c)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu0s_BFu1c");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu1c(Test_S_BFu0s_BFu1c, "S_BFu0s_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu1i  {
  short v1;
  unsigned short  :0;
  unsigned int v2:1;
};
//SIG(1 S_BFu0s_BFu1i) C1{ Fs Fs:0 Fi:1}



static void Test_S_BFu0s_BFu1i()
{
  {
    init_simple_test("S_BFu0s_BFu1i");
    static S_BFu0s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0s_BFu1i)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu0s_BFu1i");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu1i(Test_S_BFu0s_BFu1i, "S_BFu0s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu1ll  {
  short v1;
  unsigned short  :0;
  __tsu64 v2:1;
};
//SIG(1 S_BFu0s_BFu1ll) C1{ Fs Fs:0 FL:1}



static void Test_S_BFu0s_BFu1ll()
{
  {
    init_simple_test("S_BFu0s_BFu1ll");
    static S_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_BFu1ll)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu0s_BFu1ll");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu1ll(Test_S_BFu0s_BFu1ll, "S_BFu0s_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu1s  {
  short v1;
  unsigned short  :0;
  unsigned short v2:1;
};
//SIG(1 S_BFu0s_BFu1s) C1{ Fs Fs:0 Fs:1}



static void Test_S_BFu0s_BFu1s()
{
  {
    init_simple_test("S_BFu0s_BFu1s");
    static S_BFu0s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_BFu1s)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu0s_BFu1s");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu1s(Test_S_BFu0s_BFu1s, "S_BFu0s_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu31i  {
  short v1;
  unsigned short  :0;
  unsigned int v2:31;
};
//SIG(1 S_BFu0s_BFu31i) C1{ Fs Fs:0 Fi:31}



static void Test_S_BFu0s_BFu31i()
{
  {
    init_simple_test("S_BFu0s_BFu31i");
    static S_BFu0s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0s_BFu31i)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu0s_BFu31i");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu31i(Test_S_BFu0s_BFu31i, "S_BFu0s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu31ll  {
  short v1;
  unsigned short  :0;
  __tsu64 v2:31;
};
//SIG(1 S_BFu0s_BFu31ll) C1{ Fs Fs:0 FL:31}



static void Test_S_BFu0s_BFu31ll()
{
  {
    init_simple_test("S_BFu0s_BFu31ll");
    static S_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_BFu31ll)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu0s_BFu31ll");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu31ll(Test_S_BFu0s_BFu31ll, "S_BFu0s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu32i  {
  short v1;
  unsigned short  :0;
  unsigned int v2:32;
};
//SIG(1 S_BFu0s_BFu32i) C1{ Fs Fs:0 Fi:32}



static void Test_S_BFu0s_BFu32i()
{
  {
    init_simple_test("S_BFu0s_BFu32i");
    static S_BFu0s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0s_BFu32i)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu0s_BFu32i");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu32i(Test_S_BFu0s_BFu32i, "S_BFu0s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu32ll  {
  short v1;
  unsigned short  :0;
  __tsu64 v2:32;
};
//SIG(1 S_BFu0s_BFu32ll) C1{ Fs Fs:0 FL:32}



static void Test_S_BFu0s_BFu32ll()
{
  {
    init_simple_test("S_BFu0s_BFu32ll");
    static S_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_BFu32ll)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu0s_BFu32ll");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu32ll(Test_S_BFu0s_BFu32ll, "S_BFu0s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu33  {
  short v1;
  unsigned short  :0;
  __tsu64 v2:33;
};
//SIG(1 S_BFu0s_BFu33) C1{ Fs Fs:0 FL:33}



static void Test_S_BFu0s_BFu33()
{
  {
    init_simple_test("S_BFu0s_BFu33");
    static S_BFu0s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_BFu33)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu0s_BFu33");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu33(Test_S_BFu0s_BFu33, "S_BFu0s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu7c  {
  short v1;
  unsigned short  :0;
  unsigned char v2:7;
};
//SIG(1 S_BFu0s_BFu7c) C1{ Fs Fs:0 Fc:7}



static void Test_S_BFu0s_BFu7c()
{
  {
    init_simple_test("S_BFu0s_BFu7c");
    static S_BFu0s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_BFu7c)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu0s_BFu7c");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu7c(Test_S_BFu0s_BFu7c, "S_BFu0s_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu7i  {
  short v1;
  unsigned short  :0;
  unsigned int v2:7;
};
//SIG(1 S_BFu0s_BFu7i) C1{ Fs Fs:0 Fi:7}



static void Test_S_BFu0s_BFu7i()
{
  {
    init_simple_test("S_BFu0s_BFu7i");
    static S_BFu0s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0s_BFu7i)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu0s_BFu7i");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu7i(Test_S_BFu0s_BFu7i, "S_BFu0s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu7ll  {
  short v1;
  unsigned short  :0;
  __tsu64 v2:7;
};
//SIG(1 S_BFu0s_BFu7ll) C1{ Fs Fs:0 FL:7}



static void Test_S_BFu0s_BFu7ll()
{
  {
    init_simple_test("S_BFu0s_BFu7ll");
    static S_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_BFu7ll)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu0s_BFu7ll");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu7ll(Test_S_BFu0s_BFu7ll, "S_BFu0s_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu7s  {
  short v1;
  unsigned short  :0;
  unsigned short v2:7;
};
//SIG(1 S_BFu0s_BFu7s) C1{ Fs Fs:0 Fs:7}



static void Test_S_BFu0s_BFu7s()
{
  {
    init_simple_test("S_BFu0s_BFu7s");
    static S_BFu0s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_BFu7s)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu0s_BFu7s");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu7s(Test_S_BFu0s_BFu7s, "S_BFu0s_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu8c  {
  short v1;
  unsigned short  :0;
  unsigned char v2:8;
};
//SIG(1 S_BFu0s_BFu8c) C1{ Fs Fs:0 Fc:8}



static void Test_S_BFu0s_BFu8c()
{
  {
    init_simple_test("S_BFu0s_BFu8c");
    static S_BFu0s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_BFu8c)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu0s_BFu8c");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu8c(Test_S_BFu0s_BFu8c, "S_BFu0s_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu8i  {
  short v1;
  unsigned short  :0;
  unsigned int v2:8;
};
//SIG(1 S_BFu0s_BFu8i) C1{ Fs Fs:0 Fi:8}



static void Test_S_BFu0s_BFu8i()
{
  {
    init_simple_test("S_BFu0s_BFu8i");
    static S_BFu0s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0s_BFu8i)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu0s_BFu8i");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu8i(Test_S_BFu0s_BFu8i, "S_BFu0s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu8ll  {
  short v1;
  unsigned short  :0;
  __tsu64 v2:8;
};
//SIG(1 S_BFu0s_BFu8ll) C1{ Fs Fs:0 FL:8}



static void Test_S_BFu0s_BFu8ll()
{
  {
    init_simple_test("S_BFu0s_BFu8ll");
    static S_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_BFu8ll)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu0s_BFu8ll");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu8ll(Test_S_BFu0s_BFu8ll, "S_BFu0s_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu8s  {
  short v1;
  unsigned short  :0;
  unsigned short v2:8;
};
//SIG(1 S_BFu0s_BFu8s) C1{ Fs Fs:0 Fs:8}



static void Test_S_BFu0s_BFu8s()
{
  {
    init_simple_test("S_BFu0s_BFu8s");
    static S_BFu0s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_BFu8s)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu0s_BFu8s");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu8s(Test_S_BFu0s_BFu8s, "S_BFu0s_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu9i  {
  short v1;
  unsigned short  :0;
  unsigned int v2:9;
};
//SIG(1 S_BFu0s_BFu9i) C1{ Fs Fs:0 Fi:9}



static void Test_S_BFu0s_BFu9i()
{
  {
    init_simple_test("S_BFu0s_BFu9i");
    static S_BFu0s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0s_BFu9i)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu0s_BFu9i");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu9i(Test_S_BFu0s_BFu9i, "S_BFu0s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu9ll  {
  short v1;
  unsigned short  :0;
  __tsu64 v2:9;
};
//SIG(1 S_BFu0s_BFu9ll) C1{ Fs Fs:0 FL:9}



static void Test_S_BFu0s_BFu9ll()
{
  {
    init_simple_test("S_BFu0s_BFu9ll");
    static S_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_BFu9ll)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu0s_BFu9ll");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu9ll(Test_S_BFu0s_BFu9ll, "S_BFu0s_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_BFu9s  {
  short v1;
  unsigned short  :0;
  unsigned short v2:9;
};
//SIG(1 S_BFu0s_BFu9s) C1{ Fs Fs:0 Fs:9}



static void Test_S_BFu0s_BFu9s()
{
  {
    init_simple_test("S_BFu0s_BFu9s");
    static S_BFu0s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_BFu9s)");
    check_field_offset(lv, v1, 0, "S_BFu0s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu0s_BFu9s");
  }
}
static Arrange_To_Call_Me vS_BFu0s_BFu9s(Test_S_BFu0s_BFu9s, "S_BFu0s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_C  {
  short v1;
  unsigned short  :0;
  char v2;
};
//SIG(1 S_BFu0s_C) C1{ Fs Fs:0 Fc}



static void Test_S_BFu0s_C()
{
  {
    init_simple_test("S_BFu0s_C");
    static S_BFu0s_C lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_C)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_C)");
    check_field_offset(lv, v1, 0, "S_BFu0s_C.v1");
    check_field_offset(lv, v2, 2, "S_BFu0s_C.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0s_C(Test_S_BFu0s_C, "S_BFu0s_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_D  {
  short v1;
  unsigned short  :0;
  double v2;
};
//SIG(1 S_BFu0s_D) C1{ Fs Fs:0 FL}



static void Test_S_BFu0s_D()
{
  {
    init_simple_test("S_BFu0s_D");
    static S_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_D)");
    check_field_offset(lv, v1, 0, "S_BFu0s_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0s_D.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0s_D(Test_S_BFu0s_D, "S_BFu0s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_F  {
  short v1;
  unsigned short  :0;
  float v2;
};
//SIG(1 S_BFu0s_F) C1{ Fs Fs:0 Fi}



static void Test_S_BFu0s_F()
{
  {
    init_simple_test("S_BFu0s_F");
    static S_BFu0s_F lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0s_F)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0s_F)");
    check_field_offset(lv, v1, 0, "S_BFu0s_F.v1");
    check_field_offset(lv, v2, 4, "S_BFu0s_F.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0s_F(Test_S_BFu0s_F, "S_BFu0s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_I  {
  short v1;
  unsigned short  :0;
  int v2;
};
//SIG(1 S_BFu0s_I) C1{ Fs Fs:0 Fi}



static void Test_S_BFu0s_I()
{
  {
    init_simple_test("S_BFu0s_I");
    static S_BFu0s_I lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0s_I)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0s_I)");
    check_field_offset(lv, v1, 0, "S_BFu0s_I.v1");
    check_field_offset(lv, v2, 4, "S_BFu0s_I.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0s_I(Test_S_BFu0s_I, "S_BFu0s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_Ip  {
  short v1;
  unsigned short  :0;
  int *v2;
};
//SIG(1 S_BFu0s_Ip) C1{ Fs Fs:0 Fp}



static void Test_S_BFu0s_Ip()
{
  {
    init_simple_test("S_BFu0s_Ip");
    static S_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_Ip)");
    check_field_offset(lv, v1, 0, "S_BFu0s_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0s_Ip.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0s_Ip(Test_S_BFu0s_Ip, "S_BFu0s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_L  {
  short v1;
  unsigned short  :0;
  __tsi64 v2;
};
//SIG(1 S_BFu0s_L) C1{ Fs Fs:0 FL}



static void Test_S_BFu0s_L()
{
  {
    init_simple_test("S_BFu0s_L");
    static S_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_L)");
    check_field_offset(lv, v1, 0, "S_BFu0s_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0s_L.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0s_L(Test_S_BFu0s_L, "S_BFu0s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_S  {
  short v1;
  unsigned short  :0;
  short v2;
};
//SIG(1 S_BFu0s_S) C1{ Fs Fs:0 Fs}



static void Test_S_BFu0s_S()
{
  {
    init_simple_test("S_BFu0s_S");
    static S_BFu0s_S lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_S)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_S)");
    check_field_offset(lv, v1, 0, "S_BFu0s_S.v1");
    check_field_offset(lv, v2, 2, "S_BFu0s_S.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0s_S(Test_S_BFu0s_S, "S_BFu0s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_Uc  {
  short v1;
  unsigned short  :0;
  unsigned char v2;
};
//SIG(1 S_BFu0s_Uc) C1{ Fs Fs:0 Fc}



static void Test_S_BFu0s_Uc()
{
  {
    init_simple_test("S_BFu0s_Uc");
    static S_BFu0s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_Uc)");
    check_field_offset(lv, v1, 0, "S_BFu0s_Uc.v1");
    check_field_offset(lv, v2, 2, "S_BFu0s_Uc.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0s_Uc(Test_S_BFu0s_Uc, "S_BFu0s_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_Ui  {
  short v1;
  unsigned short  :0;
  unsigned int v2;
};
//SIG(1 S_BFu0s_Ui) C1{ Fs Fs:0 Fi}



static void Test_S_BFu0s_Ui()
{
  {
    init_simple_test("S_BFu0s_Ui");
    static S_BFu0s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu0s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu0s_Ui)");
    check_field_offset(lv, v1, 0, "S_BFu0s_Ui.v1");
    check_field_offset(lv, v2, 4, "S_BFu0s_Ui.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0s_Ui(Test_S_BFu0s_Ui, "S_BFu0s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_Ul  {
  short v1;
  unsigned short  :0;
  __tsu64 v2;
};
//SIG(1 S_BFu0s_Ul) C1{ Fs Fs:0 FL}



static void Test_S_BFu0s_Ul()
{
  {
    init_simple_test("S_BFu0s_Ul");
    static S_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_Ul)");
    check_field_offset(lv, v1, 0, "S_BFu0s_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0s_Ul.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0s_Ul(Test_S_BFu0s_Ul, "S_BFu0s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_Us  {
  short v1;
  unsigned short  :0;
  unsigned short v2;
};
//SIG(1 S_BFu0s_Us) C1{ Fs Fs:0 Fs}



static void Test_S_BFu0s_Us()
{
  {
    init_simple_test("S_BFu0s_Us");
    static S_BFu0s_Us lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu0s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu0s_Us)");
    check_field_offset(lv, v1, 0, "S_BFu0s_Us.v1");
    check_field_offset(lv, v2, 2, "S_BFu0s_Us.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0s_Us(Test_S_BFu0s_Us, "S_BFu0s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu0s_Vp  {
  short v1;
  unsigned short  :0;
  void *v2;
};
//SIG(1 S_BFu0s_Vp) C1{ Fs Fs:0 Fp}



static void Test_S_BFu0s_Vp()
{
  {
    init_simple_test("S_BFu0s_Vp");
    static S_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu0s_Vp)");
    check_field_offset(lv, v1, 0, "S_BFu0s_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_BFu0s_Vp.v2");
  }
}
static Arrange_To_Call_Me vS_BFu0s_Vp(Test_S_BFu0s_Vp, "S_BFu0s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu15i_BFu0c  {
  short v1;
  unsigned int v2:15;
  unsigned char  :0;
};
//SIG(1 S_BFu15i_BFu0c) C1{ Fs Fi:15 Fc:0}



static void Test_S_BFu15i_BFu0c()
{
  {
    init_simple_test("S_BFu15i_BFu0c");
    static S_BFu15i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu15i_BFu0c(Test_S_BFu15i_BFu0c, "S_BFu15i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu15i_BFu0i  {
  short v1;
  unsigned int v2:15;
  unsigned int  :0;
};
//SIG(1 S_BFu15i_BFu0i) C1{ Fs Fi:15 Fi:0}



static void Test_S_BFu15i_BFu0i()
{
  {
    init_simple_test("S_BFu15i_BFu0i");
    static S_BFu15i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu15i_BFu0i(Test_S_BFu15i_BFu0i, "S_BFu15i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu15i_BFu0ll  {
  short v1;
  unsigned int v2:15;
  __tsu64  :0;
};
//SIG(1 S_BFu15i_BFu0ll) C1{ Fs Fi:15 FL:0}



static void Test_S_BFu15i_BFu0ll()
{
  {
    init_simple_test("S_BFu15i_BFu0ll");
    static S_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu15i_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu15i_BFu0ll(Test_S_BFu15i_BFu0ll, "S_BFu15i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu15i_BFu0s  {
  short v1;
  unsigned int v2:15;
  unsigned short  :0;
};
//SIG(1 S_BFu15i_BFu0s) C1{ Fs Fi:15 Fs:0}



static void Test_S_BFu15i_BFu0s()
{
  {
    init_simple_test("S_BFu15i_BFu0s");
    static S_BFu15i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu15i_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu15i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15i_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu15i_BFu0s(Test_S_BFu15i_BFu0s, "S_BFu15i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu15ll_BFu0c  {
  short v1;
  __tsu64 v2:15;
  unsigned char  :0;
};
//SIG(1 S_BFu15ll_BFu0c) C1{ Fs FL:15 Fc:0}



static void Test_S_BFu15ll_BFu0c()
{
  {
    init_simple_test("S_BFu15ll_BFu0c");
    static S_BFu15ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu15ll_BFu0c(Test_S_BFu15ll_BFu0c, "S_BFu15ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu15ll_BFu0i  {
  short v1;
  __tsu64 v2:15;
  unsigned int  :0;
};
//SIG(1 S_BFu15ll_BFu0i) C1{ Fs FL:15 Fi:0}



static void Test_S_BFu15ll_BFu0i()
{
  {
    init_simple_test("S_BFu15ll_BFu0i");
    static S_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu15ll_BFu0i(Test_S_BFu15ll_BFu0i, "S_BFu15ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu15ll_BFu0ll  {
  short v1;
  __tsu64 v2:15;
  __tsu64  :0;
};
//SIG(1 S_BFu15ll_BFu0ll) C1{ Fs FL:15 FL:0}



static void Test_S_BFu15ll_BFu0ll()
{
  {
    init_simple_test("S_BFu15ll_BFu0ll");
    static S_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu15ll_BFu0ll(Test_S_BFu15ll_BFu0ll, "S_BFu15ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu15ll_BFu0s  {
  short v1;
  __tsu64 v2:15;
  unsigned short  :0;
};
//SIG(1 S_BFu15ll_BFu0s) C1{ Fs FL:15 Fs:0}



static void Test_S_BFu15ll_BFu0s()
{
  {
    init_simple_test("S_BFu15ll_BFu0s");
    static S_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu15ll_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu15ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15ll_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu15ll_BFu0s(Test_S_BFu15ll_BFu0s, "S_BFu15ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu15s_BFu0c  {
  short v1;
  unsigned short v2:15;
  unsigned char  :0;
};
//SIG(1 S_BFu15s_BFu0c) C1{ Fs Fs:15 Fc:0}



static void Test_S_BFu15s_BFu0c()
{
  {
    init_simple_test("S_BFu15s_BFu0c");
    static S_BFu15s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu15s_BFu0c(Test_S_BFu15s_BFu0c, "S_BFu15s_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu15s_BFu0i  {
  short v1;
  unsigned short v2:15;
  unsigned int  :0;
};
//SIG(1 S_BFu15s_BFu0i) C1{ Fs Fs:15 Fi:0}



static void Test_S_BFu15s_BFu0i()
{
  {
    init_simple_test("S_BFu15s_BFu0i");
    static S_BFu15s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu15s_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu15s_BFu0i(Test_S_BFu15s_BFu0i, "S_BFu15s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu15s_BFu0ll  {
  short v1;
  unsigned short v2:15;
  __tsu64  :0;
};
//SIG(1 S_BFu15s_BFu0ll) C1{ Fs Fs:15 FL:0}



static void Test_S_BFu15s_BFu0ll()
{
  {
    init_simple_test("S_BFu15s_BFu0ll");
    static S_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu15s_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu15s_BFu0ll(Test_S_BFu15s_BFu0ll, "S_BFu15s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu15s_BFu0s  {
  short v1;
  unsigned short v2:15;
  unsigned short  :0;
};
//SIG(1 S_BFu15s_BFu0s) C1{ Fs Fs:15 Fs:0}



static void Test_S_BFu15s_BFu0s()
{
  {
    init_simple_test("S_BFu15s_BFu0s");
    static S_BFu15s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu15s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu15s_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu15s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "S_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "S_BFu15s_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu15s_BFu0s(Test_S_BFu15s_BFu0s, "S_BFu15s_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu16i_BFu0c  {
  short v1;
  unsigned int v2:16;
  unsigned char  :0;
};
//SIG(1 S_BFu16i_BFu0c) C1{ Fs Fi:16 Fc:0}



static void Test_S_BFu16i_BFu0c()
{
  {
    init_simple_test("S_BFu16i_BFu0c");
    static S_BFu16i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu16i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu16i_BFu0c(Test_S_BFu16i_BFu0c, "S_BFu16i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu16i_BFu0i  {
  short v1;
  unsigned int v2:16;
  unsigned int  :0;
};
//SIG(1 S_BFu16i_BFu0i) C1{ Fs Fi:16 Fi:0}



static void Test_S_BFu16i_BFu0i()
{
  {
    init_simple_test("S_BFu16i_BFu0i");
    static S_BFu16i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu16i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu16i_BFu0i(Test_S_BFu16i_BFu0i, "S_BFu16i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu16i_BFu0ll  {
  short v1;
  unsigned int v2:16;
  __tsu64  :0;
};
//SIG(1 S_BFu16i_BFu0ll) C1{ Fs Fi:16 FL:0}



static void Test_S_BFu16i_BFu0ll()
{
  {
    init_simple_test("S_BFu16i_BFu0ll");
    static S_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu16i_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu16i_BFu0ll(Test_S_BFu16i_BFu0ll, "S_BFu16i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu16i_BFu0s  {
  short v1;
  unsigned int v2:16;
  unsigned short  :0;
};
//SIG(1 S_BFu16i_BFu0s) C1{ Fs Fi:16 Fs:0}



static void Test_S_BFu16i_BFu0s()
{
  {
    init_simple_test("S_BFu16i_BFu0s");
    static S_BFu16i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu16i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu16i_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu16i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16i_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu16i_BFu0s(Test_S_BFu16i_BFu0s, "S_BFu16i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu16ll_BFu0c  {
  short v1;
  __tsu64 v2:16;
  unsigned char  :0;
};
//SIG(1 S_BFu16ll_BFu0c) C1{ Fs FL:16 Fc:0}



static void Test_S_BFu16ll_BFu0c()
{
  {
    init_simple_test("S_BFu16ll_BFu0c");
    static S_BFu16ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu16ll_BFu0c(Test_S_BFu16ll_BFu0c, "S_BFu16ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu16ll_BFu0i  {
  short v1;
  __tsu64 v2:16;
  unsigned int  :0;
};
//SIG(1 S_BFu16ll_BFu0i) C1{ Fs FL:16 Fi:0}



static void Test_S_BFu16ll_BFu0i()
{
  {
    init_simple_test("S_BFu16ll_BFu0i");
    static S_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu16ll_BFu0i(Test_S_BFu16ll_BFu0i, "S_BFu16ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu16ll_BFu0ll  {
  short v1;
  __tsu64 v2:16;
  __tsu64  :0;
};
//SIG(1 S_BFu16ll_BFu0ll) C1{ Fs FL:16 FL:0}



static void Test_S_BFu16ll_BFu0ll()
{
  {
    init_simple_test("S_BFu16ll_BFu0ll");
    static S_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu16ll_BFu0ll(Test_S_BFu16ll_BFu0ll, "S_BFu16ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu16ll_BFu0s  {
  short v1;
  __tsu64 v2:16;
  unsigned short  :0;
};
//SIG(1 S_BFu16ll_BFu0s) C1{ Fs FL:16 Fs:0}



static void Test_S_BFu16ll_BFu0s()
{
  {
    init_simple_test("S_BFu16ll_BFu0s");
    static S_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu16ll_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu16ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16ll_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu16ll_BFu0s(Test_S_BFu16ll_BFu0s, "S_BFu16ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu16s_BFu0c  {
  short v1;
  unsigned short v2:16;
  unsigned char  :0;
};
//SIG(1 S_BFu16s_BFu0c) C1{ Fs Fs:16 Fc:0}



static void Test_S_BFu16s_BFu0c()
{
  {
    init_simple_test("S_BFu16s_BFu0c");
    static S_BFu16s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu16s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu16s_BFu0c(Test_S_BFu16s_BFu0c, "S_BFu16s_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu16s_BFu0i  {
  short v1;
  unsigned short v2:16;
  unsigned int  :0;
};
//SIG(1 S_BFu16s_BFu0i) C1{ Fs Fs:16 Fi:0}



static void Test_S_BFu16s_BFu0i()
{
  {
    init_simple_test("S_BFu16s_BFu0i");
    static S_BFu16s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu16s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu16s_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu16s_BFu0i(Test_S_BFu16s_BFu0i, "S_BFu16s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu16s_BFu0ll  {
  short v1;
  unsigned short v2:16;
  __tsu64  :0;
};
//SIG(1 S_BFu16s_BFu0ll) C1{ Fs Fs:16 FL:0}



static void Test_S_BFu16s_BFu0ll()
{
  {
    init_simple_test("S_BFu16s_BFu0ll");
    static S_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu16s_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu16s_BFu0ll(Test_S_BFu16s_BFu0ll, "S_BFu16s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu16s_BFu0s  {
  short v1;
  unsigned short v2:16;
  unsigned short  :0;
};
//SIG(1 S_BFu16s_BFu0s) C1{ Fs Fs:16 Fs:0}



static void Test_S_BFu16s_BFu0s()
{
  {
    init_simple_test("S_BFu16s_BFu0s");
    static S_BFu16s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu16s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu16s_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu16s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "S_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "S_BFu16s_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu16s_BFu0s(Test_S_BFu16s_BFu0s, "S_BFu16s_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu17i_BFu0c  {
  short v1;
  unsigned int v2:17;
  unsigned char  :0;
};
//SIG(1 S_BFu17i_BFu0c) C1{ Fs Fi:17 Fc:0}



static void Test_S_BFu17i_BFu0c()
{
  {
    init_simple_test("S_BFu17i_BFu0c");
    static S_BFu17i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu17i_BFu0c(Test_S_BFu17i_BFu0c, "S_BFu17i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu17i_BFu0i  {
  short v1;
  unsigned int v2:17;
  unsigned int  :0;
};
//SIG(1 S_BFu17i_BFu0i) C1{ Fs Fi:17 Fi:0}



static void Test_S_BFu17i_BFu0i()
{
  {
    init_simple_test("S_BFu17i_BFu0i");
    static S_BFu17i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu17i_BFu0i(Test_S_BFu17i_BFu0i, "S_BFu17i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu17i_BFu0ll  {
  short v1;
  unsigned int v2:17;
  __tsu64  :0;
};
//SIG(1 S_BFu17i_BFu0ll) C1{ Fs Fi:17 FL:0}



static void Test_S_BFu17i_BFu0ll()
{
  {
    init_simple_test("S_BFu17i_BFu0ll");
    static S_BFu17i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu17i_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu17i_BFu0ll(Test_S_BFu17i_BFu0ll, "S_BFu17i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu17i_BFu0s  {
  short v1;
  unsigned int v2:17;
  unsigned short  :0;
};
//SIG(1 S_BFu17i_BFu0s) C1{ Fs Fi:17 Fs:0}



static void Test_S_BFu17i_BFu0s()
{
  {
    init_simple_test("S_BFu17i_BFu0s");
    static S_BFu17i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu17i_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu17i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "S_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "S_BFu17i_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu17i_BFu0s(Test_S_BFu17i_BFu0s, "S_BFu17i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu17ll_BFu0c  {
  short v1;
  __tsu64 v2:17;
  unsigned char  :0;
};
//SIG(1 S_BFu17ll_BFu0c) C1{ Fs FL:17 Fc:0}



static void Test_S_BFu17ll_BFu0c()
{
  {
    init_simple_test("S_BFu17ll_BFu0c");
    static S_BFu17ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu17ll_BFu0c(Test_S_BFu17ll_BFu0c, "S_BFu17ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu17ll_BFu0i  {
  short v1;
  __tsu64 v2:17;
  unsigned int  :0;
};
//SIG(1 S_BFu17ll_BFu0i) C1{ Fs FL:17 Fi:0}



static void Test_S_BFu17ll_BFu0i()
{
  {
    init_simple_test("S_BFu17ll_BFu0i");
    static S_BFu17ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu17ll_BFu0i(Test_S_BFu17ll_BFu0i, "S_BFu17ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu17ll_BFu0ll  {
  short v1;
  __tsu64 v2:17;
  __tsu64  :0;
};
//SIG(1 S_BFu17ll_BFu0ll) C1{ Fs FL:17 FL:0}



static void Test_S_BFu17ll_BFu0ll()
{
  {
    init_simple_test("S_BFu17ll_BFu0ll");
    static S_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu17ll_BFu0ll(Test_S_BFu17ll_BFu0ll, "S_BFu17ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu17ll_BFu0s  {
  short v1;
  __tsu64 v2:17;
  unsigned short  :0;
};
//SIG(1 S_BFu17ll_BFu0s) C1{ Fs FL:17 Fs:0}



static void Test_S_BFu17ll_BFu0s()
{
  {
    init_simple_test("S_BFu17ll_BFu0s");
    static S_BFu17ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu17ll_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu17ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "S_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "S_BFu17ll_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu17ll_BFu0s(Test_S_BFu17ll_BFu0s, "S_BFu17ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1c_BFu0c  {
  short v1;
  unsigned char v2:1;
  unsigned char  :0;
};
//SIG(1 S_BFu1c_BFu0c) C1{ Fs Fc:1 Fc:0}



static void Test_S_BFu1c_BFu0c()
{
  {
    init_simple_test("S_BFu1c_BFu0c");
    static S_BFu1c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu1c_BFu0c(Test_S_BFu1c_BFu0c, "S_BFu1c_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1c_BFu0i  {
  short v1;
  unsigned char v2:1;
  unsigned int  :0;
};
//SIG(1 S_BFu1c_BFu0i) C1{ Fs Fc:1 Fi:0}



static void Test_S_BFu1c_BFu0i()
{
  {
    init_simple_test("S_BFu1c_BFu0i");
    static S_BFu1c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu1c_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu1c_BFu0i(Test_S_BFu1c_BFu0i, "S_BFu1c_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1c_BFu0ll  {
  short v1;
  unsigned char v2:1;
  __tsu64  :0;
};
//SIG(1 S_BFu1c_BFu0ll) C1{ Fs Fc:1 FL:0}



static void Test_S_BFu1c_BFu0ll()
{
  {
    init_simple_test("S_BFu1c_BFu0ll");
    static S_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu1c_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu1c_BFu0ll(Test_S_BFu1c_BFu0ll, "S_BFu1c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1c_BFu0s  {
  short v1;
  unsigned char v2:1;
  unsigned short  :0;
};
//SIG(1 S_BFu1c_BFu0s) C1{ Fs Fc:1 Fs:0}



static void Test_S_BFu1c_BFu0s()
{
  {
    init_simple_test("S_BFu1c_BFu0s");
    static S_BFu1c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1c_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1c_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu1c_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1c_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu1c_BFu0s(Test_S_BFu1c_BFu0s, "S_BFu1c_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1i_BFu0c  {
  short v1;
  unsigned int v2:1;
  unsigned char  :0;
};
//SIG(1 S_BFu1i_BFu0c) C1{ Fs Fi:1 Fc:0}



static void Test_S_BFu1i_BFu0c()
{
  {
    init_simple_test("S_BFu1i_BFu0c");
    static S_BFu1i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu1i_BFu0c(Test_S_BFu1i_BFu0c, "S_BFu1i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1i_BFu0i  {
  short v1;
  unsigned int v2:1;
  unsigned int  :0;
};
//SIG(1 S_BFu1i_BFu0i) C1{ Fs Fi:1 Fi:0}



static void Test_S_BFu1i_BFu0i()
{
  {
    init_simple_test("S_BFu1i_BFu0i");
    static S_BFu1i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu1i_BFu0i(Test_S_BFu1i_BFu0i, "S_BFu1i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1i_BFu0ll  {
  short v1;
  unsigned int v2:1;
  __tsu64  :0;
};
//SIG(1 S_BFu1i_BFu0ll) C1{ Fs Fi:1 FL:0}



static void Test_S_BFu1i_BFu0ll()
{
  {
    init_simple_test("S_BFu1i_BFu0ll");
    static S_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu1i_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu1i_BFu0ll(Test_S_BFu1i_BFu0ll, "S_BFu1i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1i_BFu0s  {
  short v1;
  unsigned int v2:1;
  unsigned short  :0;
};
//SIG(1 S_BFu1i_BFu0s) C1{ Fs Fi:1 Fs:0}



static void Test_S_BFu1i_BFu0s()
{
  {
    init_simple_test("S_BFu1i_BFu0s");
    static S_BFu1i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu1i_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu1i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1i_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu1i_BFu0s(Test_S_BFu1i_BFu0s, "S_BFu1i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1ll_BFu0c  {
  short v1;
  __tsu64 v2:1;
  unsigned char  :0;
};
//SIG(1 S_BFu1ll_BFu0c) C1{ Fs FL:1 Fc:0}



static void Test_S_BFu1ll_BFu0c()
{
  {
    init_simple_test("S_BFu1ll_BFu0c");
    static S_BFu1ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu1ll_BFu0c(Test_S_BFu1ll_BFu0c, "S_BFu1ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1ll_BFu0i  {
  short v1;
  __tsu64 v2:1;
  unsigned int  :0;
};
//SIG(1 S_BFu1ll_BFu0i) C1{ Fs FL:1 Fi:0}



static void Test_S_BFu1ll_BFu0i()
{
  {
    init_simple_test("S_BFu1ll_BFu0i");
    static S_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu1ll_BFu0i(Test_S_BFu1ll_BFu0i, "S_BFu1ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1ll_BFu0ll  {
  short v1;
  __tsu64 v2:1;
  __tsu64  :0;
};
//SIG(1 S_BFu1ll_BFu0ll) C1{ Fs FL:1 FL:0}



static void Test_S_BFu1ll_BFu0ll()
{
  {
    init_simple_test("S_BFu1ll_BFu0ll");
    static S_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu1ll_BFu0ll(Test_S_BFu1ll_BFu0ll, "S_BFu1ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1ll_BFu0s  {
  short v1;
  __tsu64 v2:1;
  unsigned short  :0;
};
//SIG(1 S_BFu1ll_BFu0s) C1{ Fs FL:1 Fs:0}



static void Test_S_BFu1ll_BFu0s()
{
  {
    init_simple_test("S_BFu1ll_BFu0s");
    static S_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu1ll_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu1ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1ll_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu1ll_BFu0s(Test_S_BFu1ll_BFu0s, "S_BFu1ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1s_BFu0c  {
  short v1;
  unsigned short v2:1;
  unsigned char  :0;
};
//SIG(1 S_BFu1s_BFu0c) C1{ Fs Fs:1 Fc:0}



static void Test_S_BFu1s_BFu0c()
{
  {
    init_simple_test("S_BFu1s_BFu0c");
    static S_BFu1s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu1s_BFu0c(Test_S_BFu1s_BFu0c, "S_BFu1s_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1s_BFu0i  {
  short v1;
  unsigned short v2:1;
  unsigned int  :0;
};
//SIG(1 S_BFu1s_BFu0i) C1{ Fs Fs:1 Fi:0}



static void Test_S_BFu1s_BFu0i()
{
  {
    init_simple_test("S_BFu1s_BFu0i");
    static S_BFu1s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu1s_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu1s_BFu0i(Test_S_BFu1s_BFu0i, "S_BFu1s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1s_BFu0ll  {
  short v1;
  unsigned short v2:1;
  __tsu64  :0;
};
//SIG(1 S_BFu1s_BFu0ll) C1{ Fs Fs:1 FL:0}



static void Test_S_BFu1s_BFu0ll()
{
  {
    init_simple_test("S_BFu1s_BFu0ll");
    static S_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu1s_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu1s_BFu0ll(Test_S_BFu1s_BFu0ll, "S_BFu1s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu1s_BFu0s  {
  short v1;
  unsigned short v2:1;
  unsigned short  :0;
};
//SIG(1 S_BFu1s_BFu0s) C1{ Fs Fs:1 Fs:0}



static void Test_S_BFu1s_BFu0s()
{
  {
    init_simple_test("S_BFu1s_BFu0s");
    static S_BFu1s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu1s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu1s_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu1s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "S_BFu1s_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu1s_BFu0s(Test_S_BFu1s_BFu0s, "S_BFu1s_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu31i_BFu0c  {
  short v1;
  unsigned int v2:31;
  unsigned char  :0;
};
//SIG(1 S_BFu31i_BFu0c) C1{ Fs Fi:31 Fc:0}



static void Test_S_BFu31i_BFu0c()
{
  {
    init_simple_test("S_BFu31i_BFu0c");
    static S_BFu31i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu31i_BFu0c(Test_S_BFu31i_BFu0c, "S_BFu31i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu31i_BFu0i  {
  short v1;
  unsigned int v2:31;
  unsigned int  :0;
};
//SIG(1 S_BFu31i_BFu0i) C1{ Fs Fi:31 Fi:0}



static void Test_S_BFu31i_BFu0i()
{
  {
    init_simple_test("S_BFu31i_BFu0i");
    static S_BFu31i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu31i_BFu0i(Test_S_BFu31i_BFu0i, "S_BFu31i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu31i_BFu0ll  {
  short v1;
  unsigned int v2:31;
  __tsu64  :0;
};
//SIG(1 S_BFu31i_BFu0ll) C1{ Fs Fi:31 FL:0}



static void Test_S_BFu31i_BFu0ll()
{
  {
    init_simple_test("S_BFu31i_BFu0ll");
    static S_BFu31i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu31i_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu31i_BFu0ll(Test_S_BFu31i_BFu0ll, "S_BFu31i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu31i_BFu0s  {
  short v1;
  unsigned int v2:31;
  unsigned short  :0;
};
//SIG(1 S_BFu31i_BFu0s) C1{ Fs Fi:31 Fs:0}



static void Test_S_BFu31i_BFu0s()
{
  {
    init_simple_test("S_BFu31i_BFu0s");
    static S_BFu31i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu31i_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu31i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "S_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "S_BFu31i_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu31i_BFu0s(Test_S_BFu31i_BFu0s, "S_BFu31i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu31ll_BFu0c  {
  short v1;
  __tsu64 v2:31;
  unsigned char  :0;
};
//SIG(1 S_BFu31ll_BFu0c) C1{ Fs FL:31 Fc:0}



static void Test_S_BFu31ll_BFu0c()
{
  {
    init_simple_test("S_BFu31ll_BFu0c");
    static S_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu31ll_BFu0c(Test_S_BFu31ll_BFu0c, "S_BFu31ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu31ll_BFu0i  {
  short v1;
  __tsu64 v2:31;
  unsigned int  :0;
};
//SIG(1 S_BFu31ll_BFu0i) C1{ Fs FL:31 Fi:0}



static void Test_S_BFu31ll_BFu0i()
{
  {
    init_simple_test("S_BFu31ll_BFu0i");
    static S_BFu31ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu31ll_BFu0i(Test_S_BFu31ll_BFu0i, "S_BFu31ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu31ll_BFu0ll  {
  short v1;
  __tsu64 v2:31;
  __tsu64  :0;
};
//SIG(1 S_BFu31ll_BFu0ll) C1{ Fs FL:31 FL:0}



static void Test_S_BFu31ll_BFu0ll()
{
  {
    init_simple_test("S_BFu31ll_BFu0ll");
    static S_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu31ll_BFu0ll(Test_S_BFu31ll_BFu0ll, "S_BFu31ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu31ll_BFu0s  {
  short v1;
  __tsu64 v2:31;
  unsigned short  :0;
};
//SIG(1 S_BFu31ll_BFu0s) C1{ Fs FL:31 Fs:0}



static void Test_S_BFu31ll_BFu0s()
{
  {
    init_simple_test("S_BFu31ll_BFu0s");
    static S_BFu31ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu31ll_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu31ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "S_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "S_BFu31ll_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu31ll_BFu0s(Test_S_BFu31ll_BFu0s, "S_BFu31ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu32i_BFu0c  {
  short v1;
  unsigned int v2:32;
  unsigned char  :0;
};
//SIG(1 S_BFu32i_BFu0c) C1{ Fs Fi:32 Fc:0}



static void Test_S_BFu32i_BFu0c()
{
  {
    init_simple_test("S_BFu32i_BFu0c");
    static S_BFu32i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu32i_BFu0c(Test_S_BFu32i_BFu0c, "S_BFu32i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu32i_BFu0i  {
  short v1;
  unsigned int v2:32;
  unsigned int  :0;
};
//SIG(1 S_BFu32i_BFu0i) C1{ Fs Fi:32 Fi:0}



static void Test_S_BFu32i_BFu0i()
{
  {
    init_simple_test("S_BFu32i_BFu0i");
    static S_BFu32i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu32i_BFu0i(Test_S_BFu32i_BFu0i, "S_BFu32i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu32i_BFu0ll  {
  short v1;
  unsigned int v2:32;
  __tsu64  :0;
};
//SIG(1 S_BFu32i_BFu0ll) C1{ Fs Fi:32 FL:0}



static void Test_S_BFu32i_BFu0ll()
{
  {
    init_simple_test("S_BFu32i_BFu0ll");
    static S_BFu32i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu32i_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu32i_BFu0ll(Test_S_BFu32i_BFu0ll, "S_BFu32i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu32i_BFu0s  {
  short v1;
  unsigned int v2:32;
  unsigned short  :0;
};
//SIG(1 S_BFu32i_BFu0s) C1{ Fs Fi:32 Fs:0}



static void Test_S_BFu32i_BFu0s()
{
  {
    init_simple_test("S_BFu32i_BFu0s");
    static S_BFu32i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu32i_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu32i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "S_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "S_BFu32i_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu32i_BFu0s(Test_S_BFu32i_BFu0s, "S_BFu32i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu32ll_BFu0c  {
  short v1;
  __tsu64 v2:32;
  unsigned char  :0;
};
//SIG(1 S_BFu32ll_BFu0c) C1{ Fs FL:32 Fc:0}



static void Test_S_BFu32ll_BFu0c()
{
  {
    init_simple_test("S_BFu32ll_BFu0c");
    static S_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu32ll_BFu0c(Test_S_BFu32ll_BFu0c, "S_BFu32ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu32ll_BFu0i  {
  short v1;
  __tsu64 v2:32;
  unsigned int  :0;
};
//SIG(1 S_BFu32ll_BFu0i) C1{ Fs FL:32 Fi:0}



static void Test_S_BFu32ll_BFu0i()
{
  {
    init_simple_test("S_BFu32ll_BFu0i");
    static S_BFu32ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu32ll_BFu0i(Test_S_BFu32ll_BFu0i, "S_BFu32ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu32ll_BFu0ll  {
  short v1;
  __tsu64 v2:32;
  __tsu64  :0;
};
//SIG(1 S_BFu32ll_BFu0ll) C1{ Fs FL:32 FL:0}



static void Test_S_BFu32ll_BFu0ll()
{
  {
    init_simple_test("S_BFu32ll_BFu0ll");
    static S_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu32ll_BFu0ll(Test_S_BFu32ll_BFu0ll, "S_BFu32ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu32ll_BFu0s  {
  short v1;
  __tsu64 v2:32;
  unsigned short  :0;
};
//SIG(1 S_BFu32ll_BFu0s) C1{ Fs FL:32 Fs:0}



static void Test_S_BFu32ll_BFu0s()
{
  {
    init_simple_test("S_BFu32ll_BFu0s");
    static S_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu32ll_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu32ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "S_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "S_BFu32ll_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu32ll_BFu0s(Test_S_BFu32ll_BFu0s, "S_BFu32ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu33_BFu0c  {
  short v1;
  __tsu64 v2:33;
  unsigned char  :0;
};
//SIG(1 S_BFu33_BFu0c) C1{ Fs FL:33 Fc:0}



static void Test_S_BFu33_BFu0c()
{
  {
    init_simple_test("S_BFu33_BFu0c");
    static S_BFu33_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu33_BFu0c(Test_S_BFu33_BFu0c, "S_BFu33_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu33_BFu0i  {
  short v1;
  __tsu64 v2:33;
  unsigned int  :0;
};
//SIG(1 S_BFu33_BFu0i) C1{ Fs FL:33 Fi:0}



static void Test_S_BFu33_BFu0i()
{
  {
    init_simple_test("S_BFu33_BFu0i");
    static S_BFu33_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu33_BFu0i(Test_S_BFu33_BFu0i, "S_BFu33_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu33_BFu0ll  {
  short v1;
  __tsu64 v2:33;
  __tsu64  :0;
};
//SIG(1 S_BFu33_BFu0ll) C1{ Fs FL:33 FL:0}



static void Test_S_BFu33_BFu0ll()
{
  {
    init_simple_test("S_BFu33_BFu0ll");
    static S_BFu33_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu33_BFu0ll(Test_S_BFu33_BFu0ll, "S_BFu33_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu33_BFu0s  {
  short v1;
  __tsu64 v2:33;
  unsigned short  :0;
};
//SIG(1 S_BFu33_BFu0s) C1{ Fs FL:33 Fs:0}



static void Test_S_BFu33_BFu0s()
{
  {
    init_simple_test("S_BFu33_BFu0s");
    static S_BFu33_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(S_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu33_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu33_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "S_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "S_BFu33_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu33_BFu0s(Test_S_BFu33_BFu0s, "S_BFu33_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7c_BFu0c  {
  short v1;
  unsigned char v2:7;
  unsigned char  :0;
};
//SIG(1 S_BFu7c_BFu0c) C1{ Fs Fc:7 Fc:0}



static void Test_S_BFu7c_BFu0c()
{
  {
    init_simple_test("S_BFu7c_BFu0c");
    static S_BFu7c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu7c_BFu0c(Test_S_BFu7c_BFu0c, "S_BFu7c_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7c_BFu0i  {
  short v1;
  unsigned char v2:7;
  unsigned int  :0;
};
//SIG(1 S_BFu7c_BFu0i) C1{ Fs Fc:7 Fi:0}



static void Test_S_BFu7c_BFu0i()
{
  {
    init_simple_test("S_BFu7c_BFu0i");
    static S_BFu7c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu7c_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu7c_BFu0i(Test_S_BFu7c_BFu0i, "S_BFu7c_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7c_BFu0ll  {
  short v1;
  unsigned char v2:7;
  __tsu64  :0;
};
//SIG(1 S_BFu7c_BFu0ll) C1{ Fs Fc:7 FL:0}



static void Test_S_BFu7c_BFu0ll()
{
  {
    init_simple_test("S_BFu7c_BFu0ll");
    static S_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu7c_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu7c_BFu0ll(Test_S_BFu7c_BFu0ll, "S_BFu7c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7c_BFu0s  {
  short v1;
  unsigned char v2:7;
  unsigned short  :0;
};
//SIG(1 S_BFu7c_BFu0s) C1{ Fs Fc:7 Fs:0}



static void Test_S_BFu7c_BFu0s()
{
  {
    init_simple_test("S_BFu7c_BFu0s");
    static S_BFu7c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7c_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7c_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu7c_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7c_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu7c_BFu0s(Test_S_BFu7c_BFu0s, "S_BFu7c_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7i_BFu0c  {
  short v1;
  unsigned int v2:7;
  unsigned char  :0;
};
//SIG(1 S_BFu7i_BFu0c) C1{ Fs Fi:7 Fc:0}



static void Test_S_BFu7i_BFu0c()
{
  {
    init_simple_test("S_BFu7i_BFu0c");
    static S_BFu7i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu7i_BFu0c(Test_S_BFu7i_BFu0c, "S_BFu7i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7i_BFu0i  {
  short v1;
  unsigned int v2:7;
  unsigned int  :0;
};
//SIG(1 S_BFu7i_BFu0i) C1{ Fs Fi:7 Fi:0}



static void Test_S_BFu7i_BFu0i()
{
  {
    init_simple_test("S_BFu7i_BFu0i");
    static S_BFu7i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu7i_BFu0i(Test_S_BFu7i_BFu0i, "S_BFu7i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7i_BFu0ll  {
  short v1;
  unsigned int v2:7;
  __tsu64  :0;
};
//SIG(1 S_BFu7i_BFu0ll) C1{ Fs Fi:7 FL:0}



static void Test_S_BFu7i_BFu0ll()
{
  {
    init_simple_test("S_BFu7i_BFu0ll");
    static S_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu7i_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu7i_BFu0ll(Test_S_BFu7i_BFu0ll, "S_BFu7i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7i_BFu0s  {
  short v1;
  unsigned int v2:7;
  unsigned short  :0;
};
//SIG(1 S_BFu7i_BFu0s) C1{ Fs Fi:7 Fs:0}



static void Test_S_BFu7i_BFu0s()
{
  {
    init_simple_test("S_BFu7i_BFu0s");
    static S_BFu7i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu7i_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu7i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7i_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu7i_BFu0s(Test_S_BFu7i_BFu0s, "S_BFu7i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7ll_BFu0c  {
  short v1;
  __tsu64 v2:7;
  unsigned char  :0;
};
//SIG(1 S_BFu7ll_BFu0c) C1{ Fs FL:7 Fc:0}



static void Test_S_BFu7ll_BFu0c()
{
  {
    init_simple_test("S_BFu7ll_BFu0c");
    static S_BFu7ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu7ll_BFu0c(Test_S_BFu7ll_BFu0c, "S_BFu7ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7ll_BFu0i  {
  short v1;
  __tsu64 v2:7;
  unsigned int  :0;
};
//SIG(1 S_BFu7ll_BFu0i) C1{ Fs FL:7 Fi:0}



static void Test_S_BFu7ll_BFu0i()
{
  {
    init_simple_test("S_BFu7ll_BFu0i");
    static S_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu7ll_BFu0i(Test_S_BFu7ll_BFu0i, "S_BFu7ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7ll_BFu0ll  {
  short v1;
  __tsu64 v2:7;
  __tsu64  :0;
};
//SIG(1 S_BFu7ll_BFu0ll) C1{ Fs FL:7 FL:0}



static void Test_S_BFu7ll_BFu0ll()
{
  {
    init_simple_test("S_BFu7ll_BFu0ll");
    static S_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu7ll_BFu0ll(Test_S_BFu7ll_BFu0ll, "S_BFu7ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7ll_BFu0s  {
  short v1;
  __tsu64 v2:7;
  unsigned short  :0;
};
//SIG(1 S_BFu7ll_BFu0s) C1{ Fs FL:7 Fs:0}



static void Test_S_BFu7ll_BFu0s()
{
  {
    init_simple_test("S_BFu7ll_BFu0s");
    static S_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu7ll_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu7ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7ll_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu7ll_BFu0s(Test_S_BFu7ll_BFu0s, "S_BFu7ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7s_BFu0c  {
  short v1;
  unsigned short v2:7;
  unsigned char  :0;
};
//SIG(1 S_BFu7s_BFu0c) C1{ Fs Fs:7 Fc:0}



static void Test_S_BFu7s_BFu0c()
{
  {
    init_simple_test("S_BFu7s_BFu0c");
    static S_BFu7s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu7s_BFu0c(Test_S_BFu7s_BFu0c, "S_BFu7s_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7s_BFu0i  {
  short v1;
  unsigned short v2:7;
  unsigned int  :0;
};
//SIG(1 S_BFu7s_BFu0i) C1{ Fs Fs:7 Fi:0}



static void Test_S_BFu7s_BFu0i()
{
  {
    init_simple_test("S_BFu7s_BFu0i");
    static S_BFu7s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu7s_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu7s_BFu0i(Test_S_BFu7s_BFu0i, "S_BFu7s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7s_BFu0ll  {
  short v1;
  unsigned short v2:7;
  __tsu64  :0;
};
//SIG(1 S_BFu7s_BFu0ll) C1{ Fs Fs:7 FL:0}



static void Test_S_BFu7s_BFu0ll()
{
  {
    init_simple_test("S_BFu7s_BFu0ll");
    static S_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu7s_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu7s_BFu0ll(Test_S_BFu7s_BFu0ll, "S_BFu7s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu7s_BFu0s  {
  short v1;
  unsigned short v2:7;
  unsigned short  :0;
};
//SIG(1 S_BFu7s_BFu0s) C1{ Fs Fs:7 Fs:0}



static void Test_S_BFu7s_BFu0s()
{
  {
    init_simple_test("S_BFu7s_BFu0s");
    static S_BFu7s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu7s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu7s_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu7s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "S_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "S_BFu7s_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu7s_BFu0s(Test_S_BFu7s_BFu0s, "S_BFu7s_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8c_BFu0c  {
  short v1;
  unsigned char v2:8;
  unsigned char  :0;
};
//SIG(1 S_BFu8c_BFu0c) C1{ Fs Fc:8 Fc:0}



static void Test_S_BFu8c_BFu0c()
{
  {
    init_simple_test("S_BFu8c_BFu0c");
    static S_BFu8c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu8c_BFu0c(Test_S_BFu8c_BFu0c, "S_BFu8c_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8c_BFu0i  {
  short v1;
  unsigned char v2:8;
  unsigned int  :0;
};
//SIG(1 S_BFu8c_BFu0i) C1{ Fs Fc:8 Fi:0}



static void Test_S_BFu8c_BFu0i()
{
  {
    init_simple_test("S_BFu8c_BFu0i");
    static S_BFu8c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu8c_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu8c_BFu0i(Test_S_BFu8c_BFu0i, "S_BFu8c_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8c_BFu0ll  {
  short v1;
  unsigned char v2:8;
  __tsu64  :0;
};
//SIG(1 S_BFu8c_BFu0ll) C1{ Fs Fc:8 FL:0}



static void Test_S_BFu8c_BFu0ll()
{
  {
    init_simple_test("S_BFu8c_BFu0ll");
    static S_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu8c_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu8c_BFu0ll(Test_S_BFu8c_BFu0ll, "S_BFu8c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8c_BFu0s  {
  short v1;
  unsigned char v2:8;
  unsigned short  :0;
};
//SIG(1 S_BFu8c_BFu0s) C1{ Fs Fc:8 Fs:0}



static void Test_S_BFu8c_BFu0s()
{
  {
    init_simple_test("S_BFu8c_BFu0s");
    static S_BFu8c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8c_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8c_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu8c_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8c_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu8c_BFu0s(Test_S_BFu8c_BFu0s, "S_BFu8c_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8i_BFu0c  {
  short v1;
  unsigned int v2:8;
  unsigned char  :0;
};
//SIG(1 S_BFu8i_BFu0c) C1{ Fs Fi:8 Fc:0}



static void Test_S_BFu8i_BFu0c()
{
  {
    init_simple_test("S_BFu8i_BFu0c");
    static S_BFu8i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu8i_BFu0c(Test_S_BFu8i_BFu0c, "S_BFu8i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8i_BFu0i  {
  short v1;
  unsigned int v2:8;
  unsigned int  :0;
};
//SIG(1 S_BFu8i_BFu0i) C1{ Fs Fi:8 Fi:0}



static void Test_S_BFu8i_BFu0i()
{
  {
    init_simple_test("S_BFu8i_BFu0i");
    static S_BFu8i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu8i_BFu0i(Test_S_BFu8i_BFu0i, "S_BFu8i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8i_BFu0ll  {
  short v1;
  unsigned int v2:8;
  __tsu64  :0;
};
//SIG(1 S_BFu8i_BFu0ll) C1{ Fs Fi:8 FL:0}



static void Test_S_BFu8i_BFu0ll()
{
  {
    init_simple_test("S_BFu8i_BFu0ll");
    static S_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu8i_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu8i_BFu0ll(Test_S_BFu8i_BFu0ll, "S_BFu8i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8i_BFu0s  {
  short v1;
  unsigned int v2:8;
  unsigned short  :0;
};
//SIG(1 S_BFu8i_BFu0s) C1{ Fs Fi:8 Fs:0}



static void Test_S_BFu8i_BFu0s()
{
  {
    init_simple_test("S_BFu8i_BFu0s");
    static S_BFu8i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu8i_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu8i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8i_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu8i_BFu0s(Test_S_BFu8i_BFu0s, "S_BFu8i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8ll_BFu0c  {
  short v1;
  __tsu64 v2:8;
  unsigned char  :0;
};
//SIG(1 S_BFu8ll_BFu0c) C1{ Fs FL:8 Fc:0}



static void Test_S_BFu8ll_BFu0c()
{
  {
    init_simple_test("S_BFu8ll_BFu0c");
    static S_BFu8ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu8ll_BFu0c(Test_S_BFu8ll_BFu0c, "S_BFu8ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8ll_BFu0i  {
  short v1;
  __tsu64 v2:8;
  unsigned int  :0;
};
//SIG(1 S_BFu8ll_BFu0i) C1{ Fs FL:8 Fi:0}



static void Test_S_BFu8ll_BFu0i()
{
  {
    init_simple_test("S_BFu8ll_BFu0i");
    static S_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu8ll_BFu0i(Test_S_BFu8ll_BFu0i, "S_BFu8ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8ll_BFu0ll  {
  short v1;
  __tsu64 v2:8;
  __tsu64  :0;
};
//SIG(1 S_BFu8ll_BFu0ll) C1{ Fs FL:8 FL:0}



static void Test_S_BFu8ll_BFu0ll()
{
  {
    init_simple_test("S_BFu8ll_BFu0ll");
    static S_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu8ll_BFu0ll(Test_S_BFu8ll_BFu0ll, "S_BFu8ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8ll_BFu0s  {
  short v1;
  __tsu64 v2:8;
  unsigned short  :0;
};
//SIG(1 S_BFu8ll_BFu0s) C1{ Fs FL:8 Fs:0}



static void Test_S_BFu8ll_BFu0s()
{
  {
    init_simple_test("S_BFu8ll_BFu0s");
    static S_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu8ll_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu8ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8ll_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu8ll_BFu0s(Test_S_BFu8ll_BFu0s, "S_BFu8ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8s_BFu0c  {
  short v1;
  unsigned short v2:8;
  unsigned char  :0;
};
//SIG(1 S_BFu8s_BFu0c) C1{ Fs Fs:8 Fc:0}



static void Test_S_BFu8s_BFu0c()
{
  {
    init_simple_test("S_BFu8s_BFu0c");
    static S_BFu8s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu8s_BFu0c(Test_S_BFu8s_BFu0c, "S_BFu8s_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8s_BFu0i  {
  short v1;
  unsigned short v2:8;
  unsigned int  :0;
};
//SIG(1 S_BFu8s_BFu0i) C1{ Fs Fs:8 Fi:0}



static void Test_S_BFu8s_BFu0i()
{
  {
    init_simple_test("S_BFu8s_BFu0i");
    static S_BFu8s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu8s_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu8s_BFu0i(Test_S_BFu8s_BFu0i, "S_BFu8s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8s_BFu0ll  {
  short v1;
  unsigned short v2:8;
  __tsu64  :0;
};
//SIG(1 S_BFu8s_BFu0ll) C1{ Fs Fs:8 FL:0}



static void Test_S_BFu8s_BFu0ll()
{
  {
    init_simple_test("S_BFu8s_BFu0ll");
    static S_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu8s_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu8s_BFu0ll(Test_S_BFu8s_BFu0ll, "S_BFu8s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu8s_BFu0s  {
  short v1;
  unsigned short v2:8;
  unsigned short  :0;
};
//SIG(1 S_BFu8s_BFu0s) C1{ Fs Fs:8 Fs:0}



static void Test_S_BFu8s_BFu0s()
{
  {
    init_simple_test("S_BFu8s_BFu0s");
    static S_BFu8s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu8s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu8s_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu8s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "S_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "S_BFu8s_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu8s_BFu0s(Test_S_BFu8s_BFu0s, "S_BFu8s_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu9i_BFu0c  {
  short v1;
  unsigned int v2:9;
  unsigned char  :0;
};
//SIG(1 S_BFu9i_BFu0c) C1{ Fs Fi:9 Fc:0}



static void Test_S_BFu9i_BFu0c()
{
  {
    init_simple_test("S_BFu9i_BFu0c");
    static S_BFu9i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu9i_BFu0c(Test_S_BFu9i_BFu0c, "S_BFu9i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu9i_BFu0i  {
  short v1;
  unsigned int v2:9;
  unsigned int  :0;
};
//SIG(1 S_BFu9i_BFu0i) C1{ Fs Fi:9 Fi:0}



static void Test_S_BFu9i_BFu0i()
{
  {
    init_simple_test("S_BFu9i_BFu0i");
    static S_BFu9i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu9i_BFu0i(Test_S_BFu9i_BFu0i, "S_BFu9i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu9i_BFu0ll  {
  short v1;
  unsigned int v2:9;
  __tsu64  :0;
};
//SIG(1 S_BFu9i_BFu0ll) C1{ Fs Fi:9 FL:0}



static void Test_S_BFu9i_BFu0ll()
{
  {
    init_simple_test("S_BFu9i_BFu0ll");
    static S_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_BFu9i_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu9i_BFu0ll(Test_S_BFu9i_BFu0ll, "S_BFu9i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu9i_BFu0s  {
  short v1;
  unsigned int v2:9;
  unsigned short  :0;
};
//SIG(1 S_BFu9i_BFu0s) C1{ Fs Fi:9 Fs:0}



static void Test_S_BFu9i_BFu0s()
{
  {
    init_simple_test("S_BFu9i_BFu0s");
    static S_BFu9i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(S_BFu9i_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu9i_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9i_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu9i_BFu0s(Test_S_BFu9i_BFu0s, "S_BFu9i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu9ll_BFu0c  {
  short v1;
  __tsu64 v2:9;
  unsigned char  :0;
};
//SIG(1 S_BFu9ll_BFu0c) C1{ Fs FL:9 Fc:0}



static void Test_S_BFu9ll_BFu0c()
{
  {
    init_simple_test("S_BFu9ll_BFu0c");
    static S_BFu9ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu9ll_BFu0c(Test_S_BFu9ll_BFu0c, "S_BFu9ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu9ll_BFu0i  {
  short v1;
  __tsu64 v2:9;
  unsigned int  :0;
};
//SIG(1 S_BFu9ll_BFu0i) C1{ Fs FL:9 Fi:0}



static void Test_S_BFu9ll_BFu0i()
{
  {
    init_simple_test("S_BFu9ll_BFu0i");
    static S_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu9ll_BFu0i(Test_S_BFu9ll_BFu0i, "S_BFu9ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu9ll_BFu0ll  {
  short v1;
  __tsu64 v2:9;
  __tsu64  :0;
};
//SIG(1 S_BFu9ll_BFu0ll) C1{ Fs FL:9 FL:0}



static void Test_S_BFu9ll_BFu0ll()
{
  {
    init_simple_test("S_BFu9ll_BFu0ll");
    static S_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu9ll_BFu0ll(Test_S_BFu9ll_BFu0ll, "S_BFu9ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu9ll_BFu0s  {
  short v1;
  __tsu64 v2:9;
  unsigned short  :0;
};
//SIG(1 S_BFu9ll_BFu0s) C1{ Fs FL:9 Fs:0}



static void Test_S_BFu9ll_BFu0s()
{
  {
    init_simple_test("S_BFu9ll_BFu0s");
    static S_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_BFu9ll_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu9ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9ll_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu9ll_BFu0s(Test_S_BFu9ll_BFu0s, "S_BFu9ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu9s_BFu0c  {
  short v1;
  unsigned short v2:9;
  unsigned char  :0;
};
//SIG(1 S_BFu9s_BFu0c) C1{ Fs Fs:9 Fc:0}



static void Test_S_BFu9s_BFu0c()
{
  {
    init_simple_test("S_BFu9s_BFu0c");
    static S_BFu9s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu9s_BFu0c)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu0c");
  }
}
static Arrange_To_Call_Me vS_BFu9s_BFu0c(Test_S_BFu9s_BFu0c, "S_BFu9s_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu9s_BFu0i  {
  short v1;
  unsigned short v2:9;
  unsigned int  :0;
};
//SIG(1 S_BFu9s_BFu0i) C1{ Fs Fs:9 Fi:0}



static void Test_S_BFu9s_BFu0i()
{
  {
    init_simple_test("S_BFu9s_BFu0i");
    static S_BFu9s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu9s_BFu0i)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu0i");
  }
}
static Arrange_To_Call_Me vS_BFu9s_BFu0i(Test_S_BFu9s_BFu0i, "S_BFu9s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu9s_BFu0ll  {
  short v1;
  unsigned short v2:9;
  __tsu64  :0;
};
//SIG(1 S_BFu9s_BFu0ll) C1{ Fs Fs:9 FL:0}



static void Test_S_BFu9s_BFu0ll()
{
  {
    init_simple_test("S_BFu9s_BFu0ll");
    static S_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_BFu9s_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu0ll");
  }
}
static Arrange_To_Call_Me vS_BFu9s_BFu0ll(Test_S_BFu9s_BFu0ll, "S_BFu9s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_BFu9s_BFu0s  {
  short v1;
  unsigned short v2:9;
  unsigned short  :0;
};
//SIG(1 S_BFu9s_BFu0s) C1{ Fs Fs:9 Fs:0}



static void Test_S_BFu9s_BFu0s()
{
  {
    init_simple_test("S_BFu9s_BFu0s");
    static S_BFu9s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_BFu9s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_BFu9s_BFu0s)");
    check_field_offset(lv, v1, 0, "S_BFu9s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "S_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "S_BFu9s_BFu0s");
  }
}
static Arrange_To_Call_Me vS_BFu9s_BFu0s(Test_S_BFu9s_BFu0s, "S_BFu9s_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_C_BFu0c  {
  short v1;
  char v2;
  unsigned char  :0;
};
//SIG(1 S_C_BFu0c) C1{ Fs Fc Fc:0}



static void Test_S_C_BFu0c()
{
  {
    init_simple_test("S_C_BFu0c");
    static S_C_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_C_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_C_BFu0c)");
    check_field_offset(lv, v1, 0, "S_C_BFu0c.v1");
    check_field_offset(lv, v2, 2, "S_C_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vS_C_BFu0c(Test_S_C_BFu0c, "S_C_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_C_BFu0i  {
  short v1;
  char v2;
  unsigned int  :0;
};
//SIG(1 S_C_BFu0i) C1{ Fs Fc Fi:0}



static void Test_S_C_BFu0i()
{
  {
    init_simple_test("S_C_BFu0i");
    static S_C_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_C_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_C_BFu0i)");
    check_field_offset(lv, v1, 0, "S_C_BFu0i.v1");
    check_field_offset(lv, v2, 2, "S_C_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vS_C_BFu0i(Test_S_C_BFu0i, "S_C_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_C_BFu0ll  {
  short v1;
  char v2;
  __tsu64  :0;
};
//SIG(1 S_C_BFu0ll) C1{ Fs Fc FL:0}



static void Test_S_C_BFu0ll()
{
  {
    init_simple_test("S_C_BFu0ll");
    static S_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_C_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_C_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "S_C_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vS_C_BFu0ll(Test_S_C_BFu0ll, "S_C_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_C_BFu0s  {
  short v1;
  char v2;
  unsigned short  :0;
};
//SIG(1 S_C_BFu0s) C1{ Fs Fc Fs:0}



static void Test_S_C_BFu0s()
{
  {
    init_simple_test("S_C_BFu0s");
    static S_C_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_C_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_C_BFu0s)");
    check_field_offset(lv, v1, 0, "S_C_BFu0s.v1");
    check_field_offset(lv, v2, 2, "S_C_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vS_C_BFu0s(Test_S_C_BFu0s, "S_C_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_D_BFu0c  {
  short v1;
  double v2;
  unsigned char  :0;
};
//SIG(1 S_D_BFu0c) C1{ Fs FL Fc:0}



static void Test_S_D_BFu0c()
{
  {
    init_simple_test("S_D_BFu0c");
    static S_D_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_D_BFu0c)");
    check_field_offset(lv, v1, 0, "S_D_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_D_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vS_D_BFu0c(Test_S_D_BFu0c, "S_D_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_D_BFu0i  {
  short v1;
  double v2;
  unsigned int  :0;
};
//SIG(1 S_D_BFu0i) C1{ Fs FL Fi:0}



static void Test_S_D_BFu0i()
{
  {
    init_simple_test("S_D_BFu0i");
    static S_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_D_BFu0i)");
    check_field_offset(lv, v1, 0, "S_D_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_D_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vS_D_BFu0i(Test_S_D_BFu0i, "S_D_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_D_BFu0ll  {
  short v1;
  double v2;
  __tsu64  :0;
};
//SIG(1 S_D_BFu0ll) C1{ Fs FL FL:0}



static void Test_S_D_BFu0ll()
{
  {
    init_simple_test("S_D_BFu0ll");
    static S_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_D_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_D_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_D_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vS_D_BFu0ll(Test_S_D_BFu0ll, "S_D_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_D_BFu0s  {
  short v1;
  double v2;
  unsigned short  :0;
};
//SIG(1 S_D_BFu0s) C1{ Fs FL Fs:0}



static void Test_S_D_BFu0s()
{
  {
    init_simple_test("S_D_BFu0s");
    static S_D_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_D_BFu0s)");
    check_field_offset(lv, v1, 0, "S_D_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_D_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vS_D_BFu0s(Test_S_D_BFu0s, "S_D_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_F_BFu0c  {
  short v1;
  float v2;
  unsigned char  :0;
};
//SIG(1 S_F_BFu0c) C1{ Fs Fi Fc:0}



static void Test_S_F_BFu0c()
{
  {
    init_simple_test("S_F_BFu0c");
    static S_F_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(S_F_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(S_F_BFu0c)");
    check_field_offset(lv, v1, 0, "S_F_BFu0c.v1");
    check_field_offset(lv, v2, 4, "S_F_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vS_F_BFu0c(Test_S_F_BFu0c, "S_F_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_F_BFu0i  {
  short v1;
  float v2;
  unsigned int  :0;
};
//SIG(1 S_F_BFu0i) C1{ Fs Fi Fi:0}



static void Test_S_F_BFu0i()
{
  {
    init_simple_test("S_F_BFu0i");
    static S_F_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(S_F_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(S_F_BFu0i)");
    check_field_offset(lv, v1, 0, "S_F_BFu0i.v1");
    check_field_offset(lv, v2, 4, "S_F_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vS_F_BFu0i(Test_S_F_BFu0i, "S_F_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_F_BFu0ll  {
  short v1;
  float v2;
  __tsu64  :0;
};
//SIG(1 S_F_BFu0ll) C1{ Fs Fi FL:0}



static void Test_S_F_BFu0ll()
{
  {
    init_simple_test("S_F_BFu0ll");
    static S_F_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(S_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_F_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_F_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "S_F_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vS_F_BFu0ll(Test_S_F_BFu0ll, "S_F_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_F_BFu0s  {
  short v1;
  float v2;
  unsigned short  :0;
};
//SIG(1 S_F_BFu0s) C1{ Fs Fi Fs:0}



static void Test_S_F_BFu0s()
{
  {
    init_simple_test("S_F_BFu0s");
    static S_F_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(S_F_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(S_F_BFu0s)");
    check_field_offset(lv, v1, 0, "S_F_BFu0s.v1");
    check_field_offset(lv, v2, 4, "S_F_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vS_F_BFu0s(Test_S_F_BFu0s, "S_F_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_I_BFu0c  {
  short v1;
  int v2;
  unsigned char  :0;
};
//SIG(1 S_I_BFu0c) C1{ Fs Fi Fc:0}



static void Test_S_I_BFu0c()
{
  {
    init_simple_test("S_I_BFu0c");
    static S_I_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(S_I_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(S_I_BFu0c)");
    check_field_offset(lv, v1, 0, "S_I_BFu0c.v1");
    check_field_offset(lv, v2, 4, "S_I_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vS_I_BFu0c(Test_S_I_BFu0c, "S_I_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_I_BFu0i  {
  short v1;
  int v2;
  unsigned int  :0;
};
//SIG(1 S_I_BFu0i) C1{ Fs Fi Fi:0}



static void Test_S_I_BFu0i()
{
  {
    init_simple_test("S_I_BFu0i");
    static S_I_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(S_I_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(S_I_BFu0i)");
    check_field_offset(lv, v1, 0, "S_I_BFu0i.v1");
    check_field_offset(lv, v2, 4, "S_I_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vS_I_BFu0i(Test_S_I_BFu0i, "S_I_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_I_BFu0ll  {
  short v1;
  int v2;
  __tsu64  :0;
};
//SIG(1 S_I_BFu0ll) C1{ Fs Fi FL:0}



static void Test_S_I_BFu0ll()
{
  {
    init_simple_test("S_I_BFu0ll");
    static S_I_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(S_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_I_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_I_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "S_I_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vS_I_BFu0ll(Test_S_I_BFu0ll, "S_I_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_I_BFu0s  {
  short v1;
  int v2;
  unsigned short  :0;
};
//SIG(1 S_I_BFu0s) C1{ Fs Fi Fs:0}



static void Test_S_I_BFu0s()
{
  {
    init_simple_test("S_I_BFu0s");
    static S_I_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(S_I_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(S_I_BFu0s)");
    check_field_offset(lv, v1, 0, "S_I_BFu0s.v1");
    check_field_offset(lv, v2, 4, "S_I_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vS_I_BFu0s(Test_S_I_BFu0s, "S_I_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Ip_BFu0c  {
  short v1;
  int *v2;
  unsigned char  :0;
};
//SIG(1 S_Ip_BFu0c) C1{ Fs Fp Fc:0}



static void Test_S_Ip_BFu0c()
{
  {
    init_simple_test("S_Ip_BFu0c");
    static S_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_Ip_BFu0c)");
    check_field_offset(lv, v1, 0, "S_Ip_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_Ip_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vS_Ip_BFu0c(Test_S_Ip_BFu0c, "S_Ip_BFu0c", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Ip_BFu0i  {
  short v1;
  int *v2;
  unsigned int  :0;
};
//SIG(1 S_Ip_BFu0i) C1{ Fs Fp Fi:0}



static void Test_S_Ip_BFu0i()
{
  {
    init_simple_test("S_Ip_BFu0i");
    static S_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_Ip_BFu0i)");
    check_field_offset(lv, v1, 0, "S_Ip_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_Ip_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vS_Ip_BFu0i(Test_S_Ip_BFu0i, "S_Ip_BFu0i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Ip_BFu0ll  {
  short v1;
  int *v2;
  __tsu64  :0;
};
//SIG(1 S_Ip_BFu0ll) C1{ Fs Fp FL:0}



static void Test_S_Ip_BFu0ll()
{
  {
    init_simple_test("S_Ip_BFu0ll");
    static S_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_Ip_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_Ip_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_Ip_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vS_Ip_BFu0ll(Test_S_Ip_BFu0ll, "S_Ip_BFu0ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Ip_BFu0s  {
  short v1;
  int *v2;
  unsigned short  :0;
};
//SIG(1 S_Ip_BFu0s) C1{ Fs Fp Fs:0}



static void Test_S_Ip_BFu0s()
{
  {
    init_simple_test("S_Ip_BFu0s");
    static S_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_Ip_BFu0s)");
    check_field_offset(lv, v1, 0, "S_Ip_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_Ip_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vS_Ip_BFu0s(Test_S_Ip_BFu0s, "S_Ip_BFu0s", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_L_BFu0c  {
  short v1;
  __tsi64 v2;
  unsigned char  :0;
};
//SIG(1 S_L_BFu0c) C1{ Fs FL Fc:0}



static void Test_S_L_BFu0c()
{
  {
    init_simple_test("S_L_BFu0c");
    static S_L_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_L_BFu0c)");
    check_field_offset(lv, v1, 0, "S_L_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_L_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vS_L_BFu0c(Test_S_L_BFu0c, "S_L_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_L_BFu0i  {
  short v1;
  __tsi64 v2;
  unsigned int  :0;
};
//SIG(1 S_L_BFu0i) C1{ Fs FL Fi:0}



static void Test_S_L_BFu0i()
{
  {
    init_simple_test("S_L_BFu0i");
    static S_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_L_BFu0i)");
    check_field_offset(lv, v1, 0, "S_L_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_L_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vS_L_BFu0i(Test_S_L_BFu0i, "S_L_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_L_BFu0ll  {
  short v1;
  __tsi64 v2;
  __tsu64  :0;
};
//SIG(1 S_L_BFu0ll) C1{ Fs FL FL:0}



static void Test_S_L_BFu0ll()
{
  {
    init_simple_test("S_L_BFu0ll");
    static S_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_L_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_L_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_L_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vS_L_BFu0ll(Test_S_L_BFu0ll, "S_L_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_L_BFu0s  {
  short v1;
  __tsi64 v2;
  unsigned short  :0;
};
//SIG(1 S_L_BFu0s) C1{ Fs FL Fs:0}



static void Test_S_L_BFu0s()
{
  {
    init_simple_test("S_L_BFu0s");
    static S_L_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_L_BFu0s)");
    check_field_offset(lv, v1, 0, "S_L_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_L_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vS_L_BFu0s(Test_S_L_BFu0s, "S_L_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_S_BFu0c  {
  short v1;
  short v2;
  unsigned char  :0;
};
//SIG(1 S_S_BFu0c) C1{ Fs[2] Fc:0}



static void Test_S_S_BFu0c()
{
  {
    init_simple_test("S_S_BFu0c");
    static S_S_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_S_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_S_BFu0c)");
    check_field_offset(lv, v1, 0, "S_S_BFu0c.v1");
    check_field_offset(lv, v2, 2, "S_S_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vS_S_BFu0c(Test_S_S_BFu0c, "S_S_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_S_BFu0i  {
  short v1;
  short v2;
  unsigned int  :0;
};
//SIG(1 S_S_BFu0i) C1{ Fs[2] Fi:0}



static void Test_S_S_BFu0i()
{
  {
    init_simple_test("S_S_BFu0i");
    static S_S_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_S_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_S_BFu0i)");
    check_field_offset(lv, v1, 0, "S_S_BFu0i.v1");
    check_field_offset(lv, v2, 2, "S_S_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vS_S_BFu0i(Test_S_S_BFu0i, "S_S_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_S_BFu0ll  {
  short v1;
  short v2;
  __tsu64  :0;
};
//SIG(1 S_S_BFu0ll) C1{ Fs[2] FL:0}



static void Test_S_S_BFu0ll()
{
  {
    init_simple_test("S_S_BFu0ll");
    static S_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_S_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_S_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "S_S_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vS_S_BFu0ll(Test_S_S_BFu0ll, "S_S_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_S_BFu0s  {
  short v1;
  short v2;
  unsigned short  :0;
};
//SIG(1 S_S_BFu0s) C1{ Fs[2] Fs:0}



static void Test_S_S_BFu0s()
{
  {
    init_simple_test("S_S_BFu0s");
    static S_S_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_S_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_S_BFu0s)");
    check_field_offset(lv, v1, 0, "S_S_BFu0s.v1");
    check_field_offset(lv, v2, 2, "S_S_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vS_S_BFu0s(Test_S_S_BFu0s, "S_S_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Uc_BFu0c  {
  short v1;
  unsigned char v2;
  unsigned char  :0;
};
//SIG(1 S_Uc_BFu0c) C1{ Fs Fc Fc:0}



static void Test_S_Uc_BFu0c()
{
  {
    init_simple_test("S_Uc_BFu0c");
    static S_Uc_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_Uc_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_Uc_BFu0c)");
    check_field_offset(lv, v1, 0, "S_Uc_BFu0c.v1");
    check_field_offset(lv, v2, 2, "S_Uc_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vS_Uc_BFu0c(Test_S_Uc_BFu0c, "S_Uc_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Uc_BFu0i  {
  short v1;
  unsigned char v2;
  unsigned int  :0;
};
//SIG(1 S_Uc_BFu0i) C1{ Fs Fc Fi:0}



static void Test_S_Uc_BFu0i()
{
  {
    init_simple_test("S_Uc_BFu0i");
    static S_Uc_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_Uc_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_Uc_BFu0i)");
    check_field_offset(lv, v1, 0, "S_Uc_BFu0i.v1");
    check_field_offset(lv, v2, 2, "S_Uc_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vS_Uc_BFu0i(Test_S_Uc_BFu0i, "S_Uc_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Uc_BFu0ll  {
  short v1;
  unsigned char v2;
  __tsu64  :0;
};
//SIG(1 S_Uc_BFu0ll) C1{ Fs Fc FL:0}



static void Test_S_Uc_BFu0ll()
{
  {
    init_simple_test("S_Uc_BFu0ll");
    static S_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_Uc_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_Uc_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "S_Uc_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vS_Uc_BFu0ll(Test_S_Uc_BFu0ll, "S_Uc_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Uc_BFu0s  {
  short v1;
  unsigned char v2;
  unsigned short  :0;
};
//SIG(1 S_Uc_BFu0s) C1{ Fs Fc Fs:0}



static void Test_S_Uc_BFu0s()
{
  {
    init_simple_test("S_Uc_BFu0s");
    static S_Uc_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_Uc_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_Uc_BFu0s)");
    check_field_offset(lv, v1, 0, "S_Uc_BFu0s.v1");
    check_field_offset(lv, v2, 2, "S_Uc_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vS_Uc_BFu0s(Test_S_Uc_BFu0s, "S_Uc_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Ui_BFu0c  {
  short v1;
  unsigned int v2;
  unsigned char  :0;
};
//SIG(1 S_Ui_BFu0c) C1{ Fs Fi Fc:0}



static void Test_S_Ui_BFu0c()
{
  {
    init_simple_test("S_Ui_BFu0c");
    static S_Ui_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(S_Ui_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(S_Ui_BFu0c)");
    check_field_offset(lv, v1, 0, "S_Ui_BFu0c.v1");
    check_field_offset(lv, v2, 4, "S_Ui_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vS_Ui_BFu0c(Test_S_Ui_BFu0c, "S_Ui_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Ui_BFu0i  {
  short v1;
  unsigned int v2;
  unsigned int  :0;
};
//SIG(1 S_Ui_BFu0i) C1{ Fs Fi Fi:0}



static void Test_S_Ui_BFu0i()
{
  {
    init_simple_test("S_Ui_BFu0i");
    static S_Ui_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(S_Ui_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(S_Ui_BFu0i)");
    check_field_offset(lv, v1, 0, "S_Ui_BFu0i.v1");
    check_field_offset(lv, v2, 4, "S_Ui_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vS_Ui_BFu0i(Test_S_Ui_BFu0i, "S_Ui_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Ui_BFu0ll  {
  short v1;
  unsigned int v2;
  __tsu64  :0;
};
//SIG(1 S_Ui_BFu0ll) C1{ Fs Fi FL:0}



static void Test_S_Ui_BFu0ll()
{
  {
    init_simple_test("S_Ui_BFu0ll");
    static S_Ui_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(S_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(S_Ui_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_Ui_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "S_Ui_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vS_Ui_BFu0ll(Test_S_Ui_BFu0ll, "S_Ui_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Ui_BFu0s  {
  short v1;
  unsigned int v2;
  unsigned short  :0;
};
//SIG(1 S_Ui_BFu0s) C1{ Fs Fi Fs:0}



static void Test_S_Ui_BFu0s()
{
  {
    init_simple_test("S_Ui_BFu0s");
    static S_Ui_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(S_Ui_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(S_Ui_BFu0s)");
    check_field_offset(lv, v1, 0, "S_Ui_BFu0s.v1");
    check_field_offset(lv, v2, 4, "S_Ui_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vS_Ui_BFu0s(Test_S_Ui_BFu0s, "S_Ui_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Ul_BFu0c  {
  short v1;
  __tsu64 v2;
  unsigned char  :0;
};
//SIG(1 S_Ul_BFu0c) C1{ Fs FL Fc:0}



static void Test_S_Ul_BFu0c()
{
  {
    init_simple_test("S_Ul_BFu0c");
    static S_Ul_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_Ul_BFu0c)");
    check_field_offset(lv, v1, 0, "S_Ul_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_Ul_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vS_Ul_BFu0c(Test_S_Ul_BFu0c, "S_Ul_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Ul_BFu0i  {
  short v1;
  __tsu64 v2;
  unsigned int  :0;
};
//SIG(1 S_Ul_BFu0i) C1{ Fs FL Fi:0}



static void Test_S_Ul_BFu0i()
{
  {
    init_simple_test("S_Ul_BFu0i");
    static S_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_Ul_BFu0i)");
    check_field_offset(lv, v1, 0, "S_Ul_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_Ul_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vS_Ul_BFu0i(Test_S_Ul_BFu0i, "S_Ul_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Ul_BFu0ll  {
  short v1;
  __tsu64 v2;
  __tsu64  :0;
};
//SIG(1 S_Ul_BFu0ll) C1{ Fs FL FL:0}



static void Test_S_Ul_BFu0ll()
{
  {
    init_simple_test("S_Ul_BFu0ll");
    static S_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_Ul_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_Ul_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_Ul_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vS_Ul_BFu0ll(Test_S_Ul_BFu0ll, "S_Ul_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Ul_BFu0s  {
  short v1;
  __tsu64 v2;
  unsigned short  :0;
};
//SIG(1 S_Ul_BFu0s) C1{ Fs FL Fs:0}



static void Test_S_Ul_BFu0s()
{
  {
    init_simple_test("S_Ul_BFu0s");
    static S_Ul_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_Ul_BFu0s)");
    check_field_offset(lv, v1, 0, "S_Ul_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_Ul_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vS_Ul_BFu0s(Test_S_Ul_BFu0s, "S_Ul_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Us_BFu0c  {
  short v1;
  unsigned short v2;
  unsigned char  :0;
};
//SIG(1 S_Us_BFu0c) C1{ Fs[2] Fc:0}



static void Test_S_Us_BFu0c()
{
  {
    init_simple_test("S_Us_BFu0c");
    static S_Us_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(S_Us_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(S_Us_BFu0c)");
    check_field_offset(lv, v1, 0, "S_Us_BFu0c.v1");
    check_field_offset(lv, v2, 2, "S_Us_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vS_Us_BFu0c(Test_S_Us_BFu0c, "S_Us_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Us_BFu0i  {
  short v1;
  unsigned short v2;
  unsigned int  :0;
};
//SIG(1 S_Us_BFu0i) C1{ Fs[2] Fi:0}



static void Test_S_Us_BFu0i()
{
  {
    init_simple_test("S_Us_BFu0i");
    static S_Us_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(S_Us_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_Us_BFu0i)");
    check_field_offset(lv, v1, 0, "S_Us_BFu0i.v1");
    check_field_offset(lv, v2, 2, "S_Us_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vS_Us_BFu0i(Test_S_Us_BFu0i, "S_Us_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Us_BFu0ll  {
  short v1;
  unsigned short v2;
  __tsu64  :0;
};
//SIG(1 S_Us_BFu0ll) C1{ Fs[2] FL:0}



static void Test_S_Us_BFu0ll()
{
  {
    init_simple_test("S_Us_BFu0ll");
    static S_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(S_Us_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_Us_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "S_Us_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vS_Us_BFu0ll(Test_S_Us_BFu0ll, "S_Us_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Us_BFu0s  {
  short v1;
  unsigned short v2;
  unsigned short  :0;
};
//SIG(1 S_Us_BFu0s) C1{ Fs[2] Fs:0}



static void Test_S_Us_BFu0s()
{
  {
    init_simple_test("S_Us_BFu0s");
    static S_Us_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(S_Us_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(S_Us_BFu0s)");
    check_field_offset(lv, v1, 0, "S_Us_BFu0s.v1");
    check_field_offset(lv, v2, 2, "S_Us_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vS_Us_BFu0s(Test_S_Us_BFu0s, "S_Us_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Vp_BFu0c  {
  short v1;
  void *v2;
  unsigned char  :0;
};
//SIG(1 S_Vp_BFu0c) C1{ Fs Fp Fc:0}



static void Test_S_Vp_BFu0c()
{
  {
    init_simple_test("S_Vp_BFu0c");
    static S_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_Vp_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_Vp_BFu0c)");
    check_field_offset(lv, v1, 0, "S_Vp_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_Vp_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vS_Vp_BFu0c(Test_S_Vp_BFu0c, "S_Vp_BFu0c", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Vp_BFu0i  {
  short v1;
  void *v2;
  unsigned int  :0;
};
//SIG(1 S_Vp_BFu0i) C1{ Fs Fp Fi:0}



static void Test_S_Vp_BFu0i()
{
  {
    init_simple_test("S_Vp_BFu0i");
    static S_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_Vp_BFu0i)");
    check_field_offset(lv, v1, 0, "S_Vp_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_Vp_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vS_Vp_BFu0i(Test_S_Vp_BFu0i, "S_Vp_BFu0i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Vp_BFu0ll  {
  short v1;
  void *v2;
  __tsu64  :0;
};
//SIG(1 S_Vp_BFu0ll) C1{ Fs Fp FL:0}



static void Test_S_Vp_BFu0ll()
{
  {
    init_simple_test("S_Vp_BFu0ll");
    static S_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_Vp_BFu0ll)");
    check_field_offset(lv, v1, 0, "S_Vp_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_Vp_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vS_Vp_BFu0ll(Test_S_Vp_BFu0ll, "S_Vp_BFu0ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S_Vp_BFu0s  {
  short v1;
  void *v2;
  unsigned short  :0;
};
//SIG(1 S_Vp_BFu0s) C1{ Fs Fp Fs:0}



static void Test_S_Vp_BFu0s()
{
  {
    init_simple_test("S_Vp_BFu0s");
    static S_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S_Vp_BFu0s)");
    check_field_offset(lv, v1, 0, "S_Vp_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "S_Vp_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vS_Vp_BFu0s(Test_S_Vp_BFu0s, "S_Vp_BFu0s", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c  {
  unsigned char v1;
  unsigned char  :0;
};
//SIG(1 Uc_BFu0c) C1{ Fc Fc:0}



static void Test_Uc_BFu0c()
{
  {
    init_simple_test("Uc_BFu0c");
    static Uc_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(Uc_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0c(Test_Uc_BFu0c, "Uc_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu0c  {
  unsigned char v1;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 Uc_BFu0c_BFu0c) C1{ Fc Fc:0 Fc:0}



static void Test_Uc_BFu0c_BFu0c()
{
  {
    init_simple_test("Uc_BFu0c_BFu0c");
    static Uc_BFu0c_BFu0c lv;
    check2(sizeof(lv), 1, "sizeof(Uc_BFu0c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu0c_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu0c(Test_Uc_BFu0c_BFu0c, "Uc_BFu0c_BFu0c", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu0i  {
  unsigned char v1;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 Uc_BFu0c_BFu0i) C1{ Fc Fc:0 Fi:0}



static void Test_Uc_BFu0c_BFu0i()
{
  {
    init_simple_test("Uc_BFu0c_BFu0i");
    static Uc_BFu0c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0c_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu0i(Test_Uc_BFu0c_BFu0i, "Uc_BFu0c_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu0ll  {
  unsigned char v1;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 Uc_BFu0c_BFu0ll) C1{ Fc Fc:0 FL:0}



static void Test_Uc_BFu0c_BFu0ll()
{
  {
    init_simple_test("Uc_BFu0c_BFu0ll");
    static Uc_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0c_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu0ll(Test_Uc_BFu0c_BFu0ll, "Uc_BFu0c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu0s  {
  unsigned char v1;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 Uc_BFu0c_BFu0s) C1{ Fc Fc:0 Fs:0}



static void Test_Uc_BFu0c_BFu0s()
{
  {
    init_simple_test("Uc_BFu0c_BFu0s");
    static Uc_BFu0c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0c_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu0s(Test_Uc_BFu0c_BFu0s, "Uc_BFu0c_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu15i  {
  unsigned char v1;
  unsigned char  :0;
  unsigned int v2:15;
};
//SIG(1 Uc_BFu0c_BFu15i) C1{ Fc Fc:0 Fi:15}



static void Test_Uc_BFu0c_BFu15i()
{
  {
    init_simple_test("Uc_BFu0c_BFu15i");
    static Uc_BFu0c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0c_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "Uc_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "Uc_BFu0c_BFu15i");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu15i(Test_Uc_BFu0c_BFu15i, "Uc_BFu0c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu15ll  {
  unsigned char v1;
  unsigned char  :0;
  __tsu64 v2:15;
};
//SIG(1 Uc_BFu0c_BFu15ll) C1{ Fc Fc:0 FL:15}



static void Test_Uc_BFu0c_BFu15ll()
{
  {
    init_simple_test("Uc_BFu0c_BFu15ll");
    static Uc_BFu0c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "Uc_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "Uc_BFu0c_BFu15ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu15ll(Test_Uc_BFu0c_BFu15ll, "Uc_BFu0c_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu15s  {
  unsigned char v1;
  unsigned char  :0;
  unsigned short v2:15;
};
//SIG(1 Uc_BFu0c_BFu15s) C1{ Fc Fc:0 Fs:15}



static void Test_Uc_BFu0c_BFu15s()
{
  {
    init_simple_test("Uc_BFu0c_BFu15s");
    static Uc_BFu0c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0c_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Uc_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu0c_BFu15s");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu15s(Test_Uc_BFu0c_BFu15s, "Uc_BFu0c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu16i  {
  unsigned char v1;
  unsigned char  :0;
  unsigned int v2:16;
};
//SIG(1 Uc_BFu0c_BFu16i) C1{ Fc Fc:0 Fi:16}



static void Test_Uc_BFu0c_BFu16i()
{
  {
    init_simple_test("Uc_BFu0c_BFu16i");
    static Uc_BFu0c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0c_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu0c_BFu16i");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu16i(Test_Uc_BFu0c_BFu16i, "Uc_BFu0c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu16ll  {
  unsigned char v1;
  unsigned char  :0;
  __tsu64 v2:16;
};
//SIG(1 Uc_BFu0c_BFu16ll) C1{ Fc Fc:0 FL:16}



static void Test_Uc_BFu0c_BFu16ll()
{
  {
    init_simple_test("Uc_BFu0c_BFu16ll");
    static Uc_BFu0c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu0c_BFu16ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu16ll(Test_Uc_BFu0c_BFu16ll, "Uc_BFu0c_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu16s  {
  unsigned char v1;
  unsigned char  :0;
  unsigned short v2:16;
};
//SIG(1 Uc_BFu0c_BFu16s) C1{ Fc Fc:0 Fs:16}



static void Test_Uc_BFu0c_BFu16s()
{
  {
    init_simple_test("Uc_BFu0c_BFu16s");
    static Uc_BFu0c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0c_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Uc_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu0c_BFu16s");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu16s(Test_Uc_BFu0c_BFu16s, "Uc_BFu0c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu17i  {
  unsigned char v1;
  unsigned char  :0;
  unsigned int v2:17;
};
//SIG(1 Uc_BFu0c_BFu17i) C1{ Fc Fc:0 Fi:17}



static void Test_Uc_BFu0c_BFu17i()
{
  {
    init_simple_test("Uc_BFu0c_BFu17i");
    static Uc_BFu0c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0c_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu0c_BFu17i");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu17i(Test_Uc_BFu0c_BFu17i, "Uc_BFu0c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu17ll  {
  unsigned char v1;
  unsigned char  :0;
  __tsu64 v2:17;
};
//SIG(1 Uc_BFu0c_BFu17ll) C1{ Fc Fc:0 FL:17}



static void Test_Uc_BFu0c_BFu17ll()
{
  {
    init_simple_test("Uc_BFu0c_BFu17ll");
    static Uc_BFu0c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu0c_BFu17ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu17ll(Test_Uc_BFu0c_BFu17ll, "Uc_BFu0c_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu1c  {
  unsigned char v1;
  unsigned char  :0;
  unsigned char v2:1;
};
//SIG(1 Uc_BFu0c_BFu1c) C1{ Fc Fc:0 Fc:1}



static void Test_Uc_BFu0c_BFu1c()
{
  {
    init_simple_test("Uc_BFu0c_BFu1c");
    static Uc_BFu0c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu0c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu0c_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu0c_BFu1c");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu1c(Test_Uc_BFu0c_BFu1c, "Uc_BFu0c_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu1i  {
  unsigned char v1;
  unsigned char  :0;
  unsigned int v2:1;
};
//SIG(1 Uc_BFu0c_BFu1i) C1{ Fc Fc:0 Fi:1}



static void Test_Uc_BFu0c_BFu1i()
{
  {
    init_simple_test("Uc_BFu0c_BFu1i");
    static Uc_BFu0c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0c_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu0c_BFu1i");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu1i(Test_Uc_BFu0c_BFu1i, "Uc_BFu0c_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu1ll  {
  unsigned char v1;
  unsigned char  :0;
  __tsu64 v2:1;
};
//SIG(1 Uc_BFu0c_BFu1ll) C1{ Fc Fc:0 FL:1}



static void Test_Uc_BFu0c_BFu1ll()
{
  {
    init_simple_test("Uc_BFu0c_BFu1ll");
    static Uc_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu0c_BFu1ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu1ll(Test_Uc_BFu0c_BFu1ll, "Uc_BFu0c_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu1s  {
  unsigned char v1;
  unsigned char  :0;
  unsigned short v2:1;
};
//SIG(1 Uc_BFu0c_BFu1s) C1{ Fc Fc:0 Fs:1}



static void Test_Uc_BFu0c_BFu1s()
{
  {
    init_simple_test("Uc_BFu0c_BFu1s");
    static Uc_BFu0c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu0c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0c_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu0c_BFu1s");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu1s(Test_Uc_BFu0c_BFu1s, "Uc_BFu0c_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu31i  {
  unsigned char v1;
  unsigned char  :0;
  unsigned int v2:31;
};
//SIG(1 Uc_BFu0c_BFu31i) C1{ Fc Fc:0 Fi:31}



static void Test_Uc_BFu0c_BFu31i()
{
  {
    init_simple_test("Uc_BFu0c_BFu31i");
    static Uc_BFu0c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0c_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Uc_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Uc_BFu0c_BFu31i");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu31i(Test_Uc_BFu0c_BFu31i, "Uc_BFu0c_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu31ll  {
  unsigned char v1;
  unsigned char  :0;
  __tsu64 v2:31;
};
//SIG(1 Uc_BFu0c_BFu31ll) C1{ Fc Fc:0 FL:31}



static void Test_Uc_BFu0c_BFu31ll()
{
  {
    init_simple_test("Uc_BFu0c_BFu31ll");
    static Uc_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu0c_BFu31ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu31ll(Test_Uc_BFu0c_BFu31ll, "Uc_BFu0c_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu32i  {
  unsigned char v1;
  unsigned char  :0;
  unsigned int v2:32;
};
//SIG(1 Uc_BFu0c_BFu32i) C1{ Fc Fc:0 Fi:32}



static void Test_Uc_BFu0c_BFu32i()
{
  {
    init_simple_test("Uc_BFu0c_BFu32i");
    static Uc_BFu0c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0c_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Uc_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Uc_BFu0c_BFu32i");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu32i(Test_Uc_BFu0c_BFu32i, "Uc_BFu0c_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu32ll  {
  unsigned char v1;
  unsigned char  :0;
  __tsu64 v2:32;
};
//SIG(1 Uc_BFu0c_BFu32ll) C1{ Fc Fc:0 FL:32}



static void Test_Uc_BFu0c_BFu32ll()
{
  {
    init_simple_test("Uc_BFu0c_BFu32ll");
    static Uc_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu0c_BFu32ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu32ll(Test_Uc_BFu0c_BFu32ll, "Uc_BFu0c_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu33  {
  unsigned char v1;
  unsigned char  :0;
  __tsu64 v2:33;
};
//SIG(1 Uc_BFu0c_BFu33) C1{ Fc Fc:0 FL:33}



static void Test_Uc_BFu0c_BFu33()
{
  {
    init_simple_test("Uc_BFu0c_BFu33");
    static Uc_BFu0c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu0c_BFu33");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu33(Test_Uc_BFu0c_BFu33, "Uc_BFu0c_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu7c  {
  unsigned char v1;
  unsigned char  :0;
  unsigned char v2:7;
};
//SIG(1 Uc_BFu0c_BFu7c) C1{ Fc Fc:0 Fc:7}



static void Test_Uc_BFu0c_BFu7c()
{
  {
    init_simple_test("Uc_BFu0c_BFu7c");
    static Uc_BFu0c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu0c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu0c_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu0c_BFu7c");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu7c(Test_Uc_BFu0c_BFu7c, "Uc_BFu0c_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu7i  {
  unsigned char v1;
  unsigned char  :0;
  unsigned int v2:7;
};
//SIG(1 Uc_BFu0c_BFu7i) C1{ Fc Fc:0 Fi:7}



static void Test_Uc_BFu0c_BFu7i()
{
  {
    init_simple_test("Uc_BFu0c_BFu7i");
    static Uc_BFu0c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0c_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu0c_BFu7i");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu7i(Test_Uc_BFu0c_BFu7i, "Uc_BFu0c_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu7ll  {
  unsigned char v1;
  unsigned char  :0;
  __tsu64 v2:7;
};
//SIG(1 Uc_BFu0c_BFu7ll) C1{ Fc Fc:0 FL:7}



static void Test_Uc_BFu0c_BFu7ll()
{
  {
    init_simple_test("Uc_BFu0c_BFu7ll");
    static Uc_BFu0c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu0c_BFu7ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu7ll(Test_Uc_BFu0c_BFu7ll, "Uc_BFu0c_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu7s  {
  unsigned char v1;
  unsigned char  :0;
  unsigned short v2:7;
};
//SIG(1 Uc_BFu0c_BFu7s) C1{ Fc Fc:0 Fs:7}



static void Test_Uc_BFu0c_BFu7s()
{
  {
    init_simple_test("Uc_BFu0c_BFu7s");
    static Uc_BFu0c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu0c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0c_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu0c_BFu7s");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu7s(Test_Uc_BFu0c_BFu7s, "Uc_BFu0c_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu8c  {
  unsigned char v1;
  unsigned char  :0;
  unsigned char v2:8;
};
//SIG(1 Uc_BFu0c_BFu8c) C1{ Fc Fc:0 Fc:8}



static void Test_Uc_BFu0c_BFu8c()
{
  {
    init_simple_test("Uc_BFu0c_BFu8c");
    static Uc_BFu0c_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu0c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu0c_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu0c_BFu8c");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu8c(Test_Uc_BFu0c_BFu8c, "Uc_BFu0c_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu8i  {
  unsigned char v1;
  unsigned char  :0;
  unsigned int v2:8;
};
//SIG(1 Uc_BFu0c_BFu8i) C1{ Fc Fc:0 Fi:8}



static void Test_Uc_BFu0c_BFu8i()
{
  {
    init_simple_test("Uc_BFu0c_BFu8i");
    static Uc_BFu0c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0c_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu0c_BFu8i");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu8i(Test_Uc_BFu0c_BFu8i, "Uc_BFu0c_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu8ll  {
  unsigned char v1;
  unsigned char  :0;
  __tsu64 v2:8;
};
//SIG(1 Uc_BFu0c_BFu8ll) C1{ Fc Fc:0 FL:8}



static void Test_Uc_BFu0c_BFu8ll()
{
  {
    init_simple_test("Uc_BFu0c_BFu8ll");
    static Uc_BFu0c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu0c_BFu8ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu8ll(Test_Uc_BFu0c_BFu8ll, "Uc_BFu0c_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu8s  {
  unsigned char v1;
  unsigned char  :0;
  unsigned short v2:8;
};
//SIG(1 Uc_BFu0c_BFu8s) C1{ Fc Fc:0 Fs:8}



static void Test_Uc_BFu0c_BFu8s()
{
  {
    init_simple_test("Uc_BFu0c_BFu8s");
    static Uc_BFu0c_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu0c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0c_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu0c_BFu8s");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu8s(Test_Uc_BFu0c_BFu8s, "Uc_BFu0c_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu9i  {
  unsigned char v1;
  unsigned char  :0;
  unsigned int v2:9;
};
//SIG(1 Uc_BFu0c_BFu9i) C1{ Fc Fc:0 Fi:9}



static void Test_Uc_BFu0c_BFu9i()
{
  {
    init_simple_test("Uc_BFu0c_BFu9i");
    static Uc_BFu0c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0c_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu0c_BFu9i");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu9i(Test_Uc_BFu0c_BFu9i, "Uc_BFu0c_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu9ll  {
  unsigned char v1;
  unsigned char  :0;
  __tsu64 v2:9;
};
//SIG(1 Uc_BFu0c_BFu9ll) C1{ Fc Fc:0 FL:9}



static void Test_Uc_BFu0c_BFu9ll()
{
  {
    init_simple_test("Uc_BFu0c_BFu9ll");
    static Uc_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu0c_BFu9ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu9ll(Test_Uc_BFu0c_BFu9ll, "Uc_BFu0c_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_BFu9s  {
  unsigned char v1;
  unsigned char  :0;
  unsigned short v2:9;
};
//SIG(1 Uc_BFu0c_BFu9s) C1{ Fc Fc:0 Fs:9}



static void Test_Uc_BFu0c_BFu9s()
{
  {
    init_simple_test("Uc_BFu0c_BFu9s");
    static Uc_BFu0c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0c_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Uc_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu0c_BFu9s");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_BFu9s(Test_Uc_BFu0c_BFu9s, "Uc_BFu0c_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_C  {
  unsigned char v1;
  unsigned char  :0;
  char v2;
};
//SIG(1 Uc_BFu0c_C) C1{ Fc Fc:0 Fc}



static void Test_Uc_BFu0c_C()
{
  {
    init_simple_test("Uc_BFu0c_C");
    static Uc_BFu0c_C lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu0c_C)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu0c_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_C.v1");
    check_field_offset(lv, v2, 1, "Uc_BFu0c_C.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_C(Test_Uc_BFu0c_C, "Uc_BFu0c_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_D  {
  unsigned char v1;
  unsigned char  :0;
  double v2;
};
//SIG(1 Uc_BFu0c_D) C1{ Fc Fc:0 FL}



static void Test_Uc_BFu0c_D()
{
  {
    init_simple_test("Uc_BFu0c_D");
    static Uc_BFu0c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_BFu0c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0c_D.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_D(Test_Uc_BFu0c_D, "Uc_BFu0c_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_F  {
  unsigned char v1;
  unsigned char  :0;
  float v2;
};
//SIG(1 Uc_BFu0c_F) C1{ Fc Fc:0 Fi}



static void Test_Uc_BFu0c_F()
{
  {
    init_simple_test("Uc_BFu0c_F");
    static Uc_BFu0c_F lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0c_F)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0c_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_F.v1");
    check_field_offset(lv, v2, 4, "Uc_BFu0c_F.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_F(Test_Uc_BFu0c_F, "Uc_BFu0c_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_I  {
  unsigned char v1;
  unsigned char  :0;
  int v2;
};
//SIG(1 Uc_BFu0c_I) C1{ Fc Fc:0 Fi}



static void Test_Uc_BFu0c_I()
{
  {
    init_simple_test("Uc_BFu0c_I");
    static Uc_BFu0c_I lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0c_I)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0c_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_I.v1");
    check_field_offset(lv, v2, 4, "Uc_BFu0c_I.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_I(Test_Uc_BFu0c_I, "Uc_BFu0c_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_Ip  {
  unsigned char v1;
  unsigned char  :0;
  int *v2;
};
//SIG(1 Uc_BFu0c_Ip) C1{ Fc Fc:0 Fp}



static void Test_Uc_BFu0c_Ip()
{
  {
    init_simple_test("Uc_BFu0c_Ip");
    static Uc_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0c_Ip.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_Ip(Test_Uc_BFu0c_Ip, "Uc_BFu0c_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_L  {
  unsigned char v1;
  unsigned char  :0;
  __tsi64 v2;
};
//SIG(1 Uc_BFu0c_L) C1{ Fc Fc:0 FL}



static void Test_Uc_BFu0c_L()
{
  {
    init_simple_test("Uc_BFu0c_L");
    static Uc_BFu0c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_BFu0c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0c_L.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_L(Test_Uc_BFu0c_L, "Uc_BFu0c_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_S  {
  unsigned char v1;
  unsigned char  :0;
  short v2;
};
//SIG(1 Uc_BFu0c_S) C1{ Fc Fc:0 Fs}



static void Test_Uc_BFu0c_S()
{
  {
    init_simple_test("Uc_BFu0c_S");
    static Uc_BFu0c_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0c_S)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0c_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_S.v1");
    check_field_offset(lv, v2, 2, "Uc_BFu0c_S.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_S(Test_Uc_BFu0c_S, "Uc_BFu0c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_Uc  {
  unsigned char v1;
  unsigned char  :0;
  unsigned char v2;
};
//SIG(1 Uc_BFu0c_Uc) C1{ Fc Fc:0 Fc}



static void Test_Uc_BFu0c_Uc()
{
  {
    init_simple_test("Uc_BFu0c_Uc");
    static Uc_BFu0c_Uc lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu0c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu0c_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_Uc.v1");
    check_field_offset(lv, v2, 1, "Uc_BFu0c_Uc.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_Uc(Test_Uc_BFu0c_Uc, "Uc_BFu0c_Uc", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_Ui  {
  unsigned char v1;
  unsigned char  :0;
  unsigned int v2;
};
//SIG(1 Uc_BFu0c_Ui) C1{ Fc Fc:0 Fi}



static void Test_Uc_BFu0c_Ui()
{
  {
    init_simple_test("Uc_BFu0c_Ui");
    static Uc_BFu0c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0c_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_Ui.v1");
    check_field_offset(lv, v2, 4, "Uc_BFu0c_Ui.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_Ui(Test_Uc_BFu0c_Ui, "Uc_BFu0c_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_Ul  {
  unsigned char v1;
  unsigned char  :0;
  __tsu64 v2;
};
//SIG(1 Uc_BFu0c_Ul) C1{ Fc Fc:0 FL}



static void Test_Uc_BFu0c_Ul()
{
  {
    init_simple_test("Uc_BFu0c_Ul");
    static Uc_BFu0c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_BFu0c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0c_Ul.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_Ul(Test_Uc_BFu0c_Ul, "Uc_BFu0c_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_Us  {
  unsigned char v1;
  unsigned char  :0;
  unsigned short v2;
};
//SIG(1 Uc_BFu0c_Us) C1{ Fc Fc:0 Fs}



static void Test_Uc_BFu0c_Us()
{
  {
    init_simple_test("Uc_BFu0c_Us");
    static Uc_BFu0c_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0c_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_Us.v1");
    check_field_offset(lv, v2, 2, "Uc_BFu0c_Us.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_Us(Test_Uc_BFu0c_Us, "Uc_BFu0c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0c_Vp  {
  unsigned char v1;
  unsigned char  :0;
  void *v2;
};
//SIG(1 Uc_BFu0c_Vp) C1{ Fc Fc:0 Fp}



static void Test_Uc_BFu0c_Vp()
{
  {
    init_simple_test("Uc_BFu0c_Vp");
    static Uc_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0c_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu0c_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0c_Vp.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0c_Vp(Test_Uc_BFu0c_Vp, "Uc_BFu0c_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i  {
  unsigned char v1;
  unsigned int  :0;
};
//SIG(1 Uc_BFu0i) C1{ Fc Fi:0}



static void Test_Uc_BFu0i()
{
  {
    init_simple_test("Uc_BFu0i");
    static Uc_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0i(Test_Uc_BFu0i, "Uc_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu0c  {
  unsigned char v1;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 Uc_BFu0i_BFu0c) C1{ Fc Fi:0 Fc:0}



static void Test_Uc_BFu0i_BFu0c()
{
  {
    init_simple_test("Uc_BFu0i_BFu0c");
    static Uc_BFu0i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0i_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu0c(Test_Uc_BFu0i_BFu0c, "Uc_BFu0i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu0i  {
  unsigned char v1;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 Uc_BFu0i_BFu0i) C1{ Fc Fi:0 Fi:0}



static void Test_Uc_BFu0i_BFu0i()
{
  {
    init_simple_test("Uc_BFu0i_BFu0i");
    static Uc_BFu0i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0i_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu0i(Test_Uc_BFu0i_BFu0i, "Uc_BFu0i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu0ll  {
  unsigned char v1;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 Uc_BFu0i_BFu0ll) C1{ Fc Fi:0 FL:0}



static void Test_Uc_BFu0i_BFu0ll()
{
  {
    init_simple_test("Uc_BFu0i_BFu0ll");
    static Uc_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu0ll(Test_Uc_BFu0i_BFu0ll, "Uc_BFu0i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu0s  {
  unsigned char v1;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 Uc_BFu0i_BFu0s) C1{ Fc Fi:0 Fs:0}



static void Test_Uc_BFu0i_BFu0s()
{
  {
    init_simple_test("Uc_BFu0i_BFu0s");
    static Uc_BFu0i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0i_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu0s(Test_Uc_BFu0i_BFu0s, "Uc_BFu0i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu15i  {
  unsigned char v1;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 Uc_BFu0i_BFu15i) C1{ Fc Fi:0 Fi:15}



static void Test_Uc_BFu0i_BFu15i()
{
  {
    init_simple_test("Uc_BFu0i_BFu15i");
    static Uc_BFu0i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0i_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Uc_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Uc_BFu0i_BFu15i");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu15i(Test_Uc_BFu0i_BFu15i, "Uc_BFu0i_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu15ll  {
  unsigned char v1;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 Uc_BFu0i_BFu15ll) C1{ Fc Fi:0 FL:15}



static void Test_Uc_BFu0i_BFu15ll()
{
  {
    init_simple_test("Uc_BFu0i_BFu15ll");
    static Uc_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Uc_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Uc_BFu0i_BFu15ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu15ll(Test_Uc_BFu0i_BFu15ll, "Uc_BFu0i_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu15s  {
  unsigned char v1;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 Uc_BFu0i_BFu15s) C1{ Fc Fi:0 Fs:15}



static void Test_Uc_BFu0i_BFu15s()
{
  {
    init_simple_test("Uc_BFu0i_BFu15s");
    static Uc_BFu0i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(Uc_BFu0i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0i_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Uc_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Uc_BFu0i_BFu15s");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu15s(Test_Uc_BFu0i_BFu15s, "Uc_BFu0i_BFu15s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu16i  {
  unsigned char v1;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 Uc_BFu0i_BFu16i) C1{ Fc Fi:0 Fi:16}



static void Test_Uc_BFu0i_BFu16i()
{
  {
    init_simple_test("Uc_BFu0i_BFu16i");
    static Uc_BFu0i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0i_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Uc_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Uc_BFu0i_BFu16i");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu16i(Test_Uc_BFu0i_BFu16i, "Uc_BFu0i_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu16ll  {
  unsigned char v1;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 Uc_BFu0i_BFu16ll) C1{ Fc Fi:0 FL:16}



static void Test_Uc_BFu0i_BFu16ll()
{
  {
    init_simple_test("Uc_BFu0i_BFu16ll");
    static Uc_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Uc_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Uc_BFu0i_BFu16ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu16ll(Test_Uc_BFu0i_BFu16ll, "Uc_BFu0i_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu16s  {
  unsigned char v1;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 Uc_BFu0i_BFu16s) C1{ Fc Fi:0 Fs:16}



static void Test_Uc_BFu0i_BFu16s()
{
  {
    init_simple_test("Uc_BFu0i_BFu16s");
    static Uc_BFu0i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(Uc_BFu0i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0i_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Uc_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Uc_BFu0i_BFu16s");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu16s(Test_Uc_BFu0i_BFu16s, "Uc_BFu0i_BFu16s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu17i  {
  unsigned char v1;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 Uc_BFu0i_BFu17i) C1{ Fc Fi:0 Fi:17}



static void Test_Uc_BFu0i_BFu17i()
{
  {
    init_simple_test("Uc_BFu0i_BFu17i");
    static Uc_BFu0i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0i_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Uc_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Uc_BFu0i_BFu17i");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu17i(Test_Uc_BFu0i_BFu17i, "Uc_BFu0i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu17ll  {
  unsigned char v1;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 Uc_BFu0i_BFu17ll) C1{ Fc Fi:0 FL:17}



static void Test_Uc_BFu0i_BFu17ll()
{
  {
    init_simple_test("Uc_BFu0i_BFu17ll");
    static Uc_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Uc_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Uc_BFu0i_BFu17ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu17ll(Test_Uc_BFu0i_BFu17ll, "Uc_BFu0i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu1c  {
  unsigned char v1;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 Uc_BFu0i_BFu1c) C1{ Fc Fi:0 Fc:1}



static void Test_Uc_BFu0i_BFu1c()
{
  {
    init_simple_test("Uc_BFu0i_BFu1c");
    static Uc_BFu0i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(Uc_BFu0i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0i_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Uc_BFu0i_BFu1c");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu1c(Test_Uc_BFu0i_BFu1c, "Uc_BFu0i_BFu1c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu1i  {
  unsigned char v1;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 Uc_BFu0i_BFu1i) C1{ Fc Fi:0 Fi:1}



static void Test_Uc_BFu0i_BFu1i()
{
  {
    init_simple_test("Uc_BFu0i_BFu1i");
    static Uc_BFu0i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0i_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Uc_BFu0i_BFu1i");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu1i(Test_Uc_BFu0i_BFu1i, "Uc_BFu0i_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu1ll  {
  unsigned char v1;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 Uc_BFu0i_BFu1ll) C1{ Fc Fi:0 FL:1}



static void Test_Uc_BFu0i_BFu1ll()
{
  {
    init_simple_test("Uc_BFu0i_BFu1ll");
    static Uc_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Uc_BFu0i_BFu1ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu1ll(Test_Uc_BFu0i_BFu1ll, "Uc_BFu0i_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu1s  {
  unsigned char v1;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 Uc_BFu0i_BFu1s) C1{ Fc Fi:0 Fs:1}



static void Test_Uc_BFu0i_BFu1s()
{
  {
    init_simple_test("Uc_BFu0i_BFu1s");
    static Uc_BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(Uc_BFu0i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0i_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Uc_BFu0i_BFu1s");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu1s(Test_Uc_BFu0i_BFu1s, "Uc_BFu0i_BFu1s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu31i  {
  unsigned char v1;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 Uc_BFu0i_BFu31i) C1{ Fc Fi:0 Fi:31}



static void Test_Uc_BFu0i_BFu31i()
{
  {
    init_simple_test("Uc_BFu0i_BFu31i");
    static Uc_BFu0i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0i_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Uc_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Uc_BFu0i_BFu31i");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu31i(Test_Uc_BFu0i_BFu31i, "Uc_BFu0i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu31ll  {
  unsigned char v1;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 Uc_BFu0i_BFu31ll) C1{ Fc Fi:0 FL:31}



static void Test_Uc_BFu0i_BFu31ll()
{
  {
    init_simple_test("Uc_BFu0i_BFu31ll");
    static Uc_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Uc_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Uc_BFu0i_BFu31ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu31ll(Test_Uc_BFu0i_BFu31ll, "Uc_BFu0i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu32i  {
  unsigned char v1;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 Uc_BFu0i_BFu32i) C1{ Fc Fi:0 Fi:32}



static void Test_Uc_BFu0i_BFu32i()
{
  {
    init_simple_test("Uc_BFu0i_BFu32i");
    static Uc_BFu0i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0i_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Uc_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Uc_BFu0i_BFu32i");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu32i(Test_Uc_BFu0i_BFu32i, "Uc_BFu0i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu32ll  {
  unsigned char v1;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 Uc_BFu0i_BFu32ll) C1{ Fc Fi:0 FL:32}



static void Test_Uc_BFu0i_BFu32ll()
{
  {
    init_simple_test("Uc_BFu0i_BFu32ll");
    static Uc_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Uc_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Uc_BFu0i_BFu32ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu32ll(Test_Uc_BFu0i_BFu32ll, "Uc_BFu0i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu33  {
  unsigned char v1;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 Uc_BFu0i_BFu33) C1{ Fc Fi:0 FL:33}



static void Test_Uc_BFu0i_BFu33()
{
  {
    init_simple_test("Uc_BFu0i_BFu33");
    static Uc_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Uc_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Uc_BFu0i_BFu33");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu33(Test_Uc_BFu0i_BFu33, "Uc_BFu0i_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu7c  {
  unsigned char v1;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 Uc_BFu0i_BFu7c) C1{ Fc Fi:0 Fc:7}



static void Test_Uc_BFu0i_BFu7c()
{
  {
    init_simple_test("Uc_BFu0i_BFu7c");
    static Uc_BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(Uc_BFu0i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0i_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Uc_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Uc_BFu0i_BFu7c");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu7c(Test_Uc_BFu0i_BFu7c, "Uc_BFu0i_BFu7c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu7i  {
  unsigned char v1;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 Uc_BFu0i_BFu7i) C1{ Fc Fi:0 Fi:7}



static void Test_Uc_BFu0i_BFu7i()
{
  {
    init_simple_test("Uc_BFu0i_BFu7i");
    static Uc_BFu0i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0i_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Uc_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Uc_BFu0i_BFu7i");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu7i(Test_Uc_BFu0i_BFu7i, "Uc_BFu0i_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu7ll  {
  unsigned char v1;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 Uc_BFu0i_BFu7ll) C1{ Fc Fi:0 FL:7}



static void Test_Uc_BFu0i_BFu7ll()
{
  {
    init_simple_test("Uc_BFu0i_BFu7ll");
    static Uc_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Uc_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Uc_BFu0i_BFu7ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu7ll(Test_Uc_BFu0i_BFu7ll, "Uc_BFu0i_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu7s  {
  unsigned char v1;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 Uc_BFu0i_BFu7s) C1{ Fc Fi:0 Fs:7}



static void Test_Uc_BFu0i_BFu7s()
{
  {
    init_simple_test("Uc_BFu0i_BFu7s");
    static Uc_BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(Uc_BFu0i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0i_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Uc_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Uc_BFu0i_BFu7s");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu7s(Test_Uc_BFu0i_BFu7s, "Uc_BFu0i_BFu7s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu8c  {
  unsigned char v1;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 Uc_BFu0i_BFu8c) C1{ Fc Fi:0 Fc:8}



static void Test_Uc_BFu0i_BFu8c()
{
  {
    init_simple_test("Uc_BFu0i_BFu8c");
    static Uc_BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(Uc_BFu0i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0i_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Uc_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Uc_BFu0i_BFu8c");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu8c(Test_Uc_BFu0i_BFu8c, "Uc_BFu0i_BFu8c", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu8i  {
  unsigned char v1;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 Uc_BFu0i_BFu8i) C1{ Fc Fi:0 Fi:8}



static void Test_Uc_BFu0i_BFu8i()
{
  {
    init_simple_test("Uc_BFu0i_BFu8i");
    static Uc_BFu0i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0i_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Uc_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Uc_BFu0i_BFu8i");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu8i(Test_Uc_BFu0i_BFu8i, "Uc_BFu0i_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu8ll  {
  unsigned char v1;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 Uc_BFu0i_BFu8ll) C1{ Fc Fi:0 FL:8}



static void Test_Uc_BFu0i_BFu8ll()
{
  {
    init_simple_test("Uc_BFu0i_BFu8ll");
    static Uc_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Uc_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Uc_BFu0i_BFu8ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu8ll(Test_Uc_BFu0i_BFu8ll, "Uc_BFu0i_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu8s  {
  unsigned char v1;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 Uc_BFu0i_BFu8s) C1{ Fc Fi:0 Fs:8}



static void Test_Uc_BFu0i_BFu8s()
{
  {
    init_simple_test("Uc_BFu0i_BFu8s");
    static Uc_BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(Uc_BFu0i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0i_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Uc_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Uc_BFu0i_BFu8s");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu8s(Test_Uc_BFu0i_BFu8s, "Uc_BFu0i_BFu8s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu9i  {
  unsigned char v1;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 Uc_BFu0i_BFu9i) C1{ Fc Fi:0 Fi:9}



static void Test_Uc_BFu0i_BFu9i()
{
  {
    init_simple_test("Uc_BFu0i_BFu9i");
    static Uc_BFu0i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0i_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Uc_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Uc_BFu0i_BFu9i");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu9i(Test_Uc_BFu0i_BFu9i, "Uc_BFu0i_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu9ll  {
  unsigned char v1;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 Uc_BFu0i_BFu9ll) C1{ Fc Fi:0 FL:9}



static void Test_Uc_BFu0i_BFu9ll()
{
  {
    init_simple_test("Uc_BFu0i_BFu9ll");
    static Uc_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Uc_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Uc_BFu0i_BFu9ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu9ll(Test_Uc_BFu0i_BFu9ll, "Uc_BFu0i_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_BFu9s  {
  unsigned char v1;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 Uc_BFu0i_BFu9s) C1{ Fc Fi:0 Fs:9}



static void Test_Uc_BFu0i_BFu9s()
{
  {
    init_simple_test("Uc_BFu0i_BFu9s");
    static Uc_BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(Uc_BFu0i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0i_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Uc_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Uc_BFu0i_BFu9s");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_BFu9s(Test_Uc_BFu0i_BFu9s, "Uc_BFu0i_BFu9s", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_C  {
  unsigned char v1;
  unsigned int  :0;
  char v2;
};
//SIG(1 Uc_BFu0i_C) C1{ Fc Fi:0 Fc}



static void Test_Uc_BFu0i_C()
{
  {
    init_simple_test("Uc_BFu0i_C");
    static Uc_BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(Uc_BFu0i_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0i_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_C.v1");
    check_field_offset(lv, v2, 4, "Uc_BFu0i_C.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_C(Test_Uc_BFu0i_C, "Uc_BFu0i_C", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_D  {
  unsigned char v1;
  unsigned int  :0;
  double v2;
};
//SIG(1 Uc_BFu0i_D) C1{ Fc Fi:0 FL}



static void Test_Uc_BFu0i_D()
{
  {
    init_simple_test("Uc_BFu0i_D");
    static Uc_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0i_D.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_D(Test_Uc_BFu0i_D, "Uc_BFu0i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_F  {
  unsigned char v1;
  unsigned int  :0;
  float v2;
};
//SIG(1 Uc_BFu0i_F) C1{ Fc Fi:0 Fi}



static void Test_Uc_BFu0i_F()
{
  {
    init_simple_test("Uc_BFu0i_F");
    static Uc_BFu0i_F lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0i_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_F.v1");
    check_field_offset(lv, v2, 4, "Uc_BFu0i_F.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_F(Test_Uc_BFu0i_F, "Uc_BFu0i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_I  {
  unsigned char v1;
  unsigned int  :0;
  int v2;
};
//SIG(1 Uc_BFu0i_I) C1{ Fc Fi:0 Fi}



static void Test_Uc_BFu0i_I()
{
  {
    init_simple_test("Uc_BFu0i_I");
    static Uc_BFu0i_I lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0i_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_I.v1");
    check_field_offset(lv, v2, 4, "Uc_BFu0i_I.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_I(Test_Uc_BFu0i_I, "Uc_BFu0i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_Ip  {
  unsigned char v1;
  unsigned int  :0;
  int *v2;
};
//SIG(1 Uc_BFu0i_Ip) C1{ Fc Fi:0 Fp}



static void Test_Uc_BFu0i_Ip()
{
  {
    init_simple_test("Uc_BFu0i_Ip");
    static Uc_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0i_Ip.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_Ip(Test_Uc_BFu0i_Ip, "Uc_BFu0i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_L  {
  unsigned char v1;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 Uc_BFu0i_L) C1{ Fc Fi:0 FL}



static void Test_Uc_BFu0i_L()
{
  {
    init_simple_test("Uc_BFu0i_L");
    static Uc_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0i_L.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_L(Test_Uc_BFu0i_L, "Uc_BFu0i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_S  {
  unsigned char v1;
  unsigned int  :0;
  short v2;
};
//SIG(1 Uc_BFu0i_S) C1{ Fc Fi:0 Fs}



static void Test_Uc_BFu0i_S()
{
  {
    init_simple_test("Uc_BFu0i_S");
    static Uc_BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(Uc_BFu0i_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0i_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_S.v1");
    check_field_offset(lv, v2, 4, "Uc_BFu0i_S.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_S(Test_Uc_BFu0i_S, "Uc_BFu0i_S", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_Uc  {
  unsigned char v1;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 Uc_BFu0i_Uc) C1{ Fc Fi:0 Fc}



static void Test_Uc_BFu0i_Uc()
{
  {
    init_simple_test("Uc_BFu0i_Uc");
    static Uc_BFu0i_Uc lv;
    check2(sizeof(lv), ABISELECT(5,5), "sizeof(Uc_BFu0i_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0i_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_Uc.v1");
    check_field_offset(lv, v2, 4, "Uc_BFu0i_Uc.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_Uc(Test_Uc_BFu0i_Uc, "Uc_BFu0i_Uc", ABISELECT(5,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_Ui  {
  unsigned char v1;
  unsigned int  :0;
  unsigned int v2;
};
//SIG(1 Uc_BFu0i_Ui) C1{ Fc Fi:0 Fi}



static void Test_Uc_BFu0i_Ui()
{
  {
    init_simple_test("Uc_BFu0i_Ui");
    static Uc_BFu0i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0i_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_Ui.v1");
    check_field_offset(lv, v2, 4, "Uc_BFu0i_Ui.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_Ui(Test_Uc_BFu0i_Ui, "Uc_BFu0i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_Ul  {
  unsigned char v1;
  unsigned int  :0;
  __tsu64 v2;
};
//SIG(1 Uc_BFu0i_Ul) C1{ Fc Fi:0 FL}



static void Test_Uc_BFu0i_Ul()
{
  {
    init_simple_test("Uc_BFu0i_Ul");
    static Uc_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0i_Ul.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_Ul(Test_Uc_BFu0i_Ul, "Uc_BFu0i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_Us  {
  unsigned char v1;
  unsigned int  :0;
  unsigned short v2;
};
//SIG(1 Uc_BFu0i_Us) C1{ Fc Fi:0 Fs}



static void Test_Uc_BFu0i_Us()
{
  {
    init_simple_test("Uc_BFu0i_Us");
    static Uc_BFu0i_Us lv;
    check2(sizeof(lv), ABISELECT(6,6), "sizeof(Uc_BFu0i_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0i_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_Us.v1");
    check_field_offset(lv, v2, 4, "Uc_BFu0i_Us.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_Us(Test_Uc_BFu0i_Us, "Uc_BFu0i_Us", ABISELECT(6,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0i_Vp  {
  unsigned char v1;
  unsigned int  :0;
  void *v2;
};
//SIG(1 Uc_BFu0i_Vp) C1{ Fc Fi:0 Fp}



static void Test_Uc_BFu0i_Vp()
{
  {
    init_simple_test("Uc_BFu0i_Vp");
    static Uc_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0i_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu0i_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0i_Vp.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0i_Vp(Test_Uc_BFu0i_Vp, "Uc_BFu0i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll  {
  unsigned char v1;
  __tsu64  :0;
};
//SIG(1 Uc_BFu0ll) C1{ Fc FL:0}



static void Test_Uc_BFu0ll()
{
  {
    init_simple_test("Uc_BFu0ll");
    static Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll(Test_Uc_BFu0ll, "Uc_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu0c  {
  unsigned char v1;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 Uc_BFu0ll_BFu0c) C1{ Fc FL:0 Fc:0}



static void Test_Uc_BFu0ll_BFu0c()
{
  {
    init_simple_test("Uc_BFu0ll_BFu0c");
    static Uc_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu0c(Test_Uc_BFu0ll_BFu0c, "Uc_BFu0ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu0i  {
  unsigned char v1;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 Uc_BFu0ll_BFu0i) C1{ Fc FL:0 Fi:0}



static void Test_Uc_BFu0ll_BFu0i()
{
  {
    init_simple_test("Uc_BFu0ll_BFu0i");
    static Uc_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu0i(Test_Uc_BFu0ll_BFu0i, "Uc_BFu0ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu0ll  {
  unsigned char v1;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 Uc_BFu0ll_BFu0ll) C1{ Fc FL:0 FL:0}



static void Test_Uc_BFu0ll_BFu0ll()
{
  {
    init_simple_test("Uc_BFu0ll_BFu0ll");
    static Uc_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu0ll(Test_Uc_BFu0ll_BFu0ll, "Uc_BFu0ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu0s  {
  unsigned char v1;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 Uc_BFu0ll_BFu0s) C1{ Fc FL:0 Fs:0}



static void Test_Uc_BFu0ll_BFu0s()
{
  {
    init_simple_test("Uc_BFu0ll_BFu0s");
    static Uc_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu0s(Test_Uc_BFu0ll_BFu0s, "Uc_BFu0ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu15i  {
  unsigned char v1;
  __tsu64  :0;
  unsigned int v2:15;
};
//SIG(1 Uc_BFu0ll_BFu15i) C1{ Fc FL:0 Fi:15}



static void Test_Uc_BFu0ll_BFu15i()
{
  {
    init_simple_test("Uc_BFu0ll_BFu15i");
    static Uc_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu0ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Uc_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Uc_BFu0ll_BFu15i");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu15i(Test_Uc_BFu0ll_BFu15i, "Uc_BFu0ll_BFu15i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu15ll  {
  unsigned char v1;
  __tsu64  :0;
  __tsu64 v2:15;
};
//SIG(1 Uc_BFu0ll_BFu15ll) C1{ Fc FL:0 FL:15}



static void Test_Uc_BFu0ll_BFu15ll()
{
  {
    init_simple_test("Uc_BFu0ll_BFu15ll");
    static Uc_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Uc_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Uc_BFu0ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu15ll(Test_Uc_BFu0ll_BFu15ll, "Uc_BFu0ll_BFu15ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu15s  {
  unsigned char v1;
  __tsu64  :0;
  unsigned short v2:15;
};
//SIG(1 Uc_BFu0ll_BFu15s) C1{ Fc FL:0 Fs:15}



static void Test_Uc_BFu0ll_BFu15s()
{
  {
    init_simple_test("Uc_BFu0ll_BFu15s");
    static Uc_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Uc_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Uc_BFu0ll_BFu15s");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu15s(Test_Uc_BFu0ll_BFu15s, "Uc_BFu0ll_BFu15s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu16i  {
  unsigned char v1;
  __tsu64  :0;
  unsigned int v2:16;
};
//SIG(1 Uc_BFu0ll_BFu16i) C1{ Fc FL:0 Fi:16}



static void Test_Uc_BFu0ll_BFu16i()
{
  {
    init_simple_test("Uc_BFu0ll_BFu16i");
    static Uc_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu0ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Uc_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Uc_BFu0ll_BFu16i");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu16i(Test_Uc_BFu0ll_BFu16i, "Uc_BFu0ll_BFu16i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu16ll  {
  unsigned char v1;
  __tsu64  :0;
  __tsu64 v2:16;
};
//SIG(1 Uc_BFu0ll_BFu16ll) C1{ Fc FL:0 FL:16}



static void Test_Uc_BFu0ll_BFu16ll()
{
  {
    init_simple_test("Uc_BFu0ll_BFu16ll");
    static Uc_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Uc_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Uc_BFu0ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu16ll(Test_Uc_BFu0ll_BFu16ll, "Uc_BFu0ll_BFu16ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu16s  {
  unsigned char v1;
  __tsu64  :0;
  unsigned short v2:16;
};
//SIG(1 Uc_BFu0ll_BFu16s) C1{ Fc FL:0 Fs:16}



static void Test_Uc_BFu0ll_BFu16s()
{
  {
    init_simple_test("Uc_BFu0ll_BFu16s");
    static Uc_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Uc_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Uc_BFu0ll_BFu16s");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu16s(Test_Uc_BFu0ll_BFu16s, "Uc_BFu0ll_BFu16s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu17i  {
  unsigned char v1;
  __tsu64  :0;
  unsigned int v2:17;
};
//SIG(1 Uc_BFu0ll_BFu17i) C1{ Fc FL:0 Fi:17}



static void Test_Uc_BFu0ll_BFu17i()
{
  {
    init_simple_test("Uc_BFu0ll_BFu17i");
    static Uc_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu0ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Uc_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Uc_BFu0ll_BFu17i");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu17i(Test_Uc_BFu0ll_BFu17i, "Uc_BFu0ll_BFu17i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu17ll  {
  unsigned char v1;
  __tsu64  :0;
  __tsu64 v2:17;
};
//SIG(1 Uc_BFu0ll_BFu17ll) C1{ Fc FL:0 FL:17}



static void Test_Uc_BFu0ll_BFu17ll()
{
  {
    init_simple_test("Uc_BFu0ll_BFu17ll");
    static Uc_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Uc_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Uc_BFu0ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu17ll(Test_Uc_BFu0ll_BFu17ll, "Uc_BFu0ll_BFu17ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu1c  {
  unsigned char v1;
  __tsu64  :0;
  unsigned char v2:1;
};
//SIG(1 Uc_BFu0ll_BFu1c) C1{ Fc FL:0 Fc:1}



static void Test_Uc_BFu0ll_BFu1c()
{
  {
    init_simple_test("Uc_BFu0ll_BFu1c");
    static Uc_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Uc_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Uc_BFu0ll_BFu1c");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu1c(Test_Uc_BFu0ll_BFu1c, "Uc_BFu0ll_BFu1c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu1i  {
  unsigned char v1;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 Uc_BFu0ll_BFu1i) C1{ Fc FL:0 Fi:1}



static void Test_Uc_BFu0ll_BFu1i()
{
  {
    init_simple_test("Uc_BFu0ll_BFu1i");
    static Uc_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu0ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Uc_BFu0ll_BFu1i");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu1i(Test_Uc_BFu0ll_BFu1i, "Uc_BFu0ll_BFu1i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu1ll  {
  unsigned char v1;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 Uc_BFu0ll_BFu1ll) C1{ Fc FL:0 FL:1}



static void Test_Uc_BFu0ll_BFu1ll()
{
  {
    init_simple_test("Uc_BFu0ll_BFu1ll");
    static Uc_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Uc_BFu0ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu1ll(Test_Uc_BFu0ll_BFu1ll, "Uc_BFu0ll_BFu1ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu1s  {
  unsigned char v1;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 Uc_BFu0ll_BFu1s) C1{ Fc FL:0 Fs:1}



static void Test_Uc_BFu0ll_BFu1s()
{
  {
    init_simple_test("Uc_BFu0ll_BFu1s");
    static Uc_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Uc_BFu0ll_BFu1s");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu1s(Test_Uc_BFu0ll_BFu1s, "Uc_BFu0ll_BFu1s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu31i  {
  unsigned char v1;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 Uc_BFu0ll_BFu31i) C1{ Fc FL:0 Fi:31}



static void Test_Uc_BFu0ll_BFu31i()
{
  {
    init_simple_test("Uc_BFu0ll_BFu31i");
    static Uc_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu0ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Uc_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Uc_BFu0ll_BFu31i");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu31i(Test_Uc_BFu0ll_BFu31i, "Uc_BFu0ll_BFu31i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu31ll  {
  unsigned char v1;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 Uc_BFu0ll_BFu31ll) C1{ Fc FL:0 FL:31}



static void Test_Uc_BFu0ll_BFu31ll()
{
  {
    init_simple_test("Uc_BFu0ll_BFu31ll");
    static Uc_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Uc_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Uc_BFu0ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu31ll(Test_Uc_BFu0ll_BFu31ll, "Uc_BFu0ll_BFu31ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu32i  {
  unsigned char v1;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 Uc_BFu0ll_BFu32i) C1{ Fc FL:0 Fi:32}



static void Test_Uc_BFu0ll_BFu32i()
{
  {
    init_simple_test("Uc_BFu0ll_BFu32i");
    static Uc_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu0ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Uc_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Uc_BFu0ll_BFu32i");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu32i(Test_Uc_BFu0ll_BFu32i, "Uc_BFu0ll_BFu32i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu32ll  {
  unsigned char v1;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 Uc_BFu0ll_BFu32ll) C1{ Fc FL:0 FL:32}



static void Test_Uc_BFu0ll_BFu32ll()
{
  {
    init_simple_test("Uc_BFu0ll_BFu32ll");
    static Uc_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Uc_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Uc_BFu0ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu32ll(Test_Uc_BFu0ll_BFu32ll, "Uc_BFu0ll_BFu32ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu33  {
  unsigned char v1;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 Uc_BFu0ll_BFu33) C1{ Fc FL:0 FL:33}



static void Test_Uc_BFu0ll_BFu33()
{
  {
    init_simple_test("Uc_BFu0ll_BFu33");
    static Uc_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Uc_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Uc_BFu0ll_BFu33");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu33(Test_Uc_BFu0ll_BFu33, "Uc_BFu0ll_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu7c  {
  unsigned char v1;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 Uc_BFu0ll_BFu7c) C1{ Fc FL:0 Fc:7}



static void Test_Uc_BFu0ll_BFu7c()
{
  {
    init_simple_test("Uc_BFu0ll_BFu7c");
    static Uc_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Uc_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Uc_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Uc_BFu0ll_BFu7c");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu7c(Test_Uc_BFu0ll_BFu7c, "Uc_BFu0ll_BFu7c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu7i  {
  unsigned char v1;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 Uc_BFu0ll_BFu7i) C1{ Fc FL:0 Fi:7}



static void Test_Uc_BFu0ll_BFu7i()
{
  {
    init_simple_test("Uc_BFu0ll_BFu7i");
    static Uc_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu0ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Uc_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Uc_BFu0ll_BFu7i");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu7i(Test_Uc_BFu0ll_BFu7i, "Uc_BFu0ll_BFu7i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu7ll  {
  unsigned char v1;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 Uc_BFu0ll_BFu7ll) C1{ Fc FL:0 FL:7}



static void Test_Uc_BFu0ll_BFu7ll()
{
  {
    init_simple_test("Uc_BFu0ll_BFu7ll");
    static Uc_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Uc_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Uc_BFu0ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu7ll(Test_Uc_BFu0ll_BFu7ll, "Uc_BFu0ll_BFu7ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu7s  {
  unsigned char v1;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 Uc_BFu0ll_BFu7s) C1{ Fc FL:0 Fs:7}



static void Test_Uc_BFu0ll_BFu7s()
{
  {
    init_simple_test("Uc_BFu0ll_BFu7s");
    static Uc_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Uc_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Uc_BFu0ll_BFu7s");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu7s(Test_Uc_BFu0ll_BFu7s, "Uc_BFu0ll_BFu7s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu8c  {
  unsigned char v1;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 Uc_BFu0ll_BFu8c) C1{ Fc FL:0 Fc:8}



static void Test_Uc_BFu0ll_BFu8c()
{
  {
    init_simple_test("Uc_BFu0ll_BFu8c");
    static Uc_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Uc_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Uc_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Uc_BFu0ll_BFu8c");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu8c(Test_Uc_BFu0ll_BFu8c, "Uc_BFu0ll_BFu8c", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu8i  {
  unsigned char v1;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 Uc_BFu0ll_BFu8i) C1{ Fc FL:0 Fi:8}



static void Test_Uc_BFu0ll_BFu8i()
{
  {
    init_simple_test("Uc_BFu0ll_BFu8i");
    static Uc_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu0ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Uc_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Uc_BFu0ll_BFu8i");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu8i(Test_Uc_BFu0ll_BFu8i, "Uc_BFu0ll_BFu8i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu8ll  {
  unsigned char v1;
  __tsu64  :0;
  __tsu64 v2:8;
};
//SIG(1 Uc_BFu0ll_BFu8ll) C1{ Fc FL:0 FL:8}



static void Test_Uc_BFu0ll_BFu8ll()
{
  {
    init_simple_test("Uc_BFu0ll_BFu8ll");
    static Uc_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Uc_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Uc_BFu0ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu8ll(Test_Uc_BFu0ll_BFu8ll, "Uc_BFu0ll_BFu8ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu8s  {
  unsigned char v1;
  __tsu64  :0;
  unsigned short v2:8;
};
//SIG(1 Uc_BFu0ll_BFu8s) C1{ Fc FL:0 Fs:8}



static void Test_Uc_BFu0ll_BFu8s()
{
  {
    init_simple_test("Uc_BFu0ll_BFu8s");
    static Uc_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Uc_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Uc_BFu0ll_BFu8s");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu8s(Test_Uc_BFu0ll_BFu8s, "Uc_BFu0ll_BFu8s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu9i  {
  unsigned char v1;
  __tsu64  :0;
  unsigned int v2:9;
};
//SIG(1 Uc_BFu0ll_BFu9i) C1{ Fc FL:0 Fi:9}



static void Test_Uc_BFu0ll_BFu9i()
{
  {
    init_simple_test("Uc_BFu0ll_BFu9i");
    static Uc_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu0ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Uc_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Uc_BFu0ll_BFu9i");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu9i(Test_Uc_BFu0ll_BFu9i, "Uc_BFu0ll_BFu9i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu9ll  {
  unsigned char v1;
  __tsu64  :0;
  __tsu64 v2:9;
};
//SIG(1 Uc_BFu0ll_BFu9ll) C1{ Fc FL:0 FL:9}



static void Test_Uc_BFu0ll_BFu9ll()
{
  {
    init_simple_test("Uc_BFu0ll_BFu9ll");
    static Uc_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Uc_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Uc_BFu0ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu9ll(Test_Uc_BFu0ll_BFu9ll, "Uc_BFu0ll_BFu9ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_BFu9s  {
  unsigned char v1;
  __tsu64  :0;
  unsigned short v2:9;
};
//SIG(1 Uc_BFu0ll_BFu9s) C1{ Fc FL:0 Fs:9}



static void Test_Uc_BFu0ll_BFu9s()
{
  {
    init_simple_test("Uc_BFu0ll_BFu9s");
    static Uc_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Uc_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Uc_BFu0ll_BFu9s");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_BFu9s(Test_Uc_BFu0ll_BFu9s, "Uc_BFu0ll_BFu9s", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_C  {
  unsigned char v1;
  __tsu64  :0;
  char v2;
};
//SIG(1 Uc_BFu0ll_C) C1{ Fc FL:0 Fc}



static void Test_Uc_BFu0ll_C()
{
  {
    init_simple_test("Uc_BFu0ll_C");
    static Uc_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Uc_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0ll_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0ll_C.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_C(Test_Uc_BFu0ll_C, "Uc_BFu0ll_C", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_D  {
  unsigned char v1;
  __tsu64  :0;
  double v2;
};
//SIG(1 Uc_BFu0ll_D) C1{ Fc FL:0 FL}



static void Test_Uc_BFu0ll_D()
{
  {
    init_simple_test("Uc_BFu0ll_D");
    static Uc_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0ll_D.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_D(Test_Uc_BFu0ll_D, "Uc_BFu0ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_F  {
  unsigned char v1;
  __tsu64  :0;
  float v2;
};
//SIG(1 Uc_BFu0ll_F) C1{ Fc FL:0 Fi}



static void Test_Uc_BFu0ll_F()
{
  {
    init_simple_test("Uc_BFu0ll_F");
    static Uc_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu0ll_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0ll_F.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_F(Test_Uc_BFu0ll_F, "Uc_BFu0ll_F", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_I  {
  unsigned char v1;
  __tsu64  :0;
  int v2;
};
//SIG(1 Uc_BFu0ll_I) C1{ Fc FL:0 Fi}



static void Test_Uc_BFu0ll_I()
{
  {
    init_simple_test("Uc_BFu0ll_I");
    static Uc_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu0ll_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0ll_I.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_I(Test_Uc_BFu0ll_I, "Uc_BFu0ll_I", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_Ip  {
  unsigned char v1;
  __tsu64  :0;
  int *v2;
};
//SIG(1 Uc_BFu0ll_Ip) C1{ Fc FL:0 Fp}



static void Test_Uc_BFu0ll_Ip()
{
  {
    init_simple_test("Uc_BFu0ll_Ip");
    static Uc_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_Ip(Test_Uc_BFu0ll_Ip, "Uc_BFu0ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_L  {
  unsigned char v1;
  __tsu64  :0;
  __tsi64 v2;
};
//SIG(1 Uc_BFu0ll_L) C1{ Fc FL:0 FL}



static void Test_Uc_BFu0ll_L()
{
  {
    init_simple_test("Uc_BFu0ll_L");
    static Uc_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0ll_L.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_L(Test_Uc_BFu0ll_L, "Uc_BFu0ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_S  {
  unsigned char v1;
  __tsu64  :0;
  short v2;
};
//SIG(1 Uc_BFu0ll_S) C1{ Fc FL:0 Fs}



static void Test_Uc_BFu0ll_S()
{
  {
    init_simple_test("Uc_BFu0ll_S");
    static Uc_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0ll_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0ll_S.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_S(Test_Uc_BFu0ll_S, "Uc_BFu0ll_S", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_Uc  {
  unsigned char v1;
  __tsu64  :0;
  unsigned char v2;
};
//SIG(1 Uc_BFu0ll_Uc) C1{ Fc FL:0 Fc}



static void Test_Uc_BFu0ll_Uc()
{
  {
    init_simple_test("Uc_BFu0ll_Uc");
    static Uc_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(Uc_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0ll_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_Uc(Test_Uc_BFu0ll_Uc, "Uc_BFu0ll_Uc", ABISELECT(9,5));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_Ui  {
  unsigned char v1;
  __tsu64  :0;
  unsigned int v2;
};
//SIG(1 Uc_BFu0ll_Ui) C1{ Fc FL:0 Fi}



static void Test_Uc_BFu0ll_Ui()
{
  {
    init_simple_test("Uc_BFu0ll_Ui");
    static Uc_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Uc_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu0ll_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_Ui(Test_Uc_BFu0ll_Ui, "Uc_BFu0ll_Ui", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_Ul  {
  unsigned char v1;
  __tsu64  :0;
  __tsu64 v2;
};
//SIG(1 Uc_BFu0ll_Ul) C1{ Fc FL:0 FL}



static void Test_Uc_BFu0ll_Ul()
{
  {
    init_simple_test("Uc_BFu0ll_Ul");
    static Uc_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_Ul(Test_Uc_BFu0ll_Ul, "Uc_BFu0ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_Us  {
  unsigned char v1;
  __tsu64  :0;
  unsigned short v2;
};
//SIG(1 Uc_BFu0ll_Us) C1{ Fc FL:0 Fs}



static void Test_Uc_BFu0ll_Us()
{
  {
    init_simple_test("Uc_BFu0ll_Us");
    static Uc_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(Uc_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu0ll_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0ll_Us.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_Us(Test_Uc_BFu0ll_Us, "Uc_BFu0ll_Us", ABISELECT(10,6));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0ll_Vp  {
  unsigned char v1;
  __tsu64  :0;
  void *v2;
};
//SIG(1 Uc_BFu0ll_Vp) C1{ Fc FL:0 Fp}



static void Test_Uc_BFu0ll_Vp()
{
  {
    init_simple_test("Uc_BFu0ll_Vp");
    static Uc_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0ll_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu0ll_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0ll_Vp(Test_Uc_BFu0ll_Vp, "Uc_BFu0ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s  {
  unsigned char v1;
  unsigned short  :0;
};
//SIG(1 Uc_BFu0s) C1{ Fc Fs:0}



static void Test_Uc_BFu0s()
{
  {
    init_simple_test("Uc_BFu0s");
    static Uc_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0s(Test_Uc_BFu0s, "Uc_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu0c  {
  unsigned char v1;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 Uc_BFu0s_BFu0c) C1{ Fc Fs:0 Fc:0}



static void Test_Uc_BFu0s_BFu0c()
{
  {
    init_simple_test("Uc_BFu0s_BFu0c");
    static Uc_BFu0s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0s_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu0c(Test_Uc_BFu0s_BFu0c, "Uc_BFu0s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu0i  {
  unsigned char v1;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 Uc_BFu0s_BFu0i) C1{ Fc Fs:0 Fi:0}



static void Test_Uc_BFu0s_BFu0i()
{
  {
    init_simple_test("Uc_BFu0s_BFu0i");
    static Uc_BFu0s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0s_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu0i(Test_Uc_BFu0s_BFu0i, "Uc_BFu0s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu0ll  {
  unsigned char v1;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 Uc_BFu0s_BFu0ll) C1{ Fc Fs:0 FL:0}



static void Test_Uc_BFu0s_BFu0ll()
{
  {
    init_simple_test("Uc_BFu0s_BFu0ll");
    static Uc_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu0ll(Test_Uc_BFu0s_BFu0ll, "Uc_BFu0s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu0s  {
  unsigned char v1;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 Uc_BFu0s_BFu0s) C1{ Fc Fs:0 Fs:0}



static void Test_Uc_BFu0s_BFu0s()
{
  {
    init_simple_test("Uc_BFu0s_BFu0s");
    static Uc_BFu0s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0s_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu0s(Test_Uc_BFu0s_BFu0s, "Uc_BFu0s_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu15i  {
  unsigned char v1;
  unsigned short  :0;
  unsigned int v2:15;
};
//SIG(1 Uc_BFu0s_BFu15i) C1{ Fc Fs:0 Fi:15}



static void Test_Uc_BFu0s_BFu15i()
{
  {
    init_simple_test("Uc_BFu0s_BFu15i");
    static Uc_BFu0s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0s_BFu15i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Uc_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu0s_BFu15i");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu15i(Test_Uc_BFu0s_BFu15i, "Uc_BFu0s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu15ll  {
  unsigned char v1;
  unsigned short  :0;
  __tsu64 v2:15;
};
//SIG(1 Uc_BFu0s_BFu15ll) C1{ Fc Fs:0 FL:15}



static void Test_Uc_BFu0s_BFu15ll()
{
  {
    init_simple_test("Uc_BFu0s_BFu15ll");
    static Uc_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Uc_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu0s_BFu15ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu15ll(Test_Uc_BFu0s_BFu15ll, "Uc_BFu0s_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu15s  {
  unsigned char v1;
  unsigned short  :0;
  unsigned short v2:15;
};
//SIG(1 Uc_BFu0s_BFu15s) C1{ Fc Fs:0 Fs:15}



static void Test_Uc_BFu0s_BFu15s()
{
  {
    init_simple_test("Uc_BFu0s_BFu15s");
    static Uc_BFu0s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0s_BFu15s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Uc_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu0s_BFu15s");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu15s(Test_Uc_BFu0s_BFu15s, "Uc_BFu0s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu16i  {
  unsigned char v1;
  unsigned short  :0;
  unsigned int v2:16;
};
//SIG(1 Uc_BFu0s_BFu16i) C1{ Fc Fs:0 Fi:16}



static void Test_Uc_BFu0s_BFu16i()
{
  {
    init_simple_test("Uc_BFu0s_BFu16i");
    static Uc_BFu0s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0s_BFu16i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Uc_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu0s_BFu16i");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu16i(Test_Uc_BFu0s_BFu16i, "Uc_BFu0s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu16ll  {
  unsigned char v1;
  unsigned short  :0;
  __tsu64 v2:16;
};
//SIG(1 Uc_BFu0s_BFu16ll) C1{ Fc Fs:0 FL:16}



static void Test_Uc_BFu0s_BFu16ll()
{
  {
    init_simple_test("Uc_BFu0s_BFu16ll");
    static Uc_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Uc_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu0s_BFu16ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu16ll(Test_Uc_BFu0s_BFu16ll, "Uc_BFu0s_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu16s  {
  unsigned char v1;
  unsigned short  :0;
  unsigned short v2:16;
};
//SIG(1 Uc_BFu0s_BFu16s) C1{ Fc Fs:0 Fs:16}



static void Test_Uc_BFu0s_BFu16s()
{
  {
    init_simple_test("Uc_BFu0s_BFu16s");
    static Uc_BFu0s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0s_BFu16s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Uc_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu0s_BFu16s");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu16s(Test_Uc_BFu0s_BFu16s, "Uc_BFu0s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu17i  {
  unsigned char v1;
  unsigned short  :0;
  unsigned int v2:17;
};
//SIG(1 Uc_BFu0s_BFu17i) C1{ Fc Fs:0 Fi:17}



static void Test_Uc_BFu0s_BFu17i()
{
  {
    init_simple_test("Uc_BFu0s_BFu17i");
    static Uc_BFu0s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0s_BFu17i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Uc_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Uc_BFu0s_BFu17i");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu17i(Test_Uc_BFu0s_BFu17i, "Uc_BFu0s_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu17ll  {
  unsigned char v1;
  unsigned short  :0;
  __tsu64 v2:17;
};
//SIG(1 Uc_BFu0s_BFu17ll) C1{ Fc Fs:0 FL:17}



static void Test_Uc_BFu0s_BFu17ll()
{
  {
    init_simple_test("Uc_BFu0s_BFu17ll");
    static Uc_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Uc_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Uc_BFu0s_BFu17ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu17ll(Test_Uc_BFu0s_BFu17ll, "Uc_BFu0s_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu1c  {
  unsigned char v1;
  unsigned short  :0;
  unsigned char v2:1;
};
//SIG(1 Uc_BFu0s_BFu1c) C1{ Fc Fs:0 Fc:1}



static void Test_Uc_BFu0s_BFu1c()
{
  {
    init_simple_test("Uc_BFu0s_BFu1c");
    static Uc_BFu0s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(Uc_BFu0s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0s_BFu1c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Uc_BFu0s_BFu1c");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu1c(Test_Uc_BFu0s_BFu1c, "Uc_BFu0s_BFu1c", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu1i  {
  unsigned char v1;
  unsigned short  :0;
  unsigned int v2:1;
};
//SIG(1 Uc_BFu0s_BFu1i) C1{ Fc Fs:0 Fi:1}



static void Test_Uc_BFu0s_BFu1i()
{
  {
    init_simple_test("Uc_BFu0s_BFu1i");
    static Uc_BFu0s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0s_BFu1i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Uc_BFu0s_BFu1i");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu1i(Test_Uc_BFu0s_BFu1i, "Uc_BFu0s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu1ll  {
  unsigned char v1;
  unsigned short  :0;
  __tsu64 v2:1;
};
//SIG(1 Uc_BFu0s_BFu1ll) C1{ Fc Fs:0 FL:1}



static void Test_Uc_BFu0s_BFu1ll()
{
  {
    init_simple_test("Uc_BFu0s_BFu1ll");
    static Uc_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Uc_BFu0s_BFu1ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu1ll(Test_Uc_BFu0s_BFu1ll, "Uc_BFu0s_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu1s  {
  unsigned char v1;
  unsigned short  :0;
  unsigned short v2:1;
};
//SIG(1 Uc_BFu0s_BFu1s) C1{ Fc Fs:0 Fs:1}



static void Test_Uc_BFu0s_BFu1s()
{
  {
    init_simple_test("Uc_BFu0s_BFu1s");
    static Uc_BFu0s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0s_BFu1s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Uc_BFu0s_BFu1s");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu1s(Test_Uc_BFu0s_BFu1s, "Uc_BFu0s_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu31i  {
  unsigned char v1;
  unsigned short  :0;
  unsigned int v2:31;
};
//SIG(1 Uc_BFu0s_BFu31i) C1{ Fc Fs:0 Fi:31}



static void Test_Uc_BFu0s_BFu31i()
{
  {
    init_simple_test("Uc_BFu0s_BFu31i");
    static Uc_BFu0s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0s_BFu31i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Uc_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Uc_BFu0s_BFu31i");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu31i(Test_Uc_BFu0s_BFu31i, "Uc_BFu0s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu31ll  {
  unsigned char v1;
  unsigned short  :0;
  __tsu64 v2:31;
};
//SIG(1 Uc_BFu0s_BFu31ll) C1{ Fc Fs:0 FL:31}



static void Test_Uc_BFu0s_BFu31ll()
{
  {
    init_simple_test("Uc_BFu0s_BFu31ll");
    static Uc_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Uc_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Uc_BFu0s_BFu31ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu31ll(Test_Uc_BFu0s_BFu31ll, "Uc_BFu0s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu32i  {
  unsigned char v1;
  unsigned short  :0;
  unsigned int v2:32;
};
//SIG(1 Uc_BFu0s_BFu32i) C1{ Fc Fs:0 Fi:32}



static void Test_Uc_BFu0s_BFu32i()
{
  {
    init_simple_test("Uc_BFu0s_BFu32i");
    static Uc_BFu0s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0s_BFu32i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Uc_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Uc_BFu0s_BFu32i");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu32i(Test_Uc_BFu0s_BFu32i, "Uc_BFu0s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu32ll  {
  unsigned char v1;
  unsigned short  :0;
  __tsu64 v2:32;
};
//SIG(1 Uc_BFu0s_BFu32ll) C1{ Fc Fs:0 FL:32}



static void Test_Uc_BFu0s_BFu32ll()
{
  {
    init_simple_test("Uc_BFu0s_BFu32ll");
    static Uc_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "Uc_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "Uc_BFu0s_BFu32ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu32ll(Test_Uc_BFu0s_BFu32ll, "Uc_BFu0s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu33  {
  unsigned char v1;
  unsigned short  :0;
  __tsu64 v2:33;
};
//SIG(1 Uc_BFu0s_BFu33) C1{ Fc Fs:0 FL:33}



static void Test_Uc_BFu0s_BFu33()
{
  {
    init_simple_test("Uc_BFu0s_BFu33");
    static Uc_BFu0s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_BFu33)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "Uc_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "Uc_BFu0s_BFu33");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu33(Test_Uc_BFu0s_BFu33, "Uc_BFu0s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu7c  {
  unsigned char v1;
  unsigned short  :0;
  unsigned char v2:7;
};
//SIG(1 Uc_BFu0s_BFu7c) C1{ Fc Fs:0 Fc:7}



static void Test_Uc_BFu0s_BFu7c()
{
  {
    init_simple_test("Uc_BFu0s_BFu7c");
    static Uc_BFu0s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(Uc_BFu0s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0s_BFu7c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "Uc_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu0s_BFu7c");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu7c(Test_Uc_BFu0s_BFu7c, "Uc_BFu0s_BFu7c", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu7i  {
  unsigned char v1;
  unsigned short  :0;
  unsigned int v2:7;
};
//SIG(1 Uc_BFu0s_BFu7i) C1{ Fc Fs:0 Fi:7}



static void Test_Uc_BFu0s_BFu7i()
{
  {
    init_simple_test("Uc_BFu0s_BFu7i");
    static Uc_BFu0s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0s_BFu7i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "Uc_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu0s_BFu7i");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu7i(Test_Uc_BFu0s_BFu7i, "Uc_BFu0s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu7ll  {
  unsigned char v1;
  unsigned short  :0;
  __tsu64 v2:7;
};
//SIG(1 Uc_BFu0s_BFu7ll) C1{ Fc Fs:0 FL:7}



static void Test_Uc_BFu0s_BFu7ll()
{
  {
    init_simple_test("Uc_BFu0s_BFu7ll");
    static Uc_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "Uc_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu0s_BFu7ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu7ll(Test_Uc_BFu0s_BFu7ll, "Uc_BFu0s_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu7s  {
  unsigned char v1;
  unsigned short  :0;
  unsigned short v2:7;
};
//SIG(1 Uc_BFu0s_BFu7s) C1{ Fc Fs:0 Fs:7}



static void Test_Uc_BFu0s_BFu7s()
{
  {
    init_simple_test("Uc_BFu0s_BFu7s");
    static Uc_BFu0s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0s_BFu7s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "Uc_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "Uc_BFu0s_BFu7s");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu7s(Test_Uc_BFu0s_BFu7s, "Uc_BFu0s_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu8c  {
  unsigned char v1;
  unsigned short  :0;
  unsigned char v2:8;
};
//SIG(1 Uc_BFu0s_BFu8c) C1{ Fc Fs:0 Fc:8}



static void Test_Uc_BFu0s_BFu8c()
{
  {
    init_simple_test("Uc_BFu0s_BFu8c");
    static Uc_BFu0s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(Uc_BFu0s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0s_BFu8c)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "Uc_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu0s_BFu8c");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu8c(Test_Uc_BFu0s_BFu8c, "Uc_BFu0s_BFu8c", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu8i  {
  unsigned char v1;
  unsigned short  :0;
  unsigned int v2:8;
};
//SIG(1 Uc_BFu0s_BFu8i) C1{ Fc Fs:0 Fi:8}



static void Test_Uc_BFu0s_BFu8i()
{
  {
    init_simple_test("Uc_BFu0s_BFu8i");
    static Uc_BFu0s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0s_BFu8i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "Uc_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu0s_BFu8i");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu8i(Test_Uc_BFu0s_BFu8i, "Uc_BFu0s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu8ll  {
  unsigned char v1;
  unsigned short  :0;
  __tsu64 v2:8;
};
//SIG(1 Uc_BFu0s_BFu8ll) C1{ Fc Fs:0 FL:8}



static void Test_Uc_BFu0s_BFu8ll()
{
  {
    init_simple_test("Uc_BFu0s_BFu8ll");
    static Uc_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "Uc_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu0s_BFu8ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu8ll(Test_Uc_BFu0s_BFu8ll, "Uc_BFu0s_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu8s  {
  unsigned char v1;
  unsigned short  :0;
  unsigned short v2:8;
};
//SIG(1 Uc_BFu0s_BFu8s) C1{ Fc Fs:0 Fs:8}



static void Test_Uc_BFu0s_BFu8s()
{
  {
    init_simple_test("Uc_BFu0s_BFu8s");
    static Uc_BFu0s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0s_BFu8s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "Uc_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "Uc_BFu0s_BFu8s");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu8s(Test_Uc_BFu0s_BFu8s, "Uc_BFu0s_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu9i  {
  unsigned char v1;
  unsigned short  :0;
  unsigned int v2:9;
};
//SIG(1 Uc_BFu0s_BFu9i) C1{ Fc Fs:0 Fi:9}



static void Test_Uc_BFu0s_BFu9i()
{
  {
    init_simple_test("Uc_BFu0s_BFu9i");
    static Uc_BFu0s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0s_BFu9i)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Uc_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu0s_BFu9i");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu9i(Test_Uc_BFu0s_BFu9i, "Uc_BFu0s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu9ll  {
  unsigned char v1;
  unsigned short  :0;
  __tsu64 v2:9;
};
//SIG(1 Uc_BFu0s_BFu9ll) C1{ Fc Fs:0 FL:9}



static void Test_Uc_BFu0s_BFu9ll()
{
  {
    init_simple_test("Uc_BFu0s_BFu9ll");
    static Uc_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Uc_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu0s_BFu9ll");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu9ll(Test_Uc_BFu0s_BFu9ll, "Uc_BFu0s_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_BFu9s  {
  unsigned char v1;
  unsigned short  :0;
  unsigned short v2:9;
};
//SIG(1 Uc_BFu0s_BFu9s) C1{ Fc Fs:0 Fs:9}



static void Test_Uc_BFu0s_BFu9s()
{
  {
    init_simple_test("Uc_BFu0s_BFu9s");
    static Uc_BFu0s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0s_BFu9s)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Uc_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu0s_BFu9s");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_BFu9s(Test_Uc_BFu0s_BFu9s, "Uc_BFu0s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_C  {
  unsigned char v1;
  unsigned short  :0;
  char v2;
};
//SIG(1 Uc_BFu0s_C) C1{ Fc Fs:0 Fc}



static void Test_Uc_BFu0s_C()
{
  {
    init_simple_test("Uc_BFu0s_C");
    static Uc_BFu0s_C lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(Uc_BFu0s_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0s_C)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_C.v1");
    check_field_offset(lv, v2, 2, "Uc_BFu0s_C.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_C(Test_Uc_BFu0s_C, "Uc_BFu0s_C", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_D  {
  unsigned char v1;
  unsigned short  :0;
  double v2;
};
//SIG(1 Uc_BFu0s_D) C1{ Fc Fs:0 FL}



static void Test_Uc_BFu0s_D()
{
  {
    init_simple_test("Uc_BFu0s_D");
    static Uc_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_D)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0s_D.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_D(Test_Uc_BFu0s_D, "Uc_BFu0s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_F  {
  unsigned char v1;
  unsigned short  :0;
  float v2;
};
//SIG(1 Uc_BFu0s_F) C1{ Fc Fs:0 Fi}



static void Test_Uc_BFu0s_F()
{
  {
    init_simple_test("Uc_BFu0s_F");
    static Uc_BFu0s_F lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0s_F)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0s_F)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_F.v1");
    check_field_offset(lv, v2, 4, "Uc_BFu0s_F.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_F(Test_Uc_BFu0s_F, "Uc_BFu0s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_I  {
  unsigned char v1;
  unsigned short  :0;
  int v2;
};
//SIG(1 Uc_BFu0s_I) C1{ Fc Fs:0 Fi}



static void Test_Uc_BFu0s_I()
{
  {
    init_simple_test("Uc_BFu0s_I");
    static Uc_BFu0s_I lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0s_I)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0s_I)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_I.v1");
    check_field_offset(lv, v2, 4, "Uc_BFu0s_I.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_I(Test_Uc_BFu0s_I, "Uc_BFu0s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_Ip  {
  unsigned char v1;
  unsigned short  :0;
  int *v2;
};
//SIG(1 Uc_BFu0s_Ip) C1{ Fc Fs:0 Fp}



static void Test_Uc_BFu0s_Ip()
{
  {
    init_simple_test("Uc_BFu0s_Ip");
    static Uc_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_Ip)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0s_Ip.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_Ip(Test_Uc_BFu0s_Ip, "Uc_BFu0s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_L  {
  unsigned char v1;
  unsigned short  :0;
  __tsi64 v2;
};
//SIG(1 Uc_BFu0s_L) C1{ Fc Fs:0 FL}



static void Test_Uc_BFu0s_L()
{
  {
    init_simple_test("Uc_BFu0s_L");
    static Uc_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_L)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0s_L.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_L(Test_Uc_BFu0s_L, "Uc_BFu0s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_S  {
  unsigned char v1;
  unsigned short  :0;
  short v2;
};
//SIG(1 Uc_BFu0s_S) C1{ Fc Fs:0 Fs}



static void Test_Uc_BFu0s_S()
{
  {
    init_simple_test("Uc_BFu0s_S");
    static Uc_BFu0s_S lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_S)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0s_S)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_S.v1");
    check_field_offset(lv, v2, 2, "Uc_BFu0s_S.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_S(Test_Uc_BFu0s_S, "Uc_BFu0s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_Uc  {
  unsigned char v1;
  unsigned short  :0;
  unsigned char v2;
};
//SIG(1 Uc_BFu0s_Uc) C1{ Fc Fs:0 Fc}



static void Test_Uc_BFu0s_Uc()
{
  {
    init_simple_test("Uc_BFu0s_Uc");
    static Uc_BFu0s_Uc lv;
    check2(sizeof(lv), ABISELECT(3,3), "sizeof(Uc_BFu0s_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu0s_Uc)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_Uc.v1");
    check_field_offset(lv, v2, 2, "Uc_BFu0s_Uc.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_Uc(Test_Uc_BFu0s_Uc, "Uc_BFu0s_Uc", ABISELECT(3,3));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_Ui  {
  unsigned char v1;
  unsigned short  :0;
  unsigned int v2;
};
//SIG(1 Uc_BFu0s_Ui) C1{ Fc Fs:0 Fi}



static void Test_Uc_BFu0s_Ui()
{
  {
    init_simple_test("Uc_BFu0s_Ui");
    static Uc_BFu0s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu0s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu0s_Ui)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_Ui.v1");
    check_field_offset(lv, v2, 4, "Uc_BFu0s_Ui.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_Ui(Test_Uc_BFu0s_Ui, "Uc_BFu0s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_Ul  {
  unsigned char v1;
  unsigned short  :0;
  __tsu64 v2;
};
//SIG(1 Uc_BFu0s_Ul) C1{ Fc Fs:0 FL}



static void Test_Uc_BFu0s_Ul()
{
  {
    init_simple_test("Uc_BFu0s_Ul");
    static Uc_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_Ul)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0s_Ul.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_Ul(Test_Uc_BFu0s_Ul, "Uc_BFu0s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_Us  {
  unsigned char v1;
  unsigned short  :0;
  unsigned short v2;
};
//SIG(1 Uc_BFu0s_Us) C1{ Fc Fs:0 Fs}



static void Test_Uc_BFu0s_Us()
{
  {
    init_simple_test("Uc_BFu0s_Us");
    static Uc_BFu0s_Us lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu0s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu0s_Us)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_Us.v1");
    check_field_offset(lv, v2, 2, "Uc_BFu0s_Us.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_Us(Test_Uc_BFu0s_Us, "Uc_BFu0s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu0s_Vp  {
  unsigned char v1;
  unsigned short  :0;
  void *v2;
};
//SIG(1 Uc_BFu0s_Vp) C1{ Fc Fs:0 Fp}



static void Test_Uc_BFu0s_Vp()
{
  {
    init_simple_test("Uc_BFu0s_Vp");
    static Uc_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu0s_Vp)");
    check_field_offset(lv, v1, 0, "Uc_BFu0s_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_BFu0s_Vp.v2");
  }
}
static Arrange_To_Call_Me vUc_BFu0s_Vp(Test_Uc_BFu0s_Vp, "Uc_BFu0s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu15i_BFu0c  {
  unsigned char v1;
  unsigned int v2:15;
  unsigned char  :0;
};
//SIG(1 Uc_BFu15i_BFu0c) C1{ Fc Fi:15 Fc:0}



static void Test_Uc_BFu15i_BFu0c()
{
  {
    init_simple_test("Uc_BFu15i_BFu0c");
    static Uc_BFu15i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu15i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu15i_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu15i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "Uc_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "Uc_BFu15i_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu15i_BFu0c(Test_Uc_BFu15i_BFu0c, "Uc_BFu15i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu15i_BFu0i  {
  unsigned char v1;
  unsigned int v2:15;
  unsigned int  :0;
};
//SIG(1 Uc_BFu15i_BFu0i) C1{ Fc Fi:15 Fi:0}



static void Test_Uc_BFu15i_BFu0i()
{
  {
    init_simple_test("Uc_BFu15i_BFu0i");
    static Uc_BFu15i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu15i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu15i_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu15i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "Uc_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "Uc_BFu15i_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu15i_BFu0i(Test_Uc_BFu15i_BFu0i, "Uc_BFu15i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu15i_BFu0ll  {
  unsigned char v1;
  unsigned int v2:15;
  __tsu64  :0;
};
//SIG(1 Uc_BFu15i_BFu0ll) C1{ Fc Fi:15 FL:0}



static void Test_Uc_BFu15i_BFu0ll()
{
  {
    init_simple_test("Uc_BFu15i_BFu0ll");
    static Uc_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu15i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu15i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "Uc_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "Uc_BFu15i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu15i_BFu0ll(Test_Uc_BFu15i_BFu0ll, "Uc_BFu15i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu15i_BFu0s  {
  unsigned char v1;
  unsigned int v2:15;
  unsigned short  :0;
};
//SIG(1 Uc_BFu15i_BFu0s) C1{ Fc Fi:15 Fs:0}



static void Test_Uc_BFu15i_BFu0s()
{
  {
    init_simple_test("Uc_BFu15i_BFu0s");
    static Uc_BFu15i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu15i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu15i_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu15i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "Uc_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "Uc_BFu15i_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu15i_BFu0s(Test_Uc_BFu15i_BFu0s, "Uc_BFu15i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu15ll_BFu0c  {
  unsigned char v1;
  __tsu64 v2:15;
  unsigned char  :0;
};
//SIG(1 Uc_BFu15ll_BFu0c) C1{ Fc FL:15 Fc:0}



static void Test_Uc_BFu15ll_BFu0c()
{
  {
    init_simple_test("Uc_BFu15ll_BFu0c");
    static Uc_BFu15ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu15ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu15ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "Uc_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "Uc_BFu15ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu15ll_BFu0c(Test_Uc_BFu15ll_BFu0c, "Uc_BFu15ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu15ll_BFu0i  {
  unsigned char v1;
  __tsu64 v2:15;
  unsigned int  :0;
};
//SIG(1 Uc_BFu15ll_BFu0i) C1{ Fc FL:15 Fi:0}



static void Test_Uc_BFu15ll_BFu0i()
{
  {
    init_simple_test("Uc_BFu15ll_BFu0i");
    static Uc_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu15ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu15ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "Uc_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "Uc_BFu15ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu15ll_BFu0i(Test_Uc_BFu15ll_BFu0i, "Uc_BFu15ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu15ll_BFu0ll  {
  unsigned char v1;
  __tsu64 v2:15;
  __tsu64  :0;
};
//SIG(1 Uc_BFu15ll_BFu0ll) C1{ Fc FL:15 FL:0}



static void Test_Uc_BFu15ll_BFu0ll()
{
  {
    init_simple_test("Uc_BFu15ll_BFu0ll");
    static Uc_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu15ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu15ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "Uc_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "Uc_BFu15ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu15ll_BFu0ll(Test_Uc_BFu15ll_BFu0ll, "Uc_BFu15ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu15ll_BFu0s  {
  unsigned char v1;
  __tsu64 v2:15;
  unsigned short  :0;
};
//SIG(1 Uc_BFu15ll_BFu0s) C1{ Fc FL:15 Fs:0}



static void Test_Uc_BFu15ll_BFu0s()
{
  {
    init_simple_test("Uc_BFu15ll_BFu0s");
    static Uc_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu15ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu15ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "Uc_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "Uc_BFu15ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu15ll_BFu0s(Test_Uc_BFu15ll_BFu0s, "Uc_BFu15ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu15s_BFu0c  {
  unsigned char v1;
  unsigned short v2:15;
  unsigned char  :0;
};
//SIG(1 Uc_BFu15s_BFu0c) C1{ Fc Fs:15 Fc:0}



static void Test_Uc_BFu15s_BFu0c()
{
  {
    init_simple_test("Uc_BFu15s_BFu0c");
    static Uc_BFu15s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu15s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu15s_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu15s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Uc_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu15s_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu15s_BFu0c(Test_Uc_BFu15s_BFu0c, "Uc_BFu15s_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu15s_BFu0i  {
  unsigned char v1;
  unsigned short v2:15;
  unsigned int  :0;
};
//SIG(1 Uc_BFu15s_BFu0i) C1{ Fc Fs:15 Fi:0}



static void Test_Uc_BFu15s_BFu0i()
{
  {
    init_simple_test("Uc_BFu15s_BFu0i");
    static Uc_BFu15s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu15s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu15s_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu15s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Uc_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu15s_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu15s_BFu0i(Test_Uc_BFu15s_BFu0i, "Uc_BFu15s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu15s_BFu0ll  {
  unsigned char v1;
  unsigned short v2:15;
  __tsu64  :0;
};
//SIG(1 Uc_BFu15s_BFu0ll) C1{ Fc Fs:15 FL:0}



static void Test_Uc_BFu15s_BFu0ll()
{
  {
    init_simple_test("Uc_BFu15s_BFu0ll");
    static Uc_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu15s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu15s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Uc_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu15s_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu15s_BFu0ll(Test_Uc_BFu15s_BFu0ll, "Uc_BFu15s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu15s_BFu0s  {
  unsigned char v1;
  unsigned short v2:15;
  unsigned short  :0;
};
//SIG(1 Uc_BFu15s_BFu0s) C1{ Fc Fs:15 Fs:0}



static void Test_Uc_BFu15s_BFu0s()
{
  {
    init_simple_test("Uc_BFu15s_BFu0s");
    static Uc_BFu15s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu15s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu15s_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu15s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Uc_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Uc_BFu15s_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu15s_BFu0s(Test_Uc_BFu15s_BFu0s, "Uc_BFu15s_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu16i_BFu0c  {
  unsigned char v1;
  unsigned int v2:16;
  unsigned char  :0;
};
//SIG(1 Uc_BFu16i_BFu0c) C1{ Fc Fi:16 Fc:0}



static void Test_Uc_BFu16i_BFu0c()
{
  {
    init_simple_test("Uc_BFu16i_BFu0c");
    static Uc_BFu16i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu16i_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu16i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16i_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu16i_BFu0c(Test_Uc_BFu16i_BFu0c, "Uc_BFu16i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu16i_BFu0i  {
  unsigned char v1;
  unsigned int v2:16;
  unsigned int  :0;
};
//SIG(1 Uc_BFu16i_BFu0i) C1{ Fc Fi:16 Fi:0}



static void Test_Uc_BFu16i_BFu0i()
{
  {
    init_simple_test("Uc_BFu16i_BFu0i");
    static Uc_BFu16i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu16i_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu16i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16i_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu16i_BFu0i(Test_Uc_BFu16i_BFu0i, "Uc_BFu16i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu16i_BFu0ll  {
  unsigned char v1;
  unsigned int v2:16;
  __tsu64  :0;
};
//SIG(1 Uc_BFu16i_BFu0ll) C1{ Fc Fi:16 FL:0}



static void Test_Uc_BFu16i_BFu0ll()
{
  {
    init_simple_test("Uc_BFu16i_BFu0ll");
    static Uc_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu16i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu16i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu16i_BFu0ll(Test_Uc_BFu16i_BFu0ll, "Uc_BFu16i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu16i_BFu0s  {
  unsigned char v1;
  unsigned int v2:16;
  unsigned short  :0;
};
//SIG(1 Uc_BFu16i_BFu0s) C1{ Fc Fi:16 Fs:0}



static void Test_Uc_BFu16i_BFu0s()
{
  {
    init_simple_test("Uc_BFu16i_BFu0s");
    static Uc_BFu16i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu16i_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu16i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16i_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu16i_BFu0s(Test_Uc_BFu16i_BFu0s, "Uc_BFu16i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu16ll_BFu0c  {
  unsigned char v1;
  __tsu64 v2:16;
  unsigned char  :0;
};
//SIG(1 Uc_BFu16ll_BFu0c) C1{ Fc FL:16 Fc:0}



static void Test_Uc_BFu16ll_BFu0c()
{
  {
    init_simple_test("Uc_BFu16ll_BFu0c");
    static Uc_BFu16ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu16ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu16ll_BFu0c(Test_Uc_BFu16ll_BFu0c, "Uc_BFu16ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu16ll_BFu0i  {
  unsigned char v1;
  __tsu64 v2:16;
  unsigned int  :0;
};
//SIG(1 Uc_BFu16ll_BFu0i) C1{ Fc FL:16 Fi:0}



static void Test_Uc_BFu16ll_BFu0i()
{
  {
    init_simple_test("Uc_BFu16ll_BFu0i");
    static Uc_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu16ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu16ll_BFu0i(Test_Uc_BFu16ll_BFu0i, "Uc_BFu16ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu16ll_BFu0ll  {
  unsigned char v1;
  __tsu64 v2:16;
  __tsu64  :0;
};
//SIG(1 Uc_BFu16ll_BFu0ll) C1{ Fc FL:16 FL:0}



static void Test_Uc_BFu16ll_BFu0ll()
{
  {
    init_simple_test("Uc_BFu16ll_BFu0ll");
    static Uc_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu16ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu16ll_BFu0ll(Test_Uc_BFu16ll_BFu0ll, "Uc_BFu16ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu16ll_BFu0s  {
  unsigned char v1;
  __tsu64 v2:16;
  unsigned short  :0;
};
//SIG(1 Uc_BFu16ll_BFu0s) C1{ Fc FL:16 Fs:0}



static void Test_Uc_BFu16ll_BFu0s()
{
  {
    init_simple_test("Uc_BFu16ll_BFu0s");
    static Uc_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu16ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu16ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Uc_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Uc_BFu16ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu16ll_BFu0s(Test_Uc_BFu16ll_BFu0s, "Uc_BFu16ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu16s_BFu0c  {
  unsigned char v1;
  unsigned short v2:16;
  unsigned char  :0;
};
//SIG(1 Uc_BFu16s_BFu0c) C1{ Fc Fs:16 Fc:0}



static void Test_Uc_BFu16s_BFu0c()
{
  {
    init_simple_test("Uc_BFu16s_BFu0c");
    static Uc_BFu16s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu16s_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Uc_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu16s_BFu0c(Test_Uc_BFu16s_BFu0c, "Uc_BFu16s_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu16s_BFu0i  {
  unsigned char v1;
  unsigned short v2:16;
  unsigned int  :0;
};
//SIG(1 Uc_BFu16s_BFu0i) C1{ Fc Fs:16 Fi:0}



static void Test_Uc_BFu16s_BFu0i()
{
  {
    init_simple_test("Uc_BFu16s_BFu0i");
    static Uc_BFu16s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu16s_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Uc_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu16s_BFu0i(Test_Uc_BFu16s_BFu0i, "Uc_BFu16s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu16s_BFu0ll  {
  unsigned char v1;
  unsigned short v2:16;
  __tsu64  :0;
};
//SIG(1 Uc_BFu16s_BFu0ll) C1{ Fc Fs:16 FL:0}



static void Test_Uc_BFu16s_BFu0ll()
{
  {
    init_simple_test("Uc_BFu16s_BFu0ll");
    static Uc_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu16s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Uc_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu16s_BFu0ll(Test_Uc_BFu16s_BFu0ll, "Uc_BFu16s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu16s_BFu0s  {
  unsigned char v1;
  unsigned short v2:16;
  unsigned short  :0;
};
//SIG(1 Uc_BFu16s_BFu0s) C1{ Fc Fs:16 Fs:0}



static void Test_Uc_BFu16s_BFu0s()
{
  {
    init_simple_test("Uc_BFu16s_BFu0s");
    static Uc_BFu16s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu16s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu16s_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu16s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Uc_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Uc_BFu16s_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu16s_BFu0s(Test_Uc_BFu16s_BFu0s, "Uc_BFu16s_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu17i_BFu0c  {
  unsigned char v1;
  unsigned int v2:17;
  unsigned char  :0;
};
//SIG(1 Uc_BFu17i_BFu0c) C1{ Fc Fi:17 Fc:0}



static void Test_Uc_BFu17i_BFu0c()
{
  {
    init_simple_test("Uc_BFu17i_BFu0c");
    static Uc_BFu17i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu17i_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu17i_BFu0c(Test_Uc_BFu17i_BFu0c, "Uc_BFu17i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu17i_BFu0i  {
  unsigned char v1;
  unsigned int v2:17;
  unsigned int  :0;
};
//SIG(1 Uc_BFu17i_BFu0i) C1{ Fc Fi:17 Fi:0}



static void Test_Uc_BFu17i_BFu0i()
{
  {
    init_simple_test("Uc_BFu17i_BFu0i");
    static Uc_BFu17i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu17i_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu17i_BFu0i(Test_Uc_BFu17i_BFu0i, "Uc_BFu17i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu17i_BFu0ll  {
  unsigned char v1;
  unsigned int v2:17;
  __tsu64  :0;
};
//SIG(1 Uc_BFu17i_BFu0ll) C1{ Fc Fi:17 FL:0}



static void Test_Uc_BFu17i_BFu0ll()
{
  {
    init_simple_test("Uc_BFu17i_BFu0ll");
    static Uc_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu17i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu17i_BFu0ll(Test_Uc_BFu17i_BFu0ll, "Uc_BFu17i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu17i_BFu0s  {
  unsigned char v1;
  unsigned int v2:17;
  unsigned short  :0;
};
//SIG(1 Uc_BFu17i_BFu0s) C1{ Fc Fi:17 Fs:0}



static void Test_Uc_BFu17i_BFu0s()
{
  {
    init_simple_test("Uc_BFu17i_BFu0s");
    static Uc_BFu17i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu17i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu17i_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu17i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17i_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu17i_BFu0s(Test_Uc_BFu17i_BFu0s, "Uc_BFu17i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu17ll_BFu0c  {
  unsigned char v1;
  __tsu64 v2:17;
  unsigned char  :0;
};
//SIG(1 Uc_BFu17ll_BFu0c) C1{ Fc FL:17 Fc:0}



static void Test_Uc_BFu17ll_BFu0c()
{
  {
    init_simple_test("Uc_BFu17ll_BFu0c");
    static Uc_BFu17ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu17ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu17ll_BFu0c(Test_Uc_BFu17ll_BFu0c, "Uc_BFu17ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu17ll_BFu0i  {
  unsigned char v1;
  __tsu64 v2:17;
  unsigned int  :0;
};
//SIG(1 Uc_BFu17ll_BFu0i) C1{ Fc FL:17 Fi:0}



static void Test_Uc_BFu17ll_BFu0i()
{
  {
    init_simple_test("Uc_BFu17ll_BFu0i");
    static Uc_BFu17ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu17ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu17ll_BFu0i(Test_Uc_BFu17ll_BFu0i, "Uc_BFu17ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu17ll_BFu0ll  {
  unsigned char v1;
  __tsu64 v2:17;
  __tsu64  :0;
};
//SIG(1 Uc_BFu17ll_BFu0ll) C1{ Fc FL:17 FL:0}



static void Test_Uc_BFu17ll_BFu0ll()
{
  {
    init_simple_test("Uc_BFu17ll_BFu0ll");
    static Uc_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu17ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu17ll_BFu0ll(Test_Uc_BFu17ll_BFu0ll, "Uc_BFu17ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu17ll_BFu0s  {
  unsigned char v1;
  __tsu64 v2:17;
  unsigned short  :0;
};
//SIG(1 Uc_BFu17ll_BFu0s) C1{ Fc FL:17 Fs:0}



static void Test_Uc_BFu17ll_BFu0s()
{
  {
    init_simple_test("Uc_BFu17ll_BFu0s");
    static Uc_BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu17ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu17ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Uc_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Uc_BFu17ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu17ll_BFu0s(Test_Uc_BFu17ll_BFu0s, "Uc_BFu17ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1c_BFu0c  {
  unsigned char v1;
  unsigned char v2:1;
  unsigned char  :0;
};
//SIG(1 Uc_BFu1c_BFu0c) C1{ Fc Fc:1 Fc:0}



static void Test_Uc_BFu1c_BFu0c()
{
  {
    init_simple_test("Uc_BFu1c_BFu0c");
    static Uc_BFu1c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu1c_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu1c_BFu0c(Test_Uc_BFu1c_BFu0c, "Uc_BFu1c_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1c_BFu0i  {
  unsigned char v1;
  unsigned char v2:1;
  unsigned int  :0;
};
//SIG(1 Uc_BFu1c_BFu0i) C1{ Fc Fc:1 Fi:0}



static void Test_Uc_BFu1c_BFu0i()
{
  {
    init_simple_test("Uc_BFu1c_BFu0i");
    static Uc_BFu1c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu1c_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu1c_BFu0i(Test_Uc_BFu1c_BFu0i, "Uc_BFu1c_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1c_BFu0ll  {
  unsigned char v1;
  unsigned char v2:1;
  __tsu64  :0;
};
//SIG(1 Uc_BFu1c_BFu0ll) C1{ Fc Fc:1 FL:0}



static void Test_Uc_BFu1c_BFu0ll()
{
  {
    init_simple_test("Uc_BFu1c_BFu0ll");
    static Uc_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu1c_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu1c_BFu0ll(Test_Uc_BFu1c_BFu0ll, "Uc_BFu1c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1c_BFu0s  {
  unsigned char v1;
  unsigned char v2:1;
  unsigned short  :0;
};
//SIG(1 Uc_BFu1c_BFu0s) C1{ Fc Fc:1 Fs:0}



static void Test_Uc_BFu1c_BFu0s()
{
  {
    init_simple_test("Uc_BFu1c_BFu0s");
    static Uc_BFu1c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu1c_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1c_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1c_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu1c_BFu0s(Test_Uc_BFu1c_BFu0s, "Uc_BFu1c_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1i_BFu0c  {
  unsigned char v1;
  unsigned int v2:1;
  unsigned char  :0;
};
//SIG(1 Uc_BFu1i_BFu0c) C1{ Fc Fi:1 Fc:0}



static void Test_Uc_BFu1i_BFu0c()
{
  {
    init_simple_test("Uc_BFu1i_BFu0c");
    static Uc_BFu1i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu1i_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu1i_BFu0c(Test_Uc_BFu1i_BFu0c, "Uc_BFu1i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1i_BFu0i  {
  unsigned char v1;
  unsigned int v2:1;
  unsigned int  :0;
};
//SIG(1 Uc_BFu1i_BFu0i) C1{ Fc Fi:1 Fi:0}



static void Test_Uc_BFu1i_BFu0i()
{
  {
    init_simple_test("Uc_BFu1i_BFu0i");
    static Uc_BFu1i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu1i_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu1i_BFu0i(Test_Uc_BFu1i_BFu0i, "Uc_BFu1i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1i_BFu0ll  {
  unsigned char v1;
  unsigned int v2:1;
  __tsu64  :0;
};
//SIG(1 Uc_BFu1i_BFu0ll) C1{ Fc Fi:1 FL:0}



static void Test_Uc_BFu1i_BFu0ll()
{
  {
    init_simple_test("Uc_BFu1i_BFu0ll");
    static Uc_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu1i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu1i_BFu0ll(Test_Uc_BFu1i_BFu0ll, "Uc_BFu1i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1i_BFu0s  {
  unsigned char v1;
  unsigned int v2:1;
  unsigned short  :0;
};
//SIG(1 Uc_BFu1i_BFu0s) C1{ Fc Fi:1 Fs:0}



static void Test_Uc_BFu1i_BFu0s()
{
  {
    init_simple_test("Uc_BFu1i_BFu0s");
    static Uc_BFu1i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu1i_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1i_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu1i_BFu0s(Test_Uc_BFu1i_BFu0s, "Uc_BFu1i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1ll_BFu0c  {
  unsigned char v1;
  __tsu64 v2:1;
  unsigned char  :0;
};
//SIG(1 Uc_BFu1ll_BFu0c) C1{ Fc FL:1 Fc:0}



static void Test_Uc_BFu1ll_BFu0c()
{
  {
    init_simple_test("Uc_BFu1ll_BFu0c");
    static Uc_BFu1ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu1ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu1ll_BFu0c(Test_Uc_BFu1ll_BFu0c, "Uc_BFu1ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1ll_BFu0i  {
  unsigned char v1;
  __tsu64 v2:1;
  unsigned int  :0;
};
//SIG(1 Uc_BFu1ll_BFu0i) C1{ Fc FL:1 Fi:0}



static void Test_Uc_BFu1ll_BFu0i()
{
  {
    init_simple_test("Uc_BFu1ll_BFu0i");
    static Uc_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu1ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu1ll_BFu0i(Test_Uc_BFu1ll_BFu0i, "Uc_BFu1ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1ll_BFu0ll  {
  unsigned char v1;
  __tsu64 v2:1;
  __tsu64  :0;
};
//SIG(1 Uc_BFu1ll_BFu0ll) C1{ Fc FL:1 FL:0}



static void Test_Uc_BFu1ll_BFu0ll()
{
  {
    init_simple_test("Uc_BFu1ll_BFu0ll");
    static Uc_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu1ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu1ll_BFu0ll(Test_Uc_BFu1ll_BFu0ll, "Uc_BFu1ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1ll_BFu0s  {
  unsigned char v1;
  __tsu64 v2:1;
  unsigned short  :0;
};
//SIG(1 Uc_BFu1ll_BFu0s) C1{ Fc FL:1 Fs:0}



static void Test_Uc_BFu1ll_BFu0s()
{
  {
    init_simple_test("Uc_BFu1ll_BFu0s");
    static Uc_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu1ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu1ll_BFu0s(Test_Uc_BFu1ll_BFu0s, "Uc_BFu1ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1s_BFu0c  {
  unsigned char v1;
  unsigned short v2:1;
  unsigned char  :0;
};
//SIG(1 Uc_BFu1s_BFu0c) C1{ Fc Fs:1 Fc:0}



static void Test_Uc_BFu1s_BFu0c()
{
  {
    init_simple_test("Uc_BFu1s_BFu0c");
    static Uc_BFu1s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu1s_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu1s_BFu0c(Test_Uc_BFu1s_BFu0c, "Uc_BFu1s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1s_BFu0i  {
  unsigned char v1;
  unsigned short v2:1;
  unsigned int  :0;
};
//SIG(1 Uc_BFu1s_BFu0i) C1{ Fc Fs:1 Fi:0}



static void Test_Uc_BFu1s_BFu0i()
{
  {
    init_simple_test("Uc_BFu1s_BFu0i");
    static Uc_BFu1s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu1s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu1s_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu1s_BFu0i(Test_Uc_BFu1s_BFu0i, "Uc_BFu1s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1s_BFu0ll  {
  unsigned char v1;
  unsigned short v2:1;
  __tsu64  :0;
};
//SIG(1 Uc_BFu1s_BFu0ll) C1{ Fc Fs:1 FL:0}



static void Test_Uc_BFu1s_BFu0ll()
{
  {
    init_simple_test("Uc_BFu1s_BFu0ll");
    static Uc_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu1s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu1s_BFu0ll(Test_Uc_BFu1s_BFu0ll, "Uc_BFu1s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu1s_BFu0s  {
  unsigned char v1;
  unsigned short v2:1;
  unsigned short  :0;
};
//SIG(1 Uc_BFu1s_BFu0s) C1{ Fc Fs:1 Fs:0}



static void Test_Uc_BFu1s_BFu0s()
{
  {
    init_simple_test("Uc_BFu1s_BFu0s");
    static Uc_BFu1s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu1s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu1s_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu1s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Uc_BFu1s_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu1s_BFu0s(Test_Uc_BFu1s_BFu0s, "Uc_BFu1s_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu31i_BFu0c  {
  unsigned char v1;
  unsigned int v2:31;
  unsigned char  :0;
};
//SIG(1 Uc_BFu31i_BFu0c) C1{ Fc Fi:31 Fc:0}



static void Test_Uc_BFu31i_BFu0c()
{
  {
    init_simple_test("Uc_BFu31i_BFu0c");
    static Uc_BFu31i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu31i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu31i_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Uc_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu31i_BFu0c(Test_Uc_BFu31i_BFu0c, "Uc_BFu31i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu31i_BFu0i  {
  unsigned char v1;
  unsigned int v2:31;
  unsigned int  :0;
};
//SIG(1 Uc_BFu31i_BFu0i) C1{ Fc Fi:31 Fi:0}



static void Test_Uc_BFu31i_BFu0i()
{
  {
    init_simple_test("Uc_BFu31i_BFu0i");
    static Uc_BFu31i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu31i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu31i_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Uc_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu31i_BFu0i(Test_Uc_BFu31i_BFu0i, "Uc_BFu31i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu31i_BFu0ll  {
  unsigned char v1;
  unsigned int v2:31;
  __tsu64  :0;
};
//SIG(1 Uc_BFu31i_BFu0ll) C1{ Fc Fi:31 FL:0}



static void Test_Uc_BFu31i_BFu0ll()
{
  {
    init_simple_test("Uc_BFu31i_BFu0ll");
    static Uc_BFu31i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu31i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Uc_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu31i_BFu0ll(Test_Uc_BFu31i_BFu0ll, "Uc_BFu31i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu31i_BFu0s  {
  unsigned char v1;
  unsigned int v2:31;
  unsigned short  :0;
};
//SIG(1 Uc_BFu31i_BFu0s) C1{ Fc Fi:31 Fs:0}



static void Test_Uc_BFu31i_BFu0s()
{
  {
    init_simple_test("Uc_BFu31i_BFu0s");
    static Uc_BFu31i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu31i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu31i_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu31i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Uc_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Uc_BFu31i_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu31i_BFu0s(Test_Uc_BFu31i_BFu0s, "Uc_BFu31i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu31ll_BFu0c  {
  unsigned char v1;
  __tsu64 v2:31;
  unsigned char  :0;
};
//SIG(1 Uc_BFu31ll_BFu0c) C1{ Fc FL:31 Fc:0}



static void Test_Uc_BFu31ll_BFu0c()
{
  {
    init_simple_test("Uc_BFu31ll_BFu0c");
    static Uc_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu31ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu31ll_BFu0c(Test_Uc_BFu31ll_BFu0c, "Uc_BFu31ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu31ll_BFu0i  {
  unsigned char v1;
  __tsu64 v2:31;
  unsigned int  :0;
};
//SIG(1 Uc_BFu31ll_BFu0i) C1{ Fc FL:31 Fi:0}



static void Test_Uc_BFu31ll_BFu0i()
{
  {
    init_simple_test("Uc_BFu31ll_BFu0i");
    static Uc_BFu31ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu31ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu31ll_BFu0i(Test_Uc_BFu31ll_BFu0i, "Uc_BFu31ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu31ll_BFu0ll  {
  unsigned char v1;
  __tsu64 v2:31;
  __tsu64  :0;
};
//SIG(1 Uc_BFu31ll_BFu0ll) C1{ Fc FL:31 FL:0}



static void Test_Uc_BFu31ll_BFu0ll()
{
  {
    init_simple_test("Uc_BFu31ll_BFu0ll");
    static Uc_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu31ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu31ll_BFu0ll(Test_Uc_BFu31ll_BFu0ll, "Uc_BFu31ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu31ll_BFu0s  {
  unsigned char v1;
  __tsu64 v2:31;
  unsigned short  :0;
};
//SIG(1 Uc_BFu31ll_BFu0s) C1{ Fc FL:31 Fs:0}



static void Test_Uc_BFu31ll_BFu0s()
{
  {
    init_simple_test("Uc_BFu31ll_BFu0s");
    static Uc_BFu31ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu31ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu31ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Uc_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Uc_BFu31ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu31ll_BFu0s(Test_Uc_BFu31ll_BFu0s, "Uc_BFu31ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu32i_BFu0c  {
  unsigned char v1;
  unsigned int v2:32;
  unsigned char  :0;
};
//SIG(1 Uc_BFu32i_BFu0c) C1{ Fc Fi:32 Fc:0}



static void Test_Uc_BFu32i_BFu0c()
{
  {
    init_simple_test("Uc_BFu32i_BFu0c");
    static Uc_BFu32i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu32i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu32i_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Uc_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu32i_BFu0c(Test_Uc_BFu32i_BFu0c, "Uc_BFu32i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu32i_BFu0i  {
  unsigned char v1;
  unsigned int v2:32;
  unsigned int  :0;
};
//SIG(1 Uc_BFu32i_BFu0i) C1{ Fc Fi:32 Fi:0}



static void Test_Uc_BFu32i_BFu0i()
{
  {
    init_simple_test("Uc_BFu32i_BFu0i");
    static Uc_BFu32i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu32i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu32i_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Uc_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu32i_BFu0i(Test_Uc_BFu32i_BFu0i, "Uc_BFu32i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu32i_BFu0ll  {
  unsigned char v1;
  unsigned int v2:32;
  __tsu64  :0;
};
//SIG(1 Uc_BFu32i_BFu0ll) C1{ Fc Fi:32 FL:0}



static void Test_Uc_BFu32i_BFu0ll()
{
  {
    init_simple_test("Uc_BFu32i_BFu0ll");
    static Uc_BFu32i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu32i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Uc_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu32i_BFu0ll(Test_Uc_BFu32i_BFu0ll, "Uc_BFu32i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu32i_BFu0s  {
  unsigned char v1;
  unsigned int v2:32;
  unsigned short  :0;
};
//SIG(1 Uc_BFu32i_BFu0s) C1{ Fc Fi:32 Fs:0}



static void Test_Uc_BFu32i_BFu0s()
{
  {
    init_simple_test("Uc_BFu32i_BFu0s");
    static Uc_BFu32i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu32i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu32i_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu32i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Uc_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Uc_BFu32i_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu32i_BFu0s(Test_Uc_BFu32i_BFu0s, "Uc_BFu32i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu32ll_BFu0c  {
  unsigned char v1;
  __tsu64 v2:32;
  unsigned char  :0;
};
//SIG(1 Uc_BFu32ll_BFu0c) C1{ Fc FL:32 Fc:0}



static void Test_Uc_BFu32ll_BFu0c()
{
  {
    init_simple_test("Uc_BFu32ll_BFu0c");
    static Uc_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu32ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu32ll_BFu0c(Test_Uc_BFu32ll_BFu0c, "Uc_BFu32ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu32ll_BFu0i  {
  unsigned char v1;
  __tsu64 v2:32;
  unsigned int  :0;
};
//SIG(1 Uc_BFu32ll_BFu0i) C1{ Fc FL:32 Fi:0}



static void Test_Uc_BFu32ll_BFu0i()
{
  {
    init_simple_test("Uc_BFu32ll_BFu0i");
    static Uc_BFu32ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu32ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu32ll_BFu0i(Test_Uc_BFu32ll_BFu0i, "Uc_BFu32ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu32ll_BFu0ll  {
  unsigned char v1;
  __tsu64 v2:32;
  __tsu64  :0;
};
//SIG(1 Uc_BFu32ll_BFu0ll) C1{ Fc FL:32 FL:0}



static void Test_Uc_BFu32ll_BFu0ll()
{
  {
    init_simple_test("Uc_BFu32ll_BFu0ll");
    static Uc_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu32ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu32ll_BFu0ll(Test_Uc_BFu32ll_BFu0ll, "Uc_BFu32ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu32ll_BFu0s  {
  unsigned char v1;
  __tsu64 v2:32;
  unsigned short  :0;
};
//SIG(1 Uc_BFu32ll_BFu0s) C1{ Fc FL:32 Fs:0}



static void Test_Uc_BFu32ll_BFu0s()
{
  {
    init_simple_test("Uc_BFu32ll_BFu0s");
    static Uc_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu32ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu32ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Uc_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Uc_BFu32ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu32ll_BFu0s(Test_Uc_BFu32ll_BFu0s, "Uc_BFu32ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu33_BFu0c  {
  unsigned char v1;
  __tsu64 v2:33;
  unsigned char  :0;
};
//SIG(1 Uc_BFu33_BFu0c) C1{ Fc FL:33 Fc:0}



static void Test_Uc_BFu33_BFu0c()
{
  {
    init_simple_test("Uc_BFu33_BFu0c");
    static Uc_BFu33_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu33_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu33_BFu0c(Test_Uc_BFu33_BFu0c, "Uc_BFu33_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu33_BFu0i  {
  unsigned char v1;
  __tsu64 v2:33;
  unsigned int  :0;
};
//SIG(1 Uc_BFu33_BFu0i) C1{ Fc FL:33 Fi:0}



static void Test_Uc_BFu33_BFu0i()
{
  {
    init_simple_test("Uc_BFu33_BFu0i");
    static Uc_BFu33_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu33_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu33_BFu0i(Test_Uc_BFu33_BFu0i, "Uc_BFu33_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu33_BFu0ll  {
  unsigned char v1;
  __tsu64 v2:33;
  __tsu64  :0;
};
//SIG(1 Uc_BFu33_BFu0ll) C1{ Fc FL:33 FL:0}



static void Test_Uc_BFu33_BFu0ll()
{
  {
    init_simple_test("Uc_BFu33_BFu0ll");
    static Uc_BFu33_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu33_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu33_BFu0ll(Test_Uc_BFu33_BFu0ll, "Uc_BFu33_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu33_BFu0s  {
  unsigned char v1;
  __tsu64 v2:33;
  unsigned short  :0;
};
//SIG(1 Uc_BFu33_BFu0s) C1{ Fc FL:33 Fs:0}



static void Test_Uc_BFu33_BFu0s()
{
  {
    init_simple_test("Uc_BFu33_BFu0s");
    static Uc_BFu33_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Uc_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu33_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu33_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Uc_BFu33_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Uc_BFu33_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu33_BFu0s(Test_Uc_BFu33_BFu0s, "Uc_BFu33_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7c_BFu0c  {
  unsigned char v1;
  unsigned char v2:7;
  unsigned char  :0;
};
//SIG(1 Uc_BFu7c_BFu0c) C1{ Fc Fc:7 Fc:0}



static void Test_Uc_BFu7c_BFu0c()
{
  {
    init_simple_test("Uc_BFu7c_BFu0c");
    static Uc_BFu7c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu7c_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu7c_BFu0c(Test_Uc_BFu7c_BFu0c, "Uc_BFu7c_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7c_BFu0i  {
  unsigned char v1;
  unsigned char v2:7;
  unsigned int  :0;
};
//SIG(1 Uc_BFu7c_BFu0i) C1{ Fc Fc:7 Fi:0}



static void Test_Uc_BFu7c_BFu0i()
{
  {
    init_simple_test("Uc_BFu7c_BFu0i");
    static Uc_BFu7c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu7c_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu7c_BFu0i(Test_Uc_BFu7c_BFu0i, "Uc_BFu7c_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7c_BFu0ll  {
  unsigned char v1;
  unsigned char v2:7;
  __tsu64  :0;
};
//SIG(1 Uc_BFu7c_BFu0ll) C1{ Fc Fc:7 FL:0}



static void Test_Uc_BFu7c_BFu0ll()
{
  {
    init_simple_test("Uc_BFu7c_BFu0ll");
    static Uc_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu7c_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu7c_BFu0ll(Test_Uc_BFu7c_BFu0ll, "Uc_BFu7c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7c_BFu0s  {
  unsigned char v1;
  unsigned char v2:7;
  unsigned short  :0;
};
//SIG(1 Uc_BFu7c_BFu0s) C1{ Fc Fc:7 Fs:0}



static void Test_Uc_BFu7c_BFu0s()
{
  {
    init_simple_test("Uc_BFu7c_BFu0s");
    static Uc_BFu7c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu7c_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7c_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7c_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu7c_BFu0s(Test_Uc_BFu7c_BFu0s, "Uc_BFu7c_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7i_BFu0c  {
  unsigned char v1;
  unsigned int v2:7;
  unsigned char  :0;
};
//SIG(1 Uc_BFu7i_BFu0c) C1{ Fc Fi:7 Fc:0}



static void Test_Uc_BFu7i_BFu0c()
{
  {
    init_simple_test("Uc_BFu7i_BFu0c");
    static Uc_BFu7i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu7i_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu7i_BFu0c(Test_Uc_BFu7i_BFu0c, "Uc_BFu7i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7i_BFu0i  {
  unsigned char v1;
  unsigned int v2:7;
  unsigned int  :0;
};
//SIG(1 Uc_BFu7i_BFu0i) C1{ Fc Fi:7 Fi:0}



static void Test_Uc_BFu7i_BFu0i()
{
  {
    init_simple_test("Uc_BFu7i_BFu0i");
    static Uc_BFu7i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu7i_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu7i_BFu0i(Test_Uc_BFu7i_BFu0i, "Uc_BFu7i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7i_BFu0ll  {
  unsigned char v1;
  unsigned int v2:7;
  __tsu64  :0;
};
//SIG(1 Uc_BFu7i_BFu0ll) C1{ Fc Fi:7 FL:0}



static void Test_Uc_BFu7i_BFu0ll()
{
  {
    init_simple_test("Uc_BFu7i_BFu0ll");
    static Uc_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu7i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu7i_BFu0ll(Test_Uc_BFu7i_BFu0ll, "Uc_BFu7i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7i_BFu0s  {
  unsigned char v1;
  unsigned int v2:7;
  unsigned short  :0;
};
//SIG(1 Uc_BFu7i_BFu0s) C1{ Fc Fi:7 Fs:0}



static void Test_Uc_BFu7i_BFu0s()
{
  {
    init_simple_test("Uc_BFu7i_BFu0s");
    static Uc_BFu7i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu7i_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7i_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu7i_BFu0s(Test_Uc_BFu7i_BFu0s, "Uc_BFu7i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7ll_BFu0c  {
  unsigned char v1;
  __tsu64 v2:7;
  unsigned char  :0;
};
//SIG(1 Uc_BFu7ll_BFu0c) C1{ Fc FL:7 Fc:0}



static void Test_Uc_BFu7ll_BFu0c()
{
  {
    init_simple_test("Uc_BFu7ll_BFu0c");
    static Uc_BFu7ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu7ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu7ll_BFu0c(Test_Uc_BFu7ll_BFu0c, "Uc_BFu7ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7ll_BFu0i  {
  unsigned char v1;
  __tsu64 v2:7;
  unsigned int  :0;
};
//SIG(1 Uc_BFu7ll_BFu0i) C1{ Fc FL:7 Fi:0}



static void Test_Uc_BFu7ll_BFu0i()
{
  {
    init_simple_test("Uc_BFu7ll_BFu0i");
    static Uc_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu7ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu7ll_BFu0i(Test_Uc_BFu7ll_BFu0i, "Uc_BFu7ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7ll_BFu0ll  {
  unsigned char v1;
  __tsu64 v2:7;
  __tsu64  :0;
};
//SIG(1 Uc_BFu7ll_BFu0ll) C1{ Fc FL:7 FL:0}



static void Test_Uc_BFu7ll_BFu0ll()
{
  {
    init_simple_test("Uc_BFu7ll_BFu0ll");
    static Uc_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu7ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu7ll_BFu0ll(Test_Uc_BFu7ll_BFu0ll, "Uc_BFu7ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7ll_BFu0s  {
  unsigned char v1;
  __tsu64 v2:7;
  unsigned short  :0;
};
//SIG(1 Uc_BFu7ll_BFu0s) C1{ Fc FL:7 Fs:0}



static void Test_Uc_BFu7ll_BFu0s()
{
  {
    init_simple_test("Uc_BFu7ll_BFu0s");
    static Uc_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu7ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu7ll_BFu0s(Test_Uc_BFu7ll_BFu0s, "Uc_BFu7ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7s_BFu0c  {
  unsigned char v1;
  unsigned short v2:7;
  unsigned char  :0;
};
//SIG(1 Uc_BFu7s_BFu0c) C1{ Fc Fs:7 Fc:0}



static void Test_Uc_BFu7s_BFu0c()
{
  {
    init_simple_test("Uc_BFu7s_BFu0c");
    static Uc_BFu7s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu7s_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu7s_BFu0c(Test_Uc_BFu7s_BFu0c, "Uc_BFu7s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7s_BFu0i  {
  unsigned char v1;
  unsigned short v2:7;
  unsigned int  :0;
};
//SIG(1 Uc_BFu7s_BFu0i) C1{ Fc Fs:7 Fi:0}



static void Test_Uc_BFu7s_BFu0i()
{
  {
    init_simple_test("Uc_BFu7s_BFu0i");
    static Uc_BFu7s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu7s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu7s_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu7s_BFu0i(Test_Uc_BFu7s_BFu0i, "Uc_BFu7s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7s_BFu0ll  {
  unsigned char v1;
  unsigned short v2:7;
  __tsu64  :0;
};
//SIG(1 Uc_BFu7s_BFu0ll) C1{ Fc Fs:7 FL:0}



static void Test_Uc_BFu7s_BFu0ll()
{
  {
    init_simple_test("Uc_BFu7s_BFu0ll");
    static Uc_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu7s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu7s_BFu0ll(Test_Uc_BFu7s_BFu0ll, "Uc_BFu7s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu7s_BFu0s  {
  unsigned char v1;
  unsigned short v2:7;
  unsigned short  :0;
};
//SIG(1 Uc_BFu7s_BFu0s) C1{ Fc Fs:7 Fs:0}



static void Test_Uc_BFu7s_BFu0s()
{
  {
    init_simple_test("Uc_BFu7s_BFu0s");
    static Uc_BFu7s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu7s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu7s_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu7s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Uc_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Uc_BFu7s_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu7s_BFu0s(Test_Uc_BFu7s_BFu0s, "Uc_BFu7s_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8c_BFu0c  {
  unsigned char v1;
  unsigned char v2:8;
  unsigned char  :0;
};
//SIG(1 Uc_BFu8c_BFu0c) C1{ Fc Fc:8 Fc:0}



static void Test_Uc_BFu8c_BFu0c()
{
  {
    init_simple_test("Uc_BFu8c_BFu0c");
    static Uc_BFu8c_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu8c_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_BFu8c_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu8c_BFu0c(Test_Uc_BFu8c_BFu0c, "Uc_BFu8c_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8c_BFu0i  {
  unsigned char v1;
  unsigned char v2:8;
  unsigned int  :0;
};
//SIG(1 Uc_BFu8c_BFu0i) C1{ Fc Fc:8 Fi:0}



static void Test_Uc_BFu8c_BFu0i()
{
  {
    init_simple_test("Uc_BFu8c_BFu0i");
    static Uc_BFu8c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu8c_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu8c_BFu0i(Test_Uc_BFu8c_BFu0i, "Uc_BFu8c_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8c_BFu0ll  {
  unsigned char v1;
  unsigned char v2:8;
  __tsu64  :0;
};
//SIG(1 Uc_BFu8c_BFu0ll) C1{ Fc Fc:8 FL:0}



static void Test_Uc_BFu8c_BFu0ll()
{
  {
    init_simple_test("Uc_BFu8c_BFu0ll");
    static Uc_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu8c_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu8c_BFu0ll(Test_Uc_BFu8c_BFu0ll, "Uc_BFu8c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8c_BFu0s  {
  unsigned char v1;
  unsigned char v2:8;
  unsigned short  :0;
};
//SIG(1 Uc_BFu8c_BFu0s) C1{ Fc Fc:8 Fs:0}



static void Test_Uc_BFu8c_BFu0s()
{
  {
    init_simple_test("Uc_BFu8c_BFu0s");
    static Uc_BFu8c_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu8c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_BFu8c_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8c_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8c_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu8c_BFu0s(Test_Uc_BFu8c_BFu0s, "Uc_BFu8c_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8i_BFu0c  {
  unsigned char v1;
  unsigned int v2:8;
  unsigned char  :0;
};
//SIG(1 Uc_BFu8i_BFu0c) C1{ Fc Fi:8 Fc:0}



static void Test_Uc_BFu8i_BFu0c()
{
  {
    init_simple_test("Uc_BFu8i_BFu0c");
    static Uc_BFu8i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu8i_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu8i_BFu0c(Test_Uc_BFu8i_BFu0c, "Uc_BFu8i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8i_BFu0i  {
  unsigned char v1;
  unsigned int v2:8;
  unsigned int  :0;
};
//SIG(1 Uc_BFu8i_BFu0i) C1{ Fc Fi:8 Fi:0}



static void Test_Uc_BFu8i_BFu0i()
{
  {
    init_simple_test("Uc_BFu8i_BFu0i");
    static Uc_BFu8i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu8i_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu8i_BFu0i(Test_Uc_BFu8i_BFu0i, "Uc_BFu8i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8i_BFu0ll  {
  unsigned char v1;
  unsigned int v2:8;
  __tsu64  :0;
};
//SIG(1 Uc_BFu8i_BFu0ll) C1{ Fc Fi:8 FL:0}



static void Test_Uc_BFu8i_BFu0ll()
{
  {
    init_simple_test("Uc_BFu8i_BFu0ll");
    static Uc_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu8i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu8i_BFu0ll(Test_Uc_BFu8i_BFu0ll, "Uc_BFu8i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8i_BFu0s  {
  unsigned char v1;
  unsigned int v2:8;
  unsigned short  :0;
};
//SIG(1 Uc_BFu8i_BFu0s) C1{ Fc Fi:8 Fs:0}



static void Test_Uc_BFu8i_BFu0s()
{
  {
    init_simple_test("Uc_BFu8i_BFu0s");
    static Uc_BFu8i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu8i_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8i_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu8i_BFu0s(Test_Uc_BFu8i_BFu0s, "Uc_BFu8i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8ll_BFu0c  {
  unsigned char v1;
  __tsu64 v2:8;
  unsigned char  :0;
};
//SIG(1 Uc_BFu8ll_BFu0c) C1{ Fc FL:8 Fc:0}



static void Test_Uc_BFu8ll_BFu0c()
{
  {
    init_simple_test("Uc_BFu8ll_BFu0c");
    static Uc_BFu8ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu8ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu8ll_BFu0c(Test_Uc_BFu8ll_BFu0c, "Uc_BFu8ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8ll_BFu0i  {
  unsigned char v1;
  __tsu64 v2:8;
  unsigned int  :0;
};
//SIG(1 Uc_BFu8ll_BFu0i) C1{ Fc FL:8 Fi:0}



static void Test_Uc_BFu8ll_BFu0i()
{
  {
    init_simple_test("Uc_BFu8ll_BFu0i");
    static Uc_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu8ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu8ll_BFu0i(Test_Uc_BFu8ll_BFu0i, "Uc_BFu8ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8ll_BFu0ll  {
  unsigned char v1;
  __tsu64 v2:8;
  __tsu64  :0;
};
//SIG(1 Uc_BFu8ll_BFu0ll) C1{ Fc FL:8 FL:0}



static void Test_Uc_BFu8ll_BFu0ll()
{
  {
    init_simple_test("Uc_BFu8ll_BFu0ll");
    static Uc_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu8ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu8ll_BFu0ll(Test_Uc_BFu8ll_BFu0ll, "Uc_BFu8ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8ll_BFu0s  {
  unsigned char v1;
  __tsu64 v2:8;
  unsigned short  :0;
};
//SIG(1 Uc_BFu8ll_BFu0s) C1{ Fc FL:8 Fs:0}



static void Test_Uc_BFu8ll_BFu0s()
{
  {
    init_simple_test("Uc_BFu8ll_BFu0s");
    static Uc_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu8ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu8ll_BFu0s(Test_Uc_BFu8ll_BFu0s, "Uc_BFu8ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8s_BFu0c  {
  unsigned char v1;
  unsigned short v2:8;
  unsigned char  :0;
};
//SIG(1 Uc_BFu8s_BFu0c) C1{ Fc Fs:8 Fc:0}



static void Test_Uc_BFu8s_BFu0c()
{
  {
    init_simple_test("Uc_BFu8s_BFu0c");
    static Uc_BFu8s_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu8s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu8s_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu8s_BFu0c(Test_Uc_BFu8s_BFu0c, "Uc_BFu8s_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8s_BFu0i  {
  unsigned char v1;
  unsigned short v2:8;
  unsigned int  :0;
};
//SIG(1 Uc_BFu8s_BFu0i) C1{ Fc Fs:8 Fi:0}



static void Test_Uc_BFu8s_BFu0i()
{
  {
    init_simple_test("Uc_BFu8s_BFu0i");
    static Uc_BFu8s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu8s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu8s_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu8s_BFu0i(Test_Uc_BFu8s_BFu0i, "Uc_BFu8s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8s_BFu0ll  {
  unsigned char v1;
  unsigned short v2:8;
  __tsu64  :0;
};
//SIG(1 Uc_BFu8s_BFu0ll) C1{ Fc Fs:8 FL:0}



static void Test_Uc_BFu8s_BFu0ll()
{
  {
    init_simple_test("Uc_BFu8s_BFu0ll");
    static Uc_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu8s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu8s_BFu0ll(Test_Uc_BFu8s_BFu0ll, "Uc_BFu8s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu8s_BFu0s  {
  unsigned char v1;
  unsigned short v2:8;
  unsigned short  :0;
};
//SIG(1 Uc_BFu8s_BFu0s) C1{ Fc Fs:8 Fs:0}



static void Test_Uc_BFu8s_BFu0s()
{
  {
    init_simple_test("Uc_BFu8s_BFu0s");
    static Uc_BFu8s_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_BFu8s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu8s_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu8s_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Uc_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Uc_BFu8s_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu8s_BFu0s(Test_Uc_BFu8s_BFu0s, "Uc_BFu8s_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu9i_BFu0c  {
  unsigned char v1;
  unsigned int v2:9;
  unsigned char  :0;
};
//SIG(1 Uc_BFu9i_BFu0c) C1{ Fc Fi:9 Fc:0}



static void Test_Uc_BFu9i_BFu0c()
{
  {
    init_simple_test("Uc_BFu9i_BFu0c");
    static Uc_BFu9i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu9i_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu9i_BFu0c(Test_Uc_BFu9i_BFu0c, "Uc_BFu9i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu9i_BFu0i  {
  unsigned char v1;
  unsigned int v2:9;
  unsigned int  :0;
};
//SIG(1 Uc_BFu9i_BFu0i) C1{ Fc Fi:9 Fi:0}



static void Test_Uc_BFu9i_BFu0i()
{
  {
    init_simple_test("Uc_BFu9i_BFu0i");
    static Uc_BFu9i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu9i_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu9i_BFu0i(Test_Uc_BFu9i_BFu0i, "Uc_BFu9i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu9i_BFu0ll  {
  unsigned char v1;
  unsigned int v2:9;
  __tsu64  :0;
};
//SIG(1 Uc_BFu9i_BFu0ll) C1{ Fc Fi:9 FL:0}



static void Test_Uc_BFu9i_BFu0ll()
{
  {
    init_simple_test("Uc_BFu9i_BFu0ll");
    static Uc_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_BFu9i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu9i_BFu0ll(Test_Uc_BFu9i_BFu0ll, "Uc_BFu9i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu9i_BFu0s  {
  unsigned char v1;
  unsigned int v2:9;
  unsigned short  :0;
};
//SIG(1 Uc_BFu9i_BFu0s) C1{ Fc Fi:9 Fs:0}



static void Test_Uc_BFu9i_BFu0s()
{
  {
    init_simple_test("Uc_BFu9i_BFu0s");
    static Uc_BFu9i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_BFu9i_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9i_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9i_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu9i_BFu0s(Test_Uc_BFu9i_BFu0s, "Uc_BFu9i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu9ll_BFu0c  {
  unsigned char v1;
  __tsu64 v2:9;
  unsigned char  :0;
};
//SIG(1 Uc_BFu9ll_BFu0c) C1{ Fc FL:9 Fc:0}



static void Test_Uc_BFu9ll_BFu0c()
{
  {
    init_simple_test("Uc_BFu9ll_BFu0c");
    static Uc_BFu9ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu9ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu9ll_BFu0c(Test_Uc_BFu9ll_BFu0c, "Uc_BFu9ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu9ll_BFu0i  {
  unsigned char v1;
  __tsu64 v2:9;
  unsigned int  :0;
};
//SIG(1 Uc_BFu9ll_BFu0i) C1{ Fc FL:9 Fi:0}



static void Test_Uc_BFu9ll_BFu0i()
{
  {
    init_simple_test("Uc_BFu9ll_BFu0i");
    static Uc_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu9ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu9ll_BFu0i(Test_Uc_BFu9ll_BFu0i, "Uc_BFu9ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu9ll_BFu0ll  {
  unsigned char v1;
  __tsu64 v2:9;
  __tsu64  :0;
};
//SIG(1 Uc_BFu9ll_BFu0ll) C1{ Fc FL:9 FL:0}



static void Test_Uc_BFu9ll_BFu0ll()
{
  {
    init_simple_test("Uc_BFu9ll_BFu0ll");
    static Uc_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu9ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu9ll_BFu0ll(Test_Uc_BFu9ll_BFu0ll, "Uc_BFu9ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu9ll_BFu0s  {
  unsigned char v1;
  __tsu64 v2:9;
  unsigned short  :0;
};
//SIG(1 Uc_BFu9ll_BFu0s) C1{ Fc FL:9 Fs:0}



static void Test_Uc_BFu9ll_BFu0s()
{
  {
    init_simple_test("Uc_BFu9ll_BFu0s");
    static Uc_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_BFu9ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Uc_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Uc_BFu9ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu9ll_BFu0s(Test_Uc_BFu9ll_BFu0s, "Uc_BFu9ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu9s_BFu0c  {
  unsigned char v1;
  unsigned short v2:9;
  unsigned char  :0;
};
//SIG(1 Uc_BFu9s_BFu0c) C1{ Fc Fs:9 Fc:0}



static void Test_Uc_BFu9s_BFu0c()
{
  {
    init_simple_test("Uc_BFu9s_BFu0c");
    static Uc_BFu9s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu9s_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu0c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Uc_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu0c");
  }
}
static Arrange_To_Call_Me vUc_BFu9s_BFu0c(Test_Uc_BFu9s_BFu0c, "Uc_BFu9s_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu9s_BFu0i  {
  unsigned char v1;
  unsigned short v2:9;
  unsigned int  :0;
};
//SIG(1 Uc_BFu9s_BFu0i) C1{ Fc Fs:9 Fi:0}



static void Test_Uc_BFu9s_BFu0i()
{
  {
    init_simple_test("Uc_BFu9s_BFu0i");
    static Uc_BFu9s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu9s_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu0i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Uc_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu0i");
  }
}
static Arrange_To_Call_Me vUc_BFu9s_BFu0i(Test_Uc_BFu9s_BFu0i, "Uc_BFu9s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu9s_BFu0ll  {
  unsigned char v1;
  unsigned short v2:9;
  __tsu64  :0;
};
//SIG(1 Uc_BFu9s_BFu0ll) C1{ Fc Fs:9 FL:0}



static void Test_Uc_BFu9s_BFu0ll()
{
  {
    init_simple_test("Uc_BFu9s_BFu0ll");
    static Uc_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_BFu9s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Uc_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu0ll");
  }
}
static Arrange_To_Call_Me vUc_BFu9s_BFu0ll(Test_Uc_BFu9s_BFu0ll, "Uc_BFu9s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_BFu9s_BFu0s  {
  unsigned char v1;
  unsigned short v2:9;
  unsigned short  :0;
};
//SIG(1 Uc_BFu9s_BFu0s) C1{ Fc Fs:9 Fs:0}



static void Test_Uc_BFu9s_BFu0s()
{
  {
    init_simple_test("Uc_BFu9s_BFu0s");
    static Uc_BFu9s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_BFu9s_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_BFu9s_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_BFu9s_BFu0s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Uc_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Uc_BFu9s_BFu0s");
  }
}
static Arrange_To_Call_Me vUc_BFu9s_BFu0s(Test_Uc_BFu9s_BFu0s, "Uc_BFu9s_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_C_BFu0c  {
  unsigned char v1;
  char v2;
  unsigned char  :0;
};
//SIG(1 Uc_C_BFu0c) C1{ Fc[2] Fc:0}



static void Test_Uc_C_BFu0c()
{
  {
    init_simple_test("Uc_C_BFu0c");
    static Uc_C_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_C_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_C_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu0c.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUc_C_BFu0c(Test_Uc_C_BFu0c, "Uc_C_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_C_BFu0i  {
  unsigned char v1;
  char v2;
  unsigned int  :0;
};
//SIG(1 Uc_C_BFu0i) C1{ Fc[2] Fi:0}



static void Test_Uc_C_BFu0i()
{
  {
    init_simple_test("Uc_C_BFu0i");
    static Uc_C_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_C_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_C_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu0i.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUc_C_BFu0i(Test_Uc_C_BFu0i, "Uc_C_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_C_BFu0ll  {
  unsigned char v1;
  char v2;
  __tsu64  :0;
};
//SIG(1 Uc_C_BFu0ll) C1{ Fc[2] FL:0}



static void Test_Uc_C_BFu0ll()
{
  {
    init_simple_test("Uc_C_BFu0ll");
    static Uc_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_C_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUc_C_BFu0ll(Test_Uc_C_BFu0ll, "Uc_C_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_C_BFu0s  {
  unsigned char v1;
  char v2;
  unsigned short  :0;
};
//SIG(1 Uc_C_BFu0s) C1{ Fc[2] Fs:0}



static void Test_Uc_C_BFu0s()
{
  {
    init_simple_test("Uc_C_BFu0s");
    static Uc_C_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_C_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_C_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_C_BFu0s.v1");
    check_field_offset(lv, v2, 1, "Uc_C_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUc_C_BFu0s(Test_Uc_C_BFu0s, "Uc_C_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_D_BFu0c  {
  unsigned char v1;
  double v2;
  unsigned char  :0;
};
//SIG(1 Uc_D_BFu0c) C1{ Fc FL Fc:0}



static void Test_Uc_D_BFu0c()
{
  {
    init_simple_test("Uc_D_BFu0c");
    static Uc_D_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUc_D_BFu0c(Test_Uc_D_BFu0c, "Uc_D_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_D_BFu0i  {
  unsigned char v1;
  double v2;
  unsigned int  :0;
};
//SIG(1 Uc_D_BFu0i) C1{ Fc FL Fi:0}



static void Test_Uc_D_BFu0i()
{
  {
    init_simple_test("Uc_D_BFu0i");
    static Uc_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUc_D_BFu0i(Test_Uc_D_BFu0i, "Uc_D_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_D_BFu0ll  {
  unsigned char v1;
  double v2;
  __tsu64  :0;
};
//SIG(1 Uc_D_BFu0ll) C1{ Fc FL FL:0}



static void Test_Uc_D_BFu0ll()
{
  {
    init_simple_test("Uc_D_BFu0ll");
    static Uc_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUc_D_BFu0ll(Test_Uc_D_BFu0ll, "Uc_D_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_D_BFu0s  {
  unsigned char v1;
  double v2;
  unsigned short  :0;
};
//SIG(1 Uc_D_BFu0s) C1{ Fc FL Fs:0}



static void Test_Uc_D_BFu0s()
{
  {
    init_simple_test("Uc_D_BFu0s");
    static Uc_D_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_D_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_D_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_D_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUc_D_BFu0s(Test_Uc_D_BFu0s, "Uc_D_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_F_BFu0c  {
  unsigned char v1;
  float v2;
  unsigned char  :0;
};
//SIG(1 Uc_F_BFu0c) C1{ Fc Fi Fc:0}



static void Test_Uc_F_BFu0c()
{
  {
    init_simple_test("Uc_F_BFu0c");
    static Uc_F_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Uc_F_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu0c.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUc_F_BFu0c(Test_Uc_F_BFu0c, "Uc_F_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_F_BFu0i  {
  unsigned char v1;
  float v2;
  unsigned int  :0;
};
//SIG(1 Uc_F_BFu0i) C1{ Fc Fi Fi:0}



static void Test_Uc_F_BFu0i()
{
  {
    init_simple_test("Uc_F_BFu0i");
    static Uc_F_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_F_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu0i.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUc_F_BFu0i(Test_Uc_F_BFu0i, "Uc_F_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_F_BFu0ll  {
  unsigned char v1;
  float v2;
  __tsu64  :0;
};
//SIG(1 Uc_F_BFu0ll) C1{ Fc Fi FL:0}



static void Test_Uc_F_BFu0ll()
{
  {
    init_simple_test("Uc_F_BFu0ll");
    static Uc_F_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_F_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUc_F_BFu0ll(Test_Uc_F_BFu0ll, "Uc_F_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_F_BFu0s  {
  unsigned char v1;
  float v2;
  unsigned short  :0;
};
//SIG(1 Uc_F_BFu0s) C1{ Fc Fi Fs:0}



static void Test_Uc_F_BFu0s()
{
  {
    init_simple_test("Uc_F_BFu0s");
    static Uc_F_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Uc_F_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_F_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_F_BFu0s.v1");
    check_field_offset(lv, v2, 4, "Uc_F_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUc_F_BFu0s(Test_Uc_F_BFu0s, "Uc_F_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_I_BFu0c  {
  unsigned char v1;
  int v2;
  unsigned char  :0;
};
//SIG(1 Uc_I_BFu0c) C1{ Fc Fi Fc:0}



static void Test_Uc_I_BFu0c()
{
  {
    init_simple_test("Uc_I_BFu0c");
    static Uc_I_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Uc_I_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu0c.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUc_I_BFu0c(Test_Uc_I_BFu0c, "Uc_I_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_I_BFu0i  {
  unsigned char v1;
  int v2;
  unsigned int  :0;
};
//SIG(1 Uc_I_BFu0i) C1{ Fc Fi Fi:0}



static void Test_Uc_I_BFu0i()
{
  {
    init_simple_test("Uc_I_BFu0i");
    static Uc_I_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_I_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu0i.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUc_I_BFu0i(Test_Uc_I_BFu0i, "Uc_I_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_I_BFu0ll  {
  unsigned char v1;
  int v2;
  __tsu64  :0;
};
//SIG(1 Uc_I_BFu0ll) C1{ Fc Fi FL:0}



static void Test_Uc_I_BFu0ll()
{
  {
    init_simple_test("Uc_I_BFu0ll");
    static Uc_I_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_I_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUc_I_BFu0ll(Test_Uc_I_BFu0ll, "Uc_I_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_I_BFu0s  {
  unsigned char v1;
  int v2;
  unsigned short  :0;
};
//SIG(1 Uc_I_BFu0s) C1{ Fc Fi Fs:0}



static void Test_Uc_I_BFu0s()
{
  {
    init_simple_test("Uc_I_BFu0s");
    static Uc_I_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Uc_I_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_I_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_I_BFu0s.v1");
    check_field_offset(lv, v2, 4, "Uc_I_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUc_I_BFu0s(Test_Uc_I_BFu0s, "Uc_I_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Ip_BFu0c  {
  unsigned char v1;
  int *v2;
  unsigned char  :0;
};
//SIG(1 Uc_Ip_BFu0c) C1{ Fc Fp Fc:0}



static void Test_Uc_Ip_BFu0c()
{
  {
    init_simple_test("Uc_Ip_BFu0c");
    static Uc_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUc_Ip_BFu0c(Test_Uc_Ip_BFu0c, "Uc_Ip_BFu0c", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Ip_BFu0i  {
  unsigned char v1;
  int *v2;
  unsigned int  :0;
};
//SIG(1 Uc_Ip_BFu0i) C1{ Fc Fp Fi:0}



static void Test_Uc_Ip_BFu0i()
{
  {
    init_simple_test("Uc_Ip_BFu0i");
    static Uc_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUc_Ip_BFu0i(Test_Uc_Ip_BFu0i, "Uc_Ip_BFu0i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Ip_BFu0ll  {
  unsigned char v1;
  int *v2;
  __tsu64  :0;
};
//SIG(1 Uc_Ip_BFu0ll) C1{ Fc Fp FL:0}



static void Test_Uc_Ip_BFu0ll()
{
  {
    init_simple_test("Uc_Ip_BFu0ll");
    static Uc_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUc_Ip_BFu0ll(Test_Uc_Ip_BFu0ll, "Uc_Ip_BFu0ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Ip_BFu0s  {
  unsigned char v1;
  int *v2;
  unsigned short  :0;
};
//SIG(1 Uc_Ip_BFu0s) C1{ Fc Fp Fs:0}



static void Test_Uc_Ip_BFu0s()
{
  {
    init_simple_test("Uc_Ip_BFu0s");
    static Uc_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ip_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_Ip_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ip_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUc_Ip_BFu0s(Test_Uc_Ip_BFu0s, "Uc_Ip_BFu0s", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_L_BFu0c  {
  unsigned char v1;
  __tsi64 v2;
  unsigned char  :0;
};
//SIG(1 Uc_L_BFu0c) C1{ Fc FL Fc:0}



static void Test_Uc_L_BFu0c()
{
  {
    init_simple_test("Uc_L_BFu0c");
    static Uc_L_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUc_L_BFu0c(Test_Uc_L_BFu0c, "Uc_L_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_L_BFu0i  {
  unsigned char v1;
  __tsi64 v2;
  unsigned int  :0;
};
//SIG(1 Uc_L_BFu0i) C1{ Fc FL Fi:0}



static void Test_Uc_L_BFu0i()
{
  {
    init_simple_test("Uc_L_BFu0i");
    static Uc_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUc_L_BFu0i(Test_Uc_L_BFu0i, "Uc_L_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_L_BFu0ll  {
  unsigned char v1;
  __tsi64 v2;
  __tsu64  :0;
};
//SIG(1 Uc_L_BFu0ll) C1{ Fc FL FL:0}



static void Test_Uc_L_BFu0ll()
{
  {
    init_simple_test("Uc_L_BFu0ll");
    static Uc_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUc_L_BFu0ll(Test_Uc_L_BFu0ll, "Uc_L_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_L_BFu0s  {
  unsigned char v1;
  __tsi64 v2;
  unsigned short  :0;
};
//SIG(1 Uc_L_BFu0s) C1{ Fc FL Fs:0}



static void Test_Uc_L_BFu0s()
{
  {
    init_simple_test("Uc_L_BFu0s");
    static Uc_L_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_L_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_L_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_L_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUc_L_BFu0s(Test_Uc_L_BFu0s, "Uc_L_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_S_BFu0c  {
  unsigned char v1;
  short v2;
  unsigned char  :0;
};
//SIG(1 Uc_S_BFu0c) C1{ Fc Fs Fc:0}



static void Test_Uc_S_BFu0c()
{
  {
    init_simple_test("Uc_S_BFu0c");
    static Uc_S_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_S_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu0c.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUc_S_BFu0c(Test_Uc_S_BFu0c, "Uc_S_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_S_BFu0i  {
  unsigned char v1;
  short v2;
  unsigned int  :0;
};
//SIG(1 Uc_S_BFu0i) C1{ Fc Fs Fi:0}



static void Test_Uc_S_BFu0i()
{
  {
    init_simple_test("Uc_S_BFu0i");
    static Uc_S_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_S_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_S_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu0i.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUc_S_BFu0i(Test_Uc_S_BFu0i, "Uc_S_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_S_BFu0ll  {
  unsigned char v1;
  short v2;
  __tsu64  :0;
};
//SIG(1 Uc_S_BFu0ll) C1{ Fc Fs FL:0}



static void Test_Uc_S_BFu0ll()
{
  {
    init_simple_test("Uc_S_BFu0ll");
    static Uc_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_S_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUc_S_BFu0ll(Test_Uc_S_BFu0ll, "Uc_S_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_S_BFu0s  {
  unsigned char v1;
  short v2;
  unsigned short  :0;
};
//SIG(1 Uc_S_BFu0s) C1{ Fc Fs Fs:0}



static void Test_Uc_S_BFu0s()
{
  {
    init_simple_test("Uc_S_BFu0s");
    static Uc_S_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_S_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_S_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_S_BFu0s.v1");
    check_field_offset(lv, v2, 2, "Uc_S_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUc_S_BFu0s(Test_Uc_S_BFu0s, "Uc_S_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Uc_BFu0c  {
  unsigned char v1;
  unsigned char v2;
  unsigned char  :0;
};
//SIG(1 Uc_Uc_BFu0c) C1{ Fc[2] Fc:0}



static void Test_Uc_Uc_BFu0c()
{
  {
    init_simple_test("Uc_Uc_BFu0c");
    static Uc_Uc_BFu0c lv;
    check2(sizeof(lv), 2, "sizeof(Uc_Uc_BFu0c)");
    check2(__alignof__(lv), 1, "__alignof__(Uc_Uc_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu0c.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUc_Uc_BFu0c(Test_Uc_Uc_BFu0c, "Uc_Uc_BFu0c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Uc_BFu0i  {
  unsigned char v1;
  unsigned char v2;
  unsigned int  :0;
};
//SIG(1 Uc_Uc_BFu0i) C1{ Fc[2] Fi:0}



static void Test_Uc_Uc_BFu0i()
{
  {
    init_simple_test("Uc_Uc_BFu0i");
    static Uc_Uc_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Uc_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_Uc_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu0i.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUc_Uc_BFu0i(Test_Uc_Uc_BFu0i, "Uc_Uc_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Uc_BFu0ll  {
  unsigned char v1;
  unsigned char v2;
  __tsu64  :0;
};
//SIG(1 Uc_Uc_BFu0ll) C1{ Fc[2] FL:0}



static void Test_Uc_Uc_BFu0ll()
{
  {
    init_simple_test("Uc_Uc_BFu0ll");
    static Uc_Uc_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_Uc_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu0ll.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUc_Uc_BFu0ll(Test_Uc_Uc_BFu0ll, "Uc_Uc_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Uc_BFu0s  {
  unsigned char v1;
  unsigned char v2;
  unsigned short  :0;
};
//SIG(1 Uc_Uc_BFu0s) C1{ Fc[2] Fs:0}



static void Test_Uc_Uc_BFu0s()
{
  {
    init_simple_test("Uc_Uc_BFu0s");
    static Uc_Uc_BFu0s lv;
    check2(sizeof(lv), 2, "sizeof(Uc_Uc_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(Uc_Uc_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_Uc_BFu0s.v1");
    check_field_offset(lv, v2, 1, "Uc_Uc_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUc_Uc_BFu0s(Test_Uc_Uc_BFu0s, "Uc_Uc_BFu0s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Ui_BFu0c  {
  unsigned char v1;
  unsigned int v2;
  unsigned char  :0;
};
//SIG(1 Uc_Ui_BFu0c) C1{ Fc Fi Fc:0}



static void Test_Uc_Ui_BFu0c()
{
  {
    init_simple_test("Uc_Ui_BFu0c");
    static Uc_Ui_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Ui_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu0c.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUc_Ui_BFu0c(Test_Uc_Ui_BFu0c, "Uc_Ui_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Ui_BFu0i  {
  unsigned char v1;
  unsigned int v2;
  unsigned int  :0;
};
//SIG(1 Uc_Ui_BFu0i) C1{ Fc Fi Fi:0}



static void Test_Uc_Ui_BFu0i()
{
  {
    init_simple_test("Uc_Ui_BFu0i");
    static Uc_Ui_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Ui_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu0i.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUc_Ui_BFu0i(Test_Uc_Ui_BFu0i, "Uc_Ui_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Ui_BFu0ll  {
  unsigned char v1;
  unsigned int v2;
  __tsu64  :0;
};
//SIG(1 Uc_Ui_BFu0ll) C1{ Fc Fi FL:0}



static void Test_Uc_Ui_BFu0ll()
{
  {
    init_simple_test("Uc_Ui_BFu0ll");
    static Uc_Ui_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Uc_Ui_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUc_Ui_BFu0ll(Test_Uc_Ui_BFu0ll, "Uc_Ui_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Ui_BFu0s  {
  unsigned char v1;
  unsigned int v2;
  unsigned short  :0;
};
//SIG(1 Uc_Ui_BFu0s) C1{ Fc Fi Fs:0}



static void Test_Uc_Ui_BFu0s()
{
  {
    init_simple_test("Uc_Ui_BFu0s");
    static Uc_Ui_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Uc_Ui_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Uc_Ui_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_Ui_BFu0s.v1");
    check_field_offset(lv, v2, 4, "Uc_Ui_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUc_Ui_BFu0s(Test_Uc_Ui_BFu0s, "Uc_Ui_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Ul_BFu0c  {
  unsigned char v1;
  __tsu64 v2;
  unsigned char  :0;
};
//SIG(1 Uc_Ul_BFu0c) C1{ Fc FL Fc:0}



static void Test_Uc_Ul_BFu0c()
{
  {
    init_simple_test("Uc_Ul_BFu0c");
    static Uc_Ul_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUc_Ul_BFu0c(Test_Uc_Ul_BFu0c, "Uc_Ul_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Ul_BFu0i  {
  unsigned char v1;
  __tsu64 v2;
  unsigned int  :0;
};
//SIG(1 Uc_Ul_BFu0i) C1{ Fc FL Fi:0}



static void Test_Uc_Ul_BFu0i()
{
  {
    init_simple_test("Uc_Ul_BFu0i");
    static Uc_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUc_Ul_BFu0i(Test_Uc_Ul_BFu0i, "Uc_Ul_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Ul_BFu0ll  {
  unsigned char v1;
  __tsu64 v2;
  __tsu64  :0;
};
//SIG(1 Uc_Ul_BFu0ll) C1{ Fc FL FL:0}



static void Test_Uc_Ul_BFu0ll()
{
  {
    init_simple_test("Uc_Ul_BFu0ll");
    static Uc_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUc_Ul_BFu0ll(Test_Uc_Ul_BFu0ll, "Uc_Ul_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Ul_BFu0s  {
  unsigned char v1;
  __tsu64 v2;
  unsigned short  :0;
};
//SIG(1 Uc_Ul_BFu0s) C1{ Fc FL Fs:0}



static void Test_Uc_Ul_BFu0s()
{
  {
    init_simple_test("Uc_Ul_BFu0s");
    static Uc_Ul_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Uc_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Ul_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_Ul_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Ul_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUc_Ul_BFu0s(Test_Uc_Ul_BFu0s, "Uc_Ul_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Us_BFu0c  {
  unsigned char v1;
  unsigned short v2;
  unsigned char  :0;
};
//SIG(1 Uc_Us_BFu0c) C1{ Fc Fs Fc:0}



static void Test_Uc_Us_BFu0c()
{
  {
    init_simple_test("Uc_Us_BFu0c");
    static Uc_Us_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Us_BFu0c)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu0c.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUc_Us_BFu0c(Test_Uc_Us_BFu0c, "Uc_Us_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Us_BFu0i  {
  unsigned char v1;
  unsigned short v2;
  unsigned int  :0;
};
//SIG(1 Uc_Us_BFu0i) C1{ Fc Fs Fi:0}



static void Test_Uc_Us_BFu0i()
{
  {
    init_simple_test("Uc_Us_BFu0i");
    static Uc_Us_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Us_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_Us_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu0i.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUc_Us_BFu0i(Test_Uc_Us_BFu0i, "Uc_Us_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Us_BFu0ll  {
  unsigned char v1;
  unsigned short v2;
  __tsu64  :0;
};
//SIG(1 Uc_Us_BFu0ll) C1{ Fc Fs FL:0}



static void Test_Uc_Us_BFu0ll()
{
  {
    init_simple_test("Uc_Us_BFu0ll");
    static Uc_Us_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Uc_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(Uc_Us_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu0ll.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUc_Us_BFu0ll(Test_Uc_Us_BFu0ll, "Uc_Us_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Us_BFu0s  {
  unsigned char v1;
  unsigned short v2;
  unsigned short  :0;
};
//SIG(1 Uc_Us_BFu0s) C1{ Fc Fs Fs:0}



static void Test_Uc_Us_BFu0s()
{
  {
    init_simple_test("Uc_Us_BFu0s");
    static Uc_Us_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Uc_Us_BFu0s)");
    check2(__alignof__(lv), 2, "__alignof__(Uc_Us_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_Us_BFu0s.v1");
    check_field_offset(lv, v2, 2, "Uc_Us_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUc_Us_BFu0s(Test_Uc_Us_BFu0s, "Uc_Us_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Vp_BFu0c  {
  unsigned char v1;
  void *v2;
  unsigned char  :0;
};
//SIG(1 Uc_Vp_BFu0c) C1{ Fc Fp Fc:0}



static void Test_Uc_Vp_BFu0c()
{
  {
    init_simple_test("Uc_Vp_BFu0c");
    static Uc_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_Vp_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu0c)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUc_Vp_BFu0c(Test_Uc_Vp_BFu0c, "Uc_Vp_BFu0c", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Vp_BFu0i  {
  unsigned char v1;
  void *v2;
  unsigned int  :0;
};
//SIG(1 Uc_Vp_BFu0i) C1{ Fc Fp Fi:0}



static void Test_Uc_Vp_BFu0i()
{
  {
    init_simple_test("Uc_Vp_BFu0i");
    static Uc_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu0i)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUc_Vp_BFu0i(Test_Uc_Vp_BFu0i, "Uc_Vp_BFu0i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Vp_BFu0ll  {
  unsigned char v1;
  void *v2;
  __tsu64  :0;
};
//SIG(1 Uc_Vp_BFu0ll) C1{ Fc Fp FL:0}



static void Test_Uc_Vp_BFu0ll()
{
  {
    init_simple_test("Uc_Vp_BFu0ll");
    static Uc_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu0ll)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUc_Vp_BFu0ll(Test_Uc_Vp_BFu0ll, "Uc_Vp_BFu0ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Uc_Vp_BFu0s  {
  unsigned char v1;
  void *v2;
  unsigned short  :0;
};
//SIG(1 Uc_Vp_BFu0s) C1{ Fc Fp Fs:0}



static void Test_Uc_Vp_BFu0s()
{
  {
    init_simple_test("Uc_Vp_BFu0s");
    static Uc_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Uc_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Uc_Vp_BFu0s)");
    check_field_offset(lv, v1, 0, "Uc_Vp_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Uc_Vp_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUc_Vp_BFu0s(Test_Uc_Vp_BFu0s, "Uc_Vp_BFu0s", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c  {
  unsigned int v1;
  unsigned char  :0;
};
//SIG(1 Ui_BFu0c) C1{ Fi Fc:0}



static void Test_Ui_BFu0c()
{
  {
    init_simple_test("Ui_BFu0c");
    static Ui_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Ui_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0c(Test_Ui_BFu0c, "Ui_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu0c  {
  unsigned int v1;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 Ui_BFu0c_BFu0c) C1{ Fi Fc:0 Fc:0}



static void Test_Ui_BFu0c_BFu0c()
{
  {
    init_simple_test("Ui_BFu0c_BFu0c");
    static Ui_BFu0c_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Ui_BFu0c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu0c(Test_Ui_BFu0c_BFu0c, "Ui_BFu0c_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu0i  {
  unsigned int v1;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 Ui_BFu0c_BFu0i) C1{ Fi Fc:0 Fi:0}



static void Test_Ui_BFu0c_BFu0i()
{
  {
    init_simple_test("Ui_BFu0c_BFu0i");
    static Ui_BFu0c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Ui_BFu0c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu0i(Test_Ui_BFu0c_BFu0i, "Ui_BFu0c_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu0ll  {
  unsigned int v1;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 Ui_BFu0c_BFu0ll) C1{ Fi Fc:0 FL:0}



static void Test_Ui_BFu0c_BFu0ll()
{
  {
    init_simple_test("Ui_BFu0c_BFu0ll");
    static Ui_BFu0c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Ui_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0c_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu0ll(Test_Ui_BFu0c_BFu0ll, "Ui_BFu0c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu0s  {
  unsigned int v1;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 Ui_BFu0c_BFu0s) C1{ Fi Fc:0 Fs:0}



static void Test_Ui_BFu0c_BFu0s()
{
  {
    init_simple_test("Ui_BFu0c_BFu0s");
    static Ui_BFu0c_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Ui_BFu0c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu0s(Test_Ui_BFu0c_BFu0s, "Ui_BFu0c_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu15i  {
  unsigned int v1;
  unsigned char  :0;
  unsigned int v2:15;
};
//SIG(1 Ui_BFu0c_BFu15i) C1{ Fi Fc:0 Fi:15}



static void Test_Ui_BFu0c_BFu15i()
{
  {
    init_simple_test("Ui_BFu0c_BFu15i");
    static Ui_BFu0c_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu0c_BFu15i");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu15i(Test_Ui_BFu0c_BFu15i, "Ui_BFu0c_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu15ll  {
  unsigned int v1;
  unsigned char  :0;
  __tsu64 v2:15;
};
//SIG(1 Ui_BFu0c_BFu15ll) C1{ Fi Fc:0 FL:15}



static void Test_Ui_BFu0c_BFu15ll()
{
  {
    init_simple_test("Ui_BFu0c_BFu15ll");
    static Ui_BFu0c_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu0c_BFu15ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu15ll(Test_Ui_BFu0c_BFu15ll, "Ui_BFu0c_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu15s  {
  unsigned int v1;
  unsigned char  :0;
  unsigned short v2:15;
};
//SIG(1 Ui_BFu0c_BFu15s) C1{ Fi Fc:0 Fs:15}



static void Test_Ui_BFu0c_BFu15s()
{
  {
    init_simple_test("Ui_BFu0c_BFu15s");
    static Ui_BFu0c_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu0c_BFu15s");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu15s(Test_Ui_BFu0c_BFu15s, "Ui_BFu0c_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu16i  {
  unsigned int v1;
  unsigned char  :0;
  unsigned int v2:16;
};
//SIG(1 Ui_BFu0c_BFu16i) C1{ Fi Fc:0 Fi:16}



static void Test_Ui_BFu0c_BFu16i()
{
  {
    init_simple_test("Ui_BFu0c_BFu16i");
    static Ui_BFu0c_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu0c_BFu16i");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu16i(Test_Ui_BFu0c_BFu16i, "Ui_BFu0c_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu16ll  {
  unsigned int v1;
  unsigned char  :0;
  __tsu64 v2:16;
};
//SIG(1 Ui_BFu0c_BFu16ll) C1{ Fi Fc:0 FL:16}



static void Test_Ui_BFu0c_BFu16ll()
{
  {
    init_simple_test("Ui_BFu0c_BFu16ll");
    static Ui_BFu0c_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu0c_BFu16ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu16ll(Test_Ui_BFu0c_BFu16ll, "Ui_BFu0c_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu16s  {
  unsigned int v1;
  unsigned char  :0;
  unsigned short v2:16;
};
//SIG(1 Ui_BFu0c_BFu16s) C1{ Fi Fc:0 Fs:16}



static void Test_Ui_BFu0c_BFu16s()
{
  {
    init_simple_test("Ui_BFu0c_BFu16s");
    static Ui_BFu0c_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu0c_BFu16s");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu16s(Test_Ui_BFu0c_BFu16s, "Ui_BFu0c_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu17i  {
  unsigned int v1;
  unsigned char  :0;
  unsigned int v2:17;
};
//SIG(1 Ui_BFu0c_BFu17i) C1{ Fi Fc:0 Fi:17}



static void Test_Ui_BFu0c_BFu17i()
{
  {
    init_simple_test("Ui_BFu0c_BFu17i");
    static Ui_BFu0c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu0c_BFu17i");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu17i(Test_Ui_BFu0c_BFu17i, "Ui_BFu0c_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu17ll  {
  unsigned int v1;
  unsigned char  :0;
  __tsu64 v2:17;
};
//SIG(1 Ui_BFu0c_BFu17ll) C1{ Fi Fc:0 FL:17}



static void Test_Ui_BFu0c_BFu17ll()
{
  {
    init_simple_test("Ui_BFu0c_BFu17ll");
    static Ui_BFu0c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu0c_BFu17ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu17ll(Test_Ui_BFu0c_BFu17ll, "Ui_BFu0c_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu1c  {
  unsigned int v1;
  unsigned char  :0;
  unsigned char v2:1;
};
//SIG(1 Ui_BFu0c_BFu1c) C1{ Fi Fc:0 Fc:1}



static void Test_Ui_BFu0c_BFu1c()
{
  {
    init_simple_test("Ui_BFu0c_BFu1c");
    static Ui_BFu0c_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu0c_BFu1c");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu1c(Test_Ui_BFu0c_BFu1c, "Ui_BFu0c_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu1i  {
  unsigned int v1;
  unsigned char  :0;
  unsigned int v2:1;
};
//SIG(1 Ui_BFu0c_BFu1i) C1{ Fi Fc:0 Fi:1}



static void Test_Ui_BFu0c_BFu1i()
{
  {
    init_simple_test("Ui_BFu0c_BFu1i");
    static Ui_BFu0c_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu0c_BFu1i");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu1i(Test_Ui_BFu0c_BFu1i, "Ui_BFu0c_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu1ll  {
  unsigned int v1;
  unsigned char  :0;
  __tsu64 v2:1;
};
//SIG(1 Ui_BFu0c_BFu1ll) C1{ Fi Fc:0 FL:1}



static void Test_Ui_BFu0c_BFu1ll()
{
  {
    init_simple_test("Ui_BFu0c_BFu1ll");
    static Ui_BFu0c_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu0c_BFu1ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu1ll(Test_Ui_BFu0c_BFu1ll, "Ui_BFu0c_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu1s  {
  unsigned int v1;
  unsigned char  :0;
  unsigned short v2:1;
};
//SIG(1 Ui_BFu0c_BFu1s) C1{ Fi Fc:0 Fs:1}



static void Test_Ui_BFu0c_BFu1s()
{
  {
    init_simple_test("Ui_BFu0c_BFu1s");
    static Ui_BFu0c_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu0c_BFu1s");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu1s(Test_Ui_BFu0c_BFu1s, "Ui_BFu0c_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu31i  {
  unsigned int v1;
  unsigned char  :0;
  unsigned int v2:31;
};
//SIG(1 Ui_BFu0c_BFu31i) C1{ Fi Fc:0 Fi:31}



static void Test_Ui_BFu0c_BFu31i()
{
  {
    init_simple_test("Ui_BFu0c_BFu31i");
    static Ui_BFu0c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu0c_BFu31i");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu31i(Test_Ui_BFu0c_BFu31i, "Ui_BFu0c_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu31ll  {
  unsigned int v1;
  unsigned char  :0;
  __tsu64 v2:31;
};
//SIG(1 Ui_BFu0c_BFu31ll) C1{ Fi Fc:0 FL:31}



static void Test_Ui_BFu0c_BFu31ll()
{
  {
    init_simple_test("Ui_BFu0c_BFu31ll");
    static Ui_BFu0c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu0c_BFu31ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu31ll(Test_Ui_BFu0c_BFu31ll, "Ui_BFu0c_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu32i  {
  unsigned int v1;
  unsigned char  :0;
  unsigned int v2:32;
};
//SIG(1 Ui_BFu0c_BFu32i) C1{ Fi Fc:0 Fi:32}



static void Test_Ui_BFu0c_BFu32i()
{
  {
    init_simple_test("Ui_BFu0c_BFu32i");
    static Ui_BFu0c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu0c_BFu32i");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu32i(Test_Ui_BFu0c_BFu32i, "Ui_BFu0c_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu32ll  {
  unsigned int v1;
  unsigned char  :0;
  __tsu64 v2:32;
};
//SIG(1 Ui_BFu0c_BFu32ll) C1{ Fi Fc:0 FL:32}



static void Test_Ui_BFu0c_BFu32ll()
{
  {
    init_simple_test("Ui_BFu0c_BFu32ll");
    static Ui_BFu0c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu0c_BFu32ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu32ll(Test_Ui_BFu0c_BFu32ll, "Ui_BFu0c_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu33  {
  unsigned int v1;
  unsigned char  :0;
  __tsu64 v2:33;
};
//SIG(1 Ui_BFu0c_BFu33) C1{ Fi Fc:0 FL:33}



static void Test_Ui_BFu0c_BFu33()
{
  {
    init_simple_test("Ui_BFu0c_BFu33");
    static Ui_BFu0c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu0c_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu0c_BFu33");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu33(Test_Ui_BFu0c_BFu33, "Ui_BFu0c_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu7c  {
  unsigned int v1;
  unsigned char  :0;
  unsigned char v2:7;
};
//SIG(1 Ui_BFu0c_BFu7c) C1{ Fi Fc:0 Fc:7}



static void Test_Ui_BFu0c_BFu7c()
{
  {
    init_simple_test("Ui_BFu0c_BFu7c");
    static Ui_BFu0c_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu0c_BFu7c");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu7c(Test_Ui_BFu0c_BFu7c, "Ui_BFu0c_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu7i  {
  unsigned int v1;
  unsigned char  :0;
  unsigned int v2:7;
};
//SIG(1 Ui_BFu0c_BFu7i) C1{ Fi Fc:0 Fi:7}



static void Test_Ui_BFu0c_BFu7i()
{
  {
    init_simple_test("Ui_BFu0c_BFu7i");
    static Ui_BFu0c_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu0c_BFu7i");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu7i(Test_Ui_BFu0c_BFu7i, "Ui_BFu0c_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu7ll  {
  unsigned int v1;
  unsigned char  :0;
  __tsu64 v2:7;
};
//SIG(1 Ui_BFu0c_BFu7ll) C1{ Fi Fc:0 FL:7}



static void Test_Ui_BFu0c_BFu7ll()
{
  {
    init_simple_test("Ui_BFu0c_BFu7ll");
    static Ui_BFu0c_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu0c_BFu7ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu7ll(Test_Ui_BFu0c_BFu7ll, "Ui_BFu0c_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu7s  {
  unsigned int v1;
  unsigned char  :0;
  unsigned short v2:7;
};
//SIG(1 Ui_BFu0c_BFu7s) C1{ Fi Fc:0 Fs:7}



static void Test_Ui_BFu0c_BFu7s()
{
  {
    init_simple_test("Ui_BFu0c_BFu7s");
    static Ui_BFu0c_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu0c_BFu7s");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu7s(Test_Ui_BFu0c_BFu7s, "Ui_BFu0c_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu8c  {
  unsigned int v1;
  unsigned char  :0;
  unsigned char v2:8;
};
//SIG(1 Ui_BFu0c_BFu8c) C1{ Fi Fc:0 Fc:8}



static void Test_Ui_BFu0c_BFu8c()
{
  {
    init_simple_test("Ui_BFu0c_BFu8c");
    static Ui_BFu0c_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu0c_BFu8c");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu8c(Test_Ui_BFu0c_BFu8c, "Ui_BFu0c_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu8i  {
  unsigned int v1;
  unsigned char  :0;
  unsigned int v2:8;
};
//SIG(1 Ui_BFu0c_BFu8i) C1{ Fi Fc:0 Fi:8}



static void Test_Ui_BFu0c_BFu8i()
{
  {
    init_simple_test("Ui_BFu0c_BFu8i");
    static Ui_BFu0c_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu0c_BFu8i");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu8i(Test_Ui_BFu0c_BFu8i, "Ui_BFu0c_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu8ll  {
  unsigned int v1;
  unsigned char  :0;
  __tsu64 v2:8;
};
//SIG(1 Ui_BFu0c_BFu8ll) C1{ Fi Fc:0 FL:8}



static void Test_Ui_BFu0c_BFu8ll()
{
  {
    init_simple_test("Ui_BFu0c_BFu8ll");
    static Ui_BFu0c_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu0c_BFu8ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu8ll(Test_Ui_BFu0c_BFu8ll, "Ui_BFu0c_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu8s  {
  unsigned int v1;
  unsigned char  :0;
  unsigned short v2:8;
};
//SIG(1 Ui_BFu0c_BFu8s) C1{ Fi Fc:0 Fs:8}



static void Test_Ui_BFu0c_BFu8s()
{
  {
    init_simple_test("Ui_BFu0c_BFu8s");
    static Ui_BFu0c_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu0c_BFu8s");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu8s(Test_Ui_BFu0c_BFu8s, "Ui_BFu0c_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu9i  {
  unsigned int v1;
  unsigned char  :0;
  unsigned int v2:9;
};
//SIG(1 Ui_BFu0c_BFu9i) C1{ Fi Fc:0 Fi:9}



static void Test_Ui_BFu0c_BFu9i()
{
  {
    init_simple_test("Ui_BFu0c_BFu9i");
    static Ui_BFu0c_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu0c_BFu9i");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu9i(Test_Ui_BFu0c_BFu9i, "Ui_BFu0c_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu9ll  {
  unsigned int v1;
  unsigned char  :0;
  __tsu64 v2:9;
};
//SIG(1 Ui_BFu0c_BFu9ll) C1{ Fi Fc:0 FL:9}



static void Test_Ui_BFu0c_BFu9ll()
{
  {
    init_simple_test("Ui_BFu0c_BFu9ll");
    static Ui_BFu0c_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu0c_BFu9ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu9ll(Test_Ui_BFu0c_BFu9ll, "Ui_BFu0c_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_BFu9s  {
  unsigned int v1;
  unsigned char  :0;
  unsigned short v2:9;
};
//SIG(1 Ui_BFu0c_BFu9s) C1{ Fi Fc:0 Fs:9}



static void Test_Ui_BFu0c_BFu9s()
{
  {
    init_simple_test("Ui_BFu0c_BFu9s");
    static Ui_BFu0c_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu0c_BFu9s");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_BFu9s(Test_Ui_BFu0c_BFu9s, "Ui_BFu0c_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_C  {
  unsigned int v1;
  unsigned char  :0;
  char v2;
};
//SIG(1 Ui_BFu0c_C) C1{ Fi Fc:0 Fc}



static void Test_Ui_BFu0c_C()
{
  {
    init_simple_test("Ui_BFu0c_C");
    static Ui_BFu0c_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_C.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0c_C.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_C(Test_Ui_BFu0c_C, "Ui_BFu0c_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_D  {
  unsigned int v1;
  unsigned char  :0;
  double v2;
};
//SIG(1 Ui_BFu0c_D) C1{ Fi Fc:0 FL}



static void Test_Ui_BFu0c_D()
{
  {
    init_simple_test("Ui_BFu0c_D");
    static Ui_BFu0c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0c_D.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_D(Test_Ui_BFu0c_D, "Ui_BFu0c_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_F  {
  unsigned int v1;
  unsigned char  :0;
  float v2;
};
//SIG(1 Ui_BFu0c_F) C1{ Fi Fc:0 Fi}



static void Test_Ui_BFu0c_F()
{
  {
    init_simple_test("Ui_BFu0c_F");
    static Ui_BFu0c_F lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_F.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0c_F.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_F(Test_Ui_BFu0c_F, "Ui_BFu0c_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_I  {
  unsigned int v1;
  unsigned char  :0;
  int v2;
};
//SIG(1 Ui_BFu0c_I) C1{ Fi Fc:0 Fi}



static void Test_Ui_BFu0c_I()
{
  {
    init_simple_test("Ui_BFu0c_I");
    static Ui_BFu0c_I lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_I.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0c_I.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_I(Test_Ui_BFu0c_I, "Ui_BFu0c_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_Ip  {
  unsigned int v1;
  unsigned char  :0;
  int *v2;
};
//SIG(1 Ui_BFu0c_Ip) C1{ Fi Fc:0 Fp}



static void Test_Ui_BFu0c_Ip()
{
  {
    init_simple_test("Ui_BFu0c_Ip");
    static Ui_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0c_Ip.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_Ip(Test_Ui_BFu0c_Ip, "Ui_BFu0c_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_L  {
  unsigned int v1;
  unsigned char  :0;
  __tsi64 v2;
};
//SIG(1 Ui_BFu0c_L) C1{ Fi Fc:0 FL}



static void Test_Ui_BFu0c_L()
{
  {
    init_simple_test("Ui_BFu0c_L");
    static Ui_BFu0c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0c_L.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_L(Test_Ui_BFu0c_L, "Ui_BFu0c_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_S  {
  unsigned int v1;
  unsigned char  :0;
  short v2;
};
//SIG(1 Ui_BFu0c_S) C1{ Fi Fc:0 Fs}



static void Test_Ui_BFu0c_S()
{
  {
    init_simple_test("Ui_BFu0c_S");
    static Ui_BFu0c_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_S.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0c_S.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_S(Test_Ui_BFu0c_S, "Ui_BFu0c_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_Uc  {
  unsigned int v1;
  unsigned char  :0;
  unsigned char v2;
};
//SIG(1 Ui_BFu0c_Uc) C1{ Fi Fc:0 Fc}



static void Test_Ui_BFu0c_Uc()
{
  {
    init_simple_test("Ui_BFu0c_Uc");
    static Ui_BFu0c_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_Uc.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0c_Uc.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_Uc(Test_Ui_BFu0c_Uc, "Ui_BFu0c_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_Ui  {
  unsigned int v1;
  unsigned char  :0;
  unsigned int v2;
};
//SIG(1 Ui_BFu0c_Ui) C1{ Fi Fc:0 Fi}



static void Test_Ui_BFu0c_Ui()
{
  {
    init_simple_test("Ui_BFu0c_Ui");
    static Ui_BFu0c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_Ui.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0c_Ui.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_Ui(Test_Ui_BFu0c_Ui, "Ui_BFu0c_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_Ul  {
  unsigned int v1;
  unsigned char  :0;
  __tsu64 v2;
};
//SIG(1 Ui_BFu0c_Ul) C1{ Fi Fc:0 FL}



static void Test_Ui_BFu0c_Ul()
{
  {
    init_simple_test("Ui_BFu0c_Ul");
    static Ui_BFu0c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0c_Ul.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_Ul(Test_Ui_BFu0c_Ul, "Ui_BFu0c_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_Us  {
  unsigned int v1;
  unsigned char  :0;
  unsigned short v2;
};
//SIG(1 Ui_BFu0c_Us) C1{ Fi Fc:0 Fs}



static void Test_Ui_BFu0c_Us()
{
  {
    init_simple_test("Ui_BFu0c_Us");
    static Ui_BFu0c_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0c_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0c_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_Us.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0c_Us.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_Us(Test_Ui_BFu0c_Us, "Ui_BFu0c_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0c_Vp  {
  unsigned int v1;
  unsigned char  :0;
  void *v2;
};
//SIG(1 Ui_BFu0c_Vp) C1{ Fi Fc:0 Fp}



static void Test_Ui_BFu0c_Vp()
{
  {
    init_simple_test("Ui_BFu0c_Vp");
    static Ui_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0c_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu0c_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0c_Vp.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0c_Vp(Test_Ui_BFu0c_Vp, "Ui_BFu0c_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i  {
  unsigned int v1;
  unsigned int  :0;
};
//SIG(1 Ui_BFu0i) C1{ Fi Fi:0}



static void Test_Ui_BFu0i()
{
  {
    init_simple_test("Ui_BFu0i");
    static Ui_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Ui_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0i(Test_Ui_BFu0i, "Ui_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu0c  {
  unsigned int v1;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 Ui_BFu0i_BFu0c) C1{ Fi Fi:0 Fc:0}



static void Test_Ui_BFu0i_BFu0c()
{
  {
    init_simple_test("Ui_BFu0i_BFu0c");
    static Ui_BFu0i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Ui_BFu0i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu0c(Test_Ui_BFu0i_BFu0c, "Ui_BFu0i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu0i  {
  unsigned int v1;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 Ui_BFu0i_BFu0i) C1{ Fi Fi:0 Fi:0}



static void Test_Ui_BFu0i_BFu0i()
{
  {
    init_simple_test("Ui_BFu0i_BFu0i");
    static Ui_BFu0i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Ui_BFu0i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu0i(Test_Ui_BFu0i_BFu0i, "Ui_BFu0i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu0ll  {
  unsigned int v1;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 Ui_BFu0i_BFu0ll) C1{ Fi Fi:0 FL:0}



static void Test_Ui_BFu0i_BFu0ll()
{
  {
    init_simple_test("Ui_BFu0i_BFu0ll");
    static Ui_BFu0i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Ui_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu0ll(Test_Ui_BFu0i_BFu0ll, "Ui_BFu0i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu0s  {
  unsigned int v1;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 Ui_BFu0i_BFu0s) C1{ Fi Fi:0 Fs:0}



static void Test_Ui_BFu0i_BFu0s()
{
  {
    init_simple_test("Ui_BFu0i_BFu0s");
    static Ui_BFu0i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Ui_BFu0i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu0s(Test_Ui_BFu0i_BFu0s, "Ui_BFu0i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu15i  {
  unsigned int v1;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 Ui_BFu0i_BFu15i) C1{ Fi Fi:0 Fi:15}



static void Test_Ui_BFu0i_BFu15i()
{
  {
    init_simple_test("Ui_BFu0i_BFu15i");
    static Ui_BFu0i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu0i_BFu15i");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu15i(Test_Ui_BFu0i_BFu15i, "Ui_BFu0i_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu15ll  {
  unsigned int v1;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 Ui_BFu0i_BFu15ll) C1{ Fi Fi:0 FL:15}



static void Test_Ui_BFu0i_BFu15ll()
{
  {
    init_simple_test("Ui_BFu0i_BFu15ll");
    static Ui_BFu0i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu0i_BFu15ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu15ll(Test_Ui_BFu0i_BFu15ll, "Ui_BFu0i_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu15s  {
  unsigned int v1;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 Ui_BFu0i_BFu15s) C1{ Fi Fi:0 Fs:15}



static void Test_Ui_BFu0i_BFu15s()
{
  {
    init_simple_test("Ui_BFu0i_BFu15s");
    static Ui_BFu0i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu0i_BFu15s");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu15s(Test_Ui_BFu0i_BFu15s, "Ui_BFu0i_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu16i  {
  unsigned int v1;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 Ui_BFu0i_BFu16i) C1{ Fi Fi:0 Fi:16}



static void Test_Ui_BFu0i_BFu16i()
{
  {
    init_simple_test("Ui_BFu0i_BFu16i");
    static Ui_BFu0i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu0i_BFu16i");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu16i(Test_Ui_BFu0i_BFu16i, "Ui_BFu0i_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu16ll  {
  unsigned int v1;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 Ui_BFu0i_BFu16ll) C1{ Fi Fi:0 FL:16}



static void Test_Ui_BFu0i_BFu16ll()
{
  {
    init_simple_test("Ui_BFu0i_BFu16ll");
    static Ui_BFu0i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu0i_BFu16ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu16ll(Test_Ui_BFu0i_BFu16ll, "Ui_BFu0i_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu16s  {
  unsigned int v1;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 Ui_BFu0i_BFu16s) C1{ Fi Fi:0 Fs:16}



static void Test_Ui_BFu0i_BFu16s()
{
  {
    init_simple_test("Ui_BFu0i_BFu16s");
    static Ui_BFu0i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu0i_BFu16s");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu16s(Test_Ui_BFu0i_BFu16s, "Ui_BFu0i_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu17i  {
  unsigned int v1;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 Ui_BFu0i_BFu17i) C1{ Fi Fi:0 Fi:17}



static void Test_Ui_BFu0i_BFu17i()
{
  {
    init_simple_test("Ui_BFu0i_BFu17i");
    static Ui_BFu0i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu0i_BFu17i");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu17i(Test_Ui_BFu0i_BFu17i, "Ui_BFu0i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu17ll  {
  unsigned int v1;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 Ui_BFu0i_BFu17ll) C1{ Fi Fi:0 FL:17}



static void Test_Ui_BFu0i_BFu17ll()
{
  {
    init_simple_test("Ui_BFu0i_BFu17ll");
    static Ui_BFu0i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu0i_BFu17ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu17ll(Test_Ui_BFu0i_BFu17ll, "Ui_BFu0i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu1c  {
  unsigned int v1;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 Ui_BFu0i_BFu1c) C1{ Fi Fi:0 Fc:1}



static void Test_Ui_BFu0i_BFu1c()
{
  {
    init_simple_test("Ui_BFu0i_BFu1c");
    static Ui_BFu0i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu0i_BFu1c");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu1c(Test_Ui_BFu0i_BFu1c, "Ui_BFu0i_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu1i  {
  unsigned int v1;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 Ui_BFu0i_BFu1i) C1{ Fi Fi:0 Fi:1}



static void Test_Ui_BFu0i_BFu1i()
{
  {
    init_simple_test("Ui_BFu0i_BFu1i");
    static Ui_BFu0i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu0i_BFu1i");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu1i(Test_Ui_BFu0i_BFu1i, "Ui_BFu0i_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu1ll  {
  unsigned int v1;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 Ui_BFu0i_BFu1ll) C1{ Fi Fi:0 FL:1}



static void Test_Ui_BFu0i_BFu1ll()
{
  {
    init_simple_test("Ui_BFu0i_BFu1ll");
    static Ui_BFu0i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu0i_BFu1ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu1ll(Test_Ui_BFu0i_BFu1ll, "Ui_BFu0i_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu1s  {
  unsigned int v1;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 Ui_BFu0i_BFu1s) C1{ Fi Fi:0 Fs:1}



static void Test_Ui_BFu0i_BFu1s()
{
  {
    init_simple_test("Ui_BFu0i_BFu1s");
    static Ui_BFu0i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu0i_BFu1s");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu1s(Test_Ui_BFu0i_BFu1s, "Ui_BFu0i_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu31i  {
  unsigned int v1;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 Ui_BFu0i_BFu31i) C1{ Fi Fi:0 Fi:31}



static void Test_Ui_BFu0i_BFu31i()
{
  {
    init_simple_test("Ui_BFu0i_BFu31i");
    static Ui_BFu0i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu0i_BFu31i");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu31i(Test_Ui_BFu0i_BFu31i, "Ui_BFu0i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu31ll  {
  unsigned int v1;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 Ui_BFu0i_BFu31ll) C1{ Fi Fi:0 FL:31}



static void Test_Ui_BFu0i_BFu31ll()
{
  {
    init_simple_test("Ui_BFu0i_BFu31ll");
    static Ui_BFu0i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu0i_BFu31ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu31ll(Test_Ui_BFu0i_BFu31ll, "Ui_BFu0i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu32i  {
  unsigned int v1;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 Ui_BFu0i_BFu32i) C1{ Fi Fi:0 Fi:32}



static void Test_Ui_BFu0i_BFu32i()
{
  {
    init_simple_test("Ui_BFu0i_BFu32i");
    static Ui_BFu0i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu0i_BFu32i");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu32i(Test_Ui_BFu0i_BFu32i, "Ui_BFu0i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu32ll  {
  unsigned int v1;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 Ui_BFu0i_BFu32ll) C1{ Fi Fi:0 FL:32}



static void Test_Ui_BFu0i_BFu32ll()
{
  {
    init_simple_test("Ui_BFu0i_BFu32ll");
    static Ui_BFu0i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu0i_BFu32ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu32ll(Test_Ui_BFu0i_BFu32ll, "Ui_BFu0i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu33  {
  unsigned int v1;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 Ui_BFu0i_BFu33) C1{ Fi Fi:0 FL:33}



static void Test_Ui_BFu0i_BFu33()
{
  {
    init_simple_test("Ui_BFu0i_BFu33");
    static Ui_BFu0i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu0i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu0i_BFu33");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu33(Test_Ui_BFu0i_BFu33, "Ui_BFu0i_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu7c  {
  unsigned int v1;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 Ui_BFu0i_BFu7c) C1{ Fi Fi:0 Fc:7}



static void Test_Ui_BFu0i_BFu7c()
{
  {
    init_simple_test("Ui_BFu0i_BFu7c");
    static Ui_BFu0i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu0i_BFu7c");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu7c(Test_Ui_BFu0i_BFu7c, "Ui_BFu0i_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu7i  {
  unsigned int v1;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 Ui_BFu0i_BFu7i) C1{ Fi Fi:0 Fi:7}



static void Test_Ui_BFu0i_BFu7i()
{
  {
    init_simple_test("Ui_BFu0i_BFu7i");
    static Ui_BFu0i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu0i_BFu7i");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu7i(Test_Ui_BFu0i_BFu7i, "Ui_BFu0i_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu7ll  {
  unsigned int v1;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 Ui_BFu0i_BFu7ll) C1{ Fi Fi:0 FL:7}



static void Test_Ui_BFu0i_BFu7ll()
{
  {
    init_simple_test("Ui_BFu0i_BFu7ll");
    static Ui_BFu0i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu0i_BFu7ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu7ll(Test_Ui_BFu0i_BFu7ll, "Ui_BFu0i_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu7s  {
  unsigned int v1;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 Ui_BFu0i_BFu7s) C1{ Fi Fi:0 Fs:7}



static void Test_Ui_BFu0i_BFu7s()
{
  {
    init_simple_test("Ui_BFu0i_BFu7s");
    static Ui_BFu0i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu0i_BFu7s");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu7s(Test_Ui_BFu0i_BFu7s, "Ui_BFu0i_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu8c  {
  unsigned int v1;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 Ui_BFu0i_BFu8c) C1{ Fi Fi:0 Fc:8}



static void Test_Ui_BFu0i_BFu8c()
{
  {
    init_simple_test("Ui_BFu0i_BFu8c");
    static Ui_BFu0i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu0i_BFu8c");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu8c(Test_Ui_BFu0i_BFu8c, "Ui_BFu0i_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu8i  {
  unsigned int v1;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 Ui_BFu0i_BFu8i) C1{ Fi Fi:0 Fi:8}



static void Test_Ui_BFu0i_BFu8i()
{
  {
    init_simple_test("Ui_BFu0i_BFu8i");
    static Ui_BFu0i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu0i_BFu8i");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu8i(Test_Ui_BFu0i_BFu8i, "Ui_BFu0i_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu8ll  {
  unsigned int v1;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 Ui_BFu0i_BFu8ll) C1{ Fi Fi:0 FL:8}



static void Test_Ui_BFu0i_BFu8ll()
{
  {
    init_simple_test("Ui_BFu0i_BFu8ll");
    static Ui_BFu0i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu0i_BFu8ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu8ll(Test_Ui_BFu0i_BFu8ll, "Ui_BFu0i_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu8s  {
  unsigned int v1;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 Ui_BFu0i_BFu8s) C1{ Fi Fi:0 Fs:8}



static void Test_Ui_BFu0i_BFu8s()
{
  {
    init_simple_test("Ui_BFu0i_BFu8s");
    static Ui_BFu0i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu0i_BFu8s");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu8s(Test_Ui_BFu0i_BFu8s, "Ui_BFu0i_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu9i  {
  unsigned int v1;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 Ui_BFu0i_BFu9i) C1{ Fi Fi:0 Fi:9}



static void Test_Ui_BFu0i_BFu9i()
{
  {
    init_simple_test("Ui_BFu0i_BFu9i");
    static Ui_BFu0i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu0i_BFu9i");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu9i(Test_Ui_BFu0i_BFu9i, "Ui_BFu0i_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu9ll  {
  unsigned int v1;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 Ui_BFu0i_BFu9ll) C1{ Fi Fi:0 FL:9}



static void Test_Ui_BFu0i_BFu9ll()
{
  {
    init_simple_test("Ui_BFu0i_BFu9ll");
    static Ui_BFu0i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu0i_BFu9ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu9ll(Test_Ui_BFu0i_BFu9ll, "Ui_BFu0i_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_BFu9s  {
  unsigned int v1;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 Ui_BFu0i_BFu9s) C1{ Fi Fi:0 Fs:9}



static void Test_Ui_BFu0i_BFu9s()
{
  {
    init_simple_test("Ui_BFu0i_BFu9s");
    static Ui_BFu0i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu0i_BFu9s");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_BFu9s(Test_Ui_BFu0i_BFu9s, "Ui_BFu0i_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_C  {
  unsigned int v1;
  unsigned int  :0;
  char v2;
};
//SIG(1 Ui_BFu0i_C) C1{ Fi Fi:0 Fc}



static void Test_Ui_BFu0i_C()
{
  {
    init_simple_test("Ui_BFu0i_C");
    static Ui_BFu0i_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_C.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0i_C.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_C(Test_Ui_BFu0i_C, "Ui_BFu0i_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_D  {
  unsigned int v1;
  unsigned int  :0;
  double v2;
};
//SIG(1 Ui_BFu0i_D) C1{ Fi Fi:0 FL}



static void Test_Ui_BFu0i_D()
{
  {
    init_simple_test("Ui_BFu0i_D");
    static Ui_BFu0i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0i_D.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_D(Test_Ui_BFu0i_D, "Ui_BFu0i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_F  {
  unsigned int v1;
  unsigned int  :0;
  float v2;
};
//SIG(1 Ui_BFu0i_F) C1{ Fi Fi:0 Fi}



static void Test_Ui_BFu0i_F()
{
  {
    init_simple_test("Ui_BFu0i_F");
    static Ui_BFu0i_F lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_F.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0i_F.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_F(Test_Ui_BFu0i_F, "Ui_BFu0i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_I  {
  unsigned int v1;
  unsigned int  :0;
  int v2;
};
//SIG(1 Ui_BFu0i_I) C1{ Fi Fi:0 Fi}



static void Test_Ui_BFu0i_I()
{
  {
    init_simple_test("Ui_BFu0i_I");
    static Ui_BFu0i_I lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_I.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0i_I.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_I(Test_Ui_BFu0i_I, "Ui_BFu0i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_Ip  {
  unsigned int v1;
  unsigned int  :0;
  int *v2;
};
//SIG(1 Ui_BFu0i_Ip) C1{ Fi Fi:0 Fp}



static void Test_Ui_BFu0i_Ip()
{
  {
    init_simple_test("Ui_BFu0i_Ip");
    static Ui_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0i_Ip.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_Ip(Test_Ui_BFu0i_Ip, "Ui_BFu0i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_L  {
  unsigned int v1;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 Ui_BFu0i_L) C1{ Fi Fi:0 FL}



static void Test_Ui_BFu0i_L()
{
  {
    init_simple_test("Ui_BFu0i_L");
    static Ui_BFu0i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0i_L.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_L(Test_Ui_BFu0i_L, "Ui_BFu0i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_S  {
  unsigned int v1;
  unsigned int  :0;
  short v2;
};
//SIG(1 Ui_BFu0i_S) C1{ Fi Fi:0 Fs}



static void Test_Ui_BFu0i_S()
{
  {
    init_simple_test("Ui_BFu0i_S");
    static Ui_BFu0i_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_S.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0i_S.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_S(Test_Ui_BFu0i_S, "Ui_BFu0i_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_Uc  {
  unsigned int v1;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 Ui_BFu0i_Uc) C1{ Fi Fi:0 Fc}



static void Test_Ui_BFu0i_Uc()
{
  {
    init_simple_test("Ui_BFu0i_Uc");
    static Ui_BFu0i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_Uc.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0i_Uc.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_Uc(Test_Ui_BFu0i_Uc, "Ui_BFu0i_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_Ui  {
  unsigned int v1;
  unsigned int  :0;
  unsigned int v2;
};
//SIG(1 Ui_BFu0i_Ui) C1{ Fi Fi:0 Fi}



static void Test_Ui_BFu0i_Ui()
{
  {
    init_simple_test("Ui_BFu0i_Ui");
    static Ui_BFu0i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_Ui.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0i_Ui.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_Ui(Test_Ui_BFu0i_Ui, "Ui_BFu0i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_Ul  {
  unsigned int v1;
  unsigned int  :0;
  __tsu64 v2;
};
//SIG(1 Ui_BFu0i_Ul) C1{ Fi Fi:0 FL}



static void Test_Ui_BFu0i_Ul()
{
  {
    init_simple_test("Ui_BFu0i_Ul");
    static Ui_BFu0i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0i_Ul.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_Ul(Test_Ui_BFu0i_Ul, "Ui_BFu0i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_Us  {
  unsigned int v1;
  unsigned int  :0;
  unsigned short v2;
};
//SIG(1 Ui_BFu0i_Us) C1{ Fi Fi:0 Fs}



static void Test_Ui_BFu0i_Us()
{
  {
    init_simple_test("Ui_BFu0i_Us");
    static Ui_BFu0i_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0i_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_Us.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0i_Us.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_Us(Test_Ui_BFu0i_Us, "Ui_BFu0i_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0i_Vp  {
  unsigned int v1;
  unsigned int  :0;
  void *v2;
};
//SIG(1 Ui_BFu0i_Vp) C1{ Fi Fi:0 Fp}



static void Test_Ui_BFu0i_Vp()
{
  {
    init_simple_test("Ui_BFu0i_Vp");
    static Ui_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0i_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu0i_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0i_Vp.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0i_Vp(Test_Ui_BFu0i_Vp, "Ui_BFu0i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll  {
  unsigned int v1;
  __tsu64  :0;
};
//SIG(1 Ui_BFu0ll) C1{ Fi FL:0}



static void Test_Ui_BFu0ll()
{
  {
    init_simple_test("Ui_BFu0ll");
    static Ui_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll(Test_Ui_BFu0ll, "Ui_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu0c  {
  unsigned int v1;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 Ui_BFu0ll_BFu0c) C1{ Fi FL:0 Fc:0}



static void Test_Ui_BFu0ll_BFu0c()
{
  {
    init_simple_test("Ui_BFu0ll_BFu0c");
    static Ui_BFu0ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Ui_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu0c(Test_Ui_BFu0ll_BFu0c, "Ui_BFu0ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu0i  {
  unsigned int v1;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 Ui_BFu0ll_BFu0i) C1{ Fi FL:0 Fi:0}



static void Test_Ui_BFu0ll_BFu0i()
{
  {
    init_simple_test("Ui_BFu0ll_BFu0i");
    static Ui_BFu0ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Ui_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu0i(Test_Ui_BFu0ll_BFu0i, "Ui_BFu0ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu0ll  {
  unsigned int v1;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 Ui_BFu0ll_BFu0ll) C1{ Fi FL:0 FL:0}



static void Test_Ui_BFu0ll_BFu0ll()
{
  {
    init_simple_test("Ui_BFu0ll_BFu0ll");
    static Ui_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Ui_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu0ll(Test_Ui_BFu0ll_BFu0ll, "Ui_BFu0ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu0s  {
  unsigned int v1;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 Ui_BFu0ll_BFu0s) C1{ Fi FL:0 Fs:0}



static void Test_Ui_BFu0ll_BFu0s()
{
  {
    init_simple_test("Ui_BFu0ll_BFu0s");
    static Ui_BFu0ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Ui_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu0s(Test_Ui_BFu0ll_BFu0s, "Ui_BFu0ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu15i  {
  unsigned int v1;
  __tsu64  :0;
  unsigned int v2:15;
};
//SIG(1 Ui_BFu0ll_BFu15i) C1{ Fi FL:0 Fi:15}



static void Test_Ui_BFu0ll_BFu15i()
{
  {
    init_simple_test("Ui_BFu0ll_BFu15i");
    static Ui_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Ui_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Ui_BFu0ll_BFu15i");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu15i(Test_Ui_BFu0ll_BFu15i, "Ui_BFu0ll_BFu15i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu15ll  {
  unsigned int v1;
  __tsu64  :0;
  __tsu64 v2:15;
};
//SIG(1 Ui_BFu0ll_BFu15ll) C1{ Fi FL:0 FL:15}



static void Test_Ui_BFu0ll_BFu15ll()
{
  {
    init_simple_test("Ui_BFu0ll_BFu15ll");
    static Ui_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Ui_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Ui_BFu0ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu15ll(Test_Ui_BFu0ll_BFu15ll, "Ui_BFu0ll_BFu15ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu15s  {
  unsigned int v1;
  __tsu64  :0;
  unsigned short v2:15;
};
//SIG(1 Ui_BFu0ll_BFu15s) C1{ Fi FL:0 Fs:15}



static void Test_Ui_BFu0ll_BFu15s()
{
  {
    init_simple_test("Ui_BFu0ll_BFu15s");
    static Ui_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "Ui_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "Ui_BFu0ll_BFu15s");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu15s(Test_Ui_BFu0ll_BFu15s, "Ui_BFu0ll_BFu15s", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu16i  {
  unsigned int v1;
  __tsu64  :0;
  unsigned int v2:16;
};
//SIG(1 Ui_BFu0ll_BFu16i) C1{ Fi FL:0 Fi:16}



static void Test_Ui_BFu0ll_BFu16i()
{
  {
    init_simple_test("Ui_BFu0ll_BFu16i");
    static Ui_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ui_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ui_BFu0ll_BFu16i");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu16i(Test_Ui_BFu0ll_BFu16i, "Ui_BFu0ll_BFu16i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu16ll  {
  unsigned int v1;
  __tsu64  :0;
  __tsu64 v2:16;
};
//SIG(1 Ui_BFu0ll_BFu16ll) C1{ Fi FL:0 FL:16}



static void Test_Ui_BFu0ll_BFu16ll()
{
  {
    init_simple_test("Ui_BFu0ll_BFu16ll");
    static Ui_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ui_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ui_BFu0ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu16ll(Test_Ui_BFu0ll_BFu16ll, "Ui_BFu0ll_BFu16ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu16s  {
  unsigned int v1;
  __tsu64  :0;
  unsigned short v2:16;
};
//SIG(1 Ui_BFu0ll_BFu16s) C1{ Fi FL:0 Fs:16}



static void Test_Ui_BFu0ll_BFu16s()
{
  {
    init_simple_test("Ui_BFu0ll_BFu16s");
    static Ui_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "Ui_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "Ui_BFu0ll_BFu16s");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu16s(Test_Ui_BFu0ll_BFu16s, "Ui_BFu0ll_BFu16s", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu17i  {
  unsigned int v1;
  __tsu64  :0;
  unsigned int v2:17;
};
//SIG(1 Ui_BFu0ll_BFu17i) C1{ Fi FL:0 Fi:17}



static void Test_Ui_BFu0ll_BFu17i()
{
  {
    init_simple_test("Ui_BFu0ll_BFu17i");
    static Ui_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ui_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ui_BFu0ll_BFu17i");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu17i(Test_Ui_BFu0ll_BFu17i, "Ui_BFu0ll_BFu17i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu17ll  {
  unsigned int v1;
  __tsu64  :0;
  __tsu64 v2:17;
};
//SIG(1 Ui_BFu0ll_BFu17ll) C1{ Fi FL:0 FL:17}



static void Test_Ui_BFu0ll_BFu17ll()
{
  {
    init_simple_test("Ui_BFu0ll_BFu17ll");
    static Ui_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "Ui_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "Ui_BFu0ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu17ll(Test_Ui_BFu0ll_BFu17ll, "Ui_BFu0ll_BFu17ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu1c  {
  unsigned int v1;
  __tsu64  :0;
  unsigned char v2:1;
};
//SIG(1 Ui_BFu0ll_BFu1c) C1{ Fi FL:0 Fc:1}



static void Test_Ui_BFu0ll_BFu1c()
{
  {
    init_simple_test("Ui_BFu0ll_BFu1c");
    static Ui_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ui_BFu0ll_BFu1c");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu1c(Test_Ui_BFu0ll_BFu1c, "Ui_BFu0ll_BFu1c", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu1i  {
  unsigned int v1;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 Ui_BFu0ll_BFu1i) C1{ Fi FL:0 Fi:1}



static void Test_Ui_BFu0ll_BFu1i()
{
  {
    init_simple_test("Ui_BFu0ll_BFu1i");
    static Ui_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ui_BFu0ll_BFu1i");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu1i(Test_Ui_BFu0ll_BFu1i, "Ui_BFu0ll_BFu1i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu1ll  {
  unsigned int v1;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 Ui_BFu0ll_BFu1ll) C1{ Fi FL:0 FL:1}



static void Test_Ui_BFu0ll_BFu1ll()
{
  {
    init_simple_test("Ui_BFu0ll_BFu1ll");
    static Ui_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ui_BFu0ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu1ll(Test_Ui_BFu0ll_BFu1ll, "Ui_BFu0ll_BFu1ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu1s  {
  unsigned int v1;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 Ui_BFu0ll_BFu1s) C1{ Fi FL:0 Fs:1}



static void Test_Ui_BFu0ll_BFu1s()
{
  {
    init_simple_test("Ui_BFu0ll_BFu1s");
    static Ui_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "Ui_BFu0ll_BFu1s");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu1s(Test_Ui_BFu0ll_BFu1s, "Ui_BFu0ll_BFu1s", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu31i  {
  unsigned int v1;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 Ui_BFu0ll_BFu31i) C1{ Fi FL:0 Fi:31}



static void Test_Ui_BFu0ll_BFu31i()
{
  {
    init_simple_test("Ui_BFu0ll_BFu31i");
    static Ui_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ui_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ui_BFu0ll_BFu31i");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu31i(Test_Ui_BFu0ll_BFu31i, "Ui_BFu0ll_BFu31i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu31ll  {
  unsigned int v1;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 Ui_BFu0ll_BFu31ll) C1{ Fi FL:0 FL:31}



static void Test_Ui_BFu0ll_BFu31ll()
{
  {
    init_simple_test("Ui_BFu0ll_BFu31ll");
    static Ui_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "Ui_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "Ui_BFu0ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu31ll(Test_Ui_BFu0ll_BFu31ll, "Ui_BFu0ll_BFu31ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu32i  {
  unsigned int v1;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 Ui_BFu0ll_BFu32i) C1{ Fi FL:0 Fi:32}



static void Test_Ui_BFu0ll_BFu32i()
{
  {
    init_simple_test("Ui_BFu0ll_BFu32i");
    static Ui_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ui_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ui_BFu0ll_BFu32i");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu32i(Test_Ui_BFu0ll_BFu32i, "Ui_BFu0ll_BFu32i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu32ll  {
  unsigned int v1;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 Ui_BFu0ll_BFu32ll) C1{ Fi FL:0 FL:32}



static void Test_Ui_BFu0ll_BFu32ll()
{
  {
    init_simple_test("Ui_BFu0ll_BFu32ll");
    static Ui_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "Ui_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "Ui_BFu0ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu32ll(Test_Ui_BFu0ll_BFu32ll, "Ui_BFu0ll_BFu32ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu33  {
  unsigned int v1;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 Ui_BFu0ll_BFu33) C1{ Fi FL:0 FL:33}



static void Test_Ui_BFu0ll_BFu33()
{
  {
    init_simple_test("Ui_BFu0ll_BFu33");
    static Ui_BFu0ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu0ll_BFu33");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu33(Test_Ui_BFu0ll_BFu33, "Ui_BFu0ll_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu7c  {
  unsigned int v1;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 Ui_BFu0ll_BFu7c) C1{ Fi FL:0 Fc:7}



static void Test_Ui_BFu0ll_BFu7c()
{
  {
    init_simple_test("Ui_BFu0ll_BFu7c");
    static Ui_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ui_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ui_BFu0ll_BFu7c");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu7c(Test_Ui_BFu0ll_BFu7c, "Ui_BFu0ll_BFu7c", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu7i  {
  unsigned int v1;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 Ui_BFu0ll_BFu7i) C1{ Fi FL:0 Fi:7}



static void Test_Ui_BFu0ll_BFu7i()
{
  {
    init_simple_test("Ui_BFu0ll_BFu7i");
    static Ui_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ui_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ui_BFu0ll_BFu7i");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu7i(Test_Ui_BFu0ll_BFu7i, "Ui_BFu0ll_BFu7i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu7ll  {
  unsigned int v1;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 Ui_BFu0ll_BFu7ll) C1{ Fi FL:0 FL:7}



static void Test_Ui_BFu0ll_BFu7ll()
{
  {
    init_simple_test("Ui_BFu0ll_BFu7ll");
    static Ui_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ui_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ui_BFu0ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu7ll(Test_Ui_BFu0ll_BFu7ll, "Ui_BFu0ll_BFu7ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu7s  {
  unsigned int v1;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 Ui_BFu0ll_BFu7s) C1{ Fi FL:0 Fs:7}



static void Test_Ui_BFu0ll_BFu7s()
{
  {
    init_simple_test("Ui_BFu0ll_BFu7s");
    static Ui_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "Ui_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "Ui_BFu0ll_BFu7s");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu7s(Test_Ui_BFu0ll_BFu7s, "Ui_BFu0ll_BFu7s", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu8c  {
  unsigned int v1;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 Ui_BFu0ll_BFu8c) C1{ Fi FL:0 Fc:8}



static void Test_Ui_BFu0ll_BFu8c()
{
  {
    init_simple_test("Ui_BFu0ll_BFu8c");
    static Ui_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ui_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ui_BFu0ll_BFu8c");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu8c(Test_Ui_BFu0ll_BFu8c, "Ui_BFu0ll_BFu8c", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu8i  {
  unsigned int v1;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 Ui_BFu0ll_BFu8i) C1{ Fi FL:0 Fi:8}



static void Test_Ui_BFu0ll_BFu8i()
{
  {
    init_simple_test("Ui_BFu0ll_BFu8i");
    static Ui_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ui_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ui_BFu0ll_BFu8i");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu8i(Test_Ui_BFu0ll_BFu8i, "Ui_BFu0ll_BFu8i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu8ll  {
  unsigned int v1;
  __tsu64  :0;
  __tsu64 v2:8;
};
//SIG(1 Ui_BFu0ll_BFu8ll) C1{ Fi FL:0 FL:8}



static void Test_Ui_BFu0ll_BFu8ll()
{
  {
    init_simple_test("Ui_BFu0ll_BFu8ll");
    static Ui_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ui_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ui_BFu0ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu8ll(Test_Ui_BFu0ll_BFu8ll, "Ui_BFu0ll_BFu8ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu8s  {
  unsigned int v1;
  __tsu64  :0;
  unsigned short v2:8;
};
//SIG(1 Ui_BFu0ll_BFu8s) C1{ Fi FL:0 Fs:8}



static void Test_Ui_BFu0ll_BFu8s()
{
  {
    init_simple_test("Ui_BFu0ll_BFu8s");
    static Ui_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "Ui_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "Ui_BFu0ll_BFu8s");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu8s(Test_Ui_BFu0ll_BFu8s, "Ui_BFu0ll_BFu8s", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu9i  {
  unsigned int v1;
  __tsu64  :0;
  unsigned int v2:9;
};
//SIG(1 Ui_BFu0ll_BFu9i) C1{ Fi FL:0 Fi:9}



static void Test_Ui_BFu0ll_BFu9i()
{
  {
    init_simple_test("Ui_BFu0ll_BFu9i");
    static Ui_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ui_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ui_BFu0ll_BFu9i");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu9i(Test_Ui_BFu0ll_BFu9i, "Ui_BFu0ll_BFu9i", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu9ll  {
  unsigned int v1;
  __tsu64  :0;
  __tsu64 v2:9;
};
//SIG(1 Ui_BFu0ll_BFu9ll) C1{ Fi FL:0 FL:9}



static void Test_Ui_BFu0ll_BFu9ll()
{
  {
    init_simple_test("Ui_BFu0ll_BFu9ll");
    static Ui_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ui_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ui_BFu0ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu9ll(Test_Ui_BFu0ll_BFu9ll, "Ui_BFu0ll_BFu9ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_BFu9s  {
  unsigned int v1;
  __tsu64  :0;
  unsigned short v2:9;
};
//SIG(1 Ui_BFu0ll_BFu9s) C1{ Fi FL:0 Fs:9}



static void Test_Ui_BFu0ll_BFu9s()
{
  {
    init_simple_test("Ui_BFu0ll_BFu9s");
    static Ui_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "Ui_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "Ui_BFu0ll_BFu9s");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_BFu9s(Test_Ui_BFu0ll_BFu9s, "Ui_BFu0ll_BFu9s", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_C  {
  unsigned int v1;
  __tsu64  :0;
  char v2;
};
//SIG(1 Ui_BFu0ll_C) C1{ Fi FL:0 Fc}



static void Test_Ui_BFu0ll_C()
{
  {
    init_simple_test("Ui_BFu0ll_C");
    static Ui_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0ll_C.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_C(Test_Ui_BFu0ll_C, "Ui_BFu0ll_C", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_D  {
  unsigned int v1;
  __tsu64  :0;
  double v2;
};
//SIG(1 Ui_BFu0ll_D) C1{ Fi FL:0 FL}



static void Test_Ui_BFu0ll_D()
{
  {
    init_simple_test("Ui_BFu0ll_D");
    static Ui_BFu0ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0ll_D.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_D(Test_Ui_BFu0ll_D, "Ui_BFu0ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_F  {
  unsigned int v1;
  __tsu64  :0;
  float v2;
};
//SIG(1 Ui_BFu0ll_F) C1{ Fi FL:0 Fi}



static void Test_Ui_BFu0ll_F()
{
  {
    init_simple_test("Ui_BFu0ll_F");
    static Ui_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0ll_F.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_F(Test_Ui_BFu0ll_F, "Ui_BFu0ll_F", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_I  {
  unsigned int v1;
  __tsu64  :0;
  int v2;
};
//SIG(1 Ui_BFu0ll_I) C1{ Fi FL:0 Fi}



static void Test_Ui_BFu0ll_I()
{
  {
    init_simple_test("Ui_BFu0ll_I");
    static Ui_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0ll_I.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_I(Test_Ui_BFu0ll_I, "Ui_BFu0ll_I", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_Ip  {
  unsigned int v1;
  __tsu64  :0;
  int *v2;
};
//SIG(1 Ui_BFu0ll_Ip) C1{ Fi FL:0 Fp}



static void Test_Ui_BFu0ll_Ip()
{
  {
    init_simple_test("Ui_BFu0ll_Ip");
    static Ui_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_Ip(Test_Ui_BFu0ll_Ip, "Ui_BFu0ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_L  {
  unsigned int v1;
  __tsu64  :0;
  __tsi64 v2;
};
//SIG(1 Ui_BFu0ll_L) C1{ Fi FL:0 FL}



static void Test_Ui_BFu0ll_L()
{
  {
    init_simple_test("Ui_BFu0ll_L");
    static Ui_BFu0ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0ll_L.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_L(Test_Ui_BFu0ll_L, "Ui_BFu0ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_S  {
  unsigned int v1;
  __tsu64  :0;
  short v2;
};
//SIG(1 Ui_BFu0ll_S) C1{ Fi FL:0 Fs}



static void Test_Ui_BFu0ll_S()
{
  {
    init_simple_test("Ui_BFu0ll_S");
    static Ui_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0ll_S.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_S(Test_Ui_BFu0ll_S, "Ui_BFu0ll_S", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_Uc  {
  unsigned int v1;
  __tsu64  :0;
  unsigned char v2;
};
//SIG(1 Ui_BFu0ll_Uc) C1{ Fi FL:0 Fc}



static void Test_Ui_BFu0ll_Uc()
{
  {
    init_simple_test("Ui_BFu0ll_Uc");
    static Ui_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_Uc(Test_Ui_BFu0ll_Uc, "Ui_BFu0ll_Uc", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_Ui  {
  unsigned int v1;
  __tsu64  :0;
  unsigned int v2;
};
//SIG(1 Ui_BFu0ll_Ui) C1{ Fi FL:0 Fi}



static void Test_Ui_BFu0ll_Ui()
{
  {
    init_simple_test("Ui_BFu0ll_Ui");
    static Ui_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_Ui(Test_Ui_BFu0ll_Ui, "Ui_BFu0ll_Ui", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_Ul  {
  unsigned int v1;
  __tsu64  :0;
  __tsu64 v2;
};
//SIG(1 Ui_BFu0ll_Ul) C1{ Fi FL:0 FL}



static void Test_Ui_BFu0ll_Ul()
{
  {
    init_simple_test("Ui_BFu0ll_Ul");
    static Ui_BFu0ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_Ul(Test_Ui_BFu0ll_Ul, "Ui_BFu0ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_Us  {
  unsigned int v1;
  __tsu64  :0;
  unsigned short v2;
};
//SIG(1 Ui_BFu0ll_Us) C1{ Fi FL:0 Fs}



static void Test_Ui_BFu0ll_Us()
{
  {
    init_simple_test("Ui_BFu0ll_Us");
    static Ui_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(Ui_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0ll_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0ll_Us.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_Us(Test_Ui_BFu0ll_Us, "Ui_BFu0ll_Us", ABISELECT(12,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0ll_Vp  {
  unsigned int v1;
  __tsu64  :0;
  void *v2;
};
//SIG(1 Ui_BFu0ll_Vp) C1{ Fi FL:0 Fp}



static void Test_Ui_BFu0ll_Vp()
{
  {
    init_simple_test("Ui_BFu0ll_Vp");
    static Ui_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0ll_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu0ll_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0ll_Vp(Test_Ui_BFu0ll_Vp, "Ui_BFu0ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s  {
  unsigned int v1;
  unsigned short  :0;
};
//SIG(1 Ui_BFu0s) C1{ Fi Fs:0}



static void Test_Ui_BFu0s()
{
  {
    init_simple_test("Ui_BFu0s");
    static Ui_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Ui_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0s(Test_Ui_BFu0s, "Ui_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu0c  {
  unsigned int v1;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 Ui_BFu0s_BFu0c) C1{ Fi Fs:0 Fc:0}



static void Test_Ui_BFu0s_BFu0c()
{
  {
    init_simple_test("Ui_BFu0s_BFu0c");
    static Ui_BFu0s_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(Ui_BFu0s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu0c(Test_Ui_BFu0s_BFu0c, "Ui_BFu0s_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu0i  {
  unsigned int v1;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 Ui_BFu0s_BFu0i) C1{ Fi Fs:0 Fi:0}



static void Test_Ui_BFu0s_BFu0i()
{
  {
    init_simple_test("Ui_BFu0s_BFu0i");
    static Ui_BFu0s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(Ui_BFu0s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu0i(Test_Ui_BFu0s_BFu0i, "Ui_BFu0s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu0ll  {
  unsigned int v1;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 Ui_BFu0s_BFu0ll) C1{ Fi Fs:0 FL:0}



static void Test_Ui_BFu0s_BFu0ll()
{
  {
    init_simple_test("Ui_BFu0s_BFu0ll");
    static Ui_BFu0s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Ui_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu0s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu0ll(Test_Ui_BFu0s_BFu0ll, "Ui_BFu0s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu0s  {
  unsigned int v1;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 Ui_BFu0s_BFu0s) C1{ Fi Fs:0 Fs:0}



static void Test_Ui_BFu0s_BFu0s()
{
  {
    init_simple_test("Ui_BFu0s_BFu0s");
    static Ui_BFu0s_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(Ui_BFu0s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu0s(Test_Ui_BFu0s_BFu0s, "Ui_BFu0s_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu15i  {
  unsigned int v1;
  unsigned short  :0;
  unsigned int v2:15;
};
//SIG(1 Ui_BFu0s_BFu15i) C1{ Fi Fs:0 Fi:15}



static void Test_Ui_BFu0s_BFu15i()
{
  {
    init_simple_test("Ui_BFu0s_BFu15i");
    static Ui_BFu0s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu0s_BFu15i");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu15i(Test_Ui_BFu0s_BFu15i, "Ui_BFu0s_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu15ll  {
  unsigned int v1;
  unsigned short  :0;
  __tsu64 v2:15;
};
//SIG(1 Ui_BFu0s_BFu15ll) C1{ Fi Fs:0 FL:15}



static void Test_Ui_BFu0s_BFu15ll()
{
  {
    init_simple_test("Ui_BFu0s_BFu15ll");
    static Ui_BFu0s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu0s_BFu15ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu15ll(Test_Ui_BFu0s_BFu15ll, "Ui_BFu0s_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu15s  {
  unsigned int v1;
  unsigned short  :0;
  unsigned short v2:15;
};
//SIG(1 Ui_BFu0s_BFu15s) C1{ Fi Fs:0 Fs:15}



static void Test_Ui_BFu0s_BFu15s()
{
  {
    init_simple_test("Ui_BFu0s_BFu15s");
    static Ui_BFu0s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu0s_BFu15s");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu15s(Test_Ui_BFu0s_BFu15s, "Ui_BFu0s_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu16i  {
  unsigned int v1;
  unsigned short  :0;
  unsigned int v2:16;
};
//SIG(1 Ui_BFu0s_BFu16i) C1{ Fi Fs:0 Fi:16}



static void Test_Ui_BFu0s_BFu16i()
{
  {
    init_simple_test("Ui_BFu0s_BFu16i");
    static Ui_BFu0s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu0s_BFu16i");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu16i(Test_Ui_BFu0s_BFu16i, "Ui_BFu0s_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu16ll  {
  unsigned int v1;
  unsigned short  :0;
  __tsu64 v2:16;
};
//SIG(1 Ui_BFu0s_BFu16ll) C1{ Fi Fs:0 FL:16}



static void Test_Ui_BFu0s_BFu16ll()
{
  {
    init_simple_test("Ui_BFu0s_BFu16ll");
    static Ui_BFu0s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu0s_BFu16ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu16ll(Test_Ui_BFu0s_BFu16ll, "Ui_BFu0s_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu16s  {
  unsigned int v1;
  unsigned short  :0;
  unsigned short v2:16;
};
//SIG(1 Ui_BFu0s_BFu16s) C1{ Fi Fs:0 Fs:16}



static void Test_Ui_BFu0s_BFu16s()
{
  {
    init_simple_test("Ui_BFu0s_BFu16s");
    static Ui_BFu0s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu0s_BFu16s");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu16s(Test_Ui_BFu0s_BFu16s, "Ui_BFu0s_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu17i  {
  unsigned int v1;
  unsigned short  :0;
  unsigned int v2:17;
};
//SIG(1 Ui_BFu0s_BFu17i) C1{ Fi Fs:0 Fi:17}



static void Test_Ui_BFu0s_BFu17i()
{
  {
    init_simple_test("Ui_BFu0s_BFu17i");
    static Ui_BFu0s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu0s_BFu17i");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu17i(Test_Ui_BFu0s_BFu17i, "Ui_BFu0s_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu17ll  {
  unsigned int v1;
  unsigned short  :0;
  __tsu64 v2:17;
};
//SIG(1 Ui_BFu0s_BFu17ll) C1{ Fi Fs:0 FL:17}



static void Test_Ui_BFu0s_BFu17ll()
{
  {
    init_simple_test("Ui_BFu0s_BFu17ll");
    static Ui_BFu0s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu0s_BFu17ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu17ll(Test_Ui_BFu0s_BFu17ll, "Ui_BFu0s_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu1c  {
  unsigned int v1;
  unsigned short  :0;
  unsigned char v2:1;
};
//SIG(1 Ui_BFu0s_BFu1c) C1{ Fi Fs:0 Fc:1}



static void Test_Ui_BFu0s_BFu1c()
{
  {
    init_simple_test("Ui_BFu0s_BFu1c");
    static Ui_BFu0s_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu0s_BFu1c");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu1c(Test_Ui_BFu0s_BFu1c, "Ui_BFu0s_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu1i  {
  unsigned int v1;
  unsigned short  :0;
  unsigned int v2:1;
};
//SIG(1 Ui_BFu0s_BFu1i) C1{ Fi Fs:0 Fi:1}



static void Test_Ui_BFu0s_BFu1i()
{
  {
    init_simple_test("Ui_BFu0s_BFu1i");
    static Ui_BFu0s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu0s_BFu1i");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu1i(Test_Ui_BFu0s_BFu1i, "Ui_BFu0s_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu1ll  {
  unsigned int v1;
  unsigned short  :0;
  __tsu64 v2:1;
};
//SIG(1 Ui_BFu0s_BFu1ll) C1{ Fi Fs:0 FL:1}



static void Test_Ui_BFu0s_BFu1ll()
{
  {
    init_simple_test("Ui_BFu0s_BFu1ll");
    static Ui_BFu0s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu0s_BFu1ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu1ll(Test_Ui_BFu0s_BFu1ll, "Ui_BFu0s_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu1s  {
  unsigned int v1;
  unsigned short  :0;
  unsigned short v2:1;
};
//SIG(1 Ui_BFu0s_BFu1s) C1{ Fi Fs:0 Fs:1}



static void Test_Ui_BFu0s_BFu1s()
{
  {
    init_simple_test("Ui_BFu0s_BFu1s");
    static Ui_BFu0s_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu0s_BFu1s");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu1s(Test_Ui_BFu0s_BFu1s, "Ui_BFu0s_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu31i  {
  unsigned int v1;
  unsigned short  :0;
  unsigned int v2:31;
};
//SIG(1 Ui_BFu0s_BFu31i) C1{ Fi Fs:0 Fi:31}



static void Test_Ui_BFu0s_BFu31i()
{
  {
    init_simple_test("Ui_BFu0s_BFu31i");
    static Ui_BFu0s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu0s_BFu31i");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu31i(Test_Ui_BFu0s_BFu31i, "Ui_BFu0s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu31ll  {
  unsigned int v1;
  unsigned short  :0;
  __tsu64 v2:31;
};
//SIG(1 Ui_BFu0s_BFu31ll) C1{ Fi Fs:0 FL:31}



static void Test_Ui_BFu0s_BFu31ll()
{
  {
    init_simple_test("Ui_BFu0s_BFu31ll");
    static Ui_BFu0s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu0s_BFu31ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu31ll(Test_Ui_BFu0s_BFu31ll, "Ui_BFu0s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu32i  {
  unsigned int v1;
  unsigned short  :0;
  unsigned int v2:32;
};
//SIG(1 Ui_BFu0s_BFu32i) C1{ Fi Fs:0 Fi:32}



static void Test_Ui_BFu0s_BFu32i()
{
  {
    init_simple_test("Ui_BFu0s_BFu32i");
    static Ui_BFu0s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu0s_BFu32i");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu32i(Test_Ui_BFu0s_BFu32i, "Ui_BFu0s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu32ll  {
  unsigned int v1;
  unsigned short  :0;
  __tsu64 v2:32;
};
//SIG(1 Ui_BFu0s_BFu32ll) C1{ Fi Fs:0 FL:32}



static void Test_Ui_BFu0s_BFu32ll()
{
  {
    init_simple_test("Ui_BFu0s_BFu32ll");
    static Ui_BFu0s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu0s_BFu32ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu32ll(Test_Ui_BFu0s_BFu32ll, "Ui_BFu0s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu33  {
  unsigned int v1;
  unsigned short  :0;
  __tsu64 v2:33;
};
//SIG(1 Ui_BFu0s_BFu33) C1{ Fi Fs:0 FL:33}



static void Test_Ui_BFu0s_BFu33()
{
  {
    init_simple_test("Ui_BFu0s_BFu33");
    static Ui_BFu0s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_BFu33)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu0s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu0s_BFu33");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu33(Test_Ui_BFu0s_BFu33, "Ui_BFu0s_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu7c  {
  unsigned int v1;
  unsigned short  :0;
  unsigned char v2:7;
};
//SIG(1 Ui_BFu0s_BFu7c) C1{ Fi Fs:0 Fc:7}



static void Test_Ui_BFu0s_BFu7c()
{
  {
    init_simple_test("Ui_BFu0s_BFu7c");
    static Ui_BFu0s_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu0s_BFu7c");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu7c(Test_Ui_BFu0s_BFu7c, "Ui_BFu0s_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu7i  {
  unsigned int v1;
  unsigned short  :0;
  unsigned int v2:7;
};
//SIG(1 Ui_BFu0s_BFu7i) C1{ Fi Fs:0 Fi:7}



static void Test_Ui_BFu0s_BFu7i()
{
  {
    init_simple_test("Ui_BFu0s_BFu7i");
    static Ui_BFu0s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu0s_BFu7i");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu7i(Test_Ui_BFu0s_BFu7i, "Ui_BFu0s_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu7ll  {
  unsigned int v1;
  unsigned short  :0;
  __tsu64 v2:7;
};
//SIG(1 Ui_BFu0s_BFu7ll) C1{ Fi Fs:0 FL:7}



static void Test_Ui_BFu0s_BFu7ll()
{
  {
    init_simple_test("Ui_BFu0s_BFu7ll");
    static Ui_BFu0s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu0s_BFu7ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu7ll(Test_Ui_BFu0s_BFu7ll, "Ui_BFu0s_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu7s  {
  unsigned int v1;
  unsigned short  :0;
  unsigned short v2:7;
};
//SIG(1 Ui_BFu0s_BFu7s) C1{ Fi Fs:0 Fs:7}



static void Test_Ui_BFu0s_BFu7s()
{
  {
    init_simple_test("Ui_BFu0s_BFu7s");
    static Ui_BFu0s_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu0s_BFu7s");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu7s(Test_Ui_BFu0s_BFu7s, "Ui_BFu0s_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu8c  {
  unsigned int v1;
  unsigned short  :0;
  unsigned char v2:8;
};
//SIG(1 Ui_BFu0s_BFu8c) C1{ Fi Fs:0 Fc:8}



static void Test_Ui_BFu0s_BFu8c()
{
  {
    init_simple_test("Ui_BFu0s_BFu8c");
    static Ui_BFu0s_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu0s_BFu8c");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu8c(Test_Ui_BFu0s_BFu8c, "Ui_BFu0s_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu8i  {
  unsigned int v1;
  unsigned short  :0;
  unsigned int v2:8;
};
//SIG(1 Ui_BFu0s_BFu8i) C1{ Fi Fs:0 Fi:8}



static void Test_Ui_BFu0s_BFu8i()
{
  {
    init_simple_test("Ui_BFu0s_BFu8i");
    static Ui_BFu0s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu0s_BFu8i");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu8i(Test_Ui_BFu0s_BFu8i, "Ui_BFu0s_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu8ll  {
  unsigned int v1;
  unsigned short  :0;
  __tsu64 v2:8;
};
//SIG(1 Ui_BFu0s_BFu8ll) C1{ Fi Fs:0 FL:8}



static void Test_Ui_BFu0s_BFu8ll()
{
  {
    init_simple_test("Ui_BFu0s_BFu8ll");
    static Ui_BFu0s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu0s_BFu8ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu8ll(Test_Ui_BFu0s_BFu8ll, "Ui_BFu0s_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu8s  {
  unsigned int v1;
  unsigned short  :0;
  unsigned short v2:8;
};
//SIG(1 Ui_BFu0s_BFu8s) C1{ Fi Fs:0 Fs:8}



static void Test_Ui_BFu0s_BFu8s()
{
  {
    init_simple_test("Ui_BFu0s_BFu8s");
    static Ui_BFu0s_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu0s_BFu8s");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu8s(Test_Ui_BFu0s_BFu8s, "Ui_BFu0s_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu9i  {
  unsigned int v1;
  unsigned short  :0;
  unsigned int v2:9;
};
//SIG(1 Ui_BFu0s_BFu9i) C1{ Fi Fs:0 Fi:9}



static void Test_Ui_BFu0s_BFu9i()
{
  {
    init_simple_test("Ui_BFu0s_BFu9i");
    static Ui_BFu0s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu0s_BFu9i");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu9i(Test_Ui_BFu0s_BFu9i, "Ui_BFu0s_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu9ll  {
  unsigned int v1;
  unsigned short  :0;
  __tsu64 v2:9;
};
//SIG(1 Ui_BFu0s_BFu9ll) C1{ Fi Fs:0 FL:9}



static void Test_Ui_BFu0s_BFu9ll()
{
  {
    init_simple_test("Ui_BFu0s_BFu9ll");
    static Ui_BFu0s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu0s_BFu9ll");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu9ll(Test_Ui_BFu0s_BFu9ll, "Ui_BFu0s_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_BFu9s  {
  unsigned int v1;
  unsigned short  :0;
  unsigned short v2:9;
};
//SIG(1 Ui_BFu0s_BFu9s) C1{ Fi Fs:0 Fs:9}



static void Test_Ui_BFu0s_BFu9s()
{
  {
    init_simple_test("Ui_BFu0s_BFu9s");
    static Ui_BFu0s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu0s_BFu9s");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_BFu9s(Test_Ui_BFu0s_BFu9s, "Ui_BFu0s_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_C  {
  unsigned int v1;
  unsigned short  :0;
  char v2;
};
//SIG(1 Ui_BFu0s_C) C1{ Fi Fs:0 Fc}



static void Test_Ui_BFu0s_C()
{
  {
    init_simple_test("Ui_BFu0s_C");
    static Ui_BFu0s_C lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_C)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_C)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_C.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0s_C.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_C(Test_Ui_BFu0s_C, "Ui_BFu0s_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_D  {
  unsigned int v1;
  unsigned short  :0;
  double v2;
};
//SIG(1 Ui_BFu0s_D) C1{ Fi Fs:0 FL}



static void Test_Ui_BFu0s_D()
{
  {
    init_simple_test("Ui_BFu0s_D");
    static Ui_BFu0s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_D)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0s_D.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_D(Test_Ui_BFu0s_D, "Ui_BFu0s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_F  {
  unsigned int v1;
  unsigned short  :0;
  float v2;
};
//SIG(1 Ui_BFu0s_F) C1{ Fi Fs:0 Fi}



static void Test_Ui_BFu0s_F()
{
  {
    init_simple_test("Ui_BFu0s_F");
    static Ui_BFu0s_F lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_F)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_F)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_F.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0s_F.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_F(Test_Ui_BFu0s_F, "Ui_BFu0s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_I  {
  unsigned int v1;
  unsigned short  :0;
  int v2;
};
//SIG(1 Ui_BFu0s_I) C1{ Fi Fs:0 Fi}



static void Test_Ui_BFu0s_I()
{
  {
    init_simple_test("Ui_BFu0s_I");
    static Ui_BFu0s_I lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_I)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_I)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_I.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0s_I.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_I(Test_Ui_BFu0s_I, "Ui_BFu0s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_Ip  {
  unsigned int v1;
  unsigned short  :0;
  int *v2;
};
//SIG(1 Ui_BFu0s_Ip) C1{ Fi Fs:0 Fp}



static void Test_Ui_BFu0s_Ip()
{
  {
    init_simple_test("Ui_BFu0s_Ip");
    static Ui_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_Ip)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0s_Ip.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_Ip(Test_Ui_BFu0s_Ip, "Ui_BFu0s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_L  {
  unsigned int v1;
  unsigned short  :0;
  __tsi64 v2;
};
//SIG(1 Ui_BFu0s_L) C1{ Fi Fs:0 FL}



static void Test_Ui_BFu0s_L()
{
  {
    init_simple_test("Ui_BFu0s_L");
    static Ui_BFu0s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_L)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0s_L.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_L(Test_Ui_BFu0s_L, "Ui_BFu0s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_S  {
  unsigned int v1;
  unsigned short  :0;
  short v2;
};
//SIG(1 Ui_BFu0s_S) C1{ Fi Fs:0 Fs}



static void Test_Ui_BFu0s_S()
{
  {
    init_simple_test("Ui_BFu0s_S");
    static Ui_BFu0s_S lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_S)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_S)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_S.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0s_S.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_S(Test_Ui_BFu0s_S, "Ui_BFu0s_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_Uc  {
  unsigned int v1;
  unsigned short  :0;
  unsigned char v2;
};
//SIG(1 Ui_BFu0s_Uc) C1{ Fi Fs:0 Fc}



static void Test_Ui_BFu0s_Uc()
{
  {
    init_simple_test("Ui_BFu0s_Uc");
    static Ui_BFu0s_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_Uc)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_Uc.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0s_Uc.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_Uc(Test_Ui_BFu0s_Uc, "Ui_BFu0s_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_Ui  {
  unsigned int v1;
  unsigned short  :0;
  unsigned int v2;
};
//SIG(1 Ui_BFu0s_Ui) C1{ Fi Fs:0 Fi}



static void Test_Ui_BFu0s_Ui()
{
  {
    init_simple_test("Ui_BFu0s_Ui");
    static Ui_BFu0s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_Ui)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_Ui.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0s_Ui.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_Ui(Test_Ui_BFu0s_Ui, "Ui_BFu0s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_Ul  {
  unsigned int v1;
  unsigned short  :0;
  __tsu64 v2;
};
//SIG(1 Ui_BFu0s_Ul) C1{ Fi Fs:0 FL}



static void Test_Ui_BFu0s_Ul()
{
  {
    init_simple_test("Ui_BFu0s_Ul");
    static Ui_BFu0s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_Ul)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0s_Ul.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_Ul(Test_Ui_BFu0s_Ul, "Ui_BFu0s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_Us  {
  unsigned int v1;
  unsigned short  :0;
  unsigned short v2;
};
//SIG(1 Ui_BFu0s_Us) C1{ Fi Fs:0 Fs}



static void Test_Ui_BFu0s_Us()
{
  {
    init_simple_test("Ui_BFu0s_Us");
    static Ui_BFu0s_Us lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu0s_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu0s_Us)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_Us.v1");
    check_field_offset(lv, v2, 4, "Ui_BFu0s_Us.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_Us(Test_Ui_BFu0s_Us, "Ui_BFu0s_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu0s_Vp  {
  unsigned int v1;
  unsigned short  :0;
  void *v2;
};
//SIG(1 Ui_BFu0s_Vp) C1{ Fi Fs:0 Fp}



static void Test_Ui_BFu0s_Vp()
{
  {
    init_simple_test("Ui_BFu0s_Vp");
    static Ui_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu0s_Vp)");
    check_field_offset(lv, v1, 0, "Ui_BFu0s_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_BFu0s_Vp.v2");
  }
}
static Arrange_To_Call_Me vUi_BFu0s_Vp(Test_Ui_BFu0s_Vp, "Ui_BFu0s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu15i_BFu0c  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned char  :0;
};
//SIG(1 Ui_BFu15i_BFu0c) C1{ Fi Fi:15 Fc:0}



static void Test_Ui_BFu15i_BFu0c()
{
  {
    init_simple_test("Ui_BFu15i_BFu0c");
    static Ui_BFu15i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu15i_BFu0c(Test_Ui_BFu15i_BFu0c, "Ui_BFu15i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu15i_BFu0i  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned int  :0;
};
//SIG(1 Ui_BFu15i_BFu0i) C1{ Fi Fi:15 Fi:0}



static void Test_Ui_BFu15i_BFu0i()
{
  {
    init_simple_test("Ui_BFu15i_BFu0i");
    static Ui_BFu15i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu15i_BFu0i(Test_Ui_BFu15i_BFu0i, "Ui_BFu15i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu15i_BFu0ll  {
  unsigned int v1;
  unsigned int v2:15;
  __tsu64  :0;
};
//SIG(1 Ui_BFu15i_BFu0ll) C1{ Fi Fi:15 FL:0}



static void Test_Ui_BFu15i_BFu0ll()
{
  {
    init_simple_test("Ui_BFu15i_BFu0ll");
    static Ui_BFu15i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu15i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu15i_BFu0ll(Test_Ui_BFu15i_BFu0ll, "Ui_BFu15i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu15i_BFu0s  {
  unsigned int v1;
  unsigned int v2:15;
  unsigned short  :0;
};
//SIG(1 Ui_BFu15i_BFu0s) C1{ Fi Fi:15 Fs:0}



static void Test_Ui_BFu15i_BFu0s()
{
  {
    init_simple_test("Ui_BFu15i_BFu0s");
    static Ui_BFu15i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15i_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15i_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu15i_BFu0s(Test_Ui_BFu15i_BFu0s, "Ui_BFu15i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu15ll_BFu0c  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned char  :0;
};
//SIG(1 Ui_BFu15ll_BFu0c) C1{ Fi FL:15 Fc:0}



static void Test_Ui_BFu15ll_BFu0c()
{
  {
    init_simple_test("Ui_BFu15ll_BFu0c");
    static Ui_BFu15ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu15ll_BFu0c(Test_Ui_BFu15ll_BFu0c, "Ui_BFu15ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu15ll_BFu0i  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned int  :0;
};
//SIG(1 Ui_BFu15ll_BFu0i) C1{ Fi FL:15 Fi:0}



static void Test_Ui_BFu15ll_BFu0i()
{
  {
    init_simple_test("Ui_BFu15ll_BFu0i");
    static Ui_BFu15ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu15ll_BFu0i(Test_Ui_BFu15ll_BFu0i, "Ui_BFu15ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu15ll_BFu0ll  {
  unsigned int v1;
  __tsu64 v2:15;
  __tsu64  :0;
};
//SIG(1 Ui_BFu15ll_BFu0ll) C1{ Fi FL:15 FL:0}



static void Test_Ui_BFu15ll_BFu0ll()
{
  {
    init_simple_test("Ui_BFu15ll_BFu0ll");
    static Ui_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu15ll_BFu0ll(Test_Ui_BFu15ll_BFu0ll, "Ui_BFu15ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu15ll_BFu0s  {
  unsigned int v1;
  __tsu64 v2:15;
  unsigned short  :0;
};
//SIG(1 Ui_BFu15ll_BFu0s) C1{ Fi FL:15 Fs:0}



static void Test_Ui_BFu15ll_BFu0s()
{
  {
    init_simple_test("Ui_BFu15ll_BFu0s");
    static Ui_BFu15ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu15ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu15ll_BFu0s(Test_Ui_BFu15ll_BFu0s, "Ui_BFu15ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu15s_BFu0c  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned char  :0;
};
//SIG(1 Ui_BFu15s_BFu0c) C1{ Fi Fs:15 Fc:0}



static void Test_Ui_BFu15s_BFu0c()
{
  {
    init_simple_test("Ui_BFu15s_BFu0c");
    static Ui_BFu15s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu15s_BFu0c(Test_Ui_BFu15s_BFu0c, "Ui_BFu15s_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu15s_BFu0i  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned int  :0;
};
//SIG(1 Ui_BFu15s_BFu0i) C1{ Fi Fs:15 Fi:0}



static void Test_Ui_BFu15s_BFu0i()
{
  {
    init_simple_test("Ui_BFu15s_BFu0i");
    static Ui_BFu15s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu15s_BFu0i(Test_Ui_BFu15s_BFu0i, "Ui_BFu15s_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu15s_BFu0ll  {
  unsigned int v1;
  unsigned short v2:15;
  __tsu64  :0;
};
//SIG(1 Ui_BFu15s_BFu0ll) C1{ Fi Fs:15 FL:0}



static void Test_Ui_BFu15s_BFu0ll()
{
  {
    init_simple_test("Ui_BFu15s_BFu0ll");
    static Ui_BFu15s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu15s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu15s_BFu0ll(Test_Ui_BFu15s_BFu0ll, "Ui_BFu15s_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu15s_BFu0s  {
  unsigned int v1;
  unsigned short v2:15;
  unsigned short  :0;
};
//SIG(1 Ui_BFu15s_BFu0s) C1{ Fi Fs:15 Fs:0}



static void Test_Ui_BFu15s_BFu0s()
{
  {
    init_simple_test("Ui_BFu15s_BFu0s");
    static Ui_BFu15s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu15s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu15s_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu15s_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "Ui_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "Ui_BFu15s_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu15s_BFu0s(Test_Ui_BFu15s_BFu0s, "Ui_BFu15s_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu16i_BFu0c  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned char  :0;
};
//SIG(1 Ui_BFu16i_BFu0c) C1{ Fi Fi:16 Fc:0}



static void Test_Ui_BFu16i_BFu0c()
{
  {
    init_simple_test("Ui_BFu16i_BFu0c");
    static Ui_BFu16i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu16i_BFu0c(Test_Ui_BFu16i_BFu0c, "Ui_BFu16i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu16i_BFu0i  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned int  :0;
};
//SIG(1 Ui_BFu16i_BFu0i) C1{ Fi Fi:16 Fi:0}



static void Test_Ui_BFu16i_BFu0i()
{
  {
    init_simple_test("Ui_BFu16i_BFu0i");
    static Ui_BFu16i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu16i_BFu0i(Test_Ui_BFu16i_BFu0i, "Ui_BFu16i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu16i_BFu0ll  {
  unsigned int v1;
  unsigned int v2:16;
  __tsu64  :0;
};
//SIG(1 Ui_BFu16i_BFu0ll) C1{ Fi Fi:16 FL:0}



static void Test_Ui_BFu16i_BFu0ll()
{
  {
    init_simple_test("Ui_BFu16i_BFu0ll");
    static Ui_BFu16i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu16i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu16i_BFu0ll(Test_Ui_BFu16i_BFu0ll, "Ui_BFu16i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu16i_BFu0s  {
  unsigned int v1;
  unsigned int v2:16;
  unsigned short  :0;
};
//SIG(1 Ui_BFu16i_BFu0s) C1{ Fi Fi:16 Fs:0}



static void Test_Ui_BFu16i_BFu0s()
{
  {
    init_simple_test("Ui_BFu16i_BFu0s");
    static Ui_BFu16i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16i_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16i_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu16i_BFu0s(Test_Ui_BFu16i_BFu0s, "Ui_BFu16i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu16ll_BFu0c  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned char  :0;
};
//SIG(1 Ui_BFu16ll_BFu0c) C1{ Fi FL:16 Fc:0}



static void Test_Ui_BFu16ll_BFu0c()
{
  {
    init_simple_test("Ui_BFu16ll_BFu0c");
    static Ui_BFu16ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu16ll_BFu0c(Test_Ui_BFu16ll_BFu0c, "Ui_BFu16ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu16ll_BFu0i  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned int  :0;
};
//SIG(1 Ui_BFu16ll_BFu0i) C1{ Fi FL:16 Fi:0}



static void Test_Ui_BFu16ll_BFu0i()
{
  {
    init_simple_test("Ui_BFu16ll_BFu0i");
    static Ui_BFu16ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu16ll_BFu0i(Test_Ui_BFu16ll_BFu0i, "Ui_BFu16ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu16ll_BFu0ll  {
  unsigned int v1;
  __tsu64 v2:16;
  __tsu64  :0;
};
//SIG(1 Ui_BFu16ll_BFu0ll) C1{ Fi FL:16 FL:0}



static void Test_Ui_BFu16ll_BFu0ll()
{
  {
    init_simple_test("Ui_BFu16ll_BFu0ll");
    static Ui_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu16ll_BFu0ll(Test_Ui_BFu16ll_BFu0ll, "Ui_BFu16ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu16ll_BFu0s  {
  unsigned int v1;
  __tsu64 v2:16;
  unsigned short  :0;
};
//SIG(1 Ui_BFu16ll_BFu0s) C1{ Fi FL:16 Fs:0}



static void Test_Ui_BFu16ll_BFu0s()
{
  {
    init_simple_test("Ui_BFu16ll_BFu0s");
    static Ui_BFu16ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu16ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu16ll_BFu0s(Test_Ui_BFu16ll_BFu0s, "Ui_BFu16ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu16s_BFu0c  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned char  :0;
};
//SIG(1 Ui_BFu16s_BFu0c) C1{ Fi Fs:16 Fc:0}



static void Test_Ui_BFu16s_BFu0c()
{
  {
    init_simple_test("Ui_BFu16s_BFu0c");
    static Ui_BFu16s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu16s_BFu0c(Test_Ui_BFu16s_BFu0c, "Ui_BFu16s_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu16s_BFu0i  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned int  :0;
};
//SIG(1 Ui_BFu16s_BFu0i) C1{ Fi Fs:16 Fi:0}



static void Test_Ui_BFu16s_BFu0i()
{
  {
    init_simple_test("Ui_BFu16s_BFu0i");
    static Ui_BFu16s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu16s_BFu0i(Test_Ui_BFu16s_BFu0i, "Ui_BFu16s_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu16s_BFu0ll  {
  unsigned int v1;
  unsigned short v2:16;
  __tsu64  :0;
};
//SIG(1 Ui_BFu16s_BFu0ll) C1{ Fi Fs:16 FL:0}



static void Test_Ui_BFu16s_BFu0ll()
{
  {
    init_simple_test("Ui_BFu16s_BFu0ll");
    static Ui_BFu16s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu16s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu16s_BFu0ll(Test_Ui_BFu16s_BFu0ll, "Ui_BFu16s_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu16s_BFu0s  {
  unsigned int v1;
  unsigned short v2:16;
  unsigned short  :0;
};
//SIG(1 Ui_BFu16s_BFu0s) C1{ Fi Fs:16 Fs:0}



static void Test_Ui_BFu16s_BFu0s()
{
  {
    init_simple_test("Ui_BFu16s_BFu0s");
    static Ui_BFu16s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu16s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu16s_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu16s_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "Ui_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "Ui_BFu16s_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu16s_BFu0s(Test_Ui_BFu16s_BFu0s, "Ui_BFu16s_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu17i_BFu0c  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned char  :0;
};
//SIG(1 Ui_BFu17i_BFu0c) C1{ Fi Fi:17 Fc:0}



static void Test_Ui_BFu17i_BFu0c()
{
  {
    init_simple_test("Ui_BFu17i_BFu0c");
    static Ui_BFu17i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu17i_BFu0c(Test_Ui_BFu17i_BFu0c, "Ui_BFu17i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu17i_BFu0i  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned int  :0;
};
//SIG(1 Ui_BFu17i_BFu0i) C1{ Fi Fi:17 Fi:0}



static void Test_Ui_BFu17i_BFu0i()
{
  {
    init_simple_test("Ui_BFu17i_BFu0i");
    static Ui_BFu17i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu17i_BFu0i(Test_Ui_BFu17i_BFu0i, "Ui_BFu17i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu17i_BFu0ll  {
  unsigned int v1;
  unsigned int v2:17;
  __tsu64  :0;
};
//SIG(1 Ui_BFu17i_BFu0ll) C1{ Fi Fi:17 FL:0}



static void Test_Ui_BFu17i_BFu0ll()
{
  {
    init_simple_test("Ui_BFu17i_BFu0ll");
    static Ui_BFu17i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu17i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu17i_BFu0ll(Test_Ui_BFu17i_BFu0ll, "Ui_BFu17i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu17i_BFu0s  {
  unsigned int v1;
  unsigned int v2:17;
  unsigned short  :0;
};
//SIG(1 Ui_BFu17i_BFu0s) C1{ Fi Fi:17 Fs:0}



static void Test_Ui_BFu17i_BFu0s()
{
  {
    init_simple_test("Ui_BFu17i_BFu0s");
    static Ui_BFu17i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu17i_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu17i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17i_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu17i_BFu0s(Test_Ui_BFu17i_BFu0s, "Ui_BFu17i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu17ll_BFu0c  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned char  :0;
};
//SIG(1 Ui_BFu17ll_BFu0c) C1{ Fi FL:17 Fc:0}



static void Test_Ui_BFu17ll_BFu0c()
{
  {
    init_simple_test("Ui_BFu17ll_BFu0c");
    static Ui_BFu17ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu17ll_BFu0c(Test_Ui_BFu17ll_BFu0c, "Ui_BFu17ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu17ll_BFu0i  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned int  :0;
};
//SIG(1 Ui_BFu17ll_BFu0i) C1{ Fi FL:17 Fi:0}



static void Test_Ui_BFu17ll_BFu0i()
{
  {
    init_simple_test("Ui_BFu17ll_BFu0i");
    static Ui_BFu17ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu17ll_BFu0i(Test_Ui_BFu17ll_BFu0i, "Ui_BFu17ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu17ll_BFu0ll  {
  unsigned int v1;
  __tsu64 v2:17;
  __tsu64  :0;
};
//SIG(1 Ui_BFu17ll_BFu0ll) C1{ Fi FL:17 FL:0}



static void Test_Ui_BFu17ll_BFu0ll()
{
  {
    init_simple_test("Ui_BFu17ll_BFu0ll");
    static Ui_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu17ll_BFu0ll(Test_Ui_BFu17ll_BFu0ll, "Ui_BFu17ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu17ll_BFu0s  {
  unsigned int v1;
  __tsu64 v2:17;
  unsigned short  :0;
};
//SIG(1 Ui_BFu17ll_BFu0s) C1{ Fi FL:17 Fs:0}



static void Test_Ui_BFu17ll_BFu0s()
{
  {
    init_simple_test("Ui_BFu17ll_BFu0s");
    static Ui_BFu17ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu17ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu17ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Ui_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Ui_BFu17ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu17ll_BFu0s(Test_Ui_BFu17ll_BFu0s, "Ui_BFu17ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1c_BFu0c  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned char  :0;
};
//SIG(1 Ui_BFu1c_BFu0c) C1{ Fi Fc:1 Fc:0}



static void Test_Ui_BFu1c_BFu0c()
{
  {
    init_simple_test("Ui_BFu1c_BFu0c");
    static Ui_BFu1c_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu1c_BFu0c(Test_Ui_BFu1c_BFu0c, "Ui_BFu1c_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1c_BFu0i  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned int  :0;
};
//SIG(1 Ui_BFu1c_BFu0i) C1{ Fi Fc:1 Fi:0}



static void Test_Ui_BFu1c_BFu0i()
{
  {
    init_simple_test("Ui_BFu1c_BFu0i");
    static Ui_BFu1c_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu1c_BFu0i(Test_Ui_BFu1c_BFu0i, "Ui_BFu1c_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1c_BFu0ll  {
  unsigned int v1;
  unsigned char v2:1;
  __tsu64  :0;
};
//SIG(1 Ui_BFu1c_BFu0ll) C1{ Fi Fc:1 FL:0}



static void Test_Ui_BFu1c_BFu0ll()
{
  {
    init_simple_test("Ui_BFu1c_BFu0ll");
    static Ui_BFu1c_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu1c_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu1c_BFu0ll(Test_Ui_BFu1c_BFu0ll, "Ui_BFu1c_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1c_BFu0s  {
  unsigned int v1;
  unsigned char v2:1;
  unsigned short  :0;
};
//SIG(1 Ui_BFu1c_BFu0s) C1{ Fi Fc:1 Fs:0}



static void Test_Ui_BFu1c_BFu0s()
{
  {
    init_simple_test("Ui_BFu1c_BFu0s");
    static Ui_BFu1c_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1c_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1c_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1c_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu1c_BFu0s(Test_Ui_BFu1c_BFu0s, "Ui_BFu1c_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1i_BFu0c  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned char  :0;
};
//SIG(1 Ui_BFu1i_BFu0c) C1{ Fi Fi:1 Fc:0}



static void Test_Ui_BFu1i_BFu0c()
{
  {
    init_simple_test("Ui_BFu1i_BFu0c");
    static Ui_BFu1i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu1i_BFu0c(Test_Ui_BFu1i_BFu0c, "Ui_BFu1i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1i_BFu0i  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned int  :0;
};
//SIG(1 Ui_BFu1i_BFu0i) C1{ Fi Fi:1 Fi:0}



static void Test_Ui_BFu1i_BFu0i()
{
  {
    init_simple_test("Ui_BFu1i_BFu0i");
    static Ui_BFu1i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu1i_BFu0i(Test_Ui_BFu1i_BFu0i, "Ui_BFu1i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1i_BFu0ll  {
  unsigned int v1;
  unsigned int v2:1;
  __tsu64  :0;
};
//SIG(1 Ui_BFu1i_BFu0ll) C1{ Fi Fi:1 FL:0}



static void Test_Ui_BFu1i_BFu0ll()
{
  {
    init_simple_test("Ui_BFu1i_BFu0ll");
    static Ui_BFu1i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu1i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu1i_BFu0ll(Test_Ui_BFu1i_BFu0ll, "Ui_BFu1i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1i_BFu0s  {
  unsigned int v1;
  unsigned int v2:1;
  unsigned short  :0;
};
//SIG(1 Ui_BFu1i_BFu0s) C1{ Fi Fi:1 Fs:0}



static void Test_Ui_BFu1i_BFu0s()
{
  {
    init_simple_test("Ui_BFu1i_BFu0s");
    static Ui_BFu1i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1i_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1i_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu1i_BFu0s(Test_Ui_BFu1i_BFu0s, "Ui_BFu1i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1ll_BFu0c  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned char  :0;
};
//SIG(1 Ui_BFu1ll_BFu0c) C1{ Fi FL:1 Fc:0}



static void Test_Ui_BFu1ll_BFu0c()
{
  {
    init_simple_test("Ui_BFu1ll_BFu0c");
    static Ui_BFu1ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu1ll_BFu0c(Test_Ui_BFu1ll_BFu0c, "Ui_BFu1ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1ll_BFu0i  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned int  :0;
};
//SIG(1 Ui_BFu1ll_BFu0i) C1{ Fi FL:1 Fi:0}



static void Test_Ui_BFu1ll_BFu0i()
{
  {
    init_simple_test("Ui_BFu1ll_BFu0i");
    static Ui_BFu1ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu1ll_BFu0i(Test_Ui_BFu1ll_BFu0i, "Ui_BFu1ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1ll_BFu0ll  {
  unsigned int v1;
  __tsu64 v2:1;
  __tsu64  :0;
};
//SIG(1 Ui_BFu1ll_BFu0ll) C1{ Fi FL:1 FL:0}



static void Test_Ui_BFu1ll_BFu0ll()
{
  {
    init_simple_test("Ui_BFu1ll_BFu0ll");
    static Ui_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu1ll_BFu0ll(Test_Ui_BFu1ll_BFu0ll, "Ui_BFu1ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1ll_BFu0s  {
  unsigned int v1;
  __tsu64 v2:1;
  unsigned short  :0;
};
//SIG(1 Ui_BFu1ll_BFu0s) C1{ Fi FL:1 Fs:0}



static void Test_Ui_BFu1ll_BFu0s()
{
  {
    init_simple_test("Ui_BFu1ll_BFu0s");
    static Ui_BFu1ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu1ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu1ll_BFu0s(Test_Ui_BFu1ll_BFu0s, "Ui_BFu1ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1s_BFu0c  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned char  :0;
};
//SIG(1 Ui_BFu1s_BFu0c) C1{ Fi Fs:1 Fc:0}



static void Test_Ui_BFu1s_BFu0c()
{
  {
    init_simple_test("Ui_BFu1s_BFu0c");
    static Ui_BFu1s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu1s_BFu0c(Test_Ui_BFu1s_BFu0c, "Ui_BFu1s_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1s_BFu0i  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned int  :0;
};
//SIG(1 Ui_BFu1s_BFu0i) C1{ Fi Fs:1 Fi:0}



static void Test_Ui_BFu1s_BFu0i()
{
  {
    init_simple_test("Ui_BFu1s_BFu0i");
    static Ui_BFu1s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu1s_BFu0i(Test_Ui_BFu1s_BFu0i, "Ui_BFu1s_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1s_BFu0ll  {
  unsigned int v1;
  unsigned short v2:1;
  __tsu64  :0;
};
//SIG(1 Ui_BFu1s_BFu0ll) C1{ Fi Fs:1 FL:0}



static void Test_Ui_BFu1s_BFu0ll()
{
  {
    init_simple_test("Ui_BFu1s_BFu0ll");
    static Ui_BFu1s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu1s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu1s_BFu0ll(Test_Ui_BFu1s_BFu0ll, "Ui_BFu1s_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu1s_BFu0s  {
  unsigned int v1;
  unsigned short v2:1;
  unsigned short  :0;
};
//SIG(1 Ui_BFu1s_BFu0s) C1{ Fi Fs:1 Fs:0}



static void Test_Ui_BFu1s_BFu0s()
{
  {
    init_simple_test("Ui_BFu1s_BFu0s");
    static Ui_BFu1s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu1s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu1s_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu1s_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "Ui_BFu1s_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu1s_BFu0s(Test_Ui_BFu1s_BFu0s, "Ui_BFu1s_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu31i_BFu0c  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned char  :0;
};
//SIG(1 Ui_BFu31i_BFu0c) C1{ Fi Fi:31 Fc:0}



static void Test_Ui_BFu31i_BFu0c()
{
  {
    init_simple_test("Ui_BFu31i_BFu0c");
    static Ui_BFu31i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu31i_BFu0c(Test_Ui_BFu31i_BFu0c, "Ui_BFu31i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu31i_BFu0i  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned int  :0;
};
//SIG(1 Ui_BFu31i_BFu0i) C1{ Fi Fi:31 Fi:0}



static void Test_Ui_BFu31i_BFu0i()
{
  {
    init_simple_test("Ui_BFu31i_BFu0i");
    static Ui_BFu31i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu31i_BFu0i(Test_Ui_BFu31i_BFu0i, "Ui_BFu31i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu31i_BFu0ll  {
  unsigned int v1;
  unsigned int v2:31;
  __tsu64  :0;
};
//SIG(1 Ui_BFu31i_BFu0ll) C1{ Fi Fi:31 FL:0}



static void Test_Ui_BFu31i_BFu0ll()
{
  {
    init_simple_test("Ui_BFu31i_BFu0ll");
    static Ui_BFu31i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu31i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu31i_BFu0ll(Test_Ui_BFu31i_BFu0ll, "Ui_BFu31i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu31i_BFu0s  {
  unsigned int v1;
  unsigned int v2:31;
  unsigned short  :0;
};
//SIG(1 Ui_BFu31i_BFu0s) C1{ Fi Fi:31 Fs:0}



static void Test_Ui_BFu31i_BFu0s()
{
  {
    init_simple_test("Ui_BFu31i_BFu0s");
    static Ui_BFu31i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu31i_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu31i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31i_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu31i_BFu0s(Test_Ui_BFu31i_BFu0s, "Ui_BFu31i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu31ll_BFu0c  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned char  :0;
};
//SIG(1 Ui_BFu31ll_BFu0c) C1{ Fi FL:31 Fc:0}



static void Test_Ui_BFu31ll_BFu0c()
{
  {
    init_simple_test("Ui_BFu31ll_BFu0c");
    static Ui_BFu31ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu31ll_BFu0c(Test_Ui_BFu31ll_BFu0c, "Ui_BFu31ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu31ll_BFu0i  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned int  :0;
};
//SIG(1 Ui_BFu31ll_BFu0i) C1{ Fi FL:31 Fi:0}



static void Test_Ui_BFu31ll_BFu0i()
{
  {
    init_simple_test("Ui_BFu31ll_BFu0i");
    static Ui_BFu31ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu31ll_BFu0i(Test_Ui_BFu31ll_BFu0i, "Ui_BFu31ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu31ll_BFu0ll  {
  unsigned int v1;
  __tsu64 v2:31;
  __tsu64  :0;
};
//SIG(1 Ui_BFu31ll_BFu0ll) C1{ Fi FL:31 FL:0}



static void Test_Ui_BFu31ll_BFu0ll()
{
  {
    init_simple_test("Ui_BFu31ll_BFu0ll");
    static Ui_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu31ll_BFu0ll(Test_Ui_BFu31ll_BFu0ll, "Ui_BFu31ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu31ll_BFu0s  {
  unsigned int v1;
  __tsu64 v2:31;
  unsigned short  :0;
};
//SIG(1 Ui_BFu31ll_BFu0s) C1{ Fi FL:31 Fs:0}



static void Test_Ui_BFu31ll_BFu0s()
{
  {
    init_simple_test("Ui_BFu31ll_BFu0s");
    static Ui_BFu31ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu31ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu31ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Ui_BFu31ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Ui_BFu31ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu31ll_BFu0s(Test_Ui_BFu31ll_BFu0s, "Ui_BFu31ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu32i_BFu0c  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned char  :0;
};
//SIG(1 Ui_BFu32i_BFu0c) C1{ Fi Fi:32 Fc:0}



static void Test_Ui_BFu32i_BFu0c()
{
  {
    init_simple_test("Ui_BFu32i_BFu0c");
    static Ui_BFu32i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu32i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu32i_BFu0c(Test_Ui_BFu32i_BFu0c, "Ui_BFu32i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu32i_BFu0i  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned int  :0;
};
//SIG(1 Ui_BFu32i_BFu0i) C1{ Fi Fi:32 Fi:0}



static void Test_Ui_BFu32i_BFu0i()
{
  {
    init_simple_test("Ui_BFu32i_BFu0i");
    static Ui_BFu32i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu32i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu32i_BFu0i(Test_Ui_BFu32i_BFu0i, "Ui_BFu32i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu32i_BFu0ll  {
  unsigned int v1;
  unsigned int v2:32;
  __tsu64  :0;
};
//SIG(1 Ui_BFu32i_BFu0ll) C1{ Fi Fi:32 FL:0}



static void Test_Ui_BFu32i_BFu0ll()
{
  {
    init_simple_test("Ui_BFu32i_BFu0ll");
    static Ui_BFu32i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu32i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu32i_BFu0ll(Test_Ui_BFu32i_BFu0ll, "Ui_BFu32i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu32i_BFu0s  {
  unsigned int v1;
  unsigned int v2:32;
  unsigned short  :0;
};
//SIG(1 Ui_BFu32i_BFu0s) C1{ Fi Fi:32 Fs:0}



static void Test_Ui_BFu32i_BFu0s()
{
  {
    init_simple_test("Ui_BFu32i_BFu0s");
    static Ui_BFu32i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu32i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu32i_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu32i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32i_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu32i_BFu0s(Test_Ui_BFu32i_BFu0s, "Ui_BFu32i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu32ll_BFu0c  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned char  :0;
};
//SIG(1 Ui_BFu32ll_BFu0c) C1{ Fi FL:32 Fc:0}



static void Test_Ui_BFu32ll_BFu0c()
{
  {
    init_simple_test("Ui_BFu32ll_BFu0c");
    static Ui_BFu32ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu32ll_BFu0c(Test_Ui_BFu32ll_BFu0c, "Ui_BFu32ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu32ll_BFu0i  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned int  :0;
};
//SIG(1 Ui_BFu32ll_BFu0i) C1{ Fi FL:32 Fi:0}



static void Test_Ui_BFu32ll_BFu0i()
{
  {
    init_simple_test("Ui_BFu32ll_BFu0i");
    static Ui_BFu32ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu32ll_BFu0i(Test_Ui_BFu32ll_BFu0i, "Ui_BFu32ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu32ll_BFu0ll  {
  unsigned int v1;
  __tsu64 v2:32;
  __tsu64  :0;
};
//SIG(1 Ui_BFu32ll_BFu0ll) C1{ Fi FL:32 FL:0}



static void Test_Ui_BFu32ll_BFu0ll()
{
  {
    init_simple_test("Ui_BFu32ll_BFu0ll");
    static Ui_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu32ll_BFu0ll(Test_Ui_BFu32ll_BFu0ll, "Ui_BFu32ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu32ll_BFu0s  {
  unsigned int v1;
  __tsu64 v2:32;
  unsigned short  :0;
};
//SIG(1 Ui_BFu32ll_BFu0s) C1{ Fi FL:32 Fs:0}



static void Test_Ui_BFu32ll_BFu0s()
{
  {
    init_simple_test("Ui_BFu32ll_BFu0s");
    static Ui_BFu32ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu32ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu32ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Ui_BFu32ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Ui_BFu32ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu32ll_BFu0s(Test_Ui_BFu32ll_BFu0s, "Ui_BFu32ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu33_BFu0c  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned char  :0;
};
//SIG(1 Ui_BFu33_BFu0c) C1{ Fi FL:33 Fc:0}



static void Test_Ui_BFu33_BFu0c()
{
  {
    init_simple_test("Ui_BFu33_BFu0c");
    static Ui_BFu33_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu0c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu0c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu33_BFu0c(Test_Ui_BFu33_BFu0c, "Ui_BFu33_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu33_BFu0i  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned int  :0;
};
//SIG(1 Ui_BFu33_BFu0i) C1{ Fi FL:33 Fi:0}



static void Test_Ui_BFu33_BFu0i()
{
  {
    init_simple_test("Ui_BFu33_BFu0i");
    static Ui_BFu33_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu0i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu0i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu33_BFu0i(Test_Ui_BFu33_BFu0i, "Ui_BFu33_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu33_BFu0ll  {
  unsigned int v1;
  __tsu64 v2:33;
  __tsu64  :0;
};
//SIG(1 Ui_BFu33_BFu0ll) C1{ Fi FL:33 FL:0}



static void Test_Ui_BFu33_BFu0ll()
{
  {
    init_simple_test("Ui_BFu33_BFu0ll");
    static Ui_BFu33_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu0ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu0ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu33_BFu0ll(Test_Ui_BFu33_BFu0ll, "Ui_BFu33_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu33_BFu0s  {
  unsigned int v1;
  __tsu64 v2:33;
  unsigned short  :0;
};
//SIG(1 Ui_BFu33_BFu0s) C1{ Fi FL:33 Fs:0}



static void Test_Ui_BFu33_BFu0s()
{
  {
    init_simple_test("Ui_BFu33_BFu0s");
    static Ui_BFu33_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu33_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu33_BFu0s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "Ui_BFu33_BFu0s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Ui_BFu33_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu33_BFu0s(Test_Ui_BFu33_BFu0s, "Ui_BFu33_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7c_BFu0c  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned char  :0;
};
//SIG(1 Ui_BFu7c_BFu0c) C1{ Fi Fc:7 Fc:0}



static void Test_Ui_BFu7c_BFu0c()
{
  {
    init_simple_test("Ui_BFu7c_BFu0c");
    static Ui_BFu7c_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu7c_BFu0c(Test_Ui_BFu7c_BFu0c, "Ui_BFu7c_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7c_BFu0i  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned int  :0;
};
//SIG(1 Ui_BFu7c_BFu0i) C1{ Fi Fc:7 Fi:0}



static void Test_Ui_BFu7c_BFu0i()
{
  {
    init_simple_test("Ui_BFu7c_BFu0i");
    static Ui_BFu7c_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu7c_BFu0i(Test_Ui_BFu7c_BFu0i, "Ui_BFu7c_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7c_BFu0ll  {
  unsigned int v1;
  unsigned char v2:7;
  __tsu64  :0;
};
//SIG(1 Ui_BFu7c_BFu0ll) C1{ Fi Fc:7 FL:0}



static void Test_Ui_BFu7c_BFu0ll()
{
  {
    init_simple_test("Ui_BFu7c_BFu0ll");
    static Ui_BFu7c_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu7c_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu7c_BFu0ll(Test_Ui_BFu7c_BFu0ll, "Ui_BFu7c_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7c_BFu0s  {
  unsigned int v1;
  unsigned char v2:7;
  unsigned short  :0;
};
//SIG(1 Ui_BFu7c_BFu0s) C1{ Fi Fc:7 Fs:0}



static void Test_Ui_BFu7c_BFu0s()
{
  {
    init_simple_test("Ui_BFu7c_BFu0s");
    static Ui_BFu7c_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7c_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7c_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7c_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7c_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu7c_BFu0s(Test_Ui_BFu7c_BFu0s, "Ui_BFu7c_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7i_BFu0c  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned char  :0;
};
//SIG(1 Ui_BFu7i_BFu0c) C1{ Fi Fi:7 Fc:0}



static void Test_Ui_BFu7i_BFu0c()
{
  {
    init_simple_test("Ui_BFu7i_BFu0c");
    static Ui_BFu7i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu7i_BFu0c(Test_Ui_BFu7i_BFu0c, "Ui_BFu7i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7i_BFu0i  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned int  :0;
};
//SIG(1 Ui_BFu7i_BFu0i) C1{ Fi Fi:7 Fi:0}



static void Test_Ui_BFu7i_BFu0i()
{
  {
    init_simple_test("Ui_BFu7i_BFu0i");
    static Ui_BFu7i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu7i_BFu0i(Test_Ui_BFu7i_BFu0i, "Ui_BFu7i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7i_BFu0ll  {
  unsigned int v1;
  unsigned int v2:7;
  __tsu64  :0;
};
//SIG(1 Ui_BFu7i_BFu0ll) C1{ Fi Fi:7 FL:0}



static void Test_Ui_BFu7i_BFu0ll()
{
  {
    init_simple_test("Ui_BFu7i_BFu0ll");
    static Ui_BFu7i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu7i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu7i_BFu0ll(Test_Ui_BFu7i_BFu0ll, "Ui_BFu7i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7i_BFu0s  {
  unsigned int v1;
  unsigned int v2:7;
  unsigned short  :0;
};
//SIG(1 Ui_BFu7i_BFu0s) C1{ Fi Fi:7 Fs:0}



static void Test_Ui_BFu7i_BFu0s()
{
  {
    init_simple_test("Ui_BFu7i_BFu0s");
    static Ui_BFu7i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7i_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7i_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu7i_BFu0s(Test_Ui_BFu7i_BFu0s, "Ui_BFu7i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7ll_BFu0c  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned char  :0;
};
//SIG(1 Ui_BFu7ll_BFu0c) C1{ Fi FL:7 Fc:0}



static void Test_Ui_BFu7ll_BFu0c()
{
  {
    init_simple_test("Ui_BFu7ll_BFu0c");
    static Ui_BFu7ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu7ll_BFu0c(Test_Ui_BFu7ll_BFu0c, "Ui_BFu7ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7ll_BFu0i  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned int  :0;
};
//SIG(1 Ui_BFu7ll_BFu0i) C1{ Fi FL:7 Fi:0}



static void Test_Ui_BFu7ll_BFu0i()
{
  {
    init_simple_test("Ui_BFu7ll_BFu0i");
    static Ui_BFu7ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu7ll_BFu0i(Test_Ui_BFu7ll_BFu0i, "Ui_BFu7ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7ll_BFu0ll  {
  unsigned int v1;
  __tsu64 v2:7;
  __tsu64  :0;
};
//SIG(1 Ui_BFu7ll_BFu0ll) C1{ Fi FL:7 FL:0}



static void Test_Ui_BFu7ll_BFu0ll()
{
  {
    init_simple_test("Ui_BFu7ll_BFu0ll");
    static Ui_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu7ll_BFu0ll(Test_Ui_BFu7ll_BFu0ll, "Ui_BFu7ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7ll_BFu0s  {
  unsigned int v1;
  __tsu64 v2:7;
  unsigned short  :0;
};
//SIG(1 Ui_BFu7ll_BFu0s) C1{ Fi FL:7 Fs:0}



static void Test_Ui_BFu7ll_BFu0s()
{
  {
    init_simple_test("Ui_BFu7ll_BFu0s");
    static Ui_BFu7ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu7ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu7ll_BFu0s(Test_Ui_BFu7ll_BFu0s, "Ui_BFu7ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7s_BFu0c  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned char  :0;
};
//SIG(1 Ui_BFu7s_BFu0c) C1{ Fi Fs:7 Fc:0}



static void Test_Ui_BFu7s_BFu0c()
{
  {
    init_simple_test("Ui_BFu7s_BFu0c");
    static Ui_BFu7s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu7s_BFu0c(Test_Ui_BFu7s_BFu0c, "Ui_BFu7s_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7s_BFu0i  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned int  :0;
};
//SIG(1 Ui_BFu7s_BFu0i) C1{ Fi Fs:7 Fi:0}



static void Test_Ui_BFu7s_BFu0i()
{
  {
    init_simple_test("Ui_BFu7s_BFu0i");
    static Ui_BFu7s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu7s_BFu0i(Test_Ui_BFu7s_BFu0i, "Ui_BFu7s_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7s_BFu0ll  {
  unsigned int v1;
  unsigned short v2:7;
  __tsu64  :0;
};
//SIG(1 Ui_BFu7s_BFu0ll) C1{ Fi Fs:7 FL:0}



static void Test_Ui_BFu7s_BFu0ll()
{
  {
    init_simple_test("Ui_BFu7s_BFu0ll");
    static Ui_BFu7s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu7s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu7s_BFu0ll(Test_Ui_BFu7s_BFu0ll, "Ui_BFu7s_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu7s_BFu0s  {
  unsigned int v1;
  unsigned short v2:7;
  unsigned short  :0;
};
//SIG(1 Ui_BFu7s_BFu0s) C1{ Fi Fs:7 Fs:0}



static void Test_Ui_BFu7s_BFu0s()
{
  {
    init_simple_test("Ui_BFu7s_BFu0s");
    static Ui_BFu7s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu7s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu7s_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu7s_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "Ui_BFu7s_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "Ui_BFu7s_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu7s_BFu0s(Test_Ui_BFu7s_BFu0s, "Ui_BFu7s_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8c_BFu0c  {
  unsigned int v1;
  unsigned char v2:8;
  unsigned char  :0;
};
//SIG(1 Ui_BFu8c_BFu0c) C1{ Fi Fc:8 Fc:0}



static void Test_Ui_BFu8c_BFu0c()
{
  {
    init_simple_test("Ui_BFu8c_BFu0c");
    static Ui_BFu8c_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8c_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu8c_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu8c_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8c_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8c_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu8c_BFu0c(Test_Ui_BFu8c_BFu0c, "Ui_BFu8c_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8c_BFu0i  {
  unsigned int v1;
  unsigned char v2:8;
  unsigned int  :0;
};
//SIG(1 Ui_BFu8c_BFu0i) C1{ Fi Fc:8 Fi:0}



static void Test_Ui_BFu8c_BFu0i()
{
  {
    init_simple_test("Ui_BFu8c_BFu0i");
    static Ui_BFu8c_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8c_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu8c_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu8c_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8c_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8c_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu8c_BFu0i(Test_Ui_BFu8c_BFu0i, "Ui_BFu8c_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8c_BFu0ll  {
  unsigned int v1;
  unsigned char v2:8;
  __tsu64  :0;
};
//SIG(1 Ui_BFu8c_BFu0ll) C1{ Fi Fc:8 FL:0}



static void Test_Ui_BFu8c_BFu0ll()
{
  {
    init_simple_test("Ui_BFu8c_BFu0ll");
    static Ui_BFu8c_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu8c_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu8c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8c_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8c_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu8c_BFu0ll(Test_Ui_BFu8c_BFu0ll, "Ui_BFu8c_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8c_BFu0s  {
  unsigned int v1;
  unsigned char v2:8;
  unsigned short  :0;
};
//SIG(1 Ui_BFu8c_BFu0s) C1{ Fi Fc:8 Fs:0}



static void Test_Ui_BFu8c_BFu0s()
{
  {
    init_simple_test("Ui_BFu8c_BFu0s");
    static Ui_BFu8c_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8c_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu8c_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu8c_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8c_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8c_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu8c_BFu0s(Test_Ui_BFu8c_BFu0s, "Ui_BFu8c_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8i_BFu0c  {
  unsigned int v1;
  unsigned int v2:8;
  unsigned char  :0;
};
//SIG(1 Ui_BFu8i_BFu0c) C1{ Fi Fi:8 Fc:0}



static void Test_Ui_BFu8i_BFu0c()
{
  {
    init_simple_test("Ui_BFu8i_BFu0c");
    static Ui_BFu8i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu8i_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu8i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8i_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu8i_BFu0c(Test_Ui_BFu8i_BFu0c, "Ui_BFu8i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8i_BFu0i  {
  unsigned int v1;
  unsigned int v2:8;
  unsigned int  :0;
};
//SIG(1 Ui_BFu8i_BFu0i) C1{ Fi Fi:8 Fi:0}



static void Test_Ui_BFu8i_BFu0i()
{
  {
    init_simple_test("Ui_BFu8i_BFu0i");
    static Ui_BFu8i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu8i_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu8i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8i_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu8i_BFu0i(Test_Ui_BFu8i_BFu0i, "Ui_BFu8i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8i_BFu0ll  {
  unsigned int v1;
  unsigned int v2:8;
  __tsu64  :0;
};
//SIG(1 Ui_BFu8i_BFu0ll) C1{ Fi Fi:8 FL:0}



static void Test_Ui_BFu8i_BFu0ll()
{
  {
    init_simple_test("Ui_BFu8i_BFu0ll");
    static Ui_BFu8i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu8i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu8i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu8i_BFu0ll(Test_Ui_BFu8i_BFu0ll, "Ui_BFu8i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8i_BFu0s  {
  unsigned int v1;
  unsigned int v2:8;
  unsigned short  :0;
};
//SIG(1 Ui_BFu8i_BFu0s) C1{ Fi Fi:8 Fs:0}



static void Test_Ui_BFu8i_BFu0s()
{
  {
    init_simple_test("Ui_BFu8i_BFu0s");
    static Ui_BFu8i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu8i_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu8i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8i_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu8i_BFu0s(Test_Ui_BFu8i_BFu0s, "Ui_BFu8i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8ll_BFu0c  {
  unsigned int v1;
  __tsu64 v2:8;
  unsigned char  :0;
};
//SIG(1 Ui_BFu8ll_BFu0c) C1{ Fi FL:8 Fc:0}



static void Test_Ui_BFu8ll_BFu0c()
{
  {
    init_simple_test("Ui_BFu8ll_BFu0c");
    static Ui_BFu8ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu8ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu8ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu8ll_BFu0c(Test_Ui_BFu8ll_BFu0c, "Ui_BFu8ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8ll_BFu0i  {
  unsigned int v1;
  __tsu64 v2:8;
  unsigned int  :0;
};
//SIG(1 Ui_BFu8ll_BFu0i) C1{ Fi FL:8 Fi:0}



static void Test_Ui_BFu8ll_BFu0i()
{
  {
    init_simple_test("Ui_BFu8ll_BFu0i");
    static Ui_BFu8ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu8ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu8ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu8ll_BFu0i(Test_Ui_BFu8ll_BFu0i, "Ui_BFu8ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8ll_BFu0ll  {
  unsigned int v1;
  __tsu64 v2:8;
  __tsu64  :0;
};
//SIG(1 Ui_BFu8ll_BFu0ll) C1{ Fi FL:8 FL:0}



static void Test_Ui_BFu8ll_BFu0ll()
{
  {
    init_simple_test("Ui_BFu8ll_BFu0ll");
    static Ui_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu8ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu8ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu8ll_BFu0ll(Test_Ui_BFu8ll_BFu0ll, "Ui_BFu8ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8ll_BFu0s  {
  unsigned int v1;
  __tsu64 v2:8;
  unsigned short  :0;
};
//SIG(1 Ui_BFu8ll_BFu0s) C1{ Fi FL:8 Fs:0}



static void Test_Ui_BFu8ll_BFu0s()
{
  {
    init_simple_test("Ui_BFu8ll_BFu0s");
    static Ui_BFu8ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu8ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu8ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu8ll_BFu0s(Test_Ui_BFu8ll_BFu0s, "Ui_BFu8ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8s_BFu0c  {
  unsigned int v1;
  unsigned short v2:8;
  unsigned char  :0;
};
//SIG(1 Ui_BFu8s_BFu0c) C1{ Fi Fs:8 Fc:0}



static void Test_Ui_BFu8s_BFu0c()
{
  {
    init_simple_test("Ui_BFu8s_BFu0c");
    static Ui_BFu8s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu8s_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu8s_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8s_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8s_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu8s_BFu0c(Test_Ui_BFu8s_BFu0c, "Ui_BFu8s_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8s_BFu0i  {
  unsigned int v1;
  unsigned short v2:8;
  unsigned int  :0;
};
//SIG(1 Ui_BFu8s_BFu0i) C1{ Fi Fs:8 Fi:0}



static void Test_Ui_BFu8s_BFu0i()
{
  {
    init_simple_test("Ui_BFu8s_BFu0i");
    static Ui_BFu8s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu8s_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu8s_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8s_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8s_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu8s_BFu0i(Test_Ui_BFu8s_BFu0i, "Ui_BFu8s_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8s_BFu0ll  {
  unsigned int v1;
  unsigned short v2:8;
  __tsu64  :0;
};
//SIG(1 Ui_BFu8s_BFu0ll) C1{ Fi Fs:8 FL:0}



static void Test_Ui_BFu8s_BFu0ll()
{
  {
    init_simple_test("Ui_BFu8s_BFu0ll");
    static Ui_BFu8s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu8s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu8s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8s_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu8s_BFu0ll(Test_Ui_BFu8s_BFu0ll, "Ui_BFu8s_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu8s_BFu0s  {
  unsigned int v1;
  unsigned short v2:8;
  unsigned short  :0;
};
//SIG(1 Ui_BFu8s_BFu0s) C1{ Fi Fs:8 Fs:0}



static void Test_Ui_BFu8s_BFu0s()
{
  {
    init_simple_test("Ui_BFu8s_BFu0s");
    static Ui_BFu8s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu8s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu8s_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu8s_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "Ui_BFu8s_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "Ui_BFu8s_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu8s_BFu0s(Test_Ui_BFu8s_BFu0s, "Ui_BFu8s_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu9i_BFu0c  {
  unsigned int v1;
  unsigned int v2:9;
  unsigned char  :0;
};
//SIG(1 Ui_BFu9i_BFu0c) C1{ Fi Fi:9 Fc:0}



static void Test_Ui_BFu9i_BFu0c()
{
  {
    init_simple_test("Ui_BFu9i_BFu0c");
    static Ui_BFu9i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu9i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu9i_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu9i_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu9i_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu9i_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu9i_BFu0c(Test_Ui_BFu9i_BFu0c, "Ui_BFu9i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu9i_BFu0i  {
  unsigned int v1;
  unsigned int v2:9;
  unsigned int  :0;
};
//SIG(1 Ui_BFu9i_BFu0i) C1{ Fi Fi:9 Fi:0}



static void Test_Ui_BFu9i_BFu0i()
{
  {
    init_simple_test("Ui_BFu9i_BFu0i");
    static Ui_BFu9i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu9i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu9i_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu9i_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu9i_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu9i_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu9i_BFu0i(Test_Ui_BFu9i_BFu0i, "Ui_BFu9i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu9i_BFu0ll  {
  unsigned int v1;
  unsigned int v2:9;
  __tsu64  :0;
};
//SIG(1 Ui_BFu9i_BFu0ll) C1{ Fi Fi:9 FL:0}



static void Test_Ui_BFu9i_BFu0ll()
{
  {
    init_simple_test("Ui_BFu9i_BFu0ll");
    static Ui_BFu9i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu9i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu9i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu9i_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu9i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu9i_BFu0ll(Test_Ui_BFu9i_BFu0ll, "Ui_BFu9i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu9i_BFu0s  {
  unsigned int v1;
  unsigned int v2:9;
  unsigned short  :0;
};
//SIG(1 Ui_BFu9i_BFu0s) C1{ Fi Fi:9 Fs:0}



static void Test_Ui_BFu9i_BFu0s()
{
  {
    init_simple_test("Ui_BFu9i_BFu0s");
    static Ui_BFu9i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu9i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu9i_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu9i_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu9i_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu9i_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu9i_BFu0s(Test_Ui_BFu9i_BFu0s, "Ui_BFu9i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu9ll_BFu0c  {
  unsigned int v1;
  __tsu64 v2:9;
  unsigned char  :0;
};
//SIG(1 Ui_BFu9ll_BFu0c) C1{ Fi FL:9 Fc:0}



static void Test_Ui_BFu9ll_BFu0c()
{
  {
    init_simple_test("Ui_BFu9ll_BFu0c");
    static Ui_BFu9ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu9ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu9ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu9ll_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu9ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu9ll_BFu0c(Test_Ui_BFu9ll_BFu0c, "Ui_BFu9ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu9ll_BFu0i  {
  unsigned int v1;
  __tsu64 v2:9;
  unsigned int  :0;
};
//SIG(1 Ui_BFu9ll_BFu0i) C1{ Fi FL:9 Fi:0}



static void Test_Ui_BFu9ll_BFu0i()
{
  {
    init_simple_test("Ui_BFu9ll_BFu0i");
    static Ui_BFu9ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu9ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu9ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu9ll_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu9ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu9ll_BFu0i(Test_Ui_BFu9ll_BFu0i, "Ui_BFu9ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu9ll_BFu0ll  {
  unsigned int v1;
  __tsu64 v2:9;
  __tsu64  :0;
};
//SIG(1 Ui_BFu9ll_BFu0ll) C1{ Fi FL:9 FL:0}



static void Test_Ui_BFu9ll_BFu0ll()
{
  {
    init_simple_test("Ui_BFu9ll_BFu0ll");
    static Ui_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu9ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu9ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu9ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu9ll_BFu0ll(Test_Ui_BFu9ll_BFu0ll, "Ui_BFu9ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu9ll_BFu0s  {
  unsigned int v1;
  __tsu64 v2:9;
  unsigned short  :0;
};
//SIG(1 Ui_BFu9ll_BFu0s) C1{ Fi FL:9 Fs:0}



static void Test_Ui_BFu9ll_BFu0s()
{
  {
    init_simple_test("Ui_BFu9ll_BFu0s");
    static Ui_BFu9ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_BFu9ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu9ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu9ll_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu9ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu9ll_BFu0s(Test_Ui_BFu9ll_BFu0s, "Ui_BFu9ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu9s_BFu0c  {
  unsigned int v1;
  unsigned short v2:9;
  unsigned char  :0;
};
//SIG(1 Ui_BFu9s_BFu0c) C1{ Fi Fs:9 Fc:0}



static void Test_Ui_BFu9s_BFu0c()
{
  {
    init_simple_test("Ui_BFu9s_BFu0c");
    static Ui_BFu9s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu9s_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu9s_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_BFu9s_BFu0c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu9s_BFu0c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu9s_BFu0c");
  }
}
static Arrange_To_Call_Me vUi_BFu9s_BFu0c(Test_Ui_BFu9s_BFu0c, "Ui_BFu9s_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu9s_BFu0i  {
  unsigned int v1;
  unsigned short v2:9;
  unsigned int  :0;
};
//SIG(1 Ui_BFu9s_BFu0i) C1{ Fi Fs:9 Fi:0}



static void Test_Ui_BFu9s_BFu0i()
{
  {
    init_simple_test("Ui_BFu9s_BFu0i");
    static Ui_BFu9s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu9s_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu9s_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_BFu9s_BFu0i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu9s_BFu0i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu9s_BFu0i");
  }
}
static Arrange_To_Call_Me vUi_BFu9s_BFu0i(Test_Ui_BFu9s_BFu0i, "Ui_BFu9s_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu9s_BFu0ll  {
  unsigned int v1;
  unsigned short v2:9;
  __tsu64  :0;
};
//SIG(1 Ui_BFu9s_BFu0ll) C1{ Fi Fs:9 FL:0}



static void Test_Ui_BFu9s_BFu0ll()
{
  {
    init_simple_test("Ui_BFu9s_BFu0ll");
    static Ui_BFu9s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_BFu9s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_BFu9s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu9s_BFu0ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu9s_BFu0ll");
  }
}
static Arrange_To_Call_Me vUi_BFu9s_BFu0ll(Test_Ui_BFu9s_BFu0ll, "Ui_BFu9s_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_BFu9s_BFu0s  {
  unsigned int v1;
  unsigned short v2:9;
  unsigned short  :0;
};
//SIG(1 Ui_BFu9s_BFu0s) C1{ Fi Fs:9 Fs:0}



static void Test_Ui_BFu9s_BFu0s()
{
  {
    init_simple_test("Ui_BFu9s_BFu0s");
    static Ui_BFu9s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_BFu9s_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_BFu9s_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_BFu9s_BFu0s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "Ui_BFu9s_BFu0s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "Ui_BFu9s_BFu0s");
  }
}
static Arrange_To_Call_Me vUi_BFu9s_BFu0s(Test_Ui_BFu9s_BFu0s, "Ui_BFu9s_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_C_BFu0c  {
  unsigned int v1;
  char v2;
  unsigned char  :0;
};
//SIG(1 Ui_C_BFu0c) C1{ Fi Fc Fc:0}



static void Test_Ui_C_BFu0c()
{
  {
    init_simple_test("Ui_C_BFu0c");
    static Ui_C_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_C_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_C_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_C_BFu0c.v1");
    check_field_offset(lv, v2, 4, "Ui_C_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUi_C_BFu0c(Test_Ui_C_BFu0c, "Ui_C_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_C_BFu0i  {
  unsigned int v1;
  char v2;
  unsigned int  :0;
};
//SIG(1 Ui_C_BFu0i) C1{ Fi Fc Fi:0}



static void Test_Ui_C_BFu0i()
{
  {
    init_simple_test("Ui_C_BFu0i");
    static Ui_C_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_C_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_C_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_C_BFu0i.v1");
    check_field_offset(lv, v2, 4, "Ui_C_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUi_C_BFu0i(Test_Ui_C_BFu0i, "Ui_C_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_C_BFu0ll  {
  unsigned int v1;
  char v2;
  __tsu64  :0;
};
//SIG(1 Ui_C_BFu0ll) C1{ Fi Fc FL:0}



static void Test_Ui_C_BFu0ll()
{
  {
    init_simple_test("Ui_C_BFu0ll");
    static Ui_C_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_C_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_C_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "Ui_C_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUi_C_BFu0ll(Test_Ui_C_BFu0ll, "Ui_C_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_C_BFu0s  {
  unsigned int v1;
  char v2;
  unsigned short  :0;
};
//SIG(1 Ui_C_BFu0s) C1{ Fi Fc Fs:0}



static void Test_Ui_C_BFu0s()
{
  {
    init_simple_test("Ui_C_BFu0s");
    static Ui_C_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_C_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_C_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_C_BFu0s.v1");
    check_field_offset(lv, v2, 4, "Ui_C_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUi_C_BFu0s(Test_Ui_C_BFu0s, "Ui_C_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_D_BFu0c  {
  unsigned int v1;
  double v2;
  unsigned char  :0;
};
//SIG(1 Ui_D_BFu0c) C1{ Fi FL Fc:0}



static void Test_Ui_D_BFu0c()
{
  {
    init_simple_test("Ui_D_BFu0c");
    static Ui_D_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_D_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_D_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_D_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUi_D_BFu0c(Test_Ui_D_BFu0c, "Ui_D_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_D_BFu0i  {
  unsigned int v1;
  double v2;
  unsigned int  :0;
};
//SIG(1 Ui_D_BFu0i) C1{ Fi FL Fi:0}



static void Test_Ui_D_BFu0i()
{
  {
    init_simple_test("Ui_D_BFu0i");
    static Ui_D_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_D_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_D_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_D_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUi_D_BFu0i(Test_Ui_D_BFu0i, "Ui_D_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_D_BFu0ll  {
  unsigned int v1;
  double v2;
  __tsu64  :0;
};
//SIG(1 Ui_D_BFu0ll) C1{ Fi FL FL:0}



static void Test_Ui_D_BFu0ll()
{
  {
    init_simple_test("Ui_D_BFu0ll");
    static Ui_D_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_D_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_D_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_D_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUi_D_BFu0ll(Test_Ui_D_BFu0ll, "Ui_D_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_D_BFu0s  {
  unsigned int v1;
  double v2;
  unsigned short  :0;
};
//SIG(1 Ui_D_BFu0s) C1{ Fi FL Fs:0}



static void Test_Ui_D_BFu0s()
{
  {
    init_simple_test("Ui_D_BFu0s");
    static Ui_D_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_D_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_D_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_D_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUi_D_BFu0s(Test_Ui_D_BFu0s, "Ui_D_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_F_BFu0c  {
  unsigned int v1;
  float v2;
  unsigned char  :0;
};
//SIG(1 Ui_F_BFu0c) C1{ Fi[2] Fc:0}



static void Test_Ui_F_BFu0c()
{
  {
    init_simple_test("Ui_F_BFu0c");
    static Ui_F_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_F_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_F_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_F_BFu0c.v1");
    check_field_offset(lv, v2, 4, "Ui_F_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUi_F_BFu0c(Test_Ui_F_BFu0c, "Ui_F_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_F_BFu0i  {
  unsigned int v1;
  float v2;
  unsigned int  :0;
};
//SIG(1 Ui_F_BFu0i) C1{ Fi[2] Fi:0}



static void Test_Ui_F_BFu0i()
{
  {
    init_simple_test("Ui_F_BFu0i");
    static Ui_F_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_F_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_F_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_F_BFu0i.v1");
    check_field_offset(lv, v2, 4, "Ui_F_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUi_F_BFu0i(Test_Ui_F_BFu0i, "Ui_F_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_F_BFu0ll  {
  unsigned int v1;
  float v2;
  __tsu64  :0;
};
//SIG(1 Ui_F_BFu0ll) C1{ Fi[2] FL:0}



static void Test_Ui_F_BFu0ll()
{
  {
    init_simple_test("Ui_F_BFu0ll");
    static Ui_F_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_F_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_F_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "Ui_F_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUi_F_BFu0ll(Test_Ui_F_BFu0ll, "Ui_F_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_F_BFu0s  {
  unsigned int v1;
  float v2;
  unsigned short  :0;
};
//SIG(1 Ui_F_BFu0s) C1{ Fi[2] Fs:0}



static void Test_Ui_F_BFu0s()
{
  {
    init_simple_test("Ui_F_BFu0s");
    static Ui_F_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_F_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_F_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_F_BFu0s.v1");
    check_field_offset(lv, v2, 4, "Ui_F_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUi_F_BFu0s(Test_Ui_F_BFu0s, "Ui_F_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_I_BFu0c  {
  unsigned int v1;
  int v2;
  unsigned char  :0;
};
//SIG(1 Ui_I_BFu0c) C1{ Fi[2] Fc:0}



static void Test_Ui_I_BFu0c()
{
  {
    init_simple_test("Ui_I_BFu0c");
    static Ui_I_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_I_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_I_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_I_BFu0c.v1");
    check_field_offset(lv, v2, 4, "Ui_I_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUi_I_BFu0c(Test_Ui_I_BFu0c, "Ui_I_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_I_BFu0i  {
  unsigned int v1;
  int v2;
  unsigned int  :0;
};
//SIG(1 Ui_I_BFu0i) C1{ Fi[2] Fi:0}



static void Test_Ui_I_BFu0i()
{
  {
    init_simple_test("Ui_I_BFu0i");
    static Ui_I_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_I_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_I_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_I_BFu0i.v1");
    check_field_offset(lv, v2, 4, "Ui_I_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUi_I_BFu0i(Test_Ui_I_BFu0i, "Ui_I_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_I_BFu0ll  {
  unsigned int v1;
  int v2;
  __tsu64  :0;
};
//SIG(1 Ui_I_BFu0ll) C1{ Fi[2] FL:0}



static void Test_Ui_I_BFu0ll()
{
  {
    init_simple_test("Ui_I_BFu0ll");
    static Ui_I_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_I_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_I_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "Ui_I_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUi_I_BFu0ll(Test_Ui_I_BFu0ll, "Ui_I_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_I_BFu0s  {
  unsigned int v1;
  int v2;
  unsigned short  :0;
};
//SIG(1 Ui_I_BFu0s) C1{ Fi[2] Fs:0}



static void Test_Ui_I_BFu0s()
{
  {
    init_simple_test("Ui_I_BFu0s");
    static Ui_I_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_I_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_I_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_I_BFu0s.v1");
    check_field_offset(lv, v2, 4, "Ui_I_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUi_I_BFu0s(Test_Ui_I_BFu0s, "Ui_I_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Ip_BFu0c  {
  unsigned int v1;
  int *v2;
  unsigned char  :0;
};
//SIG(1 Ui_Ip_BFu0c) C1{ Fi Fp Fc:0}



static void Test_Ui_Ip_BFu0c()
{
  {
    init_simple_test("Ui_Ip_BFu0c");
    static Ui_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_Ip_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_Ip_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_Ip_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUi_Ip_BFu0c(Test_Ui_Ip_BFu0c, "Ui_Ip_BFu0c", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Ip_BFu0i  {
  unsigned int v1;
  int *v2;
  unsigned int  :0;
};
//SIG(1 Ui_Ip_BFu0i) C1{ Fi Fp Fi:0}



static void Test_Ui_Ip_BFu0i()
{
  {
    init_simple_test("Ui_Ip_BFu0i");
    static Ui_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_Ip_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_Ip_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_Ip_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUi_Ip_BFu0i(Test_Ui_Ip_BFu0i, "Ui_Ip_BFu0i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Ip_BFu0ll  {
  unsigned int v1;
  int *v2;
  __tsu64  :0;
};
//SIG(1 Ui_Ip_BFu0ll) C1{ Fi Fp FL:0}



static void Test_Ui_Ip_BFu0ll()
{
  {
    init_simple_test("Ui_Ip_BFu0ll");
    static Ui_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_Ip_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_Ip_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_Ip_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUi_Ip_BFu0ll(Test_Ui_Ip_BFu0ll, "Ui_Ip_BFu0ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Ip_BFu0s  {
  unsigned int v1;
  int *v2;
  unsigned short  :0;
};
//SIG(1 Ui_Ip_BFu0s) C1{ Fi Fp Fs:0}



static void Test_Ui_Ip_BFu0s()
{
  {
    init_simple_test("Ui_Ip_BFu0s");
    static Ui_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_Ip_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_Ip_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_Ip_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUi_Ip_BFu0s(Test_Ui_Ip_BFu0s, "Ui_Ip_BFu0s", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_L_BFu0c  {
  unsigned int v1;
  __tsi64 v2;
  unsigned char  :0;
};
//SIG(1 Ui_L_BFu0c) C1{ Fi FL Fc:0}



static void Test_Ui_L_BFu0c()
{
  {
    init_simple_test("Ui_L_BFu0c");
    static Ui_L_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_L_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_L_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_L_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUi_L_BFu0c(Test_Ui_L_BFu0c, "Ui_L_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_L_BFu0i  {
  unsigned int v1;
  __tsi64 v2;
  unsigned int  :0;
};
//SIG(1 Ui_L_BFu0i) C1{ Fi FL Fi:0}



static void Test_Ui_L_BFu0i()
{
  {
    init_simple_test("Ui_L_BFu0i");
    static Ui_L_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_L_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_L_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_L_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUi_L_BFu0i(Test_Ui_L_BFu0i, "Ui_L_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_L_BFu0ll  {
  unsigned int v1;
  __tsi64 v2;
  __tsu64  :0;
};
//SIG(1 Ui_L_BFu0ll) C1{ Fi FL FL:0}



static void Test_Ui_L_BFu0ll()
{
  {
    init_simple_test("Ui_L_BFu0ll");
    static Ui_L_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_L_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_L_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_L_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUi_L_BFu0ll(Test_Ui_L_BFu0ll, "Ui_L_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_L_BFu0s  {
  unsigned int v1;
  __tsi64 v2;
  unsigned short  :0;
};
//SIG(1 Ui_L_BFu0s) C1{ Fi FL Fs:0}



static void Test_Ui_L_BFu0s()
{
  {
    init_simple_test("Ui_L_BFu0s");
    static Ui_L_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_L_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_L_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_L_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUi_L_BFu0s(Test_Ui_L_BFu0s, "Ui_L_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_S_BFu0c  {
  unsigned int v1;
  short v2;
  unsigned char  :0;
};
//SIG(1 Ui_S_BFu0c) C1{ Fi Fs Fc:0}



static void Test_Ui_S_BFu0c()
{
  {
    init_simple_test("Ui_S_BFu0c");
    static Ui_S_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_S_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_S_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_S_BFu0c.v1");
    check_field_offset(lv, v2, 4, "Ui_S_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUi_S_BFu0c(Test_Ui_S_BFu0c, "Ui_S_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_S_BFu0i  {
  unsigned int v1;
  short v2;
  unsigned int  :0;
};
//SIG(1 Ui_S_BFu0i) C1{ Fi Fs Fi:0}



static void Test_Ui_S_BFu0i()
{
  {
    init_simple_test("Ui_S_BFu0i");
    static Ui_S_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_S_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_S_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_S_BFu0i.v1");
    check_field_offset(lv, v2, 4, "Ui_S_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUi_S_BFu0i(Test_Ui_S_BFu0i, "Ui_S_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_S_BFu0ll  {
  unsigned int v1;
  short v2;
  __tsu64  :0;
};
//SIG(1 Ui_S_BFu0ll) C1{ Fi Fs FL:0}



static void Test_Ui_S_BFu0ll()
{
  {
    init_simple_test("Ui_S_BFu0ll");
    static Ui_S_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_S_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_S_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "Ui_S_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUi_S_BFu0ll(Test_Ui_S_BFu0ll, "Ui_S_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_S_BFu0s  {
  unsigned int v1;
  short v2;
  unsigned short  :0;
};
//SIG(1 Ui_S_BFu0s) C1{ Fi Fs Fs:0}



static void Test_Ui_S_BFu0s()
{
  {
    init_simple_test("Ui_S_BFu0s");
    static Ui_S_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_S_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_S_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_S_BFu0s.v1");
    check_field_offset(lv, v2, 4, "Ui_S_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUi_S_BFu0s(Test_Ui_S_BFu0s, "Ui_S_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Uc_BFu0c  {
  unsigned int v1;
  unsigned char v2;
  unsigned char  :0;
};
//SIG(1 Ui_Uc_BFu0c) C1{ Fi Fc Fc:0}



static void Test_Ui_Uc_BFu0c()
{
  {
    init_simple_test("Ui_Uc_BFu0c");
    static Ui_Uc_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Uc_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_Uc_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_Uc_BFu0c.v1");
    check_field_offset(lv, v2, 4, "Ui_Uc_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUi_Uc_BFu0c(Test_Ui_Uc_BFu0c, "Ui_Uc_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Uc_BFu0i  {
  unsigned int v1;
  unsigned char v2;
  unsigned int  :0;
};
//SIG(1 Ui_Uc_BFu0i) C1{ Fi Fc Fi:0}



static void Test_Ui_Uc_BFu0i()
{
  {
    init_simple_test("Ui_Uc_BFu0i");
    static Ui_Uc_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Uc_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_Uc_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_Uc_BFu0i.v1");
    check_field_offset(lv, v2, 4, "Ui_Uc_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUi_Uc_BFu0i(Test_Ui_Uc_BFu0i, "Ui_Uc_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Uc_BFu0ll  {
  unsigned int v1;
  unsigned char v2;
  __tsu64  :0;
};
//SIG(1 Ui_Uc_BFu0ll) C1{ Fi Fc FL:0}



static void Test_Ui_Uc_BFu0ll()
{
  {
    init_simple_test("Ui_Uc_BFu0ll");
    static Ui_Uc_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Uc_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_Uc_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_Uc_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Uc_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUi_Uc_BFu0ll(Test_Ui_Uc_BFu0ll, "Ui_Uc_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Uc_BFu0s  {
  unsigned int v1;
  unsigned char v2;
  unsigned short  :0;
};
//SIG(1 Ui_Uc_BFu0s) C1{ Fi Fc Fs:0}



static void Test_Ui_Uc_BFu0s()
{
  {
    init_simple_test("Ui_Uc_BFu0s");
    static Ui_Uc_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Uc_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_Uc_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_Uc_BFu0s.v1");
    check_field_offset(lv, v2, 4, "Ui_Uc_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUi_Uc_BFu0s(Test_Ui_Uc_BFu0s, "Ui_Uc_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Ui_BFu0c  {
  unsigned int v1;
  unsigned int v2;
  unsigned char  :0;
};
//SIG(1 Ui_Ui_BFu0c) C1{ Fi[2] Fc:0}



static void Test_Ui_Ui_BFu0c()
{
  {
    init_simple_test("Ui_Ui_BFu0c");
    static Ui_Ui_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Ui_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_Ui_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_Ui_BFu0c.v1");
    check_field_offset(lv, v2, 4, "Ui_Ui_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUi_Ui_BFu0c(Test_Ui_Ui_BFu0c, "Ui_Ui_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Ui_BFu0i  {
  unsigned int v1;
  unsigned int v2;
  unsigned int  :0;
};
//SIG(1 Ui_Ui_BFu0i) C1{ Fi[2] Fi:0}



static void Test_Ui_Ui_BFu0i()
{
  {
    init_simple_test("Ui_Ui_BFu0i");
    static Ui_Ui_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Ui_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_Ui_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_Ui_BFu0i.v1");
    check_field_offset(lv, v2, 4, "Ui_Ui_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUi_Ui_BFu0i(Test_Ui_Ui_BFu0i, "Ui_Ui_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Ui_BFu0ll  {
  unsigned int v1;
  unsigned int v2;
  __tsu64  :0;
};
//SIG(1 Ui_Ui_BFu0ll) C1{ Fi[2] FL:0}



static void Test_Ui_Ui_BFu0ll()
{
  {
    init_simple_test("Ui_Ui_BFu0ll");
    static Ui_Ui_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Ui_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_Ui_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_Ui_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Ui_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUi_Ui_BFu0ll(Test_Ui_Ui_BFu0ll, "Ui_Ui_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Ui_BFu0s  {
  unsigned int v1;
  unsigned int v2;
  unsigned short  :0;
};
//SIG(1 Ui_Ui_BFu0s) C1{ Fi[2] Fs:0}



static void Test_Ui_Ui_BFu0s()
{
  {
    init_simple_test("Ui_Ui_BFu0s");
    static Ui_Ui_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Ui_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_Ui_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_Ui_BFu0s.v1");
    check_field_offset(lv, v2, 4, "Ui_Ui_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUi_Ui_BFu0s(Test_Ui_Ui_BFu0s, "Ui_Ui_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Ul_BFu0c  {
  unsigned int v1;
  __tsu64 v2;
  unsigned char  :0;
};
//SIG(1 Ui_Ul_BFu0c) C1{ Fi FL Fc:0}



static void Test_Ui_Ul_BFu0c()
{
  {
    init_simple_test("Ui_Ul_BFu0c");
    static Ui_Ul_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_Ul_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_Ul_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_Ul_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUi_Ul_BFu0c(Test_Ui_Ul_BFu0c, "Ui_Ul_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Ul_BFu0i  {
  unsigned int v1;
  __tsu64 v2;
  unsigned int  :0;
};
//SIG(1 Ui_Ul_BFu0i) C1{ Fi FL Fi:0}



static void Test_Ui_Ul_BFu0i()
{
  {
    init_simple_test("Ui_Ul_BFu0i");
    static Ui_Ul_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_Ul_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_Ul_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_Ul_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUi_Ul_BFu0i(Test_Ui_Ul_BFu0i, "Ui_Ul_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Ul_BFu0ll  {
  unsigned int v1;
  __tsu64 v2;
  __tsu64  :0;
};
//SIG(1 Ui_Ul_BFu0ll) C1{ Fi FL FL:0}



static void Test_Ui_Ul_BFu0ll()
{
  {
    init_simple_test("Ui_Ul_BFu0ll");
    static Ui_Ul_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_Ul_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_Ul_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_Ul_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUi_Ul_BFu0ll(Test_Ui_Ul_BFu0ll, "Ui_Ul_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Ul_BFu0s  {
  unsigned int v1;
  __tsu64 v2;
  unsigned short  :0;
};
//SIG(1 Ui_Ul_BFu0s) C1{ Fi FL Fs:0}



static void Test_Ui_Ul_BFu0s()
{
  {
    init_simple_test("Ui_Ul_BFu0s");
    static Ui_Ul_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ui_Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_Ul_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_Ul_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_Ul_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUi_Ul_BFu0s(Test_Ui_Ul_BFu0s, "Ui_Ul_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Us_BFu0c  {
  unsigned int v1;
  unsigned short v2;
  unsigned char  :0;
};
//SIG(1 Ui_Us_BFu0c) C1{ Fi Fs Fc:0}



static void Test_Ui_Us_BFu0c()
{
  {
    init_simple_test("Ui_Us_BFu0c");
    static Ui_Us_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_Us_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu0c.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUi_Us_BFu0c(Test_Ui_Us_BFu0c, "Ui_Us_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Us_BFu0i  {
  unsigned int v1;
  unsigned short v2;
  unsigned int  :0;
};
//SIG(1 Ui_Us_BFu0i) C1{ Fi Fs Fi:0}



static void Test_Ui_Us_BFu0i()
{
  {
    init_simple_test("Ui_Us_BFu0i");
    static Ui_Us_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_Us_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu0i.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUi_Us_BFu0i(Test_Ui_Us_BFu0i, "Ui_Us_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Us_BFu0ll  {
  unsigned int v1;
  unsigned short v2;
  __tsu64  :0;
};
//SIG(1 Ui_Us_BFu0ll) C1{ Fi Fs FL:0}



static void Test_Ui_Us_BFu0ll()
{
  {
    init_simple_test("Ui_Us_BFu0ll");
    static Ui_Us_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(Ui_Us_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu0ll.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUi_Us_BFu0ll(Test_Ui_Us_BFu0ll, "Ui_Us_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Us_BFu0s  {
  unsigned int v1;
  unsigned short v2;
  unsigned short  :0;
};
//SIG(1 Ui_Us_BFu0s) C1{ Fi Fs Fs:0}



static void Test_Ui_Us_BFu0s()
{
  {
    init_simple_test("Ui_Us_BFu0s");
    static Ui_Us_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ui_Us_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(Ui_Us_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_Us_BFu0s.v1");
    check_field_offset(lv, v2, 4, "Ui_Us_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUi_Us_BFu0s(Test_Ui_Us_BFu0s, "Ui_Us_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Vp_BFu0c  {
  unsigned int v1;
  void *v2;
  unsigned char  :0;
};
//SIG(1 Ui_Vp_BFu0c) C1{ Fi Fp Fc:0}



static void Test_Ui_Vp_BFu0c()
{
  {
    init_simple_test("Ui_Vp_BFu0c");
    static Ui_Vp_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_Vp_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_Vp_BFu0c)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu0c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_Vp_BFu0c.v2");
  }
}
static Arrange_To_Call_Me vUi_Vp_BFu0c(Test_Ui_Vp_BFu0c, "Ui_Vp_BFu0c", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Vp_BFu0i  {
  unsigned int v1;
  void *v2;
  unsigned int  :0;
};
//SIG(1 Ui_Vp_BFu0i) C1{ Fi Fp Fi:0}



static void Test_Ui_Vp_BFu0i()
{
  {
    init_simple_test("Ui_Vp_BFu0i");
    static Ui_Vp_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_Vp_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_Vp_BFu0i)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu0i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_Vp_BFu0i.v2");
  }
}
static Arrange_To_Call_Me vUi_Vp_BFu0i(Test_Ui_Vp_BFu0i, "Ui_Vp_BFu0i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Vp_BFu0ll  {
  unsigned int v1;
  void *v2;
  __tsu64  :0;
};
//SIG(1 Ui_Vp_BFu0ll) C1{ Fi Fp FL:0}



static void Test_Ui_Vp_BFu0ll()
{
  {
    init_simple_test("Ui_Vp_BFu0ll");
    static Ui_Vp_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_Vp_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_Vp_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu0ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_Vp_BFu0ll.v2");
  }
}
static Arrange_To_Call_Me vUi_Vp_BFu0ll(Test_Ui_Vp_BFu0ll, "Ui_Vp_BFu0ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ui_Vp_BFu0s  {
  unsigned int v1;
  void *v2;
  unsigned short  :0;
};
//SIG(1 Ui_Vp_BFu0s) C1{ Fi Fp Fs:0}



static void Test_Ui_Vp_BFu0s()
{
  {
    init_simple_test("Ui_Vp_BFu0s");
    static Ui_Vp_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Ui_Vp_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ui_Vp_BFu0s)");
    check_field_offset(lv, v1, 0, "Ui_Vp_BFu0s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Ui_Vp_BFu0s.v2");
  }
}
static Arrange_To_Call_Me vUi_Vp_BFu0s(Test_Ui_Vp_BFu0s, "Ui_Vp_BFu0s", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c  {
  __tsu64 v1;
  unsigned char  :0;
};
//SIG(1 Ul_BFu0c) C1{ FL Fc:0}



static void Test_Ul_BFu0c()
{
  {
    init_simple_test("Ul_BFu0c");
    static Ul_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0c(Test_Ul_BFu0c, "Ul_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu0c  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned char  :0;
};
//SIG(1 Ul_BFu0c_BFu0c) C1{ FL Fc:0 Fc:0}



static void Test_Ul_BFu0c_BFu0c()
{
  {
    init_simple_test("Ul_BFu0c_BFu0c");
    static Ul_BFu0c_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu0c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu0c(Test_Ul_BFu0c_BFu0c, "Ul_BFu0c_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu0i  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned int  :0;
};
//SIG(1 Ul_BFu0c_BFu0i) C1{ FL Fc:0 Fi:0}



static void Test_Ul_BFu0c_BFu0i()
{
  {
    init_simple_test("Ul_BFu0c_BFu0i");
    static Ul_BFu0c_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu0i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu0i(Test_Ul_BFu0c_BFu0i, "Ul_BFu0c_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu0ll  {
  __tsu64 v1;
  unsigned char  :0;
  __tsu64  :0;
};
//SIG(1 Ul_BFu0c_BFu0ll) C1{ FL Fc:0 FL:0}



static void Test_Ul_BFu0c_BFu0ll()
{
  {
    init_simple_test("Ul_BFu0c_BFu0ll");
    static Ul_BFu0c_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu0ll(Test_Ul_BFu0c_BFu0ll, "Ul_BFu0c_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu0s  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned short  :0;
};
//SIG(1 Ul_BFu0c_BFu0s) C1{ FL Fc:0 Fs:0}



static void Test_Ul_BFu0c_BFu0s()
{
  {
    init_simple_test("Ul_BFu0c_BFu0s");
    static Ul_BFu0c_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu0s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu0s(Test_Ul_BFu0c_BFu0s, "Ul_BFu0c_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu15i  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned int v2:15;
};
//SIG(1 Ul_BFu0c_BFu15i) C1{ FL Fc:0 Fi:15}



static void Test_Ul_BFu0c_BFu15i()
{
  {
    init_simple_test("Ul_BFu0c_BFu15i");
    static Ul_BFu0c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu0c_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu0c_BFu15i");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu15i(Test_Ul_BFu0c_BFu15i, "Ul_BFu0c_BFu15i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu15ll  {
  __tsu64 v1;
  unsigned char  :0;
  __tsu64 v2:15;
};
//SIG(1 Ul_BFu0c_BFu15ll) C1{ FL Fc:0 FL:15}



static void Test_Ul_BFu0c_BFu15ll()
{
  {
    init_simple_test("Ul_BFu0c_BFu15ll");
    static Ul_BFu0c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu0c_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu0c_BFu15ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu15ll(Test_Ul_BFu0c_BFu15ll, "Ul_BFu0c_BFu15ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu15s  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned short v2:15;
};
//SIG(1 Ul_BFu0c_BFu15s) C1{ FL Fc:0 Fs:15}



static void Test_Ul_BFu0c_BFu15s()
{
  {
    init_simple_test("Ul_BFu0c_BFu15s");
    static Ul_BFu0c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu0c_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu0c_BFu15s");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu15s(Test_Ul_BFu0c_BFu15s, "Ul_BFu0c_BFu15s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu16i  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned int v2:16;
};
//SIG(1 Ul_BFu0c_BFu16i) C1{ FL Fc:0 Fi:16}



static void Test_Ul_BFu0c_BFu16i()
{
  {
    init_simple_test("Ul_BFu0c_BFu16i");
    static Ul_BFu0c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu0c_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu0c_BFu16i");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu16i(Test_Ul_BFu0c_BFu16i, "Ul_BFu0c_BFu16i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu16ll  {
  __tsu64 v1;
  unsigned char  :0;
  __tsu64 v2:16;
};
//SIG(1 Ul_BFu0c_BFu16ll) C1{ FL Fc:0 FL:16}



static void Test_Ul_BFu0c_BFu16ll()
{
  {
    init_simple_test("Ul_BFu0c_BFu16ll");
    static Ul_BFu0c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu0c_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu0c_BFu16ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu16ll(Test_Ul_BFu0c_BFu16ll, "Ul_BFu0c_BFu16ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu16s  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned short v2:16;
};
//SIG(1 Ul_BFu0c_BFu16s) C1{ FL Fc:0 Fs:16}



static void Test_Ul_BFu0c_BFu16s()
{
  {
    init_simple_test("Ul_BFu0c_BFu16s");
    static Ul_BFu0c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu0c_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu0c_BFu16s");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu16s(Test_Ul_BFu0c_BFu16s, "Ul_BFu0c_BFu16s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu17i  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned int v2:17;
};
//SIG(1 Ul_BFu0c_BFu17i) C1{ FL Fc:0 Fi:17}



static void Test_Ul_BFu0c_BFu17i()
{
  {
    init_simple_test("Ul_BFu0c_BFu17i");
    static Ul_BFu0c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu0c_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu0c_BFu17i");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu17i(Test_Ul_BFu0c_BFu17i, "Ul_BFu0c_BFu17i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu17ll  {
  __tsu64 v1;
  unsigned char  :0;
  __tsu64 v2:17;
};
//SIG(1 Ul_BFu0c_BFu17ll) C1{ FL Fc:0 FL:17}



static void Test_Ul_BFu0c_BFu17ll()
{
  {
    init_simple_test("Ul_BFu0c_BFu17ll");
    static Ul_BFu0c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu0c_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu0c_BFu17ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu17ll(Test_Ul_BFu0c_BFu17ll, "Ul_BFu0c_BFu17ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu1c  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned char v2:1;
};
//SIG(1 Ul_BFu0c_BFu1c) C1{ FL Fc:0 Fc:1}



static void Test_Ul_BFu0c_BFu1c()
{
  {
    init_simple_test("Ul_BFu0c_BFu1c");
    static Ul_BFu0c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0c_BFu1c");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu1c(Test_Ul_BFu0c_BFu1c, "Ul_BFu0c_BFu1c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu1i  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned int v2:1;
};
//SIG(1 Ul_BFu0c_BFu1i) C1{ FL Fc:0 Fi:1}



static void Test_Ul_BFu0c_BFu1i()
{
  {
    init_simple_test("Ul_BFu0c_BFu1i");
    static Ul_BFu0c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0c_BFu1i");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu1i(Test_Ul_BFu0c_BFu1i, "Ul_BFu0c_BFu1i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu1ll  {
  __tsu64 v1;
  unsigned char  :0;
  __tsu64 v2:1;
};
//SIG(1 Ul_BFu0c_BFu1ll) C1{ FL Fc:0 FL:1}



static void Test_Ul_BFu0c_BFu1ll()
{
  {
    init_simple_test("Ul_BFu0c_BFu1ll");
    static Ul_BFu0c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0c_BFu1ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu1ll(Test_Ul_BFu0c_BFu1ll, "Ul_BFu0c_BFu1ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu1s  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned short v2:1;
};
//SIG(1 Ul_BFu0c_BFu1s) C1{ FL Fc:0 Fs:1}



static void Test_Ul_BFu0c_BFu1s()
{
  {
    init_simple_test("Ul_BFu0c_BFu1s");
    static Ul_BFu0c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0c_BFu1s");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu1s(Test_Ul_BFu0c_BFu1s, "Ul_BFu0c_BFu1s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu31i  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned int v2:31;
};
//SIG(1 Ul_BFu0c_BFu31i) C1{ FL Fc:0 Fi:31}



static void Test_Ul_BFu0c_BFu31i()
{
  {
    init_simple_test("Ul_BFu0c_BFu31i");
    static Ul_BFu0c_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu0c_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu0c_BFu31i");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu31i(Test_Ul_BFu0c_BFu31i, "Ul_BFu0c_BFu31i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu31ll  {
  __tsu64 v1;
  unsigned char  :0;
  __tsu64 v2:31;
};
//SIG(1 Ul_BFu0c_BFu31ll) C1{ FL Fc:0 FL:31}



static void Test_Ul_BFu0c_BFu31ll()
{
  {
    init_simple_test("Ul_BFu0c_BFu31ll");
    static Ul_BFu0c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu0c_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu0c_BFu31ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu31ll(Test_Ul_BFu0c_BFu31ll, "Ul_BFu0c_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu32i  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned int v2:32;
};
//SIG(1 Ul_BFu0c_BFu32i) C1{ FL Fc:0 Fi:32}



static void Test_Ul_BFu0c_BFu32i()
{
  {
    init_simple_test("Ul_BFu0c_BFu32i");
    static Ul_BFu0c_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu0c_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu0c_BFu32i");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu32i(Test_Ul_BFu0c_BFu32i, "Ul_BFu0c_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu32ll  {
  __tsu64 v1;
  unsigned char  :0;
  __tsu64 v2:32;
};
//SIG(1 Ul_BFu0c_BFu32ll) C1{ FL Fc:0 FL:32}



static void Test_Ul_BFu0c_BFu32ll()
{
  {
    init_simple_test("Ul_BFu0c_BFu32ll");
    static Ul_BFu0c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu0c_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu0c_BFu32ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu32ll(Test_Ul_BFu0c_BFu32ll, "Ul_BFu0c_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu33  {
  __tsu64 v1;
  unsigned char  :0;
  __tsu64 v2:33;
};
//SIG(1 Ul_BFu0c_BFu33) C1{ FL Fc:0 FL:33}



static void Test_Ul_BFu0c_BFu33()
{
  {
    init_simple_test("Ul_BFu0c_BFu33");
    static Ul_BFu0c_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu0c_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu0c_BFu33");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu33(Test_Ul_BFu0c_BFu33, "Ul_BFu0c_BFu33", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu7c  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned char v2:7;
};
//SIG(1 Ul_BFu0c_BFu7c) C1{ FL Fc:0 Fc:7}



static void Test_Ul_BFu0c_BFu7c()
{
  {
    init_simple_test("Ul_BFu0c_BFu7c");
    static Ul_BFu0c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0c_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0c_BFu7c");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu7c(Test_Ul_BFu0c_BFu7c, "Ul_BFu0c_BFu7c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu7i  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned int v2:7;
};
//SIG(1 Ul_BFu0c_BFu7i) C1{ FL Fc:0 Fi:7}



static void Test_Ul_BFu0c_BFu7i()
{
  {
    init_simple_test("Ul_BFu0c_BFu7i");
    static Ul_BFu0c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0c_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0c_BFu7i");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu7i(Test_Ul_BFu0c_BFu7i, "Ul_BFu0c_BFu7i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu7ll  {
  __tsu64 v1;
  unsigned char  :0;
  __tsu64 v2:7;
};
//SIG(1 Ul_BFu0c_BFu7ll) C1{ FL Fc:0 FL:7}



static void Test_Ul_BFu0c_BFu7ll()
{
  {
    init_simple_test("Ul_BFu0c_BFu7ll");
    static Ul_BFu0c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0c_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0c_BFu7ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu7ll(Test_Ul_BFu0c_BFu7ll, "Ul_BFu0c_BFu7ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu7s  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned short v2:7;
};
//SIG(1 Ul_BFu0c_BFu7s) C1{ FL Fc:0 Fs:7}



static void Test_Ul_BFu0c_BFu7s()
{
  {
    init_simple_test("Ul_BFu0c_BFu7s");
    static Ul_BFu0c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0c_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0c_BFu7s");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu7s(Test_Ul_BFu0c_BFu7s, "Ul_BFu0c_BFu7s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu8c  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned char v2:8;
};
//SIG(1 Ul_BFu0c_BFu8c) C1{ FL Fc:0 Fc:8}



static void Test_Ul_BFu0c_BFu8c()
{
  {
    init_simple_test("Ul_BFu0c_BFu8c");
    static Ul_BFu0c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0c_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0c_BFu8c");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu8c(Test_Ul_BFu0c_BFu8c, "Ul_BFu0c_BFu8c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu8i  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned int v2:8;
};
//SIG(1 Ul_BFu0c_BFu8i) C1{ FL Fc:0 Fi:8}



static void Test_Ul_BFu0c_BFu8i()
{
  {
    init_simple_test("Ul_BFu0c_BFu8i");
    static Ul_BFu0c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0c_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0c_BFu8i");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu8i(Test_Ul_BFu0c_BFu8i, "Ul_BFu0c_BFu8i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu8ll  {
  __tsu64 v1;
  unsigned char  :0;
  __tsu64 v2:8;
};
//SIG(1 Ul_BFu0c_BFu8ll) C1{ FL Fc:0 FL:8}



static void Test_Ul_BFu0c_BFu8ll()
{
  {
    init_simple_test("Ul_BFu0c_BFu8ll");
    static Ul_BFu0c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0c_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0c_BFu8ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu8ll(Test_Ul_BFu0c_BFu8ll, "Ul_BFu0c_BFu8ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu8s  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned short v2:8;
};
//SIG(1 Ul_BFu0c_BFu8s) C1{ FL Fc:0 Fs:8}



static void Test_Ul_BFu0c_BFu8s()
{
  {
    init_simple_test("Ul_BFu0c_BFu8s");
    static Ul_BFu0c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0c_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0c_BFu8s");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu8s(Test_Ul_BFu0c_BFu8s, "Ul_BFu0c_BFu8s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu9i  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned int v2:9;
};
//SIG(1 Ul_BFu0c_BFu9i) C1{ FL Fc:0 Fi:9}



static void Test_Ul_BFu0c_BFu9i()
{
  {
    init_simple_test("Ul_BFu0c_BFu9i");
    static Ul_BFu0c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu0c_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu0c_BFu9i");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu9i(Test_Ul_BFu0c_BFu9i, "Ul_BFu0c_BFu9i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu9ll  {
  __tsu64 v1;
  unsigned char  :0;
  __tsu64 v2:9;
};
//SIG(1 Ul_BFu0c_BFu9ll) C1{ FL Fc:0 FL:9}



static void Test_Ul_BFu0c_BFu9ll()
{
  {
    init_simple_test("Ul_BFu0c_BFu9ll");
    static Ul_BFu0c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu0c_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu0c_BFu9ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu9ll(Test_Ul_BFu0c_BFu9ll, "Ul_BFu0c_BFu9ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_BFu9s  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned short v2:9;
};
//SIG(1 Ul_BFu0c_BFu9s) C1{ FL Fc:0 Fs:9}



static void Test_Ul_BFu0c_BFu9s()
{
  {
    init_simple_test("Ul_BFu0c_BFu9s");
    static Ul_BFu0c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu0c_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu0c_BFu9s");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_BFu9s(Test_Ul_BFu0c_BFu9s, "Ul_BFu0c_BFu9s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_C  {
  __tsu64 v1;
  unsigned char  :0;
  char v2;
};
//SIG(1 Ul_BFu0c_C) C1{ FL Fc:0 Fc}



static void Test_Ul_BFu0c_C()
{
  {
    init_simple_test("Ul_BFu0c_C");
    static Ul_BFu0c_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_C.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0c_C.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_C(Test_Ul_BFu0c_C, "Ul_BFu0c_C", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_D  {
  __tsu64 v1;
  unsigned char  :0;
  double v2;
};
//SIG(1 Ul_BFu0c_D) C1{ FL Fc:0 FL}



static void Test_Ul_BFu0c_D()
{
  {
    init_simple_test("Ul_BFu0c_D");
    static Ul_BFu0c_D lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_D.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0c_D.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_D(Test_Ul_BFu0c_D, "Ul_BFu0c_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_F  {
  __tsu64 v1;
  unsigned char  :0;
  float v2;
};
//SIG(1 Ul_BFu0c_F) C1{ FL Fc:0 Fi}



static void Test_Ul_BFu0c_F()
{
  {
    init_simple_test("Ul_BFu0c_F");
    static Ul_BFu0c_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_F.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0c_F.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_F(Test_Ul_BFu0c_F, "Ul_BFu0c_F", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_I  {
  __tsu64 v1;
  unsigned char  :0;
  int v2;
};
//SIG(1 Ul_BFu0c_I) C1{ FL Fc:0 Fi}



static void Test_Ul_BFu0c_I()
{
  {
    init_simple_test("Ul_BFu0c_I");
    static Ul_BFu0c_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_I.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0c_I.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_I(Test_Ul_BFu0c_I, "Ul_BFu0c_I", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_Ip  {
  __tsu64 v1;
  unsigned char  :0;
  int *v2;
};
//SIG(1 Ul_BFu0c_Ip) C1{ FL Fc:0 Fp}



static void Test_Ul_BFu0c_Ip()
{
  {
    init_simple_test("Ul_BFu0c_Ip");
    static Ul_BFu0c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0c_Ip.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_Ip(Test_Ul_BFu0c_Ip, "Ul_BFu0c_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_L  {
  __tsu64 v1;
  unsigned char  :0;
  __tsi64 v2;
};
//SIG(1 Ul_BFu0c_L) C1{ FL Fc:0 FL}



static void Test_Ul_BFu0c_L()
{
  {
    init_simple_test("Ul_BFu0c_L");
    static Ul_BFu0c_L lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_L.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0c_L.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_L(Test_Ul_BFu0c_L, "Ul_BFu0c_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_S  {
  __tsu64 v1;
  unsigned char  :0;
  short v2;
};
//SIG(1 Ul_BFu0c_S) C1{ FL Fc:0 Fs}



static void Test_Ul_BFu0c_S()
{
  {
    init_simple_test("Ul_BFu0c_S");
    static Ul_BFu0c_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_S.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0c_S.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_S(Test_Ul_BFu0c_S, "Ul_BFu0c_S", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_Uc  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned char v2;
};
//SIG(1 Ul_BFu0c_Uc) C1{ FL Fc:0 Fc}



static void Test_Ul_BFu0c_Uc()
{
  {
    init_simple_test("Ul_BFu0c_Uc");
    static Ul_BFu0c_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0c_Uc.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_Uc(Test_Ul_BFu0c_Uc, "Ul_BFu0c_Uc", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_Ui  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned int v2;
};
//SIG(1 Ul_BFu0c_Ui) C1{ FL Fc:0 Fi}



static void Test_Ul_BFu0c_Ui()
{
  {
    init_simple_test("Ul_BFu0c_Ui");
    static Ul_BFu0c_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0c_Ui.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_Ui(Test_Ul_BFu0c_Ui, "Ul_BFu0c_Ui", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_Ul  {
  __tsu64 v1;
  unsigned char  :0;
  __tsu64 v2;
};
//SIG(1 Ul_BFu0c_Ul) C1{ FL Fc:0 FL}



static void Test_Ul_BFu0c_Ul()
{
  {
    init_simple_test("Ul_BFu0c_Ul");
    static Ul_BFu0c_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0c_Ul.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_Ul(Test_Ul_BFu0c_Ul, "Ul_BFu0c_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_Us  {
  __tsu64 v1;
  unsigned char  :0;
  unsigned short v2;
};
//SIG(1 Ul_BFu0c_Us) C1{ FL Fc:0 Fs}



static void Test_Ul_BFu0c_Us()
{
  {
    init_simple_test("Ul_BFu0c_Us");
    static Ul_BFu0c_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0c_Us.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_Us(Test_Ul_BFu0c_Us, "Ul_BFu0c_Us", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0c_Vp  {
  __tsu64 v1;
  unsigned char  :0;
  void *v2;
};
//SIG(1 Ul_BFu0c_Vp) C1{ FL Fc:0 Fp}



static void Test_Ul_BFu0c_Vp()
{
  {
    init_simple_test("Ul_BFu0c_Vp");
    static Ul_BFu0c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0c_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu0c_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0c_Vp.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0c_Vp(Test_Ul_BFu0c_Vp, "Ul_BFu0c_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i  {
  __tsu64 v1;
  unsigned int  :0;
};
//SIG(1 Ul_BFu0i) C1{ FL Fi:0}



static void Test_Ul_BFu0i()
{
  {
    init_simple_test("Ul_BFu0i");
    static Ul_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0i(Test_Ul_BFu0i, "Ul_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu0c  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned char  :0;
};
//SIG(1 Ul_BFu0i_BFu0c) C1{ FL Fi:0 Fc:0}



static void Test_Ul_BFu0i_BFu0c()
{
  {
    init_simple_test("Ul_BFu0i_BFu0c");
    static Ul_BFu0i_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu0c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu0c(Test_Ul_BFu0i_BFu0c, "Ul_BFu0i_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu0i  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned int  :0;
};
//SIG(1 Ul_BFu0i_BFu0i) C1{ FL Fi:0 Fi:0}



static void Test_Ul_BFu0i_BFu0i()
{
  {
    init_simple_test("Ul_BFu0i_BFu0i");
    static Ul_BFu0i_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu0i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu0i(Test_Ul_BFu0i_BFu0i, "Ul_BFu0i_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu0ll  {
  __tsu64 v1;
  unsigned int  :0;
  __tsu64  :0;
};
//SIG(1 Ul_BFu0i_BFu0ll) C1{ FL Fi:0 FL:0}



static void Test_Ul_BFu0i_BFu0ll()
{
  {
    init_simple_test("Ul_BFu0i_BFu0ll");
    static Ul_BFu0i_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu0ll(Test_Ul_BFu0i_BFu0ll, "Ul_BFu0i_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu0s  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned short  :0;
};
//SIG(1 Ul_BFu0i_BFu0s) C1{ FL Fi:0 Fs:0}



static void Test_Ul_BFu0i_BFu0s()
{
  {
    init_simple_test("Ul_BFu0i_BFu0s");
    static Ul_BFu0i_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu0s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu0s(Test_Ul_BFu0i_BFu0s, "Ul_BFu0i_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu15i  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned int v2:15;
};
//SIG(1 Ul_BFu0i_BFu15i) C1{ FL Fi:0 Fi:15}



static void Test_Ul_BFu0i_BFu15i()
{
  {
    init_simple_test("Ul_BFu0i_BFu15i");
    static Ul_BFu0i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu0i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu0i_BFu15i");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu15i(Test_Ul_BFu0i_BFu15i, "Ul_BFu0i_BFu15i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu15ll  {
  __tsu64 v1;
  unsigned int  :0;
  __tsu64 v2:15;
};
//SIG(1 Ul_BFu0i_BFu15ll) C1{ FL Fi:0 FL:15}



static void Test_Ul_BFu0i_BFu15ll()
{
  {
    init_simple_test("Ul_BFu0i_BFu15ll");
    static Ul_BFu0i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu0i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu0i_BFu15ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu15ll(Test_Ul_BFu0i_BFu15ll, "Ul_BFu0i_BFu15ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu15s  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned short v2:15;
};
//SIG(1 Ul_BFu0i_BFu15s) C1{ FL Fi:0 Fs:15}



static void Test_Ul_BFu0i_BFu15s()
{
  {
    init_simple_test("Ul_BFu0i_BFu15s");
    static Ul_BFu0i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu0i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu0i_BFu15s");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu15s(Test_Ul_BFu0i_BFu15s, "Ul_BFu0i_BFu15s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu16i  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned int v2:16;
};
//SIG(1 Ul_BFu0i_BFu16i) C1{ FL Fi:0 Fi:16}



static void Test_Ul_BFu0i_BFu16i()
{
  {
    init_simple_test("Ul_BFu0i_BFu16i");
    static Ul_BFu0i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu0i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu0i_BFu16i");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu16i(Test_Ul_BFu0i_BFu16i, "Ul_BFu0i_BFu16i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu16ll  {
  __tsu64 v1;
  unsigned int  :0;
  __tsu64 v2:16;
};
//SIG(1 Ul_BFu0i_BFu16ll) C1{ FL Fi:0 FL:16}



static void Test_Ul_BFu0i_BFu16ll()
{
  {
    init_simple_test("Ul_BFu0i_BFu16ll");
    static Ul_BFu0i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu0i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu0i_BFu16ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu16ll(Test_Ul_BFu0i_BFu16ll, "Ul_BFu0i_BFu16ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu16s  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned short v2:16;
};
//SIG(1 Ul_BFu0i_BFu16s) C1{ FL Fi:0 Fs:16}



static void Test_Ul_BFu0i_BFu16s()
{
  {
    init_simple_test("Ul_BFu0i_BFu16s");
    static Ul_BFu0i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu0i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu0i_BFu16s");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu16s(Test_Ul_BFu0i_BFu16s, "Ul_BFu0i_BFu16s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu17i  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned int v2:17;
};
//SIG(1 Ul_BFu0i_BFu17i) C1{ FL Fi:0 Fi:17}



static void Test_Ul_BFu0i_BFu17i()
{
  {
    init_simple_test("Ul_BFu0i_BFu17i");
    static Ul_BFu0i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu0i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu0i_BFu17i");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu17i(Test_Ul_BFu0i_BFu17i, "Ul_BFu0i_BFu17i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu17ll  {
  __tsu64 v1;
  unsigned int  :0;
  __tsu64 v2:17;
};
//SIG(1 Ul_BFu0i_BFu17ll) C1{ FL Fi:0 FL:17}



static void Test_Ul_BFu0i_BFu17ll()
{
  {
    init_simple_test("Ul_BFu0i_BFu17ll");
    static Ul_BFu0i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu0i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu0i_BFu17ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu17ll(Test_Ul_BFu0i_BFu17ll, "Ul_BFu0i_BFu17ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu1c  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned char v2:1;
};
//SIG(1 Ul_BFu0i_BFu1c) C1{ FL Fi:0 Fc:1}



static void Test_Ul_BFu0i_BFu1c()
{
  {
    init_simple_test("Ul_BFu0i_BFu1c");
    static Ul_BFu0i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0i_BFu1c");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu1c(Test_Ul_BFu0i_BFu1c, "Ul_BFu0i_BFu1c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu1i  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned int v2:1;
};
//SIG(1 Ul_BFu0i_BFu1i) C1{ FL Fi:0 Fi:1}



static void Test_Ul_BFu0i_BFu1i()
{
  {
    init_simple_test("Ul_BFu0i_BFu1i");
    static Ul_BFu0i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0i_BFu1i");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu1i(Test_Ul_BFu0i_BFu1i, "Ul_BFu0i_BFu1i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu1ll  {
  __tsu64 v1;
  unsigned int  :0;
  __tsu64 v2:1;
};
//SIG(1 Ul_BFu0i_BFu1ll) C1{ FL Fi:0 FL:1}



static void Test_Ul_BFu0i_BFu1ll()
{
  {
    init_simple_test("Ul_BFu0i_BFu1ll");
    static Ul_BFu0i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0i_BFu1ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu1ll(Test_Ul_BFu0i_BFu1ll, "Ul_BFu0i_BFu1ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu1s  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned short v2:1;
};
//SIG(1 Ul_BFu0i_BFu1s) C1{ FL Fi:0 Fs:1}



static void Test_Ul_BFu0i_BFu1s()
{
  {
    init_simple_test("Ul_BFu0i_BFu1s");
    static Ul_BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0i_BFu1s");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu1s(Test_Ul_BFu0i_BFu1s, "Ul_BFu0i_BFu1s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu31i  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned int v2:31;
};
//SIG(1 Ul_BFu0i_BFu31i) C1{ FL Fi:0 Fi:31}



static void Test_Ul_BFu0i_BFu31i()
{
  {
    init_simple_test("Ul_BFu0i_BFu31i");
    static Ul_BFu0i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu0i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu0i_BFu31i");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu31i(Test_Ul_BFu0i_BFu31i, "Ul_BFu0i_BFu31i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu31ll  {
  __tsu64 v1;
  unsigned int  :0;
  __tsu64 v2:31;
};
//SIG(1 Ul_BFu0i_BFu31ll) C1{ FL Fi:0 FL:31}



static void Test_Ul_BFu0i_BFu31ll()
{
  {
    init_simple_test("Ul_BFu0i_BFu31ll");
    static Ul_BFu0i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu0i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu0i_BFu31ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu31ll(Test_Ul_BFu0i_BFu31ll, "Ul_BFu0i_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu32i  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned int v2:32;
};
//SIG(1 Ul_BFu0i_BFu32i) C1{ FL Fi:0 Fi:32}



static void Test_Ul_BFu0i_BFu32i()
{
  {
    init_simple_test("Ul_BFu0i_BFu32i");
    static Ul_BFu0i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu0i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu0i_BFu32i");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu32i(Test_Ul_BFu0i_BFu32i, "Ul_BFu0i_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu32ll  {
  __tsu64 v1;
  unsigned int  :0;
  __tsu64 v2:32;
};
//SIG(1 Ul_BFu0i_BFu32ll) C1{ FL Fi:0 FL:32}



static void Test_Ul_BFu0i_BFu32ll()
{
  {
    init_simple_test("Ul_BFu0i_BFu32ll");
    static Ul_BFu0i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu0i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu0i_BFu32ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu32ll(Test_Ul_BFu0i_BFu32ll, "Ul_BFu0i_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu33  {
  __tsu64 v1;
  unsigned int  :0;
  __tsu64 v2:33;
};
//SIG(1 Ul_BFu0i_BFu33) C1{ FL Fi:0 FL:33}



static void Test_Ul_BFu0i_BFu33()
{
  {
    init_simple_test("Ul_BFu0i_BFu33");
    static Ul_BFu0i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu0i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu0i_BFu33");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu33(Test_Ul_BFu0i_BFu33, "Ul_BFu0i_BFu33", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu7c  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned char v2:7;
};
//SIG(1 Ul_BFu0i_BFu7c) C1{ FL Fi:0 Fc:7}



static void Test_Ul_BFu0i_BFu7c()
{
  {
    init_simple_test("Ul_BFu0i_BFu7c");
    static Ul_BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0i_BFu7c");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu7c(Test_Ul_BFu0i_BFu7c, "Ul_BFu0i_BFu7c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu7i  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned int v2:7;
};
//SIG(1 Ul_BFu0i_BFu7i) C1{ FL Fi:0 Fi:7}



static void Test_Ul_BFu0i_BFu7i()
{
  {
    init_simple_test("Ul_BFu0i_BFu7i");
    static Ul_BFu0i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0i_BFu7i");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu7i(Test_Ul_BFu0i_BFu7i, "Ul_BFu0i_BFu7i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu7ll  {
  __tsu64 v1;
  unsigned int  :0;
  __tsu64 v2:7;
};
//SIG(1 Ul_BFu0i_BFu7ll) C1{ FL Fi:0 FL:7}



static void Test_Ul_BFu0i_BFu7ll()
{
  {
    init_simple_test("Ul_BFu0i_BFu7ll");
    static Ul_BFu0i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0i_BFu7ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu7ll(Test_Ul_BFu0i_BFu7ll, "Ul_BFu0i_BFu7ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu7s  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned short v2:7;
};
//SIG(1 Ul_BFu0i_BFu7s) C1{ FL Fi:0 Fs:7}



static void Test_Ul_BFu0i_BFu7s()
{
  {
    init_simple_test("Ul_BFu0i_BFu7s");
    static Ul_BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0i_BFu7s");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu7s(Test_Ul_BFu0i_BFu7s, "Ul_BFu0i_BFu7s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu8c  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned char v2:8;
};
//SIG(1 Ul_BFu0i_BFu8c) C1{ FL Fi:0 Fc:8}



static void Test_Ul_BFu0i_BFu8c()
{
  {
    init_simple_test("Ul_BFu0i_BFu8c");
    static Ul_BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0i_BFu8c");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu8c(Test_Ul_BFu0i_BFu8c, "Ul_BFu0i_BFu8c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu8i  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned int v2:8;
};
//SIG(1 Ul_BFu0i_BFu8i) C1{ FL Fi:0 Fi:8}



static void Test_Ul_BFu0i_BFu8i()
{
  {
    init_simple_test("Ul_BFu0i_BFu8i");
    static Ul_BFu0i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0i_BFu8i");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu8i(Test_Ul_BFu0i_BFu8i, "Ul_BFu0i_BFu8i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu8ll  {
  __tsu64 v1;
  unsigned int  :0;
  __tsu64 v2:8;
};
//SIG(1 Ul_BFu0i_BFu8ll) C1{ FL Fi:0 FL:8}



static void Test_Ul_BFu0i_BFu8ll()
{
  {
    init_simple_test("Ul_BFu0i_BFu8ll");
    static Ul_BFu0i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0i_BFu8ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu8ll(Test_Ul_BFu0i_BFu8ll, "Ul_BFu0i_BFu8ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu8s  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned short v2:8;
};
//SIG(1 Ul_BFu0i_BFu8s) C1{ FL Fi:0 Fs:8}



static void Test_Ul_BFu0i_BFu8s()
{
  {
    init_simple_test("Ul_BFu0i_BFu8s");
    static Ul_BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0i_BFu8s");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu8s(Test_Ul_BFu0i_BFu8s, "Ul_BFu0i_BFu8s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu9i  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned int v2:9;
};
//SIG(1 Ul_BFu0i_BFu9i) C1{ FL Fi:0 Fi:9}



static void Test_Ul_BFu0i_BFu9i()
{
  {
    init_simple_test("Ul_BFu0i_BFu9i");
    static Ul_BFu0i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu0i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu0i_BFu9i");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu9i(Test_Ul_BFu0i_BFu9i, "Ul_BFu0i_BFu9i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu9ll  {
  __tsu64 v1;
  unsigned int  :0;
  __tsu64 v2:9;
};
//SIG(1 Ul_BFu0i_BFu9ll) C1{ FL Fi:0 FL:9}



static void Test_Ul_BFu0i_BFu9ll()
{
  {
    init_simple_test("Ul_BFu0i_BFu9ll");
    static Ul_BFu0i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu0i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu0i_BFu9ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu9ll(Test_Ul_BFu0i_BFu9ll, "Ul_BFu0i_BFu9ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_BFu9s  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned short v2:9;
};
//SIG(1 Ul_BFu0i_BFu9s) C1{ FL Fi:0 Fs:9}



static void Test_Ul_BFu0i_BFu9s()
{
  {
    init_simple_test("Ul_BFu0i_BFu9s");
    static Ul_BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu0i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu0i_BFu9s");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_BFu9s(Test_Ul_BFu0i_BFu9s, "Ul_BFu0i_BFu9s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_C  {
  __tsu64 v1;
  unsigned int  :0;
  char v2;
};
//SIG(1 Ul_BFu0i_C) C1{ FL Fi:0 Fc}



static void Test_Ul_BFu0i_C()
{
  {
    init_simple_test("Ul_BFu0i_C");
    static Ul_BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_C.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0i_C.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_C(Test_Ul_BFu0i_C, "Ul_BFu0i_C", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_D  {
  __tsu64 v1;
  unsigned int  :0;
  double v2;
};
//SIG(1 Ul_BFu0i_D) C1{ FL Fi:0 FL}



static void Test_Ul_BFu0i_D()
{
  {
    init_simple_test("Ul_BFu0i_D");
    static Ul_BFu0i_D lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_D.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0i_D.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_D(Test_Ul_BFu0i_D, "Ul_BFu0i_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_F  {
  __tsu64 v1;
  unsigned int  :0;
  float v2;
};
//SIG(1 Ul_BFu0i_F) C1{ FL Fi:0 Fi}



static void Test_Ul_BFu0i_F()
{
  {
    init_simple_test("Ul_BFu0i_F");
    static Ul_BFu0i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_F.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0i_F.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_F(Test_Ul_BFu0i_F, "Ul_BFu0i_F", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_I  {
  __tsu64 v1;
  unsigned int  :0;
  int v2;
};
//SIG(1 Ul_BFu0i_I) C1{ FL Fi:0 Fi}



static void Test_Ul_BFu0i_I()
{
  {
    init_simple_test("Ul_BFu0i_I");
    static Ul_BFu0i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_I.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0i_I.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_I(Test_Ul_BFu0i_I, "Ul_BFu0i_I", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_Ip  {
  __tsu64 v1;
  unsigned int  :0;
  int *v2;
};
//SIG(1 Ul_BFu0i_Ip) C1{ FL Fi:0 Fp}



static void Test_Ul_BFu0i_Ip()
{
  {
    init_simple_test("Ul_BFu0i_Ip");
    static Ul_BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0i_Ip.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_Ip(Test_Ul_BFu0i_Ip, "Ul_BFu0i_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_L  {
  __tsu64 v1;
  unsigned int  :0;
  __tsi64 v2;
};
//SIG(1 Ul_BFu0i_L) C1{ FL Fi:0 FL}



static void Test_Ul_BFu0i_L()
{
  {
    init_simple_test("Ul_BFu0i_L");
    static Ul_BFu0i_L lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_L.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0i_L.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_L(Test_Ul_BFu0i_L, "Ul_BFu0i_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_S  {
  __tsu64 v1;
  unsigned int  :0;
  short v2;
};
//SIG(1 Ul_BFu0i_S) C1{ FL Fi:0 Fs}



static void Test_Ul_BFu0i_S()
{
  {
    init_simple_test("Ul_BFu0i_S");
    static Ul_BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_S.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0i_S.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_S(Test_Ul_BFu0i_S, "Ul_BFu0i_S", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_Uc  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned char v2;
};
//SIG(1 Ul_BFu0i_Uc) C1{ FL Fi:0 Fc}



static void Test_Ul_BFu0i_Uc()
{
  {
    init_simple_test("Ul_BFu0i_Uc");
    static Ul_BFu0i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0i_Uc.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_Uc(Test_Ul_BFu0i_Uc, "Ul_BFu0i_Uc", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_Ui  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned int v2;
};
//SIG(1 Ul_BFu0i_Ui) C1{ FL Fi:0 Fi}



static void Test_Ul_BFu0i_Ui()
{
  {
    init_simple_test("Ul_BFu0i_Ui");
    static Ul_BFu0i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0i_Ui.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_Ui(Test_Ul_BFu0i_Ui, "Ul_BFu0i_Ui", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_Ul  {
  __tsu64 v1;
  unsigned int  :0;
  __tsu64 v2;
};
//SIG(1 Ul_BFu0i_Ul) C1{ FL Fi:0 FL}



static void Test_Ul_BFu0i_Ul()
{
  {
    init_simple_test("Ul_BFu0i_Ul");
    static Ul_BFu0i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0i_Ul.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_Ul(Test_Ul_BFu0i_Ul, "Ul_BFu0i_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_Us  {
  __tsu64 v1;
  unsigned int  :0;
  unsigned short v2;
};
//SIG(1 Ul_BFu0i_Us) C1{ FL Fi:0 Fs}



static void Test_Ul_BFu0i_Us()
{
  {
    init_simple_test("Ul_BFu0i_Us");
    static Ul_BFu0i_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0i_Us.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_Us(Test_Ul_BFu0i_Us, "Ul_BFu0i_Us", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0i_Vp  {
  __tsu64 v1;
  unsigned int  :0;
  void *v2;
};
//SIG(1 Ul_BFu0i_Vp) C1{ FL Fi:0 Fp}



static void Test_Ul_BFu0i_Vp()
{
  {
    init_simple_test("Ul_BFu0i_Vp");
    static Ul_BFu0i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0i_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu0i_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0i_Vp.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0i_Vp(Test_Ul_BFu0i_Vp, "Ul_BFu0i_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll  {
  __tsu64 v1;
  __tsu64  :0;
};
//SIG(1 Ul_BFu0ll) C1{ FL FL:0}



static void Test_Ul_BFu0ll()
{
  {
    init_simple_test("Ul_BFu0ll");
    static Ul_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll(Test_Ul_BFu0ll, "Ul_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu0c  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned char  :0;
};
//SIG(1 Ul_BFu0ll_BFu0c) C1{ FL FL:0 Fc:0}



static void Test_Ul_BFu0ll_BFu0c()
{
  {
    init_simple_test("Ul_BFu0ll_BFu0c");
    static Ul_BFu0ll_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu0c(Test_Ul_BFu0ll_BFu0c, "Ul_BFu0ll_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu0i  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned int  :0;
};
//SIG(1 Ul_BFu0ll_BFu0i) C1{ FL FL:0 Fi:0}



static void Test_Ul_BFu0ll_BFu0i()
{
  {
    init_simple_test("Ul_BFu0ll_BFu0i");
    static Ul_BFu0ll_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu0i(Test_Ul_BFu0ll_BFu0i, "Ul_BFu0ll_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu0ll  {
  __tsu64 v1;
  __tsu64  :0;
  __tsu64  :0;
};
//SIG(1 Ul_BFu0ll_BFu0ll) C1{ FL FL:0 FL:0}



static void Test_Ul_BFu0ll_BFu0ll()
{
  {
    init_simple_test("Ul_BFu0ll_BFu0ll");
    static Ul_BFu0ll_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu0ll(Test_Ul_BFu0ll_BFu0ll, "Ul_BFu0ll_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu0s  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned short  :0;
};
//SIG(1 Ul_BFu0ll_BFu0s) C1{ FL FL:0 Fs:0}



static void Test_Ul_BFu0ll_BFu0s()
{
  {
    init_simple_test("Ul_BFu0ll_BFu0s");
    static Ul_BFu0ll_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu0s(Test_Ul_BFu0ll_BFu0s, "Ul_BFu0ll_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu15i  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned int v2:15;
};
//SIG(1 Ul_BFu0ll_BFu15i) C1{ FL FL:0 Fi:15}



static void Test_Ul_BFu0ll_BFu15i()
{
  {
    init_simple_test("Ul_BFu0ll_BFu15i");
    static Ul_BFu0ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu0ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu0ll_BFu15i");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu15i(Test_Ul_BFu0ll_BFu15i, "Ul_BFu0ll_BFu15i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu15ll  {
  __tsu64 v1;
  __tsu64  :0;
  __tsu64 v2:15;
};
//SIG(1 Ul_BFu0ll_BFu15ll) C1{ FL FL:0 FL:15}



static void Test_Ul_BFu0ll_BFu15ll()
{
  {
    init_simple_test("Ul_BFu0ll_BFu15ll");
    static Ul_BFu0ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu0ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu0ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu15ll(Test_Ul_BFu0ll_BFu15ll, "Ul_BFu0ll_BFu15ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu15s  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned short v2:15;
};
//SIG(1 Ul_BFu0ll_BFu15s) C1{ FL FL:0 Fs:15}



static void Test_Ul_BFu0ll_BFu15s()
{
  {
    init_simple_test("Ul_BFu0ll_BFu15s");
    static Ul_BFu0ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu0ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu0ll_BFu15s");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu15s(Test_Ul_BFu0ll_BFu15s, "Ul_BFu0ll_BFu15s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu16i  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned int v2:16;
};
//SIG(1 Ul_BFu0ll_BFu16i) C1{ FL FL:0 Fi:16}



static void Test_Ul_BFu0ll_BFu16i()
{
  {
    init_simple_test("Ul_BFu0ll_BFu16i");
    static Ul_BFu0ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu0ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu0ll_BFu16i");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu16i(Test_Ul_BFu0ll_BFu16i, "Ul_BFu0ll_BFu16i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu16ll  {
  __tsu64 v1;
  __tsu64  :0;
  __tsu64 v2:16;
};
//SIG(1 Ul_BFu0ll_BFu16ll) C1{ FL FL:0 FL:16}



static void Test_Ul_BFu0ll_BFu16ll()
{
  {
    init_simple_test("Ul_BFu0ll_BFu16ll");
    static Ul_BFu0ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu0ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu0ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu16ll(Test_Ul_BFu0ll_BFu16ll, "Ul_BFu0ll_BFu16ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu16s  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned short v2:16;
};
//SIG(1 Ul_BFu0ll_BFu16s) C1{ FL FL:0 Fs:16}



static void Test_Ul_BFu0ll_BFu16s()
{
  {
    init_simple_test("Ul_BFu0ll_BFu16s");
    static Ul_BFu0ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu0ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu0ll_BFu16s");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu16s(Test_Ul_BFu0ll_BFu16s, "Ul_BFu0ll_BFu16s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu17i  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned int v2:17;
};
//SIG(1 Ul_BFu0ll_BFu17i) C1{ FL FL:0 Fi:17}



static void Test_Ul_BFu0ll_BFu17i()
{
  {
    init_simple_test("Ul_BFu0ll_BFu17i");
    static Ul_BFu0ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu0ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu0ll_BFu17i");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu17i(Test_Ul_BFu0ll_BFu17i, "Ul_BFu0ll_BFu17i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu17ll  {
  __tsu64 v1;
  __tsu64  :0;
  __tsu64 v2:17;
};
//SIG(1 Ul_BFu0ll_BFu17ll) C1{ FL FL:0 FL:17}



static void Test_Ul_BFu0ll_BFu17ll()
{
  {
    init_simple_test("Ul_BFu0ll_BFu17ll");
    static Ul_BFu0ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu0ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu0ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu17ll(Test_Ul_BFu0ll_BFu17ll, "Ul_BFu0ll_BFu17ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu1c  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned char v2:1;
};
//SIG(1 Ul_BFu0ll_BFu1c) C1{ FL FL:0 Fc:1}



static void Test_Ul_BFu0ll_BFu1c()
{
  {
    init_simple_test("Ul_BFu0ll_BFu1c");
    static Ul_BFu0ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0ll_BFu1c");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu1c(Test_Ul_BFu0ll_BFu1c, "Ul_BFu0ll_BFu1c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu1i  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned int v2:1;
};
//SIG(1 Ul_BFu0ll_BFu1i) C1{ FL FL:0 Fi:1}



static void Test_Ul_BFu0ll_BFu1i()
{
  {
    init_simple_test("Ul_BFu0ll_BFu1i");
    static Ul_BFu0ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0ll_BFu1i");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu1i(Test_Ul_BFu0ll_BFu1i, "Ul_BFu0ll_BFu1i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu1ll  {
  __tsu64 v1;
  __tsu64  :0;
  __tsu64 v2:1;
};
//SIG(1 Ul_BFu0ll_BFu1ll) C1{ FL FL:0 FL:1}



static void Test_Ul_BFu0ll_BFu1ll()
{
  {
    init_simple_test("Ul_BFu0ll_BFu1ll");
    static Ul_BFu0ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu1ll(Test_Ul_BFu0ll_BFu1ll, "Ul_BFu0ll_BFu1ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu1s  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned short v2:1;
};
//SIG(1 Ul_BFu0ll_BFu1s) C1{ FL FL:0 Fs:1}



static void Test_Ul_BFu0ll_BFu1s()
{
  {
    init_simple_test("Ul_BFu0ll_BFu1s");
    static Ul_BFu0ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0ll_BFu1s");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu1s(Test_Ul_BFu0ll_BFu1s, "Ul_BFu0ll_BFu1s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu31i  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned int v2:31;
};
//SIG(1 Ul_BFu0ll_BFu31i) C1{ FL FL:0 Fi:31}



static void Test_Ul_BFu0ll_BFu31i()
{
  {
    init_simple_test("Ul_BFu0ll_BFu31i");
    static Ul_BFu0ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu0ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu0ll_BFu31i");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu31i(Test_Ul_BFu0ll_BFu31i, "Ul_BFu0ll_BFu31i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu31ll  {
  __tsu64 v1;
  __tsu64  :0;
  __tsu64 v2:31;
};
//SIG(1 Ul_BFu0ll_BFu31ll) C1{ FL FL:0 FL:31}



static void Test_Ul_BFu0ll_BFu31ll()
{
  {
    init_simple_test("Ul_BFu0ll_BFu31ll");
    static Ul_BFu0ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu0ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu0ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu31ll(Test_Ul_BFu0ll_BFu31ll, "Ul_BFu0ll_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu32i  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned int v2:32;
};
//SIG(1 Ul_BFu0ll_BFu32i) C1{ FL FL:0 Fi:32}



static void Test_Ul_BFu0ll_BFu32i()
{
  {
    init_simple_test("Ul_BFu0ll_BFu32i");
    static Ul_BFu0ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu0ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu0ll_BFu32i");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu32i(Test_Ul_BFu0ll_BFu32i, "Ul_BFu0ll_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu32ll  {
  __tsu64 v1;
  __tsu64  :0;
  __tsu64 v2:32;
};
//SIG(1 Ul_BFu0ll_BFu32ll) C1{ FL FL:0 FL:32}



static void Test_Ul_BFu0ll_BFu32ll()
{
  {
    init_simple_test("Ul_BFu0ll_BFu32ll");
    static Ul_BFu0ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu0ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu0ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu32ll(Test_Ul_BFu0ll_BFu32ll, "Ul_BFu0ll_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu33  {
  __tsu64 v1;
  __tsu64  :0;
  __tsu64 v2:33;
};
//SIG(1 Ul_BFu0ll_BFu33) C1{ FL FL:0 FL:33}



static void Test_Ul_BFu0ll_BFu33()
{
  {
    init_simple_test("Ul_BFu0ll_BFu33");
    static Ul_BFu0ll_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu0ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu0ll_BFu33");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu33(Test_Ul_BFu0ll_BFu33, "Ul_BFu0ll_BFu33", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu7c  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned char v2:7;
};
//SIG(1 Ul_BFu0ll_BFu7c) C1{ FL FL:0 Fc:7}



static void Test_Ul_BFu0ll_BFu7c()
{
  {
    init_simple_test("Ul_BFu0ll_BFu7c");
    static Ul_BFu0ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0ll_BFu7c");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu7c(Test_Ul_BFu0ll_BFu7c, "Ul_BFu0ll_BFu7c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu7i  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned int v2:7;
};
//SIG(1 Ul_BFu0ll_BFu7i) C1{ FL FL:0 Fi:7}



static void Test_Ul_BFu0ll_BFu7i()
{
  {
    init_simple_test("Ul_BFu0ll_BFu7i");
    static Ul_BFu0ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0ll_BFu7i");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu7i(Test_Ul_BFu0ll_BFu7i, "Ul_BFu0ll_BFu7i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu7ll  {
  __tsu64 v1;
  __tsu64  :0;
  __tsu64 v2:7;
};
//SIG(1 Ul_BFu0ll_BFu7ll) C1{ FL FL:0 FL:7}



static void Test_Ul_BFu0ll_BFu7ll()
{
  {
    init_simple_test("Ul_BFu0ll_BFu7ll");
    static Ul_BFu0ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu7ll(Test_Ul_BFu0ll_BFu7ll, "Ul_BFu0ll_BFu7ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu7s  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned short v2:7;
};
//SIG(1 Ul_BFu0ll_BFu7s) C1{ FL FL:0 Fs:7}



static void Test_Ul_BFu0ll_BFu7s()
{
  {
    init_simple_test("Ul_BFu0ll_BFu7s");
    static Ul_BFu0ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0ll_BFu7s");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu7s(Test_Ul_BFu0ll_BFu7s, "Ul_BFu0ll_BFu7s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu8c  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned char v2:8;
};
//SIG(1 Ul_BFu0ll_BFu8c) C1{ FL FL:0 Fc:8}



static void Test_Ul_BFu0ll_BFu8c()
{
  {
    init_simple_test("Ul_BFu0ll_BFu8c");
    static Ul_BFu0ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0ll_BFu8c");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu8c(Test_Ul_BFu0ll_BFu8c, "Ul_BFu0ll_BFu8c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu8i  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned int v2:8;
};
//SIG(1 Ul_BFu0ll_BFu8i) C1{ FL FL:0 Fi:8}



static void Test_Ul_BFu0ll_BFu8i()
{
  {
    init_simple_test("Ul_BFu0ll_BFu8i");
    static Ul_BFu0ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0ll_BFu8i");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu8i(Test_Ul_BFu0ll_BFu8i, "Ul_BFu0ll_BFu8i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu8ll  {
  __tsu64 v1;
  __tsu64  :0;
  __tsu64 v2:8;
};
//SIG(1 Ul_BFu0ll_BFu8ll) C1{ FL FL:0 FL:8}



static void Test_Ul_BFu0ll_BFu8ll()
{
  {
    init_simple_test("Ul_BFu0ll_BFu8ll");
    static Ul_BFu0ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu8ll(Test_Ul_BFu0ll_BFu8ll, "Ul_BFu0ll_BFu8ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu8s  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned short v2:8;
};
//SIG(1 Ul_BFu0ll_BFu8s) C1{ FL FL:0 Fs:8}



static void Test_Ul_BFu0ll_BFu8s()
{
  {
    init_simple_test("Ul_BFu0ll_BFu8s");
    static Ul_BFu0ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0ll_BFu8s");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu8s(Test_Ul_BFu0ll_BFu8s, "Ul_BFu0ll_BFu8s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu9i  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned int v2:9;
};
//SIG(1 Ul_BFu0ll_BFu9i) C1{ FL FL:0 Fi:9}



static void Test_Ul_BFu0ll_BFu9i()
{
  {
    init_simple_test("Ul_BFu0ll_BFu9i");
    static Ul_BFu0ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu0ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu0ll_BFu9i");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu9i(Test_Ul_BFu0ll_BFu9i, "Ul_BFu0ll_BFu9i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu9ll  {
  __tsu64 v1;
  __tsu64  :0;
  __tsu64 v2:9;
};
//SIG(1 Ul_BFu0ll_BFu9ll) C1{ FL FL:0 FL:9}



static void Test_Ul_BFu0ll_BFu9ll()
{
  {
    init_simple_test("Ul_BFu0ll_BFu9ll");
    static Ul_BFu0ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu0ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu0ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu9ll(Test_Ul_BFu0ll_BFu9ll, "Ul_BFu0ll_BFu9ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_BFu9s  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned short v2:9;
};
//SIG(1 Ul_BFu0ll_BFu9s) C1{ FL FL:0 Fs:9}



static void Test_Ul_BFu0ll_BFu9s()
{
  {
    init_simple_test("Ul_BFu0ll_BFu9s");
    static Ul_BFu0ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu0ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu0ll_BFu9s");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_BFu9s(Test_Ul_BFu0ll_BFu9s, "Ul_BFu0ll_BFu9s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_C  {
  __tsu64 v1;
  __tsu64  :0;
  char v2;
};
//SIG(1 Ul_BFu0ll_C) C1{ FL FL:0 Fc}



static void Test_Ul_BFu0ll_C()
{
  {
    init_simple_test("Ul_BFu0ll_C");
    static Ul_BFu0ll_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_C.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0ll_C.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_C(Test_Ul_BFu0ll_C, "Ul_BFu0ll_C", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_D  {
  __tsu64 v1;
  __tsu64  :0;
  double v2;
};
//SIG(1 Ul_BFu0ll_D) C1{ FL FL:0 FL}



static void Test_Ul_BFu0ll_D()
{
  {
    init_simple_test("Ul_BFu0ll_D");
    static Ul_BFu0ll_D lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_D.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0ll_D.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_D(Test_Ul_BFu0ll_D, "Ul_BFu0ll_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_F  {
  __tsu64 v1;
  __tsu64  :0;
  float v2;
};
//SIG(1 Ul_BFu0ll_F) C1{ FL FL:0 Fi}



static void Test_Ul_BFu0ll_F()
{
  {
    init_simple_test("Ul_BFu0ll_F");
    static Ul_BFu0ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_F.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0ll_F.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_F(Test_Ul_BFu0ll_F, "Ul_BFu0ll_F", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_I  {
  __tsu64 v1;
  __tsu64  :0;
  int v2;
};
//SIG(1 Ul_BFu0ll_I) C1{ FL FL:0 Fi}



static void Test_Ul_BFu0ll_I()
{
  {
    init_simple_test("Ul_BFu0ll_I");
    static Ul_BFu0ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_I.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0ll_I.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_I(Test_Ul_BFu0ll_I, "Ul_BFu0ll_I", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_Ip  {
  __tsu64 v1;
  __tsu64  :0;
  int *v2;
};
//SIG(1 Ul_BFu0ll_Ip) C1{ FL FL:0 Fp}



static void Test_Ul_BFu0ll_Ip()
{
  {
    init_simple_test("Ul_BFu0ll_Ip");
    static Ul_BFu0ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_Ip(Test_Ul_BFu0ll_Ip, "Ul_BFu0ll_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_L  {
  __tsu64 v1;
  __tsu64  :0;
  __tsi64 v2;
};
//SIG(1 Ul_BFu0ll_L) C1{ FL FL:0 FL}



static void Test_Ul_BFu0ll_L()
{
  {
    init_simple_test("Ul_BFu0ll_L");
    static Ul_BFu0ll_L lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_L.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0ll_L.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_L(Test_Ul_BFu0ll_L, "Ul_BFu0ll_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_S  {
  __tsu64 v1;
  __tsu64  :0;
  short v2;
};
//SIG(1 Ul_BFu0ll_S) C1{ FL FL:0 Fs}



static void Test_Ul_BFu0ll_S()
{
  {
    init_simple_test("Ul_BFu0ll_S");
    static Ul_BFu0ll_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_S.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0ll_S.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_S(Test_Ul_BFu0ll_S, "Ul_BFu0ll_S", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_Uc  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned char v2;
};
//SIG(1 Ul_BFu0ll_Uc) C1{ FL FL:0 Fc}



static void Test_Ul_BFu0ll_Uc()
{
  {
    init_simple_test("Ul_BFu0ll_Uc");
    static Ul_BFu0ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_Uc(Test_Ul_BFu0ll_Uc, "Ul_BFu0ll_Uc", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_Ui  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned int v2;
};
//SIG(1 Ul_BFu0ll_Ui) C1{ FL FL:0 Fi}



static void Test_Ul_BFu0ll_Ui()
{
  {
    init_simple_test("Ul_BFu0ll_Ui");
    static Ul_BFu0ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_Ui(Test_Ul_BFu0ll_Ui, "Ul_BFu0ll_Ui", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_Ul  {
  __tsu64 v1;
  __tsu64  :0;
  __tsu64 v2;
};
//SIG(1 Ul_BFu0ll_Ul) C1{ FL FL:0 FL}



static void Test_Ul_BFu0ll_Ul()
{
  {
    init_simple_test("Ul_BFu0ll_Ul");
    static Ul_BFu0ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_Ul(Test_Ul_BFu0ll_Ul, "Ul_BFu0ll_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_Us  {
  __tsu64 v1;
  __tsu64  :0;
  unsigned short v2;
};
//SIG(1 Ul_BFu0ll_Us) C1{ FL FL:0 Fs}



static void Test_Ul_BFu0ll_Us()
{
  {
    init_simple_test("Ul_BFu0ll_Us");
    static Ul_BFu0ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0ll_Us.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_Us(Test_Ul_BFu0ll_Us, "Ul_BFu0ll_Us", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0ll_Vp  {
  __tsu64 v1;
  __tsu64  :0;
  void *v2;
};
//SIG(1 Ul_BFu0ll_Vp) C1{ FL FL:0 Fp}



static void Test_Ul_BFu0ll_Vp()
{
  {
    init_simple_test("Ul_BFu0ll_Vp");
    static Ul_BFu0ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0ll_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu0ll_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0ll_Vp(Test_Ul_BFu0ll_Vp, "Ul_BFu0ll_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s  {
  __tsu64 v1;
  unsigned short  :0;
};
//SIG(1 Ul_BFu0s) C1{ FL Fs:0}



static void Test_Ul_BFu0s()
{
  {
    init_simple_test("Ul_BFu0s");
    static Ul_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0s(Test_Ul_BFu0s, "Ul_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu0c  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned char  :0;
};
//SIG(1 Ul_BFu0s_BFu0c) C1{ FL Fs:0 Fc:0}



static void Test_Ul_BFu0s_BFu0c()
{
  {
    init_simple_test("Ul_BFu0s_BFu0c");
    static Ul_BFu0s_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu0c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu0c(Test_Ul_BFu0s_BFu0c, "Ul_BFu0s_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu0i  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned int  :0;
};
//SIG(1 Ul_BFu0s_BFu0i) C1{ FL Fs:0 Fi:0}



static void Test_Ul_BFu0s_BFu0i()
{
  {
    init_simple_test("Ul_BFu0s_BFu0i");
    static Ul_BFu0s_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu0i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu0i(Test_Ul_BFu0s_BFu0i, "Ul_BFu0s_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu0ll  {
  __tsu64 v1;
  unsigned short  :0;
  __tsu64  :0;
};
//SIG(1 Ul_BFu0s_BFu0ll) C1{ FL Fs:0 FL:0}



static void Test_Ul_BFu0s_BFu0ll()
{
  {
    init_simple_test("Ul_BFu0s_BFu0ll");
    static Ul_BFu0s_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu0ll(Test_Ul_BFu0s_BFu0ll, "Ul_BFu0s_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu0s  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned short  :0;
};
//SIG(1 Ul_BFu0s_BFu0s) C1{ FL Fs:0 Fs:0}



static void Test_Ul_BFu0s_BFu0s()
{
  {
    init_simple_test("Ul_BFu0s_BFu0s");
    static Ul_BFu0s_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(Ul_BFu0s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu0s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu0s(Test_Ul_BFu0s_BFu0s, "Ul_BFu0s_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu15i  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned int v2:15;
};
//SIG(1 Ul_BFu0s_BFu15i) C1{ FL Fs:0 Fi:15}



static void Test_Ul_BFu0s_BFu15i()
{
  {
    init_simple_test("Ul_BFu0s_BFu15i");
    static Ul_BFu0s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu0s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu0s_BFu15i");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu15i(Test_Ul_BFu0s_BFu15i, "Ul_BFu0s_BFu15i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu15ll  {
  __tsu64 v1;
  unsigned short  :0;
  __tsu64 v2:15;
};
//SIG(1 Ul_BFu0s_BFu15ll) C1{ FL Fs:0 FL:15}



static void Test_Ul_BFu0s_BFu15ll()
{
  {
    init_simple_test("Ul_BFu0s_BFu15ll");
    static Ul_BFu0s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu0s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu0s_BFu15ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu15ll(Test_Ul_BFu0s_BFu15ll, "Ul_BFu0s_BFu15ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu15s  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned short v2:15;
};
//SIG(1 Ul_BFu0s_BFu15s) C1{ FL Fs:0 Fs:15}



static void Test_Ul_BFu0s_BFu15s()
{
  {
    init_simple_test("Ul_BFu0s_BFu15s");
    static Ul_BFu0s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu0s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu0s_BFu15s");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu15s(Test_Ul_BFu0s_BFu15s, "Ul_BFu0s_BFu15s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu16i  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned int v2:16;
};
//SIG(1 Ul_BFu0s_BFu16i) C1{ FL Fs:0 Fi:16}



static void Test_Ul_BFu0s_BFu16i()
{
  {
    init_simple_test("Ul_BFu0s_BFu16i");
    static Ul_BFu0s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu0s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu0s_BFu16i");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu16i(Test_Ul_BFu0s_BFu16i, "Ul_BFu0s_BFu16i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu16ll  {
  __tsu64 v1;
  unsigned short  :0;
  __tsu64 v2:16;
};
//SIG(1 Ul_BFu0s_BFu16ll) C1{ FL Fs:0 FL:16}



static void Test_Ul_BFu0s_BFu16ll()
{
  {
    init_simple_test("Ul_BFu0s_BFu16ll");
    static Ul_BFu0s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu0s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu0s_BFu16ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu16ll(Test_Ul_BFu0s_BFu16ll, "Ul_BFu0s_BFu16ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu16s  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned short v2:16;
};
//SIG(1 Ul_BFu0s_BFu16s) C1{ FL Fs:0 Fs:16}



static void Test_Ul_BFu0s_BFu16s()
{
  {
    init_simple_test("Ul_BFu0s_BFu16s");
    static Ul_BFu0s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu0s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu0s_BFu16s");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu16s(Test_Ul_BFu0s_BFu16s, "Ul_BFu0s_BFu16s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu17i  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned int v2:17;
};
//SIG(1 Ul_BFu0s_BFu17i) C1{ FL Fs:0 Fi:17}



static void Test_Ul_BFu0s_BFu17i()
{
  {
    init_simple_test("Ul_BFu0s_BFu17i");
    static Ul_BFu0s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu0s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu0s_BFu17i");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu17i(Test_Ul_BFu0s_BFu17i, "Ul_BFu0s_BFu17i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu17ll  {
  __tsu64 v1;
  unsigned short  :0;
  __tsu64 v2:17;
};
//SIG(1 Ul_BFu0s_BFu17ll) C1{ FL Fs:0 FL:17}



static void Test_Ul_BFu0s_BFu17ll()
{
  {
    init_simple_test("Ul_BFu0s_BFu17ll");
    static Ul_BFu0s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu0s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu0s_BFu17ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu17ll(Test_Ul_BFu0s_BFu17ll, "Ul_BFu0s_BFu17ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu1c  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned char v2:1;
};
//SIG(1 Ul_BFu0s_BFu1c) C1{ FL Fs:0 Fc:1}



static void Test_Ul_BFu0s_BFu1c()
{
  {
    init_simple_test("Ul_BFu0s_BFu1c");
    static Ul_BFu0s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0s_BFu1c");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu1c(Test_Ul_BFu0s_BFu1c, "Ul_BFu0s_BFu1c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu1i  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned int v2:1;
};
//SIG(1 Ul_BFu0s_BFu1i) C1{ FL Fs:0 Fi:1}



static void Test_Ul_BFu0s_BFu1i()
{
  {
    init_simple_test("Ul_BFu0s_BFu1i");
    static Ul_BFu0s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0s_BFu1i");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu1i(Test_Ul_BFu0s_BFu1i, "Ul_BFu0s_BFu1i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu1ll  {
  __tsu64 v1;
  unsigned short  :0;
  __tsu64 v2:1;
};
//SIG(1 Ul_BFu0s_BFu1ll) C1{ FL Fs:0 FL:1}



static void Test_Ul_BFu0s_BFu1ll()
{
  {
    init_simple_test("Ul_BFu0s_BFu1ll");
    static Ul_BFu0s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0s_BFu1ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu1ll(Test_Ul_BFu0s_BFu1ll, "Ul_BFu0s_BFu1ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu1s  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned short v2:1;
};
//SIG(1 Ul_BFu0s_BFu1s) C1{ FL Fs:0 Fs:1}



static void Test_Ul_BFu0s_BFu1s()
{
  {
    init_simple_test("Ul_BFu0s_BFu1s");
    static Ul_BFu0s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu0s_BFu1s");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu1s(Test_Ul_BFu0s_BFu1s, "Ul_BFu0s_BFu1s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu31i  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned int v2:31;
};
//SIG(1 Ul_BFu0s_BFu31i) C1{ FL Fs:0 Fi:31}



static void Test_Ul_BFu0s_BFu31i()
{
  {
    init_simple_test("Ul_BFu0s_BFu31i");
    static Ul_BFu0s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu0s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu0s_BFu31i");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu31i(Test_Ul_BFu0s_BFu31i, "Ul_BFu0s_BFu31i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu31ll  {
  __tsu64 v1;
  unsigned short  :0;
  __tsu64 v2:31;
};
//SIG(1 Ul_BFu0s_BFu31ll) C1{ FL Fs:0 FL:31}



static void Test_Ul_BFu0s_BFu31ll()
{
  {
    init_simple_test("Ul_BFu0s_BFu31ll");
    static Ul_BFu0s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "Ul_BFu0s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "Ul_BFu0s_BFu31ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu31ll(Test_Ul_BFu0s_BFu31ll, "Ul_BFu0s_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu32i  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned int v2:32;
};
//SIG(1 Ul_BFu0s_BFu32i) C1{ FL Fs:0 Fi:32}



static void Test_Ul_BFu0s_BFu32i()
{
  {
    init_simple_test("Ul_BFu0s_BFu32i");
    static Ul_BFu0s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu0s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu0s_BFu32i");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu32i(Test_Ul_BFu0s_BFu32i, "Ul_BFu0s_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu32ll  {
  __tsu64 v1;
  unsigned short  :0;
  __tsu64 v2:32;
};
//SIG(1 Ul_BFu0s_BFu32ll) C1{ FL Fs:0 FL:32}



static void Test_Ul_BFu0s_BFu32ll()
{
  {
    init_simple_test("Ul_BFu0s_BFu32ll");
    static Ul_BFu0s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "Ul_BFu0s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "Ul_BFu0s_BFu32ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu32ll(Test_Ul_BFu0s_BFu32ll, "Ul_BFu0s_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu33  {
  __tsu64 v1;
  unsigned short  :0;
  __tsu64 v2:33;
};
//SIG(1 Ul_BFu0s_BFu33) C1{ FL Fs:0 FL:33}



static void Test_Ul_BFu0s_BFu33()
{
  {
    init_simple_test("Ul_BFu0s_BFu33");
    static Ul_BFu0s_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "Ul_BFu0s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "Ul_BFu0s_BFu33");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu33(Test_Ul_BFu0s_BFu33, "Ul_BFu0s_BFu33", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu7c  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned char v2:7;
};
//SIG(1 Ul_BFu0s_BFu7c) C1{ FL Fs:0 Fc:7}



static void Test_Ul_BFu0s_BFu7c()
{
  {
    init_simple_test("Ul_BFu0s_BFu7c");
    static Ul_BFu0s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0s_BFu7c");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu7c(Test_Ul_BFu0s_BFu7c, "Ul_BFu0s_BFu7c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu7i  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned int v2:7;
};
//SIG(1 Ul_BFu0s_BFu7i) C1{ FL Fs:0 Fi:7}



static void Test_Ul_BFu0s_BFu7i()
{
  {
    init_simple_test("Ul_BFu0s_BFu7i");
    static Ul_BFu0s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0s_BFu7i");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu7i(Test_Ul_BFu0s_BFu7i, "Ul_BFu0s_BFu7i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu7ll  {
  __tsu64 v1;
  unsigned short  :0;
  __tsu64 v2:7;
};
//SIG(1 Ul_BFu0s_BFu7ll) C1{ FL Fs:0 FL:7}



static void Test_Ul_BFu0s_BFu7ll()
{
  {
    init_simple_test("Ul_BFu0s_BFu7ll");
    static Ul_BFu0s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0s_BFu7ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu7ll(Test_Ul_BFu0s_BFu7ll, "Ul_BFu0s_BFu7ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu7s  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned short v2:7;
};
//SIG(1 Ul_BFu0s_BFu7s) C1{ FL Fs:0 Fs:7}



static void Test_Ul_BFu0s_BFu7s()
{
  {
    init_simple_test("Ul_BFu0s_BFu7s");
    static Ul_BFu0s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "Ul_BFu0s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "Ul_BFu0s_BFu7s");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu7s(Test_Ul_BFu0s_BFu7s, "Ul_BFu0s_BFu7s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu8c  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned char v2:8;
};
//SIG(1 Ul_BFu0s_BFu8c) C1{ FL Fs:0 Fc:8}



static void Test_Ul_BFu0s_BFu8c()
{
  {
    init_simple_test("Ul_BFu0s_BFu8c");
    static Ul_BFu0s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0s_BFu8c");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu8c(Test_Ul_BFu0s_BFu8c, "Ul_BFu0s_BFu8c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu8i  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned int v2:8;
};
//SIG(1 Ul_BFu0s_BFu8i) C1{ FL Fs:0 Fi:8}



static void Test_Ul_BFu0s_BFu8i()
{
  {
    init_simple_test("Ul_BFu0s_BFu8i");
    static Ul_BFu0s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0s_BFu8i");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu8i(Test_Ul_BFu0s_BFu8i, "Ul_BFu0s_BFu8i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu8ll  {
  __tsu64 v1;
  unsigned short  :0;
  __tsu64 v2:8;
};
//SIG(1 Ul_BFu0s_BFu8ll) C1{ FL Fs:0 FL:8}



static void Test_Ul_BFu0s_BFu8ll()
{
  {
    init_simple_test("Ul_BFu0s_BFu8ll");
    static Ul_BFu0s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0s_BFu8ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu8ll(Test_Ul_BFu0s_BFu8ll, "Ul_BFu0s_BFu8ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu8s  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned short v2:8;
};
//SIG(1 Ul_BFu0s_BFu8s) C1{ FL Fs:0 Fs:8}



static void Test_Ul_BFu0s_BFu8s()
{
  {
    init_simple_test("Ul_BFu0s_BFu8s");
    static Ul_BFu0s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu0s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu0s_BFu8s");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu8s(Test_Ul_BFu0s_BFu8s, "Ul_BFu0s_BFu8s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu9i  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned int v2:9;
};
//SIG(1 Ul_BFu0s_BFu9i) C1{ FL Fs:0 Fi:9}



static void Test_Ul_BFu0s_BFu9i()
{
  {
    init_simple_test("Ul_BFu0s_BFu9i");
    static Ul_BFu0s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu0s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu0s_BFu9i");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu9i(Test_Ul_BFu0s_BFu9i, "Ul_BFu0s_BFu9i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu9ll  {
  __tsu64 v1;
  unsigned short  :0;
  __tsu64 v2:9;
};
//SIG(1 Ul_BFu0s_BFu9ll) C1{ FL Fs:0 FL:9}



static void Test_Ul_BFu0s_BFu9ll()
{
  {
    init_simple_test("Ul_BFu0s_BFu9ll");
    static Ul_BFu0s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu0s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu0s_BFu9ll");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu9ll(Test_Ul_BFu0s_BFu9ll, "Ul_BFu0s_BFu9ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_BFu9s  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned short v2:9;
};
//SIG(1 Ul_BFu0s_BFu9s) C1{ FL Fs:0 Fs:9}



static void Test_Ul_BFu0s_BFu9s()
{
  {
    init_simple_test("Ul_BFu0s_BFu9s");
    static Ul_BFu0s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu0s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu0s_BFu9s");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_BFu9s(Test_Ul_BFu0s_BFu9s, "Ul_BFu0s_BFu9s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_C  {
  __tsu64 v1;
  unsigned short  :0;
  char v2;
};
//SIG(1 Ul_BFu0s_C) C1{ FL Fs:0 Fc}



static void Test_Ul_BFu0s_C()
{
  {
    init_simple_test("Ul_BFu0s_C");
    static Ul_BFu0s_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_C.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0s_C.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_C(Test_Ul_BFu0s_C, "Ul_BFu0s_C", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_D  {
  __tsu64 v1;
  unsigned short  :0;
  double v2;
};
//SIG(1 Ul_BFu0s_D) C1{ FL Fs:0 FL}



static void Test_Ul_BFu0s_D()
{
  {
    init_simple_test("Ul_BFu0s_D");
    static Ul_BFu0s_D lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_D.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0s_D.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_D(Test_Ul_BFu0s_D, "Ul_BFu0s_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_F  {
  __tsu64 v1;
  unsigned short  :0;
  float v2;
};
//SIG(1 Ul_BFu0s_F) C1{ FL Fs:0 Fi}



static void Test_Ul_BFu0s_F()
{
  {
    init_simple_test("Ul_BFu0s_F");
    static Ul_BFu0s_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_F.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0s_F.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_F(Test_Ul_BFu0s_F, "Ul_BFu0s_F", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_I  {
  __tsu64 v1;
  unsigned short  :0;
  int v2;
};
//SIG(1 Ul_BFu0s_I) C1{ FL Fs:0 Fi}



static void Test_Ul_BFu0s_I()
{
  {
    init_simple_test("Ul_BFu0s_I");
    static Ul_BFu0s_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_I.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0s_I.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_I(Test_Ul_BFu0s_I, "Ul_BFu0s_I", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_Ip  {
  __tsu64 v1;
  unsigned short  :0;
  int *v2;
};
//SIG(1 Ul_BFu0s_Ip) C1{ FL Fs:0 Fp}



static void Test_Ul_BFu0s_Ip()
{
  {
    init_simple_test("Ul_BFu0s_Ip");
    static Ul_BFu0s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0s_Ip.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_Ip(Test_Ul_BFu0s_Ip, "Ul_BFu0s_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_L  {
  __tsu64 v1;
  unsigned short  :0;
  __tsi64 v2;
};
//SIG(1 Ul_BFu0s_L) C1{ FL Fs:0 FL}



static void Test_Ul_BFu0s_L()
{
  {
    init_simple_test("Ul_BFu0s_L");
    static Ul_BFu0s_L lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_L.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0s_L.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_L(Test_Ul_BFu0s_L, "Ul_BFu0s_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_S  {
  __tsu64 v1;
  unsigned short  :0;
  short v2;
};
//SIG(1 Ul_BFu0s_S) C1{ FL Fs:0 Fs}



static void Test_Ul_BFu0s_S()
{
  {
    init_simple_test("Ul_BFu0s_S");
    static Ul_BFu0s_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_S.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0s_S.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_S(Test_Ul_BFu0s_S, "Ul_BFu0s_S", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_Uc  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned char v2;
};
//SIG(1 Ul_BFu0s_Uc) C1{ FL Fs:0 Fc}



static void Test_Ul_BFu0s_Uc()
{
  {
    init_simple_test("Ul_BFu0s_Uc");
    static Ul_BFu0s_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0s_Uc.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_Uc(Test_Ul_BFu0s_Uc, "Ul_BFu0s_Uc", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_Ui  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned int v2;
};
//SIG(1 Ul_BFu0s_Ui) C1{ FL Fs:0 Fi}



static void Test_Ul_BFu0s_Ui()
{
  {
    init_simple_test("Ul_BFu0s_Ui");
    static Ul_BFu0s_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0s_Ui.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_Ui(Test_Ul_BFu0s_Ui, "Ul_BFu0s_Ui", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_Ul  {
  __tsu64 v1;
  unsigned short  :0;
  __tsu64 v2;
};
//SIG(1 Ul_BFu0s_Ul) C1{ FL Fs:0 FL}



static void Test_Ul_BFu0s_Ul()
{
  {
    init_simple_test("Ul_BFu0s_Ul");
    static Ul_BFu0s_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu0s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0s_Ul.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_Ul(Test_Ul_BFu0s_Ul, "Ul_BFu0s_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_Us  {
  __tsu64 v1;
  unsigned short  :0;
  unsigned short v2;
};
//SIG(1 Ul_BFu0s_Us) C1{ FL Fs:0 Fs}



static void Test_Ul_BFu0s_Us()
{
  {
    init_simple_test("Ul_BFu0s_Us");
    static Ul_BFu0s_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0s_Us.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_Us(Test_Ul_BFu0s_Us, "Ul_BFu0s_Us", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu0s_Vp  {
  __tsu64 v1;
  unsigned short  :0;
  void *v2;
};
//SIG(1 Ul_BFu0s_Vp) C1{ FL Fs:0 Fp}



static void Test_Ul_BFu0s_Vp()
{
  {
    init_simple_test("Ul_BFu0s_Vp");
    static Ul_BFu0s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu0s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu0s_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu0s_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_BFu0s_Vp.v2");
  }
}
static Arrange_To_Call_Me vUl_BFu0s_Vp(Test_Ul_BFu0s_Vp, "Ul_BFu0s_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu15i_BFu0c  {
  __tsu64 v1;
  unsigned int v2:15;
  unsigned char  :0;
};
//SIG(1 Ul_BFu15i_BFu0c) C1{ FL Fi:15 Fc:0}



static void Test_Ul_BFu15i_BFu0c()
{
  {
    init_simple_test("Ul_BFu15i_BFu0c");
    static Ul_BFu15i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu15i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu15i_BFu0c)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu0c");
  }
}
static Arrange_To_Call_Me vUl_BFu15i_BFu0c(Test_Ul_BFu15i_BFu0c, "Ul_BFu15i_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu15i_BFu0i  {
  __tsu64 v1;
  unsigned int v2:15;
  unsigned int  :0;
};
//SIG(1 Ul_BFu15i_BFu0i) C1{ FL Fi:15 Fi:0}



static void Test_Ul_BFu15i_BFu0i()
{
  {
    init_simple_test("Ul_BFu15i_BFu0i");
    static Ul_BFu15i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu15i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu15i_BFu0i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu0i");
  }
}
static Arrange_To_Call_Me vUl_BFu15i_BFu0i(Test_Ul_BFu15i_BFu0i, "Ul_BFu15i_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu15i_BFu0ll  {
  __tsu64 v1;
  unsigned int v2:15;
  __tsu64  :0;
};
//SIG(1 Ul_BFu15i_BFu0ll) C1{ FL Fi:15 FL:0}



static void Test_Ul_BFu15i_BFu0ll()
{
  {
    init_simple_test("Ul_BFu15i_BFu0ll");
    static Ul_BFu15i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu15i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu15i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUl_BFu15i_BFu0ll(Test_Ul_BFu15i_BFu0ll, "Ul_BFu15i_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu15i_BFu0s  {
  __tsu64 v1;
  unsigned int v2:15;
  unsigned short  :0;
};
//SIG(1 Ul_BFu15i_BFu0s) C1{ FL Fi:15 Fs:0}



static void Test_Ul_BFu15i_BFu0s()
{
  {
    init_simple_test("Ul_BFu15i_BFu0s");
    static Ul_BFu15i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu15i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu15i_BFu0s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15i_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15i_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15i_BFu0s");
  }
}
static Arrange_To_Call_Me vUl_BFu15i_BFu0s(Test_Ul_BFu15i_BFu0s, "Ul_BFu15i_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu15ll_BFu0c  {
  __tsu64 v1;
  __tsu64 v2:15;
  unsigned char  :0;
};
//SIG(1 Ul_BFu15ll_BFu0c) C1{ FL FL:15 Fc:0}



static void Test_Ul_BFu15ll_BFu0c()
{
  {
    init_simple_test("Ul_BFu15ll_BFu0c");
    static Ul_BFu15ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu15ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu15ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUl_BFu15ll_BFu0c(Test_Ul_BFu15ll_BFu0c, "Ul_BFu15ll_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu15ll_BFu0i  {
  __tsu64 v1;
  __tsu64 v2:15;
  unsigned int  :0;
};
//SIG(1 Ul_BFu15ll_BFu0i) C1{ FL FL:15 Fi:0}



static void Test_Ul_BFu15ll_BFu0i()
{
  {
    init_simple_test("Ul_BFu15ll_BFu0i");
    static Ul_BFu15ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu15ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu15ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUl_BFu15ll_BFu0i(Test_Ul_BFu15ll_BFu0i, "Ul_BFu15ll_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu15ll_BFu0ll  {
  __tsu64 v1;
  __tsu64 v2:15;
  __tsu64  :0;
};
//SIG(1 Ul_BFu15ll_BFu0ll) C1{ FL FL:15 FL:0}



static void Test_Ul_BFu15ll_BFu0ll()
{
  {
    init_simple_test("Ul_BFu15ll_BFu0ll");
    static Ul_BFu15ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu15ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu15ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUl_BFu15ll_BFu0ll(Test_Ul_BFu15ll_BFu0ll, "Ul_BFu15ll_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu15ll_BFu0s  {
  __tsu64 v1;
  __tsu64 v2:15;
  unsigned short  :0;
};
//SIG(1 Ul_BFu15ll_BFu0s) C1{ FL FL:15 Fs:0}



static void Test_Ul_BFu15ll_BFu0s()
{
  {
    init_simple_test("Ul_BFu15ll_BFu0s");
    static Ul_BFu15ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu15ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu15ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15ll_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUl_BFu15ll_BFu0s(Test_Ul_BFu15ll_BFu0s, "Ul_BFu15ll_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu15s_BFu0c  {
  __tsu64 v1;
  unsigned short v2:15;
  unsigned char  :0;
};
//SIG(1 Ul_BFu15s_BFu0c) C1{ FL Fs:15 Fc:0}



static void Test_Ul_BFu15s_BFu0c()
{
  {
    init_simple_test("Ul_BFu15s_BFu0c");
    static Ul_BFu15s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu15s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu15s_BFu0c)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu0c");
  }
}
static Arrange_To_Call_Me vUl_BFu15s_BFu0c(Test_Ul_BFu15s_BFu0c, "Ul_BFu15s_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu15s_BFu0i  {
  __tsu64 v1;
  unsigned short v2:15;
  unsigned int  :0;
};
//SIG(1 Ul_BFu15s_BFu0i) C1{ FL Fs:15 Fi:0}



static void Test_Ul_BFu15s_BFu0i()
{
  {
    init_simple_test("Ul_BFu15s_BFu0i");
    static Ul_BFu15s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu15s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu15s_BFu0i)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu0i");
  }
}
static Arrange_To_Call_Me vUl_BFu15s_BFu0i(Test_Ul_BFu15s_BFu0i, "Ul_BFu15s_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu15s_BFu0ll  {
  __tsu64 v1;
  unsigned short v2:15;
  __tsu64  :0;
};
//SIG(1 Ul_BFu15s_BFu0ll) C1{ FL Fs:15 FL:0}



static void Test_Ul_BFu15s_BFu0ll()
{
  {
    init_simple_test("Ul_BFu15s_BFu0ll");
    static Ul_BFu15s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu15s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu15s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu0ll");
  }
}
static Arrange_To_Call_Me vUl_BFu15s_BFu0ll(Test_Ul_BFu15s_BFu0ll, "Ul_BFu15s_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu15s_BFu0s  {
  __tsu64 v1;
  unsigned short v2:15;
  unsigned short  :0;
};
//SIG(1 Ul_BFu15s_BFu0s) C1{ FL Fs:15 Fs:0}



static void Test_Ul_BFu15s_BFu0s()
{
  {
    init_simple_test("Ul_BFu15s_BFu0s");
    static Ul_BFu15s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu15s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu15s_BFu0s)");
    check_field_offset(lv, v1, 0, "Ul_BFu15s_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "Ul_BFu15s_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "Ul_BFu15s_BFu0s");
  }
}
static Arrange_To_Call_Me vUl_BFu15s_BFu0s(Test_Ul_BFu15s_BFu0s, "Ul_BFu15s_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu16i_BFu0c  {
  __tsu64 v1;
  unsigned int v2:16;
  unsigned char  :0;
};
//SIG(1 Ul_BFu16i_BFu0c) C1{ FL Fi:16 Fc:0}



static void Test_Ul_BFu16i_BFu0c()
{
  {
    init_simple_test("Ul_BFu16i_BFu0c");
    static Ul_BFu16i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu16i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu16i_BFu0c)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu0c");
  }
}
static Arrange_To_Call_Me vUl_BFu16i_BFu0c(Test_Ul_BFu16i_BFu0c, "Ul_BFu16i_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu16i_BFu0i  {
  __tsu64 v1;
  unsigned int v2:16;
  unsigned int  :0;
};
//SIG(1 Ul_BFu16i_BFu0i) C1{ FL Fi:16 Fi:0}



static void Test_Ul_BFu16i_BFu0i()
{
  {
    init_simple_test("Ul_BFu16i_BFu0i");
    static Ul_BFu16i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu16i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu16i_BFu0i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu0i");
  }
}
static Arrange_To_Call_Me vUl_BFu16i_BFu0i(Test_Ul_BFu16i_BFu0i, "Ul_BFu16i_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu16i_BFu0ll  {
  __tsu64 v1;
  unsigned int v2:16;
  __tsu64  :0;
};
//SIG(1 Ul_BFu16i_BFu0ll) C1{ FL Fi:16 FL:0}



static void Test_Ul_BFu16i_BFu0ll()
{
  {
    init_simple_test("Ul_BFu16i_BFu0ll");
    static Ul_BFu16i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu16i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu16i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUl_BFu16i_BFu0ll(Test_Ul_BFu16i_BFu0ll, "Ul_BFu16i_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu16i_BFu0s  {
  __tsu64 v1;
  unsigned int v2:16;
  unsigned short  :0;
};
//SIG(1 Ul_BFu16i_BFu0s) C1{ FL Fi:16 Fs:0}



static void Test_Ul_BFu16i_BFu0s()
{
  {
    init_simple_test("Ul_BFu16i_BFu0s");
    static Ul_BFu16i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu16i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu16i_BFu0s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16i_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16i_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16i_BFu0s");
  }
}
static Arrange_To_Call_Me vUl_BFu16i_BFu0s(Test_Ul_BFu16i_BFu0s, "Ul_BFu16i_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu16ll_BFu0c  {
  __tsu64 v1;
  __tsu64 v2:16;
  unsigned char  :0;
};
//SIG(1 Ul_BFu16ll_BFu0c) C1{ FL FL:16 Fc:0}



static void Test_Ul_BFu16ll_BFu0c()
{
  {
    init_simple_test("Ul_BFu16ll_BFu0c");
    static Ul_BFu16ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu16ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu16ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUl_BFu16ll_BFu0c(Test_Ul_BFu16ll_BFu0c, "Ul_BFu16ll_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu16ll_BFu0i  {
  __tsu64 v1;
  __tsu64 v2:16;
  unsigned int  :0;
};
//SIG(1 Ul_BFu16ll_BFu0i) C1{ FL FL:16 Fi:0}



static void Test_Ul_BFu16ll_BFu0i()
{
  {
    init_simple_test("Ul_BFu16ll_BFu0i");
    static Ul_BFu16ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu16ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu16ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUl_BFu16ll_BFu0i(Test_Ul_BFu16ll_BFu0i, "Ul_BFu16ll_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu16ll_BFu0ll  {
  __tsu64 v1;
  __tsu64 v2:16;
  __tsu64  :0;
};
//SIG(1 Ul_BFu16ll_BFu0ll) C1{ FL FL:16 FL:0}



static void Test_Ul_BFu16ll_BFu0ll()
{
  {
    init_simple_test("Ul_BFu16ll_BFu0ll");
    static Ul_BFu16ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu16ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu16ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUl_BFu16ll_BFu0ll(Test_Ul_BFu16ll_BFu0ll, "Ul_BFu16ll_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu16ll_BFu0s  {
  __tsu64 v1;
  __tsu64 v2:16;
  unsigned short  :0;
};
//SIG(1 Ul_BFu16ll_BFu0s) C1{ FL FL:16 Fs:0}



static void Test_Ul_BFu16ll_BFu0s()
{
  {
    init_simple_test("Ul_BFu16ll_BFu0s");
    static Ul_BFu16ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu16ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu16ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16ll_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUl_BFu16ll_BFu0s(Test_Ul_BFu16ll_BFu0s, "Ul_BFu16ll_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu16s_BFu0c  {
  __tsu64 v1;
  unsigned short v2:16;
  unsigned char  :0;
};
//SIG(1 Ul_BFu16s_BFu0c) C1{ FL Fs:16 Fc:0}



static void Test_Ul_BFu16s_BFu0c()
{
  {
    init_simple_test("Ul_BFu16s_BFu0c");
    static Ul_BFu16s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu16s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu16s_BFu0c)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu0c");
  }
}
static Arrange_To_Call_Me vUl_BFu16s_BFu0c(Test_Ul_BFu16s_BFu0c, "Ul_BFu16s_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu16s_BFu0i  {
  __tsu64 v1;
  unsigned short v2:16;
  unsigned int  :0;
};
//SIG(1 Ul_BFu16s_BFu0i) C1{ FL Fs:16 Fi:0}



static void Test_Ul_BFu16s_BFu0i()
{
  {
    init_simple_test("Ul_BFu16s_BFu0i");
    static Ul_BFu16s_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu16s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu16s_BFu0i)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu0i");
  }
}
static Arrange_To_Call_Me vUl_BFu16s_BFu0i(Test_Ul_BFu16s_BFu0i, "Ul_BFu16s_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu16s_BFu0ll  {
  __tsu64 v1;
  unsigned short v2:16;
  __tsu64  :0;
};
//SIG(1 Ul_BFu16s_BFu0ll) C1{ FL Fs:16 FL:0}



static void Test_Ul_BFu16s_BFu0ll()
{
  {
    init_simple_test("Ul_BFu16s_BFu0ll");
    static Ul_BFu16s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu16s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu16s_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu0ll");
  }
}
static Arrange_To_Call_Me vUl_BFu16s_BFu0ll(Test_Ul_BFu16s_BFu0ll, "Ul_BFu16s_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu16s_BFu0s  {
  __tsu64 v1;
  unsigned short v2:16;
  unsigned short  :0;
};
//SIG(1 Ul_BFu16s_BFu0s) C1{ FL Fs:16 Fs:0}



static void Test_Ul_BFu16s_BFu0s()
{
  {
    init_simple_test("Ul_BFu16s_BFu0s");
    static Ul_BFu16s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu16s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu16s_BFu0s)");
    check_field_offset(lv, v1, 0, "Ul_BFu16s_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "Ul_BFu16s_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "Ul_BFu16s_BFu0s");
  }
}
static Arrange_To_Call_Me vUl_BFu16s_BFu0s(Test_Ul_BFu16s_BFu0s, "Ul_BFu16s_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu17i_BFu0c  {
  __tsu64 v1;
  unsigned int v2:17;
  unsigned char  :0;
};
//SIG(1 Ul_BFu17i_BFu0c) C1{ FL Fi:17 Fc:0}



static void Test_Ul_BFu17i_BFu0c()
{
  {
    init_simple_test("Ul_BFu17i_BFu0c");
    static Ul_BFu17i_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu17i_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu17i_BFu0c)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu0c");
  }
}
static Arrange_To_Call_Me vUl_BFu17i_BFu0c(Test_Ul_BFu17i_BFu0c, "Ul_BFu17i_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu17i_BFu0i  {
  __tsu64 v1;
  unsigned int v2:17;
  unsigned int  :0;
};
//SIG(1 Ul_BFu17i_BFu0i) C1{ FL Fi:17 Fi:0}



static void Test_Ul_BFu17i_BFu0i()
{
  {
    init_simple_test("Ul_BFu17i_BFu0i");
    static Ul_BFu17i_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu17i_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu17i_BFu0i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu0i");
  }
}
static Arrange_To_Call_Me vUl_BFu17i_BFu0i(Test_Ul_BFu17i_BFu0i, "Ul_BFu17i_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu17i_BFu0ll  {
  __tsu64 v1;
  unsigned int v2:17;
  __tsu64  :0;
};
//SIG(1 Ul_BFu17i_BFu0ll) C1{ FL Fi:17 FL:0}



static void Test_Ul_BFu17i_BFu0ll()
{
  {
    init_simple_test("Ul_BFu17i_BFu0ll");
    static Ul_BFu17i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu17i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu17i_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu0ll");
  }
}
static Arrange_To_Call_Me vUl_BFu17i_BFu0ll(Test_Ul_BFu17i_BFu0ll, "Ul_BFu17i_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu17i_BFu0s  {
  __tsu64 v1;
  unsigned int v2:17;
  unsigned short  :0;
};
//SIG(1 Ul_BFu17i_BFu0s) C1{ FL Fi:17 Fs:0}



static void Test_Ul_BFu17i_BFu0s()
{
  {
    init_simple_test("Ul_BFu17i_BFu0s");
    static Ul_BFu17i_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu17i_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu17i_BFu0s)");
    check_field_offset(lv, v1, 0, "Ul_BFu17i_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17i_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17i_BFu0s");
  }
}
static Arrange_To_Call_Me vUl_BFu17i_BFu0s(Test_Ul_BFu17i_BFu0s, "Ul_BFu17i_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu17ll_BFu0c  {
  __tsu64 v1;
  __tsu64 v2:17;
  unsigned char  :0;
};
//SIG(1 Ul_BFu17ll_BFu0c) C1{ FL FL:17 Fc:0}



static void Test_Ul_BFu17ll_BFu0c()
{
  {
    init_simple_test("Ul_BFu17ll_BFu0c");
    static Ul_BFu17ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu17ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu17ll_BFu0c)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu0c");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu0c");
  }
}
static Arrange_To_Call_Me vUl_BFu17ll_BFu0c(Test_Ul_BFu17ll_BFu0c, "Ul_BFu17ll_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu17ll_BFu0i  {
  __tsu64 v1;
  __tsu64 v2:17;
  unsigned int  :0;
};
//SIG(1 Ul_BFu17ll_BFu0i) C1{ FL FL:17 Fi:0}



static void Test_Ul_BFu17ll_BFu0i()
{
  {
    init_simple_test("Ul_BFu17ll_BFu0i");
    static Ul_BFu17ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu17ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu17ll_BFu0i)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu0i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu0i");
  }
}
static Arrange_To_Call_Me vUl_BFu17ll_BFu0i(Test_Ul_BFu17ll_BFu0i, "Ul_BFu17ll_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu17ll_BFu0ll  {
  __tsu64 v1;
  __tsu64 v2:17;
  __tsu64  :0;
};
//SIG(1 Ul_BFu17ll_BFu0ll) C1{ FL FL:17 FL:0}



static void Test_Ul_BFu17ll_BFu0ll()
{
  {
    init_simple_test("Ul_BFu17ll_BFu0ll");
    static Ul_BFu17ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu17ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu17ll_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu0ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vUl_BFu17ll_BFu0ll(Test_Ul_BFu17ll_BFu0ll, "Ul_BFu17ll_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu17ll_BFu0s  {
  __tsu64 v1;
  __tsu64 v2:17;
  unsigned short  :0;
};
//SIG(1 Ul_BFu17ll_BFu0s) C1{ FL FL:17 Fs:0}



static void Test_Ul_BFu17ll_BFu0s()
{
  {
    init_simple_test("Ul_BFu17ll_BFu0s");
    static Ul_BFu17ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu17ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu17ll_BFu0s)");
    check_field_offset(lv, v1, 0, "Ul_BFu17ll_BFu0s.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "Ul_BFu17ll_BFu0s");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "Ul_BFu17ll_BFu0s");
  }
}
static Arrange_To_Call_Me vUl_BFu17ll_BFu0s(Test_Ul_BFu17ll_BFu0s, "Ul_BFu17ll_BFu0s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu1c_BFu0c  {
  __tsu64 v1;
  unsigned char v2:1;
  unsigned char  :0;
};
//SIG(1 Ul_BFu1c_BFu0c) C1{ FL Fc:1 Fc:0}



static void Test_Ul_BFu1c_BFu0c()
{
  {
    init_simple_test("Ul_BFu1c_BFu0c");
    static Ul_BFu1c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu1c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu1c_BFu0c)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu0c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu0c");
  }
}
static Arrange_To_Call_Me vUl_BFu1c_BFu0c(Test_Ul_BFu1c_BFu0c, "Ul_BFu1c_BFu0c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu1c_BFu0i  {
  __tsu64 v1;
  unsigned char v2:1;
  unsigned int  :0;
};
//SIG(1 Ul_BFu1c_BFu0i) C1{ FL Fc:1 Fi:0}



static void Test_Ul_BFu1c_BFu0i()
{
  {
    init_simple_test("Ul_BFu1c_BFu0i");
    static Ul_BFu1c_BFu0i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu1c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu1c_BFu0i)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu0i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu0i");
  }
}
static Arrange_To_Call_Me vUl_BFu1c_BFu0i(Test_Ul_BFu1c_BFu0i, "Ul_BFu1c_BFu0i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu1c_BFu0ll  {
  __tsu64 v1;
  unsigned char v2:1;
  __tsu64  :0;
};
//SIG(1 Ul_BFu1c_BFu0ll) C1{ FL Fc:1 FL:0}



static void Test_Ul_BFu1c_BFu0ll()
{
  {
    init_simple_test("Ul_BFu1c_BFu0ll");
    static Ul_BFu1c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu1c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu1c_BFu0ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu0ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "Ul_BFu1c_BFu0ll");
  }
}
static Arrange_To_Call_Me vUl_BFu1c_BFu0ll(Test_Ul_BFu1c_BFu0ll, "Ul_BFu1c_BFu0ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Ul_BFu1c_BFu0s  {
  __tsu64 v1;
  unsigned char v2:1;
  unsigned short  :0;
};
//SIG(1 Ul_BFu1c_BFu0s) C1{ FL Fc:1 Fs:0}



static void Test_Ul_BFu1c_BFu0s()
{
  {
    init_simple_test("Ul_BFu1c_BFu0s");
    static Ul_BFu1c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu1c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu1c_BFu0s)");
    check_field_offset(lv, v1, 0, "Ul_BFu1c_BFu0s.v