// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu1i  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu1c_BFu1i) C1{ Fi:0 Fc:1 Fi:1}



static void Test_BFu0i_BFu1c_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu1i");
    static BFu0i_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1c_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu1i(Test_BFu0i_BFu1c_BFu1i, "BFu0i_BFu1c_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu1ll  {
  unsigned int  :0;
  unsigned char v1:1;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu1c_BFu1ll) C1{ Fi:0 Fc:1 FL:1}



static void Test_BFu0i_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu1ll");
    static BFu0i_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1c_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu1ll(Test_BFu0i_BFu1c_BFu1ll, "BFu0i_BFu1c_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu1s  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu1c_BFu1s) C1{ Fi:0 Fc:1 Fs:1}



static void Test_BFu0i_BFu1c_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu1s");
    static BFu0i_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1c_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu1s(Test_BFu0i_BFu1c_BFu1s, "BFu0i_BFu1c_BFu1s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu31i  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu1c_BFu31i) C1{ Fi:0 Fc:1 Fi:31}



static void Test_BFu0i_BFu1c_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu31i");
    static BFu0i_BFu1c_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0i_BFu1c_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0i_BFu1c_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu31i(Test_BFu0i_BFu1c_BFu31i, "BFu0i_BFu1c_BFu31i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu31ll  {
  unsigned int  :0;
  unsigned char v1:1;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu1c_BFu31ll) C1{ Fi:0 Fc:1 FL:31}



static void Test_BFu0i_BFu1c_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu31ll");
    static BFu0i_BFu1c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0i_BFu1c_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0i_BFu1c_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu31ll(Test_BFu0i_BFu1c_BFu31ll, "BFu0i_BFu1c_BFu31ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu32i  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu1c_BFu32i) C1{ Fi:0 Fc:1 Fi:32}



static void Test_BFu0i_BFu1c_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu32i");
    static BFu0i_BFu1c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu1c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu1c_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu32i(Test_BFu0i_BFu1c_BFu32i, "BFu0i_BFu1c_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu32ll  {
  unsigned int  :0;
  unsigned char v1:1;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu1c_BFu32ll) C1{ Fi:0 Fc:1 FL:32}



static void Test_BFu0i_BFu1c_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu32ll");
    static BFu0i_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu0i_BFu1c_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu0i_BFu1c_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu32ll(Test_BFu0i_BFu1c_BFu32ll, "BFu0i_BFu1c_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu33  {
  unsigned int  :0;
  unsigned char v1:1;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu1c_BFu33) C1{ Fi:0 Fc:1 FL:33}



static void Test_BFu0i_BFu1c_BFu33()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu33");
    static BFu0i_BFu1c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu0i_BFu1c_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu0i_BFu1c_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu33(Test_BFu0i_BFu1c_BFu33, "BFu0i_BFu1c_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu7c  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu1c_BFu7c) C1{ Fi:0 Fc:1 Fc:7}



static void Test_BFu0i_BFu1c_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu7c");
    static BFu0i_BFu1c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu1c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu1c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1c_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1c_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu7c(Test_BFu0i_BFu1c_BFu7c, "BFu0i_BFu1c_BFu7c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu7i  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu1c_BFu7i) C1{ Fi:0 Fc:1 Fi:7}



static void Test_BFu0i_BFu1c_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu7i");
    static BFu0i_BFu1c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1c_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1c_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu7i(Test_BFu0i_BFu1c_BFu7i, "BFu0i_BFu1c_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu7ll  {
  unsigned int  :0;
  unsigned char v1:1;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu1c_BFu7ll) C1{ Fi:0 Fc:1 FL:7}



static void Test_BFu0i_BFu1c_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu7ll");
    static BFu0i_BFu1c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1c_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu7ll(Test_BFu0i_BFu1c_BFu7ll, "BFu0i_BFu1c_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu7s  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu1c_BFu7s) C1{ Fi:0 Fc:1 Fs:7}



static void Test_BFu0i_BFu1c_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu7s");
    static BFu0i_BFu1c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1c_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1c_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu7s(Test_BFu0i_BFu1c_BFu7s, "BFu0i_BFu1c_BFu7s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu8c  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu1c_BFu8c) C1{ Fi:0 Fc:1 Fc:8}



static void Test_BFu0i_BFu1c_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu8c");
    static BFu0i_BFu1c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu1c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu1c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu1c_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu8c(Test_BFu0i_BFu1c_BFu8c, "BFu0i_BFu1c_BFu8c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu8i  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu1c_BFu8i) C1{ Fi:0 Fc:1 Fi:8}



static void Test_BFu0i_BFu1c_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu8i");
    static BFu0i_BFu1c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0i_BFu1c_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu1c_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu8i(Test_BFu0i_BFu1c_BFu8i, "BFu0i_BFu1c_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu8ll  {
  unsigned int  :0;
  unsigned char v1:1;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu1c_BFu8ll) C1{ Fi:0 Fc:1 FL:8}



static void Test_BFu0i_BFu1c_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu8ll");
    static BFu0i_BFu1c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0i_BFu1c_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu1c_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu8ll(Test_BFu0i_BFu1c_BFu8ll, "BFu0i_BFu1c_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu8s  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu1c_BFu8s) C1{ Fi:0 Fc:1 Fs:8}



static void Test_BFu0i_BFu1c_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu8s");
    static BFu0i_BFu1c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0i_BFu1c_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu1c_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu8s(Test_BFu0i_BFu1c_BFu8s, "BFu0i_BFu1c_BFu8s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu9i  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu1c_BFu9i) C1{ Fi:0 Fc:1 Fi:9}



static void Test_BFu0i_BFu1c_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu9i");
    static BFu0i_BFu1c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0i_BFu1c_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu1c_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu9i(Test_BFu0i_BFu1c_BFu9i, "BFu0i_BFu1c_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu9ll  {
  unsigned int  :0;
  unsigned char v1:1;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu1c_BFu9ll) C1{ Fi:0 Fc:1 FL:9}



static void Test_BFu0i_BFu1c_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu9ll");
    static BFu0i_BFu1c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0i_BFu1c_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu1c_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu9ll(Test_BFu0i_BFu1c_BFu9ll, "BFu0i_BFu1c_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_BFu9s  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu1c_BFu9s) C1{ Fi:0 Fc:1 Fs:9}



static void Test_BFu0i_BFu1c_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu1c_BFu9s");
    static BFu0i_BFu1c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1c_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0i_BFu1c_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu1c_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_BFu9s(Test_BFu0i_BFu1c_BFu9s, "BFu0i_BFu1c_BFu9s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_C  {
  unsigned int  :0;
  unsigned char v1:1;
  char v2;
};
//SIG(1 BFu0i_BFu1c_C) C1{ Fi:0 Fc:1 Fc}



static void Test_BFu0i_BFu1c_C()
{
  {
    init_simple_test("BFu0i_BFu1c_C");
    static BFu0i_BFu1c_C lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1c_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu1c_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_C");
    check_field_offset(lv, v2, 1, "BFu0i_BFu1c_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_C(Test_BFu0i_BFu1c_C, "BFu0i_BFu1c_C", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_D  {
  unsigned int  :0;
  unsigned char v1:1;
  double v2;
};
//SIG(1 BFu0i_BFu1c_D) C1{ Fi:0 Fc:1 FL}



static void Test_BFu0i_BFu1c_D()
{
  {
    init_simple_test("BFu0i_BFu1c_D");
    static BFu0i_BFu1c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu1c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1c_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1c_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_D(Test_BFu0i_BFu1c_D, "BFu0i_BFu1c_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_F  {
  unsigned int  :0;
  unsigned char v1:1;
  float v2;
};
//SIG(1 BFu0i_BFu1c_F) C1{ Fi:0 Fc:1 Fi}



static void Test_BFu0i_BFu1c_F()
{
  {
    init_simple_test("BFu0i_BFu1c_F");
    static BFu0i_BFu1c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1c_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu1c_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_F(Test_BFu0i_BFu1c_F, "BFu0i_BFu1c_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_I  {
  unsigned int  :0;
  unsigned char v1:1;
  int v2;
};
//SIG(1 BFu0i_BFu1c_I) C1{ Fi:0 Fc:1 Fi}



static void Test_BFu0i_BFu1c_I()
{
  {
    init_simple_test("BFu0i_BFu1c_I");
    static BFu0i_BFu1c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1c_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu1c_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_I(Test_BFu0i_BFu1c_I, "BFu0i_BFu1c_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_Ip  {
  unsigned int  :0;
  unsigned char v1:1;
  int *v2;
};
//SIG(1 BFu0i_BFu1c_Ip) C1{ Fi:0 Fc:1 Fp}



static void Test_BFu0i_BFu1c_Ip()
{
  {
    init_simple_test("BFu0i_BFu1c_Ip");
    static BFu0i_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu1c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1c_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_Ip(Test_BFu0i_BFu1c_Ip, "BFu0i_BFu1c_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_L  {
  unsigned int  :0;
  unsigned char v1:1;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu1c_L) C1{ Fi:0 Fc:1 FL}



static void Test_BFu0i_BFu1c_L()
{
  {
    init_simple_test("BFu0i_BFu1c_L");
    static BFu0i_BFu1c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu1c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1c_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1c_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_L(Test_BFu0i_BFu1c_L, "BFu0i_BFu1c_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_S  {
  unsigned int  :0;
  unsigned char v1:1;
  short v2;
};
//SIG(1 BFu0i_BFu1c_S) C1{ Fi:0 Fc:1 Fs}



static void Test_BFu0i_BFu1c_S()
{
  {
    init_simple_test("BFu0i_BFu1c_S");
    static BFu0i_BFu1c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1c_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1c_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu1c_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_S(Test_BFu0i_BFu1c_S, "BFu0i_BFu1c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_Uc  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu1c_Uc) C1{ Fi:0 Fc:1 Fc}



static void Test_BFu0i_BFu1c_Uc()
{
  {
    init_simple_test("BFu0i_BFu1c_Uc");
    static BFu0i_BFu1c_Uc lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1c_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu1c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_Uc");
    check_field_offset(lv, v2, 1, "BFu0i_BFu1c_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_Uc(Test_BFu0i_BFu1c_Uc, "BFu0i_BFu1c_Uc", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_Ui  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu1c_Ui) C1{ Fi:0 Fc:1 Fi}



static void Test_BFu0i_BFu1c_Ui()
{
  {
    init_simple_test("BFu0i_BFu1c_Ui");
    static BFu0i_BFu1c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu1c_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_Ui(Test_BFu0i_BFu1c_Ui, "BFu0i_BFu1c_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_Ul  {
  unsigned int  :0;
  unsigned char v1:1;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu1c_Ul) C1{ Fi:0 Fc:1 FL}



static void Test_BFu0i_BFu1c_Ul()
{
  {
    init_simple_test("BFu0i_BFu1c_Ul");
    static BFu0i_BFu1c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu1c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1c_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_Ul(Test_BFu0i_BFu1c_Ul, "BFu0i_BFu1c_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_Us  {
  unsigned int  :0;
  unsigned char v1:1;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu1c_Us) C1{ Fi:0 Fc:1 Fs}



static void Test_BFu0i_BFu1c_Us()
{
  {
    init_simple_test("BFu0i_BFu1c_Us");
    static BFu0i_BFu1c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1c_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu1c_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_Us(Test_BFu0i_BFu1c_Us, "BFu0i_BFu1c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1c_Vp  {
  unsigned int  :0;
  unsigned char v1:1;
  void *v2;
};
//SIG(1 BFu0i_BFu1c_Vp) C1{ Fi:0 Fc:1 Fp}



static void Test_BFu0i_BFu1c_Vp()
{
  {
    init_simple_test("BFu0i_BFu1c_Vp");
    static BFu0i_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu1c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1c_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1c_Vp(Test_BFu0i_BFu1c_Vp, "BFu0i_BFu1c_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i  {
  unsigned int  :0;
  unsigned int v1:1;
};
//SIG(1 BFu0i_BFu1i) C1{ Fi:0 Fi:1}



static void Test_BFu0i_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu1i");
    static BFu0i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i(Test_BFu0i_BFu1i, "BFu0i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu0c  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu1i_BFu0c) C1{ Fi:0 Fi:1 Fc:0}



static void Test_BFu0i_BFu1i_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu0c");
    static BFu0i_BFu1i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu0c(Test_BFu0i_BFu1i_BFu0c, "BFu0i_BFu1i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu0i  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu1i_BFu0i) C1{ Fi:0 Fi:1 Fi:0}



static void Test_BFu0i_BFu1i_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu0i");
    static BFu0i_BFu1i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu0i(Test_BFu0i_BFu1i_BFu0i, "BFu0i_BFu1i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu0ll  {
  unsigned int  :0;
  unsigned int v1:1;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu1i_BFu0ll) C1{ Fi:0 Fi:1 FL:0}



static void Test_BFu0i_BFu1i_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu0ll");
    static BFu0i_BFu1i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0i_BFu1i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu0ll(Test_BFu0i_BFu1i_BFu0ll, "BFu0i_BFu1i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu0s  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu1i_BFu0s) C1{ Fi:0 Fi:1 Fs:0}



static void Test_BFu0i_BFu1i_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu0s");
    static BFu0i_BFu1i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu0s(Test_BFu0i_BFu1i_BFu0s, "BFu0i_BFu1i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu15i  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu1i_BFu15i) C1{ Fi:0 Fi:1 Fi:15}



static void Test_BFu0i_BFu1i_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu15i");
    static BFu0i_BFu1i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0i_BFu1i_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu1i_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu15i(Test_BFu0i_BFu1i_BFu15i, "BFu0i_BFu1i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu15ll  {
  unsigned int  :0;
  unsigned int v1:1;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu1i_BFu15ll) C1{ Fi:0 Fi:1 FL:15}



static void Test_BFu0i_BFu1i_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu15ll");
    static BFu0i_BFu1i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0i_BFu1i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu1i_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu15ll(Test_BFu0i_BFu1i_BFu15ll, "BFu0i_BFu1i_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu15s  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu1i_BFu15s) C1{ Fi:0 Fi:1 Fs:15}



static void Test_BFu0i_BFu1i_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu15s");
    static BFu0i_BFu1i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0i_BFu1i_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu1i_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu15s(Test_BFu0i_BFu1i_BFu15s, "BFu0i_BFu1i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu16i  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu1i_BFu16i) C1{ Fi:0 Fi:1 Fi:16}



static void Test_BFu0i_BFu1i_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu16i");
    static BFu0i_BFu1i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu0i_BFu1i_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu0i_BFu1i_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu16i(Test_BFu0i_BFu1i_BFu16i, "BFu0i_BFu1i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu16ll  {
  unsigned int  :0;
  unsigned int v1:1;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu1i_BFu16ll) C1{ Fi:0 Fi:1 FL:16}



static void Test_BFu0i_BFu1i_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu16ll");
    static BFu0i_BFu1i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu0i_BFu1i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu0i_BFu1i_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu16ll(Test_BFu0i_BFu1i_BFu16ll, "BFu0i_BFu1i_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu16s  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu1i_BFu16s) C1{ Fi:0 Fi:1 Fs:16}



static void Test_BFu0i_BFu1i_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu16s");
    static BFu0i_BFu1i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_BFu1i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu1i_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu16s(Test_BFu0i_BFu1i_BFu16s, "BFu0i_BFu1i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu17i  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu1i_BFu17i) C1{ Fi:0 Fi:1 Fi:17}



static void Test_BFu0i_BFu1i_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu17i");
    static BFu0i_BFu1i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu0i_BFu1i_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu0i_BFu1i_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu17i(Test_BFu0i_BFu1i_BFu17i, "BFu0i_BFu1i_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu17ll  {
  unsigned int  :0;
  unsigned int v1:1;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu1i_BFu17ll) C1{ Fi:0 Fi:1 FL:17}



static void Test_BFu0i_BFu1i_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu17ll");
    static BFu0i_BFu1i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu0i_BFu1i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu0i_BFu1i_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu17ll(Test_BFu0i_BFu1i_BFu17ll, "BFu0i_BFu1i_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu1c  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu1i_BFu1c) C1{ Fi:0 Fi:1 Fc:1}



static void Test_BFu0i_BFu1i_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu1c");
    static BFu0i_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1i_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu1c(Test_BFu0i_BFu1i_BFu1c, "BFu0i_BFu1i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu1i  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu1i_BFu1i) C1{ Fi:0 Fi:1 Fi:1}



static void Test_BFu0i_BFu1i_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu1i");
    static BFu0i_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1i_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu1i(Test_BFu0i_BFu1i_BFu1i, "BFu0i_BFu1i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu1ll  {
  unsigned int  :0;
  unsigned int v1:1;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu1i_BFu1ll) C1{ Fi:0 Fi:1 FL:1}



static void Test_BFu0i_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu1ll");
    static BFu0i_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1i_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu1ll(Test_BFu0i_BFu1i_BFu1ll, "BFu0i_BFu1i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu1s  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu1i_BFu1s) C1{ Fi:0 Fi:1 Fs:1}



static void Test_BFu0i_BFu1i_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu1s");
    static BFu0i_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1i_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu1s(Test_BFu0i_BFu1i_BFu1s, "BFu0i_BFu1i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu31i  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu1i_BFu31i) C1{ Fi:0 Fi:1 Fi:31}



static void Test_BFu0i_BFu1i_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu31i");
    static BFu0i_BFu1i_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0i_BFu1i_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0i_BFu1i_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu31i(Test_BFu0i_BFu1i_BFu31i, "BFu0i_BFu1i_BFu31i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu31ll  {
  unsigned int  :0;
  unsigned int v1:1;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu1i_BFu31ll) C1{ Fi:0 Fi:1 FL:31}



static void Test_BFu0i_BFu1i_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu31ll");
    static BFu0i_BFu1i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0i_BFu1i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0i_BFu1i_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu31ll(Test_BFu0i_BFu1i_BFu31ll, "BFu0i_BFu1i_BFu31ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu32i  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu1i_BFu32i) C1{ Fi:0 Fi:1 Fi:32}



static void Test_BFu0i_BFu1i_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu32i");
    static BFu0i_BFu1i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu1i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu1i_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu32i(Test_BFu0i_BFu1i_BFu32i, "BFu0i_BFu1i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu32ll  {
  unsigned int  :0;
  unsigned int v1:1;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu1i_BFu32ll) C1{ Fi:0 Fi:1 FL:32}



static void Test_BFu0i_BFu1i_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu32ll");
    static BFu0i_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu0i_BFu1i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu0i_BFu1i_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu32ll(Test_BFu0i_BFu1i_BFu32ll, "BFu0i_BFu1i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu33  {
  unsigned int  :0;
  unsigned int v1:1;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu1i_BFu33) C1{ Fi:0 Fi:1 FL:33}



static void Test_BFu0i_BFu1i_BFu33()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu33");
    static BFu0i_BFu1i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu0i_BFu1i_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu0i_BFu1i_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu33(Test_BFu0i_BFu1i_BFu33, "BFu0i_BFu1i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu7c  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu1i_BFu7c) C1{ Fi:0 Fi:1 Fc:7}



static void Test_BFu0i_BFu1i_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu7c");
    static BFu0i_BFu1i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1i_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1i_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu7c(Test_BFu0i_BFu1i_BFu7c, "BFu0i_BFu1i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu7i  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu1i_BFu7i) C1{ Fi:0 Fi:1 Fi:7}



static void Test_BFu0i_BFu1i_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu7i");
    static BFu0i_BFu1i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1i_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1i_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu7i(Test_BFu0i_BFu1i_BFu7i, "BFu0i_BFu1i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu7ll  {
  unsigned int  :0;
  unsigned int v1:1;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu1i_BFu7ll) C1{ Fi:0 Fi:1 FL:7}



static void Test_BFu0i_BFu1i_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu7ll");
    static BFu0i_BFu1i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1i_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu7ll(Test_BFu0i_BFu1i_BFu7ll, "BFu0i_BFu1i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu7s  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu1i_BFu7s) C1{ Fi:0 Fi:1 Fs:7}



static void Test_BFu0i_BFu1i_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu7s");
    static BFu0i_BFu1i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1i_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1i_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu7s(Test_BFu0i_BFu1i_BFu7s, "BFu0i_BFu1i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu8c  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu1i_BFu8c) C1{ Fi:0 Fi:1 Fc:8}



static void Test_BFu0i_BFu1i_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu8c");
    static BFu0i_BFu1i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu1i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu1i_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu8c(Test_BFu0i_BFu1i_BFu8c, "BFu0i_BFu1i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu8i  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu1i_BFu8i) C1{ Fi:0 Fi:1 Fi:8}



static void Test_BFu0i_BFu1i_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu8i");
    static BFu0i_BFu1i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0i_BFu1i_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu1i_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu8i(Test_BFu0i_BFu1i_BFu8i, "BFu0i_BFu1i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu8ll  {
  unsigned int  :0;
  unsigned int v1:1;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu1i_BFu8ll) C1{ Fi:0 Fi:1 FL:8}



static void Test_BFu0i_BFu1i_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu8ll");
    static BFu0i_BFu1i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0i_BFu1i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu1i_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu8ll(Test_BFu0i_BFu1i_BFu8ll, "BFu0i_BFu1i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu8s  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu1i_BFu8s) C1{ Fi:0 Fi:1 Fs:8}



static void Test_BFu0i_BFu1i_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu8s");
    static BFu0i_BFu1i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0i_BFu1i_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu1i_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu8s(Test_BFu0i_BFu1i_BFu8s, "BFu0i_BFu1i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu9i  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu1i_BFu9i) C1{ Fi:0 Fi:1 Fi:9}



static void Test_BFu0i_BFu1i_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu9i");
    static BFu0i_BFu1i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0i_BFu1i_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu1i_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu9i(Test_BFu0i_BFu1i_BFu9i, "BFu0i_BFu1i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu9ll  {
  unsigned int  :0;
  unsigned int v1:1;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu1i_BFu9ll) C1{ Fi:0 Fi:1 FL:9}



static void Test_BFu0i_BFu1i_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu9ll");
    static BFu0i_BFu1i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0i_BFu1i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu1i_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu9ll(Test_BFu0i_BFu1i_BFu9ll, "BFu0i_BFu1i_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_BFu9s  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu1i_BFu9s) C1{ Fi:0 Fi:1 Fs:9}



static void Test_BFu0i_BFu1i_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu1i_BFu9s");
    static BFu0i_BFu1i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0i_BFu1i_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu1i_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_BFu9s(Test_BFu0i_BFu1i_BFu9s, "BFu0i_BFu1i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_C  {
  unsigned int  :0;
  unsigned int v1:1;
  char v2;
};
//SIG(1 BFu0i_BFu1i_C) C1{ Fi:0 Fi:1 Fc}



static void Test_BFu0i_BFu1i_C()
{
  {
    init_simple_test("BFu0i_BFu1i_C");
    static BFu0i_BFu1i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_C");
    check_field_offset(lv, v2, 1, "BFu0i_BFu1i_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_C(Test_BFu0i_BFu1i_C, "BFu0i_BFu1i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_D  {
  unsigned int  :0;
  unsigned int v1:1;
  double v2;
};
//SIG(1 BFu0i_BFu1i_D) C1{ Fi:0 Fi:1 FL}



static void Test_BFu0i_BFu1i_D()
{
  {
    init_simple_test("BFu0i_BFu1i_D");
    static BFu0i_BFu1i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu1i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1i_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_D(Test_BFu0i_BFu1i_D, "BFu0i_BFu1i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_F  {
  unsigned int  :0;
  unsigned int v1:1;
  float v2;
};
//SIG(1 BFu0i_BFu1i_F) C1{ Fi:0 Fi:1 Fi}



static void Test_BFu0i_BFu1i_F()
{
  {
    init_simple_test("BFu0i_BFu1i_F");
    static BFu0i_BFu1i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu1i_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_F(Test_BFu0i_BFu1i_F, "BFu0i_BFu1i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_I  {
  unsigned int  :0;
  unsigned int v1:1;
  int v2;
};
//SIG(1 BFu0i_BFu1i_I) C1{ Fi:0 Fi:1 Fi}



static void Test_BFu0i_BFu1i_I()
{
  {
    init_simple_test("BFu0i_BFu1i_I");
    static BFu0i_BFu1i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu1i_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_I(Test_BFu0i_BFu1i_I, "BFu0i_BFu1i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_Ip  {
  unsigned int  :0;
  unsigned int v1:1;
  int *v2;
};
//SIG(1 BFu0i_BFu1i_Ip) C1{ Fi:0 Fi:1 Fp}



static void Test_BFu0i_BFu1i_Ip()
{
  {
    init_simple_test("BFu0i_BFu1i_Ip");
    static BFu0i_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu1i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1i_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_Ip(Test_BFu0i_BFu1i_Ip, "BFu0i_BFu1i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_L  {
  unsigned int  :0;
  unsigned int v1:1;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu1i_L) C1{ Fi:0 Fi:1 FL}



static void Test_BFu0i_BFu1i_L()
{
  {
    init_simple_test("BFu0i_BFu1i_L");
    static BFu0i_BFu1i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu1i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1i_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_L(Test_BFu0i_BFu1i_L, "BFu0i_BFu1i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_S  {
  unsigned int  :0;
  unsigned int v1:1;
  short v2;
};
//SIG(1 BFu0i_BFu1i_S) C1{ Fi:0 Fi:1 Fs}



static void Test_BFu0i_BFu1i_S()
{
  {
    init_simple_test("BFu0i_BFu1i_S");
    static BFu0i_BFu1i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu1i_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_S(Test_BFu0i_BFu1i_S, "BFu0i_BFu1i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_Uc  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu1i_Uc) C1{ Fi:0 Fi:1 Fc}



static void Test_BFu0i_BFu1i_Uc()
{
  {
    init_simple_test("BFu0i_BFu1i_Uc");
    static BFu0i_BFu1i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_Uc");
    check_field_offset(lv, v2, 1, "BFu0i_BFu1i_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_Uc(Test_BFu0i_BFu1i_Uc, "BFu0i_BFu1i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_Ui  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu1i_Ui) C1{ Fi:0 Fi:1 Fi}



static void Test_BFu0i_BFu1i_Ui()
{
  {
    init_simple_test("BFu0i_BFu1i_Ui");
    static BFu0i_BFu1i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu1i_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_Ui(Test_BFu0i_BFu1i_Ui, "BFu0i_BFu1i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_Ul  {
  unsigned int  :0;
  unsigned int v1:1;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu1i_Ul) C1{ Fi:0 Fi:1 FL}



static void Test_BFu0i_BFu1i_Ul()
{
  {
    init_simple_test("BFu0i_BFu1i_Ul");
    static BFu0i_BFu1i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu1i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1i_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_Ul(Test_BFu0i_BFu1i_Ul, "BFu0i_BFu1i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_Us  {
  unsigned int  :0;
  unsigned int v1:1;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu1i_Us) C1{ Fi:0 Fi:1 Fs}



static void Test_BFu0i_BFu1i_Us()
{
  {
    init_simple_test("BFu0i_BFu1i_Us");
    static BFu0i_BFu1i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu1i_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_Us(Test_BFu0i_BFu1i_Us, "BFu0i_BFu1i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1i_Vp  {
  unsigned int  :0;
  unsigned int v1:1;
  void *v2;
};
//SIG(1 BFu0i_BFu1i_Vp) C1{ Fi:0 Fi:1 Fp}



static void Test_BFu0i_BFu1i_Vp()
{
  {
    init_simple_test("BFu0i_BFu1i_Vp");
    static BFu0i_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu1i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1i_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1i_Vp(Test_BFu0i_BFu1i_Vp, "BFu0i_BFu1i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll  {
  unsigned int  :0;
  __tsu64 v1:1;
};
//SIG(1 BFu0i_BFu1ll) C1{ Fi:0 FL:1}



static void Test_BFu0i_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu1ll");
    static BFu0i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll(Test_BFu0i_BFu1ll, "BFu0i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu0c  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu1ll_BFu0c) C1{ Fi:0 FL:1 Fc:0}



static void Test_BFu0i_BFu1ll_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu0c");
    static BFu0i_BFu1ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu0c(Test_BFu0i_BFu1ll_BFu0c, "BFu0i_BFu1ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu0i  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu1ll_BFu0i) C1{ Fi:0 FL:1 Fi:0}



static void Test_BFu0i_BFu1ll_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu0i");
    static BFu0i_BFu1ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu0i(Test_BFu0i_BFu1ll_BFu0i, "BFu0i_BFu1ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu0ll  {
  unsigned int  :0;
  __tsu64 v1:1;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu1ll_BFu0ll) C1{ Fi:0 FL:1 FL:0}



static void Test_BFu0i_BFu1ll_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu0ll");
    static BFu0i_BFu1ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu0ll(Test_BFu0i_BFu1ll_BFu0ll, "BFu0i_BFu1ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu0s  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu1ll_BFu0s) C1{ Fi:0 FL:1 Fs:0}



static void Test_BFu0i_BFu1ll_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu0s");
    static BFu0i_BFu1ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu0s(Test_BFu0i_BFu1ll_BFu0s, "BFu0i_BFu1ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu15i  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu1ll_BFu15i) C1{ Fi:0 FL:1 Fi:15}



static void Test_BFu0i_BFu1ll_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu15i");
    static BFu0i_BFu1ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0i_BFu1ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu1ll_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu15i(Test_BFu0i_BFu1ll_BFu15i, "BFu0i_BFu1ll_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu15ll  {
  unsigned int  :0;
  __tsu64 v1:1;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu1ll_BFu15ll) C1{ Fi:0 FL:1 FL:15}



static void Test_BFu0i_BFu1ll_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu15ll");
    static BFu0i_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0i_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu1ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu15ll(Test_BFu0i_BFu1ll_BFu15ll, "BFu0i_BFu1ll_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu15s  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu1ll_BFu15s) C1{ Fi:0 FL:1 Fs:15}



static void Test_BFu0i_BFu1ll_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu15s");
    static BFu0i_BFu1ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0i_BFu1ll_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu1ll_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu15s(Test_BFu0i_BFu1ll_BFu15s, "BFu0i_BFu1ll_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu16i  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu1ll_BFu16i) C1{ Fi:0 FL:1 Fi:16}



static void Test_BFu0i_BFu1ll_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu16i");
    static BFu0i_BFu1ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu0i_BFu1ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu0i_BFu1ll_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu16i(Test_BFu0i_BFu1ll_BFu16i, "BFu0i_BFu1ll_BFu16i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu16ll  {
  unsigned int  :0;
  __tsu64 v1:1;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu1ll_BFu16ll) C1{ Fi:0 FL:1 FL:16}



static void Test_BFu0i_BFu1ll_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu16ll");
    static BFu0i_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu0i_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu0i_BFu1ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu16ll(Test_BFu0i_BFu1ll_BFu16ll, "BFu0i_BFu1ll_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu16s  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu1ll_BFu16s) C1{ Fi:0 FL:1 Fs:16}



static void Test_BFu0i_BFu1ll_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu16s");
    static BFu0i_BFu1ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_BFu1ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu1ll_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu16s(Test_BFu0i_BFu1ll_BFu16s, "BFu0i_BFu1ll_BFu16s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu17i  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu1ll_BFu17i) C1{ Fi:0 FL:1 Fi:17}



static void Test_BFu0i_BFu1ll_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu17i");
    static BFu0i_BFu1ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu0i_BFu1ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu0i_BFu1ll_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu17i(Test_BFu0i_BFu1ll_BFu17i, "BFu0i_BFu1ll_BFu17i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu17ll  {
  unsigned int  :0;
  __tsu64 v1:1;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu1ll_BFu17ll) C1{ Fi:0 FL:1 FL:17}



static void Test_BFu0i_BFu1ll_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu17ll");
    static BFu0i_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu0i_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu0i_BFu1ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu17ll(Test_BFu0i_BFu1ll_BFu17ll, "BFu0i_BFu1ll_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu1c  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu1ll_BFu1c) C1{ Fi:0 FL:1 Fc:1}



static void Test_BFu0i_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu1c");
    static BFu0i_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1ll_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu1c(Test_BFu0i_BFu1ll_BFu1c, "BFu0i_BFu1ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu1i  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu1ll_BFu1i) C1{ Fi:0 FL:1 Fi:1}



static void Test_BFu0i_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu1i");
    static BFu0i_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1ll_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu1i(Test_BFu0i_BFu1ll_BFu1i, "BFu0i_BFu1ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu1ll  {
  unsigned int  :0;
  __tsu64 v1:1;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu1ll_BFu1ll) C1{ Fi:0 FL:1 FL:1}



static void Test_BFu0i_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu1ll");
    static BFu0i_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu1ll(Test_BFu0i_BFu1ll_BFu1ll, "BFu0i_BFu1ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu1s  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu1ll_BFu1s) C1{ Fi:0 FL:1 Fs:1}



static void Test_BFu0i_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu1s");
    static BFu0i_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1ll_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu1s(Test_BFu0i_BFu1ll_BFu1s, "BFu0i_BFu1ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu31i  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu1ll_BFu31i) C1{ Fi:0 FL:1 Fi:31}



static void Test_BFu0i_BFu1ll_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu31i");
    static BFu0i_BFu1ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0i_BFu1ll_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0i_BFu1ll_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu31i(Test_BFu0i_BFu1ll_BFu31i, "BFu0i_BFu1ll_BFu31i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu31ll  {
  unsigned int  :0;
  __tsu64 v1:1;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu1ll_BFu31ll) C1{ Fi:0 FL:1 FL:31}



static void Test_BFu0i_BFu1ll_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu31ll");
    static BFu0i_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0i_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0i_BFu1ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu31ll(Test_BFu0i_BFu1ll_BFu31ll, "BFu0i_BFu1ll_BFu31ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu32i  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu1ll_BFu32i) C1{ Fi:0 FL:1 Fi:32}



static void Test_BFu0i_BFu1ll_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu32i");
    static BFu0i_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu1ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu1ll_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu32i(Test_BFu0i_BFu1ll_BFu32i, "BFu0i_BFu1ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu32ll  {
  unsigned int  :0;
  __tsu64 v1:1;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu1ll_BFu32ll) C1{ Fi:0 FL:1 FL:32}



static void Test_BFu0i_BFu1ll_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu32ll");
    static BFu0i_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu0i_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu0i_BFu1ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu32ll(Test_BFu0i_BFu1ll_BFu32ll, "BFu0i_BFu1ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu33  {
  unsigned int  :0;
  __tsu64 v1:1;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu1ll_BFu33) C1{ Fi:0 FL:1 FL:33}



static void Test_BFu0i_BFu1ll_BFu33()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu33");
    static BFu0i_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu0i_BFu1ll_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu0i_BFu1ll_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu33(Test_BFu0i_BFu1ll_BFu33, "BFu0i_BFu1ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu7c  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu1ll_BFu7c) C1{ Fi:0 FL:1 Fc:7}



static void Test_BFu0i_BFu1ll_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu7c");
    static BFu0i_BFu1ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1ll_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1ll_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu7c(Test_BFu0i_BFu1ll_BFu7c, "BFu0i_BFu1ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu7i  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu1ll_BFu7i) C1{ Fi:0 FL:1 Fi:7}



static void Test_BFu0i_BFu1ll_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu7i");
    static BFu0i_BFu1ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1ll_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu7i(Test_BFu0i_BFu1ll_BFu7i, "BFu0i_BFu1ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu7ll  {
  unsigned int  :0;
  __tsu64 v1:1;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu1ll_BFu7ll) C1{ Fi:0 FL:1 FL:7}



static void Test_BFu0i_BFu1ll_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu7ll");
    static BFu0i_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu7ll(Test_BFu0i_BFu1ll_BFu7ll, "BFu0i_BFu1ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu7s  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu1ll_BFu7s) C1{ Fi:0 FL:1 Fs:7}



static void Test_BFu0i_BFu1ll_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu7s");
    static BFu0i_BFu1ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1ll_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu7s(Test_BFu0i_BFu1ll_BFu7s, "BFu0i_BFu1ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu8c  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu1ll_BFu8c) C1{ Fi:0 FL:1 Fc:8}



static void Test_BFu0i_BFu1ll_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu8c");
    static BFu0i_BFu1ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu1ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu1ll_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu8c(Test_BFu0i_BFu1ll_BFu8c, "BFu0i_BFu1ll_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu8i  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu1ll_BFu8i) C1{ Fi:0 FL:1 Fi:8}



static void Test_BFu0i_BFu1ll_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu8i");
    static BFu0i_BFu1ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0i_BFu1ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu1ll_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu8i(Test_BFu0i_BFu1ll_BFu8i, "BFu0i_BFu1ll_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu8ll  {
  unsigned int  :0;
  __tsu64 v1:1;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu1ll_BFu8ll) C1{ Fi:0 FL:1 FL:8}



static void Test_BFu0i_BFu1ll_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu8ll");
    static BFu0i_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0i_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu1ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu8ll(Test_BFu0i_BFu1ll_BFu8ll, "BFu0i_BFu1ll_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu8s  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu1ll_BFu8s) C1{ Fi:0 FL:1 Fs:8}



static void Test_BFu0i_BFu1ll_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu8s");
    static BFu0i_BFu1ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0i_BFu1ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu1ll_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu8s(Test_BFu0i_BFu1ll_BFu8s, "BFu0i_BFu1ll_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu9i  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu1ll_BFu9i) C1{ Fi:0 FL:1 Fi:9}



static void Test_BFu0i_BFu1ll_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu9i");
    static BFu0i_BFu1ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0i_BFu1ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu1ll_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu9i(Test_BFu0i_BFu1ll_BFu9i, "BFu0i_BFu1ll_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu9ll  {
  unsigned int  :0;
  __tsu64 v1:1;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu1ll_BFu9ll) C1{ Fi:0 FL:1 FL:9}



static void Test_BFu0i_BFu1ll_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu9ll");
    static BFu0i_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0i_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu1ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu9ll(Test_BFu0i_BFu1ll_BFu9ll, "BFu0i_BFu1ll_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_BFu9s  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu1ll_BFu9s) C1{ Fi:0 FL:1 Fs:9}



static void Test_BFu0i_BFu1ll_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu1ll_BFu9s");
    static BFu0i_BFu1ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0i_BFu1ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu1ll_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_BFu9s(Test_BFu0i_BFu1ll_BFu9s, "BFu0i_BFu1ll_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_C  {
  unsigned int  :0;
  __tsu64 v1:1;
  char v2;
};
//SIG(1 BFu0i_BFu1ll_C) C1{ Fi:0 FL:1 Fc}



static void Test_BFu0i_BFu1ll_C()
{
  {
    init_simple_test("BFu0i_BFu1ll_C");
    static BFu0i_BFu1ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_C");
    check_field_offset(lv, v2, 1, "BFu0i_BFu1ll_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_C(Test_BFu0i_BFu1ll_C, "BFu0i_BFu1ll_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_D  {
  unsigned int  :0;
  __tsu64 v1:1;
  double v2;
};
//SIG(1 BFu0i_BFu1ll_D) C1{ Fi:0 FL:1 FL}



static void Test_BFu0i_BFu1ll_D()
{
  {
    init_simple_test("BFu0i_BFu1ll_D");
    static BFu0i_BFu1ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu1ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1ll_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_D(Test_BFu0i_BFu1ll_D, "BFu0i_BFu1ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_F  {
  unsigned int  :0;
  __tsu64 v1:1;
  float v2;
};
//SIG(1 BFu0i_BFu1ll_F) C1{ Fi:0 FL:1 Fi}



static void Test_BFu0i_BFu1ll_F()
{
  {
    init_simple_test("BFu0i_BFu1ll_F");
    static BFu0i_BFu1ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu1ll_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_F(Test_BFu0i_BFu1ll_F, "BFu0i_BFu1ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_I  {
  unsigned int  :0;
  __tsu64 v1:1;
  int v2;
};
//SIG(1 BFu0i_BFu1ll_I) C1{ Fi:0 FL:1 Fi}



static void Test_BFu0i_BFu1ll_I()
{
  {
    init_simple_test("BFu0i_BFu1ll_I");
    static BFu0i_BFu1ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu1ll_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_I(Test_BFu0i_BFu1ll_I, "BFu0i_BFu1ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_Ip  {
  unsigned int  :0;
  __tsu64 v1:1;
  int *v2;
};
//SIG(1 BFu0i_BFu1ll_Ip) C1{ Fi:0 FL:1 Fp}



static void Test_BFu0i_BFu1ll_Ip()
{
  {
    init_simple_test("BFu0i_BFu1ll_Ip");
    static BFu0i_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu1ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_Ip(Test_BFu0i_BFu1ll_Ip, "BFu0i_BFu1ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_L  {
  unsigned int  :0;
  __tsu64 v1:1;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu1ll_L) C1{ Fi:0 FL:1 FL}



static void Test_BFu0i_BFu1ll_L()
{
  {
    init_simple_test("BFu0i_BFu1ll_L");
    static BFu0i_BFu1ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu1ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1ll_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_L(Test_BFu0i_BFu1ll_L, "BFu0i_BFu1ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_S  {
  unsigned int  :0;
  __tsu64 v1:1;
  short v2;
};
//SIG(1 BFu0i_BFu1ll_S) C1{ Fi:0 FL:1 Fs}



static void Test_BFu0i_BFu1ll_S()
{
  {
    init_simple_test("BFu0i_BFu1ll_S");
    static BFu0i_BFu1ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu1ll_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_S(Test_BFu0i_BFu1ll_S, "BFu0i_BFu1ll_S", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_Uc  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu1ll_Uc) C1{ Fi:0 FL:1 Fc}



static void Test_BFu0i_BFu1ll_Uc()
{
  {
    init_simple_test("BFu0i_BFu1ll_Uc");
    static BFu0i_BFu1ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_Uc");
    check_field_offset(lv, v2, 1, "BFu0i_BFu1ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_Uc(Test_BFu0i_BFu1ll_Uc, "BFu0i_BFu1ll_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_Ui  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu1ll_Ui) C1{ Fi:0 FL:1 Fi}



static void Test_BFu0i_BFu1ll_Ui()
{
  {
    init_simple_test("BFu0i_BFu1ll_Ui");
    static BFu0i_BFu1ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu1ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_Ui(Test_BFu0i_BFu1ll_Ui, "BFu0i_BFu1ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_Ul  {
  unsigned int  :0;
  __tsu64 v1:1;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu1ll_Ul) C1{ Fi:0 FL:1 FL}



static void Test_BFu0i_BFu1ll_Ul()
{
  {
    init_simple_test("BFu0i_BFu1ll_Ul");
    static BFu0i_BFu1ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu1ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_Ul(Test_BFu0i_BFu1ll_Ul, "BFu0i_BFu1ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_Us  {
  unsigned int  :0;
  __tsu64 v1:1;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu1ll_Us) C1{ Fi:0 FL:1 Fs}



static void Test_BFu0i_BFu1ll_Us()
{
  {
    init_simple_test("BFu0i_BFu1ll_Us");
    static BFu0i_BFu1ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu1ll_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_Us(Test_BFu0i_BFu1ll_Us, "BFu0i_BFu1ll_Us", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1ll_Vp  {
  unsigned int  :0;
  __tsu64 v1:1;
  void *v2;
};
//SIG(1 BFu0i_BFu1ll_Vp) C1{ Fi:0 FL:1 Fp}



static void Test_BFu0i_BFu1ll_Vp()
{
  {
    init_simple_test("BFu0i_BFu1ll_Vp");
    static BFu0i_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu1ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1ll_Vp(Test_BFu0i_BFu1ll_Vp, "BFu0i_BFu1ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s  {
  unsigned int  :0;
  unsigned short v1:1;
};
//SIG(1 BFu0i_BFu1s) C1{ Fi:0 Fs:1}



static void Test_BFu0i_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu1s");
    static BFu0i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s(Test_BFu0i_BFu1s, "BFu0i_BFu1s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu0c  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu1s_BFu0c) C1{ Fi:0 Fs:1 Fc:0}



static void Test_BFu0i_BFu1s_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu0c");
    static BFu0i_BFu1s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu0c(Test_BFu0i_BFu1s_BFu0c, "BFu0i_BFu1s_BFu0c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu0i  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu1s_BFu0i) C1{ Fi:0 Fs:1 Fi:0}



static void Test_BFu0i_BFu1s_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu0i");
    static BFu0i_BFu1s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu0i(Test_BFu0i_BFu1s_BFu0i, "BFu0i_BFu1s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu0ll  {
  unsigned int  :0;
  unsigned short v1:1;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu1s_BFu0ll) C1{ Fi:0 Fs:1 FL:0}



static void Test_BFu0i_BFu1s_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu0ll");
    static BFu0i_BFu1s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu0ll(Test_BFu0i_BFu1s_BFu0ll, "BFu0i_BFu1s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu0s  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu1s_BFu0s) C1{ Fi:0 Fs:1 Fs:0}



static void Test_BFu0i_BFu1s_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu0s");
    static BFu0i_BFu1s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu0s(Test_BFu0i_BFu1s_BFu0s, "BFu0i_BFu1s_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu15i  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu1s_BFu15i) C1{ Fi:0 Fs:1 Fi:15}



static void Test_BFu0i_BFu1s_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu15i");
    static BFu0i_BFu1s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0i_BFu1s_BFu15i");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu1s_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu15i(Test_BFu0i_BFu1s_BFu15i, "BFu0i_BFu1s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu15ll  {
  unsigned int  :0;
  unsigned short v1:1;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu1s_BFu15ll) C1{ Fi:0 Fs:1 FL:15}



static void Test_BFu0i_BFu1s_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu15ll");
    static BFu0i_BFu1s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0i_BFu1s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu1s_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu15ll(Test_BFu0i_BFu1s_BFu15ll, "BFu0i_BFu1s_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu15s  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu1s_BFu15s) C1{ Fi:0 Fs:1 Fs:15}



static void Test_BFu0i_BFu1s_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu15s");
    static BFu0i_BFu1s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu0i_BFu1s_BFu15s");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu1s_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu15s(Test_BFu0i_BFu1s_BFu15s, "BFu0i_BFu1s_BFu15s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu16i  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu1s_BFu16i) C1{ Fi:0 Fs:1 Fi:16}



static void Test_BFu0i_BFu1s_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu16i");
    static BFu0i_BFu1s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu0i_BFu1s_BFu16i");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu0i_BFu1s_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu16i(Test_BFu0i_BFu1s_BFu16i, "BFu0i_BFu1s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu16ll  {
  unsigned int  :0;
  unsigned short v1:1;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu1s_BFu16ll) C1{ Fi:0 Fs:1 FL:16}



static void Test_BFu0i_BFu1s_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu16ll");
    static BFu0i_BFu1s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu0i_BFu1s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu0i_BFu1s_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu16ll(Test_BFu0i_BFu1s_BFu16ll, "BFu0i_BFu1s_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu16s  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu1s_BFu16s) C1{ Fi:0 Fs:1 Fs:16}



static void Test_BFu0i_BFu1s_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu16s");
    static BFu0i_BFu1s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_BFu1s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu1s_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu16s(Test_BFu0i_BFu1s_BFu16s, "BFu0i_BFu1s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu17i  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu1s_BFu17i) C1{ Fi:0 Fs:1 Fi:17}



static void Test_BFu0i_BFu1s_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu17i");
    static BFu0i_BFu1s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu0i_BFu1s_BFu17i");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu0i_BFu1s_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu17i(Test_BFu0i_BFu1s_BFu17i, "BFu0i_BFu1s_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu17ll  {
  unsigned int  :0;
  unsigned short v1:1;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu1s_BFu17ll) C1{ Fi:0 Fs:1 FL:17}



static void Test_BFu0i_BFu1s_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu17ll");
    static BFu0i_BFu1s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu0i_BFu1s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu0i_BFu1s_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu17ll(Test_BFu0i_BFu1s_BFu17ll, "BFu0i_BFu1s_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu1c  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu1s_BFu1c) C1{ Fi:0 Fs:1 Fc:1}



static void Test_BFu0i_BFu1s_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu1c");
    static BFu0i_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1s_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu1c(Test_BFu0i_BFu1s_BFu1c, "BFu0i_BFu1s_BFu1c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu1i  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu1s_BFu1i) C1{ Fi:0 Fs:1 Fi:1}



static void Test_BFu0i_BFu1s_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu1i");
    static BFu0i_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1s_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu1i(Test_BFu0i_BFu1s_BFu1i, "BFu0i_BFu1s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu1ll  {
  unsigned int  :0;
  unsigned short v1:1;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu1s_BFu1ll) C1{ Fi:0 Fs:1 FL:1}



static void Test_BFu0i_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu1ll");
    static BFu0i_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1s_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu1ll(Test_BFu0i_BFu1s_BFu1ll, "BFu0i_BFu1s_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu1s  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu1s_BFu1s) C1{ Fi:0 Fs:1 Fs:1}



static void Test_BFu0i_BFu1s_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu1s");
    static BFu0i_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu0i_BFu1s_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu1s(Test_BFu0i_BFu1s_BFu1s, "BFu0i_BFu1s_BFu1s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu31i  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu1s_BFu31i) C1{ Fi:0 Fs:1 Fi:31}



static void Test_BFu0i_BFu1s_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu31i");
    static BFu0i_BFu1s_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0i_BFu1s_BFu31i");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0i_BFu1s_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu31i(Test_BFu0i_BFu1s_BFu31i, "BFu0i_BFu1s_BFu31i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu31ll  {
  unsigned int  :0;
  unsigned short v1:1;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu1s_BFu31ll) C1{ Fi:0 Fs:1 FL:31}



static void Test_BFu0i_BFu1s_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu31ll");
    static BFu0i_BFu1s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu0i_BFu1s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu0i_BFu1s_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu31ll(Test_BFu0i_BFu1s_BFu31ll, "BFu0i_BFu1s_BFu31ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu32i  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu1s_BFu32i) C1{ Fi:0 Fs:1 Fi:32}



static void Test_BFu0i_BFu1s_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu32i");
    static BFu0i_BFu1s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu1s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu1s_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu32i(Test_BFu0i_BFu1s_BFu32i, "BFu0i_BFu1s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu32ll  {
  unsigned int  :0;
  unsigned short v1:1;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu1s_BFu32ll) C1{ Fi:0 Fs:1 FL:32}



static void Test_BFu0i_BFu1s_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu32ll");
    static BFu0i_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu0i_BFu1s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu0i_BFu1s_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu32ll(Test_BFu0i_BFu1s_BFu32ll, "BFu0i_BFu1s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu33  {
  unsigned int  :0;
  unsigned short v1:1;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu1s_BFu33) C1{ Fi:0 Fs:1 FL:33}



static void Test_BFu0i_BFu1s_BFu33()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu33");
    static BFu0i_BFu1s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu0i_BFu1s_BFu33");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu0i_BFu1s_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu33(Test_BFu0i_BFu1s_BFu33, "BFu0i_BFu1s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu7c  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu1s_BFu7c) C1{ Fi:0 Fs:1 Fc:7}



static void Test_BFu0i_BFu1s_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu7c");
    static BFu0i_BFu1s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1s_BFu7c");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1s_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu7c(Test_BFu0i_BFu1s_BFu7c, "BFu0i_BFu1s_BFu7c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu7i  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu1s_BFu7i) C1{ Fi:0 Fs:1 Fi:7}



static void Test_BFu0i_BFu1s_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu7i");
    static BFu0i_BFu1s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1s_BFu7i");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1s_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu7i(Test_BFu0i_BFu1s_BFu7i, "BFu0i_BFu1s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu7ll  {
  unsigned int  :0;
  unsigned short v1:1;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu1s_BFu7ll) C1{ Fi:0 Fs:1 FL:7}



static void Test_BFu0i_BFu1s_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu7ll");
    static BFu0i_BFu1s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1s_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu7ll(Test_BFu0i_BFu1s_BFu7ll, "BFu0i_BFu1s_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu7s  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu1s_BFu7s) C1{ Fi:0 Fs:1 Fs:7}



static void Test_BFu0i_BFu1s_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu7s");
    static BFu0i_BFu1s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu0i_BFu1s_BFu7s");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu1s_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu7s(Test_BFu0i_BFu1s_BFu7s, "BFu0i_BFu1s_BFu7s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu8c  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu1s_BFu8c) C1{ Fi:0 Fs:1 Fc:8}



static void Test_BFu0i_BFu1s_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu8c");
    static BFu0i_BFu1s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu1s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu1s_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu8c(Test_BFu0i_BFu1s_BFu8c, "BFu0i_BFu1s_BFu8c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu8i  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu1s_BFu8i) C1{ Fi:0 Fs:1 Fi:8}



static void Test_BFu0i_BFu1s_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu8i");
    static BFu0i_BFu1s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0i_BFu1s_BFu8i");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu1s_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu8i(Test_BFu0i_BFu1s_BFu8i, "BFu0i_BFu1s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu8ll  {
  unsigned int  :0;
  unsigned short v1:1;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu1s_BFu8ll) C1{ Fi:0 Fs:1 FL:8}



static void Test_BFu0i_BFu1s_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu8ll");
    static BFu0i_BFu1s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0i_BFu1s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu1s_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu8ll(Test_BFu0i_BFu1s_BFu8ll, "BFu0i_BFu1s_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu8s  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu1s_BFu8s) C1{ Fi:0 Fs:1 Fs:8}



static void Test_BFu0i_BFu1s_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu8s");
    static BFu0i_BFu1s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu0i_BFu1s_BFu8s");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu1s_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu8s(Test_BFu0i_BFu1s_BFu8s, "BFu0i_BFu1s_BFu8s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu9i  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu1s_BFu9i) C1{ Fi:0 Fs:1 Fi:9}



static void Test_BFu0i_BFu1s_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu9i");
    static BFu0i_BFu1s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0i_BFu1s_BFu9i");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu1s_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu9i(Test_BFu0i_BFu1s_BFu9i, "BFu0i_BFu1s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu9ll  {
  unsigned int  :0;
  unsigned short v1:1;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu1s_BFu9ll) C1{ Fi:0 Fs:1 FL:9}



static void Test_BFu0i_BFu1s_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu9ll");
    static BFu0i_BFu1s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu1s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0i_BFu1s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu1s_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu9ll(Test_BFu0i_BFu1s_BFu9ll, "BFu0i_BFu1s_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_BFu9s  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu1s_BFu9s) C1{ Fi:0 Fs:1 Fs:9}



static void Test_BFu0i_BFu1s_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu1s_BFu9s");
    static BFu0i_BFu1s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu0i_BFu1s_BFu9s");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu1s_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_BFu9s(Test_BFu0i_BFu1s_BFu9s, "BFu0i_BFu1s_BFu9s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_C  {
  unsigned int  :0;
  unsigned short v1:1;
  char v2;
};
//SIG(1 BFu0i_BFu1s_C) C1{ Fi:0 Fs:1 Fc}



static void Test_BFu0i_BFu1s_C()
{
  {
    init_simple_test("BFu0i_BFu1s_C");
    static BFu0i_BFu1s_C lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1s_C)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_C");
    check_field_offset(lv, v2, 1, "BFu0i_BFu1s_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_C(Test_BFu0i_BFu1s_C, "BFu0i_BFu1s_C", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_D  {
  unsigned int  :0;
  unsigned short v1:1;
  double v2;
};
//SIG(1 BFu0i_BFu1s_D) C1{ Fi:0 Fs:1 FL}



static void Test_BFu0i_BFu1s_D()
{
  {
    init_simple_test("BFu0i_BFu1s_D");
    static BFu0i_BFu1s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu1s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1s_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_D(Test_BFu0i_BFu1s_D, "BFu0i_BFu1s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_F  {
  unsigned int  :0;
  unsigned short v1:1;
  float v2;
};
//SIG(1 BFu0i_BFu1s_F) C1{ Fi:0 Fs:1 Fi}



static void Test_BFu0i_BFu1s_F()
{
  {
    init_simple_test("BFu0i_BFu1s_F");
    static BFu0i_BFu1s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1s_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu1s_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_F(Test_BFu0i_BFu1s_F, "BFu0i_BFu1s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_I  {
  unsigned int  :0;
  unsigned short v1:1;
  int v2;
};
//SIG(1 BFu0i_BFu1s_I) C1{ Fi:0 Fs:1 Fi}



static void Test_BFu0i_BFu1s_I()
{
  {
    init_simple_test("BFu0i_BFu1s_I");
    static BFu0i_BFu1s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1s_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu1s_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_I(Test_BFu0i_BFu1s_I, "BFu0i_BFu1s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_Ip  {
  unsigned int  :0;
  unsigned short v1:1;
  int *v2;
};
//SIG(1 BFu0i_BFu1s_Ip) C1{ Fi:0 Fs:1 Fp}



static void Test_BFu0i_BFu1s_Ip()
{
  {
    init_simple_test("BFu0i_BFu1s_Ip");
    static BFu0i_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu1s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1s_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_Ip(Test_BFu0i_BFu1s_Ip, "BFu0i_BFu1s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_L  {
  unsigned int  :0;
  unsigned short v1:1;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu1s_L) C1{ Fi:0 Fs:1 FL}



static void Test_BFu0i_BFu1s_L()
{
  {
    init_simple_test("BFu0i_BFu1s_L");
    static BFu0i_BFu1s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu1s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1s_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_L(Test_BFu0i_BFu1s_L, "BFu0i_BFu1s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_S  {
  unsigned int  :0;
  unsigned short v1:1;
  short v2;
};
//SIG(1 BFu0i_BFu1s_S) C1{ Fi:0 Fs:1 Fs}



static void Test_BFu0i_BFu1s_S()
{
  {
    init_simple_test("BFu0i_BFu1s_S");
    static BFu0i_BFu1s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1s_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu1s_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_S(Test_BFu0i_BFu1s_S, "BFu0i_BFu1s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_Uc  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu1s_Uc) C1{ Fi:0 Fs:1 Fc}



static void Test_BFu0i_BFu1s_Uc()
{
  {
    init_simple_test("BFu0i_BFu1s_Uc");
    static BFu0i_BFu1s_Uc lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu1s_Uc)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_Uc");
    check_field_offset(lv, v2, 1, "BFu0i_BFu1s_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_Uc(Test_BFu0i_BFu1s_Uc, "BFu0i_BFu1s_Uc", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_Ui  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu1s_Ui) C1{ Fi:0 Fs:1 Fi}



static void Test_BFu0i_BFu1s_Ui()
{
  {
    init_simple_test("BFu0i_BFu1s_Ui");
    static BFu0i_BFu1s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu1s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu1s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu1s_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_Ui(Test_BFu0i_BFu1s_Ui, "BFu0i_BFu1s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_Ul  {
  unsigned int  :0;
  unsigned short v1:1;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu1s_Ul) C1{ Fi:0 Fs:1 FL}



static void Test_BFu0i_BFu1s_Ul()
{
  {
    init_simple_test("BFu0i_BFu1s_Ul");
    static BFu0i_BFu1s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu1s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1s_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_Ul(Test_BFu0i_BFu1s_Ul, "BFu0i_BFu1s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_Us  {
  unsigned int  :0;
  unsigned short v1:1;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu1s_Us) C1{ Fi:0 Fs:1 Fs}



static void Test_BFu0i_BFu1s_Us()
{
  {
    init_simple_test("BFu0i_BFu1s_Us");
    static BFu0i_BFu1s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu1s_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu1s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu1s_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_Us(Test_BFu0i_BFu1s_Us, "BFu0i_BFu1s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu1s_Vp  {
  unsigned int  :0;
  unsigned short v1:1;
  void *v2;
};
//SIG(1 BFu0i_BFu1s_Vp) C1{ Fi:0 Fs:1 Fp}



static void Test_BFu0i_BFu1s_Vp()
{
  {
    init_simple_test("BFu0i_BFu1s_Vp");
    static BFu0i_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu1s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu1s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu0i_BFu1s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu1s_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu1s_Vp(Test_BFu0i_BFu1s_Vp, "BFu0i_BFu1s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i  {
  unsigned int  :0;
  unsigned int v1:31;
};
//SIG(1 BFu0i_BFu31i) C1{ Fi:0 Fi:31}



static void Test_BFu0i_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu31i");
    static BFu0i_BFu31i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i(Test_BFu0i_BFu31i, "BFu0i_BFu31i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu0c  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu31i_BFu0c) C1{ Fi:0 Fi:31 Fc:0}



static void Test_BFu0i_BFu31i_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu0c");
    static BFu0i_BFu31i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu31i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu0c(Test_BFu0i_BFu31i_BFu0c, "BFu0i_BFu31i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu0i  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu31i_BFu0i) C1{ Fi:0 Fi:31 Fi:0}



static void Test_BFu0i_BFu31i_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu0i");
    static BFu0i_BFu31i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu31i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu0i(Test_BFu0i_BFu31i_BFu0i, "BFu0i_BFu31i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu0ll  {
  unsigned int  :0;
  unsigned int v1:31;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu31i_BFu0ll) C1{ Fi:0 Fi:31 FL:0}



static void Test_BFu0i_BFu31i_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu0ll");
    static BFu0i_BFu31i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu31i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0i_BFu31i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu0ll(Test_BFu0i_BFu31i_BFu0ll, "BFu0i_BFu31i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu0s  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu31i_BFu0s) C1{ Fi:0 Fi:31 Fs:0}



static void Test_BFu0i_BFu31i_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu0s");
    static BFu0i_BFu31i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu31i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu0s(Test_BFu0i_BFu31i_BFu0s, "BFu0i_BFu31i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu15i  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu31i_BFu15i) C1{ Fi:0 Fi:31 Fi:15}



static void Test_BFu0i_BFu31i_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu15i");
    static BFu0i_BFu31i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu31i_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu15i(Test_BFu0i_BFu31i_BFu15i, "BFu0i_BFu31i_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu15ll  {
  unsigned int  :0;
  unsigned int v1:31;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu31i_BFu15ll) C1{ Fi:0 Fi:31 FL:15}



static void Test_BFu0i_BFu31i_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu15ll");
    static BFu0i_BFu31i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 3, 7, 15, 1, "BFu0i_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 3, 7, 15, hide_ull(1LL<<14), "BFu0i_BFu31i_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu15ll(Test_BFu0i_BFu31i_BFu15ll, "BFu0i_BFu31i_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu15s  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu31i_BFu15s) C1{ Fi:0 Fi:31 Fs:15}



static void Test_BFu0i_BFu31i_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu15s");
    static BFu0i_BFu31i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu31i_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu15s(Test_BFu0i_BFu31i_BFu15s, "BFu0i_BFu31i_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu16i  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu31i_BFu16i) C1{ Fi:0 Fi:31 Fi:16}



static void Test_BFu0i_BFu31i_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu16i");
    static BFu0i_BFu31i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu31i_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu16i(Test_BFu0i_BFu31i_BFu16i, "BFu0i_BFu31i_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu16ll  {
  unsigned int  :0;
  unsigned int v1:31;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu31i_BFu16ll) C1{ Fi:0 Fi:31 FL:16}



static void Test_BFu0i_BFu31i_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu16ll");
    static BFu0i_BFu31i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 3, 7, 16, 1, "BFu0i_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 3, 7, 16, hide_ull(1LL<<15), "BFu0i_BFu31i_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu16ll(Test_BFu0i_BFu31i_BFu16ll, "BFu0i_BFu31i_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu16s  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu31i_BFu16s) C1{ Fi:0 Fi:31 Fs:16}



static void Test_BFu0i_BFu31i_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu16s");
    static BFu0i_BFu31i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu31i_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu16s(Test_BFu0i_BFu31i_BFu16s, "BFu0i_BFu31i_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu17i  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu31i_BFu17i) C1{ Fi:0 Fi:31 Fi:17}



static void Test_BFu0i_BFu31i_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu17i");
    static BFu0i_BFu31i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0i_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu31i_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu17i(Test_BFu0i_BFu31i_BFu17i, "BFu0i_BFu31i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu17ll  {
  unsigned int  :0;
  unsigned int v1:31;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu31i_BFu17ll) C1{ Fi:0 Fi:31 FL:17}



static void Test_BFu0i_BFu31i_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu17ll");
    static BFu0i_BFu31i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 3, 7, 17, 1, "BFu0i_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 3, 7, 17, hide_ull(1LL<<16), "BFu0i_BFu31i_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu17ll(Test_BFu0i_BFu31i_BFu17ll, "BFu0i_BFu31i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu1c  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu31i_BFu1c) C1{ Fi:0 Fi:31 Fc:1}



static void Test_BFu0i_BFu31i_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu1c");
    static BFu0i_BFu31i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu31i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0i_BFu31i_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu1c(Test_BFu0i_BFu31i_BFu1c, "BFu0i_BFu31i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu1i  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu31i_BFu1i) C1{ Fi:0 Fi:31 Fi:1}



static void Test_BFu0i_BFu31i_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu1i");
    static BFu0i_BFu31i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu31i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0i_BFu31i_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu1i(Test_BFu0i_BFu31i_BFu1i, "BFu0i_BFu31i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu1ll  {
  unsigned int  :0;
  unsigned int v1:31;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu31i_BFu1ll) C1{ Fi:0 Fi:31 FL:1}



static void Test_BFu0i_BFu31i_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu1ll");
    static BFu0i_BFu31i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu31i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0i_BFu31i_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu1ll(Test_BFu0i_BFu31i_BFu1ll, "BFu0i_BFu31i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu1s  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu31i_BFu1s) C1{ Fi:0 Fi:31 Fs:1}



static void Test_BFu0i_BFu31i_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu1s");
    static BFu0i_BFu31i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu31i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0i_BFu31i_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu1s(Test_BFu0i_BFu31i_BFu1s, "BFu0i_BFu31i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu31i  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu31i_BFu31i) C1{ Fi:0 Fi:31 Fi:31}



static void Test_BFu0i_BFu31i_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu31i");
    static BFu0i_BFu31i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu31i(Test_BFu0i_BFu31i_BFu31i, "BFu0i_BFu31i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu31ll  {
  unsigned int  :0;
  unsigned int v1:31;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu31i_BFu31ll) C1{ Fi:0 Fi:31 FL:31}



static void Test_BFu0i_BFu31i_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu31ll");
    static BFu0i_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFu0i_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu31ll(Test_BFu0i_BFu31i_BFu31ll, "BFu0i_BFu31i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu32i  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu31i_BFu32i) C1{ Fi:0 Fi:31 Fi:32}



static void Test_BFu0i_BFu31i_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu32i");
    static BFu0i_BFu31i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu31i_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu32i(Test_BFu0i_BFu31i_BFu32i, "BFu0i_BFu31i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu32ll  {
  unsigned int  :0;
  unsigned int v1:31;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu31i_BFu32ll) C1{ Fi:0 Fi:31 FL:32}



static void Test_BFu0i_BFu31i_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu32ll");
    static BFu0i_BFu31i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 3, 7, 32, 1, "BFu0i_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 3, 7, 32, hide_ull(1LL<<31), "BFu0i_BFu31i_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu32ll(Test_BFu0i_BFu31i_BFu32ll, "BFu0i_BFu31i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu33  {
  unsigned int  :0;
  unsigned int v1:31;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu31i_BFu33) C1{ Fi:0 Fi:31 FL:33}



static void Test_BFu0i_BFu31i_BFu33()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu33");
    static BFu0i_BFu31i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 3, 7, 33, 1, "BFu0i_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 3, 7, 33, hide_ull(1LL<<32), "BFu0i_BFu31i_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu33(Test_BFu0i_BFu31i_BFu33, "BFu0i_BFu31i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu7c  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu31i_BFu7c) C1{ Fi:0 Fi:31 Fc:7}



static void Test_BFu0i_BFu31i_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu7c");
    static BFu0i_BFu31i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu31i_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu7c(Test_BFu0i_BFu31i_BFu7c, "BFu0i_BFu31i_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu7i  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu31i_BFu7i) C1{ Fi:0 Fi:31 Fi:7}



static void Test_BFu0i_BFu31i_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu7i");
    static BFu0i_BFu31i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu31i_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu7i(Test_BFu0i_BFu31i_BFu7i, "BFu0i_BFu31i_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu7ll  {
  unsigned int  :0;
  unsigned int v1:31;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu31i_BFu7ll) C1{ Fi:0 Fi:31 FL:7}



static void Test_BFu0i_BFu31i_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu7ll");
    static BFu0i_BFu31i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "BFu0i_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "BFu0i_BFu31i_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu7ll(Test_BFu0i_BFu31i_BFu7ll, "BFu0i_BFu31i_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu7s  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu31i_BFu7s) C1{ Fi:0 Fi:31 Fs:7}



static void Test_BFu0i_BFu31i_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu7s");
    static BFu0i_BFu31i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu31i_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu7s(Test_BFu0i_BFu31i_BFu7s, "BFu0i_BFu31i_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu8c  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu31i_BFu8c) C1{ Fi:0 Fi:31 Fc:8}



static void Test_BFu0i_BFu31i_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu8c");
    static BFu0i_BFu31i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu31i_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu8c(Test_BFu0i_BFu31i_BFu8c, "BFu0i_BFu31i_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu8i  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu31i_BFu8i) C1{ Fi:0 Fi:31 Fi:8}



static void Test_BFu0i_BFu31i_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu8i");
    static BFu0i_BFu31i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu31i_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu8i(Test_BFu0i_BFu31i_BFu8i, "BFu0i_BFu31i_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu8ll  {
  unsigned int  :0;
  unsigned int v1:31;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu31i_BFu8ll) C1{ Fi:0 Fi:31 FL:8}



static void Test_BFu0i_BFu31i_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu8ll");
    static BFu0i_BFu31i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "BFu0i_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "BFu0i_BFu31i_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu8ll(Test_BFu0i_BFu31i_BFu8ll, "BFu0i_BFu31i_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu8s  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu31i_BFu8s) C1{ Fi:0 Fi:31 Fs:8}



static void Test_BFu0i_BFu31i_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu8s");
    static BFu0i_BFu31i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu31i_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu8s(Test_BFu0i_BFu31i_BFu8s, "BFu0i_BFu31i_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu9i  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu31i_BFu9i) C1{ Fi:0 Fi:31 Fi:9}



static void Test_BFu0i_BFu31i_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu9i");
    static BFu0i_BFu31i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu31i_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu9i(Test_BFu0i_BFu31i_BFu9i, "BFu0i_BFu31i_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu9ll  {
  unsigned int  :0;
  unsigned int v1:31;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu31i_BFu9ll) C1{ Fi:0 Fi:31 FL:9}



static void Test_BFu0i_BFu31i_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu9ll");
    static BFu0i_BFu31i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "BFu0i_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "BFu0i_BFu31i_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu9ll(Test_BFu0i_BFu31i_BFu9ll, "BFu0i_BFu31i_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_BFu9s  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu31i_BFu9s) C1{ Fi:0 Fi:31 Fs:9}



static void Test_BFu0i_BFu31i_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu31i_BFu9s");
    static BFu0i_BFu31i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu31i_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_BFu9s(Test_BFu0i_BFu31i_BFu9s, "BFu0i_BFu31i_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_C  {
  unsigned int  :0;
  unsigned int v1:31;
  char v2;
};
//SIG(1 BFu0i_BFu31i_C) C1{ Fi:0 Fi:31 Fc}



static void Test_BFu0i_BFu31i_C()
{
  {
    init_simple_test("BFu0i_BFu31i_C");
    static BFu0i_BFu31i_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_C)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_C");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_C");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31i_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_C(Test_BFu0i_BFu31i_C, "BFu0i_BFu31i_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_D  {
  unsigned int  :0;
  unsigned int v1:31;
  double v2;
};
//SIG(1 BFu0i_BFu31i_D) C1{ Fi:0 Fi:31 FL}



static void Test_BFu0i_BFu31i_D()
{
  {
    init_simple_test("BFu0i_BFu31i_D");
    static BFu0i_BFu31i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu31i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_D)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_D");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu31i_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_D(Test_BFu0i_BFu31i_D, "BFu0i_BFu31i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_F  {
  unsigned int  :0;
  unsigned int v1:31;
  float v2;
};
//SIG(1 BFu0i_BFu31i_F) C1{ Fi:0 Fi:31 Fi}



static void Test_BFu0i_BFu31i_F()
{
  {
    init_simple_test("BFu0i_BFu31i_F");
    static BFu0i_BFu31i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_F)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_F");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31i_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_F(Test_BFu0i_BFu31i_F, "BFu0i_BFu31i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_I  {
  unsigned int  :0;
  unsigned int v1:31;
  int v2;
};
//SIG(1 BFu0i_BFu31i_I) C1{ Fi:0 Fi:31 Fi}



static void Test_BFu0i_BFu31i_I()
{
  {
    init_simple_test("BFu0i_BFu31i_I");
    static BFu0i_BFu31i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_I)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_I");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31i_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_I(Test_BFu0i_BFu31i_I, "BFu0i_BFu31i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_Ip  {
  unsigned int  :0;
  unsigned int v1:31;
  int *v2;
};
//SIG(1 BFu0i_BFu31i_Ip) C1{ Fi:0 Fi:31 Fp}



static void Test_BFu0i_BFu31i_Ip()
{
  {
    init_simple_test("BFu0i_BFu31i_Ip");
    static BFu0i_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu31i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu31i_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_Ip(Test_BFu0i_BFu31i_Ip, "BFu0i_BFu31i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_L  {
  unsigned int  :0;
  unsigned int v1:31;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu31i_L) C1{ Fi:0 Fi:31 FL}



static void Test_BFu0i_BFu31i_L()
{
  {
    init_simple_test("BFu0i_BFu31i_L");
    static BFu0i_BFu31i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu31i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_L)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_L");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu31i_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_L(Test_BFu0i_BFu31i_L, "BFu0i_BFu31i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_S  {
  unsigned int  :0;
  unsigned int v1:31;
  short v2;
};
//SIG(1 BFu0i_BFu31i_S) C1{ Fi:0 Fi:31 Fs}



static void Test_BFu0i_BFu31i_S()
{
  {
    init_simple_test("BFu0i_BFu31i_S");
    static BFu0i_BFu31i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_S)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_S");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_S");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31i_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_S(Test_BFu0i_BFu31i_S, "BFu0i_BFu31i_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_Uc  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu31i_Uc) C1{ Fi:0 Fi:31 Fc}



static void Test_BFu0i_BFu31i_Uc()
{
  {
    init_simple_test("BFu0i_BFu31i_Uc");
    static BFu0i_BFu31i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_Uc");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31i_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_Uc(Test_BFu0i_BFu31i_Uc, "BFu0i_BFu31i_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_Ui  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu31i_Ui) C1{ Fi:0 Fi:31 Fi}



static void Test_BFu0i_BFu31i_Ui()
{
  {
    init_simple_test("BFu0i_BFu31i_Ui");
    static BFu0i_BFu31i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31i_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_Ui(Test_BFu0i_BFu31i_Ui, "BFu0i_BFu31i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_Ul  {
  unsigned int  :0;
  unsigned int v1:31;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu31i_Ul) C1{ Fi:0 Fi:31 FL}



static void Test_BFu0i_BFu31i_Ul()
{
  {
    init_simple_test("BFu0i_BFu31i_Ul");
    static BFu0i_BFu31i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu31i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu31i_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_Ul(Test_BFu0i_BFu31i_Ul, "BFu0i_BFu31i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_Us  {
  unsigned int  :0;
  unsigned int v1:31;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu31i_Us) C1{ Fi:0 Fi:31 Fs}



static void Test_BFu0i_BFu31i_Us()
{
  {
    init_simple_test("BFu0i_BFu31i_Us");
    static BFu0i_BFu31i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu31i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_Us");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_Us");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31i_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_Us(Test_BFu0i_BFu31i_Us, "BFu0i_BFu31i_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31i_Vp  {
  unsigned int  :0;
  unsigned int v1:31;
  void *v2;
};
//SIG(1 BFu0i_BFu31i_Vp) C1{ Fi:0 Fi:31 Fp}



static void Test_BFu0i_BFu31i_Vp()
{
  {
    init_simple_test("BFu0i_BFu31i_Vp");
    static BFu0i_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu31i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu31i_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31i_Vp(Test_BFu0i_BFu31i_Vp, "BFu0i_BFu31i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll  {
  unsigned int  :0;
  __tsu64 v1:31;
};
//SIG(1 BFu0i_BFu31ll) C1{ Fi:0 FL:31}



static void Test_BFu0i_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu31ll");
    static BFu0i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll(Test_BFu0i_BFu31ll, "BFu0i_BFu31ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu0c  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu31ll_BFu0c) C1{ Fi:0 FL:31 Fc:0}



static void Test_BFu0i_BFu31ll_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu0c");
    static BFu0i_BFu31ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu31ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu0c(Test_BFu0i_BFu31ll_BFu0c, "BFu0i_BFu31ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu0i  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu31ll_BFu0i) C1{ Fi:0 FL:31 Fi:0}



static void Test_BFu0i_BFu31ll_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu0i");
    static BFu0i_BFu31ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu31ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu0i(Test_BFu0i_BFu31ll_BFu0i, "BFu0i_BFu31ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu0ll  {
  unsigned int  :0;
  __tsu64 v1:31;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu31ll_BFu0ll) C1{ Fi:0 FL:31 FL:0}



static void Test_BFu0i_BFu31ll_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu0ll");
    static BFu0i_BFu31ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu31ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu0ll(Test_BFu0i_BFu31ll_BFu0ll, "BFu0i_BFu31ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu0s  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu31ll_BFu0s) C1{ Fi:0 FL:31 Fs:0}



static void Test_BFu0i_BFu31ll_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu0s");
    static BFu0i_BFu31ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu31ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu0s(Test_BFu0i_BFu31ll_BFu0s, "BFu0i_BFu31ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu15i  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu31ll_BFu15i) C1{ Fi:0 FL:31 Fi:15}



static void Test_BFu0i_BFu31ll_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu15i");
    static BFu0i_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu31ll_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu15i(Test_BFu0i_BFu31ll_BFu15i, "BFu0i_BFu31ll_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu15ll  {
  unsigned int  :0;
  __tsu64 v1:31;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu31ll_BFu15ll) C1{ Fi:0 FL:31 FL:15}



static void Test_BFu0i_BFu31ll_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu15ll");
    static BFu0i_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 3, 7, 15, 1, "BFu0i_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 3, 7, 15, hide_ull(1LL<<14), "BFu0i_BFu31ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu15ll(Test_BFu0i_BFu31ll_BFu15ll, "BFu0i_BFu31ll_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu15s  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu31ll_BFu15s) C1{ Fi:0 FL:31 Fs:15}



static void Test_BFu0i_BFu31ll_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu15s");
    static BFu0i_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu31ll_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu15s(Test_BFu0i_BFu31ll_BFu15s, "BFu0i_BFu31ll_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu16i  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu31ll_BFu16i) C1{ Fi:0 FL:31 Fi:16}



static void Test_BFu0i_BFu31ll_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu16i");
    static BFu0i_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu31ll_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu16i(Test_BFu0i_BFu31ll_BFu16i, "BFu0i_BFu31ll_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu16ll  {
  unsigned int  :0;
  __tsu64 v1:31;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu31ll_BFu16ll) C1{ Fi:0 FL:31 FL:16}



static void Test_BFu0i_BFu31ll_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu16ll");
    static BFu0i_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 3, 7, 16, 1, "BFu0i_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 3, 7, 16, hide_ull(1LL<<15), "BFu0i_BFu31ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu16ll(Test_BFu0i_BFu31ll_BFu16ll, "BFu0i_BFu31ll_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu16s  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu31ll_BFu16s) C1{ Fi:0 FL:31 Fs:16}



static void Test_BFu0i_BFu31ll_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu16s");
    static BFu0i_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu31ll_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu16s(Test_BFu0i_BFu31ll_BFu16s, "BFu0i_BFu31ll_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu17i  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu31ll_BFu17i) C1{ Fi:0 FL:31 Fi:17}



static void Test_BFu0i_BFu31ll_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu17i");
    static BFu0i_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0i_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu31ll_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu17i(Test_BFu0i_BFu31ll_BFu17i, "BFu0i_BFu31ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu17ll  {
  unsigned int  :0;
  __tsu64 v1:31;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu31ll_BFu17ll) C1{ Fi:0 FL:31 FL:17}



static void Test_BFu0i_BFu31ll_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu17ll");
    static BFu0i_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 3, 7, 17, 1, "BFu0i_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 3, 7, 17, hide_ull(1LL<<16), "BFu0i_BFu31ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu17ll(Test_BFu0i_BFu31ll_BFu17ll, "BFu0i_BFu31ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu1c  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu31ll_BFu1c) C1{ Fi:0 FL:31 Fc:1}



static void Test_BFu0i_BFu31ll_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu1c");
    static BFu0i_BFu31ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu31ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0i_BFu31ll_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu1c(Test_BFu0i_BFu31ll_BFu1c, "BFu0i_BFu31ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu1i  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu31ll_BFu1i) C1{ Fi:0 FL:31 Fi:1}



static void Test_BFu0i_BFu31ll_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu1i");
    static BFu0i_BFu31ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu31ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0i_BFu31ll_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu1i(Test_BFu0i_BFu31ll_BFu1i, "BFu0i_BFu31ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu1ll  {
  unsigned int  :0;
  __tsu64 v1:31;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu31ll_BFu1ll) C1{ Fi:0 FL:31 FL:1}



static void Test_BFu0i_BFu31ll_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu1ll");
    static BFu0i_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0i_BFu31ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu1ll(Test_BFu0i_BFu31ll_BFu1ll, "BFu0i_BFu31ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu1s  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu31ll_BFu1s) C1{ Fi:0 FL:31 Fs:1}



static void Test_BFu0i_BFu31ll_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu1s");
    static BFu0i_BFu31ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu31ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu0i_BFu31ll_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu1s(Test_BFu0i_BFu31ll_BFu1s, "BFu0i_BFu31ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu31i  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu31ll_BFu31i) C1{ Fi:0 FL:31 Fi:31}



static void Test_BFu0i_BFu31ll_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu31i");
    static BFu0i_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu31i(Test_BFu0i_BFu31ll_BFu31i, "BFu0i_BFu31ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu31ll  {
  unsigned int  :0;
  __tsu64 v1:31;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu31ll_BFu31ll) C1{ Fi:0 FL:31 FL:31}



static void Test_BFu0i_BFu31ll_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu31ll");
    static BFu0i_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFu0i_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu31ll(Test_BFu0i_BFu31ll_BFu31ll, "BFu0i_BFu31ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu32i  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu31ll_BFu32i) C1{ Fi:0 FL:31 Fi:32}



static void Test_BFu0i_BFu31ll_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu32i");
    static BFu0i_BFu31ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu31ll_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu32i(Test_BFu0i_BFu31ll_BFu32i, "BFu0i_BFu31ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu32ll  {
  unsigned int  :0;
  __tsu64 v1:31;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu31ll_BFu32ll) C1{ Fi:0 FL:31 FL:32}



static void Test_BFu0i_BFu31ll_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu32ll");
    static BFu0i_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 3, 7, 32, 1, "BFu0i_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 3, 7, 32, hide_ull(1LL<<31), "BFu0i_BFu31ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu32ll(Test_BFu0i_BFu31ll_BFu32ll, "BFu0i_BFu31ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu33  {
  unsigned int  :0;
  __tsu64 v1:31;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu31ll_BFu33) C1{ Fi:0 FL:31 FL:33}



static void Test_BFu0i_BFu31ll_BFu33()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu33");
    static BFu0i_BFu31ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 3, 7, 33, 1, "BFu0i_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 3, 7, 33, hide_ull(1LL<<32), "BFu0i_BFu31ll_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu33(Test_BFu0i_BFu31ll_BFu33, "BFu0i_BFu31ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu7c  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu31ll_BFu7c) C1{ Fi:0 FL:31 Fc:7}



static void Test_BFu0i_BFu31ll_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu7c");
    static BFu0i_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu31ll_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu7c(Test_BFu0i_BFu31ll_BFu7c, "BFu0i_BFu31ll_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu7i  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu31ll_BFu7i) C1{ Fi:0 FL:31 Fi:7}



static void Test_BFu0i_BFu31ll_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu7i");
    static BFu0i_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu31ll_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu7i(Test_BFu0i_BFu31ll_BFu7i, "BFu0i_BFu31ll_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu7ll  {
  unsigned int  :0;
  __tsu64 v1:31;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu31ll_BFu7ll) C1{ Fi:0 FL:31 FL:7}



static void Test_BFu0i_BFu31ll_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu7ll");
    static BFu0i_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "BFu0i_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "BFu0i_BFu31ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu7ll(Test_BFu0i_BFu31ll_BFu7ll, "BFu0i_BFu31ll_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu7s  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu31ll_BFu7s) C1{ Fi:0 FL:31 Fs:7}



static void Test_BFu0i_BFu31ll_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu7s");
    static BFu0i_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu31ll_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu7s(Test_BFu0i_BFu31ll_BFu7s, "BFu0i_BFu31ll_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu8c  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu31ll_BFu8c) C1{ Fi:0 FL:31 Fc:8}



static void Test_BFu0i_BFu31ll_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu8c");
    static BFu0i_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu31ll_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu8c(Test_BFu0i_BFu31ll_BFu8c, "BFu0i_BFu31ll_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu8i  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu31ll_BFu8i) C1{ Fi:0 FL:31 Fi:8}



static void Test_BFu0i_BFu31ll_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu8i");
    static BFu0i_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu31ll_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu8i(Test_BFu0i_BFu31ll_BFu8i, "BFu0i_BFu31ll_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu8ll  {
  unsigned int  :0;
  __tsu64 v1:31;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu31ll_BFu8ll) C1{ Fi:0 FL:31 FL:8}



static void Test_BFu0i_BFu31ll_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu8ll");
    static BFu0i_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "BFu0i_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "BFu0i_BFu31ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu8ll(Test_BFu0i_BFu31ll_BFu8ll, "BFu0i_BFu31ll_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu8s  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu31ll_BFu8s) C1{ Fi:0 FL:31 Fs:8}



static void Test_BFu0i_BFu31ll_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu8s");
    static BFu0i_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu31ll_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu8s(Test_BFu0i_BFu31ll_BFu8s, "BFu0i_BFu31ll_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu9i  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu31ll_BFu9i) C1{ Fi:0 FL:31 Fi:9}



static void Test_BFu0i_BFu31ll_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu9i");
    static BFu0i_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu31ll_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu9i(Test_BFu0i_BFu31ll_BFu9i, "BFu0i_BFu31ll_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu9ll  {
  unsigned int  :0;
  __tsu64 v1:31;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu31ll_BFu9ll) C1{ Fi:0 FL:31 FL:9}



static void Test_BFu0i_BFu31ll_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu9ll");
    static BFu0i_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "BFu0i_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "BFu0i_BFu31ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu9ll(Test_BFu0i_BFu31ll_BFu9ll, "BFu0i_BFu31ll_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_BFu9s  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu31ll_BFu9s) C1{ Fi:0 FL:31 Fs:9}



static void Test_BFu0i_BFu31ll_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu31ll_BFu9s");
    static BFu0i_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu31ll_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_BFu9s(Test_BFu0i_BFu31ll_BFu9s, "BFu0i_BFu31ll_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_C  {
  unsigned int  :0;
  __tsu64 v1:31;
  char v2;
};
//SIG(1 BFu0i_BFu31ll_C) C1{ Fi:0 FL:31 Fc}



static void Test_BFu0i_BFu31ll_C()
{
  {
    init_simple_test("BFu0i_BFu31ll_C");
    static BFu0i_BFu31ll_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_C");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_C");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31ll_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_C(Test_BFu0i_BFu31ll_C, "BFu0i_BFu31ll_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_D  {
  unsigned int  :0;
  __tsu64 v1:31;
  double v2;
};
//SIG(1 BFu0i_BFu31ll_D) C1{ Fi:0 FL:31 FL}



static void Test_BFu0i_BFu31ll_D()
{
  {
    init_simple_test("BFu0i_BFu31ll_D");
    static BFu0i_BFu31ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu31ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_D");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu31ll_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_D(Test_BFu0i_BFu31ll_D, "BFu0i_BFu31ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_F  {
  unsigned int  :0;
  __tsu64 v1:31;
  float v2;
};
//SIG(1 BFu0i_BFu31ll_F) C1{ Fi:0 FL:31 Fi}



static void Test_BFu0i_BFu31ll_F()
{
  {
    init_simple_test("BFu0i_BFu31ll_F");
    static BFu0i_BFu31ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_F");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31ll_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_F(Test_BFu0i_BFu31ll_F, "BFu0i_BFu31ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_I  {
  unsigned int  :0;
  __tsu64 v1:31;
  int v2;
};
//SIG(1 BFu0i_BFu31ll_I) C1{ Fi:0 FL:31 Fi}



static void Test_BFu0i_BFu31ll_I()
{
  {
    init_simple_test("BFu0i_BFu31ll_I");
    static BFu0i_BFu31ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_I");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31ll_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_I(Test_BFu0i_BFu31ll_I, "BFu0i_BFu31ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_Ip  {
  unsigned int  :0;
  __tsu64 v1:31;
  int *v2;
};
//SIG(1 BFu0i_BFu31ll_Ip) C1{ Fi:0 FL:31 Fp}



static void Test_BFu0i_BFu31ll_Ip()
{
  {
    init_simple_test("BFu0i_BFu31ll_Ip");
    static BFu0i_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu31ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu31ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_Ip(Test_BFu0i_BFu31ll_Ip, "BFu0i_BFu31ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_L  {
  unsigned int  :0;
  __tsu64 v1:31;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu31ll_L) C1{ Fi:0 FL:31 FL}



static void Test_BFu0i_BFu31ll_L()
{
  {
    init_simple_test("BFu0i_BFu31ll_L");
    static BFu0i_BFu31ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu31ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_L");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu31ll_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_L(Test_BFu0i_BFu31ll_L, "BFu0i_BFu31ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_S  {
  unsigned int  :0;
  __tsu64 v1:31;
  short v2;
};
//SIG(1 BFu0i_BFu31ll_S) C1{ Fi:0 FL:31 Fs}



static void Test_BFu0i_BFu31ll_S()
{
  {
    init_simple_test("BFu0i_BFu31ll_S");
    static BFu0i_BFu31ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_S");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_S");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31ll_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_S(Test_BFu0i_BFu31ll_S, "BFu0i_BFu31ll_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_Uc  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu31ll_Uc) C1{ Fi:0 FL:31 Fc}



static void Test_BFu0i_BFu31ll_Uc()
{
  {
    init_simple_test("BFu0i_BFu31ll_Uc");
    static BFu0i_BFu31ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_Uc");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_Uc(Test_BFu0i_BFu31ll_Uc, "BFu0i_BFu31ll_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_Ui  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu31ll_Ui) C1{ Fi:0 FL:31 Fi}



static void Test_BFu0i_BFu31ll_Ui()
{
  {
    init_simple_test("BFu0i_BFu31ll_Ui");
    static BFu0i_BFu31ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_Ui(Test_BFu0i_BFu31ll_Ui, "BFu0i_BFu31ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_Ul  {
  unsigned int  :0;
  __tsu64 v1:31;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu31ll_Ul) C1{ Fi:0 FL:31 FL}



static void Test_BFu0i_BFu31ll_Ul()
{
  {
    init_simple_test("BFu0i_BFu31ll_Ul");
    static BFu0i_BFu31ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu31ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu31ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_Ul(Test_BFu0i_BFu31ll_Ul, "BFu0i_BFu31ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_Us  {
  unsigned int  :0;
  __tsu64 v1:31;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu31ll_Us) C1{ Fi:0 FL:31 Fs}



static void Test_BFu0i_BFu31ll_Us()
{
  {
    init_simple_test("BFu0i_BFu31ll_Us");
    static BFu0i_BFu31ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu31ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_Us");
    check_field_offset(lv, v2, 4, "BFu0i_BFu31ll_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_Us(Test_BFu0i_BFu31ll_Us, "BFu0i_BFu31ll_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu31ll_Vp  {
  unsigned int  :0;
  __tsu64 v1:31;
  void *v2;
};
//SIG(1 BFu0i_BFu31ll_Vp) C1{ Fi:0 FL:31 Fp}



static void Test_BFu0i_BFu31ll_Vp()
{
  {
    init_simple_test("BFu0i_BFu31ll_Vp");
    static BFu0i_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu31ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu31ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu0i_BFu31ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu31ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu31ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu31ll_Vp(Test_BFu0i_BFu31ll_Vp, "BFu0i_BFu31ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i  {
  unsigned int  :0;
  unsigned int v1:32;
};
//SIG(1 BFu0i_BFu32i) C1{ Fi:0 Fi:32}



static void Test_BFu0i_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu32i");
    static BFu0i_BFu32i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i(Test_BFu0i_BFu32i, "BFu0i_BFu32i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu0c  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu32i_BFu0c) C1{ Fi:0 Fi:32 Fc:0}



static void Test_BFu0i_BFu32i_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu0c");
    static BFu0i_BFu32i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu32i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu0c(Test_BFu0i_BFu32i_BFu0c, "BFu0i_BFu32i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu0i  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu32i_BFu0i) C1{ Fi:0 Fi:32 Fi:0}



static void Test_BFu0i_BFu32i_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu0i");
    static BFu0i_BFu32i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu32i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu0i(Test_BFu0i_BFu32i_BFu0i, "BFu0i_BFu32i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu0ll  {
  unsigned int  :0;
  unsigned int v1:32;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu32i_BFu0ll) C1{ Fi:0 Fi:32 FL:0}



static void Test_BFu0i_BFu32i_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu0ll");
    static BFu0i_BFu32i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu32i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0i_BFu32i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu0ll(Test_BFu0i_BFu32i_BFu0ll, "BFu0i_BFu32i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu0s  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu32i_BFu0s) C1{ Fi:0 Fi:32 Fs:0}



static void Test_BFu0i_BFu32i_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu0s");
    static BFu0i_BFu32i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu32i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu0s(Test_BFu0i_BFu32i_BFu0s, "BFu0i_BFu32i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu15i  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu32i_BFu15i) C1{ Fi:0 Fi:32 Fi:15}



static void Test_BFu0i_BFu32i_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu15i");
    static BFu0i_BFu32i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu32i_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu15i(Test_BFu0i_BFu32i_BFu15i, "BFu0i_BFu32i_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu15ll  {
  unsigned int  :0;
  unsigned int v1:32;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu32i_BFu15ll) C1{ Fi:0 Fi:32 FL:15}



static void Test_BFu0i_BFu32i_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu15ll");
    static BFu0i_BFu32i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu32i_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu15ll(Test_BFu0i_BFu32i_BFu15ll, "BFu0i_BFu32i_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu15s  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu32i_BFu15s) C1{ Fi:0 Fi:32 Fs:15}



static void Test_BFu0i_BFu32i_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu15s");
    static BFu0i_BFu32i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu32i_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu15s(Test_BFu0i_BFu32i_BFu15s, "BFu0i_BFu32i_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu16i  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu32i_BFu16i) C1{ Fi:0 Fi:32 Fi:16}



static void Test_BFu0i_BFu32i_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu16i");
    static BFu0i_BFu32i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu32i_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu16i(Test_BFu0i_BFu32i_BFu16i, "BFu0i_BFu32i_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu16ll  {
  unsigned int  :0;
  unsigned int v1:32;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu32i_BFu16ll) C1{ Fi:0 Fi:32 FL:16}



static void Test_BFu0i_BFu32i_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu16ll");
    static BFu0i_BFu32i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu32i_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu16ll(Test_BFu0i_BFu32i_BFu16ll, "BFu0i_BFu32i_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu16s  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu32i_BFu16s) C1{ Fi:0 Fi:32 Fs:16}



static void Test_BFu0i_BFu32i_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu16s");
    static BFu0i_BFu32i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu32i_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu16s(Test_BFu0i_BFu32i_BFu16s, "BFu0i_BFu32i_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu17i  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu32i_BFu17i) C1{ Fi:0 Fi:32 Fi:17}



static void Test_BFu0i_BFu32i_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu17i");
    static BFu0i_BFu32i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0i_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu32i_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu17i(Test_BFu0i_BFu32i_BFu17i, "BFu0i_BFu32i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu17ll  {
  unsigned int  :0;
  unsigned int v1:32;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu32i_BFu17ll) C1{ Fi:0 Fi:32 FL:17}



static void Test_BFu0i_BFu32i_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu17ll");
    static BFu0i_BFu32i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0i_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu32i_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu17ll(Test_BFu0i_BFu32i_BFu17ll, "BFu0i_BFu32i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu1c  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu32i_BFu1c) C1{ Fi:0 Fi:32 Fc:1}



static void Test_BFu0i_BFu32i_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu1c");
    static BFu0i_BFu32i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_BFu32i_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu1c(Test_BFu0i_BFu32i_BFu1c, "BFu0i_BFu32i_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu1i  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu32i_BFu1i) C1{ Fi:0 Fi:32 Fi:1}



static void Test_BFu0i_BFu32i_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu1i");
    static BFu0i_BFu32i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_BFu32i_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu1i(Test_BFu0i_BFu32i_BFu1i, "BFu0i_BFu32i_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu1ll  {
  unsigned int  :0;
  unsigned int v1:32;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu32i_BFu1ll) C1{ Fi:0 Fi:32 FL:1}



static void Test_BFu0i_BFu32i_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu1ll");
    static BFu0i_BFu32i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_BFu32i_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu1ll(Test_BFu0i_BFu32i_BFu1ll, "BFu0i_BFu32i_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu1s  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu32i_BFu1s) C1{ Fi:0 Fi:32 Fs:1}



static void Test_BFu0i_BFu32i_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu1s");
    static BFu0i_BFu32i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_BFu32i_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu1s(Test_BFu0i_BFu32i_BFu1s, "BFu0i_BFu32i_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu31i  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu32i_BFu31i) C1{ Fi:0 Fi:32 Fi:31}



static void Test_BFu0i_BFu32i_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu31i");
    static BFu0i_BFu32i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu32i_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu31i(Test_BFu0i_BFu32i_BFu31i, "BFu0i_BFu32i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu31ll  {
  unsigned int  :0;
  unsigned int v1:32;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu32i_BFu31ll) C1{ Fi:0 Fi:32 FL:31}



static void Test_BFu0i_BFu32i_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu31ll");
    static BFu0i_BFu32i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu32i_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu31ll(Test_BFu0i_BFu32i_BFu31ll, "BFu0i_BFu32i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu32i  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu32i_BFu32i) C1{ Fi:0 Fi:32 Fi:32}



static void Test_BFu0i_BFu32i_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu32i");
    static BFu0i_BFu32i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu32i(Test_BFu0i_BFu32i_BFu32i, "BFu0i_BFu32i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu32ll  {
  unsigned int  :0;
  unsigned int v1:32;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu32i_BFu32ll) C1{ Fi:0 Fi:32 FL:32}



static void Test_BFu0i_BFu32i_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu32ll");
    static BFu0i_BFu32i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu32ll(Test_BFu0i_BFu32i_BFu32ll, "BFu0i_BFu32i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu33  {
  unsigned int  :0;
  unsigned int v1:32;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu32i_BFu33) C1{ Fi:0 Fi:32 FL:33}



static void Test_BFu0i_BFu32i_BFu33()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu33");
    static BFu0i_BFu32i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu32i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu0i_BFu32i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu0i_BFu32i_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu33(Test_BFu0i_BFu32i_BFu33, "BFu0i_BFu32i_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu7c  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu32i_BFu7c) C1{ Fi:0 Fi:32 Fc:7}



static void Test_BFu0i_BFu32i_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu7c");
    static BFu0i_BFu32i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu32i_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu7c(Test_BFu0i_BFu32i_BFu7c, "BFu0i_BFu32i_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu7i  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu32i_BFu7i) C1{ Fi:0 Fi:32 Fi:7}



static void Test_BFu0i_BFu32i_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu7i");
    static BFu0i_BFu32i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu32i_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu7i(Test_BFu0i_BFu32i_BFu7i, "BFu0i_BFu32i_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu7ll  {
  unsigned int  :0;
  unsigned int v1:32;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu32i_BFu7ll) C1{ Fi:0 Fi:32 FL:7}



static void Test_BFu0i_BFu32i_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu7ll");
    static BFu0i_BFu32i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu32i_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu7ll(Test_BFu0i_BFu32i_BFu7ll, "BFu0i_BFu32i_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu7s  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu32i_BFu7s) C1{ Fi:0 Fi:32 Fs:7}



static void Test_BFu0i_BFu32i_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu7s");
    static BFu0i_BFu32i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu32i_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu7s(Test_BFu0i_BFu32i_BFu7s, "BFu0i_BFu32i_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu8c  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu32i_BFu8c) C1{ Fi:0 Fi:32 Fc:8}



static void Test_BFu0i_BFu32i_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu8c");
    static BFu0i_BFu32i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu32i_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu8c(Test_BFu0i_BFu32i_BFu8c, "BFu0i_BFu32i_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu8i  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu32i_BFu8i) C1{ Fi:0 Fi:32 Fi:8}



static void Test_BFu0i_BFu32i_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu8i");
    static BFu0i_BFu32i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu32i_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu8i(Test_BFu0i_BFu32i_BFu8i, "BFu0i_BFu32i_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu8ll  {
  unsigned int  :0;
  unsigned int v1:32;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu32i_BFu8ll) C1{ Fi:0 Fi:32 FL:8}



static void Test_BFu0i_BFu32i_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu8ll");
    static BFu0i_BFu32i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu32i_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu8ll(Test_BFu0i_BFu32i_BFu8ll, "BFu0i_BFu32i_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu8s  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu32i_BFu8s) C1{ Fi:0 Fi:32 Fs:8}



static void Test_BFu0i_BFu32i_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu8s");
    static BFu0i_BFu32i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu32i_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu8s(Test_BFu0i_BFu32i_BFu8s, "BFu0i_BFu32i_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu9i  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu32i_BFu9i) C1{ Fi:0 Fi:32 Fi:9}



static void Test_BFu0i_BFu32i_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu9i");
    static BFu0i_BFu32i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu32i_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu9i(Test_BFu0i_BFu32i_BFu9i, "BFu0i_BFu32i_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu9ll  {
  unsigned int  :0;
  unsigned int v1:32;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu32i_BFu9ll) C1{ Fi:0 Fi:32 FL:9}



static void Test_BFu0i_BFu32i_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu9ll");
    static BFu0i_BFu32i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu32i_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu9ll(Test_BFu0i_BFu32i_BFu9ll, "BFu0i_BFu32i_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_BFu9s  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu32i_BFu9s) C1{ Fi:0 Fi:32 Fs:9}



static void Test_BFu0i_BFu32i_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu32i_BFu9s");
    static BFu0i_BFu32i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu32i_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_BFu9s(Test_BFu0i_BFu32i_BFu9s, "BFu0i_BFu32i_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_C  {
  unsigned int  :0;
  unsigned int v1:32;
  char v2;
};
//SIG(1 BFu0i_BFu32i_C) C1{ Fi:0 Fi:32 Fc}



static void Test_BFu0i_BFu32i_C()
{
  {
    init_simple_test("BFu0i_BFu32i_C");
    static BFu0i_BFu32i_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_C)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_C");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_C");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32i_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_C(Test_BFu0i_BFu32i_C, "BFu0i_BFu32i_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_D  {
  unsigned int  :0;
  unsigned int v1:32;
  double v2;
};
//SIG(1 BFu0i_BFu32i_D) C1{ Fi:0 Fi:32 FL}



static void Test_BFu0i_BFu32i_D()
{
  {
    init_simple_test("BFu0i_BFu32i_D");
    static BFu0i_BFu32i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu32i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_D)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_D");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu32i_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_D(Test_BFu0i_BFu32i_D, "BFu0i_BFu32i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_F  {
  unsigned int  :0;
  unsigned int v1:32;
  float v2;
};
//SIG(1 BFu0i_BFu32i_F) C1{ Fi:0 Fi:32 Fi}



static void Test_BFu0i_BFu32i_F()
{
  {
    init_simple_test("BFu0i_BFu32i_F");
    static BFu0i_BFu32i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_F)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_F");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32i_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_F(Test_BFu0i_BFu32i_F, "BFu0i_BFu32i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_I  {
  unsigned int  :0;
  unsigned int v1:32;
  int v2;
};
//SIG(1 BFu0i_BFu32i_I) C1{ Fi:0 Fi:32 Fi}



static void Test_BFu0i_BFu32i_I()
{
  {
    init_simple_test("BFu0i_BFu32i_I");
    static BFu0i_BFu32i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_I)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_I");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32i_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_I(Test_BFu0i_BFu32i_I, "BFu0i_BFu32i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_Ip  {
  unsigned int  :0;
  unsigned int v1:32;
  int *v2;
};
//SIG(1 BFu0i_BFu32i_Ip) C1{ Fi:0 Fi:32 Fp}



static void Test_BFu0i_BFu32i_Ip()
{
  {
    init_simple_test("BFu0i_BFu32i_Ip");
    static BFu0i_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu32i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu32i_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_Ip(Test_BFu0i_BFu32i_Ip, "BFu0i_BFu32i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_L  {
  unsigned int  :0;
  unsigned int v1:32;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu32i_L) C1{ Fi:0 Fi:32 FL}



static void Test_BFu0i_BFu32i_L()
{
  {
    init_simple_test("BFu0i_BFu32i_L");
    static BFu0i_BFu32i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu32i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_L)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_L");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu32i_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_L(Test_BFu0i_BFu32i_L, "BFu0i_BFu32i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_S  {
  unsigned int  :0;
  unsigned int v1:32;
  short v2;
};
//SIG(1 BFu0i_BFu32i_S) C1{ Fi:0 Fi:32 Fs}



static void Test_BFu0i_BFu32i_S()
{
  {
    init_simple_test("BFu0i_BFu32i_S");
    static BFu0i_BFu32i_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_S)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_S");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_S");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32i_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_S(Test_BFu0i_BFu32i_S, "BFu0i_BFu32i_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_Uc  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu32i_Uc) C1{ Fi:0 Fi:32 Fc}



static void Test_BFu0i_BFu32i_Uc()
{
  {
    init_simple_test("BFu0i_BFu32i_Uc");
    static BFu0i_BFu32i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_Uc");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32i_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_Uc(Test_BFu0i_BFu32i_Uc, "BFu0i_BFu32i_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_Ui  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu32i_Ui) C1{ Fi:0 Fi:32 Fi}



static void Test_BFu0i_BFu32i_Ui()
{
  {
    init_simple_test("BFu0i_BFu32i_Ui");
    static BFu0i_BFu32i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32i_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_Ui(Test_BFu0i_BFu32i_Ui, "BFu0i_BFu32i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_Ul  {
  unsigned int  :0;
  unsigned int v1:32;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu32i_Ul) C1{ Fi:0 Fi:32 FL}



static void Test_BFu0i_BFu32i_Ul()
{
  {
    init_simple_test("BFu0i_BFu32i_Ul");
    static BFu0i_BFu32i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu32i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu32i_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_Ul(Test_BFu0i_BFu32i_Ul, "BFu0i_BFu32i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_Us  {
  unsigned int  :0;
  unsigned int v1:32;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu32i_Us) C1{ Fi:0 Fi:32 Fs}



static void Test_BFu0i_BFu32i_Us()
{
  {
    init_simple_test("BFu0i_BFu32i_Us");
    static BFu0i_BFu32i_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu32i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_Us");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_Us");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32i_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_Us(Test_BFu0i_BFu32i_Us, "BFu0i_BFu32i_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32i_Vp  {
  unsigned int  :0;
  unsigned int v1:32;
  void *v2;
};
//SIG(1 BFu0i_BFu32i_Vp) C1{ Fi:0 Fi:32 Fp}



static void Test_BFu0i_BFu32i_Vp()
{
  {
    init_simple_test("BFu0i_BFu32i_Vp");
    static BFu0i_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu32i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu32i_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32i_Vp(Test_BFu0i_BFu32i_Vp, "BFu0i_BFu32i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll  {
  unsigned int  :0;
  __tsu64 v1:32;
};
//SIG(1 BFu0i_BFu32ll) C1{ Fi:0 FL:32}



static void Test_BFu0i_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu32ll");
    static BFu0i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll(Test_BFu0i_BFu32ll, "BFu0i_BFu32ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu0c  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu32ll_BFu0c) C1{ Fi:0 FL:32 Fc:0}



static void Test_BFu0i_BFu32ll_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu0c");
    static BFu0i_BFu32ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu32ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu0c(Test_BFu0i_BFu32ll_BFu0c, "BFu0i_BFu32ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu0i  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu32ll_BFu0i) C1{ Fi:0 FL:32 Fi:0}



static void Test_BFu0i_BFu32ll_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu0i");
    static BFu0i_BFu32ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu32ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu0i(Test_BFu0i_BFu32ll_BFu0i, "BFu0i_BFu32ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu0ll  {
  unsigned int  :0;
  __tsu64 v1:32;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu32ll_BFu0ll) C1{ Fi:0 FL:32 FL:0}



static void Test_BFu0i_BFu32ll_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu0ll");
    static BFu0i_BFu32ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu32ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu0ll(Test_BFu0i_BFu32ll_BFu0ll, "BFu0i_BFu32ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu0s  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu32ll_BFu0s) C1{ Fi:0 FL:32 Fs:0}



static void Test_BFu0i_BFu32ll_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu0s");
    static BFu0i_BFu32ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu32ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu0s(Test_BFu0i_BFu32ll_BFu0s, "BFu0i_BFu32ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu15i  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu32ll_BFu15i) C1{ Fi:0 FL:32 Fi:15}



static void Test_BFu0i_BFu32ll_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu15i");
    static BFu0i_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu32ll_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu15i(Test_BFu0i_BFu32ll_BFu15i, "BFu0i_BFu32ll_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu15ll  {
  unsigned int  :0;
  __tsu64 v1:32;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu32ll_BFu15ll) C1{ Fi:0 FL:32 FL:15}



static void Test_BFu0i_BFu32ll_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu15ll");
    static BFu0i_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu32ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu15ll(Test_BFu0i_BFu32ll_BFu15ll, "BFu0i_BFu32ll_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu15s  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu32ll_BFu15s) C1{ Fi:0 FL:32 Fs:15}



static void Test_BFu0i_BFu32ll_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu15s");
    static BFu0i_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu32ll_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu15s(Test_BFu0i_BFu32ll_BFu15s, "BFu0i_BFu32ll_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu16i  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu32ll_BFu16i) C1{ Fi:0 FL:32 Fi:16}



static void Test_BFu0i_BFu32ll_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu16i");
    static BFu0i_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu32ll_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu16i(Test_BFu0i_BFu32ll_BFu16i, "BFu0i_BFu32ll_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu16ll  {
  unsigned int  :0;
  __tsu64 v1:32;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu32ll_BFu16ll) C1{ Fi:0 FL:32 FL:16}



static void Test_BFu0i_BFu32ll_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu16ll");
    static BFu0i_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu32ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu16ll(Test_BFu0i_BFu32ll_BFu16ll, "BFu0i_BFu32ll_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu16s  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu32ll_BFu16s) C1{ Fi:0 FL:32 Fs:16}



static void Test_BFu0i_BFu32ll_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu16s");
    static BFu0i_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu32ll_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu16s(Test_BFu0i_BFu32ll_BFu16s, "BFu0i_BFu32ll_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu17i  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu32ll_BFu17i) C1{ Fi:0 FL:32 Fi:17}



static void Test_BFu0i_BFu32ll_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu17i");
    static BFu0i_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0i_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu32ll_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu17i(Test_BFu0i_BFu32ll_BFu17i, "BFu0i_BFu32ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu17ll  {
  unsigned int  :0;
  __tsu64 v1:32;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu32ll_BFu17ll) C1{ Fi:0 FL:32 FL:17}



static void Test_BFu0i_BFu32ll_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu17ll");
    static BFu0i_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0i_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu32ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu17ll(Test_BFu0i_BFu32ll_BFu17ll, "BFu0i_BFu32ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu1c  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu32ll_BFu1c) C1{ Fi:0 FL:32 Fc:1}



static void Test_BFu0i_BFu32ll_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu1c");
    static BFu0i_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_BFu32ll_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu1c(Test_BFu0i_BFu32ll_BFu1c, "BFu0i_BFu32ll_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu1i  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu32ll_BFu1i) C1{ Fi:0 FL:32 Fi:1}



static void Test_BFu0i_BFu32ll_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu1i");
    static BFu0i_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_BFu32ll_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu1i(Test_BFu0i_BFu32ll_BFu1i, "BFu0i_BFu32ll_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu1ll  {
  unsigned int  :0;
  __tsu64 v1:32;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu32ll_BFu1ll) C1{ Fi:0 FL:32 FL:1}



static void Test_BFu0i_BFu32ll_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu1ll");
    static BFu0i_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_BFu32ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu1ll(Test_BFu0i_BFu32ll_BFu1ll, "BFu0i_BFu32ll_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu1s  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu32ll_BFu1s) C1{ Fi:0 FL:32 Fs:1}



static void Test_BFu0i_BFu32ll_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu1s");
    static BFu0i_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_BFu32ll_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu1s(Test_BFu0i_BFu32ll_BFu1s, "BFu0i_BFu32ll_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu31i  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu32ll_BFu31i) C1{ Fi:0 FL:32 Fi:31}



static void Test_BFu0i_BFu32ll_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu31i");
    static BFu0i_BFu32ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu32ll_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu31i(Test_BFu0i_BFu32ll_BFu31i, "BFu0i_BFu32ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu31ll  {
  unsigned int  :0;
  __tsu64 v1:32;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu32ll_BFu31ll) C1{ Fi:0 FL:32 FL:31}



static void Test_BFu0i_BFu32ll_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu31ll");
    static BFu0i_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu32ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu31ll(Test_BFu0i_BFu32ll_BFu31ll, "BFu0i_BFu32ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu32i  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu32ll_BFu32i) C1{ Fi:0 FL:32 Fi:32}



static void Test_BFu0i_BFu32ll_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu32i");
    static BFu0i_BFu32ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu32i(Test_BFu0i_BFu32ll_BFu32i, "BFu0i_BFu32ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu32ll  {
  unsigned int  :0;
  __tsu64 v1:32;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu32ll_BFu32ll) C1{ Fi:0 FL:32 FL:32}



static void Test_BFu0i_BFu32ll_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu32ll");
    static BFu0i_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu32ll(Test_BFu0i_BFu32ll_BFu32ll, "BFu0i_BFu32ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu33  {
  unsigned int  :0;
  __tsu64 v1:32;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu32ll_BFu33) C1{ Fi:0 FL:32 FL:33}



static void Test_BFu0i_BFu32ll_BFu33()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu33");
    static BFu0i_BFu32ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu32ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu0i_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu0i_BFu32ll_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu33(Test_BFu0i_BFu32ll_BFu33, "BFu0i_BFu32ll_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu7c  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu32ll_BFu7c) C1{ Fi:0 FL:32 Fc:7}



static void Test_BFu0i_BFu32ll_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu7c");
    static BFu0i_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu32ll_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu7c(Test_BFu0i_BFu32ll_BFu7c, "BFu0i_BFu32ll_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu7i  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu32ll_BFu7i) C1{ Fi:0 FL:32 Fi:7}



static void Test_BFu0i_BFu32ll_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu7i");
    static BFu0i_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu32ll_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu7i(Test_BFu0i_BFu32ll_BFu7i, "BFu0i_BFu32ll_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu7ll  {
  unsigned int  :0;
  __tsu64 v1:32;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu32ll_BFu7ll) C1{ Fi:0 FL:32 FL:7}



static void Test_BFu0i_BFu32ll_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu7ll");
    static BFu0i_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu32ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu7ll(Test_BFu0i_BFu32ll_BFu7ll, "BFu0i_BFu32ll_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu7s  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu32ll_BFu7s) C1{ Fi:0 FL:32 Fs:7}



static void Test_BFu0i_BFu32ll_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu7s");
    static BFu0i_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu32ll_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu7s(Test_BFu0i_BFu32ll_BFu7s, "BFu0i_BFu32ll_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu8c  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu32ll_BFu8c) C1{ Fi:0 FL:32 Fc:8}



static void Test_BFu0i_BFu32ll_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu8c");
    static BFu0i_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu32ll_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu8c(Test_BFu0i_BFu32ll_BFu8c, "BFu0i_BFu32ll_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu8i  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu32ll_BFu8i) C1{ Fi:0 FL:32 Fi:8}



static void Test_BFu0i_BFu32ll_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu8i");
    static BFu0i_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu32ll_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu8i(Test_BFu0i_BFu32ll_BFu8i, "BFu0i_BFu32ll_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu8ll  {
  unsigned int  :0;
  __tsu64 v1:32;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu32ll_BFu8ll) C1{ Fi:0 FL:32 FL:8}



static void Test_BFu0i_BFu32ll_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu8ll");
    static BFu0i_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu32ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu8ll(Test_BFu0i_BFu32ll_BFu8ll, "BFu0i_BFu32ll_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu8s  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu32ll_BFu8s) C1{ Fi:0 FL:32 Fs:8}



static void Test_BFu0i_BFu32ll_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu8s");
    static BFu0i_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu32ll_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu8s(Test_BFu0i_BFu32ll_BFu8s, "BFu0i_BFu32ll_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu9i  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu32ll_BFu9i) C1{ Fi:0 FL:32 Fi:9}



static void Test_BFu0i_BFu32ll_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu9i");
    static BFu0i_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu32ll_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu9i(Test_BFu0i_BFu32ll_BFu9i, "BFu0i_BFu32ll_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu9ll  {
  unsigned int  :0;
  __tsu64 v1:32;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu32ll_BFu9ll) C1{ Fi:0 FL:32 FL:9}



static void Test_BFu0i_BFu32ll_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu9ll");
    static BFu0i_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu32ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu9ll(Test_BFu0i_BFu32ll_BFu9ll, "BFu0i_BFu32ll_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_BFu9s  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu32ll_BFu9s) C1{ Fi:0 FL:32 Fs:9}



static void Test_BFu0i_BFu32ll_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu32ll_BFu9s");
    static BFu0i_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu32ll_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_BFu9s(Test_BFu0i_BFu32ll_BFu9s, "BFu0i_BFu32ll_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_C  {
  unsigned int  :0;
  __tsu64 v1:32;
  char v2;
};
//SIG(1 BFu0i_BFu32ll_C) C1{ Fi:0 FL:32 Fc}



static void Test_BFu0i_BFu32ll_C()
{
  {
    init_simple_test("BFu0i_BFu32ll_C");
    static BFu0i_BFu32ll_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_C");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_C");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32ll_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_C(Test_BFu0i_BFu32ll_C, "BFu0i_BFu32ll_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_D  {
  unsigned int  :0;
  __tsu64 v1:32;
  double v2;
};
//SIG(1 BFu0i_BFu32ll_D) C1{ Fi:0 FL:32 FL}



static void Test_BFu0i_BFu32ll_D()
{
  {
    init_simple_test("BFu0i_BFu32ll_D");
    static BFu0i_BFu32ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu32ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_D");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu32ll_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_D(Test_BFu0i_BFu32ll_D, "BFu0i_BFu32ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_F  {
  unsigned int  :0;
  __tsu64 v1:32;
  float v2;
};
//SIG(1 BFu0i_BFu32ll_F) C1{ Fi:0 FL:32 Fi}



static void Test_BFu0i_BFu32ll_F()
{
  {
    init_simple_test("BFu0i_BFu32ll_F");
    static BFu0i_BFu32ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_F");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32ll_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_F(Test_BFu0i_BFu32ll_F, "BFu0i_BFu32ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_I  {
  unsigned int  :0;
  __tsu64 v1:32;
  int v2;
};
//SIG(1 BFu0i_BFu32ll_I) C1{ Fi:0 FL:32 Fi}



static void Test_BFu0i_BFu32ll_I()
{
  {
    init_simple_test("BFu0i_BFu32ll_I");
    static BFu0i_BFu32ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_I");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32ll_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_I(Test_BFu0i_BFu32ll_I, "BFu0i_BFu32ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_Ip  {
  unsigned int  :0;
  __tsu64 v1:32;
  int *v2;
};
//SIG(1 BFu0i_BFu32ll_Ip) C1{ Fi:0 FL:32 Fp}



static void Test_BFu0i_BFu32ll_Ip()
{
  {
    init_simple_test("BFu0i_BFu32ll_Ip");
    static BFu0i_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu32ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu32ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_Ip(Test_BFu0i_BFu32ll_Ip, "BFu0i_BFu32ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_L  {
  unsigned int  :0;
  __tsu64 v1:32;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu32ll_L) C1{ Fi:0 FL:32 FL}



static void Test_BFu0i_BFu32ll_L()
{
  {
    init_simple_test("BFu0i_BFu32ll_L");
    static BFu0i_BFu32ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu32ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_L");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu32ll_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_L(Test_BFu0i_BFu32ll_L, "BFu0i_BFu32ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_S  {
  unsigned int  :0;
  __tsu64 v1:32;
  short v2;
};
//SIG(1 BFu0i_BFu32ll_S) C1{ Fi:0 FL:32 Fs}



static void Test_BFu0i_BFu32ll_S()
{
  {
    init_simple_test("BFu0i_BFu32ll_S");
    static BFu0i_BFu32ll_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_S");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_S");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32ll_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_S(Test_BFu0i_BFu32ll_S, "BFu0i_BFu32ll_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_Uc  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu32ll_Uc) C1{ Fi:0 FL:32 Fc}



static void Test_BFu0i_BFu32ll_Uc()
{
  {
    init_simple_test("BFu0i_BFu32ll_Uc");
    static BFu0i_BFu32ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_Uc");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_Uc(Test_BFu0i_BFu32ll_Uc, "BFu0i_BFu32ll_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_Ui  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu32ll_Ui) C1{ Fi:0 FL:32 Fi}



static void Test_BFu0i_BFu32ll_Ui()
{
  {
    init_simple_test("BFu0i_BFu32ll_Ui");
    static BFu0i_BFu32ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_Ui(Test_BFu0i_BFu32ll_Ui, "BFu0i_BFu32ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_Ul  {
  unsigned int  :0;
  __tsu64 v1:32;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu32ll_Ul) C1{ Fi:0 FL:32 FL}



static void Test_BFu0i_BFu32ll_Ul()
{
  {
    init_simple_test("BFu0i_BFu32ll_Ul");
    static BFu0i_BFu32ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu32ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu32ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_Ul(Test_BFu0i_BFu32ll_Ul, "BFu0i_BFu32ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_Us  {
  unsigned int  :0;
  __tsu64 v1:32;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu32ll_Us) C1{ Fi:0 FL:32 Fs}



static void Test_BFu0i_BFu32ll_Us()
{
  {
    init_simple_test("BFu0i_BFu32ll_Us");
    static BFu0i_BFu32ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu32ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_Us");
    check_field_offset(lv, v2, 4, "BFu0i_BFu32ll_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_Us(Test_BFu0i_BFu32ll_Us, "BFu0i_BFu32ll_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu32ll_Vp  {
  unsigned int  :0;
  __tsu64 v1:32;
  void *v2;
};
//SIG(1 BFu0i_BFu32ll_Vp) C1{ Fi:0 FL:32 Fp}



static void Test_BFu0i_BFu32ll_Vp()
{
  {
    init_simple_test("BFu0i_BFu32ll_Vp");
    static BFu0i_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu32ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu32ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 32, 1, "BFu0i_BFu32ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu32ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu32ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu32ll_Vp(Test_BFu0i_BFu32ll_Vp, "BFu0i_BFu32ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33  {
  unsigned int  :0;
  __tsu64 v1:33;
};
//SIG(1 BFu0i_BFu33) C1{ Fi:0 FL:33}



static void Test_BFu0i_BFu33()
{
  {
    init_simple_test("BFu0i_BFu33");
    static BFu0i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33(Test_BFu0i_BFu33, "BFu0i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu0c  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu33_BFu0c) C1{ Fi:0 FL:33 Fc:0}



static void Test_BFu0i_BFu33_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu33_BFu0c");
    static BFu0i_BFu33_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu0c(Test_BFu0i_BFu33_BFu0c, "BFu0i_BFu33_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu0i  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu33_BFu0i) C1{ Fi:0 FL:33 Fi:0}



static void Test_BFu0i_BFu33_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu33_BFu0i");
    static BFu0i_BFu33_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu0i(Test_BFu0i_BFu33_BFu0i, "BFu0i_BFu33_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu0ll  {
  unsigned int  :0;
  __tsu64 v1:33;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu33_BFu0ll) C1{ Fi:0 FL:33 FL:0}



static void Test_BFu0i_BFu33_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu33_BFu0ll");
    static BFu0i_BFu33_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu0ll(Test_BFu0i_BFu33_BFu0ll, "BFu0i_BFu33_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu0s  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu33_BFu0s) C1{ Fi:0 FL:33 Fs:0}



static void Test_BFu0i_BFu33_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu33_BFu0s");
    static BFu0i_BFu33_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu0s(Test_BFu0i_BFu33_BFu0s, "BFu0i_BFu33_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu15i  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu33_BFu15i) C1{ Fi:0 FL:33 Fi:15}



static void Test_BFu0i_BFu33_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu33_BFu15i");
    static BFu0i_BFu33_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu0i_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu33_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu15i(Test_BFu0i_BFu33_BFu15i, "BFu0i_BFu33_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu15ll  {
  unsigned int  :0;
  __tsu64 v1:33;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu33_BFu15ll) C1{ Fi:0 FL:33 FL:15}



static void Test_BFu0i_BFu33_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu33_BFu15ll");
    static BFu0i_BFu33_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu0i_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu33_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu15ll(Test_BFu0i_BFu33_BFu15ll, "BFu0i_BFu33_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu15s  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu33_BFu15s) C1{ Fi:0 FL:33 Fs:15}



static void Test_BFu0i_BFu33_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu33_BFu15s");
    static BFu0i_BFu33_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 4, 1, 15, 1, "BFu0i_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 4, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu33_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu15s(Test_BFu0i_BFu33_BFu15s, "BFu0i_BFu33_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu16i  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu33_BFu16i) C1{ Fi:0 FL:33 Fi:16}



static void Test_BFu0i_BFu33_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu33_BFu16i");
    static BFu0i_BFu33_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu0i_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu0i_BFu33_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu16i(Test_BFu0i_BFu33_BFu16i, "BFu0i_BFu33_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu16ll  {
  unsigned int  :0;
  __tsu64 v1:33;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu33_BFu16ll) C1{ Fi:0 FL:33 FL:16}



static void Test_BFu0i_BFu33_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu33_BFu16ll");
    static BFu0i_BFu33_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 4, 1, 16, 1, "BFu0i_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 4, 1, 16, hide_ull(1LL<<15), "BFu0i_BFu33_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu16ll(Test_BFu0i_BFu33_BFu16ll, "BFu0i_BFu33_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu16s  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu33_BFu16s) C1{ Fi:0 FL:33 Fs:16}



static void Test_BFu0i_BFu33_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu33_BFu16s");
    static BFu0i_BFu33_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 6, 0, 16, 1, "BFu0i_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 6, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu33_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu16s(Test_BFu0i_BFu33_BFu16s, "BFu0i_BFu33_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu17i  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu33_BFu17i) C1{ Fi:0 FL:33 Fi:17}



static void Test_BFu0i_BFu33_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu33_BFu17i");
    static BFu0i_BFu33_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu0i_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu0i_BFu33_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu17i(Test_BFu0i_BFu33_BFu17i, "BFu0i_BFu33_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu17ll  {
  unsigned int  :0;
  __tsu64 v1:33;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu33_BFu17ll) C1{ Fi:0 FL:33 FL:17}



static void Test_BFu0i_BFu33_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu33_BFu17ll");
    static BFu0i_BFu33_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 4, 1, 17, 1, "BFu0i_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 4, 1, 17, hide_ull(1LL<<16), "BFu0i_BFu33_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu17ll(Test_BFu0i_BFu33_BFu17ll, "BFu0i_BFu33_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu1c  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu33_BFu1c) C1{ Fi:0 FL:33 Fc:1}



static void Test_BFu0i_BFu33_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu33_BFu1c");
    static BFu0i_BFu33_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu0i_BFu33_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu1c(Test_BFu0i_BFu33_BFu1c, "BFu0i_BFu33_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu1i  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu33_BFu1i) C1{ Fi:0 FL:33 Fi:1}



static void Test_BFu0i_BFu33_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu33_BFu1i");
    static BFu0i_BFu33_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu0i_BFu33_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu1i(Test_BFu0i_BFu33_BFu1i, "BFu0i_BFu33_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu1ll  {
  unsigned int  :0;
  __tsu64 v1:33;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu33_BFu1ll) C1{ Fi:0 FL:33 FL:1}



static void Test_BFu0i_BFu33_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu33_BFu1ll");
    static BFu0i_BFu33_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu0i_BFu33_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu1ll(Test_BFu0i_BFu33_BFu1ll, "BFu0i_BFu33_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu1s  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu33_BFu1s) C1{ Fi:0 FL:33 Fs:1}



static void Test_BFu0i_BFu33_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu33_BFu1s");
    static BFu0i_BFu33_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 4, 1, 1, 1, "BFu0i_BFu33_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu1s(Test_BFu0i_BFu33_BFu1s, "BFu0i_BFu33_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu31i  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu33_BFu31i) C1{ Fi:0 FL:33 Fi:31}



static void Test_BFu0i_BFu33_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu33_BFu31i");
    static BFu0i_BFu33_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu0i_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu0i_BFu33_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu31i(Test_BFu0i_BFu33_BFu31i, "BFu0i_BFu33_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu31ll  {
  unsigned int  :0;
  __tsu64 v1:33;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu33_BFu31ll) C1{ Fi:0 FL:33 FL:31}



static void Test_BFu0i_BFu33_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu33_BFu31ll");
    static BFu0i_BFu33_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 4, 1, 31, 1, "BFu0i_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 4, 1, 31, hide_ull(1LL<<30), "BFu0i_BFu33_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu31ll(Test_BFu0i_BFu33_BFu31ll, "BFu0i_BFu33_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu32i  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu33_BFu32i) C1{ Fi:0 FL:33 Fi:32}



static void Test_BFu0i_BFu33_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu33_BFu32i");
    static BFu0i_BFu33_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu33_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0i_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu33_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu32i(Test_BFu0i_BFu33_BFu32i, "BFu0i_BFu33_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu32ll  {
  unsigned int  :0;
  __tsu64 v1:33;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu33_BFu32ll) C1{ Fi:0 FL:33 FL:32}



static void Test_BFu0i_BFu33_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu33_BFu32ll");
    static BFu0i_BFu33_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu33_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "BFu0i_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "BFu0i_BFu33_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu32ll(Test_BFu0i_BFu33_BFu32ll, "BFu0i_BFu33_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu33  {
  unsigned int  :0;
  __tsu64 v1:33;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu33_BFu33) C1{ Fi:0 FL:33 FL:33}



static void Test_BFu0i_BFu33_BFu33()
{
  {
    init_simple_test("BFu0i_BFu33_BFu33");
    static BFu0i_BFu33_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu33_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "BFu0i_BFu33_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu33(Test_BFu0i_BFu33_BFu33, "BFu0i_BFu33_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu7c  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu33_BFu7c) C1{ Fi:0 FL:33 Fc:7}



static void Test_BFu0i_BFu33_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu33_BFu7c");
    static BFu0i_BFu33_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu0i_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu33_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu7c(Test_BFu0i_BFu33_BFu7c, "BFu0i_BFu33_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu7i  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu33_BFu7i) C1{ Fi:0 FL:33 Fi:7}



static void Test_BFu0i_BFu33_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu33_BFu7i");
    static BFu0i_BFu33_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu0i_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu33_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu7i(Test_BFu0i_BFu33_BFu7i, "BFu0i_BFu33_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu7ll  {
  unsigned int  :0;
  __tsu64 v1:33;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu33_BFu7ll) C1{ Fi:0 FL:33 FL:7}



static void Test_BFu0i_BFu33_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu33_BFu7ll");
    static BFu0i_BFu33_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu0i_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu33_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu7ll(Test_BFu0i_BFu33_BFu7ll, "BFu0i_BFu33_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu7s  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu33_BFu7s) C1{ Fi:0 FL:33 Fs:7}



static void Test_BFu0i_BFu33_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu33_BFu7s");
    static BFu0i_BFu33_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 4, 1, 7, 1, "BFu0i_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 4, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu33_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu7s(Test_BFu0i_BFu33_BFu7s, "BFu0i_BFu33_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu8c  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu33_BFu8c) C1{ Fi:0 FL:33 Fc:8}



static void Test_BFu0i_BFu33_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu33_BFu8c");
    static BFu0i_BFu33_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 5, 0, 8, 1, "BFu0i_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 5, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu33_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu8c(Test_BFu0i_BFu33_BFu8c, "BFu0i_BFu33_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu8i  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu33_BFu8i) C1{ Fi:0 FL:33 Fi:8}



static void Test_BFu0i_BFu33_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu33_BFu8i");
    static BFu0i_BFu33_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu0i_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu33_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu8i(Test_BFu0i_BFu33_BFu8i, "BFu0i_BFu33_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu8ll  {
  unsigned int  :0;
  __tsu64 v1:33;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu33_BFu8ll) C1{ Fi:0 FL:33 FL:8}



static void Test_BFu0i_BFu33_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu33_BFu8ll");
    static BFu0i_BFu33_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu0i_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu33_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu8ll(Test_BFu0i_BFu33_BFu8ll, "BFu0i_BFu33_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu8s  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu33_BFu8s) C1{ Fi:0 FL:33 Fs:8}



static void Test_BFu0i_BFu33_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu33_BFu8s");
    static BFu0i_BFu33_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 4, 1, 8, 1, "BFu0i_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 4, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu33_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu8s(Test_BFu0i_BFu33_BFu8s, "BFu0i_BFu33_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu9i  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu33_BFu9i) C1{ Fi:0 FL:33 Fi:9}



static void Test_BFu0i_BFu33_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu33_BFu9i");
    static BFu0i_BFu33_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu0i_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu33_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu9i(Test_BFu0i_BFu33_BFu9i, "BFu0i_BFu33_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu9ll  {
  unsigned int  :0;
  __tsu64 v1:33;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu33_BFu9ll) C1{ Fi:0 FL:33 FL:9}



static void Test_BFu0i_BFu33_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu33_BFu9ll");
    static BFu0i_BFu33_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu0i_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu33_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu9ll(Test_BFu0i_BFu33_BFu9ll, "BFu0i_BFu33_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_BFu9s  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu33_BFu9s) C1{ Fi:0 FL:33 Fs:9}



static void Test_BFu0i_BFu33_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu33_BFu9s");
    static BFu0i_BFu33_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 4, 1, 9, 1, "BFu0i_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 4, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu33_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_BFu9s(Test_BFu0i_BFu33_BFu9s, "BFu0i_BFu33_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_C  {
  unsigned int  :0;
  __tsu64 v1:33;
  char v2;
};
//SIG(1 BFu0i_BFu33_C) C1{ Fi:0 FL:33 Fc}



static void Test_BFu0i_BFu33_C()
{
  {
    init_simple_test("BFu0i_BFu33_C");
    static BFu0i_BFu33_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_C)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_C");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_C");
    check_field_offset(lv, v2, 5, "BFu0i_BFu33_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_C(Test_BFu0i_BFu33_C, "BFu0i_BFu33_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_D  {
  unsigned int  :0;
  __tsu64 v1:33;
  double v2;
};
//SIG(1 BFu0i_BFu33_D) C1{ Fi:0 FL:33 FL}



static void Test_BFu0i_BFu33_D()
{
  {
    init_simple_test("BFu0i_BFu33_D");
    static BFu0i_BFu33_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu0i_BFu33_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_D)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_D");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_D");
    check_field_offset(lv, v2, 8, "BFu0i_BFu33_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_D(Test_BFu0i_BFu33_D, "BFu0i_BFu33_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_F  {
  unsigned int  :0;
  __tsu64 v1:33;
  float v2;
};
//SIG(1 BFu0i_BFu33_F) C1{ Fi:0 FL:33 Fi}



static void Test_BFu0i_BFu33_F()
{
  {
    init_simple_test("BFu0i_BFu33_F");
    static BFu0i_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu33_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_F)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_F");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_F");
    check_field_offset(lv, v2, 8, "BFu0i_BFu33_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_F(Test_BFu0i_BFu33_F, "BFu0i_BFu33_F", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_I  {
  unsigned int  :0;
  __tsu64 v1:33;
  int v2;
};
//SIG(1 BFu0i_BFu33_I) C1{ Fi:0 FL:33 Fi}



static void Test_BFu0i_BFu33_I()
{
  {
    init_simple_test("BFu0i_BFu33_I");
    static BFu0i_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu33_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_I)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_I");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_I");
    check_field_offset(lv, v2, 8, "BFu0i_BFu33_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_I(Test_BFu0i_BFu33_I, "BFu0i_BFu33_I", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_Ip  {
  unsigned int  :0;
  __tsu64 v1:33;
  int *v2;
};
//SIG(1 BFu0i_BFu33_Ip) C1{ Fi:0 FL:33 Fp}



static void Test_BFu0i_BFu33_Ip()
{
  {
    init_simple_test("BFu0i_BFu33_Ip");
    static BFu0i_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu33_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_Ip");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_Ip");
    check_field_offset(lv, v2, 8, "BFu0i_BFu33_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_Ip(Test_BFu0i_BFu33_Ip, "BFu0i_BFu33_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_L  {
  unsigned int  :0;
  __tsu64 v1:33;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu33_L) C1{ Fi:0 FL:33 FL}



static void Test_BFu0i_BFu33_L()
{
  {
    init_simple_test("BFu0i_BFu33_L");
    static BFu0i_BFu33_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu0i_BFu33_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_L)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_L");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_L");
    check_field_offset(lv, v2, 8, "BFu0i_BFu33_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_L(Test_BFu0i_BFu33_L, "BFu0i_BFu33_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_S  {
  unsigned int  :0;
  __tsu64 v1:33;
  short v2;
};
//SIG(1 BFu0i_BFu33_S) C1{ Fi:0 FL:33 Fs}



static void Test_BFu0i_BFu33_S()
{
  {
    init_simple_test("BFu0i_BFu33_S");
    static BFu0i_BFu33_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_S)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_S");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_S");
    check_field_offset(lv, v2, 6, "BFu0i_BFu33_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_S(Test_BFu0i_BFu33_S, "BFu0i_BFu33_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_Uc  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu33_Uc) C1{ Fi:0 FL:33 Fc}



static void Test_BFu0i_BFu33_Uc()
{
  {
    init_simple_test("BFu0i_BFu33_Uc");
    static BFu0i_BFu33_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_Uc");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_Uc");
    check_field_offset(lv, v2, 5, "BFu0i_BFu33_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_Uc(Test_BFu0i_BFu33_Uc, "BFu0i_BFu33_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_Ui  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu33_Ui) C1{ Fi:0 FL:33 Fi}



static void Test_BFu0i_BFu33_Ui()
{
  {
    init_simple_test("BFu0i_BFu33_Ui");
    static BFu0i_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu33_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_Ui");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_Ui");
    check_field_offset(lv, v2, 8, "BFu0i_BFu33_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_Ui(Test_BFu0i_BFu33_Ui, "BFu0i_BFu33_Ui", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_Ul  {
  unsigned int  :0;
  __tsu64 v1:33;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu33_Ul) C1{ Fi:0 FL:33 FL}



static void Test_BFu0i_BFu33_Ul()
{
  {
    init_simple_test("BFu0i_BFu33_Ul");
    static BFu0i_BFu33_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu0i_BFu33_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_Ul");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_Ul");
    check_field_offset(lv, v2, 8, "BFu0i_BFu33_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_Ul(Test_BFu0i_BFu33_Ul, "BFu0i_BFu33_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_Us  {
  unsigned int  :0;
  __tsu64 v1:33;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu33_Us) C1{ Fi:0 FL:33 Fs}



static void Test_BFu0i_BFu33_Us()
{
  {
    init_simple_test("BFu0i_BFu33_Us");
    static BFu0i_BFu33_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu33_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_Us)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_Us");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_Us");
    check_field_offset(lv, v2, 6, "BFu0i_BFu33_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_Us(Test_BFu0i_BFu33_Us, "BFu0i_BFu33_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu33_Vp  {
  unsigned int  :0;
  __tsu64 v1:33;
  void *v2;
};
//SIG(1 BFu0i_BFu33_Vp) C1{ Fi:0 FL:33 Fp}



static void Test_BFu0i_BFu33_Vp()
{
  {
    init_simple_test("BFu0i_BFu33_Vp");
    static BFu0i_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu33_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu33_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 33, 1, "BFu0i_BFu33_Vp");
    set_bf_and_test(lv, v1, 0, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu33_Vp");
    check_field_offset(lv, v2, 8, "BFu0i_BFu33_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu33_Vp(Test_BFu0i_BFu33_Vp, "BFu0i_BFu33_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c  {
  unsigned int  :0;
  unsigned char v1:7;
};
//SIG(1 BFu0i_BFu7c) C1{ Fi:0 Fc:7}



static void Test_BFu0i_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu7c");
    static BFu0i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c(Test_BFu0i_BFu7c, "BFu0i_BFu7c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu0c  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu7c_BFu0c) C1{ Fi:0 Fc:7 Fc:0}



static void Test_BFu0i_BFu7c_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu0c");
    static BFu0i_BFu7c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu7c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu7c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu0c(Test_BFu0i_BFu7c_BFu0c, "BFu0i_BFu7c_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu0i  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu7c_BFu0i) C1{ Fi:0 Fc:7 Fi:0}



static void Test_BFu0i_BFu7c_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu0i");
    static BFu0i_BFu7c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu7c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu0i(Test_BFu0i_BFu7c_BFu0i, "BFu0i_BFu7c_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu0ll  {
  unsigned int  :0;
  unsigned char v1:7;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu7c_BFu0ll) C1{ Fi:0 Fc:7 FL:0}



static void Test_BFu0i_BFu7c_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu0ll");
    static BFu0i_BFu7c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu7c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu0ll(Test_BFu0i_BFu7c_BFu0ll, "BFu0i_BFu7c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu0s  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu7c_BFu0s) C1{ Fi:0 Fc:7 Fs:0}



static void Test_BFu0i_BFu7c_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu0s");
    static BFu0i_BFu7c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu7c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu0s(Test_BFu0i_BFu7c_BFu0s, "BFu0i_BFu7c_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu15i  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu7c_BFu15i) C1{ Fi:0 Fc:7 Fi:15}



static void Test_BFu0i_BFu7c_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu15i");
    static BFu0i_BFu7c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0i_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0i_BFu7c_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu15i(Test_BFu0i_BFu7c_BFu15i, "BFu0i_BFu7c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu15ll  {
  unsigned int  :0;
  unsigned char v1:7;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu7c_BFu15ll) C1{ Fi:0 Fc:7 FL:15}



static void Test_BFu0i_BFu7c_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu15ll");
    static BFu0i_BFu7c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0i_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0i_BFu7c_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu15ll(Test_BFu0i_BFu7c_BFu15ll, "BFu0i_BFu7c_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu15s  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu7c_BFu15s) C1{ Fi:0 Fc:7 Fs:15}



static void Test_BFu0i_BFu7c_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu15s");
    static BFu0i_BFu7c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7c_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu7c_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu15s(Test_BFu0i_BFu7c_BFu15s, "BFu0i_BFu7c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu16i  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu7c_BFu16i) C1{ Fi:0 Fc:7 Fi:16}



static void Test_BFu0i_BFu7c_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu16i");
    static BFu0i_BFu7c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0i_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0i_BFu7c_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu16i(Test_BFu0i_BFu7c_BFu16i, "BFu0i_BFu7c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu16ll  {
  unsigned int  :0;
  unsigned char v1:7;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu7c_BFu16ll) C1{ Fi:0 Fc:7 FL:16}



static void Test_BFu0i_BFu7c_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu16ll");
    static BFu0i_BFu7c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0i_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0i_BFu7c_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu16ll(Test_BFu0i_BFu7c_BFu16ll, "BFu0i_BFu7c_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu16s  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu7c_BFu16s) C1{ Fi:0 Fc:7 Fs:16}



static void Test_BFu0i_BFu7c_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu16s");
    static BFu0i_BFu7c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7c_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu7c_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu16s(Test_BFu0i_BFu7c_BFu16s, "BFu0i_BFu7c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu17i  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu7c_BFu17i) C1{ Fi:0 Fc:7 Fi:17}



static void Test_BFu0i_BFu7c_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu17i");
    static BFu0i_BFu7c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0i_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0i_BFu7c_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu17i(Test_BFu0i_BFu7c_BFu17i, "BFu0i_BFu7c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu17ll  {
  unsigned int  :0;
  unsigned char v1:7;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu7c_BFu17ll) C1{ Fi:0 Fc:7 FL:17}



static void Test_BFu0i_BFu7c_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu17ll");
    static BFu0i_BFu7c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0i_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0i_BFu7c_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu17ll(Test_BFu0i_BFu7c_BFu17ll, "BFu0i_BFu7c_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu1c  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu7c_BFu1c) C1{ Fi:0 Fc:7 Fc:1}



static void Test_BFu0i_BFu7c_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu1c");
    static BFu0i_BFu7c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu7c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu7c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7c_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu1c(Test_BFu0i_BFu7c_BFu1c, "BFu0i_BFu7c_BFu1c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu1i  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu7c_BFu1i) C1{ Fi:0 Fc:7 Fi:1}



static void Test_BFu0i_BFu7c_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu1i");
    static BFu0i_BFu7c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7c_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu1i(Test_BFu0i_BFu7c_BFu1i, "BFu0i_BFu7c_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu1ll  {
  unsigned int  :0;
  unsigned char v1:7;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu7c_BFu1ll) C1{ Fi:0 Fc:7 FL:1}



static void Test_BFu0i_BFu7c_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu1ll");
    static BFu0i_BFu7c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7c_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu1ll(Test_BFu0i_BFu7c_BFu1ll, "BFu0i_BFu7c_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu1s  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu7c_BFu1s) C1{ Fi:0 Fc:7 Fs:1}



static void Test_BFu0i_BFu7c_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu1s");
    static BFu0i_BFu7c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7c_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu1s(Test_BFu0i_BFu7c_BFu1s, "BFu0i_BFu7c_BFu1s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu31i  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu7c_BFu31i) C1{ Fi:0 Fc:7 Fi:31}



static void Test_BFu0i_BFu7c_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu31i");
    static BFu0i_BFu7c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu7c_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu31i(Test_BFu0i_BFu7c_BFu31i, "BFu0i_BFu7c_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu31ll  {
  unsigned int  :0;
  unsigned char v1:7;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu7c_BFu31ll) C1{ Fi:0 Fc:7 FL:31}



static void Test_BFu0i_BFu7c_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu31ll");
    static BFu0i_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu0i_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu0i_BFu7c_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu31ll(Test_BFu0i_BFu7c_BFu31ll, "BFu0i_BFu7c_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu32i  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu7c_BFu32i) C1{ Fi:0 Fc:7 Fi:32}



static void Test_BFu0i_BFu7c_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu32i");
    static BFu0i_BFu7c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu7c_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu32i(Test_BFu0i_BFu7c_BFu32i, "BFu0i_BFu7c_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu32ll  {
  unsigned int  :0;
  unsigned char v1:7;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu7c_BFu32ll) C1{ Fi:0 Fc:7 FL:32}



static void Test_BFu0i_BFu7c_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu32ll");
    static BFu0i_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu0i_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu0i_BFu7c_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu32ll(Test_BFu0i_BFu7c_BFu32ll, "BFu0i_BFu7c_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu33  {
  unsigned int  :0;
  unsigned char v1:7;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu7c_BFu33) C1{ Fi:0 Fc:7 FL:33}



static void Test_BFu0i_BFu7c_BFu33()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu33");
    static BFu0i_BFu7c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu0i_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu0i_BFu7c_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu33(Test_BFu0i_BFu7c_BFu33, "BFu0i_BFu7c_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu7c  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu7c_BFu7c) C1{ Fi:0 Fc:7 Fc:7}



static void Test_BFu0i_BFu7c_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu7c");
    static BFu0i_BFu7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu7c(Test_BFu0i_BFu7c_BFu7c, "BFu0i_BFu7c_BFu7c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu7i  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu7c_BFu7i) C1{ Fi:0 Fc:7 Fi:7}



static void Test_BFu0i_BFu7c_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu7i");
    static BFu0i_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0i_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu7i(Test_BFu0i_BFu7c_BFu7i, "BFu0i_BFu7c_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu7ll  {
  unsigned int  :0;
  unsigned char v1:7;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu7c_BFu7ll) C1{ Fi:0 Fc:7 FL:7}



static void Test_BFu0i_BFu7c_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu7ll");
    static BFu0i_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0i_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu7ll(Test_BFu0i_BFu7c_BFu7ll, "BFu0i_BFu7c_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu7s  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu7c_BFu7s) C1{ Fi:0 Fc:7 Fs:7}



static void Test_BFu0i_BFu7c_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu7s");
    static BFu0i_BFu7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0i_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu7s(Test_BFu0i_BFu7c_BFu7s, "BFu0i_BFu7c_BFu7s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu8c  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu7c_BFu8c) C1{ Fi:0 Fc:7 Fc:8}



static void Test_BFu0i_BFu7c_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu8c");
    static BFu0i_BFu7c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu7c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu7c_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu8c(Test_BFu0i_BFu7c_BFu8c, "BFu0i_BFu7c_BFu8c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu8i  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu7c_BFu8i) C1{ Fi:0 Fc:7 Fi:8}



static void Test_BFu0i_BFu7c_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu8i");
    static BFu0i_BFu7c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0i_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0i_BFu7c_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu8i(Test_BFu0i_BFu7c_BFu8i, "BFu0i_BFu7c_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu8ll  {
  unsigned int  :0;
  unsigned char v1:7;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu7c_BFu8ll) C1{ Fi:0 Fc:7 FL:8}



static void Test_BFu0i_BFu7c_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu8ll");
    static BFu0i_BFu7c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0i_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0i_BFu7c_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu8ll(Test_BFu0i_BFu7c_BFu8ll, "BFu0i_BFu7c_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu8s  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu7c_BFu8s) C1{ Fi:0 Fc:7 Fs:8}



static void Test_BFu0i_BFu7c_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu8s");
    static BFu0i_BFu7c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0i_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0i_BFu7c_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu8s(Test_BFu0i_BFu7c_BFu8s, "BFu0i_BFu7c_BFu8s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu9i  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu7c_BFu9i) C1{ Fi:0 Fc:7 Fi:9}



static void Test_BFu0i_BFu7c_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu9i");
    static BFu0i_BFu7c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0i_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0i_BFu7c_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu9i(Test_BFu0i_BFu7c_BFu9i, "BFu0i_BFu7c_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu9ll  {
  unsigned int  :0;
  unsigned char v1:7;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu7c_BFu9ll) C1{ Fi:0 Fc:7 FL:9}



static void Test_BFu0i_BFu7c_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu9ll");
    static BFu0i_BFu7c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0i_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0i_BFu7c_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu9ll(Test_BFu0i_BFu7c_BFu9ll, "BFu0i_BFu7c_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_BFu9s  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu7c_BFu9s) C1{ Fi:0 Fc:7 Fs:9}



static void Test_BFu0i_BFu7c_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu7c_BFu9s");
    static BFu0i_BFu7c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7c_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0i_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0i_BFu7c_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_BFu9s(Test_BFu0i_BFu7c_BFu9s, "BFu0i_BFu7c_BFu9s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_C  {
  unsigned int  :0;
  unsigned char v1:7;
  char v2;
};
//SIG(1 BFu0i_BFu7c_C) C1{ Fi:0 Fc:7 Fc}



static void Test_BFu0i_BFu7c_C()
{
  {
    init_simple_test("BFu0i_BFu7c_C");
    static BFu0i_BFu7c_C lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7c_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu7c_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_C");
    check_field_offset(lv, v2, 1, "BFu0i_BFu7c_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_C(Test_BFu0i_BFu7c_C, "BFu0i_BFu7c_C", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_D  {
  unsigned int  :0;
  unsigned char v1:7;
  double v2;
};
//SIG(1 BFu0i_BFu7c_D) C1{ Fi:0 Fc:7 FL}



static void Test_BFu0i_BFu7c_D()
{
  {
    init_simple_test("BFu0i_BFu7c_D");
    static BFu0i_BFu7c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu7c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7c_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_D(Test_BFu0i_BFu7c_D, "BFu0i_BFu7c_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_F  {
  unsigned int  :0;
  unsigned char v1:7;
  float v2;
};
//SIG(1 BFu0i_BFu7c_F) C1{ Fi:0 Fc:7 Fi}



static void Test_BFu0i_BFu7c_F()
{
  {
    init_simple_test("BFu0i_BFu7c_F");
    static BFu0i_BFu7c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7c_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu7c_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_F(Test_BFu0i_BFu7c_F, "BFu0i_BFu7c_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_I  {
  unsigned int  :0;
  unsigned char v1:7;
  int v2;
};
//SIG(1 BFu0i_BFu7c_I) C1{ Fi:0 Fc:7 Fi}



static void Test_BFu0i_BFu7c_I()
{
  {
    init_simple_test("BFu0i_BFu7c_I");
    static BFu0i_BFu7c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7c_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu7c_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_I(Test_BFu0i_BFu7c_I, "BFu0i_BFu7c_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_Ip  {
  unsigned int  :0;
  unsigned char v1:7;
  int *v2;
};
//SIG(1 BFu0i_BFu7c_Ip) C1{ Fi:0 Fc:7 Fp}



static void Test_BFu0i_BFu7c_Ip()
{
  {
    init_simple_test("BFu0i_BFu7c_Ip");
    static BFu0i_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu7c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7c_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_Ip(Test_BFu0i_BFu7c_Ip, "BFu0i_BFu7c_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_L  {
  unsigned int  :0;
  unsigned char v1:7;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu7c_L) C1{ Fi:0 Fc:7 FL}



static void Test_BFu0i_BFu7c_L()
{
  {
    init_simple_test("BFu0i_BFu7c_L");
    static BFu0i_BFu7c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu7c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7c_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_L(Test_BFu0i_BFu7c_L, "BFu0i_BFu7c_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_S  {
  unsigned int  :0;
  unsigned char v1:7;
  short v2;
};
//SIG(1 BFu0i_BFu7c_S) C1{ Fi:0 Fc:7 Fs}



static void Test_BFu0i_BFu7c_S()
{
  {
    init_simple_test("BFu0i_BFu7c_S");
    static BFu0i_BFu7c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7c_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7c_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu7c_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_S(Test_BFu0i_BFu7c_S, "BFu0i_BFu7c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_Uc  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu7c_Uc) C1{ Fi:0 Fc:7 Fc}



static void Test_BFu0i_BFu7c_Uc()
{
  {
    init_simple_test("BFu0i_BFu7c_Uc");
    static BFu0i_BFu7c_Uc lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7c_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu7c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_Uc");
    check_field_offset(lv, v2, 1, "BFu0i_BFu7c_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_Uc(Test_BFu0i_BFu7c_Uc, "BFu0i_BFu7c_Uc", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_Ui  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu7c_Ui) C1{ Fi:0 Fc:7 Fi}



static void Test_BFu0i_BFu7c_Ui()
{
  {
    init_simple_test("BFu0i_BFu7c_Ui");
    static BFu0i_BFu7c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu7c_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_Ui(Test_BFu0i_BFu7c_Ui, "BFu0i_BFu7c_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_Ul  {
  unsigned int  :0;
  unsigned char v1:7;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu7c_Ul) C1{ Fi:0 Fc:7 FL}



static void Test_BFu0i_BFu7c_Ul()
{
  {
    init_simple_test("BFu0i_BFu7c_Ul");
    static BFu0i_BFu7c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu7c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7c_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_Ul(Test_BFu0i_BFu7c_Ul, "BFu0i_BFu7c_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_Us  {
  unsigned int  :0;
  unsigned char v1:7;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu7c_Us) C1{ Fi:0 Fc:7 Fs}



static void Test_BFu0i_BFu7c_Us()
{
  {
    init_simple_test("BFu0i_BFu7c_Us");
    static BFu0i_BFu7c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7c_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu7c_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_Us(Test_BFu0i_BFu7c_Us, "BFu0i_BFu7c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7c_Vp  {
  unsigned int  :0;
  unsigned char v1:7;
  void *v2;
};
//SIG(1 BFu0i_BFu7c_Vp) C1{ Fi:0 Fc:7 Fp}



static void Test_BFu0i_BFu7c_Vp()
{
  {
    init_simple_test("BFu0i_BFu7c_Vp");
    static BFu0i_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu7c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7c_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7c_Vp(Test_BFu0i_BFu7c_Vp, "BFu0i_BFu7c_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i  {
  unsigned int  :0;
  unsigned int v1:7;
};
//SIG(1 BFu0i_BFu7i) C1{ Fi:0 Fi:7}



static void Test_BFu0i_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu7i");
    static BFu0i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i(Test_BFu0i_BFu7i, "BFu0i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu0c  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu7i_BFu0c) C1{ Fi:0 Fi:7 Fc:0}



static void Test_BFu0i_BFu7i_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu0c");
    static BFu0i_BFu7i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu0c(Test_BFu0i_BFu7i_BFu0c, "BFu0i_BFu7i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu0i  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu7i_BFu0i) C1{ Fi:0 Fi:7 Fi:0}



static void Test_BFu0i_BFu7i_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu0i");
    static BFu0i_BFu7i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu0i(Test_BFu0i_BFu7i_BFu0i, "BFu0i_BFu7i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu0ll  {
  unsigned int  :0;
  unsigned int v1:7;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu7i_BFu0ll) C1{ Fi:0 Fi:7 FL:0}



static void Test_BFu0i_BFu7i_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu0ll");
    static BFu0i_BFu7i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0i_BFu7i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu0ll(Test_BFu0i_BFu7i_BFu0ll, "BFu0i_BFu7i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu0s  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu7i_BFu0s) C1{ Fi:0 Fi:7 Fs:0}



static void Test_BFu0i_BFu7i_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu0s");
    static BFu0i_BFu7i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu0s(Test_BFu0i_BFu7i_BFu0s, "BFu0i_BFu7i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu15i  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu7i_BFu15i) C1{ Fi:0 Fi:7 Fi:15}



static void Test_BFu0i_BFu7i_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu15i");
    static BFu0i_BFu7i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0i_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0i_BFu7i_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu15i(Test_BFu0i_BFu7i_BFu15i, "BFu0i_BFu7i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu15ll  {
  unsigned int  :0;
  unsigned int v1:7;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu7i_BFu15ll) C1{ Fi:0 Fi:7 FL:15}



static void Test_BFu0i_BFu7i_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu15ll");
    static BFu0i_BFu7i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0i_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0i_BFu7i_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu15ll(Test_BFu0i_BFu7i_BFu15ll, "BFu0i_BFu7i_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu15s  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu7i_BFu15s) C1{ Fi:0 Fi:7 Fs:15}



static void Test_BFu0i_BFu7i_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu15s");
    static BFu0i_BFu7i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu7i_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu15s(Test_BFu0i_BFu7i_BFu15s, "BFu0i_BFu7i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu16i  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu7i_BFu16i) C1{ Fi:0 Fi:7 Fi:16}



static void Test_BFu0i_BFu7i_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu16i");
    static BFu0i_BFu7i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0i_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0i_BFu7i_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu16i(Test_BFu0i_BFu7i_BFu16i, "BFu0i_BFu7i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu16ll  {
  unsigned int  :0;
  unsigned int v1:7;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu7i_BFu16ll) C1{ Fi:0 Fi:7 FL:16}



static void Test_BFu0i_BFu7i_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu16ll");
    static BFu0i_BFu7i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0i_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0i_BFu7i_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu16ll(Test_BFu0i_BFu7i_BFu16ll, "BFu0i_BFu7i_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu16s  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu7i_BFu16s) C1{ Fi:0 Fi:7 Fs:16}



static void Test_BFu0i_BFu7i_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu16s");
    static BFu0i_BFu7i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu7i_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu16s(Test_BFu0i_BFu7i_BFu16s, "BFu0i_BFu7i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu17i  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu7i_BFu17i) C1{ Fi:0 Fi:7 Fi:17}



static void Test_BFu0i_BFu7i_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu17i");
    static BFu0i_BFu7i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0i_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0i_BFu7i_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu17i(Test_BFu0i_BFu7i_BFu17i, "BFu0i_BFu7i_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu17ll  {
  unsigned int  :0;
  unsigned int v1:7;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu7i_BFu17ll) C1{ Fi:0 Fi:7 FL:17}



static void Test_BFu0i_BFu7i_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu17ll");
    static BFu0i_BFu7i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0i_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0i_BFu7i_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu17ll(Test_BFu0i_BFu7i_BFu17ll, "BFu0i_BFu7i_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu1c  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu7i_BFu1c) C1{ Fi:0 Fi:7 Fc:1}



static void Test_BFu0i_BFu7i_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu1c");
    static BFu0i_BFu7i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7i_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu1c(Test_BFu0i_BFu7i_BFu1c, "BFu0i_BFu7i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu1i  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu7i_BFu1i) C1{ Fi:0 Fi:7 Fi:1}



static void Test_BFu0i_BFu7i_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu1i");
    static BFu0i_BFu7i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7i_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu1i(Test_BFu0i_BFu7i_BFu1i, "BFu0i_BFu7i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu1ll  {
  unsigned int  :0;
  unsigned int v1:7;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu7i_BFu1ll) C1{ Fi:0 Fi:7 FL:1}



static void Test_BFu0i_BFu7i_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu1ll");
    static BFu0i_BFu7i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7i_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu1ll(Test_BFu0i_BFu7i_BFu1ll, "BFu0i_BFu7i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu1s  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu7i_BFu1s) C1{ Fi:0 Fi:7 Fs:1}



static void Test_BFu0i_BFu7i_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu1s");
    static BFu0i_BFu7i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7i_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu1s(Test_BFu0i_BFu7i_BFu1s, "BFu0i_BFu7i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu31i  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu7i_BFu31i) C1{ Fi:0 Fi:7 Fi:31}



static void Test_BFu0i_BFu7i_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu31i");
    static BFu0i_BFu7i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu7i_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu31i(Test_BFu0i_BFu7i_BFu31i, "BFu0i_BFu7i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu31ll  {
  unsigned int  :0;
  unsigned int v1:7;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu7i_BFu31ll) C1{ Fi:0 Fi:7 FL:31}



static void Test_BFu0i_BFu7i_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu31ll");
    static BFu0i_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu0i_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu0i_BFu7i_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu31ll(Test_BFu0i_BFu7i_BFu31ll, "BFu0i_BFu7i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu32i  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu7i_BFu32i) C1{ Fi:0 Fi:7 Fi:32}



static void Test_BFu0i_BFu7i_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu32i");
    static BFu0i_BFu7i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu7i_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu32i(Test_BFu0i_BFu7i_BFu32i, "BFu0i_BFu7i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu32ll  {
  unsigned int  :0;
  unsigned int v1:7;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu7i_BFu32ll) C1{ Fi:0 Fi:7 FL:32}



static void Test_BFu0i_BFu7i_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu32ll");
    static BFu0i_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu0i_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu0i_BFu7i_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu32ll(Test_BFu0i_BFu7i_BFu32ll, "BFu0i_BFu7i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu33  {
  unsigned int  :0;
  unsigned int v1:7;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu7i_BFu33) C1{ Fi:0 Fi:7 FL:33}



static void Test_BFu0i_BFu7i_BFu33()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu33");
    static BFu0i_BFu7i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu0i_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu0i_BFu7i_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu33(Test_BFu0i_BFu7i_BFu33, "BFu0i_BFu7i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu7c  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu7i_BFu7c) C1{ Fi:0 Fi:7 Fc:7}



static void Test_BFu0i_BFu7i_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu7c");
    static BFu0i_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu7c(Test_BFu0i_BFu7i_BFu7c, "BFu0i_BFu7i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu7i  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu7i_BFu7i) C1{ Fi:0 Fi:7 Fi:7}



static void Test_BFu0i_BFu7i_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu7i");
    static BFu0i_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0i_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu7i(Test_BFu0i_BFu7i_BFu7i, "BFu0i_BFu7i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu7ll  {
  unsigned int  :0;
  unsigned int v1:7;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu7i_BFu7ll) C1{ Fi:0 Fi:7 FL:7}



static void Test_BFu0i_BFu7i_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu7ll");
    static BFu0i_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0i_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu7ll(Test_BFu0i_BFu7i_BFu7ll, "BFu0i_BFu7i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu7s  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu7i_BFu7s) C1{ Fi:0 Fi:7 Fs:7}



static void Test_BFu0i_BFu7i_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu7s");
    static BFu0i_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0i_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu7s(Test_BFu0i_BFu7i_BFu7s, "BFu0i_BFu7i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu8c  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu7i_BFu8c) C1{ Fi:0 Fi:7 Fc:8}



static void Test_BFu0i_BFu7i_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu8c");
    static BFu0i_BFu7i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu7i_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu8c(Test_BFu0i_BFu7i_BFu8c, "BFu0i_BFu7i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu8i  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu7i_BFu8i) C1{ Fi:0 Fi:7 Fi:8}



static void Test_BFu0i_BFu7i_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu8i");
    static BFu0i_BFu7i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0i_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0i_BFu7i_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu8i(Test_BFu0i_BFu7i_BFu8i, "BFu0i_BFu7i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu8ll  {
  unsigned int  :0;
  unsigned int v1:7;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu7i_BFu8ll) C1{ Fi:0 Fi:7 FL:8}



static void Test_BFu0i_BFu7i_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu8ll");
    static BFu0i_BFu7i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0i_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0i_BFu7i_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu8ll(Test_BFu0i_BFu7i_BFu8ll, "BFu0i_BFu7i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu8s  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu7i_BFu8s) C1{ Fi:0 Fi:7 Fs:8}



static void Test_BFu0i_BFu7i_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu8s");
    static BFu0i_BFu7i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0i_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0i_BFu7i_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu8s(Test_BFu0i_BFu7i_BFu8s, "BFu0i_BFu7i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu9i  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu7i_BFu9i) C1{ Fi:0 Fi:7 Fi:9}



static void Test_BFu0i_BFu7i_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu9i");
    static BFu0i_BFu7i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0i_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0i_BFu7i_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu9i(Test_BFu0i_BFu7i_BFu9i, "BFu0i_BFu7i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu9ll  {
  unsigned int  :0;
  unsigned int v1:7;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu7i_BFu9ll) C1{ Fi:0 Fi:7 FL:9}



static void Test_BFu0i_BFu7i_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu9ll");
    static BFu0i_BFu7i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0i_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0i_BFu7i_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu9ll(Test_BFu0i_BFu7i_BFu9ll, "BFu0i_BFu7i_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_BFu9s  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu7i_BFu9s) C1{ Fi:0 Fi:7 Fs:9}



static void Test_BFu0i_BFu7i_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu7i_BFu9s");
    static BFu0i_BFu7i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0i_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0i_BFu7i_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_BFu9s(Test_BFu0i_BFu7i_BFu9s, "BFu0i_BFu7i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_C  {
  unsigned int  :0;
  unsigned int v1:7;
  char v2;
};
//SIG(1 BFu0i_BFu7i_C) C1{ Fi:0 Fi:7 Fc}



static void Test_BFu0i_BFu7i_C()
{
  {
    init_simple_test("BFu0i_BFu7i_C");
    static BFu0i_BFu7i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_C");
    check_field_offset(lv, v2, 1, "BFu0i_BFu7i_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_C(Test_BFu0i_BFu7i_C, "BFu0i_BFu7i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_D  {
  unsigned int  :0;
  unsigned int v1:7;
  double v2;
};
//SIG(1 BFu0i_BFu7i_D) C1{ Fi:0 Fi:7 FL}



static void Test_BFu0i_BFu7i_D()
{
  {
    init_simple_test("BFu0i_BFu7i_D");
    static BFu0i_BFu7i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu7i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7i_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_D(Test_BFu0i_BFu7i_D, "BFu0i_BFu7i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_F  {
  unsigned int  :0;
  unsigned int v1:7;
  float v2;
};
//SIG(1 BFu0i_BFu7i_F) C1{ Fi:0 Fi:7 Fi}



static void Test_BFu0i_BFu7i_F()
{
  {
    init_simple_test("BFu0i_BFu7i_F");
    static BFu0i_BFu7i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu7i_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_F(Test_BFu0i_BFu7i_F, "BFu0i_BFu7i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_I  {
  unsigned int  :0;
  unsigned int v1:7;
  int v2;
};
//SIG(1 BFu0i_BFu7i_I) C1{ Fi:0 Fi:7 Fi}



static void Test_BFu0i_BFu7i_I()
{
  {
    init_simple_test("BFu0i_BFu7i_I");
    static BFu0i_BFu7i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu7i_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_I(Test_BFu0i_BFu7i_I, "BFu0i_BFu7i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_Ip  {
  unsigned int  :0;
  unsigned int v1:7;
  int *v2;
};
//SIG(1 BFu0i_BFu7i_Ip) C1{ Fi:0 Fi:7 Fp}



static void Test_BFu0i_BFu7i_Ip()
{
  {
    init_simple_test("BFu0i_BFu7i_Ip");
    static BFu0i_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu7i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7i_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_Ip(Test_BFu0i_BFu7i_Ip, "BFu0i_BFu7i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_L  {
  unsigned int  :0;
  unsigned int v1:7;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu7i_L) C1{ Fi:0 Fi:7 FL}



static void Test_BFu0i_BFu7i_L()
{
  {
    init_simple_test("BFu0i_BFu7i_L");
    static BFu0i_BFu7i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu7i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7i_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_L(Test_BFu0i_BFu7i_L, "BFu0i_BFu7i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_S  {
  unsigned int  :0;
  unsigned int v1:7;
  short v2;
};
//SIG(1 BFu0i_BFu7i_S) C1{ Fi:0 Fi:7 Fs}



static void Test_BFu0i_BFu7i_S()
{
  {
    init_simple_test("BFu0i_BFu7i_S");
    static BFu0i_BFu7i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu7i_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_S(Test_BFu0i_BFu7i_S, "BFu0i_BFu7i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_Uc  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu7i_Uc) C1{ Fi:0 Fi:7 Fc}



static void Test_BFu0i_BFu7i_Uc()
{
  {
    init_simple_test("BFu0i_BFu7i_Uc");
    static BFu0i_BFu7i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_Uc");
    check_field_offset(lv, v2, 1, "BFu0i_BFu7i_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_Uc(Test_BFu0i_BFu7i_Uc, "BFu0i_BFu7i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_Ui  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu7i_Ui) C1{ Fi:0 Fi:7 Fi}



static void Test_BFu0i_BFu7i_Ui()
{
  {
    init_simple_test("BFu0i_BFu7i_Ui");
    static BFu0i_BFu7i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu7i_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_Ui(Test_BFu0i_BFu7i_Ui, "BFu0i_BFu7i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_Ul  {
  unsigned int  :0;
  unsigned int v1:7;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu7i_Ul) C1{ Fi:0 Fi:7 FL}



static void Test_BFu0i_BFu7i_Ul()
{
  {
    init_simple_test("BFu0i_BFu7i_Ul");
    static BFu0i_BFu7i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu7i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7i_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_Ul(Test_BFu0i_BFu7i_Ul, "BFu0i_BFu7i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_Us  {
  unsigned int  :0;
  unsigned int v1:7;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu7i_Us) C1{ Fi:0 Fi:7 Fs}



static void Test_BFu0i_BFu7i_Us()
{
  {
    init_simple_test("BFu0i_BFu7i_Us");
    static BFu0i_BFu7i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu7i_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_Us(Test_BFu0i_BFu7i_Us, "BFu0i_BFu7i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7i_Vp  {
  unsigned int  :0;
  unsigned int v1:7;
  void *v2;
};
//SIG(1 BFu0i_BFu7i_Vp) C1{ Fi:0 Fi:7 Fp}



static void Test_BFu0i_BFu7i_Vp()
{
  {
    init_simple_test("BFu0i_BFu7i_Vp");
    static BFu0i_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu7i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7i_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7i_Vp(Test_BFu0i_BFu7i_Vp, "BFu0i_BFu7i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll  {
  unsigned int  :0;
  __tsu64 v1:7;
};
//SIG(1 BFu0i_BFu7ll) C1{ Fi:0 FL:7}



static void Test_BFu0i_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu7ll");
    static BFu0i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll(Test_BFu0i_BFu7ll, "BFu0i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu0c  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu7ll_BFu0c) C1{ Fi:0 FL:7 Fc:0}



static void Test_BFu0i_BFu7ll_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu0c");
    static BFu0i_BFu7ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu0c(Test_BFu0i_BFu7ll_BFu0c, "BFu0i_BFu7ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu0i  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu7ll_BFu0i) C1{ Fi:0 FL:7 Fi:0}



static void Test_BFu0i_BFu7ll_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu0i");
    static BFu0i_BFu7ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu0i(Test_BFu0i_BFu7ll_BFu0i, "BFu0i_BFu7ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu0ll  {
  unsigned int  :0;
  __tsu64 v1:7;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu7ll_BFu0ll) C1{ Fi:0 FL:7 FL:0}



static void Test_BFu0i_BFu7ll_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu0ll");
    static BFu0i_BFu7ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu0ll(Test_BFu0i_BFu7ll_BFu0ll, "BFu0i_BFu7ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu0s  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu7ll_BFu0s) C1{ Fi:0 FL:7 Fs:0}



static void Test_BFu0i_BFu7ll_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu0s");
    static BFu0i_BFu7ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu0s(Test_BFu0i_BFu7ll_BFu0s, "BFu0i_BFu7ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu15i  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu7ll_BFu15i) C1{ Fi:0 FL:7 Fi:15}



static void Test_BFu0i_BFu7ll_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu15i");
    static BFu0i_BFu7ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0i_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0i_BFu7ll_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu15i(Test_BFu0i_BFu7ll_BFu15i, "BFu0i_BFu7ll_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu15ll  {
  unsigned int  :0;
  __tsu64 v1:7;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu7ll_BFu15ll) C1{ Fi:0 FL:7 FL:15}



static void Test_BFu0i_BFu7ll_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu15ll");
    static BFu0i_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0i_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0i_BFu7ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu15ll(Test_BFu0i_BFu7ll_BFu15ll, "BFu0i_BFu7ll_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu15s  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu7ll_BFu15s) C1{ Fi:0 FL:7 Fs:15}



static void Test_BFu0i_BFu7ll_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu15s");
    static BFu0i_BFu7ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu7ll_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu15s(Test_BFu0i_BFu7ll_BFu15s, "BFu0i_BFu7ll_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu16i  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu7ll_BFu16i) C1{ Fi:0 FL:7 Fi:16}



static void Test_BFu0i_BFu7ll_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu16i");
    static BFu0i_BFu7ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0i_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0i_BFu7ll_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu16i(Test_BFu0i_BFu7ll_BFu16i, "BFu0i_BFu7ll_BFu16i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu16ll  {
  unsigned int  :0;
  __tsu64 v1:7;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu7ll_BFu16ll) C1{ Fi:0 FL:7 FL:16}



static void Test_BFu0i_BFu7ll_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu16ll");
    static BFu0i_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0i_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0i_BFu7ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu16ll(Test_BFu0i_BFu7ll_BFu16ll, "BFu0i_BFu7ll_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu16s  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu7ll_BFu16s) C1{ Fi:0 FL:7 Fs:16}



static void Test_BFu0i_BFu7ll_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu16s");
    static BFu0i_BFu7ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu7ll_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu16s(Test_BFu0i_BFu7ll_BFu16s, "BFu0i_BFu7ll_BFu16s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu17i  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu7ll_BFu17i) C1{ Fi:0 FL:7 Fi:17}



static void Test_BFu0i_BFu7ll_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu17i");
    static BFu0i_BFu7ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0i_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0i_BFu7ll_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu17i(Test_BFu0i_BFu7ll_BFu17i, "BFu0i_BFu7ll_BFu17i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu17ll  {
  unsigned int  :0;
  __tsu64 v1:7;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu7ll_BFu17ll) C1{ Fi:0 FL:7 FL:17}



static void Test_BFu0i_BFu7ll_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu17ll");
    static BFu0i_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0i_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0i_BFu7ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu17ll(Test_BFu0i_BFu7ll_BFu17ll, "BFu0i_BFu7ll_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu1c  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu7ll_BFu1c) C1{ Fi:0 FL:7 Fc:1}



static void Test_BFu0i_BFu7ll_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu1c");
    static BFu0i_BFu7ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7ll_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu1c(Test_BFu0i_BFu7ll_BFu1c, "BFu0i_BFu7ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu1i  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu7ll_BFu1i) C1{ Fi:0 FL:7 Fi:1}



static void Test_BFu0i_BFu7ll_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu1i");
    static BFu0i_BFu7ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7ll_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu1i(Test_BFu0i_BFu7ll_BFu1i, "BFu0i_BFu7ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu1ll  {
  unsigned int  :0;
  __tsu64 v1:7;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu7ll_BFu1ll) C1{ Fi:0 FL:7 FL:1}



static void Test_BFu0i_BFu7ll_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu1ll");
    static BFu0i_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu1ll(Test_BFu0i_BFu7ll_BFu1ll, "BFu0i_BFu7ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu1s  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu7ll_BFu1s) C1{ Fi:0 FL:7 Fs:1}



static void Test_BFu0i_BFu7ll_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu1s");
    static BFu0i_BFu7ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7ll_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu1s(Test_BFu0i_BFu7ll_BFu1s, "BFu0i_BFu7ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu31i  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu7ll_BFu31i) C1{ Fi:0 FL:7 Fi:31}



static void Test_BFu0i_BFu7ll_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu31i");
    static BFu0i_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu7ll_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu31i(Test_BFu0i_BFu7ll_BFu31i, "BFu0i_BFu7ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu31ll  {
  unsigned int  :0;
  __tsu64 v1:7;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu7ll_BFu31ll) C1{ Fi:0 FL:7 FL:31}



static void Test_BFu0i_BFu7ll_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu31ll");
    static BFu0i_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu0i_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu0i_BFu7ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu31ll(Test_BFu0i_BFu7ll_BFu31ll, "BFu0i_BFu7ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu32i  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu7ll_BFu32i) C1{ Fi:0 FL:7 Fi:32}



static void Test_BFu0i_BFu7ll_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu32i");
    static BFu0i_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu7ll_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu32i(Test_BFu0i_BFu7ll_BFu32i, "BFu0i_BFu7ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu32ll  {
  unsigned int  :0;
  __tsu64 v1:7;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu7ll_BFu32ll) C1{ Fi:0 FL:7 FL:32}



static void Test_BFu0i_BFu7ll_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu32ll");
    static BFu0i_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu0i_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu0i_BFu7ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu32ll(Test_BFu0i_BFu7ll_BFu32ll, "BFu0i_BFu7ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu33  {
  unsigned int  :0;
  __tsu64 v1:7;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu7ll_BFu33) C1{ Fi:0 FL:7 FL:33}



static void Test_BFu0i_BFu7ll_BFu33()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu33");
    static BFu0i_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu0i_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu0i_BFu7ll_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu33(Test_BFu0i_BFu7ll_BFu33, "BFu0i_BFu7ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu7c  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu7ll_BFu7c) C1{ Fi:0 FL:7 Fc:7}



static void Test_BFu0i_BFu7ll_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu7c");
    static BFu0i_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu7c(Test_BFu0i_BFu7ll_BFu7c, "BFu0i_BFu7ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu7i  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu7ll_BFu7i) C1{ Fi:0 FL:7 Fi:7}



static void Test_BFu0i_BFu7ll_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu7i");
    static BFu0i_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0i_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu7i(Test_BFu0i_BFu7ll_BFu7i, "BFu0i_BFu7ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu7ll  {
  unsigned int  :0;
  __tsu64 v1:7;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu7ll_BFu7ll) C1{ Fi:0 FL:7 FL:7}



static void Test_BFu0i_BFu7ll_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu7ll");
    static BFu0i_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0i_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu7ll(Test_BFu0i_BFu7ll_BFu7ll, "BFu0i_BFu7ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu7s  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu7ll_BFu7s) C1{ Fi:0 FL:7 Fs:7}



static void Test_BFu0i_BFu7ll_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu7s");
    static BFu0i_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0i_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu7s(Test_BFu0i_BFu7ll_BFu7s, "BFu0i_BFu7ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu8c  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu7ll_BFu8c) C1{ Fi:0 FL:7 Fc:8}



static void Test_BFu0i_BFu7ll_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu8c");
    static BFu0i_BFu7ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu7ll_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu8c(Test_BFu0i_BFu7ll_BFu8c, "BFu0i_BFu7ll_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu8i  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu7ll_BFu8i) C1{ Fi:0 FL:7 Fi:8}



static void Test_BFu0i_BFu7ll_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu8i");
    static BFu0i_BFu7ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0i_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0i_BFu7ll_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu8i(Test_BFu0i_BFu7ll_BFu8i, "BFu0i_BFu7ll_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu8ll  {
  unsigned int  :0;
  __tsu64 v1:7;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu7ll_BFu8ll) C1{ Fi:0 FL:7 FL:8}



static void Test_BFu0i_BFu7ll_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu8ll");
    static BFu0i_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0i_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0i_BFu7ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu8ll(Test_BFu0i_BFu7ll_BFu8ll, "BFu0i_BFu7ll_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu8s  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu7ll_BFu8s) C1{ Fi:0 FL:7 Fs:8}



static void Test_BFu0i_BFu7ll_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu8s");
    static BFu0i_BFu7ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0i_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0i_BFu7ll_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu8s(Test_BFu0i_BFu7ll_BFu8s, "BFu0i_BFu7ll_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu9i  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu7ll_BFu9i) C1{ Fi:0 FL:7 Fi:9}



static void Test_BFu0i_BFu7ll_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu9i");
    static BFu0i_BFu7ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0i_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0i_BFu7ll_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu9i(Test_BFu0i_BFu7ll_BFu9i, "BFu0i_BFu7ll_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu9ll  {
  unsigned int  :0;
  __tsu64 v1:7;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu7ll_BFu9ll) C1{ Fi:0 FL:7 FL:9}



static void Test_BFu0i_BFu7ll_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu9ll");
    static BFu0i_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0i_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0i_BFu7ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu9ll(Test_BFu0i_BFu7ll_BFu9ll, "BFu0i_BFu7ll_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_BFu9s  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu7ll_BFu9s) C1{ Fi:0 FL:7 Fs:9}



static void Test_BFu0i_BFu7ll_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu7ll_BFu9s");
    static BFu0i_BFu7ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0i_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0i_BFu7ll_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_BFu9s(Test_BFu0i_BFu7ll_BFu9s, "BFu0i_BFu7ll_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_C  {
  unsigned int  :0;
  __tsu64 v1:7;
  char v2;
};
//SIG(1 BFu0i_BFu7ll_C) C1{ Fi:0 FL:7 Fc}



static void Test_BFu0i_BFu7ll_C()
{
  {
    init_simple_test("BFu0i_BFu7ll_C");
    static BFu0i_BFu7ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_C");
    check_field_offset(lv, v2, 1, "BFu0i_BFu7ll_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_C(Test_BFu0i_BFu7ll_C, "BFu0i_BFu7ll_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_D  {
  unsigned int  :0;
  __tsu64 v1:7;
  double v2;
};
//SIG(1 BFu0i_BFu7ll_D) C1{ Fi:0 FL:7 FL}



static void Test_BFu0i_BFu7ll_D()
{
  {
    init_simple_test("BFu0i_BFu7ll_D");
    static BFu0i_BFu7ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu7ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7ll_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_D(Test_BFu0i_BFu7ll_D, "BFu0i_BFu7ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_F  {
  unsigned int  :0;
  __tsu64 v1:7;
  float v2;
};
//SIG(1 BFu0i_BFu7ll_F) C1{ Fi:0 FL:7 Fi}



static void Test_BFu0i_BFu7ll_F()
{
  {
    init_simple_test("BFu0i_BFu7ll_F");
    static BFu0i_BFu7ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu7ll_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_F(Test_BFu0i_BFu7ll_F, "BFu0i_BFu7ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_I  {
  unsigned int  :0;
  __tsu64 v1:7;
  int v2;
};
//SIG(1 BFu0i_BFu7ll_I) C1{ Fi:0 FL:7 Fi}



static void Test_BFu0i_BFu7ll_I()
{
  {
    init_simple_test("BFu0i_BFu7ll_I");
    static BFu0i_BFu7ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu7ll_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_I(Test_BFu0i_BFu7ll_I, "BFu0i_BFu7ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_Ip  {
  unsigned int  :0;
  __tsu64 v1:7;
  int *v2;
};
//SIG(1 BFu0i_BFu7ll_Ip) C1{ Fi:0 FL:7 Fp}



static void Test_BFu0i_BFu7ll_Ip()
{
  {
    init_simple_test("BFu0i_BFu7ll_Ip");
    static BFu0i_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu7ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_Ip(Test_BFu0i_BFu7ll_Ip, "BFu0i_BFu7ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_L  {
  unsigned int  :0;
  __tsu64 v1:7;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu7ll_L) C1{ Fi:0 FL:7 FL}



static void Test_BFu0i_BFu7ll_L()
{
  {
    init_simple_test("BFu0i_BFu7ll_L");
    static BFu0i_BFu7ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu7ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7ll_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_L(Test_BFu0i_BFu7ll_L, "BFu0i_BFu7ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_S  {
  unsigned int  :0;
  __tsu64 v1:7;
  short v2;
};
//SIG(1 BFu0i_BFu7ll_S) C1{ Fi:0 FL:7 Fs}



static void Test_BFu0i_BFu7ll_S()
{
  {
    init_simple_test("BFu0i_BFu7ll_S");
    static BFu0i_BFu7ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu7ll_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_S(Test_BFu0i_BFu7ll_S, "BFu0i_BFu7ll_S", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_Uc  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu7ll_Uc) C1{ Fi:0 FL:7 Fc}



static void Test_BFu0i_BFu7ll_Uc()
{
  {
    init_simple_test("BFu0i_BFu7ll_Uc");
    static BFu0i_BFu7ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_Uc");
    check_field_offset(lv, v2, 1, "BFu0i_BFu7ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_Uc(Test_BFu0i_BFu7ll_Uc, "BFu0i_BFu7ll_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_Ui  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu7ll_Ui) C1{ Fi:0 FL:7 Fi}



static void Test_BFu0i_BFu7ll_Ui()
{
  {
    init_simple_test("BFu0i_BFu7ll_Ui");
    static BFu0i_BFu7ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu7ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_Ui(Test_BFu0i_BFu7ll_Ui, "BFu0i_BFu7ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_Ul  {
  unsigned int  :0;
  __tsu64 v1:7;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu7ll_Ul) C1{ Fi:0 FL:7 FL}



static void Test_BFu0i_BFu7ll_Ul()
{
  {
    init_simple_test("BFu0i_BFu7ll_Ul");
    static BFu0i_BFu7ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu7ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_Ul(Test_BFu0i_BFu7ll_Ul, "BFu0i_BFu7ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_Us  {
  unsigned int  :0;
  __tsu64 v1:7;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu7ll_Us) C1{ Fi:0 FL:7 Fs}



static void Test_BFu0i_BFu7ll_Us()
{
  {
    init_simple_test("BFu0i_BFu7ll_Us");
    static BFu0i_BFu7ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu7ll_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_Us(Test_BFu0i_BFu7ll_Us, "BFu0i_BFu7ll_Us", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7ll_Vp  {
  unsigned int  :0;
  __tsu64 v1:7;
  void *v2;
};
//SIG(1 BFu0i_BFu7ll_Vp) C1{ Fi:0 FL:7 Fp}



static void Test_BFu0i_BFu7ll_Vp()
{
  {
    init_simple_test("BFu0i_BFu7ll_Vp");
    static BFu0i_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu7ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7ll_Vp(Test_BFu0i_BFu7ll_Vp, "BFu0i_BFu7ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s  {
  unsigned int  :0;
  unsigned short v1:7;
};
//SIG(1 BFu0i_BFu7s) C1{ Fi:0 Fs:7}



static void Test_BFu0i_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu7s");
    static BFu0i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s(Test_BFu0i_BFu7s, "BFu0i_BFu7s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu0c  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu7s_BFu0c) C1{ Fi:0 Fs:7 Fc:0}



static void Test_BFu0i_BFu7s_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu0c");
    static BFu0i_BFu7s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu0c(Test_BFu0i_BFu7s_BFu0c, "BFu0i_BFu7s_BFu0c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu0i  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu7s_BFu0i) C1{ Fi:0 Fs:7 Fi:0}



static void Test_BFu0i_BFu7s_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu0i");
    static BFu0i_BFu7s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu0i(Test_BFu0i_BFu7s_BFu0i, "BFu0i_BFu7s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu0ll  {
  unsigned int  :0;
  unsigned short v1:7;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu7s_BFu0ll) C1{ Fi:0 Fs:7 FL:0}



static void Test_BFu0i_BFu7s_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu0ll");
    static BFu0i_BFu7s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu0ll(Test_BFu0i_BFu7s_BFu0ll, "BFu0i_BFu7s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu0s  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu7s_BFu0s) C1{ Fi:0 Fs:7 Fs:0}



static void Test_BFu0i_BFu7s_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu0s");
    static BFu0i_BFu7s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu0s(Test_BFu0i_BFu7s_BFu0s, "BFu0i_BFu7s_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu15i  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu7s_BFu15i) C1{ Fi:0 Fs:7 Fi:15}



static void Test_BFu0i_BFu7s_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu15i");
    static BFu0i_BFu7s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0i_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0i_BFu7s_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu15i(Test_BFu0i_BFu7s_BFu15i, "BFu0i_BFu7s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu15ll  {
  unsigned int  :0;
  unsigned short v1:7;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu7s_BFu15ll) C1{ Fi:0 Fs:7 FL:15}



static void Test_BFu0i_BFu7s_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu15ll");
    static BFu0i_BFu7s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, 1, "BFu0i_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 0, 7, 15, hide_ull(1LL<<14), "BFu0i_BFu7s_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu15ll(Test_BFu0i_BFu7s_BFu15ll, "BFu0i_BFu7s_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu15s  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu7s_BFu15s) C1{ Fi:0 Fs:7 Fs:15}



static void Test_BFu0i_BFu7s_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu15s");
    static BFu0i_BFu7s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu7s_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu15s(Test_BFu0i_BFu7s_BFu15s, "BFu0i_BFu7s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu16i  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu7s_BFu16i) C1{ Fi:0 Fs:7 Fi:16}



static void Test_BFu0i_BFu7s_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu16i");
    static BFu0i_BFu7s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0i_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0i_BFu7s_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu16i(Test_BFu0i_BFu7s_BFu16i, "BFu0i_BFu7s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu16ll  {
  unsigned int  :0;
  unsigned short v1:7;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu7s_BFu16ll) C1{ Fi:0 Fs:7 FL:16}



static void Test_BFu0i_BFu7s_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu16ll");
    static BFu0i_BFu7s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, 1, "BFu0i_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 0, 7, 16, hide_ull(1LL<<15), "BFu0i_BFu7s_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu16ll(Test_BFu0i_BFu7s_BFu16ll, "BFu0i_BFu7s_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu16s  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu7s_BFu16s) C1{ Fi:0 Fs:7 Fs:16}



static void Test_BFu0i_BFu7s_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu16s");
    static BFu0i_BFu7s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu7s_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu16s(Test_BFu0i_BFu7s_BFu16s, "BFu0i_BFu7s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu17i  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu7s_BFu17i) C1{ Fi:0 Fs:7 Fi:17}



static void Test_BFu0i_BFu7s_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu17i");
    static BFu0i_BFu7s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0i_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0i_BFu7s_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu17i(Test_BFu0i_BFu7s_BFu17i, "BFu0i_BFu7s_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu17ll  {
  unsigned int  :0;
  unsigned short v1:7;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu7s_BFu17ll) C1{ Fi:0 Fs:7 FL:17}



static void Test_BFu0i_BFu7s_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu17ll");
    static BFu0i_BFu7s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, 1, "BFu0i_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 0, 7, 17, hide_ull(1LL<<16), "BFu0i_BFu7s_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu17ll(Test_BFu0i_BFu7s_BFu17ll, "BFu0i_BFu7s_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu1c  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu7s_BFu1c) C1{ Fi:0 Fs:7 Fc:1}



static void Test_BFu0i_BFu7s_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu1c");
    static BFu0i_BFu7s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7s_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu1c(Test_BFu0i_BFu7s_BFu1c, "BFu0i_BFu7s_BFu1c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu1i  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu7s_BFu1i) C1{ Fi:0 Fs:7 Fi:1}



static void Test_BFu0i_BFu7s_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu1i");
    static BFu0i_BFu7s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7s_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu1i(Test_BFu0i_BFu7s_BFu1i, "BFu0i_BFu7s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu1ll  {
  unsigned int  :0;
  unsigned short v1:7;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu7s_BFu1ll) C1{ Fi:0 Fs:7 FL:1}



static void Test_BFu0i_BFu7s_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu1ll");
    static BFu0i_BFu7s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7s_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu1ll(Test_BFu0i_BFu7s_BFu1ll, "BFu0i_BFu7s_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu1s  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu7s_BFu1s) C1{ Fi:0 Fs:7 Fs:1}



static void Test_BFu0i_BFu7s_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu1s");
    static BFu0i_BFu7s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 0, 7, 1, 1, "BFu0i_BFu7s_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu1s(Test_BFu0i_BFu7s_BFu1s, "BFu0i_BFu7s_BFu1s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu31i  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu7s_BFu31i) C1{ Fi:0 Fs:7 Fi:31}



static void Test_BFu0i_BFu7s_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu31i");
    static BFu0i_BFu7s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu7s_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu31i(Test_BFu0i_BFu7s_BFu31i, "BFu0i_BFu7s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu31ll  {
  unsigned int  :0;
  unsigned short v1:7;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu7s_BFu31ll) C1{ Fi:0 Fs:7 FL:31}



static void Test_BFu0i_BFu7s_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu31ll");
    static BFu0i_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, 1, "BFu0i_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 0, 7, 31, hide_ull(1LL<<30), "BFu0i_BFu7s_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu31ll(Test_BFu0i_BFu7s_BFu31ll, "BFu0i_BFu7s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu32i  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu7s_BFu32i) C1{ Fi:0 Fs:7 Fi:32}



static void Test_BFu0i_BFu7s_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu32i");
    static BFu0i_BFu7s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu7s_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu32i(Test_BFu0i_BFu7s_BFu32i, "BFu0i_BFu7s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu32ll  {
  unsigned int  :0;
  unsigned short v1:7;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu7s_BFu32ll) C1{ Fi:0 Fs:7 FL:32}



static void Test_BFu0i_BFu7s_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu32ll");
    static BFu0i_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, 1, "BFu0i_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 0, 7, 32, hide_ull(1LL<<31), "BFu0i_BFu7s_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu32ll(Test_BFu0i_BFu7s_BFu32ll, "BFu0i_BFu7s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu33  {
  unsigned int  :0;
  unsigned short v1:7;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu7s_BFu33) C1{ Fi:0 Fs:7 FL:33}



static void Test_BFu0i_BFu7s_BFu33()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu33");
    static BFu0i_BFu7s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, 1, "BFu0i_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 0, 7, 33, hide_ull(1LL<<32), "BFu0i_BFu7s_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu33(Test_BFu0i_BFu7s_BFu33, "BFu0i_BFu7s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu7c  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu7s_BFu7c) C1{ Fi:0 Fs:7 Fc:7}



static void Test_BFu0i_BFu7s_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu7c");
    static BFu0i_BFu7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu7c(Test_BFu0i_BFu7s_BFu7c, "BFu0i_BFu7s_BFu7c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu7i  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu7s_BFu7i) C1{ Fi:0 Fs:7 Fi:7}



static void Test_BFu0i_BFu7s_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu7i");
    static BFu0i_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0i_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu7i(Test_BFu0i_BFu7s_BFu7i, "BFu0i_BFu7s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu7ll  {
  unsigned int  :0;
  unsigned short v1:7;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu7s_BFu7ll) C1{ Fi:0 Fs:7 FL:7}



static void Test_BFu0i_BFu7s_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu7ll");
    static BFu0i_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0i_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu7ll(Test_BFu0i_BFu7s_BFu7ll, "BFu0i_BFu7s_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu7s  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu7s_BFu7s) C1{ Fi:0 Fs:7 Fs:7}



static void Test_BFu0i_BFu7s_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu7s");
    static BFu0i_BFu7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, 1, "BFu0i_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 0, 7, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu7s(Test_BFu0i_BFu7s_BFu7s, "BFu0i_BFu7s_BFu7s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu8c  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu7s_BFu8c) C1{ Fi:0 Fs:7 Fc:8}



static void Test_BFu0i_BFu7s_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu8c");
    static BFu0i_BFu7s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu7s_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu8c(Test_BFu0i_BFu7s_BFu8c, "BFu0i_BFu7s_BFu8c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu8i  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu7s_BFu8i) C1{ Fi:0 Fs:7 Fi:8}



static void Test_BFu0i_BFu7s_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu8i");
    static BFu0i_BFu7s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0i_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0i_BFu7s_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu8i(Test_BFu0i_BFu7s_BFu8i, "BFu0i_BFu7s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu8ll  {
  unsigned int  :0;
  unsigned short v1:7;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu7s_BFu8ll) C1{ Fi:0 Fs:7 FL:8}



static void Test_BFu0i_BFu7s_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu8ll");
    static BFu0i_BFu7s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0i_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0i_BFu7s_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu8ll(Test_BFu0i_BFu7s_BFu8ll, "BFu0i_BFu7s_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu8s  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu7s_BFu8s) C1{ Fi:0 Fs:7 Fs:8}



static void Test_BFu0i_BFu7s_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu8s");
    static BFu0i_BFu7s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, 1, "BFu0i_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 0, 7, 8, hide_ull(1LL<<7), "BFu0i_BFu7s_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu8s(Test_BFu0i_BFu7s_BFu8s, "BFu0i_BFu7s_BFu8s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu9i  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu7s_BFu9i) C1{ Fi:0 Fs:7 Fi:9}



static void Test_BFu0i_BFu7s_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu9i");
    static BFu0i_BFu7s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0i_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0i_BFu7s_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu9i(Test_BFu0i_BFu7s_BFu9i, "BFu0i_BFu7s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu9ll  {
  unsigned int  :0;
  unsigned short v1:7;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu7s_BFu9ll) C1{ Fi:0 Fs:7 FL:9}



static void Test_BFu0i_BFu7s_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu9ll");
    static BFu0i_BFu7s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu7s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0i_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0i_BFu7s_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu9ll(Test_BFu0i_BFu7s_BFu9ll, "BFu0i_BFu7s_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_BFu9s  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu7s_BFu9s) C1{ Fi:0 Fs:7 Fs:9}



static void Test_BFu0i_BFu7s_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu7s_BFu9s");
    static BFu0i_BFu7s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, 1, "BFu0i_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 0, 7, 9, hide_ull(1LL<<8), "BFu0i_BFu7s_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_BFu9s(Test_BFu0i_BFu7s_BFu9s, "BFu0i_BFu7s_BFu9s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_C  {
  unsigned int  :0;
  unsigned short v1:7;
  char v2;
};
//SIG(1 BFu0i_BFu7s_C) C1{ Fi:0 Fs:7 Fc}



static void Test_BFu0i_BFu7s_C()
{
  {
    init_simple_test("BFu0i_BFu7s_C");
    static BFu0i_BFu7s_C lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7s_C)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_C)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_C");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_C");
    check_field_offset(lv, v2, 1, "BFu0i_BFu7s_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_C(Test_BFu0i_BFu7s_C, "BFu0i_BFu7s_C", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_D  {
  unsigned int  :0;
  unsigned short v1:7;
  double v2;
};
//SIG(1 BFu0i_BFu7s_D) C1{ Fi:0 Fs:7 FL}



static void Test_BFu0i_BFu7s_D()
{
  {
    init_simple_test("BFu0i_BFu7s_D");
    static BFu0i_BFu7s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu7s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_D)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_D");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7s_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_D(Test_BFu0i_BFu7s_D, "BFu0i_BFu7s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_F  {
  unsigned int  :0;
  unsigned short v1:7;
  float v2;
};
//SIG(1 BFu0i_BFu7s_F) C1{ Fi:0 Fs:7 Fi}



static void Test_BFu0i_BFu7s_F()
{
  {
    init_simple_test("BFu0i_BFu7s_F");
    static BFu0i_BFu7s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7s_F)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_F");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu7s_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_F(Test_BFu0i_BFu7s_F, "BFu0i_BFu7s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_I  {
  unsigned int  :0;
  unsigned short v1:7;
  int v2;
};
//SIG(1 BFu0i_BFu7s_I) C1{ Fi:0 Fs:7 Fi}



static void Test_BFu0i_BFu7s_I()
{
  {
    init_simple_test("BFu0i_BFu7s_I");
    static BFu0i_BFu7s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7s_I)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_I");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu7s_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_I(Test_BFu0i_BFu7s_I, "BFu0i_BFu7s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_Ip  {
  unsigned int  :0;
  unsigned short v1:7;
  int *v2;
};
//SIG(1 BFu0i_BFu7s_Ip) C1{ Fi:0 Fs:7 Fp}



static void Test_BFu0i_BFu7s_Ip()
{
  {
    init_simple_test("BFu0i_BFu7s_Ip");
    static BFu0i_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu7s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7s_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_Ip(Test_BFu0i_BFu7s_Ip, "BFu0i_BFu7s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_L  {
  unsigned int  :0;
  unsigned short v1:7;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu7s_L) C1{ Fi:0 Fs:7 FL}



static void Test_BFu0i_BFu7s_L()
{
  {
    init_simple_test("BFu0i_BFu7s_L");
    static BFu0i_BFu7s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu7s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_L)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_L");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7s_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_L(Test_BFu0i_BFu7s_L, "BFu0i_BFu7s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_S  {
  unsigned int  :0;
  unsigned short v1:7;
  short v2;
};
//SIG(1 BFu0i_BFu7s_S) C1{ Fi:0 Fs:7 Fs}



static void Test_BFu0i_BFu7s_S()
{
  {
    init_simple_test("BFu0i_BFu7s_S");
    static BFu0i_BFu7s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7s_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_S)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_S");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu7s_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_S(Test_BFu0i_BFu7s_S, "BFu0i_BFu7s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_Uc  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu7s_Uc) C1{ Fi:0 Fs:7 Fc}



static void Test_BFu0i_BFu7s_Uc()
{
  {
    init_simple_test("BFu0i_BFu7s_Uc");
    static BFu0i_BFu7s_Uc lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu7s_Uc)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_Uc");
    check_field_offset(lv, v2, 1, "BFu0i_BFu7s_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_Uc(Test_BFu0i_BFu7s_Uc, "BFu0i_BFu7s_Uc", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_Ui  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu7s_Ui) C1{ Fi:0 Fs:7 Fi}



static void Test_BFu0i_BFu7s_Ui()
{
  {
    init_simple_test("BFu0i_BFu7s_Ui");
    static BFu0i_BFu7s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu7s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu7s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu7s_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_Ui(Test_BFu0i_BFu7s_Ui, "BFu0i_BFu7s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_Ul  {
  unsigned int  :0;
  unsigned short v1:7;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu7s_Ul) C1{ Fi:0 Fs:7 FL}



static void Test_BFu0i_BFu7s_Ul()
{
  {
    init_simple_test("BFu0i_BFu7s_Ul");
    static BFu0i_BFu7s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu7s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7s_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_Ul(Test_BFu0i_BFu7s_Ul, "BFu0i_BFu7s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_Us  {
  unsigned int  :0;
  unsigned short v1:7;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu7s_Us) C1{ Fi:0 Fs:7 Fs}



static void Test_BFu0i_BFu7s_Us()
{
  {
    init_simple_test("BFu0i_BFu7s_Us");
    static BFu0i_BFu7s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu7s_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu7s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_Us");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu7s_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_Us(Test_BFu0i_BFu7s_Us, "BFu0i_BFu7s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu7s_Vp  {
  unsigned int  :0;
  unsigned short v1:7;
  void *v2;
};
//SIG(1 BFu0i_BFu7s_Vp) C1{ Fi:0 Fs:7 Fp}



static void Test_BFu0i_BFu7s_Vp()
{
  {
    init_simple_test("BFu0i_BFu7s_Vp");
    static BFu0i_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu7s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu7s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 7, 1, "BFu0i_BFu7s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu7s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu7s_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu7s_Vp(Test_BFu0i_BFu7s_Vp, "BFu0i_BFu7s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c  {
  unsigned int  :0;
  unsigned char v1:8;
};
//SIG(1 BFu0i_BFu8c) C1{ Fi:0 Fc:8}



static void Test_BFu0i_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu8c");
    static BFu0i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c(Test_BFu0i_BFu8c, "BFu0i_BFu8c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu0c  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu8c_BFu0c) C1{ Fi:0 Fc:8 Fc:0}



static void Test_BFu0i_BFu8c_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu0c");
    static BFu0i_BFu8c_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_BFu8c_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu8c_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu0c(Test_BFu0i_BFu8c_BFu0c, "BFu0i_BFu8c_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu0i  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu8c_BFu0i) C1{ Fi:0 Fc:8 Fi:0}



static void Test_BFu0i_BFu8c_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu0i");
    static BFu0i_BFu8c_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8c_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu8c_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu0i(Test_BFu0i_BFu8c_BFu0i, "BFu0i_BFu8c_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu0ll  {
  unsigned int  :0;
  unsigned char v1:8;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu8c_BFu0ll) C1{ Fi:0 Fc:8 FL:0}



static void Test_BFu0i_BFu8c_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu0ll");
    static BFu0i_BFu8c_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8c_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu8c_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu0ll(Test_BFu0i_BFu8c_BFu0ll, "BFu0i_BFu8c_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu0s  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu8c_BFu0s) C1{ Fi:0 Fc:8 Fs:0}



static void Test_BFu0i_BFu8c_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu0s");
    static BFu0i_BFu8c_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8c_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu8c_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu0s(Test_BFu0i_BFu8c_BFu0s, "BFu0i_BFu8c_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu15i  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu8c_BFu15i) C1{ Fi:0 Fc:8 Fi:15}



static void Test_BFu0i_BFu8c_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu15i");
    static BFu0i_BFu8c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0i_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu8c_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu15i(Test_BFu0i_BFu8c_BFu15i, "BFu0i_BFu8c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu15ll  {
  unsigned int  :0;
  unsigned char v1:8;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu8c_BFu15ll) C1{ Fi:0 Fc:8 FL:15}



static void Test_BFu0i_BFu8c_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu15ll");
    static BFu0i_BFu8c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0i_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu8c_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu15ll(Test_BFu0i_BFu8c_BFu15ll, "BFu0i_BFu8c_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu15s  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu8c_BFu15s) C1{ Fi:0 Fc:8 Fs:15}



static void Test_BFu0i_BFu8c_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu15s");
    static BFu0i_BFu8c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8c_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu8c_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu15s(Test_BFu0i_BFu8c_BFu15s, "BFu0i_BFu8c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu16i  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu8c_BFu16i) C1{ Fi:0 Fc:8 Fi:16}



static void Test_BFu0i_BFu8c_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu16i");
    static BFu0i_BFu8c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0i_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu8c_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu16i(Test_BFu0i_BFu8c_BFu16i, "BFu0i_BFu8c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu16ll  {
  unsigned int  :0;
  unsigned char v1:8;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu8c_BFu16ll) C1{ Fi:0 Fc:8 FL:16}



static void Test_BFu0i_BFu8c_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu16ll");
    static BFu0i_BFu8c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0i_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu8c_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu16ll(Test_BFu0i_BFu8c_BFu16ll, "BFu0i_BFu8c_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu16s  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu8c_BFu16s) C1{ Fi:0 Fc:8 Fs:16}



static void Test_BFu0i_BFu8c_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu16s");
    static BFu0i_BFu8c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8c_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu8c_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu16s(Test_BFu0i_BFu8c_BFu16s, "BFu0i_BFu8c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu17i  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu8c_BFu17i) C1{ Fi:0 Fc:8 Fi:17}



static void Test_BFu0i_BFu8c_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu17i");
    static BFu0i_BFu8c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0i_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu8c_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu17i(Test_BFu0i_BFu8c_BFu17i, "BFu0i_BFu8c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu17ll  {
  unsigned int  :0;
  unsigned char v1:8;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu8c_BFu17ll) C1{ Fi:0 Fc:8 FL:17}



static void Test_BFu0i_BFu8c_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu17ll");
    static BFu0i_BFu8c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0i_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu8c_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu17ll(Test_BFu0i_BFu8c_BFu17ll, "BFu0i_BFu8c_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu1c  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu8c_BFu1c) C1{ Fi:0 Fc:8 Fc:1}



static void Test_BFu0i_BFu8c_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu1c");
    static BFu0i_BFu8c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8c_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu8c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8c_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu1c(Test_BFu0i_BFu8c_BFu1c, "BFu0i_BFu8c_BFu1c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu1i  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu8c_BFu1i) C1{ Fi:0 Fc:8 Fi:1}



static void Test_BFu0i_BFu8c_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu1i");
    static BFu0i_BFu8c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8c_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu1i(Test_BFu0i_BFu8c_BFu1i, "BFu0i_BFu8c_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu1ll  {
  unsigned int  :0;
  unsigned char v1:8;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu8c_BFu1ll) C1{ Fi:0 Fc:8 FL:1}



static void Test_BFu0i_BFu8c_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu1ll");
    static BFu0i_BFu8c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8c_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu1ll(Test_BFu0i_BFu8c_BFu1ll, "BFu0i_BFu8c_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu1s  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu8c_BFu1s) C1{ Fi:0 Fc:8 Fs:1}



static void Test_BFu0i_BFu8c_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu1s");
    static BFu0i_BFu8c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8c_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8c_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu1s(Test_BFu0i_BFu8c_BFu1s, "BFu0i_BFu8c_BFu1s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu31i  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu8c_BFu31i) C1{ Fi:0 Fc:8 Fi:31}



static void Test_BFu0i_BFu8c_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu31i");
    static BFu0i_BFu8c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu8c_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu31i(Test_BFu0i_BFu8c_BFu31i, "BFu0i_BFu8c_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu31ll  {
  unsigned int  :0;
  unsigned char v1:8;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu8c_BFu31ll) C1{ Fi:0 Fc:8 FL:31}



static void Test_BFu0i_BFu8c_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu31ll");
    static BFu0i_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0i_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu8c_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu31ll(Test_BFu0i_BFu8c_BFu31ll, "BFu0i_BFu8c_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu32i  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu8c_BFu32i) C1{ Fi:0 Fc:8 Fi:32}



static void Test_BFu0i_BFu8c_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu32i");
    static BFu0i_BFu8c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu8c_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu32i(Test_BFu0i_BFu8c_BFu32i, "BFu0i_BFu8c_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu32ll  {
  unsigned int  :0;
  unsigned char v1:8;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu8c_BFu32ll) C1{ Fi:0 Fc:8 FL:32}



static void Test_BFu0i_BFu8c_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu32ll");
    static BFu0i_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0i_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu8c_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu32ll(Test_BFu0i_BFu8c_BFu32ll, "BFu0i_BFu8c_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu33  {
  unsigned int  :0;
  unsigned char v1:8;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu8c_BFu33) C1{ Fi:0 Fc:8 FL:33}



static void Test_BFu0i_BFu8c_BFu33()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu33");
    static BFu0i_BFu8c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0i_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu8c_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu33(Test_BFu0i_BFu8c_BFu33, "BFu0i_BFu8c_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu7c  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu8c_BFu7c) C1{ Fi:0 Fc:8 Fc:7}



static void Test_BFu0i_BFu8c_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu7c");
    static BFu0i_BFu8c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8c_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu8c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8c_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu7c(Test_BFu0i_BFu8c_BFu7c, "BFu0i_BFu8c_BFu7c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu7i  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu8c_BFu7i) C1{ Fi:0 Fc:8 Fi:7}



static void Test_BFu0i_BFu8c_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu7i");
    static BFu0i_BFu8c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8c_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu7i(Test_BFu0i_BFu8c_BFu7i, "BFu0i_BFu8c_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu7ll  {
  unsigned int  :0;
  unsigned char v1:8;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu8c_BFu7ll) C1{ Fi:0 Fc:8 FL:7}



static void Test_BFu0i_BFu8c_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu7ll");
    static BFu0i_BFu8c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8c_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu7ll(Test_BFu0i_BFu8c_BFu7ll, "BFu0i_BFu8c_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu7s  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu8c_BFu7s) C1{ Fi:0 Fc:8 Fs:7}



static void Test_BFu0i_BFu8c_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu7s");
    static BFu0i_BFu8c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8c_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8c_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu7s(Test_BFu0i_BFu8c_BFu7s, "BFu0i_BFu8c_BFu7s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu8c  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu8c_BFu8c) C1{ Fi:0 Fc:8 Fc:8}



static void Test_BFu0i_BFu8c_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu8c");
    static BFu0i_BFu8c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8c_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu8c(Test_BFu0i_BFu8c_BFu8c, "BFu0i_BFu8c_BFu8c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu8i  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu8c_BFu8i) C1{ Fi:0 Fc:8 Fi:8}



static void Test_BFu0i_BFu8c_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu8i");
    static BFu0i_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu8i(Test_BFu0i_BFu8c_BFu8i, "BFu0i_BFu8c_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu8ll  {
  unsigned int  :0;
  unsigned char v1:8;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu8c_BFu8ll) C1{ Fi:0 Fc:8 FL:8}



static void Test_BFu0i_BFu8c_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu8ll");
    static BFu0i_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu8ll(Test_BFu0i_BFu8c_BFu8ll, "BFu0i_BFu8c_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu8s  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu8c_BFu8s) C1{ Fi:0 Fc:8 Fs:8}



static void Test_BFu0i_BFu8c_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu8s");
    static BFu0i_BFu8c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8c_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu8s(Test_BFu0i_BFu8c_BFu8s, "BFu0i_BFu8c_BFu8s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu9i  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu8c_BFu9i) C1{ Fi:0 Fc:8 Fi:9}



static void Test_BFu0i_BFu8c_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu9i");
    static BFu0i_BFu8c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0i_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu8c_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu9i(Test_BFu0i_BFu8c_BFu9i, "BFu0i_BFu8c_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu9ll  {
  unsigned int  :0;
  unsigned char v1:8;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu8c_BFu9ll) C1{ Fi:0 Fc:8 FL:9}



static void Test_BFu0i_BFu8c_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu9ll");
    static BFu0i_BFu8c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0i_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu8c_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu9ll(Test_BFu0i_BFu8c_BFu9ll, "BFu0i_BFu8c_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_BFu9s  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu8c_BFu9s) C1{ Fi:0 Fc:8 Fs:9}



static void Test_BFu0i_BFu8c_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu8c_BFu9s");
    static BFu0i_BFu8c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8c_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0i_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu8c_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_BFu9s(Test_BFu0i_BFu8c_BFu9s, "BFu0i_BFu8c_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_C  {
  unsigned int  :0;
  unsigned char v1:8;
  char v2;
};
//SIG(1 BFu0i_BFu8c_C) C1{ Fi:0 Fc:8 Fc}



static void Test_BFu0i_BFu8c_C()
{
  {
    init_simple_test("BFu0i_BFu8c_C");
    static BFu0i_BFu8c_C lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8c_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu8c_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_C");
    check_field_offset(lv, v2, 1, "BFu0i_BFu8c_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_C(Test_BFu0i_BFu8c_C, "BFu0i_BFu8c_C", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_D  {
  unsigned int  :0;
  unsigned char v1:8;
  double v2;
};
//SIG(1 BFu0i_BFu8c_D) C1{ Fi:0 Fc:8 FL}



static void Test_BFu0i_BFu8c_D()
{
  {
    init_simple_test("BFu0i_BFu8c_D");
    static BFu0i_BFu8c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu8c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8c_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_D(Test_BFu0i_BFu8c_D, "BFu0i_BFu8c_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_F  {
  unsigned int  :0;
  unsigned char v1:8;
  float v2;
};
//SIG(1 BFu0i_BFu8c_F) C1{ Fi:0 Fc:8 Fi}



static void Test_BFu0i_BFu8c_F()
{
  {
    init_simple_test("BFu0i_BFu8c_F");
    static BFu0i_BFu8c_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8c_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8c_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu8c_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_F(Test_BFu0i_BFu8c_F, "BFu0i_BFu8c_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_I  {
  unsigned int  :0;
  unsigned char v1:8;
  int v2;
};
//SIG(1 BFu0i_BFu8c_I) C1{ Fi:0 Fc:8 Fi}



static void Test_BFu0i_BFu8c_I()
{
  {
    init_simple_test("BFu0i_BFu8c_I");
    static BFu0i_BFu8c_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8c_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8c_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu8c_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_I(Test_BFu0i_BFu8c_I, "BFu0i_BFu8c_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_Ip  {
  unsigned int  :0;
  unsigned char v1:8;
  int *v2;
};
//SIG(1 BFu0i_BFu8c_Ip) C1{ Fi:0 Fc:8 Fp}



static void Test_BFu0i_BFu8c_Ip()
{
  {
    init_simple_test("BFu0i_BFu8c_Ip");
    static BFu0i_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu8c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8c_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_Ip(Test_BFu0i_BFu8c_Ip, "BFu0i_BFu8c_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_L  {
  unsigned int  :0;
  unsigned char v1:8;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu8c_L) C1{ Fi:0 Fc:8 FL}



static void Test_BFu0i_BFu8c_L()
{
  {
    init_simple_test("BFu0i_BFu8c_L");
    static BFu0i_BFu8c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu8c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8c_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_L(Test_BFu0i_BFu8c_L, "BFu0i_BFu8c_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_S  {
  unsigned int  :0;
  unsigned char v1:8;
  short v2;
};
//SIG(1 BFu0i_BFu8c_S) C1{ Fi:0 Fc:8 Fs}



static void Test_BFu0i_BFu8c_S()
{
  {
    init_simple_test("BFu0i_BFu8c_S");
    static BFu0i_BFu8c_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8c_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8c_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu8c_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_S(Test_BFu0i_BFu8c_S, "BFu0i_BFu8c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_Uc  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu8c_Uc) C1{ Fi:0 Fc:8 Fc}



static void Test_BFu0i_BFu8c_Uc()
{
  {
    init_simple_test("BFu0i_BFu8c_Uc");
    static BFu0i_BFu8c_Uc lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8c_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_BFu8c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_Uc");
    check_field_offset(lv, v2, 1, "BFu0i_BFu8c_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_Uc(Test_BFu0i_BFu8c_Uc, "BFu0i_BFu8c_Uc", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_Ui  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu8c_Ui) C1{ Fi:0 Fc:8 Fi}



static void Test_BFu0i_BFu8c_Ui()
{
  {
    init_simple_test("BFu0i_BFu8c_Ui");
    static BFu0i_BFu8c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu8c_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_Ui(Test_BFu0i_BFu8c_Ui, "BFu0i_BFu8c_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_Ul  {
  unsigned int  :0;
  unsigned char v1:8;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu8c_Ul) C1{ Fi:0 Fc:8 FL}



static void Test_BFu0i_BFu8c_Ul()
{
  {
    init_simple_test("BFu0i_BFu8c_Ul");
    static BFu0i_BFu8c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu8c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8c_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_Ul(Test_BFu0i_BFu8c_Ul, "BFu0i_BFu8c_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_Us  {
  unsigned int  :0;
  unsigned char v1:8;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu8c_Us) C1{ Fi:0 Fc:8 Fs}



static void Test_BFu0i_BFu8c_Us()
{
  {
    init_simple_test("BFu0i_BFu8c_Us");
    static BFu0i_BFu8c_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8c_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu8c_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_Us(Test_BFu0i_BFu8c_Us, "BFu0i_BFu8c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8c_Vp  {
  unsigned int  :0;
  unsigned char v1:8;
  void *v2;
};
//SIG(1 BFu0i_BFu8c_Vp) C1{ Fi:0 Fc:8 Fp}



static void Test_BFu0i_BFu8c_Vp()
{
  {
    init_simple_test("BFu0i_BFu8c_Vp");
    static BFu0i_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu8c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8c_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8c_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8c_Vp(Test_BFu0i_BFu8c_Vp, "BFu0i_BFu8c_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i  {
  unsigned int  :0;
  unsigned int v1:8;
};
//SIG(1 BFu0i_BFu8i) C1{ Fi:0 Fi:8}



static void Test_BFu0i_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu8i");
    static BFu0i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i(Test_BFu0i_BFu8i, "BFu0i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu0c  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu8i_BFu0c) C1{ Fi:0 Fi:8 Fc:0}



static void Test_BFu0i_BFu8i_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu0c");
    static BFu0i_BFu8i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu0c(Test_BFu0i_BFu8i_BFu0c, "BFu0i_BFu8i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu0i  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu8i_BFu0i) C1{ Fi:0 Fi:8 Fi:0}



static void Test_BFu0i_BFu8i_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu0i");
    static BFu0i_BFu8i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu0i(Test_BFu0i_BFu8i_BFu0i, "BFu0i_BFu8i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu0ll  {
  unsigned int  :0;
  unsigned int v1:8;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu8i_BFu0ll) C1{ Fi:0 Fi:8 FL:0}



static void Test_BFu0i_BFu8i_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu0ll");
    static BFu0i_BFu8i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0i_BFu8i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu0ll(Test_BFu0i_BFu8i_BFu0ll, "BFu0i_BFu8i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu0s  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu8i_BFu0s) C1{ Fi:0 Fi:8 Fs:0}



static void Test_BFu0i_BFu8i_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu0s");
    static BFu0i_BFu8i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu0s(Test_BFu0i_BFu8i_BFu0s, "BFu0i_BFu8i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu15i  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu8i_BFu15i) C1{ Fi:0 Fi:8 Fi:15}



static void Test_BFu0i_BFu8i_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu15i");
    static BFu0i_BFu8i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0i_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu8i_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu15i(Test_BFu0i_BFu8i_BFu15i, "BFu0i_BFu8i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu15ll  {
  unsigned int  :0;
  unsigned int v1:8;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu8i_BFu15ll) C1{ Fi:0 Fi:8 FL:15}



static void Test_BFu0i_BFu8i_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu15ll");
    static BFu0i_BFu8i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0i_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu8i_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu15ll(Test_BFu0i_BFu8i_BFu15ll, "BFu0i_BFu8i_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu15s  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu8i_BFu15s) C1{ Fi:0 Fi:8 Fs:15}



static void Test_BFu0i_BFu8i_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu15s");
    static BFu0i_BFu8i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu8i_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu15s(Test_BFu0i_BFu8i_BFu15s, "BFu0i_BFu8i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu16i  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu8i_BFu16i) C1{ Fi:0 Fi:8 Fi:16}



static void Test_BFu0i_BFu8i_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu16i");
    static BFu0i_BFu8i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0i_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu8i_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu16i(Test_BFu0i_BFu8i_BFu16i, "BFu0i_BFu8i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu16ll  {
  unsigned int  :0;
  unsigned int v1:8;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu8i_BFu16ll) C1{ Fi:0 Fi:8 FL:16}



static void Test_BFu0i_BFu8i_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu16ll");
    static BFu0i_BFu8i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0i_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu8i_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu16ll(Test_BFu0i_BFu8i_BFu16ll, "BFu0i_BFu8i_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu16s  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu8i_BFu16s) C1{ Fi:0 Fi:8 Fs:16}



static void Test_BFu0i_BFu8i_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu16s");
    static BFu0i_BFu8i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu8i_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu16s(Test_BFu0i_BFu8i_BFu16s, "BFu0i_BFu8i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu17i  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu8i_BFu17i) C1{ Fi:0 Fi:8 Fi:17}



static void Test_BFu0i_BFu8i_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu17i");
    static BFu0i_BFu8i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0i_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu8i_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu17i(Test_BFu0i_BFu8i_BFu17i, "BFu0i_BFu8i_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu17ll  {
  unsigned int  :0;
  unsigned int v1:8;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu8i_BFu17ll) C1{ Fi:0 Fi:8 FL:17}



static void Test_BFu0i_BFu8i_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu17ll");
    static BFu0i_BFu8i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0i_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu8i_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu17ll(Test_BFu0i_BFu8i_BFu17ll, "BFu0i_BFu8i_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu1c  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu8i_BFu1c) C1{ Fi:0 Fi:8 Fc:1}



static void Test_BFu0i_BFu8i_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu1c");
    static BFu0i_BFu8i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8i_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu1c(Test_BFu0i_BFu8i_BFu1c, "BFu0i_BFu8i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu1i  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu8i_BFu1i) C1{ Fi:0 Fi:8 Fi:1}



static void Test_BFu0i_BFu8i_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu1i");
    static BFu0i_BFu8i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8i_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu1i(Test_BFu0i_BFu8i_BFu1i, "BFu0i_BFu8i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu1ll  {
  unsigned int  :0;
  unsigned int v1:8;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu8i_BFu1ll) C1{ Fi:0 Fi:8 FL:1}



static void Test_BFu0i_BFu8i_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu1ll");
    static BFu0i_BFu8i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8i_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu1ll(Test_BFu0i_BFu8i_BFu1ll, "BFu0i_BFu8i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu1s  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu8i_BFu1s) C1{ Fi:0 Fi:8 Fs:1}



static void Test_BFu0i_BFu8i_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu1s");
    static BFu0i_BFu8i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8i_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu1s(Test_BFu0i_BFu8i_BFu1s, "BFu0i_BFu8i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu31i  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu8i_BFu31i) C1{ Fi:0 Fi:8 Fi:31}



static void Test_BFu0i_BFu8i_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu31i");
    static BFu0i_BFu8i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu8i_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu31i(Test_BFu0i_BFu8i_BFu31i, "BFu0i_BFu8i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu31ll  {
  unsigned int  :0;
  unsigned int v1:8;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu8i_BFu31ll) C1{ Fi:0 Fi:8 FL:31}



static void Test_BFu0i_BFu8i_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu31ll");
    static BFu0i_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0i_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu8i_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu31ll(Test_BFu0i_BFu8i_BFu31ll, "BFu0i_BFu8i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu32i  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu8i_BFu32i) C1{ Fi:0 Fi:8 Fi:32}



static void Test_BFu0i_BFu8i_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu32i");
    static BFu0i_BFu8i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu8i_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu32i(Test_BFu0i_BFu8i_BFu32i, "BFu0i_BFu8i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu32ll  {
  unsigned int  :0;
  unsigned int v1:8;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu8i_BFu32ll) C1{ Fi:0 Fi:8 FL:32}



static void Test_BFu0i_BFu8i_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu32ll");
    static BFu0i_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0i_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu8i_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu32ll(Test_BFu0i_BFu8i_BFu32ll, "BFu0i_BFu8i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu33  {
  unsigned int  :0;
  unsigned int v1:8;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu8i_BFu33) C1{ Fi:0 Fi:8 FL:33}



static void Test_BFu0i_BFu8i_BFu33()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu33");
    static BFu0i_BFu8i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0i_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu8i_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu33(Test_BFu0i_BFu8i_BFu33, "BFu0i_BFu8i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu7c  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu8i_BFu7c) C1{ Fi:0 Fi:8 Fc:7}



static void Test_BFu0i_BFu8i_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu7c");
    static BFu0i_BFu8i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8i_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu7c(Test_BFu0i_BFu8i_BFu7c, "BFu0i_BFu8i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu7i  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu8i_BFu7i) C1{ Fi:0 Fi:8 Fi:7}



static void Test_BFu0i_BFu8i_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu7i");
    static BFu0i_BFu8i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8i_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu7i(Test_BFu0i_BFu8i_BFu7i, "BFu0i_BFu8i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu7ll  {
  unsigned int  :0;
  unsigned int v1:8;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu8i_BFu7ll) C1{ Fi:0 Fi:8 FL:7}



static void Test_BFu0i_BFu8i_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu7ll");
    static BFu0i_BFu8i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8i_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu7ll(Test_BFu0i_BFu8i_BFu7ll, "BFu0i_BFu8i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu7s  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu8i_BFu7s) C1{ Fi:0 Fi:8 Fs:7}



static void Test_BFu0i_BFu8i_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu7s");
    static BFu0i_BFu8i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8i_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu7s(Test_BFu0i_BFu8i_BFu7s, "BFu0i_BFu8i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu8c  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu8i_BFu8c) C1{ Fi:0 Fi:8 Fc:8}



static void Test_BFu0i_BFu8i_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu8c");
    static BFu0i_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu8c(Test_BFu0i_BFu8i_BFu8c, "BFu0i_BFu8i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu8i  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu8i_BFu8i) C1{ Fi:0 Fi:8 Fi:8}



static void Test_BFu0i_BFu8i_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu8i");
    static BFu0i_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu8i(Test_BFu0i_BFu8i_BFu8i, "BFu0i_BFu8i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu8ll  {
  unsigned int  :0;
  unsigned int v1:8;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu8i_BFu8ll) C1{ Fi:0 Fi:8 FL:8}



static void Test_BFu0i_BFu8i_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu8ll");
    static BFu0i_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu8ll(Test_BFu0i_BFu8i_BFu8ll, "BFu0i_BFu8i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu8s  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu8i_BFu8s) C1{ Fi:0 Fi:8 Fs:8}



static void Test_BFu0i_BFu8i_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu8s");
    static BFu0i_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu8s(Test_BFu0i_BFu8i_BFu8s, "BFu0i_BFu8i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu9i  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu8i_BFu9i) C1{ Fi:0 Fi:8 Fi:9}



static void Test_BFu0i_BFu8i_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu9i");
    static BFu0i_BFu8i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0i_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu8i_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu9i(Test_BFu0i_BFu8i_BFu9i, "BFu0i_BFu8i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu9ll  {
  unsigned int  :0;
  unsigned int v1:8;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu8i_BFu9ll) C1{ Fi:0 Fi:8 FL:9}



static void Test_BFu0i_BFu8i_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu9ll");
    static BFu0i_BFu8i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0i_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu8i_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu9ll(Test_BFu0i_BFu8i_BFu9ll, "BFu0i_BFu8i_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_BFu9s  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu8i_BFu9s) C1{ Fi:0 Fi:8 Fs:9}



static void Test_BFu0i_BFu8i_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu8i_BFu9s");
    static BFu0i_BFu8i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0i_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu8i_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_BFu9s(Test_BFu0i_BFu8i_BFu9s, "BFu0i_BFu8i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_C  {
  unsigned int  :0;
  unsigned int v1:8;
  char v2;
};
//SIG(1 BFu0i_BFu8i_C) C1{ Fi:0 Fi:8 Fc}



static void Test_BFu0i_BFu8i_C()
{
  {
    init_simple_test("BFu0i_BFu8i_C");
    static BFu0i_BFu8i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_C");
    check_field_offset(lv, v2, 1, "BFu0i_BFu8i_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_C(Test_BFu0i_BFu8i_C, "BFu0i_BFu8i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_D  {
  unsigned int  :0;
  unsigned int v1:8;
  double v2;
};
//SIG(1 BFu0i_BFu8i_D) C1{ Fi:0 Fi:8 FL}



static void Test_BFu0i_BFu8i_D()
{
  {
    init_simple_test("BFu0i_BFu8i_D");
    static BFu0i_BFu8i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu8i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8i_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_D(Test_BFu0i_BFu8i_D, "BFu0i_BFu8i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_F  {
  unsigned int  :0;
  unsigned int v1:8;
  float v2;
};
//SIG(1 BFu0i_BFu8i_F) C1{ Fi:0 Fi:8 Fi}



static void Test_BFu0i_BFu8i_F()
{
  {
    init_simple_test("BFu0i_BFu8i_F");
    static BFu0i_BFu8i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu8i_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_F(Test_BFu0i_BFu8i_F, "BFu0i_BFu8i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_I  {
  unsigned int  :0;
  unsigned int v1:8;
  int v2;
};
//SIG(1 BFu0i_BFu8i_I) C1{ Fi:0 Fi:8 Fi}



static void Test_BFu0i_BFu8i_I()
{
  {
    init_simple_test("BFu0i_BFu8i_I");
    static BFu0i_BFu8i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu8i_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_I(Test_BFu0i_BFu8i_I, "BFu0i_BFu8i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_Ip  {
  unsigned int  :0;
  unsigned int v1:8;
  int *v2;
};
//SIG(1 BFu0i_BFu8i_Ip) C1{ Fi:0 Fi:8 Fp}



static void Test_BFu0i_BFu8i_Ip()
{
  {
    init_simple_test("BFu0i_BFu8i_Ip");
    static BFu0i_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu8i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8i_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_Ip(Test_BFu0i_BFu8i_Ip, "BFu0i_BFu8i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_L  {
  unsigned int  :0;
  unsigned int v1:8;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu8i_L) C1{ Fi:0 Fi:8 FL}



static void Test_BFu0i_BFu8i_L()
{
  {
    init_simple_test("BFu0i_BFu8i_L");
    static BFu0i_BFu8i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu8i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8i_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_L(Test_BFu0i_BFu8i_L, "BFu0i_BFu8i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_S  {
  unsigned int  :0;
  unsigned int v1:8;
  short v2;
};
//SIG(1 BFu0i_BFu8i_S) C1{ Fi:0 Fi:8 Fs}



static void Test_BFu0i_BFu8i_S()
{
  {
    init_simple_test("BFu0i_BFu8i_S");
    static BFu0i_BFu8i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu8i_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_S(Test_BFu0i_BFu8i_S, "BFu0i_BFu8i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_Uc  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu8i_Uc) C1{ Fi:0 Fi:8 Fc}



static void Test_BFu0i_BFu8i_Uc()
{
  {
    init_simple_test("BFu0i_BFu8i_Uc");
    static BFu0i_BFu8i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_Uc");
    check_field_offset(lv, v2, 1, "BFu0i_BFu8i_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_Uc(Test_BFu0i_BFu8i_Uc, "BFu0i_BFu8i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_Ui  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu8i_Ui) C1{ Fi:0 Fi:8 Fi}



static void Test_BFu0i_BFu8i_Ui()
{
  {
    init_simple_test("BFu0i_BFu8i_Ui");
    static BFu0i_BFu8i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu8i_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_Ui(Test_BFu0i_BFu8i_Ui, "BFu0i_BFu8i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_Ul  {
  unsigned int  :0;
  unsigned int v1:8;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu8i_Ul) C1{ Fi:0 Fi:8 FL}



static void Test_BFu0i_BFu8i_Ul()
{
  {
    init_simple_test("BFu0i_BFu8i_Ul");
    static BFu0i_BFu8i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu8i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8i_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_Ul(Test_BFu0i_BFu8i_Ul, "BFu0i_BFu8i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_Us  {
  unsigned int  :0;
  unsigned int v1:8;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu8i_Us) C1{ Fi:0 Fi:8 Fs}



static void Test_BFu0i_BFu8i_Us()
{
  {
    init_simple_test("BFu0i_BFu8i_Us");
    static BFu0i_BFu8i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu8i_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_Us(Test_BFu0i_BFu8i_Us, "BFu0i_BFu8i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8i_Vp  {
  unsigned int  :0;
  unsigned int v1:8;
  void *v2;
};
//SIG(1 BFu0i_BFu8i_Vp) C1{ Fi:0 Fi:8 Fp}



static void Test_BFu0i_BFu8i_Vp()
{
  {
    init_simple_test("BFu0i_BFu8i_Vp");
    static BFu0i_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu8i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8i_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8i_Vp(Test_BFu0i_BFu8i_Vp, "BFu0i_BFu8i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll  {
  unsigned int  :0;
  __tsu64 v1:8;
};
//SIG(1 BFu0i_BFu8ll) C1{ Fi:0 FL:8}



static void Test_BFu0i_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu8ll");
    static BFu0i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll(Test_BFu0i_BFu8ll, "BFu0i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu0c  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu8ll_BFu0c) C1{ Fi:0 FL:8 Fc:0}



static void Test_BFu0i_BFu8ll_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu0c");
    static BFu0i_BFu8ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu0c(Test_BFu0i_BFu8ll_BFu0c, "BFu0i_BFu8ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu0i  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu8ll_BFu0i) C1{ Fi:0 FL:8 Fi:0}



static void Test_BFu0i_BFu8ll_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu0i");
    static BFu0i_BFu8ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu0i(Test_BFu0i_BFu8ll_BFu0i, "BFu0i_BFu8ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu0ll  {
  unsigned int  :0;
  __tsu64 v1:8;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu8ll_BFu0ll) C1{ Fi:0 FL:8 FL:0}



static void Test_BFu0i_BFu8ll_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu0ll");
    static BFu0i_BFu8ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu0ll(Test_BFu0i_BFu8ll_BFu0ll, "BFu0i_BFu8ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu0s  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu8ll_BFu0s) C1{ Fi:0 FL:8 Fs:0}



static void Test_BFu0i_BFu8ll_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu0s");
    static BFu0i_BFu8ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu0s(Test_BFu0i_BFu8ll_BFu0s, "BFu0i_BFu8ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu15i  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu8ll_BFu15i) C1{ Fi:0 FL:8 Fi:15}



static void Test_BFu0i_BFu8ll_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu15i");
    static BFu0i_BFu8ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0i_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu8ll_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu15i(Test_BFu0i_BFu8ll_BFu15i, "BFu0i_BFu8ll_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu15ll  {
  unsigned int  :0;
  __tsu64 v1:8;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu8ll_BFu15ll) C1{ Fi:0 FL:8 FL:15}



static void Test_BFu0i_BFu8ll_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu15ll");
    static BFu0i_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0i_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu8ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu15ll(Test_BFu0i_BFu8ll_BFu15ll, "BFu0i_BFu8ll_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu15s  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu8ll_BFu15s) C1{ Fi:0 FL:8 Fs:15}



static void Test_BFu0i_BFu8ll_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu15s");
    static BFu0i_BFu8ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu8ll_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu15s(Test_BFu0i_BFu8ll_BFu15s, "BFu0i_BFu8ll_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu16i  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu8ll_BFu16i) C1{ Fi:0 FL:8 Fi:16}



static void Test_BFu0i_BFu8ll_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu16i");
    static BFu0i_BFu8ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0i_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu8ll_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu16i(Test_BFu0i_BFu8ll_BFu16i, "BFu0i_BFu8ll_BFu16i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu16ll  {
  unsigned int  :0;
  __tsu64 v1:8;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu8ll_BFu16ll) C1{ Fi:0 FL:8 FL:16}



static void Test_BFu0i_BFu8ll_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu16ll");
    static BFu0i_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0i_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu8ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu16ll(Test_BFu0i_BFu8ll_BFu16ll, "BFu0i_BFu8ll_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu16s  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu8ll_BFu16s) C1{ Fi:0 FL:8 Fs:16}



static void Test_BFu0i_BFu8ll_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu16s");
    static BFu0i_BFu8ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu8ll_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu16s(Test_BFu0i_BFu8ll_BFu16s, "BFu0i_BFu8ll_BFu16s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu17i  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu8ll_BFu17i) C1{ Fi:0 FL:8 Fi:17}



static void Test_BFu0i_BFu8ll_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu17i");
    static BFu0i_BFu8ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0i_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu8ll_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu17i(Test_BFu0i_BFu8ll_BFu17i, "BFu0i_BFu8ll_BFu17i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu17ll  {
  unsigned int  :0;
  __tsu64 v1:8;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu8ll_BFu17ll) C1{ Fi:0 FL:8 FL:17}



static void Test_BFu0i_BFu8ll_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu17ll");
    static BFu0i_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0i_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu8ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu17ll(Test_BFu0i_BFu8ll_BFu17ll, "BFu0i_BFu8ll_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu1c  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu8ll_BFu1c) C1{ Fi:0 FL:8 Fc:1}



static void Test_BFu0i_BFu8ll_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu1c");
    static BFu0i_BFu8ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8ll_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu1c(Test_BFu0i_BFu8ll_BFu1c, "BFu0i_BFu8ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu1i  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu8ll_BFu1i) C1{ Fi:0 FL:8 Fi:1}



static void Test_BFu0i_BFu8ll_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu1i");
    static BFu0i_BFu8ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8ll_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu1i(Test_BFu0i_BFu8ll_BFu1i, "BFu0i_BFu8ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu1ll  {
  unsigned int  :0;
  __tsu64 v1:8;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu8ll_BFu1ll) C1{ Fi:0 FL:8 FL:1}



static void Test_BFu0i_BFu8ll_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu1ll");
    static BFu0i_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu1ll(Test_BFu0i_BFu8ll_BFu1ll, "BFu0i_BFu8ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu1s  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu8ll_BFu1s) C1{ Fi:0 FL:8 Fs:1}



static void Test_BFu0i_BFu8ll_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu1s");
    static BFu0i_BFu8ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8ll_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu1s(Test_BFu0i_BFu8ll_BFu1s, "BFu0i_BFu8ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu31i  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu8ll_BFu31i) C1{ Fi:0 FL:8 Fi:31}



static void Test_BFu0i_BFu8ll_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu31i");
    static BFu0i_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu8ll_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu31i(Test_BFu0i_BFu8ll_BFu31i, "BFu0i_BFu8ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu31ll  {
  unsigned int  :0;
  __tsu64 v1:8;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu8ll_BFu31ll) C1{ Fi:0 FL:8 FL:31}



static void Test_BFu0i_BFu8ll_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu31ll");
    static BFu0i_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0i_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu8ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu31ll(Test_BFu0i_BFu8ll_BFu31ll, "BFu0i_BFu8ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu32i  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu8ll_BFu32i) C1{ Fi:0 FL:8 Fi:32}



static void Test_BFu0i_BFu8ll_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu32i");
    static BFu0i_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu8ll_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu32i(Test_BFu0i_BFu8ll_BFu32i, "BFu0i_BFu8ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu32ll  {
  unsigned int  :0;
  __tsu64 v1:8;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu8ll_BFu32ll) C1{ Fi:0 FL:8 FL:32}



static void Test_BFu0i_BFu8ll_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu32ll");
    static BFu0i_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0i_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu8ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu32ll(Test_BFu0i_BFu8ll_BFu32ll, "BFu0i_BFu8ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu33  {
  unsigned int  :0;
  __tsu64 v1:8;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu8ll_BFu33) C1{ Fi:0 FL:8 FL:33}



static void Test_BFu0i_BFu8ll_BFu33()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu33");
    static BFu0i_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0i_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu8ll_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu33(Test_BFu0i_BFu8ll_BFu33, "BFu0i_BFu8ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu7c  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu8ll_BFu7c) C1{ Fi:0 FL:8 Fc:7}



static void Test_BFu0i_BFu8ll_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu7c");
    static BFu0i_BFu8ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8ll_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu7c(Test_BFu0i_BFu8ll_BFu7c, "BFu0i_BFu8ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu7i  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu8ll_BFu7i) C1{ Fi:0 FL:8 Fi:7}



static void Test_BFu0i_BFu8ll_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu7i");
    static BFu0i_BFu8ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8ll_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu7i(Test_BFu0i_BFu8ll_BFu7i, "BFu0i_BFu8ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu7ll  {
  unsigned int  :0;
  __tsu64 v1:8;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu8ll_BFu7ll) C1{ Fi:0 FL:8 FL:7}



static void Test_BFu0i_BFu8ll_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu7ll");
    static BFu0i_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu7ll(Test_BFu0i_BFu8ll_BFu7ll, "BFu0i_BFu8ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu7s  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu8ll_BFu7s) C1{ Fi:0 FL:8 Fs:7}



static void Test_BFu0i_BFu8ll_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu7s");
    static BFu0i_BFu8ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8ll_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu7s(Test_BFu0i_BFu8ll_BFu7s, "BFu0i_BFu8ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu8c  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu8ll_BFu8c) C1{ Fi:0 FL:8 Fc:8}



static void Test_BFu0i_BFu8ll_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu8c");
    static BFu0i_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu8c(Test_BFu0i_BFu8ll_BFu8c, "BFu0i_BFu8ll_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu8i  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu8ll_BFu8i) C1{ Fi:0 FL:8 Fi:8}



static void Test_BFu0i_BFu8ll_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu8i");
    static BFu0i_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu8i(Test_BFu0i_BFu8ll_BFu8i, "BFu0i_BFu8ll_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu8ll  {
  unsigned int  :0;
  __tsu64 v1:8;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu8ll_BFu8ll) C1{ Fi:0 FL:8 FL:8}



static void Test_BFu0i_BFu8ll_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu8ll");
    static BFu0i_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu8ll(Test_BFu0i_BFu8ll_BFu8ll, "BFu0i_BFu8ll_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu8s  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu8ll_BFu8s) C1{ Fi:0 FL:8 Fs:8}



static void Test_BFu0i_BFu8ll_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu8s");
    static BFu0i_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu8s(Test_BFu0i_BFu8ll_BFu8s, "BFu0i_BFu8ll_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu9i  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu8ll_BFu9i) C1{ Fi:0 FL:8 Fi:9}



static void Test_BFu0i_BFu8ll_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu9i");
    static BFu0i_BFu8ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0i_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu8ll_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu9i(Test_BFu0i_BFu8ll_BFu9i, "BFu0i_BFu8ll_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu9ll  {
  unsigned int  :0;
  __tsu64 v1:8;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu8ll_BFu9ll) C1{ Fi:0 FL:8 FL:9}



static void Test_BFu0i_BFu8ll_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu9ll");
    static BFu0i_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0i_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu8ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu9ll(Test_BFu0i_BFu8ll_BFu9ll, "BFu0i_BFu8ll_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_BFu9s  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu8ll_BFu9s) C1{ Fi:0 FL:8 Fs:9}



static void Test_BFu0i_BFu8ll_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu8ll_BFu9s");
    static BFu0i_BFu8ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0i_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu8ll_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_BFu9s(Test_BFu0i_BFu8ll_BFu9s, "BFu0i_BFu8ll_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_C  {
  unsigned int  :0;
  __tsu64 v1:8;
  char v2;
};
//SIG(1 BFu0i_BFu8ll_C) C1{ Fi:0 FL:8 Fc}



static void Test_BFu0i_BFu8ll_C()
{
  {
    init_simple_test("BFu0i_BFu8ll_C");
    static BFu0i_BFu8ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_C");
    check_field_offset(lv, v2, 1, "BFu0i_BFu8ll_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_C(Test_BFu0i_BFu8ll_C, "BFu0i_BFu8ll_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_D  {
  unsigned int  :0;
  __tsu64 v1:8;
  double v2;
};
//SIG(1 BFu0i_BFu8ll_D) C1{ Fi:0 FL:8 FL}



static void Test_BFu0i_BFu8ll_D()
{
  {
    init_simple_test("BFu0i_BFu8ll_D");
    static BFu0i_BFu8ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu8ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8ll_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_D(Test_BFu0i_BFu8ll_D, "BFu0i_BFu8ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_F  {
  unsigned int  :0;
  __tsu64 v1:8;
  float v2;
};
//SIG(1 BFu0i_BFu8ll_F) C1{ Fi:0 FL:8 Fi}



static void Test_BFu0i_BFu8ll_F()
{
  {
    init_simple_test("BFu0i_BFu8ll_F");
    static BFu0i_BFu8ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu8ll_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_F(Test_BFu0i_BFu8ll_F, "BFu0i_BFu8ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_I  {
  unsigned int  :0;
  __tsu64 v1:8;
  int v2;
};
//SIG(1 BFu0i_BFu8ll_I) C1{ Fi:0 FL:8 Fi}



static void Test_BFu0i_BFu8ll_I()
{
  {
    init_simple_test("BFu0i_BFu8ll_I");
    static BFu0i_BFu8ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu8ll_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_I(Test_BFu0i_BFu8ll_I, "BFu0i_BFu8ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_Ip  {
  unsigned int  :0;
  __tsu64 v1:8;
  int *v2;
};
//SIG(1 BFu0i_BFu8ll_Ip) C1{ Fi:0 FL:8 Fp}



static void Test_BFu0i_BFu8ll_Ip()
{
  {
    init_simple_test("BFu0i_BFu8ll_Ip");
    static BFu0i_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu8ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_Ip(Test_BFu0i_BFu8ll_Ip, "BFu0i_BFu8ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_L  {
  unsigned int  :0;
  __tsu64 v1:8;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu8ll_L) C1{ Fi:0 FL:8 FL}



static void Test_BFu0i_BFu8ll_L()
{
  {
    init_simple_test("BFu0i_BFu8ll_L");
    static BFu0i_BFu8ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu8ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8ll_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_L(Test_BFu0i_BFu8ll_L, "BFu0i_BFu8ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_S  {
  unsigned int  :0;
  __tsu64 v1:8;
  short v2;
};
//SIG(1 BFu0i_BFu8ll_S) C1{ Fi:0 FL:8 Fs}



static void Test_BFu0i_BFu8ll_S()
{
  {
    init_simple_test("BFu0i_BFu8ll_S");
    static BFu0i_BFu8ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu8ll_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_S(Test_BFu0i_BFu8ll_S, "BFu0i_BFu8ll_S", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_Uc  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu8ll_Uc) C1{ Fi:0 FL:8 Fc}



static void Test_BFu0i_BFu8ll_Uc()
{
  {
    init_simple_test("BFu0i_BFu8ll_Uc");
    static BFu0i_BFu8ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_Uc");
    check_field_offset(lv, v2, 1, "BFu0i_BFu8ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_Uc(Test_BFu0i_BFu8ll_Uc, "BFu0i_BFu8ll_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_Ui  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu8ll_Ui) C1{ Fi:0 FL:8 Fi}



static void Test_BFu0i_BFu8ll_Ui()
{
  {
    init_simple_test("BFu0i_BFu8ll_Ui");
    static BFu0i_BFu8ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu8ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_Ui(Test_BFu0i_BFu8ll_Ui, "BFu0i_BFu8ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_Ul  {
  unsigned int  :0;
  __tsu64 v1:8;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu8ll_Ul) C1{ Fi:0 FL:8 FL}



static void Test_BFu0i_BFu8ll_Ul()
{
  {
    init_simple_test("BFu0i_BFu8ll_Ul");
    static BFu0i_BFu8ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu8ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_Ul(Test_BFu0i_BFu8ll_Ul, "BFu0i_BFu8ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_Us  {
  unsigned int  :0;
  __tsu64 v1:8;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu8ll_Us) C1{ Fi:0 FL:8 Fs}



static void Test_BFu0i_BFu8ll_Us()
{
  {
    init_simple_test("BFu0i_BFu8ll_Us");
    static BFu0i_BFu8ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu8ll_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_Us(Test_BFu0i_BFu8ll_Us, "BFu0i_BFu8ll_Us", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8ll_Vp  {
  unsigned int  :0;
  __tsu64 v1:8;
  void *v2;
};
//SIG(1 BFu0i_BFu8ll_Vp) C1{ Fi:0 FL:8 Fp}



static void Test_BFu0i_BFu8ll_Vp()
{
  {
    init_simple_test("BFu0i_BFu8ll_Vp");
    static BFu0i_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu8ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8ll_Vp(Test_BFu0i_BFu8ll_Vp, "BFu0i_BFu8ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s  {
  unsigned int  :0;
  unsigned short v1:8;
};
//SIG(1 BFu0i_BFu8s) C1{ Fi:0 Fs:8}



static void Test_BFu0i_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu8s");
    static BFu0i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s(Test_BFu0i_BFu8s, "BFu0i_BFu8s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu0c  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu8s_BFu0c) C1{ Fi:0 Fs:8 Fc:0}



static void Test_BFu0i_BFu8s_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu0c");
    static BFu0i_BFu8s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu0c(Test_BFu0i_BFu8s_BFu0c, "BFu0i_BFu8s_BFu0c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu0i  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu8s_BFu0i) C1{ Fi:0 Fs:8 Fi:0}



static void Test_BFu0i_BFu8s_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu0i");
    static BFu0i_BFu8s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu0i(Test_BFu0i_BFu8s_BFu0i, "BFu0i_BFu8s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu0ll  {
  unsigned int  :0;
  unsigned short v1:8;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu8s_BFu0ll) C1{ Fi:0 Fs:8 FL:0}



static void Test_BFu0i_BFu8s_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu0ll");
    static BFu0i_BFu8s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu0ll(Test_BFu0i_BFu8s_BFu0ll, "BFu0i_BFu8s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu0s  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu8s_BFu0s) C1{ Fi:0 Fs:8 Fs:0}



static void Test_BFu0i_BFu8s_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu0s");
    static BFu0i_BFu8s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu0s(Test_BFu0i_BFu8s_BFu0s, "BFu0i_BFu8s_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu15i  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu8s_BFu15i) C1{ Fi:0 Fs:8 Fi:15}



static void Test_BFu0i_BFu8s_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu15i");
    static BFu0i_BFu8s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0i_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu8s_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu15i(Test_BFu0i_BFu8s_BFu15i, "BFu0i_BFu8s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu15ll  {
  unsigned int  :0;
  unsigned short v1:8;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu8s_BFu15ll) C1{ Fi:0 Fs:8 FL:15}



static void Test_BFu0i_BFu8s_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu15ll");
    static BFu0i_BFu8s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0i_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu8s_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu15ll(Test_BFu0i_BFu8s_BFu15ll, "BFu0i_BFu8s_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu15s  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu8s_BFu15s) C1{ Fi:0 Fs:8 Fs:15}



static void Test_BFu0i_BFu8s_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu15s");
    static BFu0i_BFu8s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu8s_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu15s(Test_BFu0i_BFu8s_BFu15s, "BFu0i_BFu8s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu16i  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu8s_BFu16i) C1{ Fi:0 Fs:8 Fi:16}



static void Test_BFu0i_BFu8s_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu16i");
    static BFu0i_BFu8s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0i_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu8s_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu16i(Test_BFu0i_BFu8s_BFu16i, "BFu0i_BFu8s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu16ll  {
  unsigned int  :0;
  unsigned short v1:8;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu8s_BFu16ll) C1{ Fi:0 Fs:8 FL:16}



static void Test_BFu0i_BFu8s_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu16ll");
    static BFu0i_BFu8s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0i_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu8s_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu16ll(Test_BFu0i_BFu8s_BFu16ll, "BFu0i_BFu8s_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu16s  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu8s_BFu16s) C1{ Fi:0 Fs:8 Fs:16}



static void Test_BFu0i_BFu8s_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu16s");
    static BFu0i_BFu8s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu8s_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu16s(Test_BFu0i_BFu8s_BFu16s, "BFu0i_BFu8s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu17i  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu8s_BFu17i) C1{ Fi:0 Fs:8 Fi:17}



static void Test_BFu0i_BFu8s_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu17i");
    static BFu0i_BFu8s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0i_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu8s_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu17i(Test_BFu0i_BFu8s_BFu17i, "BFu0i_BFu8s_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu17ll  {
  unsigned int  :0;
  unsigned short v1:8;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu8s_BFu17ll) C1{ Fi:0 Fs:8 FL:17}



static void Test_BFu0i_BFu8s_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu17ll");
    static BFu0i_BFu8s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0i_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0i_BFu8s_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu17ll(Test_BFu0i_BFu8s_BFu17ll, "BFu0i_BFu8s_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu1c  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu8s_BFu1c) C1{ Fi:0 Fs:8 Fc:1}



static void Test_BFu0i_BFu8s_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu1c");
    static BFu0i_BFu8s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8s_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu1c(Test_BFu0i_BFu8s_BFu1c, "BFu0i_BFu8s_BFu1c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu1i  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu8s_BFu1i) C1{ Fi:0 Fs:8 Fi:1}



static void Test_BFu0i_BFu8s_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu1i");
    static BFu0i_BFu8s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8s_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu1i(Test_BFu0i_BFu8s_BFu1i, "BFu0i_BFu8s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu1ll  {
  unsigned int  :0;
  unsigned short v1:8;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu8s_BFu1ll) C1{ Fi:0 Fs:8 FL:1}



static void Test_BFu0i_BFu8s_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu1ll");
    static BFu0i_BFu8s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8s_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu1ll(Test_BFu0i_BFu8s_BFu1ll, "BFu0i_BFu8s_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu1s  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu8s_BFu1s) C1{ Fi:0 Fs:8 Fs:1}



static void Test_BFu0i_BFu8s_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu1s");
    static BFu0i_BFu8s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_BFu8s_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu1s(Test_BFu0i_BFu8s_BFu1s, "BFu0i_BFu8s_BFu1s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu31i  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu8s_BFu31i) C1{ Fi:0 Fs:8 Fi:31}



static void Test_BFu0i_BFu8s_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu31i");
    static BFu0i_BFu8s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu8s_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu31i(Test_BFu0i_BFu8s_BFu31i, "BFu0i_BFu8s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu31ll  {
  unsigned int  :0;
  unsigned short v1:8;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu8s_BFu31ll) C1{ Fi:0 Fs:8 FL:31}



static void Test_BFu0i_BFu8s_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu31ll");
    static BFu0i_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0i_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu8s_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu31ll(Test_BFu0i_BFu8s_BFu31ll, "BFu0i_BFu8s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu32i  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu8s_BFu32i) C1{ Fi:0 Fs:8 Fi:32}



static void Test_BFu0i_BFu8s_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu32i");
    static BFu0i_BFu8s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu8s_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu32i(Test_BFu0i_BFu8s_BFu32i, "BFu0i_BFu8s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu32ll  {
  unsigned int  :0;
  unsigned short v1:8;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu8s_BFu32ll) C1{ Fi:0 Fs:8 FL:32}



static void Test_BFu0i_BFu8s_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu32ll");
    static BFu0i_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0i_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu8s_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu32ll(Test_BFu0i_BFu8s_BFu32ll, "BFu0i_BFu8s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu33  {
  unsigned int  :0;
  unsigned short v1:8;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu8s_BFu33) C1{ Fi:0 Fs:8 FL:33}



static void Test_BFu0i_BFu8s_BFu33()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu33");
    static BFu0i_BFu8s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0i_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0i_BFu8s_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu33(Test_BFu0i_BFu8s_BFu33, "BFu0i_BFu8s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu7c  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu8s_BFu7c) C1{ Fi:0 Fs:8 Fc:7}



static void Test_BFu0i_BFu8s_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu7c");
    static BFu0i_BFu8s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8s_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu7c(Test_BFu0i_BFu8s_BFu7c, "BFu0i_BFu8s_BFu7c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu7i  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu8s_BFu7i) C1{ Fi:0 Fs:8 Fi:7}



static void Test_BFu0i_BFu8s_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu7i");
    static BFu0i_BFu8s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8s_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu7i(Test_BFu0i_BFu8s_BFu7i, "BFu0i_BFu8s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu7ll  {
  unsigned int  :0;
  unsigned short v1:8;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu8s_BFu7ll) C1{ Fi:0 Fs:8 FL:7}



static void Test_BFu0i_BFu8s_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu7ll");
    static BFu0i_BFu8s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8s_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu7ll(Test_BFu0i_BFu8s_BFu7ll, "BFu0i_BFu8s_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu7s  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu8s_BFu7s) C1{ Fi:0 Fs:8 Fs:7}



static void Test_BFu0i_BFu8s_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu7s");
    static BFu0i_BFu8s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_BFu8s_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu7s(Test_BFu0i_BFu8s_BFu7s, "BFu0i_BFu8s_BFu7s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu8c  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu8s_BFu8c) C1{ Fi:0 Fs:8 Fc:8}



static void Test_BFu0i_BFu8s_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu8c");
    static BFu0i_BFu8s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu8c(Test_BFu0i_BFu8s_BFu8c, "BFu0i_BFu8s_BFu8c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu8i  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu8s_BFu8i) C1{ Fi:0 Fs:8 Fi:8}



static void Test_BFu0i_BFu8s_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu8i");
    static BFu0i_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu8i(Test_BFu0i_BFu8s_BFu8i, "BFu0i_BFu8s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu8ll  {
  unsigned int  :0;
  unsigned short v1:8;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu8s_BFu8ll) C1{ Fi:0 Fs:8 FL:8}



static void Test_BFu0i_BFu8s_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu8ll");
    static BFu0i_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu8ll(Test_BFu0i_BFu8s_BFu8ll, "BFu0i_BFu8s_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu8s  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu8s_BFu8s) C1{ Fi:0 Fs:8 Fs:8}



static void Test_BFu0i_BFu8s_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu8s");
    static BFu0i_BFu8s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu8s(Test_BFu0i_BFu8s_BFu8s, "BFu0i_BFu8s_BFu8s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu9i  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu8s_BFu9i) C1{ Fi:0 Fs:8 Fi:9}



static void Test_BFu0i_BFu8s_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu9i");
    static BFu0i_BFu8s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0i_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu8s_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu9i(Test_BFu0i_BFu8s_BFu9i, "BFu0i_BFu8s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu9ll  {
  unsigned int  :0;
  unsigned short v1:8;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu8s_BFu9ll) C1{ Fi:0 Fs:8 FL:9}



static void Test_BFu0i_BFu8s_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu9ll");
    static BFu0i_BFu8s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu8s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0i_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu8s_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu9ll(Test_BFu0i_BFu8s_BFu9ll, "BFu0i_BFu8s_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_BFu9s  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu8s_BFu9s) C1{ Fi:0 Fs:8 Fs:9}



static void Test_BFu0i_BFu8s_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu8s_BFu9s");
    static BFu0i_BFu8s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0i_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu8s_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_BFu9s(Test_BFu0i_BFu8s_BFu9s, "BFu0i_BFu8s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_C  {
  unsigned int  :0;
  unsigned short v1:8;
  char v2;
};
//SIG(1 BFu0i_BFu8s_C) C1{ Fi:0 Fs:8 Fc}



static void Test_BFu0i_BFu8s_C()
{
  {
    init_simple_test("BFu0i_BFu8s_C");
    static BFu0i_BFu8s_C lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8s_C)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_C");
    check_field_offset(lv, v2, 1, "BFu0i_BFu8s_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_C(Test_BFu0i_BFu8s_C, "BFu0i_BFu8s_C", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_D  {
  unsigned int  :0;
  unsigned short v1:8;
  double v2;
};
//SIG(1 BFu0i_BFu8s_D) C1{ Fi:0 Fs:8 FL}



static void Test_BFu0i_BFu8s_D()
{
  {
    init_simple_test("BFu0i_BFu8s_D");
    static BFu0i_BFu8s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu8s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8s_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_D(Test_BFu0i_BFu8s_D, "BFu0i_BFu8s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_F  {
  unsigned int  :0;
  unsigned short v1:8;
  float v2;
};
//SIG(1 BFu0i_BFu8s_F) C1{ Fi:0 Fs:8 Fi}



static void Test_BFu0i_BFu8s_F()
{
  {
    init_simple_test("BFu0i_BFu8s_F");
    static BFu0i_BFu8s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8s_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu8s_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_F(Test_BFu0i_BFu8s_F, "BFu0i_BFu8s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_I  {
  unsigned int  :0;
  unsigned short v1:8;
  int v2;
};
//SIG(1 BFu0i_BFu8s_I) C1{ Fi:0 Fs:8 Fi}



static void Test_BFu0i_BFu8s_I()
{
  {
    init_simple_test("BFu0i_BFu8s_I");
    static BFu0i_BFu8s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8s_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu8s_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_I(Test_BFu0i_BFu8s_I, "BFu0i_BFu8s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_Ip  {
  unsigned int  :0;
  unsigned short v1:8;
  int *v2;
};
//SIG(1 BFu0i_BFu8s_Ip) C1{ Fi:0 Fs:8 Fp}



static void Test_BFu0i_BFu8s_Ip()
{
  {
    init_simple_test("BFu0i_BFu8s_Ip");
    static BFu0i_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu8s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8s_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_Ip(Test_BFu0i_BFu8s_Ip, "BFu0i_BFu8s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_L  {
  unsigned int  :0;
  unsigned short v1:8;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu8s_L) C1{ Fi:0 Fs:8 FL}



static void Test_BFu0i_BFu8s_L()
{
  {
    init_simple_test("BFu0i_BFu8s_L");
    static BFu0i_BFu8s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu8s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8s_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_L(Test_BFu0i_BFu8s_L, "BFu0i_BFu8s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_S  {
  unsigned int  :0;
  unsigned short v1:8;
  short v2;
};
//SIG(1 BFu0i_BFu8s_S) C1{ Fi:0 Fs:8 Fs}



static void Test_BFu0i_BFu8s_S()
{
  {
    init_simple_test("BFu0i_BFu8s_S");
    static BFu0i_BFu8s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8s_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu8s_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_S(Test_BFu0i_BFu8s_S, "BFu0i_BFu8s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_Uc  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu8s_Uc) C1{ Fi:0 Fs:8 Fc}



static void Test_BFu0i_BFu8s_Uc()
{
  {
    init_simple_test("BFu0i_BFu8s_Uc");
    static BFu0i_BFu8s_Uc lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu8s_Uc)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_Uc");
    check_field_offset(lv, v2, 1, "BFu0i_BFu8s_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_Uc(Test_BFu0i_BFu8s_Uc, "BFu0i_BFu8s_Uc", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_Ui  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu8s_Ui) C1{ Fi:0 Fs:8 Fi}



static void Test_BFu0i_BFu8s_Ui()
{
  {
    init_simple_test("BFu0i_BFu8s_Ui");
    static BFu0i_BFu8s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu8s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu8s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu8s_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_Ui(Test_BFu0i_BFu8s_Ui, "BFu0i_BFu8s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_Ul  {
  unsigned int  :0;
  unsigned short v1:8;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu8s_Ul) C1{ Fi:0 Fs:8 FL}



static void Test_BFu0i_BFu8s_Ul()
{
  {
    init_simple_test("BFu0i_BFu8s_Ul");
    static BFu0i_BFu8s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu8s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8s_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_Ul(Test_BFu0i_BFu8s_Ul, "BFu0i_BFu8s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_Us  {
  unsigned int  :0;
  unsigned short v1:8;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu8s_Us) C1{ Fi:0 Fs:8 Fs}



static void Test_BFu0i_BFu8s_Us()
{
  {
    init_simple_test("BFu0i_BFu8s_Us");
    static BFu0i_BFu8s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu8s_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu8s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu8s_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_Us(Test_BFu0i_BFu8s_Us, "BFu0i_BFu8s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu8s_Vp  {
  unsigned int  :0;
  unsigned short v1:8;
  void *v2;
};
//SIG(1 BFu0i_BFu8s_Vp) C1{ Fi:0 Fs:8 Fp}



static void Test_BFu0i_BFu8s_Vp()
{
  {
    init_simple_test("BFu0i_BFu8s_Vp");
    static BFu0i_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu8s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu8s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "BFu0i_BFu8s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu8s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu8s_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu8s_Vp(Test_BFu0i_BFu8s_Vp, "BFu0i_BFu8s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i  {
  unsigned int  :0;
  unsigned int v1:9;
};
//SIG(1 BFu0i_BFu9i) C1{ Fi:0 Fi:9}



static void Test_BFu0i_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu9i");
    static BFu0i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i(Test_BFu0i_BFu9i, "BFu0i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu0c  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu9i_BFu0c) C1{ Fi:0 Fi:9 Fc:0}



static void Test_BFu0i_BFu9i_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu0c");
    static BFu0i_BFu9i_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu0c(Test_BFu0i_BFu9i_BFu0c, "BFu0i_BFu9i_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu0i  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu9i_BFu0i) C1{ Fi:0 Fi:9 Fi:0}



static void Test_BFu0i_BFu9i_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu0i");
    static BFu0i_BFu9i_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu0i(Test_BFu0i_BFu9i_BFu0i, "BFu0i_BFu9i_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu0ll  {
  unsigned int  :0;
  unsigned int v1:9;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu9i_BFu0ll) C1{ Fi:0 Fi:9 FL:0}



static void Test_BFu0i_BFu9i_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu0ll");
    static BFu0i_BFu9i_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9i_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0i_BFu9i_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu0ll(Test_BFu0i_BFu9i_BFu0ll, "BFu0i_BFu9i_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu0s  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu9i_BFu0s) C1{ Fi:0 Fi:9 Fs:0}



static void Test_BFu0i_BFu9i_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu0s");
    static BFu0i_BFu9i_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu0s(Test_BFu0i_BFu9i_BFu0s, "BFu0i_BFu9i_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu15i  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu9i_BFu15i) C1{ Fi:0 Fi:9 Fi:15}



static void Test_BFu0i_BFu9i_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu15i");
    static BFu0i_BFu9i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0i_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu9i_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu15i(Test_BFu0i_BFu9i_BFu15i, "BFu0i_BFu9i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu15ll  {
  unsigned int  :0;
  unsigned int v1:9;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu9i_BFu15ll) C1{ Fi:0 Fi:9 FL:15}



static void Test_BFu0i_BFu9i_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu15ll");
    static BFu0i_BFu9i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0i_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu9i_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu15ll(Test_BFu0i_BFu9i_BFu15ll, "BFu0i_BFu9i_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu15s  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu9i_BFu15s) C1{ Fi:0 Fi:9 Fs:15}



static void Test_BFu0i_BFu9i_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu15s");
    static BFu0i_BFu9i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu9i_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu15s(Test_BFu0i_BFu9i_BFu15s, "BFu0i_BFu9i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu16i  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu9i_BFu16i) C1{ Fi:0 Fi:9 Fi:16}



static void Test_BFu0i_BFu9i_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu16i");
    static BFu0i_BFu9i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0i_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0i_BFu9i_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu16i(Test_BFu0i_BFu9i_BFu16i, "BFu0i_BFu9i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu16ll  {
  unsigned int  :0;
  unsigned int v1:9;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu9i_BFu16ll) C1{ Fi:0 Fi:9 FL:16}



static void Test_BFu0i_BFu9i_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu16ll");
    static BFu0i_BFu9i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0i_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0i_BFu9i_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu16ll(Test_BFu0i_BFu9i_BFu16ll, "BFu0i_BFu9i_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu16s  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu9i_BFu16s) C1{ Fi:0 Fi:9 Fs:16}



static void Test_BFu0i_BFu9i_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu16s");
    static BFu0i_BFu9i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu9i_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu16s(Test_BFu0i_BFu9i_BFu16s, "BFu0i_BFu9i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu17i  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu9i_BFu17i) C1{ Fi:0 Fi:9 Fi:17}



static void Test_BFu0i_BFu9i_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu17i");
    static BFu0i_BFu9i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0i_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0i_BFu9i_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu17i(Test_BFu0i_BFu9i_BFu17i, "BFu0i_BFu9i_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu17ll  {
  unsigned int  :0;
  unsigned int v1:9;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu9i_BFu17ll) C1{ Fi:0 Fi:9 FL:17}



static void Test_BFu0i_BFu9i_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu17ll");
    static BFu0i_BFu9i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0i_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0i_BFu9i_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu17ll(Test_BFu0i_BFu9i_BFu17ll, "BFu0i_BFu9i_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu1c  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu9i_BFu1c) C1{ Fi:0 Fi:9 Fc:1}



static void Test_BFu0i_BFu9i_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu1c");
    static BFu0i_BFu9i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0i_BFu9i_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu1c(Test_BFu0i_BFu9i_BFu1c, "BFu0i_BFu9i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu1i  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu9i_BFu1i) C1{ Fi:0 Fi:9 Fi:1}



static void Test_BFu0i_BFu9i_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu1i");
    static BFu0i_BFu9i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0i_BFu9i_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu1i(Test_BFu0i_BFu9i_BFu1i, "BFu0i_BFu9i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu1ll  {
  unsigned int  :0;
  unsigned int v1:9;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu9i_BFu1ll) C1{ Fi:0 Fi:9 FL:1}



static void Test_BFu0i_BFu9i_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu1ll");
    static BFu0i_BFu9i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0i_BFu9i_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu1ll(Test_BFu0i_BFu9i_BFu1ll, "BFu0i_BFu9i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu1s  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu9i_BFu1s) C1{ Fi:0 Fi:9 Fs:1}



static void Test_BFu0i_BFu9i_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu1s");
    static BFu0i_BFu9i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0i_BFu9i_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu1s(Test_BFu0i_BFu9i_BFu1s, "BFu0i_BFu9i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu31i  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu9i_BFu31i) C1{ Fi:0 Fi:9 Fi:31}



static void Test_BFu0i_BFu9i_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu31i");
    static BFu0i_BFu9i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu9i_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu31i(Test_BFu0i_BFu9i_BFu31i, "BFu0i_BFu9i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu31ll  {
  unsigned int  :0;
  unsigned int v1:9;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu9i_BFu31ll) C1{ Fi:0 Fi:9 FL:31}



static void Test_BFu0i_BFu9i_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu31ll");
    static BFu0i_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu0i_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu0i_BFu9i_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu31ll(Test_BFu0i_BFu9i_BFu31ll, "BFu0i_BFu9i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu32i  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu9i_BFu32i) C1{ Fi:0 Fi:9 Fi:32}



static void Test_BFu0i_BFu9i_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu32i");
    static BFu0i_BFu9i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu9i_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu32i(Test_BFu0i_BFu9i_BFu32i, "BFu0i_BFu9i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu32ll  {
  unsigned int  :0;
  unsigned int v1:9;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu9i_BFu32ll) C1{ Fi:0 Fi:9 FL:32}



static void Test_BFu0i_BFu9i_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu32ll");
    static BFu0i_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu0i_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu0i_BFu9i_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu32ll(Test_BFu0i_BFu9i_BFu32ll, "BFu0i_BFu9i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu33  {
  unsigned int  :0;
  unsigned int v1:9;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu9i_BFu33) C1{ Fi:0 Fi:9 FL:33}



static void Test_BFu0i_BFu9i_BFu33()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu33");
    static BFu0i_BFu9i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, 1, "BFu0i_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, hide_ull(1LL<<32), "BFu0i_BFu9i_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu33(Test_BFu0i_BFu9i_BFu33, "BFu0i_BFu9i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu7c  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu9i_BFu7c) C1{ Fi:0 Fi:9 Fc:7}



static void Test_BFu0i_BFu9i_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu7c");
    static BFu0i_BFu9i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0i_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu9i_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu7c(Test_BFu0i_BFu9i_BFu7c, "BFu0i_BFu9i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu7i  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu9i_BFu7i) C1{ Fi:0 Fi:9 Fi:7}



static void Test_BFu0i_BFu9i_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu7i");
    static BFu0i_BFu9i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0i_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu9i_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu7i(Test_BFu0i_BFu9i_BFu7i, "BFu0i_BFu9i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu7ll  {
  unsigned int  :0;
  unsigned int v1:9;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu9i_BFu7ll) C1{ Fi:0 Fi:9 FL:7}



static void Test_BFu0i_BFu9i_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu7ll");
    static BFu0i_BFu9i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0i_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu9i_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu7ll(Test_BFu0i_BFu9i_BFu7ll, "BFu0i_BFu9i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu7s  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu9i_BFu7s) C1{ Fi:0 Fi:9 Fs:7}



static void Test_BFu0i_BFu9i_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu7s");
    static BFu0i_BFu9i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0i_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu9i_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu7s(Test_BFu0i_BFu9i_BFu7s, "BFu0i_BFu9i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu8c  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu9i_BFu8c) C1{ Fi:0 Fi:9 Fc:8}



static void Test_BFu0i_BFu9i_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu8c");
    static BFu0i_BFu9i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0i_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu9i_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu8c(Test_BFu0i_BFu9i_BFu8c, "BFu0i_BFu9i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu8i  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu9i_BFu8i) C1{ Fi:0 Fi:9 Fi:8}



static void Test_BFu0i_BFu9i_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu8i");
    static BFu0i_BFu9i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0i_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu9i_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu8i(Test_BFu0i_BFu9i_BFu8i, "BFu0i_BFu9i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu8ll  {
  unsigned int  :0;
  unsigned int v1:9;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu9i_BFu8ll) C1{ Fi:0 Fi:9 FL:8}



static void Test_BFu0i_BFu9i_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu8ll");
    static BFu0i_BFu9i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0i_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu9i_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu8ll(Test_BFu0i_BFu9i_BFu8ll, "BFu0i_BFu9i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu8s  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu9i_BFu8s) C1{ Fi:0 Fi:9 Fs:8}



static void Test_BFu0i_BFu9i_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu8s");
    static BFu0i_BFu9i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0i_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu9i_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu8s(Test_BFu0i_BFu9i_BFu8s, "BFu0i_BFu9i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu9i  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu9i_BFu9i) C1{ Fi:0 Fi:9 Fi:9}



static void Test_BFu0i_BFu9i_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu9i");
    static BFu0i_BFu9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0i_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu9i(Test_BFu0i_BFu9i_BFu9i, "BFu0i_BFu9i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu9ll  {
  unsigned int  :0;
  unsigned int v1:9;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu9i_BFu9ll) C1{ Fi:0 Fi:9 FL:9}



static void Test_BFu0i_BFu9i_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu9ll");
    static BFu0i_BFu9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0i_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu9ll(Test_BFu0i_BFu9i_BFu9ll, "BFu0i_BFu9i_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_BFu9s  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu9i_BFu9s) C1{ Fi:0 Fi:9 Fs:9}



static void Test_BFu0i_BFu9i_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu9i_BFu9s");
    static BFu0i_BFu9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0i_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_BFu9s(Test_BFu0i_BFu9i_BFu9s, "BFu0i_BFu9i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_C  {
  unsigned int  :0;
  unsigned int v1:9;
  char v2;
};
//SIG(1 BFu0i_BFu9i_C) C1{ Fi:0 Fi:9 Fc}



static void Test_BFu0i_BFu9i_C()
{
  {
    init_simple_test("BFu0i_BFu9i_C");
    static BFu0i_BFu9i_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_C");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9i_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_C(Test_BFu0i_BFu9i_C, "BFu0i_BFu9i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_D  {
  unsigned int  :0;
  unsigned int v1:9;
  double v2;
};
//SIG(1 BFu0i_BFu9i_D) C1{ Fi:0 Fi:9 FL}



static void Test_BFu0i_BFu9i_D()
{
  {
    init_simple_test("BFu0i_BFu9i_D");
    static BFu0i_BFu9i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu9i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9i_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_D(Test_BFu0i_BFu9i_D, "BFu0i_BFu9i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_F  {
  unsigned int  :0;
  unsigned int v1:9;
  float v2;
};
//SIG(1 BFu0i_BFu9i_F) C1{ Fi:0 Fi:9 Fi}



static void Test_BFu0i_BFu9i_F()
{
  {
    init_simple_test("BFu0i_BFu9i_F");
    static BFu0i_BFu9i_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu9i_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_F(Test_BFu0i_BFu9i_F, "BFu0i_BFu9i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_I  {
  unsigned int  :0;
  unsigned int v1:9;
  int v2;
};
//SIG(1 BFu0i_BFu9i_I) C1{ Fi:0 Fi:9 Fi}



static void Test_BFu0i_BFu9i_I()
{
  {
    init_simple_test("BFu0i_BFu9i_I");
    static BFu0i_BFu9i_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu9i_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_I(Test_BFu0i_BFu9i_I, "BFu0i_BFu9i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_Ip  {
  unsigned int  :0;
  unsigned int v1:9;
  int *v2;
};
//SIG(1 BFu0i_BFu9i_Ip) C1{ Fi:0 Fi:9 Fp}



static void Test_BFu0i_BFu9i_Ip()
{
  {
    init_simple_test("BFu0i_BFu9i_Ip");
    static BFu0i_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu9i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9i_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_Ip(Test_BFu0i_BFu9i_Ip, "BFu0i_BFu9i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_L  {
  unsigned int  :0;
  unsigned int v1:9;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu9i_L) C1{ Fi:0 Fi:9 FL}



static void Test_BFu0i_BFu9i_L()
{
  {
    init_simple_test("BFu0i_BFu9i_L");
    static BFu0i_BFu9i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu9i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9i_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_L(Test_BFu0i_BFu9i_L, "BFu0i_BFu9i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_S  {
  unsigned int  :0;
  unsigned int v1:9;
  short v2;
};
//SIG(1 BFu0i_BFu9i_S) C1{ Fi:0 Fi:9 Fs}



static void Test_BFu0i_BFu9i_S()
{
  {
    init_simple_test("BFu0i_BFu9i_S");
    static BFu0i_BFu9i_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9i_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_S(Test_BFu0i_BFu9i_S, "BFu0i_BFu9i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_Uc  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu9i_Uc) C1{ Fi:0 Fi:9 Fc}



static void Test_BFu0i_BFu9i_Uc()
{
  {
    init_simple_test("BFu0i_BFu9i_Uc");
    static BFu0i_BFu9i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_Uc");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9i_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_Uc(Test_BFu0i_BFu9i_Uc, "BFu0i_BFu9i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_Ui  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu9i_Ui) C1{ Fi:0 Fi:9 Fi}



static void Test_BFu0i_BFu9i_Ui()
{
  {
    init_simple_test("BFu0i_BFu9i_Ui");
    static BFu0i_BFu9i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu9i_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_Ui(Test_BFu0i_BFu9i_Ui, "BFu0i_BFu9i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_Ul  {
  unsigned int  :0;
  unsigned int v1:9;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu9i_Ul) C1{ Fi:0 Fi:9 FL}



static void Test_BFu0i_BFu9i_Ul()
{
  {
    init_simple_test("BFu0i_BFu9i_Ul");
    static BFu0i_BFu9i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu9i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9i_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_Ul(Test_BFu0i_BFu9i_Ul, "BFu0i_BFu9i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_Us  {
  unsigned int  :0;
  unsigned int v1:9;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu9i_Us) C1{ Fi:0 Fi:9 Fs}



static void Test_BFu0i_BFu9i_Us()
{
  {
    init_simple_test("BFu0i_BFu9i_Us");
    static BFu0i_BFu9i_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9i_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_Us(Test_BFu0i_BFu9i_Us, "BFu0i_BFu9i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9i_Vp  {
  unsigned int  :0;
  unsigned int v1:9;
  void *v2;
};
//SIG(1 BFu0i_BFu9i_Vp) C1{ Fi:0 Fi:9 Fp}



static void Test_BFu0i_BFu9i_Vp()
{
  {
    init_simple_test("BFu0i_BFu9i_Vp");
    static BFu0i_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu9i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9i_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9i_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9i_Vp(Test_BFu0i_BFu9i_Vp, "BFu0i_BFu9i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll  {
  unsigned int  :0;
  __tsu64 v1:9;
};
//SIG(1 BFu0i_BFu9ll) C1{ Fi:0 FL:9}



static void Test_BFu0i_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu9ll");
    static BFu0i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll(Test_BFu0i_BFu9ll, "BFu0i_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu0c  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu9ll_BFu0c) C1{ Fi:0 FL:9 Fc:0}



static void Test_BFu0i_BFu9ll_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu0c");
    static BFu0i_BFu9ll_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu0c(Test_BFu0i_BFu9ll_BFu0c, "BFu0i_BFu9ll_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu0i  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu9ll_BFu0i) C1{ Fi:0 FL:9 Fi:0}



static void Test_BFu0i_BFu9ll_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu0i");
    static BFu0i_BFu9ll_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu0i(Test_BFu0i_BFu9ll_BFu0i, "BFu0i_BFu9ll_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu0ll  {
  unsigned int  :0;
  __tsu64 v1:9;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu9ll_BFu0ll) C1{ Fi:0 FL:9 FL:0}



static void Test_BFu0i_BFu9ll_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu0ll");
    static BFu0i_BFu9ll_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu0ll(Test_BFu0i_BFu9ll_BFu0ll, "BFu0i_BFu9ll_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu0s  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu9ll_BFu0s) C1{ Fi:0 FL:9 Fs:0}



static void Test_BFu0i_BFu9ll_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu0s");
    static BFu0i_BFu9ll_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu0s(Test_BFu0i_BFu9ll_BFu0s, "BFu0i_BFu9ll_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu15i  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu9ll_BFu15i) C1{ Fi:0 FL:9 Fi:15}



static void Test_BFu0i_BFu9ll_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu15i");
    static BFu0i_BFu9ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0i_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu9ll_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu15i(Test_BFu0i_BFu9ll_BFu15i, "BFu0i_BFu9ll_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu15ll  {
  unsigned int  :0;
  __tsu64 v1:9;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu9ll_BFu15ll) C1{ Fi:0 FL:9 FL:15}



static void Test_BFu0i_BFu9ll_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu15ll");
    static BFu0i_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0i_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu9ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu15ll(Test_BFu0i_BFu9ll_BFu15ll, "BFu0i_BFu9ll_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu15s  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu9ll_BFu15s) C1{ Fi:0 FL:9 Fs:15}



static void Test_BFu0i_BFu9ll_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu15s");
    static BFu0i_BFu9ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu9ll_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu15s(Test_BFu0i_BFu9ll_BFu15s, "BFu0i_BFu9ll_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu16i  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu9ll_BFu16i) C1{ Fi:0 FL:9 Fi:16}



static void Test_BFu0i_BFu9ll_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu16i");
    static BFu0i_BFu9ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0i_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0i_BFu9ll_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu16i(Test_BFu0i_BFu9ll_BFu16i, "BFu0i_BFu9ll_BFu16i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu16ll  {
  unsigned int  :0;
  __tsu64 v1:9;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu9ll_BFu16ll) C1{ Fi:0 FL:9 FL:16}



static void Test_BFu0i_BFu9ll_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu16ll");
    static BFu0i_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0i_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0i_BFu9ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu16ll(Test_BFu0i_BFu9ll_BFu16ll, "BFu0i_BFu9ll_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu16s  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu9ll_BFu16s) C1{ Fi:0 FL:9 Fs:16}



static void Test_BFu0i_BFu9ll_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu16s");
    static BFu0i_BFu9ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu9ll_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu16s(Test_BFu0i_BFu9ll_BFu16s, "BFu0i_BFu9ll_BFu16s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu17i  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu9ll_BFu17i) C1{ Fi:0 FL:9 Fi:17}



static void Test_BFu0i_BFu9ll_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu17i");
    static BFu0i_BFu9ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0i_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0i_BFu9ll_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu17i(Test_BFu0i_BFu9ll_BFu17i, "BFu0i_BFu9ll_BFu17i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu17ll  {
  unsigned int  :0;
  __tsu64 v1:9;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu9ll_BFu17ll) C1{ Fi:0 FL:9 FL:17}



static void Test_BFu0i_BFu9ll_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu17ll");
    static BFu0i_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0i_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0i_BFu9ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu17ll(Test_BFu0i_BFu9ll_BFu17ll, "BFu0i_BFu9ll_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu1c  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu9ll_BFu1c) C1{ Fi:0 FL:9 Fc:1}



static void Test_BFu0i_BFu9ll_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu1c");
    static BFu0i_BFu9ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0i_BFu9ll_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu1c(Test_BFu0i_BFu9ll_BFu1c, "BFu0i_BFu9ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu1i  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu9ll_BFu1i) C1{ Fi:0 FL:9 Fi:1}



static void Test_BFu0i_BFu9ll_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu1i");
    static BFu0i_BFu9ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0i_BFu9ll_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu1i(Test_BFu0i_BFu9ll_BFu1i, "BFu0i_BFu9ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu1ll  {
  unsigned int  :0;
  __tsu64 v1:9;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu9ll_BFu1ll) C1{ Fi:0 FL:9 FL:1}



static void Test_BFu0i_BFu9ll_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu1ll");
    static BFu0i_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0i_BFu9ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu1ll(Test_BFu0i_BFu9ll_BFu1ll, "BFu0i_BFu9ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu1s  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu9ll_BFu1s) C1{ Fi:0 FL:9 Fs:1}



static void Test_BFu0i_BFu9ll_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu1s");
    static BFu0i_BFu9ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0i_BFu9ll_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu1s(Test_BFu0i_BFu9ll_BFu1s, "BFu0i_BFu9ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu31i  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu9ll_BFu31i) C1{ Fi:0 FL:9 Fi:31}



static void Test_BFu0i_BFu9ll_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu31i");
    static BFu0i_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu9ll_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu31i(Test_BFu0i_BFu9ll_BFu31i, "BFu0i_BFu9ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu31ll  {
  unsigned int  :0;
  __tsu64 v1:9;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu9ll_BFu31ll) C1{ Fi:0 FL:9 FL:31}



static void Test_BFu0i_BFu9ll_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu31ll");
    static BFu0i_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu0i_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu0i_BFu9ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu31ll(Test_BFu0i_BFu9ll_BFu31ll, "BFu0i_BFu9ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu32i  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu9ll_BFu32i) C1{ Fi:0 FL:9 Fi:32}



static void Test_BFu0i_BFu9ll_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu32i");
    static BFu0i_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu9ll_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu32i(Test_BFu0i_BFu9ll_BFu32i, "BFu0i_BFu9ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu32ll  {
  unsigned int  :0;
  __tsu64 v1:9;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu9ll_BFu32ll) C1{ Fi:0 FL:9 FL:32}



static void Test_BFu0i_BFu9ll_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu32ll");
    static BFu0i_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu0i_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu0i_BFu9ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu32ll(Test_BFu0i_BFu9ll_BFu32ll, "BFu0i_BFu9ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu33  {
  unsigned int  :0;
  __tsu64 v1:9;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu9ll_BFu33) C1{ Fi:0 FL:9 FL:33}



static void Test_BFu0i_BFu9ll_BFu33()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu33");
    static BFu0i_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, 1, "BFu0i_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, hide_ull(1LL<<32), "BFu0i_BFu9ll_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu33(Test_BFu0i_BFu9ll_BFu33, "BFu0i_BFu9ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu7c  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu9ll_BFu7c) C1{ Fi:0 FL:9 Fc:7}



static void Test_BFu0i_BFu9ll_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu7c");
    static BFu0i_BFu9ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0i_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu9ll_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu7c(Test_BFu0i_BFu9ll_BFu7c, "BFu0i_BFu9ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu7i  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu9ll_BFu7i) C1{ Fi:0 FL:9 Fi:7}



static void Test_BFu0i_BFu9ll_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu7i");
    static BFu0i_BFu9ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0i_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu9ll_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu7i(Test_BFu0i_BFu9ll_BFu7i, "BFu0i_BFu9ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu7ll  {
  unsigned int  :0;
  __tsu64 v1:9;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu9ll_BFu7ll) C1{ Fi:0 FL:9 FL:7}



static void Test_BFu0i_BFu9ll_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu7ll");
    static BFu0i_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0i_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu9ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu7ll(Test_BFu0i_BFu9ll_BFu7ll, "BFu0i_BFu9ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu7s  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu9ll_BFu7s) C1{ Fi:0 FL:9 Fs:7}



static void Test_BFu0i_BFu9ll_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu7s");
    static BFu0i_BFu9ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0i_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu9ll_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu7s(Test_BFu0i_BFu9ll_BFu7s, "BFu0i_BFu9ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu8c  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu9ll_BFu8c) C1{ Fi:0 FL:9 Fc:8}



static void Test_BFu0i_BFu9ll_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu8c");
    static BFu0i_BFu9ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0i_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu9ll_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu8c(Test_BFu0i_BFu9ll_BFu8c, "BFu0i_BFu9ll_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu8i  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu9ll_BFu8i) C1{ Fi:0 FL:9 Fi:8}



static void Test_BFu0i_BFu9ll_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu8i");
    static BFu0i_BFu9ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0i_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu9ll_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu8i(Test_BFu0i_BFu9ll_BFu8i, "BFu0i_BFu9ll_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu8ll  {
  unsigned int  :0;
  __tsu64 v1:9;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu9ll_BFu8ll) C1{ Fi:0 FL:9 FL:8}



static void Test_BFu0i_BFu9ll_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu8ll");
    static BFu0i_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0i_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu9ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu8ll(Test_BFu0i_BFu9ll_BFu8ll, "BFu0i_BFu9ll_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu8s  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu9ll_BFu8s) C1{ Fi:0 FL:9 Fs:8}



static void Test_BFu0i_BFu9ll_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu8s");
    static BFu0i_BFu9ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0i_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu9ll_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu8s(Test_BFu0i_BFu9ll_BFu8s, "BFu0i_BFu9ll_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu9i  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu9ll_BFu9i) C1{ Fi:0 FL:9 Fi:9}



static void Test_BFu0i_BFu9ll_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu9i");
    static BFu0i_BFu9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0i_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu9i(Test_BFu0i_BFu9ll_BFu9i, "BFu0i_BFu9ll_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu9ll  {
  unsigned int  :0;
  __tsu64 v1:9;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu9ll_BFu9ll) C1{ Fi:0 FL:9 FL:9}



static void Test_BFu0i_BFu9ll_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu9ll");
    static BFu0i_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0i_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu9ll(Test_BFu0i_BFu9ll_BFu9ll, "BFu0i_BFu9ll_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_BFu9s  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu9ll_BFu9s) C1{ Fi:0 FL:9 Fs:9}



static void Test_BFu0i_BFu9ll_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu9ll_BFu9s");
    static BFu0i_BFu9ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0i_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_BFu9s(Test_BFu0i_BFu9ll_BFu9s, "BFu0i_BFu9ll_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_C  {
  unsigned int  :0;
  __tsu64 v1:9;
  char v2;
};
//SIG(1 BFu0i_BFu9ll_C) C1{ Fi:0 FL:9 Fc}



static void Test_BFu0i_BFu9ll_C()
{
  {
    init_simple_test("BFu0i_BFu9ll_C");
    static BFu0i_BFu9ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_C");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9ll_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_C(Test_BFu0i_BFu9ll_C, "BFu0i_BFu9ll_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_D  {
  unsigned int  :0;
  __tsu64 v1:9;
  double v2;
};
//SIG(1 BFu0i_BFu9ll_D) C1{ Fi:0 FL:9 FL}



static void Test_BFu0i_BFu9ll_D()
{
  {
    init_simple_test("BFu0i_BFu9ll_D");
    static BFu0i_BFu9ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu9ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9ll_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_D(Test_BFu0i_BFu9ll_D, "BFu0i_BFu9ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_F  {
  unsigned int  :0;
  __tsu64 v1:9;
  float v2;
};
//SIG(1 BFu0i_BFu9ll_F) C1{ Fi:0 FL:9 Fi}



static void Test_BFu0i_BFu9ll_F()
{
  {
    init_simple_test("BFu0i_BFu9ll_F");
    static BFu0i_BFu9ll_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu9ll_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_F(Test_BFu0i_BFu9ll_F, "BFu0i_BFu9ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_I  {
  unsigned int  :0;
  __tsu64 v1:9;
  int v2;
};
//SIG(1 BFu0i_BFu9ll_I) C1{ Fi:0 FL:9 Fi}



static void Test_BFu0i_BFu9ll_I()
{
  {
    init_simple_test("BFu0i_BFu9ll_I");
    static BFu0i_BFu9ll_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu9ll_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_I(Test_BFu0i_BFu9ll_I, "BFu0i_BFu9ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_Ip  {
  unsigned int  :0;
  __tsu64 v1:9;
  int *v2;
};
//SIG(1 BFu0i_BFu9ll_Ip) C1{ Fi:0 FL:9 Fp}



static void Test_BFu0i_BFu9ll_Ip()
{
  {
    init_simple_test("BFu0i_BFu9ll_Ip");
    static BFu0i_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu9ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9ll_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_Ip(Test_BFu0i_BFu9ll_Ip, "BFu0i_BFu9ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_L  {
  unsigned int  :0;
  __tsu64 v1:9;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu9ll_L) C1{ Fi:0 FL:9 FL}



static void Test_BFu0i_BFu9ll_L()
{
  {
    init_simple_test("BFu0i_BFu9ll_L");
    static BFu0i_BFu9ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu9ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9ll_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_L(Test_BFu0i_BFu9ll_L, "BFu0i_BFu9ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_S  {
  unsigned int  :0;
  __tsu64 v1:9;
  short v2;
};
//SIG(1 BFu0i_BFu9ll_S) C1{ Fi:0 FL:9 Fs}



static void Test_BFu0i_BFu9ll_S()
{
  {
    init_simple_test("BFu0i_BFu9ll_S");
    static BFu0i_BFu9ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9ll_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_S(Test_BFu0i_BFu9ll_S, "BFu0i_BFu9ll_S", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_Uc  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu9ll_Uc) C1{ Fi:0 FL:9 Fc}



static void Test_BFu0i_BFu9ll_Uc()
{
  {
    init_simple_test("BFu0i_BFu9ll_Uc");
    static BFu0i_BFu9ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_Uc");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9ll_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_Uc(Test_BFu0i_BFu9ll_Uc, "BFu0i_BFu9ll_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_Ui  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu9ll_Ui) C1{ Fi:0 FL:9 Fi}



static void Test_BFu0i_BFu9ll_Ui()
{
  {
    init_simple_test("BFu0i_BFu9ll_Ui");
    static BFu0i_BFu9ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu9ll_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_Ui(Test_BFu0i_BFu9ll_Ui, "BFu0i_BFu9ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_Ul  {
  unsigned int  :0;
  __tsu64 v1:9;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu9ll_Ul) C1{ Fi:0 FL:9 FL}



static void Test_BFu0i_BFu9ll_Ul()
{
  {
    init_simple_test("BFu0i_BFu9ll_Ul");
    static BFu0i_BFu9ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu9ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9ll_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_Ul(Test_BFu0i_BFu9ll_Ul, "BFu0i_BFu9ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_Us  {
  unsigned int  :0;
  __tsu64 v1:9;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu9ll_Us) C1{ Fi:0 FL:9 Fs}



static void Test_BFu0i_BFu9ll_Us()
{
  {
    init_simple_test("BFu0i_BFu9ll_Us");
    static BFu0i_BFu9ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9ll_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_Us(Test_BFu0i_BFu9ll_Us, "BFu0i_BFu9ll_Us", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9ll_Vp  {
  unsigned int  :0;
  __tsu64 v1:9;
  void *v2;
};
//SIG(1 BFu0i_BFu9ll_Vp) C1{ Fi:0 FL:9 Fp}



static void Test_BFu0i_BFu9ll_Vp()
{
  {
    init_simple_test("BFu0i_BFu9ll_Vp");
    static BFu0i_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu9ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9ll_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9ll_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9ll_Vp(Test_BFu0i_BFu9ll_Vp, "BFu0i_BFu9ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s  {
  unsigned int  :0;
  unsigned short v1:9;
};
//SIG(1 BFu0i_BFu9s) C1{ Fi:0 Fs:9}



static void Test_BFu0i_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu9s");
    static BFu0i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s(Test_BFu0i_BFu9s, "BFu0i_BFu9s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu0c  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned char  :0;
};
//SIG(1 BFu0i_BFu9s_BFu0c) C1{ Fi:0 Fs:9 Fc:0}



static void Test_BFu0i_BFu9s_BFu0c()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu0c");
    static BFu0i_BFu9s_BFu0c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu9s_BFu0c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_BFu0c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu0c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu0c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu0c(Test_BFu0i_BFu9s_BFu0c, "BFu0i_BFu9s_BFu0c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu0i  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned int  :0;
};
//SIG(1 BFu0i_BFu9s_BFu0i) C1{ Fi:0 Fs:9 Fi:0}



static void Test_BFu0i_BFu9s_BFu0i()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu0i");
    static BFu0i_BFu9s_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_BFu0i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu0i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu0i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu0i(Test_BFu0i_BFu9s_BFu0i, "BFu0i_BFu9s_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu0ll  {
  unsigned int  :0;
  unsigned short v1:9;
  __tsu64  :0;
};
//SIG(1 BFu0i_BFu9s_BFu0ll) C1{ Fi:0 Fs:9 FL:0}



static void Test_BFu0i_BFu9s_BFu0ll()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu0ll");
    static BFu0i_BFu9s_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9s_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_BFu0ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu0ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu0ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu0ll(Test_BFu0i_BFu9s_BFu0ll, "BFu0i_BFu9s_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu0s  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned short  :0;
};
//SIG(1 BFu0i_BFu9s_BFu0s) C1{ Fi:0 Fs:9 Fs:0}



static void Test_BFu0i_BFu9s_BFu0s()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu0s");
    static BFu0i_BFu9s_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu9s_BFu0s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_BFu0s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu0s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu0s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu0s(Test_BFu0i_BFu9s_BFu0s, "BFu0i_BFu9s_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu15i  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned int v2:15;
};
//SIG(1 BFu0i_BFu9s_BFu15i) C1{ Fi:0 Fs:9 Fi:15}



static void Test_BFu0i_BFu9s_BFu15i()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu15i");
    static BFu0i_BFu9s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0i_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu9s_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu15i(Test_BFu0i_BFu9s_BFu15i, "BFu0i_BFu9s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu15ll  {
  unsigned int  :0;
  unsigned short v1:9;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_BFu9s_BFu15ll) C1{ Fi:0 Fs:9 FL:15}



static void Test_BFu0i_BFu9s_BFu15ll()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu15ll");
    static BFu0i_BFu9s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, 1, "BFu0i_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 1, 15, hide_ull(1LL<<14), "BFu0i_BFu9s_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu15ll(Test_BFu0i_BFu9s_BFu15ll, "BFu0i_BFu9s_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu15s  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned short v2:15;
};
//SIG(1 BFu0i_BFu9s_BFu15s) C1{ Fi:0 Fs:9 Fs:15}



static void Test_BFu0i_BFu9s_BFu15s()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu15s");
    static BFu0i_BFu9s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_BFu9s_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu15s(Test_BFu0i_BFu9s_BFu15s, "BFu0i_BFu9s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu16i  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned int v2:16;
};
//SIG(1 BFu0i_BFu9s_BFu16i) C1{ Fi:0 Fs:9 Fi:16}



static void Test_BFu0i_BFu9s_BFu16i()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu16i");
    static BFu0i_BFu9s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0i_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0i_BFu9s_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu16i(Test_BFu0i_BFu9s_BFu16i, "BFu0i_BFu9s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu16ll  {
  unsigned int  :0;
  unsigned short v1:9;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_BFu9s_BFu16ll) C1{ Fi:0 Fs:9 FL:16}



static void Test_BFu0i_BFu9s_BFu16ll()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu16ll");
    static BFu0i_BFu9s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, 1, "BFu0i_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 1, 16, hide_ull(1LL<<15), "BFu0i_BFu9s_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu16ll(Test_BFu0i_BFu9s_BFu16ll, "BFu0i_BFu9s_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu16s  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned short v2:16;
};
//SIG(1 BFu0i_BFu9s_BFu16s) C1{ Fi:0 Fs:9 Fs:16}



static void Test_BFu0i_BFu9s_BFu16s()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu16s");
    static BFu0i_BFu9s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_BFu9s_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu16s(Test_BFu0i_BFu9s_BFu16s, "BFu0i_BFu9s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu17i  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned int v2:17;
};
//SIG(1 BFu0i_BFu9s_BFu17i) C1{ Fi:0 Fs:9 Fi:17}



static void Test_BFu0i_BFu9s_BFu17i()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu17i");
    static BFu0i_BFu9s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0i_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0i_BFu9s_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu17i(Test_BFu0i_BFu9s_BFu17i, "BFu0i_BFu9s_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu17ll  {
  unsigned int  :0;
  unsigned short v1:9;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_BFu9s_BFu17ll) C1{ Fi:0 Fs:9 FL:17}



static void Test_BFu0i_BFu9s_BFu17ll()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu17ll");
    static BFu0i_BFu9s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, 1, "BFu0i_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 1, 17, hide_ull(1LL<<16), "BFu0i_BFu9s_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu17ll(Test_BFu0i_BFu9s_BFu17ll, "BFu0i_BFu9s_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu1c  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned char v2:1;
};
//SIG(1 BFu0i_BFu9s_BFu1c) C1{ Fi:0 Fs:9 Fc:1}



static void Test_BFu0i_BFu9s_BFu1c()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu1c");
    static BFu0i_BFu9s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu9s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0i_BFu9s_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu1c(Test_BFu0i_BFu9s_BFu1c, "BFu0i_BFu9s_BFu1c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu1i  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned int v2:1;
};
//SIG(1 BFu0i_BFu9s_BFu1i) C1{ Fi:0 Fs:9 Fi:1}



static void Test_BFu0i_BFu9s_BFu1i()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu1i");
    static BFu0i_BFu9s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0i_BFu9s_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu1i(Test_BFu0i_BFu9s_BFu1i, "BFu0i_BFu9s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu1ll  {
  unsigned int  :0;
  unsigned short v1:9;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_BFu9s_BFu1ll) C1{ Fi:0 Fs:9 FL:1}



static void Test_BFu0i_BFu9s_BFu1ll()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu1ll");
    static BFu0i_BFu9s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0i_BFu9s_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu1ll(Test_BFu0i_BFu9s_BFu1ll, "BFu0i_BFu9s_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu1s  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned short v2:1;
};
//SIG(1 BFu0i_BFu9s_BFu1s) C1{ Fi:0 Fs:9 Fs:1}



static void Test_BFu0i_BFu9s_BFu1s()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu1s");
    static BFu0i_BFu9s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu9s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 1, 1, 1, 1, "BFu0i_BFu9s_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu1s(Test_BFu0i_BFu9s_BFu1s, "BFu0i_BFu9s_BFu1s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu31i  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned int v2:31;
};
//SIG(1 BFu0i_BFu9s_BFu31i) C1{ Fi:0 Fs:9 Fi:31}



static void Test_BFu0i_BFu9s_BFu31i()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu31i");
    static BFu0i_BFu9s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_BFu9s_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu31i(Test_BFu0i_BFu9s_BFu31i, "BFu0i_BFu9s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu31ll  {
  unsigned int  :0;
  unsigned short v1:9;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_BFu9s_BFu31ll) C1{ Fi:0 Fs:9 FL:31}



static void Test_BFu0i_BFu9s_BFu31ll()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu31ll");
    static BFu0i_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, 1, "BFu0i_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 1, 31, hide_ull(1LL<<30), "BFu0i_BFu9s_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu31ll(Test_BFu0i_BFu9s_BFu31ll, "BFu0i_BFu9s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu32i  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned int v2:32;
};
//SIG(1 BFu0i_BFu9s_BFu32i) C1{ Fi:0 Fs:9 Fi:32}



static void Test_BFu0i_BFu9s_BFu32i()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu32i");
    static BFu0i_BFu9s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_BFu9s_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu32i(Test_BFu0i_BFu9s_BFu32i, "BFu0i_BFu9s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu32ll  {
  unsigned int  :0;
  unsigned short v1:9;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_BFu9s_BFu32ll) C1{ Fi:0 Fs:9 FL:32}



static void Test_BFu0i_BFu9s_BFu32ll()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu32ll");
    static BFu0i_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, 1, "BFu0i_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 1, 32, hide_ull(1LL<<31), "BFu0i_BFu9s_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu32ll(Test_BFu0i_BFu9s_BFu32ll, "BFu0i_BFu9s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu33  {
  unsigned int  :0;
  unsigned short v1:9;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_BFu9s_BFu33) C1{ Fi:0 Fs:9 FL:33}



static void Test_BFu0i_BFu9s_BFu33()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu33");
    static BFu0i_BFu9s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, 1, "BFu0i_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 1, 1, 33, hide_ull(1LL<<32), "BFu0i_BFu9s_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu33(Test_BFu0i_BFu9s_BFu33, "BFu0i_BFu9s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu7c  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned char v2:7;
};
//SIG(1 BFu0i_BFu9s_BFu7c) C1{ Fi:0 Fs:9 Fc:7}



static void Test_BFu0i_BFu9s_BFu7c()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu7c");
    static BFu0i_BFu9s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu9s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0i_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu9s_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu7c(Test_BFu0i_BFu9s_BFu7c, "BFu0i_BFu9s_BFu7c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu7i  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned int v2:7;
};
//SIG(1 BFu0i_BFu9s_BFu7i) C1{ Fi:0 Fs:9 Fi:7}



static void Test_BFu0i_BFu9s_BFu7i()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu7i");
    static BFu0i_BFu9s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0i_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu9s_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu7i(Test_BFu0i_BFu9s_BFu7i, "BFu0i_BFu9s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu7ll  {
  unsigned int  :0;
  unsigned short v1:9;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_BFu9s_BFu7ll) C1{ Fi:0 Fs:9 FL:7}



static void Test_BFu0i_BFu9s_BFu7ll()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu7ll");
    static BFu0i_BFu9s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0i_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu9s_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu7ll(Test_BFu0i_BFu9s_BFu7ll, "BFu0i_BFu9s_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu7s  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned short v2:7;
};
//SIG(1 BFu0i_BFu9s_BFu7s) C1{ Fi:0 Fs:9 Fs:7}



static void Test_BFu0i_BFu9s_BFu7s()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu7s");
    static BFu0i_BFu9s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_BFu9s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, 1, "BFu0i_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 1, 1, 7, hide_ull(1LL<<6), "BFu0i_BFu9s_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu7s(Test_BFu0i_BFu9s_BFu7s, "BFu0i_BFu9s_BFu7s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu8c  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned char v2:8;
};
//SIG(1 BFu0i_BFu9s_BFu8c) C1{ Fi:0 Fs:9 Fc:8}



static void Test_BFu0i_BFu9s_BFu8c()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu8c");
    static BFu0i_BFu9s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0i_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu9s_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu8c(Test_BFu0i_BFu9s_BFu8c, "BFu0i_BFu9s_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu8i  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned int v2:8;
};
//SIG(1 BFu0i_BFu9s_BFu8i) C1{ Fi:0 Fs:9 Fi:8}



static void Test_BFu0i_BFu9s_BFu8i()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu8i");
    static BFu0i_BFu9s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0i_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu9s_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu8i(Test_BFu0i_BFu9s_BFu8i, "BFu0i_BFu9s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu8ll  {
  unsigned int  :0;
  unsigned short v1:9;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_BFu9s_BFu8ll) C1{ Fi:0 Fs:9 FL:8}



static void Test_BFu0i_BFu9s_BFu8ll()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu8ll");
    static BFu0i_BFu9s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, 1, "BFu0i_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 1, 8, hide_ull(1LL<<7), "BFu0i_BFu9s_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu8ll(Test_BFu0i_BFu9s_BFu8ll, "BFu0i_BFu9s_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu8s  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned short v2:8;
};
//SIG(1 BFu0i_BFu9s_BFu8s) C1{ Fi:0 Fs:9 Fs:8}



static void Test_BFu0i_BFu9s_BFu8s()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu8s");
    static BFu0i_BFu9s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0i_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0i_BFu9s_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu8s(Test_BFu0i_BFu9s_BFu8s, "BFu0i_BFu9s_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu9i  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned int v2:9;
};
//SIG(1 BFu0i_BFu9s_BFu9i) C1{ Fi:0 Fs:9 Fi:9}



static void Test_BFu0i_BFu9s_BFu9i()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu9i");
    static BFu0i_BFu9s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0i_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu9i(Test_BFu0i_BFu9s_BFu9i, "BFu0i_BFu9s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu9ll  {
  unsigned int  :0;
  unsigned short v1:9;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_BFu9s_BFu9ll) C1{ Fi:0 Fs:9 FL:9}



static void Test_BFu0i_BFu9s_BFu9ll()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu9ll");
    static BFu0i_BFu9s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, 1, "BFu0i_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 1, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu9ll(Test_BFu0i_BFu9s_BFu9ll, "BFu0i_BFu9s_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_BFu9s  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned short v2:9;
};
//SIG(1 BFu0i_BFu9s_BFu9s) C1{ Fi:0 Fs:9 Fs:9}



static void Test_BFu0i_BFu9s_BFu9s()
{
  {
    init_simple_test("BFu0i_BFu9s_BFu9s");
    static BFu0i_BFu9s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0i_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_BFu9s(Test_BFu0i_BFu9s_BFu9s, "BFu0i_BFu9s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_C  {
  unsigned int  :0;
  unsigned short v1:9;
  char v2;
};
//SIG(1 BFu0i_BFu9s_C) C1{ Fi:0 Fs:9 Fc}



static void Test_BFu0i_BFu9s_C()
{
  {
    init_simple_test("BFu0i_BFu9s_C");
    static BFu0i_BFu9s_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_C)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_C)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_C");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_C");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9s_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_C(Test_BFu0i_BFu9s_C, "BFu0i_BFu9s_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_D  {
  unsigned int  :0;
  unsigned short v1:9;
  double v2;
};
//SIG(1 BFu0i_BFu9s_D) C1{ Fi:0 Fs:9 FL}



static void Test_BFu0i_BFu9s_D()
{
  {
    init_simple_test("BFu0i_BFu9s_D");
    static BFu0i_BFu9s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu9s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_D)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_D");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_D");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9s_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_D(Test_BFu0i_BFu9s_D, "BFu0i_BFu9s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_F  {
  unsigned int  :0;
  unsigned short v1:9;
  float v2;
};
//SIG(1 BFu0i_BFu9s_F) C1{ Fi:0 Fs:9 Fi}



static void Test_BFu0i_BFu9s_F()
{
  {
    init_simple_test("BFu0i_BFu9s_F");
    static BFu0i_BFu9s_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9s_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9s_F)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_F");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_F");
    check_field_offset(lv, v2, 4, "BFu0i_BFu9s_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_F(Test_BFu0i_BFu9s_F, "BFu0i_BFu9s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_I  {
  unsigned int  :0;
  unsigned short v1:9;
  int v2;
};
//SIG(1 BFu0i_BFu9s_I) C1{ Fi:0 Fs:9 Fi}



static void Test_BFu0i_BFu9s_I()
{
  {
    init_simple_test("BFu0i_BFu9s_I");
    static BFu0i_BFu9s_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9s_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9s_I)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_I");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_I");
    check_field_offset(lv, v2, 4, "BFu0i_BFu9s_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_I(Test_BFu0i_BFu9s_I, "BFu0i_BFu9s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_Ip  {
  unsigned int  :0;
  unsigned short v1:9;
  int *v2;
};
//SIG(1 BFu0i_BFu9s_Ip) C1{ Fi:0 Fs:9 Fp}



static void Test_BFu0i_BFu9s_Ip()
{
  {
    init_simple_test("BFu0i_BFu9s_Ip");
    static BFu0i_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu9s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_Ip");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9s_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_Ip(Test_BFu0i_BFu9s_Ip, "BFu0i_BFu9s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_L  {
  unsigned int  :0;
  unsigned short v1:9;
  __tsi64 v2;
};
//SIG(1 BFu0i_BFu9s_L) C1{ Fi:0 Fs:9 FL}



static void Test_BFu0i_BFu9s_L()
{
  {
    init_simple_test("BFu0i_BFu9s_L");
    static BFu0i_BFu9s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu9s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_L)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_L");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_L");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9s_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_L(Test_BFu0i_BFu9s_L, "BFu0i_BFu9s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_S  {
  unsigned int  :0;
  unsigned short v1:9;
  short v2;
};
//SIG(1 BFu0i_BFu9s_S) C1{ Fi:0 Fs:9 Fs}



static void Test_BFu0i_BFu9s_S()
{
  {
    init_simple_test("BFu0i_BFu9s_S");
    static BFu0i_BFu9s_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_S)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_S");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_S");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9s_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_S(Test_BFu0i_BFu9s_S, "BFu0i_BFu9s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_Uc  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned char v2;
};
//SIG(1 BFu0i_BFu9s_Uc) C1{ Fi:0 Fs:9 Fc}



static void Test_BFu0i_BFu9s_Uc()
{
  {
    init_simple_test("BFu0i_BFu9s_Uc");
    static BFu0i_BFu9s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_Uc)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_Uc");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9s_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_Uc(Test_BFu0i_BFu9s_Uc, "BFu0i_BFu9s_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_Ui  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned int v2;
};
//SIG(1 BFu0i_BFu9s_Ui) C1{ Fi:0 Fs:9 Fi}



static void Test_BFu0i_BFu9s_Ui()
{
  {
    init_simple_test("BFu0i_BFu9s_Ui");
    static BFu0i_BFu9s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_BFu9s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_BFu9s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_Ui");
    check_field_offset(lv, v2, 4, "BFu0i_BFu9s_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_Ui(Test_BFu0i_BFu9s_Ui, "BFu0i_BFu9s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_Ul  {
  unsigned int  :0;
  unsigned short v1:9;
  __tsu64 v2;
};
//SIG(1 BFu0i_BFu9s_Ul) C1{ Fi:0 Fs:9 FL}



static void Test_BFu0i_BFu9s_Ul()
{
  {
    init_simple_test("BFu0i_BFu9s_Ul");
    static BFu0i_BFu9s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_BFu9s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_Ul");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9s_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_Ul(Test_BFu0i_BFu9s_Ul, "BFu0i_BFu9s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_Us  {
  unsigned int  :0;
  unsigned short v1:9;
  unsigned short v2;
};
//SIG(1 BFu0i_BFu9s_Us) C1{ Fi:0 Fs:9 Fs}



static void Test_BFu0i_BFu9s_Us()
{
  {
    init_simple_test("BFu0i_BFu9s_Us");
    static BFu0i_BFu9s_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_BFu9s_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_BFu9s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_Us");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_Us");
    check_field_offset(lv, v2, 2, "BFu0i_BFu9s_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_Us(Test_BFu0i_BFu9s_Us, "BFu0i_BFu9s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_BFu9s_Vp  {
  unsigned int  :0;
  unsigned short v1:9;
  void *v2;
};
//SIG(1 BFu0i_BFu9s_Vp) C1{ Fi:0 Fs:9 Fp}



static void Test_BFu0i_BFu9s_Vp()
{
  {
    init_simple_test("BFu0i_BFu9s_Vp");
    static BFu0i_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_BFu9s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_BFu9s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 9, 1, "BFu0i_BFu9s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 9, hide_ull(1LL<<8), "BFu0i_BFu9s_Vp");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_BFu9s_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_BFu9s_Vp(Test_BFu0i_BFu9s_Vp, "BFu0i_BFu9s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C  {
  unsigned int  :0;
  char v1;
};
//SIG(1 BFu0i_C) C1{ Fi:0 Fc}



static void Test_BFu0i_C()
{
  {
    init_simple_test("BFu0i_C");
    static BFu0i_C lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_C)");
    check_field_offset(lv, v1, 0, "BFu0i_C.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_C(Test_BFu0i_C, "BFu0i_C", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu0c  {
  unsigned int  :0;
  char v1;
  unsigned char  :0;
};
//SIG(1 BFu0i_C_BFu0c) C1{ Fi:0 Fc Fc:0}



static void Test_BFu0i_C_BFu0c()
{
  {
    init_simple_test("BFu0i_C_BFu0c");
    static BFu0i_C_BFu0c lv;
    check2(sizeof(lv), ABISELECT(1,1), "sizeof(BFu0i_C_BFu0c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_C_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu0c(Test_BFu0i_C_BFu0c, "BFu0i_C_BFu0c", ABISELECT(1,1));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu0i  {
  unsigned int  :0;
  char v1;
  unsigned int  :0;
};
//SIG(1 BFu0i_C_BFu0i) C1{ Fi:0 Fc Fi:0}



static void Test_BFu0i_C_BFu0i()
{
  {
    init_simple_test("BFu0i_C_BFu0i");
    static BFu0i_C_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_C_BFu0i)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_C_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu0i(Test_BFu0i_C_BFu0i, "BFu0i_C_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu0ll  {
  unsigned int  :0;
  char v1;
  __tsu64  :0;
};
//SIG(1 BFu0i_C_BFu0ll) C1{ Fi:0 Fc FL:0}



static void Test_BFu0i_C_BFu0ll()
{
  {
    init_simple_test("BFu0i_C_BFu0ll");
    static BFu0i_C_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_C_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_C_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu0ll(Test_BFu0i_C_BFu0ll, "BFu0i_C_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu0s  {
  unsigned int  :0;
  char v1;
  unsigned short  :0;
};
//SIG(1 BFu0i_C_BFu0s) C1{ Fi:0 Fc Fs:0}



static void Test_BFu0i_C_BFu0s()
{
  {
    init_simple_test("BFu0i_C_BFu0s");
    static BFu0i_C_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_C_BFu0s)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_C_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu0s(Test_BFu0i_C_BFu0s, "BFu0i_C_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu15i  {
  unsigned int  :0;
  char v1;
  unsigned int v2:15;
};
//SIG(1 BFu0i_C_BFu15i) C1{ Fi:0 Fc Fi:15}



static void Test_BFu0i_C_BFu15i()
{
  {
    init_simple_test("BFu0i_C_BFu15i");
    static BFu0i_C_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_C_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_C_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0i_C_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0i_C_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu15i(Test_BFu0i_C_BFu15i, "BFu0i_C_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu15ll  {
  unsigned int  :0;
  char v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_C_BFu15ll) C1{ Fi:0 Fc FL:15}



static void Test_BFu0i_C_BFu15ll()
{
  {
    init_simple_test("BFu0i_C_BFu15ll");
    static BFu0i_C_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_C_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "BFu0i_C_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "BFu0i_C_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu15ll(Test_BFu0i_C_BFu15ll, "BFu0i_C_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu15s  {
  unsigned int  :0;
  char v1;
  unsigned short v2:15;
};
//SIG(1 BFu0i_C_BFu15s) C1{ Fi:0 Fc Fs:15}



static void Test_BFu0i_C_BFu15s()
{
  {
    init_simple_test("BFu0i_C_BFu15s");
    static BFu0i_C_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_C_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_C_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_C_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_C_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu15s(Test_BFu0i_C_BFu15s, "BFu0i_C_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu16i  {
  unsigned int  :0;
  char v1;
  unsigned int v2:16;
};
//SIG(1 BFu0i_C_BFu16i) C1{ Fi:0 Fc Fi:16}



static void Test_BFu0i_C_BFu16i()
{
  {
    init_simple_test("BFu0i_C_BFu16i");
    static BFu0i_C_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_C_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_C_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0i_C_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0i_C_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu16i(Test_BFu0i_C_BFu16i, "BFu0i_C_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu16ll  {
  unsigned int  :0;
  char v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_C_BFu16ll) C1{ Fi:0 Fc FL:16}



static void Test_BFu0i_C_BFu16ll()
{
  {
    init_simple_test("BFu0i_C_BFu16ll");
    static BFu0i_C_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_C_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "BFu0i_C_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "BFu0i_C_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu16ll(Test_BFu0i_C_BFu16ll, "BFu0i_C_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu16s  {
  unsigned int  :0;
  char v1;
  unsigned short v2:16;
};
//SIG(1 BFu0i_C_BFu16s) C1{ Fi:0 Fc Fs:16}



static void Test_BFu0i_C_BFu16s()
{
  {
    init_simple_test("BFu0i_C_BFu16s");
    static BFu0i_C_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_C_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_C_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_C_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_C_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu16s(Test_BFu0i_C_BFu16s, "BFu0i_C_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu17i  {
  unsigned int  :0;
  char v1;
  unsigned int v2:17;
};
//SIG(1 BFu0i_C_BFu17i) C1{ Fi:0 Fc Fi:17}



static void Test_BFu0i_C_BFu17i()
{
  {
    init_simple_test("BFu0i_C_BFu17i");
    static BFu0i_C_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_C_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_C_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0i_C_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0i_C_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu17i(Test_BFu0i_C_BFu17i, "BFu0i_C_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu17ll  {
  unsigned int  :0;
  char v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_C_BFu17ll) C1{ Fi:0 Fc FL:17}



static void Test_BFu0i_C_BFu17ll()
{
  {
    init_simple_test("BFu0i_C_BFu17ll");
    static BFu0i_C_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_C_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "BFu0i_C_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "BFu0i_C_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu17ll(Test_BFu0i_C_BFu17ll, "BFu0i_C_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu1c  {
  unsigned int  :0;
  char v1;
  unsigned char v2:1;
};
//SIG(1 BFu0i_C_BFu1c) C1{ Fi:0 Fc Fc:1}



static void Test_BFu0i_C_BFu1c()
{
  {
    init_simple_test("BFu0i_C_BFu1c");
    static BFu0i_C_BFu1c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_C_BFu1c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_C_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_C_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu1c(Test_BFu0i_C_BFu1c, "BFu0i_C_BFu1c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu1i  {
  unsigned int  :0;
  char v1;
  unsigned int v2:1;
};
//SIG(1 BFu0i_C_BFu1i) C1{ Fi:0 Fc Fi:1}



static void Test_BFu0i_C_BFu1i()
{
  {
    init_simple_test("BFu0i_C_BFu1i");
    static BFu0i_C_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_C_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_C_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_C_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu1i(Test_BFu0i_C_BFu1i, "BFu0i_C_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu1ll  {
  unsigned int  :0;
  char v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_C_BFu1ll) C1{ Fi:0 Fc FL:1}



static void Test_BFu0i_C_BFu1ll()
{
  {
    init_simple_test("BFu0i_C_BFu1ll");
    static BFu0i_C_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_C_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_C_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu1ll(Test_BFu0i_C_BFu1ll, "BFu0i_C_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu1s  {
  unsigned int  :0;
  char v1;
  unsigned short v2:1;
};
//SIG(1 BFu0i_C_BFu1s) C1{ Fi:0 Fc Fs:1}



static void Test_BFu0i_C_BFu1s()
{
  {
    init_simple_test("BFu0i_C_BFu1s");
    static BFu0i_C_BFu1s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_C_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_C_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "BFu0i_C_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu1s(Test_BFu0i_C_BFu1s, "BFu0i_C_BFu1s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu31i  {
  unsigned int  :0;
  char v1;
  unsigned int v2:31;
};
//SIG(1 BFu0i_C_BFu31i) C1{ Fi:0 Fc Fi:31}



static void Test_BFu0i_C_BFu31i()
{
  {
    init_simple_test("BFu0i_C_BFu31i");
    static BFu0i_C_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_C_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_C_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_C_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_C_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu31i(Test_BFu0i_C_BFu31i, "BFu0i_C_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu31ll  {
  unsigned int  :0;
  char v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_C_BFu31ll) C1{ Fi:0 Fc FL:31}



static void Test_BFu0i_C_BFu31ll()
{
  {
    init_simple_test("BFu0i_C_BFu31ll");
    static BFu0i_C_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_C_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "BFu0i_C_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "BFu0i_C_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu31ll(Test_BFu0i_C_BFu31ll, "BFu0i_C_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu32i  {
  unsigned int  :0;
  char v1;
  unsigned int v2:32;
};
//SIG(1 BFu0i_C_BFu32i) C1{ Fi:0 Fc Fi:32}



static void Test_BFu0i_C_BFu32i()
{
  {
    init_simple_test("BFu0i_C_BFu32i");
    static BFu0i_C_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_C_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_C_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_C_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_C_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu32i(Test_BFu0i_C_BFu32i, "BFu0i_C_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu32ll  {
  unsigned int  :0;
  char v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_C_BFu32ll) C1{ Fi:0 Fc FL:32}



static void Test_BFu0i_C_BFu32ll()
{
  {
    init_simple_test("BFu0i_C_BFu32ll");
    static BFu0i_C_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_C_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "BFu0i_C_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "BFu0i_C_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu32ll(Test_BFu0i_C_BFu32ll, "BFu0i_C_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu33  {
  unsigned int  :0;
  char v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_C_BFu33) C1{ Fi:0 Fc FL:33}



static void Test_BFu0i_C_BFu33()
{
  {
    init_simple_test("BFu0i_C_BFu33");
    static BFu0i_C_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_C_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "BFu0i_C_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "BFu0i_C_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu33(Test_BFu0i_C_BFu33, "BFu0i_C_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu7c  {
  unsigned int  :0;
  char v1;
  unsigned char v2:7;
};
//SIG(1 BFu0i_C_BFu7c) C1{ Fi:0 Fc Fc:7}



static void Test_BFu0i_C_BFu7c()
{
  {
    init_simple_test("BFu0i_C_BFu7c");
    static BFu0i_C_BFu7c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_C_BFu7c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_C_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_C_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_C_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu7c(Test_BFu0i_C_BFu7c, "BFu0i_C_BFu7c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu7i  {
  unsigned int  :0;
  char v1;
  unsigned int v2:7;
};
//SIG(1 BFu0i_C_BFu7i) C1{ Fi:0 Fc Fi:7}



static void Test_BFu0i_C_BFu7i()
{
  {
    init_simple_test("BFu0i_C_BFu7i");
    static BFu0i_C_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_C_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_C_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_C_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_C_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu7i(Test_BFu0i_C_BFu7i, "BFu0i_C_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu7ll  {
  unsigned int  :0;
  char v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_C_BFu7ll) C1{ Fi:0 Fc FL:7}



static void Test_BFu0i_C_BFu7ll()
{
  {
    init_simple_test("BFu0i_C_BFu7ll");
    static BFu0i_C_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_C_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_C_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_C_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu7ll(Test_BFu0i_C_BFu7ll, "BFu0i_C_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu7s  {
  unsigned int  :0;
  char v1;
  unsigned short v2:7;
};
//SIG(1 BFu0i_C_BFu7s) C1{ Fi:0 Fc Fs:7}



static void Test_BFu0i_C_BFu7s()
{
  {
    init_simple_test("BFu0i_C_BFu7s");
    static BFu0i_C_BFu7s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_C_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_C_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "BFu0i_C_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "BFu0i_C_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu7s(Test_BFu0i_C_BFu7s, "BFu0i_C_BFu7s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu8c  {
  unsigned int  :0;
  char v1;
  unsigned char v2:8;
};
//SIG(1 BFu0i_C_BFu8c) C1{ Fi:0 Fc Fc:8}



static void Test_BFu0i_C_BFu8c()
{
  {
    init_simple_test("BFu0i_C_BFu8c");
    static BFu0i_C_BFu8c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_C_BFu8c)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_C_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_C_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_C_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu8c(Test_BFu0i_C_BFu8c, "BFu0i_C_BFu8c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu8i  {
  unsigned int  :0;
  char v1;
  unsigned int v2:8;
};
//SIG(1 BFu0i_C_BFu8i) C1{ Fi:0 Fc Fi:8}



static void Test_BFu0i_C_BFu8i()
{
  {
    init_simple_test("BFu0i_C_BFu8i");
    static BFu0i_C_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_C_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_C_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_C_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_C_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu8i(Test_BFu0i_C_BFu8i, "BFu0i_C_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu8ll  {
  unsigned int  :0;
  char v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_C_BFu8ll) C1{ Fi:0 Fc FL:8}



static void Test_BFu0i_C_BFu8ll()
{
  {
    init_simple_test("BFu0i_C_BFu8ll");
    static BFu0i_C_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_C_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_C_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_C_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu8ll(Test_BFu0i_C_BFu8ll, "BFu0i_C_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu8s  {
  unsigned int  :0;
  char v1;
  unsigned short v2:8;
};
//SIG(1 BFu0i_C_BFu8s) C1{ Fi:0 Fc Fs:8}



static void Test_BFu0i_C_BFu8s()
{
  {
    init_simple_test("BFu0i_C_BFu8s");
    static BFu0i_C_BFu8s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_C_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_C_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu0i_C_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu0i_C_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu8s(Test_BFu0i_C_BFu8s, "BFu0i_C_BFu8s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu9i  {
  unsigned int  :0;
  char v1;
  unsigned int v2:9;
};
//SIG(1 BFu0i_C_BFu9i) C1{ Fi:0 Fc Fi:9}



static void Test_BFu0i_C_BFu9i()
{
  {
    init_simple_test("BFu0i_C_BFu9i");
    static BFu0i_C_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_C_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_C_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0i_C_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0i_C_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu9i(Test_BFu0i_C_BFu9i, "BFu0i_C_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu9ll  {
  unsigned int  :0;
  char v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_C_BFu9ll) C1{ Fi:0 Fc FL:9}



static void Test_BFu0i_C_BFu9ll()
{
  {
    init_simple_test("BFu0i_C_BFu9ll");
    static BFu0i_C_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_C_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "BFu0i_C_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "BFu0i_C_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu9ll(Test_BFu0i_C_BFu9ll, "BFu0i_C_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_BFu9s  {
  unsigned int  :0;
  char v1;
  unsigned short v2:9;
};
//SIG(1 BFu0i_C_BFu9s) C1{ Fi:0 Fc Fs:9}



static void Test_BFu0i_C_BFu9s()
{
  {
    init_simple_test("BFu0i_C_BFu9s");
    static BFu0i_C_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_C_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_C_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0i_C_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0i_C_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0i_C_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_C_BFu9s(Test_BFu0i_C_BFu9s, "BFu0i_C_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_C  {
  unsigned int  :0;
  char v1;
  char v2;
};
//SIG(1 BFu0i_C_C) C1{ Fi:0 Fc[2]}



static void Test_BFu0i_C_C()
{
  {
    init_simple_test("BFu0i_C_C");
    static BFu0i_C_C lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_C_C)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_C_C)");
    check_field_offset(lv, v1, 0, "BFu0i_C_C.v1");
    check_field_offset(lv, v2, 1, "BFu0i_C_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_C_C(Test_BFu0i_C_C, "BFu0i_C_C", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_D  {
  unsigned int  :0;
  char v1;
  double v2;
};
//SIG(1 BFu0i_C_D) C1{ Fi:0 Fc FL}



static void Test_BFu0i_C_D()
{
  {
    init_simple_test("BFu0i_C_D");
    static BFu0i_C_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_C_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_D)");
    check_field_offset(lv, v1, 0, "BFu0i_C_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_C_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_C_D(Test_BFu0i_C_D, "BFu0i_C_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_F  {
  unsigned int  :0;
  char v1;
  float v2;
};
//SIG(1 BFu0i_C_F) C1{ Fi:0 Fc Fi}



static void Test_BFu0i_C_F()
{
  {
    init_simple_test("BFu0i_C_F");
    static BFu0i_C_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_C_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_C_F)");
    check_field_offset(lv, v1, 0, "BFu0i_C_F.v1");
    check_field_offset(lv, v2, 4, "BFu0i_C_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_C_F(Test_BFu0i_C_F, "BFu0i_C_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_I  {
  unsigned int  :0;
  char v1;
  int v2;
};
//SIG(1 BFu0i_C_I) C1{ Fi:0 Fc Fi}



static void Test_BFu0i_C_I()
{
  {
    init_simple_test("BFu0i_C_I");
    static BFu0i_C_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_C_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_C_I)");
    check_field_offset(lv, v1, 0, "BFu0i_C_I.v1");
    check_field_offset(lv, v2, 4, "BFu0i_C_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_C_I(Test_BFu0i_C_I, "BFu0i_C_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_Ip  {
  unsigned int  :0;
  char v1;
  int *v2;
};
//SIG(1 BFu0i_C_Ip) C1{ Fi:0 Fc Fp}



static void Test_BFu0i_C_Ip()
{
  {
    init_simple_test("BFu0i_C_Ip");
    static BFu0i_C_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_C_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_Ip)");
    check_field_offset(lv, v1, 0, "BFu0i_C_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_C_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_C_Ip(Test_BFu0i_C_Ip, "BFu0i_C_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_L  {
  unsigned int  :0;
  char v1;
  __tsi64 v2;
};
//SIG(1 BFu0i_C_L) C1{ Fi:0 Fc FL}



static void Test_BFu0i_C_L()
{
  {
    init_simple_test("BFu0i_C_L");
    static BFu0i_C_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_C_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_L)");
    check_field_offset(lv, v1, 0, "BFu0i_C_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_C_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_C_L(Test_BFu0i_C_L, "BFu0i_C_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_S  {
  unsigned int  :0;
  char v1;
  short v2;
};
//SIG(1 BFu0i_C_S) C1{ Fi:0 Fc Fs}



static void Test_BFu0i_C_S()
{
  {
    init_simple_test("BFu0i_C_S");
    static BFu0i_C_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_C_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_C_S)");
    check_field_offset(lv, v1, 0, "BFu0i_C_S.v1");
    check_field_offset(lv, v2, 2, "BFu0i_C_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_C_S(Test_BFu0i_C_S, "BFu0i_C_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_Uc  {
  unsigned int  :0;
  char v1;
  unsigned char v2;
};
//SIG(1 BFu0i_C_Uc) C1{ Fi:0 Fc[2]}



static void Test_BFu0i_C_Uc()
{
  {
    init_simple_test("BFu0i_C_Uc");
    static BFu0i_C_Uc lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_C_Uc)");
    check2(__alignof__(lv), ABISELECT(1,1), "__alignof__(BFu0i_C_Uc)");
    check_field_offset(lv, v1, 0, "BFu0i_C_Uc.v1");
    check_field_offset(lv, v2, 1, "BFu0i_C_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_C_Uc(Test_BFu0i_C_Uc, "BFu0i_C_Uc", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_Ui  {
  unsigned int  :0;
  char v1;
  unsigned int v2;
};
//SIG(1 BFu0i_C_Ui) C1{ Fi:0 Fc Fi}



static void Test_BFu0i_C_Ui()
{
  {
    init_simple_test("BFu0i_C_Ui");
    static BFu0i_C_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_C_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_C_Ui)");
    check_field_offset(lv, v1, 0, "BFu0i_C_Ui.v1");
    check_field_offset(lv, v2, 4, "BFu0i_C_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_C_Ui(Test_BFu0i_C_Ui, "BFu0i_C_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_Ul  {
  unsigned int  :0;
  char v1;
  __tsu64 v2;
};
//SIG(1 BFu0i_C_Ul) C1{ Fi:0 Fc FL}



static void Test_BFu0i_C_Ul()
{
  {
    init_simple_test("BFu0i_C_Ul");
    static BFu0i_C_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_C_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_Ul)");
    check_field_offset(lv, v1, 0, "BFu0i_C_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_C_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_C_Ul(Test_BFu0i_C_Ul, "BFu0i_C_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_Us  {
  unsigned int  :0;
  char v1;
  unsigned short v2;
};
//SIG(1 BFu0i_C_Us) C1{ Fi:0 Fc Fs}



static void Test_BFu0i_C_Us()
{
  {
    init_simple_test("BFu0i_C_Us");
    static BFu0i_C_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_C_Us)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_C_Us)");
    check_field_offset(lv, v1, 0, "BFu0i_C_Us.v1");
    check_field_offset(lv, v2, 2, "BFu0i_C_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_C_Us(Test_BFu0i_C_Us, "BFu0i_C_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_C_Vp  {
  unsigned int  :0;
  char v1;
  void *v2;
};
//SIG(1 BFu0i_C_Vp) C1{ Fi:0 Fc Fp}



static void Test_BFu0i_C_Vp()
{
  {
    init_simple_test("BFu0i_C_Vp");
    static BFu0i_C_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_C_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_C_Vp)");
    check_field_offset(lv, v1, 0, "BFu0i_C_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_C_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_C_Vp(Test_BFu0i_C_Vp, "BFu0i_C_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D  {
  unsigned int  :0;
  double v1;
};
//SIG(1 BFu0i_D) C1{ Fi:0 FL}



static void Test_BFu0i_D()
{
  {
    init_simple_test("BFu0i_D");
    static BFu0i_D lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D)");
    check_field_offset(lv, v1, 0, "BFu0i_D.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_D(Test_BFu0i_D, "BFu0i_D", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu0c  {
  unsigned int  :0;
  double v1;
  unsigned char  :0;
};
//SIG(1 BFu0i_D_BFu0c) C1{ Fi:0 FL Fc:0}



static void Test_BFu0i_D_BFu0c()
{
  {
    init_simple_test("BFu0i_D_BFu0c");
    static BFu0i_D_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_D_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu0c(Test_BFu0i_D_BFu0c, "BFu0i_D_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu0i  {
  unsigned int  :0;
  double v1;
  unsigned int  :0;
};
//SIG(1 BFu0i_D_BFu0i) C1{ Fi:0 FL Fi:0}



static void Test_BFu0i_D_BFu0i()
{
  {
    init_simple_test("BFu0i_D_BFu0i");
    static BFu0i_D_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_D_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu0i(Test_BFu0i_D_BFu0i, "BFu0i_D_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu0ll  {
  unsigned int  :0;
  double v1;
  __tsu64  :0;
};
//SIG(1 BFu0i_D_BFu0ll) C1{ Fi:0 FL FL:0}



static void Test_BFu0i_D_BFu0ll()
{
  {
    init_simple_test("BFu0i_D_BFu0ll");
    static BFu0i_D_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_D_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu0ll(Test_BFu0i_D_BFu0ll, "BFu0i_D_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu0s  {
  unsigned int  :0;
  double v1;
  unsigned short  :0;
};
//SIG(1 BFu0i_D_BFu0s) C1{ Fi:0 FL Fs:0}



static void Test_BFu0i_D_BFu0s()
{
  {
    init_simple_test("BFu0i_D_BFu0s");
    static BFu0i_D_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_D_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu0s(Test_BFu0i_D_BFu0s, "BFu0i_D_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu15i  {
  unsigned int  :0;
  double v1;
  unsigned int v2:15;
};
//SIG(1 BFu0i_D_BFu15i) C1{ Fi:0 FL Fi:15}



static void Test_BFu0i_D_BFu15i()
{
  {
    init_simple_test("BFu0i_D_BFu15i");
    static BFu0i_D_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0i_D_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0i_D_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu15i(Test_BFu0i_D_BFu15i, "BFu0i_D_BFu15i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu15ll  {
  unsigned int  :0;
  double v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_D_BFu15ll) C1{ Fi:0 FL FL:15}



static void Test_BFu0i_D_BFu15ll()
{
  {
    init_simple_test("BFu0i_D_BFu15ll");
    static BFu0i_D_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0i_D_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0i_D_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu15ll(Test_BFu0i_D_BFu15ll, "BFu0i_D_BFu15ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu15s  {
  unsigned int  :0;
  double v1;
  unsigned short v2:15;
};
//SIG(1 BFu0i_D_BFu15s) C1{ Fi:0 FL Fs:15}



static void Test_BFu0i_D_BFu15s()
{
  {
    init_simple_test("BFu0i_D_BFu15s");
    static BFu0i_D_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0i_D_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0i_D_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu15s(Test_BFu0i_D_BFu15s, "BFu0i_D_BFu15s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu16i  {
  unsigned int  :0;
  double v1;
  unsigned int v2:16;
};
//SIG(1 BFu0i_D_BFu16i) C1{ Fi:0 FL Fi:16}



static void Test_BFu0i_D_BFu16i()
{
  {
    init_simple_test("BFu0i_D_BFu16i");
    static BFu0i_D_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0i_D_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0i_D_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu16i(Test_BFu0i_D_BFu16i, "BFu0i_D_BFu16i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu16ll  {
  unsigned int  :0;
  double v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_D_BFu16ll) C1{ Fi:0 FL FL:16}



static void Test_BFu0i_D_BFu16ll()
{
  {
    init_simple_test("BFu0i_D_BFu16ll");
    static BFu0i_D_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0i_D_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0i_D_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu16ll(Test_BFu0i_D_BFu16ll, "BFu0i_D_BFu16ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu16s  {
  unsigned int  :0;
  double v1;
  unsigned short v2:16;
};
//SIG(1 BFu0i_D_BFu16s) C1{ Fi:0 FL Fs:16}



static void Test_BFu0i_D_BFu16s()
{
  {
    init_simple_test("BFu0i_D_BFu16s");
    static BFu0i_D_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0i_D_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0i_D_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu16s(Test_BFu0i_D_BFu16s, "BFu0i_D_BFu16s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu17i  {
  unsigned int  :0;
  double v1;
  unsigned int v2:17;
};
//SIG(1 BFu0i_D_BFu17i) C1{ Fi:0 FL Fi:17}



static void Test_BFu0i_D_BFu17i()
{
  {
    init_simple_test("BFu0i_D_BFu17i");
    static BFu0i_D_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0i_D_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0i_D_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu17i(Test_BFu0i_D_BFu17i, "BFu0i_D_BFu17i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu17ll  {
  unsigned int  :0;
  double v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_D_BFu17ll) C1{ Fi:0 FL FL:17}



static void Test_BFu0i_D_BFu17ll()
{
  {
    init_simple_test("BFu0i_D_BFu17ll");
    static BFu0i_D_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0i_D_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0i_D_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu17ll(Test_BFu0i_D_BFu17ll, "BFu0i_D_BFu17ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu1c  {
  unsigned int  :0;
  double v1;
  unsigned char v2:1;
};
//SIG(1 BFu0i_D_BFu1c) C1{ Fi:0 FL Fc:1}



static void Test_BFu0i_D_BFu1c()
{
  {
    init_simple_test("BFu0i_D_BFu1c");
    static BFu0i_D_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0i_D_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu1c(Test_BFu0i_D_BFu1c, "BFu0i_D_BFu1c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu1i  {
  unsigned int  :0;
  double v1;
  unsigned int v2:1;
};
//SIG(1 BFu0i_D_BFu1i) C1{ Fi:0 FL Fi:1}



static void Test_BFu0i_D_BFu1i()
{
  {
    init_simple_test("BFu0i_D_BFu1i");
    static BFu0i_D_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0i_D_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu1i(Test_BFu0i_D_BFu1i, "BFu0i_D_BFu1i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu1ll  {
  unsigned int  :0;
  double v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_D_BFu1ll) C1{ Fi:0 FL FL:1}



static void Test_BFu0i_D_BFu1ll()
{
  {
    init_simple_test("BFu0i_D_BFu1ll");
    static BFu0i_D_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0i_D_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu1ll(Test_BFu0i_D_BFu1ll, "BFu0i_D_BFu1ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu1s  {
  unsigned int  :0;
  double v1;
  unsigned short v2:1;
};
//SIG(1 BFu0i_D_BFu1s) C1{ Fi:0 FL Fs:1}



static void Test_BFu0i_D_BFu1s()
{
  {
    init_simple_test("BFu0i_D_BFu1s");
    static BFu0i_D_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0i_D_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu1s(Test_BFu0i_D_BFu1s, "BFu0i_D_BFu1s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu31i  {
  unsigned int  :0;
  double v1;
  unsigned int v2:31;
};
//SIG(1 BFu0i_D_BFu31i) C1{ Fi:0 FL Fi:31}



static void Test_BFu0i_D_BFu31i()
{
  {
    init_simple_test("BFu0i_D_BFu31i");
    static BFu0i_D_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0i_D_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0i_D_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu31i(Test_BFu0i_D_BFu31i, "BFu0i_D_BFu31i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu31ll  {
  unsigned int  :0;
  double v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_D_BFu31ll) C1{ Fi:0 FL FL:31}



static void Test_BFu0i_D_BFu31ll()
{
  {
    init_simple_test("BFu0i_D_BFu31ll");
    static BFu0i_D_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0i_D_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0i_D_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu31ll(Test_BFu0i_D_BFu31ll, "BFu0i_D_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu32i  {
  unsigned int  :0;
  double v1;
  unsigned int v2:32;
};
//SIG(1 BFu0i_D_BFu32i) C1{ Fi:0 FL Fi:32}



static void Test_BFu0i_D_BFu32i()
{
  {
    init_simple_test("BFu0i_D_BFu32i");
    static BFu0i_D_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0i_D_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0i_D_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu32i(Test_BFu0i_D_BFu32i, "BFu0i_D_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu32ll  {
  unsigned int  :0;
  double v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_D_BFu32ll) C1{ Fi:0 FL FL:32}



static void Test_BFu0i_D_BFu32ll()
{
  {
    init_simple_test("BFu0i_D_BFu32ll");
    static BFu0i_D_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0i_D_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0i_D_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu32ll(Test_BFu0i_D_BFu32ll, "BFu0i_D_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu33  {
  unsigned int  :0;
  double v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_D_BFu33) C1{ Fi:0 FL FL:33}



static void Test_BFu0i_D_BFu33()
{
  {
    init_simple_test("BFu0i_D_BFu33");
    static BFu0i_D_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(BFu0i_D_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "BFu0i_D_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "BFu0i_D_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu33(Test_BFu0i_D_BFu33, "BFu0i_D_BFu33", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu7c  {
  unsigned int  :0;
  double v1;
  unsigned char v2:7;
};
//SIG(1 BFu0i_D_BFu7c) C1{ Fi:0 FL Fc:7}



static void Test_BFu0i_D_BFu7c()
{
  {
    init_simple_test("BFu0i_D_BFu7c");
    static BFu0i_D_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0i_D_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0i_D_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu7c(Test_BFu0i_D_BFu7c, "BFu0i_D_BFu7c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu7i  {
  unsigned int  :0;
  double v1;
  unsigned int v2:7;
};
//SIG(1 BFu0i_D_BFu7i) C1{ Fi:0 FL Fi:7}



static void Test_BFu0i_D_BFu7i()
{
  {
    init_simple_test("BFu0i_D_BFu7i");
    static BFu0i_D_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0i_D_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0i_D_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu7i(Test_BFu0i_D_BFu7i, "BFu0i_D_BFu7i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu7ll  {
  unsigned int  :0;
  double v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_D_BFu7ll) C1{ Fi:0 FL FL:7}



static void Test_BFu0i_D_BFu7ll()
{
  {
    init_simple_test("BFu0i_D_BFu7ll");
    static BFu0i_D_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0i_D_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0i_D_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu7ll(Test_BFu0i_D_BFu7ll, "BFu0i_D_BFu7ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu7s  {
  unsigned int  :0;
  double v1;
  unsigned short v2:7;
};
//SIG(1 BFu0i_D_BFu7s) C1{ Fi:0 FL Fs:7}



static void Test_BFu0i_D_BFu7s()
{
  {
    init_simple_test("BFu0i_D_BFu7s");
    static BFu0i_D_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0i_D_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0i_D_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu7s(Test_BFu0i_D_BFu7s, "BFu0i_D_BFu7s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu8c  {
  unsigned int  :0;
  double v1;
  unsigned char v2:8;
};
//SIG(1 BFu0i_D_BFu8c) C1{ Fi:0 FL Fc:8}



static void Test_BFu0i_D_BFu8c()
{
  {
    init_simple_test("BFu0i_D_BFu8c");
    static BFu0i_D_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0i_D_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0i_D_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu8c(Test_BFu0i_D_BFu8c, "BFu0i_D_BFu8c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu8i  {
  unsigned int  :0;
  double v1;
  unsigned int v2:8;
};
//SIG(1 BFu0i_D_BFu8i) C1{ Fi:0 FL Fi:8}



static void Test_BFu0i_D_BFu8i()
{
  {
    init_simple_test("BFu0i_D_BFu8i");
    static BFu0i_D_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0i_D_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0i_D_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu8i(Test_BFu0i_D_BFu8i, "BFu0i_D_BFu8i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu8ll  {
  unsigned int  :0;
  double v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_D_BFu8ll) C1{ Fi:0 FL FL:8}



static void Test_BFu0i_D_BFu8ll()
{
  {
    init_simple_test("BFu0i_D_BFu8ll");
    static BFu0i_D_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0i_D_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0i_D_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu8ll(Test_BFu0i_D_BFu8ll, "BFu0i_D_BFu8ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu8s  {
  unsigned int  :0;
  double v1;
  unsigned short v2:8;
};
//SIG(1 BFu0i_D_BFu8s) C1{ Fi:0 FL Fs:8}



static void Test_BFu0i_D_BFu8s()
{
  {
    init_simple_test("BFu0i_D_BFu8s");
    static BFu0i_D_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0i_D_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0i_D_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu8s(Test_BFu0i_D_BFu8s, "BFu0i_D_BFu8s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu9i  {
  unsigned int  :0;
  double v1;
  unsigned int v2:9;
};
//SIG(1 BFu0i_D_BFu9i) C1{ Fi:0 FL Fi:9}



static void Test_BFu0i_D_BFu9i()
{
  {
    init_simple_test("BFu0i_D_BFu9i");
    static BFu0i_D_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0i_D_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0i_D_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu9i(Test_BFu0i_D_BFu9i, "BFu0i_D_BFu9i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu9ll  {
  unsigned int  :0;
  double v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_D_BFu9ll) C1{ Fi:0 FL FL:9}



static void Test_BFu0i_D_BFu9ll()
{
  {
    init_simple_test("BFu0i_D_BFu9ll");
    static BFu0i_D_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0i_D_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0i_D_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu9ll(Test_BFu0i_D_BFu9ll, "BFu0i_D_BFu9ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_BFu9s  {
  unsigned int  :0;
  double v1;
  unsigned short v2:9;
};
//SIG(1 BFu0i_D_BFu9s) C1{ Fi:0 FL Fs:9}



static void Test_BFu0i_D_BFu9s()
{
  {
    init_simple_test("BFu0i_D_BFu9s");
    static BFu0i_D_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0i_D_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0i_D_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0i_D_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_D_BFu9s(Test_BFu0i_D_BFu9s, "BFu0i_D_BFu9s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_C  {
  unsigned int  :0;
  double v1;
  char v2;
};
//SIG(1 BFu0i_D_C) C1{ Fi:0 FL Fc}



static void Test_BFu0i_D_C()
{
  {
    init_simple_test("BFu0i_D_C");
    static BFu0i_D_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_C)");
    check_field_offset(lv, v1, 0, "BFu0i_D_C.v1");
    check_field_offset(lv, v2, 8, "BFu0i_D_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_D_C(Test_BFu0i_D_C, "BFu0i_D_C", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_D  {
  unsigned int  :0;
  double v1;
  double v2;
};
//SIG(1 BFu0i_D_D) C1{ Fi:0 FL[2]}



static void Test_BFu0i_D_D()
{
  {
    init_simple_test("BFu0i_D_D");
    static BFu0i_D_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu0i_D_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_D)");
    check_field_offset(lv, v1, 0, "BFu0i_D_D.v1");
    check_field_offset(lv, v2, 8, "BFu0i_D_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_D_D(Test_BFu0i_D_D, "BFu0i_D_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_F  {
  unsigned int  :0;
  double v1;
  float v2;
};
//SIG(1 BFu0i_D_F) C1{ Fi:0 FL Fi}



static void Test_BFu0i_D_F()
{
  {
    init_simple_test("BFu0i_D_F");
    static BFu0i_D_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_F)");
    check_field_offset(lv, v1, 0, "BFu0i_D_F.v1");
    check_field_offset(lv, v2, 8, "BFu0i_D_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_D_F(Test_BFu0i_D_F, "BFu0i_D_F", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_I  {
  unsigned int  :0;
  double v1;
  int v2;
};
//SIG(1 BFu0i_D_I) C1{ Fi:0 FL Fi}



static void Test_BFu0i_D_I()
{
  {
    init_simple_test("BFu0i_D_I");
    static BFu0i_D_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_I)");
    check_field_offset(lv, v1, 0, "BFu0i_D_I.v1");
    check_field_offset(lv, v2, 8, "BFu0i_D_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_D_I(Test_BFu0i_D_I, "BFu0i_D_I", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_Ip  {
  unsigned int  :0;
  double v1;
  int *v2;
};
//SIG(1 BFu0i_D_Ip) C1{ Fi:0 FL Fp}



static void Test_BFu0i_D_Ip()
{
  {
    init_simple_test("BFu0i_D_Ip");
    static BFu0i_D_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_Ip)");
    check_field_offset(lv, v1, 0, "BFu0i_D_Ip.v1");
    check_field_offset(lv, v2, 8, "BFu0i_D_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_D_Ip(Test_BFu0i_D_Ip, "BFu0i_D_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_L  {
  unsigned int  :0;
  double v1;
  __tsi64 v2;
};
//SIG(1 BFu0i_D_L) C1{ Fi:0 FL[2]}



static void Test_BFu0i_D_L()
{
  {
    init_simple_test("BFu0i_D_L");
    static BFu0i_D_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu0i_D_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_L)");
    check_field_offset(lv, v1, 0, "BFu0i_D_L.v1");
    check_field_offset(lv, v2, 8, "BFu0i_D_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_D_L(Test_BFu0i_D_L, "BFu0i_D_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_S  {
  unsigned int  :0;
  double v1;
  short v2;
};
//SIG(1 BFu0i_D_S) C1{ Fi:0 FL Fs}



static void Test_BFu0i_D_S()
{
  {
    init_simple_test("BFu0i_D_S");
    static BFu0i_D_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_S)");
    check_field_offset(lv, v1, 0, "BFu0i_D_S.v1");
    check_field_offset(lv, v2, 8, "BFu0i_D_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_D_S(Test_BFu0i_D_S, "BFu0i_D_S", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_Uc  {
  unsigned int  :0;
  double v1;
  unsigned char v2;
};
//SIG(1 BFu0i_D_Uc) C1{ Fi:0 FL Fc}



static void Test_BFu0i_D_Uc()
{
  {
    init_simple_test("BFu0i_D_Uc");
    static BFu0i_D_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_Uc)");
    check_field_offset(lv, v1, 0, "BFu0i_D_Uc.v1");
    check_field_offset(lv, v2, 8, "BFu0i_D_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_D_Uc(Test_BFu0i_D_Uc, "BFu0i_D_Uc", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_Ui  {
  unsigned int  :0;
  double v1;
  unsigned int v2;
};
//SIG(1 BFu0i_D_Ui) C1{ Fi:0 FL Fi}



static void Test_BFu0i_D_Ui()
{
  {
    init_simple_test("BFu0i_D_Ui");
    static BFu0i_D_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_Ui)");
    check_field_offset(lv, v1, 0, "BFu0i_D_Ui.v1");
    check_field_offset(lv, v2, 8, "BFu0i_D_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_D_Ui(Test_BFu0i_D_Ui, "BFu0i_D_Ui", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_Ul  {
  unsigned int  :0;
  double v1;
  __tsu64 v2;
};
//SIG(1 BFu0i_D_Ul) C1{ Fi:0 FL[2]}



static void Test_BFu0i_D_Ul()
{
  {
    init_simple_test("BFu0i_D_Ul");
    static BFu0i_D_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu0i_D_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_Ul)");
    check_field_offset(lv, v1, 0, "BFu0i_D_Ul.v1");
    check_field_offset(lv, v2, 8, "BFu0i_D_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_D_Ul(Test_BFu0i_D_Ul, "BFu0i_D_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_Us  {
  unsigned int  :0;
  double v1;
  unsigned short v2;
};
//SIG(1 BFu0i_D_Us) C1{ Fi:0 FL Fs}



static void Test_BFu0i_D_Us()
{
  {
    init_simple_test("BFu0i_D_Us");
    static BFu0i_D_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_Us)");
    check_field_offset(lv, v1, 0, "BFu0i_D_Us.v1");
    check_field_offset(lv, v2, 8, "BFu0i_D_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_D_Us(Test_BFu0i_D_Us, "BFu0i_D_Us", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_D_Vp  {
  unsigned int  :0;
  double v1;
  void *v2;
};
//SIG(1 BFu0i_D_Vp) C1{ Fi:0 FL Fp}



static void Test_BFu0i_D_Vp()
{
  {
    init_simple_test("BFu0i_D_Vp");
    static BFu0i_D_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_D_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_D_Vp)");
    check_field_offset(lv, v1, 0, "BFu0i_D_Vp.v1");
    check_field_offset(lv, v2, 8, "BFu0i_D_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_D_Vp(Test_BFu0i_D_Vp, "BFu0i_D_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F  {
  unsigned int  :0;
  float v1;
};
//SIG(1 BFu0i_F) C1{ Fi:0 Fi}



static void Test_BFu0i_F()
{
  {
    init_simple_test("BFu0i_F");
    static BFu0i_F lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F)");
    check_field_offset(lv, v1, 0, "BFu0i_F.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_F(Test_BFu0i_F, "BFu0i_F", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu0c  {
  unsigned int  :0;
  float v1;
  unsigned char  :0;
};
//SIG(1 BFu0i_F_BFu0c) C1{ Fi:0 Fi Fc:0}



static void Test_BFu0i_F_BFu0c()
{
  {
    init_simple_test("BFu0i_F_BFu0c");
    static BFu0i_F_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_F_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu0c(Test_BFu0i_F_BFu0c, "BFu0i_F_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu0i  {
  unsigned int  :0;
  float v1;
  unsigned int  :0;
};
//SIG(1 BFu0i_F_BFu0i) C1{ Fi:0 Fi Fi:0}



static void Test_BFu0i_F_BFu0i()
{
  {
    init_simple_test("BFu0i_F_BFu0i");
    static BFu0i_F_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_F_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu0i(Test_BFu0i_F_BFu0i, "BFu0i_F_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu0ll  {
  unsigned int  :0;
  float v1;
  __tsu64  :0;
};
//SIG(1 BFu0i_F_BFu0ll) C1{ Fi:0 Fi FL:0}



static void Test_BFu0i_F_BFu0ll()
{
  {
    init_simple_test("BFu0i_F_BFu0ll");
    static BFu0i_F_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_F_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0i_F_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu0ll(Test_BFu0i_F_BFu0ll, "BFu0i_F_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu0s  {
  unsigned int  :0;
  float v1;
  unsigned short  :0;
};
//SIG(1 BFu0i_F_BFu0s) C1{ Fi:0 Fi Fs:0}



static void Test_BFu0i_F_BFu0s()
{
  {
    init_simple_test("BFu0i_F_BFu0s");
    static BFu0i_F_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_F_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu0s(Test_BFu0i_F_BFu0s, "BFu0i_F_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu15i  {
  unsigned int  :0;
  float v1;
  unsigned int v2:15;
};
//SIG(1 BFu0i_F_BFu15i) C1{ Fi:0 Fi Fi:15}



static void Test_BFu0i_F_BFu15i()
{
  {
    init_simple_test("BFu0i_F_BFu15i");
    static BFu0i_F_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_F_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_F_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu15i(Test_BFu0i_F_BFu15i, "BFu0i_F_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu15ll  {
  unsigned int  :0;
  float v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_F_BFu15ll) C1{ Fi:0 Fi FL:15}



static void Test_BFu0i_F_BFu15ll()
{
  {
    init_simple_test("BFu0i_F_BFu15ll");
    static BFu0i_F_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_F_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_F_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu15ll(Test_BFu0i_F_BFu15ll, "BFu0i_F_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu15s  {
  unsigned int  :0;
  float v1;
  unsigned short v2:15;
};
//SIG(1 BFu0i_F_BFu15s) C1{ Fi:0 Fi Fs:15}



static void Test_BFu0i_F_BFu15s()
{
  {
    init_simple_test("BFu0i_F_BFu15s");
    static BFu0i_F_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_F_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_F_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu15s(Test_BFu0i_F_BFu15s, "BFu0i_F_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu16i  {
  unsigned int  :0;
  float v1;
  unsigned int v2:16;
};
//SIG(1 BFu0i_F_BFu16i) C1{ Fi:0 Fi Fi:16}



static void Test_BFu0i_F_BFu16i()
{
  {
    init_simple_test("BFu0i_F_BFu16i");
    static BFu0i_F_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_F_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_F_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu16i(Test_BFu0i_F_BFu16i, "BFu0i_F_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu16ll  {
  unsigned int  :0;
  float v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_F_BFu16ll) C1{ Fi:0 Fi FL:16}



static void Test_BFu0i_F_BFu16ll()
{
  {
    init_simple_test("BFu0i_F_BFu16ll");
    static BFu0i_F_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_F_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_F_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu16ll(Test_BFu0i_F_BFu16ll, "BFu0i_F_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu16s  {
  unsigned int  :0;
  float v1;
  unsigned short v2:16;
};
//SIG(1 BFu0i_F_BFu16s) C1{ Fi:0 Fi Fs:16}



static void Test_BFu0i_F_BFu16s()
{
  {
    init_simple_test("BFu0i_F_BFu16s");
    static BFu0i_F_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_F_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_F_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu16s(Test_BFu0i_F_BFu16s, "BFu0i_F_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu17i  {
  unsigned int  :0;
  float v1;
  unsigned int v2:17;
};
//SIG(1 BFu0i_F_BFu17i) C1{ Fi:0 Fi Fi:17}



static void Test_BFu0i_F_BFu17i()
{
  {
    init_simple_test("BFu0i_F_BFu17i");
    static BFu0i_F_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0i_F_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0i_F_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu17i(Test_BFu0i_F_BFu17i, "BFu0i_F_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu17ll  {
  unsigned int  :0;
  float v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_F_BFu17ll) C1{ Fi:0 Fi FL:17}



static void Test_BFu0i_F_BFu17ll()
{
  {
    init_simple_test("BFu0i_F_BFu17ll");
    static BFu0i_F_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0i_F_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0i_F_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu17ll(Test_BFu0i_F_BFu17ll, "BFu0i_F_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu1c  {
  unsigned int  :0;
  float v1;
  unsigned char v2:1;
};
//SIG(1 BFu0i_F_BFu1c) C1{ Fi:0 Fi Fc:1}



static void Test_BFu0i_F_BFu1c()
{
  {
    init_simple_test("BFu0i_F_BFu1c");
    static BFu0i_F_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_F_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu1c(Test_BFu0i_F_BFu1c, "BFu0i_F_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu1i  {
  unsigned int  :0;
  float v1;
  unsigned int v2:1;
};
//SIG(1 BFu0i_F_BFu1i) C1{ Fi:0 Fi Fi:1}



static void Test_BFu0i_F_BFu1i()
{
  {
    init_simple_test("BFu0i_F_BFu1i");
    static BFu0i_F_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_F_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu1i(Test_BFu0i_F_BFu1i, "BFu0i_F_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu1ll  {
  unsigned int  :0;
  float v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_F_BFu1ll) C1{ Fi:0 Fi FL:1}



static void Test_BFu0i_F_BFu1ll()
{
  {
    init_simple_test("BFu0i_F_BFu1ll");
    static BFu0i_F_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_F_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu1ll(Test_BFu0i_F_BFu1ll, "BFu0i_F_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu1s  {
  unsigned int  :0;
  float v1;
  unsigned short v2:1;
};
//SIG(1 BFu0i_F_BFu1s) C1{ Fi:0 Fi Fs:1}



static void Test_BFu0i_F_BFu1s()
{
  {
    init_simple_test("BFu0i_F_BFu1s");
    static BFu0i_F_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_F_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu1s(Test_BFu0i_F_BFu1s, "BFu0i_F_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu31i  {
  unsigned int  :0;
  float v1;
  unsigned int v2:31;
};
//SIG(1 BFu0i_F_BFu31i) C1{ Fi:0 Fi Fi:31}



static void Test_BFu0i_F_BFu31i()
{
  {
    init_simple_test("BFu0i_F_BFu31i");
    static BFu0i_F_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_F_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_F_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu31i(Test_BFu0i_F_BFu31i, "BFu0i_F_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu31ll  {
  unsigned int  :0;
  float v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_F_BFu31ll) C1{ Fi:0 Fi FL:31}



static void Test_BFu0i_F_BFu31ll()
{
  {
    init_simple_test("BFu0i_F_BFu31ll");
    static BFu0i_F_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_F_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_F_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu31ll(Test_BFu0i_F_BFu31ll, "BFu0i_F_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu32i  {
  unsigned int  :0;
  float v1;
  unsigned int v2:32;
};
//SIG(1 BFu0i_F_BFu32i) C1{ Fi:0 Fi Fi:32}



static void Test_BFu0i_F_BFu32i()
{
  {
    init_simple_test("BFu0i_F_BFu32i");
    static BFu0i_F_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_F_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_F_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu32i(Test_BFu0i_F_BFu32i, "BFu0i_F_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu32ll  {
  unsigned int  :0;
  float v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_F_BFu32ll) C1{ Fi:0 Fi FL:32}



static void Test_BFu0i_F_BFu32ll()
{
  {
    init_simple_test("BFu0i_F_BFu32ll");
    static BFu0i_F_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_F_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_F_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu32ll(Test_BFu0i_F_BFu32ll, "BFu0i_F_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu33  {
  unsigned int  :0;
  float v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_F_BFu33) C1{ Fi:0 Fi FL:33}



static void Test_BFu0i_F_BFu33()
{
  {
    init_simple_test("BFu0i_F_BFu33");
    static BFu0i_F_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_F_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu0i_F_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu0i_F_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu33(Test_BFu0i_F_BFu33, "BFu0i_F_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu7c  {
  unsigned int  :0;
  float v1;
  unsigned char v2:7;
};
//SIG(1 BFu0i_F_BFu7c) C1{ Fi:0 Fi Fc:7}



static void Test_BFu0i_F_BFu7c()
{
  {
    init_simple_test("BFu0i_F_BFu7c");
    static BFu0i_F_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_F_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_F_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu7c(Test_BFu0i_F_BFu7c, "BFu0i_F_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu7i  {
  unsigned int  :0;
  float v1;
  unsigned int v2:7;
};
//SIG(1 BFu0i_F_BFu7i) C1{ Fi:0 Fi Fi:7}



static void Test_BFu0i_F_BFu7i()
{
  {
    init_simple_test("BFu0i_F_BFu7i");
    static BFu0i_F_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_F_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_F_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu7i(Test_BFu0i_F_BFu7i, "BFu0i_F_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu7ll  {
  unsigned int  :0;
  float v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_F_BFu7ll) C1{ Fi:0 Fi FL:7}



static void Test_BFu0i_F_BFu7ll()
{
  {
    init_simple_test("BFu0i_F_BFu7ll");
    static BFu0i_F_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_F_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_F_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu7ll(Test_BFu0i_F_BFu7ll, "BFu0i_F_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu7s  {
  unsigned int  :0;
  float v1;
  unsigned short v2:7;
};
//SIG(1 BFu0i_F_BFu7s) C1{ Fi:0 Fi Fs:7}



static void Test_BFu0i_F_BFu7s()
{
  {
    init_simple_test("BFu0i_F_BFu7s");
    static BFu0i_F_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_F_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_F_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu7s(Test_BFu0i_F_BFu7s, "BFu0i_F_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu8c  {
  unsigned int  :0;
  float v1;
  unsigned char v2:8;
};
//SIG(1 BFu0i_F_BFu8c) C1{ Fi:0 Fi Fc:8}



static void Test_BFu0i_F_BFu8c()
{
  {
    init_simple_test("BFu0i_F_BFu8c");
    static BFu0i_F_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_F_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_F_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu8c(Test_BFu0i_F_BFu8c, "BFu0i_F_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu8i  {
  unsigned int  :0;
  float v1;
  unsigned int v2:8;
};
//SIG(1 BFu0i_F_BFu8i) C1{ Fi:0 Fi Fi:8}



static void Test_BFu0i_F_BFu8i()
{
  {
    init_simple_test("BFu0i_F_BFu8i");
    static BFu0i_F_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_F_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_F_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu8i(Test_BFu0i_F_BFu8i, "BFu0i_F_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu8ll  {
  unsigned int  :0;
  float v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_F_BFu8ll) C1{ Fi:0 Fi FL:8}



static void Test_BFu0i_F_BFu8ll()
{
  {
    init_simple_test("BFu0i_F_BFu8ll");
    static BFu0i_F_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_F_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_F_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu8ll(Test_BFu0i_F_BFu8ll, "BFu0i_F_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu8s  {
  unsigned int  :0;
  float v1;
  unsigned short v2:8;
};
//SIG(1 BFu0i_F_BFu8s) C1{ Fi:0 Fi Fs:8}



static void Test_BFu0i_F_BFu8s()
{
  {
    init_simple_test("BFu0i_F_BFu8s");
    static BFu0i_F_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_F_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_F_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu8s(Test_BFu0i_F_BFu8s, "BFu0i_F_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu9i  {
  unsigned int  :0;
  float v1;
  unsigned int v2:9;
};
//SIG(1 BFu0i_F_BFu9i) C1{ Fi:0 Fi Fi:9}



static void Test_BFu0i_F_BFu9i()
{
  {
    init_simple_test("BFu0i_F_BFu9i");
    static BFu0i_F_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_F_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_F_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu9i(Test_BFu0i_F_BFu9i, "BFu0i_F_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu9ll  {
  unsigned int  :0;
  float v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_F_BFu9ll) C1{ Fi:0 Fi FL:9}



static void Test_BFu0i_F_BFu9ll()
{
  {
    init_simple_test("BFu0i_F_BFu9ll");
    static BFu0i_F_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_F_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_F_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu9ll(Test_BFu0i_F_BFu9ll, "BFu0i_F_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_BFu9s  {
  unsigned int  :0;
  float v1;
  unsigned short v2:9;
};
//SIG(1 BFu0i_F_BFu9s) C1{ Fi:0 Fi Fs:9}



static void Test_BFu0i_F_BFu9s()
{
  {
    init_simple_test("BFu0i_F_BFu9s");
    static BFu0i_F_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0i_F_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_F_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_F_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_F_BFu9s(Test_BFu0i_F_BFu9s, "BFu0i_F_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_C  {
  unsigned int  :0;
  float v1;
  char v2;
};
//SIG(1 BFu0i_F_C) C1{ Fi:0 Fi Fc}



static void Test_BFu0i_F_C()
{
  {
    init_simple_test("BFu0i_F_C");
    static BFu0i_F_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_C)");
    check_field_offset(lv, v1, 0, "BFu0i_F_C.v1");
    check_field_offset(lv, v2, 4, "BFu0i_F_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_F_C(Test_BFu0i_F_C, "BFu0i_F_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_D  {
  unsigned int  :0;
  float v1;
  double v2;
};
//SIG(1 BFu0i_F_D) C1{ Fi:0 Fi FL}



static void Test_BFu0i_F_D()
{
  {
    init_simple_test("BFu0i_F_D");
    static BFu0i_F_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_F_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_D)");
    check_field_offset(lv, v1, 0, "BFu0i_F_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_F_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_F_D(Test_BFu0i_F_D, "BFu0i_F_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_F  {
  unsigned int  :0;
  float v1;
  float v2;
};
//SIG(1 BFu0i_F_F) C1{ Fi:0 Fi[2]}



static void Test_BFu0i_F_F()
{
  {
    init_simple_test("BFu0i_F_F");
    static BFu0i_F_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_F)");
    check_field_offset(lv, v1, 0, "BFu0i_F_F.v1");
    check_field_offset(lv, v2, 4, "BFu0i_F_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_F_F(Test_BFu0i_F_F, "BFu0i_F_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_I  {
  unsigned int  :0;
  float v1;
  int v2;
};
//SIG(1 BFu0i_F_I) C1{ Fi:0 Fi[2]}



static void Test_BFu0i_F_I()
{
  {
    init_simple_test("BFu0i_F_I");
    static BFu0i_F_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_I)");
    check_field_offset(lv, v1, 0, "BFu0i_F_I.v1");
    check_field_offset(lv, v2, 4, "BFu0i_F_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_F_I(Test_BFu0i_F_I, "BFu0i_F_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_Ip  {
  unsigned int  :0;
  float v1;
  int *v2;
};
//SIG(1 BFu0i_F_Ip) C1{ Fi:0 Fi Fp}



static void Test_BFu0i_F_Ip()
{
  {
    init_simple_test("BFu0i_F_Ip");
    static BFu0i_F_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_F_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_Ip)");
    check_field_offset(lv, v1, 0, "BFu0i_F_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_F_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_F_Ip(Test_BFu0i_F_Ip, "BFu0i_F_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_L  {
  unsigned int  :0;
  float v1;
  __tsi64 v2;
};
//SIG(1 BFu0i_F_L) C1{ Fi:0 Fi FL}



static void Test_BFu0i_F_L()
{
  {
    init_simple_test("BFu0i_F_L");
    static BFu0i_F_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_F_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_L)");
    check_field_offset(lv, v1, 0, "BFu0i_F_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_F_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_F_L(Test_BFu0i_F_L, "BFu0i_F_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_S  {
  unsigned int  :0;
  float v1;
  short v2;
};
//SIG(1 BFu0i_F_S) C1{ Fi:0 Fi Fs}



static void Test_BFu0i_F_S()
{
  {
    init_simple_test("BFu0i_F_S");
    static BFu0i_F_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_S)");
    check_field_offset(lv, v1, 0, "BFu0i_F_S.v1");
    check_field_offset(lv, v2, 4, "BFu0i_F_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_F_S(Test_BFu0i_F_S, "BFu0i_F_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_Uc  {
  unsigned int  :0;
  float v1;
  unsigned char v2;
};
//SIG(1 BFu0i_F_Uc) C1{ Fi:0 Fi Fc}



static void Test_BFu0i_F_Uc()
{
  {
    init_simple_test("BFu0i_F_Uc");
    static BFu0i_F_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_Uc)");
    check_field_offset(lv, v1, 0, "BFu0i_F_Uc.v1");
    check_field_offset(lv, v2, 4, "BFu0i_F_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_F_Uc(Test_BFu0i_F_Uc, "BFu0i_F_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_Ui  {
  unsigned int  :0;
  float v1;
  unsigned int v2;
};
//SIG(1 BFu0i_F_Ui) C1{ Fi:0 Fi[2]}



static void Test_BFu0i_F_Ui()
{
  {
    init_simple_test("BFu0i_F_Ui");
    static BFu0i_F_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_Ui)");
    check_field_offset(lv, v1, 0, "BFu0i_F_Ui.v1");
    check_field_offset(lv, v2, 4, "BFu0i_F_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_F_Ui(Test_BFu0i_F_Ui, "BFu0i_F_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_Ul  {
  unsigned int  :0;
  float v1;
  __tsu64 v2;
};
//SIG(1 BFu0i_F_Ul) C1{ Fi:0 Fi FL}



static void Test_BFu0i_F_Ul()
{
  {
    init_simple_test("BFu0i_F_Ul");
    static BFu0i_F_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_F_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_Ul)");
    check_field_offset(lv, v1, 0, "BFu0i_F_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_F_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_F_Ul(Test_BFu0i_F_Ul, "BFu0i_F_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_Us  {
  unsigned int  :0;
  float v1;
  unsigned short v2;
};
//SIG(1 BFu0i_F_Us) C1{ Fi:0 Fi Fs}



static void Test_BFu0i_F_Us()
{
  {
    init_simple_test("BFu0i_F_Us");
    static BFu0i_F_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_F_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_F_Us)");
    check_field_offset(lv, v1, 0, "BFu0i_F_Us.v1");
    check_field_offset(lv, v2, 4, "BFu0i_F_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_F_Us(Test_BFu0i_F_Us, "BFu0i_F_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_F_Vp  {
  unsigned int  :0;
  float v1;
  void *v2;
};
//SIG(1 BFu0i_F_Vp) C1{ Fi:0 Fi Fp}



static void Test_BFu0i_F_Vp()
{
  {
    init_simple_test("BFu0i_F_Vp");
    static BFu0i_F_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_F_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_F_Vp)");
    check_field_offset(lv, v1, 0, "BFu0i_F_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_F_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_F_Vp(Test_BFu0i_F_Vp, "BFu0i_F_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I  {
  unsigned int  :0;
  int v1;
};
//SIG(1 BFu0i_I) C1{ Fi:0 Fi}



static void Test_BFu0i_I()
{
  {
    init_simple_test("BFu0i_I");
    static BFu0i_I lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I)");
    check_field_offset(lv, v1, 0, "BFu0i_I.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_I(Test_BFu0i_I, "BFu0i_I", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu0c  {
  unsigned int  :0;
  int v1;
  unsigned char  :0;
};
//SIG(1 BFu0i_I_BFu0c) C1{ Fi:0 Fi Fc:0}



static void Test_BFu0i_I_BFu0c()
{
  {
    init_simple_test("BFu0i_I_BFu0c");
    static BFu0i_I_BFu0c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_I_BFu0c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu0c(Test_BFu0i_I_BFu0c, "BFu0i_I_BFu0c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu0i  {
  unsigned int  :0;
  int v1;
  unsigned int  :0;
};
//SIG(1 BFu0i_I_BFu0i) C1{ Fi:0 Fi Fi:0}



static void Test_BFu0i_I_BFu0i()
{
  {
    init_simple_test("BFu0i_I_BFu0i");
    static BFu0i_I_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_I_BFu0i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu0i(Test_BFu0i_I_BFu0i, "BFu0i_I_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu0ll  {
  unsigned int  :0;
  int v1;
  __tsu64  :0;
};
//SIG(1 BFu0i_I_BFu0ll) C1{ Fi:0 Fi FL:0}



static void Test_BFu0i_I_BFu0ll()
{
  {
    init_simple_test("BFu0i_I_BFu0ll");
    static BFu0i_I_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_I_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(4,4), "__alignof__(BFu0i_I_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu0ll(Test_BFu0i_I_BFu0ll, "BFu0i_I_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu0s  {
  unsigned int  :0;
  int v1;
  unsigned short  :0;
};
//SIG(1 BFu0i_I_BFu0s) C1{ Fi:0 Fi Fs:0}



static void Test_BFu0i_I_BFu0s()
{
  {
    init_simple_test("BFu0i_I_BFu0s");
    static BFu0i_I_BFu0s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_I_BFu0s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu0s(Test_BFu0i_I_BFu0s, "BFu0i_I_BFu0s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu15i  {
  unsigned int  :0;
  int v1;
  unsigned int v2:15;
};
//SIG(1 BFu0i_I_BFu15i) C1{ Fi:0 Fi Fi:15}



static void Test_BFu0i_I_BFu15i()
{
  {
    init_simple_test("BFu0i_I_BFu15i");
    static BFu0i_I_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_I_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_I_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu15i(Test_BFu0i_I_BFu15i, "BFu0i_I_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu15ll  {
  unsigned int  :0;
  int v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_I_BFu15ll) C1{ Fi:0 Fi FL:15}



static void Test_BFu0i_I_BFu15ll()
{
  {
    init_simple_test("BFu0i_I_BFu15ll");
    static BFu0i_I_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_I_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_I_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu15ll(Test_BFu0i_I_BFu15ll, "BFu0i_I_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu15s  {
  unsigned int  :0;
  int v1;
  unsigned short v2:15;
};
//SIG(1 BFu0i_I_BFu15s) C1{ Fi:0 Fi Fs:15}



static void Test_BFu0i_I_BFu15s()
{
  {
    init_simple_test("BFu0i_I_BFu15s");
    static BFu0i_I_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu0i_I_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu0i_I_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu15s(Test_BFu0i_I_BFu15s, "BFu0i_I_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu16i  {
  unsigned int  :0;
  int v1;
  unsigned int v2:16;
};
//SIG(1 BFu0i_I_BFu16i) C1{ Fi:0 Fi Fi:16}



static void Test_BFu0i_I_BFu16i()
{
  {
    init_simple_test("BFu0i_I_BFu16i");
    static BFu0i_I_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_I_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_I_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu16i(Test_BFu0i_I_BFu16i, "BFu0i_I_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu16ll  {
  unsigned int  :0;
  int v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_I_BFu16ll) C1{ Fi:0 Fi FL:16}



static void Test_BFu0i_I_BFu16ll()
{
  {
    init_simple_test("BFu0i_I_BFu16ll");
    static BFu0i_I_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_I_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_I_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu16ll(Test_BFu0i_I_BFu16ll, "BFu0i_I_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu16s  {
  unsigned int  :0;
  int v1;
  unsigned short v2:16;
};
//SIG(1 BFu0i_I_BFu16s) C1{ Fi:0 Fi Fs:16}



static void Test_BFu0i_I_BFu16s()
{
  {
    init_simple_test("BFu0i_I_BFu16s");
    static BFu0i_I_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu0i_I_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu0i_I_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu16s(Test_BFu0i_I_BFu16s, "BFu0i_I_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu17i  {
  unsigned int  :0;
  int v1;
  unsigned int v2:17;
};
//SIG(1 BFu0i_I_BFu17i) C1{ Fi:0 Fi Fi:17}



static void Test_BFu0i_I_BFu17i()
{
  {
    init_simple_test("BFu0i_I_BFu17i");
    static BFu0i_I_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0i_I_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0i_I_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu17i(Test_BFu0i_I_BFu17i, "BFu0i_I_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu17ll  {
  unsigned int  :0;
  int v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_I_BFu17ll) C1{ Fi:0 Fi FL:17}



static void Test_BFu0i_I_BFu17ll()
{
  {
    init_simple_test("BFu0i_I_BFu17ll");
    static BFu0i_I_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0i_I_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0i_I_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu17ll(Test_BFu0i_I_BFu17ll, "BFu0i_I_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu1c  {
  unsigned int  :0;
  int v1;
  unsigned char v2:1;
};
//SIG(1 BFu0i_I_BFu1c) C1{ Fi:0 Fi Fc:1}



static void Test_BFu0i_I_BFu1c()
{
  {
    init_simple_test("BFu0i_I_BFu1c");
    static BFu0i_I_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_I_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu1c(Test_BFu0i_I_BFu1c, "BFu0i_I_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu1i  {
  unsigned int  :0;
  int v1;
  unsigned int v2:1;
};
//SIG(1 BFu0i_I_BFu1i) C1{ Fi:0 Fi Fi:1}



static void Test_BFu0i_I_BFu1i()
{
  {
    init_simple_test("BFu0i_I_BFu1i");
    static BFu0i_I_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_I_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu1i(Test_BFu0i_I_BFu1i, "BFu0i_I_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu1ll  {
  unsigned int  :0;
  int v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_I_BFu1ll) C1{ Fi:0 Fi FL:1}



static void Test_BFu0i_I_BFu1ll()
{
  {
    init_simple_test("BFu0i_I_BFu1ll");
    static BFu0i_I_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_I_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu1ll(Test_BFu0i_I_BFu1ll, "BFu0i_I_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu1s  {
  unsigned int  :0;
  int v1;
  unsigned short v2:1;
};
//SIG(1 BFu0i_I_BFu1s) C1{ Fi:0 Fi Fs:1}



static void Test_BFu0i_I_BFu1s()
{
  {
    init_simple_test("BFu0i_I_BFu1s");
    static BFu0i_I_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "BFu0i_I_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu1s(Test_BFu0i_I_BFu1s, "BFu0i_I_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu31i  {
  unsigned int  :0;
  int v1;
  unsigned int v2:31;
};
//SIG(1 BFu0i_I_BFu31i) C1{ Fi:0 Fi Fi:31}



static void Test_BFu0i_I_BFu31i()
{
  {
    init_simple_test("BFu0i_I_BFu31i");
    static BFu0i_I_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_I_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_I_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu31i(Test_BFu0i_I_BFu31i, "BFu0i_I_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu31ll  {
  unsigned int  :0;
  int v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_I_BFu31ll) C1{ Fi:0 Fi FL:31}



static void Test_BFu0i_I_BFu31ll()
{
  {
    init_simple_test("BFu0i_I_BFu31ll");
    static BFu0i_I_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_I_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_I_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu31ll(Test_BFu0i_I_BFu31ll, "BFu0i_I_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu32i  {
  unsigned int  :0;
  int v1;
  unsigned int v2:32;
};
//SIG(1 BFu0i_I_BFu32i) C1{ Fi:0 Fi Fi:32}



static void Test_BFu0i_I_BFu32i()
{
  {
    init_simple_test("BFu0i_I_BFu32i");
    static BFu0i_I_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_I_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_I_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu32i(Test_BFu0i_I_BFu32i, "BFu0i_I_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu32ll  {
  unsigned int  :0;
  int v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_I_BFu32ll) C1{ Fi:0 Fi FL:32}



static void Test_BFu0i_I_BFu32ll()
{
  {
    init_simple_test("BFu0i_I_BFu32ll");
    static BFu0i_I_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_I_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_I_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu32ll(Test_BFu0i_I_BFu32ll, "BFu0i_I_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu33  {
  unsigned int  :0;
  int v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_I_BFu33) C1{ Fi:0 Fi FL:33}



static void Test_BFu0i_I_BFu33()
{
  {
    init_simple_test("BFu0i_I_BFu33");
    static BFu0i_I_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_I_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu0i_I_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu0i_I_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu33(Test_BFu0i_I_BFu33, "BFu0i_I_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu7c  {
  unsigned int  :0;
  int v1;
  unsigned char v2:7;
};
//SIG(1 BFu0i_I_BFu7c) C1{ Fi:0 Fi Fc:7}



static void Test_BFu0i_I_BFu7c()
{
  {
    init_simple_test("BFu0i_I_BFu7c");
    static BFu0i_I_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_I_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_I_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu7c(Test_BFu0i_I_BFu7c, "BFu0i_I_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu7i  {
  unsigned int  :0;
  int v1;
  unsigned int v2:7;
};
//SIG(1 BFu0i_I_BFu7i) C1{ Fi:0 Fi Fi:7}



static void Test_BFu0i_I_BFu7i()
{
  {
    init_simple_test("BFu0i_I_BFu7i");
    static BFu0i_I_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_I_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_I_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu7i(Test_BFu0i_I_BFu7i, "BFu0i_I_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu7ll  {
  unsigned int  :0;
  int v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_I_BFu7ll) C1{ Fi:0 Fi FL:7}



static void Test_BFu0i_I_BFu7ll()
{
  {
    init_simple_test("BFu0i_I_BFu7ll");
    static BFu0i_I_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_I_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_I_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu7ll(Test_BFu0i_I_BFu7ll, "BFu0i_I_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu7s  {
  unsigned int  :0;
  int v1;
  unsigned short v2:7;
};
//SIG(1 BFu0i_I_BFu7s) C1{ Fi:0 Fi Fs:7}



static void Test_BFu0i_I_BFu7s()
{
  {
    init_simple_test("BFu0i_I_BFu7s");
    static BFu0i_I_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu0i_I_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu0i_I_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu7s(Test_BFu0i_I_BFu7s, "BFu0i_I_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu8c  {
  unsigned int  :0;
  int v1;
  unsigned char v2:8;
};
//SIG(1 BFu0i_I_BFu8c) C1{ Fi:0 Fi Fc:8}



static void Test_BFu0i_I_BFu8c()
{
  {
    init_simple_test("BFu0i_I_BFu8c");
    static BFu0i_I_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_I_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_I_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu8c(Test_BFu0i_I_BFu8c, "BFu0i_I_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu8i  {
  unsigned int  :0;
  int v1;
  unsigned int v2:8;
};
//SIG(1 BFu0i_I_BFu8i) C1{ Fi:0 Fi Fi:8}



static void Test_BFu0i_I_BFu8i()
{
  {
    init_simple_test("BFu0i_I_BFu8i");
    static BFu0i_I_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_I_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_I_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu8i(Test_BFu0i_I_BFu8i, "BFu0i_I_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu8ll  {
  unsigned int  :0;
  int v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_I_BFu8ll) C1{ Fi:0 Fi FL:8}



static void Test_BFu0i_I_BFu8ll()
{
  {
    init_simple_test("BFu0i_I_BFu8ll");
    static BFu0i_I_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_I_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_I_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu8ll(Test_BFu0i_I_BFu8ll, "BFu0i_I_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu8s  {
  unsigned int  :0;
  int v1;
  unsigned short v2:8;
};
//SIG(1 BFu0i_I_BFu8s) C1{ Fi:0 Fi Fs:8}



static void Test_BFu0i_I_BFu8s()
{
  {
    init_simple_test("BFu0i_I_BFu8s");
    static BFu0i_I_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu0i_I_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu0i_I_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu8s(Test_BFu0i_I_BFu8s, "BFu0i_I_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu9i  {
  unsigned int  :0;
  int v1;
  unsigned int v2:9;
};
//SIG(1 BFu0i_I_BFu9i) C1{ Fi:0 Fi Fi:9}



static void Test_BFu0i_I_BFu9i()
{
  {
    init_simple_test("BFu0i_I_BFu9i");
    static BFu0i_I_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_I_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_I_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu9i(Test_BFu0i_I_BFu9i, "BFu0i_I_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu9ll  {
  unsigned int  :0;
  int v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_I_BFu9ll) C1{ Fi:0 Fi FL:9}



static void Test_BFu0i_I_BFu9ll()
{
  {
    init_simple_test("BFu0i_I_BFu9ll");
    static BFu0i_I_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_I_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_I_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu9ll(Test_BFu0i_I_BFu9ll, "BFu0i_I_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_BFu9s  {
  unsigned int  :0;
  int v1;
  unsigned short v2:9;
};
//SIG(1 BFu0i_I_BFu9s) C1{ Fi:0 Fi Fs:9}



static void Test_BFu0i_I_BFu9s()
{
  {
    init_simple_test("BFu0i_I_BFu9s");
    static BFu0i_I_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0i_I_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu0i_I_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu0i_I_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_I_BFu9s(Test_BFu0i_I_BFu9s, "BFu0i_I_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_C  {
  unsigned int  :0;
  int v1;
  char v2;
};
//SIG(1 BFu0i_I_C) C1{ Fi:0 Fi Fc}



static void Test_BFu0i_I_C()
{
  {
    init_simple_test("BFu0i_I_C");
    static BFu0i_I_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_C)");
    check_field_offset(lv, v1, 0, "BFu0i_I_C.v1");
    check_field_offset(lv, v2, 4, "BFu0i_I_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_I_C(Test_BFu0i_I_C, "BFu0i_I_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_D  {
  unsigned int  :0;
  int v1;
  double v2;
};
//SIG(1 BFu0i_I_D) C1{ Fi:0 Fi FL}



static void Test_BFu0i_I_D()
{
  {
    init_simple_test("BFu0i_I_D");
    static BFu0i_I_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_I_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_D)");
    check_field_offset(lv, v1, 0, "BFu0i_I_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_I_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_I_D(Test_BFu0i_I_D, "BFu0i_I_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_F  {
  unsigned int  :0;
  int v1;
  float v2;
};
//SIG(1 BFu0i_I_F) C1{ Fi:0 Fi[2]}



static void Test_BFu0i_I_F()
{
  {
    init_simple_test("BFu0i_I_F");
    static BFu0i_I_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_F)");
    check_field_offset(lv, v1, 0, "BFu0i_I_F.v1");
    check_field_offset(lv, v2, 4, "BFu0i_I_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_I_F(Test_BFu0i_I_F, "BFu0i_I_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_I  {
  unsigned int  :0;
  int v1;
  int v2;
};
//SIG(1 BFu0i_I_I) C1{ Fi:0 Fi[2]}



static void Test_BFu0i_I_I()
{
  {
    init_simple_test("BFu0i_I_I");
    static BFu0i_I_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_I)");
    check_field_offset(lv, v1, 0, "BFu0i_I_I.v1");
    check_field_offset(lv, v2, 4, "BFu0i_I_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_I_I(Test_BFu0i_I_I, "BFu0i_I_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_Ip  {
  unsigned int  :0;
  int v1;
  int *v2;
};
//SIG(1 BFu0i_I_Ip) C1{ Fi:0 Fi Fp}



static void Test_BFu0i_I_Ip()
{
  {
    init_simple_test("BFu0i_I_Ip");
    static BFu0i_I_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_I_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_Ip)");
    check_field_offset(lv, v1, 0, "BFu0i_I_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_I_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_I_Ip(Test_BFu0i_I_Ip, "BFu0i_I_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_L  {
  unsigned int  :0;
  int v1;
  __tsi64 v2;
};
//SIG(1 BFu0i_I_L) C1{ Fi:0 Fi FL}



static void Test_BFu0i_I_L()
{
  {
    init_simple_test("BFu0i_I_L");
    static BFu0i_I_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_I_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_L)");
    check_field_offset(lv, v1, 0, "BFu0i_I_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_I_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_I_L(Test_BFu0i_I_L, "BFu0i_I_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_S  {
  unsigned int  :0;
  int v1;
  short v2;
};
//SIG(1 BFu0i_I_S) C1{ Fi:0 Fi Fs}



static void Test_BFu0i_I_S()
{
  {
    init_simple_test("BFu0i_I_S");
    static BFu0i_I_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_S)");
    check_field_offset(lv, v1, 0, "BFu0i_I_S.v1");
    check_field_offset(lv, v2, 4, "BFu0i_I_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_I_S(Test_BFu0i_I_S, "BFu0i_I_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_Uc  {
  unsigned int  :0;
  int v1;
  unsigned char v2;
};
//SIG(1 BFu0i_I_Uc) C1{ Fi:0 Fi Fc}



static void Test_BFu0i_I_Uc()
{
  {
    init_simple_test("BFu0i_I_Uc");
    static BFu0i_I_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_Uc)");
    check_field_offset(lv, v1, 0, "BFu0i_I_Uc.v1");
    check_field_offset(lv, v2, 4, "BFu0i_I_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_I_Uc(Test_BFu0i_I_Uc, "BFu0i_I_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_Ui  {
  unsigned int  :0;
  int v1;
  unsigned int v2;
};
//SIG(1 BFu0i_I_Ui) C1{ Fi:0 Fi[2]}



static void Test_BFu0i_I_Ui()
{
  {
    init_simple_test("BFu0i_I_Ui");
    static BFu0i_I_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_Ui)");
    check_field_offset(lv, v1, 0, "BFu0i_I_Ui.v1");
    check_field_offset(lv, v2, 4, "BFu0i_I_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_I_Ui(Test_BFu0i_I_Ui, "BFu0i_I_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_Ul  {
  unsigned int  :0;
  int v1;
  __tsu64 v2;
};
//SIG(1 BFu0i_I_Ul) C1{ Fi:0 Fi FL}



static void Test_BFu0i_I_Ul()
{
  {
    init_simple_test("BFu0i_I_Ul");
    static BFu0i_I_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_I_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_Ul)");
    check_field_offset(lv, v1, 0, "BFu0i_I_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_I_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_I_Ul(Test_BFu0i_I_Ul, "BFu0i_I_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_Us  {
  unsigned int  :0;
  int v1;
  unsigned short v2;
};
//SIG(1 BFu0i_I_Us) C1{ Fi:0 Fi Fs}



static void Test_BFu0i_I_Us()
{
  {
    init_simple_test("BFu0i_I_Us");
    static BFu0i_I_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_I_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_I_Us)");
    check_field_offset(lv, v1, 0, "BFu0i_I_Us.v1");
    check_field_offset(lv, v2, 4, "BFu0i_I_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_I_Us(Test_BFu0i_I_Us, "BFu0i_I_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_I_Vp  {
  unsigned int  :0;
  int v1;
  void *v2;
};
//SIG(1 BFu0i_I_Vp) C1{ Fi:0 Fi Fp}



static void Test_BFu0i_I_Vp()
{
  {
    init_simple_test("BFu0i_I_Vp");
    static BFu0i_I_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_I_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_I_Vp)");
    check_field_offset(lv, v1, 0, "BFu0i_I_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_I_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_I_Vp(Test_BFu0i_I_Vp, "BFu0i_I_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip  {
  unsigned int  :0;
  int *v1;
};
//SIG(1 BFu0i_Ip) C1{ Fi:0 Fp}



static void Test_BFu0i_Ip()
{
  {
    init_simple_test("BFu0i_Ip");
    static BFu0i_Ip lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip(Test_BFu0i_Ip, "BFu0i_Ip", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu0c  {
  unsigned int  :0;
  int *v1;
  unsigned char  :0;
};
//SIG(1 BFu0i_Ip_BFu0c) C1{ Fi:0 Fp Fc:0}



static void Test_BFu0i_Ip_BFu0c()
{
  {
    init_simple_test("BFu0i_Ip_BFu0c");
    static BFu0i_Ip_BFu0c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_Ip_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu0c(Test_BFu0i_Ip_BFu0c, "BFu0i_Ip_BFu0c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu0i  {
  unsigned int  :0;
  int *v1;
  unsigned int  :0;
};
//SIG(1 BFu0i_Ip_BFu0i) C1{ Fi:0 Fp Fi:0}



static void Test_BFu0i_Ip_BFu0i()
{
  {
    init_simple_test("BFu0i_Ip_BFu0i");
    static BFu0i_Ip_BFu0i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_Ip_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu0i(Test_BFu0i_Ip_BFu0i, "BFu0i_Ip_BFu0i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu0ll  {
  unsigned int  :0;
  int *v1;
  __tsu64  :0;
};
//SIG(1 BFu0i_Ip_BFu0ll) C1{ Fi:0 Fp FL:0}



static void Test_BFu0i_Ip_BFu0ll()
{
  {
    init_simple_test("BFu0i_Ip_BFu0ll");
    static BFu0i_Ip_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_Ip_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu0ll(Test_BFu0i_Ip_BFu0ll, "BFu0i_Ip_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu0s  {
  unsigned int  :0;
  int *v1;
  unsigned short  :0;
};
//SIG(1 BFu0i_Ip_BFu0s) C1{ Fi:0 Fp Fs:0}



static void Test_BFu0i_Ip_BFu0s()
{
  {
    init_simple_test("BFu0i_Ip_BFu0s");
    static BFu0i_Ip_BFu0s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_Ip_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu0s(Test_BFu0i_Ip_BFu0s, "BFu0i_Ip_BFu0s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu15i  {
  unsigned int  :0;
  int *v1;
  unsigned int v2:15;
};
//SIG(1 BFu0i_Ip_BFu15i) C1{ Fi:0 Fp Fi:15}



static void Test_BFu0i_Ip_BFu15i()
{
  {
    init_simple_test("BFu0i_Ip_BFu15i");
    static BFu0i_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0i_Ip_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0i_Ip_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu15i(Test_BFu0i_Ip_BFu15i, "BFu0i_Ip_BFu15i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu15ll  {
  unsigned int  :0;
  int *v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_Ip_BFu15ll) C1{ Fi:0 Fp FL:15}



static void Test_BFu0i_Ip_BFu15ll()
{
  {
    init_simple_test("BFu0i_Ip_BFu15ll");
    static BFu0i_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0i_Ip_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0i_Ip_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu15ll(Test_BFu0i_Ip_BFu15ll, "BFu0i_Ip_BFu15ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu15s  {
  unsigned int  :0;
  int *v1;
  unsigned short v2:15;
};
//SIG(1 BFu0i_Ip_BFu15s) C1{ Fi:0 Fp Fs:15}



static void Test_BFu0i_Ip_BFu15s()
{
  {
    init_simple_test("BFu0i_Ip_BFu15s");
    static BFu0i_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "BFu0i_Ip_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "BFu0i_Ip_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu15s(Test_BFu0i_Ip_BFu15s, "BFu0i_Ip_BFu15s", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu16i  {
  unsigned int  :0;
  int *v1;
  unsigned int v2:16;
};
//SIG(1 BFu0i_Ip_BFu16i) C1{ Fi:0 Fp Fi:16}



static void Test_BFu0i_Ip_BFu16i()
{
  {
    init_simple_test("BFu0i_Ip_BFu16i");
    static BFu0i_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0i_Ip_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0i_Ip_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu16i(Test_BFu0i_Ip_BFu16i, "BFu0i_Ip_BFu16i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu16ll  {
  unsigned int  :0;
  int *v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_Ip_BFu16ll) C1{ Fi:0 Fp FL:16}



static void Test_BFu0i_Ip_BFu16ll()
{
  {
    init_simple_test("BFu0i_Ip_BFu16ll");
    static BFu0i_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0i_Ip_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0i_Ip_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu16ll(Test_BFu0i_Ip_BFu16ll, "BFu0i_Ip_BFu16ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu16s  {
  unsigned int  :0;
  int *v1;
  unsigned short v2:16;
};
//SIG(1 BFu0i_Ip_BFu16s) C1{ Fi:0 Fp Fs:16}



static void Test_BFu0i_Ip_BFu16s()
{
  {
    init_simple_test("BFu0i_Ip_BFu16s");
    static BFu0i_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "BFu0i_Ip_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "BFu0i_Ip_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu16s(Test_BFu0i_Ip_BFu16s, "BFu0i_Ip_BFu16s", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu17i  {
  unsigned int  :0;
  int *v1;
  unsigned int v2:17;
};
//SIG(1 BFu0i_Ip_BFu17i) C1{ Fi:0 Fp Fi:17}



static void Test_BFu0i_Ip_BFu17i()
{
  {
    init_simple_test("BFu0i_Ip_BFu17i");
    static BFu0i_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu0i_Ip_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu0i_Ip_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu17i(Test_BFu0i_Ip_BFu17i, "BFu0i_Ip_BFu17i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu17ll  {
  unsigned int  :0;
  int *v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_Ip_BFu17ll) C1{ Fi:0 Fp FL:17}



static void Test_BFu0i_Ip_BFu17ll()
{
  {
    init_simple_test("BFu0i_Ip_BFu17ll");
    static BFu0i_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "BFu0i_Ip_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "BFu0i_Ip_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu17ll(Test_BFu0i_Ip_BFu17ll, "BFu0i_Ip_BFu17ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu1c  {
  unsigned int  :0;
  int *v1;
  unsigned char v2:1;
};
//SIG(1 BFu0i_Ip_BFu1c) C1{ Fi:0 Fp Fc:1}



static void Test_BFu0i_Ip_BFu1c()
{
  {
    init_simple_test("BFu0i_Ip_BFu1c");
    static BFu0i_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0i_Ip_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu1c(Test_BFu0i_Ip_BFu1c, "BFu0i_Ip_BFu1c", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu1i  {
  unsigned int  :0;
  int *v1;
  unsigned int v2:1;
};
//SIG(1 BFu0i_Ip_BFu1i) C1{ Fi:0 Fp Fi:1}



static void Test_BFu0i_Ip_BFu1i()
{
  {
    init_simple_test("BFu0i_Ip_BFu1i");
    static BFu0i_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0i_Ip_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu1i(Test_BFu0i_Ip_BFu1i, "BFu0i_Ip_BFu1i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu1ll  {
  unsigned int  :0;
  int *v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_Ip_BFu1ll) C1{ Fi:0 Fp FL:1}



static void Test_BFu0i_Ip_BFu1ll()
{
  {
    init_simple_test("BFu0i_Ip_BFu1ll");
    static BFu0i_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0i_Ip_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu1ll(Test_BFu0i_Ip_BFu1ll, "BFu0i_Ip_BFu1ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu1s  {
  unsigned int  :0;
  int *v1;
  unsigned short v2:1;
};
//SIG(1 BFu0i_Ip_BFu1s) C1{ Fi:0 Fp Fs:1}



static void Test_BFu0i_Ip_BFu1s()
{
  {
    init_simple_test("BFu0i_Ip_BFu1s");
    static BFu0i_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "BFu0i_Ip_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu1s(Test_BFu0i_Ip_BFu1s, "BFu0i_Ip_BFu1s", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu31i  {
  unsigned int  :0;
  int *v1;
  unsigned int v2:31;
};
//SIG(1 BFu0i_Ip_BFu31i) C1{ Fi:0 Fp Fi:31}



static void Test_BFu0i_Ip_BFu31i()
{
  {
    init_simple_test("BFu0i_Ip_BFu31i");
    static BFu0i_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu0i_Ip_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu0i_Ip_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu31i(Test_BFu0i_Ip_BFu31i, "BFu0i_Ip_BFu31i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu31ll  {
  unsigned int  :0;
  int *v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_Ip_BFu31ll) C1{ Fi:0 Fp FL:31}



static void Test_BFu0i_Ip_BFu31ll()
{
  {
    init_simple_test("BFu0i_Ip_BFu31ll");
    static BFu0i_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "BFu0i_Ip_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "BFu0i_Ip_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu31ll(Test_BFu0i_Ip_BFu31ll, "BFu0i_Ip_BFu31ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu32i  {
  unsigned int  :0;
  int *v1;
  unsigned int v2:32;
};
//SIG(1 BFu0i_Ip_BFu32i) C1{ Fi:0 Fp Fi:32}



static void Test_BFu0i_Ip_BFu32i()
{
  {
    init_simple_test("BFu0i_Ip_BFu32i");
    static BFu0i_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu0i_Ip_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu0i_Ip_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu32i(Test_BFu0i_Ip_BFu32i, "BFu0i_Ip_BFu32i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu32ll  {
  unsigned int  :0;
  int *v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_Ip_BFu32ll) C1{ Fi:0 Fp FL:32}



static void Test_BFu0i_Ip_BFu32ll()
{
  {
    init_simple_test("BFu0i_Ip_BFu32ll");
    static BFu0i_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "BFu0i_Ip_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "BFu0i_Ip_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu32ll(Test_BFu0i_Ip_BFu32ll, "BFu0i_Ip_BFu32ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu33  {
  unsigned int  :0;
  int *v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_Ip_BFu33) C1{ Fi:0 Fp FL:33}



static void Test_BFu0i_Ip_BFu33()
{
  {
    init_simple_test("BFu0i_Ip_BFu33");
    static BFu0i_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_Ip_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "BFu0i_Ip_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu0i_Ip_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu33(Test_BFu0i_Ip_BFu33, "BFu0i_Ip_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu7c  {
  unsigned int  :0;
  int *v1;
  unsigned char v2:7;
};
//SIG(1 BFu0i_Ip_BFu7c) C1{ Fi:0 Fp Fc:7}



static void Test_BFu0i_Ip_BFu7c()
{
  {
    init_simple_test("BFu0i_Ip_BFu7c");
    static BFu0i_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0i_Ip_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0i_Ip_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu7c(Test_BFu0i_Ip_BFu7c, "BFu0i_Ip_BFu7c", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu7i  {
  unsigned int  :0;
  int *v1;
  unsigned int v2:7;
};
//SIG(1 BFu0i_Ip_BFu7i) C1{ Fi:0 Fp Fi:7}



static void Test_BFu0i_Ip_BFu7i()
{
  {
    init_simple_test("BFu0i_Ip_BFu7i");
    static BFu0i_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0i_Ip_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0i_Ip_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu7i(Test_BFu0i_Ip_BFu7i, "BFu0i_Ip_BFu7i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu7ll  {
  unsigned int  :0;
  int *v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_Ip_BFu7ll) C1{ Fi:0 Fp FL:7}



static void Test_BFu0i_Ip_BFu7ll()
{
  {
    init_simple_test("BFu0i_Ip_BFu7ll");
    static BFu0i_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0i_Ip_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0i_Ip_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu7ll(Test_BFu0i_Ip_BFu7ll, "BFu0i_Ip_BFu7ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu7s  {
  unsigned int  :0;
  int *v1;
  unsigned short v2:7;
};
//SIG(1 BFu0i_Ip_BFu7s) C1{ Fi:0 Fp Fs:7}



static void Test_BFu0i_Ip_BFu7s()
{
  {
    init_simple_test("BFu0i_Ip_BFu7s");
    static BFu0i_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "BFu0i_Ip_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "BFu0i_Ip_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu7s(Test_BFu0i_Ip_BFu7s, "BFu0i_Ip_BFu7s", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu8c  {
  unsigned int  :0;
  int *v1;
  unsigned char v2:8;
};
//SIG(1 BFu0i_Ip_BFu8c) C1{ Fi:0 Fp Fc:8}



static void Test_BFu0i_Ip_BFu8c()
{
  {
    init_simple_test("BFu0i_Ip_BFu8c");
    static BFu0i_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0i_Ip_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0i_Ip_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu8c(Test_BFu0i_Ip_BFu8c, "BFu0i_Ip_BFu8c", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu8i  {
  unsigned int  :0;
  int *v1;
  unsigned int v2:8;
};
//SIG(1 BFu0i_Ip_BFu8i) C1{ Fi:0 Fp Fi:8}



static void Test_BFu0i_Ip_BFu8i()
{
  {
    init_simple_test("BFu0i_Ip_BFu8i");
    static BFu0i_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0i_Ip_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0i_Ip_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu8i(Test_BFu0i_Ip_BFu8i, "BFu0i_Ip_BFu8i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu8ll  {
  unsigned int  :0;
  int *v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_Ip_BFu8ll) C1{ Fi:0 Fp FL:8}



static void Test_BFu0i_Ip_BFu8ll()
{
  {
    init_simple_test("BFu0i_Ip_BFu8ll");
    static BFu0i_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0i_Ip_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0i_Ip_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu8ll(Test_BFu0i_Ip_BFu8ll, "BFu0i_Ip_BFu8ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu8s  {
  unsigned int  :0;
  int *v1;
  unsigned short v2:8;
};
//SIG(1 BFu0i_Ip_BFu8s) C1{ Fi:0 Fp Fs:8}



static void Test_BFu0i_Ip_BFu8s()
{
  {
    init_simple_test("BFu0i_Ip_BFu8s");
    static BFu0i_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "BFu0i_Ip_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "BFu0i_Ip_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu8s(Test_BFu0i_Ip_BFu8s, "BFu0i_Ip_BFu8s", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu9i  {
  unsigned int  :0;
  int *v1;
  unsigned int v2:9;
};
//SIG(1 BFu0i_Ip_BFu9i) C1{ Fi:0 Fp Fi:9}



static void Test_BFu0i_Ip_BFu9i()
{
  {
    init_simple_test("BFu0i_Ip_BFu9i");
    static BFu0i_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0i_Ip_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0i_Ip_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu9i(Test_BFu0i_Ip_BFu9i, "BFu0i_Ip_BFu9i", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu9ll  {
  unsigned int  :0;
  int *v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_Ip_BFu9ll) C1{ Fi:0 Fp FL:9}



static void Test_BFu0i_Ip_BFu9ll()
{
  {
    init_simple_test("BFu0i_Ip_BFu9ll");
    static BFu0i_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0i_Ip_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0i_Ip_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu9ll(Test_BFu0i_Ip_BFu9ll, "BFu0i_Ip_BFu9ll", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_BFu9s  {
  unsigned int  :0;
  int *v1;
  unsigned short v2:9;
};
//SIG(1 BFu0i_Ip_BFu9s) C1{ Fi:0 Fp Fs:9}



static void Test_BFu0i_Ip_BFu9s()
{
  {
    init_simple_test("BFu0i_Ip_BFu9s");
    static BFu0i_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "BFu0i_Ip_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "BFu0i_Ip_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_BFu9s(Test_BFu0i_Ip_BFu9s, "BFu0i_Ip_BFu9s", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_C  {
  unsigned int  :0;
  int *v1;
  char v2;
};
//SIG(1 BFu0i_Ip_C) C1{ Fi:0 Fp Fc}



static void Test_BFu0i_Ip_C()
{
  {
    init_simple_test("BFu0i_Ip_C");
    static BFu0i_Ip_C lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_C)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_Ip_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_C(Test_BFu0i_Ip_C, "BFu0i_Ip_C", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_D  {
  unsigned int  :0;
  int *v1;
  double v2;
};
//SIG(1 BFu0i_Ip_D) C1{ Fi:0 Fp FL}



static void Test_BFu0i_Ip_D()
{
  {
    init_simple_test("BFu0i_Ip_D");
    static BFu0i_Ip_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_Ip_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_D)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_Ip_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_D(Test_BFu0i_Ip_D, "BFu0i_Ip_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_F  {
  unsigned int  :0;
  int *v1;
  float v2;
};
//SIG(1 BFu0i_Ip_F) C1{ Fi:0 Fp Fi}



static void Test_BFu0i_Ip_F()
{
  {
    init_simple_test("BFu0i_Ip_F");
    static BFu0i_Ip_F lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_F)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_Ip_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_F(Test_BFu0i_Ip_F, "BFu0i_Ip_F", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_I  {
  unsigned int  :0;
  int *v1;
  int v2;
};
//SIG(1 BFu0i_Ip_I) C1{ Fi:0 Fp Fi}



static void Test_BFu0i_Ip_I()
{
  {
    init_simple_test("BFu0i_Ip_I");
    static BFu0i_Ip_I lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_I)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_Ip_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_I(Test_BFu0i_Ip_I, "BFu0i_Ip_I", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_Ip  {
  unsigned int  :0;
  int *v1;
  int *v2;
};
//SIG(1 BFu0i_Ip_Ip) C1{ Fi:0 Fp[2]}



static void Test_BFu0i_Ip_Ip()
{
  {
    init_simple_test("BFu0i_Ip_Ip");
    static BFu0i_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_Ip)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_Ip_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_Ip(Test_BFu0i_Ip_Ip, "BFu0i_Ip_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_L  {
  unsigned int  :0;
  int *v1;
  __tsi64 v2;
};
//SIG(1 BFu0i_Ip_L) C1{ Fi:0 Fp FL}



static void Test_BFu0i_Ip_L()
{
  {
    init_simple_test("BFu0i_Ip_L");
    static BFu0i_Ip_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_Ip_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_L)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_Ip_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_L(Test_BFu0i_Ip_L, "BFu0i_Ip_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_S  {
  unsigned int  :0;
  int *v1;
  short v2;
};
//SIG(1 BFu0i_Ip_S) C1{ Fi:0 Fp Fs}



static void Test_BFu0i_Ip_S()
{
  {
    init_simple_test("BFu0i_Ip_S");
    static BFu0i_Ip_S lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_S)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_Ip_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_S(Test_BFu0i_Ip_S, "BFu0i_Ip_S", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_Uc  {
  unsigned int  :0;
  int *v1;
  unsigned char v2;
};
//SIG(1 BFu0i_Ip_Uc) C1{ Fi:0 Fp Fc}



static void Test_BFu0i_Ip_Uc()
{
  {
    init_simple_test("BFu0i_Ip_Uc");
    static BFu0i_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_Uc)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_Ip_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_Uc(Test_BFu0i_Ip_Uc, "BFu0i_Ip_Uc", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_Ui  {
  unsigned int  :0;
  int *v1;
  unsigned int v2;
};
//SIG(1 BFu0i_Ip_Ui) C1{ Fi:0 Fp Fi}



static void Test_BFu0i_Ip_Ui()
{
  {
    init_simple_test("BFu0i_Ip_Ui");
    static BFu0i_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_Ui)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_Ip_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_Ui(Test_BFu0i_Ip_Ui, "BFu0i_Ip_Ui", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_Ul  {
  unsigned int  :0;
  int *v1;
  __tsu64 v2;
};
//SIG(1 BFu0i_Ip_Ul) C1{ Fi:0 Fp FL}



static void Test_BFu0i_Ip_Ul()
{
  {
    init_simple_test("BFu0i_Ip_Ul");
    static BFu0i_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_Ip_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_Ul)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_Ip_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_Ul(Test_BFu0i_Ip_Ul, "BFu0i_Ip_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_Us  {
  unsigned int  :0;
  int *v1;
  unsigned short v2;
};
//SIG(1 BFu0i_Ip_Us) C1{ Fi:0 Fp Fs}



static void Test_BFu0i_Ip_Us()
{
  {
    init_simple_test("BFu0i_Ip_Us");
    static BFu0i_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_Us)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_Ip_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_Us(Test_BFu0i_Ip_Us, "BFu0i_Ip_Us", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_Ip_Vp  {
  unsigned int  :0;
  int *v1;
  void *v2;
};
//SIG(1 BFu0i_Ip_Vp) C1{ Fi:0 Fp[2]}



static void Test_BFu0i_Ip_Vp()
{
  {
    init_simple_test("BFu0i_Ip_Vp");
    static BFu0i_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu0i_Ip_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_Ip_Vp)");
    check_field_offset(lv, v1, 0, "BFu0i_Ip_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu0i_Ip_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_Ip_Vp(Test_BFu0i_Ip_Vp, "BFu0i_Ip_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L  {
  unsigned int  :0;
  __tsi64 v1;
};
//SIG(1 BFu0i_L) C1{ Fi:0 FL}



static void Test_BFu0i_L()
{
  {
    init_simple_test("BFu0i_L");
    static BFu0i_L lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L)");
    check_field_offset(lv, v1, 0, "BFu0i_L.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_L(Test_BFu0i_L, "BFu0i_L", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu0c  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned char  :0;
};
//SIG(1 BFu0i_L_BFu0c) C1{ Fi:0 FL Fc:0}



static void Test_BFu0i_L_BFu0c()
{
  {
    init_simple_test("BFu0i_L_BFu0c");
    static BFu0i_L_BFu0c lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_L_BFu0c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu0c(Test_BFu0i_L_BFu0c, "BFu0i_L_BFu0c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu0i  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned int  :0;
};
//SIG(1 BFu0i_L_BFu0i) C1{ Fi:0 FL Fi:0}



static void Test_BFu0i_L_BFu0i()
{
  {
    init_simple_test("BFu0i_L_BFu0i");
    static BFu0i_L_BFu0i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_L_BFu0i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu0i(Test_BFu0i_L_BFu0i, "BFu0i_L_BFu0i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu0ll  {
  unsigned int  :0;
  __tsi64 v1;
  __tsu64  :0;
};
//SIG(1 BFu0i_L_BFu0ll) C1{ Fi:0 FL FL:0}



static void Test_BFu0i_L_BFu0ll()
{
  {
    init_simple_test("BFu0i_L_BFu0ll");
    static BFu0i_L_BFu0ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_L_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu0ll(Test_BFu0i_L_BFu0ll, "BFu0i_L_BFu0ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu0s  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned short  :0;
};
//SIG(1 BFu0i_L_BFu0s) C1{ Fi:0 FL Fs:0}



static void Test_BFu0i_L_BFu0s()
{
  {
    init_simple_test("BFu0i_L_BFu0s");
    static BFu0i_L_BFu0s lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_L_BFu0s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu0s(Test_BFu0i_L_BFu0s, "BFu0i_L_BFu0s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu15i  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned int v2:15;
};
//SIG(1 BFu0i_L_BFu15i) C1{ Fi:0 FL Fi:15}



static void Test_BFu0i_L_BFu15i()
{
  {
    init_simple_test("BFu0i_L_BFu15i");
    static BFu0i_L_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0i_L_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0i_L_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu15i(Test_BFu0i_L_BFu15i, "BFu0i_L_BFu15i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu15ll  {
  unsigned int  :0;
  __tsi64 v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_L_BFu15ll) C1{ Fi:0 FL FL:15}



static void Test_BFu0i_L_BFu15ll()
{
  {
    init_simple_test("BFu0i_L_BFu15ll");
    static BFu0i_L_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0i_L_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0i_L_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu15ll(Test_BFu0i_L_BFu15ll, "BFu0i_L_BFu15ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu15s  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned short v2:15;
};
//SIG(1 BFu0i_L_BFu15s) C1{ Fi:0 FL Fs:15}



static void Test_BFu0i_L_BFu15s()
{
  {
    init_simple_test("BFu0i_L_BFu15s");
    static BFu0i_L_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "BFu0i_L_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "BFu0i_L_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu15s(Test_BFu0i_L_BFu15s, "BFu0i_L_BFu15s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu16i  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned int v2:16;
};
//SIG(1 BFu0i_L_BFu16i) C1{ Fi:0 FL Fi:16}



static void Test_BFu0i_L_BFu16i()
{
  {
    init_simple_test("BFu0i_L_BFu16i");
    static BFu0i_L_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0i_L_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0i_L_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu16i(Test_BFu0i_L_BFu16i, "BFu0i_L_BFu16i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu16ll  {
  unsigned int  :0;
  __tsi64 v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_L_BFu16ll) C1{ Fi:0 FL FL:16}



static void Test_BFu0i_L_BFu16ll()
{
  {
    init_simple_test("BFu0i_L_BFu16ll");
    static BFu0i_L_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0i_L_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0i_L_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu16ll(Test_BFu0i_L_BFu16ll, "BFu0i_L_BFu16ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu16s  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned short v2:16;
};
//SIG(1 BFu0i_L_BFu16s) C1{ Fi:0 FL Fs:16}



static void Test_BFu0i_L_BFu16s()
{
  {
    init_simple_test("BFu0i_L_BFu16s");
    static BFu0i_L_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "BFu0i_L_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "BFu0i_L_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu16s(Test_BFu0i_L_BFu16s, "BFu0i_L_BFu16s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu17i  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned int v2:17;
};
//SIG(1 BFu0i_L_BFu17i) C1{ Fi:0 FL Fi:17}



static void Test_BFu0i_L_BFu17i()
{
  {
    init_simple_test("BFu0i_L_BFu17i");
    static BFu0i_L_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0i_L_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0i_L_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu17i(Test_BFu0i_L_BFu17i, "BFu0i_L_BFu17i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu17ll  {
  unsigned int  :0;
  __tsi64 v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_L_BFu17ll) C1{ Fi:0 FL FL:17}



static void Test_BFu0i_L_BFu17ll()
{
  {
    init_simple_test("BFu0i_L_BFu17ll");
    static BFu0i_L_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 17, 1, "BFu0i_L_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 17, hide_ull(1LL<<16), "BFu0i_L_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu17ll(Test_BFu0i_L_BFu17ll, "BFu0i_L_BFu17ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu1c  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned char v2:1;
};
//SIG(1 BFu0i_L_BFu1c) C1{ Fi:0 FL Fc:1}



static void Test_BFu0i_L_BFu1c()
{
  {
    init_simple_test("BFu0i_L_BFu1c");
    static BFu0i_L_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0i_L_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu1c(Test_BFu0i_L_BFu1c, "BFu0i_L_BFu1c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu1i  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned int v2:1;
};
//SIG(1 BFu0i_L_BFu1i) C1{ Fi:0 FL Fi:1}



static void Test_BFu0i_L_BFu1i()
{
  {
    init_simple_test("BFu0i_L_BFu1i");
    static BFu0i_L_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0i_L_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu1i(Test_BFu0i_L_BFu1i, "BFu0i_L_BFu1i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu1ll  {
  unsigned int  :0;
  __tsi64 v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_L_BFu1ll) C1{ Fi:0 FL FL:1}



static void Test_BFu0i_L_BFu1ll()
{
  {
    init_simple_test("BFu0i_L_BFu1ll");
    static BFu0i_L_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0i_L_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu1ll(Test_BFu0i_L_BFu1ll, "BFu0i_L_BFu1ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu1s  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned short v2:1;
};
//SIG(1 BFu0i_L_BFu1s) C1{ Fi:0 FL Fs:1}



static void Test_BFu0i_L_BFu1s()
{
  {
    init_simple_test("BFu0i_L_BFu1s");
    static BFu0i_L_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 1, 1, "BFu0i_L_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu1s(Test_BFu0i_L_BFu1s, "BFu0i_L_BFu1s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu31i  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned int v2:31;
};
//SIG(1 BFu0i_L_BFu31i) C1{ Fi:0 FL Fi:31}



static void Test_BFu0i_L_BFu31i()
{
  {
    init_simple_test("BFu0i_L_BFu31i");
    static BFu0i_L_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0i_L_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0i_L_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu31i(Test_BFu0i_L_BFu31i, "BFu0i_L_BFu31i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu31ll  {
  unsigned int  :0;
  __tsi64 v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_L_BFu31ll) C1{ Fi:0 FL FL:31}



static void Test_BFu0i_L_BFu31ll()
{
  {
    init_simple_test("BFu0i_L_BFu31ll");
    static BFu0i_L_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 31, 1, "BFu0i_L_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 31, hide_ull(1LL<<30), "BFu0i_L_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu31ll(Test_BFu0i_L_BFu31ll, "BFu0i_L_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu32i  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned int v2:32;
};
//SIG(1 BFu0i_L_BFu32i) C1{ Fi:0 FL Fi:32}



static void Test_BFu0i_L_BFu32i()
{
  {
    init_simple_test("BFu0i_L_BFu32i");
    static BFu0i_L_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0i_L_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0i_L_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu32i(Test_BFu0i_L_BFu32i, "BFu0i_L_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu32ll  {
  unsigned int  :0;
  __tsi64 v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_L_BFu32ll) C1{ Fi:0 FL FL:32}



static void Test_BFu0i_L_BFu32ll()
{
  {
    init_simple_test("BFu0i_L_BFu32ll");
    static BFu0i_L_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 32, 1, "BFu0i_L_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 32, hide_ull(1LL<<31), "BFu0i_L_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu32ll(Test_BFu0i_L_BFu32ll, "BFu0i_L_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu33  {
  unsigned int  :0;
  __tsi64 v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_L_BFu33) C1{ Fi:0 FL FL:33}



static void Test_BFu0i_L_BFu33()
{
  {
    init_simple_test("BFu0i_L_BFu33");
    static BFu0i_L_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(BFu0i_L_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 33, 1, "BFu0i_L_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 33, hide_ull(1LL<<32), "BFu0i_L_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu33(Test_BFu0i_L_BFu33, "BFu0i_L_BFu33", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu7c  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned char v2:7;
};
//SIG(1 BFu0i_L_BFu7c) C1{ Fi:0 FL Fc:7}



static void Test_BFu0i_L_BFu7c()
{
  {
    init_simple_test("BFu0i_L_BFu7c");
    static BFu0i_L_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0i_L_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0i_L_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu7c(Test_BFu0i_L_BFu7c, "BFu0i_L_BFu7c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu7i  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned int v2:7;
};
//SIG(1 BFu0i_L_BFu7i) C1{ Fi:0 FL Fi:7}



static void Test_BFu0i_L_BFu7i()
{
  {
    init_simple_test("BFu0i_L_BFu7i");
    static BFu0i_L_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0i_L_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0i_L_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu7i(Test_BFu0i_L_BFu7i, "BFu0i_L_BFu7i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu7ll  {
  unsigned int  :0;
  __tsi64 v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_L_BFu7ll) C1{ Fi:0 FL FL:7}



static void Test_BFu0i_L_BFu7ll()
{
  {
    init_simple_test("BFu0i_L_BFu7ll");
    static BFu0i_L_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0i_L_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0i_L_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu7ll(Test_BFu0i_L_BFu7ll, "BFu0i_L_BFu7ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu7s  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned short v2:7;
};
//SIG(1 BFu0i_L_BFu7s) C1{ Fi:0 FL Fs:7}



static void Test_BFu0i_L_BFu7s()
{
  {
    init_simple_test("BFu0i_L_BFu7s");
    static BFu0i_L_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 7, 1, "BFu0i_L_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 7, hide_ull(1LL<<6), "BFu0i_L_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu7s(Test_BFu0i_L_BFu7s, "BFu0i_L_BFu7s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu8c  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned char v2:8;
};
//SIG(1 BFu0i_L_BFu8c) C1{ Fi:0 FL Fc:8}



static void Test_BFu0i_L_BFu8c()
{
  {
    init_simple_test("BFu0i_L_BFu8c");
    static BFu0i_L_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0i_L_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0i_L_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu8c(Test_BFu0i_L_BFu8c, "BFu0i_L_BFu8c", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu8i  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned int v2:8;
};
//SIG(1 BFu0i_L_BFu8i) C1{ Fi:0 FL Fi:8}



static void Test_BFu0i_L_BFu8i()
{
  {
    init_simple_test("BFu0i_L_BFu8i");
    static BFu0i_L_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0i_L_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0i_L_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu8i(Test_BFu0i_L_BFu8i, "BFu0i_L_BFu8i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu8ll  {
  unsigned int  :0;
  __tsi64 v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_L_BFu8ll) C1{ Fi:0 FL FL:8}



static void Test_BFu0i_L_BFu8ll()
{
  {
    init_simple_test("BFu0i_L_BFu8ll");
    static BFu0i_L_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0i_L_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0i_L_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu8ll(Test_BFu0i_L_BFu8ll, "BFu0i_L_BFu8ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu8s  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned short v2:8;
};
//SIG(1 BFu0i_L_BFu8s) C1{ Fi:0 FL Fs:8}



static void Test_BFu0i_L_BFu8s()
{
  {
    init_simple_test("BFu0i_L_BFu8s");
    static BFu0i_L_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "BFu0i_L_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "BFu0i_L_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu8s(Test_BFu0i_L_BFu8s, "BFu0i_L_BFu8s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu9i  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned int v2:9;
};
//SIG(1 BFu0i_L_BFu9i) C1{ Fi:0 FL Fi:9}



static void Test_BFu0i_L_BFu9i()
{
  {
    init_simple_test("BFu0i_L_BFu9i");
    static BFu0i_L_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0i_L_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0i_L_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu9i(Test_BFu0i_L_BFu9i, "BFu0i_L_BFu9i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu9ll  {
  unsigned int  :0;
  __tsi64 v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_L_BFu9ll) C1{ Fi:0 FL FL:9}



static void Test_BFu0i_L_BFu9ll()
{
  {
    init_simple_test("BFu0i_L_BFu9ll");
    static BFu0i_L_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0i_L_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0i_L_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu9ll(Test_BFu0i_L_BFu9ll, "BFu0i_L_BFu9ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_BFu9s  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned short v2:9;
};
//SIG(1 BFu0i_L_BFu9s) C1{ Fi:0 FL Fs:9}



static void Test_BFu0i_L_BFu9s()
{
  {
    init_simple_test("BFu0i_L_BFu9s");
    static BFu0i_L_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0i_L_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "BFu0i_L_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "BFu0i_L_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_L_BFu9s(Test_BFu0i_L_BFu9s, "BFu0i_L_BFu9s", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_C  {
  unsigned int  :0;
  __tsi64 v1;
  char v2;
};
//SIG(1 BFu0i_L_C) C1{ Fi:0 FL Fc}



static void Test_BFu0i_L_C()
{
  {
    init_simple_test("BFu0i_L_C");
    static BFu0i_L_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_C)");
    check_field_offset(lv, v1, 0, "BFu0i_L_C.v1");
    check_field_offset(lv, v2, 8, "BFu0i_L_C.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_L_C(Test_BFu0i_L_C, "BFu0i_L_C", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_D  {
  unsigned int  :0;
  __tsi64 v1;
  double v2;
};
//SIG(1 BFu0i_L_D) C1{ Fi:0 FL[2]}



static void Test_BFu0i_L_D()
{
  {
    init_simple_test("BFu0i_L_D");
    static BFu0i_L_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu0i_L_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_D)");
    check_field_offset(lv, v1, 0, "BFu0i_L_D.v1");
    check_field_offset(lv, v2, 8, "BFu0i_L_D.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_L_D(Test_BFu0i_L_D, "BFu0i_L_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_F  {
  unsigned int  :0;
  __tsi64 v1;
  float v2;
};
//SIG(1 BFu0i_L_F) C1{ Fi:0 FL Fi}



static void Test_BFu0i_L_F()
{
  {
    init_simple_test("BFu0i_L_F");
    static BFu0i_L_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_F)");
    check_field_offset(lv, v1, 0, "BFu0i_L_F.v1");
    check_field_offset(lv, v2, 8, "BFu0i_L_F.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_L_F(Test_BFu0i_L_F, "BFu0i_L_F", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_I  {
  unsigned int  :0;
  __tsi64 v1;
  int v2;
};
//SIG(1 BFu0i_L_I) C1{ Fi:0 FL Fi}



static void Test_BFu0i_L_I()
{
  {
    init_simple_test("BFu0i_L_I");
    static BFu0i_L_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_I)");
    check_field_offset(lv, v1, 0, "BFu0i_L_I.v1");
    check_field_offset(lv, v2, 8, "BFu0i_L_I.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_L_I(Test_BFu0i_L_I, "BFu0i_L_I", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_Ip  {
  unsigned int  :0;
  __tsi64 v1;
  int *v2;
};
//SIG(1 BFu0i_L_Ip) C1{ Fi:0 FL Fp}



static void Test_BFu0i_L_Ip()
{
  {
    init_simple_test("BFu0i_L_Ip");
    static BFu0i_L_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_Ip)");
    check_field_offset(lv, v1, 0, "BFu0i_L_Ip.v1");
    check_field_offset(lv, v2, 8, "BFu0i_L_Ip.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_L_Ip(Test_BFu0i_L_Ip, "BFu0i_L_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_L  {
  unsigned int  :0;
  __tsi64 v1;
  __tsi64 v2;
};
//SIG(1 BFu0i_L_L) C1{ Fi:0 FL[2]}



static void Test_BFu0i_L_L()
{
  {
    init_simple_test("BFu0i_L_L");
    static BFu0i_L_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu0i_L_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_L)");
    check_field_offset(lv, v1, 0, "BFu0i_L_L.v1");
    check_field_offset(lv, v2, 8, "BFu0i_L_L.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_L_L(Test_BFu0i_L_L, "BFu0i_L_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_S  {
  unsigned int  :0;
  __tsi64 v1;
  short v2;
};
//SIG(1 BFu0i_L_S) C1{ Fi:0 FL Fs}



static void Test_BFu0i_L_S()
{
  {
    init_simple_test("BFu0i_L_S");
    static BFu0i_L_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_S)");
    check_field_offset(lv, v1, 0, "BFu0i_L_S.v1");
    check_field_offset(lv, v2, 8, "BFu0i_L_S.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_L_S(Test_BFu0i_L_S, "BFu0i_L_S", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_Uc  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned char v2;
};
//SIG(1 BFu0i_L_Uc) C1{ Fi:0 FL Fc}



static void Test_BFu0i_L_Uc()
{
  {
    init_simple_test("BFu0i_L_Uc");
    static BFu0i_L_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_Uc)");
    check_field_offset(lv, v1, 0, "BFu0i_L_Uc.v1");
    check_field_offset(lv, v2, 8, "BFu0i_L_Uc.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_L_Uc(Test_BFu0i_L_Uc, "BFu0i_L_Uc", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_Ui  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned int v2;
};
//SIG(1 BFu0i_L_Ui) C1{ Fi:0 FL Fi}



static void Test_BFu0i_L_Ui()
{
  {
    init_simple_test("BFu0i_L_Ui");
    static BFu0i_L_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_Ui)");
    check_field_offset(lv, v1, 0, "BFu0i_L_Ui.v1");
    check_field_offset(lv, v2, 8, "BFu0i_L_Ui.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_L_Ui(Test_BFu0i_L_Ui, "BFu0i_L_Ui", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_Ul  {
  unsigned int  :0;
  __tsi64 v1;
  __tsu64 v2;
};
//SIG(1 BFu0i_L_Ul) C1{ Fi:0 FL[2]}



static void Test_BFu0i_L_Ul()
{
  {
    init_simple_test("BFu0i_L_Ul");
    static BFu0i_L_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu0i_L_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_Ul)");
    check_field_offset(lv, v1, 0, "BFu0i_L_Ul.v1");
    check_field_offset(lv, v2, 8, "BFu0i_L_Ul.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_L_Ul(Test_BFu0i_L_Ul, "BFu0i_L_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_Us  {
  unsigned int  :0;
  __tsi64 v1;
  unsigned short v2;
};
//SIG(1 BFu0i_L_Us) C1{ Fi:0 FL Fs}



static void Test_BFu0i_L_Us()
{
  {
    init_simple_test("BFu0i_L_Us");
    static BFu0i_L_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_Us)");
    check_field_offset(lv, v1, 0, "BFu0i_L_Us.v1");
    check_field_offset(lv, v2, 8, "BFu0i_L_Us.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_L_Us(Test_BFu0i_L_Us, "BFu0i_L_Us", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_L_Vp  {
  unsigned int  :0;
  __tsi64 v1;
  void *v2;
};
//SIG(1 BFu0i_L_Vp) C1{ Fi:0 FL Fp}



static void Test_BFu0i_L_Vp()
{
  {
    init_simple_test("BFu0i_L_Vp");
    static BFu0i_L_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu0i_L_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_L_Vp)");
    check_field_offset(lv, v1, 0, "BFu0i_L_Vp.v1");
    check_field_offset(lv, v2, 8, "BFu0i_L_Vp.v2");
  }
}
static Arrange_To_Call_Me vBFu0i_L_Vp(Test_BFu0i_L_Vp, "BFu0i_L_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S  {
  unsigned int  :0;
  short v1;
};
//SIG(1 BFu0i_S) C1{ Fi:0 Fs}



static void Test_BFu0i_S()
{
  {
    init_simple_test("BFu0i_S");
    static BFu0i_S lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_S)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_S)");
    check_field_offset(lv, v1, 0, "BFu0i_S.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_S(Test_BFu0i_S, "BFu0i_S", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu0c  {
  unsigned int  :0;
  short v1;
  unsigned char  :0;
};
//SIG(1 BFu0i_S_BFu0c) C1{ Fi:0 Fs Fc:0}



static void Test_BFu0i_S_BFu0c()
{
  {
    init_simple_test("BFu0i_S_BFu0c");
    static BFu0i_S_BFu0c lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_S_BFu0c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_S_BFu0c)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu0c.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu0c(Test_BFu0i_S_BFu0c, "BFu0i_S_BFu0c", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu0i  {
  unsigned int  :0;
  short v1;
  unsigned int  :0;
};
//SIG(1 BFu0i_S_BFu0i) C1{ Fi:0 Fs Fi:0}



static void Test_BFu0i_S_BFu0i()
{
  {
    init_simple_test("BFu0i_S_BFu0i");
    static BFu0i_S_BFu0i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu0i)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_S_BFu0i)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu0i.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu0i(Test_BFu0i_S_BFu0i, "BFu0i_S_BFu0i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu0ll  {
  unsigned int  :0;
  short v1;
  __tsu64  :0;
};
//SIG(1 BFu0i_S_BFu0ll) C1{ Fi:0 Fs FL:0}



static void Test_BFu0i_S_BFu0ll()
{
  {
    init_simple_test("BFu0i_S_BFu0ll");
    static BFu0i_S_BFu0ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_S_BFu0ll)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_S_BFu0ll)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu0ll.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu0ll(Test_BFu0i_S_BFu0ll, "BFu0i_S_BFu0ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu0s  {
  unsigned int  :0;
  short v1;
  unsigned short  :0;
};
//SIG(1 BFu0i_S_BFu0s) C1{ Fi:0 Fs Fs:0}



static void Test_BFu0i_S_BFu0s()
{
  {
    init_simple_test("BFu0i_S_BFu0s");
    static BFu0i_S_BFu0s lv;
    check2(sizeof(lv), ABISELECT(2,2), "sizeof(BFu0i_S_BFu0s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_S_BFu0s)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu0s.v1");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu0s(Test_BFu0i_S_BFu0s, "BFu0i_S_BFu0s", ABISELECT(2,2));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu15i  {
  unsigned int  :0;
  short v1;
  unsigned int v2:15;
};
//SIG(1 BFu0i_S_BFu15i) C1{ Fi:0 Fs Fi:15}



static void Test_BFu0i_S_BFu15i()
{
  {
    init_simple_test("BFu0i_S_BFu15i");
    static BFu0i_S_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_S_BFu15i)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_S_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_S_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu15i(Test_BFu0i_S_BFu15i, "BFu0i_S_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu15ll  {
  unsigned int  :0;
  short v1;
  __tsu64 v2:15;
};
//SIG(1 BFu0i_S_BFu15ll) C1{ Fi:0 Fs FL:15}



static void Test_BFu0i_S_BFu15ll()
{
  {
    init_simple_test("BFu0i_S_BFu15ll");
    static BFu0i_S_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_S_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_S_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_S_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu15ll(Test_BFu0i_S_BFu15ll, "BFu0i_S_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu15s  {
  unsigned int  :0;
  short v1;
  unsigned short v2:15;
};
//SIG(1 BFu0i_S_BFu15s) C1{ Fi:0 Fs Fs:15}



static void Test_BFu0i_S_BFu15s()
{
  {
    init_simple_test("BFu0i_S_BFu15s");
    static BFu0i_S_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu15s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_S_BFu15s)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu0i_S_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu0i_S_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu15s(Test_BFu0i_S_BFu15s, "BFu0i_S_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu16i  {
  unsigned int  :0;
  short v1;
  unsigned int v2:16;
};
//SIG(1 BFu0i_S_BFu16i) C1{ Fi:0 Fs Fi:16}



static void Test_BFu0i_S_BFu16i()
{
  {
    init_simple_test("BFu0i_S_BFu16i");
    static BFu0i_S_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_S_BFu16i)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_S_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_S_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu16i(Test_BFu0i_S_BFu16i, "BFu0i_S_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu16ll  {
  unsigned int  :0;
  short v1;
  __tsu64 v2:16;
};
//SIG(1 BFu0i_S_BFu16ll) C1{ Fi:0 Fs FL:16}



static void Test_BFu0i_S_BFu16ll()
{
  {
    init_simple_test("BFu0i_S_BFu16ll");
    static BFu0i_S_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_S_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_S_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_S_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu16ll(Test_BFu0i_S_BFu16ll, "BFu0i_S_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu16s  {
  unsigned int  :0;
  short v1;
  unsigned short v2:16;
};
//SIG(1 BFu0i_S_BFu16s) C1{ Fi:0 Fs Fs:16}



static void Test_BFu0i_S_BFu16s()
{
  {
    init_simple_test("BFu0i_S_BFu16s");
    static BFu0i_S_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu16s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_S_BFu16s)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu0i_S_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu0i_S_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu16s(Test_BFu0i_S_BFu16s, "BFu0i_S_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu17i  {
  unsigned int  :0;
  short v1;
  unsigned int v2:17;
};
//SIG(1 BFu0i_S_BFu17i) C1{ Fi:0 Fs Fi:17}



static void Test_BFu0i_S_BFu17i()
{
  {
    init_simple_test("BFu0i_S_BFu17i");
    static BFu0i_S_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_S_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_S_BFu17i)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu0i_S_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu0i_S_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu17i(Test_BFu0i_S_BFu17i, "BFu0i_S_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu17ll  {
  unsigned int  :0;
  short v1;
  __tsu64 v2:17;
};
//SIG(1 BFu0i_S_BFu17ll) C1{ Fi:0 Fs FL:17}



static void Test_BFu0i_S_BFu17ll()
{
  {
    init_simple_test("BFu0i_S_BFu17ll");
    static BFu0i_S_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_S_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu0i_S_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu0i_S_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu17ll(Test_BFu0i_S_BFu17ll, "BFu0i_S_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu1c  {
  unsigned int  :0;
  short v1;
  unsigned char v2:1;
};
//SIG(1 BFu0i_S_BFu1c) C1{ Fi:0 Fs Fc:1}



static void Test_BFu0i_S_BFu1c()
{
  {
    init_simple_test("BFu0i_S_BFu1c");
    static BFu0i_S_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu1c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_S_BFu1c)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0i_S_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu1c(Test_BFu0i_S_BFu1c, "BFu0i_S_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu1i  {
  unsigned int  :0;
  short v1;
  unsigned int v2:1;
};
//SIG(1 BFu0i_S_BFu1i) C1{ Fi:0 Fs Fi:1}



static void Test_BFu0i_S_BFu1i()
{
  {
    init_simple_test("BFu0i_S_BFu1i");
    static BFu0i_S_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_S_BFu1i)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0i_S_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu1i(Test_BFu0i_S_BFu1i, "BFu0i_S_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu1ll  {
  unsigned int  :0;
  short v1;
  __tsu64 v2:1;
};
//SIG(1 BFu0i_S_BFu1ll) C1{ Fi:0 Fs FL:1}



static void Test_BFu0i_S_BFu1ll()
{
  {
    init_simple_test("BFu0i_S_BFu1ll");
    static BFu0i_S_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_S_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0i_S_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu1ll(Test_BFu0i_S_BFu1ll, "BFu0i_S_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu1s  {
  unsigned int  :0;
  short v1;
  unsigned short v2:1;
};
//SIG(1 BFu0i_S_BFu1s) C1{ Fi:0 Fs Fs:1}



static void Test_BFu0i_S_BFu1s()
{
  {
    init_simple_test("BFu0i_S_BFu1s");
    static BFu0i_S_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu1s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_S_BFu1s)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu0i_S_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu1s(Test_BFu0i_S_BFu1s, "BFu0i_S_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu31i  {
  unsigned int  :0;
  short v1;
  unsigned int v2:31;
};
//SIG(1 BFu0i_S_BFu31i) C1{ Fi:0 Fs Fi:31}



static void Test_BFu0i_S_BFu31i()
{
  {
    init_simple_test("BFu0i_S_BFu31i");
    static BFu0i_S_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_S_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_S_BFu31i)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu0i_S_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu0i_S_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu31i(Test_BFu0i_S_BFu31i, "BFu0i_S_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu31ll  {
  unsigned int  :0;
  short v1;
  __tsu64 v2:31;
};
//SIG(1 BFu0i_S_BFu31ll) C1{ Fi:0 Fs FL:31}



static void Test_BFu0i_S_BFu31ll()
{
  {
    init_simple_test("BFu0i_S_BFu31ll");
    static BFu0i_S_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_S_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu0i_S_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu0i_S_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu31ll(Test_BFu0i_S_BFu31ll, "BFu0i_S_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu32i  {
  unsigned int  :0;
  short v1;
  unsigned int v2:32;
};
//SIG(1 BFu0i_S_BFu32i) C1{ Fi:0 Fs Fi:32}



static void Test_BFu0i_S_BFu32i()
{
  {
    init_simple_test("BFu0i_S_BFu32i");
    static BFu0i_S_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_S_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_S_BFu32i)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu0i_S_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu0i_S_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu32i(Test_BFu0i_S_BFu32i, "BFu0i_S_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu32ll  {
  unsigned int  :0;
  short v1;
  __tsu64 v2:32;
};
//SIG(1 BFu0i_S_BFu32ll) C1{ Fi:0 Fs FL:32}



static void Test_BFu0i_S_BFu32ll()
{
  {
    init_simple_test("BFu0i_S_BFu32ll");
    static BFu0i_S_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_S_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu0i_S_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu0i_S_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu32ll(Test_BFu0i_S_BFu32ll, "BFu0i_S_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu33  {
  unsigned int  :0;
  short v1;
  __tsu64 v2:33;
};
//SIG(1 BFu0i_S_BFu33) C1{ Fi:0 Fs FL:33}



static void Test_BFu0i_S_BFu33()
{
  {
    init_simple_test("BFu0i_S_BFu33");
    static BFu0i_S_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu0i_S_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_S_BFu33)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu0i_S_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu0i_S_BFu33");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu33(Test_BFu0i_S_BFu33, "BFu0i_S_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu7c  {
  unsigned int  :0;
  short v1;
  unsigned char v2:7;
};
//SIG(1 BFu0i_S_BFu7c) C1{ Fi:0 Fs Fc:7}



static void Test_BFu0i_S_BFu7c()
{
  {
    init_simple_test("BFu0i_S_BFu7c");
    static BFu0i_S_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu7c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_S_BFu7c)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0i_S_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0i_S_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu7c(Test_BFu0i_S_BFu7c, "BFu0i_S_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu7i  {
  unsigned int  :0;
  short v1;
  unsigned int v2:7;
};
//SIG(1 BFu0i_S_BFu7i) C1{ Fi:0 Fs Fi:7}



static void Test_BFu0i_S_BFu7i()
{
  {
    init_simple_test("BFu0i_S_BFu7i");
    static BFu0i_S_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_S_BFu7i)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0i_S_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0i_S_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu7i(Test_BFu0i_S_BFu7i, "BFu0i_S_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu7ll  {
  unsigned int  :0;
  short v1;
  __tsu64 v2:7;
};
//SIG(1 BFu0i_S_BFu7ll) C1{ Fi:0 Fs FL:7}



static void Test_BFu0i_S_BFu7ll()
{
  {
    init_simple_test("BFu0i_S_BFu7ll");
    static BFu0i_S_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_S_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0i_S_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0i_S_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu7ll(Test_BFu0i_S_BFu7ll, "BFu0i_S_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu7s  {
  unsigned int  :0;
  short v1;
  unsigned short v2:7;
};
//SIG(1 BFu0i_S_BFu7s) C1{ Fi:0 Fs Fs:7}



static void Test_BFu0i_S_BFu7s()
{
  {
    init_simple_test("BFu0i_S_BFu7s");
    static BFu0i_S_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu7s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_S_BFu7s)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu0i_S_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu0i_S_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu7s(Test_BFu0i_S_BFu7s, "BFu0i_S_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu8c  {
  unsigned int  :0;
  short v1;
  unsigned char v2:8;
};
//SIG(1 BFu0i_S_BFu8c) C1{ Fi:0 Fs Fc:8}



static void Test_BFu0i_S_BFu8c()
{
  {
    init_simple_test("BFu0i_S_BFu8c");
    static BFu0i_S_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu8c)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_S_BFu8c)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0i_S_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0i_S_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu8c(Test_BFu0i_S_BFu8c, "BFu0i_S_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu8i  {
  unsigned int  :0;
  short v1;
  unsigned int v2:8;
};
//SIG(1 BFu0i_S_BFu8i) C1{ Fi:0 Fs Fi:8}



static void Test_BFu0i_S_BFu8i()
{
  {
    init_simple_test("BFu0i_S_BFu8i");
    static BFu0i_S_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_S_BFu8i)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0i_S_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0i_S_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu8i(Test_BFu0i_S_BFu8i, "BFu0i_S_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu8ll  {
  unsigned int  :0;
  short v1;
  __tsu64 v2:8;
};
//SIG(1 BFu0i_S_BFu8ll) C1{ Fi:0 Fs FL:8}



static void Test_BFu0i_S_BFu8ll()
{
  {
    init_simple_test("BFu0i_S_BFu8ll");
    static BFu0i_S_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_S_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0i_S_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0i_S_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu8ll(Test_BFu0i_S_BFu8ll, "BFu0i_S_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu8s  {
  unsigned int  :0;
  short v1;
  unsigned short v2:8;
};
//SIG(1 BFu0i_S_BFu8s) C1{ Fi:0 Fs Fs:8}



static void Test_BFu0i_S_BFu8s()
{
  {
    init_simple_test("BFu0i_S_BFu8s");
    static BFu0i_S_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu8s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_S_BFu8s)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu0i_S_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu0i_S_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu8s(Test_BFu0i_S_BFu8s, "BFu0i_S_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu9i  {
  unsigned int  :0;
  short v1;
  unsigned int v2:9;
};
//SIG(1 BFu0i_S_BFu9i) C1{ Fi:0 Fs Fi:9}



static void Test_BFu0i_S_BFu9i()
{
  {
    init_simple_test("BFu0i_S_BFu9i");
    static BFu0i_S_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu0i_S_BFu9i)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0i_S_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0i_S_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu9i(Test_BFu0i_S_BFu9i, "BFu0i_S_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu9ll  {
  unsigned int  :0;
  short v1;
  __tsu64 v2:9;
};
//SIG(1 BFu0i_S_BFu9ll) C1{ Fi:0 Fs FL:9}



static void Test_BFu0i_S_BFu9ll()
{
  {
    init_simple_test("BFu0i_S_BFu9ll");
    static BFu0i_S_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu0i_S_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu0i_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0i_S_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0i_S_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu9ll(Test_BFu0i_S_BFu9ll, "BFu0i_S_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_BFu9s  {
  unsigned int  :0;
  short v1;
  unsigned short v2:9;
};
//SIG(1 BFu0i_S_BFu9s) C1{ Fi:0 Fs Fs:9}



static void Test_BFu0i_S_BFu9s()
{
  {
    init_simple_test("BFu0i_S_BFu9s");
    static BFu0i_S_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu0i_S_BFu9s)");
    check2(__alignof__(lv), ABISELECT(2,2), "__alignof__(BFu0i_S_BFu9s)");
    check_field_offset(lv, v1, 0, "BFu0i_S_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu0i_S_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu0i_S_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu0i_S_BFu9s(Test_BFu0i_S_BFu9s, "BFu0i_S_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu0i_S_C  {
  unsigned int  :0;
  short v1;
  char v2;
};
//SIG(