// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  empty  {
};
//SIG(-1 empty) C1{}



static void Test_empty()
{
  {
    init_simple_test("empty");
    empty lv;
    check2(sizeof(lv), 1, "sizeof(empty)");
    check2(__alignof__(lv), 1, "__alignof__(empty)");
  }
}
static Arrange_To_Call_Me vempty(Test_empty, "empty", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu15s  {
  ::empty v1;
  unsigned int v2:16;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu16i_BFu15s) C1{ FC2{} Fi:16 Fs:15}



static void Test_Sf_BFu16i_BFu15s()
{
  {
    init_simple_test("Sf_BFu16i_BFu15s");
    static Sf_BFu16i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Sf_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Sf_BFu16i_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu15s(Test_Sf_BFu16i_BFu15s, "Sf_BFu16i_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu16i  {
  ::empty v1;
  unsigned int v2:16;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu16i_BFu16i) C1{ FC2{} Fi:16 Fi:16}



static void Test_Sf_BFu16i_BFu16i()
{
  {
    init_simple_test("Sf_BFu16i_BFu16i");
    static Sf_BFu16i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu16i(Test_Sf_BFu16i_BFu16i, "Sf_BFu16i_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu16ll  {
  ::empty v1;
  unsigned int v2:16;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu16i_BFu16ll) C1{ FC2{} Fi:16 FL:16}



static void Test_Sf_BFu16i_BFu16ll()
{
  {
    init_simple_test("Sf_BFu16i_BFu16ll");
    static Sf_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "Sf_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu16ll(Test_Sf_BFu16i_BFu16ll, "Sf_BFu16i_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu16s  {
  ::empty v1;
  unsigned int v2:16;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu16i_BFu16s) C1{ FC2{} Fi:16 Fs:16}



static void Test_Sf_BFu16i_BFu16s()
{
  {
    init_simple_test("Sf_BFu16i_BFu16s");
    static Sf_BFu16i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu16s(Test_Sf_BFu16i_BFu16s, "Sf_BFu16i_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu17i  {
  ::empty v1;
  unsigned int v2:16;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu16i_BFu17i) C1{ FC2{} Fi:16 Fi:17}



static void Test_Sf_BFu16i_BFu17i()
{
  {
    init_simple_test("Sf_BFu16i_BFu17i");
    static Sf_BFu16i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Sf_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Sf_BFu16i_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu17i(Test_Sf_BFu16i_BFu17i, "Sf_BFu16i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu17ll  {
  ::empty v1;
  unsigned int v2:16;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu16i_BFu17ll) C1{ FC2{} Fi:16 FL:17}



static void Test_Sf_BFu16i_BFu17ll()
{
  {
    init_simple_test("Sf_BFu16i_BFu17ll");
    static Sf_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "Sf_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "Sf_BFu16i_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu17ll(Test_Sf_BFu16i_BFu17ll, "Sf_BFu16i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu1c  {
  ::empty v1;
  unsigned int v2:16;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu16i_BFu1c) C1{ FC2{} Fi:16 Fc:1}



static void Test_Sf_BFu16i_BFu1c()
{
  {
    init_simple_test("Sf_BFu16i_BFu1c");
    static Sf_BFu16i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu16i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Sf_BFu16i_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu1c(Test_Sf_BFu16i_BFu1c, "Sf_BFu16i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu1i  {
  ::empty v1;
  unsigned int v2:16;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu16i_BFu1i) C1{ FC2{} Fi:16 Fi:1}



static void Test_Sf_BFu16i_BFu1i()
{
  {
    init_simple_test("Sf_BFu16i_BFu1i");
    static Sf_BFu16i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu16i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Sf_BFu16i_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu1i(Test_Sf_BFu16i_BFu1i, "Sf_BFu16i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu1ll  {
  ::empty v1;
  unsigned int v2:16;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu16i_BFu1ll) C1{ FC2{} Fi:16 FL:1}



static void Test_Sf_BFu16i_BFu1ll()
{
  {
    init_simple_test("Sf_BFu16i_BFu1ll");
    static Sf_BFu16i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Sf_BFu16i_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu1ll(Test_Sf_BFu16i_BFu1ll, "Sf_BFu16i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu1s  {
  ::empty v1;
  unsigned int v2:16;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu16i_BFu1s) C1{ FC2{} Fi:16 Fs:1}



static void Test_Sf_BFu16i_BFu1s()
{
  {
    init_simple_test("Sf_BFu16i_BFu1s");
    static Sf_BFu16i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu16i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Sf_BFu16i_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu1s(Test_Sf_BFu16i_BFu1s, "Sf_BFu16i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu31i  {
  ::empty v1;
  unsigned int v2:16;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu16i_BFu31i) C1{ FC2{} Fi:16 Fi:31}



static void Test_Sf_BFu16i_BFu31i()
{
  {
    init_simple_test("Sf_BFu16i_BFu31i");
    static Sf_BFu16i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu16i_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu31i(Test_Sf_BFu16i_BFu31i, "Sf_BFu16i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu31ll  {
  ::empty v1;
  unsigned int v2:16;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu16i_BFu31ll) C1{ FC2{} Fi:16 FL:31}



static void Test_Sf_BFu16i_BFu31ll()
{
  {
    init_simple_test("Sf_BFu16i_BFu31ll");
    static Sf_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "Sf_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "Sf_BFu16i_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu31ll(Test_Sf_BFu16i_BFu31ll, "Sf_BFu16i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu32i  {
  ::empty v1;
  unsigned int v2:16;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu16i_BFu32i) C1{ FC2{} Fi:16 Fi:32}



static void Test_Sf_BFu16i_BFu32i()
{
  {
    init_simple_test("Sf_BFu16i_BFu32i");
    static Sf_BFu16i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu16i_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu32i(Test_Sf_BFu16i_BFu32i, "Sf_BFu16i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu32ll  {
  ::empty v1;
  unsigned int v2:16;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu16i_BFu32ll) C1{ FC2{} Fi:16 FL:32}



static void Test_Sf_BFu16i_BFu32ll()
{
  {
    init_simple_test("Sf_BFu16i_BFu32ll");
    static Sf_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "Sf_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "Sf_BFu16i_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu32ll(Test_Sf_BFu16i_BFu32ll, "Sf_BFu16i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu33  {
  ::empty v1;
  unsigned int v2:16;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu16i_BFu33) C1{ FC2{} Fi:16 FL:33}



static void Test_Sf_BFu16i_BFu33()
{
  {
    init_simple_test("Sf_BFu16i_BFu33");
    static Sf_BFu16i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "Sf_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "Sf_BFu16i_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu33(Test_Sf_BFu16i_BFu33, "Sf_BFu16i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu7c  {
  ::empty v1;
  unsigned int v2:16;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu16i_BFu7c) C1{ FC2{} Fi:16 Fc:7}



static void Test_Sf_BFu16i_BFu7c()
{
  {
    init_simple_test("Sf_BFu16i_BFu7c");
    static Sf_BFu16i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu16i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Sf_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Sf_BFu16i_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu7c(Test_Sf_BFu16i_BFu7c, "Sf_BFu16i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu7i  {
  ::empty v1;
  unsigned int v2:16;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu16i_BFu7i) C1{ FC2{} Fi:16 Fi:7}



static void Test_Sf_BFu16i_BFu7i()
{
  {
    init_simple_test("Sf_BFu16i_BFu7i");
    static Sf_BFu16i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu16i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Sf_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Sf_BFu16i_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu7i(Test_Sf_BFu16i_BFu7i, "Sf_BFu16i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu7ll  {
  ::empty v1;
  unsigned int v2:16;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu16i_BFu7ll) C1{ FC2{} Fi:16 FL:7}



static void Test_Sf_BFu16i_BFu7ll()
{
  {
    init_simple_test("Sf_BFu16i_BFu7ll");
    static Sf_BFu16i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Sf_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Sf_BFu16i_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu7ll(Test_Sf_BFu16i_BFu7ll, "Sf_BFu16i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu7s  {
  ::empty v1;
  unsigned int v2:16;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu16i_BFu7s) C1{ FC2{} Fi:16 Fs:7}



static void Test_Sf_BFu16i_BFu7s()
{
  {
    init_simple_test("Sf_BFu16i_BFu7s");
    static Sf_BFu16i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu16i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Sf_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Sf_BFu16i_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu7s(Test_Sf_BFu16i_BFu7s, "Sf_BFu16i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu8c  {
  ::empty v1;
  unsigned int v2:16;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu16i_BFu8c) C1{ FC2{} Fi:16 Fc:8}



static void Test_Sf_BFu16i_BFu8c()
{
  {
    init_simple_test("Sf_BFu16i_BFu8c");
    static Sf_BFu16i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu16i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Sf_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Sf_BFu16i_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu8c(Test_Sf_BFu16i_BFu8c, "Sf_BFu16i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu8i  {
  ::empty v1;
  unsigned int v2:16;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu16i_BFu8i) C1{ FC2{} Fi:16 Fi:8}



static void Test_Sf_BFu16i_BFu8i()
{
  {
    init_simple_test("Sf_BFu16i_BFu8i");
    static Sf_BFu16i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu16i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Sf_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Sf_BFu16i_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu8i(Test_Sf_BFu16i_BFu8i, "Sf_BFu16i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu8ll  {
  ::empty v1;
  unsigned int v2:16;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu16i_BFu8ll) C1{ FC2{} Fi:16 FL:8}



static void Test_Sf_BFu16i_BFu8ll()
{
  {
    init_simple_test("Sf_BFu16i_BFu8ll");
    static Sf_BFu16i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Sf_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Sf_BFu16i_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu8ll(Test_Sf_BFu16i_BFu8ll, "Sf_BFu16i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu8s  {
  ::empty v1;
  unsigned int v2:16;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu16i_BFu8s) C1{ FC2{} Fi:16 Fs:8}



static void Test_Sf_BFu16i_BFu8s()
{
  {
    init_simple_test("Sf_BFu16i_BFu8s");
    static Sf_BFu16i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu16i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Sf_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Sf_BFu16i_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu8s(Test_Sf_BFu16i_BFu8s, "Sf_BFu16i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu9i  {
  ::empty v1;
  unsigned int v2:16;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu16i_BFu9i) C1{ FC2{} Fi:16 Fi:9}



static void Test_Sf_BFu16i_BFu9i()
{
  {
    init_simple_test("Sf_BFu16i_BFu9i");
    static Sf_BFu16i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Sf_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Sf_BFu16i_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu9i(Test_Sf_BFu16i_BFu9i, "Sf_BFu16i_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu9ll  {
  ::empty v1;
  unsigned int v2:16;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu16i_BFu9ll) C1{ FC2{} Fi:16 FL:9}



static void Test_Sf_BFu16i_BFu9ll()
{
  {
    init_simple_test("Sf_BFu16i_BFu9ll");
    static Sf_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "Sf_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "Sf_BFu16i_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu9ll(Test_Sf_BFu16i_BFu9ll, "Sf_BFu16i_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_BFu9s  {
  ::empty v1;
  unsigned int v2:16;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu16i_BFu9s) C1{ FC2{} Fi:16 Fs:9}



static void Test_Sf_BFu16i_BFu9s()
{
  {
    init_simple_test("Sf_BFu16i_BFu9s");
    static Sf_BFu16i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Sf_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Sf_BFu16i_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_BFu9s(Test_Sf_BFu16i_BFu9s, "Sf_BFu16i_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_C  {
  ::empty v1;
  unsigned int v2:16;
  char v3;
};
//SIG(1 Sf_BFu16i_C) C1{ FC2{} Fi:16 Fc}



static void Test_Sf_BFu16i_C()
{
  {
    init_simple_test("Sf_BFu16i_C");
    static Sf_BFu16i_C lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu16i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_C");
    check_field_offset(lv, v3, 3, "Sf_BFu16i_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_C(Test_Sf_BFu16i_C, "Sf_BFu16i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_D  {
  ::empty v1;
  unsigned int v2:16;
  double v3;
};
//SIG(1 Sf_BFu16i_D) C1{ FC2{} Fi:16 FL}



static void Test_Sf_BFu16i_D()
{
  {
    init_simple_test("Sf_BFu16i_D");
    static Sf_BFu16i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu16i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16i_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16i_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_D(Test_Sf_BFu16i_D, "Sf_BFu16i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_F  {
  ::empty v1;
  unsigned int v2:16;
  float v3;
};
//SIG(1 Sf_BFu16i_F) C1{ FC2{} Fi:16 Fi}



static void Test_Sf_BFu16i_F()
{
  {
    init_simple_test("Sf_BFu16i_F");
    static Sf_BFu16i_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_F");
    check_field_offset(lv, v3, 4, "Sf_BFu16i_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_F(Test_Sf_BFu16i_F, "Sf_BFu16i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_I  {
  ::empty v1;
  unsigned int v2:16;
  int v3;
};
//SIG(1 Sf_BFu16i_I) C1{ FC2{} Fi:16 Fi}



static void Test_Sf_BFu16i_I()
{
  {
    init_simple_test("Sf_BFu16i_I");
    static Sf_BFu16i_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_I");
    check_field_offset(lv, v3, 4, "Sf_BFu16i_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_I(Test_Sf_BFu16i_I, "Sf_BFu16i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_Ip  {
  ::empty v1;
  unsigned int v2:16;
  int *v3;
};
//SIG(1 Sf_BFu16i_Ip) C1{ FC2{} Fi:16 Fp}



static void Test_Sf_BFu16i_Ip()
{
  {
    init_simple_test("Sf_BFu16i_Ip");
    static Sf_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu16i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16i_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_Ip(Test_Sf_BFu16i_Ip, "Sf_BFu16i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_L  {
  ::empty v1;
  unsigned int v2:16;
  __tsi64 v3;
};
//SIG(1 Sf_BFu16i_L) C1{ FC2{} Fi:16 FL}



static void Test_Sf_BFu16i_L()
{
  {
    init_simple_test("Sf_BFu16i_L");
    static Sf_BFu16i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu16i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16i_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16i_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_L(Test_Sf_BFu16i_L, "Sf_BFu16i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_S  {
  ::empty v1;
  unsigned int v2:16;
  short v3;
};
//SIG(1 Sf_BFu16i_S) C1{ FC2{} Fi:16 Fs}



static void Test_Sf_BFu16i_S()
{
  {
    init_simple_test("Sf_BFu16i_S");
    static Sf_BFu16i_S lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_S");
    check_field_offset(lv, v3, 4, "Sf_BFu16i_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_S(Test_Sf_BFu16i_S, "Sf_BFu16i_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_Sf  {
  ::empty v1;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 Sf_BFu16i_Sf) C1{ FC2{} Fi:16 FC2}



static void Test_Sf_BFu16i_Sf()
{
  {
    init_simple_test("Sf_BFu16i_Sf");
    static Sf_BFu16i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu16i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "Sf_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_Sf(Test_Sf_BFu16i_Sf, "Sf_BFu16i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_Uc  {
  ::empty v1;
  unsigned int v2:16;
  unsigned char v3;
};
//SIG(1 Sf_BFu16i_Uc) C1{ FC2{} Fi:16 Fc}



static void Test_Sf_BFu16i_Uc()
{
  {
    init_simple_test("Sf_BFu16i_Uc");
    static Sf_BFu16i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu16i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_Uc");
    check_field_offset(lv, v3, 3, "Sf_BFu16i_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_Uc(Test_Sf_BFu16i_Uc, "Sf_BFu16i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_Ui  {
  ::empty v1;
  unsigned int v2:16;
  unsigned int v3;
};
//SIG(1 Sf_BFu16i_Ui) C1{ FC2{} Fi:16 Fi}



static void Test_Sf_BFu16i_Ui()
{
  {
    init_simple_test("Sf_BFu16i_Ui");
    static Sf_BFu16i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu16i_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_Ui(Test_Sf_BFu16i_Ui, "Sf_BFu16i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_Ul  {
  ::empty v1;
  unsigned int v2:16;
  __tsu64 v3;
};
//SIG(1 Sf_BFu16i_Ul) C1{ FC2{} Fi:16 FL}



static void Test_Sf_BFu16i_Ul()
{
  {
    init_simple_test("Sf_BFu16i_Ul");
    static Sf_BFu16i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu16i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16i_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_Ul(Test_Sf_BFu16i_Ul, "Sf_BFu16i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_Us  {
  ::empty v1;
  unsigned int v2:16;
  unsigned short v3;
};
//SIG(1 Sf_BFu16i_Us) C1{ FC2{} Fi:16 Fs}



static void Test_Sf_BFu16i_Us()
{
  {
    init_simple_test("Sf_BFu16i_Us");
    static Sf_BFu16i_Us lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_Us");
    check_field_offset(lv, v3, 4, "Sf_BFu16i_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_Us(Test_Sf_BFu16i_Us, "Sf_BFu16i_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16i_Vp  {
  ::empty v1;
  unsigned int v2:16;
  void *v3;
};
//SIG(1 Sf_BFu16i_Vp) C1{ FC2{} Fi:16 Fp}



static void Test_Sf_BFu16i_Vp()
{
  {
    init_simple_test("Sf_BFu16i_Vp");
    static Sf_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu16i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16i_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16i_Vp(Test_Sf_BFu16i_Vp, "Sf_BFu16i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll  {
  ::empty v1;
  __tsu64 v2:16;
};
//SIG(1 Sf_BFu16ll) C1{ FC2{} FL:16}



static void Test_Sf_BFu16ll()
{
  {
    init_simple_test("Sf_BFu16ll");
    static Sf_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll(Test_Sf_BFu16ll, "Sf_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu15i  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu16ll_BFu15i) C1{ FC2{} FL:16 Fi:15}



static void Test_Sf_BFu16ll_BFu15i()
{
  {
    init_simple_test("Sf_BFu16ll_BFu15i");
    static Sf_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Sf_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Sf_BFu16ll_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu15i(Test_Sf_BFu16ll_BFu15i, "Sf_BFu16ll_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu15ll  {
  ::empty v1;
  __tsu64 v2:16;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu16ll_BFu15ll) C1{ FC2{} FL:16 FL:15}



static void Test_Sf_BFu16ll_BFu15ll()
{
  {
    init_simple_test("Sf_BFu16ll_BFu15ll");
    static Sf_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "Sf_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "Sf_BFu16ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu15ll(Test_Sf_BFu16ll_BFu15ll, "Sf_BFu16ll_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu15s  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu16ll_BFu15s) C1{ FC2{} FL:16 Fs:15}



static void Test_Sf_BFu16ll_BFu15s()
{
  {
    init_simple_test("Sf_BFu16ll_BFu15s");
    static Sf_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Sf_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Sf_BFu16ll_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu15s(Test_Sf_BFu16ll_BFu15s, "Sf_BFu16ll_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu16i  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu16ll_BFu16i) C1{ FC2{} FL:16 Fi:16}



static void Test_Sf_BFu16ll_BFu16i()
{
  {
    init_simple_test("Sf_BFu16ll_BFu16i");
    static Sf_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu16i(Test_Sf_BFu16ll_BFu16i, "Sf_BFu16ll_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu16ll  {
  ::empty v1;
  __tsu64 v2:16;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu16ll_BFu16ll) C1{ FC2{} FL:16 FL:16}



static void Test_Sf_BFu16ll_BFu16ll()
{
  {
    init_simple_test("Sf_BFu16ll_BFu16ll");
    static Sf_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "Sf_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu16ll(Test_Sf_BFu16ll_BFu16ll, "Sf_BFu16ll_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu16s  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu16ll_BFu16s) C1{ FC2{} FL:16 Fs:16}



static void Test_Sf_BFu16ll_BFu16s()
{
  {
    init_simple_test("Sf_BFu16ll_BFu16s");
    static Sf_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu16s(Test_Sf_BFu16ll_BFu16s, "Sf_BFu16ll_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu17i  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu16ll_BFu17i) C1{ FC2{} FL:16 Fi:17}



static void Test_Sf_BFu16ll_BFu17i()
{
  {
    init_simple_test("Sf_BFu16ll_BFu17i");
    static Sf_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Sf_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Sf_BFu16ll_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu17i(Test_Sf_BFu16ll_BFu17i, "Sf_BFu16ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu17ll  {
  ::empty v1;
  __tsu64 v2:16;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu16ll_BFu17ll) C1{ FC2{} FL:16 FL:17}



static void Test_Sf_BFu16ll_BFu17ll()
{
  {
    init_simple_test("Sf_BFu16ll_BFu17ll");
    static Sf_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "Sf_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "Sf_BFu16ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu17ll(Test_Sf_BFu16ll_BFu17ll, "Sf_BFu16ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu1c  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu16ll_BFu1c) C1{ FC2{} FL:16 Fc:1}



static void Test_Sf_BFu16ll_BFu1c()
{
  {
    init_simple_test("Sf_BFu16ll_BFu1c");
    static Sf_BFu16ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Sf_BFu16ll_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu1c(Test_Sf_BFu16ll_BFu1c, "Sf_BFu16ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu1i  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu16ll_BFu1i) C1{ FC2{} FL:16 Fi:1}



static void Test_Sf_BFu16ll_BFu1i()
{
  {
    init_simple_test("Sf_BFu16ll_BFu1i");
    static Sf_BFu16ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Sf_BFu16ll_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu1i(Test_Sf_BFu16ll_BFu1i, "Sf_BFu16ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu1ll  {
  ::empty v1;
  __tsu64 v2:16;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu16ll_BFu1ll) C1{ FC2{} FL:16 FL:1}



static void Test_Sf_BFu16ll_BFu1ll()
{
  {
    init_simple_test("Sf_BFu16ll_BFu1ll");
    static Sf_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Sf_BFu16ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu1ll(Test_Sf_BFu16ll_BFu1ll, "Sf_BFu16ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu1s  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu16ll_BFu1s) C1{ FC2{} FL:16 Fs:1}



static void Test_Sf_BFu16ll_BFu1s()
{
  {
    init_simple_test("Sf_BFu16ll_BFu1s");
    static Sf_BFu16ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "Sf_BFu16ll_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu1s(Test_Sf_BFu16ll_BFu1s, "Sf_BFu16ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu31i  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu16ll_BFu31i) C1{ FC2{} FL:16 Fi:31}



static void Test_Sf_BFu16ll_BFu31i()
{
  {
    init_simple_test("Sf_BFu16ll_BFu31i");
    static Sf_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu16ll_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu31i(Test_Sf_BFu16ll_BFu31i, "Sf_BFu16ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu31ll  {
  ::empty v1;
  __tsu64 v2:16;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu16ll_BFu31ll) C1{ FC2{} FL:16 FL:31}



static void Test_Sf_BFu16ll_BFu31ll()
{
  {
    init_simple_test("Sf_BFu16ll_BFu31ll");
    static Sf_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "Sf_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "Sf_BFu16ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu31ll(Test_Sf_BFu16ll_BFu31ll, "Sf_BFu16ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu32i  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu16ll_BFu32i) C1{ FC2{} FL:16 Fi:32}



static void Test_Sf_BFu16ll_BFu32i()
{
  {
    init_simple_test("Sf_BFu16ll_BFu32i");
    static Sf_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu16ll_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu32i(Test_Sf_BFu16ll_BFu32i, "Sf_BFu16ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu32ll  {
  ::empty v1;
  __tsu64 v2:16;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu16ll_BFu32ll) C1{ FC2{} FL:16 FL:32}



static void Test_Sf_BFu16ll_BFu32ll()
{
  {
    init_simple_test("Sf_BFu16ll_BFu32ll");
    static Sf_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "Sf_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "Sf_BFu16ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu32ll(Test_Sf_BFu16ll_BFu32ll, "Sf_BFu16ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu33  {
  ::empty v1;
  __tsu64 v2:16;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu16ll_BFu33) C1{ FC2{} FL:16 FL:33}



static void Test_Sf_BFu16ll_BFu33()
{
  {
    init_simple_test("Sf_BFu16ll_BFu33");
    static Sf_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "Sf_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "Sf_BFu16ll_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu33(Test_Sf_BFu16ll_BFu33, "Sf_BFu16ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu7c  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu16ll_BFu7c) C1{ FC2{} FL:16 Fc:7}



static void Test_Sf_BFu16ll_BFu7c()
{
  {
    init_simple_test("Sf_BFu16ll_BFu7c");
    static Sf_BFu16ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Sf_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Sf_BFu16ll_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu7c(Test_Sf_BFu16ll_BFu7c, "Sf_BFu16ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu7i  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu16ll_BFu7i) C1{ FC2{} FL:16 Fi:7}



static void Test_Sf_BFu16ll_BFu7i()
{
  {
    init_simple_test("Sf_BFu16ll_BFu7i");
    static Sf_BFu16ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Sf_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Sf_BFu16ll_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu7i(Test_Sf_BFu16ll_BFu7i, "Sf_BFu16ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu7ll  {
  ::empty v1;
  __tsu64 v2:16;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu16ll_BFu7ll) C1{ FC2{} FL:16 FL:7}



static void Test_Sf_BFu16ll_BFu7ll()
{
  {
    init_simple_test("Sf_BFu16ll_BFu7ll");
    static Sf_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Sf_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Sf_BFu16ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu7ll(Test_Sf_BFu16ll_BFu7ll, "Sf_BFu16ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu7s  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu16ll_BFu7s) C1{ FC2{} FL:16 Fs:7}



static void Test_Sf_BFu16ll_BFu7s()
{
  {
    init_simple_test("Sf_BFu16ll_BFu7s");
    static Sf_BFu16ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "Sf_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "Sf_BFu16ll_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu7s(Test_Sf_BFu16ll_BFu7s, "Sf_BFu16ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu8c  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu16ll_BFu8c) C1{ FC2{} FL:16 Fc:8}



static void Test_Sf_BFu16ll_BFu8c()
{
  {
    init_simple_test("Sf_BFu16ll_BFu8c");
    static Sf_BFu16ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Sf_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Sf_BFu16ll_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu8c(Test_Sf_BFu16ll_BFu8c, "Sf_BFu16ll_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu8i  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu16ll_BFu8i) C1{ FC2{} FL:16 Fi:8}



static void Test_Sf_BFu16ll_BFu8i()
{
  {
    init_simple_test("Sf_BFu16ll_BFu8i");
    static Sf_BFu16ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Sf_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Sf_BFu16ll_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu8i(Test_Sf_BFu16ll_BFu8i, "Sf_BFu16ll_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu8ll  {
  ::empty v1;
  __tsu64 v2:16;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu16ll_BFu8ll) C1{ FC2{} FL:16 FL:8}



static void Test_Sf_BFu16ll_BFu8ll()
{
  {
    init_simple_test("Sf_BFu16ll_BFu8ll");
    static Sf_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Sf_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Sf_BFu16ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu8ll(Test_Sf_BFu16ll_BFu8ll, "Sf_BFu16ll_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu8s  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu16ll_BFu8s) C1{ FC2{} FL:16 Fs:8}



static void Test_Sf_BFu16ll_BFu8s()
{
  {
    init_simple_test("Sf_BFu16ll_BFu8s");
    static Sf_BFu16ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Sf_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Sf_BFu16ll_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu8s(Test_Sf_BFu16ll_BFu8s, "Sf_BFu16ll_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu9i  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu16ll_BFu9i) C1{ FC2{} FL:16 Fi:9}



static void Test_Sf_BFu16ll_BFu9i()
{
  {
    init_simple_test("Sf_BFu16ll_BFu9i");
    static Sf_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Sf_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Sf_BFu16ll_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu9i(Test_Sf_BFu16ll_BFu9i, "Sf_BFu16ll_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu9ll  {
  ::empty v1;
  __tsu64 v2:16;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu16ll_BFu9ll) C1{ FC2{} FL:16 FL:9}



static void Test_Sf_BFu16ll_BFu9ll()
{
  {
    init_simple_test("Sf_BFu16ll_BFu9ll");
    static Sf_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "Sf_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "Sf_BFu16ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu9ll(Test_Sf_BFu16ll_BFu9ll, "Sf_BFu16ll_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_BFu9s  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu16ll_BFu9s) C1{ FC2{} FL:16 Fs:9}



static void Test_Sf_BFu16ll_BFu9s()
{
  {
    init_simple_test("Sf_BFu16ll_BFu9s");
    static Sf_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Sf_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Sf_BFu16ll_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_BFu9s(Test_Sf_BFu16ll_BFu9s, "Sf_BFu16ll_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_C  {
  ::empty v1;
  __tsu64 v2:16;
  char v3;
};
//SIG(1 Sf_BFu16ll_C) C1{ FC2{} FL:16 Fc}



static void Test_Sf_BFu16ll_C()
{
  {
    init_simple_test("Sf_BFu16ll_C");
    static Sf_BFu16ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_C");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_C");
    check_field_offset(lv, v3, 3, "Sf_BFu16ll_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_C(Test_Sf_BFu16ll_C, "Sf_BFu16ll_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_D  {
  ::empty v1;
  __tsu64 v2:16;
  double v3;
};
//SIG(1 Sf_BFu16ll_D) C1{ FC2{} FL:16 FL}



static void Test_Sf_BFu16ll_D()
{
  {
    init_simple_test("Sf_BFu16ll_D");
    static Sf_BFu16ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu16ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_D");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16ll_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_D(Test_Sf_BFu16ll_D, "Sf_BFu16ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_F  {
  ::empty v1;
  __tsu64 v2:16;
  float v3;
};
//SIG(1 Sf_BFu16ll_F) C1{ FC2{} FL:16 Fi}



static void Test_Sf_BFu16ll_F()
{
  {
    init_simple_test("Sf_BFu16ll_F");
    static Sf_BFu16ll_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_F");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_F");
    check_field_offset(lv, v3, 4, "Sf_BFu16ll_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_F(Test_Sf_BFu16ll_F, "Sf_BFu16ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_I  {
  ::empty v1;
  __tsu64 v2:16;
  int v3;
};
//SIG(1 Sf_BFu16ll_I) C1{ FC2{} FL:16 Fi}



static void Test_Sf_BFu16ll_I()
{
  {
    init_simple_test("Sf_BFu16ll_I");
    static Sf_BFu16ll_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_I");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_I");
    check_field_offset(lv, v3, 4, "Sf_BFu16ll_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_I(Test_Sf_BFu16ll_I, "Sf_BFu16ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_Ip  {
  ::empty v1;
  __tsu64 v2:16;
  int *v3;
};
//SIG(1 Sf_BFu16ll_Ip) C1{ FC2{} FL:16 Fp}



static void Test_Sf_BFu16ll_Ip()
{
  {
    init_simple_test("Sf_BFu16ll_Ip");
    static Sf_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu16ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_Ip(Test_Sf_BFu16ll_Ip, "Sf_BFu16ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_L  {
  ::empty v1;
  __tsu64 v2:16;
  __tsi64 v3;
};
//SIG(1 Sf_BFu16ll_L) C1{ FC2{} FL:16 FL}



static void Test_Sf_BFu16ll_L()
{
  {
    init_simple_test("Sf_BFu16ll_L");
    static Sf_BFu16ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu16ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_L");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16ll_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_L(Test_Sf_BFu16ll_L, "Sf_BFu16ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_S  {
  ::empty v1;
  __tsu64 v2:16;
  short v3;
};
//SIG(1 Sf_BFu16ll_S) C1{ FC2{} FL:16 Fs}



static void Test_Sf_BFu16ll_S()
{
  {
    init_simple_test("Sf_BFu16ll_S");
    static Sf_BFu16ll_S lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_S");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_S");
    check_field_offset(lv, v3, 4, "Sf_BFu16ll_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_S(Test_Sf_BFu16ll_S, "Sf_BFu16ll_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_Sf  {
  ::empty v1;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 Sf_BFu16ll_Sf) C1{ FC2{} FL:16 FC2}



static void Test_Sf_BFu16ll_Sf()
{
  {
    init_simple_test("Sf_BFu16ll_Sf");
    static Sf_BFu16ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "Sf_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_Sf(Test_Sf_BFu16ll_Sf, "Sf_BFu16ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_Uc  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned char v3;
};
//SIG(1 Sf_BFu16ll_Uc) C1{ FC2{} FL:16 Fc}



static void Test_Sf_BFu16ll_Uc()
{
  {
    init_simple_test("Sf_BFu16ll_Uc");
    static Sf_BFu16ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu16ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_Uc");
    check_field_offset(lv, v3, 3, "Sf_BFu16ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_Uc(Test_Sf_BFu16ll_Uc, "Sf_BFu16ll_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_Ui  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned int v3;
};
//SIG(1 Sf_BFu16ll_Ui) C1{ FC2{} FL:16 Fi}



static void Test_Sf_BFu16ll_Ui()
{
  {
    init_simple_test("Sf_BFu16ll_Ui");
    static Sf_BFu16ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu16ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_Ui(Test_Sf_BFu16ll_Ui, "Sf_BFu16ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_Ul  {
  ::empty v1;
  __tsu64 v2:16;
  __tsu64 v3;
};
//SIG(1 Sf_BFu16ll_Ul) C1{ FC2{} FL:16 FL}



static void Test_Sf_BFu16ll_Ul()
{
  {
    init_simple_test("Sf_BFu16ll_Ul");
    static Sf_BFu16ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu16ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_Ul(Test_Sf_BFu16ll_Ul, "Sf_BFu16ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_Us  {
  ::empty v1;
  __tsu64 v2:16;
  unsigned short v3;
};
//SIG(1 Sf_BFu16ll_Us) C1{ FC2{} FL:16 Fs}



static void Test_Sf_BFu16ll_Us()
{
  {
    init_simple_test("Sf_BFu16ll_Us");
    static Sf_BFu16ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_Us");
    check_field_offset(lv, v3, 4, "Sf_BFu16ll_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_Us(Test_Sf_BFu16ll_Us, "Sf_BFu16ll_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16ll_Vp  {
  ::empty v1;
  __tsu64 v2:16;
  void *v3;
};
//SIG(1 Sf_BFu16ll_Vp) C1{ FC2{} FL:16 Fp}



static void Test_Sf_BFu16ll_Vp()
{
  {
    init_simple_test("Sf_BFu16ll_Vp");
    static Sf_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu16ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 16, 1, "Sf_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 16, hide_ull(1LL<<15), "Sf_BFu16ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16ll_Vp(Test_Sf_BFu16ll_Vp, "Sf_BFu16ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s  {
  ::empty v1;
  unsigned short v2:16;
};
//SIG(1 Sf_BFu16s) C1{ FC2{} Fs:16}



static void Test_Sf_BFu16s()
{
  {
    init_simple_test("Sf_BFu16s");
    static Sf_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu16s(Test_Sf_BFu16s, "Sf_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu15i  {
  ::empty v1;
  unsigned short v2:16;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu16s_BFu15i) C1{ FC2{} Fs:16 Fi:15}



static void Test_Sf_BFu16s_BFu15i()
{
  {
    init_simple_test("Sf_BFu16s_BFu15i");
    static Sf_BFu16s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Sf_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Sf_BFu16s_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu15i(Test_Sf_BFu16s_BFu15i, "Sf_BFu16s_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu15ll  {
  ::empty v1;
  unsigned short v2:16;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu16s_BFu15ll) C1{ FC2{} Fs:16 FL:15}



static void Test_Sf_BFu16s_BFu15ll()
{
  {
    init_simple_test("Sf_BFu16s_BFu15ll");
    static Sf_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Sf_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Sf_BFu16s_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu15ll(Test_Sf_BFu16s_BFu15ll, "Sf_BFu16s_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu15s  {
  ::empty v1;
  unsigned short v2:16;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu16s_BFu15s) C1{ FC2{} Fs:16 Fs:15}



static void Test_Sf_BFu16s_BFu15s()
{
  {
    init_simple_test("Sf_BFu16s_BFu15s");
    static Sf_BFu16s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu16s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Sf_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Sf_BFu16s_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu15s(Test_Sf_BFu16s_BFu15s, "Sf_BFu16s_BFu15s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu16i  {
  ::empty v1;
  unsigned short v2:16;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu16s_BFu16i) C1{ FC2{} Fs:16 Fi:16}



static void Test_Sf_BFu16s_BFu16i()
{
  {
    init_simple_test("Sf_BFu16s_BFu16i");
    static Sf_BFu16s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu16i(Test_Sf_BFu16s_BFu16i, "Sf_BFu16s_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu16ll  {
  ::empty v1;
  unsigned short v2:16;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu16s_BFu16ll) C1{ FC2{} Fs:16 FL:16}



static void Test_Sf_BFu16s_BFu16ll()
{
  {
    init_simple_test("Sf_BFu16s_BFu16ll");
    static Sf_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu16ll(Test_Sf_BFu16s_BFu16ll, "Sf_BFu16s_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu16s  {
  ::empty v1;
  unsigned short v2:16;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu16s_BFu16s) C1{ FC2{} Fs:16 Fs:16}



static void Test_Sf_BFu16s_BFu16s()
{
  {
    init_simple_test("Sf_BFu16s_BFu16s");
    static Sf_BFu16s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu16s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu16s(Test_Sf_BFu16s_BFu16s, "Sf_BFu16s_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu17i  {
  ::empty v1;
  unsigned short v2:16;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu16s_BFu17i) C1{ FC2{} Fs:16 Fi:17}



static void Test_Sf_BFu16s_BFu17i()
{
  {
    init_simple_test("Sf_BFu16s_BFu17i");
    static Sf_BFu16s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Sf_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Sf_BFu16s_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu17i(Test_Sf_BFu16s_BFu17i, "Sf_BFu16s_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu17ll  {
  ::empty v1;
  unsigned short v2:16;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu16s_BFu17ll) C1{ FC2{} Fs:16 FL:17}



static void Test_Sf_BFu16s_BFu17ll()
{
  {
    init_simple_test("Sf_BFu16s_BFu17ll");
    static Sf_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Sf_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Sf_BFu16s_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu17ll(Test_Sf_BFu16s_BFu17ll, "Sf_BFu16s_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu1c  {
  ::empty v1;
  unsigned short v2:16;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu16s_BFu1c) C1{ FC2{} Fs:16 Fc:1}



static void Test_Sf_BFu16s_BFu1c()
{
  {
    init_simple_test("Sf_BFu16s_BFu1c");
    static Sf_BFu16s_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu16s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Sf_BFu16s_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu1c(Test_Sf_BFu16s_BFu1c, "Sf_BFu16s_BFu1c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu1i  {
  ::empty v1;
  unsigned short v2:16;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu16s_BFu1i) C1{ FC2{} Fs:16 Fi:1}



static void Test_Sf_BFu16s_BFu1i()
{
  {
    init_simple_test("Sf_BFu16s_BFu1i");
    static Sf_BFu16s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Sf_BFu16s_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu1i(Test_Sf_BFu16s_BFu1i, "Sf_BFu16s_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu1ll  {
  ::empty v1;
  unsigned short v2:16;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu16s_BFu1ll) C1{ FC2{} Fs:16 FL:1}



static void Test_Sf_BFu16s_BFu1ll()
{
  {
    init_simple_test("Sf_BFu16s_BFu1ll");
    static Sf_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Sf_BFu16s_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu1ll(Test_Sf_BFu16s_BFu1ll, "Sf_BFu16s_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu1s  {
  ::empty v1;
  unsigned short v2:16;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu16s_BFu1s) C1{ FC2{} Fs:16 Fs:1}



static void Test_Sf_BFu16s_BFu1s()
{
  {
    init_simple_test("Sf_BFu16s_BFu1s");
    static Sf_BFu16s_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu16s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Sf_BFu16s_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu1s(Test_Sf_BFu16s_BFu1s, "Sf_BFu16s_BFu1s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu31i  {
  ::empty v1;
  unsigned short v2:16;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu16s_BFu31i) C1{ FC2{} Fs:16 Fi:31}



static void Test_Sf_BFu16s_BFu31i()
{
  {
    init_simple_test("Sf_BFu16s_BFu31i");
    static Sf_BFu16s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu16s_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu31i(Test_Sf_BFu16s_BFu31i, "Sf_BFu16s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu31ll  {
  ::empty v1;
  unsigned short v2:16;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu16s_BFu31ll) C1{ FC2{} Fs:16 FL:31}



static void Test_Sf_BFu16s_BFu31ll()
{
  {
    init_simple_test("Sf_BFu16s_BFu31ll");
    static Sf_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu16s_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu31ll(Test_Sf_BFu16s_BFu31ll, "Sf_BFu16s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu32i  {
  ::empty v1;
  unsigned short v2:16;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu16s_BFu32i) C1{ FC2{} Fs:16 Fi:32}



static void Test_Sf_BFu16s_BFu32i()
{
  {
    init_simple_test("Sf_BFu16s_BFu32i");
    static Sf_BFu16s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu16s_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu32i(Test_Sf_BFu16s_BFu32i, "Sf_BFu16s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu32ll  {
  ::empty v1;
  unsigned short v2:16;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu16s_BFu32ll) C1{ FC2{} Fs:16 FL:32}



static void Test_Sf_BFu16s_BFu32ll()
{
  {
    init_simple_test("Sf_BFu16s_BFu32ll");
    static Sf_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu16s_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu32ll(Test_Sf_BFu16s_BFu32ll, "Sf_BFu16s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu33  {
  ::empty v1;
  unsigned short v2:16;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu16s_BFu33) C1{ FC2{} Fs:16 FL:33}



static void Test_Sf_BFu16s_BFu33()
{
  {
    init_simple_test("Sf_BFu16s_BFu33");
    static Sf_BFu16s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu16s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "Sf_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Sf_BFu16s_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu33(Test_Sf_BFu16s_BFu33, "Sf_BFu16s_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu7c  {
  ::empty v1;
  unsigned short v2:16;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu16s_BFu7c) C1{ FC2{} Fs:16 Fc:7}



static void Test_Sf_BFu16s_BFu7c()
{
  {
    init_simple_test("Sf_BFu16s_BFu7c");
    static Sf_BFu16s_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu16s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Sf_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Sf_BFu16s_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu7c(Test_Sf_BFu16s_BFu7c, "Sf_BFu16s_BFu7c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu7i  {
  ::empty v1;
  unsigned short v2:16;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu16s_BFu7i) C1{ FC2{} Fs:16 Fi:7}



static void Test_Sf_BFu16s_BFu7i()
{
  {
    init_simple_test("Sf_BFu16s_BFu7i");
    static Sf_BFu16s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Sf_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Sf_BFu16s_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu7i(Test_Sf_BFu16s_BFu7i, "Sf_BFu16s_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu7ll  {
  ::empty v1;
  unsigned short v2:16;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu16s_BFu7ll) C1{ FC2{} Fs:16 FL:7}



static void Test_Sf_BFu16s_BFu7ll()
{
  {
    init_simple_test("Sf_BFu16s_BFu7ll");
    static Sf_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Sf_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Sf_BFu16s_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu7ll(Test_Sf_BFu16s_BFu7ll, "Sf_BFu16s_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu7s  {
  ::empty v1;
  unsigned short v2:16;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu16s_BFu7s) C1{ FC2{} Fs:16 Fs:7}



static void Test_Sf_BFu16s_BFu7s()
{
  {
    init_simple_test("Sf_BFu16s_BFu7s");
    static Sf_BFu16s_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu16s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Sf_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Sf_BFu16s_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu7s(Test_Sf_BFu16s_BFu7s, "Sf_BFu16s_BFu7s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu8c  {
  ::empty v1;
  unsigned short v2:16;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu16s_BFu8c) C1{ FC2{} Fs:16 Fc:8}



static void Test_Sf_BFu16s_BFu8c()
{
  {
    init_simple_test("Sf_BFu16s_BFu8c");
    static Sf_BFu16s_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu16s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Sf_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Sf_BFu16s_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu8c(Test_Sf_BFu16s_BFu8c, "Sf_BFu16s_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu8i  {
  ::empty v1;
  unsigned short v2:16;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu16s_BFu8i) C1{ FC2{} Fs:16 Fi:8}



static void Test_Sf_BFu16s_BFu8i()
{
  {
    init_simple_test("Sf_BFu16s_BFu8i");
    static Sf_BFu16s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Sf_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Sf_BFu16s_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu8i(Test_Sf_BFu16s_BFu8i, "Sf_BFu16s_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu8ll  {
  ::empty v1;
  unsigned short v2:16;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu16s_BFu8ll) C1{ FC2{} Fs:16 FL:8}



static void Test_Sf_BFu16s_BFu8ll()
{
  {
    init_simple_test("Sf_BFu16s_BFu8ll");
    static Sf_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Sf_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Sf_BFu16s_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu8ll(Test_Sf_BFu16s_BFu8ll, "Sf_BFu16s_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu8s  {
  ::empty v1;
  unsigned short v2:16;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu16s_BFu8s) C1{ FC2{} Fs:16 Fs:8}



static void Test_Sf_BFu16s_BFu8s()
{
  {
    init_simple_test("Sf_BFu16s_BFu8s");
    static Sf_BFu16s_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu16s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Sf_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Sf_BFu16s_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu8s(Test_Sf_BFu16s_BFu8s, "Sf_BFu16s_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu9i  {
  ::empty v1;
  unsigned short v2:16;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu16s_BFu9i) C1{ FC2{} Fs:16 Fi:9}



static void Test_Sf_BFu16s_BFu9i()
{
  {
    init_simple_test("Sf_BFu16s_BFu9i");
    static Sf_BFu16s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Sf_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Sf_BFu16s_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu9i(Test_Sf_BFu16s_BFu9i, "Sf_BFu16s_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu9ll  {
  ::empty v1;
  unsigned short v2:16;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu16s_BFu9ll) C1{ FC2{} Fs:16 FL:9}



static void Test_Sf_BFu16s_BFu9ll()
{
  {
    init_simple_test("Sf_BFu16s_BFu9ll");
    static Sf_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Sf_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Sf_BFu16s_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu9ll(Test_Sf_BFu16s_BFu9ll, "Sf_BFu16s_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_BFu9s  {
  ::empty v1;
  unsigned short v2:16;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu16s_BFu9s) C1{ FC2{} Fs:16 Fs:9}



static void Test_Sf_BFu16s_BFu9s()
{
  {
    init_simple_test("Sf_BFu16s_BFu9s");
    static Sf_BFu16s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu16s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Sf_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Sf_BFu16s_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_BFu9s(Test_Sf_BFu16s_BFu9s, "Sf_BFu16s_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_C  {
  ::empty v1;
  unsigned short v2:16;
  char v3;
};
//SIG(1 Sf_BFu16s_C) C1{ FC2{} Fs:16 Fc}



static void Test_Sf_BFu16s_C()
{
  {
    init_simple_test("Sf_BFu16s_C");
    static Sf_BFu16s_C lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu16s_C)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_C");
    check_field_offset(lv, v3, 4, "Sf_BFu16s_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_C(Test_Sf_BFu16s_C, "Sf_BFu16s_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_D  {
  ::empty v1;
  unsigned short v2:16;
  double v3;
};
//SIG(1 Sf_BFu16s_D) C1{ FC2{} Fs:16 FL}



static void Test_Sf_BFu16s_D()
{
  {
    init_simple_test("Sf_BFu16s_D");
    static Sf_BFu16s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu16s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16s_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_D(Test_Sf_BFu16s_D, "Sf_BFu16s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_F  {
  ::empty v1;
  unsigned short v2:16;
  float v3;
};
//SIG(1 Sf_BFu16s_F) C1{ FC2{} Fs:16 Fi}



static void Test_Sf_BFu16s_F()
{
  {
    init_simple_test("Sf_BFu16s_F");
    static Sf_BFu16s_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16s_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_F");
    check_field_offset(lv, v3, 4, "Sf_BFu16s_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_F(Test_Sf_BFu16s_F, "Sf_BFu16s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_I  {
  ::empty v1;
  unsigned short v2:16;
  int v3;
};
//SIG(1 Sf_BFu16s_I) C1{ FC2{} Fs:16 Fi}



static void Test_Sf_BFu16s_I()
{
  {
    init_simple_test("Sf_BFu16s_I");
    static Sf_BFu16s_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16s_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_I");
    check_field_offset(lv, v3, 4, "Sf_BFu16s_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_I(Test_Sf_BFu16s_I, "Sf_BFu16s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_Ip  {
  ::empty v1;
  unsigned short v2:16;
  int *v3;
};
//SIG(1 Sf_BFu16s_Ip) C1{ FC2{} Fs:16 Fp}



static void Test_Sf_BFu16s_Ip()
{
  {
    init_simple_test("Sf_BFu16s_Ip");
    static Sf_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu16s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16s_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_Ip(Test_Sf_BFu16s_Ip, "Sf_BFu16s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_L  {
  ::empty v1;
  unsigned short v2:16;
  __tsi64 v3;
};
//SIG(1 Sf_BFu16s_L) C1{ FC2{} Fs:16 FL}



static void Test_Sf_BFu16s_L()
{
  {
    init_simple_test("Sf_BFu16s_L");
    static Sf_BFu16s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu16s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16s_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_L(Test_Sf_BFu16s_L, "Sf_BFu16s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_S  {
  ::empty v1;
  unsigned short v2:16;
  short v3;
};
//SIG(1 Sf_BFu16s_S) C1{ FC2{} Fs:16 Fs}



static void Test_Sf_BFu16s_S()
{
  {
    init_simple_test("Sf_BFu16s_S");
    static Sf_BFu16s_S lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu16s_S)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_S");
    check_field_offset(lv, v3, 4, "Sf_BFu16s_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_S(Test_Sf_BFu16s_S, "Sf_BFu16s_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_Sf  {
  ::empty v1;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 Sf_BFu16s_Sf) C1{ FC2{} Fs:16 FC2}



static void Test_Sf_BFu16s_Sf()
{
  {
    init_simple_test("Sf_BFu16s_Sf");
    static Sf_BFu16s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu16s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_Sf.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "Sf_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_Sf(Test_Sf_BFu16s_Sf, "Sf_BFu16s_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_Uc  {
  ::empty v1;
  unsigned short v2:16;
  unsigned char v3;
};
//SIG(1 Sf_BFu16s_Uc) C1{ FC2{} Fs:16 Fc}



static void Test_Sf_BFu16s_Uc()
{
  {
    init_simple_test("Sf_BFu16s_Uc");
    static Sf_BFu16s_Uc lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu16s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_Uc");
    check_field_offset(lv, v3, 4, "Sf_BFu16s_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_Uc(Test_Sf_BFu16s_Uc, "Sf_BFu16s_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_Ui  {
  ::empty v1;
  unsigned short v2:16;
  unsigned int v3;
};
//SIG(1 Sf_BFu16s_Ui) C1{ FC2{} Fs:16 Fi}



static void Test_Sf_BFu16s_Ui()
{
  {
    init_simple_test("Sf_BFu16s_Ui");
    static Sf_BFu16s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu16s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu16s_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_Ui(Test_Sf_BFu16s_Ui, "Sf_BFu16s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_Ul  {
  ::empty v1;
  unsigned short v2:16;
  __tsu64 v3;
};
//SIG(1 Sf_BFu16s_Ul) C1{ FC2{} Fs:16 FL}



static void Test_Sf_BFu16s_Ul()
{
  {
    init_simple_test("Sf_BFu16s_Ul");
    static Sf_BFu16s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu16s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16s_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_Ul(Test_Sf_BFu16s_Ul, "Sf_BFu16s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_Us  {
  ::empty v1;
  unsigned short v2:16;
  unsigned short v3;
};
//SIG(1 Sf_BFu16s_Us) C1{ FC2{} Fs:16 Fs}



static void Test_Sf_BFu16s_Us()
{
  {
    init_simple_test("Sf_BFu16s_Us");
    static Sf_BFu16s_Us lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu16s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_Us");
    check_field_offset(lv, v3, 4, "Sf_BFu16s_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_Us(Test_Sf_BFu16s_Us, "Sf_BFu16s_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu16s_Vp  {
  ::empty v1;
  unsigned short v2:16;
  void *v3;
};
//SIG(1 Sf_BFu16s_Vp) C1{ FC2{} Fs:16 Fp}



static void Test_Sf_BFu16s_Vp()
{
  {
    init_simple_test("Sf_BFu16s_Vp");
    static Sf_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu16s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Sf_BFu16s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu16s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu16s_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu16s_Vp(Test_Sf_BFu16s_Vp, "Sf_BFu16s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i  {
  ::empty v1;
  unsigned int v2:17;
};
//SIG(1 Sf_BFu17i) C1{ FC2{} Fi:17}



static void Test_Sf_BFu17i()
{
  {
    init_simple_test("Sf_BFu17i");
    static Sf_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu17i(Test_Sf_BFu17i, "Sf_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu15i  {
  ::empty v1;
  unsigned int v2:17;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu17i_BFu15i) C1{ FC2{} Fi:17 Fi:15}



static void Test_Sf_BFu17i_BFu15i()
{
  {
    init_simple_test("Sf_BFu17i_BFu15i");
    static Sf_BFu17i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Sf_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Sf_BFu17i_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu15i(Test_Sf_BFu17i_BFu15i, "Sf_BFu17i_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu15ll  {
  ::empty v1;
  unsigned int v2:17;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu17i_BFu15ll) C1{ FC2{} Fi:17 FL:15}



static void Test_Sf_BFu17i_BFu15ll()
{
  {
    init_simple_test("Sf_BFu17i_BFu15ll");
    static Sf_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "Sf_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "Sf_BFu17i_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu15ll(Test_Sf_BFu17i_BFu15ll, "Sf_BFu17i_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu15s  {
  ::empty v1;
  unsigned int v2:17;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu17i_BFu15s) C1{ FC2{} Fi:17 Fs:15}



static void Test_Sf_BFu17i_BFu15s()
{
  {
    init_simple_test("Sf_BFu17i_BFu15s");
    static Sf_BFu17i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Sf_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Sf_BFu17i_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu15s(Test_Sf_BFu17i_BFu15s, "Sf_BFu17i_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu16i  {
  ::empty v1;
  unsigned int v2:17;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu17i_BFu16i) C1{ FC2{} Fi:17 Fi:16}



static void Test_Sf_BFu17i_BFu16i()
{
  {
    init_simple_test("Sf_BFu17i_BFu16i");
    static Sf_BFu17i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu17i_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu16i(Test_Sf_BFu17i_BFu16i, "Sf_BFu17i_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu16ll  {
  ::empty v1;
  unsigned int v2:17;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu17i_BFu16ll) C1{ FC2{} Fi:17 FL:16}



static void Test_Sf_BFu17i_BFu16ll()
{
  {
    init_simple_test("Sf_BFu17i_BFu16ll");
    static Sf_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "Sf_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "Sf_BFu17i_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu16ll(Test_Sf_BFu17i_BFu16ll, "Sf_BFu17i_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu16s  {
  ::empty v1;
  unsigned int v2:17;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu17i_BFu16s) C1{ FC2{} Fi:17 Fs:16}



static void Test_Sf_BFu17i_BFu16s()
{
  {
    init_simple_test("Sf_BFu17i_BFu16s");
    static Sf_BFu17i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu17i_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu16s(Test_Sf_BFu17i_BFu16s, "Sf_BFu17i_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu17i  {
  ::empty v1;
  unsigned int v2:17;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu17i_BFu17i) C1{ FC2{} Fi:17 Fi:17}



static void Test_Sf_BFu17i_BFu17i()
{
  {
    init_simple_test("Sf_BFu17i_BFu17i");
    static Sf_BFu17i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Sf_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu17i(Test_Sf_BFu17i_BFu17i, "Sf_BFu17i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu17ll  {
  ::empty v1;
  unsigned int v2:17;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu17i_BFu17ll) C1{ FC2{} Fi:17 FL:17}



static void Test_Sf_BFu17i_BFu17ll()
{
  {
    init_simple_test("Sf_BFu17i_BFu17ll");
    static Sf_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "Sf_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu17ll(Test_Sf_BFu17i_BFu17ll, "Sf_BFu17i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu1c  {
  ::empty v1;
  unsigned int v2:17;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu17i_BFu1c) C1{ FC2{} Fi:17 Fc:1}



static void Test_Sf_BFu17i_BFu1c()
{
  {
    init_simple_test("Sf_BFu17i_BFu1c");
    static Sf_BFu17i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu17i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Sf_BFu17i_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu1c(Test_Sf_BFu17i_BFu1c, "Sf_BFu17i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu1i  {
  ::empty v1;
  unsigned int v2:17;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu17i_BFu1i) C1{ FC2{} Fi:17 Fi:1}



static void Test_Sf_BFu17i_BFu1i()
{
  {
    init_simple_test("Sf_BFu17i_BFu1i");
    static Sf_BFu17i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu17i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Sf_BFu17i_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu1i(Test_Sf_BFu17i_BFu1i, "Sf_BFu17i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu1ll  {
  ::empty v1;
  unsigned int v2:17;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu17i_BFu1ll) C1{ FC2{} Fi:17 FL:1}



static void Test_Sf_BFu17i_BFu1ll()
{
  {
    init_simple_test("Sf_BFu17i_BFu1ll");
    static Sf_BFu17i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu17i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Sf_BFu17i_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu1ll(Test_Sf_BFu17i_BFu1ll, "Sf_BFu17i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu1s  {
  ::empty v1;
  unsigned int v2:17;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu17i_BFu1s) C1{ FC2{} Fi:17 Fs:1}



static void Test_Sf_BFu17i_BFu1s()
{
  {
    init_simple_test("Sf_BFu17i_BFu1s");
    static Sf_BFu17i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu17i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Sf_BFu17i_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu1s(Test_Sf_BFu17i_BFu1s, "Sf_BFu17i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu31i  {
  ::empty v1;
  unsigned int v2:17;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu17i_BFu31i) C1{ FC2{} Fi:17 Fi:31}



static void Test_Sf_BFu17i_BFu31i()
{
  {
    init_simple_test("Sf_BFu17i_BFu31i");
    static Sf_BFu17i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu17i_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu31i(Test_Sf_BFu17i_BFu31i, "Sf_BFu17i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu31ll  {
  ::empty v1;
  unsigned int v2:17;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu17i_BFu31ll) C1{ FC2{} Fi:17 FL:31}



static void Test_Sf_BFu17i_BFu31ll()
{
  {
    init_simple_test("Sf_BFu17i_BFu31ll");
    static Sf_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "Sf_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "Sf_BFu17i_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu31ll(Test_Sf_BFu17i_BFu31ll, "Sf_BFu17i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu32i  {
  ::empty v1;
  unsigned int v2:17;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu17i_BFu32i) C1{ FC2{} Fi:17 Fi:32}



static void Test_Sf_BFu17i_BFu32i()
{
  {
    init_simple_test("Sf_BFu17i_BFu32i");
    static Sf_BFu17i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu17i_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu32i(Test_Sf_BFu17i_BFu32i, "Sf_BFu17i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu32ll  {
  ::empty v1;
  unsigned int v2:17;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu17i_BFu32ll) C1{ FC2{} Fi:17 FL:32}



static void Test_Sf_BFu17i_BFu32ll()
{
  {
    init_simple_test("Sf_BFu17i_BFu32ll");
    static Sf_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "Sf_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "Sf_BFu17i_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu32ll(Test_Sf_BFu17i_BFu32ll, "Sf_BFu17i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu33  {
  ::empty v1;
  unsigned int v2:17;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu17i_BFu33) C1{ FC2{} Fi:17 FL:33}



static void Test_Sf_BFu17i_BFu33()
{
  {
    init_simple_test("Sf_BFu17i_BFu33");
    static Sf_BFu17i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "Sf_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "Sf_BFu17i_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu33(Test_Sf_BFu17i_BFu33, "Sf_BFu17i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu7c  {
  ::empty v1;
  unsigned int v2:17;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu17i_BFu7c) C1{ FC2{} Fi:17 Fc:7}



static void Test_Sf_BFu17i_BFu7c()
{
  {
    init_simple_test("Sf_BFu17i_BFu7c");
    static Sf_BFu17i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu17i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Sf_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Sf_BFu17i_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu7c(Test_Sf_BFu17i_BFu7c, "Sf_BFu17i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu7i  {
  ::empty v1;
  unsigned int v2:17;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu17i_BFu7i) C1{ FC2{} Fi:17 Fi:7}



static void Test_Sf_BFu17i_BFu7i()
{
  {
    init_simple_test("Sf_BFu17i_BFu7i");
    static Sf_BFu17i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu17i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Sf_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Sf_BFu17i_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu7i(Test_Sf_BFu17i_BFu7i, "Sf_BFu17i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu7ll  {
  ::empty v1;
  unsigned int v2:17;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu17i_BFu7ll) C1{ FC2{} Fi:17 FL:7}



static void Test_Sf_BFu17i_BFu7ll()
{
  {
    init_simple_test("Sf_BFu17i_BFu7ll");
    static Sf_BFu17i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu17i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Sf_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Sf_BFu17i_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu7ll(Test_Sf_BFu17i_BFu7ll, "Sf_BFu17i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu7s  {
  ::empty v1;
  unsigned int v2:17;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu17i_BFu7s) C1{ FC2{} Fi:17 Fs:7}



static void Test_Sf_BFu17i_BFu7s()
{
  {
    init_simple_test("Sf_BFu17i_BFu7s");
    static Sf_BFu17i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu17i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Sf_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Sf_BFu17i_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu7s(Test_Sf_BFu17i_BFu7s, "Sf_BFu17i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu8c  {
  ::empty v1;
  unsigned int v2:17;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu17i_BFu8c) C1{ FC2{} Fi:17 Fc:8}



static void Test_Sf_BFu17i_BFu8c()
{
  {
    init_simple_test("Sf_BFu17i_BFu8c");
    static Sf_BFu17i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Sf_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Sf_BFu17i_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu8c(Test_Sf_BFu17i_BFu8c, "Sf_BFu17i_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu8i  {
  ::empty v1;
  unsigned int v2:17;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu17i_BFu8i) C1{ FC2{} Fi:17 Fi:8}



static void Test_Sf_BFu17i_BFu8i()
{
  {
    init_simple_test("Sf_BFu17i_BFu8i");
    static Sf_BFu17i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Sf_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Sf_BFu17i_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu8i(Test_Sf_BFu17i_BFu8i, "Sf_BFu17i_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu8ll  {
  ::empty v1;
  unsigned int v2:17;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu17i_BFu8ll) C1{ FC2{} Fi:17 FL:8}



static void Test_Sf_BFu17i_BFu8ll()
{
  {
    init_simple_test("Sf_BFu17i_BFu8ll");
    static Sf_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "Sf_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "Sf_BFu17i_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu8ll(Test_Sf_BFu17i_BFu8ll, "Sf_BFu17i_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu8s  {
  ::empty v1;
  unsigned int v2:17;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu17i_BFu8s) C1{ FC2{} Fi:17 Fs:8}



static void Test_Sf_BFu17i_BFu8s()
{
  {
    init_simple_test("Sf_BFu17i_BFu8s");
    static Sf_BFu17i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Sf_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Sf_BFu17i_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu8s(Test_Sf_BFu17i_BFu8s, "Sf_BFu17i_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu9i  {
  ::empty v1;
  unsigned int v2:17;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu17i_BFu9i) C1{ FC2{} Fi:17 Fi:9}



static void Test_Sf_BFu17i_BFu9i()
{
  {
    init_simple_test("Sf_BFu17i_BFu9i");
    static Sf_BFu17i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Sf_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Sf_BFu17i_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu9i(Test_Sf_BFu17i_BFu9i, "Sf_BFu17i_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu9ll  {
  ::empty v1;
  unsigned int v2:17;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu17i_BFu9ll) C1{ FC2{} Fi:17 FL:9}



static void Test_Sf_BFu17i_BFu9ll()
{
  {
    init_simple_test("Sf_BFu17i_BFu9ll");
    static Sf_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "Sf_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "Sf_BFu17i_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu9ll(Test_Sf_BFu17i_BFu9ll, "Sf_BFu17i_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_BFu9s  {
  ::empty v1;
  unsigned int v2:17;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu17i_BFu9s) C1{ FC2{} Fi:17 Fs:9}



static void Test_Sf_BFu17i_BFu9s()
{
  {
    init_simple_test("Sf_BFu17i_BFu9s");
    static Sf_BFu17i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Sf_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Sf_BFu17i_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_BFu9s(Test_Sf_BFu17i_BFu9s, "Sf_BFu17i_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_C  {
  ::empty v1;
  unsigned int v2:17;
  char v3;
};
//SIG(1 Sf_BFu17i_C) C1{ FC2{} Fi:17 Fc}



static void Test_Sf_BFu17i_C()
{
  {
    init_simple_test("Sf_BFu17i_C");
    static Sf_BFu17i_C lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_C");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_C");
    check_field_offset(lv, v3, 4, "Sf_BFu17i_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_C(Test_Sf_BFu17i_C, "Sf_BFu17i_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_D  {
  ::empty v1;
  unsigned int v2:17;
  double v3;
};
//SIG(1 Sf_BFu17i_D) C1{ FC2{} Fi:17 FL}



static void Test_Sf_BFu17i_D()
{
  {
    init_simple_test("Sf_BFu17i_D");
    static Sf_BFu17i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu17i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_D");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu17i_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_D(Test_Sf_BFu17i_D, "Sf_BFu17i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_F  {
  ::empty v1;
  unsigned int v2:17;
  float v3;
};
//SIG(1 Sf_BFu17i_F) C1{ FC2{} Fi:17 Fi}



static void Test_Sf_BFu17i_F()
{
  {
    init_simple_test("Sf_BFu17i_F");
    static Sf_BFu17i_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_F");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_F");
    check_field_offset(lv, v3, 4, "Sf_BFu17i_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_F(Test_Sf_BFu17i_F, "Sf_BFu17i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_I  {
  ::empty v1;
  unsigned int v2:17;
  int v3;
};
//SIG(1 Sf_BFu17i_I) C1{ FC2{} Fi:17 Fi}



static void Test_Sf_BFu17i_I()
{
  {
    init_simple_test("Sf_BFu17i_I");
    static Sf_BFu17i_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_I");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_I");
    check_field_offset(lv, v3, 4, "Sf_BFu17i_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_I(Test_Sf_BFu17i_I, "Sf_BFu17i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_Ip  {
  ::empty v1;
  unsigned int v2:17;
  int *v3;
};
//SIG(1 Sf_BFu17i_Ip) C1{ FC2{} Fi:17 Fp}



static void Test_Sf_BFu17i_Ip()
{
  {
    init_simple_test("Sf_BFu17i_Ip");
    static Sf_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu17i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu17i_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_Ip(Test_Sf_BFu17i_Ip, "Sf_BFu17i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_L  {
  ::empty v1;
  unsigned int v2:17;
  __tsi64 v3;
};
//SIG(1 Sf_BFu17i_L) C1{ FC2{} Fi:17 FL}



static void Test_Sf_BFu17i_L()
{
  {
    init_simple_test("Sf_BFu17i_L");
    static Sf_BFu17i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu17i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_L");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu17i_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_L(Test_Sf_BFu17i_L, "Sf_BFu17i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_S  {
  ::empty v1;
  unsigned int v2:17;
  short v3;
};
//SIG(1 Sf_BFu17i_S) C1{ FC2{} Fi:17 Fs}



static void Test_Sf_BFu17i_S()
{
  {
    init_simple_test("Sf_BFu17i_S");
    static Sf_BFu17i_S lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_S");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_S");
    check_field_offset(lv, v3, 4, "Sf_BFu17i_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_S(Test_Sf_BFu17i_S, "Sf_BFu17i_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_Sf  {
  ::empty v1;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 Sf_BFu17i_Sf) C1{ FC2{} Fi:17 FC2}



static void Test_Sf_BFu17i_Sf()
{
  {
    init_simple_test("Sf_BFu17i_Sf");
    static Sf_BFu17i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_Sf");
    check_field_offset(lv, v3, 4, "Sf_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_Sf(Test_Sf_BFu17i_Sf, "Sf_BFu17i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_Uc  {
  ::empty v1;
  unsigned int v2:17;
  unsigned char v3;
};
//SIG(1 Sf_BFu17i_Uc) C1{ FC2{} Fi:17 Fc}



static void Test_Sf_BFu17i_Uc()
{
  {
    init_simple_test("Sf_BFu17i_Uc");
    static Sf_BFu17i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_Uc");
    check_field_offset(lv, v3, 4, "Sf_BFu17i_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_Uc(Test_Sf_BFu17i_Uc, "Sf_BFu17i_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_Ui  {
  ::empty v1;
  unsigned int v2:17;
  unsigned int v3;
};
//SIG(1 Sf_BFu17i_Ui) C1{ FC2{} Fi:17 Fi}



static void Test_Sf_BFu17i_Ui()
{
  {
    init_simple_test("Sf_BFu17i_Ui");
    static Sf_BFu17i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu17i_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_Ui(Test_Sf_BFu17i_Ui, "Sf_BFu17i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_Ul  {
  ::empty v1;
  unsigned int v2:17;
  __tsu64 v3;
};
//SIG(1 Sf_BFu17i_Ul) C1{ FC2{} Fi:17 FL}



static void Test_Sf_BFu17i_Ul()
{
  {
    init_simple_test("Sf_BFu17i_Ul");
    static Sf_BFu17i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu17i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu17i_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_Ul(Test_Sf_BFu17i_Ul, "Sf_BFu17i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_Us  {
  ::empty v1;
  unsigned int v2:17;
  unsigned short v3;
};
//SIG(1 Sf_BFu17i_Us) C1{ FC2{} Fi:17 Fs}



static void Test_Sf_BFu17i_Us()
{
  {
    init_simple_test("Sf_BFu17i_Us");
    static Sf_BFu17i_Us lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_Us");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_Us");
    check_field_offset(lv, v3, 4, "Sf_BFu17i_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_Us(Test_Sf_BFu17i_Us, "Sf_BFu17i_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17i_Vp  {
  ::empty v1;
  unsigned int v2:17;
  void *v3;
};
//SIG(1 Sf_BFu17i_Vp) C1{ FC2{} Fi:17 Fp}



static void Test_Sf_BFu17i_Vp()
{
  {
    init_simple_test("Sf_BFu17i_Vp");
    static Sf_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu17i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu17i_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17i_Vp(Test_Sf_BFu17i_Vp, "Sf_BFu17i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll  {
  ::empty v1;
  __tsu64 v2:17;
};
//SIG(1 Sf_BFu17ll) C1{ FC2{} FL:17}



static void Test_Sf_BFu17ll()
{
  {
    init_simple_test("Sf_BFu17ll");
    static Sf_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll(Test_Sf_BFu17ll, "Sf_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu15i  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu17ll_BFu15i) C1{ FC2{} FL:17 Fi:15}



static void Test_Sf_BFu17ll_BFu15i()
{
  {
    init_simple_test("Sf_BFu17ll_BFu15i");
    static Sf_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Sf_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Sf_BFu17ll_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu15i(Test_Sf_BFu17ll_BFu15i, "Sf_BFu17ll_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu15ll  {
  ::empty v1;
  __tsu64 v2:17;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu17ll_BFu15ll) C1{ FC2{} FL:17 FL:15}



static void Test_Sf_BFu17ll_BFu15ll()
{
  {
    init_simple_test("Sf_BFu17ll_BFu15ll");
    static Sf_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "Sf_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "Sf_BFu17ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu15ll(Test_Sf_BFu17ll_BFu15ll, "Sf_BFu17ll_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu15s  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu17ll_BFu15s) C1{ FC2{} FL:17 Fs:15}



static void Test_Sf_BFu17ll_BFu15s()
{
  {
    init_simple_test("Sf_BFu17ll_BFu15s");
    static Sf_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Sf_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Sf_BFu17ll_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu15s(Test_Sf_BFu17ll_BFu15s, "Sf_BFu17ll_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu16i  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu17ll_BFu16i) C1{ FC2{} FL:17 Fi:16}



static void Test_Sf_BFu17ll_BFu16i()
{
  {
    init_simple_test("Sf_BFu17ll_BFu16i");
    static Sf_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu17ll_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu16i(Test_Sf_BFu17ll_BFu16i, "Sf_BFu17ll_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu16ll  {
  ::empty v1;
  __tsu64 v2:17;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu17ll_BFu16ll) C1{ FC2{} FL:17 FL:16}



static void Test_Sf_BFu17ll_BFu16ll()
{
  {
    init_simple_test("Sf_BFu17ll_BFu16ll");
    static Sf_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "Sf_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "Sf_BFu17ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu16ll(Test_Sf_BFu17ll_BFu16ll, "Sf_BFu17ll_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu16s  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu17ll_BFu16s) C1{ FC2{} FL:17 Fs:16}



static void Test_Sf_BFu17ll_BFu16s()
{
  {
    init_simple_test("Sf_BFu17ll_BFu16s");
    static Sf_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu17ll_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu16s(Test_Sf_BFu17ll_BFu16s, "Sf_BFu17ll_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu17i  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu17ll_BFu17i) C1{ FC2{} FL:17 Fi:17}



static void Test_Sf_BFu17ll_BFu17i()
{
  {
    init_simple_test("Sf_BFu17ll_BFu17i");
    static Sf_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Sf_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu17i(Test_Sf_BFu17ll_BFu17i, "Sf_BFu17ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu17ll  {
  ::empty v1;
  __tsu64 v2:17;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu17ll_BFu17ll) C1{ FC2{} FL:17 FL:17}



static void Test_Sf_BFu17ll_BFu17ll()
{
  {
    init_simple_test("Sf_BFu17ll_BFu17ll");
    static Sf_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "Sf_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu17ll(Test_Sf_BFu17ll_BFu17ll, "Sf_BFu17ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu1c  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu17ll_BFu1c) C1{ FC2{} FL:17 Fc:1}



static void Test_Sf_BFu17ll_BFu1c()
{
  {
    init_simple_test("Sf_BFu17ll_BFu1c");
    static Sf_BFu17ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu17ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Sf_BFu17ll_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu1c(Test_Sf_BFu17ll_BFu1c, "Sf_BFu17ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu1i  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu17ll_BFu1i) C1{ FC2{} FL:17 Fi:1}



static void Test_Sf_BFu17ll_BFu1i()
{
  {
    init_simple_test("Sf_BFu17ll_BFu1i");
    static Sf_BFu17ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu17ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Sf_BFu17ll_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu1i(Test_Sf_BFu17ll_BFu1i, "Sf_BFu17ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu1ll  {
  ::empty v1;
  __tsu64 v2:17;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu17ll_BFu1ll) C1{ FC2{} FL:17 FL:1}



static void Test_Sf_BFu17ll_BFu1ll()
{
  {
    init_simple_test("Sf_BFu17ll_BFu1ll");
    static Sf_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Sf_BFu17ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu1ll(Test_Sf_BFu17ll_BFu1ll, "Sf_BFu17ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu1s  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu17ll_BFu1s) C1{ FC2{} FL:17 Fs:1}



static void Test_Sf_BFu17ll_BFu1s()
{
  {
    init_simple_test("Sf_BFu17ll_BFu1s");
    static Sf_BFu17ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu17ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Sf_BFu17ll_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu1s(Test_Sf_BFu17ll_BFu1s, "Sf_BFu17ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu31i  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu17ll_BFu31i) C1{ FC2{} FL:17 Fi:31}



static void Test_Sf_BFu17ll_BFu31i()
{
  {
    init_simple_test("Sf_BFu17ll_BFu31i");
    static Sf_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu17ll_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu31i(Test_Sf_BFu17ll_BFu31i, "Sf_BFu17ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu31ll  {
  ::empty v1;
  __tsu64 v2:17;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu17ll_BFu31ll) C1{ FC2{} FL:17 FL:31}



static void Test_Sf_BFu17ll_BFu31ll()
{
  {
    init_simple_test("Sf_BFu17ll_BFu31ll");
    static Sf_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "Sf_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "Sf_BFu17ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu31ll(Test_Sf_BFu17ll_BFu31ll, "Sf_BFu17ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu32i  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu17ll_BFu32i) C1{ FC2{} FL:17 Fi:32}



static void Test_Sf_BFu17ll_BFu32i()
{
  {
    init_simple_test("Sf_BFu17ll_BFu32i");
    static Sf_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu17ll_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu32i(Test_Sf_BFu17ll_BFu32i, "Sf_BFu17ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu32ll  {
  ::empty v1;
  __tsu64 v2:17;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu17ll_BFu32ll) C1{ FC2{} FL:17 FL:32}



static void Test_Sf_BFu17ll_BFu32ll()
{
  {
    init_simple_test("Sf_BFu17ll_BFu32ll");
    static Sf_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "Sf_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "Sf_BFu17ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu32ll(Test_Sf_BFu17ll_BFu32ll, "Sf_BFu17ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu33  {
  ::empty v1;
  __tsu64 v2:17;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu17ll_BFu33) C1{ FC2{} FL:17 FL:33}



static void Test_Sf_BFu17ll_BFu33()
{
  {
    init_simple_test("Sf_BFu17ll_BFu33");
    static Sf_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "Sf_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "Sf_BFu17ll_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu33(Test_Sf_BFu17ll_BFu33, "Sf_BFu17ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu7c  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu17ll_BFu7c) C1{ FC2{} FL:17 Fc:7}



static void Test_Sf_BFu17ll_BFu7c()
{
  {
    init_simple_test("Sf_BFu17ll_BFu7c");
    static Sf_BFu17ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu17ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Sf_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Sf_BFu17ll_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu7c(Test_Sf_BFu17ll_BFu7c, "Sf_BFu17ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu7i  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu17ll_BFu7i) C1{ FC2{} FL:17 Fi:7}



static void Test_Sf_BFu17ll_BFu7i()
{
  {
    init_simple_test("Sf_BFu17ll_BFu7i");
    static Sf_BFu17ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu17ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Sf_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Sf_BFu17ll_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu7i(Test_Sf_BFu17ll_BFu7i, "Sf_BFu17ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu7ll  {
  ::empty v1;
  __tsu64 v2:17;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu17ll_BFu7ll) C1{ FC2{} FL:17 FL:7}



static void Test_Sf_BFu17ll_BFu7ll()
{
  {
    init_simple_test("Sf_BFu17ll_BFu7ll");
    static Sf_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Sf_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Sf_BFu17ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu7ll(Test_Sf_BFu17ll_BFu7ll, "Sf_BFu17ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu7s  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu17ll_BFu7s) C1{ FC2{} FL:17 Fs:7}



static void Test_Sf_BFu17ll_BFu7s()
{
  {
    init_simple_test("Sf_BFu17ll_BFu7s");
    static Sf_BFu17ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu17ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Sf_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Sf_BFu17ll_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu7s(Test_Sf_BFu17ll_BFu7s, "Sf_BFu17ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu8c  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu17ll_BFu8c) C1{ FC2{} FL:17 Fc:8}



static void Test_Sf_BFu17ll_BFu8c()
{
  {
    init_simple_test("Sf_BFu17ll_BFu8c");
    static Sf_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Sf_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Sf_BFu17ll_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu8c(Test_Sf_BFu17ll_BFu8c, "Sf_BFu17ll_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu8i  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu17ll_BFu8i) C1{ FC2{} FL:17 Fi:8}



static void Test_Sf_BFu17ll_BFu8i()
{
  {
    init_simple_test("Sf_BFu17ll_BFu8i");
    static Sf_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Sf_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Sf_BFu17ll_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu8i(Test_Sf_BFu17ll_BFu8i, "Sf_BFu17ll_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu8ll  {
  ::empty v1;
  __tsu64 v2:17;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu17ll_BFu8ll) C1{ FC2{} FL:17 FL:8}



static void Test_Sf_BFu17ll_BFu8ll()
{
  {
    init_simple_test("Sf_BFu17ll_BFu8ll");
    static Sf_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "Sf_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "Sf_BFu17ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu8ll(Test_Sf_BFu17ll_BFu8ll, "Sf_BFu17ll_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu8s  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu17ll_BFu8s) C1{ FC2{} FL:17 Fs:8}



static void Test_Sf_BFu17ll_BFu8s()
{
  {
    init_simple_test("Sf_BFu17ll_BFu8s");
    static Sf_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Sf_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Sf_BFu17ll_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu8s(Test_Sf_BFu17ll_BFu8s, "Sf_BFu17ll_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu9i  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu17ll_BFu9i) C1{ FC2{} FL:17 Fi:9}



static void Test_Sf_BFu17ll_BFu9i()
{
  {
    init_simple_test("Sf_BFu17ll_BFu9i");
    static Sf_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Sf_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Sf_BFu17ll_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu9i(Test_Sf_BFu17ll_BFu9i, "Sf_BFu17ll_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu9ll  {
  ::empty v1;
  __tsu64 v2:17;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu17ll_BFu9ll) C1{ FC2{} FL:17 FL:9}



static void Test_Sf_BFu17ll_BFu9ll()
{
  {
    init_simple_test("Sf_BFu17ll_BFu9ll");
    static Sf_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "Sf_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "Sf_BFu17ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu9ll(Test_Sf_BFu17ll_BFu9ll, "Sf_BFu17ll_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_BFu9s  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu17ll_BFu9s) C1{ FC2{} FL:17 Fs:9}



static void Test_Sf_BFu17ll_BFu9s()
{
  {
    init_simple_test("Sf_BFu17ll_BFu9s");
    static Sf_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Sf_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Sf_BFu17ll_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_BFu9s(Test_Sf_BFu17ll_BFu9s, "Sf_BFu17ll_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_C  {
  ::empty v1;
  __tsu64 v2:17;
  char v3;
};
//SIG(1 Sf_BFu17ll_C) C1{ FC2{} FL:17 Fc}



static void Test_Sf_BFu17ll_C()
{
  {
    init_simple_test("Sf_BFu17ll_C");
    static Sf_BFu17ll_C lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_C");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_C");
    check_field_offset(lv, v3, 4, "Sf_BFu17ll_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_C(Test_Sf_BFu17ll_C, "Sf_BFu17ll_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_D  {
  ::empty v1;
  __tsu64 v2:17;
  double v3;
};
//SIG(1 Sf_BFu17ll_D) C1{ FC2{} FL:17 FL}



static void Test_Sf_BFu17ll_D()
{
  {
    init_simple_test("Sf_BFu17ll_D");
    static Sf_BFu17ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu17ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_D");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu17ll_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_D(Test_Sf_BFu17ll_D, "Sf_BFu17ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_F  {
  ::empty v1;
  __tsu64 v2:17;
  float v3;
};
//SIG(1 Sf_BFu17ll_F) C1{ FC2{} FL:17 Fi}



static void Test_Sf_BFu17ll_F()
{
  {
    init_simple_test("Sf_BFu17ll_F");
    static Sf_BFu17ll_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_F");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_F");
    check_field_offset(lv, v3, 4, "Sf_BFu17ll_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_F(Test_Sf_BFu17ll_F, "Sf_BFu17ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_I  {
  ::empty v1;
  __tsu64 v2:17;
  int v3;
};
//SIG(1 Sf_BFu17ll_I) C1{ FC2{} FL:17 Fi}



static void Test_Sf_BFu17ll_I()
{
  {
    init_simple_test("Sf_BFu17ll_I");
    static Sf_BFu17ll_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_I");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_I");
    check_field_offset(lv, v3, 4, "Sf_BFu17ll_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_I(Test_Sf_BFu17ll_I, "Sf_BFu17ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_Ip  {
  ::empty v1;
  __tsu64 v2:17;
  int *v3;
};
//SIG(1 Sf_BFu17ll_Ip) C1{ FC2{} FL:17 Fp}



static void Test_Sf_BFu17ll_Ip()
{
  {
    init_simple_test("Sf_BFu17ll_Ip");
    static Sf_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu17ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu17ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_Ip(Test_Sf_BFu17ll_Ip, "Sf_BFu17ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_L  {
  ::empty v1;
  __tsu64 v2:17;
  __tsi64 v3;
};
//SIG(1 Sf_BFu17ll_L) C1{ FC2{} FL:17 FL}



static void Test_Sf_BFu17ll_L()
{
  {
    init_simple_test("Sf_BFu17ll_L");
    static Sf_BFu17ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu17ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_L");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu17ll_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_L(Test_Sf_BFu17ll_L, "Sf_BFu17ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_S  {
  ::empty v1;
  __tsu64 v2:17;
  short v3;
};
//SIG(1 Sf_BFu17ll_S) C1{ FC2{} FL:17 Fs}



static void Test_Sf_BFu17ll_S()
{
  {
    init_simple_test("Sf_BFu17ll_S");
    static Sf_BFu17ll_S lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_S");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_S");
    check_field_offset(lv, v3, 4, "Sf_BFu17ll_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_S(Test_Sf_BFu17ll_S, "Sf_BFu17ll_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_Sf  {
  ::empty v1;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 Sf_BFu17ll_Sf) C1{ FC2{} FL:17 FC2}



static void Test_Sf_BFu17ll_Sf()
{
  {
    init_simple_test("Sf_BFu17ll_Sf");
    static Sf_BFu17ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_Sf");
    check_field_offset(lv, v3, 4, "Sf_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_Sf(Test_Sf_BFu17ll_Sf, "Sf_BFu17ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_Uc  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned char v3;
};
//SIG(1 Sf_BFu17ll_Uc) C1{ FC2{} FL:17 Fc}



static void Test_Sf_BFu17ll_Uc()
{
  {
    init_simple_test("Sf_BFu17ll_Uc");
    static Sf_BFu17ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_Uc");
    check_field_offset(lv, v3, 4, "Sf_BFu17ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_Uc(Test_Sf_BFu17ll_Uc, "Sf_BFu17ll_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_Ui  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned int v3;
};
//SIG(1 Sf_BFu17ll_Ui) C1{ FC2{} FL:17 Fi}



static void Test_Sf_BFu17ll_Ui()
{
  {
    init_simple_test("Sf_BFu17ll_Ui");
    static Sf_BFu17ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu17ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_Ui(Test_Sf_BFu17ll_Ui, "Sf_BFu17ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_Ul  {
  ::empty v1;
  __tsu64 v2:17;
  __tsu64 v3;
};
//SIG(1 Sf_BFu17ll_Ul) C1{ FC2{} FL:17 FL}



static void Test_Sf_BFu17ll_Ul()
{
  {
    init_simple_test("Sf_BFu17ll_Ul");
    static Sf_BFu17ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu17ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu17ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_Ul(Test_Sf_BFu17ll_Ul, "Sf_BFu17ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_Us  {
  ::empty v1;
  __tsu64 v2:17;
  unsigned short v3;
};
//SIG(1 Sf_BFu17ll_Us) C1{ FC2{} FL:17 Fs}



static void Test_Sf_BFu17ll_Us()
{
  {
    init_simple_test("Sf_BFu17ll_Us");
    static Sf_BFu17ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu17ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_Us");
    check_field_offset(lv, v3, 4, "Sf_BFu17ll_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_Us(Test_Sf_BFu17ll_Us, "Sf_BFu17ll_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu17ll_Vp  {
  ::empty v1;
  __tsu64 v2:17;
  void *v3;
};
//SIG(1 Sf_BFu17ll_Vp) C1{ FC2{} FL:17 Fp}



static void Test_Sf_BFu17ll_Vp()
{
  {
    init_simple_test("Sf_BFu17ll_Vp");
    static Sf_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu17ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 17, 1, "Sf_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 17, hide_ull(1LL<<16), "Sf_BFu17ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu17ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu17ll_Vp(Test_Sf_BFu17ll_Vp, "Sf_BFu17ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c  {
  ::empty v1;
  unsigned char v2:1;
};
//SIG(1 Sf_BFu1c) C1{ FC2{} Fc:1}



static void Test_Sf_BFu1c()
{
  {
    init_simple_test("Sf_BFu1c");
    static Sf_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu1c(Test_Sf_BFu1c, "Sf_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu15i  {
  ::empty v1;
  unsigned char v2:1;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu1c_BFu15i) C1{ FC2{} Fc:1 Fi:15}



static void Test_Sf_BFu1c_BFu15i()
{
  {
    init_simple_test("Sf_BFu1c_BFu15i");
    static Sf_BFu1c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Sf_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Sf_BFu1c_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu15i(Test_Sf_BFu1c_BFu15i, "Sf_BFu1c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu15ll  {
  ::empty v1;
  unsigned char v2:1;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu1c_BFu15ll) C1{ FC2{} Fc:1 FL:15}



static void Test_Sf_BFu1c_BFu15ll()
{
  {
    init_simple_test("Sf_BFu1c_BFu15ll");
    static Sf_BFu1c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Sf_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Sf_BFu1c_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu15ll(Test_Sf_BFu1c_BFu15ll, "Sf_BFu1c_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu15s  {
  ::empty v1;
  unsigned char v2:1;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu1c_BFu15s) C1{ FC2{} Fc:1 Fs:15}



static void Test_Sf_BFu1c_BFu15s()
{
  {
    init_simple_test("Sf_BFu1c_BFu15s");
    static Sf_BFu1c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu1c_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu15s(Test_Sf_BFu1c_BFu15s, "Sf_BFu1c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu16i  {
  ::empty v1;
  unsigned char v2:1;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu1c_BFu16i) C1{ FC2{} Fc:1 Fi:16}



static void Test_Sf_BFu1c_BFu16i()
{
  {
    init_simple_test("Sf_BFu1c_BFu16i");
    static Sf_BFu1c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Sf_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Sf_BFu1c_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu16i(Test_Sf_BFu1c_BFu16i, "Sf_BFu1c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu16ll  {
  ::empty v1;
  unsigned char v2:1;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu1c_BFu16ll) C1{ FC2{} Fc:1 FL:16}



static void Test_Sf_BFu1c_BFu16ll()
{
  {
    init_simple_test("Sf_BFu1c_BFu16ll");
    static Sf_BFu1c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Sf_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Sf_BFu1c_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu16ll(Test_Sf_BFu1c_BFu16ll, "Sf_BFu1c_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu16s  {
  ::empty v1;
  unsigned char v2:1;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu1c_BFu16s) C1{ FC2{} Fc:1 Fs:16}



static void Test_Sf_BFu1c_BFu16s()
{
  {
    init_simple_test("Sf_BFu1c_BFu16s");
    static Sf_BFu1c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu1c_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu16s(Test_Sf_BFu1c_BFu16s, "Sf_BFu1c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu17i  {
  ::empty v1;
  unsigned char v2:1;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu1c_BFu17i) C1{ FC2{} Fc:1 Fi:17}



static void Test_Sf_BFu1c_BFu17i()
{
  {
    init_simple_test("Sf_BFu1c_BFu17i");
    static Sf_BFu1c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Sf_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Sf_BFu1c_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu17i(Test_Sf_BFu1c_BFu17i, "Sf_BFu1c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu17ll  {
  ::empty v1;
  unsigned char v2:1;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu1c_BFu17ll) C1{ FC2{} Fc:1 FL:17}



static void Test_Sf_BFu1c_BFu17ll()
{
  {
    init_simple_test("Sf_BFu1c_BFu17ll");
    static Sf_BFu1c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Sf_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Sf_BFu1c_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu17ll(Test_Sf_BFu1c_BFu17ll, "Sf_BFu1c_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu1c  {
  ::empty v1;
  unsigned char v2:1;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu1c_BFu1c) C1{ FC2{} Fc:1 Fc:1}



static void Test_Sf_BFu1c_BFu1c()
{
  {
    init_simple_test("Sf_BFu1c_BFu1c");
    static Sf_BFu1c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1c_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu1c(Test_Sf_BFu1c_BFu1c, "Sf_BFu1c_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu1i  {
  ::empty v1;
  unsigned char v2:1;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu1c_BFu1i) C1{ FC2{} Fc:1 Fi:1}



static void Test_Sf_BFu1c_BFu1i()
{
  {
    init_simple_test("Sf_BFu1c_BFu1i");
    static Sf_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1c_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu1i(Test_Sf_BFu1c_BFu1i, "Sf_BFu1c_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu1ll  {
  ::empty v1;
  unsigned char v2:1;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu1c_BFu1ll) C1{ FC2{} Fc:1 FL:1}



static void Test_Sf_BFu1c_BFu1ll()
{
  {
    init_simple_test("Sf_BFu1c_BFu1ll");
    static Sf_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1c_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu1ll(Test_Sf_BFu1c_BFu1ll, "Sf_BFu1c_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu1s  {
  ::empty v1;
  unsigned char v2:1;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu1c_BFu1s) C1{ FC2{} Fc:1 Fs:1}



static void Test_Sf_BFu1c_BFu1s()
{
  {
    init_simple_test("Sf_BFu1c_BFu1s");
    static Sf_BFu1c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1c_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu1s(Test_Sf_BFu1c_BFu1s, "Sf_BFu1c_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu31i  {
  ::empty v1;
  unsigned char v2:1;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu1c_BFu31i) C1{ FC2{} Fc:1 Fi:31}



static void Test_Sf_BFu1c_BFu31i()
{
  {
    init_simple_test("Sf_BFu1c_BFu31i");
    static Sf_BFu1c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu1c_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu31i(Test_Sf_BFu1c_BFu31i, "Sf_BFu1c_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu31ll  {
  ::empty v1;
  unsigned char v2:1;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu1c_BFu31ll) C1{ FC2{} Fc:1 FL:31}



static void Test_Sf_BFu1c_BFu31ll()
{
  {
    init_simple_test("Sf_BFu1c_BFu31ll");
    static Sf_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "Sf_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "Sf_BFu1c_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu31ll(Test_Sf_BFu1c_BFu31ll, "Sf_BFu1c_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu32i  {
  ::empty v1;
  unsigned char v2:1;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu1c_BFu32i) C1{ FC2{} Fc:1 Fi:32}



static void Test_Sf_BFu1c_BFu32i()
{
  {
    init_simple_test("Sf_BFu1c_BFu32i");
    static Sf_BFu1c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu1c_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu32i(Test_Sf_BFu1c_BFu32i, "Sf_BFu1c_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu32ll  {
  ::empty v1;
  unsigned char v2:1;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu1c_BFu32ll) C1{ FC2{} Fc:1 FL:32}



static void Test_Sf_BFu1c_BFu32ll()
{
  {
    init_simple_test("Sf_BFu1c_BFu32ll");
    static Sf_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "Sf_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "Sf_BFu1c_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu32ll(Test_Sf_BFu1c_BFu32ll, "Sf_BFu1c_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu33  {
  ::empty v1;
  unsigned char v2:1;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu1c_BFu33) C1{ FC2{} Fc:1 FL:33}



static void Test_Sf_BFu1c_BFu33()
{
  {
    init_simple_test("Sf_BFu1c_BFu33");
    static Sf_BFu1c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "Sf_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "Sf_BFu1c_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu33(Test_Sf_BFu1c_BFu33, "Sf_BFu1c_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu7c  {
  ::empty v1;
  unsigned char v2:1;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu1c_BFu7c) C1{ FC2{} Fc:1 Fc:7}



static void Test_Sf_BFu1c_BFu7c()
{
  {
    init_simple_test("Sf_BFu1c_BFu7c");
    static Sf_BFu1c_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu1c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1c_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu7c(Test_Sf_BFu1c_BFu7c, "Sf_BFu1c_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu7i  {
  ::empty v1;
  unsigned char v2:1;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu1c_BFu7i) C1{ FC2{} Fc:1 Fi:7}



static void Test_Sf_BFu1c_BFu7i()
{
  {
    init_simple_test("Sf_BFu1c_BFu7i");
    static Sf_BFu1c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1c_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu7i(Test_Sf_BFu1c_BFu7i, "Sf_BFu1c_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu7ll  {
  ::empty v1;
  unsigned char v2:1;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu1c_BFu7ll) C1{ FC2{} Fc:1 FL:7}



static void Test_Sf_BFu1c_BFu7ll()
{
  {
    init_simple_test("Sf_BFu1c_BFu7ll");
    static Sf_BFu1c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1c_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu7ll(Test_Sf_BFu1c_BFu7ll, "Sf_BFu1c_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu7s  {
  ::empty v1;
  unsigned char v2:1;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu1c_BFu7s) C1{ FC2{} Fc:1 Fs:7}



static void Test_Sf_BFu1c_BFu7s()
{
  {
    init_simple_test("Sf_BFu1c_BFu7s");
    static Sf_BFu1c_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu1c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1c_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu7s(Test_Sf_BFu1c_BFu7s, "Sf_BFu1c_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu8c  {
  ::empty v1;
  unsigned char v2:1;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu1c_BFu8c) C1{ FC2{} Fc:1 Fc:8}



static void Test_Sf_BFu1c_BFu8c()
{
  {
    init_simple_test("Sf_BFu1c_BFu8c");
    static Sf_BFu1c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu1c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu1c_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu8c(Test_Sf_BFu1c_BFu8c, "Sf_BFu1c_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu8i  {
  ::empty v1;
  unsigned char v2:1;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu1c_BFu8i) C1{ FC2{} Fc:1 Fi:8}



static void Test_Sf_BFu1c_BFu8i()
{
  {
    init_simple_test("Sf_BFu1c_BFu8i");
    static Sf_BFu1c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Sf_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Sf_BFu1c_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu8i(Test_Sf_BFu1c_BFu8i, "Sf_BFu1c_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu8ll  {
  ::empty v1;
  unsigned char v2:1;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu1c_BFu8ll) C1{ FC2{} Fc:1 FL:8}



static void Test_Sf_BFu1c_BFu8ll()
{
  {
    init_simple_test("Sf_BFu1c_BFu8ll");
    static Sf_BFu1c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Sf_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Sf_BFu1c_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu8ll(Test_Sf_BFu1c_BFu8ll, "Sf_BFu1c_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu8s  {
  ::empty v1;
  unsigned char v2:1;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu1c_BFu8s) C1{ FC2{} Fc:1 Fs:8}



static void Test_Sf_BFu1c_BFu8s()
{
  {
    init_simple_test("Sf_BFu1c_BFu8s");
    static Sf_BFu1c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu1c_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu8s(Test_Sf_BFu1c_BFu8s, "Sf_BFu1c_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu9i  {
  ::empty v1;
  unsigned char v2:1;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu1c_BFu9i) C1{ FC2{} Fc:1 Fi:9}



static void Test_Sf_BFu1c_BFu9i()
{
  {
    init_simple_test("Sf_BFu1c_BFu9i");
    static Sf_BFu1c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Sf_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Sf_BFu1c_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu9i(Test_Sf_BFu1c_BFu9i, "Sf_BFu1c_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu9ll  {
  ::empty v1;
  unsigned char v2:1;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu1c_BFu9ll) C1{ FC2{} Fc:1 FL:9}



static void Test_Sf_BFu1c_BFu9ll()
{
  {
    init_simple_test("Sf_BFu1c_BFu9ll");
    static Sf_BFu1c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Sf_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Sf_BFu1c_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu9ll(Test_Sf_BFu1c_BFu9ll, "Sf_BFu1c_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_BFu9s  {
  ::empty v1;
  unsigned char v2:1;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu1c_BFu9s) C1{ FC2{} Fc:1 Fs:9}



static void Test_Sf_BFu1c_BFu9s()
{
  {
    init_simple_test("Sf_BFu1c_BFu9s");
    static Sf_BFu1c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu1c_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_BFu9s(Test_Sf_BFu1c_BFu9s, "Sf_BFu1c_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_C  {
  ::empty v1;
  unsigned char v2:1;
  char v3;
};
//SIG(1 Sf_BFu1c_C) C1{ FC2{} Fc:1 Fc}



static void Test_Sf_BFu1c_C()
{
  {
    init_simple_test("Sf_BFu1c_C");
    static Sf_BFu1c_C lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu1c_C)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu1c_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_C");
    check_field_offset(lv, v3, 2, "Sf_BFu1c_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_C(Test_Sf_BFu1c_C, "Sf_BFu1c_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_D  {
  ::empty v1;
  unsigned char v2:1;
  double v3;
};
//SIG(1 Sf_BFu1c_D) C1{ FC2{} Fc:1 FL}



static void Test_Sf_BFu1c_D()
{
  {
    init_simple_test("Sf_BFu1c_D");
    static Sf_BFu1c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu1c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1c_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_D(Test_Sf_BFu1c_D, "Sf_BFu1c_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_F  {
  ::empty v1;
  unsigned char v2:1;
  float v3;
};
//SIG(1 Sf_BFu1c_F) C1{ FC2{} Fc:1 Fi}



static void Test_Sf_BFu1c_F()
{
  {
    init_simple_test("Sf_BFu1c_F");
    static Sf_BFu1c_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1c_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1c_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_F");
    check_field_offset(lv, v3, 4, "Sf_BFu1c_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_F(Test_Sf_BFu1c_F, "Sf_BFu1c_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_I  {
  ::empty v1;
  unsigned char v2:1;
  int v3;
};
//SIG(1 Sf_BFu1c_I) C1{ FC2{} Fc:1 Fi}



static void Test_Sf_BFu1c_I()
{
  {
    init_simple_test("Sf_BFu1c_I");
    static Sf_BFu1c_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1c_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1c_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_I");
    check_field_offset(lv, v3, 4, "Sf_BFu1c_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_I(Test_Sf_BFu1c_I, "Sf_BFu1c_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_Ip  {
  ::empty v1;
  unsigned char v2:1;
  int *v3;
};
//SIG(1 Sf_BFu1c_Ip) C1{ FC2{} Fc:1 Fp}



static void Test_Sf_BFu1c_Ip()
{
  {
    init_simple_test("Sf_BFu1c_Ip");
    static Sf_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu1c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1c_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_Ip(Test_Sf_BFu1c_Ip, "Sf_BFu1c_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_L  {
  ::empty v1;
  unsigned char v2:1;
  __tsi64 v3;
};
//SIG(1 Sf_BFu1c_L) C1{ FC2{} Fc:1 FL}



static void Test_Sf_BFu1c_L()
{
  {
    init_simple_test("Sf_BFu1c_L");
    static Sf_BFu1c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu1c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1c_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_L(Test_Sf_BFu1c_L, "Sf_BFu1c_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_S  {
  ::empty v1;
  unsigned char v2:1;
  short v3;
};
//SIG(1 Sf_BFu1c_S) C1{ FC2{} Fc:1 Fs}



static void Test_Sf_BFu1c_S()
{
  {
    init_simple_test("Sf_BFu1c_S");
    static Sf_BFu1c_S lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1c_S)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1c_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_S");
    check_field_offset(lv, v3, 2, "Sf_BFu1c_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_S(Test_Sf_BFu1c_S, "Sf_BFu1c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_Sf  {
  ::empty v1;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 Sf_BFu1c_Sf) C1{ FC2{} Fc:1 FC2}



static void Test_Sf_BFu1c_Sf()
{
  {
    init_simple_test("Sf_BFu1c_Sf");
    static Sf_BFu1c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu1c_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_Sf");
    check_field_offset(lv, v3, 2, "Sf_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_Sf(Test_Sf_BFu1c_Sf, "Sf_BFu1c_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_Uc  {
  ::empty v1;
  unsigned char v2:1;
  unsigned char v3;
};
//SIG(1 Sf_BFu1c_Uc) C1{ FC2{} Fc:1 Fc}



static void Test_Sf_BFu1c_Uc()
{
  {
    init_simple_test("Sf_BFu1c_Uc");
    static Sf_BFu1c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu1c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_Uc");
    check_field_offset(lv, v3, 2, "Sf_BFu1c_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_Uc(Test_Sf_BFu1c_Uc, "Sf_BFu1c_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_Ui  {
  ::empty v1;
  unsigned char v2:1;
  unsigned int v3;
};
//SIG(1 Sf_BFu1c_Ui) C1{ FC2{} Fc:1 Fi}



static void Test_Sf_BFu1c_Ui()
{
  {
    init_simple_test("Sf_BFu1c_Ui");
    static Sf_BFu1c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu1c_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_Ui(Test_Sf_BFu1c_Ui, "Sf_BFu1c_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_Ul  {
  ::empty v1;
  unsigned char v2:1;
  __tsu64 v3;
};
//SIG(1 Sf_BFu1c_Ul) C1{ FC2{} Fc:1 FL}



static void Test_Sf_BFu1c_Ul()
{
  {
    init_simple_test("Sf_BFu1c_Ul");
    static Sf_BFu1c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu1c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1c_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_Ul(Test_Sf_BFu1c_Ul, "Sf_BFu1c_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_Us  {
  ::empty v1;
  unsigned char v2:1;
  unsigned short v3;
};
//SIG(1 Sf_BFu1c_Us) C1{ FC2{} Fc:1 Fs}



static void Test_Sf_BFu1c_Us()
{
  {
    init_simple_test("Sf_BFu1c_Us");
    static Sf_BFu1c_Us lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_Us");
    check_field_offset(lv, v3, 2, "Sf_BFu1c_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_Us(Test_Sf_BFu1c_Us, "Sf_BFu1c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1c_Vp  {
  ::empty v1;
  unsigned char v2:1;
  void *v3;
};
//SIG(1 Sf_BFu1c_Vp) C1{ FC2{} Fc:1 Fp}



static void Test_Sf_BFu1c_Vp()
{
  {
    init_simple_test("Sf_BFu1c_Vp");
    static Sf_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu1c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1c_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1c_Vp(Test_Sf_BFu1c_Vp, "Sf_BFu1c_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i  {
  ::empty v1;
  unsigned int v2:1;
};
//SIG(1 Sf_BFu1i) C1{ FC2{} Fi:1}



static void Test_Sf_BFu1i()
{
  {
    init_simple_test("Sf_BFu1i");
    static Sf_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu1i(Test_Sf_BFu1i, "Sf_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu15i  {
  ::empty v1;
  unsigned int v2:1;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu1i_BFu15i) C1{ FC2{} Fi:1 Fi:15}



static void Test_Sf_BFu1i_BFu15i()
{
  {
    init_simple_test("Sf_BFu1i_BFu15i");
    static Sf_BFu1i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Sf_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Sf_BFu1i_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu15i(Test_Sf_BFu1i_BFu15i, "Sf_BFu1i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu15ll  {
  ::empty v1;
  unsigned int v2:1;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu1i_BFu15ll) C1{ FC2{} Fi:1 FL:15}



static void Test_Sf_BFu1i_BFu15ll()
{
  {
    init_simple_test("Sf_BFu1i_BFu15ll");
    static Sf_BFu1i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Sf_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Sf_BFu1i_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu15ll(Test_Sf_BFu1i_BFu15ll, "Sf_BFu1i_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu15s  {
  ::empty v1;
  unsigned int v2:1;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu1i_BFu15s) C1{ FC2{} Fi:1 Fs:15}



static void Test_Sf_BFu1i_BFu15s()
{
  {
    init_simple_test("Sf_BFu1i_BFu15s");
    static Sf_BFu1i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu1i_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu15s(Test_Sf_BFu1i_BFu15s, "Sf_BFu1i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu16i  {
  ::empty v1;
  unsigned int v2:1;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu1i_BFu16i) C1{ FC2{} Fi:1 Fi:16}



static void Test_Sf_BFu1i_BFu16i()
{
  {
    init_simple_test("Sf_BFu1i_BFu16i");
    static Sf_BFu1i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Sf_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Sf_BFu1i_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu16i(Test_Sf_BFu1i_BFu16i, "Sf_BFu1i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu16ll  {
  ::empty v1;
  unsigned int v2:1;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu1i_BFu16ll) C1{ FC2{} Fi:1 FL:16}



static void Test_Sf_BFu1i_BFu16ll()
{
  {
    init_simple_test("Sf_BFu1i_BFu16ll");
    static Sf_BFu1i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Sf_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Sf_BFu1i_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu16ll(Test_Sf_BFu1i_BFu16ll, "Sf_BFu1i_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu16s  {
  ::empty v1;
  unsigned int v2:1;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu1i_BFu16s) C1{ FC2{} Fi:1 Fs:16}



static void Test_Sf_BFu1i_BFu16s()
{
  {
    init_simple_test("Sf_BFu1i_BFu16s");
    static Sf_BFu1i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu1i_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu16s(Test_Sf_BFu1i_BFu16s, "Sf_BFu1i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu17i  {
  ::empty v1;
  unsigned int v2:1;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu1i_BFu17i) C1{ FC2{} Fi:1 Fi:17}



static void Test_Sf_BFu1i_BFu17i()
{
  {
    init_simple_test("Sf_BFu1i_BFu17i");
    static Sf_BFu1i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Sf_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Sf_BFu1i_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu17i(Test_Sf_BFu1i_BFu17i, "Sf_BFu1i_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu17ll  {
  ::empty v1;
  unsigned int v2:1;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu1i_BFu17ll) C1{ FC2{} Fi:1 FL:17}



static void Test_Sf_BFu1i_BFu17ll()
{
  {
    init_simple_test("Sf_BFu1i_BFu17ll");
    static Sf_BFu1i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Sf_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Sf_BFu1i_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu17ll(Test_Sf_BFu1i_BFu17ll, "Sf_BFu1i_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu1c  {
  ::empty v1;
  unsigned int v2:1;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu1i_BFu1c) C1{ FC2{} Fi:1 Fc:1}



static void Test_Sf_BFu1i_BFu1c()
{
  {
    init_simple_test("Sf_BFu1i_BFu1c");
    static Sf_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1i_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu1c(Test_Sf_BFu1i_BFu1c, "Sf_BFu1i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu1i  {
  ::empty v1;
  unsigned int v2:1;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu1i_BFu1i) C1{ FC2{} Fi:1 Fi:1}



static void Test_Sf_BFu1i_BFu1i()
{
  {
    init_simple_test("Sf_BFu1i_BFu1i");
    static Sf_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1i_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu1i(Test_Sf_BFu1i_BFu1i, "Sf_BFu1i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu1ll  {
  ::empty v1;
  unsigned int v2:1;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu1i_BFu1ll) C1{ FC2{} Fi:1 FL:1}



static void Test_Sf_BFu1i_BFu1ll()
{
  {
    init_simple_test("Sf_BFu1i_BFu1ll");
    static Sf_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1i_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu1ll(Test_Sf_BFu1i_BFu1ll, "Sf_BFu1i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu1s  {
  ::empty v1;
  unsigned int v2:1;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu1i_BFu1s) C1{ FC2{} Fi:1 Fs:1}



static void Test_Sf_BFu1i_BFu1s()
{
  {
    init_simple_test("Sf_BFu1i_BFu1s");
    static Sf_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1i_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu1s(Test_Sf_BFu1i_BFu1s, "Sf_BFu1i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu31i  {
  ::empty v1;
  unsigned int v2:1;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu1i_BFu31i) C1{ FC2{} Fi:1 Fi:31}



static void Test_Sf_BFu1i_BFu31i()
{
  {
    init_simple_test("Sf_BFu1i_BFu31i");
    static Sf_BFu1i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu1i_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu31i(Test_Sf_BFu1i_BFu31i, "Sf_BFu1i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu31ll  {
  ::empty v1;
  unsigned int v2:1;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu1i_BFu31ll) C1{ FC2{} Fi:1 FL:31}



static void Test_Sf_BFu1i_BFu31ll()
{
  {
    init_simple_test("Sf_BFu1i_BFu31ll");
    static Sf_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "Sf_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "Sf_BFu1i_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu31ll(Test_Sf_BFu1i_BFu31ll, "Sf_BFu1i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu32i  {
  ::empty v1;
  unsigned int v2:1;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu1i_BFu32i) C1{ FC2{} Fi:1 Fi:32}



static void Test_Sf_BFu1i_BFu32i()
{
  {
    init_simple_test("Sf_BFu1i_BFu32i");
    static Sf_BFu1i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu1i_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu32i(Test_Sf_BFu1i_BFu32i, "Sf_BFu1i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu32ll  {
  ::empty v1;
  unsigned int v2:1;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu1i_BFu32ll) C1{ FC2{} Fi:1 FL:32}



static void Test_Sf_BFu1i_BFu32ll()
{
  {
    init_simple_test("Sf_BFu1i_BFu32ll");
    static Sf_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "Sf_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "Sf_BFu1i_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu32ll(Test_Sf_BFu1i_BFu32ll, "Sf_BFu1i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu33  {
  ::empty v1;
  unsigned int v2:1;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu1i_BFu33) C1{ FC2{} Fi:1 FL:33}



static void Test_Sf_BFu1i_BFu33()
{
  {
    init_simple_test("Sf_BFu1i_BFu33");
    static Sf_BFu1i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "Sf_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "Sf_BFu1i_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu33(Test_Sf_BFu1i_BFu33, "Sf_BFu1i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu7c  {
  ::empty v1;
  unsigned int v2:1;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu1i_BFu7c) C1{ FC2{} Fi:1 Fc:7}



static void Test_Sf_BFu1i_BFu7c()
{
  {
    init_simple_test("Sf_BFu1i_BFu7c");
    static Sf_BFu1i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1i_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu7c(Test_Sf_BFu1i_BFu7c, "Sf_BFu1i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu7i  {
  ::empty v1;
  unsigned int v2:1;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu1i_BFu7i) C1{ FC2{} Fi:1 Fi:7}



static void Test_Sf_BFu1i_BFu7i()
{
  {
    init_simple_test("Sf_BFu1i_BFu7i");
    static Sf_BFu1i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1i_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu7i(Test_Sf_BFu1i_BFu7i, "Sf_BFu1i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu7ll  {
  ::empty v1;
  unsigned int v2:1;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu1i_BFu7ll) C1{ FC2{} Fi:1 FL:7}



static void Test_Sf_BFu1i_BFu7ll()
{
  {
    init_simple_test("Sf_BFu1i_BFu7ll");
    static Sf_BFu1i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1i_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu7ll(Test_Sf_BFu1i_BFu7ll, "Sf_BFu1i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu7s  {
  ::empty v1;
  unsigned int v2:1;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu1i_BFu7s) C1{ FC2{} Fi:1 Fs:7}



static void Test_Sf_BFu1i_BFu7s()
{
  {
    init_simple_test("Sf_BFu1i_BFu7s");
    static Sf_BFu1i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1i_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu7s(Test_Sf_BFu1i_BFu7s, "Sf_BFu1i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu8c  {
  ::empty v1;
  unsigned int v2:1;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu1i_BFu8c) C1{ FC2{} Fi:1 Fc:8}



static void Test_Sf_BFu1i_BFu8c()
{
  {
    init_simple_test("Sf_BFu1i_BFu8c");
    static Sf_BFu1i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu1i_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu8c(Test_Sf_BFu1i_BFu8c, "Sf_BFu1i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu8i  {
  ::empty v1;
  unsigned int v2:1;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu1i_BFu8i) C1{ FC2{} Fi:1 Fi:8}



static void Test_Sf_BFu1i_BFu8i()
{
  {
    init_simple_test("Sf_BFu1i_BFu8i");
    static Sf_BFu1i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Sf_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Sf_BFu1i_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu8i(Test_Sf_BFu1i_BFu8i, "Sf_BFu1i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu8ll  {
  ::empty v1;
  unsigned int v2:1;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu1i_BFu8ll) C1{ FC2{} Fi:1 FL:8}



static void Test_Sf_BFu1i_BFu8ll()
{
  {
    init_simple_test("Sf_BFu1i_BFu8ll");
    static Sf_BFu1i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Sf_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Sf_BFu1i_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu8ll(Test_Sf_BFu1i_BFu8ll, "Sf_BFu1i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu8s  {
  ::empty v1;
  unsigned int v2:1;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu1i_BFu8s) C1{ FC2{} Fi:1 Fs:8}



static void Test_Sf_BFu1i_BFu8s()
{
  {
    init_simple_test("Sf_BFu1i_BFu8s");
    static Sf_BFu1i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu1i_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu8s(Test_Sf_BFu1i_BFu8s, "Sf_BFu1i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu9i  {
  ::empty v1;
  unsigned int v2:1;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu1i_BFu9i) C1{ FC2{} Fi:1 Fi:9}



static void Test_Sf_BFu1i_BFu9i()
{
  {
    init_simple_test("Sf_BFu1i_BFu9i");
    static Sf_BFu1i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Sf_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Sf_BFu1i_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu9i(Test_Sf_BFu1i_BFu9i, "Sf_BFu1i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu9ll  {
  ::empty v1;
  unsigned int v2:1;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu1i_BFu9ll) C1{ FC2{} Fi:1 FL:9}



static void Test_Sf_BFu1i_BFu9ll()
{
  {
    init_simple_test("Sf_BFu1i_BFu9ll");
    static Sf_BFu1i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Sf_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Sf_BFu1i_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu9ll(Test_Sf_BFu1i_BFu9ll, "Sf_BFu1i_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_BFu9s  {
  ::empty v1;
  unsigned int v2:1;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu1i_BFu9s) C1{ FC2{} Fi:1 Fs:9}



static void Test_Sf_BFu1i_BFu9s()
{
  {
    init_simple_test("Sf_BFu1i_BFu9s");
    static Sf_BFu1i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu1i_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_BFu9s(Test_Sf_BFu1i_BFu9s, "Sf_BFu1i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_C  {
  ::empty v1;
  unsigned int v2:1;
  char v3;
};
//SIG(1 Sf_BFu1i_C) C1{ FC2{} Fi:1 Fc}



static void Test_Sf_BFu1i_C()
{
  {
    init_simple_test("Sf_BFu1i_C");
    static Sf_BFu1i_C lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_C");
    check_field_offset(lv, v3, 2, "Sf_BFu1i_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_C(Test_Sf_BFu1i_C, "Sf_BFu1i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_D  {
  ::empty v1;
  unsigned int v2:1;
  double v3;
};
//SIG(1 Sf_BFu1i_D) C1{ FC2{} Fi:1 FL}



static void Test_Sf_BFu1i_D()
{
  {
    init_simple_test("Sf_BFu1i_D");
    static Sf_BFu1i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu1i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1i_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_D(Test_Sf_BFu1i_D, "Sf_BFu1i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_F  {
  ::empty v1;
  unsigned int v2:1;
  float v3;
};
//SIG(1 Sf_BFu1i_F) C1{ FC2{} Fi:1 Fi}



static void Test_Sf_BFu1i_F()
{
  {
    init_simple_test("Sf_BFu1i_F");
    static Sf_BFu1i_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_F");
    check_field_offset(lv, v3, 4, "Sf_BFu1i_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_F(Test_Sf_BFu1i_F, "Sf_BFu1i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_I  {
  ::empty v1;
  unsigned int v2:1;
  int v3;
};
//SIG(1 Sf_BFu1i_I) C1{ FC2{} Fi:1 Fi}



static void Test_Sf_BFu1i_I()
{
  {
    init_simple_test("Sf_BFu1i_I");
    static Sf_BFu1i_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_I");
    check_field_offset(lv, v3, 4, "Sf_BFu1i_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_I(Test_Sf_BFu1i_I, "Sf_BFu1i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_Ip  {
  ::empty v1;
  unsigned int v2:1;
  int *v3;
};
//SIG(1 Sf_BFu1i_Ip) C1{ FC2{} Fi:1 Fp}



static void Test_Sf_BFu1i_Ip()
{
  {
    init_simple_test("Sf_BFu1i_Ip");
    static Sf_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu1i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1i_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_Ip(Test_Sf_BFu1i_Ip, "Sf_BFu1i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_L  {
  ::empty v1;
  unsigned int v2:1;
  __tsi64 v3;
};
//SIG(1 Sf_BFu1i_L) C1{ FC2{} Fi:1 FL}



static void Test_Sf_BFu1i_L()
{
  {
    init_simple_test("Sf_BFu1i_L");
    static Sf_BFu1i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu1i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1i_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_L(Test_Sf_BFu1i_L, "Sf_BFu1i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_S  {
  ::empty v1;
  unsigned int v2:1;
  short v3;
};
//SIG(1 Sf_BFu1i_S) C1{ FC2{} Fi:1 Fs}



static void Test_Sf_BFu1i_S()
{
  {
    init_simple_test("Sf_BFu1i_S");
    static Sf_BFu1i_S lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_S");
    check_field_offset(lv, v3, 2, "Sf_BFu1i_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_S(Test_Sf_BFu1i_S, "Sf_BFu1i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_Sf  {
  ::empty v1;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 Sf_BFu1i_Sf) C1{ FC2{} Fi:1 FC2}



static void Test_Sf_BFu1i_Sf()
{
  {
    init_simple_test("Sf_BFu1i_Sf");
    static Sf_BFu1i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_Sf");
    check_field_offset(lv, v3, 2, "Sf_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_Sf(Test_Sf_BFu1i_Sf, "Sf_BFu1i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_Uc  {
  ::empty v1;
  unsigned int v2:1;
  unsigned char v3;
};
//SIG(1 Sf_BFu1i_Uc) C1{ FC2{} Fi:1 Fc}



static void Test_Sf_BFu1i_Uc()
{
  {
    init_simple_test("Sf_BFu1i_Uc");
    static Sf_BFu1i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_Uc");
    check_field_offset(lv, v3, 2, "Sf_BFu1i_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_Uc(Test_Sf_BFu1i_Uc, "Sf_BFu1i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_Ui  {
  ::empty v1;
  unsigned int v2:1;
  unsigned int v3;
};
//SIG(1 Sf_BFu1i_Ui) C1{ FC2{} Fi:1 Fi}



static void Test_Sf_BFu1i_Ui()
{
  {
    init_simple_test("Sf_BFu1i_Ui");
    static Sf_BFu1i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu1i_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_Ui(Test_Sf_BFu1i_Ui, "Sf_BFu1i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_Ul  {
  ::empty v1;
  unsigned int v2:1;
  __tsu64 v3;
};
//SIG(1 Sf_BFu1i_Ul) C1{ FC2{} Fi:1 FL}



static void Test_Sf_BFu1i_Ul()
{
  {
    init_simple_test("Sf_BFu1i_Ul");
    static Sf_BFu1i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu1i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1i_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_Ul(Test_Sf_BFu1i_Ul, "Sf_BFu1i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_Us  {
  ::empty v1;
  unsigned int v2:1;
  unsigned short v3;
};
//SIG(1 Sf_BFu1i_Us) C1{ FC2{} Fi:1 Fs}



static void Test_Sf_BFu1i_Us()
{
  {
    init_simple_test("Sf_BFu1i_Us");
    static Sf_BFu1i_Us lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_Us");
    check_field_offset(lv, v3, 2, "Sf_BFu1i_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_Us(Test_Sf_BFu1i_Us, "Sf_BFu1i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1i_Vp  {
  ::empty v1;
  unsigned int v2:1;
  void *v3;
};
//SIG(1 Sf_BFu1i_Vp) C1{ FC2{} Fi:1 Fp}



static void Test_Sf_BFu1i_Vp()
{
  {
    init_simple_test("Sf_BFu1i_Vp");
    static Sf_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu1i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1i_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1i_Vp(Test_Sf_BFu1i_Vp, "Sf_BFu1i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll  {
  ::empty v1;
  __tsu64 v2:1;
};
//SIG(1 Sf_BFu1ll) C1{ FC2{} FL:1}



static void Test_Sf_BFu1ll()
{
  {
    init_simple_test("Sf_BFu1ll");
    static Sf_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll(Test_Sf_BFu1ll, "Sf_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu15i  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu1ll_BFu15i) C1{ FC2{} FL:1 Fi:15}



static void Test_Sf_BFu1ll_BFu15i()
{
  {
    init_simple_test("Sf_BFu1ll_BFu15i");
    static Sf_BFu1ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Sf_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Sf_BFu1ll_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu15i(Test_Sf_BFu1ll_BFu15i, "Sf_BFu1ll_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu15ll  {
  ::empty v1;
  __tsu64 v2:1;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu1ll_BFu15ll) C1{ FC2{} FL:1 FL:15}



static void Test_Sf_BFu1ll_BFu15ll()
{
  {
    init_simple_test("Sf_BFu1ll_BFu15ll");
    static Sf_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Sf_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Sf_BFu1ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu15ll(Test_Sf_BFu1ll_BFu15ll, "Sf_BFu1ll_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu15s  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu1ll_BFu15s) C1{ FC2{} FL:1 Fs:15}



static void Test_Sf_BFu1ll_BFu15s()
{
  {
    init_simple_test("Sf_BFu1ll_BFu15s");
    static Sf_BFu1ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu1ll_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu15s(Test_Sf_BFu1ll_BFu15s, "Sf_BFu1ll_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu16i  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu1ll_BFu16i) C1{ FC2{} FL:1 Fi:16}



static void Test_Sf_BFu1ll_BFu16i()
{
  {
    init_simple_test("Sf_BFu1ll_BFu16i");
    static Sf_BFu1ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Sf_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Sf_BFu1ll_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu16i(Test_Sf_BFu1ll_BFu16i, "Sf_BFu1ll_BFu16i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu16ll  {
  ::empty v1;
  __tsu64 v2:1;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu1ll_BFu16ll) C1{ FC2{} FL:1 FL:16}



static void Test_Sf_BFu1ll_BFu16ll()
{
  {
    init_simple_test("Sf_BFu1ll_BFu16ll");
    static Sf_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Sf_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Sf_BFu1ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu16ll(Test_Sf_BFu1ll_BFu16ll, "Sf_BFu1ll_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu16s  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu1ll_BFu16s) C1{ FC2{} FL:1 Fs:16}



static void Test_Sf_BFu1ll_BFu16s()
{
  {
    init_simple_test("Sf_BFu1ll_BFu16s");
    static Sf_BFu1ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu1ll_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu16s(Test_Sf_BFu1ll_BFu16s, "Sf_BFu1ll_BFu16s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu17i  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu1ll_BFu17i) C1{ FC2{} FL:1 Fi:17}



static void Test_Sf_BFu1ll_BFu17i()
{
  {
    init_simple_test("Sf_BFu1ll_BFu17i");
    static Sf_BFu1ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Sf_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Sf_BFu1ll_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu17i(Test_Sf_BFu1ll_BFu17i, "Sf_BFu1ll_BFu17i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu17ll  {
  ::empty v1;
  __tsu64 v2:1;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu1ll_BFu17ll) C1{ FC2{} FL:1 FL:17}



static void Test_Sf_BFu1ll_BFu17ll()
{
  {
    init_simple_test("Sf_BFu1ll_BFu17ll");
    static Sf_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Sf_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Sf_BFu1ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu17ll(Test_Sf_BFu1ll_BFu17ll, "Sf_BFu1ll_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu1c  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu1ll_BFu1c) C1{ FC2{} FL:1 Fc:1}



static void Test_Sf_BFu1ll_BFu1c()
{
  {
    init_simple_test("Sf_BFu1ll_BFu1c");
    static Sf_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1ll_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu1c(Test_Sf_BFu1ll_BFu1c, "Sf_BFu1ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu1i  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu1ll_BFu1i) C1{ FC2{} FL:1 Fi:1}



static void Test_Sf_BFu1ll_BFu1i()
{
  {
    init_simple_test("Sf_BFu1ll_BFu1i");
    static Sf_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1ll_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu1i(Test_Sf_BFu1ll_BFu1i, "Sf_BFu1ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu1ll  {
  ::empty v1;
  __tsu64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu1ll_BFu1ll) C1{ FC2{} FL:1 FL:1}



static void Test_Sf_BFu1ll_BFu1ll()
{
  {
    init_simple_test("Sf_BFu1ll_BFu1ll");
    static Sf_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu1ll(Test_Sf_BFu1ll_BFu1ll, "Sf_BFu1ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu1s  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu1ll_BFu1s) C1{ FC2{} FL:1 Fs:1}



static void Test_Sf_BFu1ll_BFu1s()
{
  {
    init_simple_test("Sf_BFu1ll_BFu1s");
    static Sf_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1ll_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu1s(Test_Sf_BFu1ll_BFu1s, "Sf_BFu1ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu31i  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu1ll_BFu31i) C1{ FC2{} FL:1 Fi:31}



static void Test_Sf_BFu1ll_BFu31i()
{
  {
    init_simple_test("Sf_BFu1ll_BFu31i");
    static Sf_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu1ll_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu31i(Test_Sf_BFu1ll_BFu31i, "Sf_BFu1ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu31ll  {
  ::empty v1;
  __tsu64 v2:1;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu1ll_BFu31ll) C1{ FC2{} FL:1 FL:31}



static void Test_Sf_BFu1ll_BFu31ll()
{
  {
    init_simple_test("Sf_BFu1ll_BFu31ll");
    static Sf_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "Sf_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "Sf_BFu1ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu31ll(Test_Sf_BFu1ll_BFu31ll, "Sf_BFu1ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu32i  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu1ll_BFu32i) C1{ FC2{} FL:1 Fi:32}



static void Test_Sf_BFu1ll_BFu32i()
{
  {
    init_simple_test("Sf_BFu1ll_BFu32i");
    static Sf_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu1ll_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu32i(Test_Sf_BFu1ll_BFu32i, "Sf_BFu1ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu32ll  {
  ::empty v1;
  __tsu64 v2:1;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu1ll_BFu32ll) C1{ FC2{} FL:1 FL:32}



static void Test_Sf_BFu1ll_BFu32ll()
{
  {
    init_simple_test("Sf_BFu1ll_BFu32ll");
    static Sf_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "Sf_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "Sf_BFu1ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu32ll(Test_Sf_BFu1ll_BFu32ll, "Sf_BFu1ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu33  {
  ::empty v1;
  __tsu64 v2:1;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu1ll_BFu33) C1{ FC2{} FL:1 FL:33}



static void Test_Sf_BFu1ll_BFu33()
{
  {
    init_simple_test("Sf_BFu1ll_BFu33");
    static Sf_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "Sf_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "Sf_BFu1ll_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu33(Test_Sf_BFu1ll_BFu33, "Sf_BFu1ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu7c  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu1ll_BFu7c) C1{ FC2{} FL:1 Fc:7}



static void Test_Sf_BFu1ll_BFu7c()
{
  {
    init_simple_test("Sf_BFu1ll_BFu7c");
    static Sf_BFu1ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1ll_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu7c(Test_Sf_BFu1ll_BFu7c, "Sf_BFu1ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu7i  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu1ll_BFu7i) C1{ FC2{} FL:1 Fi:7}



static void Test_Sf_BFu1ll_BFu7i()
{
  {
    init_simple_test("Sf_BFu1ll_BFu7i");
    static Sf_BFu1ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1ll_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu7i(Test_Sf_BFu1ll_BFu7i, "Sf_BFu1ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu7ll  {
  ::empty v1;
  __tsu64 v2:1;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu1ll_BFu7ll) C1{ FC2{} FL:1 FL:7}



static void Test_Sf_BFu1ll_BFu7ll()
{
  {
    init_simple_test("Sf_BFu1ll_BFu7ll");
    static Sf_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu7ll(Test_Sf_BFu1ll_BFu7ll, "Sf_BFu1ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu7s  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu1ll_BFu7s) C1{ FC2{} FL:1 Fs:7}



static void Test_Sf_BFu1ll_BFu7s()
{
  {
    init_simple_test("Sf_BFu1ll_BFu7s");
    static Sf_BFu1ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1ll_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu7s(Test_Sf_BFu1ll_BFu7s, "Sf_BFu1ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu8c  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu1ll_BFu8c) C1{ FC2{} FL:1 Fc:8}



static void Test_Sf_BFu1ll_BFu8c()
{
  {
    init_simple_test("Sf_BFu1ll_BFu8c");
    static Sf_BFu1ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu1ll_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu8c(Test_Sf_BFu1ll_BFu8c, "Sf_BFu1ll_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu8i  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu1ll_BFu8i) C1{ FC2{} FL:1 Fi:8}



static void Test_Sf_BFu1ll_BFu8i()
{
  {
    init_simple_test("Sf_BFu1ll_BFu8i");
    static Sf_BFu1ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Sf_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Sf_BFu1ll_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu8i(Test_Sf_BFu1ll_BFu8i, "Sf_BFu1ll_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu8ll  {
  ::empty v1;
  __tsu64 v2:1;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu1ll_BFu8ll) C1{ FC2{} FL:1 FL:8}



static void Test_Sf_BFu1ll_BFu8ll()
{
  {
    init_simple_test("Sf_BFu1ll_BFu8ll");
    static Sf_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Sf_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Sf_BFu1ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu8ll(Test_Sf_BFu1ll_BFu8ll, "Sf_BFu1ll_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu8s  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu1ll_BFu8s) C1{ FC2{} FL:1 Fs:8}



static void Test_Sf_BFu1ll_BFu8s()
{
  {
    init_simple_test("Sf_BFu1ll_BFu8s");
    static Sf_BFu1ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu1ll_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu8s(Test_Sf_BFu1ll_BFu8s, "Sf_BFu1ll_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu9i  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu1ll_BFu9i) C1{ FC2{} FL:1 Fi:9}



static void Test_Sf_BFu1ll_BFu9i()
{
  {
    init_simple_test("Sf_BFu1ll_BFu9i");
    static Sf_BFu1ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Sf_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Sf_BFu1ll_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu9i(Test_Sf_BFu1ll_BFu9i, "Sf_BFu1ll_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu9ll  {
  ::empty v1;
  __tsu64 v2:1;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu1ll_BFu9ll) C1{ FC2{} FL:1 FL:9}



static void Test_Sf_BFu1ll_BFu9ll()
{
  {
    init_simple_test("Sf_BFu1ll_BFu9ll");
    static Sf_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Sf_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Sf_BFu1ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu9ll(Test_Sf_BFu1ll_BFu9ll, "Sf_BFu1ll_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_BFu9s  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu1ll_BFu9s) C1{ FC2{} FL:1 Fs:9}



static void Test_Sf_BFu1ll_BFu9s()
{
  {
    init_simple_test("Sf_BFu1ll_BFu9s");
    static Sf_BFu1ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu1ll_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_BFu9s(Test_Sf_BFu1ll_BFu9s, "Sf_BFu1ll_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_C  {
  ::empty v1;
  __tsu64 v2:1;
  char v3;
};
//SIG(1 Sf_BFu1ll_C) C1{ FC2{} FL:1 Fc}



static void Test_Sf_BFu1ll_C()
{
  {
    init_simple_test("Sf_BFu1ll_C");
    static Sf_BFu1ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_C");
    check_field_offset(lv, v3, 2, "Sf_BFu1ll_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_C(Test_Sf_BFu1ll_C, "Sf_BFu1ll_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_D  {
  ::empty v1;
  __tsu64 v2:1;
  double v3;
};
//SIG(1 Sf_BFu1ll_D) C1{ FC2{} FL:1 FL}



static void Test_Sf_BFu1ll_D()
{
  {
    init_simple_test("Sf_BFu1ll_D");
    static Sf_BFu1ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu1ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1ll_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_D(Test_Sf_BFu1ll_D, "Sf_BFu1ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_F  {
  ::empty v1;
  __tsu64 v2:1;
  float v3;
};
//SIG(1 Sf_BFu1ll_F) C1{ FC2{} FL:1 Fi}



static void Test_Sf_BFu1ll_F()
{
  {
    init_simple_test("Sf_BFu1ll_F");
    static Sf_BFu1ll_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_F");
    check_field_offset(lv, v3, 4, "Sf_BFu1ll_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_F(Test_Sf_BFu1ll_F, "Sf_BFu1ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_I  {
  ::empty v1;
  __tsu64 v2:1;
  int v3;
};
//SIG(1 Sf_BFu1ll_I) C1{ FC2{} FL:1 Fi}



static void Test_Sf_BFu1ll_I()
{
  {
    init_simple_test("Sf_BFu1ll_I");
    static Sf_BFu1ll_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_I");
    check_field_offset(lv, v3, 4, "Sf_BFu1ll_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_I(Test_Sf_BFu1ll_I, "Sf_BFu1ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_Ip  {
  ::empty v1;
  __tsu64 v2:1;
  int *v3;
};
//SIG(1 Sf_BFu1ll_Ip) C1{ FC2{} FL:1 Fp}



static void Test_Sf_BFu1ll_Ip()
{
  {
    init_simple_test("Sf_BFu1ll_Ip");
    static Sf_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu1ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_Ip(Test_Sf_BFu1ll_Ip, "Sf_BFu1ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_L  {
  ::empty v1;
  __tsu64 v2:1;
  __tsi64 v3;
};
//SIG(1 Sf_BFu1ll_L) C1{ FC2{} FL:1 FL}



static void Test_Sf_BFu1ll_L()
{
  {
    init_simple_test("Sf_BFu1ll_L");
    static Sf_BFu1ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu1ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1ll_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_L(Test_Sf_BFu1ll_L, "Sf_BFu1ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_S  {
  ::empty v1;
  __tsu64 v2:1;
  short v3;
};
//SIG(1 Sf_BFu1ll_S) C1{ FC2{} FL:1 Fs}



static void Test_Sf_BFu1ll_S()
{
  {
    init_simple_test("Sf_BFu1ll_S");
    static Sf_BFu1ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_S");
    check_field_offset(lv, v3, 2, "Sf_BFu1ll_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_S(Test_Sf_BFu1ll_S, "Sf_BFu1ll_S", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_Sf  {
  ::empty v1;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 Sf_BFu1ll_Sf) C1{ FC2{} FL:1 FC2}



static void Test_Sf_BFu1ll_Sf()
{
  {
    init_simple_test("Sf_BFu1ll_Sf");
    static Sf_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_Sf");
    check_field_offset(lv, v3, 2, "Sf_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_Sf(Test_Sf_BFu1ll_Sf, "Sf_BFu1ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_Uc  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned char v3;
};
//SIG(1 Sf_BFu1ll_Uc) C1{ FC2{} FL:1 Fc}



static void Test_Sf_BFu1ll_Uc()
{
  {
    init_simple_test("Sf_BFu1ll_Uc");
    static Sf_BFu1ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_Uc");
    check_field_offset(lv, v3, 2, "Sf_BFu1ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_Uc(Test_Sf_BFu1ll_Uc, "Sf_BFu1ll_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_Ui  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned int v3;
};
//SIG(1 Sf_BFu1ll_Ui) C1{ FC2{} FL:1 Fi}



static void Test_Sf_BFu1ll_Ui()
{
  {
    init_simple_test("Sf_BFu1ll_Ui");
    static Sf_BFu1ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu1ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_Ui(Test_Sf_BFu1ll_Ui, "Sf_BFu1ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_Ul  {
  ::empty v1;
  __tsu64 v2:1;
  __tsu64 v3;
};
//SIG(1 Sf_BFu1ll_Ul) C1{ FC2{} FL:1 FL}



static void Test_Sf_BFu1ll_Ul()
{
  {
    init_simple_test("Sf_BFu1ll_Ul");
    static Sf_BFu1ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu1ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_Ul(Test_Sf_BFu1ll_Ul, "Sf_BFu1ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_Us  {
  ::empty v1;
  __tsu64 v2:1;
  unsigned short v3;
};
//SIG(1 Sf_BFu1ll_Us) C1{ FC2{} FL:1 Fs}



static void Test_Sf_BFu1ll_Us()
{
  {
    init_simple_test("Sf_BFu1ll_Us");
    static Sf_BFu1ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_Us");
    check_field_offset(lv, v3, 2, "Sf_BFu1ll_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_Us(Test_Sf_BFu1ll_Us, "Sf_BFu1ll_Us", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1ll_Vp  {
  ::empty v1;
  __tsu64 v2:1;
  void *v3;
};
//SIG(1 Sf_BFu1ll_Vp) C1{ FC2{} FL:1 Fp}



static void Test_Sf_BFu1ll_Vp()
{
  {
    init_simple_test("Sf_BFu1ll_Vp");
    static Sf_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu1ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1ll_Vp(Test_Sf_BFu1ll_Vp, "Sf_BFu1ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s  {
  ::empty v1;
  unsigned short v2:1;
};
//SIG(1 Sf_BFu1s) C1{ FC2{} Fs:1}



static void Test_Sf_BFu1s()
{
  {
    init_simple_test("Sf_BFu1s");
    static Sf_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu1s(Test_Sf_BFu1s, "Sf_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu15i  {
  ::empty v1;
  unsigned short v2:1;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu1s_BFu15i) C1{ FC2{} Fs:1 Fi:15}



static void Test_Sf_BFu1s_BFu15i()
{
  {
    init_simple_test("Sf_BFu1s_BFu15i");
    static Sf_BFu1s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Sf_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Sf_BFu1s_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu15i(Test_Sf_BFu1s_BFu15i, "Sf_BFu1s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu15ll  {
  ::empty v1;
  unsigned short v2:1;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu1s_BFu15ll) C1{ FC2{} Fs:1 FL:15}



static void Test_Sf_BFu1s_BFu15ll()
{
  {
    init_simple_test("Sf_BFu1s_BFu15ll");
    static Sf_BFu1s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, 1, "Sf_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 1, 15, hide_ull(1LL<<14), "Sf_BFu1s_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu15ll(Test_Sf_BFu1s_BFu15ll, "Sf_BFu1s_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu15s  {
  ::empty v1;
  unsigned short v2:1;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu1s_BFu15s) C1{ FC2{} Fs:1 Fs:15}



static void Test_Sf_BFu1s_BFu15s()
{
  {
    init_simple_test("Sf_BFu1s_BFu15s");
    static Sf_BFu1s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu1s_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu15s(Test_Sf_BFu1s_BFu15s, "Sf_BFu1s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu16i  {
  ::empty v1;
  unsigned short v2:1;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu1s_BFu16i) C1{ FC2{} Fs:1 Fi:16}



static void Test_Sf_BFu1s_BFu16i()
{
  {
    init_simple_test("Sf_BFu1s_BFu16i");
    static Sf_BFu1s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Sf_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Sf_BFu1s_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu16i(Test_Sf_BFu1s_BFu16i, "Sf_BFu1s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu16ll  {
  ::empty v1;
  unsigned short v2:1;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu1s_BFu16ll) C1{ FC2{} Fs:1 FL:16}



static void Test_Sf_BFu1s_BFu16ll()
{
  {
    init_simple_test("Sf_BFu1s_BFu16ll");
    static Sf_BFu1s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, 1, "Sf_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 1, 16, hide_ull(1LL<<15), "Sf_BFu1s_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu16ll(Test_Sf_BFu1s_BFu16ll, "Sf_BFu1s_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu16s  {
  ::empty v1;
  unsigned short v2:1;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu1s_BFu16s) C1{ FC2{} Fs:1 Fs:16}



static void Test_Sf_BFu1s_BFu16s()
{
  {
    init_simple_test("Sf_BFu1s_BFu16s");
    static Sf_BFu1s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu1s_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu16s(Test_Sf_BFu1s_BFu16s, "Sf_BFu1s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu17i  {
  ::empty v1;
  unsigned short v2:1;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu1s_BFu17i) C1{ FC2{} Fs:1 Fi:17}



static void Test_Sf_BFu1s_BFu17i()
{
  {
    init_simple_test("Sf_BFu1s_BFu17i");
    static Sf_BFu1s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Sf_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Sf_BFu1s_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu17i(Test_Sf_BFu1s_BFu17i, "Sf_BFu1s_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu17ll  {
  ::empty v1;
  unsigned short v2:1;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu1s_BFu17ll) C1{ FC2{} Fs:1 FL:17}



static void Test_Sf_BFu1s_BFu17ll()
{
  {
    init_simple_test("Sf_BFu1s_BFu17ll");
    static Sf_BFu1s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, 1, "Sf_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 1, 17, hide_ull(1LL<<16), "Sf_BFu1s_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu17ll(Test_Sf_BFu1s_BFu17ll, "Sf_BFu1s_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu1c  {
  ::empty v1;
  unsigned short v2:1;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu1s_BFu1c) C1{ FC2{} Fs:1 Fc:1}



static void Test_Sf_BFu1s_BFu1c()
{
  {
    init_simple_test("Sf_BFu1s_BFu1c");
    static Sf_BFu1s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1s_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu1c(Test_Sf_BFu1s_BFu1c, "Sf_BFu1s_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu1i  {
  ::empty v1;
  unsigned short v2:1;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu1s_BFu1i) C1{ FC2{} Fs:1 Fi:1}



static void Test_Sf_BFu1s_BFu1i()
{
  {
    init_simple_test("Sf_BFu1s_BFu1i");
    static Sf_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1s_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu1i(Test_Sf_BFu1s_BFu1i, "Sf_BFu1s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu1ll  {
  ::empty v1;
  unsigned short v2:1;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu1s_BFu1ll) C1{ FC2{} Fs:1 FL:1}



static void Test_Sf_BFu1s_BFu1ll()
{
  {
    init_simple_test("Sf_BFu1s_BFu1ll");
    static Sf_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1s_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu1ll(Test_Sf_BFu1s_BFu1ll, "Sf_BFu1s_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu1s  {
  ::empty v1;
  unsigned short v2:1;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu1s_BFu1s) C1{ FC2{} Fs:1 Fs:1}



static void Test_Sf_BFu1s_BFu1s()
{
  {
    init_simple_test("Sf_BFu1s_BFu1s");
    static Sf_BFu1s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 1, 1, 1, 1, "Sf_BFu1s_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu1s(Test_Sf_BFu1s_BFu1s, "Sf_BFu1s_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu31i  {
  ::empty v1;
  unsigned short v2:1;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu1s_BFu31i) C1{ FC2{} Fs:1 Fi:31}



static void Test_Sf_BFu1s_BFu31i()
{
  {
    init_simple_test("Sf_BFu1s_BFu31i");
    static Sf_BFu1s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu1s_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu31i(Test_Sf_BFu1s_BFu31i, "Sf_BFu1s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu31ll  {
  ::empty v1;
  unsigned short v2:1;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu1s_BFu31ll) C1{ FC2{} Fs:1 FL:31}



static void Test_Sf_BFu1s_BFu31ll()
{
  {
    init_simple_test("Sf_BFu1s_BFu31ll");
    static Sf_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, 1, "Sf_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 1, 31, hide_ull(1LL<<30), "Sf_BFu1s_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu31ll(Test_Sf_BFu1s_BFu31ll, "Sf_BFu1s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu32i  {
  ::empty v1;
  unsigned short v2:1;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu1s_BFu32i) C1{ FC2{} Fs:1 Fi:32}



static void Test_Sf_BFu1s_BFu32i()
{
  {
    init_simple_test("Sf_BFu1s_BFu32i");
    static Sf_BFu1s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu1s_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu32i(Test_Sf_BFu1s_BFu32i, "Sf_BFu1s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu32ll  {
  ::empty v1;
  unsigned short v2:1;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu1s_BFu32ll) C1{ FC2{} Fs:1 FL:32}



static void Test_Sf_BFu1s_BFu32ll()
{
  {
    init_simple_test("Sf_BFu1s_BFu32ll");
    static Sf_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, 1, "Sf_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 1, 32, hide_ull(1LL<<31), "Sf_BFu1s_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu32ll(Test_Sf_BFu1s_BFu32ll, "Sf_BFu1s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu33  {
  ::empty v1;
  unsigned short v2:1;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu1s_BFu33) C1{ FC2{} Fs:1 FL:33}



static void Test_Sf_BFu1s_BFu33()
{
  {
    init_simple_test("Sf_BFu1s_BFu33");
    static Sf_BFu1s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, 1, "Sf_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 1, 1, 33, hide_ull(1LL<<32), "Sf_BFu1s_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu33(Test_Sf_BFu1s_BFu33, "Sf_BFu1s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu7c  {
  ::empty v1;
  unsigned short v2:1;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu1s_BFu7c) C1{ FC2{} Fs:1 Fc:7}



static void Test_Sf_BFu1s_BFu7c()
{
  {
    init_simple_test("Sf_BFu1s_BFu7c");
    static Sf_BFu1s_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu1s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1s_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu7c(Test_Sf_BFu1s_BFu7c, "Sf_BFu1s_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu7i  {
  ::empty v1;
  unsigned short v2:1;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu1s_BFu7i) C1{ FC2{} Fs:1 Fi:7}



static void Test_Sf_BFu1s_BFu7i()
{
  {
    init_simple_test("Sf_BFu1s_BFu7i");
    static Sf_BFu1s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1s_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu7i(Test_Sf_BFu1s_BFu7i, "Sf_BFu1s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu7ll  {
  ::empty v1;
  unsigned short v2:1;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu1s_BFu7ll) C1{ FC2{} Fs:1 FL:7}



static void Test_Sf_BFu1s_BFu7ll()
{
  {
    init_simple_test("Sf_BFu1s_BFu7ll");
    static Sf_BFu1s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1s_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu7ll(Test_Sf_BFu1s_BFu7ll, "Sf_BFu1s_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu7s  {
  ::empty v1;
  unsigned short v2:1;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu1s_BFu7s) C1{ FC2{} Fs:1 Fs:7}



static void Test_Sf_BFu1s_BFu7s()
{
  {
    init_simple_test("Sf_BFu1s_BFu7s");
    static Sf_BFu1s_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu1s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, 1, "Sf_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 1, 1, 7, hide_ull(1LL<<6), "Sf_BFu1s_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu7s(Test_Sf_BFu1s_BFu7s, "Sf_BFu1s_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu8c  {
  ::empty v1;
  unsigned short v2:1;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu1s_BFu8c) C1{ FC2{} Fs:1 Fc:8}



static void Test_Sf_BFu1s_BFu8c()
{
  {
    init_simple_test("Sf_BFu1s_BFu8c");
    static Sf_BFu1s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu1s_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu8c(Test_Sf_BFu1s_BFu8c, "Sf_BFu1s_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu8i  {
  ::empty v1;
  unsigned short v2:1;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu1s_BFu8i) C1{ FC2{} Fs:1 Fi:8}



static void Test_Sf_BFu1s_BFu8i()
{
  {
    init_simple_test("Sf_BFu1s_BFu8i");
    static Sf_BFu1s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Sf_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Sf_BFu1s_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu8i(Test_Sf_BFu1s_BFu8i, "Sf_BFu1s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu8ll  {
  ::empty v1;
  unsigned short v2:1;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu1s_BFu8ll) C1{ FC2{} Fs:1 FL:8}



static void Test_Sf_BFu1s_BFu8ll()
{
  {
    init_simple_test("Sf_BFu1s_BFu8ll");
    static Sf_BFu1s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, 1, "Sf_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 1, 8, hide_ull(1LL<<7), "Sf_BFu1s_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu8ll(Test_Sf_BFu1s_BFu8ll, "Sf_BFu1s_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu8s  {
  ::empty v1;
  unsigned short v2:1;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu1s_BFu8s) C1{ FC2{} Fs:1 Fs:8}



static void Test_Sf_BFu1s_BFu8s()
{
  {
    init_simple_test("Sf_BFu1s_BFu8s");
    static Sf_BFu1s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu1s_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu8s(Test_Sf_BFu1s_BFu8s, "Sf_BFu1s_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu9i  {
  ::empty v1;
  unsigned short v2:1;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu1s_BFu9i) C1{ FC2{} Fs:1 Fi:9}



static void Test_Sf_BFu1s_BFu9i()
{
  {
    init_simple_test("Sf_BFu1s_BFu9i");
    static Sf_BFu1s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Sf_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Sf_BFu1s_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu9i(Test_Sf_BFu1s_BFu9i, "Sf_BFu1s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu9ll  {
  ::empty v1;
  unsigned short v2:1;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu1s_BFu9ll) C1{ FC2{} Fs:1 FL:9}



static void Test_Sf_BFu1s_BFu9ll()
{
  {
    init_simple_test("Sf_BFu1s_BFu9ll");
    static Sf_BFu1s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu1s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, 1, "Sf_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 1, 9, hide_ull(1LL<<8), "Sf_BFu1s_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu9ll(Test_Sf_BFu1s_BFu9ll, "Sf_BFu1s_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_BFu9s  {
  ::empty v1;
  unsigned short v2:1;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu1s_BFu9s) C1{ FC2{} Fs:1 Fs:9}



static void Test_Sf_BFu1s_BFu9s()
{
  {
    init_simple_test("Sf_BFu1s_BFu9s");
    static Sf_BFu1s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu1s_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_BFu9s(Test_Sf_BFu1s_BFu9s, "Sf_BFu1s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_C  {
  ::empty v1;
  unsigned short v2:1;
  char v3;
};
//SIG(1 Sf_BFu1s_C) C1{ FC2{} Fs:1 Fc}



static void Test_Sf_BFu1s_C()
{
  {
    init_simple_test("Sf_BFu1s_C");
    static Sf_BFu1s_C lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_C)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_C");
    check_field_offset(lv, v3, 2, "Sf_BFu1s_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_C(Test_Sf_BFu1s_C, "Sf_BFu1s_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_D  {
  ::empty v1;
  unsigned short v2:1;
  double v3;
};
//SIG(1 Sf_BFu1s_D) C1{ FC2{} Fs:1 FL}



static void Test_Sf_BFu1s_D()
{
  {
    init_simple_test("Sf_BFu1s_D");
    static Sf_BFu1s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu1s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1s_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_D(Test_Sf_BFu1s_D, "Sf_BFu1s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_F  {
  ::empty v1;
  unsigned short v2:1;
  float v3;
};
//SIG(1 Sf_BFu1s_F) C1{ FC2{} Fs:1 Fi}



static void Test_Sf_BFu1s_F()
{
  {
    init_simple_test("Sf_BFu1s_F");
    static Sf_BFu1s_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1s_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1s_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_F");
    check_field_offset(lv, v3, 4, "Sf_BFu1s_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_F(Test_Sf_BFu1s_F, "Sf_BFu1s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_I  {
  ::empty v1;
  unsigned short v2:1;
  int v3;
};
//SIG(1 Sf_BFu1s_I) C1{ FC2{} Fs:1 Fi}



static void Test_Sf_BFu1s_I()
{
  {
    init_simple_test("Sf_BFu1s_I");
    static Sf_BFu1s_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1s_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1s_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_I");
    check_field_offset(lv, v3, 4, "Sf_BFu1s_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_I(Test_Sf_BFu1s_I, "Sf_BFu1s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_Ip  {
  ::empty v1;
  unsigned short v2:1;
  int *v3;
};
//SIG(1 Sf_BFu1s_Ip) C1{ FC2{} Fs:1 Fp}



static void Test_Sf_BFu1s_Ip()
{
  {
    init_simple_test("Sf_BFu1s_Ip");
    static Sf_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu1s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1s_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_Ip(Test_Sf_BFu1s_Ip, "Sf_BFu1s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_L  {
  ::empty v1;
  unsigned short v2:1;
  __tsi64 v3;
};
//SIG(1 Sf_BFu1s_L) C1{ FC2{} Fs:1 FL}



static void Test_Sf_BFu1s_L()
{
  {
    init_simple_test("Sf_BFu1s_L");
    static Sf_BFu1s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu1s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1s_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_L(Test_Sf_BFu1s_L, "Sf_BFu1s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_S  {
  ::empty v1;
  unsigned short v2:1;
  short v3;
};
//SIG(1 Sf_BFu1s_S) C1{ FC2{} Fs:1 Fs}



static void Test_Sf_BFu1s_S()
{
  {
    init_simple_test("Sf_BFu1s_S");
    static Sf_BFu1s_S lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_S)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_S");
    check_field_offset(lv, v3, 2, "Sf_BFu1s_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_S(Test_Sf_BFu1s_S, "Sf_BFu1s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_Sf  {
  ::empty v1;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 Sf_BFu1s_Sf) C1{ FC2{} Fs:1 FC2}



static void Test_Sf_BFu1s_Sf()
{
  {
    init_simple_test("Sf_BFu1s_Sf");
    static Sf_BFu1s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_Sf");
    check_field_offset(lv, v3, 2, "Sf_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_Sf(Test_Sf_BFu1s_Sf, "Sf_BFu1s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_Uc  {
  ::empty v1;
  unsigned short v2:1;
  unsigned char v3;
};
//SIG(1 Sf_BFu1s_Uc) C1{ FC2{} Fs:1 Fc}



static void Test_Sf_BFu1s_Uc()
{
  {
    init_simple_test("Sf_BFu1s_Uc");
    static Sf_BFu1s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_Uc");
    check_field_offset(lv, v3, 2, "Sf_BFu1s_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_Uc(Test_Sf_BFu1s_Uc, "Sf_BFu1s_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_Ui  {
  ::empty v1;
  unsigned short v2:1;
  unsigned int v3;
};
//SIG(1 Sf_BFu1s_Ui) C1{ FC2{} Fs:1 Fi}



static void Test_Sf_BFu1s_Ui()
{
  {
    init_simple_test("Sf_BFu1s_Ui");
    static Sf_BFu1s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu1s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu1s_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_Ui(Test_Sf_BFu1s_Ui, "Sf_BFu1s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_Ul  {
  ::empty v1;
  unsigned short v2:1;
  __tsu64 v3;
};
//SIG(1 Sf_BFu1s_Ul) C1{ FC2{} Fs:1 FL}



static void Test_Sf_BFu1s_Ul()
{
  {
    init_simple_test("Sf_BFu1s_Ul");
    static Sf_BFu1s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu1s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1s_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_Ul(Test_Sf_BFu1s_Ul, "Sf_BFu1s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_Us  {
  ::empty v1;
  unsigned short v2:1;
  unsigned short v3;
};
//SIG(1 Sf_BFu1s_Us) C1{ FC2{} Fs:1 Fs}



static void Test_Sf_BFu1s_Us()
{
  {
    init_simple_test("Sf_BFu1s_Us");
    static Sf_BFu1s_Us lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu1s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_Us");
    check_field_offset(lv, v3, 2, "Sf_BFu1s_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_Us(Test_Sf_BFu1s_Us, "Sf_BFu1s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu1s_Vp  {
  ::empty v1;
  unsigned short v2:1;
  void *v3;
};
//SIG(1 Sf_BFu1s_Vp) C1{ FC2{} Fs:1 Fp}



static void Test_Sf_BFu1s_Vp()
{
  {
    init_simple_test("Sf_BFu1s_Vp");
    static Sf_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu1s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 1, 1, "Sf_BFu1s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu1s_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu1s_Vp(Test_Sf_BFu1s_Vp, "Sf_BFu1s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i  {
  ::empty v1;
  unsigned int v2:31;
};
//SIG(1 Sf_BFu31i) C1{ FC2{} Fi:31}



static void Test_Sf_BFu31i()
{
  {
    init_simple_test("Sf_BFu31i");
    static Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu31i(Test_Sf_BFu31i, "Sf_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu15i  {
  ::empty v1;
  unsigned int v2:31;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu31i_BFu15i) C1{ FC2{} Fi:31 Fi:15}



static void Test_Sf_BFu31i_BFu15i()
{
  {
    init_simple_test("Sf_BFu31i_BFu15i");
    static Sf_BFu31i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Sf_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Sf_BFu31i_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu15i(Test_Sf_BFu31i_BFu15i, "Sf_BFu31i_BFu15i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu15ll  {
  ::empty v1;
  unsigned int v2:31;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu31i_BFu15ll) C1{ FC2{} Fi:31 FL:15}



static void Test_Sf_BFu31i_BFu15ll()
{
  {
    init_simple_test("Sf_BFu31i_BFu15ll");
    static Sf_BFu31i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, 1, "Sf_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, hide_ull(1LL<<14), "Sf_BFu31i_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu15ll(Test_Sf_BFu31i_BFu15ll, "Sf_BFu31i_BFu15ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu15s  {
  ::empty v1;
  unsigned int v2:31;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu31i_BFu15s) C1{ FC2{} Fi:31 Fs:15}



static void Test_Sf_BFu31i_BFu15s()
{
  {
    init_simple_test("Sf_BFu31i_BFu15s");
    static Sf_BFu31i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Sf_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Sf_BFu31i_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu15s(Test_Sf_BFu31i_BFu15s, "Sf_BFu31i_BFu15s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu16i  {
  ::empty v1;
  unsigned int v2:31;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu31i_BFu16i) C1{ FC2{} Fi:31 Fi:16}



static void Test_Sf_BFu31i_BFu16i()
{
  {
    init_simple_test("Sf_BFu31i_BFu16i");
    static Sf_BFu31i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Sf_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Sf_BFu31i_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu16i(Test_Sf_BFu31i_BFu16i, "Sf_BFu31i_BFu16i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu16ll  {
  ::empty v1;
  unsigned int v2:31;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu31i_BFu16ll) C1{ FC2{} Fi:31 FL:16}



static void Test_Sf_BFu31i_BFu16ll()
{
  {
    init_simple_test("Sf_BFu31i_BFu16ll");
    static Sf_BFu31i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, 1, "Sf_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, hide_ull(1LL<<15), "Sf_BFu31i_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu16ll(Test_Sf_BFu31i_BFu16ll, "Sf_BFu31i_BFu16ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu16s  {
  ::empty v1;
  unsigned int v2:31;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu31i_BFu16s) C1{ FC2{} Fi:31 Fs:16}



static void Test_Sf_BFu31i_BFu16s()
{
  {
    init_simple_test("Sf_BFu31i_BFu16s");
    static Sf_BFu31i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Sf_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Sf_BFu31i_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu16s(Test_Sf_BFu31i_BFu16s, "Sf_BFu31i_BFu16s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu17i  {
  ::empty v1;
  unsigned int v2:31;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu31i_BFu17i) C1{ FC2{} Fi:31 Fi:17}



static void Test_Sf_BFu31i_BFu17i()
{
  {
    init_simple_test("Sf_BFu31i_BFu17i");
    static Sf_BFu31i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Sf_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Sf_BFu31i_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu17i(Test_Sf_BFu31i_BFu17i, "Sf_BFu31i_BFu17i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu17ll  {
  ::empty v1;
  unsigned int v2:31;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu31i_BFu17ll) C1{ FC2{} Fi:31 FL:17}



static void Test_Sf_BFu31i_BFu17ll()
{
  {
    init_simple_test("Sf_BFu31i_BFu17ll");
    static Sf_BFu31i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, 1, "Sf_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, hide_ull(1LL<<16), "Sf_BFu31i_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu17ll(Test_Sf_BFu31i_BFu17ll, "Sf_BFu31i_BFu17ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu1c  {
  ::empty v1;
  unsigned int v2:31;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu31i_BFu1c) C1{ FC2{} Fi:31 Fc:1}



static void Test_Sf_BFu31i_BFu1c()
{
  {
    init_simple_test("Sf_BFu31i_BFu1c");
    static Sf_BFu31i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Sf_BFu31i_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu1c(Test_Sf_BFu31i_BFu1c, "Sf_BFu31i_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu1i  {
  ::empty v1;
  unsigned int v2:31;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu31i_BFu1i) C1{ FC2{} Fi:31 Fi:1}



static void Test_Sf_BFu31i_BFu1i()
{
  {
    init_simple_test("Sf_BFu31i_BFu1i");
    static Sf_BFu31i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Sf_BFu31i_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu1i(Test_Sf_BFu31i_BFu1i, "Sf_BFu31i_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu1ll  {
  ::empty v1;
  unsigned int v2:31;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu31i_BFu1ll) C1{ FC2{} Fi:31 FL:1}



static void Test_Sf_BFu31i_BFu1ll()
{
  {
    init_simple_test("Sf_BFu31i_BFu1ll");
    static Sf_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Sf_BFu31i_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu1ll(Test_Sf_BFu31i_BFu1ll, "Sf_BFu31i_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu1s  {
  ::empty v1;
  unsigned int v2:31;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu31i_BFu1s) C1{ FC2{} Fi:31 Fs:1}



static void Test_Sf_BFu31i_BFu1s()
{
  {
    init_simple_test("Sf_BFu31i_BFu1s");
    static Sf_BFu31i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Sf_BFu31i_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu1s(Test_Sf_BFu31i_BFu1s, "Sf_BFu31i_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu31i  {
  ::empty v1;
  unsigned int v2:31;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu31i_BFu31i) C1{ FC2{} Fi:31 Fi:31}



static void Test_Sf_BFu31i_BFu31i()
{
  {
    init_simple_test("Sf_BFu31i_BFu31i");
    static Sf_BFu31i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Sf_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu31i(Test_Sf_BFu31i_BFu31i, "Sf_BFu31i_BFu31i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu31ll  {
  ::empty v1;
  unsigned int v2:31;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu31i_BFu31ll) C1{ FC2{} Fi:31 FL:31}



static void Test_Sf_BFu31i_BFu31ll()
{
  {
    init_simple_test("Sf_BFu31i_BFu31ll");
    static Sf_BFu31i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "Sf_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu31ll(Test_Sf_BFu31i_BFu31ll, "Sf_BFu31i_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu32i  {
  ::empty v1;
  unsigned int v2:31;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu31i_BFu32i) C1{ FC2{} Fi:31 Fi:32}



static void Test_Sf_BFu31i_BFu32i()
{
  {
    init_simple_test("Sf_BFu31i_BFu32i");
    static Sf_BFu31i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Sf_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Sf_BFu31i_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu32i(Test_Sf_BFu31i_BFu32i, "Sf_BFu31i_BFu32i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu32ll  {
  ::empty v1;
  unsigned int v2:31;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu31i_BFu32ll) C1{ FC2{} Fi:31 FL:32}



static void Test_Sf_BFu31i_BFu32ll()
{
  {
    init_simple_test("Sf_BFu31i_BFu32ll");
    static Sf_BFu31i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, 1, "Sf_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, hide_ull(1LL<<31), "Sf_BFu31i_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu32ll(Test_Sf_BFu31i_BFu32ll, "Sf_BFu31i_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu33  {
  ::empty v1;
  unsigned int v2:31;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu31i_BFu33) C1{ FC2{} Fi:31 FL:33}



static void Test_Sf_BFu31i_BFu33()
{
  {
    init_simple_test("Sf_BFu31i_BFu33");
    static Sf_BFu31i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, 1, "Sf_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, hide_ull(1LL<<32), "Sf_BFu31i_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu33(Test_Sf_BFu31i_BFu33, "Sf_BFu31i_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu7c  {
  ::empty v1;
  unsigned int v2:31;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu31i_BFu7c) C1{ FC2{} Fi:31 Fc:7}



static void Test_Sf_BFu31i_BFu7c()
{
  {
    init_simple_test("Sf_BFu31i_BFu7c");
    static Sf_BFu31i_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Sf_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Sf_BFu31i_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu7c(Test_Sf_BFu31i_BFu7c, "Sf_BFu31i_BFu7c", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu7i  {
  ::empty v1;
  unsigned int v2:31;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu31i_BFu7i) C1{ FC2{} Fi:31 Fi:7}



static void Test_Sf_BFu31i_BFu7i()
{
  {
    init_simple_test("Sf_BFu31i_BFu7i");
    static Sf_BFu31i_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Sf_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Sf_BFu31i_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu7i(Test_Sf_BFu31i_BFu7i, "Sf_BFu31i_BFu7i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu7ll  {
  ::empty v1;
  unsigned int v2:31;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu31i_BFu7ll) C1{ FC2{} Fi:31 FL:7}



static void Test_Sf_BFu31i_BFu7ll()
{
  {
    init_simple_test("Sf_BFu31i_BFu7ll");
    static Sf_BFu31i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, 1, "Sf_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, hide_ull(1LL<<6), "Sf_BFu31i_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu7ll(Test_Sf_BFu31i_BFu7ll, "Sf_BFu31i_BFu7ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu7s  {
  ::empty v1;
  unsigned int v2:31;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu31i_BFu7s) C1{ FC2{} Fi:31 Fs:7}



static void Test_Sf_BFu31i_BFu7s()
{
  {
    init_simple_test("Sf_BFu31i_BFu7s");
    static Sf_BFu31i_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Sf_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Sf_BFu31i_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu7s(Test_Sf_BFu31i_BFu7s, "Sf_BFu31i_BFu7s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu8c  {
  ::empty v1;
  unsigned int v2:31;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu31i_BFu8c) C1{ FC2{} Fi:31 Fc:8}



static void Test_Sf_BFu31i_BFu8c()
{
  {
    init_simple_test("Sf_BFu31i_BFu8c");
    static Sf_BFu31i_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Sf_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Sf_BFu31i_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu8c(Test_Sf_BFu31i_BFu8c, "Sf_BFu31i_BFu8c", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu8i  {
  ::empty v1;
  unsigned int v2:31;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu31i_BFu8i) C1{ FC2{} Fi:31 Fi:8}



static void Test_Sf_BFu31i_BFu8i()
{
  {
    init_simple_test("Sf_BFu31i_BFu8i");
    static Sf_BFu31i_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Sf_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Sf_BFu31i_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu8i(Test_Sf_BFu31i_BFu8i, "Sf_BFu31i_BFu8i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu8ll  {
  ::empty v1;
  unsigned int v2:31;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu31i_BFu8ll) C1{ FC2{} Fi:31 FL:8}



static void Test_Sf_BFu31i_BFu8ll()
{
  {
    init_simple_test("Sf_BFu31i_BFu8ll");
    static Sf_BFu31i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, 1, "Sf_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, hide_ull(1LL<<7), "Sf_BFu31i_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu8ll(Test_Sf_BFu31i_BFu8ll, "Sf_BFu31i_BFu8ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu8s  {
  ::empty v1;
  unsigned int v2:31;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu31i_BFu8s) C1{ FC2{} Fi:31 Fs:8}



static void Test_Sf_BFu31i_BFu8s()
{
  {
    init_simple_test("Sf_BFu31i_BFu8s");
    static Sf_BFu31i_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Sf_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Sf_BFu31i_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu8s(Test_Sf_BFu31i_BFu8s, "Sf_BFu31i_BFu8s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu9i  {
  ::empty v1;
  unsigned int v2:31;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu31i_BFu9i) C1{ FC2{} Fi:31 Fi:9}



static void Test_Sf_BFu31i_BFu9i()
{
  {
    init_simple_test("Sf_BFu31i_BFu9i");
    static Sf_BFu31i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Sf_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Sf_BFu31i_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu9i(Test_Sf_BFu31i_BFu9i, "Sf_BFu31i_BFu9i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu9ll  {
  ::empty v1;
  unsigned int v2:31;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu31i_BFu9ll) C1{ FC2{} Fi:31 FL:9}



static void Test_Sf_BFu31i_BFu9ll()
{
  {
    init_simple_test("Sf_BFu31i_BFu9ll");
    static Sf_BFu31i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, 1, "Sf_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, hide_ull(1LL<<8), "Sf_BFu31i_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu9ll(Test_Sf_BFu31i_BFu9ll, "Sf_BFu31i_BFu9ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_BFu9s  {
  ::empty v1;
  unsigned int v2:31;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu31i_BFu9s) C1{ FC2{} Fi:31 Fs:9}



static void Test_Sf_BFu31i_BFu9s()
{
  {
    init_simple_test("Sf_BFu31i_BFu9s");
    static Sf_BFu31i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Sf_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Sf_BFu31i_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_BFu9s(Test_Sf_BFu31i_BFu9s, "Sf_BFu31i_BFu9s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_C  {
  ::empty v1;
  unsigned int v2:31;
  char v3;
};
//SIG(1 Sf_BFu31i_C) C1{ FC2{} Fi:31 Fc}



static void Test_Sf_BFu31i_C()
{
  {
    init_simple_test("Sf_BFu31i_C");
    static Sf_BFu31i_C lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_C");
    check_field_offset(lv, v3, 8, "Sf_BFu31i_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_C(Test_Sf_BFu31i_C, "Sf_BFu31i_C", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_D  {
  ::empty v1;
  unsigned int v2:31;
  double v3;
};
//SIG(1 Sf_BFu31i_D) C1{ FC2{} Fi:31 FL}



static void Test_Sf_BFu31i_D()
{
  {
    init_simple_test("Sf_BFu31i_D");
    static Sf_BFu31i_D lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu31i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_D");
    check_field_offset(lv, v3, 8, "Sf_BFu31i_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_D(Test_Sf_BFu31i_D, "Sf_BFu31i_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_F  {
  ::empty v1;
  unsigned int v2:31;
  float v3;
};
//SIG(1 Sf_BFu31i_F) C1{ FC2{} Fi:31 Fi}



static void Test_Sf_BFu31i_F()
{
  {
    init_simple_test("Sf_BFu31i_F");
    static Sf_BFu31i_F lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_F");
    check_field_offset(lv, v3, 8, "Sf_BFu31i_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_F(Test_Sf_BFu31i_F, "Sf_BFu31i_F", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_I  {
  ::empty v1;
  unsigned int v2:31;
  int v3;
};
//SIG(1 Sf_BFu31i_I) C1{ FC2{} Fi:31 Fi}



static void Test_Sf_BFu31i_I()
{
  {
    init_simple_test("Sf_BFu31i_I");
    static Sf_BFu31i_I lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_I");
    check_field_offset(lv, v3, 8, "Sf_BFu31i_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_I(Test_Sf_BFu31i_I, "Sf_BFu31i_I", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_Ip  {
  ::empty v1;
  unsigned int v2:31;
  int *v3;
};
//SIG(1 Sf_BFu31i_Ip) C1{ FC2{} Fi:31 Fp}



static void Test_Sf_BFu31i_Ip()
{
  {
    init_simple_test("Sf_BFu31i_Ip");
    static Sf_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_Ip");
    check_field_offset(lv, v3, 8, "Sf_BFu31i_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_Ip(Test_Sf_BFu31i_Ip, "Sf_BFu31i_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_L  {
  ::empty v1;
  unsigned int v2:31;
  __tsi64 v3;
};
//SIG(1 Sf_BFu31i_L) C1{ FC2{} Fi:31 FL}



static void Test_Sf_BFu31i_L()
{
  {
    init_simple_test("Sf_BFu31i_L");
    static Sf_BFu31i_L lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu31i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_L");
    check_field_offset(lv, v3, 8, "Sf_BFu31i_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_L(Test_Sf_BFu31i_L, "Sf_BFu31i_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_S  {
  ::empty v1;
  unsigned int v2:31;
  short v3;
};
//SIG(1 Sf_BFu31i_S) C1{ FC2{} Fi:31 Fs}



static void Test_Sf_BFu31i_S()
{
  {
    init_simple_test("Sf_BFu31i_S");
    static Sf_BFu31i_S lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_S");
    check_field_offset(lv, v3, 8, "Sf_BFu31i_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_S(Test_Sf_BFu31i_S, "Sf_BFu31i_S", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_Sf  {
  ::empty v1;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 Sf_BFu31i_Sf) C1{ FC2{} Fi:31 FC2}



static void Test_Sf_BFu31i_Sf()
{
  {
    init_simple_test("Sf_BFu31i_Sf");
    static Sf_BFu31i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_Sf.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "Sf_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_Sf(Test_Sf_BFu31i_Sf, "Sf_BFu31i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_Uc  {
  ::empty v1;
  unsigned int v2:31;
  unsigned char v3;
};
//SIG(1 Sf_BFu31i_Uc) C1{ FC2{} Fi:31 Fc}



static void Test_Sf_BFu31i_Uc()
{
  {
    init_simple_test("Sf_BFu31i_Uc");
    static Sf_BFu31i_Uc lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_Uc");
    check_field_offset(lv, v3, 8, "Sf_BFu31i_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_Uc(Test_Sf_BFu31i_Uc, "Sf_BFu31i_Uc", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_Ui  {
  ::empty v1;
  unsigned int v2:31;
  unsigned int v3;
};
//SIG(1 Sf_BFu31i_Ui) C1{ FC2{} Fi:31 Fi}



static void Test_Sf_BFu31i_Ui()
{
  {
    init_simple_test("Sf_BFu31i_Ui");
    static Sf_BFu31i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_Ui");
    check_field_offset(lv, v3, 8, "Sf_BFu31i_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_Ui(Test_Sf_BFu31i_Ui, "Sf_BFu31i_Ui", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_Ul  {
  ::empty v1;
  unsigned int v2:31;
  __tsu64 v3;
};
//SIG(1 Sf_BFu31i_Ul) C1{ FC2{} Fi:31 FL}



static void Test_Sf_BFu31i_Ul()
{
  {
    init_simple_test("Sf_BFu31i_Ul");
    static Sf_BFu31i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu31i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_Ul");
    check_field_offset(lv, v3, 8, "Sf_BFu31i_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_Ul(Test_Sf_BFu31i_Ul, "Sf_BFu31i_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_Us  {
  ::empty v1;
  unsigned int v2:31;
  unsigned short v3;
};
//SIG(1 Sf_BFu31i_Us) C1{ FC2{} Fi:31 Fs}



static void Test_Sf_BFu31i_Us()
{
  {
    init_simple_test("Sf_BFu31i_Us");
    static Sf_BFu31i_Us lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu31i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_Us");
    check_field_offset(lv, v3, 8, "Sf_BFu31i_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_Us(Test_Sf_BFu31i_Us, "Sf_BFu31i_Us", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31i_Vp  {
  ::empty v1;
  unsigned int v2:31;
  void *v3;
};
//SIG(1 Sf_BFu31i_Vp) C1{ FC2{} Fi:31 Fp}



static void Test_Sf_BFu31i_Vp()
{
  {
    init_simple_test("Sf_BFu31i_Vp");
    static Sf_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Sf_BFu31i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu31i_Vp");
    check_field_offset(lv, v3, 8, "Sf_BFu31i_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31i_Vp(Test_Sf_BFu31i_Vp, "Sf_BFu31i_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll  {
  ::empty v1;
  __tsu64 v2:31;
};
//SIG(1 Sf_BFu31ll) C1{ FC2{} FL:31}



static void Test_Sf_BFu31ll()
{
  {
    init_simple_test("Sf_BFu31ll");
    static Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll(Test_Sf_BFu31ll, "Sf_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu15i  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu31ll_BFu15i) C1{ FC2{} FL:31 Fi:15}



static void Test_Sf_BFu31ll_BFu15i()
{
  {
    init_simple_test("Sf_BFu31ll_BFu15i");
    static Sf_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Sf_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Sf_BFu31ll_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu15i(Test_Sf_BFu31ll_BFu15i, "Sf_BFu31ll_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu15ll  {
  ::empty v1;
  __tsu64 v2:31;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu31ll_BFu15ll) C1{ FC2{} FL:31 FL:15}



static void Test_Sf_BFu31ll_BFu15ll()
{
  {
    init_simple_test("Sf_BFu31ll_BFu15ll");
    static Sf_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "Sf_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "Sf_BFu31ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu15ll(Test_Sf_BFu31ll_BFu15ll, "Sf_BFu31ll_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu15s  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu31ll_BFu15s) C1{ FC2{} FL:31 Fs:15}



static void Test_Sf_BFu31ll_BFu15s()
{
  {
    init_simple_test("Sf_BFu31ll_BFu15s");
    static Sf_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Sf_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Sf_BFu31ll_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu15s(Test_Sf_BFu31ll_BFu15s, "Sf_BFu31ll_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu16i  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu31ll_BFu16i) C1{ FC2{} FL:31 Fi:16}



static void Test_Sf_BFu31ll_BFu16i()
{
  {
    init_simple_test("Sf_BFu31ll_BFu16i");
    static Sf_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Sf_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Sf_BFu31ll_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu16i(Test_Sf_BFu31ll_BFu16i, "Sf_BFu31ll_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu16ll  {
  ::empty v1;
  __tsu64 v2:31;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu31ll_BFu16ll) C1{ FC2{} FL:31 FL:16}



static void Test_Sf_BFu31ll_BFu16ll()
{
  {
    init_simple_test("Sf_BFu31ll_BFu16ll");
    static Sf_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "Sf_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "Sf_BFu31ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu16ll(Test_Sf_BFu31ll_BFu16ll, "Sf_BFu31ll_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu16s  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu31ll_BFu16s) C1{ FC2{} FL:31 Fs:16}



static void Test_Sf_BFu31ll_BFu16s()
{
  {
    init_simple_test("Sf_BFu31ll_BFu16s");
    static Sf_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Sf_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Sf_BFu31ll_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu16s(Test_Sf_BFu31ll_BFu16s, "Sf_BFu31ll_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu17i  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu31ll_BFu17i) C1{ FC2{} FL:31 Fi:17}



static void Test_Sf_BFu31ll_BFu17i()
{
  {
    init_simple_test("Sf_BFu31ll_BFu17i");
    static Sf_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "Sf_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "Sf_BFu31ll_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu17i(Test_Sf_BFu31ll_BFu17i, "Sf_BFu31ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu17ll  {
  ::empty v1;
  __tsu64 v2:31;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu31ll_BFu17ll) C1{ FC2{} FL:31 FL:17}



static void Test_Sf_BFu31ll_BFu17ll()
{
  {
    init_simple_test("Sf_BFu31ll_BFu17ll");
    static Sf_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "Sf_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "Sf_BFu31ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu17ll(Test_Sf_BFu31ll_BFu17ll, "Sf_BFu31ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu1c  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu31ll_BFu1c) C1{ FC2{} FL:31 Fc:1}



static void Test_Sf_BFu31ll_BFu1c()
{
  {
    init_simple_test("Sf_BFu31ll_BFu1c");
    static Sf_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Sf_BFu31ll_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu1c(Test_Sf_BFu31ll_BFu1c, "Sf_BFu31ll_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu1i  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu31ll_BFu1i) C1{ FC2{} FL:31 Fi:1}



static void Test_Sf_BFu31ll_BFu1i()
{
  {
    init_simple_test("Sf_BFu31ll_BFu1i");
    static Sf_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Sf_BFu31ll_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu1i(Test_Sf_BFu31ll_BFu1i, "Sf_BFu31ll_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu1ll  {
  ::empty v1;
  __tsu64 v2:31;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu31ll_BFu1ll) C1{ FC2{} FL:31 FL:1}



static void Test_Sf_BFu31ll_BFu1ll()
{
  {
    init_simple_test("Sf_BFu31ll_BFu1ll");
    static Sf_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Sf_BFu31ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu1ll(Test_Sf_BFu31ll_BFu1ll, "Sf_BFu31ll_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu1s  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu31ll_BFu1s) C1{ FC2{} FL:31 Fs:1}



static void Test_Sf_BFu31ll_BFu1s()
{
  {
    init_simple_test("Sf_BFu31ll_BFu1s");
    static Sf_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "Sf_BFu31ll_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu1s(Test_Sf_BFu31ll_BFu1s, "Sf_BFu31ll_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu31i  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu31ll_BFu31i) C1{ FC2{} FL:31 Fi:31}



static void Test_Sf_BFu31ll_BFu31i()
{
  {
    init_simple_test("Sf_BFu31ll_BFu31i");
    static Sf_BFu31ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Sf_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu31i(Test_Sf_BFu31ll_BFu31i, "Sf_BFu31ll_BFu31i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu31ll  {
  ::empty v1;
  __tsu64 v2:31;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu31ll_BFu31ll) C1{ FC2{} FL:31 FL:31}



static void Test_Sf_BFu31ll_BFu31ll()
{
  {
    init_simple_test("Sf_BFu31ll_BFu31ll");
    static Sf_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, 1, "Sf_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu31ll(Test_Sf_BFu31ll_BFu31ll, "Sf_BFu31ll_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu32i  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu31ll_BFu32i) C1{ FC2{} FL:31 Fi:32}



static void Test_Sf_BFu31ll_BFu32i()
{
  {
    init_simple_test("Sf_BFu31ll_BFu32i");
    static Sf_BFu31ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Sf_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Sf_BFu31ll_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu32i(Test_Sf_BFu31ll_BFu32i, "Sf_BFu31ll_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu32ll  {
  ::empty v1;
  __tsu64 v2:31;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu31ll_BFu32ll) C1{ FC2{} FL:31 FL:32}



static void Test_Sf_BFu31ll_BFu32ll()
{
  {
    init_simple_test("Sf_BFu31ll_BFu32ll");
    static Sf_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, 1, "Sf_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 32, hide_ull(1LL<<31), "Sf_BFu31ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu32ll(Test_Sf_BFu31ll_BFu32ll, "Sf_BFu31ll_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu33  {
  ::empty v1;
  __tsu64 v2:31;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu31ll_BFu33) C1{ FC2{} FL:31 FL:33}



static void Test_Sf_BFu31ll_BFu33()
{
  {
    init_simple_test("Sf_BFu31ll_BFu33");
    static Sf_BFu31ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, 1, "Sf_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,7), 33, hide_ull(1LL<<32), "Sf_BFu31ll_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu33(Test_Sf_BFu31ll_BFu33, "Sf_BFu31ll_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu7c  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu31ll_BFu7c) C1{ FC2{} FL:31 Fc:7}



static void Test_Sf_BFu31ll_BFu7c()
{
  {
    init_simple_test("Sf_BFu31ll_BFu7c");
    static Sf_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Sf_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Sf_BFu31ll_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu7c(Test_Sf_BFu31ll_BFu7c, "Sf_BFu31ll_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu7i  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu31ll_BFu7i) C1{ FC2{} FL:31 Fi:7}



static void Test_Sf_BFu31ll_BFu7i()
{
  {
    init_simple_test("Sf_BFu31ll_BFu7i");
    static Sf_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Sf_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Sf_BFu31ll_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu7i(Test_Sf_BFu31ll_BFu7i, "Sf_BFu31ll_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu7ll  {
  ::empty v1;
  __tsu64 v2:31;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu31ll_BFu7ll) C1{ FC2{} FL:31 FL:7}



static void Test_Sf_BFu31ll_BFu7ll()
{
  {
    init_simple_test("Sf_BFu31ll_BFu7ll");
    static Sf_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Sf_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Sf_BFu31ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu7ll(Test_Sf_BFu31ll_BFu7ll, "Sf_BFu31ll_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu7s  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu31ll_BFu7s) C1{ FC2{} FL:31 Fs:7}



static void Test_Sf_BFu31ll_BFu7s()
{
  {
    init_simple_test("Sf_BFu31ll_BFu7s");
    static Sf_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "Sf_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "Sf_BFu31ll_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu7s(Test_Sf_BFu31ll_BFu7s, "Sf_BFu31ll_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu8c  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu31ll_BFu8c) C1{ FC2{} FL:31 Fc:8}



static void Test_Sf_BFu31ll_BFu8c()
{
  {
    init_simple_test("Sf_BFu31ll_BFu8c");
    static Sf_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Sf_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Sf_BFu31ll_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu8c(Test_Sf_BFu31ll_BFu8c, "Sf_BFu31ll_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu8i  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu31ll_BFu8i) C1{ FC2{} FL:31 Fi:8}



static void Test_Sf_BFu31ll_BFu8i()
{
  {
    init_simple_test("Sf_BFu31ll_BFu8i");
    static Sf_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Sf_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Sf_BFu31ll_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu8i(Test_Sf_BFu31ll_BFu8i, "Sf_BFu31ll_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu8ll  {
  ::empty v1;
  __tsu64 v2:31;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu31ll_BFu8ll) C1{ FC2{} FL:31 FL:8}



static void Test_Sf_BFu31ll_BFu8ll()
{
  {
    init_simple_test("Sf_BFu31ll_BFu8ll");
    static Sf_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Sf_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Sf_BFu31ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu8ll(Test_Sf_BFu31ll_BFu8ll, "Sf_BFu31ll_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu8s  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu31ll_BFu8s) C1{ FC2{} FL:31 Fs:8}



static void Test_Sf_BFu31ll_BFu8s()
{
  {
    init_simple_test("Sf_BFu31ll_BFu8s");
    static Sf_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "Sf_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "Sf_BFu31ll_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu8s(Test_Sf_BFu31ll_BFu8s, "Sf_BFu31ll_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu9i  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu31ll_BFu9i) C1{ FC2{} FL:31 Fi:9}



static void Test_Sf_BFu31ll_BFu9i()
{
  {
    init_simple_test("Sf_BFu31ll_BFu9i");
    static Sf_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Sf_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Sf_BFu31ll_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu9i(Test_Sf_BFu31ll_BFu9i, "Sf_BFu31ll_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu9ll  {
  ::empty v1;
  __tsu64 v2:31;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu31ll_BFu9ll) C1{ FC2{} FL:31 FL:9}



static void Test_Sf_BFu31ll_BFu9ll()
{
  {
    init_simple_test("Sf_BFu31ll_BFu9ll");
    static Sf_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Sf_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Sf_BFu31ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu9ll(Test_Sf_BFu31ll_BFu9ll, "Sf_BFu31ll_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_BFu9s  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu31ll_BFu9s) C1{ FC2{} FL:31 Fs:9}



static void Test_Sf_BFu31ll_BFu9s()
{
  {
    init_simple_test("Sf_BFu31ll_BFu9s");
    static Sf_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "Sf_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "Sf_BFu31ll_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_BFu9s(Test_Sf_BFu31ll_BFu9s, "Sf_BFu31ll_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_C  {
  ::empty v1;
  __tsu64 v2:31;
  char v3;
};
//SIG(1 Sf_BFu31ll_C) C1{ FC2{} FL:31 Fc}



static void Test_Sf_BFu31ll_C()
{
  {
    init_simple_test("Sf_BFu31ll_C");
    static Sf_BFu31ll_C lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_C");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_C");
    check_field_offset(lv, v3, 5, "Sf_BFu31ll_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_C(Test_Sf_BFu31ll_C, "Sf_BFu31ll_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_D  {
  ::empty v1;
  __tsu64 v2:31;
  double v3;
};
//SIG(1 Sf_BFu31ll_D) C1{ FC2{} FL:31 FL}



static void Test_Sf_BFu31ll_D()
{
  {
    init_simple_test("Sf_BFu31ll_D");
    static Sf_BFu31ll_D lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu31ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_D");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_D");
    check_field_offset(lv, v3, 8, "Sf_BFu31ll_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_D(Test_Sf_BFu31ll_D, "Sf_BFu31ll_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_F  {
  ::empty v1;
  __tsu64 v2:31;
  float v3;
};
//SIG(1 Sf_BFu31ll_F) C1{ FC2{} FL:31 Fi}



static void Test_Sf_BFu31ll_F()
{
  {
    init_simple_test("Sf_BFu31ll_F");
    static Sf_BFu31ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_F");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_F");
    check_field_offset(lv, v3, 8, "Sf_BFu31ll_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_F(Test_Sf_BFu31ll_F, "Sf_BFu31ll_F", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_I  {
  ::empty v1;
  __tsu64 v2:31;
  int v3;
};
//SIG(1 Sf_BFu31ll_I) C1{ FC2{} FL:31 Fi}



static void Test_Sf_BFu31ll_I()
{
  {
    init_simple_test("Sf_BFu31ll_I");
    static Sf_BFu31ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_I");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_I");
    check_field_offset(lv, v3, 8, "Sf_BFu31ll_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_I(Test_Sf_BFu31ll_I, "Sf_BFu31ll_I", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_Ip  {
  ::empty v1;
  __tsu64 v2:31;
  int *v3;
};
//SIG(1 Sf_BFu31ll_Ip) C1{ FC2{} FL:31 Fp}



static void Test_Sf_BFu31ll_Ip()
{
  {
    init_simple_test("Sf_BFu31ll_Ip");
    static Sf_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_Ip");
    check_field_offset(lv, v3, 8, "Sf_BFu31ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_Ip(Test_Sf_BFu31ll_Ip, "Sf_BFu31ll_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_L  {
  ::empty v1;
  __tsu64 v2:31;
  __tsi64 v3;
};
//SIG(1 Sf_BFu31ll_L) C1{ FC2{} FL:31 FL}



static void Test_Sf_BFu31ll_L()
{
  {
    init_simple_test("Sf_BFu31ll_L");
    static Sf_BFu31ll_L lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu31ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_L");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_L");
    check_field_offset(lv, v3, 8, "Sf_BFu31ll_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_L(Test_Sf_BFu31ll_L, "Sf_BFu31ll_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_S  {
  ::empty v1;
  __tsu64 v2:31;
  short v3;
};
//SIG(1 Sf_BFu31ll_S) C1{ FC2{} FL:31 Fs}



static void Test_Sf_BFu31ll_S()
{
  {
    init_simple_test("Sf_BFu31ll_S");
    static Sf_BFu31ll_S lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_S");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_S");
    check_field_offset(lv, v3, 6, "Sf_BFu31ll_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_S(Test_Sf_BFu31ll_S, "Sf_BFu31ll_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_Sf  {
  ::empty v1;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 Sf_BFu31ll_Sf) C1{ FC2{} FL:31 FC2}



static void Test_Sf_BFu31ll_Sf()
{
  {
    init_simple_test("Sf_BFu31ll_Sf");
    static Sf_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_Sf");
    check_field_offset(lv, v3, 5, "Sf_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_Sf(Test_Sf_BFu31ll_Sf, "Sf_BFu31ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_Uc  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned char v3;
};
//SIG(1 Sf_BFu31ll_Uc) C1{ FC2{} FL:31 Fc}



static void Test_Sf_BFu31ll_Uc()
{
  {
    init_simple_test("Sf_BFu31ll_Uc");
    static Sf_BFu31ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_Uc");
    check_field_offset(lv, v3, 5, "Sf_BFu31ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_Uc(Test_Sf_BFu31ll_Uc, "Sf_BFu31ll_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_Ui  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned int v3;
};
//SIG(1 Sf_BFu31ll_Ui) C1{ FC2{} FL:31 Fi}



static void Test_Sf_BFu31ll_Ui()
{
  {
    init_simple_test("Sf_BFu31ll_Ui");
    static Sf_BFu31ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_Ui");
    check_field_offset(lv, v3, 8, "Sf_BFu31ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_Ui(Test_Sf_BFu31ll_Ui, "Sf_BFu31ll_Ui", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_Ul  {
  ::empty v1;
  __tsu64 v2:31;
  __tsu64 v3;
};
//SIG(1 Sf_BFu31ll_Ul) C1{ FC2{} FL:31 FL}



static void Test_Sf_BFu31ll_Ul()
{
  {
    init_simple_test("Sf_BFu31ll_Ul");
    static Sf_BFu31ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu31ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_Ul");
    check_field_offset(lv, v3, 8, "Sf_BFu31ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_Ul(Test_Sf_BFu31ll_Ul, "Sf_BFu31ll_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_Us  {
  ::empty v1;
  __tsu64 v2:31;
  unsigned short v3;
};
//SIG(1 Sf_BFu31ll_Us) C1{ FC2{} FL:31 Fs}



static void Test_Sf_BFu31ll_Us()
{
  {
    init_simple_test("Sf_BFu31ll_Us");
    static Sf_BFu31ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu31ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_Us");
    check_field_offset(lv, v3, 6, "Sf_BFu31ll_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_Us(Test_Sf_BFu31ll_Us, "Sf_BFu31ll_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu31ll_Vp  {
  ::empty v1;
  __tsu64 v2:31;
  void *v3;
};
//SIG(1 Sf_BFu31ll_Vp) C1{ FC2{} FL:31 Fp}



static void Test_Sf_BFu31ll_Vp()
{
  {
    init_simple_test("Sf_BFu31ll_Vp");
    static Sf_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu31ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 31, 1, "Sf_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 31, hide_ull(1LL<<30), "Sf_BFu31ll_Vp");
    check_field_offset(lv, v3, 8, "Sf_BFu31ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu31ll_Vp(Test_Sf_BFu31ll_Vp, "Sf_BFu31ll_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i  {
  ::empty v1;
  unsigned int v2:32;
};
//SIG(1 Sf_BFu32i) C1{ FC2{} Fi:32}



static void Test_Sf_BFu32i()
{
  {
    init_simple_test("Sf_BFu32i");
    static Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu32i(Test_Sf_BFu32i, "Sf_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu15i  {
  ::empty v1;
  unsigned int v2:32;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu32i_BFu15i) C1{ FC2{} Fi:32 Fi:15}



static void Test_Sf_BFu32i_BFu15i()
{
  {
    init_simple_test("Sf_BFu32i_BFu15i");
    static Sf_BFu32i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Sf_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Sf_BFu32i_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu15i(Test_Sf_BFu32i_BFu15i, "Sf_BFu32i_BFu15i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu15ll  {
  ::empty v1;
  unsigned int v2:32;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu32i_BFu15ll) C1{ FC2{} Fi:32 FL:15}



static void Test_Sf_BFu32i_BFu15ll()
{
  {
    init_simple_test("Sf_BFu32i_BFu15ll");
    static Sf_BFu32i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Sf_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Sf_BFu32i_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu15ll(Test_Sf_BFu32i_BFu15ll, "Sf_BFu32i_BFu15ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu15s  {
  ::empty v1;
  unsigned int v2:32;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu32i_BFu15s) C1{ FC2{} Fi:32 Fs:15}



static void Test_Sf_BFu32i_BFu15s()
{
  {
    init_simple_test("Sf_BFu32i_BFu15s");
    static Sf_BFu32i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Sf_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Sf_BFu32i_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu15s(Test_Sf_BFu32i_BFu15s, "Sf_BFu32i_BFu15s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu16i  {
  ::empty v1;
  unsigned int v2:32;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu32i_BFu16i) C1{ FC2{} Fi:32 Fi:16}



static void Test_Sf_BFu32i_BFu16i()
{
  {
    init_simple_test("Sf_BFu32i_BFu16i");
    static Sf_BFu32i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Sf_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Sf_BFu32i_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu16i(Test_Sf_BFu32i_BFu16i, "Sf_BFu32i_BFu16i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu16ll  {
  ::empty v1;
  unsigned int v2:32;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu32i_BFu16ll) C1{ FC2{} Fi:32 FL:16}



static void Test_Sf_BFu32i_BFu16ll()
{
  {
    init_simple_test("Sf_BFu32i_BFu16ll");
    static Sf_BFu32i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Sf_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Sf_BFu32i_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu16ll(Test_Sf_BFu32i_BFu16ll, "Sf_BFu32i_BFu16ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu16s  {
  ::empty v1;
  unsigned int v2:32;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu32i_BFu16s) C1{ FC2{} Fi:32 Fs:16}



static void Test_Sf_BFu32i_BFu16s()
{
  {
    init_simple_test("Sf_BFu32i_BFu16s");
    static Sf_BFu32i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Sf_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Sf_BFu32i_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu16s(Test_Sf_BFu32i_BFu16s, "Sf_BFu32i_BFu16s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu17i  {
  ::empty v1;
  unsigned int v2:32;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu32i_BFu17i) C1{ FC2{} Fi:32 Fi:17}



static void Test_Sf_BFu32i_BFu17i()
{
  {
    init_simple_test("Sf_BFu32i_BFu17i");
    static Sf_BFu32i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Sf_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Sf_BFu32i_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu17i(Test_Sf_BFu32i_BFu17i, "Sf_BFu32i_BFu17i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu17ll  {
  ::empty v1;
  unsigned int v2:32;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu32i_BFu17ll) C1{ FC2{} Fi:32 FL:17}



static void Test_Sf_BFu32i_BFu17ll()
{
  {
    init_simple_test("Sf_BFu32i_BFu17ll");
    static Sf_BFu32i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Sf_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Sf_BFu32i_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu17ll(Test_Sf_BFu32i_BFu17ll, "Sf_BFu32i_BFu17ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu1c  {
  ::empty v1;
  unsigned int v2:32;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu32i_BFu1c) C1{ FC2{} Fi:32 Fc:1}



static void Test_Sf_BFu32i_BFu1c()
{
  {
    init_simple_test("Sf_BFu32i_BFu1c");
    static Sf_BFu32i_BFu1c lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Sf_BFu32i_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu1c(Test_Sf_BFu32i_BFu1c, "Sf_BFu32i_BFu1c", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu1i  {
  ::empty v1;
  unsigned int v2:32;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu32i_BFu1i) C1{ FC2{} Fi:32 Fi:1}



static void Test_Sf_BFu32i_BFu1i()
{
  {
    init_simple_test("Sf_BFu32i_BFu1i");
    static Sf_BFu32i_BFu1i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Sf_BFu32i_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu1i(Test_Sf_BFu32i_BFu1i, "Sf_BFu32i_BFu1i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu1ll  {
  ::empty v1;
  unsigned int v2:32;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu32i_BFu1ll) C1{ FC2{} Fi:32 FL:1}



static void Test_Sf_BFu32i_BFu1ll()
{
  {
    init_simple_test("Sf_BFu32i_BFu1ll");
    static Sf_BFu32i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Sf_BFu32i_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu1ll(Test_Sf_BFu32i_BFu1ll, "Sf_BFu32i_BFu1ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu1s  {
  ::empty v1;
  unsigned int v2:32;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu32i_BFu1s) C1{ FC2{} Fi:32 Fs:1}



static void Test_Sf_BFu32i_BFu1s()
{
  {
    init_simple_test("Sf_BFu32i_BFu1s");
    static Sf_BFu32i_BFu1s lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "Sf_BFu32i_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu1s(Test_Sf_BFu32i_BFu1s, "Sf_BFu32i_BFu1s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu31i  {
  ::empty v1;
  unsigned int v2:32;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu32i_BFu31i) C1{ FC2{} Fi:32 Fi:31}



static void Test_Sf_BFu32i_BFu31i()
{
  {
    init_simple_test("Sf_BFu32i_BFu31i");
    static Sf_BFu32i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Sf_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Sf_BFu32i_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu31i(Test_Sf_BFu32i_BFu31i, "Sf_BFu32i_BFu31i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu31ll  {
  ::empty v1;
  unsigned int v2:32;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu32i_BFu31ll) C1{ FC2{} Fi:32 FL:31}



static void Test_Sf_BFu32i_BFu31ll()
{
  {
    init_simple_test("Sf_BFu32i_BFu31ll");
    static Sf_BFu32i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Sf_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Sf_BFu32i_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu31ll(Test_Sf_BFu32i_BFu31ll, "Sf_BFu32i_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu32i  {
  ::empty v1;
  unsigned int v2:32;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu32i_BFu32i) C1{ FC2{} Fi:32 Fi:32}



static void Test_Sf_BFu32i_BFu32i()
{
  {
    init_simple_test("Sf_BFu32i_BFu32i");
    static Sf_BFu32i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Sf_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu32i(Test_Sf_BFu32i_BFu32i, "Sf_BFu32i_BFu32i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu32ll  {
  ::empty v1;
  unsigned int v2:32;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu32i_BFu32ll) C1{ FC2{} Fi:32 FL:32}



static void Test_Sf_BFu32i_BFu32ll()
{
  {
    init_simple_test("Sf_BFu32i_BFu32ll");
    static Sf_BFu32i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Sf_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu32ll(Test_Sf_BFu32i_BFu32ll, "Sf_BFu32i_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu33  {
  ::empty v1;
  unsigned int v2:32;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu32i_BFu33) C1{ FC2{} Fi:32 FL:33}



static void Test_Sf_BFu32i_BFu33()
{
  {
    init_simple_test("Sf_BFu32i_BFu33");
    static Sf_BFu32i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu32i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "Sf_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "Sf_BFu32i_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu33(Test_Sf_BFu32i_BFu33, "Sf_BFu32i_BFu33", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu7c  {
  ::empty v1;
  unsigned int v2:32;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu32i_BFu7c) C1{ FC2{} Fi:32 Fc:7}



static void Test_Sf_BFu32i_BFu7c()
{
  {
    init_simple_test("Sf_BFu32i_BFu7c");
    static Sf_BFu32i_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Sf_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Sf_BFu32i_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu7c(Test_Sf_BFu32i_BFu7c, "Sf_BFu32i_BFu7c", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu7i  {
  ::empty v1;
  unsigned int v2:32;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu32i_BFu7i) C1{ FC2{} Fi:32 Fi:7}



static void Test_Sf_BFu32i_BFu7i()
{
  {
    init_simple_test("Sf_BFu32i_BFu7i");
    static Sf_BFu32i_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Sf_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Sf_BFu32i_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu7i(Test_Sf_BFu32i_BFu7i, "Sf_BFu32i_BFu7i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu7ll  {
  ::empty v1;
  unsigned int v2:32;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu32i_BFu7ll) C1{ FC2{} Fi:32 FL:7}



static void Test_Sf_BFu32i_BFu7ll()
{
  {
    init_simple_test("Sf_BFu32i_BFu7ll");
    static Sf_BFu32i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Sf_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Sf_BFu32i_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu7ll(Test_Sf_BFu32i_BFu7ll, "Sf_BFu32i_BFu7ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu7s  {
  ::empty v1;
  unsigned int v2:32;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu32i_BFu7s) C1{ FC2{} Fi:32 Fs:7}



static void Test_Sf_BFu32i_BFu7s()
{
  {
    init_simple_test("Sf_BFu32i_BFu7s");
    static Sf_BFu32i_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Sf_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Sf_BFu32i_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu7s(Test_Sf_BFu32i_BFu7s, "Sf_BFu32i_BFu7s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu8c  {
  ::empty v1;
  unsigned int v2:32;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu32i_BFu8c) C1{ FC2{} Fi:32 Fc:8}



static void Test_Sf_BFu32i_BFu8c()
{
  {
    init_simple_test("Sf_BFu32i_BFu8c");
    static Sf_BFu32i_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Sf_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Sf_BFu32i_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu8c(Test_Sf_BFu32i_BFu8c, "Sf_BFu32i_BFu8c", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu8i  {
  ::empty v1;
  unsigned int v2:32;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu32i_BFu8i) C1{ FC2{} Fi:32 Fi:8}



static void Test_Sf_BFu32i_BFu8i()
{
  {
    init_simple_test("Sf_BFu32i_BFu8i");
    static Sf_BFu32i_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Sf_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Sf_BFu32i_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu8i(Test_Sf_BFu32i_BFu8i, "Sf_BFu32i_BFu8i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu8ll  {
  ::empty v1;
  unsigned int v2:32;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu32i_BFu8ll) C1{ FC2{} Fi:32 FL:8}



static void Test_Sf_BFu32i_BFu8ll()
{
  {
    init_simple_test("Sf_BFu32i_BFu8ll");
    static Sf_BFu32i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Sf_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Sf_BFu32i_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu8ll(Test_Sf_BFu32i_BFu8ll, "Sf_BFu32i_BFu8ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu8s  {
  ::empty v1;
  unsigned int v2:32;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu32i_BFu8s) C1{ FC2{} Fi:32 Fs:8}



static void Test_Sf_BFu32i_BFu8s()
{
  {
    init_simple_test("Sf_BFu32i_BFu8s");
    static Sf_BFu32i_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Sf_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Sf_BFu32i_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu8s(Test_Sf_BFu32i_BFu8s, "Sf_BFu32i_BFu8s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu9i  {
  ::empty v1;
  unsigned int v2:32;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu32i_BFu9i) C1{ FC2{} Fi:32 Fi:9}



static void Test_Sf_BFu32i_BFu9i()
{
  {
    init_simple_test("Sf_BFu32i_BFu9i");
    static Sf_BFu32i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Sf_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Sf_BFu32i_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu9i(Test_Sf_BFu32i_BFu9i, "Sf_BFu32i_BFu9i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu9ll  {
  ::empty v1;
  unsigned int v2:32;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu32i_BFu9ll) C1{ FC2{} Fi:32 FL:9}



static void Test_Sf_BFu32i_BFu9ll()
{
  {
    init_simple_test("Sf_BFu32i_BFu9ll");
    static Sf_BFu32i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Sf_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Sf_BFu32i_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu9ll(Test_Sf_BFu32i_BFu9ll, "Sf_BFu32i_BFu9ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_BFu9s  {
  ::empty v1;
  unsigned int v2:32;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu32i_BFu9s) C1{ FC2{} Fi:32 Fs:9}



static void Test_Sf_BFu32i_BFu9s()
{
  {
    init_simple_test("Sf_BFu32i_BFu9s");
    static Sf_BFu32i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Sf_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Sf_BFu32i_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_BFu9s(Test_Sf_BFu32i_BFu9s, "Sf_BFu32i_BFu9s", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_C  {
  ::empty v1;
  unsigned int v2:32;
  char v3;
};
//SIG(1 Sf_BFu32i_C) C1{ FC2{} Fi:32 Fc}



static void Test_Sf_BFu32i_C()
{
  {
    init_simple_test("Sf_BFu32i_C");
    static Sf_BFu32i_C lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_C");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_C");
    check_field_offset(lv, v3, 8, "Sf_BFu32i_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_C(Test_Sf_BFu32i_C, "Sf_BFu32i_C", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_D  {
  ::empty v1;
  unsigned int v2:32;
  double v3;
};
//SIG(1 Sf_BFu32i_D) C1{ FC2{} Fi:32 FL}



static void Test_Sf_BFu32i_D()
{
  {
    init_simple_test("Sf_BFu32i_D");
    static Sf_BFu32i_D lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu32i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_D");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_D");
    check_field_offset(lv, v3, 8, "Sf_BFu32i_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_D(Test_Sf_BFu32i_D, "Sf_BFu32i_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_F  {
  ::empty v1;
  unsigned int v2:32;
  float v3;
};
//SIG(1 Sf_BFu32i_F) C1{ FC2{} Fi:32 Fi}



static void Test_Sf_BFu32i_F()
{
  {
    init_simple_test("Sf_BFu32i_F");
    static Sf_BFu32i_F lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_F");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_F");
    check_field_offset(lv, v3, 8, "Sf_BFu32i_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_F(Test_Sf_BFu32i_F, "Sf_BFu32i_F", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_I  {
  ::empty v1;
  unsigned int v2:32;
  int v3;
};
//SIG(1 Sf_BFu32i_I) C1{ FC2{} Fi:32 Fi}



static void Test_Sf_BFu32i_I()
{
  {
    init_simple_test("Sf_BFu32i_I");
    static Sf_BFu32i_I lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_I");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_I");
    check_field_offset(lv, v3, 8, "Sf_BFu32i_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_I(Test_Sf_BFu32i_I, "Sf_BFu32i_I", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_Ip  {
  ::empty v1;
  unsigned int v2:32;
  int *v3;
};
//SIG(1 Sf_BFu32i_Ip) C1{ FC2{} Fi:32 Fp}



static void Test_Sf_BFu32i_Ip()
{
  {
    init_simple_test("Sf_BFu32i_Ip");
    static Sf_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_Ip");
    check_field_offset(lv, v3, 8, "Sf_BFu32i_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_Ip(Test_Sf_BFu32i_Ip, "Sf_BFu32i_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_L  {
  ::empty v1;
  unsigned int v2:32;
  __tsi64 v3;
};
//SIG(1 Sf_BFu32i_L) C1{ FC2{} Fi:32 FL}



static void Test_Sf_BFu32i_L()
{
  {
    init_simple_test("Sf_BFu32i_L");
    static Sf_BFu32i_L lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu32i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_L");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_L");
    check_field_offset(lv, v3, 8, "Sf_BFu32i_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_L(Test_Sf_BFu32i_L, "Sf_BFu32i_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_S  {
  ::empty v1;
  unsigned int v2:32;
  short v3;
};
//SIG(1 Sf_BFu32i_S) C1{ FC2{} Fi:32 Fs}



static void Test_Sf_BFu32i_S()
{
  {
    init_simple_test("Sf_BFu32i_S");
    static Sf_BFu32i_S lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_S");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_S");
    check_field_offset(lv, v3, 8, "Sf_BFu32i_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_S(Test_Sf_BFu32i_S, "Sf_BFu32i_S", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_Sf  {
  ::empty v1;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 Sf_BFu32i_Sf) C1{ FC2{} Fi:32 FC2}



static void Test_Sf_BFu32i_Sf()
{
  {
    init_simple_test("Sf_BFu32i_Sf");
    static Sf_BFu32i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_Sf.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "Sf_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_Sf(Test_Sf_BFu32i_Sf, "Sf_BFu32i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_Uc  {
  ::empty v1;
  unsigned int v2:32;
  unsigned char v3;
};
//SIG(1 Sf_BFu32i_Uc) C1{ FC2{} Fi:32 Fc}



static void Test_Sf_BFu32i_Uc()
{
  {
    init_simple_test("Sf_BFu32i_Uc");
    static Sf_BFu32i_Uc lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_Uc");
    check_field_offset(lv, v3, 8, "Sf_BFu32i_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_Uc(Test_Sf_BFu32i_Uc, "Sf_BFu32i_Uc", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_Ui  {
  ::empty v1;
  unsigned int v2:32;
  unsigned int v3;
};
//SIG(1 Sf_BFu32i_Ui) C1{ FC2{} Fi:32 Fi}



static void Test_Sf_BFu32i_Ui()
{
  {
    init_simple_test("Sf_BFu32i_Ui");
    static Sf_BFu32i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_Ui");
    check_field_offset(lv, v3, 8, "Sf_BFu32i_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_Ui(Test_Sf_BFu32i_Ui, "Sf_BFu32i_Ui", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_Ul  {
  ::empty v1;
  unsigned int v2:32;
  __tsu64 v3;
};
//SIG(1 Sf_BFu32i_Ul) C1{ FC2{} Fi:32 FL}



static void Test_Sf_BFu32i_Ul()
{
  {
    init_simple_test("Sf_BFu32i_Ul");
    static Sf_BFu32i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu32i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_Ul");
    check_field_offset(lv, v3, 8, "Sf_BFu32i_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_Ul(Test_Sf_BFu32i_Ul, "Sf_BFu32i_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_Us  {
  ::empty v1;
  unsigned int v2:32;
  unsigned short v3;
};
//SIG(1 Sf_BFu32i_Us) C1{ FC2{} Fi:32 Fs}



static void Test_Sf_BFu32i_Us()
{
  {
    init_simple_test("Sf_BFu32i_Us");
    static Sf_BFu32i_Us lv;
    check2(sizeof(lv), 12, "sizeof(Sf_BFu32i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_Us");
    check_field_offset(lv, v3, 8, "Sf_BFu32i_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_Us(Test_Sf_BFu32i_Us, "Sf_BFu32i_Us", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32i_Vp  {
  ::empty v1;
  unsigned int v2:32;
  void *v3;
};
//SIG(1 Sf_BFu32i_Vp) C1{ FC2{} Fi:32 Fp}



static void Test_Sf_BFu32i_Vp()
{
  {
    init_simple_test("Sf_BFu32i_Vp");
    static Sf_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Sf_BFu32i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu32i_Vp");
    check_field_offset(lv, v3, 8, "Sf_BFu32i_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32i_Vp(Test_Sf_BFu32i_Vp, "Sf_BFu32i_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll  {
  ::empty v1;
  __tsu64 v2:32;
};
//SIG(1 Sf_BFu32ll) C1{ FC2{} FL:32}



static void Test_Sf_BFu32ll()
{
  {
    init_simple_test("Sf_BFu32ll");
    static Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll(Test_Sf_BFu32ll, "Sf_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu15i  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu32ll_BFu15i) C1{ FC2{} FL:32 Fi:15}



static void Test_Sf_BFu32ll_BFu15i()
{
  {
    init_simple_test("Sf_BFu32ll_BFu15i");
    static Sf_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "Sf_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "Sf_BFu32ll_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu15i(Test_Sf_BFu32ll_BFu15i, "Sf_BFu32ll_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu15ll  {
  ::empty v1;
  __tsu64 v2:32;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu32ll_BFu15ll) C1{ FC2{} FL:32 FL:15}



static void Test_Sf_BFu32ll_BFu15ll()
{
  {
    init_simple_test("Sf_BFu32ll_BFu15ll");
    static Sf_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "Sf_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "Sf_BFu32ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu15ll(Test_Sf_BFu32ll_BFu15ll, "Sf_BFu32ll_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu15s  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu32ll_BFu15s) C1{ FC2{} FL:32 Fs:15}



static void Test_Sf_BFu32ll_BFu15s()
{
  {
    init_simple_test("Sf_BFu32ll_BFu15s");
    static Sf_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Sf_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Sf_BFu32ll_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu15s(Test_Sf_BFu32ll_BFu15s, "Sf_BFu32ll_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu16i  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu32ll_BFu16i) C1{ FC2{} FL:32 Fi:16}



static void Test_Sf_BFu32ll_BFu16i()
{
  {
    init_simple_test("Sf_BFu32ll_BFu16i");
    static Sf_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "Sf_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "Sf_BFu32ll_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu16i(Test_Sf_BFu32ll_BFu16i, "Sf_BFu32ll_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu16ll  {
  ::empty v1;
  __tsu64 v2:32;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu32ll_BFu16ll) C1{ FC2{} FL:32 FL:16}



static void Test_Sf_BFu32ll_BFu16ll()
{
  {
    init_simple_test("Sf_BFu32ll_BFu16ll");
    static Sf_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "Sf_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "Sf_BFu32ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu16ll(Test_Sf_BFu32ll_BFu16ll, "Sf_BFu32ll_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu16s  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu32ll_BFu16s) C1{ FC2{} FL:32 Fs:16}



static void Test_Sf_BFu32ll_BFu16s()
{
  {
    init_simple_test("Sf_BFu32ll_BFu16s");
    static Sf_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Sf_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Sf_BFu32ll_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu16s(Test_Sf_BFu32ll_BFu16s, "Sf_BFu32ll_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu17i  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu32ll_BFu17i) C1{ FC2{} FL:32 Fi:17}



static void Test_Sf_BFu32ll_BFu17i()
{
  {
    init_simple_test("Sf_BFu32ll_BFu17i");
    static Sf_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "Sf_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "Sf_BFu32ll_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu17i(Test_Sf_BFu32ll_BFu17i, "Sf_BFu32ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu17ll  {
  ::empty v1;
  __tsu64 v2:32;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu32ll_BFu17ll) C1{ FC2{} FL:32 FL:17}



static void Test_Sf_BFu32ll_BFu17ll()
{
  {
    init_simple_test("Sf_BFu32ll_BFu17ll");
    static Sf_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "Sf_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "Sf_BFu32ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu17ll(Test_Sf_BFu32ll_BFu17ll, "Sf_BFu32ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu1c  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu32ll_BFu1c) C1{ FC2{} FL:32 Fc:1}



static void Test_Sf_BFu32ll_BFu1c()
{
  {
    init_simple_test("Sf_BFu32ll_BFu1c");
    static Sf_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Sf_BFu32ll_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu1c(Test_Sf_BFu32ll_BFu1c, "Sf_BFu32ll_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu1i  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu32ll_BFu1i) C1{ FC2{} FL:32 Fi:1}



static void Test_Sf_BFu32ll_BFu1i()
{
  {
    init_simple_test("Sf_BFu32ll_BFu1i");
    static Sf_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Sf_BFu32ll_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu1i(Test_Sf_BFu32ll_BFu1i, "Sf_BFu32ll_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu1ll  {
  ::empty v1;
  __tsu64 v2:32;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu32ll_BFu1ll) C1{ FC2{} FL:32 FL:1}



static void Test_Sf_BFu32ll_BFu1ll()
{
  {
    init_simple_test("Sf_BFu32ll_BFu1ll");
    static Sf_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Sf_BFu32ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu1ll(Test_Sf_BFu32ll_BFu1ll, "Sf_BFu32ll_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu1s  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu32ll_BFu1s) C1{ FC2{} FL:32 Fs:1}



static void Test_Sf_BFu32ll_BFu1s()
{
  {
    init_simple_test("Sf_BFu32ll_BFu1s");
    static Sf_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "Sf_BFu32ll_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu1s(Test_Sf_BFu32ll_BFu1s, "Sf_BFu32ll_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu31i  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu32ll_BFu31i) C1{ FC2{} FL:32 Fi:31}



static void Test_Sf_BFu32ll_BFu31i()
{
  {
    init_simple_test("Sf_BFu32ll_BFu31i");
    static Sf_BFu32ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Sf_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Sf_BFu32ll_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu31i(Test_Sf_BFu32ll_BFu31i, "Sf_BFu32ll_BFu31i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu31ll  {
  ::empty v1;
  __tsu64 v2:32;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu32ll_BFu31ll) C1{ FC2{} FL:32 FL:31}



static void Test_Sf_BFu32ll_BFu31ll()
{
  {
    init_simple_test("Sf_BFu32ll_BFu31ll");
    static Sf_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, 1, "Sf_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, hide_ull(1LL<<30), "Sf_BFu32ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu31ll(Test_Sf_BFu32ll_BFu31ll, "Sf_BFu32ll_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu32i  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu32ll_BFu32i) C1{ FC2{} FL:32 Fi:32}



static void Test_Sf_BFu32ll_BFu32i()
{
  {
    init_simple_test("Sf_BFu32ll_BFu32i");
    static Sf_BFu32ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Sf_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu32i(Test_Sf_BFu32ll_BFu32i, "Sf_BFu32ll_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu32ll  {
  ::empty v1;
  __tsu64 v2:32;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu32ll_BFu32ll) C1{ FC2{} FL:32 FL:32}



static void Test_Sf_BFu32ll_BFu32ll()
{
  {
    init_simple_test("Sf_BFu32ll_BFu32ll");
    static Sf_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, 1, "Sf_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu32ll(Test_Sf_BFu32ll_BFu32ll, "Sf_BFu32ll_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu33  {
  ::empty v1;
  __tsu64 v2:32;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu32ll_BFu33) C1{ FC2{} FL:32 FL:33}



static void Test_Sf_BFu32ll_BFu33()
{
  {
    init_simple_test("Sf_BFu32ll_BFu33");
    static Sf_BFu32ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, 1, "Sf_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, hide_ull(1LL<<32), "Sf_BFu32ll_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu33(Test_Sf_BFu32ll_BFu33, "Sf_BFu32ll_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu7c  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu32ll_BFu7c) C1{ FC2{} FL:32 Fc:7}



static void Test_Sf_BFu32ll_BFu7c()
{
  {
    init_simple_test("Sf_BFu32ll_BFu7c");
    static Sf_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Sf_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Sf_BFu32ll_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu7c(Test_Sf_BFu32ll_BFu7c, "Sf_BFu32ll_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu7i  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu32ll_BFu7i) C1{ FC2{} FL:32 Fi:7}



static void Test_Sf_BFu32ll_BFu7i()
{
  {
    init_simple_test("Sf_BFu32ll_BFu7i");
    static Sf_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Sf_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Sf_BFu32ll_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu7i(Test_Sf_BFu32ll_BFu7i, "Sf_BFu32ll_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu7ll  {
  ::empty v1;
  __tsu64 v2:32;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu32ll_BFu7ll) C1{ FC2{} FL:32 FL:7}



static void Test_Sf_BFu32ll_BFu7ll()
{
  {
    init_simple_test("Sf_BFu32ll_BFu7ll");
    static Sf_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Sf_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Sf_BFu32ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu7ll(Test_Sf_BFu32ll_BFu7ll, "Sf_BFu32ll_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu7s  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu32ll_BFu7s) C1{ FC2{} FL:32 Fs:7}



static void Test_Sf_BFu32ll_BFu7s()
{
  {
    init_simple_test("Sf_BFu32ll_BFu7s");
    static Sf_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "Sf_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "Sf_BFu32ll_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu7s(Test_Sf_BFu32ll_BFu7s, "Sf_BFu32ll_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu8c  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu32ll_BFu8c) C1{ FC2{} FL:32 Fc:8}



static void Test_Sf_BFu32ll_BFu8c()
{
  {
    init_simple_test("Sf_BFu32ll_BFu8c");
    static Sf_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Sf_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Sf_BFu32ll_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu8c(Test_Sf_BFu32ll_BFu8c, "Sf_BFu32ll_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu8i  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu32ll_BFu8i) C1{ FC2{} FL:32 Fi:8}



static void Test_Sf_BFu32ll_BFu8i()
{
  {
    init_simple_test("Sf_BFu32ll_BFu8i");
    static Sf_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Sf_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Sf_BFu32ll_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu8i(Test_Sf_BFu32ll_BFu8i, "Sf_BFu32ll_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu8ll  {
  ::empty v1;
  __tsu64 v2:32;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu32ll_BFu8ll) C1{ FC2{} FL:32 FL:8}



static void Test_Sf_BFu32ll_BFu8ll()
{
  {
    init_simple_test("Sf_BFu32ll_BFu8ll");
    static Sf_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Sf_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Sf_BFu32ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu8ll(Test_Sf_BFu32ll_BFu8ll, "Sf_BFu32ll_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu8s  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu32ll_BFu8s) C1{ FC2{} FL:32 Fs:8}



static void Test_Sf_BFu32ll_BFu8s()
{
  {
    init_simple_test("Sf_BFu32ll_BFu8s");
    static Sf_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Sf_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Sf_BFu32ll_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu8s(Test_Sf_BFu32ll_BFu8s, "Sf_BFu32ll_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu9i  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu32ll_BFu9i) C1{ FC2{} FL:32 Fi:9}



static void Test_Sf_BFu32ll_BFu9i()
{
  {
    init_simple_test("Sf_BFu32ll_BFu9i");
    static Sf_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "Sf_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "Sf_BFu32ll_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu9i(Test_Sf_BFu32ll_BFu9i, "Sf_BFu32ll_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu9ll  {
  ::empty v1;
  __tsu64 v2:32;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu32ll_BFu9ll) C1{ FC2{} FL:32 FL:9}



static void Test_Sf_BFu32ll_BFu9ll()
{
  {
    init_simple_test("Sf_BFu32ll_BFu9ll");
    static Sf_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "Sf_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "Sf_BFu32ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu9ll(Test_Sf_BFu32ll_BFu9ll, "Sf_BFu32ll_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_BFu9s  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu32ll_BFu9s) C1{ FC2{} FL:32 Fs:9}



static void Test_Sf_BFu32ll_BFu9s()
{
  {
    init_simple_test("Sf_BFu32ll_BFu9s");
    static Sf_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Sf_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Sf_BFu32ll_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_BFu9s(Test_Sf_BFu32ll_BFu9s, "Sf_BFu32ll_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_C  {
  ::empty v1;
  __tsu64 v2:32;
  char v3;
};
//SIG(1 Sf_BFu32ll_C) C1{ FC2{} FL:32 Fc}



static void Test_Sf_BFu32ll_C()
{
  {
    init_simple_test("Sf_BFu32ll_C");
    static Sf_BFu32ll_C lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_C");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_C");
    check_field_offset(lv, v3, 5, "Sf_BFu32ll_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_C(Test_Sf_BFu32ll_C, "Sf_BFu32ll_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_D  {
  ::empty v1;
  __tsu64 v2:32;
  double v3;
};
//SIG(1 Sf_BFu32ll_D) C1{ FC2{} FL:32 FL}



static void Test_Sf_BFu32ll_D()
{
  {
    init_simple_test("Sf_BFu32ll_D");
    static Sf_BFu32ll_D lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu32ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_D");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_D");
    check_field_offset(lv, v3, 8, "Sf_BFu32ll_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_D(Test_Sf_BFu32ll_D, "Sf_BFu32ll_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_F  {
  ::empty v1;
  __tsu64 v2:32;
  float v3;
};
//SIG(1 Sf_BFu32ll_F) C1{ FC2{} FL:32 Fi}



static void Test_Sf_BFu32ll_F()
{
  {
    init_simple_test("Sf_BFu32ll_F");
    static Sf_BFu32ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_F");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_F");
    check_field_offset(lv, v3, 8, "Sf_BFu32ll_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_F(Test_Sf_BFu32ll_F, "Sf_BFu32ll_F", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_I  {
  ::empty v1;
  __tsu64 v2:32;
  int v3;
};
//SIG(1 Sf_BFu32ll_I) C1{ FC2{} FL:32 Fi}



static void Test_Sf_BFu32ll_I()
{
  {
    init_simple_test("Sf_BFu32ll_I");
    static Sf_BFu32ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_I");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_I");
    check_field_offset(lv, v3, 8, "Sf_BFu32ll_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_I(Test_Sf_BFu32ll_I, "Sf_BFu32ll_I", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_Ip  {
  ::empty v1;
  __tsu64 v2:32;
  int *v3;
};
//SIG(1 Sf_BFu32ll_Ip) C1{ FC2{} FL:32 Fp}



static void Test_Sf_BFu32ll_Ip()
{
  {
    init_simple_test("Sf_BFu32ll_Ip");
    static Sf_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_Ip");
    check_field_offset(lv, v3, 8, "Sf_BFu32ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_Ip(Test_Sf_BFu32ll_Ip, "Sf_BFu32ll_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_L  {
  ::empty v1;
  __tsu64 v2:32;
  __tsi64 v3;
};
//SIG(1 Sf_BFu32ll_L) C1{ FC2{} FL:32 FL}



static void Test_Sf_BFu32ll_L()
{
  {
    init_simple_test("Sf_BFu32ll_L");
    static Sf_BFu32ll_L lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu32ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_L");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_L");
    check_field_offset(lv, v3, 8, "Sf_BFu32ll_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_L(Test_Sf_BFu32ll_L, "Sf_BFu32ll_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_S  {
  ::empty v1;
  __tsu64 v2:32;
  short v3;
};
//SIG(1 Sf_BFu32ll_S) C1{ FC2{} FL:32 Fs}



static void Test_Sf_BFu32ll_S()
{
  {
    init_simple_test("Sf_BFu32ll_S");
    static Sf_BFu32ll_S lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_S");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_S");
    check_field_offset(lv, v3, 6, "Sf_BFu32ll_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_S(Test_Sf_BFu32ll_S, "Sf_BFu32ll_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_Sf  {
  ::empty v1;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 Sf_BFu32ll_Sf) C1{ FC2{} FL:32 FC2}



static void Test_Sf_BFu32ll_Sf()
{
  {
    init_simple_test("Sf_BFu32ll_Sf");
    static Sf_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "Sf_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_Sf(Test_Sf_BFu32ll_Sf, "Sf_BFu32ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_Uc  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned char v3;
};
//SIG(1 Sf_BFu32ll_Uc) C1{ FC2{} FL:32 Fc}



static void Test_Sf_BFu32ll_Uc()
{
  {
    init_simple_test("Sf_BFu32ll_Uc");
    static Sf_BFu32ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_Uc");
    check_field_offset(lv, v3, 5, "Sf_BFu32ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_Uc(Test_Sf_BFu32ll_Uc, "Sf_BFu32ll_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_Ui  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned int v3;
};
//SIG(1 Sf_BFu32ll_Ui) C1{ FC2{} FL:32 Fi}



static void Test_Sf_BFu32ll_Ui()
{
  {
    init_simple_test("Sf_BFu32ll_Ui");
    static Sf_BFu32ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_Ui");
    check_field_offset(lv, v3, 8, "Sf_BFu32ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_Ui(Test_Sf_BFu32ll_Ui, "Sf_BFu32ll_Ui", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_Ul  {
  ::empty v1;
  __tsu64 v2:32;
  __tsu64 v3;
};
//SIG(1 Sf_BFu32ll_Ul) C1{ FC2{} FL:32 FL}



static void Test_Sf_BFu32ll_Ul()
{
  {
    init_simple_test("Sf_BFu32ll_Ul");
    static Sf_BFu32ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu32ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_Ul");
    check_field_offset(lv, v3, 8, "Sf_BFu32ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_Ul(Test_Sf_BFu32ll_Ul, "Sf_BFu32ll_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_Us  {
  ::empty v1;
  __tsu64 v2:32;
  unsigned short v3;
};
//SIG(1 Sf_BFu32ll_Us) C1{ FC2{} FL:32 Fs}



static void Test_Sf_BFu32ll_Us()
{
  {
    init_simple_test("Sf_BFu32ll_Us");
    static Sf_BFu32ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu32ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_Us");
    check_field_offset(lv, v3, 6, "Sf_BFu32ll_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_Us(Test_Sf_BFu32ll_Us, "Sf_BFu32ll_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu32ll_Vp  {
  ::empty v1;
  __tsu64 v2:32;
  void *v3;
};
//SIG(1 Sf_BFu32ll_Vp) C1{ FC2{} FL:32 Fp}



static void Test_Sf_BFu32ll_Vp()
{
  {
    init_simple_test("Sf_BFu32ll_Vp");
    static Sf_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu32ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 32, 1, "Sf_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 32, hide_ull(1LL<<31), "Sf_BFu32ll_Vp");
    check_field_offset(lv, v3, 8, "Sf_BFu32ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu32ll_Vp(Test_Sf_BFu32ll_Vp, "Sf_BFu32ll_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33  {
  ::empty v1;
  __tsu64 v2:33;
};
//SIG(1 Sf_BFu33) C1{ FC2{} FL:33}



static void Test_Sf_BFu33()
{
  {
    init_simple_test("Sf_BFu33");
    static Sf_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu33(Test_Sf_BFu33, "Sf_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu15i  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu33_BFu15i) C1{ FC2{} FL:33 Fi:15}



static void Test_Sf_BFu33_BFu15i()
{
  {
    init_simple_test("Sf_BFu33_BFu15i");
    static Sf_BFu33_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "Sf_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "Sf_BFu33_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu15i(Test_Sf_BFu33_BFu15i, "Sf_BFu33_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu15ll  {
  ::empty v1;
  __tsu64 v2:33;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu33_BFu15ll) C1{ FC2{} FL:33 FL:15}



static void Test_Sf_BFu33_BFu15ll()
{
  {
    init_simple_test("Sf_BFu33_BFu15ll");
    static Sf_BFu33_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "Sf_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "Sf_BFu33_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu15ll(Test_Sf_BFu33_BFu15ll, "Sf_BFu33_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu15s  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu33_BFu15s) C1{ FC2{} FL:33 Fs:15}



static void Test_Sf_BFu33_BFu15s()
{
  {
    init_simple_test("Sf_BFu33_BFu15s");
    static Sf_BFu33_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Sf_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Sf_BFu33_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu15s(Test_Sf_BFu33_BFu15s, "Sf_BFu33_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu16i  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu33_BFu16i) C1{ FC2{} FL:33 Fi:16}



static void Test_Sf_BFu33_BFu16i()
{
  {
    init_simple_test("Sf_BFu33_BFu16i");
    static Sf_BFu33_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "Sf_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "Sf_BFu33_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu16i(Test_Sf_BFu33_BFu16i, "Sf_BFu33_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu16ll  {
  ::empty v1;
  __tsu64 v2:33;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu33_BFu16ll) C1{ FC2{} FL:33 FL:16}



static void Test_Sf_BFu33_BFu16ll()
{
  {
    init_simple_test("Sf_BFu33_BFu16ll");
    static Sf_BFu33_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "Sf_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "Sf_BFu33_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu16ll(Test_Sf_BFu33_BFu16ll, "Sf_BFu33_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu16s  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu33_BFu16s) C1{ FC2{} FL:33 Fs:16}



static void Test_Sf_BFu33_BFu16s()
{
  {
    init_simple_test("Sf_BFu33_BFu16s");
    static Sf_BFu33_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Sf_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Sf_BFu33_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu16s(Test_Sf_BFu33_BFu16s, "Sf_BFu33_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu17i  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu33_BFu17i) C1{ FC2{} FL:33 Fi:17}



static void Test_Sf_BFu33_BFu17i()
{
  {
    init_simple_test("Sf_BFu33_BFu17i");
    static Sf_BFu33_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "Sf_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "Sf_BFu33_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu17i(Test_Sf_BFu33_BFu17i, "Sf_BFu33_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu17ll  {
  ::empty v1;
  __tsu64 v2:33;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu33_BFu17ll) C1{ FC2{} FL:33 FL:17}



static void Test_Sf_BFu33_BFu17ll()
{
  {
    init_simple_test("Sf_BFu33_BFu17ll");
    static Sf_BFu33_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "Sf_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "Sf_BFu33_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu17ll(Test_Sf_BFu33_BFu17ll, "Sf_BFu33_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu1c  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu33_BFu1c) C1{ FC2{} FL:33 Fc:1}



static void Test_Sf_BFu33_BFu1c()
{
  {
    init_simple_test("Sf_BFu33_BFu1c");
    static Sf_BFu33_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "Sf_BFu33_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu1c(Test_Sf_BFu33_BFu1c, "Sf_BFu33_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu1i  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu33_BFu1i) C1{ FC2{} FL:33 Fi:1}



static void Test_Sf_BFu33_BFu1i()
{
  {
    init_simple_test("Sf_BFu33_BFu1i");
    static Sf_BFu33_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "Sf_BFu33_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu1i(Test_Sf_BFu33_BFu1i, "Sf_BFu33_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu1ll  {
  ::empty v1;
  __tsu64 v2:33;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu33_BFu1ll) C1{ FC2{} FL:33 FL:1}



static void Test_Sf_BFu33_BFu1ll()
{
  {
    init_simple_test("Sf_BFu33_BFu1ll");
    static Sf_BFu33_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "Sf_BFu33_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu1ll(Test_Sf_BFu33_BFu1ll, "Sf_BFu33_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu1s  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu33_BFu1s) C1{ FC2{} FL:33 Fs:1}



static void Test_Sf_BFu33_BFu1s()
{
  {
    init_simple_test("Sf_BFu33_BFu1s");
    static Sf_BFu33_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "Sf_BFu33_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu1s(Test_Sf_BFu33_BFu1s, "Sf_BFu33_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu31i  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu33_BFu31i) C1{ FC2{} FL:33 Fi:31}



static void Test_Sf_BFu33_BFu31i()
{
  {
    init_simple_test("Sf_BFu33_BFu31i");
    static Sf_BFu33_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu33_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Sf_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Sf_BFu33_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu31i(Test_Sf_BFu33_BFu31i, "Sf_BFu33_BFu31i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu31ll  {
  ::empty v1;
  __tsu64 v2:33;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu33_BFu31ll) C1{ FC2{} FL:33 FL:31}



static void Test_Sf_BFu33_BFu31ll()
{
  {
    init_simple_test("Sf_BFu33_BFu31ll");
    static Sf_BFu33_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu33_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 31, 1, "Sf_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 31, hide_ull(1LL<<30), "Sf_BFu33_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu31ll(Test_Sf_BFu33_BFu31ll, "Sf_BFu33_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu32i  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu33_BFu32i) C1{ FC2{} FL:33 Fi:32}



static void Test_Sf_BFu33_BFu32i()
{
  {
    init_simple_test("Sf_BFu33_BFu32i");
    static Sf_BFu33_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu33_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Sf_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Sf_BFu33_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu32i(Test_Sf_BFu33_BFu32i, "Sf_BFu33_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu32ll  {
  ::empty v1;
  __tsu64 v2:33;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu33_BFu32ll) C1{ FC2{} FL:33 FL:32}



static void Test_Sf_BFu33_BFu32ll()
{
  {
    init_simple_test("Sf_BFu33_BFu32ll");
    static Sf_BFu33_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu33_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 32, 1, "Sf_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 32, hide_ull(1LL<<31), "Sf_BFu33_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu32ll(Test_Sf_BFu33_BFu32ll, "Sf_BFu33_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu33  {
  ::empty v1;
  __tsu64 v2:33;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu33_BFu33) C1{ FC2{} FL:33 FL:33}



static void Test_Sf_BFu33_BFu33()
{
  {
    init_simple_test("Sf_BFu33_BFu33");
    static Sf_BFu33_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu33_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 33, 1, "Sf_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,1), 33, hide_ull(1LL<<32), "Sf_BFu33_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu33(Test_Sf_BFu33_BFu33, "Sf_BFu33_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu7c  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu33_BFu7c) C1{ FC2{} FL:33 Fc:7}



static void Test_Sf_BFu33_BFu7c()
{
  {
    init_simple_test("Sf_BFu33_BFu7c");
    static Sf_BFu33_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "Sf_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "Sf_BFu33_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu7c(Test_Sf_BFu33_BFu7c, "Sf_BFu33_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu7i  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu33_BFu7i) C1{ FC2{} FL:33 Fi:7}



static void Test_Sf_BFu33_BFu7i()
{
  {
    init_simple_test("Sf_BFu33_BFu7i");
    static Sf_BFu33_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "Sf_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "Sf_BFu33_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu7i(Test_Sf_BFu33_BFu7i, "Sf_BFu33_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu7ll  {
  ::empty v1;
  __tsu64 v2:33;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu33_BFu7ll) C1{ FC2{} FL:33 FL:7}



static void Test_Sf_BFu33_BFu7ll()
{
  {
    init_simple_test("Sf_BFu33_BFu7ll");
    static Sf_BFu33_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "Sf_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "Sf_BFu33_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu7ll(Test_Sf_BFu33_BFu7ll, "Sf_BFu33_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu7s  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu33_BFu7s) C1{ FC2{} FL:33 Fs:7}



static void Test_Sf_BFu33_BFu7s()
{
  {
    init_simple_test("Sf_BFu33_BFu7s");
    static Sf_BFu33_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "Sf_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "Sf_BFu33_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu7s(Test_Sf_BFu33_BFu7s, "Sf_BFu33_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu8c  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu33_BFu8c) C1{ FC2{} FL:33 Fc:8}



static void Test_Sf_BFu33_BFu8c()
{
  {
    init_simple_test("Sf_BFu33_BFu8c");
    static Sf_BFu33_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Sf_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Sf_BFu33_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu8c(Test_Sf_BFu33_BFu8c, "Sf_BFu33_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu8i  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu33_BFu8i) C1{ FC2{} FL:33 Fi:8}



static void Test_Sf_BFu33_BFu8i()
{
  {
    init_simple_test("Sf_BFu33_BFu8i");
    static Sf_BFu33_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "Sf_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "Sf_BFu33_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu8i(Test_Sf_BFu33_BFu8i, "Sf_BFu33_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu8ll  {
  ::empty v1;
  __tsu64 v2:33;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu33_BFu8ll) C1{ FC2{} FL:33 FL:8}



static void Test_Sf_BFu33_BFu8ll()
{
  {
    init_simple_test("Sf_BFu33_BFu8ll");
    static Sf_BFu33_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "Sf_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "Sf_BFu33_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu8ll(Test_Sf_BFu33_BFu8ll, "Sf_BFu33_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu8s  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu33_BFu8s) C1{ FC2{} FL:33 Fs:8}



static void Test_Sf_BFu33_BFu8s()
{
  {
    init_simple_test("Sf_BFu33_BFu8s");
    static Sf_BFu33_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Sf_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Sf_BFu33_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu8s(Test_Sf_BFu33_BFu8s, "Sf_BFu33_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu9i  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu33_BFu9i) C1{ FC2{} FL:33 Fi:9}



static void Test_Sf_BFu33_BFu9i()
{
  {
    init_simple_test("Sf_BFu33_BFu9i");
    static Sf_BFu33_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "Sf_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "Sf_BFu33_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu9i(Test_Sf_BFu33_BFu9i, "Sf_BFu33_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu9ll  {
  ::empty v1;
  __tsu64 v2:33;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu33_BFu9ll) C1{ FC2{} FL:33 FL:9}



static void Test_Sf_BFu33_BFu9ll()
{
  {
    init_simple_test("Sf_BFu33_BFu9ll");
    static Sf_BFu33_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "Sf_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "Sf_BFu33_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu9ll(Test_Sf_BFu33_BFu9ll, "Sf_BFu33_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_BFu9s  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu33_BFu9s) C1{ FC2{} FL:33 Fs:9}



static void Test_Sf_BFu33_BFu9s()
{
  {
    init_simple_test("Sf_BFu33_BFu9s");
    static Sf_BFu33_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Sf_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Sf_BFu33_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu33_BFu9s(Test_Sf_BFu33_BFu9s, "Sf_BFu33_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_C  {
  ::empty v1;
  __tsu64 v2:33;
  char v3;
};
//SIG(1 Sf_BFu33_C) C1{ FC2{} FL:33 Fc}



static void Test_Sf_BFu33_C()
{
  {
    init_simple_test("Sf_BFu33_C");
    static Sf_BFu33_C lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_C");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_C");
    check_field_offset(lv, v3, 6, "Sf_BFu33_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu33_C(Test_Sf_BFu33_C, "Sf_BFu33_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_D  {
  ::empty v1;
  __tsu64 v2:33;
  double v3;
};
//SIG(1 Sf_BFu33_D) C1{ FC2{} FL:33 FL}



static void Test_Sf_BFu33_D()
{
  {
    init_simple_test("Sf_BFu33_D");
    static Sf_BFu33_D lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu33_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_D");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_D");
    check_field_offset(lv, v3, 8, "Sf_BFu33_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu33_D(Test_Sf_BFu33_D, "Sf_BFu33_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_F  {
  ::empty v1;
  __tsu64 v2:33;
  float v3;
};
//SIG(1 Sf_BFu33_F) C1{ FC2{} FL:33 Fi}



static void Test_Sf_BFu33_F()
{
  {
    init_simple_test("Sf_BFu33_F");
    static Sf_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu33_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_F");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_F");
    check_field_offset(lv, v3, 8, "Sf_BFu33_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu33_F(Test_Sf_BFu33_F, "Sf_BFu33_F", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_I  {
  ::empty v1;
  __tsu64 v2:33;
  int v3;
};
//SIG(1 Sf_BFu33_I) C1{ FC2{} FL:33 Fi}



static void Test_Sf_BFu33_I()
{
  {
    init_simple_test("Sf_BFu33_I");
    static Sf_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu33_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_I");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_I");
    check_field_offset(lv, v3, 8, "Sf_BFu33_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu33_I(Test_Sf_BFu33_I, "Sf_BFu33_I", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_Ip  {
  ::empty v1;
  __tsu64 v2:33;
  int *v3;
};
//SIG(1 Sf_BFu33_Ip) C1{ FC2{} FL:33 Fp}



static void Test_Sf_BFu33_Ip()
{
  {
    init_simple_test("Sf_BFu33_Ip");
    static Sf_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu33_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_Ip");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_Ip");
    check_field_offset(lv, v3, 8, "Sf_BFu33_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu33_Ip(Test_Sf_BFu33_Ip, "Sf_BFu33_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_L  {
  ::empty v1;
  __tsu64 v2:33;
  __tsi64 v3;
};
//SIG(1 Sf_BFu33_L) C1{ FC2{} FL:33 FL}



static void Test_Sf_BFu33_L()
{
  {
    init_simple_test("Sf_BFu33_L");
    static Sf_BFu33_L lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu33_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_L");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_L");
    check_field_offset(lv, v3, 8, "Sf_BFu33_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu33_L(Test_Sf_BFu33_L, "Sf_BFu33_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_S  {
  ::empty v1;
  __tsu64 v2:33;
  short v3;
};
//SIG(1 Sf_BFu33_S) C1{ FC2{} FL:33 Fs}



static void Test_Sf_BFu33_S()
{
  {
    init_simple_test("Sf_BFu33_S");
    static Sf_BFu33_S lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_S");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_S");
    check_field_offset(lv, v3, 6, "Sf_BFu33_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu33_S(Test_Sf_BFu33_S, "Sf_BFu33_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_Sf  {
  ::empty v1;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 Sf_BFu33_Sf) C1{ FC2{} FL:33 FC2}



static void Test_Sf_BFu33_Sf()
{
  {
    init_simple_test("Sf_BFu33_Sf");
    static Sf_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_Sf");
    check_field_offset(lv, v3, 6, "Sf_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu33_Sf(Test_Sf_BFu33_Sf, "Sf_BFu33_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_Uc  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned char v3;
};
//SIG(1 Sf_BFu33_Uc) C1{ FC2{} FL:33 Fc}



static void Test_Sf_BFu33_Uc()
{
  {
    init_simple_test("Sf_BFu33_Uc");
    static Sf_BFu33_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_Uc");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_Uc");
    check_field_offset(lv, v3, 6, "Sf_BFu33_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu33_Uc(Test_Sf_BFu33_Uc, "Sf_BFu33_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_Ui  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned int v3;
};
//SIG(1 Sf_BFu33_Ui) C1{ FC2{} FL:33 Fi}



static void Test_Sf_BFu33_Ui()
{
  {
    init_simple_test("Sf_BFu33_Ui");
    static Sf_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu33_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_Ui");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_Ui");
    check_field_offset(lv, v3, 8, "Sf_BFu33_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu33_Ui(Test_Sf_BFu33_Ui, "Sf_BFu33_Ui", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_Ul  {
  ::empty v1;
  __tsu64 v2:33;
  __tsu64 v3;
};
//SIG(1 Sf_BFu33_Ul) C1{ FC2{} FL:33 FL}



static void Test_Sf_BFu33_Ul()
{
  {
    init_simple_test("Sf_BFu33_Ul");
    static Sf_BFu33_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Sf_BFu33_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_Ul");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_Ul");
    check_field_offset(lv, v3, 8, "Sf_BFu33_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu33_Ul(Test_Sf_BFu33_Ul, "Sf_BFu33_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_Us  {
  ::empty v1;
  __tsu64 v2:33;
  unsigned short v3;
};
//SIG(1 Sf_BFu33_Us) C1{ FC2{} FL:33 Fs}



static void Test_Sf_BFu33_Us()
{
  {
    init_simple_test("Sf_BFu33_Us");
    static Sf_BFu33_Us lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu33_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_Us");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_Us");
    check_field_offset(lv, v3, 6, "Sf_BFu33_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu33_Us(Test_Sf_BFu33_Us, "Sf_BFu33_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu33_Vp  {
  ::empty v1;
  __tsu64 v2:33;
  void *v3;
};
//SIG(1 Sf_BFu33_Vp) C1{ FC2{} FL:33 Fp}



static void Test_Sf_BFu33_Vp()
{
  {
    init_simple_test("Sf_BFu33_Vp");
    static Sf_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu33_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "Sf_BFu33_Vp");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "Sf_BFu33_Vp");
    check_field_offset(lv, v3, 8, "Sf_BFu33_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu33_Vp(Test_Sf_BFu33_Vp, "Sf_BFu33_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c  {
  ::empty v1;
  unsigned char v2:7;
};
//SIG(1 Sf_BFu7c) C1{ FC2{} Fc:7}



static void Test_Sf_BFu7c()
{
  {
    init_simple_test("Sf_BFu7c");
    static Sf_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu7c(Test_Sf_BFu7c, "Sf_BFu7c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu15i  {
  ::empty v1;
  unsigned char v2:7;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu7c_BFu15i) C1{ FC2{} Fc:7 Fi:15}



static void Test_Sf_BFu7c_BFu15i()
{
  {
    init_simple_test("Sf_BFu7c_BFu15i");
    static Sf_BFu7c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Sf_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Sf_BFu7c_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu15i(Test_Sf_BFu7c_BFu15i, "Sf_BFu7c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu15ll  {
  ::empty v1;
  unsigned char v2:7;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu7c_BFu15ll) C1{ FC2{} Fc:7 FL:15}



static void Test_Sf_BFu7c_BFu15ll()
{
  {
    init_simple_test("Sf_BFu7c_BFu15ll");
    static Sf_BFu7c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Sf_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Sf_BFu7c_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu15ll(Test_Sf_BFu7c_BFu15ll, "Sf_BFu7c_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu15s  {
  ::empty v1;
  unsigned char v2:7;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu7c_BFu15s) C1{ FC2{} Fc:7 Fs:15}



static void Test_Sf_BFu7c_BFu15s()
{
  {
    init_simple_test("Sf_BFu7c_BFu15s");
    static Sf_BFu7c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu7c_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu15s(Test_Sf_BFu7c_BFu15s, "Sf_BFu7c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu16i  {
  ::empty v1;
  unsigned char v2:7;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu7c_BFu16i) C1{ FC2{} Fc:7 Fi:16}



static void Test_Sf_BFu7c_BFu16i()
{
  {
    init_simple_test("Sf_BFu7c_BFu16i");
    static Sf_BFu7c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Sf_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Sf_BFu7c_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu16i(Test_Sf_BFu7c_BFu16i, "Sf_BFu7c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu16ll  {
  ::empty v1;
  unsigned char v2:7;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu7c_BFu16ll) C1{ FC2{} Fc:7 FL:16}



static void Test_Sf_BFu7c_BFu16ll()
{
  {
    init_simple_test("Sf_BFu7c_BFu16ll");
    static Sf_BFu7c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Sf_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Sf_BFu7c_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu16ll(Test_Sf_BFu7c_BFu16ll, "Sf_BFu7c_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu16s  {
  ::empty v1;
  unsigned char v2:7;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu7c_BFu16s) C1{ FC2{} Fc:7 Fs:16}



static void Test_Sf_BFu7c_BFu16s()
{
  {
    init_simple_test("Sf_BFu7c_BFu16s");
    static Sf_BFu7c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu7c_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu16s(Test_Sf_BFu7c_BFu16s, "Sf_BFu7c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu17i  {
  ::empty v1;
  unsigned char v2:7;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu7c_BFu17i) C1{ FC2{} Fc:7 Fi:17}



static void Test_Sf_BFu7c_BFu17i()
{
  {
    init_simple_test("Sf_BFu7c_BFu17i");
    static Sf_BFu7c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Sf_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Sf_BFu7c_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu17i(Test_Sf_BFu7c_BFu17i, "Sf_BFu7c_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu17ll  {
  ::empty v1;
  unsigned char v2:7;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu7c_BFu17ll) C1{ FC2{} Fc:7 FL:17}



static void Test_Sf_BFu7c_BFu17ll()
{
  {
    init_simple_test("Sf_BFu7c_BFu17ll");
    static Sf_BFu7c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Sf_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Sf_BFu7c_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu17ll(Test_Sf_BFu7c_BFu17ll, "Sf_BFu7c_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu1c  {
  ::empty v1;
  unsigned char v2:7;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu7c_BFu1c) C1{ FC2{} Fc:7 Fc:1}



static void Test_Sf_BFu7c_BFu1c()
{
  {
    init_simple_test("Sf_BFu7c_BFu1c");
    static Sf_BFu7c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7c_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu1c(Test_Sf_BFu7c_BFu1c, "Sf_BFu7c_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu1i  {
  ::empty v1;
  unsigned char v2:7;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu7c_BFu1i) C1{ FC2{} Fc:7 Fi:1}



static void Test_Sf_BFu7c_BFu1i()
{
  {
    init_simple_test("Sf_BFu7c_BFu1i");
    static Sf_BFu7c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7c_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu1i(Test_Sf_BFu7c_BFu1i, "Sf_BFu7c_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu1ll  {
  ::empty v1;
  unsigned char v2:7;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu7c_BFu1ll) C1{ FC2{} Fc:7 FL:1}



static void Test_Sf_BFu7c_BFu1ll()
{
  {
    init_simple_test("Sf_BFu7c_BFu1ll");
    static Sf_BFu7c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7c_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu1ll(Test_Sf_BFu7c_BFu1ll, "Sf_BFu7c_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu1s  {
  ::empty v1;
  unsigned char v2:7;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu7c_BFu1s) C1{ FC2{} Fc:7 Fs:1}



static void Test_Sf_BFu7c_BFu1s()
{
  {
    init_simple_test("Sf_BFu7c_BFu1s");
    static Sf_BFu7c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu7c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7c_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu1s(Test_Sf_BFu7c_BFu1s, "Sf_BFu7c_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu31i  {
  ::empty v1;
  unsigned char v2:7;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu7c_BFu31i) C1{ FC2{} Fc:7 Fi:31}



static void Test_Sf_BFu7c_BFu31i()
{
  {
    init_simple_test("Sf_BFu7c_BFu31i");
    static Sf_BFu7c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu7c_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu31i(Test_Sf_BFu7c_BFu31i, "Sf_BFu7c_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu31ll  {
  ::empty v1;
  unsigned char v2:7;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu7c_BFu31ll) C1{ FC2{} Fc:7 FL:31}



static void Test_Sf_BFu7c_BFu31ll()
{
  {
    init_simple_test("Sf_BFu7c_BFu31ll");
    static Sf_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "Sf_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "Sf_BFu7c_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu31ll(Test_Sf_BFu7c_BFu31ll, "Sf_BFu7c_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu32i  {
  ::empty v1;
  unsigned char v2:7;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu7c_BFu32i) C1{ FC2{} Fc:7 Fi:32}



static void Test_Sf_BFu7c_BFu32i()
{
  {
    init_simple_test("Sf_BFu7c_BFu32i");
    static Sf_BFu7c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu7c_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu32i(Test_Sf_BFu7c_BFu32i, "Sf_BFu7c_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu32ll  {
  ::empty v1;
  unsigned char v2:7;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu7c_BFu32ll) C1{ FC2{} Fc:7 FL:32}



static void Test_Sf_BFu7c_BFu32ll()
{
  {
    init_simple_test("Sf_BFu7c_BFu32ll");
    static Sf_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "Sf_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "Sf_BFu7c_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu32ll(Test_Sf_BFu7c_BFu32ll, "Sf_BFu7c_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu33  {
  ::empty v1;
  unsigned char v2:7;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu7c_BFu33) C1{ FC2{} Fc:7 FL:33}



static void Test_Sf_BFu7c_BFu33()
{
  {
    init_simple_test("Sf_BFu7c_BFu33");
    static Sf_BFu7c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "Sf_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "Sf_BFu7c_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu33(Test_Sf_BFu7c_BFu33, "Sf_BFu7c_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu7c  {
  ::empty v1;
  unsigned char v2:7;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu7c_BFu7c) C1{ FC2{} Fc:7 Fc:7}



static void Test_Sf_BFu7c_BFu7c()
{
  {
    init_simple_test("Sf_BFu7c_BFu7c");
    static Sf_BFu7c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu7c(Test_Sf_BFu7c_BFu7c, "Sf_BFu7c_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu7i  {
  ::empty v1;
  unsigned char v2:7;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu7c_BFu7i) C1{ FC2{} Fc:7 Fi:7}



static void Test_Sf_BFu7c_BFu7i()
{
  {
    init_simple_test("Sf_BFu7c_BFu7i");
    static Sf_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Sf_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu7i(Test_Sf_BFu7c_BFu7i, "Sf_BFu7c_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu7ll  {
  ::empty v1;
  unsigned char v2:7;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu7c_BFu7ll) C1{ FC2{} Fc:7 FL:7}



static void Test_Sf_BFu7c_BFu7ll()
{
  {
    init_simple_test("Sf_BFu7c_BFu7ll");
    static Sf_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Sf_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu7ll(Test_Sf_BFu7c_BFu7ll, "Sf_BFu7c_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu7s  {
  ::empty v1;
  unsigned char v2:7;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu7c_BFu7s) C1{ FC2{} Fc:7 Fs:7}



static void Test_Sf_BFu7c_BFu7s()
{
  {
    init_simple_test("Sf_BFu7c_BFu7s");
    static Sf_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu7s(Test_Sf_BFu7c_BFu7s, "Sf_BFu7c_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu8c  {
  ::empty v1;
  unsigned char v2:7;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu7c_BFu8c) C1{ FC2{} Fc:7 Fc:8}



static void Test_Sf_BFu7c_BFu8c()
{
  {
    init_simple_test("Sf_BFu7c_BFu8c");
    static Sf_BFu7c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu7c_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu8c(Test_Sf_BFu7c_BFu8c, "Sf_BFu7c_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu8i  {
  ::empty v1;
  unsigned char v2:7;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu7c_BFu8i) C1{ FC2{} Fc:7 Fi:8}



static void Test_Sf_BFu7c_BFu8i()
{
  {
    init_simple_test("Sf_BFu7c_BFu8i");
    static Sf_BFu7c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Sf_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Sf_BFu7c_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu8i(Test_Sf_BFu7c_BFu8i, "Sf_BFu7c_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu8ll  {
  ::empty v1;
  unsigned char v2:7;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu7c_BFu8ll) C1{ FC2{} Fc:7 FL:8}



static void Test_Sf_BFu7c_BFu8ll()
{
  {
    init_simple_test("Sf_BFu7c_BFu8ll");
    static Sf_BFu7c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Sf_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Sf_BFu7c_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu8ll(Test_Sf_BFu7c_BFu8ll, "Sf_BFu7c_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu8s  {
  ::empty v1;
  unsigned char v2:7;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu7c_BFu8s) C1{ FC2{} Fc:7 Fs:8}



static void Test_Sf_BFu7c_BFu8s()
{
  {
    init_simple_test("Sf_BFu7c_BFu8s");
    static Sf_BFu7c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu7c_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu8s(Test_Sf_BFu7c_BFu8s, "Sf_BFu7c_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu9i  {
  ::empty v1;
  unsigned char v2:7;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu7c_BFu9i) C1{ FC2{} Fc:7 Fi:9}



static void Test_Sf_BFu7c_BFu9i()
{
  {
    init_simple_test("Sf_BFu7c_BFu9i");
    static Sf_BFu7c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Sf_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Sf_BFu7c_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu9i(Test_Sf_BFu7c_BFu9i, "Sf_BFu7c_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu9ll  {
  ::empty v1;
  unsigned char v2:7;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu7c_BFu9ll) C1{ FC2{} Fc:7 FL:9}



static void Test_Sf_BFu7c_BFu9ll()
{
  {
    init_simple_test("Sf_BFu7c_BFu9ll");
    static Sf_BFu7c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Sf_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Sf_BFu7c_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu9ll(Test_Sf_BFu7c_BFu9ll, "Sf_BFu7c_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_BFu9s  {
  ::empty v1;
  unsigned char v2:7;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu7c_BFu9s) C1{ FC2{} Fc:7 Fs:9}



static void Test_Sf_BFu7c_BFu9s()
{
  {
    init_simple_test("Sf_BFu7c_BFu9s");
    static Sf_BFu7c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu7c_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_BFu9s(Test_Sf_BFu7c_BFu9s, "Sf_BFu7c_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_C  {
  ::empty v1;
  unsigned char v2:7;
  char v3;
};
//SIG(1 Sf_BFu7c_C) C1{ FC2{} Fc:7 Fc}



static void Test_Sf_BFu7c_C()
{
  {
    init_simple_test("Sf_BFu7c_C");
    static Sf_BFu7c_C lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu7c_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_C");
    check_field_offset(lv, v3, 2, "Sf_BFu7c_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_C(Test_Sf_BFu7c_C, "Sf_BFu7c_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_D  {
  ::empty v1;
  unsigned char v2:7;
  double v3;
};
//SIG(1 Sf_BFu7c_D) C1{ FC2{} Fc:7 FL}



static void Test_Sf_BFu7c_D()
{
  {
    init_simple_test("Sf_BFu7c_D");
    static Sf_BFu7c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu7c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7c_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_D(Test_Sf_BFu7c_D, "Sf_BFu7c_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_F  {
  ::empty v1;
  unsigned char v2:7;
  float v3;
};
//SIG(1 Sf_BFu7c_F) C1{ FC2{} Fc:7 Fi}



static void Test_Sf_BFu7c_F()
{
  {
    init_simple_test("Sf_BFu7c_F");
    static Sf_BFu7c_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7c_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7c_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_F");
    check_field_offset(lv, v3, 4, "Sf_BFu7c_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_F(Test_Sf_BFu7c_F, "Sf_BFu7c_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_I  {
  ::empty v1;
  unsigned char v2:7;
  int v3;
};
//SIG(1 Sf_BFu7c_I) C1{ FC2{} Fc:7 Fi}



static void Test_Sf_BFu7c_I()
{
  {
    init_simple_test("Sf_BFu7c_I");
    static Sf_BFu7c_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7c_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7c_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_I");
    check_field_offset(lv, v3, 4, "Sf_BFu7c_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_I(Test_Sf_BFu7c_I, "Sf_BFu7c_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_Ip  {
  ::empty v1;
  unsigned char v2:7;
  int *v3;
};
//SIG(1 Sf_BFu7c_Ip) C1{ FC2{} Fc:7 Fp}



static void Test_Sf_BFu7c_Ip()
{
  {
    init_simple_test("Sf_BFu7c_Ip");
    static Sf_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu7c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7c_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_Ip(Test_Sf_BFu7c_Ip, "Sf_BFu7c_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_L  {
  ::empty v1;
  unsigned char v2:7;
  __tsi64 v3;
};
//SIG(1 Sf_BFu7c_L) C1{ FC2{} Fc:7 FL}



static void Test_Sf_BFu7c_L()
{
  {
    init_simple_test("Sf_BFu7c_L");
    static Sf_BFu7c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu7c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7c_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_L(Test_Sf_BFu7c_L, "Sf_BFu7c_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_S  {
  ::empty v1;
  unsigned char v2:7;
  short v3;
};
//SIG(1 Sf_BFu7c_S) C1{ FC2{} Fc:7 Fs}



static void Test_Sf_BFu7c_S()
{
  {
    init_simple_test("Sf_BFu7c_S");
    static Sf_BFu7c_S lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7c_S)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7c_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_S");
    check_field_offset(lv, v3, 2, "Sf_BFu7c_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_S(Test_Sf_BFu7c_S, "Sf_BFu7c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_Sf  {
  ::empty v1;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 Sf_BFu7c_Sf) C1{ FC2{} Fc:7 FC2}



static void Test_Sf_BFu7c_Sf()
{
  {
    init_simple_test("Sf_BFu7c_Sf");
    static Sf_BFu7c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu7c_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_Sf");
    check_field_offset(lv, v3, 2, "Sf_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_Sf(Test_Sf_BFu7c_Sf, "Sf_BFu7c_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_Uc  {
  ::empty v1;
  unsigned char v2:7;
  unsigned char v3;
};
//SIG(1 Sf_BFu7c_Uc) C1{ FC2{} Fc:7 Fc}



static void Test_Sf_BFu7c_Uc()
{
  {
    init_simple_test("Sf_BFu7c_Uc");
    static Sf_BFu7c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_Uc");
    check_field_offset(lv, v3, 2, "Sf_BFu7c_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_Uc(Test_Sf_BFu7c_Uc, "Sf_BFu7c_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_Ui  {
  ::empty v1;
  unsigned char v2:7;
  unsigned int v3;
};
//SIG(1 Sf_BFu7c_Ui) C1{ FC2{} Fc:7 Fi}



static void Test_Sf_BFu7c_Ui()
{
  {
    init_simple_test("Sf_BFu7c_Ui");
    static Sf_BFu7c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu7c_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_Ui(Test_Sf_BFu7c_Ui, "Sf_BFu7c_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_Ul  {
  ::empty v1;
  unsigned char v2:7;
  __tsu64 v3;
};
//SIG(1 Sf_BFu7c_Ul) C1{ FC2{} Fc:7 FL}



static void Test_Sf_BFu7c_Ul()
{
  {
    init_simple_test("Sf_BFu7c_Ul");
    static Sf_BFu7c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu7c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7c_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_Ul(Test_Sf_BFu7c_Ul, "Sf_BFu7c_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_Us  {
  ::empty v1;
  unsigned char v2:7;
  unsigned short v3;
};
//SIG(1 Sf_BFu7c_Us) C1{ FC2{} Fc:7 Fs}



static void Test_Sf_BFu7c_Us()
{
  {
    init_simple_test("Sf_BFu7c_Us");
    static Sf_BFu7c_Us lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_Us");
    check_field_offset(lv, v3, 2, "Sf_BFu7c_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_Us(Test_Sf_BFu7c_Us, "Sf_BFu7c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7c_Vp  {
  ::empty v1;
  unsigned char v2:7;
  void *v3;
};
//SIG(1 Sf_BFu7c_Vp) C1{ FC2{} Fc:7 Fp}



static void Test_Sf_BFu7c_Vp()
{
  {
    init_simple_test("Sf_BFu7c_Vp");
    static Sf_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu7c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7c_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7c_Vp(Test_Sf_BFu7c_Vp, "Sf_BFu7c_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i  {
  ::empty v1;
  unsigned int v2:7;
};
//SIG(1 Sf_BFu7i) C1{ FC2{} Fi:7}



static void Test_Sf_BFu7i()
{
  {
    init_simple_test("Sf_BFu7i");
    static Sf_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu7i(Test_Sf_BFu7i, "Sf_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu15i  {
  ::empty v1;
  unsigned int v2:7;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu7i_BFu15i) C1{ FC2{} Fi:7 Fi:15}



static void Test_Sf_BFu7i_BFu15i()
{
  {
    init_simple_test("Sf_BFu7i_BFu15i");
    static Sf_BFu7i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Sf_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Sf_BFu7i_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu15i(Test_Sf_BFu7i_BFu15i, "Sf_BFu7i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu15ll  {
  ::empty v1;
  unsigned int v2:7;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu7i_BFu15ll) C1{ FC2{} Fi:7 FL:15}



static void Test_Sf_BFu7i_BFu15ll()
{
  {
    init_simple_test("Sf_BFu7i_BFu15ll");
    static Sf_BFu7i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Sf_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Sf_BFu7i_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu15ll(Test_Sf_BFu7i_BFu15ll, "Sf_BFu7i_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu15s  {
  ::empty v1;
  unsigned int v2:7;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu7i_BFu15s) C1{ FC2{} Fi:7 Fs:15}



static void Test_Sf_BFu7i_BFu15s()
{
  {
    init_simple_test("Sf_BFu7i_BFu15s");
    static Sf_BFu7i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu7i_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu15s(Test_Sf_BFu7i_BFu15s, "Sf_BFu7i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu16i  {
  ::empty v1;
  unsigned int v2:7;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu7i_BFu16i) C1{ FC2{} Fi:7 Fi:16}



static void Test_Sf_BFu7i_BFu16i()
{
  {
    init_simple_test("Sf_BFu7i_BFu16i");
    static Sf_BFu7i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Sf_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Sf_BFu7i_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu16i(Test_Sf_BFu7i_BFu16i, "Sf_BFu7i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu16ll  {
  ::empty v1;
  unsigned int v2:7;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu7i_BFu16ll) C1{ FC2{} Fi:7 FL:16}



static void Test_Sf_BFu7i_BFu16ll()
{
  {
    init_simple_test("Sf_BFu7i_BFu16ll");
    static Sf_BFu7i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Sf_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Sf_BFu7i_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu16ll(Test_Sf_BFu7i_BFu16ll, "Sf_BFu7i_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu16s  {
  ::empty v1;
  unsigned int v2:7;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu7i_BFu16s) C1{ FC2{} Fi:7 Fs:16}



static void Test_Sf_BFu7i_BFu16s()
{
  {
    init_simple_test("Sf_BFu7i_BFu16s");
    static Sf_BFu7i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu7i_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu16s(Test_Sf_BFu7i_BFu16s, "Sf_BFu7i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu17i  {
  ::empty v1;
  unsigned int v2:7;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu7i_BFu17i) C1{ FC2{} Fi:7 Fi:17}



static void Test_Sf_BFu7i_BFu17i()
{
  {
    init_simple_test("Sf_BFu7i_BFu17i");
    static Sf_BFu7i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Sf_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Sf_BFu7i_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu17i(Test_Sf_BFu7i_BFu17i, "Sf_BFu7i_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu17ll  {
  ::empty v1;
  unsigned int v2:7;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu7i_BFu17ll) C1{ FC2{} Fi:7 FL:17}



static void Test_Sf_BFu7i_BFu17ll()
{
  {
    init_simple_test("Sf_BFu7i_BFu17ll");
    static Sf_BFu7i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Sf_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Sf_BFu7i_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu17ll(Test_Sf_BFu7i_BFu17ll, "Sf_BFu7i_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu1c  {
  ::empty v1;
  unsigned int v2:7;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu7i_BFu1c) C1{ FC2{} Fi:7 Fc:1}



static void Test_Sf_BFu7i_BFu1c()
{
  {
    init_simple_test("Sf_BFu7i_BFu1c");
    static Sf_BFu7i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7i_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu1c(Test_Sf_BFu7i_BFu1c, "Sf_BFu7i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu1i  {
  ::empty v1;
  unsigned int v2:7;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu7i_BFu1i) C1{ FC2{} Fi:7 Fi:1}



static void Test_Sf_BFu7i_BFu1i()
{
  {
    init_simple_test("Sf_BFu7i_BFu1i");
    static Sf_BFu7i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7i_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu1i(Test_Sf_BFu7i_BFu1i, "Sf_BFu7i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu1ll  {
  ::empty v1;
  unsigned int v2:7;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu7i_BFu1ll) C1{ FC2{} Fi:7 FL:1}



static void Test_Sf_BFu7i_BFu1ll()
{
  {
    init_simple_test("Sf_BFu7i_BFu1ll");
    static Sf_BFu7i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7i_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu1ll(Test_Sf_BFu7i_BFu1ll, "Sf_BFu7i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu1s  {
  ::empty v1;
  unsigned int v2:7;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu7i_BFu1s) C1{ FC2{} Fi:7 Fs:1}



static void Test_Sf_BFu7i_BFu1s()
{
  {
    init_simple_test("Sf_BFu7i_BFu1s");
    static Sf_BFu7i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7i_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu1s(Test_Sf_BFu7i_BFu1s, "Sf_BFu7i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu31i  {
  ::empty v1;
  unsigned int v2:7;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu7i_BFu31i) C1{ FC2{} Fi:7 Fi:31}



static void Test_Sf_BFu7i_BFu31i()
{
  {
    init_simple_test("Sf_BFu7i_BFu31i");
    static Sf_BFu7i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu7i_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu31i(Test_Sf_BFu7i_BFu31i, "Sf_BFu7i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu31ll  {
  ::empty v1;
  unsigned int v2:7;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu7i_BFu31ll) C1{ FC2{} Fi:7 FL:31}



static void Test_Sf_BFu7i_BFu31ll()
{
  {
    init_simple_test("Sf_BFu7i_BFu31ll");
    static Sf_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "Sf_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "Sf_BFu7i_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu31ll(Test_Sf_BFu7i_BFu31ll, "Sf_BFu7i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu32i  {
  ::empty v1;
  unsigned int v2:7;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu7i_BFu32i) C1{ FC2{} Fi:7 Fi:32}



static void Test_Sf_BFu7i_BFu32i()
{
  {
    init_simple_test("Sf_BFu7i_BFu32i");
    static Sf_BFu7i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu7i_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu32i(Test_Sf_BFu7i_BFu32i, "Sf_BFu7i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu32ll  {
  ::empty v1;
  unsigned int v2:7;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu7i_BFu32ll) C1{ FC2{} Fi:7 FL:32}



static void Test_Sf_BFu7i_BFu32ll()
{
  {
    init_simple_test("Sf_BFu7i_BFu32ll");
    static Sf_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "Sf_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "Sf_BFu7i_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu32ll(Test_Sf_BFu7i_BFu32ll, "Sf_BFu7i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu33  {
  ::empty v1;
  unsigned int v2:7;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu7i_BFu33) C1{ FC2{} Fi:7 FL:33}



static void Test_Sf_BFu7i_BFu33()
{
  {
    init_simple_test("Sf_BFu7i_BFu33");
    static Sf_BFu7i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "Sf_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "Sf_BFu7i_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu33(Test_Sf_BFu7i_BFu33, "Sf_BFu7i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu7c  {
  ::empty v1;
  unsigned int v2:7;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu7i_BFu7c) C1{ FC2{} Fi:7 Fc:7}



static void Test_Sf_BFu7i_BFu7c()
{
  {
    init_simple_test("Sf_BFu7i_BFu7c");
    static Sf_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu7c(Test_Sf_BFu7i_BFu7c, "Sf_BFu7i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu7i  {
  ::empty v1;
  unsigned int v2:7;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu7i_BFu7i) C1{ FC2{} Fi:7 Fi:7}



static void Test_Sf_BFu7i_BFu7i()
{
  {
    init_simple_test("Sf_BFu7i_BFu7i");
    static Sf_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Sf_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu7i(Test_Sf_BFu7i_BFu7i, "Sf_BFu7i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu7ll  {
  ::empty v1;
  unsigned int v2:7;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu7i_BFu7ll) C1{ FC2{} Fi:7 FL:7}



static void Test_Sf_BFu7i_BFu7ll()
{
  {
    init_simple_test("Sf_BFu7i_BFu7ll");
    static Sf_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Sf_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu7ll(Test_Sf_BFu7i_BFu7ll, "Sf_BFu7i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu7s  {
  ::empty v1;
  unsigned int v2:7;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu7i_BFu7s) C1{ FC2{} Fi:7 Fs:7}



static void Test_Sf_BFu7i_BFu7s()
{
  {
    init_simple_test("Sf_BFu7i_BFu7s");
    static Sf_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu7s(Test_Sf_BFu7i_BFu7s, "Sf_BFu7i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu8c  {
  ::empty v1;
  unsigned int v2:7;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu7i_BFu8c) C1{ FC2{} Fi:7 Fc:8}



static void Test_Sf_BFu7i_BFu8c()
{
  {
    init_simple_test("Sf_BFu7i_BFu8c");
    static Sf_BFu7i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu7i_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu8c(Test_Sf_BFu7i_BFu8c, "Sf_BFu7i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu8i  {
  ::empty v1;
  unsigned int v2:7;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu7i_BFu8i) C1{ FC2{} Fi:7 Fi:8}



static void Test_Sf_BFu7i_BFu8i()
{
  {
    init_simple_test("Sf_BFu7i_BFu8i");
    static Sf_BFu7i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Sf_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Sf_BFu7i_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu8i(Test_Sf_BFu7i_BFu8i, "Sf_BFu7i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu8ll  {
  ::empty v1;
  unsigned int v2:7;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu7i_BFu8ll) C1{ FC2{} Fi:7 FL:8}



static void Test_Sf_BFu7i_BFu8ll()
{
  {
    init_simple_test("Sf_BFu7i_BFu8ll");
    static Sf_BFu7i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Sf_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Sf_BFu7i_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu8ll(Test_Sf_BFu7i_BFu8ll, "Sf_BFu7i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu8s  {
  ::empty v1;
  unsigned int v2:7;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu7i_BFu8s) C1{ FC2{} Fi:7 Fs:8}



static void Test_Sf_BFu7i_BFu8s()
{
  {
    init_simple_test("Sf_BFu7i_BFu8s");
    static Sf_BFu7i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu7i_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu8s(Test_Sf_BFu7i_BFu8s, "Sf_BFu7i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu9i  {
  ::empty v1;
  unsigned int v2:7;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu7i_BFu9i) C1{ FC2{} Fi:7 Fi:9}



static void Test_Sf_BFu7i_BFu9i()
{
  {
    init_simple_test("Sf_BFu7i_BFu9i");
    static Sf_BFu7i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Sf_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Sf_BFu7i_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu9i(Test_Sf_BFu7i_BFu9i, "Sf_BFu7i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu9ll  {
  ::empty v1;
  unsigned int v2:7;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu7i_BFu9ll) C1{ FC2{} Fi:7 FL:9}



static void Test_Sf_BFu7i_BFu9ll()
{
  {
    init_simple_test("Sf_BFu7i_BFu9ll");
    static Sf_BFu7i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Sf_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Sf_BFu7i_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu9ll(Test_Sf_BFu7i_BFu9ll, "Sf_BFu7i_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_BFu9s  {
  ::empty v1;
  unsigned int v2:7;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu7i_BFu9s) C1{ FC2{} Fi:7 Fs:9}



static void Test_Sf_BFu7i_BFu9s()
{
  {
    init_simple_test("Sf_BFu7i_BFu9s");
    static Sf_BFu7i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu7i_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_BFu9s(Test_Sf_BFu7i_BFu9s, "Sf_BFu7i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_C  {
  ::empty v1;
  unsigned int v2:7;
  char v3;
};
//SIG(1 Sf_BFu7i_C) C1{ FC2{} Fi:7 Fc}



static void Test_Sf_BFu7i_C()
{
  {
    init_simple_test("Sf_BFu7i_C");
    static Sf_BFu7i_C lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_C");
    check_field_offset(lv, v3, 2, "Sf_BFu7i_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_C(Test_Sf_BFu7i_C, "Sf_BFu7i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_D  {
  ::empty v1;
  unsigned int v2:7;
  double v3;
};
//SIG(1 Sf_BFu7i_D) C1{ FC2{} Fi:7 FL}



static void Test_Sf_BFu7i_D()
{
  {
    init_simple_test("Sf_BFu7i_D");
    static Sf_BFu7i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu7i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7i_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_D(Test_Sf_BFu7i_D, "Sf_BFu7i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_F  {
  ::empty v1;
  unsigned int v2:7;
  float v3;
};
//SIG(1 Sf_BFu7i_F) C1{ FC2{} Fi:7 Fi}



static void Test_Sf_BFu7i_F()
{
  {
    init_simple_test("Sf_BFu7i_F");
    static Sf_BFu7i_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_F");
    check_field_offset(lv, v3, 4, "Sf_BFu7i_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_F(Test_Sf_BFu7i_F, "Sf_BFu7i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_I  {
  ::empty v1;
  unsigned int v2:7;
  int v3;
};
//SIG(1 Sf_BFu7i_I) C1{ FC2{} Fi:7 Fi}



static void Test_Sf_BFu7i_I()
{
  {
    init_simple_test("Sf_BFu7i_I");
    static Sf_BFu7i_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_I");
    check_field_offset(lv, v3, 4, "Sf_BFu7i_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_I(Test_Sf_BFu7i_I, "Sf_BFu7i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_Ip  {
  ::empty v1;
  unsigned int v2:7;
  int *v3;
};
//SIG(1 Sf_BFu7i_Ip) C1{ FC2{} Fi:7 Fp}



static void Test_Sf_BFu7i_Ip()
{
  {
    init_simple_test("Sf_BFu7i_Ip");
    static Sf_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu7i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7i_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_Ip(Test_Sf_BFu7i_Ip, "Sf_BFu7i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_L  {
  ::empty v1;
  unsigned int v2:7;
  __tsi64 v3;
};
//SIG(1 Sf_BFu7i_L) C1{ FC2{} Fi:7 FL}



static void Test_Sf_BFu7i_L()
{
  {
    init_simple_test("Sf_BFu7i_L");
    static Sf_BFu7i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu7i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7i_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_L(Test_Sf_BFu7i_L, "Sf_BFu7i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_S  {
  ::empty v1;
  unsigned int v2:7;
  short v3;
};
//SIG(1 Sf_BFu7i_S) C1{ FC2{} Fi:7 Fs}



static void Test_Sf_BFu7i_S()
{
  {
    init_simple_test("Sf_BFu7i_S");
    static Sf_BFu7i_S lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_S");
    check_field_offset(lv, v3, 2, "Sf_BFu7i_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_S(Test_Sf_BFu7i_S, "Sf_BFu7i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_Sf  {
  ::empty v1;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 Sf_BFu7i_Sf) C1{ FC2{} Fi:7 FC2}



static void Test_Sf_BFu7i_Sf()
{
  {
    init_simple_test("Sf_BFu7i_Sf");
    static Sf_BFu7i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_Sf");
    check_field_offset(lv, v3, 2, "Sf_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_Sf(Test_Sf_BFu7i_Sf, "Sf_BFu7i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_Uc  {
  ::empty v1;
  unsigned int v2:7;
  unsigned char v3;
};
//SIG(1 Sf_BFu7i_Uc) C1{ FC2{} Fi:7 Fc}



static void Test_Sf_BFu7i_Uc()
{
  {
    init_simple_test("Sf_BFu7i_Uc");
    static Sf_BFu7i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_Uc");
    check_field_offset(lv, v3, 2, "Sf_BFu7i_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_Uc(Test_Sf_BFu7i_Uc, "Sf_BFu7i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_Ui  {
  ::empty v1;
  unsigned int v2:7;
  unsigned int v3;
};
//SIG(1 Sf_BFu7i_Ui) C1{ FC2{} Fi:7 Fi}



static void Test_Sf_BFu7i_Ui()
{
  {
    init_simple_test("Sf_BFu7i_Ui");
    static Sf_BFu7i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu7i_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_Ui(Test_Sf_BFu7i_Ui, "Sf_BFu7i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_Ul  {
  ::empty v1;
  unsigned int v2:7;
  __tsu64 v3;
};
//SIG(1 Sf_BFu7i_Ul) C1{ FC2{} Fi:7 FL}



static void Test_Sf_BFu7i_Ul()
{
  {
    init_simple_test("Sf_BFu7i_Ul");
    static Sf_BFu7i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu7i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7i_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_Ul(Test_Sf_BFu7i_Ul, "Sf_BFu7i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_Us  {
  ::empty v1;
  unsigned int v2:7;
  unsigned short v3;
};
//SIG(1 Sf_BFu7i_Us) C1{ FC2{} Fi:7 Fs}



static void Test_Sf_BFu7i_Us()
{
  {
    init_simple_test("Sf_BFu7i_Us");
    static Sf_BFu7i_Us lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_Us");
    check_field_offset(lv, v3, 2, "Sf_BFu7i_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_Us(Test_Sf_BFu7i_Us, "Sf_BFu7i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7i_Vp  {
  ::empty v1;
  unsigned int v2:7;
  void *v3;
};
//SIG(1 Sf_BFu7i_Vp) C1{ FC2{} Fi:7 Fp}



static void Test_Sf_BFu7i_Vp()
{
  {
    init_simple_test("Sf_BFu7i_Vp");
    static Sf_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu7i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7i_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7i_Vp(Test_Sf_BFu7i_Vp, "Sf_BFu7i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll  {
  ::empty v1;
  __tsu64 v2:7;
};
//SIG(1 Sf_BFu7ll) C1{ FC2{} FL:7}



static void Test_Sf_BFu7ll()
{
  {
    init_simple_test("Sf_BFu7ll");
    static Sf_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll(Test_Sf_BFu7ll, "Sf_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu15i  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu7ll_BFu15i) C1{ FC2{} FL:7 Fi:15}



static void Test_Sf_BFu7ll_BFu15i()
{
  {
    init_simple_test("Sf_BFu7ll_BFu15i");
    static Sf_BFu7ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Sf_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Sf_BFu7ll_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu15i(Test_Sf_BFu7ll_BFu15i, "Sf_BFu7ll_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu15ll  {
  ::empty v1;
  __tsu64 v2:7;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu7ll_BFu15ll) C1{ FC2{} FL:7 FL:15}



static void Test_Sf_BFu7ll_BFu15ll()
{
  {
    init_simple_test("Sf_BFu7ll_BFu15ll");
    static Sf_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Sf_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Sf_BFu7ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu15ll(Test_Sf_BFu7ll_BFu15ll, "Sf_BFu7ll_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu15s  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu7ll_BFu15s) C1{ FC2{} FL:7 Fs:15}



static void Test_Sf_BFu7ll_BFu15s()
{
  {
    init_simple_test("Sf_BFu7ll_BFu15s");
    static Sf_BFu7ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu7ll_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu15s(Test_Sf_BFu7ll_BFu15s, "Sf_BFu7ll_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu16i  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu7ll_BFu16i) C1{ FC2{} FL:7 Fi:16}



static void Test_Sf_BFu7ll_BFu16i()
{
  {
    init_simple_test("Sf_BFu7ll_BFu16i");
    static Sf_BFu7ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Sf_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Sf_BFu7ll_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu16i(Test_Sf_BFu7ll_BFu16i, "Sf_BFu7ll_BFu16i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu16ll  {
  ::empty v1;
  __tsu64 v2:7;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu7ll_BFu16ll) C1{ FC2{} FL:7 FL:16}



static void Test_Sf_BFu7ll_BFu16ll()
{
  {
    init_simple_test("Sf_BFu7ll_BFu16ll");
    static Sf_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Sf_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Sf_BFu7ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu16ll(Test_Sf_BFu7ll_BFu16ll, "Sf_BFu7ll_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu16s  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu7ll_BFu16s) C1{ FC2{} FL:7 Fs:16}



static void Test_Sf_BFu7ll_BFu16s()
{
  {
    init_simple_test("Sf_BFu7ll_BFu16s");
    static Sf_BFu7ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu7ll_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu16s(Test_Sf_BFu7ll_BFu16s, "Sf_BFu7ll_BFu16s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu17i  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu7ll_BFu17i) C1{ FC2{} FL:7 Fi:17}



static void Test_Sf_BFu7ll_BFu17i()
{
  {
    init_simple_test("Sf_BFu7ll_BFu17i");
    static Sf_BFu7ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Sf_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Sf_BFu7ll_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu17i(Test_Sf_BFu7ll_BFu17i, "Sf_BFu7ll_BFu17i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu17ll  {
  ::empty v1;
  __tsu64 v2:7;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu7ll_BFu17ll) C1{ FC2{} FL:7 FL:17}



static void Test_Sf_BFu7ll_BFu17ll()
{
  {
    init_simple_test("Sf_BFu7ll_BFu17ll");
    static Sf_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Sf_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Sf_BFu7ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu17ll(Test_Sf_BFu7ll_BFu17ll, "Sf_BFu7ll_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu1c  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu7ll_BFu1c) C1{ FC2{} FL:7 Fc:1}



static void Test_Sf_BFu7ll_BFu1c()
{
  {
    init_simple_test("Sf_BFu7ll_BFu1c");
    static Sf_BFu7ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7ll_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu1c(Test_Sf_BFu7ll_BFu1c, "Sf_BFu7ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu1i  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu7ll_BFu1i) C1{ FC2{} FL:7 Fi:1}



static void Test_Sf_BFu7ll_BFu1i()
{
  {
    init_simple_test("Sf_BFu7ll_BFu1i");
    static Sf_BFu7ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7ll_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu1i(Test_Sf_BFu7ll_BFu1i, "Sf_BFu7ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu1ll  {
  ::empty v1;
  __tsu64 v2:7;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu7ll_BFu1ll) C1{ FC2{} FL:7 FL:1}



static void Test_Sf_BFu7ll_BFu1ll()
{
  {
    init_simple_test("Sf_BFu7ll_BFu1ll");
    static Sf_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu1ll(Test_Sf_BFu7ll_BFu1ll, "Sf_BFu7ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu1s  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu7ll_BFu1s) C1{ FC2{} FL:7 Fs:1}



static void Test_Sf_BFu7ll_BFu1s()
{
  {
    init_simple_test("Sf_BFu7ll_BFu1s");
    static Sf_BFu7ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7ll_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu1s(Test_Sf_BFu7ll_BFu1s, "Sf_BFu7ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu31i  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu7ll_BFu31i) C1{ FC2{} FL:7 Fi:31}



static void Test_Sf_BFu7ll_BFu31i()
{
  {
    init_simple_test("Sf_BFu7ll_BFu31i");
    static Sf_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu7ll_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu31i(Test_Sf_BFu7ll_BFu31i, "Sf_BFu7ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu31ll  {
  ::empty v1;
  __tsu64 v2:7;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu7ll_BFu31ll) C1{ FC2{} FL:7 FL:31}



static void Test_Sf_BFu7ll_BFu31ll()
{
  {
    init_simple_test("Sf_BFu7ll_BFu31ll");
    static Sf_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "Sf_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "Sf_BFu7ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu31ll(Test_Sf_BFu7ll_BFu31ll, "Sf_BFu7ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu32i  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu7ll_BFu32i) C1{ FC2{} FL:7 Fi:32}



static void Test_Sf_BFu7ll_BFu32i()
{
  {
    init_simple_test("Sf_BFu7ll_BFu32i");
    static Sf_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu7ll_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu32i(Test_Sf_BFu7ll_BFu32i, "Sf_BFu7ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu32ll  {
  ::empty v1;
  __tsu64 v2:7;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu7ll_BFu32ll) C1{ FC2{} FL:7 FL:32}



static void Test_Sf_BFu7ll_BFu32ll()
{
  {
    init_simple_test("Sf_BFu7ll_BFu32ll");
    static Sf_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "Sf_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "Sf_BFu7ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu32ll(Test_Sf_BFu7ll_BFu32ll, "Sf_BFu7ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu33  {
  ::empty v1;
  __tsu64 v2:7;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu7ll_BFu33) C1{ FC2{} FL:7 FL:33}



static void Test_Sf_BFu7ll_BFu33()
{
  {
    init_simple_test("Sf_BFu7ll_BFu33");
    static Sf_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "Sf_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "Sf_BFu7ll_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu33(Test_Sf_BFu7ll_BFu33, "Sf_BFu7ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu7c  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu7ll_BFu7c) C1{ FC2{} FL:7 Fc:7}



static void Test_Sf_BFu7ll_BFu7c()
{
  {
    init_simple_test("Sf_BFu7ll_BFu7c");
    static Sf_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu7c(Test_Sf_BFu7ll_BFu7c, "Sf_BFu7ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu7i  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu7ll_BFu7i) C1{ FC2{} FL:7 Fi:7}



static void Test_Sf_BFu7ll_BFu7i()
{
  {
    init_simple_test("Sf_BFu7ll_BFu7i");
    static Sf_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Sf_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu7i(Test_Sf_BFu7ll_BFu7i, "Sf_BFu7ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu7ll  {
  ::empty v1;
  __tsu64 v2:7;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu7ll_BFu7ll) C1{ FC2{} FL:7 FL:7}



static void Test_Sf_BFu7ll_BFu7ll()
{
  {
    init_simple_test("Sf_BFu7ll_BFu7ll");
    static Sf_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Sf_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu7ll(Test_Sf_BFu7ll_BFu7ll, "Sf_BFu7ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu7s  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu7ll_BFu7s) C1{ FC2{} FL:7 Fs:7}



static void Test_Sf_BFu7ll_BFu7s()
{
  {
    init_simple_test("Sf_BFu7ll_BFu7s");
    static Sf_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu7s(Test_Sf_BFu7ll_BFu7s, "Sf_BFu7ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu8c  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu7ll_BFu8c) C1{ FC2{} FL:7 Fc:8}



static void Test_Sf_BFu7ll_BFu8c()
{
  {
    init_simple_test("Sf_BFu7ll_BFu8c");
    static Sf_BFu7ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu7ll_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu8c(Test_Sf_BFu7ll_BFu8c, "Sf_BFu7ll_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu8i  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu7ll_BFu8i) C1{ FC2{} FL:7 Fi:8}



static void Test_Sf_BFu7ll_BFu8i()
{
  {
    init_simple_test("Sf_BFu7ll_BFu8i");
    static Sf_BFu7ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Sf_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Sf_BFu7ll_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu8i(Test_Sf_BFu7ll_BFu8i, "Sf_BFu7ll_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu8ll  {
  ::empty v1;
  __tsu64 v2:7;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu7ll_BFu8ll) C1{ FC2{} FL:7 FL:8}



static void Test_Sf_BFu7ll_BFu8ll()
{
  {
    init_simple_test("Sf_BFu7ll_BFu8ll");
    static Sf_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Sf_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Sf_BFu7ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu8ll(Test_Sf_BFu7ll_BFu8ll, "Sf_BFu7ll_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu8s  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu7ll_BFu8s) C1{ FC2{} FL:7 Fs:8}



static void Test_Sf_BFu7ll_BFu8s()
{
  {
    init_simple_test("Sf_BFu7ll_BFu8s");
    static Sf_BFu7ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu7ll_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu8s(Test_Sf_BFu7ll_BFu8s, "Sf_BFu7ll_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu9i  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu7ll_BFu9i) C1{ FC2{} FL:7 Fi:9}



static void Test_Sf_BFu7ll_BFu9i()
{
  {
    init_simple_test("Sf_BFu7ll_BFu9i");
    static Sf_BFu7ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Sf_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Sf_BFu7ll_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu9i(Test_Sf_BFu7ll_BFu9i, "Sf_BFu7ll_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu9ll  {
  ::empty v1;
  __tsu64 v2:7;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu7ll_BFu9ll) C1{ FC2{} FL:7 FL:9}



static void Test_Sf_BFu7ll_BFu9ll()
{
  {
    init_simple_test("Sf_BFu7ll_BFu9ll");
    static Sf_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Sf_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Sf_BFu7ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu9ll(Test_Sf_BFu7ll_BFu9ll, "Sf_BFu7ll_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_BFu9s  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu7ll_BFu9s) C1{ FC2{} FL:7 Fs:9}



static void Test_Sf_BFu7ll_BFu9s()
{
  {
    init_simple_test("Sf_BFu7ll_BFu9s");
    static Sf_BFu7ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu7ll_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_BFu9s(Test_Sf_BFu7ll_BFu9s, "Sf_BFu7ll_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_C  {
  ::empty v1;
  __tsu64 v2:7;
  char v3;
};
//SIG(1 Sf_BFu7ll_C) C1{ FC2{} FL:7 Fc}



static void Test_Sf_BFu7ll_C()
{
  {
    init_simple_test("Sf_BFu7ll_C");
    static Sf_BFu7ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_C");
    check_field_offset(lv, v3, 2, "Sf_BFu7ll_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_C(Test_Sf_BFu7ll_C, "Sf_BFu7ll_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_D  {
  ::empty v1;
  __tsu64 v2:7;
  double v3;
};
//SIG(1 Sf_BFu7ll_D) C1{ FC2{} FL:7 FL}



static void Test_Sf_BFu7ll_D()
{
  {
    init_simple_test("Sf_BFu7ll_D");
    static Sf_BFu7ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu7ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7ll_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_D(Test_Sf_BFu7ll_D, "Sf_BFu7ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_F  {
  ::empty v1;
  __tsu64 v2:7;
  float v3;
};
//SIG(1 Sf_BFu7ll_F) C1{ FC2{} FL:7 Fi}



static void Test_Sf_BFu7ll_F()
{
  {
    init_simple_test("Sf_BFu7ll_F");
    static Sf_BFu7ll_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_F");
    check_field_offset(lv, v3, 4, "Sf_BFu7ll_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_F(Test_Sf_BFu7ll_F, "Sf_BFu7ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_I  {
  ::empty v1;
  __tsu64 v2:7;
  int v3;
};
//SIG(1 Sf_BFu7ll_I) C1{ FC2{} FL:7 Fi}



static void Test_Sf_BFu7ll_I()
{
  {
    init_simple_test("Sf_BFu7ll_I");
    static Sf_BFu7ll_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_I");
    check_field_offset(lv, v3, 4, "Sf_BFu7ll_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_I(Test_Sf_BFu7ll_I, "Sf_BFu7ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_Ip  {
  ::empty v1;
  __tsu64 v2:7;
  int *v3;
};
//SIG(1 Sf_BFu7ll_Ip) C1{ FC2{} FL:7 Fp}



static void Test_Sf_BFu7ll_Ip()
{
  {
    init_simple_test("Sf_BFu7ll_Ip");
    static Sf_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu7ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_Ip(Test_Sf_BFu7ll_Ip, "Sf_BFu7ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_L  {
  ::empty v1;
  __tsu64 v2:7;
  __tsi64 v3;
};
//SIG(1 Sf_BFu7ll_L) C1{ FC2{} FL:7 FL}



static void Test_Sf_BFu7ll_L()
{
  {
    init_simple_test("Sf_BFu7ll_L");
    static Sf_BFu7ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu7ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7ll_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_L(Test_Sf_BFu7ll_L, "Sf_BFu7ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_S  {
  ::empty v1;
  __tsu64 v2:7;
  short v3;
};
//SIG(1 Sf_BFu7ll_S) C1{ FC2{} FL:7 Fs}



static void Test_Sf_BFu7ll_S()
{
  {
    init_simple_test("Sf_BFu7ll_S");
    static Sf_BFu7ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_S");
    check_field_offset(lv, v3, 2, "Sf_BFu7ll_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_S(Test_Sf_BFu7ll_S, "Sf_BFu7ll_S", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_Sf  {
  ::empty v1;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 Sf_BFu7ll_Sf) C1{ FC2{} FL:7 FC2}



static void Test_Sf_BFu7ll_Sf()
{
  {
    init_simple_test("Sf_BFu7ll_Sf");
    static Sf_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_Sf");
    check_field_offset(lv, v3, 2, "Sf_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_Sf(Test_Sf_BFu7ll_Sf, "Sf_BFu7ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_Uc  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned char v3;
};
//SIG(1 Sf_BFu7ll_Uc) C1{ FC2{} FL:7 Fc}



static void Test_Sf_BFu7ll_Uc()
{
  {
    init_simple_test("Sf_BFu7ll_Uc");
    static Sf_BFu7ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_Uc");
    check_field_offset(lv, v3, 2, "Sf_BFu7ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_Uc(Test_Sf_BFu7ll_Uc, "Sf_BFu7ll_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_Ui  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned int v3;
};
//SIG(1 Sf_BFu7ll_Ui) C1{ FC2{} FL:7 Fi}



static void Test_Sf_BFu7ll_Ui()
{
  {
    init_simple_test("Sf_BFu7ll_Ui");
    static Sf_BFu7ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu7ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_Ui(Test_Sf_BFu7ll_Ui, "Sf_BFu7ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_Ul  {
  ::empty v1;
  __tsu64 v2:7;
  __tsu64 v3;
};
//SIG(1 Sf_BFu7ll_Ul) C1{ FC2{} FL:7 FL}



static void Test_Sf_BFu7ll_Ul()
{
  {
    init_simple_test("Sf_BFu7ll_Ul");
    static Sf_BFu7ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu7ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_Ul(Test_Sf_BFu7ll_Ul, "Sf_BFu7ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_Us  {
  ::empty v1;
  __tsu64 v2:7;
  unsigned short v3;
};
//SIG(1 Sf_BFu7ll_Us) C1{ FC2{} FL:7 Fs}



static void Test_Sf_BFu7ll_Us()
{
  {
    init_simple_test("Sf_BFu7ll_Us");
    static Sf_BFu7ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_Us");
    check_field_offset(lv, v3, 2, "Sf_BFu7ll_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_Us(Test_Sf_BFu7ll_Us, "Sf_BFu7ll_Us", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7ll_Vp  {
  ::empty v1;
  __tsu64 v2:7;
  void *v3;
};
//SIG(1 Sf_BFu7ll_Vp) C1{ FC2{} FL:7 Fp}



static void Test_Sf_BFu7ll_Vp()
{
  {
    init_simple_test("Sf_BFu7ll_Vp");
    static Sf_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu7ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7ll_Vp(Test_Sf_BFu7ll_Vp, "Sf_BFu7ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s  {
  ::empty v1;
  unsigned short v2:7;
};
//SIG(1 Sf_BFu7s) C1{ FC2{} Fs:7}



static void Test_Sf_BFu7s()
{
  {
    init_simple_test("Sf_BFu7s");
    static Sf_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu7s(Test_Sf_BFu7s, "Sf_BFu7s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu15i  {
  ::empty v1;
  unsigned short v2:7;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu7s_BFu15i) C1{ FC2{} Fs:7 Fi:15}



static void Test_Sf_BFu7s_BFu15i()
{
  {
    init_simple_test("Sf_BFu7s_BFu15i");
    static Sf_BFu7s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Sf_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Sf_BFu7s_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu15i(Test_Sf_BFu7s_BFu15i, "Sf_BFu7s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu15ll  {
  ::empty v1;
  unsigned short v2:7;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu7s_BFu15ll) C1{ FC2{} Fs:7 FL:15}



static void Test_Sf_BFu7s_BFu15ll()
{
  {
    init_simple_test("Sf_BFu7s_BFu15ll");
    static Sf_BFu7s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "Sf_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "Sf_BFu7s_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu15ll(Test_Sf_BFu7s_BFu15ll, "Sf_BFu7s_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu15s  {
  ::empty v1;
  unsigned short v2:7;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu7s_BFu15s) C1{ FC2{} Fs:7 Fs:15}



static void Test_Sf_BFu7s_BFu15s()
{
  {
    init_simple_test("Sf_BFu7s_BFu15s");
    static Sf_BFu7s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu7s_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu15s(Test_Sf_BFu7s_BFu15s, "Sf_BFu7s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu16i  {
  ::empty v1;
  unsigned short v2:7;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu7s_BFu16i) C1{ FC2{} Fs:7 Fi:16}



static void Test_Sf_BFu7s_BFu16i()
{
  {
    init_simple_test("Sf_BFu7s_BFu16i");
    static Sf_BFu7s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Sf_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Sf_BFu7s_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu16i(Test_Sf_BFu7s_BFu16i, "Sf_BFu7s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu16ll  {
  ::empty v1;
  unsigned short v2:7;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu7s_BFu16ll) C1{ FC2{} Fs:7 FL:16}



static void Test_Sf_BFu7s_BFu16ll()
{
  {
    init_simple_test("Sf_BFu7s_BFu16ll");
    static Sf_BFu7s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "Sf_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "Sf_BFu7s_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu16ll(Test_Sf_BFu7s_BFu16ll, "Sf_BFu7s_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu16s  {
  ::empty v1;
  unsigned short v2:7;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu7s_BFu16s) C1{ FC2{} Fs:7 Fs:16}



static void Test_Sf_BFu7s_BFu16s()
{
  {
    init_simple_test("Sf_BFu7s_BFu16s");
    static Sf_BFu7s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu7s_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu16s(Test_Sf_BFu7s_BFu16s, "Sf_BFu7s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu17i  {
  ::empty v1;
  unsigned short v2:7;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu7s_BFu17i) C1{ FC2{} Fs:7 Fi:17}



static void Test_Sf_BFu7s_BFu17i()
{
  {
    init_simple_test("Sf_BFu7s_BFu17i");
    static Sf_BFu7s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Sf_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Sf_BFu7s_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu17i(Test_Sf_BFu7s_BFu17i, "Sf_BFu7s_BFu17i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu17ll  {
  ::empty v1;
  unsigned short v2:7;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu7s_BFu17ll) C1{ FC2{} Fs:7 FL:17}



static void Test_Sf_BFu7s_BFu17ll()
{
  {
    init_simple_test("Sf_BFu7s_BFu17ll");
    static Sf_BFu7s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "Sf_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "Sf_BFu7s_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu17ll(Test_Sf_BFu7s_BFu17ll, "Sf_BFu7s_BFu17ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu1c  {
  ::empty v1;
  unsigned short v2:7;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu7s_BFu1c) C1{ FC2{} Fs:7 Fc:1}



static void Test_Sf_BFu7s_BFu1c()
{
  {
    init_simple_test("Sf_BFu7s_BFu1c");
    static Sf_BFu7s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu7s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7s_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu1c(Test_Sf_BFu7s_BFu1c, "Sf_BFu7s_BFu1c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu1i  {
  ::empty v1;
  unsigned short v2:7;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu7s_BFu1i) C1{ FC2{} Fs:7 Fi:1}



static void Test_Sf_BFu7s_BFu1i()
{
  {
    init_simple_test("Sf_BFu7s_BFu1i");
    static Sf_BFu7s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7s_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu1i(Test_Sf_BFu7s_BFu1i, "Sf_BFu7s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu1ll  {
  ::empty v1;
  unsigned short v2:7;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu7s_BFu1ll) C1{ FC2{} Fs:7 FL:1}



static void Test_Sf_BFu7s_BFu1ll()
{
  {
    init_simple_test("Sf_BFu7s_BFu1ll");
    static Sf_BFu7s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7s_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu1ll(Test_Sf_BFu7s_BFu1ll, "Sf_BFu7s_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu1s  {
  ::empty v1;
  unsigned short v2:7;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu7s_BFu1s) C1{ FC2{} Fs:7 Fs:1}



static void Test_Sf_BFu7s_BFu1s()
{
  {
    init_simple_test("Sf_BFu7s_BFu1s");
    static Sf_BFu7s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu7s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "Sf_BFu7s_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu1s(Test_Sf_BFu7s_BFu1s, "Sf_BFu7s_BFu1s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu31i  {
  ::empty v1;
  unsigned short v2:7;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu7s_BFu31i) C1{ FC2{} Fs:7 Fi:31}



static void Test_Sf_BFu7s_BFu31i()
{
  {
    init_simple_test("Sf_BFu7s_BFu31i");
    static Sf_BFu7s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu7s_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu31i(Test_Sf_BFu7s_BFu31i, "Sf_BFu7s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu31ll  {
  ::empty v1;
  unsigned short v2:7;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu7s_BFu31ll) C1{ FC2{} Fs:7 FL:31}



static void Test_Sf_BFu7s_BFu31ll()
{
  {
    init_simple_test("Sf_BFu7s_BFu31ll");
    static Sf_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "Sf_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "Sf_BFu7s_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu31ll(Test_Sf_BFu7s_BFu31ll, "Sf_BFu7s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu32i  {
  ::empty v1;
  unsigned short v2:7;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu7s_BFu32i) C1{ FC2{} Fs:7 Fi:32}



static void Test_Sf_BFu7s_BFu32i()
{
  {
    init_simple_test("Sf_BFu7s_BFu32i");
    static Sf_BFu7s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu7s_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu32i(Test_Sf_BFu7s_BFu32i, "Sf_BFu7s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu32ll  {
  ::empty v1;
  unsigned short v2:7;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu7s_BFu32ll) C1{ FC2{} Fs:7 FL:32}



static void Test_Sf_BFu7s_BFu32ll()
{
  {
    init_simple_test("Sf_BFu7s_BFu32ll");
    static Sf_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "Sf_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "Sf_BFu7s_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu32ll(Test_Sf_BFu7s_BFu32ll, "Sf_BFu7s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu33  {
  ::empty v1;
  unsigned short v2:7;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu7s_BFu33) C1{ FC2{} Fs:7 FL:33}



static void Test_Sf_BFu7s_BFu33()
{
  {
    init_simple_test("Sf_BFu7s_BFu33");
    static Sf_BFu7s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "Sf_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "Sf_BFu7s_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu33(Test_Sf_BFu7s_BFu33, "Sf_BFu7s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu7c  {
  ::empty v1;
  unsigned short v2:7;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu7s_BFu7c) C1{ FC2{} Fs:7 Fc:7}



static void Test_Sf_BFu7s_BFu7c()
{
  {
    init_simple_test("Sf_BFu7s_BFu7c");
    static Sf_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu7c(Test_Sf_BFu7s_BFu7c, "Sf_BFu7s_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu7i  {
  ::empty v1;
  unsigned short v2:7;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu7s_BFu7i) C1{ FC2{} Fs:7 Fi:7}



static void Test_Sf_BFu7s_BFu7i()
{
  {
    init_simple_test("Sf_BFu7s_BFu7i");
    static Sf_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Sf_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu7i(Test_Sf_BFu7s_BFu7i, "Sf_BFu7s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu7ll  {
  ::empty v1;
  unsigned short v2:7;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu7s_BFu7ll) C1{ FC2{} Fs:7 FL:7}



static void Test_Sf_BFu7s_BFu7ll()
{
  {
    init_simple_test("Sf_BFu7s_BFu7ll");
    static Sf_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "Sf_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu7ll(Test_Sf_BFu7s_BFu7ll, "Sf_BFu7s_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu7s  {
  ::empty v1;
  unsigned short v2:7;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu7s_BFu7s) C1{ FC2{} Fs:7 Fs:7}



static void Test_Sf_BFu7s_BFu7s()
{
  {
    init_simple_test("Sf_BFu7s_BFu7s");
    static Sf_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu7s(Test_Sf_BFu7s_BFu7s, "Sf_BFu7s_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu8c  {
  ::empty v1;
  unsigned short v2:7;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu7s_BFu8c) C1{ FC2{} Fs:7 Fc:8}



static void Test_Sf_BFu7s_BFu8c()
{
  {
    init_simple_test("Sf_BFu7s_BFu8c");
    static Sf_BFu7s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu7s_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu8c(Test_Sf_BFu7s_BFu8c, "Sf_BFu7s_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu8i  {
  ::empty v1;
  unsigned short v2:7;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu7s_BFu8i) C1{ FC2{} Fs:7 Fi:8}



static void Test_Sf_BFu7s_BFu8i()
{
  {
    init_simple_test("Sf_BFu7s_BFu8i");
    static Sf_BFu7s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Sf_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Sf_BFu7s_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu8i(Test_Sf_BFu7s_BFu8i, "Sf_BFu7s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu8ll  {
  ::empty v1;
  unsigned short v2:7;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu7s_BFu8ll) C1{ FC2{} Fs:7 FL:8}



static void Test_Sf_BFu7s_BFu8ll()
{
  {
    init_simple_test("Sf_BFu7s_BFu8ll");
    static Sf_BFu7s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "Sf_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "Sf_BFu7s_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu8ll(Test_Sf_BFu7s_BFu8ll, "Sf_BFu7s_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu8s  {
  ::empty v1;
  unsigned short v2:7;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu7s_BFu8s) C1{ FC2{} Fs:7 Fs:8}



static void Test_Sf_BFu7s_BFu8s()
{
  {
    init_simple_test("Sf_BFu7s_BFu8s");
    static Sf_BFu7s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu7s_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu8s(Test_Sf_BFu7s_BFu8s, "Sf_BFu7s_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu9i  {
  ::empty v1;
  unsigned short v2:7;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu7s_BFu9i) C1{ FC2{} Fs:7 Fi:9}



static void Test_Sf_BFu7s_BFu9i()
{
  {
    init_simple_test("Sf_BFu7s_BFu9i");
    static Sf_BFu7s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Sf_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Sf_BFu7s_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu9i(Test_Sf_BFu7s_BFu9i, "Sf_BFu7s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu9ll  {
  ::empty v1;
  unsigned short v2:7;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu7s_BFu9ll) C1{ FC2{} Fs:7 FL:9}



static void Test_Sf_BFu7s_BFu9ll()
{
  {
    init_simple_test("Sf_BFu7s_BFu9ll");
    static Sf_BFu7s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu7s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "Sf_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "Sf_BFu7s_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu9ll(Test_Sf_BFu7s_BFu9ll, "Sf_BFu7s_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_BFu9s  {
  ::empty v1;
  unsigned short v2:7;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu7s_BFu9s) C1{ FC2{} Fs:7 Fs:9}



static void Test_Sf_BFu7s_BFu9s()
{
  {
    init_simple_test("Sf_BFu7s_BFu9s");
    static Sf_BFu7s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu7s_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_BFu9s(Test_Sf_BFu7s_BFu9s, "Sf_BFu7s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_C  {
  ::empty v1;
  unsigned short v2:7;
  char v3;
};
//SIG(1 Sf_BFu7s_C) C1{ FC2{} Fs:7 Fc}



static void Test_Sf_BFu7s_C()
{
  {
    init_simple_test("Sf_BFu7s_C");
    static Sf_BFu7s_C lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_C)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_C");
    check_field_offset(lv, v3, 2, "Sf_BFu7s_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_C(Test_Sf_BFu7s_C, "Sf_BFu7s_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_D  {
  ::empty v1;
  unsigned short v2:7;
  double v3;
};
//SIG(1 Sf_BFu7s_D) C1{ FC2{} Fs:7 FL}



static void Test_Sf_BFu7s_D()
{
  {
    init_simple_test("Sf_BFu7s_D");
    static Sf_BFu7s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu7s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7s_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_D(Test_Sf_BFu7s_D, "Sf_BFu7s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_F  {
  ::empty v1;
  unsigned short v2:7;
  float v3;
};
//SIG(1 Sf_BFu7s_F) C1{ FC2{} Fs:7 Fi}



static void Test_Sf_BFu7s_F()
{
  {
    init_simple_test("Sf_BFu7s_F");
    static Sf_BFu7s_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7s_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7s_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_F");
    check_field_offset(lv, v3, 4, "Sf_BFu7s_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_F(Test_Sf_BFu7s_F, "Sf_BFu7s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_I  {
  ::empty v1;
  unsigned short v2:7;
  int v3;
};
//SIG(1 Sf_BFu7s_I) C1{ FC2{} Fs:7 Fi}



static void Test_Sf_BFu7s_I()
{
  {
    init_simple_test("Sf_BFu7s_I");
    static Sf_BFu7s_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7s_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7s_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_I");
    check_field_offset(lv, v3, 4, "Sf_BFu7s_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_I(Test_Sf_BFu7s_I, "Sf_BFu7s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_Ip  {
  ::empty v1;
  unsigned short v2:7;
  int *v3;
};
//SIG(1 Sf_BFu7s_Ip) C1{ FC2{} Fs:7 Fp}



static void Test_Sf_BFu7s_Ip()
{
  {
    init_simple_test("Sf_BFu7s_Ip");
    static Sf_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu7s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7s_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_Ip(Test_Sf_BFu7s_Ip, "Sf_BFu7s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_L  {
  ::empty v1;
  unsigned short v2:7;
  __tsi64 v3;
};
//SIG(1 Sf_BFu7s_L) C1{ FC2{} Fs:7 FL}



static void Test_Sf_BFu7s_L()
{
  {
    init_simple_test("Sf_BFu7s_L");
    static Sf_BFu7s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu7s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7s_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_L(Test_Sf_BFu7s_L, "Sf_BFu7s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_S  {
  ::empty v1;
  unsigned short v2:7;
  short v3;
};
//SIG(1 Sf_BFu7s_S) C1{ FC2{} Fs:7 Fs}



static void Test_Sf_BFu7s_S()
{
  {
    init_simple_test("Sf_BFu7s_S");
    static Sf_BFu7s_S lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_S)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_S");
    check_field_offset(lv, v3, 2, "Sf_BFu7s_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_S(Test_Sf_BFu7s_S, "Sf_BFu7s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_Sf  {
  ::empty v1;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 Sf_BFu7s_Sf) C1{ FC2{} Fs:7 FC2}



static void Test_Sf_BFu7s_Sf()
{
  {
    init_simple_test("Sf_BFu7s_Sf");
    static Sf_BFu7s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_Sf");
    check_field_offset(lv, v3, 2, "Sf_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_Sf(Test_Sf_BFu7s_Sf, "Sf_BFu7s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_Uc  {
  ::empty v1;
  unsigned short v2:7;
  unsigned char v3;
};
//SIG(1 Sf_BFu7s_Uc) C1{ FC2{} Fs:7 Fc}



static void Test_Sf_BFu7s_Uc()
{
  {
    init_simple_test("Sf_BFu7s_Uc");
    static Sf_BFu7s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_Uc");
    check_field_offset(lv, v3, 2, "Sf_BFu7s_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_Uc(Test_Sf_BFu7s_Uc, "Sf_BFu7s_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_Ui  {
  ::empty v1;
  unsigned short v2:7;
  unsigned int v3;
};
//SIG(1 Sf_BFu7s_Ui) C1{ FC2{} Fs:7 Fi}



static void Test_Sf_BFu7s_Ui()
{
  {
    init_simple_test("Sf_BFu7s_Ui");
    static Sf_BFu7s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu7s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu7s_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_Ui(Test_Sf_BFu7s_Ui, "Sf_BFu7s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_Ul  {
  ::empty v1;
  unsigned short v2:7;
  __tsu64 v3;
};
//SIG(1 Sf_BFu7s_Ul) C1{ FC2{} Fs:7 FL}



static void Test_Sf_BFu7s_Ul()
{
  {
    init_simple_test("Sf_BFu7s_Ul");
    static Sf_BFu7s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu7s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7s_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_Ul(Test_Sf_BFu7s_Ul, "Sf_BFu7s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_Us  {
  ::empty v1;
  unsigned short v2:7;
  unsigned short v3;
};
//SIG(1 Sf_BFu7s_Us) C1{ FC2{} Fs:7 Fs}



static void Test_Sf_BFu7s_Us()
{
  {
    init_simple_test("Sf_BFu7s_Us");
    static Sf_BFu7s_Us lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu7s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_Us");
    check_field_offset(lv, v3, 2, "Sf_BFu7s_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_Us(Test_Sf_BFu7s_Us, "Sf_BFu7s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu7s_Vp  {
  ::empty v1;
  unsigned short v2:7;
  void *v3;
};
//SIG(1 Sf_BFu7s_Vp) C1{ FC2{} Fs:7 Fp}



static void Test_Sf_BFu7s_Vp()
{
  {
    init_simple_test("Sf_BFu7s_Vp");
    static Sf_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu7s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "Sf_BFu7s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "Sf_BFu7s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu7s_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu7s_Vp(Test_Sf_BFu7s_Vp, "Sf_BFu7s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c  {
  ::empty v1;
  unsigned char v2:8;
};
//SIG(1 Sf_BFu8c) C1{ FC2{} Fc:8}



static void Test_Sf_BFu8c()
{
  {
    init_simple_test("Sf_BFu8c");
    static Sf_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu8c(Test_Sf_BFu8c, "Sf_BFu8c", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu15i  {
  ::empty v1;
  unsigned char v2:8;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu8c_BFu15i) C1{ FC2{} Fc:8 Fi:15}



static void Test_Sf_BFu8c_BFu15i()
{
  {
    init_simple_test("Sf_BFu8c_BFu15i");
    static Sf_BFu8c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu8c_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu15i(Test_Sf_BFu8c_BFu15i, "Sf_BFu8c_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu15ll  {
  ::empty v1;
  unsigned char v2:8;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu8c_BFu15ll) C1{ FC2{} Fc:8 FL:15}



static void Test_Sf_BFu8c_BFu15ll()
{
  {
    init_simple_test("Sf_BFu8c_BFu15ll");
    static Sf_BFu8c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu8c_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu15ll(Test_Sf_BFu8c_BFu15ll, "Sf_BFu8c_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu15s  {
  ::empty v1;
  unsigned char v2:8;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu8c_BFu15s) C1{ FC2{} Fc:8 Fs:15}



static void Test_Sf_BFu8c_BFu15s()
{
  {
    init_simple_test("Sf_BFu8c_BFu15s");
    static Sf_BFu8c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu8c_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu15s(Test_Sf_BFu8c_BFu15s, "Sf_BFu8c_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu16i  {
  ::empty v1;
  unsigned char v2:8;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu8c_BFu16i) C1{ FC2{} Fc:8 Fi:16}



static void Test_Sf_BFu8c_BFu16i()
{
  {
    init_simple_test("Sf_BFu8c_BFu16i");
    static Sf_BFu8c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu8c_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu16i(Test_Sf_BFu8c_BFu16i, "Sf_BFu8c_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu16ll  {
  ::empty v1;
  unsigned char v2:8;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu8c_BFu16ll) C1{ FC2{} Fc:8 FL:16}



static void Test_Sf_BFu8c_BFu16ll()
{
  {
    init_simple_test("Sf_BFu8c_BFu16ll");
    static Sf_BFu8c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu8c_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu16ll(Test_Sf_BFu8c_BFu16ll, "Sf_BFu8c_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu16s  {
  ::empty v1;
  unsigned char v2:8;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu8c_BFu16s) C1{ FC2{} Fc:8 Fs:16}



static void Test_Sf_BFu8c_BFu16s()
{
  {
    init_simple_test("Sf_BFu8c_BFu16s");
    static Sf_BFu8c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu8c_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu16s(Test_Sf_BFu8c_BFu16s, "Sf_BFu8c_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu17i  {
  ::empty v1;
  unsigned char v2:8;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu8c_BFu17i) C1{ FC2{} Fc:8 Fi:17}



static void Test_Sf_BFu8c_BFu17i()
{
  {
    init_simple_test("Sf_BFu8c_BFu17i");
    static Sf_BFu8c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Sf_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Sf_BFu8c_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu17i(Test_Sf_BFu8c_BFu17i, "Sf_BFu8c_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu17ll  {
  ::empty v1;
  unsigned char v2:8;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu8c_BFu17ll) C1{ FC2{} Fc:8 FL:17}



static void Test_Sf_BFu8c_BFu17ll()
{
  {
    init_simple_test("Sf_BFu8c_BFu17ll");
    static Sf_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Sf_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Sf_BFu8c_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu17ll(Test_Sf_BFu8c_BFu17ll, "Sf_BFu8c_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu1c  {
  ::empty v1;
  unsigned char v2:8;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu8c_BFu1c) C1{ FC2{} Fc:8 Fc:1}



static void Test_Sf_BFu8c_BFu1c()
{
  {
    init_simple_test("Sf_BFu8c_BFu1c");
    static Sf_BFu8c_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8c_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu1c(Test_Sf_BFu8c_BFu1c, "Sf_BFu8c_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu1i  {
  ::empty v1;
  unsigned char v2:8;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu8c_BFu1i) C1{ FC2{} Fc:8 Fi:1}



static void Test_Sf_BFu8c_BFu1i()
{
  {
    init_simple_test("Sf_BFu8c_BFu1i");
    static Sf_BFu8c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8c_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu1i(Test_Sf_BFu8c_BFu1i, "Sf_BFu8c_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu1ll  {
  ::empty v1;
  unsigned char v2:8;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu8c_BFu1ll) C1{ FC2{} Fc:8 FL:1}



static void Test_Sf_BFu8c_BFu1ll()
{
  {
    init_simple_test("Sf_BFu8c_BFu1ll");
    static Sf_BFu8c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8c_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu1ll(Test_Sf_BFu8c_BFu1ll, "Sf_BFu8c_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu1s  {
  ::empty v1;
  unsigned char v2:8;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu8c_BFu1s) C1{ FC2{} Fc:8 Fs:1}



static void Test_Sf_BFu8c_BFu1s()
{
  {
    init_simple_test("Sf_BFu8c_BFu1s");
    static Sf_BFu8c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8c_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu1s(Test_Sf_BFu8c_BFu1s, "Sf_BFu8c_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu31i  {
  ::empty v1;
  unsigned char v2:8;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu8c_BFu31i) C1{ FC2{} Fc:8 Fi:31}



static void Test_Sf_BFu8c_BFu31i()
{
  {
    init_simple_test("Sf_BFu8c_BFu31i");
    static Sf_BFu8c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu8c_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu31i(Test_Sf_BFu8c_BFu31i, "Sf_BFu8c_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu31ll  {
  ::empty v1;
  unsigned char v2:8;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu8c_BFu31ll) C1{ FC2{} Fc:8 FL:31}



static void Test_Sf_BFu8c_BFu31ll()
{
  {
    init_simple_test("Sf_BFu8c_BFu31ll");
    static Sf_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Sf_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Sf_BFu8c_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu31ll(Test_Sf_BFu8c_BFu31ll, "Sf_BFu8c_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu32i  {
  ::empty v1;
  unsigned char v2:8;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu8c_BFu32i) C1{ FC2{} Fc:8 Fi:32}



static void Test_Sf_BFu8c_BFu32i()
{
  {
    init_simple_test("Sf_BFu8c_BFu32i");
    static Sf_BFu8c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu8c_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu32i(Test_Sf_BFu8c_BFu32i, "Sf_BFu8c_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu32ll  {
  ::empty v1;
  unsigned char v2:8;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu8c_BFu32ll) C1{ FC2{} Fc:8 FL:32}



static void Test_Sf_BFu8c_BFu32ll()
{
  {
    init_simple_test("Sf_BFu8c_BFu32ll");
    static Sf_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Sf_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Sf_BFu8c_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu32ll(Test_Sf_BFu8c_BFu32ll, "Sf_BFu8c_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu33  {
  ::empty v1;
  unsigned char v2:8;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu8c_BFu33) C1{ FC2{} Fc:8 FL:33}



static void Test_Sf_BFu8c_BFu33()
{
  {
    init_simple_test("Sf_BFu8c_BFu33");
    static Sf_BFu8c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "Sf_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "Sf_BFu8c_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu33(Test_Sf_BFu8c_BFu33, "Sf_BFu8c_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu7c  {
  ::empty v1;
  unsigned char v2:8;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu8c_BFu7c) C1{ FC2{} Fc:8 Fc:7}



static void Test_Sf_BFu8c_BFu7c()
{
  {
    init_simple_test("Sf_BFu8c_BFu7c");
    static Sf_BFu8c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8c_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu7c(Test_Sf_BFu8c_BFu7c, "Sf_BFu8c_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu7i  {
  ::empty v1;
  unsigned char v2:8;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu8c_BFu7i) C1{ FC2{} Fc:8 Fi:7}



static void Test_Sf_BFu8c_BFu7i()
{
  {
    init_simple_test("Sf_BFu8c_BFu7i");
    static Sf_BFu8c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8c_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu7i(Test_Sf_BFu8c_BFu7i, "Sf_BFu8c_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu7ll  {
  ::empty v1;
  unsigned char v2:8;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu8c_BFu7ll) C1{ FC2{} Fc:8 FL:7}



static void Test_Sf_BFu8c_BFu7ll()
{
  {
    init_simple_test("Sf_BFu8c_BFu7ll");
    static Sf_BFu8c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8c_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu7ll(Test_Sf_BFu8c_BFu7ll, "Sf_BFu8c_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu7s  {
  ::empty v1;
  unsigned char v2:8;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu8c_BFu7s) C1{ FC2{} Fc:8 Fs:7}



static void Test_Sf_BFu8c_BFu7s()
{
  {
    init_simple_test("Sf_BFu8c_BFu7s");
    static Sf_BFu8c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8c_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu7s(Test_Sf_BFu8c_BFu7s, "Sf_BFu8c_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu8c  {
  ::empty v1;
  unsigned char v2:8;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu8c_BFu8c) C1{ FC2{} Fc:8 Fc:8}



static void Test_Sf_BFu8c_BFu8c()
{
  {
    init_simple_test("Sf_BFu8c_BFu8c");
    static Sf_BFu8c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu8c(Test_Sf_BFu8c_BFu8c, "Sf_BFu8c_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu8i  {
  ::empty v1;
  unsigned char v2:8;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu8c_BFu8i) C1{ FC2{} Fc:8 Fi:8}



static void Test_Sf_BFu8c_BFu8i()
{
  {
    init_simple_test("Sf_BFu8c_BFu8i");
    static Sf_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu8i(Test_Sf_BFu8c_BFu8i, "Sf_BFu8c_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu8ll  {
  ::empty v1;
  unsigned char v2:8;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu8c_BFu8ll) C1{ FC2{} Fc:8 FL:8}



static void Test_Sf_BFu8c_BFu8ll()
{
  {
    init_simple_test("Sf_BFu8c_BFu8ll");
    static Sf_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu8ll(Test_Sf_BFu8c_BFu8ll, "Sf_BFu8c_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu8s  {
  ::empty v1;
  unsigned char v2:8;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu8c_BFu8s) C1{ FC2{} Fc:8 Fs:8}



static void Test_Sf_BFu8c_BFu8s()
{
  {
    init_simple_test("Sf_BFu8c_BFu8s");
    static Sf_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu8s(Test_Sf_BFu8c_BFu8s, "Sf_BFu8c_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu9i  {
  ::empty v1;
  unsigned char v2:8;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu8c_BFu9i) C1{ FC2{} Fc:8 Fi:9}



static void Test_Sf_BFu8c_BFu9i()
{
  {
    init_simple_test("Sf_BFu8c_BFu9i");
    static Sf_BFu8c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu8c_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu9i(Test_Sf_BFu8c_BFu9i, "Sf_BFu8c_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu9ll  {
  ::empty v1;
  unsigned char v2:8;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu8c_BFu9ll) C1{ FC2{} Fc:8 FL:9}



static void Test_Sf_BFu8c_BFu9ll()
{
  {
    init_simple_test("Sf_BFu8c_BFu9ll");
    static Sf_BFu8c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu8c_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu9ll(Test_Sf_BFu8c_BFu9ll, "Sf_BFu8c_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_BFu9s  {
  ::empty v1;
  unsigned char v2:8;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu8c_BFu9s) C1{ FC2{} Fc:8 Fs:9}



static void Test_Sf_BFu8c_BFu9s()
{
  {
    init_simple_test("Sf_BFu8c_BFu9s");
    static Sf_BFu8c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu8c_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_BFu9s(Test_Sf_BFu8c_BFu9s, "Sf_BFu8c_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_C  {
  ::empty v1;
  unsigned char v2:8;
  char v3;
};
//SIG(1 Sf_BFu8c_C) C1{ FC2{} Fc:8 Fc}



static void Test_Sf_BFu8c_C()
{
  {
    init_simple_test("Sf_BFu8c_C");
    static Sf_BFu8c_C lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu8c_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_C");
    check_field_offset(lv, v3, 2, "Sf_BFu8c_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_C(Test_Sf_BFu8c_C, "Sf_BFu8c_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_D  {
  ::empty v1;
  unsigned char v2:8;
  double v3;
};
//SIG(1 Sf_BFu8c_D) C1{ FC2{} Fc:8 FL}



static void Test_Sf_BFu8c_D()
{
  {
    init_simple_test("Sf_BFu8c_D");
    static Sf_BFu8c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu8c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8c_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_D(Test_Sf_BFu8c_D, "Sf_BFu8c_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_F  {
  ::empty v1;
  unsigned char v2:8;
  float v3;
};
//SIG(1 Sf_BFu8c_F) C1{ FC2{} Fc:8 Fi}



static void Test_Sf_BFu8c_F()
{
  {
    init_simple_test("Sf_BFu8c_F");
    static Sf_BFu8c_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8c_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8c_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_F");
    check_field_offset(lv, v3, 4, "Sf_BFu8c_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_F(Test_Sf_BFu8c_F, "Sf_BFu8c_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_I  {
  ::empty v1;
  unsigned char v2:8;
  int v3;
};
//SIG(1 Sf_BFu8c_I) C1{ FC2{} Fc:8 Fi}



static void Test_Sf_BFu8c_I()
{
  {
    init_simple_test("Sf_BFu8c_I");
    static Sf_BFu8c_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8c_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8c_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_I");
    check_field_offset(lv, v3, 4, "Sf_BFu8c_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_I(Test_Sf_BFu8c_I, "Sf_BFu8c_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_Ip  {
  ::empty v1;
  unsigned char v2:8;
  int *v3;
};
//SIG(1 Sf_BFu8c_Ip) C1{ FC2{} Fc:8 Fp}



static void Test_Sf_BFu8c_Ip()
{
  {
    init_simple_test("Sf_BFu8c_Ip");
    static Sf_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu8c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8c_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_Ip(Test_Sf_BFu8c_Ip, "Sf_BFu8c_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_L  {
  ::empty v1;
  unsigned char v2:8;
  __tsi64 v3;
};
//SIG(1 Sf_BFu8c_L) C1{ FC2{} Fc:8 FL}



static void Test_Sf_BFu8c_L()
{
  {
    init_simple_test("Sf_BFu8c_L");
    static Sf_BFu8c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu8c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8c_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_L(Test_Sf_BFu8c_L, "Sf_BFu8c_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_S  {
  ::empty v1;
  unsigned char v2:8;
  short v3;
};
//SIG(1 Sf_BFu8c_S) C1{ FC2{} Fc:8 Fs}



static void Test_Sf_BFu8c_S()
{
  {
    init_simple_test("Sf_BFu8c_S");
    static Sf_BFu8c_S lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8c_S)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8c_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_S");
    check_field_offset(lv, v3, 2, "Sf_BFu8c_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_S(Test_Sf_BFu8c_S, "Sf_BFu8c_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_Sf  {
  ::empty v1;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 Sf_BFu8c_Sf) C1{ FC2{} Fc:8 FC2}



static void Test_Sf_BFu8c_Sf()
{
  {
    init_simple_test("Sf_BFu8c_Sf");
    static Sf_BFu8c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu8c_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "Sf_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_Sf(Test_Sf_BFu8c_Sf, "Sf_BFu8c_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_Uc  {
  ::empty v1;
  unsigned char v2:8;
  unsigned char v3;
};
//SIG(1 Sf_BFu8c_Uc) C1{ FC2{} Fc:8 Fc}



static void Test_Sf_BFu8c_Uc()
{
  {
    init_simple_test("Sf_BFu8c_Uc");
    static Sf_BFu8c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Sf_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_Uc");
    check_field_offset(lv, v3, 2, "Sf_BFu8c_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_Uc(Test_Sf_BFu8c_Uc, "Sf_BFu8c_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_Ui  {
  ::empty v1;
  unsigned char v2:8;
  unsigned int v3;
};
//SIG(1 Sf_BFu8c_Ui) C1{ FC2{} Fc:8 Fi}



static void Test_Sf_BFu8c_Ui()
{
  {
    init_simple_test("Sf_BFu8c_Ui");
    static Sf_BFu8c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu8c_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_Ui(Test_Sf_BFu8c_Ui, "Sf_BFu8c_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_Ul  {
  ::empty v1;
  unsigned char v2:8;
  __tsu64 v3;
};
//SIG(1 Sf_BFu8c_Ul) C1{ FC2{} Fc:8 FL}



static void Test_Sf_BFu8c_Ul()
{
  {
    init_simple_test("Sf_BFu8c_Ul");
    static Sf_BFu8c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu8c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8c_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_Ul(Test_Sf_BFu8c_Ul, "Sf_BFu8c_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_Us  {
  ::empty v1;
  unsigned char v2:8;
  unsigned short v3;
};
//SIG(1 Sf_BFu8c_Us) C1{ FC2{} Fc:8 Fs}



static void Test_Sf_BFu8c_Us()
{
  {
    init_simple_test("Sf_BFu8c_Us");
    static Sf_BFu8c_Us lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_Us");
    check_field_offset(lv, v3, 2, "Sf_BFu8c_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_Us(Test_Sf_BFu8c_Us, "Sf_BFu8c_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8c_Vp  {
  ::empty v1;
  unsigned char v2:8;
  void *v3;
};
//SIG(1 Sf_BFu8c_Vp) C1{ FC2{} Fc:8 Fp}



static void Test_Sf_BFu8c_Vp()
{
  {
    init_simple_test("Sf_BFu8c_Vp");
    static Sf_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu8c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8c_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu8c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8c_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8c_Vp(Test_Sf_BFu8c_Vp, "Sf_BFu8c_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i  {
  ::empty v1;
  unsigned int v2:8;
};
//SIG(1 Sf_BFu8i) C1{ FC2{} Fi:8}



static void Test_Sf_BFu8i()
{
  {
    init_simple_test("Sf_BFu8i");
    static Sf_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu8i(Test_Sf_BFu8i, "Sf_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu15i  {
  ::empty v1;
  unsigned int v2:8;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu8i_BFu15i) C1{ FC2{} Fi:8 Fi:15}



static void Test_Sf_BFu8i_BFu15i()
{
  {
    init_simple_test("Sf_BFu8i_BFu15i");
    static Sf_BFu8i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu8i_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu15i(Test_Sf_BFu8i_BFu15i, "Sf_BFu8i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu15ll  {
  ::empty v1;
  unsigned int v2:8;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu8i_BFu15ll) C1{ FC2{} Fi:8 FL:15}



static void Test_Sf_BFu8i_BFu15ll()
{
  {
    init_simple_test("Sf_BFu8i_BFu15ll");
    static Sf_BFu8i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu8i_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu15ll(Test_Sf_BFu8i_BFu15ll, "Sf_BFu8i_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu15s  {
  ::empty v1;
  unsigned int v2:8;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu8i_BFu15s) C1{ FC2{} Fi:8 Fs:15}



static void Test_Sf_BFu8i_BFu15s()
{
  {
    init_simple_test("Sf_BFu8i_BFu15s");
    static Sf_BFu8i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu8i_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu15s(Test_Sf_BFu8i_BFu15s, "Sf_BFu8i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu16i  {
  ::empty v1;
  unsigned int v2:8;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu8i_BFu16i) C1{ FC2{} Fi:8 Fi:16}



static void Test_Sf_BFu8i_BFu16i()
{
  {
    init_simple_test("Sf_BFu8i_BFu16i");
    static Sf_BFu8i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu8i_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu16i(Test_Sf_BFu8i_BFu16i, "Sf_BFu8i_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu16ll  {
  ::empty v1;
  unsigned int v2:8;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu8i_BFu16ll) C1{ FC2{} Fi:8 FL:16}



static void Test_Sf_BFu8i_BFu16ll()
{
  {
    init_simple_test("Sf_BFu8i_BFu16ll");
    static Sf_BFu8i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu8i_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu16ll(Test_Sf_BFu8i_BFu16ll, "Sf_BFu8i_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu16s  {
  ::empty v1;
  unsigned int v2:8;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu8i_BFu16s) C1{ FC2{} Fi:8 Fs:16}



static void Test_Sf_BFu8i_BFu16s()
{
  {
    init_simple_test("Sf_BFu8i_BFu16s");
    static Sf_BFu8i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu8i_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu16s(Test_Sf_BFu8i_BFu16s, "Sf_BFu8i_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu17i  {
  ::empty v1;
  unsigned int v2:8;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu8i_BFu17i) C1{ FC2{} Fi:8 Fi:17}



static void Test_Sf_BFu8i_BFu17i()
{
  {
    init_simple_test("Sf_BFu8i_BFu17i");
    static Sf_BFu8i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Sf_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Sf_BFu8i_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu17i(Test_Sf_BFu8i_BFu17i, "Sf_BFu8i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu17ll  {
  ::empty v1;
  unsigned int v2:8;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu8i_BFu17ll) C1{ FC2{} Fi:8 FL:17}



static void Test_Sf_BFu8i_BFu17ll()
{
  {
    init_simple_test("Sf_BFu8i_BFu17ll");
    static Sf_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Sf_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Sf_BFu8i_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu17ll(Test_Sf_BFu8i_BFu17ll, "Sf_BFu8i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu1c  {
  ::empty v1;
  unsigned int v2:8;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu8i_BFu1c) C1{ FC2{} Fi:8 Fc:1}



static void Test_Sf_BFu8i_BFu1c()
{
  {
    init_simple_test("Sf_BFu8i_BFu1c");
    static Sf_BFu8i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8i_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu1c(Test_Sf_BFu8i_BFu1c, "Sf_BFu8i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu1i  {
  ::empty v1;
  unsigned int v2:8;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu8i_BFu1i) C1{ FC2{} Fi:8 Fi:1}



static void Test_Sf_BFu8i_BFu1i()
{
  {
    init_simple_test("Sf_BFu8i_BFu1i");
    static Sf_BFu8i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8i_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu1i(Test_Sf_BFu8i_BFu1i, "Sf_BFu8i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu1ll  {
  ::empty v1;
  unsigned int v2:8;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu8i_BFu1ll) C1{ FC2{} Fi:8 FL:1}



static void Test_Sf_BFu8i_BFu1ll()
{
  {
    init_simple_test("Sf_BFu8i_BFu1ll");
    static Sf_BFu8i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8i_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu1ll(Test_Sf_BFu8i_BFu1ll, "Sf_BFu8i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu1s  {
  ::empty v1;
  unsigned int v2:8;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu8i_BFu1s) C1{ FC2{} Fi:8 Fs:1}



static void Test_Sf_BFu8i_BFu1s()
{
  {
    init_simple_test("Sf_BFu8i_BFu1s");
    static Sf_BFu8i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8i_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu1s(Test_Sf_BFu8i_BFu1s, "Sf_BFu8i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu31i  {
  ::empty v1;
  unsigned int v2:8;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu8i_BFu31i) C1{ FC2{} Fi:8 Fi:31}



static void Test_Sf_BFu8i_BFu31i()
{
  {
    init_simple_test("Sf_BFu8i_BFu31i");
    static Sf_BFu8i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu8i_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu31i(Test_Sf_BFu8i_BFu31i, "Sf_BFu8i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu31ll  {
  ::empty v1;
  unsigned int v2:8;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu8i_BFu31ll) C1{ FC2{} Fi:8 FL:31}



static void Test_Sf_BFu8i_BFu31ll()
{
  {
    init_simple_test("Sf_BFu8i_BFu31ll");
    static Sf_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Sf_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Sf_BFu8i_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu31ll(Test_Sf_BFu8i_BFu31ll, "Sf_BFu8i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu32i  {
  ::empty v1;
  unsigned int v2:8;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu8i_BFu32i) C1{ FC2{} Fi:8 Fi:32}



static void Test_Sf_BFu8i_BFu32i()
{
  {
    init_simple_test("Sf_BFu8i_BFu32i");
    static Sf_BFu8i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu8i_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu32i(Test_Sf_BFu8i_BFu32i, "Sf_BFu8i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu32ll  {
  ::empty v1;
  unsigned int v2:8;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu8i_BFu32ll) C1{ FC2{} Fi:8 FL:32}



static void Test_Sf_BFu8i_BFu32ll()
{
  {
    init_simple_test("Sf_BFu8i_BFu32ll");
    static Sf_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Sf_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Sf_BFu8i_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu32ll(Test_Sf_BFu8i_BFu32ll, "Sf_BFu8i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu33  {
  ::empty v1;
  unsigned int v2:8;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu8i_BFu33) C1{ FC2{} Fi:8 FL:33}



static void Test_Sf_BFu8i_BFu33()
{
  {
    init_simple_test("Sf_BFu8i_BFu33");
    static Sf_BFu8i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "Sf_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "Sf_BFu8i_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu33(Test_Sf_BFu8i_BFu33, "Sf_BFu8i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu7c  {
  ::empty v1;
  unsigned int v2:8;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu8i_BFu7c) C1{ FC2{} Fi:8 Fc:7}



static void Test_Sf_BFu8i_BFu7c()
{
  {
    init_simple_test("Sf_BFu8i_BFu7c");
    static Sf_BFu8i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8i_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu7c(Test_Sf_BFu8i_BFu7c, "Sf_BFu8i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu7i  {
  ::empty v1;
  unsigned int v2:8;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu8i_BFu7i) C1{ FC2{} Fi:8 Fi:7}



static void Test_Sf_BFu8i_BFu7i()
{
  {
    init_simple_test("Sf_BFu8i_BFu7i");
    static Sf_BFu8i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8i_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu7i(Test_Sf_BFu8i_BFu7i, "Sf_BFu8i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu7ll  {
  ::empty v1;
  unsigned int v2:8;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu8i_BFu7ll) C1{ FC2{} Fi:8 FL:7}



static void Test_Sf_BFu8i_BFu7ll()
{
  {
    init_simple_test("Sf_BFu8i_BFu7ll");
    static Sf_BFu8i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8i_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu7ll(Test_Sf_BFu8i_BFu7ll, "Sf_BFu8i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu7s  {
  ::empty v1;
  unsigned int v2:8;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu8i_BFu7s) C1{ FC2{} Fi:8 Fs:7}



static void Test_Sf_BFu8i_BFu7s()
{
  {
    init_simple_test("Sf_BFu8i_BFu7s");
    static Sf_BFu8i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8i_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu7s(Test_Sf_BFu8i_BFu7s, "Sf_BFu8i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu8c  {
  ::empty v1;
  unsigned int v2:8;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu8i_BFu8c) C1{ FC2{} Fi:8 Fc:8}



static void Test_Sf_BFu8i_BFu8c()
{
  {
    init_simple_test("Sf_BFu8i_BFu8c");
    static Sf_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu8c(Test_Sf_BFu8i_BFu8c, "Sf_BFu8i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu8i  {
  ::empty v1;
  unsigned int v2:8;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu8i_BFu8i) C1{ FC2{} Fi:8 Fi:8}



static void Test_Sf_BFu8i_BFu8i()
{
  {
    init_simple_test("Sf_BFu8i_BFu8i");
    static Sf_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu8i(Test_Sf_BFu8i_BFu8i, "Sf_BFu8i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu8ll  {
  ::empty v1;
  unsigned int v2:8;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu8i_BFu8ll) C1{ FC2{} Fi:8 FL:8}



static void Test_Sf_BFu8i_BFu8ll()
{
  {
    init_simple_test("Sf_BFu8i_BFu8ll");
    static Sf_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu8ll(Test_Sf_BFu8i_BFu8ll, "Sf_BFu8i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu8s  {
  ::empty v1;
  unsigned int v2:8;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu8i_BFu8s) C1{ FC2{} Fi:8 Fs:8}



static void Test_Sf_BFu8i_BFu8s()
{
  {
    init_simple_test("Sf_BFu8i_BFu8s");
    static Sf_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu8s(Test_Sf_BFu8i_BFu8s, "Sf_BFu8i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu9i  {
  ::empty v1;
  unsigned int v2:8;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu8i_BFu9i) C1{ FC2{} Fi:8 Fi:9}



static void Test_Sf_BFu8i_BFu9i()
{
  {
    init_simple_test("Sf_BFu8i_BFu9i");
    static Sf_BFu8i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu8i_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu9i(Test_Sf_BFu8i_BFu9i, "Sf_BFu8i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu9ll  {
  ::empty v1;
  unsigned int v2:8;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu8i_BFu9ll) C1{ FC2{} Fi:8 FL:9}



static void Test_Sf_BFu8i_BFu9ll()
{
  {
    init_simple_test("Sf_BFu8i_BFu9ll");
    static Sf_BFu8i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu8i_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu9ll(Test_Sf_BFu8i_BFu9ll, "Sf_BFu8i_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_BFu9s  {
  ::empty v1;
  unsigned int v2:8;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu8i_BFu9s) C1{ FC2{} Fi:8 Fs:9}



static void Test_Sf_BFu8i_BFu9s()
{
  {
    init_simple_test("Sf_BFu8i_BFu9s");
    static Sf_BFu8i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu8i_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_BFu9s(Test_Sf_BFu8i_BFu9s, "Sf_BFu8i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_C  {
  ::empty v1;
  unsigned int v2:8;
  char v3;
};
//SIG(1 Sf_BFu8i_C) C1{ FC2{} Fi:8 Fc}



static void Test_Sf_BFu8i_C()
{
  {
    init_simple_test("Sf_BFu8i_C");
    static Sf_BFu8i_C lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_C");
    check_field_offset(lv, v3, 2, "Sf_BFu8i_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_C(Test_Sf_BFu8i_C, "Sf_BFu8i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_D  {
  ::empty v1;
  unsigned int v2:8;
  double v3;
};
//SIG(1 Sf_BFu8i_D) C1{ FC2{} Fi:8 FL}



static void Test_Sf_BFu8i_D()
{
  {
    init_simple_test("Sf_BFu8i_D");
    static Sf_BFu8i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu8i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8i_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_D(Test_Sf_BFu8i_D, "Sf_BFu8i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_F  {
  ::empty v1;
  unsigned int v2:8;
  float v3;
};
//SIG(1 Sf_BFu8i_F) C1{ FC2{} Fi:8 Fi}



static void Test_Sf_BFu8i_F()
{
  {
    init_simple_test("Sf_BFu8i_F");
    static Sf_BFu8i_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_F");
    check_field_offset(lv, v3, 4, "Sf_BFu8i_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_F(Test_Sf_BFu8i_F, "Sf_BFu8i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_I  {
  ::empty v1;
  unsigned int v2:8;
  int v3;
};
//SIG(1 Sf_BFu8i_I) C1{ FC2{} Fi:8 Fi}



static void Test_Sf_BFu8i_I()
{
  {
    init_simple_test("Sf_BFu8i_I");
    static Sf_BFu8i_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_I");
    check_field_offset(lv, v3, 4, "Sf_BFu8i_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_I(Test_Sf_BFu8i_I, "Sf_BFu8i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_Ip  {
  ::empty v1;
  unsigned int v2:8;
  int *v3;
};
//SIG(1 Sf_BFu8i_Ip) C1{ FC2{} Fi:8 Fp}



static void Test_Sf_BFu8i_Ip()
{
  {
    init_simple_test("Sf_BFu8i_Ip");
    static Sf_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu8i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8i_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_Ip(Test_Sf_BFu8i_Ip, "Sf_BFu8i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_L  {
  ::empty v1;
  unsigned int v2:8;
  __tsi64 v3;
};
//SIG(1 Sf_BFu8i_L) C1{ FC2{} Fi:8 FL}



static void Test_Sf_BFu8i_L()
{
  {
    init_simple_test("Sf_BFu8i_L");
    static Sf_BFu8i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu8i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8i_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_L(Test_Sf_BFu8i_L, "Sf_BFu8i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_S  {
  ::empty v1;
  unsigned int v2:8;
  short v3;
};
//SIG(1 Sf_BFu8i_S) C1{ FC2{} Fi:8 Fs}



static void Test_Sf_BFu8i_S()
{
  {
    init_simple_test("Sf_BFu8i_S");
    static Sf_BFu8i_S lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_S");
    check_field_offset(lv, v3, 2, "Sf_BFu8i_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_S(Test_Sf_BFu8i_S, "Sf_BFu8i_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_Sf  {
  ::empty v1;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 Sf_BFu8i_Sf) C1{ FC2{} Fi:8 FC2}



static void Test_Sf_BFu8i_Sf()
{
  {
    init_simple_test("Sf_BFu8i_Sf");
    static Sf_BFu8i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "Sf_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_Sf(Test_Sf_BFu8i_Sf, "Sf_BFu8i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_Uc  {
  ::empty v1;
  unsigned int v2:8;
  unsigned char v3;
};
//SIG(1 Sf_BFu8i_Uc) C1{ FC2{} Fi:8 Fc}



static void Test_Sf_BFu8i_Uc()
{
  {
    init_simple_test("Sf_BFu8i_Uc");
    static Sf_BFu8i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_Uc");
    check_field_offset(lv, v3, 2, "Sf_BFu8i_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_Uc(Test_Sf_BFu8i_Uc, "Sf_BFu8i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_Ui  {
  ::empty v1;
  unsigned int v2:8;
  unsigned int v3;
};
//SIG(1 Sf_BFu8i_Ui) C1{ FC2{} Fi:8 Fi}



static void Test_Sf_BFu8i_Ui()
{
  {
    init_simple_test("Sf_BFu8i_Ui");
    static Sf_BFu8i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu8i_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_Ui(Test_Sf_BFu8i_Ui, "Sf_BFu8i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_Ul  {
  ::empty v1;
  unsigned int v2:8;
  __tsu64 v3;
};
//SIG(1 Sf_BFu8i_Ul) C1{ FC2{} Fi:8 FL}



static void Test_Sf_BFu8i_Ul()
{
  {
    init_simple_test("Sf_BFu8i_Ul");
    static Sf_BFu8i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu8i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8i_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_Ul(Test_Sf_BFu8i_Ul, "Sf_BFu8i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_Us  {
  ::empty v1;
  unsigned int v2:8;
  unsigned short v3;
};
//SIG(1 Sf_BFu8i_Us) C1{ FC2{} Fi:8 Fs}



static void Test_Sf_BFu8i_Us()
{
  {
    init_simple_test("Sf_BFu8i_Us");
    static Sf_BFu8i_Us lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_Us");
    check_field_offset(lv, v3, 2, "Sf_BFu8i_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_Us(Test_Sf_BFu8i_Us, "Sf_BFu8i_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8i_Vp  {
  ::empty v1;
  unsigned int v2:8;
  void *v3;
};
//SIG(1 Sf_BFu8i_Vp) C1{ FC2{} Fi:8 Fp}



static void Test_Sf_BFu8i_Vp()
{
  {
    init_simple_test("Sf_BFu8i_Vp");
    static Sf_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu8i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8i_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8i_Vp(Test_Sf_BFu8i_Vp, "Sf_BFu8i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll  {
  ::empty v1;
  __tsu64 v2:8;
};
//SIG(1 Sf_BFu8ll) C1{ FC2{} FL:8}



static void Test_Sf_BFu8ll()
{
  {
    init_simple_test("Sf_BFu8ll");
    static Sf_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll(Test_Sf_BFu8ll, "Sf_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu15i  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu8ll_BFu15i) C1{ FC2{} FL:8 Fi:15}



static void Test_Sf_BFu8ll_BFu15i()
{
  {
    init_simple_test("Sf_BFu8ll_BFu15i");
    static Sf_BFu8ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu8ll_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu15i(Test_Sf_BFu8ll_BFu15i, "Sf_BFu8ll_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu15ll  {
  ::empty v1;
  __tsu64 v2:8;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu8ll_BFu15ll) C1{ FC2{} FL:8 FL:15}



static void Test_Sf_BFu8ll_BFu15ll()
{
  {
    init_simple_test("Sf_BFu8ll_BFu15ll");
    static Sf_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu8ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu15ll(Test_Sf_BFu8ll_BFu15ll, "Sf_BFu8ll_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu15s  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu8ll_BFu15s) C1{ FC2{} FL:8 Fs:15}



static void Test_Sf_BFu8ll_BFu15s()
{
  {
    init_simple_test("Sf_BFu8ll_BFu15s");
    static Sf_BFu8ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu8ll_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu15s(Test_Sf_BFu8ll_BFu15s, "Sf_BFu8ll_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu16i  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu8ll_BFu16i) C1{ FC2{} FL:8 Fi:16}



static void Test_Sf_BFu8ll_BFu16i()
{
  {
    init_simple_test("Sf_BFu8ll_BFu16i");
    static Sf_BFu8ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu8ll_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu16i(Test_Sf_BFu8ll_BFu16i, "Sf_BFu8ll_BFu16i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu16ll  {
  ::empty v1;
  __tsu64 v2:8;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu8ll_BFu16ll) C1{ FC2{} FL:8 FL:16}



static void Test_Sf_BFu8ll_BFu16ll()
{
  {
    init_simple_test("Sf_BFu8ll_BFu16ll");
    static Sf_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu8ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu16ll(Test_Sf_BFu8ll_BFu16ll, "Sf_BFu8ll_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu16s  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu8ll_BFu16s) C1{ FC2{} FL:8 Fs:16}



static void Test_Sf_BFu8ll_BFu16s()
{
  {
    init_simple_test("Sf_BFu8ll_BFu16s");
    static Sf_BFu8ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu8ll_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu16s(Test_Sf_BFu8ll_BFu16s, "Sf_BFu8ll_BFu16s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu17i  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu8ll_BFu17i) C1{ FC2{} FL:8 Fi:17}



static void Test_Sf_BFu8ll_BFu17i()
{
  {
    init_simple_test("Sf_BFu8ll_BFu17i");
    static Sf_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Sf_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Sf_BFu8ll_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu17i(Test_Sf_BFu8ll_BFu17i, "Sf_BFu8ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu17ll  {
  ::empty v1;
  __tsu64 v2:8;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu8ll_BFu17ll) C1{ FC2{} FL:8 FL:17}



static void Test_Sf_BFu8ll_BFu17ll()
{
  {
    init_simple_test("Sf_BFu8ll_BFu17ll");
    static Sf_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Sf_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Sf_BFu8ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu17ll(Test_Sf_BFu8ll_BFu17ll, "Sf_BFu8ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu1c  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu8ll_BFu1c) C1{ FC2{} FL:8 Fc:1}



static void Test_Sf_BFu8ll_BFu1c()
{
  {
    init_simple_test("Sf_BFu8ll_BFu1c");
    static Sf_BFu8ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8ll_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu1c(Test_Sf_BFu8ll_BFu1c, "Sf_BFu8ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu1i  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu8ll_BFu1i) C1{ FC2{} FL:8 Fi:1}



static void Test_Sf_BFu8ll_BFu1i()
{
  {
    init_simple_test("Sf_BFu8ll_BFu1i");
    static Sf_BFu8ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8ll_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu1i(Test_Sf_BFu8ll_BFu1i, "Sf_BFu8ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu1ll  {
  ::empty v1;
  __tsu64 v2:8;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu8ll_BFu1ll) C1{ FC2{} FL:8 FL:1}



static void Test_Sf_BFu8ll_BFu1ll()
{
  {
    init_simple_test("Sf_BFu8ll_BFu1ll");
    static Sf_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu1ll(Test_Sf_BFu8ll_BFu1ll, "Sf_BFu8ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu1s  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu8ll_BFu1s) C1{ FC2{} FL:8 Fs:1}



static void Test_Sf_BFu8ll_BFu1s()
{
  {
    init_simple_test("Sf_BFu8ll_BFu1s");
    static Sf_BFu8ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8ll_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu1s(Test_Sf_BFu8ll_BFu1s, "Sf_BFu8ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu31i  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu8ll_BFu31i) C1{ FC2{} FL:8 Fi:31}



static void Test_Sf_BFu8ll_BFu31i()
{
  {
    init_simple_test("Sf_BFu8ll_BFu31i");
    static Sf_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu8ll_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu31i(Test_Sf_BFu8ll_BFu31i, "Sf_BFu8ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu31ll  {
  ::empty v1;
  __tsu64 v2:8;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu8ll_BFu31ll) C1{ FC2{} FL:8 FL:31}



static void Test_Sf_BFu8ll_BFu31ll()
{
  {
    init_simple_test("Sf_BFu8ll_BFu31ll");
    static Sf_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Sf_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Sf_BFu8ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu31ll(Test_Sf_BFu8ll_BFu31ll, "Sf_BFu8ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu32i  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu8ll_BFu32i) C1{ FC2{} FL:8 Fi:32}



static void Test_Sf_BFu8ll_BFu32i()
{
  {
    init_simple_test("Sf_BFu8ll_BFu32i");
    static Sf_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu8ll_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu32i(Test_Sf_BFu8ll_BFu32i, "Sf_BFu8ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu32ll  {
  ::empty v1;
  __tsu64 v2:8;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu8ll_BFu32ll) C1{ FC2{} FL:8 FL:32}



static void Test_Sf_BFu8ll_BFu32ll()
{
  {
    init_simple_test("Sf_BFu8ll_BFu32ll");
    static Sf_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Sf_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Sf_BFu8ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu32ll(Test_Sf_BFu8ll_BFu32ll, "Sf_BFu8ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu33  {
  ::empty v1;
  __tsu64 v2:8;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu8ll_BFu33) C1{ FC2{} FL:8 FL:33}



static void Test_Sf_BFu8ll_BFu33()
{
  {
    init_simple_test("Sf_BFu8ll_BFu33");
    static Sf_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "Sf_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "Sf_BFu8ll_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu33(Test_Sf_BFu8ll_BFu33, "Sf_BFu8ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu7c  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu8ll_BFu7c) C1{ FC2{} FL:8 Fc:7}



static void Test_Sf_BFu8ll_BFu7c()
{
  {
    init_simple_test("Sf_BFu8ll_BFu7c");
    static Sf_BFu8ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8ll_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu7c(Test_Sf_BFu8ll_BFu7c, "Sf_BFu8ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu7i  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu8ll_BFu7i) C1{ FC2{} FL:8 Fi:7}



static void Test_Sf_BFu8ll_BFu7i()
{
  {
    init_simple_test("Sf_BFu8ll_BFu7i");
    static Sf_BFu8ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8ll_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu7i(Test_Sf_BFu8ll_BFu7i, "Sf_BFu8ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu7ll  {
  ::empty v1;
  __tsu64 v2:8;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu8ll_BFu7ll) C1{ FC2{} FL:8 FL:7}



static void Test_Sf_BFu8ll_BFu7ll()
{
  {
    init_simple_test("Sf_BFu8ll_BFu7ll");
    static Sf_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu7ll(Test_Sf_BFu8ll_BFu7ll, "Sf_BFu8ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu7s  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu8ll_BFu7s) C1{ FC2{} FL:8 Fs:7}



static void Test_Sf_BFu8ll_BFu7s()
{
  {
    init_simple_test("Sf_BFu8ll_BFu7s");
    static Sf_BFu8ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8ll_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu7s(Test_Sf_BFu8ll_BFu7s, "Sf_BFu8ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu8c  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu8ll_BFu8c) C1{ FC2{} FL:8 Fc:8}



static void Test_Sf_BFu8ll_BFu8c()
{
  {
    init_simple_test("Sf_BFu8ll_BFu8c");
    static Sf_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu8c(Test_Sf_BFu8ll_BFu8c, "Sf_BFu8ll_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu8i  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu8ll_BFu8i) C1{ FC2{} FL:8 Fi:8}



static void Test_Sf_BFu8ll_BFu8i()
{
  {
    init_simple_test("Sf_BFu8ll_BFu8i");
    static Sf_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu8i(Test_Sf_BFu8ll_BFu8i, "Sf_BFu8ll_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu8ll  {
  ::empty v1;
  __tsu64 v2:8;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu8ll_BFu8ll) C1{ FC2{} FL:8 FL:8}



static void Test_Sf_BFu8ll_BFu8ll()
{
  {
    init_simple_test("Sf_BFu8ll_BFu8ll");
    static Sf_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu8ll(Test_Sf_BFu8ll_BFu8ll, "Sf_BFu8ll_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu8s  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu8ll_BFu8s) C1{ FC2{} FL:8 Fs:8}



static void Test_Sf_BFu8ll_BFu8s()
{
  {
    init_simple_test("Sf_BFu8ll_BFu8s");
    static Sf_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu8s(Test_Sf_BFu8ll_BFu8s, "Sf_BFu8ll_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu9i  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu8ll_BFu9i) C1{ FC2{} FL:8 Fi:9}



static void Test_Sf_BFu8ll_BFu9i()
{
  {
    init_simple_test("Sf_BFu8ll_BFu9i");
    static Sf_BFu8ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu8ll_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu9i(Test_Sf_BFu8ll_BFu9i, "Sf_BFu8ll_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu9ll  {
  ::empty v1;
  __tsu64 v2:8;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu8ll_BFu9ll) C1{ FC2{} FL:8 FL:9}



static void Test_Sf_BFu8ll_BFu9ll()
{
  {
    init_simple_test("Sf_BFu8ll_BFu9ll");
    static Sf_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu8ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu9ll(Test_Sf_BFu8ll_BFu9ll, "Sf_BFu8ll_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_BFu9s  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu8ll_BFu9s) C1{ FC2{} FL:8 Fs:9}



static void Test_Sf_BFu8ll_BFu9s()
{
  {
    init_simple_test("Sf_BFu8ll_BFu9s");
    static Sf_BFu8ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu8ll_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_BFu9s(Test_Sf_BFu8ll_BFu9s, "Sf_BFu8ll_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_C  {
  ::empty v1;
  __tsu64 v2:8;
  char v3;
};
//SIG(1 Sf_BFu8ll_C) C1{ FC2{} FL:8 Fc}



static void Test_Sf_BFu8ll_C()
{
  {
    init_simple_test("Sf_BFu8ll_C");
    static Sf_BFu8ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_C");
    check_field_offset(lv, v3, 2, "Sf_BFu8ll_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_C(Test_Sf_BFu8ll_C, "Sf_BFu8ll_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_D  {
  ::empty v1;
  __tsu64 v2:8;
  double v3;
};
//SIG(1 Sf_BFu8ll_D) C1{ FC2{} FL:8 FL}



static void Test_Sf_BFu8ll_D()
{
  {
    init_simple_test("Sf_BFu8ll_D");
    static Sf_BFu8ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu8ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8ll_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_D(Test_Sf_BFu8ll_D, "Sf_BFu8ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_F  {
  ::empty v1;
  __tsu64 v2:8;
  float v3;
};
//SIG(1 Sf_BFu8ll_F) C1{ FC2{} FL:8 Fi}



static void Test_Sf_BFu8ll_F()
{
  {
    init_simple_test("Sf_BFu8ll_F");
    static Sf_BFu8ll_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_F");
    check_field_offset(lv, v3, 4, "Sf_BFu8ll_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_F(Test_Sf_BFu8ll_F, "Sf_BFu8ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_I  {
  ::empty v1;
  __tsu64 v2:8;
  int v3;
};
//SIG(1 Sf_BFu8ll_I) C1{ FC2{} FL:8 Fi}



static void Test_Sf_BFu8ll_I()
{
  {
    init_simple_test("Sf_BFu8ll_I");
    static Sf_BFu8ll_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_I");
    check_field_offset(lv, v3, 4, "Sf_BFu8ll_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_I(Test_Sf_BFu8ll_I, "Sf_BFu8ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_Ip  {
  ::empty v1;
  __tsu64 v2:8;
  int *v3;
};
//SIG(1 Sf_BFu8ll_Ip) C1{ FC2{} FL:8 Fp}



static void Test_Sf_BFu8ll_Ip()
{
  {
    init_simple_test("Sf_BFu8ll_Ip");
    static Sf_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu8ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_Ip(Test_Sf_BFu8ll_Ip, "Sf_BFu8ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_L  {
  ::empty v1;
  __tsu64 v2:8;
  __tsi64 v3;
};
//SIG(1 Sf_BFu8ll_L) C1{ FC2{} FL:8 FL}



static void Test_Sf_BFu8ll_L()
{
  {
    init_simple_test("Sf_BFu8ll_L");
    static Sf_BFu8ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu8ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8ll_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_L(Test_Sf_BFu8ll_L, "Sf_BFu8ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_S  {
  ::empty v1;
  __tsu64 v2:8;
  short v3;
};
//SIG(1 Sf_BFu8ll_S) C1{ FC2{} FL:8 Fs}



static void Test_Sf_BFu8ll_S()
{
  {
    init_simple_test("Sf_BFu8ll_S");
    static Sf_BFu8ll_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_S");
    check_field_offset(lv, v3, 2, "Sf_BFu8ll_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_S(Test_Sf_BFu8ll_S, "Sf_BFu8ll_S", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_Sf  {
  ::empty v1;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 Sf_BFu8ll_Sf) C1{ FC2{} FL:8 FC2}



static void Test_Sf_BFu8ll_Sf()
{
  {
    init_simple_test("Sf_BFu8ll_Sf");
    static Sf_BFu8ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "Sf_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_Sf(Test_Sf_BFu8ll_Sf, "Sf_BFu8ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_Uc  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned char v3;
};
//SIG(1 Sf_BFu8ll_Uc) C1{ FC2{} FL:8 Fc}



static void Test_Sf_BFu8ll_Uc()
{
  {
    init_simple_test("Sf_BFu8ll_Uc");
    static Sf_BFu8ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_Uc");
    check_field_offset(lv, v3, 2, "Sf_BFu8ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_Uc(Test_Sf_BFu8ll_Uc, "Sf_BFu8ll_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_Ui  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned int v3;
};
//SIG(1 Sf_BFu8ll_Ui) C1{ FC2{} FL:8 Fi}



static void Test_Sf_BFu8ll_Ui()
{
  {
    init_simple_test("Sf_BFu8ll_Ui");
    static Sf_BFu8ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu8ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_Ui(Test_Sf_BFu8ll_Ui, "Sf_BFu8ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_Ul  {
  ::empty v1;
  __tsu64 v2:8;
  __tsu64 v3;
};
//SIG(1 Sf_BFu8ll_Ul) C1{ FC2{} FL:8 FL}



static void Test_Sf_BFu8ll_Ul()
{
  {
    init_simple_test("Sf_BFu8ll_Ul");
    static Sf_BFu8ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu8ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_Ul(Test_Sf_BFu8ll_Ul, "Sf_BFu8ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_Us  {
  ::empty v1;
  __tsu64 v2:8;
  unsigned short v3;
};
//SIG(1 Sf_BFu8ll_Us) C1{ FC2{} FL:8 Fs}



static void Test_Sf_BFu8ll_Us()
{
  {
    init_simple_test("Sf_BFu8ll_Us");
    static Sf_BFu8ll_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_Us");
    check_field_offset(lv, v3, 2, "Sf_BFu8ll_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_Us(Test_Sf_BFu8ll_Us, "Sf_BFu8ll_Us", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8ll_Vp  {
  ::empty v1;
  __tsu64 v2:8;
  void *v3;
};
//SIG(1 Sf_BFu8ll_Vp) C1{ FC2{} FL:8 Fp}



static void Test_Sf_BFu8ll_Vp()
{
  {
    init_simple_test("Sf_BFu8ll_Vp");
    static Sf_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu8ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8ll_Vp(Test_Sf_BFu8ll_Vp, "Sf_BFu8ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s  {
  ::empty v1;
  unsigned short v2:8;
};
//SIG(1 Sf_BFu8s) C1{ FC2{} Fs:8}



static void Test_Sf_BFu8s()
{
  {
    init_simple_test("Sf_BFu8s");
    static Sf_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(Sf_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu8s(Test_Sf_BFu8s, "Sf_BFu8s", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu15i  {
  ::empty v1;
  unsigned short v2:8;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu8s_BFu15i) C1{ FC2{} Fs:8 Fi:15}



static void Test_Sf_BFu8s_BFu15i()
{
  {
    init_simple_test("Sf_BFu8s_BFu15i");
    static Sf_BFu8s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu8s_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu15i(Test_Sf_BFu8s_BFu15i, "Sf_BFu8s_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu15ll  {
  ::empty v1;
  unsigned short v2:8;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu8s_BFu15ll) C1{ FC2{} Fs:8 FL:15}



static void Test_Sf_BFu8s_BFu15ll()
{
  {
    init_simple_test("Sf_BFu8s_BFu15ll");
    static Sf_BFu8s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu8s_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu15ll(Test_Sf_BFu8s_BFu15ll, "Sf_BFu8s_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu15s  {
  ::empty v1;
  unsigned short v2:8;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu8s_BFu15s) C1{ FC2{} Fs:8 Fs:15}



static void Test_Sf_BFu8s_BFu15s()
{
  {
    init_simple_test("Sf_BFu8s_BFu15s");
    static Sf_BFu8s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_BFu8s_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu15s(Test_Sf_BFu8s_BFu15s, "Sf_BFu8s_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu16i  {
  ::empty v1;
  unsigned short v2:8;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu8s_BFu16i) C1{ FC2{} Fs:8 Fi:16}



static void Test_Sf_BFu8s_BFu16i()
{
  {
    init_simple_test("Sf_BFu8s_BFu16i");
    static Sf_BFu8s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu8s_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu16i(Test_Sf_BFu8s_BFu16i, "Sf_BFu8s_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu16ll  {
  ::empty v1;
  unsigned short v2:8;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu8s_BFu16ll) C1{ FC2{} Fs:8 FL:16}



static void Test_Sf_BFu8s_BFu16ll()
{
  {
    init_simple_test("Sf_BFu8s_BFu16ll");
    static Sf_BFu8s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu8s_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu16ll(Test_Sf_BFu8s_BFu16ll, "Sf_BFu8s_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu16s  {
  ::empty v1;
  unsigned short v2:8;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu8s_BFu16s) C1{ FC2{} Fs:8 Fs:16}



static void Test_Sf_BFu8s_BFu16s()
{
  {
    init_simple_test("Sf_BFu8s_BFu16s");
    static Sf_BFu8s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_BFu8s_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu16s(Test_Sf_BFu8s_BFu16s, "Sf_BFu8s_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu17i  {
  ::empty v1;
  unsigned short v2:8;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu8s_BFu17i) C1{ FC2{} Fs:8 Fi:17}



static void Test_Sf_BFu8s_BFu17i()
{
  {
    init_simple_test("Sf_BFu8s_BFu17i");
    static Sf_BFu8s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Sf_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Sf_BFu8s_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu17i(Test_Sf_BFu8s_BFu17i, "Sf_BFu8s_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu17ll  {
  ::empty v1;
  unsigned short v2:8;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu8s_BFu17ll) C1{ FC2{} Fs:8 FL:17}



static void Test_Sf_BFu8s_BFu17ll()
{
  {
    init_simple_test("Sf_BFu8s_BFu17ll");
    static Sf_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Sf_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Sf_BFu8s_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu17ll(Test_Sf_BFu8s_BFu17ll, "Sf_BFu8s_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu1c  {
  ::empty v1;
  unsigned short v2:8;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu8s_BFu1c) C1{ FC2{} Fs:8 Fc:1}



static void Test_Sf_BFu8s_BFu1c()
{
  {
    init_simple_test("Sf_BFu8s_BFu1c");
    static Sf_BFu8s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8s_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu1c(Test_Sf_BFu8s_BFu1c, "Sf_BFu8s_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu1i  {
  ::empty v1;
  unsigned short v2:8;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu8s_BFu1i) C1{ FC2{} Fs:8 Fi:1}



static void Test_Sf_BFu8s_BFu1i()
{
  {
    init_simple_test("Sf_BFu8s_BFu1i");
    static Sf_BFu8s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8s_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu1i(Test_Sf_BFu8s_BFu1i, "Sf_BFu8s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu1ll  {
  ::empty v1;
  unsigned short v2:8;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu8s_BFu1ll) C1{ FC2{} Fs:8 FL:1}



static void Test_Sf_BFu8s_BFu1ll()
{
  {
    init_simple_test("Sf_BFu8s_BFu1ll");
    static Sf_BFu8s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8s_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu1ll(Test_Sf_BFu8s_BFu1ll, "Sf_BFu8s_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu1s  {
  ::empty v1;
  unsigned short v2:8;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu8s_BFu1s) C1{ FC2{} Fs:8 Fs:1}



static void Test_Sf_BFu8s_BFu1s()
{
  {
    init_simple_test("Sf_BFu8s_BFu1s");
    static Sf_BFu8s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_BFu8s_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu1s(Test_Sf_BFu8s_BFu1s, "Sf_BFu8s_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu31i  {
  ::empty v1;
  unsigned short v2:8;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu8s_BFu31i) C1{ FC2{} Fs:8 Fi:31}



static void Test_Sf_BFu8s_BFu31i()
{
  {
    init_simple_test("Sf_BFu8s_BFu31i");
    static Sf_BFu8s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu8s_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu31i(Test_Sf_BFu8s_BFu31i, "Sf_BFu8s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu31ll  {
  ::empty v1;
  unsigned short v2:8;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu8s_BFu31ll) C1{ FC2{} Fs:8 FL:31}



static void Test_Sf_BFu8s_BFu31ll()
{
  {
    init_simple_test("Sf_BFu8s_BFu31ll");
    static Sf_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Sf_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Sf_BFu8s_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu31ll(Test_Sf_BFu8s_BFu31ll, "Sf_BFu8s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu32i  {
  ::empty v1;
  unsigned short v2:8;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu8s_BFu32i) C1{ FC2{} Fs:8 Fi:32}



static void Test_Sf_BFu8s_BFu32i()
{
  {
    init_simple_test("Sf_BFu8s_BFu32i");
    static Sf_BFu8s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu8s_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu32i(Test_Sf_BFu8s_BFu32i, "Sf_BFu8s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu32ll  {
  ::empty v1;
  unsigned short v2:8;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu8s_BFu32ll) C1{ FC2{} Fs:8 FL:32}



static void Test_Sf_BFu8s_BFu32ll()
{
  {
    init_simple_test("Sf_BFu8s_BFu32ll");
    static Sf_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Sf_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Sf_BFu8s_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu32ll(Test_Sf_BFu8s_BFu32ll, "Sf_BFu8s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu33  {
  ::empty v1;
  unsigned short v2:8;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu8s_BFu33) C1{ FC2{} Fs:8 FL:33}



static void Test_Sf_BFu8s_BFu33()
{
  {
    init_simple_test("Sf_BFu8s_BFu33");
    static Sf_BFu8s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "Sf_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "Sf_BFu8s_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu33(Test_Sf_BFu8s_BFu33, "Sf_BFu8s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu7c  {
  ::empty v1;
  unsigned short v2:8;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu8s_BFu7c) C1{ FC2{} Fs:8 Fc:7}



static void Test_Sf_BFu8s_BFu7c()
{
  {
    init_simple_test("Sf_BFu8s_BFu7c");
    static Sf_BFu8s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8s_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu7c(Test_Sf_BFu8s_BFu7c, "Sf_BFu8s_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu7i  {
  ::empty v1;
  unsigned short v2:8;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu8s_BFu7i) C1{ FC2{} Fs:8 Fi:7}



static void Test_Sf_BFu8s_BFu7i()
{
  {
    init_simple_test("Sf_BFu8s_BFu7i");
    static Sf_BFu8s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8s_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu7i(Test_Sf_BFu8s_BFu7i, "Sf_BFu8s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu7ll  {
  ::empty v1;
  unsigned short v2:8;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu8s_BFu7ll) C1{ FC2{} Fs:8 FL:7}



static void Test_Sf_BFu8s_BFu7ll()
{
  {
    init_simple_test("Sf_BFu8s_BFu7ll");
    static Sf_BFu8s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8s_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu7ll(Test_Sf_BFu8s_BFu7ll, "Sf_BFu8s_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu7s  {
  ::empty v1;
  unsigned short v2:8;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu8s_BFu7s) C1{ FC2{} Fs:8 Fs:7}



static void Test_Sf_BFu8s_BFu7s()
{
  {
    init_simple_test("Sf_BFu8s_BFu7s");
    static Sf_BFu8s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_BFu8s_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu7s(Test_Sf_BFu8s_BFu7s, "Sf_BFu8s_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu8c  {
  ::empty v1;
  unsigned short v2:8;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu8s_BFu8c) C1{ FC2{} Fs:8 Fc:8}



static void Test_Sf_BFu8s_BFu8c()
{
  {
    init_simple_test("Sf_BFu8s_BFu8c");
    static Sf_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu8c(Test_Sf_BFu8s_BFu8c, "Sf_BFu8s_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu8i  {
  ::empty v1;
  unsigned short v2:8;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu8s_BFu8i) C1{ FC2{} Fs:8 Fi:8}



static void Test_Sf_BFu8s_BFu8i()
{
  {
    init_simple_test("Sf_BFu8s_BFu8i");
    static Sf_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu8i(Test_Sf_BFu8s_BFu8i, "Sf_BFu8s_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu8ll  {
  ::empty v1;
  unsigned short v2:8;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu8s_BFu8ll) C1{ FC2{} Fs:8 FL:8}



static void Test_Sf_BFu8s_BFu8ll()
{
  {
    init_simple_test("Sf_BFu8s_BFu8ll");
    static Sf_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu8ll(Test_Sf_BFu8s_BFu8ll, "Sf_BFu8s_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu8s  {
  ::empty v1;
  unsigned short v2:8;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu8s_BFu8s) C1{ FC2{} Fs:8 Fs:8}



static void Test_Sf_BFu8s_BFu8s()
{
  {
    init_simple_test("Sf_BFu8s_BFu8s");
    static Sf_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu8s(Test_Sf_BFu8s_BFu8s, "Sf_BFu8s_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu9i  {
  ::empty v1;
  unsigned short v2:8;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu8s_BFu9i) C1{ FC2{} Fs:8 Fi:9}



static void Test_Sf_BFu8s_BFu9i()
{
  {
    init_simple_test("Sf_BFu8s_BFu9i");
    static Sf_BFu8s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu8s_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu9i(Test_Sf_BFu8s_BFu9i, "Sf_BFu8s_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu9ll  {
  ::empty v1;
  unsigned short v2:8;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu8s_BFu9ll) C1{ FC2{} Fs:8 FL:9}



static void Test_Sf_BFu8s_BFu9ll()
{
  {
    init_simple_test("Sf_BFu8s_BFu9ll");
    static Sf_BFu8s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu8s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu8s_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu9ll(Test_Sf_BFu8s_BFu9ll, "Sf_BFu8s_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_BFu9s  {
  ::empty v1;
  unsigned short v2:8;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu8s_BFu9s) C1{ FC2{} Fs:8 Fs:9}



static void Test_Sf_BFu8s_BFu9s()
{
  {
    init_simple_test("Sf_BFu8s_BFu9s");
    static Sf_BFu8s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu8s_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_BFu9s(Test_Sf_BFu8s_BFu9s, "Sf_BFu8s_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_C  {
  ::empty v1;
  unsigned short v2:8;
  char v3;
};
//SIG(1 Sf_BFu8s_C) C1{ FC2{} Fs:8 Fc}



static void Test_Sf_BFu8s_C()
{
  {
    init_simple_test("Sf_BFu8s_C");
    static Sf_BFu8s_C lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_C)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_C");
    check_field_offset(lv, v3, 2, "Sf_BFu8s_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_C(Test_Sf_BFu8s_C, "Sf_BFu8s_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_D  {
  ::empty v1;
  unsigned short v2:8;
  double v3;
};
//SIG(1 Sf_BFu8s_D) C1{ FC2{} Fs:8 FL}



static void Test_Sf_BFu8s_D()
{
  {
    init_simple_test("Sf_BFu8s_D");
    static Sf_BFu8s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu8s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8s_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_D(Test_Sf_BFu8s_D, "Sf_BFu8s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_F  {
  ::empty v1;
  unsigned short v2:8;
  float v3;
};
//SIG(1 Sf_BFu8s_F) C1{ FC2{} Fs:8 Fi}



static void Test_Sf_BFu8s_F()
{
  {
    init_simple_test("Sf_BFu8s_F");
    static Sf_BFu8s_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8s_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8s_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_F");
    check_field_offset(lv, v3, 4, "Sf_BFu8s_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_F(Test_Sf_BFu8s_F, "Sf_BFu8s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_I  {
  ::empty v1;
  unsigned short v2:8;
  int v3;
};
//SIG(1 Sf_BFu8s_I) C1{ FC2{} Fs:8 Fi}



static void Test_Sf_BFu8s_I()
{
  {
    init_simple_test("Sf_BFu8s_I");
    static Sf_BFu8s_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8s_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8s_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_I");
    check_field_offset(lv, v3, 4, "Sf_BFu8s_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_I(Test_Sf_BFu8s_I, "Sf_BFu8s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_Ip  {
  ::empty v1;
  unsigned short v2:8;
  int *v3;
};
//SIG(1 Sf_BFu8s_Ip) C1{ FC2{} Fs:8 Fp}



static void Test_Sf_BFu8s_Ip()
{
  {
    init_simple_test("Sf_BFu8s_Ip");
    static Sf_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu8s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8s_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_Ip(Test_Sf_BFu8s_Ip, "Sf_BFu8s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_L  {
  ::empty v1;
  unsigned short v2:8;
  __tsi64 v3;
};
//SIG(1 Sf_BFu8s_L) C1{ FC2{} Fs:8 FL}



static void Test_Sf_BFu8s_L()
{
  {
    init_simple_test("Sf_BFu8s_L");
    static Sf_BFu8s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu8s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8s_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_L(Test_Sf_BFu8s_L, "Sf_BFu8s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_S  {
  ::empty v1;
  unsigned short v2:8;
  short v3;
};
//SIG(1 Sf_BFu8s_S) C1{ FC2{} Fs:8 Fs}



static void Test_Sf_BFu8s_S()
{
  {
    init_simple_test("Sf_BFu8s_S");
    static Sf_BFu8s_S lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_S)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_S");
    check_field_offset(lv, v3, 2, "Sf_BFu8s_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_S(Test_Sf_BFu8s_S, "Sf_BFu8s_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_Sf  {
  ::empty v1;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 Sf_BFu8s_Sf) C1{ FC2{} Fs:8 FC2}



static void Test_Sf_BFu8s_Sf()
{
  {
    init_simple_test("Sf_BFu8s_Sf");
    static Sf_BFu8s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "Sf_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_Sf(Test_Sf_BFu8s_Sf, "Sf_BFu8s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_Uc  {
  ::empty v1;
  unsigned short v2:8;
  unsigned char v3;
};
//SIG(1 Sf_BFu8s_Uc) C1{ FC2{} Fs:8 Fc}



static void Test_Sf_BFu8s_Uc()
{
  {
    init_simple_test("Sf_BFu8s_Uc");
    static Sf_BFu8s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_Uc");
    check_field_offset(lv, v3, 2, "Sf_BFu8s_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_Uc(Test_Sf_BFu8s_Uc, "Sf_BFu8s_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_Ui  {
  ::empty v1;
  unsigned short v2:8;
  unsigned int v3;
};
//SIG(1 Sf_BFu8s_Ui) C1{ FC2{} Fs:8 Fi}



static void Test_Sf_BFu8s_Ui()
{
  {
    init_simple_test("Sf_BFu8s_Ui");
    static Sf_BFu8s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu8s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu8s_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_Ui(Test_Sf_BFu8s_Ui, "Sf_BFu8s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_Ul  {
  ::empty v1;
  unsigned short v2:8;
  __tsu64 v3;
};
//SIG(1 Sf_BFu8s_Ul) C1{ FC2{} Fs:8 FL}



static void Test_Sf_BFu8s_Ul()
{
  {
    init_simple_test("Sf_BFu8s_Ul");
    static Sf_BFu8s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu8s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8s_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_Ul(Test_Sf_BFu8s_Ul, "Sf_BFu8s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_Us  {
  ::empty v1;
  unsigned short v2:8;
  unsigned short v3;
};
//SIG(1 Sf_BFu8s_Us) C1{ FC2{} Fs:8 Fs}



static void Test_Sf_BFu8s_Us()
{
  {
    init_simple_test("Sf_BFu8s_Us");
    static Sf_BFu8s_Us lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu8s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_Us");
    check_field_offset(lv, v3, 2, "Sf_BFu8s_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_Us(Test_Sf_BFu8s_Us, "Sf_BFu8s_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu8s_Vp  {
  ::empty v1;
  unsigned short v2:8;
  void *v3;
};
//SIG(1 Sf_BFu8s_Vp) C1{ FC2{} Fs:8 Fp}



static void Test_Sf_BFu8s_Vp()
{
  {
    init_simple_test("Sf_BFu8s_Vp");
    static Sf_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu8s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "Sf_BFu8s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "Sf_BFu8s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu8s_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu8s_Vp(Test_Sf_BFu8s_Vp, "Sf_BFu8s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i  {
  ::empty v1;
  unsigned int v2:9;
};
//SIG(1 Sf_BFu9i) C1{ FC2{} Fi:9}



static void Test_Sf_BFu9i()
{
  {
    init_simple_test("Sf_BFu9i");
    static Sf_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu9i(Test_Sf_BFu9i, "Sf_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu15i  {
  ::empty v1;
  unsigned int v2:9;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu9i_BFu15i) C1{ FC2{} Fi:9 Fi:15}



static void Test_Sf_BFu9i_BFu15i()
{
  {
    init_simple_test("Sf_BFu9i_BFu15i");
    static Sf_BFu9i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Sf_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Sf_BFu9i_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu15i(Test_Sf_BFu9i_BFu15i, "Sf_BFu9i_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu15ll  {
  ::empty v1;
  unsigned int v2:9;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu9i_BFu15ll) C1{ FC2{} Fi:9 FL:15}



static void Test_Sf_BFu9i_BFu15ll()
{
  {
    init_simple_test("Sf_BFu9i_BFu15ll");
    static Sf_BFu9i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Sf_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Sf_BFu9i_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu15ll(Test_Sf_BFu9i_BFu15ll, "Sf_BFu9i_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu15s  {
  ::empty v1;
  unsigned int v2:9;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu9i_BFu15s) C1{ FC2{} Fi:9 Fs:15}



static void Test_Sf_BFu9i_BFu15s()
{
  {
    init_simple_test("Sf_BFu9i_BFu15s");
    static Sf_BFu9i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Sf_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Sf_BFu9i_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu15s(Test_Sf_BFu9i_BFu15s, "Sf_BFu9i_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu16i  {
  ::empty v1;
  unsigned int v2:9;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu9i_BFu16i) C1{ FC2{} Fi:9 Fi:16}



static void Test_Sf_BFu9i_BFu16i()
{
  {
    init_simple_test("Sf_BFu9i_BFu16i");
    static Sf_BFu9i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu9i_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu16i(Test_Sf_BFu9i_BFu16i, "Sf_BFu9i_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu16ll  {
  ::empty v1;
  unsigned int v2:9;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu9i_BFu16ll) C1{ FC2{} Fi:9 FL:16}



static void Test_Sf_BFu9i_BFu16ll()
{
  {
    init_simple_test("Sf_BFu9i_BFu16ll");
    static Sf_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Sf_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Sf_BFu9i_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu16ll(Test_Sf_BFu9i_BFu16ll, "Sf_BFu9i_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu16s  {
  ::empty v1;
  unsigned int v2:9;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu9i_BFu16s) C1{ FC2{} Fi:9 Fs:16}



static void Test_Sf_BFu9i_BFu16s()
{
  {
    init_simple_test("Sf_BFu9i_BFu16s");
    static Sf_BFu9i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu9i_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu16s(Test_Sf_BFu9i_BFu16s, "Sf_BFu9i_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu17i  {
  ::empty v1;
  unsigned int v2:9;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu9i_BFu17i) C1{ FC2{} Fi:9 Fi:17}



static void Test_Sf_BFu9i_BFu17i()
{
  {
    init_simple_test("Sf_BFu9i_BFu17i");
    static Sf_BFu9i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Sf_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Sf_BFu9i_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu17i(Test_Sf_BFu9i_BFu17i, "Sf_BFu9i_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu17ll  {
  ::empty v1;
  unsigned int v2:9;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu9i_BFu17ll) C1{ FC2{} Fi:9 FL:17}



static void Test_Sf_BFu9i_BFu17ll()
{
  {
    init_simple_test("Sf_BFu9i_BFu17ll");
    static Sf_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "Sf_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "Sf_BFu9i_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu17ll(Test_Sf_BFu9i_BFu17ll, "Sf_BFu9i_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu1c  {
  ::empty v1;
  unsigned int v2:9;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu9i_BFu1c) C1{ FC2{} Fi:9 Fc:1}



static void Test_Sf_BFu9i_BFu1c()
{
  {
    init_simple_test("Sf_BFu9i_BFu1c");
    static Sf_BFu9i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Sf_BFu9i_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu1c(Test_Sf_BFu9i_BFu1c, "Sf_BFu9i_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu1i  {
  ::empty v1;
  unsigned int v2:9;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu9i_BFu1i) C1{ FC2{} Fi:9 Fi:1}



static void Test_Sf_BFu9i_BFu1i()
{
  {
    init_simple_test("Sf_BFu9i_BFu1i");
    static Sf_BFu9i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Sf_BFu9i_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu1i(Test_Sf_BFu9i_BFu1i, "Sf_BFu9i_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu1ll  {
  ::empty v1;
  unsigned int v2:9;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu9i_BFu1ll) C1{ FC2{} Fi:9 FL:1}



static void Test_Sf_BFu9i_BFu1ll()
{
  {
    init_simple_test("Sf_BFu9i_BFu1ll");
    static Sf_BFu9i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Sf_BFu9i_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu1ll(Test_Sf_BFu9i_BFu1ll, "Sf_BFu9i_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu1s  {
  ::empty v1;
  unsigned int v2:9;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu9i_BFu1s) C1{ FC2{} Fi:9 Fs:1}



static void Test_Sf_BFu9i_BFu1s()
{
  {
    init_simple_test("Sf_BFu9i_BFu1s");
    static Sf_BFu9i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Sf_BFu9i_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu1s(Test_Sf_BFu9i_BFu1s, "Sf_BFu9i_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu31i  {
  ::empty v1;
  unsigned int v2:9;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu9i_BFu31i) C1{ FC2{} Fi:9 Fi:31}



static void Test_Sf_BFu9i_BFu31i()
{
  {
    init_simple_test("Sf_BFu9i_BFu31i");
    static Sf_BFu9i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu9i_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu31i(Test_Sf_BFu9i_BFu31i, "Sf_BFu9i_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu31ll  {
  ::empty v1;
  unsigned int v2:9;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu9i_BFu31ll) C1{ FC2{} Fi:9 FL:31}



static void Test_Sf_BFu9i_BFu31ll()
{
  {
    init_simple_test("Sf_BFu9i_BFu31ll");
    static Sf_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "Sf_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "Sf_BFu9i_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu31ll(Test_Sf_BFu9i_BFu31ll, "Sf_BFu9i_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu32i  {
  ::empty v1;
  unsigned int v2:9;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu9i_BFu32i) C1{ FC2{} Fi:9 Fi:32}



static void Test_Sf_BFu9i_BFu32i()
{
  {
    init_simple_test("Sf_BFu9i_BFu32i");
    static Sf_BFu9i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu9i_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu32i(Test_Sf_BFu9i_BFu32i, "Sf_BFu9i_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu32ll  {
  ::empty v1;
  unsigned int v2:9;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu9i_BFu32ll) C1{ FC2{} Fi:9 FL:32}



static void Test_Sf_BFu9i_BFu32ll()
{
  {
    init_simple_test("Sf_BFu9i_BFu32ll");
    static Sf_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "Sf_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "Sf_BFu9i_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu32ll(Test_Sf_BFu9i_BFu32ll, "Sf_BFu9i_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu33  {
  ::empty v1;
  unsigned int v2:9;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu9i_BFu33) C1{ FC2{} Fi:9 FL:33}



static void Test_Sf_BFu9i_BFu33()
{
  {
    init_simple_test("Sf_BFu9i_BFu33");
    static Sf_BFu9i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "Sf_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "Sf_BFu9i_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu33(Test_Sf_BFu9i_BFu33, "Sf_BFu9i_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu7c  {
  ::empty v1;
  unsigned int v2:9;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu9i_BFu7c) C1{ FC2{} Fi:9 Fc:7}



static void Test_Sf_BFu9i_BFu7c()
{
  {
    init_simple_test("Sf_BFu9i_BFu7c");
    static Sf_BFu9i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Sf_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Sf_BFu9i_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu7c(Test_Sf_BFu9i_BFu7c, "Sf_BFu9i_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu7i  {
  ::empty v1;
  unsigned int v2:9;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu9i_BFu7i) C1{ FC2{} Fi:9 Fi:7}



static void Test_Sf_BFu9i_BFu7i()
{
  {
    init_simple_test("Sf_BFu9i_BFu7i");
    static Sf_BFu9i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Sf_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Sf_BFu9i_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu7i(Test_Sf_BFu9i_BFu7i, "Sf_BFu9i_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu7ll  {
  ::empty v1;
  unsigned int v2:9;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu9i_BFu7ll) C1{ FC2{} Fi:9 FL:7}



static void Test_Sf_BFu9i_BFu7ll()
{
  {
    init_simple_test("Sf_BFu9i_BFu7ll");
    static Sf_BFu9i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Sf_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Sf_BFu9i_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu7ll(Test_Sf_BFu9i_BFu7ll, "Sf_BFu9i_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu7s  {
  ::empty v1;
  unsigned int v2:9;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu9i_BFu7s) C1{ FC2{} Fi:9 Fs:7}



static void Test_Sf_BFu9i_BFu7s()
{
  {
    init_simple_test("Sf_BFu9i_BFu7s");
    static Sf_BFu9i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Sf_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Sf_BFu9i_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu7s(Test_Sf_BFu9i_BFu7s, "Sf_BFu9i_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu8c  {
  ::empty v1;
  unsigned int v2:9;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu9i_BFu8c) C1{ FC2{} Fi:9 Fc:8}



static void Test_Sf_BFu9i_BFu8c()
{
  {
    init_simple_test("Sf_BFu9i_BFu8c");
    static Sf_BFu9i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Sf_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Sf_BFu9i_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu8c(Test_Sf_BFu9i_BFu8c, "Sf_BFu9i_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu8i  {
  ::empty v1;
  unsigned int v2:9;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu9i_BFu8i) C1{ FC2{} Fi:9 Fi:8}



static void Test_Sf_BFu9i_BFu8i()
{
  {
    init_simple_test("Sf_BFu9i_BFu8i");
    static Sf_BFu9i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Sf_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Sf_BFu9i_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu8i(Test_Sf_BFu9i_BFu8i, "Sf_BFu9i_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu8ll  {
  ::empty v1;
  unsigned int v2:9;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu9i_BFu8ll) C1{ FC2{} Fi:9 FL:8}



static void Test_Sf_BFu9i_BFu8ll()
{
  {
    init_simple_test("Sf_BFu9i_BFu8ll");
    static Sf_BFu9i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Sf_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Sf_BFu9i_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu8ll(Test_Sf_BFu9i_BFu8ll, "Sf_BFu9i_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu8s  {
  ::empty v1;
  unsigned int v2:9;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu9i_BFu8s) C1{ FC2{} Fi:9 Fs:8}



static void Test_Sf_BFu9i_BFu8s()
{
  {
    init_simple_test("Sf_BFu9i_BFu8s");
    static Sf_BFu9i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Sf_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Sf_BFu9i_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu8s(Test_Sf_BFu9i_BFu8s, "Sf_BFu9i_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu9i  {
  ::empty v1;
  unsigned int v2:9;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu9i_BFu9i) C1{ FC2{} Fi:9 Fi:9}



static void Test_Sf_BFu9i_BFu9i()
{
  {
    init_simple_test("Sf_BFu9i_BFu9i");
    static Sf_BFu9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Sf_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu9i(Test_Sf_BFu9i_BFu9i, "Sf_BFu9i_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu9ll  {
  ::empty v1;
  unsigned int v2:9;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu9i_BFu9ll) C1{ FC2{} Fi:9 FL:9}



static void Test_Sf_BFu9i_BFu9ll()
{
  {
    init_simple_test("Sf_BFu9i_BFu9ll");
    static Sf_BFu9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Sf_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu9ll(Test_Sf_BFu9i_BFu9ll, "Sf_BFu9i_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_BFu9s  {
  ::empty v1;
  unsigned int v2:9;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu9i_BFu9s) C1{ FC2{} Fi:9 Fs:9}



static void Test_Sf_BFu9i_BFu9s()
{
  {
    init_simple_test("Sf_BFu9i_BFu9s");
    static Sf_BFu9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Sf_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Sf_BFu9i_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_BFu9s(Test_Sf_BFu9i_BFu9s, "Sf_BFu9i_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_C  {
  ::empty v1;
  unsigned int v2:9;
  char v3;
};
//SIG(1 Sf_BFu9i_C) C1{ FC2{} Fi:9 Fc}



static void Test_Sf_BFu9i_C()
{
  {
    init_simple_test("Sf_BFu9i_C");
    static Sf_BFu9i_C lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_C");
    check_field_offset(lv, v3, 3, "Sf_BFu9i_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_C(Test_Sf_BFu9i_C, "Sf_BFu9i_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_D  {
  ::empty v1;
  unsigned int v2:9;
  double v3;
};
//SIG(1 Sf_BFu9i_D) C1{ FC2{} Fi:9 FL}



static void Test_Sf_BFu9i_D()
{
  {
    init_simple_test("Sf_BFu9i_D");
    static Sf_BFu9i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu9i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9i_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_D(Test_Sf_BFu9i_D, "Sf_BFu9i_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_F  {
  ::empty v1;
  unsigned int v2:9;
  float v3;
};
//SIG(1 Sf_BFu9i_F) C1{ FC2{} Fi:9 Fi}



static void Test_Sf_BFu9i_F()
{
  {
    init_simple_test("Sf_BFu9i_F");
    static Sf_BFu9i_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_F");
    check_field_offset(lv, v3, 4, "Sf_BFu9i_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_F(Test_Sf_BFu9i_F, "Sf_BFu9i_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_I  {
  ::empty v1;
  unsigned int v2:9;
  int v3;
};
//SIG(1 Sf_BFu9i_I) C1{ FC2{} Fi:9 Fi}



static void Test_Sf_BFu9i_I()
{
  {
    init_simple_test("Sf_BFu9i_I");
    static Sf_BFu9i_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_I");
    check_field_offset(lv, v3, 4, "Sf_BFu9i_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_I(Test_Sf_BFu9i_I, "Sf_BFu9i_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_Ip  {
  ::empty v1;
  unsigned int v2:9;
  int *v3;
};
//SIG(1 Sf_BFu9i_Ip) C1{ FC2{} Fi:9 Fp}



static void Test_Sf_BFu9i_Ip()
{
  {
    init_simple_test("Sf_BFu9i_Ip");
    static Sf_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu9i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9i_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_Ip(Test_Sf_BFu9i_Ip, "Sf_BFu9i_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_L  {
  ::empty v1;
  unsigned int v2:9;
  __tsi64 v3;
};
//SIG(1 Sf_BFu9i_L) C1{ FC2{} Fi:9 FL}



static void Test_Sf_BFu9i_L()
{
  {
    init_simple_test("Sf_BFu9i_L");
    static Sf_BFu9i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu9i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9i_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_L(Test_Sf_BFu9i_L, "Sf_BFu9i_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_S  {
  ::empty v1;
  unsigned int v2:9;
  short v3;
};
//SIG(1 Sf_BFu9i_S) C1{ FC2{} Fi:9 Fs}



static void Test_Sf_BFu9i_S()
{
  {
    init_simple_test("Sf_BFu9i_S");
    static Sf_BFu9i_S lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_S");
    check_field_offset(lv, v3, 4, "Sf_BFu9i_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_S(Test_Sf_BFu9i_S, "Sf_BFu9i_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_Sf  {
  ::empty v1;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 Sf_BFu9i_Sf) C1{ FC2{} Fi:9 FC2}



static void Test_Sf_BFu9i_Sf()
{
  {
    init_simple_test("Sf_BFu9i_Sf");
    static Sf_BFu9i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_Sf");
    check_field_offset(lv, v3, 3, "Sf_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_Sf(Test_Sf_BFu9i_Sf, "Sf_BFu9i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_Uc  {
  ::empty v1;
  unsigned int v2:9;
  unsigned char v3;
};
//SIG(1 Sf_BFu9i_Uc) C1{ FC2{} Fi:9 Fc}



static void Test_Sf_BFu9i_Uc()
{
  {
    init_simple_test("Sf_BFu9i_Uc");
    static Sf_BFu9i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_Uc");
    check_field_offset(lv, v3, 3, "Sf_BFu9i_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_Uc(Test_Sf_BFu9i_Uc, "Sf_BFu9i_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_Ui  {
  ::empty v1;
  unsigned int v2:9;
  unsigned int v3;
};
//SIG(1 Sf_BFu9i_Ui) C1{ FC2{} Fi:9 Fi}



static void Test_Sf_BFu9i_Ui()
{
  {
    init_simple_test("Sf_BFu9i_Ui");
    static Sf_BFu9i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu9i_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_Ui(Test_Sf_BFu9i_Ui, "Sf_BFu9i_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_Ul  {
  ::empty v1;
  unsigned int v2:9;
  __tsu64 v3;
};
//SIG(1 Sf_BFu9i_Ul) C1{ FC2{} Fi:9 FL}



static void Test_Sf_BFu9i_Ul()
{
  {
    init_simple_test("Sf_BFu9i_Ul");
    static Sf_BFu9i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu9i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9i_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_Ul(Test_Sf_BFu9i_Ul, "Sf_BFu9i_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_Us  {
  ::empty v1;
  unsigned int v2:9;
  unsigned short v3;
};
//SIG(1 Sf_BFu9i_Us) C1{ FC2{} Fi:9 Fs}



static void Test_Sf_BFu9i_Us()
{
  {
    init_simple_test("Sf_BFu9i_Us");
    static Sf_BFu9i_Us lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_Us");
    check_field_offset(lv, v3, 4, "Sf_BFu9i_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_Us(Test_Sf_BFu9i_Us, "Sf_BFu9i_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9i_Vp  {
  ::empty v1;
  unsigned int v2:9;
  void *v3;
};
//SIG(1 Sf_BFu9i_Vp) C1{ FC2{} Fi:9 Fp}



static void Test_Sf_BFu9i_Vp()
{
  {
    init_simple_test("Sf_BFu9i_Vp");
    static Sf_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu9i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9i_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9i_Vp(Test_Sf_BFu9i_Vp, "Sf_BFu9i_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll  {
  ::empty v1;
  __tsu64 v2:9;
};
//SIG(1 Sf_BFu9ll) C1{ FC2{} FL:9}



static void Test_Sf_BFu9ll()
{
  {
    init_simple_test("Sf_BFu9ll");
    static Sf_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll(Test_Sf_BFu9ll, "Sf_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu15i  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu9ll_BFu15i) C1{ FC2{} FL:9 Fi:15}



static void Test_Sf_BFu9ll_BFu15i()
{
  {
    init_simple_test("Sf_BFu9ll_BFu15i");
    static Sf_BFu9ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Sf_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Sf_BFu9ll_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu15i(Test_Sf_BFu9ll_BFu15i, "Sf_BFu9ll_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu15ll  {
  ::empty v1;
  __tsu64 v2:9;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu9ll_BFu15ll) C1{ FC2{} FL:9 FL:15}



static void Test_Sf_BFu9ll_BFu15ll()
{
  {
    init_simple_test("Sf_BFu9ll_BFu15ll");
    static Sf_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Sf_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Sf_BFu9ll_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu15ll(Test_Sf_BFu9ll_BFu15ll, "Sf_BFu9ll_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu15s  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu9ll_BFu15s) C1{ FC2{} FL:9 Fs:15}



static void Test_Sf_BFu9ll_BFu15s()
{
  {
    init_simple_test("Sf_BFu9ll_BFu15s");
    static Sf_BFu9ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Sf_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Sf_BFu9ll_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu15s(Test_Sf_BFu9ll_BFu15s, "Sf_BFu9ll_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu16i  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu9ll_BFu16i) C1{ FC2{} FL:9 Fi:16}



static void Test_Sf_BFu9ll_BFu16i()
{
  {
    init_simple_test("Sf_BFu9ll_BFu16i");
    static Sf_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu9ll_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu16i(Test_Sf_BFu9ll_BFu16i, "Sf_BFu9ll_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu16ll  {
  ::empty v1;
  __tsu64 v2:9;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu9ll_BFu16ll) C1{ FC2{} FL:9 FL:16}



static void Test_Sf_BFu9ll_BFu16ll()
{
  {
    init_simple_test("Sf_BFu9ll_BFu16ll");
    static Sf_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Sf_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Sf_BFu9ll_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu16ll(Test_Sf_BFu9ll_BFu16ll, "Sf_BFu9ll_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu16s  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu9ll_BFu16s) C1{ FC2{} FL:9 Fs:16}



static void Test_Sf_BFu9ll_BFu16s()
{
  {
    init_simple_test("Sf_BFu9ll_BFu16s");
    static Sf_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu9ll_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu16s(Test_Sf_BFu9ll_BFu16s, "Sf_BFu9ll_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu17i  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu9ll_BFu17i) C1{ FC2{} FL:9 Fi:17}



static void Test_Sf_BFu9ll_BFu17i()
{
  {
    init_simple_test("Sf_BFu9ll_BFu17i");
    static Sf_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Sf_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Sf_BFu9ll_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu17i(Test_Sf_BFu9ll_BFu17i, "Sf_BFu9ll_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu17ll  {
  ::empty v1;
  __tsu64 v2:9;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu9ll_BFu17ll) C1{ FC2{} FL:9 FL:17}



static void Test_Sf_BFu9ll_BFu17ll()
{
  {
    init_simple_test("Sf_BFu9ll_BFu17ll");
    static Sf_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "Sf_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "Sf_BFu9ll_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu17ll(Test_Sf_BFu9ll_BFu17ll, "Sf_BFu9ll_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu1c  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu9ll_BFu1c) C1{ FC2{} FL:9 Fc:1}



static void Test_Sf_BFu9ll_BFu1c()
{
  {
    init_simple_test("Sf_BFu9ll_BFu1c");
    static Sf_BFu9ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Sf_BFu9ll_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu1c(Test_Sf_BFu9ll_BFu1c, "Sf_BFu9ll_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu1i  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu9ll_BFu1i) C1{ FC2{} FL:9 Fi:1}



static void Test_Sf_BFu9ll_BFu1i()
{
  {
    init_simple_test("Sf_BFu9ll_BFu1i");
    static Sf_BFu9ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Sf_BFu9ll_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu1i(Test_Sf_BFu9ll_BFu1i, "Sf_BFu9ll_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu1ll  {
  ::empty v1;
  __tsu64 v2:9;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu9ll_BFu1ll) C1{ FC2{} FL:9 FL:1}



static void Test_Sf_BFu9ll_BFu1ll()
{
  {
    init_simple_test("Sf_BFu9ll_BFu1ll");
    static Sf_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Sf_BFu9ll_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu1ll(Test_Sf_BFu9ll_BFu1ll, "Sf_BFu9ll_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu1s  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu9ll_BFu1s) C1{ FC2{} FL:9 Fs:1}



static void Test_Sf_BFu9ll_BFu1s()
{
  {
    init_simple_test("Sf_BFu9ll_BFu1s");
    static Sf_BFu9ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Sf_BFu9ll_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu1s(Test_Sf_BFu9ll_BFu1s, "Sf_BFu9ll_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu31i  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu9ll_BFu31i) C1{ FC2{} FL:9 Fi:31}



static void Test_Sf_BFu9ll_BFu31i()
{
  {
    init_simple_test("Sf_BFu9ll_BFu31i");
    static Sf_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu9ll_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu31i(Test_Sf_BFu9ll_BFu31i, "Sf_BFu9ll_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu31ll  {
  ::empty v1;
  __tsu64 v2:9;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu9ll_BFu31ll) C1{ FC2{} FL:9 FL:31}



static void Test_Sf_BFu9ll_BFu31ll()
{
  {
    init_simple_test("Sf_BFu9ll_BFu31ll");
    static Sf_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "Sf_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "Sf_BFu9ll_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu31ll(Test_Sf_BFu9ll_BFu31ll, "Sf_BFu9ll_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu32i  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu9ll_BFu32i) C1{ FC2{} FL:9 Fi:32}



static void Test_Sf_BFu9ll_BFu32i()
{
  {
    init_simple_test("Sf_BFu9ll_BFu32i");
    static Sf_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu9ll_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu32i(Test_Sf_BFu9ll_BFu32i, "Sf_BFu9ll_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu32ll  {
  ::empty v1;
  __tsu64 v2:9;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu9ll_BFu32ll) C1{ FC2{} FL:9 FL:32}



static void Test_Sf_BFu9ll_BFu32ll()
{
  {
    init_simple_test("Sf_BFu9ll_BFu32ll");
    static Sf_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "Sf_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "Sf_BFu9ll_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu32ll(Test_Sf_BFu9ll_BFu32ll, "Sf_BFu9ll_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu33  {
  ::empty v1;
  __tsu64 v2:9;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu9ll_BFu33) C1{ FC2{} FL:9 FL:33}



static void Test_Sf_BFu9ll_BFu33()
{
  {
    init_simple_test("Sf_BFu9ll_BFu33");
    static Sf_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "Sf_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "Sf_BFu9ll_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu33(Test_Sf_BFu9ll_BFu33, "Sf_BFu9ll_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu7c  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu9ll_BFu7c) C1{ FC2{} FL:9 Fc:7}



static void Test_Sf_BFu9ll_BFu7c()
{
  {
    init_simple_test("Sf_BFu9ll_BFu7c");
    static Sf_BFu9ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Sf_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Sf_BFu9ll_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu7c(Test_Sf_BFu9ll_BFu7c, "Sf_BFu9ll_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu7i  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu9ll_BFu7i) C1{ FC2{} FL:9 Fi:7}



static void Test_Sf_BFu9ll_BFu7i()
{
  {
    init_simple_test("Sf_BFu9ll_BFu7i");
    static Sf_BFu9ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Sf_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Sf_BFu9ll_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu7i(Test_Sf_BFu9ll_BFu7i, "Sf_BFu9ll_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu7ll  {
  ::empty v1;
  __tsu64 v2:9;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu9ll_BFu7ll) C1{ FC2{} FL:9 FL:7}



static void Test_Sf_BFu9ll_BFu7ll()
{
  {
    init_simple_test("Sf_BFu9ll_BFu7ll");
    static Sf_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Sf_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Sf_BFu9ll_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu7ll(Test_Sf_BFu9ll_BFu7ll, "Sf_BFu9ll_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu7s  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu9ll_BFu7s) C1{ FC2{} FL:9 Fs:7}



static void Test_Sf_BFu9ll_BFu7s()
{
  {
    init_simple_test("Sf_BFu9ll_BFu7s");
    static Sf_BFu9ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Sf_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Sf_BFu9ll_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu7s(Test_Sf_BFu9ll_BFu7s, "Sf_BFu9ll_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu8c  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu9ll_BFu8c) C1{ FC2{} FL:9 Fc:8}



static void Test_Sf_BFu9ll_BFu8c()
{
  {
    init_simple_test("Sf_BFu9ll_BFu8c");
    static Sf_BFu9ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Sf_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Sf_BFu9ll_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu8c(Test_Sf_BFu9ll_BFu8c, "Sf_BFu9ll_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu8i  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu9ll_BFu8i) C1{ FC2{} FL:9 Fi:8}



static void Test_Sf_BFu9ll_BFu8i()
{
  {
    init_simple_test("Sf_BFu9ll_BFu8i");
    static Sf_BFu9ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Sf_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Sf_BFu9ll_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu8i(Test_Sf_BFu9ll_BFu8i, "Sf_BFu9ll_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu8ll  {
  ::empty v1;
  __tsu64 v2:9;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu9ll_BFu8ll) C1{ FC2{} FL:9 FL:8}



static void Test_Sf_BFu9ll_BFu8ll()
{
  {
    init_simple_test("Sf_BFu9ll_BFu8ll");
    static Sf_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Sf_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Sf_BFu9ll_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu8ll(Test_Sf_BFu9ll_BFu8ll, "Sf_BFu9ll_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu8s  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu9ll_BFu8s) C1{ FC2{} FL:9 Fs:8}



static void Test_Sf_BFu9ll_BFu8s()
{
  {
    init_simple_test("Sf_BFu9ll_BFu8s");
    static Sf_BFu9ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Sf_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Sf_BFu9ll_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu8s(Test_Sf_BFu9ll_BFu8s, "Sf_BFu9ll_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu9i  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu9ll_BFu9i) C1{ FC2{} FL:9 Fi:9}



static void Test_Sf_BFu9ll_BFu9i()
{
  {
    init_simple_test("Sf_BFu9ll_BFu9i");
    static Sf_BFu9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Sf_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu9i(Test_Sf_BFu9ll_BFu9i, "Sf_BFu9ll_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu9ll  {
  ::empty v1;
  __tsu64 v2:9;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu9ll_BFu9ll) C1{ FC2{} FL:9 FL:9}



static void Test_Sf_BFu9ll_BFu9ll()
{
  {
    init_simple_test("Sf_BFu9ll_BFu9ll");
    static Sf_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Sf_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu9ll(Test_Sf_BFu9ll_BFu9ll, "Sf_BFu9ll_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_BFu9s  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu9ll_BFu9s) C1{ FC2{} FL:9 Fs:9}



static void Test_Sf_BFu9ll_BFu9s()
{
  {
    init_simple_test("Sf_BFu9ll_BFu9s");
    static Sf_BFu9ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Sf_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Sf_BFu9ll_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_BFu9s(Test_Sf_BFu9ll_BFu9s, "Sf_BFu9ll_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_C  {
  ::empty v1;
  __tsu64 v2:9;
  char v3;
};
//SIG(1 Sf_BFu9ll_C) C1{ FC2{} FL:9 Fc}



static void Test_Sf_BFu9ll_C()
{
  {
    init_simple_test("Sf_BFu9ll_C");
    static Sf_BFu9ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_C");
    check_field_offset(lv, v3, 3, "Sf_BFu9ll_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_C(Test_Sf_BFu9ll_C, "Sf_BFu9ll_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_D  {
  ::empty v1;
  __tsu64 v2:9;
  double v3;
};
//SIG(1 Sf_BFu9ll_D) C1{ FC2{} FL:9 FL}



static void Test_Sf_BFu9ll_D()
{
  {
    init_simple_test("Sf_BFu9ll_D");
    static Sf_BFu9ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu9ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9ll_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_D(Test_Sf_BFu9ll_D, "Sf_BFu9ll_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_F  {
  ::empty v1;
  __tsu64 v2:9;
  float v3;
};
//SIG(1 Sf_BFu9ll_F) C1{ FC2{} FL:9 Fi}



static void Test_Sf_BFu9ll_F()
{
  {
    init_simple_test("Sf_BFu9ll_F");
    static Sf_BFu9ll_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_F");
    check_field_offset(lv, v3, 4, "Sf_BFu9ll_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_F(Test_Sf_BFu9ll_F, "Sf_BFu9ll_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_I  {
  ::empty v1;
  __tsu64 v2:9;
  int v3;
};
//SIG(1 Sf_BFu9ll_I) C1{ FC2{} FL:9 Fi}



static void Test_Sf_BFu9ll_I()
{
  {
    init_simple_test("Sf_BFu9ll_I");
    static Sf_BFu9ll_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_I");
    check_field_offset(lv, v3, 4, "Sf_BFu9ll_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_I(Test_Sf_BFu9ll_I, "Sf_BFu9ll_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_Ip  {
  ::empty v1;
  __tsu64 v2:9;
  int *v3;
};
//SIG(1 Sf_BFu9ll_Ip) C1{ FC2{} FL:9 Fp}



static void Test_Sf_BFu9ll_Ip()
{
  {
    init_simple_test("Sf_BFu9ll_Ip");
    static Sf_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu9ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9ll_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_Ip(Test_Sf_BFu9ll_Ip, "Sf_BFu9ll_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_L  {
  ::empty v1;
  __tsu64 v2:9;
  __tsi64 v3;
};
//SIG(1 Sf_BFu9ll_L) C1{ FC2{} FL:9 FL}



static void Test_Sf_BFu9ll_L()
{
  {
    init_simple_test("Sf_BFu9ll_L");
    static Sf_BFu9ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu9ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9ll_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_L(Test_Sf_BFu9ll_L, "Sf_BFu9ll_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_S  {
  ::empty v1;
  __tsu64 v2:9;
  short v3;
};
//SIG(1 Sf_BFu9ll_S) C1{ FC2{} FL:9 Fs}



static void Test_Sf_BFu9ll_S()
{
  {
    init_simple_test("Sf_BFu9ll_S");
    static Sf_BFu9ll_S lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_S");
    check_field_offset(lv, v3, 4, "Sf_BFu9ll_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_S(Test_Sf_BFu9ll_S, "Sf_BFu9ll_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_Sf  {
  ::empty v1;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 Sf_BFu9ll_Sf) C1{ FC2{} FL:9 FC2}



static void Test_Sf_BFu9ll_Sf()
{
  {
    init_simple_test("Sf_BFu9ll_Sf");
    static Sf_BFu9ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_Sf.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_Sf");
    check_field_offset(lv, v3, 3, "Sf_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_Sf(Test_Sf_BFu9ll_Sf, "Sf_BFu9ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_Uc  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned char v3;
};
//SIG(1 Sf_BFu9ll_Uc) C1{ FC2{} FL:9 Fc}



static void Test_Sf_BFu9ll_Uc()
{
  {
    init_simple_test("Sf_BFu9ll_Uc");
    static Sf_BFu9ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_Uc");
    check_field_offset(lv, v3, 3, "Sf_BFu9ll_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_Uc(Test_Sf_BFu9ll_Uc, "Sf_BFu9ll_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_Ui  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned int v3;
};
//SIG(1 Sf_BFu9ll_Ui) C1{ FC2{} FL:9 Fi}



static void Test_Sf_BFu9ll_Ui()
{
  {
    init_simple_test("Sf_BFu9ll_Ui");
    static Sf_BFu9ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu9ll_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_Ui(Test_Sf_BFu9ll_Ui, "Sf_BFu9ll_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_Ul  {
  ::empty v1;
  __tsu64 v2:9;
  __tsu64 v3;
};
//SIG(1 Sf_BFu9ll_Ul) C1{ FC2{} FL:9 FL}



static void Test_Sf_BFu9ll_Ul()
{
  {
    init_simple_test("Sf_BFu9ll_Ul");
    static Sf_BFu9ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu9ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9ll_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_Ul(Test_Sf_BFu9ll_Ul, "Sf_BFu9ll_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_Us  {
  ::empty v1;
  __tsu64 v2:9;
  unsigned short v3;
};
//SIG(1 Sf_BFu9ll_Us) C1{ FC2{} FL:9 Fs}



static void Test_Sf_BFu9ll_Us()
{
  {
    init_simple_test("Sf_BFu9ll_Us");
    static Sf_BFu9ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_Us");
    check_field_offset(lv, v3, 4, "Sf_BFu9ll_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_Us(Test_Sf_BFu9ll_Us, "Sf_BFu9ll_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9ll_Vp  {
  ::empty v1;
  __tsu64 v2:9;
  void *v3;
};
//SIG(1 Sf_BFu9ll_Vp) C1{ FC2{} FL:9 Fp}



static void Test_Sf_BFu9ll_Vp()
{
  {
    init_simple_test("Sf_BFu9ll_Vp");
    static Sf_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu9ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9ll_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu9ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "Sf_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "Sf_BFu9ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9ll_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9ll_Vp(Test_Sf_BFu9ll_Vp, "Sf_BFu9ll_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s  {
  ::empty v1;
  unsigned short v2:9;
};
//SIG(1 Sf_BFu9s) C1{ FC2{} Fs:9}



static void Test_Sf_BFu9s()
{
  {
    init_simple_test("Sf_BFu9s");
    static Sf_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu9s(Test_Sf_BFu9s, "Sf_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu15i  {
  ::empty v1;
  unsigned short v2:9;
  unsigned int v3:15;
};
//SIG(1 Sf_BFu9s_BFu15i) C1{ FC2{} Fs:9 Fi:15}



static void Test_Sf_BFu9s_BFu15i()
{
  {
    init_simple_test("Sf_BFu9s_BFu15i");
    static Sf_BFu9s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9s_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Sf_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Sf_BFu9s_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu15i(Test_Sf_BFu9s_BFu15i, "Sf_BFu9s_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu15ll  {
  ::empty v1;
  unsigned short v2:9;
  __tsu64 v3:15;
};
//SIG(1 Sf_BFu9s_BFu15ll) C1{ FC2{} Fs:9 FL:15}



static void Test_Sf_BFu9s_BFu15ll()
{
  {
    init_simple_test("Sf_BFu9s_BFu15ll");
    static Sf_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "Sf_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "Sf_BFu9s_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu15ll(Test_Sf_BFu9s_BFu15ll, "Sf_BFu9s_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu15s  {
  ::empty v1;
  unsigned short v2:9;
  unsigned short v3:15;
};
//SIG(1 Sf_BFu9s_BFu15s) C1{ FC2{} Fs:9 Fs:15}



static void Test_Sf_BFu9s_BFu15s()
{
  {
    init_simple_test("Sf_BFu9s_BFu15s");
    static Sf_BFu9s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu9s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Sf_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Sf_BFu9s_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu15s(Test_Sf_BFu9s_BFu15s, "Sf_BFu9s_BFu15s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu16i  {
  ::empty v1;
  unsigned short v2:9;
  unsigned int v3:16;
};
//SIG(1 Sf_BFu9s_BFu16i) C1{ FC2{} Fs:9 Fi:16}



static void Test_Sf_BFu9s_BFu16i()
{
  {
    init_simple_test("Sf_BFu9s_BFu16i");
    static Sf_BFu9s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9s_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu9s_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu16i(Test_Sf_BFu9s_BFu16i, "Sf_BFu9s_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu16ll  {
  ::empty v1;
  unsigned short v2:9;
  __tsu64 v3:16;
};
//SIG(1 Sf_BFu9s_BFu16ll) C1{ FC2{} Fs:9 FL:16}



static void Test_Sf_BFu9s_BFu16ll()
{
  {
    init_simple_test("Sf_BFu9s_BFu16ll");
    static Sf_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "Sf_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "Sf_BFu9s_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu16ll(Test_Sf_BFu9s_BFu16ll, "Sf_BFu9s_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu16s  {
  ::empty v1;
  unsigned short v2:9;
  unsigned short v3:16;
};
//SIG(1 Sf_BFu9s_BFu16s) C1{ FC2{} Fs:9 Fs:16}



static void Test_Sf_BFu9s_BFu16s()
{
  {
    init_simple_test("Sf_BFu9s_BFu16s");
    static Sf_BFu9s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu9s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Sf_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Sf_BFu9s_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu16s(Test_Sf_BFu9s_BFu16s, "Sf_BFu9s_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu17i  {
  ::empty v1;
  unsigned short v2:9;
  unsigned int v3:17;
};
//SIG(1 Sf_BFu9s_BFu17i) C1{ FC2{} Fs:9 Fi:17}



static void Test_Sf_BFu9s_BFu17i()
{
  {
    init_simple_test("Sf_BFu9s_BFu17i");
    static Sf_BFu9s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9s_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Sf_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Sf_BFu9s_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu17i(Test_Sf_BFu9s_BFu17i, "Sf_BFu9s_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu17ll  {
  ::empty v1;
  unsigned short v2:9;
  __tsu64 v3:17;
};
//SIG(1 Sf_BFu9s_BFu17ll) C1{ FC2{} Fs:9 FL:17}



static void Test_Sf_BFu9s_BFu17ll()
{
  {
    init_simple_test("Sf_BFu9s_BFu17ll");
    static Sf_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "Sf_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "Sf_BFu9s_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu17ll(Test_Sf_BFu9s_BFu17ll, "Sf_BFu9s_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu1c  {
  ::empty v1;
  unsigned short v2:9;
  unsigned char v3:1;
};
//SIG(1 Sf_BFu9s_BFu1c) C1{ FC2{} Fs:9 Fc:1}



static void Test_Sf_BFu9s_BFu1c()
{
  {
    init_simple_test("Sf_BFu9s_BFu1c");
    static Sf_BFu9s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Sf_BFu9s_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu1c(Test_Sf_BFu9s_BFu1c, "Sf_BFu9s_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu1i  {
  ::empty v1;
  unsigned short v2:9;
  unsigned int v3:1;
};
//SIG(1 Sf_BFu9s_BFu1i) C1{ FC2{} Fs:9 Fi:1}



static void Test_Sf_BFu9s_BFu1i()
{
  {
    init_simple_test("Sf_BFu9s_BFu1i");
    static Sf_BFu9s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9s_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Sf_BFu9s_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu1i(Test_Sf_BFu9s_BFu1i, "Sf_BFu9s_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu1ll  {
  ::empty v1;
  unsigned short v2:9;
  __tsu64 v3:1;
};
//SIG(1 Sf_BFu9s_BFu1ll) C1{ FC2{} Fs:9 FL:1}



static void Test_Sf_BFu9s_BFu1ll()
{
  {
    init_simple_test("Sf_BFu9s_BFu1ll");
    static Sf_BFu9s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Sf_BFu9s_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu1ll(Test_Sf_BFu9s_BFu1ll, "Sf_BFu9s_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu1s  {
  ::empty v1;
  unsigned short v2:9;
  unsigned short v3:1;
};
//SIG(1 Sf_BFu9s_BFu1s) C1{ FC2{} Fs:9 Fs:1}



static void Test_Sf_BFu9s_BFu1s()
{
  {
    init_simple_test("Sf_BFu9s_BFu1s");
    static Sf_BFu9s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "Sf_BFu9s_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu1s(Test_Sf_BFu9s_BFu1s, "Sf_BFu9s_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu31i  {
  ::empty v1;
  unsigned short v2:9;
  unsigned int v3:31;
};
//SIG(1 Sf_BFu9s_BFu31i) C1{ FC2{} Fs:9 Fi:31}



static void Test_Sf_BFu9s_BFu31i()
{
  {
    init_simple_test("Sf_BFu9s_BFu31i");
    static Sf_BFu9s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9s_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_BFu9s_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu31i(Test_Sf_BFu9s_BFu31i, "Sf_BFu9s_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu31ll  {
  ::empty v1;
  unsigned short v2:9;
  __tsu64 v3:31;
};
//SIG(1 Sf_BFu9s_BFu31ll) C1{ FC2{} Fs:9 FL:31}



static void Test_Sf_BFu9s_BFu31ll()
{
  {
    init_simple_test("Sf_BFu9s_BFu31ll");
    static Sf_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "Sf_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "Sf_BFu9s_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu31ll(Test_Sf_BFu9s_BFu31ll, "Sf_BFu9s_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu32i  {
  ::empty v1;
  unsigned short v2:9;
  unsigned int v3:32;
};
//SIG(1 Sf_BFu9s_BFu32i) C1{ FC2{} Fs:9 Fi:32}



static void Test_Sf_BFu9s_BFu32i()
{
  {
    init_simple_test("Sf_BFu9s_BFu32i");
    static Sf_BFu9s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9s_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_BFu9s_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu32i(Test_Sf_BFu9s_BFu32i, "Sf_BFu9s_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu32ll  {
  ::empty v1;
  unsigned short v2:9;
  __tsu64 v3:32;
};
//SIG(1 Sf_BFu9s_BFu32ll) C1{ FC2{} Fs:9 FL:32}



static void Test_Sf_BFu9s_BFu32ll()
{
  {
    init_simple_test("Sf_BFu9s_BFu32ll");
    static Sf_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "Sf_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "Sf_BFu9s_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu32ll(Test_Sf_BFu9s_BFu32ll, "Sf_BFu9s_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu33  {
  ::empty v1;
  unsigned short v2:9;
  __tsu64 v3:33;
};
//SIG(1 Sf_BFu9s_BFu33) C1{ FC2{} Fs:9 FL:33}



static void Test_Sf_BFu9s_BFu33()
{
  {
    init_simple_test("Sf_BFu9s_BFu33");
    static Sf_BFu9s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "Sf_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "Sf_BFu9s_BFu33");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu33(Test_Sf_BFu9s_BFu33, "Sf_BFu9s_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu7c  {
  ::empty v1;
  unsigned short v2:9;
  unsigned char v3:7;
};
//SIG(1 Sf_BFu9s_BFu7c) C1{ FC2{} Fs:9 Fc:7}



static void Test_Sf_BFu9s_BFu7c()
{
  {
    init_simple_test("Sf_BFu9s_BFu7c");
    static Sf_BFu9s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Sf_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Sf_BFu9s_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu7c(Test_Sf_BFu9s_BFu7c, "Sf_BFu9s_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu7i  {
  ::empty v1;
  unsigned short v2:9;
  unsigned int v3:7;
};
//SIG(1 Sf_BFu9s_BFu7i) C1{ FC2{} Fs:9 Fi:7}



static void Test_Sf_BFu9s_BFu7i()
{
  {
    init_simple_test("Sf_BFu9s_BFu7i");
    static Sf_BFu9s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9s_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Sf_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Sf_BFu9s_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu7i(Test_Sf_BFu9s_BFu7i, "Sf_BFu9s_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu7ll  {
  ::empty v1;
  unsigned short v2:9;
  __tsu64 v3:7;
};
//SIG(1 Sf_BFu9s_BFu7ll) C1{ FC2{} Fs:9 FL:7}



static void Test_Sf_BFu9s_BFu7ll()
{
  {
    init_simple_test("Sf_BFu9s_BFu7ll");
    static Sf_BFu9s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_BFu9s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Sf_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Sf_BFu9s_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu7ll(Test_Sf_BFu9s_BFu7ll, "Sf_BFu9s_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu7s  {
  ::empty v1;
  unsigned short v2:9;
  unsigned short v3:7;
};
//SIG(1 Sf_BFu9s_BFu7s) C1{ FC2{} Fs:9 Fs:7}



static void Test_Sf_BFu9s_BFu7s()
{
  {
    init_simple_test("Sf_BFu9s_BFu7s");
    static Sf_BFu9s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_BFu9s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "Sf_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "Sf_BFu9s_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu7s(Test_Sf_BFu9s_BFu7s, "Sf_BFu9s_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu8c  {
  ::empty v1;
  unsigned short v2:9;
  unsigned char v3:8;
};
//SIG(1 Sf_BFu9s_BFu8c) C1{ FC2{} Fs:9 Fc:8}



static void Test_Sf_BFu9s_BFu8c()
{
  {
    init_simple_test("Sf_BFu9s_BFu8c");
    static Sf_BFu9s_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu9s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Sf_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Sf_BFu9s_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu8c(Test_Sf_BFu9s_BFu8c, "Sf_BFu9s_BFu8c", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu8i  {
  ::empty v1;
  unsigned short v2:9;
  unsigned int v3:8;
};
//SIG(1 Sf_BFu9s_BFu8i) C1{ FC2{} Fs:9 Fi:8}



static void Test_Sf_BFu9s_BFu8i()
{
  {
    init_simple_test("Sf_BFu9s_BFu8i");
    static Sf_BFu9s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9s_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Sf_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Sf_BFu9s_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu8i(Test_Sf_BFu9s_BFu8i, "Sf_BFu9s_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu8ll  {
  ::empty v1;
  unsigned short v2:9;
  __tsu64 v3:8;
};
//SIG(1 Sf_BFu9s_BFu8ll) C1{ FC2{} Fs:9 FL:8}



static void Test_Sf_BFu9s_BFu8ll()
{
  {
    init_simple_test("Sf_BFu9s_BFu8ll");
    static Sf_BFu9s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "Sf_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "Sf_BFu9s_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu8ll(Test_Sf_BFu9s_BFu8ll, "Sf_BFu9s_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu8s  {
  ::empty v1;
  unsigned short v2:9;
  unsigned short v3:8;
};
//SIG(1 Sf_BFu9s_BFu8s) C1{ FC2{} Fs:9 Fs:8}



static void Test_Sf_BFu9s_BFu8s()
{
  {
    init_simple_test("Sf_BFu9s_BFu8s");
    static Sf_BFu9s_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu9s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Sf_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Sf_BFu9s_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu8s(Test_Sf_BFu9s_BFu8s, "Sf_BFu9s_BFu8s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu9i  {
  ::empty v1;
  unsigned short v2:9;
  unsigned int v3:9;
};
//SIG(1 Sf_BFu9s_BFu9i) C1{ FC2{} Fs:9 Fi:9}



static void Test_Sf_BFu9s_BFu9i()
{
  {
    init_simple_test("Sf_BFu9s_BFu9i");
    static Sf_BFu9s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9s_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Sf_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu9i(Test_Sf_BFu9s_BFu9i, "Sf_BFu9s_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu9ll  {
  ::empty v1;
  unsigned short v2:9;
  __tsu64 v3:9;
};
//SIG(1 Sf_BFu9s_BFu9ll) C1{ FC2{} Fs:9 FL:9}



static void Test_Sf_BFu9s_BFu9ll()
{
  {
    init_simple_test("Sf_BFu9s_BFu9ll");
    static Sf_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "Sf_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu9ll(Test_Sf_BFu9s_BFu9ll, "Sf_BFu9s_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_BFu9s  {
  ::empty v1;
  unsigned short v2:9;
  unsigned short v3:9;
};
//SIG(1 Sf_BFu9s_BFu9s) C1{ FC2{} Fs:9 Fs:9}



static void Test_Sf_BFu9s_BFu9s()
{
  {
    init_simple_test("Sf_BFu9s_BFu9s");
    static Sf_BFu9s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu9s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Sf_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_BFu9s(Test_Sf_BFu9s_BFu9s, "Sf_BFu9s_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_C  {
  ::empty v1;
  unsigned short v2:9;
  char v3;
};
//SIG(1 Sf_BFu9s_C) C1{ FC2{} Fs:9 Fc}



static void Test_Sf_BFu9s_C()
{
  {
    init_simple_test("Sf_BFu9s_C");
    static Sf_BFu9s_C lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu9s_C)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s_C)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_C");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_C");
    check_field_offset(lv, v3, 4, "Sf_BFu9s_C.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_C(Test_Sf_BFu9s_C, "Sf_BFu9s_C", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_D  {
  ::empty v1;
  unsigned short v2:9;
  double v3;
};
//SIG(1 Sf_BFu9s_D) C1{ FC2{} Fs:9 FL}



static void Test_Sf_BFu9s_D()
{
  {
    init_simple_test("Sf_BFu9s_D");
    static Sf_BFu9s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu9s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_D)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_D");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9s_D.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_D(Test_Sf_BFu9s_D, "Sf_BFu9s_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_F  {
  ::empty v1;
  unsigned short v2:9;
  float v3;
};
//SIG(1 Sf_BFu9s_F) C1{ FC2{} Fs:9 Fi}



static void Test_Sf_BFu9s_F()
{
  {
    init_simple_test("Sf_BFu9s_F");
    static Sf_BFu9s_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9s_F)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_F");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_F");
    check_field_offset(lv, v3, 4, "Sf_BFu9s_F.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_F(Test_Sf_BFu9s_F, "Sf_BFu9s_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_I  {
  ::empty v1;
  unsigned short v2:9;
  int v3;
};
//SIG(1 Sf_BFu9s_I) C1{ FC2{} Fs:9 Fi}



static void Test_Sf_BFu9s_I()
{
  {
    init_simple_test("Sf_BFu9s_I");
    static Sf_BFu9s_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9s_I)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_I");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_I");
    check_field_offset(lv, v3, 4, "Sf_BFu9s_I.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_I(Test_Sf_BFu9s_I, "Sf_BFu9s_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_Ip  {
  ::empty v1;
  unsigned short v2:9;
  int *v3;
};
//SIG(1 Sf_BFu9s_Ip) C1{ FC2{} Fs:9 Fp}



static void Test_Sf_BFu9s_Ip()
{
  {
    init_simple_test("Sf_BFu9s_Ip");
    static Sf_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu9s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_Ip)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9s_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_Ip(Test_Sf_BFu9s_Ip, "Sf_BFu9s_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_L  {
  ::empty v1;
  unsigned short v2:9;
  __tsi64 v3;
};
//SIG(1 Sf_BFu9s_L) C1{ FC2{} Fs:9 FL}



static void Test_Sf_BFu9s_L()
{
  {
    init_simple_test("Sf_BFu9s_L");
    static Sf_BFu9s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu9s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_L)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_L");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9s_L.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_L(Test_Sf_BFu9s_L, "Sf_BFu9s_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_S  {
  ::empty v1;
  unsigned short v2:9;
  short v3;
};
//SIG(1 Sf_BFu9s_S) C1{ FC2{} Fs:9 Fs}



static void Test_Sf_BFu9s_S()
{
  {
    init_simple_test("Sf_BFu9s_S");
    static Sf_BFu9s_S lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu9s_S)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s_S)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_S");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_S");
    check_field_offset(lv, v3, 4, "Sf_BFu9s_S.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_S(Test_Sf_BFu9s_S, "Sf_BFu9s_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_Sf  {
  ::empty v1;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 Sf_BFu9s_Sf) C1{ FC2{} Fs:9 FC2}



static void Test_Sf_BFu9s_Sf()
{
  {
    init_simple_test("Sf_BFu9s_Sf");
    static Sf_BFu9s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu9s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s_Sf)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_Sf.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_Sf");
    check_field_offset(lv, v3, 4, "Sf_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_Sf(Test_Sf_BFu9s_Sf, "Sf_BFu9s_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_Uc  {
  ::empty v1;
  unsigned short v2:9;
  unsigned char v3;
};
//SIG(1 Sf_BFu9s_Uc) C1{ FC2{} Fs:9 Fc}



static void Test_Sf_BFu9s_Uc()
{
  {
    init_simple_test("Sf_BFu9s_Uc");
    static Sf_BFu9s_Uc lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu9s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s_Uc)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_Uc");
    check_field_offset(lv, v3, 4, "Sf_BFu9s_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_Uc(Test_Sf_BFu9s_Uc, "Sf_BFu9s_Uc", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_Ui  {
  ::empty v1;
  unsigned short v2:9;
  unsigned int v3;
};
//SIG(1 Sf_BFu9s_Ui) C1{ FC2{} Fs:9 Fi}



static void Test_Sf_BFu9s_Ui()
{
  {
    init_simple_test("Sf_BFu9s_Ui");
    static Sf_BFu9s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_BFu9s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_BFu9s_Ui)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_Ui");
    check_field_offset(lv, v3, 4, "Sf_BFu9s_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_Ui(Test_Sf_BFu9s_Ui, "Sf_BFu9s_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_Ul  {
  ::empty v1;
  unsigned short v2:9;
  __tsu64 v3;
};
//SIG(1 Sf_BFu9s_Ul) C1{ FC2{} Fs:9 FL}



static void Test_Sf_BFu9s_Ul()
{
  {
    init_simple_test("Sf_BFu9s_Ul");
    static Sf_BFu9s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_BFu9s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_Ul)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9s_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_Ul(Test_Sf_BFu9s_Ul, "Sf_BFu9s_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_Us  {
  ::empty v1;
  unsigned short v2:9;
  unsigned short v3;
};
//SIG(1 Sf_BFu9s_Us) C1{ FC2{} Fs:9 Fs}



static void Test_Sf_BFu9s_Us()
{
  {
    init_simple_test("Sf_BFu9s_Us");
    static Sf_BFu9s_Us lv;
    check2(sizeof(lv), 6, "sizeof(Sf_BFu9s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_BFu9s_Us)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_Us");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_Us");
    check_field_offset(lv, v3, 4, "Sf_BFu9s_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_Us(Test_Sf_BFu9s_Us, "Sf_BFu9s_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_BFu9s_Vp  {
  ::empty v1;
  unsigned short v2:9;
  void *v3;
};
//SIG(1 Sf_BFu9s_Vp) C1{ FC2{} Fs:9 Fp}



static void Test_Sf_BFu9s_Vp()
{
  {
    init_simple_test("Sf_BFu9s_Vp");
    static Sf_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_BFu9s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_BFu9s_Vp)");
    check_field_offset(lv, v1, 0, "Sf_BFu9s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "Sf_BFu9s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "Sf_BFu9s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_BFu9s_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_BFu9s_Vp(Test_Sf_BFu9s_Vp, "Sf_BFu9s_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C  {
  ::empty v1;
  char v2;
};
//SIG(1 Sf_C) C1{ FC2{} Fc}



static void Test_Sf_C()
{
  {
    init_simple_test("Sf_C");
    Sf_C lv;
    check2(sizeof(lv), 2, "sizeof(Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_C)");
    check_field_offset(lv, v1, 0, "Sf_C.v1");
    check_field_offset(lv, v2, 1, "Sf_C.v2");
  }
}
static Arrange_To_Call_Me vSf_C(Test_Sf_C, "Sf_C", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu15i  {
  ::empty v1;
  char v2;
  unsigned int v3:15;
};
//SIG(1 Sf_C_BFu15i) C1{ FC2{} Fc Fi:15}



static void Test_Sf_C_BFu15i()
{
  {
    init_simple_test("Sf_C_BFu15i");
    static Sf_C_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_C_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_C_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu15i.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_C_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_C_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_C_BFu15i(Test_Sf_C_BFu15i, "Sf_C_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu15ll  {
  ::empty v1;
  char v2;
  __tsu64 v3:15;
};
//SIG(1 Sf_C_BFu15ll) C1{ FC2{} Fc FL:15}



static void Test_Sf_C_BFu15ll()
{
  {
    init_simple_test("Sf_C_BFu15ll");
    static Sf_C_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_C_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_C_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_C_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_C_BFu15ll(Test_Sf_C_BFu15ll, "Sf_C_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu15s  {
  ::empty v1;
  char v2;
  unsigned short v3:15;
};
//SIG(1 Sf_C_BFu15s) C1{ FC2{} Fc Fs:15}



static void Test_Sf_C_BFu15s()
{
  {
    init_simple_test("Sf_C_BFu15s");
    static Sf_C_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_C_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_C_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu15s.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "Sf_C_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "Sf_C_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_C_BFu15s(Test_Sf_C_BFu15s, "Sf_C_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu16i  {
  ::empty v1;
  char v2;
  unsigned int v3:16;
};
//SIG(1 Sf_C_BFu16i) C1{ FC2{} Fc Fi:16}



static void Test_Sf_C_BFu16i()
{
  {
    init_simple_test("Sf_C_BFu16i");
    static Sf_C_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_C_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_C_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu16i.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_C_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_C_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_C_BFu16i(Test_Sf_C_BFu16i, "Sf_C_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu16ll  {
  ::empty v1;
  char v2;
  __tsu64 v3:16;
};
//SIG(1 Sf_C_BFu16ll) C1{ FC2{} Fc FL:16}



static void Test_Sf_C_BFu16ll()
{
  {
    init_simple_test("Sf_C_BFu16ll");
    static Sf_C_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_C_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_C_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_C_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_C_BFu16ll(Test_Sf_C_BFu16ll, "Sf_C_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu16s  {
  ::empty v1;
  char v2;
  unsigned short v3:16;
};
//SIG(1 Sf_C_BFu16s) C1{ FC2{} Fc Fs:16}



static void Test_Sf_C_BFu16s()
{
  {
    init_simple_test("Sf_C_BFu16s");
    static Sf_C_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_C_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_C_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu16s.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "Sf_C_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "Sf_C_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_C_BFu16s(Test_Sf_C_BFu16s, "Sf_C_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu17i  {
  ::empty v1;
  char v2;
  unsigned int v3:17;
};
//SIG(1 Sf_C_BFu17i) C1{ FC2{} Fc Fi:17}



static void Test_Sf_C_BFu17i()
{
  {
    init_simple_test("Sf_C_BFu17i");
    static Sf_C_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_C_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_C_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu17i.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Sf_C_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Sf_C_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_C_BFu17i(Test_Sf_C_BFu17i, "Sf_C_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu17ll  {
  ::empty v1;
  char v2;
  __tsu64 v3:17;
};
//SIG(1 Sf_C_BFu17ll) C1{ FC2{} Fc FL:17}



static void Test_Sf_C_BFu17ll()
{
  {
    init_simple_test("Sf_C_BFu17ll");
    static Sf_C_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_C_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "Sf_C_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "Sf_C_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_C_BFu17ll(Test_Sf_C_BFu17ll, "Sf_C_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu1c  {
  ::empty v1;
  char v2;
  unsigned char v3:1;
};
//SIG(1 Sf_C_BFu1c) C1{ FC2{} Fc Fc:1}



static void Test_Sf_C_BFu1c()
{
  {
    init_simple_test("Sf_C_BFu1c");
    static Sf_C_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(Sf_C_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_C_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu1c.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_C_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_C_BFu1c(Test_Sf_C_BFu1c, "Sf_C_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu1i  {
  ::empty v1;
  char v2;
  unsigned int v3:1;
};
//SIG(1 Sf_C_BFu1i) C1{ FC2{} Fc Fi:1}



static void Test_Sf_C_BFu1i()
{
  {
    init_simple_test("Sf_C_BFu1i");
    static Sf_C_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_C_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_C_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu1i.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_C_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_C_BFu1i(Test_Sf_C_BFu1i, "Sf_C_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu1ll  {
  ::empty v1;
  char v2;
  __tsu64 v3:1;
};
//SIG(1 Sf_C_BFu1ll) C1{ FC2{} Fc FL:1}



static void Test_Sf_C_BFu1ll()
{
  {
    init_simple_test("Sf_C_BFu1ll");
    static Sf_C_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_C_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_C_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_C_BFu1ll(Test_Sf_C_BFu1ll, "Sf_C_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu1s  {
  ::empty v1;
  char v2;
  unsigned short v3:1;
};
//SIG(1 Sf_C_BFu1s) C1{ FC2{} Fc Fs:1}



static void Test_Sf_C_BFu1s()
{
  {
    init_simple_test("Sf_C_BFu1s");
    static Sf_C_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_C_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_C_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu1s.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "Sf_C_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_C_BFu1s(Test_Sf_C_BFu1s, "Sf_C_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu31i  {
  ::empty v1;
  char v2;
  unsigned int v3:31;
};
//SIG(1 Sf_C_BFu31i) C1{ FC2{} Fc Fi:31}



static void Test_Sf_C_BFu31i()
{
  {
    init_simple_test("Sf_C_BFu31i");
    static Sf_C_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_C_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_C_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu31i.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Sf_C_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Sf_C_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_C_BFu31i(Test_Sf_C_BFu31i, "Sf_C_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu31ll  {
  ::empty v1;
  char v2;
  __tsu64 v3:31;
};
//SIG(1 Sf_C_BFu31ll) C1{ FC2{} Fc FL:31}



static void Test_Sf_C_BFu31ll()
{
  {
    init_simple_test("Sf_C_BFu31ll");
    static Sf_C_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_C_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "Sf_C_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "Sf_C_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_C_BFu31ll(Test_Sf_C_BFu31ll, "Sf_C_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu32i  {
  ::empty v1;
  char v2;
  unsigned int v3:32;
};
//SIG(1 Sf_C_BFu32i) C1{ FC2{} Fc Fi:32}



static void Test_Sf_C_BFu32i()
{
  {
    init_simple_test("Sf_C_BFu32i");
    static Sf_C_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Sf_C_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_C_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu32i.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Sf_C_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Sf_C_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_C_BFu32i(Test_Sf_C_BFu32i, "Sf_C_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu32ll  {
  ::empty v1;
  char v2;
  __tsu64 v3:32;
};
//SIG(1 Sf_C_BFu32ll) C1{ FC2{} Fc FL:32}



static void Test_Sf_C_BFu32ll()
{
  {
    init_simple_test("Sf_C_BFu32ll");
    static Sf_C_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Sf_C_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "Sf_C_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "Sf_C_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_C_BFu32ll(Test_Sf_C_BFu32ll, "Sf_C_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu33  {
  ::empty v1;
  char v2;
  __tsu64 v3:33;
};
//SIG(1 Sf_C_BFu33) C1{ FC2{} Fc FL:33}



static void Test_Sf_C_BFu33()
{
  {
    init_simple_test("Sf_C_BFu33");
    static Sf_C_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Sf_C_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu33.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "Sf_C_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "Sf_C_BFu33");
  }
}
static Arrange_To_Call_Me vSf_C_BFu33(Test_Sf_C_BFu33, "Sf_C_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu7c  {
  ::empty v1;
  char v2;
  unsigned char v3:7;
};
//SIG(1 Sf_C_BFu7c) C1{ FC2{} Fc Fc:7}



static void Test_Sf_C_BFu7c()
{
  {
    init_simple_test("Sf_C_BFu7c");
    static Sf_C_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(Sf_C_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_C_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu7c.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_C_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_C_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_C_BFu7c(Test_Sf_C_BFu7c, "Sf_C_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu7i  {
  ::empty v1;
  char v2;
  unsigned int v3:7;
};
//SIG(1 Sf_C_BFu7i) C1{ FC2{} Fc Fi:7}



static void Test_Sf_C_BFu7i()
{
  {
    init_simple_test("Sf_C_BFu7i");
    static Sf_C_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_C_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_C_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu7i.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_C_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_C_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_C_BFu7i(Test_Sf_C_BFu7i, "Sf_C_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu7ll  {
  ::empty v1;
  char v2;
  __tsu64 v3:7;
};
//SIG(1 Sf_C_BFu7ll) C1{ FC2{} Fc FL:7}



static void Test_Sf_C_BFu7ll()
{
  {
    init_simple_test("Sf_C_BFu7ll");
    static Sf_C_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_C_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_C_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_C_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_C_BFu7ll(Test_Sf_C_BFu7ll, "Sf_C_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu7s  {
  ::empty v1;
  char v2;
  unsigned short v3:7;
};
//SIG(1 Sf_C_BFu7s) C1{ FC2{} Fc Fs:7}



static void Test_Sf_C_BFu7s()
{
  {
    init_simple_test("Sf_C_BFu7s");
    static Sf_C_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_C_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_C_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu7s.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "Sf_C_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "Sf_C_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_C_BFu7s(Test_Sf_C_BFu7s, "Sf_C_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu8c  {
  ::empty v1;
  char v2;
  unsigned char v3:8;
};
//SIG(1 Sf_C_BFu8c) C1{ FC2{} Fc Fc:8}



static void Test_Sf_C_BFu8c()
{
  {
    init_simple_test("Sf_C_BFu8c");
    static Sf_C_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(Sf_C_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_C_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu8c.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_C_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_C_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_C_BFu8c(Test_Sf_C_BFu8c, "Sf_C_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu8i  {
  ::empty v1;
  char v2;
  unsigned int v3:8;
};
//SIG(1 Sf_C_BFu8i) C1{ FC2{} Fc Fi:8}



static void Test_Sf_C_BFu8i()
{
  {
    init_simple_test("Sf_C_BFu8i");
    static Sf_C_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_C_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_C_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu8i.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_C_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_C_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_C_BFu8i(Test_Sf_C_BFu8i, "Sf_C_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu8ll  {
  ::empty v1;
  char v2;
  __tsu64 v3:8;
};
//SIG(1 Sf_C_BFu8ll) C1{ FC2{} Fc FL:8}



static void Test_Sf_C_BFu8ll()
{
  {
    init_simple_test("Sf_C_BFu8ll");
    static Sf_C_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_C_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_C_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_C_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_C_BFu8ll(Test_Sf_C_BFu8ll, "Sf_C_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu8s  {
  ::empty v1;
  char v2;
  unsigned short v3:8;
};
//SIG(1 Sf_C_BFu8s) C1{ FC2{} Fc Fs:8}



static void Test_Sf_C_BFu8s()
{
  {
    init_simple_test("Sf_C_BFu8s");
    static Sf_C_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_C_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_C_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu8s.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "Sf_C_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "Sf_C_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_C_BFu8s(Test_Sf_C_BFu8s, "Sf_C_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu9i  {
  ::empty v1;
  char v2;
  unsigned int v3:9;
};
//SIG(1 Sf_C_BFu9i) C1{ FC2{} Fc Fi:9}



static void Test_Sf_C_BFu9i()
{
  {
    init_simple_test("Sf_C_BFu9i");
    static Sf_C_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Sf_C_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_C_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu9i.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_C_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_C_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_C_BFu9i(Test_Sf_C_BFu9i, "Sf_C_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu9ll  {
  ::empty v1;
  char v2;
  __tsu64 v3:9;
};
//SIG(1 Sf_C_BFu9ll) C1{ FC2{} Fc FL:9}



static void Test_Sf_C_BFu9ll()
{
  {
    init_simple_test("Sf_C_BFu9ll");
    static Sf_C_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Sf_C_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_C_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_C_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_C_BFu9ll(Test_Sf_C_BFu9ll, "Sf_C_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_BFu9s  {
  ::empty v1;
  char v2;
  unsigned short v3:9;
};
//SIG(1 Sf_C_BFu9s) C1{ FC2{} Fc Fs:9}



static void Test_Sf_C_BFu9s()
{
  {
    init_simple_test("Sf_C_BFu9s");
    static Sf_C_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Sf_C_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_C_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_C_BFu9s.v1");
    check_field_offset(lv, v2, 1, "Sf_C_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "Sf_C_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "Sf_C_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_C_BFu9s(Test_Sf_C_BFu9s, "Sf_C_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_C  {
  ::empty v1;
  char v2;
  char v3;
};
//SIG(1 Sf_C_C) C1{ FC2{} Fc[2]}



static void Test_Sf_C_C()
{
  {
    init_simple_test("Sf_C_C");
    Sf_C_C lv;
    check2(sizeof(lv), 3, "sizeof(Sf_C_C)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_C_C)");
    check_field_offset(lv, v1, 0, "Sf_C_C.v1");
    check_field_offset(lv, v2, 1, "Sf_C_C.v2");
    check_field_offset(lv, v3, 2, "Sf_C_C.v3");
  }
}
static Arrange_To_Call_Me vSf_C_C(Test_Sf_C_C, "Sf_C_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_D  {
  ::empty v1;
  char v2;
  double v3;
};
//SIG(1 Sf_C_D) C1{ FC2{} Fc FL}



static void Test_Sf_C_D()
{
  {
    init_simple_test("Sf_C_D");
    Sf_C_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_C_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_D)");
    check_field_offset(lv, v1, 0, "Sf_C_D.v1");
    check_field_offset(lv, v2, 1, "Sf_C_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_C_D.v3");
  }
}
static Arrange_To_Call_Me vSf_C_D(Test_Sf_C_D, "Sf_C_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_F  {
  ::empty v1;
  char v2;
  float v3;
};
//SIG(1 Sf_C_F) C1{ FC2{} Fc Fi}



static void Test_Sf_C_F()
{
  {
    init_simple_test("Sf_C_F");
    Sf_C_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_C_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_C_F)");
    check_field_offset(lv, v1, 0, "Sf_C_F.v1");
    check_field_offset(lv, v2, 1, "Sf_C_F.v2");
    check_field_offset(lv, v3, 4, "Sf_C_F.v3");
  }
}
static Arrange_To_Call_Me vSf_C_F(Test_Sf_C_F, "Sf_C_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_I  {
  ::empty v1;
  char v2;
  int v3;
};
//SIG(1 Sf_C_I) C1{ FC2{} Fc Fi}



static void Test_Sf_C_I()
{
  {
    init_simple_test("Sf_C_I");
    Sf_C_I lv;
    check2(sizeof(lv), 8, "sizeof(Sf_C_I)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_C_I)");
    check_field_offset(lv, v1, 0, "Sf_C_I.v1");
    check_field_offset(lv, v2, 1, "Sf_C_I.v2");
    check_field_offset(lv, v3, 4, "Sf_C_I.v3");
  }
}
static Arrange_To_Call_Me vSf_C_I(Test_Sf_C_I, "Sf_C_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_Ip  {
  ::empty v1;
  char v2;
  int *v3;
};
//SIG(1 Sf_C_Ip) C1{ FC2{} Fc Fp}



static void Test_Sf_C_Ip()
{
  {
    init_simple_test("Sf_C_Ip");
    Sf_C_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_C_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_Ip)");
    check_field_offset(lv, v1, 0, "Sf_C_Ip.v1");
    check_field_offset(lv, v2, 1, "Sf_C_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_C_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_C_Ip(Test_Sf_C_Ip, "Sf_C_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_L  {
  ::empty v1;
  char v2;
  __tsi64 v3;
};
//SIG(1 Sf_C_L) C1{ FC2{} Fc FL}



static void Test_Sf_C_L()
{
  {
    init_simple_test("Sf_C_L");
    Sf_C_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_C_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_L)");
    check_field_offset(lv, v1, 0, "Sf_C_L.v1");
    check_field_offset(lv, v2, 1, "Sf_C_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_C_L.v3");
  }
}
static Arrange_To_Call_Me vSf_C_L(Test_Sf_C_L, "Sf_C_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_S  {
  ::empty v1;
  char v2;
  short v3;
};
//SIG(1 Sf_C_S) C1{ FC2{} Fc Fs}



static void Test_Sf_C_S()
{
  {
    init_simple_test("Sf_C_S");
    Sf_C_S lv;
    check2(sizeof(lv), 4, "sizeof(Sf_C_S)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_C_S)");
    check_field_offset(lv, v1, 0, "Sf_C_S.v1");
    check_field_offset(lv, v2, 1, "Sf_C_S.v2");
    check_field_offset(lv, v3, 2, "Sf_C_S.v3");
  }
}
static Arrange_To_Call_Me vSf_C_S(Test_Sf_C_S, "Sf_C_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_Sf  {
  ::empty v1;
  char v2;
  ::empty v3;
};
//SIG(1 Sf_C_Sf) C1{ FC2{} Fc FC2}



static void Test_Sf_C_Sf()
{
  {
    init_simple_test("Sf_C_Sf");
    Sf_C_Sf lv;
    check2(sizeof(lv), 3, "sizeof(Sf_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_C_Sf)");
    check_field_offset(lv, v1, 0, "Sf_C_Sf.v1");
    check_field_offset(lv, v2, 1, "Sf_C_Sf.v2");
    check_field_offset(lv, v3, 2, "Sf_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_C_Sf(Test_Sf_C_Sf, "Sf_C_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_Uc  {
  ::empty v1;
  char v2;
  unsigned char v3;
};
//SIG(1 Sf_C_Uc) C1{ FC2{} Fc[2]}



static void Test_Sf_C_Uc()
{
  {
    init_simple_test("Sf_C_Uc");
    Sf_C_Uc lv;
    check2(sizeof(lv), 3, "sizeof(Sf_C_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(Sf_C_Uc)");
    check_field_offset(lv, v1, 0, "Sf_C_Uc.v1");
    check_field_offset(lv, v2, 1, "Sf_C_Uc.v2");
    check_field_offset(lv, v3, 2, "Sf_C_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_C_Uc(Test_Sf_C_Uc, "Sf_C_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_Ui  {
  ::empty v1;
  char v2;
  unsigned int v3;
};
//SIG(1 Sf_C_Ui) C1{ FC2{} Fc Fi}



static void Test_Sf_C_Ui()
{
  {
    init_simple_test("Sf_C_Ui");
    Sf_C_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Sf_C_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_C_Ui)");
    check_field_offset(lv, v1, 0, "Sf_C_Ui.v1");
    check_field_offset(lv, v2, 1, "Sf_C_Ui.v2");
    check_field_offset(lv, v3, 4, "Sf_C_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_C_Ui(Test_Sf_C_Ui, "Sf_C_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_Ul  {
  ::empty v1;
  char v2;
  __tsu64 v3;
};
//SIG(1 Sf_C_Ul) C1{ FC2{} Fc FL}



static void Test_Sf_C_Ul()
{
  {
    init_simple_test("Sf_C_Ul");
    Sf_C_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_C_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_Ul)");
    check_field_offset(lv, v1, 0, "Sf_C_Ul.v1");
    check_field_offset(lv, v2, 1, "Sf_C_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_C_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_C_Ul(Test_Sf_C_Ul, "Sf_C_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_Us  {
  ::empty v1;
  char v2;
  unsigned short v3;
};
//SIG(1 Sf_C_Us) C1{ FC2{} Fc Fs}



static void Test_Sf_C_Us()
{
  {
    init_simple_test("Sf_C_Us");
    Sf_C_Us lv;
    check2(sizeof(lv), 4, "sizeof(Sf_C_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Sf_C_Us)");
    check_field_offset(lv, v1, 0, "Sf_C_Us.v1");
    check_field_offset(lv, v2, 1, "Sf_C_Us.v2");
    check_field_offset(lv, v3, 2, "Sf_C_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_C_Us(Test_Sf_C_Us, "Sf_C_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_C_Vp  {
  ::empty v1;
  char v2;
  void *v3;
};
//SIG(1 Sf_C_Vp) C1{ FC2{} Fc Fp}



static void Test_Sf_C_Vp()
{
  {
    init_simple_test("Sf_C_Vp");
    Sf_C_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Sf_C_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_C_Vp)");
    check_field_offset(lv, v1, 0, "Sf_C_Vp.v1");
    check_field_offset(lv, v2, 1, "Sf_C_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "Sf_C_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_C_Vp(Test_Sf_C_Vp, "Sf_C_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D  {
  ::empty v1;
  double v2;
};
//SIG(1 Sf_D) C1{ FC2{} FL}



static void Test_Sf_D()
{
  {
    init_simple_test("Sf_D");
    Sf_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D)");
    check_field_offset(lv, v1, 0, "Sf_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D.v2");
  }
}
static Arrange_To_Call_Me vSf_D(Test_Sf_D, "Sf_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu15i  {
  ::empty v1;
  double v2;
  unsigned int v3:15;
};
//SIG(1 Sf_D_BFu15i) C1{ FC2{} FL Fi:15}



static void Test_Sf_D_BFu15i()
{
  {
    init_simple_test("Sf_D_BFu15i");
    static Sf_D_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Sf_D_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Sf_D_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_D_BFu15i(Test_Sf_D_BFu15i, "Sf_D_BFu15i", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu15ll  {
  ::empty v1;
  double v2;
  __tsu64 v3:15;
};
//SIG(1 Sf_D_BFu15ll) C1{ FC2{} FL FL:15}



static void Test_Sf_D_BFu15ll()
{
  {
    init_simple_test("Sf_D_BFu15ll");
    static Sf_D_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Sf_D_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Sf_D_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_D_BFu15ll(Test_Sf_D_BFu15ll, "Sf_D_BFu15ll", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu15s  {
  ::empty v1;
  double v2;
  unsigned short v3:15;
};
//SIG(1 Sf_D_BFu15s) C1{ FC2{} FL Fs:15}



static void Test_Sf_D_BFu15s()
{
  {
    init_simple_test("Sf_D_BFu15s");
    static Sf_D_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu15s)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Sf_D_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Sf_D_BFu15s");
  }
}
static Arrange_To_Call_Me vSf_D_BFu15s(Test_Sf_D_BFu15s, "Sf_D_BFu15s", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu16i  {
  ::empty v1;
  double v2;
  unsigned int v3:16;
};
//SIG(1 Sf_D_BFu16i) C1{ FC2{} FL Fi:16}



static void Test_Sf_D_BFu16i()
{
  {
    init_simple_test("Sf_D_BFu16i");
    static Sf_D_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu16i)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Sf_D_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Sf_D_BFu16i");
  }
}
static Arrange_To_Call_Me vSf_D_BFu16i(Test_Sf_D_BFu16i, "Sf_D_BFu16i", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu16ll  {
  ::empty v1;
  double v2;
  __tsu64 v3:16;
};
//SIG(1 Sf_D_BFu16ll) C1{ FC2{} FL FL:16}



static void Test_Sf_D_BFu16ll()
{
  {
    init_simple_test("Sf_D_BFu16ll");
    static Sf_D_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Sf_D_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Sf_D_BFu16ll");
  }
}
static Arrange_To_Call_Me vSf_D_BFu16ll(Test_Sf_D_BFu16ll, "Sf_D_BFu16ll", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu16s  {
  ::empty v1;
  double v2;
  unsigned short v3:16;
};
//SIG(1 Sf_D_BFu16s) C1{ FC2{} FL Fs:16}



static void Test_Sf_D_BFu16s()
{
  {
    init_simple_test("Sf_D_BFu16s");
    static Sf_D_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu16s)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Sf_D_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Sf_D_BFu16s");
  }
}
static Arrange_To_Call_Me vSf_D_BFu16s(Test_Sf_D_BFu16s, "Sf_D_BFu16s", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu17i  {
  ::empty v1;
  double v2;
  unsigned int v3:17;
};
//SIG(1 Sf_D_BFu17i) C1{ FC2{} FL Fi:17}



static void Test_Sf_D_BFu17i()
{
  {
    init_simple_test("Sf_D_BFu17i");
    static Sf_D_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu17i)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "Sf_D_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "Sf_D_BFu17i");
  }
}
static Arrange_To_Call_Me vSf_D_BFu17i(Test_Sf_D_BFu17i, "Sf_D_BFu17i", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu17ll  {
  ::empty v1;
  double v2;
  __tsu64 v3:17;
};
//SIG(1 Sf_D_BFu17ll) C1{ FC2{} FL FL:17}



static void Test_Sf_D_BFu17ll()
{
  {
    init_simple_test("Sf_D_BFu17ll");
    static Sf_D_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "Sf_D_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "Sf_D_BFu17ll");
  }
}
static Arrange_To_Call_Me vSf_D_BFu17ll(Test_Sf_D_BFu17ll, "Sf_D_BFu17ll", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu1c  {
  ::empty v1;
  double v2;
  unsigned char v3:1;
};
//SIG(1 Sf_D_BFu1c) C1{ FC2{} FL Fc:1}



static void Test_Sf_D_BFu1c()
{
  {
    init_simple_test("Sf_D_BFu1c");
    static Sf_D_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu1c)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Sf_D_BFu1c");
  }
}
static Arrange_To_Call_Me vSf_D_BFu1c(Test_Sf_D_BFu1c, "Sf_D_BFu1c", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu1i  {
  ::empty v1;
  double v2;
  unsigned int v3:1;
};
//SIG(1 Sf_D_BFu1i) C1{ FC2{} FL Fi:1}



static void Test_Sf_D_BFu1i()
{
  {
    init_simple_test("Sf_D_BFu1i");
    static Sf_D_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu1i)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Sf_D_BFu1i");
  }
}
static Arrange_To_Call_Me vSf_D_BFu1i(Test_Sf_D_BFu1i, "Sf_D_BFu1i", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu1ll  {
  ::empty v1;
  double v2;
  __tsu64 v3:1;
};
//SIG(1 Sf_D_BFu1ll) C1{ FC2{} FL FL:1}



static void Test_Sf_D_BFu1ll()
{
  {
    init_simple_test("Sf_D_BFu1ll");
    static Sf_D_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Sf_D_BFu1ll");
  }
}
static Arrange_To_Call_Me vSf_D_BFu1ll(Test_Sf_D_BFu1ll, "Sf_D_BFu1ll", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu1s  {
  ::empty v1;
  double v2;
  unsigned short v3:1;
};
//SIG(1 Sf_D_BFu1s) C1{ FC2{} FL Fs:1}



static void Test_Sf_D_BFu1s()
{
  {
    init_simple_test("Sf_D_BFu1s");
    static Sf_D_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu1s)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Sf_D_BFu1s");
  }
}
static Arrange_To_Call_Me vSf_D_BFu1s(Test_Sf_D_BFu1s, "Sf_D_BFu1s", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu31i  {
  ::empty v1;
  double v2;
  unsigned int v3:31;
};
//SIG(1 Sf_D_BFu31i) C1{ FC2{} FL Fi:31}



static void Test_Sf_D_BFu31i()
{
  {
    init_simple_test("Sf_D_BFu31i");
    static Sf_D_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu31i)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "Sf_D_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "Sf_D_BFu31i");
  }
}
static Arrange_To_Call_Me vSf_D_BFu31i(Test_Sf_D_BFu31i, "Sf_D_BFu31i", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu31ll  {
  ::empty v1;
  double v2;
  __tsu64 v3:31;
};
//SIG(1 Sf_D_BFu31ll) C1{ FC2{} FL FL:31}



static void Test_Sf_D_BFu31ll()
{
  {
    init_simple_test("Sf_D_BFu31ll");
    static Sf_D_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "Sf_D_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "Sf_D_BFu31ll");
  }
}
static Arrange_To_Call_Me vSf_D_BFu31ll(Test_Sf_D_BFu31ll, "Sf_D_BFu31ll", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu32i  {
  ::empty v1;
  double v2;
  unsigned int v3:32;
};
//SIG(1 Sf_D_BFu32i) C1{ FC2{} FL Fi:32}



static void Test_Sf_D_BFu32i()
{
  {
    init_simple_test("Sf_D_BFu32i");
    static Sf_D_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu32i)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Sf_D_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Sf_D_BFu32i");
  }
}
static Arrange_To_Call_Me vSf_D_BFu32i(Test_Sf_D_BFu32i, "Sf_D_BFu32i", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu32ll  {
  ::empty v1;
  double v2;
  __tsu64 v3:32;
};
//SIG(1 Sf_D_BFu32ll) C1{ FC2{} FL FL:32}



static void Test_Sf_D_BFu32ll()
{
  {
    init_simple_test("Sf_D_BFu32ll");
    static Sf_D_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Sf_D_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Sf_D_BFu32ll");
  }
}
static Arrange_To_Call_Me vSf_D_BFu32ll(Test_Sf_D_BFu32ll, "Sf_D_BFu32ll", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu33  {
  ::empty v1;
  double v2;
  __tsu64 v3:33;
};
//SIG(1 Sf_D_BFu33) C1{ FC2{} FL FL:33}



static void Test_Sf_D_BFu33()
{
  {
    init_simple_test("Sf_D_BFu33");
    static Sf_D_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Sf_D_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu33)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "Sf_D_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "Sf_D_BFu33");
  }
}
static Arrange_To_Call_Me vSf_D_BFu33(Test_Sf_D_BFu33, "Sf_D_BFu33", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu7c  {
  ::empty v1;
  double v2;
  unsigned char v3:7;
};
//SIG(1 Sf_D_BFu7c) C1{ FC2{} FL Fc:7}



static void Test_Sf_D_BFu7c()
{
  {
    init_simple_test("Sf_D_BFu7c");
    static Sf_D_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu7c)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Sf_D_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Sf_D_BFu7c");
  }
}
static Arrange_To_Call_Me vSf_D_BFu7c(Test_Sf_D_BFu7c, "Sf_D_BFu7c", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu7i  {
  ::empty v1;
  double v2;
  unsigned int v3:7;
};
//SIG(1 Sf_D_BFu7i) C1{ FC2{} FL Fi:7}



static void Test_Sf_D_BFu7i()
{
  {
    init_simple_test("Sf_D_BFu7i");
    static Sf_D_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu7i)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Sf_D_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Sf_D_BFu7i");
  }
}
static Arrange_To_Call_Me vSf_D_BFu7i(Test_Sf_D_BFu7i, "Sf_D_BFu7i", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu7ll  {
  ::empty v1;
  double v2;
  __tsu64 v3:7;
};
//SIG(1 Sf_D_BFu7ll) C1{ FC2{} FL FL:7}



static void Test_Sf_D_BFu7ll()
{
  {
    init_simple_test("Sf_D_BFu7ll");
    static Sf_D_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Sf_D_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Sf_D_BFu7ll");
  }
}
static Arrange_To_Call_Me vSf_D_BFu7ll(Test_Sf_D_BFu7ll, "Sf_D_BFu7ll", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu7s  {
  ::empty v1;
  double v2;
  unsigned short v3:7;
};
//SIG(1 Sf_D_BFu7s) C1{ FC2{} FL Fs:7}



static void Test_Sf_D_BFu7s()
{
  {
    init_simple_test("Sf_D_BFu7s");
    static Sf_D_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu7s)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Sf_D_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Sf_D_BFu7s");
  }
}
static Arrange_To_Call_Me vSf_D_BFu7s(Test_Sf_D_BFu7s, "Sf_D_BFu7s", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu8c  {
  ::empty v1;
  double v2;
  unsigned char v3:8;
};
//SIG(1 Sf_D_BFu8c) C1{ FC2{} FL Fc:8}



static void Test_Sf_D_BFu8c()
{
  {
    init_simple_test("Sf_D_BFu8c");
    static Sf_D_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu8c)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Sf_D_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Sf_D_BFu8c");
  }
}
static Arrange_To_Call_Me vSf_D_BFu8c(Test_Sf_D_BFu8c, "Sf_D_BFu8c", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu8i  {
  ::empty v1;
  double v2;
  unsigned int v3:8;
};
//SIG(1 Sf_D_BFu8i) C1{ FC2{} FL Fi:8}



static void Test_Sf_D_BFu8i()
{
  {
    init_simple_test("Sf_D_BFu8i");
    static Sf_D_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu8i)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Sf_D_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Sf_D_BFu8i");
  }
}
static Arrange_To_Call_Me vSf_D_BFu8i(Test_Sf_D_BFu8i, "Sf_D_BFu8i", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu8ll  {
  ::empty v1;
  double v2;
  __tsu64 v3:8;
};
//SIG(1 Sf_D_BFu8ll) C1{ FC2{} FL FL:8}



static void Test_Sf_D_BFu8ll()
{
  {
    init_simple_test("Sf_D_BFu8ll");
    static Sf_D_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Sf_D_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Sf_D_BFu8ll");
  }
}
static Arrange_To_Call_Me vSf_D_BFu8ll(Test_Sf_D_BFu8ll, "Sf_D_BFu8ll", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu8s  {
  ::empty v1;
  double v2;
  unsigned short v3:8;
};
//SIG(1 Sf_D_BFu8s) C1{ FC2{} FL Fs:8}



static void Test_Sf_D_BFu8s()
{
  {
    init_simple_test("Sf_D_BFu8s");
    static Sf_D_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu8s)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Sf_D_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Sf_D_BFu8s");
  }
}
static Arrange_To_Call_Me vSf_D_BFu8s(Test_Sf_D_BFu8s, "Sf_D_BFu8s", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu9i  {
  ::empty v1;
  double v2;
  unsigned int v3:9;
};
//SIG(1 Sf_D_BFu9i) C1{ FC2{} FL Fi:9}



static void Test_Sf_D_BFu9i()
{
  {
    init_simple_test("Sf_D_BFu9i");
    static Sf_D_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu9i)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Sf_D_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Sf_D_BFu9i");
  }
}
static Arrange_To_Call_Me vSf_D_BFu9i(Test_Sf_D_BFu9i, "Sf_D_BFu9i", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu9ll  {
  ::empty v1;
  double v2;
  __tsu64 v3:9;
};
//SIG(1 Sf_D_BFu9ll) C1{ FC2{} FL FL:9}



static void Test_Sf_D_BFu9ll()
{
  {
    init_simple_test("Sf_D_BFu9ll");
    static Sf_D_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Sf_D_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Sf_D_BFu9ll");
  }
}
static Arrange_To_Call_Me vSf_D_BFu9ll(Test_Sf_D_BFu9ll, "Sf_D_BFu9ll", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_BFu9s  {
  ::empty v1;
  double v2;
  unsigned short v3:9;
};
//SIG(1 Sf_D_BFu9s) C1{ FC2{} FL Fs:9}



static void Test_Sf_D_BFu9s()
{
  {
    init_simple_test("Sf_D_BFu9s");
    static Sf_D_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_BFu9s)");
    check_field_offset(lv, v1, 0, "Sf_D_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Sf_D_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Sf_D_BFu9s");
  }
}
static Arrange_To_Call_Me vSf_D_BFu9s(Test_Sf_D_BFu9s, "Sf_D_BFu9s", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_C  {
  ::empty v1;
  double v2;
  char v3;
};
//SIG(1 Sf_D_C) C1{ FC2{} FL Fc}



static void Test_Sf_D_C()
{
  {
    init_simple_test("Sf_D_C");
    Sf_D_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_C)");
    check_field_offset(lv, v1, 0, "Sf_D_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Sf_D_C.v3");
  }
}
static Arrange_To_Call_Me vSf_D_C(Test_Sf_D_C, "Sf_D_C", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_D  {
  ::empty v1;
  double v2;
  double v3;
};
//SIG(1 Sf_D_D) C1{ FC2{} FL[2]}



static void Test_Sf_D_D()
{
  {
    init_simple_test("Sf_D_D");
    Sf_D_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Sf_D_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_D)");
    check_field_offset(lv, v1, 0, "Sf_D_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Sf_D_D.v3");
  }
}
static Arrange_To_Call_Me vSf_D_D(Test_Sf_D_D, "Sf_D_D", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_F  {
  ::empty v1;
  double v2;
  float v3;
};
//SIG(1 Sf_D_F) C1{ FC2{} FL Fi}



static void Test_Sf_D_F()
{
  {
    init_simple_test("Sf_D_F");
    Sf_D_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_F)");
    check_field_offset(lv, v1, 0, "Sf_D_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Sf_D_F.v3");
  }
}
static Arrange_To_Call_Me vSf_D_F(Test_Sf_D_F, "Sf_D_F", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_I  {
  ::empty v1;
  double v2;
  int v3;
};
//SIG(1 Sf_D_I) C1{ FC2{} FL Fi}



static void Test_Sf_D_I()
{
  {
    init_simple_test("Sf_D_I");
    Sf_D_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_I)");
    check_field_offset(lv, v1, 0, "Sf_D_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Sf_D_I.v3");
  }
}
static Arrange_To_Call_Me vSf_D_I(Test_Sf_D_I, "Sf_D_I", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_Ip  {
  ::empty v1;
  double v2;
  int *v3;
};
//SIG(1 Sf_D_Ip) C1{ FC2{} FL Fp}



static void Test_Sf_D_Ip()
{
  {
    init_simple_test("Sf_D_Ip");
    Sf_D_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_Ip)");
    check_field_offset(lv, v1, 0, "Sf_D_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Sf_D_Ip.v3");
  }
}
static Arrange_To_Call_Me vSf_D_Ip(Test_Sf_D_Ip, "Sf_D_Ip", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_L  {
  ::empty v1;
  double v2;
  __tsi64 v3;
};
//SIG(1 Sf_D_L) C1{ FC2{} FL[2]}



static void Test_Sf_D_L()
{
  {
    init_simple_test("Sf_D_L");
    Sf_D_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Sf_D_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_L)");
    check_field_offset(lv, v1, 0, "Sf_D_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Sf_D_L.v3");
  }
}
static Arrange_To_Call_Me vSf_D_L(Test_Sf_D_L, "Sf_D_L", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_S  {
  ::empty v1;
  double v2;
  short v3;
};
//SIG(1 Sf_D_S) C1{ FC2{} FL Fs}



static void Test_Sf_D_S()
{
  {
    init_simple_test("Sf_D_S");
    Sf_D_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_S)");
    check_field_offset(lv, v1, 0, "Sf_D_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Sf_D_S.v3");
  }
}
static Arrange_To_Call_Me vSf_D_S(Test_Sf_D_S, "Sf_D_S", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_Sf  {
  ::empty v1;
  double v2;
  ::empty v3;
};
//SIG(1 Sf_D_Sf) C1{ FC2{} FL FC2}



static void Test_Sf_D_Sf()
{
  {
    init_simple_test("Sf_D_Sf");
    Sf_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_Sf)");
    check_field_offset(lv, v1, 0, "Sf_D_Sf.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Sf_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vSf_D_Sf(Test_Sf_D_Sf, "Sf_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_Uc  {
  ::empty v1;
  double v2;
  unsigned char v3;
};
//SIG(1 Sf_D_Uc) C1{ FC2{} FL Fc}



static void Test_Sf_D_Uc()
{
  {
    init_simple_test("Sf_D_Uc");
    Sf_D_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_Uc)");
    check_field_offset(lv, v1, 0, "Sf_D_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Sf_D_Uc.v3");
  }
}
static Arrange_To_Call_Me vSf_D_Uc(Test_Sf_D_Uc, "Sf_D_Uc", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_Ui  {
  ::empty v1;
  double v2;
  unsigned int v3;
};
//SIG(1 Sf_D_Ui) C1{ FC2{} FL Fi}



static void Test_Sf_D_Ui()
{
  {
    init_simple_test("Sf_D_Ui");
    Sf_D_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_Ui)");
    check_field_offset(lv, v1, 0, "Sf_D_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Sf_D_Ui.v3");
  }
}
static Arrange_To_Call_Me vSf_D_Ui(Test_Sf_D_Ui, "Sf_D_Ui", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_Ul  {
  ::empty v1;
  double v2;
  __tsu64 v3;
};
//SIG(1 Sf_D_Ul) C1{ FC2{} FL[2]}



static void Test_Sf_D_Ul()
{
  {
    init_simple_test("Sf_D_Ul");
    Sf_D_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Sf_D_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_Ul)");
    check_field_offset(lv, v1, 0, "Sf_D_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Sf_D_Ul.v3");
  }
}
static Arrange_To_Call_Me vSf_D_Ul(Test_Sf_D_Ul, "Sf_D_Ul", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_Us  {
  ::empty v1;
  double v2;
  unsigned short v3;
};
//SIG(1 Sf_D_Us) C1{ FC2{} FL Fs}



static void Test_Sf_D_Us()
{
  {
    init_simple_test("Sf_D_Us");
    Sf_D_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_Us)");
    check_field_offset(lv, v1, 0, "Sf_D_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Sf_D_Us.v3");
  }
}
static Arrange_To_Call_Me vSf_D_Us(Test_Sf_D_Us, "Sf_D_Us", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_D_Vp  {
  ::empty v1;
  double v2;
  void *v3;
};
//SIG(1 Sf_D_Vp) C1{ FC2{} FL Fp}



static void Test_Sf_D_Vp()
{
  {
    init_simple_test("Sf_D_Vp");
    Sf_D_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Sf_D_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_D_Vp)");
    check_field_offset(lv, v1, 0, "Sf_D_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "Sf_D_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Sf_D_Vp.v3");
  }
}
static Arrange_To_Call_Me vSf_D_Vp(Test_Sf_D_Vp, "Sf_D_Vp", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_F  {
  ::empty v1;
  float v2;
};
//SIG(1 Sf_F) C1{ FC2{} Fi}



static void Test_Sf_F()
{
  {
    init_simple_test("Sf_F");
    Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(Sf_F)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_F)");
    check_field_offset(lv, v1, 0, "Sf_F.v1");
    check_field_offset(lv, v2, 4, "Sf_F.v2");
  }
}
static Arrange_To_Call_Me vSf_F(Test_Sf_F, "Sf_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_F_BFu15i  {
  ::empty v1;
  float v2;
  unsigned int v3:15;
};
//SIG(1 Sf_F_BFu15i) C1{ FC2{} Fi Fi:15}



static void Test_Sf_F_BFu15i()
{
  {
    init_simple_test("Sf_F_BFu15i");
    static Sf_F_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Sf_F_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Sf_F_BFu15i)");
    check_field_offset(lv, v1, 0, "Sf_F_BFu15i.v1");
    check_field_offset(lv, v2, 4, "Sf_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Sf_F_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Sf_F_BFu15i");
  }
}
static Arrange_To_Call_Me vSf_F_BFu15i(Test_Sf_F_BFu15i, "Sf_F_BFu15i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_F_BFu15ll  {
  ::empty v1;
  float v2;
  __tsu64 v3:15;
};
//SIG(1 Sf_F_BFu15ll) C1{ FC2{} Fi FL:15}



static void Test_Sf_F_BFu15ll()
{
  {
    init_simple_test("Sf_F_BFu15ll");
    static Sf_F_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Sf_F_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Sf_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "Sf_F_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "Sf_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Sf_F_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Sf_F_BFu15ll");
  }
}
static Arrange_To_Call_Me vSf_F_BFu15ll(Test_Sf_F_BFu15ll, "Sf_F_BFu15ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  Sf_F_BFu15s  {
  ::empty v1;
  fl