// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  empty  {
};
//SIG(-1 empty) C1{}



static void Test_empty()
{
  {
    init_simple_test("empty");
    empty lv;
    check2(sizeof(lv), 1, "sizeof(empty)");
    check2(__alignof__(lv), 1, "__alignof__(empty)");
  }
}
static Arrange_To_Call_Me vempty(Test_empty, "empty", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu15i_Sf  {
  unsigned int v1:15;
  unsigned int v2:15;
  ::empty v3;
};
//SIG(1 BFu15i_BFu15i_Sf) C1{ Fi:15 Fi:15 FC2{}}



static void Test_BFu15i_BFu15i_Sf()
{
  {
    init_simple_test("BFu15i_BFu15i_Sf");
    static BFu15i_BFu15i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu15i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "BFu15i_BFu15i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu15i_Sf(Test_BFu15i_BFu15i_Sf, "BFu15i_BFu15i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu15ll_Sf  {
  unsigned int v1:15;
  __tsu64 v2:15;
  ::empty v3;
};
//SIG(1 BFu15i_BFu15ll_Sf) C1{ Fi:15 FL:15 FC2{}}



static void Test_BFu15i_BFu15ll_Sf()
{
  {
    init_simple_test("BFu15i_BFu15ll_Sf");
    static BFu15i_BFu15ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15i_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "BFu15i_BFu15ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu15ll_Sf(Test_BFu15i_BFu15ll_Sf, "BFu15i_BFu15ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu15s_Sf  {
  unsigned int v1:15;
  unsigned short v2:15;
  ::empty v3;
};
//SIG(1 BFu15i_BFu15s_Sf) C1{ Fi:15 Fs:15 FC2{}}



static void Test_BFu15i_BFu15s_Sf()
{
  {
    init_simple_test("BFu15i_BFu15s_Sf");
    static BFu15i_BFu15s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu15s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "BFu15i_BFu15s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu15s_Sf(Test_BFu15i_BFu15s_Sf, "BFu15i_BFu15s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu16i_Sf  {
  unsigned int v1:15;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 BFu15i_BFu16i_Sf) C1{ Fi:15 Fi:16 FC2{}}



static void Test_BFu15i_BFu16i_Sf()
{
  {
    init_simple_test("BFu15i_BFu16i_Sf");
    static BFu15i_BFu16i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu16i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu16i_Sf");
    check_field_offset(lv, v3, 4, "BFu15i_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu16i_Sf(Test_BFu15i_BFu16i_Sf, "BFu15i_BFu16i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu16ll_Sf  {
  unsigned int v1:15;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 BFu15i_BFu16ll_Sf) C1{ Fi:15 FL:16 FC2{}}



static void Test_BFu15i_BFu16ll_Sf()
{
  {
    init_simple_test("BFu15i_BFu16ll_Sf");
    static BFu15i_BFu16ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15i_BFu16ll_Sf");
    check_field_offset(lv, v3, 4, "BFu15i_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu16ll_Sf(Test_BFu15i_BFu16ll_Sf, "BFu15i_BFu16ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu16s_Sf  {
  unsigned int v1:15;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 BFu15i_BFu16s_Sf) C1{ Fi:15 Fs:16 FC2{}}



static void Test_BFu15i_BFu16s_Sf()
{
  {
    init_simple_test("BFu15i_BFu16s_Sf");
    static BFu15i_BFu16s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu16s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15i_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "BFu15i_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu16s_Sf(Test_BFu15i_BFu16s_Sf, "BFu15i_BFu16s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu17i_Sf  {
  unsigned int v1:15;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 BFu15i_BFu17i_Sf) C1{ Fi:15 Fi:17 FC2{}}



static void Test_BFu15i_BFu17i_Sf()
{
  {
    init_simple_test("BFu15i_BFu17i_Sf");
    static BFu15i_BFu17i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu17i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu17i_Sf");
    check_field_offset(lv, v3, 4, "BFu15i_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu17i_Sf(Test_BFu15i_BFu17i_Sf, "BFu15i_BFu17i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu17ll_Sf  {
  unsigned int v1:15;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 BFu15i_BFu17ll_Sf) C1{ Fi:15 FL:17 FC2{}}



static void Test_BFu15i_BFu17ll_Sf()
{
  {
    init_simple_test("BFu15i_BFu17ll_Sf");
    static BFu15i_BFu17ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15i_BFu17ll_Sf");
    check_field_offset(lv, v3, 4, "BFu15i_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu17ll_Sf(Test_BFu15i_BFu17ll_Sf, "BFu15i_BFu17ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu1c_Sf  {
  unsigned int v1:15;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 BFu15i_BFu1c_Sf) C1{ Fi:15 Fc:1 FC2{}}



static void Test_BFu15i_BFu1c_Sf()
{
  {
    init_simple_test("BFu15i_BFu1c_Sf");
    static BFu15i_BFu1c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu1c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1c_Sf");
    check_field_offset(lv, v3, 2, "BFu15i_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu1c_Sf(Test_BFu15i_BFu1c_Sf, "BFu15i_BFu1c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu1i_Sf  {
  unsigned int v1:15;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 BFu15i_BFu1i_Sf) C1{ Fi:15 Fi:1 FC2{}}



static void Test_BFu15i_BFu1i_Sf()
{
  {
    init_simple_test("BFu15i_BFu1i_Sf");
    static BFu15i_BFu1i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu1i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1i_Sf");
    check_field_offset(lv, v3, 2, "BFu15i_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu1i_Sf(Test_BFu15i_BFu1i_Sf, "BFu15i_BFu1i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu1ll_Sf  {
  unsigned int v1:15;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 BFu15i_BFu1ll_Sf) C1{ Fi:15 FL:1 FC2{}}



static void Test_BFu15i_BFu1ll_Sf()
{
  {
    init_simple_test("BFu15i_BFu1ll_Sf");
    static BFu15i_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1ll_Sf");
    check_field_offset(lv, v3, 2, "BFu15i_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu1ll_Sf(Test_BFu15i_BFu1ll_Sf, "BFu15i_BFu1ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu1s_Sf  {
  unsigned int v1:15;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 BFu15i_BFu1s_Sf) C1{ Fi:15 Fs:1 FC2{}}



static void Test_BFu15i_BFu1s_Sf()
{
  {
    init_simple_test("BFu15i_BFu1s_Sf");
    static BFu15i_BFu1s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu1s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu1s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15i_BFu1s_Sf");
    check_field_offset(lv, v3, 2, "BFu15i_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu1s_Sf(Test_BFu15i_BFu1s_Sf, "BFu15i_BFu1s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu31i_Sf  {
  unsigned int v1:15;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 BFu15i_BFu31i_Sf) C1{ Fi:15 Fi:31 FC2{}}



static void Test_BFu15i_BFu31i_Sf()
{
  {
    init_simple_test("BFu15i_BFu31i_Sf");
    static BFu15i_BFu31i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_BFu31i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15i_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "BFu15i_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu31i_Sf(Test_BFu15i_BFu31i_Sf, "BFu15i_BFu31i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu31ll_Sf  {
  unsigned int v1:15;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 BFu15i_BFu31ll_Sf) C1{ Fi:15 FL:31 FC2{}}



static void Test_BFu15i_BFu31ll_Sf()
{
  {
    init_simple_test("BFu15i_BFu31ll_Sf");
    static BFu15i_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15i_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "BFu15i_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu31ll_Sf(Test_BFu15i_BFu31ll_Sf, "BFu15i_BFu31ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu32i_Sf  {
  unsigned int v1:15;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 BFu15i_BFu32i_Sf) C1{ Fi:15 Fi:32 FC2{}}



static void Test_BFu15i_BFu32i_Sf()
{
  {
    init_simple_test("BFu15i_BFu32i_Sf");
    static BFu15i_BFu32i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_BFu32i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15i_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu15i_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu32i_Sf(Test_BFu15i_BFu32i_Sf, "BFu15i_BFu32i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu32ll_Sf  {
  unsigned int v1:15;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 BFu15i_BFu32ll_Sf) C1{ Fi:15 FL:32 FC2{}}



static void Test_BFu15i_BFu32ll_Sf()
{
  {
    init_simple_test("BFu15i_BFu32ll_Sf");
    static BFu15i_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15i_BFu32ll_Sf");
    check_field_offset(lv, v3, 6, "BFu15i_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu32ll_Sf(Test_BFu15i_BFu32ll_Sf, "BFu15i_BFu32ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu33_Sf  {
  unsigned int v1:15;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 BFu15i_BFu33_Sf) C1{ Fi:15 FL:33 FC2{}}



static void Test_BFu15i_BFu33_Sf()
{
  {
    init_simple_test("BFu15i_BFu33_Sf");
    static BFu15i_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15i_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15i_BFu33_Sf");
    check_field_offset(lv, v3, 6, "BFu15i_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu33_Sf(Test_BFu15i_BFu33_Sf, "BFu15i_BFu33_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu7c_Sf  {
  unsigned int v1:15;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 BFu15i_BFu7c_Sf) C1{ Fi:15 Fc:7 FC2{}}



static void Test_BFu15i_BFu7c_Sf()
{
  {
    init_simple_test("BFu15i_BFu7c_Sf");
    static BFu15i_BFu7c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "BFu15i_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu7c_Sf(Test_BFu15i_BFu7c_Sf, "BFu15i_BFu7c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu7i_Sf  {
  unsigned int v1:15;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 BFu15i_BFu7i_Sf) C1{ Fi:15 Fi:7 FC2{}}



static void Test_BFu15i_BFu7i_Sf()
{
  {
    init_simple_test("BFu15i_BFu7i_Sf");
    static BFu15i_BFu7i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "BFu15i_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu7i_Sf(Test_BFu15i_BFu7i_Sf, "BFu15i_BFu7i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu7ll_Sf  {
  unsigned int v1:15;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 BFu15i_BFu7ll_Sf) C1{ Fi:15 FL:7 FC2{}}



static void Test_BFu15i_BFu7ll_Sf()
{
  {
    init_simple_test("BFu15i_BFu7ll_Sf");
    static BFu15i_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15i_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "BFu15i_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu7ll_Sf(Test_BFu15i_BFu7ll_Sf, "BFu15i_BFu7ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu7s_Sf  {
  unsigned int v1:15;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 BFu15i_BFu7s_Sf) C1{ Fi:15 Fs:7 FC2{}}



static void Test_BFu15i_BFu7s_Sf()
{
  {
    init_simple_test("BFu15i_BFu7s_Sf");
    static BFu15i_BFu7s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu7s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15i_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "BFu15i_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu7s_Sf(Test_BFu15i_BFu7s_Sf, "BFu15i_BFu7s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu8c_Sf  {
  unsigned int v1:15;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 BFu15i_BFu8c_Sf) C1{ Fi:15 Fc:8 FC2{}}



static void Test_BFu15i_BFu8c_Sf()
{
  {
    init_simple_test("BFu15i_BFu8c_Sf");
    static BFu15i_BFu8c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu8c_Sf");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu8c_Sf(Test_BFu15i_BFu8c_Sf, "BFu15i_BFu8c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu8i_Sf  {
  unsigned int v1:15;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 BFu15i_BFu8i_Sf) C1{ Fi:15 Fi:8 FC2{}}



static void Test_BFu15i_BFu8i_Sf()
{
  {
    init_simple_test("BFu15i_BFu8i_Sf");
    static BFu15i_BFu8i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8i_Sf");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu8i_Sf(Test_BFu15i_BFu8i_Sf, "BFu15i_BFu8i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu8ll_Sf  {
  unsigned int v1:15;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 BFu15i_BFu8ll_Sf) C1{ Fi:15 FL:8 FC2{}}



static void Test_BFu15i_BFu8ll_Sf()
{
  {
    init_simple_test("BFu15i_BFu8ll_Sf");
    static BFu15i_BFu8ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15i_BFu8ll_Sf");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu8ll_Sf(Test_BFu15i_BFu8ll_Sf, "BFu15i_BFu8ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu8s_Sf  {
  unsigned int v1:15;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 BFu15i_BFu8s_Sf) C1{ Fi:15 Fs:8 FC2{}}



static void Test_BFu15i_BFu8s_Sf()
{
  {
    init_simple_test("BFu15i_BFu8s_Sf");
    static BFu15i_BFu8s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu8s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15i_BFu8s_Sf");
    check_field_offset(lv, v3, 3, "BFu15i_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu8s_Sf(Test_BFu15i_BFu8s_Sf, "BFu15i_BFu8s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu9i_Sf  {
  unsigned int v1:15;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 BFu15i_BFu9i_Sf) C1{ Fi:15 Fi:9 FC2{}}



static void Test_BFu15i_BFu9i_Sf()
{
  {
    init_simple_test("BFu15i_BFu9i_Sf");
    static BFu15i_BFu9i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_BFu9i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9i_Sf");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu9i_Sf(Test_BFu15i_BFu9i_Sf, "BFu15i_BFu9i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu9ll_Sf  {
  unsigned int v1:15;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 BFu15i_BFu9ll_Sf) C1{ Fi:15 FL:9 FC2{}}



static void Test_BFu15i_BFu9ll_Sf()
{
  {
    init_simple_test("BFu15i_BFu9ll_Sf");
    static BFu15i_BFu9ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15i_BFu9ll_Sf");
    check_field_offset(lv, v3, 3, "BFu15i_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu9ll_Sf(Test_BFu15i_BFu9ll_Sf, "BFu15i_BFu9ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_BFu9s_Sf  {
  unsigned int v1:15;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 BFu15i_BFu9s_Sf) C1{ Fi:15 Fs:9 FC2{}}



static void Test_BFu15i_BFu9s_Sf()
{
  {
    init_simple_test("BFu15i_BFu9s_Sf");
    static BFu15i_BFu9s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_BFu9s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15i_BFu9s_Sf");
    check_field_offset(lv, v3, 4, "BFu15i_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_BFu9s_Sf(Test_BFu15i_BFu9s_Sf, "BFu15i_BFu9s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_C_Sf  {
  unsigned int v1:15;
  char v2;
  ::empty v3;
};
//SIG(1 BFu15i_C_Sf) C1{ Fi:15 Fc FC2{}}



static void Test_BFu15i_C_Sf()
{
  {
    init_simple_test("BFu15i_C_Sf");
    static BFu15i_C_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_C_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_C_Sf");
    check_field_offset(lv, v2, 2, "BFu15i_C_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu15i_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_C_Sf(Test_BFu15i_C_Sf, "BFu15i_C_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_D_Sf  {
  unsigned int v1:15;
  double v2;
  ::empty v3;
};
//SIG(1 BFu15i_D_Sf) C1{ Fi:15 FL FC2{}}



static void Test_BFu15i_D_Sf()
{
  {
    init_simple_test("BFu15i_D_Sf");
    static BFu15i_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu15i_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_D_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu15i_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_D_Sf(Test_BFu15i_D_Sf, "BFu15i_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_F_Sf  {
  unsigned int v1:15;
  float v2;
  ::empty v3;
};
//SIG(1 BFu15i_F_Sf) C1{ Fi:15 Fi FC2{}}



static void Test_BFu15i_F_Sf()
{
  {
    init_simple_test("BFu15i_F_Sf");
    static BFu15i_F_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_F_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_F_Sf");
    check_field_offset(lv, v2, 4, "BFu15i_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu15i_F_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_F_Sf(Test_BFu15i_F_Sf, "BFu15i_F_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_I_Sf  {
  unsigned int v1:15;
  int v2;
  ::empty v3;
};
//SIG(1 BFu15i_I_Sf) C1{ Fi:15 Fi FC2{}}



static void Test_BFu15i_I_Sf()
{
  {
    init_simple_test("BFu15i_I_Sf");
    static BFu15i_I_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_I_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_I_Sf");
    check_field_offset(lv, v2, 4, "BFu15i_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu15i_I_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_I_Sf(Test_BFu15i_I_Sf, "BFu15i_I_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Ip_Sf  {
  unsigned int v1:15;
  int *v2;
  ::empty v3;
};
//SIG(1 BFu15i_Ip_Sf) C1{ Fi:15 Fp FC2{}}



static void Test_BFu15i_Ip_Sf()
{
  {
    init_simple_test("BFu15i_Ip_Sf");
    static BFu15i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu15i_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ip_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu15i_Ip_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Ip_Sf(Test_BFu15i_Ip_Sf, "BFu15i_Ip_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_L_Sf  {
  unsigned int v1:15;
  __tsi64 v2;
  ::empty v3;
};
//SIG(1 BFu15i_L_Sf) C1{ Fi:15 FL FC2{}}



static void Test_BFu15i_L_Sf()
{
  {
    init_simple_test("BFu15i_L_Sf");
    static BFu15i_L_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu15i_L_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_L_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_L_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu15i_L_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_L_Sf(Test_BFu15i_L_Sf, "BFu15i_L_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_S_Sf  {
  unsigned int v1:15;
  short v2;
  ::empty v3;
};
//SIG(1 BFu15i_S_Sf) C1{ Fi:15 Fs FC2{}}



static void Test_BFu15i_S_Sf()
{
  {
    init_simple_test("BFu15i_S_Sf");
    static BFu15i_S_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_S_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_S_Sf");
    check_field_offset(lv, v2, 2, "BFu15i_S_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu15i_S_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_S_Sf(Test_BFu15i_S_Sf, "BFu15i_S_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf  {
  unsigned int v1:15;
  ::empty v2;
};
//SIG(1 BFu15i_Sf) C1{ Fi:15 FC2{}}



static void Test_BFu15i_Sf()
{
  {
    init_simple_test("BFu15i_Sf");
    static BFu15i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf");
    check_field_offset(lv, v2, 2, "BFu15i_Sf.v2");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf(Test_BFu15i_Sf, "BFu15i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu15i  {
  unsigned int v1:15;
  ::empty v2;
  unsigned int v3:15;
};
//SIG(1 BFu15i_Sf_BFu15i) C1{ Fi:15 FC2{} Fi:15}



static void Test_BFu15i_Sf_BFu15i()
{
  {
    init_simple_test("BFu15i_Sf_BFu15i");
    static BFu15i_Sf_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu15i(Test_BFu15i_Sf_BFu15i, "BFu15i_Sf_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu15ll  {
  unsigned int v1:15;
  ::empty v2;
  __tsu64 v3:15;
};
//SIG(1 BFu15i_Sf_BFu15ll) C1{ Fi:15 FC2{} FL:15}



static void Test_BFu15i_Sf_BFu15ll()
{
  {
    init_simple_test("BFu15i_Sf_BFu15ll");
    static BFu15i_Sf_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu15ll(Test_BFu15i_Sf_BFu15ll, "BFu15i_Sf_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu15s  {
  unsigned int v1:15;
  ::empty v2;
  unsigned short v3:15;
};
//SIG(1 BFu15i_Sf_BFu15s) C1{ Fi:15 FC2{} Fs:15}



static void Test_BFu15i_Sf_BFu15s()
{
  {
    init_simple_test("BFu15i_Sf_BFu15s");
    static BFu15i_Sf_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu15s(Test_BFu15i_Sf_BFu15s, "BFu15i_Sf_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu16i  {
  unsigned int v1:15;
  ::empty v2;
  unsigned int v3:16;
};
//SIG(1 BFu15i_Sf_BFu16i) C1{ Fi:15 FC2{} Fi:16}



static void Test_BFu15i_Sf_BFu16i()
{
  {
    init_simple_test("BFu15i_Sf_BFu16i");
    static BFu15i_Sf_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15i_Sf_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu16i(Test_BFu15i_Sf_BFu16i, "BFu15i_Sf_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu16ll  {
  unsigned int v1:15;
  ::empty v2;
  __tsu64 v3:16;
};
//SIG(1 BFu15i_Sf_BFu16ll) C1{ Fi:15 FC2{} FL:16}



static void Test_BFu15i_Sf_BFu16ll()
{
  {
    init_simple_test("BFu15i_Sf_BFu16ll");
    static BFu15i_Sf_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15i_Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu16ll(Test_BFu15i_Sf_BFu16ll, "BFu15i_Sf_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu16s  {
  unsigned int v1:15;
  ::empty v2;
  unsigned short v3:16;
};
//SIG(1 BFu15i_Sf_BFu16s) C1{ Fi:15 FC2{} Fs:16}



static void Test_BFu15i_Sf_BFu16s()
{
  {
    init_simple_test("BFu15i_Sf_BFu16s");
    static BFu15i_Sf_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15i_Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu16s(Test_BFu15i_Sf_BFu16s, "BFu15i_Sf_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu17i  {
  unsigned int v1:15;
  ::empty v2;
  unsigned int v3:17;
};
//SIG(1 BFu15i_Sf_BFu17i) C1{ Fi:15 FC2{} Fi:17}



static void Test_BFu15i_Sf_BFu17i()
{
  {
    init_simple_test("BFu15i_Sf_BFu17i");
    static BFu15i_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15i_Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu17i(Test_BFu15i_Sf_BFu17i, "BFu15i_Sf_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu17ll  {
  unsigned int v1:15;
  ::empty v2;
  __tsu64 v3:17;
};
//SIG(1 BFu15i_Sf_BFu17ll) C1{ Fi:15 FC2{} FL:17}



static void Test_BFu15i_Sf_BFu17ll()
{
  {
    init_simple_test("BFu15i_Sf_BFu17ll");
    static BFu15i_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15i_Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu17ll(Test_BFu15i_Sf_BFu17ll, "BFu15i_Sf_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu1c  {
  unsigned int v1:15;
  ::empty v2;
  unsigned char v3:1;
};
//SIG(1 BFu15i_Sf_BFu1c) C1{ Fi:15 FC2{} Fc:1}



static void Test_BFu15i_Sf_BFu1c()
{
  {
    init_simple_test("BFu15i_Sf_BFu1c");
    static BFu15i_Sf_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Sf_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu1c(Test_BFu15i_Sf_BFu1c, "BFu15i_Sf_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu1i  {
  unsigned int v1:15;
  ::empty v2;
  unsigned int v3:1;
};
//SIG(1 BFu15i_Sf_BFu1i) C1{ Fi:15 FC2{} Fi:1}



static void Test_BFu15i_Sf_BFu1i()
{
  {
    init_simple_test("BFu15i_Sf_BFu1i");
    static BFu15i_Sf_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Sf_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu1i(Test_BFu15i_Sf_BFu1i, "BFu15i_Sf_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu1ll  {
  unsigned int v1:15;
  ::empty v2;
  __tsu64 v3:1;
};
//SIG(1 BFu15i_Sf_BFu1ll) C1{ Fi:15 FC2{} FL:1}



static void Test_BFu15i_Sf_BFu1ll()
{
  {
    init_simple_test("BFu15i_Sf_BFu1ll");
    static BFu15i_Sf_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu1ll(Test_BFu15i_Sf_BFu1ll, "BFu15i_Sf_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu1s  {
  unsigned int v1:15;
  ::empty v2;
  unsigned short v3:1;
};
//SIG(1 BFu15i_Sf_BFu1s) C1{ Fi:15 FC2{} Fs:1}



static void Test_BFu15i_Sf_BFu1s()
{
  {
    init_simple_test("BFu15i_Sf_BFu1s");
    static BFu15i_Sf_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Sf_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15i_Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu1s(Test_BFu15i_Sf_BFu1s, "BFu15i_Sf_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu31i  {
  unsigned int v1:15;
  ::empty v2;
  unsigned int v3:31;
};
//SIG(1 BFu15i_Sf_BFu31i) C1{ Fi:15 FC2{} Fi:31}



static void Test_BFu15i_Sf_BFu31i()
{
  {
    init_simple_test("BFu15i_Sf_BFu31i");
    static BFu15i_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15i_Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu31i(Test_BFu15i_Sf_BFu31i, "BFu15i_Sf_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu31ll  {
  unsigned int v1:15;
  ::empty v2;
  __tsu64 v3:31;
};
//SIG(1 BFu15i_Sf_BFu31ll) C1{ Fi:15 FC2{} FL:31}



static void Test_BFu15i_Sf_BFu31ll()
{
  {
    init_simple_test("BFu15i_Sf_BFu31ll");
    static BFu15i_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15i_Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu31ll(Test_BFu15i_Sf_BFu31ll, "BFu15i_Sf_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu32i  {
  unsigned int v1:15;
  ::empty v2;
  unsigned int v3:32;
};
//SIG(1 BFu15i_Sf_BFu32i) C1{ Fi:15 FC2{} Fi:32}



static void Test_BFu15i_Sf_BFu32i()
{
  {
    init_simple_test("BFu15i_Sf_BFu32i");
    static BFu15i_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15i_Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu32i(Test_BFu15i_Sf_BFu32i, "BFu15i_Sf_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu32ll  {
  unsigned int v1:15;
  ::empty v2;
  __tsu64 v3:32;
};
//SIG(1 BFu15i_Sf_BFu32ll) C1{ Fi:15 FC2{} FL:32}



static void Test_BFu15i_Sf_BFu32ll()
{
  {
    init_simple_test("BFu15i_Sf_BFu32ll");
    static BFu15i_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15i_Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu32ll(Test_BFu15i_Sf_BFu32ll, "BFu15i_Sf_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu33  {
  unsigned int v1:15;
  ::empty v2;
  __tsu64 v3:33;
};
//SIG(1 BFu15i_Sf_BFu33) C1{ Fi:15 FC2{} FL:33}



static void Test_BFu15i_Sf_BFu33()
{
  {
    init_simple_test("BFu15i_Sf_BFu33");
    static BFu15i_Sf_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu33");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu15i_Sf_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu15i_Sf_BFu33");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu33(Test_BFu15i_Sf_BFu33, "BFu15i_Sf_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu7c  {
  unsigned int v1:15;
  ::empty v2;
  unsigned char v3:7;
};
//SIG(1 BFu15i_Sf_BFu7c) C1{ Fi:15 FC2{} Fc:7}



static void Test_BFu15i_Sf_BFu7c()
{
  {
    init_simple_test("BFu15i_Sf_BFu7c");
    static BFu15i_Sf_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Sf_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu7c(Test_BFu15i_Sf_BFu7c, "BFu15i_Sf_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu7i  {
  unsigned int v1:15;
  ::empty v2;
  unsigned int v3:7;
};
//SIG(1 BFu15i_Sf_BFu7i) C1{ Fi:15 FC2{} Fi:7}



static void Test_BFu15i_Sf_BFu7i()
{
  {
    init_simple_test("BFu15i_Sf_BFu7i");
    static BFu15i_Sf_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Sf_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_Sf_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu7i(Test_BFu15i_Sf_BFu7i, "BFu15i_Sf_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu7ll  {
  unsigned int v1:15;
  ::empty v2;
  __tsu64 v3:7;
};
//SIG(1 BFu15i_Sf_BFu7ll) C1{ Fi:15 FC2{} FL:7}



static void Test_BFu15i_Sf_BFu7ll()
{
  {
    init_simple_test("BFu15i_Sf_BFu7ll");
    static BFu15i_Sf_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_Sf_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu7ll(Test_BFu15i_Sf_BFu7ll, "BFu15i_Sf_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu7s  {
  unsigned int v1:15;
  ::empty v2;
  unsigned short v3:7;
};
//SIG(1 BFu15i_Sf_BFu7s) C1{ Fi:15 FC2{} Fs:7}



static void Test_BFu15i_Sf_BFu7s()
{
  {
    init_simple_test("BFu15i_Sf_BFu7s");
    static BFu15i_Sf_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Sf_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15i_Sf_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu7s(Test_BFu15i_Sf_BFu7s, "BFu15i_Sf_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu8c  {
  unsigned int v1:15;
  ::empty v2;
  unsigned char v3:8;
};
//SIG(1 BFu15i_Sf_BFu8c) C1{ Fi:15 FC2{} Fc:8}



static void Test_BFu15i_Sf_BFu8c()
{
  {
    init_simple_test("BFu15i_Sf_BFu8c");
    static BFu15i_Sf_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Sf_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_Sf_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu8c(Test_BFu15i_Sf_BFu8c, "BFu15i_Sf_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu8i  {
  unsigned int v1:15;
  ::empty v2;
  unsigned int v3:8;
};
//SIG(1 BFu15i_Sf_BFu8i) C1{ Fi:15 FC2{} Fi:8}



static void Test_BFu15i_Sf_BFu8i()
{
  {
    init_simple_test("BFu15i_Sf_BFu8i");
    static BFu15i_Sf_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Sf_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_Sf_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_Sf_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu8i(Test_BFu15i_Sf_BFu8i, "BFu15i_Sf_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu8ll  {
  unsigned int v1:15;
  ::empty v2;
  __tsu64 v3:8;
};
//SIG(1 BFu15i_Sf_BFu8ll) C1{ Fi:15 FC2{} FL:8}



static void Test_BFu15i_Sf_BFu8ll()
{
  {
    init_simple_test("BFu15i_Sf_BFu8ll");
    static BFu15i_Sf_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15i_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_Sf_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu8ll(Test_BFu15i_Sf_BFu8ll, "BFu15i_Sf_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu8s  {
  unsigned int v1:15;
  ::empty v2;
  unsigned short v3:8;
};
//SIG(1 BFu15i_Sf_BFu8s) C1{ Fi:15 FC2{} Fs:8}



static void Test_BFu15i_Sf_BFu8s()
{
  {
    init_simple_test("BFu15i_Sf_BFu8s");
    static BFu15i_Sf_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Sf_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15i_Sf_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15i_Sf_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu8s(Test_BFu15i_Sf_BFu8s, "BFu15i_Sf_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu9i  {
  unsigned int v1:15;
  ::empty v2;
  unsigned int v3:9;
};
//SIG(1 BFu15i_Sf_BFu9i) C1{ Fi:15 FC2{} Fi:9}



static void Test_BFu15i_Sf_BFu9i()
{
  {
    init_simple_test("BFu15i_Sf_BFu9i");
    static BFu15i_Sf_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15i_Sf_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15i_Sf_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu9i(Test_BFu15i_Sf_BFu9i, "BFu15i_Sf_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu9ll  {
  unsigned int v1:15;
  ::empty v2;
  __tsu64 v3:9;
};
//SIG(1 BFu15i_Sf_BFu9ll) C1{ Fi:15 FC2{} FL:9}



static void Test_BFu15i_Sf_BFu9ll()
{
  {
    init_simple_test("BFu15i_Sf_BFu9ll");
    static BFu15i_Sf_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15i_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15i_Sf_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu9ll(Test_BFu15i_Sf_BFu9ll, "BFu15i_Sf_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_BFu9s  {
  unsigned int v1:15;
  ::empty v2;
  unsigned short v3:9;
};
//SIG(1 BFu15i_Sf_BFu9s) C1{ Fi:15 FC2{} Fs:9}



static void Test_BFu15i_Sf_BFu9s()
{
  {
    init_simple_test("BFu15i_Sf_BFu9s");
    static BFu15i_Sf_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15i_Sf_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15i_Sf_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_BFu9s(Test_BFu15i_Sf_BFu9s, "BFu15i_Sf_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_C  {
  unsigned int v1:15;
  ::empty v2;
  char v3;
};
//SIG(1 BFu15i_Sf_C) C1{ Fi:15 FC2{} Fc}



static void Test_BFu15i_Sf_C()
{
  {
    init_simple_test("BFu15i_Sf_C");
    static BFu15i_Sf_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Sf_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_C");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_C.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Sf_C.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_C(Test_BFu15i_Sf_C, "BFu15i_Sf_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_D  {
  unsigned int v1:15;
  ::empty v2;
  double v3;
};
//SIG(1 BFu15i_Sf_D) C1{ Fi:15 FC2{} FL}



static void Test_BFu15i_Sf_D()
{
  {
    init_simple_test("BFu15i_Sf_D");
    static BFu15i_Sf_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_Sf_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_D");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15i_Sf_D.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_D(Test_BFu15i_Sf_D, "BFu15i_Sf_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_F  {
  unsigned int v1:15;
  ::empty v2;
  float v3;
};
//SIG(1 BFu15i_Sf_F) C1{ Fi:15 FC2{} Fi}



static void Test_BFu15i_Sf_F()
{
  {
    init_simple_test("BFu15i_Sf_F");
    static BFu15i_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_F");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Sf_F.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_F(Test_BFu15i_Sf_F, "BFu15i_Sf_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_I  {
  unsigned int v1:15;
  ::empty v2;
  int v3;
};
//SIG(1 BFu15i_Sf_I) C1{ Fi:15 FC2{} Fi}



static void Test_BFu15i_Sf_I()
{
  {
    init_simple_test("BFu15i_Sf_I");
    static BFu15i_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_I");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Sf_I.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_I(Test_BFu15i_Sf_I, "BFu15i_Sf_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_Ip  {
  unsigned int v1:15;
  ::empty v2;
  int *v3;
};
//SIG(1 BFu15i_Sf_Ip) C1{ Fi:15 FC2{} Fp}



static void Test_BFu15i_Sf_Ip()
{
  {
    init_simple_test("BFu15i_Sf_Ip");
    static BFu15i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_Ip");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15i_Sf_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_Ip(Test_BFu15i_Sf_Ip, "BFu15i_Sf_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_L  {
  unsigned int v1:15;
  ::empty v2;
  __tsi64 v3;
};
//SIG(1 BFu15i_Sf_L) C1{ Fi:15 FC2{} FL}



static void Test_BFu15i_Sf_L()
{
  {
    init_simple_test("BFu15i_Sf_L");
    static BFu15i_Sf_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_Sf_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_L");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15i_Sf_L.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_L(Test_BFu15i_Sf_L, "BFu15i_Sf_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_S  {
  unsigned int v1:15;
  ::empty v2;
  short v3;
};
//SIG(1 BFu15i_Sf_S) C1{ Fi:15 FC2{} Fs}



static void Test_BFu15i_Sf_S()
{
  {
    init_simple_test("BFu15i_Sf_S");
    static BFu15i_Sf_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_S");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_S.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Sf_S.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_S(Test_BFu15i_Sf_S, "BFu15i_Sf_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_Sf  {
  unsigned int v1:15;
  ::empty v2;
  ::empty v3;
};
//SIG(1 BFu15i_Sf_Sf) C1{ Fi:15 FC2{} FC2}



static void Test_BFu15i_Sf_Sf()
{
  {
    init_simple_test("BFu15i_Sf_Sf");
    static BFu15i_Sf_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Sf_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_Sf");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Sf_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_Sf(Test_BFu15i_Sf_Sf, "BFu15i_Sf_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_Uc  {
  unsigned int v1:15;
  ::empty v2;
  unsigned char v3;
};
//SIG(1 BFu15i_Sf_Uc) C1{ Fi:15 FC2{} Fc}



static void Test_BFu15i_Sf_Uc()
{
  {
    init_simple_test("BFu15i_Sf_Uc");
    static BFu15i_Sf_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Sf_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_Uc");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Sf_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_Uc(Test_BFu15i_Sf_Uc, "BFu15i_Sf_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_Ui  {
  unsigned int v1:15;
  ::empty v2;
  unsigned int v3;
};
//SIG(1 BFu15i_Sf_Ui) C1{ Fi:15 FC2{} Fi}



static void Test_BFu15i_Sf_Ui()
{
  {
    init_simple_test("BFu15i_Sf_Ui");
    static BFu15i_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_Ui");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Sf_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_Ui(Test_BFu15i_Sf_Ui, "BFu15i_Sf_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_Ul  {
  unsigned int v1:15;
  ::empty v2;
  __tsu64 v3;
};
//SIG(1 BFu15i_Sf_Ul) C1{ Fi:15 FC2{} FL}



static void Test_BFu15i_Sf_Ul()
{
  {
    init_simple_test("BFu15i_Sf_Ul");
    static BFu15i_Sf_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15i_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_Ul");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15i_Sf_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_Ul(Test_BFu15i_Sf_Ul, "BFu15i_Sf_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_Us  {
  unsigned int v1:15;
  ::empty v2;
  unsigned short v3;
};
//SIG(1 BFu15i_Sf_Us) C1{ Fi:15 FC2{} Fs}



static void Test_BFu15i_Sf_Us()
{
  {
    init_simple_test("BFu15i_Sf_Us");
    static BFu15i_Sf_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Sf_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_Us");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_Us.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Sf_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_Us(Test_BFu15i_Sf_Us, "BFu15i_Sf_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Sf_Vp  {
  unsigned int v1:15;
  ::empty v2;
  void *v3;
};
//SIG(1 BFu15i_Sf_Vp) C1{ Fi:15 FC2{} Fp}



static void Test_BFu15i_Sf_Vp()
{
  {
    init_simple_test("BFu15i_Sf_Vp");
    static BFu15i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15i_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Sf_Vp");
    check_field_offset(lv, v2, 2, "BFu15i_Sf_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15i_Sf_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Sf_Vp(Test_BFu15i_Sf_Vp, "BFu15i_Sf_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Uc_Sf  {
  unsigned int v1:15;
  unsigned char v2;
  ::empty v3;
};
//SIG(1 BFu15i_Uc_Sf) C1{ Fi:15 Fc FC2{}}



static void Test_BFu15i_Uc_Sf()
{
  {
    init_simple_test("BFu15i_Uc_Sf");
    static BFu15i_Uc_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15i_Uc_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Uc_Sf");
    check_field_offset(lv, v2, 2, "BFu15i_Uc_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu15i_Uc_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Uc_Sf(Test_BFu15i_Uc_Sf, "BFu15i_Uc_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Ui_Sf  {
  unsigned int v1:15;
  unsigned int v2;
  ::empty v3;
};
//SIG(1 BFu15i_Ui_Sf) C1{ Fi:15 Fi FC2{}}



static void Test_BFu15i_Ui_Sf()
{
  {
    init_simple_test("BFu15i_Ui_Sf");
    static BFu15i_Ui_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu15i_Ui_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu15i_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu15i_Ui_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Ui_Sf(Test_BFu15i_Ui_Sf, "BFu15i_Ui_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Ul_Sf  {
  unsigned int v1:15;
  __tsu64 v2;
  ::empty v3;
};
//SIG(1 BFu15i_Ul_Sf) C1{ Fi:15 FL FC2{}}



static void Test_BFu15i_Ul_Sf()
{
  {
    init_simple_test("BFu15i_Ul_Sf");
    static BFu15i_Ul_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu15i_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Ul_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Ul_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu15i_Ul_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Ul_Sf(Test_BFu15i_Ul_Sf, "BFu15i_Ul_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Us_Sf  {
  unsigned int v1:15;
  unsigned short v2;
  ::empty v3;
};
//SIG(1 BFu15i_Us_Sf) C1{ Fi:15 Fs FC2{}}



static void Test_BFu15i_Us_Sf()
{
  {
    init_simple_test("BFu15i_Us_Sf");
    static BFu15i_Us_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15i_Us_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15i_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Us_Sf");
    check_field_offset(lv, v2, 2, "BFu15i_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu15i_Us_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Us_Sf(Test_BFu15i_Us_Sf, "BFu15i_Us_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15i_Vp_Sf  {
  unsigned int v1:15;
  void *v2;
  ::empty v3;
};
//SIG(1 BFu15i_Vp_Sf) C1{ Fi:15 Fp FC2{}}



static void Test_BFu15i_Vp_Sf()
{
  {
    init_simple_test("BFu15i_Vp_Sf");
    static BFu15i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu15i_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15i_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15i_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15i_Vp_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15i_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu15i_Vp_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15i_Vp_Sf(Test_BFu15i_Vp_Sf, "BFu15i_Vp_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu15i_Sf  {
  __tsu64 v1:15;
  unsigned int v2:15;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu15i_Sf) C1{ FL:15 Fi:15 FC2{}}



static void Test_BFu15ll_BFu15i_Sf()
{
  {
    init_simple_test("BFu15ll_BFu15i_Sf");
    static BFu15ll_BFu15i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu15i_Sf(Test_BFu15ll_BFu15i_Sf, "BFu15ll_BFu15i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu15ll_Sf  {
  __tsu64 v1:15;
  __tsu64 v2:15;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu15ll_Sf) C1{ FL:15 FL:15 FC2{}}



static void Test_BFu15ll_BFu15ll_Sf()
{
  {
    init_simple_test("BFu15ll_BFu15ll_Sf");
    static BFu15ll_BFu15ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15ll_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu15ll_Sf(Test_BFu15ll_BFu15ll_Sf, "BFu15ll_BFu15ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu15s_Sf  {
  __tsu64 v1:15;
  unsigned short v2:15;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu15s_Sf) C1{ FL:15 Fs:15 FC2{}}



static void Test_BFu15ll_BFu15s_Sf()
{
  {
    init_simple_test("BFu15ll_BFu15s_Sf");
    static BFu15ll_BFu15s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu15s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu15s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu15s_Sf(Test_BFu15ll_BFu15s_Sf, "BFu15ll_BFu15s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu16i_Sf  {
  __tsu64 v1:15;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu16i_Sf) C1{ FL:15 Fi:16 FC2{}}



static void Test_BFu15ll_BFu16i_Sf()
{
  {
    init_simple_test("BFu15ll_BFu16i_Sf");
    static BFu15ll_BFu16i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16i_Sf");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu16i_Sf(Test_BFu15ll_BFu16i_Sf, "BFu15ll_BFu16i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu16ll_Sf  {
  __tsu64 v1:15;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu16ll_Sf) C1{ FL:15 FL:16 FC2{}}



static void Test_BFu15ll_BFu16ll_Sf()
{
  {
    init_simple_test("BFu15ll_BFu16ll_Sf");
    static BFu15ll_BFu16ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15ll_BFu16ll_Sf");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu16ll_Sf(Test_BFu15ll_BFu16ll_Sf, "BFu15ll_BFu16ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu16s_Sf  {
  __tsu64 v1:15;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu16s_Sf) C1{ FL:15 Fs:16 FC2{}}



static void Test_BFu15ll_BFu16s_Sf()
{
  {
    init_simple_test("BFu15ll_BFu16s_Sf");
    static BFu15ll_BFu16s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu16s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15ll_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu16s_Sf(Test_BFu15ll_BFu16s_Sf, "BFu15ll_BFu16s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu17i_Sf  {
  __tsu64 v1:15;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu17i_Sf) C1{ FL:15 Fi:17 FC2{}}



static void Test_BFu15ll_BFu17i_Sf()
{
  {
    init_simple_test("BFu15ll_BFu17i_Sf");
    static BFu15ll_BFu17i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17i_Sf");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu17i_Sf(Test_BFu15ll_BFu17i_Sf, "BFu15ll_BFu17i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu17ll_Sf  {
  __tsu64 v1:15;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu17ll_Sf) C1{ FL:15 FL:17 FC2{}}



static void Test_BFu15ll_BFu17ll_Sf()
{
  {
    init_simple_test("BFu15ll_BFu17ll_Sf");
    static BFu15ll_BFu17ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15ll_BFu17ll_Sf");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu17ll_Sf(Test_BFu15ll_BFu17ll_Sf, "BFu15ll_BFu17ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu1c_Sf  {
  __tsu64 v1:15;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu1c_Sf) C1{ FL:15 Fc:1 FC2{}}



static void Test_BFu15ll_BFu1c_Sf()
{
  {
    init_simple_test("BFu15ll_BFu1c_Sf");
    static BFu15ll_BFu1c_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1c_Sf");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu1c_Sf(Test_BFu15ll_BFu1c_Sf, "BFu15ll_BFu1c_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu1i_Sf  {
  __tsu64 v1:15;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu1i_Sf) C1{ FL:15 Fi:1 FC2{}}



static void Test_BFu15ll_BFu1i_Sf()
{
  {
    init_simple_test("BFu15ll_BFu1i_Sf");
    static BFu15ll_BFu1i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1i_Sf");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu1i_Sf(Test_BFu15ll_BFu1i_Sf, "BFu15ll_BFu1i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu1ll_Sf  {
  __tsu64 v1:15;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu1ll_Sf) C1{ FL:15 FL:1 FC2{}}



static void Test_BFu15ll_BFu1ll_Sf()
{
  {
    init_simple_test("BFu15ll_BFu1ll_Sf");
    static BFu15ll_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1ll_Sf");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu1ll_Sf(Test_BFu15ll_BFu1ll_Sf, "BFu15ll_BFu1ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu1s_Sf  {
  __tsu64 v1:15;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu1s_Sf) C1{ FL:15 Fs:1 FC2{}}



static void Test_BFu15ll_BFu1s_Sf()
{
  {
    init_simple_test("BFu15ll_BFu1s_Sf");
    static BFu15ll_BFu1s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu1s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu1s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15ll_BFu1s_Sf");
    check_field_offset(lv, v3, 2, "BFu15ll_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu1s_Sf(Test_BFu15ll_BFu1s_Sf, "BFu15ll_BFu1s_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu31i_Sf  {
  __tsu64 v1:15;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu31i_Sf) C1{ FL:15 Fi:31 FC2{}}



static void Test_BFu15ll_BFu31i_Sf()
{
  {
    init_simple_test("BFu15ll_BFu31i_Sf");
    static BFu15ll_BFu31i_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu31i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu31i_Sf(Test_BFu15ll_BFu31i_Sf, "BFu15ll_BFu31i_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu31ll_Sf  {
  __tsu64 v1:15;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu31ll_Sf) C1{ FL:15 FL:31 FC2{}}



static void Test_BFu15ll_BFu31ll_Sf()
{
  {
    init_simple_test("BFu15ll_BFu31ll_Sf");
    static BFu15ll_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15ll_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu31ll_Sf(Test_BFu15ll_BFu31ll_Sf, "BFu15ll_BFu31ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu32i_Sf  {
  __tsu64 v1:15;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu32i_Sf) C1{ FL:15 Fi:32 FC2{}}



static void Test_BFu15ll_BFu32i_Sf()
{
  {
    init_simple_test("BFu15ll_BFu32i_Sf");
    static BFu15ll_BFu32i_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_BFu32i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu15ll_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu32i_Sf(Test_BFu15ll_BFu32i_Sf, "BFu15ll_BFu32i_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu32ll_Sf  {
  __tsu64 v1:15;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu32ll_Sf) C1{ FL:15 FL:32 FC2{}}



static void Test_BFu15ll_BFu32ll_Sf()
{
  {
    init_simple_test("BFu15ll_BFu32ll_Sf");
    static BFu15ll_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15ll_BFu32ll_Sf");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu32ll_Sf(Test_BFu15ll_BFu32ll_Sf, "BFu15ll_BFu32ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu33_Sf  {
  __tsu64 v1:15;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu33_Sf) C1{ FL:15 FL:33 FC2{}}



static void Test_BFu15ll_BFu33_Sf()
{
  {
    init_simple_test("BFu15ll_BFu33_Sf");
    static BFu15ll_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15ll_BFu33_Sf");
    check_field_offset(lv, v3, 6, "BFu15ll_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu33_Sf(Test_BFu15ll_BFu33_Sf, "BFu15ll_BFu33_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu7c_Sf  {
  __tsu64 v1:15;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu7c_Sf) C1{ FL:15 Fc:7 FC2{}}



static void Test_BFu15ll_BFu7c_Sf()
{
  {
    init_simple_test("BFu15ll_BFu7c_Sf");
    static BFu15ll_BFu7c_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu7c_Sf(Test_BFu15ll_BFu7c_Sf, "BFu15ll_BFu7c_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu7i_Sf  {
  __tsu64 v1:15;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu7i_Sf) C1{ FL:15 Fi:7 FC2{}}



static void Test_BFu15ll_BFu7i_Sf()
{
  {
    init_simple_test("BFu15ll_BFu7i_Sf");
    static BFu15ll_BFu7i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu7i_Sf(Test_BFu15ll_BFu7i_Sf, "BFu15ll_BFu7i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu7ll_Sf  {
  __tsu64 v1:15;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu7ll_Sf) C1{ FL:15 FL:7 FC2{}}



static void Test_BFu15ll_BFu7ll_Sf()
{
  {
    init_simple_test("BFu15ll_BFu7ll_Sf");
    static BFu15ll_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15ll_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu7ll_Sf(Test_BFu15ll_BFu7ll_Sf, "BFu15ll_BFu7ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu7s_Sf  {
  __tsu64 v1:15;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu7s_Sf) C1{ FL:15 Fs:7 FC2{}}



static void Test_BFu15ll_BFu7s_Sf()
{
  {
    init_simple_test("BFu15ll_BFu7s_Sf");
    static BFu15ll_BFu7s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu7s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15ll_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu7s_Sf(Test_BFu15ll_BFu7s_Sf, "BFu15ll_BFu7s_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu8c_Sf  {
  __tsu64 v1:15;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu8c_Sf) C1{ FL:15 Fc:8 FC2{}}



static void Test_BFu15ll_BFu8c_Sf()
{
  {
    init_simple_test("BFu15ll_BFu8c_Sf");
    static BFu15ll_BFu8c_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8c_Sf");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu8c_Sf(Test_BFu15ll_BFu8c_Sf, "BFu15ll_BFu8c_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu8i_Sf  {
  __tsu64 v1:15;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu8i_Sf) C1{ FL:15 Fi:8 FC2{}}



static void Test_BFu15ll_BFu8i_Sf()
{
  {
    init_simple_test("BFu15ll_BFu8i_Sf");
    static BFu15ll_BFu8i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8i_Sf");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu8i_Sf(Test_BFu15ll_BFu8i_Sf, "BFu15ll_BFu8i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu8ll_Sf  {
  __tsu64 v1:15;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu8ll_Sf) C1{ FL:15 FL:8 FC2{}}



static void Test_BFu15ll_BFu8ll_Sf()
{
  {
    init_simple_test("BFu15ll_BFu8ll_Sf");
    static BFu15ll_BFu8ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15ll_BFu8ll_Sf");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu8ll_Sf(Test_BFu15ll_BFu8ll_Sf, "BFu15ll_BFu8ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu8s_Sf  {
  __tsu64 v1:15;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu8s_Sf) C1{ FL:15 Fs:8 FC2{}}



static void Test_BFu15ll_BFu8s_Sf()
{
  {
    init_simple_test("BFu15ll_BFu8s_Sf");
    static BFu15ll_BFu8s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu8s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15ll_BFu8s_Sf");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu8s_Sf(Test_BFu15ll_BFu8s_Sf, "BFu15ll_BFu8s_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu9i_Sf  {
  __tsu64 v1:15;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu9i_Sf) C1{ FL:15 Fi:9 FC2{}}



static void Test_BFu15ll_BFu9i_Sf()
{
  {
    init_simple_test("BFu15ll_BFu9i_Sf");
    static BFu15ll_BFu9i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu9i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu9i_Sf");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu9i_Sf(Test_BFu15ll_BFu9i_Sf, "BFu15ll_BFu9i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu9ll_Sf  {
  __tsu64 v1:15;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu9ll_Sf) C1{ FL:15 FL:9 FC2{}}



static void Test_BFu15ll_BFu9ll_Sf()
{
  {
    init_simple_test("BFu15ll_BFu9ll_Sf");
    static BFu15ll_BFu9ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15ll_BFu9ll_Sf");
    check_field_offset(lv, v3, 3, "BFu15ll_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu9ll_Sf(Test_BFu15ll_BFu9ll_Sf, "BFu15ll_BFu9ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_BFu9s_Sf  {
  __tsu64 v1:15;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 BFu15ll_BFu9s_Sf) C1{ FL:15 Fs:9 FC2{}}



static void Test_BFu15ll_BFu9s_Sf()
{
  {
    init_simple_test("BFu15ll_BFu9s_Sf");
    static BFu15ll_BFu9s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_BFu9s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15ll_BFu9s_Sf");
    check_field_offset(lv, v3, 4, "BFu15ll_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_BFu9s_Sf(Test_BFu15ll_BFu9s_Sf, "BFu15ll_BFu9s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_C_Sf  {
  __tsu64 v1:15;
  char v2;
  ::empty v3;
};
//SIG(1 BFu15ll_C_Sf) C1{ FL:15 Fc FC2{}}



static void Test_BFu15ll_C_Sf()
{
  {
    init_simple_test("BFu15ll_C_Sf");
    static BFu15ll_C_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_C_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_C_Sf");
    check_field_offset(lv, v2, 2, "BFu15ll_C_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_C_Sf(Test_BFu15ll_C_Sf, "BFu15ll_C_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_D_Sf  {
  __tsu64 v1:15;
  double v2;
  ::empty v3;
};
//SIG(1 BFu15ll_D_Sf) C1{ FL:15 FL FC2{}}



static void Test_BFu15ll_D_Sf()
{
  {
    init_simple_test("BFu15ll_D_Sf");
    static BFu15ll_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu15ll_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_D_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu15ll_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_D_Sf(Test_BFu15ll_D_Sf, "BFu15ll_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_F_Sf  {
  __tsu64 v1:15;
  float v2;
  ::empty v3;
};
//SIG(1 BFu15ll_F_Sf) C1{ FL:15 Fi FC2{}}



static void Test_BFu15ll_F_Sf()
{
  {
    init_simple_test("BFu15ll_F_Sf");
    static BFu15ll_F_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_F_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_F_Sf");
    check_field_offset(lv, v2, 4, "BFu15ll_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu15ll_F_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_F_Sf(Test_BFu15ll_F_Sf, "BFu15ll_F_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_I_Sf  {
  __tsu64 v1:15;
  int v2;
  ::empty v3;
};
//SIG(1 BFu15ll_I_Sf) C1{ FL:15 Fi FC2{}}



static void Test_BFu15ll_I_Sf()
{
  {
    init_simple_test("BFu15ll_I_Sf");
    static BFu15ll_I_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_I_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_I_Sf");
    check_field_offset(lv, v2, 4, "BFu15ll_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu15ll_I_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_I_Sf(Test_BFu15ll_I_Sf, "BFu15ll_I_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Ip_Sf  {
  __tsu64 v1:15;
  int *v2;
  ::empty v3;
};
//SIG(1 BFu15ll_Ip_Sf) C1{ FL:15 Fp FC2{}}



static void Test_BFu15ll_Ip_Sf()
{
  {
    init_simple_test("BFu15ll_Ip_Sf");
    static BFu15ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu15ll_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ip_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu15ll_Ip_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Ip_Sf(Test_BFu15ll_Ip_Sf, "BFu15ll_Ip_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_L_Sf  {
  __tsu64 v1:15;
  __tsi64 v2;
  ::empty v3;
};
//SIG(1 BFu15ll_L_Sf) C1{ FL:15 FL FC2{}}



static void Test_BFu15ll_L_Sf()
{
  {
    init_simple_test("BFu15ll_L_Sf");
    static BFu15ll_L_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu15ll_L_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_L_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_L_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu15ll_L_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_L_Sf(Test_BFu15ll_L_Sf, "BFu15ll_L_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_S_Sf  {
  __tsu64 v1:15;
  short v2;
  ::empty v3;
};
//SIG(1 BFu15ll_S_Sf) C1{ FL:15 Fs FC2{}}



static void Test_BFu15ll_S_Sf()
{
  {
    init_simple_test("BFu15ll_S_Sf");
    static BFu15ll_S_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_S_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_S_Sf");
    check_field_offset(lv, v2, 2, "BFu15ll_S_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu15ll_S_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_S_Sf(Test_BFu15ll_S_Sf, "BFu15ll_S_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf  {
  __tsu64 v1:15;
  ::empty v2;
};
//SIG(1 BFu15ll_Sf) C1{ FL:15 FC2{}}



static void Test_BFu15ll_Sf()
{
  {
    init_simple_test("BFu15ll_Sf");
    static BFu15ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf.v2");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf(Test_BFu15ll_Sf, "BFu15ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu15i  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned int v3:15;
};
//SIG(1 BFu15ll_Sf_BFu15i) C1{ FL:15 FC2{} Fi:15}



static void Test_BFu15ll_Sf_BFu15i()
{
  {
    init_simple_test("BFu15ll_Sf_BFu15i");
    static BFu15ll_Sf_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_Sf_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu15i(Test_BFu15ll_Sf_BFu15i, "BFu15ll_Sf_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu15ll  {
  __tsu64 v1:15;
  ::empty v2;
  __tsu64 v3:15;
};
//SIG(1 BFu15ll_Sf_BFu15ll) C1{ FL:15 FC2{} FL:15}



static void Test_BFu15ll_Sf_BFu15ll()
{
  {
    init_simple_test("BFu15ll_Sf_BFu15ll");
    static BFu15ll_Sf_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15ll_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu15ll(Test_BFu15ll_Sf_BFu15ll, "BFu15ll_Sf_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu15s  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned short v3:15;
};
//SIG(1 BFu15ll_Sf_BFu15s) C1{ FL:15 FC2{} Fs:15}



static void Test_BFu15ll_Sf_BFu15s()
{
  {
    init_simple_test("BFu15ll_Sf_BFu15s");
    static BFu15ll_Sf_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15ll_Sf_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu15s(Test_BFu15ll_Sf_BFu15s, "BFu15ll_Sf_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu16i  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned int v3:16;
};
//SIG(1 BFu15ll_Sf_BFu16i) C1{ FL:15 FC2{} Fi:16}



static void Test_BFu15ll_Sf_BFu16i()
{
  {
    init_simple_test("BFu15ll_Sf_BFu16i");
    static BFu15ll_Sf_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_Sf_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_Sf_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu16i(Test_BFu15ll_Sf_BFu16i, "BFu15ll_Sf_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu16ll  {
  __tsu64 v1:15;
  ::empty v2;
  __tsu64 v3:16;
};
//SIG(1 BFu15ll_Sf_BFu16ll) C1{ FL:15 FC2{} FL:16}



static void Test_BFu15ll_Sf_BFu16ll()
{
  {
    init_simple_test("BFu15ll_Sf_BFu16ll");
    static BFu15ll_Sf_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15ll_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15ll_Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu16ll(Test_BFu15ll_Sf_BFu16ll, "BFu15ll_Sf_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu16s  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned short v3:16;
};
//SIG(1 BFu15ll_Sf_BFu16s) C1{ FL:15 FC2{} Fs:16}



static void Test_BFu15ll_Sf_BFu16s()
{
  {
    init_simple_test("BFu15ll_Sf_BFu16s");
    static BFu15ll_Sf_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15ll_Sf_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15ll_Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu16s(Test_BFu15ll_Sf_BFu16s, "BFu15ll_Sf_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu17i  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned int v3:17;
};
//SIG(1 BFu15ll_Sf_BFu17i) C1{ FL:15 FC2{} Fi:17}



static void Test_BFu15ll_Sf_BFu17i()
{
  {
    init_simple_test("BFu15ll_Sf_BFu17i");
    static BFu15ll_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15ll_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15ll_Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu17i(Test_BFu15ll_Sf_BFu17i, "BFu15ll_Sf_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu17ll  {
  __tsu64 v1:15;
  ::empty v2;
  __tsu64 v3:17;
};
//SIG(1 BFu15ll_Sf_BFu17ll) C1{ FL:15 FC2{} FL:17}



static void Test_BFu15ll_Sf_BFu17ll()
{
  {
    init_simple_test("BFu15ll_Sf_BFu17ll");
    static BFu15ll_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15ll_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15ll_Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu17ll(Test_BFu15ll_Sf_BFu17ll, "BFu15ll_Sf_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu1c  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned char v3:1;
};
//SIG(1 BFu15ll_Sf_BFu1c) C1{ FL:15 FC2{} Fc:1}



static void Test_BFu15ll_Sf_BFu1c()
{
  {
    init_simple_test("BFu15ll_Sf_BFu1c");
    static BFu15ll_Sf_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu1c(Test_BFu15ll_Sf_BFu1c, "BFu15ll_Sf_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu1i  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned int v3:1;
};
//SIG(1 BFu15ll_Sf_BFu1i) C1{ FL:15 FC2{} Fi:1}



static void Test_BFu15ll_Sf_BFu1i()
{
  {
    init_simple_test("BFu15ll_Sf_BFu1i");
    static BFu15ll_Sf_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu1i(Test_BFu15ll_Sf_BFu1i, "BFu15ll_Sf_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu1ll  {
  __tsu64 v1:15;
  ::empty v2;
  __tsu64 v3:1;
};
//SIG(1 BFu15ll_Sf_BFu1ll) C1{ FL:15 FC2{} FL:1}



static void Test_BFu15ll_Sf_BFu1ll()
{
  {
    init_simple_test("BFu15ll_Sf_BFu1ll");
    static BFu15ll_Sf_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu1ll(Test_BFu15ll_Sf_BFu1ll, "BFu15ll_Sf_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu1s  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned short v3:1;
};
//SIG(1 BFu15ll_Sf_BFu1s) C1{ FL:15 FC2{} Fs:1}



static void Test_BFu15ll_Sf_BFu1s()
{
  {
    init_simple_test("BFu15ll_Sf_BFu1s");
    static BFu15ll_Sf_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15ll_Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu1s(Test_BFu15ll_Sf_BFu1s, "BFu15ll_Sf_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu31i  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned int v3:31;
};
//SIG(1 BFu15ll_Sf_BFu31i) C1{ FL:15 FC2{} Fi:31}



static void Test_BFu15ll_Sf_BFu31i()
{
  {
    init_simple_test("BFu15ll_Sf_BFu31i");
    static BFu15ll_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15ll_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15ll_Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu31i(Test_BFu15ll_Sf_BFu31i, "BFu15ll_Sf_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu31ll  {
  __tsu64 v1:15;
  ::empty v2;
  __tsu64 v3:31;
};
//SIG(1 BFu15ll_Sf_BFu31ll) C1{ FL:15 FC2{} FL:31}



static void Test_BFu15ll_Sf_BFu31ll()
{
  {
    init_simple_test("BFu15ll_Sf_BFu31ll");
    static BFu15ll_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15ll_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15ll_Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu31ll(Test_BFu15ll_Sf_BFu31ll, "BFu15ll_Sf_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu32i  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned int v3:32;
};
//SIG(1 BFu15ll_Sf_BFu32i) C1{ FL:15 FC2{} Fi:32}



static void Test_BFu15ll_Sf_BFu32i()
{
  {
    init_simple_test("BFu15ll_Sf_BFu32i");
    static BFu15ll_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15ll_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15ll_Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu32i(Test_BFu15ll_Sf_BFu32i, "BFu15ll_Sf_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu32ll  {
  __tsu64 v1:15;
  ::empty v2;
  __tsu64 v3:32;
};
//SIG(1 BFu15ll_Sf_BFu32ll) C1{ FL:15 FC2{} FL:32}



static void Test_BFu15ll_Sf_BFu32ll()
{
  {
    init_simple_test("BFu15ll_Sf_BFu32ll");
    static BFu15ll_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15ll_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15ll_Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu32ll(Test_BFu15ll_Sf_BFu32ll, "BFu15ll_Sf_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu33  {
  __tsu64 v1:15;
  ::empty v2;
  __tsu64 v3:33;
};
//SIG(1 BFu15ll_Sf_BFu33) C1{ FL:15 FC2{} FL:33}



static void Test_BFu15ll_Sf_BFu33()
{
  {
    init_simple_test("BFu15ll_Sf_BFu33");
    static BFu15ll_Sf_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu33");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu15ll_Sf_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu15ll_Sf_BFu33");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu33(Test_BFu15ll_Sf_BFu33, "BFu15ll_Sf_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu7c  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned char v3:7;
};
//SIG(1 BFu15ll_Sf_BFu7c) C1{ FL:15 FC2{} Fc:7}



static void Test_BFu15ll_Sf_BFu7c()
{
  {
    init_simple_test("BFu15ll_Sf_BFu7c");
    static BFu15ll_Sf_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_Sf_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu7c(Test_BFu15ll_Sf_BFu7c, "BFu15ll_Sf_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu7i  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned int v3:7;
};
//SIG(1 BFu15ll_Sf_BFu7i) C1{ FL:15 FC2{} Fi:7}



static void Test_BFu15ll_Sf_BFu7i()
{
  {
    init_simple_test("BFu15ll_Sf_BFu7i");
    static BFu15ll_Sf_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_Sf_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_Sf_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu7i(Test_BFu15ll_Sf_BFu7i, "BFu15ll_Sf_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu7ll  {
  __tsu64 v1:15;
  ::empty v2;
  __tsu64 v3:7;
};
//SIG(1 BFu15ll_Sf_BFu7ll) C1{ FL:15 FC2{} FL:7}



static void Test_BFu15ll_Sf_BFu7ll()
{
  {
    init_simple_test("BFu15ll_Sf_BFu7ll");
    static BFu15ll_Sf_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_Sf_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu7ll(Test_BFu15ll_Sf_BFu7ll, "BFu15ll_Sf_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu7s  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned short v3:7;
};
//SIG(1 BFu15ll_Sf_BFu7s) C1{ FL:15 FC2{} Fs:7}



static void Test_BFu15ll_Sf_BFu7s()
{
  {
    init_simple_test("BFu15ll_Sf_BFu7s");
    static BFu15ll_Sf_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15ll_Sf_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15ll_Sf_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu7s(Test_BFu15ll_Sf_BFu7s, "BFu15ll_Sf_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu8c  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned char v3:8;
};
//SIG(1 BFu15ll_Sf_BFu8c) C1{ FL:15 FC2{} Fc:8}



static void Test_BFu15ll_Sf_BFu8c()
{
  {
    init_simple_test("BFu15ll_Sf_BFu8c");
    static BFu15ll_Sf_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_Sf_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_Sf_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu8c(Test_BFu15ll_Sf_BFu8c, "BFu15ll_Sf_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu8i  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned int v3:8;
};
//SIG(1 BFu15ll_Sf_BFu8i) C1{ FL:15 FC2{} Fi:8}



static void Test_BFu15ll_Sf_BFu8i()
{
  {
    init_simple_test("BFu15ll_Sf_BFu8i");
    static BFu15ll_Sf_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_Sf_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_Sf_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu8i(Test_BFu15ll_Sf_BFu8i, "BFu15ll_Sf_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu8ll  {
  __tsu64 v1:15;
  ::empty v2;
  __tsu64 v3:8;
};
//SIG(1 BFu15ll_Sf_BFu8ll) C1{ FL:15 FC2{} FL:8}



static void Test_BFu15ll_Sf_BFu8ll()
{
  {
    init_simple_test("BFu15ll_Sf_BFu8ll");
    static BFu15ll_Sf_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_Sf_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu8ll(Test_BFu15ll_Sf_BFu8ll, "BFu15ll_Sf_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu8s  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned short v3:8;
};
//SIG(1 BFu15ll_Sf_BFu8s) C1{ FL:15 FC2{} Fs:8}



static void Test_BFu15ll_Sf_BFu8s()
{
  {
    init_simple_test("BFu15ll_Sf_BFu8s");
    static BFu15ll_Sf_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15ll_Sf_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15ll_Sf_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu8s(Test_BFu15ll_Sf_BFu8s, "BFu15ll_Sf_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu9i  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned int v3:9;
};
//SIG(1 BFu15ll_Sf_BFu9i) C1{ FL:15 FC2{} Fi:9}



static void Test_BFu15ll_Sf_BFu9i()
{
  {
    init_simple_test("BFu15ll_Sf_BFu9i");
    static BFu15ll_Sf_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_Sf_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_Sf_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu9i(Test_BFu15ll_Sf_BFu9i, "BFu15ll_Sf_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu9ll  {
  __tsu64 v1:15;
  ::empty v2;
  __tsu64 v3:9;
};
//SIG(1 BFu15ll_Sf_BFu9ll) C1{ FL:15 FC2{} FL:9}



static void Test_BFu15ll_Sf_BFu9ll()
{
  {
    init_simple_test("BFu15ll_Sf_BFu9ll");
    static BFu15ll_Sf_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15ll_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15ll_Sf_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu9ll(Test_BFu15ll_Sf_BFu9ll, "BFu15ll_Sf_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_BFu9s  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned short v3:9;
};
//SIG(1 BFu15ll_Sf_BFu9s) C1{ FL:15 FC2{} Fs:9}



static void Test_BFu15ll_Sf_BFu9s()
{
  {
    init_simple_test("BFu15ll_Sf_BFu9s");
    static BFu15ll_Sf_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15ll_Sf_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15ll_Sf_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_BFu9s(Test_BFu15ll_Sf_BFu9s, "BFu15ll_Sf_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_C  {
  __tsu64 v1:15;
  ::empty v2;
  char v3;
};
//SIG(1 BFu15ll_Sf_C) C1{ FL:15 FC2{} Fc}



static void Test_BFu15ll_Sf_C()
{
  {
    init_simple_test("BFu15ll_Sf_C");
    static BFu15ll_Sf_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_C");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_C.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_Sf_C.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_C(Test_BFu15ll_Sf_C, "BFu15ll_Sf_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_D  {
  __tsu64 v1:15;
  ::empty v2;
  double v3;
};
//SIG(1 BFu15ll_Sf_D) C1{ FL:15 FC2{} FL}



static void Test_BFu15ll_Sf_D()
{
  {
    init_simple_test("BFu15ll_Sf_D");
    static BFu15ll_Sf_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_Sf_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_D");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_Sf_D.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_D(Test_BFu15ll_Sf_D, "BFu15ll_Sf_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_F  {
  __tsu64 v1:15;
  ::empty v2;
  float v3;
};
//SIG(1 BFu15ll_Sf_F) C1{ FL:15 FC2{} Fi}



static void Test_BFu15ll_Sf_F()
{
  {
    init_simple_test("BFu15ll_Sf_F");
    static BFu15ll_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_F");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu15ll_Sf_F.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_F(Test_BFu15ll_Sf_F, "BFu15ll_Sf_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_I  {
  __tsu64 v1:15;
  ::empty v2;
  int v3;
};
//SIG(1 BFu15ll_Sf_I) C1{ FL:15 FC2{} Fi}



static void Test_BFu15ll_Sf_I()
{
  {
    init_simple_test("BFu15ll_Sf_I");
    static BFu15ll_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_I");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu15ll_Sf_I.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_I(Test_BFu15ll_Sf_I, "BFu15ll_Sf_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_Ip  {
  __tsu64 v1:15;
  ::empty v2;
  int *v3;
};
//SIG(1 BFu15ll_Sf_Ip) C1{ FL:15 FC2{} Fp}



static void Test_BFu15ll_Sf_Ip()
{
  {
    init_simple_test("BFu15ll_Sf_Ip");
    static BFu15ll_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_Ip");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_Sf_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_Ip(Test_BFu15ll_Sf_Ip, "BFu15ll_Sf_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_L  {
  __tsu64 v1:15;
  ::empty v2;
  __tsi64 v3;
};
//SIG(1 BFu15ll_Sf_L) C1{ FL:15 FC2{} FL}



static void Test_BFu15ll_Sf_L()
{
  {
    init_simple_test("BFu15ll_Sf_L");
    static BFu15ll_Sf_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_Sf_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_L");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_Sf_L.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_L(Test_BFu15ll_Sf_L, "BFu15ll_Sf_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_S  {
  __tsu64 v1:15;
  ::empty v2;
  short v3;
};
//SIG(1 BFu15ll_Sf_S) C1{ FL:15 FC2{} Fs}



static void Test_BFu15ll_Sf_S()
{
  {
    init_simple_test("BFu15ll_Sf_S");
    static BFu15ll_Sf_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_S");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_S.v2");
    check_field_offset(lv, v3, 4, "BFu15ll_Sf_S.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_S(Test_BFu15ll_Sf_S, "BFu15ll_Sf_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_Sf  {
  __tsu64 v1:15;
  ::empty v2;
  ::empty v3;
};
//SIG(1 BFu15ll_Sf_Sf) C1{ FL:15 FC2{} FC2}



static void Test_BFu15ll_Sf_Sf()
{
  {
    init_simple_test("BFu15ll_Sf_Sf");
    static BFu15ll_Sf_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_Sf");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_Sf_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_Sf(Test_BFu15ll_Sf_Sf, "BFu15ll_Sf_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_Uc  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned char v3;
};
//SIG(1 BFu15ll_Sf_Uc) C1{ FL:15 FC2{} Fc}



static void Test_BFu15ll_Sf_Uc()
{
  {
    init_simple_test("BFu15ll_Sf_Uc");
    static BFu15ll_Sf_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Sf_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_Uc");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_Sf_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_Uc(Test_BFu15ll_Sf_Uc, "BFu15ll_Sf_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_Ui  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned int v3;
};
//SIG(1 BFu15ll_Sf_Ui) C1{ FL:15 FC2{} Fi}



static void Test_BFu15ll_Sf_Ui()
{
  {
    init_simple_test("BFu15ll_Sf_Ui");
    static BFu15ll_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_Ui");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu15ll_Sf_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_Ui(Test_BFu15ll_Sf_Ui, "BFu15ll_Sf_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_Ul  {
  __tsu64 v1:15;
  ::empty v2;
  __tsu64 v3;
};
//SIG(1 BFu15ll_Sf_Ul) C1{ FL:15 FC2{} FL}



static void Test_BFu15ll_Sf_Ul()
{
  {
    init_simple_test("BFu15ll_Sf_Ul");
    static BFu15ll_Sf_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_Ul");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_Sf_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_Ul(Test_BFu15ll_Sf_Ul, "BFu15ll_Sf_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_Us  {
  __tsu64 v1:15;
  ::empty v2;
  unsigned short v3;
};
//SIG(1 BFu15ll_Sf_Us) C1{ FL:15 FC2{} Fs}



static void Test_BFu15ll_Sf_Us()
{
  {
    init_simple_test("BFu15ll_Sf_Us");
    static BFu15ll_Sf_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Sf_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_Us");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_Us.v2");
    check_field_offset(lv, v3, 4, "BFu15ll_Sf_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_Us(Test_BFu15ll_Sf_Us, "BFu15ll_Sf_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Sf_Vp  {
  __tsu64 v1:15;
  ::empty v2;
  void *v3;
};
//SIG(1 BFu15ll_Sf_Vp) C1{ FL:15 FC2{} Fp}



static void Test_BFu15ll_Sf_Vp()
{
  {
    init_simple_test("BFu15ll_Sf_Vp");
    static BFu15ll_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15ll_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Sf_Vp");
    check_field_offset(lv, v2, 2, "BFu15ll_Sf_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15ll_Sf_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Sf_Vp(Test_BFu15ll_Sf_Vp, "BFu15ll_Sf_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Uc_Sf  {
  __tsu64 v1:15;
  unsigned char v2;
  ::empty v3;
};
//SIG(1 BFu15ll_Uc_Sf) C1{ FL:15 Fc FC2{}}



static void Test_BFu15ll_Uc_Sf()
{
  {
    init_simple_test("BFu15ll_Uc_Sf");
    static BFu15ll_Uc_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15ll_Uc_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Uc_Sf");
    check_field_offset(lv, v2, 2, "BFu15ll_Uc_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu15ll_Uc_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Uc_Sf(Test_BFu15ll_Uc_Sf, "BFu15ll_Uc_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Ui_Sf  {
  __tsu64 v1:15;
  unsigned int v2;
  ::empty v3;
};
//SIG(1 BFu15ll_Ui_Sf) C1{ FL:15 Fi FC2{}}



static void Test_BFu15ll_Ui_Sf()
{
  {
    init_simple_test("BFu15ll_Ui_Sf");
    static BFu15ll_Ui_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15ll_Ui_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu15ll_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu15ll_Ui_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Ui_Sf(Test_BFu15ll_Ui_Sf, "BFu15ll_Ui_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Ul_Sf  {
  __tsu64 v1:15;
  __tsu64 v2;
  ::empty v3;
};
//SIG(1 BFu15ll_Ul_Sf) C1{ FL:15 FL FC2{}}



static void Test_BFu15ll_Ul_Sf()
{
  {
    init_simple_test("BFu15ll_Ul_Sf");
    static BFu15ll_Ul_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu15ll_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Ul_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Ul_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu15ll_Ul_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Ul_Sf(Test_BFu15ll_Ul_Sf, "BFu15ll_Ul_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Us_Sf  {
  __tsu64 v1:15;
  unsigned short v2;
  ::empty v3;
};
//SIG(1 BFu15ll_Us_Sf) C1{ FL:15 Fs FC2{}}



static void Test_BFu15ll_Us_Sf()
{
  {
    init_simple_test("BFu15ll_Us_Sf");
    static BFu15ll_Us_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15ll_Us_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Us_Sf");
    check_field_offset(lv, v2, 2, "BFu15ll_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu15ll_Us_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Us_Sf(Test_BFu15ll_Us_Sf, "BFu15ll_Us_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15ll_Vp_Sf  {
  __tsu64 v1:15;
  void *v2;
  ::empty v3;
};
//SIG(1 BFu15ll_Vp_Sf) C1{ FL:15 Fp FC2{}}



static void Test_BFu15ll_Vp_Sf()
{
  {
    init_simple_test("BFu15ll_Vp_Sf");
    static BFu15ll_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu15ll_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15ll_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15ll_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15ll_Vp_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15ll_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu15ll_Vp_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15ll_Vp_Sf(Test_BFu15ll_Vp_Sf, "BFu15ll_Vp_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu15i_Sf  {
  unsigned short v1:15;
  unsigned int v2:15;
  ::empty v3;
};
//SIG(1 BFu15s_BFu15i_Sf) C1{ Fs:15 Fi:15 FC2{}}



static void Test_BFu15s_BFu15i_Sf()
{
  {
    init_simple_test("BFu15s_BFu15i_Sf");
    static BFu15s_BFu15i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu15i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15s_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "BFu15s_BFu15i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu15i_Sf(Test_BFu15s_BFu15i_Sf, "BFu15s_BFu15i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu15ll_Sf  {
  unsigned short v1:15;
  __tsu64 v2:15;
  ::empty v3;
};
//SIG(1 BFu15s_BFu15ll_Sf) C1{ Fs:15 FL:15 FC2{}}



static void Test_BFu15s_BFu15ll_Sf()
{
  {
    init_simple_test("BFu15s_BFu15ll_Sf");
    static BFu15s_BFu15ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, 1, "BFu15s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 15, hide_ull(1LL<<14), "BFu15s_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "BFu15s_BFu15ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu15ll_Sf(Test_BFu15s_BFu15ll_Sf, "BFu15s_BFu15ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu15s_Sf  {
  unsigned short v1:15;
  unsigned short v2:15;
  ::empty v3;
};
//SIG(1 BFu15s_BFu15s_Sf) C1{ Fs:15 Fs:15 FC2{}}



static void Test_BFu15s_BFu15s_Sf()
{
  {
    init_simple_test("BFu15s_BFu15s_Sf");
    static BFu15s_BFu15s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu15s_BFu15s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu15s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "BFu15s_BFu15s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu15s_Sf(Test_BFu15s_BFu15s_Sf, "BFu15s_BFu15s_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu16i_Sf  {
  unsigned short v1:15;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 BFu15s_BFu16i_Sf) C1{ Fs:15 Fi:16 FC2{}}



static void Test_BFu15s_BFu16i_Sf()
{
  {
    init_simple_test("BFu15s_BFu16i_Sf");
    static BFu15s_BFu16i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu16i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15s_BFu16i_Sf");
    check_field_offset(lv, v3, 4, "BFu15s_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu16i_Sf(Test_BFu15s_BFu16i_Sf, "BFu15s_BFu16i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu16ll_Sf  {
  unsigned short v1:15;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 BFu15s_BFu16ll_Sf) C1{ Fs:15 FL:16 FC2{}}



static void Test_BFu15s_BFu16ll_Sf()
{
  {
    init_simple_test("BFu15s_BFu16ll_Sf");
    static BFu15s_BFu16ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, 1, "BFu15s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 16, hide_ull(1LL<<15), "BFu15s_BFu16ll_Sf");
    check_field_offset(lv, v3, 4, "BFu15s_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu16ll_Sf(Test_BFu15s_BFu16ll_Sf, "BFu15s_BFu16ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu16s_Sf  {
  unsigned short v1:15;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 BFu15s_BFu16s_Sf) C1{ Fs:15 Fs:16 FC2{}}



static void Test_BFu15s_BFu16s_Sf()
{
  {
    init_simple_test("BFu15s_BFu16s_Sf");
    static BFu15s_BFu16s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu15s_BFu16s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu15s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu15s_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "BFu15s_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu16s_Sf(Test_BFu15s_BFu16s_Sf, "BFu15s_BFu16s_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu17i_Sf  {
  unsigned short v1:15;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 BFu15s_BFu17i_Sf) C1{ Fs:15 Fi:17 FC2{}}



static void Test_BFu15s_BFu17i_Sf()
{
  {
    init_simple_test("BFu15s_BFu17i_Sf");
    static BFu15s_BFu17i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu17i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15s_BFu17i_Sf");
    check_field_offset(lv, v3, 4, "BFu15s_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu17i_Sf(Test_BFu15s_BFu17i_Sf, "BFu15s_BFu17i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu17ll_Sf  {
  unsigned short v1:15;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 BFu15s_BFu17ll_Sf) C1{ Fs:15 FL:17 FC2{}}



static void Test_BFu15s_BFu17ll_Sf()
{
  {
    init_simple_test("BFu15s_BFu17ll_Sf");
    static BFu15s_BFu17ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, 1, "BFu15s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 17, hide_ull(1LL<<16), "BFu15s_BFu17ll_Sf");
    check_field_offset(lv, v3, 4, "BFu15s_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu17ll_Sf(Test_BFu15s_BFu17ll_Sf, "BFu15s_BFu17ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu1c_Sf  {
  unsigned short v1:15;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 BFu15s_BFu1c_Sf) C1{ Fs:15 Fc:1 FC2{}}



static void Test_BFu15s_BFu1c_Sf()
{
  {
    init_simple_test("BFu15s_BFu1c_Sf");
    static BFu15s_BFu1c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu1c_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu1c_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15s_BFu1c_Sf");
    check_field_offset(lv, v3, 2, "BFu15s_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu1c_Sf(Test_BFu15s_BFu1c_Sf, "BFu15s_BFu1c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu1i_Sf  {
  unsigned short v1:15;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 BFu15s_BFu1i_Sf) C1{ Fs:15 Fi:1 FC2{}}



static void Test_BFu15s_BFu1i_Sf()
{
  {
    init_simple_test("BFu15s_BFu1i_Sf");
    static BFu15s_BFu1i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu1i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu1i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15s_BFu1i_Sf");
    check_field_offset(lv, v3, 2, "BFu15s_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu1i_Sf(Test_BFu15s_BFu1i_Sf, "BFu15s_BFu1i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu1ll_Sf  {
  unsigned short v1:15;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 BFu15s_BFu1ll_Sf) C1{ Fs:15 FL:1 FC2{}}



static void Test_BFu15s_BFu1ll_Sf()
{
  {
    init_simple_test("BFu15s_BFu1ll_Sf");
    static BFu15s_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15s_BFu1ll_Sf");
    check_field_offset(lv, v3, 2, "BFu15s_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu1ll_Sf(Test_BFu15s_BFu1ll_Sf, "BFu15s_BFu1ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu1s_Sf  {
  unsigned short v1:15;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 BFu15s_BFu1s_Sf) C1{ Fs:15 Fs:1 FC2{}}



static void Test_BFu15s_BFu1s_Sf()
{
  {
    init_simple_test("BFu15s_BFu1s_Sf");
    static BFu15s_BFu1s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu1s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu1s_Sf");
    set_bf_and_test(lv, v2, 1, 7, 1, 1, "BFu15s_BFu1s_Sf");
    check_field_offset(lv, v3, 2, "BFu15s_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu1s_Sf(Test_BFu15s_BFu1s_Sf, "BFu15s_BFu1s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu31i_Sf  {
  unsigned short v1:15;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 BFu15s_BFu31i_Sf) C1{ Fs:15 Fi:31 FC2{}}



static void Test_BFu15s_BFu31i_Sf()
{
  {
    init_simple_test("BFu15s_BFu31i_Sf");
    static BFu15s_BFu31i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu15s_BFu31i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu15s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu15s_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "BFu15s_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu31i_Sf(Test_BFu15s_BFu31i_Sf, "BFu15s_BFu31i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu31ll_Sf  {
  unsigned short v1:15;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 BFu15s_BFu31ll_Sf) C1{ Fs:15 FL:31 FC2{}}



static void Test_BFu15s_BFu31ll_Sf()
{
  {
    init_simple_test("BFu15s_BFu31ll_Sf");
    static BFu15s_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, 1, "BFu15s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 31, hide_ull(1LL<<30), "BFu15s_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "BFu15s_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu31ll_Sf(Test_BFu15s_BFu31ll_Sf, "BFu15s_BFu31ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu32i_Sf  {
  unsigned short v1:15;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 BFu15s_BFu32i_Sf) C1{ Fs:15 Fi:32 FC2{}}



static void Test_BFu15s_BFu32i_Sf()
{
  {
    init_simple_test("BFu15s_BFu32i_Sf");
    static BFu15s_BFu32i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu15s_BFu32i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu15s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu15s_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu15s_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu32i_Sf(Test_BFu15s_BFu32i_Sf, "BFu15s_BFu32i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu32ll_Sf  {
  unsigned short v1:15;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 BFu15s_BFu32ll_Sf) C1{ Fs:15 FL:32 FC2{}}



static void Test_BFu15s_BFu32ll_Sf()
{
  {
    init_simple_test("BFu15s_BFu32ll_Sf");
    static BFu15s_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, 1, "BFu15s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 32, hide_ull(1LL<<31), "BFu15s_BFu32ll_Sf");
    check_field_offset(lv, v3, 6, "BFu15s_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu32ll_Sf(Test_BFu15s_BFu32ll_Sf, "BFu15s_BFu32ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu33_Sf  {
  unsigned short v1:15;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 BFu15s_BFu33_Sf) C1{ Fs:15 FL:33 FC2{}}



static void Test_BFu15s_BFu33_Sf()
{
  {
    init_simple_test("BFu15s_BFu33_Sf");
    static BFu15s_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 7, 33, 1, "BFu15s_BFu33_Sf");
    set_bf_and_test(lv, v2, 1, 7, 33, hide_ull(1LL<<32), "BFu15s_BFu33_Sf");
    check_field_offset(lv, v3, 6, "BFu15s_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu33_Sf(Test_BFu15s_BFu33_Sf, "BFu15s_BFu33_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu7c_Sf  {
  unsigned short v1:15;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 BFu15s_BFu7c_Sf) C1{ Fs:15 Fc:7 FC2{}}



static void Test_BFu15s_BFu7c_Sf()
{
  {
    init_simple_test("BFu15s_BFu7c_Sf");
    static BFu15s_BFu7c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu7c_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15s_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "BFu15s_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu7c_Sf(Test_BFu15s_BFu7c_Sf, "BFu15s_BFu7c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu7i_Sf  {
  unsigned short v1:15;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 BFu15s_BFu7i_Sf) C1{ Fs:15 Fi:7 FC2{}}



static void Test_BFu15s_BFu7i_Sf()
{
  {
    init_simple_test("BFu15s_BFu7i_Sf");
    static BFu15s_BFu7i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu7i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15s_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "BFu15s_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu7i_Sf(Test_BFu15s_BFu7i_Sf, "BFu15s_BFu7i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu7ll_Sf  {
  unsigned short v1:15;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 BFu15s_BFu7ll_Sf) C1{ Fs:15 FL:7 FC2{}}



static void Test_BFu15s_BFu7ll_Sf()
{
  {
    init_simple_test("BFu15s_BFu7ll_Sf");
    static BFu15s_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, 1, "BFu15s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 7, hide_ull(1LL<<6), "BFu15s_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "BFu15s_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu7ll_Sf(Test_BFu15s_BFu7ll_Sf, "BFu15s_BFu7ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu7s_Sf  {
  unsigned short v1:15;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 BFu15s_BFu7s_Sf) C1{ Fs:15 Fs:7 FC2{}}



static void Test_BFu15s_BFu7s_Sf()
{
  {
    init_simple_test("BFu15s_BFu7s_Sf");
    static BFu15s_BFu7s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu7s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu15s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu15s_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "BFu15s_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu7s_Sf(Test_BFu15s_BFu7s_Sf, "BFu15s_BFu7s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu8c_Sf  {
  unsigned short v1:15;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 BFu15s_BFu8c_Sf) C1{ Fs:15 Fc:8 FC2{}}



static void Test_BFu15s_BFu8c_Sf()
{
  {
    init_simple_test("BFu15s_BFu8c_Sf");
    static BFu15s_BFu8c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu8c_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15s_BFu8c_Sf");
    check_field_offset(lv, v3, 3, "BFu15s_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu8c_Sf(Test_BFu15s_BFu8c_Sf, "BFu15s_BFu8c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu8i_Sf  {
  unsigned short v1:15;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 BFu15s_BFu8i_Sf) C1{ Fs:15 Fi:8 FC2{}}



static void Test_BFu15s_BFu8i_Sf()
{
  {
    init_simple_test("BFu15s_BFu8i_Sf");
    static BFu15s_BFu8i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu8i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15s_BFu8i_Sf");
    check_field_offset(lv, v3, 3, "BFu15s_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu8i_Sf(Test_BFu15s_BFu8i_Sf, "BFu15s_BFu8i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu8ll_Sf  {
  unsigned short v1:15;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 BFu15s_BFu8ll_Sf) C1{ Fs:15 FL:8 FC2{}}



static void Test_BFu15s_BFu8ll_Sf()
{
  {
    init_simple_test("BFu15s_BFu8ll_Sf");
    static BFu15s_BFu8ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, 1, "BFu15s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 8, hide_ull(1LL<<7), "BFu15s_BFu8ll_Sf");
    check_field_offset(lv, v3, 3, "BFu15s_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu8ll_Sf(Test_BFu15s_BFu8ll_Sf, "BFu15s_BFu8ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu8s_Sf  {
  unsigned short v1:15;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 BFu15s_BFu8s_Sf) C1{ Fs:15 Fs:8 FC2{}}



static void Test_BFu15s_BFu8s_Sf()
{
  {
    init_simple_test("BFu15s_BFu8s_Sf");
    static BFu15s_BFu8s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu8s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu15s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu15s_BFu8s_Sf");
    check_field_offset(lv, v3, 3, "BFu15s_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu8s_Sf(Test_BFu15s_BFu8s_Sf, "BFu15s_BFu8s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu9i_Sf  {
  unsigned short v1:15;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 BFu15s_BFu9i_Sf) C1{ Fs:15 Fi:9 FC2{}}



static void Test_BFu15s_BFu9i_Sf()
{
  {
    init_simple_test("BFu15s_BFu9i_Sf");
    static BFu15s_BFu9i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_BFu9i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15s_BFu9i_Sf");
    check_field_offset(lv, v3, 3, "BFu15s_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu9i_Sf(Test_BFu15s_BFu9i_Sf, "BFu15s_BFu9i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu9ll_Sf  {
  unsigned short v1:15;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 BFu15s_BFu9ll_Sf) C1{ Fs:15 FL:9 FC2{}}



static void Test_BFu15s_BFu9ll_Sf()
{
  {
    init_simple_test("BFu15s_BFu9ll_Sf");
    static BFu15s_BFu9ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, 1, "BFu15s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 1, 7, 9, hide_ull(1LL<<8), "BFu15s_BFu9ll_Sf");
    check_field_offset(lv, v3, 3, "BFu15s_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu9ll_Sf(Test_BFu15s_BFu9ll_Sf, "BFu15s_BFu9ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_BFu9s_Sf  {
  unsigned short v1:15;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 BFu15s_BFu9s_Sf) C1{ Fs:15 Fs:9 FC2{}}



static void Test_BFu15s_BFu9s_Sf()
{
  {
    init_simple_test("BFu15s_BFu9s_Sf");
    static BFu15s_BFu9s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu15s_BFu9s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu15s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu15s_BFu9s_Sf");
    check_field_offset(lv, v3, 4, "BFu15s_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_BFu9s_Sf(Test_BFu15s_BFu9s_Sf, "BFu15s_BFu9s_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_C_Sf  {
  unsigned short v1:15;
  char v2;
  ::empty v3;
};
//SIG(1 BFu15s_C_Sf) C1{ Fs:15 Fc FC2{}}



static void Test_BFu15s_C_Sf()
{
  {
    init_simple_test("BFu15s_C_Sf");
    static BFu15s_C_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_C_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_C_Sf");
    check_field_offset(lv, v2, 2, "BFu15s_C_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu15s_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_C_Sf(Test_BFu15s_C_Sf, "BFu15s_C_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_D_Sf  {
  unsigned short v1:15;
  double v2;
  ::empty v3;
};
//SIG(1 BFu15s_D_Sf) C1{ Fs:15 FL FC2{}}



static void Test_BFu15s_D_Sf()
{
  {
    init_simple_test("BFu15s_D_Sf");
    static BFu15s_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu15s_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_D_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu15s_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_D_Sf(Test_BFu15s_D_Sf, "BFu15s_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_F_Sf  {
  unsigned short v1:15;
  float v2;
  ::empty v3;
};
//SIG(1 BFu15s_F_Sf) C1{ Fs:15 Fi FC2{}}



static void Test_BFu15s_F_Sf()
{
  {
    init_simple_test("BFu15s_F_Sf");
    static BFu15s_F_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu15s_F_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_F_Sf");
    check_field_offset(lv, v2, 4, "BFu15s_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu15s_F_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_F_Sf(Test_BFu15s_F_Sf, "BFu15s_F_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_I_Sf  {
  unsigned short v1:15;
  int v2;
  ::empty v3;
};
//SIG(1 BFu15s_I_Sf) C1{ Fs:15 Fi FC2{}}



static void Test_BFu15s_I_Sf()
{
  {
    init_simple_test("BFu15s_I_Sf");
    static BFu15s_I_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu15s_I_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_I_Sf");
    check_field_offset(lv, v2, 4, "BFu15s_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu15s_I_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_I_Sf(Test_BFu15s_I_Sf, "BFu15s_I_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Ip_Sf  {
  unsigned short v1:15;
  int *v2;
  ::empty v3;
};
//SIG(1 BFu15s_Ip_Sf) C1{ Fs:15 Fp FC2{}}



static void Test_BFu15s_Ip_Sf()
{
  {
    init_simple_test("BFu15s_Ip_Sf");
    static BFu15s_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu15s_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Ip_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu15s_Ip_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Ip_Sf(Test_BFu15s_Ip_Sf, "BFu15s_Ip_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_L_Sf  {
  unsigned short v1:15;
  __tsi64 v2;
  ::empty v3;
};
//SIG(1 BFu15s_L_Sf) C1{ Fs:15 FL FC2{}}



static void Test_BFu15s_L_Sf()
{
  {
    init_simple_test("BFu15s_L_Sf");
    static BFu15s_L_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu15s_L_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_L_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_L_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu15s_L_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_L_Sf(Test_BFu15s_L_Sf, "BFu15s_L_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_S_Sf  {
  unsigned short v1:15;
  short v2;
  ::empty v3;
};
//SIG(1 BFu15s_S_Sf) C1{ Fs:15 Fs FC2{}}



static void Test_BFu15s_S_Sf()
{
  {
    init_simple_test("BFu15s_S_Sf");
    static BFu15s_S_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu15s_S_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_S_Sf");
    check_field_offset(lv, v2, 2, "BFu15s_S_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu15s_S_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_S_Sf(Test_BFu15s_S_Sf, "BFu15s_S_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf  {
  unsigned short v1:15;
  ::empty v2;
};
//SIG(1 BFu15s_Sf) C1{ Fs:15 FC2{}}



static void Test_BFu15s_Sf()
{
  {
    init_simple_test("BFu15s_Sf");
    static BFu15s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf");
    check_field_offset(lv, v2, 2, "BFu15s_Sf.v2");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf(Test_BFu15s_Sf, "BFu15s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu15i  {
  unsigned short v1:15;
  ::empty v2;
  unsigned int v3:15;
};
//SIG(1 BFu15s_Sf_BFu15i) C1{ Fs:15 FC2{} Fi:15}



static void Test_BFu15s_Sf_BFu15i()
{
  {
    init_simple_test("BFu15s_Sf_BFu15i");
    static BFu15s_Sf_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu15i");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15s_Sf_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu15i(Test_BFu15s_Sf_BFu15i, "BFu15s_Sf_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu15ll  {
  unsigned short v1:15;
  ::empty v2;
  __tsu64 v3:15;
};
//SIG(1 BFu15s_Sf_BFu15ll) C1{ Fs:15 FC2{} FL:15}



static void Test_BFu15s_Sf_BFu15ll()
{
  {
    init_simple_test("BFu15s_Sf_BFu15ll");
    static BFu15s_Sf_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu15s_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu15ll(Test_BFu15s_Sf_BFu15ll, "BFu15s_Sf_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu15s  {
  unsigned short v1:15;
  ::empty v2;
  unsigned short v3:15;
};
//SIG(1 BFu15s_Sf_BFu15s) C1{ Fs:15 FC2{} Fs:15}



static void Test_BFu15s_Sf_BFu15s()
{
  {
    init_simple_test("BFu15s_Sf_BFu15s");
    static BFu15s_Sf_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15s_Sf_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu15s");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu15s_Sf_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu15s(Test_BFu15s_Sf_BFu15s, "BFu15s_Sf_BFu15s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu16i  {
  unsigned short v1:15;
  ::empty v2;
  unsigned int v3:16;
};
//SIG(1 BFu15s_Sf_BFu16i) C1{ Fs:15 FC2{} Fi:16}



static void Test_BFu15s_Sf_BFu16i()
{
  {
    init_simple_test("BFu15s_Sf_BFu16i");
    static BFu15s_Sf_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu16i");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15s_Sf_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15s_Sf_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu16i(Test_BFu15s_Sf_BFu16i, "BFu15s_Sf_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu16ll  {
  unsigned short v1:15;
  ::empty v2;
  __tsu64 v3:16;
};
//SIG(1 BFu15s_Sf_BFu16ll) C1{ Fs:15 FC2{} FL:16}



static void Test_BFu15s_Sf_BFu16ll()
{
  {
    init_simple_test("BFu15s_Sf_BFu16ll");
    static BFu15s_Sf_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu15s_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu15s_Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu16ll(Test_BFu15s_Sf_BFu16ll, "BFu15s_Sf_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu16s  {
  unsigned short v1:15;
  ::empty v2;
  unsigned short v3:16;
};
//SIG(1 BFu15s_Sf_BFu16s) C1{ Fs:15 FC2{} Fs:16}



static void Test_BFu15s_Sf_BFu16s()
{
  {
    init_simple_test("BFu15s_Sf_BFu16s");
    static BFu15s_Sf_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15s_Sf_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu16s");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu15s_Sf_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu15s_Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu16s(Test_BFu15s_Sf_BFu16s, "BFu15s_Sf_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu17i  {
  unsigned short v1:15;
  ::empty v2;
  unsigned int v3:17;
};
//SIG(1 BFu15s_Sf_BFu17i) C1{ Fs:15 FC2{} Fi:17}



static void Test_BFu15s_Sf_BFu17i()
{
  {
    init_simple_test("BFu15s_Sf_BFu17i");
    static BFu15s_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu17i");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu15s_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu15s_Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu17i(Test_BFu15s_Sf_BFu17i, "BFu15s_Sf_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu17ll  {
  unsigned short v1:15;
  ::empty v2;
  __tsu64 v3:17;
};
//SIG(1 BFu15s_Sf_BFu17ll) C1{ Fs:15 FC2{} FL:17}



static void Test_BFu15s_Sf_BFu17ll()
{
  {
    init_simple_test("BFu15s_Sf_BFu17ll");
    static BFu15s_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu15s_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu15s_Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu17ll(Test_BFu15s_Sf_BFu17ll, "BFu15s_Sf_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu1c  {
  unsigned short v1:15;
  ::empty v2;
  unsigned char v3:1;
};
//SIG(1 BFu15s_Sf_BFu1c) C1{ Fs:15 FC2{} Fc:1}



static void Test_BFu15s_Sf_BFu1c()
{
  {
    init_simple_test("BFu15s_Sf_BFu1c");
    static BFu15s_Sf_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Sf_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu1c");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15s_Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu1c(Test_BFu15s_Sf_BFu1c, "BFu15s_Sf_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu1i  {
  unsigned short v1:15;
  ::empty v2;
  unsigned int v3:1;
};
//SIG(1 BFu15s_Sf_BFu1i) C1{ Fs:15 FC2{} Fi:1}



static void Test_BFu15s_Sf_BFu1i()
{
  {
    init_simple_test("BFu15s_Sf_BFu1i");
    static BFu15s_Sf_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Sf_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu1i");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15s_Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu1i(Test_BFu15s_Sf_BFu1i, "BFu15s_Sf_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu1ll  {
  unsigned short v1:15;
  ::empty v2;
  __tsu64 v3:1;
};
//SIG(1 BFu15s_Sf_BFu1ll) C1{ Fs:15 FC2{} FL:1}



static void Test_BFu15s_Sf_BFu1ll()
{
  {
    init_simple_test("BFu15s_Sf_BFu1ll");
    static BFu15s_Sf_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15s_Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu1ll(Test_BFu15s_Sf_BFu1ll, "BFu15s_Sf_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu1s  {
  unsigned short v1:15;
  ::empty v2;
  unsigned short v3:1;
};
//SIG(1 BFu15s_Sf_BFu1s) C1{ Fs:15 FC2{} Fs:1}



static void Test_BFu15s_Sf_BFu1s()
{
  {
    init_simple_test("BFu15s_Sf_BFu1s");
    static BFu15s_Sf_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Sf_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu1s");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu15s_Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu1s(Test_BFu15s_Sf_BFu1s, "BFu15s_Sf_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu31i  {
  unsigned short v1:15;
  ::empty v2;
  unsigned int v3:31;
};
//SIG(1 BFu15s_Sf_BFu31i) C1{ Fs:15 FC2{} Fi:31}



static void Test_BFu15s_Sf_BFu31i()
{
  {
    init_simple_test("BFu15s_Sf_BFu31i");
    static BFu15s_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu31i");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu15s_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu15s_Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu31i(Test_BFu15s_Sf_BFu31i, "BFu15s_Sf_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu31ll  {
  unsigned short v1:15;
  ::empty v2;
  __tsu64 v3:31;
};
//SIG(1 BFu15s_Sf_BFu31ll) C1{ Fs:15 FC2{} FL:31}



static void Test_BFu15s_Sf_BFu31ll()
{
  {
    init_simple_test("BFu15s_Sf_BFu31ll");
    static BFu15s_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu15s_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu15s_Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu31ll(Test_BFu15s_Sf_BFu31ll, "BFu15s_Sf_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu32i  {
  unsigned short v1:15;
  ::empty v2;
  unsigned int v3:32;
};
//SIG(1 BFu15s_Sf_BFu32i) C1{ Fs:15 FC2{} Fi:32}



static void Test_BFu15s_Sf_BFu32i()
{
  {
    init_simple_test("BFu15s_Sf_BFu32i");
    static BFu15s_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu32i");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu15s_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu15s_Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu32i(Test_BFu15s_Sf_BFu32i, "BFu15s_Sf_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu32ll  {
  unsigned short v1:15;
  ::empty v2;
  __tsu64 v3:32;
};
//SIG(1 BFu15s_Sf_BFu32ll) C1{ Fs:15 FC2{} FL:32}



static void Test_BFu15s_Sf_BFu32ll()
{
  {
    init_simple_test("BFu15s_Sf_BFu32ll");
    static BFu15s_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu15s_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu15s_Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu32ll(Test_BFu15s_Sf_BFu32ll, "BFu15s_Sf_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu33  {
  unsigned short v1:15;
  ::empty v2;
  __tsu64 v3:33;
};
//SIG(1 BFu15s_Sf_BFu33) C1{ Fs:15 FC2{} FL:33}



static void Test_BFu15s_Sf_BFu33()
{
  {
    init_simple_test("BFu15s_Sf_BFu33");
    static BFu15s_Sf_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu33");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu15s_Sf_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu15s_Sf_BFu33");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu33(Test_BFu15s_Sf_BFu33, "BFu15s_Sf_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu7c  {
  unsigned short v1:15;
  ::empty v2;
  unsigned char v3:7;
};
//SIG(1 BFu15s_Sf_BFu7c) C1{ Fs:15 FC2{} Fc:7}



static void Test_BFu15s_Sf_BFu7c()
{
  {
    init_simple_test("BFu15s_Sf_BFu7c");
    static BFu15s_Sf_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Sf_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu7c");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15s_Sf_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15s_Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu7c(Test_BFu15s_Sf_BFu7c, "BFu15s_Sf_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu7i  {
  unsigned short v1:15;
  ::empty v2;
  unsigned int v3:7;
};
//SIG(1 BFu15s_Sf_BFu7i) C1{ Fs:15 FC2{} Fi:7}



static void Test_BFu15s_Sf_BFu7i()
{
  {
    init_simple_test("BFu15s_Sf_BFu7i");
    static BFu15s_Sf_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Sf_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu7i");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15s_Sf_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15s_Sf_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu7i(Test_BFu15s_Sf_BFu7i, "BFu15s_Sf_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu7ll  {
  unsigned short v1:15;
  ::empty v2;
  __tsu64 v3:7;
};
//SIG(1 BFu15s_Sf_BFu7ll) C1{ Fs:15 FC2{} FL:7}



static void Test_BFu15s_Sf_BFu7ll()
{
  {
    init_simple_test("BFu15s_Sf_BFu7ll");
    static BFu15s_Sf_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15s_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15s_Sf_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu7ll(Test_BFu15s_Sf_BFu7ll, "BFu15s_Sf_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu7s  {
  unsigned short v1:15;
  ::empty v2;
  unsigned short v3:7;
};
//SIG(1 BFu15s_Sf_BFu7s) C1{ Fs:15 FC2{} Fs:7}



static void Test_BFu15s_Sf_BFu7s()
{
  {
    init_simple_test("BFu15s_Sf_BFu7s");
    static BFu15s_Sf_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Sf_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu7s");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu15s_Sf_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu15s_Sf_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu7s(Test_BFu15s_Sf_BFu7s, "BFu15s_Sf_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu8c  {
  unsigned short v1:15;
  ::empty v2;
  unsigned char v3:8;
};
//SIG(1 BFu15s_Sf_BFu8c) C1{ Fs:15 FC2{} Fc:8}



static void Test_BFu15s_Sf_BFu8c()
{
  {
    init_simple_test("BFu15s_Sf_BFu8c");
    static BFu15s_Sf_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Sf_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu8c");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15s_Sf_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15s_Sf_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu8c(Test_BFu15s_Sf_BFu8c, "BFu15s_Sf_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu8i  {
  unsigned short v1:15;
  ::empty v2;
  unsigned int v3:8;
};
//SIG(1 BFu15s_Sf_BFu8i) C1{ Fs:15 FC2{} Fi:8}



static void Test_BFu15s_Sf_BFu8i()
{
  {
    init_simple_test("BFu15s_Sf_BFu8i");
    static BFu15s_Sf_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Sf_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu8i");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15s_Sf_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15s_Sf_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu8i(Test_BFu15s_Sf_BFu8i, "BFu15s_Sf_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu8ll  {
  unsigned short v1:15;
  ::empty v2;
  __tsu64 v3:8;
};
//SIG(1 BFu15s_Sf_BFu8ll) C1{ Fs:15 FC2{} FL:8}



static void Test_BFu15s_Sf_BFu8ll()
{
  {
    init_simple_test("BFu15s_Sf_BFu8ll");
    static BFu15s_Sf_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu15s_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15s_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15s_Sf_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu8ll(Test_BFu15s_Sf_BFu8ll, "BFu15s_Sf_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu8s  {
  unsigned short v1:15;
  ::empty v2;
  unsigned short v3:8;
};
//SIG(1 BFu15s_Sf_BFu8s) C1{ Fs:15 FC2{} Fs:8}



static void Test_BFu15s_Sf_BFu8s()
{
  {
    init_simple_test("BFu15s_Sf_BFu8s");
    static BFu15s_Sf_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Sf_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu8s");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu15s_Sf_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu15s_Sf_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu8s(Test_BFu15s_Sf_BFu8s, "BFu15s_Sf_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu9i  {
  unsigned short v1:15;
  ::empty v2;
  unsigned int v3:9;
};
//SIG(1 BFu15s_Sf_BFu9i) C1{ Fs:15 FC2{} Fi:9}



static void Test_BFu15s_Sf_BFu9i()
{
  {
    init_simple_test("BFu15s_Sf_BFu9i");
    static BFu15s_Sf_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu9i");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15s_Sf_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15s_Sf_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu9i(Test_BFu15s_Sf_BFu9i, "BFu15s_Sf_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu9ll  {
  unsigned short v1:15;
  ::empty v2;
  __tsu64 v3:9;
};
//SIG(1 BFu15s_Sf_BFu9ll) C1{ Fs:15 FC2{} FL:9}



static void Test_BFu15s_Sf_BFu9ll()
{
  {
    init_simple_test("BFu15s_Sf_BFu9ll");
    static BFu15s_Sf_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu15s_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu15s_Sf_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu9ll(Test_BFu15s_Sf_BFu9ll, "BFu15s_Sf_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_BFu9s  {
  unsigned short v1:15;
  ::empty v2;
  unsigned short v3:9;
};
//SIG(1 BFu15s_Sf_BFu9s) C1{ Fs:15 FC2{} Fs:9}



static void Test_BFu15s_Sf_BFu9s()
{
  {
    init_simple_test("BFu15s_Sf_BFu9s");
    static BFu15s_Sf_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFu15s_Sf_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_BFu9s");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu15s_Sf_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu15s_Sf_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_BFu9s(Test_BFu15s_Sf_BFu9s, "BFu15s_Sf_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_C  {
  unsigned short v1:15;
  ::empty v2;
  char v3;
};
//SIG(1 BFu15s_Sf_C) C1{ Fs:15 FC2{} Fc}



static void Test_BFu15s_Sf_C()
{
  {
    init_simple_test("BFu15s_Sf_C");
    static BFu15s_Sf_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Sf_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_C");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_C.v2");
    check_field_offset(lv, v3, 3, "BFu15s_Sf_C.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_C(Test_BFu15s_Sf_C, "BFu15s_Sf_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_D  {
  unsigned short v1:15;
  ::empty v2;
  double v3;
};
//SIG(1 BFu15s_Sf_D) C1{ Fs:15 FC2{} FL}



static void Test_BFu15s_Sf_D()
{
  {
    init_simple_test("BFu15s_Sf_D");
    static BFu15s_Sf_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15s_Sf_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_D");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15s_Sf_D.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_D(Test_BFu15s_Sf_D, "BFu15s_Sf_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_F  {
  unsigned short v1:15;
  ::empty v2;
  float v3;
};
//SIG(1 BFu15s_Sf_F) C1{ Fs:15 FC2{} Fi}



static void Test_BFu15s_Sf_F()
{
  {
    init_simple_test("BFu15s_Sf_F");
    static BFu15s_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_F");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu15s_Sf_F.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_F(Test_BFu15s_Sf_F, "BFu15s_Sf_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_I  {
  unsigned short v1:15;
  ::empty v2;
  int v3;
};
//SIG(1 BFu15s_Sf_I) C1{ Fs:15 FC2{} Fi}



static void Test_BFu15s_Sf_I()
{
  {
    init_simple_test("BFu15s_Sf_I");
    static BFu15s_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_I");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu15s_Sf_I.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_I(Test_BFu15s_Sf_I, "BFu15s_Sf_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_Ip  {
  unsigned short v1:15;
  ::empty v2;
  int *v3;
};
//SIG(1 BFu15s_Sf_Ip) C1{ Fs:15 FC2{} Fp}



static void Test_BFu15s_Sf_Ip()
{
  {
    init_simple_test("BFu15s_Sf_Ip");
    static BFu15s_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15s_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_Ip");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15s_Sf_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_Ip(Test_BFu15s_Sf_Ip, "BFu15s_Sf_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_L  {
  unsigned short v1:15;
  ::empty v2;
  __tsi64 v3;
};
//SIG(1 BFu15s_Sf_L) C1{ Fs:15 FC2{} FL}



static void Test_BFu15s_Sf_L()
{
  {
    init_simple_test("BFu15s_Sf_L");
    static BFu15s_Sf_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15s_Sf_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_L");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15s_Sf_L.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_L(Test_BFu15s_Sf_L, "BFu15s_Sf_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_S  {
  unsigned short v1:15;
  ::empty v2;
  short v3;
};
//SIG(1 BFu15s_Sf_S) C1{ Fs:15 FC2{} Fs}



static void Test_BFu15s_Sf_S()
{
  {
    init_simple_test("BFu15s_Sf_S");
    static BFu15s_Sf_S lv;
    check2(sizeof(lv), 6, "sizeof(BFu15s_Sf_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_S");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_S.v2");
    check_field_offset(lv, v3, 4, "BFu15s_Sf_S.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_S(Test_BFu15s_Sf_S, "BFu15s_Sf_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_Sf  {
  unsigned short v1:15;
  ::empty v2;
  ::empty v3;
};
//SIG(1 BFu15s_Sf_Sf) C1{ Fs:15 FC2{} FC2}



static void Test_BFu15s_Sf_Sf()
{
  {
    init_simple_test("BFu15s_Sf_Sf");
    static BFu15s_Sf_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Sf_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_Sf");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu15s_Sf_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_Sf(Test_BFu15s_Sf_Sf, "BFu15s_Sf_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_Uc  {
  unsigned short v1:15;
  ::empty v2;
  unsigned char v3;
};
//SIG(1 BFu15s_Sf_Uc) C1{ Fs:15 FC2{} Fc}



static void Test_BFu15s_Sf_Uc()
{
  {
    init_simple_test("BFu15s_Sf_Uc");
    static BFu15s_Sf_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Sf_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_Uc");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu15s_Sf_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_Uc(Test_BFu15s_Sf_Uc, "BFu15s_Sf_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_Ui  {
  unsigned short v1:15;
  ::empty v2;
  unsigned int v3;
};
//SIG(1 BFu15s_Sf_Ui) C1{ Fs:15 FC2{} Fi}



static void Test_BFu15s_Sf_Ui()
{
  {
    init_simple_test("BFu15s_Sf_Ui");
    static BFu15s_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu15s_Sf_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_Ui");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu15s_Sf_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_Ui(Test_BFu15s_Sf_Ui, "BFu15s_Sf_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_Ul  {
  unsigned short v1:15;
  ::empty v2;
  __tsu64 v3;
};
//SIG(1 BFu15s_Sf_Ul) C1{ Fs:15 FC2{} FL}



static void Test_BFu15s_Sf_Ul()
{
  {
    init_simple_test("BFu15s_Sf_Ul");
    static BFu15s_Sf_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu15s_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_Ul");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15s_Sf_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_Ul(Test_BFu15s_Sf_Ul, "BFu15s_Sf_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_Us  {
  unsigned short v1:15;
  ::empty v2;
  unsigned short v3;
};
//SIG(1 BFu15s_Sf_Us) C1{ Fs:15 FC2{} Fs}



static void Test_BFu15s_Sf_Us()
{
  {
    init_simple_test("BFu15s_Sf_Us");
    static BFu15s_Sf_Us lv;
    check2(sizeof(lv), 6, "sizeof(BFu15s_Sf_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_Us");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_Us.v2");
    check_field_offset(lv, v3, 4, "BFu15s_Sf_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_Us(Test_BFu15s_Sf_Us, "BFu15s_Sf_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Sf_Vp  {
  unsigned short v1:15;
  ::empty v2;
  void *v3;
};
//SIG(1 BFu15s_Sf_Vp) C1{ Fs:15 FC2{} Fp}



static void Test_BFu15s_Sf_Vp()
{
  {
    init_simple_test("BFu15s_Sf_Vp");
    static BFu15s_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu15s_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Sf_Vp");
    check_field_offset(lv, v2, 2, "BFu15s_Sf_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu15s_Sf_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Sf_Vp(Test_BFu15s_Sf_Vp, "BFu15s_Sf_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Uc_Sf  {
  unsigned short v1:15;
  unsigned char v2;
  ::empty v3;
};
//SIG(1 BFu15s_Uc_Sf) C1{ Fs:15 Fc FC2{}}



static void Test_BFu15s_Uc_Sf()
{
  {
    init_simple_test("BFu15s_Uc_Sf");
    static BFu15s_Uc_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu15s_Uc_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Uc_Sf");
    check_field_offset(lv, v2, 2, "BFu15s_Uc_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu15s_Uc_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Uc_Sf(Test_BFu15s_Uc_Sf, "BFu15s_Uc_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Ui_Sf  {
  unsigned short v1:15;
  unsigned int v2;
  ::empty v3;
};
//SIG(1 BFu15s_Ui_Sf) C1{ Fs:15 Fi FC2{}}



static void Test_BFu15s_Ui_Sf()
{
  {
    init_simple_test("BFu15s_Ui_Sf");
    static BFu15s_Ui_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu15s_Ui_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu15s_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu15s_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu15s_Ui_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Ui_Sf(Test_BFu15s_Ui_Sf, "BFu15s_Ui_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Ul_Sf  {
  unsigned short v1:15;
  __tsu64 v2;
  ::empty v3;
};
//SIG(1 BFu15s_Ul_Sf) C1{ Fs:15 FL FC2{}}



static void Test_BFu15s_Ul_Sf()
{
  {
    init_simple_test("BFu15s_Ul_Sf");
    static BFu15s_Ul_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu15s_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Ul_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_Ul_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu15s_Ul_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Ul_Sf(Test_BFu15s_Ul_Sf, "BFu15s_Ul_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Us_Sf  {
  unsigned short v1:15;
  unsigned short v2;
  ::empty v3;
};
//SIG(1 BFu15s_Us_Sf) C1{ Fs:15 Fs FC2{}}



static void Test_BFu15s_Us_Sf()
{
  {
    init_simple_test("BFu15s_Us_Sf");
    static BFu15s_Us_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu15s_Us_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu15s_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Us_Sf");
    check_field_offset(lv, v2, 2, "BFu15s_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu15s_Us_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Us_Sf(Test_BFu15s_Us_Sf, "BFu15s_Us_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu15s_Vp_Sf  {
  unsigned short v1:15;
  void *v2;
  ::empty v3;
};
//SIG(1 BFu15s_Vp_Sf) C1{ Fs:15 Fp FC2{}}



static void Test_BFu15s_Vp_Sf()
{
  {
    init_simple_test("BFu15s_Vp_Sf");
    static BFu15s_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu15s_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu15s_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 15, 1, "BFu15s_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 15, hide_ull(1LL<<14), "BFu15s_Vp_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu15s_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu15s_Vp_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu15s_Vp_Sf(Test_BFu15s_Vp_Sf, "BFu15s_Vp_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu15i_Sf  {
  unsigned int v1:16;
  unsigned int v2:15;
  ::empty v3;
};
//SIG(1 BFu16i_BFu15i_Sf) C1{ Fi:16 Fi:15 FC2{}}



static void Test_BFu16i_BFu15i_Sf()
{
  {
    init_simple_test("BFu16i_BFu15i_Sf");
    static BFu16i_BFu15i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu15i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16i_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "BFu16i_BFu15i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu15i_Sf(Test_BFu16i_BFu15i_Sf, "BFu16i_BFu15i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu15ll_Sf  {
  unsigned int v1:16;
  __tsu64 v2:15;
  ::empty v3;
};
//SIG(1 BFu16i_BFu15ll_Sf) C1{ Fi:16 FL:15 FC2{}}



static void Test_BFu16i_BFu15ll_Sf()
{
  {
    init_simple_test("BFu16i_BFu15ll_Sf");
    static BFu16i_BFu15ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16i_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "BFu16i_BFu15ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu15ll_Sf(Test_BFu16i_BFu15ll_Sf, "BFu16i_BFu15ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu15s_Sf  {
  unsigned int v1:16;
  unsigned short v2:15;
  ::empty v3;
};
//SIG(1 BFu16i_BFu15s_Sf) C1{ Fi:16 Fs:15 FC2{}}



static void Test_BFu16i_BFu15s_Sf()
{
  {
    init_simple_test("BFu16i_BFu15s_Sf");
    static BFu16i_BFu15s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu15s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16i_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "BFu16i_BFu15s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu15s_Sf(Test_BFu16i_BFu15s_Sf, "BFu16i_BFu15s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu16i_Sf  {
  unsigned int v1:16;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 BFu16i_BFu16i_Sf) C1{ Fi:16 Fi:16 FC2{}}



static void Test_BFu16i_BFu16i_Sf()
{
  {
    init_simple_test("BFu16i_BFu16i_Sf");
    static BFu16i_BFu16i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu16i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu16i_Sf");
    check_field_offset(lv, v3, 4, "BFu16i_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu16i_Sf(Test_BFu16i_BFu16i_Sf, "BFu16i_BFu16i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu16ll_Sf  {
  unsigned int v1:16;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 BFu16i_BFu16ll_Sf) C1{ Fi:16 FL:16 FC2{}}



static void Test_BFu16i_BFu16ll_Sf()
{
  {
    init_simple_test("BFu16i_BFu16ll_Sf");
    static BFu16i_BFu16ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu16ll_Sf");
    check_field_offset(lv, v3, 4, "BFu16i_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu16ll_Sf(Test_BFu16i_BFu16ll_Sf, "BFu16i_BFu16ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu16s_Sf  {
  unsigned int v1:16;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 BFu16i_BFu16s_Sf) C1{ Fi:16 Fs:16 FC2{}}



static void Test_BFu16i_BFu16s_Sf()
{
  {
    init_simple_test("BFu16i_BFu16s_Sf");
    static BFu16i_BFu16s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu16s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "BFu16i_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu16s_Sf(Test_BFu16i_BFu16s_Sf, "BFu16i_BFu16s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu17i_Sf  {
  unsigned int v1:16;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 BFu16i_BFu17i_Sf) C1{ Fi:16 Fi:17 FC2{}}



static void Test_BFu16i_BFu17i_Sf()
{
  {
    init_simple_test("BFu16i_BFu17i_Sf");
    static BFu16i_BFu17i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu17i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu16i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu16i_BFu17i_Sf");
    check_field_offset(lv, v3, 7, "BFu16i_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu17i_Sf(Test_BFu16i_BFu17i_Sf, "BFu16i_BFu17i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu17ll_Sf  {
  unsigned int v1:16;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 BFu16i_BFu17ll_Sf) C1{ Fi:16 FL:17 FC2{}}



static void Test_BFu16i_BFu17ll_Sf()
{
  {
    init_simple_test("BFu16i_BFu17ll_Sf");
    static BFu16i_BFu17ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu16i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu16i_BFu17ll_Sf");
    check_field_offset(lv, v3, 5, "BFu16i_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu17ll_Sf(Test_BFu16i_BFu17ll_Sf, "BFu16i_BFu17ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu1c_Sf  {
  unsigned int v1:16;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 BFu16i_BFu1c_Sf) C1{ Fi:16 Fc:1 FC2{}}



static void Test_BFu16i_BFu1c_Sf()
{
  {
    init_simple_test("BFu16i_BFu1c_Sf");
    static BFu16i_BFu1c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu1c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu1c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16i_BFu1c_Sf");
    check_field_offset(lv, v3, 3, "BFu16i_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu1c_Sf(Test_BFu16i_BFu1c_Sf, "BFu16i_BFu1c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu1i_Sf  {
  unsigned int v1:16;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 BFu16i_BFu1i_Sf) C1{ Fi:16 Fi:1 FC2{}}



static void Test_BFu16i_BFu1i_Sf()
{
  {
    init_simple_test("BFu16i_BFu1i_Sf");
    static BFu16i_BFu1i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu1i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu1i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16i_BFu1i_Sf");
    check_field_offset(lv, v3, 3, "BFu16i_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu1i_Sf(Test_BFu16i_BFu1i_Sf, "BFu16i_BFu1i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu1ll_Sf  {
  unsigned int v1:16;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 BFu16i_BFu1ll_Sf) C1{ Fi:16 FL:1 FC2{}}



static void Test_BFu16i_BFu1ll_Sf()
{
  {
    init_simple_test("BFu16i_BFu1ll_Sf");
    static BFu16i_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16i_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16i_BFu1ll_Sf");
    check_field_offset(lv, v3, 3, "BFu16i_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu1ll_Sf(Test_BFu16i_BFu1ll_Sf, "BFu16i_BFu1ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu1s_Sf  {
  unsigned int v1:16;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 BFu16i_BFu1s_Sf) C1{ Fi:16 Fs:1 FC2{}}



static void Test_BFu16i_BFu1s_Sf()
{
  {
    init_simple_test("BFu16i_BFu1s_Sf");
    static BFu16i_BFu1s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu1s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu1s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16i_BFu1s_Sf");
    check_field_offset(lv, v3, 3, "BFu16i_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu1s_Sf(Test_BFu16i_BFu1s_Sf, "BFu16i_BFu1s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu31i_Sf  {
  unsigned int v1:16;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 BFu16i_BFu31i_Sf) C1{ Fi:16 Fi:31 FC2{}}



static void Test_BFu16i_BFu31i_Sf()
{
  {
    init_simple_test("BFu16i_BFu31i_Sf");
    static BFu16i_BFu31i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu16i_BFu31i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu16i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu16i_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "BFu16i_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu31i_Sf(Test_BFu16i_BFu31i_Sf, "BFu16i_BFu31i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu31ll_Sf  {
  unsigned int v1:16;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 BFu16i_BFu31ll_Sf) C1{ Fi:16 FL:31 FC2{}}



static void Test_BFu16i_BFu31ll_Sf()
{
  {
    init_simple_test("BFu16i_BFu31ll_Sf");
    static BFu16i_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu16i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu16i_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "BFu16i_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu31ll_Sf(Test_BFu16i_BFu31ll_Sf, "BFu16i_BFu31ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu32i_Sf  {
  unsigned int v1:16;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 BFu16i_BFu32i_Sf) C1{ Fi:16 Fi:32 FC2{}}



static void Test_BFu16i_BFu32i_Sf()
{
  {
    init_simple_test("BFu16i_BFu32i_Sf");
    static BFu16i_BFu32i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu16i_BFu32i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu16i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu16i_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu16i_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu32i_Sf(Test_BFu16i_BFu32i_Sf, "BFu16i_BFu32i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu32ll_Sf  {
  unsigned int v1:16;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 BFu16i_BFu32ll_Sf) C1{ Fi:16 FL:32 FC2{}}



static void Test_BFu16i_BFu32ll_Sf()
{
  {
    init_simple_test("BFu16i_BFu32ll_Sf");
    static BFu16i_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu16i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu16i_BFu32ll_Sf");
    check_field_offset(lv, v3, 6, "BFu16i_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu32ll_Sf(Test_BFu16i_BFu32ll_Sf, "BFu16i_BFu32ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu33_Sf  {
  unsigned int v1:16;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 BFu16i_BFu33_Sf) C1{ Fi:16 FL:33 FC2{}}



static void Test_BFu16i_BFu33_Sf()
{
  {
    init_simple_test("BFu16i_BFu33_Sf");
    static BFu16i_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu16i_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu16i_BFu33_Sf");
    check_field_offset(lv, v3, 7, "BFu16i_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu33_Sf(Test_BFu16i_BFu33_Sf, "BFu16i_BFu33_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu7c_Sf  {
  unsigned int v1:16;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 BFu16i_BFu7c_Sf) C1{ Fi:16 Fc:7 FC2{}}



static void Test_BFu16i_BFu7c_Sf()
{
  {
    init_simple_test("BFu16i_BFu7c_Sf");
    static BFu16i_BFu7c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu7c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16i_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "BFu16i_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu7c_Sf(Test_BFu16i_BFu7c_Sf, "BFu16i_BFu7c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu7i_Sf  {
  unsigned int v1:16;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 BFu16i_BFu7i_Sf) C1{ Fi:16 Fi:7 FC2{}}



static void Test_BFu16i_BFu7i_Sf()
{
  {
    init_simple_test("BFu16i_BFu7i_Sf");
    static BFu16i_BFu7i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu7i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16i_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "BFu16i_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu7i_Sf(Test_BFu16i_BFu7i_Sf, "BFu16i_BFu7i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu7ll_Sf  {
  unsigned int v1:16;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 BFu16i_BFu7ll_Sf) C1{ Fi:16 FL:7 FC2{}}



static void Test_BFu16i_BFu7ll_Sf()
{
  {
    init_simple_test("BFu16i_BFu7ll_Sf");
    static BFu16i_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16i_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16i_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "BFu16i_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu7ll_Sf(Test_BFu16i_BFu7ll_Sf, "BFu16i_BFu7ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu7s_Sf  {
  unsigned int v1:16;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 BFu16i_BFu7s_Sf) C1{ Fi:16 Fs:7 FC2{}}



static void Test_BFu16i_BFu7s_Sf()
{
  {
    init_simple_test("BFu16i_BFu7s_Sf");
    static BFu16i_BFu7s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu7s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16i_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "BFu16i_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu7s_Sf(Test_BFu16i_BFu7s_Sf, "BFu16i_BFu7s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu8c_Sf  {
  unsigned int v1:16;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 BFu16i_BFu8c_Sf) C1{ Fi:16 Fc:8 FC2{}}



static void Test_BFu16i_BFu8c_Sf()
{
  {
    init_simple_test("BFu16i_BFu8c_Sf");
    static BFu16i_BFu8c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu8c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16i_BFu8c_Sf");
    check_field_offset(lv, v3, 3, "BFu16i_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu8c_Sf(Test_BFu16i_BFu8c_Sf, "BFu16i_BFu8c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu8i_Sf  {
  unsigned int v1:16;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 BFu16i_BFu8i_Sf) C1{ Fi:16 Fi:8 FC2{}}



static void Test_BFu16i_BFu8i_Sf()
{
  {
    init_simple_test("BFu16i_BFu8i_Sf");
    static BFu16i_BFu8i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu8i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16i_BFu8i_Sf");
    check_field_offset(lv, v3, 3, "BFu16i_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu8i_Sf(Test_BFu16i_BFu8i_Sf, "BFu16i_BFu8i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu8ll_Sf  {
  unsigned int v1:16;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 BFu16i_BFu8ll_Sf) C1{ Fi:16 FL:8 FC2{}}



static void Test_BFu16i_BFu8ll_Sf()
{
  {
    init_simple_test("BFu16i_BFu8ll_Sf");
    static BFu16i_BFu8ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16i_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16i_BFu8ll_Sf");
    check_field_offset(lv, v3, 3, "BFu16i_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu8ll_Sf(Test_BFu16i_BFu8ll_Sf, "BFu16i_BFu8ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu8s_Sf  {
  unsigned int v1:16;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 BFu16i_BFu8s_Sf) C1{ Fi:16 Fs:8 FC2{}}



static void Test_BFu16i_BFu8s_Sf()
{
  {
    init_simple_test("BFu16i_BFu8s_Sf");
    static BFu16i_BFu8s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_BFu8s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16i_BFu8s_Sf");
    check_field_offset(lv, v3, 3, "BFu16i_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu8s_Sf(Test_BFu16i_BFu8s_Sf, "BFu16i_BFu8s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu9i_Sf  {
  unsigned int v1:16;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 BFu16i_BFu9i_Sf) C1{ Fi:16 Fi:9 FC2{}}



static void Test_BFu16i_BFu9i_Sf()
{
  {
    init_simple_test("BFu16i_BFu9i_Sf");
    static BFu16i_BFu9i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu9i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu16i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu16i_BFu9i_Sf");
    check_field_offset(lv, v3, 4, "BFu16i_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu9i_Sf(Test_BFu16i_BFu9i_Sf, "BFu16i_BFu9i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu9ll_Sf  {
  unsigned int v1:16;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 BFu16i_BFu9ll_Sf) C1{ Fi:16 FL:9 FC2{}}



static void Test_BFu16i_BFu9ll_Sf()
{
  {
    init_simple_test("BFu16i_BFu9ll_Sf");
    static BFu16i_BFu9ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu16i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu16i_BFu9ll_Sf");
    check_field_offset(lv, v3, 4, "BFu16i_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu9ll_Sf(Test_BFu16i_BFu9ll_Sf, "BFu16i_BFu9ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_BFu9s_Sf  {
  unsigned int v1:16;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 BFu16i_BFu9s_Sf) C1{ Fi:16 Fs:9 FC2{}}



static void Test_BFu16i_BFu9s_Sf()
{
  {
    init_simple_test("BFu16i_BFu9s_Sf");
    static BFu16i_BFu9s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_BFu9s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu16i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu16i_BFu9s_Sf");
    check_field_offset(lv, v3, 4, "BFu16i_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_BFu9s_Sf(Test_BFu16i_BFu9s_Sf, "BFu16i_BFu9s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_C_Sf  {
  unsigned int v1:16;
  char v2;
  ::empty v3;
};
//SIG(1 BFu16i_C_Sf) C1{ Fi:16 Fc FC2{}}



static void Test_BFu16i_C_Sf()
{
  {
    init_simple_test("BFu16i_C_Sf");
    static BFu16i_C_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_C_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_C_Sf");
    check_field_offset(lv, v2, 2, "BFu16i_C_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu16i_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_C_Sf(Test_BFu16i_C_Sf, "BFu16i_C_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_D_Sf  {
  unsigned int v1:16;
  double v2;
  ::empty v3;
};
//SIG(1 BFu16i_D_Sf) C1{ Fi:16 FL FC2{}}



static void Test_BFu16i_D_Sf()
{
  {
    init_simple_test("BFu16i_D_Sf");
    static BFu16i_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu16i_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_D_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16i_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu16i_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_D_Sf(Test_BFu16i_D_Sf, "BFu16i_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_F_Sf  {
  unsigned int v1:16;
  float v2;
  ::empty v3;
};
//SIG(1 BFu16i_F_Sf) C1{ Fi:16 Fi FC2{}}



static void Test_BFu16i_F_Sf()
{
  {
    init_simple_test("BFu16i_F_Sf");
    static BFu16i_F_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu16i_F_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_F_Sf");
    check_field_offset(lv, v2, 4, "BFu16i_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu16i_F_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_F_Sf(Test_BFu16i_F_Sf, "BFu16i_F_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_I_Sf  {
  unsigned int v1:16;
  int v2;
  ::empty v3;
};
//SIG(1 BFu16i_I_Sf) C1{ Fi:16 Fi FC2{}}



static void Test_BFu16i_I_Sf()
{
  {
    init_simple_test("BFu16i_I_Sf");
    static BFu16i_I_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu16i_I_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_I_Sf");
    check_field_offset(lv, v2, 4, "BFu16i_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu16i_I_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_I_Sf(Test_BFu16i_I_Sf, "BFu16i_I_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Ip_Sf  {
  unsigned int v1:16;
  int *v2;
  ::empty v3;
};
//SIG(1 BFu16i_Ip_Sf) C1{ Fi:16 Fp FC2{}}



static void Test_BFu16i_Ip_Sf()
{
  {
    init_simple_test("BFu16i_Ip_Sf");
    static BFu16i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu16i_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Ip_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu16i_Ip_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Ip_Sf(Test_BFu16i_Ip_Sf, "BFu16i_Ip_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_L_Sf  {
  unsigned int v1:16;
  __tsi64 v2;
  ::empty v3;
};
//SIG(1 BFu16i_L_Sf) C1{ Fi:16 FL FC2{}}



static void Test_BFu16i_L_Sf()
{
  {
    init_simple_test("BFu16i_L_Sf");
    static BFu16i_L_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu16i_L_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_L_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16i_L_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu16i_L_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_L_Sf(Test_BFu16i_L_Sf, "BFu16i_L_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_S_Sf  {
  unsigned int v1:16;
  short v2;
  ::empty v3;
};
//SIG(1 BFu16i_S_Sf) C1{ Fi:16 Fs FC2{}}



static void Test_BFu16i_S_Sf()
{
  {
    init_simple_test("BFu16i_S_Sf");
    static BFu16i_S_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_S_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_S_Sf");
    check_field_offset(lv, v2, 2, "BFu16i_S_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu16i_S_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_S_Sf(Test_BFu16i_S_Sf, "BFu16i_S_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf  {
  unsigned int v1:16;
  ::empty v2;
};
//SIG(1 BFu16i_Sf) C1{ Fi:16 FC2{}}



static void Test_BFu16i_Sf()
{
  {
    init_simple_test("BFu16i_Sf");
    static BFu16i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf");
    check_field_offset(lv, v2, 2, "BFu16i_Sf.v2");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf(Test_BFu16i_Sf, "BFu16i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu15i  {
  unsigned int v1:16;
  ::empty v2;
  unsigned int v3:15;
};
//SIG(1 BFu16i_Sf_BFu15i) C1{ Fi:16 FC2{} Fi:15}



static void Test_BFu16i_Sf_BFu15i()
{
  {
    init_simple_test("BFu16i_Sf_BFu15i");
    static BFu16i_Sf_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu15i");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu16i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu16i_Sf_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu15i(Test_BFu16i_Sf_BFu15i, "BFu16i_Sf_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu15ll  {
  unsigned int v1:16;
  ::empty v2;
  __tsu64 v3:15;
};
//SIG(1 BFu16i_Sf_BFu15ll) C1{ Fi:16 FC2{} FL:15}



static void Test_BFu16i_Sf_BFu15ll()
{
  {
    init_simple_test("BFu16i_Sf_BFu15ll");
    static BFu16i_Sf_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu16i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu16i_Sf_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu15ll(Test_BFu16i_Sf_BFu15ll, "BFu16i_Sf_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu15s  {
  unsigned int v1:16;
  ::empty v2;
  unsigned short v3:15;
};
//SIG(1 BFu16i_Sf_BFu15s) C1{ Fi:16 FC2{} Fs:15}



static void Test_BFu16i_Sf_BFu15s()
{
  {
    init_simple_test("BFu16i_Sf_BFu15s");
    static BFu16i_Sf_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu15s");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu16i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu16i_Sf_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu15s(Test_BFu16i_Sf_BFu15s, "BFu16i_Sf_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu16i  {
  unsigned int v1:16;
  ::empty v2;
  unsigned int v3:16;
};
//SIG(1 BFu16i_Sf_BFu16i) C1{ Fi:16 FC2{} Fi:16}



static void Test_BFu16i_Sf_BFu16i()
{
  {
    init_simple_test("BFu16i_Sf_BFu16i");
    static BFu16i_Sf_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu16i");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu16i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu16i(Test_BFu16i_Sf_BFu16i, "BFu16i_Sf_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu16ll  {
  unsigned int v1:16;
  ::empty v2;
  __tsu64 v3:16;
};
//SIG(1 BFu16i_Sf_BFu16ll) C1{ Fi:16 FC2{} FL:16}



static void Test_BFu16i_Sf_BFu16ll()
{
  {
    init_simple_test("BFu16i_Sf_BFu16ll");
    static BFu16i_Sf_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu16i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu16ll(Test_BFu16i_Sf_BFu16ll, "BFu16i_Sf_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu16s  {
  unsigned int v1:16;
  ::empty v2;
  unsigned short v3:16;
};
//SIG(1 BFu16i_Sf_BFu16s) C1{ Fi:16 FC2{} Fs:16}



static void Test_BFu16i_Sf_BFu16s()
{
  {
    init_simple_test("BFu16i_Sf_BFu16s");
    static BFu16i_Sf_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu16s");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu16i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu16s(Test_BFu16i_Sf_BFu16s, "BFu16i_Sf_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu17i  {
  unsigned int v1:16;
  ::empty v2;
  unsigned int v3:17;
};
//SIG(1 BFu16i_Sf_BFu17i) C1{ Fi:16 FC2{} Fi:17}



static void Test_BFu16i_Sf_BFu17i()
{
  {
    init_simple_test("BFu16i_Sf_BFu17i");
    static BFu16i_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu17i");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu16i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu16i_Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu17i(Test_BFu16i_Sf_BFu17i, "BFu16i_Sf_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu17ll  {
  unsigned int v1:16;
  ::empty v2;
  __tsu64 v3:17;
};
//SIG(1 BFu16i_Sf_BFu17ll) C1{ Fi:16 FC2{} FL:17}



static void Test_BFu16i_Sf_BFu17ll()
{
  {
    init_simple_test("BFu16i_Sf_BFu17ll");
    static BFu16i_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu16i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu16i_Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu17ll(Test_BFu16i_Sf_BFu17ll, "BFu16i_Sf_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu1c  {
  unsigned int v1:16;
  ::empty v2;
  unsigned char v3:1;
};
//SIG(1 BFu16i_Sf_BFu1c) C1{ Fi:16 FC2{} Fc:1}



static void Test_BFu16i_Sf_BFu1c()
{
  {
    init_simple_test("BFu16i_Sf_BFu1c");
    static BFu16i_Sf_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Sf_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu1c");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16i_Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu1c(Test_BFu16i_Sf_BFu1c, "BFu16i_Sf_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu1i  {
  unsigned int v1:16;
  ::empty v2;
  unsigned int v3:1;
};
//SIG(1 BFu16i_Sf_BFu1i) C1{ Fi:16 FC2{} Fi:1}



static void Test_BFu16i_Sf_BFu1i()
{
  {
    init_simple_test("BFu16i_Sf_BFu1i");
    static BFu16i_Sf_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Sf_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu1i");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16i_Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu1i(Test_BFu16i_Sf_BFu1i, "BFu16i_Sf_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu1ll  {
  unsigned int v1:16;
  ::empty v2;
  __tsu64 v3:1;
};
//SIG(1 BFu16i_Sf_BFu1ll) C1{ Fi:16 FC2{} FL:1}



static void Test_BFu16i_Sf_BFu1ll()
{
  {
    init_simple_test("BFu16i_Sf_BFu1ll");
    static BFu16i_Sf_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16i_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16i_Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu1ll(Test_BFu16i_Sf_BFu1ll, "BFu16i_Sf_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu1s  {
  unsigned int v1:16;
  ::empty v2;
  unsigned short v3:1;
};
//SIG(1 BFu16i_Sf_BFu1s) C1{ Fi:16 FC2{} Fs:1}



static void Test_BFu16i_Sf_BFu1s()
{
  {
    init_simple_test("BFu16i_Sf_BFu1s");
    static BFu16i_Sf_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Sf_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu1s");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16i_Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu1s(Test_BFu16i_Sf_BFu1s, "BFu16i_Sf_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu31i  {
  unsigned int v1:16;
  ::empty v2;
  unsigned int v3:31;
};
//SIG(1 BFu16i_Sf_BFu31i) C1{ Fi:16 FC2{} Fi:31}



static void Test_BFu16i_Sf_BFu31i()
{
  {
    init_simple_test("BFu16i_Sf_BFu31i");
    static BFu16i_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu31i");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu16i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu16i_Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu31i(Test_BFu16i_Sf_BFu31i, "BFu16i_Sf_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu31ll  {
  unsigned int v1:16;
  ::empty v2;
  __tsu64 v3:31;
};
//SIG(1 BFu16i_Sf_BFu31ll) C1{ Fi:16 FC2{} FL:31}



static void Test_BFu16i_Sf_BFu31ll()
{
  {
    init_simple_test("BFu16i_Sf_BFu31ll");
    static BFu16i_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu16i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu16i_Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu31ll(Test_BFu16i_Sf_BFu31ll, "BFu16i_Sf_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu32i  {
  unsigned int v1:16;
  ::empty v2;
  unsigned int v3:32;
};
//SIG(1 BFu16i_Sf_BFu32i) C1{ Fi:16 FC2{} Fi:32}



static void Test_BFu16i_Sf_BFu32i()
{
  {
    init_simple_test("BFu16i_Sf_BFu32i");
    static BFu16i_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu32i");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu16i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu16i_Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu32i(Test_BFu16i_Sf_BFu32i, "BFu16i_Sf_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu32ll  {
  unsigned int v1:16;
  ::empty v2;
  __tsu64 v3:32;
};
//SIG(1 BFu16i_Sf_BFu32ll) C1{ Fi:16 FC2{} FL:32}



static void Test_BFu16i_Sf_BFu32ll()
{
  {
    init_simple_test("BFu16i_Sf_BFu32ll");
    static BFu16i_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu16i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu16i_Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu32ll(Test_BFu16i_Sf_BFu32ll, "BFu16i_Sf_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu33  {
  unsigned int v1:16;
  ::empty v2;
  __tsu64 v3:33;
};
//SIG(1 BFu16i_Sf_BFu33) C1{ Fi:16 FC2{} FL:33}



static void Test_BFu16i_Sf_BFu33()
{
  {
    init_simple_test("BFu16i_Sf_BFu33");
    static BFu16i_Sf_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu33");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu16i_Sf_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu16i_Sf_BFu33");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu33(Test_BFu16i_Sf_BFu33, "BFu16i_Sf_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu7c  {
  unsigned int v1:16;
  ::empty v2;
  unsigned char v3:7;
};
//SIG(1 BFu16i_Sf_BFu7c) C1{ Fi:16 FC2{} Fc:7}



static void Test_BFu16i_Sf_BFu7c()
{
  {
    init_simple_test("BFu16i_Sf_BFu7c");
    static BFu16i_Sf_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Sf_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu7c");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16i_Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu7c(Test_BFu16i_Sf_BFu7c, "BFu16i_Sf_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu7i  {
  unsigned int v1:16;
  ::empty v2;
  unsigned int v3:7;
};
//SIG(1 BFu16i_Sf_BFu7i) C1{ Fi:16 FC2{} Fi:7}



static void Test_BFu16i_Sf_BFu7i()
{
  {
    init_simple_test("BFu16i_Sf_BFu7i");
    static BFu16i_Sf_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Sf_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu7i");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16i_Sf_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu7i(Test_BFu16i_Sf_BFu7i, "BFu16i_Sf_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu7ll  {
  unsigned int v1:16;
  ::empty v2;
  __tsu64 v3:7;
};
//SIG(1 BFu16i_Sf_BFu7ll) C1{ Fi:16 FC2{} FL:7}



static void Test_BFu16i_Sf_BFu7ll()
{
  {
    init_simple_test("BFu16i_Sf_BFu7ll");
    static BFu16i_Sf_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16i_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16i_Sf_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu7ll(Test_BFu16i_Sf_BFu7ll, "BFu16i_Sf_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu7s  {
  unsigned int v1:16;
  ::empty v2;
  unsigned short v3:7;
};
//SIG(1 BFu16i_Sf_BFu7s) C1{ Fi:16 FC2{} Fs:7}



static void Test_BFu16i_Sf_BFu7s()
{
  {
    init_simple_test("BFu16i_Sf_BFu7s");
    static BFu16i_Sf_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Sf_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu7s");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16i_Sf_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu7s(Test_BFu16i_Sf_BFu7s, "BFu16i_Sf_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu8c  {
  unsigned int v1:16;
  ::empty v2;
  unsigned char v3:8;
};
//SIG(1 BFu16i_Sf_BFu8c) C1{ Fi:16 FC2{} Fc:8}



static void Test_BFu16i_Sf_BFu8c()
{
  {
    init_simple_test("BFu16i_Sf_BFu8c");
    static BFu16i_Sf_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Sf_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu8c");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16i_Sf_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu8c(Test_BFu16i_Sf_BFu8c, "BFu16i_Sf_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu8i  {
  unsigned int v1:16;
  ::empty v2;
  unsigned int v3:8;
};
//SIG(1 BFu16i_Sf_BFu8i) C1{ Fi:16 FC2{} Fi:8}



static void Test_BFu16i_Sf_BFu8i()
{
  {
    init_simple_test("BFu16i_Sf_BFu8i");
    static BFu16i_Sf_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Sf_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu8i");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16i_Sf_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16i_Sf_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu8i(Test_BFu16i_Sf_BFu8i, "BFu16i_Sf_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu8ll  {
  unsigned int v1:16;
  ::empty v2;
  __tsu64 v3:8;
};
//SIG(1 BFu16i_Sf_BFu8ll) C1{ Fi:16 FC2{} FL:8}



static void Test_BFu16i_Sf_BFu8ll()
{
  {
    init_simple_test("BFu16i_Sf_BFu8ll");
    static BFu16i_Sf_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16i_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16i_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16i_Sf_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu8ll(Test_BFu16i_Sf_BFu8ll, "BFu16i_Sf_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu8s  {
  unsigned int v1:16;
  ::empty v2;
  unsigned short v3:8;
};
//SIG(1 BFu16i_Sf_BFu8s) C1{ Fi:16 FC2{} Fs:8}



static void Test_BFu16i_Sf_BFu8s()
{
  {
    init_simple_test("BFu16i_Sf_BFu8s");
    static BFu16i_Sf_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Sf_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu8s");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16i_Sf_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16i_Sf_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu8s(Test_BFu16i_Sf_BFu8s, "BFu16i_Sf_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu9i  {
  unsigned int v1:16;
  ::empty v2;
  unsigned int v3:9;
};
//SIG(1 BFu16i_Sf_BFu9i) C1{ Fi:16 FC2{} Fi:9}



static void Test_BFu16i_Sf_BFu9i()
{
  {
    init_simple_test("BFu16i_Sf_BFu9i");
    static BFu16i_Sf_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu9i");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu16i_Sf_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu16i_Sf_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu9i(Test_BFu16i_Sf_BFu9i, "BFu16i_Sf_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu9ll  {
  unsigned int v1:16;
  ::empty v2;
  __tsu64 v3:9;
};
//SIG(1 BFu16i_Sf_BFu9ll) C1{ Fi:16 FC2{} FL:9}



static void Test_BFu16i_Sf_BFu9ll()
{
  {
    init_simple_test("BFu16i_Sf_BFu9ll");
    static BFu16i_Sf_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu16i_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu16i_Sf_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu9ll(Test_BFu16i_Sf_BFu9ll, "BFu16i_Sf_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_BFu9s  {
  unsigned int v1:16;
  ::empty v2;
  unsigned short v3:9;
};
//SIG(1 BFu16i_Sf_BFu9s) C1{ Fi:16 FC2{} Fs:9}



static void Test_BFu16i_Sf_BFu9s()
{
  {
    init_simple_test("BFu16i_Sf_BFu9s");
    static BFu16i_Sf_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_BFu9s");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu16i_Sf_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu16i_Sf_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_BFu9s(Test_BFu16i_Sf_BFu9s, "BFu16i_Sf_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_C  {
  unsigned int v1:16;
  ::empty v2;
  char v3;
};
//SIG(1 BFu16i_Sf_C) C1{ Fi:16 FC2{} Fc}



static void Test_BFu16i_Sf_C()
{
  {
    init_simple_test("BFu16i_Sf_C");
    static BFu16i_Sf_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Sf_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_C");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_C.v2");
    check_field_offset(lv, v3, 3, "BFu16i_Sf_C.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_C(Test_BFu16i_Sf_C, "BFu16i_Sf_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_D  {
  unsigned int v1:16;
  ::empty v2;
  double v3;
};
//SIG(1 BFu16i_Sf_D) C1{ Fi:16 FC2{} FL}



static void Test_BFu16i_Sf_D()
{
  {
    init_simple_test("BFu16i_Sf_D");
    static BFu16i_Sf_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu16i_Sf_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_D");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16i_Sf_D.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_D(Test_BFu16i_Sf_D, "BFu16i_Sf_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_F  {
  unsigned int v1:16;
  ::empty v2;
  float v3;
};
//SIG(1 BFu16i_Sf_F) C1{ Fi:16 FC2{} Fi}



static void Test_BFu16i_Sf_F()
{
  {
    init_simple_test("BFu16i_Sf_F");
    static BFu16i_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_F");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu16i_Sf_F.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_F(Test_BFu16i_Sf_F, "BFu16i_Sf_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_I  {
  unsigned int v1:16;
  ::empty v2;
  int v3;
};
//SIG(1 BFu16i_Sf_I) C1{ Fi:16 FC2{} Fi}



static void Test_BFu16i_Sf_I()
{
  {
    init_simple_test("BFu16i_Sf_I");
    static BFu16i_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_I");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu16i_Sf_I.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_I(Test_BFu16i_Sf_I, "BFu16i_Sf_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_Ip  {
  unsigned int v1:16;
  ::empty v2;
  int *v3;
};
//SIG(1 BFu16i_Sf_Ip) C1{ Fi:16 FC2{} Fp}



static void Test_BFu16i_Sf_Ip()
{
  {
    init_simple_test("BFu16i_Sf_Ip");
    static BFu16i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu16i_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_Ip");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16i_Sf_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_Ip(Test_BFu16i_Sf_Ip, "BFu16i_Sf_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_L  {
  unsigned int v1:16;
  ::empty v2;
  __tsi64 v3;
};
//SIG(1 BFu16i_Sf_L) C1{ Fi:16 FC2{} FL}



static void Test_BFu16i_Sf_L()
{
  {
    init_simple_test("BFu16i_Sf_L");
    static BFu16i_Sf_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu16i_Sf_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_L");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16i_Sf_L.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_L(Test_BFu16i_Sf_L, "BFu16i_Sf_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_S  {
  unsigned int v1:16;
  ::empty v2;
  short v3;
};
//SIG(1 BFu16i_Sf_S) C1{ Fi:16 FC2{} Fs}



static void Test_BFu16i_Sf_S()
{
  {
    init_simple_test("BFu16i_Sf_S");
    static BFu16i_Sf_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_S");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_S.v2");
    check_field_offset(lv, v3, 4, "BFu16i_Sf_S.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_S(Test_BFu16i_Sf_S, "BFu16i_Sf_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_Sf  {
  unsigned int v1:16;
  ::empty v2;
  ::empty v3;
};
//SIG(1 BFu16i_Sf_Sf) C1{ Fi:16 FC2{} FC2}



static void Test_BFu16i_Sf_Sf()
{
  {
    init_simple_test("BFu16i_Sf_Sf");
    static BFu16i_Sf_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Sf_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_Sf");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu16i_Sf_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_Sf(Test_BFu16i_Sf_Sf, "BFu16i_Sf_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_Uc  {
  unsigned int v1:16;
  ::empty v2;
  unsigned char v3;
};
//SIG(1 BFu16i_Sf_Uc) C1{ Fi:16 FC2{} Fc}



static void Test_BFu16i_Sf_Uc()
{
  {
    init_simple_test("BFu16i_Sf_Uc");
    static BFu16i_Sf_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Sf_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_Uc");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu16i_Sf_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_Uc(Test_BFu16i_Sf_Uc, "BFu16i_Sf_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_Ui  {
  unsigned int v1:16;
  ::empty v2;
  unsigned int v3;
};
//SIG(1 BFu16i_Sf_Ui) C1{ Fi:16 FC2{} Fi}



static void Test_BFu16i_Sf_Ui()
{
  {
    init_simple_test("BFu16i_Sf_Ui");
    static BFu16i_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_Ui");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu16i_Sf_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_Ui(Test_BFu16i_Sf_Ui, "BFu16i_Sf_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_Ul  {
  unsigned int v1:16;
  ::empty v2;
  __tsu64 v3;
};
//SIG(1 BFu16i_Sf_Ul) C1{ Fi:16 FC2{} FL}



static void Test_BFu16i_Sf_Ul()
{
  {
    init_simple_test("BFu16i_Sf_Ul");
    static BFu16i_Sf_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu16i_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_Ul");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16i_Sf_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_Ul(Test_BFu16i_Sf_Ul, "BFu16i_Sf_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_Us  {
  unsigned int v1:16;
  ::empty v2;
  unsigned short v3;
};
//SIG(1 BFu16i_Sf_Us) C1{ Fi:16 FC2{} Fs}



static void Test_BFu16i_Sf_Us()
{
  {
    init_simple_test("BFu16i_Sf_Us");
    static BFu16i_Sf_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Sf_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_Us");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_Us.v2");
    check_field_offset(lv, v3, 4, "BFu16i_Sf_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_Us(Test_BFu16i_Sf_Us, "BFu16i_Sf_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Sf_Vp  {
  unsigned int v1:16;
  ::empty v2;
  void *v3;
};
//SIG(1 BFu16i_Sf_Vp) C1{ Fi:16 FC2{} Fp}



static void Test_BFu16i_Sf_Vp()
{
  {
    init_simple_test("BFu16i_Sf_Vp");
    static BFu16i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu16i_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Sf_Vp");
    check_field_offset(lv, v2, 2, "BFu16i_Sf_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16i_Sf_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Sf_Vp(Test_BFu16i_Sf_Vp, "BFu16i_Sf_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Uc_Sf  {
  unsigned int v1:16;
  unsigned char v2;
  ::empty v3;
};
//SIG(1 BFu16i_Uc_Sf) C1{ Fi:16 Fc FC2{}}



static void Test_BFu16i_Uc_Sf()
{
  {
    init_simple_test("BFu16i_Uc_Sf");
    static BFu16i_Uc_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16i_Uc_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Uc_Sf");
    check_field_offset(lv, v2, 2, "BFu16i_Uc_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu16i_Uc_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Uc_Sf(Test_BFu16i_Uc_Sf, "BFu16i_Uc_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Ui_Sf  {
  unsigned int v1:16;
  unsigned int v2;
  ::empty v3;
};
//SIG(1 BFu16i_Ui_Sf) C1{ Fi:16 Fi FC2{}}



static void Test_BFu16i_Ui_Sf()
{
  {
    init_simple_test("BFu16i_Ui_Sf");
    static BFu16i_Ui_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu16i_Ui_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu16i_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu16i_Ui_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Ui_Sf(Test_BFu16i_Ui_Sf, "BFu16i_Ui_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Ul_Sf  {
  unsigned int v1:16;
  __tsu64 v2;
  ::empty v3;
};
//SIG(1 BFu16i_Ul_Sf) C1{ Fi:16 FL FC2{}}



static void Test_BFu16i_Ul_Sf()
{
  {
    init_simple_test("BFu16i_Ul_Sf");
    static BFu16i_Ul_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu16i_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Ul_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16i_Ul_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu16i_Ul_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Ul_Sf(Test_BFu16i_Ul_Sf, "BFu16i_Ul_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Us_Sf  {
  unsigned int v1:16;
  unsigned short v2;
  ::empty v3;
};
//SIG(1 BFu16i_Us_Sf) C1{ Fi:16 Fs FC2{}}



static void Test_BFu16i_Us_Sf()
{
  {
    init_simple_test("BFu16i_Us_Sf");
    static BFu16i_Us_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16i_Us_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16i_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Us_Sf");
    check_field_offset(lv, v2, 2, "BFu16i_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu16i_Us_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Us_Sf(Test_BFu16i_Us_Sf, "BFu16i_Us_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16i_Vp_Sf  {
  unsigned int v1:16;
  void *v2;
  ::empty v3;
};
//SIG(1 BFu16i_Vp_Sf) C1{ Fi:16 Fp FC2{}}



static void Test_BFu16i_Vp_Sf()
{
  {
    init_simple_test("BFu16i_Vp_Sf");
    static BFu16i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu16i_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16i_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16i_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16i_Vp_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16i_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu16i_Vp_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16i_Vp_Sf(Test_BFu16i_Vp_Sf, "BFu16i_Vp_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu15i_Sf  {
  __tsu64 v1:16;
  unsigned int v2:15;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu15i_Sf) C1{ FL:16 Fi:15 FC2{}}



static void Test_BFu16ll_BFu15i_Sf()
{
  {
    init_simple_test("BFu16ll_BFu15i_Sf");
    static BFu16ll_BFu15i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu15i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16ll_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu15i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu15i_Sf(Test_BFu16ll_BFu15i_Sf, "BFu16ll_BFu15i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu15ll_Sf  {
  __tsu64 v1:16;
  __tsu64 v2:15;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu15ll_Sf) C1{ FL:16 FL:15 FC2{}}



static void Test_BFu16ll_BFu15ll_Sf()
{
  {
    init_simple_test("BFu16ll_BFu15ll_Sf");
    static BFu16ll_BFu15ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16ll_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu15ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu15ll_Sf(Test_BFu16ll_BFu15ll_Sf, "BFu16ll_BFu15ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu15s_Sf  {
  __tsu64 v1:16;
  unsigned short v2:15;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu15s_Sf) C1{ FL:16 Fs:15 FC2{}}



static void Test_BFu16ll_BFu15s_Sf()
{
  {
    init_simple_test("BFu16ll_BFu15s_Sf");
    static BFu16ll_BFu15s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu15s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16ll_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu15s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu15s_Sf(Test_BFu16ll_BFu15s_Sf, "BFu16ll_BFu15s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu16i_Sf  {
  __tsu64 v1:16;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu16i_Sf) C1{ FL:16 Fi:16 FC2{}}



static void Test_BFu16ll_BFu16i_Sf()
{
  {
    init_simple_test("BFu16ll_BFu16i_Sf");
    static BFu16ll_BFu16i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu16i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu16i_Sf");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu16i_Sf(Test_BFu16ll_BFu16i_Sf, "BFu16ll_BFu16i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu16ll_Sf  {
  __tsu64 v1:16;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu16ll_Sf) C1{ FL:16 FL:16 FC2{}}



static void Test_BFu16ll_BFu16ll_Sf()
{
  {
    init_simple_test("BFu16ll_BFu16ll_Sf");
    static BFu16ll_BFu16ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu16ll_Sf");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu16ll_Sf(Test_BFu16ll_BFu16ll_Sf, "BFu16ll_BFu16ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu16s_Sf  {
  __tsu64 v1:16;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu16s_Sf) C1{ FL:16 Fs:16 FC2{}}



static void Test_BFu16ll_BFu16s_Sf()
{
  {
    init_simple_test("BFu16ll_BFu16s_Sf");
    static BFu16ll_BFu16s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu16s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu16s_Sf(Test_BFu16ll_BFu16s_Sf, "BFu16ll_BFu16s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu17i_Sf  {
  __tsu64 v1:16;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu17i_Sf) C1{ FL:16 Fi:17 FC2{}}



static void Test_BFu16ll_BFu17i_Sf()
{
  {
    init_simple_test("BFu16ll_BFu17i_Sf");
    static BFu16ll_BFu17i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu17i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu16ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu16ll_BFu17i_Sf");
    check_field_offset(lv, v3, 7, "BFu16ll_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu17i_Sf(Test_BFu16ll_BFu17i_Sf, "BFu16ll_BFu17i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu17ll_Sf  {
  __tsu64 v1:16;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu17ll_Sf) C1{ FL:16 FL:17 FC2{}}



static void Test_BFu16ll_BFu17ll_Sf()
{
  {
    init_simple_test("BFu16ll_BFu17ll_Sf");
    static BFu16ll_BFu17ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu16ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu16ll_BFu17ll_Sf");
    check_field_offset(lv, v3, 5, "BFu16ll_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu17ll_Sf(Test_BFu16ll_BFu17ll_Sf, "BFu16ll_BFu17ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu1c_Sf  {
  __tsu64 v1:16;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu1c_Sf) C1{ FL:16 Fc:1 FC2{}}



static void Test_BFu16ll_BFu1c_Sf()
{
  {
    init_simple_test("BFu16ll_BFu1c_Sf");
    static BFu16ll_BFu1c_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_BFu1c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu1c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16ll_BFu1c_Sf");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu1c_Sf(Test_BFu16ll_BFu1c_Sf, "BFu16ll_BFu1c_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu1i_Sf  {
  __tsu64 v1:16;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu1i_Sf) C1{ FL:16 Fi:1 FC2{}}



static void Test_BFu16ll_BFu1i_Sf()
{
  {
    init_simple_test("BFu16ll_BFu1i_Sf");
    static BFu16ll_BFu1i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_BFu1i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu1i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16ll_BFu1i_Sf");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu1i_Sf(Test_BFu16ll_BFu1i_Sf, "BFu16ll_BFu1i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu1ll_Sf  {
  __tsu64 v1:16;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu1ll_Sf) C1{ FL:16 FL:1 FC2{}}



static void Test_BFu16ll_BFu1ll_Sf()
{
  {
    init_simple_test("BFu16ll_BFu1ll_Sf");
    static BFu16ll_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16ll_BFu1ll_Sf");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu1ll_Sf(Test_BFu16ll_BFu1ll_Sf, "BFu16ll_BFu1ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu1s_Sf  {
  __tsu64 v1:16;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu1s_Sf) C1{ FL:16 Fs:1 FC2{}}



static void Test_BFu16ll_BFu1s_Sf()
{
  {
    init_simple_test("BFu16ll_BFu1s_Sf");
    static BFu16ll_BFu1s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_BFu1s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu1s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16ll_BFu1s_Sf");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu1s_Sf(Test_BFu16ll_BFu1s_Sf, "BFu16ll_BFu1s_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu31i_Sf  {
  __tsu64 v1:16;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu31i_Sf) C1{ FL:16 Fi:31 FC2{}}



static void Test_BFu16ll_BFu31i_Sf()
{
  {
    init_simple_test("BFu16ll_BFu31i_Sf");
    static BFu16ll_BFu31i_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu16ll_BFu31i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu16ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu16ll_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "BFu16ll_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu31i_Sf(Test_BFu16ll_BFu31i_Sf, "BFu16ll_BFu31i_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu31ll_Sf  {
  __tsu64 v1:16;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu31ll_Sf) C1{ FL:16 FL:31 FC2{}}



static void Test_BFu16ll_BFu31ll_Sf()
{
  {
    init_simple_test("BFu16ll_BFu31ll_Sf");
    static BFu16ll_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu16ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu16ll_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "BFu16ll_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu31ll_Sf(Test_BFu16ll_BFu31ll_Sf, "BFu16ll_BFu31ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu32i_Sf  {
  __tsu64 v1:16;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu32i_Sf) C1{ FL:16 Fi:32 FC2{}}



static void Test_BFu16ll_BFu32i_Sf()
{
  {
    init_simple_test("BFu16ll_BFu32i_Sf");
    static BFu16ll_BFu32i_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu16ll_BFu32i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu16ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu16ll_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu16ll_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu32i_Sf(Test_BFu16ll_BFu32i_Sf, "BFu16ll_BFu32i_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu32ll_Sf  {
  __tsu64 v1:16;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu32ll_Sf) C1{ FL:16 FL:32 FC2{}}



static void Test_BFu16ll_BFu32ll_Sf()
{
  {
    init_simple_test("BFu16ll_BFu32ll_Sf");
    static BFu16ll_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu16ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu16ll_BFu32ll_Sf");
    check_field_offset(lv, v3, 6, "BFu16ll_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu32ll_Sf(Test_BFu16ll_BFu32ll_Sf, "BFu16ll_BFu32ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu33_Sf  {
  __tsu64 v1:16;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu33_Sf) C1{ FL:16 FL:33 FC2{}}



static void Test_BFu16ll_BFu33_Sf()
{
  {
    init_simple_test("BFu16ll_BFu33_Sf");
    static BFu16ll_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu16ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu16ll_BFu33_Sf");
    check_field_offset(lv, v3, 7, "BFu16ll_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu33_Sf(Test_BFu16ll_BFu33_Sf, "BFu16ll_BFu33_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu7c_Sf  {
  __tsu64 v1:16;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu7c_Sf) C1{ FL:16 Fc:7 FC2{}}



static void Test_BFu16ll_BFu7c_Sf()
{
  {
    init_simple_test("BFu16ll_BFu7c_Sf");
    static BFu16ll_BFu7c_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_BFu7c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16ll_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu7c_Sf(Test_BFu16ll_BFu7c_Sf, "BFu16ll_BFu7c_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu7i_Sf  {
  __tsu64 v1:16;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu7i_Sf) C1{ FL:16 Fi:7 FC2{}}



static void Test_BFu16ll_BFu7i_Sf()
{
  {
    init_simple_test("BFu16ll_BFu7i_Sf");
    static BFu16ll_BFu7i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_BFu7i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16ll_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu7i_Sf(Test_BFu16ll_BFu7i_Sf, "BFu16ll_BFu7i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu7ll_Sf  {
  __tsu64 v1:16;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu7ll_Sf) C1{ FL:16 FL:7 FC2{}}



static void Test_BFu16ll_BFu7ll_Sf()
{
  {
    init_simple_test("BFu16ll_BFu7ll_Sf");
    static BFu16ll_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16ll_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu7ll_Sf(Test_BFu16ll_BFu7ll_Sf, "BFu16ll_BFu7ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu7s_Sf  {
  __tsu64 v1:16;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu7s_Sf) C1{ FL:16 Fs:7 FC2{}}



static void Test_BFu16ll_BFu7s_Sf()
{
  {
    init_simple_test("BFu16ll_BFu7s_Sf");
    static BFu16ll_BFu7s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_BFu7s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16ll_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu7s_Sf(Test_BFu16ll_BFu7s_Sf, "BFu16ll_BFu7s_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu8c_Sf  {
  __tsu64 v1:16;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu8c_Sf) C1{ FL:16 Fc:8 FC2{}}



static void Test_BFu16ll_BFu8c_Sf()
{
  {
    init_simple_test("BFu16ll_BFu8c_Sf");
    static BFu16ll_BFu8c_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_BFu8c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16ll_BFu8c_Sf");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu8c_Sf(Test_BFu16ll_BFu8c_Sf, "BFu16ll_BFu8c_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu8i_Sf  {
  __tsu64 v1:16;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu8i_Sf) C1{ FL:16 Fi:8 FC2{}}



static void Test_BFu16ll_BFu8i_Sf()
{
  {
    init_simple_test("BFu16ll_BFu8i_Sf");
    static BFu16ll_BFu8i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_BFu8i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16ll_BFu8i_Sf");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu8i_Sf(Test_BFu16ll_BFu8i_Sf, "BFu16ll_BFu8i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu8ll_Sf  {
  __tsu64 v1:16;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu8ll_Sf) C1{ FL:16 FL:8 FC2{}}



static void Test_BFu16ll_BFu8ll_Sf()
{
  {
    init_simple_test("BFu16ll_BFu8ll_Sf");
    static BFu16ll_BFu8ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16ll_BFu8ll_Sf");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu8ll_Sf(Test_BFu16ll_BFu8ll_Sf, "BFu16ll_BFu8ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu8s_Sf  {
  __tsu64 v1:16;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu8s_Sf) C1{ FL:16 Fs:8 FC2{}}



static void Test_BFu16ll_BFu8s_Sf()
{
  {
    init_simple_test("BFu16ll_BFu8s_Sf");
    static BFu16ll_BFu8s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_BFu8s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16ll_BFu8s_Sf");
    check_field_offset(lv, v3, 3, "BFu16ll_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu8s_Sf(Test_BFu16ll_BFu8s_Sf, "BFu16ll_BFu8s_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu9i_Sf  {
  __tsu64 v1:16;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu9i_Sf) C1{ FL:16 Fi:9 FC2{}}



static void Test_BFu16ll_BFu9i_Sf()
{
  {
    init_simple_test("BFu16ll_BFu9i_Sf");
    static BFu16ll_BFu9i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu9i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu16ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu16ll_BFu9i_Sf");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu9i_Sf(Test_BFu16ll_BFu9i_Sf, "BFu16ll_BFu9i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu9ll_Sf  {
  __tsu64 v1:16;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu9ll_Sf) C1{ FL:16 FL:9 FC2{}}



static void Test_BFu16ll_BFu9ll_Sf()
{
  {
    init_simple_test("BFu16ll_BFu9ll_Sf");
    static BFu16ll_BFu9ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu16ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu16ll_BFu9ll_Sf");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu9ll_Sf(Test_BFu16ll_BFu9ll_Sf, "BFu16ll_BFu9ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_BFu9s_Sf  {
  __tsu64 v1:16;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 BFu16ll_BFu9s_Sf) C1{ FL:16 Fs:9 FC2{}}



static void Test_BFu16ll_BFu9s_Sf()
{
  {
    init_simple_test("BFu16ll_BFu9s_Sf");
    static BFu16ll_BFu9s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_BFu9s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu16ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu16ll_BFu9s_Sf");
    check_field_offset(lv, v3, 4, "BFu16ll_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_BFu9s_Sf(Test_BFu16ll_BFu9s_Sf, "BFu16ll_BFu9s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_C_Sf  {
  __tsu64 v1:16;
  char v2;
  ::empty v3;
};
//SIG(1 BFu16ll_C_Sf) C1{ FL:16 Fc FC2{}}



static void Test_BFu16ll_C_Sf()
{
  {
    init_simple_test("BFu16ll_C_Sf");
    static BFu16ll_C_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_C_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_C_Sf");
    check_field_offset(lv, v2, 2, "BFu16ll_C_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_C_Sf(Test_BFu16ll_C_Sf, "BFu16ll_C_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_D_Sf  {
  __tsu64 v1:16;
  double v2;
  ::empty v3;
};
//SIG(1 BFu16ll_D_Sf) C1{ FL:16 FL FC2{}}



static void Test_BFu16ll_D_Sf()
{
  {
    init_simple_test("BFu16ll_D_Sf");
    static BFu16ll_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu16ll_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_D_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16ll_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu16ll_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_D_Sf(Test_BFu16ll_D_Sf, "BFu16ll_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_F_Sf  {
  __tsu64 v1:16;
  float v2;
  ::empty v3;
};
//SIG(1 BFu16ll_F_Sf) C1{ FL:16 Fi FC2{}}



static void Test_BFu16ll_F_Sf()
{
  {
    init_simple_test("BFu16ll_F_Sf");
    static BFu16ll_F_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu16ll_F_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_F_Sf");
    check_field_offset(lv, v2, 4, "BFu16ll_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu16ll_F_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_F_Sf(Test_BFu16ll_F_Sf, "BFu16ll_F_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_I_Sf  {
  __tsu64 v1:16;
  int v2;
  ::empty v3;
};
//SIG(1 BFu16ll_I_Sf) C1{ FL:16 Fi FC2{}}



static void Test_BFu16ll_I_Sf()
{
  {
    init_simple_test("BFu16ll_I_Sf");
    static BFu16ll_I_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu16ll_I_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_I_Sf");
    check_field_offset(lv, v2, 4, "BFu16ll_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu16ll_I_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_I_Sf(Test_BFu16ll_I_Sf, "BFu16ll_I_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Ip_Sf  {
  __tsu64 v1:16;
  int *v2;
  ::empty v3;
};
//SIG(1 BFu16ll_Ip_Sf) C1{ FL:16 Fp FC2{}}



static void Test_BFu16ll_Ip_Sf()
{
  {
    init_simple_test("BFu16ll_Ip_Sf");
    static BFu16ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu16ll_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Ip_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16ll_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu16ll_Ip_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Ip_Sf(Test_BFu16ll_Ip_Sf, "BFu16ll_Ip_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_L_Sf  {
  __tsu64 v1:16;
  __tsi64 v2;
  ::empty v3;
};
//SIG(1 BFu16ll_L_Sf) C1{ FL:16 FL FC2{}}



static void Test_BFu16ll_L_Sf()
{
  {
    init_simple_test("BFu16ll_L_Sf");
    static BFu16ll_L_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu16ll_L_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_L_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16ll_L_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu16ll_L_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_L_Sf(Test_BFu16ll_L_Sf, "BFu16ll_L_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_S_Sf  {
  __tsu64 v1:16;
  short v2;
  ::empty v3;
};
//SIG(1 BFu16ll_S_Sf) C1{ FL:16 Fs FC2{}}



static void Test_BFu16ll_S_Sf()
{
  {
    init_simple_test("BFu16ll_S_Sf");
    static BFu16ll_S_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_S_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_S_Sf");
    check_field_offset(lv, v2, 2, "BFu16ll_S_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu16ll_S_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_S_Sf(Test_BFu16ll_S_Sf, "BFu16ll_S_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf  {
  __tsu64 v1:16;
  ::empty v2;
};
//SIG(1 BFu16ll_Sf) C1{ FL:16 FC2{}}



static void Test_BFu16ll_Sf()
{
  {
    init_simple_test("BFu16ll_Sf");
    static BFu16ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf.v2");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf(Test_BFu16ll_Sf, "BFu16ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu15i  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned int v3:15;
};
//SIG(1 BFu16ll_Sf_BFu15i) C1{ FL:16 FC2{} Fi:15}



static void Test_BFu16ll_Sf_BFu15i()
{
  {
    init_simple_test("BFu16ll_Sf_BFu15i");
    static BFu16ll_Sf_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu15i");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu16ll_Sf_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu16ll_Sf_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu15i(Test_BFu16ll_Sf_BFu15i, "BFu16ll_Sf_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu15ll  {
  __tsu64 v1:16;
  ::empty v2;
  __tsu64 v3:15;
};
//SIG(1 BFu16ll_Sf_BFu15ll) C1{ FL:16 FC2{} FL:15}



static void Test_BFu16ll_Sf_BFu15ll()
{
  {
    init_simple_test("BFu16ll_Sf_BFu15ll");
    static BFu16ll_Sf_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu16ll_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu16ll_Sf_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu15ll(Test_BFu16ll_Sf_BFu15ll, "BFu16ll_Sf_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu15s  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned short v3:15;
};
//SIG(1 BFu16ll_Sf_BFu15s) C1{ FL:16 FC2{} Fs:15}



static void Test_BFu16ll_Sf_BFu15s()
{
  {
    init_simple_test("BFu16ll_Sf_BFu15s");
    static BFu16ll_Sf_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu15s");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu16ll_Sf_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu16ll_Sf_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu15s(Test_BFu16ll_Sf_BFu15s, "BFu16ll_Sf_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu16i  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned int v3:16;
};
//SIG(1 BFu16ll_Sf_BFu16i) C1{ FL:16 FC2{} Fi:16}



static void Test_BFu16ll_Sf_BFu16i()
{
  {
    init_simple_test("BFu16ll_Sf_BFu16i");
    static BFu16ll_Sf_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu16i");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu16ll_Sf_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu16i(Test_BFu16ll_Sf_BFu16i, "BFu16ll_Sf_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu16ll  {
  __tsu64 v1:16;
  ::empty v2;
  __tsu64 v3:16;
};
//SIG(1 BFu16ll_Sf_BFu16ll) C1{ FL:16 FC2{} FL:16}



static void Test_BFu16ll_Sf_BFu16ll()
{
  {
    init_simple_test("BFu16ll_Sf_BFu16ll");
    static BFu16ll_Sf_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu16ll_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu16ll(Test_BFu16ll_Sf_BFu16ll, "BFu16ll_Sf_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu16s  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned short v3:16;
};
//SIG(1 BFu16ll_Sf_BFu16s) C1{ FL:16 FC2{} Fs:16}



static void Test_BFu16ll_Sf_BFu16s()
{
  {
    init_simple_test("BFu16ll_Sf_BFu16s");
    static BFu16ll_Sf_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu16s");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu16ll_Sf_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu16s(Test_BFu16ll_Sf_BFu16s, "BFu16ll_Sf_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu17i  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned int v3:17;
};
//SIG(1 BFu16ll_Sf_BFu17i) C1{ FL:16 FC2{} Fi:17}



static void Test_BFu16ll_Sf_BFu17i()
{
  {
    init_simple_test("BFu16ll_Sf_BFu17i");
    static BFu16ll_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu17i");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu16ll_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu16ll_Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu17i(Test_BFu16ll_Sf_BFu17i, "BFu16ll_Sf_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu17ll  {
  __tsu64 v1:16;
  ::empty v2;
  __tsu64 v3:17;
};
//SIG(1 BFu16ll_Sf_BFu17ll) C1{ FL:16 FC2{} FL:17}



static void Test_BFu16ll_Sf_BFu17ll()
{
  {
    init_simple_test("BFu16ll_Sf_BFu17ll");
    static BFu16ll_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu16ll_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu16ll_Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu17ll(Test_BFu16ll_Sf_BFu17ll, "BFu16ll_Sf_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu1c  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned char v3:1;
};
//SIG(1 BFu16ll_Sf_BFu1c) C1{ FL:16 FC2{} Fc:1}



static void Test_BFu16ll_Sf_BFu1c()
{
  {
    init_simple_test("BFu16ll_Sf_BFu1c");
    static BFu16ll_Sf_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu1c");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16ll_Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu1c(Test_BFu16ll_Sf_BFu1c, "BFu16ll_Sf_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu1i  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned int v3:1;
};
//SIG(1 BFu16ll_Sf_BFu1i) C1{ FL:16 FC2{} Fi:1}



static void Test_BFu16ll_Sf_BFu1i()
{
  {
    init_simple_test("BFu16ll_Sf_BFu1i");
    static BFu16ll_Sf_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu1i");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16ll_Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu1i(Test_BFu16ll_Sf_BFu1i, "BFu16ll_Sf_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu1ll  {
  __tsu64 v1:16;
  ::empty v2;
  __tsu64 v3:1;
};
//SIG(1 BFu16ll_Sf_BFu1ll) C1{ FL:16 FC2{} FL:1}



static void Test_BFu16ll_Sf_BFu1ll()
{
  {
    init_simple_test("BFu16ll_Sf_BFu1ll");
    static BFu16ll_Sf_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16ll_Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu1ll(Test_BFu16ll_Sf_BFu1ll, "BFu16ll_Sf_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu1s  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned short v3:1;
};
//SIG(1 BFu16ll_Sf_BFu1s) C1{ FL:16 FC2{} Fs:1}



static void Test_BFu16ll_Sf_BFu1s()
{
  {
    init_simple_test("BFu16ll_Sf_BFu1s");
    static BFu16ll_Sf_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu1s");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16ll_Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu1s(Test_BFu16ll_Sf_BFu1s, "BFu16ll_Sf_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu31i  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned int v3:31;
};
//SIG(1 BFu16ll_Sf_BFu31i) C1{ FL:16 FC2{} Fi:31}



static void Test_BFu16ll_Sf_BFu31i()
{
  {
    init_simple_test("BFu16ll_Sf_BFu31i");
    static BFu16ll_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu31i");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu16ll_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu16ll_Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu31i(Test_BFu16ll_Sf_BFu31i, "BFu16ll_Sf_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu31ll  {
  __tsu64 v1:16;
  ::empty v2;
  __tsu64 v3:31;
};
//SIG(1 BFu16ll_Sf_BFu31ll) C1{ FL:16 FC2{} FL:31}



static void Test_BFu16ll_Sf_BFu31ll()
{
  {
    init_simple_test("BFu16ll_Sf_BFu31ll");
    static BFu16ll_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu16ll_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu16ll_Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu31ll(Test_BFu16ll_Sf_BFu31ll, "BFu16ll_Sf_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu32i  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned int v3:32;
};
//SIG(1 BFu16ll_Sf_BFu32i) C1{ FL:16 FC2{} Fi:32}



static void Test_BFu16ll_Sf_BFu32i()
{
  {
    init_simple_test("BFu16ll_Sf_BFu32i");
    static BFu16ll_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu32i");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu16ll_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu16ll_Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu32i(Test_BFu16ll_Sf_BFu32i, "BFu16ll_Sf_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu32ll  {
  __tsu64 v1:16;
  ::empty v2;
  __tsu64 v3:32;
};
//SIG(1 BFu16ll_Sf_BFu32ll) C1{ FL:16 FC2{} FL:32}



static void Test_BFu16ll_Sf_BFu32ll()
{
  {
    init_simple_test("BFu16ll_Sf_BFu32ll");
    static BFu16ll_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu16ll_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu16ll_Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu32ll(Test_BFu16ll_Sf_BFu32ll, "BFu16ll_Sf_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu33  {
  __tsu64 v1:16;
  ::empty v2;
  __tsu64 v3:33;
};
//SIG(1 BFu16ll_Sf_BFu33) C1{ FL:16 FC2{} FL:33}



static void Test_BFu16ll_Sf_BFu33()
{
  {
    init_simple_test("BFu16ll_Sf_BFu33");
    static BFu16ll_Sf_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu33");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu16ll_Sf_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu16ll_Sf_BFu33");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu33(Test_BFu16ll_Sf_BFu33, "BFu16ll_Sf_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu7c  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned char v3:7;
};
//SIG(1 BFu16ll_Sf_BFu7c) C1{ FL:16 FC2{} Fc:7}



static void Test_BFu16ll_Sf_BFu7c()
{
  {
    init_simple_test("BFu16ll_Sf_BFu7c");
    static BFu16ll_Sf_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu7c");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16ll_Sf_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16ll_Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu7c(Test_BFu16ll_Sf_BFu7c, "BFu16ll_Sf_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu7i  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned int v3:7;
};
//SIG(1 BFu16ll_Sf_BFu7i) C1{ FL:16 FC2{} Fi:7}



static void Test_BFu16ll_Sf_BFu7i()
{
  {
    init_simple_test("BFu16ll_Sf_BFu7i");
    static BFu16ll_Sf_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu7i");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16ll_Sf_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16ll_Sf_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu7i(Test_BFu16ll_Sf_BFu7i, "BFu16ll_Sf_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu7ll  {
  __tsu64 v1:16;
  ::empty v2;
  __tsu64 v3:7;
};
//SIG(1 BFu16ll_Sf_BFu7ll) C1{ FL:16 FC2{} FL:7}



static void Test_BFu16ll_Sf_BFu7ll()
{
  {
    init_simple_test("BFu16ll_Sf_BFu7ll");
    static BFu16ll_Sf_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16ll_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16ll_Sf_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu7ll(Test_BFu16ll_Sf_BFu7ll, "BFu16ll_Sf_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu7s  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned short v3:7;
};
//SIG(1 BFu16ll_Sf_BFu7s) C1{ FL:16 FC2{} Fs:7}



static void Test_BFu16ll_Sf_BFu7s()
{
  {
    init_simple_test("BFu16ll_Sf_BFu7s");
    static BFu16ll_Sf_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu7s");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16ll_Sf_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16ll_Sf_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu7s(Test_BFu16ll_Sf_BFu7s, "BFu16ll_Sf_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu8c  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned char v3:8;
};
//SIG(1 BFu16ll_Sf_BFu8c) C1{ FL:16 FC2{} Fc:8}



static void Test_BFu16ll_Sf_BFu8c()
{
  {
    init_simple_test("BFu16ll_Sf_BFu8c");
    static BFu16ll_Sf_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu8c");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16ll_Sf_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16ll_Sf_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu8c(Test_BFu16ll_Sf_BFu8c, "BFu16ll_Sf_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu8i  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned int v3:8;
};
//SIG(1 BFu16ll_Sf_BFu8i) C1{ FL:16 FC2{} Fi:8}



static void Test_BFu16ll_Sf_BFu8i()
{
  {
    init_simple_test("BFu16ll_Sf_BFu8i");
    static BFu16ll_Sf_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu8i");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16ll_Sf_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16ll_Sf_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu8i(Test_BFu16ll_Sf_BFu8i, "BFu16ll_Sf_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu8ll  {
  __tsu64 v1:16;
  ::empty v2;
  __tsu64 v3:8;
};
//SIG(1 BFu16ll_Sf_BFu8ll) C1{ FL:16 FC2{} FL:8}



static void Test_BFu16ll_Sf_BFu8ll()
{
  {
    init_simple_test("BFu16ll_Sf_BFu8ll");
    static BFu16ll_Sf_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16ll_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16ll_Sf_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu8ll(Test_BFu16ll_Sf_BFu8ll, "BFu16ll_Sf_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu8s  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned short v3:8;
};
//SIG(1 BFu16ll_Sf_BFu8s) C1{ FL:16 FC2{} Fs:8}



static void Test_BFu16ll_Sf_BFu8s()
{
  {
    init_simple_test("BFu16ll_Sf_BFu8s");
    static BFu16ll_Sf_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu8s");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16ll_Sf_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16ll_Sf_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu8s(Test_BFu16ll_Sf_BFu8s, "BFu16ll_Sf_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu9i  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned int v3:9;
};
//SIG(1 BFu16ll_Sf_BFu9i) C1{ FL:16 FC2{} Fi:9}



static void Test_BFu16ll_Sf_BFu9i()
{
  {
    init_simple_test("BFu16ll_Sf_BFu9i");
    static BFu16ll_Sf_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu9i");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu16ll_Sf_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu16ll_Sf_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu9i(Test_BFu16ll_Sf_BFu9i, "BFu16ll_Sf_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu9ll  {
  __tsu64 v1:16;
  ::empty v2;
  __tsu64 v3:9;
};
//SIG(1 BFu16ll_Sf_BFu9ll) C1{ FL:16 FC2{} FL:9}



static void Test_BFu16ll_Sf_BFu9ll()
{
  {
    init_simple_test("BFu16ll_Sf_BFu9ll");
    static BFu16ll_Sf_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu16ll_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu16ll_Sf_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu9ll(Test_BFu16ll_Sf_BFu9ll, "BFu16ll_Sf_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_BFu9s  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned short v3:9;
};
//SIG(1 BFu16ll_Sf_BFu9s) C1{ FL:16 FC2{} Fs:9}



static void Test_BFu16ll_Sf_BFu9s()
{
  {
    init_simple_test("BFu16ll_Sf_BFu9s");
    static BFu16ll_Sf_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_BFu9s");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu16ll_Sf_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu16ll_Sf_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_BFu9s(Test_BFu16ll_Sf_BFu9s, "BFu16ll_Sf_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_C  {
  __tsu64 v1:16;
  ::empty v2;
  char v3;
};
//SIG(1 BFu16ll_Sf_C) C1{ FL:16 FC2{} Fc}



static void Test_BFu16ll_Sf_C()
{
  {
    init_simple_test("BFu16ll_Sf_C");
    static BFu16ll_Sf_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_C");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_C.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_Sf_C.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_C(Test_BFu16ll_Sf_C, "BFu16ll_Sf_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_D  {
  __tsu64 v1:16;
  ::empty v2;
  double v3;
};
//SIG(1 BFu16ll_Sf_D) C1{ FL:16 FC2{} FL}



static void Test_BFu16ll_Sf_D()
{
  {
    init_simple_test("BFu16ll_Sf_D");
    static BFu16ll_Sf_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu16ll_Sf_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_D");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16ll_Sf_D.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_D(Test_BFu16ll_Sf_D, "BFu16ll_Sf_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_F  {
  __tsu64 v1:16;
  ::empty v2;
  float v3;
};
//SIG(1 BFu16ll_Sf_F) C1{ FL:16 FC2{} Fi}



static void Test_BFu16ll_Sf_F()
{
  {
    init_simple_test("BFu16ll_Sf_F");
    static BFu16ll_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_F");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu16ll_Sf_F.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_F(Test_BFu16ll_Sf_F, "BFu16ll_Sf_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_I  {
  __tsu64 v1:16;
  ::empty v2;
  int v3;
};
//SIG(1 BFu16ll_Sf_I) C1{ FL:16 FC2{} Fi}



static void Test_BFu16ll_Sf_I()
{
  {
    init_simple_test("BFu16ll_Sf_I");
    static BFu16ll_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_I");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu16ll_Sf_I.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_I(Test_BFu16ll_Sf_I, "BFu16ll_Sf_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_Ip  {
  __tsu64 v1:16;
  ::empty v2;
  int *v3;
};
//SIG(1 BFu16ll_Sf_Ip) C1{ FL:16 FC2{} Fp}



static void Test_BFu16ll_Sf_Ip()
{
  {
    init_simple_test("BFu16ll_Sf_Ip");
    static BFu16ll_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu16ll_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_Ip");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16ll_Sf_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_Ip(Test_BFu16ll_Sf_Ip, "BFu16ll_Sf_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_L  {
  __tsu64 v1:16;
  ::empty v2;
  __tsi64 v3;
};
//SIG(1 BFu16ll_Sf_L) C1{ FL:16 FC2{} FL}



static void Test_BFu16ll_Sf_L()
{
  {
    init_simple_test("BFu16ll_Sf_L");
    static BFu16ll_Sf_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu16ll_Sf_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_L");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16ll_Sf_L.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_L(Test_BFu16ll_Sf_L, "BFu16ll_Sf_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_S  {
  __tsu64 v1:16;
  ::empty v2;
  short v3;
};
//SIG(1 BFu16ll_Sf_S) C1{ FL:16 FC2{} Fs}



static void Test_BFu16ll_Sf_S()
{
  {
    init_simple_test("BFu16ll_Sf_S");
    static BFu16ll_Sf_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_S");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_S.v2");
    check_field_offset(lv, v3, 4, "BFu16ll_Sf_S.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_S(Test_BFu16ll_Sf_S, "BFu16ll_Sf_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_Sf  {
  __tsu64 v1:16;
  ::empty v2;
  ::empty v3;
};
//SIG(1 BFu16ll_Sf_Sf) C1{ FL:16 FC2{} FC2}



static void Test_BFu16ll_Sf_Sf()
{
  {
    init_simple_test("BFu16ll_Sf_Sf");
    static BFu16ll_Sf_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_Sf");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_Sf_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_Sf(Test_BFu16ll_Sf_Sf, "BFu16ll_Sf_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_Uc  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned char v3;
};
//SIG(1 BFu16ll_Sf_Uc) C1{ FL:16 FC2{} Fc}



static void Test_BFu16ll_Sf_Uc()
{
  {
    init_simple_test("BFu16ll_Sf_Uc");
    static BFu16ll_Sf_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Sf_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_Uc");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_Sf_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_Uc(Test_BFu16ll_Sf_Uc, "BFu16ll_Sf_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_Ui  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned int v3;
};
//SIG(1 BFu16ll_Sf_Ui) C1{ FL:16 FC2{} Fi}



static void Test_BFu16ll_Sf_Ui()
{
  {
    init_simple_test("BFu16ll_Sf_Ui");
    static BFu16ll_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_Ui");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu16ll_Sf_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_Ui(Test_BFu16ll_Sf_Ui, "BFu16ll_Sf_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_Ul  {
  __tsu64 v1:16;
  ::empty v2;
  __tsu64 v3;
};
//SIG(1 BFu16ll_Sf_Ul) C1{ FL:16 FC2{} FL}



static void Test_BFu16ll_Sf_Ul()
{
  {
    init_simple_test("BFu16ll_Sf_Ul");
    static BFu16ll_Sf_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu16ll_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_Ul");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16ll_Sf_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_Ul(Test_BFu16ll_Sf_Ul, "BFu16ll_Sf_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_Us  {
  __tsu64 v1:16;
  ::empty v2;
  unsigned short v3;
};
//SIG(1 BFu16ll_Sf_Us) C1{ FL:16 FC2{} Fs}



static void Test_BFu16ll_Sf_Us()
{
  {
    init_simple_test("BFu16ll_Sf_Us");
    static BFu16ll_Sf_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Sf_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_Us");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_Us.v2");
    check_field_offset(lv, v3, 4, "BFu16ll_Sf_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_Us(Test_BFu16ll_Sf_Us, "BFu16ll_Sf_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Sf_Vp  {
  __tsu64 v1:16;
  ::empty v2;
  void *v3;
};
//SIG(1 BFu16ll_Sf_Vp) C1{ FL:16 FC2{} Fp}



static void Test_BFu16ll_Sf_Vp()
{
  {
    init_simple_test("BFu16ll_Sf_Vp");
    static BFu16ll_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu16ll_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Sf_Vp");
    check_field_offset(lv, v2, 2, "BFu16ll_Sf_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16ll_Sf_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Sf_Vp(Test_BFu16ll_Sf_Vp, "BFu16ll_Sf_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Uc_Sf  {
  __tsu64 v1:16;
  unsigned char v2;
  ::empty v3;
};
//SIG(1 BFu16ll_Uc_Sf) C1{ FL:16 Fc FC2{}}



static void Test_BFu16ll_Uc_Sf()
{
  {
    init_simple_test("BFu16ll_Uc_Sf");
    static BFu16ll_Uc_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16ll_Uc_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Uc_Sf");
    check_field_offset(lv, v2, 2, "BFu16ll_Uc_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu16ll_Uc_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Uc_Sf(Test_BFu16ll_Uc_Sf, "BFu16ll_Uc_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Ui_Sf  {
  __tsu64 v1:16;
  unsigned int v2;
  ::empty v3;
};
//SIG(1 BFu16ll_Ui_Sf) C1{ FL:16 Fi FC2{}}



static void Test_BFu16ll_Ui_Sf()
{
  {
    init_simple_test("BFu16ll_Ui_Sf");
    static BFu16ll_Ui_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu16ll_Ui_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu16ll_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu16ll_Ui_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Ui_Sf(Test_BFu16ll_Ui_Sf, "BFu16ll_Ui_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Ul_Sf  {
  __tsu64 v1:16;
  __tsu64 v2;
  ::empty v3;
};
//SIG(1 BFu16ll_Ul_Sf) C1{ FL:16 FL FC2{}}



static void Test_BFu16ll_Ul_Sf()
{
  {
    init_simple_test("BFu16ll_Ul_Sf");
    static BFu16ll_Ul_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu16ll_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Ul_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16ll_Ul_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu16ll_Ul_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Ul_Sf(Test_BFu16ll_Ul_Sf, "BFu16ll_Ul_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Us_Sf  {
  __tsu64 v1:16;
  unsigned short v2;
  ::empty v3;
};
//SIG(1 BFu16ll_Us_Sf) C1{ FL:16 Fs FC2{}}



static void Test_BFu16ll_Us_Sf()
{
  {
    init_simple_test("BFu16ll_Us_Sf");
    static BFu16ll_Us_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16ll_Us_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Us_Sf");
    check_field_offset(lv, v2, 2, "BFu16ll_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu16ll_Us_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Us_Sf(Test_BFu16ll_Us_Sf, "BFu16ll_Us_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16ll_Vp_Sf  {
  __tsu64 v1:16;
  void *v2;
  ::empty v3;
};
//SIG(1 BFu16ll_Vp_Sf) C1{ FL:16 Fp FC2{}}



static void Test_BFu16ll_Vp_Sf()
{
  {
    init_simple_test("BFu16ll_Vp_Sf");
    static BFu16ll_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu16ll_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16ll_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16ll_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16ll_Vp_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16ll_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu16ll_Vp_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16ll_Vp_Sf(Test_BFu16ll_Vp_Sf, "BFu16ll_Vp_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu15i_Sf  {
  unsigned short v1:16;
  unsigned int v2:15;
  ::empty v3;
};
//SIG(1 BFu16s_BFu15i_Sf) C1{ Fs:16 Fi:15 FC2{}}



static void Test_BFu16s_BFu15i_Sf()
{
  {
    init_simple_test("BFu16s_BFu15i_Sf");
    static BFu16s_BFu15i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_BFu15i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16s_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "BFu16s_BFu15i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu15i_Sf(Test_BFu16s_BFu15i_Sf, "BFu16s_BFu15i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu15ll_Sf  {
  unsigned short v1:16;
  __tsu64 v2:15;
  ::empty v3;
};
//SIG(1 BFu16s_BFu15ll_Sf) C1{ Fs:16 FL:15 FC2{}}



static void Test_BFu16s_BFu15ll_Sf()
{
  {
    init_simple_test("BFu16s_BFu15ll_Sf");
    static BFu16s_BFu15ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16s_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "BFu16s_BFu15ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu15ll_Sf(Test_BFu16s_BFu15ll_Sf, "BFu16s_BFu15ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu15s_Sf  {
  unsigned short v1:16;
  unsigned short v2:15;
  ::empty v3;
};
//SIG(1 BFu16s_BFu15s_Sf) C1{ Fs:16 Fs:15 FC2{}}



static void Test_BFu16s_BFu15s_Sf()
{
  {
    init_simple_test("BFu16s_BFu15s_Sf");
    static BFu16s_BFu15s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu16s_BFu15s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "BFu16s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "BFu16s_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "BFu16s_BFu15s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu15s_Sf(Test_BFu16s_BFu15s_Sf, "BFu16s_BFu15s_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu16i_Sf  {
  unsigned short v1:16;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 BFu16s_BFu16i_Sf) C1{ Fs:16 Fi:16 FC2{}}



static void Test_BFu16s_BFu16i_Sf()
{
  {
    init_simple_test("BFu16s_BFu16i_Sf");
    static BFu16s_BFu16i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_BFu16i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu16i_Sf");
    check_field_offset(lv, v3, 4, "BFu16s_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu16i_Sf(Test_BFu16s_BFu16i_Sf, "BFu16s_BFu16i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu16ll_Sf  {
  unsigned short v1:16;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 BFu16s_BFu16ll_Sf) C1{ Fs:16 FL:16 FC2{}}



static void Test_BFu16s_BFu16ll_Sf()
{
  {
    init_simple_test("BFu16s_BFu16ll_Sf");
    static BFu16s_BFu16ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu16ll_Sf");
    check_field_offset(lv, v3, 4, "BFu16s_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu16ll_Sf(Test_BFu16s_BFu16ll_Sf, "BFu16s_BFu16ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu16s_Sf  {
  unsigned short v1:16;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 BFu16s_BFu16s_Sf) C1{ Fs:16 Fs:16 FC2{}}



static void Test_BFu16s_BFu16s_Sf()
{
  {
    init_simple_test("BFu16s_BFu16s_Sf");
    static BFu16s_BFu16s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu16s_BFu16s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu16s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "BFu16s_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu16s_Sf(Test_BFu16s_BFu16s_Sf, "BFu16s_BFu16s_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu17i_Sf  {
  unsigned short v1:16;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 BFu16s_BFu17i_Sf) C1{ Fs:16 Fi:17 FC2{}}



static void Test_BFu16s_BFu17i_Sf()
{
  {
    init_simple_test("BFu16s_BFu17i_Sf");
    static BFu16s_BFu17i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_BFu17i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu16s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu16s_BFu17i_Sf");
    check_field_offset(lv, v3, 7, "BFu16s_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu17i_Sf(Test_BFu16s_BFu17i_Sf, "BFu16s_BFu17i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu17ll_Sf  {
  unsigned short v1:16;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 BFu16s_BFu17ll_Sf) C1{ Fs:16 FL:17 FC2{}}



static void Test_BFu16s_BFu17ll_Sf()
{
  {
    init_simple_test("BFu16s_BFu17ll_Sf");
    static BFu16s_BFu17ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "BFu16s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "BFu16s_BFu17ll_Sf");
    check_field_offset(lv, v3, 5, "BFu16s_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu17ll_Sf(Test_BFu16s_BFu17ll_Sf, "BFu16s_BFu17ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu1c_Sf  {
  unsigned short v1:16;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 BFu16s_BFu1c_Sf) C1{ Fs:16 Fc:1 FC2{}}



static void Test_BFu16s_BFu1c_Sf()
{
  {
    init_simple_test("BFu16s_BFu1c_Sf");
    static BFu16s_BFu1c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_BFu1c_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu1c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16s_BFu1c_Sf");
    check_field_offset(lv, v3, 3, "BFu16s_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu1c_Sf(Test_BFu16s_BFu1c_Sf, "BFu16s_BFu1c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu1i_Sf  {
  unsigned short v1:16;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 BFu16s_BFu1i_Sf) C1{ Fs:16 Fi:1 FC2{}}



static void Test_BFu16s_BFu1i_Sf()
{
  {
    init_simple_test("BFu16s_BFu1i_Sf");
    static BFu16s_BFu1i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_BFu1i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu1i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16s_BFu1i_Sf");
    check_field_offset(lv, v3, 3, "BFu16s_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu1i_Sf(Test_BFu16s_BFu1i_Sf, "BFu16s_BFu1i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu1ll_Sf  {
  unsigned short v1:16;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 BFu16s_BFu1ll_Sf) C1{ Fs:16 FL:1 FC2{}}



static void Test_BFu16s_BFu1ll_Sf()
{
  {
    init_simple_test("BFu16s_BFu1ll_Sf");
    static BFu16s_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16s_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16s_BFu1ll_Sf");
    check_field_offset(lv, v3, 3, "BFu16s_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu1ll_Sf(Test_BFu16s_BFu1ll_Sf, "BFu16s_BFu1ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu1s_Sf  {
  unsigned short v1:16;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 BFu16s_BFu1s_Sf) C1{ Fs:16 Fs:1 FC2{}}



static void Test_BFu16s_BFu1s_Sf()
{
  {
    init_simple_test("BFu16s_BFu1s_Sf");
    static BFu16s_BFu1s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_BFu1s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu1s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "BFu16s_BFu1s_Sf");
    check_field_offset(lv, v3, 3, "BFu16s_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu1s_Sf(Test_BFu16s_BFu1s_Sf, "BFu16s_BFu1s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu31i_Sf  {
  unsigned short v1:16;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 BFu16s_BFu31i_Sf) C1{ Fs:16 Fi:31 FC2{}}



static void Test_BFu16s_BFu31i_Sf()
{
  {
    init_simple_test("BFu16s_BFu31i_Sf");
    static BFu16s_BFu31i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu16s_BFu31i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu16s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu16s_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "BFu16s_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu31i_Sf(Test_BFu16s_BFu31i_Sf, "BFu16s_BFu31i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu31ll_Sf  {
  unsigned short v1:16;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 BFu16s_BFu31ll_Sf) C1{ Fs:16 FL:31 FC2{}}



static void Test_BFu16s_BFu31ll_Sf()
{
  {
    init_simple_test("BFu16s_BFu31ll_Sf");
    static BFu16s_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "BFu16s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "BFu16s_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "BFu16s_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu31ll_Sf(Test_BFu16s_BFu31ll_Sf, "BFu16s_BFu31ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu32i_Sf  {
  unsigned short v1:16;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 BFu16s_BFu32i_Sf) C1{ Fs:16 Fi:32 FC2{}}



static void Test_BFu16s_BFu32i_Sf()
{
  {
    init_simple_test("BFu16s_BFu32i_Sf");
    static BFu16s_BFu32i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu16s_BFu32i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu16s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu16s_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu16s_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu32i_Sf(Test_BFu16s_BFu32i_Sf, "BFu16s_BFu32i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu32ll_Sf  {
  unsigned short v1:16;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 BFu16s_BFu32ll_Sf) C1{ Fs:16 FL:32 FC2{}}



static void Test_BFu16s_BFu32ll_Sf()
{
  {
    init_simple_test("BFu16s_BFu32ll_Sf");
    static BFu16s_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "BFu16s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "BFu16s_BFu32ll_Sf");
    check_field_offset(lv, v3, 6, "BFu16s_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu32ll_Sf(Test_BFu16s_BFu32ll_Sf, "BFu16s_BFu32ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu33_Sf  {
  unsigned short v1:16;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 BFu16s_BFu33_Sf) C1{ Fs:16 FL:33 FC2{}}



static void Test_BFu16s_BFu33_Sf()
{
  {
    init_simple_test("BFu16s_BFu33_Sf");
    static BFu16s_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "BFu16s_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "BFu16s_BFu33_Sf");
    check_field_offset(lv, v3, 7, "BFu16s_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu33_Sf(Test_BFu16s_BFu33_Sf, "BFu16s_BFu33_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu7c_Sf  {
  unsigned short v1:16;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 BFu16s_BFu7c_Sf) C1{ Fs:16 Fc:7 FC2{}}



static void Test_BFu16s_BFu7c_Sf()
{
  {
    init_simple_test("BFu16s_BFu7c_Sf");
    static BFu16s_BFu7c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_BFu7c_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16s_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "BFu16s_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu7c_Sf(Test_BFu16s_BFu7c_Sf, "BFu16s_BFu7c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu7i_Sf  {
  unsigned short v1:16;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 BFu16s_BFu7i_Sf) C1{ Fs:16 Fi:7 FC2{}}



static void Test_BFu16s_BFu7i_Sf()
{
  {
    init_simple_test("BFu16s_BFu7i_Sf");
    static BFu16s_BFu7i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_BFu7i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16s_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "BFu16s_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu7i_Sf(Test_BFu16s_BFu7i_Sf, "BFu16s_BFu7i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu7ll_Sf  {
  unsigned short v1:16;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 BFu16s_BFu7ll_Sf) C1{ Fs:16 FL:7 FC2{}}



static void Test_BFu16s_BFu7ll_Sf()
{
  {
    init_simple_test("BFu16s_BFu7ll_Sf");
    static BFu16s_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16s_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16s_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "BFu16s_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu7ll_Sf(Test_BFu16s_BFu7ll_Sf, "BFu16s_BFu7ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu7s_Sf  {
  unsigned short v1:16;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 BFu16s_BFu7s_Sf) C1{ Fs:16 Fs:7 FC2{}}



static void Test_BFu16s_BFu7s_Sf()
{
  {
    init_simple_test("BFu16s_BFu7s_Sf");
    static BFu16s_BFu7s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_BFu7s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "BFu16s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "BFu16s_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "BFu16s_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu7s_Sf(Test_BFu16s_BFu7s_Sf, "BFu16s_BFu7s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu8c_Sf  {
  unsigned short v1:16;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 BFu16s_BFu8c_Sf) C1{ Fs:16 Fc:8 FC2{}}



static void Test_BFu16s_BFu8c_Sf()
{
  {
    init_simple_test("BFu16s_BFu8c_Sf");
    static BFu16s_BFu8c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_BFu8c_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16s_BFu8c_Sf");
    check_field_offset(lv, v3, 3, "BFu16s_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu8c_Sf(Test_BFu16s_BFu8c_Sf, "BFu16s_BFu8c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu8i_Sf  {
  unsigned short v1:16;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 BFu16s_BFu8i_Sf) C1{ Fs:16 Fi:8 FC2{}}



static void Test_BFu16s_BFu8i_Sf()
{
  {
    init_simple_test("BFu16s_BFu8i_Sf");
    static BFu16s_BFu8i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_BFu8i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16s_BFu8i_Sf");
    check_field_offset(lv, v3, 3, "BFu16s_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu8i_Sf(Test_BFu16s_BFu8i_Sf, "BFu16s_BFu8i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu8ll_Sf  {
  unsigned short v1:16;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 BFu16s_BFu8ll_Sf) C1{ Fs:16 FL:8 FC2{}}



static void Test_BFu16s_BFu8ll_Sf()
{
  {
    init_simple_test("BFu16s_BFu8ll_Sf");
    static BFu16s_BFu8ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16s_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16s_BFu8ll_Sf");
    check_field_offset(lv, v3, 3, "BFu16s_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu8ll_Sf(Test_BFu16s_BFu8ll_Sf, "BFu16s_BFu8ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu8s_Sf  {
  unsigned short v1:16;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 BFu16s_BFu8s_Sf) C1{ Fs:16 Fs:8 FC2{}}



static void Test_BFu16s_BFu8s_Sf()
{
  {
    init_simple_test("BFu16s_BFu8s_Sf");
    static BFu16s_BFu8s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_BFu8s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "BFu16s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "BFu16s_BFu8s_Sf");
    check_field_offset(lv, v3, 3, "BFu16s_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu8s_Sf(Test_BFu16s_BFu8s_Sf, "BFu16s_BFu8s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu9i_Sf  {
  unsigned short v1:16;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 BFu16s_BFu9i_Sf) C1{ Fs:16 Fi:9 FC2{}}



static void Test_BFu16s_BFu9i_Sf()
{
  {
    init_simple_test("BFu16s_BFu9i_Sf");
    static BFu16s_BFu9i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_BFu9i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu16s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu16s_BFu9i_Sf");
    check_field_offset(lv, v3, 4, "BFu16s_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu9i_Sf(Test_BFu16s_BFu9i_Sf, "BFu16s_BFu9i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu9ll_Sf  {
  unsigned short v1:16;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 BFu16s_BFu9ll_Sf) C1{ Fs:16 FL:9 FC2{}}



static void Test_BFu16s_BFu9ll_Sf()
{
  {
    init_simple_test("BFu16s_BFu9ll_Sf");
    static BFu16s_BFu9ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu16s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu16s_BFu9ll_Sf");
    check_field_offset(lv, v3, 4, "BFu16s_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu9ll_Sf(Test_BFu16s_BFu9ll_Sf, "BFu16s_BFu9ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_BFu9s_Sf  {
  unsigned short v1:16;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 BFu16s_BFu9s_Sf) C1{ Fs:16 Fs:9 FC2{}}



static void Test_BFu16s_BFu9s_Sf()
{
  {
    init_simple_test("BFu16s_BFu9s_Sf");
    static BFu16s_BFu9s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu16s_BFu9s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "BFu16s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "BFu16s_BFu9s_Sf");
    check_field_offset(lv, v3, 4, "BFu16s_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_BFu9s_Sf(Test_BFu16s_BFu9s_Sf, "BFu16s_BFu9s_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_C_Sf  {
  unsigned short v1:16;
  char v2;
  ::empty v3;
};
//SIG(1 BFu16s_C_Sf) C1{ Fs:16 Fc FC2{}}



static void Test_BFu16s_C_Sf()
{
  {
    init_simple_test("BFu16s_C_Sf");
    static BFu16s_C_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_C_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_C_Sf");
    check_field_offset(lv, v2, 2, "BFu16s_C_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu16s_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_C_Sf(Test_BFu16s_C_Sf, "BFu16s_C_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_D_Sf  {
  unsigned short v1:16;
  double v2;
  ::empty v3;
};
//SIG(1 BFu16s_D_Sf) C1{ Fs:16 FL FC2{}}



static void Test_BFu16s_D_Sf()
{
  {
    init_simple_test("BFu16s_D_Sf");
    static BFu16s_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu16s_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_D_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16s_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu16s_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_D_Sf(Test_BFu16s_D_Sf, "BFu16s_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_F_Sf  {
  unsigned short v1:16;
  float v2;
  ::empty v3;
};
//SIG(1 BFu16s_F_Sf) C1{ Fs:16 Fi FC2{}}



static void Test_BFu16s_F_Sf()
{
  {
    init_simple_test("BFu16s_F_Sf");
    static BFu16s_F_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu16s_F_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_F_Sf");
    check_field_offset(lv, v2, 4, "BFu16s_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu16s_F_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_F_Sf(Test_BFu16s_F_Sf, "BFu16s_F_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_I_Sf  {
  unsigned short v1:16;
  int v2;
  ::empty v3;
};
//SIG(1 BFu16s_I_Sf) C1{ Fs:16 Fi FC2{}}



static void Test_BFu16s_I_Sf()
{
  {
    init_simple_test("BFu16s_I_Sf");
    static BFu16s_I_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu16s_I_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_I_Sf");
    check_field_offset(lv, v2, 4, "BFu16s_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu16s_I_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_I_Sf(Test_BFu16s_I_Sf, "BFu16s_I_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Ip_Sf  {
  unsigned short v1:16;
  int *v2;
  ::empty v3;
};
//SIG(1 BFu16s_Ip_Sf) C1{ Fs:16 Fp FC2{}}



static void Test_BFu16s_Ip_Sf()
{
  {
    init_simple_test("BFu16s_Ip_Sf");
    static BFu16s_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu16s_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Ip_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16s_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu16s_Ip_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Ip_Sf(Test_BFu16s_Ip_Sf, "BFu16s_Ip_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_L_Sf  {
  unsigned short v1:16;
  __tsi64 v2;
  ::empty v3;
};
//SIG(1 BFu16s_L_Sf) C1{ Fs:16 FL FC2{}}



static void Test_BFu16s_L_Sf()
{
  {
    init_simple_test("BFu16s_L_Sf");
    static BFu16s_L_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu16s_L_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_L_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16s_L_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu16s_L_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_L_Sf(Test_BFu16s_L_Sf, "BFu16s_L_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_S_Sf  {
  unsigned short v1:16;
  short v2;
  ::empty v3;
};
//SIG(1 BFu16s_S_Sf) C1{ Fs:16 Fs FC2{}}



static void Test_BFu16s_S_Sf()
{
  {
    init_simple_test("BFu16s_S_Sf");
    static BFu16s_S_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu16s_S_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_S_Sf");
    check_field_offset(lv, v2, 2, "BFu16s_S_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu16s_S_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_S_Sf(Test_BFu16s_S_Sf, "BFu16s_S_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf  {
  unsigned short v1:16;
  ::empty v2;
};
//SIG(1 BFu16s_Sf) C1{ Fs:16 FC2{}}



static void Test_BFu16s_Sf()
{
  {
    init_simple_test("BFu16s_Sf");
    static BFu16s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf");
    check_field_offset(lv, v2, 2, "BFu16s_Sf.v2");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf(Test_BFu16s_Sf, "BFu16s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu15i  {
  unsigned short v1:16;
  ::empty v2;
  unsigned int v3:15;
};
//SIG(1 BFu16s_Sf_BFu15i) C1{ Fs:16 FC2{} Fi:15}



static void Test_BFu16s_Sf_BFu15i()
{
  {
    init_simple_test("BFu16s_Sf_BFu15i");
    static BFu16s_Sf_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu15i");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu16s_Sf_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu16s_Sf_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu15i(Test_BFu16s_Sf_BFu15i, "BFu16s_Sf_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu15ll  {
  unsigned short v1:16;
  ::empty v2;
  __tsu64 v3:15;
};
//SIG(1 BFu16s_Sf_BFu15ll) C1{ Fs:16 FC2{} FL:15}



static void Test_BFu16s_Sf_BFu15ll()
{
  {
    init_simple_test("BFu16s_Sf_BFu15ll");
    static BFu16s_Sf_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu15ll");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "BFu16s_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "BFu16s_Sf_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu15ll(Test_BFu16s_Sf_BFu15ll, "BFu16s_Sf_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu15s  {
  unsigned short v1:16;
  ::empty v2;
  unsigned short v3:15;
};
//SIG(1 BFu16s_Sf_BFu15s) C1{ Fs:16 FC2{} Fs:15}



static void Test_BFu16s_Sf_BFu15s()
{
  {
    init_simple_test("BFu16s_Sf_BFu15s");
    static BFu16s_Sf_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(BFu16s_Sf_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu15s");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu16s_Sf_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu16s_Sf_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu15s(Test_BFu16s_Sf_BFu15s, "BFu16s_Sf_BFu15s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu16i  {
  unsigned short v1:16;
  ::empty v2;
  unsigned int v3:16;
};
//SIG(1 BFu16s_Sf_BFu16i) C1{ Fs:16 FC2{} Fi:16}



static void Test_BFu16s_Sf_BFu16i()
{
  {
    init_simple_test("BFu16s_Sf_BFu16i");
    static BFu16s_Sf_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu16i");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu16s_Sf_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu16i(Test_BFu16s_Sf_BFu16i, "BFu16s_Sf_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu16ll  {
  unsigned short v1:16;
  ::empty v2;
  __tsu64 v3:16;
};
//SIG(1 BFu16s_Sf_BFu16ll) C1{ Fs:16 FC2{} FL:16}



static void Test_BFu16s_Sf_BFu16ll()
{
  {
    init_simple_test("BFu16s_Sf_BFu16ll");
    static BFu16s_Sf_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu16ll");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "BFu16s_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu16ll(Test_BFu16s_Sf_BFu16ll, "BFu16s_Sf_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu16s  {
  unsigned short v1:16;
  ::empty v2;
  unsigned short v3:16;
};
//SIG(1 BFu16s_Sf_BFu16s) C1{ Fs:16 FC2{} Fs:16}



static void Test_BFu16s_Sf_BFu16s()
{
  {
    init_simple_test("BFu16s_Sf_BFu16s");
    static BFu16s_Sf_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(BFu16s_Sf_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu16s");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu16s_Sf_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu16s(Test_BFu16s_Sf_BFu16s, "BFu16s_Sf_BFu16s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu17i  {
  unsigned short v1:16;
  ::empty v2;
  unsigned int v3:17;
};
//SIG(1 BFu16s_Sf_BFu17i) C1{ Fs:16 FC2{} Fi:17}



static void Test_BFu16s_Sf_BFu17i()
{
  {
    init_simple_test("BFu16s_Sf_BFu17i");
    static BFu16s_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu17i");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu16s_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu16s_Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu17i(Test_BFu16s_Sf_BFu17i, "BFu16s_Sf_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu17ll  {
  unsigned short v1:16;
  ::empty v2;
  __tsu64 v3:17;
};
//SIG(1 BFu16s_Sf_BFu17ll) C1{ Fs:16 FC2{} FL:17}



static void Test_BFu16s_Sf_BFu17ll()
{
  {
    init_simple_test("BFu16s_Sf_BFu17ll");
    static BFu16s_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu17ll");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "BFu16s_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "BFu16s_Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu17ll(Test_BFu16s_Sf_BFu17ll, "BFu16s_Sf_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu1c  {
  unsigned short v1:16;
  ::empty v2;
  unsigned char v3:1;
};
//SIG(1 BFu16s_Sf_BFu1c) C1{ Fs:16 FC2{} Fc:1}



static void Test_BFu16s_Sf_BFu1c()
{
  {
    init_simple_test("BFu16s_Sf_BFu1c");
    static BFu16s_Sf_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_Sf_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu1c");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16s_Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu1c(Test_BFu16s_Sf_BFu1c, "BFu16s_Sf_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu1i  {
  unsigned short v1:16;
  ::empty v2;
  unsigned int v3:1;
};
//SIG(1 BFu16s_Sf_BFu1i) C1{ Fs:16 FC2{} Fi:1}



static void Test_BFu16s_Sf_BFu1i()
{
  {
    init_simple_test("BFu16s_Sf_BFu1i");
    static BFu16s_Sf_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_Sf_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu1i");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16s_Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu1i(Test_BFu16s_Sf_BFu1i, "BFu16s_Sf_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu1ll  {
  unsigned short v1:16;
  ::empty v2;
  __tsu64 v3:1;
};
//SIG(1 BFu16s_Sf_BFu1ll) C1{ Fs:16 FC2{} FL:1}



static void Test_BFu16s_Sf_BFu1ll()
{
  {
    init_simple_test("BFu16s_Sf_BFu1ll");
    static BFu16s_Sf_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16s_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu1ll");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16s_Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu1ll(Test_BFu16s_Sf_BFu1ll, "BFu16s_Sf_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu1s  {
  unsigned short v1:16;
  ::empty v2;
  unsigned short v3:1;
};
//SIG(1 BFu16s_Sf_BFu1s) C1{ Fs:16 FC2{} Fs:1}



static void Test_BFu16s_Sf_BFu1s()
{
  {
    init_simple_test("BFu16s_Sf_BFu1s");
    static BFu16s_Sf_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_Sf_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu1s");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "BFu16s_Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu1s(Test_BFu16s_Sf_BFu1s, "BFu16s_Sf_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu31i  {
  unsigned short v1:16;
  ::empty v2;
  unsigned int v3:31;
};
//SIG(1 BFu16s_Sf_BFu31i) C1{ Fs:16 FC2{} Fi:31}



static void Test_BFu16s_Sf_BFu31i()
{
  {
    init_simple_test("BFu16s_Sf_BFu31i");
    static BFu16s_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu31i");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu16s_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu16s_Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu31i(Test_BFu16s_Sf_BFu31i, "BFu16s_Sf_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu31ll  {
  unsigned short v1:16;
  ::empty v2;
  __tsu64 v3:31;
};
//SIG(1 BFu16s_Sf_BFu31ll) C1{ Fs:16 FC2{} FL:31}



static void Test_BFu16s_Sf_BFu31ll()
{
  {
    init_simple_test("BFu16s_Sf_BFu31ll");
    static BFu16s_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu31ll");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "BFu16s_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "BFu16s_Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu31ll(Test_BFu16s_Sf_BFu31ll, "BFu16s_Sf_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu32i  {
  unsigned short v1:16;
  ::empty v2;
  unsigned int v3:32;
};
//SIG(1 BFu16s_Sf_BFu32i) C1{ Fs:16 FC2{} Fi:32}



static void Test_BFu16s_Sf_BFu32i()
{
  {
    init_simple_test("BFu16s_Sf_BFu32i");
    static BFu16s_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu32i");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu16s_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu16s_Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu32i(Test_BFu16s_Sf_BFu32i, "BFu16s_Sf_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu32ll  {
  unsigned short v1:16;
  ::empty v2;
  __tsu64 v3:32;
};
//SIG(1 BFu16s_Sf_BFu32ll) C1{ Fs:16 FC2{} FL:32}



static void Test_BFu16s_Sf_BFu32ll()
{
  {
    init_simple_test("BFu16s_Sf_BFu32ll");
    static BFu16s_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu32ll");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "BFu16s_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "BFu16s_Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu32ll(Test_BFu16s_Sf_BFu32ll, "BFu16s_Sf_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu33  {
  unsigned short v1:16;
  ::empty v2;
  __tsu64 v3:33;
};
//SIG(1 BFu16s_Sf_BFu33) C1{ Fs:16 FC2{} FL:33}



static void Test_BFu16s_Sf_BFu33()
{
  {
    init_simple_test("BFu16s_Sf_BFu33");
    static BFu16s_Sf_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu33");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "BFu16s_Sf_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "BFu16s_Sf_BFu33");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu33(Test_BFu16s_Sf_BFu33, "BFu16s_Sf_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu7c  {
  unsigned short v1:16;
  ::empty v2;
  unsigned char v3:7;
};
//SIG(1 BFu16s_Sf_BFu7c) C1{ Fs:16 FC2{} Fc:7}



static void Test_BFu16s_Sf_BFu7c()
{
  {
    init_simple_test("BFu16s_Sf_BFu7c");
    static BFu16s_Sf_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_Sf_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu7c");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16s_Sf_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16s_Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu7c(Test_BFu16s_Sf_BFu7c, "BFu16s_Sf_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu7i  {
  unsigned short v1:16;
  ::empty v2;
  unsigned int v3:7;
};
//SIG(1 BFu16s_Sf_BFu7i) C1{ Fs:16 FC2{} Fi:7}



static void Test_BFu16s_Sf_BFu7i()
{
  {
    init_simple_test("BFu16s_Sf_BFu7i");
    static BFu16s_Sf_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_Sf_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu7i");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16s_Sf_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16s_Sf_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu7i(Test_BFu16s_Sf_BFu7i, "BFu16s_Sf_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu7ll  {
  unsigned short v1:16;
  ::empty v2;
  __tsu64 v3:7;
};
//SIG(1 BFu16s_Sf_BFu7ll) C1{ Fs:16 FC2{} FL:7}



static void Test_BFu16s_Sf_BFu7ll()
{
  {
    init_simple_test("BFu16s_Sf_BFu7ll");
    static BFu16s_Sf_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16s_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu7ll");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16s_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16s_Sf_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu7ll(Test_BFu16s_Sf_BFu7ll, "BFu16s_Sf_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu7s  {
  unsigned short v1:16;
  ::empty v2;
  unsigned short v3:7;
};
//SIG(1 BFu16s_Sf_BFu7s) C1{ Fs:16 FC2{} Fs:7}



static void Test_BFu16s_Sf_BFu7s()
{
  {
    init_simple_test("BFu16s_Sf_BFu7s");
    static BFu16s_Sf_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_Sf_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu7s");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "BFu16s_Sf_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "BFu16s_Sf_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu7s(Test_BFu16s_Sf_BFu7s, "BFu16s_Sf_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu8c  {
  unsigned short v1:16;
  ::empty v2;
  unsigned char v3:8;
};
//SIG(1 BFu16s_Sf_BFu8c) C1{ Fs:16 FC2{} Fc:8}



static void Test_BFu16s_Sf_BFu8c()
{
  {
    init_simple_test("BFu16s_Sf_BFu8c");
    static BFu16s_Sf_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_Sf_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu8c");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16s_Sf_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16s_Sf_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu8c(Test_BFu16s_Sf_BFu8c, "BFu16s_Sf_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu8i  {
  unsigned short v1:16;
  ::empty v2;
  unsigned int v3:8;
};
//SIG(1 BFu16s_Sf_BFu8i) C1{ Fs:16 FC2{} Fi:8}



static void Test_BFu16s_Sf_BFu8i()
{
  {
    init_simple_test("BFu16s_Sf_BFu8i");
    static BFu16s_Sf_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_Sf_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu8i");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16s_Sf_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16s_Sf_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu8i(Test_BFu16s_Sf_BFu8i, "BFu16s_Sf_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu8ll  {
  unsigned short v1:16;
  ::empty v2;
  __tsu64 v3:8;
};
//SIG(1 BFu16s_Sf_BFu8ll) C1{ Fs:16 FC2{} FL:8}



static void Test_BFu16s_Sf_BFu8ll()
{
  {
    init_simple_test("BFu16s_Sf_BFu8ll");
    static BFu16s_Sf_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu16s_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu8ll");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16s_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16s_Sf_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu8ll(Test_BFu16s_Sf_BFu8ll, "BFu16s_Sf_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu8s  {
  unsigned short v1:16;
  ::empty v2;
  unsigned short v3:8;
};
//SIG(1 BFu16s_Sf_BFu8s) C1{ Fs:16 FC2{} Fs:8}



static void Test_BFu16s_Sf_BFu8s()
{
  {
    init_simple_test("BFu16s_Sf_BFu8s");
    static BFu16s_Sf_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_Sf_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu8s");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "BFu16s_Sf_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "BFu16s_Sf_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu8s(Test_BFu16s_Sf_BFu8s, "BFu16s_Sf_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu9i  {
  unsigned short v1:16;
  ::empty v2;
  unsigned int v3:9;
};
//SIG(1 BFu16s_Sf_BFu9i) C1{ Fs:16 FC2{} Fi:9}



static void Test_BFu16s_Sf_BFu9i()
{
  {
    init_simple_test("BFu16s_Sf_BFu9i");
    static BFu16s_Sf_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu9i");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu16s_Sf_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu16s_Sf_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu9i(Test_BFu16s_Sf_BFu9i, "BFu16s_Sf_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu9ll  {
  unsigned short v1:16;
  ::empty v2;
  __tsu64 v3:9;
};
//SIG(1 BFu16s_Sf_BFu9ll) C1{ Fs:16 FC2{} FL:9}



static void Test_BFu16s_Sf_BFu9ll()
{
  {
    init_simple_test("BFu16s_Sf_BFu9ll");
    static BFu16s_Sf_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu9ll");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "BFu16s_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "BFu16s_Sf_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu9ll(Test_BFu16s_Sf_BFu9ll, "BFu16s_Sf_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_BFu9s  {
  unsigned short v1:16;
  ::empty v2;
  unsigned short v3:9;
};
//SIG(1 BFu16s_Sf_BFu9s) C1{ Fs:16 FC2{} Fs:9}



static void Test_BFu16s_Sf_BFu9s()
{
  {
    init_simple_test("BFu16s_Sf_BFu9s");
    static BFu16s_Sf_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(BFu16s_Sf_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_BFu9s");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu16s_Sf_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu16s_Sf_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_BFu9s(Test_BFu16s_Sf_BFu9s, "BFu16s_Sf_BFu9s", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_C  {
  unsigned short v1:16;
  ::empty v2;
  char v3;
};
//SIG(1 BFu16s_Sf_C) C1{ Fs:16 FC2{} Fc}



static void Test_BFu16s_Sf_C()
{
  {
    init_simple_test("BFu16s_Sf_C");
    static BFu16s_Sf_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_Sf_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_C");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_C.v2");
    check_field_offset(lv, v3, 3, "BFu16s_Sf_C.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_C(Test_BFu16s_Sf_C, "BFu16s_Sf_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_D  {
  unsigned short v1:16;
  ::empty v2;
  double v3;
};
//SIG(1 BFu16s_Sf_D) C1{ Fs:16 FC2{} FL}



static void Test_BFu16s_Sf_D()
{
  {
    init_simple_test("BFu16s_Sf_D");
    static BFu16s_Sf_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu16s_Sf_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_D");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16s_Sf_D.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_D(Test_BFu16s_Sf_D, "BFu16s_Sf_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_F  {
  unsigned short v1:16;
  ::empty v2;
  float v3;
};
//SIG(1 BFu16s_Sf_F) C1{ Fs:16 FC2{} Fi}



static void Test_BFu16s_Sf_F()
{
  {
    init_simple_test("BFu16s_Sf_F");
    static BFu16s_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_F");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu16s_Sf_F.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_F(Test_BFu16s_Sf_F, "BFu16s_Sf_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_I  {
  unsigned short v1:16;
  ::empty v2;
  int v3;
};
//SIG(1 BFu16s_Sf_I) C1{ Fs:16 FC2{} Fi}



static void Test_BFu16s_Sf_I()
{
  {
    init_simple_test("BFu16s_Sf_I");
    static BFu16s_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_I");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu16s_Sf_I.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_I(Test_BFu16s_Sf_I, "BFu16s_Sf_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_Ip  {
  unsigned short v1:16;
  ::empty v2;
  int *v3;
};
//SIG(1 BFu16s_Sf_Ip) C1{ Fs:16 FC2{} Fp}



static void Test_BFu16s_Sf_Ip()
{
  {
    init_simple_test("BFu16s_Sf_Ip");
    static BFu16s_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu16s_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_Ip");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16s_Sf_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_Ip(Test_BFu16s_Sf_Ip, "BFu16s_Sf_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_L  {
  unsigned short v1:16;
  ::empty v2;
  __tsi64 v3;
};
//SIG(1 BFu16s_Sf_L) C1{ Fs:16 FC2{} FL}



static void Test_BFu16s_Sf_L()
{
  {
    init_simple_test("BFu16s_Sf_L");
    static BFu16s_Sf_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu16s_Sf_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_L");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16s_Sf_L.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_L(Test_BFu16s_Sf_L, "BFu16s_Sf_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_S  {
  unsigned short v1:16;
  ::empty v2;
  short v3;
};
//SIG(1 BFu16s_Sf_S) C1{ Fs:16 FC2{} Fs}



static void Test_BFu16s_Sf_S()
{
  {
    init_simple_test("BFu16s_Sf_S");
    static BFu16s_Sf_S lv;
    check2(sizeof(lv), 6, "sizeof(BFu16s_Sf_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_S");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_S.v2");
    check_field_offset(lv, v3, 4, "BFu16s_Sf_S.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_S(Test_BFu16s_Sf_S, "BFu16s_Sf_S", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_Sf  {
  unsigned short v1:16;
  ::empty v2;
  ::empty v3;
};
//SIG(1 BFu16s_Sf_Sf) C1{ Fs:16 FC2{} FC2}



static void Test_BFu16s_Sf_Sf()
{
  {
    init_simple_test("BFu16s_Sf_Sf");
    static BFu16s_Sf_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_Sf_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_Sf");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu16s_Sf_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_Sf(Test_BFu16s_Sf_Sf, "BFu16s_Sf_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_Uc  {
  unsigned short v1:16;
  ::empty v2;
  unsigned char v3;
};
//SIG(1 BFu16s_Sf_Uc) C1{ Fs:16 FC2{} Fc}



static void Test_BFu16s_Sf_Uc()
{
  {
    init_simple_test("BFu16s_Sf_Uc");
    static BFu16s_Sf_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_Sf_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_Uc");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_Uc.v2");
    check_field_offset(lv, v3, 3, "BFu16s_Sf_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_Uc(Test_BFu16s_Sf_Uc, "BFu16s_Sf_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_Ui  {
  unsigned short v1:16;
  ::empty v2;
  unsigned int v3;
};
//SIG(1 BFu16s_Sf_Ui) C1{ Fs:16 FC2{} Fi}



static void Test_BFu16s_Sf_Ui()
{
  {
    init_simple_test("BFu16s_Sf_Ui");
    static BFu16s_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu16s_Sf_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_Ui");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu16s_Sf_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_Ui(Test_BFu16s_Sf_Ui, "BFu16s_Sf_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_Ul  {
  unsigned short v1:16;
  ::empty v2;
  __tsu64 v3;
};
//SIG(1 BFu16s_Sf_Ul) C1{ Fs:16 FC2{} FL}



static void Test_BFu16s_Sf_Ul()
{
  {
    init_simple_test("BFu16s_Sf_Ul");
    static BFu16s_Sf_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu16s_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_Ul");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16s_Sf_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_Ul(Test_BFu16s_Sf_Ul, "BFu16s_Sf_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_Us  {
  unsigned short v1:16;
  ::empty v2;
  unsigned short v3;
};
//SIG(1 BFu16s_Sf_Us) C1{ Fs:16 FC2{} Fs}



static void Test_BFu16s_Sf_Us()
{
  {
    init_simple_test("BFu16s_Sf_Us");
    static BFu16s_Sf_Us lv;
    check2(sizeof(lv), 6, "sizeof(BFu16s_Sf_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_Us");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_Us.v2");
    check_field_offset(lv, v3, 4, "BFu16s_Sf_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_Us(Test_BFu16s_Sf_Us, "BFu16s_Sf_Us", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Sf_Vp  {
  unsigned short v1:16;
  ::empty v2;
  void *v3;
};
//SIG(1 BFu16s_Sf_Vp) C1{ Fs:16 FC2{} Fp}



static void Test_BFu16s_Sf_Vp()
{
  {
    init_simple_test("BFu16s_Sf_Vp");
    static BFu16s_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu16s_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Sf_Vp");
    check_field_offset(lv, v2, 2, "BFu16s_Sf_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu16s_Sf_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Sf_Vp(Test_BFu16s_Sf_Vp, "BFu16s_Sf_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Uc_Sf  {
  unsigned short v1:16;
  unsigned char v2;
  ::empty v3;
};
//SIG(1 BFu16s_Uc_Sf) C1{ Fs:16 Fc FC2{}}



static void Test_BFu16s_Uc_Sf()
{
  {
    init_simple_test("BFu16s_Uc_Sf");
    static BFu16s_Uc_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu16s_Uc_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Uc_Sf");
    check_field_offset(lv, v2, 2, "BFu16s_Uc_Sf.v2");
    check_field_offset(lv, v3, 3, "BFu16s_Uc_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Uc_Sf(Test_BFu16s_Uc_Sf, "BFu16s_Uc_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Ui_Sf  {
  unsigned short v1:16;
  unsigned int v2;
  ::empty v3;
};
//SIG(1 BFu16s_Ui_Sf) C1{ Fs:16 Fi FC2{}}



static void Test_BFu16s_Ui_Sf()
{
  {
    init_simple_test("BFu16s_Ui_Sf");
    static BFu16s_Ui_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu16s_Ui_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu16s_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu16s_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu16s_Ui_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Ui_Sf(Test_BFu16s_Ui_Sf, "BFu16s_Ui_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Ul_Sf  {
  unsigned short v1:16;
  __tsu64 v2;
  ::empty v3;
};
//SIG(1 BFu16s_Ul_Sf) C1{ Fs:16 FL FC2{}}



static void Test_BFu16s_Ul_Sf()
{
  {
    init_simple_test("BFu16s_Ul_Sf");
    static BFu16s_Ul_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu16s_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Ul_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16s_Ul_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu16s_Ul_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Ul_Sf(Test_BFu16s_Ul_Sf, "BFu16s_Ul_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Us_Sf  {
  unsigned short v1:16;
  unsigned short v2;
  ::empty v3;
};
//SIG(1 BFu16s_Us_Sf) C1{ Fs:16 Fs FC2{}}



static void Test_BFu16s_Us_Sf()
{
  {
    init_simple_test("BFu16s_Us_Sf");
    static BFu16s_Us_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu16s_Us_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu16s_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Us_Sf");
    check_field_offset(lv, v2, 2, "BFu16s_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu16s_Us_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Us_Sf(Test_BFu16s_Us_Sf, "BFu16s_Us_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu16s_Vp_Sf  {
  unsigned short v1:16;
  void *v2;
  ::empty v3;
};
//SIG(1 BFu16s_Vp_Sf) C1{ Fs:16 Fp FC2{}}



static void Test_BFu16s_Vp_Sf()
{
  {
    init_simple_test("BFu16s_Vp_Sf");
    static BFu16s_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu16s_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu16s_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "BFu16s_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "BFu16s_Vp_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu16s_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu16s_Vp_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu16s_Vp_Sf(Test_BFu16s_Vp_Sf, "BFu16s_Vp_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu15i_Sf  {
  unsigned int v1:17;
  unsigned int v2:15;
  ::empty v3;
};
//SIG(1 BFu17i_BFu15i_Sf) C1{ Fi:17 Fi:15 FC2{}}



static void Test_BFu17i_BFu15i_Sf()
{
  {
    init_simple_test("BFu17i_BFu15i_Sf");
    static BFu17i_BFu15i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu15i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17i_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "BFu17i_BFu15i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu15i_Sf(Test_BFu17i_BFu15i_Sf, "BFu17i_BFu15i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu15ll_Sf  {
  unsigned int v1:17;
  __tsu64 v2:15;
  ::empty v3;
};
//SIG(1 BFu17i_BFu15ll_Sf) C1{ Fi:17 FL:15 FC2{}}



static void Test_BFu17i_BFu15ll_Sf()
{
  {
    init_simple_test("BFu17i_BFu15ll_Sf");
    static BFu17i_BFu15ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17i_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "BFu17i_BFu15ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu15ll_Sf(Test_BFu17i_BFu15ll_Sf, "BFu17i_BFu15ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu15s_Sf  {
  unsigned int v1:17;
  unsigned short v2:15;
  ::empty v3;
};
//SIG(1 BFu17i_BFu15s_Sf) C1{ Fi:17 Fs:15 FC2{}}



static void Test_BFu17i_BFu15s_Sf()
{
  {
    init_simple_test("BFu17i_BFu15s_Sf");
    static BFu17i_BFu15s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu15s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17i_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "BFu17i_BFu15s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu15s_Sf(Test_BFu17i_BFu15s_Sf, "BFu17i_BFu15s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu16i_Sf  {
  unsigned int v1:17;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 BFu17i_BFu16i_Sf) C1{ Fi:17 Fi:16 FC2{}}



static void Test_BFu17i_BFu16i_Sf()
{
  {
    init_simple_test("BFu17i_BFu16i_Sf");
    static BFu17i_BFu16i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu16i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17i_BFu16i_Sf");
    check_field_offset(lv, v3, 6, "BFu17i_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu16i_Sf(Test_BFu17i_BFu16i_Sf, "BFu17i_BFu16i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu16ll_Sf  {
  unsigned int v1:17;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 BFu17i_BFu16ll_Sf) C1{ Fi:17 FL:16 FC2{}}



static void Test_BFu17i_BFu16ll_Sf()
{
  {
    init_simple_test("BFu17i_BFu16ll_Sf");
    static BFu17i_BFu16ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, 1, "BFu17i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, hide_ull(1LL<<15), "BFu17i_BFu16ll_Sf");
    check_field_offset(lv, v3, 5, "BFu17i_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu16ll_Sf(Test_BFu17i_BFu16ll_Sf, "BFu17i_BFu16ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu16s_Sf  {
  unsigned int v1:17;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 BFu17i_BFu16s_Sf) C1{ Fi:17 Fs:16 FC2{}}



static void Test_BFu17i_BFu16s_Sf()
{
  {
    init_simple_test("BFu17i_BFu16s_Sf");
    static BFu17i_BFu16s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu16s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17i_BFu16s_Sf");
    check_field_offset(lv, v3, 6, "BFu17i_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu16s_Sf(Test_BFu17i_BFu16s_Sf, "BFu17i_BFu16s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu17i_Sf  {
  unsigned int v1:17;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 BFu17i_BFu17i_Sf) C1{ Fi:17 Fi:17 FC2{}}



static void Test_BFu17i_BFu17i_Sf()
{
  {
    init_simple_test("BFu17i_BFu17i_Sf");
    static BFu17i_BFu17i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu17i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu17i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu17i_Sf");
    check_field_offset(lv, v3, 7, "BFu17i_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu17i_Sf(Test_BFu17i_BFu17i_Sf, "BFu17i_BFu17i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu17ll_Sf  {
  unsigned int v1:17;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 BFu17i_BFu17ll_Sf) C1{ Fi:17 FL:17 FC2{}}



static void Test_BFu17i_BFu17ll_Sf()
{
  {
    init_simple_test("BFu17i_BFu17ll_Sf");
    static BFu17i_BFu17ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 17, 1, "BFu17i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 17, hide_ull(1LL<<16), "BFu17i_BFu17ll_Sf");
    check_field_offset(lv, v3, 5, "BFu17i_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu17ll_Sf(Test_BFu17i_BFu17ll_Sf, "BFu17i_BFu17ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu1c_Sf  {
  unsigned int v1:17;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 BFu17i_BFu1c_Sf) C1{ Fi:17 Fc:1 FC2{}}



static void Test_BFu17i_BFu1c_Sf()
{
  {
    init_simple_test("BFu17i_BFu1c_Sf");
    static BFu17i_BFu1c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu17i_BFu1c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu1c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17i_BFu1c_Sf");
    check_field_offset(lv, v3, 3, "BFu17i_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu1c_Sf(Test_BFu17i_BFu1c_Sf, "BFu17i_BFu1c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu1i_Sf  {
  unsigned int v1:17;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 BFu17i_BFu1i_Sf) C1{ Fi:17 Fi:1 FC2{}}



static void Test_BFu17i_BFu1i_Sf()
{
  {
    init_simple_test("BFu17i_BFu1i_Sf");
    static BFu17i_BFu1i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu17i_BFu1i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu1i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17i_BFu1i_Sf");
    check_field_offset(lv, v3, 3, "BFu17i_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu1i_Sf(Test_BFu17i_BFu1i_Sf, "BFu17i_BFu1i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu1ll_Sf  {
  unsigned int v1:17;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 BFu17i_BFu1ll_Sf) C1{ Fi:17 FL:1 FC2{}}



static void Test_BFu17i_BFu1ll_Sf()
{
  {
    init_simple_test("BFu17i_BFu1ll_Sf");
    static BFu17i_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17i_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17i_BFu1ll_Sf");
    check_field_offset(lv, v3, 3, "BFu17i_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu1ll_Sf(Test_BFu17i_BFu1ll_Sf, "BFu17i_BFu1ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu1s_Sf  {
  unsigned int v1:17;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 BFu17i_BFu1s_Sf) C1{ Fi:17 Fs:1 FC2{}}



static void Test_BFu17i_BFu1s_Sf()
{
  {
    init_simple_test("BFu17i_BFu1s_Sf");
    static BFu17i_BFu1s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu17i_BFu1s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu1s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17i_BFu1s_Sf");
    check_field_offset(lv, v3, 3, "BFu17i_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu1s_Sf(Test_BFu17i_BFu1s_Sf, "BFu17i_BFu1s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu31i_Sf  {
  unsigned int v1:17;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 BFu17i_BFu31i_Sf) C1{ Fi:17 Fi:31 FC2{}}



static void Test_BFu17i_BFu31i_Sf()
{
  {
    init_simple_test("BFu17i_BFu31i_Sf");
    static BFu17i_BFu31i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu17i_BFu31i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu17i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu17i_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "BFu17i_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu31i_Sf(Test_BFu17i_BFu31i_Sf, "BFu17i_BFu31i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu31ll_Sf  {
  unsigned int v1:17;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 BFu17i_BFu31ll_Sf) C1{ Fi:17 FL:31 FC2{}}



static void Test_BFu17i_BFu31ll_Sf()
{
  {
    init_simple_test("BFu17i_BFu31ll_Sf");
    static BFu17i_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 31, 1, "BFu17i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 31, hide_ull(1LL<<30), "BFu17i_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "BFu17i_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu31ll_Sf(Test_BFu17i_BFu31ll_Sf, "BFu17i_BFu31ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu32i_Sf  {
  unsigned int v1:17;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 BFu17i_BFu32i_Sf) C1{ Fi:17 Fi:32 FC2{}}



static void Test_BFu17i_BFu32i_Sf()
{
  {
    init_simple_test("BFu17i_BFu32i_Sf");
    static BFu17i_BFu32i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu17i_BFu32i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu17i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu17i_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu17i_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu32i_Sf(Test_BFu17i_BFu32i_Sf, "BFu17i_BFu32i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu32ll_Sf  {
  unsigned int v1:17;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 BFu17i_BFu32ll_Sf) C1{ Fi:17 FL:32 FC2{}}



static void Test_BFu17i_BFu32ll_Sf()
{
  {
    init_simple_test("BFu17i_BFu32ll_Sf");
    static BFu17i_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 32, 1, "BFu17i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 32, hide_ull(1LL<<31), "BFu17i_BFu32ll_Sf");
    check_field_offset(lv, v3, 7, "BFu17i_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu32ll_Sf(Test_BFu17i_BFu32ll_Sf, "BFu17i_BFu32ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu33_Sf  {
  unsigned int v1:17;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 BFu17i_BFu33_Sf) C1{ Fi:17 FL:33 FC2{}}



static void Test_BFu17i_BFu33_Sf()
{
  {
    init_simple_test("BFu17i_BFu33_Sf");
    static BFu17i_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 1, 33, 1, "BFu17i_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 1, 33, hide_ull(1LL<<32), "BFu17i_BFu33_Sf");
    check_field_offset(lv, v3, 7, "BFu17i_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu33_Sf(Test_BFu17i_BFu33_Sf, "BFu17i_BFu33_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu7c_Sf  {
  unsigned int v1:17;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 BFu17i_BFu7c_Sf) C1{ Fi:17 Fc:7 FC2{}}



static void Test_BFu17i_BFu7c_Sf()
{
  {
    init_simple_test("BFu17i_BFu7c_Sf");
    static BFu17i_BFu7c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu17i_BFu7c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17i_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "BFu17i_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu7c_Sf(Test_BFu17i_BFu7c_Sf, "BFu17i_BFu7c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu7i_Sf  {
  unsigned int v1:17;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 BFu17i_BFu7i_Sf) C1{ Fi:17 Fi:7 FC2{}}



static void Test_BFu17i_BFu7i_Sf()
{
  {
    init_simple_test("BFu17i_BFu7i_Sf");
    static BFu17i_BFu7i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu17i_BFu7i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17i_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "BFu17i_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu7i_Sf(Test_BFu17i_BFu7i_Sf, "BFu17i_BFu7i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu7ll_Sf  {
  unsigned int v1:17;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 BFu17i_BFu7ll_Sf) C1{ Fi:17 FL:7 FC2{}}



static void Test_BFu17i_BFu7ll_Sf()
{
  {
    init_simple_test("BFu17i_BFu7ll_Sf");
    static BFu17i_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17i_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17i_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "BFu17i_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu7ll_Sf(Test_BFu17i_BFu7ll_Sf, "BFu17i_BFu7ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu7s_Sf  {
  unsigned int v1:17;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 BFu17i_BFu7s_Sf) C1{ Fi:17 Fs:7 FC2{}}



static void Test_BFu17i_BFu7s_Sf()
{
  {
    init_simple_test("BFu17i_BFu7s_Sf");
    static BFu17i_BFu7s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu17i_BFu7s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17i_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "BFu17i_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu7s_Sf(Test_BFu17i_BFu7s_Sf, "BFu17i_BFu7s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu8c_Sf  {
  unsigned int v1:17;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 BFu17i_BFu8c_Sf) C1{ Fi:17 Fc:8 FC2{}}



static void Test_BFu17i_BFu8c_Sf()
{
  {
    init_simple_test("BFu17i_BFu8c_Sf");
    static BFu17i_BFu8c_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu8c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 3, 0, 8, 1, "BFu17i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 3, 0, 8, hide_ull(1LL<<7), "BFu17i_BFu8c_Sf");
    check_field_offset(lv, v3, 4, "BFu17i_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu8c_Sf(Test_BFu17i_BFu8c_Sf, "BFu17i_BFu8c_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu8i_Sf  {
  unsigned int v1:17;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 BFu17i_BFu8i_Sf) C1{ Fi:17 Fi:8 FC2{}}



static void Test_BFu17i_BFu8i_Sf()
{
  {
    init_simple_test("BFu17i_BFu8i_Sf");
    static BFu17i_BFu8i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu8i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17i_BFu8i_Sf");
    check_field_offset(lv, v3, 4, "BFu17i_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu8i_Sf(Test_BFu17i_BFu8i_Sf, "BFu17i_BFu8i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu8ll_Sf  {
  unsigned int v1:17;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 BFu17i_BFu8ll_Sf) C1{ Fi:17 FL:8 FC2{}}



static void Test_BFu17i_BFu8ll_Sf()
{
  {
    init_simple_test("BFu17i_BFu8ll_Sf");
    static BFu17i_BFu8ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17i_BFu8ll_Sf");
    check_field_offset(lv, v3, 4, "BFu17i_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu8ll_Sf(Test_BFu17i_BFu8ll_Sf, "BFu17i_BFu8ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu8s_Sf  {
  unsigned int v1:17;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 BFu17i_BFu8s_Sf) C1{ Fi:17 Fs:8 FC2{}}



static void Test_BFu17i_BFu8s_Sf()
{
  {
    init_simple_test("BFu17i_BFu8s_Sf");
    static BFu17i_BFu8s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu8s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17i_BFu8s_Sf");
    check_field_offset(lv, v3, 4, "BFu17i_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu8s_Sf(Test_BFu17i_BFu8s_Sf, "BFu17i_BFu8s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu9i_Sf  {
  unsigned int v1:17;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 BFu17i_BFu9i_Sf) C1{ Fi:17 Fi:9 FC2{}}



static void Test_BFu17i_BFu9i_Sf()
{
  {
    init_simple_test("BFu17i_BFu9i_Sf");
    static BFu17i_BFu9i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu9i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17i_BFu9i_Sf");
    check_field_offset(lv, v3, 4, "BFu17i_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu9i_Sf(Test_BFu17i_BFu9i_Sf, "BFu17i_BFu9i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu9ll_Sf  {
  unsigned int v1:17;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 BFu17i_BFu9ll_Sf) C1{ Fi:17 FL:9 FC2{}}



static void Test_BFu17i_BFu9ll_Sf()
{
  {
    init_simple_test("BFu17i_BFu9ll_Sf");
    static BFu17i_BFu9ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17i_BFu9ll_Sf");
    check_field_offset(lv, v3, 4, "BFu17i_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu9ll_Sf(Test_BFu17i_BFu9ll_Sf, "BFu17i_BFu9ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_BFu9s_Sf  {
  unsigned int v1:17;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 BFu17i_BFu9s_Sf) C1{ Fi:17 Fs:9 FC2{}}



static void Test_BFu17i_BFu9s_Sf()
{
  {
    init_simple_test("BFu17i_BFu9s_Sf");
    static BFu17i_BFu9s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_BFu9s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17i_BFu9s_Sf");
    check_field_offset(lv, v3, 4, "BFu17i_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_BFu9s_Sf(Test_BFu17i_BFu9s_Sf, "BFu17i_BFu9s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_C_Sf  {
  unsigned int v1:17;
  char v2;
  ::empty v3;
};
//SIG(1 BFu17i_C_Sf) C1{ Fi:17 Fc FC2{}}



static void Test_BFu17i_C_Sf()
{
  {
    init_simple_test("BFu17i_C_Sf");
    static BFu17i_C_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_C_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_C_Sf");
    check_field_offset(lv, v2, 3, "BFu17i_C_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu17i_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_C_Sf(Test_BFu17i_C_Sf, "BFu17i_C_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_D_Sf  {
  unsigned int v1:17;
  double v2;
  ::empty v3;
};
//SIG(1 BFu17i_D_Sf) C1{ Fi:17 FL FC2{}}



static void Test_BFu17i_D_Sf()
{
  {
    init_simple_test("BFu17i_D_Sf");
    static BFu17i_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17i_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_D_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17i_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17i_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_D_Sf(Test_BFu17i_D_Sf, "BFu17i_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_F_Sf  {
  unsigned int v1:17;
  float v2;
  ::empty v3;
};
//SIG(1 BFu17i_F_Sf) C1{ Fi:17 Fi FC2{}}



static void Test_BFu17i_F_Sf()
{
  {
    init_simple_test("BFu17i_F_Sf");
    static BFu17i_F_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu17i_F_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_F_Sf");
    check_field_offset(lv, v2, 4, "BFu17i_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu17i_F_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_F_Sf(Test_BFu17i_F_Sf, "BFu17i_F_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_I_Sf  {
  unsigned int v1:17;
  int v2;
  ::empty v3;
};
//SIG(1 BFu17i_I_Sf) C1{ Fi:17 Fi FC2{}}



static void Test_BFu17i_I_Sf()
{
  {
    init_simple_test("BFu17i_I_Sf");
    static BFu17i_I_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu17i_I_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_I_Sf");
    check_field_offset(lv, v2, 4, "BFu17i_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu17i_I_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_I_Sf(Test_BFu17i_I_Sf, "BFu17i_I_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Ip_Sf  {
  unsigned int v1:17;
  int *v2;
  ::empty v3;
};
//SIG(1 BFu17i_Ip_Sf) C1{ Fi:17 Fp FC2{}}



static void Test_BFu17i_Ip_Sf()
{
  {
    init_simple_test("BFu17i_Ip_Sf");
    static BFu17i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17i_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Ip_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17i_Ip_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Ip_Sf(Test_BFu17i_Ip_Sf, "BFu17i_Ip_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_L_Sf  {
  unsigned int v1:17;
  __tsi64 v2;
  ::empty v3;
};
//SIG(1 BFu17i_L_Sf) C1{ Fi:17 FL FC2{}}



static void Test_BFu17i_L_Sf()
{
  {
    init_simple_test("BFu17i_L_Sf");
    static BFu17i_L_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17i_L_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_L_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17i_L_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17i_L_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_L_Sf(Test_BFu17i_L_Sf, "BFu17i_L_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_S_Sf  {
  unsigned int v1:17;
  short v2;
  ::empty v3;
};
//SIG(1 BFu17i_S_Sf) C1{ Fi:17 Fs FC2{}}



static void Test_BFu17i_S_Sf()
{
  {
    init_simple_test("BFu17i_S_Sf");
    static BFu17i_S_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_S_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_S_Sf");
    check_field_offset(lv, v2, 4, "BFu17i_S_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu17i_S_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_S_Sf(Test_BFu17i_S_Sf, "BFu17i_S_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf  {
  unsigned int v1:17;
  ::empty v2;
};
//SIG(1 BFu17i_Sf) C1{ Fi:17 FC2{}}



static void Test_BFu17i_Sf()
{
  {
    init_simple_test("BFu17i_Sf");
    static BFu17i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu17i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf");
    check_field_offset(lv, v2, 3, "BFu17i_Sf.v2");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf(Test_BFu17i_Sf, "BFu17i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu15i  {
  unsigned int v1:17;
  ::empty v2;
  unsigned int v3:15;
};
//SIG(1 BFu17i_Sf_BFu15i) C1{ Fi:17 FC2{} Fi:15}



static void Test_BFu17i_Sf_BFu15i()
{
  {
    init_simple_test("BFu17i_Sf_BFu15i");
    static BFu17i_Sf_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu15i");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17i_Sf_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu15i(Test_BFu17i_Sf_BFu15i, "BFu17i_Sf_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu15ll  {
  unsigned int v1:17;
  ::empty v2;
  __tsu64 v3:15;
};
//SIG(1 BFu17i_Sf_BFu15ll) C1{ Fi:17 FC2{} FL:15}



static void Test_BFu17i_Sf_BFu15ll()
{
  {
    init_simple_test("BFu17i_Sf_BFu15ll");
    static BFu17i_Sf_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu15ll");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17i_Sf_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu15ll(Test_BFu17i_Sf_BFu15ll, "BFu17i_Sf_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu15s  {
  unsigned int v1:17;
  ::empty v2;
  unsigned short v3:15;
};
//SIG(1 BFu17i_Sf_BFu15s) C1{ Fi:17 FC2{} Fs:15}



static void Test_BFu17i_Sf_BFu15s()
{
  {
    init_simple_test("BFu17i_Sf_BFu15s");
    static BFu17i_Sf_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu15s");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17i_Sf_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu15s(Test_BFu17i_Sf_BFu15s, "BFu17i_Sf_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu16i  {
  unsigned int v1:17;
  ::empty v2;
  unsigned int v3:16;
};
//SIG(1 BFu17i_Sf_BFu16i) C1{ Fi:17 FC2{} Fi:16}



static void Test_BFu17i_Sf_BFu16i()
{
  {
    init_simple_test("BFu17i_Sf_BFu16i");
    static BFu17i_Sf_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu16i");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17i_Sf_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu16i(Test_BFu17i_Sf_BFu16i, "BFu17i_Sf_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu16ll  {
  unsigned int v1:17;
  ::empty v2;
  __tsu64 v3:16;
};
//SIG(1 BFu17i_Sf_BFu16ll) C1{ Fi:17 FC2{} FL:16}



static void Test_BFu17i_Sf_BFu16ll()
{
  {
    init_simple_test("BFu17i_Sf_BFu16ll");
    static BFu17i_Sf_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu16ll");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17i_Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu16ll(Test_BFu17i_Sf_BFu16ll, "BFu17i_Sf_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu16s  {
  unsigned int v1:17;
  ::empty v2;
  unsigned short v3:16;
};
//SIG(1 BFu17i_Sf_BFu16s) C1{ Fi:17 FC2{} Fs:16}



static void Test_BFu17i_Sf_BFu16s()
{
  {
    init_simple_test("BFu17i_Sf_BFu16s");
    static BFu17i_Sf_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu16s");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17i_Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu16s(Test_BFu17i_Sf_BFu16s, "BFu17i_Sf_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu17i  {
  unsigned int v1:17;
  ::empty v2;
  unsigned int v3:17;
};
//SIG(1 BFu17i_Sf_BFu17i) C1{ Fi:17 FC2{} Fi:17}



static void Test_BFu17i_Sf_BFu17i()
{
  {
    init_simple_test("BFu17i_Sf_BFu17i");
    static BFu17i_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu17i");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu17i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu17i(Test_BFu17i_Sf_BFu17i, "BFu17i_Sf_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu17ll  {
  unsigned int v1:17;
  ::empty v2;
  __tsu64 v3:17;
};
//SIG(1 BFu17i_Sf_BFu17ll) C1{ Fi:17 FC2{} FL:17}



static void Test_BFu17i_Sf_BFu17ll()
{
  {
    init_simple_test("BFu17i_Sf_BFu17ll");
    static BFu17i_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu17ll");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu17i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu17ll(Test_BFu17i_Sf_BFu17ll, "BFu17i_Sf_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu1c  {
  unsigned int v1:17;
  ::empty v2;
  unsigned char v3:1;
};
//SIG(1 BFu17i_Sf_BFu1c) C1{ Fi:17 FC2{} Fc:1}



static void Test_BFu17i_Sf_BFu1c()
{
  {
    init_simple_test("BFu17i_Sf_BFu1c");
    static BFu17i_Sf_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu1c");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17i_Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu1c(Test_BFu17i_Sf_BFu1c, "BFu17i_Sf_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu1i  {
  unsigned int v1:17;
  ::empty v2;
  unsigned int v3:1;
};
//SIG(1 BFu17i_Sf_BFu1i) C1{ Fi:17 FC2{} Fi:1}



static void Test_BFu17i_Sf_BFu1i()
{
  {
    init_simple_test("BFu17i_Sf_BFu1i");
    static BFu17i_Sf_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu1i");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17i_Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu1i(Test_BFu17i_Sf_BFu1i, "BFu17i_Sf_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu1ll  {
  unsigned int v1:17;
  ::empty v2;
  __tsu64 v3:1;
};
//SIG(1 BFu17i_Sf_BFu1ll) C1{ Fi:17 FC2{} FL:1}



static void Test_BFu17i_Sf_BFu1ll()
{
  {
    init_simple_test("BFu17i_Sf_BFu1ll");
    static BFu17i_Sf_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu1ll");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17i_Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu1ll(Test_BFu17i_Sf_BFu1ll, "BFu17i_Sf_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu1s  {
  unsigned int v1:17;
  ::empty v2;
  unsigned short v3:1;
};
//SIG(1 BFu17i_Sf_BFu1s) C1{ Fi:17 FC2{} Fs:1}



static void Test_BFu17i_Sf_BFu1s()
{
  {
    init_simple_test("BFu17i_Sf_BFu1s");
    static BFu17i_Sf_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu1s");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17i_Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu1s(Test_BFu17i_Sf_BFu1s, "BFu17i_Sf_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu31i  {
  unsigned int v1:17;
  ::empty v2;
  unsigned int v3:31;
};
//SIG(1 BFu17i_Sf_BFu31i) C1{ Fi:17 FC2{} Fi:31}



static void Test_BFu17i_Sf_BFu31i()
{
  {
    init_simple_test("BFu17i_Sf_BFu31i");
    static BFu17i_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu31i");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu17i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu17i_Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu31i(Test_BFu17i_Sf_BFu31i, "BFu17i_Sf_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu31ll  {
  unsigned int v1:17;
  ::empty v2;
  __tsu64 v3:31;
};
//SIG(1 BFu17i_Sf_BFu31ll) C1{ Fi:17 FC2{} FL:31}



static void Test_BFu17i_Sf_BFu31ll()
{
  {
    init_simple_test("BFu17i_Sf_BFu31ll");
    static BFu17i_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu31ll");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu17i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu17i_Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu31ll(Test_BFu17i_Sf_BFu31ll, "BFu17i_Sf_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu32i  {
  unsigned int v1:17;
  ::empty v2;
  unsigned int v3:32;
};
//SIG(1 BFu17i_Sf_BFu32i) C1{ Fi:17 FC2{} Fi:32}



static void Test_BFu17i_Sf_BFu32i()
{
  {
    init_simple_test("BFu17i_Sf_BFu32i");
    static BFu17i_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu32i");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu17i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu17i_Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu32i(Test_BFu17i_Sf_BFu32i, "BFu17i_Sf_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu32ll  {
  unsigned int v1:17;
  ::empty v2;
  __tsu64 v3:32;
};
//SIG(1 BFu17i_Sf_BFu32ll) C1{ Fi:17 FC2{} FL:32}



static void Test_BFu17i_Sf_BFu32ll()
{
  {
    init_simple_test("BFu17i_Sf_BFu32ll");
    static BFu17i_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu32ll");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu17i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu17i_Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu32ll(Test_BFu17i_Sf_BFu32ll, "BFu17i_Sf_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu33  {
  unsigned int v1:17;
  ::empty v2;
  __tsu64 v3:33;
};
//SIG(1 BFu17i_Sf_BFu33) C1{ Fi:17 FC2{} FL:33}



static void Test_BFu17i_Sf_BFu33()
{
  {
    init_simple_test("BFu17i_Sf_BFu33");
    static BFu17i_Sf_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17i_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu33");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "BFu17i_Sf_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu17i_Sf_BFu33");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu33(Test_BFu17i_Sf_BFu33, "BFu17i_Sf_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu7c  {
  unsigned int v1:17;
  ::empty v2;
  unsigned char v3:7;
};
//SIG(1 BFu17i_Sf_BFu7c) C1{ Fi:17 FC2{} Fc:7}



static void Test_BFu17i_Sf_BFu7c()
{
  {
    init_simple_test("BFu17i_Sf_BFu7c");
    static BFu17i_Sf_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu7c");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17i_Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu7c(Test_BFu17i_Sf_BFu7c, "BFu17i_Sf_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu7i  {
  unsigned int v1:17;
  ::empty v2;
  unsigned int v3:7;
};
//SIG(1 BFu17i_Sf_BFu7i) C1{ Fi:17 FC2{} Fi:7}



static void Test_BFu17i_Sf_BFu7i()
{
  {
    init_simple_test("BFu17i_Sf_BFu7i");
    static BFu17i_Sf_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu7i");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17i_Sf_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu7i(Test_BFu17i_Sf_BFu7i, "BFu17i_Sf_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu7ll  {
  unsigned int v1:17;
  ::empty v2;
  __tsu64 v3:7;
};
//SIG(1 BFu17i_Sf_BFu7ll) C1{ Fi:17 FC2{} FL:7}



static void Test_BFu17i_Sf_BFu7ll()
{
  {
    init_simple_test("BFu17i_Sf_BFu7ll");
    static BFu17i_Sf_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu7ll");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17i_Sf_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu7ll(Test_BFu17i_Sf_BFu7ll, "BFu17i_Sf_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu7s  {
  unsigned int v1:17;
  ::empty v2;
  unsigned short v3:7;
};
//SIG(1 BFu17i_Sf_BFu7s) C1{ Fi:17 FC2{} Fs:7}



static void Test_BFu17i_Sf_BFu7s()
{
  {
    init_simple_test("BFu17i_Sf_BFu7s");
    static BFu17i_Sf_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu7s");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17i_Sf_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu7s(Test_BFu17i_Sf_BFu7s, "BFu17i_Sf_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu8c  {
  unsigned int v1:17;
  ::empty v2;
  unsigned char v3:8;
};
//SIG(1 BFu17i_Sf_BFu8c) C1{ Fi:17 FC2{} Fc:8}



static void Test_BFu17i_Sf_BFu8c()
{
  {
    init_simple_test("BFu17i_Sf_BFu8c");
    static BFu17i_Sf_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu8c");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17i_Sf_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu8c(Test_BFu17i_Sf_BFu8c, "BFu17i_Sf_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu8i  {
  unsigned int v1:17;
  ::empty v2;
  unsigned int v3:8;
};
//SIG(1 BFu17i_Sf_BFu8i) C1{ Fi:17 FC2{} Fi:8}



static void Test_BFu17i_Sf_BFu8i()
{
  {
    init_simple_test("BFu17i_Sf_BFu8i");
    static BFu17i_Sf_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu8i");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17i_Sf_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17i_Sf_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu8i(Test_BFu17i_Sf_BFu8i, "BFu17i_Sf_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu8ll  {
  unsigned int v1:17;
  ::empty v2;
  __tsu64 v3:8;
};
//SIG(1 BFu17i_Sf_BFu8ll) C1{ Fi:17 FC2{} FL:8}



static void Test_BFu17i_Sf_BFu8ll()
{
  {
    init_simple_test("BFu17i_Sf_BFu8ll");
    static BFu17i_Sf_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu8ll");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17i_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17i_Sf_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu8ll(Test_BFu17i_Sf_BFu8ll, "BFu17i_Sf_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu8s  {
  unsigned int v1:17;
  ::empty v2;
  unsigned short v3:8;
};
//SIG(1 BFu17i_Sf_BFu8s) C1{ Fi:17 FC2{} Fs:8}



static void Test_BFu17i_Sf_BFu8s()
{
  {
    init_simple_test("BFu17i_Sf_BFu8s");
    static BFu17i_Sf_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu8s");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17i_Sf_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17i_Sf_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu8s(Test_BFu17i_Sf_BFu8s, "BFu17i_Sf_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu9i  {
  unsigned int v1:17;
  ::empty v2;
  unsigned int v3:9;
};
//SIG(1 BFu17i_Sf_BFu9i) C1{ Fi:17 FC2{} Fi:9}



static void Test_BFu17i_Sf_BFu9i()
{
  {
    init_simple_test("BFu17i_Sf_BFu9i");
    static BFu17i_Sf_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu9i");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17i_Sf_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17i_Sf_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu9i(Test_BFu17i_Sf_BFu9i, "BFu17i_Sf_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu9ll  {
  unsigned int v1:17;
  ::empty v2;
  __tsu64 v3:9;
};
//SIG(1 BFu17i_Sf_BFu9ll) C1{ Fi:17 FC2{} FL:9}



static void Test_BFu17i_Sf_BFu9ll()
{
  {
    init_simple_test("BFu17i_Sf_BFu9ll");
    static BFu17i_Sf_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu9ll");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17i_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17i_Sf_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu9ll(Test_BFu17i_Sf_BFu9ll, "BFu17i_Sf_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_BFu9s  {
  unsigned int v1:17;
  ::empty v2;
  unsigned short v3:9;
};
//SIG(1 BFu17i_Sf_BFu9s) C1{ Fi:17 FC2{} Fs:9}



static void Test_BFu17i_Sf_BFu9s()
{
  {
    init_simple_test("BFu17i_Sf_BFu9s");
    static BFu17i_Sf_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_BFu9s");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17i_Sf_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17i_Sf_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_BFu9s(Test_BFu17i_Sf_BFu9s, "BFu17i_Sf_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_C  {
  unsigned int v1:17;
  ::empty v2;
  char v3;
};
//SIG(1 BFu17i_Sf_C) C1{ Fi:17 FC2{} Fc}



static void Test_BFu17i_Sf_C()
{
  {
    init_simple_test("BFu17i_Sf_C");
    static BFu17i_Sf_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_C");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_C.v2");
    check_field_offset(lv, v3, 4, "BFu17i_Sf_C.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_C(Test_BFu17i_Sf_C, "BFu17i_Sf_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_D  {
  unsigned int v1:17;
  ::empty v2;
  double v3;
};
//SIG(1 BFu17i_Sf_D) C1{ Fi:17 FC2{} FL}



static void Test_BFu17i_Sf_D()
{
  {
    init_simple_test("BFu17i_Sf_D");
    static BFu17i_Sf_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17i_Sf_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_D");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17i_Sf_D.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_D(Test_BFu17i_Sf_D, "BFu17i_Sf_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_F  {
  unsigned int v1:17;
  ::empty v2;
  float v3;
};
//SIG(1 BFu17i_Sf_F) C1{ Fi:17 FC2{} Fi}



static void Test_BFu17i_Sf_F()
{
  {
    init_simple_test("BFu17i_Sf_F");
    static BFu17i_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_F");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu17i_Sf_F.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_F(Test_BFu17i_Sf_F, "BFu17i_Sf_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_I  {
  unsigned int v1:17;
  ::empty v2;
  int v3;
};
//SIG(1 BFu17i_Sf_I) C1{ Fi:17 FC2{} Fi}



static void Test_BFu17i_Sf_I()
{
  {
    init_simple_test("BFu17i_Sf_I");
    static BFu17i_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_I");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu17i_Sf_I.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_I(Test_BFu17i_Sf_I, "BFu17i_Sf_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_Ip  {
  unsigned int v1:17;
  ::empty v2;
  int *v3;
};
//SIG(1 BFu17i_Sf_Ip) C1{ Fi:17 FC2{} Fp}



static void Test_BFu17i_Sf_Ip()
{
  {
    init_simple_test("BFu17i_Sf_Ip");
    static BFu17i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17i_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_Ip");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17i_Sf_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_Ip(Test_BFu17i_Sf_Ip, "BFu17i_Sf_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_L  {
  unsigned int v1:17;
  ::empty v2;
  __tsi64 v3;
};
//SIG(1 BFu17i_Sf_L) C1{ Fi:17 FC2{} FL}



static void Test_BFu17i_Sf_L()
{
  {
    init_simple_test("BFu17i_Sf_L");
    static BFu17i_Sf_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17i_Sf_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_L");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17i_Sf_L.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_L(Test_BFu17i_Sf_L, "BFu17i_Sf_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_S  {
  unsigned int v1:17;
  ::empty v2;
  short v3;
};
//SIG(1 BFu17i_Sf_S) C1{ Fi:17 FC2{} Fs}



static void Test_BFu17i_Sf_S()
{
  {
    init_simple_test("BFu17i_Sf_S");
    static BFu17i_Sf_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_S");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_S.v2");
    check_field_offset(lv, v3, 4, "BFu17i_Sf_S.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_S(Test_BFu17i_Sf_S, "BFu17i_Sf_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_Sf  {
  unsigned int v1:17;
  ::empty v2;
  ::empty v3;
};
//SIG(1 BFu17i_Sf_Sf) C1{ Fi:17 FC2{} FC2}



static void Test_BFu17i_Sf_Sf()
{
  {
    init_simple_test("BFu17i_Sf_Sf");
    static BFu17i_Sf_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_Sf");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu17i_Sf_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_Sf(Test_BFu17i_Sf_Sf, "BFu17i_Sf_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_Uc  {
  unsigned int v1:17;
  ::empty v2;
  unsigned char v3;
};
//SIG(1 BFu17i_Sf_Uc) C1{ Fi:17 FC2{} Fc}



static void Test_BFu17i_Sf_Uc()
{
  {
    init_simple_test("BFu17i_Sf_Uc");
    static BFu17i_Sf_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_Uc");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_Uc.v2");
    check_field_offset(lv, v3, 4, "BFu17i_Sf_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_Uc(Test_BFu17i_Sf_Uc, "BFu17i_Sf_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_Ui  {
  unsigned int v1:17;
  ::empty v2;
  unsigned int v3;
};
//SIG(1 BFu17i_Sf_Ui) C1{ Fi:17 FC2{} Fi}



static void Test_BFu17i_Sf_Ui()
{
  {
    init_simple_test("BFu17i_Sf_Ui");
    static BFu17i_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_Ui");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu17i_Sf_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_Ui(Test_BFu17i_Sf_Ui, "BFu17i_Sf_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_Ul  {
  unsigned int v1:17;
  ::empty v2;
  __tsu64 v3;
};
//SIG(1 BFu17i_Sf_Ul) C1{ Fi:17 FC2{} FL}



static void Test_BFu17i_Sf_Ul()
{
  {
    init_simple_test("BFu17i_Sf_Ul");
    static BFu17i_Sf_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17i_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_Ul");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17i_Sf_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_Ul(Test_BFu17i_Sf_Ul, "BFu17i_Sf_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_Us  {
  unsigned int v1:17;
  ::empty v2;
  unsigned short v3;
};
//SIG(1 BFu17i_Sf_Us) C1{ Fi:17 FC2{} Fs}



static void Test_BFu17i_Sf_Us()
{
  {
    init_simple_test("BFu17i_Sf_Us");
    static BFu17i_Sf_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Sf_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_Us");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_Us.v2");
    check_field_offset(lv, v3, 4, "BFu17i_Sf_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_Us(Test_BFu17i_Sf_Us, "BFu17i_Sf_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Sf_Vp  {
  unsigned int v1:17;
  ::empty v2;
  void *v3;
};
//SIG(1 BFu17i_Sf_Vp) C1{ Fi:17 FC2{} Fp}



static void Test_BFu17i_Sf_Vp()
{
  {
    init_simple_test("BFu17i_Sf_Vp");
    static BFu17i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17i_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Sf_Vp");
    check_field_offset(lv, v2, 3, "BFu17i_Sf_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17i_Sf_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Sf_Vp(Test_BFu17i_Sf_Vp, "BFu17i_Sf_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Uc_Sf  {
  unsigned int v1:17;
  unsigned char v2;
  ::empty v3;
};
//SIG(1 BFu17i_Uc_Sf) C1{ Fi:17 Fc FC2{}}



static void Test_BFu17i_Uc_Sf()
{
  {
    init_simple_test("BFu17i_Uc_Sf");
    static BFu17i_Uc_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Uc_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Uc_Sf");
    check_field_offset(lv, v2, 3, "BFu17i_Uc_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu17i_Uc_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Uc_Sf(Test_BFu17i_Uc_Sf, "BFu17i_Uc_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Ui_Sf  {
  unsigned int v1:17;
  unsigned int v2;
  ::empty v3;
};
//SIG(1 BFu17i_Ui_Sf) C1{ Fi:17 Fi FC2{}}



static void Test_BFu17i_Ui_Sf()
{
  {
    init_simple_test("BFu17i_Ui_Sf");
    static BFu17i_Ui_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu17i_Ui_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu17i_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu17i_Ui_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Ui_Sf(Test_BFu17i_Ui_Sf, "BFu17i_Ui_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Ul_Sf  {
  unsigned int v1:17;
  __tsu64 v2;
  ::empty v3;
};
//SIG(1 BFu17i_Ul_Sf) C1{ Fi:17 FL FC2{}}



static void Test_BFu17i_Ul_Sf()
{
  {
    init_simple_test("BFu17i_Ul_Sf");
    static BFu17i_Ul_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17i_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Ul_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17i_Ul_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17i_Ul_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Ul_Sf(Test_BFu17i_Ul_Sf, "BFu17i_Ul_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Us_Sf  {
  unsigned int v1:17;
  unsigned short v2;
  ::empty v3;
};
//SIG(1 BFu17i_Us_Sf) C1{ Fi:17 Fs FC2{}}



static void Test_BFu17i_Us_Sf()
{
  {
    init_simple_test("BFu17i_Us_Sf");
    static BFu17i_Us_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17i_Us_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu17i_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Us_Sf");
    check_field_offset(lv, v2, 4, "BFu17i_Us_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu17i_Us_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Us_Sf(Test_BFu17i_Us_Sf, "BFu17i_Us_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17i_Vp_Sf  {
  unsigned int v1:17;
  void *v2;
  ::empty v3;
};
//SIG(1 BFu17i_Vp_Sf) C1{ Fi:17 Fp FC2{}}



static void Test_BFu17i_Vp_Sf()
{
  {
    init_simple_test("BFu17i_Vp_Sf");
    static BFu17i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17i_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17i_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17i_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17i_Vp_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17i_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17i_Vp_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17i_Vp_Sf(Test_BFu17i_Vp_Sf, "BFu17i_Vp_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu15i_Sf  {
  __tsu64 v1:17;
  unsigned int v2:15;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu15i_Sf) C1{ FL:17 Fi:15 FC2{}}



static void Test_BFu17ll_BFu15i_Sf()
{
  {
    init_simple_test("BFu17ll_BFu15i_Sf");
    static BFu17ll_BFu15i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu15i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15i_Sf");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu15i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu15i_Sf(Test_BFu17ll_BFu15i_Sf, "BFu17ll_BFu15i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu15ll_Sf  {
  __tsu64 v1:17;
  __tsu64 v2:15;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu15ll_Sf) C1{ FL:17 FL:15 FC2{}}



static void Test_BFu17ll_BFu15ll_Sf()
{
  {
    init_simple_test("BFu17ll_BFu15ll_Sf");
    static BFu17ll_BFu15ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15ll_Sf");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu15ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu15ll_Sf(Test_BFu17ll_BFu15ll_Sf, "BFu17ll_BFu15ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu15s_Sf  {
  __tsu64 v1:17;
  unsigned short v2:15;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu15s_Sf) C1{ FL:17 Fs:15 FC2{}}



static void Test_BFu17ll_BFu15s_Sf()
{
  {
    init_simple_test("BFu17ll_BFu15s_Sf");
    static BFu17ll_BFu15s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu15s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, 1, "BFu17ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 15, hide_ull(1LL<<14), "BFu17ll_BFu15s_Sf");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu15s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu15s_Sf(Test_BFu17ll_BFu15s_Sf, "BFu17ll_BFu15s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu16i_Sf  {
  __tsu64 v1:17;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu16i_Sf) C1{ FL:17 Fi:16 FC2{}}



static void Test_BFu17ll_BFu16i_Sf()
{
  {
    init_simple_test("BFu17ll_BFu16i_Sf");
    static BFu17ll_BFu16i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu16i_Sf");
    check_field_offset(lv, v3, 6, "BFu17ll_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu16i_Sf(Test_BFu17ll_BFu16i_Sf, "BFu17ll_BFu16i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu16ll_Sf  {
  __tsu64 v1:17;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu16ll_Sf) C1{ FL:17 FL:16 FC2{}}



static void Test_BFu17ll_BFu16ll_Sf()
{
  {
    init_simple_test("BFu17ll_BFu16ll_Sf");
    static BFu17ll_BFu16ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, 1, "BFu17ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 16, hide_ull(1LL<<15), "BFu17ll_BFu16ll_Sf");
    check_field_offset(lv, v3, 5, "BFu17ll_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu16ll_Sf(Test_BFu17ll_BFu16ll_Sf, "BFu17ll_BFu16ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu16s_Sf  {
  __tsu64 v1:17;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu16s_Sf) C1{ FL:17 Fs:16 FC2{}}



static void Test_BFu17ll_BFu16s_Sf()
{
  {
    init_simple_test("BFu17ll_BFu16s_Sf");
    static BFu17ll_BFu16s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu16s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu17ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_BFu16s_Sf");
    check_field_offset(lv, v3, 6, "BFu17ll_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu16s_Sf(Test_BFu17ll_BFu16s_Sf, "BFu17ll_BFu16s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu17i_Sf  {
  __tsu64 v1:17;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu17i_Sf) C1{ FL:17 Fi:17 FC2{}}



static void Test_BFu17ll_BFu17i_Sf()
{
  {
    init_simple_test("BFu17ll_BFu17i_Sf");
    static BFu17ll_BFu17i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu17i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu17ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17i_Sf");
    check_field_offset(lv, v3, 7, "BFu17ll_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu17i_Sf(Test_BFu17ll_BFu17i_Sf, "BFu17ll_BFu17i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu17ll_Sf  {
  __tsu64 v1:17;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu17ll_Sf) C1{ FL:17 FL:17 FC2{}}



static void Test_BFu17ll_BFu17ll_Sf()
{
  {
    init_simple_test("BFu17ll_BFu17ll_Sf");
    static BFu17ll_BFu17ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 17, 1, "BFu17ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 17, hide_ull(1LL<<16), "BFu17ll_BFu17ll_Sf");
    check_field_offset(lv, v3, 5, "BFu17ll_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu17ll_Sf(Test_BFu17ll_BFu17ll_Sf, "BFu17ll_BFu17ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu1c_Sf  {
  __tsu64 v1:17;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu1c_Sf) C1{ FL:17 Fc:1 FC2{}}



static void Test_BFu17ll_BFu1c_Sf()
{
  {
    init_simple_test("BFu17ll_BFu1c_Sf");
    static BFu17ll_BFu1c_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1c_Sf");
    check_field_offset(lv, v3, 3, "BFu17ll_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu1c_Sf(Test_BFu17ll_BFu1c_Sf, "BFu17ll_BFu1c_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu1i_Sf  {
  __tsu64 v1:17;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu1i_Sf) C1{ FL:17 Fi:1 FC2{}}



static void Test_BFu17ll_BFu1i_Sf()
{
  {
    init_simple_test("BFu17ll_BFu1i_Sf");
    static BFu17ll_BFu1i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1i_Sf");
    check_field_offset(lv, v3, 3, "BFu17ll_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu1i_Sf(Test_BFu17ll_BFu1i_Sf, "BFu17ll_BFu1i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu1ll_Sf  {
  __tsu64 v1:17;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu1ll_Sf) C1{ FL:17 FL:1 FC2{}}



static void Test_BFu17ll_BFu1ll_Sf()
{
  {
    init_simple_test("BFu17ll_BFu1ll_Sf");
    static BFu17ll_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1ll_Sf");
    check_field_offset(lv, v3, 3, "BFu17ll_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu1ll_Sf(Test_BFu17ll_BFu1ll_Sf, "BFu17ll_BFu1ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu1s_Sf  {
  __tsu64 v1:17;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu1s_Sf) C1{ FL:17 Fs:1 FC2{}}



static void Test_BFu17ll_BFu1s_Sf()
{
  {
    init_simple_test("BFu17ll_BFu1s_Sf");
    static BFu17ll_BFu1s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu1s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu1s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 1, 1, "BFu17ll_BFu1s_Sf");
    check_field_offset(lv, v3, 3, "BFu17ll_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu1s_Sf(Test_BFu17ll_BFu1s_Sf, "BFu17ll_BFu1s_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu31i_Sf  {
  __tsu64 v1:17;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu31i_Sf) C1{ FL:17 Fi:31 FC2{}}



static void Test_BFu17ll_BFu31i_Sf()
{
  {
    init_simple_test("BFu17ll_BFu31i_Sf");
    static BFu17ll_BFu31i_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu31i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu17ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "BFu17ll_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu31i_Sf(Test_BFu17ll_BFu31i_Sf, "BFu17ll_BFu31i_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu31ll_Sf  {
  __tsu64 v1:17;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu31ll_Sf) C1{ FL:17 FL:31 FC2{}}



static void Test_BFu17ll_BFu31ll_Sf()
{
  {
    init_simple_test("BFu17ll_BFu31ll_Sf");
    static BFu17ll_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 31, 1, "BFu17ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 31, hide_ull(1LL<<30), "BFu17ll_BFu31ll_Sf");
    check_field_offset(lv, v3, 6, "BFu17ll_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu31ll_Sf(Test_BFu17ll_BFu31ll_Sf, "BFu17ll_BFu31ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu32i_Sf  {
  __tsu64 v1:17;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu32i_Sf) C1{ FL:17 Fi:32 FC2{}}



static void Test_BFu17ll_BFu32i_Sf()
{
  {
    init_simple_test("BFu17ll_BFu32i_Sf");
    static BFu17ll_BFu32i_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_BFu32i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu17ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu17ll_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu32i_Sf(Test_BFu17ll_BFu32i_Sf, "BFu17ll_BFu32i_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu32ll_Sf  {
  __tsu64 v1:17;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu32ll_Sf) C1{ FL:17 FL:32 FC2{}}



static void Test_BFu17ll_BFu32ll_Sf()
{
  {
    init_simple_test("BFu17ll_BFu32ll_Sf");
    static BFu17ll_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 32, 1, "BFu17ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 32, hide_ull(1LL<<31), "BFu17ll_BFu32ll_Sf");
    check_field_offset(lv, v3, 7, "BFu17ll_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu32ll_Sf(Test_BFu17ll_BFu32ll_Sf, "BFu17ll_BFu32ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu33_Sf  {
  __tsu64 v1:17;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu33_Sf) C1{ FL:17 FL:33 FC2{}}



static void Test_BFu17ll_BFu33_Sf()
{
  {
    init_simple_test("BFu17ll_BFu33_Sf");
    static BFu17ll_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 1, 33, 1, "BFu17ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 2, 1, 33, hide_ull(1LL<<32), "BFu17ll_BFu33_Sf");
    check_field_offset(lv, v3, 7, "BFu17ll_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu33_Sf(Test_BFu17ll_BFu33_Sf, "BFu17ll_BFu33_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu7c_Sf  {
  __tsu64 v1:17;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu7c_Sf) C1{ FL:17 Fc:7 FC2{}}



static void Test_BFu17ll_BFu7c_Sf()
{
  {
    init_simple_test("BFu17ll_BFu7c_Sf");
    static BFu17ll_BFu7c_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7c_Sf");
    check_field_offset(lv, v3, 3, "BFu17ll_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu7c_Sf(Test_BFu17ll_BFu7c_Sf, "BFu17ll_BFu7c_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu7i_Sf  {
  __tsu64 v1:17;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu7i_Sf) C1{ FL:17 Fi:7 FC2{}}



static void Test_BFu17ll_BFu7i_Sf()
{
  {
    init_simple_test("BFu17ll_BFu7i_Sf");
    static BFu17ll_BFu7i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7i_Sf");
    check_field_offset(lv, v3, 3, "BFu17ll_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu7i_Sf(Test_BFu17ll_BFu7i_Sf, "BFu17ll_BFu7i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu7ll_Sf  {
  __tsu64 v1:17;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu7ll_Sf) C1{ FL:17 FL:7 FC2{}}



static void Test_BFu17ll_BFu7ll_Sf()
{
  {
    init_simple_test("BFu17ll_BFu7ll_Sf");
    static BFu17ll_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7ll_Sf");
    check_field_offset(lv, v3, 3, "BFu17ll_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu7ll_Sf(Test_BFu17ll_BFu7ll_Sf, "BFu17ll_BFu7ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu7s_Sf  {
  __tsu64 v1:17;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu7s_Sf) C1{ FL:17 Fs:7 FC2{}}



static void Test_BFu17ll_BFu7s_Sf()
{
  {
    init_simple_test("BFu17ll_BFu7s_Sf");
    static BFu17ll_BFu7s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_BFu7s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, 1, "BFu17ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 7, hide_ull(1LL<<6), "BFu17ll_BFu7s_Sf");
    check_field_offset(lv, v3, 3, "BFu17ll_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu7s_Sf(Test_BFu17ll_BFu7s_Sf, "BFu17ll_BFu7s_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu8c_Sf  {
  __tsu64 v1:17;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu8c_Sf) C1{ FL:17 Fc:8 FC2{}}



static void Test_BFu17ll_BFu8c_Sf()
{
  {
    init_simple_test("BFu17ll_BFu8c_Sf");
    static BFu17ll_BFu8c_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 3, 0, 8, 1, "BFu17ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 3, 0, 8, hide_ull(1LL<<7), "BFu17ll_BFu8c_Sf");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu8c_Sf(Test_BFu17ll_BFu8c_Sf, "BFu17ll_BFu8c_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu8i_Sf  {
  __tsu64 v1:17;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu8i_Sf) C1{ FL:17 Fi:8 FC2{}}



static void Test_BFu17ll_BFu8i_Sf()
{
  {
    init_simple_test("BFu17ll_BFu8i_Sf");
    static BFu17ll_BFu8i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8i_Sf");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu8i_Sf(Test_BFu17ll_BFu8i_Sf, "BFu17ll_BFu8i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu8ll_Sf  {
  __tsu64 v1:17;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu8ll_Sf) C1{ FL:17 FL:8 FC2{}}



static void Test_BFu17ll_BFu8ll_Sf()
{
  {
    init_simple_test("BFu17ll_BFu8ll_Sf");
    static BFu17ll_BFu8ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8ll_Sf");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu8ll_Sf(Test_BFu17ll_BFu8ll_Sf, "BFu17ll_BFu8ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu8s_Sf  {
  __tsu64 v1:17;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu8s_Sf) C1{ FL:17 Fs:8 FC2{}}



static void Test_BFu17ll_BFu8s_Sf()
{
  {
    init_simple_test("BFu17ll_BFu8s_Sf");
    static BFu17ll_BFu8s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu8s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, 1, "BFu17ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 8, hide_ull(1LL<<7), "BFu17ll_BFu8s_Sf");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu8s_Sf(Test_BFu17ll_BFu8s_Sf, "BFu17ll_BFu8s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu9i_Sf  {
  __tsu64 v1:17;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu9i_Sf) C1{ FL:17 Fi:9 FC2{}}



static void Test_BFu17ll_BFu9i_Sf()
{
  {
    init_simple_test("BFu17ll_BFu9i_Sf");
    static BFu17ll_BFu9i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9i_Sf");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu9i_Sf(Test_BFu17ll_BFu9i_Sf, "BFu17ll_BFu9i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu9ll_Sf  {
  __tsu64 v1:17;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu9ll_Sf) C1{ FL:17 FL:9 FC2{}}



static void Test_BFu17ll_BFu9ll_Sf()
{
  {
    init_simple_test("BFu17ll_BFu9ll_Sf");
    static BFu17ll_BFu9ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9ll_Sf");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu9ll_Sf(Test_BFu17ll_BFu9ll_Sf, "BFu17ll_BFu9ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_BFu9s_Sf  {
  __tsu64 v1:17;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 BFu17ll_BFu9s_Sf) C1{ FL:17 Fs:9 FC2{}}



static void Test_BFu17ll_BFu9s_Sf()
{
  {
    init_simple_test("BFu17ll_BFu9s_Sf");
    static BFu17ll_BFu9s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_BFu9s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, 1, "BFu17ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 2, 1, 9, hide_ull(1LL<<8), "BFu17ll_BFu9s_Sf");
    check_field_offset(lv, v3, 4, "BFu17ll_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_BFu9s_Sf(Test_BFu17ll_BFu9s_Sf, "BFu17ll_BFu9s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_C_Sf  {
  __tsu64 v1:17;
  char v2;
  ::empty v3;
};
//SIG(1 BFu17ll_C_Sf) C1{ FL:17 Fc FC2{}}



static void Test_BFu17ll_C_Sf()
{
  {
    init_simple_test("BFu17ll_C_Sf");
    static BFu17ll_C_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_C_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_C_Sf");
    check_field_offset(lv, v2, 3, "BFu17ll_C_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_C_Sf(Test_BFu17ll_C_Sf, "BFu17ll_C_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_D_Sf  {
  __tsu64 v1:17;
  double v2;
  ::empty v3;
};
//SIG(1 BFu17ll_D_Sf) C1{ FL:17 FL FC2{}}



static void Test_BFu17ll_D_Sf()
{
  {
    init_simple_test("BFu17ll_D_Sf");
    static BFu17ll_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_D_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_D_Sf(Test_BFu17ll_D_Sf, "BFu17ll_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_F_Sf  {
  __tsu64 v1:17;
  float v2;
  ::empty v3;
};
//SIG(1 BFu17ll_F_Sf) C1{ FL:17 Fi FC2{}}



static void Test_BFu17ll_F_Sf()
{
  {
    init_simple_test("BFu17ll_F_Sf");
    static BFu17ll_F_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_F_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_F_Sf");
    check_field_offset(lv, v2, 4, "BFu17ll_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_F_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_F_Sf(Test_BFu17ll_F_Sf, "BFu17ll_F_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_I_Sf  {
  __tsu64 v1:17;
  int v2;
  ::empty v3;
};
//SIG(1 BFu17ll_I_Sf) C1{ FL:17 Fi FC2{}}



static void Test_BFu17ll_I_Sf()
{
  {
    init_simple_test("BFu17ll_I_Sf");
    static BFu17ll_I_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_I_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_I_Sf");
    check_field_offset(lv, v2, 4, "BFu17ll_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_I_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_I_Sf(Test_BFu17ll_I_Sf, "BFu17ll_I_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Ip_Sf  {
  __tsu64 v1:17;
  int *v2;
  ::empty v3;
};
//SIG(1 BFu17ll_Ip_Sf) C1{ FL:17 Fp FC2{}}



static void Test_BFu17ll_Ip_Sf()
{
  {
    init_simple_test("BFu17ll_Ip_Sf");
    static BFu17ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ip_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Ip_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Ip_Sf(Test_BFu17ll_Ip_Sf, "BFu17ll_Ip_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_L_Sf  {
  __tsu64 v1:17;
  __tsi64 v2;
  ::empty v3;
};
//SIG(1 BFu17ll_L_Sf) C1{ FL:17 FL FC2{}}



static void Test_BFu17ll_L_Sf()
{
  {
    init_simple_test("BFu17ll_L_Sf");
    static BFu17ll_L_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_L_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_L_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_L_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_L_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_L_Sf(Test_BFu17ll_L_Sf, "BFu17ll_L_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_S_Sf  {
  __tsu64 v1:17;
  short v2;
  ::empty v3;
};
//SIG(1 BFu17ll_S_Sf) C1{ FL:17 Fs FC2{}}



static void Test_BFu17ll_S_Sf()
{
  {
    init_simple_test("BFu17ll_S_Sf");
    static BFu17ll_S_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_S_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_S_Sf");
    check_field_offset(lv, v2, 4, "BFu17ll_S_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu17ll_S_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_S_Sf(Test_BFu17ll_S_Sf, "BFu17ll_S_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf  {
  __tsu64 v1:17;
  ::empty v2;
};
//SIG(1 BFu17ll_Sf) C1{ FL:17 FC2{}}



static void Test_BFu17ll_Sf()
{
  {
    init_simple_test("BFu17ll_Sf");
    static BFu17ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf.v2");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf(Test_BFu17ll_Sf, "BFu17ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu15i  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned int v3:15;
};
//SIG(1 BFu17ll_Sf_BFu15i) C1{ FL:17 FC2{} Fi:15}



static void Test_BFu17ll_Sf_BFu15i()
{
  {
    init_simple_test("BFu17ll_Sf_BFu15i");
    static BFu17ll_Sf_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu15i");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_Sf_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_Sf_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu15i(Test_BFu17ll_Sf_BFu15i, "BFu17ll_Sf_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu15ll  {
  __tsu64 v1:17;
  ::empty v2;
  __tsu64 v3:15;
};
//SIG(1 BFu17ll_Sf_BFu15ll) C1{ FL:17 FC2{} FL:15}



static void Test_BFu17ll_Sf_BFu15ll()
{
  {
    init_simple_test("BFu17ll_Sf_BFu15ll");
    static BFu17ll_Sf_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu15ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_Sf_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu15ll(Test_BFu17ll_Sf_BFu15ll, "BFu17ll_Sf_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu15s  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned short v3:15;
};
//SIG(1 BFu17ll_Sf_BFu15s) C1{ FL:17 FC2{} Fs:15}



static void Test_BFu17ll_Sf_BFu15s()
{
  {
    init_simple_test("BFu17ll_Sf_BFu15s");
    static BFu17ll_Sf_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu15s");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "BFu17ll_Sf_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "BFu17ll_Sf_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu15s(Test_BFu17ll_Sf_BFu15s, "BFu17ll_Sf_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu16i  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned int v3:16;
};
//SIG(1 BFu17ll_Sf_BFu16i) C1{ FL:17 FC2{} Fi:16}



static void Test_BFu17ll_Sf_BFu16i()
{
  {
    init_simple_test("BFu17ll_Sf_BFu16i");
    static BFu17ll_Sf_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu16i");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_Sf_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_Sf_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu16i(Test_BFu17ll_Sf_BFu16i, "BFu17ll_Sf_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu16ll  {
  __tsu64 v1:17;
  ::empty v2;
  __tsu64 v3:16;
};
//SIG(1 BFu17ll_Sf_BFu16ll) C1{ FL:17 FC2{} FL:16}



static void Test_BFu17ll_Sf_BFu16ll()
{
  {
    init_simple_test("BFu17ll_Sf_BFu16ll");
    static BFu17ll_Sf_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu16ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu16ll(Test_BFu17ll_Sf_BFu16ll, "BFu17ll_Sf_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu16s  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned short v3:16;
};
//SIG(1 BFu17ll_Sf_BFu16s) C1{ FL:17 FC2{} Fs:16}



static void Test_BFu17ll_Sf_BFu16s()
{
  {
    init_simple_test("BFu17ll_Sf_BFu16s");
    static BFu17ll_Sf_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu16s");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "BFu17ll_Sf_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "BFu17ll_Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu16s(Test_BFu17ll_Sf_BFu16s, "BFu17ll_Sf_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu17i  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned int v3:17;
};
//SIG(1 BFu17ll_Sf_BFu17i) C1{ FL:17 FC2{} Fi:17}



static void Test_BFu17ll_Sf_BFu17i()
{
  {
    init_simple_test("BFu17ll_Sf_BFu17i");
    static BFu17ll_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu17i");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu17ll_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu17i(Test_BFu17ll_Sf_BFu17i, "BFu17ll_Sf_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu17ll  {
  __tsu64 v1:17;
  ::empty v2;
  __tsu64 v3:17;
};
//SIG(1 BFu17ll_Sf_BFu17ll) C1{ FL:17 FC2{} FL:17}



static void Test_BFu17ll_Sf_BFu17ll()
{
  {
    init_simple_test("BFu17ll_Sf_BFu17ll");
    static BFu17ll_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu17ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu17ll_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu17ll(Test_BFu17ll_Sf_BFu17ll, "BFu17ll_Sf_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu1c  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned char v3:1;
};
//SIG(1 BFu17ll_Sf_BFu1c) C1{ FL:17 FC2{} Fc:1}



static void Test_BFu17ll_Sf_BFu1c()
{
  {
    init_simple_test("BFu17ll_Sf_BFu1c");
    static BFu17ll_Sf_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu1c");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17ll_Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu1c(Test_BFu17ll_Sf_BFu1c, "BFu17ll_Sf_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu1i  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned int v3:1;
};
//SIG(1 BFu17ll_Sf_BFu1i) C1{ FL:17 FC2{} Fi:1}



static void Test_BFu17ll_Sf_BFu1i()
{
  {
    init_simple_test("BFu17ll_Sf_BFu1i");
    static BFu17ll_Sf_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu1i");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17ll_Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu1i(Test_BFu17ll_Sf_BFu1i, "BFu17ll_Sf_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu1ll  {
  __tsu64 v1:17;
  ::empty v2;
  __tsu64 v3:1;
};
//SIG(1 BFu17ll_Sf_BFu1ll) C1{ FL:17 FC2{} FL:1}



static void Test_BFu17ll_Sf_BFu1ll()
{
  {
    init_simple_test("BFu17ll_Sf_BFu1ll");
    static BFu17ll_Sf_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu1ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17ll_Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu1ll(Test_BFu17ll_Sf_BFu1ll, "BFu17ll_Sf_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu1s  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned short v3:1;
};
//SIG(1 BFu17ll_Sf_BFu1s) C1{ FL:17 FC2{} Fs:1}



static void Test_BFu17ll_Sf_BFu1s()
{
  {
    init_simple_test("BFu17ll_Sf_BFu1s");
    static BFu17ll_Sf_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu1s");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "BFu17ll_Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu1s(Test_BFu17ll_Sf_BFu1s, "BFu17ll_Sf_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu31i  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned int v3:31;
};
//SIG(1 BFu17ll_Sf_BFu31i) C1{ FL:17 FC2{} Fi:31}



static void Test_BFu17ll_Sf_BFu31i()
{
  {
    init_simple_test("BFu17ll_Sf_BFu31i");
    static BFu17ll_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu31i");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu17ll_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu31i(Test_BFu17ll_Sf_BFu31i, "BFu17ll_Sf_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu31ll  {
  __tsu64 v1:17;
  ::empty v2;
  __tsu64 v3:31;
};
//SIG(1 BFu17ll_Sf_BFu31ll) C1{ FL:17 FC2{} FL:31}



static void Test_BFu17ll_Sf_BFu31ll()
{
  {
    init_simple_test("BFu17ll_Sf_BFu31ll");
    static BFu17ll_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu31ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu17ll_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu17ll_Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu31ll(Test_BFu17ll_Sf_BFu31ll, "BFu17ll_Sf_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu32i  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned int v3:32;
};
//SIG(1 BFu17ll_Sf_BFu32i) C1{ FL:17 FC2{} Fi:32}



static void Test_BFu17ll_Sf_BFu32i()
{
  {
    init_simple_test("BFu17ll_Sf_BFu32i");
    static BFu17ll_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu32i");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu17ll_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu32i(Test_BFu17ll_Sf_BFu32i, "BFu17ll_Sf_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu32ll  {
  __tsu64 v1:17;
  ::empty v2;
  __tsu64 v3:32;
};
//SIG(1 BFu17ll_Sf_BFu32ll) C1{ FL:17 FC2{} FL:32}



static void Test_BFu17ll_Sf_BFu32ll()
{
  {
    init_simple_test("BFu17ll_Sf_BFu32ll");
    static BFu17ll_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu32ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu17ll_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu17ll_Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu32ll(Test_BFu17ll_Sf_BFu32ll, "BFu17ll_Sf_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu33  {
  __tsu64 v1:17;
  ::empty v2;
  __tsu64 v3:33;
};
//SIG(1 BFu17ll_Sf_BFu33) C1{ FL:17 FC2{} FL:33}



static void Test_BFu17ll_Sf_BFu33()
{
  {
    init_simple_test("BFu17ll_Sf_BFu33");
    static BFu17ll_Sf_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu33");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "BFu17ll_Sf_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "BFu17ll_Sf_BFu33");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu33(Test_BFu17ll_Sf_BFu33, "BFu17ll_Sf_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu7c  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned char v3:7;
};
//SIG(1 BFu17ll_Sf_BFu7c) C1{ FL:17 FC2{} Fc:7}



static void Test_BFu17ll_Sf_BFu7c()
{
  {
    init_simple_test("BFu17ll_Sf_BFu7c");
    static BFu17ll_Sf_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu7c");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_Sf_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu7c(Test_BFu17ll_Sf_BFu7c, "BFu17ll_Sf_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu7i  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned int v3:7;
};
//SIG(1 BFu17ll_Sf_BFu7i) C1{ FL:17 FC2{} Fi:7}



static void Test_BFu17ll_Sf_BFu7i()
{
  {
    init_simple_test("BFu17ll_Sf_BFu7i");
    static BFu17ll_Sf_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu7i");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_Sf_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_Sf_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu7i(Test_BFu17ll_Sf_BFu7i, "BFu17ll_Sf_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu7ll  {
  __tsu64 v1:17;
  ::empty v2;
  __tsu64 v3:7;
};
//SIG(1 BFu17ll_Sf_BFu7ll) C1{ FL:17 FC2{} FL:7}



static void Test_BFu17ll_Sf_BFu7ll()
{
  {
    init_simple_test("BFu17ll_Sf_BFu7ll");
    static BFu17ll_Sf_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu7ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_Sf_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu7ll(Test_BFu17ll_Sf_BFu7ll, "BFu17ll_Sf_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu7s  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned short v3:7;
};
//SIG(1 BFu17ll_Sf_BFu7s) C1{ FL:17 FC2{} Fs:7}



static void Test_BFu17ll_Sf_BFu7s()
{
  {
    init_simple_test("BFu17ll_Sf_BFu7s");
    static BFu17ll_Sf_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu7s");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "BFu17ll_Sf_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "BFu17ll_Sf_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu7s(Test_BFu17ll_Sf_BFu7s, "BFu17ll_Sf_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu8c  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned char v3:8;
};
//SIG(1 BFu17ll_Sf_BFu8c) C1{ FL:17 FC2{} Fc:8}



static void Test_BFu17ll_Sf_BFu8c()
{
  {
    init_simple_test("BFu17ll_Sf_BFu8c");
    static BFu17ll_Sf_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu8c");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_Sf_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_Sf_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu8c(Test_BFu17ll_Sf_BFu8c, "BFu17ll_Sf_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu8i  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned int v3:8;
};
//SIG(1 BFu17ll_Sf_BFu8i) C1{ FL:17 FC2{} Fi:8}



static void Test_BFu17ll_Sf_BFu8i()
{
  {
    init_simple_test("BFu17ll_Sf_BFu8i");
    static BFu17ll_Sf_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu8i");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_Sf_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_Sf_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu8i(Test_BFu17ll_Sf_BFu8i, "BFu17ll_Sf_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu8ll  {
  __tsu64 v1:17;
  ::empty v2;
  __tsu64 v3:8;
};
//SIG(1 BFu17ll_Sf_BFu8ll) C1{ FL:17 FC2{} FL:8}



static void Test_BFu17ll_Sf_BFu8ll()
{
  {
    init_simple_test("BFu17ll_Sf_BFu8ll");
    static BFu17ll_Sf_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu8ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_Sf_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu8ll(Test_BFu17ll_Sf_BFu8ll, "BFu17ll_Sf_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu8s  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned short v3:8;
};
//SIG(1 BFu17ll_Sf_BFu8s) C1{ FL:17 FC2{} Fs:8}



static void Test_BFu17ll_Sf_BFu8s()
{
  {
    init_simple_test("BFu17ll_Sf_BFu8s");
    static BFu17ll_Sf_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu8s");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "BFu17ll_Sf_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "BFu17ll_Sf_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu8s(Test_BFu17ll_Sf_BFu8s, "BFu17ll_Sf_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu9i  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned int v3:9;
};
//SIG(1 BFu17ll_Sf_BFu9i) C1{ FL:17 FC2{} Fi:9}



static void Test_BFu17ll_Sf_BFu9i()
{
  {
    init_simple_test("BFu17ll_Sf_BFu9i");
    static BFu17ll_Sf_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu9i");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_Sf_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_Sf_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu9i(Test_BFu17ll_Sf_BFu9i, "BFu17ll_Sf_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu9ll  {
  __tsu64 v1:17;
  ::empty v2;
  __tsu64 v3:9;
};
//SIG(1 BFu17ll_Sf_BFu9ll) C1{ FL:17 FC2{} FL:9}



static void Test_BFu17ll_Sf_BFu9ll()
{
  {
    init_simple_test("BFu17ll_Sf_BFu9ll");
    static BFu17ll_Sf_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu9ll");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_Sf_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu9ll(Test_BFu17ll_Sf_BFu9ll, "BFu17ll_Sf_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_BFu9s  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned short v3:9;
};
//SIG(1 BFu17ll_Sf_BFu9s) C1{ FL:17 FC2{} Fs:9}



static void Test_BFu17ll_Sf_BFu9s()
{
  {
    init_simple_test("BFu17ll_Sf_BFu9s");
    static BFu17ll_Sf_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_BFu9s");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "BFu17ll_Sf_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "BFu17ll_Sf_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_BFu9s(Test_BFu17ll_Sf_BFu9s, "BFu17ll_Sf_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_C  {
  __tsu64 v1:17;
  ::empty v2;
  char v3;
};
//SIG(1 BFu17ll_Sf_C) C1{ FL:17 FC2{} Fc}



static void Test_BFu17ll_Sf_C()
{
  {
    init_simple_test("BFu17ll_Sf_C");
    static BFu17ll_Sf_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_C");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_C.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Sf_C.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_C(Test_BFu17ll_Sf_C, "BFu17ll_Sf_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_D  {
  __tsu64 v1:17;
  ::empty v2;
  double v3;
};
//SIG(1 BFu17ll_Sf_D) C1{ FL:17 FC2{} FL}



static void Test_BFu17ll_Sf_D()
{
  {
    init_simple_test("BFu17ll_Sf_D");
    static BFu17ll_Sf_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Sf_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_D");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_Sf_D.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_D(Test_BFu17ll_Sf_D, "BFu17ll_Sf_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_F  {
  __tsu64 v1:17;
  ::empty v2;
  float v3;
};
//SIG(1 BFu17ll_Sf_F) C1{ FL:17 FC2{} Fi}



static void Test_BFu17ll_Sf_F()
{
  {
    init_simple_test("BFu17ll_Sf_F");
    static BFu17ll_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_F");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Sf_F.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_F(Test_BFu17ll_Sf_F, "BFu17ll_Sf_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_I  {
  __tsu64 v1:17;
  ::empty v2;
  int v3;
};
//SIG(1 BFu17ll_Sf_I) C1{ FL:17 FC2{} Fi}



static void Test_BFu17ll_Sf_I()
{
  {
    init_simple_test("BFu17ll_Sf_I");
    static BFu17ll_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_I");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Sf_I.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_I(Test_BFu17ll_Sf_I, "BFu17ll_Sf_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_Ip  {
  __tsu64 v1:17;
  ::empty v2;
  int *v3;
};
//SIG(1 BFu17ll_Sf_Ip) C1{ FL:17 FC2{} Fp}



static void Test_BFu17ll_Sf_Ip()
{
  {
    init_simple_test("BFu17ll_Sf_Ip");
    static BFu17ll_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_Ip");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_Sf_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_Ip(Test_BFu17ll_Sf_Ip, "BFu17ll_Sf_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_L  {
  __tsu64 v1:17;
  ::empty v2;
  __tsi64 v3;
};
//SIG(1 BFu17ll_Sf_L) C1{ FL:17 FC2{} FL}



static void Test_BFu17ll_Sf_L()
{
  {
    init_simple_test("BFu17ll_Sf_L");
    static BFu17ll_Sf_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Sf_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_L");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_Sf_L.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_L(Test_BFu17ll_Sf_L, "BFu17ll_Sf_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_S  {
  __tsu64 v1:17;
  ::empty v2;
  short v3;
};
//SIG(1 BFu17ll_Sf_S) C1{ FL:17 FC2{} Fs}



static void Test_BFu17ll_Sf_S()
{
  {
    init_simple_test("BFu17ll_Sf_S");
    static BFu17ll_Sf_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_S");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_S.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Sf_S.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_S(Test_BFu17ll_Sf_S, "BFu17ll_Sf_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_Sf  {
  __tsu64 v1:17;
  ::empty v2;
  ::empty v3;
};
//SIG(1 BFu17ll_Sf_Sf) C1{ FL:17 FC2{} FC2}



static void Test_BFu17ll_Sf_Sf()
{
  {
    init_simple_test("BFu17ll_Sf_Sf");
    static BFu17ll_Sf_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_Sf");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Sf_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_Sf(Test_BFu17ll_Sf_Sf, "BFu17ll_Sf_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_Uc  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned char v3;
};
//SIG(1 BFu17ll_Sf_Uc) C1{ FL:17 FC2{} Fc}



static void Test_BFu17ll_Sf_Uc()
{
  {
    init_simple_test("BFu17ll_Sf_Uc");
    static BFu17ll_Sf_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_Uc");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_Uc.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Sf_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_Uc(Test_BFu17ll_Sf_Uc, "BFu17ll_Sf_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_Ui  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned int v3;
};
//SIG(1 BFu17ll_Sf_Ui) C1{ FL:17 FC2{} Fi}



static void Test_BFu17ll_Sf_Ui()
{
  {
    init_simple_test("BFu17ll_Sf_Ui");
    static BFu17ll_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_Ui");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Sf_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_Ui(Test_BFu17ll_Sf_Ui, "BFu17ll_Sf_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_Ul  {
  __tsu64 v1:17;
  ::empty v2;
  __tsu64 v3;
};
//SIG(1 BFu17ll_Sf_Ul) C1{ FL:17 FC2{} FL}



static void Test_BFu17ll_Sf_Ul()
{
  {
    init_simple_test("BFu17ll_Sf_Ul");
    static BFu17ll_Sf_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_Ul");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_Sf_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_Ul(Test_BFu17ll_Sf_Ul, "BFu17ll_Sf_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_Us  {
  __tsu64 v1:17;
  ::empty v2;
  unsigned short v3;
};
//SIG(1 BFu17ll_Sf_Us) C1{ FL:17 FC2{} Fs}



static void Test_BFu17ll_Sf_Us()
{
  {
    init_simple_test("BFu17ll_Sf_Us");
    static BFu17ll_Sf_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Sf_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_Us");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_Us.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Sf_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_Us(Test_BFu17ll_Sf_Us, "BFu17ll_Sf_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Sf_Vp  {
  __tsu64 v1:17;
  ::empty v2;
  void *v3;
};
//SIG(1 BFu17ll_Sf_Vp) C1{ FL:17 FC2{} Fp}



static void Test_BFu17ll_Sf_Vp()
{
  {
    init_simple_test("BFu17ll_Sf_Vp");
    static BFu17ll_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu17ll_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Sf_Vp");
    check_field_offset(lv, v2, 3, "BFu17ll_Sf_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu17ll_Sf_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Sf_Vp(Test_BFu17ll_Sf_Vp, "BFu17ll_Sf_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Uc_Sf  {
  __tsu64 v1:17;
  unsigned char v2;
  ::empty v3;
};
//SIG(1 BFu17ll_Uc_Sf) C1{ FL:17 Fc FC2{}}



static void Test_BFu17ll_Uc_Sf()
{
  {
    init_simple_test("BFu17ll_Uc_Sf");
    static BFu17ll_Uc_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Uc_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Uc_Sf");
    check_field_offset(lv, v2, 3, "BFu17ll_Uc_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu17ll_Uc_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Uc_Sf(Test_BFu17ll_Uc_Sf, "BFu17ll_Uc_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Ui_Sf  {
  __tsu64 v1:17;
  unsigned int v2;
  ::empty v3;
};
//SIG(1 BFu17ll_Ui_Sf) C1{ FL:17 Fi FC2{}}



static void Test_BFu17ll_Ui_Sf()
{
  {
    init_simple_test("BFu17ll_Ui_Sf");
    static BFu17ll_Ui_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu17ll_Ui_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu17ll_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu17ll_Ui_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Ui_Sf(Test_BFu17ll_Ui_Sf, "BFu17ll_Ui_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Ul_Sf  {
  __tsu64 v1:17;
  __tsu64 v2;
  ::empty v3;
};
//SIG(1 BFu17ll_Ul_Sf) C1{ FL:17 FL FC2{}}



static void Test_BFu17ll_Ul_Sf()
{
  {
    init_simple_test("BFu17ll_Ul_Sf");
    static BFu17ll_Ul_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu17ll_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Ul_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Ul_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu17ll_Ul_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Ul_Sf(Test_BFu17ll_Ul_Sf, "BFu17ll_Ul_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Us_Sf  {
  __tsu64 v1:17;
  unsigned short v2;
  ::empty v3;
};
//SIG(1 BFu17ll_Us_Sf) C1{ FL:17 Fs FC2{}}



static void Test_BFu17ll_Us_Sf()
{
  {
    init_simple_test("BFu17ll_Us_Sf");
    static BFu17ll_Us_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu17ll_Us_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Us_Sf");
    check_field_offset(lv, v2, 4, "BFu17ll_Us_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu17ll_Us_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Us_Sf(Test_BFu17ll_Us_Sf, "BFu17ll_Us_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu17ll_Vp_Sf  {
  __tsu64 v1:17;
  void *v2;
  ::empty v3;
};
//SIG(1 BFu17ll_Vp_Sf) C1{ FL:17 Fp FC2{}}



static void Test_BFu17ll_Vp_Sf()
{
  {
    init_simple_test("BFu17ll_Vp_Sf");
    static BFu17ll_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu17ll_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu17ll_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 17, 1, "BFu17ll_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 17, hide_ull(1LL<<16), "BFu17ll_Vp_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu17ll_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu17ll_Vp_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu17ll_Vp_Sf(Test_BFu17ll_Vp_Sf, "BFu17ll_Vp_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu15i_Sf  {
  unsigned char v1:1;
  unsigned int v2:15;
  ::empty v3;
};
//SIG(1 BFu1c_BFu15i_Sf) C1{ Fc:1 Fi:15 FC2{}}



static void Test_BFu1c_BFu15i_Sf()
{
  {
    init_simple_test("BFu1c_BFu15i_Sf");
    static BFu1c_BFu15i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15i_Sf");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu15i_Sf(Test_BFu1c_BFu15i_Sf, "BFu1c_BFu15i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu15ll_Sf  {
  unsigned char v1:1;
  __tsu64 v2:15;
  ::empty v3;
};
//SIG(1 BFu1c_BFu15ll_Sf) C1{ Fc:1 FL:15 FC2{}}



static void Test_BFu1c_BFu15ll_Sf()
{
  {
    init_simple_test("BFu1c_BFu15ll_Sf");
    static BFu1c_BFu15ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15ll_Sf");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu15ll_Sf(Test_BFu1c_BFu15ll_Sf, "BFu1c_BFu15ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu15s_Sf  {
  unsigned char v1:1;
  unsigned short v2:15;
  ::empty v3;
};
//SIG(1 BFu1c_BFu15s_Sf) C1{ Fc:1 Fs:15 FC2{}}



static void Test_BFu1c_BFu15s_Sf()
{
  {
    init_simple_test("BFu1c_BFu15s_Sf");
    static BFu1c_BFu15s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu15s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1c_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1c_BFu15s_Sf");
    check_field_offset(lv, v3, 2, "BFu1c_BFu15s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu15s_Sf(Test_BFu1c_BFu15s_Sf, "BFu1c_BFu15s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu16i_Sf  {
  unsigned char v1:1;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 BFu1c_BFu16i_Sf) C1{ Fc:1 Fi:16 FC2{}}



static void Test_BFu1c_BFu16i_Sf()
{
  {
    init_simple_test("BFu1c_BFu16i_Sf");
    static BFu1c_BFu16i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu16i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "BFu1c_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu16i_Sf(Test_BFu1c_BFu16i_Sf, "BFu1c_BFu16i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu16ll_Sf  {
  unsigned char v1:1;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 BFu1c_BFu16ll_Sf) C1{ Fc:1 FL:16 FC2{}}



static void Test_BFu1c_BFu16ll_Sf()
{
  {
    init_simple_test("BFu1c_BFu16ll_Sf");
    static BFu1c_BFu16ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1c_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1c_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "BFu1c_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu16ll_Sf(Test_BFu1c_BFu16ll_Sf, "BFu1c_BFu16ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu16s_Sf  {
  unsigned char v1:1;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 BFu1c_BFu16s_Sf) C1{ Fc:1 Fs:16 FC2{}}



static void Test_BFu1c_BFu16s_Sf()
{
  {
    init_simple_test("BFu1c_BFu16s_Sf");
    static BFu1c_BFu16s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu1c_BFu16s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1c_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "BFu1c_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu16s_Sf(Test_BFu1c_BFu16s_Sf, "BFu1c_BFu16s_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu17i_Sf  {
  unsigned char v1:1;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 BFu1c_BFu17i_Sf) C1{ Fc:1 Fi:17 FC2{}}



static void Test_BFu1c_BFu17i_Sf()
{
  {
    init_simple_test("BFu1c_BFu17i_Sf");
    static BFu1c_BFu17i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu17i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1c_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1c_BFu17i_Sf");
    check_field_offset(lv, v3, 3, "BFu1c_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu17i_Sf(Test_BFu1c_BFu17i_Sf, "BFu1c_BFu17i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu17ll_Sf  {
  unsigned char v1:1;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 BFu1c_BFu17ll_Sf) C1{ Fc:1 FL:17 FC2{}}



static void Test_BFu1c_BFu17ll_Sf()
{
  {
    init_simple_test("BFu1c_BFu17ll_Sf");
    static BFu1c_BFu17ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1c_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1c_BFu17ll_Sf");
    check_field_offset(lv, v3, 3, "BFu1c_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu17ll_Sf(Test_BFu1c_BFu17ll_Sf, "BFu1c_BFu17ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu1c_Sf  {
  unsigned char v1:1;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 BFu1c_BFu1c_Sf) C1{ Fc:1 Fc:1 FC2{}}



static void Test_BFu1c_BFu1c_Sf()
{
  {
    init_simple_test("BFu1c_BFu1c_Sf");
    static BFu1c_BFu1c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1c_Sf");
    check_field_offset(lv, v3, 1, "BFu1c_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu1c_Sf(Test_BFu1c_BFu1c_Sf, "BFu1c_BFu1c_Sf", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu1i_Sf  {
  unsigned char v1:1;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 BFu1c_BFu1i_Sf) C1{ Fc:1 Fi:1 FC2{}}



static void Test_BFu1c_BFu1i_Sf()
{
  {
    init_simple_test("BFu1c_BFu1i_Sf");
    static BFu1c_BFu1i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu1i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1i_Sf");
    check_field_offset(lv, v3, 1, "BFu1c_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu1i_Sf(Test_BFu1c_BFu1i_Sf, "BFu1c_BFu1i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu1ll_Sf  {
  unsigned char v1:1;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 BFu1c_BFu1ll_Sf) C1{ Fc:1 FL:1 FC2{}}



static void Test_BFu1c_BFu1ll_Sf()
{
  {
    init_simple_test("BFu1c_BFu1ll_Sf");
    static BFu1c_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1ll_Sf");
    check_field_offset(lv, v3, 1, "BFu1c_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu1ll_Sf(Test_BFu1c_BFu1ll_Sf, "BFu1c_BFu1ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu1s_Sf  {
  unsigned char v1:1;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 BFu1c_BFu1s_Sf) C1{ Fc:1 Fs:1 FC2{}}



static void Test_BFu1c_BFu1s_Sf()
{
  {
    init_simple_test("BFu1c_BFu1s_Sf");
    static BFu1c_BFu1s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu1s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu1s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1c_BFu1s_Sf");
    check_field_offset(lv, v3, 1, "BFu1c_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu1s_Sf(Test_BFu1c_BFu1s_Sf, "BFu1c_BFu1s_Sf", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu31i_Sf  {
  unsigned char v1:1;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 BFu1c_BFu31i_Sf) C1{ Fc:1 Fi:31 FC2{}}



static void Test_BFu1c_BFu31i_Sf()
{
  {
    init_simple_test("BFu1c_BFu31i_Sf");
    static BFu1c_BFu31i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu31i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1c_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1c_BFu31i_Sf");
    check_field_offset(lv, v3, 4, "BFu1c_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu31i_Sf(Test_BFu1c_BFu31i_Sf, "BFu1c_BFu31i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu31ll_Sf  {
  unsigned char v1:1;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 BFu1c_BFu31ll_Sf) C1{ Fc:1 FL:31 FC2{}}



static void Test_BFu1c_BFu31ll_Sf()
{
  {
    init_simple_test("BFu1c_BFu31ll_Sf");
    static BFu1c_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1c_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1c_BFu31ll_Sf");
    check_field_offset(lv, v3, 4, "BFu1c_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu31ll_Sf(Test_BFu1c_BFu31ll_Sf, "BFu1c_BFu31ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu32i_Sf  {
  unsigned char v1:1;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 BFu1c_BFu32i_Sf) C1{ Fc:1 Fi:32 FC2{}}



static void Test_BFu1c_BFu32i_Sf()
{
  {
    init_simple_test("BFu1c_BFu32i_Sf");
    static BFu1c_BFu32i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu1c_BFu32i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1c_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu1c_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu32i_Sf(Test_BFu1c_BFu32i_Sf, "BFu1c_BFu32i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu32ll_Sf  {
  unsigned char v1:1;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 BFu1c_BFu32ll_Sf) C1{ Fc:1 FL:32 FC2{}}



static void Test_BFu1c_BFu32ll_Sf()
{
  {
    init_simple_test("BFu1c_BFu32ll_Sf");
    static BFu1c_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1c_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1c_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "BFu1c_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu32ll_Sf(Test_BFu1c_BFu32ll_Sf, "BFu1c_BFu32ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu33_Sf  {
  unsigned char v1:1;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 BFu1c_BFu33_Sf) C1{ Fc:1 FL:33 FC2{}}



static void Test_BFu1c_BFu33_Sf()
{
  {
    init_simple_test("BFu1c_BFu33_Sf");
    static BFu1c_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1c_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1c_BFu33_Sf");
    check_field_offset(lv, v3, 5, "BFu1c_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu33_Sf(Test_BFu1c_BFu33_Sf, "BFu1c_BFu33_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu7c_Sf  {
  unsigned char v1:1;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 BFu1c_BFu7c_Sf) C1{ Fc:1 Fc:7 FC2{}}



static void Test_BFu1c_BFu7c_Sf()
{
  {
    init_simple_test("BFu1c_BFu7c_Sf");
    static BFu1c_BFu7c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu7c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7c_Sf");
    check_field_offset(lv, v3, 1, "BFu1c_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu7c_Sf(Test_BFu1c_BFu7c_Sf, "BFu1c_BFu7c_Sf", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu7i_Sf  {
  unsigned char v1:1;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 BFu1c_BFu7i_Sf) C1{ Fc:1 Fi:7 FC2{}}



static void Test_BFu1c_BFu7i_Sf()
{
  {
    init_simple_test("BFu1c_BFu7i_Sf");
    static BFu1c_BFu7i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu7i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7i_Sf");
    check_field_offset(lv, v3, 1, "BFu1c_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu7i_Sf(Test_BFu1c_BFu7i_Sf, "BFu1c_BFu7i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu7ll_Sf  {
  unsigned char v1:1;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 BFu1c_BFu7ll_Sf) C1{ Fc:1 FL:7 FC2{}}



static void Test_BFu1c_BFu7ll_Sf()
{
  {
    init_simple_test("BFu1c_BFu7ll_Sf");
    static BFu1c_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7ll_Sf");
    check_field_offset(lv, v3, 1, "BFu1c_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu7ll_Sf(Test_BFu1c_BFu7ll_Sf, "BFu1c_BFu7ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu7s_Sf  {
  unsigned char v1:1;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 BFu1c_BFu7s_Sf) C1{ Fc:1 Fs:7 FC2{}}



static void Test_BFu1c_BFu7s_Sf()
{
  {
    init_simple_test("BFu1c_BFu7s_Sf");
    static BFu1c_BFu7s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_BFu7s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1c_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1c_BFu7s_Sf");
    check_field_offset(lv, v3, 1, "BFu1c_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu7s_Sf(Test_BFu1c_BFu7s_Sf, "BFu1c_BFu7s_Sf", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu8c_Sf  {
  unsigned char v1:1;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 BFu1c_BFu8c_Sf) C1{ Fc:1 Fc:8 FC2{}}



static void Test_BFu1c_BFu8c_Sf()
{
  {
    init_simple_test("BFu1c_BFu8c_Sf");
    static BFu1c_BFu8c_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu1c_BFu8c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1c_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1c_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "BFu1c_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu8c_Sf(Test_BFu1c_BFu8c_Sf, "BFu1c_BFu8c_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu8i_Sf  {
  unsigned char v1:1;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 BFu1c_BFu8i_Sf) C1{ Fc:1 Fi:8 FC2{}}



static void Test_BFu1c_BFu8i_Sf()
{
  {
    init_simple_test("BFu1c_BFu8i_Sf");
    static BFu1c_BFu8i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu8i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "BFu1c_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu8i_Sf(Test_BFu1c_BFu8i_Sf, "BFu1c_BFu8i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu8ll_Sf  {
  unsigned char v1:1;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 BFu1c_BFu8ll_Sf) C1{ Fc:1 FL:8 FC2{}}



static void Test_BFu1c_BFu8ll_Sf()
{
  {
    init_simple_test("BFu1c_BFu8ll_Sf");
    static BFu1c_BFu8ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "BFu1c_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu8ll_Sf(Test_BFu1c_BFu8ll_Sf, "BFu1c_BFu8ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu8s_Sf  {
  unsigned char v1:1;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 BFu1c_BFu8s_Sf) C1{ Fc:1 Fs:8 FC2{}}



static void Test_BFu1c_BFu8s_Sf()
{
  {
    init_simple_test("BFu1c_BFu8s_Sf");
    static BFu1c_BFu8s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu8s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1c_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1c_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "BFu1c_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu8s_Sf(Test_BFu1c_BFu8s_Sf, "BFu1c_BFu8s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu9i_Sf  {
  unsigned char v1:1;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 BFu1c_BFu9i_Sf) C1{ Fc:1 Fi:9 FC2{}}



static void Test_BFu1c_BFu9i_Sf()
{
  {
    init_simple_test("BFu1c_BFu9i_Sf");
    static BFu1c_BFu9i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu9i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9i_Sf");
    check_field_offset(lv, v3, 2, "BFu1c_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu9i_Sf(Test_BFu1c_BFu9i_Sf, "BFu1c_BFu9i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu9ll_Sf  {
  unsigned char v1:1;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 BFu1c_BFu9ll_Sf) C1{ Fc:1 FL:9 FC2{}}



static void Test_BFu1c_BFu9ll_Sf()
{
  {
    init_simple_test("BFu1c_BFu9ll_Sf");
    static BFu1c_BFu9ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9ll_Sf");
    check_field_offset(lv, v3, 2, "BFu1c_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu9ll_Sf(Test_BFu1c_BFu9ll_Sf, "BFu1c_BFu9ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_BFu9s_Sf  {
  unsigned char v1:1;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 BFu1c_BFu9s_Sf) C1{ Fc:1 Fs:9 FC2{}}



static void Test_BFu1c_BFu9s_Sf()
{
  {
    init_simple_test("BFu1c_BFu9s_Sf");
    static BFu1c_BFu9s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_BFu9s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1c_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1c_BFu9s_Sf");
    check_field_offset(lv, v3, 2, "BFu1c_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_BFu9s_Sf(Test_BFu1c_BFu9s_Sf, "BFu1c_BFu9s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_C_Sf  {
  unsigned char v1:1;
  char v2;
  ::empty v3;
};
//SIG(1 BFu1c_C_Sf) C1{ Fc:1 Fc FC2{}}



static void Test_BFu1c_C_Sf()
{
  {
    init_simple_test("BFu1c_C_Sf");
    static BFu1c_C_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu1c_C_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_C_Sf");
    check_field_offset(lv, v2, 1, "BFu1c_C_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu1c_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_C_Sf(Test_BFu1c_C_Sf, "BFu1c_C_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_D_Sf  {
  unsigned char v1:1;
  double v2;
  ::empty v3;
};
//SIG(1 BFu1c_D_Sf) C1{ Fc:1 FL FC2{}}



static void Test_BFu1c_D_Sf()
{
  {
    init_simple_test("BFu1c_D_Sf");
    static BFu1c_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu1c_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_D_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu1c_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_D_Sf(Test_BFu1c_D_Sf, "BFu1c_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_F_Sf  {
  unsigned char v1:1;
  float v2;
  ::empty v3;
};
//SIG(1 BFu1c_F_Sf) C1{ Fc:1 Fi FC2{}}



static void Test_BFu1c_F_Sf()
{
  {
    init_simple_test("BFu1c_F_Sf");
    static BFu1c_F_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu1c_F_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_F_Sf");
    check_field_offset(lv, v2, 4, "BFu1c_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu1c_F_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_F_Sf(Test_BFu1c_F_Sf, "BFu1c_F_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_I_Sf  {
  unsigned char v1:1;
  int v2;
  ::empty v3;
};
//SIG(1 BFu1c_I_Sf) C1{ Fc:1 Fi FC2{}}



static void Test_BFu1c_I_Sf()
{
  {
    init_simple_test("BFu1c_I_Sf");
    static BFu1c_I_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu1c_I_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_I_Sf");
    check_field_offset(lv, v2, 4, "BFu1c_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu1c_I_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_I_Sf(Test_BFu1c_I_Sf, "BFu1c_I_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Ip_Sf  {
  unsigned char v1:1;
  int *v2;
  ::empty v3;
};
//SIG(1 BFu1c_Ip_Sf) C1{ Fc:1 Fp FC2{}}



static void Test_BFu1c_Ip_Sf()
{
  {
    init_simple_test("BFu1c_Ip_Sf");
    static BFu1c_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu1c_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ip_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu1c_Ip_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Ip_Sf(Test_BFu1c_Ip_Sf, "BFu1c_Ip_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_L_Sf  {
  unsigned char v1:1;
  __tsi64 v2;
  ::empty v3;
};
//SIG(1 BFu1c_L_Sf) C1{ Fc:1 FL FC2{}}



static void Test_BFu1c_L_Sf()
{
  {
    init_simple_test("BFu1c_L_Sf");
    static BFu1c_L_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu1c_L_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_L_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_L_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu1c_L_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_L_Sf(Test_BFu1c_L_Sf, "BFu1c_L_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_S_Sf  {
  unsigned char v1:1;
  short v2;
  ::empty v3;
};
//SIG(1 BFu1c_S_Sf) C1{ Fc:1 Fs FC2{}}



static void Test_BFu1c_S_Sf()
{
  {
    init_simple_test("BFu1c_S_Sf");
    static BFu1c_S_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu1c_S_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_S_Sf");
    check_field_offset(lv, v2, 2, "BFu1c_S_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu1c_S_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_S_Sf(Test_BFu1c_S_Sf, "BFu1c_S_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf  {
  unsigned char v1:1;
  ::empty v2;
};
//SIG(1 BFu1c_Sf) C1{ Fc:1 FC2{}}



static void Test_BFu1c_Sf()
{
  {
    init_simple_test("BFu1c_Sf");
    static BFu1c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu1c_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf");
    check_field_offset(lv, v2, 1, "BFu1c_Sf.v2");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf(Test_BFu1c_Sf, "BFu1c_Sf", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu15i  {
  unsigned char v1:1;
  ::empty v2;
  unsigned int v3:15;
};
//SIG(1 BFu1c_Sf_BFu15i) C1{ Fc:1 FC2{} Fi:15}



static void Test_BFu1c_Sf_BFu15i()
{
  {
    init_simple_test("BFu1c_Sf_BFu15i");
    static BFu1c_Sf_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Sf_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1c_Sf_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_Sf_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu15i(Test_BFu1c_Sf_BFu15i, "BFu1c_Sf_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu15ll  {
  unsigned char v1:1;
  ::empty v2;
  __tsu64 v3:15;
};
//SIG(1 BFu1c_Sf_BFu15ll) C1{ Fc:1 FC2{} FL:15}



static void Test_BFu1c_Sf_BFu15ll()
{
  {
    init_simple_test("BFu1c_Sf_BFu15ll");
    static BFu1c_Sf_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1c_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_Sf_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu15ll(Test_BFu1c_Sf_BFu15ll, "BFu1c_Sf_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu15s  {
  unsigned char v1:1;
  ::empty v2;
  unsigned short v3:15;
};
//SIG(1 BFu1c_Sf_BFu15s) C1{ Fc:1 FC2{} Fs:15}



static void Test_BFu1c_Sf_BFu15s()
{
  {
    init_simple_test("BFu1c_Sf_BFu15s");
    static BFu1c_Sf_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Sf_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1c_Sf_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1c_Sf_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu15s(Test_BFu1c_Sf_BFu15s, "BFu1c_Sf_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu16i  {
  unsigned char v1:1;
  ::empty v2;
  unsigned int v3:16;
};
//SIG(1 BFu1c_Sf_BFu16i) C1{ Fc:1 FC2{} Fi:16}



static void Test_BFu1c_Sf_BFu16i()
{
  {
    init_simple_test("BFu1c_Sf_BFu16i");
    static BFu1c_Sf_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Sf_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1c_Sf_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_Sf_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu16i(Test_BFu1c_Sf_BFu16i, "BFu1c_Sf_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu16ll  {
  unsigned char v1:1;
  ::empty v2;
  __tsu64 v3:16;
};
//SIG(1 BFu1c_Sf_BFu16ll) C1{ Fc:1 FC2{} FL:16}



static void Test_BFu1c_Sf_BFu16ll()
{
  {
    init_simple_test("BFu1c_Sf_BFu16ll");
    static BFu1c_Sf_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1c_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu16ll(Test_BFu1c_Sf_BFu16ll, "BFu1c_Sf_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu16s  {
  unsigned char v1:1;
  ::empty v2;
  unsigned short v3:16;
};
//SIG(1 BFu1c_Sf_BFu16s) C1{ Fc:1 FC2{} Fs:16}



static void Test_BFu1c_Sf_BFu16s()
{
  {
    init_simple_test("BFu1c_Sf_BFu16s");
    static BFu1c_Sf_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Sf_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1c_Sf_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1c_Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu16s(Test_BFu1c_Sf_BFu16s, "BFu1c_Sf_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu17i  {
  unsigned char v1:1;
  ::empty v2;
  unsigned int v3:17;
};
//SIG(1 BFu1c_Sf_BFu17i) C1{ Fc:1 FC2{} Fi:17}



static void Test_BFu1c_Sf_BFu17i()
{
  {
    init_simple_test("BFu1c_Sf_BFu17i");
    static BFu1c_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_Sf_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1c_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1c_Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu17i(Test_BFu1c_Sf_BFu17i, "BFu1c_Sf_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu17ll  {
  unsigned char v1:1;
  ::empty v2;
  __tsu64 v3:17;
};
//SIG(1 BFu1c_Sf_BFu17ll) C1{ Fc:1 FC2{} FL:17}



static void Test_BFu1c_Sf_BFu17ll()
{
  {
    init_simple_test("BFu1c_Sf_BFu17ll");
    static BFu1c_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu1c_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu1c_Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu17ll(Test_BFu1c_Sf_BFu17ll, "BFu1c_Sf_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu1c  {
  unsigned char v1:1;
  ::empty v2;
  unsigned char v3:1;
};
//SIG(1 BFu1c_Sf_BFu1c) C1{ Fc:1 FC2{} Fc:1}



static void Test_BFu1c_Sf_BFu1c()
{
  {
    init_simple_test("BFu1c_Sf_BFu1c");
    static BFu1c_Sf_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(BFu1c_Sf_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu1c(Test_BFu1c_Sf_BFu1c, "BFu1c_Sf_BFu1c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu1i  {
  unsigned char v1:1;
  ::empty v2;
  unsigned int v3:1;
};
//SIG(1 BFu1c_Sf_BFu1i) C1{ Fc:1 FC2{} Fi:1}



static void Test_BFu1c_Sf_BFu1i()
{
  {
    init_simple_test("BFu1c_Sf_BFu1i");
    static BFu1c_Sf_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Sf_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu1i(Test_BFu1c_Sf_BFu1i, "BFu1c_Sf_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu1ll  {
  unsigned char v1:1;
  ::empty v2;
  __tsu64 v3:1;
};
//SIG(1 BFu1c_Sf_BFu1ll) C1{ Fc:1 FC2{} FL:1}



static void Test_BFu1c_Sf_BFu1ll()
{
  {
    init_simple_test("BFu1c_Sf_BFu1ll");
    static BFu1c_Sf_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu1ll(Test_BFu1c_Sf_BFu1ll, "BFu1c_Sf_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu1s  {
  unsigned char v1:1;
  ::empty v2;
  unsigned short v3:1;
};
//SIG(1 BFu1c_Sf_BFu1s) C1{ Fc:1 FC2{} Fs:1}



static void Test_BFu1c_Sf_BFu1s()
{
  {
    init_simple_test("BFu1c_Sf_BFu1s");
    static BFu1c_Sf_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Sf_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1c_Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu1s(Test_BFu1c_Sf_BFu1s, "BFu1c_Sf_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu31i  {
  unsigned char v1:1;
  ::empty v2;
  unsigned int v3:31;
};
//SIG(1 BFu1c_Sf_BFu31i) C1{ Fc:1 FC2{} Fi:31}



static void Test_BFu1c_Sf_BFu31i()
{
  {
    init_simple_test("BFu1c_Sf_BFu31i");
    static BFu1c_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_Sf_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1c_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1c_Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu31i(Test_BFu1c_Sf_BFu31i, "BFu1c_Sf_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu31ll  {
  unsigned char v1:1;
  ::empty v2;
  __tsu64 v3:31;
};
//SIG(1 BFu1c_Sf_BFu31ll) C1{ Fc:1 FC2{} FL:31}



static void Test_BFu1c_Sf_BFu31ll()
{
  {
    init_simple_test("BFu1c_Sf_BFu31ll");
    static BFu1c_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu1c_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu1c_Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu31ll(Test_BFu1c_Sf_BFu31ll, "BFu1c_Sf_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu32i  {
  unsigned char v1:1;
  ::empty v2;
  unsigned int v3:32;
};
//SIG(1 BFu1c_Sf_BFu32i) C1{ Fc:1 FC2{} Fi:32}



static void Test_BFu1c_Sf_BFu32i()
{
  {
    init_simple_test("BFu1c_Sf_BFu32i");
    static BFu1c_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_Sf_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1c_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1c_Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu32i(Test_BFu1c_Sf_BFu32i, "BFu1c_Sf_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu32ll  {
  unsigned char v1:1;
  ::empty v2;
  __tsu64 v3:32;
};
//SIG(1 BFu1c_Sf_BFu32ll) C1{ Fc:1 FC2{} FL:32}



static void Test_BFu1c_Sf_BFu32ll()
{
  {
    init_simple_test("BFu1c_Sf_BFu32ll");
    static BFu1c_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu1c_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu1c_Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu32ll(Test_BFu1c_Sf_BFu32ll, "BFu1c_Sf_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu33  {
  unsigned char v1:1;
  ::empty v2;
  __tsu64 v3:33;
};
//SIG(1 BFu1c_Sf_BFu33) C1{ Fc:1 FC2{} FL:33}



static void Test_BFu1c_Sf_BFu33()
{
  {
    init_simple_test("BFu1c_Sf_BFu33");
    static BFu1c_Sf_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu33");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu1c_Sf_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu1c_Sf_BFu33");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu33(Test_BFu1c_Sf_BFu33, "BFu1c_Sf_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu7c  {
  unsigned char v1:1;
  ::empty v2;
  unsigned char v3:7;
};
//SIG(1 BFu1c_Sf_BFu7c) C1{ Fc:1 FC2{} Fc:7}



static void Test_BFu1c_Sf_BFu7c()
{
  {
    init_simple_test("BFu1c_Sf_BFu7c");
    static BFu1c_Sf_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(BFu1c_Sf_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_Sf_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu7c(Test_BFu1c_Sf_BFu7c, "BFu1c_Sf_BFu7c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu7i  {
  unsigned char v1:1;
  ::empty v2;
  unsigned int v3:7;
};
//SIG(1 BFu1c_Sf_BFu7i) C1{ Fc:1 FC2{} Fi:7}



static void Test_BFu1c_Sf_BFu7i()
{
  {
    init_simple_test("BFu1c_Sf_BFu7i");
    static BFu1c_Sf_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Sf_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_Sf_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_Sf_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu7i(Test_BFu1c_Sf_BFu7i, "BFu1c_Sf_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu7ll  {
  unsigned char v1:1;
  ::empty v2;
  __tsu64 v3:7;
};
//SIG(1 BFu1c_Sf_BFu7ll) C1{ Fc:1 FC2{} FL:7}



static void Test_BFu1c_Sf_BFu7ll()
{
  {
    init_simple_test("BFu1c_Sf_BFu7ll");
    static BFu1c_Sf_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_Sf_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu7ll(Test_BFu1c_Sf_BFu7ll, "BFu1c_Sf_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu7s  {
  unsigned char v1:1;
  ::empty v2;
  unsigned short v3:7;
};
//SIG(1 BFu1c_Sf_BFu7s) C1{ Fc:1 FC2{} Fs:7}



static void Test_BFu1c_Sf_BFu7s()
{
  {
    init_simple_test("BFu1c_Sf_BFu7s");
    static BFu1c_Sf_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Sf_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1c_Sf_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1c_Sf_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu7s(Test_BFu1c_Sf_BFu7s, "BFu1c_Sf_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu8c  {
  unsigned char v1:1;
  ::empty v2;
  unsigned char v3:8;
};
//SIG(1 BFu1c_Sf_BFu8c) C1{ Fc:1 FC2{} Fc:8}



static void Test_BFu1c_Sf_BFu8c()
{
  {
    init_simple_test("BFu1c_Sf_BFu8c");
    static BFu1c_Sf_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(BFu1c_Sf_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_Sf_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_Sf_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu8c(Test_BFu1c_Sf_BFu8c, "BFu1c_Sf_BFu8c", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu8i  {
  unsigned char v1:1;
  ::empty v2;
  unsigned int v3:8;
};
//SIG(1 BFu1c_Sf_BFu8i) C1{ Fc:1 FC2{} Fi:8}



static void Test_BFu1c_Sf_BFu8i()
{
  {
    init_simple_test("BFu1c_Sf_BFu8i");
    static BFu1c_Sf_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Sf_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_Sf_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_Sf_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu8i(Test_BFu1c_Sf_BFu8i, "BFu1c_Sf_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu8ll  {
  unsigned char v1:1;
  ::empty v2;
  __tsu64 v3:8;
};
//SIG(1 BFu1c_Sf_BFu8ll) C1{ Fc:1 FC2{} FL:8}



static void Test_BFu1c_Sf_BFu8ll()
{
  {
    init_simple_test("BFu1c_Sf_BFu8ll");
    static BFu1c_Sf_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_Sf_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu8ll(Test_BFu1c_Sf_BFu8ll, "BFu1c_Sf_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu8s  {
  unsigned char v1:1;
  ::empty v2;
  unsigned short v3:8;
};
//SIG(1 BFu1c_Sf_BFu8s) C1{ Fc:1 FC2{} Fs:8}



static void Test_BFu1c_Sf_BFu8s()
{
  {
    init_simple_test("BFu1c_Sf_BFu8s");
    static BFu1c_Sf_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Sf_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1c_Sf_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1c_Sf_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu8s(Test_BFu1c_Sf_BFu8s, "BFu1c_Sf_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu9i  {
  unsigned char v1:1;
  ::empty v2;
  unsigned int v3:9;
};
//SIG(1 BFu1c_Sf_BFu9i) C1{ Fc:1 FC2{} Fi:9}



static void Test_BFu1c_Sf_BFu9i()
{
  {
    init_simple_test("BFu1c_Sf_BFu9i");
    static BFu1c_Sf_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Sf_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1c_Sf_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_Sf_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu9i(Test_BFu1c_Sf_BFu9i, "BFu1c_Sf_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu9ll  {
  unsigned char v1:1;
  ::empty v2;
  __tsu64 v3:9;
};
//SIG(1 BFu1c_Sf_BFu9ll) C1{ Fc:1 FC2{} FL:9}



static void Test_BFu1c_Sf_BFu9ll()
{
  {
    init_simple_test("BFu1c_Sf_BFu9ll");
    static BFu1c_Sf_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1c_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1c_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_Sf_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu9ll(Test_BFu1c_Sf_BFu9ll, "BFu1c_Sf_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_BFu9s  {
  unsigned char v1:1;
  ::empty v2;
  unsigned short v3:9;
};
//SIG(1 BFu1c_Sf_BFu9s) C1{ Fc:1 FC2{} Fs:9}



static void Test_BFu1c_Sf_BFu9s()
{
  {
    init_simple_test("BFu1c_Sf_BFu9s");
    static BFu1c_Sf_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Sf_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1c_Sf_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1c_Sf_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_BFu9s(Test_BFu1c_Sf_BFu9s, "BFu1c_Sf_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_C  {
  unsigned char v1:1;
  ::empty v2;
  char v3;
};
//SIG(1 BFu1c_Sf_C) C1{ Fc:1 FC2{} Fc}



static void Test_BFu1c_Sf_C()
{
  {
    init_simple_test("BFu1c_Sf_C");
    static BFu1c_Sf_C lv;
    check2(sizeof(lv), 3, "sizeof(BFu1c_Sf_C)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_C");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_C.v2");
    check_field_offset(lv, v3, 2, "BFu1c_Sf_C.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_C(Test_BFu1c_Sf_C, "BFu1c_Sf_C", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_D  {
  unsigned char v1:1;
  ::empty v2;
  double v3;
};
//SIG(1 BFu1c_Sf_D) C1{ Fc:1 FC2{} FL}



static void Test_BFu1c_Sf_D()
{
  {
    init_simple_test("BFu1c_Sf_D");
    static BFu1c_Sf_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_Sf_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_D");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_Sf_D.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_D(Test_BFu1c_Sf_D, "BFu1c_Sf_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_F  {
  unsigned char v1:1;
  ::empty v2;
  float v3;
};
//SIG(1 BFu1c_Sf_F) C1{ Fc:1 FC2{} Fi}



static void Test_BFu1c_Sf_F()
{
  {
    init_simple_test("BFu1c_Sf_F");
    static BFu1c_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_Sf_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_F");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu1c_Sf_F.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_F(Test_BFu1c_Sf_F, "BFu1c_Sf_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_I  {
  unsigned char v1:1;
  ::empty v2;
  int v3;
};
//SIG(1 BFu1c_Sf_I) C1{ Fc:1 FC2{} Fi}



static void Test_BFu1c_Sf_I()
{
  {
    init_simple_test("BFu1c_Sf_I");
    static BFu1c_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_Sf_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_I");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu1c_Sf_I.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_I(Test_BFu1c_Sf_I, "BFu1c_Sf_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_Ip  {
  unsigned char v1:1;
  ::empty v2;
  int *v3;
};
//SIG(1 BFu1c_Sf_Ip) C1{ Fc:1 FC2{} Fp}



static void Test_BFu1c_Sf_Ip()
{
  {
    init_simple_test("BFu1c_Sf_Ip");
    static BFu1c_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_Ip");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_Sf_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_Ip(Test_BFu1c_Sf_Ip, "BFu1c_Sf_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_L  {
  unsigned char v1:1;
  ::empty v2;
  __tsi64 v3;
};
//SIG(1 BFu1c_Sf_L) C1{ Fc:1 FC2{} FL}



static void Test_BFu1c_Sf_L()
{
  {
    init_simple_test("BFu1c_Sf_L");
    static BFu1c_Sf_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_Sf_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_L");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_Sf_L.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_L(Test_BFu1c_Sf_L, "BFu1c_Sf_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_S  {
  unsigned char v1:1;
  ::empty v2;
  short v3;
};
//SIG(1 BFu1c_Sf_S) C1{ Fc:1 FC2{} Fs}



static void Test_BFu1c_Sf_S()
{
  {
    init_simple_test("BFu1c_Sf_S");
    static BFu1c_Sf_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Sf_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_S");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_S.v2");
    check_field_offset(lv, v3, 2, "BFu1c_Sf_S.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_S(Test_BFu1c_Sf_S, "BFu1c_Sf_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_Sf  {
  unsigned char v1:1;
  ::empty v2;
  ::empty v3;
};
//SIG(1 BFu1c_Sf_Sf) C1{ Fc:1 FC2{} FC2}



static void Test_BFu1c_Sf_Sf()
{
  {
    init_simple_test("BFu1c_Sf_Sf");
    static BFu1c_Sf_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu1c_Sf_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_Sf");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu1c_Sf_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_Sf(Test_BFu1c_Sf_Sf, "BFu1c_Sf_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_Uc  {
  unsigned char v1:1;
  ::empty v2;
  unsigned char v3;
};
//SIG(1 BFu1c_Sf_Uc) C1{ Fc:1 FC2{} Fc}



static void Test_BFu1c_Sf_Uc()
{
  {
    init_simple_test("BFu1c_Sf_Uc");
    static BFu1c_Sf_Uc lv;
    check2(sizeof(lv), 3, "sizeof(BFu1c_Sf_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_Uc");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu1c_Sf_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_Uc(Test_BFu1c_Sf_Uc, "BFu1c_Sf_Uc", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_Ui  {
  unsigned char v1:1;
  ::empty v2;
  unsigned int v3;
};
//SIG(1 BFu1c_Sf_Ui) C1{ Fc:1 FC2{} Fi}



static void Test_BFu1c_Sf_Ui()
{
  {
    init_simple_test("BFu1c_Sf_Ui");
    static BFu1c_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1c_Sf_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_Ui");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu1c_Sf_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_Ui(Test_BFu1c_Sf_Ui, "BFu1c_Sf_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_Ul  {
  unsigned char v1:1;
  ::empty v2;
  __tsu64 v3;
};
//SIG(1 BFu1c_Sf_Ul) C1{ Fc:1 FC2{} FL}



static void Test_BFu1c_Sf_Ul()
{
  {
    init_simple_test("BFu1c_Sf_Ul");
    static BFu1c_Sf_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1c_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_Ul");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_Sf_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_Ul(Test_BFu1c_Sf_Ul, "BFu1c_Sf_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_Us  {
  unsigned char v1:1;
  ::empty v2;
  unsigned short v3;
};
//SIG(1 BFu1c_Sf_Us) C1{ Fc:1 FC2{} Fs}



static void Test_BFu1c_Sf_Us()
{
  {
    init_simple_test("BFu1c_Sf_Us");
    static BFu1c_Sf_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1c_Sf_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_Us");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_Us.v2");
    check_field_offset(lv, v3, 2, "BFu1c_Sf_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_Us(Test_BFu1c_Sf_Us, "BFu1c_Sf_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Sf_Vp  {
  unsigned char v1:1;
  ::empty v2;
  void *v3;
};
//SIG(1 BFu1c_Sf_Vp) C1{ Fc:1 FC2{} Fp}



static void Test_BFu1c_Sf_Vp()
{
  {
    init_simple_test("BFu1c_Sf_Vp");
    static BFu1c_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1c_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Sf_Vp");
    check_field_offset(lv, v2, 1, "BFu1c_Sf_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1c_Sf_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Sf_Vp(Test_BFu1c_Sf_Vp, "BFu1c_Sf_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Uc_Sf  {
  unsigned char v1:1;
  unsigned char v2;
  ::empty v3;
};
//SIG(1 BFu1c_Uc_Sf) C1{ Fc:1 Fc FC2{}}



static void Test_BFu1c_Uc_Sf()
{
  {
    init_simple_test("BFu1c_Uc_Sf");
    static BFu1c_Uc_Sf lv;
    check2(sizeof(lv), 3, "sizeof(BFu1c_Uc_Sf)");
    check2(__alignof__(lv), 1, "__alignof__(BFu1c_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Uc_Sf");
    check_field_offset(lv, v2, 1, "BFu1c_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu1c_Uc_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Uc_Sf(Test_BFu1c_Uc_Sf, "BFu1c_Uc_Sf", 3);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Ui_Sf  {
  unsigned char v1:1;
  unsigned int v2;
  ::empty v3;
};
//SIG(1 BFu1c_Ui_Sf) C1{ Fc:1 Fi FC2{}}



static void Test_BFu1c_Ui_Sf()
{
  {
    init_simple_test("BFu1c_Ui_Sf");
    static BFu1c_Ui_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu1c_Ui_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1c_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu1c_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu1c_Ui_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Ui_Sf(Test_BFu1c_Ui_Sf, "BFu1c_Ui_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Ul_Sf  {
  unsigned char v1:1;
  __tsu64 v2;
  ::empty v3;
};
//SIG(1 BFu1c_Ul_Sf) C1{ Fc:1 FL FC2{}}



static void Test_BFu1c_Ul_Sf()
{
  {
    init_simple_test("BFu1c_Ul_Sf");
    static BFu1c_Ul_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu1c_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Ul_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Ul_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu1c_Ul_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Ul_Sf(Test_BFu1c_Ul_Sf, "BFu1c_Ul_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Us_Sf  {
  unsigned char v1:1;
  unsigned short v2;
  ::empty v3;
};
//SIG(1 BFu1c_Us_Sf) C1{ Fc:1 Fs FC2{}}



static void Test_BFu1c_Us_Sf()
{
  {
    init_simple_test("BFu1c_Us_Sf");
    static BFu1c_Us_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu1c_Us_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1c_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Us_Sf");
    check_field_offset(lv, v2, 2, "BFu1c_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu1c_Us_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Us_Sf(Test_BFu1c_Us_Sf, "BFu1c_Us_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1c_Vp_Sf  {
  unsigned char v1:1;
  void *v2;
  ::empty v3;
};
//SIG(1 BFu1c_Vp_Sf) C1{ Fc:1 Fp FC2{}}



static void Test_BFu1c_Vp_Sf()
{
  {
    init_simple_test("BFu1c_Vp_Sf");
    static BFu1c_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu1c_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1c_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1c_Vp_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1c_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu1c_Vp_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1c_Vp_Sf(Test_BFu1c_Vp_Sf, "BFu1c_Vp_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu15i_Sf  {
  unsigned int v1:1;
  unsigned int v2:15;
  ::empty v3;
};
//SIG(1 BFu1i_BFu15i_Sf) C1{ Fi:1 Fi:15 FC2{}}



static void Test_BFu1i_BFu15i_Sf()
{
  {
    init_simple_test("BFu1i_BFu15i_Sf");
    static BFu1i_BFu15i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15i_Sf");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu15i_Sf(Test_BFu1i_BFu15i_Sf, "BFu1i_BFu15i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu15ll_Sf  {
  unsigned int v1:1;
  __tsu64 v2:15;
  ::empty v3;
};
//SIG(1 BFu1i_BFu15ll_Sf) C1{ Fi:1 FL:15 FC2{}}



static void Test_BFu1i_BFu15ll_Sf()
{
  {
    init_simple_test("BFu1i_BFu15ll_Sf");
    static BFu1i_BFu15ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15ll_Sf");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu15ll_Sf(Test_BFu1i_BFu15ll_Sf, "BFu1i_BFu15ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu15s_Sf  {
  unsigned int v1:1;
  unsigned short v2:15;
  ::empty v3;
};
//SIG(1 BFu1i_BFu15s_Sf) C1{ Fi:1 Fs:15 FC2{}}



static void Test_BFu1i_BFu15s_Sf()
{
  {
    init_simple_test("BFu1i_BFu15s_Sf");
    static BFu1i_BFu15s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu15s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1i_BFu15s_Sf");
    check_field_offset(lv, v3, 2, "BFu1i_BFu15s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu15s_Sf(Test_BFu1i_BFu15s_Sf, "BFu1i_BFu15s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu16i_Sf  {
  unsigned int v1:1;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 BFu1i_BFu16i_Sf) C1{ Fi:1 Fi:16 FC2{}}



static void Test_BFu1i_BFu16i_Sf()
{
  {
    init_simple_test("BFu1i_BFu16i_Sf");
    static BFu1i_BFu16i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu16i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "BFu1i_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu16i_Sf(Test_BFu1i_BFu16i_Sf, "BFu1i_BFu16i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu16ll_Sf  {
  unsigned int v1:1;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 BFu1i_BFu16ll_Sf) C1{ Fi:1 FL:16 FC2{}}



static void Test_BFu1i_BFu16ll_Sf()
{
  {
    init_simple_test("BFu1i_BFu16ll_Sf");
    static BFu1i_BFu16ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1i_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "BFu1i_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu16ll_Sf(Test_BFu1i_BFu16ll_Sf, "BFu1i_BFu16ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu16s_Sf  {
  unsigned int v1:1;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 BFu1i_BFu16s_Sf) C1{ Fi:1 Fs:16 FC2{}}



static void Test_BFu1i_BFu16s_Sf()
{
  {
    init_simple_test("BFu1i_BFu16s_Sf");
    static BFu1i_BFu16s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu16s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "BFu1i_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu16s_Sf(Test_BFu1i_BFu16s_Sf, "BFu1i_BFu16s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu17i_Sf  {
  unsigned int v1:1;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 BFu1i_BFu17i_Sf) C1{ Fi:1 Fi:17 FC2{}}



static void Test_BFu1i_BFu17i_Sf()
{
  {
    init_simple_test("BFu1i_BFu17i_Sf");
    static BFu1i_BFu17i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu17i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17i_Sf");
    check_field_offset(lv, v3, 3, "BFu1i_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu17i_Sf(Test_BFu1i_BFu17i_Sf, "BFu1i_BFu17i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu17ll_Sf  {
  unsigned int v1:1;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 BFu1i_BFu17ll_Sf) C1{ Fi:1 FL:17 FC2{}}



static void Test_BFu1i_BFu17ll_Sf()
{
  {
    init_simple_test("BFu1i_BFu17ll_Sf");
    static BFu1i_BFu17ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1i_BFu17ll_Sf");
    check_field_offset(lv, v3, 3, "BFu1i_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu17ll_Sf(Test_BFu1i_BFu17ll_Sf, "BFu1i_BFu17ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu1c_Sf  {
  unsigned int v1:1;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 BFu1i_BFu1c_Sf) C1{ Fi:1 Fc:1 FC2{}}



static void Test_BFu1i_BFu1c_Sf()
{
  {
    init_simple_test("BFu1i_BFu1c_Sf");
    static BFu1i_BFu1c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1c_Sf");
    check_field_offset(lv, v3, 1, "BFu1i_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu1c_Sf(Test_BFu1i_BFu1c_Sf, "BFu1i_BFu1c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu1i_Sf  {
  unsigned int v1:1;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 BFu1i_BFu1i_Sf) C1{ Fi:1 Fi:1 FC2{}}



static void Test_BFu1i_BFu1i_Sf()
{
  {
    init_simple_test("BFu1i_BFu1i_Sf");
    static BFu1i_BFu1i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1i_Sf");
    check_field_offset(lv, v3, 1, "BFu1i_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu1i_Sf(Test_BFu1i_BFu1i_Sf, "BFu1i_BFu1i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu1ll_Sf  {
  unsigned int v1:1;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 BFu1i_BFu1ll_Sf) C1{ Fi:1 FL:1 FC2{}}



static void Test_BFu1i_BFu1ll_Sf()
{
  {
    init_simple_test("BFu1i_BFu1ll_Sf");
    static BFu1i_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1ll_Sf");
    check_field_offset(lv, v3, 1, "BFu1i_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu1ll_Sf(Test_BFu1i_BFu1ll_Sf, "BFu1i_BFu1ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu1s_Sf  {
  unsigned int v1:1;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 BFu1i_BFu1s_Sf) C1{ Fi:1 Fs:1 FC2{}}



static void Test_BFu1i_BFu1s_Sf()
{
  {
    init_simple_test("BFu1i_BFu1s_Sf");
    static BFu1i_BFu1s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu1s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu1s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1i_BFu1s_Sf");
    check_field_offset(lv, v3, 1, "BFu1i_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu1s_Sf(Test_BFu1i_BFu1s_Sf, "BFu1i_BFu1s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu31i_Sf  {
  unsigned int v1:1;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 BFu1i_BFu31i_Sf) C1{ Fi:1 Fi:31 FC2{}}



static void Test_BFu1i_BFu31i_Sf()
{
  {
    init_simple_test("BFu1i_BFu31i_Sf");
    static BFu1i_BFu31i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31i_Sf");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu31i_Sf(Test_BFu1i_BFu31i_Sf, "BFu1i_BFu31i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu31ll_Sf  {
  unsigned int v1:1;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 BFu1i_BFu31ll_Sf) C1{ Fi:1 FL:31 FC2{}}



static void Test_BFu1i_BFu31ll_Sf()
{
  {
    init_simple_test("BFu1i_BFu31ll_Sf");
    static BFu1i_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1i_BFu31ll_Sf");
    check_field_offset(lv, v3, 4, "BFu1i_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu31ll_Sf(Test_BFu1i_BFu31ll_Sf, "BFu1i_BFu31ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu32i_Sf  {
  unsigned int v1:1;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 BFu1i_BFu32i_Sf) C1{ Fi:1 Fi:32 FC2{}}



static void Test_BFu1i_BFu32i_Sf()
{
  {
    init_simple_test("BFu1i_BFu32i_Sf");
    static BFu1i_BFu32i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_BFu32i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu1i_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu32i_Sf(Test_BFu1i_BFu32i_Sf, "BFu1i_BFu32i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu32ll_Sf  {
  unsigned int v1:1;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 BFu1i_BFu32ll_Sf) C1{ Fi:1 FL:32 FC2{}}



static void Test_BFu1i_BFu32ll_Sf()
{
  {
    init_simple_test("BFu1i_BFu32ll_Sf");
    static BFu1i_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1i_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "BFu1i_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu32ll_Sf(Test_BFu1i_BFu32ll_Sf, "BFu1i_BFu32ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu33_Sf  {
  unsigned int v1:1;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 BFu1i_BFu33_Sf) C1{ Fi:1 FL:33 FC2{}}



static void Test_BFu1i_BFu33_Sf()
{
  {
    init_simple_test("BFu1i_BFu33_Sf");
    static BFu1i_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1i_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1i_BFu33_Sf");
    check_field_offset(lv, v3, 5, "BFu1i_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu33_Sf(Test_BFu1i_BFu33_Sf, "BFu1i_BFu33_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu7c_Sf  {
  unsigned int v1:1;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 BFu1i_BFu7c_Sf) C1{ Fi:1 Fc:7 FC2{}}



static void Test_BFu1i_BFu7c_Sf()
{
  {
    init_simple_test("BFu1i_BFu7c_Sf");
    static BFu1i_BFu7c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7c_Sf");
    check_field_offset(lv, v3, 1, "BFu1i_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu7c_Sf(Test_BFu1i_BFu7c_Sf, "BFu1i_BFu7c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu7i_Sf  {
  unsigned int v1:1;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 BFu1i_BFu7i_Sf) C1{ Fi:1 Fi:7 FC2{}}



static void Test_BFu1i_BFu7i_Sf()
{
  {
    init_simple_test("BFu1i_BFu7i_Sf");
    static BFu1i_BFu7i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7i_Sf");
    check_field_offset(lv, v3, 1, "BFu1i_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu7i_Sf(Test_BFu1i_BFu7i_Sf, "BFu1i_BFu7i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu7ll_Sf  {
  unsigned int v1:1;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 BFu1i_BFu7ll_Sf) C1{ Fi:1 FL:7 FC2{}}



static void Test_BFu1i_BFu7ll_Sf()
{
  {
    init_simple_test("BFu1i_BFu7ll_Sf");
    static BFu1i_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7ll_Sf");
    check_field_offset(lv, v3, 1, "BFu1i_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu7ll_Sf(Test_BFu1i_BFu7ll_Sf, "BFu1i_BFu7ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu7s_Sf  {
  unsigned int v1:1;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 BFu1i_BFu7s_Sf) C1{ Fi:1 Fs:7 FC2{}}



static void Test_BFu1i_BFu7s_Sf()
{
  {
    init_simple_test("BFu1i_BFu7s_Sf");
    static BFu1i_BFu7s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu7s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1i_BFu7s_Sf");
    check_field_offset(lv, v3, 1, "BFu1i_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu7s_Sf(Test_BFu1i_BFu7s_Sf, "BFu1i_BFu7s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu8c_Sf  {
  unsigned int v1:1;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 BFu1i_BFu8c_Sf) C1{ Fi:1 Fc:8 FC2{}}



static void Test_BFu1i_BFu8c_Sf()
{
  {
    init_simple_test("BFu1i_BFu8c_Sf");
    static BFu1i_BFu8c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu8c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1i_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "BFu1i_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu8c_Sf(Test_BFu1i_BFu8c_Sf, "BFu1i_BFu8c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu8i_Sf  {
  unsigned int v1:1;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 BFu1i_BFu8i_Sf) C1{ Fi:1 Fi:8 FC2{}}



static void Test_BFu1i_BFu8i_Sf()
{
  {
    init_simple_test("BFu1i_BFu8i_Sf");
    static BFu1i_BFu8i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu8i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "BFu1i_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu8i_Sf(Test_BFu1i_BFu8i_Sf, "BFu1i_BFu8i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu8ll_Sf  {
  unsigned int v1:1;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 BFu1i_BFu8ll_Sf) C1{ Fi:1 FL:8 FC2{}}



static void Test_BFu1i_BFu8ll_Sf()
{
  {
    init_simple_test("BFu1i_BFu8ll_Sf");
    static BFu1i_BFu8ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "BFu1i_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu8ll_Sf(Test_BFu1i_BFu8ll_Sf, "BFu1i_BFu8ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu8s_Sf  {
  unsigned int v1:1;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 BFu1i_BFu8s_Sf) C1{ Fi:1 Fs:8 FC2{}}



static void Test_BFu1i_BFu8s_Sf()
{
  {
    init_simple_test("BFu1i_BFu8s_Sf");
    static BFu1i_BFu8s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu8s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1i_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "BFu1i_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu8s_Sf(Test_BFu1i_BFu8s_Sf, "BFu1i_BFu8s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu9i_Sf  {
  unsigned int v1:1;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 BFu1i_BFu9i_Sf) C1{ Fi:1 Fi:9 FC2{}}



static void Test_BFu1i_BFu9i_Sf()
{
  {
    init_simple_test("BFu1i_BFu9i_Sf");
    static BFu1i_BFu9i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu9i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9i_Sf");
    check_field_offset(lv, v3, 2, "BFu1i_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu9i_Sf(Test_BFu1i_BFu9i_Sf, "BFu1i_BFu9i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu9ll_Sf  {
  unsigned int v1:1;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 BFu1i_BFu9ll_Sf) C1{ Fi:1 FL:9 FC2{}}



static void Test_BFu1i_BFu9ll_Sf()
{
  {
    init_simple_test("BFu1i_BFu9ll_Sf");
    static BFu1i_BFu9ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9ll_Sf");
    check_field_offset(lv, v3, 2, "BFu1i_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu9ll_Sf(Test_BFu1i_BFu9ll_Sf, "BFu1i_BFu9ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_BFu9s_Sf  {
  unsigned int v1:1;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 BFu1i_BFu9s_Sf) C1{ Fi:1 Fs:9 FC2{}}



static void Test_BFu1i_BFu9s_Sf()
{
  {
    init_simple_test("BFu1i_BFu9s_Sf");
    static BFu1i_BFu9s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_BFu9s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1i_BFu9s_Sf");
    check_field_offset(lv, v3, 2, "BFu1i_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_BFu9s_Sf(Test_BFu1i_BFu9s_Sf, "BFu1i_BFu9s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_C_Sf  {
  unsigned int v1:1;
  char v2;
  ::empty v3;
};
//SIG(1 BFu1i_C_Sf) C1{ Fi:1 Fc FC2{}}



static void Test_BFu1i_C_Sf()
{
  {
    init_simple_test("BFu1i_C_Sf");
    static BFu1i_C_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_C_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_C_Sf");
    check_field_offset(lv, v2, 1, "BFu1i_C_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu1i_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_C_Sf(Test_BFu1i_C_Sf, "BFu1i_C_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_D_Sf  {
  unsigned int v1:1;
  double v2;
  ::empty v3;
};
//SIG(1 BFu1i_D_Sf) C1{ Fi:1 FL FC2{}}



static void Test_BFu1i_D_Sf()
{
  {
    init_simple_test("BFu1i_D_Sf");
    static BFu1i_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu1i_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_D_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu1i_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_D_Sf(Test_BFu1i_D_Sf, "BFu1i_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_F_Sf  {
  unsigned int v1:1;
  float v2;
  ::empty v3;
};
//SIG(1 BFu1i_F_Sf) C1{ Fi:1 Fi FC2{}}



static void Test_BFu1i_F_Sf()
{
  {
    init_simple_test("BFu1i_F_Sf");
    static BFu1i_F_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_F_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_F_Sf");
    check_field_offset(lv, v2, 4, "BFu1i_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu1i_F_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_F_Sf(Test_BFu1i_F_Sf, "BFu1i_F_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_I_Sf  {
  unsigned int v1:1;
  int v2;
  ::empty v3;
};
//SIG(1 BFu1i_I_Sf) C1{ Fi:1 Fi FC2{}}



static void Test_BFu1i_I_Sf()
{
  {
    init_simple_test("BFu1i_I_Sf");
    static BFu1i_I_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_I_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_I_Sf");
    check_field_offset(lv, v2, 4, "BFu1i_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu1i_I_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_I_Sf(Test_BFu1i_I_Sf, "BFu1i_I_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Ip_Sf  {
  unsigned int v1:1;
  int *v2;
  ::empty v3;
};
//SIG(1 BFu1i_Ip_Sf) C1{ Fi:1 Fp FC2{}}



static void Test_BFu1i_Ip_Sf()
{
  {
    init_simple_test("BFu1i_Ip_Sf");
    static BFu1i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu1i_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ip_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu1i_Ip_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Ip_Sf(Test_BFu1i_Ip_Sf, "BFu1i_Ip_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_L_Sf  {
  unsigned int v1:1;
  __tsi64 v2;
  ::empty v3;
};
//SIG(1 BFu1i_L_Sf) C1{ Fi:1 FL FC2{}}



static void Test_BFu1i_L_Sf()
{
  {
    init_simple_test("BFu1i_L_Sf");
    static BFu1i_L_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu1i_L_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_L_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_L_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu1i_L_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_L_Sf(Test_BFu1i_L_Sf, "BFu1i_L_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_S_Sf  {
  unsigned int v1:1;
  short v2;
  ::empty v3;
};
//SIG(1 BFu1i_S_Sf) C1{ Fi:1 Fs FC2{}}



static void Test_BFu1i_S_Sf()
{
  {
    init_simple_test("BFu1i_S_Sf");
    static BFu1i_S_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_S_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_S_Sf");
    check_field_offset(lv, v2, 2, "BFu1i_S_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu1i_S_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_S_Sf(Test_BFu1i_S_Sf, "BFu1i_S_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf  {
  unsigned int v1:1;
  ::empty v2;
};
//SIG(1 BFu1i_Sf) C1{ Fi:1 FC2{}}



static void Test_BFu1i_Sf()
{
  {
    init_simple_test("BFu1i_Sf");
    static BFu1i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf");
    check_field_offset(lv, v2, 1, "BFu1i_Sf.v2");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf(Test_BFu1i_Sf, "BFu1i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu15i  {
  unsigned int v1:1;
  ::empty v2;
  unsigned int v3:15;
};
//SIG(1 BFu1i_Sf_BFu15i) C1{ Fi:1 FC2{} Fi:15}



static void Test_BFu1i_Sf_BFu15i()
{
  {
    init_simple_test("BFu1i_Sf_BFu15i");
    static BFu1i_Sf_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_Sf_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu15i(Test_BFu1i_Sf_BFu15i, "BFu1i_Sf_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu15ll  {
  unsigned int v1:1;
  ::empty v2;
  __tsu64 v3:15;
};
//SIG(1 BFu1i_Sf_BFu15ll) C1{ Fi:1 FC2{} FL:15}



static void Test_BFu1i_Sf_BFu15ll()
{
  {
    init_simple_test("BFu1i_Sf_BFu15ll");
    static BFu1i_Sf_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_Sf_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu15ll(Test_BFu1i_Sf_BFu15ll, "BFu1i_Sf_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu15s  {
  unsigned int v1:1;
  ::empty v2;
  unsigned short v3:15;
};
//SIG(1 BFu1i_Sf_BFu15s) C1{ Fi:1 FC2{} Fs:15}



static void Test_BFu1i_Sf_BFu15s()
{
  {
    init_simple_test("BFu1i_Sf_BFu15s");
    static BFu1i_Sf_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1i_Sf_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu15s(Test_BFu1i_Sf_BFu15s, "BFu1i_Sf_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu16i  {
  unsigned int v1:1;
  ::empty v2;
  unsigned int v3:16;
};
//SIG(1 BFu1i_Sf_BFu16i) C1{ Fi:1 FC2{} Fi:16}



static void Test_BFu1i_Sf_BFu16i()
{
  {
    init_simple_test("BFu1i_Sf_BFu16i");
    static BFu1i_Sf_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_Sf_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu16i(Test_BFu1i_Sf_BFu16i, "BFu1i_Sf_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu16ll  {
  unsigned int v1:1;
  ::empty v2;
  __tsu64 v3:16;
};
//SIG(1 BFu1i_Sf_BFu16ll) C1{ Fi:1 FC2{} FL:16}



static void Test_BFu1i_Sf_BFu16ll()
{
  {
    init_simple_test("BFu1i_Sf_BFu16ll");
    static BFu1i_Sf_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu16ll(Test_BFu1i_Sf_BFu16ll, "BFu1i_Sf_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu16s  {
  unsigned int v1:1;
  ::empty v2;
  unsigned short v3:16;
};
//SIG(1 BFu1i_Sf_BFu16s) C1{ Fi:1 FC2{} Fs:16}



static void Test_BFu1i_Sf_BFu16s()
{
  {
    init_simple_test("BFu1i_Sf_BFu16s");
    static BFu1i_Sf_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1i_Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu16s(Test_BFu1i_Sf_BFu16s, "BFu1i_Sf_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu17i  {
  unsigned int v1:1;
  ::empty v2;
  unsigned int v3:17;
};
//SIG(1 BFu1i_Sf_BFu17i) C1{ Fi:1 FC2{} Fi:17}



static void Test_BFu1i_Sf_BFu17i()
{
  {
    init_simple_test("BFu1i_Sf_BFu17i");
    static BFu1i_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Sf_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1i_Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu17i(Test_BFu1i_Sf_BFu17i, "BFu1i_Sf_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu17ll  {
  unsigned int v1:1;
  ::empty v2;
  __tsu64 v3:17;
};
//SIG(1 BFu1i_Sf_BFu17ll) C1{ Fi:1 FC2{} FL:17}



static void Test_BFu1i_Sf_BFu17ll()
{
  {
    init_simple_test("BFu1i_Sf_BFu17ll");
    static BFu1i_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu1i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu1i_Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu17ll(Test_BFu1i_Sf_BFu17ll, "BFu1i_Sf_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu1c  {
  unsigned int v1:1;
  ::empty v2;
  unsigned char v3:1;
};
//SIG(1 BFu1i_Sf_BFu1c) C1{ Fi:1 FC2{} Fc:1}



static void Test_BFu1i_Sf_BFu1c()
{
  {
    init_simple_test("BFu1i_Sf_BFu1c");
    static BFu1i_Sf_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu1c(Test_BFu1i_Sf_BFu1c, "BFu1i_Sf_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu1i  {
  unsigned int v1:1;
  ::empty v2;
  unsigned int v3:1;
};
//SIG(1 BFu1i_Sf_BFu1i) C1{ Fi:1 FC2{} Fi:1}



static void Test_BFu1i_Sf_BFu1i()
{
  {
    init_simple_test("BFu1i_Sf_BFu1i");
    static BFu1i_Sf_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu1i(Test_BFu1i_Sf_BFu1i, "BFu1i_Sf_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu1ll  {
  unsigned int v1:1;
  ::empty v2;
  __tsu64 v3:1;
};
//SIG(1 BFu1i_Sf_BFu1ll) C1{ Fi:1 FC2{} FL:1}



static void Test_BFu1i_Sf_BFu1ll()
{
  {
    init_simple_test("BFu1i_Sf_BFu1ll");
    static BFu1i_Sf_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu1ll(Test_BFu1i_Sf_BFu1ll, "BFu1i_Sf_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu1s  {
  unsigned int v1:1;
  ::empty v2;
  unsigned short v3:1;
};
//SIG(1 BFu1i_Sf_BFu1s) C1{ Fi:1 FC2{} Fs:1}



static void Test_BFu1i_Sf_BFu1s()
{
  {
    init_simple_test("BFu1i_Sf_BFu1s");
    static BFu1i_Sf_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1i_Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu1s(Test_BFu1i_Sf_BFu1s, "BFu1i_Sf_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu31i  {
  unsigned int v1:1;
  ::empty v2;
  unsigned int v3:31;
};
//SIG(1 BFu1i_Sf_BFu31i) C1{ Fi:1 FC2{} Fi:31}



static void Test_BFu1i_Sf_BFu31i()
{
  {
    init_simple_test("BFu1i_Sf_BFu31i");
    static BFu1i_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Sf_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1i_Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu31i(Test_BFu1i_Sf_BFu31i, "BFu1i_Sf_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu31ll  {
  unsigned int v1:1;
  ::empty v2;
  __tsu64 v3:31;
};
//SIG(1 BFu1i_Sf_BFu31ll) C1{ Fi:1 FC2{} FL:31}



static void Test_BFu1i_Sf_BFu31ll()
{
  {
    init_simple_test("BFu1i_Sf_BFu31ll");
    static BFu1i_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu1i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu1i_Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu31ll(Test_BFu1i_Sf_BFu31ll, "BFu1i_Sf_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu32i  {
  unsigned int v1:1;
  ::empty v2;
  unsigned int v3:32;
};
//SIG(1 BFu1i_Sf_BFu32i) C1{ Fi:1 FC2{} Fi:32}



static void Test_BFu1i_Sf_BFu32i()
{
  {
    init_simple_test("BFu1i_Sf_BFu32i");
    static BFu1i_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Sf_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1i_Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu32i(Test_BFu1i_Sf_BFu32i, "BFu1i_Sf_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu32ll  {
  unsigned int v1:1;
  ::empty v2;
  __tsu64 v3:32;
};
//SIG(1 BFu1i_Sf_BFu32ll) C1{ Fi:1 FC2{} FL:32}



static void Test_BFu1i_Sf_BFu32ll()
{
  {
    init_simple_test("BFu1i_Sf_BFu32ll");
    static BFu1i_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu1i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu1i_Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu32ll(Test_BFu1i_Sf_BFu32ll, "BFu1i_Sf_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu33  {
  unsigned int v1:1;
  ::empty v2;
  __tsu64 v3:33;
};
//SIG(1 BFu1i_Sf_BFu33) C1{ Fi:1 FC2{} FL:33}



static void Test_BFu1i_Sf_BFu33()
{
  {
    init_simple_test("BFu1i_Sf_BFu33");
    static BFu1i_Sf_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu33");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu1i_Sf_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu1i_Sf_BFu33");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu33(Test_BFu1i_Sf_BFu33, "BFu1i_Sf_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu7c  {
  unsigned int v1:1;
  ::empty v2;
  unsigned char v3:7;
};
//SIG(1 BFu1i_Sf_BFu7c) C1{ Fi:1 FC2{} Fc:7}



static void Test_BFu1i_Sf_BFu7c()
{
  {
    init_simple_test("BFu1i_Sf_BFu7c");
    static BFu1i_Sf_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu7c(Test_BFu1i_Sf_BFu7c, "BFu1i_Sf_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu7i  {
  unsigned int v1:1;
  ::empty v2;
  unsigned int v3:7;
};
//SIG(1 BFu1i_Sf_BFu7i) C1{ Fi:1 FC2{} Fi:7}



static void Test_BFu1i_Sf_BFu7i()
{
  {
    init_simple_test("BFu1i_Sf_BFu7i");
    static BFu1i_Sf_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_Sf_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu7i(Test_BFu1i_Sf_BFu7i, "BFu1i_Sf_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu7ll  {
  unsigned int v1:1;
  ::empty v2;
  __tsu64 v3:7;
};
//SIG(1 BFu1i_Sf_BFu7ll) C1{ Fi:1 FC2{} FL:7}



static void Test_BFu1i_Sf_BFu7ll()
{
  {
    init_simple_test("BFu1i_Sf_BFu7ll");
    static BFu1i_Sf_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_Sf_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu7ll(Test_BFu1i_Sf_BFu7ll, "BFu1i_Sf_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu7s  {
  unsigned int v1:1;
  ::empty v2;
  unsigned short v3:7;
};
//SIG(1 BFu1i_Sf_BFu7s) C1{ Fi:1 FC2{} Fs:7}



static void Test_BFu1i_Sf_BFu7s()
{
  {
    init_simple_test("BFu1i_Sf_BFu7s");
    static BFu1i_Sf_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1i_Sf_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu7s(Test_BFu1i_Sf_BFu7s, "BFu1i_Sf_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu8c  {
  unsigned int v1:1;
  ::empty v2;
  unsigned char v3:8;
};
//SIG(1 BFu1i_Sf_BFu8c) C1{ Fi:1 FC2{} Fc:8}



static void Test_BFu1i_Sf_BFu8c()
{
  {
    init_simple_test("BFu1i_Sf_BFu8c");
    static BFu1i_Sf_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_Sf_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu8c(Test_BFu1i_Sf_BFu8c, "BFu1i_Sf_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu8i  {
  unsigned int v1:1;
  ::empty v2;
  unsigned int v3:8;
};
//SIG(1 BFu1i_Sf_BFu8i) C1{ Fi:1 FC2{} Fi:8}



static void Test_BFu1i_Sf_BFu8i()
{
  {
    init_simple_test("BFu1i_Sf_BFu8i");
    static BFu1i_Sf_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_Sf_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_Sf_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu8i(Test_BFu1i_Sf_BFu8i, "BFu1i_Sf_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu8ll  {
  unsigned int v1:1;
  ::empty v2;
  __tsu64 v3:8;
};
//SIG(1 BFu1i_Sf_BFu8ll) C1{ Fi:1 FC2{} FL:8}



static void Test_BFu1i_Sf_BFu8ll()
{
  {
    init_simple_test("BFu1i_Sf_BFu8ll");
    static BFu1i_Sf_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_Sf_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu8ll(Test_BFu1i_Sf_BFu8ll, "BFu1i_Sf_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu8s  {
  unsigned int v1:1;
  ::empty v2;
  unsigned short v3:8;
};
//SIG(1 BFu1i_Sf_BFu8s) C1{ Fi:1 FC2{} Fs:8}



static void Test_BFu1i_Sf_BFu8s()
{
  {
    init_simple_test("BFu1i_Sf_BFu8s");
    static BFu1i_Sf_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1i_Sf_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1i_Sf_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu8s(Test_BFu1i_Sf_BFu8s, "BFu1i_Sf_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu9i  {
  unsigned int v1:1;
  ::empty v2;
  unsigned int v3:9;
};
//SIG(1 BFu1i_Sf_BFu9i) C1{ Fi:1 FC2{} Fi:9}



static void Test_BFu1i_Sf_BFu9i()
{
  {
    init_simple_test("BFu1i_Sf_BFu9i");
    static BFu1i_Sf_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1i_Sf_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_Sf_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu9i(Test_BFu1i_Sf_BFu9i, "BFu1i_Sf_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu9ll  {
  unsigned int v1:1;
  ::empty v2;
  __tsu64 v3:9;
};
//SIG(1 BFu1i_Sf_BFu9ll) C1{ Fi:1 FC2{} FL:9}



static void Test_BFu1i_Sf_BFu9ll()
{
  {
    init_simple_test("BFu1i_Sf_BFu9ll");
    static BFu1i_Sf_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1i_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1i_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_Sf_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu9ll(Test_BFu1i_Sf_BFu9ll, "BFu1i_Sf_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_BFu9s  {
  unsigned int v1:1;
  ::empty v2;
  unsigned short v3:9;
};
//SIG(1 BFu1i_Sf_BFu9s) C1{ Fi:1 FC2{} Fs:9}



static void Test_BFu1i_Sf_BFu9s()
{
  {
    init_simple_test("BFu1i_Sf_BFu9s");
    static BFu1i_Sf_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1i_Sf_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1i_Sf_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_BFu9s(Test_BFu1i_Sf_BFu9s, "BFu1i_Sf_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_C  {
  unsigned int v1:1;
  ::empty v2;
  char v3;
};
//SIG(1 BFu1i_Sf_C) C1{ Fi:1 FC2{} Fc}



static void Test_BFu1i_Sf_C()
{
  {
    init_simple_test("BFu1i_Sf_C");
    static BFu1i_Sf_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_C");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_C.v2");
    check_field_offset(lv, v3, 2, "BFu1i_Sf_C.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_C(Test_BFu1i_Sf_C, "BFu1i_Sf_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_D  {
  unsigned int v1:1;
  ::empty v2;
  double v3;
};
//SIG(1 BFu1i_Sf_D) C1{ Fi:1 FC2{} FL}



static void Test_BFu1i_Sf_D()
{
  {
    init_simple_test("BFu1i_Sf_D");
    static BFu1i_Sf_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_Sf_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_D");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_Sf_D.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_D(Test_BFu1i_Sf_D, "BFu1i_Sf_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_F  {
  unsigned int v1:1;
  ::empty v2;
  float v3;
};
//SIG(1 BFu1i_Sf_F) C1{ Fi:1 FC2{} Fi}



static void Test_BFu1i_Sf_F()
{
  {
    init_simple_test("BFu1i_Sf_F");
    static BFu1i_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Sf_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_F");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu1i_Sf_F.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_F(Test_BFu1i_Sf_F, "BFu1i_Sf_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_I  {
  unsigned int v1:1;
  ::empty v2;
  int v3;
};
//SIG(1 BFu1i_Sf_I) C1{ Fi:1 FC2{} Fi}



static void Test_BFu1i_Sf_I()
{
  {
    init_simple_test("BFu1i_Sf_I");
    static BFu1i_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Sf_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_I");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu1i_Sf_I.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_I(Test_BFu1i_Sf_I, "BFu1i_Sf_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_Ip  {
  unsigned int v1:1;
  ::empty v2;
  int *v3;
};
//SIG(1 BFu1i_Sf_Ip) C1{ Fi:1 FC2{} Fp}



static void Test_BFu1i_Sf_Ip()
{
  {
    init_simple_test("BFu1i_Sf_Ip");
    static BFu1i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_Ip");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_Sf_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_Ip(Test_BFu1i_Sf_Ip, "BFu1i_Sf_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_L  {
  unsigned int v1:1;
  ::empty v2;
  __tsi64 v3;
};
//SIG(1 BFu1i_Sf_L) C1{ Fi:1 FC2{} FL}



static void Test_BFu1i_Sf_L()
{
  {
    init_simple_test("BFu1i_Sf_L");
    static BFu1i_Sf_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_Sf_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_L");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_Sf_L.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_L(Test_BFu1i_Sf_L, "BFu1i_Sf_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_S  {
  unsigned int v1:1;
  ::empty v2;
  short v3;
};
//SIG(1 BFu1i_Sf_S) C1{ Fi:1 FC2{} Fs}



static void Test_BFu1i_Sf_S()
{
  {
    init_simple_test("BFu1i_Sf_S");
    static BFu1i_Sf_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_S");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_S.v2");
    check_field_offset(lv, v3, 2, "BFu1i_Sf_S.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_S(Test_BFu1i_Sf_S, "BFu1i_Sf_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_Sf  {
  unsigned int v1:1;
  ::empty v2;
  ::empty v3;
};
//SIG(1 BFu1i_Sf_Sf) C1{ Fi:1 FC2{} FC2}



static void Test_BFu1i_Sf_Sf()
{
  {
    init_simple_test("BFu1i_Sf_Sf");
    static BFu1i_Sf_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_Sf");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu1i_Sf_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_Sf(Test_BFu1i_Sf_Sf, "BFu1i_Sf_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_Uc  {
  unsigned int v1:1;
  ::empty v2;
  unsigned char v3;
};
//SIG(1 BFu1i_Sf_Uc) C1{ Fi:1 FC2{} Fc}



static void Test_BFu1i_Sf_Uc()
{
  {
    init_simple_test("BFu1i_Sf_Uc");
    static BFu1i_Sf_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_Uc");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu1i_Sf_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_Uc(Test_BFu1i_Sf_Uc, "BFu1i_Sf_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_Ui  {
  unsigned int v1:1;
  ::empty v2;
  unsigned int v3;
};
//SIG(1 BFu1i_Sf_Ui) C1{ Fi:1 FC2{} Fi}



static void Test_BFu1i_Sf_Ui()
{
  {
    init_simple_test("BFu1i_Sf_Ui");
    static BFu1i_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Sf_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_Ui");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu1i_Sf_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_Ui(Test_BFu1i_Sf_Ui, "BFu1i_Sf_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_Ul  {
  unsigned int v1:1;
  ::empty v2;
  __tsu64 v3;
};
//SIG(1 BFu1i_Sf_Ul) C1{ Fi:1 FC2{} FL}



static void Test_BFu1i_Sf_Ul()
{
  {
    init_simple_test("BFu1i_Sf_Ul");
    static BFu1i_Sf_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1i_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_Ul");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_Sf_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_Ul(Test_BFu1i_Sf_Ul, "BFu1i_Sf_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_Us  {
  unsigned int v1:1;
  ::empty v2;
  unsigned short v3;
};
//SIG(1 BFu1i_Sf_Us) C1{ Fi:1 FC2{} Fs}



static void Test_BFu1i_Sf_Us()
{
  {
    init_simple_test("BFu1i_Sf_Us");
    static BFu1i_Sf_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Sf_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_Us");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_Us.v2");
    check_field_offset(lv, v3, 2, "BFu1i_Sf_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_Us(Test_BFu1i_Sf_Us, "BFu1i_Sf_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Sf_Vp  {
  unsigned int v1:1;
  ::empty v2;
  void *v3;
};
//SIG(1 BFu1i_Sf_Vp) C1{ Fi:1 FC2{} Fp}



static void Test_BFu1i_Sf_Vp()
{
  {
    init_simple_test("BFu1i_Sf_Vp");
    static BFu1i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1i_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Sf_Vp");
    check_field_offset(lv, v2, 1, "BFu1i_Sf_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1i_Sf_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Sf_Vp(Test_BFu1i_Sf_Vp, "BFu1i_Sf_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Uc_Sf  {
  unsigned int v1:1;
  unsigned char v2;
  ::empty v3;
};
//SIG(1 BFu1i_Uc_Sf) C1{ Fi:1 Fc FC2{}}



static void Test_BFu1i_Uc_Sf()
{
  {
    init_simple_test("BFu1i_Uc_Sf");
    static BFu1i_Uc_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1i_Uc_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Uc_Sf");
    check_field_offset(lv, v2, 1, "BFu1i_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu1i_Uc_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Uc_Sf(Test_BFu1i_Uc_Sf, "BFu1i_Uc_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Ui_Sf  {
  unsigned int v1:1;
  unsigned int v2;
  ::empty v3;
};
//SIG(1 BFu1i_Ui_Sf) C1{ Fi:1 Fi FC2{}}



static void Test_BFu1i_Ui_Sf()
{
  {
    init_simple_test("BFu1i_Ui_Sf");
    static BFu1i_Ui_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu1i_Ui_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu1i_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu1i_Ui_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Ui_Sf(Test_BFu1i_Ui_Sf, "BFu1i_Ui_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Ul_Sf  {
  unsigned int v1:1;
  __tsu64 v2;
  ::empty v3;
};
//SIG(1 BFu1i_Ul_Sf) C1{ Fi:1 FL FC2{}}



static void Test_BFu1i_Ul_Sf()
{
  {
    init_simple_test("BFu1i_Ul_Sf");
    static BFu1i_Ul_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu1i_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Ul_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Ul_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu1i_Ul_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Ul_Sf(Test_BFu1i_Ul_Sf, "BFu1i_Ul_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Us_Sf  {
  unsigned int v1:1;
  unsigned short v2;
  ::empty v3;
};
//SIG(1 BFu1i_Us_Sf) C1{ Fi:1 Fs FC2{}}



static void Test_BFu1i_Us_Sf()
{
  {
    init_simple_test("BFu1i_Us_Sf");
    static BFu1i_Us_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1i_Us_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1i_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Us_Sf");
    check_field_offset(lv, v2, 2, "BFu1i_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu1i_Us_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Us_Sf(Test_BFu1i_Us_Sf, "BFu1i_Us_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1i_Vp_Sf  {
  unsigned int v1:1;
  void *v2;
  ::empty v3;
};
//SIG(1 BFu1i_Vp_Sf) C1{ Fi:1 Fp FC2{}}



static void Test_BFu1i_Vp_Sf()
{
  {
    init_simple_test("BFu1i_Vp_Sf");
    static BFu1i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu1i_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1i_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1i_Vp_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1i_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu1i_Vp_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1i_Vp_Sf(Test_BFu1i_Vp_Sf, "BFu1i_Vp_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu15i_Sf  {
  __tsu64 v1:1;
  unsigned int v2:15;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu15i_Sf) C1{ FL:1 Fi:15 FC2{}}



static void Test_BFu1ll_BFu15i_Sf()
{
  {
    init_simple_test("BFu1ll_BFu15i_Sf");
    static BFu1ll_BFu15i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15i_Sf");
    check_field_offset(lv, v3, 2, "BFu1ll_BFu15i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu15i_Sf(Test_BFu1ll_BFu15i_Sf, "BFu1ll_BFu15i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu15ll_Sf  {
  __tsu64 v1:1;
  __tsu64 v2:15;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu15ll_Sf) C1{ FL:1 FL:15 FC2{}}



static void Test_BFu1ll_BFu15ll_Sf()
{
  {
    init_simple_test("BFu1ll_BFu15ll_Sf");
    static BFu1ll_BFu15ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15ll_Sf");
    check_field_offset(lv, v3, 2, "BFu1ll_BFu15ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu15ll_Sf(Test_BFu1ll_BFu15ll_Sf, "BFu1ll_BFu15ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu15s_Sf  {
  __tsu64 v1:1;
  unsigned short v2:15;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu15s_Sf) C1{ FL:1 Fs:15 FC2{}}



static void Test_BFu1ll_BFu15s_Sf()
{
  {
    init_simple_test("BFu1ll_BFu15s_Sf");
    static BFu1ll_BFu15s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu15s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1ll_BFu15s_Sf");
    check_field_offset(lv, v3, 2, "BFu1ll_BFu15s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu15s_Sf(Test_BFu1ll_BFu15s_Sf, "BFu1ll_BFu15s_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu16i_Sf  {
  __tsu64 v1:1;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu16i_Sf) C1{ FL:1 Fi:16 FC2{}}



static void Test_BFu1ll_BFu16i_Sf()
{
  {
    init_simple_test("BFu1ll_BFu16i_Sf");
    static BFu1ll_BFu16i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu16i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1ll_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "BFu1ll_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu16i_Sf(Test_BFu1ll_BFu16i_Sf, "BFu1ll_BFu16i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu16ll_Sf  {
  __tsu64 v1:1;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu16ll_Sf) C1{ FL:1 FL:16 FC2{}}



static void Test_BFu1ll_BFu16ll_Sf()
{
  {
    init_simple_test("BFu1ll_BFu16ll_Sf");
    static BFu1ll_BFu16ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1ll_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "BFu1ll_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu16ll_Sf(Test_BFu1ll_BFu16ll_Sf, "BFu1ll_BFu16ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu16s_Sf  {
  __tsu64 v1:1;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu16s_Sf) C1{ FL:1 Fs:16 FC2{}}



static void Test_BFu1ll_BFu16s_Sf()
{
  {
    init_simple_test("BFu1ll_BFu16s_Sf");
    static BFu1ll_BFu16s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu16s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1ll_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "BFu1ll_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu16s_Sf(Test_BFu1ll_BFu16s_Sf, "BFu1ll_BFu16s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu17i_Sf  {
  __tsu64 v1:1;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu17i_Sf) C1{ FL:1 Fi:17 FC2{}}



static void Test_BFu1ll_BFu17i_Sf()
{
  {
    init_simple_test("BFu1ll_BFu17i_Sf");
    static BFu1ll_BFu17i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu17i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1ll_BFu17i_Sf");
    check_field_offset(lv, v3, 3, "BFu1ll_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu17i_Sf(Test_BFu1ll_BFu17i_Sf, "BFu1ll_BFu17i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu17ll_Sf  {
  __tsu64 v1:1;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu17ll_Sf) C1{ FL:1 FL:17 FC2{}}



static void Test_BFu1ll_BFu17ll_Sf()
{
  {
    init_simple_test("BFu1ll_BFu17ll_Sf");
    static BFu1ll_BFu17ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1ll_BFu17ll_Sf");
    check_field_offset(lv, v3, 3, "BFu1ll_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu17ll_Sf(Test_BFu1ll_BFu17ll_Sf, "BFu1ll_BFu17ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu1c_Sf  {
  __tsu64 v1:1;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu1c_Sf) C1{ FL:1 Fc:1 FC2{}}



static void Test_BFu1ll_BFu1c_Sf()
{
  {
    init_simple_test("BFu1ll_BFu1c_Sf");
    static BFu1ll_BFu1c_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1c_Sf");
    check_field_offset(lv, v3, 1, "BFu1ll_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu1c_Sf(Test_BFu1ll_BFu1c_Sf, "BFu1ll_BFu1c_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu1i_Sf  {
  __tsu64 v1:1;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu1i_Sf) C1{ FL:1 Fi:1 FC2{}}



static void Test_BFu1ll_BFu1i_Sf()
{
  {
    init_simple_test("BFu1ll_BFu1i_Sf");
    static BFu1ll_BFu1i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1i_Sf");
    check_field_offset(lv, v3, 1, "BFu1ll_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu1i_Sf(Test_BFu1ll_BFu1i_Sf, "BFu1ll_BFu1i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu1ll_Sf  {
  __tsu64 v1:1;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu1ll_Sf) C1{ FL:1 FL:1 FC2{}}



static void Test_BFu1ll_BFu1ll_Sf()
{
  {
    init_simple_test("BFu1ll_BFu1ll_Sf");
    static BFu1ll_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1ll_Sf");
    check_field_offset(lv, v3, 1, "BFu1ll_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu1ll_Sf(Test_BFu1ll_BFu1ll_Sf, "BFu1ll_BFu1ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu1s_Sf  {
  __tsu64 v1:1;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu1s_Sf) C1{ FL:1 Fs:1 FC2{}}



static void Test_BFu1ll_BFu1s_Sf()
{
  {
    init_simple_test("BFu1ll_BFu1s_Sf");
    static BFu1ll_BFu1s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu1s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu1s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1ll_BFu1s_Sf");
    check_field_offset(lv, v3, 1, "BFu1ll_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu1s_Sf(Test_BFu1ll_BFu1s_Sf, "BFu1ll_BFu1s_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu31i_Sf  {
  __tsu64 v1:1;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu31i_Sf) C1{ FL:1 Fi:31 FC2{}}



static void Test_BFu1ll_BFu31i_Sf()
{
  {
    init_simple_test("BFu1ll_BFu31i_Sf");
    static BFu1ll_BFu31i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu31i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1ll_BFu31i_Sf");
    check_field_offset(lv, v3, 4, "BFu1ll_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu31i_Sf(Test_BFu1ll_BFu31i_Sf, "BFu1ll_BFu31i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu31ll_Sf  {
  __tsu64 v1:1;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu31ll_Sf) C1{ FL:1 FL:31 FC2{}}



static void Test_BFu1ll_BFu31ll_Sf()
{
  {
    init_simple_test("BFu1ll_BFu31ll_Sf");
    static BFu1ll_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1ll_BFu31ll_Sf");
    check_field_offset(lv, v3, 4, "BFu1ll_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu31ll_Sf(Test_BFu1ll_BFu31ll_Sf, "BFu1ll_BFu31ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu32i_Sf  {
  __tsu64 v1:1;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu32i_Sf) C1{ FL:1 Fi:32 FC2{}}



static void Test_BFu1ll_BFu32i_Sf()
{
  {
    init_simple_test("BFu1ll_BFu32i_Sf");
    static BFu1ll_BFu32i_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_BFu32i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1ll_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu1ll_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu32i_Sf(Test_BFu1ll_BFu32i_Sf, "BFu1ll_BFu32i_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu32ll_Sf  {
  __tsu64 v1:1;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu32ll_Sf) C1{ FL:1 FL:32 FC2{}}



static void Test_BFu1ll_BFu32ll_Sf()
{
  {
    init_simple_test("BFu1ll_BFu32ll_Sf");
    static BFu1ll_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1ll_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "BFu1ll_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu32ll_Sf(Test_BFu1ll_BFu32ll_Sf, "BFu1ll_BFu32ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu33_Sf  {
  __tsu64 v1:1;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu33_Sf) C1{ FL:1 FL:33 FC2{}}



static void Test_BFu1ll_BFu33_Sf()
{
  {
    init_simple_test("BFu1ll_BFu33_Sf");
    static BFu1ll_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1ll_BFu33_Sf");
    check_field_offset(lv, v3, 5, "BFu1ll_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu33_Sf(Test_BFu1ll_BFu33_Sf, "BFu1ll_BFu33_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu7c_Sf  {
  __tsu64 v1:1;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu7c_Sf) C1{ FL:1 Fc:7 FC2{}}



static void Test_BFu1ll_BFu7c_Sf()
{
  {
    init_simple_test("BFu1ll_BFu7c_Sf");
    static BFu1ll_BFu7c_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7c_Sf");
    check_field_offset(lv, v3, 1, "BFu1ll_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu7c_Sf(Test_BFu1ll_BFu7c_Sf, "BFu1ll_BFu7c_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu7i_Sf  {
  __tsu64 v1:1;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu7i_Sf) C1{ FL:1 Fi:7 FC2{}}



static void Test_BFu1ll_BFu7i_Sf()
{
  {
    init_simple_test("BFu1ll_BFu7i_Sf");
    static BFu1ll_BFu7i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7i_Sf");
    check_field_offset(lv, v3, 1, "BFu1ll_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu7i_Sf(Test_BFu1ll_BFu7i_Sf, "BFu1ll_BFu7i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu7ll_Sf  {
  __tsu64 v1:1;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu7ll_Sf) C1{ FL:1 FL:7 FC2{}}



static void Test_BFu1ll_BFu7ll_Sf()
{
  {
    init_simple_test("BFu1ll_BFu7ll_Sf");
    static BFu1ll_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7ll_Sf");
    check_field_offset(lv, v3, 1, "BFu1ll_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu7ll_Sf(Test_BFu1ll_BFu7ll_Sf, "BFu1ll_BFu7ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu7s_Sf  {
  __tsu64 v1:1;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu7s_Sf) C1{ FL:1 Fs:7 FC2{}}



static void Test_BFu1ll_BFu7s_Sf()
{
  {
    init_simple_test("BFu1ll_BFu7s_Sf");
    static BFu1ll_BFu7s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu7s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1ll_BFu7s_Sf");
    check_field_offset(lv, v3, 1, "BFu1ll_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu7s_Sf(Test_BFu1ll_BFu7s_Sf, "BFu1ll_BFu7s_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu8c_Sf  {
  __tsu64 v1:1;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu8c_Sf) C1{ FL:1 Fc:8 FC2{}}



static void Test_BFu1ll_BFu8c_Sf()
{
  {
    init_simple_test("BFu1ll_BFu8c_Sf");
    static BFu1ll_BFu8c_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1ll_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "BFu1ll_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu8c_Sf(Test_BFu1ll_BFu8c_Sf, "BFu1ll_BFu8c_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu8i_Sf  {
  __tsu64 v1:1;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu8i_Sf) C1{ FL:1 Fi:8 FC2{}}



static void Test_BFu1ll_BFu8i_Sf()
{
  {
    init_simple_test("BFu1ll_BFu8i_Sf");
    static BFu1ll_BFu8i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "BFu1ll_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu8i_Sf(Test_BFu1ll_BFu8i_Sf, "BFu1ll_BFu8i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu8ll_Sf  {
  __tsu64 v1:1;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu8ll_Sf) C1{ FL:1 FL:8 FC2{}}



static void Test_BFu1ll_BFu8ll_Sf()
{
  {
    init_simple_test("BFu1ll_BFu8ll_Sf");
    static BFu1ll_BFu8ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "BFu1ll_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu8ll_Sf(Test_BFu1ll_BFu8ll_Sf, "BFu1ll_BFu8ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu8s_Sf  {
  __tsu64 v1:1;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu8s_Sf) C1{ FL:1 Fs:8 FC2{}}



static void Test_BFu1ll_BFu8s_Sf()
{
  {
    init_simple_test("BFu1ll_BFu8s_Sf");
    static BFu1ll_BFu8s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu8s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1ll_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "BFu1ll_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu8s_Sf(Test_BFu1ll_BFu8s_Sf, "BFu1ll_BFu8s_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu9i_Sf  {
  __tsu64 v1:1;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu9i_Sf) C1{ FL:1 Fi:9 FC2{}}



static void Test_BFu1ll_BFu9i_Sf()
{
  {
    init_simple_test("BFu1ll_BFu9i_Sf");
    static BFu1ll_BFu9i_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9i_Sf");
    check_field_offset(lv, v3, 2, "BFu1ll_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu9i_Sf(Test_BFu1ll_BFu9i_Sf, "BFu1ll_BFu9i_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu9ll_Sf  {
  __tsu64 v1:1;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu9ll_Sf) C1{ FL:1 FL:9 FC2{}}



static void Test_BFu1ll_BFu9ll_Sf()
{
  {
    init_simple_test("BFu1ll_BFu9ll_Sf");
    static BFu1ll_BFu9ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9ll_Sf");
    check_field_offset(lv, v3, 2, "BFu1ll_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu9ll_Sf(Test_BFu1ll_BFu9ll_Sf, "BFu1ll_BFu9ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_BFu9s_Sf  {
  __tsu64 v1:1;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 BFu1ll_BFu9s_Sf) C1{ FL:1 Fs:9 FC2{}}



static void Test_BFu1ll_BFu9s_Sf()
{
  {
    init_simple_test("BFu1ll_BFu9s_Sf");
    static BFu1ll_BFu9s_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_BFu9s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1ll_BFu9s_Sf");
    check_field_offset(lv, v3, 2, "BFu1ll_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_BFu9s_Sf(Test_BFu1ll_BFu9s_Sf, "BFu1ll_BFu9s_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_C_Sf  {
  __tsu64 v1:1;
  char v2;
  ::empty v3;
};
//SIG(1 BFu1ll_C_Sf) C1{ FL:1 Fc FC2{}}



static void Test_BFu1ll_C_Sf()
{
  {
    init_simple_test("BFu1ll_C_Sf");
    static BFu1ll_C_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_C_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_C_Sf");
    check_field_offset(lv, v2, 1, "BFu1ll_C_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu1ll_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_C_Sf(Test_BFu1ll_C_Sf, "BFu1ll_C_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_D_Sf  {
  __tsu64 v1:1;
  double v2;
  ::empty v3;
};
//SIG(1 BFu1ll_D_Sf) C1{ FL:1 FL FC2{}}



static void Test_BFu1ll_D_Sf()
{
  {
    init_simple_test("BFu1ll_D_Sf");
    static BFu1ll_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu1ll_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_D_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu1ll_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_D_Sf(Test_BFu1ll_D_Sf, "BFu1ll_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_F_Sf  {
  __tsu64 v1:1;
  float v2;
  ::empty v3;
};
//SIG(1 BFu1ll_F_Sf) C1{ FL:1 Fi FC2{}}



static void Test_BFu1ll_F_Sf()
{
  {
    init_simple_test("BFu1ll_F_Sf");
    static BFu1ll_F_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_F_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_F_Sf");
    check_field_offset(lv, v2, 4, "BFu1ll_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu1ll_F_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_F_Sf(Test_BFu1ll_F_Sf, "BFu1ll_F_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_I_Sf  {
  __tsu64 v1:1;
  int v2;
  ::empty v3;
};
//SIG(1 BFu1ll_I_Sf) C1{ FL:1 Fi FC2{}}



static void Test_BFu1ll_I_Sf()
{
  {
    init_simple_test("BFu1ll_I_Sf");
    static BFu1ll_I_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_I_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_I_Sf");
    check_field_offset(lv, v2, 4, "BFu1ll_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu1ll_I_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_I_Sf(Test_BFu1ll_I_Sf, "BFu1ll_I_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Ip_Sf  {
  __tsu64 v1:1;
  int *v2;
  ::empty v3;
};
//SIG(1 BFu1ll_Ip_Sf) C1{ FL:1 Fp FC2{}}



static void Test_BFu1ll_Ip_Sf()
{
  {
    init_simple_test("BFu1ll_Ip_Sf");
    static BFu1ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu1ll_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ip_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu1ll_Ip_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Ip_Sf(Test_BFu1ll_Ip_Sf, "BFu1ll_Ip_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_L_Sf  {
  __tsu64 v1:1;
  __tsi64 v2;
  ::empty v3;
};
//SIG(1 BFu1ll_L_Sf) C1{ FL:1 FL FC2{}}



static void Test_BFu1ll_L_Sf()
{
  {
    init_simple_test("BFu1ll_L_Sf");
    static BFu1ll_L_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu1ll_L_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_L_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_L_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu1ll_L_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_L_Sf(Test_BFu1ll_L_Sf, "BFu1ll_L_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_S_Sf  {
  __tsu64 v1:1;
  short v2;
  ::empty v3;
};
//SIG(1 BFu1ll_S_Sf) C1{ FL:1 Fs FC2{}}



static void Test_BFu1ll_S_Sf()
{
  {
    init_simple_test("BFu1ll_S_Sf");
    static BFu1ll_S_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_S_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_S_Sf");
    check_field_offset(lv, v2, 2, "BFu1ll_S_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu1ll_S_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_S_Sf(Test_BFu1ll_S_Sf, "BFu1ll_S_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf  {
  __tsu64 v1:1;
  ::empty v2;
};
//SIG(1 BFu1ll_Sf) C1{ FL:1 FC2{}}



static void Test_BFu1ll_Sf()
{
  {
    init_simple_test("BFu1ll_Sf");
    static BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf.v2");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf(Test_BFu1ll_Sf, "BFu1ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu15i  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned int v3:15;
};
//SIG(1 BFu1ll_Sf_BFu15i) C1{ FL:1 FC2{} Fi:15}



static void Test_BFu1ll_Sf_BFu15i()
{
  {
    init_simple_test("BFu1ll_Sf_BFu15i");
    static BFu1ll_Sf_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1ll_Sf_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1ll_Sf_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu15i(Test_BFu1ll_Sf_BFu15i, "BFu1ll_Sf_BFu15i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu15ll  {
  __tsu64 v1:1;
  ::empty v2;
  __tsu64 v3:15;
};
//SIG(1 BFu1ll_Sf_BFu15ll) C1{ FL:1 FC2{} FL:15}



static void Test_BFu1ll_Sf_BFu15ll()
{
  {
    init_simple_test("BFu1ll_Sf_BFu15ll");
    static BFu1ll_Sf_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1ll_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1ll_Sf_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu15ll(Test_BFu1ll_Sf_BFu15ll, "BFu1ll_Sf_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu15s  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned short v3:15;
};
//SIG(1 BFu1ll_Sf_BFu15s) C1{ FL:1 FC2{} Fs:15}



static void Test_BFu1ll_Sf_BFu15s()
{
  {
    init_simple_test("BFu1ll_Sf_BFu15s");
    static BFu1ll_Sf_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1ll_Sf_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1ll_Sf_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu15s(Test_BFu1ll_Sf_BFu15s, "BFu1ll_Sf_BFu15s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu16i  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned int v3:16;
};
//SIG(1 BFu1ll_Sf_BFu16i) C1{ FL:1 FC2{} Fi:16}



static void Test_BFu1ll_Sf_BFu16i()
{
  {
    init_simple_test("BFu1ll_Sf_BFu16i");
    static BFu1ll_Sf_BFu16i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1ll_Sf_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1ll_Sf_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu16i(Test_BFu1ll_Sf_BFu16i, "BFu1ll_Sf_BFu16i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu16ll  {
  __tsu64 v1:1;
  ::empty v2;
  __tsu64 v3:16;
};
//SIG(1 BFu1ll_Sf_BFu16ll) C1{ FL:1 FC2{} FL:16}



static void Test_BFu1ll_Sf_BFu16ll()
{
  {
    init_simple_test("BFu1ll_Sf_BFu16ll");
    static BFu1ll_Sf_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1ll_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1ll_Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu16ll(Test_BFu1ll_Sf_BFu16ll, "BFu1ll_Sf_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu16s  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned short v3:16;
};
//SIG(1 BFu1ll_Sf_BFu16s) C1{ FL:1 FC2{} Fs:16}



static void Test_BFu1ll_Sf_BFu16s()
{
  {
    init_simple_test("BFu1ll_Sf_BFu16s");
    static BFu1ll_Sf_BFu16s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1ll_Sf_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1ll_Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu16s(Test_BFu1ll_Sf_BFu16s, "BFu1ll_Sf_BFu16s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu17i  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned int v3:17;
};
//SIG(1 BFu1ll_Sf_BFu17i) C1{ FL:1 FC2{} Fi:17}



static void Test_BFu1ll_Sf_BFu17i()
{
  {
    init_simple_test("BFu1ll_Sf_BFu17i");
    static BFu1ll_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Sf_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1ll_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1ll_Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu17i(Test_BFu1ll_Sf_BFu17i, "BFu1ll_Sf_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu17ll  {
  __tsu64 v1:1;
  ::empty v2;
  __tsu64 v3:17;
};
//SIG(1 BFu1ll_Sf_BFu17ll) C1{ FL:1 FC2{} FL:17}



static void Test_BFu1ll_Sf_BFu17ll()
{
  {
    init_simple_test("BFu1ll_Sf_BFu17ll");
    static BFu1ll_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu1ll_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu1ll_Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu17ll(Test_BFu1ll_Sf_BFu17ll, "BFu1ll_Sf_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu1c  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned char v3:1;
};
//SIG(1 BFu1ll_Sf_BFu1c) C1{ FL:1 FC2{} Fc:1}



static void Test_BFu1ll_Sf_BFu1c()
{
  {
    init_simple_test("BFu1ll_Sf_BFu1c");
    static BFu1ll_Sf_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1ll_Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu1c(Test_BFu1ll_Sf_BFu1c, "BFu1ll_Sf_BFu1c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu1i  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned int v3:1;
};
//SIG(1 BFu1ll_Sf_BFu1i) C1{ FL:1 FC2{} Fi:1}



static void Test_BFu1ll_Sf_BFu1i()
{
  {
    init_simple_test("BFu1ll_Sf_BFu1i");
    static BFu1ll_Sf_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1ll_Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu1i(Test_BFu1ll_Sf_BFu1i, "BFu1ll_Sf_BFu1i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu1ll  {
  __tsu64 v1:1;
  ::empty v2;
  __tsu64 v3:1;
};
//SIG(1 BFu1ll_Sf_BFu1ll) C1{ FL:1 FC2{} FL:1}



static void Test_BFu1ll_Sf_BFu1ll()
{
  {
    init_simple_test("BFu1ll_Sf_BFu1ll");
    static BFu1ll_Sf_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1ll_Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu1ll(Test_BFu1ll_Sf_BFu1ll, "BFu1ll_Sf_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu1s  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned short v3:1;
};
//SIG(1 BFu1ll_Sf_BFu1s) C1{ FL:1 FC2{} Fs:1}



static void Test_BFu1ll_Sf_BFu1s()
{
  {
    init_simple_test("BFu1ll_Sf_BFu1s");
    static BFu1ll_Sf_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1ll_Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu1s(Test_BFu1ll_Sf_BFu1s, "BFu1ll_Sf_BFu1s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu31i  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned int v3:31;
};
//SIG(1 BFu1ll_Sf_BFu31i) C1{ FL:1 FC2{} Fi:31}



static void Test_BFu1ll_Sf_BFu31i()
{
  {
    init_simple_test("BFu1ll_Sf_BFu31i");
    static BFu1ll_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Sf_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1ll_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1ll_Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu31i(Test_BFu1ll_Sf_BFu31i, "BFu1ll_Sf_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu31ll  {
  __tsu64 v1:1;
  ::empty v2;
  __tsu64 v3:31;
};
//SIG(1 BFu1ll_Sf_BFu31ll) C1{ FL:1 FC2{} FL:31}



static void Test_BFu1ll_Sf_BFu31ll()
{
  {
    init_simple_test("BFu1ll_Sf_BFu31ll");
    static BFu1ll_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu1ll_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu1ll_Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu31ll(Test_BFu1ll_Sf_BFu31ll, "BFu1ll_Sf_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu32i  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned int v3:32;
};
//SIG(1 BFu1ll_Sf_BFu32i) C1{ FL:1 FC2{} Fi:32}



static void Test_BFu1ll_Sf_BFu32i()
{
  {
    init_simple_test("BFu1ll_Sf_BFu32i");
    static BFu1ll_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Sf_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1ll_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1ll_Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu32i(Test_BFu1ll_Sf_BFu32i, "BFu1ll_Sf_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu32ll  {
  __tsu64 v1:1;
  ::empty v2;
  __tsu64 v3:32;
};
//SIG(1 BFu1ll_Sf_BFu32ll) C1{ FL:1 FC2{} FL:32}



static void Test_BFu1ll_Sf_BFu32ll()
{
  {
    init_simple_test("BFu1ll_Sf_BFu32ll");
    static BFu1ll_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu1ll_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu1ll_Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu32ll(Test_BFu1ll_Sf_BFu32ll, "BFu1ll_Sf_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu33  {
  __tsu64 v1:1;
  ::empty v2;
  __tsu64 v3:33;
};
//SIG(1 BFu1ll_Sf_BFu33) C1{ FL:1 FC2{} FL:33}



static void Test_BFu1ll_Sf_BFu33()
{
  {
    init_simple_test("BFu1ll_Sf_BFu33");
    static BFu1ll_Sf_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu33");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu1ll_Sf_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu1ll_Sf_BFu33");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu33(Test_BFu1ll_Sf_BFu33, "BFu1ll_Sf_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu7c  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned char v3:7;
};
//SIG(1 BFu1ll_Sf_BFu7c) C1{ FL:1 FC2{} Fc:7}



static void Test_BFu1ll_Sf_BFu7c()
{
  {
    init_simple_test("BFu1ll_Sf_BFu7c");
    static BFu1ll_Sf_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1ll_Sf_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1ll_Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu7c(Test_BFu1ll_Sf_BFu7c, "BFu1ll_Sf_BFu7c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu7i  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned int v3:7;
};
//SIG(1 BFu1ll_Sf_BFu7i) C1{ FL:1 FC2{} Fi:7}



static void Test_BFu1ll_Sf_BFu7i()
{
  {
    init_simple_test("BFu1ll_Sf_BFu7i");
    static BFu1ll_Sf_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1ll_Sf_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1ll_Sf_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu7i(Test_BFu1ll_Sf_BFu7i, "BFu1ll_Sf_BFu7i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu7ll  {
  __tsu64 v1:1;
  ::empty v2;
  __tsu64 v3:7;
};
//SIG(1 BFu1ll_Sf_BFu7ll) C1{ FL:1 FC2{} FL:7}



static void Test_BFu1ll_Sf_BFu7ll()
{
  {
    init_simple_test("BFu1ll_Sf_BFu7ll");
    static BFu1ll_Sf_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1ll_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1ll_Sf_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu7ll(Test_BFu1ll_Sf_BFu7ll, "BFu1ll_Sf_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu7s  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned short v3:7;
};
//SIG(1 BFu1ll_Sf_BFu7s) C1{ FL:1 FC2{} Fs:7}



static void Test_BFu1ll_Sf_BFu7s()
{
  {
    init_simple_test("BFu1ll_Sf_BFu7s");
    static BFu1ll_Sf_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1ll_Sf_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1ll_Sf_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu7s(Test_BFu1ll_Sf_BFu7s, "BFu1ll_Sf_BFu7s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu8c  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned char v3:8;
};
//SIG(1 BFu1ll_Sf_BFu8c) C1{ FL:1 FC2{} Fc:8}



static void Test_BFu1ll_Sf_BFu8c()
{
  {
    init_simple_test("BFu1ll_Sf_BFu8c");
    static BFu1ll_Sf_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1ll_Sf_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1ll_Sf_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu8c(Test_BFu1ll_Sf_BFu8c, "BFu1ll_Sf_BFu8c", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu8i  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned int v3:8;
};
//SIG(1 BFu1ll_Sf_BFu8i) C1{ FL:1 FC2{} Fi:8}



static void Test_BFu1ll_Sf_BFu8i()
{
  {
    init_simple_test("BFu1ll_Sf_BFu8i");
    static BFu1ll_Sf_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1ll_Sf_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1ll_Sf_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu8i(Test_BFu1ll_Sf_BFu8i, "BFu1ll_Sf_BFu8i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu8ll  {
  __tsu64 v1:1;
  ::empty v2;
  __tsu64 v3:8;
};
//SIG(1 BFu1ll_Sf_BFu8ll) C1{ FL:1 FC2{} FL:8}



static void Test_BFu1ll_Sf_BFu8ll()
{
  {
    init_simple_test("BFu1ll_Sf_BFu8ll");
    static BFu1ll_Sf_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1ll_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1ll_Sf_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu8ll(Test_BFu1ll_Sf_BFu8ll, "BFu1ll_Sf_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu8s  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned short v3:8;
};
//SIG(1 BFu1ll_Sf_BFu8s) C1{ FL:1 FC2{} Fs:8}



static void Test_BFu1ll_Sf_BFu8s()
{
  {
    init_simple_test("BFu1ll_Sf_BFu8s");
    static BFu1ll_Sf_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1ll_Sf_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1ll_Sf_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu8s(Test_BFu1ll_Sf_BFu8s, "BFu1ll_Sf_BFu8s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu9i  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned int v3:9;
};
//SIG(1 BFu1ll_Sf_BFu9i) C1{ FL:1 FC2{} Fi:9}



static void Test_BFu1ll_Sf_BFu9i()
{
  {
    init_simple_test("BFu1ll_Sf_BFu9i");
    static BFu1ll_Sf_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1ll_Sf_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1ll_Sf_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu9i(Test_BFu1ll_Sf_BFu9i, "BFu1ll_Sf_BFu9i", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu9ll  {
  __tsu64 v1:1;
  ::empty v2;
  __tsu64 v3:9;
};
//SIG(1 BFu1ll_Sf_BFu9ll) C1{ FL:1 FC2{} FL:9}



static void Test_BFu1ll_Sf_BFu9ll()
{
  {
    init_simple_test("BFu1ll_Sf_BFu9ll");
    static BFu1ll_Sf_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1ll_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1ll_Sf_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu9ll(Test_BFu1ll_Sf_BFu9ll, "BFu1ll_Sf_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_BFu9s  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned short v3:9;
};
//SIG(1 BFu1ll_Sf_BFu9s) C1{ FL:1 FC2{} Fs:9}



static void Test_BFu1ll_Sf_BFu9s()
{
  {
    init_simple_test("BFu1ll_Sf_BFu9s");
    static BFu1ll_Sf_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1ll_Sf_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1ll_Sf_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_BFu9s(Test_BFu1ll_Sf_BFu9s, "BFu1ll_Sf_BFu9s", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_C  {
  __tsu64 v1:1;
  ::empty v2;
  char v3;
};
//SIG(1 BFu1ll_Sf_C) C1{ FL:1 FC2{} Fc}



static void Test_BFu1ll_Sf_C()
{
  {
    init_simple_test("BFu1ll_Sf_C");
    static BFu1ll_Sf_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_C");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_C.v2");
    check_field_offset(lv, v3, 2, "BFu1ll_Sf_C.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_C(Test_BFu1ll_Sf_C, "BFu1ll_Sf_C", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_D  {
  __tsu64 v1:1;
  ::empty v2;
  double v3;
};
//SIG(1 BFu1ll_Sf_D) C1{ FL:1 FC2{} FL}



static void Test_BFu1ll_Sf_D()
{
  {
    init_simple_test("BFu1ll_Sf_D");
    static BFu1ll_Sf_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_Sf_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_D");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1ll_Sf_D.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_D(Test_BFu1ll_Sf_D, "BFu1ll_Sf_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_F  {
  __tsu64 v1:1;
  ::empty v2;
  float v3;
};
//SIG(1 BFu1ll_Sf_F) C1{ FL:1 FC2{} Fi}



static void Test_BFu1ll_Sf_F()
{
  {
    init_simple_test("BFu1ll_Sf_F");
    static BFu1ll_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Sf_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_F");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu1ll_Sf_F.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_F(Test_BFu1ll_Sf_F, "BFu1ll_Sf_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_I  {
  __tsu64 v1:1;
  ::empty v2;
  int v3;
};
//SIG(1 BFu1ll_Sf_I) C1{ FL:1 FC2{} Fi}



static void Test_BFu1ll_Sf_I()
{
  {
    init_simple_test("BFu1ll_Sf_I");
    static BFu1ll_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Sf_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_I");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu1ll_Sf_I.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_I(Test_BFu1ll_Sf_I, "BFu1ll_Sf_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_Ip  {
  __tsu64 v1:1;
  ::empty v2;
  int *v3;
};
//SIG(1 BFu1ll_Sf_Ip) C1{ FL:1 FC2{} Fp}



static void Test_BFu1ll_Sf_Ip()
{
  {
    init_simple_test("BFu1ll_Sf_Ip");
    static BFu1ll_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_Ip");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1ll_Sf_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_Ip(Test_BFu1ll_Sf_Ip, "BFu1ll_Sf_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_L  {
  __tsu64 v1:1;
  ::empty v2;
  __tsi64 v3;
};
//SIG(1 BFu1ll_Sf_L) C1{ FL:1 FC2{} FL}



static void Test_BFu1ll_Sf_L()
{
  {
    init_simple_test("BFu1ll_Sf_L");
    static BFu1ll_Sf_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_Sf_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_L");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1ll_Sf_L.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_L(Test_BFu1ll_Sf_L, "BFu1ll_Sf_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_S  {
  __tsu64 v1:1;
  ::empty v2;
  short v3;
};
//SIG(1 BFu1ll_Sf_S) C1{ FL:1 FC2{} Fs}



static void Test_BFu1ll_Sf_S()
{
  {
    init_simple_test("BFu1ll_Sf_S");
    static BFu1ll_Sf_S lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_S");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_S.v2");
    check_field_offset(lv, v3, 2, "BFu1ll_Sf_S.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_S(Test_BFu1ll_Sf_S, "BFu1ll_Sf_S", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_Sf  {
  __tsu64 v1:1;
  ::empty v2;
  ::empty v3;
};
//SIG(1 BFu1ll_Sf_Sf) C1{ FL:1 FC2{} FC2}



static void Test_BFu1ll_Sf_Sf()
{
  {
    init_simple_test("BFu1ll_Sf_Sf");
    static BFu1ll_Sf_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_Sf");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu1ll_Sf_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_Sf(Test_BFu1ll_Sf_Sf, "BFu1ll_Sf_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_Uc  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned char v3;
};
//SIG(1 BFu1ll_Sf_Uc) C1{ FL:1 FC2{} Fc}



static void Test_BFu1ll_Sf_Uc()
{
  {
    init_simple_test("BFu1ll_Sf_Uc");
    static BFu1ll_Sf_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_Uc");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu1ll_Sf_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_Uc(Test_BFu1ll_Sf_Uc, "BFu1ll_Sf_Uc", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_Ui  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned int v3;
};
//SIG(1 BFu1ll_Sf_Ui) C1{ FL:1 FC2{} Fi}



static void Test_BFu1ll_Sf_Ui()
{
  {
    init_simple_test("BFu1ll_Sf_Ui");
    static BFu1ll_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Sf_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_Ui");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu1ll_Sf_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_Ui(Test_BFu1ll_Sf_Ui, "BFu1ll_Sf_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_Ul  {
  __tsu64 v1:1;
  ::empty v2;
  __tsu64 v3;
};
//SIG(1 BFu1ll_Sf_Ul) C1{ FL:1 FC2{} FL}



static void Test_BFu1ll_Sf_Ul()
{
  {
    init_simple_test("BFu1ll_Sf_Ul");
    static BFu1ll_Sf_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_Ul");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1ll_Sf_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_Ul(Test_BFu1ll_Sf_Ul, "BFu1ll_Sf_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_Us  {
  __tsu64 v1:1;
  ::empty v2;
  unsigned short v3;
};
//SIG(1 BFu1ll_Sf_Us) C1{ FL:1 FC2{} Fs}



static void Test_BFu1ll_Sf_Us()
{
  {
    init_simple_test("BFu1ll_Sf_Us");
    static BFu1ll_Sf_Us lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Sf_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_Us");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_Us.v2");
    check_field_offset(lv, v3, 2, "BFu1ll_Sf_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_Us(Test_BFu1ll_Sf_Us, "BFu1ll_Sf_Us", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Sf_Vp  {
  __tsu64 v1:1;
  ::empty v2;
  void *v3;
};
//SIG(1 BFu1ll_Sf_Vp) C1{ FL:1 FC2{} Fp}



static void Test_BFu1ll_Sf_Vp()
{
  {
    init_simple_test("BFu1ll_Sf_Vp");
    static BFu1ll_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1ll_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Sf_Vp");
    check_field_offset(lv, v2, 1, "BFu1ll_Sf_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1ll_Sf_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Sf_Vp(Test_BFu1ll_Sf_Vp, "BFu1ll_Sf_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Uc_Sf  {
  __tsu64 v1:1;
  unsigned char v2;
  ::empty v3;
};
//SIG(1 BFu1ll_Uc_Sf) C1{ FL:1 Fc FC2{}}



static void Test_BFu1ll_Uc_Sf()
{
  {
    init_simple_test("BFu1ll_Uc_Sf");
    static BFu1ll_Uc_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1ll_Uc_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Uc_Sf");
    check_field_offset(lv, v2, 1, "BFu1ll_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu1ll_Uc_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Uc_Sf(Test_BFu1ll_Uc_Sf, "BFu1ll_Uc_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Ui_Sf  {
  __tsu64 v1:1;
  unsigned int v2;
  ::empty v3;
};
//SIG(1 BFu1ll_Ui_Sf) C1{ FL:1 Fi FC2{}}



static void Test_BFu1ll_Ui_Sf()
{
  {
    init_simple_test("BFu1ll_Ui_Sf");
    static BFu1ll_Ui_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1ll_Ui_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu1ll_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu1ll_Ui_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Ui_Sf(Test_BFu1ll_Ui_Sf, "BFu1ll_Ui_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Ul_Sf  {
  __tsu64 v1:1;
  __tsu64 v2;
  ::empty v3;
};
//SIG(1 BFu1ll_Ul_Sf) C1{ FL:1 FL FC2{}}



static void Test_BFu1ll_Ul_Sf()
{
  {
    init_simple_test("BFu1ll_Ul_Sf");
    static BFu1ll_Ul_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu1ll_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Ul_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Ul_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu1ll_Ul_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Ul_Sf(Test_BFu1ll_Ul_Sf, "BFu1ll_Ul_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Us_Sf  {
  __tsu64 v1:1;
  unsigned short v2;
  ::empty v3;
};
//SIG(1 BFu1ll_Us_Sf) C1{ FL:1 Fs FC2{}}



static void Test_BFu1ll_Us_Sf()
{
  {
    init_simple_test("BFu1ll_Us_Sf");
    static BFu1ll_Us_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1ll_Us_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Us_Sf");
    check_field_offset(lv, v2, 2, "BFu1ll_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu1ll_Us_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Us_Sf(Test_BFu1ll_Us_Sf, "BFu1ll_Us_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1ll_Vp_Sf  {
  __tsu64 v1:1;
  void *v2;
  ::empty v3;
};
//SIG(1 BFu1ll_Vp_Sf) C1{ FL:1 Fp FC2{}}



static void Test_BFu1ll_Vp_Sf()
{
  {
    init_simple_test("BFu1ll_Vp_Sf");
    static BFu1ll_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu1ll_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1ll_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1ll_Vp_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1ll_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu1ll_Vp_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1ll_Vp_Sf(Test_BFu1ll_Vp_Sf, "BFu1ll_Vp_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu15i_Sf  {
  unsigned short v1:1;
  unsigned int v2:15;
  ::empty v3;
};
//SIG(1 BFu1s_BFu15i_Sf) C1{ Fs:1 Fi:15 FC2{}}



static void Test_BFu1s_BFu15i_Sf()
{
  {
    init_simple_test("BFu1s_BFu15i_Sf");
    static BFu1s_BFu15i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu15i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1s_BFu15i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1s_BFu15i_Sf");
    check_field_offset(lv, v3, 2, "BFu1s_BFu15i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu15i_Sf(Test_BFu1s_BFu15i_Sf, "BFu1s_BFu15i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu15ll_Sf  {
  unsigned short v1:1;
  __tsu64 v2:15;
  ::empty v3;
};
//SIG(1 BFu1s_BFu15ll_Sf) C1{ Fs:1 FL:15 FC2{}}



static void Test_BFu1s_BFu15ll_Sf()
{
  {
    init_simple_test("BFu1s_BFu15ll_Sf");
    static BFu1s_BFu15ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1s_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1s_BFu15ll_Sf");
    check_field_offset(lv, v3, 2, "BFu1s_BFu15ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu15ll_Sf(Test_BFu1s_BFu15ll_Sf, "BFu1s_BFu15ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu15s_Sf  {
  unsigned short v1:1;
  unsigned short v2:15;
  ::empty v3;
};
//SIG(1 BFu1s_BFu15s_Sf) C1{ Fs:1 Fs:15 FC2{}}



static void Test_BFu1s_BFu15s_Sf()
{
  {
    init_simple_test("BFu1s_BFu15s_Sf");
    static BFu1s_BFu15s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu15s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, 1, "BFu1s_BFu15s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 15, hide_ull(1LL<<14), "BFu1s_BFu15s_Sf");
    check_field_offset(lv, v3, 2, "BFu1s_BFu15s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu15s_Sf(Test_BFu1s_BFu15s_Sf, "BFu1s_BFu15s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu16i_Sf  {
  unsigned short v1:1;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 BFu1s_BFu16i_Sf) C1{ Fs:1 Fi:16 FC2{}}



static void Test_BFu1s_BFu16i_Sf()
{
  {
    init_simple_test("BFu1s_BFu16i_Sf");
    static BFu1s_BFu16i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu16i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1s_BFu16i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1s_BFu16i_Sf");
    check_field_offset(lv, v3, 3, "BFu1s_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu16i_Sf(Test_BFu1s_BFu16i_Sf, "BFu1s_BFu16i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu16ll_Sf  {
  unsigned short v1:1;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 BFu1s_BFu16ll_Sf) C1{ Fs:1 FL:16 FC2{}}



static void Test_BFu1s_BFu16ll_Sf()
{
  {
    init_simple_test("BFu1s_BFu16ll_Sf");
    static BFu1s_BFu16ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, 1, "BFu1s_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 16, hide_ull(1LL<<15), "BFu1s_BFu16ll_Sf");
    check_field_offset(lv, v3, 3, "BFu1s_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu16ll_Sf(Test_BFu1s_BFu16ll_Sf, "BFu1s_BFu16ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu16s_Sf  {
  unsigned short v1:1;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 BFu1s_BFu16s_Sf) C1{ Fs:1 Fs:16 FC2{}}



static void Test_BFu1s_BFu16s_Sf()
{
  {
    init_simple_test("BFu1s_BFu16s_Sf");
    static BFu1s_BFu16s_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu1s_BFu16s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "BFu1s_BFu16s_Sf");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "BFu1s_BFu16s_Sf");
    check_field_offset(lv, v3, 4, "BFu1s_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu16s_Sf(Test_BFu1s_BFu16s_Sf, "BFu1s_BFu16s_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu17i_Sf  {
  unsigned short v1:1;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 BFu1s_BFu17i_Sf) C1{ Fs:1 Fi:17 FC2{}}



static void Test_BFu1s_BFu17i_Sf()
{
  {
    init_simple_test("BFu1s_BFu17i_Sf");
    static BFu1s_BFu17i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu17i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1s_BFu17i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1s_BFu17i_Sf");
    check_field_offset(lv, v3, 3, "BFu1s_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu17i_Sf(Test_BFu1s_BFu17i_Sf, "BFu1s_BFu17i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu17ll_Sf  {
  unsigned short v1:1;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 BFu1s_BFu17ll_Sf) C1{ Fs:1 FL:17 FC2{}}



static void Test_BFu1s_BFu17ll_Sf()
{
  {
    init_simple_test("BFu1s_BFu17ll_Sf");
    static BFu1s_BFu17ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, 1, "BFu1s_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 17, hide_ull(1LL<<16), "BFu1s_BFu17ll_Sf");
    check_field_offset(lv, v3, 3, "BFu1s_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu17ll_Sf(Test_BFu1s_BFu17ll_Sf, "BFu1s_BFu17ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu1c_Sf  {
  unsigned short v1:1;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 BFu1s_BFu1c_Sf) C1{ Fs:1 Fc:1 FC2{}}



static void Test_BFu1s_BFu1c_Sf()
{
  {
    init_simple_test("BFu1s_BFu1c_Sf");
    static BFu1s_BFu1c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu1c_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu1c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1s_BFu1c_Sf");
    check_field_offset(lv, v3, 1, "BFu1s_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu1c_Sf(Test_BFu1s_BFu1c_Sf, "BFu1s_BFu1c_Sf", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu1i_Sf  {
  unsigned short v1:1;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 BFu1s_BFu1i_Sf) C1{ Fs:1 Fi:1 FC2{}}



static void Test_BFu1s_BFu1i_Sf()
{
  {
    init_simple_test("BFu1s_BFu1i_Sf");
    static BFu1s_BFu1i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu1i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu1i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1s_BFu1i_Sf");
    check_field_offset(lv, v3, 1, "BFu1s_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu1i_Sf(Test_BFu1s_BFu1i_Sf, "BFu1s_BFu1i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu1ll_Sf  {
  unsigned short v1:1;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 BFu1s_BFu1ll_Sf) C1{ Fs:1 FL:1 FC2{}}



static void Test_BFu1s_BFu1ll_Sf()
{
  {
    init_simple_test("BFu1s_BFu1ll_Sf");
    static BFu1s_BFu1ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1s_BFu1ll_Sf");
    check_field_offset(lv, v3, 1, "BFu1s_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu1ll_Sf(Test_BFu1s_BFu1ll_Sf, "BFu1s_BFu1ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu1s_Sf  {
  unsigned short v1:1;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 BFu1s_BFu1s_Sf) C1{ Fs:1 Fs:1 FC2{}}



static void Test_BFu1s_BFu1s_Sf()
{
  {
    init_simple_test("BFu1s_BFu1s_Sf");
    static BFu1s_BFu1s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu1s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu1s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFu1s_BFu1s_Sf");
    check_field_offset(lv, v3, 1, "BFu1s_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu1s_Sf(Test_BFu1s_BFu1s_Sf, "BFu1s_BFu1s_Sf", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu31i_Sf  {
  unsigned short v1:1;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 BFu1s_BFu31i_Sf) C1{ Fs:1 Fi:31 FC2{}}



static void Test_BFu1s_BFu31i_Sf()
{
  {
    init_simple_test("BFu1s_BFu31i_Sf");
    static BFu1s_BFu31i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu31i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1s_BFu31i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1s_BFu31i_Sf");
    check_field_offset(lv, v3, 4, "BFu1s_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu31i_Sf(Test_BFu1s_BFu31i_Sf, "BFu1s_BFu31i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu31ll_Sf  {
  unsigned short v1:1;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 BFu1s_BFu31ll_Sf) C1{ Fs:1 FL:31 FC2{}}



static void Test_BFu1s_BFu31ll_Sf()
{
  {
    init_simple_test("BFu1s_BFu31ll_Sf");
    static BFu1s_BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, 1, "BFu1s_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 31, hide_ull(1LL<<30), "BFu1s_BFu31ll_Sf");
    check_field_offset(lv, v3, 4, "BFu1s_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu31ll_Sf(Test_BFu1s_BFu31ll_Sf, "BFu1s_BFu31ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu32i_Sf  {
  unsigned short v1:1;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 BFu1s_BFu32i_Sf) C1{ Fs:1 Fi:32 FC2{}}



static void Test_BFu1s_BFu32i_Sf()
{
  {
    init_simple_test("BFu1s_BFu32i_Sf");
    static BFu1s_BFu32i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu1s_BFu32i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu1s_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu1s_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu1s_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu32i_Sf(Test_BFu1s_BFu32i_Sf, "BFu1s_BFu32i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu32ll_Sf  {
  unsigned short v1:1;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 BFu1s_BFu32ll_Sf) C1{ Fs:1 FL:32 FC2{}}



static void Test_BFu1s_BFu32ll_Sf()
{
  {
    init_simple_test("BFu1s_BFu32ll_Sf");
    static BFu1s_BFu32ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, 1, "BFu1s_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 32, hide_ull(1LL<<31), "BFu1s_BFu32ll_Sf");
    check_field_offset(lv, v3, 5, "BFu1s_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu32ll_Sf(Test_BFu1s_BFu32ll_Sf, "BFu1s_BFu32ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu33_Sf  {
  unsigned short v1:1;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 BFu1s_BFu33_Sf) C1{ Fs:1 FL:33 FC2{}}



static void Test_BFu1s_BFu33_Sf()
{
  {
    init_simple_test("BFu1s_BFu33_Sf");
    static BFu1s_BFu33_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, 1, "BFu1s_BFu33_Sf");
    set_bf_and_test(lv, v2, 0, 1, 33, hide_ull(1LL<<32), "BFu1s_BFu33_Sf");
    check_field_offset(lv, v3, 5, "BFu1s_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu33_Sf(Test_BFu1s_BFu33_Sf, "BFu1s_BFu33_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu7c_Sf  {
  unsigned short v1:1;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 BFu1s_BFu7c_Sf) C1{ Fs:1 Fc:7 FC2{}}



static void Test_BFu1s_BFu7c_Sf()
{
  {
    init_simple_test("BFu1s_BFu7c_Sf");
    static BFu1s_BFu7c_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu7c_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1s_BFu7c_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1s_BFu7c_Sf");
    check_field_offset(lv, v3, 1, "BFu1s_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu7c_Sf(Test_BFu1s_BFu7c_Sf, "BFu1s_BFu7c_Sf", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu7i_Sf  {
  unsigned short v1:1;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 BFu1s_BFu7i_Sf) C1{ Fs:1 Fi:7 FC2{}}



static void Test_BFu1s_BFu7i_Sf()
{
  {
    init_simple_test("BFu1s_BFu7i_Sf");
    static BFu1s_BFu7i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu7i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1s_BFu7i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1s_BFu7i_Sf");
    check_field_offset(lv, v3, 1, "BFu1s_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu7i_Sf(Test_BFu1s_BFu7i_Sf, "BFu1s_BFu7i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu7ll_Sf  {
  unsigned short v1:1;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 BFu1s_BFu7ll_Sf) C1{ Fs:1 FL:7 FC2{}}



static void Test_BFu1s_BFu7ll_Sf()
{
  {
    init_simple_test("BFu1s_BFu7ll_Sf");
    static BFu1s_BFu7ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1s_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1s_BFu7ll_Sf");
    check_field_offset(lv, v3, 1, "BFu1s_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu7ll_Sf(Test_BFu1s_BFu7ll_Sf, "BFu1s_BFu7ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu7s_Sf  {
  unsigned short v1:1;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 BFu1s_BFu7s_Sf) C1{ Fs:1 Fs:7 FC2{}}



static void Test_BFu1s_BFu7s_Sf()
{
  {
    init_simple_test("BFu1s_BFu7s_Sf");
    static BFu1s_BFu7s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_BFu7s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, 1, "BFu1s_BFu7s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 7, hide_ull(1LL<<6), "BFu1s_BFu7s_Sf");
    check_field_offset(lv, v3, 1, "BFu1s_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu7s_Sf(Test_BFu1s_BFu7s_Sf, "BFu1s_BFu7s_Sf", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu8c_Sf  {
  unsigned short v1:1;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 BFu1s_BFu8c_Sf) C1{ Fs:1 Fc:8 FC2{}}



static void Test_BFu1s_BFu8c_Sf()
{
  {
    init_simple_test("BFu1s_BFu8c_Sf");
    static BFu1s_BFu8c_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu8c_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "BFu1s_BFu8c_Sf");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "BFu1s_BFu8c_Sf");
    check_field_offset(lv, v3, 2, "BFu1s_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu8c_Sf(Test_BFu1s_BFu8c_Sf, "BFu1s_BFu8c_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu8i_Sf  {
  unsigned short v1:1;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 BFu1s_BFu8i_Sf) C1{ Fs:1 Fi:8 FC2{}}



static void Test_BFu1s_BFu8i_Sf()
{
  {
    init_simple_test("BFu1s_BFu8i_Sf");
    static BFu1s_BFu8i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu8i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1s_BFu8i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1s_BFu8i_Sf");
    check_field_offset(lv, v3, 2, "BFu1s_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu8i_Sf(Test_BFu1s_BFu8i_Sf, "BFu1s_BFu8i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu8ll_Sf  {
  unsigned short v1:1;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 BFu1s_BFu8ll_Sf) C1{ Fs:1 FL:8 FC2{}}



static void Test_BFu1s_BFu8ll_Sf()
{
  {
    init_simple_test("BFu1s_BFu8ll_Sf");
    static BFu1s_BFu8ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1s_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1s_BFu8ll_Sf");
    check_field_offset(lv, v3, 2, "BFu1s_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu8ll_Sf(Test_BFu1s_BFu8ll_Sf, "BFu1s_BFu8ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu8s_Sf  {
  unsigned short v1:1;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 BFu1s_BFu8s_Sf) C1{ Fs:1 Fs:8 FC2{}}



static void Test_BFu1s_BFu8s_Sf()
{
  {
    init_simple_test("BFu1s_BFu8s_Sf");
    static BFu1s_BFu8s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu8s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, 1, "BFu1s_BFu8s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 8, hide_ull(1LL<<7), "BFu1s_BFu8s_Sf");
    check_field_offset(lv, v3, 2, "BFu1s_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu8s_Sf(Test_BFu1s_BFu8s_Sf, "BFu1s_BFu8s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu9i_Sf  {
  unsigned short v1:1;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 BFu1s_BFu9i_Sf) C1{ Fs:1 Fi:9 FC2{}}



static void Test_BFu1s_BFu9i_Sf()
{
  {
    init_simple_test("BFu1s_BFu9i_Sf");
    static BFu1s_BFu9i_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu9i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1s_BFu9i_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1s_BFu9i_Sf");
    check_field_offset(lv, v3, 2, "BFu1s_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu9i_Sf(Test_BFu1s_BFu9i_Sf, "BFu1s_BFu9i_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu9ll_Sf  {
  unsigned short v1:1;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 BFu1s_BFu9ll_Sf) C1{ Fs:1 FL:9 FC2{}}



static void Test_BFu1s_BFu9ll_Sf()
{
  {
    init_simple_test("BFu1s_BFu9ll_Sf");
    static BFu1s_BFu9ll_Sf lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1s_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1s_BFu9ll_Sf");
    check_field_offset(lv, v3, 2, "BFu1s_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu9ll_Sf(Test_BFu1s_BFu9ll_Sf, "BFu1s_BFu9ll_Sf", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_BFu9s_Sf  {
  unsigned short v1:1;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 BFu1s_BFu9s_Sf) C1{ Fs:1 Fs:9 FC2{}}



static void Test_BFu1s_BFu9s_Sf()
{
  {
    init_simple_test("BFu1s_BFu9s_Sf");
    static BFu1s_BFu9s_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_BFu9s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, 1, "BFu1s_BFu9s_Sf");
    set_bf_and_test(lv, v2, 0, 1, 9, hide_ull(1LL<<8), "BFu1s_BFu9s_Sf");
    check_field_offset(lv, v3, 2, "BFu1s_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_BFu9s_Sf(Test_BFu1s_BFu9s_Sf, "BFu1s_BFu9s_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_C_Sf  {
  unsigned short v1:1;
  char v2;
  ::empty v3;
};
//SIG(1 BFu1s_C_Sf) C1{ Fs:1 Fc FC2{}}



static void Test_BFu1s_C_Sf()
{
  {
    init_simple_test("BFu1s_C_Sf");
    static BFu1s_C_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_C_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_C_Sf");
    check_field_offset(lv, v2, 1, "BFu1s_C_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu1s_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_C_Sf(Test_BFu1s_C_Sf, "BFu1s_C_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_D_Sf  {
  unsigned short v1:1;
  double v2;
  ::empty v3;
};
//SIG(1 BFu1s_D_Sf) C1{ Fs:1 FL FC2{}}



static void Test_BFu1s_D_Sf()
{
  {
    init_simple_test("BFu1s_D_Sf");
    static BFu1s_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu1s_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_D_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1s_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu1s_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_D_Sf(Test_BFu1s_D_Sf, "BFu1s_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_F_Sf  {
  unsigned short v1:1;
  float v2;
  ::empty v3;
};
//SIG(1 BFu1s_F_Sf) C1{ Fs:1 Fi FC2{}}



static void Test_BFu1s_F_Sf()
{
  {
    init_simple_test("BFu1s_F_Sf");
    static BFu1s_F_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu1s_F_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_F_Sf");
    check_field_offset(lv, v2, 4, "BFu1s_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu1s_F_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_F_Sf(Test_BFu1s_F_Sf, "BFu1s_F_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_I_Sf  {
  unsigned short v1:1;
  int v2;
  ::empty v3;
};
//SIG(1 BFu1s_I_Sf) C1{ Fs:1 Fi FC2{}}



static void Test_BFu1s_I_Sf()
{
  {
    init_simple_test("BFu1s_I_Sf");
    static BFu1s_I_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu1s_I_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_I_Sf");
    check_field_offset(lv, v2, 4, "BFu1s_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu1s_I_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_I_Sf(Test_BFu1s_I_Sf, "BFu1s_I_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Ip_Sf  {
  unsigned short v1:1;
  int *v2;
  ::empty v3;
};
//SIG(1 BFu1s_Ip_Sf) C1{ Fs:1 Fp FC2{}}



static void Test_BFu1s_Ip_Sf()
{
  {
    init_simple_test("BFu1s_Ip_Sf");
    static BFu1s_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu1s_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Ip_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1s_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu1s_Ip_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Ip_Sf(Test_BFu1s_Ip_Sf, "BFu1s_Ip_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_L_Sf  {
  unsigned short v1:1;
  __tsi64 v2;
  ::empty v3;
};
//SIG(1 BFu1s_L_Sf) C1{ Fs:1 FL FC2{}}



static void Test_BFu1s_L_Sf()
{
  {
    init_simple_test("BFu1s_L_Sf");
    static BFu1s_L_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu1s_L_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_L_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1s_L_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu1s_L_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_L_Sf(Test_BFu1s_L_Sf, "BFu1s_L_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_S_Sf  {
  unsigned short v1:1;
  short v2;
  ::empty v3;
};
//SIG(1 BFu1s_S_Sf) C1{ Fs:1 Fs FC2{}}



static void Test_BFu1s_S_Sf()
{
  {
    init_simple_test("BFu1s_S_Sf");
    static BFu1s_S_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu1s_S_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_S_Sf");
    check_field_offset(lv, v2, 2, "BFu1s_S_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu1s_S_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_S_Sf(Test_BFu1s_S_Sf, "BFu1s_S_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf  {
  unsigned short v1:1;
  ::empty v2;
};
//SIG(1 BFu1s_Sf) C1{ Fs:1 FC2{}}



static void Test_BFu1s_Sf()
{
  {
    init_simple_test("BFu1s_Sf");
    static BFu1s_Sf lv;
    check2(sizeof(lv), 2, "sizeof(BFu1s_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf");
    check_field_offset(lv, v2, 1, "BFu1s_Sf.v2");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf(Test_BFu1s_Sf, "BFu1s_Sf", 2);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu15i  {
  unsigned short v1:1;
  ::empty v2;
  unsigned int v3:15;
};
//SIG(1 BFu1s_Sf_BFu15i) C1{ Fs:1 FC2{} Fi:15}



static void Test_BFu1s_Sf_BFu15i()
{
  {
    init_simple_test("BFu1s_Sf_BFu15i");
    static BFu1s_Sf_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu15i");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1s_Sf_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1s_Sf_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu15i(Test_BFu1s_Sf_BFu15i, "BFu1s_Sf_BFu15i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu15ll  {
  unsigned short v1:1;
  ::empty v2;
  __tsu64 v3:15;
};
//SIG(1 BFu1s_Sf_BFu15ll) C1{ Fs:1 FC2{} FL:15}



static void Test_BFu1s_Sf_BFu15ll()
{
  {
    init_simple_test("BFu1s_Sf_BFu15ll");
    static BFu1s_Sf_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu15ll");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1s_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1s_Sf_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu15ll(Test_BFu1s_Sf_BFu15ll, "BFu1s_Sf_BFu15ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu15s  {
  unsigned short v1:1;
  ::empty v2;
  unsigned short v3:15;
};
//SIG(1 BFu1s_Sf_BFu15s) C1{ Fs:1 FC2{} Fs:15}



static void Test_BFu1s_Sf_BFu15s()
{
  {
    init_simple_test("BFu1s_Sf_BFu15s");
    static BFu1s_Sf_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu15s");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "BFu1s_Sf_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "BFu1s_Sf_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu15s(Test_BFu1s_Sf_BFu15s, "BFu1s_Sf_BFu15s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu16i  {
  unsigned short v1:1;
  ::empty v2;
  unsigned int v3:16;
};
//SIG(1 BFu1s_Sf_BFu16i) C1{ Fs:1 FC2{} Fi:16}



static void Test_BFu1s_Sf_BFu16i()
{
  {
    init_simple_test("BFu1s_Sf_BFu16i");
    static BFu1s_Sf_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu16i");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1s_Sf_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1s_Sf_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu16i(Test_BFu1s_Sf_BFu16i, "BFu1s_Sf_BFu16i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu16ll  {
  unsigned short v1:1;
  ::empty v2;
  __tsu64 v3:16;
};
//SIG(1 BFu1s_Sf_BFu16ll) C1{ Fs:1 FC2{} FL:16}



static void Test_BFu1s_Sf_BFu16ll()
{
  {
    init_simple_test("BFu1s_Sf_BFu16ll");
    static BFu1s_Sf_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu16ll");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1s_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1s_Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu16ll(Test_BFu1s_Sf_BFu16ll, "BFu1s_Sf_BFu16ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu16s  {
  unsigned short v1:1;
  ::empty v2;
  unsigned short v3:16;
};
//SIG(1 BFu1s_Sf_BFu16s) C1{ Fs:1 FC2{} Fs:16}



static void Test_BFu1s_Sf_BFu16s()
{
  {
    init_simple_test("BFu1s_Sf_BFu16s");
    static BFu1s_Sf_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu16s");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "BFu1s_Sf_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "BFu1s_Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu16s(Test_BFu1s_Sf_BFu16s, "BFu1s_Sf_BFu16s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu17i  {
  unsigned short v1:1;
  ::empty v2;
  unsigned int v3:17;
};
//SIG(1 BFu1s_Sf_BFu17i) C1{ Fs:1 FC2{} Fi:17}



static void Test_BFu1s_Sf_BFu17i()
{
  {
    init_simple_test("BFu1s_Sf_BFu17i");
    static BFu1s_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_Sf_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu17i");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "BFu1s_Sf_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "BFu1s_Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu17i(Test_BFu1s_Sf_BFu17i, "BFu1s_Sf_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu17ll  {
  unsigned short v1:1;
  ::empty v2;
  __tsu64 v3:17;
};
//SIG(1 BFu1s_Sf_BFu17ll) C1{ Fs:1 FC2{} FL:17}



static void Test_BFu1s_Sf_BFu17ll()
{
  {
    init_simple_test("BFu1s_Sf_BFu17ll");
    static BFu1s_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu17ll");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "BFu1s_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "BFu1s_Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu17ll(Test_BFu1s_Sf_BFu17ll, "BFu1s_Sf_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu1c  {
  unsigned short v1:1;
  ::empty v2;
  unsigned char v3:1;
};
//SIG(1 BFu1s_Sf_BFu1c) C1{ Fs:1 FC2{} Fc:1}



static void Test_BFu1s_Sf_BFu1c()
{
  {
    init_simple_test("BFu1s_Sf_BFu1c");
    static BFu1s_Sf_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu1c");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1s_Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu1c(Test_BFu1s_Sf_BFu1c, "BFu1s_Sf_BFu1c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu1i  {
  unsigned short v1:1;
  ::empty v2;
  unsigned int v3:1;
};
//SIG(1 BFu1s_Sf_BFu1i) C1{ Fs:1 FC2{} Fi:1}



static void Test_BFu1s_Sf_BFu1i()
{
  {
    init_simple_test("BFu1s_Sf_BFu1i");
    static BFu1s_Sf_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu1i");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1s_Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu1i(Test_BFu1s_Sf_BFu1i, "BFu1s_Sf_BFu1i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu1ll  {
  unsigned short v1:1;
  ::empty v2;
  __tsu64 v3:1;
};
//SIG(1 BFu1s_Sf_BFu1ll) C1{ Fs:1 FC2{} FL:1}



static void Test_BFu1s_Sf_BFu1ll()
{
  {
    init_simple_test("BFu1s_Sf_BFu1ll");
    static BFu1s_Sf_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu1ll");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1s_Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu1ll(Test_BFu1s_Sf_BFu1ll, "BFu1s_Sf_BFu1ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu1s  {
  unsigned short v1:1;
  ::empty v2;
  unsigned short v3:1;
};
//SIG(1 BFu1s_Sf_BFu1s) C1{ Fs:1 FC2{} Fs:1}



static void Test_BFu1s_Sf_BFu1s()
{
  {
    init_simple_test("BFu1s_Sf_BFu1s");
    static BFu1s_Sf_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu1s");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "BFu1s_Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu1s(Test_BFu1s_Sf_BFu1s, "BFu1s_Sf_BFu1s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu31i  {
  unsigned short v1:1;
  ::empty v2;
  unsigned int v3:31;
};
//SIG(1 BFu1s_Sf_BFu31i) C1{ Fs:1 FC2{} Fi:31}



static void Test_BFu1s_Sf_BFu31i()
{
  {
    init_simple_test("BFu1s_Sf_BFu31i");
    static BFu1s_Sf_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_Sf_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu31i");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "BFu1s_Sf_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "BFu1s_Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu31i(Test_BFu1s_Sf_BFu31i, "BFu1s_Sf_BFu31i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu31ll  {
  unsigned short v1:1;
  ::empty v2;
  __tsu64 v3:31;
};
//SIG(1 BFu1s_Sf_BFu31ll) C1{ Fs:1 FC2{} FL:31}



static void Test_BFu1s_Sf_BFu31ll()
{
  {
    init_simple_test("BFu1s_Sf_BFu31ll");
    static BFu1s_Sf_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu31ll");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "BFu1s_Sf_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "BFu1s_Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu31ll(Test_BFu1s_Sf_BFu31ll, "BFu1s_Sf_BFu31ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu32i  {
  unsigned short v1:1;
  ::empty v2;
  unsigned int v3:32;
};
//SIG(1 BFu1s_Sf_BFu32i) C1{ Fs:1 FC2{} Fi:32}



static void Test_BFu1s_Sf_BFu32i()
{
  {
    init_simple_test("BFu1s_Sf_BFu32i");
    static BFu1s_Sf_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_Sf_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu32i");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "BFu1s_Sf_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "BFu1s_Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu32i(Test_BFu1s_Sf_BFu32i, "BFu1s_Sf_BFu32i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu32ll  {
  unsigned short v1:1;
  ::empty v2;
  __tsu64 v3:32;
};
//SIG(1 BFu1s_Sf_BFu32ll) C1{ Fs:1 FC2{} FL:32}



static void Test_BFu1s_Sf_BFu32ll()
{
  {
    init_simple_test("BFu1s_Sf_BFu32ll");
    static BFu1s_Sf_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu32ll");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "BFu1s_Sf_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "BFu1s_Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu32ll(Test_BFu1s_Sf_BFu32ll, "BFu1s_Sf_BFu32ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu33  {
  unsigned short v1:1;
  ::empty v2;
  __tsu64 v3:33;
};
//SIG(1 BFu1s_Sf_BFu33) C1{ Fs:1 FC2{} FL:33}



static void Test_BFu1s_Sf_BFu33()
{
  {
    init_simple_test("BFu1s_Sf_BFu33");
    static BFu1s_Sf_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu33");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "BFu1s_Sf_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "BFu1s_Sf_BFu33");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu33(Test_BFu1s_Sf_BFu33, "BFu1s_Sf_BFu33", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu7c  {
  unsigned short v1:1;
  ::empty v2;
  unsigned char v3:7;
};
//SIG(1 BFu1s_Sf_BFu7c) C1{ Fs:1 FC2{} Fc:7}



static void Test_BFu1s_Sf_BFu7c()
{
  {
    init_simple_test("BFu1s_Sf_BFu7c");
    static BFu1s_Sf_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu7c");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1s_Sf_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1s_Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu7c(Test_BFu1s_Sf_BFu7c, "BFu1s_Sf_BFu7c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu7i  {
  unsigned short v1:1;
  ::empty v2;
  unsigned int v3:7;
};
//SIG(1 BFu1s_Sf_BFu7i) C1{ Fs:1 FC2{} Fi:7}



static void Test_BFu1s_Sf_BFu7i()
{
  {
    init_simple_test("BFu1s_Sf_BFu7i");
    static BFu1s_Sf_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu7i");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1s_Sf_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1s_Sf_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu7i(Test_BFu1s_Sf_BFu7i, "BFu1s_Sf_BFu7i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu7ll  {
  unsigned short v1:1;
  ::empty v2;
  __tsu64 v3:7;
};
//SIG(1 BFu1s_Sf_BFu7ll) C1{ Fs:1 FC2{} FL:7}



static void Test_BFu1s_Sf_BFu7ll()
{
  {
    init_simple_test("BFu1s_Sf_BFu7ll");
    static BFu1s_Sf_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu7ll");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1s_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1s_Sf_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu7ll(Test_BFu1s_Sf_BFu7ll, "BFu1s_Sf_BFu7ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu7s  {
  unsigned short v1:1;
  ::empty v2;
  unsigned short v3:7;
};
//SIG(1 BFu1s_Sf_BFu7s) C1{ Fs:1 FC2{} Fs:7}



static void Test_BFu1s_Sf_BFu7s()
{
  {
    init_simple_test("BFu1s_Sf_BFu7s");
    static BFu1s_Sf_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu7s");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "BFu1s_Sf_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "BFu1s_Sf_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu7s(Test_BFu1s_Sf_BFu7s, "BFu1s_Sf_BFu7s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu8c  {
  unsigned short v1:1;
  ::empty v2;
  unsigned char v3:8;
};
//SIG(1 BFu1s_Sf_BFu8c) C1{ Fs:1 FC2{} Fc:8}



static void Test_BFu1s_Sf_BFu8c()
{
  {
    init_simple_test("BFu1s_Sf_BFu8c");
    static BFu1s_Sf_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu8c");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1s_Sf_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1s_Sf_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu8c(Test_BFu1s_Sf_BFu8c, "BFu1s_Sf_BFu8c", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu8i  {
  unsigned short v1:1;
  ::empty v2;
  unsigned int v3:8;
};
//SIG(1 BFu1s_Sf_BFu8i) C1{ Fs:1 FC2{} Fi:8}



static void Test_BFu1s_Sf_BFu8i()
{
  {
    init_simple_test("BFu1s_Sf_BFu8i");
    static BFu1s_Sf_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu8i");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1s_Sf_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1s_Sf_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu8i(Test_BFu1s_Sf_BFu8i, "BFu1s_Sf_BFu8i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu8ll  {
  unsigned short v1:1;
  ::empty v2;
  __tsu64 v3:8;
};
//SIG(1 BFu1s_Sf_BFu8ll) C1{ Fs:1 FC2{} FL:8}



static void Test_BFu1s_Sf_BFu8ll()
{
  {
    init_simple_test("BFu1s_Sf_BFu8ll");
    static BFu1s_Sf_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu8ll");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1s_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1s_Sf_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu8ll(Test_BFu1s_Sf_BFu8ll, "BFu1s_Sf_BFu8ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu8s  {
  unsigned short v1:1;
  ::empty v2;
  unsigned short v3:8;
};
//SIG(1 BFu1s_Sf_BFu8s) C1{ Fs:1 FC2{} Fs:8}



static void Test_BFu1s_Sf_BFu8s()
{
  {
    init_simple_test("BFu1s_Sf_BFu8s");
    static BFu1s_Sf_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu8s");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "BFu1s_Sf_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "BFu1s_Sf_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu8s(Test_BFu1s_Sf_BFu8s, "BFu1s_Sf_BFu8s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu9i  {
  unsigned short v1:1;
  ::empty v2;
  unsigned int v3:9;
};
//SIG(1 BFu1s_Sf_BFu9i) C1{ Fs:1 FC2{} Fi:9}



static void Test_BFu1s_Sf_BFu9i()
{
  {
    init_simple_test("BFu1s_Sf_BFu9i");
    static BFu1s_Sf_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu9i");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1s_Sf_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1s_Sf_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu9i(Test_BFu1s_Sf_BFu9i, "BFu1s_Sf_BFu9i", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu9ll  {
  unsigned short v1:1;
  ::empty v2;
  __tsu64 v3:9;
};
//SIG(1 BFu1s_Sf_BFu9ll) C1{ Fs:1 FC2{} FL:9}



static void Test_BFu1s_Sf_BFu9ll()
{
  {
    init_simple_test("BFu1s_Sf_BFu9ll");
    static BFu1s_Sf_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(BFu1s_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu9ll");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1s_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1s_Sf_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu9ll(Test_BFu1s_Sf_BFu9ll, "BFu1s_Sf_BFu9ll", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_BFu9s  {
  unsigned short v1:1;
  ::empty v2;
  unsigned short v3:9;
};
//SIG(1 BFu1s_Sf_BFu9s) C1{ Fs:1 FC2{} Fs:9}



static void Test_BFu1s_Sf_BFu9s()
{
  {
    init_simple_test("BFu1s_Sf_BFu9s");
    static BFu1s_Sf_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_BFu9s");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "BFu1s_Sf_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "BFu1s_Sf_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_BFu9s(Test_BFu1s_Sf_BFu9s, "BFu1s_Sf_BFu9s", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_C  {
  unsigned short v1:1;
  ::empty v2;
  char v3;
};
//SIG(1 BFu1s_Sf_C) C1{ Fs:1 FC2{} Fc}



static void Test_BFu1s_Sf_C()
{
  {
    init_simple_test("BFu1s_Sf_C");
    static BFu1s_Sf_C lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_C)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_C");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_C.v2");
    check_field_offset(lv, v3, 2, "BFu1s_Sf_C.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_C(Test_BFu1s_Sf_C, "BFu1s_Sf_C", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_D  {
  unsigned short v1:1;
  ::empty v2;
  double v3;
};
//SIG(1 BFu1s_Sf_D) C1{ Fs:1 FC2{} FL}



static void Test_BFu1s_Sf_D()
{
  {
    init_simple_test("BFu1s_Sf_D");
    static BFu1s_Sf_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1s_Sf_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_D");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_D.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1s_Sf_D.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_D(Test_BFu1s_Sf_D, "BFu1s_Sf_D", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_F  {
  unsigned short v1:1;
  ::empty v2;
  float v3;
};
//SIG(1 BFu1s_Sf_F) C1{ Fs:1 FC2{} Fi}



static void Test_BFu1s_Sf_F()
{
  {
    init_simple_test("BFu1s_Sf_F");
    static BFu1s_Sf_F lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_Sf_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_F");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_F.v2");
    check_field_offset(lv, v3, 4, "BFu1s_Sf_F.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_F(Test_BFu1s_Sf_F, "BFu1s_Sf_F", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_I  {
  unsigned short v1:1;
  ::empty v2;
  int v3;
};
//SIG(1 BFu1s_Sf_I) C1{ Fs:1 FC2{} Fi}



static void Test_BFu1s_Sf_I()
{
  {
    init_simple_test("BFu1s_Sf_I");
    static BFu1s_Sf_I lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_Sf_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_I");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_I.v2");
    check_field_offset(lv, v3, 4, "BFu1s_Sf_I.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_I(Test_BFu1s_Sf_I, "BFu1s_Sf_I", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_Ip  {
  unsigned short v1:1;
  ::empty v2;
  int *v3;
};
//SIG(1 BFu1s_Sf_Ip) C1{ Fs:1 FC2{} Fp}



static void Test_BFu1s_Sf_Ip()
{
  {
    init_simple_test("BFu1s_Sf_Ip");
    static BFu1s_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1s_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_Ip");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1s_Sf_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_Ip(Test_BFu1s_Sf_Ip, "BFu1s_Sf_Ip", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_L  {
  unsigned short v1:1;
  ::empty v2;
  __tsi64 v3;
};
//SIG(1 BFu1s_Sf_L) C1{ Fs:1 FC2{} FL}



static void Test_BFu1s_Sf_L()
{
  {
    init_simple_test("BFu1s_Sf_L");
    static BFu1s_Sf_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1s_Sf_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_L");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_L.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1s_Sf_L.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_L(Test_BFu1s_Sf_L, "BFu1s_Sf_L", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_S  {
  unsigned short v1:1;
  ::empty v2;
  short v3;
};
//SIG(1 BFu1s_Sf_S) C1{ Fs:1 FC2{} Fs}



static void Test_BFu1s_Sf_S()
{
  {
    init_simple_test("BFu1s_Sf_S");
    static BFu1s_Sf_S lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_S)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_S");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_S.v2");
    check_field_offset(lv, v3, 2, "BFu1s_Sf_S.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_S(Test_BFu1s_Sf_S, "BFu1s_Sf_S", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_Sf  {
  unsigned short v1:1;
  ::empty v2;
  ::empty v3;
};
//SIG(1 BFu1s_Sf_Sf) C1{ Fs:1 FC2{} FC2}



static void Test_BFu1s_Sf_Sf()
{
  {
    init_simple_test("BFu1s_Sf_Sf");
    static BFu1s_Sf_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_Sf");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu1s_Sf_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_Sf(Test_BFu1s_Sf_Sf, "BFu1s_Sf_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_Uc  {
  unsigned short v1:1;
  ::empty v2;
  unsigned char v3;
};
//SIG(1 BFu1s_Sf_Uc) C1{ Fs:1 FC2{} Fc}



static void Test_BFu1s_Sf_Uc()
{
  {
    init_simple_test("BFu1s_Sf_Uc");
    static BFu1s_Sf_Uc lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_Uc");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_Uc.v2");
    check_field_offset(lv, v3, 2, "BFu1s_Sf_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_Uc(Test_BFu1s_Sf_Uc, "BFu1s_Sf_Uc", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_Ui  {
  unsigned short v1:1;
  ::empty v2;
  unsigned int v3;
};
//SIG(1 BFu1s_Sf_Ui) C1{ Fs:1 FC2{} Fi}



static void Test_BFu1s_Sf_Ui()
{
  {
    init_simple_test("BFu1s_Sf_Ui");
    static BFu1s_Sf_Ui lv;
    check2(sizeof(lv), 8, "sizeof(BFu1s_Sf_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_Ui");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_Ui.v2");
    check_field_offset(lv, v3, 4, "BFu1s_Sf_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_Ui(Test_BFu1s_Sf_Ui, "BFu1s_Sf_Ui", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_Ul  {
  unsigned short v1:1;
  ::empty v2;
  __tsu64 v3;
};
//SIG(1 BFu1s_Sf_Ul) C1{ Fs:1 FC2{} FL}



static void Test_BFu1s_Sf_Ul()
{
  {
    init_simple_test("BFu1s_Sf_Ul");
    static BFu1s_Sf_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu1s_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_Ul");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1s_Sf_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_Ul(Test_BFu1s_Sf_Ul, "BFu1s_Sf_Ul", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_Us  {
  unsigned short v1:1;
  ::empty v2;
  unsigned short v3;
};
//SIG(1 BFu1s_Sf_Us) C1{ Fs:1 FC2{} Fs}



static void Test_BFu1s_Sf_Us()
{
  {
    init_simple_test("BFu1s_Sf_Us");
    static BFu1s_Sf_Us lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Sf_Us)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_Us");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_Us.v2");
    check_field_offset(lv, v3, 2, "BFu1s_Sf_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_Us(Test_BFu1s_Sf_Us, "BFu1s_Sf_Us", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Sf_Vp  {
  unsigned short v1:1;
  ::empty v2;
  void *v3;
};
//SIG(1 BFu1s_Sf_Vp) C1{ Fs:1 FC2{} Fp}



static void Test_BFu1s_Sf_Vp()
{
  {
    init_simple_test("BFu1s_Sf_Vp");
    static BFu1s_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BFu1s_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Sf_Vp");
    check_field_offset(lv, v2, 1, "BFu1s_Sf_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(8,4), "BFu1s_Sf_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Sf_Vp(Test_BFu1s_Sf_Vp, "BFu1s_Sf_Vp", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Uc_Sf  {
  unsigned short v1:1;
  unsigned char v2;
  ::empty v3;
};
//SIG(1 BFu1s_Uc_Sf) C1{ Fs:1 Fc FC2{}}



static void Test_BFu1s_Uc_Sf()
{
  {
    init_simple_test("BFu1s_Uc_Sf");
    static BFu1s_Uc_Sf lv;
    check2(sizeof(lv), 4, "sizeof(BFu1s_Uc_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Uc_Sf");
    check_field_offset(lv, v2, 1, "BFu1s_Uc_Sf.v2");
    check_field_offset(lv, v3, 2, "BFu1s_Uc_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Uc_Sf(Test_BFu1s_Uc_Sf, "BFu1s_Uc_Sf", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Ui_Sf  {
  unsigned short v1:1;
  unsigned int v2;
  ::empty v3;
};
//SIG(1 BFu1s_Ui_Sf) C1{ Fs:1 Fi FC2{}}



static void Test_BFu1s_Ui_Sf()
{
  {
    init_simple_test("BFu1s_Ui_Sf");
    static BFu1s_Ui_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu1s_Ui_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu1s_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu1s_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu1s_Ui_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Ui_Sf(Test_BFu1s_Ui_Sf, "BFu1s_Ui_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Ul_Sf  {
  unsigned short v1:1;
  __tsu64 v2;
  ::empty v3;
};
//SIG(1 BFu1s_Ul_Sf) C1{ Fs:1 FL FC2{}}



static void Test_BFu1s_Ul_Sf()
{
  {
    init_simple_test("BFu1s_Ul_Sf");
    static BFu1s_Ul_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu1s_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Ul_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1s_Ul_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu1s_Ul_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Ul_Sf(Test_BFu1s_Ul_Sf, "BFu1s_Ul_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Us_Sf  {
  unsigned short v1:1;
  unsigned short v2;
  ::empty v3;
};
//SIG(1 BFu1s_Us_Sf) C1{ Fs:1 Fs FC2{}}



static void Test_BFu1s_Us_Sf()
{
  {
    init_simple_test("BFu1s_Us_Sf");
    static BFu1s_Us_Sf lv;
    check2(sizeof(lv), 6, "sizeof(BFu1s_Us_Sf)");
    check2(__alignof__(lv), 2, "__alignof__(BFu1s_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Us_Sf");
    check_field_offset(lv, v2, 2, "BFu1s_Us_Sf.v2");
    check_field_offset(lv, v3, 4, "BFu1s_Us_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Us_Sf(Test_BFu1s_Us_Sf, "BFu1s_Us_Sf", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu1s_Vp_Sf  {
  unsigned short v1:1;
  void *v2;
  ::empty v3;
};
//SIG(1 BFu1s_Vp_Sf) C1{ Fs:1 Fp FC2{}}



static void Test_BFu1s_Vp_Sf()
{
  {
    init_simple_test("BFu1s_Vp_Sf");
    static BFu1s_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu1s_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu1s_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 1, 1, "BFu1s_Vp_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu1s_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu1s_Vp_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu1s_Vp_Sf(Test_BFu1s_Vp_Sf, "BFu1s_Vp_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu15i_Sf  {
  unsigned int v1:31;
  unsigned int v2:15;
  ::empty v3;
};
//SIG(1 BFu31i_BFu15i_Sf) C1{ Fi:31 Fi:15 FC2{}}



static void Test_BFu31i_BFu15i_Sf()
{
  {
    init_simple_test("BFu31i_BFu15i_Sf");
    static BFu31i_BFu15i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu15i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu31i_BFu15i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu31i_BFu15i_Sf");
    check_field_offset(lv, v3, 6, "BFu31i_BFu15i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu15i_Sf(Test_BFu31i_BFu15i_Sf, "BFu31i_BFu15i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu15ll_Sf  {
  unsigned int v1:31;
  __tsu64 v2:15;
  ::empty v3;
};
//SIG(1 BFu31i_BFu15ll_Sf) C1{ Fi:31 FL:15 FC2{}}



static void Test_BFu31i_BFu15ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu15ll_Sf");
    static BFu31i_BFu15ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, 1, "BFu31i_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, hide_ull(1LL<<14), "BFu31i_BFu15ll_Sf");
    check_field_offset(lv, v3, 6, "BFu31i_BFu15ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu15ll_Sf(Test_BFu31i_BFu15ll_Sf, "BFu31i_BFu15ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu15s_Sf  {
  unsigned int v1:31;
  unsigned short v2:15;
  ::empty v3;
};
//SIG(1 BFu31i_BFu15s_Sf) C1{ Fi:31 Fs:15 FC2{}}



static void Test_BFu31i_BFu15s_Sf()
{
  {
    init_simple_test("BFu31i_BFu15s_Sf");
    static BFu31i_BFu15s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu15s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu31i_BFu15s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu31i_BFu15s_Sf");
    check_field_offset(lv, v3, 6, "BFu31i_BFu15s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu15s_Sf(Test_BFu31i_BFu15s_Sf, "BFu31i_BFu15s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu16i_Sf  {
  unsigned int v1:31;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 BFu31i_BFu16i_Sf) C1{ Fi:31 Fi:16 FC2{}}



static void Test_BFu31i_BFu16i_Sf()
{
  {
    init_simple_test("BFu31i_BFu16i_Sf");
    static BFu31i_BFu16i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu16i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu31i_BFu16i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu31i_BFu16i_Sf");
    check_field_offset(lv, v3, 6, "BFu31i_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu16i_Sf(Test_BFu31i_BFu16i_Sf, "BFu31i_BFu16i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu16ll_Sf  {
  unsigned int v1:31;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 BFu31i_BFu16ll_Sf) C1{ Fi:31 FL:16 FC2{}}



static void Test_BFu31i_BFu16ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu16ll_Sf");
    static BFu31i_BFu16ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, 1, "BFu31i_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, hide_ull(1LL<<15), "BFu31i_BFu16ll_Sf");
    check_field_offset(lv, v3, 6, "BFu31i_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu16ll_Sf(Test_BFu31i_BFu16ll_Sf, "BFu31i_BFu16ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu16s_Sf  {
  unsigned int v1:31;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 BFu31i_BFu16s_Sf) C1{ Fi:31 Fs:16 FC2{}}



static void Test_BFu31i_BFu16s_Sf()
{
  {
    init_simple_test("BFu31i_BFu16s_Sf");
    static BFu31i_BFu16s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu16s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu31i_BFu16s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu31i_BFu16s_Sf");
    check_field_offset(lv, v3, 6, "BFu31i_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu16s_Sf(Test_BFu31i_BFu16s_Sf, "BFu31i_BFu16s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu17i_Sf  {
  unsigned int v1:31;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 BFu31i_BFu17i_Sf) C1{ Fi:31 Fi:17 FC2{}}



static void Test_BFu31i_BFu17i_Sf()
{
  {
    init_simple_test("BFu31i_BFu17i_Sf");
    static BFu31i_BFu17i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu17i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu31i_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu31i_BFu17i_Sf");
    check_field_offset(lv, v3, 7, "BFu31i_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu17i_Sf(Test_BFu31i_BFu17i_Sf, "BFu31i_BFu17i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu17ll_Sf  {
  unsigned int v1:31;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 BFu31i_BFu17ll_Sf) C1{ Fi:31 FL:17 FC2{}}



static void Test_BFu31i_BFu17ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu17ll_Sf");
    static BFu31i_BFu17ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 17, 1, "BFu31i_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 17, hide_ull(1LL<<16), "BFu31i_BFu17ll_Sf");
    check_field_offset(lv, v3, 6, "BFu31i_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu17ll_Sf(Test_BFu31i_BFu17ll_Sf, "BFu31i_BFu17ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu1c_Sf  {
  unsigned int v1:31;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 BFu31i_BFu1c_Sf) C1{ Fi:31 Fc:1 FC2{}}



static void Test_BFu31i_BFu1c_Sf()
{
  {
    init_simple_test("BFu31i_BFu1c_Sf");
    static BFu31i_BFu1c_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu1c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu1c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu31i_BFu1c_Sf");
    check_field_offset(lv, v3, 4, "BFu31i_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu1c_Sf(Test_BFu31i_BFu1c_Sf, "BFu31i_BFu1c_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu1i_Sf  {
  unsigned int v1:31;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 BFu31i_BFu1i_Sf) C1{ Fi:31 Fi:1 FC2{}}



static void Test_BFu31i_BFu1i_Sf()
{
  {
    init_simple_test("BFu31i_BFu1i_Sf");
    static BFu31i_BFu1i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu1i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu1i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu31i_BFu1i_Sf");
    check_field_offset(lv, v3, 4, "BFu31i_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu1i_Sf(Test_BFu31i_BFu1i_Sf, "BFu31i_BFu1i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu1ll_Sf  {
  unsigned int v1:31;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 BFu31i_BFu1ll_Sf) C1{ Fi:31 FL:1 FC2{}}



static void Test_BFu31i_BFu1ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu1ll_Sf");
    static BFu31i_BFu1ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu31i_BFu1ll_Sf");
    check_field_offset(lv, v3, 4, "BFu31i_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu1ll_Sf(Test_BFu31i_BFu1ll_Sf, "BFu31i_BFu1ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu1s_Sf  {
  unsigned int v1:31;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 BFu31i_BFu1s_Sf) C1{ Fi:31 Fs:1 FC2{}}



static void Test_BFu31i_BFu1s_Sf()
{
  {
    init_simple_test("BFu31i_BFu1s_Sf");
    static BFu31i_BFu1s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu1s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu1s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu31i_BFu1s_Sf");
    check_field_offset(lv, v3, 4, "BFu31i_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu1s_Sf(Test_BFu31i_BFu1s_Sf, "BFu31i_BFu1s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu31i_Sf  {
  unsigned int v1:31;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 BFu31i_BFu31i_Sf) C1{ Fi:31 Fi:31 FC2{}}



static void Test_BFu31i_BFu31i_Sf()
{
  {
    init_simple_test("BFu31i_BFu31i_Sf");
    static BFu31i_BFu31i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_BFu31i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu31i_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "BFu31i_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu31i_Sf(Test_BFu31i_BFu31i_Sf, "BFu31i_BFu31i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu31ll_Sf  {
  unsigned int v1:31;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 BFu31i_BFu31ll_Sf) C1{ Fi:31 FL:31 FC2{}}



static void Test_BFu31i_BFu31ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu31ll_Sf");
    static BFu31i_BFu31ll_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31i_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFu31i_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_ull(1LL<<30), "BFu31i_BFu31ll_Sf");
    check_field_offset(lv, v3, 8, "BFu31i_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu31ll_Sf(Test_BFu31i_BFu31ll_Sf, "BFu31i_BFu31ll_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu32i_Sf  {
  unsigned int v1:31;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 BFu31i_BFu32i_Sf) C1{ Fi:31 Fi:32 FC2{}}



static void Test_BFu31i_BFu32i_Sf()
{
  {
    init_simple_test("BFu31i_BFu32i_Sf");
    static BFu31i_BFu32i_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_BFu32i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu31i_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu31i_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu31i_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu32i_Sf(Test_BFu31i_BFu32i_Sf, "BFu31i_BFu32i_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu32ll_Sf  {
  unsigned int v1:31;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 BFu31i_BFu32ll_Sf) C1{ Fi:31 FL:32 FC2{}}



static void Test_BFu31i_BFu32ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu32ll_Sf");
    static BFu31i_BFu32ll_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31i_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, 1, "BFu31i_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, hide_ull(1LL<<31), "BFu31i_BFu32ll_Sf");
    check_field_offset(lv, v3, 8, "BFu31i_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu32ll_Sf(Test_BFu31i_BFu32ll_Sf, "BFu31i_BFu32ll_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu33_Sf  {
  unsigned int v1:31;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 BFu31i_BFu33_Sf) C1{ Fi:31 FL:33 FC2{}}



static void Test_BFu31i_BFu33_Sf()
{
  {
    init_simple_test("BFu31i_BFu33_Sf");
    static BFu31i_BFu33_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31i_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu33_Sf");
    set_bf_and_test(lv, v2, 3, 7, 33, 1, "BFu31i_BFu33_Sf");
    set_bf_and_test(lv, v2, 3, 7, 33, hide_ull(1LL<<32), "BFu31i_BFu33_Sf");
    check_field_offset(lv, v3, 8, "BFu31i_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu33_Sf(Test_BFu31i_BFu33_Sf, "BFu31i_BFu33_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu7c_Sf  {
  unsigned int v1:31;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 BFu31i_BFu7c_Sf) C1{ Fi:31 Fc:7 FC2{}}



static void Test_BFu31i_BFu7c_Sf()
{
  {
    init_simple_test("BFu31i_BFu7c_Sf");
    static BFu31i_BFu7c_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu7c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu31i_BFu7c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu31i_BFu7c_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu7c_Sf(Test_BFu31i_BFu7c_Sf, "BFu31i_BFu7c_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu7i_Sf  {
  unsigned int v1:31;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 BFu31i_BFu7i_Sf) C1{ Fi:31 Fi:7 FC2{}}



static void Test_BFu31i_BFu7i_Sf()
{
  {
    init_simple_test("BFu31i_BFu7i_Sf");
    static BFu31i_BFu7i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu7i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu31i_BFu7i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu31i_BFu7i_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu7i_Sf(Test_BFu31i_BFu7i_Sf, "BFu31i_BFu7i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu7ll_Sf  {
  unsigned int v1:31;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 BFu31i_BFu7ll_Sf) C1{ Fi:31 FL:7 FC2{}}



static void Test_BFu31i_BFu7ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu7ll_Sf");
    static BFu31i_BFu7ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "BFu31i_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "BFu31i_BFu7ll_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu7ll_Sf(Test_BFu31i_BFu7ll_Sf, "BFu31i_BFu7ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu7s_Sf  {
  unsigned int v1:31;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 BFu31i_BFu7s_Sf) C1{ Fi:31 Fs:7 FC2{}}



static void Test_BFu31i_BFu7s_Sf()
{
  {
    init_simple_test("BFu31i_BFu7s_Sf");
    static BFu31i_BFu7s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu7s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu31i_BFu7s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu31i_BFu7s_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu7s_Sf(Test_BFu31i_BFu7s_Sf, "BFu31i_BFu7s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu8c_Sf  {
  unsigned int v1:31;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 BFu31i_BFu8c_Sf) C1{ Fi:31 Fc:8 FC2{}}



static void Test_BFu31i_BFu8c_Sf()
{
  {
    init_simple_test("BFu31i_BFu8c_Sf");
    static BFu31i_BFu8c_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu8c_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu31i_BFu8c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu31i_BFu8c_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu8c_Sf(Test_BFu31i_BFu8c_Sf, "BFu31i_BFu8c_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu8i_Sf  {
  unsigned int v1:31;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 BFu31i_BFu8i_Sf) C1{ Fi:31 Fi:8 FC2{}}



static void Test_BFu31i_BFu8i_Sf()
{
  {
    init_simple_test("BFu31i_BFu8i_Sf");
    static BFu31i_BFu8i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu8i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu31i_BFu8i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu31i_BFu8i_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu8i_Sf(Test_BFu31i_BFu8i_Sf, "BFu31i_BFu8i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu8ll_Sf  {
  unsigned int v1:31;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 BFu31i_BFu8ll_Sf) C1{ Fi:31 FL:8 FC2{}}



static void Test_BFu31i_BFu8ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu8ll_Sf");
    static BFu31i_BFu8ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "BFu31i_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "BFu31i_BFu8ll_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu8ll_Sf(Test_BFu31i_BFu8ll_Sf, "BFu31i_BFu8ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu8s_Sf  {
  unsigned int v1:31;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 BFu31i_BFu8s_Sf) C1{ Fi:31 Fs:8 FC2{}}



static void Test_BFu31i_BFu8s_Sf()
{
  {
    init_simple_test("BFu31i_BFu8s_Sf");
    static BFu31i_BFu8s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu8s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu31i_BFu8s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu31i_BFu8s_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu8s_Sf(Test_BFu31i_BFu8s_Sf, "BFu31i_BFu8s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu9i_Sf  {
  unsigned int v1:31;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 BFu31i_BFu9i_Sf) C1{ Fi:31 Fi:9 FC2{}}



static void Test_BFu31i_BFu9i_Sf()
{
  {
    init_simple_test("BFu31i_BFu9i_Sf");
    static BFu31i_BFu9i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu9i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu31i_BFu9i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu31i_BFu9i_Sf");
    check_field_offset(lv, v3, 6, "BFu31i_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu9i_Sf(Test_BFu31i_BFu9i_Sf, "BFu31i_BFu9i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu9ll_Sf  {
  unsigned int v1:31;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 BFu31i_BFu9ll_Sf) C1{ Fi:31 FL:9 FC2{}}



static void Test_BFu31i_BFu9ll_Sf()
{
  {
    init_simple_test("BFu31i_BFu9ll_Sf");
    static BFu31i_BFu9ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "BFu31i_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "BFu31i_BFu9ll_Sf");
    check_field_offset(lv, v3, 5, "BFu31i_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu9ll_Sf(Test_BFu31i_BFu9ll_Sf, "BFu31i_BFu9ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_BFu9s_Sf  {
  unsigned int v1:31;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 BFu31i_BFu9s_Sf) C1{ Fi:31 Fs:9 FC2{}}



static void Test_BFu31i_BFu9s_Sf()
{
  {
    init_simple_test("BFu31i_BFu9s_Sf");
    static BFu31i_BFu9s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_BFu9s_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu31i_BFu9s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu31i_BFu9s_Sf");
    check_field_offset(lv, v3, 6, "BFu31i_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_BFu9s_Sf(Test_BFu31i_BFu9s_Sf, "BFu31i_BFu9s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_C_Sf  {
  unsigned int v1:31;
  char v2;
  ::empty v3;
};
//SIG(1 BFu31i_C_Sf) C1{ Fi:31 Fc FC2{}}



static void Test_BFu31i_C_Sf()
{
  {
    init_simple_test("BFu31i_C_Sf");
    static BFu31i_C_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_C_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_C_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_C_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu31i_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_C_Sf(Test_BFu31i_C_Sf, "BFu31i_C_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_D_Sf  {
  unsigned int v1:31;
  double v2;
  ::empty v3;
};
//SIG(1 BFu31i_D_Sf) C1{ Fi:31 FL FC2{}}



static void Test_BFu31i_D_Sf()
{
  {
    init_simple_test("BFu31i_D_Sf");
    static BFu31i_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu31i_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_D_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu31i_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu31i_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_D_Sf(Test_BFu31i_D_Sf, "BFu31i_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_F_Sf  {
  unsigned int v1:31;
  float v2;
  ::empty v3;
};
//SIG(1 BFu31i_F_Sf) C1{ Fi:31 Fi FC2{}}



static void Test_BFu31i_F_Sf()
{
  {
    init_simple_test("BFu31i_F_Sf");
    static BFu31i_F_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_F_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_F_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu31i_F_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_F_Sf(Test_BFu31i_F_Sf, "BFu31i_F_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_I_Sf  {
  unsigned int v1:31;
  int v2;
  ::empty v3;
};
//SIG(1 BFu31i_I_Sf) C1{ Fi:31 Fi FC2{}}



static void Test_BFu31i_I_Sf()
{
  {
    init_simple_test("BFu31i_I_Sf");
    static BFu31i_I_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_I_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_I_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu31i_I_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_I_Sf(Test_BFu31i_I_Sf, "BFu31i_I_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Ip_Sf  {
  unsigned int v1:31;
  int *v2;
  ::empty v3;
};
//SIG(1 BFu31i_Ip_Sf) C1{ Fi:31 Fp FC2{}}



static void Test_BFu31i_Ip_Sf()
{
  {
    init_simple_test("BFu31i_Ip_Sf");
    static BFu31i_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu31i_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Ip_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu31i_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu31i_Ip_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Ip_Sf(Test_BFu31i_Ip_Sf, "BFu31i_Ip_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_L_Sf  {
  unsigned int v1:31;
  __tsi64 v2;
  ::empty v3;
};
//SIG(1 BFu31i_L_Sf) C1{ Fi:31 FL FC2{}}



static void Test_BFu31i_L_Sf()
{
  {
    init_simple_test("BFu31i_L_Sf");
    static BFu31i_L_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu31i_L_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_L_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu31i_L_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu31i_L_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_L_Sf(Test_BFu31i_L_Sf, "BFu31i_L_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_S_Sf  {
  unsigned int v1:31;
  short v2;
  ::empty v3;
};
//SIG(1 BFu31i_S_Sf) C1{ Fi:31 Fs FC2{}}



static void Test_BFu31i_S_Sf()
{
  {
    init_simple_test("BFu31i_S_Sf");
    static BFu31i_S_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_S_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_S_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_S_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu31i_S_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_S_Sf(Test_BFu31i_S_Sf, "BFu31i_S_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf  {
  unsigned int v1:31;
  ::empty v2;
};
//SIG(1 BFu31i_Sf) C1{ Fi:31 FC2{}}



static void Test_BFu31i_Sf()
{
  {
    init_simple_test("BFu31i_Sf");
    static BFu31i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_Sf.v2");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf(Test_BFu31i_Sf, "BFu31i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu15i  {
  unsigned int v1:31;
  ::empty v2;
  unsigned int v3:15;
};
//SIG(1 BFu31i_Sf_BFu15i) C1{ Fi:31 FC2{} Fi:15}



static void Test_BFu31i_Sf_BFu15i()
{
  {
    init_simple_test("BFu31i_Sf_BFu15i");
    static BFu31i_Sf_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu15i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "BFu31i_Sf_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "BFu31i_Sf_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu15i(Test_BFu31i_Sf_BFu15i, "BFu31i_Sf_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu15ll  {
  unsigned int v1:31;
  ::empty v2;
  __tsu64 v3:15;
};
//SIG(1 BFu31i_Sf_BFu15ll) C1{ Fi:31 FC2{} FL:15}



static void Test_BFu31i_Sf_BFu15ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu15ll");
    static BFu31i_Sf_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu15ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "BFu31i_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "BFu31i_Sf_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu15ll(Test_BFu31i_Sf_BFu15ll, "BFu31i_Sf_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu15s  {
  unsigned int v1:31;
  ::empty v2;
  unsigned short v3:15;
};
//SIG(1 BFu31i_Sf_BFu15s) C1{ Fi:31 FC2{} Fs:15}



static void Test_BFu31i_Sf_BFu15s()
{
  {
    init_simple_test("BFu31i_Sf_BFu15s");
    static BFu31i_Sf_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu15s");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu31i_Sf_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu31i_Sf_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu15s(Test_BFu31i_Sf_BFu15s, "BFu31i_Sf_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu16i  {
  unsigned int v1:31;
  ::empty v2;
  unsigned int v3:16;
};
//SIG(1 BFu31i_Sf_BFu16i) C1{ Fi:31 FC2{} Fi:16}



static void Test_BFu31i_Sf_BFu16i()
{
  {
    init_simple_test("BFu31i_Sf_BFu16i");
    static BFu31i_Sf_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu16i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "BFu31i_Sf_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "BFu31i_Sf_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu16i(Test_BFu31i_Sf_BFu16i, "BFu31i_Sf_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu16ll  {
  unsigned int v1:31;
  ::empty v2;
  __tsu64 v3:16;
};
//SIG(1 BFu31i_Sf_BFu16ll) C1{ Fi:31 FC2{} FL:16}



static void Test_BFu31i_Sf_BFu16ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu16ll");
    static BFu31i_Sf_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu16ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "BFu31i_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "BFu31i_Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu16ll(Test_BFu31i_Sf_BFu16ll, "BFu31i_Sf_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu16s  {
  unsigned int v1:31;
  ::empty v2;
  unsigned short v3:16;
};
//SIG(1 BFu31i_Sf_BFu16s) C1{ Fi:31 FC2{} Fs:16}



static void Test_BFu31i_Sf_BFu16s()
{
  {
    init_simple_test("BFu31i_Sf_BFu16s");
    static BFu31i_Sf_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu16s");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu31i_Sf_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu31i_Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu16s(Test_BFu31i_Sf_BFu16s, "BFu31i_Sf_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu17i  {
  unsigned int v1:31;
  ::empty v2;
  unsigned int v3:17;
};
//SIG(1 BFu31i_Sf_BFu17i) C1{ Fi:31 FC2{} Fi:17}



static void Test_BFu31i_Sf_BFu17i()
{
  {
    init_simple_test("BFu31i_Sf_BFu17i");
    static BFu31i_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu17i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "BFu31i_Sf_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "BFu31i_Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu17i(Test_BFu31i_Sf_BFu17i, "BFu31i_Sf_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu17ll  {
  unsigned int v1:31;
  ::empty v2;
  __tsu64 v3:17;
};
//SIG(1 BFu31i_Sf_BFu17ll) C1{ Fi:31 FC2{} FL:17}



static void Test_BFu31i_Sf_BFu17ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu17ll");
    static BFu31i_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu17ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "BFu31i_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "BFu31i_Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu17ll(Test_BFu31i_Sf_BFu17ll, "BFu31i_Sf_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu1c  {
  unsigned int v1:31;
  ::empty v2;
  unsigned char v3:1;
};
//SIG(1 BFu31i_Sf_BFu1c) C1{ Fi:31 FC2{} Fc:1}



static void Test_BFu31i_Sf_BFu1c()
{
  {
    init_simple_test("BFu31i_Sf_BFu1c");
    static BFu31i_Sf_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu1c");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu31i_Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu1c(Test_BFu31i_Sf_BFu1c, "BFu31i_Sf_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu1i  {
  unsigned int v1:31;
  ::empty v2;
  unsigned int v3:1;
};
//SIG(1 BFu31i_Sf_BFu1i) C1{ Fi:31 FC2{} Fi:1}



static void Test_BFu31i_Sf_BFu1i()
{
  {
    init_simple_test("BFu31i_Sf_BFu1i");
    static BFu31i_Sf_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu1i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu31i_Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu1i(Test_BFu31i_Sf_BFu1i, "BFu31i_Sf_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu1ll  {
  unsigned int v1:31;
  ::empty v2;
  __tsu64 v3:1;
};
//SIG(1 BFu31i_Sf_BFu1ll) C1{ Fi:31 FC2{} FL:1}



static void Test_BFu31i_Sf_BFu1ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu1ll");
    static BFu31i_Sf_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu1ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu31i_Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu1ll(Test_BFu31i_Sf_BFu1ll, "BFu31i_Sf_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu1s  {
  unsigned int v1:31;
  ::empty v2;
  unsigned short v3:1;
};
//SIG(1 BFu31i_Sf_BFu1s) C1{ Fi:31 FC2{} Fs:1}



static void Test_BFu31i_Sf_BFu1s()
{
  {
    init_simple_test("BFu31i_Sf_BFu1s");
    static BFu31i_Sf_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu1s");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu31i_Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu1s(Test_BFu31i_Sf_BFu1s, "BFu31i_Sf_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu31i  {
  unsigned int v1:31;
  ::empty v2;
  unsigned int v3:31;
};
//SIG(1 BFu31i_Sf_BFu31i) C1{ Fi:31 FC2{} Fi:31}



static void Test_BFu31i_Sf_BFu31i()
{
  {
    init_simple_test("BFu31i_Sf_BFu31i");
    static BFu31i_Sf_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_Sf_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu31i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu31i_Sf_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu31i(Test_BFu31i_Sf_BFu31i, "BFu31i_Sf_BFu31i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu31ll  {
  unsigned int v1:31;
  ::empty v2;
  __tsu64 v3:31;
};
//SIG(1 BFu31i_Sf_BFu31ll) C1{ Fi:31 FC2{} FL:31}



static void Test_BFu31i_Sf_BFu31ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu31ll");
    static BFu31i_Sf_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31i_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu31ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, 1, "BFu31i_Sf_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu31ll(Test_BFu31i_Sf_BFu31ll, "BFu31i_Sf_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu32i  {
  unsigned int v1:31;
  ::empty v2;
  unsigned int v3:32;
};
//SIG(1 BFu31i_Sf_BFu32i) C1{ Fi:31 FC2{} Fi:32}



static void Test_BFu31i_Sf_BFu32i()
{
  {
    init_simple_test("BFu31i_Sf_BFu32i");
    static BFu31i_Sf_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_Sf_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu32i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu31i_Sf_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu31i_Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu32i(Test_BFu31i_Sf_BFu32i, "BFu31i_Sf_BFu32i", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu32ll  {
  unsigned int v1:31;
  ::empty v2;
  __tsu64 v3:32;
};
//SIG(1 BFu31i_Sf_BFu32ll) C1{ Fi:31 FC2{} FL:32}



static void Test_BFu31i_Sf_BFu32ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu32ll");
    static BFu31i_Sf_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31i_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu32ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, 1, "BFu31i_Sf_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, hide_ull(1LL<<31), "BFu31i_Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu32ll(Test_BFu31i_Sf_BFu32ll, "BFu31i_Sf_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu33  {
  unsigned int v1:31;
  ::empty v2;
  __tsu64 v3:33;
};
//SIG(1 BFu31i_Sf_BFu33) C1{ Fi:31 FC2{} FL:33}



static void Test_BFu31i_Sf_BFu33()
{
  {
    init_simple_test("BFu31i_Sf_BFu33");
    static BFu31i_Sf_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31i_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu33");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, 1, "BFu31i_Sf_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, hide_ull(1LL<<32), "BFu31i_Sf_BFu33");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu33(Test_BFu31i_Sf_BFu33, "BFu31i_Sf_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu7c  {
  unsigned int v1:31;
  ::empty v2;
  unsigned char v3:7;
};
//SIG(1 BFu31i_Sf_BFu7c) C1{ Fi:31 FC2{} Fc:7}



static void Test_BFu31i_Sf_BFu7c()
{
  {
    init_simple_test("BFu31i_Sf_BFu7c");
    static BFu31i_Sf_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu7c");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu31i_Sf_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu31i_Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu7c(Test_BFu31i_Sf_BFu7c, "BFu31i_Sf_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu7i  {
  unsigned int v1:31;
  ::empty v2;
  unsigned int v3:7;
};
//SIG(1 BFu31i_Sf_BFu7i) C1{ Fi:31 FC2{} Fi:7}



static void Test_BFu31i_Sf_BFu7i()
{
  {
    init_simple_test("BFu31i_Sf_BFu7i");
    static BFu31i_Sf_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu7i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu31i_Sf_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu31i_Sf_BFu7i");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu7i(Test_BFu31i_Sf_BFu7i, "BFu31i_Sf_BFu7i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu7ll  {
  unsigned int v1:31;
  ::empty v2;
  __tsu64 v3:7;
};
//SIG(1 BFu31i_Sf_BFu7ll) C1{ Fi:31 FC2{} FL:7}



static void Test_BFu31i_Sf_BFu7ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu7ll");
    static BFu31i_Sf_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu7ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu31i_Sf_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu31i_Sf_BFu7ll");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu7ll(Test_BFu31i_Sf_BFu7ll, "BFu31i_Sf_BFu7ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu7s  {
  unsigned int v1:31;
  ::empty v2;
  unsigned short v3:7;
};
//SIG(1 BFu31i_Sf_BFu7s) C1{ Fi:31 FC2{} Fs:7}



static void Test_BFu31i_Sf_BFu7s()
{
  {
    init_simple_test("BFu31i_Sf_BFu7s");
    static BFu31i_Sf_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu7s");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu31i_Sf_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu31i_Sf_BFu7s");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu7s(Test_BFu31i_Sf_BFu7s, "BFu31i_Sf_BFu7s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu8c  {
  unsigned int v1:31;
  ::empty v2;
  unsigned char v3:8;
};
//SIG(1 BFu31i_Sf_BFu8c) C1{ Fi:31 FC2{} Fc:8}



static void Test_BFu31i_Sf_BFu8c()
{
  {
    init_simple_test("BFu31i_Sf_BFu8c");
    static BFu31i_Sf_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu8c");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "BFu31i_Sf_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "BFu31i_Sf_BFu8c");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu8c(Test_BFu31i_Sf_BFu8c, "BFu31i_Sf_BFu8c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu8i  {
  unsigned int v1:31;
  ::empty v2;
  unsigned int v3:8;
};
//SIG(1 BFu31i_Sf_BFu8i) C1{ Fi:31 FC2{} Fi:8}



static void Test_BFu31i_Sf_BFu8i()
{
  {
    init_simple_test("BFu31i_Sf_BFu8i");
    static BFu31i_Sf_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu8i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "BFu31i_Sf_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "BFu31i_Sf_BFu8i");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu8i(Test_BFu31i_Sf_BFu8i, "BFu31i_Sf_BFu8i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu8ll  {
  unsigned int v1:31;
  ::empty v2;
  __tsu64 v3:8;
};
//SIG(1 BFu31i_Sf_BFu8ll) C1{ Fi:31 FC2{} FL:8}



static void Test_BFu31i_Sf_BFu8ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu8ll");
    static BFu31i_Sf_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu8ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "BFu31i_Sf_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "BFu31i_Sf_BFu8ll");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu8ll(Test_BFu31i_Sf_BFu8ll, "BFu31i_Sf_BFu8ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu8s  {
  unsigned int v1:31;
  ::empty v2;
  unsigned short v3:8;
};
//SIG(1 BFu31i_Sf_BFu8s) C1{ Fi:31 FC2{} Fs:8}



static void Test_BFu31i_Sf_BFu8s()
{
  {
    init_simple_test("BFu31i_Sf_BFu8s");
    static BFu31i_Sf_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu8s");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "BFu31i_Sf_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "BFu31i_Sf_BFu8s");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu8s(Test_BFu31i_Sf_BFu8s, "BFu31i_Sf_BFu8s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu9i  {
  unsigned int v1:31;
  ::empty v2;
  unsigned int v3:9;
};
//SIG(1 BFu31i_Sf_BFu9i) C1{ Fi:31 FC2{} Fi:9}



static void Test_BFu31i_Sf_BFu9i()
{
  {
    init_simple_test("BFu31i_Sf_BFu9i");
    static BFu31i_Sf_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu9i");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "BFu31i_Sf_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "BFu31i_Sf_BFu9i");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu9i(Test_BFu31i_Sf_BFu9i, "BFu31i_Sf_BFu9i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu9ll  {
  unsigned int v1:31;
  ::empty v2;
  __tsu64 v3:9;
};
//SIG(1 BFu31i_Sf_BFu9ll) C1{ Fi:31 FC2{} FL:9}



static void Test_BFu31i_Sf_BFu9ll()
{
  {
    init_simple_test("BFu31i_Sf_BFu9ll");
    static BFu31i_Sf_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu9ll");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "BFu31i_Sf_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "BFu31i_Sf_BFu9ll");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu9ll(Test_BFu31i_Sf_BFu9ll, "BFu31i_Sf_BFu9ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_BFu9s  {
  unsigned int v1:31;
  ::empty v2;
  unsigned short v3:9;
};
//SIG(1 BFu31i_Sf_BFu9s) C1{ Fi:31 FC2{} Fs:9}



static void Test_BFu31i_Sf_BFu9s()
{
  {
    init_simple_test("BFu31i_Sf_BFu9s");
    static BFu31i_Sf_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_BFu9s");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "BFu31i_Sf_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "BFu31i_Sf_BFu9s");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_BFu9s(Test_BFu31i_Sf_BFu9s, "BFu31i_Sf_BFu9s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_C  {
  unsigned int v1:31;
  ::empty v2;
  char v3;
};
//SIG(1 BFu31i_Sf_C) C1{ Fi:31 FC2{} Fc}



static void Test_BFu31i_Sf_C()
{
  {
    init_simple_test("BFu31i_Sf_C");
    static BFu31i_Sf_C lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_C)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_C)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_C");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_C");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_C.v2");
    check_field_offset(lv, v3, 5, "BFu31i_Sf_C.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_C(Test_BFu31i_Sf_C, "BFu31i_Sf_C", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_D  {
  unsigned int v1:31;
  ::empty v2;
  double v3;
};
//SIG(1 BFu31i_Sf_D) C1{ Fi:31 FC2{} FL}



static void Test_BFu31i_Sf_D()
{
  {
    init_simple_test("BFu31i_Sf_D");
    static BFu31i_Sf_D lv;
    check2(sizeof(lv), 16, "sizeof(BFu31i_Sf_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_D)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_D");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_D");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_D.v2");
    check_field_offset(lv, v3, 8, "BFu31i_Sf_D.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_D(Test_BFu31i_Sf_D, "BFu31i_Sf_D", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_F  {
  unsigned int v1:31;
  ::empty v2;
  float v3;
};
//SIG(1 BFu31i_Sf_F) C1{ Fi:31 FC2{} Fi}



static void Test_BFu31i_Sf_F()
{
  {
    init_simple_test("BFu31i_Sf_F");
    static BFu31i_Sf_F lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_Sf_F)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_F)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_F");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_F");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_F.v2");
    check_field_offset(lv, v3, 8, "BFu31i_Sf_F.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_F(Test_BFu31i_Sf_F, "BFu31i_Sf_F", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_I  {
  unsigned int v1:31;
  ::empty v2;
  int v3;
};
//SIG(1 BFu31i_Sf_I) C1{ Fi:31 FC2{} Fi}



static void Test_BFu31i_Sf_I()
{
  {
    init_simple_test("BFu31i_Sf_I");
    static BFu31i_Sf_I lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_Sf_I)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_I)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_I");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_I");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_I.v2");
    check_field_offset(lv, v3, 8, "BFu31i_Sf_I.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_I(Test_BFu31i_Sf_I, "BFu31i_Sf_I", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_Ip  {
  unsigned int v1:31;
  ::empty v2;
  int *v3;
};
//SIG(1 BFu31i_Sf_Ip) C1{ Fi:31 FC2{} Fp}



static void Test_BFu31i_Sf_Ip()
{
  {
    init_simple_test("BFu31i_Sf_Ip");
    static BFu31i_Sf_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31i_Sf_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_Ip");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_Ip");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_Ip.v2");
    check_field_offset(lv, v3, 8, "BFu31i_Sf_Ip.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_Ip(Test_BFu31i_Sf_Ip, "BFu31i_Sf_Ip", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_L  {
  unsigned int v1:31;
  ::empty v2;
  __tsi64 v3;
};
//SIG(1 BFu31i_Sf_L) C1{ Fi:31 FC2{} FL}



static void Test_BFu31i_Sf_L()
{
  {
    init_simple_test("BFu31i_Sf_L");
    static BFu31i_Sf_L lv;
    check2(sizeof(lv), 16, "sizeof(BFu31i_Sf_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_L)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_L");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_L");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_L.v2");
    check_field_offset(lv, v3, 8, "BFu31i_Sf_L.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_L(Test_BFu31i_Sf_L, "BFu31i_Sf_L", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_S  {
  unsigned int v1:31;
  ::empty v2;
  short v3;
};
//SIG(1 BFu31i_Sf_S) C1{ Fi:31 FC2{} Fs}



static void Test_BFu31i_Sf_S()
{
  {
    init_simple_test("BFu31i_Sf_S");
    static BFu31i_Sf_S lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_S)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_S)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_S");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_S");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_S.v2");
    check_field_offset(lv, v3, 6, "BFu31i_Sf_S.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_S(Test_BFu31i_Sf_S, "BFu31i_Sf_S", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_Sf  {
  unsigned int v1:31;
  ::empty v2;
  ::empty v3;
};
//SIG(1 BFu31i_Sf_Sf) C1{ Fi:31 FC2{} FC2}



static void Test_BFu31i_Sf_Sf()
{
  {
    init_simple_test("BFu31i_Sf_Sf");
    static BFu31i_Sf_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu31i_Sf_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_Sf(Test_BFu31i_Sf_Sf, "BFu31i_Sf_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_Uc  {
  unsigned int v1:31;
  ::empty v2;
  unsigned char v3;
};
//SIG(1 BFu31i_Sf_Uc) C1{ Fi:31 FC2{} Fc}



static void Test_BFu31i_Sf_Uc()
{
  {
    init_simple_test("BFu31i_Sf_Uc");
    static BFu31i_Sf_Uc lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_Uc");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_Uc");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_Uc.v2");
    check_field_offset(lv, v3, 5, "BFu31i_Sf_Uc.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_Uc(Test_BFu31i_Sf_Uc, "BFu31i_Sf_Uc", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_Ui  {
  unsigned int v1:31;
  ::empty v2;
  unsigned int v3;
};
//SIG(1 BFu31i_Sf_Ui) C1{ Fi:31 FC2{} Fi}



static void Test_BFu31i_Sf_Ui()
{
  {
    init_simple_test("BFu31i_Sf_Ui");
    static BFu31i_Sf_Ui lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_Sf_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_Ui");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_Ui");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_Ui.v2");
    check_field_offset(lv, v3, 8, "BFu31i_Sf_Ui.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_Ui(Test_BFu31i_Sf_Ui, "BFu31i_Sf_Ui", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_Ul  {
  unsigned int v1:31;
  ::empty v2;
  __tsu64 v3;
};
//SIG(1 BFu31i_Sf_Ul) C1{ Fi:31 FC2{} FL}



static void Test_BFu31i_Sf_Ul()
{
  {
    init_simple_test("BFu31i_Sf_Ul");
    static BFu31i_Sf_Ul lv;
    check2(sizeof(lv), 16, "sizeof(BFu31i_Sf_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_Ul");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_Ul");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_Ul.v2");
    check_field_offset(lv, v3, 8, "BFu31i_Sf_Ul.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_Ul(Test_BFu31i_Sf_Ul, "BFu31i_Sf_Ul", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_Us  {
  unsigned int v1:31;
  ::empty v2;
  unsigned short v3;
};
//SIG(1 BFu31i_Sf_Us) C1{ Fi:31 FC2{} Fs}



static void Test_BFu31i_Sf_Us()
{
  {
    init_simple_test("BFu31i_Sf_Us");
    static BFu31i_Sf_Us lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Sf_Us)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Sf_Us)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_Us");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_Us");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_Us.v2");
    check_field_offset(lv, v3, 6, "BFu31i_Sf_Us.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_Us(Test_BFu31i_Sf_Us, "BFu31i_Sf_Us", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Sf_Vp  {
  unsigned int v1:31;
  ::empty v2;
  void *v3;
};
//SIG(1 BFu31i_Sf_Vp) C1{ Fi:31 FC2{} Fp}



static void Test_BFu31i_Sf_Vp()
{
  {
    init_simple_test("BFu31i_Sf_Vp");
    static BFu31i_Sf_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31i_Sf_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Sf_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Sf_Vp");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Sf_Vp");
    check_field_offset(lv, v2, 4, "BFu31i_Sf_Vp.v2");
    check_field_offset(lv, v3, 8, "BFu31i_Sf_Vp.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Sf_Vp(Test_BFu31i_Sf_Vp, "BFu31i_Sf_Vp", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Uc_Sf  {
  unsigned int v1:31;
  unsigned char v2;
  ::empty v3;
};
//SIG(1 BFu31i_Uc_Sf) C1{ Fi:31 Fc FC2{}}



static void Test_BFu31i_Uc_Sf()
{
  {
    init_simple_test("BFu31i_Uc_Sf");
    static BFu31i_Uc_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Uc_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Uc_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Uc_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Uc_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_Uc_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu31i_Uc_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Uc_Sf(Test_BFu31i_Uc_Sf, "BFu31i_Uc_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Ui_Sf  {
  unsigned int v1:31;
  unsigned int v2;
  ::empty v3;
};
//SIG(1 BFu31i_Ui_Sf) C1{ Fi:31 Fi FC2{}}



static void Test_BFu31i_Ui_Sf()
{
  {
    init_simple_test("BFu31i_Ui_Sf");
    static BFu31i_Ui_Sf lv;
    check2(sizeof(lv), 12, "sizeof(BFu31i_Ui_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Ui_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Ui_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Ui_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_Ui_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu31i_Ui_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Ui_Sf(Test_BFu31i_Ui_Sf, "BFu31i_Ui_Sf", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Ul_Sf  {
  unsigned int v1:31;
  __tsu64 v2;
  ::empty v3;
};
//SIG(1 BFu31i_Ul_Sf) C1{ Fi:31 FL FC2{}}



static void Test_BFu31i_Ul_Sf()
{
  {
    init_simple_test("BFu31i_Ul_Sf");
    static BFu31i_Ul_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu31i_Ul_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Ul_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Ul_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Ul_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu31i_Ul_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu31i_Ul_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Ul_Sf(Test_BFu31i_Ul_Sf, "BFu31i_Ul_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Us_Sf  {
  unsigned int v1:31;
  unsigned short v2;
  ::empty v3;
};
//SIG(1 BFu31i_Us_Sf) C1{ Fi:31 Fs FC2{}}



static void Test_BFu31i_Us_Sf()
{
  {
    init_simple_test("BFu31i_Us_Sf");
    static BFu31i_Us_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31i_Us_Sf)");
    check2(__alignof__(lv), 4, "__alignof__(BFu31i_Us_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Us_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Us_Sf");
    check_field_offset(lv, v2, 4, "BFu31i_Us_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu31i_Us_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Us_Sf(Test_BFu31i_Us_Sf, "BFu31i_Us_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31i_Vp_Sf  {
  unsigned int v1:31;
  void *v2;
  ::empty v3;
};
//SIG(1 BFu31i_Vp_Sf) C1{ Fi:31 Fp FC2{}}



static void Test_BFu31i_Vp_Sf()
{
  {
    init_simple_test("BFu31i_Vp_Sf");
    static BFu31i_Vp_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu31i_Vp_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31i_Vp_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31i_Vp_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31i_Vp_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu31i_Vp_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu31i_Vp_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31i_Vp_Sf(Test_BFu31i_Vp_Sf, "BFu31i_Vp_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu15i_Sf  {
  __tsu64 v1:31;
  unsigned int v2:15;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu15i_Sf) C1{ FL:31 Fi:15 FC2{}}



static void Test_BFu31ll_BFu15i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu15i_Sf");
    static BFu31ll_BFu15i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu15i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu15i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu15i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu31ll_BFu15i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu31ll_BFu15i_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu15i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu15i_Sf(Test_BFu31ll_BFu15i_Sf, "BFu31ll_BFu15i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu15ll_Sf  {
  __tsu64 v1:31;
  __tsu64 v2:15;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu15ll_Sf) C1{ FL:31 FL:15 FC2{}}



static void Test_BFu31ll_BFu15ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu15ll_Sf");
    static BFu31ll_BFu15ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu15ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu15ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu15ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, 1, "BFu31ll_BFu15ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 15, hide_ull(1LL<<14), "BFu31ll_BFu15ll_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu15ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu15ll_Sf(Test_BFu31ll_BFu15ll_Sf, "BFu31ll_BFu15ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu15s_Sf  {
  __tsu64 v1:31;
  unsigned short v2:15;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu15s_Sf) C1{ FL:31 Fs:15 FC2{}}



static void Test_BFu31ll_BFu15s_Sf()
{
  {
    init_simple_test("BFu31ll_BFu15s_Sf");
    static BFu31ll_BFu15s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu15s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu15s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu15s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "BFu31ll_BFu15s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "BFu31ll_BFu15s_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu15s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu15s_Sf(Test_BFu31ll_BFu15s_Sf, "BFu31ll_BFu15s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu16i_Sf  {
  __tsu64 v1:31;
  unsigned int v2:16;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu16i_Sf) C1{ FL:31 Fi:16 FC2{}}



static void Test_BFu31ll_BFu16i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu16i_Sf");
    static BFu31ll_BFu16i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu16i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu16i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu16i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu31ll_BFu16i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu31ll_BFu16i_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu16i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu16i_Sf(Test_BFu31ll_BFu16i_Sf, "BFu31ll_BFu16i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu16ll_Sf  {
  __tsu64 v1:31;
  __tsu64 v2:16;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu16ll_Sf) C1{ FL:31 FL:16 FC2{}}



static void Test_BFu31ll_BFu16ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu16ll_Sf");
    static BFu31ll_BFu16ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu16ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu16ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu16ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, 1, "BFu31ll_BFu16ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 16, hide_ull(1LL<<15), "BFu31ll_BFu16ll_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu16ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu16ll_Sf(Test_BFu31ll_BFu16ll_Sf, "BFu31ll_BFu16ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu16s_Sf  {
  __tsu64 v1:31;
  unsigned short v2:16;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu16s_Sf) C1{ FL:31 Fs:16 FC2{}}



static void Test_BFu31ll_BFu16s_Sf()
{
  {
    init_simple_test("BFu31ll_BFu16s_Sf");
    static BFu31ll_BFu16s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu16s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu16s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu16s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "BFu31ll_BFu16s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "BFu31ll_BFu16s_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu16s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu16s_Sf(Test_BFu31ll_BFu16s_Sf, "BFu31ll_BFu16s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu17i_Sf  {
  __tsu64 v1:31;
  unsigned int v2:17;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu17i_Sf) C1{ FL:31 Fi:17 FC2{}}



static void Test_BFu31ll_BFu17i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu17i_Sf");
    static BFu31ll_BFu17i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu17i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu17i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu17i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "BFu31ll_BFu17i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "BFu31ll_BFu17i_Sf");
    check_field_offset(lv, v3, 7, "BFu31ll_BFu17i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu17i_Sf(Test_BFu31ll_BFu17i_Sf, "BFu31ll_BFu17i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu17ll_Sf  {
  __tsu64 v1:31;
  __tsu64 v2:17;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu17ll_Sf) C1{ FL:31 FL:17 FC2{}}



static void Test_BFu31ll_BFu17ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu17ll_Sf");
    static BFu31ll_BFu17ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu17ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu17ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu17ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 17, 1, "BFu31ll_BFu17ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 17, hide_ull(1LL<<16), "BFu31ll_BFu17ll_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu17ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu17ll_Sf(Test_BFu31ll_BFu17ll_Sf, "BFu31ll_BFu17ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu1c_Sf  {
  __tsu64 v1:31;
  unsigned char v2:1;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu1c_Sf) C1{ FL:31 Fc:1 FC2{}}



static void Test_BFu31ll_BFu1c_Sf()
{
  {
    init_simple_test("BFu31ll_BFu1c_Sf");
    static BFu31ll_BFu1c_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu1c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu1c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu1c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu1c_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu31ll_BFu1c_Sf");
    check_field_offset(lv, v3, 4, "BFu31ll_BFu1c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu1c_Sf(Test_BFu31ll_BFu1c_Sf, "BFu31ll_BFu1c_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu1i_Sf  {
  __tsu64 v1:31;
  unsigned int v2:1;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu1i_Sf) C1{ FL:31 Fi:1 FC2{}}



static void Test_BFu31ll_BFu1i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu1i_Sf");
    static BFu31ll_BFu1i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu1i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu1i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu1i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu1i_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu31ll_BFu1i_Sf");
    check_field_offset(lv, v3, 4, "BFu31ll_BFu1i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu1i_Sf(Test_BFu31ll_BFu1i_Sf, "BFu31ll_BFu1i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu1ll_Sf  {
  __tsu64 v1:31;
  __tsu64 v2:1;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu1ll_Sf) C1{ FL:31 FL:1 FC2{}}



static void Test_BFu31ll_BFu1ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu1ll_Sf");
    static BFu31ll_BFu1ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu1ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu1ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu1ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu1ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu31ll_BFu1ll_Sf");
    check_field_offset(lv, v3, 4, "BFu31ll_BFu1ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu1ll_Sf(Test_BFu31ll_BFu1ll_Sf, "BFu31ll_BFu1ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu1s_Sf  {
  __tsu64 v1:31;
  unsigned short v2:1;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu1s_Sf) C1{ FL:31 Fs:1 FC2{}}



static void Test_BFu31ll_BFu1s_Sf()
{
  {
    init_simple_test("BFu31ll_BFu1s_Sf");
    static BFu31ll_BFu1s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu1s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu1s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu1s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu1s_Sf");
    set_bf_and_test(lv, v2, 3, 7, 1, 1, "BFu31ll_BFu1s_Sf");
    check_field_offset(lv, v3, 4, "BFu31ll_BFu1s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu1s_Sf(Test_BFu31ll_BFu1s_Sf, "BFu31ll_BFu1s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu31i_Sf  {
  __tsu64 v1:31;
  unsigned int v2:31;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu31i_Sf) C1{ FL:31 Fi:31 FC2{}}



static void Test_BFu31ll_BFu31i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu31i_Sf");
    static BFu31ll_BFu31i_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31ll_BFu31i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu31i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu31i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "BFu31ll_BFu31i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu31i_Sf");
    check_field_offset(lv, v3, 8, "BFu31ll_BFu31i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu31i_Sf(Test_BFu31ll_BFu31i_Sf, "BFu31ll_BFu31i_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu31ll_Sf  {
  __tsu64 v1:31;
  __tsu64 v2:31;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu31ll_Sf) C1{ FL:31 FL:31 FC2{}}



static void Test_BFu31ll_BFu31ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu31ll_Sf");
    static BFu31ll_BFu31ll_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31ll_BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 31, 1, "BFu31ll_BFu31ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 31, hide_ull(1LL<<30), "BFu31ll_BFu31ll_Sf");
    check_field_offset(lv, v3, 8, "BFu31ll_BFu31ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu31ll_Sf(Test_BFu31ll_BFu31ll_Sf, "BFu31ll_BFu31ll_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu32i_Sf  {
  __tsu64 v1:31;
  unsigned int v2:32;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu32i_Sf) C1{ FL:31 Fi:32 FC2{}}



static void Test_BFu31ll_BFu32i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu32i_Sf");
    static BFu31ll_BFu32i_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31ll_BFu32i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu32i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu32i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "BFu31ll_BFu32i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "BFu31ll_BFu32i_Sf");
    check_field_offset(lv, v3, 8, "BFu31ll_BFu32i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu32i_Sf(Test_BFu31ll_BFu32i_Sf, "BFu31ll_BFu32i_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu32ll_Sf  {
  __tsu64 v1:31;
  __tsu64 v2:32;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu32ll_Sf) C1{ FL:31 FL:32 FC2{}}



static void Test_BFu31ll_BFu32ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu32ll_Sf");
    static BFu31ll_BFu32ll_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31ll_BFu32ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu32ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu32ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, 1, "BFu31ll_BFu32ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 32, hide_ull(1LL<<31), "BFu31ll_BFu32ll_Sf");
    check_field_offset(lv, v3, 8, "BFu31ll_BFu32ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu32ll_Sf(Test_BFu31ll_BFu32ll_Sf, "BFu31ll_BFu32ll_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu33_Sf  {
  __tsu64 v1:31;
  __tsu64 v2:33;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu33_Sf) C1{ FL:31 FL:33 FC2{}}



static void Test_BFu31ll_BFu33_Sf()
{
  {
    init_simple_test("BFu31ll_BFu33_Sf");
    static BFu31ll_BFu33_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31ll_BFu33_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu33_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu33_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 3, 7, 33, 1, "BFu31ll_BFu33_Sf");
    set_bf_and_test(lv, v2, 3, 7, 33, hide_ull(1LL<<32), "BFu31ll_BFu33_Sf");
    check_field_offset(lv, v3, 8, "BFu31ll_BFu33_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu33_Sf(Test_BFu31ll_BFu33_Sf, "BFu31ll_BFu33_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu7c_Sf  {
  __tsu64 v1:31;
  unsigned char v2:7;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu7c_Sf) C1{ FL:31 Fc:7 FC2{}}



static void Test_BFu31ll_BFu7c_Sf()
{
  {
    init_simple_test("BFu31ll_BFu7c_Sf");
    static BFu31ll_BFu7c_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu7c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu7c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu7c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu31ll_BFu7c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu31ll_BFu7c_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu7c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu7c_Sf(Test_BFu31ll_BFu7c_Sf, "BFu31ll_BFu7c_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu7i_Sf  {
  __tsu64 v1:31;
  unsigned int v2:7;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu7i_Sf) C1{ FL:31 Fi:7 FC2{}}



static void Test_BFu31ll_BFu7i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu7i_Sf");
    static BFu31ll_BFu7i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu7i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu7i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu7i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu31ll_BFu7i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu31ll_BFu7i_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu7i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu7i_Sf(Test_BFu31ll_BFu7i_Sf, "BFu31ll_BFu7i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu7ll_Sf  {
  __tsu64 v1:31;
  __tsu64 v2:7;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu7ll_Sf) C1{ FL:31 FL:7 FC2{}}



static void Test_BFu31ll_BFu7ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu7ll_Sf");
    static BFu31ll_BFu7ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu7ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu7ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu7ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, 1, "BFu31ll_BFu7ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 7, hide_ull(1LL<<6), "BFu31ll_BFu7ll_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu7ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu7ll_Sf(Test_BFu31ll_BFu7ll_Sf, "BFu31ll_BFu7ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu7s_Sf  {
  __tsu64 v1:31;
  unsigned short v2:7;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu7s_Sf) C1{ FL:31 Fs:7 FC2{}}



static void Test_BFu31ll_BFu7s_Sf()
{
  {
    init_simple_test("BFu31ll_BFu7s_Sf");
    static BFu31ll_BFu7s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu7s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu7s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu7s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "BFu31ll_BFu7s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "BFu31ll_BFu7s_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu7s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu7s_Sf(Test_BFu31ll_BFu7s_Sf, "BFu31ll_BFu7s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu8c_Sf  {
  __tsu64 v1:31;
  unsigned char v2:8;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu8c_Sf) C1{ FL:31 Fc:8 FC2{}}



static void Test_BFu31ll_BFu8c_Sf()
{
  {
    init_simple_test("BFu31ll_BFu8c_Sf");
    static BFu31ll_BFu8c_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu8c_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu8c_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu8c_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu31ll_BFu8c_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu31ll_BFu8c_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu8c_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu8c_Sf(Test_BFu31ll_BFu8c_Sf, "BFu31ll_BFu8c_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu8i_Sf  {
  __tsu64 v1:31;
  unsigned int v2:8;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu8i_Sf) C1{ FL:31 Fi:8 FC2{}}



static void Test_BFu31ll_BFu8i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu8i_Sf");
    static BFu31ll_BFu8i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu8i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu8i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu8i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu31ll_BFu8i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu31ll_BFu8i_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu8i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu8i_Sf(Test_BFu31ll_BFu8i_Sf, "BFu31ll_BFu8i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu8ll_Sf  {
  __tsu64 v1:31;
  __tsu64 v2:8;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu8ll_Sf) C1{ FL:31 FL:8 FC2{}}



static void Test_BFu31ll_BFu8ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu8ll_Sf");
    static BFu31ll_BFu8ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu8ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu8ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu8ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, 1, "BFu31ll_BFu8ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 8, hide_ull(1LL<<7), "BFu31ll_BFu8ll_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu8ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu8ll_Sf(Test_BFu31ll_BFu8ll_Sf, "BFu31ll_BFu8ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu8s_Sf  {
  __tsu64 v1:31;
  unsigned short v2:8;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu8s_Sf) C1{ FL:31 Fs:8 FC2{}}



static void Test_BFu31ll_BFu8s_Sf()
{
  {
    init_simple_test("BFu31ll_BFu8s_Sf");
    static BFu31ll_BFu8s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu8s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu8s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu8s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "BFu31ll_BFu8s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "BFu31ll_BFu8s_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu8s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu8s_Sf(Test_BFu31ll_BFu8s_Sf, "BFu31ll_BFu8s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu9i_Sf  {
  __tsu64 v1:31;
  unsigned int v2:9;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu9i_Sf) C1{ FL:31 Fi:9 FC2{}}



static void Test_BFu31ll_BFu9i_Sf()
{
  {
    init_simple_test("BFu31ll_BFu9i_Sf");
    static BFu31ll_BFu9i_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu9i_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu9i_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu9i_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu31ll_BFu9i_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu31ll_BFu9i_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu9i_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu9i_Sf(Test_BFu31ll_BFu9i_Sf, "BFu31ll_BFu9i_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu9ll_Sf  {
  __tsu64 v1:31;
  __tsu64 v2:9;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu9ll_Sf) C1{ FL:31 FL:9 FC2{}}



static void Test_BFu31ll_BFu9ll_Sf()
{
  {
    init_simple_test("BFu31ll_BFu9ll_Sf");
    static BFu31ll_BFu9ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu9ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu9ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu9ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, 1, "BFu31ll_BFu9ll_Sf");
    set_bf_and_test(lv, v2, 3, 7, 9, hide_ull(1LL<<8), "BFu31ll_BFu9ll_Sf");
    check_field_offset(lv, v3, 5, "BFu31ll_BFu9ll_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu9ll_Sf(Test_BFu31ll_BFu9ll_Sf, "BFu31ll_BFu9ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_BFu9s_Sf  {
  __tsu64 v1:31;
  unsigned short v2:9;
  ::empty v3;
};
//SIG(1 BFu31ll_BFu9s_Sf) C1{ FL:31 Fs:9 FC2{}}



static void Test_BFu31ll_BFu9s_Sf()
{
  {
    init_simple_test("BFu31ll_BFu9s_Sf");
    static BFu31ll_BFu9s_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_BFu9s_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_BFu9s_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_BFu9s_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "BFu31ll_BFu9s_Sf");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "BFu31ll_BFu9s_Sf");
    check_field_offset(lv, v3, 6, "BFu31ll_BFu9s_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_BFu9s_Sf(Test_BFu31ll_BFu9s_Sf, "BFu31ll_BFu9s_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_C_Sf  {
  __tsu64 v1:31;
  char v2;
  ::empty v3;
};
//SIG(1 BFu31ll_C_Sf) C1{ FL:31 Fc FC2{}}



static void Test_BFu31ll_C_Sf()
{
  {
    init_simple_test("BFu31ll_C_Sf");
    static BFu31ll_C_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_C_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_C_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_C_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_C_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_C_Sf.v2");
    check_field_offset(lv, v3, 5, "BFu31ll_C_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_C_Sf(Test_BFu31ll_C_Sf, "BFu31ll_C_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_D_Sf  {
  __tsu64 v1:31;
  double v2;
  ::empty v3;
};
//SIG(1 BFu31ll_D_Sf) C1{ FL:31 FL FC2{}}



static void Test_BFu31ll_D_Sf()
{
  {
    init_simple_test("BFu31ll_D_Sf");
    static BFu31ll_D_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu31ll_D_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_D_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_D_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_D_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu31ll_D_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu31ll_D_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_D_Sf(Test_BFu31ll_D_Sf, "BFu31ll_D_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_F_Sf  {
  __tsu64 v1:31;
  float v2;
  ::empty v3;
};
//SIG(1 BFu31ll_F_Sf) C1{ FL:31 Fi FC2{}}



static void Test_BFu31ll_F_Sf()
{
  {
    init_simple_test("BFu31ll_F_Sf");
    static BFu31ll_F_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31ll_F_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_F_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_F_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_F_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_F_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu31ll_F_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_F_Sf(Test_BFu31ll_F_Sf, "BFu31ll_F_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_I_Sf  {
  __tsu64 v1:31;
  int v2;
  ::empty v3;
};
//SIG(1 BFu31ll_I_Sf) C1{ FL:31 Fi FC2{}}



static void Test_BFu31ll_I_Sf()
{
  {
    init_simple_test("BFu31ll_I_Sf");
    static BFu31ll_I_Sf lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31ll_I_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_I_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_I_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_I_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_I_Sf.v2");
    check_field_offset(lv, v3, 8, "BFu31ll_I_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_I_Sf(Test_BFu31ll_I_Sf, "BFu31ll_I_Sf", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Ip_Sf  {
  __tsu64 v1:31;
  int *v2;
  ::empty v3;
};
//SIG(1 BFu31ll_Ip_Sf) C1{ FL:31 Fp FC2{}}



static void Test_BFu31ll_Ip_Sf()
{
  {
    init_simple_test("BFu31ll_Ip_Sf");
    static BFu31ll_Ip_Sf lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(BFu31ll_Ip_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Ip_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Ip_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Ip_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu31ll_Ip_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "BFu31ll_Ip_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_Ip_Sf(Test_BFu31ll_Ip_Sf, "BFu31ll_Ip_Sf", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_L_Sf  {
  __tsu64 v1:31;
  __tsi64 v2;
  ::empty v3;
};
//SIG(1 BFu31ll_L_Sf) C1{ FL:31 FL FC2{}}



static void Test_BFu31ll_L_Sf()
{
  {
    init_simple_test("BFu31ll_L_Sf");
    static BFu31ll_L_Sf lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(BFu31ll_L_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_L_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_L_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_L_Sf");
    check_field_offset(lv, v2, ABISELECT(8,4), "BFu31ll_L_Sf.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "BFu31ll_L_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_L_Sf(Test_BFu31ll_L_Sf, "BFu31ll_L_Sf", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_S_Sf  {
  __tsu64 v1:31;
  short v2;
  ::empty v3;
};
//SIG(1 BFu31ll_S_Sf) C1{ FL:31 Fs FC2{}}



static void Test_BFu31ll_S_Sf()
{
  {
    init_simple_test("BFu31ll_S_Sf");
    static BFu31ll_S_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_S_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_S_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_S_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_S_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_S_Sf.v2");
    check_field_offset(lv, v3, 6, "BFu31ll_S_Sf.v3");
  }
}
static Arrange_To_Call_Me vBFu31ll_S_Sf(Test_BFu31ll_S_Sf, "BFu31ll_S_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf  {
  __tsu64 v1:31;
  ::empty v2;
};
//SIG(1 BFu31ll_Sf) C1{ FL:31 FC2{}}



static void Test_BFu31ll_Sf()
{
  {
    init_simple_test("BFu31ll_Sf");
    static BFu31ll_Sf lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf.v2");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf(Test_BFu31ll_Sf, "BFu31ll_Sf", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu15i  {
  __tsu64 v1:31;
  ::empty v2;
  unsigned int v3:15;
};
//SIG(1 BFu31ll_Sf_BFu15i) C1{ FL:31 FC2{} Fi:15}



static void Test_BFu31ll_Sf_BFu15i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu15i");
    static BFu31ll_Sf_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu15i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "BFu31ll_Sf_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "BFu31ll_Sf_BFu15i");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu15i(Test_BFu31ll_Sf_BFu15i, "BFu31ll_Sf_BFu15i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu15ll  {
  __tsu64 v1:31;
  ::empty v2;
  __tsu64 v3:15;
};
//SIG(1 BFu31ll_Sf_BFu15ll) C1{ FL:31 FC2{} FL:15}



static void Test_BFu31ll_Sf_BFu15ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu15ll");
    static BFu31ll_Sf_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu15ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "BFu31ll_Sf_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "BFu31ll_Sf_BFu15ll");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu15ll(Test_BFu31ll_Sf_BFu15ll, "BFu31ll_Sf_BFu15ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu15s  {
  __tsu64 v1:31;
  ::empty v2;
  unsigned short v3:15;
};
//SIG(1 BFu31ll_Sf_BFu15s) C1{ FL:31 FC2{} Fs:15}



static void Test_BFu31ll_Sf_BFu15s()
{
  {
    init_simple_test("BFu31ll_Sf_BFu15s");
    static BFu31ll_Sf_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu15s");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "BFu31ll_Sf_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "BFu31ll_Sf_BFu15s");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu15s(Test_BFu31ll_Sf_BFu15s, "BFu31ll_Sf_BFu15s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu16i  {
  __tsu64 v1:31;
  ::empty v2;
  unsigned int v3:16;
};
//SIG(1 BFu31ll_Sf_BFu16i) C1{ FL:31 FC2{} Fi:16}



static void Test_BFu31ll_Sf_BFu16i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu16i");
    static BFu31ll_Sf_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu16i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "BFu31ll_Sf_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "BFu31ll_Sf_BFu16i");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu16i(Test_BFu31ll_Sf_BFu16i, "BFu31ll_Sf_BFu16i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu16ll  {
  __tsu64 v1:31;
  ::empty v2;
  __tsu64 v3:16;
};
//SIG(1 BFu31ll_Sf_BFu16ll) C1{ FL:31 FC2{} FL:16}



static void Test_BFu31ll_Sf_BFu16ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu16ll");
    static BFu31ll_Sf_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu16ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "BFu31ll_Sf_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "BFu31ll_Sf_BFu16ll");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu16ll(Test_BFu31ll_Sf_BFu16ll, "BFu31ll_Sf_BFu16ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu16s  {
  __tsu64 v1:31;
  ::empty v2;
  unsigned short v3:16;
};
//SIG(1 BFu31ll_Sf_BFu16s) C1{ FL:31 FC2{} Fs:16}



static void Test_BFu31ll_Sf_BFu16s()
{
  {
    init_simple_test("BFu31ll_Sf_BFu16s");
    static BFu31ll_Sf_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu16s");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "BFu31ll_Sf_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "BFu31ll_Sf_BFu16s");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu16s(Test_BFu31ll_Sf_BFu16s, "BFu31ll_Sf_BFu16s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu17i  {
  __tsu64 v1:31;
  ::empty v2;
  unsigned int v3:17;
};
//SIG(1 BFu31ll_Sf_BFu17i) C1{ FL:31 FC2{} Fi:17}



static void Test_BFu31ll_Sf_BFu17i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu17i");
    static BFu31ll_Sf_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu17i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "BFu31ll_Sf_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "BFu31ll_Sf_BFu17i");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu17i(Test_BFu31ll_Sf_BFu17i, "BFu31ll_Sf_BFu17i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu17ll  {
  __tsu64 v1:31;
  ::empty v2;
  __tsu64 v3:17;
};
//SIG(1 BFu31ll_Sf_BFu17ll) C1{ FL:31 FC2{} FL:17}



static void Test_BFu31ll_Sf_BFu17ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu17ll");
    static BFu31ll_Sf_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu17ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "BFu31ll_Sf_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "BFu31ll_Sf_BFu17ll");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu17ll(Test_BFu31ll_Sf_BFu17ll, "BFu31ll_Sf_BFu17ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu1c  {
  __tsu64 v1:31;
  ::empty v2;
  unsigned char v3:1;
};
//SIG(1 BFu31ll_Sf_BFu1c) C1{ FL:31 FC2{} Fc:1}



static void Test_BFu31ll_Sf_BFu1c()
{
  {
    init_simple_test("BFu31ll_Sf_BFu1c");
    static BFu31ll_Sf_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu1c");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu31ll_Sf_BFu1c");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu1c(Test_BFu31ll_Sf_BFu1c, "BFu31ll_Sf_BFu1c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu1i  {
  __tsu64 v1:31;
  ::empty v2;
  unsigned int v3:1;
};
//SIG(1 BFu31ll_Sf_BFu1i) C1{ FL:31 FC2{} Fi:1}



static void Test_BFu31ll_Sf_BFu1i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu1i");
    static BFu31ll_Sf_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu1i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu31ll_Sf_BFu1i");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu1i(Test_BFu31ll_Sf_BFu1i, "BFu31ll_Sf_BFu1i", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu1ll  {
  __tsu64 v1:31;
  ::empty v2;
  __tsu64 v3:1;
};
//SIG(1 BFu31ll_Sf_BFu1ll) C1{ FL:31 FC2{} FL:1}



static void Test_BFu31ll_Sf_BFu1ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu1ll");
    static BFu31ll_Sf_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu1ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu31ll_Sf_BFu1ll");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu1ll(Test_BFu31ll_Sf_BFu1ll, "BFu31ll_Sf_BFu1ll", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu1s  {
  __tsu64 v1:31;
  ::empty v2;
  unsigned short v3:1;
};
//SIG(1 BFu31ll_Sf_BFu1s) C1{ FL:31 FC2{} Fs:1}



static void Test_BFu31ll_Sf_BFu1s()
{
  {
    init_simple_test("BFu31ll_Sf_BFu1s");
    static BFu31ll_Sf_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu1s");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "BFu31ll_Sf_BFu1s");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu1s(Test_BFu31ll_Sf_BFu1s, "BFu31ll_Sf_BFu1s", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu31i  {
  __tsu64 v1:31;
  ::empty v2;
  unsigned int v3:31;
};
//SIG(1 BFu31ll_Sf_BFu31i) C1{ FL:31 FC2{} Fi:31}



static void Test_BFu31ll_Sf_BFu31i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu31i");
    static BFu31ll_Sf_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31ll_Sf_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu31i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "BFu31ll_Sf_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu31i");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu31i(Test_BFu31ll_Sf_BFu31i, "BFu31ll_Sf_BFu31i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu31ll  {
  __tsu64 v1:31;
  ::empty v2;
  __tsu64 v3:31;
};
//SIG(1 BFu31ll_Sf_BFu31ll) C1{ FL:31 FC2{} FL:31}



static void Test_BFu31ll_Sf_BFu31ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu31ll");
    static BFu31ll_Sf_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31ll_Sf_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu31ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, 1, "BFu31ll_Sf_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu31ll");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu31ll(Test_BFu31ll_Sf_BFu31ll, "BFu31ll_Sf_BFu31ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu32i  {
  __tsu64 v1:31;
  ::empty v2;
  unsigned int v3:32;
};
//SIG(1 BFu31ll_Sf_BFu32i) C1{ FL:31 FC2{} Fi:32}



static void Test_BFu31ll_Sf_BFu32i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu32i");
    static BFu31ll_Sf_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31ll_Sf_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu32i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "BFu31ll_Sf_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "BFu31ll_Sf_BFu32i");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu32i(Test_BFu31ll_Sf_BFu32i, "BFu31ll_Sf_BFu32i", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu32ll  {
  __tsu64 v1:31;
  ::empty v2;
  __tsu64 v3:32;
};
//SIG(1 BFu31ll_Sf_BFu32ll) C1{ FL:31 FC2{} FL:32}



static void Test_BFu31ll_Sf_BFu32ll()
{
  {
    init_simple_test("BFu31ll_Sf_BFu32ll");
    static BFu31ll_Sf_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31ll_Sf_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu32ll");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, 1, "BFu31ll_Sf_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 32, hide_ull(1LL<<31), "BFu31ll_Sf_BFu32ll");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu32ll(Test_BFu31ll_Sf_BFu32ll, "BFu31ll_Sf_BFu32ll", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu33  {
  __tsu64 v1:31;
  ::empty v2;
  __tsu64 v3:33;
};
//SIG(1 BFu31ll_Sf_BFu33) C1{ FL:31 FC2{} FL:33}



static void Test_BFu31ll_Sf_BFu33()
{
  {
    init_simple_test("BFu31ll_Sf_BFu33");
    static BFu31ll_Sf_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(BFu31ll_Sf_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu33");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, 1, "BFu31ll_Sf_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), 0, 33, hide_ull(1LL<<32), "BFu31ll_Sf_BFu33");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu33(Test_BFu31ll_Sf_BFu33, "BFu31ll_Sf_BFu33", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu7c  {
  __tsu64 v1:31;
  ::empty v2;
  unsigned char v3:7;
};
//SIG(1 BFu31ll_Sf_BFu7c) C1{ FL:31 FC2{} Fc:7}



static void Test_BFu31ll_Sf_BFu7c()
{
  {
    init_simple_test("BFu31ll_Sf_BFu7c");
    static BFu31ll_Sf_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu7c");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu31ll_Sf_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu31ll_Sf_BFu7c");
  }
}
static Arrange_To_Call_Me vBFu31ll_Sf_BFu7c(Test_BFu31ll_Sf_BFu7c, "BFu31ll_Sf_BFu7c", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BFu31ll_Sf_BFu7i  {
  __tsu64 v1:31;
  ::empty v2;
  unsigned int v3:7;
};
//SIG(1 BFu31ll_Sf_BFu7i) C1{ FL:31 FC2{} Fi:7}



static void Test_BFu31ll_Sf_BFu7i()
{
  {
    init_simple_test("BFu31ll_Sf_BFu7i");
    static BFu31ll_Sf_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(BFu31ll_Sf_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BFu31ll_Sf_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 31, 1, "BFu31ll_Sf_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 31, hide_ull(1LL<<30), "BFu31ll_Sf_BFu7i");
    check_field_offset(lv, v2, 4, "BFu31ll_Sf_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "BFu31ll_Sf_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "BFu31ll_Sf_BFu7i");
  }
}
static Ar